#!/usr/bin/env python

import visvis as vv
import numpy as np
app = vv.use()
vv.clf()

# create volume
vol = vv.aVolume(size=64)

# set labels
vv.xlabel('x axis')
vv.ylabel('y axis')
vv.zlabel('z axis')

# show
t = vv.volshow(vol, renderStyle='mip')
# try the differtent render styles, for examample 
# "t.renderStyle='iso'" or "t.renderStyle='ray'"
# If the drawing hangs, your video drived decided to render in software mode.
# This is unfortunately (as far as I know) not possible to detect. 
# It might help if your data is shaped a power of 2.

# Get axes and set camera to orthographic mode (with a field of view of 70)
a = vv.gca()
a.camera.fov = 45

# Create colormap editor wibject.
vv.ColormapEditor(a)

# Start app
app.Run()
