var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { getSizeChannel, POSITION_SCALE_CHANNELS } from '../channel';
import { isFieldOrDatumDef } from '../channeldef';
import * as log from '../log';
import { isUnitSpec } from '../spec/unit';
import { isEmpty } from '../util';
export class RangeStepNormalizer {
    constructor() {
        this.name = 'RangeStep';
    }
    hasMatchingType(spec) {
        var _a;
        if (isUnitSpec(spec) && spec.encoding) {
            for (const channel of POSITION_SCALE_CHANNELS) {
                const def = spec.encoding[channel];
                if (def && isFieldOrDatumDef(def)) {
                    if ((_a = def === null || def === void 0 ? void 0 : def.scale) === null || _a === void 0 ? void 0 : _a['rangeStep']) {
                        return true;
                    }
                }
            }
        }
        return false;
    }
    run(spec) {
        var _a;
        const sizeMixins = {};
        let encoding = Object.assign({}, spec.encoding);
        for (const channel of POSITION_SCALE_CHANNELS) {
            const sizeType = getSizeChannel(channel);
            const def = encoding[channel];
            if (def && isFieldOrDatumDef(def)) {
                if ((_a = def === null || def === void 0 ? void 0 : def.scale) === null || _a === void 0 ? void 0 : _a['rangeStep']) {
                    const { scale } = def, defWithoutScale = __rest(def, ["scale"]);
                    const _b = scale, { rangeStep } = _b, scaleWithoutRangeStep = __rest(_b, ["rangeStep"]);
                    sizeMixins[sizeType] = { step: scale['rangeStep'] };
                    log.warn(log.message.RANGE_STEP_DEPRECATED);
                    encoding = Object.assign(Object.assign({}, encoding), { [channel]: Object.assign(Object.assign({}, defWithoutScale), (isEmpty(scaleWithoutRangeStep) ? {} : { scale: scaleWithoutRangeStep })) });
                }
            }
        }
        return Object.assign(Object.assign(Object.assign({}, sizeMixins), spec), { encoding });
    }
}
//# sourceMappingURL=rangestep.js.map