import { signalRefOrValue } from './compile/common';
import { keys } from './util';
import { isSignalRef } from './vega.schema';
export function isExprRef(o) {
    return o && !!o['expr'];
}
export function isExprOrSignalRef(o) {
    return isExprRef(o) || isSignalRef(o);
}
export function replaceExprRefInIndex(index) {
    const props = keys(index || {});
    const newIndex = {};
    for (const prop of props) {
        newIndex[prop] = signalRefOrValue(index[prop]);
    }
    return newIndex;
}
//# sourceMappingURL=expr.js.map