define(["jquery","base/js/events"], function(__WEBPACK_EXTERNAL_MODULE_201__, __WEBPACK_EXTERNAL_MODULE_202__) { return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	var embed = __webpack_require__(1);
	var $ = __webpack_require__(201);
	var events = __webpack_require__(202);
	
	function javascriptIndex(selector, outputs) {
	  // Return the index in the output array of the JS repr of this viz
	  for (var i = 0; i < outputs.length; i++) {
	    var item = outputs[i];
	    if (item.metadata['jupyter-vega'] === selector &&
	        item.data['application/javascript'] !== undefined) {
	      return i;
	    }
	  }
	  return -1;
	}
	
	function imageIndex(selector, outputs) {
	  // Return the index in the output array of the PNG repr of this viz
	  for (var i = 0; i < outputs.length; i++) {
	    var item = outputs[i];
	    if (item.metadata['jupyter-vega'] === selector &&
	        item.data['image/png'] !== undefined) {
	      return i;
	    }
	  }
	  return -1;
	}
	
	function render(selector, spec, type, output_area) {
	  var embedSpec = {
	    mode: type,
	    spec: spec
	  };
	
	  // Find the indices of this visualizations JS and PNG
	  // representation.
	  var imgIndex = imageIndex(selector, output_area.outputs);
	  var jsIndex = javascriptIndex(selector, output_area.outputs);
	
	  // If we have already rendered a static image, don't render
	  // the JS version or append a new PNG version
	  if (imgIndex >- 1 && jsIndex >- 1 && imgIndex === (jsIndex+1)) {
	    return;
	  }
	
	  // Never been rendered, so render JS and append the PNG to the
	  // outputs for the cell
	  var el = $.find(selector);
	  embed(el[0], embedSpec, function(error, result) {
	    var imageData = result.view.toImageURL();
	    if (output_area!==undefined) {
	      var output = {
	          data: {
	            'image/png': imageData.split(',')[1]
	          },
	          metadata: {'jupyter-vega': selector},
	          output_type: 'display_data'
	      };
	      // This appends the PNG output, but doesn't render it this time
	      // as the JS version will be rendered already.
	      output_area.outputs.push(output);
	    }
	  });
	}
	
	exports.render = render;


/***/ },
/* 1 */
/***/ function(module, exports, __webpack_require__) {

	var d3 = __webpack_require__(2),
	    vg = __webpack_require__(3),
	    vl = __webpack_require__(161),
	    parameter = __webpack_require__(199),
	    post = __webpack_require__(200);
	
	var config = {
	  // URL for loading specs into editor
	  editor_url: 'http://vega.github.io/vega-editor/',
	
	  // HTML to inject within view source head element
	  source_header: '',
	
	  // HTML to inject before view source closing body tag
	  source_footer: ''
	};
	
	var MODES = {
	  'vega':      'vega',
	  'vega-lite': 'vega-lite'
	};
	
	var PREPROCESSOR = {
	  'vega':      function(vgjson) { return vgjson; },
	  'vega-lite': function(vljson) { return vl.compile(vljson).spec; }
	};
	
	function load(url, arg, el, callback) {
	  vg.util.load({url: url}, function(err, data) {
	    if (err || !data) {
	      console.error(err || ('No data found at ' + url));
	    } else {
	      // marshal embedding spec and restart
	      var opt = !arg ? JSON.parse(data) : vg.util.extend({source: data}, arg);
	      embed(el, opt, callback);
	    }
	  });
	}
	
	// Embed a Vega visualization component in a web page.
	// el: DOM element in which to place component (DOM node or CSS selector)
	// opt: Embedding specification (parsed JSON or URL string)
	// callback: invoked with the generated Vega View instance
	function embed(el, opt, callback) {
	  var cb = callback || function(){},
	      params = [], source, spec, mode;
	
	  try {
	    if (vg.util.isString(opt)) {
	      return load(opt, null, el, callback);
	    } else if (opt.source) {
	      source = opt.source;
	      spec = JSON.parse(source);
	    } else if (opt.spec) {
	      spec = opt.spec;
	      source = JSON.stringify(spec, null, 2);
	    } else if (opt.url) {
	      return load(opt.url, opt, el, callback);
	    } else {
	      spec = opt;
	      source = JSON.stringify(spec, null, 2);
	      opt = {spec: spec, actions: false};
	    }
	    mode = MODES[opt.mode] || MODES.vega;
	    spec = PREPROCESSOR[mode](spec);
	
	    // ensure container div has class 'vega-embed'
	    var div = d3.select(el)
	      .classed('vega-embed', true)
	      .html(''); // clear container
	
	    // handle parameters
	    if (opt.parameters) {
	      var elp = opt.parameter_el ? d3.select(opt.parameter_el) : div;
	      var pdiv = elp.append('div')
	        .attr('class', 'vega-params');
	      params = opt.parameters.map(function(p) {
	        return parameter.init(pdiv, p, spec);
	      });
	    }
	  } catch (err) { cb(err); }
	
	  vg.parse.spec(spec, function(error, chart) {
	    if (error) { cb(error); return; }
	    try {
	      var renderer = opt.renderer || 'canvas',
	          actions  = opt.actions || {};
	
	      var view = chart({
	        el: el,
	        data: opt.data || undefined,
	        renderer: renderer
	      });
	
	      if (opt.actions !== false) {
	        // add child div to house action links
	        var ctrl = div.append('div')
	          .attr('class', 'vega-actions');
	
	        // add 'Export' action
	        if (actions.export !== false) {
	          var ext = (renderer==='canvas' ? 'png' : 'svg');
	          ctrl.append('a')
	            .text('Export as ' + ext.toUpperCase())
	            .attr('href', '#')
	            .attr('target', '_blank')
	            .attr('download', (spec.name || 'vega') + '.' + ext)
	            .on('mousedown', function() {
	              this.href = view.toImageURL(ext);
	              d3.event.preventDefault();
	            });
	        }
	
	        // add 'View Source' action
	        if (actions.source !== false) {
	          ctrl.append('a')
	            .text('View Source')
	            .attr('href', '#')
	            .on('click', function() {
	              viewSource(source);
	              d3.event.preventDefault();
	            });
	        }
	
	        // add 'Open in Vega Editor' action
	        if (actions.editor !== false) {
	          ctrl.append('a')
	            .text('Open in Vega Editor')
	            .attr('href', '#')
	            .on('click', function() {
	              post(window, embed.config.editor_url, {spec: source, mode: mode});
	              d3.event.preventDefault();
	            });
	        }
	      }
	
	      // bind all parameter elements
	      params.forEach(function(p) { parameter.bind(p, view); });
	
	      // initialize and return visualization
	      view.update();
	      cb(null, {view: view, spec: spec});
	    } catch (err) { cb(err); }
	  });
	}
	
	function viewSource(source) {
	  var header = '<html><head>' + config.source_header + '</head>' + '<body><pre><code class="json">';
	  var footer = '</code></pre>' + config.source_footer + '</body></html>';
	  var win = window.open('');
	  win.document.write(header + source + footer);
	  win.document.title = 'Vega JSON Source';
	}
	
	// make config externally visible
	embed.config = config;
	
	module.exports = embed;


/***/ },
/* 2 */
/***/ function(module, exports, __webpack_require__) {

	var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_RESULT__;!function() {
	  var d3 = {
	    version: "3.5.17"
	  };
	  var d3_arraySlice = [].slice, d3_array = function(list) {
	    return d3_arraySlice.call(list);
	  };
	  var d3_document = this.document;
	  function d3_documentElement(node) {
	    return node && (node.ownerDocument || node.document || node).documentElement;
	  }
	  function d3_window(node) {
	    return node && (node.ownerDocument && node.ownerDocument.defaultView || node.document && node || node.defaultView);
	  }
	  if (d3_document) {
	    try {
	      d3_array(d3_document.documentElement.childNodes)[0].nodeType;
	    } catch (e) {
	      d3_array = function(list) {
	        var i = list.length, array = new Array(i);
	        while (i--) array[i] = list[i];
	        return array;
	      };
	    }
	  }
	  if (!Date.now) Date.now = function() {
	    return +new Date();
	  };
	  if (d3_document) {
	    try {
	      d3_document.createElement("DIV").style.setProperty("opacity", 0, "");
	    } catch (error) {
	      var d3_element_prototype = this.Element.prototype, d3_element_setAttribute = d3_element_prototype.setAttribute, d3_element_setAttributeNS = d3_element_prototype.setAttributeNS, d3_style_prototype = this.CSSStyleDeclaration.prototype, d3_style_setProperty = d3_style_prototype.setProperty;
	      d3_element_prototype.setAttribute = function(name, value) {
	        d3_element_setAttribute.call(this, name, value + "");
	      };
	      d3_element_prototype.setAttributeNS = function(space, local, value) {
	        d3_element_setAttributeNS.call(this, space, local, value + "");
	      };
	      d3_style_prototype.setProperty = function(name, value, priority) {
	        d3_style_setProperty.call(this, name, value + "", priority);
	      };
	    }
	  }
	  d3.ascending = d3_ascending;
	  function d3_ascending(a, b) {
	    return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
	  }
	  d3.descending = function(a, b) {
	    return b < a ? -1 : b > a ? 1 : b >= a ? 0 : NaN;
	  };
	  d3.min = function(array, f) {
	    var i = -1, n = array.length, a, b;
	    if (arguments.length === 1) {
	      while (++i < n) if ((b = array[i]) != null && b >= b) {
	        a = b;
	        break;
	      }
	      while (++i < n) if ((b = array[i]) != null && a > b) a = b;
	    } else {
	      while (++i < n) if ((b = f.call(array, array[i], i)) != null && b >= b) {
	        a = b;
	        break;
	      }
	      while (++i < n) if ((b = f.call(array, array[i], i)) != null && a > b) a = b;
	    }
	    return a;
	  };
	  d3.max = function(array, f) {
	    var i = -1, n = array.length, a, b;
	    if (arguments.length === 1) {
	      while (++i < n) if ((b = array[i]) != null && b >= b) {
	        a = b;
	        break;
	      }
	      while (++i < n) if ((b = array[i]) != null && b > a) a = b;
	    } else {
	      while (++i < n) if ((b = f.call(array, array[i], i)) != null && b >= b) {
	        a = b;
	        break;
	      }
	      while (++i < n) if ((b = f.call(array, array[i], i)) != null && b > a) a = b;
	    }
	    return a;
	  };
	  d3.extent = function(array, f) {
	    var i = -1, n = array.length, a, b, c;
	    if (arguments.length === 1) {
	      while (++i < n) if ((b = array[i]) != null && b >= b) {
	        a = c = b;
	        break;
	      }
	      while (++i < n) if ((b = array[i]) != null) {
	        if (a > b) a = b;
	        if (c < b) c = b;
	      }
	    } else {
	      while (++i < n) if ((b = f.call(array, array[i], i)) != null && b >= b) {
	        a = c = b;
	        break;
	      }
	      while (++i < n) if ((b = f.call(array, array[i], i)) != null) {
	        if (a > b) a = b;
	        if (c < b) c = b;
	      }
	    }
	    return [ a, c ];
	  };
	  function d3_number(x) {
	    return x === null ? NaN : +x;
	  }
	  function d3_numeric(x) {
	    return !isNaN(x);
	  }
	  d3.sum = function(array, f) {
	    var s = 0, n = array.length, a, i = -1;
	    if (arguments.length === 1) {
	      while (++i < n) if (d3_numeric(a = +array[i])) s += a;
	    } else {
	      while (++i < n) if (d3_numeric(a = +f.call(array, array[i], i))) s += a;
	    }
	    return s;
	  };
	  d3.mean = function(array, f) {
	    var s = 0, n = array.length, a, i = -1, j = n;
	    if (arguments.length === 1) {
	      while (++i < n) if (d3_numeric(a = d3_number(array[i]))) s += a; else --j;
	    } else {
	      while (++i < n) if (d3_numeric(a = d3_number(f.call(array, array[i], i)))) s += a; else --j;
	    }
	    if (j) return s / j;
	  };
	  d3.quantile = function(values, p) {
	    var H = (values.length - 1) * p + 1, h = Math.floor(H), v = +values[h - 1], e = H - h;
	    return e ? v + e * (values[h] - v) : v;
	  };
	  d3.median = function(array, f) {
	    var numbers = [], n = array.length, a, i = -1;
	    if (arguments.length === 1) {
	      while (++i < n) if (d3_numeric(a = d3_number(array[i]))) numbers.push(a);
	    } else {
	      while (++i < n) if (d3_numeric(a = d3_number(f.call(array, array[i], i)))) numbers.push(a);
	    }
	    if (numbers.length) return d3.quantile(numbers.sort(d3_ascending), .5);
	  };
	  d3.variance = function(array, f) {
	    var n = array.length, m = 0, a, d, s = 0, i = -1, j = 0;
	    if (arguments.length === 1) {
	      while (++i < n) {
	        if (d3_numeric(a = d3_number(array[i]))) {
	          d = a - m;
	          m += d / ++j;
	          s += d * (a - m);
	        }
	      }
	    } else {
	      while (++i < n) {
	        if (d3_numeric(a = d3_number(f.call(array, array[i], i)))) {
	          d = a - m;
	          m += d / ++j;
	          s += d * (a - m);
	        }
	      }
	    }
	    if (j > 1) return s / (j - 1);
	  };
	  d3.deviation = function() {
	    var v = d3.variance.apply(this, arguments);
	    return v ? Math.sqrt(v) : v;
	  };
	  function d3_bisector(compare) {
	    return {
	      left: function(a, x, lo, hi) {
	        if (arguments.length < 3) lo = 0;
	        if (arguments.length < 4) hi = a.length;
	        while (lo < hi) {
	          var mid = lo + hi >>> 1;
	          if (compare(a[mid], x) < 0) lo = mid + 1; else hi = mid;
	        }
	        return lo;
	      },
	      right: function(a, x, lo, hi) {
	        if (arguments.length < 3) lo = 0;
	        if (arguments.length < 4) hi = a.length;
	        while (lo < hi) {
	          var mid = lo + hi >>> 1;
	          if (compare(a[mid], x) > 0) hi = mid; else lo = mid + 1;
	        }
	        return lo;
	      }
	    };
	  }
	  var d3_bisect = d3_bisector(d3_ascending);
	  d3.bisectLeft = d3_bisect.left;
	  d3.bisect = d3.bisectRight = d3_bisect.right;
	  d3.bisector = function(f) {
	    return d3_bisector(f.length === 1 ? function(d, x) {
	      return d3_ascending(f(d), x);
	    } : f);
	  };
	  d3.shuffle = function(array, i0, i1) {
	    if ((m = arguments.length) < 3) {
	      i1 = array.length;
	      if (m < 2) i0 = 0;
	    }
	    var m = i1 - i0, t, i;
	    while (m) {
	      i = Math.random() * m-- | 0;
	      t = array[m + i0], array[m + i0] = array[i + i0], array[i + i0] = t;
	    }
	    return array;
	  };
	  d3.permute = function(array, indexes) {
	    var i = indexes.length, permutes = new Array(i);
	    while (i--) permutes[i] = array[indexes[i]];
	    return permutes;
	  };
	  d3.pairs = function(array) {
	    var i = 0, n = array.length - 1, p0, p1 = array[0], pairs = new Array(n < 0 ? 0 : n);
	    while (i < n) pairs[i] = [ p0 = p1, p1 = array[++i] ];
	    return pairs;
	  };
	  d3.transpose = function(matrix) {
	    if (!(n = matrix.length)) return [];
	    for (var i = -1, m = d3.min(matrix, d3_transposeLength), transpose = new Array(m); ++i < m; ) {
	      for (var j = -1, n, row = transpose[i] = new Array(n); ++j < n; ) {
	        row[j] = matrix[j][i];
	      }
	    }
	    return transpose;
	  };
	  function d3_transposeLength(d) {
	    return d.length;
	  }
	  d3.zip = function() {
	    return d3.transpose(arguments);
	  };
	  d3.keys = function(map) {
	    var keys = [];
	    for (var key in map) keys.push(key);
	    return keys;
	  };
	  d3.values = function(map) {
	    var values = [];
	    for (var key in map) values.push(map[key]);
	    return values;
	  };
	  d3.entries = function(map) {
	    var entries = [];
	    for (var key in map) entries.push({
	      key: key,
	      value: map[key]
	    });
	    return entries;
	  };
	  d3.merge = function(arrays) {
	    var n = arrays.length, m, i = -1, j = 0, merged, array;
	    while (++i < n) j += arrays[i].length;
	    merged = new Array(j);
	    while (--n >= 0) {
	      array = arrays[n];
	      m = array.length;
	      while (--m >= 0) {
	        merged[--j] = array[m];
	      }
	    }
	    return merged;
	  };
	  var abs = Math.abs;
	  d3.range = function(start, stop, step) {
	    if (arguments.length < 3) {
	      step = 1;
	      if (arguments.length < 2) {
	        stop = start;
	        start = 0;
	      }
	    }
	    if ((stop - start) / step === Infinity) throw new Error("infinite range");
	    var range = [], k = d3_range_integerScale(abs(step)), i = -1, j;
	    start *= k, stop *= k, step *= k;
	    if (step < 0) while ((j = start + step * ++i) > stop) range.push(j / k); else while ((j = start + step * ++i) < stop) range.push(j / k);
	    return range;
	  };
	  function d3_range_integerScale(x) {
	    var k = 1;
	    while (x * k % 1) k *= 10;
	    return k;
	  }
	  function d3_class(ctor, properties) {
	    for (var key in properties) {
	      Object.defineProperty(ctor.prototype, key, {
	        value: properties[key],
	        enumerable: false
	      });
	    }
	  }
	  d3.map = function(object, f) {
	    var map = new d3_Map();
	    if (object instanceof d3_Map) {
	      object.forEach(function(key, value) {
	        map.set(key, value);
	      });
	    } else if (Array.isArray(object)) {
	      var i = -1, n = object.length, o;
	      if (arguments.length === 1) while (++i < n) map.set(i, object[i]); else while (++i < n) map.set(f.call(object, o = object[i], i), o);
	    } else {
	      for (var key in object) map.set(key, object[key]);
	    }
	    return map;
	  };
	  function d3_Map() {
	    this._ = Object.create(null);
	  }
	  var d3_map_proto = "__proto__", d3_map_zero = "\x00";
	  d3_class(d3_Map, {
	    has: d3_map_has,
	    get: function(key) {
	      return this._[d3_map_escape(key)];
	    },
	    set: function(key, value) {
	      return this._[d3_map_escape(key)] = value;
	    },
	    remove: d3_map_remove,
	    keys: d3_map_keys,
	    values: function() {
	      var values = [];
	      for (var key in this._) values.push(this._[key]);
	      return values;
	    },
	    entries: function() {
	      var entries = [];
	      for (var key in this._) entries.push({
	        key: d3_map_unescape(key),
	        value: this._[key]
	      });
	      return entries;
	    },
	    size: d3_map_size,
	    empty: d3_map_empty,
	    forEach: function(f) {
	      for (var key in this._) f.call(this, d3_map_unescape(key), this._[key]);
	    }
	  });
	  function d3_map_escape(key) {
	    return (key += "") === d3_map_proto || key[0] === d3_map_zero ? d3_map_zero + key : key;
	  }
	  function d3_map_unescape(key) {
	    return (key += "")[0] === d3_map_zero ? key.slice(1) : key;
	  }
	  function d3_map_has(key) {
	    return d3_map_escape(key) in this._;
	  }
	  function d3_map_remove(key) {
	    return (key = d3_map_escape(key)) in this._ && delete this._[key];
	  }
	  function d3_map_keys() {
	    var keys = [];
	    for (var key in this._) keys.push(d3_map_unescape(key));
	    return keys;
	  }
	  function d3_map_size() {
	    var size = 0;
	    for (var key in this._) ++size;
	    return size;
	  }
	  function d3_map_empty() {
	    for (var key in this._) return false;
	    return true;
	  }
	  d3.nest = function() {
	    var nest = {}, keys = [], sortKeys = [], sortValues, rollup;
	    function map(mapType, array, depth) {
	      if (depth >= keys.length) return rollup ? rollup.call(nest, array) : sortValues ? array.sort(sortValues) : array;
	      var i = -1, n = array.length, key = keys[depth++], keyValue, object, setter, valuesByKey = new d3_Map(), values;
	      while (++i < n) {
	        if (values = valuesByKey.get(keyValue = key(object = array[i]))) {
	          values.push(object);
	        } else {
	          valuesByKey.set(keyValue, [ object ]);
	        }
	      }
	      if (mapType) {
	        object = mapType();
	        setter = function(keyValue, values) {
	          object.set(keyValue, map(mapType, values, depth));
	        };
	      } else {
	        object = {};
	        setter = function(keyValue, values) {
	          object[keyValue] = map(mapType, values, depth);
	        };
	      }
	      valuesByKey.forEach(setter);
	      return object;
	    }
	    function entries(map, depth) {
	      if (depth >= keys.length) return map;
	      var array = [], sortKey = sortKeys[depth++];
	      map.forEach(function(key, keyMap) {
	        array.push({
	          key: key,
	          values: entries(keyMap, depth)
	        });
	      });
	      return sortKey ? array.sort(function(a, b) {
	        return sortKey(a.key, b.key);
	      }) : array;
	    }
	    nest.map = function(array, mapType) {
	      return map(mapType, array, 0);
	    };
	    nest.entries = function(array) {
	      return entries(map(d3.map, array, 0), 0);
	    };
	    nest.key = function(d) {
	      keys.push(d);
	      return nest;
	    };
	    nest.sortKeys = function(order) {
	      sortKeys[keys.length - 1] = order;
	      return nest;
	    };
	    nest.sortValues = function(order) {
	      sortValues = order;
	      return nest;
	    };
	    nest.rollup = function(f) {
	      rollup = f;
	      return nest;
	    };
	    return nest;
	  };
	  d3.set = function(array) {
	    var set = new d3_Set();
	    if (array) for (var i = 0, n = array.length; i < n; ++i) set.add(array[i]);
	    return set;
	  };
	  function d3_Set() {
	    this._ = Object.create(null);
	  }
	  d3_class(d3_Set, {
	    has: d3_map_has,
	    add: function(key) {
	      this._[d3_map_escape(key += "")] = true;
	      return key;
	    },
	    remove: d3_map_remove,
	    values: d3_map_keys,
	    size: d3_map_size,
	    empty: d3_map_empty,
	    forEach: function(f) {
	      for (var key in this._) f.call(this, d3_map_unescape(key));
	    }
	  });
	  d3.behavior = {};
	  function d3_identity(d) {
	    return d;
	  }
	  d3.rebind = function(target, source) {
	    var i = 1, n = arguments.length, method;
	    while (++i < n) target[method = arguments[i]] = d3_rebind(target, source, source[method]);
	    return target;
	  };
	  function d3_rebind(target, source, method) {
	    return function() {
	      var value = method.apply(source, arguments);
	      return value === source ? target : value;
	    };
	  }
	  function d3_vendorSymbol(object, name) {
	    if (name in object) return name;
	    name = name.charAt(0).toUpperCase() + name.slice(1);
	    for (var i = 0, n = d3_vendorPrefixes.length; i < n; ++i) {
	      var prefixName = d3_vendorPrefixes[i] + name;
	      if (prefixName in object) return prefixName;
	    }
	  }
	  var d3_vendorPrefixes = [ "webkit", "ms", "moz", "Moz", "o", "O" ];
	  function d3_noop() {}
	  d3.dispatch = function() {
	    var dispatch = new d3_dispatch(), i = -1, n = arguments.length;
	    while (++i < n) dispatch[arguments[i]] = d3_dispatch_event(dispatch);
	    return dispatch;
	  };
	  function d3_dispatch() {}
	  d3_dispatch.prototype.on = function(type, listener) {
	    var i = type.indexOf("."), name = "";
	    if (i >= 0) {
	      name = type.slice(i + 1);
	      type = type.slice(0, i);
	    }
	    if (type) return arguments.length < 2 ? this[type].on(name) : this[type].on(name, listener);
	    if (arguments.length === 2) {
	      if (listener == null) for (type in this) {
	        if (this.hasOwnProperty(type)) this[type].on(name, null);
	      }
	      return this;
	    }
	  };
	  function d3_dispatch_event(dispatch) {
	    var listeners = [], listenerByName = new d3_Map();
	    function event() {
	      var z = listeners, i = -1, n = z.length, l;
	      while (++i < n) if (l = z[i].on) l.apply(this, arguments);
	      return dispatch;
	    }
	    event.on = function(name, listener) {
	      var l = listenerByName.get(name), i;
	      if (arguments.length < 2) return l && l.on;
	      if (l) {
	        l.on = null;
	        listeners = listeners.slice(0, i = listeners.indexOf(l)).concat(listeners.slice(i + 1));
	        listenerByName.remove(name);
	      }
	      if (listener) listeners.push(listenerByName.set(name, {
	        on: listener
	      }));
	      return dispatch;
	    };
	    return event;
	  }
	  d3.event = null;
	  function d3_eventPreventDefault() {
	    d3.event.preventDefault();
	  }
	  function d3_eventSource() {
	    var e = d3.event, s;
	    while (s = e.sourceEvent) e = s;
	    return e;
	  }
	  function d3_eventDispatch(target) {
	    var dispatch = new d3_dispatch(), i = 0, n = arguments.length;
	    while (++i < n) dispatch[arguments[i]] = d3_dispatch_event(dispatch);
	    dispatch.of = function(thiz, argumentz) {
	      return function(e1) {
	        try {
	          var e0 = e1.sourceEvent = d3.event;
	          e1.target = target;
	          d3.event = e1;
	          dispatch[e1.type].apply(thiz, argumentz);
	        } finally {
	          d3.event = e0;
	        }
	      };
	    };
	    return dispatch;
	  }
	  d3.requote = function(s) {
	    return s.replace(d3_requote_re, "\\$&");
	  };
	  var d3_requote_re = /[\\\^\$\*\+\?\|\[\]\(\)\.\{\}]/g;
	  var d3_subclass = {}.__proto__ ? function(object, prototype) {
	    object.__proto__ = prototype;
	  } : function(object, prototype) {
	    for (var property in prototype) object[property] = prototype[property];
	  };
	  function d3_selection(groups) {
	    d3_subclass(groups, d3_selectionPrototype);
	    return groups;
	  }
	  var d3_select = function(s, n) {
	    return n.querySelector(s);
	  }, d3_selectAll = function(s, n) {
	    return n.querySelectorAll(s);
	  }, d3_selectMatches = function(n, s) {
	    var d3_selectMatcher = n.matches || n[d3_vendorSymbol(n, "matchesSelector")];
	    d3_selectMatches = function(n, s) {
	      return d3_selectMatcher.call(n, s);
	    };
	    return d3_selectMatches(n, s);
	  };
	  if (typeof Sizzle === "function") {
	    d3_select = function(s, n) {
	      return Sizzle(s, n)[0] || null;
	    };
	    d3_selectAll = Sizzle;
	    d3_selectMatches = Sizzle.matchesSelector;
	  }
	  d3.selection = function() {
	    return d3.select(d3_document.documentElement);
	  };
	  var d3_selectionPrototype = d3.selection.prototype = [];
	  d3_selectionPrototype.select = function(selector) {
	    var subgroups = [], subgroup, subnode, group, node;
	    selector = d3_selection_selector(selector);
	    for (var j = -1, m = this.length; ++j < m; ) {
	      subgroups.push(subgroup = []);
	      subgroup.parentNode = (group = this[j]).parentNode;
	      for (var i = -1, n = group.length; ++i < n; ) {
	        if (node = group[i]) {
	          subgroup.push(subnode = selector.call(node, node.__data__, i, j));
	          if (subnode && "__data__" in node) subnode.__data__ = node.__data__;
	        } else {
	          subgroup.push(null);
	        }
	      }
	    }
	    return d3_selection(subgroups);
	  };
	  function d3_selection_selector(selector) {
	    return typeof selector === "function" ? selector : function() {
	      return d3_select(selector, this);
	    };
	  }
	  d3_selectionPrototype.selectAll = function(selector) {
	    var subgroups = [], subgroup, node;
	    selector = d3_selection_selectorAll(selector);
	    for (var j = -1, m = this.length; ++j < m; ) {
	      for (var group = this[j], i = -1, n = group.length; ++i < n; ) {
	        if (node = group[i]) {
	          subgroups.push(subgroup = d3_array(selector.call(node, node.__data__, i, j)));
	          subgroup.parentNode = node;
	        }
	      }
	    }
	    return d3_selection(subgroups);
	  };
	  function d3_selection_selectorAll(selector) {
	    return typeof selector === "function" ? selector : function() {
	      return d3_selectAll(selector, this);
	    };
	  }
	  var d3_nsXhtml = "http://www.w3.org/1999/xhtml";
	  var d3_nsPrefix = {
	    svg: "http://www.w3.org/2000/svg",
	    xhtml: d3_nsXhtml,
	    xlink: "http://www.w3.org/1999/xlink",
	    xml: "http://www.w3.org/XML/1998/namespace",
	    xmlns: "http://www.w3.org/2000/xmlns/"
	  };
	  d3.ns = {
	    prefix: d3_nsPrefix,
	    qualify: function(name) {
	      var i = name.indexOf(":"), prefix = name;
	      if (i >= 0 && (prefix = name.slice(0, i)) !== "xmlns") name = name.slice(i + 1);
	      return d3_nsPrefix.hasOwnProperty(prefix) ? {
	        space: d3_nsPrefix[prefix],
	        local: name
	      } : name;
	    }
	  };
	  d3_selectionPrototype.attr = function(name, value) {
	    if (arguments.length < 2) {
	      if (typeof name === "string") {
	        var node = this.node();
	        name = d3.ns.qualify(name);
	        return name.local ? node.getAttributeNS(name.space, name.local) : node.getAttribute(name);
	      }
	      for (value in name) this.each(d3_selection_attr(value, name[value]));
	      return this;
	    }
	    return this.each(d3_selection_attr(name, value));
	  };
	  function d3_selection_attr(name, value) {
	    name = d3.ns.qualify(name);
	    function attrNull() {
	      this.removeAttribute(name);
	    }
	    function attrNullNS() {
	      this.removeAttributeNS(name.space, name.local);
	    }
	    function attrConstant() {
	      this.setAttribute(name, value);
	    }
	    function attrConstantNS() {
	      this.setAttributeNS(name.space, name.local, value);
	    }
	    function attrFunction() {
	      var x = value.apply(this, arguments);
	      if (x == null) this.removeAttribute(name); else this.setAttribute(name, x);
	    }
	    function attrFunctionNS() {
	      var x = value.apply(this, arguments);
	      if (x == null) this.removeAttributeNS(name.space, name.local); else this.setAttributeNS(name.space, name.local, x);
	    }
	    return value == null ? name.local ? attrNullNS : attrNull : typeof value === "function" ? name.local ? attrFunctionNS : attrFunction : name.local ? attrConstantNS : attrConstant;
	  }
	  function d3_collapse(s) {
	    return s.trim().replace(/\s+/g, " ");
	  }
	  d3_selectionPrototype.classed = function(name, value) {
	    if (arguments.length < 2) {
	      if (typeof name === "string") {
	        var node = this.node(), n = (name = d3_selection_classes(name)).length, i = -1;
	        if (value = node.classList) {
	          while (++i < n) if (!value.contains(name[i])) return false;
	        } else {
	          value = node.getAttribute("class");
	          while (++i < n) if (!d3_selection_classedRe(name[i]).test(value)) return false;
	        }
	        return true;
	      }
	      for (value in name) this.each(d3_selection_classed(value, name[value]));
	      return this;
	    }
	    return this.each(d3_selection_classed(name, value));
	  };
	  function d3_selection_classedRe(name) {
	    return new RegExp("(?:^|\\s+)" + d3.requote(name) + "(?:\\s+|$)", "g");
	  }
	  function d3_selection_classes(name) {
	    return (name + "").trim().split(/^|\s+/);
	  }
	  function d3_selection_classed(name, value) {
	    name = d3_selection_classes(name).map(d3_selection_classedName);
	    var n = name.length;
	    function classedConstant() {
	      var i = -1;
	      while (++i < n) name[i](this, value);
	    }
	    function classedFunction() {
	      var i = -1, x = value.apply(this, arguments);
	      while (++i < n) name[i](this, x);
	    }
	    return typeof value === "function" ? classedFunction : classedConstant;
	  }
	  function d3_selection_classedName(name) {
	    var re = d3_selection_classedRe(name);
	    return function(node, value) {
	      if (c = node.classList) return value ? c.add(name) : c.remove(name);
	      var c = node.getAttribute("class") || "";
	      if (value) {
	        re.lastIndex = 0;
	        if (!re.test(c)) node.setAttribute("class", d3_collapse(c + " " + name));
	      } else {
	        node.setAttribute("class", d3_collapse(c.replace(re, " ")));
	      }
	    };
	  }
	  d3_selectionPrototype.style = function(name, value, priority) {
	    var n = arguments.length;
	    if (n < 3) {
	      if (typeof name !== "string") {
	        if (n < 2) value = "";
	        for (priority in name) this.each(d3_selection_style(priority, name[priority], value));
	        return this;
	      }
	      if (n < 2) {
	        var node = this.node();
	        return d3_window(node).getComputedStyle(node, null).getPropertyValue(name);
	      }
	      priority = "";
	    }
	    return this.each(d3_selection_style(name, value, priority));
	  };
	  function d3_selection_style(name, value, priority) {
	    function styleNull() {
	      this.style.removeProperty(name);
	    }
	    function styleConstant() {
	      this.style.setProperty(name, value, priority);
	    }
	    function styleFunction() {
	      var x = value.apply(this, arguments);
	      if (x == null) this.style.removeProperty(name); else this.style.setProperty(name, x, priority);
	    }
	    return value == null ? styleNull : typeof value === "function" ? styleFunction : styleConstant;
	  }
	  d3_selectionPrototype.property = function(name, value) {
	    if (arguments.length < 2) {
	      if (typeof name === "string") return this.node()[name];
	      for (value in name) this.each(d3_selection_property(value, name[value]));
	      return this;
	    }
	    return this.each(d3_selection_property(name, value));
	  };
	  function d3_selection_property(name, value) {
	    function propertyNull() {
	      delete this[name];
	    }
	    function propertyConstant() {
	      this[name] = value;
	    }
	    function propertyFunction() {
	      var x = value.apply(this, arguments);
	      if (x == null) delete this[name]; else this[name] = x;
	    }
	    return value == null ? propertyNull : typeof value === "function" ? propertyFunction : propertyConstant;
	  }
	  d3_selectionPrototype.text = function(value) {
	    return arguments.length ? this.each(typeof value === "function" ? function() {
	      var v = value.apply(this, arguments);
	      this.textContent = v == null ? "" : v;
	    } : value == null ? function() {
	      this.textContent = "";
	    } : function() {
	      this.textContent = value;
	    }) : this.node().textContent;
	  };
	  d3_selectionPrototype.html = function(value) {
	    return arguments.length ? this.each(typeof value === "function" ? function() {
	      var v = value.apply(this, arguments);
	      this.innerHTML = v == null ? "" : v;
	    } : value == null ? function() {
	      this.innerHTML = "";
	    } : function() {
	      this.innerHTML = value;
	    }) : this.node().innerHTML;
	  };
	  d3_selectionPrototype.append = function(name) {
	    name = d3_selection_creator(name);
	    return this.select(function() {
	      return this.appendChild(name.apply(this, arguments));
	    });
	  };
	  function d3_selection_creator(name) {
	    function create() {
	      var document = this.ownerDocument, namespace = this.namespaceURI;
	      return namespace === d3_nsXhtml && document.documentElement.namespaceURI === d3_nsXhtml ? document.createElement(name) : document.createElementNS(namespace, name);
	    }
	    function createNS() {
	      return this.ownerDocument.createElementNS(name.space, name.local);
	    }
	    return typeof name === "function" ? name : (name = d3.ns.qualify(name)).local ? createNS : create;
	  }
	  d3_selectionPrototype.insert = function(name, before) {
	    name = d3_selection_creator(name);
	    before = d3_selection_selector(before);
	    return this.select(function() {
	      return this.insertBefore(name.apply(this, arguments), before.apply(this, arguments) || null);
	    });
	  };
	  d3_selectionPrototype.remove = function() {
	    return this.each(d3_selectionRemove);
	  };
	  function d3_selectionRemove() {
	    var parent = this.parentNode;
	    if (parent) parent.removeChild(this);
	  }
	  d3_selectionPrototype.data = function(value, key) {
	    var i = -1, n = this.length, group, node;
	    if (!arguments.length) {
	      value = new Array(n = (group = this[0]).length);
	      while (++i < n) {
	        if (node = group[i]) {
	          value[i] = node.__data__;
	        }
	      }
	      return value;
	    }
	    function bind(group, groupData) {
	      var i, n = group.length, m = groupData.length, n0 = Math.min(n, m), updateNodes = new Array(m), enterNodes = new Array(m), exitNodes = new Array(n), node, nodeData;
	      if (key) {
	        var nodeByKeyValue = new d3_Map(), keyValues = new Array(n), keyValue;
	        for (i = -1; ++i < n; ) {
	          if (node = group[i]) {
	            if (nodeByKeyValue.has(keyValue = key.call(node, node.__data__, i))) {
	              exitNodes[i] = node;
	            } else {
	              nodeByKeyValue.set(keyValue, node);
	            }
	            keyValues[i] = keyValue;
	          }
	        }
	        for (i = -1; ++i < m; ) {
	          if (!(node = nodeByKeyValue.get(keyValue = key.call(groupData, nodeData = groupData[i], i)))) {
	            enterNodes[i] = d3_selection_dataNode(nodeData);
	          } else if (node !== true) {
	            updateNodes[i] = node;
	            node.__data__ = nodeData;
	          }
	          nodeByKeyValue.set(keyValue, true);
	        }
	        for (i = -1; ++i < n; ) {
	          if (i in keyValues && nodeByKeyValue.get(keyValues[i]) !== true) {
	            exitNodes[i] = group[i];
	          }
	        }
	      } else {
	        for (i = -1; ++i < n0; ) {
	          node = group[i];
	          nodeData = groupData[i];
	          if (node) {
	            node.__data__ = nodeData;
	            updateNodes[i] = node;
	          } else {
	            enterNodes[i] = d3_selection_dataNode(nodeData);
	          }
	        }
	        for (;i < m; ++i) {
	          enterNodes[i] = d3_selection_dataNode(groupData[i]);
	        }
	        for (;i < n; ++i) {
	          exitNodes[i] = group[i];
	        }
	      }
	      enterNodes.update = updateNodes;
	      enterNodes.parentNode = updateNodes.parentNode = exitNodes.parentNode = group.parentNode;
	      enter.push(enterNodes);
	      update.push(updateNodes);
	      exit.push(exitNodes);
	    }
	    var enter = d3_selection_enter([]), update = d3_selection([]), exit = d3_selection([]);
	    if (typeof value === "function") {
	      while (++i < n) {
	        bind(group = this[i], value.call(group, group.parentNode.__data__, i));
	      }
	    } else {
	      while (++i < n) {
	        bind(group = this[i], value);
	      }
	    }
	    update.enter = function() {
	      return enter;
	    };
	    update.exit = function() {
	      return exit;
	    };
	    return update;
	  };
	  function d3_selection_dataNode(data) {
	    return {
	      __data__: data
	    };
	  }
	  d3_selectionPrototype.datum = function(value) {
	    return arguments.length ? this.property("__data__", value) : this.property("__data__");
	  };
	  d3_selectionPrototype.filter = function(filter) {
	    var subgroups = [], subgroup, group, node;
	    if (typeof filter !== "function") filter = d3_selection_filter(filter);
	    for (var j = 0, m = this.length; j < m; j++) {
	      subgroups.push(subgroup = []);
	      subgroup.parentNode = (group = this[j]).parentNode;
	      for (var i = 0, n = group.length; i < n; i++) {
	        if ((node = group[i]) && filter.call(node, node.__data__, i, j)) {
	          subgroup.push(node);
	        }
	      }
	    }
	    return d3_selection(subgroups);
	  };
	  function d3_selection_filter(selector) {
	    return function() {
	      return d3_selectMatches(this, selector);
	    };
	  }
	  d3_selectionPrototype.order = function() {
	    for (var j = -1, m = this.length; ++j < m; ) {
	      for (var group = this[j], i = group.length - 1, next = group[i], node; --i >= 0; ) {
	        if (node = group[i]) {
	          if (next && next !== node.nextSibling) next.parentNode.insertBefore(node, next);
	          next = node;
	        }
	      }
	    }
	    return this;
	  };
	  d3_selectionPrototype.sort = function(comparator) {
	    comparator = d3_selection_sortComparator.apply(this, arguments);
	    for (var j = -1, m = this.length; ++j < m; ) this[j].sort(comparator);
	    return this.order();
	  };
	  function d3_selection_sortComparator(comparator) {
	    if (!arguments.length) comparator = d3_ascending;
	    return function(a, b) {
	      return a && b ? comparator(a.__data__, b.__data__) : !a - !b;
	    };
	  }
	  d3_selectionPrototype.each = function(callback) {
	    return d3_selection_each(this, function(node, i, j) {
	      callback.call(node, node.__data__, i, j);
	    });
	  };
	  function d3_selection_each(groups, callback) {
	    for (var j = 0, m = groups.length; j < m; j++) {
	      for (var group = groups[j], i = 0, n = group.length, node; i < n; i++) {
	        if (node = group[i]) callback(node, i, j);
	      }
	    }
	    return groups;
	  }
	  d3_selectionPrototype.call = function(callback) {
	    var args = d3_array(arguments);
	    callback.apply(args[0] = this, args);
	    return this;
	  };
	  d3_selectionPrototype.empty = function() {
	    return !this.node();
	  };
	  d3_selectionPrototype.node = function() {
	    for (var j = 0, m = this.length; j < m; j++) {
	      for (var group = this[j], i = 0, n = group.length; i < n; i++) {
	        var node = group[i];
	        if (node) return node;
	      }
	    }
	    return null;
	  };
	  d3_selectionPrototype.size = function() {
	    var n = 0;
	    d3_selection_each(this, function() {
	      ++n;
	    });
	    return n;
	  };
	  function d3_selection_enter(selection) {
	    d3_subclass(selection, d3_selection_enterPrototype);
	    return selection;
	  }
	  var d3_selection_enterPrototype = [];
	  d3.selection.enter = d3_selection_enter;
	  d3.selection.enter.prototype = d3_selection_enterPrototype;
	  d3_selection_enterPrototype.append = d3_selectionPrototype.append;
	  d3_selection_enterPrototype.empty = d3_selectionPrototype.empty;
	  d3_selection_enterPrototype.node = d3_selectionPrototype.node;
	  d3_selection_enterPrototype.call = d3_selectionPrototype.call;
	  d3_selection_enterPrototype.size = d3_selectionPrototype.size;
	  d3_selection_enterPrototype.select = function(selector) {
	    var subgroups = [], subgroup, subnode, upgroup, group, node;
	    for (var j = -1, m = this.length; ++j < m; ) {
	      upgroup = (group = this[j]).update;
	      subgroups.push(subgroup = []);
	      subgroup.parentNode = group.parentNode;
	      for (var i = -1, n = group.length; ++i < n; ) {
	        if (node = group[i]) {
	          subgroup.push(upgroup[i] = subnode = selector.call(group.parentNode, node.__data__, i, j));
	          subnode.__data__ = node.__data__;
	        } else {
	          subgroup.push(null);
	        }
	      }
	    }
	    return d3_selection(subgroups);
	  };
	  d3_selection_enterPrototype.insert = function(name, before) {
	    if (arguments.length < 2) before = d3_selection_enterInsertBefore(this);
	    return d3_selectionPrototype.insert.call(this, name, before);
	  };
	  function d3_selection_enterInsertBefore(enter) {
	    var i0, j0;
	    return function(d, i, j) {
	      var group = enter[j].update, n = group.length, node;
	      if (j != j0) j0 = j, i0 = 0;
	      if (i >= i0) i0 = i + 1;
	      while (!(node = group[i0]) && ++i0 < n) ;
	      return node;
	    };
	  }
	  d3.select = function(node) {
	    var group;
	    if (typeof node === "string") {
	      group = [ d3_select(node, d3_document) ];
	      group.parentNode = d3_document.documentElement;
	    } else {
	      group = [ node ];
	      group.parentNode = d3_documentElement(node);
	    }
	    return d3_selection([ group ]);
	  };
	  d3.selectAll = function(nodes) {
	    var group;
	    if (typeof nodes === "string") {
	      group = d3_array(d3_selectAll(nodes, d3_document));
	      group.parentNode = d3_document.documentElement;
	    } else {
	      group = d3_array(nodes);
	      group.parentNode = null;
	    }
	    return d3_selection([ group ]);
	  };
	  d3_selectionPrototype.on = function(type, listener, capture) {
	    var n = arguments.length;
	    if (n < 3) {
	      if (typeof type !== "string") {
	        if (n < 2) listener = false;
	        for (capture in type) this.each(d3_selection_on(capture, type[capture], listener));
	        return this;
	      }
	      if (n < 2) return (n = this.node()["__on" + type]) && n._;
	      capture = false;
	    }
	    return this.each(d3_selection_on(type, listener, capture));
	  };
	  function d3_selection_on(type, listener, capture) {
	    var name = "__on" + type, i = type.indexOf("."), wrap = d3_selection_onListener;
	    if (i > 0) type = type.slice(0, i);
	    var filter = d3_selection_onFilters.get(type);
	    if (filter) type = filter, wrap = d3_selection_onFilter;
	    function onRemove() {
	      var l = this[name];
	      if (l) {
	        this.removeEventListener(type, l, l.$);
	        delete this[name];
	      }
	    }
	    function onAdd() {
	      var l = wrap(listener, d3_array(arguments));
	      onRemove.call(this);
	      this.addEventListener(type, this[name] = l, l.$ = capture);
	      l._ = listener;
	    }
	    function removeAll() {
	      var re = new RegExp("^__on([^.]+)" + d3.requote(type) + "$"), match;
	      for (var name in this) {
	        if (match = name.match(re)) {
	          var l = this[name];
	          this.removeEventListener(match[1], l, l.$);
	          delete this[name];
	        }
	      }
	    }
	    return i ? listener ? onAdd : onRemove : listener ? d3_noop : removeAll;
	  }
	  var d3_selection_onFilters = d3.map({
	    mouseenter: "mouseover",
	    mouseleave: "mouseout"
	  });
	  if (d3_document) {
	    d3_selection_onFilters.forEach(function(k) {
	      if ("on" + k in d3_document) d3_selection_onFilters.remove(k);
	    });
	  }
	  function d3_selection_onListener(listener, argumentz) {
	    return function(e) {
	      var o = d3.event;
	      d3.event = e;
	      argumentz[0] = this.__data__;
	      try {
	        listener.apply(this, argumentz);
	      } finally {
	        d3.event = o;
	      }
	    };
	  }
	  function d3_selection_onFilter(listener, argumentz) {
	    var l = d3_selection_onListener(listener, argumentz);
	    return function(e) {
	      var target = this, related = e.relatedTarget;
	      if (!related || related !== target && !(related.compareDocumentPosition(target) & 8)) {
	        l.call(target, e);
	      }
	    };
	  }
	  var d3_event_dragSelect, d3_event_dragId = 0;
	  function d3_event_dragSuppress(node) {
	    var name = ".dragsuppress-" + ++d3_event_dragId, click = "click" + name, w = d3.select(d3_window(node)).on("touchmove" + name, d3_eventPreventDefault).on("dragstart" + name, d3_eventPreventDefault).on("selectstart" + name, d3_eventPreventDefault);
	    if (d3_event_dragSelect == null) {
	      d3_event_dragSelect = "onselectstart" in node ? false : d3_vendorSymbol(node.style, "userSelect");
	    }
	    if (d3_event_dragSelect) {
	      var style = d3_documentElement(node).style, select = style[d3_event_dragSelect];
	      style[d3_event_dragSelect] = "none";
	    }
	    return function(suppressClick) {
	      w.on(name, null);
	      if (d3_event_dragSelect) style[d3_event_dragSelect] = select;
	      if (suppressClick) {
	        var off = function() {
	          w.on(click, null);
	        };
	        w.on(click, function() {
	          d3_eventPreventDefault();
	          off();
	        }, true);
	        setTimeout(off, 0);
	      }
	    };
	  }
	  d3.mouse = function(container) {
	    return d3_mousePoint(container, d3_eventSource());
	  };
	  var d3_mouse_bug44083 = this.navigator && /WebKit/.test(this.navigator.userAgent) ? -1 : 0;
	  function d3_mousePoint(container, e) {
	    if (e.changedTouches) e = e.changedTouches[0];
	    var svg = container.ownerSVGElement || container;
	    if (svg.createSVGPoint) {
	      var point = svg.createSVGPoint();
	      if (d3_mouse_bug44083 < 0) {
	        var window = d3_window(container);
	        if (window.scrollX || window.scrollY) {
	          svg = d3.select("body").append("svg").style({
	            position: "absolute",
	            top: 0,
	            left: 0,
	            margin: 0,
	            padding: 0,
	            border: "none"
	          }, "important");
	          var ctm = svg[0][0].getScreenCTM();
	          d3_mouse_bug44083 = !(ctm.f || ctm.e);
	          svg.remove();
	        }
	      }
	      if (d3_mouse_bug44083) point.x = e.pageX, point.y = e.pageY; else point.x = e.clientX, 
	      point.y = e.clientY;
	      point = point.matrixTransform(container.getScreenCTM().inverse());
	      return [ point.x, point.y ];
	    }
	    var rect = container.getBoundingClientRect();
	    return [ e.clientX - rect.left - container.clientLeft, e.clientY - rect.top - container.clientTop ];
	  }
	  d3.touch = function(container, touches, identifier) {
	    if (arguments.length < 3) identifier = touches, touches = d3_eventSource().changedTouches;
	    if (touches) for (var i = 0, n = touches.length, touch; i < n; ++i) {
	      if ((touch = touches[i]).identifier === identifier) {
	        return d3_mousePoint(container, touch);
	      }
	    }
	  };
	  d3.behavior.drag = function() {
	    var event = d3_eventDispatch(drag, "drag", "dragstart", "dragend"), origin = null, mousedown = dragstart(d3_noop, d3.mouse, d3_window, "mousemove", "mouseup"), touchstart = dragstart(d3_behavior_dragTouchId, d3.touch, d3_identity, "touchmove", "touchend");
	    function drag() {
	      this.on("mousedown.drag", mousedown).on("touchstart.drag", touchstart);
	    }
	    function dragstart(id, position, subject, move, end) {
	      return function() {
	        var that = this, target = d3.event.target.correspondingElement || d3.event.target, parent = that.parentNode, dispatch = event.of(that, arguments), dragged = 0, dragId = id(), dragName = ".drag" + (dragId == null ? "" : "-" + dragId), dragOffset, dragSubject = d3.select(subject(target)).on(move + dragName, moved).on(end + dragName, ended), dragRestore = d3_event_dragSuppress(target), position0 = position(parent, dragId);
	        if (origin) {
	          dragOffset = origin.apply(that, arguments);
	          dragOffset = [ dragOffset.x - position0[0], dragOffset.y - position0[1] ];
	        } else {
	          dragOffset = [ 0, 0 ];
	        }
	        dispatch({
	          type: "dragstart"
	        });
	        function moved() {
	          var position1 = position(parent, dragId), dx, dy;
	          if (!position1) return;
	          dx = position1[0] - position0[0];
	          dy = position1[1] - position0[1];
	          dragged |= dx | dy;
	          position0 = position1;
	          dispatch({
	            type: "drag",
	            x: position1[0] + dragOffset[0],
	            y: position1[1] + dragOffset[1],
	            dx: dx,
	            dy: dy
	          });
	        }
	        function ended() {
	          if (!position(parent, dragId)) return;
	          dragSubject.on(move + dragName, null).on(end + dragName, null);
	          dragRestore(dragged);
	          dispatch({
	            type: "dragend"
	          });
	        }
	      };
	    }
	    drag.origin = function(x) {
	      if (!arguments.length) return origin;
	      origin = x;
	      return drag;
	    };
	    return d3.rebind(drag, event, "on");
	  };
	  function d3_behavior_dragTouchId() {
	    return d3.event.changedTouches[0].identifier;
	  }
	  d3.touches = function(container, touches) {
	    if (arguments.length < 2) touches = d3_eventSource().touches;
	    return touches ? d3_array(touches).map(function(touch) {
	      var point = d3_mousePoint(container, touch);
	      point.identifier = touch.identifier;
	      return point;
	    }) : [];
	  };
	  var ε = 1e-6, ε2 = ε * ε, π = Math.PI, τ = 2 * π, τε = τ - ε, halfπ = π / 2, d3_radians = π / 180, d3_degrees = 180 / π;
	  function d3_sgn(x) {
	    return x > 0 ? 1 : x < 0 ? -1 : 0;
	  }
	  function d3_cross2d(a, b, c) {
	    return (b[0] - a[0]) * (c[1] - a[1]) - (b[1] - a[1]) * (c[0] - a[0]);
	  }
	  function d3_acos(x) {
	    return x > 1 ? 0 : x < -1 ? π : Math.acos(x);
	  }
	  function d3_asin(x) {
	    return x > 1 ? halfπ : x < -1 ? -halfπ : Math.asin(x);
	  }
	  function d3_sinh(x) {
	    return ((x = Math.exp(x)) - 1 / x) / 2;
	  }
	  function d3_cosh(x) {
	    return ((x = Math.exp(x)) + 1 / x) / 2;
	  }
	  function d3_tanh(x) {
	    return ((x = Math.exp(2 * x)) - 1) / (x + 1);
	  }
	  function d3_haversin(x) {
	    return (x = Math.sin(x / 2)) * x;
	  }
	  var ρ = Math.SQRT2, ρ2 = 2, ρ4 = 4;
	  d3.interpolateZoom = function(p0, p1) {
	    var ux0 = p0[0], uy0 = p0[1], w0 = p0[2], ux1 = p1[0], uy1 = p1[1], w1 = p1[2], dx = ux1 - ux0, dy = uy1 - uy0, d2 = dx * dx + dy * dy, i, S;
	    if (d2 < ε2) {
	      S = Math.log(w1 / w0) / ρ;
	      i = function(t) {
	        return [ ux0 + t * dx, uy0 + t * dy, w0 * Math.exp(ρ * t * S) ];
	      };
	    } else {
	      var d1 = Math.sqrt(d2), b0 = (w1 * w1 - w0 * w0 + ρ4 * d2) / (2 * w0 * ρ2 * d1), b1 = (w1 * w1 - w0 * w0 - ρ4 * d2) / (2 * w1 * ρ2 * d1), r0 = Math.log(Math.sqrt(b0 * b0 + 1) - b0), r1 = Math.log(Math.sqrt(b1 * b1 + 1) - b1);
	      S = (r1 - r0) / ρ;
	      i = function(t) {
	        var s = t * S, coshr0 = d3_cosh(r0), u = w0 / (ρ2 * d1) * (coshr0 * d3_tanh(ρ * s + r0) - d3_sinh(r0));
	        return [ ux0 + u * dx, uy0 + u * dy, w0 * coshr0 / d3_cosh(ρ * s + r0) ];
	      };
	    }
	    i.duration = S * 1e3;
	    return i;
	  };
	  d3.behavior.zoom = function() {
	    var view = {
	      x: 0,
	      y: 0,
	      k: 1
	    }, translate0, center0, center, size = [ 960, 500 ], scaleExtent = d3_behavior_zoomInfinity, duration = 250, zooming = 0, mousedown = "mousedown.zoom", mousemove = "mousemove.zoom", mouseup = "mouseup.zoom", mousewheelTimer, touchstart = "touchstart.zoom", touchtime, event = d3_eventDispatch(zoom, "zoomstart", "zoom", "zoomend"), x0, x1, y0, y1;
	    if (!d3_behavior_zoomWheel) {
	      d3_behavior_zoomWheel = "onwheel" in d3_document ? (d3_behavior_zoomDelta = function() {
	        return -d3.event.deltaY * (d3.event.deltaMode ? 120 : 1);
	      }, "wheel") : "onmousewheel" in d3_document ? (d3_behavior_zoomDelta = function() {
	        return d3.event.wheelDelta;
	      }, "mousewheel") : (d3_behavior_zoomDelta = function() {
	        return -d3.event.detail;
	      }, "MozMousePixelScroll");
	    }
	    function zoom(g) {
	      g.on(mousedown, mousedowned).on(d3_behavior_zoomWheel + ".zoom", mousewheeled).on("dblclick.zoom", dblclicked).on(touchstart, touchstarted);
	    }
	    zoom.event = function(g) {
	      g.each(function() {
	        var dispatch = event.of(this, arguments), view1 = view;
	        if (d3_transitionInheritId) {
	          d3.select(this).transition().each("start.zoom", function() {
	            view = this.__chart__ || {
	              x: 0,
	              y: 0,
	              k: 1
	            };
	            zoomstarted(dispatch);
	          }).tween("zoom:zoom", function() {
	            var dx = size[0], dy = size[1], cx = center0 ? center0[0] : dx / 2, cy = center0 ? center0[1] : dy / 2, i = d3.interpolateZoom([ (cx - view.x) / view.k, (cy - view.y) / view.k, dx / view.k ], [ (cx - view1.x) / view1.k, (cy - view1.y) / view1.k, dx / view1.k ]);
	            return function(t) {
	              var l = i(t), k = dx / l[2];
	              this.__chart__ = view = {
	                x: cx - l[0] * k,
	                y: cy - l[1] * k,
	                k: k
	              };
	              zoomed(dispatch);
	            };
	          }).each("interrupt.zoom", function() {
	            zoomended(dispatch);
	          }).each("end.zoom", function() {
	            zoomended(dispatch);
	          });
	        } else {
	          this.__chart__ = view;
	          zoomstarted(dispatch);
	          zoomed(dispatch);
	          zoomended(dispatch);
	        }
	      });
	    };
	    zoom.translate = function(_) {
	      if (!arguments.length) return [ view.x, view.y ];
	      view = {
	        x: +_[0],
	        y: +_[1],
	        k: view.k
	      };
	      rescale();
	      return zoom;
	    };
	    zoom.scale = function(_) {
	      if (!arguments.length) return view.k;
	      view = {
	        x: view.x,
	        y: view.y,
	        k: null
	      };
	      scaleTo(+_);
	      rescale();
	      return zoom;
	    };
	    zoom.scaleExtent = function(_) {
	      if (!arguments.length) return scaleExtent;
	      scaleExtent = _ == null ? d3_behavior_zoomInfinity : [ +_[0], +_[1] ];
	      return zoom;
	    };
	    zoom.center = function(_) {
	      if (!arguments.length) return center;
	      center = _ && [ +_[0], +_[1] ];
	      return zoom;
	    };
	    zoom.size = function(_) {
	      if (!arguments.length) return size;
	      size = _ && [ +_[0], +_[1] ];
	      return zoom;
	    };
	    zoom.duration = function(_) {
	      if (!arguments.length) return duration;
	      duration = +_;
	      return zoom;
	    };
	    zoom.x = function(z) {
	      if (!arguments.length) return x1;
	      x1 = z;
	      x0 = z.copy();
	      view = {
	        x: 0,
	        y: 0,
	        k: 1
	      };
	      return zoom;
	    };
	    zoom.y = function(z) {
	      if (!arguments.length) return y1;
	      y1 = z;
	      y0 = z.copy();
	      view = {
	        x: 0,
	        y: 0,
	        k: 1
	      };
	      return zoom;
	    };
	    function location(p) {
	      return [ (p[0] - view.x) / view.k, (p[1] - view.y) / view.k ];
	    }
	    function point(l) {
	      return [ l[0] * view.k + view.x, l[1] * view.k + view.y ];
	    }
	    function scaleTo(s) {
	      view.k = Math.max(scaleExtent[0], Math.min(scaleExtent[1], s));
	    }
	    function translateTo(p, l) {
	      l = point(l);
	      view.x += p[0] - l[0];
	      view.y += p[1] - l[1];
	    }
	    function zoomTo(that, p, l, k) {
	      that.__chart__ = {
	        x: view.x,
	        y: view.y,
	        k: view.k
	      };
	      scaleTo(Math.pow(2, k));
	      translateTo(center0 = p, l);
	      that = d3.select(that);
	      if (duration > 0) that = that.transition().duration(duration);
	      that.call(zoom.event);
	    }
	    function rescale() {
	      if (x1) x1.domain(x0.range().map(function(x) {
	        return (x - view.x) / view.k;
	      }).map(x0.invert));
	      if (y1) y1.domain(y0.range().map(function(y) {
	        return (y - view.y) / view.k;
	      }).map(y0.invert));
	    }
	    function zoomstarted(dispatch) {
	      if (!zooming++) dispatch({
	        type: "zoomstart"
	      });
	    }
	    function zoomed(dispatch) {
	      rescale();
	      dispatch({
	        type: "zoom",
	        scale: view.k,
	        translate: [ view.x, view.y ]
	      });
	    }
	    function zoomended(dispatch) {
	      if (!--zooming) dispatch({
	        type: "zoomend"
	      }), center0 = null;
	    }
	    function mousedowned() {
	      var that = this, dispatch = event.of(that, arguments), dragged = 0, subject = d3.select(d3_window(that)).on(mousemove, moved).on(mouseup, ended), location0 = location(d3.mouse(that)), dragRestore = d3_event_dragSuppress(that);
	      d3_selection_interrupt.call(that);
	      zoomstarted(dispatch);
	      function moved() {
	        dragged = 1;
	        translateTo(d3.mouse(that), location0);
	        zoomed(dispatch);
	      }
	      function ended() {
	        subject.on(mousemove, null).on(mouseup, null);
	        dragRestore(dragged);
	        zoomended(dispatch);
	      }
	    }
	    function touchstarted() {
	      var that = this, dispatch = event.of(that, arguments), locations0 = {}, distance0 = 0, scale0, zoomName = ".zoom-" + d3.event.changedTouches[0].identifier, touchmove = "touchmove" + zoomName, touchend = "touchend" + zoomName, targets = [], subject = d3.select(that), dragRestore = d3_event_dragSuppress(that);
	      started();
	      zoomstarted(dispatch);
	      subject.on(mousedown, null).on(touchstart, started);
	      function relocate() {
	        var touches = d3.touches(that);
	        scale0 = view.k;
	        touches.forEach(function(t) {
	          if (t.identifier in locations0) locations0[t.identifier] = location(t);
	        });
	        return touches;
	      }
	      function started() {
	        var target = d3.event.target;
	        d3.select(target).on(touchmove, moved).on(touchend, ended);
	        targets.push(target);
	        var changed = d3.event.changedTouches;
	        for (var i = 0, n = changed.length; i < n; ++i) {
	          locations0[changed[i].identifier] = null;
	        }
	        var touches = relocate(), now = Date.now();
	        if (touches.length === 1) {
	          if (now - touchtime < 500) {
	            var p = touches[0];
	            zoomTo(that, p, locations0[p.identifier], Math.floor(Math.log(view.k) / Math.LN2) + 1);
	            d3_eventPreventDefault();
	          }
	          touchtime = now;
	        } else if (touches.length > 1) {
	          var p = touches[0], q = touches[1], dx = p[0] - q[0], dy = p[1] - q[1];
	          distance0 = dx * dx + dy * dy;
	        }
	      }
	      function moved() {
	        var touches = d3.touches(that), p0, l0, p1, l1;
	        d3_selection_interrupt.call(that);
	        for (var i = 0, n = touches.length; i < n; ++i, l1 = null) {
	          p1 = touches[i];
	          if (l1 = locations0[p1.identifier]) {
	            if (l0) break;
	            p0 = p1, l0 = l1;
	          }
	        }
	        if (l1) {
	          var distance1 = (distance1 = p1[0] - p0[0]) * distance1 + (distance1 = p1[1] - p0[1]) * distance1, scale1 = distance0 && Math.sqrt(distance1 / distance0);
	          p0 = [ (p0[0] + p1[0]) / 2, (p0[1] + p1[1]) / 2 ];
	          l0 = [ (l0[0] + l1[0]) / 2, (l0[1] + l1[1]) / 2 ];
	          scaleTo(scale1 * scale0);
	        }
	        touchtime = null;
	        translateTo(p0, l0);
	        zoomed(dispatch);
	      }
	      function ended() {
	        if (d3.event.touches.length) {
	          var changed = d3.event.changedTouches;
	          for (var i = 0, n = changed.length; i < n; ++i) {
	            delete locations0[changed[i].identifier];
	          }
	          for (var identifier in locations0) {
	            return void relocate();
	          }
	        }
	        d3.selectAll(targets).on(zoomName, null);
	        subject.on(mousedown, mousedowned).on(touchstart, touchstarted);
	        dragRestore();
	        zoomended(dispatch);
	      }
	    }
	    function mousewheeled() {
	      var dispatch = event.of(this, arguments);
	      if (mousewheelTimer) clearTimeout(mousewheelTimer); else d3_selection_interrupt.call(this), 
	      translate0 = location(center0 = center || d3.mouse(this)), zoomstarted(dispatch);
	      mousewheelTimer = setTimeout(function() {
	        mousewheelTimer = null;
	        zoomended(dispatch);
	      }, 50);
	      d3_eventPreventDefault();
	      scaleTo(Math.pow(2, d3_behavior_zoomDelta() * .002) * view.k);
	      translateTo(center0, translate0);
	      zoomed(dispatch);
	    }
	    function dblclicked() {
	      var p = d3.mouse(this), k = Math.log(view.k) / Math.LN2;
	      zoomTo(this, p, location(p), d3.event.shiftKey ? Math.ceil(k) - 1 : Math.floor(k) + 1);
	    }
	    return d3.rebind(zoom, event, "on");
	  };
	  var d3_behavior_zoomInfinity = [ 0, Infinity ], d3_behavior_zoomDelta, d3_behavior_zoomWheel;
	  d3.color = d3_color;
	  function d3_color() {}
	  d3_color.prototype.toString = function() {
	    return this.rgb() + "";
	  };
	  d3.hsl = d3_hsl;
	  function d3_hsl(h, s, l) {
	    return this instanceof d3_hsl ? void (this.h = +h, this.s = +s, this.l = +l) : arguments.length < 2 ? h instanceof d3_hsl ? new d3_hsl(h.h, h.s, h.l) : d3_rgb_parse("" + h, d3_rgb_hsl, d3_hsl) : new d3_hsl(h, s, l);
	  }
	  var d3_hslPrototype = d3_hsl.prototype = new d3_color();
	  d3_hslPrototype.brighter = function(k) {
	    k = Math.pow(.7, arguments.length ? k : 1);
	    return new d3_hsl(this.h, this.s, this.l / k);
	  };
	  d3_hslPrototype.darker = function(k) {
	    k = Math.pow(.7, arguments.length ? k : 1);
	    return new d3_hsl(this.h, this.s, k * this.l);
	  };
	  d3_hslPrototype.rgb = function() {
	    return d3_hsl_rgb(this.h, this.s, this.l);
	  };
	  function d3_hsl_rgb(h, s, l) {
	    var m1, m2;
	    h = isNaN(h) ? 0 : (h %= 360) < 0 ? h + 360 : h;
	    s = isNaN(s) ? 0 : s < 0 ? 0 : s > 1 ? 1 : s;
	    l = l < 0 ? 0 : l > 1 ? 1 : l;
	    m2 = l <= .5 ? l * (1 + s) : l + s - l * s;
	    m1 = 2 * l - m2;
	    function v(h) {
	      if (h > 360) h -= 360; else if (h < 0) h += 360;
	      if (h < 60) return m1 + (m2 - m1) * h / 60;
	      if (h < 180) return m2;
	      if (h < 240) return m1 + (m2 - m1) * (240 - h) / 60;
	      return m1;
	    }
	    function vv(h) {
	      return Math.round(v(h) * 255);
	    }
	    return new d3_rgb(vv(h + 120), vv(h), vv(h - 120));
	  }
	  d3.hcl = d3_hcl;
	  function d3_hcl(h, c, l) {
	    return this instanceof d3_hcl ? void (this.h = +h, this.c = +c, this.l = +l) : arguments.length < 2 ? h instanceof d3_hcl ? new d3_hcl(h.h, h.c, h.l) : h instanceof d3_lab ? d3_lab_hcl(h.l, h.a, h.b) : d3_lab_hcl((h = d3_rgb_lab((h = d3.rgb(h)).r, h.g, h.b)).l, h.a, h.b) : new d3_hcl(h, c, l);
	  }
	  var d3_hclPrototype = d3_hcl.prototype = new d3_color();
	  d3_hclPrototype.brighter = function(k) {
	    return new d3_hcl(this.h, this.c, Math.min(100, this.l + d3_lab_K * (arguments.length ? k : 1)));
	  };
	  d3_hclPrototype.darker = function(k) {
	    return new d3_hcl(this.h, this.c, Math.max(0, this.l - d3_lab_K * (arguments.length ? k : 1)));
	  };
	  d3_hclPrototype.rgb = function() {
	    return d3_hcl_lab(this.h, this.c, this.l).rgb();
	  };
	  function d3_hcl_lab(h, c, l) {
	    if (isNaN(h)) h = 0;
	    if (isNaN(c)) c = 0;
	    return new d3_lab(l, Math.cos(h *= d3_radians) * c, Math.sin(h) * c);
	  }
	  d3.lab = d3_lab;
	  function d3_lab(l, a, b) {
	    return this instanceof d3_lab ? void (this.l = +l, this.a = +a, this.b = +b) : arguments.length < 2 ? l instanceof d3_lab ? new d3_lab(l.l, l.a, l.b) : l instanceof d3_hcl ? d3_hcl_lab(l.h, l.c, l.l) : d3_rgb_lab((l = d3_rgb(l)).r, l.g, l.b) : new d3_lab(l, a, b);
	  }
	  var d3_lab_K = 18;
	  var d3_lab_X = .95047, d3_lab_Y = 1, d3_lab_Z = 1.08883;
	  var d3_labPrototype = d3_lab.prototype = new d3_color();
	  d3_labPrototype.brighter = function(k) {
	    return new d3_lab(Math.min(100, this.l + d3_lab_K * (arguments.length ? k : 1)), this.a, this.b);
	  };
	  d3_labPrototype.darker = function(k) {
	    return new d3_lab(Math.max(0, this.l - d3_lab_K * (arguments.length ? k : 1)), this.a, this.b);
	  };
	  d3_labPrototype.rgb = function() {
	    return d3_lab_rgb(this.l, this.a, this.b);
	  };
	  function d3_lab_rgb(l, a, b) {
	    var y = (l + 16) / 116, x = y + a / 500, z = y - b / 200;
	    x = d3_lab_xyz(x) * d3_lab_X;
	    y = d3_lab_xyz(y) * d3_lab_Y;
	    z = d3_lab_xyz(z) * d3_lab_Z;
	    return new d3_rgb(d3_xyz_rgb(3.2404542 * x - 1.5371385 * y - .4985314 * z), d3_xyz_rgb(-.969266 * x + 1.8760108 * y + .041556 * z), d3_xyz_rgb(.0556434 * x - .2040259 * y + 1.0572252 * z));
	  }
	  function d3_lab_hcl(l, a, b) {
	    return l > 0 ? new d3_hcl(Math.atan2(b, a) * d3_degrees, Math.sqrt(a * a + b * b), l) : new d3_hcl(NaN, NaN, l);
	  }
	  function d3_lab_xyz(x) {
	    return x > .206893034 ? x * x * x : (x - 4 / 29) / 7.787037;
	  }
	  function d3_xyz_lab(x) {
	    return x > .008856 ? Math.pow(x, 1 / 3) : 7.787037 * x + 4 / 29;
	  }
	  function d3_xyz_rgb(r) {
	    return Math.round(255 * (r <= .00304 ? 12.92 * r : 1.055 * Math.pow(r, 1 / 2.4) - .055));
	  }
	  d3.rgb = d3_rgb;
	  function d3_rgb(r, g, b) {
	    return this instanceof d3_rgb ? void (this.r = ~~r, this.g = ~~g, this.b = ~~b) : arguments.length < 2 ? r instanceof d3_rgb ? new d3_rgb(r.r, r.g, r.b) : d3_rgb_parse("" + r, d3_rgb, d3_hsl_rgb) : new d3_rgb(r, g, b);
	  }
	  function d3_rgbNumber(value) {
	    return new d3_rgb(value >> 16, value >> 8 & 255, value & 255);
	  }
	  function d3_rgbString(value) {
	    return d3_rgbNumber(value) + "";
	  }
	  var d3_rgbPrototype = d3_rgb.prototype = new d3_color();
	  d3_rgbPrototype.brighter = function(k) {
	    k = Math.pow(.7, arguments.length ? k : 1);
	    var r = this.r, g = this.g, b = this.b, i = 30;
	    if (!r && !g && !b) return new d3_rgb(i, i, i);
	    if (r && r < i) r = i;
	    if (g && g < i) g = i;
	    if (b && b < i) b = i;
	    return new d3_rgb(Math.min(255, r / k), Math.min(255, g / k), Math.min(255, b / k));
	  };
	  d3_rgbPrototype.darker = function(k) {
	    k = Math.pow(.7, arguments.length ? k : 1);
	    return new d3_rgb(k * this.r, k * this.g, k * this.b);
	  };
	  d3_rgbPrototype.hsl = function() {
	    return d3_rgb_hsl(this.r, this.g, this.b);
	  };
	  d3_rgbPrototype.toString = function() {
	    return "#" + d3_rgb_hex(this.r) + d3_rgb_hex(this.g) + d3_rgb_hex(this.b);
	  };
	  function d3_rgb_hex(v) {
	    return v < 16 ? "0" + Math.max(0, v).toString(16) : Math.min(255, v).toString(16);
	  }
	  function d3_rgb_parse(format, rgb, hsl) {
	    var r = 0, g = 0, b = 0, m1, m2, color;
	    m1 = /([a-z]+)\((.*)\)/.exec(format = format.toLowerCase());
	    if (m1) {
	      m2 = m1[2].split(",");
	      switch (m1[1]) {
	       case "hsl":
	        {
	          return hsl(parseFloat(m2[0]), parseFloat(m2[1]) / 100, parseFloat(m2[2]) / 100);
	        }
	
	       case "rgb":
	        {
	          return rgb(d3_rgb_parseNumber(m2[0]), d3_rgb_parseNumber(m2[1]), d3_rgb_parseNumber(m2[2]));
	        }
	      }
	    }
	    if (color = d3_rgb_names.get(format)) {
	      return rgb(color.r, color.g, color.b);
	    }
	    if (format != null && format.charAt(0) === "#" && !isNaN(color = parseInt(format.slice(1), 16))) {
	      if (format.length === 4) {
	        r = (color & 3840) >> 4;
	        r = r >> 4 | r;
	        g = color & 240;
	        g = g >> 4 | g;
	        b = color & 15;
	        b = b << 4 | b;
	      } else if (format.length === 7) {
	        r = (color & 16711680) >> 16;
	        g = (color & 65280) >> 8;
	        b = color & 255;
	      }
	    }
	    return rgb(r, g, b);
	  }
	  function d3_rgb_hsl(r, g, b) {
	    var min = Math.min(r /= 255, g /= 255, b /= 255), max = Math.max(r, g, b), d = max - min, h, s, l = (max + min) / 2;
	    if (d) {
	      s = l < .5 ? d / (max + min) : d / (2 - max - min);
	      if (r == max) h = (g - b) / d + (g < b ? 6 : 0); else if (g == max) h = (b - r) / d + 2; else h = (r - g) / d + 4;
	      h *= 60;
	    } else {
	      h = NaN;
	      s = l > 0 && l < 1 ? 0 : h;
	    }
	    return new d3_hsl(h, s, l);
	  }
	  function d3_rgb_lab(r, g, b) {
	    r = d3_rgb_xyz(r);
	    g = d3_rgb_xyz(g);
	    b = d3_rgb_xyz(b);
	    var x = d3_xyz_lab((.4124564 * r + .3575761 * g + .1804375 * b) / d3_lab_X), y = d3_xyz_lab((.2126729 * r + .7151522 * g + .072175 * b) / d3_lab_Y), z = d3_xyz_lab((.0193339 * r + .119192 * g + .9503041 * b) / d3_lab_Z);
	    return d3_lab(116 * y - 16, 500 * (x - y), 200 * (y - z));
	  }
	  function d3_rgb_xyz(r) {
	    return (r /= 255) <= .04045 ? r / 12.92 : Math.pow((r + .055) / 1.055, 2.4);
	  }
	  function d3_rgb_parseNumber(c) {
	    var f = parseFloat(c);
	    return c.charAt(c.length - 1) === "%" ? Math.round(f * 2.55) : f;
	  }
	  var d3_rgb_names = d3.map({
	    aliceblue: 15792383,
	    antiquewhite: 16444375,
	    aqua: 65535,
	    aquamarine: 8388564,
	    azure: 15794175,
	    beige: 16119260,
	    bisque: 16770244,
	    black: 0,
	    blanchedalmond: 16772045,
	    blue: 255,
	    blueviolet: 9055202,
	    brown: 10824234,
	    burlywood: 14596231,
	    cadetblue: 6266528,
	    chartreuse: 8388352,
	    chocolate: 13789470,
	    coral: 16744272,
	    cornflowerblue: 6591981,
	    cornsilk: 16775388,
	    crimson: 14423100,
	    cyan: 65535,
	    darkblue: 139,
	    darkcyan: 35723,
	    darkgoldenrod: 12092939,
	    darkgray: 11119017,
	    darkgreen: 25600,
	    darkgrey: 11119017,
	    darkkhaki: 12433259,
	    darkmagenta: 9109643,
	    darkolivegreen: 5597999,
	    darkorange: 16747520,
	    darkorchid: 10040012,
	    darkred: 9109504,
	    darksalmon: 15308410,
	    darkseagreen: 9419919,
	    darkslateblue: 4734347,
	    darkslategray: 3100495,
	    darkslategrey: 3100495,
	    darkturquoise: 52945,
	    darkviolet: 9699539,
	    deeppink: 16716947,
	    deepskyblue: 49151,
	    dimgray: 6908265,
	    dimgrey: 6908265,
	    dodgerblue: 2003199,
	    firebrick: 11674146,
	    floralwhite: 16775920,
	    forestgreen: 2263842,
	    fuchsia: 16711935,
	    gainsboro: 14474460,
	    ghostwhite: 16316671,
	    gold: 16766720,
	    goldenrod: 14329120,
	    gray: 8421504,
	    green: 32768,
	    greenyellow: 11403055,
	    grey: 8421504,
	    honeydew: 15794160,
	    hotpink: 16738740,
	    indianred: 13458524,
	    indigo: 4915330,
	    ivory: 16777200,
	    khaki: 15787660,
	    lavender: 15132410,
	    lavenderblush: 16773365,
	    lawngreen: 8190976,
	    lemonchiffon: 16775885,
	    lightblue: 11393254,
	    lightcoral: 15761536,
	    lightcyan: 14745599,
	    lightgoldenrodyellow: 16448210,
	    lightgray: 13882323,
	    lightgreen: 9498256,
	    lightgrey: 13882323,
	    lightpink: 16758465,
	    lightsalmon: 16752762,
	    lightseagreen: 2142890,
	    lightskyblue: 8900346,
	    lightslategray: 7833753,
	    lightslategrey: 7833753,
	    lightsteelblue: 11584734,
	    lightyellow: 16777184,
	    lime: 65280,
	    limegreen: 3329330,
	    linen: 16445670,
	    magenta: 16711935,
	    maroon: 8388608,
	    mediumaquamarine: 6737322,
	    mediumblue: 205,
	    mediumorchid: 12211667,
	    mediumpurple: 9662683,
	    mediumseagreen: 3978097,
	    mediumslateblue: 8087790,
	    mediumspringgreen: 64154,
	    mediumturquoise: 4772300,
	    mediumvioletred: 13047173,
	    midnightblue: 1644912,
	    mintcream: 16121850,
	    mistyrose: 16770273,
	    moccasin: 16770229,
	    navajowhite: 16768685,
	    navy: 128,
	    oldlace: 16643558,
	    olive: 8421376,
	    olivedrab: 7048739,
	    orange: 16753920,
	    orangered: 16729344,
	    orchid: 14315734,
	    palegoldenrod: 15657130,
	    palegreen: 10025880,
	    paleturquoise: 11529966,
	    palevioletred: 14381203,
	    papayawhip: 16773077,
	    peachpuff: 16767673,
	    peru: 13468991,
	    pink: 16761035,
	    plum: 14524637,
	    powderblue: 11591910,
	    purple: 8388736,
	    rebeccapurple: 6697881,
	    red: 16711680,
	    rosybrown: 12357519,
	    royalblue: 4286945,
	    saddlebrown: 9127187,
	    salmon: 16416882,
	    sandybrown: 16032864,
	    seagreen: 3050327,
	    seashell: 16774638,
	    sienna: 10506797,
	    silver: 12632256,
	    skyblue: 8900331,
	    slateblue: 6970061,
	    slategray: 7372944,
	    slategrey: 7372944,
	    snow: 16775930,
	    springgreen: 65407,
	    steelblue: 4620980,
	    tan: 13808780,
	    teal: 32896,
	    thistle: 14204888,
	    tomato: 16737095,
	    turquoise: 4251856,
	    violet: 15631086,
	    wheat: 16113331,
	    white: 16777215,
	    whitesmoke: 16119285,
	    yellow: 16776960,
	    yellowgreen: 10145074
	  });
	  d3_rgb_names.forEach(function(key, value) {
	    d3_rgb_names.set(key, d3_rgbNumber(value));
	  });
	  function d3_functor(v) {
	    return typeof v === "function" ? v : function() {
	      return v;
	    };
	  }
	  d3.functor = d3_functor;
	  d3.xhr = d3_xhrType(d3_identity);
	  function d3_xhrType(response) {
	    return function(url, mimeType, callback) {
	      if (arguments.length === 2 && typeof mimeType === "function") callback = mimeType, 
	      mimeType = null;
	      return d3_xhr(url, mimeType, response, callback);
	    };
	  }
	  function d3_xhr(url, mimeType, response, callback) {
	    var xhr = {}, dispatch = d3.dispatch("beforesend", "progress", "load", "error"), headers = {}, request = new XMLHttpRequest(), responseType = null;
	    if (this.XDomainRequest && !("withCredentials" in request) && /^(http(s)?:)?\/\//.test(url)) request = new XDomainRequest();
	    "onload" in request ? request.onload = request.onerror = respond : request.onreadystatechange = function() {
	      request.readyState > 3 && respond();
	    };
	    function respond() {
	      var status = request.status, result;
	      if (!status && d3_xhrHasResponse(request) || status >= 200 && status < 300 || status === 304) {
	        try {
	          result = response.call(xhr, request);
	        } catch (e) {
	          dispatch.error.call(xhr, e);
	          return;
	        }
	        dispatch.load.call(xhr, result);
	      } else {
	        dispatch.error.call(xhr, request);
	      }
	    }
	    request.onprogress = function(event) {
	      var o = d3.event;
	      d3.event = event;
	      try {
	        dispatch.progress.call(xhr, request);
	      } finally {
	        d3.event = o;
	      }
	    };
	    xhr.header = function(name, value) {
	      name = (name + "").toLowerCase();
	      if (arguments.length < 2) return headers[name];
	      if (value == null) delete headers[name]; else headers[name] = value + "";
	      return xhr;
	    };
	    xhr.mimeType = function(value) {
	      if (!arguments.length) return mimeType;
	      mimeType = value == null ? null : value + "";
	      return xhr;
	    };
	    xhr.responseType = function(value) {
	      if (!arguments.length) return responseType;
	      responseType = value;
	      return xhr;
	    };
	    xhr.response = function(value) {
	      response = value;
	      return xhr;
	    };
	    [ "get", "post" ].forEach(function(method) {
	      xhr[method] = function() {
	        return xhr.send.apply(xhr, [ method ].concat(d3_array(arguments)));
	      };
	    });
	    xhr.send = function(method, data, callback) {
	      if (arguments.length === 2 && typeof data === "function") callback = data, data = null;
	      request.open(method, url, true);
	      if (mimeType != null && !("accept" in headers)) headers["accept"] = mimeType + ",*/*";
	      if (request.setRequestHeader) for (var name in headers) request.setRequestHeader(name, headers[name]);
	      if (mimeType != null && request.overrideMimeType) request.overrideMimeType(mimeType);
	      if (responseType != null) request.responseType = responseType;
	      if (callback != null) xhr.on("error", callback).on("load", function(request) {
	        callback(null, request);
	      });
	      dispatch.beforesend.call(xhr, request);
	      request.send(data == null ? null : data);
	      return xhr;
	    };
	    xhr.abort = function() {
	      request.abort();
	      return xhr;
	    };
	    d3.rebind(xhr, dispatch, "on");
	    return callback == null ? xhr : xhr.get(d3_xhr_fixCallback(callback));
	  }
	  function d3_xhr_fixCallback(callback) {
	    return callback.length === 1 ? function(error, request) {
	      callback(error == null ? request : null);
	    } : callback;
	  }
	  function d3_xhrHasResponse(request) {
	    var type = request.responseType;
	    return type && type !== "text" ? request.response : request.responseText;
	  }
	  d3.dsv = function(delimiter, mimeType) {
	    var reFormat = new RegExp('["' + delimiter + "\n]"), delimiterCode = delimiter.charCodeAt(0);
	    function dsv(url, row, callback) {
	      if (arguments.length < 3) callback = row, row = null;
	      var xhr = d3_xhr(url, mimeType, row == null ? response : typedResponse(row), callback);
	      xhr.row = function(_) {
	        return arguments.length ? xhr.response((row = _) == null ? response : typedResponse(_)) : row;
	      };
	      return xhr;
	    }
	    function response(request) {
	      return dsv.parse(request.responseText);
	    }
	    function typedResponse(f) {
	      return function(request) {
	        return dsv.parse(request.responseText, f);
	      };
	    }
	    dsv.parse = function(text, f) {
	      var o;
	      return dsv.parseRows(text, function(row, i) {
	        if (o) return o(row, i - 1);
	        var a = new Function("d", "return {" + row.map(function(name, i) {
	          return JSON.stringify(name) + ": d[" + i + "]";
	        }).join(",") + "}");
	        o = f ? function(row, i) {
	          return f(a(row), i);
	        } : a;
	      });
	    };
	    dsv.parseRows = function(text, f) {
	      var EOL = {}, EOF = {}, rows = [], N = text.length, I = 0, n = 0, t, eol;
	      function token() {
	        if (I >= N) return EOF;
	        if (eol) return eol = false, EOL;
	        var j = I;
	        if (text.charCodeAt(j) === 34) {
	          var i = j;
	          while (i++ < N) {
	            if (text.charCodeAt(i) === 34) {
	              if (text.charCodeAt(i + 1) !== 34) break;
	              ++i;
	            }
	          }
	          I = i + 2;
	          var c = text.charCodeAt(i + 1);
	          if (c === 13) {
	            eol = true;
	            if (text.charCodeAt(i + 2) === 10) ++I;
	          } else if (c === 10) {
	            eol = true;
	          }
	          return text.slice(j + 1, i).replace(/""/g, '"');
	        }
	        while (I < N) {
	          var c = text.charCodeAt(I++), k = 1;
	          if (c === 10) eol = true; else if (c === 13) {
	            eol = true;
	            if (text.charCodeAt(I) === 10) ++I, ++k;
	          } else if (c !== delimiterCode) continue;
	          return text.slice(j, I - k);
	        }
	        return text.slice(j);
	      }
	      while ((t = token()) !== EOF) {
	        var a = [];
	        while (t !== EOL && t !== EOF) {
	          a.push(t);
	          t = token();
	        }
	        if (f && (a = f(a, n++)) == null) continue;
	        rows.push(a);
	      }
	      return rows;
	    };
	    dsv.format = function(rows) {
	      if (Array.isArray(rows[0])) return dsv.formatRows(rows);
	      var fieldSet = new d3_Set(), fields = [];
	      rows.forEach(function(row) {
	        for (var field in row) {
	          if (!fieldSet.has(field)) {
	            fields.push(fieldSet.add(field));
	          }
	        }
	      });
	      return [ fields.map(formatValue).join(delimiter) ].concat(rows.map(function(row) {
	        return fields.map(function(field) {
	          return formatValue(row[field]);
	        }).join(delimiter);
	      })).join("\n");
	    };
	    dsv.formatRows = function(rows) {
	      return rows.map(formatRow).join("\n");
	    };
	    function formatRow(row) {
	      return row.map(formatValue).join(delimiter);
	    }
	    function formatValue(text) {
	      return reFormat.test(text) ? '"' + text.replace(/\"/g, '""') + '"' : text;
	    }
	    return dsv;
	  };
	  d3.csv = d3.dsv(",", "text/csv");
	  d3.tsv = d3.dsv("	", "text/tab-separated-values");
	  var d3_timer_queueHead, d3_timer_queueTail, d3_timer_interval, d3_timer_timeout, d3_timer_frame = this[d3_vendorSymbol(this, "requestAnimationFrame")] || function(callback) {
	    setTimeout(callback, 17);
	  };
	  d3.timer = function() {
	    d3_timer.apply(this, arguments);
	  };
	  function d3_timer(callback, delay, then) {
	    var n = arguments.length;
	    if (n < 2) delay = 0;
	    if (n < 3) then = Date.now();
	    var time = then + delay, timer = {
	      c: callback,
	      t: time,
	      n: null
	    };
	    if (d3_timer_queueTail) d3_timer_queueTail.n = timer; else d3_timer_queueHead = timer;
	    d3_timer_queueTail = timer;
	    if (!d3_timer_interval) {
	      d3_timer_timeout = clearTimeout(d3_timer_timeout);
	      d3_timer_interval = 1;
	      d3_timer_frame(d3_timer_step);
	    }
	    return timer;
	  }
	  function d3_timer_step() {
	    var now = d3_timer_mark(), delay = d3_timer_sweep() - now;
	    if (delay > 24) {
	      if (isFinite(delay)) {
	        clearTimeout(d3_timer_timeout);
	        d3_timer_timeout = setTimeout(d3_timer_step, delay);
	      }
	      d3_timer_interval = 0;
	    } else {
	      d3_timer_interval = 1;
	      d3_timer_frame(d3_timer_step);
	    }
	  }
	  d3.timer.flush = function() {
	    d3_timer_mark();
	    d3_timer_sweep();
	  };
	  function d3_timer_mark() {
	    var now = Date.now(), timer = d3_timer_queueHead;
	    while (timer) {
	      if (now >= timer.t && timer.c(now - timer.t)) timer.c = null;
	      timer = timer.n;
	    }
	    return now;
	  }
	  function d3_timer_sweep() {
	    var t0, t1 = d3_timer_queueHead, time = Infinity;
	    while (t1) {
	      if (t1.c) {
	        if (t1.t < time) time = t1.t;
	        t1 = (t0 = t1).n;
	      } else {
	        t1 = t0 ? t0.n = t1.n : d3_timer_queueHead = t1.n;
	      }
	    }
	    d3_timer_queueTail = t0;
	    return time;
	  }
	  function d3_format_precision(x, p) {
	    return p - (x ? Math.ceil(Math.log(x) / Math.LN10) : 1);
	  }
	  d3.round = function(x, n) {
	    return n ? Math.round(x * (n = Math.pow(10, n))) / n : Math.round(x);
	  };
	  var d3_formatPrefixes = [ "y", "z", "a", "f", "p", "n", "µ", "m", "", "k", "M", "G", "T", "P", "E", "Z", "Y" ].map(d3_formatPrefix);
	  d3.formatPrefix = function(value, precision) {
	    var i = 0;
	    if (value = +value) {
	      if (value < 0) value *= -1;
	      if (precision) value = d3.round(value, d3_format_precision(value, precision));
	      i = 1 + Math.floor(1e-12 + Math.log(value) / Math.LN10);
	      i = Math.max(-24, Math.min(24, Math.floor((i - 1) / 3) * 3));
	    }
	    return d3_formatPrefixes[8 + i / 3];
	  };
	  function d3_formatPrefix(d, i) {
	    var k = Math.pow(10, abs(8 - i) * 3);
	    return {
	      scale: i > 8 ? function(d) {
	        return d / k;
	      } : function(d) {
	        return d * k;
	      },
	      symbol: d
	    };
	  }
	  function d3_locale_numberFormat(locale) {
	    var locale_decimal = locale.decimal, locale_thousands = locale.thousands, locale_grouping = locale.grouping, locale_currency = locale.currency, formatGroup = locale_grouping && locale_thousands ? function(value, width) {
	      var i = value.length, t = [], j = 0, g = locale_grouping[0], length = 0;
	      while (i > 0 && g > 0) {
	        if (length + g + 1 > width) g = Math.max(1, width - length);
	        t.push(value.substring(i -= g, i + g));
	        if ((length += g + 1) > width) break;
	        g = locale_grouping[j = (j + 1) % locale_grouping.length];
	      }
	      return t.reverse().join(locale_thousands);
	    } : d3_identity;
	    return function(specifier) {
	      var match = d3_format_re.exec(specifier), fill = match[1] || " ", align = match[2] || ">", sign = match[3] || "-", symbol = match[4] || "", zfill = match[5], width = +match[6], comma = match[7], precision = match[8], type = match[9], scale = 1, prefix = "", suffix = "", integer = false, exponent = true;
	      if (precision) precision = +precision.substring(1);
	      if (zfill || fill === "0" && align === "=") {
	        zfill = fill = "0";
	        align = "=";
	      }
	      switch (type) {
	       case "n":
	        comma = true;
	        type = "g";
	        break;
	
	       case "%":
	        scale = 100;
	        suffix = "%";
	        type = "f";
	        break;
	
	       case "p":
	        scale = 100;
	        suffix = "%";
	        type = "r";
	        break;
	
	       case "b":
	       case "o":
	       case "x":
	       case "X":
	        if (symbol === "#") prefix = "0" + type.toLowerCase();
	
	       case "c":
	        exponent = false;
	
	       case "d":
	        integer = true;
	        precision = 0;
	        break;
	
	       case "s":
	        scale = -1;
	        type = "r";
	        break;
	      }
	      if (symbol === "$") prefix = locale_currency[0], suffix = locale_currency[1];
	      if (type == "r" && !precision) type = "g";
	      if (precision != null) {
	        if (type == "g") precision = Math.max(1, Math.min(21, precision)); else if (type == "e" || type == "f") precision = Math.max(0, Math.min(20, precision));
	      }
	      type = d3_format_types.get(type) || d3_format_typeDefault;
	      var zcomma = zfill && comma;
	      return function(value) {
	        var fullSuffix = suffix;
	        if (integer && value % 1) return "";
	        var negative = value < 0 || value === 0 && 1 / value < 0 ? (value = -value, "-") : sign === "-" ? "" : sign;
	        if (scale < 0) {
	          var unit = d3.formatPrefix(value, precision);
	          value = unit.scale(value);
	          fullSuffix = unit.symbol + suffix;
	        } else {
	          value *= scale;
	        }
	        value = type(value, precision);
	        var i = value.lastIndexOf("."), before, after;
	        if (i < 0) {
	          var j = exponent ? value.lastIndexOf("e") : -1;
	          if (j < 0) before = value, after = ""; else before = value.substring(0, j), after = value.substring(j);
	        } else {
	          before = value.substring(0, i);
	          after = locale_decimal + value.substring(i + 1);
	        }
	        if (!zfill && comma) before = formatGroup(before, Infinity);
	        var length = prefix.length + before.length + after.length + (zcomma ? 0 : negative.length), padding = length < width ? new Array(length = width - length + 1).join(fill) : "";
	        if (zcomma) before = formatGroup(padding + before, padding.length ? width - after.length : Infinity);
	        negative += prefix;
	        value = before + after;
	        return (align === "<" ? negative + value + padding : align === ">" ? padding + negative + value : align === "^" ? padding.substring(0, length >>= 1) + negative + value + padding.substring(length) : negative + (zcomma ? value : padding + value)) + fullSuffix;
	      };
	    };
	  }
	  var d3_format_re = /(?:([^{])?([<>=^]))?([+\- ])?([$#])?(0)?(\d+)?(,)?(\.-?\d+)?([a-z%])?/i;
	  var d3_format_types = d3.map({
	    b: function(x) {
	      return x.toString(2);
	    },
	    c: function(x) {
	      return String.fromCharCode(x);
	    },
	    o: function(x) {
	      return x.toString(8);
	    },
	    x: function(x) {
	      return x.toString(16);
	    },
	    X: function(x) {
	      return x.toString(16).toUpperCase();
	    },
	    g: function(x, p) {
	      return x.toPrecision(p);
	    },
	    e: function(x, p) {
	      return x.toExponential(p);
	    },
	    f: function(x, p) {
	      return x.toFixed(p);
	    },
	    r: function(x, p) {
	      return (x = d3.round(x, d3_format_precision(x, p))).toFixed(Math.max(0, Math.min(20, d3_format_precision(x * (1 + 1e-15), p))));
	    }
	  });
	  function d3_format_typeDefault(x) {
	    return x + "";
	  }
	  var d3_time = d3.time = {}, d3_date = Date;
	  function d3_date_utc() {
	    this._ = new Date(arguments.length > 1 ? Date.UTC.apply(this, arguments) : arguments[0]);
	  }
	  d3_date_utc.prototype = {
	    getDate: function() {
	      return this._.getUTCDate();
	    },
	    getDay: function() {
	      return this._.getUTCDay();
	    },
	    getFullYear: function() {
	      return this._.getUTCFullYear();
	    },
	    getHours: function() {
	      return this._.getUTCHours();
	    },
	    getMilliseconds: function() {
	      return this._.getUTCMilliseconds();
	    },
	    getMinutes: function() {
	      return this._.getUTCMinutes();
	    },
	    getMonth: function() {
	      return this._.getUTCMonth();
	    },
	    getSeconds: function() {
	      return this._.getUTCSeconds();
	    },
	    getTime: function() {
	      return this._.getTime();
	    },
	    getTimezoneOffset: function() {
	      return 0;
	    },
	    valueOf: function() {
	      return this._.valueOf();
	    },
	    setDate: function() {
	      d3_time_prototype.setUTCDate.apply(this._, arguments);
	    },
	    setDay: function() {
	      d3_time_prototype.setUTCDay.apply(this._, arguments);
	    },
	    setFullYear: function() {
	      d3_time_prototype.setUTCFullYear.apply(this._, arguments);
	    },
	    setHours: function() {
	      d3_time_prototype.setUTCHours.apply(this._, arguments);
	    },
	    setMilliseconds: function() {
	      d3_time_prototype.setUTCMilliseconds.apply(this._, arguments);
	    },
	    setMinutes: function() {
	      d3_time_prototype.setUTCMinutes.apply(this._, arguments);
	    },
	    setMonth: function() {
	      d3_time_prototype.setUTCMonth.apply(this._, arguments);
	    },
	    setSeconds: function() {
	      d3_time_prototype.setUTCSeconds.apply(this._, arguments);
	    },
	    setTime: function() {
	      d3_time_prototype.setTime.apply(this._, arguments);
	    }
	  };
	  var d3_time_prototype = Date.prototype;
	  function d3_time_interval(local, step, number) {
	    function round(date) {
	      var d0 = local(date), d1 = offset(d0, 1);
	      return date - d0 < d1 - date ? d0 : d1;
	    }
	    function ceil(date) {
	      step(date = local(new d3_date(date - 1)), 1);
	      return date;
	    }
	    function offset(date, k) {
	      step(date = new d3_date(+date), k);
	      return date;
	    }
	    function range(t0, t1, dt) {
	      var time = ceil(t0), times = [];
	      if (dt > 1) {
	        while (time < t1) {
	          if (!(number(time) % dt)) times.push(new Date(+time));
	          step(time, 1);
	        }
	      } else {
	        while (time < t1) times.push(new Date(+time)), step(time, 1);
	      }
	      return times;
	    }
	    function range_utc(t0, t1, dt) {
	      try {
	        d3_date = d3_date_utc;
	        var utc = new d3_date_utc();
	        utc._ = t0;
	        return range(utc, t1, dt);
	      } finally {
	        d3_date = Date;
	      }
	    }
	    local.floor = local;
	    local.round = round;
	    local.ceil = ceil;
	    local.offset = offset;
	    local.range = range;
	    var utc = local.utc = d3_time_interval_utc(local);
	    utc.floor = utc;
	    utc.round = d3_time_interval_utc(round);
	    utc.ceil = d3_time_interval_utc(ceil);
	    utc.offset = d3_time_interval_utc(offset);
	    utc.range = range_utc;
	    return local;
	  }
	  function d3_time_interval_utc(method) {
	    return function(date, k) {
	      try {
	        d3_date = d3_date_utc;
	        var utc = new d3_date_utc();
	        utc._ = date;
	        return method(utc, k)._;
	      } finally {
	        d3_date = Date;
	      }
	    };
	  }
	  d3_time.year = d3_time_interval(function(date) {
	    date = d3_time.day(date);
	    date.setMonth(0, 1);
	    return date;
	  }, function(date, offset) {
	    date.setFullYear(date.getFullYear() + offset);
	  }, function(date) {
	    return date.getFullYear();
	  });
	  d3_time.years = d3_time.year.range;
	  d3_time.years.utc = d3_time.year.utc.range;
	  d3_time.day = d3_time_interval(function(date) {
	    var day = new d3_date(2e3, 0);
	    day.setFullYear(date.getFullYear(), date.getMonth(), date.getDate());
	    return day;
	  }, function(date, offset) {
	    date.setDate(date.getDate() + offset);
	  }, function(date) {
	    return date.getDate() - 1;
	  });
	  d3_time.days = d3_time.day.range;
	  d3_time.days.utc = d3_time.day.utc.range;
	  d3_time.dayOfYear = function(date) {
	    var year = d3_time.year(date);
	    return Math.floor((date - year - (date.getTimezoneOffset() - year.getTimezoneOffset()) * 6e4) / 864e5);
	  };
	  [ "sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday" ].forEach(function(day, i) {
	    i = 7 - i;
	    var interval = d3_time[day] = d3_time_interval(function(date) {
	      (date = d3_time.day(date)).setDate(date.getDate() - (date.getDay() + i) % 7);
	      return date;
	    }, function(date, offset) {
	      date.setDate(date.getDate() + Math.floor(offset) * 7);
	    }, function(date) {
	      var day = d3_time.year(date).getDay();
	      return Math.floor((d3_time.dayOfYear(date) + (day + i) % 7) / 7) - (day !== i);
	    });
	    d3_time[day + "s"] = interval.range;
	    d3_time[day + "s"].utc = interval.utc.range;
	    d3_time[day + "OfYear"] = function(date) {
	      var day = d3_time.year(date).getDay();
	      return Math.floor((d3_time.dayOfYear(date) + (day + i) % 7) / 7);
	    };
	  });
	  d3_time.week = d3_time.sunday;
	  d3_time.weeks = d3_time.sunday.range;
	  d3_time.weeks.utc = d3_time.sunday.utc.range;
	  d3_time.weekOfYear = d3_time.sundayOfYear;
	  function d3_locale_timeFormat(locale) {
	    var locale_dateTime = locale.dateTime, locale_date = locale.date, locale_time = locale.time, locale_periods = locale.periods, locale_days = locale.days, locale_shortDays = locale.shortDays, locale_months = locale.months, locale_shortMonths = locale.shortMonths;
	    function d3_time_format(template) {
	      var n = template.length;
	      function format(date) {
	        var string = [], i = -1, j = 0, c, p, f;
	        while (++i < n) {
	          if (template.charCodeAt(i) === 37) {
	            string.push(template.slice(j, i));
	            if ((p = d3_time_formatPads[c = template.charAt(++i)]) != null) c = template.charAt(++i);
	            if (f = d3_time_formats[c]) c = f(date, p == null ? c === "e" ? " " : "0" : p);
	            string.push(c);
	            j = i + 1;
	          }
	        }
	        string.push(template.slice(j, i));
	        return string.join("");
	      }
	      format.parse = function(string) {
	        var d = {
	          y: 1900,
	          m: 0,
	          d: 1,
	          H: 0,
	          M: 0,
	          S: 0,
	          L: 0,
	          Z: null
	        }, i = d3_time_parse(d, template, string, 0);
	        if (i != string.length) return null;
	        if ("p" in d) d.H = d.H % 12 + d.p * 12;
	        var localZ = d.Z != null && d3_date !== d3_date_utc, date = new (localZ ? d3_date_utc : d3_date)();
	        if ("j" in d) date.setFullYear(d.y, 0, d.j); else if ("W" in d || "U" in d) {
	          if (!("w" in d)) d.w = "W" in d ? 1 : 0;
	          date.setFullYear(d.y, 0, 1);
	          date.setFullYear(d.y, 0, "W" in d ? (d.w + 6) % 7 + d.W * 7 - (date.getDay() + 5) % 7 : d.w + d.U * 7 - (date.getDay() + 6) % 7);
	        } else date.setFullYear(d.y, d.m, d.d);
	        date.setHours(d.H + (d.Z / 100 | 0), d.M + d.Z % 100, d.S, d.L);
	        return localZ ? date._ : date;
	      };
	      format.toString = function() {
	        return template;
	      };
	      return format;
	    }
	    function d3_time_parse(date, template, string, j) {
	      var c, p, t, i = 0, n = template.length, m = string.length;
	      while (i < n) {
	        if (j >= m) return -1;
	        c = template.charCodeAt(i++);
	        if (c === 37) {
	          t = template.charAt(i++);
	          p = d3_time_parsers[t in d3_time_formatPads ? template.charAt(i++) : t];
	          if (!p || (j = p(date, string, j)) < 0) return -1;
	        } else if (c != string.charCodeAt(j++)) {
	          return -1;
	        }
	      }
	      return j;
	    }
	    d3_time_format.utc = function(template) {
	      var local = d3_time_format(template);
	      function format(date) {
	        try {
	          d3_date = d3_date_utc;
	          var utc = new d3_date();
	          utc._ = date;
	          return local(utc);
	        } finally {
	          d3_date = Date;
	        }
	      }
	      format.parse = function(string) {
	        try {
	          d3_date = d3_date_utc;
	          var date = local.parse(string);
	          return date && date._;
	        } finally {
	          d3_date = Date;
	        }
	      };
	      format.toString = local.toString;
	      return format;
	    };
	    d3_time_format.multi = d3_time_format.utc.multi = d3_time_formatMulti;
	    var d3_time_periodLookup = d3.map(), d3_time_dayRe = d3_time_formatRe(locale_days), d3_time_dayLookup = d3_time_formatLookup(locale_days), d3_time_dayAbbrevRe = d3_time_formatRe(locale_shortDays), d3_time_dayAbbrevLookup = d3_time_formatLookup(locale_shortDays), d3_time_monthRe = d3_time_formatRe(locale_months), d3_time_monthLookup = d3_time_formatLookup(locale_months), d3_time_monthAbbrevRe = d3_time_formatRe(locale_shortMonths), d3_time_monthAbbrevLookup = d3_time_formatLookup(locale_shortMonths);
	    locale_periods.forEach(function(p, i) {
	      d3_time_periodLookup.set(p.toLowerCase(), i);
	    });
	    var d3_time_formats = {
	      a: function(d) {
	        return locale_shortDays[d.getDay()];
	      },
	      A: function(d) {
	        return locale_days[d.getDay()];
	      },
	      b: function(d) {
	        return locale_shortMonths[d.getMonth()];
	      },
	      B: function(d) {
	        return locale_months[d.getMonth()];
	      },
	      c: d3_time_format(locale_dateTime),
	      d: function(d, p) {
	        return d3_time_formatPad(d.getDate(), p, 2);
	      },
	      e: function(d, p) {
	        return d3_time_formatPad(d.getDate(), p, 2);
	      },
	      H: function(d, p) {
	        return d3_time_formatPad(d.getHours(), p, 2);
	      },
	      I: function(d, p) {
	        return d3_time_formatPad(d.getHours() % 12 || 12, p, 2);
	      },
	      j: function(d, p) {
	        return d3_time_formatPad(1 + d3_time.dayOfYear(d), p, 3);
	      },
	      L: function(d, p) {
	        return d3_time_formatPad(d.getMilliseconds(), p, 3);
	      },
	      m: function(d, p) {
	        return d3_time_formatPad(d.getMonth() + 1, p, 2);
	      },
	      M: function(d, p) {
	        return d3_time_formatPad(d.getMinutes(), p, 2);
	      },
	      p: function(d) {
	        return locale_periods[+(d.getHours() >= 12)];
	      },
	      S: function(d, p) {
	        return d3_time_formatPad(d.getSeconds(), p, 2);
	      },
	      U: function(d, p) {
	        return d3_time_formatPad(d3_time.sundayOfYear(d), p, 2);
	      },
	      w: function(d) {
	        return d.getDay();
	      },
	      W: function(d, p) {
	        return d3_time_formatPad(d3_time.mondayOfYear(d), p, 2);
	      },
	      x: d3_time_format(locale_date),
	      X: d3_time_format(locale_time),
	      y: function(d, p) {
	        return d3_time_formatPad(d.getFullYear() % 100, p, 2);
	      },
	      Y: function(d, p) {
	        return d3_time_formatPad(d.getFullYear() % 1e4, p, 4);
	      },
	      Z: d3_time_zone,
	      "%": function() {
	        return "%";
	      }
	    };
	    var d3_time_parsers = {
	      a: d3_time_parseWeekdayAbbrev,
	      A: d3_time_parseWeekday,
	      b: d3_time_parseMonthAbbrev,
	      B: d3_time_parseMonth,
	      c: d3_time_parseLocaleFull,
	      d: d3_time_parseDay,
	      e: d3_time_parseDay,
	      H: d3_time_parseHour24,
	      I: d3_time_parseHour24,
	      j: d3_time_parseDayOfYear,
	      L: d3_time_parseMilliseconds,
	      m: d3_time_parseMonthNumber,
	      M: d3_time_parseMinutes,
	      p: d3_time_parseAmPm,
	      S: d3_time_parseSeconds,
	      U: d3_time_parseWeekNumberSunday,
	      w: d3_time_parseWeekdayNumber,
	      W: d3_time_parseWeekNumberMonday,
	      x: d3_time_parseLocaleDate,
	      X: d3_time_parseLocaleTime,
	      y: d3_time_parseYear,
	      Y: d3_time_parseFullYear,
	      Z: d3_time_parseZone,
	      "%": d3_time_parseLiteralPercent
	    };
	    function d3_time_parseWeekdayAbbrev(date, string, i) {
	      d3_time_dayAbbrevRe.lastIndex = 0;
	      var n = d3_time_dayAbbrevRe.exec(string.slice(i));
	      return n ? (date.w = d3_time_dayAbbrevLookup.get(n[0].toLowerCase()), i + n[0].length) : -1;
	    }
	    function d3_time_parseWeekday(date, string, i) {
	      d3_time_dayRe.lastIndex = 0;
	      var n = d3_time_dayRe.exec(string.slice(i));
	      return n ? (date.w = d3_time_dayLookup.get(n[0].toLowerCase()), i + n[0].length) : -1;
	    }
	    function d3_time_parseMonthAbbrev(date, string, i) {
	      d3_time_monthAbbrevRe.lastIndex = 0;
	      var n = d3_time_monthAbbrevRe.exec(string.slice(i));
	      return n ? (date.m = d3_time_monthAbbrevLookup.get(n[0].toLowerCase()), i + n[0].length) : -1;
	    }
	    function d3_time_parseMonth(date, string, i) {
	      d3_time_monthRe.lastIndex = 0;
	      var n = d3_time_monthRe.exec(string.slice(i));
	      return n ? (date.m = d3_time_monthLookup.get(n[0].toLowerCase()), i + n[0].length) : -1;
	    }
	    function d3_time_parseLocaleFull(date, string, i) {
	      return d3_time_parse(date, d3_time_formats.c.toString(), string, i);
	    }
	    function d3_time_parseLocaleDate(date, string, i) {
	      return d3_time_parse(date, d3_time_formats.x.toString(), string, i);
	    }
	    function d3_time_parseLocaleTime(date, string, i) {
	      return d3_time_parse(date, d3_time_formats.X.toString(), string, i);
	    }
	    function d3_time_parseAmPm(date, string, i) {
	      var n = d3_time_periodLookup.get(string.slice(i, i += 2).toLowerCase());
	      return n == null ? -1 : (date.p = n, i);
	    }
	    return d3_time_format;
	  }
	  var d3_time_formatPads = {
	    "-": "",
	    _: " ",
	    "0": "0"
	  }, d3_time_numberRe = /^\s*\d+/, d3_time_percentRe = /^%/;
	  function d3_time_formatPad(value, fill, width) {
	    var sign = value < 0 ? "-" : "", string = (sign ? -value : value) + "", length = string.length;
	    return sign + (length < width ? new Array(width - length + 1).join(fill) + string : string);
	  }
	  function d3_time_formatRe(names) {
	    return new RegExp("^(?:" + names.map(d3.requote).join("|") + ")", "i");
	  }
	  function d3_time_formatLookup(names) {
	    var map = new d3_Map(), i = -1, n = names.length;
	    while (++i < n) map.set(names[i].toLowerCase(), i);
	    return map;
	  }
	  function d3_time_parseWeekdayNumber(date, string, i) {
	    d3_time_numberRe.lastIndex = 0;
	    var n = d3_time_numberRe.exec(string.slice(i, i + 1));
	    return n ? (date.w = +n[0], i + n[0].length) : -1;
	  }
	  function d3_time_parseWeekNumberSunday(date, string, i) {
	    d3_time_numberRe.lastIndex = 0;
	    var n = d3_time_numberRe.exec(string.slice(i));
	    return n ? (date.U = +n[0], i + n[0].length) : -1;
	  }
	  function d3_time_parseWeekNumberMonday(date, string, i) {
	    d3_time_numberRe.lastIndex = 0;
	    var n = d3_time_numberRe.exec(string.slice(i));
	    return n ? (date.W = +n[0], i + n[0].length) : -1;
	  }
	  function d3_time_parseFullYear(date, string, i) {
	    d3_time_numberRe.lastIndex = 0;
	    var n = d3_time_numberRe.exec(string.slice(i, i + 4));
	    return n ? (date.y = +n[0], i + n[0].length) : -1;
	  }
	  function d3_time_parseYear(date, string, i) {
	    d3_time_numberRe.lastIndex = 0;
	    var n = d3_time_numberRe.exec(string.slice(i, i + 2));
	    return n ? (date.y = d3_time_expandYear(+n[0]), i + n[0].length) : -1;
	  }
	  function d3_time_parseZone(date, string, i) {
	    return /^[+-]\d{4}$/.test(string = string.slice(i, i + 5)) ? (date.Z = -string, 
	    i + 5) : -1;
	  }
	  function d3_time_expandYear(d) {
	    return d + (d > 68 ? 1900 : 2e3);
	  }
	  function d3_time_parseMonthNumber(date, string, i) {
	    d3_time_numberRe.lastIndex = 0;
	    var n = d3_time_numberRe.exec(string.slice(i, i + 2));
	    return n ? (date.m = n[0] - 1, i + n[0].length) : -1;
	  }
	  function d3_time_parseDay(date, string, i) {
	    d3_time_numberRe.lastIndex = 0;
	    var n = d3_time_numberRe.exec(string.slice(i, i + 2));
	    return n ? (date.d = +n[0], i + n[0].length) : -1;
	  }
	  function d3_time_parseDayOfYear(date, string, i) {
	    d3_time_numberRe.lastIndex = 0;
	    var n = d3_time_numberRe.exec(string.slice(i, i + 3));
	    return n ? (date.j = +n[0], i + n[0].length) : -1;
	  }
	  function d3_time_parseHour24(date, string, i) {
	    d3_time_numberRe.lastIndex = 0;
	    var n = d3_time_numberRe.exec(string.slice(i, i + 2));
	    return n ? (date.H = +n[0], i + n[0].length) : -1;
	  }
	  function d3_time_parseMinutes(date, string, i) {
	    d3_time_numberRe.lastIndex = 0;
	    var n = d3_time_numberRe.exec(string.slice(i, i + 2));
	    return n ? (date.M = +n[0], i + n[0].length) : -1;
	  }
	  function d3_time_parseSeconds(date, string, i) {
	    d3_time_numberRe.lastIndex = 0;
	    var n = d3_time_numberRe.exec(string.slice(i, i + 2));
	    return n ? (date.S = +n[0], i + n[0].length) : -1;
	  }
	  function d3_time_parseMilliseconds(date, string, i) {
	    d3_time_numberRe.lastIndex = 0;
	    var n = d3_time_numberRe.exec(string.slice(i, i + 3));
	    return n ? (date.L = +n[0], i + n[0].length) : -1;
	  }
	  function d3_time_zone(d) {
	    var z = d.getTimezoneOffset(), zs = z > 0 ? "-" : "+", zh = abs(z) / 60 | 0, zm = abs(z) % 60;
	    return zs + d3_time_formatPad(zh, "0", 2) + d3_time_formatPad(zm, "0", 2);
	  }
	  function d3_time_parseLiteralPercent(date, string, i) {
	    d3_time_percentRe.lastIndex = 0;
	    var n = d3_time_percentRe.exec(string.slice(i, i + 1));
	    return n ? i + n[0].length : -1;
	  }
	  function d3_time_formatMulti(formats) {
	    var n = formats.length, i = -1;
	    while (++i < n) formats[i][0] = this(formats[i][0]);
	    return function(date) {
	      var i = 0, f = formats[i];
	      while (!f[1](date)) f = formats[++i];
	      return f[0](date);
	    };
	  }
	  d3.locale = function(locale) {
	    return {
	      numberFormat: d3_locale_numberFormat(locale),
	      timeFormat: d3_locale_timeFormat(locale)
	    };
	  };
	  var d3_locale_enUS = d3.locale({
	    decimal: ".",
	    thousands: ",",
	    grouping: [ 3 ],
	    currency: [ "$", "" ],
	    dateTime: "%a %b %e %X %Y",
	    date: "%m/%d/%Y",
	    time: "%H:%M:%S",
	    periods: [ "AM", "PM" ],
	    days: [ "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" ],
	    shortDays: [ "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" ],
	    months: [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ],
	    shortMonths: [ "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" ]
	  });
	  d3.format = d3_locale_enUS.numberFormat;
	  d3.geo = {};
	  function d3_adder() {}
	  d3_adder.prototype = {
	    s: 0,
	    t: 0,
	    add: function(y) {
	      d3_adderSum(y, this.t, d3_adderTemp);
	      d3_adderSum(d3_adderTemp.s, this.s, this);
	      if (this.s) this.t += d3_adderTemp.t; else this.s = d3_adderTemp.t;
	    },
	    reset: function() {
	      this.s = this.t = 0;
	    },
	    valueOf: function() {
	      return this.s;
	    }
	  };
	  var d3_adderTemp = new d3_adder();
	  function d3_adderSum(a, b, o) {
	    var x = o.s = a + b, bv = x - a, av = x - bv;
	    o.t = a - av + (b - bv);
	  }
	  d3.geo.stream = function(object, listener) {
	    if (object && d3_geo_streamObjectType.hasOwnProperty(object.type)) {
	      d3_geo_streamObjectType[object.type](object, listener);
	    } else {
	      d3_geo_streamGeometry(object, listener);
	    }
	  };
	  function d3_geo_streamGeometry(geometry, listener) {
	    if (geometry && d3_geo_streamGeometryType.hasOwnProperty(geometry.type)) {
	      d3_geo_streamGeometryType[geometry.type](geometry, listener);
	    }
	  }
	  var d3_geo_streamObjectType = {
	    Feature: function(feature, listener) {
	      d3_geo_streamGeometry(feature.geometry, listener);
	    },
	    FeatureCollection: function(object, listener) {
	      var features = object.features, i = -1, n = features.length;
	      while (++i < n) d3_geo_streamGeometry(features[i].geometry, listener);
	    }
	  };
	  var d3_geo_streamGeometryType = {
	    Sphere: function(object, listener) {
	      listener.sphere();
	    },
	    Point: function(object, listener) {
	      object = object.coordinates;
	      listener.point(object[0], object[1], object[2]);
	    },
	    MultiPoint: function(object, listener) {
	      var coordinates = object.coordinates, i = -1, n = coordinates.length;
	      while (++i < n) object = coordinates[i], listener.point(object[0], object[1], object[2]);
	    },
	    LineString: function(object, listener) {
	      d3_geo_streamLine(object.coordinates, listener, 0);
	    },
	    MultiLineString: function(object, listener) {
	      var coordinates = object.coordinates, i = -1, n = coordinates.length;
	      while (++i < n) d3_geo_streamLine(coordinates[i], listener, 0);
	    },
	    Polygon: function(object, listener) {
	      d3_geo_streamPolygon(object.coordinates, listener);
	    },
	    MultiPolygon: function(object, listener) {
	      var coordinates = object.coordinates, i = -1, n = coordinates.length;
	      while (++i < n) d3_geo_streamPolygon(coordinates[i], listener);
	    },
	    GeometryCollection: function(object, listener) {
	      var geometries = object.geometries, i = -1, n = geometries.length;
	      while (++i < n) d3_geo_streamGeometry(geometries[i], listener);
	    }
	  };
	  function d3_geo_streamLine(coordinates, listener, closed) {
	    var i = -1, n = coordinates.length - closed, coordinate;
	    listener.lineStart();
	    while (++i < n) coordinate = coordinates[i], listener.point(coordinate[0], coordinate[1], coordinate[2]);
	    listener.lineEnd();
	  }
	  function d3_geo_streamPolygon(coordinates, listener) {
	    var i = -1, n = coordinates.length;
	    listener.polygonStart();
	    while (++i < n) d3_geo_streamLine(coordinates[i], listener, 1);
	    listener.polygonEnd();
	  }
	  d3.geo.area = function(object) {
	    d3_geo_areaSum = 0;
	    d3.geo.stream(object, d3_geo_area);
	    return d3_geo_areaSum;
	  };
	  var d3_geo_areaSum, d3_geo_areaRingSum = new d3_adder();
	  var d3_geo_area = {
	    sphere: function() {
	      d3_geo_areaSum += 4 * π;
	    },
	    point: d3_noop,
	    lineStart: d3_noop,
	    lineEnd: d3_noop,
	    polygonStart: function() {
	      d3_geo_areaRingSum.reset();
	      d3_geo_area.lineStart = d3_geo_areaRingStart;
	    },
	    polygonEnd: function() {
	      var area = 2 * d3_geo_areaRingSum;
	      d3_geo_areaSum += area < 0 ? 4 * π + area : area;
	      d3_geo_area.lineStart = d3_geo_area.lineEnd = d3_geo_area.point = d3_noop;
	    }
	  };
	  function d3_geo_areaRingStart() {
	    var λ00, φ00, λ0, cosφ0, sinφ0;
	    d3_geo_area.point = function(λ, φ) {
	      d3_geo_area.point = nextPoint;
	      λ0 = (λ00 = λ) * d3_radians, cosφ0 = Math.cos(φ = (φ00 = φ) * d3_radians / 2 + π / 4), 
	      sinφ0 = Math.sin(φ);
	    };
	    function nextPoint(λ, φ) {
	      λ *= d3_radians;
	      φ = φ * d3_radians / 2 + π / 4;
	      var dλ = λ - λ0, sdλ = dλ >= 0 ? 1 : -1, adλ = sdλ * dλ, cosφ = Math.cos(φ), sinφ = Math.sin(φ), k = sinφ0 * sinφ, u = cosφ0 * cosφ + k * Math.cos(adλ), v = k * sdλ * Math.sin(adλ);
	      d3_geo_areaRingSum.add(Math.atan2(v, u));
	      λ0 = λ, cosφ0 = cosφ, sinφ0 = sinφ;
	    }
	    d3_geo_area.lineEnd = function() {
	      nextPoint(λ00, φ00);
	    };
	  }
	  function d3_geo_cartesian(spherical) {
	    var λ = spherical[0], φ = spherical[1], cosφ = Math.cos(φ);
	    return [ cosφ * Math.cos(λ), cosφ * Math.sin(λ), Math.sin(φ) ];
	  }
	  function d3_geo_cartesianDot(a, b) {
	    return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
	  }
	  function d3_geo_cartesianCross(a, b) {
	    return [ a[1] * b[2] - a[2] * b[1], a[2] * b[0] - a[0] * b[2], a[0] * b[1] - a[1] * b[0] ];
	  }
	  function d3_geo_cartesianAdd(a, b) {
	    a[0] += b[0];
	    a[1] += b[1];
	    a[2] += b[2];
	  }
	  function d3_geo_cartesianScale(vector, k) {
	    return [ vector[0] * k, vector[1] * k, vector[2] * k ];
	  }
	  function d3_geo_cartesianNormalize(d) {
	    var l = Math.sqrt(d[0] * d[0] + d[1] * d[1] + d[2] * d[2]);
	    d[0] /= l;
	    d[1] /= l;
	    d[2] /= l;
	  }
	  function d3_geo_spherical(cartesian) {
	    return [ Math.atan2(cartesian[1], cartesian[0]), d3_asin(cartesian[2]) ];
	  }
	  function d3_geo_sphericalEqual(a, b) {
	    return abs(a[0] - b[0]) < ε && abs(a[1] - b[1]) < ε;
	  }
	  d3.geo.bounds = function() {
	    var λ0, φ0, λ1, φ1, λ_, λ__, φ__, p0, dλSum, ranges, range;
	    var bound = {
	      point: point,
	      lineStart: lineStart,
	      lineEnd: lineEnd,
	      polygonStart: function() {
	        bound.point = ringPoint;
	        bound.lineStart = ringStart;
	        bound.lineEnd = ringEnd;
	        dλSum = 0;
	        d3_geo_area.polygonStart();
	      },
	      polygonEnd: function() {
	        d3_geo_area.polygonEnd();
	        bound.point = point;
	        bound.lineStart = lineStart;
	        bound.lineEnd = lineEnd;
	        if (d3_geo_areaRingSum < 0) λ0 = -(λ1 = 180), φ0 = -(φ1 = 90); else if (dλSum > ε) φ1 = 90; else if (dλSum < -ε) φ0 = -90;
	        range[0] = λ0, range[1] = λ1;
	      }
	    };
	    function point(λ, φ) {
	      ranges.push(range = [ λ0 = λ, λ1 = λ ]);
	      if (φ < φ0) φ0 = φ;
	      if (φ > φ1) φ1 = φ;
	    }
	    function linePoint(λ, φ) {
	      var p = d3_geo_cartesian([ λ * d3_radians, φ * d3_radians ]);
	      if (p0) {
	        var normal = d3_geo_cartesianCross(p0, p), equatorial = [ normal[1], -normal[0], 0 ], inflection = d3_geo_cartesianCross(equatorial, normal);
	        d3_geo_cartesianNormalize(inflection);
	        inflection = d3_geo_spherical(inflection);
	        var dλ = λ - λ_, s = dλ > 0 ? 1 : -1, λi = inflection[0] * d3_degrees * s, antimeridian = abs(dλ) > 180;
	        if (antimeridian ^ (s * λ_ < λi && λi < s * λ)) {
	          var φi = inflection[1] * d3_degrees;
	          if (φi > φ1) φ1 = φi;
	        } else if (λi = (λi + 360) % 360 - 180, antimeridian ^ (s * λ_ < λi && λi < s * λ)) {
	          var φi = -inflection[1] * d3_degrees;
	          if (φi < φ0) φ0 = φi;
	        } else {
	          if (φ < φ0) φ0 = φ;
	          if (φ > φ1) φ1 = φ;
	        }
	        if (antimeridian) {
	          if (λ < λ_) {
	            if (angle(λ0, λ) > angle(λ0, λ1)) λ1 = λ;
	          } else {
	            if (angle(λ, λ1) > angle(λ0, λ1)) λ0 = λ;
	          }
	        } else {
	          if (λ1 >= λ0) {
	            if (λ < λ0) λ0 = λ;
	            if (λ > λ1) λ1 = λ;
	          } else {
	            if (λ > λ_) {
	              if (angle(λ0, λ) > angle(λ0, λ1)) λ1 = λ;
	            } else {
	              if (angle(λ, λ1) > angle(λ0, λ1)) λ0 = λ;
	            }
	          }
	        }
	      } else {
	        point(λ, φ);
	      }
	      p0 = p, λ_ = λ;
	    }
	    function lineStart() {
	      bound.point = linePoint;
	    }
	    function lineEnd() {
	      range[0] = λ0, range[1] = λ1;
	      bound.point = point;
	      p0 = null;
	    }
	    function ringPoint(λ, φ) {
	      if (p0) {
	        var dλ = λ - λ_;
	        dλSum += abs(dλ) > 180 ? dλ + (dλ > 0 ? 360 : -360) : dλ;
	      } else λ__ = λ, φ__ = φ;
	      d3_geo_area.point(λ, φ);
	      linePoint(λ, φ);
	    }
	    function ringStart() {
	      d3_geo_area.lineStart();
	    }
	    function ringEnd() {
	      ringPoint(λ__, φ__);
	      d3_geo_area.lineEnd();
	      if (abs(dλSum) > ε) λ0 = -(λ1 = 180);
	      range[0] = λ0, range[1] = λ1;
	      p0 = null;
	    }
	    function angle(λ0, λ1) {
	      return (λ1 -= λ0) < 0 ? λ1 + 360 : λ1;
	    }
	    function compareRanges(a, b) {
	      return a[0] - b[0];
	    }
	    function withinRange(x, range) {
	      return range[0] <= range[1] ? range[0] <= x && x <= range[1] : x < range[0] || range[1] < x;
	    }
	    return function(feature) {
	      φ1 = λ1 = -(λ0 = φ0 = Infinity);
	      ranges = [];
	      d3.geo.stream(feature, bound);
	      var n = ranges.length;
	      if (n) {
	        ranges.sort(compareRanges);
	        for (var i = 1, a = ranges[0], b, merged = [ a ]; i < n; ++i) {
	          b = ranges[i];
	          if (withinRange(b[0], a) || withinRange(b[1], a)) {
	            if (angle(a[0], b[1]) > angle(a[0], a[1])) a[1] = b[1];
	            if (angle(b[0], a[1]) > angle(a[0], a[1])) a[0] = b[0];
	          } else {
	            merged.push(a = b);
	          }
	        }
	        var best = -Infinity, dλ;
	        for (var n = merged.length - 1, i = 0, a = merged[n], b; i <= n; a = b, ++i) {
	          b = merged[i];
	          if ((dλ = angle(a[1], b[0])) > best) best = dλ, λ0 = b[0], λ1 = a[1];
	        }
	      }
	      ranges = range = null;
	      return λ0 === Infinity || φ0 === Infinity ? [ [ NaN, NaN ], [ NaN, NaN ] ] : [ [ λ0, φ0 ], [ λ1, φ1 ] ];
	    };
	  }();
	  d3.geo.centroid = function(object) {
	    d3_geo_centroidW0 = d3_geo_centroidW1 = d3_geo_centroidX0 = d3_geo_centroidY0 = d3_geo_centroidZ0 = d3_geo_centroidX1 = d3_geo_centroidY1 = d3_geo_centroidZ1 = d3_geo_centroidX2 = d3_geo_centroidY2 = d3_geo_centroidZ2 = 0;
	    d3.geo.stream(object, d3_geo_centroid);
	    var x = d3_geo_centroidX2, y = d3_geo_centroidY2, z = d3_geo_centroidZ2, m = x * x + y * y + z * z;
	    if (m < ε2) {
	      x = d3_geo_centroidX1, y = d3_geo_centroidY1, z = d3_geo_centroidZ1;
	      if (d3_geo_centroidW1 < ε) x = d3_geo_centroidX0, y = d3_geo_centroidY0, z = d3_geo_centroidZ0;
	      m = x * x + y * y + z * z;
	      if (m < ε2) return [ NaN, NaN ];
	    }
	    return [ Math.atan2(y, x) * d3_degrees, d3_asin(z / Math.sqrt(m)) * d3_degrees ];
	  };
	  var d3_geo_centroidW0, d3_geo_centroidW1, d3_geo_centroidX0, d3_geo_centroidY0, d3_geo_centroidZ0, d3_geo_centroidX1, d3_geo_centroidY1, d3_geo_centroidZ1, d3_geo_centroidX2, d3_geo_centroidY2, d3_geo_centroidZ2;
	  var d3_geo_centroid = {
	    sphere: d3_noop,
	    point: d3_geo_centroidPoint,
	    lineStart: d3_geo_centroidLineStart,
	    lineEnd: d3_geo_centroidLineEnd,
	    polygonStart: function() {
	      d3_geo_centroid.lineStart = d3_geo_centroidRingStart;
	    },
	    polygonEnd: function() {
	      d3_geo_centroid.lineStart = d3_geo_centroidLineStart;
	    }
	  };
	  function d3_geo_centroidPoint(λ, φ) {
	    λ *= d3_radians;
	    var cosφ = Math.cos(φ *= d3_radians);
	    d3_geo_centroidPointXYZ(cosφ * Math.cos(λ), cosφ * Math.sin(λ), Math.sin(φ));
	  }
	  function d3_geo_centroidPointXYZ(x, y, z) {
	    ++d3_geo_centroidW0;
	    d3_geo_centroidX0 += (x - d3_geo_centroidX0) / d3_geo_centroidW0;
	    d3_geo_centroidY0 += (y - d3_geo_centroidY0) / d3_geo_centroidW0;
	    d3_geo_centroidZ0 += (z - d3_geo_centroidZ0) / d3_geo_centroidW0;
	  }
	  function d3_geo_centroidLineStart() {
	    var x0, y0, z0;
	    d3_geo_centroid.point = function(λ, φ) {
	      λ *= d3_radians;
	      var cosφ = Math.cos(φ *= d3_radians);
	      x0 = cosφ * Math.cos(λ);
	      y0 = cosφ * Math.sin(λ);
	      z0 = Math.sin(φ);
	      d3_geo_centroid.point = nextPoint;
	      d3_geo_centroidPointXYZ(x0, y0, z0);
	    };
	    function nextPoint(λ, φ) {
	      λ *= d3_radians;
	      var cosφ = Math.cos(φ *= d3_radians), x = cosφ * Math.cos(λ), y = cosφ * Math.sin(λ), z = Math.sin(φ), w = Math.atan2(Math.sqrt((w = y0 * z - z0 * y) * w + (w = z0 * x - x0 * z) * w + (w = x0 * y - y0 * x) * w), x0 * x + y0 * y + z0 * z);
	      d3_geo_centroidW1 += w;
	      d3_geo_centroidX1 += w * (x0 + (x0 = x));
	      d3_geo_centroidY1 += w * (y0 + (y0 = y));
	      d3_geo_centroidZ1 += w * (z0 + (z0 = z));
	      d3_geo_centroidPointXYZ(x0, y0, z0);
	    }
	  }
	  function d3_geo_centroidLineEnd() {
	    d3_geo_centroid.point = d3_geo_centroidPoint;
	  }
	  function d3_geo_centroidRingStart() {
	    var λ00, φ00, x0, y0, z0;
	    d3_geo_centroid.point = function(λ, φ) {
	      λ00 = λ, φ00 = φ;
	      d3_geo_centroid.point = nextPoint;
	      λ *= d3_radians;
	      var cosφ = Math.cos(φ *= d3_radians);
	      x0 = cosφ * Math.cos(λ);
	      y0 = cosφ * Math.sin(λ);
	      z0 = Math.sin(φ);
	      d3_geo_centroidPointXYZ(x0, y0, z0);
	    };
	    d3_geo_centroid.lineEnd = function() {
	      nextPoint(λ00, φ00);
	      d3_geo_centroid.lineEnd = d3_geo_centroidLineEnd;
	      d3_geo_centroid.point = d3_geo_centroidPoint;
	    };
	    function nextPoint(λ, φ) {
	      λ *= d3_radians;
	      var cosφ = Math.cos(φ *= d3_radians), x = cosφ * Math.cos(λ), y = cosφ * Math.sin(λ), z = Math.sin(φ), cx = y0 * z - z0 * y, cy = z0 * x - x0 * z, cz = x0 * y - y0 * x, m = Math.sqrt(cx * cx + cy * cy + cz * cz), u = x0 * x + y0 * y + z0 * z, v = m && -d3_acos(u) / m, w = Math.atan2(m, u);
	      d3_geo_centroidX2 += v * cx;
	      d3_geo_centroidY2 += v * cy;
	      d3_geo_centroidZ2 += v * cz;
	      d3_geo_centroidW1 += w;
	      d3_geo_centroidX1 += w * (x0 + (x0 = x));
	      d3_geo_centroidY1 += w * (y0 + (y0 = y));
	      d3_geo_centroidZ1 += w * (z0 + (z0 = z));
	      d3_geo_centroidPointXYZ(x0, y0, z0);
	    }
	  }
	  function d3_geo_compose(a, b) {
	    function compose(x, y) {
	      return x = a(x, y), b(x[0], x[1]);
	    }
	    if (a.invert && b.invert) compose.invert = function(x, y) {
	      return x = b.invert(x, y), x && a.invert(x[0], x[1]);
	    };
	    return compose;
	  }
	  function d3_true() {
	    return true;
	  }
	  function d3_geo_clipPolygon(segments, compare, clipStartInside, interpolate, listener) {
	    var subject = [], clip = [];
	    segments.forEach(function(segment) {
	      if ((n = segment.length - 1) <= 0) return;
	      var n, p0 = segment[0], p1 = segment[n];
	      if (d3_geo_sphericalEqual(p0, p1)) {
	        listener.lineStart();
	        for (var i = 0; i < n; ++i) listener.point((p0 = segment[i])[0], p0[1]);
	        listener.lineEnd();
	        return;
	      }
	      var a = new d3_geo_clipPolygonIntersection(p0, segment, null, true), b = new d3_geo_clipPolygonIntersection(p0, null, a, false);
	      a.o = b;
	      subject.push(a);
	      clip.push(b);
	      a = new d3_geo_clipPolygonIntersection(p1, segment, null, false);
	      b = new d3_geo_clipPolygonIntersection(p1, null, a, true);
	      a.o = b;
	      subject.push(a);
	      clip.push(b);
	    });
	    clip.sort(compare);
	    d3_geo_clipPolygonLinkCircular(subject);
	    d3_geo_clipPolygonLinkCircular(clip);
	    if (!subject.length) return;
	    for (var i = 0, entry = clipStartInside, n = clip.length; i < n; ++i) {
	      clip[i].e = entry = !entry;
	    }
	    var start = subject[0], points, point;
	    while (1) {
	      var current = start, isSubject = true;
	      while (current.v) if ((current = current.n) === start) return;
	      points = current.z;
	      listener.lineStart();
	      do {
	        current.v = current.o.v = true;
	        if (current.e) {
	          if (isSubject) {
	            for (var i = 0, n = points.length; i < n; ++i) listener.point((point = points[i])[0], point[1]);
	          } else {
	            interpolate(current.x, current.n.x, 1, listener);
	          }
	          current = current.n;
	        } else {
	          if (isSubject) {
	            points = current.p.z;
	            for (var i = points.length - 1; i >= 0; --i) listener.point((point = points[i])[0], point[1]);
	          } else {
	            interpolate(current.x, current.p.x, -1, listener);
	          }
	          current = current.p;
	        }
	        current = current.o;
	        points = current.z;
	        isSubject = !isSubject;
	      } while (!current.v);
	      listener.lineEnd();
	    }
	  }
	  function d3_geo_clipPolygonLinkCircular(array) {
	    if (!(n = array.length)) return;
	    var n, i = 0, a = array[0], b;
	    while (++i < n) {
	      a.n = b = array[i];
	      b.p = a;
	      a = b;
	    }
	    a.n = b = array[0];
	    b.p = a;
	  }
	  function d3_geo_clipPolygonIntersection(point, points, other, entry) {
	    this.x = point;
	    this.z = points;
	    this.o = other;
	    this.e = entry;
	    this.v = false;
	    this.n = this.p = null;
	  }
	  function d3_geo_clip(pointVisible, clipLine, interpolate, clipStart) {
	    return function(rotate, listener) {
	      var line = clipLine(listener), rotatedClipStart = rotate.invert(clipStart[0], clipStart[1]);
	      var clip = {
	        point: point,
	        lineStart: lineStart,
	        lineEnd: lineEnd,
	        polygonStart: function() {
	          clip.point = pointRing;
	          clip.lineStart = ringStart;
	          clip.lineEnd = ringEnd;
	          segments = [];
	          polygon = [];
	        },
	        polygonEnd: function() {
	          clip.point = point;
	          clip.lineStart = lineStart;
	          clip.lineEnd = lineEnd;
	          segments = d3.merge(segments);
	          var clipStartInside = d3_geo_pointInPolygon(rotatedClipStart, polygon);
	          if (segments.length) {
	            if (!polygonStarted) listener.polygonStart(), polygonStarted = true;
	            d3_geo_clipPolygon(segments, d3_geo_clipSort, clipStartInside, interpolate, listener);
	          } else if (clipStartInside) {
	            if (!polygonStarted) listener.polygonStart(), polygonStarted = true;
	            listener.lineStart();
	            interpolate(null, null, 1, listener);
	            listener.lineEnd();
	          }
	          if (polygonStarted) listener.polygonEnd(), polygonStarted = false;
	          segments = polygon = null;
	        },
	        sphere: function() {
	          listener.polygonStart();
	          listener.lineStart();
	          interpolate(null, null, 1, listener);
	          listener.lineEnd();
	          listener.polygonEnd();
	        }
	      };
	      function point(λ, φ) {
	        var point = rotate(λ, φ);
	        if (pointVisible(λ = point[0], φ = point[1])) listener.point(λ, φ);
	      }
	      function pointLine(λ, φ) {
	        var point = rotate(λ, φ);
	        line.point(point[0], point[1]);
	      }
	      function lineStart() {
	        clip.point = pointLine;
	        line.lineStart();
	      }
	      function lineEnd() {
	        clip.point = point;
	        line.lineEnd();
	      }
	      var segments;
	      var buffer = d3_geo_clipBufferListener(), ringListener = clipLine(buffer), polygonStarted = false, polygon, ring;
	      function pointRing(λ, φ) {
	        ring.push([ λ, φ ]);
	        var point = rotate(λ, φ);
	        ringListener.point(point[0], point[1]);
	      }
	      function ringStart() {
	        ringListener.lineStart();
	        ring = [];
	      }
	      function ringEnd() {
	        pointRing(ring[0][0], ring[0][1]);
	        ringListener.lineEnd();
	        var clean = ringListener.clean(), ringSegments = buffer.buffer(), segment, n = ringSegments.length;
	        ring.pop();
	        polygon.push(ring);
	        ring = null;
	        if (!n) return;
	        if (clean & 1) {
	          segment = ringSegments[0];
	          var n = segment.length - 1, i = -1, point;
	          if (n > 0) {
	            if (!polygonStarted) listener.polygonStart(), polygonStarted = true;
	            listener.lineStart();
	            while (++i < n) listener.point((point = segment[i])[0], point[1]);
	            listener.lineEnd();
	          }
	          return;
	        }
	        if (n > 1 && clean & 2) ringSegments.push(ringSegments.pop().concat(ringSegments.shift()));
	        segments.push(ringSegments.filter(d3_geo_clipSegmentLength1));
	      }
	      return clip;
	    };
	  }
	  function d3_geo_clipSegmentLength1(segment) {
	    return segment.length > 1;
	  }
	  function d3_geo_clipBufferListener() {
	    var lines = [], line;
	    return {
	      lineStart: function() {
	        lines.push(line = []);
	      },
	      point: function(λ, φ) {
	        line.push([ λ, φ ]);
	      },
	      lineEnd: d3_noop,
	      buffer: function() {
	        var buffer = lines;
	        lines = [];
	        line = null;
	        return buffer;
	      },
	      rejoin: function() {
	        if (lines.length > 1) lines.push(lines.pop().concat(lines.shift()));
	      }
	    };
	  }
	  function d3_geo_clipSort(a, b) {
	    return ((a = a.x)[0] < 0 ? a[1] - halfπ - ε : halfπ - a[1]) - ((b = b.x)[0] < 0 ? b[1] - halfπ - ε : halfπ - b[1]);
	  }
	  var d3_geo_clipAntimeridian = d3_geo_clip(d3_true, d3_geo_clipAntimeridianLine, d3_geo_clipAntimeridianInterpolate, [ -π, -π / 2 ]);
	  function d3_geo_clipAntimeridianLine(listener) {
	    var λ0 = NaN, φ0 = NaN, sλ0 = NaN, clean;
	    return {
	      lineStart: function() {
	        listener.lineStart();
	        clean = 1;
	      },
	      point: function(λ1, φ1) {
	        var sλ1 = λ1 > 0 ? π : -π, dλ = abs(λ1 - λ0);
	        if (abs(dλ - π) < ε) {
	          listener.point(λ0, φ0 = (φ0 + φ1) / 2 > 0 ? halfπ : -halfπ);
	          listener.point(sλ0, φ0);
	          listener.lineEnd();
	          listener.lineStart();
	          listener.point(sλ1, φ0);
	          listener.point(λ1, φ0);
	          clean = 0;
	        } else if (sλ0 !== sλ1 && dλ >= π) {
	          if (abs(λ0 - sλ0) < ε) λ0 -= sλ0 * ε;
	          if (abs(λ1 - sλ1) < ε) λ1 -= sλ1 * ε;
	          φ0 = d3_geo_clipAntimeridianIntersect(λ0, φ0, λ1, φ1);
	          listener.point(sλ0, φ0);
	          listener.lineEnd();
	          listener.lineStart();
	          listener.point(sλ1, φ0);
	          clean = 0;
	        }
	        listener.point(λ0 = λ1, φ0 = φ1);
	        sλ0 = sλ1;
	      },
	      lineEnd: function() {
	        listener.lineEnd();
	        λ0 = φ0 = NaN;
	      },
	      clean: function() {
	        return 2 - clean;
	      }
	    };
	  }
	  function d3_geo_clipAntimeridianIntersect(λ0, φ0, λ1, φ1) {
	    var cosφ0, cosφ1, sinλ0_λ1 = Math.sin(λ0 - λ1);
	    return abs(sinλ0_λ1) > ε ? Math.atan((Math.sin(φ0) * (cosφ1 = Math.cos(φ1)) * Math.sin(λ1) - Math.sin(φ1) * (cosφ0 = Math.cos(φ0)) * Math.sin(λ0)) / (cosφ0 * cosφ1 * sinλ0_λ1)) : (φ0 + φ1) / 2;
	  }
	  function d3_geo_clipAntimeridianInterpolate(from, to, direction, listener) {
	    var φ;
	    if (from == null) {
	      φ = direction * halfπ;
	      listener.point(-π, φ);
	      listener.point(0, φ);
	      listener.point(π, φ);
	      listener.point(π, 0);
	      listener.point(π, -φ);
	      listener.point(0, -φ);
	      listener.point(-π, -φ);
	      listener.point(-π, 0);
	      listener.point(-π, φ);
	    } else if (abs(from[0] - to[0]) > ε) {
	      var s = from[0] < to[0] ? π : -π;
	      φ = direction * s / 2;
	      listener.point(-s, φ);
	      listener.point(0, φ);
	      listener.point(s, φ);
	    } else {
	      listener.point(to[0], to[1]);
	    }
	  }
	  function d3_geo_pointInPolygon(point, polygon) {
	    var meridian = point[0], parallel = point[1], meridianNormal = [ Math.sin(meridian), -Math.cos(meridian), 0 ], polarAngle = 0, winding = 0;
	    d3_geo_areaRingSum.reset();
	    for (var i = 0, n = polygon.length; i < n; ++i) {
	      var ring = polygon[i], m = ring.length;
	      if (!m) continue;
	      var point0 = ring[0], λ0 = point0[0], φ0 = point0[1] / 2 + π / 4, sinφ0 = Math.sin(φ0), cosφ0 = Math.cos(φ0), j = 1;
	      while (true) {
	        if (j === m) j = 0;
	        point = ring[j];
	        var λ = point[0], φ = point[1] / 2 + π / 4, sinφ = Math.sin(φ), cosφ = Math.cos(φ), dλ = λ - λ0, sdλ = dλ >= 0 ? 1 : -1, adλ = sdλ * dλ, antimeridian = adλ > π, k = sinφ0 * sinφ;
	        d3_geo_areaRingSum.add(Math.atan2(k * sdλ * Math.sin(adλ), cosφ0 * cosφ + k * Math.cos(adλ)));
	        polarAngle += antimeridian ? dλ + sdλ * τ : dλ;
	        if (antimeridian ^ λ0 >= meridian ^ λ >= meridian) {
	          var arc = d3_geo_cartesianCross(d3_geo_cartesian(point0), d3_geo_cartesian(point));
	          d3_geo_cartesianNormalize(arc);
	          var intersection = d3_geo_cartesianCross(meridianNormal, arc);
	          d3_geo_cartesianNormalize(intersection);
	          var φarc = (antimeridian ^ dλ >= 0 ? -1 : 1) * d3_asin(intersection[2]);
	          if (parallel > φarc || parallel === φarc && (arc[0] || arc[1])) {
	            winding += antimeridian ^ dλ >= 0 ? 1 : -1;
	          }
	        }
	        if (!j++) break;
	        λ0 = λ, sinφ0 = sinφ, cosφ0 = cosφ, point0 = point;
	      }
	    }
	    return (polarAngle < -ε || polarAngle < ε && d3_geo_areaRingSum < -ε) ^ winding & 1;
	  }
	  function d3_geo_clipCircle(radius) {
	    var cr = Math.cos(radius), smallRadius = cr > 0, notHemisphere = abs(cr) > ε, interpolate = d3_geo_circleInterpolate(radius, 6 * d3_radians);
	    return d3_geo_clip(visible, clipLine, interpolate, smallRadius ? [ 0, -radius ] : [ -π, radius - π ]);
	    function visible(λ, φ) {
	      return Math.cos(λ) * Math.cos(φ) > cr;
	    }
	    function clipLine(listener) {
	      var point0, c0, v0, v00, clean;
	      return {
	        lineStart: function() {
	          v00 = v0 = false;
	          clean = 1;
	        },
	        point: function(λ, φ) {
	          var point1 = [ λ, φ ], point2, v = visible(λ, φ), c = smallRadius ? v ? 0 : code(λ, φ) : v ? code(λ + (λ < 0 ? π : -π), φ) : 0;
	          if (!point0 && (v00 = v0 = v)) listener.lineStart();
	          if (v !== v0) {
	            point2 = intersect(point0, point1);
	            if (d3_geo_sphericalEqual(point0, point2) || d3_geo_sphericalEqual(point1, point2)) {
	              point1[0] += ε;
	              point1[1] += ε;
	              v = visible(point1[0], point1[1]);
	            }
	          }
	          if (v !== v0) {
	            clean = 0;
	            if (v) {
	              listener.lineStart();
	              point2 = intersect(point1, point0);
	              listener.point(point2[0], point2[1]);
	            } else {
	              point2 = intersect(point0, point1);
	              listener.point(point2[0], point2[1]);
	              listener.lineEnd();
	            }
	            point0 = point2;
	          } else if (notHemisphere && point0 && smallRadius ^ v) {
	            var t;
	            if (!(c & c0) && (t = intersect(point1, point0, true))) {
	              clean = 0;
	              if (smallRadius) {
	                listener.lineStart();
	                listener.point(t[0][0], t[0][1]);
	                listener.point(t[1][0], t[1][1]);
	                listener.lineEnd();
	              } else {
	                listener.point(t[1][0], t[1][1]);
	                listener.lineEnd();
	                listener.lineStart();
	                listener.point(t[0][0], t[0][1]);
	              }
	            }
	          }
	          if (v && (!point0 || !d3_geo_sphericalEqual(point0, point1))) {
	            listener.point(point1[0], point1[1]);
	          }
	          point0 = point1, v0 = v, c0 = c;
	        },
	        lineEnd: function() {
	          if (v0) listener.lineEnd();
	          point0 = null;
	        },
	        clean: function() {
	          return clean | (v00 && v0) << 1;
	        }
	      };
	    }
	    function intersect(a, b, two) {
	      var pa = d3_geo_cartesian(a), pb = d3_geo_cartesian(b);
	      var n1 = [ 1, 0, 0 ], n2 = d3_geo_cartesianCross(pa, pb), n2n2 = d3_geo_cartesianDot(n2, n2), n1n2 = n2[0], determinant = n2n2 - n1n2 * n1n2;
	      if (!determinant) return !two && a;
	      var c1 = cr * n2n2 / determinant, c2 = -cr * n1n2 / determinant, n1xn2 = d3_geo_cartesianCross(n1, n2), A = d3_geo_cartesianScale(n1, c1), B = d3_geo_cartesianScale(n2, c2);
	      d3_geo_cartesianAdd(A, B);
	      var u = n1xn2, w = d3_geo_cartesianDot(A, u), uu = d3_geo_cartesianDot(u, u), t2 = w * w - uu * (d3_geo_cartesianDot(A, A) - 1);
	      if (t2 < 0) return;
	      var t = Math.sqrt(t2), q = d3_geo_cartesianScale(u, (-w - t) / uu);
	      d3_geo_cartesianAdd(q, A);
	      q = d3_geo_spherical(q);
	      if (!two) return q;
	      var λ0 = a[0], λ1 = b[0], φ0 = a[1], φ1 = b[1], z;
	      if (λ1 < λ0) z = λ0, λ0 = λ1, λ1 = z;
	      var δλ = λ1 - λ0, polar = abs(δλ - π) < ε, meridian = polar || δλ < ε;
	      if (!polar && φ1 < φ0) z = φ0, φ0 = φ1, φ1 = z;
	      if (meridian ? polar ? φ0 + φ1 > 0 ^ q[1] < (abs(q[0] - λ0) < ε ? φ0 : φ1) : φ0 <= q[1] && q[1] <= φ1 : δλ > π ^ (λ0 <= q[0] && q[0] <= λ1)) {
	        var q1 = d3_geo_cartesianScale(u, (-w + t) / uu);
	        d3_geo_cartesianAdd(q1, A);
	        return [ q, d3_geo_spherical(q1) ];
	      }
	    }
	    function code(λ, φ) {
	      var r = smallRadius ? radius : π - radius, code = 0;
	      if (λ < -r) code |= 1; else if (λ > r) code |= 2;
	      if (φ < -r) code |= 4; else if (φ > r) code |= 8;
	      return code;
	    }
	  }
	  function d3_geom_clipLine(x0, y0, x1, y1) {
	    return function(line) {
	      var a = line.a, b = line.b, ax = a.x, ay = a.y, bx = b.x, by = b.y, t0 = 0, t1 = 1, dx = bx - ax, dy = by - ay, r;
	      r = x0 - ax;
	      if (!dx && r > 0) return;
	      r /= dx;
	      if (dx < 0) {
	        if (r < t0) return;
	        if (r < t1) t1 = r;
	      } else if (dx > 0) {
	        if (r > t1) return;
	        if (r > t0) t0 = r;
	      }
	      r = x1 - ax;
	      if (!dx && r < 0) return;
	      r /= dx;
	      if (dx < 0) {
	        if (r > t1) return;
	        if (r > t0) t0 = r;
	      } else if (dx > 0) {
	        if (r < t0) return;
	        if (r < t1) t1 = r;
	      }
	      r = y0 - ay;
	      if (!dy && r > 0) return;
	      r /= dy;
	      if (dy < 0) {
	        if (r < t0) return;
	        if (r < t1) t1 = r;
	      } else if (dy > 0) {
	        if (r > t1) return;
	        if (r > t0) t0 = r;
	      }
	      r = y1 - ay;
	      if (!dy && r < 0) return;
	      r /= dy;
	      if (dy < 0) {
	        if (r > t1) return;
	        if (r > t0) t0 = r;
	      } else if (dy > 0) {
	        if (r < t0) return;
	        if (r < t1) t1 = r;
	      }
	      if (t0 > 0) line.a = {
	        x: ax + t0 * dx,
	        y: ay + t0 * dy
	      };
	      if (t1 < 1) line.b = {
	        x: ax + t1 * dx,
	        y: ay + t1 * dy
	      };
	      return line;
	    };
	  }
	  var d3_geo_clipExtentMAX = 1e9;
	  d3.geo.clipExtent = function() {
	    var x0, y0, x1, y1, stream, clip, clipExtent = {
	      stream: function(output) {
	        if (stream) stream.valid = false;
	        stream = clip(output);
	        stream.valid = true;
	        return stream;
	      },
	      extent: function(_) {
	        if (!arguments.length) return [ [ x0, y0 ], [ x1, y1 ] ];
	        clip = d3_geo_clipExtent(x0 = +_[0][0], y0 = +_[0][1], x1 = +_[1][0], y1 = +_[1][1]);
	        if (stream) stream.valid = false, stream = null;
	        return clipExtent;
	      }
	    };
	    return clipExtent.extent([ [ 0, 0 ], [ 960, 500 ] ]);
	  };
	  function d3_geo_clipExtent(x0, y0, x1, y1) {
	    return function(listener) {
	      var listener_ = listener, bufferListener = d3_geo_clipBufferListener(), clipLine = d3_geom_clipLine(x0, y0, x1, y1), segments, polygon, ring;
	      var clip = {
	        point: point,
	        lineStart: lineStart,
	        lineEnd: lineEnd,
	        polygonStart: function() {
	          listener = bufferListener;
	          segments = [];
	          polygon = [];
	          clean = true;
	        },
	        polygonEnd: function() {
	          listener = listener_;
	          segments = d3.merge(segments);
	          var clipStartInside = insidePolygon([ x0, y1 ]), inside = clean && clipStartInside, visible = segments.length;
	          if (inside || visible) {
	            listener.polygonStart();
	            if (inside) {
	              listener.lineStart();
	              interpolate(null, null, 1, listener);
	              listener.lineEnd();
	            }
	            if (visible) {
	              d3_geo_clipPolygon(segments, compare, clipStartInside, interpolate, listener);
	            }
	            listener.polygonEnd();
	          }
	          segments = polygon = ring = null;
	        }
	      };
	      function insidePolygon(p) {
	        var wn = 0, n = polygon.length, y = p[1];
	        for (var i = 0; i < n; ++i) {
	          for (var j = 1, v = polygon[i], m = v.length, a = v[0], b; j < m; ++j) {
	            b = v[j];
	            if (a[1] <= y) {
	              if (b[1] > y && d3_cross2d(a, b, p) > 0) ++wn;
	            } else {
	              if (b[1] <= y && d3_cross2d(a, b, p) < 0) --wn;
	            }
	            a = b;
	          }
	        }
	        return wn !== 0;
	      }
	      function interpolate(from, to, direction, listener) {
	        var a = 0, a1 = 0;
	        if (from == null || (a = corner(from, direction)) !== (a1 = corner(to, direction)) || comparePoints(from, to) < 0 ^ direction > 0) {
	          do {
	            listener.point(a === 0 || a === 3 ? x0 : x1, a > 1 ? y1 : y0);
	          } while ((a = (a + direction + 4) % 4) !== a1);
	        } else {
	          listener.point(to[0], to[1]);
	        }
	      }
	      function pointVisible(x, y) {
	        return x0 <= x && x <= x1 && y0 <= y && y <= y1;
	      }
	      function point(x, y) {
	        if (pointVisible(x, y)) listener.point(x, y);
	      }
	      var x__, y__, v__, x_, y_, v_, first, clean;
	      function lineStart() {
	        clip.point = linePoint;
	        if (polygon) polygon.push(ring = []);
	        first = true;
	        v_ = false;
	        x_ = y_ = NaN;
	      }
	      function lineEnd() {
	        if (segments) {
	          linePoint(x__, y__);
	          if (v__ && v_) bufferListener.rejoin();
	          segments.push(bufferListener.buffer());
	        }
	        clip.point = point;
	        if (v_) listener.lineEnd();
	      }
	      function linePoint(x, y) {
	        x = Math.max(-d3_geo_clipExtentMAX, Math.min(d3_geo_clipExtentMAX, x));
	        y = Math.max(-d3_geo_clipExtentMAX, Math.min(d3_geo_clipExtentMAX, y));
	        var v = pointVisible(x, y);
	        if (polygon) ring.push([ x, y ]);
	        if (first) {
	          x__ = x, y__ = y, v__ = v;
	          first = false;
	          if (v) {
	            listener.lineStart();
	            listener.point(x, y);
	          }
	        } else {
	          if (v && v_) listener.point(x, y); else {
	            var l = {
	              a: {
	                x: x_,
	                y: y_
	              },
	              b: {
	                x: x,
	                y: y
	              }
	            };
	            if (clipLine(l)) {
	              if (!v_) {
	                listener.lineStart();
	                listener.point(l.a.x, l.a.y);
	              }
	              listener.point(l.b.x, l.b.y);
	              if (!v) listener.lineEnd();
	              clean = false;
	            } else if (v) {
	              listener.lineStart();
	              listener.point(x, y);
	              clean = false;
	            }
	          }
	        }
	        x_ = x, y_ = y, v_ = v;
	      }
	      return clip;
	    };
	    function corner(p, direction) {
	      return abs(p[0] - x0) < ε ? direction > 0 ? 0 : 3 : abs(p[0] - x1) < ε ? direction > 0 ? 2 : 1 : abs(p[1] - y0) < ε ? direction > 0 ? 1 : 0 : direction > 0 ? 3 : 2;
	    }
	    function compare(a, b) {
	      return comparePoints(a.x, b.x);
	    }
	    function comparePoints(a, b) {
	      var ca = corner(a, 1), cb = corner(b, 1);
	      return ca !== cb ? ca - cb : ca === 0 ? b[1] - a[1] : ca === 1 ? a[0] - b[0] : ca === 2 ? a[1] - b[1] : b[0] - a[0];
	    }
	  }
	  function d3_geo_conic(projectAt) {
	    var φ0 = 0, φ1 = π / 3, m = d3_geo_projectionMutator(projectAt), p = m(φ0, φ1);
	    p.parallels = function(_) {
	      if (!arguments.length) return [ φ0 / π * 180, φ1 / π * 180 ];
	      return m(φ0 = _[0] * π / 180, φ1 = _[1] * π / 180);
	    };
	    return p;
	  }
	  function d3_geo_conicEqualArea(φ0, φ1) {
	    var sinφ0 = Math.sin(φ0), n = (sinφ0 + Math.sin(φ1)) / 2, C = 1 + sinφ0 * (2 * n - sinφ0), ρ0 = Math.sqrt(C) / n;
	    function forward(λ, φ) {
	      var ρ = Math.sqrt(C - 2 * n * Math.sin(φ)) / n;
	      return [ ρ * Math.sin(λ *= n), ρ0 - ρ * Math.cos(λ) ];
	    }
	    forward.invert = function(x, y) {
	      var ρ0_y = ρ0 - y;
	      return [ Math.atan2(x, ρ0_y) / n, d3_asin((C - (x * x + ρ0_y * ρ0_y) * n * n) / (2 * n)) ];
	    };
	    return forward;
	  }
	  (d3.geo.conicEqualArea = function() {
	    return d3_geo_conic(d3_geo_conicEqualArea);
	  }).raw = d3_geo_conicEqualArea;
	  d3.geo.albers = function() {
	    return d3.geo.conicEqualArea().rotate([ 96, 0 ]).center([ -.6, 38.7 ]).parallels([ 29.5, 45.5 ]).scale(1070);
	  };
	  d3.geo.albersUsa = function() {
	    var lower48 = d3.geo.albers();
	    var alaska = d3.geo.conicEqualArea().rotate([ 154, 0 ]).center([ -2, 58.5 ]).parallels([ 55, 65 ]);
	    var hawaii = d3.geo.conicEqualArea().rotate([ 157, 0 ]).center([ -3, 19.9 ]).parallels([ 8, 18 ]);
	    var point, pointStream = {
	      point: function(x, y) {
	        point = [ x, y ];
	      }
	    }, lower48Point, alaskaPoint, hawaiiPoint;
	    function albersUsa(coordinates) {
	      var x = coordinates[0], y = coordinates[1];
	      point = null;
	      (lower48Point(x, y), point) || (alaskaPoint(x, y), point) || hawaiiPoint(x, y);
	      return point;
	    }
	    albersUsa.invert = function(coordinates) {
	      var k = lower48.scale(), t = lower48.translate(), x = (coordinates[0] - t[0]) / k, y = (coordinates[1] - t[1]) / k;
	      return (y >= .12 && y < .234 && x >= -.425 && x < -.214 ? alaska : y >= .166 && y < .234 && x >= -.214 && x < -.115 ? hawaii : lower48).invert(coordinates);
	    };
	    albersUsa.stream = function(stream) {
	      var lower48Stream = lower48.stream(stream), alaskaStream = alaska.stream(stream), hawaiiStream = hawaii.stream(stream);
	      return {
	        point: function(x, y) {
	          lower48Stream.point(x, y);
	          alaskaStream.point(x, y);
	          hawaiiStream.point(x, y);
	        },
	        sphere: function() {
	          lower48Stream.sphere();
	          alaskaStream.sphere();
	          hawaiiStream.sphere();
	        },
	        lineStart: function() {
	          lower48Stream.lineStart();
	          alaskaStream.lineStart();
	          hawaiiStream.lineStart();
	        },
	        lineEnd: function() {
	          lower48Stream.lineEnd();
	          alaskaStream.lineEnd();
	          hawaiiStream.lineEnd();
	        },
	        polygonStart: function() {
	          lower48Stream.polygonStart();
	          alaskaStream.polygonStart();
	          hawaiiStream.polygonStart();
	        },
	        polygonEnd: function() {
	          lower48Stream.polygonEnd();
	          alaskaStream.polygonEnd();
	          hawaiiStream.polygonEnd();
	        }
	      };
	    };
	    albersUsa.precision = function(_) {
	      if (!arguments.length) return lower48.precision();
	      lower48.precision(_);
	      alaska.precision(_);
	      hawaii.precision(_);
	      return albersUsa;
	    };
	    albersUsa.scale = function(_) {
	      if (!arguments.length) return lower48.scale();
	      lower48.scale(_);
	      alaska.scale(_ * .35);
	      hawaii.scale(_);
	      return albersUsa.translate(lower48.translate());
	    };
	    albersUsa.translate = function(_) {
	      if (!arguments.length) return lower48.translate();
	      var k = lower48.scale(), x = +_[0], y = +_[1];
	      lower48Point = lower48.translate(_).clipExtent([ [ x - .455 * k, y - .238 * k ], [ x + .455 * k, y + .238 * k ] ]).stream(pointStream).point;
	      alaskaPoint = alaska.translate([ x - .307 * k, y + .201 * k ]).clipExtent([ [ x - .425 * k + ε, y + .12 * k + ε ], [ x - .214 * k - ε, y + .234 * k - ε ] ]).stream(pointStream).point;
	      hawaiiPoint = hawaii.translate([ x - .205 * k, y + .212 * k ]).clipExtent([ [ x - .214 * k + ε, y + .166 * k + ε ], [ x - .115 * k - ε, y + .234 * k - ε ] ]).stream(pointStream).point;
	      return albersUsa;
	    };
	    return albersUsa.scale(1070);
	  };
	  var d3_geo_pathAreaSum, d3_geo_pathAreaPolygon, d3_geo_pathArea = {
	    point: d3_noop,
	    lineStart: d3_noop,
	    lineEnd: d3_noop,
	    polygonStart: function() {
	      d3_geo_pathAreaPolygon = 0;
	      d3_geo_pathArea.lineStart = d3_geo_pathAreaRingStart;
	    },
	    polygonEnd: function() {
	      d3_geo_pathArea.lineStart = d3_geo_pathArea.lineEnd = d3_geo_pathArea.point = d3_noop;
	      d3_geo_pathAreaSum += abs(d3_geo_pathAreaPolygon / 2);
	    }
	  };
	  function d3_geo_pathAreaRingStart() {
	    var x00, y00, x0, y0;
	    d3_geo_pathArea.point = function(x, y) {
	      d3_geo_pathArea.point = nextPoint;
	      x00 = x0 = x, y00 = y0 = y;
	    };
	    function nextPoint(x, y) {
	      d3_geo_pathAreaPolygon += y0 * x - x0 * y;
	      x0 = x, y0 = y;
	    }
	    d3_geo_pathArea.lineEnd = function() {
	      nextPoint(x00, y00);
	    };
	  }
	  var d3_geo_pathBoundsX0, d3_geo_pathBoundsY0, d3_geo_pathBoundsX1, d3_geo_pathBoundsY1;
	  var d3_geo_pathBounds = {
	    point: d3_geo_pathBoundsPoint,
	    lineStart: d3_noop,
	    lineEnd: d3_noop,
	    polygonStart: d3_noop,
	    polygonEnd: d3_noop
	  };
	  function d3_geo_pathBoundsPoint(x, y) {
	    if (x < d3_geo_pathBoundsX0) d3_geo_pathBoundsX0 = x;
	    if (x > d3_geo_pathBoundsX1) d3_geo_pathBoundsX1 = x;
	    if (y < d3_geo_pathBoundsY0) d3_geo_pathBoundsY0 = y;
	    if (y > d3_geo_pathBoundsY1) d3_geo_pathBoundsY1 = y;
	  }
	  function d3_geo_pathBuffer() {
	    var pointCircle = d3_geo_pathBufferCircle(4.5), buffer = [];
	    var stream = {
	      point: point,
	      lineStart: function() {
	        stream.point = pointLineStart;
	      },
	      lineEnd: lineEnd,
	      polygonStart: function() {
	        stream.lineEnd = lineEndPolygon;
	      },
	      polygonEnd: function() {
	        stream.lineEnd = lineEnd;
	        stream.point = point;
	      },
	      pointRadius: function(_) {
	        pointCircle = d3_geo_pathBufferCircle(_);
	        return stream;
	      },
	      result: function() {
	        if (buffer.length) {
	          var result = buffer.join("");
	          buffer = [];
	          return result;
	        }
	      }
	    };
	    function point(x, y) {
	      buffer.push("M", x, ",", y, pointCircle);
	    }
	    function pointLineStart(x, y) {
	      buffer.push("M", x, ",", y);
	      stream.point = pointLine;
	    }
	    function pointLine(x, y) {
	      buffer.push("L", x, ",", y);
	    }
	    function lineEnd() {
	      stream.point = point;
	    }
	    function lineEndPolygon() {
	      buffer.push("Z");
	    }
	    return stream;
	  }
	  function d3_geo_pathBufferCircle(radius) {
	    return "m0," + radius + "a" + radius + "," + radius + " 0 1,1 0," + -2 * radius + "a" + radius + "," + radius + " 0 1,1 0," + 2 * radius + "z";
	  }
	  var d3_geo_pathCentroid = {
	    point: d3_geo_pathCentroidPoint,
	    lineStart: d3_geo_pathCentroidLineStart,
	    lineEnd: d3_geo_pathCentroidLineEnd,
	    polygonStart: function() {
	      d3_geo_pathCentroid.lineStart = d3_geo_pathCentroidRingStart;
	    },
	    polygonEnd: function() {
	      d3_geo_pathCentroid.point = d3_geo_pathCentroidPoint;
	      d3_geo_pathCentroid.lineStart = d3_geo_pathCentroidLineStart;
	      d3_geo_pathCentroid.lineEnd = d3_geo_pathCentroidLineEnd;
	    }
	  };
	  function d3_geo_pathCentroidPoint(x, y) {
	    d3_geo_centroidX0 += x;
	    d3_geo_centroidY0 += y;
	    ++d3_geo_centroidZ0;
	  }
	  function d3_geo_pathCentroidLineStart() {
	    var x0, y0;
	    d3_geo_pathCentroid.point = function(x, y) {
	      d3_geo_pathCentroid.point = nextPoint;
	      d3_geo_pathCentroidPoint(x0 = x, y0 = y);
	    };
	    function nextPoint(x, y) {
	      var dx = x - x0, dy = y - y0, z = Math.sqrt(dx * dx + dy * dy);
	      d3_geo_centroidX1 += z * (x0 + x) / 2;
	      d3_geo_centroidY1 += z * (y0 + y) / 2;
	      d3_geo_centroidZ1 += z;
	      d3_geo_pathCentroidPoint(x0 = x, y0 = y);
	    }
	  }
	  function d3_geo_pathCentroidLineEnd() {
	    d3_geo_pathCentroid.point = d3_geo_pathCentroidPoint;
	  }
	  function d3_geo_pathCentroidRingStart() {
	    var x00, y00, x0, y0;
	    d3_geo_pathCentroid.point = function(x, y) {
	      d3_geo_pathCentroid.point = nextPoint;
	      d3_geo_pathCentroidPoint(x00 = x0 = x, y00 = y0 = y);
	    };
	    function nextPoint(x, y) {
	      var dx = x - x0, dy = y - y0, z = Math.sqrt(dx * dx + dy * dy);
	      d3_geo_centroidX1 += z * (x0 + x) / 2;
	      d3_geo_centroidY1 += z * (y0 + y) / 2;
	      d3_geo_centroidZ1 += z;
	      z = y0 * x - x0 * y;
	      d3_geo_centroidX2 += z * (x0 + x);
	      d3_geo_centroidY2 += z * (y0 + y);
	      d3_geo_centroidZ2 += z * 3;
	      d3_geo_pathCentroidPoint(x0 = x, y0 = y);
	    }
	    d3_geo_pathCentroid.lineEnd = function() {
	      nextPoint(x00, y00);
	    };
	  }
	  function d3_geo_pathContext(context) {
	    var pointRadius = 4.5;
	    var stream = {
	      point: point,
	      lineStart: function() {
	        stream.point = pointLineStart;
	      },
	      lineEnd: lineEnd,
	      polygonStart: function() {
	        stream.lineEnd = lineEndPolygon;
	      },
	      polygonEnd: function() {
	        stream.lineEnd = lineEnd;
	        stream.point = point;
	      },
	      pointRadius: function(_) {
	        pointRadius = _;
	        return stream;
	      },
	      result: d3_noop
	    };
	    function point(x, y) {
	      context.moveTo(x + pointRadius, y);
	      context.arc(x, y, pointRadius, 0, τ);
	    }
	    function pointLineStart(x, y) {
	      context.moveTo(x, y);
	      stream.point = pointLine;
	    }
	    function pointLine(x, y) {
	      context.lineTo(x, y);
	    }
	    function lineEnd() {
	      stream.point = point;
	    }
	    function lineEndPolygon() {
	      context.closePath();
	    }
	    return stream;
	  }
	  function d3_geo_resample(project) {
	    var δ2 = .5, cosMinDistance = Math.cos(30 * d3_radians), maxDepth = 16;
	    function resample(stream) {
	      return (maxDepth ? resampleRecursive : resampleNone)(stream);
	    }
	    function resampleNone(stream) {
	      return d3_geo_transformPoint(stream, function(x, y) {
	        x = project(x, y);
	        stream.point(x[0], x[1]);
	      });
	    }
	    function resampleRecursive(stream) {
	      var λ00, φ00, x00, y00, a00, b00, c00, λ0, x0, y0, a0, b0, c0;
	      var resample = {
	        point: point,
	        lineStart: lineStart,
	        lineEnd: lineEnd,
	        polygonStart: function() {
	          stream.polygonStart();
	          resample.lineStart = ringStart;
	        },
	        polygonEnd: function() {
	          stream.polygonEnd();
	          resample.lineStart = lineStart;
	        }
	      };
	      function point(x, y) {
	        x = project(x, y);
	        stream.point(x[0], x[1]);
	      }
	      function lineStart() {
	        x0 = NaN;
	        resample.point = linePoint;
	        stream.lineStart();
	      }
	      function linePoint(λ, φ) {
	        var c = d3_geo_cartesian([ λ, φ ]), p = project(λ, φ);
	        resampleLineTo(x0, y0, λ0, a0, b0, c0, x0 = p[0], y0 = p[1], λ0 = λ, a0 = c[0], b0 = c[1], c0 = c[2], maxDepth, stream);
	        stream.point(x0, y0);
	      }
	      function lineEnd() {
	        resample.point = point;
	        stream.lineEnd();
	      }
	      function ringStart() {
	        lineStart();
	        resample.point = ringPoint;
	        resample.lineEnd = ringEnd;
	      }
	      function ringPoint(λ, φ) {
	        linePoint(λ00 = λ, φ00 = φ), x00 = x0, y00 = y0, a00 = a0, b00 = b0, c00 = c0;
	        resample.point = linePoint;
	      }
	      function ringEnd() {
	        resampleLineTo(x0, y0, λ0, a0, b0, c0, x00, y00, λ00, a00, b00, c00, maxDepth, stream);
	        resample.lineEnd = lineEnd;
	        lineEnd();
	      }
	      return resample;
	    }
	    function resampleLineTo(x0, y0, λ0, a0, b0, c0, x1, y1, λ1, a1, b1, c1, depth, stream) {
	      var dx = x1 - x0, dy = y1 - y0, d2 = dx * dx + dy * dy;
	      if (d2 > 4 * δ2 && depth--) {
	        var a = a0 + a1, b = b0 + b1, c = c0 + c1, m = Math.sqrt(a * a + b * b + c * c), φ2 = Math.asin(c /= m), λ2 = abs(abs(c) - 1) < ε || abs(λ0 - λ1) < ε ? (λ0 + λ1) / 2 : Math.atan2(b, a), p = project(λ2, φ2), x2 = p[0], y2 = p[1], dx2 = x2 - x0, dy2 = y2 - y0, dz = dy * dx2 - dx * dy2;
	        if (dz * dz / d2 > δ2 || abs((dx * dx2 + dy * dy2) / d2 - .5) > .3 || a0 * a1 + b0 * b1 + c0 * c1 < cosMinDistance) {
	          resampleLineTo(x0, y0, λ0, a0, b0, c0, x2, y2, λ2, a /= m, b /= m, c, depth, stream);
	          stream.point(x2, y2);
	          resampleLineTo(x2, y2, λ2, a, b, c, x1, y1, λ1, a1, b1, c1, depth, stream);
	        }
	      }
	    }
	    resample.precision = function(_) {
	      if (!arguments.length) return Math.sqrt(δ2);
	      maxDepth = (δ2 = _ * _) > 0 && 16;
	      return resample;
	    };
	    return resample;
	  }
	  d3.geo.path = function() {
	    var pointRadius = 4.5, projection, context, projectStream, contextStream, cacheStream;
	    function path(object) {
	      if (object) {
	        if (typeof pointRadius === "function") contextStream.pointRadius(+pointRadius.apply(this, arguments));
	        if (!cacheStream || !cacheStream.valid) cacheStream = projectStream(contextStream);
	        d3.geo.stream(object, cacheStream);
	      }
	      return contextStream.result();
	    }
	    path.area = function(object) {
	      d3_geo_pathAreaSum = 0;
	      d3.geo.stream(object, projectStream(d3_geo_pathArea));
	      return d3_geo_pathAreaSum;
	    };
	    path.centroid = function(object) {
	      d3_geo_centroidX0 = d3_geo_centroidY0 = d3_geo_centroidZ0 = d3_geo_centroidX1 = d3_geo_centroidY1 = d3_geo_centroidZ1 = d3_geo_centroidX2 = d3_geo_centroidY2 = d3_geo_centroidZ2 = 0;
	      d3.geo.stream(object, projectStream(d3_geo_pathCentroid));
	      return d3_geo_centroidZ2 ? [ d3_geo_centroidX2 / d3_geo_centroidZ2, d3_geo_centroidY2 / d3_geo_centroidZ2 ] : d3_geo_centroidZ1 ? [ d3_geo_centroidX1 / d3_geo_centroidZ1, d3_geo_centroidY1 / d3_geo_centroidZ1 ] : d3_geo_centroidZ0 ? [ d3_geo_centroidX0 / d3_geo_centroidZ0, d3_geo_centroidY0 / d3_geo_centroidZ0 ] : [ NaN, NaN ];
	    };
	    path.bounds = function(object) {
	      d3_geo_pathBoundsX1 = d3_geo_pathBoundsY1 = -(d3_geo_pathBoundsX0 = d3_geo_pathBoundsY0 = Infinity);
	      d3.geo.stream(object, projectStream(d3_geo_pathBounds));
	      return [ [ d3_geo_pathBoundsX0, d3_geo_pathBoundsY0 ], [ d3_geo_pathBoundsX1, d3_geo_pathBoundsY1 ] ];
	    };
	    path.projection = function(_) {
	      if (!arguments.length) return projection;
	      projectStream = (projection = _) ? _.stream || d3_geo_pathProjectStream(_) : d3_identity;
	      return reset();
	    };
	    path.context = function(_) {
	      if (!arguments.length) return context;
	      contextStream = (context = _) == null ? new d3_geo_pathBuffer() : new d3_geo_pathContext(_);
	      if (typeof pointRadius !== "function") contextStream.pointRadius(pointRadius);
	      return reset();
	    };
	    path.pointRadius = function(_) {
	      if (!arguments.length) return pointRadius;
	      pointRadius = typeof _ === "function" ? _ : (contextStream.pointRadius(+_), +_);
	      return path;
	    };
	    function reset() {
	      cacheStream = null;
	      return path;
	    }
	    return path.projection(d3.geo.albersUsa()).context(null);
	  };
	  function d3_geo_pathProjectStream(project) {
	    var resample = d3_geo_resample(function(x, y) {
	      return project([ x * d3_degrees, y * d3_degrees ]);
	    });
	    return function(stream) {
	      return d3_geo_projectionRadians(resample(stream));
	    };
	  }
	  d3.geo.transform = function(methods) {
	    return {
	      stream: function(stream) {
	        var transform = new d3_geo_transform(stream);
	        for (var k in methods) transform[k] = methods[k];
	        return transform;
	      }
	    };
	  };
	  function d3_geo_transform(stream) {
	    this.stream = stream;
	  }
	  d3_geo_transform.prototype = {
	    point: function(x, y) {
	      this.stream.point(x, y);
	    },
	    sphere: function() {
	      this.stream.sphere();
	    },
	    lineStart: function() {
	      this.stream.lineStart();
	    },
	    lineEnd: function() {
	      this.stream.lineEnd();
	    },
	    polygonStart: function() {
	      this.stream.polygonStart();
	    },
	    polygonEnd: function() {
	      this.stream.polygonEnd();
	    }
	  };
	  function d3_geo_transformPoint(stream, point) {
	    return {
	      point: point,
	      sphere: function() {
	        stream.sphere();
	      },
	      lineStart: function() {
	        stream.lineStart();
	      },
	      lineEnd: function() {
	        stream.lineEnd();
	      },
	      polygonStart: function() {
	        stream.polygonStart();
	      },
	      polygonEnd: function() {
	        stream.polygonEnd();
	      }
	    };
	  }
	  d3.geo.projection = d3_geo_projection;
	  d3.geo.projectionMutator = d3_geo_projectionMutator;
	  function d3_geo_projection(project) {
	    return d3_geo_projectionMutator(function() {
	      return project;
	    })();
	  }
	  function d3_geo_projectionMutator(projectAt) {
	    var project, rotate, projectRotate, projectResample = d3_geo_resample(function(x, y) {
	      x = project(x, y);
	      return [ x[0] * k + δx, δy - x[1] * k ];
	    }), k = 150, x = 480, y = 250, λ = 0, φ = 0, δλ = 0, δφ = 0, δγ = 0, δx, δy, preclip = d3_geo_clipAntimeridian, postclip = d3_identity, clipAngle = null, clipExtent = null, stream;
	    function projection(point) {
	      point = projectRotate(point[0] * d3_radians, point[1] * d3_radians);
	      return [ point[0] * k + δx, δy - point[1] * k ];
	    }
	    function invert(point) {
	      point = projectRotate.invert((point[0] - δx) / k, (δy - point[1]) / k);
	      return point && [ point[0] * d3_degrees, point[1] * d3_degrees ];
	    }
	    projection.stream = function(output) {
	      if (stream) stream.valid = false;
	      stream = d3_geo_projectionRadians(preclip(rotate, projectResample(postclip(output))));
	      stream.valid = true;
	      return stream;
	    };
	    projection.clipAngle = function(_) {
	      if (!arguments.length) return clipAngle;
	      preclip = _ == null ? (clipAngle = _, d3_geo_clipAntimeridian) : d3_geo_clipCircle((clipAngle = +_) * d3_radians);
	      return invalidate();
	    };
	    projection.clipExtent = function(_) {
	      if (!arguments.length) return clipExtent;
	      clipExtent = _;
	      postclip = _ ? d3_geo_clipExtent(_[0][0], _[0][1], _[1][0], _[1][1]) : d3_identity;
	      return invalidate();
	    };
	    projection.scale = function(_) {
	      if (!arguments.length) return k;
	      k = +_;
	      return reset();
	    };
	    projection.translate = function(_) {
	      if (!arguments.length) return [ x, y ];
	      x = +_[0];
	      y = +_[1];
	      return reset();
	    };
	    projection.center = function(_) {
	      if (!arguments.length) return [ λ * d3_degrees, φ * d3_degrees ];
	      λ = _[0] % 360 * d3_radians;
	      φ = _[1] % 360 * d3_radians;
	      return reset();
	    };
	    projection.rotate = function(_) {
	      if (!arguments.length) return [ δλ * d3_degrees, δφ * d3_degrees, δγ * d3_degrees ];
	      δλ = _[0] % 360 * d3_radians;
	      δφ = _[1] % 360 * d3_radians;
	      δγ = _.length > 2 ? _[2] % 360 * d3_radians : 0;
	      return reset();
	    };
	    d3.rebind(projection, projectResample, "precision");
	    function reset() {
	      projectRotate = d3_geo_compose(rotate = d3_geo_rotation(δλ, δφ, δγ), project);
	      var center = project(λ, φ);
	      δx = x - center[0] * k;
	      δy = y + center[1] * k;
	      return invalidate();
	    }
	    function invalidate() {
	      if (stream) stream.valid = false, stream = null;
	      return projection;
	    }
	    return function() {
	      project = projectAt.apply(this, arguments);
	      projection.invert = project.invert && invert;
	      return reset();
	    };
	  }
	  function d3_geo_projectionRadians(stream) {
	    return d3_geo_transformPoint(stream, function(x, y) {
	      stream.point(x * d3_radians, y * d3_radians);
	    });
	  }
	  function d3_geo_equirectangular(λ, φ) {
	    return [ λ, φ ];
	  }
	  (d3.geo.equirectangular = function() {
	    return d3_geo_projection(d3_geo_equirectangular);
	  }).raw = d3_geo_equirectangular.invert = d3_geo_equirectangular;
	  d3.geo.rotation = function(rotate) {
	    rotate = d3_geo_rotation(rotate[0] % 360 * d3_radians, rotate[1] * d3_radians, rotate.length > 2 ? rotate[2] * d3_radians : 0);
	    function forward(coordinates) {
	      coordinates = rotate(coordinates[0] * d3_radians, coordinates[1] * d3_radians);
	      return coordinates[0] *= d3_degrees, coordinates[1] *= d3_degrees, coordinates;
	    }
	    forward.invert = function(coordinates) {
	      coordinates = rotate.invert(coordinates[0] * d3_radians, coordinates[1] * d3_radians);
	      return coordinates[0] *= d3_degrees, coordinates[1] *= d3_degrees, coordinates;
	    };
	    return forward;
	  };
	  function d3_geo_identityRotation(λ, φ) {
	    return [ λ > π ? λ - τ : λ < -π ? λ + τ : λ, φ ];
	  }
	  d3_geo_identityRotation.invert = d3_geo_equirectangular;
	  function d3_geo_rotation(δλ, δφ, δγ) {
	    return δλ ? δφ || δγ ? d3_geo_compose(d3_geo_rotationλ(δλ), d3_geo_rotationφγ(δφ, δγ)) : d3_geo_rotationλ(δλ) : δφ || δγ ? d3_geo_rotationφγ(δφ, δγ) : d3_geo_identityRotation;
	  }
	  function d3_geo_forwardRotationλ(δλ) {
	    return function(λ, φ) {
	      return λ += δλ, [ λ > π ? λ - τ : λ < -π ? λ + τ : λ, φ ];
	    };
	  }
	  function d3_geo_rotationλ(δλ) {
	    var rotation = d3_geo_forwardRotationλ(δλ);
	    rotation.invert = d3_geo_forwardRotationλ(-δλ);
	    return rotation;
	  }
	  function d3_geo_rotationφγ(δφ, δγ) {
	    var cosδφ = Math.cos(δφ), sinδφ = Math.sin(δφ), cosδγ = Math.cos(δγ), sinδγ = Math.sin(δγ);
	    function rotation(λ, φ) {
	      var cosφ = Math.cos(φ), x = Math.cos(λ) * cosφ, y = Math.sin(λ) * cosφ, z = Math.sin(φ), k = z * cosδφ + x * sinδφ;
	      return [ Math.atan2(y * cosδγ - k * sinδγ, x * cosδφ - z * sinδφ), d3_asin(k * cosδγ + y * sinδγ) ];
	    }
	    rotation.invert = function(λ, φ) {
	      var cosφ = Math.cos(φ), x = Math.cos(λ) * cosφ, y = Math.sin(λ) * cosφ, z = Math.sin(φ), k = z * cosδγ - y * sinδγ;
	      return [ Math.atan2(y * cosδγ + z * sinδγ, x * cosδφ + k * sinδφ), d3_asin(k * cosδφ - x * sinδφ) ];
	    };
	    return rotation;
	  }
	  d3.geo.circle = function() {
	    var origin = [ 0, 0 ], angle, precision = 6, interpolate;
	    function circle() {
	      var center = typeof origin === "function" ? origin.apply(this, arguments) : origin, rotate = d3_geo_rotation(-center[0] * d3_radians, -center[1] * d3_radians, 0).invert, ring = [];
	      interpolate(null, null, 1, {
	        point: function(x, y) {
	          ring.push(x = rotate(x, y));
	          x[0] *= d3_degrees, x[1] *= d3_degrees;
	        }
	      });
	      return {
	        type: "Polygon",
	        coordinates: [ ring ]
	      };
	    }
	    circle.origin = function(x) {
	      if (!arguments.length) return origin;
	      origin = x;
	      return circle;
	    };
	    circle.angle = function(x) {
	      if (!arguments.length) return angle;
	      interpolate = d3_geo_circleInterpolate((angle = +x) * d3_radians, precision * d3_radians);
	      return circle;
	    };
	    circle.precision = function(_) {
	      if (!arguments.length) return precision;
	      interpolate = d3_geo_circleInterpolate(angle * d3_radians, (precision = +_) * d3_radians);
	      return circle;
	    };
	    return circle.angle(90);
	  };
	  function d3_geo_circleInterpolate(radius, precision) {
	    var cr = Math.cos(radius), sr = Math.sin(radius);
	    return function(from, to, direction, listener) {
	      var step = direction * precision;
	      if (from != null) {
	        from = d3_geo_circleAngle(cr, from);
	        to = d3_geo_circleAngle(cr, to);
	        if (direction > 0 ? from < to : from > to) from += direction * τ;
	      } else {
	        from = radius + direction * τ;
	        to = radius - .5 * step;
	      }
	      for (var point, t = from; direction > 0 ? t > to : t < to; t -= step) {
	        listener.point((point = d3_geo_spherical([ cr, -sr * Math.cos(t), -sr * Math.sin(t) ]))[0], point[1]);
	      }
	    };
	  }
	  function d3_geo_circleAngle(cr, point) {
	    var a = d3_geo_cartesian(point);
	    a[0] -= cr;
	    d3_geo_cartesianNormalize(a);
	    var angle = d3_acos(-a[1]);
	    return ((-a[2] < 0 ? -angle : angle) + 2 * Math.PI - ε) % (2 * Math.PI);
	  }
	  d3.geo.distance = function(a, b) {
	    var Δλ = (b[0] - a[0]) * d3_radians, φ0 = a[1] * d3_radians, φ1 = b[1] * d3_radians, sinΔλ = Math.sin(Δλ), cosΔλ = Math.cos(Δλ), sinφ0 = Math.sin(φ0), cosφ0 = Math.cos(φ0), sinφ1 = Math.sin(φ1), cosφ1 = Math.cos(φ1), t;
	    return Math.atan2(Math.sqrt((t = cosφ1 * sinΔλ) * t + (t = cosφ0 * sinφ1 - sinφ0 * cosφ1 * cosΔλ) * t), sinφ0 * sinφ1 + cosφ0 * cosφ1 * cosΔλ);
	  };
	  d3.geo.graticule = function() {
	    var x1, x0, X1, X0, y1, y0, Y1, Y0, dx = 10, dy = dx, DX = 90, DY = 360, x, y, X, Y, precision = 2.5;
	    function graticule() {
	      return {
	        type: "MultiLineString",
	        coordinates: lines()
	      };
	    }
	    function lines() {
	      return d3.range(Math.ceil(X0 / DX) * DX, X1, DX).map(X).concat(d3.range(Math.ceil(Y0 / DY) * DY, Y1, DY).map(Y)).concat(d3.range(Math.ceil(x0 / dx) * dx, x1, dx).filter(function(x) {
	        return abs(x % DX) > ε;
	      }).map(x)).concat(d3.range(Math.ceil(y0 / dy) * dy, y1, dy).filter(function(y) {
	        return abs(y % DY) > ε;
	      }).map(y));
	    }
	    graticule.lines = function() {
	      return lines().map(function(coordinates) {
	        return {
	          type: "LineString",
	          coordinates: coordinates
	        };
	      });
	    };
	    graticule.outline = function() {
	      return {
	        type: "Polygon",
	        coordinates: [ X(X0).concat(Y(Y1).slice(1), X(X1).reverse().slice(1), Y(Y0).reverse().slice(1)) ]
	      };
	    };
	    graticule.extent = function(_) {
	      if (!arguments.length) return graticule.minorExtent();
	      return graticule.majorExtent(_).minorExtent(_);
	    };
	    graticule.majorExtent = function(_) {
	      if (!arguments.length) return [ [ X0, Y0 ], [ X1, Y1 ] ];
	      X0 = +_[0][0], X1 = +_[1][0];
	      Y0 = +_[0][1], Y1 = +_[1][1];
	      if (X0 > X1) _ = X0, X0 = X1, X1 = _;
	      if (Y0 > Y1) _ = Y0, Y0 = Y1, Y1 = _;
	      return graticule.precision(precision);
	    };
	    graticule.minorExtent = function(_) {
	      if (!arguments.length) return [ [ x0, y0 ], [ x1, y1 ] ];
	      x0 = +_[0][0], x1 = +_[1][0];
	      y0 = +_[0][1], y1 = +_[1][1];
	      if (x0 > x1) _ = x0, x0 = x1, x1 = _;
	      if (y0 > y1) _ = y0, y0 = y1, y1 = _;
	      return graticule.precision(precision);
	    };
	    graticule.step = function(_) {
	      if (!arguments.length) return graticule.minorStep();
	      return graticule.majorStep(_).minorStep(_);
	    };
	    graticule.majorStep = function(_) {
	      if (!arguments.length) return [ DX, DY ];
	      DX = +_[0], DY = +_[1];
	      return graticule;
	    };
	    graticule.minorStep = function(_) {
	      if (!arguments.length) return [ dx, dy ];
	      dx = +_[0], dy = +_[1];
	      return graticule;
	    };
	    graticule.precision = function(_) {
	      if (!arguments.length) return precision;
	      precision = +_;
	      x = d3_geo_graticuleX(y0, y1, 90);
	      y = d3_geo_graticuleY(x0, x1, precision);
	      X = d3_geo_graticuleX(Y0, Y1, 90);
	      Y = d3_geo_graticuleY(X0, X1, precision);
	      return graticule;
	    };
	    return graticule.majorExtent([ [ -180, -90 + ε ], [ 180, 90 - ε ] ]).minorExtent([ [ -180, -80 - ε ], [ 180, 80 + ε ] ]);
	  };
	  function d3_geo_graticuleX(y0, y1, dy) {
	    var y = d3.range(y0, y1 - ε, dy).concat(y1);
	    return function(x) {
	      return y.map(function(y) {
	        return [ x, y ];
	      });
	    };
	  }
	  function d3_geo_graticuleY(x0, x1, dx) {
	    var x = d3.range(x0, x1 - ε, dx).concat(x1);
	    return function(y) {
	      return x.map(function(x) {
	        return [ x, y ];
	      });
	    };
	  }
	  function d3_source(d) {
	    return d.source;
	  }
	  function d3_target(d) {
	    return d.target;
	  }
	  d3.geo.greatArc = function() {
	    var source = d3_source, source_, target = d3_target, target_;
	    function greatArc() {
	      return {
	        type: "LineString",
	        coordinates: [ source_ || source.apply(this, arguments), target_ || target.apply(this, arguments) ]
	      };
	    }
	    greatArc.distance = function() {
	      return d3.geo.distance(source_ || source.apply(this, arguments), target_ || target.apply(this, arguments));
	    };
	    greatArc.source = function(_) {
	      if (!arguments.length) return source;
	      source = _, source_ = typeof _ === "function" ? null : _;
	      return greatArc;
	    };
	    greatArc.target = function(_) {
	      if (!arguments.length) return target;
	      target = _, target_ = typeof _ === "function" ? null : _;
	      return greatArc;
	    };
	    greatArc.precision = function() {
	      return arguments.length ? greatArc : 0;
	    };
	    return greatArc;
	  };
	  d3.geo.interpolate = function(source, target) {
	    return d3_geo_interpolate(source[0] * d3_radians, source[1] * d3_radians, target[0] * d3_radians, target[1] * d3_radians);
	  };
	  function d3_geo_interpolate(x0, y0, x1, y1) {
	    var cy0 = Math.cos(y0), sy0 = Math.sin(y0), cy1 = Math.cos(y1), sy1 = Math.sin(y1), kx0 = cy0 * Math.cos(x0), ky0 = cy0 * Math.sin(x0), kx1 = cy1 * Math.cos(x1), ky1 = cy1 * Math.sin(x1), d = 2 * Math.asin(Math.sqrt(d3_haversin(y1 - y0) + cy0 * cy1 * d3_haversin(x1 - x0))), k = 1 / Math.sin(d);
	    var interpolate = d ? function(t) {
	      var B = Math.sin(t *= d) * k, A = Math.sin(d - t) * k, x = A * kx0 + B * kx1, y = A * ky0 + B * ky1, z = A * sy0 + B * sy1;
	      return [ Math.atan2(y, x) * d3_degrees, Math.atan2(z, Math.sqrt(x * x + y * y)) * d3_degrees ];
	    } : function() {
	      return [ x0 * d3_degrees, y0 * d3_degrees ];
	    };
	    interpolate.distance = d;
	    return interpolate;
	  }
	  d3.geo.length = function(object) {
	    d3_geo_lengthSum = 0;
	    d3.geo.stream(object, d3_geo_length);
	    return d3_geo_lengthSum;
	  };
	  var d3_geo_lengthSum;
	  var d3_geo_length = {
	    sphere: d3_noop,
	    point: d3_noop,
	    lineStart: d3_geo_lengthLineStart,
	    lineEnd: d3_noop,
	    polygonStart: d3_noop,
	    polygonEnd: d3_noop
	  };
	  function d3_geo_lengthLineStart() {
	    var λ0, sinφ0, cosφ0;
	    d3_geo_length.point = function(λ, φ) {
	      λ0 = λ * d3_radians, sinφ0 = Math.sin(φ *= d3_radians), cosφ0 = Math.cos(φ);
	      d3_geo_length.point = nextPoint;
	    };
	    d3_geo_length.lineEnd = function() {
	      d3_geo_length.point = d3_geo_length.lineEnd = d3_noop;
	    };
	    function nextPoint(λ, φ) {
	      var sinφ = Math.sin(φ *= d3_radians), cosφ = Math.cos(φ), t = abs((λ *= d3_radians) - λ0), cosΔλ = Math.cos(t);
	      d3_geo_lengthSum += Math.atan2(Math.sqrt((t = cosφ * Math.sin(t)) * t + (t = cosφ0 * sinφ - sinφ0 * cosφ * cosΔλ) * t), sinφ0 * sinφ + cosφ0 * cosφ * cosΔλ);
	      λ0 = λ, sinφ0 = sinφ, cosφ0 = cosφ;
	    }
	  }
	  function d3_geo_azimuthal(scale, angle) {
	    function azimuthal(λ, φ) {
	      var cosλ = Math.cos(λ), cosφ = Math.cos(φ), k = scale(cosλ * cosφ);
	      return [ k * cosφ * Math.sin(λ), k * Math.sin(φ) ];
	    }
	    azimuthal.invert = function(x, y) {
	      var ρ = Math.sqrt(x * x + y * y), c = angle(ρ), sinc = Math.sin(c), cosc = Math.cos(c);
	      return [ Math.atan2(x * sinc, ρ * cosc), Math.asin(ρ && y * sinc / ρ) ];
	    };
	    return azimuthal;
	  }
	  var d3_geo_azimuthalEqualArea = d3_geo_azimuthal(function(cosλcosφ) {
	    return Math.sqrt(2 / (1 + cosλcosφ));
	  }, function(ρ) {
	    return 2 * Math.asin(ρ / 2);
	  });
	  (d3.geo.azimuthalEqualArea = function() {
	    return d3_geo_projection(d3_geo_azimuthalEqualArea);
	  }).raw = d3_geo_azimuthalEqualArea;
	  var d3_geo_azimuthalEquidistant = d3_geo_azimuthal(function(cosλcosφ) {
	    var c = Math.acos(cosλcosφ);
	    return c && c / Math.sin(c);
	  }, d3_identity);
	  (d3.geo.azimuthalEquidistant = function() {
	    return d3_geo_projection(d3_geo_azimuthalEquidistant);
	  }).raw = d3_geo_azimuthalEquidistant;
	  function d3_geo_conicConformal(φ0, φ1) {
	    var cosφ0 = Math.cos(φ0), t = function(φ) {
	      return Math.tan(π / 4 + φ / 2);
	    }, n = φ0 === φ1 ? Math.sin(φ0) : Math.log(cosφ0 / Math.cos(φ1)) / Math.log(t(φ1) / t(φ0)), F = cosφ0 * Math.pow(t(φ0), n) / n;
	    if (!n) return d3_geo_mercator;
	    function forward(λ, φ) {
	      if (F > 0) {
	        if (φ < -halfπ + ε) φ = -halfπ + ε;
	      } else {
	        if (φ > halfπ - ε) φ = halfπ - ε;
	      }
	      var ρ = F / Math.pow(t(φ), n);
	      return [ ρ * Math.sin(n * λ), F - ρ * Math.cos(n * λ) ];
	    }
	    forward.invert = function(x, y) {
	      var ρ0_y = F - y, ρ = d3_sgn(n) * Math.sqrt(x * x + ρ0_y * ρ0_y);
	      return [ Math.atan2(x, ρ0_y) / n, 2 * Math.atan(Math.pow(F / ρ, 1 / n)) - halfπ ];
	    };
	    return forward;
	  }
	  (d3.geo.conicConformal = function() {
	    return d3_geo_conic(d3_geo_conicConformal);
	  }).raw = d3_geo_conicConformal;
	  function d3_geo_conicEquidistant(φ0, φ1) {
	    var cosφ0 = Math.cos(φ0), n = φ0 === φ1 ? Math.sin(φ0) : (cosφ0 - Math.cos(φ1)) / (φ1 - φ0), G = cosφ0 / n + φ0;
	    if (abs(n) < ε) return d3_geo_equirectangular;
	    function forward(λ, φ) {
	      var ρ = G - φ;
	      return [ ρ * Math.sin(n * λ), G - ρ * Math.cos(n * λ) ];
	    }
	    forward.invert = function(x, y) {
	      var ρ0_y = G - y;
	      return [ Math.atan2(x, ρ0_y) / n, G - d3_sgn(n) * Math.sqrt(x * x + ρ0_y * ρ0_y) ];
	    };
	    return forward;
	  }
	  (d3.geo.conicEquidistant = function() {
	    return d3_geo_conic(d3_geo_conicEquidistant);
	  }).raw = d3_geo_conicEquidistant;
	  var d3_geo_gnomonic = d3_geo_azimuthal(function(cosλcosφ) {
	    return 1 / cosλcosφ;
	  }, Math.atan);
	  (d3.geo.gnomonic = function() {
	    return d3_geo_projection(d3_geo_gnomonic);
	  }).raw = d3_geo_gnomonic;
	  function d3_geo_mercator(λ, φ) {
	    return [ λ, Math.log(Math.tan(π / 4 + φ / 2)) ];
	  }
	  d3_geo_mercator.invert = function(x, y) {
	    return [ x, 2 * Math.atan(Math.exp(y)) - halfπ ];
	  };
	  function d3_geo_mercatorProjection(project) {
	    var m = d3_geo_projection(project), scale = m.scale, translate = m.translate, clipExtent = m.clipExtent, clipAuto;
	    m.scale = function() {
	      var v = scale.apply(m, arguments);
	      return v === m ? clipAuto ? m.clipExtent(null) : m : v;
	    };
	    m.translate = function() {
	      var v = translate.apply(m, arguments);
	      return v === m ? clipAuto ? m.clipExtent(null) : m : v;
	    };
	    m.clipExtent = function(_) {
	      var v = clipExtent.apply(m, arguments);
	      if (v === m) {
	        if (clipAuto = _ == null) {
	          var k = π * scale(), t = translate();
	          clipExtent([ [ t[0] - k, t[1] - k ], [ t[0] + k, t[1] + k ] ]);
	        }
	      } else if (clipAuto) {
	        v = null;
	      }
	      return v;
	    };
	    return m.clipExtent(null);
	  }
	  (d3.geo.mercator = function() {
	    return d3_geo_mercatorProjection(d3_geo_mercator);
	  }).raw = d3_geo_mercator;
	  var d3_geo_orthographic = d3_geo_azimuthal(function() {
	    return 1;
	  }, Math.asin);
	  (d3.geo.orthographic = function() {
	    return d3_geo_projection(d3_geo_orthographic);
	  }).raw = d3_geo_orthographic;
	  var d3_geo_stereographic = d3_geo_azimuthal(function(cosλcosφ) {
	    return 1 / (1 + cosλcosφ);
	  }, function(ρ) {
	    return 2 * Math.atan(ρ);
	  });
	  (d3.geo.stereographic = function() {
	    return d3_geo_projection(d3_geo_stereographic);
	  }).raw = d3_geo_stereographic;
	  function d3_geo_transverseMercator(λ, φ) {
	    return [ Math.log(Math.tan(π / 4 + φ / 2)), -λ ];
	  }
	  d3_geo_transverseMercator.invert = function(x, y) {
	    return [ -y, 2 * Math.atan(Math.exp(x)) - halfπ ];
	  };
	  (d3.geo.transverseMercator = function() {
	    var projection = d3_geo_mercatorProjection(d3_geo_transverseMercator), center = projection.center, rotate = projection.rotate;
	    projection.center = function(_) {
	      return _ ? center([ -_[1], _[0] ]) : (_ = center(), [ _[1], -_[0] ]);
	    };
	    projection.rotate = function(_) {
	      return _ ? rotate([ _[0], _[1], _.length > 2 ? _[2] + 90 : 90 ]) : (_ = rotate(), 
	      [ _[0], _[1], _[2] - 90 ]);
	    };
	    return rotate([ 0, 0, 90 ]);
	  }).raw = d3_geo_transverseMercator;
	  d3.geom = {};
	  function d3_geom_pointX(d) {
	    return d[0];
	  }
	  function d3_geom_pointY(d) {
	    return d[1];
	  }
	  d3.geom.hull = function(vertices) {
	    var x = d3_geom_pointX, y = d3_geom_pointY;
	    if (arguments.length) return hull(vertices);
	    function hull(data) {
	      if (data.length < 3) return [];
	      var fx = d3_functor(x), fy = d3_functor(y), i, n = data.length, points = [], flippedPoints = [];
	      for (i = 0; i < n; i++) {
	        points.push([ +fx.call(this, data[i], i), +fy.call(this, data[i], i), i ]);
	      }
	      points.sort(d3_geom_hullOrder);
	      for (i = 0; i < n; i++) flippedPoints.push([ points[i][0], -points[i][1] ]);
	      var upper = d3_geom_hullUpper(points), lower = d3_geom_hullUpper(flippedPoints);
	      var skipLeft = lower[0] === upper[0], skipRight = lower[lower.length - 1] === upper[upper.length - 1], polygon = [];
	      for (i = upper.length - 1; i >= 0; --i) polygon.push(data[points[upper[i]][2]]);
	      for (i = +skipLeft; i < lower.length - skipRight; ++i) polygon.push(data[points[lower[i]][2]]);
	      return polygon;
	    }
	    hull.x = function(_) {
	      return arguments.length ? (x = _, hull) : x;
	    };
	    hull.y = function(_) {
	      return arguments.length ? (y = _, hull) : y;
	    };
	    return hull;
	  };
	  function d3_geom_hullUpper(points) {
	    var n = points.length, hull = [ 0, 1 ], hs = 2;
	    for (var i = 2; i < n; i++) {
	      while (hs > 1 && d3_cross2d(points[hull[hs - 2]], points[hull[hs - 1]], points[i]) <= 0) --hs;
	      hull[hs++] = i;
	    }
	    return hull.slice(0, hs);
	  }
	  function d3_geom_hullOrder(a, b) {
	    return a[0] - b[0] || a[1] - b[1];
	  }
	  d3.geom.polygon = function(coordinates) {
	    d3_subclass(coordinates, d3_geom_polygonPrototype);
	    return coordinates;
	  };
	  var d3_geom_polygonPrototype = d3.geom.polygon.prototype = [];
	  d3_geom_polygonPrototype.area = function() {
	    var i = -1, n = this.length, a, b = this[n - 1], area = 0;
	    while (++i < n) {
	      a = b;
	      b = this[i];
	      area += a[1] * b[0] - a[0] * b[1];
	    }
	    return area * .5;
	  };
	  d3_geom_polygonPrototype.centroid = function(k) {
	    var i = -1, n = this.length, x = 0, y = 0, a, b = this[n - 1], c;
	    if (!arguments.length) k = -1 / (6 * this.area());
	    while (++i < n) {
	      a = b;
	      b = this[i];
	      c = a[0] * b[1] - b[0] * a[1];
	      x += (a[0] + b[0]) * c;
	      y += (a[1] + b[1]) * c;
	    }
	    return [ x * k, y * k ];
	  };
	  d3_geom_polygonPrototype.clip = function(subject) {
	    var input, closed = d3_geom_polygonClosed(subject), i = -1, n = this.length - d3_geom_polygonClosed(this), j, m, a = this[n - 1], b, c, d;
	    while (++i < n) {
	      input = subject.slice();
	      subject.length = 0;
	      b = this[i];
	      c = input[(m = input.length - closed) - 1];
	      j = -1;
	      while (++j < m) {
	        d = input[j];
	        if (d3_geom_polygonInside(d, a, b)) {
	          if (!d3_geom_polygonInside(c, a, b)) {
	            subject.push(d3_geom_polygonIntersect(c, d, a, b));
	          }
	          subject.push(d);
	        } else if (d3_geom_polygonInside(c, a, b)) {
	          subject.push(d3_geom_polygonIntersect(c, d, a, b));
	        }
	        c = d;
	      }
	      if (closed) subject.push(subject[0]);
	      a = b;
	    }
	    return subject;
	  };
	  function d3_geom_polygonInside(p, a, b) {
	    return (b[0] - a[0]) * (p[1] - a[1]) < (b[1] - a[1]) * (p[0] - a[0]);
	  }
	  function d3_geom_polygonIntersect(c, d, a, b) {
	    var x1 = c[0], x3 = a[0], x21 = d[0] - x1, x43 = b[0] - x3, y1 = c[1], y3 = a[1], y21 = d[1] - y1, y43 = b[1] - y3, ua = (x43 * (y1 - y3) - y43 * (x1 - x3)) / (y43 * x21 - x43 * y21);
	    return [ x1 + ua * x21, y1 + ua * y21 ];
	  }
	  function d3_geom_polygonClosed(coordinates) {
	    var a = coordinates[0], b = coordinates[coordinates.length - 1];
	    return !(a[0] - b[0] || a[1] - b[1]);
	  }
	  var d3_geom_voronoiEdges, d3_geom_voronoiCells, d3_geom_voronoiBeaches, d3_geom_voronoiBeachPool = [], d3_geom_voronoiFirstCircle, d3_geom_voronoiCircles, d3_geom_voronoiCirclePool = [];
	  function d3_geom_voronoiBeach() {
	    d3_geom_voronoiRedBlackNode(this);
	    this.edge = this.site = this.circle = null;
	  }
	  function d3_geom_voronoiCreateBeach(site) {
	    var beach = d3_geom_voronoiBeachPool.pop() || new d3_geom_voronoiBeach();
	    beach.site = site;
	    return beach;
	  }
	  function d3_geom_voronoiDetachBeach(beach) {
	    d3_geom_voronoiDetachCircle(beach);
	    d3_geom_voronoiBeaches.remove(beach);
	    d3_geom_voronoiBeachPool.push(beach);
	    d3_geom_voronoiRedBlackNode(beach);
	  }
	  function d3_geom_voronoiRemoveBeach(beach) {
	    var circle = beach.circle, x = circle.x, y = circle.cy, vertex = {
	      x: x,
	      y: y
	    }, previous = beach.P, next = beach.N, disappearing = [ beach ];
	    d3_geom_voronoiDetachBeach(beach);
	    var lArc = previous;
	    while (lArc.circle && abs(x - lArc.circle.x) < ε && abs(y - lArc.circle.cy) < ε) {
	      previous = lArc.P;
	      disappearing.unshift(lArc);
	      d3_geom_voronoiDetachBeach(lArc);
	      lArc = previous;
	    }
	    disappearing.unshift(lArc);
	    d3_geom_voronoiDetachCircle(lArc);
	    var rArc = next;
	    while (rArc.circle && abs(x - rArc.circle.x) < ε && abs(y - rArc.circle.cy) < ε) {
	      next = rArc.N;
	      disappearing.push(rArc);
	      d3_geom_voronoiDetachBeach(rArc);
	      rArc = next;
	    }
	    disappearing.push(rArc);
	    d3_geom_voronoiDetachCircle(rArc);
	    var nArcs = disappearing.length, iArc;
	    for (iArc = 1; iArc < nArcs; ++iArc) {
	      rArc = disappearing[iArc];
	      lArc = disappearing[iArc - 1];
	      d3_geom_voronoiSetEdgeEnd(rArc.edge, lArc.site, rArc.site, vertex);
	    }
	    lArc = disappearing[0];
	    rArc = disappearing[nArcs - 1];
	    rArc.edge = d3_geom_voronoiCreateEdge(lArc.site, rArc.site, null, vertex);
	    d3_geom_voronoiAttachCircle(lArc);
	    d3_geom_voronoiAttachCircle(rArc);
	  }
	  function d3_geom_voronoiAddBeach(site) {
	    var x = site.x, directrix = site.y, lArc, rArc, dxl, dxr, node = d3_geom_voronoiBeaches._;
	    while (node) {
	      dxl = d3_geom_voronoiLeftBreakPoint(node, directrix) - x;
	      if (dxl > ε) node = node.L; else {
	        dxr = x - d3_geom_voronoiRightBreakPoint(node, directrix);
	        if (dxr > ε) {
	          if (!node.R) {
	            lArc = node;
	            break;
	          }
	          node = node.R;
	        } else {
	          if (dxl > -ε) {
	            lArc = node.P;
	            rArc = node;
	          } else if (dxr > -ε) {
	            lArc = node;
	            rArc = node.N;
	          } else {
	            lArc = rArc = node;
	          }
	          break;
	        }
	      }
	    }
	    var newArc = d3_geom_voronoiCreateBeach(site);
	    d3_geom_voronoiBeaches.insert(lArc, newArc);
	    if (!lArc && !rArc) return;
	    if (lArc === rArc) {
	      d3_geom_voronoiDetachCircle(lArc);
	      rArc = d3_geom_voronoiCreateBeach(lArc.site);
	      d3_geom_voronoiBeaches.insert(newArc, rArc);
	      newArc.edge = rArc.edge = d3_geom_voronoiCreateEdge(lArc.site, newArc.site);
	      d3_geom_voronoiAttachCircle(lArc);
	      d3_geom_voronoiAttachCircle(rArc);
	      return;
	    }
	    if (!rArc) {
	      newArc.edge = d3_geom_voronoiCreateEdge(lArc.site, newArc.site);
	      return;
	    }
	    d3_geom_voronoiDetachCircle(lArc);
	    d3_geom_voronoiDetachCircle(rArc);
	    var lSite = lArc.site, ax = lSite.x, ay = lSite.y, bx = site.x - ax, by = site.y - ay, rSite = rArc.site, cx = rSite.x - ax, cy = rSite.y - ay, d = 2 * (bx * cy - by * cx), hb = bx * bx + by * by, hc = cx * cx + cy * cy, vertex = {
	      x: (cy * hb - by * hc) / d + ax,
	      y: (bx * hc - cx * hb) / d + ay
	    };
	    d3_geom_voronoiSetEdgeEnd(rArc.edge, lSite, rSite, vertex);
	    newArc.edge = d3_geom_voronoiCreateEdge(lSite, site, null, vertex);
	    rArc.edge = d3_geom_voronoiCreateEdge(site, rSite, null, vertex);
	    d3_geom_voronoiAttachCircle(lArc);
	    d3_geom_voronoiAttachCircle(rArc);
	  }
	  function d3_geom_voronoiLeftBreakPoint(arc, directrix) {
	    var site = arc.site, rfocx = site.x, rfocy = site.y, pby2 = rfocy - directrix;
	    if (!pby2) return rfocx;
	    var lArc = arc.P;
	    if (!lArc) return -Infinity;
	    site = lArc.site;
	    var lfocx = site.x, lfocy = site.y, plby2 = lfocy - directrix;
	    if (!plby2) return lfocx;
	    var hl = lfocx - rfocx, aby2 = 1 / pby2 - 1 / plby2, b = hl / plby2;
	    if (aby2) return (-b + Math.sqrt(b * b - 2 * aby2 * (hl * hl / (-2 * plby2) - lfocy + plby2 / 2 + rfocy - pby2 / 2))) / aby2 + rfocx;
	    return (rfocx + lfocx) / 2;
	  }
	  function d3_geom_voronoiRightBreakPoint(arc, directrix) {
	    var rArc = arc.N;
	    if (rArc) return d3_geom_voronoiLeftBreakPoint(rArc, directrix);
	    var site = arc.site;
	    return site.y === directrix ? site.x : Infinity;
	  }
	  function d3_geom_voronoiCell(site) {
	    this.site = site;
	    this.edges = [];
	  }
	  d3_geom_voronoiCell.prototype.prepare = function() {
	    var halfEdges = this.edges, iHalfEdge = halfEdges.length, edge;
	    while (iHalfEdge--) {
	      edge = halfEdges[iHalfEdge].edge;
	      if (!edge.b || !edge.a) halfEdges.splice(iHalfEdge, 1);
	    }
	    halfEdges.sort(d3_geom_voronoiHalfEdgeOrder);
	    return halfEdges.length;
	  };
	  function d3_geom_voronoiCloseCells(extent) {
	    var x0 = extent[0][0], x1 = extent[1][0], y0 = extent[0][1], y1 = extent[1][1], x2, y2, x3, y3, cells = d3_geom_voronoiCells, iCell = cells.length, cell, iHalfEdge, halfEdges, nHalfEdges, start, end;
	    while (iCell--) {
	      cell = cells[iCell];
	      if (!cell || !cell.prepare()) continue;
	      halfEdges = cell.edges;
	      nHalfEdges = halfEdges.length;
	      iHalfEdge = 0;
	      while (iHalfEdge < nHalfEdges) {
	        end = halfEdges[iHalfEdge].end(), x3 = end.x, y3 = end.y;
	        start = halfEdges[++iHalfEdge % nHalfEdges].start(), x2 = start.x, y2 = start.y;
	        if (abs(x3 - x2) > ε || abs(y3 - y2) > ε) {
	          halfEdges.splice(iHalfEdge, 0, new d3_geom_voronoiHalfEdge(d3_geom_voronoiCreateBorderEdge(cell.site, end, abs(x3 - x0) < ε && y1 - y3 > ε ? {
	            x: x0,
	            y: abs(x2 - x0) < ε ? y2 : y1
	          } : abs(y3 - y1) < ε && x1 - x3 > ε ? {
	            x: abs(y2 - y1) < ε ? x2 : x1,
	            y: y1
	          } : abs(x3 - x1) < ε && y3 - y0 > ε ? {
	            x: x1,
	            y: abs(x2 - x1) < ε ? y2 : y0
	          } : abs(y3 - y0) < ε && x3 - x0 > ε ? {
	            x: abs(y2 - y0) < ε ? x2 : x0,
	            y: y0
	          } : null), cell.site, null));
	          ++nHalfEdges;
	        }
	      }
	    }
	  }
	  function d3_geom_voronoiHalfEdgeOrder(a, b) {
	    return b.angle - a.angle;
	  }
	  function d3_geom_voronoiCircle() {
	    d3_geom_voronoiRedBlackNode(this);
	    this.x = this.y = this.arc = this.site = this.cy = null;
	  }
	  function d3_geom_voronoiAttachCircle(arc) {
	    var lArc = arc.P, rArc = arc.N;
	    if (!lArc || !rArc) return;
	    var lSite = lArc.site, cSite = arc.site, rSite = rArc.site;
	    if (lSite === rSite) return;
	    var bx = cSite.x, by = cSite.y, ax = lSite.x - bx, ay = lSite.y - by, cx = rSite.x - bx, cy = rSite.y - by;
	    var d = 2 * (ax * cy - ay * cx);
	    if (d >= -ε2) return;
	    var ha = ax * ax + ay * ay, hc = cx * cx + cy * cy, x = (cy * ha - ay * hc) / d, y = (ax * hc - cx * ha) / d, cy = y + by;
	    var circle = d3_geom_voronoiCirclePool.pop() || new d3_geom_voronoiCircle();
	    circle.arc = arc;
	    circle.site = cSite;
	    circle.x = x + bx;
	    circle.y = cy + Math.sqrt(x * x + y * y);
	    circle.cy = cy;
	    arc.circle = circle;
	    var before = null, node = d3_geom_voronoiCircles._;
	    while (node) {
	      if (circle.y < node.y || circle.y === node.y && circle.x <= node.x) {
	        if (node.L) node = node.L; else {
	          before = node.P;
	          break;
	        }
	      } else {
	        if (node.R) node = node.R; else {
	          before = node;
	          break;
	        }
	      }
	    }
	    d3_geom_voronoiCircles.insert(before, circle);
	    if (!before) d3_geom_voronoiFirstCircle = circle;
	  }
	  function d3_geom_voronoiDetachCircle(arc) {
	    var circle = arc.circle;
	    if (circle) {
	      if (!circle.P) d3_geom_voronoiFirstCircle = circle.N;
	      d3_geom_voronoiCircles.remove(circle);
	      d3_geom_voronoiCirclePool.push(circle);
	      d3_geom_voronoiRedBlackNode(circle);
	      arc.circle = null;
	    }
	  }
	  function d3_geom_voronoiClipEdges(extent) {
	    var edges = d3_geom_voronoiEdges, clip = d3_geom_clipLine(extent[0][0], extent[0][1], extent[1][0], extent[1][1]), i = edges.length, e;
	    while (i--) {
	      e = edges[i];
	      if (!d3_geom_voronoiConnectEdge(e, extent) || !clip(e) || abs(e.a.x - e.b.x) < ε && abs(e.a.y - e.b.y) < ε) {
	        e.a = e.b = null;
	        edges.splice(i, 1);
	      }
	    }
	  }
	  function d3_geom_voronoiConnectEdge(edge, extent) {
	    var vb = edge.b;
	    if (vb) return true;
	    var va = edge.a, x0 = extent[0][0], x1 = extent[1][0], y0 = extent[0][1], y1 = extent[1][1], lSite = edge.l, rSite = edge.r, lx = lSite.x, ly = lSite.y, rx = rSite.x, ry = rSite.y, fx = (lx + rx) / 2, fy = (ly + ry) / 2, fm, fb;
	    if (ry === ly) {
	      if (fx < x0 || fx >= x1) return;
	      if (lx > rx) {
	        if (!va) va = {
	          x: fx,
	          y: y0
	        }; else if (va.y >= y1) return;
	        vb = {
	          x: fx,
	          y: y1
	        };
	      } else {
	        if (!va) va = {
	          x: fx,
	          y: y1
	        }; else if (va.y < y0) return;
	        vb = {
	          x: fx,
	          y: y0
	        };
	      }
	    } else {
	      fm = (lx - rx) / (ry - ly);
	      fb = fy - fm * fx;
	      if (fm < -1 || fm > 1) {
	        if (lx > rx) {
	          if (!va) va = {
	            x: (y0 - fb) / fm,
	            y: y0
	          }; else if (va.y >= y1) return;
	          vb = {
	            x: (y1 - fb) / fm,
	            y: y1
	          };
	        } else {
	          if (!va) va = {
	            x: (y1 - fb) / fm,
	            y: y1
	          }; else if (va.y < y0) return;
	          vb = {
	            x: (y0 - fb) / fm,
	            y: y0
	          };
	        }
	      } else {
	        if (ly < ry) {
	          if (!va) va = {
	            x: x0,
	            y: fm * x0 + fb
	          }; else if (va.x >= x1) return;
	          vb = {
	            x: x1,
	            y: fm * x1 + fb
	          };
	        } else {
	          if (!va) va = {
	            x: x1,
	            y: fm * x1 + fb
	          }; else if (va.x < x0) return;
	          vb = {
	            x: x0,
	            y: fm * x0 + fb
	          };
	        }
	      }
	    }
	    edge.a = va;
	    edge.b = vb;
	    return true;
	  }
	  function d3_geom_voronoiEdge(lSite, rSite) {
	    this.l = lSite;
	    this.r = rSite;
	    this.a = this.b = null;
	  }
	  function d3_geom_voronoiCreateEdge(lSite, rSite, va, vb) {
	    var edge = new d3_geom_voronoiEdge(lSite, rSite);
	    d3_geom_voronoiEdges.push(edge);
	    if (va) d3_geom_voronoiSetEdgeEnd(edge, lSite, rSite, va);
	    if (vb) d3_geom_voronoiSetEdgeEnd(edge, rSite, lSite, vb);
	    d3_geom_voronoiCells[lSite.i].edges.push(new d3_geom_voronoiHalfEdge(edge, lSite, rSite));
	    d3_geom_voronoiCells[rSite.i].edges.push(new d3_geom_voronoiHalfEdge(edge, rSite, lSite));
	    return edge;
	  }
	  function d3_geom_voronoiCreateBorderEdge(lSite, va, vb) {
	    var edge = new d3_geom_voronoiEdge(lSite, null);
	    edge.a = va;
	    edge.b = vb;
	    d3_geom_voronoiEdges.push(edge);
	    return edge;
	  }
	  function d3_geom_voronoiSetEdgeEnd(edge, lSite, rSite, vertex) {
	    if (!edge.a && !edge.b) {
	      edge.a = vertex;
	      edge.l = lSite;
	      edge.r = rSite;
	    } else if (edge.l === rSite) {
	      edge.b = vertex;
	    } else {
	      edge.a = vertex;
	    }
	  }
	  function d3_geom_voronoiHalfEdge(edge, lSite, rSite) {
	    var va = edge.a, vb = edge.b;
	    this.edge = edge;
	    this.site = lSite;
	    this.angle = rSite ? Math.atan2(rSite.y - lSite.y, rSite.x - lSite.x) : edge.l === lSite ? Math.atan2(vb.x - va.x, va.y - vb.y) : Math.atan2(va.x - vb.x, vb.y - va.y);
	  }
	  d3_geom_voronoiHalfEdge.prototype = {
	    start: function() {
	      return this.edge.l === this.site ? this.edge.a : this.edge.b;
	    },
	    end: function() {
	      return this.edge.l === this.site ? this.edge.b : this.edge.a;
	    }
	  };
	  function d3_geom_voronoiRedBlackTree() {
	    this._ = null;
	  }
	  function d3_geom_voronoiRedBlackNode(node) {
	    node.U = node.C = node.L = node.R = node.P = node.N = null;
	  }
	  d3_geom_voronoiRedBlackTree.prototype = {
	    insert: function(after, node) {
	      var parent, grandpa, uncle;
	      if (after) {
	        node.P = after;
	        node.N = after.N;
	        if (after.N) after.N.P = node;
	        after.N = node;
	        if (after.R) {
	          after = after.R;
	          while (after.L) after = after.L;
	          after.L = node;
	        } else {
	          after.R = node;
	        }
	        parent = after;
	      } else if (this._) {
	        after = d3_geom_voronoiRedBlackFirst(this._);
	        node.P = null;
	        node.N = after;
	        after.P = after.L = node;
	        parent = after;
	      } else {
	        node.P = node.N = null;
	        this._ = node;
	        parent = null;
	      }
	      node.L = node.R = null;
	      node.U = parent;
	      node.C = true;
	      after = node;
	      while (parent && parent.C) {
	        grandpa = parent.U;
	        if (parent === grandpa.L) {
	          uncle = grandpa.R;
	          if (uncle && uncle.C) {
	            parent.C = uncle.C = false;
	            grandpa.C = true;
	            after = grandpa;
	          } else {
	            if (after === parent.R) {
	              d3_geom_voronoiRedBlackRotateLeft(this, parent);
	              after = parent;
	              parent = after.U;
	            }
	            parent.C = false;
	            grandpa.C = true;
	            d3_geom_voronoiRedBlackRotateRight(this, grandpa);
	          }
	        } else {
	          uncle = grandpa.L;
	          if (uncle && uncle.C) {
	            parent.C = uncle.C = false;
	            grandpa.C = true;
	            after = grandpa;
	          } else {
	            if (after === parent.L) {
	              d3_geom_voronoiRedBlackRotateRight(this, parent);
	              after = parent;
	              parent = after.U;
	            }
	            parent.C = false;
	            grandpa.C = true;
	            d3_geom_voronoiRedBlackRotateLeft(this, grandpa);
	          }
	        }
	        parent = after.U;
	      }
	      this._.C = false;
	    },
	    remove: function(node) {
	      if (node.N) node.N.P = node.P;
	      if (node.P) node.P.N = node.N;
	      node.N = node.P = null;
	      var parent = node.U, sibling, left = node.L, right = node.R, next, red;
	      if (!left) next = right; else if (!right) next = left; else next = d3_geom_voronoiRedBlackFirst(right);
	      if (parent) {
	        if (parent.L === node) parent.L = next; else parent.R = next;
	      } else {
	        this._ = next;
	      }
	      if (left && right) {
	        red = next.C;
	        next.C = node.C;
	        next.L = left;
	        left.U = next;
	        if (next !== right) {
	          parent = next.U;
	          next.U = node.U;
	          node = next.R;
	          parent.L = node;
	          next.R = right;
	          right.U = next;
	        } else {
	          next.U = parent;
	          parent = next;
	          node = next.R;
	        }
	      } else {
	        red = node.C;
	        node = next;
	      }
	      if (node) node.U = parent;
	      if (red) return;
	      if (node && node.C) {
	        node.C = false;
	        return;
	      }
	      do {
	        if (node === this._) break;
	        if (node === parent.L) {
	          sibling = parent.R;
	          if (sibling.C) {
	            sibling.C = false;
	            parent.C = true;
	            d3_geom_voronoiRedBlackRotateLeft(this, parent);
	            sibling = parent.R;
	          }
	          if (sibling.L && sibling.L.C || sibling.R && sibling.R.C) {
	            if (!sibling.R || !sibling.R.C) {
	              sibling.L.C = false;
	              sibling.C = true;
	              d3_geom_voronoiRedBlackRotateRight(this, sibling);
	              sibling = parent.R;
	            }
	            sibling.C = parent.C;
	            parent.C = sibling.R.C = false;
	            d3_geom_voronoiRedBlackRotateLeft(this, parent);
	            node = this._;
	            break;
	          }
	        } else {
	          sibling = parent.L;
	          if (sibling.C) {
	            sibling.C = false;
	            parent.C = true;
	            d3_geom_voronoiRedBlackRotateRight(this, parent);
	            sibling = parent.L;
	          }
	          if (sibling.L && sibling.L.C || sibling.R && sibling.R.C) {
	            if (!sibling.L || !sibling.L.C) {
	              sibling.R.C = false;
	              sibling.C = true;
	              d3_geom_voronoiRedBlackRotateLeft(this, sibling);
	              sibling = parent.L;
	            }
	            sibling.C = parent.C;
	            parent.C = sibling.L.C = false;
	            d3_geom_voronoiRedBlackRotateRight(this, parent);
	            node = this._;
	            break;
	          }
	        }
	        sibling.C = true;
	        node = parent;
	        parent = parent.U;
	      } while (!node.C);
	      if (node) node.C = false;
	    }
	  };
	  function d3_geom_voronoiRedBlackRotateLeft(tree, node) {
	    var p = node, q = node.R, parent = p.U;
	    if (parent) {
	      if (parent.L === p) parent.L = q; else parent.R = q;
	    } else {
	      tree._ = q;
	    }
	    q.U = parent;
	    p.U = q;
	    p.R = q.L;
	    if (p.R) p.R.U = p;
	    q.L = p;
	  }
	  function d3_geom_voronoiRedBlackRotateRight(tree, node) {
	    var p = node, q = node.L, parent = p.U;
	    if (parent) {
	      if (parent.L === p) parent.L = q; else parent.R = q;
	    } else {
	      tree._ = q;
	    }
	    q.U = parent;
	    p.U = q;
	    p.L = q.R;
	    if (p.L) p.L.U = p;
	    q.R = p;
	  }
	  function d3_geom_voronoiRedBlackFirst(node) {
	    while (node.L) node = node.L;
	    return node;
	  }
	  function d3_geom_voronoi(sites, bbox) {
	    var site = sites.sort(d3_geom_voronoiVertexOrder).pop(), x0, y0, circle;
	    d3_geom_voronoiEdges = [];
	    d3_geom_voronoiCells = new Array(sites.length);
	    d3_geom_voronoiBeaches = new d3_geom_voronoiRedBlackTree();
	    d3_geom_voronoiCircles = new d3_geom_voronoiRedBlackTree();
	    while (true) {
	      circle = d3_geom_voronoiFirstCircle;
	      if (site && (!circle || site.y < circle.y || site.y === circle.y && site.x < circle.x)) {
	        if (site.x !== x0 || site.y !== y0) {
	          d3_geom_voronoiCells[site.i] = new d3_geom_voronoiCell(site);
	          d3_geom_voronoiAddBeach(site);
	          x0 = site.x, y0 = site.y;
	        }
	        site = sites.pop();
	      } else if (circle) {
	        d3_geom_voronoiRemoveBeach(circle.arc);
	      } else {
	        break;
	      }
	    }
	    if (bbox) d3_geom_voronoiClipEdges(bbox), d3_geom_voronoiCloseCells(bbox);
	    var diagram = {
	      cells: d3_geom_voronoiCells,
	      edges: d3_geom_voronoiEdges
	    };
	    d3_geom_voronoiBeaches = d3_geom_voronoiCircles = d3_geom_voronoiEdges = d3_geom_voronoiCells = null;
	    return diagram;
	  }
	  function d3_geom_voronoiVertexOrder(a, b) {
	    return b.y - a.y || b.x - a.x;
	  }
	  d3.geom.voronoi = function(points) {
	    var x = d3_geom_pointX, y = d3_geom_pointY, fx = x, fy = y, clipExtent = d3_geom_voronoiClipExtent;
	    if (points) return voronoi(points);
	    function voronoi(data) {
	      var polygons = new Array(data.length), x0 = clipExtent[0][0], y0 = clipExtent[0][1], x1 = clipExtent[1][0], y1 = clipExtent[1][1];
	      d3_geom_voronoi(sites(data), clipExtent).cells.forEach(function(cell, i) {
	        var edges = cell.edges, site = cell.site, polygon = polygons[i] = edges.length ? edges.map(function(e) {
	          var s = e.start();
	          return [ s.x, s.y ];
	        }) : site.x >= x0 && site.x <= x1 && site.y >= y0 && site.y <= y1 ? [ [ x0, y1 ], [ x1, y1 ], [ x1, y0 ], [ x0, y0 ] ] : [];
	        polygon.point = data[i];
	      });
	      return polygons;
	    }
	    function sites(data) {
	      return data.map(function(d, i) {
	        return {
	          x: Math.round(fx(d, i) / ε) * ε,
	          y: Math.round(fy(d, i) / ε) * ε,
	          i: i
	        };
	      });
	    }
	    voronoi.links = function(data) {
	      return d3_geom_voronoi(sites(data)).edges.filter(function(edge) {
	        return edge.l && edge.r;
	      }).map(function(edge) {
	        return {
	          source: data[edge.l.i],
	          target: data[edge.r.i]
	        };
	      });
	    };
	    voronoi.triangles = function(data) {
	      var triangles = [];
	      d3_geom_voronoi(sites(data)).cells.forEach(function(cell, i) {
	        var site = cell.site, edges = cell.edges.sort(d3_geom_voronoiHalfEdgeOrder), j = -1, m = edges.length, e0, s0, e1 = edges[m - 1].edge, s1 = e1.l === site ? e1.r : e1.l;
	        while (++j < m) {
	          e0 = e1;
	          s0 = s1;
	          e1 = edges[j].edge;
	          s1 = e1.l === site ? e1.r : e1.l;
	          if (i < s0.i && i < s1.i && d3_geom_voronoiTriangleArea(site, s0, s1) < 0) {
	            triangles.push([ data[i], data[s0.i], data[s1.i] ]);
	          }
	        }
	      });
	      return triangles;
	    };
	    voronoi.x = function(_) {
	      return arguments.length ? (fx = d3_functor(x = _), voronoi) : x;
	    };
	    voronoi.y = function(_) {
	      return arguments.length ? (fy = d3_functor(y = _), voronoi) : y;
	    };
	    voronoi.clipExtent = function(_) {
	      if (!arguments.length) return clipExtent === d3_geom_voronoiClipExtent ? null : clipExtent;
	      clipExtent = _ == null ? d3_geom_voronoiClipExtent : _;
	      return voronoi;
	    };
	    voronoi.size = function(_) {
	      if (!arguments.length) return clipExtent === d3_geom_voronoiClipExtent ? null : clipExtent && clipExtent[1];
	      return voronoi.clipExtent(_ && [ [ 0, 0 ], _ ]);
	    };
	    return voronoi;
	  };
	  var d3_geom_voronoiClipExtent = [ [ -1e6, -1e6 ], [ 1e6, 1e6 ] ];
	  function d3_geom_voronoiTriangleArea(a, b, c) {
	    return (a.x - c.x) * (b.y - a.y) - (a.x - b.x) * (c.y - a.y);
	  }
	  d3.geom.delaunay = function(vertices) {
	    return d3.geom.voronoi().triangles(vertices);
	  };
	  d3.geom.quadtree = function(points, x1, y1, x2, y2) {
	    var x = d3_geom_pointX, y = d3_geom_pointY, compat;
	    if (compat = arguments.length) {
	      x = d3_geom_quadtreeCompatX;
	      y = d3_geom_quadtreeCompatY;
	      if (compat === 3) {
	        y2 = y1;
	        x2 = x1;
	        y1 = x1 = 0;
	      }
	      return quadtree(points);
	    }
	    function quadtree(data) {
	      var d, fx = d3_functor(x), fy = d3_functor(y), xs, ys, i, n, x1_, y1_, x2_, y2_;
	      if (x1 != null) {
	        x1_ = x1, y1_ = y1, x2_ = x2, y2_ = y2;
	      } else {
	        x2_ = y2_ = -(x1_ = y1_ = Infinity);
	        xs = [], ys = [];
	        n = data.length;
	        if (compat) for (i = 0; i < n; ++i) {
	          d = data[i];
	          if (d.x < x1_) x1_ = d.x;
	          if (d.y < y1_) y1_ = d.y;
	          if (d.x > x2_) x2_ = d.x;
	          if (d.y > y2_) y2_ = d.y;
	          xs.push(d.x);
	          ys.push(d.y);
	        } else for (i = 0; i < n; ++i) {
	          var x_ = +fx(d = data[i], i), y_ = +fy(d, i);
	          if (x_ < x1_) x1_ = x_;
	          if (y_ < y1_) y1_ = y_;
	          if (x_ > x2_) x2_ = x_;
	          if (y_ > y2_) y2_ = y_;
	          xs.push(x_);
	          ys.push(y_);
	        }
	      }
	      var dx = x2_ - x1_, dy = y2_ - y1_;
	      if (dx > dy) y2_ = y1_ + dx; else x2_ = x1_ + dy;
	      function insert(n, d, x, y, x1, y1, x2, y2) {
	        if (isNaN(x) || isNaN(y)) return;
	        if (n.leaf) {
	          var nx = n.x, ny = n.y;
	          if (nx != null) {
	            if (abs(nx - x) + abs(ny - y) < .01) {
	              insertChild(n, d, x, y, x1, y1, x2, y2);
	            } else {
	              var nPoint = n.point;
	              n.x = n.y = n.point = null;
	              insertChild(n, nPoint, nx, ny, x1, y1, x2, y2);
	              insertChild(n, d, x, y, x1, y1, x2, y2);
	            }
	          } else {
	            n.x = x, n.y = y, n.point = d;
	          }
	        } else {
	          insertChild(n, d, x, y, x1, y1, x2, y2);
	        }
	      }
	      function insertChild(n, d, x, y, x1, y1, x2, y2) {
	        var xm = (x1 + x2) * .5, ym = (y1 + y2) * .5, right = x >= xm, below = y >= ym, i = below << 1 | right;
	        n.leaf = false;
	        n = n.nodes[i] || (n.nodes[i] = d3_geom_quadtreeNode());
	        if (right) x1 = xm; else x2 = xm;
	        if (below) y1 = ym; else y2 = ym;
	        insert(n, d, x, y, x1, y1, x2, y2);
	      }
	      var root = d3_geom_quadtreeNode();
	      root.add = function(d) {
	        insert(root, d, +fx(d, ++i), +fy(d, i), x1_, y1_, x2_, y2_);
	      };
	      root.visit = function(f) {
	        d3_geom_quadtreeVisit(f, root, x1_, y1_, x2_, y2_);
	      };
	      root.find = function(point) {
	        return d3_geom_quadtreeFind(root, point[0], point[1], x1_, y1_, x2_, y2_);
	      };
	      i = -1;
	      if (x1 == null) {
	        while (++i < n) {
	          insert(root, data[i], xs[i], ys[i], x1_, y1_, x2_, y2_);
	        }
	        --i;
	      } else data.forEach(root.add);
	      xs = ys = data = d = null;
	      return root;
	    }
	    quadtree.x = function(_) {
	      return arguments.length ? (x = _, quadtree) : x;
	    };
	    quadtree.y = function(_) {
	      return arguments.length ? (y = _, quadtree) : y;
	    };
	    quadtree.extent = function(_) {
	      if (!arguments.length) return x1 == null ? null : [ [ x1, y1 ], [ x2, y2 ] ];
	      if (_ == null) x1 = y1 = x2 = y2 = null; else x1 = +_[0][0], y1 = +_[0][1], x2 = +_[1][0], 
	      y2 = +_[1][1];
	      return quadtree;
	    };
	    quadtree.size = function(_) {
	      if (!arguments.length) return x1 == null ? null : [ x2 - x1, y2 - y1 ];
	      if (_ == null) x1 = y1 = x2 = y2 = null; else x1 = y1 = 0, x2 = +_[0], y2 = +_[1];
	      return quadtree;
	    };
	    return quadtree;
	  };
	  function d3_geom_quadtreeCompatX(d) {
	    return d.x;
	  }
	  function d3_geom_quadtreeCompatY(d) {
	    return d.y;
	  }
	  function d3_geom_quadtreeNode() {
	    return {
	      leaf: true,
	      nodes: [],
	      point: null,
	      x: null,
	      y: null
	    };
	  }
	  function d3_geom_quadtreeVisit(f, node, x1, y1, x2, y2) {
	    if (!f(node, x1, y1, x2, y2)) {
	      var sx = (x1 + x2) * .5, sy = (y1 + y2) * .5, children = node.nodes;
	      if (children[0]) d3_geom_quadtreeVisit(f, children[0], x1, y1, sx, sy);
	      if (children[1]) d3_geom_quadtreeVisit(f, children[1], sx, y1, x2, sy);
	      if (children[2]) d3_geom_quadtreeVisit(f, children[2], x1, sy, sx, y2);
	      if (children[3]) d3_geom_quadtreeVisit(f, children[3], sx, sy, x2, y2);
	    }
	  }
	  function d3_geom_quadtreeFind(root, x, y, x0, y0, x3, y3) {
	    var minDistance2 = Infinity, closestPoint;
	    (function find(node, x1, y1, x2, y2) {
	      if (x1 > x3 || y1 > y3 || x2 < x0 || y2 < y0) return;
	      if (point = node.point) {
	        var point, dx = x - node.x, dy = y - node.y, distance2 = dx * dx + dy * dy;
	        if (distance2 < minDistance2) {
	          var distance = Math.sqrt(minDistance2 = distance2);
	          x0 = x - distance, y0 = y - distance;
	          x3 = x + distance, y3 = y + distance;
	          closestPoint = point;
	        }
	      }
	      var children = node.nodes, xm = (x1 + x2) * .5, ym = (y1 + y2) * .5, right = x >= xm, below = y >= ym;
	      for (var i = below << 1 | right, j = i + 4; i < j; ++i) {
	        if (node = children[i & 3]) switch (i & 3) {
	         case 0:
	          find(node, x1, y1, xm, ym);
	          break;
	
	         case 1:
	          find(node, xm, y1, x2, ym);
	          break;
	
	         case 2:
	          find(node, x1, ym, xm, y2);
	          break;
	
	         case 3:
	          find(node, xm, ym, x2, y2);
	          break;
	        }
	      }
	    })(root, x0, y0, x3, y3);
	    return closestPoint;
	  }
	  d3.interpolateRgb = d3_interpolateRgb;
	  function d3_interpolateRgb(a, b) {
	    a = d3.rgb(a);
	    b = d3.rgb(b);
	    var ar = a.r, ag = a.g, ab = a.b, br = b.r - ar, bg = b.g - ag, bb = b.b - ab;
	    return function(t) {
	      return "#" + d3_rgb_hex(Math.round(ar + br * t)) + d3_rgb_hex(Math.round(ag + bg * t)) + d3_rgb_hex(Math.round(ab + bb * t));
	    };
	  }
	  d3.interpolateObject = d3_interpolateObject;
	  function d3_interpolateObject(a, b) {
	    var i = {}, c = {}, k;
	    for (k in a) {
	      if (k in b) {
	        i[k] = d3_interpolate(a[k], b[k]);
	      } else {
	        c[k] = a[k];
	      }
	    }
	    for (k in b) {
	      if (!(k in a)) {
	        c[k] = b[k];
	      }
	    }
	    return function(t) {
	      for (k in i) c[k] = i[k](t);
	      return c;
	    };
	  }
	  d3.interpolateNumber = d3_interpolateNumber;
	  function d3_interpolateNumber(a, b) {
	    a = +a, b = +b;
	    return function(t) {
	      return a * (1 - t) + b * t;
	    };
	  }
	  d3.interpolateString = d3_interpolateString;
	  function d3_interpolateString(a, b) {
	    var bi = d3_interpolate_numberA.lastIndex = d3_interpolate_numberB.lastIndex = 0, am, bm, bs, i = -1, s = [], q = [];
	    a = a + "", b = b + "";
	    while ((am = d3_interpolate_numberA.exec(a)) && (bm = d3_interpolate_numberB.exec(b))) {
	      if ((bs = bm.index) > bi) {
	        bs = b.slice(bi, bs);
	        if (s[i]) s[i] += bs; else s[++i] = bs;
	      }
	      if ((am = am[0]) === (bm = bm[0])) {
	        if (s[i]) s[i] += bm; else s[++i] = bm;
	      } else {
	        s[++i] = null;
	        q.push({
	          i: i,
	          x: d3_interpolateNumber(am, bm)
	        });
	      }
	      bi = d3_interpolate_numberB.lastIndex;
	    }
	    if (bi < b.length) {
	      bs = b.slice(bi);
	      if (s[i]) s[i] += bs; else s[++i] = bs;
	    }
	    return s.length < 2 ? q[0] ? (b = q[0].x, function(t) {
	      return b(t) + "";
	    }) : function() {
	      return b;
	    } : (b = q.length, function(t) {
	      for (var i = 0, o; i < b; ++i) s[(o = q[i]).i] = o.x(t);
	      return s.join("");
	    });
	  }
	  var d3_interpolate_numberA = /[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g, d3_interpolate_numberB = new RegExp(d3_interpolate_numberA.source, "g");
	  d3.interpolate = d3_interpolate;
	  function d3_interpolate(a, b) {
	    var i = d3.interpolators.length, f;
	    while (--i >= 0 && !(f = d3.interpolators[i](a, b))) ;
	    return f;
	  }
	  d3.interpolators = [ function(a, b) {
	    var t = typeof b;
	    return (t === "string" ? d3_rgb_names.has(b.toLowerCase()) || /^(#|rgb\(|hsl\()/i.test(b) ? d3_interpolateRgb : d3_interpolateString : b instanceof d3_color ? d3_interpolateRgb : Array.isArray(b) ? d3_interpolateArray : t === "object" && isNaN(b) ? d3_interpolateObject : d3_interpolateNumber)(a, b);
	  } ];
	  d3.interpolateArray = d3_interpolateArray;
	  function d3_interpolateArray(a, b) {
	    var x = [], c = [], na = a.length, nb = b.length, n0 = Math.min(a.length, b.length), i;
	    for (i = 0; i < n0; ++i) x.push(d3_interpolate(a[i], b[i]));
	    for (;i < na; ++i) c[i] = a[i];
	    for (;i < nb; ++i) c[i] = b[i];
	    return function(t) {
	      for (i = 0; i < n0; ++i) c[i] = x[i](t);
	      return c;
	    };
	  }
	  var d3_ease_default = function() {
	    return d3_identity;
	  };
	  var d3_ease = d3.map({
	    linear: d3_ease_default,
	    poly: d3_ease_poly,
	    quad: function() {
	      return d3_ease_quad;
	    },
	    cubic: function() {
	      return d3_ease_cubic;
	    },
	    sin: function() {
	      return d3_ease_sin;
	    },
	    exp: function() {
	      return d3_ease_exp;
	    },
	    circle: function() {
	      return d3_ease_circle;
	    },
	    elastic: d3_ease_elastic,
	    back: d3_ease_back,
	    bounce: function() {
	      return d3_ease_bounce;
	    }
	  });
	  var d3_ease_mode = d3.map({
	    "in": d3_identity,
	    out: d3_ease_reverse,
	    "in-out": d3_ease_reflect,
	    "out-in": function(f) {
	      return d3_ease_reflect(d3_ease_reverse(f));
	    }
	  });
	  d3.ease = function(name) {
	    var i = name.indexOf("-"), t = i >= 0 ? name.slice(0, i) : name, m = i >= 0 ? name.slice(i + 1) : "in";
	    t = d3_ease.get(t) || d3_ease_default;
	    m = d3_ease_mode.get(m) || d3_identity;
	    return d3_ease_clamp(m(t.apply(null, d3_arraySlice.call(arguments, 1))));
	  };
	  function d3_ease_clamp(f) {
	    return function(t) {
	      return t <= 0 ? 0 : t >= 1 ? 1 : f(t);
	    };
	  }
	  function d3_ease_reverse(f) {
	    return function(t) {
	      return 1 - f(1 - t);
	    };
	  }
	  function d3_ease_reflect(f) {
	    return function(t) {
	      return .5 * (t < .5 ? f(2 * t) : 2 - f(2 - 2 * t));
	    };
	  }
	  function d3_ease_quad(t) {
	    return t * t;
	  }
	  function d3_ease_cubic(t) {
	    return t * t * t;
	  }
	  function d3_ease_cubicInOut(t) {
	    if (t <= 0) return 0;
	    if (t >= 1) return 1;
	    var t2 = t * t, t3 = t2 * t;
	    return 4 * (t < .5 ? t3 : 3 * (t - t2) + t3 - .75);
	  }
	  function d3_ease_poly(e) {
	    return function(t) {
	      return Math.pow(t, e);
	    };
	  }
	  function d3_ease_sin(t) {
	    return 1 - Math.cos(t * halfπ);
	  }
	  function d3_ease_exp(t) {
	    return Math.pow(2, 10 * (t - 1));
	  }
	  function d3_ease_circle(t) {
	    return 1 - Math.sqrt(1 - t * t);
	  }
	  function d3_ease_elastic(a, p) {
	    var s;
	    if (arguments.length < 2) p = .45;
	    if (arguments.length) s = p / τ * Math.asin(1 / a); else a = 1, s = p / 4;
	    return function(t) {
	      return 1 + a * Math.pow(2, -10 * t) * Math.sin((t - s) * τ / p);
	    };
	  }
	  function d3_ease_back(s) {
	    if (!s) s = 1.70158;
	    return function(t) {
	      return t * t * ((s + 1) * t - s);
	    };
	  }
	  function d3_ease_bounce(t) {
	    return t < 1 / 2.75 ? 7.5625 * t * t : t < 2 / 2.75 ? 7.5625 * (t -= 1.5 / 2.75) * t + .75 : t < 2.5 / 2.75 ? 7.5625 * (t -= 2.25 / 2.75) * t + .9375 : 7.5625 * (t -= 2.625 / 2.75) * t + .984375;
	  }
	  d3.interpolateHcl = d3_interpolateHcl;
	  function d3_interpolateHcl(a, b) {
	    a = d3.hcl(a);
	    b = d3.hcl(b);
	    var ah = a.h, ac = a.c, al = a.l, bh = b.h - ah, bc = b.c - ac, bl = b.l - al;
	    if (isNaN(bc)) bc = 0, ac = isNaN(ac) ? b.c : ac;
	    if (isNaN(bh)) bh = 0, ah = isNaN(ah) ? b.h : ah; else if (bh > 180) bh -= 360; else if (bh < -180) bh += 360;
	    return function(t) {
	      return d3_hcl_lab(ah + bh * t, ac + bc * t, al + bl * t) + "";
	    };
	  }
	  d3.interpolateHsl = d3_interpolateHsl;
	  function d3_interpolateHsl(a, b) {
	    a = d3.hsl(a);
	    b = d3.hsl(b);
	    var ah = a.h, as = a.s, al = a.l, bh = b.h - ah, bs = b.s - as, bl = b.l - al;
	    if (isNaN(bs)) bs = 0, as = isNaN(as) ? b.s : as;
	    if (isNaN(bh)) bh = 0, ah = isNaN(ah) ? b.h : ah; else if (bh > 180) bh -= 360; else if (bh < -180) bh += 360;
	    return function(t) {
	      return d3_hsl_rgb(ah + bh * t, as + bs * t, al + bl * t) + "";
	    };
	  }
	  d3.interpolateLab = d3_interpolateLab;
	  function d3_interpolateLab(a, b) {
	    a = d3.lab(a);
	    b = d3.lab(b);
	    var al = a.l, aa = a.a, ab = a.b, bl = b.l - al, ba = b.a - aa, bb = b.b - ab;
	    return function(t) {
	      return d3_lab_rgb(al + bl * t, aa + ba * t, ab + bb * t) + "";
	    };
	  }
	  d3.interpolateRound = d3_interpolateRound;
	  function d3_interpolateRound(a, b) {
	    b -= a;
	    return function(t) {
	      return Math.round(a + b * t);
	    };
	  }
	  d3.transform = function(string) {
	    var g = d3_document.createElementNS(d3.ns.prefix.svg, "g");
	    return (d3.transform = function(string) {
	      if (string != null) {
	        g.setAttribute("transform", string);
	        var t = g.transform.baseVal.consolidate();
	      }
	      return new d3_transform(t ? t.matrix : d3_transformIdentity);
	    })(string);
	  };
	  function d3_transform(m) {
	    var r0 = [ m.a, m.b ], r1 = [ m.c, m.d ], kx = d3_transformNormalize(r0), kz = d3_transformDot(r0, r1), ky = d3_transformNormalize(d3_transformCombine(r1, r0, -kz)) || 0;
	    if (r0[0] * r1[1] < r1[0] * r0[1]) {
	      r0[0] *= -1;
	      r0[1] *= -1;
	      kx *= -1;
	      kz *= -1;
	    }
	    this.rotate = (kx ? Math.atan2(r0[1], r0[0]) : Math.atan2(-r1[0], r1[1])) * d3_degrees;
	    this.translate = [ m.e, m.f ];
	    this.scale = [ kx, ky ];
	    this.skew = ky ? Math.atan2(kz, ky) * d3_degrees : 0;
	  }
	  d3_transform.prototype.toString = function() {
	    return "translate(" + this.translate + ")rotate(" + this.rotate + ")skewX(" + this.skew + ")scale(" + this.scale + ")";
	  };
	  function d3_transformDot(a, b) {
	    return a[0] * b[0] + a[1] * b[1];
	  }
	  function d3_transformNormalize(a) {
	    var k = Math.sqrt(d3_transformDot(a, a));
	    if (k) {
	      a[0] /= k;
	      a[1] /= k;
	    }
	    return k;
	  }
	  function d3_transformCombine(a, b, k) {
	    a[0] += k * b[0];
	    a[1] += k * b[1];
	    return a;
	  }
	  var d3_transformIdentity = {
	    a: 1,
	    b: 0,
	    c: 0,
	    d: 1,
	    e: 0,
	    f: 0
	  };
	  d3.interpolateTransform = d3_interpolateTransform;
	  function d3_interpolateTransformPop(s) {
	    return s.length ? s.pop() + "," : "";
	  }
	  function d3_interpolateTranslate(ta, tb, s, q) {
	    if (ta[0] !== tb[0] || ta[1] !== tb[1]) {
	      var i = s.push("translate(", null, ",", null, ")");
	      q.push({
	        i: i - 4,
	        x: d3_interpolateNumber(ta[0], tb[0])
	      }, {
	        i: i - 2,
	        x: d3_interpolateNumber(ta[1], tb[1])
	      });
	    } else if (tb[0] || tb[1]) {
	      s.push("translate(" + tb + ")");
	    }
	  }
	  function d3_interpolateRotate(ra, rb, s, q) {
	    if (ra !== rb) {
	      if (ra - rb > 180) rb += 360; else if (rb - ra > 180) ra += 360;
	      q.push({
	        i: s.push(d3_interpolateTransformPop(s) + "rotate(", null, ")") - 2,
	        x: d3_interpolateNumber(ra, rb)
	      });
	    } else if (rb) {
	      s.push(d3_interpolateTransformPop(s) + "rotate(" + rb + ")");
	    }
	  }
	  function d3_interpolateSkew(wa, wb, s, q) {
	    if (wa !== wb) {
	      q.push({
	        i: s.push(d3_interpolateTransformPop(s) + "skewX(", null, ")") - 2,
	        x: d3_interpolateNumber(wa, wb)
	      });
	    } else if (wb) {
	      s.push(d3_interpolateTransformPop(s) + "skewX(" + wb + ")");
	    }
	  }
	  function d3_interpolateScale(ka, kb, s, q) {
	    if (ka[0] !== kb[0] || ka[1] !== kb[1]) {
	      var i = s.push(d3_interpolateTransformPop(s) + "scale(", null, ",", null, ")");
	      q.push({
	        i: i - 4,
	        x: d3_interpolateNumber(ka[0], kb[0])
	      }, {
	        i: i - 2,
	        x: d3_interpolateNumber(ka[1], kb[1])
	      });
	    } else if (kb[0] !== 1 || kb[1] !== 1) {
	      s.push(d3_interpolateTransformPop(s) + "scale(" + kb + ")");
	    }
	  }
	  function d3_interpolateTransform(a, b) {
	    var s = [], q = [];
	    a = d3.transform(a), b = d3.transform(b);
	    d3_interpolateTranslate(a.translate, b.translate, s, q);
	    d3_interpolateRotate(a.rotate, b.rotate, s, q);
	    d3_interpolateSkew(a.skew, b.skew, s, q);
	    d3_interpolateScale(a.scale, b.scale, s, q);
	    a = b = null;
	    return function(t) {
	      var i = -1, n = q.length, o;
	      while (++i < n) s[(o = q[i]).i] = o.x(t);
	      return s.join("");
	    };
	  }
	  function d3_uninterpolateNumber(a, b) {
	    b = (b -= a = +a) || 1 / b;
	    return function(x) {
	      return (x - a) / b;
	    };
	  }
	  function d3_uninterpolateClamp(a, b) {
	    b = (b -= a = +a) || 1 / b;
	    return function(x) {
	      return Math.max(0, Math.min(1, (x - a) / b));
	    };
	  }
	  d3.layout = {};
	  d3.layout.bundle = function() {
	    return function(links) {
	      var paths = [], i = -1, n = links.length;
	      while (++i < n) paths.push(d3_layout_bundlePath(links[i]));
	      return paths;
	    };
	  };
	  function d3_layout_bundlePath(link) {
	    var start = link.source, end = link.target, lca = d3_layout_bundleLeastCommonAncestor(start, end), points = [ start ];
	    while (start !== lca) {
	      start = start.parent;
	      points.push(start);
	    }
	    var k = points.length;
	    while (end !== lca) {
	      points.splice(k, 0, end);
	      end = end.parent;
	    }
	    return points;
	  }
	  function d3_layout_bundleAncestors(node) {
	    var ancestors = [], parent = node.parent;
	    while (parent != null) {
	      ancestors.push(node);
	      node = parent;
	      parent = parent.parent;
	    }
	    ancestors.push(node);
	    return ancestors;
	  }
	  function d3_layout_bundleLeastCommonAncestor(a, b) {
	    if (a === b) return a;
	    var aNodes = d3_layout_bundleAncestors(a), bNodes = d3_layout_bundleAncestors(b), aNode = aNodes.pop(), bNode = bNodes.pop(), sharedNode = null;
	    while (aNode === bNode) {
	      sharedNode = aNode;
	      aNode = aNodes.pop();
	      bNode = bNodes.pop();
	    }
	    return sharedNode;
	  }
	  d3.layout.chord = function() {
	    var chord = {}, chords, groups, matrix, n, padding = 0, sortGroups, sortSubgroups, sortChords;
	    function relayout() {
	      var subgroups = {}, groupSums = [], groupIndex = d3.range(n), subgroupIndex = [], k, x, x0, i, j;
	      chords = [];
	      groups = [];
	      k = 0, i = -1;
	      while (++i < n) {
	        x = 0, j = -1;
	        while (++j < n) {
	          x += matrix[i][j];
	        }
	        groupSums.push(x);
	        subgroupIndex.push(d3.range(n));
	        k += x;
	      }
	      if (sortGroups) {
	        groupIndex.sort(function(a, b) {
	          return sortGroups(groupSums[a], groupSums[b]);
	        });
	      }
	      if (sortSubgroups) {
	        subgroupIndex.forEach(function(d, i) {
	          d.sort(function(a, b) {
	            return sortSubgroups(matrix[i][a], matrix[i][b]);
	          });
	        });
	      }
	      k = (τ - padding * n) / k;
	      x = 0, i = -1;
	      while (++i < n) {
	        x0 = x, j = -1;
	        while (++j < n) {
	          var di = groupIndex[i], dj = subgroupIndex[di][j], v = matrix[di][dj], a0 = x, a1 = x += v * k;
	          subgroups[di + "-" + dj] = {
	            index: di,
	            subindex: dj,
	            startAngle: a0,
	            endAngle: a1,
	            value: v
	          };
	        }
	        groups[di] = {
	          index: di,
	          startAngle: x0,
	          endAngle: x,
	          value: groupSums[di]
	        };
	        x += padding;
	      }
	      i = -1;
	      while (++i < n) {
	        j = i - 1;
	        while (++j < n) {
	          var source = subgroups[i + "-" + j], target = subgroups[j + "-" + i];
	          if (source.value || target.value) {
	            chords.push(source.value < target.value ? {
	              source: target,
	              target: source
	            } : {
	              source: source,
	              target: target
	            });
	          }
	        }
	      }
	      if (sortChords) resort();
	    }
	    function resort() {
	      chords.sort(function(a, b) {
	        return sortChords((a.source.value + a.target.value) / 2, (b.source.value + b.target.value) / 2);
	      });
	    }
	    chord.matrix = function(x) {
	      if (!arguments.length) return matrix;
	      n = (matrix = x) && matrix.length;
	      chords = groups = null;
	      return chord;
	    };
	    chord.padding = function(x) {
	      if (!arguments.length) return padding;
	      padding = x;
	      chords = groups = null;
	      return chord;
	    };
	    chord.sortGroups = function(x) {
	      if (!arguments.length) return sortGroups;
	      sortGroups = x;
	      chords = groups = null;
	      return chord;
	    };
	    chord.sortSubgroups = function(x) {
	      if (!arguments.length) return sortSubgroups;
	      sortSubgroups = x;
	      chords = null;
	      return chord;
	    };
	    chord.sortChords = function(x) {
	      if (!arguments.length) return sortChords;
	      sortChords = x;
	      if (chords) resort();
	      return chord;
	    };
	    chord.chords = function() {
	      if (!chords) relayout();
	      return chords;
	    };
	    chord.groups = function() {
	      if (!groups) relayout();
	      return groups;
	    };
	    return chord;
	  };
	  d3.layout.force = function() {
	    var force = {}, event = d3.dispatch("start", "tick", "end"), timer, size = [ 1, 1 ], drag, alpha, friction = .9, linkDistance = d3_layout_forceLinkDistance, linkStrength = d3_layout_forceLinkStrength, charge = -30, chargeDistance2 = d3_layout_forceChargeDistance2, gravity = .1, theta2 = .64, nodes = [], links = [], distances, strengths, charges;
	    function repulse(node) {
	      return function(quad, x1, _, x2) {
	        if (quad.point !== node) {
	          var dx = quad.cx - node.x, dy = quad.cy - node.y, dw = x2 - x1, dn = dx * dx + dy * dy;
	          if (dw * dw / theta2 < dn) {
	            if (dn < chargeDistance2) {
	              var k = quad.charge / dn;
	              node.px -= dx * k;
	              node.py -= dy * k;
	            }
	            return true;
	          }
	          if (quad.point && dn && dn < chargeDistance2) {
	            var k = quad.pointCharge / dn;
	            node.px -= dx * k;
	            node.py -= dy * k;
	          }
	        }
	        return !quad.charge;
	      };
	    }
	    force.tick = function() {
	      if ((alpha *= .99) < .005) {
	        timer = null;
	        event.end({
	          type: "end",
	          alpha: alpha = 0
	        });
	        return true;
	      }
	      var n = nodes.length, m = links.length, q, i, o, s, t, l, k, x, y;
	      for (i = 0; i < m; ++i) {
	        o = links[i];
	        s = o.source;
	        t = o.target;
	        x = t.x - s.x;
	        y = t.y - s.y;
	        if (l = x * x + y * y) {
	          l = alpha * strengths[i] * ((l = Math.sqrt(l)) - distances[i]) / l;
	          x *= l;
	          y *= l;
	          t.x -= x * (k = s.weight + t.weight ? s.weight / (s.weight + t.weight) : .5);
	          t.y -= y * k;
	          s.x += x * (k = 1 - k);
	          s.y += y * k;
	        }
	      }
	      if (k = alpha * gravity) {
	        x = size[0] / 2;
	        y = size[1] / 2;
	        i = -1;
	        if (k) while (++i < n) {
	          o = nodes[i];
	          o.x += (x - o.x) * k;
	          o.y += (y - o.y) * k;
	        }
	      }
	      if (charge) {
	        d3_layout_forceAccumulate(q = d3.geom.quadtree(nodes), alpha, charges);
	        i = -1;
	        while (++i < n) {
	          if (!(o = nodes[i]).fixed) {
	            q.visit(repulse(o));
	          }
	        }
	      }
	      i = -1;
	      while (++i < n) {
	        o = nodes[i];
	        if (o.fixed) {
	          o.x = o.px;
	          o.y = o.py;
	        } else {
	          o.x -= (o.px - (o.px = o.x)) * friction;
	          o.y -= (o.py - (o.py = o.y)) * friction;
	        }
	      }
	      event.tick({
	        type: "tick",
	        alpha: alpha
	      });
	    };
	    force.nodes = function(x) {
	      if (!arguments.length) return nodes;
	      nodes = x;
	      return force;
	    };
	    force.links = function(x) {
	      if (!arguments.length) return links;
	      links = x;
	      return force;
	    };
	    force.size = function(x) {
	      if (!arguments.length) return size;
	      size = x;
	      return force;
	    };
	    force.linkDistance = function(x) {
	      if (!arguments.length) return linkDistance;
	      linkDistance = typeof x === "function" ? x : +x;
	      return force;
	    };
	    force.distance = force.linkDistance;
	    force.linkStrength = function(x) {
	      if (!arguments.length) return linkStrength;
	      linkStrength = typeof x === "function" ? x : +x;
	      return force;
	    };
	    force.friction = function(x) {
	      if (!arguments.length) return friction;
	      friction = +x;
	      return force;
	    };
	    force.charge = function(x) {
	      if (!arguments.length) return charge;
	      charge = typeof x === "function" ? x : +x;
	      return force;
	    };
	    force.chargeDistance = function(x) {
	      if (!arguments.length) return Math.sqrt(chargeDistance2);
	      chargeDistance2 = x * x;
	      return force;
	    };
	    force.gravity = function(x) {
	      if (!arguments.length) return gravity;
	      gravity = +x;
	      return force;
	    };
	    force.theta = function(x) {
	      if (!arguments.length) return Math.sqrt(theta2);
	      theta2 = x * x;
	      return force;
	    };
	    force.alpha = function(x) {
	      if (!arguments.length) return alpha;
	      x = +x;
	      if (alpha) {
	        if (x > 0) {
	          alpha = x;
	        } else {
	          timer.c = null, timer.t = NaN, timer = null;
	          event.end({
	            type: "end",
	            alpha: alpha = 0
	          });
	        }
	      } else if (x > 0) {
	        event.start({
	          type: "start",
	          alpha: alpha = x
	        });
	        timer = d3_timer(force.tick);
	      }
	      return force;
	    };
	    force.start = function() {
	      var i, n = nodes.length, m = links.length, w = size[0], h = size[1], neighbors, o;
	      for (i = 0; i < n; ++i) {
	        (o = nodes[i]).index = i;
	        o.weight = 0;
	      }
	      for (i = 0; i < m; ++i) {
	        o = links[i];
	        if (typeof o.source == "number") o.source = nodes[o.source];
	        if (typeof o.target == "number") o.target = nodes[o.target];
	        ++o.source.weight;
	        ++o.target.weight;
	      }
	      for (i = 0; i < n; ++i) {
	        o = nodes[i];
	        if (isNaN(o.x)) o.x = position("x", w);
	        if (isNaN(o.y)) o.y = position("y", h);
	        if (isNaN(o.px)) o.px = o.x;
	        if (isNaN(o.py)) o.py = o.y;
	      }
	      distances = [];
	      if (typeof linkDistance === "function") for (i = 0; i < m; ++i) distances[i] = +linkDistance.call(this, links[i], i); else for (i = 0; i < m; ++i) distances[i] = linkDistance;
	      strengths = [];
	      if (typeof linkStrength === "function") for (i = 0; i < m; ++i) strengths[i] = +linkStrength.call(this, links[i], i); else for (i = 0; i < m; ++i) strengths[i] = linkStrength;
	      charges = [];
	      if (typeof charge === "function") for (i = 0; i < n; ++i) charges[i] = +charge.call(this, nodes[i], i); else for (i = 0; i < n; ++i) charges[i] = charge;
	      function position(dimension, size) {
	        if (!neighbors) {
	          neighbors = new Array(n);
	          for (j = 0; j < n; ++j) {
	            neighbors[j] = [];
	          }
	          for (j = 0; j < m; ++j) {
	            var o = links[j];
	            neighbors[o.source.index].push(o.target);
	            neighbors[o.target.index].push(o.source);
	          }
	        }
	        var candidates = neighbors[i], j = -1, l = candidates.length, x;
	        while (++j < l) if (!isNaN(x = candidates[j][dimension])) return x;
	        return Math.random() * size;
	      }
	      return force.resume();
	    };
	    force.resume = function() {
	      return force.alpha(.1);
	    };
	    force.stop = function() {
	      return force.alpha(0);
	    };
	    force.drag = function() {
	      if (!drag) drag = d3.behavior.drag().origin(d3_identity).on("dragstart.force", d3_layout_forceDragstart).on("drag.force", dragmove).on("dragend.force", d3_layout_forceDragend);
	      if (!arguments.length) return drag;
	      this.on("mouseover.force", d3_layout_forceMouseover).on("mouseout.force", d3_layout_forceMouseout).call(drag);
	    };
	    function dragmove(d) {
	      d.px = d3.event.x, d.py = d3.event.y;
	      force.resume();
	    }
	    return d3.rebind(force, event, "on");
	  };
	  function d3_layout_forceDragstart(d) {
	    d.fixed |= 2;
	  }
	  function d3_layout_forceDragend(d) {
	    d.fixed &= ~6;
	  }
	  function d3_layout_forceMouseover(d) {
	    d.fixed |= 4;
	    d.px = d.x, d.py = d.y;
	  }
	  function d3_layout_forceMouseout(d) {
	    d.fixed &= ~4;
	  }
	  function d3_layout_forceAccumulate(quad, alpha, charges) {
	    var cx = 0, cy = 0;
	    quad.charge = 0;
	    if (!quad.leaf) {
	      var nodes = quad.nodes, n = nodes.length, i = -1, c;
	      while (++i < n) {
	        c = nodes[i];
	        if (c == null) continue;
	        d3_layout_forceAccumulate(c, alpha, charges);
	        quad.charge += c.charge;
	        cx += c.charge * c.cx;
	        cy += c.charge * c.cy;
	      }
	    }
	    if (quad.point) {
	      if (!quad.leaf) {
	        quad.point.x += Math.random() - .5;
	        quad.point.y += Math.random() - .5;
	      }
	      var k = alpha * charges[quad.point.index];
	      quad.charge += quad.pointCharge = k;
	      cx += k * quad.point.x;
	      cy += k * quad.point.y;
	    }
	    quad.cx = cx / quad.charge;
	    quad.cy = cy / quad.charge;
	  }
	  var d3_layout_forceLinkDistance = 20, d3_layout_forceLinkStrength = 1, d3_layout_forceChargeDistance2 = Infinity;
	  d3.layout.hierarchy = function() {
	    var sort = d3_layout_hierarchySort, children = d3_layout_hierarchyChildren, value = d3_layout_hierarchyValue;
	    function hierarchy(root) {
	      var stack = [ root ], nodes = [], node;
	      root.depth = 0;
	      while ((node = stack.pop()) != null) {
	        nodes.push(node);
	        if ((childs = children.call(hierarchy, node, node.depth)) && (n = childs.length)) {
	          var n, childs, child;
	          while (--n >= 0) {
	            stack.push(child = childs[n]);
	            child.parent = node;
	            child.depth = node.depth + 1;
	          }
	          if (value) node.value = 0;
	          node.children = childs;
	        } else {
	          if (value) node.value = +value.call(hierarchy, node, node.depth) || 0;
	          delete node.children;
	        }
	      }
	      d3_layout_hierarchyVisitAfter(root, function(node) {
	        var childs, parent;
	        if (sort && (childs = node.children)) childs.sort(sort);
	        if (value && (parent = node.parent)) parent.value += node.value;
	      });
	      return nodes;
	    }
	    hierarchy.sort = function(x) {
	      if (!arguments.length) return sort;
	      sort = x;
	      return hierarchy;
	    };
	    hierarchy.children = function(x) {
	      if (!arguments.length) return children;
	      children = x;
	      return hierarchy;
	    };
	    hierarchy.value = function(x) {
	      if (!arguments.length) return value;
	      value = x;
	      return hierarchy;
	    };
	    hierarchy.revalue = function(root) {
	      if (value) {
	        d3_layout_hierarchyVisitBefore(root, function(node) {
	          if (node.children) node.value = 0;
	        });
	        d3_layout_hierarchyVisitAfter(root, function(node) {
	          var parent;
	          if (!node.children) node.value = +value.call(hierarchy, node, node.depth) || 0;
	          if (parent = node.parent) parent.value += node.value;
	        });
	      }
	      return root;
	    };
	    return hierarchy;
	  };
	  function d3_layout_hierarchyRebind(object, hierarchy) {
	    d3.rebind(object, hierarchy, "sort", "children", "value");
	    object.nodes = object;
	    object.links = d3_layout_hierarchyLinks;
	    return object;
	  }
	  function d3_layout_hierarchyVisitBefore(node, callback) {
	    var nodes = [ node ];
	    while ((node = nodes.pop()) != null) {
	      callback(node);
	      if ((children = node.children) && (n = children.length)) {
	        var n, children;
	        while (--n >= 0) nodes.push(children[n]);
	      }
	    }
	  }
	  function d3_layout_hierarchyVisitAfter(node, callback) {
	    var nodes = [ node ], nodes2 = [];
	    while ((node = nodes.pop()) != null) {
	      nodes2.push(node);
	      if ((children = node.children) && (n = children.length)) {
	        var i = -1, n, children;
	        while (++i < n) nodes.push(children[i]);
	      }
	    }
	    while ((node = nodes2.pop()) != null) {
	      callback(node);
	    }
	  }
	  function d3_layout_hierarchyChildren(d) {
	    return d.children;
	  }
	  function d3_layout_hierarchyValue(d) {
	    return d.value;
	  }
	  function d3_layout_hierarchySort(a, b) {
	    return b.value - a.value;
	  }
	  function d3_layout_hierarchyLinks(nodes) {
	    return d3.merge(nodes.map(function(parent) {
	      return (parent.children || []).map(function(child) {
	        return {
	          source: parent,
	          target: child
	        };
	      });
	    }));
	  }
	  d3.layout.partition = function() {
	    var hierarchy = d3.layout.hierarchy(), size = [ 1, 1 ];
	    function position(node, x, dx, dy) {
	      var children = node.children;
	      node.x = x;
	      node.y = node.depth * dy;
	      node.dx = dx;
	      node.dy = dy;
	      if (children && (n = children.length)) {
	        var i = -1, n, c, d;
	        dx = node.value ? dx / node.value : 0;
	        while (++i < n) {
	          position(c = children[i], x, d = c.value * dx, dy);
	          x += d;
	        }
	      }
	    }
	    function depth(node) {
	      var children = node.children, d = 0;
	      if (children && (n = children.length)) {
	        var i = -1, n;
	        while (++i < n) d = Math.max(d, depth(children[i]));
	      }
	      return 1 + d;
	    }
	    function partition(d, i) {
	      var nodes = hierarchy.call(this, d, i);
	      position(nodes[0], 0, size[0], size[1] / depth(nodes[0]));
	      return nodes;
	    }
	    partition.size = function(x) {
	      if (!arguments.length) return size;
	      size = x;
	      return partition;
	    };
	    return d3_layout_hierarchyRebind(partition, hierarchy);
	  };
	  d3.layout.pie = function() {
	    var value = Number, sort = d3_layout_pieSortByValue, startAngle = 0, endAngle = τ, padAngle = 0;
	    function pie(data) {
	      var n = data.length, values = data.map(function(d, i) {
	        return +value.call(pie, d, i);
	      }), a = +(typeof startAngle === "function" ? startAngle.apply(this, arguments) : startAngle), da = (typeof endAngle === "function" ? endAngle.apply(this, arguments) : endAngle) - a, p = Math.min(Math.abs(da) / n, +(typeof padAngle === "function" ? padAngle.apply(this, arguments) : padAngle)), pa = p * (da < 0 ? -1 : 1), sum = d3.sum(values), k = sum ? (da - n * pa) / sum : 0, index = d3.range(n), arcs = [], v;
	      if (sort != null) index.sort(sort === d3_layout_pieSortByValue ? function(i, j) {
	        return values[j] - values[i];
	      } : function(i, j) {
	        return sort(data[i], data[j]);
	      });
	      index.forEach(function(i) {
	        arcs[i] = {
	          data: data[i],
	          value: v = values[i],
	          startAngle: a,
	          endAngle: a += v * k + pa,
	          padAngle: p
	        };
	      });
	      return arcs;
	    }
	    pie.value = function(_) {
	      if (!arguments.length) return value;
	      value = _;
	      return pie;
	    };
	    pie.sort = function(_) {
	      if (!arguments.length) return sort;
	      sort = _;
	      return pie;
	    };
	    pie.startAngle = function(_) {
	      if (!arguments.length) return startAngle;
	      startAngle = _;
	      return pie;
	    };
	    pie.endAngle = function(_) {
	      if (!arguments.length) return endAngle;
	      endAngle = _;
	      return pie;
	    };
	    pie.padAngle = function(_) {
	      if (!arguments.length) return padAngle;
	      padAngle = _;
	      return pie;
	    };
	    return pie;
	  };
	  var d3_layout_pieSortByValue = {};
	  d3.layout.stack = function() {
	    var values = d3_identity, order = d3_layout_stackOrderDefault, offset = d3_layout_stackOffsetZero, out = d3_layout_stackOut, x = d3_layout_stackX, y = d3_layout_stackY;
	    function stack(data, index) {
	      if (!(n = data.length)) return data;
	      var series = data.map(function(d, i) {
	        return values.call(stack, d, i);
	      });
	      var points = series.map(function(d) {
	        return d.map(function(v, i) {
	          return [ x.call(stack, v, i), y.call(stack, v, i) ];
	        });
	      });
	      var orders = order.call(stack, points, index);
	      series = d3.permute(series, orders);
	      points = d3.permute(points, orders);
	      var offsets = offset.call(stack, points, index);
	      var m = series[0].length, n, i, j, o;
	      for (j = 0; j < m; ++j) {
	        out.call(stack, series[0][j], o = offsets[j], points[0][j][1]);
	        for (i = 1; i < n; ++i) {
	          out.call(stack, series[i][j], o += points[i - 1][j][1], points[i][j][1]);
	        }
	      }
	      return data;
	    }
	    stack.values = function(x) {
	      if (!arguments.length) return values;
	      values = x;
	      return stack;
	    };
	    stack.order = function(x) {
	      if (!arguments.length) return order;
	      order = typeof x === "function" ? x : d3_layout_stackOrders.get(x) || d3_layout_stackOrderDefault;
	      return stack;
	    };
	    stack.offset = function(x) {
	      if (!arguments.length) return offset;
	      offset = typeof x === "function" ? x : d3_layout_stackOffsets.get(x) || d3_layout_stackOffsetZero;
	      return stack;
	    };
	    stack.x = function(z) {
	      if (!arguments.length) return x;
	      x = z;
	      return stack;
	    };
	    stack.y = function(z) {
	      if (!arguments.length) return y;
	      y = z;
	      return stack;
	    };
	    stack.out = function(z) {
	      if (!arguments.length) return out;
	      out = z;
	      return stack;
	    };
	    return stack;
	  };
	  function d3_layout_stackX(d) {
	    return d.x;
	  }
	  function d3_layout_stackY(d) {
	    return d.y;
	  }
	  function d3_layout_stackOut(d, y0, y) {
	    d.y0 = y0;
	    d.y = y;
	  }
	  var d3_layout_stackOrders = d3.map({
	    "inside-out": function(data) {
	      var n = data.length, i, j, max = data.map(d3_layout_stackMaxIndex), sums = data.map(d3_layout_stackReduceSum), index = d3.range(n).sort(function(a, b) {
	        return max[a] - max[b];
	      }), top = 0, bottom = 0, tops = [], bottoms = [];
	      for (i = 0; i < n; ++i) {
	        j = index[i];
	        if (top < bottom) {
	          top += sums[j];
	          tops.push(j);
	        } else {
	          bottom += sums[j];
	          bottoms.push(j);
	        }
	      }
	      return bottoms.reverse().concat(tops);
	    },
	    reverse: function(data) {
	      return d3.range(data.length).reverse();
	    },
	    "default": d3_layout_stackOrderDefault
	  });
	  var d3_layout_stackOffsets = d3.map({
	    silhouette: function(data) {
	      var n = data.length, m = data[0].length, sums = [], max = 0, i, j, o, y0 = [];
	      for (j = 0; j < m; ++j) {
	        for (i = 0, o = 0; i < n; i++) o += data[i][j][1];
	        if (o > max) max = o;
	        sums.push(o);
	      }
	      for (j = 0; j < m; ++j) {
	        y0[j] = (max - sums[j]) / 2;
	      }
	      return y0;
	    },
	    wiggle: function(data) {
	      var n = data.length, x = data[0], m = x.length, i, j, k, s1, s2, s3, dx, o, o0, y0 = [];
	      y0[0] = o = o0 = 0;
	      for (j = 1; j < m; ++j) {
	        for (i = 0, s1 = 0; i < n; ++i) s1 += data[i][j][1];
	        for (i = 0, s2 = 0, dx = x[j][0] - x[j - 1][0]; i < n; ++i) {
	          for (k = 0, s3 = (data[i][j][1] - data[i][j - 1][1]) / (2 * dx); k < i; ++k) {
	            s3 += (data[k][j][1] - data[k][j - 1][1]) / dx;
	          }
	          s2 += s3 * data[i][j][1];
	        }
	        y0[j] = o -= s1 ? s2 / s1 * dx : 0;
	        if (o < o0) o0 = o;
	      }
	      for (j = 0; j < m; ++j) y0[j] -= o0;
	      return y0;
	    },
	    expand: function(data) {
	      var n = data.length, m = data[0].length, k = 1 / n, i, j, o, y0 = [];
	      for (j = 0; j < m; ++j) {
	        for (i = 0, o = 0; i < n; i++) o += data[i][j][1];
	        if (o) for (i = 0; i < n; i++) data[i][j][1] /= o; else for (i = 0; i < n; i++) data[i][j][1] = k;
	      }
	      for (j = 0; j < m; ++j) y0[j] = 0;
	      return y0;
	    },
	    zero: d3_layout_stackOffsetZero
	  });
	  function d3_layout_stackOrderDefault(data) {
	    return d3.range(data.length);
	  }
	  function d3_layout_stackOffsetZero(data) {
	    var j = -1, m = data[0].length, y0 = [];
	    while (++j < m) y0[j] = 0;
	    return y0;
	  }
	  function d3_layout_stackMaxIndex(array) {
	    var i = 1, j = 0, v = array[0][1], k, n = array.length;
	    for (;i < n; ++i) {
	      if ((k = array[i][1]) > v) {
	        j = i;
	        v = k;
	      }
	    }
	    return j;
	  }
	  function d3_layout_stackReduceSum(d) {
	    return d.reduce(d3_layout_stackSum, 0);
	  }
	  function d3_layout_stackSum(p, d) {
	    return p + d[1];
	  }
	  d3.layout.histogram = function() {
	    var frequency = true, valuer = Number, ranger = d3_layout_histogramRange, binner = d3_layout_histogramBinSturges;
	    function histogram(data, i) {
	      var bins = [], values = data.map(valuer, this), range = ranger.call(this, values, i), thresholds = binner.call(this, range, values, i), bin, i = -1, n = values.length, m = thresholds.length - 1, k = frequency ? 1 : 1 / n, x;
	      while (++i < m) {
	        bin = bins[i] = [];
	        bin.dx = thresholds[i + 1] - (bin.x = thresholds[i]);
	        bin.y = 0;
	      }
	      if (m > 0) {
	        i = -1;
	        while (++i < n) {
	          x = values[i];
	          if (x >= range[0] && x <= range[1]) {
	            bin = bins[d3.bisect(thresholds, x, 1, m) - 1];
	            bin.y += k;
	            bin.push(data[i]);
	          }
	        }
	      }
	      return bins;
	    }
	    histogram.value = function(x) {
	      if (!arguments.length) return valuer;
	      valuer = x;
	      return histogram;
	    };
	    histogram.range = function(x) {
	      if (!arguments.length) return ranger;
	      ranger = d3_functor(x);
	      return histogram;
	    };
	    histogram.bins = function(x) {
	      if (!arguments.length) return binner;
	      binner = typeof x === "number" ? function(range) {
	        return d3_layout_histogramBinFixed(range, x);
	      } : d3_functor(x);
	      return histogram;
	    };
	    histogram.frequency = function(x) {
	      if (!arguments.length) return frequency;
	      frequency = !!x;
	      return histogram;
	    };
	    return histogram;
	  };
	  function d3_layout_histogramBinSturges(range, values) {
	    return d3_layout_histogramBinFixed(range, Math.ceil(Math.log(values.length) / Math.LN2 + 1));
	  }
	  function d3_layout_histogramBinFixed(range, n) {
	    var x = -1, b = +range[0], m = (range[1] - b) / n, f = [];
	    while (++x <= n) f[x] = m * x + b;
	    return f;
	  }
	  function d3_layout_histogramRange(values) {
	    return [ d3.min(values), d3.max(values) ];
	  }
	  d3.layout.pack = function() {
	    var hierarchy = d3.layout.hierarchy().sort(d3_layout_packSort), padding = 0, size = [ 1, 1 ], radius;
	    function pack(d, i) {
	      var nodes = hierarchy.call(this, d, i), root = nodes[0], w = size[0], h = size[1], r = radius == null ? Math.sqrt : typeof radius === "function" ? radius : function() {
	        return radius;
	      };
	      root.x = root.y = 0;
	      d3_layout_hierarchyVisitAfter(root, function(d) {
	        d.r = +r(d.value);
	      });
	      d3_layout_hierarchyVisitAfter(root, d3_layout_packSiblings);
	      if (padding) {
	        var dr = padding * (radius ? 1 : Math.max(2 * root.r / w, 2 * root.r / h)) / 2;
	        d3_layout_hierarchyVisitAfter(root, function(d) {
	          d.r += dr;
	        });
	        d3_layout_hierarchyVisitAfter(root, d3_layout_packSiblings);
	        d3_layout_hierarchyVisitAfter(root, function(d) {
	          d.r -= dr;
	        });
	      }
	      d3_layout_packTransform(root, w / 2, h / 2, radius ? 1 : 1 / Math.max(2 * root.r / w, 2 * root.r / h));
	      return nodes;
	    }
	    pack.size = function(_) {
	      if (!arguments.length) return size;
	      size = _;
	      return pack;
	    };
	    pack.radius = function(_) {
	      if (!arguments.length) return radius;
	      radius = _ == null || typeof _ === "function" ? _ : +_;
	      return pack;
	    };
	    pack.padding = function(_) {
	      if (!arguments.length) return padding;
	      padding = +_;
	      return pack;
	    };
	    return d3_layout_hierarchyRebind(pack, hierarchy);
	  };
	  function d3_layout_packSort(a, b) {
	    return a.value - b.value;
	  }
	  function d3_layout_packInsert(a, b) {
	    var c = a._pack_next;
	    a._pack_next = b;
	    b._pack_prev = a;
	    b._pack_next = c;
	    c._pack_prev = b;
	  }
	  function d3_layout_packSplice(a, b) {
	    a._pack_next = b;
	    b._pack_prev = a;
	  }
	  function d3_layout_packIntersects(a, b) {
	    var dx = b.x - a.x, dy = b.y - a.y, dr = a.r + b.r;
	    return .999 * dr * dr > dx * dx + dy * dy;
	  }
	  function d3_layout_packSiblings(node) {
	    if (!(nodes = node.children) || !(n = nodes.length)) return;
	    var nodes, xMin = Infinity, xMax = -Infinity, yMin = Infinity, yMax = -Infinity, a, b, c, i, j, k, n;
	    function bound(node) {
	      xMin = Math.min(node.x - node.r, xMin);
	      xMax = Math.max(node.x + node.r, xMax);
	      yMin = Math.min(node.y - node.r, yMin);
	      yMax = Math.max(node.y + node.r, yMax);
	    }
	    nodes.forEach(d3_layout_packLink);
	    a = nodes[0];
	    a.x = -a.r;
	    a.y = 0;
	    bound(a);
	    if (n > 1) {
	      b = nodes[1];
	      b.x = b.r;
	      b.y = 0;
	      bound(b);
	      if (n > 2) {
	        c = nodes[2];
	        d3_layout_packPlace(a, b, c);
	        bound(c);
	        d3_layout_packInsert(a, c);
	        a._pack_prev = c;
	        d3_layout_packInsert(c, b);
	        b = a._pack_next;
	        for (i = 3; i < n; i++) {
	          d3_layout_packPlace(a, b, c = nodes[i]);
	          var isect = 0, s1 = 1, s2 = 1;
	          for (j = b._pack_next; j !== b; j = j._pack_next, s1++) {
	            if (d3_layout_packIntersects(j, c)) {
	              isect = 1;
	              break;
	            }
	          }
	          if (isect == 1) {
	            for (k = a._pack_prev; k !== j._pack_prev; k = k._pack_prev, s2++) {
	              if (d3_layout_packIntersects(k, c)) {
	                break;
	              }
	            }
	          }
	          if (isect) {
	            if (s1 < s2 || s1 == s2 && b.r < a.r) d3_layout_packSplice(a, b = j); else d3_layout_packSplice(a = k, b);
	            i--;
	          } else {
	            d3_layout_packInsert(a, c);
	            b = c;
	            bound(c);
	          }
	        }
	      }
	    }
	    var cx = (xMin + xMax) / 2, cy = (yMin + yMax) / 2, cr = 0;
	    for (i = 0; i < n; i++) {
	      c = nodes[i];
	      c.x -= cx;
	      c.y -= cy;
	      cr = Math.max(cr, c.r + Math.sqrt(c.x * c.x + c.y * c.y));
	    }
	    node.r = cr;
	    nodes.forEach(d3_layout_packUnlink);
	  }
	  function d3_layout_packLink(node) {
	    node._pack_next = node._pack_prev = node;
	  }
	  function d3_layout_packUnlink(node) {
	    delete node._pack_next;
	    delete node._pack_prev;
	  }
	  function d3_layout_packTransform(node, x, y, k) {
	    var children = node.children;
	    node.x = x += k * node.x;
	    node.y = y += k * node.y;
	    node.r *= k;
	    if (children) {
	      var i = -1, n = children.length;
	      while (++i < n) d3_layout_packTransform(children[i], x, y, k);
	    }
	  }
	  function d3_layout_packPlace(a, b, c) {
	    var db = a.r + c.r, dx = b.x - a.x, dy = b.y - a.y;
	    if (db && (dx || dy)) {
	      var da = b.r + c.r, dc = dx * dx + dy * dy;
	      da *= da;
	      db *= db;
	      var x = .5 + (db - da) / (2 * dc), y = Math.sqrt(Math.max(0, 2 * da * (db + dc) - (db -= dc) * db - da * da)) / (2 * dc);
	      c.x = a.x + x * dx + y * dy;
	      c.y = a.y + x * dy - y * dx;
	    } else {
	      c.x = a.x + db;
	      c.y = a.y;
	    }
	  }
	  d3.layout.tree = function() {
	    var hierarchy = d3.layout.hierarchy().sort(null).value(null), separation = d3_layout_treeSeparation, size = [ 1, 1 ], nodeSize = null;
	    function tree(d, i) {
	      var nodes = hierarchy.call(this, d, i), root0 = nodes[0], root1 = wrapTree(root0);
	      d3_layout_hierarchyVisitAfter(root1, firstWalk), root1.parent.m = -root1.z;
	      d3_layout_hierarchyVisitBefore(root1, secondWalk);
	      if (nodeSize) d3_layout_hierarchyVisitBefore(root0, sizeNode); else {
	        var left = root0, right = root0, bottom = root0;
	        d3_layout_hierarchyVisitBefore(root0, function(node) {
	          if (node.x < left.x) left = node;
	          if (node.x > right.x) right = node;
	          if (node.depth > bottom.depth) bottom = node;
	        });
	        var tx = separation(left, right) / 2 - left.x, kx = size[0] / (right.x + separation(right, left) / 2 + tx), ky = size[1] / (bottom.depth || 1);
	        d3_layout_hierarchyVisitBefore(root0, function(node) {
	          node.x = (node.x + tx) * kx;
	          node.y = node.depth * ky;
	        });
	      }
	      return nodes;
	    }
	    function wrapTree(root0) {
	      var root1 = {
	        A: null,
	        children: [ root0 ]
	      }, queue = [ root1 ], node1;
	      while ((node1 = queue.pop()) != null) {
	        for (var children = node1.children, child, i = 0, n = children.length; i < n; ++i) {
	          queue.push((children[i] = child = {
	            _: children[i],
	            parent: node1,
	            children: (child = children[i].children) && child.slice() || [],
	            A: null,
	            a: null,
	            z: 0,
	            m: 0,
	            c: 0,
	            s: 0,
	            t: null,
	            i: i
	          }).a = child);
	        }
	      }
	      return root1.children[0];
	    }
	    function firstWalk(v) {
	      var children = v.children, siblings = v.parent.children, w = v.i ? siblings[v.i - 1] : null;
	      if (children.length) {
	        d3_layout_treeShift(v);
	        var midpoint = (children[0].z + children[children.length - 1].z) / 2;
	        if (w) {
	          v.z = w.z + separation(v._, w._);
	          v.m = v.z - midpoint;
	        } else {
	          v.z = midpoint;
	        }
	      } else if (w) {
	        v.z = w.z + separation(v._, w._);
	      }
	      v.parent.A = apportion(v, w, v.parent.A || siblings[0]);
	    }
	    function secondWalk(v) {
	      v._.x = v.z + v.parent.m;
	      v.m += v.parent.m;
	    }
	    function apportion(v, w, ancestor) {
	      if (w) {
	        var vip = v, vop = v, vim = w, vom = vip.parent.children[0], sip = vip.m, sop = vop.m, sim = vim.m, som = vom.m, shift;
	        while (vim = d3_layout_treeRight(vim), vip = d3_layout_treeLeft(vip), vim && vip) {
	          vom = d3_layout_treeLeft(vom);
	          vop = d3_layout_treeRight(vop);
	          vop.a = v;
	          shift = vim.z + sim - vip.z - sip + separation(vim._, vip._);
	          if (shift > 0) {
	            d3_layout_treeMove(d3_layout_treeAncestor(vim, v, ancestor), v, shift);
	            sip += shift;
	            sop += shift;
	          }
	          sim += vim.m;
	          sip += vip.m;
	          som += vom.m;
	          sop += vop.m;
	        }
	        if (vim && !d3_layout_treeRight(vop)) {
	          vop.t = vim;
	          vop.m += sim - sop;
	        }
	        if (vip && !d3_layout_treeLeft(vom)) {
	          vom.t = vip;
	          vom.m += sip - som;
	          ancestor = v;
	        }
	      }
	      return ancestor;
	    }
	    function sizeNode(node) {
	      node.x *= size[0];
	      node.y = node.depth * size[1];
	    }
	    tree.separation = function(x) {
	      if (!arguments.length) return separation;
	      separation = x;
	      return tree;
	    };
	    tree.size = function(x) {
	      if (!arguments.length) return nodeSize ? null : size;
	      nodeSize = (size = x) == null ? sizeNode : null;
	      return tree;
	    };
	    tree.nodeSize = function(x) {
	      if (!arguments.length) return nodeSize ? size : null;
	      nodeSize = (size = x) == null ? null : sizeNode;
	      return tree;
	    };
	    return d3_layout_hierarchyRebind(tree, hierarchy);
	  };
	  function d3_layout_treeSeparation(a, b) {
	    return a.parent == b.parent ? 1 : 2;
	  }
	  function d3_layout_treeLeft(v) {
	    var children = v.children;
	    return children.length ? children[0] : v.t;
	  }
	  function d3_layout_treeRight(v) {
	    var children = v.children, n;
	    return (n = children.length) ? children[n - 1] : v.t;
	  }
	  function d3_layout_treeMove(wm, wp, shift) {
	    var change = shift / (wp.i - wm.i);
	    wp.c -= change;
	    wp.s += shift;
	    wm.c += change;
	    wp.z += shift;
	    wp.m += shift;
	  }
	  function d3_layout_treeShift(v) {
	    var shift = 0, change = 0, children = v.children, i = children.length, w;
	    while (--i >= 0) {
	      w = children[i];
	      w.z += shift;
	      w.m += shift;
	      shift += w.s + (change += w.c);
	    }
	  }
	  function d3_layout_treeAncestor(vim, v, ancestor) {
	    return vim.a.parent === v.parent ? vim.a : ancestor;
	  }
	  d3.layout.cluster = function() {
	    var hierarchy = d3.layout.hierarchy().sort(null).value(null), separation = d3_layout_treeSeparation, size = [ 1, 1 ], nodeSize = false;
	    function cluster(d, i) {
	      var nodes = hierarchy.call(this, d, i), root = nodes[0], previousNode, x = 0;
	      d3_layout_hierarchyVisitAfter(root, function(node) {
	        var children = node.children;
	        if (children && children.length) {
	          node.x = d3_layout_clusterX(children);
	          node.y = d3_layout_clusterY(children);
	        } else {
	          node.x = previousNode ? x += separation(node, previousNode) : 0;
	          node.y = 0;
	          previousNode = node;
	        }
	      });
	      var left = d3_layout_clusterLeft(root), right = d3_layout_clusterRight(root), x0 = left.x - separation(left, right) / 2, x1 = right.x + separation(right, left) / 2;
	      d3_layout_hierarchyVisitAfter(root, nodeSize ? function(node) {
	        node.x = (node.x - root.x) * size[0];
	        node.y = (root.y - node.y) * size[1];
	      } : function(node) {
	        node.x = (node.x - x0) / (x1 - x0) * size[0];
	        node.y = (1 - (root.y ? node.y / root.y : 1)) * size[1];
	      });
	      return nodes;
	    }
	    cluster.separation = function(x) {
	      if (!arguments.length) return separation;
	      separation = x;
	      return cluster;
	    };
	    cluster.size = function(x) {
	      if (!arguments.length) return nodeSize ? null : size;
	      nodeSize = (size = x) == null;
	      return cluster;
	    };
	    cluster.nodeSize = function(x) {
	      if (!arguments.length) return nodeSize ? size : null;
	      nodeSize = (size = x) != null;
	      return cluster;
	    };
	    return d3_layout_hierarchyRebind(cluster, hierarchy);
	  };
	  function d3_layout_clusterY(children) {
	    return 1 + d3.max(children, function(child) {
	      return child.y;
	    });
	  }
	  function d3_layout_clusterX(children) {
	    return children.reduce(function(x, child) {
	      return x + child.x;
	    }, 0) / children.length;
	  }
	  function d3_layout_clusterLeft(node) {
	    var children = node.children;
	    return children && children.length ? d3_layout_clusterLeft(children[0]) : node;
	  }
	  function d3_layout_clusterRight(node) {
	    var children = node.children, n;
	    return children && (n = children.length) ? d3_layout_clusterRight(children[n - 1]) : node;
	  }
	  d3.layout.treemap = function() {
	    var hierarchy = d3.layout.hierarchy(), round = Math.round, size = [ 1, 1 ], padding = null, pad = d3_layout_treemapPadNull, sticky = false, stickies, mode = "squarify", ratio = .5 * (1 + Math.sqrt(5));
	    function scale(children, k) {
	      var i = -1, n = children.length, child, area;
	      while (++i < n) {
	        area = (child = children[i]).value * (k < 0 ? 0 : k);
	        child.area = isNaN(area) || area <= 0 ? 0 : area;
	      }
	    }
	    function squarify(node) {
	      var children = node.children;
	      if (children && children.length) {
	        var rect = pad(node), row = [], remaining = children.slice(), child, best = Infinity, score, u = mode === "slice" ? rect.dx : mode === "dice" ? rect.dy : mode === "slice-dice" ? node.depth & 1 ? rect.dy : rect.dx : Math.min(rect.dx, rect.dy), n;
	        scale(remaining, rect.dx * rect.dy / node.value);
	        row.area = 0;
	        while ((n = remaining.length) > 0) {
	          row.push(child = remaining[n - 1]);
	          row.area += child.area;
	          if (mode !== "squarify" || (score = worst(row, u)) <= best) {
	            remaining.pop();
	            best = score;
	          } else {
	            row.area -= row.pop().area;
	            position(row, u, rect, false);
	            u = Math.min(rect.dx, rect.dy);
	            row.length = row.area = 0;
	            best = Infinity;
	          }
	        }
	        if (row.length) {
	          position(row, u, rect, true);
	          row.length = row.area = 0;
	        }
	        children.forEach(squarify);
	      }
	    }
	    function stickify(node) {
	      var children = node.children;
	      if (children && children.length) {
	        var rect = pad(node), remaining = children.slice(), child, row = [];
	        scale(remaining, rect.dx * rect.dy / node.value);
	        row.area = 0;
	        while (child = remaining.pop()) {
	          row.push(child);
	          row.area += child.area;
	          if (child.z != null) {
	            position(row, child.z ? rect.dx : rect.dy, rect, !remaining.length);
	            row.length = row.area = 0;
	          }
	        }
	        children.forEach(stickify);
	      }
	    }
	    function worst(row, u) {
	      var s = row.area, r, rmax = 0, rmin = Infinity, i = -1, n = row.length;
	      while (++i < n) {
	        if (!(r = row[i].area)) continue;
	        if (r < rmin) rmin = r;
	        if (r > rmax) rmax = r;
	      }
	      s *= s;
	      u *= u;
	      return s ? Math.max(u * rmax * ratio / s, s / (u * rmin * ratio)) : Infinity;
	    }
	    function position(row, u, rect, flush) {
	      var i = -1, n = row.length, x = rect.x, y = rect.y, v = u ? round(row.area / u) : 0, o;
	      if (u == rect.dx) {
	        if (flush || v > rect.dy) v = rect.dy;
	        while (++i < n) {
	          o = row[i];
	          o.x = x;
	          o.y = y;
	          o.dy = v;
	          x += o.dx = Math.min(rect.x + rect.dx - x, v ? round(o.area / v) : 0);
	        }
	        o.z = true;
	        o.dx += rect.x + rect.dx - x;
	        rect.y += v;
	        rect.dy -= v;
	      } else {
	        if (flush || v > rect.dx) v = rect.dx;
	        while (++i < n) {
	          o = row[i];
	          o.x = x;
	          o.y = y;
	          o.dx = v;
	          y += o.dy = Math.min(rect.y + rect.dy - y, v ? round(o.area / v) : 0);
	        }
	        o.z = false;
	        o.dy += rect.y + rect.dy - y;
	        rect.x += v;
	        rect.dx -= v;
	      }
	    }
	    function treemap(d) {
	      var nodes = stickies || hierarchy(d), root = nodes[0];
	      root.x = root.y = 0;
	      if (root.value) root.dx = size[0], root.dy = size[1]; else root.dx = root.dy = 0;
	      if (stickies) hierarchy.revalue(root);
	      scale([ root ], root.dx * root.dy / root.value);
	      (stickies ? stickify : squarify)(root);
	      if (sticky) stickies = nodes;
	      return nodes;
	    }
	    treemap.size = function(x) {
	      if (!arguments.length) return size;
	      size = x;
	      return treemap;
	    };
	    treemap.padding = function(x) {
	      if (!arguments.length) return padding;
	      function padFunction(node) {
	        var p = x.call(treemap, node, node.depth);
	        return p == null ? d3_layout_treemapPadNull(node) : d3_layout_treemapPad(node, typeof p === "number" ? [ p, p, p, p ] : p);
	      }
	      function padConstant(node) {
	        return d3_layout_treemapPad(node, x);
	      }
	      var type;
	      pad = (padding = x) == null ? d3_layout_treemapPadNull : (type = typeof x) === "function" ? padFunction : type === "number" ? (x = [ x, x, x, x ], 
	      padConstant) : padConstant;
	      return treemap;
	    };
	    treemap.round = function(x) {
	      if (!arguments.length) return round != Number;
	      round = x ? Math.round : Number;
	      return treemap;
	    };
	    treemap.sticky = function(x) {
	      if (!arguments.length) return sticky;
	      sticky = x;
	      stickies = null;
	      return treemap;
	    };
	    treemap.ratio = function(x) {
	      if (!arguments.length) return ratio;
	      ratio = x;
	      return treemap;
	    };
	    treemap.mode = function(x) {
	      if (!arguments.length) return mode;
	      mode = x + "";
	      return treemap;
	    };
	    return d3_layout_hierarchyRebind(treemap, hierarchy);
	  };
	  function d3_layout_treemapPadNull(node) {
	    return {
	      x: node.x,
	      y: node.y,
	      dx: node.dx,
	      dy: node.dy
	    };
	  }
	  function d3_layout_treemapPad(node, padding) {
	    var x = node.x + padding[3], y = node.y + padding[0], dx = node.dx - padding[1] - padding[3], dy = node.dy - padding[0] - padding[2];
	    if (dx < 0) {
	      x += dx / 2;
	      dx = 0;
	    }
	    if (dy < 0) {
	      y += dy / 2;
	      dy = 0;
	    }
	    return {
	      x: x,
	      y: y,
	      dx: dx,
	      dy: dy
	    };
	  }
	  d3.random = {
	    normal: function(µ, σ) {
	      var n = arguments.length;
	      if (n < 2) σ = 1;
	      if (n < 1) µ = 0;
	      return function() {
	        var x, y, r;
	        do {
	          x = Math.random() * 2 - 1;
	          y = Math.random() * 2 - 1;
	          r = x * x + y * y;
	        } while (!r || r > 1);
	        return µ + σ * x * Math.sqrt(-2 * Math.log(r) / r);
	      };
	    },
	    logNormal: function() {
	      var random = d3.random.normal.apply(d3, arguments);
	      return function() {
	        return Math.exp(random());
	      };
	    },
	    bates: function(m) {
	      var random = d3.random.irwinHall(m);
	      return function() {
	        return random() / m;
	      };
	    },
	    irwinHall: function(m) {
	      return function() {
	        for (var s = 0, j = 0; j < m; j++) s += Math.random();
	        return s;
	      };
	    }
	  };
	  d3.scale = {};
	  function d3_scaleExtent(domain) {
	    var start = domain[0], stop = domain[domain.length - 1];
	    return start < stop ? [ start, stop ] : [ stop, start ];
	  }
	  function d3_scaleRange(scale) {
	    return scale.rangeExtent ? scale.rangeExtent() : d3_scaleExtent(scale.range());
	  }
	  function d3_scale_bilinear(domain, range, uninterpolate, interpolate) {
	    var u = uninterpolate(domain[0], domain[1]), i = interpolate(range[0], range[1]);
	    return function(x) {
	      return i(u(x));
	    };
	  }
	  function d3_scale_nice(domain, nice) {
	    var i0 = 0, i1 = domain.length - 1, x0 = domain[i0], x1 = domain[i1], dx;
	    if (x1 < x0) {
	      dx = i0, i0 = i1, i1 = dx;
	      dx = x0, x0 = x1, x1 = dx;
	    }
	    domain[i0] = nice.floor(x0);
	    domain[i1] = nice.ceil(x1);
	    return domain;
	  }
	  function d3_scale_niceStep(step) {
	    return step ? {
	      floor: function(x) {
	        return Math.floor(x / step) * step;
	      },
	      ceil: function(x) {
	        return Math.ceil(x / step) * step;
	      }
	    } : d3_scale_niceIdentity;
	  }
	  var d3_scale_niceIdentity = {
	    floor: d3_identity,
	    ceil: d3_identity
	  };
	  function d3_scale_polylinear(domain, range, uninterpolate, interpolate) {
	    var u = [], i = [], j = 0, k = Math.min(domain.length, range.length) - 1;
	    if (domain[k] < domain[0]) {
	      domain = domain.slice().reverse();
	      range = range.slice().reverse();
	    }
	    while (++j <= k) {
	      u.push(uninterpolate(domain[j - 1], domain[j]));
	      i.push(interpolate(range[j - 1], range[j]));
	    }
	    return function(x) {
	      var j = d3.bisect(domain, x, 1, k) - 1;
	      return i[j](u[j](x));
	    };
	  }
	  d3.scale.linear = function() {
	    return d3_scale_linear([ 0, 1 ], [ 0, 1 ], d3_interpolate, false);
	  };
	  function d3_scale_linear(domain, range, interpolate, clamp) {
	    var output, input;
	    function rescale() {
	      var linear = Math.min(domain.length, range.length) > 2 ? d3_scale_polylinear : d3_scale_bilinear, uninterpolate = clamp ? d3_uninterpolateClamp : d3_uninterpolateNumber;
	      output = linear(domain, range, uninterpolate, interpolate);
	      input = linear(range, domain, uninterpolate, d3_interpolate);
	      return scale;
	    }
	    function scale(x) {
	      return output(x);
	    }
	    scale.invert = function(y) {
	      return input(y);
	    };
	    scale.domain = function(x) {
	      if (!arguments.length) return domain;
	      domain = x.map(Number);
	      return rescale();
	    };
	    scale.range = function(x) {
	      if (!arguments.length) return range;
	      range = x;
	      return rescale();
	    };
	    scale.rangeRound = function(x) {
	      return scale.range(x).interpolate(d3_interpolateRound);
	    };
	    scale.clamp = function(x) {
	      if (!arguments.length) return clamp;
	      clamp = x;
	      return rescale();
	    };
	    scale.interpolate = function(x) {
	      if (!arguments.length) return interpolate;
	      interpolate = x;
	      return rescale();
	    };
	    scale.ticks = function(m) {
	      return d3_scale_linearTicks(domain, m);
	    };
	    scale.tickFormat = function(m, format) {
	      return d3_scale_linearTickFormat(domain, m, format);
	    };
	    scale.nice = function(m) {
	      d3_scale_linearNice(domain, m);
	      return rescale();
	    };
	    scale.copy = function() {
	      return d3_scale_linear(domain, range, interpolate, clamp);
	    };
	    return rescale();
	  }
	  function d3_scale_linearRebind(scale, linear) {
	    return d3.rebind(scale, linear, "range", "rangeRound", "interpolate", "clamp");
	  }
	  function d3_scale_linearNice(domain, m) {
	    d3_scale_nice(domain, d3_scale_niceStep(d3_scale_linearTickRange(domain, m)[2]));
	    d3_scale_nice(domain, d3_scale_niceStep(d3_scale_linearTickRange(domain, m)[2]));
	    return domain;
	  }
	  function d3_scale_linearTickRange(domain, m) {
	    if (m == null) m = 10;
	    var extent = d3_scaleExtent(domain), span = extent[1] - extent[0], step = Math.pow(10, Math.floor(Math.log(span / m) / Math.LN10)), err = m / span * step;
	    if (err <= .15) step *= 10; else if (err <= .35) step *= 5; else if (err <= .75) step *= 2;
	    extent[0] = Math.ceil(extent[0] / step) * step;
	    extent[1] = Math.floor(extent[1] / step) * step + step * .5;
	    extent[2] = step;
	    return extent;
	  }
	  function d3_scale_linearTicks(domain, m) {
	    return d3.range.apply(d3, d3_scale_linearTickRange(domain, m));
	  }
	  function d3_scale_linearTickFormat(domain, m, format) {
	    var range = d3_scale_linearTickRange(domain, m);
	    if (format) {
	      var match = d3_format_re.exec(format);
	      match.shift();
	      if (match[8] === "s") {
	        var prefix = d3.formatPrefix(Math.max(abs(range[0]), abs(range[1])));
	        if (!match[7]) match[7] = "." + d3_scale_linearPrecision(prefix.scale(range[2]));
	        match[8] = "f";
	        format = d3.format(match.join(""));
	        return function(d) {
	          return format(prefix.scale(d)) + prefix.symbol;
	        };
	      }
	      if (!match[7]) match[7] = "." + d3_scale_linearFormatPrecision(match[8], range);
	      format = match.join("");
	    } else {
	      format = ",." + d3_scale_linearPrecision(range[2]) + "f";
	    }
	    return d3.format(format);
	  }
	  var d3_scale_linearFormatSignificant = {
	    s: 1,
	    g: 1,
	    p: 1,
	    r: 1,
	    e: 1
	  };
	  function d3_scale_linearPrecision(value) {
	    return -Math.floor(Math.log(value) / Math.LN10 + .01);
	  }
	  function d3_scale_linearFormatPrecision(type, range) {
	    var p = d3_scale_linearPrecision(range[2]);
	    return type in d3_scale_linearFormatSignificant ? Math.abs(p - d3_scale_linearPrecision(Math.max(abs(range[0]), abs(range[1])))) + +(type !== "e") : p - (type === "%") * 2;
	  }
	  d3.scale.log = function() {
	    return d3_scale_log(d3.scale.linear().domain([ 0, 1 ]), 10, true, [ 1, 10 ]);
	  };
	  function d3_scale_log(linear, base, positive, domain) {
	    function log(x) {
	      return (positive ? Math.log(x < 0 ? 0 : x) : -Math.log(x > 0 ? 0 : -x)) / Math.log(base);
	    }
	    function pow(x) {
	      return positive ? Math.pow(base, x) : -Math.pow(base, -x);
	    }
	    function scale(x) {
	      return linear(log(x));
	    }
	    scale.invert = function(x) {
	      return pow(linear.invert(x));
	    };
	    scale.domain = function(x) {
	      if (!arguments.length) return domain;
	      positive = x[0] >= 0;
	      linear.domain((domain = x.map(Number)).map(log));
	      return scale;
	    };
	    scale.base = function(_) {
	      if (!arguments.length) return base;
	      base = +_;
	      linear.domain(domain.map(log));
	      return scale;
	    };
	    scale.nice = function() {
	      var niced = d3_scale_nice(domain.map(log), positive ? Math : d3_scale_logNiceNegative);
	      linear.domain(niced);
	      domain = niced.map(pow);
	      return scale;
	    };
	    scale.ticks = function() {
	      var extent = d3_scaleExtent(domain), ticks = [], u = extent[0], v = extent[1], i = Math.floor(log(u)), j = Math.ceil(log(v)), n = base % 1 ? 2 : base;
	      if (isFinite(j - i)) {
	        if (positive) {
	          for (;i < j; i++) for (var k = 1; k < n; k++) ticks.push(pow(i) * k);
	          ticks.push(pow(i));
	        } else {
	          ticks.push(pow(i));
	          for (;i++ < j; ) for (var k = n - 1; k > 0; k--) ticks.push(pow(i) * k);
	        }
	        for (i = 0; ticks[i] < u; i++) {}
	        for (j = ticks.length; ticks[j - 1] > v; j--) {}
	        ticks = ticks.slice(i, j);
	      }
	      return ticks;
	    };
	    scale.tickFormat = function(n, format) {
	      if (!arguments.length) return d3_scale_logFormat;
	      if (arguments.length < 2) format = d3_scale_logFormat; else if (typeof format !== "function") format = d3.format(format);
	      var k = Math.max(1, base * n / scale.ticks().length);
	      return function(d) {
	        var i = d / pow(Math.round(log(d)));
	        if (i * base < base - .5) i *= base;
	        return i <= k ? format(d) : "";
	      };
	    };
	    scale.copy = function() {
	      return d3_scale_log(linear.copy(), base, positive, domain);
	    };
	    return d3_scale_linearRebind(scale, linear);
	  }
	  var d3_scale_logFormat = d3.format(".0e"), d3_scale_logNiceNegative = {
	    floor: function(x) {
	      return -Math.ceil(-x);
	    },
	    ceil: function(x) {
	      return -Math.floor(-x);
	    }
	  };
	  d3.scale.pow = function() {
	    return d3_scale_pow(d3.scale.linear(), 1, [ 0, 1 ]);
	  };
	  function d3_scale_pow(linear, exponent, domain) {
	    var powp = d3_scale_powPow(exponent), powb = d3_scale_powPow(1 / exponent);
	    function scale(x) {
	      return linear(powp(x));
	    }
	    scale.invert = function(x) {
	      return powb(linear.invert(x));
	    };
	    scale.domain = function(x) {
	      if (!arguments.length) return domain;
	      linear.domain((domain = x.map(Number)).map(powp));
	      return scale;
	    };
	    scale.ticks = function(m) {
	      return d3_scale_linearTicks(domain, m);
	    };
	    scale.tickFormat = function(m, format) {
	      return d3_scale_linearTickFormat(domain, m, format);
	    };
	    scale.nice = function(m) {
	      return scale.domain(d3_scale_linearNice(domain, m));
	    };
	    scale.exponent = function(x) {
	      if (!arguments.length) return exponent;
	      powp = d3_scale_powPow(exponent = x);
	      powb = d3_scale_powPow(1 / exponent);
	      linear.domain(domain.map(powp));
	      return scale;
	    };
	    scale.copy = function() {
	      return d3_scale_pow(linear.copy(), exponent, domain);
	    };
	    return d3_scale_linearRebind(scale, linear);
	  }
	  function d3_scale_powPow(e) {
	    return function(x) {
	      return x < 0 ? -Math.pow(-x, e) : Math.pow(x, e);
	    };
	  }
	  d3.scale.sqrt = function() {
	    return d3.scale.pow().exponent(.5);
	  };
	  d3.scale.ordinal = function() {
	    return d3_scale_ordinal([], {
	      t: "range",
	      a: [ [] ]
	    });
	  };
	  function d3_scale_ordinal(domain, ranger) {
	    var index, range, rangeBand;
	    function scale(x) {
	      return range[((index.get(x) || (ranger.t === "range" ? index.set(x, domain.push(x)) : NaN)) - 1) % range.length];
	    }
	    function steps(start, step) {
	      return d3.range(domain.length).map(function(i) {
	        return start + step * i;
	      });
	    }
	    scale.domain = function(x) {
	      if (!arguments.length) return domain;
	      domain = [];
	      index = new d3_Map();
	      var i = -1, n = x.length, xi;
	      while (++i < n) if (!index.has(xi = x[i])) index.set(xi, domain.push(xi));
	      return scale[ranger.t].apply(scale, ranger.a);
	    };
	    scale.range = function(x) {
	      if (!arguments.length) return range;
	      range = x;
	      rangeBand = 0;
	      ranger = {
	        t: "range",
	        a: arguments
	      };
	      return scale;
	    };
	    scale.rangePoints = function(x, padding) {
	      if (arguments.length < 2) padding = 0;
	      var start = x[0], stop = x[1], step = domain.length < 2 ? (start = (start + stop) / 2, 
	      0) : (stop - start) / (domain.length - 1 + padding);
	      range = steps(start + step * padding / 2, step);
	      rangeBand = 0;
	      ranger = {
	        t: "rangePoints",
	        a: arguments
	      };
	      return scale;
	    };
	    scale.rangeRoundPoints = function(x, padding) {
	      if (arguments.length < 2) padding = 0;
	      var start = x[0], stop = x[1], step = domain.length < 2 ? (start = stop = Math.round((start + stop) / 2), 
	      0) : (stop - start) / (domain.length - 1 + padding) | 0;
	      range = steps(start + Math.round(step * padding / 2 + (stop - start - (domain.length - 1 + padding) * step) / 2), step);
	      rangeBand = 0;
	      ranger = {
	        t: "rangeRoundPoints",
	        a: arguments
	      };
	      return scale;
	    };
	    scale.rangeBands = function(x, padding, outerPadding) {
	      if (arguments.length < 2) padding = 0;
	      if (arguments.length < 3) outerPadding = padding;
	      var reverse = x[1] < x[0], start = x[reverse - 0], stop = x[1 - reverse], step = (stop - start) / (domain.length - padding + 2 * outerPadding);
	      range = steps(start + step * outerPadding, step);
	      if (reverse) range.reverse();
	      rangeBand = step * (1 - padding);
	      ranger = {
	        t: "rangeBands",
	        a: arguments
	      };
	      return scale;
	    };
	    scale.rangeRoundBands = function(x, padding, outerPadding) {
	      if (arguments.length < 2) padding = 0;
	      if (arguments.length < 3) outerPadding = padding;
	      var reverse = x[1] < x[0], start = x[reverse - 0], stop = x[1 - reverse], step = Math.floor((stop - start) / (domain.length - padding + 2 * outerPadding));
	      range = steps(start + Math.round((stop - start - (domain.length - padding) * step) / 2), step);
	      if (reverse) range.reverse();
	      rangeBand = Math.round(step * (1 - padding));
	      ranger = {
	        t: "rangeRoundBands",
	        a: arguments
	      };
	      return scale;
	    };
	    scale.rangeBand = function() {
	      return rangeBand;
	    };
	    scale.rangeExtent = function() {
	      return d3_scaleExtent(ranger.a[0]);
	    };
	    scale.copy = function() {
	      return d3_scale_ordinal(domain, ranger);
	    };
	    return scale.domain(domain);
	  }
	  d3.scale.category10 = function() {
	    return d3.scale.ordinal().range(d3_category10);
	  };
	  d3.scale.category20 = function() {
	    return d3.scale.ordinal().range(d3_category20);
	  };
	  d3.scale.category20b = function() {
	    return d3.scale.ordinal().range(d3_category20b);
	  };
	  d3.scale.category20c = function() {
	    return d3.scale.ordinal().range(d3_category20c);
	  };
	  var d3_category10 = [ 2062260, 16744206, 2924588, 14034728, 9725885, 9197131, 14907330, 8355711, 12369186, 1556175 ].map(d3_rgbString);
	  var d3_category20 = [ 2062260, 11454440, 16744206, 16759672, 2924588, 10018698, 14034728, 16750742, 9725885, 12955861, 9197131, 12885140, 14907330, 16234194, 8355711, 13092807, 12369186, 14408589, 1556175, 10410725 ].map(d3_rgbString);
	  var d3_category20b = [ 3750777, 5395619, 7040719, 10264286, 6519097, 9216594, 11915115, 13556636, 9202993, 12426809, 15186514, 15190932, 8666169, 11356490, 14049643, 15177372, 8077683, 10834324, 13528509, 14589654 ].map(d3_rgbString);
	  var d3_category20c = [ 3244733, 7057110, 10406625, 13032431, 15095053, 16616764, 16625259, 16634018, 3253076, 7652470, 10607003, 13101504, 7695281, 10394312, 12369372, 14342891, 6513507, 9868950, 12434877, 14277081 ].map(d3_rgbString);
	  d3.scale.quantile = function() {
	    return d3_scale_quantile([], []);
	  };
	  function d3_scale_quantile(domain, range) {
	    var thresholds;
	    function rescale() {
	      var k = 0, q = range.length;
	      thresholds = [];
	      while (++k < q) thresholds[k - 1] = d3.quantile(domain, k / q);
	      return scale;
	    }
	    function scale(x) {
	      if (!isNaN(x = +x)) return range[d3.bisect(thresholds, x)];
	    }
	    scale.domain = function(x) {
	      if (!arguments.length) return domain;
	      domain = x.map(d3_number).filter(d3_numeric).sort(d3_ascending);
	      return rescale();
	    };
	    scale.range = function(x) {
	      if (!arguments.length) return range;
	      range = x;
	      return rescale();
	    };
	    scale.quantiles = function() {
	      return thresholds;
	    };
	    scale.invertExtent = function(y) {
	      y = range.indexOf(y);
	      return y < 0 ? [ NaN, NaN ] : [ y > 0 ? thresholds[y - 1] : domain[0], y < thresholds.length ? thresholds[y] : domain[domain.length - 1] ];
	    };
	    scale.copy = function() {
	      return d3_scale_quantile(domain, range);
	    };
	    return rescale();
	  }
	  d3.scale.quantize = function() {
	    return d3_scale_quantize(0, 1, [ 0, 1 ]);
	  };
	  function d3_scale_quantize(x0, x1, range) {
	    var kx, i;
	    function scale(x) {
	      return range[Math.max(0, Math.min(i, Math.floor(kx * (x - x0))))];
	    }
	    function rescale() {
	      kx = range.length / (x1 - x0);
	      i = range.length - 1;
	      return scale;
	    }
	    scale.domain = function(x) {
	      if (!arguments.length) return [ x0, x1 ];
	      x0 = +x[0];
	      x1 = +x[x.length - 1];
	      return rescale();
	    };
	    scale.range = function(x) {
	      if (!arguments.length) return range;
	      range = x;
	      return rescale();
	    };
	    scale.invertExtent = function(y) {
	      y = range.indexOf(y);
	      y = y < 0 ? NaN : y / kx + x0;
	      return [ y, y + 1 / kx ];
	    };
	    scale.copy = function() {
	      return d3_scale_quantize(x0, x1, range);
	    };
	    return rescale();
	  }
	  d3.scale.threshold = function() {
	    return d3_scale_threshold([ .5 ], [ 0, 1 ]);
	  };
	  function d3_scale_threshold(domain, range) {
	    function scale(x) {
	      if (x <= x) return range[d3.bisect(domain, x)];
	    }
	    scale.domain = function(_) {
	      if (!arguments.length) return domain;
	      domain = _;
	      return scale;
	    };
	    scale.range = function(_) {
	      if (!arguments.length) return range;
	      range = _;
	      return scale;
	    };
	    scale.invertExtent = function(y) {
	      y = range.indexOf(y);
	      return [ domain[y - 1], domain[y] ];
	    };
	    scale.copy = function() {
	      return d3_scale_threshold(domain, range);
	    };
	    return scale;
	  }
	  d3.scale.identity = function() {
	    return d3_scale_identity([ 0, 1 ]);
	  };
	  function d3_scale_identity(domain) {
	    function identity(x) {
	      return +x;
	    }
	    identity.invert = identity;
	    identity.domain = identity.range = function(x) {
	      if (!arguments.length) return domain;
	      domain = x.map(identity);
	      return identity;
	    };
	    identity.ticks = function(m) {
	      return d3_scale_linearTicks(domain, m);
	    };
	    identity.tickFormat = function(m, format) {
	      return d3_scale_linearTickFormat(domain, m, format);
	    };
	    identity.copy = function() {
	      return d3_scale_identity(domain);
	    };
	    return identity;
	  }
	  d3.svg = {};
	  function d3_zero() {
	    return 0;
	  }
	  d3.svg.arc = function() {
	    var innerRadius = d3_svg_arcInnerRadius, outerRadius = d3_svg_arcOuterRadius, cornerRadius = d3_zero, padRadius = d3_svg_arcAuto, startAngle = d3_svg_arcStartAngle, endAngle = d3_svg_arcEndAngle, padAngle = d3_svg_arcPadAngle;
	    function arc() {
	      var r0 = Math.max(0, +innerRadius.apply(this, arguments)), r1 = Math.max(0, +outerRadius.apply(this, arguments)), a0 = startAngle.apply(this, arguments) - halfπ, a1 = endAngle.apply(this, arguments) - halfπ, da = Math.abs(a1 - a0), cw = a0 > a1 ? 0 : 1;
	      if (r1 < r0) rc = r1, r1 = r0, r0 = rc;
	      if (da >= τε) return circleSegment(r1, cw) + (r0 ? circleSegment(r0, 1 - cw) : "") + "Z";
	      var rc, cr, rp, ap, p0 = 0, p1 = 0, x0, y0, x1, y1, x2, y2, x3, y3, path = [];
	      if (ap = (+padAngle.apply(this, arguments) || 0) / 2) {
	        rp = padRadius === d3_svg_arcAuto ? Math.sqrt(r0 * r0 + r1 * r1) : +padRadius.apply(this, arguments);
	        if (!cw) p1 *= -1;
	        if (r1) p1 = d3_asin(rp / r1 * Math.sin(ap));
	        if (r0) p0 = d3_asin(rp / r0 * Math.sin(ap));
	      }
	      if (r1) {
	        x0 = r1 * Math.cos(a0 + p1);
	        y0 = r1 * Math.sin(a0 + p1);
	        x1 = r1 * Math.cos(a1 - p1);
	        y1 = r1 * Math.sin(a1 - p1);
	        var l1 = Math.abs(a1 - a0 - 2 * p1) <= π ? 0 : 1;
	        if (p1 && d3_svg_arcSweep(x0, y0, x1, y1) === cw ^ l1) {
	          var h1 = (a0 + a1) / 2;
	          x0 = r1 * Math.cos(h1);
	          y0 = r1 * Math.sin(h1);
	          x1 = y1 = null;
	        }
	      } else {
	        x0 = y0 = 0;
	      }
	      if (r0) {
	        x2 = r0 * Math.cos(a1 - p0);
	        y2 = r0 * Math.sin(a1 - p0);
	        x3 = r0 * Math.cos(a0 + p0);
	        y3 = r0 * Math.sin(a0 + p0);
	        var l0 = Math.abs(a0 - a1 + 2 * p0) <= π ? 0 : 1;
	        if (p0 && d3_svg_arcSweep(x2, y2, x3, y3) === 1 - cw ^ l0) {
	          var h0 = (a0 + a1) / 2;
	          x2 = r0 * Math.cos(h0);
	          y2 = r0 * Math.sin(h0);
	          x3 = y3 = null;
	        }
	      } else {
	        x2 = y2 = 0;
	      }
	      if (da > ε && (rc = Math.min(Math.abs(r1 - r0) / 2, +cornerRadius.apply(this, arguments))) > .001) {
	        cr = r0 < r1 ^ cw ? 0 : 1;
	        var rc1 = rc, rc0 = rc;
	        if (da < π) {
	          var oc = x3 == null ? [ x2, y2 ] : x1 == null ? [ x0, y0 ] : d3_geom_polygonIntersect([ x0, y0 ], [ x3, y3 ], [ x1, y1 ], [ x2, y2 ]), ax = x0 - oc[0], ay = y0 - oc[1], bx = x1 - oc[0], by = y1 - oc[1], kc = 1 / Math.sin(Math.acos((ax * bx + ay * by) / (Math.sqrt(ax * ax + ay * ay) * Math.sqrt(bx * bx + by * by))) / 2), lc = Math.sqrt(oc[0] * oc[0] + oc[1] * oc[1]);
	          rc0 = Math.min(rc, (r0 - lc) / (kc - 1));
	          rc1 = Math.min(rc, (r1 - lc) / (kc + 1));
	        }
	        if (x1 != null) {
	          var t30 = d3_svg_arcCornerTangents(x3 == null ? [ x2, y2 ] : [ x3, y3 ], [ x0, y0 ], r1, rc1, cw), t12 = d3_svg_arcCornerTangents([ x1, y1 ], [ x2, y2 ], r1, rc1, cw);
	          if (rc === rc1) {
	            path.push("M", t30[0], "A", rc1, ",", rc1, " 0 0,", cr, " ", t30[1], "A", r1, ",", r1, " 0 ", 1 - cw ^ d3_svg_arcSweep(t30[1][0], t30[1][1], t12[1][0], t12[1][1]), ",", cw, " ", t12[1], "A", rc1, ",", rc1, " 0 0,", cr, " ", t12[0]);
	          } else {
	            path.push("M", t30[0], "A", rc1, ",", rc1, " 0 1,", cr, " ", t12[0]);
	          }
	        } else {
	          path.push("M", x0, ",", y0);
	        }
	        if (x3 != null) {
	          var t03 = d3_svg_arcCornerTangents([ x0, y0 ], [ x3, y3 ], r0, -rc0, cw), t21 = d3_svg_arcCornerTangents([ x2, y2 ], x1 == null ? [ x0, y0 ] : [ x1, y1 ], r0, -rc0, cw);
	          if (rc === rc0) {
	            path.push("L", t21[0], "A", rc0, ",", rc0, " 0 0,", cr, " ", t21[1], "A", r0, ",", r0, " 0 ", cw ^ d3_svg_arcSweep(t21[1][0], t21[1][1], t03[1][0], t03[1][1]), ",", 1 - cw, " ", t03[1], "A", rc0, ",", rc0, " 0 0,", cr, " ", t03[0]);
	          } else {
	            path.push("L", t21[0], "A", rc0, ",", rc0, " 0 0,", cr, " ", t03[0]);
	          }
	        } else {
	          path.push("L", x2, ",", y2);
	        }
	      } else {
	        path.push("M", x0, ",", y0);
	        if (x1 != null) path.push("A", r1, ",", r1, " 0 ", l1, ",", cw, " ", x1, ",", y1);
	        path.push("L", x2, ",", y2);
	        if (x3 != null) path.push("A", r0, ",", r0, " 0 ", l0, ",", 1 - cw, " ", x3, ",", y3);
	      }
	      path.push("Z");
	      return path.join("");
	    }
	    function circleSegment(r1, cw) {
	      return "M0," + r1 + "A" + r1 + "," + r1 + " 0 1," + cw + " 0," + -r1 + "A" + r1 + "," + r1 + " 0 1," + cw + " 0," + r1;
	    }
	    arc.innerRadius = function(v) {
	      if (!arguments.length) return innerRadius;
	      innerRadius = d3_functor(v);
	      return arc;
	    };
	    arc.outerRadius = function(v) {
	      if (!arguments.length) return outerRadius;
	      outerRadius = d3_functor(v);
	      return arc;
	    };
	    arc.cornerRadius = function(v) {
	      if (!arguments.length) return cornerRadius;
	      cornerRadius = d3_functor(v);
	      return arc;
	    };
	    arc.padRadius = function(v) {
	      if (!arguments.length) return padRadius;
	      padRadius = v == d3_svg_arcAuto ? d3_svg_arcAuto : d3_functor(v);
	      return arc;
	    };
	    arc.startAngle = function(v) {
	      if (!arguments.length) return startAngle;
	      startAngle = d3_functor(v);
	      return arc;
	    };
	    arc.endAngle = function(v) {
	      if (!arguments.length) return endAngle;
	      endAngle = d3_functor(v);
	      return arc;
	    };
	    arc.padAngle = function(v) {
	      if (!arguments.length) return padAngle;
	      padAngle = d3_functor(v);
	      return arc;
	    };
	    arc.centroid = function() {
	      var r = (+innerRadius.apply(this, arguments) + +outerRadius.apply(this, arguments)) / 2, a = (+startAngle.apply(this, arguments) + +endAngle.apply(this, arguments)) / 2 - halfπ;
	      return [ Math.cos(a) * r, Math.sin(a) * r ];
	    };
	    return arc;
	  };
	  var d3_svg_arcAuto = "auto";
	  function d3_svg_arcInnerRadius(d) {
	    return d.innerRadius;
	  }
	  function d3_svg_arcOuterRadius(d) {
	    return d.outerRadius;
	  }
	  function d3_svg_arcStartAngle(d) {
	    return d.startAngle;
	  }
	  function d3_svg_arcEndAngle(d) {
	    return d.endAngle;
	  }
	  function d3_svg_arcPadAngle(d) {
	    return d && d.padAngle;
	  }
	  function d3_svg_arcSweep(x0, y0, x1, y1) {
	    return (x0 - x1) * y0 - (y0 - y1) * x0 > 0 ? 0 : 1;
	  }
	  function d3_svg_arcCornerTangents(p0, p1, r1, rc, cw) {
	    var x01 = p0[0] - p1[0], y01 = p0[1] - p1[1], lo = (cw ? rc : -rc) / Math.sqrt(x01 * x01 + y01 * y01), ox = lo * y01, oy = -lo * x01, x1 = p0[0] + ox, y1 = p0[1] + oy, x2 = p1[0] + ox, y2 = p1[1] + oy, x3 = (x1 + x2) / 2, y3 = (y1 + y2) / 2, dx = x2 - x1, dy = y2 - y1, d2 = dx * dx + dy * dy, r = r1 - rc, D = x1 * y2 - x2 * y1, d = (dy < 0 ? -1 : 1) * Math.sqrt(Math.max(0, r * r * d2 - D * D)), cx0 = (D * dy - dx * d) / d2, cy0 = (-D * dx - dy * d) / d2, cx1 = (D * dy + dx * d) / d2, cy1 = (-D * dx + dy * d) / d2, dx0 = cx0 - x3, dy0 = cy0 - y3, dx1 = cx1 - x3, dy1 = cy1 - y3;
	    if (dx0 * dx0 + dy0 * dy0 > dx1 * dx1 + dy1 * dy1) cx0 = cx1, cy0 = cy1;
	    return [ [ cx0 - ox, cy0 - oy ], [ cx0 * r1 / r, cy0 * r1 / r ] ];
	  }
	  function d3_svg_line(projection) {
	    var x = d3_geom_pointX, y = d3_geom_pointY, defined = d3_true, interpolate = d3_svg_lineLinear, interpolateKey = interpolate.key, tension = .7;
	    function line(data) {
	      var segments = [], points = [], i = -1, n = data.length, d, fx = d3_functor(x), fy = d3_functor(y);
	      function segment() {
	        segments.push("M", interpolate(projection(points), tension));
	      }
	      while (++i < n) {
	        if (defined.call(this, d = data[i], i)) {
	          points.push([ +fx.call(this, d, i), +fy.call(this, d, i) ]);
	        } else if (points.length) {
	          segment();
	          points = [];
	        }
	      }
	      if (points.length) segment();
	      return segments.length ? segments.join("") : null;
	    }
	    line.x = function(_) {
	      if (!arguments.length) return x;
	      x = _;
	      return line;
	    };
	    line.y = function(_) {
	      if (!arguments.length) return y;
	      y = _;
	      return line;
	    };
	    line.defined = function(_) {
	      if (!arguments.length) return defined;
	      defined = _;
	      return line;
	    };
	    line.interpolate = function(_) {
	      if (!arguments.length) return interpolateKey;
	      if (typeof _ === "function") interpolateKey = interpolate = _; else interpolateKey = (interpolate = d3_svg_lineInterpolators.get(_) || d3_svg_lineLinear).key;
	      return line;
	    };
	    line.tension = function(_) {
	      if (!arguments.length) return tension;
	      tension = _;
	      return line;
	    };
	    return line;
	  }
	  d3.svg.line = function() {
	    return d3_svg_line(d3_identity);
	  };
	  var d3_svg_lineInterpolators = d3.map({
	    linear: d3_svg_lineLinear,
	    "linear-closed": d3_svg_lineLinearClosed,
	    step: d3_svg_lineStep,
	    "step-before": d3_svg_lineStepBefore,
	    "step-after": d3_svg_lineStepAfter,
	    basis: d3_svg_lineBasis,
	    "basis-open": d3_svg_lineBasisOpen,
	    "basis-closed": d3_svg_lineBasisClosed,
	    bundle: d3_svg_lineBundle,
	    cardinal: d3_svg_lineCardinal,
	    "cardinal-open": d3_svg_lineCardinalOpen,
	    "cardinal-closed": d3_svg_lineCardinalClosed,
	    monotone: d3_svg_lineMonotone
	  });
	  d3_svg_lineInterpolators.forEach(function(key, value) {
	    value.key = key;
	    value.closed = /-closed$/.test(key);
	  });
	  function d3_svg_lineLinear(points) {
	    return points.length > 1 ? points.join("L") : points + "Z";
	  }
	  function d3_svg_lineLinearClosed(points) {
	    return points.join("L") + "Z";
	  }
	  function d3_svg_lineStep(points) {
	    var i = 0, n = points.length, p = points[0], path = [ p[0], ",", p[1] ];
	    while (++i < n) path.push("H", (p[0] + (p = points[i])[0]) / 2, "V", p[1]);
	    if (n > 1) path.push("H", p[0]);
	    return path.join("");
	  }
	  function d3_svg_lineStepBefore(points) {
	    var i = 0, n = points.length, p = points[0], path = [ p[0], ",", p[1] ];
	    while (++i < n) path.push("V", (p = points[i])[1], "H", p[0]);
	    return path.join("");
	  }
	  function d3_svg_lineStepAfter(points) {
	    var i = 0, n = points.length, p = points[0], path = [ p[0], ",", p[1] ];
	    while (++i < n) path.push("H", (p = points[i])[0], "V", p[1]);
	    return path.join("");
	  }
	  function d3_svg_lineCardinalOpen(points, tension) {
	    return points.length < 4 ? d3_svg_lineLinear(points) : points[1] + d3_svg_lineHermite(points.slice(1, -1), d3_svg_lineCardinalTangents(points, tension));
	  }
	  function d3_svg_lineCardinalClosed(points, tension) {
	    return points.length < 3 ? d3_svg_lineLinearClosed(points) : points[0] + d3_svg_lineHermite((points.push(points[0]), 
	    points), d3_svg_lineCardinalTangents([ points[points.length - 2] ].concat(points, [ points[1] ]), tension));
	  }
	  function d3_svg_lineCardinal(points, tension) {
	    return points.length < 3 ? d3_svg_lineLinear(points) : points[0] + d3_svg_lineHermite(points, d3_svg_lineCardinalTangents(points, tension));
	  }
	  function d3_svg_lineHermite(points, tangents) {
	    if (tangents.length < 1 || points.length != tangents.length && points.length != tangents.length + 2) {
	      return d3_svg_lineLinear(points);
	    }
	    var quad = points.length != tangents.length, path = "", p0 = points[0], p = points[1], t0 = tangents[0], t = t0, pi = 1;
	    if (quad) {
	      path += "Q" + (p[0] - t0[0] * 2 / 3) + "," + (p[1] - t0[1] * 2 / 3) + "," + p[0] + "," + p[1];
	      p0 = points[1];
	      pi = 2;
	    }
	    if (tangents.length > 1) {
	      t = tangents[1];
	      p = points[pi];
	      pi++;
	      path += "C" + (p0[0] + t0[0]) + "," + (p0[1] + t0[1]) + "," + (p[0] - t[0]) + "," + (p[1] - t[1]) + "," + p[0] + "," + p[1];
	      for (var i = 2; i < tangents.length; i++, pi++) {
	        p = points[pi];
	        t = tangents[i];
	        path += "S" + (p[0] - t[0]) + "," + (p[1] - t[1]) + "," + p[0] + "," + p[1];
	      }
	    }
	    if (quad) {
	      var lp = points[pi];
	      path += "Q" + (p[0] + t[0] * 2 / 3) + "," + (p[1] + t[1] * 2 / 3) + "," + lp[0] + "," + lp[1];
	    }
	    return path;
	  }
	  function d3_svg_lineCardinalTangents(points, tension) {
	    var tangents = [], a = (1 - tension) / 2, p0, p1 = points[0], p2 = points[1], i = 1, n = points.length;
	    while (++i < n) {
	      p0 = p1;
	      p1 = p2;
	      p2 = points[i];
	      tangents.push([ a * (p2[0] - p0[0]), a * (p2[1] - p0[1]) ]);
	    }
	    return tangents;
	  }
	  function d3_svg_lineBasis(points) {
	    if (points.length < 3) return d3_svg_lineLinear(points);
	    var i = 1, n = points.length, pi = points[0], x0 = pi[0], y0 = pi[1], px = [ x0, x0, x0, (pi = points[1])[0] ], py = [ y0, y0, y0, pi[1] ], path = [ x0, ",", y0, "L", d3_svg_lineDot4(d3_svg_lineBasisBezier3, px), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier3, py) ];
	    points.push(points[n - 1]);
	    while (++i <= n) {
	      pi = points[i];
	      px.shift();
	      px.push(pi[0]);
	      py.shift();
	      py.push(pi[1]);
	      d3_svg_lineBasisBezier(path, px, py);
	    }
	    points.pop();
	    path.push("L", pi);
	    return path.join("");
	  }
	  function d3_svg_lineBasisOpen(points) {
	    if (points.length < 4) return d3_svg_lineLinear(points);
	    var path = [], i = -1, n = points.length, pi, px = [ 0 ], py = [ 0 ];
	    while (++i < 3) {
	      pi = points[i];
	      px.push(pi[0]);
	      py.push(pi[1]);
	    }
	    path.push(d3_svg_lineDot4(d3_svg_lineBasisBezier3, px) + "," + d3_svg_lineDot4(d3_svg_lineBasisBezier3, py));
	    --i;
	    while (++i < n) {
	      pi = points[i];
	      px.shift();
	      px.push(pi[0]);
	      py.shift();
	      py.push(pi[1]);
	      d3_svg_lineBasisBezier(path, px, py);
	    }
	    return path.join("");
	  }
	  function d3_svg_lineBasisClosed(points) {
	    var path, i = -1, n = points.length, m = n + 4, pi, px = [], py = [];
	    while (++i < 4) {
	      pi = points[i % n];
	      px.push(pi[0]);
	      py.push(pi[1]);
	    }
	    path = [ d3_svg_lineDot4(d3_svg_lineBasisBezier3, px), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier3, py) ];
	    --i;
	    while (++i < m) {
	      pi = points[i % n];
	      px.shift();
	      px.push(pi[0]);
	      py.shift();
	      py.push(pi[1]);
	      d3_svg_lineBasisBezier(path, px, py);
	    }
	    return path.join("");
	  }
	  function d3_svg_lineBundle(points, tension) {
	    var n = points.length - 1;
	    if (n) {
	      var x0 = points[0][0], y0 = points[0][1], dx = points[n][0] - x0, dy = points[n][1] - y0, i = -1, p, t;
	      while (++i <= n) {
	        p = points[i];
	        t = i / n;
	        p[0] = tension * p[0] + (1 - tension) * (x0 + t * dx);
	        p[1] = tension * p[1] + (1 - tension) * (y0 + t * dy);
	      }
	    }
	    return d3_svg_lineBasis(points);
	  }
	  function d3_svg_lineDot4(a, b) {
	    return a[0] * b[0] + a[1] * b[1] + a[2] * b[2] + a[3] * b[3];
	  }
	  var d3_svg_lineBasisBezier1 = [ 0, 2 / 3, 1 / 3, 0 ], d3_svg_lineBasisBezier2 = [ 0, 1 / 3, 2 / 3, 0 ], d3_svg_lineBasisBezier3 = [ 0, 1 / 6, 2 / 3, 1 / 6 ];
	  function d3_svg_lineBasisBezier(path, x, y) {
	    path.push("C", d3_svg_lineDot4(d3_svg_lineBasisBezier1, x), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier1, y), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier2, x), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier2, y), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier3, x), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier3, y));
	  }
	  function d3_svg_lineSlope(p0, p1) {
	    return (p1[1] - p0[1]) / (p1[0] - p0[0]);
	  }
	  function d3_svg_lineFiniteDifferences(points) {
	    var i = 0, j = points.length - 1, m = [], p0 = points[0], p1 = points[1], d = m[0] = d3_svg_lineSlope(p0, p1);
	    while (++i < j) {
	      m[i] = (d + (d = d3_svg_lineSlope(p0 = p1, p1 = points[i + 1]))) / 2;
	    }
	    m[i] = d;
	    return m;
	  }
	  function d3_svg_lineMonotoneTangents(points) {
	    var tangents = [], d, a, b, s, m = d3_svg_lineFiniteDifferences(points), i = -1, j = points.length - 1;
	    while (++i < j) {
	      d = d3_svg_lineSlope(points[i], points[i + 1]);
	      if (abs(d) < ε) {
	        m[i] = m[i + 1] = 0;
	      } else {
	        a = m[i] / d;
	        b = m[i + 1] / d;
	        s = a * a + b * b;
	        if (s > 9) {
	          s = d * 3 / Math.sqrt(s);
	          m[i] = s * a;
	          m[i + 1] = s * b;
	        }
	      }
	    }
	    i = -1;
	    while (++i <= j) {
	      s = (points[Math.min(j, i + 1)][0] - points[Math.max(0, i - 1)][0]) / (6 * (1 + m[i] * m[i]));
	      tangents.push([ s || 0, m[i] * s || 0 ]);
	    }
	    return tangents;
	  }
	  function d3_svg_lineMonotone(points) {
	    return points.length < 3 ? d3_svg_lineLinear(points) : points[0] + d3_svg_lineHermite(points, d3_svg_lineMonotoneTangents(points));
	  }
	  d3.svg.line.radial = function() {
	    var line = d3_svg_line(d3_svg_lineRadial);
	    line.radius = line.x, delete line.x;
	    line.angle = line.y, delete line.y;
	    return line;
	  };
	  function d3_svg_lineRadial(points) {
	    var point, i = -1, n = points.length, r, a;
	    while (++i < n) {
	      point = points[i];
	      r = point[0];
	      a = point[1] - halfπ;
	      point[0] = r * Math.cos(a);
	      point[1] = r * Math.sin(a);
	    }
	    return points;
	  }
	  function d3_svg_area(projection) {
	    var x0 = d3_geom_pointX, x1 = d3_geom_pointX, y0 = 0, y1 = d3_geom_pointY, defined = d3_true, interpolate = d3_svg_lineLinear, interpolateKey = interpolate.key, interpolateReverse = interpolate, L = "L", tension = .7;
	    function area(data) {
	      var segments = [], points0 = [], points1 = [], i = -1, n = data.length, d, fx0 = d3_functor(x0), fy0 = d3_functor(y0), fx1 = x0 === x1 ? function() {
	        return x;
	      } : d3_functor(x1), fy1 = y0 === y1 ? function() {
	        return y;
	      } : d3_functor(y1), x, y;
	      function segment() {
	        segments.push("M", interpolate(projection(points1), tension), L, interpolateReverse(projection(points0.reverse()), tension), "Z");
	      }
	      while (++i < n) {
	        if (defined.call(this, d = data[i], i)) {
	          points0.push([ x = +fx0.call(this, d, i), y = +fy0.call(this, d, i) ]);
	          points1.push([ +fx1.call(this, d, i), +fy1.call(this, d, i) ]);
	        } else if (points0.length) {
	          segment();
	          points0 = [];
	          points1 = [];
	        }
	      }
	      if (points0.length) segment();
	      return segments.length ? segments.join("") : null;
	    }
	    area.x = function(_) {
	      if (!arguments.length) return x1;
	      x0 = x1 = _;
	      return area;
	    };
	    area.x0 = function(_) {
	      if (!arguments.length) return x0;
	      x0 = _;
	      return area;
	    };
	    area.x1 = function(_) {
	      if (!arguments.length) return x1;
	      x1 = _;
	      return area;
	    };
	    area.y = function(_) {
	      if (!arguments.length) return y1;
	      y0 = y1 = _;
	      return area;
	    };
	    area.y0 = function(_) {
	      if (!arguments.length) return y0;
	      y0 = _;
	      return area;
	    };
	    area.y1 = function(_) {
	      if (!arguments.length) return y1;
	      y1 = _;
	      return area;
	    };
	    area.defined = function(_) {
	      if (!arguments.length) return defined;
	      defined = _;
	      return area;
	    };
	    area.interpolate = function(_) {
	      if (!arguments.length) return interpolateKey;
	      if (typeof _ === "function") interpolateKey = interpolate = _; else interpolateKey = (interpolate = d3_svg_lineInterpolators.get(_) || d3_svg_lineLinear).key;
	      interpolateReverse = interpolate.reverse || interpolate;
	      L = interpolate.closed ? "M" : "L";
	      return area;
	    };
	    area.tension = function(_) {
	      if (!arguments.length) return tension;
	      tension = _;
	      return area;
	    };
	    return area;
	  }
	  d3_svg_lineStepBefore.reverse = d3_svg_lineStepAfter;
	  d3_svg_lineStepAfter.reverse = d3_svg_lineStepBefore;
	  d3.svg.area = function() {
	    return d3_svg_area(d3_identity);
	  };
	  d3.svg.area.radial = function() {
	    var area = d3_svg_area(d3_svg_lineRadial);
	    area.radius = area.x, delete area.x;
	    area.innerRadius = area.x0, delete area.x0;
	    area.outerRadius = area.x1, delete area.x1;
	    area.angle = area.y, delete area.y;
	    area.startAngle = area.y0, delete area.y0;
	    area.endAngle = area.y1, delete area.y1;
	    return area;
	  };
	  d3.svg.chord = function() {
	    var source = d3_source, target = d3_target, radius = d3_svg_chordRadius, startAngle = d3_svg_arcStartAngle, endAngle = d3_svg_arcEndAngle;
	    function chord(d, i) {
	      var s = subgroup(this, source, d, i), t = subgroup(this, target, d, i);
	      return "M" + s.p0 + arc(s.r, s.p1, s.a1 - s.a0) + (equals(s, t) ? curve(s.r, s.p1, s.r, s.p0) : curve(s.r, s.p1, t.r, t.p0) + arc(t.r, t.p1, t.a1 - t.a0) + curve(t.r, t.p1, s.r, s.p0)) + "Z";
	    }
	    function subgroup(self, f, d, i) {
	      var subgroup = f.call(self, d, i), r = radius.call(self, subgroup, i), a0 = startAngle.call(self, subgroup, i) - halfπ, a1 = endAngle.call(self, subgroup, i) - halfπ;
	      return {
	        r: r,
	        a0: a0,
	        a1: a1,
	        p0: [ r * Math.cos(a0), r * Math.sin(a0) ],
	        p1: [ r * Math.cos(a1), r * Math.sin(a1) ]
	      };
	    }
	    function equals(a, b) {
	      return a.a0 == b.a0 && a.a1 == b.a1;
	    }
	    function arc(r, p, a) {
	      return "A" + r + "," + r + " 0 " + +(a > π) + ",1 " + p;
	    }
	    function curve(r0, p0, r1, p1) {
	      return "Q 0,0 " + p1;
	    }
	    chord.radius = function(v) {
	      if (!arguments.length) return radius;
	      radius = d3_functor(v);
	      return chord;
	    };
	    chord.source = function(v) {
	      if (!arguments.length) return source;
	      source = d3_functor(v);
	      return chord;
	    };
	    chord.target = function(v) {
	      if (!arguments.length) return target;
	      target = d3_functor(v);
	      return chord;
	    };
	    chord.startAngle = function(v) {
	      if (!arguments.length) return startAngle;
	      startAngle = d3_functor(v);
	      return chord;
	    };
	    chord.endAngle = function(v) {
	      if (!arguments.length) return endAngle;
	      endAngle = d3_functor(v);
	      return chord;
	    };
	    return chord;
	  };
	  function d3_svg_chordRadius(d) {
	    return d.radius;
	  }
	  d3.svg.diagonal = function() {
	    var source = d3_source, target = d3_target, projection = d3_svg_diagonalProjection;
	    function diagonal(d, i) {
	      var p0 = source.call(this, d, i), p3 = target.call(this, d, i), m = (p0.y + p3.y) / 2, p = [ p0, {
	        x: p0.x,
	        y: m
	      }, {
	        x: p3.x,
	        y: m
	      }, p3 ];
	      p = p.map(projection);
	      return "M" + p[0] + "C" + p[1] + " " + p[2] + " " + p[3];
	    }
	    diagonal.source = function(x) {
	      if (!arguments.length) return source;
	      source = d3_functor(x);
	      return diagonal;
	    };
	    diagonal.target = function(x) {
	      if (!arguments.length) return target;
	      target = d3_functor(x);
	      return diagonal;
	    };
	    diagonal.projection = function(x) {
	      if (!arguments.length) return projection;
	      projection = x;
	      return diagonal;
	    };
	    return diagonal;
	  };
	  function d3_svg_diagonalProjection(d) {
	    return [ d.x, d.y ];
	  }
	  d3.svg.diagonal.radial = function() {
	    var diagonal = d3.svg.diagonal(), projection = d3_svg_diagonalProjection, projection_ = diagonal.projection;
	    diagonal.projection = function(x) {
	      return arguments.length ? projection_(d3_svg_diagonalRadialProjection(projection = x)) : projection;
	    };
	    return diagonal;
	  };
	  function d3_svg_diagonalRadialProjection(projection) {
	    return function() {
	      var d = projection.apply(this, arguments), r = d[0], a = d[1] - halfπ;
	      return [ r * Math.cos(a), r * Math.sin(a) ];
	    };
	  }
	  d3.svg.symbol = function() {
	    var type = d3_svg_symbolType, size = d3_svg_symbolSize;
	    function symbol(d, i) {
	      return (d3_svg_symbols.get(type.call(this, d, i)) || d3_svg_symbolCircle)(size.call(this, d, i));
	    }
	    symbol.type = function(x) {
	      if (!arguments.length) return type;
	      type = d3_functor(x);
	      return symbol;
	    };
	    symbol.size = function(x) {
	      if (!arguments.length) return size;
	      size = d3_functor(x);
	      return symbol;
	    };
	    return symbol;
	  };
	  function d3_svg_symbolSize() {
	    return 64;
	  }
	  function d3_svg_symbolType() {
	    return "circle";
	  }
	  function d3_svg_symbolCircle(size) {
	    var r = Math.sqrt(size / π);
	    return "M0," + r + "A" + r + "," + r + " 0 1,1 0," + -r + "A" + r + "," + r + " 0 1,1 0," + r + "Z";
	  }
	  var d3_svg_symbols = d3.map({
	    circle: d3_svg_symbolCircle,
	    cross: function(size) {
	      var r = Math.sqrt(size / 5) / 2;
	      return "M" + -3 * r + "," + -r + "H" + -r + "V" + -3 * r + "H" + r + "V" + -r + "H" + 3 * r + "V" + r + "H" + r + "V" + 3 * r + "H" + -r + "V" + r + "H" + -3 * r + "Z";
	    },
	    diamond: function(size) {
	      var ry = Math.sqrt(size / (2 * d3_svg_symbolTan30)), rx = ry * d3_svg_symbolTan30;
	      return "M0," + -ry + "L" + rx + ",0" + " 0," + ry + " " + -rx + ",0" + "Z";
	    },
	    square: function(size) {
	      var r = Math.sqrt(size) / 2;
	      return "M" + -r + "," + -r + "L" + r + "," + -r + " " + r + "," + r + " " + -r + "," + r + "Z";
	    },
	    "triangle-down": function(size) {
	      var rx = Math.sqrt(size / d3_svg_symbolSqrt3), ry = rx * d3_svg_symbolSqrt3 / 2;
	      return "M0," + ry + "L" + rx + "," + -ry + " " + -rx + "," + -ry + "Z";
	    },
	    "triangle-up": function(size) {
	      var rx = Math.sqrt(size / d3_svg_symbolSqrt3), ry = rx * d3_svg_symbolSqrt3 / 2;
	      return "M0," + -ry + "L" + rx + "," + ry + " " + -rx + "," + ry + "Z";
	    }
	  });
	  d3.svg.symbolTypes = d3_svg_symbols.keys();
	  var d3_svg_symbolSqrt3 = Math.sqrt(3), d3_svg_symbolTan30 = Math.tan(30 * d3_radians);
	  d3_selectionPrototype.transition = function(name) {
	    var id = d3_transitionInheritId || ++d3_transitionId, ns = d3_transitionNamespace(name), subgroups = [], subgroup, node, transition = d3_transitionInherit || {
	      time: Date.now(),
	      ease: d3_ease_cubicInOut,
	      delay: 0,
	      duration: 250
	    };
	    for (var j = -1, m = this.length; ++j < m; ) {
	      subgroups.push(subgroup = []);
	      for (var group = this[j], i = -1, n = group.length; ++i < n; ) {
	        if (node = group[i]) d3_transitionNode(node, i, ns, id, transition);
	        subgroup.push(node);
	      }
	    }
	    return d3_transition(subgroups, ns, id);
	  };
	  d3_selectionPrototype.interrupt = function(name) {
	    return this.each(name == null ? d3_selection_interrupt : d3_selection_interruptNS(d3_transitionNamespace(name)));
	  };
	  var d3_selection_interrupt = d3_selection_interruptNS(d3_transitionNamespace());
	  function d3_selection_interruptNS(ns) {
	    return function() {
	      var lock, activeId, active;
	      if ((lock = this[ns]) && (active = lock[activeId = lock.active])) {
	        active.timer.c = null;
	        active.timer.t = NaN;
	        if (--lock.count) delete lock[activeId]; else delete this[ns];
	        lock.active += .5;
	        active.event && active.event.interrupt.call(this, this.__data__, active.index);
	      }
	    };
	  }
	  function d3_transition(groups, ns, id) {
	    d3_subclass(groups, d3_transitionPrototype);
	    groups.namespace = ns;
	    groups.id = id;
	    return groups;
	  }
	  var d3_transitionPrototype = [], d3_transitionId = 0, d3_transitionInheritId, d3_transitionInherit;
	  d3_transitionPrototype.call = d3_selectionPrototype.call;
	  d3_transitionPrototype.empty = d3_selectionPrototype.empty;
	  d3_transitionPrototype.node = d3_selectionPrototype.node;
	  d3_transitionPrototype.size = d3_selectionPrototype.size;
	  d3.transition = function(selection, name) {
	    return selection && selection.transition ? d3_transitionInheritId ? selection.transition(name) : selection : d3.selection().transition(selection);
	  };
	  d3.transition.prototype = d3_transitionPrototype;
	  d3_transitionPrototype.select = function(selector) {
	    var id = this.id, ns = this.namespace, subgroups = [], subgroup, subnode, node;
	    selector = d3_selection_selector(selector);
	    for (var j = -1, m = this.length; ++j < m; ) {
	      subgroups.push(subgroup = []);
	      for (var group = this[j], i = -1, n = group.length; ++i < n; ) {
	        if ((node = group[i]) && (subnode = selector.call(node, node.__data__, i, j))) {
	          if ("__data__" in node) subnode.__data__ = node.__data__;
	          d3_transitionNode(subnode, i, ns, id, node[ns][id]);
	          subgroup.push(subnode);
	        } else {
	          subgroup.push(null);
	        }
	      }
	    }
	    return d3_transition(subgroups, ns, id);
	  };
	  d3_transitionPrototype.selectAll = function(selector) {
	    var id = this.id, ns = this.namespace, subgroups = [], subgroup, subnodes, node, subnode, transition;
	    selector = d3_selection_selectorAll(selector);
	    for (var j = -1, m = this.length; ++j < m; ) {
	      for (var group = this[j], i = -1, n = group.length; ++i < n; ) {
	        if (node = group[i]) {
	          transition = node[ns][id];
	          subnodes = selector.call(node, node.__data__, i, j);
	          subgroups.push(subgroup = []);
	          for (var k = -1, o = subnodes.length; ++k < o; ) {
	            if (subnode = subnodes[k]) d3_transitionNode(subnode, k, ns, id, transition);
	            subgroup.push(subnode);
	          }
	        }
	      }
	    }
	    return d3_transition(subgroups, ns, id);
	  };
	  d3_transitionPrototype.filter = function(filter) {
	    var subgroups = [], subgroup, group, node;
	    if (typeof filter !== "function") filter = d3_selection_filter(filter);
	    for (var j = 0, m = this.length; j < m; j++) {
	      subgroups.push(subgroup = []);
	      for (var group = this[j], i = 0, n = group.length; i < n; i++) {
	        if ((node = group[i]) && filter.call(node, node.__data__, i, j)) {
	          subgroup.push(node);
	        }
	      }
	    }
	    return d3_transition(subgroups, this.namespace, this.id);
	  };
	  d3_transitionPrototype.tween = function(name, tween) {
	    var id = this.id, ns = this.namespace;
	    if (arguments.length < 2) return this.node()[ns][id].tween.get(name);
	    return d3_selection_each(this, tween == null ? function(node) {
	      node[ns][id].tween.remove(name);
	    } : function(node) {
	      node[ns][id].tween.set(name, tween);
	    });
	  };
	  function d3_transition_tween(groups, name, value, tween) {
	    var id = groups.id, ns = groups.namespace;
	    return d3_selection_each(groups, typeof value === "function" ? function(node, i, j) {
	      node[ns][id].tween.set(name, tween(value.call(node, node.__data__, i, j)));
	    } : (value = tween(value), function(node) {
	      node[ns][id].tween.set(name, value);
	    }));
	  }
	  d3_transitionPrototype.attr = function(nameNS, value) {
	    if (arguments.length < 2) {
	      for (value in nameNS) this.attr(value, nameNS[value]);
	      return this;
	    }
	    var interpolate = nameNS == "transform" ? d3_interpolateTransform : d3_interpolate, name = d3.ns.qualify(nameNS);
	    function attrNull() {
	      this.removeAttribute(name);
	    }
	    function attrNullNS() {
	      this.removeAttributeNS(name.space, name.local);
	    }
	    function attrTween(b) {
	      return b == null ? attrNull : (b += "", function() {
	        var a = this.getAttribute(name), i;
	        return a !== b && (i = interpolate(a, b), function(t) {
	          this.setAttribute(name, i(t));
	        });
	      });
	    }
	    function attrTweenNS(b) {
	      return b == null ? attrNullNS : (b += "", function() {
	        var a = this.getAttributeNS(name.space, name.local), i;
	        return a !== b && (i = interpolate(a, b), function(t) {
	          this.setAttributeNS(name.space, name.local, i(t));
	        });
	      });
	    }
	    return d3_transition_tween(this, "attr." + nameNS, value, name.local ? attrTweenNS : attrTween);
	  };
	  d3_transitionPrototype.attrTween = function(nameNS, tween) {
	    var name = d3.ns.qualify(nameNS);
	    function attrTween(d, i) {
	      var f = tween.call(this, d, i, this.getAttribute(name));
	      return f && function(t) {
	        this.setAttribute(name, f(t));
	      };
	    }
	    function attrTweenNS(d, i) {
	      var f = tween.call(this, d, i, this.getAttributeNS(name.space, name.local));
	      return f && function(t) {
	        this.setAttributeNS(name.space, name.local, f(t));
	      };
	    }
	    return this.tween("attr." + nameNS, name.local ? attrTweenNS : attrTween);
	  };
	  d3_transitionPrototype.style = function(name, value, priority) {
	    var n = arguments.length;
	    if (n < 3) {
	      if (typeof name !== "string") {
	        if (n < 2) value = "";
	        for (priority in name) this.style(priority, name[priority], value);
	        return this;
	      }
	      priority = "";
	    }
	    function styleNull() {
	      this.style.removeProperty(name);
	    }
	    function styleString(b) {
	      return b == null ? styleNull : (b += "", function() {
	        var a = d3_window(this).getComputedStyle(this, null).getPropertyValue(name), i;
	        return a !== b && (i = d3_interpolate(a, b), function(t) {
	          this.style.setProperty(name, i(t), priority);
	        });
	      });
	    }
	    return d3_transition_tween(this, "style." + name, value, styleString);
	  };
	  d3_transitionPrototype.styleTween = function(name, tween, priority) {
	    if (arguments.length < 3) priority = "";
	    function styleTween(d, i) {
	      var f = tween.call(this, d, i, d3_window(this).getComputedStyle(this, null).getPropertyValue(name));
	      return f && function(t) {
	        this.style.setProperty(name, f(t), priority);
	      };
	    }
	    return this.tween("style." + name, styleTween);
	  };
	  d3_transitionPrototype.text = function(value) {
	    return d3_transition_tween(this, "text", value, d3_transition_text);
	  };
	  function d3_transition_text(b) {
	    if (b == null) b = "";
	    return function() {
	      this.textContent = b;
	    };
	  }
	  d3_transitionPrototype.remove = function() {
	    var ns = this.namespace;
	    return this.each("end.transition", function() {
	      var p;
	      if (this[ns].count < 2 && (p = this.parentNode)) p.removeChild(this);
	    });
	  };
	  d3_transitionPrototype.ease = function(value) {
	    var id = this.id, ns = this.namespace;
	    if (arguments.length < 1) return this.node()[ns][id].ease;
	    if (typeof value !== "function") value = d3.ease.apply(d3, arguments);
	    return d3_selection_each(this, function(node) {
	      node[ns][id].ease = value;
	    });
	  };
	  d3_transitionPrototype.delay = function(value) {
	    var id = this.id, ns = this.namespace;
	    if (arguments.length < 1) return this.node()[ns][id].delay;
	    return d3_selection_each(this, typeof value === "function" ? function(node, i, j) {
	      node[ns][id].delay = +value.call(node, node.__data__, i, j);
	    } : (value = +value, function(node) {
	      node[ns][id].delay = value;
	    }));
	  };
	  d3_transitionPrototype.duration = function(value) {
	    var id = this.id, ns = this.namespace;
	    if (arguments.length < 1) return this.node()[ns][id].duration;
	    return d3_selection_each(this, typeof value === "function" ? function(node, i, j) {
	      node[ns][id].duration = Math.max(1, value.call(node, node.__data__, i, j));
	    } : (value = Math.max(1, value), function(node) {
	      node[ns][id].duration = value;
	    }));
	  };
	  d3_transitionPrototype.each = function(type, listener) {
	    var id = this.id, ns = this.namespace;
	    if (arguments.length < 2) {
	      var inherit = d3_transitionInherit, inheritId = d3_transitionInheritId;
	      try {
	        d3_transitionInheritId = id;
	        d3_selection_each(this, function(node, i, j) {
	          d3_transitionInherit = node[ns][id];
	          type.call(node, node.__data__, i, j);
	        });
	      } finally {
	        d3_transitionInherit = inherit;
	        d3_transitionInheritId = inheritId;
	      }
	    } else {
	      d3_selection_each(this, function(node) {
	        var transition = node[ns][id];
	        (transition.event || (transition.event = d3.dispatch("start", "end", "interrupt"))).on(type, listener);
	      });
	    }
	    return this;
	  };
	  d3_transitionPrototype.transition = function() {
	    var id0 = this.id, id1 = ++d3_transitionId, ns = this.namespace, subgroups = [], subgroup, group, node, transition;
	    for (var j = 0, m = this.length; j < m; j++) {
	      subgroups.push(subgroup = []);
	      for (var group = this[j], i = 0, n = group.length; i < n; i++) {
	        if (node = group[i]) {
	          transition = node[ns][id0];
	          d3_transitionNode(node, i, ns, id1, {
	            time: transition.time,
	            ease: transition.ease,
	            delay: transition.delay + transition.duration,
	            duration: transition.duration
	          });
	        }
	        subgroup.push(node);
	      }
	    }
	    return d3_transition(subgroups, ns, id1);
	  };
	  function d3_transitionNamespace(name) {
	    return name == null ? "__transition__" : "__transition_" + name + "__";
	  }
	  function d3_transitionNode(node, i, ns, id, inherit) {
	    var lock = node[ns] || (node[ns] = {
	      active: 0,
	      count: 0
	    }), transition = lock[id], time, timer, duration, ease, tweens;
	    function schedule(elapsed) {
	      var delay = transition.delay;
	      timer.t = delay + time;
	      if (delay <= elapsed) return start(elapsed - delay);
	      timer.c = start;
	    }
	    function start(elapsed) {
	      var activeId = lock.active, active = lock[activeId];
	      if (active) {
	        active.timer.c = null;
	        active.timer.t = NaN;
	        --lock.count;
	        delete lock[activeId];
	        active.event && active.event.interrupt.call(node, node.__data__, active.index);
	      }
	      for (var cancelId in lock) {
	        if (+cancelId < id) {
	          var cancel = lock[cancelId];
	          cancel.timer.c = null;
	          cancel.timer.t = NaN;
	          --lock.count;
	          delete lock[cancelId];
	        }
	      }
	      timer.c = tick;
	      d3_timer(function() {
	        if (timer.c && tick(elapsed || 1)) {
	          timer.c = null;
	          timer.t = NaN;
	        }
	        return 1;
	      }, 0, time);
	      lock.active = id;
	      transition.event && transition.event.start.call(node, node.__data__, i);
	      tweens = [];
	      transition.tween.forEach(function(key, value) {
	        if (value = value.call(node, node.__data__, i)) {
	          tweens.push(value);
	        }
	      });
	      ease = transition.ease;
	      duration = transition.duration;
	    }
	    function tick(elapsed) {
	      var t = elapsed / duration, e = ease(t), n = tweens.length;
	      while (n > 0) {
	        tweens[--n].call(node, e);
	      }
	      if (t >= 1) {
	        transition.event && transition.event.end.call(node, node.__data__, i);
	        if (--lock.count) delete lock[id]; else delete node[ns];
	        return 1;
	      }
	    }
	    if (!transition) {
	      time = inherit.time;
	      timer = d3_timer(schedule, 0, time);
	      transition = lock[id] = {
	        tween: new d3_Map(),
	        time: time,
	        timer: timer,
	        delay: inherit.delay,
	        duration: inherit.duration,
	        ease: inherit.ease,
	        index: i
	      };
	      inherit = null;
	      ++lock.count;
	    }
	  }
	  d3.svg.axis = function() {
	    var scale = d3.scale.linear(), orient = d3_svg_axisDefaultOrient, innerTickSize = 6, outerTickSize = 6, tickPadding = 3, tickArguments_ = [ 10 ], tickValues = null, tickFormat_;
	    function axis(g) {
	      g.each(function() {
	        var g = d3.select(this);
	        var scale0 = this.__chart__ || scale, scale1 = this.__chart__ = scale.copy();
	        var ticks = tickValues == null ? scale1.ticks ? scale1.ticks.apply(scale1, tickArguments_) : scale1.domain() : tickValues, tickFormat = tickFormat_ == null ? scale1.tickFormat ? scale1.tickFormat.apply(scale1, tickArguments_) : d3_identity : tickFormat_, tick = g.selectAll(".tick").data(ticks, scale1), tickEnter = tick.enter().insert("g", ".domain").attr("class", "tick").style("opacity", ε), tickExit = d3.transition(tick.exit()).style("opacity", ε).remove(), tickUpdate = d3.transition(tick.order()).style("opacity", 1), tickSpacing = Math.max(innerTickSize, 0) + tickPadding, tickTransform;
	        var range = d3_scaleRange(scale1), path = g.selectAll(".domain").data([ 0 ]), pathUpdate = (path.enter().append("path").attr("class", "domain"), 
	        d3.transition(path));
	        tickEnter.append("line");
	        tickEnter.append("text");
	        var lineEnter = tickEnter.select("line"), lineUpdate = tickUpdate.select("line"), text = tick.select("text").text(tickFormat), textEnter = tickEnter.select("text"), textUpdate = tickUpdate.select("text"), sign = orient === "top" || orient === "left" ? -1 : 1, x1, x2, y1, y2;
	        if (orient === "bottom" || orient === "top") {
	          tickTransform = d3_svg_axisX, x1 = "x", y1 = "y", x2 = "x2", y2 = "y2";
	          text.attr("dy", sign < 0 ? "0em" : ".71em").style("text-anchor", "middle");
	          pathUpdate.attr("d", "M" + range[0] + "," + sign * outerTickSize + "V0H" + range[1] + "V" + sign * outerTickSize);
	        } else {
	          tickTransform = d3_svg_axisY, x1 = "y", y1 = "x", x2 = "y2", y2 = "x2";
	          text.attr("dy", ".32em").style("text-anchor", sign < 0 ? "end" : "start");
	          pathUpdate.attr("d", "M" + sign * outerTickSize + "," + range[0] + "H0V" + range[1] + "H" + sign * outerTickSize);
	        }
	        lineEnter.attr(y2, sign * innerTickSize);
	        textEnter.attr(y1, sign * tickSpacing);
	        lineUpdate.attr(x2, 0).attr(y2, sign * innerTickSize);
	        textUpdate.attr(x1, 0).attr(y1, sign * tickSpacing);
	        if (scale1.rangeBand) {
	          var x = scale1, dx = x.rangeBand() / 2;
	          scale0 = scale1 = function(d) {
	            return x(d) + dx;
	          };
	        } else if (scale0.rangeBand) {
	          scale0 = scale1;
	        } else {
	          tickExit.call(tickTransform, scale1, scale0);
	        }
	        tickEnter.call(tickTransform, scale0, scale1);
	        tickUpdate.call(tickTransform, scale1, scale1);
	      });
	    }
	    axis.scale = function(x) {
	      if (!arguments.length) return scale;
	      scale = x;
	      return axis;
	    };
	    axis.orient = function(x) {
	      if (!arguments.length) return orient;
	      orient = x in d3_svg_axisOrients ? x + "" : d3_svg_axisDefaultOrient;
	      return axis;
	    };
	    axis.ticks = function() {
	      if (!arguments.length) return tickArguments_;
	      tickArguments_ = d3_array(arguments);
	      return axis;
	    };
	    axis.tickValues = function(x) {
	      if (!arguments.length) return tickValues;
	      tickValues = x;
	      return axis;
	    };
	    axis.tickFormat = function(x) {
	      if (!arguments.length) return tickFormat_;
	      tickFormat_ = x;
	      return axis;
	    };
	    axis.tickSize = function(x) {
	      var n = arguments.length;
	      if (!n) return innerTickSize;
	      innerTickSize = +x;
	      outerTickSize = +arguments[n - 1];
	      return axis;
	    };
	    axis.innerTickSize = function(x) {
	      if (!arguments.length) return innerTickSize;
	      innerTickSize = +x;
	      return axis;
	    };
	    axis.outerTickSize = function(x) {
	      if (!arguments.length) return outerTickSize;
	      outerTickSize = +x;
	      return axis;
	    };
	    axis.tickPadding = function(x) {
	      if (!arguments.length) return tickPadding;
	      tickPadding = +x;
	      return axis;
	    };
	    axis.tickSubdivide = function() {
	      return arguments.length && axis;
	    };
	    return axis;
	  };
	  var d3_svg_axisDefaultOrient = "bottom", d3_svg_axisOrients = {
	    top: 1,
	    right: 1,
	    bottom: 1,
	    left: 1
	  };
	  function d3_svg_axisX(selection, x0, x1) {
	    selection.attr("transform", function(d) {
	      var v0 = x0(d);
	      return "translate(" + (isFinite(v0) ? v0 : x1(d)) + ",0)";
	    });
	  }
	  function d3_svg_axisY(selection, y0, y1) {
	    selection.attr("transform", function(d) {
	      var v0 = y0(d);
	      return "translate(0," + (isFinite(v0) ? v0 : y1(d)) + ")";
	    });
	  }
	  d3.svg.brush = function() {
	    var event = d3_eventDispatch(brush, "brushstart", "brush", "brushend"), x = null, y = null, xExtent = [ 0, 0 ], yExtent = [ 0, 0 ], xExtentDomain, yExtentDomain, xClamp = true, yClamp = true, resizes = d3_svg_brushResizes[0];
	    function brush(g) {
	      g.each(function() {
	        var g = d3.select(this).style("pointer-events", "all").style("-webkit-tap-highlight-color", "rgba(0,0,0,0)").on("mousedown.brush", brushstart).on("touchstart.brush", brushstart);
	        var background = g.selectAll(".background").data([ 0 ]);
	        background.enter().append("rect").attr("class", "background").style("visibility", "hidden").style("cursor", "crosshair");
	        g.selectAll(".extent").data([ 0 ]).enter().append("rect").attr("class", "extent").style("cursor", "move");
	        var resize = g.selectAll(".resize").data(resizes, d3_identity);
	        resize.exit().remove();
	        resize.enter().append("g").attr("class", function(d) {
	          return "resize " + d;
	        }).style("cursor", function(d) {
	          return d3_svg_brushCursor[d];
	        }).append("rect").attr("x", function(d) {
	          return /[ew]$/.test(d) ? -3 : null;
	        }).attr("y", function(d) {
	          return /^[ns]/.test(d) ? -3 : null;
	        }).attr("width", 6).attr("height", 6).style("visibility", "hidden");
	        resize.style("display", brush.empty() ? "none" : null);
	        var gUpdate = d3.transition(g), backgroundUpdate = d3.transition(background), range;
	        if (x) {
	          range = d3_scaleRange(x);
	          backgroundUpdate.attr("x", range[0]).attr("width", range[1] - range[0]);
	          redrawX(gUpdate);
	        }
	        if (y) {
	          range = d3_scaleRange(y);
	          backgroundUpdate.attr("y", range[0]).attr("height", range[1] - range[0]);
	          redrawY(gUpdate);
	        }
	        redraw(gUpdate);
	      });
	    }
	    brush.event = function(g) {
	      g.each(function() {
	        var event_ = event.of(this, arguments), extent1 = {
	          x: xExtent,
	          y: yExtent,
	          i: xExtentDomain,
	          j: yExtentDomain
	        }, extent0 = this.__chart__ || extent1;
	        this.__chart__ = extent1;
	        if (d3_transitionInheritId) {
	          d3.select(this).transition().each("start.brush", function() {
	            xExtentDomain = extent0.i;
	            yExtentDomain = extent0.j;
	            xExtent = extent0.x;
	            yExtent = extent0.y;
	            event_({
	              type: "brushstart"
	            });
	          }).tween("brush:brush", function() {
	            var xi = d3_interpolateArray(xExtent, extent1.x), yi = d3_interpolateArray(yExtent, extent1.y);
	            xExtentDomain = yExtentDomain = null;
	            return function(t) {
	              xExtent = extent1.x = xi(t);
	              yExtent = extent1.y = yi(t);
	              event_({
	                type: "brush",
	                mode: "resize"
	              });
	            };
	          }).each("end.brush", function() {
	            xExtentDomain = extent1.i;
	            yExtentDomain = extent1.j;
	            event_({
	              type: "brush",
	              mode: "resize"
	            });
	            event_({
	              type: "brushend"
	            });
	          });
	        } else {
	          event_({
	            type: "brushstart"
	          });
	          event_({
	            type: "brush",
	            mode: "resize"
	          });
	          event_({
	            type: "brushend"
	          });
	        }
	      });
	    };
	    function redraw(g) {
	      g.selectAll(".resize").attr("transform", function(d) {
	        return "translate(" + xExtent[+/e$/.test(d)] + "," + yExtent[+/^s/.test(d)] + ")";
	      });
	    }
	    function redrawX(g) {
	      g.select(".extent").attr("x", xExtent[0]);
	      g.selectAll(".extent,.n>rect,.s>rect").attr("width", xExtent[1] - xExtent[0]);
	    }
	    function redrawY(g) {
	      g.select(".extent").attr("y", yExtent[0]);
	      g.selectAll(".extent,.e>rect,.w>rect").attr("height", yExtent[1] - yExtent[0]);
	    }
	    function brushstart() {
	      var target = this, eventTarget = d3.select(d3.event.target), event_ = event.of(target, arguments), g = d3.select(target), resizing = eventTarget.datum(), resizingX = !/^(n|s)$/.test(resizing) && x, resizingY = !/^(e|w)$/.test(resizing) && y, dragging = eventTarget.classed("extent"), dragRestore = d3_event_dragSuppress(target), center, origin = d3.mouse(target), offset;
	      var w = d3.select(d3_window(target)).on("keydown.brush", keydown).on("keyup.brush", keyup);
	      if (d3.event.changedTouches) {
	        w.on("touchmove.brush", brushmove).on("touchend.brush", brushend);
	      } else {
	        w.on("mousemove.brush", brushmove).on("mouseup.brush", brushend);
	      }
	      g.interrupt().selectAll("*").interrupt();
	      if (dragging) {
	        origin[0] = xExtent[0] - origin[0];
	        origin[1] = yExtent[0] - origin[1];
	      } else if (resizing) {
	        var ex = +/w$/.test(resizing), ey = +/^n/.test(resizing);
	        offset = [ xExtent[1 - ex] - origin[0], yExtent[1 - ey] - origin[1] ];
	        origin[0] = xExtent[ex];
	        origin[1] = yExtent[ey];
	      } else if (d3.event.altKey) center = origin.slice();
	      g.style("pointer-events", "none").selectAll(".resize").style("display", null);
	      d3.select("body").style("cursor", eventTarget.style("cursor"));
	      event_({
	        type: "brushstart"
	      });
	      brushmove();
	      function keydown() {
	        if (d3.event.keyCode == 32) {
	          if (!dragging) {
	            center = null;
	            origin[0] -= xExtent[1];
	            origin[1] -= yExtent[1];
	            dragging = 2;
	          }
	          d3_eventPreventDefault();
	        }
	      }
	      function keyup() {
	        if (d3.event.keyCode == 32 && dragging == 2) {
	          origin[0] += xExtent[1];
	          origin[1] += yExtent[1];
	          dragging = 0;
	          d3_eventPreventDefault();
	        }
	      }
	      function brushmove() {
	        var point = d3.mouse(target), moved = false;
	        if (offset) {
	          point[0] += offset[0];
	          point[1] += offset[1];
	        }
	        if (!dragging) {
	          if (d3.event.altKey) {
	            if (!center) center = [ (xExtent[0] + xExtent[1]) / 2, (yExtent[0] + yExtent[1]) / 2 ];
	            origin[0] = xExtent[+(point[0] < center[0])];
	            origin[1] = yExtent[+(point[1] < center[1])];
	          } else center = null;
	        }
	        if (resizingX && move1(point, x, 0)) {
	          redrawX(g);
	          moved = true;
	        }
	        if (resizingY && move1(point, y, 1)) {
	          redrawY(g);
	          moved = true;
	        }
	        if (moved) {
	          redraw(g);
	          event_({
	            type: "brush",
	            mode: dragging ? "move" : "resize"
	          });
	        }
	      }
	      function move1(point, scale, i) {
	        var range = d3_scaleRange(scale), r0 = range[0], r1 = range[1], position = origin[i], extent = i ? yExtent : xExtent, size = extent[1] - extent[0], min, max;
	        if (dragging) {
	          r0 -= position;
	          r1 -= size + position;
	        }
	        min = (i ? yClamp : xClamp) ? Math.max(r0, Math.min(r1, point[i])) : point[i];
	        if (dragging) {
	          max = (min += position) + size;
	        } else {
	          if (center) position = Math.max(r0, Math.min(r1, 2 * center[i] - min));
	          if (position < min) {
	            max = min;
	            min = position;
	          } else {
	            max = position;
	          }
	        }
	        if (extent[0] != min || extent[1] != max) {
	          if (i) yExtentDomain = null; else xExtentDomain = null;
	          extent[0] = min;
	          extent[1] = max;
	          return true;
	        }
	      }
	      function brushend() {
	        brushmove();
	        g.style("pointer-events", "all").selectAll(".resize").style("display", brush.empty() ? "none" : null);
	        d3.select("body").style("cursor", null);
	        w.on("mousemove.brush", null).on("mouseup.brush", null).on("touchmove.brush", null).on("touchend.brush", null).on("keydown.brush", null).on("keyup.brush", null);
	        dragRestore();
	        event_({
	          type: "brushend"
	        });
	      }
	    }
	    brush.x = function(z) {
	      if (!arguments.length) return x;
	      x = z;
	      resizes = d3_svg_brushResizes[!x << 1 | !y];
	      return brush;
	    };
	    brush.y = function(z) {
	      if (!arguments.length) return y;
	      y = z;
	      resizes = d3_svg_brushResizes[!x << 1 | !y];
	      return brush;
	    };
	    brush.clamp = function(z) {
	      if (!arguments.length) return x && y ? [ xClamp, yClamp ] : x ? xClamp : y ? yClamp : null;
	      if (x && y) xClamp = !!z[0], yClamp = !!z[1]; else if (x) xClamp = !!z; else if (y) yClamp = !!z;
	      return brush;
	    };
	    brush.extent = function(z) {
	      var x0, x1, y0, y1, t;
	      if (!arguments.length) {
	        if (x) {
	          if (xExtentDomain) {
	            x0 = xExtentDomain[0], x1 = xExtentDomain[1];
	          } else {
	            x0 = xExtent[0], x1 = xExtent[1];
	            if (x.invert) x0 = x.invert(x0), x1 = x.invert(x1);
	            if (x1 < x0) t = x0, x0 = x1, x1 = t;
	          }
	        }
	        if (y) {
	          if (yExtentDomain) {
	            y0 = yExtentDomain[0], y1 = yExtentDomain[1];
	          } else {
	            y0 = yExtent[0], y1 = yExtent[1];
	            if (y.invert) y0 = y.invert(y0), y1 = y.invert(y1);
	            if (y1 < y0) t = y0, y0 = y1, y1 = t;
	          }
	        }
	        return x && y ? [ [ x0, y0 ], [ x1, y1 ] ] : x ? [ x0, x1 ] : y && [ y0, y1 ];
	      }
	      if (x) {
	        x0 = z[0], x1 = z[1];
	        if (y) x0 = x0[0], x1 = x1[0];
	        xExtentDomain = [ x0, x1 ];
	        if (x.invert) x0 = x(x0), x1 = x(x1);
	        if (x1 < x0) t = x0, x0 = x1, x1 = t;
	        if (x0 != xExtent[0] || x1 != xExtent[1]) xExtent = [ x0, x1 ];
	      }
	      if (y) {
	        y0 = z[0], y1 = z[1];
	        if (x) y0 = y0[1], y1 = y1[1];
	        yExtentDomain = [ y0, y1 ];
	        if (y.invert) y0 = y(y0), y1 = y(y1);
	        if (y1 < y0) t = y0, y0 = y1, y1 = t;
	        if (y0 != yExtent[0] || y1 != yExtent[1]) yExtent = [ y0, y1 ];
	      }
	      return brush;
	    };
	    brush.clear = function() {
	      if (!brush.empty()) {
	        xExtent = [ 0, 0 ], yExtent = [ 0, 0 ];
	        xExtentDomain = yExtentDomain = null;
	      }
	      return brush;
	    };
	    brush.empty = function() {
	      return !!x && xExtent[0] == xExtent[1] || !!y && yExtent[0] == yExtent[1];
	    };
	    return d3.rebind(brush, event, "on");
	  };
	  var d3_svg_brushCursor = {
	    n: "ns-resize",
	    e: "ew-resize",
	    s: "ns-resize",
	    w: "ew-resize",
	    nw: "nwse-resize",
	    ne: "nesw-resize",
	    se: "nwse-resize",
	    sw: "nesw-resize"
	  };
	  var d3_svg_brushResizes = [ [ "n", "e", "s", "w", "nw", "ne", "se", "sw" ], [ "e", "w" ], [ "n", "s" ], [] ];
	  var d3_time_format = d3_time.format = d3_locale_enUS.timeFormat;
	  var d3_time_formatUtc = d3_time_format.utc;
	  var d3_time_formatIso = d3_time_formatUtc("%Y-%m-%dT%H:%M:%S.%LZ");
	  d3_time_format.iso = Date.prototype.toISOString && +new Date("2000-01-01T00:00:00.000Z") ? d3_time_formatIsoNative : d3_time_formatIso;
	  function d3_time_formatIsoNative(date) {
	    return date.toISOString();
	  }
	  d3_time_formatIsoNative.parse = function(string) {
	    var date = new Date(string);
	    return isNaN(date) ? null : date;
	  };
	  d3_time_formatIsoNative.toString = d3_time_formatIso.toString;
	  d3_time.second = d3_time_interval(function(date) {
	    return new d3_date(Math.floor(date / 1e3) * 1e3);
	  }, function(date, offset) {
	    date.setTime(date.getTime() + Math.floor(offset) * 1e3);
	  }, function(date) {
	    return date.getSeconds();
	  });
	  d3_time.seconds = d3_time.second.range;
	  d3_time.seconds.utc = d3_time.second.utc.range;
	  d3_time.minute = d3_time_interval(function(date) {
	    return new d3_date(Math.floor(date / 6e4) * 6e4);
	  }, function(date, offset) {
	    date.setTime(date.getTime() + Math.floor(offset) * 6e4);
	  }, function(date) {
	    return date.getMinutes();
	  });
	  d3_time.minutes = d3_time.minute.range;
	  d3_time.minutes.utc = d3_time.minute.utc.range;
	  d3_time.hour = d3_time_interval(function(date) {
	    var timezone = date.getTimezoneOffset() / 60;
	    return new d3_date((Math.floor(date / 36e5 - timezone) + timezone) * 36e5);
	  }, function(date, offset) {
	    date.setTime(date.getTime() + Math.floor(offset) * 36e5);
	  }, function(date) {
	    return date.getHours();
	  });
	  d3_time.hours = d3_time.hour.range;
	  d3_time.hours.utc = d3_time.hour.utc.range;
	  d3_time.month = d3_time_interval(function(date) {
	    date = d3_time.day(date);
	    date.setDate(1);
	    return date;
	  }, function(date, offset) {
	    date.setMonth(date.getMonth() + offset);
	  }, function(date) {
	    return date.getMonth();
	  });
	  d3_time.months = d3_time.month.range;
	  d3_time.months.utc = d3_time.month.utc.range;
	  function d3_time_scale(linear, methods, format) {
	    function scale(x) {
	      return linear(x);
	    }
	    scale.invert = function(x) {
	      return d3_time_scaleDate(linear.invert(x));
	    };
	    scale.domain = function(x) {
	      if (!arguments.length) return linear.domain().map(d3_time_scaleDate);
	      linear.domain(x);
	      return scale;
	    };
	    function tickMethod(extent, count) {
	      var span = extent[1] - extent[0], target = span / count, i = d3.bisect(d3_time_scaleSteps, target);
	      return i == d3_time_scaleSteps.length ? [ methods.year, d3_scale_linearTickRange(extent.map(function(d) {
	        return d / 31536e6;
	      }), count)[2] ] : !i ? [ d3_time_scaleMilliseconds, d3_scale_linearTickRange(extent, count)[2] ] : methods[target / d3_time_scaleSteps[i - 1] < d3_time_scaleSteps[i] / target ? i - 1 : i];
	    }
	    scale.nice = function(interval, skip) {
	      var domain = scale.domain(), extent = d3_scaleExtent(domain), method = interval == null ? tickMethod(extent, 10) : typeof interval === "number" && tickMethod(extent, interval);
	      if (method) interval = method[0], skip = method[1];
	      function skipped(date) {
	        return !isNaN(date) && !interval.range(date, d3_time_scaleDate(+date + 1), skip).length;
	      }
	      return scale.domain(d3_scale_nice(domain, skip > 1 ? {
	        floor: function(date) {
	          while (skipped(date = interval.floor(date))) date = d3_time_scaleDate(date - 1);
	          return date;
	        },
	        ceil: function(date) {
	          while (skipped(date = interval.ceil(date))) date = d3_time_scaleDate(+date + 1);
	          return date;
	        }
	      } : interval));
	    };
	    scale.ticks = function(interval, skip) {
	      var extent = d3_scaleExtent(scale.domain()), method = interval == null ? tickMethod(extent, 10) : typeof interval === "number" ? tickMethod(extent, interval) : !interval.range && [ {
	        range: interval
	      }, skip ];
	      if (method) interval = method[0], skip = method[1];
	      return interval.range(extent[0], d3_time_scaleDate(+extent[1] + 1), skip < 1 ? 1 : skip);
	    };
	    scale.tickFormat = function() {
	      return format;
	    };
	    scale.copy = function() {
	      return d3_time_scale(linear.copy(), methods, format);
	    };
	    return d3_scale_linearRebind(scale, linear);
	  }
	  function d3_time_scaleDate(t) {
	    return new Date(t);
	  }
	  var d3_time_scaleSteps = [ 1e3, 5e3, 15e3, 3e4, 6e4, 3e5, 9e5, 18e5, 36e5, 108e5, 216e5, 432e5, 864e5, 1728e5, 6048e5, 2592e6, 7776e6, 31536e6 ];
	  var d3_time_scaleLocalMethods = [ [ d3_time.second, 1 ], [ d3_time.second, 5 ], [ d3_time.second, 15 ], [ d3_time.second, 30 ], [ d3_time.minute, 1 ], [ d3_time.minute, 5 ], [ d3_time.minute, 15 ], [ d3_time.minute, 30 ], [ d3_time.hour, 1 ], [ d3_time.hour, 3 ], [ d3_time.hour, 6 ], [ d3_time.hour, 12 ], [ d3_time.day, 1 ], [ d3_time.day, 2 ], [ d3_time.week, 1 ], [ d3_time.month, 1 ], [ d3_time.month, 3 ], [ d3_time.year, 1 ] ];
	  var d3_time_scaleLocalFormat = d3_time_format.multi([ [ ".%L", function(d) {
	    return d.getMilliseconds();
	  } ], [ ":%S", function(d) {
	    return d.getSeconds();
	  } ], [ "%I:%M", function(d) {
	    return d.getMinutes();
	  } ], [ "%I %p", function(d) {
	    return d.getHours();
	  } ], [ "%a %d", function(d) {
	    return d.getDay() && d.getDate() != 1;
	  } ], [ "%b %d", function(d) {
	    return d.getDate() != 1;
	  } ], [ "%B", function(d) {
	    return d.getMonth();
	  } ], [ "%Y", d3_true ] ]);
	  var d3_time_scaleMilliseconds = {
	    range: function(start, stop, step) {
	      return d3.range(Math.ceil(start / step) * step, +stop, step).map(d3_time_scaleDate);
	    },
	    floor: d3_identity,
	    ceil: d3_identity
	  };
	  d3_time_scaleLocalMethods.year = d3_time.year;
	  d3_time.scale = function() {
	    return d3_time_scale(d3.scale.linear(), d3_time_scaleLocalMethods, d3_time_scaleLocalFormat);
	  };
	  var d3_time_scaleUtcMethods = d3_time_scaleLocalMethods.map(function(m) {
	    return [ m[0].utc, m[1] ];
	  });
	  var d3_time_scaleUtcFormat = d3_time_formatUtc.multi([ [ ".%L", function(d) {
	    return d.getUTCMilliseconds();
	  } ], [ ":%S", function(d) {
	    return d.getUTCSeconds();
	  } ], [ "%I:%M", function(d) {
	    return d.getUTCMinutes();
	  } ], [ "%I %p", function(d) {
	    return d.getUTCHours();
	  } ], [ "%a %d", function(d) {
	    return d.getUTCDay() && d.getUTCDate() != 1;
	  } ], [ "%b %d", function(d) {
	    return d.getUTCDate() != 1;
	  } ], [ "%B", function(d) {
	    return d.getUTCMonth();
	  } ], [ "%Y", d3_true ] ]);
	  d3_time_scaleUtcMethods.year = d3_time.year.utc;
	  d3_time.scale.utc = function() {
	    return d3_time_scale(d3.scale.linear(), d3_time_scaleUtcMethods, d3_time_scaleUtcFormat);
	  };
	  d3.text = d3_xhrType(function(request) {
	    return request.responseText;
	  });
	  d3.json = function(url, callback) {
	    return d3_xhr(url, "application/json", d3_json, callback);
	  };
	  function d3_json(request) {
	    return JSON.parse(request.responseText);
	  }
	  d3.html = function(url, callback) {
	    return d3_xhr(url, "text/html", d3_html, callback);
	  };
	  function d3_html(request) {
	    var range = d3_document.createRange();
	    range.selectNode(d3_document.body);
	    return range.createContextualFragment(request.responseText);
	  }
	  d3.xml = d3_xhrType(function(request) {
	    return request.responseXML;
	  });
	  if (true) this.d3 = d3, !(__WEBPACK_AMD_DEFINE_FACTORY__ = (d3), __WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ? (__WEBPACK_AMD_DEFINE_FACTORY__.call(exports, __webpack_require__, exports, module)) : __WEBPACK_AMD_DEFINE_FACTORY__), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)); else if (typeof module === "object" && module.exports) module.exports = d3; else this.d3 = d3;
	}();

/***/ },
/* 3 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = {
	  version: '__VERSION__',
	  dataflow: __webpack_require__(4),
	  parse: __webpack_require__(52),
	  scene: {
	    Bounder: __webpack_require__(152),
	    Builder: __webpack_require__(150),
	    Encoder: __webpack_require__(151),
	    GroupBuilder: __webpack_require__(149),
	    visit: __webpack_require__(154)
	  },
	  transforms: __webpack_require__(102),
	  Transform: __webpack_require__(104),
	  BatchTransform: __webpack_require__(108),
	  Parameter: __webpack_require__(105),
	  schema: __webpack_require__(160),
	  config: __webpack_require__(155),
	  util: __webpack_require__(57),
	  logging: __webpack_require__(8),
	  debug: __webpack_require__(8).debug
	};


/***/ },
/* 4 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = {
	  ChangeSet:    __webpack_require__(5),
	  Collector:    __webpack_require__(7),
	  DataSource:   __webpack_require__(11),
	  Dependencies: __webpack_require__(6),
	  Graph:        __webpack_require__(49),
	  Node:         __webpack_require__(10),
	  Signal:       __webpack_require__(51),
	  Tuple:        __webpack_require__(9),
	  debug:        __webpack_require__(8).debug
	};


/***/ },
/* 5 */
/***/ function(module, exports, __webpack_require__) {

	var DEPS = __webpack_require__(6).ALL;
	
	function create(cs, reflow) {
	  var out = {};
	  copy(cs, out);
	
	  out.add = [];
	  out.mod = [];
	  out.rem = [];
	
	  out.reflow = reflow;
	
	  return out;
	}
	
	function copy(a, b) {
	  b.stamp = a ? a.stamp : 0;
	  b.sort  = a ? a.sort  : null;
	  b.facet = a ? a.facet : null;
	  b.trans = a ? a.trans : null;
	  b.dirty = a ? a.dirty : [];
	  b.request = a ? a.request : null;
	  for (var d, i=0, n=DEPS.length; i<n; ++i) {
	    b[d=DEPS[i]] = a ? a[d] : {};
	  }
	}
	
	module.exports = {
	  create: create,
	  copy: copy
	};

/***/ },
/* 6 */
/***/ function(module, exports) {

	var deps = module.exports = {
	  ALL: ['data', 'fields', 'scales', 'signals']
	};
	deps.ALL.forEach(function(k) { deps[k.toUpperCase()] = k; });


/***/ },
/* 7 */
/***/ function(module, exports, __webpack_require__) {

	var log = __webpack_require__(8),
	    Tuple = __webpack_require__(9),
	    Base = __webpack_require__(10).prototype,
	    ChangeSet = __webpack_require__(5);
	
	function Collector(graph) {
	  Base.init.call(this, graph);
	  this._data = [];
	  this.router(true).collector(true);
	}
	
	var prototype = (Collector.prototype = Object.create(Base));
	prototype.constructor = Collector;
	
	prototype.data = function() {
	  return this._data;
	};
	
	prototype.evaluate = function(input) {
	  log.debug(input, ["collecting"]);
	
	  // Create a new output changeset to prevent pollution when the Graph
	  // merges reflow and regular changesets.
	  var output = ChangeSet.create(input);
	
	  if (input.rem.length) {
	    this._data = Tuple.idFilter(this._data, input.rem);
	    output.rem = input.rem.slice(0);
	  }
	
	  if (input.add.length) {
	    this._data = this._data.concat(input.add);
	    output.add = input.add.slice(0);
	  }
	
	  if (input.mod.length) {
	    output.mod = input.mod.slice(0);
	  }
	
	  if (input.sort) {
	    this._data.sort(input.sort);
	  }
	
	  if (input.reflow) {
	    output.mod = output.mod.concat(
	      Tuple.idFilter(this._data, output.add, output.mod, output.rem));
	    output.reflow = false;
	  }
	
	  return output;
	};
	
	module.exports = Collector;

/***/ },
/* 8 */
/***/ function(module, exports) {

	var ts = Date.now();
	
	function write(msg) {
	  console.log('[Vega Log]', msg);
	}
	
	function error(msg) {
	  console.error('[Vega Err]', msg);
	}
	
	function debug(input, args) {
	  if (!debug.enable) return;
	  var log = Function.prototype.bind.call(console.log, console);
	  var state = {
	    prevTime:  Date.now() - ts,
	    stamp: input.stamp
	  };
	
	  if (input.add) {
	    state.add = input.add.length;
	    state.mod = input.mod.length;
	    state.rem = input.rem.length;
	    state.reflow = !!input.reflow;
	  }
	
	  log.apply(console, (args.push(JSON.stringify(state)), args));
	  ts = Date.now();
	}
	
	module.exports = {
	  log:   write,
	  error: error,
	  debug: (debug.enable = false, debug)
	};


/***/ },
/* 9 */
/***/ function(module, exports) {

	var tupleID = 0;
	
	function ingest(datum) {
	  datum = (datum === Object(datum)) ? datum : {data: datum};
	  datum._id = ++tupleID;
	  if (datum._prev) datum._prev = null;
	  return datum;
	}
	
	function idMap(a, ids) {
	  ids = ids || {};
	  for (var i=0, n=a.length; i<n; ++i) {
	    ids[a[i]._id] = 1;
	  }
	  return ids;
	}
	
	function copy(t, c) {
	  c = c || {};
	  for (var k in t) {
	    if (k !== '_prev' && k !== '_id') c[k] = t[k];
	  }
	  return c;
	}
	
	module.exports = {
	  ingest: ingest,
	  idMap: idMap,
	
	  derive: function(d) {
	    return ingest(copy(d));
	  },
	
	  rederive: function(d, t) {
	    return copy(d, t);
	  },
	
	  set: function(t, k, v) {
	    return t[k] === v ? 0 : (t[k] = v, 1);
	  },
	
	  prev: function(t) {
	    return t._prev || t;
	  },
	
	  prev_init: function(t) {
	    if (!t._prev) { t._prev = {_id: t._id}; }
	  },
	
	  prev_update: function(t) {
	    var p = t._prev, k, v;
	    if (p) for (k in t) {
	      if (k !== '_prev' && k !== '_id') {
	        p[k] = ((v=t[k]) instanceof Object && v._prev) ? v._prev : v;
	      }
	    }
	  },
	
	  reset: function() { tupleID = 0; },
	
	  idFilter: function(data) {
	    var ids = {};
	    for (var i=arguments.length; --i>0;) {
	      idMap(arguments[i], ids);
	    }
	    return data.filter(function(x) { return !ids[x._id]; });
	  }
	};


/***/ },
/* 10 */
/***/ function(module, exports, __webpack_require__) {

	var DEPS = __webpack_require__(6).ALL,
	    nodeID = 0;
	
	function Node(graph) {
	  if (graph) this.init(graph);
	}
	
	var Flags = Node.Flags = {
	  Router:     0x01, // Responsible for propagating tuples, cannot be skipped.
	  Collector:  0x02, // Holds a materialized dataset, pulse node to reflow.
	  Produces:   0x04, // Produces new tuples. 
	  Mutates:    0x08, // Sets properties of incoming tuples.
	  Reflows:    0x10, // Forwards a reflow pulse.
	  Batch:      0x20  // Performs batch data processing, needs collector.
	};
	
	var prototype = Node.prototype;
	
	prototype.init = function(graph) {
	  this._id = ++nodeID;
	  this._graph = graph;
	  this._rank  = graph.rank(); // Topological sort by rank
	  this._qrank = null; // Rank when enqueued for propagation
	  this._stamp = 0;    // Last stamp seen
	
	  this._listeners = [];
	  this._listeners._ids = {}; // To prevent duplicate listeners
	
	  // Initialize dependencies.
	  this._deps = {};
	  for (var i=0, n=DEPS.length; i<n; ++i) {
	    this._deps[DEPS[i]] = [];
	  }
	
	  // Initialize status flags.
	  this._flags = 0;
	
	  return this;
	};
	
	prototype.rank = function() {
	  return this._rank;
	};
	
	prototype.rerank = function() {
	  var g = this._graph, 
	      q = [this],
	      cur;
	
	  while (q.length) {
	    cur = q.shift();
	    cur._rank = g.rank();
	    q.unshift.apply(q, cur.listeners());
	  }
	
	  return this;
	};
	
	prototype.qrank = function(/* set */) {
	  if (!arguments.length) return this._qrank;
	  return (this._qrank = this._rank, this);
	};
	
	prototype.last = function(stamp) { 
	  if (!arguments.length) return this._stamp;
	  return (this._stamp = stamp, this);
	};
	
	// -- status flags ---
	
	prototype._setf = function(v, b) {
	  if (b) { this._flags |= v; } else { this._flags &= ~v; }
	  return this;
	};
	
	prototype.router = function(state) {
	  if (!arguments.length) return (this._flags & Flags.Router);
	  return this._setf(Flags.Router, state);
	};
	
	prototype.collector = function(state) {
	  if (!arguments.length) return (this._flags & Flags.Collector);
	  return this._setf(Flags.Collector, state);
	};
	
	prototype.produces = function(state) {
	  if (!arguments.length) return (this._flags & Flags.Produces);
	  return this._setf(Flags.Produces, state);
	};
	
	prototype.mutates = function(state) {
	  if (!arguments.length) return (this._flags & Flags.Mutates);
	  return this._setf(Flags.Mutates, state);
	};
	
	prototype.reflows = function(state) {
	  if (!arguments.length) return (this._flags & Flags.Reflows);
	  return this._setf(Flags.Reflows, state);
	};
	
	prototype.batch = function(state) {
	  if (!arguments.length) return (this._flags & Flags.Batch);
	  return this._setf(Flags.Batch, state);
	};
	
	prototype.dependency = function(type, deps) {
	  var d = this._deps[type],
	      n = d._names || (d._names = {});  // To prevent dupe deps
	
	  // Get dependencies of the given type
	  if (arguments.length === 1) {
	    return d;
	  }
	
	  if (deps === null) {
	    // Clear dependencies of the given type
	    d.splice(0, d.length);
	    d._names = {};
	  } else if (!Array.isArray(deps)) {
	    // Separate this case to avoid cost of array creation
	    if (n[deps]) return this;
	    d.push(deps);
	    n[deps] = 1;
	  } else {
	    for (var i=0, len=deps.length, dep; i<len; ++i) {
	      dep = deps[i];
	      if (n[dep]) continue;
	      d.push(dep);
	      n[dep] = 1;
	    }
	  }
	
	  return this;
	};
	
	prototype.listeners = function() {
	  return this._listeners;
	};
	
	prototype.addListener = function(l) {
	  if (!(l instanceof Node)) {
	    throw Error('Listener is not a Node');
	  }
	  if (this._listeners._ids[l._id]) return this;
	
	  this._listeners.push(l);
	  this._listeners._ids[l._id] = 1;
	  if (this._rank > l._rank) {
	    l.rerank();
	  }
	
	  return this;
	};
	
	prototype.removeListener = function(l) {
	  if (!this._listeners._ids[l._id]) return false;
	  
	  var idx = this._listeners.indexOf(l),
	      b = idx >= 0;
	
	  if (b) {
	    this._listeners.splice(idx, 1);
	    this._listeners._ids[l._id] = null;
	  }
	  return b;
	};
	
	prototype.disconnect = function() {
	  this._listeners = [];
	  this._listeners._ids = {};
	};
	
	// Evaluate this dataflow node for the current pulse.
	// Subclasses should override to perform custom processing.
	prototype.evaluate = function(pulse) {
	  return pulse;
	};
	
	// Should this node be re-evaluated for the current pulse?
	// Searches pulse to see if any dependencies have updated.
	prototype.reevaluate = function(pulse) {
	  var prop, dep, i, n, j, m;
	
	  for (i=0, n=DEPS.length; i<n; ++i) {
	    prop = DEPS[i];
	    dep = this._deps[prop];
	    for (j=0, m=dep.length; j<m; ++j) {
	      if (pulse[prop][dep[j]]) return true;
	    }
	  }
	
	  return false;
	};
	
	Node.reset = function() { nodeID = 0; };
	
	module.exports = Node;


/***/ },
/* 11 */
/***/ function(module, exports, __webpack_require__) {

	var dl = __webpack_require__(12),
	    log = __webpack_require__(8),
	    ChangeSet = __webpack_require__(5),
	    Collector = __webpack_require__(7),
	    Tuple = __webpack_require__(9),
	    Node = __webpack_require__(10); // jshint ignore:line
	
	function DataSource(graph, name, facet) {
	  this._graph = graph;
	  this._name = name;
	  this._data = [];
	  this._source = null;
	  this._facet  = facet;
	  this._input  = ChangeSet.create();
	  this._output = null; // Output changeset
	  this._indexes = {};
	  this._indexFields = [];
	
	  this._inputNode  = null;
	  this._outputNode = null;
	  this._pipeline  = null; // Pipeline of transformations.
	  this._collector = null; // Collector to materialize output of pipeline.
	  this._mutates = false;  // Does any pipeline operator mutate tuples?
	}
	
	var prototype = DataSource.prototype;
	
	prototype.name = function(name) {
	  if (!arguments.length) return this._name;
	  return (this._name = name, this);
	};
	
	prototype.source = function(src) {
	  if (!arguments.length) return this._source;
	  return (this._source = this._graph.data(src));
	};
	
	prototype.insert = function(tuples) {
	  this._input.add = this._input.add.concat(tuples.map(Tuple.ingest));
	  return this;
	};
	
	prototype.remove = function(where) {
	  var remove = this._data.filter(where);
	  this._input.rem = this._input.rem.concat(remove);
	  return this;
	};
	
	prototype.update = function(where, field, func) {
	  var mod = this._input.mod,
	      ids = Tuple.idMap(mod);
	
	  this._input.fields[field] = 1;
	
	  this._data.filter(where).forEach(function(x) {
	    var prev = x[field],
	        next = func(x);
	    if (prev !== next) {
	      Tuple.set(x, field, next);
	      if (ids[x._id] !== 1) {
	        mod.push(x);
	        ids[x._id] = 1;
	      }
	    }
	  });
	
	  return this;
	};
	
	prototype.values = function(data) {
	  if (!arguments.length) return this._collector.data();
	
	  // Replace backing data
	  this._input.rem = this._data.slice();
	  if (data) { this.insert(data); }
	  return this;
	};
	
	prototype.mutates = function(m) {
	  if (!arguments.length) return this._mutates;
	  this._mutates = this._mutates || m;
	  return this;
	};
	
	prototype.last = function() {
	  return this._output;
	};
	
	prototype.fire = function(input) {
	  if (input) this._input = input;
	  this._graph.propagate(this._input, this._pipeline[0]);
	  return this;
	};
	
	prototype.pipeline = function(pipeline) {
	  if (!arguments.length) return this._pipeline;
	
	  var graph = this._graph,
	      status;
	
	  pipeline.unshift(this._inputNode = DataSourceInput(this));
	  status = graph.preprocess(pipeline);
	
	  if (status.router) {
	    pipeline.push(status.collector = new Collector(graph));
	  }
	
	  pipeline.push(this._outputNode = DataSourceOutput(this));
	  this._collector = status.collector;
	  this._mutates = !!status.mutates;
	  graph.connect(this._pipeline = pipeline);
	
	  return this;
	};
	
	prototype.synchronize = function() {
	  this._graph.synchronize(this._pipeline);
	  return this;
	};
	
	prototype.getIndex = function(field) {
	  var data = this.values(),
	      indexes = this._indexes,
	      fields  = this._indexFields,
	      f = dl.$(field),
	      index, i, len, value;
	
	  if (!indexes[field]) {
	    indexes[field] = index = {};
	    fields.push(field);
	    for (i=0, len=data.length; i<len; ++i) {
	      value = f(data[i]);
	      index[value] = (index[value] || 0) + 1;
	      Tuple.prev_init(data[i]);
	    }
	  }
	  return indexes[field];
	};
	
	prototype.listener = function() {
	  return DataSourceListener(this).addListener(this._inputNode);
	};
	
	prototype.addListener = function(l) {
	  if (l instanceof DataSource) {
	    this._collector.addListener(l.listener());
	  } else {
	    this._outputNode.addListener(l);
	  }
	  return this;
	};
	
	prototype.removeListener = function(l) {
	  this._outputNode.removeListener(l);
	};
	
	prototype.listeners = function(ds) {
	  return (ds ? this._collector : this._outputNode).listeners();
	};
	
	// Input node applies the datasource's delta, and propagates it to
	// the rest of the pipeline. It receives touches to reflow data.
	function DataSourceInput(ds) {
	  var input = new Node(ds._graph)
	    .router(true)
	    .collector(true);
	
	  input.data = function() {
	    return ds._data;
	  };
	
	  input.evaluate = function(input) {
	    log.debug(input, ['input', ds._name]);
	
	    var delta = ds._input,
	        out = ChangeSet.create(input), f;
	
	    // Delta might contain fields updated through API
	    for (f in delta.fields) {
	      out.fields[f] = 1;
	    }
	
	    // update data
	    if (delta.rem.length) {
	      ds._data = Tuple.idFilter(ds._data, delta.rem);
	    }
	
	    if (delta.add.length) {
	      ds._data = ds._data.concat(delta.add);
	    }
	
	    if (delta.sort) {
	      ds._data.sort(delta.sort);
	    }
	
	    // if reflowing, add any other tuples not currently in changeset
	    if (input.reflow) {
	      delta.mod = delta.mod.concat(
	        Tuple.idFilter(ds._data, delta.add, delta.mod, delta.rem));
	    }
	
	    // reset change list
	    ds._input = ChangeSet.create();
	
	    out.add = delta.add;
	    out.mod = delta.mod;
	    out.rem = delta.rem;
	    out.facet = ds._facet;
	    return out;
	  };
	
	  return input;
	}
	
	// Output node captures the last changeset seen by this datasource
	// (needed for joins and builds) and materializes any nested data.
	// If this datasource is faceted, materializes the values in the facet.
	function DataSourceOutput(ds) {
	  var output = new Node(ds._graph)
	    .router(true)
	    .reflows(true)
	    .collector(true);
	
	  function updateIndices(pulse) {
	    var fields = ds._indexFields,
	        i, j, f, key, index, value;
	
	    for (i=0; i<fields.length; ++i) {
	      key = fields[i];
	      index = ds._indexes[key];
	      f = dl.$(key);
	
	      for (j=0; j<pulse.add.length; ++j) {
	        value = f(pulse.add[j]);
	        Tuple.prev_init(pulse.add[j]);
	        index[value] = (index[value] || 0) + 1;
	      }
	      for (j=0; j<pulse.rem.length; ++j) {
	        value = f(pulse.rem[j]);
	        index[value] = (index[value] || 0) - 1;
	      }
	      for (j=0; j<pulse.mod.length; ++j) {
	        value = f(pulse.mod[j]._prev);
	        index[value] = (index[value] || 0) - 1;
	        value = f(pulse.mod[j]);
	        index[value] = (index[value] || 0) + 1;
	      }
	    }
	  }
	
	  output.data = function() {
	    return ds._collector ? ds._collector.data() : ds._data;
	  };
	
	  output.evaluate = function(input) {
	    log.debug(input, ['output', ds._name]);
	
	    updateIndices(input);
	    var out = ChangeSet.create(input, true);
	
	    if (ds._facet) {
	      ds._facet.values = ds.values();
	      input.facet = null;
	    }
	
	    ds._output = input;
	    out.data[ds._name] = 1;
	    return out;
	  };
	
	  return output;
	}
	
	function DataSourceListener(ds) {
	  var l = new Node(ds._graph).router(true);
	
	  l.evaluate = function(input) {
	    // Tuple derivation carries a cost. So only derive if the pipeline has
	    // operators that mutate, and thus would override the source data.
	    if (ds.mutates()) {
	      var map = ds._srcMap || (ds._srcMap = {}), // to propagate tuples correctly
	          output = ChangeSet.create(input);
	
	      output.add = input.add.map(function(t) {
	        return (map[t._id] = Tuple.derive(t));
	      });
	
	      output.mod = input.mod.map(function(t) {
	        return Tuple.rederive(t, map[t._id]);
	      });
	
	      output.rem = input.rem.map(function(t) {
	        var o = map[t._id];
	        return (map[t._id] = null, o);
	      });
	
	      return (ds._input = output);
	    } else {
	      return (ds._input = input);
	    }
	  };
	
	  return l;
	}
	
	module.exports = DataSource;


/***/ },
/* 12 */
/***/ function(module, exports, __webpack_require__) {

	var util = __webpack_require__(13);
	
	var dl = {
	  version:    '__VERSION__',
	  load:       __webpack_require__(18),
	  read:       __webpack_require__(23),
	  type:       __webpack_require__(24),
	  Aggregator: __webpack_require__(36),
	  groupby:    __webpack_require__(41),
	  bins:       __webpack_require__(42),
	  $bin:       __webpack_require__(44).$bin,
	  histogram:  __webpack_require__(44).histogram,
	  format:     __webpack_require__(32),
	  template:   __webpack_require__(45),
	  time:       __webpack_require__(43)
	};
	
	util.extend(dl, util);
	util.extend(dl, __webpack_require__(46));
	util.extend(dl, __webpack_require__(39));
	util.extend(dl, __webpack_require__(38));
	util.extend(dl, __webpack_require__(47));
	util.extend(dl.format, __webpack_require__(48));
	
	// backwards-compatible, deprecated API
	// will remove in the future
	dl.print = {
	  table:   dl.format.table,
	  summary: dl.format.summary
	};
	
	module.exports = dl;


/***/ },
/* 13 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Buffer) {var u = module.exports;
	
	// utility functions
	
	var FNAME = '__name__';
	
	u.namedfunc = function(name, f) { return (f[FNAME] = name, f); };
	
	u.name = function(f) { return f==null ? null : f[FNAME]; };
	
	u.identity = function(x) { return x; };
	
	u.true = u.namedfunc('true', function() { return true; });
	
	u.false = u.namedfunc('false', function() { return false; });
	
	u.duplicate = function(obj) {
	  return JSON.parse(JSON.stringify(obj));
	};
	
	u.equal = function(a, b) {
	  return JSON.stringify(a) === JSON.stringify(b);
	};
	
	u.extend = function(obj) {
	  for (var x, name, i=1, len=arguments.length; i<len; ++i) {
	    x = arguments[i];
	    for (name in x) { obj[name] = x[name]; }
	  }
	  return obj;
	};
	
	u.length = function(x) {
	  return x != null && x.length != null ? x.length : null;
	};
	
	u.keys = function(x) {
	  var keys = [], k;
	  for (k in x) keys.push(k);
	  return keys;
	};
	
	u.vals = function(x) {
	  var vals = [], k;
	  for (k in x) vals.push(x[k]);
	  return vals;
	};
	
	u.toMap = function(list, f) {
	  return (f = u.$(f)) ?
	    list.reduce(function(obj, x) { return (obj[f(x)] = 1, obj); }, {}) :
	    list.reduce(function(obj, x) { return (obj[x] = 1, obj); }, {});
	};
	
	u.keystr = function(values) {
	  // use to ensure consistent key generation across modules
	  var n = values.length;
	  if (!n) return '';
	  for (var s=String(values[0]), i=1; i<n; ++i) {
	    s += '|' + String(values[i]);
	  }
	  return s;
	};
	
	// type checking functions
	
	var toString = Object.prototype.toString;
	
	u.isObject = function(obj) {
	  return obj === Object(obj);
	};
	
	u.isFunction = function(obj) {
	  return toString.call(obj) === '[object Function]';
	};
	
	u.isString = function(obj) {
	  return typeof value === 'string' || toString.call(obj) === '[object String]';
	};
	
	u.isArray = Array.isArray || function(obj) {
	  return toString.call(obj) === '[object Array]';
	};
	
	u.isNumber = function(obj) {
	  return typeof obj === 'number' || toString.call(obj) === '[object Number]';
	};
	
	u.isBoolean = function(obj) {
	  return obj === true || obj === false || toString.call(obj) == '[object Boolean]';
	};
	
	u.isDate = function(obj) {
	  return toString.call(obj) === '[object Date]';
	};
	
	u.isValid = function(obj) {
	  return obj != null && obj === obj;
	};
	
	u.isBuffer = (typeof Buffer === 'function' && Buffer.isBuffer) || u.false;
	
	// type coercion functions
	
	u.number = function(s) {
	  return s == null || s === '' ? null : +s;
	};
	
	u.boolean = function(s) {
	  return s == null || s === '' ? null : s==='false' ? false : !!s;
	};
	
	// parse a date with optional d3.time-format format
	u.date = function(s, format) {
	  var d = format ? format : Date;
	  return s == null || s === '' ? null : d.parse(s);
	};
	
	u.array = function(x) {
	  return x != null ? (u.isArray(x) ? x : [x]) : [];
	};
	
	u.str = function(x) {
	  return u.isArray(x) ? '[' + x.map(u.str) + ']'
	    : u.isObject(x) || u.isString(x) ?
	      // Output valid JSON and JS source strings.
	      // See http://timelessrepo.com/json-isnt-a-javascript-subset
	      JSON.stringify(x).replace('\u2028','\\u2028').replace('\u2029', '\\u2029')
	    : x;
	};
	
	// data access functions
	
	var field_re = /\[(.*?)\]|[^.\[]+/g;
	
	u.field = function(f) {
	  return String(f).match(field_re).map(function(d) {
	    return d[0] !== '[' ? d :
	      d[1] !== "'" && d[1] !== '"' ? d.slice(1, -1) :
	      d.slice(2, -2).replace(/\\(["'])/g, '$1');
	  });
	};
	
	u.accessor = function(f) {
	  /* jshint evil: true */
	  return f==null || u.isFunction(f) ? f :
	    u.namedfunc(f, Function('x', 'return x[' + u.field(f).map(u.str).join('][') + '];'));
	};
	
	// short-cut for accessor
	u.$ = u.accessor;
	
	u.mutator = function(f) {
	  var s;
	  return u.isString(f) && (s=u.field(f)).length > 1 ?
	    function(x, v) {
	      for (var i=0; i<s.length-1; ++i) x = x[s[i]];
	      x[s[i]] = v;
	    } :
	    function(x, v) { x[f] = v; };
	};
	
	
	u.$func = function(name, op) {
	  return function(f) {
	    f = u.$(f) || u.identity;
	    var n = name + (u.name(f) ? '_'+u.name(f) : '');
	    return u.namedfunc(n, function(d) { return op(f(d)); });
	  };
	};
	
	u.$valid  = u.$func('valid', u.isValid);
	u.$length = u.$func('length', u.length);
	
	u.$in = function(f, values) {
	  f = u.$(f);
	  var map = u.isArray(values) ? u.toMap(values) : values;
	  return function(d) { return !!map[f(d)]; };
	};
	
	// comparison / sorting functions
	
	u.comparator = function(sort) {
	  var sign = [];
	  if (sort === undefined) sort = [];
	  sort = u.array(sort).map(function(f) {
	    var s = 1;
	    if      (f[0] === '-') { s = -1; f = f.slice(1); }
	    else if (f[0] === '+') { s = +1; f = f.slice(1); }
	    sign.push(s);
	    return u.accessor(f);
	  });
	  return function(a,b) {
	    var i, n, f, x, y;
	    for (i=0, n=sort.length; i<n; ++i) {
	      f = sort[i]; x = f(a); y = f(b);
	      if (x < y) return -1 * sign[i];
	      if (x > y) return sign[i];
	    }
	    return 0;
	  };
	};
	
	u.cmp = function(a, b) {
	  if (a < b) {
	    return -1;
	  } else if (a > b) {
	    return 1;
	  } else if (a >= b) {
	    return 0;
	  } else if (a === null) {
	    return -1;
	  } else if (b === null) {
	    return 1;
	  }
	  return NaN;
	};
	
	u.numcmp = function(a, b) { return a - b; };
	
	u.stablesort = function(array, sortBy, keyFn) {
	  var indices = array.reduce(function(idx, v, i) {
	    return (idx[keyFn(v)] = i, idx);
	  }, {});
	
	  array.sort(function(a, b) {
	    var sa = sortBy(a),
	        sb = sortBy(b);
	    return sa < sb ? -1 : sa > sb ? 1
	         : (indices[keyFn(a)] - indices[keyFn(b)]);
	  });
	
	  return array;
	};
	
	// permutes an array using a Knuth shuffle
	u.permute = function(a) {
	  var m = a.length,
	      swap,
	      i;
	
	  while (m) {
	    i = Math.floor(Math.random() * m--);
	    swap = a[m];
	    a[m] = a[i];
	    a[i] = swap;
	  }
	};
	
	// string functions
	
	u.pad = function(s, length, pos, padchar) {
	  padchar = padchar || " ";
	  var d = length - s.length;
	  if (d <= 0) return s;
	  switch (pos) {
	    case 'left':
	      return strrep(d, padchar) + s;
	    case 'middle':
	    case 'center':
	      return strrep(Math.floor(d/2), padchar) +
	         s + strrep(Math.ceil(d/2), padchar);
	    default:
	      return s + strrep(d, padchar);
	  }
	};
	
	function strrep(n, str) {
	  var s = "", i;
	  for (i=0; i<n; ++i) s += str;
	  return s;
	}
	
	u.truncate = function(s, length, pos, word, ellipsis) {
	  var len = s.length;
	  if (len <= length) return s;
	  ellipsis = ellipsis !== undefined ? String(ellipsis) : '\u2026';
	  var l = Math.max(0, length - ellipsis.length);
	
	  switch (pos) {
	    case 'left':
	      return ellipsis + (word ? truncateOnWord(s,l,1) : s.slice(len-l));
	    case 'middle':
	    case 'center':
	      var l1 = Math.ceil(l/2), l2 = Math.floor(l/2);
	      return (word ? truncateOnWord(s,l1) : s.slice(0,l1)) +
	        ellipsis + (word ? truncateOnWord(s,l2,1) : s.slice(len-l2));
	    default:
	      return (word ? truncateOnWord(s,l) : s.slice(0,l)) + ellipsis;
	  }
	};
	
	function truncateOnWord(s, len, rev) {
	  var cnt = 0, tok = s.split(truncate_word_re);
	  if (rev) {
	    s = (tok = tok.reverse())
	      .filter(function(w) { cnt += w.length; return cnt <= len; })
	      .reverse();
	  } else {
	    s = tok.filter(function(w) { cnt += w.length; return cnt <= len; });
	  }
	  return s.length ? s.join('').trim() : tok[0].slice(0, len);
	}
	
	var truncate_word_re = /([\u0009\u000A\u000B\u000C\u000D\u0020\u00A0\u1680\u180E\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u2028\u2029\u3000\uFEFF])/;
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(14).Buffer))

/***/ },
/* 14 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Buffer, global) {/*!
	 * The buffer module from node.js, for the browser.
	 *
	 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
	 * @license  MIT
	 */
	/* eslint-disable no-proto */
	
	'use strict'
	
	var base64 = __webpack_require__(15)
	var ieee754 = __webpack_require__(16)
	var isArray = __webpack_require__(17)
	
	exports.Buffer = Buffer
	exports.SlowBuffer = SlowBuffer
	exports.INSPECT_MAX_BYTES = 50
	Buffer.poolSize = 8192 // not used by this implementation
	
	var rootParent = {}
	
	/**
	 * If `Buffer.TYPED_ARRAY_SUPPORT`:
	 *   === true    Use Uint8Array implementation (fastest)
	 *   === false   Use Object implementation (most compatible, even IE6)
	 *
	 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
	 * Opera 11.6+, iOS 4.2+.
	 *
	 * Due to various browser bugs, sometimes the Object implementation will be used even
	 * when the browser supports typed arrays.
	 *
	 * Note:
	 *
	 *   - Firefox 4-29 lacks support for adding new properties to `Uint8Array` instances,
	 *     See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438.
	 *
	 *   - Safari 5-7 lacks support for changing the `Object.prototype.constructor` property
	 *     on objects.
	 *
	 *   - Chrome 9-10 is missing the `TypedArray.prototype.subarray` function.
	 *
	 *   - IE10 has a broken `TypedArray.prototype.subarray` function which returns arrays of
	 *     incorrect length in some situations.
	
	 * We detect these buggy browsers and set `Buffer.TYPED_ARRAY_SUPPORT` to `false` so they
	 * get the Object implementation, which is slower but behaves correctly.
	 */
	Buffer.TYPED_ARRAY_SUPPORT = global.TYPED_ARRAY_SUPPORT !== undefined
	  ? global.TYPED_ARRAY_SUPPORT
	  : typedArraySupport()
	
	function typedArraySupport () {
	  function Bar () {}
	  try {
	    var arr = new Uint8Array(1)
	    arr.foo = function () { return 42 }
	    arr.constructor = Bar
	    return arr.foo() === 42 && // typed array instances can be augmented
	        arr.constructor === Bar && // constructor can be set
	        typeof arr.subarray === 'function' && // chrome 9-10 lack `subarray`
	        arr.subarray(1, 1).byteLength === 0 // ie10 has broken `subarray`
	  } catch (e) {
	    return false
	  }
	}
	
	function kMaxLength () {
	  return Buffer.TYPED_ARRAY_SUPPORT
	    ? 0x7fffffff
	    : 0x3fffffff
	}
	
	/**
	 * Class: Buffer
	 * =============
	 *
	 * The Buffer constructor returns instances of `Uint8Array` that are augmented
	 * with function properties for all the node `Buffer` API functions. We use
	 * `Uint8Array` so that square bracket notation works as expected -- it returns
	 * a single octet.
	 *
	 * By augmenting the instances, we can avoid modifying the `Uint8Array`
	 * prototype.
	 */
	function Buffer (arg) {
	  if (!(this instanceof Buffer)) {
	    // Avoid going through an ArgumentsAdaptorTrampoline in the common case.
	    if (arguments.length > 1) return new Buffer(arg, arguments[1])
	    return new Buffer(arg)
	  }
	
	  if (!Buffer.TYPED_ARRAY_SUPPORT) {
	    this.length = 0
	    this.parent = undefined
	  }
	
	  // Common case.
	  if (typeof arg === 'number') {
	    return fromNumber(this, arg)
	  }
	
	  // Slightly less common case.
	  if (typeof arg === 'string') {
	    return fromString(this, arg, arguments.length > 1 ? arguments[1] : 'utf8')
	  }
	
	  // Unusual.
	  return fromObject(this, arg)
	}
	
	function fromNumber (that, length) {
	  that = allocate(that, length < 0 ? 0 : checked(length) | 0)
	  if (!Buffer.TYPED_ARRAY_SUPPORT) {
	    for (var i = 0; i < length; i++) {
	      that[i] = 0
	    }
	  }
	  return that
	}
	
	function fromString (that, string, encoding) {
	  if (typeof encoding !== 'string' || encoding === '') encoding = 'utf8'
	
	  // Assumption: byteLength() return value is always < kMaxLength.
	  var length = byteLength(string, encoding) | 0
	  that = allocate(that, length)
	
	  that.write(string, encoding)
	  return that
	}
	
	function fromObject (that, object) {
	  if (Buffer.isBuffer(object)) return fromBuffer(that, object)
	
	  if (isArray(object)) return fromArray(that, object)
	
	  if (object == null) {
	    throw new TypeError('must start with number, buffer, array or string')
	  }
	
	  if (typeof ArrayBuffer !== 'undefined') {
	    if (object.buffer instanceof ArrayBuffer) {
	      return fromTypedArray(that, object)
	    }
	    if (object instanceof ArrayBuffer) {
	      return fromArrayBuffer(that, object)
	    }
	  }
	
	  if (object.length) return fromArrayLike(that, object)
	
	  return fromJsonObject(that, object)
	}
	
	function fromBuffer (that, buffer) {
	  var length = checked(buffer.length) | 0
	  that = allocate(that, length)
	  buffer.copy(that, 0, 0, length)
	  return that
	}
	
	function fromArray (that, array) {
	  var length = checked(array.length) | 0
	  that = allocate(that, length)
	  for (var i = 0; i < length; i += 1) {
	    that[i] = array[i] & 255
	  }
	  return that
	}
	
	// Duplicate of fromArray() to keep fromArray() monomorphic.
	function fromTypedArray (that, array) {
	  var length = checked(array.length) | 0
	  that = allocate(that, length)
	  // Truncating the elements is probably not what people expect from typed
	  // arrays with BYTES_PER_ELEMENT > 1 but it's compatible with the behavior
	  // of the old Buffer constructor.
	  for (var i = 0; i < length; i += 1) {
	    that[i] = array[i] & 255
	  }
	  return that
	}
	
	function fromArrayBuffer (that, array) {
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    // Return an augmented `Uint8Array` instance, for best performance
	    array.byteLength
	    that = Buffer._augment(new Uint8Array(array))
	  } else {
	    // Fallback: Return an object instance of the Buffer class
	    that = fromTypedArray(that, new Uint8Array(array))
	  }
	  return that
	}
	
	function fromArrayLike (that, array) {
	  var length = checked(array.length) | 0
	  that = allocate(that, length)
	  for (var i = 0; i < length; i += 1) {
	    that[i] = array[i] & 255
	  }
	  return that
	}
	
	// Deserialize { type: 'Buffer', data: [1,2,3,...] } into a Buffer object.
	// Returns a zero-length buffer for inputs that don't conform to the spec.
	function fromJsonObject (that, object) {
	  var array
	  var length = 0
	
	  if (object.type === 'Buffer' && isArray(object.data)) {
	    array = object.data
	    length = checked(array.length) | 0
	  }
	  that = allocate(that, length)
	
	  for (var i = 0; i < length; i += 1) {
	    that[i] = array[i] & 255
	  }
	  return that
	}
	
	if (Buffer.TYPED_ARRAY_SUPPORT) {
	  Buffer.prototype.__proto__ = Uint8Array.prototype
	  Buffer.__proto__ = Uint8Array
	} else {
	  // pre-set for values that may exist in the future
	  Buffer.prototype.length = undefined
	  Buffer.prototype.parent = undefined
	}
	
	function allocate (that, length) {
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    // Return an augmented `Uint8Array` instance, for best performance
	    that = Buffer._augment(new Uint8Array(length))
	    that.__proto__ = Buffer.prototype
	  } else {
	    // Fallback: Return an object instance of the Buffer class
	    that.length = length
	    that._isBuffer = true
	  }
	
	  var fromPool = length !== 0 && length <= Buffer.poolSize >>> 1
	  if (fromPool) that.parent = rootParent
	
	  return that
	}
	
	function checked (length) {
	  // Note: cannot use `length < kMaxLength` here because that fails when
	  // length is NaN (which is otherwise coerced to zero.)
	  if (length >= kMaxLength()) {
	    throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
	                         'size: 0x' + kMaxLength().toString(16) + ' bytes')
	  }
	  return length | 0
	}
	
	function SlowBuffer (subject, encoding) {
	  if (!(this instanceof SlowBuffer)) return new SlowBuffer(subject, encoding)
	
	  var buf = new Buffer(subject, encoding)
	  delete buf.parent
	  return buf
	}
	
	Buffer.isBuffer = function isBuffer (b) {
	  return !!(b != null && b._isBuffer)
	}
	
	Buffer.compare = function compare (a, b) {
	  if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
	    throw new TypeError('Arguments must be Buffers')
	  }
	
	  if (a === b) return 0
	
	  var x = a.length
	  var y = b.length
	
	  var i = 0
	  var len = Math.min(x, y)
	  while (i < len) {
	    if (a[i] !== b[i]) break
	
	    ++i
	  }
	
	  if (i !== len) {
	    x = a[i]
	    y = b[i]
	  }
	
	  if (x < y) return -1
	  if (y < x) return 1
	  return 0
	}
	
	Buffer.isEncoding = function isEncoding (encoding) {
	  switch (String(encoding).toLowerCase()) {
	    case 'hex':
	    case 'utf8':
	    case 'utf-8':
	    case 'ascii':
	    case 'binary':
	    case 'base64':
	    case 'raw':
	    case 'ucs2':
	    case 'ucs-2':
	    case 'utf16le':
	    case 'utf-16le':
	      return true
	    default:
	      return false
	  }
	}
	
	Buffer.concat = function concat (list, length) {
	  if (!isArray(list)) throw new TypeError('list argument must be an Array of Buffers.')
	
	  if (list.length === 0) {
	    return new Buffer(0)
	  }
	
	  var i
	  if (length === undefined) {
	    length = 0
	    for (i = 0; i < list.length; i++) {
	      length += list[i].length
	    }
	  }
	
	  var buf = new Buffer(length)
	  var pos = 0
	  for (i = 0; i < list.length; i++) {
	    var item = list[i]
	    item.copy(buf, pos)
	    pos += item.length
	  }
	  return buf
	}
	
	function byteLength (string, encoding) {
	  if (typeof string !== 'string') string = '' + string
	
	  var len = string.length
	  if (len === 0) return 0
	
	  // Use a for loop to avoid recursion
	  var loweredCase = false
	  for (;;) {
	    switch (encoding) {
	      case 'ascii':
	      case 'binary':
	      // Deprecated
	      case 'raw':
	      case 'raws':
	        return len
	      case 'utf8':
	      case 'utf-8':
	        return utf8ToBytes(string).length
	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return len * 2
	      case 'hex':
	        return len >>> 1
	      case 'base64':
	        return base64ToBytes(string).length
	      default:
	        if (loweredCase) return utf8ToBytes(string).length // assume utf8
	        encoding = ('' + encoding).toLowerCase()
	        loweredCase = true
	    }
	  }
	}
	Buffer.byteLength = byteLength
	
	function slowToString (encoding, start, end) {
	  var loweredCase = false
	
	  start = start | 0
	  end = end === undefined || end === Infinity ? this.length : end | 0
	
	  if (!encoding) encoding = 'utf8'
	  if (start < 0) start = 0
	  if (end > this.length) end = this.length
	  if (end <= start) return ''
	
	  while (true) {
	    switch (encoding) {
	      case 'hex':
	        return hexSlice(this, start, end)
	
	      case 'utf8':
	      case 'utf-8':
	        return utf8Slice(this, start, end)
	
	      case 'ascii':
	        return asciiSlice(this, start, end)
	
	      case 'binary':
	        return binarySlice(this, start, end)
	
	      case 'base64':
	        return base64Slice(this, start, end)
	
	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return utf16leSlice(this, start, end)
	
	      default:
	        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
	        encoding = (encoding + '').toLowerCase()
	        loweredCase = true
	    }
	  }
	}
	
	Buffer.prototype.toString = function toString () {
	  var length = this.length | 0
	  if (length === 0) return ''
	  if (arguments.length === 0) return utf8Slice(this, 0, length)
	  return slowToString.apply(this, arguments)
	}
	
	Buffer.prototype.equals = function equals (b) {
	  if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer')
	  if (this === b) return true
	  return Buffer.compare(this, b) === 0
	}
	
	Buffer.prototype.inspect = function inspect () {
	  var str = ''
	  var max = exports.INSPECT_MAX_BYTES
	  if (this.length > 0) {
	    str = this.toString('hex', 0, max).match(/.{2}/g).join(' ')
	    if (this.length > max) str += ' ... '
	  }
	  return '<Buffer ' + str + '>'
	}
	
	Buffer.prototype.compare = function compare (b) {
	  if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer')
	  if (this === b) return 0
	  return Buffer.compare(this, b)
	}
	
	Buffer.prototype.indexOf = function indexOf (val, byteOffset) {
	  if (byteOffset > 0x7fffffff) byteOffset = 0x7fffffff
	  else if (byteOffset < -0x80000000) byteOffset = -0x80000000
	  byteOffset >>= 0
	
	  if (this.length === 0) return -1
	  if (byteOffset >= this.length) return -1
	
	  // Negative offsets start from the end of the buffer
	  if (byteOffset < 0) byteOffset = Math.max(this.length + byteOffset, 0)
	
	  if (typeof val === 'string') {
	    if (val.length === 0) return -1 // special case: looking for empty string always fails
	    return String.prototype.indexOf.call(this, val, byteOffset)
	  }
	  if (Buffer.isBuffer(val)) {
	    return arrayIndexOf(this, val, byteOffset)
	  }
	  if (typeof val === 'number') {
	    if (Buffer.TYPED_ARRAY_SUPPORT && Uint8Array.prototype.indexOf === 'function') {
	      return Uint8Array.prototype.indexOf.call(this, val, byteOffset)
	    }
	    return arrayIndexOf(this, [ val ], byteOffset)
	  }
	
	  function arrayIndexOf (arr, val, byteOffset) {
	    var foundIndex = -1
	    for (var i = 0; byteOffset + i < arr.length; i++) {
	      if (arr[byteOffset + i] === val[foundIndex === -1 ? 0 : i - foundIndex]) {
	        if (foundIndex === -1) foundIndex = i
	        if (i - foundIndex + 1 === val.length) return byteOffset + foundIndex
	      } else {
	        foundIndex = -1
	      }
	    }
	    return -1
	  }
	
	  throw new TypeError('val must be string, number or Buffer')
	}
	
	// `get` is deprecated
	Buffer.prototype.get = function get (offset) {
	  console.log('.get() is deprecated. Access using array indexes instead.')
	  return this.readUInt8(offset)
	}
	
	// `set` is deprecated
	Buffer.prototype.set = function set (v, offset) {
	  console.log('.set() is deprecated. Access using array indexes instead.')
	  return this.writeUInt8(v, offset)
	}
	
	function hexWrite (buf, string, offset, length) {
	  offset = Number(offset) || 0
	  var remaining = buf.length - offset
	  if (!length) {
	    length = remaining
	  } else {
	    length = Number(length)
	    if (length > remaining) {
	      length = remaining
	    }
	  }
	
	  // must be an even number of digits
	  var strLen = string.length
	  if (strLen % 2 !== 0) throw new Error('Invalid hex string')
	
	  if (length > strLen / 2) {
	    length = strLen / 2
	  }
	  for (var i = 0; i < length; i++) {
	    var parsed = parseInt(string.substr(i * 2, 2), 16)
	    if (isNaN(parsed)) throw new Error('Invalid hex string')
	    buf[offset + i] = parsed
	  }
	  return i
	}
	
	function utf8Write (buf, string, offset, length) {
	  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)
	}
	
	function asciiWrite (buf, string, offset, length) {
	  return blitBuffer(asciiToBytes(string), buf, offset, length)
	}
	
	function binaryWrite (buf, string, offset, length) {
	  return asciiWrite(buf, string, offset, length)
	}
	
	function base64Write (buf, string, offset, length) {
	  return blitBuffer(base64ToBytes(string), buf, offset, length)
	}
	
	function ucs2Write (buf, string, offset, length) {
	  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)
	}
	
	Buffer.prototype.write = function write (string, offset, length, encoding) {
	  // Buffer#write(string)
	  if (offset === undefined) {
	    encoding = 'utf8'
	    length = this.length
	    offset = 0
	  // Buffer#write(string, encoding)
	  } else if (length === undefined && typeof offset === 'string') {
	    encoding = offset
	    length = this.length
	    offset = 0
	  // Buffer#write(string, offset[, length][, encoding])
	  } else if (isFinite(offset)) {
	    offset = offset | 0
	    if (isFinite(length)) {
	      length = length | 0
	      if (encoding === undefined) encoding = 'utf8'
	    } else {
	      encoding = length
	      length = undefined
	    }
	  // legacy write(string, encoding, offset, length) - remove in v0.13
	  } else {
	    var swap = encoding
	    encoding = offset
	    offset = length | 0
	    length = swap
	  }
	
	  var remaining = this.length - offset
	  if (length === undefined || length > remaining) length = remaining
	
	  if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
	    throw new RangeError('attempt to write outside buffer bounds')
	  }
	
	  if (!encoding) encoding = 'utf8'
	
	  var loweredCase = false
	  for (;;) {
	    switch (encoding) {
	      case 'hex':
	        return hexWrite(this, string, offset, length)
	
	      case 'utf8':
	      case 'utf-8':
	        return utf8Write(this, string, offset, length)
	
	      case 'ascii':
	        return asciiWrite(this, string, offset, length)
	
	      case 'binary':
	        return binaryWrite(this, string, offset, length)
	
	      case 'base64':
	        // Warning: maxLength not taken into account in base64Write
	        return base64Write(this, string, offset, length)
	
	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return ucs2Write(this, string, offset, length)
	
	      default:
	        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
	        encoding = ('' + encoding).toLowerCase()
	        loweredCase = true
	    }
	  }
	}
	
	Buffer.prototype.toJSON = function toJSON () {
	  return {
	    type: 'Buffer',
	    data: Array.prototype.slice.call(this._arr || this, 0)
	  }
	}
	
	function base64Slice (buf, start, end) {
	  if (start === 0 && end === buf.length) {
	    return base64.fromByteArray(buf)
	  } else {
	    return base64.fromByteArray(buf.slice(start, end))
	  }
	}
	
	function utf8Slice (buf, start, end) {
	  end = Math.min(buf.length, end)
	  var res = []
	
	  var i = start
	  while (i < end) {
	    var firstByte = buf[i]
	    var codePoint = null
	    var bytesPerSequence = (firstByte > 0xEF) ? 4
	      : (firstByte > 0xDF) ? 3
	      : (firstByte > 0xBF) ? 2
	      : 1
	
	    if (i + bytesPerSequence <= end) {
	      var secondByte, thirdByte, fourthByte, tempCodePoint
	
	      switch (bytesPerSequence) {
	        case 1:
	          if (firstByte < 0x80) {
	            codePoint = firstByte
	          }
	          break
	        case 2:
	          secondByte = buf[i + 1]
	          if ((secondByte & 0xC0) === 0x80) {
	            tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F)
	            if (tempCodePoint > 0x7F) {
	              codePoint = tempCodePoint
	            }
	          }
	          break
	        case 3:
	          secondByte = buf[i + 1]
	          thirdByte = buf[i + 2]
	          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
	            tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F)
	            if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
	              codePoint = tempCodePoint
	            }
	          }
	          break
	        case 4:
	          secondByte = buf[i + 1]
	          thirdByte = buf[i + 2]
	          fourthByte = buf[i + 3]
	          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
	            tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F)
	            if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
	              codePoint = tempCodePoint
	            }
	          }
	      }
	    }
	
	    if (codePoint === null) {
	      // we did not generate a valid codePoint so insert a
	      // replacement char (U+FFFD) and advance only 1 byte
	      codePoint = 0xFFFD
	      bytesPerSequence = 1
	    } else if (codePoint > 0xFFFF) {
	      // encode to utf16 (surrogate pair dance)
	      codePoint -= 0x10000
	      res.push(codePoint >>> 10 & 0x3FF | 0xD800)
	      codePoint = 0xDC00 | codePoint & 0x3FF
	    }
	
	    res.push(codePoint)
	    i += bytesPerSequence
	  }
	
	  return decodeCodePointsArray(res)
	}
	
	// Based on http://stackoverflow.com/a/22747272/680742, the browser with
	// the lowest limit is Chrome, with 0x10000 args.
	// We go 1 magnitude less, for safety
	var MAX_ARGUMENTS_LENGTH = 0x1000
	
	function decodeCodePointsArray (codePoints) {
	  var len = codePoints.length
	  if (len <= MAX_ARGUMENTS_LENGTH) {
	    return String.fromCharCode.apply(String, codePoints) // avoid extra slice()
	  }
	
	  // Decode in chunks to avoid "call stack size exceeded".
	  var res = ''
	  var i = 0
	  while (i < len) {
	    res += String.fromCharCode.apply(
	      String,
	      codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
	    )
	  }
	  return res
	}
	
	function asciiSlice (buf, start, end) {
	  var ret = ''
	  end = Math.min(buf.length, end)
	
	  for (var i = start; i < end; i++) {
	    ret += String.fromCharCode(buf[i] & 0x7F)
	  }
	  return ret
	}
	
	function binarySlice (buf, start, end) {
	  var ret = ''
	  end = Math.min(buf.length, end)
	
	  for (var i = start; i < end; i++) {
	    ret += String.fromCharCode(buf[i])
	  }
	  return ret
	}
	
	function hexSlice (buf, start, end) {
	  var len = buf.length
	
	  if (!start || start < 0) start = 0
	  if (!end || end < 0 || end > len) end = len
	
	  var out = ''
	  for (var i = start; i < end; i++) {
	    out += toHex(buf[i])
	  }
	  return out
	}
	
	function utf16leSlice (buf, start, end) {
	  var bytes = buf.slice(start, end)
	  var res = ''
	  for (var i = 0; i < bytes.length; i += 2) {
	    res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256)
	  }
	  return res
	}
	
	Buffer.prototype.slice = function slice (start, end) {
	  var len = this.length
	  start = ~~start
	  end = end === undefined ? len : ~~end
	
	  if (start < 0) {
	    start += len
	    if (start < 0) start = 0
	  } else if (start > len) {
	    start = len
	  }
	
	  if (end < 0) {
	    end += len
	    if (end < 0) end = 0
	  } else if (end > len) {
	    end = len
	  }
	
	  if (end < start) end = start
	
	  var newBuf
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    newBuf = Buffer._augment(this.subarray(start, end))
	  } else {
	    var sliceLen = end - start
	    newBuf = new Buffer(sliceLen, undefined)
	    for (var i = 0; i < sliceLen; i++) {
	      newBuf[i] = this[i + start]
	    }
	  }
	
	  if (newBuf.length) newBuf.parent = this.parent || this
	
	  return newBuf
	}
	
	/*
	 * Need to make sure that buffer isn't trying to write out of bounds.
	 */
	function checkOffset (offset, ext, length) {
	  if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')
	  if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')
	}
	
	Buffer.prototype.readUIntLE = function readUIntLE (offset, byteLength, noAssert) {
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) checkOffset(offset, byteLength, this.length)
	
	  var val = this[offset]
	  var mul = 1
	  var i = 0
	  while (++i < byteLength && (mul *= 0x100)) {
	    val += this[offset + i] * mul
	  }
	
	  return val
	}
	
	Buffer.prototype.readUIntBE = function readUIntBE (offset, byteLength, noAssert) {
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) {
	    checkOffset(offset, byteLength, this.length)
	  }
	
	  var val = this[offset + --byteLength]
	  var mul = 1
	  while (byteLength > 0 && (mul *= 0x100)) {
	    val += this[offset + --byteLength] * mul
	  }
	
	  return val
	}
	
	Buffer.prototype.readUInt8 = function readUInt8 (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 1, this.length)
	  return this[offset]
	}
	
	Buffer.prototype.readUInt16LE = function readUInt16LE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 2, this.length)
	  return this[offset] | (this[offset + 1] << 8)
	}
	
	Buffer.prototype.readUInt16BE = function readUInt16BE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 2, this.length)
	  return (this[offset] << 8) | this[offset + 1]
	}
	
	Buffer.prototype.readUInt32LE = function readUInt32LE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)
	
	  return ((this[offset]) |
	      (this[offset + 1] << 8) |
	      (this[offset + 2] << 16)) +
	      (this[offset + 3] * 0x1000000)
	}
	
	Buffer.prototype.readUInt32BE = function readUInt32BE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)
	
	  return (this[offset] * 0x1000000) +
	    ((this[offset + 1] << 16) |
	    (this[offset + 2] << 8) |
	    this[offset + 3])
	}
	
	Buffer.prototype.readIntLE = function readIntLE (offset, byteLength, noAssert) {
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) checkOffset(offset, byteLength, this.length)
	
	  var val = this[offset]
	  var mul = 1
	  var i = 0
	  while (++i < byteLength && (mul *= 0x100)) {
	    val += this[offset + i] * mul
	  }
	  mul *= 0x80
	
	  if (val >= mul) val -= Math.pow(2, 8 * byteLength)
	
	  return val
	}
	
	Buffer.prototype.readIntBE = function readIntBE (offset, byteLength, noAssert) {
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) checkOffset(offset, byteLength, this.length)
	
	  var i = byteLength
	  var mul = 1
	  var val = this[offset + --i]
	  while (i > 0 && (mul *= 0x100)) {
	    val += this[offset + --i] * mul
	  }
	  mul *= 0x80
	
	  if (val >= mul) val -= Math.pow(2, 8 * byteLength)
	
	  return val
	}
	
	Buffer.prototype.readInt8 = function readInt8 (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 1, this.length)
	  if (!(this[offset] & 0x80)) return (this[offset])
	  return ((0xff - this[offset] + 1) * -1)
	}
	
	Buffer.prototype.readInt16LE = function readInt16LE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 2, this.length)
	  var val = this[offset] | (this[offset + 1] << 8)
	  return (val & 0x8000) ? val | 0xFFFF0000 : val
	}
	
	Buffer.prototype.readInt16BE = function readInt16BE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 2, this.length)
	  var val = this[offset + 1] | (this[offset] << 8)
	  return (val & 0x8000) ? val | 0xFFFF0000 : val
	}
	
	Buffer.prototype.readInt32LE = function readInt32LE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)
	
	  return (this[offset]) |
	    (this[offset + 1] << 8) |
	    (this[offset + 2] << 16) |
	    (this[offset + 3] << 24)
	}
	
	Buffer.prototype.readInt32BE = function readInt32BE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)
	
	  return (this[offset] << 24) |
	    (this[offset + 1] << 16) |
	    (this[offset + 2] << 8) |
	    (this[offset + 3])
	}
	
	Buffer.prototype.readFloatLE = function readFloatLE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)
	  return ieee754.read(this, offset, true, 23, 4)
	}
	
	Buffer.prototype.readFloatBE = function readFloatBE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)
	  return ieee754.read(this, offset, false, 23, 4)
	}
	
	Buffer.prototype.readDoubleLE = function readDoubleLE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 8, this.length)
	  return ieee754.read(this, offset, true, 52, 8)
	}
	
	Buffer.prototype.readDoubleBE = function readDoubleBE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 8, this.length)
	  return ieee754.read(this, offset, false, 52, 8)
	}
	
	function checkInt (buf, value, offset, ext, max, min) {
	  if (!Buffer.isBuffer(buf)) throw new TypeError('buffer must be a Buffer instance')
	  if (value > max || value < min) throw new RangeError('value is out of bounds')
	  if (offset + ext > buf.length) throw new RangeError('index out of range')
	}
	
	Buffer.prototype.writeUIntLE = function writeUIntLE (value, offset, byteLength, noAssert) {
	  value = +value
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) checkInt(this, value, offset, byteLength, Math.pow(2, 8 * byteLength), 0)
	
	  var mul = 1
	  var i = 0
	  this[offset] = value & 0xFF
	  while (++i < byteLength && (mul *= 0x100)) {
	    this[offset + i] = (value / mul) & 0xFF
	  }
	
	  return offset + byteLength
	}
	
	Buffer.prototype.writeUIntBE = function writeUIntBE (value, offset, byteLength, noAssert) {
	  value = +value
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) checkInt(this, value, offset, byteLength, Math.pow(2, 8 * byteLength), 0)
	
	  var i = byteLength - 1
	  var mul = 1
	  this[offset + i] = value & 0xFF
	  while (--i >= 0 && (mul *= 0x100)) {
	    this[offset + i] = (value / mul) & 0xFF
	  }
	
	  return offset + byteLength
	}
	
	Buffer.prototype.writeUInt8 = function writeUInt8 (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0)
	  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)
	  this[offset] = (value & 0xff)
	  return offset + 1
	}
	
	function objectWriteUInt16 (buf, value, offset, littleEndian) {
	  if (value < 0) value = 0xffff + value + 1
	  for (var i = 0, j = Math.min(buf.length - offset, 2); i < j; i++) {
	    buf[offset + i] = (value & (0xff << (8 * (littleEndian ? i : 1 - i)))) >>>
	      (littleEndian ? i : 1 - i) * 8
	  }
	}
	
	Buffer.prototype.writeUInt16LE = function writeUInt16LE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value & 0xff)
	    this[offset + 1] = (value >>> 8)
	  } else {
	    objectWriteUInt16(this, value, offset, true)
	  }
	  return offset + 2
	}
	
	Buffer.prototype.writeUInt16BE = function writeUInt16BE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value >>> 8)
	    this[offset + 1] = (value & 0xff)
	  } else {
	    objectWriteUInt16(this, value, offset, false)
	  }
	  return offset + 2
	}
	
	function objectWriteUInt32 (buf, value, offset, littleEndian) {
	  if (value < 0) value = 0xffffffff + value + 1
	  for (var i = 0, j = Math.min(buf.length - offset, 4); i < j; i++) {
	    buf[offset + i] = (value >>> (littleEndian ? i : 3 - i) * 8) & 0xff
	  }
	}
	
	Buffer.prototype.writeUInt32LE = function writeUInt32LE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset + 3] = (value >>> 24)
	    this[offset + 2] = (value >>> 16)
	    this[offset + 1] = (value >>> 8)
	    this[offset] = (value & 0xff)
	  } else {
	    objectWriteUInt32(this, value, offset, true)
	  }
	  return offset + 4
	}
	
	Buffer.prototype.writeUInt32BE = function writeUInt32BE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value >>> 24)
	    this[offset + 1] = (value >>> 16)
	    this[offset + 2] = (value >>> 8)
	    this[offset + 3] = (value & 0xff)
	  } else {
	    objectWriteUInt32(this, value, offset, false)
	  }
	  return offset + 4
	}
	
	Buffer.prototype.writeIntLE = function writeIntLE (value, offset, byteLength, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) {
	    var limit = Math.pow(2, 8 * byteLength - 1)
	
	    checkInt(this, value, offset, byteLength, limit - 1, -limit)
	  }
	
	  var i = 0
	  var mul = 1
	  var sub = value < 0 ? 1 : 0
	  this[offset] = value & 0xFF
	  while (++i < byteLength && (mul *= 0x100)) {
	    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
	  }
	
	  return offset + byteLength
	}
	
	Buffer.prototype.writeIntBE = function writeIntBE (value, offset, byteLength, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) {
	    var limit = Math.pow(2, 8 * byteLength - 1)
	
	    checkInt(this, value, offset, byteLength, limit - 1, -limit)
	  }
	
	  var i = byteLength - 1
	  var mul = 1
	  var sub = value < 0 ? 1 : 0
	  this[offset + i] = value & 0xFF
	  while (--i >= 0 && (mul *= 0x100)) {
	    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
	  }
	
	  return offset + byteLength
	}
	
	Buffer.prototype.writeInt8 = function writeInt8 (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80)
	  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)
	  if (value < 0) value = 0xff + value + 1
	  this[offset] = (value & 0xff)
	  return offset + 1
	}
	
	Buffer.prototype.writeInt16LE = function writeInt16LE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value & 0xff)
	    this[offset + 1] = (value >>> 8)
	  } else {
	    objectWriteUInt16(this, value, offset, true)
	  }
	  return offset + 2
	}
	
	Buffer.prototype.writeInt16BE = function writeInt16BE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value >>> 8)
	    this[offset + 1] = (value & 0xff)
	  } else {
	    objectWriteUInt16(this, value, offset, false)
	  }
	  return offset + 2
	}
	
	Buffer.prototype.writeInt32LE = function writeInt32LE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value & 0xff)
	    this[offset + 1] = (value >>> 8)
	    this[offset + 2] = (value >>> 16)
	    this[offset + 3] = (value >>> 24)
	  } else {
	    objectWriteUInt32(this, value, offset, true)
	  }
	  return offset + 4
	}
	
	Buffer.prototype.writeInt32BE = function writeInt32BE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
	  if (value < 0) value = 0xffffffff + value + 1
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value >>> 24)
	    this[offset + 1] = (value >>> 16)
	    this[offset + 2] = (value >>> 8)
	    this[offset + 3] = (value & 0xff)
	  } else {
	    objectWriteUInt32(this, value, offset, false)
	  }
	  return offset + 4
	}
	
	function checkIEEE754 (buf, value, offset, ext, max, min) {
	  if (value > max || value < min) throw new RangeError('value is out of bounds')
	  if (offset + ext > buf.length) throw new RangeError('index out of range')
	  if (offset < 0) throw new RangeError('index out of range')
	}
	
	function writeFloat (buf, value, offset, littleEndian, noAssert) {
	  if (!noAssert) {
	    checkIEEE754(buf, value, offset, 4, 3.4028234663852886e+38, -3.4028234663852886e+38)
	  }
	  ieee754.write(buf, value, offset, littleEndian, 23, 4)
	  return offset + 4
	}
	
	Buffer.prototype.writeFloatLE = function writeFloatLE (value, offset, noAssert) {
	  return writeFloat(this, value, offset, true, noAssert)
	}
	
	Buffer.prototype.writeFloatBE = function writeFloatBE (value, offset, noAssert) {
	  return writeFloat(this, value, offset, false, noAssert)
	}
	
	function writeDouble (buf, value, offset, littleEndian, noAssert) {
	  if (!noAssert) {
	    checkIEEE754(buf, value, offset, 8, 1.7976931348623157E+308, -1.7976931348623157E+308)
	  }
	  ieee754.write(buf, value, offset, littleEndian, 52, 8)
	  return offset + 8
	}
	
	Buffer.prototype.writeDoubleLE = function writeDoubleLE (value, offset, noAssert) {
	  return writeDouble(this, value, offset, true, noAssert)
	}
	
	Buffer.prototype.writeDoubleBE = function writeDoubleBE (value, offset, noAssert) {
	  return writeDouble(this, value, offset, false, noAssert)
	}
	
	// copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
	Buffer.prototype.copy = function copy (target, targetStart, start, end) {
	  if (!start) start = 0
	  if (!end && end !== 0) end = this.length
	  if (targetStart >= target.length) targetStart = target.length
	  if (!targetStart) targetStart = 0
	  if (end > 0 && end < start) end = start
	
	  // Copy 0 bytes; we're done
	  if (end === start) return 0
	  if (target.length === 0 || this.length === 0) return 0
	
	  // Fatal error conditions
	  if (targetStart < 0) {
	    throw new RangeError('targetStart out of bounds')
	  }
	  if (start < 0 || start >= this.length) throw new RangeError('sourceStart out of bounds')
	  if (end < 0) throw new RangeError('sourceEnd out of bounds')
	
	  // Are we oob?
	  if (end > this.length) end = this.length
	  if (target.length - targetStart < end - start) {
	    end = target.length - targetStart + start
	  }
	
	  var len = end - start
	  var i
	
	  if (this === target && start < targetStart && targetStart < end) {
	    // descending copy from end
	    for (i = len - 1; i >= 0; i--) {
	      target[i + targetStart] = this[i + start]
	    }
	  } else if (len < 1000 || !Buffer.TYPED_ARRAY_SUPPORT) {
	    // ascending copy from start
	    for (i = 0; i < len; i++) {
	      target[i + targetStart] = this[i + start]
	    }
	  } else {
	    target._set(this.subarray(start, start + len), targetStart)
	  }
	
	  return len
	}
	
	// fill(value, start=0, end=buffer.length)
	Buffer.prototype.fill = function fill (value, start, end) {
	  if (!value) value = 0
	  if (!start) start = 0
	  if (!end) end = this.length
	
	  if (end < start) throw new RangeError('end < start')
	
	  // Fill 0 bytes; we're done
	  if (end === start) return
	  if (this.length === 0) return
	
	  if (start < 0 || start >= this.length) throw new RangeError('start out of bounds')
	  if (end < 0 || end > this.length) throw new RangeError('end out of bounds')
	
	  var i
	  if (typeof value === 'number') {
	    for (i = start; i < end; i++) {
	      this[i] = value
	    }
	  } else {
	    var bytes = utf8ToBytes(value.toString())
	    var len = bytes.length
	    for (i = start; i < end; i++) {
	      this[i] = bytes[i % len]
	    }
	  }
	
	  return this
	}
	
	/**
	 * Creates a new `ArrayBuffer` with the *copied* memory of the buffer instance.
	 * Added in Node 0.12. Only available in browsers that support ArrayBuffer.
	 */
	Buffer.prototype.toArrayBuffer = function toArrayBuffer () {
	  if (typeof Uint8Array !== 'undefined') {
	    if (Buffer.TYPED_ARRAY_SUPPORT) {
	      return (new Buffer(this)).buffer
	    } else {
	      var buf = new Uint8Array(this.length)
	      for (var i = 0, len = buf.length; i < len; i += 1) {
	        buf[i] = this[i]
	      }
	      return buf.buffer
	    }
	  } else {
	    throw new TypeError('Buffer.toArrayBuffer not supported in this browser')
	  }
	}
	
	// HELPER FUNCTIONS
	// ================
	
	var BP = Buffer.prototype
	
	/**
	 * Augment a Uint8Array *instance* (not the Uint8Array class!) with Buffer methods
	 */
	Buffer._augment = function _augment (arr) {
	  arr.constructor = Buffer
	  arr._isBuffer = true
	
	  // save reference to original Uint8Array set method before overwriting
	  arr._set = arr.set
	
	  // deprecated
	  arr.get = BP.get
	  arr.set = BP.set
	
	  arr.write = BP.write
	  arr.toString = BP.toString
	  arr.toLocaleString = BP.toString
	  arr.toJSON = BP.toJSON
	  arr.equals = BP.equals
	  arr.compare = BP.compare
	  arr.indexOf = BP.indexOf
	  arr.copy = BP.copy
	  arr.slice = BP.slice
	  arr.readUIntLE = BP.readUIntLE
	  arr.readUIntBE = BP.readUIntBE
	  arr.readUInt8 = BP.readUInt8
	  arr.readUInt16LE = BP.readUInt16LE
	  arr.readUInt16BE = BP.readUInt16BE
	  arr.readUInt32LE = BP.readUInt32LE
	  arr.readUInt32BE = BP.readUInt32BE
	  arr.readIntLE = BP.readIntLE
	  arr.readIntBE = BP.readIntBE
	  arr.readInt8 = BP.readInt8
	  arr.readInt16LE = BP.readInt16LE
	  arr.readInt16BE = BP.readInt16BE
	  arr.readInt32LE = BP.readInt32LE
	  arr.readInt32BE = BP.readInt32BE
	  arr.readFloatLE = BP.readFloatLE
	  arr.readFloatBE = BP.readFloatBE
	  arr.readDoubleLE = BP.readDoubleLE
	  arr.readDoubleBE = BP.readDoubleBE
	  arr.writeUInt8 = BP.writeUInt8
	  arr.writeUIntLE = BP.writeUIntLE
	  arr.writeUIntBE = BP.writeUIntBE
	  arr.writeUInt16LE = BP.writeUInt16LE
	  arr.writeUInt16BE = BP.writeUInt16BE
	  arr.writeUInt32LE = BP.writeUInt32LE
	  arr.writeUInt32BE = BP.writeUInt32BE
	  arr.writeIntLE = BP.writeIntLE
	  arr.writeIntBE = BP.writeIntBE
	  arr.writeInt8 = BP.writeInt8
	  arr.writeInt16LE = BP.writeInt16LE
	  arr.writeInt16BE = BP.writeInt16BE
	  arr.writeInt32LE = BP.writeInt32LE
	  arr.writeInt32BE = BP.writeInt32BE
	  arr.writeFloatLE = BP.writeFloatLE
	  arr.writeFloatBE = BP.writeFloatBE
	  arr.writeDoubleLE = BP.writeDoubleLE
	  arr.writeDoubleBE = BP.writeDoubleBE
	  arr.fill = BP.fill
	  arr.inspect = BP.inspect
	  arr.toArrayBuffer = BP.toArrayBuffer
	
	  return arr
	}
	
	var INVALID_BASE64_RE = /[^+\/0-9A-Za-z-_]/g
	
	function base64clean (str) {
	  // Node strips out invalid characters like \n and \t from the string, base64-js does not
	  str = stringtrim(str).replace(INVALID_BASE64_RE, '')
	  // Node converts strings with length < 2 to ''
	  if (str.length < 2) return ''
	  // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
	  while (str.length % 4 !== 0) {
	    str = str + '='
	  }
	  return str
	}
	
	function stringtrim (str) {
	  if (str.trim) return str.trim()
	  return str.replace(/^\s+|\s+$/g, '')
	}
	
	function toHex (n) {
	  if (n < 16) return '0' + n.toString(16)
	  return n.toString(16)
	}
	
	function utf8ToBytes (string, units) {
	  units = units || Infinity
	  var codePoint
	  var length = string.length
	  var leadSurrogate = null
	  var bytes = []
	
	  for (var i = 0; i < length; i++) {
	    codePoint = string.charCodeAt(i)
	
	    // is surrogate component
	    if (codePoint > 0xD7FF && codePoint < 0xE000) {
	      // last char was a lead
	      if (!leadSurrogate) {
	        // no lead yet
	        if (codePoint > 0xDBFF) {
	          // unexpected trail
	          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
	          continue
	        } else if (i + 1 === length) {
	          // unpaired lead
	          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
	          continue
	        }
	
	        // valid lead
	        leadSurrogate = codePoint
	
	        continue
	      }
	
	      // 2 leads in a row
	      if (codePoint < 0xDC00) {
	        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
	        leadSurrogate = codePoint
	        continue
	      }
	
	      // valid surrogate pair
	      codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000
	    } else if (leadSurrogate) {
	      // valid bmp char, but last char was a lead
	      if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
	    }
	
	    leadSurrogate = null
	
	    // encode utf8
	    if (codePoint < 0x80) {
	      if ((units -= 1) < 0) break
	      bytes.push(codePoint)
	    } else if (codePoint < 0x800) {
	      if ((units -= 2) < 0) break
	      bytes.push(
	        codePoint >> 0x6 | 0xC0,
	        codePoint & 0x3F | 0x80
	      )
	    } else if (codePoint < 0x10000) {
	      if ((units -= 3) < 0) break
	      bytes.push(
	        codePoint >> 0xC | 0xE0,
	        codePoint >> 0x6 & 0x3F | 0x80,
	        codePoint & 0x3F | 0x80
	      )
	    } else if (codePoint < 0x110000) {
	      if ((units -= 4) < 0) break
	      bytes.push(
	        codePoint >> 0x12 | 0xF0,
	        codePoint >> 0xC & 0x3F | 0x80,
	        codePoint >> 0x6 & 0x3F | 0x80,
	        codePoint & 0x3F | 0x80
	      )
	    } else {
	      throw new Error('Invalid code point')
	    }
	  }
	
	  return bytes
	}
	
	function asciiToBytes (str) {
	  var byteArray = []
	  for (var i = 0; i < str.length; i++) {
	    // Node's code seems to be doing this and not & 0x7F..
	    byteArray.push(str.charCodeAt(i) & 0xFF)
	  }
	  return byteArray
	}
	
	function utf16leToBytes (str, units) {
	  var c, hi, lo
	  var byteArray = []
	  for (var i = 0; i < str.length; i++) {
	    if ((units -= 2) < 0) break
	
	    c = str.charCodeAt(i)
	    hi = c >> 8
	    lo = c % 256
	    byteArray.push(lo)
	    byteArray.push(hi)
	  }
	
	  return byteArray
	}
	
	function base64ToBytes (str) {
	  return base64.toByteArray(base64clean(str))
	}
	
	function blitBuffer (src, dst, offset, length) {
	  for (var i = 0; i < length; i++) {
	    if ((i + offset >= dst.length) || (i >= src.length)) break
	    dst[i + offset] = src[i]
	  }
	  return i
	}
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(14).Buffer, (function() { return this; }())))

/***/ },
/* 15 */
/***/ function(module, exports, __webpack_require__) {

	var lookup = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
	
	;(function (exports) {
		'use strict';
	
	  var Arr = (typeof Uint8Array !== 'undefined')
	    ? Uint8Array
	    : Array
	
		var PLUS   = '+'.charCodeAt(0)
		var SLASH  = '/'.charCodeAt(0)
		var NUMBER = '0'.charCodeAt(0)
		var LOWER  = 'a'.charCodeAt(0)
		var UPPER  = 'A'.charCodeAt(0)
		var PLUS_URL_SAFE = '-'.charCodeAt(0)
		var SLASH_URL_SAFE = '_'.charCodeAt(0)
	
		function decode (elt) {
			var code = elt.charCodeAt(0)
			if (code === PLUS ||
			    code === PLUS_URL_SAFE)
				return 62 // '+'
			if (code === SLASH ||
			    code === SLASH_URL_SAFE)
				return 63 // '/'
			if (code < NUMBER)
				return -1 //no match
			if (code < NUMBER + 10)
				return code - NUMBER + 26 + 26
			if (code < UPPER + 26)
				return code - UPPER
			if (code < LOWER + 26)
				return code - LOWER + 26
		}
	
		function b64ToByteArray (b64) {
			var i, j, l, tmp, placeHolders, arr
	
			if (b64.length % 4 > 0) {
				throw new Error('Invalid string. Length must be a multiple of 4')
			}
	
			// the number of equal signs (place holders)
			// if there are two placeholders, than the two characters before it
			// represent one byte
			// if there is only one, then the three characters before it represent 2 bytes
			// this is just a cheap hack to not do indexOf twice
			var len = b64.length
			placeHolders = '=' === b64.charAt(len - 2) ? 2 : '=' === b64.charAt(len - 1) ? 1 : 0
	
			// base64 is 4/3 + up to two characters of the original data
			arr = new Arr(b64.length * 3 / 4 - placeHolders)
	
			// if there are placeholders, only get up to the last complete 4 chars
			l = placeHolders > 0 ? b64.length - 4 : b64.length
	
			var L = 0
	
			function push (v) {
				arr[L++] = v
			}
	
			for (i = 0, j = 0; i < l; i += 4, j += 3) {
				tmp = (decode(b64.charAt(i)) << 18) | (decode(b64.charAt(i + 1)) << 12) | (decode(b64.charAt(i + 2)) << 6) | decode(b64.charAt(i + 3))
				push((tmp & 0xFF0000) >> 16)
				push((tmp & 0xFF00) >> 8)
				push(tmp & 0xFF)
			}
	
			if (placeHolders === 2) {
				tmp = (decode(b64.charAt(i)) << 2) | (decode(b64.charAt(i + 1)) >> 4)
				push(tmp & 0xFF)
			} else if (placeHolders === 1) {
				tmp = (decode(b64.charAt(i)) << 10) | (decode(b64.charAt(i + 1)) << 4) | (decode(b64.charAt(i + 2)) >> 2)
				push((tmp >> 8) & 0xFF)
				push(tmp & 0xFF)
			}
	
			return arr
		}
	
		function uint8ToBase64 (uint8) {
			var i,
				extraBytes = uint8.length % 3, // if we have 1 byte left, pad 2 bytes
				output = "",
				temp, length
	
			function encode (num) {
				return lookup.charAt(num)
			}
	
			function tripletToBase64 (num) {
				return encode(num >> 18 & 0x3F) + encode(num >> 12 & 0x3F) + encode(num >> 6 & 0x3F) + encode(num & 0x3F)
			}
	
			// go through the array every three bytes, we'll deal with trailing stuff later
			for (i = 0, length = uint8.length - extraBytes; i < length; i += 3) {
				temp = (uint8[i] << 16) + (uint8[i + 1] << 8) + (uint8[i + 2])
				output += tripletToBase64(temp)
			}
	
			// pad the end with zeros, but make sure to not forget the extra bytes
			switch (extraBytes) {
				case 1:
					temp = uint8[uint8.length - 1]
					output += encode(temp >> 2)
					output += encode((temp << 4) & 0x3F)
					output += '=='
					break
				case 2:
					temp = (uint8[uint8.length - 2] << 8) + (uint8[uint8.length - 1])
					output += encode(temp >> 10)
					output += encode((temp >> 4) & 0x3F)
					output += encode((temp << 2) & 0x3F)
					output += '='
					break
			}
	
			return output
		}
	
		exports.toByteArray = b64ToByteArray
		exports.fromByteArray = uint8ToBase64
	}( false ? (this.base64js = {}) : exports))


/***/ },
/* 16 */
/***/ function(module, exports) {

	exports.read = function (buffer, offset, isLE, mLen, nBytes) {
	  var e, m
	  var eLen = nBytes * 8 - mLen - 1
	  var eMax = (1 << eLen) - 1
	  var eBias = eMax >> 1
	  var nBits = -7
	  var i = isLE ? (nBytes - 1) : 0
	  var d = isLE ? -1 : 1
	  var s = buffer[offset + i]
	
	  i += d
	
	  e = s & ((1 << (-nBits)) - 1)
	  s >>= (-nBits)
	  nBits += eLen
	  for (; nBits > 0; e = e * 256 + buffer[offset + i], i += d, nBits -= 8) {}
	
	  m = e & ((1 << (-nBits)) - 1)
	  e >>= (-nBits)
	  nBits += mLen
	  for (; nBits > 0; m = m * 256 + buffer[offset + i], i += d, nBits -= 8) {}
	
	  if (e === 0) {
	    e = 1 - eBias
	  } else if (e === eMax) {
	    return m ? NaN : ((s ? -1 : 1) * Infinity)
	  } else {
	    m = m + Math.pow(2, mLen)
	    e = e - eBias
	  }
	  return (s ? -1 : 1) * m * Math.pow(2, e - mLen)
	}
	
	exports.write = function (buffer, value, offset, isLE, mLen, nBytes) {
	  var e, m, c
	  var eLen = nBytes * 8 - mLen - 1
	  var eMax = (1 << eLen) - 1
	  var eBias = eMax >> 1
	  var rt = (mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0)
	  var i = isLE ? 0 : (nBytes - 1)
	  var d = isLE ? 1 : -1
	  var s = value < 0 || (value === 0 && 1 / value < 0) ? 1 : 0
	
	  value = Math.abs(value)
	
	  if (isNaN(value) || value === Infinity) {
	    m = isNaN(value) ? 1 : 0
	    e = eMax
	  } else {
	    e = Math.floor(Math.log(value) / Math.LN2)
	    if (value * (c = Math.pow(2, -e)) < 1) {
	      e--
	      c *= 2
	    }
	    if (e + eBias >= 1) {
	      value += rt / c
	    } else {
	      value += rt * Math.pow(2, 1 - eBias)
	    }
	    if (value * c >= 2) {
	      e++
	      c /= 2
	    }
	
	    if (e + eBias >= eMax) {
	      m = 0
	      e = eMax
	    } else if (e + eBias >= 1) {
	      m = (value * c - 1) * Math.pow(2, mLen)
	      e = e + eBias
	    } else {
	      m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen)
	      e = 0
	    }
	  }
	
	  for (; mLen >= 8; buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8) {}
	
	  e = (e << mLen) | m
	  eLen += mLen
	  for (; eLen > 0; buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8) {}
	
	  buffer[offset + i - d] |= s * 128
	}


/***/ },
/* 17 */
/***/ function(module, exports) {

	var toString = {}.toString;
	
	module.exports = Array.isArray || function (arr) {
	  return toString.call(arr) == '[object Array]';
	};


/***/ },
/* 18 */
/***/ function(module, exports, __webpack_require__) {

	var util = __webpack_require__(13);
	
	// Matches absolute URLs with optional protocol
	//   https://...    file://...    //...
	var protocol_re = /^([A-Za-z]+:)?\/\//;
	
	// Special treatment in node.js for the file: protocol
	var fileProtocol = 'file://';
	
	// Validate and cleanup URL to ensure that it is allowed to be accessed
	// Returns cleaned up URL, or false if access is not allowed
	function sanitizeUrl(opt) {
	  var url = opt.url;
	  if (!url && opt.file) { return fileProtocol + opt.file; }
	
	  // In case this is a relative url (has no host), prepend opt.baseURL
	  if (opt.baseURL && !protocol_re.test(url)) {
	    if (!startsWith(url, '/') && opt.baseURL[opt.baseURL.length-1] !== '/') {
	      url = '/' + url; // Ensure that there is a slash between the baseURL (e.g. hostname) and url
	    }
	    url = opt.baseURL + url;
	  }
	  // relative protocol, starts with '//'
	  if (!load.useXHR && startsWith(url, '//')) {
	    url = (opt.defaultProtocol || 'http') + ':' + url;
	  }
	  // If opt.domainWhiteList is set, only allows url, whose hostname
	  // * Is the same as the origin (window.location.hostname)
	  // * Equals one of the values in the whitelist
	  // * Is a proper subdomain of one of the values in the whitelist
	  if (opt.domainWhiteList) {
	    var domain, origin;
	    if (load.useXHR) {
	      var a = document.createElement('a');
	      a.href = url;
	      // From http://stackoverflow.com/questions/736513/how-do-i-parse-a-url-into-hostname-and-path-in-javascript
	      // IE doesn't populate all link properties when setting .href with a relative URL,
	      // however .href will return an absolute URL which then can be used on itself
	      // to populate these additional fields.
	      if (a.host === '') {
	        a.href = a.href;
	      }
	      domain = a.hostname.toLowerCase();
	      origin = window.location.hostname;
	    } else {
	      // relative protocol is broken: https://github.com/defunctzombie/node-url/issues/5
	      var parts = __webpack_require__(19).parse(url);
	      domain = parts.hostname;
	      origin = null;
	    }
	
	    if (origin !== domain) {
	      var whiteListed = opt.domainWhiteList.some(function(d) {
	        var idx = domain.length - d.length;
	        return d === domain ||
	          (idx > 1 && domain[idx-1] === '.' && domain.lastIndexOf(d) === idx);
	      });
	      if (!whiteListed) {
	        throw 'URL is not whitelisted: ' + url;
	      }
	    }
	  }
	  return url;
	}
	
	function load(opt, callback) {
	  return load.loader(opt, callback);
	}
	
	function loader(opt, callback) {
	  var error = callback || function(e) { throw e; }, url;
	
	  try {
	    url = load.sanitizeUrl(opt); // enable override
	  } catch (err) {
	    error(err);
	    return;
	  }
	
	  if (!url) {
	    error('Invalid URL: ' + opt.url);
	  } else if (load.useXHR) {
	    // on client, use xhr
	    return load.xhr(url, opt, callback);
	  } else if (startsWith(url, fileProtocol)) {
	    // on server, if url starts with 'file://', strip it and load from file
	    return load.file(url.slice(fileProtocol.length), opt, callback);
	  } else if (url.indexOf('://') < 0) { // TODO better protocol check?
	    // on server, if no protocol assume file
	    return load.file(url, opt, callback);
	  } else {
	    // for regular URLs on server
	    return load.http(url, opt, callback);
	  }
	}
	
	function xhrHasResponse(request) {
	  var type = request.responseType;
	  return type && type !== 'text' ?
	    request.response : // null on error
	    request.responseText; // '' on error
	}
	
	function xhr(url, opt, callback) {
	  var async = !!callback;
	  var request = new XMLHttpRequest();
	  // If IE does not support CORS, use XDomainRequest (copied from d3.xhr)
	  if (typeof XDomainRequest !== 'undefined' &&
	      !('withCredentials' in request) &&
	      /^(http(s)?:)?\/\//.test(url)) request = new XDomainRequest();
	
	  function respond() {
	    var status = request.status;
	    if (!status && xhrHasResponse(request) || status >= 200 && status < 300 || status === 304) {
	      callback(null, request.responseText);
	    } else {
	      callback(request, null);
	    }
	  }
	
	  if (async) {
	    if ('onload' in request) {
	      request.onload = request.onerror = respond;
	    } else {
	      request.onreadystatechange = function() {
	        if (request.readyState > 3) respond();
	      };
	    }
	  }
	
	  request.open('GET', url, async);
	  /* istanbul ignore else */
	  if (request.setRequestHeader) {
	    var headers = util.extend({}, load.headers, opt.headers);
	    for (var name in headers) {
	      request.setRequestHeader(name, headers[name]);
	    }
	  }
	  request.send();
	
	  if (!async && xhrHasResponse(request)) {
	    return request.responseText;
	  }
	}
	
	function file(filename, opt, callback) {
	  var fs = __webpack_require__(20);
	  if (!callback) {
	    return fs.readFileSync(filename, 'utf8');
	  }
	  fs.readFile(filename, callback);
	}
	
	function http(url, opt, callback) {
	  var headers = util.extend({}, load.headers, opt.headers);
	
	  if (!callback) {
	    return __webpack_require__(21)('GET', url, {headers: headers}).getBody();
	  }
	
	  var options = {url: url, encoding: null, gzip: true, headers: headers};
	  __webpack_require__(22)(options, function(error, response, body) {
	    if (!error && response.statusCode === 200) {
	      callback(null, body);
	    } else {
	      error = error ||
	        'Load failed with response code ' + response.statusCode + '.';
	      callback(error, null);
	    }
	  });
	}
	
	function startsWith(string, searchString) {
	  return string == null ? false : string.lastIndexOf(searchString, 0) === 0;
	}
	
	// Allow these functions to be overriden by the user of the library
	load.loader = loader;
	load.sanitizeUrl = sanitizeUrl;
	load.xhr = xhr;
	load.file = file;
	load.http = http;
	
	// Default settings
	load.useXHR = (typeof XMLHttpRequest !== 'undefined');
	load.headers = {};
	
	module.exports = load;


/***/ },
/* 19 */
/***/ function(module, exports) {

	/* (ignored) */

/***/ },
/* 20 */
/***/ function(module, exports) {

	/* (ignored) */

/***/ },
/* 21 */
/***/ function(module, exports) {

	/* (ignored) */

/***/ },
/* 22 */
/***/ function(module, exports) {

	/* (ignored) */

/***/ },
/* 23 */
/***/ function(module, exports, __webpack_require__) {

	var util = __webpack_require__(13),
	  type = __webpack_require__(24),
	  formats = __webpack_require__(25),
	  timeF = __webpack_require__(32).time;
	
	function read(data, format) {
	  var type = (format && format.type) || 'json';
	  data = formats[type](data, format);
	  if (format && format.parse) parse(data, format.parse);
	  return data;
	}
	
	function parse(data, types) {
	  var cols, parsers, d, i, j, clen, len = data.length;
	
	  types = (types==='auto') ? type.inferAll(data) : util.duplicate(types);
	  cols = util.keys(types);
	  parsers = cols.map(function(c) {
	    var t = types[c];
	    if (t && t.indexOf('date:') === 0) {
	      var parts = t.split(/:(.+)?/, 2),  // split on first :
	          pattern = parts[1];
	      if ((pattern[0] === '\'' && pattern[pattern.length-1] === '\'') ||
	          (pattern[0] === '"'  && pattern[pattern.length-1] === '"')) {
	        pattern = pattern.slice(1, -1);
	      } else {
	        throw Error('Format pattern must be quoted: ' + pattern);
	      }
	      pattern = timeF(pattern);
	      return function(v) { return pattern.parse(v); };
	    }
	    if (!type.parsers[t]) {
	      throw Error('Illegal format pattern: ' + c + ':' + t);
	    }
	    return type.parsers[t];
	  });
	
	  for (i=0, clen=cols.length; i<len; ++i) {
	    d = data[i];
	    for (j=0; j<clen; ++j) {
	      d[cols[j]] = parsers[j](d[cols[j]]);
	    }
	  }
	  type.annotation(data, types);
	}
	
	read.formats = formats;
	module.exports = read;


/***/ },
/* 24 */
/***/ function(module, exports, __webpack_require__) {

	var util = __webpack_require__(13);
	
	var TYPES = '__types__';
	
	var PARSERS = {
	  boolean: util.boolean,
	  integer: util.number,
	  number:  util.number,
	  date:    util.date,
	  string:  function(x) { return x==='' ? null : x; }
	};
	
	var TESTS = {
	  boolean: function(x) { return x==='true' || x==='false' || util.isBoolean(x); },
	  integer: function(x) { return TESTS.number(x) && (x=+x) === ~~x; },
	  number: function(x) { return !isNaN(+x) && !util.isDate(x); },
	  date: function(x) { return !isNaN(Date.parse(x)); }
	};
	
	function annotation(data, types) {
	  if (!types) return data && data[TYPES] || null;
	  data[TYPES] = types;
	}
	
	function type(values, f) {
	  values = util.array(values);
	  f = util.$(f);
	  var v, i, n;
	
	  // if data array has type annotations, use them
	  if (values[TYPES]) {
	    v = f(values[TYPES]);
	    if (util.isString(v)) return v;
	  }
	
	  for (i=0, n=values.length; !util.isValid(v) && i<n; ++i) {
	    v = f ? f(values[i]) : values[i];
	  }
	
	  return util.isDate(v) ? 'date' :
	    util.isNumber(v)    ? 'number' :
	    util.isBoolean(v)   ? 'boolean' :
	    util.isString(v)    ? 'string' : null;
	}
	
	function typeAll(data, fields) {
	  if (!data.length) return;
	  fields = fields || util.keys(data[0]);
	  return fields.reduce(function(types, f) {
	    return (types[f] = type(data, f), types);
	  }, {});
	}
	
	function infer(values, f) {
	  values = util.array(values);
	  f = util.$(f);
	  var i, j, v;
	
	  // types to test for, in precedence order
	  var types = ['boolean', 'integer', 'number', 'date'];
	
	  for (i=0; i<values.length; ++i) {
	    // get next value to test
	    v = f ? f(values[i]) : values[i];
	    // test value against remaining types
	    for (j=0; j<types.length; ++j) {
	      if (util.isValid(v) && !TESTS[types[j]](v)) {
	        types.splice(j, 1);
	        j -= 1;
	      }
	    }
	    // if no types left, return 'string'
	    if (types.length === 0) return 'string';
	  }
	
	  return types[0];
	}
	
	function inferAll(data, fields) {
	  fields = fields || util.keys(data[0]);
	  return fields.reduce(function(types, f) {
	    types[f] = infer(data, f);
	    return types;
	  }, {});
	}
	
	type.annotation = annotation;
	type.all = typeAll;
	type.infer = infer;
	type.inferAll = inferAll;
	type.parsers = PARSERS;
	module.exports = type;


/***/ },
/* 25 */
/***/ function(module, exports, __webpack_require__) {

	var dsv = __webpack_require__(26);
	
	module.exports = {
	  json: __webpack_require__(28),
	  topojson: __webpack_require__(29),
	  treejson: __webpack_require__(31),
	  dsv: dsv,
	  csv: dsv.delimiter(','),
	  tsv: dsv.delimiter('\t')
	};


/***/ },
/* 26 */
/***/ function(module, exports, __webpack_require__) {

	var util = __webpack_require__(13);
	var d3_dsv = __webpack_require__(27);
	
	function dsv(data, format) {
	  if (data) {
	    var h = format.header;
	    data = (h ? h.join(format.delimiter) + '\n' : '') + data;
	  }
	  return d3_dsv.dsv(format.delimiter).parse(data);
	}
	
	dsv.delimiter = function(delim) {
	  var fmt = {delimiter: delim};
	  return function(data, format) {
	    return dsv(data, format ? util.extend(format, fmt) : fmt);
	  };
	};
	
	module.exports = dsv;


/***/ },
/* 27 */
/***/ function(module, exports, __webpack_require__) {

	(function (global, factory) {
	   true ? factory(exports) :
	  typeof define === 'function' && define.amd ? define(['exports'], factory) :
	  (factory((global.d3_dsv = {})));
	}(this, function (exports) { 'use strict';
	
	  function dsv(delimiter) {
	    return new Dsv(delimiter);
	  }
	
	  function objectConverter(columns) {
	    return new Function("d", "return {" + columns.map(function(name, i) {
	      return JSON.stringify(name) + ": d[" + i + "]";
	    }).join(",") + "}");
	  }
	
	  function customConverter(columns, f) {
	    var object = objectConverter(columns);
	    return function(row, i) {
	      return f(object(row), i, columns);
	    };
	  }
	
	  // Compute unique columns in order of discovery.
	  function inferColumns(rows) {
	    var columnSet = Object.create(null),
	        columns = [];
	
	    rows.forEach(function(row) {
	      for (var column in row) {
	        if (!(column in columnSet)) {
	          columns.push(columnSet[column] = column);
	        }
	      }
	    });
	
	    return columns;
	  }
	
	  function Dsv(delimiter) {
	    var reFormat = new RegExp("[\"" + delimiter + "\n]"),
	        delimiterCode = delimiter.charCodeAt(0);
	
	    this.parse = function(text, f) {
	      var convert, columns, rows = this.parseRows(text, function(row, i) {
	        if (convert) return convert(row, i - 1);
	        columns = row, convert = f ? customConverter(row, f) : objectConverter(row);
	      });
	      rows.columns = columns;
	      return rows;
	    };
	
	    this.parseRows = function(text, f) {
	      var EOL = {}, // sentinel value for end-of-line
	          EOF = {}, // sentinel value for end-of-file
	          rows = [], // output rows
	          N = text.length,
	          I = 0, // current character index
	          n = 0, // the current line number
	          t, // the current token
	          eol; // is the current token followed by EOL?
	
	      function token() {
	        if (I >= N) return EOF; // special case: end of file
	        if (eol) return eol = false, EOL; // special case: end of line
	
	        // special case: quotes
	        var j = I, c;
	        if (text.charCodeAt(j) === 34) {
	          var i = j;
	          while (i++ < N) {
	            if (text.charCodeAt(i) === 34) {
	              if (text.charCodeAt(i + 1) !== 34) break;
	              ++i;
	            }
	          }
	          I = i + 2;
	          c = text.charCodeAt(i + 1);
	          if (c === 13) {
	            eol = true;
	            if (text.charCodeAt(i + 2) === 10) ++I;
	          } else if (c === 10) {
	            eol = true;
	          }
	          return text.slice(j + 1, i).replace(/""/g, "\"");
	        }
	
	        // common case: find next delimiter or newline
	        while (I < N) {
	          var k = 1;
	          c = text.charCodeAt(I++);
	          if (c === 10) eol = true; // \n
	          else if (c === 13) { eol = true; if (text.charCodeAt(I) === 10) ++I, ++k; } // \r|\r\n
	          else if (c !== delimiterCode) continue;
	          return text.slice(j, I - k);
	        }
	
	        // special case: last token before EOF
	        return text.slice(j);
	      }
	
	      while ((t = token()) !== EOF) {
	        var a = [];
	        while (t !== EOL && t !== EOF) {
	          a.push(t);
	          t = token();
	        }
	        if (f && (a = f(a, n++)) == null) continue;
	        rows.push(a);
	      }
	
	      return rows;
	    }
	
	    this.format = function(rows, columns) {
	      if (columns == null) columns = inferColumns(rows);
	      return [columns.map(formatValue).join(delimiter)].concat(rows.map(function(row) {
	        return columns.map(function(column) {
	          return formatValue(row[column]);
	        }).join(delimiter);
	      })).join("\n");
	    };
	
	    this.formatRows = function(rows) {
	      return rows.map(formatRow).join("\n");
	    };
	
	    function formatRow(row) {
	      return row.map(formatValue).join(delimiter);
	    }
	
	    function formatValue(text) {
	      return reFormat.test(text) ? "\"" + text.replace(/\"/g, "\"\"") + "\"" : text;
	    }
	  }
	
	  dsv.prototype = Dsv.prototype;
	
	  var csv = dsv(",");
	  var tsv = dsv("\t");
	
	  var version = "0.1.14";
	
	  exports.version = version;
	  exports.dsv = dsv;
	  exports.csv = csv;
	  exports.tsv = tsv;
	
	}));

/***/ },
/* 28 */
/***/ function(module, exports, __webpack_require__) {

	var util = __webpack_require__(13);
	
	module.exports = function(data, format) {
	  var d = util.isObject(data) && !util.isBuffer(data) ?
	    data : JSON.parse(data);
	  if (format && format.property) {
	    d = util.accessor(format.property)(d);
	  }
	  return d;
	};


/***/ },
/* 29 */
/***/ function(module, exports, __webpack_require__) {

	var json = __webpack_require__(28);
	
	var reader = function(data, format) {
	  var topojson = reader.topojson;
	  if (topojson == null) { throw Error('TopoJSON library not loaded.'); }
	
	  var t = json(data, format), obj;
	
	  if (format && format.feature) {
	    if ((obj = t.objects[format.feature])) {
	      return topojson.feature(t, obj).features;
	    } else {
	      throw Error('Invalid TopoJSON object: ' + format.feature);
	    }
	  } else if (format && format.mesh) {
	    if ((obj = t.objects[format.mesh])) {
	      return [topojson.mesh(t, t.objects[format.mesh])];
	    } else {
	      throw Error('Invalid TopoJSON object: ' + format.mesh);
	    }
	  } else {
	    throw Error('Missing TopoJSON feature or mesh parameter.');
	  }
	};
	
	reader.topojson = __webpack_require__(30);
	module.exports = reader;


/***/ },
/* 30 */
/***/ function(module, exports, __webpack_require__) {

	(function (global, factory) {
	   true ? factory(exports) :
	  typeof define === 'function' && define.amd ? define(['exports'], factory) :
	  (factory((global.topojson = global.topojson || {})));
	}(this, function (exports) { 'use strict';
	
	  function noop() {}
	
	  function transformAbsolute(transform) {
	    if (!transform) return noop;
	    var x0,
	        y0,
	        kx = transform.scale[0],
	        ky = transform.scale[1],
	        dx = transform.translate[0],
	        dy = transform.translate[1];
	    return function(point, i) {
	      if (!i) x0 = y0 = 0;
	      point[0] = (x0 += point[0]) * kx + dx;
	      point[1] = (y0 += point[1]) * ky + dy;
	    };
	  }
	
	  function transformRelative(transform) {
	    if (!transform) return noop;
	    var x0,
	        y0,
	        kx = transform.scale[0],
	        ky = transform.scale[1],
	        dx = transform.translate[0],
	        dy = transform.translate[1];
	    return function(point, i) {
	      if (!i) x0 = y0 = 0;
	      var x1 = Math.round((point[0] - dx) / kx),
	          y1 = Math.round((point[1] - dy) / ky);
	      point[0] = x1 - x0;
	      point[1] = y1 - y0;
	      x0 = x1;
	      y0 = y1;
	    };
	  }
	
	  function reverse(array, n) {
	    var t, j = array.length, i = j - n;
	    while (i < --j) t = array[i], array[i++] = array[j], array[j] = t;
	  }
	
	  function bisect(a, x) {
	    var lo = 0, hi = a.length;
	    while (lo < hi) {
	      var mid = lo + hi >>> 1;
	      if (a[mid] < x) lo = mid + 1;
	      else hi = mid;
	    }
	    return lo;
	  }
	
	  function feature(topology, o) {
	    return o.type === "GeometryCollection" ? {
	      type: "FeatureCollection",
	      features: o.geometries.map(function(o) { return feature$1(topology, o); })
	    } : feature$1(topology, o);
	  }
	
	  function feature$1(topology, o) {
	    var f = {
	      type: "Feature",
	      id: o.id,
	      properties: o.properties || {},
	      geometry: object(topology, o)
	    };
	    if (o.id == null) delete f.id;
	    return f;
	  }
	
	  function object(topology, o) {
	    var absolute = transformAbsolute(topology.transform),
	        arcs = topology.arcs;
	
	    function arc(i, points) {
	      if (points.length) points.pop();
	      for (var a = arcs[i < 0 ? ~i : i], k = 0, n = a.length, p; k < n; ++k) {
	        points.push(p = a[k].slice());
	        absolute(p, k);
	      }
	      if (i < 0) reverse(points, n);
	    }
	
	    function point(p) {
	      p = p.slice();
	      absolute(p, 0);
	      return p;
	    }
	
	    function line(arcs) {
	      var points = [];
	      for (var i = 0, n = arcs.length; i < n; ++i) arc(arcs[i], points);
	      if (points.length < 2) points.push(points[0].slice());
	      return points;
	    }
	
	    function ring(arcs) {
	      var points = line(arcs);
	      while (points.length < 4) points.push(points[0].slice());
	      return points;
	    }
	
	    function polygon(arcs) {
	      return arcs.map(ring);
	    }
	
	    function geometry(o) {
	      var t = o.type;
	      return t === "GeometryCollection" ? {type: t, geometries: o.geometries.map(geometry)}
	          : t in geometryType ? {type: t, coordinates: geometryType[t](o)}
	          : null;
	    }
	
	    var geometryType = {
	      Point: function(o) { return point(o.coordinates); },
	      MultiPoint: function(o) { return o.coordinates.map(point); },
	      LineString: function(o) { return line(o.arcs); },
	      MultiLineString: function(o) { return o.arcs.map(line); },
	      Polygon: function(o) { return polygon(o.arcs); },
	      MultiPolygon: function(o) { return o.arcs.map(polygon); }
	    };
	
	    return geometry(o);
	  }
	
	  function stitchArcs(topology, arcs) {
	    var stitchedArcs = {},
	        fragmentByStart = {},
	        fragmentByEnd = {},
	        fragments = [],
	        emptyIndex = -1;
	
	    // Stitch empty arcs first, since they may be subsumed by other arcs.
	    arcs.forEach(function(i, j) {
	      var arc = topology.arcs[i < 0 ? ~i : i], t;
	      if (arc.length < 3 && !arc[1][0] && !arc[1][1]) {
	        t = arcs[++emptyIndex], arcs[emptyIndex] = i, arcs[j] = t;
	      }
	    });
	
	    arcs.forEach(function(i) {
	      var e = ends(i),
	          start = e[0],
	          end = e[1],
	          f, g;
	
	      if (f = fragmentByEnd[start]) {
	        delete fragmentByEnd[f.end];
	        f.push(i);
	        f.end = end;
	        if (g = fragmentByStart[end]) {
	          delete fragmentByStart[g.start];
	          var fg = g === f ? f : f.concat(g);
	          fragmentByStart[fg.start = f.start] = fragmentByEnd[fg.end = g.end] = fg;
	        } else {
	          fragmentByStart[f.start] = fragmentByEnd[f.end] = f;
	        }
	      } else if (f = fragmentByStart[end]) {
	        delete fragmentByStart[f.start];
	        f.unshift(i);
	        f.start = start;
	        if (g = fragmentByEnd[start]) {
	          delete fragmentByEnd[g.end];
	          var gf = g === f ? f : g.concat(f);
	          fragmentByStart[gf.start = g.start] = fragmentByEnd[gf.end = f.end] = gf;
	        } else {
	          fragmentByStart[f.start] = fragmentByEnd[f.end] = f;
	        }
	      } else {
	        f = [i];
	        fragmentByStart[f.start = start] = fragmentByEnd[f.end = end] = f;
	      }
	    });
	
	    function ends(i) {
	      var arc = topology.arcs[i < 0 ? ~i : i], p0 = arc[0], p1;
	      if (topology.transform) p1 = [0, 0], arc.forEach(function(dp) { p1[0] += dp[0], p1[1] += dp[1]; });
	      else p1 = arc[arc.length - 1];
	      return i < 0 ? [p1, p0] : [p0, p1];
	    }
	
	    function flush(fragmentByEnd, fragmentByStart) {
	      for (var k in fragmentByEnd) {
	        var f = fragmentByEnd[k];
	        delete fragmentByStart[f.start];
	        delete f.start;
	        delete f.end;
	        f.forEach(function(i) { stitchedArcs[i < 0 ? ~i : i] = 1; });
	        fragments.push(f);
	      }
	    }
	
	    flush(fragmentByEnd, fragmentByStart);
	    flush(fragmentByStart, fragmentByEnd);
	    arcs.forEach(function(i) { if (!stitchedArcs[i < 0 ? ~i : i]) fragments.push([i]); });
	
	    return fragments;
	  }
	
	  function mesh(topology) {
	    return object(topology, meshArcs.apply(this, arguments));
	  }
	
	  function meshArcs(topology, o, filter) {
	    var arcs = [];
	
	    function arc(i) {
	      var j = i < 0 ? ~i : i;
	      (geomsByArc[j] || (geomsByArc[j] = [])).push({i: i, g: geom});
	    }
	
	    function line(arcs) {
	      arcs.forEach(arc);
	    }
	
	    function polygon(arcs) {
	      arcs.forEach(line);
	    }
	
	    function geometry(o) {
	      if (o.type === "GeometryCollection") o.geometries.forEach(geometry);
	      else if (o.type in geometryType) geom = o, geometryType[o.type](o.arcs);
	    }
	
	    if (arguments.length > 1) {
	      var geomsByArc = [],
	          geom;
	
	      var geometryType = {
	        LineString: line,
	        MultiLineString: polygon,
	        Polygon: polygon,
	        MultiPolygon: function(arcs) { arcs.forEach(polygon); }
	      };
	
	      geometry(o);
	
	      geomsByArc.forEach(arguments.length < 3
	          ? function(geoms) { arcs.push(geoms[0].i); }
	          : function(geoms) { if (filter(geoms[0].g, geoms[geoms.length - 1].g)) arcs.push(geoms[0].i); });
	    } else {
	      for (var i = 0, n = topology.arcs.length; i < n; ++i) arcs.push(i);
	    }
	
	    return {type: "MultiLineString", arcs: stitchArcs(topology, arcs)};
	  }
	
	  function cartesianTriangleArea(triangle) {
	    var a = triangle[0], b = triangle[1], c = triangle[2];
	    return Math.abs((a[0] - c[0]) * (b[1] - a[1]) - (a[0] - b[0]) * (c[1] - a[1]));
	  }
	
	  function ring(ring) {
	    var i = -1,
	        n = ring.length,
	        a,
	        b = ring[n - 1],
	        area = 0;
	
	    while (++i < n) {
	      a = b;
	      b = ring[i];
	      area += a[0] * b[1] - a[1] * b[0];
	    }
	
	    return area / 2;
	  }
	
	  function merge(topology) {
	    return object(topology, mergeArcs.apply(this, arguments));
	  }
	
	  function mergeArcs(topology, objects) {
	    var polygonsByArc = {},
	        polygons = [],
	        components = [];
	
	    objects.forEach(function(o) {
	      if (o.type === "Polygon") register(o.arcs);
	      else if (o.type === "MultiPolygon") o.arcs.forEach(register);
	    });
	
	    function register(polygon) {
	      polygon.forEach(function(ring$$) {
	        ring$$.forEach(function(arc) {
	          (polygonsByArc[arc = arc < 0 ? ~arc : arc] || (polygonsByArc[arc] = [])).push(polygon);
	        });
	      });
	      polygons.push(polygon);
	    }
	
	    function area(ring$$) {
	      return Math.abs(ring(object(topology, {type: "Polygon", arcs: [ring$$]}).coordinates[0]));
	    }
	
	    polygons.forEach(function(polygon) {
	      if (!polygon._) {
	        var component = [],
	            neighbors = [polygon];
	        polygon._ = 1;
	        components.push(component);
	        while (polygon = neighbors.pop()) {
	          component.push(polygon);
	          polygon.forEach(function(ring$$) {
	            ring$$.forEach(function(arc) {
	              polygonsByArc[arc < 0 ? ~arc : arc].forEach(function(polygon) {
	                if (!polygon._) {
	                  polygon._ = 1;
	                  neighbors.push(polygon);
	                }
	              });
	            });
	          });
	        }
	      }
	    });
	
	    polygons.forEach(function(polygon) {
	      delete polygon._;
	    });
	
	    return {
	      type: "MultiPolygon",
	      arcs: components.map(function(polygons) {
	        var arcs = [], n;
	
	        // Extract the exterior (unique) arcs.
	        polygons.forEach(function(polygon) {
	          polygon.forEach(function(ring$$) {
	            ring$$.forEach(function(arc) {
	              if (polygonsByArc[arc < 0 ? ~arc : arc].length < 2) {
	                arcs.push(arc);
	              }
	            });
	          });
	        });
	
	        // Stitch the arcs into one or more rings.
	        arcs = stitchArcs(topology, arcs);
	
	        // If more than one ring is returned,
	        // at most one of these rings can be the exterior;
	        // choose the one with the greatest absolute area.
	        if ((n = arcs.length) > 1) {
	          for (var i = 1, k = area(arcs[0]), ki, t; i < n; ++i) {
	            if ((ki = area(arcs[i])) > k) {
	              t = arcs[0], arcs[0] = arcs[i], arcs[i] = t, k = ki;
	            }
	          }
	        }
	
	        return arcs;
	      })
	    };
	  }
	
	  function neighbors(objects) {
	    var indexesByArc = {}, // arc index -> array of object indexes
	        neighbors = objects.map(function() { return []; });
	
	    function line(arcs, i) {
	      arcs.forEach(function(a) {
	        if (a < 0) a = ~a;
	        var o = indexesByArc[a];
	        if (o) o.push(i);
	        else indexesByArc[a] = [i];
	      });
	    }
	
	    function polygon(arcs, i) {
	      arcs.forEach(function(arc) { line(arc, i); });
	    }
	
	    function geometry(o, i) {
	      if (o.type === "GeometryCollection") o.geometries.forEach(function(o) { geometry(o, i); });
	      else if (o.type in geometryType) geometryType[o.type](o.arcs, i);
	    }
	
	    var geometryType = {
	      LineString: line,
	      MultiLineString: polygon,
	      Polygon: polygon,
	      MultiPolygon: function(arcs, i) { arcs.forEach(function(arc) { polygon(arc, i); }); }
	    };
	
	    objects.forEach(geometry);
	
	    for (var i in indexesByArc) {
	      for (var indexes = indexesByArc[i], m = indexes.length, j = 0; j < m; ++j) {
	        for (var k = j + 1; k < m; ++k) {
	          var ij = indexes[j], ik = indexes[k], n;
	          if ((n = neighbors[ij])[i = bisect(n, ik)] !== ik) n.splice(i, 0, ik);
	          if ((n = neighbors[ik])[i = bisect(n, ij)] !== ij) n.splice(i, 0, ij);
	        }
	      }
	    }
	
	    return neighbors;
	  }
	
	  function compareArea(a, b) {
	    return a[1][2] - b[1][2];
	  }
	
	  function minAreaHeap() {
	    var heap = {},
	        array = [],
	        size = 0;
	
	    heap.push = function(object) {
	      up(array[object._ = size] = object, size++);
	      return size;
	    };
	
	    heap.pop = function() {
	      if (size <= 0) return;
	      var removed = array[0], object;
	      if (--size > 0) object = array[size], down(array[object._ = 0] = object, 0);
	      return removed;
	    };
	
	    heap.remove = function(removed) {
	      var i = removed._, object;
	      if (array[i] !== removed) return; // invalid request
	      if (i !== --size) object = array[size], (compareArea(object, removed) < 0 ? up : down)(array[object._ = i] = object, i);
	      return i;
	    };
	
	    function up(object, i) {
	      while (i > 0) {
	        var j = ((i + 1) >> 1) - 1,
	            parent = array[j];
	        if (compareArea(object, parent) >= 0) break;
	        array[parent._ = i] = parent;
	        array[object._ = i = j] = object;
	      }
	    }
	
	    function down(object, i) {
	      while (true) {
	        var r = (i + 1) << 1,
	            l = r - 1,
	            j = i,
	            child = array[j];
	        if (l < size && compareArea(array[l], child) < 0) child = array[j = l];
	        if (r < size && compareArea(array[r], child) < 0) child = array[j = r];
	        if (j === i) break;
	        array[child._ = i] = child;
	        array[object._ = i = j] = object;
	      }
	    }
	
	    return heap;
	  }
	
	  function presimplify(topology, triangleArea) {
	    var absolute = transformAbsolute(topology.transform),
	        relative = transformRelative(topology.transform),
	        heap = minAreaHeap();
	
	    if (!triangleArea) triangleArea = cartesianTriangleArea;
	
	    topology.arcs.forEach(function(arc) {
	      var triangles = [],
	          maxArea = 0,
	          triangle,
	          i,
	          n,
	          p;
	
	      // To store each point’s effective area, we create a new array rather than
	      // extending the passed-in point to workaround a Chrome/V8 bug (getting
	      // stuck in smi mode). For midpoints, the initial effective area of
	      // Infinity will be computed in the next step.
	      for (i = 0, n = arc.length; i < n; ++i) {
	        p = arc[i];
	        absolute(arc[i] = [p[0], p[1], Infinity], i);
	      }
	
	      for (i = 1, n = arc.length - 1; i < n; ++i) {
	        triangle = arc.slice(i - 1, i + 2);
	        triangle[1][2] = triangleArea(triangle);
	        triangles.push(triangle);
	        heap.push(triangle);
	      }
	
	      for (i = 0, n = triangles.length; i < n; ++i) {
	        triangle = triangles[i];
	        triangle.previous = triangles[i - 1];
	        triangle.next = triangles[i + 1];
	      }
	
	      while (triangle = heap.pop()) {
	        var previous = triangle.previous,
	            next = triangle.next;
	
	        // If the area of the current point is less than that of the previous point
	        // to be eliminated, use the latter's area instead. This ensures that the
	        // current point cannot be eliminated without eliminating previously-
	        // eliminated points.
	        if (triangle[1][2] < maxArea) triangle[1][2] = maxArea;
	        else maxArea = triangle[1][2];
	
	        if (previous) {
	          previous.next = next;
	          previous[2] = triangle[2];
	          update(previous);
	        }
	
	        if (next) {
	          next.previous = previous;
	          next[0] = triangle[0];
	          update(next);
	        }
	      }
	
	      arc.forEach(relative);
	    });
	
	    function update(triangle) {
	      heap.remove(triangle);
	      triangle[1][2] = triangleArea(triangle);
	      heap.push(triangle);
	    }
	
	    return topology;
	  }
	
	  var version = "1.6.26";
	
	  exports.version = version;
	  exports.mesh = mesh;
	  exports.meshArcs = meshArcs;
	  exports.merge = merge;
	  exports.mergeArcs = mergeArcs;
	  exports.feature = feature;
	  exports.neighbors = neighbors;
	  exports.presimplify = presimplify;
	
	}));

/***/ },
/* 31 */
/***/ function(module, exports, __webpack_require__) {

	var json = __webpack_require__(28);
	
	module.exports = function(tree, format) {
	  return toTable(json(tree, format), format);
	};
	
	function toTable(root, fields) {
	  var childrenField = fields && fields.children || 'children',
	      parentField = fields && fields.parent || 'parent',
	      table = [];
	
	  function visit(node, parent) {
	    node[parentField] = parent;
	    table.push(node);
	    var children = node[childrenField];
	    if (children) {
	      for (var i=0; i<children.length; ++i) {
	        visit(children[i], node);
	      }
	    }
	  }
	
	  visit(root, null);
	  return (table.root = root, table);
	}


/***/ },
/* 32 */
/***/ function(module, exports, __webpack_require__) {

	var util = __webpack_require__(13),
	    d3_time = __webpack_require__(33),
	    d3_timeF = __webpack_require__(34),
	    d3_numberF = __webpack_require__(35),
	    numberF = d3_numberF, // defaults to EN-US
	    timeF = d3_timeF,     // defaults to EN-US
	    tmpDate = new Date(2000, 0, 1),
	    monthFull, monthAbbr, dayFull, dayAbbr;
	
	
	module.exports = {
	  // Update number formatter to use provided locale configuration.
	  // For more see https://github.com/d3/d3-format
	  numberLocale: numberLocale,
	  number:       function(f) { return numberF.format(f); },
	  numberPrefix: function(f, v) { return numberF.formatPrefix(f, v); },
	
	  // Update time formatter to use provided locale configuration.
	  // For more see https://github.com/d3/d3-time-format
	  timeLocale:   timeLocale,
	  time:         function(f) { return timeF.format(f); },
	  utc:          function(f) { return timeF.utcFormat(f); },
	
	  // Set number and time locale simultaneously.
	  locale:       function(l) { numberLocale(l); timeLocale(l); },
	
	  // automatic formatting functions
	  auto: {
	    number:   autoNumberFormat,
	    linear:   linearNumberFormat,
	    time:     function() { return timeAutoFormat(); },
	    utc:      function() { return utcAutoFormat(); }
	  },
	
	  month:    monthFormat,  // format month name from integer code
	  day:      dayFormat,    // format week day name from integer code
	  quarter:  quarterFormat // format quarter number from integer code
	};
	
	// -- Locales ----
	
	// transform 'en-US' style locale string to match d3-format v0.4+ convention
	function localeRef(l) {
	  return l.length > 4 && 'locale' + (
	    l[0].toUpperCase() + l[1].toLowerCase() +
	    l[3].toUpperCase() + l[4].toLowerCase()
	  );
	}
	
	function numberLocale(l) {
	  var f = util.isString(l) ? d3_numberF[localeRef(l)] : d3_numberF.locale(l);
	  if (f == null) throw Error('Unrecognized locale: ' + l);
	  numberF = f;
	}
	
	function timeLocale(l) {
	  var f = util.isString(l) ? d3_timeF[localeRef(l)] : d3_timeF.locale(l);
	  if (f == null) throw Error('Unrecognized locale: ' + l);
	  timeF = f;
	  monthFull = monthAbbr = dayFull = dayAbbr = null;
	}
	
	// -- Number Formatting ----
	
	var e10 = Math.sqrt(50),
	    e5 = Math.sqrt(10),
	    e2 = Math.sqrt(2);
	
	function linearRange(domain, count) {
	  if (!domain.length) domain = [0];
	  if (count == null) count = 10;
	
	  var start = domain[0],
	      stop = domain[domain.length - 1];
	
	  if (stop < start) { error = stop; stop = start; start = error; }
	
	  var span = (stop - start) || (count = 1, start || stop || 1),
	      step = Math.pow(10, Math.floor(Math.log(span / count) / Math.LN10)),
	      error = span / count / step;
	
	  // Filter ticks to get closer to the desired count.
	  if (error >= e10) step *= 10;
	  else if (error >= e5) step *= 5;
	  else if (error >= e2) step *= 2;
	
	  // Round start and stop values to step interval.
	  return [
	    Math.ceil(start / step) * step,
	    Math.floor(stop / step) * step + step / 2, // inclusive
	    step
	  ];
	}
	
	function trimZero(f, decimal) {
	  return function(x) {
	    var s = f(x),
	        n = s.indexOf(decimal);
	    if (n < 0) return s;
	
	    var idx = rightmostDigit(s, n),
	        end = idx < s.length ? s.slice(idx) : '';
	
	    while (--idx > n) {
	      if (s[idx] !== '0') { ++idx; break; }
	    }
	    return s.slice(0, idx) + end;
	  };
	}
	
	function rightmostDigit(s, n) {
	  var i = s.lastIndexOf('e'), c;
	  if (i > 0) return i;
	  for (i=s.length; --i > n;) {
	    c = s.charCodeAt(i);
	    if (c >= 48 && c <= 57) return i+1; // is digit
	  }
	}
	
	function autoNumberFormat(f) {
	  var decimal = numberF.format('.1f')(1)[1]; // get decimal char
	  if (f == null) f = ',';
	  f = d3_numberF.formatSpecifier(f);
	  if (f.precision == null) f.precision = 12;
	  switch (f.type) {
	    case '%': f.precision -= 2; break;
	    case 'e': f.precision -= 1; break;
	  }
	  return trimZero(numberF.format(f), decimal);
	}
	
	function linearNumberFormat(domain, count, f) {
	  var range = linearRange(domain, count);
	
	  if (f == null) f = ',f';
	
	  switch (f = d3_numberF.formatSpecifier(f), f.type) {
	    case 's': {
	      var value = Math.max(Math.abs(range[0]), Math.abs(range[1]));
	      if (f.precision == null) f.precision = d3_numberF.precisionPrefix(range[2], value);
	      return numberF.formatPrefix(f, value);
	    }
	    case '':
	    case 'e':
	    case 'g':
	    case 'p':
	    case 'r': {
	      if (f.precision == null) f.precision = d3_numberF.precisionRound(range[2], Math.max(Math.abs(range[0]), Math.abs(range[1]))) - (f.type === 'e');
	      break;
	    }
	    case 'f':
	    case '%': {
	      if (f.precision == null) f.precision = d3_numberF.precisionFixed(range[2]) - 2 * (f.type === '%');
	      break;
	    }
	  }
	  return numberF.format(f);
	}
	
	// -- Datetime Formatting ----
	
	function timeAutoFormat() {
	  var f = timeF.format,
	      formatMillisecond = f('.%L'),
	      formatSecond = f(':%S'),
	      formatMinute = f('%I:%M'),
	      formatHour = f('%I %p'),
	      formatDay = f('%a %d'),
	      formatWeek = f('%b %d'),
	      formatMonth = f('%B'),
	      formatYear = f('%Y');
	
	  return function(date) {
	    var d = +date;
	    return (d3_time.second(date) < d ? formatMillisecond
	        : d3_time.minute(date) < d ? formatSecond
	        : d3_time.hour(date) < d ? formatMinute
	        : d3_time.day(date) < d ? formatHour
	        : d3_time.month(date) < d ?
	          (d3_time.week(date) < d ? formatDay : formatWeek)
	        : d3_time.year(date) < d ? formatMonth
	        : formatYear)(date);
	  };
	}
	
	function utcAutoFormat() {
	  var f = timeF.utcFormat,
	      formatMillisecond = f('.%L'),
	      formatSecond = f(':%S'),
	      formatMinute = f('%I:%M'),
	      formatHour = f('%I %p'),
	      formatDay = f('%a %d'),
	      formatWeek = f('%b %d'),
	      formatMonth = f('%B'),
	      formatYear = f('%Y');
	
	  return function(date) {
	    var d = +date;
	    return (d3_time.utcSecond(date) < d ? formatMillisecond
	        : d3_time.utcMinute(date) < d ? formatSecond
	        : d3_time.utcHour(date) < d ? formatMinute
	        : d3_time.utcDay(date) < d ? formatHour
	        : d3_time.utcMonth(date) < d ?
	          (d3_time.utcWeek(date) < d ? formatDay : formatWeek)
	        : d3_time.utcYear(date) < d ? formatMonth
	        : formatYear)(date);
	  };
	}
	
	function monthFormat(month, abbreviate) {
	  var f = abbreviate ?
	    (monthAbbr || (monthAbbr = timeF.format('%b'))) :
	    (monthFull || (monthFull = timeF.format('%B')));
	  return (tmpDate.setMonth(month), f(tmpDate));
	}
	
	function dayFormat(day, abbreviate) {
	  var f = abbreviate ?
	    (dayAbbr || (dayAbbr = timeF.format('%a'))) :
	    (dayFull || (dayFull = timeF.format('%A')));
	  return (tmpDate.setMonth(0), tmpDate.setDate(2 + day), f(tmpDate));
	}
	
	function quarterFormat(month) {
	  return Math.floor(month / 3) + 1;
	}


/***/ },
/* 33 */
/***/ function(module, exports, __webpack_require__) {

	(function (global, factory) {
	   true ? factory(exports) :
	  typeof define === 'function' && define.amd ? define('d3-time', ['exports'], factory) :
	  factory((global.d3_time = {}));
	}(this, function (exports) { 'use strict';
	
	  var t0 = new Date;
	  var t1 = new Date;
	  function newInterval(floori, offseti, count, field) {
	
	    function interval(date) {
	      return floori(date = new Date(+date)), date;
	    }
	
	    interval.floor = interval;
	
	    interval.round = function(date) {
	      var d0 = new Date(+date),
	          d1 = new Date(date - 1);
	      floori(d0), floori(d1), offseti(d1, 1);
	      return date - d0 < d1 - date ? d0 : d1;
	    };
	
	    interval.ceil = function(date) {
	      return floori(date = new Date(date - 1)), offseti(date, 1), date;
	    };
	
	    interval.offset = function(date, step) {
	      return offseti(date = new Date(+date), step == null ? 1 : Math.floor(step)), date;
	    };
	
	    interval.range = function(start, stop, step) {
	      var range = [];
	      start = new Date(start - 1);
	      stop = new Date(+stop);
	      step = step == null ? 1 : Math.floor(step);
	      if (!(start < stop) || !(step > 0)) return range; // also handles Invalid Date
	      offseti(start, 1), floori(start);
	      if (start < stop) range.push(new Date(+start));
	      while (offseti(start, step), floori(start), start < stop) range.push(new Date(+start));
	      return range;
	    };
	
	    interval.filter = function(test) {
	      return newInterval(function(date) {
	        while (floori(date), !test(date)) date.setTime(date - 1);
	      }, function(date, step) {
	        while (--step >= 0) while (offseti(date, 1), !test(date));
	      });
	    };
	
	    if (count) {
	      interval.count = function(start, end) {
	        t0.setTime(+start), t1.setTime(+end);
	        floori(t0), floori(t1);
	        return Math.floor(count(t0, t1));
	      };
	
	      interval.every = function(step) {
	        step = Math.floor(step);
	        return !isFinite(step) || !(step > 0) ? null
	            : !(step > 1) ? interval
	            : interval.filter(field
	                ? function(d) { return field(d) % step === 0; }
	                : function(d) { return interval.count(0, d) % step === 0; });
	      };
	    }
	
	    return interval;
	  };
	
	  var millisecond = newInterval(function() {
	    // noop
	  }, function(date, step) {
	    date.setTime(+date + step);
	  }, function(start, end) {
	    return end - start;
	  });
	
	  // An optimized implementation for this simple case.
	  millisecond.every = function(k) {
	    k = Math.floor(k);
	    if (!isFinite(k) || !(k > 0)) return null;
	    if (!(k > 1)) return millisecond;
	    return newInterval(function(date) {
	      date.setTime(Math.floor(date / k) * k);
	    }, function(date, step) {
	      date.setTime(+date + step * k);
	    }, function(start, end) {
	      return (end - start) / k;
	    });
	  };
	
	  var second = newInterval(function(date) {
	    date.setMilliseconds(0);
	  }, function(date, step) {
	    date.setTime(+date + step * 1e3);
	  }, function(start, end) {
	    return (end - start) / 1e3;
	  }, function(date) {
	    return date.getSeconds();
	  });
	
	  var minute = newInterval(function(date) {
	    date.setSeconds(0, 0);
	  }, function(date, step) {
	    date.setTime(+date + step * 6e4);
	  }, function(start, end) {
	    return (end - start) / 6e4;
	  }, function(date) {
	    return date.getMinutes();
	  });
	
	  var hour = newInterval(function(date) {
	    date.setMinutes(0, 0, 0);
	  }, function(date, step) {
	    date.setTime(+date + step * 36e5);
	  }, function(start, end) {
	    return (end - start) / 36e5;
	  }, function(date) {
	    return date.getHours();
	  });
	
	  var day = newInterval(function(date) {
	    date.setHours(0, 0, 0, 0);
	  }, function(date, step) {
	    date.setDate(date.getDate() + step);
	  }, function(start, end) {
	    return (end - start - (end.getTimezoneOffset() - start.getTimezoneOffset()) * 6e4) / 864e5;
	  }, function(date) {
	    return date.getDate() - 1;
	  });
	
	  function weekday(i) {
	    return newInterval(function(date) {
	      date.setHours(0, 0, 0, 0);
	      date.setDate(date.getDate() - (date.getDay() + 7 - i) % 7);
	    }, function(date, step) {
	      date.setDate(date.getDate() + step * 7);
	    }, function(start, end) {
	      return (end - start - (end.getTimezoneOffset() - start.getTimezoneOffset()) * 6e4) / 6048e5;
	    });
	  }
	
	  var sunday = weekday(0);
	  var monday = weekday(1);
	  var tuesday = weekday(2);
	  var wednesday = weekday(3);
	  var thursday = weekday(4);
	  var friday = weekday(5);
	  var saturday = weekday(6);
	
	  var month = newInterval(function(date) {
	    date.setHours(0, 0, 0, 0);
	    date.setDate(1);
	  }, function(date, step) {
	    date.setMonth(date.getMonth() + step);
	  }, function(start, end) {
	    return end.getMonth() - start.getMonth() + (end.getFullYear() - start.getFullYear()) * 12;
	  }, function(date) {
	    return date.getMonth();
	  });
	
	  var year = newInterval(function(date) {
	    date.setHours(0, 0, 0, 0);
	    date.setMonth(0, 1);
	  }, function(date, step) {
	    date.setFullYear(date.getFullYear() + step);
	  }, function(start, end) {
	    return end.getFullYear() - start.getFullYear();
	  }, function(date) {
	    return date.getFullYear();
	  });
	
	  var utcSecond = newInterval(function(date) {
	    date.setUTCMilliseconds(0);
	  }, function(date, step) {
	    date.setTime(+date + step * 1e3);
	  }, function(start, end) {
	    return (end - start) / 1e3;
	  }, function(date) {
	    return date.getUTCSeconds();
	  });
	
	  var utcMinute = newInterval(function(date) {
	    date.setUTCSeconds(0, 0);
	  }, function(date, step) {
	    date.setTime(+date + step * 6e4);
	  }, function(start, end) {
	    return (end - start) / 6e4;
	  }, function(date) {
	    return date.getUTCMinutes();
	  });
	
	  var utcHour = newInterval(function(date) {
	    date.setUTCMinutes(0, 0, 0);
	  }, function(date, step) {
	    date.setTime(+date + step * 36e5);
	  }, function(start, end) {
	    return (end - start) / 36e5;
	  }, function(date) {
	    return date.getUTCHours();
	  });
	
	  var utcDay = newInterval(function(date) {
	    date.setUTCHours(0, 0, 0, 0);
	  }, function(date, step) {
	    date.setUTCDate(date.getUTCDate() + step);
	  }, function(start, end) {
	    return (end - start) / 864e5;
	  }, function(date) {
	    return date.getUTCDate() - 1;
	  });
	
	  function utcWeekday(i) {
	    return newInterval(function(date) {
	      date.setUTCHours(0, 0, 0, 0);
	      date.setUTCDate(date.getUTCDate() - (date.getUTCDay() + 7 - i) % 7);
	    }, function(date, step) {
	      date.setUTCDate(date.getUTCDate() + step * 7);
	    }, function(start, end) {
	      return (end - start) / 6048e5;
	    });
	  }
	
	  var utcSunday = utcWeekday(0);
	  var utcMonday = utcWeekday(1);
	  var utcTuesday = utcWeekday(2);
	  var utcWednesday = utcWeekday(3);
	  var utcThursday = utcWeekday(4);
	  var utcFriday = utcWeekday(5);
	  var utcSaturday = utcWeekday(6);
	
	  var utcMonth = newInterval(function(date) {
	    date.setUTCHours(0, 0, 0, 0);
	    date.setUTCDate(1);
	  }, function(date, step) {
	    date.setUTCMonth(date.getUTCMonth() + step);
	  }, function(start, end) {
	    return end.getUTCMonth() - start.getUTCMonth() + (end.getUTCFullYear() - start.getUTCFullYear()) * 12;
	  }, function(date) {
	    return date.getUTCMonth();
	  });
	
	  var utcYear = newInterval(function(date) {
	    date.setUTCHours(0, 0, 0, 0);
	    date.setUTCMonth(0, 1);
	  }, function(date, step) {
	    date.setUTCFullYear(date.getUTCFullYear() + step);
	  }, function(start, end) {
	    return end.getUTCFullYear() - start.getUTCFullYear();
	  }, function(date) {
	    return date.getUTCFullYear();
	  });
	
	  var milliseconds = millisecond.range;
	  var seconds = second.range;
	  var minutes = minute.range;
	  var hours = hour.range;
	  var days = day.range;
	  var sundays = sunday.range;
	  var mondays = monday.range;
	  var tuesdays = tuesday.range;
	  var wednesdays = wednesday.range;
	  var thursdays = thursday.range;
	  var fridays = friday.range;
	  var saturdays = saturday.range;
	  var weeks = sunday.range;
	  var months = month.range;
	  var years = year.range;
	
	  var utcMillisecond = millisecond;
	  var utcMilliseconds = milliseconds;
	  var utcSeconds = utcSecond.range;
	  var utcMinutes = utcMinute.range;
	  var utcHours = utcHour.range;
	  var utcDays = utcDay.range;
	  var utcSundays = utcSunday.range;
	  var utcMondays = utcMonday.range;
	  var utcTuesdays = utcTuesday.range;
	  var utcWednesdays = utcWednesday.range;
	  var utcThursdays = utcThursday.range;
	  var utcFridays = utcFriday.range;
	  var utcSaturdays = utcSaturday.range;
	  var utcWeeks = utcSunday.range;
	  var utcMonths = utcMonth.range;
	  var utcYears = utcYear.range;
	
	  var version = "0.1.1";
	
	  exports.version = version;
	  exports.milliseconds = milliseconds;
	  exports.seconds = seconds;
	  exports.minutes = minutes;
	  exports.hours = hours;
	  exports.days = days;
	  exports.sundays = sundays;
	  exports.mondays = mondays;
	  exports.tuesdays = tuesdays;
	  exports.wednesdays = wednesdays;
	  exports.thursdays = thursdays;
	  exports.fridays = fridays;
	  exports.saturdays = saturdays;
	  exports.weeks = weeks;
	  exports.months = months;
	  exports.years = years;
	  exports.utcMillisecond = utcMillisecond;
	  exports.utcMilliseconds = utcMilliseconds;
	  exports.utcSeconds = utcSeconds;
	  exports.utcMinutes = utcMinutes;
	  exports.utcHours = utcHours;
	  exports.utcDays = utcDays;
	  exports.utcSundays = utcSundays;
	  exports.utcMondays = utcMondays;
	  exports.utcTuesdays = utcTuesdays;
	  exports.utcWednesdays = utcWednesdays;
	  exports.utcThursdays = utcThursdays;
	  exports.utcFridays = utcFridays;
	  exports.utcSaturdays = utcSaturdays;
	  exports.utcWeeks = utcWeeks;
	  exports.utcMonths = utcMonths;
	  exports.utcYears = utcYears;
	  exports.millisecond = millisecond;
	  exports.second = second;
	  exports.minute = minute;
	  exports.hour = hour;
	  exports.day = day;
	  exports.sunday = sunday;
	  exports.monday = monday;
	  exports.tuesday = tuesday;
	  exports.wednesday = wednesday;
	  exports.thursday = thursday;
	  exports.friday = friday;
	  exports.saturday = saturday;
	  exports.week = sunday;
	  exports.month = month;
	  exports.year = year;
	  exports.utcSecond = utcSecond;
	  exports.utcMinute = utcMinute;
	  exports.utcHour = utcHour;
	  exports.utcDay = utcDay;
	  exports.utcSunday = utcSunday;
	  exports.utcMonday = utcMonday;
	  exports.utcTuesday = utcTuesday;
	  exports.utcWednesday = utcWednesday;
	  exports.utcThursday = utcThursday;
	  exports.utcFriday = utcFriday;
	  exports.utcSaturday = utcSaturday;
	  exports.utcWeek = utcSunday;
	  exports.utcMonth = utcMonth;
	  exports.utcYear = utcYear;
	  exports.interval = newInterval;
	
	}));

/***/ },
/* 34 */
/***/ function(module, exports, __webpack_require__) {

	(function (global, factory) {
	   true ? factory(exports, __webpack_require__(33)) :
	  typeof define === 'function' && define.amd ? define('d3-time-format', ['exports', 'd3-time'], factory) :
	  factory((global.d3_time_format = {}),global.d3_time);
	}(this, function (exports,d3Time) { 'use strict';
	
	  function localDate(d) {
	    if (0 <= d.y && d.y < 100) {
	      var date = new Date(-1, d.m, d.d, d.H, d.M, d.S, d.L);
	      date.setFullYear(d.y);
	      return date;
	    }
	    return new Date(d.y, d.m, d.d, d.H, d.M, d.S, d.L);
	  }
	
	  function utcDate(d) {
	    if (0 <= d.y && d.y < 100) {
	      var date = new Date(Date.UTC(-1, d.m, d.d, d.H, d.M, d.S, d.L));
	      date.setUTCFullYear(d.y);
	      return date;
	    }
	    return new Date(Date.UTC(d.y, d.m, d.d, d.H, d.M, d.S, d.L));
	  }
	
	  function newYear(y) {
	    return {y: y, m: 0, d: 1, H: 0, M: 0, S: 0, L: 0};
	  }
	
	  function locale$1(locale) {
	    var locale_dateTime = locale.dateTime,
	        locale_date = locale.date,
	        locale_time = locale.time,
	        locale_periods = locale.periods,
	        locale_weekdays = locale.days,
	        locale_shortWeekdays = locale.shortDays,
	        locale_months = locale.months,
	        locale_shortMonths = locale.shortMonths;
	
	    var periodRe = formatRe(locale_periods),
	        periodLookup = formatLookup(locale_periods),
	        weekdayRe = formatRe(locale_weekdays),
	        weekdayLookup = formatLookup(locale_weekdays),
	        shortWeekdayRe = formatRe(locale_shortWeekdays),
	        shortWeekdayLookup = formatLookup(locale_shortWeekdays),
	        monthRe = formatRe(locale_months),
	        monthLookup = formatLookup(locale_months),
	        shortMonthRe = formatRe(locale_shortMonths),
	        shortMonthLookup = formatLookup(locale_shortMonths);
	
	    var formats = {
	      "a": formatShortWeekday,
	      "A": formatWeekday,
	      "b": formatShortMonth,
	      "B": formatMonth,
	      "c": null,
	      "d": formatDayOfMonth,
	      "e": formatDayOfMonth,
	      "H": formatHour24,
	      "I": formatHour12,
	      "j": formatDayOfYear,
	      "L": formatMilliseconds,
	      "m": formatMonthNumber,
	      "M": formatMinutes,
	      "p": formatPeriod,
	      "S": formatSeconds,
	      "U": formatWeekNumberSunday,
	      "w": formatWeekdayNumber,
	      "W": formatWeekNumberMonday,
	      "x": null,
	      "X": null,
	      "y": formatYear,
	      "Y": formatFullYear,
	      "Z": formatZone,
	      "%": formatLiteralPercent
	    };
	
	    var utcFormats = {
	      "a": formatUTCShortWeekday,
	      "A": formatUTCWeekday,
	      "b": formatUTCShortMonth,
	      "B": formatUTCMonth,
	      "c": null,
	      "d": formatUTCDayOfMonth,
	      "e": formatUTCDayOfMonth,
	      "H": formatUTCHour24,
	      "I": formatUTCHour12,
	      "j": formatUTCDayOfYear,
	      "L": formatUTCMilliseconds,
	      "m": formatUTCMonthNumber,
	      "M": formatUTCMinutes,
	      "p": formatUTCPeriod,
	      "S": formatUTCSeconds,
	      "U": formatUTCWeekNumberSunday,
	      "w": formatUTCWeekdayNumber,
	      "W": formatUTCWeekNumberMonday,
	      "x": null,
	      "X": null,
	      "y": formatUTCYear,
	      "Y": formatUTCFullYear,
	      "Z": formatUTCZone,
	      "%": formatLiteralPercent
	    };
	
	    var parses = {
	      "a": parseShortWeekday,
	      "A": parseWeekday,
	      "b": parseShortMonth,
	      "B": parseMonth,
	      "c": parseLocaleDateTime,
	      "d": parseDayOfMonth,
	      "e": parseDayOfMonth,
	      "H": parseHour24,
	      "I": parseHour24,
	      "j": parseDayOfYear,
	      "L": parseMilliseconds,
	      "m": parseMonthNumber,
	      "M": parseMinutes,
	      "p": parsePeriod,
	      "S": parseSeconds,
	      "U": parseWeekNumberSunday,
	      "w": parseWeekdayNumber,
	      "W": parseWeekNumberMonday,
	      "x": parseLocaleDate,
	      "X": parseLocaleTime,
	      "y": parseYear,
	      "Y": parseFullYear,
	      "Z": parseZone,
	      "%": parseLiteralPercent
	    };
	
	    // These recursive directive definitions must be deferred.
	    formats.x = newFormat(locale_date, formats);
	    formats.X = newFormat(locale_time, formats);
	    formats.c = newFormat(locale_dateTime, formats);
	    utcFormats.x = newFormat(locale_date, utcFormats);
	    utcFormats.X = newFormat(locale_time, utcFormats);
	    utcFormats.c = newFormat(locale_dateTime, utcFormats);
	
	    function newFormat(specifier, formats) {
	      return function(date) {
	        var string = [],
	            i = -1,
	            j = 0,
	            n = specifier.length,
	            c,
	            pad,
	            format;
	
	        if (!(date instanceof Date)) date = new Date(+date);
	
	        while (++i < n) {
	          if (specifier.charCodeAt(i) === 37) {
	            string.push(specifier.slice(j, i));
	            if ((pad = pads[c = specifier.charAt(++i)]) != null) c = specifier.charAt(++i);
	            else pad = c === "e" ? " " : "0";
	            if (format = formats[c]) c = format(date, pad);
	            string.push(c);
	            j = i + 1;
	          }
	        }
	
	        string.push(specifier.slice(j, i));
	        return string.join("");
	      };
	    }
	
	    function newParse(specifier, newDate) {
	      return function(string) {
	        var d = newYear(1900),
	            i = parseSpecifier(d, specifier, string += "", 0);
	        if (i != string.length) return null;
	
	        // The am-pm flag is 0 for AM, and 1 for PM.
	        if ("p" in d) d.H = d.H % 12 + d.p * 12;
	
	        // Convert day-of-week and week-of-year to day-of-year.
	        if ("W" in d || "U" in d) {
	          if (!("w" in d)) d.w = "W" in d ? 1 : 0;
	          var day = "Z" in d ? utcDate(newYear(d.y)).getUTCDay() : newDate(newYear(d.y)).getDay();
	          d.m = 0;
	          d.d = "W" in d ? (d.w + 6) % 7 + d.W * 7 - (day + 5) % 7 : d.w + d.U * 7 - (day + 6) % 7;
	        }
	
	        // If a time zone is specified, all fields are interpreted as UTC and then
	        // offset according to the specified time zone.
	        if ("Z" in d) {
	          d.H += d.Z / 100 | 0;
	          d.M += d.Z % 100;
	          return utcDate(d);
	        }
	
	        // Otherwise, all fields are in local time.
	        return newDate(d);
	      };
	    }
	
	    function parseSpecifier(d, specifier, string, j) {
	      var i = 0,
	          n = specifier.length,
	          m = string.length,
	          c,
	          parse;
	
	      while (i < n) {
	        if (j >= m) return -1;
	        c = specifier.charCodeAt(i++);
	        if (c === 37) {
	          c = specifier.charAt(i++);
	          parse = parses[c in pads ? specifier.charAt(i++) : c];
	          if (!parse || ((j = parse(d, string, j)) < 0)) return -1;
	        } else if (c != string.charCodeAt(j++)) {
	          return -1;
	        }
	      }
	
	      return j;
	    }
	
	    function parsePeriod(d, string, i) {
	      var n = periodRe.exec(string.slice(i));
	      return n ? (d.p = periodLookup[n[0].toLowerCase()], i + n[0].length) : -1;
	    }
	
	    function parseShortWeekday(d, string, i) {
	      var n = shortWeekdayRe.exec(string.slice(i));
	      return n ? (d.w = shortWeekdayLookup[n[0].toLowerCase()], i + n[0].length) : -1;
	    }
	
	    function parseWeekday(d, string, i) {
	      var n = weekdayRe.exec(string.slice(i));
	      return n ? (d.w = weekdayLookup[n[0].toLowerCase()], i + n[0].length) : -1;
	    }
	
	    function parseShortMonth(d, string, i) {
	      var n = shortMonthRe.exec(string.slice(i));
	      return n ? (d.m = shortMonthLookup[n[0].toLowerCase()], i + n[0].length) : -1;
	    }
	
	    function parseMonth(d, string, i) {
	      var n = monthRe.exec(string.slice(i));
	      return n ? (d.m = monthLookup[n[0].toLowerCase()], i + n[0].length) : -1;
	    }
	
	    function parseLocaleDateTime(d, string, i) {
	      return parseSpecifier(d, locale_dateTime, string, i);
	    }
	
	    function parseLocaleDate(d, string, i) {
	      return parseSpecifier(d, locale_date, string, i);
	    }
	
	    function parseLocaleTime(d, string, i) {
	      return parseSpecifier(d, locale_time, string, i);
	    }
	
	    function formatShortWeekday(d) {
	      return locale_shortWeekdays[d.getDay()];
	    }
	
	    function formatWeekday(d) {
	      return locale_weekdays[d.getDay()];
	    }
	
	    function formatShortMonth(d) {
	      return locale_shortMonths[d.getMonth()];
	    }
	
	    function formatMonth(d) {
	      return locale_months[d.getMonth()];
	    }
	
	    function formatPeriod(d) {
	      return locale_periods[+(d.getHours() >= 12)];
	    }
	
	    function formatUTCShortWeekday(d) {
	      return locale_shortWeekdays[d.getUTCDay()];
	    }
	
	    function formatUTCWeekday(d) {
	      return locale_weekdays[d.getUTCDay()];
	    }
	
	    function formatUTCShortMonth(d) {
	      return locale_shortMonths[d.getUTCMonth()];
	    }
	
	    function formatUTCMonth(d) {
	      return locale_months[d.getUTCMonth()];
	    }
	
	    function formatUTCPeriod(d) {
	      return locale_periods[+(d.getUTCHours() >= 12)];
	    }
	
	    return {
	      format: function(specifier) {
	        var f = newFormat(specifier += "", formats);
	        f.parse = newParse(specifier, localDate);
	        f.toString = function() { return specifier; };
	        return f;
	      },
	      utcFormat: function(specifier) {
	        var f = newFormat(specifier += "", utcFormats);
	        f.parse = newParse(specifier, utcDate);
	        f.toString = function() { return specifier; };
	        return f;
	      }
	    };
	  };
	
	  var pads = {"-": "", "_": " ", "0": "0"};
	  var numberRe = /^\s*\d+/;
	  var percentRe = /^%/;
	  var requoteRe = /[\\\^\$\*\+\?\|\[\]\(\)\.\{\}]/g;
	  function pad(value, fill, width) {
	    var sign = value < 0 ? "-" : "",
	        string = (sign ? -value : value) + "",
	        length = string.length;
	    return sign + (length < width ? new Array(width - length + 1).join(fill) + string : string);
	  }
	
	  function requote(s) {
	    return s.replace(requoteRe, "\\$&");
	  }
	
	  function formatRe(names) {
	    return new RegExp("^(?:" + names.map(requote).join("|") + ")", "i");
	  }
	
	  function formatLookup(names) {
	    var map = {}, i = -1, n = names.length;
	    while (++i < n) map[names[i].toLowerCase()] = i;
	    return map;
	  }
	
	  function parseWeekdayNumber(d, string, i) {
	    var n = numberRe.exec(string.slice(i, i + 1));
	    return n ? (d.w = +n[0], i + n[0].length) : -1;
	  }
	
	  function parseWeekNumberSunday(d, string, i) {
	    var n = numberRe.exec(string.slice(i));
	    return n ? (d.U = +n[0], i + n[0].length) : -1;
	  }
	
	  function parseWeekNumberMonday(d, string, i) {
	    var n = numberRe.exec(string.slice(i));
	    return n ? (d.W = +n[0], i + n[0].length) : -1;
	  }
	
	  function parseFullYear(d, string, i) {
	    var n = numberRe.exec(string.slice(i, i + 4));
	    return n ? (d.y = +n[0], i + n[0].length) : -1;
	  }
	
	  function parseYear(d, string, i) {
	    var n = numberRe.exec(string.slice(i, i + 2));
	    return n ? (d.y = +n[0] + (+n[0] > 68 ? 1900 : 2000), i + n[0].length) : -1;
	  }
	
	  function parseZone(d, string, i) {
	    var n = /^(Z)|([+-]\d\d)(?:\:?(\d\d))?/.exec(string.slice(i, i + 6));
	    return n ? (d.Z = n[1] ? 0 : -(n[2] + (n[3] || "00")), i + n[0].length) : -1;
	  }
	
	  function parseMonthNumber(d, string, i) {
	    var n = numberRe.exec(string.slice(i, i + 2));
	    return n ? (d.m = n[0] - 1, i + n[0].length) : -1;
	  }
	
	  function parseDayOfMonth(d, string, i) {
	    var n = numberRe.exec(string.slice(i, i + 2));
	    return n ? (d.d = +n[0], i + n[0].length) : -1;
	  }
	
	  function parseDayOfYear(d, string, i) {
	    var n = numberRe.exec(string.slice(i, i + 3));
	    return n ? (d.m = 0, d.d = +n[0], i + n[0].length) : -1;
	  }
	
	  function parseHour24(d, string, i) {
	    var n = numberRe.exec(string.slice(i, i + 2));
	    return n ? (d.H = +n[0], i + n[0].length) : -1;
	  }
	
	  function parseMinutes(d, string, i) {
	    var n = numberRe.exec(string.slice(i, i + 2));
	    return n ? (d.M = +n[0], i + n[0].length) : -1;
	  }
	
	  function parseSeconds(d, string, i) {
	    var n = numberRe.exec(string.slice(i, i + 2));
	    return n ? (d.S = +n[0], i + n[0].length) : -1;
	  }
	
	  function parseMilliseconds(d, string, i) {
	    var n = numberRe.exec(string.slice(i, i + 3));
	    return n ? (d.L = +n[0], i + n[0].length) : -1;
	  }
	
	  function parseLiteralPercent(d, string, i) {
	    var n = percentRe.exec(string.slice(i, i + 1));
	    return n ? i + n[0].length : -1;
	  }
	
	  function formatDayOfMonth(d, p) {
	    return pad(d.getDate(), p, 2);
	  }
	
	  function formatHour24(d, p) {
	    return pad(d.getHours(), p, 2);
	  }
	
	  function formatHour12(d, p) {
	    return pad(d.getHours() % 12 || 12, p, 2);
	  }
	
	  function formatDayOfYear(d, p) {
	    return pad(1 + d3Time.day.count(d3Time.year(d), d), p, 3);
	  }
	
	  function formatMilliseconds(d, p) {
	    return pad(d.getMilliseconds(), p, 3);
	  }
	
	  function formatMonthNumber(d, p) {
	    return pad(d.getMonth() + 1, p, 2);
	  }
	
	  function formatMinutes(d, p) {
	    return pad(d.getMinutes(), p, 2);
	  }
	
	  function formatSeconds(d, p) {
	    return pad(d.getSeconds(), p, 2);
	  }
	
	  function formatWeekNumberSunday(d, p) {
	    return pad(d3Time.sunday.count(d3Time.year(d), d), p, 2);
	  }
	
	  function formatWeekdayNumber(d) {
	    return d.getDay();
	  }
	
	  function formatWeekNumberMonday(d, p) {
	    return pad(d3Time.monday.count(d3Time.year(d), d), p, 2);
	  }
	
	  function formatYear(d, p) {
	    return pad(d.getFullYear() % 100, p, 2);
	  }
	
	  function formatFullYear(d, p) {
	    return pad(d.getFullYear() % 10000, p, 4);
	  }
	
	  function formatZone(d) {
	    var z = d.getTimezoneOffset();
	    return (z > 0 ? "-" : (z *= -1, "+"))
	        + pad(z / 60 | 0, "0", 2)
	        + pad(z % 60, "0", 2);
	  }
	
	  function formatUTCDayOfMonth(d, p) {
	    return pad(d.getUTCDate(), p, 2);
	  }
	
	  function formatUTCHour24(d, p) {
	    return pad(d.getUTCHours(), p, 2);
	  }
	
	  function formatUTCHour12(d, p) {
	    return pad(d.getUTCHours() % 12 || 12, p, 2);
	  }
	
	  function formatUTCDayOfYear(d, p) {
	    return pad(1 + d3Time.utcDay.count(d3Time.utcYear(d), d), p, 3);
	  }
	
	  function formatUTCMilliseconds(d, p) {
	    return pad(d.getUTCMilliseconds(), p, 3);
	  }
	
	  function formatUTCMonthNumber(d, p) {
	    return pad(d.getUTCMonth() + 1, p, 2);
	  }
	
	  function formatUTCMinutes(d, p) {
	    return pad(d.getUTCMinutes(), p, 2);
	  }
	
	  function formatUTCSeconds(d, p) {
	    return pad(d.getUTCSeconds(), p, 2);
	  }
	
	  function formatUTCWeekNumberSunday(d, p) {
	    return pad(d3Time.utcSunday.count(d3Time.utcYear(d), d), p, 2);
	  }
	
	  function formatUTCWeekdayNumber(d) {
	    return d.getUTCDay();
	  }
	
	  function formatUTCWeekNumberMonday(d, p) {
	    return pad(d3Time.utcMonday.count(d3Time.utcYear(d), d), p, 2);
	  }
	
	  function formatUTCYear(d, p) {
	    return pad(d.getUTCFullYear() % 100, p, 2);
	  }
	
	  function formatUTCFullYear(d, p) {
	    return pad(d.getUTCFullYear() % 10000, p, 4);
	  }
	
	  function formatUTCZone() {
	    return "+0000";
	  }
	
	  function formatLiteralPercent() {
	    return "%";
	  }
	
	  var locale = locale$1({
	    dateTime: "%a %b %e %X %Y",
	    date: "%m/%d/%Y",
	    time: "%H:%M:%S",
	    periods: ["AM", "PM"],
	    days: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
	    shortDays: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
	    months: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
	    shortMonths: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
	  });
	
	  var caES = locale$1({
	    dateTime: "%A, %e de %B de %Y, %X",
	    date: "%d/%m/%Y",
	    time: "%H:%M:%S",
	    periods: ["AM", "PM"],
	    days: ["diumenge", "dilluns", "dimarts", "dimecres", "dijous", "divendres", "dissabte"],
	    shortDays: ["dg.", "dl.", "dt.", "dc.", "dj.", "dv.", "ds."],
	    months: ["gener", "febrer", "març", "abril", "maig", "juny", "juliol", "agost", "setembre", "octubre", "novembre", "desembre"],
	    shortMonths: ["gen.", "febr.", "març", "abr.", "maig", "juny", "jul.", "ag.", "set.", "oct.", "nov.", "des."]
	  });
	
	  var deCH = locale$1({
	    dateTime: "%A, der %e. %B %Y, %X",
	    date: "%d.%m.%Y",
	    time: "%H:%M:%S",
	    periods: ["AM", "PM"], // unused
	    days: ["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"],
	    shortDays: ["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"],
	    months: ["Januar", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"],
	    shortMonths: ["Jan", "Feb", "Mrz", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"]
	  });
	
	  var deDE = locale$1({
	    dateTime: "%A, der %e. %B %Y, %X",
	    date: "%d.%m.%Y",
	    time: "%H:%M:%S",
	    periods: ["AM", "PM"], // unused
	    days: ["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"],
	    shortDays: ["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"],
	    months: ["Januar", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"],
	    shortMonths: ["Jan", "Feb", "Mrz", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"]
	  });
	
	  var enCA = locale$1({
	    dateTime: "%a %b %e %X %Y",
	    date: "%Y-%m-%d",
	    time: "%H:%M:%S",
	    periods: ["AM", "PM"],
	    days: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
	    shortDays: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
	    months: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
	    shortMonths: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
	  });
	
	  var enGB = locale$1({
	    dateTime: "%a %e %b %X %Y",
	    date: "%d/%m/%Y",
	    time: "%H:%M:%S",
	    periods: ["AM", "PM"],
	    days: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
	    shortDays: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
	    months: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
	    shortMonths: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
	  });
	
	  var esES = locale$1({
	    dateTime: "%A, %e de %B de %Y, %X",
	    date: "%d/%m/%Y",
	    time: "%H:%M:%S",
	    periods: ["AM", "PM"],
	    days: ["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"],
	    shortDays: ["dom", "lun", "mar", "mié", "jue", "vie", "sáb"],
	    months: ["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"],
	    shortMonths: ["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]
	  });
	
	  var fiFI = locale$1({
	    dateTime: "%A, %-d. %Bta %Y klo %X",
	    date: "%-d.%-m.%Y",
	    time: "%H:%M:%S",
	    periods: ["a.m.", "p.m."],
	    days: ["sunnuntai", "maanantai", "tiistai", "keskiviikko", "torstai", "perjantai", "lauantai"],
	    shortDays: ["Su", "Ma", "Ti", "Ke", "To", "Pe", "La"],
	    months: ["tammikuu", "helmikuu", "maaliskuu", "huhtikuu", "toukokuu", "kesäkuu", "heinäkuu", "elokuu", "syyskuu", "lokakuu", "marraskuu", "joulukuu"],
	    shortMonths: ["Tammi", "Helmi", "Maalis", "Huhti", "Touko", "Kesä", "Heinä", "Elo", "Syys", "Loka", "Marras", "Joulu"]
	  });
	
	  var frCA = locale$1({
	    dateTime: "%a %e %b %Y %X",
	    date: "%Y-%m-%d",
	    time: "%H:%M:%S",
	    periods: ["", ""],
	    days: ["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"],
	    shortDays: ["dim", "lun", "mar", "mer", "jeu", "ven", "sam"],
	    months: ["janvier", "février", "mars", "avril", "mai", "juin", "juillet", "août", "septembre", "octobre", "novembre", "décembre"],
	    shortMonths: ["jan", "fév", "mar", "avr", "mai", "jui", "jul", "aoû", "sep", "oct", "nov", "déc"]
	  });
	
	  var frFR = locale$1({
	    dateTime: "%A, le %e %B %Y, %X",
	    date: "%d/%m/%Y",
	    time: "%H:%M:%S",
	    periods: ["AM", "PM"], // unused
	    days: ["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"],
	    shortDays: ["dim.", "lun.", "mar.", "mer.", "jeu.", "ven.", "sam."],
	    months: ["janvier", "février", "mars", "avril", "mai", "juin", "juillet", "août", "septembre", "octobre", "novembre", "décembre"],
	    shortMonths: ["janv.", "févr.", "mars", "avr.", "mai", "juin", "juil.", "août", "sept.", "oct.", "nov.", "déc."]
	  });
	
	  var heIL = locale$1({
	    dateTime: "%A, %e ב%B %Y %X",
	    date: "%d.%m.%Y",
	    time: "%H:%M:%S",
	    periods: ["AM", "PM"],
	    days: ["ראשון", "שני", "שלישי", "רביעי", "חמישי", "שישי", "שבת"],
	    shortDays: ["א׳", "ב׳", "ג׳", "ד׳", "ה׳", "ו׳", "ש׳"],
	    months: ["ינואר", "פברואר", "מרץ", "אפריל", "מאי", "יוני", "יולי", "אוגוסט", "ספטמבר", "אוקטובר", "נובמבר", "דצמבר"],
	    shortMonths: ["ינו׳", "פבר׳", "מרץ", "אפר׳", "מאי", "יוני", "יולי", "אוג׳", "ספט׳", "אוק׳", "נוב׳", "דצמ׳"]
	  });
	
	  var huHU = locale$1({
	    dateTime: "%Y. %B %-e., %A %X",
	    date: "%Y. %m. %d.",
	    time: "%H:%M:%S",
	    periods: ["de.", "du."], // unused
	    days: ["vasárnap", "hétfő", "kedd", "szerda", "csütörtök", "péntek", "szombat"],
	    shortDays: ["V", "H", "K", "Sze", "Cs", "P", "Szo"],
	    months: ["január", "február", "március", "április", "május", "június", "július", "augusztus", "szeptember", "október", "november", "december"],
	    shortMonths: ["jan.", "feb.", "már.", "ápr.", "máj.", "jún.", "júl.", "aug.", "szept.", "okt.", "nov.", "dec."]
	  });
	
	  var itIT = locale$1({
	    dateTime: "%A %e %B %Y, %X",
	    date: "%d/%m/%Y",
	    time: "%H:%M:%S",
	    periods: ["AM", "PM"], // unused
	    days: ["Domenica", "Lunedì", "Martedì", "Mercoledì", "Giovedì", "Venerdì", "Sabato"],
	    shortDays: ["Dom", "Lun", "Mar", "Mer", "Gio", "Ven", "Sab"],
	    months: ["Gennaio", "Febbraio", "Marzo", "Aprile", "Maggio", "Giugno", "Luglio", "Agosto", "Settembre", "Ottobre", "Novembre", "Dicembre"],
	    shortMonths: ["Gen", "Feb", "Mar", "Apr", "Mag", "Giu", "Lug", "Ago", "Set", "Ott", "Nov", "Dic"]
	  });
	
	  var jaJP = locale$1({
	    dateTime: "%Y %b %e %a %X",
	    date: "%Y/%m/%d",
	    time: "%H:%M:%S",
	    periods: ["AM", "PM"],
	    days: ["日曜日", "月曜日", "火曜日", "水曜日", "木曜日", "金曜日", "土曜日"],
	    shortDays: ["日", "月", "火", "水", "木", "金", "土"],
	    months: ["睦月", "如月", "弥生", "卯月", "皐月", "水無月", "文月", "葉月", "長月", "神無月", "霜月", "師走"],
	    shortMonths: ["1月", "2月", "3月", "4月", "5月", "6月", "7月", "8月", "9月", "10月", "11月", "12月"]
	  });
	
	  var koKR = locale$1({
	    dateTime: "%Y/%m/%d %a %X",
	    date: "%Y/%m/%d",
	    time: "%H:%M:%S",
	    periods: ["오전", "오후"],
	    days: ["일요일", "월요일", "화요일", "수요일", "목요일", "금요일", "토요일"],
	    shortDays: ["일", "월", "화", "수", "목", "금", "토"],
	    months: ["1월", "2월", "3월", "4월", "5월", "6월", "7월", "8월", "9월", "10월", "11월", "12월"],
	    shortMonths: ["1월", "2월", "3월", "4월", "5월", "6월", "7월", "8월", "9월", "10월", "11월", "12월"]
	  });
	
	  var mkMK = locale$1({
	    dateTime: "%A, %e %B %Y г. %X",
	    date: "%d.%m.%Y",
	    time: "%H:%M:%S",
	    periods: ["AM", "PM"],
	    days: ["недела", "понеделник", "вторник", "среда", "четврток", "петок", "сабота"],
	    shortDays: ["нед", "пон", "вто", "сре", "чет", "пет", "саб"],
	    months: ["јануари", "февруари", "март", "април", "мај", "јуни", "јули", "август", "септември", "октомври", "ноември", "декември"],
	    shortMonths: ["јан", "фев", "мар", "апр", "мај", "јун", "јул", "авг", "сеп", "окт", "ное", "дек"]
	  });
	
	  var nlNL = locale$1({
	    dateTime: "%a %e %B %Y %T",
	    date: "%d-%m-%Y",
	    time: "%H:%M:%S",
	    periods: ["AM", "PM"], // unused
	    days: ["zondag", "maandag", "dinsdag", "woensdag", "donderdag", "vrijdag", "zaterdag"],
	    shortDays: ["zo", "ma", "di", "wo", "do", "vr", "za"],
	    months: ["januari", "februari", "maart", "april", "mei", "juni", "juli", "augustus", "september", "oktober", "november", "december"],
	    shortMonths: ["jan", "feb", "mrt", "apr", "mei", "jun", "jul", "aug", "sep", "okt", "nov", "dec"]
	  });
	
	  var plPL = locale$1({
	    dateTime: "%A, %e %B %Y, %X",
	    date: "%d/%m/%Y",
	    time: "%H:%M:%S",
	    periods: ["AM", "PM"], // unused
	    days: ["Niedziela", "Poniedziałek", "Wtorek", "Środa", "Czwartek", "Piątek", "Sobota"],
	    shortDays: ["Niedz.", "Pon.", "Wt.", "Śr.", "Czw.", "Pt.", "Sob."],
	    months: ["Styczeń", "Luty", "Marzec", "Kwiecień", "Maj", "Czerwiec", "Lipiec", "Sierpień", "Wrzesień", "Październik", "Listopad", "Grudzień"],
	    shortMonths: ["Stycz.", "Luty", "Marz.", "Kwie.", "Maj", "Czerw.", "Lipc.", "Sierp.", "Wrz.", "Paźdz.", "Listop.", "Grudz."]/* In Polish language abbraviated months are not commonly used so there is a dispute about the proper abbraviations. */
	  });
	
	  var ptBR = locale$1({
	    dateTime: "%A, %e de %B de %Y. %X",
	    date: "%d/%m/%Y",
	    time: "%H:%M:%S",
	    periods: ["AM", "PM"],
	    days: ["Domingo", "Segunda", "Terça", "Quarta", "Quinta", "Sexta", "Sábado"],
	    shortDays: ["Dom", "Seg", "Ter", "Qua", "Qui", "Sex", "Sáb"],
	    months: ["Janeiro", "Fevereiro", "Março", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"],
	    shortMonths: ["Jan", "Fev", "Mar", "Abr", "Mai", "Jun", "Jul", "Ago", "Set", "Out", "Nov", "Dez"]
	  });
	
	  var ruRU = locale$1({
	    dateTime: "%A, %e %B %Y г. %X",
	    date: "%d.%m.%Y",
	    time: "%H:%M:%S",
	    periods: ["AM", "PM"],
	    days: ["воскресенье", "понедельник", "вторник", "среда", "четверг", "пятница", "суббота"],
	    shortDays: ["вс", "пн", "вт", "ср", "чт", "пт", "сб"],
	    months: ["января", "февраля", "марта", "апреля", "мая", "июня", "июля", "августа", "сентября", "октября", "ноября", "декабря"],
	    shortMonths: ["янв", "фев", "мар", "апр", "май", "июн", "июл", "авг", "сен", "окт", "ноя", "дек"]
	  });
	
	  var svSE = locale$1({
	    dateTime: "%A den %d %B %Y %X",
	    date: "%Y-%m-%d",
	    time: "%H:%M:%S",
	    periods: ["fm", "em"],
	    days: ["Söndag", "Måndag", "Tisdag", "Onsdag", "Torsdag", "Fredag", "Lördag"],
	    shortDays: ["Sön", "Mån", "Tis", "Ons", "Tor", "Fre", "Lör"],
	    months: ["Januari", "Februari", "Mars", "April", "Maj", "Juni", "Juli", "Augusti", "September", "Oktober", "November", "December"],
	    shortMonths: ["Jan", "Feb", "Mar", "Apr", "Maj", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dec"]
	  });
	
	  var zhCN = locale$1({
	    dateTime: "%a %b %e %X %Y",
	    date: "%Y/%-m/%-d",
	    time: "%H:%M:%S",
	    periods: ["上午", "下午"],
	    days: ["星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"],
	    shortDays: ["星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"],
	    months: ["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"],
	    shortMonths: ["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"]
	  });
	
	  var isoSpecifier = "%Y-%m-%dT%H:%M:%S.%LZ";
	
	  function formatIsoNative(date) {
	    return date.toISOString();
	  }
	
	  formatIsoNative.parse = function(string) {
	    var date = new Date(string);
	    return isNaN(date) ? null : date;
	  };
	
	  formatIsoNative.toString = function() {
	    return isoSpecifier;
	  };
	
	  var formatIso = Date.prototype.toISOString && +new Date("2000-01-01T00:00:00.000Z")
	      ? formatIsoNative
	      : locale.utcFormat(isoSpecifier);
	
	  var format = locale.format;
	  var utcFormat = locale.utcFormat;
	
	  var version = "0.2.1";
	
	  exports.version = version;
	  exports.format = format;
	  exports.utcFormat = utcFormat;
	  exports.locale = locale$1;
	  exports.localeCaEs = caES;
	  exports.localeDeCh = deCH;
	  exports.localeDeDe = deDE;
	  exports.localeEnCa = enCA;
	  exports.localeEnGb = enGB;
	  exports.localeEnUs = locale;
	  exports.localeEsEs = esES;
	  exports.localeFiFi = fiFI;
	  exports.localeFrCa = frCA;
	  exports.localeFrFr = frFR;
	  exports.localeHeIl = heIL;
	  exports.localeHuHu = huHU;
	  exports.localeItIt = itIT;
	  exports.localeJaJp = jaJP;
	  exports.localeKoKr = koKR;
	  exports.localeMkMk = mkMK;
	  exports.localeNlNl = nlNL;
	  exports.localePlPl = plPL;
	  exports.localePtBr = ptBR;
	  exports.localeRuRu = ruRU;
	  exports.localeSvSe = svSE;
	  exports.localeZhCn = zhCN;
	  exports.isoFormat = formatIso;
	
	}));

/***/ },
/* 35 */
/***/ function(module, exports, __webpack_require__) {

	(function (global, factory) {
	   true ? factory(exports) :
	  typeof define === 'function' && define.amd ? define('d3-format', ['exports'], factory) :
	  factory((global.d3_format = {}));
	}(this, function (exports) { 'use strict';
	
	  // Computes the decimal coefficient and exponent of the specified number x with
	  // significant digits p, where x is positive and p is in [1, 21] or undefined.
	  // For example, formatDecimal(1.23) returns ["123", 0].
	  function formatDecimal(x, p) {
	    if ((i = (x = p ? x.toExponential(p - 1) : x.toExponential()).indexOf("e")) < 0) return null; // NaN, ±Infinity
	    var i, coefficient = x.slice(0, i);
	
	    // The string returned by toExponential either has the form \d\.\d+e[-+]\d+
	    // (e.g., 1.2e+3) or the form \de[-+]\d+ (e.g., 1e+3).
	    return [
	      coefficient.length > 1 ? coefficient[0] + coefficient.slice(2) : coefficient,
	      +x.slice(i + 1)
	    ];
	  };
	
	  function exponent(x) {
	    return x = formatDecimal(Math.abs(x)), x ? x[1] : NaN;
	  };
	
	  function formatGroup(grouping, thousands) {
	    return function(value, width) {
	      var i = value.length,
	          t = [],
	          j = 0,
	          g = grouping[0],
	          length = 0;
	
	      while (i > 0 && g > 0) {
	        if (length + g + 1 > width) g = Math.max(1, width - length);
	        t.push(value.substring(i -= g, i + g));
	        if ((length += g + 1) > width) break;
	        g = grouping[j = (j + 1) % grouping.length];
	      }
	
	      return t.reverse().join(thousands);
	    };
	  };
	
	  var prefixExponent;
	
	  function formatPrefixAuto(x, p) {
	    var d = formatDecimal(x, p);
	    if (!d) return x + "";
	    var coefficient = d[0],
	        exponent = d[1],
	        i = exponent - (prefixExponent = Math.max(-8, Math.min(8, Math.floor(exponent / 3))) * 3) + 1,
	        n = coefficient.length;
	    return i === n ? coefficient
	        : i > n ? coefficient + new Array(i - n + 1).join("0")
	        : i > 0 ? coefficient.slice(0, i) + "." + coefficient.slice(i)
	        : "0." + new Array(1 - i).join("0") + formatDecimal(x, Math.max(0, p + i - 1))[0]; // less than 1y!
	  };
	
	  function formatRounded(x, p) {
	    var d = formatDecimal(x, p);
	    if (!d) return x + "";
	    var coefficient = d[0],
	        exponent = d[1];
	    return exponent < 0 ? "0." + new Array(-exponent).join("0") + coefficient
	        : coefficient.length > exponent + 1 ? coefficient.slice(0, exponent + 1) + "." + coefficient.slice(exponent + 1)
	        : coefficient + new Array(exponent - coefficient.length + 2).join("0");
	  };
	
	  function formatDefault(x, p) {
	    x = x.toPrecision(p);
	
	    out: for (var n = x.length, i = 1, i0 = -1, i1; i < n; ++i) {
	      switch (x[i]) {
	        case ".": i0 = i1 = i; break;
	        case "0": if (i0 === 0) i0 = i; i1 = i; break;
	        case "e": break out;
	        default: if (i0 > 0) i0 = 0; break;
	      }
	    }
	
	    return i0 > 0 ? x.slice(0, i0) + x.slice(i1 + 1) : x;
	  };
	
	  var formatTypes = {
	    "": formatDefault,
	    "%": function(x, p) { return (x * 100).toFixed(p); },
	    "b": function(x) { return Math.round(x).toString(2); },
	    "c": function(x) { return x + ""; },
	    "d": function(x) { return Math.round(x).toString(10); },
	    "e": function(x, p) { return x.toExponential(p); },
	    "f": function(x, p) { return x.toFixed(p); },
	    "g": function(x, p) { return x.toPrecision(p); },
	    "o": function(x) { return Math.round(x).toString(8); },
	    "p": function(x, p) { return formatRounded(x * 100, p); },
	    "r": formatRounded,
	    "s": formatPrefixAuto,
	    "X": function(x) { return Math.round(x).toString(16).toUpperCase(); },
	    "x": function(x) { return Math.round(x).toString(16); }
	  };
	
	  // [[fill]align][sign][symbol][0][width][,][.precision][type]
	  var re = /^(?:(.)?([<>=^]))?([+\-\( ])?([$#])?(0)?(\d+)?(,)?(\.\d+)?([a-z%])?$/i;
	
	  function formatSpecifier(specifier) {
	    return new FormatSpecifier(specifier);
	  };
	
	  function FormatSpecifier(specifier) {
	    if (!(match = re.exec(specifier))) throw new Error("invalid format: " + specifier);
	
	    var match,
	        fill = match[1] || " ",
	        align = match[2] || ">",
	        sign = match[3] || "-",
	        symbol = match[4] || "",
	        zero = !!match[5],
	        width = match[6] && +match[6],
	        comma = !!match[7],
	        precision = match[8] && +match[8].slice(1),
	        type = match[9] || "";
	
	    // The "n" type is an alias for ",g".
	    if (type === "n") comma = true, type = "g";
	
	    // Map invalid types to the default format.
	    else if (!formatTypes[type]) type = "";
	
	    // If zero fill is specified, padding goes after sign and before digits.
	    if (zero || (fill === "0" && align === "=")) zero = true, fill = "0", align = "=";
	
	    this.fill = fill;
	    this.align = align;
	    this.sign = sign;
	    this.symbol = symbol;
	    this.zero = zero;
	    this.width = width;
	    this.comma = comma;
	    this.precision = precision;
	    this.type = type;
	  }
	
	  FormatSpecifier.prototype.toString = function() {
	    return this.fill
	        + this.align
	        + this.sign
	        + this.symbol
	        + (this.zero ? "0" : "")
	        + (this.width == null ? "" : Math.max(1, this.width | 0))
	        + (this.comma ? "," : "")
	        + (this.precision == null ? "" : "." + Math.max(0, this.precision | 0))
	        + this.type;
	  };
	
	  var prefixes = ["y","z","a","f","p","n","µ","m","","k","M","G","T","P","E","Z","Y"];
	
	  function identity(x) {
	    return x;
	  }
	
	  function locale(locale) {
	    var group = locale.grouping && locale.thousands ? formatGroup(locale.grouping, locale.thousands) : identity,
	        currency = locale.currency,
	        decimal = locale.decimal;
	
	    function format(specifier) {
	      specifier = formatSpecifier(specifier);
	
	      var fill = specifier.fill,
	          align = specifier.align,
	          sign = specifier.sign,
	          symbol = specifier.symbol,
	          zero = specifier.zero,
	          width = specifier.width,
	          comma = specifier.comma,
	          precision = specifier.precision,
	          type = specifier.type;
	
	      // Compute the prefix and suffix.
	      // For SI-prefix, the suffix is lazily computed.
	      var prefix = symbol === "$" ? currency[0] : symbol === "#" && /[boxX]/.test(type) ? "0" + type.toLowerCase() : "",
	          suffix = symbol === "$" ? currency[1] : /[%p]/.test(type) ? "%" : "";
	
	      // What format function should we use?
	      // Is this an integer type?
	      // Can this type generate exponential notation?
	      var formatType = formatTypes[type],
	          maybeSuffix = !type || /[defgprs%]/.test(type);
	
	      // Set the default precision if not specified,
	      // or clamp the specified precision to the supported range.
	      // For significant precision, it must be in [1, 21].
	      // For fixed precision, it must be in [0, 20].
	      precision = precision == null ? (type ? 6 : 12)
	          : /[gprs]/.test(type) ? Math.max(1, Math.min(21, precision))
	          : Math.max(0, Math.min(20, precision));
	
	      return function(value) {
	        var valuePrefix = prefix,
	            valueSuffix = suffix;
	
	        if (type === "c") {
	          valueSuffix = formatType(value) + valueSuffix;
	          value = "";
	        } else {
	          value = +value;
	
	          // Convert negative to positive, and compute the prefix.
	          // Note that -0 is not less than 0, but 1 / -0 is!
	          var valueNegative = (value < 0 || 1 / value < 0) && (value *= -1, true);
	
	          // Perform the initial formatting.
	          value = formatType(value, precision);
	
	          // If the original value was negative, it may be rounded to zero during
	          // formatting; treat this as (positive) zero.
	          if (valueNegative) {
	            var i = -1, n = value.length, c;
	            valueNegative = false;
	            while (++i < n) {
	              if (c = value.charCodeAt(i), (48 < c && c < 58)
	                  || (type === "x" && 96 < c && c < 103)
	                  || (type === "X" && 64 < c && c < 71)) {
	                valueNegative = true;
	                break;
	              }
	            }
	          }
	
	          // Compute the prefix and suffix.
	          valuePrefix = (valueNegative ? (sign === "(" ? sign : "-") : sign === "-" || sign === "(" ? "" : sign) + valuePrefix;
	          valueSuffix = valueSuffix + (type === "s" ? prefixes[8 + prefixExponent / 3] : "") + (valueNegative && sign === "(" ? ")" : "");
	
	          // Break the formatted value into the integer “value” part that can be
	          // grouped, and fractional or exponential “suffix” part that is not.
	          if (maybeSuffix) {
	            var i = -1, n = value.length, c;
	            while (++i < n) {
	              if (c = value.charCodeAt(i), 48 > c || c > 57) {
	                valueSuffix = (c === 46 ? decimal + value.slice(i + 1) : value.slice(i)) + valueSuffix;
	                value = value.slice(0, i);
	                break;
	              }
	            }
	          }
	        }
	
	        // If the fill character is not "0", grouping is applied before padding.
	        if (comma && !zero) value = group(value, Infinity);
	
	        // Compute the padding.
	        var length = valuePrefix.length + value.length + valueSuffix.length,
	            padding = length < width ? new Array(width - length + 1).join(fill) : "";
	
	        // If the fill character is "0", grouping is applied after padding.
	        if (comma && zero) value = group(padding + value, padding.length ? width - valueSuffix.length : Infinity), padding = "";
	
	        // Reconstruct the final output based on the desired alignment.
	        switch (align) {
	          case "<": return valuePrefix + value + valueSuffix + padding;
	          case "=": return valuePrefix + padding + value + valueSuffix;
	          case "^": return padding.slice(0, length = padding.length >> 1) + valuePrefix + value + valueSuffix + padding.slice(length);
	        }
	        return padding + valuePrefix + value + valueSuffix;
	      };
	    }
	
	    function formatPrefix(specifier, value) {
	      var f = format((specifier = formatSpecifier(specifier), specifier.type = "f", specifier)),
	          e = Math.max(-8, Math.min(8, Math.floor(exponent(value) / 3))) * 3,
	          k = Math.pow(10, -e),
	          prefix = prefixes[8 + e / 3];
	      return function(value) {
	        return f(k * value) + prefix;
	      };
	    }
	
	    return {
	      format: format,
	      formatPrefix: formatPrefix
	    };
	  };
	
	  var defaultLocale = locale({
	    decimal: ".",
	    thousands: ",",
	    grouping: [3],
	    currency: ["$", ""]
	  });
	
	  var caES = locale({
	    decimal: ",",
	    thousands: ".",
	    grouping: [3],
	    currency: ["", "\xa0€"]
	  });
	
	  var csCZ = locale({
	    decimal: ",",
	    thousands: "\xa0",
	    grouping: [3],
	    currency: ["", "\xa0Kč"],
	  });
	
	  var deCH = locale({
	    decimal: ",",
	    thousands: "'",
	    grouping: [3],
	    currency: ["", "\xa0CHF"]
	  });
	
	  var deDE = locale({
	    decimal: ",",
	    thousands: ".",
	    grouping: [3],
	    currency: ["", "\xa0€"]
	  });
	
	  var enCA = locale({
	    decimal: ".",
	    thousands: ",",
	    grouping: [3],
	    currency: ["$", ""]
	  });
	
	  var enGB = locale({
	    decimal: ".",
	    thousands: ",",
	    grouping: [3],
	    currency: ["£", ""]
	  });
	
	  var esES = locale({
	    decimal: ",",
	    thousands: ".",
	    grouping: [3],
	    currency: ["", "\xa0€"]
	  });
	
	  var fiFI = locale({
	    decimal: ",",
	    thousands: "\xa0",
	    grouping: [3],
	    currency: ["", "\xa0€"]
	  });
	
	  var frCA = locale({
	    decimal: ",",
	    thousands: "\xa0",
	    grouping: [3],
	    currency: ["", "$"]
	  });
	
	  var frFR = locale({
	    decimal: ",",
	    thousands: ".",
	    grouping: [3],
	    currency: ["", "\xa0€"]
	  });
	
	  var heIL = locale({
	    decimal: ".",
	    thousands: ",",
	    grouping: [3],
	    currency: ["₪", ""]
	  });
	
	  var huHU = locale({
	    decimal: ",",
	    thousands: "\xa0",
	    grouping: [3],
	    currency: ["", "\xa0Ft"]
	  });
	
	  var itIT = locale({
	    decimal: ",",
	    thousands: ".",
	    grouping: [3],
	    currency: ["€", ""]
	  });
	
	  var jaJP = locale({
	    decimal: ".",
	    thousands: ",",
	    grouping: [3],
	    currency: ["", "円"]
	  });
	
	  var koKR = locale({
	    decimal: ".",
	    thousands: ",",
	    grouping: [3],
	    currency: ["₩", ""]
	  });
	
	  var mkMK = locale({
	    decimal: ",",
	    thousands: ".",
	    grouping: [3],
	    currency: ["", "\xa0ден."]
	  });
	
	  var nlNL = locale({
	    decimal: ",",
	    thousands: ".",
	    grouping: [3],
	    currency: ["€\xa0", ""]
	  });
	
	  var plPL = locale({
	    decimal: ",",
	    thousands: ".",
	    grouping: [3],
	    currency: ["", "zł"]
	  });
	
	  var ptBR = locale({
	    decimal: ",",
	    thousands: ".",
	    grouping: [3],
	    currency: ["R$", ""]
	  });
	
	  var ruRU = locale({
	    decimal: ",",
	    thousands: "\xa0",
	    grouping: [3],
	    currency: ["", "\xa0руб."]
	  });
	
	  var svSE = locale({
	    decimal: ",",
	    thousands: "\xa0",
	    grouping: [3],
	    currency: ["", "SEK"]
	  });
	
	  var zhCN = locale({
	    decimal: ".",
	    thousands: ",",
	    grouping: [3],
	    currency: ["¥", ""]
	  });
	
	  function precisionFixed(step) {
	    return Math.max(0, -exponent(Math.abs(step)));
	  };
	
	  function precisionPrefix(step, value) {
	    return Math.max(0, Math.max(-8, Math.min(8, Math.floor(exponent(value) / 3))) * 3 - exponent(Math.abs(step)));
	  };
	
	  function precisionRound(step, max) {
	    step = Math.abs(step), max = Math.abs(max) - step;
	    return Math.max(0, exponent(max) - exponent(step)) + 1;
	  };
	
	  var format = defaultLocale.format;
	  var formatPrefix = defaultLocale.formatPrefix;
	
	  var version = "0.4.2";
	
	  exports.version = version;
	  exports.format = format;
	  exports.formatPrefix = formatPrefix;
	  exports.locale = locale;
	  exports.localeCaEs = caES;
	  exports.localeCsCz = csCZ;
	  exports.localeDeCh = deCH;
	  exports.localeDeDe = deDE;
	  exports.localeEnCa = enCA;
	  exports.localeEnGb = enGB;
	  exports.localeEnUs = defaultLocale;
	  exports.localeEsEs = esES;
	  exports.localeFiFi = fiFI;
	  exports.localeFrCa = frCA;
	  exports.localeFrFr = frFR;
	  exports.localeHeIl = heIL;
	  exports.localeHuHu = huHU;
	  exports.localeItIt = itIT;
	  exports.localeJaJp = jaJP;
	  exports.localeKoKr = koKR;
	  exports.localeMkMk = mkMK;
	  exports.localeNlNl = nlNL;
	  exports.localePlPl = plPL;
	  exports.localePtBr = ptBR;
	  exports.localeRuRu = ruRU;
	  exports.localeSvSe = svSE;
	  exports.localeZhCn = zhCN;
	  exports.formatSpecifier = formatSpecifier;
	  exports.precisionFixed = precisionFixed;
	  exports.precisionPrefix = precisionPrefix;
	  exports.precisionRound = precisionRound;
	
	}));

/***/ },
/* 36 */
/***/ function(module, exports, __webpack_require__) {

	var util = __webpack_require__(13),
	    Measures = __webpack_require__(37),
	    Collector = __webpack_require__(40);
	
	function Aggregator() {
	  this._cells = {};
	  this._aggr = [];
	  this._stream = false;
	}
	
	var Flags = Aggregator.Flags = {
	  ADD_CELL: 1,
	  MOD_CELL: 2
	};
	
	var proto = Aggregator.prototype;
	
	// Parameters
	
	proto.stream = function(v) {
	  if (v == null) return this._stream;
	  this._stream = !!v;
	  this._aggr = [];
	  return this;
	};
	
	// key accessor to use for streaming removes
	proto.key = function(key) {
	  if (key == null) return this._key;
	  this._key = util.$(key);
	  return this;
	};
	
	// Input: array of objects of the form
	// {name: string, get: function}
	proto.groupby = function(dims) {
	  this._dims = util.array(dims).map(function(d, i) {
	    d = util.isString(d) ? {name: d, get: util.$(d)}
	      : util.isFunction(d) ? {name: util.name(d) || d.name || ('_' + i), get: d}
	      : (d.name && util.isFunction(d.get)) ? d : null;
	    if (d == null) throw 'Invalid groupby argument: ' + d;
	    return d;
	  });
	  return this.clear();
	};
	
	// Input: array of objects of the form
	// {name: string, ops: [string, ...]}
	proto.summarize = function(fields) {
	  fields = summarize_args(fields);
	  this._count = true;
	  var aggr = (this._aggr = []),
	      m, f, i, j, op, as, get;
	
	  for (i=0; i<fields.length; ++i) {
	    for (j=0, m=[], f=fields[i]; j<f.ops.length; ++j) {
	      op = f.ops[j];
	      if (op !== 'count') this._count = false;
	      as = (f.as && f.as[j]) || (op + (f.name==='*' ? '' : '_'+f.name));
	      m.push(Measures[op](as));
	    }
	    get = f.get && util.$(f.get) ||
	      (f.name === '*' ? util.identity : util.$(f.name));
	    aggr.push({
	      name: f.name,
	      measures: Measures.create(
	        m,
	        this._stream, // streaming remove flag
	        get,          // input tuple getter
	        this._assign) // output tuple setter
	    });
	  }
	  return this.clear();
	};
	
	// Convenience method to summarize by count
	proto.count = function() {
	  return this.summarize({'*':'count'});
	};
	
	// Override to perform custom tuple value assignment
	proto._assign = function(object, name, value) {
	  object[name] = value;
	};
	
	function summarize_args(fields) {
	  if (util.isArray(fields)) { return fields; }
	  if (fields == null) { return []; }
	  var a = [], name, ops;
	  for (name in fields) {
	    ops = util.array(fields[name]);
	    a.push({name: name, ops: ops});
	  }
	  return a;
	}
	
	// Cell Management
	
	proto.clear = function() {
	  return (this._cells = {}, this);
	};
	
	proto._cellkey = function(x) {
	  var d = this._dims,
	      n = d.length, i,
	      k = String(d[0].get(x));
	  for (i=1; i<n; ++i) {
	    k += '|' + d[i].get(x);
	  }
	  return k;
	};
	
	proto._cell = function(x) {
	  var key = this._dims.length ? this._cellkey(x) : '';
	  return this._cells[key] || (this._cells[key] = this._newcell(x, key));
	};
	
	proto._newcell = function(x, key) {
	  var cell = {
	    num:   0,
	    tuple: this._newtuple(x, key),
	    flag:  Flags.ADD_CELL,
	    aggs:  {}
	  };
	
	  var aggr = this._aggr, i;
	  for (i=0; i<aggr.length; ++i) {
	    cell.aggs[aggr[i].name] = new aggr[i].measures(cell, cell.tuple);
	  }
	  if (cell.collect) {
	    cell.data = new Collector(this._key);
	  }
	  return cell;
	};
	
	proto._newtuple = function(x) {
	  var dims = this._dims,
	      t = {}, i, n;
	  for (i=0, n=dims.length; i<n; ++i) {
	    t[dims[i].name] = dims[i].get(x);
	  }
	  return this._ingest(t);
	};
	
	// Override to perform custom tuple ingestion
	proto._ingest = util.identity;
	
	// Process Tuples
	
	proto._add = function(x) {
	  var cell = this._cell(x),
	      aggr = this._aggr, i;
	
	  cell.num += 1;
	  if (!this._count) { // skip if count-only
	    if (cell.collect) cell.data.add(x);
	    for (i=0; i<aggr.length; ++i) {
	      cell.aggs[aggr[i].name].add(x);
	    }
	  }
	  cell.flag |= Flags.MOD_CELL;
	  if (this._on_add) this._on_add(x, cell);
	};
	
	proto._rem = function(x) {
	  var cell = this._cell(x),
	      aggr = this._aggr, i;
	
	  cell.num -= 1;
	  if (!this._count) { // skip if count-only
	    if (cell.collect) cell.data.rem(x);
	    for (i=0; i<aggr.length; ++i) {
	      cell.aggs[aggr[i].name].rem(x);
	    }
	  }
	  cell.flag |= Flags.MOD_CELL;
	  if (this._on_rem) this._on_rem(x, cell);
	};
	
	proto._mod = function(curr, prev) {
	  var cell0 = this._cell(prev),
	      cell1 = this._cell(curr),
	      aggr = this._aggr, i;
	
	  if (cell0 !== cell1) {
	    cell0.num -= 1;
	    cell1.num += 1;
	    if (cell0.collect) cell0.data.rem(prev);
	    if (cell1.collect) cell1.data.add(curr);
	  } else if (cell0.collect && !util.isObject(curr)) {
	    cell0.data.rem(prev);
	    cell0.data.add(curr);
	  }
	
	  for (i=0; i<aggr.length; ++i) {
	    cell0.aggs[aggr[i].name].rem(prev);
	    cell1.aggs[aggr[i].name].add(curr);
	  }
	  cell0.flag |= Flags.MOD_CELL;
	  cell1.flag |= Flags.MOD_CELL;
	  if (this._on_mod) this._on_mod(curr, prev, cell0, cell1);
	};
	
	proto._markMod = function(x) {
	  var cell0 = this._cell(x);
	  cell0.flag |= Flags.MOD_CELL;
	};
	
	proto.result = function() {
	  var result = [],
	      aggr = this._aggr,
	      cell, i, k;
	
	  for (k in this._cells) {
	    cell = this._cells[k];
	    if (cell.num > 0) {
	      // consolidate collector values
	      if (cell.collect) {
	        cell.data.values();
	      }
	      // update tuple properties
	      for (i=0; i<aggr.length; ++i) {
	        cell.aggs[aggr[i].name].set();
	      }
	      // add output tuple
	      result.push(cell.tuple);
	    } else {
	      delete this._cells[k];
	    }
	    cell.flag = 0;
	  }
	
	  this._rems = false;
	  return result;
	};
	
	proto.changes = function(output) {
	  var changes = output || {add:[], rem:[], mod:[]},
	      aggr = this._aggr,
	      cell, flag, i, k;
	
	  for (k in this._cells) {
	    cell = this._cells[k];
	    flag = cell.flag;
	
	    // consolidate collector values
	    if (cell.collect) {
	      cell.data.values();
	    }
	
	    // update tuple properties
	    for (i=0; i<aggr.length; ++i) {
	      cell.aggs[aggr[i].name].set();
	    }
	
	    // organize output tuples
	    if (cell.num <= 0) {
	      changes.rem.push(cell.tuple); // if (flag === Flags.MOD_CELL) { ??
	      delete this._cells[k];
	      if (this._on_drop) this._on_drop(cell);
	    } else {
	      if (this._on_keep) this._on_keep(cell);
	      if (flag & Flags.ADD_CELL) {
	        changes.add.push(cell.tuple);
	      } else if (flag & Flags.MOD_CELL) {
	        changes.mod.push(cell.tuple);
	      }
	    }
	
	    cell.flag = 0;
	  }
	
	  this._rems = false;
	  return changes;
	};
	
	proto.execute = function(input) {
	  return this.clear().insert(input).result();
	};
	
	proto.insert = function(input) {
	  this._consolidate();
	  for (var i=0; i<input.length; ++i) {
	    this._add(input[i]);
	  }
	  return this;
	};
	
	proto.remove = function(input) {
	  if (!this._stream) {
	    throw 'Aggregator not configured for streaming removes.' +
	      ' Call stream(true) prior to calling summarize.';
	  }
	  for (var i=0; i<input.length; ++i) {
	    this._rem(input[i]);
	  }
	  this._rems = true;
	  return this;
	};
	
	// consolidate removals
	proto._consolidate = function() {
	  if (!this._rems) return;
	  for (var k in this._cells) {
	    if (this._cells[k].collect) {
	      this._cells[k].data.values();
	    }
	  }
	  this._rems = false;
	};
	
	module.exports = Aggregator;


/***/ },
/* 37 */
/***/ function(module, exports, __webpack_require__) {

	var util = __webpack_require__(13);
	
	var types = {
	  'values': measure({
	    name: 'values',
	    init: 'cell.collect = true;',
	    set:  'cell.data.values()', idx: -1
	  }),
	  'count': measure({
	    name: 'count',
	    set:  'cell.num'
	  }),
	  'missing': measure({
	    name: 'missing',
	    set:  'this.missing'
	  }),
	  'valid': measure({
	    name: 'valid',
	    set:  'this.valid'
	  }),
	  'sum': measure({
	    name: 'sum',
	    init: 'this.sum = 0;',
	    add:  'this.sum += v;',
	    rem:  'this.sum -= v;',
	    set:  'this.sum'
	  }),
	  'mean': measure({
	    name: 'mean',
	    init: 'this.mean = 0;',
	    add:  'var d = v - this.mean; this.mean += d / this.valid;',
	    rem:  'var d = v - this.mean; this.mean -= this.valid ? d / this.valid : this.mean;',
	    set:  'this.mean'
	  }),
	  'average': measure({
	    name: 'average',
	    set:  'this.mean',
	    req:  ['mean'], idx: 1
	  }),
	  'variance': measure({
	    name: 'variance',
	    init: 'this.dev = 0;',
	    add:  'this.dev += d * (v - this.mean);',
	    rem:  'this.dev -= d * (v - this.mean);',
	    set:  'this.valid > 1 ? this.dev / (this.valid-1) : 0',
	    req:  ['mean'], idx: 1
	  }),
	  'variancep': measure({
	    name: 'variancep',
	    set:  'this.valid > 1 ? this.dev / this.valid : 0',
	    req:  ['variance'], idx: 2
	  }),
	  'stdev': measure({
	    name: 'stdev',
	    set:  'this.valid > 1 ? Math.sqrt(this.dev / (this.valid-1)) : 0',
	    req:  ['variance'], idx: 2
	  }),
	  'stdevp': measure({
	    name: 'stdevp',
	    set:  'this.valid > 1 ? Math.sqrt(this.dev / this.valid) : 0',
	    req:  ['variance'], idx: 2
	  }),
	  'stderr': measure({
	    name: 'stderr',
	    set:  'this.valid > 1 ? Math.sqrt(this.dev / (this.valid * (this.valid-1))) : 0',
	    req:  ['variance'], idx: 2
	  }),
	  'median': measure({
	    name: 'median',
	    set:  'cell.data.q2(this.get)',
	    req:  ['values'], idx: 3
	  }),
	  'q1': measure({
	    name: 'q1',
	    set:  'cell.data.q1(this.get)',
	    req:  ['values'], idx: 3
	  }),
	  'q3': measure({
	    name: 'q3',
	    set:  'cell.data.q3(this.get)',
	    req:  ['values'], idx: 3
	  }),
	  'distinct': measure({
	    name: 'distinct',
	    set:  'this.distinct(cell.data.values(), this.get)',
	    req:  ['values'], idx: 3
	  }),
	  'argmin': measure({
	    name: 'argmin',
	    add:  'if (v < this.min) this.argmin = t;',
	    rem:  'if (v <= this.min) this.argmin = null;',
	    set:  'this.argmin = this.argmin || cell.data.argmin(this.get)',
	    req:  ['min'], str: ['values'], idx: 3
	  }),
	  'argmax': measure({
	    name: 'argmax',
	    add:  'if (v > this.max) this.argmax = t;',
	    rem:  'if (v >= this.max) this.argmax = null;',
	    set:  'this.argmax = this.argmax || cell.data.argmax(this.get)',
	    req:  ['max'], str: ['values'], idx: 3
	  }),
	  'min': measure({
	    name: 'min',
	    init: 'this.min = +Infinity;',
	    add:  'if (v < this.min) this.min = v;',
	    rem:  'if (v <= this.min) this.min = NaN;',
	    set:  'this.min = (isNaN(this.min) ? cell.data.min(this.get) : this.min)',
	    str:  ['values'], idx: 4
	  }),
	  'max': measure({
	    name: 'max',
	    init: 'this.max = -Infinity;',
	    add:  'if (v > this.max) this.max = v;',
	    rem:  'if (v >= this.max) this.max = NaN;',
	    set:  'this.max = (isNaN(this.max) ? cell.data.max(this.get) : this.max)',
	    str:  ['values'], idx: 4
	  }),
	  'modeskew': measure({
	    name: 'modeskew',
	    set:  'this.dev===0 ? 0 : (this.mean - cell.data.q2(this.get)) / Math.sqrt(this.dev/(this.valid-1))',
	    req:  ['mean', 'variance', 'median'], idx: 5
	  })
	};
	
	function measure(base) {
	  return function(out) {
	    var m = util.extend({init:'', add:'', rem:'', idx:0}, base);
	    m.out = out || base.name;
	    return m;
	  };
	}
	
	function resolve(agg, stream) {
	  function collect(m, a) {
	    function helper(r) { if (!m[r]) collect(m, m[r] = types[r]()); }
	    if (a.req) a.req.forEach(helper);
	    if (stream && a.str) a.str.forEach(helper);
	    return m;
	  }
	  var map = agg.reduce(
	    collect,
	    agg.reduce(function(m, a) { return (m[a.name] = a, m); }, {})
	  );
	  return util.vals(map).sort(function(a, b) { return a.idx - b.idx; });
	}
	
	function create(agg, stream, accessor, mutator) {
	  var all = resolve(agg, stream),
	      ctr = 'this.cell = cell; this.tuple = t; this.valid = 0; this.missing = 0;',
	      add = 'if (v==null) this.missing++; if (!this.isValid(v)) return; ++this.valid;',
	      rem = 'if (v==null) this.missing--; if (!this.isValid(v)) return; --this.valid;',
	      set = 'var t = this.tuple; var cell = this.cell;';
	
	  all.forEach(function(a) {
	    if (a.idx < 0) {
	      ctr = a.init + ctr;
	      add = a.add + add;
	      rem = a.rem + rem;
	    } else {
	      ctr += a.init;
	      add += a.add;
	      rem += a.rem;
	    }
	  });
	  agg.slice()
	    .sort(function(a, b) { return a.idx - b.idx; })
	    .forEach(function(a) {
	      set += 'this.assign(t,\''+a.out+'\','+a.set+');';
	    });
	  set += 'return t;';
	
	  /* jshint evil: true */
	  ctr = Function('cell', 't', ctr);
	  ctr.prototype.assign = mutator;
	  ctr.prototype.add = Function('t', 'var v = this.get(t);' + add);
	  ctr.prototype.rem = Function('t', 'var v = this.get(t);' + rem);
	  ctr.prototype.set = Function(set);
	  ctr.prototype.get = accessor;
	  ctr.prototype.distinct = __webpack_require__(38).count.distinct;
	  ctr.prototype.isValid = util.isValid;
	  ctr.fields = agg.map(util.$('out'));
	  return ctr;
	}
	
	types.create = create;
	module.exports = types;


/***/ },
/* 38 */
/***/ function(module, exports, __webpack_require__) {

	var util = __webpack_require__(13);
	var type = __webpack_require__(24);
	var gen = __webpack_require__(39);
	
	var stats = module.exports;
	
	// Collect unique values.
	// Output: an array of unique values, in first-observed order
	stats.unique = function(values, f, results) {
	  f = util.$(f);
	  results = results || [];
	  var u = {}, v, i, n;
	  for (i=0, n=values.length; i<n; ++i) {
	    v = f ? f(values[i]) : values[i];
	    if (v in u) continue;
	    u[v] = 1;
	    results.push(v);
	  }
	  return results;
	};
	
	// Return the length of the input array.
	stats.count = function(values) {
	  return values && values.length || 0;
	};
	
	// Count the number of non-null, non-undefined, non-NaN values.
	stats.count.valid = function(values, f) {
	  f = util.$(f);
	  var v, i, n, valid = 0;
	  for (i=0, n=values.length; i<n; ++i) {
	    v = f ? f(values[i]) : values[i];
	    if (util.isValid(v)) valid += 1;
	  }
	  return valid;
	};
	
	// Count the number of null or undefined values.
	stats.count.missing = function(values, f) {
	  f = util.$(f);
	  var v, i, n, count = 0;
	  for (i=0, n=values.length; i<n; ++i) {
	    v = f ? f(values[i]) : values[i];
	    if (v == null) count += 1;
	  }
	  return count;
	};
	
	// Count the number of distinct values.
	// Null, undefined and NaN are each considered distinct values.
	stats.count.distinct = function(values, f) {
	  f = util.$(f);
	  var u = {}, v, i, n, count = 0;
	  for (i=0, n=values.length; i<n; ++i) {
	    v = f ? f(values[i]) : values[i];
	    if (v in u) continue;
	    u[v] = 1;
	    count += 1;
	  }
	  return count;
	};
	
	// Construct a map from distinct values to occurrence counts.
	stats.count.map = function(values, f) {
	  f = util.$(f);
	  var map = {}, v, i, n;
	  for (i=0, n=values.length; i<n; ++i) {
	    v = f ? f(values[i]) : values[i];
	    map[v] = (v in map) ? map[v] + 1 : 1;
	  }
	  return map;
	};
	
	// Compute the median of an array of numbers.
	stats.median = function(values, f) {
	  if (f) values = values.map(util.$(f));
	  values = values.filter(util.isValid).sort(util.cmp);
	  return stats.quantile(values, 0.5);
	};
	
	// Computes the quartile boundaries of an array of numbers.
	stats.quartile = function(values, f) {
	  if (f) values = values.map(util.$(f));
	  values = values.filter(util.isValid).sort(util.cmp);
	  var q = stats.quantile;
	  return [q(values, 0.25), q(values, 0.50), q(values, 0.75)];
	};
	
	// Compute the quantile of a sorted array of numbers.
	// Adapted from the D3.js implementation.
	stats.quantile = function(values, f, p) {
	  if (p === undefined) { p = f; f = util.identity; }
	  f = util.$(f);
	  var H = (values.length - 1) * p + 1,
	      h = Math.floor(H),
	      v = +f(values[h - 1]),
	      e = H - h;
	  return e ? v + e * (f(values[h]) - v) : v;
	};
	
	// Compute the sum of an array of numbers.
	stats.sum = function(values, f) {
	  f = util.$(f);
	  for (var sum=0, i=0, n=values.length, v; i<n; ++i) {
	    v = f ? f(values[i]) : values[i];
	    if (util.isValid(v)) sum += v;
	  }
	  return sum;
	};
	
	// Compute the mean (average) of an array of numbers.
	stats.mean = function(values, f) {
	  f = util.$(f);
	  var mean = 0, delta, i, n, c, v;
	  for (i=0, c=0, n=values.length; i<n; ++i) {
	    v = f ? f(values[i]) : values[i];
	    if (util.isValid(v)) {
	      delta = v - mean;
	      mean = mean + delta / (++c);
	    }
	  }
	  return mean;
	};
	
	// Compute the geometric mean of an array of numbers.
	stats.mean.geometric = function(values, f) {
	  f = util.$(f);
	  var mean = 1, c, n, v, i;
	  for (i=0, c=0, n=values.length; i<n; ++i) {
	    v = f ? f(values[i]) : values[i];
	    if (util.isValid(v)) {
	      if (v <= 0) {
	        throw Error("Geometric mean only defined for positive values.");
	      }
	      mean *= v;
	      ++c;
	    }
	  }
	  mean = c > 0 ? Math.pow(mean, 1/c) : 0;
	  return mean;
	};
	
	// Compute the harmonic mean of an array of numbers.
	stats.mean.harmonic = function(values, f) {
	  f = util.$(f);
	  var mean = 0, c, n, v, i;
	  for (i=0, c=0, n=values.length; i<n; ++i) {
	    v = f ? f(values[i]) : values[i];
	    if (util.isValid(v)) {
	      mean += 1/v;
	      ++c;
	    }
	  }
	  return c / mean;
	};
	
	// Compute the sample variance of an array of numbers.
	stats.variance = function(values, f) {
	  f = util.$(f);
	  if (!util.isArray(values) || values.length < 2) return 0;
	  var mean = 0, M2 = 0, delta, i, c, v;
	  for (i=0, c=0; i<values.length; ++i) {
	    v = f ? f(values[i]) : values[i];
	    if (util.isValid(v)) {
	      delta = v - mean;
	      mean = mean + delta / (++c);
	      M2 = M2 + delta * (v - mean);
	    }
	  }
	  M2 = M2 / (c - 1);
	  return M2;
	};
	
	// Compute the sample standard deviation of an array of numbers.
	stats.stdev = function(values, f) {
	  return Math.sqrt(stats.variance(values, f));
	};
	
	// Compute the Pearson mode skewness ((median-mean)/stdev) of an array of numbers.
	stats.modeskew = function(values, f) {
	  var avg = stats.mean(values, f),
	      med = stats.median(values, f),
	      std = stats.stdev(values, f);
	  return std === 0 ? 0 : (avg - med) / std;
	};
	
	// Find the minimum value in an array.
	stats.min = function(values, f) {
	  return stats.extent(values, f)[0];
	};
	
	// Find the maximum value in an array.
	stats.max = function(values, f) {
	  return stats.extent(values, f)[1];
	};
	
	// Find the minimum and maximum of an array of values.
	stats.extent = function(values, f) {
	  f = util.$(f);
	  var a, b, v, i, n = values.length;
	  for (i=0; i<n; ++i) {
	    v = f ? f(values[i]) : values[i];
	    if (util.isValid(v)) { a = b = v; break; }
	  }
	  for (; i<n; ++i) {
	    v = f ? f(values[i]) : values[i];
	    if (util.isValid(v)) {
	      if (v < a) a = v;
	      if (v > b) b = v;
	    }
	  }
	  return [a, b];
	};
	
	// Find the integer indices of the minimum and maximum values.
	stats.extent.index = function(values, f) {
	  f = util.$(f);
	  var x = -1, y = -1, a, b, v, i, n = values.length;
	  for (i=0; i<n; ++i) {
	    v = f ? f(values[i]) : values[i];
	    if (util.isValid(v)) { a = b = v; x = y = i; break; }
	  }
	  for (; i<n; ++i) {
	    v = f ? f(values[i]) : values[i];
	    if (util.isValid(v)) {
	      if (v < a) { a = v; x = i; }
	      if (v > b) { b = v; y = i; }
	    }
	  }
	  return [x, y];
	};
	
	// Compute the dot product of two arrays of numbers.
	stats.dot = function(values, a, b) {
	  var sum = 0, i, v;
	  if (!b) {
	    if (values.length !== a.length) {
	      throw Error('Array lengths must match.');
	    }
	    for (i=0; i<values.length; ++i) {
	      v = values[i] * a[i];
	      if (v === v) sum += v;
	    }
	  } else {
	    a = util.$(a);
	    b = util.$(b);
	    for (i=0; i<values.length; ++i) {
	      v = a(values[i]) * b(values[i]);
	      if (v === v) sum += v;
	    }
	  }
	  return sum;
	};
	
	// Compute the vector distance between two arrays of numbers.
	// Default is Euclidean (exp=2) distance, configurable via exp argument.
	stats.dist = function(values, a, b, exp) {
	  var f = util.isFunction(b) || util.isString(b),
	      X = values,
	      Y = f ? values : a,
	      e = f ? exp : b,
	      L2 = e === 2 || e == null,
	      n = values.length, s = 0, d, i;
	  if (f) {
	    a = util.$(a);
	    b = util.$(b);
	  }
	  for (i=0; i<n; ++i) {
	    d = f ? (a(X[i])-b(Y[i])) : (X[i]-Y[i]);
	    s += L2 ? d*d : Math.pow(Math.abs(d), e);
	  }
	  return L2 ? Math.sqrt(s) : Math.pow(s, 1/e);
	};
	
	// Compute the Cohen's d effect size between two arrays of numbers.
	stats.cohensd = function(values, a, b) {
	  var X = b ? values.map(util.$(a)) : values,
	      Y = b ? values.map(util.$(b)) : a,
	      x1 = stats.mean(X),
	      x2 = stats.mean(Y),
	      n1 = stats.count.valid(X),
	      n2 = stats.count.valid(Y);
	
	  if ((n1+n2-2) <= 0) {
	    // if both arrays are size 1, or one is empty, there's no effect size
	    return 0;
	  }
	  // pool standard deviation
	  var s1 = stats.variance(X),
	      s2 = stats.variance(Y),
	      s = Math.sqrt((((n1-1)*s1) + ((n2-1)*s2)) / (n1+n2-2));
	  // if there is no variance, there's no effect size
	  return s===0 ? 0 : (x1 - x2) / s;
	};
	
	// Computes the covariance between two arrays of numbers
	stats.covariance = function(values, a, b) {
	  var X = b ? values.map(util.$(a)) : values,
	      Y = b ? values.map(util.$(b)) : a,
	      n = X.length,
	      xm = stats.mean(X),
	      ym = stats.mean(Y),
	      sum = 0, c = 0, i, x, y, vx, vy;
	
	  if (n !== Y.length) {
	    throw Error('Input lengths must match.');
	  }
	
	  for (i=0; i<n; ++i) {
	    x = X[i]; vx = util.isValid(x);
	    y = Y[i]; vy = util.isValid(y);
	    if (vx && vy) {
	      sum += (x-xm) * (y-ym);
	      ++c;
	    } else if (vx || vy) {
	      throw Error('Valid values must align.');
	    }
	  }
	  return sum / (c-1);
	};
	
	// Compute ascending rank scores for an array of values.
	// Ties are assigned their collective mean rank.
	stats.rank = function(values, f) {
	  f = util.$(f) || util.identity;
	  var a = values.map(function(v, i) {
	      return {idx: i, val: f(v)};
	    })
	    .sort(util.comparator('val'));
	
	  var n = values.length,
	      r = Array(n),
	      tie = -1, p = {}, i, v, mu;
	
	  for (i=0; i<n; ++i) {
	    v = a[i].val;
	    if (tie < 0 && p === v) {
	      tie = i - 1;
	    } else if (tie > -1 && p !== v) {
	      mu = 1 + (i-1 + tie) / 2;
	      for (; tie<i; ++tie) r[a[tie].idx] = mu;
	      tie = -1;
	    }
	    r[a[i].idx] = i + 1;
	    p = v;
	  }
	
	  if (tie > -1) {
	    mu = 1 + (n-1 + tie) / 2;
	    for (; tie<n; ++tie) r[a[tie].idx] = mu;
	  }
	
	  return r;
	};
	
	// Compute the sample Pearson product-moment correlation of two arrays of numbers.
	stats.cor = function(values, a, b) {
	  var fn = b;
	  b = fn ? values.map(util.$(b)) : a;
	  a = fn ? values.map(util.$(a)) : values;
	
	  var dot = stats.dot(a, b),
	      mua = stats.mean(a),
	      mub = stats.mean(b),
	      sda = stats.stdev(a),
	      sdb = stats.stdev(b),
	      n = values.length;
	
	  return (dot - n*mua*mub) / ((n-1) * sda * sdb);
	};
	
	// Compute the Spearman rank correlation of two arrays of values.
	stats.cor.rank = function(values, a, b) {
	  var ra = b ? stats.rank(values, a) : stats.rank(values),
	      rb = b ? stats.rank(values, b) : stats.rank(a),
	      n = values.length, i, s, d;
	
	  for (i=0, s=0; i<n; ++i) {
	    d = ra[i] - rb[i];
	    s += d * d;
	  }
	
	  return 1 - 6*s / (n * (n*n-1));
	};
	
	// Compute the distance correlation of two arrays of numbers.
	// http://en.wikipedia.org/wiki/Distance_correlation
	stats.cor.dist = function(values, a, b) {
	  var X = b ? values.map(util.$(a)) : values,
	      Y = b ? values.map(util.$(b)) : a;
	
	  var A = stats.dist.mat(X),
	      B = stats.dist.mat(Y),
	      n = A.length,
	      i, aa, bb, ab;
	
	  for (i=0, aa=0, bb=0, ab=0; i<n; ++i) {
	    aa += A[i]*A[i];
	    bb += B[i]*B[i];
	    ab += A[i]*B[i];
	  }
	
	  return Math.sqrt(ab / Math.sqrt(aa*bb));
	};
	
	// Simple linear regression.
	// Returns a "fit" object with slope (m), intercept (b),
	// r value (R), and sum-squared residual error (rss).
	stats.linearRegression = function(values, a, b) {
	  var X = b ? values.map(util.$(a)) : values,
	      Y = b ? values.map(util.$(b)) : a,
	      n = X.length,
	      xy = stats.covariance(X, Y), // will throw err if valid vals don't align
	      sx = stats.stdev(X),
	      sy = stats.stdev(Y),
	      slope = xy / (sx*sx),
	      icept = stats.mean(Y) - slope * stats.mean(X),
	      fit = {slope: slope, intercept: icept, R: xy / (sx*sy), rss: 0},
	      res, i;
	
	  for (i=0; i<n; ++i) {
	    if (util.isValid(X[i]) && util.isValid(Y[i])) {
	      res = (slope*X[i] + icept) - Y[i];
	      fit.rss += res * res;
	    }
	  }
	
	  return fit;
	};
	
	// Namespace for bootstrap
	stats.bootstrap = {};
	
	// Construct a bootstrapped confidence interval at a given percentile level
	// Arguments are an array, an optional n (defaults to 1000),
	//  an optional alpha (defaults to 0.05), and an optional smoothing parameter
	stats.bootstrap.ci = function(values, a, b, c, d) {
	  var X, N, alpha, smooth, bs, means, i;
	  if (util.isFunction(a) || util.isString(a)) {
	    X = values.map(util.$(a));
	    N = b;
	    alpha = c;
	    smooth = d;
	  } else {
	    X = values;
	    N = a;
	    alpha = b;
	    smooth = c;
	  }
	  N = N ? +N : 1000;
	  alpha = alpha || 0.05;
	
	  bs = gen.random.bootstrap(X, smooth);
	  for (i=0, means = Array(N); i<N; ++i) {
	    means[i] = stats.mean(bs.samples(X.length));
	  }
	  means.sort(util.numcmp);
	  return [
	    stats.quantile(means, alpha/2),
	    stats.quantile(means, 1-(alpha/2))
	  ];
	};
	
	// Namespace for z-tests
	stats.z = {};
	
	// Construct a z-confidence interval at a given significance level
	// Arguments are an array and an optional alpha (defaults to 0.05).
	stats.z.ci = function(values, a, b) {
	  var X = values, alpha = a;
	  if (util.isFunction(a) || util.isString(a)) {
	    X = values.map(util.$(a));
	    alpha = b;
	  }
	  alpha = alpha || 0.05;
	
	  var z = alpha===0.05 ? 1.96 : gen.random.normal(0, 1).icdf(1-(alpha/2)),
	      mu = stats.mean(X),
	      SE = stats.stdev(X) / Math.sqrt(stats.count.valid(X));
	  return [mu - (z*SE), mu + (z*SE)];
	};
	
	// Perform a z-test of means. Returns the p-value.
	// If a single array is provided, performs a one-sample location test.
	// If two arrays or a table and two accessors are provided, performs
	// a two-sample location test. A paired test is performed if specified
	// by the options hash.
	// The options hash format is: {paired: boolean, nullh: number}.
	// http://en.wikipedia.org/wiki/Z-test
	// http://en.wikipedia.org/wiki/Paired_difference_test
	stats.z.test = function(values, a, b, opt) {
	  if (util.isFunction(b) || util.isString(b)) { // table and accessors
	    return (opt && opt.paired ? ztestP : ztest2)(opt, values, a, b);
	  } else if (util.isArray(a)) { // two arrays
	    return (b && b.paired ? ztestP : ztest2)(b, values, a);
	  } else if (util.isFunction(a) || util.isString(a)) {
	    return ztest1(b, values, a); // table and accessor
	  } else {
	    return ztest1(a, values); // one array
	  }
	};
	
	// Perform a z-test of means. Returns the p-value.
	// Assuming we have a list of values, and a null hypothesis. If no null
	// hypothesis, assume our null hypothesis is mu=0.
	function ztest1(opt, X, f) {
	  var nullH = opt && opt.nullh || 0,
	      gaussian = gen.random.normal(0, 1),
	      mu = stats.mean(X,f),
	      SE = stats.stdev(X,f) / Math.sqrt(stats.count.valid(X,f));
	
	  if (SE===0) {
	    // Test not well defined when standard error is 0.
	    return (mu - nullH) === 0 ? 1 : 0;
	  }
	  // Two-sided, so twice the one-sided cdf.
	  var z = (mu - nullH) / SE;
	  return 2 * gaussian.cdf(-Math.abs(z));
	}
	
	// Perform a two sample paired z-test of means. Returns the p-value.
	function ztestP(opt, values, a, b) {
	  var X = b ? values.map(util.$(a)) : values,
	      Y = b ? values.map(util.$(b)) : a,
	      n1 = stats.count(X),
	      n2 = stats.count(Y),
	      diffs = Array(), i;
	
	  if (n1 !== n2) {
	    throw Error('Array lengths must match.');
	  }
	  for (i=0; i<n1; ++i) {
	    // Only valid differences should contribute to the test statistic
	    if (util.isValid(X[i]) && util.isValid(Y[i])) {
	      diffs.push(X[i] - Y[i]);
	    }
	  }
	  return stats.z.test(diffs, opt && opt.nullh || 0);
	}
	
	// Perform a two sample z-test of means. Returns the p-value.
	function ztest2(opt, values, a, b) {
	  var X = b ? values.map(util.$(a)) : values,
	      Y = b ? values.map(util.$(b)) : a,
	      n1 = stats.count.valid(X),
	      n2 = stats.count.valid(Y),
	      gaussian = gen.random.normal(0, 1),
	      meanDiff = stats.mean(X) - stats.mean(Y) - (opt && opt.nullh || 0),
	      SE = Math.sqrt(stats.variance(X)/n1 + stats.variance(Y)/n2);
	
	  if (SE===0) {
	    // Not well defined when pooled standard error is 0.
	    return meanDiff===0 ? 1 : 0;
	  }
	  // Two-tailed, so twice the one-sided cdf.
	  var z = meanDiff / SE;
	  return 2 * gaussian.cdf(-Math.abs(z));
	}
	
	// Construct a mean-centered distance matrix for an array of numbers.
	stats.dist.mat = function(X) {
	  var n = X.length,
	      m = n*n,
	      A = Array(m),
	      R = gen.zeros(n),
	      M = 0, v, i, j;
	
	  for (i=0; i<n; ++i) {
	    A[i*n+i] = 0;
	    for (j=i+1; j<n; ++j) {
	      A[i*n+j] = (v = Math.abs(X[i] - X[j]));
	      A[j*n+i] = v;
	      R[i] += v;
	      R[j] += v;
	    }
	  }
	
	  for (i=0; i<n; ++i) {
	    M += R[i];
	    R[i] /= n;
	  }
	  M /= m;
	
	  for (i=0; i<n; ++i) {
	    for (j=i; j<n; ++j) {
	      A[i*n+j] += M - R[i] - R[j];
	      A[j*n+i] = A[i*n+j];
	    }
	  }
	
	  return A;
	};
	
	// Compute the Shannon entropy (log base 2) of an array of counts.
	stats.entropy = function(counts, f) {
	  f = util.$(f);
	  var i, p, s = 0, H = 0, n = counts.length;
	  for (i=0; i<n; ++i) {
	    s += (f ? f(counts[i]) : counts[i]);
	  }
	  if (s === 0) return 0;
	  for (i=0; i<n; ++i) {
	    p = (f ? f(counts[i]) : counts[i]) / s;
	    if (p) H += p * Math.log(p);
	  }
	  return -H / Math.LN2;
	};
	
	// Compute the mutual information between two discrete variables.
	// Returns an array of the form [MI, MI_distance]
	// MI_distance is defined as 1 - I(a,b) / H(a,b).
	// http://en.wikipedia.org/wiki/Mutual_information
	stats.mutual = function(values, a, b, counts) {
	  var x = counts ? values.map(util.$(a)) : values,
	      y = counts ? values.map(util.$(b)) : a,
	      z = counts ? values.map(util.$(counts)) : b;
	
	  var px = {},
	      py = {},
	      n = z.length,
	      s = 0, I = 0, H = 0, p, t, i;
	
	  for (i=0; i<n; ++i) {
	    px[x[i]] = 0;
	    py[y[i]] = 0;
	  }
	
	  for (i=0; i<n; ++i) {
	    px[x[i]] += z[i];
	    py[y[i]] += z[i];
	    s += z[i];
	  }
	
	  t = 1 / (s * Math.LN2);
	  for (i=0; i<n; ++i) {
	    if (z[i] === 0) continue;
	    p = (s * z[i]) / (px[x[i]] * py[y[i]]);
	    I += z[i] * t * Math.log(p);
	    H += z[i] * t * Math.log(z[i]/s);
	  }
	
	  return [I, 1 + I/H];
	};
	
	// Compute the mutual information between two discrete variables.
	stats.mutual.info = function(values, a, b, counts) {
	  return stats.mutual(values, a, b, counts)[0];
	};
	
	// Compute the mutual information distance between two discrete variables.
	// MI_distance is defined as 1 - I(a,b) / H(a,b).
	stats.mutual.dist = function(values, a, b, counts) {
	  return stats.mutual(values, a, b, counts)[1];
	};
	
	// Compute a profile of summary statistics for a variable.
	stats.profile = function(values, f) {
	  var mean = 0,
	      valid = 0,
	      missing = 0,
	      distinct = 0,
	      min = null,
	      max = null,
	      M2 = 0,
	      vals = [],
	      u = {}, delta, sd, i, v, x;
	
	  // compute summary stats
	  for (i=0; i<values.length; ++i) {
	    v = f ? f(values[i]) : values[i];
	
	    // update unique values
	    u[v] = (v in u) ? u[v] + 1 : (distinct += 1, 1);
	
	    if (v == null) {
	      ++missing;
	    } else if (util.isValid(v)) {
	      // update stats
	      x = (typeof v === 'string') ? v.length : v;
	      if (min===null || x < min) min = x;
	      if (max===null || x > max) max = x;
	      delta = x - mean;
	      mean = mean + delta / (++valid);
	      M2 = M2 + delta * (x - mean);
	      vals.push(x);
	    }
	  }
	  M2 = M2 / (valid - 1);
	  sd = Math.sqrt(M2);
	
	  // sort values for median and iqr
	  vals.sort(util.cmp);
	
	  return {
	    type:     type(values, f),
	    unique:   u,
	    count:    values.length,
	    valid:    valid,
	    missing:  missing,
	    distinct: distinct,
	    min:      min,
	    max:      max,
	    mean:     mean,
	    stdev:    sd,
	    median:   (v = stats.quantile(vals, 0.5)),
	    q1:       stats.quantile(vals, 0.25),
	    q3:       stats.quantile(vals, 0.75),
	    modeskew: sd === 0 ? 0 : (mean - v) / sd
	  };
	};
	
	// Compute profiles for all variables in a data set.
	stats.summary = function(data, fields) {
	  fields = fields || util.keys(data[0]);
	  var s = fields.map(function(f) {
	    var p = stats.profile(data, util.$(f));
	    return (p.field = f, p);
	  });
	  return (s.__summary__ = true, s);
	};


/***/ },
/* 39 */
/***/ function(module, exports, __webpack_require__) {

	var util = __webpack_require__(13),
	    gen = module.exports;
	
	gen.repeat = function(val, n) {
	  var a = Array(n), i;
	  for (i=0; i<n; ++i) a[i] = val;
	  return a;
	};
	
	gen.zeros = function(n) {
	  return gen.repeat(0, n);
	};
	
	gen.range = function(start, stop, step) {
	  if (arguments.length < 3) {
	    step = 1;
	    if (arguments.length < 2) {
	      stop = start;
	      start = 0;
	    }
	  }
	  if ((stop - start) / step == Infinity) throw new Error('Infinite range');
	  var range = [], i = -1, j;
	  if (step < 0) while ((j = start + step * ++i) > stop) range.push(j);
	  else while ((j = start + step * ++i) < stop) range.push(j);
	  return range;
	};
	
	gen.random = {};
	
	gen.random.uniform = function(min, max) {
	  if (max === undefined) {
	    max = min === undefined ? 1 : min;
	    min = 0;
	  }
	  var d = max - min;
	  var f = function() {
	    return min + d * Math.random();
	  };
	  f.samples = function(n) {
	    return gen.zeros(n).map(f);
	  };
	  f.pdf = function(x) {
	    return (x >= min && x <= max) ? 1/d : 0;
	  };
	  f.cdf = function(x) {
	    return x < min ? 0 : x > max ? 1 : (x - min) / d;
	  };
	  f.icdf = function(p) {
	    return (p >= 0 && p <= 1) ? min + p*d : NaN;
	  };
	  return f;
	};
	
	gen.random.integer = function(a, b) {
	  if (b === undefined) {
	    b = a;
	    a = 0;
	  }
	  var d = b - a;
	  var f = function() {
	    return a + Math.floor(d * Math.random());
	  };
	  f.samples = function(n) {
	    return gen.zeros(n).map(f);
	  };
	  f.pdf = function(x) {
	    return (x === Math.floor(x) && x >= a && x < b) ? 1/d : 0;
	  };
	  f.cdf = function(x) {
	    var v = Math.floor(x);
	    return v < a ? 0 : v >= b ? 1 : (v - a + 1) / d;
	  };
	  f.icdf = function(p) {
	    return (p >= 0 && p <= 1) ? a - 1 + Math.floor(p*d) : NaN;
	  };
	  return f;
	};
	
	gen.random.normal = function(mean, stdev) {
	  mean = mean || 0;
	  stdev = stdev || 1;
	  var next;
	  var f = function() {
	    var x = 0, y = 0, rds, c;
	    if (next !== undefined) {
	      x = next;
	      next = undefined;
	      return x;
	    }
	    do {
	      x = Math.random()*2-1;
	      y = Math.random()*2-1;
	      rds = x*x + y*y;
	    } while (rds === 0 || rds > 1);
	    c = Math.sqrt(-2*Math.log(rds)/rds); // Box-Muller transform
	    next = mean + y*c*stdev;
	    return mean + x*c*stdev;
	  };
	  f.samples = function(n) {
	    return gen.zeros(n).map(f);
	  };
	  f.pdf = function(x) {
	    var exp = Math.exp(Math.pow(x-mean, 2) / (-2 * Math.pow(stdev, 2)));
	    return (1 / (stdev * Math.sqrt(2*Math.PI))) * exp;
	  };
	  f.cdf = function(x) {
	    // Approximation from West (2009)
	    // Better Approximations to Cumulative Normal Functions
	    var cd,
	        z = (x - mean) / stdev,
	        Z = Math.abs(z);
	    if (Z > 37) {
	      cd = 0;
	    } else {
	      var sum, exp = Math.exp(-Z*Z/2);
	      if (Z < 7.07106781186547) {
	        sum = 3.52624965998911e-02 * Z + 0.700383064443688;
	        sum = sum * Z + 6.37396220353165;
	        sum = sum * Z + 33.912866078383;
	        sum = sum * Z + 112.079291497871;
	        sum = sum * Z + 221.213596169931;
	        sum = sum * Z + 220.206867912376;
	        cd = exp * sum;
	        sum = 8.83883476483184e-02 * Z + 1.75566716318264;
	        sum = sum * Z + 16.064177579207;
	        sum = sum * Z + 86.7807322029461;
	        sum = sum * Z + 296.564248779674;
	        sum = sum * Z + 637.333633378831;
	        sum = sum * Z + 793.826512519948;
	        sum = sum * Z + 440.413735824752;
	        cd = cd / sum;
	      } else {
	        sum = Z + 0.65;
	        sum = Z + 4 / sum;
	        sum = Z + 3 / sum;
	        sum = Z + 2 / sum;
	        sum = Z + 1 / sum;
	        cd = exp / sum / 2.506628274631;
	      }
	    }
	    return z > 0 ? 1 - cd : cd;
	  };
	  f.icdf = function(p) {
	    // Approximation of Probit function using inverse error function.
	    if (p <= 0 || p >= 1) return NaN;
	    var x = 2*p - 1,
	        v = (8 * (Math.PI - 3)) / (3 * Math.PI * (4-Math.PI)),
	        a = (2 / (Math.PI*v)) + (Math.log(1 - Math.pow(x,2)) / 2),
	        b = Math.log(1 - (x*x)) / v,
	        s = (x > 0 ? 1 : -1) * Math.sqrt(Math.sqrt((a*a) - b) - a);
	    return mean + stdev * Math.SQRT2 * s;
	  };
	  return f;
	};
	
	gen.random.bootstrap = function(domain, smooth) {
	  // Generates a bootstrap sample from a set of observations.
	  // Smooth bootstrapping adds random zero-centered noise to the samples.
	  var val = domain.filter(util.isValid),
	      len = val.length,
	      err = smooth ? gen.random.normal(0, smooth) : null;
	  var f = function() {
	    return val[~~(Math.random()*len)] + (err ? err() : 0);
	  };
	  f.samples = function(n) {
	    return gen.zeros(n).map(f);
	  };
	  return f;
	};

/***/ },
/* 40 */
/***/ function(module, exports, __webpack_require__) {

	var util = __webpack_require__(13);
	var stats = __webpack_require__(38);
	
	var REM = '__dl_rem__';
	
	function Collector(key) {
	  this._add = [];
	  this._rem = [];
	  this._key = key || null;
	  this._last = null;
	}
	
	var proto = Collector.prototype;
	
	proto.add = function(v) {
	  this._add.push(v);
	};
	
	proto.rem = function(v) {
	  this._rem.push(v);
	};
	
	proto.values = function() {
	  this._get = null;
	  if (this._rem.length === 0) return this._add;
	
	  var a = this._add,
	      r = this._rem,
	      k = this._key,
	      x = Array(a.length - r.length),
	      i, j, n, m;
	
	  if (!util.isObject(r[0])) {
	    // processing raw values
	    m = stats.count.map(r);
	    for (i=0, j=0, n=a.length; i<n; ++i) {
	      if (m[a[i]] > 0) {
	        m[a[i]] -= 1;
	      } else {
	        x[j++] = a[i];
	      }
	    }
	  } else if (k) {
	    // has unique key field, so use that
	    m = util.toMap(r, k);
	    for (i=0, j=0, n=a.length; i<n; ++i) {
	      if (!m.hasOwnProperty(k(a[i]))) { x[j++] = a[i]; }
	    }
	  } else {
	    // no unique key, mark tuples directly
	    for (i=0, n=r.length; i<n; ++i) {
	      r[i][REM] = 1;
	    }
	    for (i=0, j=0, n=a.length; i<n; ++i) {
	      if (!a[i][REM]) { x[j++] = a[i]; }
	    }
	    for (i=0, n=r.length; i<n; ++i) {
	      delete r[i][REM];
	    }
	  }
	
	  this._rem = [];
	  return (this._add = x);
	};
	
	// memoizing statistics methods
	
	proto.extent = function(get) {
	  if (this._get !== get || !this._ext) {
	    var v = this.values(),
	        i = stats.extent.index(v, get);
	    this._ext = [v[i[0]], v[i[1]]];
	    this._get = get;
	  }
	  return this._ext;
	};
	
	proto.argmin = function(get) {
	  return this.extent(get)[0];
	};
	
	proto.argmax = function(get) {
	  return this.extent(get)[1];
	};
	
	proto.min = function(get) {
	  var m = this.extent(get)[0];
	  return m != null ? get(m) : +Infinity;
	};
	
	proto.max = function(get) {
	  var m = this.extent(get)[1];
	  return m != null ? get(m) : -Infinity;
	};
	
	proto.quartile = function(get) {
	  if (this._get !== get || !this._q) {
	    this._q = stats.quartile(this.values(), get);
	    this._get = get;
	  }
	  return this._q;
	};
	
	proto.q1 = function(get) {
	  return this.quartile(get)[0];
	};
	
	proto.q2 = function(get) {
	  return this.quartile(get)[1];
	};
	
	proto.q3 = function(get) {
	  return this.quartile(get)[2];
	};
	
	module.exports = Collector;


/***/ },
/* 41 */
/***/ function(module, exports, __webpack_require__) {

	var util = __webpack_require__(13);
	var Aggregator = __webpack_require__(36);
	
	module.exports = function() {
	  // flatten arguments into a single array
	  var args = [].reduce.call(arguments, function(a, x) {
	    return a.concat(util.array(x));
	  }, []);
	  // create and return an aggregator
	  return new Aggregator()
	    .groupby(args)
	    .summarize({'*':'values'});
	};


/***/ },
/* 42 */
/***/ function(module, exports, __webpack_require__) {

	var util = __webpack_require__(13),
	    time = __webpack_require__(43),
	    EPSILON = 1e-15;
	
	function bins(opt) {
	  if (!opt) { throw Error("Missing binning options."); }
	
	  // determine range
	  var maxb = opt.maxbins || 15,
	      base = opt.base || 10,
	      logb = Math.log(base),
	      div = opt.div || [5, 2],
	      min = opt.min,
	      max = opt.max,
	      span = max - min,
	      step, level, minstep, precision, v, i, eps;
	
	  if (opt.step) {
	    // if step size is explicitly given, use that
	    step = opt.step;
	  } else if (opt.steps) {
	    // if provided, limit choice to acceptable step sizes
	    step = opt.steps[Math.min(
	      opt.steps.length - 1,
	      bisect(opt.steps, span/maxb, 0, opt.steps.length)
	    )];
	  } else {
	    // else use span to determine step size
	    level = Math.ceil(Math.log(maxb) / logb);
	    minstep = opt.minstep || 0;
	    step = Math.max(
	      minstep,
	      Math.pow(base, Math.round(Math.log(span) / logb) - level)
	    );
	
	    // increase step size if too many bins
	    while (Math.ceil(span/step) > maxb) { step *= base; }
	
	    // decrease step size if allowed
	    for (i=0; i<div.length; ++i) {
	      v = step / div[i];
	      if (v >= minstep && span / v <= maxb) step = v;
	    }
	  }
	
	  // update precision, min and max
	  v = Math.log(step);
	  precision = v >= 0 ? 0 : ~~(-v / logb) + 1;
	  eps = Math.pow(base, -precision - 1);
	  min = Math.min(min, Math.floor(min / step + eps) * step);
	  max = Math.ceil(max / step) * step;
	
	  return {
	    start: min,
	    stop:  max,
	    step:  step,
	    unit:  {precision: precision},
	    value: value,
	    index: index
	  };
	}
	
	function bisect(a, x, lo, hi) {
	  while (lo < hi) {
	    var mid = lo + hi >>> 1;
	    if (util.cmp(a[mid], x) < 0) { lo = mid + 1; }
	    else { hi = mid; }
	  }
	  return lo;
	}
	
	function value(v) {
	  return this.step * Math.floor(v / this.step + EPSILON);
	}
	
	function index(v) {
	  return Math.floor((v - this.start) / this.step + EPSILON);
	}
	
	function date_value(v) {
	  return this.unit.date(value.call(this, v));
	}
	
	function date_index(v) {
	  return index.call(this, this.unit.unit(v));
	}
	
	bins.date = function(opt) {
	  if (!opt) { throw Error("Missing date binning options."); }
	
	  // find time step, then bin
	  var units = opt.utc ? time.utc : time,
	      dmin = opt.min,
	      dmax = opt.max,
	      maxb = opt.maxbins || 20,
	      minb = opt.minbins || 4,
	      span = (+dmax) - (+dmin),
	      unit = opt.unit ? units[opt.unit] : units.find(span, minb, maxb),
	      spec = bins({
	        min:     unit.min != null ? unit.min : unit.unit(dmin),
	        max:     unit.max != null ? unit.max : unit.unit(dmax),
	        maxbins: maxb,
	        minstep: unit.minstep,
	        steps:   unit.step
	      });
	
	  spec.unit = unit;
	  spec.index = date_index;
	  if (!opt.raw) spec.value = date_value;
	  return spec;
	};
	
	module.exports = bins;


/***/ },
/* 43 */
/***/ function(module, exports, __webpack_require__) {

	var d3_time = __webpack_require__(33);
	
	var tempDate = new Date(),
	    baseDate = new Date(0, 0, 1).setFullYear(0), // Jan 1, 0 AD
	    utcBaseDate = new Date(Date.UTC(0, 0, 1)).setUTCFullYear(0);
	
	function date(d) {
	  return (tempDate.setTime(+d), tempDate);
	}
	
	// create a time unit entry
	function entry(type, date, unit, step, min, max) {
	  var e = {
	    type: type,
	    date: date,
	    unit: unit
	  };
	  if (step) {
	    e.step = step;
	  } else {
	    e.minstep = 1;
	  }
	  if (min != null) e.min = min;
	  if (max != null) e.max = max;
	  return e;
	}
	
	function create(type, unit, base, step, min, max) {
	  return entry(type,
	    function(d) { return unit.offset(base, d); },
	    function(d) { return unit.count(base, d); },
	    step, min, max);
	}
	
	var locale = [
	  create('second', d3_time.second, baseDate),
	  create('minute', d3_time.minute, baseDate),
	  create('hour',   d3_time.hour,   baseDate),
	  create('day',    d3_time.day,    baseDate, [1, 7]),
	  create('month',  d3_time.month,  baseDate, [1, 3, 6]),
	  create('year',   d3_time.year,   baseDate),
	
	  // periodic units
	  entry('seconds',
	    function(d) { return new Date(1970, 0, 1, 0, 0, d); },
	    function(d) { return date(d).getSeconds(); },
	    null, 0, 59
	  ),
	  entry('minutes',
	    function(d) { return new Date(1970, 0, 1, 0, d); },
	    function(d) { return date(d).getMinutes(); },
	    null, 0, 59
	  ),
	  entry('hours',
	    function(d) { return new Date(1970, 0, 1, d); },
	    function(d) { return date(d).getHours(); },
	    null, 0, 23
	  ),
	  entry('weekdays',
	    function(d) { return new Date(1970, 0, 4+d); },
	    function(d) { return date(d).getDay(); },
	    [1], 0, 6
	  ),
	  entry('dates',
	    function(d) { return new Date(1970, 0, d); },
	    function(d) { return date(d).getDate(); },
	    [1], 1, 31
	  ),
	  entry('months',
	    function(d) { return new Date(1970, d % 12, 1); },
	    function(d) { return date(d).getMonth(); },
	    [1], 0, 11
	  )
	];
	
	var utc = [
	  create('second', d3_time.utcSecond, utcBaseDate),
	  create('minute', d3_time.utcMinute, utcBaseDate),
	  create('hour',   d3_time.utcHour,   utcBaseDate),
	  create('day',    d3_time.utcDay,    utcBaseDate, [1, 7]),
	  create('month',  d3_time.utcMonth,  utcBaseDate, [1, 3, 6]),
	  create('year',   d3_time.utcYear,   utcBaseDate),
	
	  // periodic units
	  entry('seconds',
	    function(d) { return new Date(Date.UTC(1970, 0, 1, 0, 0, d)); },
	    function(d) { return date(d).getUTCSeconds(); },
	    null, 0, 59
	  ),
	  entry('minutes',
	    function(d) { return new Date(Date.UTC(1970, 0, 1, 0, d)); },
	    function(d) { return date(d).getUTCMinutes(); },
	    null, 0, 59
	  ),
	  entry('hours',
	    function(d) { return new Date(Date.UTC(1970, 0, 1, d)); },
	    function(d) { return date(d).getUTCHours(); },
	    null, 0, 23
	  ),
	  entry('weekdays',
	    function(d) { return new Date(Date.UTC(1970, 0, 4+d)); },
	    function(d) { return date(d).getUTCDay(); },
	    [1], 0, 6
	  ),
	  entry('dates',
	    function(d) { return new Date(Date.UTC(1970, 0, d)); },
	    function(d) { return date(d).getUTCDate(); },
	    [1], 1, 31
	  ),
	  entry('months',
	    function(d) { return new Date(Date.UTC(1970, d % 12, 1)); },
	    function(d) { return date(d).getUTCMonth(); },
	    [1], 0, 11
	  )
	];
	
	var STEPS = [
	  [31536e6, 5],  // 1-year
	  [7776e6, 4],   // 3-month
	  [2592e6, 4],   // 1-month
	  [12096e5, 3],  // 2-week
	  [6048e5, 3],   // 1-week
	  [1728e5, 3],   // 2-day
	  [864e5, 3],    // 1-day
	  [432e5, 2],    // 12-hour
	  [216e5, 2],    // 6-hour
	  [108e5, 2],    // 3-hour
	  [36e5, 2],     // 1-hour
	  [18e5, 1],     // 30-minute
	  [9e5, 1],      // 15-minute
	  [3e5, 1],      // 5-minute
	  [6e4, 1],      // 1-minute
	  [3e4, 0],      // 30-second
	  [15e3, 0],     // 15-second
	  [5e3, 0],      // 5-second
	  [1e3, 0]       // 1-second
	];
	
	function find(units, span, minb, maxb) {
	  var step = STEPS[0], i, n, bins;
	
	  for (i=1, n=STEPS.length; i<n; ++i) {
	    step = STEPS[i];
	    if (span > step[0]) {
	      bins = span / step[0];
	      if (bins > maxb) {
	        return units[STEPS[i-1][1]];
	      }
	      if (bins >= minb) {
	        return units[step[1]];
	      }
	    }
	  }
	  return units[STEPS[n-1][1]];
	}
	
	function toUnitMap(units) {
	  var map = {}, i, n;
	  for (i=0, n=units.length; i<n; ++i) {
	    map[units[i].type] = units[i];
	  }
	  map.find = function(span, minb, maxb) {
	    return find(units, span, minb, maxb);
	  };
	  return map;
	}
	
	module.exports = toUnitMap(locale);
	module.exports.utc = toUnitMap(utc);

/***/ },
/* 44 */
/***/ function(module, exports, __webpack_require__) {

	var bins = __webpack_require__(42),
	    gen  = __webpack_require__(39),
	    type = __webpack_require__(24),
	    util = __webpack_require__(13),
	    stats = __webpack_require__(38);
	
	var qtype = {
	  'integer': 1,
	  'number': 1,
	  'date': 1
	};
	
	function $bin(values, f, opt) {
	  opt = options(values, f, opt);
	  var b = spec(opt);
	  return !b ? (opt.accessor || util.identity) :
	    util.$func('bin', b.unit.unit ?
	      function(x) { return b.value(b.unit.unit(x)); } :
	      function(x) { return b.value(x); }
	    )(opt.accessor);
	}
	
	function histogram(values, f, opt) {
	  opt = options(values, f, opt);
	  var b = spec(opt);
	  return b ?
	    numerical(values, opt.accessor, b) :
	    categorical(values, opt.accessor, opt && opt.sort);
	}
	
	function spec(opt) {
	  var t = opt.type, b = null;
	  if (t == null || qtype[t]) {
	    if (t === 'integer' && opt.minstep == null) opt.minstep = 1;
	    b = (t === 'date') ? bins.date(opt) : bins(opt);
	  }
	  return b;
	}
	
	function options() {
	  var a = arguments,
	      i = 0,
	      values = util.isArray(a[i]) ? a[i++] : null,
	      f = util.isFunction(a[i]) || util.isString(a[i]) ? util.$(a[i++]) : null,
	      opt = util.extend({}, a[i]);
	
	  if (values) {
	    opt.type = opt.type || type(values, f);
	    if (qtype[opt.type]) {
	      var ext = stats.extent(values, f);
	      opt = util.extend({min: ext[0], max: ext[1]}, opt);
	    }
	  }
	  if (f) { opt.accessor = f; }
	  return opt;
	}
	
	function numerical(values, f, b) {
	  var h = gen.range(b.start, b.stop + b.step/2, b.step)
	    .map(function(v) { return {value: b.value(v), count: 0}; });
	
	  for (var i=0, v, j; i<values.length; ++i) {
	    v = f ? f(values[i]) : values[i];
	    if (util.isValid(v)) {
	      j = b.index(v);
	      if (j < 0 || j >= h.length || !isFinite(j)) continue;
	      h[j].count += 1;
	    }
	  }
	  h.bins = b;
	  return h;
	}
	
	function categorical(values, f, sort) {
	  var u = stats.unique(values, f),
	      c = stats.count.map(values, f);
	  return u.map(function(k) { return {value: k, count: c[k]}; })
	    .sort(util.comparator(sort ? '-count' : '+value'));
	}
	
	module.exports = {
	  $bin: $bin,
	  histogram: histogram
	};


/***/ },
/* 45 */
/***/ function(module, exports, __webpack_require__) {

	var util = __webpack_require__(13),
	    format = __webpack_require__(32);
	
	var context = {
	  formats:    [],
	  format_map: {},
	  truncate:   util.truncate,
	  pad:        util.pad,
	  day:        format.day,
	  month:      format.month,
	  quarter:    format.quarter
	};
	
	function template(text) {
	  var src = source(text, 'd');
	  src = 'var __t; return ' + src + ';';
	
	  /* jshint evil: true */
	  return (new Function('d', src)).bind(context);
	}
	
	template.source = source;
	template.context = context;
	template.format = get_format;
	module.exports = template;
	
	// Clear cache of format objects.
	// This can *break* prior template functions, so invoke with care!
	template.clearFormatCache = function() {
	  context.formats = [];
	  context.format_map = {};
	};
	
	// Generate property access code for use within template source.
	// object: the name of the object (variable) containing template data
	// property: the property access string, verbatim from template tag
	template.property = function(object, property) {
	  var src = util.field(property).map(util.str).join('][');
	  return object + '[' + src + ']';
	};
	
	// Generate source code for a template function.
	// text: the template text
	// variable: the name of the data object variable ('obj' by default)
	// properties: optional hash for collecting all accessed properties
	function source(text, variable, properties) {
	  variable = variable || 'obj';
	  var index = 0;
	  var src = '\'';
	  var regex = template_re;
	
	  // Compile the template source, escaping string literals appropriately.
	  text.replace(regex, function(match, interpolate, offset) {
	    src += text
	      .slice(index, offset)
	      .replace(template_escaper, template_escapeChar);
	    index = offset + match.length;
	
	    if (interpolate) {
	      src += '\'\n+((__t=(' +
	        template_var(interpolate, variable, properties) +
	        '))==null?\'\':__t)+\n\'';
	    }
	
	    // Adobe VMs need the match returned to produce the correct offest.
	    return match;
	  });
	  return src + '\'';
	}
	
	function template_var(text, variable, properties) {
	  var filters = text.match(filter_re);
	  var prop = filters.shift().trim();
	  var stringCast = true;
	
	  function strcall(fn) {
	    fn = fn || '';
	    if (stringCast) {
	      stringCast = false;
	      src = 'String(' + src + ')' + fn;
	    } else {
	      src += fn;
	    }
	    return src;
	  }
	
	  function date() {
	    return '(typeof ' + src + '==="number"?new Date('+src+'):'+src+')';
	  }
	
	  function formatter(type) {
	    var pattern = args[0];
	    if ((pattern[0] === '\'' && pattern[pattern.length-1] === '\'') ||
	        (pattern[0] === '"'  && pattern[pattern.length-1] === '"')) {
	      pattern = pattern.slice(1, -1);
	    } else {
	      throw Error('Format pattern must be quoted: ' + pattern);
	    }
	    a = template_format(pattern, type);
	    stringCast = false;
	    var arg = type === 'number' ? src : date();
	    src = 'this.formats['+a+']('+arg+')';
	  }
	
	  if (properties) properties[prop] = 1;
	  var src = template.property(variable, prop);
	
	  for (var i=0; i<filters.length; ++i) {
	    var f = filters[i], args = null, pidx, a, b;
	
	    if ((pidx=f.indexOf(':')) > 0) {
	      f = f.slice(0, pidx);
	      args = filters[i].slice(pidx+1)
	        .match(args_re)
	        .map(function(s) { return s.trim(); });
	    }
	    f = f.trim();
	
	    switch (f) {
	      case 'length':
	        strcall('.length');
	        break;
	      case 'lower':
	        strcall('.toLowerCase()');
	        break;
	      case 'upper':
	        strcall('.toUpperCase()');
	        break;
	      case 'lower-locale':
	        strcall('.toLocaleLowerCase()');
	        break;
	      case 'upper-locale':
	        strcall('.toLocaleUpperCase()');
	        break;
	      case 'trim':
	        strcall('.trim()');
	        break;
	      case 'left':
	        a = util.number(args[0]);
	        strcall('.slice(0,' + a + ')');
	        break;
	      case 'right':
	        a = util.number(args[0]);
	        strcall('.slice(-' + a +')');
	        break;
	      case 'mid':
	        a = util.number(args[0]);
	        b = a + util.number(args[1]);
	        strcall('.slice(+'+a+','+b+')');
	        break;
	      case 'slice':
	        a = util.number(args[0]);
	        strcall('.slice('+ a +
	          (args.length > 1 ? ',' + util.number(args[1]) : '') +
	          ')');
	        break;
	      case 'truncate':
	        a = util.number(args[0]);
	        b = args[1];
	        b = (b!=='left' && b!=='middle' && b!=='center') ? 'right' : b;
	        src = 'this.truncate(' + strcall() + ',' + a + ',\'' + b + '\')';
	        break;
	      case 'pad':
	        a = util.number(args[0]);
	        b = args[1];
	        b = (b!=='left' && b!=='middle' && b!=='center') ? 'right' : b;
	        src = 'this.pad(' + strcall() + ',' + a + ',\'' + b + '\')';
	        break;
	      case 'number':
	        formatter('number');
	        break;
	      case 'time':
	        formatter('time');
	        break;
	      case 'time-utc':
	        formatter('utc');
	        break;
	      case 'month':
	        src = 'this.month(' + src + ')';
	        break;
	      case 'month-abbrev':
	        src = 'this.month(' + src + ',true)';
	        break;
	      case 'day':
	        src = 'this.day(' + src + ')';
	        break;
	      case 'day-abbrev':
	        src = 'this.day(' + src + ',true)';
	        break;
	      case 'quarter':
	        src = 'this.quarter(' + src + ')';
	        break;
	      default:
	        throw Error('Unrecognized template filter: ' + f);
	    }
	  }
	
	  return src;
	}
	
	var template_re = /\{\{(.+?)\}\}|$/g,
	    filter_re = /(?:"[^"]*"|\'[^\']*\'|[^\|"]+|[^\|\']+)+/g,
	    args_re = /(?:"[^"]*"|\'[^\']*\'|[^,"]+|[^,\']+)+/g;
	
	// Certain characters need to be escaped so that they can be put into a
	// string literal.
	var template_escapes = {
	  '\'':     '\'',
	  '\\':     '\\',
	  '\r':     'r',
	  '\n':     'n',
	  '\u2028': 'u2028',
	  '\u2029': 'u2029'
	};
	
	var template_escaper = /\\|'|\r|\n|\u2028|\u2029/g;
	
	function template_escapeChar(match) {
	  return '\\' + template_escapes[match];
	}
	
	function template_format(pattern, type) {
	  var key = type + ':' + pattern;
	  if (context.format_map[key] == null) {
	    var f = format[type](pattern);
	    var i = context.formats.length;
	    context.formats.push(f);
	    context.format_map[key] = i;
	    return i;
	  }
	  return context.format_map[key];
	}
	
	function get_format(pattern, type) {
	  return context.formats[template_format(pattern, type)];
	}


/***/ },
/* 46 */
/***/ function(module, exports, __webpack_require__) {

	var util = __webpack_require__(13),
	    time = __webpack_require__(43),
	    utc = time.utc;
	
	var u = module.exports;
	
	u.$year   = util.$func('year', time.year.unit);
	u.$month  = util.$func('month', time.months.unit);
	u.$date   = util.$func('date', time.dates.unit);
	u.$day    = util.$func('day', time.weekdays.unit);
	u.$hour   = util.$func('hour', time.hours.unit);
	u.$minute = util.$func('minute', time.minutes.unit);
	u.$second = util.$func('second', time.seconds.unit);
	
	u.$utcYear   = util.$func('utcYear', utc.year.unit);
	u.$utcMonth  = util.$func('utcMonth', utc.months.unit);
	u.$utcDate   = util.$func('utcDate', utc.dates.unit);
	u.$utcDay    = util.$func('utcDay', utc.weekdays.unit);
	u.$utcHour   = util.$func('utcHour', utc.hours.unit);
	u.$utcMinute = util.$func('utcMinute', utc.minutes.unit);
	u.$utcSecond = util.$func('utcSecond', utc.seconds.unit);


/***/ },
/* 47 */
/***/ function(module, exports, __webpack_require__) {

	var util = __webpack_require__(13);
	var load = __webpack_require__(18);
	var read = __webpack_require__(23);
	
	module.exports = util
	  .keys(read.formats)
	  .reduce(function(out, type) {
	    out[type] = function(opt, format, callback) {
	      // process arguments
	      if (util.isString(opt)) { opt = {url: opt}; }
	      if (arguments.length === 2 && util.isFunction(format)) {
	        callback = format;
	        format = undefined;
	      }
	
	      // set up read format
	      format = util.extend({parse: 'auto'}, format);
	      format.type = type;
	
	      // load data
	      var data = load(opt, callback ? function(error, data) {
	        if (error) { callback(error, null); return; }
	        try {
	          // data loaded, now parse it (async)
	          data = read(data, format);
	          callback(null, data);
	        } catch (e) {
	          callback(e, null);
	        }
	      } : undefined);
	
	      // data loaded, now parse it (sync)
	      if (!callback) return read(data, format);
	    };
	    return out;
	  }, {});


/***/ },
/* 48 */
/***/ function(module, exports, __webpack_require__) {

	var util = __webpack_require__(13),
	    type = __webpack_require__(24),
	    stats = __webpack_require__(38),
	    template = __webpack_require__(45);
	
	module.exports = {
	  table:   formatTable,  // format a data table
	  summary: formatSummary // format a data table summary
	};
	
	var FMT = {
	  'date':    '|time:"%m/%d/%Y %H:%M:%S"',
	  'number':  '|number:".4f"',
	  'integer': '|number:"d"'
	};
	
	var POS = {
	  'number':  'left',
	  'integer': 'left'
	};
	
	function formatTable(data, opt) {
	  opt = util.extend({separator:' ', minwidth: 8, maxwidth: 15}, opt);
	  var fields = opt.fields || util.keys(data[0]),
	      types = type.all(data);
	
	  if (opt.start || opt.limit) {
	    var a = opt.start || 0,
	        b = opt.limit ? a + opt.limit : data.length;
	    data = data.slice(a, b);
	  }
	
	  // determine char width of fields
	  var lens = fields.map(function(name) {
	    var format = FMT[types[name]] || '',
	        t = template('{{' + name + format + '}}'),
	        l = stats.max(data, function(x) { return t(x).length; });
	    l = Math.max(Math.min(name.length, opt.minwidth), l);
	    return opt.maxwidth > 0 ? Math.min(l, opt.maxwidth) : l;
	  });
	
	  // print header row
	  var head = fields.map(function(name, i) {
	    return util.truncate(util.pad(name, lens[i], 'center'), lens[i]);
	  }).join(opt.separator);
	
	  // build template function for each row
	  var tmpl = template(fields.map(function(name, i) {
	    return '{{' +
	      name +
	      (FMT[types[name]] || '') +
	      ('|pad:' + lens[i] + ',' + (POS[types[name]] || 'right')) +
	      ('|truncate:' + lens[i]) +
	    '}}';
	  }).join(opt.separator));
	
	  // print table
	  return head + "\n" + data.map(tmpl).join('\n');
	}
	
	function formatSummary(s) {
	  s = s ? s.__summary__ ? s : stats.summary(s) : this;
	  var str = [], i, n;
	  for (i=0, n=s.length; i<n; ++i) {
	    str.push('-- ' + s[i].field + ' --');
	    if (s[i].type === 'string' || s[i].distinct < 10) {
	      str.push(printCategoricalProfile(s[i]));
	    } else {
	      str.push(printQuantitativeProfile(s[i]));
	    }
	    str.push('');
	  }
	  return str.join('\n');
	}
	
	function printQuantitativeProfile(p) {
	  return [
	    'valid:    ' + p.valid,
	    'missing:  ' + p.missing,
	    'distinct: ' + p.distinct,
	    'min:      ' + p.min,
	    'max:      ' + p.max,
	    'median:   ' + p.median,
	    'mean:     ' + p.mean,
	    'stdev:    ' + p.stdev,
	    'modeskew: ' + p.modeskew
	  ].join('\n');
	}
	
	function printCategoricalProfile(p) {
	  var list = [
	    'valid:    ' + p.valid,
	    'missing:  ' + p.missing,
	    'distinct: ' + p.distinct,
	    'top values: '
	  ];
	  var u = p.unique;
	  var top = util.keys(u)
	    .sort(function(a,b) { return u[b] - u[a]; })
	    .slice(0, 6)
	    .map(function(v) { return ' \'' + v + '\' (' + u[v] + ')'; });
	  return list.concat(top).join('\n');
	}

/***/ },
/* 49 */
/***/ function(module, exports, __webpack_require__) {

	var dl = __webpack_require__(12),
	    log = __webpack_require__(8),
	    Heap = __webpack_require__(50),
	    ChangeSet = __webpack_require__(5),
	    DataSource = __webpack_require__(11),
	    Collector = __webpack_require__(7),
	    Tuple = __webpack_require__(9),
	    Signal = __webpack_require__(51),
	    Deps = __webpack_require__(6);
	
	function Graph() {
	}
	
	var prototype = Graph.prototype;
	
	prototype.init = function() {
	  this._stamp = 0;
	  this._rank  = 0;
	
	  this._data = {};
	  this._signals = {};
	  this._requestedIndexes = {};
	
	  this.doNotPropagate = {};
	};
	
	prototype.rank = function() {
	  return ++this._rank;
	};
	
	prototype.values = function(type, names, hash) {
	  var data = (type === Deps.SIGNALS ? this._signals : this._data),
	      n = (names !== undefined ? names : dl.keys(data)),
	      vals, i;
	
	  if (Array.isArray(n)) {
	    vals = hash || {};
	    for (i=0; i<n.length; ++i) {
	      vals[n[i]] = data[n[i]].values();
	    }
	    return vals;
	  } else {
	    return data[n].values();
	  }
	};
	
	// Retain for backwards-compatibility
	prototype.dataValues = function(names) {
	  return this.values(Deps.DATA, names);
	};
	
	// Retain for backwards-compatibility
	prototype.signalValues = function(names) {
	  return this.values(Deps.SIGNALS, names);
	};
	
	prototype.data = function(name, pipeline, facet) {
	  var db = this._data;
	  if (!arguments.length) {
	    var all = [], key;
	    for (key in db) { all.push(db[key]); }
	    return all;
	  } else if (arguments.length === 1) {
	    return db[name];
	  } else {
	    return (db[name] = new DataSource(this, name, facet).pipeline(pipeline));
	  }
	};
	
	prototype.signal = function(name, init) {
	  if (arguments.length === 1) {
	    var m = this;
	    return Array.isArray(name) ?
	      name.map(function(n) { return m._signals[n]; }) :
	      this._signals[name];
	  } else {
	    return (this._signals[name] = new Signal(this, name, init));
	  }
	};
	
	prototype.signalRef = function(ref) {
	  if (!Array.isArray(ref)) {
	    ref = dl.field(ref);
	  }
	
	  var value = this.signal(ref[0]).value();
	  if (ref.length > 1) {
	    for (var i=1, n=ref.length; i<n; ++i) {
	      value = value[ref[i]];
	    }
	  }
	  return value;
	};
	
	prototype.requestIndex = function(data, field) {
	  var ri  = this._requestedIndexes,
	      reg = ri[data] || (ri[data] = {}); 
	  return (reg[field] = true, this);
	};
	
	prototype.buildIndexes = function() {
	  var ri = this._requestedIndexes,
	      data = dl.keys(ri),
	      i, len, j, jlen, d, src, fields, f;
	
	  for (i=0, len=data.length; i<len; ++i) {
	    src = this.data(d=data[i]);
	    if (!src) throw Error('Data source '+dl.str(d)+' does not exist.');
	
	    fields = dl.keys(ri[d]);
	    for (j=0, jlen=fields.length; j<jlen; ++j) {
	      if ((f=fields[j]) === null) continue;
	      src.getIndex(f);
	      ri[d][f] = null;
	    }
	  }
	
	  return this;
	};
	
	// Stamp should be specified with caution. It is necessary for inline datasources,
	// which need to be populated during the same cycle even though propagation has
	// passed that part of the dataflow graph. 
	// If skipSignals is true, Signal nodes do not get reevaluated but their listeners
	// are queued for propagation. This is useful when setting signal values in batch
	// (e.g., time travel to the initial state).
	prototype.propagate = function(pulse, node, stamp, skipSignals) {
	  var pulses = {},
	      listeners, next, nplse, tpls, ntpls, i, len, isSg;
	
	  // new PQ with each propagation cycle so that we can pulse branches
	  // of the dataflow graph during a propagation (e.g., when creating
	  // a new inline datasource).
	  var pq = new Heap(function(a, b) {
	    // Sort on qrank (queue-rank).
	    // Rank can change during propagation due to rewiring.
	    return a._qrank - b._qrank;
	  });
	
	  if (pulse.stamp) throw Error('Pulse already has a non-zero stamp.');
	
	  pulse.stamp = stamp || ++this._stamp;
	  pulses[node._id] = pulse;
	  pq.push(node.qrank(true));
	
	  while (pq.size() > 0) {
	    node  = pq.peek();
	    isSg  = node instanceof Signal;
	    pulse = pulses[node._id];
	
	    if (node.rank() !== node.qrank()) {
	      // A node's rank might change during a propagation. Re-queue if so.
	      pq.replace(node.qrank(true));
	    } else {
	      // Evaluate node and propagate pulse.
	      pq.pop();
	      pulses[node._id] = null;
	      listeners = node._listeners;
	
	      if (!isSg || (isSg && !skipSignals)) {
	        pulse = this.evaluate(pulse, node);
	      }
	
	      // Propagate the pulse.
	      if (pulse !== this.doNotPropagate) {
	        // Ensure reflow pulses always send reflow pulses even if skipped.
	        if (!pulse.reflow && node.reflows()) {
	          pulse = ChangeSet.create(pulse, true);
	        }
	
	        for (i=0, len=listeners.length; i<len; ++i) {
	          next = listeners[i];
	
	          if ((nplse = pulses[next._id]) !== undefined) {
	            if (nplse === null) throw Error('Already propagated to node.');
	            if (nplse === pulse) continue;  // Re-queueing the same pulse.
	
	            // We've already queued this node. Ensure there should be at most one
	            // pulse with tuples (add/mod/rem), and the remainder will be reflows.
	            tpls  = pulse.add.length || pulse.mod.length || pulse.rem.length;
	            ntpls = nplse.add.length || nplse.mod.length || nplse.rem.length;
	
	            if (tpls && ntpls) throw Error('Multiple changeset pulses to same node');
	
	            // Combine reflow and tuples into a single pulse.
	            pulses[next._id] = tpls ? pulse : nplse;
	            pulses[next._id].reflow = pulse.reflow || nplse.reflow;
	          } else {
	            // First time we're seeing this node, queue it for propagation.
	            pq.push(next.qrank(true));
	            pulses[next._id] = pulse;
	          }
	        }
	      }
	    }
	  }
	
	  return this.done(pulse);
	};
	
	// Perform final bookkeeping on the graph, after propagation is complete.
	//  - For all updated datasources, synchronize their previous values.
	prototype.done = function(pulse) {
	  log.debug(pulse, ['bookkeeping']);
	  for (var d in pulse.data) { this.data(d).synchronize(); }
	  return this;
	};
	
	// Process a new branch of the dataflow graph prior to connection:
	// (1) Insert new Collector nodes as needed.
	// (2) Track + return mutation/routing status of the branch.
	prototype.preprocess = function(branch) {
	  var graph = this,
	      mutates = 0,
	      node, router, collector, collects;
	
	  for (var i=0; i<branch.length; ++i) {
	    node = branch[i];
	
	    // Batch nodes need access to a materialized dataset.
	    if (node.batch() && !node._collector) {
	      if (router || !collector) {
	        node = new Collector(graph);
	        branch.splice(i, 0, node);
	        router = false;
	      } else {
	        node._collector = collector;
	      }
	    }
	
	    if ((collects = node.collector())) collector = node;
	    router  = router  || node.router() && !collects;
	    mutates = mutates || node.mutates();
	
	    // A collector needs to be inserted after tuple-producing
	    // nodes for correct previous value tracking.
	    if (node.produces()) {
	      branch.splice(i+1, 0, new Collector(graph));
	      router = false;
	    }
	  }
	
	  return {router: router, collector: collector, mutates: mutates};
	};
	
	prototype.connect = function(branch) {
	  var collector, node, data, signals, i, n, j, m, x, y;
	
	  // connect the pipeline
	  for (i=0, n=branch.length; i<n; ++i) {
	    node = branch[i];
	    if (node.collector()) collector = node;
	
	    data = node.dependency(Deps.DATA);
	    for (j=0, m=data.length; j<m; ++j) {
	      if (!(x=this.data(y=data[j]))) {
	        throw new Error('Unknown data source ' + dl.str(y));
	      }
	
	      x.addListener(collector);
	    }
	
	    signals = node.dependency(Deps.SIGNALS);
	    for (j=0, m=signals.length; j<m; ++j) {
	      if (!(x=this.signal(y=signals[j]))) {
	        throw new Error('Unknown signal ' + dl.str(y));
	      }
	
	      x.addListener(collector);
	    }
	
	    if (i > 0) branch[i-1].addListener(node);
	  }
	
	  return branch;
	};
	
	prototype.disconnect = function(branch) {
	  var collector, node, data, signals, i, n, j, m;
	
	  for (i=0, n=branch.length; i<n; ++i) {
	    node = branch[i];
	    if (node.collector()) collector = node;
	
	    data = node.dependency(Deps.DATA);
	    for (j=0, m=data.length; j<m; ++j) {
	      this.data(data[j]).removeListener(collector);
	    }
	
	    signals = node.dependency(Deps.SIGNALS);
	    for (j=0, m=signals.length; j<m; ++j) {
	      this.signal(signals[j]).removeListener(collector);
	    }
	
	    node.disconnect();
	  }
	
	  return branch;
	};
	
	prototype.synchronize = function(branch) {
	  var ids = {},
	      node, data, i, n, j, m, d, id;
	
	  for (i=0, n=branch.length; i<n; ++i) {
	    node = branch[i];
	    if (!node.collector()) continue;
	
	    for (j=0, data=node.data(), m=data.length; j<m; ++j) {
	      id = (d = data[j])._id;
	      if (ids[id]) continue;
	      Tuple.prev_update(d);
	      ids[id] = 1;
	    }
	  }
	
	  return this;
	};
	
	prototype.reevaluate = function(pulse, node) {
	  var reflowed = pulse.reflow && node.last() >= pulse.stamp,
	      run = node.router() || pulse.add.length || pulse.rem.length;
	
	  return run || !reflowed || node.reevaluate(pulse);
	};
	
	prototype.evaluate = function(pulse, node) {
	  if (!this.reevaluate(pulse, node)) return pulse;
	  pulse = node.evaluate(pulse);
	  node.last(pulse.stamp);
	  return pulse;
	};
	
	module.exports = Graph;


/***/ },
/* 50 */
/***/ function(module, exports) {

	function Heap(comparator) {
	  this.cmp = comparator;
	  this.nodes = [];
	}
	
	var prototype = Heap.prototype;
	
	prototype.size = function() {
	  return this.nodes.length;
	};
	
	prototype.clear = function() {
	  return (this.nodes = [], this);
	};
	
	prototype.peek = function() {
	  return this.nodes[0];
	};
	
	prototype.push = function(x) {
	  var array = this.nodes;
	  array.push(x);
	  return _siftdown(array, 0, array.length-1, this.cmp);
	};
	
	prototype.pop = function() {
	  var array = this.nodes,
	      last = array.pop(),
	      item;
	
	  if (array.length) {
	    item = array[0];
	    array[0] = last;
	    _siftup(array, 0, this.cmp);
	  } else {
	    item = last;
	  }
	  return item;
	};
	
	prototype.replace = function(item) {
	  var array = this.nodes,
	      retval = array[0];
	  array[0] = item;
	  _siftup(array, 0, this.cmp);
	  return retval;
	};
	
	prototype.pushpop = function(item) {
	  var array = this.nodes, ref = array[0];
	  if (array.length && this.cmp(ref, item) < 0) {
	    array[0] = item;
	    item = ref;
	    _siftup(array, 0, this.cmp);
	  }
	  return item;
	};
	
	function _siftdown(array, start, idx, cmp) {
	  var item, parent, pidx;
	
	  item = array[idx];
	  while (idx > start) {
	    pidx = (idx - 1) >> 1;
	    parent = array[pidx];
	    if (cmp(item, parent) < 0) {
	      array[idx] = parent;
	      idx = pidx;
	      continue;
	    }
	    break;
	  }
	  return (array[idx] = item);
	}
	
	function _siftup(array, idx, cmp) {
	  var start = idx,
	      end = array.length,
	      item = array[idx],
	      cidx = 2 * idx + 1, ridx;
	
	  while (cidx < end) {
	    ridx = cidx + 1;
	    if (ridx < end && cmp(array[cidx], array[ridx]) >= 0) {
	      cidx = ridx;
	    }
	    array[idx] = array[cidx];
	    idx = cidx;
	    cidx = 2 * idx + 1;
	  }
	  array[idx] = item;
	  return _siftdown(array, start, idx, cmp);
	}
	
	module.exports = Heap;


/***/ },
/* 51 */
/***/ function(module, exports, __webpack_require__) {

	var ChangeSet = __webpack_require__(5),
	    Node = __webpack_require__(10), // jshint ignore:line
	    Base = Node.prototype;
	
	function Signal(graph, name, initialValue) {
	  Base.init.call(this, graph);
	  this._name  = name;
	  this._value = initialValue;
	  this._verbose = false; // Verbose signals re-pulse the graph even if prev === val.
	  this._handlers = [];
	  return this;
	}
	
	var prototype = (Signal.prototype = Object.create(Base));
	prototype.constructor = Signal;
	
	prototype.name = function() {
	  return this._name;
	};
	
	prototype.value = function(val) {
	  if (!arguments.length) return this._value;
	  return (this._value = val, this);
	};
	
	// Alias to value, for shared API with DataSource
	prototype.values = prototype.value;
	
	prototype.verbose = function(v) {
	  if (!arguments.length) return this._verbose;
	  return (this._verbose = !!v, this);
	};
	
	prototype.evaluate = function(input) {
	  return input.signals[this._name] ? input : this._graph.doNotPropagate;
	};
	
	prototype.fire = function(cs) {
	  if (!cs) cs = ChangeSet.create(null, true);
	  cs.signals[this._name] = 1;
	  this._graph.propagate(cs, this);
	};
	
	prototype.on = function(handler) {
	  var signal = this,
	      node = new Node(this._graph);
	
	  node.evaluate = function(input) {
	    handler(signal.name(), signal.value());
	    return input;
	  };
	
	  this._handlers.push({
	    handler: handler,
	    node: node
	  });
	
	  return this.addListener(node);
	};
	
	prototype.off = function(handler) {
	  var h = this._handlers, i, x;
	
	  for (i=h.length; --i>=0;) {
	    if (!handler || h[i].handler === handler) {
	      x = h.splice(i, 1)[0];
	      this.removeListener(x.node);
	    }
	  }
	
	  return this;
	};
	
	module.exports = Signal;


/***/ },
/* 52 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = {
	  axes:       __webpack_require__(53),
	  background: __webpack_require__(99),
	  data:       __webpack_require__(100),
	  events:     __webpack_require__(134),
	  expr:       __webpack_require__(135),
	  legends:    __webpack_require__(141),
	  mark:       __webpack_require__(55),
	  marks:      __webpack_require__(143),
	  modify:     __webpack_require__(133),
	  padding:    __webpack_require__(144),
	  predicates: __webpack_require__(145),
	  properties: __webpack_require__(56),
	  signals:    __webpack_require__(146),
	  spec:       __webpack_require__(147),
	  streams:    __webpack_require__(157),
	  transforms: __webpack_require__(101)
	};


/***/ },
/* 53 */
/***/ function(module, exports, __webpack_require__) {

	var dl = __webpack_require__(12),
	    axs = __webpack_require__(54);
	
	var ORIENT = {
	  "x":      "bottom",
	  "y":      "left",
	  "top":    "top",
	  "bottom": "bottom",
	  "left":   "left",
	  "right":  "right"
	};
	
	function parseAxes(model, spec, axes, group) {
	  var config = model.config();
	  (spec || []).forEach(function(def, index) {
	    axes[index] = axes[index] || axs(model);
	    parseAxis(config, def, index, axes[index], group);
	  });
	}
	
	function parseAxis(config, def, index, axis, group) {
	  // axis scale
	  if (def.scale !== undefined) {
	    axis.scale(group.scale(def.scale));
	  }
	
	  // axis orientation
	  axis.orient(def.orient || ORIENT[def.type]);
	  // axis offset
	  axis.offset(def.offset || 0);
	  // axis layer
	  axis.layer(def.layer || "front");
	  // axis grid lines
	  axis.grid(def.grid || false);
	  // axis title
	  axis.title(def.title || null);
	  // axis title offset
	  axis.titleOffset(def.titleOffset != null ?
	    def.titleOffset : config.axis.titleOffset);
	  // axis values
	  axis.tickValues(def.values || null);
	  // axis label formatting
	  axis.tickFormat(def.format || null);
	  axis.tickFormatType(def.formatType || null);
	  // axis tick subdivision
	  axis.tickSubdivide(def.subdivide || 0);
	  // axis tick padding
	  axis.tickPadding(def.tickPadding || config.axis.padding);
	
	  // axis tick size(s)
	  var size = [];
	  if (def.tickSize !== undefined) {
	    for (var i=0; i<3; ++i) size.push(def.tickSize);
	  } else {
	    var ts = config.axis.tickSize;
	    size = [ts, ts, ts];
	  }
	  if (def.tickSizeMajor != null) size[0] = def.tickSizeMajor;
	  if (def.tickSizeMinor != null) size[1] = def.tickSizeMinor;
	  if (def.tickSizeEnd   != null) size[2] = def.tickSizeEnd;
	  if (size.length) {
	    axis.tickSize.apply(axis, size);
	  }
	
	  // axis tick count
	  axis.tickCount(def.ticks || config.axis.ticks);
	
	  // style properties
	  var p = def.properties;
	  if (p && p.ticks) {
	    axis.majorTickProperties(p.majorTicks ?
	      dl.extend({}, p.ticks, p.majorTicks) : p.ticks);
	    axis.minorTickProperties(p.minorTicks ?
	      dl.extend({}, p.ticks, p.minorTicks) : p.ticks);
	  } else {
	    axis.majorTickProperties(p && p.majorTicks || {});
	    axis.minorTickProperties(p && p.minorTicks || {});
	  }
	  axis.tickLabelProperties(p && p.labels || {});
	  axis.titleProperties(p && p.title || {});
	  axis.gridLineProperties(p && p.grid || {});
	  axis.domainProperties(p && p.axis || {});
	}
	
	module.exports = parseAxes;
	
	parseAxes.schema = {
	  "defs": {
	    "axis": {
	      "type": "object",
	      "properties": {
	        "type": {"enum": ["x", "y"]},
	        "scale": {"type": "string"},
	        "orient": {"enum": ["top", "bottom", "left", "right"]},
	        "title": {"type": "string"},
	        "titleOffset": {"type": "number"},
	        "format": {"type": "string"},
	        "formatType": {"enum": ["time", "utc", "string", "number"]},
	        "ticks": {"type": "number"},
	        "values": {
	          "type": "array",
	          "items": {"type": ["string", "number"]}
	        },
	        "subdivide": {"type": "number"},
	        "tickPadding": {"type": "number"},
	        "tickSize": {"type": "number"},
	        "tickSizeMajor": {"type": "number"},
	        "tickSizeMinor": {"type": "number"},
	        "tickSizeEnd": {"type": "number"},
	        "offset": {
	          "oneOf": [{"type": "number"}, {
	            "type": "object",
	            "properties": {
	              "scale": {"type": "string"},
	              "value": {"type": ["string", "number"]}
	            },
	            "required": ["scale", "value"],
	            "additionalProperties": false
	          }]
	        },
	        "layer": {"enum": ["front", "back"], "default": "front"},
	        "grid": {"type": "boolean"},
	        "properties": {
	          "type": "object",
	          "properties": {
	            "ticks": {"$ref": "#/defs/propset"},
	            "majorTicks": {"$ref": "#/defs/propset"},
	            "minorTicks": {"$ref": "#/defs/propset"},
	            "labels": {"$ref": "#/defs/propset"},
	            "title": {"$ref": "#/defs/propset"},
	            "grid": {"$ref": "#/defs/propset"},
	            "axis": {"$ref": "#/defs/propset"}
	          },
	          "additionalProperties": false
	        }
	      },
	      "additionalProperties": false,
	      "required": ["type", "scale"]
	    }
	  }
	};


/***/ },
/* 54 */
/***/ function(module, exports, __webpack_require__) {

	var dl = __webpack_require__(12),
	    Tuple = __webpack_require__(4).Tuple,
	    parseMark = __webpack_require__(55),
	    util = __webpack_require__(57);
	
	var axisBounds = new (__webpack_require__(59).Bounds)();
	var ORDINAL = 'ordinal';
	
	function axs(model) {
	  var scale,
	      config = model.config().axis,
	      orient = config.orient,
	      offset = 0,
	      titleOffset = config.titleOffset,
	      axisDef = {},
	      layer = 'front',
	      grid = false,
	      title = null,
	      tickMajorSize = config.tickSize,
	      tickMinorSize = config.tickSize,
	      tickEndSize = config.tickSize,
	      tickPadding = config.padding,
	      tickValues = null,
	      tickFormatString = null,
	      tickFormatType = null,
	      tickSubdivide = 0,
	      tickCount = config.ticks,
	      gridLineStyle = {},
	      tickLabelStyle = {},
	      majorTickStyle = {},
	      minorTickStyle = {},
	      titleStyle = {},
	      domainStyle = {},
	      m = { // Axis marks as references for updates
	        gridLines:  {},
	        majorTicks: {},
	        minorTicks: {},
	        tickLabels: {},
	        domain: {},
	        title:  {}
	      };
	
	  var axis = {};
	
	  function reset() {
	    axisDef.type = null;
	  }
	
	  function ingest(d) {
	    return {data: d};
	  }
	
	  function getTicks(format) {
	    var major = tickValues || (scale.ticks ? scale.ticks(tickCount) : scale.domain()),
	        minor = axisSubdivide(scale, major, tickSubdivide).map(ingest);
	    major = major.map(function(d) { return (d = ingest(d), d.label = format(d.data), d); });
	    return [major, minor];
	  }
	
	  axis.def = function() {
	    if (!axisDef.type) axis_def(scale);
	
	    var format = util.getTickFormat(scale, tickCount, tickFormatType, tickFormatString),
	        ticks  = getTicks(format),
	        tdata  = title ? [title].map(ingest) : [];
	
	    axisDef.marks[0].from = function() { return grid ? ticks[0] : []; };
	    axisDef.marks[1].from = function() { return ticks[0]; };
	    axisDef.marks[2].from = function() { return ticks[1]; };
	    axisDef.marks[3].from = axisDef.marks[1].from;
	    axisDef.marks[4].from = function() { return [1]; };
	    axisDef.marks[5].from = function() { return tdata; };
	    axisDef.offset = offset;
	    axisDef.orient = orient;
	    axisDef.layer = layer;
	    if (titleOffset === 'auto') titleAutoOffset(axisDef);
	
	    return axisDef;
	  };
	
	  function titleAutoOffset(axisDef) {
	    var orient = axisDef.orient,
	        update = axisDef.marks[5].properties.update,
	        fn = update.encode,
	        min = config.titleOffsetAutoMin,
	        max = config.titleOffsetAutoMax,
	        pad = config.titleOffsetAutoMargin;
	
	    // Offset axis title using bounding box of axis domain and labels
	    // Assumes other components are **encoded and bounded** beforehand
	    update.encode = function(item, group, trans, db, signals, preds) {
	      var dirty = fn.call(fn, item, group, trans, db, signals, preds),
	          field = (orient==='bottom' || orient==='top') ? 'y' : 'x';
	      if (titleStyle[field] != null) return dirty;
	
	      axisBounds.clear()
	        .union(group.items[3].bounds)
	        .union(group.items[4].bounds);
	
	      var o = trans ? {} : item,
	          method = (orient==='left' || orient==='right') ? 'width' : 'height',
	          sign = (orient==='top' || orient==='left') ? -1 : 1,
	          off = ~~(axisBounds[method]() + item.fontSize/2 + pad);
	
	      Tuple.set(o, field, sign * Math.min(Math.max(min, off), max));
	      if (trans) trans.interpolate(item, o);
	      return true;
	    };
	  }
	
	  function axis_def(scale) {
	    // setup scale mapping
	    var newScale, oldScale, range;
	    if (scale.type === ORDINAL) {
	      newScale = {scale: scale.scaleName, offset: 0.5 + scale.rangeBand()/2};
	      oldScale = newScale;
	    } else {
	      newScale = {scale: scale.scaleName, offset: 0.5};
	      oldScale = {scale: scale.scaleName+':prev', offset: 0.5};
	    }
	    range = axisScaleRange(scale);
	
	    // setup axis marks
	    dl.extend(m.gridLines, axisTicks(config));
	    dl.extend(m.majorTicks, axisTicks(config));
	    dl.extend(m.minorTicks, axisTicks(config));
	    dl.extend(m.tickLabels, axisTickLabels(config));
	    dl.extend(m.domain, axisDomain(config));
	    dl.extend(m.title, axisTitle(config));
	    m.gridLines.properties.enter.stroke = {value: config.gridColor};
	    m.gridLines.properties.enter.strokeOpacity = {value: config.gridOpacity};
	
	    // extend axis marks based on axis orientation
	    axisTicksExtend(orient, m.gridLines, oldScale, newScale, Infinity, offset);
	    axisTicksExtend(orient, m.majorTicks, oldScale, newScale, tickMajorSize);
	    axisTicksExtend(orient, m.minorTicks, oldScale, newScale, tickMinorSize);
	    axisLabelExtend(orient, m.tickLabels, oldScale, newScale, tickMajorSize, tickPadding);
	
	    axisDomainExtend(orient, m.domain, range, tickEndSize);
	    axisTitleExtend(orient, m.title, range, +titleOffset || -1);
	
	    // add / override custom style properties
	    dl.extend(m.gridLines.properties.update, gridLineStyle);
	    dl.extend(m.majorTicks.properties.update, majorTickStyle);
	    dl.extend(m.minorTicks.properties.update, minorTickStyle);
	    dl.extend(m.tickLabels.properties.update, tickLabelStyle);
	    dl.extend(m.domain.properties.update, domainStyle);
	    dl.extend(m.title.properties.update, titleStyle);
	
	    var marks = [m.gridLines, m.majorTicks, m.minorTicks, m.tickLabels, m.domain, m.title];
	    dl.extend(axisDef, {
	      type: 'group',
	      interactive: false,
	      properties: {
	        enter: {
	          encode: axisUpdate,
	          scales: [scale.scaleName],
	          signals: [], data: []
	        },
	        update: {
	          encode: axisUpdate,
	          scales: [scale.scaleName],
	          signals: [], data: []
	        }
	      }
	    });
	
	    axisDef.marks = marks.map(function(m) { return parseMark(model, m); });
	  }
	
	  axis.scale = function(x) {
	    if (!arguments.length) return scale;
	    if (scale !== x) { scale = x; reset(); }
	    return axis;
	  };
	
	  axis.orient = function(x) {
	    if (!arguments.length) return orient;
	    if (orient !== x) {
	      orient = x in axisOrients ? x + '' : config.orient;
	      reset();
	    }
	    return axis;
	  };
	
	  axis.title = function(x) {
	    if (!arguments.length) return title;
	    if (title !== x) { title = x; reset(); }
	    return axis;
	  };
	
	  axis.tickCount = function(x) {
	    if (!arguments.length) return tickCount;
	    tickCount = x;
	    return axis;
	  };
	
	  axis.tickValues = function(x) {
	    if (!arguments.length) return tickValues;
	    tickValues = x;
	    return axis;
	  };
	
	  axis.tickFormat = function(x) {
	    if (!arguments.length) return tickFormatString;
	    if (tickFormatString !== x) {
	      tickFormatString = x;
	      reset();
	    }
	    return axis;
	  };
	
	  axis.tickFormatType = function(x) {
	    if (!arguments.length) return tickFormatType;
	    if (tickFormatType !== x) {
	      tickFormatType = x;
	      reset();
	    }
	    return axis;
	  };
	
	  axis.tickSize = function(x, y) {
	    if (!arguments.length) return tickMajorSize;
	    var n = arguments.length - 1,
	        major = +x,
	        minor = n > 1 ? +y : tickMajorSize,
	        end   = n > 0 ? +arguments[n] : tickMajorSize;
	
	    if (tickMajorSize !== major ||
	        tickMinorSize !== minor ||
	        tickEndSize !== end) {
	      reset();
	    }
	
	    tickMajorSize = major;
	    tickMinorSize = minor;
	    tickEndSize = end;
	    return axis;
	  };
	
	  axis.tickSubdivide = function(x) {
	    if (!arguments.length) return tickSubdivide;
	    tickSubdivide = +x;
	    return axis;
	  };
	
	  axis.offset = function(x) {
	    if (!arguments.length) return offset;
	    offset = dl.isObject(x) ? x : +x;
	    return axis;
	  };
	
	  axis.tickPadding = function(x) {
	    if (!arguments.length) return tickPadding;
	    if (tickPadding !== +x) { tickPadding = +x; reset(); }
	    return axis;
	  };
	
	  axis.titleOffset = function(x) {
	    if (!arguments.length) return titleOffset;
	    if (titleOffset !== x) { titleOffset = x; reset(); }
	    return axis;
	  };
	
	  axis.layer = function(x) {
	    if (!arguments.length) return layer;
	    if (layer !== x) { layer = x; reset(); }
	    return axis;
	  };
	
	  axis.grid = function(x) {
	    if (!arguments.length) return grid;
	    if (grid !== x) { grid = x; reset(); }
	    return axis;
	  };
	
	  axis.gridLineProperties = function(x) {
	    if (!arguments.length) return gridLineStyle;
	    if (gridLineStyle !== x) { gridLineStyle = x; }
	    return axis;
	  };
	
	  axis.majorTickProperties = function(x) {
	    if (!arguments.length) return majorTickStyle;
	    if (majorTickStyle !== x) { majorTickStyle = x; }
	    return axis;
	  };
	
	  axis.minorTickProperties = function(x) {
	    if (!arguments.length) return minorTickStyle;
	    if (minorTickStyle !== x) { minorTickStyle = x; }
	    return axis;
	  };
	
	  axis.tickLabelProperties = function(x) {
	    if (!arguments.length) return tickLabelStyle;
	    if (tickLabelStyle !== x) { tickLabelStyle = x; }
	    return axis;
	  };
	
	  axis.titleProperties = function(x) {
	    if (!arguments.length) return titleStyle;
	    if (titleStyle !== x) { titleStyle = x; }
	    return axis;
	  };
	
	  axis.domainProperties = function(x) {
	    if (!arguments.length) return domainStyle;
	    if (domainStyle !== x) { domainStyle = x; }
	    return axis;
	  };
	
	  axis.reset = function() {
	    reset();
	    return axis;
	  };
	
	  return axis;
	}
	
	var axisOrients = {top: 1, right: 1, bottom: 1, left: 1};
	
	function axisSubdivide(scale, ticks, m) {
	  var subticks = [];
	  if (m && ticks.length > 1) {
	    var extent = axisScaleExtent(scale.domain()),
	        i = -1,
	        n = ticks.length,
	        d = (ticks[1] - ticks[0]) / ++m,
	        j,
	        v;
	    while (++i < n) {
	      for (j = m; --j > 0;) {
	        if ((v = +ticks[i] - j * d) >= extent[0]) {
	          subticks.push(v);
	        }
	      }
	    }
	    for (--i, j = 0; ++j < m && (v = +ticks[i] + j * d) < extent[1];) {
	      subticks.push(v);
	    }
	  }
	  return subticks;
	}
	
	function axisScaleExtent(domain) {
	  var start = domain[0], stop = domain[domain.length - 1];
	  return start < stop ? [start, stop] : [stop, start];
	}
	
	function axisScaleRange(scale) {
	  return scale.rangeExtent ?
	    scale.rangeExtent() :
	    axisScaleExtent(scale.range());
	}
	
	var axisAlign = {
	  bottom: 'center',
	  top: 'center',
	  left: 'right',
	  right: 'left'
	};
	
	var axisBaseline = {
	  bottom: 'top',
	  top: 'bottom',
	  left: 'middle',
	  right: 'middle'
	};
	
	function axisLabelExtend(orient, labels, oldScale, newScale, size, pad) {
	  size = Math.max(size, 0) + pad;
	  if (orient === 'left' || orient === 'top') {
	    size *= -1;
	  }
	  if (orient === 'top' || orient === 'bottom') {
	    dl.extend(labels.properties.enter, {
	      x: oldScale,
	      y: {value: size},
	    });
	    dl.extend(labels.properties.update, {
	      x: newScale,
	      y: {value: size},
	      align: {value: 'center'},
	      baseline: {value: axisBaseline[orient]}
	    });
	  } else {
	    dl.extend(labels.properties.enter, {
	      x: {value: size},
	      y: oldScale,
	    });
	    dl.extend(labels.properties.update, {
	      x: {value: size},
	      y: newScale,
	      align: {value: axisAlign[orient]},
	      baseline: {value: 'middle'}
	    });
	  }
	}
	
	function axisTicksExtend(orient, ticks, oldScale, newScale, size, offset) {
	  var sign = (orient === 'left' || orient === 'top') ? -1 : 1;
	  if (size === Infinity) {
	    size = (orient === 'top' || orient === 'bottom') ?
	      {field: {group: 'height', level: 2}, mult: -sign, offset: offset*-sign} :
	      {field: {group: 'width',  level: 2}, mult: -sign, offset: offset*-sign};
	  } else {
	    size = {value: sign * size, offset: offset};
	  }
	  if (orient === 'top' || orient === 'bottom') {
	    dl.extend(ticks.properties.enter, {
	      x:  oldScale,
	      y:  {value: 0},
	      y2: size
	    });
	    dl.extend(ticks.properties.update, {
	      x:  newScale,
	      y:  {value: 0},
	      y2: size
	    });
	    dl.extend(ticks.properties.exit, {
	      x:  newScale,
	    });
	  } else {
	    dl.extend(ticks.properties.enter, {
	      x:  {value: 0},
	      x2: size,
	      y:  oldScale
	    });
	    dl.extend(ticks.properties.update, {
	      x:  {value: 0},
	      x2: size,
	      y:  newScale
	    });
	    dl.extend(ticks.properties.exit, {
	      y:  newScale,
	    });
	  }
	}
	
	function axisTitleExtend(orient, title, range, offset) {
	  var update = title.properties.update,
	      mid = ~~((range[0] + range[1]) / 2),
	      sign = (orient === 'top' || orient === 'left') ? -1 : 1;
	
	  if (orient === 'bottom' || orient === 'top') {
	    update.x = {value: mid};
	    update.angle = {value: 0};
	    if (offset >= 0) update.y = {value: sign * offset};
	  } else {
	    update.y = {value: mid};
	    update.angle = {value: orient === 'left' ? -90 : 90};
	    if (offset >= 0) update.x = {value: sign * offset};
	  }
	}
	
	function axisDomainExtend(orient, domain, range, size) {
	  var path;
	  if (orient === 'top' || orient === 'left') {
	    size = -1 * size;
	  }
	  if (orient === 'bottom' || orient === 'top') {
	    path = 'M' + range[0] + ',' + size + 'V0H' + range[1] + 'V' + size;
	  } else {
	    path = 'M' + size + ',' + range[0] + 'H0V' + range[1] + 'H' + size;
	  }
	  domain.properties.update.path = {value: path};
	}
	
	function axisUpdate(item, group, trans) {
	  var o = trans ? {} : item,
	      offset = item.mark.def.offset,
	      orient = item.mark.def.orient,
	      width  = group.width,
	      height = group.height; // TODO fallback to global w,h?
	
	  if (dl.isArray(offset)) {
	    var ofx = offset[0],
	        ofy = offset[1];
	
	    switch (orient) {
	      case 'left':   { Tuple.set(o, 'x', -ofx); Tuple.set(o, 'y', ofy); break; }
	      case 'right':  { Tuple.set(o, 'x', width + ofx); Tuple.set(o, 'y', ofy); break; }
	      case 'bottom': { Tuple.set(o, 'x', ofx); Tuple.set(o, 'y', height + ofy); break; }
	      case 'top':    { Tuple.set(o, 'x', ofx); Tuple.set(o, 'y', -ofy); break; }
	      default:       { Tuple.set(o, 'x', ofx); Tuple.set(o, 'y', ofy); }
	    }
	  } else {
	    if (dl.isObject(offset)) {
	      offset = -group.scale(offset.scale)(offset.value);
	    }
	
	    switch (orient) {
	      case 'left':   { Tuple.set(o, 'x', -offset); Tuple.set(o, 'y', 0); break; }
	      case 'right':  { Tuple.set(o, 'x', width + offset); Tuple.set(o, 'y', 0); break; }
	      case 'bottom': { Tuple.set(o, 'x', 0); Tuple.set(o, 'y', height + offset); break; }
	      case 'top':    { Tuple.set(o, 'x', 0); Tuple.set(o, 'y', -offset); break; }
	      default:       { Tuple.set(o, 'x', 0); Tuple.set(o, 'y', 0); }
	    }
	  }
	
	  if (trans) trans.interpolate(item, o);
	  return true;
	}
	
	function axisTicks(config) {
	  return {
	    type: 'rule',
	    interactive: false,
	    key: 'data',
	    properties: {
	      enter: {
	        stroke: {value: config.tickColor},
	        strokeWidth: {value: config.tickWidth},
	        opacity: {value: 1e-6}
	      },
	      exit: { opacity: {value: 1e-6} },
	      update: { opacity: {value: 1} }
	    }
	  };
	}
	
	function axisTickLabels(config) {
	  return {
	    type: 'text',
	    interactive: true,
	    key: 'data',
	    properties: {
	      enter: {
	        fill: {value: config.tickLabelColor},
	        font: {value: config.tickLabelFont},
	        fontSize: {value: config.tickLabelFontSize},
	        opacity: {value: 1e-6},
	        text: {field: 'label'}
	      },
	      exit: { opacity: {value: 1e-6} },
	      update: { opacity: {value: 1} }
	    }
	  };
	}
	
	function axisTitle(config) {
	  return {
	    type: 'text',
	    interactive: true,
	    properties: {
	      enter: {
	        font: {value: config.titleFont},
	        fontSize: {value: config.titleFontSize},
	        fontWeight: {value: config.titleFontWeight},
	        fill: {value: config.titleColor},
	        align: {value: 'center'},
	        baseline: {value: 'middle'},
	        text: {field: 'data'}
	      },
	      update: {}
	    }
	  };
	}
	
	function axisDomain(config) {
	  return {
	    type: 'path',
	    interactive: false,
	    properties: {
	      enter: {
	        x: {value: 0.5},
	        y: {value: 0.5},
	        stroke: {value: config.axisColor},
	        strokeWidth: {value: config.axisWidth}
	      },
	      update: {}
	    }
	  };
	}
	
	module.exports = axs;


/***/ },
/* 55 */
/***/ function(module, exports, __webpack_require__) {

	var dl = __webpack_require__(12),
	    parseProperties = __webpack_require__(56);
	
	function parseMark(model, mark) {
	  var props = mark.properties,
	      group = mark.marks;
	
	  // parse mark property definitions
	  dl.keys(props).forEach(function(k) {
	    props[k] = parseProperties(model, mark.type, props[k]);
	  });
	
	  // parse delay function
	  if (mark.delay) {
	    mark.delay = parseProperties(model, mark.type, {delay: mark.delay});
	  }
	
	  // recurse if group type
	  if (group) {
	    mark.marks = group.map(function(g) { return parseMark(model, g); });
	  }
	
	  return mark;
	}
	
	module.exports = parseMark;
	
	parseMark.schema = {
	  "defs": {
	    "mark": {
	      "type": "object",
	
	      "properties": {
	        "name": {"type": "string"},
	        "key": {"type": "string"},
	        "type": {"enum": ["rect", "symbol", "path", "arc",
	          "area", "line", "rule", "image", "text", "group"]},
	
	        "from": {
	          "type": "object",
	          "properties": {
	            "data": {"type": "string"},
	            "mark": {"type": "string"},
	            "transform": {"$ref": "#/defs/transform"}
	          },
	          "additionalProperties": false
	        },
	
	        "delay": {"$ref": "#/refs/numberValue"},
	        "ease": {
	          "enum": ["linear", "quad", "cubic", "sin",
	            "exp", "circle", "bounce"].reduce(function(acc, e) {
	              ["in", "out", "in-out", "out-in"].forEach(function(m) {
	                acc.push(e+"-"+m);
	              });
	              return acc;
	          }, [])
	        },
	
	        "interactive": {"type": "boolean"},
	
	        "properties": {
	          "type": "object",
	          "properties": {
	            "enter":  {"$ref": "#/defs/propset"},
	            "update": {"$ref": "#/defs/propset"},
	            "exit":   {"$ref": "#/defs/propset"},
	            "hover":  {"$ref": "#/defs/propset"}
	          },
	          "additionalProperties": false,
	          "anyOf": [{"required": ["enter"]}, {"required": ["update"]}]
	        }
	      },
	
	      // "additionalProperties": false,
	      "required": ["type"]
	    }
	  }
	};


/***/ },
/* 56 */
/***/ function(module, exports, __webpack_require__) {

	var d3 = __webpack_require__(2),
	    dl = __webpack_require__(12),
	    log = __webpack_require__(8),
	    Tuple = __webpack_require__(4).Tuple;
	
	var DEPS = ["signals", "scales", "data", "fields"];
	
	function properties(model, mark, spec) {
	  var config = model.config(),
	      code = "",
	      names = dl.keys(spec),
	      exprs = [], // parsed expressions injected in the generated code
	      i, len, name, ref, vars = {},
	      deps = {
	        signals: {},
	        scales:  {},
	        data:    {},
	        fields:  {},
	        nested:  [],
	        _nRefs:  {},  // Temp stash to de-dupe nested refs.
	        reflow:  false
	      };
	
	  code += "var o = trans ? {} : item, d=0, exprs=this.exprs, set=this.tpl.set, tmpl=signals||{}, t;\n" +
	          // Stash for dl.template
	          "tmpl.datum  = item.datum;\n" +
	          "tmpl.group  = group;\n" +
	          "tmpl.parent = group.datum;\n";
	
	  function handleDep(p) {
	    if (ref[p] == null) return;
	    var k = dl.array(ref[p]), i, n;
	    for (i=0, n=k.length; i<n; ++i) {
	      deps[p][k[i]] = 1;
	    }
	  }
	
	  function handleNestedRefs(r) {
	    var k = (r.parent ? "parent_" : "group_")+r.level;
	    deps._nRefs[k] = r;
	  }
	
	  for (i=0, len=names.length; i<len; ++i) {
	    ref = spec[name = names[i]];
	    code += (i > 0) ? "\n  " : "  ";
	    if (ref.rule) {
	      // a production rule valueref
	      ref = rule(model, name, ref.rule, exprs);
	      code += "\n  " + ref.code;
	    } else if (dl.isArray(ref)) {
	      // a production rule valueref as an array
	      ref = rule(model, name, ref, exprs);
	      code += "\n  " + ref.code;
	    } else {
	      // a simple valueref
	      ref = valueRef(config, name, ref);
	      code += "d += set(o, "+dl.str(name)+", "+ref.val+");";
	    }
	
	    vars[name] = true;
	    DEPS.forEach(handleDep);
	    deps.reflow = deps.reflow || ref.reflow;
	    if (ref.nested.length) ref.nested.forEach(handleNestedRefs);
	  }
	
	  // If nested references are present, sort them based on their level
	  // to speed up determination of whether encoders should be reeval'd.
	  dl.keys(deps._nRefs).forEach(function(k) { deps.nested.push(deps._nRefs[k]); });
	  deps.nested.sort(function(a, b) {
	    a = a.level;
	    b = b.level;
	    return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
	  });
	
	  if (vars.x2) {
	    if (vars.x) {
	      code += "\n  if (o.x > o.x2) { " +
	              "\n    t = o.x;" +
	              "\n    d += set(o, 'x', o.x2);" +
	              "\n    d += set(o, 'x2', t); " +
	              "\n  };";
	      code += "\n  d += set(o, 'width', (o.x2 - o.x));";
	    } else if (vars.width) {
	      code += "\n  d += set(o, 'x', (o.x2 - o.width));";
	    } else {
	      code += "\n  d += set(o, 'x', o.x2);";
	    }
	  }
	
	  if (vars.xc) {
	    if (vars.width) {
	      code += "\n  d += set(o, 'x', (o.xc - o.width/2));" ;
	    } else {
	      code += "\n  d += set(o, 'x', o.xc);" ;
	    }
	  }
	
	  if (vars.y2) {
	    if (vars.y) {
	      code += "\n  if (o.y > o.y2) { " +
	              "\n    t = o.y;" +
	              "\n    d += set(o, 'y', o.y2);" +
	              "\n    d += set(o, 'y2', t);" +
	              "\n  };";
	      code += "\n  d += set(o, 'height', (o.y2 - o.y));";
	    } else if (vars.height) {
	      code += "\n  d += set(o, 'y', (o.y2 - o.height));";
	    } else {
	      code += "\n  d += set(o, 'y', o.y2);";
	    }
	  }
	
	  if (vars.yc) {
	    if (vars.height) {
	      code += "\n  d += set(o, 'y', (o.yc - o.height/2));" ;
	    } else {
	      code += "\n  d += set(o, 'y', o.yc);" ;
	    }
	  }
	
	  if (hasPath(mark, vars)) code += "\n  d += (item.touch(), 1);";
	  code += "\n  if (trans) trans.interpolate(item, o);";
	  code += "\n  return d > 0;";
	
	  try {
	    /* jshint evil:true */
	    var encoder = Function('item', 'group', 'trans', 'db',
	      'signals', 'predicates', code);
	
	    encoder.tpl  = Tuple;
	    encoder.exprs = exprs;
	    encoder.util = dl;
	    encoder.d3   = d3; // For color spaces
	    dl.extend(encoder, dl.template.context);
	    return {
	      encode:  encoder,
	      signals: dl.keys(deps.signals),
	      scales:  dl.keys(deps.scales),
	      data:    dl.keys(deps.data),
	      fields:  dl.keys(deps.fields),
	      nested:  deps.nested,
	      reflow:  deps.reflow
	    };
	  } catch (e) {
	    log.error(e);
	    log.log(code);
	  }
	}
	
	function dependencies(a, b) {
	  if (!dl.isObject(a)) {
	    a = {reflow: false, nested: []};
	    DEPS.forEach(function(d) { a[d] = []; });
	  }
	
	  if (dl.isObject(b)) {
	    a.reflow = a.reflow || b.reflow;
	    a.nested.push.apply(a.nested, b.nested);
	    DEPS.forEach(function(d) { a[d].push.apply(a[d], b[d]); });
	  }
	
	  return a;
	}
	
	function hasPath(mark, vars) {
	  return vars.path ||
	    ((mark==='area' || mark==='line') &&
	      (vars.x || vars.x2 || vars.width ||
	       vars.y || vars.y2 || vars.height ||
	       vars.tension || vars.interpolate));
	}
	
	function rule(model, name, rules, exprs) {
	  var config  = model.config(),
	      deps = dependencies(),
	      inputs  = [],
	      code = '';
	
	  (rules||[]).forEach(function(r, i) {
	    var ref = valueRef(config, name, r);
	    dependencies(deps, ref);
	
	    if (r.test) {
	      // rule uses an expression instead of a predicate.
	      var exprFn = model.expr(r.test);
	      deps.signals.push.apply(deps.signals, exprFn.globals);
	      deps.data.push.apply(deps.data, exprFn.dataSources);
	
	      code += "if (exprs[" + exprs.length + "](item.datum, null)) {" +
	          "\n    d += set(o, "+dl.str(name)+", " +ref.val+");";
	      code += rules[i+1] ? "\n  } else " : "  }";
	
	      exprs.push(exprFn.fn);
	    } else {
	      var def = r.predicate,
	          predName = def && (def.name || def),
	          pred = model.predicate(predName),
	          p = 'predicates['+dl.str(predName)+']',
	          input = [], args = name+'_arg'+i;
	
	      if (dl.isObject(def)) {
	        dl.keys(def).forEach(function(k) {
	          if (k === 'name') return;
	          var ref = valueRef(config, i, def[k], true);
	          input.push(dl.str(k)+': '+ref.val);
	          dependencies(deps, ref);
	        });
	      }
	
	      if (predName) {
	        // append the predicates dependencies to our dependencies
	        deps.signals.push.apply(deps.signals, pred.signals);
	        deps.data.push.apply(deps.data, pred.data);
	        inputs.push(args+" = {\n    "+input.join(",\n    ")+"\n  }");
	        code += "if ("+p+".call("+p+","+args+", db, signals, predicates)) {" +
	          "\n    d += set(o, "+dl.str(name)+", "+ref.val+");";
	        code += rules[i+1] ? "\n  } else " : "  }";
	      } else {
	        code += "{" +
	          "\n    d += set(o, "+dl.str(name)+", "+ref.val+");"+
	          "\n  }\n";
	      }
	    }
	  });
	
	  if (inputs.length) code = "var " + inputs.join(",\n      ") + ";\n  " + code;
	  return (deps.code = code, deps);
	}
	
	function valueRef(config, name, ref, predicateArg) {
	  if (ref == null) return null;
	
	  if (name==='fill' || name==='stroke') {
	    if (ref.c) {
	      return colorRef(config, 'hcl', ref.h, ref.c, ref.l);
	    } else if (ref.h || ref.s) {
	      return colorRef(config, 'hsl', ref.h, ref.s, ref.l);
	    } else if (ref.l || ref.a) {
	      return colorRef(config, 'lab', ref.l, ref.a, ref.b);
	    } else if (ref.r || ref.g || ref.b) {
	      return colorRef(config, 'rgb', ref.r, ref.g, ref.b);
	    }
	  }
	
	  // initialize value
	  var val = null, scale = null,
	      deps = dependencies(),
	      sgRef = null, fRef = null, sRef = null, tmpl = {};
	
	  if (ref.template !== undefined) {
	    val = dl.template.source(ref.template, 'tmpl', tmpl);
	    dl.keys(tmpl).forEach(function(k) {
	      var f = dl.field(k),
	          a = f.shift();
	      if (a === 'parent' || a === 'group') {
	        deps.nested.push({
	          parent: a === 'parent',
	          group:  a === 'group',
	          level:  1
	        });
	      } else if (a === 'datum') {
	        deps.fields.push(f[0]);
	      } else {
	        deps.signals.push(a);
	      }
	    });
	  }
	
	  if (ref.value !== undefined) {
	    val = dl.str(ref.value);
	  }
	
	  if (ref.signal !== undefined) {
	    sgRef = dl.field(ref.signal);
	    val = 'signals['+sgRef.map(dl.str).join('][')+']';
	    deps.signals.push(sgRef.shift());
	  }
	
	  if (ref.field !== undefined) {
	    ref.field = dl.isString(ref.field) ? {datum: ref.field} : ref.field;
	    fRef = fieldRef(ref.field);
	    val  = fRef.val;
	    dependencies(deps, fRef);
	  }
	
	  if (ref.scale !== undefined) {
	    sRef  = scaleRef(ref.scale);
	    scale = sRef.val;
	    dependencies(deps, sRef);
	    deps.scales.push(ref.scale.name || ref.scale);
	
	    // run through scale function if val specified.
	    // if no val, scale function is predicate arg.
	    if (val !== null || ref.band || ref.mult || ref.offset || !predicateArg) {
	      val = scale + (ref.band ? '.rangeBand()' :
	        '('+(val !== null ? val : 'item.datum.data')+')');
	    } else if (predicateArg) {
	      val = scale;
	    }
	  }
	
	  // multiply, offset, return value
	  val = '(' + (ref.mult?(dl.number(ref.mult)+' * '):'') + val + ')' +
	        (ref.offset ? ' + ' + dl.number(ref.offset) : '');
	
	  // Collate dependencies
	  return (deps.val = val, deps);
	}
	
	function colorRef(config, type, x, y, z) {
	  var xx = x ? valueRef(config, '', x) : config.color[type][0],
	      yy = y ? valueRef(config, '', y) : config.color[type][1],
	      zz = z ? valueRef(config, '', z) : config.color[type][2],
	      deps = dependencies();
	
	  [xx, yy, zz].forEach(function(v) {
	    if (dl.isArray) return;
	    dependencies(deps, v);
	  });
	
	  var val = '(this.d3.' + type + '(' + [xx.val, yy.val, zz.val].join(',') + ') + "")';
	  return (deps.val = val, deps);
	}
	
	// {field: {datum: "foo"} }  -> item.datum.foo
	// {field: {group: "foo"} }  -> group.foo
	// {field: {parent: "foo"} } -> group.datum.foo
	function fieldRef(ref) {
	  if (dl.isString(ref)) {
	    return {val: dl.field(ref).map(dl.str).join('][')};
	  }
	
	  // Resolve nesting/parent lookups
	  var l = ref.level || 1,
	      nested = (ref.group || ref.parent) && l,
	      scope = nested ? Array(l).join('group.mark.') : '',
	      r = fieldRef(ref.datum || ref.group || ref.parent || ref.signal),
	      val = r.val,
	      deps = dependencies(null, r);
	
	  if (ref.datum) {
	    val = 'item.datum['+val+']';
	    deps.fields.push(ref.datum);
	  } else if (ref.group) {
	    val = scope+'group['+val+']';
	    deps.nested.push({ level: l, group: true });
	  } else if (ref.parent) {
	    val = scope+'group.datum['+val+']';
	    deps.nested.push({ level: l, parent: true });
	  } else if (ref.signal) {
	    val = 'signals['+val+']';
	    deps.signals.push(dl.field(ref.signal)[0]);
	    deps.reflow = true;
	  }
	
	  return (deps.val = val, deps);
	}
	
	// {scale: "x"}
	// {scale: {name: "x"}},
	// {scale: fieldRef}
	function scaleRef(ref) {
	  var scale = null,
	      fr = null,
	      deps = dependencies();
	
	  if (dl.isString(ref)) {
	    scale = dl.str(ref);
	  } else if (ref.name) {
	    scale = dl.isString(ref.name) ? dl.str(ref.name) : (fr = fieldRef(ref.name)).val;
	  } else {
	    scale = (fr = fieldRef(ref)).val;
	  }
	
	  scale = '(item.mark._scaleRefs['+scale+'] = 1, group.scale('+scale+'))';
	  if (ref.invert) scale += '.invert';
	
	  // Mark scale refs as they're dealt with separately in mark._scaleRefs.
	  if (fr) fr.nested.forEach(function(g) { g.scale = true; });
	  return fr ? (fr.val = scale, fr) : (deps.val = scale, deps);
	}
	
	module.exports = properties;
	
	function valueSchema(type) {
	  type = dl.isArray(type) ? {"enum": type} : {"type": type};
	  var modType = type.type === "number" && type.type || "string";
	  var valRef  = {
	    "type": "object",
	    "allOf": [{"$ref": "#/refs/" + modType + "Modifiers"}, {
	      "oneOf": [{
	        "$ref": "#/refs/signal",
	        "required": ["signal"]
	      }, {
	        "properties": {"value": type},
	        "required": ["value"]
	      }, {
	        "properties": {"field": {"$ref": "#/refs/field"}},
	        "required": ["field"]
	      }, {
	        "properties": {"band": {"type": "boolean"}},
	        "required": ["band"]
	      }]
	    }]
	  };
	
	  if (type.type === "string") {
	    valRef.allOf[1].oneOf.push({
	      "properties": {"template": {"type": "string"}},
	      "required": ["template"]
	    });
	  }
	
	  return {
	    "oneOf": [{
	      "type": "object",
	      "properties": {
	        "rule": {
	          "type": "array",
	          "items": {
	            "allOf": [{"$ref": "#/defs/rule"}, valRef]
	          }
	        }
	      },
	      "additionalProperties": false,
	      "required": ["rule"]
	    },
	    {
	      "type": "array",
	      "items": {
	        "allOf": [{"$ref": "#/defs/rule"}, valRef]
	      }
	    },
	    valRef]
	  };
	}
	
	properties.schema = {
	  "refs": {
	    "field": {
	      "title": "FieldRef",
	      "oneOf": [
	        {"type": "string"},
	        {
	          "oneOf": [
	            {"$ref": "#/refs/signal"},
	            {
	              "type": "object",
	              "properties": {"datum": {"$ref": "#/refs/field"}},
	              "required": ["datum"],
	              "additionalProperties": false
	            },
	            {
	              "type": "object",
	              "properties": {
	                "group": {"$ref": "#/refs/field"},
	                "level": {"type": "number"}
	              },
	              "required": ["group"],
	              "additionalProperties": false
	            },
	            {
	              "type": "object",
	              "properties": {
	                "parent": {"$ref": "#/refs/field"},
	                "level": {"type": "number"}
	              },
	              "required": ["parent"],
	              "additionalProperties": false
	            }
	          ]
	        }
	      ]
	    },
	
	    "scale": {
	      "title": "ScaleRef",
	      "oneOf": [
	        {"$ref": "#/refs/field"},
	        {
	          "type": "object",
	          "properties": {
	            "name": {"$ref": "#/refs/field"},
	            "invert": {"type": "boolean", "default": false}
	          },
	          "required": ["name"]
	        }
	      ]
	    },
	
	    "stringModifiers": {
	      "properties": {
	        "scale": {"$ref": "#/refs/scale"}
	      }
	    },
	
	    "numberModifiers": {
	      "properties": {
	        "mult": {"type": "number"},
	        "offset": {"type": "number"},
	        "scale": {"$ref": "#/refs/scale"}
	      }
	    },
	
	    "value": valueSchema({}, "value"),
	    "numberValue": valueSchema("number", "numberValue"),
	    "stringValue": valueSchema("string", "stringValue"),
	    "booleanValue": valueSchema("boolean", "booleanValue"),
	    "arrayValue": valueSchema("array", "arrayValue"),
	
	    "colorValue": {
	      "title": "ColorRef",
	      "oneOf": [{"$ref": "#/refs/stringValue"}, {
	        "type": "object",
	        "properties": {
	          "r": {"$ref": "#/refs/numberValue"},
	          "g": {"$ref": "#/refs/numberValue"},
	          "b": {"$ref": "#/refs/numberValue"}
	        },
	        "required": ["r", "g", "b"]
	      }, {
	        "type": "object",
	        "properties": {
	          "h": {"$ref": "#/refs/numberValue"},
	          "s": {"$ref": "#/refs/numberValue"},
	          "l": {"$ref": "#/refs/numberValue"}
	        },
	        "required": ["h", "s", "l"]
	      }, {
	        "type": "object",
	        "properties": {
	          "l": {"$ref": "#/refs/numberValue"},
	          "a": {"$ref": "#/refs/numberValue"},
	          "b": {"$ref": "#/refs/numberValue"}
	        },
	        "required": ["l", "a", "b"]
	      }, {
	        "type": "object",
	        "properties": {
	          "h": {"$ref": "#/refs/numberValue"},
	          "c": {"$ref": "#/refs/numberValue"},
	          "l": {"$ref": "#/refs/numberValue"}
	        },
	        "required": ["h", "c", "l"]
	      }]
	    }
	  },
	
	  "defs": {
	    "rule": {
	      "anyOf": [
	        {
	          "type": "object",
	          "properties": {
	            "predicate": {
	              "oneOf": [
	                {"type": "string"},
	                {
	                  "type": "object",
	                  "properties": {"name": { "type": "string" }},
	                  "required": ["name"]
	                }
	              ]
	            }
	          }
	        },
	        {
	          "type": "object",
	          "properties": {"test": {"type": "string"}}
	        }
	      ]
	    },
	    "propset": {
	      "title": "Mark property set",
	      "type": "object",
	      "properties": {
	        // Common Properties
	        "x": {"$ref": "#/refs/numberValue"},
	        "x2": {"$ref": "#/refs/numberValue"},
	        "xc": {"$ref": "#/refs/numberValue"},
	        "width": {"$ref": "#/refs/numberValue"},
	        "y": {"$ref": "#/refs/numberValue"},
	        "y2": {"$ref": "#/refs/numberValue"},
	        "yc": {"$ref": "#/refs/numberValue"},
	        "height": {"$ref": "#/refs/numberValue"},
	        "opacity": {"$ref": "#/refs/numberValue"},
	        "fill": {"$ref": "#/refs/colorValue"},
	        "fillOpacity": {"$ref": "#/refs/numberValue"},
	        "stroke": {"$ref": "#/refs/colorValue"},
	        "strokeWidth": {"$ref": "#/refs/numberValue"},
	        "strokeOpacity": {"$ref": "#/refs/numberValue"},
	        "strokeDash": {"$ref": "#/refs/arrayValue"},
	        "strokeDashOffset": {"$ref": "#/refs/numberValue"},
	        "cursor": {"$ref": "#/refs/stringValue"},
	
	        // Group-mark properties
	        "clip": {"$ref": "#/refs/booleanValue"},
	
	        // Symbol-mark properties
	        "size": {"$ref": "#/refs/numberValue"},
	        "shape": valueSchema(["circle", "square",
	          "cross", "diamond", "triangle-up", "triangle-down"]),
	
	        // Path-mark properties
	        "path": {"$ref": "#/refs/stringValue"},
	
	        // Arc-mark properties
	        "innerRadius": {"$ref": "#/refs/numberValue"},
	        "outerRadius": {"$ref": "#/refs/numberValue"},
	        "startAngle": {"$ref": "#/refs/numberValue"},
	        "endAngle": {"$ref": "#/refs/numberValue"},
	
	        // Area- and line-mark properties
	        "interpolate": valueSchema(["linear", "step-before", "step-after",
	          "basis", "basis-open", "cardinal", "cardinal-open", "monotone"]),
	        "tension": {"$ref": "#/refs/numberValue"},
	        "orient": valueSchema(["horizontal", "vertical"]),
	
	        // Image-mark properties
	        "url": {"$ref": "#/refs/stringValue"},
	        "align": valueSchema(["left", "right", "center"]),
	        "baseline": valueSchema(["top", "middle", "bottom", "alphabetic"]),
	
	        // Text-mark properties
	        "text": {"$ref": "#/refs/stringValue"},
	        "dx": {"$ref": "#/refs/numberValue"},
	        "dy": {"$ref": "#/refs/numberValue"},
	        "radius":{"$ref": "#/refs/numberValue"},
	        "theta": {"$ref": "#/refs/numberValue"},
	        "angle": {"$ref": "#/refs/numberValue"},
	        "font": {"$ref": "#/refs/stringValue"},
	        "fontSize": {"$ref": "#/refs/numberValue"},
	        "fontWeight": {"$ref": "#/refs/stringValue"},
	        "fontStyle": {"$ref": "#/refs/stringValue"}
	      },
	
	      "additionalProperties": false
	    }
	  }
	};


/***/ },
/* 57 */
/***/ function(module, exports, __webpack_require__) {

	var dl = __webpack_require__(12),
	    u  = {};
	
	dl.extend(u, __webpack_require__(58));
	module.exports = dl.extend(u, dl);

/***/ },
/* 58 */
/***/ function(module, exports, __webpack_require__) {

	var dl = __webpack_require__(12);
	
	var TIME    = 'time',
	    UTC     = 'utc',
	    STRING  = 'string',
	    ORDINAL = 'ordinal',
	    NUMBER  = 'number';
	
	function getTickFormat(scale, tickCount, tickFormatType, tickFormatString) {
	  var formatType = tickFormatType || inferFormatType(scale);
	  return getFormatter(scale, tickCount, formatType, tickFormatString);
	}
	
	function inferFormatType(scale) {
	  switch (scale.type) {
	    case TIME:    return TIME;
	    case UTC:     return UTC;
	    case ORDINAL: return STRING;
	    default:      return NUMBER;
	  }
	}
	
	// Adapted from d3 log scale
	// TODO customize? replace with range-size-aware filtering?
	function logFilter(scale, domain, count, f) {
	  if (count == null) return f;
	  var base = scale.base(),
	      k = Math.min(base, scale.ticks().length / count),
	      v = domain[0] > 0 ? (e = 1e-12, Math.ceil) : (e = -1e-12, Math.floor),
	      e;
	  function log(x) {
	    return (domain[0] < 0 ?
	      -Math.log(x > 0 ? 0 : -x) :
	      Math.log(x < 0 ? 0 : x)) / Math.log(base);
	  }
	  function pow(x) {
	    return domain[0] < 0 ? -Math.pow(base, -x) : Math.pow(base, x);
	  }
	  return function(d) {
	    return pow(v(log(d) + e)) / d >= k ? f(d) : '';
	  };
	}
	
	function getFormatter(scale, tickCount, formatType, str) {
	  var fmt = dl.format,
	      log = scale.type === 'log',
	      domain;
	
	  switch (formatType) {
	    case NUMBER:
	      domain = scale.domain();
	      return log ?
	        logFilter(scale, domain, tickCount, fmt.auto.number(str || null)) :
	        fmt.auto.linear(domain, tickCount, str || null);
	    case TIME: return (str ? fmt : fmt.auto).time(str);
	    case UTC:  return (str ? fmt : fmt.auto).utc(str);
	    default:   return String;
	  }
	}
	
	module.exports = {
	  getTickFormat: getTickFormat
	};

/***/ },
/* 59 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = {
	  path:       __webpack_require__(60),
	  render:     __webpack_require__(64),
	  Item:       __webpack_require__(96),
	  bound:      __webpack_require__(83),
	  Bounds:     __webpack_require__(82),
	  canvas:     __webpack_require__(85),
	  Gradient:   __webpack_require__(97),
	  toJSON:     __webpack_require__(98).toJSON,
	  fromJSON:   __webpack_require__(98).fromJSON
	};

/***/ },
/* 60 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = {
	  parse:  __webpack_require__(61),
	  render: __webpack_require__(62)
	};


/***/ },
/* 61 */
/***/ function(module, exports) {

	// Path parsing and rendering code adapted from fabric.js -- Thanks!
	var cmdlen = { m:2, l:2, h:1, v:1, c:6, s:4, q:4, t:2, a:7 },
	    regexp = [/([MLHVCSQTAZmlhvcsqtaz])/g, /###/, /(\d)([-+])/g, /\s|,|###/];
	
	module.exports = function(pathstr) {
	  var result = [],
	      path,
	      curr,
	      chunks,
	      parsed, param,
	      cmd, len, i, j, n, m;
	
	  // First, break path into command sequence
	  path = pathstr
	    .slice()
	    .replace(regexp[0], '###$1')
	    .split(regexp[1])
	    .slice(1);
	
	  // Next, parse each command in turn
	  for (i=0, n=path.length; i<n; ++i) {
	    curr = path[i];
	    chunks = curr
	      .slice(1)
	      .trim()
	      .replace(regexp[2],'$1###$2')
	      .split(regexp[3]);
	    cmd = curr.charAt(0);
	
	    parsed = [cmd];
	    for (j=0, m=chunks.length; j<m; ++j) {
	      if ((param = +chunks[j]) === param) { // not NaN
	        parsed.push(param);
	      }
	    }
	
	    len = cmdlen[cmd.toLowerCase()];
	    if (parsed.length-1 > len) {
	      for (j=1, m=parsed.length; j<m; j+=len) {
	        result.push([cmd].concat(parsed.slice(j, j+len)));
	      }
	    }
	    else {
	      result.push(parsed);
	    }
	  }
	
	  return result;
	};


/***/ },
/* 62 */
/***/ function(module, exports, __webpack_require__) {

	var arc = __webpack_require__(63);
	
	module.exports = function(g, path, l, t) {
	  var current, // current instruction
	      previous = null,
	      x = 0, // current x
	      y = 0, // current y
	      controlX = 0, // current control point x
	      controlY = 0, // current control point y
	      tempX,
	      tempY,
	      tempControlX,
	      tempControlY;
	
	  if (l == null) l = 0;
	  if (t == null) t = 0;
	
	  g.beginPath();
	
	  for (var i=0, len=path.length; i<len; ++i) {
	    current = path[i];
	
	    switch (current[0]) { // first letter
	
	      case 'l': // lineto, relative
	        x += current[1];
	        y += current[2];
	        g.lineTo(x + l, y + t);
	        break;
	
	      case 'L': // lineto, absolute
	        x = current[1];
	        y = current[2];
	        g.lineTo(x + l, y + t);
	        break;
	
	      case 'h': // horizontal lineto, relative
	        x += current[1];
	        g.lineTo(x + l, y + t);
	        break;
	
	      case 'H': // horizontal lineto, absolute
	        x = current[1];
	        g.lineTo(x + l, y + t);
	        break;
	
	      case 'v': // vertical lineto, relative
	        y += current[1];
	        g.lineTo(x + l, y + t);
	        break;
	
	      case 'V': // verical lineto, absolute
	        y = current[1];
	        g.lineTo(x + l, y + t);
	        break;
	
	      case 'm': // moveTo, relative
	        x += current[1];
	        y += current[2];
	        g.moveTo(x + l, y + t);
	        break;
	
	      case 'M': // moveTo, absolute
	        x = current[1];
	        y = current[2];
	        g.moveTo(x + l, y + t);
	        break;
	
	      case 'c': // bezierCurveTo, relative
	        tempX = x + current[5];
	        tempY = y + current[6];
	        controlX = x + current[3];
	        controlY = y + current[4];
	        g.bezierCurveTo(
	          x + current[1] + l, // x1
	          y + current[2] + t, // y1
	          controlX + l, // x2
	          controlY + t, // y2
	          tempX + l,
	          tempY + t
	        );
	        x = tempX;
	        y = tempY;
	        break;
	
	      case 'C': // bezierCurveTo, absolute
	        x = current[5];
	        y = current[6];
	        controlX = current[3];
	        controlY = current[4];
	        g.bezierCurveTo(
	          current[1] + l,
	          current[2] + t,
	          controlX + l,
	          controlY + t,
	          x + l,
	          y + t
	        );
	        break;
	
	      case 's': // shorthand cubic bezierCurveTo, relative
	        // transform to absolute x,y
	        tempX = x + current[3];
	        tempY = y + current[4];
	        // calculate reflection of previous control points
	        controlX = 2 * x - controlX;
	        controlY = 2 * y - controlY;
	        g.bezierCurveTo(
	          controlX + l,
	          controlY + t,
	          x + current[1] + l,
	          y + current[2] + t,
	          tempX + l,
	          tempY + t
	        );
	
	        // set control point to 2nd one of this command
	        // the first control point is assumed to be the reflection of
	        // the second control point on the previous command relative
	        // to the current point.
	        controlX = x + current[1];
	        controlY = y + current[2];
	
	        x = tempX;
	        y = tempY;
	        break;
	
	      case 'S': // shorthand cubic bezierCurveTo, absolute
	        tempX = current[3];
	        tempY = current[4];
	        // calculate reflection of previous control points
	        controlX = 2*x - controlX;
	        controlY = 2*y - controlY;
	        g.bezierCurveTo(
	          controlX + l,
	          controlY + t,
	          current[1] + l,
	          current[2] + t,
	          tempX + l,
	          tempY + t
	        );
	        x = tempX;
	        y = tempY;
	        // set control point to 2nd one of this command
	        // the first control point is assumed to be the reflection of
	        // the second control point on the previous command relative
	        // to the current point.
	        controlX = current[1];
	        controlY = current[2];
	
	        break;
	
	      case 'q': // quadraticCurveTo, relative
	        // transform to absolute x,y
	        tempX = x + current[3];
	        tempY = y + current[4];
	
	        controlX = x + current[1];
	        controlY = y + current[2];
	
	        g.quadraticCurveTo(
	          controlX + l,
	          controlY + t,
	          tempX + l,
	          tempY + t
	        );
	        x = tempX;
	        y = tempY;
	        break;
	
	      case 'Q': // quadraticCurveTo, absolute
	        tempX = current[3];
	        tempY = current[4];
	
	        g.quadraticCurveTo(
	          current[1] + l,
	          current[2] + t,
	          tempX + l,
	          tempY + t
	        );
	        x = tempX;
	        y = tempY;
	        controlX = current[1];
	        controlY = current[2];
	        break;
	
	      case 't': // shorthand quadraticCurveTo, relative
	
	        // transform to absolute x,y
	        tempX = x + current[1];
	        tempY = y + current[2];
	
	        if (previous[0].match(/[QqTt]/) === null) {
	          // If there is no previous command or if the previous command was not a Q, q, T or t,
	          // assume the control point is coincident with the current point
	          controlX = x;
	          controlY = y;
	        }
	        else if (previous[0] === 't') {
	          // calculate reflection of previous control points for t
	          controlX = 2 * x - tempControlX;
	          controlY = 2 * y - tempControlY;
	        }
	        else if (previous[0] === 'q') {
	          // calculate reflection of previous control points for q
	          controlX = 2 * x - controlX;
	          controlY = 2 * y - controlY;
	        }
	
	        tempControlX = controlX;
	        tempControlY = controlY;
	
	        g.quadraticCurveTo(
	          controlX + l,
	          controlY + t,
	          tempX + l,
	          tempY + t
	        );
	        x = tempX;
	        y = tempY;
	        controlX = x + current[1];
	        controlY = y + current[2];
	        break;
	
	      case 'T':
	        tempX = current[1];
	        tempY = current[2];
	
	        // calculate reflection of previous control points
	        controlX = 2 * x - controlX;
	        controlY = 2 * y - controlY;
	        g.quadraticCurveTo(
	          controlX + l,
	          controlY + t,
	          tempX + l,
	          tempY + t
	        );
	        x = tempX;
	        y = tempY;
	        break;
	
	      case 'a':
	        drawArc(g, x + l, y + t, [
	          current[1],
	          current[2],
	          current[3],
	          current[4],
	          current[5],
	          current[6] + x + l,
	          current[7] + y + t
	        ]);
	        x += current[6];
	        y += current[7];
	        break;
	
	      case 'A':
	        drawArc(g, x + l, y + t, [
	          current[1],
	          current[2],
	          current[3],
	          current[4],
	          current[5],
	          current[6] + l,
	          current[7] + t
	        ]);
	        x = current[6];
	        y = current[7];
	        break;
	
	      case 'z':
	      case 'Z':
	        g.closePath();
	        break;
	    }
	    previous = current;
	  }
	};
	
	function drawArc(g, x, y, coords) {
	  var seg = arc.segments(
	    coords[5], // end x
	    coords[6], // end y
	    coords[0], // radius x
	    coords[1], // radius y
	    coords[3], // large flag
	    coords[4], // sweep flag
	    coords[2], // rotation
	    x, y
	  );
	  for (var i=0; i<seg.length; ++i) {
	    var bez = arc.bezier(seg[i]);
	    g.bezierCurveTo.apply(g, bez);
	  }
	}


/***/ },
/* 63 */
/***/ function(module, exports) {

	var segmentCache = {},
	    bezierCache = {},
	    join = [].join;
	
	// Copied from Inkscape svgtopdf, thanks!
	function segments(x, y, rx, ry, large, sweep, rotateX, ox, oy) {
	  var key = join.call(arguments);
	  if (segmentCache[key]) {
	    return segmentCache[key];
	  }
	
	  var th = rotateX * (Math.PI/180);
	  var sin_th = Math.sin(th);
	  var cos_th = Math.cos(th);
	  rx = Math.abs(rx);
	  ry = Math.abs(ry);
	  var px = cos_th * (ox - x) * 0.5 + sin_th * (oy - y) * 0.5;
	  var py = cos_th * (oy - y) * 0.5 - sin_th * (ox - x) * 0.5;
	  var pl = (px*px) / (rx*rx) + (py*py) / (ry*ry);
	  if (pl > 1) {
	    pl = Math.sqrt(pl);
	    rx *= pl;
	    ry *= pl;
	  }
	
	  var a00 = cos_th / rx;
	  var a01 = sin_th / rx;
	  var a10 = (-sin_th) / ry;
	  var a11 = (cos_th) / ry;
	  var x0 = a00 * ox + a01 * oy;
	  var y0 = a10 * ox + a11 * oy;
	  var x1 = a00 * x + a01 * y;
	  var y1 = a10 * x + a11 * y;
	
	  var d = (x1-x0) * (x1-x0) + (y1-y0) * (y1-y0);
	  var sfactor_sq = 1 / d - 0.25;
	  if (sfactor_sq < 0) sfactor_sq = 0;
	  var sfactor = Math.sqrt(sfactor_sq);
	  if (sweep == large) sfactor = -sfactor;
	  var xc = 0.5 * (x0 + x1) - sfactor * (y1-y0);
	  var yc = 0.5 * (y0 + y1) + sfactor * (x1-x0);
	
	  var th0 = Math.atan2(y0-yc, x0-xc);
	  var th1 = Math.atan2(y1-yc, x1-xc);
	
	  var th_arc = th1-th0;
	  if (th_arc < 0 && sweep === 1){
	    th_arc += 2 * Math.PI;
	  } else if (th_arc > 0 && sweep === 0) {
	    th_arc -= 2 * Math.PI;
	  }
	
	  var segs = Math.ceil(Math.abs(th_arc / (Math.PI * 0.5 + 0.001)));
	  var result = [];
	  for (var i=0; i<segs; ++i) {
	    var th2 = th0 + i * th_arc / segs;
	    var th3 = th0 + (i+1) * th_arc / segs;
	    result[i] = [xc, yc, th2, th3, rx, ry, sin_th, cos_th];
	  }
	
	  return (segmentCache[key] = result);
	}
	
	function bezier(params) {
	  var key = join.call(params);
	  if (bezierCache[key]) {
	    return bezierCache[key];
	  }
	  
	  var cx = params[0],
	      cy = params[1],
	      th0 = params[2],
	      th1 = params[3],
	      rx = params[4],
	      ry = params[5],
	      sin_th = params[6],
	      cos_th = params[7];
	
	  var a00 = cos_th * rx;
	  var a01 = -sin_th * ry;
	  var a10 = sin_th * rx;
	  var a11 = cos_th * ry;
	
	  var cos_th0 = Math.cos(th0);
	  var sin_th0 = Math.sin(th0);
	  var cos_th1 = Math.cos(th1);
	  var sin_th1 = Math.sin(th1);
	
	  var th_half = 0.5 * (th1 - th0);
	  var sin_th_h2 = Math.sin(th_half * 0.5);
	  var t = (8/3) * sin_th_h2 * sin_th_h2 / Math.sin(th_half);
	  var x1 = cx + cos_th0 - t * sin_th0;
	  var y1 = cy + sin_th0 + t * cos_th0;
	  var x3 = cx + cos_th1;
	  var y3 = cy + sin_th1;
	  var x2 = x3 + t * sin_th1;
	  var y2 = y3 - t * cos_th1;
	
	  return (bezierCache[key] = [
	    a00 * x1 + a01 * y1,  a10 * x1 + a11 * y1,
	    a00 * x2 + a01 * y2,  a10 * x2 + a11 * y2,
	    a00 * x3 + a01 * y3,  a10 * x3 + a11 * y3
	  ]);
	}
	
	module.exports = {
	  segments: segments,
	  bezier: bezier,
	  cache: {
	    segments: segmentCache,
	    bezier: bezierCache
	  }
	};


/***/ },
/* 64 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = {
	  'canvas': __webpack_require__(65),
	  'svg':    __webpack_require__(91)
	};


/***/ },
/* 65 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = {
	  Handler:  __webpack_require__(66),
	  Renderer: __webpack_require__(88)
	};

/***/ },
/* 66 */
/***/ function(module, exports, __webpack_require__) {

	var DOM = __webpack_require__(67),
	    Handler = __webpack_require__(68),
	    marks = __webpack_require__(69);
	
	function CanvasHandler() {
	  Handler.call(this);
	  this._down = null;
	  this._touch = null;
	  this._first = true;
	}
	
	var base = Handler.prototype;
	var prototype = (CanvasHandler.prototype = Object.create(base));
	prototype.constructor = CanvasHandler;
	
	prototype.initialize = function(el, pad, obj) {
	  // add event listeners
	  var canvas = this._canvas = DOM.find(el, 'canvas');
	  if (canvas) {
	    var that = this;
	    this.events.forEach(function(type) {
	      canvas.addEventListener(type, function(evt) {
	        if (prototype[type]) {
	          prototype[type].call(that, evt);
	        } else {
	          that.fire(type, evt);
	        }
	      });
	    });
	  }
	
	  return base.initialize.call(this, el, pad, obj);
	};
	
	prototype.canvas = function() {
	  return this._canvas;
	};
	
	// retrieve the current canvas context
	prototype.context = function() {
	  return this._canvas.getContext('2d');
	};
	
	// supported events
	prototype.events = [
	  'keydown',
	  'keypress',
	  'keyup',
	  'dragenter',
	  'dragleave',
	  'dragover',
	  'mousedown',
	  'mouseup',
	  'mousemove',
	  'mouseout',
	  'mouseover',
	  'click',
	  'dblclick',
	  'wheel',
	  'mousewheel',
	  'touchstart',
	  'touchmove',
	  'touchend'
	];
	
	// to keep firefox happy
	prototype.DOMMouseScroll = function(evt) {
	  this.fire('mousewheel', evt);
	};
	
	function move(moveEvent, overEvent, outEvent) {
	  return function(evt) {
	    var a = this._active,
	        p = this.pickEvent(evt);
	
	    if (p === a) {
	      // active item and picked item are the same
	      this.fire(moveEvent, evt); // fire move
	    } else {
	      // active item and picked item are different
	      this.fire(outEvent, evt);  // fire out for prior active item
	      this._active = p;            // set new active item
	      this.fire(overEvent, evt); // fire over for new active item
	      this.fire(moveEvent, evt); // fire move for new active item
	    }
	  };
	}
	
	function inactive(type) {
	  return function(evt) {
	    this.fire(type, evt);
	    this._active = null;
	  };
	}
	
	prototype.mousemove = move('mousemove', 'mouseover', 'mouseout');
	prototype.dragover  = move('dragover', 'dragenter', 'dragleave');
	
	prototype.mouseout  = inactive('mouseout');
	prototype.dragleave = inactive('dragleave');
	
	prototype.mousedown = function(evt) {
	  this._down = this._active;
	  this.fire('mousedown', evt);
	};
	
	prototype.click = function(evt) {
	  if (this._down === this._active) {
	    this.fire('click', evt);
	    this._down = null;
	  }
	};
	
	prototype.touchstart = function(evt) {
	  this._touch = this.pickEvent(evt.changedTouches[0]);
	
	  if (this._first) {
	    this._active = this._touch;
	    this._first = false;
	  }
	
	  this.fire('touchstart', evt, true);
	};
	
	prototype.touchmove = function(evt) {
	  this.fire('touchmove', evt, true);
	};
	
	prototype.touchend = function(evt) {
	  this.fire('touchend', evt, true);
	  this._touch = null;
	};
	
	// fire an event
	prototype.fire = function(type, evt, touch) {
	  var a = touch ? this._touch : this._active,
	      h = this._handlers[type], i, len;
	  if (h) {
	    evt.vegaType = type;
	    for (i=0, len=h.length; i<len; ++i) {
	      h[i].handler.call(this._obj, evt, a);
	    }
	  }
	};
	
	// add an event handler
	prototype.on = function(type, handler) {
	  var name = this.eventName(type),
	      h = this._handlers;
	  (h[name] || (h[name] = [])).push({
	    type: type,
	    handler: handler
	  });
	  return this;
	};
	
	// remove an event handler
	prototype.off = function(type, handler) {
	  var name = this.eventName(type),
	      h = this._handlers[name], i;
	  if (!h) return;
	  for (i=h.length; --i>=0;) {
	    if (h[i].type !== type) continue;
	    if (!handler || h[i].handler === handler) h.splice(i, 1);
	  }
	  return this;
	};
	
	prototype.pickEvent = function(evt) {
	  var rect = this._canvas.getBoundingClientRect(),
	      pad = this._padding, x, y;
	  return this.pick(this._scene,
	    x = (evt.clientX - rect.left),
	    y = (evt.clientY - rect.top),
	    x - pad.left, y - pad.top);
	};
	
	// find the scenegraph item at the current mouse position
	// x, y -- the absolute x, y mouse coordinates on the canvas element
	// gx, gy -- the relative coordinates within the current group
	prototype.pick = function(scene, x, y, gx, gy) {
	  var g = this.context(),
	      mark = marks[scene.marktype];
	  return mark.pick.call(this, g, scene, x, y, gx, gy);
	};
	
	module.exports = CanvasHandler;


/***/ },
/* 67 */
/***/ function(module, exports) {

	// create a new DOM element
	function create(doc, tag, ns) {
	  return ns ? doc.createElementNS(ns, tag) : doc.createElement(tag);
	}
	
	// remove element from DOM
	// recursively remove parent elements if empty
	function remove(el) {
	  if (!el) return;
	  var p = el.parentNode;
	  if (p) {
	    p.removeChild(el);
	    if (!p.childNodes || !p.childNodes.length) remove(p);
	  }
	}
	
	module.exports = {
	  // find first child element with matching tag
	  find: function(el, tag) {
	    tag = tag.toLowerCase();
	    for (var i=0, n=el.childNodes.length; i<n; ++i) {
	      if (el.childNodes[i].tagName.toLowerCase() === tag) {
	        return el.childNodes[i];
	      }
	    }
	  },
	  // retrieve child element at given index
	  // create & insert if doesn't exist or if tag/className do not match
	  child: function(el, index, tag, ns, className, insert) {
	    var a, b;
	    a = b = el.childNodes[index];
	    if (!a || insert ||
	        a.tagName.toLowerCase() !== tag.toLowerCase() ||
	        className && a.getAttribute('class') != className) {
	      a = create(el.ownerDocument, tag, ns);
	      el.insertBefore(a, b || null);
	      if (className) a.setAttribute('class', className);
	    }
	    return a;
	  },
	  // remove all child elements at or above the given index
	  clear: function(el, index) {
	    var curr = el.childNodes.length;
	    while (curr > index) {
	      el.removeChild(el.childNodes[--curr]);
	    }
	    return el;
	  },
	  remove: remove,
	  // generate css class name for mark
	  cssClass: function(mark) {
	    return 'mark-' + mark.marktype + (mark.name ? ' '+mark.name : '');
	  },
	  // generate string for an opening xml tag
	  // tag: the name of the xml tag
	  // attr: hash of attribute name-value pairs to include
	  // raw: additional raw string to include in tag markup
	  openTag: function(tag, attr, raw) {
	    var s = '<' + tag, key, val;
	    if (attr) {
	      for (key in attr) {
	        val = attr[key];
	        if (val != null) {
	          s += ' ' + key + '="' + val + '"';
	        }
	      }
	    }
	    if (raw) s += ' ' + raw;
	    return s + '>';
	  },
	  // generate string for closing xml tag
	  // tag: the name of the xml tag
	  closeTag: function(tag) {
	    return '</' + tag + '>';
	  }
	};


/***/ },
/* 68 */
/***/ function(module, exports) {

	function Handler() {
	  this._active = null;
	  this._handlers = {};
	}
	
	var prototype = Handler.prototype;
	
	prototype.initialize = function(el, pad, obj) {
	  this._el = el;
	  this._obj = obj || null;
	  return this.padding(pad);
	};
	
	prototype.element = function() {
	  return this._el;
	};
	
	prototype.padding = function(pad) {
	  this._padding = pad || {top:0, left:0, bottom:0, right:0};
	  return this;
	};
	
	prototype.scene = function(scene) {
	  if (!arguments.length) return this._scene;
	  this._scene = scene;
	  return this;
	};
	
	// add an event handler
	// subclasses should override
	prototype.on = function(/*type, handler*/) {};
	
	// remove an event handler
	// subclasses should override
	prototype.off = function(/*type, handler*/) {};
	
	// return an array with all registered event handlers
	prototype.handlers = function() {
	  var h = this._handlers, a = [], k;
	  for (k in h) { a.push.apply(a, h[k]); }
	  return a;
	};
	
	prototype.eventName = function(name) {
	  var i = name.indexOf('.');
	  return i < 0 ? name : name.slice(0,i);
	};
	
	module.exports = Handler;

/***/ },
/* 69 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = {
	  arc:    __webpack_require__(70),
	  area:   __webpack_require__(72),
	  group:  __webpack_require__(74),
	  image:  __webpack_require__(75),
	  line:   __webpack_require__(76),
	  path:   __webpack_require__(77),
	  rect:   __webpack_require__(78),
	  rule:   __webpack_require__(79),
	  symbol: __webpack_require__(80),
	  text:   __webpack_require__(81)
	};


/***/ },
/* 70 */
/***/ function(module, exports, __webpack_require__) {

	var util = __webpack_require__(71);
	var halfpi = Math.PI / 2;
	
	function path(g, o) {
	  var x = o.x || 0,
	      y = o.y || 0,
	      ir = o.innerRadius || 0,
	      or = o.outerRadius || 0,
	      sa = (o.startAngle || 0) - halfpi,
	      ea = (o.endAngle || 0) - halfpi;
	  g.beginPath();
	  if (ir === 0) g.moveTo(x, y);
	  else g.arc(x, y, ir, sa, ea, 0);
	  g.arc(x, y, or, ea, sa, 1);
	  g.closePath();
	}
	
	module.exports = {
	  draw: util.drawAll(path),
	  pick: util.pickPath(path)
	};

/***/ },
/* 71 */
/***/ function(module, exports) {

	function drawPathOne(path, g, o, items) {
	  if (path(g, items)) return;
	
	  var opac = o.opacity == null ? 1 : o.opacity;
	  if (opac===0) return;
	
	  if (o.fill && fill(g, o, opac)) { g.fill(); }
	  if (o.stroke && stroke(g, o, opac)) { g.stroke(); }
	}
	
	function drawPathAll(path, g, scene, bounds) {
	  var i, len, item;
	  for (i=0, len=scene.items.length; i<len; ++i) {
	    item = scene.items[i];
	    if (!bounds || bounds.intersects(item.bounds)) {
	      drawPathOne(path, g, item, item);
	    }
	  }
	}
	
	function drawAll(pathFunc) {
	  return function(g, scene, bounds) {
	    drawPathAll(pathFunc, g, scene, bounds);
	  };
	}
	
	function drawOne(pathFunc) {
	  return function(g, scene, bounds) {
	    if (!scene.items.length) return;
	    if (!bounds || bounds.intersects(scene.bounds)) {
	      drawPathOne(pathFunc, g, scene.items[0], scene.items);
	    }
	  };
	}
	
	var trueFunc = function() { return true; };
	
	function pick(test) {
	  if (!test) test = trueFunc;
	
	  return function(g, scene, x, y, gx, gy) {
	    if (!scene.items.length) return null;
	
	    var o, b, i;
	
	    if (g.pixelratio != null && g.pixelratio !== 1) {
	      x *= g.pixelratio;
	      y *= g.pixelratio;
	    }
	
	    for (i=scene.items.length; --i >= 0;) {
	      o = scene.items[i]; b = o.bounds;
	      // first hit test against bounding box
	      if ((b && !b.contains(gx, gy)) || !b) continue;
	      // if in bounding box, perform more careful test
	      if (test(g, o, x, y, gx, gy)) return o;
	    }
	    return null;
	  };
	}
	
	function testPath(path, filled) {
	  return function(g, o, x, y) {
	    var item = Array.isArray(o) ? o[0] : o,
	        fill = (filled == null) ? item.fill : filled,
	        stroke = item.stroke && g.isPointInStroke, lw, lc;
	
	    if (stroke) {
	      lw = item.strokeWidth;
	      lc = item.strokeCap;
	      g.lineWidth = lw != null ? lw : 1;
	      g.lineCap   = lc != null ? lc : 'butt';
	    }
	
	    return path(g, o) ? false :
	      (fill && g.isPointInPath(x, y)) ||
	      (stroke && g.isPointInStroke(x, y));
	  };
	}
	
	function pickPath(path) {
	  return pick(testPath(path));
	}
	
	function fill(g, o, opacity) {
	  opacity *= (o.fillOpacity==null ? 1 : o.fillOpacity);
	  if (opacity > 0) {
	    g.globalAlpha = opacity;
	    g.fillStyle = color(g, o, o.fill);
	    return true;
	  } else {
	    return false;
	  }
	}
	
	function stroke(g, o, opacity) {
	  var lw = (lw = o.strokeWidth) != null ? lw : 1, lc;
	  if (lw <= 0) return false;
	
	  opacity *= (o.strokeOpacity==null ? 1 : o.strokeOpacity);
	  if (opacity > 0) {
	    g.globalAlpha = opacity;
	    g.strokeStyle = color(g, o, o.stroke);
	    g.lineWidth = lw;
	    g.lineCap = (lc = o.strokeCap) != null ? lc : 'butt';
	    g.vgLineDash(o.strokeDash || null);
	    g.vgLineDashOffset(o.strokeDashOffset || 0);
	    return true;
	  } else {
	    return false;
	  }
	}
	
	function color(g, o, value) {
	  return (value.id) ?
	    gradient(g, value, o.bounds) :
	    value;
	}
	
	function gradient(g, p, b) {
	  var w = b.width(),
	      h = b.height(),
	      x1 = b.x1 + p.x1 * w,
	      y1 = b.y1 + p.y1 * h,
	      x2 = b.x1 + p.x2 * w,
	      y2 = b.y1 + p.y2 * h,
	      grad = g.createLinearGradient(x1, y1, x2, y2),
	      stop = p.stops,
	      i, n;
	
	  for (i=0, n=stop.length; i<n; ++i) {
	    grad.addColorStop(stop[i].offset, stop[i].color);
	  }
	  return grad;
	}
	
	module.exports = {
	  drawOne:  drawOne,
	  drawAll:  drawAll,
	  pick:     pick,
	  pickPath: pickPath,
	  testPath: testPath,
	  stroke:   stroke,
	  fill:     fill,
	  color:    color,
	  gradient: gradient
	};


/***/ },
/* 72 */
/***/ function(module, exports, __webpack_require__) {

	var util = __webpack_require__(71),
	    parse = __webpack_require__(61),
	    render = __webpack_require__(62),
	    areaPath = __webpack_require__(73).path.area;
	
	function path(g, items) {
	  var o = items[0],
	      p = o.pathCache || (o.pathCache = parse(areaPath(items)));
	  render(g, p);
	}
	
	function pick(g, scene, x, y, gx, gy) {
	  var items = scene.items,
	      b = scene.bounds;
	
	  if (!items || !items.length || b && !b.contains(gx, gy)) {
	    return null;
	  }
	
	  if (g.pixelratio != null && g.pixelratio !== 1) {
	    x *= g.pixelratio;
	    y *= g.pixelratio;
	  }
	  return hit(g, items, x, y) ? items[0] : null;
	}
	
	var hit = util.testPath(path);
	
	module.exports = {
	  draw: util.drawOne(path),
	  pick: pick,
	  nested: true
	};


/***/ },
/* 73 */
/***/ function(module, exports, __webpack_require__) {

	var d3_svg = __webpack_require__(2).svg;
	
	function x(o)     { return o.x || 0; }
	function y(o)     { return o.y || 0; }
	function xw(o)    { return (o.x || 0) + (o.width || 0); }
	function yh(o)    { return (o.y || 0) + (o.height || 0); }
	function size(o)  { return o.size == null ? 100 : o.size; }
	function shape(o) { return o.shape || 'circle'; }
	
	var areav = d3_svg.area().x(x).y1(y).y0(yh),
	    areah = d3_svg.area().y(y).x1(x).x0(xw),
	    line  = d3_svg.line().x(x).y(y);
	
	module.exports = {
	  metadata: {
	    'version': '1.1',
	    'xmlns': 'http://www.w3.org/2000/svg',
	    'xmlns:xlink': 'http://www.w3.org/1999/xlink'
	  },
	  path: {
	    arc: d3_svg.arc(),
	    symbol: d3_svg.symbol().type(shape).size(size),
	    area: function(items) {
	      var o = items[0];
	      return (o.orient === 'horizontal' ? areah : areav)
	        .interpolate(o.interpolate || 'linear')
	        .tension(o.tension || 0.7)
	        (items);
	    },
	    line: function(items) {
	      var o = items[0];
	      return line
	        .interpolate(o.interpolate || 'linear')
	        .tension(o.tension || 0.7)
	        (items);
	    }
	  },
	  textAlign: {
	    'left':   'start',
	    'center': 'middle',
	    'right':  'end'
	  },
	  textBaseline: {
	    'top':    'before-edge',
	    'bottom': 'after-edge',
	    'middle': 'central'
	  },
	  styles: {
	    'fill':             'fill',
	    'fillOpacity':      'fill-opacity',
	    'stroke':           'stroke',
	    'strokeWidth':      'stroke-width',
	    'strokeOpacity':    'stroke-opacity',
	    'strokeCap':        'stroke-linecap',
	    'strokeDash':       'stroke-dasharray',
	    'strokeDashOffset': 'stroke-dashoffset',
	    'opacity':          'opacity'
	  },
	  styleProperties: [
	    'fill',
	    'fillOpacity',
	    'stroke',
	    'strokeWidth',
	    'strokeOpacity',
	    'strokeCap',
	    'strokeDash',
	    'strokeDashOffset',
	    'opacity'
	  ]
	};


/***/ },
/* 74 */
/***/ function(module, exports, __webpack_require__) {

	var util = __webpack_require__(71),
	    EMPTY = [];
	
	function draw(g, scene, bounds) {
	  if (!scene.items || !scene.items.length) return;
	
	  var groups = scene.items,
	      renderer = this,
	      group, items, axes, legends, gx, gy, w, h, opac, i, n, j, m;
	
	  for (i=0, n=groups.length; i<n; ++i) {
	    group = groups[i];
	    axes = group.axisItems || EMPTY;
	    items = group.items || EMPTY;
	    legends = group.legendItems || EMPTY;
	    gx = group.x || 0;
	    gy = group.y || 0;
	    w = group.width || 0;
	    h = group.height || 0;
	
	    // draw group background
	    if (group.stroke || group.fill) {
	      opac = group.opacity == null ? 1 : group.opacity;
	      if (opac > 0) {
	        if (group.fill && util.fill(g, group, opac)) {
	          g.fillRect(gx, gy, w, h);
	        }
	        if (group.stroke && util.stroke(g, group, opac)) {
	          g.strokeRect(gx, gy, w, h);
	        }
	      }
	    }
	
	    // setup graphics context
	    g.save();
	    g.translate(gx, gy);
	    if (group.clip) {
	      g.beginPath();
	      g.rect(0, 0, w, h);
	      g.clip();
	    }
	    if (bounds) bounds.translate(-gx, -gy);
	
	    // draw group contents
	    for (j=0, m=axes.length; j<m; ++j) {
	      if (axes[j].layer === 'back') {
	        renderer.draw(g, axes[j], bounds);
	      }
	    }
	    for (j=0, m=items.length; j<m; ++j) {
	      renderer.draw(g, items[j], bounds);
	    }
	    for (j=0, m=axes.length; j<m; ++j) {
	      if (axes[j].layer !== 'back') {
	        renderer.draw(g, axes[j], bounds);
	      }
	    }
	    for (j=0, m=legends.length; j<m; ++j) {
	      renderer.draw(g, legends[j], bounds);
	    }
	
	    // restore graphics context
	    if (bounds) bounds.translate(gx, gy);
	    g.restore();
	  }    
	}
	
	function pick(g, scene, x, y, gx, gy) {
	  if (scene.bounds && !scene.bounds.contains(gx, gy)) {
	    return null;
	  }
	
	  var groups = scene.items || EMPTY, subscene,
	      group, axes, items, legends, hits, dx, dy, i, j, b;
	
	  for (i=groups.length; --i>=0;) {
	    group = groups[i];
	
	    // first hit test against bounding box
	    // if a group is clipped, that should be handled by the bounds check.
	    b = group.bounds;
	    if (b && !b.contains(gx, gy)) continue;
	
	    // passed bounds check, so test sub-groups
	    axes = group.axisItems || EMPTY;
	    items = group.items || EMPTY;
	    legends = group.legendItems || EMPTY;
	    dx = (group.x || 0);
	    dy = (group.y || 0);
	
	    g.save();
	    g.translate(dx, dy);
	    dx = gx - dx;
	    dy = gy - dy;
	    for (j=legends.length; --j>=0;) {
	      subscene = legends[j];
	      if (subscene.interactive !== false) {
	        hits = this.pick(subscene, x, y, dx, dy);
	        if (hits) { g.restore(); return hits; }
	      }
	    }
	    for (j=axes.length; --j>=0;) {
	      subscene = axes[j];
	      if (subscene.interactive !== false && subscene.layer !== 'back') {
	        hits = this.pick(subscene, x, y, dx, dy);
	        if (hits) { g.restore(); return hits; }
	      }
	    }
	    for (j=items.length; --j>=0;) {
	      subscene = items[j];
	      if (subscene.interactive !== false) {
	        hits = this.pick(subscene, x, y, dx, dy);
	        if (hits) { g.restore(); return hits; }
	      }
	    }
	    for (j=axes.length; --j>=0;) {
	      subscene = axes[j];
	      if (subscene.interative !== false && subscene.layer === 'back') {
	        hits = this.pick(subscene, x, y, dx, dy);
	        if (hits) { g.restore(); return hits; }
	      }
	    }
	    g.restore();
	
	    if (scene.interactive !== false && (group.fill || group.stroke) &&
	        dx >= 0 && dx <= group.width && dy >= 0 && dy <= group.height) {
	      return group;
	    }
	  }
	
	  return null;
	}
	
	module.exports = {
	  draw: draw,
	  pick: pick
	};


/***/ },
/* 75 */
/***/ function(module, exports, __webpack_require__) {

	var util = __webpack_require__(71);
	
	function draw(g, scene, bounds) {
	  if (!scene.items || !scene.items.length) return;
	
	  var renderer = this,
	      items = scene.items, o;
	
	  for (var i=0, len=items.length; i<len; ++i) {
	    o = items[i];
	    if (bounds && !bounds.intersects(o.bounds))
	      continue; // bounds check
	
	    if (!(o.image && o.image.url === o.url)) {
	      o.image = renderer.loadImage(o.url);
	      o.image.url = o.url;
	    }
	
	    var x = o.x || 0,
	        y = o.y || 0,
	        w = o.width || (o.image && o.image.width) || 0,
	        h = o.height || (o.image && o.image.height) || 0,
	        opac;
	    x = x - (o.align==='center' ? w/2 : o.align==='right' ? w : 0);
	    y = y - (o.baseline==='middle' ? h/2 : o.baseline==='bottom' ? h : 0);
	
	    if (o.image.loaded) {
	      g.globalAlpha = (opac = o.opacity) != null ? opac : 1;
	      g.drawImage(o.image, x, y, w, h);
	    }
	  }
	}
	
	module.exports = {
	  draw: draw,
	  pick: util.pick()
	};

/***/ },
/* 76 */
/***/ function(module, exports, __webpack_require__) {

	var util = __webpack_require__(71),
	    parse = __webpack_require__(61),
	    render = __webpack_require__(62),
	    linePath = __webpack_require__(73).path.line;
	    
	function path(g, items) {
	  var o = items[0],
	      p = o.pathCache || (o.pathCache = parse(linePath(items)));
	  render(g, p);
	}
	
	function pick(g, scene, x, y, gx, gy) {
	  var items = scene.items,
	      b = scene.bounds;
	
	  if (!items || !items.length || b && !b.contains(gx, gy)) {
	    return null;
	  }
	
	  if (g.pixelratio != null && g.pixelratio !== 1) {
	    x *= g.pixelratio;
	    y *= g.pixelratio;
	  }
	  return hit(g, items, x, y) ? items[0] : null;
	}
	
	var hit = util.testPath(path, false);
	
	module.exports = {
	  draw: util.drawOne(path),
	  pick: pick,
	  nested: true
	};


/***/ },
/* 77 */
/***/ function(module, exports, __webpack_require__) {

	var util = __webpack_require__(71),
	    parse = __webpack_require__(61),
	    render = __webpack_require__(62);
	
	function path(g, o) {
	  if (o.path == null) return true;
	  var p = o.pathCache || (o.pathCache = parse(o.path));
	  render(g, p, o.x, o.y);
	}
	
	module.exports = {
	  draw: util.drawAll(path),
	  pick: util.pickPath(path)
	};


/***/ },
/* 78 */
/***/ function(module, exports, __webpack_require__) {

	var util = __webpack_require__(71);
	
	function draw(g, scene, bounds) {
	  if (!scene.items || !scene.items.length) return;
	
	  var items = scene.items,
	      o, opac, x, y, w, h;
	
	  for (var i=0, len=items.length; i<len; ++i) {
	    o = items[i];
	    if (bounds && !bounds.intersects(o.bounds))
	      continue; // bounds check
	
	    opac = o.opacity == null ? 1 : o.opacity;
	    if (opac === 0) continue;
	
	    x = o.x || 0;
	    y = o.y || 0;
	    w = o.width || 0;
	    h = o.height || 0;
	
	    if (o.fill && util.fill(g, o, opac)) {
	      g.fillRect(x, y, w, h);
	    }
	    if (o.stroke && util.stroke(g, o, opac)) {
	      g.strokeRect(x, y, w, h);
	    }
	  }
	}
	
	module.exports = {
	  draw: draw,
	  pick: util.pick()
	};

/***/ },
/* 79 */
/***/ function(module, exports, __webpack_require__) {

	var util = __webpack_require__(71);
	
	function draw(g, scene, bounds) {
	  if (!scene.items || !scene.items.length) return;
	
	  var items = scene.items,
	      o, opac, x1, y1, x2, y2;
	
	  for (var i=0, len=items.length; i<len; ++i) {
	    o = items[i];
	    if (bounds && !bounds.intersects(o.bounds))
	      continue; // bounds check
	
	    opac = o.opacity == null ? 1 : o.opacity;
	    if (opac === 0) continue;
	      
	    x1 = o.x || 0;
	    y1 = o.y || 0;
	    x2 = o.x2 != null ? o.x2 : x1;
	    y2 = o.y2 != null ? o.y2 : y1;
	
	    if (o.stroke && util.stroke(g, o, opac)) {
	      g.beginPath();
	      g.moveTo(x1, y1);
	      g.lineTo(x2, y2);
	      g.stroke();
	    }
	  }
	}
	
	function stroke(g, o) {
	  var x1 = o.x || 0,
	      y1 = o.y || 0,
	      x2 = o.x2 != null ? o.x2 : x1,
	      y2 = o.y2 != null ? o.y2 : y1,
	      lw = o.strokeWidth,
	      lc = o.strokeCap;
	
	  g.lineWidth = lw != null ? lw : 1;
	  g.lineCap   = lc != null ? lc : 'butt';
	  g.beginPath();
	  g.moveTo(x1, y1);
	  g.lineTo(x2, y2);
	}
	
	function hit(g, o, x, y) {
	  if (!g.isPointInStroke) return false;
	  stroke(g, o);
	  return g.isPointInStroke(x, y);
	}
	
	module.exports = {
	  draw: draw,
	  pick: util.pick(hit)
	};


/***/ },
/* 80 */
/***/ function(module, exports, __webpack_require__) {

	var util = __webpack_require__(71);
	
	var sqrt3 = Math.sqrt(3),
	    tan30 = Math.tan(30 * Math.PI / 180);
	
	function path(g, o) {
	  var size = o.size != null ? o.size : 100,
	      x = o.x, y = o.y, r, t, rx, ry;
	
	  g.beginPath();
	
	  if (o.shape == null || o.shape === 'circle') {
	    r = Math.sqrt(size / Math.PI);
	    g.arc(x, y, r, 0, 2*Math.PI, 0);
	    g.closePath();
	    return;
	  }
	
	  switch (o.shape) {
	    case 'cross':
	      r = Math.sqrt(size / 5) / 2;
	      t = 3*r;
	      g.moveTo(x-t, y-r);
	      g.lineTo(x-r, y-r);
	      g.lineTo(x-r, y-t);
	      g.lineTo(x+r, y-t);
	      g.lineTo(x+r, y-r);
	      g.lineTo(x+t, y-r);
	      g.lineTo(x+t, y+r);
	      g.lineTo(x+r, y+r);
	      g.lineTo(x+r, y+t);
	      g.lineTo(x-r, y+t);
	      g.lineTo(x-r, y+r);
	      g.lineTo(x-t, y+r);
	      break;
	
	    case 'diamond':
	      ry = Math.sqrt(size / (2 * tan30));
	      rx = ry * tan30;
	      g.moveTo(x, y-ry);
	      g.lineTo(x+rx, y);
	      g.lineTo(x, y+ry);
	      g.lineTo(x-rx, y);
	      break;
	
	    case 'square':
	      t = Math.sqrt(size);
	      r = t / 2;
	      g.rect(x-r, y-r, t, t);
	      break;
	
	    case 'triangle-down':
	      rx = Math.sqrt(size / sqrt3);
	      ry = rx * sqrt3 / 2;
	      g.moveTo(x, y+ry);
	      g.lineTo(x+rx, y-ry);
	      g.lineTo(x-rx, y-ry);
	      break;
	
	    case 'triangle-up':
	      rx = Math.sqrt(size / sqrt3);
	      ry = rx * sqrt3 / 2;
	      g.moveTo(x, y-ry);
	      g.lineTo(x+rx, y+ry);
	      g.lineTo(x-rx, y+ry);
	  }
	  g.closePath();
	}
	
	module.exports = {
	  draw: util.drawAll(path),
	  pick: util.pickPath(path)
	};

/***/ },
/* 81 */
/***/ function(module, exports, __webpack_require__) {

	var Bounds = __webpack_require__(82),
	    textBounds = __webpack_require__(83).text,
	    text = __webpack_require__(87),
	    util = __webpack_require__(71),
	    tempBounds = new Bounds();
	
	function draw(g, scene, bounds) {
	  if (!scene.items || !scene.items.length) return;
	
	  var items = scene.items,
	      o, opac, x, y, r, t, str;
	
	  for (var i=0, len=items.length; i<len; ++i) {
	    o = items[i];
	    if (bounds && !bounds.intersects(o.bounds))
	      continue; // bounds check
	
	    str = text.value(o.text);
	    if (!str) continue;
	    opac = o.opacity == null ? 1 : o.opacity;
	    if (opac === 0) continue;
	
	    g.font = text.font(o);
	    g.textAlign = o.align || 'left';
	
	    x = (o.x || 0);
	    y = (o.y || 0);
	    if ((r = o.radius)) {
	      t = (o.theta || 0) - Math.PI/2;
	      x += r * Math.cos(t);
	      y += r * Math.sin(t);
	    }
	
	    if (o.angle) {
	      g.save();
	      g.translate(x, y);
	      g.rotate(o.angle * Math.PI/180);
	      x = y = 0; // reset x, y
	    }
	    x += (o.dx || 0);
	    y += (o.dy || 0) + text.offset(o);
	
	    if (o.fill && util.fill(g, o, opac)) {
	      g.fillText(str, x, y);
	    }
	    if (o.stroke && util.stroke(g, o, opac)) {
	      g.strokeText(str, x, y);
	    }
	    if (o.angle) g.restore();
	  }
	}
	
	function hit(g, o, x, y, gx, gy) {
	  if (o.fontSize <= 0) return false;
	  if (!o.angle) return true; // bounds sufficient if no rotation
	
	  // project point into space of unrotated bounds
	  var b = textBounds(o, tempBounds, true),
	      a = -o.angle * Math.PI / 180,
	      cos = Math.cos(a),
	      sin = Math.sin(a),
	      ox = o.x,
	      oy = o.y,
	      px = cos*gx - sin*gy + (ox - ox*cos + oy*sin),
	      py = sin*gx + cos*gy + (oy - ox*sin - oy*cos);
	
	  return b.contains(px, py);
	}
	
	module.exports = {
	  draw: draw,
	  pick: util.pick(hit)
	};


/***/ },
/* 82 */
/***/ function(module, exports) {

	function Bounds(b) {
	  this.clear();
	  if (b) this.union(b);
	}
	
	var prototype = Bounds.prototype;
	
	prototype.clone = function() {
	  return new Bounds(this);
	};
	
	prototype.clear = function() {
	  this.x1 = +Number.MAX_VALUE;
	  this.y1 = +Number.MAX_VALUE;
	  this.x2 = -Number.MAX_VALUE;
	  this.y2 = -Number.MAX_VALUE;
	  return this;
	};
	
	prototype.set = function(x1, y1, x2, y2) {
	  this.x1 = x1;
	  this.y1 = y1;
	  this.x2 = x2;
	  this.y2 = y2;
	  return this;
	};
	
	prototype.add = function(x, y) {
	  if (x < this.x1) this.x1 = x;
	  if (y < this.y1) this.y1 = y;
	  if (x > this.x2) this.x2 = x;
	  if (y > this.y2) this.y2 = y;
	  return this;
	};
	
	prototype.expand = function(d) {
	  this.x1 -= d;
	  this.y1 -= d;
	  this.x2 += d;
	  this.y2 += d;
	  return this;
	};
	
	prototype.round = function() {
	  this.x1 = Math.floor(this.x1);
	  this.y1 = Math.floor(this.y1);
	  this.x2 = Math.ceil(this.x2);
	  this.y2 = Math.ceil(this.y2);
	  return this;
	};
	
	prototype.translate = function(dx, dy) {
	  this.x1 += dx;
	  this.x2 += dx;
	  this.y1 += dy;
	  this.y2 += dy;
	  return this;
	};
	
	prototype.rotate = function(angle, x, y) {
	  var cos = Math.cos(angle),
	      sin = Math.sin(angle),
	      cx = x - x*cos + y*sin,
	      cy = y - x*sin - y*cos,
	      x1 = this.x1, x2 = this.x2,
	      y1 = this.y1, y2 = this.y2;
	
	  return this.clear()
	    .add(cos*x1 - sin*y1 + cx,  sin*x1 + cos*y1 + cy)
	    .add(cos*x1 - sin*y2 + cx,  sin*x1 + cos*y2 + cy)
	    .add(cos*x2 - sin*y1 + cx,  sin*x2 + cos*y1 + cy)
	    .add(cos*x2 - sin*y2 + cx,  sin*x2 + cos*y2 + cy);
	};
	
	prototype.union = function(b) {
	  if (b.x1 < this.x1) this.x1 = b.x1;
	  if (b.y1 < this.y1) this.y1 = b.y1;
	  if (b.x2 > this.x2) this.x2 = b.x2;
	  if (b.y2 > this.y2) this.y2 = b.y2;
	  return this;
	};
	
	prototype.encloses = function(b) {
	  return b && (
	    this.x1 <= b.x1 &&
	    this.x2 >= b.x2 &&
	    this.y1 <= b.y1 &&
	    this.y2 >= b.y2
	  );
	};
	
	prototype.alignsWith = function(b) {
	  return b && (
	    this.x1 == b.x1 ||
	    this.x2 == b.x2 ||
	    this.y1 == b.y1 ||
	    this.y2 == b.y2
	  );
	};
	
	prototype.intersects = function(b) {
	  return b && !(
	    this.x2 < b.x1 ||
	    this.x1 > b.x2 ||
	    this.y2 < b.y1 ||
	    this.y1 > b.y2
	  );
	};
	
	prototype.contains = function(x, y) {
	  return !(
	    x < this.x1 ||
	    x > this.x2 ||
	    y < this.y1 ||
	    y > this.y2
	  );
	};
	
	prototype.width = function() {
	  return this.x2 - this.x1;
	};
	
	prototype.height = function() {
	  return this.y2 - this.y1;
	};
	
	module.exports = Bounds;


/***/ },
/* 83 */
/***/ function(module, exports, __webpack_require__) {

	var BoundsContext = __webpack_require__(84),
	    Bounds = __webpack_require__(82),
	    canvas = __webpack_require__(85),
	    svg = __webpack_require__(73),
	    text = __webpack_require__(87),
	    paths = __webpack_require__(60),
	    parse = paths.parse,
	    drawPath = paths.render,
	    areaPath = svg.path.area,
	    linePath = svg.path.line,
	    halfpi = Math.PI / 2,
	    sqrt3 = Math.sqrt(3),
	    tan30 = Math.tan(30 * Math.PI / 180),
	    g2D = null,
	    bc = BoundsContext();
	
	function context() {
	  return g2D || (g2D = canvas.instance(1,1).getContext('2d'));
	}
	
	function strokeBounds(o, bounds) {
	  if (o.stroke && o.opacity !== 0 && o.stokeOpacity !== 0) {
	    bounds.expand(o.strokeWidth != null ? o.strokeWidth : 1);
	  }
	  return bounds;
	}
	
	function pathBounds(o, path, bounds, x, y) {
	  if (path == null) {
	    bounds.set(0, 0, 0, 0);
	  } else {
	    drawPath(bc.bounds(bounds), path, x, y);
	    strokeBounds(o, bounds);
	  }
	  return bounds;
	}
	
	function path(o, bounds) {
	  var p = o.path ? o.pathCache || (o.pathCache = parse(o.path)) : null;
	  return pathBounds(o, p, bounds, o.x, o.y);
	}
	
	function area(mark, bounds) {
	  if (mark.items.length === 0) return bounds;
	  var items = mark.items,
	      item = items[0],
	      p = item.pathCache || (item.pathCache = parse(areaPath(items)));
	  return pathBounds(item, p, bounds);
	}
	
	function line(mark, bounds) {
	  if (mark.items.length === 0) return bounds;
	  var items = mark.items,
	      item = items[0],
	      p = item.pathCache || (item.pathCache = parse(linePath(items)));
	  return pathBounds(item, p, bounds);
	}
	
	function rect(o, bounds) {
	  var x, y;
	  return strokeBounds(o, bounds.set(
	    x = o.x || 0,
	    y = o.y || 0,
	    (x + o.width) || 0,
	    (y + o.height) || 0
	  ));
	}
	
	function image(o, bounds) {
	  var x = o.x || 0,
	      y = o.y || 0,
	      w = o.width || 0,
	      h = o.height || 0;
	  x = x - (o.align === 'center' ? w/2 : (o.align === 'right' ? w : 0));
	  y = y - (o.baseline === 'middle' ? h/2 : (o.baseline === 'bottom' ? h : 0));
	  return bounds.set(x, y, x+w, y+h);
	}
	
	function rule(o, bounds) {
	  var x1, y1;
	  return strokeBounds(o, bounds.set(
	    x1 = o.x || 0,
	    y1 = o.y || 0,
	    o.x2 != null ? o.x2 : x1,
	    o.y2 != null ? o.y2 : y1
	  ));
	}
	
	function arc(o, bounds) {
	  var cx = o.x || 0,
	      cy = o.y || 0,
	      ir = o.innerRadius || 0,
	      or = o.outerRadius || 0,
	      sa = (o.startAngle || 0) - halfpi,
	      ea = (o.endAngle || 0) - halfpi,
	      xmin = Infinity, xmax = -Infinity,
	      ymin = Infinity, ymax = -Infinity,
	      a, i, n, x, y, ix, iy, ox, oy;
	
	  var angles = [sa, ea],
	      s = sa - (sa % halfpi);
	  for (i=0; i<4 && s<ea; ++i, s+=halfpi) {
	    angles.push(s);
	  }
	
	  for (i=0, n=angles.length; i<n; ++i) {
	    a = angles[i];
	    x = Math.cos(a); ix = ir*x; ox = or*x;
	    y = Math.sin(a); iy = ir*y; oy = or*y;
	    xmin = Math.min(xmin, ix, ox);
	    xmax = Math.max(xmax, ix, ox);
	    ymin = Math.min(ymin, iy, oy);
	    ymax = Math.max(ymax, iy, oy);
	  }
	
	  return strokeBounds(o, bounds.set(
	    cx + xmin,
	    cy + ymin,
	    cx + xmax,
	    cy + ymax
	  ));
	}
	
	function symbol(o, bounds) {
	  var size = o.size != null ? o.size : 100,
	      x = o.x || 0,
	      y = o.y || 0,
	      r, t, rx, ry;
	
	  switch (o.shape) {
	    case 'cross':
	      t = 3 * Math.sqrt(size / 5) / 2;
	      bounds.set(x-t, y-t, x+t, y+t);
	      break;
	
	    case 'diamond':
	      ry = Math.sqrt(size / (2 * tan30));
	      rx = ry * tan30;
	      bounds.set(x-rx, y-ry, x+rx, y+ry);
	      break;
	
	    case 'square':
	      t = Math.sqrt(size);
	      r = t / 2;
	      bounds.set(x-r, y-r, x+r, y+r);
	      break;
	
	    case 'triangle-down':
	      rx = Math.sqrt(size / sqrt3);
	      ry = rx * sqrt3 / 2;
	      bounds.set(x-rx, y-ry, x+rx, y+ry);
	      break;
	
	    case 'triangle-up':
	      rx = Math.sqrt(size / sqrt3);
	      ry = rx * sqrt3 / 2;
	      bounds.set(x-rx, y-ry, x+rx, y+ry);
	      break;
	
	    default:
	      r = Math.sqrt(size/Math.PI);
	      bounds.set(x-r, y-r, x+r, y+r);
	  }
	
	  return strokeBounds(o, bounds);
	}
	
	function textMark(o, bounds, noRotate) {
	  var g = context(),
	      h = text.size(o),
	      a = o.align,
	      r = o.radius || 0,
	      x = (o.x || 0),
	      y = (o.y || 0),
	      dx = (o.dx || 0),
	      dy = (o.dy || 0) + text.offset(o) - Math.round(0.8*h), // use 4/5 offset
	      w, t;
	
	  if (r) {
	    t = (o.theta || 0) - Math.PI/2;
	    x += r * Math.cos(t);
	    y += r * Math.sin(t);
	  }
	
	  // horizontal alignment
	  g.font = text.font(o);
	  w = g.measureText(text.value(o.text)).width;
	  if (a === 'center') {
	    dx -= (w / 2);
	  } else if (a === 'right') {
	    dx -= w;
	  } else {
	    // left by default, do nothing
	  }
	
	  bounds.set(dx+=x, dy+=y, dx+w, dy+h);
	  if (o.angle && !noRotate) {
	    bounds.rotate(o.angle*Math.PI/180, x, y);
	  }
	  return bounds.expand(noRotate ? 0 : 1);
	}
	
	function group(g, bounds, includeLegends) {
	  var axes = g.axisItems || [],
	      items = g.items || [],
	      legends = g.legendItems || [],
	      j, m;
	
	  if (!g.clip) {
	    for (j=0, m=axes.length; j<m; ++j) {
	      bounds.union(axes[j].bounds);
	    }
	    for (j=0, m=items.length; j<m; ++j) {
	      if (items[j].bounds) bounds.union(items[j].bounds);
	    }
	    if (includeLegends) {
	      for (j=0, m=legends.length; j<m; ++j) {
	        bounds.union(legends[j].bounds);
	      }
	    }
	  }
	  if (g.clip || g.width || g.height) {
	    strokeBounds(g, bounds
	      .add(0, 0)
	      .add(g.width || 0, g.height || 0));
	  }
	  return bounds.translate(g.x || 0, g.y || 0);
	}
	
	var methods = {
	  group:  group,
	  symbol: symbol,
	  image:  image,
	  rect:   rect,
	  rule:   rule,
	  arc:    arc,
	  text:   textMark,
	  path:   path,
	  area:   area,
	  line:   line
	};
	methods.area.nest = true;
	methods.line.nest = true;
	
	function itemBounds(item, func, opt) {
	  var type = item.mark.marktype;
	  func = func || methods[type];
	  if (func.nest) item = item.mark;
	
	  var curr = item.bounds,
	      prev = item['bounds:prev'] || (item['bounds:prev'] = new Bounds());
	
	  if (curr) {
	    prev.clear().union(curr);
	    curr.clear();
	  } else {
	    item.bounds = new Bounds();
	  }
	  func(item, item.bounds, opt);
	  if (!curr) prev.clear().union(item.bounds);
	  return item.bounds;
	}
	
	var DUMMY_ITEM = {mark: null};
	
	function markBounds(mark, bounds, opt) {
	  var type  = mark.marktype,
	      func  = methods[type],
	      items = mark.items,
	      hasi  = items && items.length,
	      i, n, o, b;
	
	  if (func.nest) {
	    o = hasi ? items[0]
	      : (DUMMY_ITEM.mark = mark, DUMMY_ITEM); // no items, so fake it
	    b = itemBounds(o, func, opt);
	    bounds = bounds && bounds.union(b) || b;
	    return bounds;
	  }
	
	  bounds = bounds || mark.bounds && mark.bounds.clear() || new Bounds();
	  if (hasi) {  
	    for (i=0, n=items.length; i<n; ++i) {
	      bounds.union(itemBounds(items[i], func, opt));
	    }
	  }
	  return (mark.bounds = bounds);
	}
	
	module.exports = {
	  mark:  markBounds,
	  item:  itemBounds,
	  text:  textMark,
	  group: group
	};


/***/ },
/* 84 */
/***/ function(module, exports) {

	module.exports = function(b) {
	  function noop() { }
	  function add(x,y) { b.add(x, y); }
	
	  return {
	    bounds: function(_) {
	      if (!arguments.length) return b;
	      return (b = _, this);
	    },
	    beginPath: noop,
	    closePath: noop,
	    moveTo: add,
	    lineTo: add,
	    quadraticCurveTo: function(x1, y1, x2, y2) {
	      b.add(x1, y1);
	      b.add(x2, y2);
	    },
	    bezierCurveTo: function(x1, y1, x2, y2, x3, y3) {
	      b.add(x1, y1);
	      b.add(x2, y2);
	      b.add(x3, y3);
	    }
	  };
	};


/***/ },
/* 85 */
/***/ function(module, exports, __webpack_require__) {

	function instance(w, h) {
	  w = w || 1;
	  h = h || 1;
	  var canvas;
	
	  if (typeof document !== 'undefined' && document.createElement) {
	    canvas = document.createElement('canvas');
	    canvas.width = w;
	    canvas.height = h;
	  } else {
	    var Canvas = __webpack_require__(86);
	    if (!Canvas.prototype) return null;
	    canvas = new Canvas(w, h);
	  }
	  return lineDash(canvas);
	}
	
	function resize(canvas, w, h, p, retina) {
	  var g = this._ctx = canvas.getContext('2d'), 
	      s = 1;
	
	  canvas.width = w + p.left + p.right;
	  canvas.height = h + p.top + p.bottom;
	
	  // if browser canvas, attempt to modify for retina display
	  if (retina && typeof HTMLElement !== 'undefined' &&
	      canvas instanceof HTMLElement)
	  {
	    g.pixelratio = (s = pixelRatio(canvas) || 1);
	  }
	
	  g.setTransform(s, 0, 0, s, s*p.left, s*p.top);
	  return canvas;
	}
	
	function pixelRatio(canvas) {
	  var g = canvas.getContext('2d');
	
	  // get canvas pixel data
	  var devicePixelRatio = window && window.devicePixelRatio || 1,
	      backingStoreRatio = (
	        g.webkitBackingStorePixelRatio ||
	        g.mozBackingStorePixelRatio ||
	        g.msBackingStorePixelRatio ||
	        g.oBackingStorePixelRatio ||
	        g.backingStorePixelRatio) || 1,
	      ratio = devicePixelRatio / backingStoreRatio;
	
	  if (devicePixelRatio !== backingStoreRatio) {
	    // set actual and visible canvas size
	    var w = canvas.width,
	        h = canvas.height;
	    canvas.width = w * ratio;
	    canvas.height = h * ratio;
	    canvas.style.width = w + 'px';
	    canvas.style.height = h + 'px';
	  }
	
	  return ratio;
	}
	
	function lineDash(canvas) {
	  var g = canvas.getContext('2d');
	  if (g.vgLineDash) return; // already initialized!
	
	  var NOOP = function() {},
	      NODASH = [];
	  
	  if (g.setLineDash) {
	    g.vgLineDash = function(dash) { this.setLineDash(dash || NODASH); };
	    g.vgLineDashOffset = function(off) { this.lineDashOffset = off; };
	  } else if (g.webkitLineDash !== undefined) {
	  	g.vgLineDash = function(dash) { this.webkitLineDash = dash || NODASH; };
	    g.vgLineDashOffset = function(off) { this.webkitLineDashOffset = off; };
	  } else if (g.mozDash !== undefined) {
	    g.vgLineDash = function(dash) { this.mozDash = dash; };
	    g.vgLineDashOffset = NOOP;
	  } else {
	    g.vgLineDash = NOOP;
	    g.vgLineDashOffset = NOOP;
	  }
	  return canvas;
	}
	
	module.exports = {
	  instance:   instance,
	  resize:     resize,
	  lineDash:   lineDash
	};


/***/ },
/* 86 */
/***/ function(module, exports) {

	/* (ignored) */

/***/ },
/* 87 */
/***/ function(module, exports) {

	function size(item) {
	  return item.fontSize != null ? item.fontSize : 11;
	}
	
	module.exports = {
	  size: size,
	  value: function(s) {
	    return s != null ? String(s) : '';
	  },
	  font: function(item, quote) {
	    var font = item.font;
	    if (quote && font) {
	      font = String(font).replace(/\"/g, '\'');
	    }
	    return '' +
	      (item.fontStyle ? item.fontStyle + ' ' : '') +
	      (item.fontVariant ? item.fontVariant + ' ' : '') +
	      (item.fontWeight ? item.fontWeight + ' ' : '') +
	      size(item) + 'px ' +
	      (font || 'sans-serif');
	  },
	  offset: function(item) {
	    // perform our own font baseline calculation
	    // why? not all browsers support SVG 1.1 'alignment-baseline' :(
	    var baseline = item.baseline,
	        h = size(item);
	    return Math.round(
	      baseline === 'top'    ?  0.93*h :
	      baseline === 'middle' ?  0.30*h :
	      baseline === 'bottom' ? -0.21*h : 0
	    );
	  }
	};


/***/ },
/* 88 */
/***/ function(module, exports, __webpack_require__) {

	var DOM = __webpack_require__(67),
	    Bounds = __webpack_require__(82),
	    ImageLoader = __webpack_require__(89),
	    Canvas = __webpack_require__(85),
	    Renderer = __webpack_require__(90),
	    marks = __webpack_require__(69);
	
	function CanvasRenderer(loadConfig) {
	  Renderer.call(this);
	  this._loader = new ImageLoader(loadConfig);
	}
	
	CanvasRenderer.RETINA = true;
	
	var base = Renderer.prototype;
	var prototype = (CanvasRenderer.prototype = Object.create(base));
	prototype.constructor = CanvasRenderer;
	
	prototype.initialize = function(el, width, height, padding) {
	  this._canvas = Canvas.instance(width, height);
	  if (el) {
	    DOM.clear(el, 0).appendChild(this._canvas);
	    this._canvas.setAttribute('class', 'marks');
	  }
	  return base.initialize.call(this, el, width, height, padding);
	};
	
	prototype.resize = function(width, height, padding) {
	  base.resize.call(this, width, height, padding);
	  Canvas.resize(this._canvas, this._width, this._height,
	    this._padding, CanvasRenderer.RETINA);
	  return this;
	};
	
	prototype.canvas = function() {
	  return this._canvas;
	};
	
	prototype.context = function() {
	  return this._canvas ? this._canvas.getContext('2d') : null;
	};
	
	prototype.pendingImages = function() {
	  return this._loader.pending();
	};
	
	function clipToBounds(g, items) {
	  if (!items) return null;
	
	  var b = new Bounds(), i, n, item, mark, group;
	  for (i=0, n=items.length; i<n; ++i) {
	    item = items[i];
	    mark = item.mark;
	    group = mark.group;
	    item = marks[mark.marktype].nested ? mark : item;
	    b.union(translate(item.bounds, group));
	    if (item['bounds:prev']) {
	      b.union(translate(item['bounds:prev'], group));
	    }
	  }
	  b.round();
	
	  g.beginPath();
	  g.rect(b.x1, b.y1, b.width(), b.height());
	  g.clip();
	
	  return b;
	}
	
	function translate(bounds, group) {
	  if (group == null) return bounds;
	  var b = bounds.clone();
	  for (; group != null; group = group.mark.group) {
	    b.translate(group.x || 0, group.y || 0);
	  }
	  return b;
	}
	
	prototype.render = function(scene, items) {
	  var g = this.context(),
	      p = this._padding,
	      w = this._width + p.left + p.right,
	      h = this._height + p.top + p.bottom,
	      b;
	
	  // setup
	  this._scene = scene; // cache scene for async redraw
	  g.save();
	  b = clipToBounds(g, items);
	  this.clear(-p.left, -p.top, w, h);
	
	  // render
	  this.draw(g, scene, b);
	  
	  // takedown
	  g.restore();
	  this._scene = null; // clear scene cache
	
	  return this;
	};
	
	prototype.draw = function(ctx, scene, bounds) {
	  var mark = marks[scene.marktype];
	  mark.draw.call(this, ctx, scene, bounds);
	};
	
	prototype.clear = function(x, y, w, h) {
	  var g = this.context();
	  g.clearRect(x, y, w, h);
	  if (this._bgcolor != null) {
	    g.fillStyle = this._bgcolor;
	    g.fillRect(x, y, w, h); 
	  }
	};
	
	prototype.loadImage = function(uri) {
	  var renderer = this,
	      scene = this._scene;
	  return this._loader.loadImage(uri, function() {
	    renderer.renderAsync(scene);
	  });
	};
	
	prototype.renderAsync = function(scene) {
	  // TODO make safe for multiple scene rendering?
	  var renderer = this;
	  if (renderer._async_id) {
	    clearTimeout(renderer._async_id);
	  }
	  renderer._async_id = setTimeout(function() {
	    renderer.render(scene);
	    delete renderer._async_id;
	  }, 10);
	};
	
	module.exports = CanvasRenderer;


/***/ },
/* 89 */
/***/ function(module, exports, __webpack_require__) {

	var load = __webpack_require__(18);
	
	function ImageLoader(loadConfig) {
	  this._pending = 0;
	  this._config = loadConfig || ImageLoader.Config; 
	}
	
	// Overridable global default load configuration
	ImageLoader.Config = null;
	
	var prototype = ImageLoader.prototype;
	
	prototype.pending = function() {
	  return this._pending;
	};
	
	prototype.params = function(uri) {
	  var p = {url: uri}, k;
	  for (k in this._config) { p[k] = this._config[k]; }
	  return p;
	};
	
	prototype.imageURL = function(uri) {
	  return load.sanitizeUrl(this.params(uri));
	};
	
	function browser(uri, callback) {
	  var url = load.sanitizeUrl(this.params(uri));
	  if (!url) { // error
	    if (callback) callback(uri, null);
	    return null;
	  }
	
	  var loader = this,
	      image = new Image();
	
	  loader._pending += 1;
	
	  image.onload = function() {
	    loader._pending -= 1;
	    image.loaded = true;
	    if (callback) callback(null, image);
	  };
	  image.src = url;
	
	  return image;
	}
	
	function server(uri, callback) {
	  var loader = this,
	      image = new (__webpack_require__(86).Image)();
	
	  loader._pending += 1;
	
	  load(this.params(uri), function(err, data) {
	    loader._pending -= 1;
	    if (err) {
	      if (callback) callback(err, null);
	      return null;
	    }
	    image.src = data;
	    image.loaded = true;
	    if (callback) callback(null, image);
	  });
	
	  return image;
	}
	
	prototype.loadImage = function(uri, callback) {
	  return load.useXHR ?
	    browser.call(this, uri, callback) :
	    server.call(this, uri, callback);
	};
	
	module.exports = ImageLoader;


/***/ },
/* 90 */
/***/ function(module, exports) {

	function Renderer() {
	  this._el = null;
	  this._bgcolor = null;
	}
	
	var prototype = Renderer.prototype;
	
	prototype.initialize = function(el, width, height, padding) {
	  this._el = el;
	  return this.resize(width, height, padding);
	};
	
	// Returns the parent container element for a visualization
	prototype.element = function() {
	  return this._el;
	};
	
	// Returns the scene element (e.g., canvas or SVG) of the visualization
	// Subclasses must override if the first child is not the scene element
	prototype.scene = function() {
	  return this._el && this._el.firstChild;
	};
	
	prototype.background = function(bgcolor) {
	  if (arguments.length === 0) return this._bgcolor;
	  this._bgcolor = bgcolor;
	  return this;
	};
	
	prototype.resize = function(width, height, padding) {
	  this._width = width;
	  this._height = height;
	  this._padding = padding || {top:0, left:0, bottom:0, right:0};
	  return this;
	};
	
	prototype.render = function(/*scene, items*/) {
	  return this;
	};
	
	module.exports = Renderer;

/***/ },
/* 91 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = {
	  Handler:  __webpack_require__(92),
	  Renderer: __webpack_require__(93),
	  string: {
	    Renderer : __webpack_require__(95)
	  }
	};

/***/ },
/* 92 */
/***/ function(module, exports, __webpack_require__) {

	var DOM = __webpack_require__(67),
	    Handler = __webpack_require__(68);
	
	function SVGHandler() {
	  Handler.call(this);
	}
	
	var base = Handler.prototype;
	var prototype = (SVGHandler.prototype = Object.create(base));
	prototype.constructor = SVGHandler;
	
	prototype.initialize = function(el, pad, obj) {
	  this._svg = DOM.find(el, 'svg');
	  return base.initialize.call(this, el, pad, obj);
	};
	
	prototype.svg = function() {
	  return this._svg;
	};
	
	// wrap an event listener for the SVG DOM
	prototype.listener = function(handler) {
	  var that = this;
	  return function(evt) {
	    var target = evt.target,
	        item = target.__data__;
	    evt.vegaType = evt.type;
	    item = Array.isArray(item) ? item[0] : item;
	    handler.call(that._obj, evt, item);
	  };
	};
	
	// add an event handler
	prototype.on = function(type, handler) {
	  var name = this.eventName(type),
	      svg = this._svg,
	      h = this._handlers,
	      x = {
	        type:     type,
	        handler:  handler,
	        listener: this.listener(handler)
	      };
	
	  (h[name] || (h[name] = [])).push(x);
	  svg.addEventListener(name, x.listener);
	  return this;
	};
	
	// remove an event handler
	prototype.off = function(type, handler) {
	  var name = this.eventName(type),
	      svg = this._svg,
	      h = this._handlers[name], i;
	  if (!h) return;
	  for (i=h.length; --i>=0;) {
	    if (h[i].type === type && !handler || h[i].handler === handler) {
	      svg.removeEventListener(name, h[i].listener);
	      h.splice(i, 1);
	    }
	  }
	  return this;
	};
	
	module.exports = SVGHandler;


/***/ },
/* 93 */
/***/ function(module, exports, __webpack_require__) {

	var ImageLoader = __webpack_require__(89),
	    Renderer = __webpack_require__(90),
	    text = __webpack_require__(87),
	    DOM = __webpack_require__(67),
	    SVG = __webpack_require__(73),
	    ns = SVG.metadata.xmlns,
	    marks = __webpack_require__(94);
	
	function SVGRenderer(loadConfig) {
	  Renderer.call(this);
	  this._loader = new ImageLoader(loadConfig);
	  this._dirtyID = 0;
	}
	
	var base = Renderer.prototype;
	var prototype = (SVGRenderer.prototype = Object.create(base));
	prototype.constructor = SVGRenderer;
	
	prototype.initialize = function(el, width, height, padding) {
	  if (el) {
	    this._svg = DOM.child(el, 0, 'svg', ns, 'marks');
	    DOM.clear(el, 1);
	    // set the svg root group
	    this._root = DOM.child(this._svg, 0, 'g', ns);
	    DOM.clear(this._svg, 1);
	  }
	
	  // create the svg definitions cache
	  this._defs = {
	    clip_id:  1,
	    gradient: {},
	    clipping: {}
	  };
	
	  // set background color if defined
	  this.background(this._bgcolor);
	
	  return base.initialize.call(this, el, width, height, padding);
	};
	
	prototype.background = function(bgcolor) {
	  if (arguments.length && this._svg) {
	    this._svg.style.setProperty('background-color', bgcolor);
	  }
	  return base.background.apply(this, arguments);
	};
	
	prototype.resize = function(width, height, padding) {
	  base.resize.call(this, width, height, padding);
	  
	  if (this._svg) {
	    var w = this._width,
	        h = this._height,
	        p = this._padding;
	  
	    this._svg.setAttribute('width', w + p.left + p.right);
	    this._svg.setAttribute('height', h + p.top + p.bottom);
	    
	    this._root.setAttribute('transform', 'translate('+p.left+','+p.top+')');
	  }
	
	  return this;
	};
	
	prototype.svg = function() {
	  if (!this._svg) return null;
	
	  var attr = {
	    'class':  'marks',
	    'width':  this._width + this._padding.left + this._padding.right,
	    'height': this._height + this._padding.top + this._padding.bottom,
	  };
	  for (var key in SVG.metadata) {
	    attr[key] = SVG.metadata[key];
	  }
	
	  return DOM.openTag('svg', attr) + this._svg.innerHTML + DOM.closeTag('svg');
	};
	
	prototype.imageURL = function(url) {
	  return this._loader.imageURL(url);
	};
	
	
	// -- Render entry point --
	
	prototype.render = function(scene, items) {
	  if (this._dirtyCheck(items)) {
	    if (this._dirtyAll) this._resetDefs();
	    this.draw(this._root, scene, -1);
	    DOM.clear(this._root, 1);
	  }
	  this.updateDefs();
	  return this;
	};
	
	prototype.draw = function(el, scene, index) {
	  this.drawMark(el, scene, index, marks[scene.marktype]);
	};
	
	
	// -- Manage SVG definitions ('defs') block --
	
	prototype.updateDefs = function() {
	  var svg = this._svg,
	      defs = this._defs,
	      el = defs.el,
	      index = 0, id;
	
	  for (id in defs.gradient) {
	    if (!el) el = (defs.el = DOM.child(svg, 0, 'defs', ns));
	    updateGradient(el, defs.gradient[id], index++);
	  }
	
	  for (id in defs.clipping) {
	    if (!el) el = (defs.el = DOM.child(svg, 0, 'defs', ns));
	    updateClipping(el, defs.clipping[id], index++);
	  }
	
	  // clean-up
	  if (el) {
	    if (index === 0) {
	      svg.removeChild(el);
	      defs.el = null;
	    } else {
	      DOM.clear(el, index);      
	    }
	  }
	};
	
	function updateGradient(el, grad, index) {
	  var i, n, stop;
	
	  el = DOM.child(el, index, 'linearGradient', ns);
	  el.setAttribute('id', grad.id);
	  el.setAttribute('x1', grad.x1);
	  el.setAttribute('x2', grad.x2);
	  el.setAttribute('y1', grad.y1);
	  el.setAttribute('y2', grad.y2);
	  
	  for (i=0, n=grad.stops.length; i<n; ++i) {
	    stop = DOM.child(el, i, 'stop', ns);
	    stop.setAttribute('offset', grad.stops[i].offset);
	    stop.setAttribute('stop-color', grad.stops[i].color);
	  }
	  DOM.clear(el, i);
	}
	
	function updateClipping(el, clip, index) {
	  var rect;
	
	  el = DOM.child(el, index, 'clipPath', ns);
	  el.setAttribute('id', clip.id);
	  rect = DOM.child(el, 0, 'rect', ns);
	  rect.setAttribute('x', 0);
	  rect.setAttribute('y', 0);
	  rect.setAttribute('width', clip.width);
	  rect.setAttribute('height', clip.height);
	}
	
	prototype._resetDefs = function() {
	  var def = this._defs;
	  def.clip_id = 1;
	  def.gradient = {};
	  def.clipping = {};
	};
	
	
	// -- Manage rendering of items marked as dirty --
	
	prototype.isDirty = function(item) {
	  return this._dirtyAll || item.dirty === this._dirtyID;
	};
	
	prototype._dirtyCheck = function(items) {
	  this._dirtyAll = true;
	  if (!items) return true;
	
	  var id = ++this._dirtyID,
	      item, mark, type, mdef, i, n, o;
	
	  for (i=0, n=items.length; i<n; ++i) {
	    item = items[i];
	    mark = item.mark;
	    if (mark.marktype !== type) {
	      // memoize mark instance lookup
	      type = mark.marktype;
	      mdef = marks[type];
	    }
	
	    if (item.status === 'exit') { // EXIT
	      if (item._svg) {
	        if (mdef.nest && item.mark.items.length) {
	          // if nested mark with remaining points, update instead
	          this._update(mdef, item._svg, item.mark.items[0]);
	          o = item.mark.items[0];
	          o._svg = item._svg;
	          o._update = id;
	        } else {
	          // otherwise remove from DOM
	          DOM.remove(item._svg);
	        }
	        item._svg = null;
	      }
	      continue;
	    }
	
	    item = (mdef.nest ? mark.items[0] : item);
	    if (item._update === id) { // Already processed
	      continue;
	    } else if (item._svg) { // UPDATE
	      this._update(mdef, item._svg, item);
	    } else { // ENTER
	      this._dirtyAll = false;
	      dirtyParents(item, id);
	    }
	    item._update = id;
	  }
	  return !this._dirtyAll;
	};
	
	function dirtyParents(item, id) {
	  for (; item && item.dirty !== id; item=item.mark.group) {
	    item.dirty = id;
	    if (item.mark && item.mark.dirty !== id) {
	      item.mark.dirty = id;
	    } else return;
	  }
	}
	
	
	// -- Construct & maintain scenegraph to SVG mapping ---
	
	// Draw a mark container.
	prototype.drawMark = function(el, scene, index, mdef) {
	  if (!this.isDirty(scene)) return;
	
	  var items = mdef.nest ?
	        (scene.items && scene.items.length ? [scene.items[0]] : []) :
	        scene.items || [],
	      events = scene.interactive === false ? 'none' : null,
	      isGroup = (mdef.tag === 'g'),
	      className = DOM.cssClass(scene),
	      p, i, n, c, d, insert;
	
	  p = DOM.child(el, index+1, 'g', ns, className);
	  p.setAttribute('class', className);
	  scene._svg = p;
	  if (!isGroup && events) {
	    p.style.setProperty('pointer-events', events);
	  }
	
	  for (i=0, n=items.length; i<n; ++i) {
	    if (this.isDirty(d = items[i])) {
	      insert = !(this._dirtyAll || d._svg);
	      c = bind(p, mdef, d, i, insert);
	      this._update(mdef, c, d);
	      if (isGroup) {
	        if (insert) this._dirtyAll = true;
	        this._recurse(c, d);
	        if (insert) this._dirtyAll = false;
	      }
	    }
	  }
	  DOM.clear(p, i);
	  return p;
	};
	
	// Recursively process group contents.
	prototype._recurse = function(el, group) {
	  var items = group.items || [],
	      legends = group.legendItems || [],
	      axes = group.axisItems || [],
	      idx = 0, j, m;
	
	  for (j=0, m=axes.length; j<m; ++j) {
	    if (axes[j].layer === 'back') {
	      this.drawMark(el, axes[j], idx++, marks.group);
	    }
	  }
	  for (j=0, m=items.length; j<m; ++j) {
	    this.draw(el, items[j], idx++);
	  }
	  for (j=0, m=axes.length; j<m; ++j) {
	    if (axes[j].layer !== 'back') {
	      this.drawMark(el, axes[j], idx++, marks.group);
	    }
	  }
	  for (j=0, m=legends.length; j<m; ++j) {
	    this.drawMark(el, legends[j], idx++, marks.group);
	  }
	
	  // remove any extraneous DOM elements
	  DOM.clear(el, 1 + idx);
	};
	
	// Bind a scenegraph item to an SVG DOM element.
	// Create new SVG elements as needed.
	function bind(el, mdef, item, index, insert) {
	  // create svg element, bind item data for D3 compatibility
	  var node = DOM.child(el, index, mdef.tag, ns, null, insert);
	  node.__data__ = item;
	  node.__values__ = {fill: 'default'};
	
	  // create background rect
	  if (mdef.tag === 'g') {
	    var bg = DOM.child(node, 0, 'rect', ns, 'background');
	    bg.__data__ = item;
	  }
	
	  // add pointer from scenegraph item to svg element
	  return (item._svg = node);
	}
	
	
	// -- Set attributes & styles on SVG elements ---
	
	var element = null, // temp var for current SVG element
	    values = null;  // temp var for current values hash
	
	// Extra configuration for certain mark types
	var mark_extras = {
	  group: function(mdef, el, item) {
	    element = el.childNodes[0];
	    values = el.__values__; // use parent's values hash
	    mdef.background(emit, item, this);
	
	    var value = item.mark.interactive === false ? 'none' : null;
	    if (value !== values.events) {
	      element.style.setProperty('pointer-events', value);
	      values.events = value;
	    }
	  },
	  text: function(mdef, el, item) {
	    var str = text.value(item.text);
	    if (str !== values.text) {
	      el.textContent = str;
	      values.text = str;
	    }
	    str = text.font(item);
	    if (str !== values.font) {
	      el.style.setProperty('font', str);
	      values.font = str;
	    }
	  }
	};
	
	prototype._update = function(mdef, el, item) {
	  // set dom element and values cache
	  // provides access to emit method
	  element = el;
	  values = el.__values__;
	
	  // apply svg attributes
	  mdef.attr(emit, item, this);
	
	  // some marks need special treatment
	  var extra = mark_extras[mdef.type];
	  if (extra) extra(mdef, el, item);
	
	  // apply svg css styles
	  // note: element may be modified by 'extra' method
	  this.style(element, item);
	};
	
	function emit(name, value, ns) {
	  // early exit if value is unchanged
	  if (value === values[name]) return;
	
	  if (value != null) {
	    // if value is provided, update DOM attribute
	    if (ns) {
	      element.setAttributeNS(ns, name, value);
	    } else {
	      element.setAttribute(name, value);
	    }
	  } else {
	    // else remove DOM attribute
	    if (ns) {
	      element.removeAttributeNS(ns, name);
	    } else {
	      element.removeAttribute(name);
	    }
	  }
	
	  // note current value for future comparison
	  values[name] = value;
	}
	
	prototype.style = function(el, o) {
	  if (o == null) return;
	  var i, n, prop, name, value;
	
	  for (i=0, n=SVG.styleProperties.length; i<n; ++i) {
	    prop = SVG.styleProperties[i];
	    value = o[prop];
	    if (value === values[prop]) continue;
	
	    name = SVG.styles[prop];
	    if (value == null) {
	      if (name === 'fill') {
	        el.style.setProperty(name, 'none');
	      } else {
	        el.style.removeProperty(name);
	      }
	    } else {
	      if (value.id) {
	        // ensure definition is included
	        this._defs.gradient[value.id] = value;
	        value = 'url(' + href() + '#' + value.id + ')';
	      }
	      el.style.setProperty(name, value+'');
	    }
	
	    values[prop] = value;
	  }
	};
	
	function href() {
	  return typeof window !== 'undefined' ? window.location.href : '';
	}
	
	module.exports = SVGRenderer;


/***/ },
/* 94 */
/***/ function(module, exports, __webpack_require__) {

	var text = __webpack_require__(87),
	    SVG = __webpack_require__(73),
	    textAlign = SVG.textAlign,
	    path = SVG.path;
	
	function translateItem(o) {
	  return translate(o.x || 0, o.y || 0);
	}
	
	function translate(x, y) {
	  return 'translate(' + x + ',' + y + ')';
	}
	
	module.exports = {
	  arc: {
	    tag:  'path',
	    type: 'arc',
	    attr: function(emit, o) {
	      emit('transform', translateItem(o));
	      emit('d', path.arc(o));
	    }
	  },
	  area: {
	    tag:  'path',
	    type: 'area',
	    nest: true,
	    attr: function(emit, o) {
	      var items = o.mark.items;
	      if (items.length) emit('d', path.area(items));
	    }
	  },
	  group: {
	    tag:  'g',
	    type: 'group',
	    attr: function(emit, o, renderer) {
	      var id = null, defs, c;
	      emit('transform', translateItem(o));
	      if (o.clip) {
	        defs = renderer._defs;
	        id = o.clip_id || (o.clip_id = 'clip' + defs.clip_id++);
	        c = defs.clipping[id] || (defs.clipping[id] = {id: id});
	        c.width = o.width || 0;
	        c.height = o.height || 0;
	      }
	      emit('clip-path', id ? ('url(#' + id + ')') : null);
	    },
	    background: function(emit, o) {
	      emit('class', 'background');
	      emit('width', o.width || 0);
	      emit('height', o.height || 0);
	    }
	  },
	  image: {
	    tag:  'image',
	    type: 'image',
	    attr: function(emit, o, renderer) {
	      var x = o.x || 0,
	          y = o.y || 0,
	          w = o.width || 0,
	          h = o.height || 0,
	          url = renderer.imageURL(o.url);
	
	      x = x - (o.align === 'center' ? w/2 : o.align === 'right' ? w : 0);
	      y = y - (o.baseline === 'middle' ? h/2 : o.baseline === 'bottom' ? h : 0);
	
	      emit('href', url, 'http://www.w3.org/1999/xlink', 'xlink:href');
	      emit('transform', translate(x, y));
	      emit('width', w);
	      emit('height', h);
	    }
	  },
	  line: {
	    tag:  'path',
	    type: 'line',
	    nest: true,
	    attr: function(emit, o) {
	      var items = o.mark.items;
	      if (items.length) emit('d', path.line(items));
	    }
	  },
	  path: {
	    tag:  'path',
	    type: 'path',
	    attr: function(emit, o) {
	      emit('transform', translateItem(o));
	      emit('d', o.path);
	    }
	  },
	  rect: {
	    tag:  'rect',
	    type: 'rect',
	    nest: false,
	    attr: function(emit, o) {
	      emit('transform', translateItem(o));
	      emit('width', o.width || 0);
	      emit('height', o.height || 0);
	    }
	  },
	  rule: {
	    tag:  'line',
	    type: 'rule',
	    attr: function(emit, o) {
	      emit('transform', translateItem(o));
	      emit('x2', o.x2 != null ? o.x2 - (o.x||0) : 0);
	      emit('y2', o.y2 != null ? o.y2 - (o.y||0) : 0);
	    }
	  },
	  symbol: {
	    tag:  'path',
	    type: 'symbol',
	    attr: function(emit, o) {
	      emit('transform', translateItem(o));
	      emit('d', path.symbol(o));
	    }
	  },
	  text: {
	    tag:  'text',
	    type: 'text',
	    nest: false,
	    attr: function(emit, o) {
	      var dx = (o.dx || 0),
	          dy = (o.dy || 0) + text.offset(o),
	          x = (o.x || 0),
	          y = (o.y || 0),
	          a = o.angle || 0,
	          r = o.radius || 0, t;
	
	      if (r) {
	        t = (o.theta || 0) - Math.PI/2;
	        x += r * Math.cos(t);
	        y += r * Math.sin(t);
	      }
	
	      emit('text-anchor', textAlign[o.align] || 'start');
	      
	      if (a) {
	        t = translate(x, y) + ' rotate('+a+')';
	        if (dx || dy) t += ' ' + translate(dx, dy);
	      } else {
	        t = translate(x+dx, y+dy);
	      }
	      emit('transform', t);
	    }
	  }
	};


/***/ },
/* 95 */
/***/ function(module, exports, __webpack_require__) {

	var Renderer = __webpack_require__(90),
	    ImageLoader = __webpack_require__(89),
	    SVG = __webpack_require__(73),
	    text = __webpack_require__(87),
	    DOM = __webpack_require__(67),
	    openTag = DOM.openTag,
	    closeTag = DOM.closeTag,
	    MARKS = __webpack_require__(94);
	
	function SVGStringRenderer(loadConfig) {
	  Renderer.call(this);
	
	  this._loader = new ImageLoader(loadConfig);
	
	  this._text = {
	    head: '',
	    root: '',
	    foot: '',
	    defs: '',
	    body: ''
	  };
	
	  this._defs = {
	    clip_id:  1,
	    gradient: {},
	    clipping: {}
	  };
	}
	
	var base = Renderer.prototype;
	var prototype = (SVGStringRenderer.prototype = Object.create(base));
	prototype.constructor = SVGStringRenderer;
	
	prototype.resize = function(width, height, padding) {
	  base.resize.call(this, width, height, padding);
	  var p = this._padding,
	      t = this._text;
	
	  var attr = {
	    'class':  'marks',
	    'width':  this._width + p.left + p.right,
	    'height': this._height + p.top + p.bottom,
	  };
	  for (var key in SVG.metadata) {
	    attr[key] = SVG.metadata[key];
	  }
	
	  t.head = openTag('svg', attr);
	  t.root = openTag('g', {
	    transform: 'translate(' + p.left + ',' + p.top + ')'
	  });
	  t.foot = closeTag('g') + closeTag('svg');
	
	  return this;
	};
	
	prototype.svg = function() {
	  var t = this._text;
	  return t.head + t.defs + t.root + t.body + t.foot;
	};
	
	prototype.render = function(scene) {
	  this._text.body = this.mark(scene);
	  this._text.defs = this.buildDefs();
	  return this;
	};
	
	prototype.reset = function() {
	  this._defs.clip_id = 0;
	  return this;
	};
	
	prototype.buildDefs = function() {
	  var all = this._defs,
	      defs = '',
	      i, id, def, stops;
	
	  for (id in all.gradient) {
	    def = all.gradient[id];
	    stops = def.stops;
	
	    defs += openTag('linearGradient', {
	      id: id,
	      x1: def.x1,
	      x2: def.x2,
	      y1: def.y1,
	      y2: def.y2
	    });
	    
	    for (i=0; i<stops.length; ++i) {
	      defs += openTag('stop', {
	        offset: stops[i].offset,
	        'stop-color': stops[i].color
	      }) + closeTag('stop');
	    }
	    
	    defs += closeTag('linearGradient');
	  }
	  
	  for (id in all.clipping) {
	    def = all.clipping[id];
	
	    defs += openTag('clipPath', {id: id});
	
	    defs += openTag('rect', {
	      x: 0,
	      y: 0,
	      width: def.width,
	      height: def.height
	    }) + closeTag('rect');
	
	    defs += closeTag('clipPath');
	  }
	  
	  return (defs.length > 0) ? openTag('defs') + defs + closeTag('defs') : '';
	};
	
	prototype.imageURL = function(url) {
	  return this._loader.imageURL(url);
	};
	
	var object;
	
	function emit(name, value, ns, prefixed) {
	  object[prefixed || name] = value;
	}
	
	prototype.attributes = function(attr, item) {
	  object = {};
	  attr(emit, item, this);
	  return object;
	};
	
	prototype.mark = function(scene) {
	  var mdef = MARKS[scene.marktype],
	      tag  = mdef.tag,
	      attr = mdef.attr,
	      nest = mdef.nest || false,
	      data = nest ?
	          (scene.items && scene.items.length ? [scene.items[0]] : []) :
	          (scene.items || []),
	      defs = this._defs,
	      str = '',
	      style, i, item;
	
	  if (tag !== 'g' && scene.interactive === false) {
	    style = 'style="pointer-events: none;"';
	  }
	
	  // render opening group tag
	  str += openTag('g', {
	    'class': DOM.cssClass(scene)
	  }, style);
	
	  // render contained elements
	  for (i=0; i<data.length; ++i) {
	    item = data[i];
	    style = (tag !== 'g') ? styles(item, scene, tag, defs) : null;
	    str += openTag(tag, this.attributes(attr, item), style);
	    if (tag === 'text') {
	      str += escape_text(text.value(item.text));
	    } else if (tag === 'g') {
	      str += openTag('rect',
	        this.attributes(mdef.background, item),
	        styles(item, scene, 'bgrect', defs)) + closeTag('rect');
	      str += this.markGroup(item);
	    }
	    str += closeTag(tag);
	  }
	
	  // render closing group tag
	  return str + closeTag('g');
	};
	
	prototype.markGroup = function(scene) {
	  var str = '',
	      axes = scene.axisItems || [],
	      items = scene.items || [],
	      legends = scene.legendItems || [],
	      j, m;
	
	  for (j=0, m=axes.length; j<m; ++j) {
	    if (axes[j].layer === 'back') {
	      str += this.mark(axes[j]);
	    }
	  }
	  for (j=0, m=items.length; j<m; ++j) {
	    str += this.mark(items[j]);
	  }
	  for (j=0, m=axes.length; j<m; ++j) {
	    if (axes[j].layer !== 'back') {
	      str += this.mark(axes[j]);
	    }
	  }
	  for (j=0, m=legends.length; j<m; ++j) {
	    str += this.mark(legends[j]);
	  }
	
	  return str;
	};
	
	function styles(o, mark, tag, defs) {
	  if (o == null) return '';
	  var i, n, prop, name, value, s = '';
	
	  if (tag === 'bgrect' && mark.interactive === false) {
	    s += 'pointer-events: none;';
	  }
	
	  if (tag === 'text') {
	    s += 'font: ' + text.font(o) + ';';
	  }
	
	  for (i=0, n=SVG.styleProperties.length; i<n; ++i) {
	    prop = SVG.styleProperties[i];
	    name = SVG.styles[prop];
	    value = o[prop];
	
	    if (value == null) {
	      if (name === 'fill') {
	        s += (s.length ? ' ' : '') + 'fill: none;';
	      }
	    } else {
	      if (value.id) {
	        // ensure definition is included
	        defs.gradient[value.id] = value;
	        value = 'url(#' + value.id + ')';
	      }
	      s += (s.length ? ' ' : '') + name + ': ' + value + ';';
	    }
	  }
	
	  return s ? 'style="' + s + '"' : null;
	}
	
	function escape_text(s) {
	  return s.replace(/&/g, '&amp;')
	          .replace(/</g, '&lt;')
	          .replace(/>/g, '&gt;');
	}
	
	module.exports = SVGStringRenderer;


/***/ },
/* 96 */
/***/ function(module, exports) {

	function Item(mark) {
	  this.mark = mark;
	}
	
	var prototype = Item.prototype;
	
	prototype.hasPropertySet = function(name) {
	  var props = this.mark.def.properties;
	  return props && props[name] != null;
	};
	
	prototype.cousin = function(offset, index) {
	  if (offset === 0) return this;
	  offset = offset || -1;
	  var mark = this.mark,
	      group = mark.group,
	      iidx = index==null ? mark.items.indexOf(this) : index,
	      midx = group.items.indexOf(mark) + offset;
	  return group.items[midx].items[iidx];
	};
	
	prototype.sibling = function(offset) {
	  if (offset === 0) return this;
	  offset = offset || -1;
	  var mark = this.mark,
	      iidx = mark.items.indexOf(this) + offset;
	  return mark.items[iidx];
	};
	
	prototype.remove = function() {
	  var item = this,
	      list = item.mark.items,
	      i = list.indexOf(item);
	  if (i >= 0) {
	    if (i===list.length-1) {
	      list.pop();
	    } else {
	      list.splice(i, 1);
	    }
	  }
	  return item;
	};
	
	prototype.touch = function() {
	  if (this.pathCache) this.pathCache = null;
	};
	
	module.exports = Item;

/***/ },
/* 97 */
/***/ function(module, exports) {

	var gradient_id = 0;
	
	function Gradient(type) {
	  this.id = 'gradient_' + (gradient_id++);
	  this.type = type || 'linear';
	  this.stops = [];
	  this.x1 = 0;
	  this.x2 = 1;
	  this.y1 = 0;
	  this.y2 = 0;
	}
	
	var prototype = Gradient.prototype;
	
	prototype.stop = function(offset, color) {
	  this.stops.push({
	    offset: offset,
	    color: color
	  });
	  return this;
	};
	
	module.exports = Gradient;

/***/ },
/* 98 */
/***/ function(module, exports, __webpack_require__) {

	var bound = __webpack_require__(83);
	
	var sets = [
	  'items',
	  'axisItems',
	  'legendItems'
	];
	
	var keys = [
	  'marktype', 'name', 'interactive', 'clip',
	  'items', 'axisItems', 'legendItems', 'layer',
	  'x', 'y', 'width', 'height', 'align', 'baseline',             // layout
	  'fill', 'fillOpacity', 'opacity',                             // fill
	  'stroke', 'strokeOpacity', 'strokeWidth', 'strokeCap',        // stroke
	  'strokeDash', 'strokeDashOffset',                             // stroke dash
	  'startAngle', 'endAngle', 'innerRadius', 'outerRadius',       // arc
	  'interpolate', 'tension', 'orient',                           // area, line
	  'url',                                                        // image
	  'path',                                                       // path
	  'x2', 'y2',                                                   // rule
	  'size', 'shape',                                              // symbol
	  'text', 'angle', 'theta', 'radius', 'dx', 'dy',               // text
	  'font', 'fontSize', 'fontWeight', 'fontStyle', 'fontVariant'  // font
	];
	
	function toJSON(scene, indent) {
	  return JSON.stringify(scene, keys, indent);
	}
	
	function fromJSON(json) {
	  var scene = (typeof json === 'string' ? JSON.parse(json) : json);
	  return initialize(scene);
	}
	
	function initialize(scene) {
	  var type = scene.marktype,
	      i, n, s, m, items;
	
	  for (s=0, m=sets.length; s<m; ++s) {
	    if ((items = scene[sets[s]])) {
	      for (i=0, n=items.length; i<n; ++i) {
	        items[i][type ? 'mark' : 'group'] = scene;
	        if (!type || type === 'group') {
	          initialize(items[i]);
	        }
	      }
	    }
	  }
	
	  if (type) bound.mark(scene);
	  return scene;
	}
	
	module.exports = {
	  toJSON:   toJSON,
	  fromJSON: fromJSON
	};

/***/ },
/* 99 */
/***/ function(module, exports, __webpack_require__) {

	var d3 = __webpack_require__(2);
	
	function parseBg(bg) {
	  // return null if input is null or undefined
	  if (bg == null) return null;
	  // run through d3 rgb to sanity check
	  return d3.rgb(bg) + '';
	}
	
	module.exports = parseBg;
	
	parseBg.schema = {"defs": {"background": {"type": "string"}}};


/***/ },
/* 100 */
/***/ function(module, exports, __webpack_require__) {

	var dl = __webpack_require__(12),
	    log = __webpack_require__(8),
	    parseTransforms = __webpack_require__(101),
	    parseModify = __webpack_require__(133);
	
	function parseData(model, spec, callback) {
	  var config = model.config(),
	      count = 0;
	
	  function onError(error, d) {
	    log.error('PARSE DATA FAILED: ' + d.name + ' ' + error);
	    count = -1;
	    callback(error);
	  }
	
	  function onLoad(d) {
	    return function(error, data) {
	      if (error) {
	        onError(error, d);
	      } else if (count > 0) {
	        try {
	          model.data(d.name).values(dl.read(data, d.format));
	          if (--count === 0) callback();
	        } catch (err) {
	          onError(err, d);
	        }
	      }
	    };
	  }
	
	  // process each data set definition
	  (spec || []).forEach(function(d) {
	    if (d.url) {
	      count += 1;
	      dl.load(dl.extend({url: d.url}, config.load), onLoad(d));
	    }
	    try {
	      parseData.datasource(model, d);
	    } catch (err) {
	      onError(err, d);
	    }
	  });
	
	  if (count === 0) setTimeout(callback, 1);
	  return spec;
	}
	
	parseData.datasource = function(model, d) {
	  var transform = (d.transform || []).map(function(t) {
	        return parseTransforms(model, t);
	      }),
	      mod = (d.modify || []).map(function(m) {
	        return parseModify(model, m, d);
	      }),
	      ds = model.data(d.name, mod.concat(transform));
	
	  if (d.values) {
	    ds.values(dl.read(d.values, d.format));
	  } else if (d.source) {
	    // Derived ds will be pulsed by its src rather than the model.
	    ds.source(d.source).addListener(ds);
	    model.removeListener(ds.pipeline()[0]);
	  }
	
	  return ds;
	};
	
	module.exports = parseData;
	
	var parseDef = {
	  "oneOf": [
	    {"enum": ["auto"]},
	    {
	      "type": "object",
	      "additionalProperties": {
	        "enum": ["number", "boolean", "date", "string"]
	      }
	    }
	  ]
	};
	
	parseData.schema = {
	  "defs": {
	    "data": {
	      "title": "Input data set definition",
	      "type": "object",
	
	      "allOf": [{
	        "properties": {
	          "name": {"type": "string"},
	          "transform": {"$ref": "#/defs/transform"},
	          "modify": {"$ref": "#/defs/modify"},
	          "format": {
	            "type": "object",
	            "oneOf": [{
	              "properties": {
	                "type": {"enum": ["json"]},
	                "parse": parseDef,
	                "property": {"type": "string"}
	              },
	              "additionalProperties": false
	            }, {
	              "properties": {
	                "type": {"enum": ["csv", "tsv"]},
	                "parse": parseDef
	              },
	              "additionalProperties": false
	            }, {
	              "oneOf": [{
	                "properties": {
	                  "type": {"enum": ["topojson"]},
	                  "feature": {"type": "string"}
	                },
	                "additionalProperties": false
	              }, {
	                "properties": {
	                  "type": {"enum": ["topojson"]},
	                  "mesh": {"type": "string"}
	                },
	                "additionalProperties": false
	              }]
	            }, {
	              "properties": {
	                "type": {"enum": ["treejson"]},
	                "children": {"type": "string"},
	                "parse": parseDef
	              },
	              "additionalProperties": false
	            }]
	          }
	        },
	        "required": ["name"]
	      }, {
	        "anyOf": [{
	          "required": ["name", "modify"]
	        }, {
	          "oneOf": [{
	            "properties": {"source": {"type": "string"}},
	            "required": ["source"]
	          }, {
	            "properties": {"values": {"type": "array"}},
	            "required": ["values"]
	          }, {
	            "properties": {"url": {"type": "string"}},
	            "required": ["url"]
	          }]
	        }]
	      }]
	    }
	  }
	};


/***/ },
/* 101 */
/***/ function(module, exports, __webpack_require__) {

	var dl = __webpack_require__(12),
	    transforms = __webpack_require__(102);
	
	function parseTransforms(model, def) {
	  var transform = transforms[def.type],
	      tx;
	
	  if (!transform) throw new Error('"' + def.type + '" is not a valid transformation');
	
	  tx = new transform(model);
	  // We want to rename output fields before setting any other properties,
	  // as subsequent properties may require output to be set (e.g. group by).
	  if(def.output) tx.output(def.output);
	
	  dl.keys(def).forEach(function(k) {
	    if(k === 'type' || k === 'output') return;
	    tx.param(k, def[k]);
	  });
	
	  return tx;
	}
	
	module.exports = parseTransforms;
	
	var keys = dl.keys(transforms)
	  .filter(function(k) { return transforms[k].schema; });
	
	var defs = keys.reduce(function(acc, k) {
	  return (acc[k+'Transform'] = transforms[k].schema, acc);
	}, {});
	
	parseTransforms.schema = {
	  "defs": dl.extend(defs, {
	    "transform": {
	      "type": "array",
	      "items": {
	        "oneOf": keys.map(function(k) {
	          return {"$ref": "#/defs/"+k+"Transform"};
	        })
	      }
	    }
	  })
	};


/***/ },
/* 102 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = {
	  aggregate:    __webpack_require__(103),
	  bin:          __webpack_require__(107),
	  cross:        __webpack_require__(109),
	  countpattern: __webpack_require__(110),
	  linkpath:     __webpack_require__(111),
	  facet:        __webpack_require__(112),
	  filter:       __webpack_require__(113),
	  fold:         __webpack_require__(114),
	  force:        __webpack_require__(115),
	  formula:      __webpack_require__(117),
	  geo:          __webpack_require__(118),
	  geopath:      __webpack_require__(119),
	  hierarchy:    __webpack_require__(120),
	  impute:       __webpack_require__(121),
	  lookup:       __webpack_require__(122),
	  pie:          __webpack_require__(123),
	  rank:         __webpack_require__(124),
	  sort:         __webpack_require__(125),
	  stack:        __webpack_require__(126),
	  treeify:      __webpack_require__(127),
	  treemap:      __webpack_require__(128),
	  voronoi:      __webpack_require__(129),
	  wordcloud:    __webpack_require__(130)
	};

/***/ },
/* 103 */
/***/ function(module, exports, __webpack_require__) {

	var dl = __webpack_require__(12),
	    df = __webpack_require__(4),
	    log = __webpack_require__(8),
	    ChangeSet = df.ChangeSet,
	    Tuple = df.Tuple,
	    Deps = df.Dependencies,
	    Transform = __webpack_require__(104),
	    Facetor = __webpack_require__(106);
	
	function Aggregate(graph) {
	  Transform.prototype.init.call(this, graph);
	
	  Transform.addParameters(this, {
	    groupby: {type: 'array<field>'},
	    summarize: {
	      type: 'custom',
	      set: function(summarize) {
	        var signalDeps = {},
	            tx = this._transform,
	            i, len, f, fields, name, ops;
	
	        if (!dl.isArray(fields = summarize)) { // Object syntax from dl
	          fields = [];
	          for (name in summarize) {
	            ops = dl.array(summarize[name]);
	            fields.push({field: name, ops: ops});
	          }
	        }
	
	        function sg(x) { if (x.signal) signalDeps[x.signal] = 1; }
	
	        for (i=0, len=fields.length; i<len; ++i) {
	          f = fields[i];
	          if (f.field.signal) { signalDeps[f.field.signal] = 1; }
	          dl.array(f.ops).forEach(sg);
	          dl.array(f.as).forEach(sg);
	        }
	
	        tx._fields = fields;
	        tx._aggr = null;
	        tx.dependency(Deps.SIGNALS, dl.keys(signalDeps));
	        return tx;
	      }
	    }
	  });
	
	  this._aggr  = null; // dl.Aggregator
	  this._input = null; // Used by Facetor._on_keep.
	  this._args  = null; // To cull re-computation.
	  this._fields = [];
	  this._out = [];
	
	  this._type = TYPES.TUPLE;
	  this._acc = {groupby: dl.true, value: dl.true};
	
	  return this.router(true).produces(true);
	}
	
	var prototype = (Aggregate.prototype = Object.create(Transform.prototype));
	prototype.constructor = Aggregate;
	
	var TYPES = Aggregate.TYPES = {
	  VALUE: 1,
	  TUPLE: 2,
	  MULTI: 3
	};
	
	Aggregate.VALID_OPS = [
	  'values', 'count', 'valid', 'missing', 'distinct',
	  'sum', 'mean', 'average', 'variance', 'variancep', 'stdev',
	  'stdevp', 'median', 'q1', 'q3', 'modeskew', 'min', 'max',
	  'argmin', 'argmax'
	];
	
	prototype.type = function(type) {
	  return (this._type = type, this);
	};
	
	prototype.accessors = function(groupby, value) {
	  var acc = this._acc;
	  acc.groupby = dl.$(groupby) || dl.true;
	  acc.value = dl.$(value) || dl.true;
	};
	
	prototype.aggr = function() {
	  if (this._aggr) return this._aggr;
	
	  var g = this._graph,
	      hasGetter = false,
	      args = [],
	      groupby = this.param('groupby').field,
	      value = function(x) { return x.signal ? g.signalRef(x.signal) : x; };
	
	  // Prepare summarize fields.
	  var fields = this._fields.map(function(f) {
	    var field = {
	      name: value(f.field),
	      as:   dl.array(f.as),
	      ops:  dl.array(value(f.ops)).map(value),
	      get:  f.get
	    };
	    hasGetter = hasGetter || field.get != null;
	    args.push(field.name);
	    return field;
	  });
	
	  // If there is an arbitrary getter, all bets are off.
	  // Otherwise, we can check argument fields to cull re-computation.
	  groupby.forEach(function(g) {
	    if (g.get) hasGetter = true;
	    args.push(g.name || g);
	  });
	  this._args = hasGetter || !fields.length ? null : args;
	
	  if (!fields.length) fields = {'*': 'values'};
	
	  // Instantiate our aggregator instance.
	  // Facetor is a special subclass that can facet into data pipelines.
	  var aggr = this._aggr = new Facetor()
	    .groupby(groupby)
	    .stream(true)
	    .summarize(fields);
	
	  // Collect output fields sets by this aggregate.
	  this._out = getFields(aggr);
	
	  // If we are processing tuples, key them by '_id'.
	  if (this._type !== TYPES.VALUE) { aggr.key('_id'); }
	
	  return aggr;
	};
	
	function getFields(aggr) {
	  // Collect the output fields set by this aggregate.
	  var f = [], i, n, j, m, dims, vals, meas;
	
	  dims = aggr._dims;
	  for (i=0, n=dims.length; i<n; ++i) {
	    f.push(dims[i].name);
	  }
	
	  vals = aggr._aggr;
	  for (i=0, n=vals.length; i<n; ++i) {
	    meas = vals[i].measures.fields;
	    for (j=0, m=meas.length; j<m; ++j) {
	      f.push(meas[j]);
	    }
	  }
	
	  return f;
	}
	
	prototype.transform = function(input, reset) {
	  log.debug(input, ['aggregate']);
	
	  var output = ChangeSet.create(input),
	      aggr = this.aggr(),
	      out = this._out,
	      args = this._args,
	      reeval = true,
	      p = Tuple.prev,
	      add, rem, mod, mark, i;
	
	  // Upon reset, retract prior tuples and re-initialize.
	  if (reset) {
	    output.rem.push.apply(output.rem, aggr.result());
	    aggr.clear();
	    this._aggr = null;
	    aggr = this.aggr();
	  }
	
	  // Get update methods according to input type.
	  if (this._type === TYPES.TUPLE) {
	    add  = function(x) { aggr._add(x); Tuple.prev_init(x); };
	    rem  = function(x) { aggr._rem(p(x)); };
	    mod  = function(x) { aggr._mod(x, p(x)); };
	    mark = function(x) { aggr._markMod(x, p(x)); };
	  } else {
	    var gby = this._acc.groupby,
	        val = this._acc.value,
	        get = this._type === TYPES.VALUE ? val : function(x) {
	          return { _id: x._id, groupby: gby(x), value: val(x) };
	        };
	    add  = function(x) { aggr._add(get(x)); Tuple.prev_init(x); };
	    rem  = function(x) { aggr._rem(get(p(x))); };
	    mod  = function(x) { aggr._mod(get(x), get(p(x))); };
	    mark = function(x) { aggr._mark(get(x), get(p(x))); };
	  }
	
	  input.add.forEach(add);
	  if (reset) {
	    // A signal change triggered reflow. Add everything.
	    // No need for rem, we cleared the aggregator.
	    input.mod.forEach(add);
	  } else {
	    input.rem.forEach(rem);
	
	    // If possible, check argument fields to see if we need to re-process mods.
	    if (args) for (i=0, reeval=false; i<args.length; ++i) {
	      if (input.fields[args[i]]) { reeval = true; break; }
	    }
	    input.mod.forEach(reeval ? mod : mark);
	  }
	
	  // Indicate output fields and return aggregate tuples.
	  for (i=0; i<out.length; ++i) {
	    output.fields[out[i]] = 1;
	  }
	  return (aggr._input = input, aggr.changes(output));
	};
	
	module.exports = Aggregate;
	
	var VALID_OPS = Aggregate.VALID_OPS;
	
	Aggregate.schema = {
	  "$schema": "http://json-schema.org/draft-04/schema#",
	  "title": "Aggregate transform",
	  "description": "Compute summary aggregate statistics",
	  "type": "object",
	  "properties": {
	    "type": {"enum": ["aggregate"]},
	    "groupby": {
	      "type": "array",
	      "items": {"oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}]},
	      "description": "A list of fields to split the data into groups."
	    },
	    "summarize": {
	      "oneOf": [
	        {
	          "type": "object",
	          "additionalProperties": {
	            "type": "array",
	            "description": "An array of aggregate functions.",
	            "items": {"oneOf": [{"enum": VALID_OPS}, {"$ref": "#/refs/signal"}]}
	          }
	        },
	        {
	          "type": "array",
	          "items": {
	            "type": "object",
	            "properties": {
	              "field": {
	                "description": "The name of the field to aggregate.",
	                "oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}]
	              },
	              "ops": {
	                "type": "array",
	                "description": "An array of aggregate functions.",
	                "items": {"oneOf": [{"enum": VALID_OPS}, {"$ref": "#/refs/signal"}]}
	              },
	              "as": {
	                "type": "array",
	                "description": "An optional array of names to use for the output fields.",
	                "items": {"oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}]}
	              }
	            },
	            "additionalProperties": false,
	            "required": ["field", "ops"]
	          }
	        }
	      ]
	    }
	  },
	  "additionalProperties": false,
	  "required": ["type"]
	};


/***/ },
/* 104 */
/***/ function(module, exports, __webpack_require__) {

	var df = __webpack_require__(4),
	    Base = df.Node.prototype, // jshint ignore:line
	    Deps = df.Dependencies,
	    Parameter = __webpack_require__(105);
	
	function Transform(graph) {
	  if (graph) Base.init.call(this, graph);
	}
	
	Transform.addParameters = function(proto, params) {
	  proto._parameters = proto._parameters || {};
	  for (var name in params) {
	    var p = params[name],
	        param = new Parameter(name, p.type, proto);
	
	    proto._parameters[name] = param;
	
	    if (p.type === 'custom') {
	      if (p.set) param.set = p.set.bind(param);
	      if (p.get) param.get = p.get.bind(param);
	    }
	
	    if (p.hasOwnProperty('default')) param.set(p.default);
	  }
	};
	
	var prototype = (Transform.prototype = Object.create(Base));
	prototype.constructor = Transform;
	
	prototype.param = function(name, value) {
	  var param = this._parameters[name];
	  return (param === undefined) ? this :
	    (arguments.length === 1) ? param.get() : param.set(value);
	};
	
	// Perform transformation. Subclasses should override.
	prototype.transform = function(input/*, reset */) {
	  return input;
	};
	
	prototype.evaluate = function(input) {
	  // Many transforms store caches that must be invalidated if
	  // a signal value has changed.
	  var reset = this._stamp < input.stamp &&
	    this.dependency(Deps.SIGNALS).reduce(function(c, s) {
	      return c += input.signals[s] ? 1 : 0;
	    }, 0);
	  return this.transform(input, reset);
	};
	
	prototype.output = function(map) {
	  for (var key in this._output) {
	    if (map[key] !== undefined) {
	      this._output[key] = map[key];
	    }
	  }
	  return this;
	};
	
	module.exports = Transform;


/***/ },
/* 105 */
/***/ function(module, exports, __webpack_require__) {

	var dl = __webpack_require__(12),
	    Deps = __webpack_require__(4).Dependencies;
	
	var arrayType = /array/i,
	    dataType  = /data/i,
	    fieldType = /field/i,
	    exprType  = /expr/i,
	    valType   = /value/i;
	
	function Parameter(name, type, transform) {
	  this._name = name;
	  this._type = type;
	  this._transform = transform;
	
	  // If parameter is defined w/signals, it must be resolved
	  // on every pulse.
	  this._value = [];
	  this._accessors = [];
	  this._resolution = false;
	  this._signals = [];
	}
	
	var prototype = Parameter.prototype;
	
	function get() {
	  var isArray = arrayType.test(this._type),
	      isData  = dataType.test(this._type),
	      isField = fieldType.test(this._type);
	
	  var val = isArray ? this._value : this._value[0],
	      acc = isArray ? this._accessors : this._accessors[0];
	
	  if (!dl.isValid(acc) && valType.test(this._type)) {
	    return val;
	  } else {
	    return isData ? { name: val, source: acc } :
	    isField ? { field: val, accessor: acc } : val;
	  }
	}
	
	prototype.get = function() {
	  var graph = this._transform._graph,
	      isData  = dataType.test(this._type),
	      isField = fieldType.test(this._type),
	      i, n, sig, idx, val;
	
	  // If we don't require resolution, return the value immediately.
	  if (!this._resolution) return get.call(this);
	
	  if (isData) {
	    this._accessors = this._value.map(function(v) { return graph.data(v); });
	    return get.call(this); // TODO: support signal as dataTypes
	  }
	
	  for (i=0, n=this._signals.length; i<n; ++i) {
	    sig = this._signals[i];
	    idx = sig.index;
	    val = sig.value(graph);
	
	    if (isField) {
	      this._accessors[idx] = this._value[idx] != val ?
	        dl.accessor(val) : this._accessors[idx];
	    }
	
	    this._value[idx] = val;
	  }
	
	  return get.call(this);
	};
	
	prototype.set = function(value) {
	  var p = this,
	      graph = p._transform._graph,
	      isExpr = exprType.test(this._type),
	      isData  = dataType.test(this._type),
	      isField = fieldType.test(this._type);
	
	  p._signals = [];
	  this._value = dl.array(value).map(function(v, i) {
	    var e;
	    if (dl.isString(v)) {
	      if (isExpr) {
	        e = graph.expr(v);
	        p._transform.dependency(Deps.FIELDS,  e.fields);
	        p._transform.dependency(Deps.SIGNALS, e.globals);
	        p._transform.dependency(Deps.DATA,    e.dataSources);
	        return e.fn;
	      } else if (isField) {  // Backwards compatibility
	        p._accessors[i] = dl.accessor(v);
	        p._transform.dependency(Deps.FIELDS, dl.field(v));
	      } else if (isData) {
	        p._resolution = true;
	        p._transform.dependency(Deps.DATA, v);
	      }
	      return v;
	    } else if (v.value !== undefined) {
	      return v.value;
	    } else if (v.field !== undefined) {
	      p._accessors[i] = dl.accessor(v.field);
	      p._transform.dependency(Deps.FIELDS, dl.field(v.field));
	      return v.field;
	    } else if (v.signal !== undefined) {
	      p._resolution = true;
	      p._transform.dependency(Deps.SIGNALS, v.signal);
	      p._signals.push({
	        index: i,
	        value: function(graph) { return graph.signalRef(v.signal); }
	      });
	      return v.signal;
	    } else if (v.expr !== undefined) {
	      p._resolution = true;
	      e = graph.expr(v.expr);
	      p._transform.dependency(Deps.SIGNALS, e.globals);
	      p._signals.push({
	        index: i,
	        value: function() { return e.fn(); }
	      });
	      return v.expr;
	    }
	
	    return v;
	  });
	
	  return p._transform;
	};
	
	module.exports = Parameter;
	
	// Schema for field|value-type parameters.
	Parameter.schema = {
	  "type": "object",
	  "oneOf": [{
	    "properties": {"field": {"type": "string"}},
	    "required": ["field"]
	  }, {
	    "properties": {"value": {"type": "string"}},
	    "required": ["value"]
	  }]
	};


/***/ },
/* 106 */
/***/ function(module, exports, __webpack_require__) {

	var dl = __webpack_require__(12),
	    Aggregator = dl.Aggregator,
	    Base = Aggregator.prototype,
	    df = __webpack_require__(4),
	    Tuple = df.Tuple,
	    log = __webpack_require__(8),
	    facetID = 0;
	
	function Facetor() {
	  Aggregator.call(this);
	  this._facet = null;
	  this._facetID = ++facetID;
	}
	
	var prototype = (Facetor.prototype = Object.create(Base));
	prototype.constructor = Facetor;
	
	prototype.facet = function(f) {
	  return arguments.length ? (this._facet = f, this) : this._facet;
	};
	
	prototype._ingest = function(t) {
	  return Tuple.ingest(t, null);
	};
	
	prototype._assign = Tuple.set;
	
	function disconnect_cell(facet) {
	  log.debug({}, ['disconnecting cell', this.tuple._id]);
	  var pipeline = this.ds.pipeline();
	  facet.removeListener(pipeline[0]);
	  facet._graph.removeListener(pipeline[0]);
	  facet._graph.disconnect(pipeline);
	}
	
	prototype._newcell = function(x, key) {
	  var cell  = Base._newcell.call(this, x, key),
	      facet = this._facet;
	
	  if (facet) {
	    var graph = facet._graph,
	        tuple = cell.tuple,
	        pipeline = facet.param('transform');
	    cell.ds = graph.data(tuple._facetID, pipeline, tuple);
	    cell.disconnect = disconnect_cell;
	    facet.addListener(pipeline[0]);
	  }
	
	  return cell;
	};
	
	prototype._newtuple = function(x, key) {
	  var t = Base._newtuple.call(this, x);
	  if (this._facet) {
	    Tuple.set(t, 'key', key);
	    Tuple.set(t, '_facetID', this._facetID + '_' + key);
	  }
	  return t;
	};
	
	prototype.clear = function() {
	  if (this._facet) {
	    for (var k in this._cells) {
	      this._cells[k].disconnect(this._facet);
	    }
	  }
	  return Base.clear.call(this);
	};
	
	prototype._on_add = function(x, cell) {
	  if (this._facet) cell.ds._input.add.push(x);
	};
	
	prototype._on_rem = function(x, cell) {
	  if (this._facet) cell.ds._input.rem.push(x);
	};
	
	prototype._on_mod = function(x, prev, cell0, cell1) {
	  if (this._facet) { // Propagate tuples
	    if (cell0 === cell1) {
	      cell0.ds._input.mod.push(x);
	    } else {
	      cell0.ds._input.rem.push(x);
	      cell1.ds._input.add.push(x);
	    }
	  }
	};
	
	prototype._on_drop = function(cell) {
	  if (this._facet) cell.disconnect(this._facet);
	};
	
	prototype._on_keep = function(cell) {
	  // propagate sort, signals, fields, etc.
	  if (this._facet) df.ChangeSet.copy(this._input, cell.ds._input);
	};
	
	module.exports = Facetor;


/***/ },
/* 107 */
/***/ function(module, exports, __webpack_require__) {

	var dl = __webpack_require__(12),
	    Tuple = __webpack_require__(4).Tuple,
	    log = __webpack_require__(8),
	    Transform = __webpack_require__(104),
	    BatchTransform = __webpack_require__(108);
	
	function Bin(graph) {
	  BatchTransform.prototype.init.call(this, graph);
	  Transform.addParameters(this, {
	    field: {type: 'field'},
	    min: {type: 'value'},
	    max: {type: 'value'},
	    base: {type: 'value', default: 10},
	    maxbins: {type: 'value', default: 20},
	    step: {type: 'value'},
	    steps: {type: 'value'},
	    minstep: {type: 'value'},
	    div: {type: 'array<value>', default: [5, 2]}
	  });
	
	  this._output = {
	    start: 'bin_start',
	    end:   'bin_end',
	    mid:   'bin_mid'
	  };
	  return this.mutates(true);
	}
	
	var prototype = (Bin.prototype = Object.create(BatchTransform.prototype));
	prototype.constructor = Bin;
	
	prototype.extent = function(data) {
	  // TODO only recompute extent upon data or field change?
	  var e = [this.param('min'), this.param('max')], d;
	  if (e[0] == null || e[1] == null) {
	    d = dl.extent(data, this.param('field').accessor);
	    if (e[0] == null) e[0] = d[0];
	    if (e[1] == null) e[1] = d[1];
	  }
	  return e;
	};
	
	prototype.batchTransform = function(input, data) {
	  log.debug(input, ['binning']);
	
	  var extent  = this.extent(data),
	      output  = this._output,
	      step    = this.param('step'),
	      steps   = this.param('steps'),
	      minstep = this.param('minstep'),
	      get     = this.param('field').accessor,
	      opt = {
	        min: extent[0],
	        max: extent[1],
	        base: this.param('base'),
	        maxbins: this.param('maxbins'),
	        div: this.param('div')
	      };
	
	  if (step) opt.step = step;
	  if (steps) opt.steps = steps;
	  if (minstep) opt.minstep = minstep;
	  var b = dl.bins(opt),
	      s = b.step;
	
	  function update(d) {
	    var v = get(d);
	    v = v == null ? null
	      : b.start + s * ~~((v - b.start) / s);
	    Tuple.set(d, output.start, v);
	    Tuple.set(d, output.end, v + s);
	    Tuple.set(d, output.mid, v + s/2);
	  }
	  input.add.forEach(update);
	  input.mod.forEach(update);
	  input.rem.forEach(update);
	
	  input.fields[output.start] = 1;
	  input.fields[output.end] = 1;
	  input.fields[output.mid] = 1;
	  return input;
	};
	
	module.exports = Bin;
	
	Bin.schema = {
	  "$schema": "http://json-schema.org/draft-04/schema#",
	  "title": "Bin transform",
	  "description": "Bins values into quantitative bins (e.g., for a histogram).",
	  "type": "object",
	  "properties": {
	    "type": {"enum": ["bin"]},
	    "field": {
	      "oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}],
	      "description": "The name of the field to bin values from."
	    },
	    "min": {
	      "oneOf": [{"type": "number"}, {"$ref": "#/refs/signal"}],
	      "description": "The minimum bin value to consider."
	    },
	    "max": {
	      "oneOf": [{"type": "number"}, {"$ref": "#/refs/signal"}],
	      "description": "The maximum bin value to consider."
	    },
	    "base": {
	      "oneOf": [{"type": "number"}, {"$ref": "#/refs/signal"}],
	      "description": "The number base to use for automatic bin determination.",
	      "default": 10
	    },
	    "maxbins": {
	      "oneOf": [{"type": "number"}, {"$ref": "#/refs/signal"}],
	      "description": "The maximum number of allowable bins.",
	      "default": 20
	    },
	    "step": {
	      "oneOf": [{"type": "number"}, {"$ref": "#/refs/signal"}],
	      "description": "An exact step size to use between bins. If provided, options such as maxbins will be ignored."
	    },
	    "steps": {
	      "description": "An array of allowable step sizes to choose from.",
	      "oneOf": [
	        {
	          "type": "array",
	          "items": {"type": "number"}
	        },
	        {"$ref": "#/refs/signal"}
	      ]
	    },
	    "minstep": {
	      "oneOf": [{"type": "number"}, {"$ref": "#/refs/signal"}],
	      "description": "A minimum allowable step size (particularly useful for integer values)."
	    },
	    "div": {
	      "description": "An array of scale factors indicating allowable subdivisions.",
	      "oneOf": [
	        {
	          "type": "array",
	          "items": {"type": "number"},
	          "default": [5, 2]
	        },
	        {"$ref": "#/refs/signal"}
	      ]
	    },
	    "output": {
	      "type": "object",
	      "description": "Rename the output data fields",
	      "properties": {
	        "start": {"type": "string", "default": "bin_start"},
	        "end": {"type": "string", "default": "bin_end"},
	        "mid": {"type": "string", "default": "bin_mid"}
	      },
	      "additionalProperties": false
	    }
	  },
	  "additionalProperties": false,
	  "required": ["type", "field"]
	};


/***/ },
/* 108 */
/***/ function(module, exports, __webpack_require__) {

	var Base = __webpack_require__(104).prototype;
	
	function BatchTransform() {
	  // Nearest appropriate collector.
	  // Set by the dataflow Graph during connection.
	  this._collector = null;
	}
	
	var prototype = (BatchTransform.prototype = Object.create(Base));
	prototype.constructor = BatchTransform;
	
	prototype.init = function(graph) {
	  Base.init.call(this, graph);
	  return this.batch(true);
	};
	
	prototype.transform = function(input, reset) {
	  return this.batchTransform(input, this._collector.data(), reset);
	};
	
	prototype.batchTransform = function(/* input, data, reset */) {
	};
	
	module.exports = BatchTransform;


/***/ },
/* 109 */
/***/ function(module, exports, __webpack_require__) {

	var dl = __webpack_require__(12),
	    df = __webpack_require__(4),
	    ChangeSet = df.ChangeSet,
	    Tuple = df.Tuple,
	    log = __webpack_require__(8),
	    Transform = __webpack_require__(104),
	    BatchTransform = __webpack_require__(108);
	
	function Cross(graph) {
	  BatchTransform.prototype.init.call(this, graph);
	  Transform.addParameters(this, {
	    with: {type: 'data'},
	    diagonal: {type: 'value', default: 'true'},
	    filter: {type: 'expr'}
	  });
	
	  this._output = {'left': 'a', 'right': 'b'};
	  this._lastWith = null; // Last time we crossed w/with-ds.
	  this._cids  = {};
	  this._cache = {};
	
	  return this.router(true).produces(true);
	}
	
	var prototype = (Cross.prototype = Object.create(BatchTransform.prototype));
	prototype.constructor = Cross;
	
	// Each cached incoming tuple also has a flag to determine whether
	// any tuples were filtered.
	function _cache(x, t) {
	  var c = this._cache,
	      cross = c[x._id] || (c[x._id] = {c: [], f: false});
	  cross.c.push(t);
	}
	
	function _cid(left, x, y) {
	  return left ? x._id+'_'+y._id : y._id+'_'+x._id;
	}
	
	function add(output, left, data, diag, test, mids, x) {
	  var as = this._output,
	      cache = this._cache,
	      cids  = this._cids,
	      oadd  = output.add,
	      fltrd = false,
	      i = 0, len = data.length,
	      t = {}, y, cid;
	
	  for (; i<len; ++i) {
	    y = data[i];
	    cid = _cid(left, x, y);
	    if (cids[cid]) continue;
	    if (x._id === y._id && !diag) continue;
	
	    Tuple.set(t, as.left, left ? x : y);
	    Tuple.set(t, as.right, left ? y : x);
	
	    // Only ingest a tuple if we keep it around. Otherwise, flag the
	    // caches as filtered.
	    if (!test || test(t)) {
	      oadd.push(t=Tuple.ingest(t));
	      _cache.call(this, x, t);
	      if (x._id !== y._id) _cache.call(this, y, t);
	      mids[t._id] = 1;
	      cids[cid] = true;
	      t = {};
	    } else {
	      if (cache[y._id]) cache[y._id].f = true;
	      fltrd = true;
	    }
	  }
	
	  if (cache[x._id]) cache[x._id].f = fltrd;
	}
	
	function mod(output, left, data, diag, test, mids, rids, x) {
	  var as = this._output,
	      cache = this._cache,
	      cids  = this._cids,
	      cross = cache[x._id],
	      tpls  = cross && cross.c,
	      fltrd = !cross || cross.f,
	      omod  = output.mod,
	      orem  = output.rem,
	      i, t, y, l, cid;
	
	  // If we have cached values, iterate through them for lazy
	  // removal, and to re-run the filter.
	  if (tpls) {
	    for (i=tpls.length-1; i>=0; --i) {
	      t = tpls[i];
	      l = x === t[as.left]; // Cache has tpls w/x both on left & right.
	      y = l ? t[as.right] : t[as.left];
	      cid = _cid(l, x, y);
	
	      // Lazy removal: y was previously rem'd, so clean up the cache.
	      if (!cache[y._id]) {
	        cids[cid] = false;
	        tpls.splice(i, 1);
	        continue;
	      }
	
	      if (!test || test(t)) {
	        if (mids[t._id]) continue;
	        omod.push(t);
	        mids[t._id] = 1;
	      } else {
	        if (!rids[t._id]) orem.push.apply(orem, tpls.splice(i, 1));
	        rids[t._id] = 1;
	        cids[cid] = false;
	        cross.f = true;
	      }
	    }
	  }
	
	  // If we have a filter param, call add to catch any tuples that may
	  // have previously been filtered.
	  if (test && fltrd) add.call(this, output, left, data, diag, test, mids, x);
	}
	
	function rem(output, left, rids, x) {
	  var as = this._output,
	      cross = this._cache[x._id],
	      cids  = this._cids,
	      orem  = output.rem,
	      i, len, t, y, l;
	  if (!cross) return;
	
	  for (i=0, len=cross.c.length; i<len; ++i) {
	    t = cross.c[i];
	    l = x === t[as.left];
	    y = l ? t[as.right] : t[as.left];
	    cids[_cid(l, x, y)] = false;
	    if (!rids[t._id]) {
	      orem.push(t);
	      rids[t._id] = 1;
	    }
	  }
	
	  this._cache[x._id] = null;
	}
	
	function purge(output, rids) {
	  var cache = this._cache,
	      keys  = dl.keys(cache),
	      rem = output.rem,
	      i, len, j, jlen, cross, t;
	
	  for (i=0, len=keys.length; i<len; ++i) {
	    cross = cache[keys[i]];
	    for (j=0, jlen=cross.c.length; j<jlen; ++j) {
	      t = cross.c[j];
	      if (rids[t._id]) continue;
	      rem.push(t);
	      rids[t._id] = 1;
	    }
	  }
	
	  this._cache = {};
	  this._cids = {};
	  this._lastWith = null;
	}
	
	prototype.batchTransform = function(input, data, reset) {
	  log.debug(input, ['crossing']);
	
	  var w = this.param('with'),
	      diag = this.param('diagonal'),
	      as = this._output,
	      test = this.param('filter') || null,
	      selfCross = (!w.name),
	      woutput = selfCross ? input : w.source.last(),
	      wdata   = selfCross ? data : w.source.values(),
	      output  = ChangeSet.create(input),
	      mids = {}, rids = {}; // Track IDs to prevent dupe mod/rem tuples.
	
	  // If signal values (for diag or test) have changed, purge the cache
	  // and re-run cross in batch mode. Otherwise stream cross values.
	  if (reset) {
	    purge.call(this, output, rids);
	    data.forEach(add.bind(this, output, true, wdata, diag, test, mids));
	    this._lastWith = woutput.stamp;
	  } else {
	    input.rem.forEach(rem.bind(this, output, true, rids));
	    input.add.forEach(add.bind(this, output, true, wdata, diag, test, mids));
	
	    if (woutput.stamp > this._lastWith) {
	      woutput.rem.forEach(rem.bind(this, output, false, rids));
	      woutput.add.forEach(add.bind(this, output, false, data, diag, test, mids));
	      woutput.mod.forEach(mod.bind(this, output, false, data, diag, test, mids, rids));
	      this._lastWith = woutput.stamp;
	    }
	
	    // Mods need to come after all removals have been run.
	    input.mod.forEach(mod.bind(this, output, true, wdata, diag, test, mids, rids));
	  }
	
	  output.fields[as.left]  = 1;
	  output.fields[as.right] = 1;
	  return output;
	};
	
	module.exports = Cross;
	
	Cross.schema = {
	  "$schema": "http://json-schema.org/draft-04/schema#",
	  "title": "Cross transform",
	  "description": "Compute the cross-product of two data sets.",
	  "type": "object",
	  "properties": {
	    "type": {"enum": ["cross"]},
	    "with": {
	      "type": "string",
	      "description": "The name of the secondary data set to cross with the primary data. " +
	        "If unspecified, the primary data is crossed with itself."
	    },
	    "diagonal": {
	      "oneOf": [{"type": "boolean"}, {"$ref": "#/refs/signal"}],
	      "description": "If false, items along the \"diagonal\" of the cross-product " +
	        "(those elements with the same index in their respective array) " +
	        "will not be included in the output.",
	      "default": true
	    },
	    "filter": {
	      "type": "string",
	      "description": "A string containing an expression (in JavaScript syntax) " +
	        "to filter the resulting data elements."
	    },
	    "output": {
	      "type": "object",
	      "description": "Rename the output data fields",
	      "properties": {
	        "left": {"type": "string", "default": "a"},
	        "right": {"type": "string", "default": "b"}
	      },
	      "additionalProperties": false
	    }
	  },
	  "additionalProperties": false,
	  "required": ["type"]
	};


/***/ },
/* 110 */
/***/ function(module, exports, __webpack_require__) {

	var df = __webpack_require__(4),
	    Tuple = df.Tuple,
	    log = __webpack_require__(8),
	    Transform = __webpack_require__(104);
	
	function CountPattern(graph) {
	  Transform.prototype.init.call(this, graph);
	  Transform.addParameters(this, {
	    field:     {type: 'field', default: 'data'},
	    pattern:   {type: 'value', default: '[\\w\']+'},
	    case:      {type: 'value', default: 'lower'},
	    stopwords: {type: 'value', default: ''}
	  });
	
	  this._output = {text: 'text', count: 'count'};
	
	  return this.router(true).produces(true);
	}
	
	var prototype = (CountPattern.prototype = Object.create(Transform.prototype));
	prototype.constructor = CountPattern;
	
	prototype.transform = function(input, reset) {
	  log.debug(input, ['countpattern']);
	
	  var get = this.param('field').accessor,
	      pattern = this.param('pattern'),
	      stop = this.param('stopwords'),
	      rem = false;
	
	  // update parameters
	  if (this._stop !== stop) {
	    this._stop = stop;
	    this._stop_re = new RegExp('^' + stop + '$', 'i');
	    reset = true;
	  }
	
	  if (this._pattern !== pattern) {
	    this._pattern = pattern;
	    this._match = new RegExp(this._pattern, 'g');
	    reset = true;
	  }
	
	  if (reset) this._counts = {};
	
	  function curr(t) { return (Tuple.prev_init(t), get(t)); }
	  function prev(t) { return get(Tuple.prev(t)); }
	
	  this._add(input.add, curr);
	  if (!reset) this._rem(input.rem, prev);
	  if (reset || (rem = input.fields[get.field])) {
	    if (rem) this._rem(input.mod, prev);
	    this._add(input.mod, curr);
	  }
	
	  // generate output tuples
	  return this._changeset(input);
	};
	
	prototype._changeset = function(input) {
	  var counts = this._counts,
	      tuples = this._tuples || (this._tuples = {}),
	      change = df.ChangeSet.create(input),
	      out = this._output, w, t, c;
	
	  for (w in counts) {
	    t = tuples[w];
	    c = counts[w] || 0;
	    if (!t && c) {
	      tuples[w] = (t = Tuple.ingest({}));
	      t[out.text] = w;
	      t[out.count] = c;
	      change.add.push(t);
	    } else if (c === 0) {
	      if (t) change.rem.push(t);
	      delete counts[w];
	      delete tuples[w];
	    } else if (t[out.count] !== c) {
	      Tuple.set(t, out.count, c);
	      change.mod.push(t);
	    }
	  }
	  return change;
	};
	
	prototype._tokenize = function(text) {
	  switch (this.param('case')) {
	    case 'upper': text = text.toUpperCase(); break;
	    case 'lower': text = text.toLowerCase(); break;
	  }
	  return text.match(this._match);
	};
	
	prototype._add = function(tuples, get) {
	  var counts = this._counts,
	      stop = this._stop_re,
	      tok, i, j, t;
	
	  for (j=0; j<tuples.length; ++j) {
	    tok = this._tokenize(get(tuples[j]));
	    for (i=0; i<tok.length; ++i) {
	      if (!stop.test(t=tok[i])) {
	        counts[t] = 1 + (counts[t] || 0);
	      }
	    }
	  }
	};
	
	prototype._rem = function(tuples, get) {
	  var counts = this._counts,
	      stop = this._stop_re,
	      tok, i, j, t;
	
	  for (j=0; j<tuples.length; ++j) {
	    tok = this._tokenize(get(tuples[j]));
	    for (i=0; i<tok.length; ++i) {
	      if (!stop.test(t=tok[i])) {
	        counts[t] -= 1;
	      }
	    }
	  }
	};
	
	module.exports = CountPattern;
	
	CountPattern.schema = {
	  "$schema": "http://json-schema.org/draft-04/schema#",
	  "title": "CountPattern transform",
	  "type": "object",
	  "properties": {
	    "type": {"enum": ["countpattern"]},
	    "field": {
	      "description": "The field containing the text to analyze.",
	      "oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}],
	      "default": 'data'
	    },
	    "pattern": {
	      "description": "A regexp pattern for matching words in text.",
	      "oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}],
	      "default": "[\\w\']+"
	    },
	    "case": {
	      "description": "Text case transformation to apply.",
	      "oneOf": [{"enum": ["lower", "upper", "none"]}, {"$ref": "#/refs/signal"}],
	      "default": "lower"
	    },
	    "stopwords": {
	      "description": "A regexp pattern for matching stopwords to omit.",
	      "oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}],
	      "default": ""
	    },
	    "output": {
	      "type": "object",
	      "description": "Rename the output data fields",
	      "properties": {
	        "text": {"type": "string", "default": "text"},
	        "count": {"type": "string", "default": "count"}
	      },
	      "additionalProperties": false
	    }
	  },
	  "additionalProperties": false,
	  "required": ["type"]
	};


/***/ },
/* 111 */
/***/ function(module, exports, __webpack_require__) {

	var Tuple = __webpack_require__(4).Tuple,
	    log = __webpack_require__(8),
	    Transform = __webpack_require__(104);
	
	function LinkPath(graph) {
	  Transform.prototype.init.call(this, graph);
	  Transform.addParameters(this, {
	    sourceX:  {type: 'field', default: '_source.layout_x'},
	    sourceY:  {type: 'field', default: '_source.layout_y'},
	    targetX:  {type: 'field', default: '_target.layout_x'},
	    targetY:  {type: 'field', default: '_target.layout_y'},
	    tension:  {type: 'value', default: 0.2},
	    shape:    {type: 'value', default: 'line'}
	  });
	
	  this._output = {'path': 'layout_path'};
	  return this.mutates(true);
	}
	
	var prototype = (LinkPath.prototype = Object.create(Transform.prototype));
	prototype.constructor = LinkPath;
	
	function line(sx, sy, tx, ty) {
	  return 'M' + sx + ',' + sy +
	         'L' + tx + ',' + ty;
	}
	
	function curve(sx, sy, tx, ty, tension) {
	  var dx = tx - sx,
	      dy = ty - sy,
	      ix = tension * (dx + dy),
	      iy = tension * (dy - dx);
	  return 'M' + sx + ',' + sy +
	         'C' + (sx+ix) + ',' + (sy+iy) +
	         ' ' + (tx+iy) + ',' + (ty-ix) +
	         ' ' + tx + ',' + ty;
	}
	
	function cornerX(sx, sy, tx, ty) {
	  return 'M' + sx + ',' + sy +
	         'V' + ty + 'H' + tx;
	}
	
	function cornerY(sx, sy, tx, ty) {
	  return 'M' + sx + ',' + sy +
	         'H' + tx + 'V' + ty;
	}
	
	function cornerR(sa, sr, ta, tr) {
	  var sc = Math.cos(sa),
	      ss = Math.sin(sa),
	      tc = Math.cos(ta),
	      ts = Math.sin(ta),
	      sf = Math.abs(ta - sa) > Math.PI ? ta <= sa : ta > sa;
	  return 'M' + (sr*sc) + ',' + (sr*ss) +
	         'A' + sr + ',' + sr + ' 0 0,' + (sf?1:0) +
	         ' ' + (sr*tc) + ',' + (sr*ts) +
	         'L' + (tr*tc) + ',' + (tr*ts);
	}
	
	function diagonalX(sx, sy, tx, ty) {
	  var m = (sx + tx) / 2;
	  return 'M' + sx + ',' + sy +
	         'C' + m  + ',' + sy +
	         ' ' + m  + ',' + ty +
	         ' ' + tx + ',' + ty;
	}
	
	function diagonalY(sx, sy, tx, ty) {
	  var m = (sy + ty) / 2;
	  return 'M' + sx + ',' + sy +
	         'C' + sx + ',' + m +
	         ' ' + tx + ',' + m +
	         ' ' + tx + ',' + ty;
	}
	
	function diagonalR(sa, sr, ta, tr) {
	  var sc = Math.cos(sa),
	      ss = Math.sin(sa),
	      tc = Math.cos(ta),
	      ts = Math.sin(ta),
	      mr = (sr + tr) / 2;
	  return 'M' + (sr*sc) + ',' + (sr*ss) +
	         'C' + (mr*sc) + ',' + (mr*ss) +
	         ' ' + (mr*tc) + ',' + (mr*ts) +
	         ' ' + (tr*tc) + ',' + (tr*ts);
	}
	
	var shapes = {
	  line:      line,
	  curve:     curve,
	  cornerX:   cornerX,
	  cornerY:   cornerY,
	  cornerR:   cornerR,
	  diagonalX: diagonalX,
	  diagonalY: diagonalY,
	  diagonalR: diagonalR
	};
	
	prototype.transform = function(input) {
	  log.debug(input, ['linkpath']);
	
	  var output = this._output,
	      shape = shapes[this.param('shape')] || shapes.line,
	      sourceX = this.param('sourceX').accessor,
	      sourceY = this.param('sourceY').accessor,
	      targetX = this.param('targetX').accessor,
	      targetY = this.param('targetY').accessor,
	      tension = this.param('tension');
	
	  function set(t) {
	    var path = shape(sourceX(t), sourceY(t), targetX(t), targetY(t), tension);
	    Tuple.set(t, output.path, path);
	  }
	
	  input.add.forEach(set);
	  if (this.reevaluate(input)) {
	    input.mod.forEach(set);
	    input.rem.forEach(set);
	  }
	
	  input.fields[output.path] = 1;
	  return input;
	};
	
	module.exports = LinkPath;
	
	LinkPath.schema = {
	  "$schema": "http://json-schema.org/draft-04/schema#",
	  "title": "LinkPath transform",
	  "description": "Computes a path definition for connecting nodes within a node-link network or tree diagram.",
	  "type": "object",
	  "properties": {
	    "type": {"enum": ["linkpath"]},
	    "sourceX": {
	      "description": "The data field that references the source x-coordinate for this link.",
	      "oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}],
	      "default": "_source"
	    },
	    "sourceY": {
	      "description": "The data field that references the source y-coordinate for this link.",
	      "oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}],
	      "default": "_source"
	    },
	    "targetX": {
	      "description": "The data field that references the target x-coordinate for this link.",
	      "oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}],
	      "default": "_target"
	    },
	    "targetY": {
	      "description": "The data field that references the target y-coordinate for this link.",
	      "oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}],
	      "default": "_target"
	    },
	    "tension": {
	      "description": "A tension parameter for the \"tightness\" of \"curve\"-shaped links.",
	      "oneOf": [
	        {
	          "type": "number",
	          "minimum": 0,
	          "maximum": 1
	        },
	        {"$ref": "#/refs/signal"}
	      ],
	      "default": 0.2
	    },
	    "shape": {
	      "description": "The path shape to use",
	      "oneOf": [
	        {"enum": ["line", "curve", "cornerX", "cornerY", "cornerR", "diagonalX", "diagonalY", "diagonalR"]},
	        {"$ref": "#/refs/signal"}
	      ],
	      "default": "line"
	    },
	    "output": {
	      "type": "object",
	      "description": "Rename the output data fields",
	      "properties": {
	        "path": {"type": "string", "default": "layout_path"}
	      },
	      "additionalProperties": false
	    }
	  },
	  "additionalProperties": false,
	  "required": ["type"]
	};


/***/ },
/* 112 */
/***/ function(module, exports, __webpack_require__) {

	var Transform = __webpack_require__(104),
	    Aggregate = __webpack_require__(103);
	
	function Facet(graph) {
	  Transform.addParameters(this, {
	    transform: {
	      type: "custom",
	      set: function(pipeline) {
	        return (this._transform._pipeline = pipeline, this._transform);
	      },
	      get: function() {
	        var parse = __webpack_require__(101),
	            facet = this._transform;
	        return facet._pipeline.map(function(t) {
	          return parse(facet._graph, t);
	        });
	      }
	    }
	  });
	
	  this._pipeline = [];
	  return Aggregate.call(this, graph);
	}
	
	var prototype = (Facet.prototype = Object.create(Aggregate.prototype));
	prototype.constructor = Facet;
	
	prototype.aggr = function() {
	  return Aggregate.prototype.aggr.call(this).facet(this);
	};
	
	prototype.transform = function(input, reset) {
	  var output  = Aggregate.prototype.transform.call(this, input, reset);
	
	  // New facet cells should trigger a re-ranking of the dataflow graph.
	  // This ensures facet datasources are computed before scenegraph nodes.
	  // We rerank the Facet's first listener, which is the next node in the
	  // datasource's pipeline.
	  if (input.add.length) {
	    this.listeners()[0].rerank();
	  }
	
	  return output;
	};
	
	module.exports = Facet;
	
	var dl = __webpack_require__(12);
	
	Facet.schema = {
	  "$schema": "http://json-schema.org/draft-04/schema#",
	  "title": "Facet transform",
	  "description": "A special aggregate transform that organizes a data set into groups or \"facets\".",
	  "type": "object",
	  "properties": dl.extend({}, Aggregate.schema.properties, {
	    "type": {"enum": ["facet"]},
	    "transform": {"$ref": "#/defs/transform"}
	  }),
	  "additionalProperties": false,
	  "required": ["type"]
	};


/***/ },
/* 113 */
/***/ function(module, exports, __webpack_require__) {

	var df = __webpack_require__(4),
	    log = __webpack_require__(8),
	    Transform = __webpack_require__(104);
	
	function Filter(graph) {
	  Transform.prototype.init.call(this, graph);
	  Transform.addParameters(this, {test: {type: 'expr'}});
	
	  this._skip = {};
	  return this.router(true);
	}
	
	var prototype = (Filter.prototype = Object.create(Transform.prototype));
	prototype.constructor = Filter;
	
	prototype.transform = function(input) {
	  log.debug(input, ['filtering']);
	
	  var output = df.ChangeSet.create(input),
	      skip = this._skip,
	      test = this.param('test');
	
	  input.rem.forEach(function(x) {
	    if (skip[x._id] !== 1) output.rem.push(x);
	    else skip[x._id] = 0;
	  });
	
	  input.add.forEach(function(x) {
	    if (test(x)) output.add.push(x);
	    else skip[x._id] = 1;
	  });
	
	  input.mod.forEach(function(x) {
	    var b = test(x),
	        s = (skip[x._id] === 1);
	    if (b && s) {
	      skip[x._id] = 0;
	      output.add.push(x);
	    } else if (b && !s) {
	      output.mod.push(x);
	    } else if (!b && s) {
	      // do nothing, keep skip true
	    } else { // !b && !s
	      output.rem.push(x);
	      skip[x._id] = 1;
	    }
	  });
	
	  return output;
	};
	
	module.exports = Filter;
	
	Filter.schema = {
	  "$schema": "http://json-schema.org/draft-04/schema#",
	  "title": "Filter transform",
	  "description": "Filters elements from a data set to remove unwanted items.",
	  "type": "object",
	  "properties": {
	    "type": {"enum": ["filter"]},
	    "test": {
	      "type": "string",
	      "description": "A string containing an expression (in JavaScript syntax) for the filter predicate."
	    }
	  },
	  "additionalProperties": false,
	  "required": ["type", "test"]
	};


/***/ },
/* 114 */
/***/ function(module, exports, __webpack_require__) {

	var df = __webpack_require__(4),
	    Tuple = df.Tuple,
	    log = __webpack_require__(8),
	    Transform = __webpack_require__(104);
	
	function Fold(graph) {
	  Transform.prototype.init.call(this, graph);
	  Transform.addParameters(this, {
	    fields: {type: 'array<field>'}
	  });
	
	  this._output = {key: 'key', value: 'value'};
	  this._cache = {};
	
	  return this.router(true).produces(true);
	}
	
	var prototype = (Fold.prototype = Object.create(Transform.prototype));
	prototype.constructor = Fold;
	
	prototype._reset = function(input, output) {
	  for (var id in this._cache) {
	    output.rem.push.apply(output.rem, this._cache[id]);
	  }
	  this._cache = {};
	};
	
	prototype._tuple = function(x, i, len) {
	  var list = this._cache[x._id] || (this._cache[x._id] = Array(len));
	  return list[i] ? Tuple.rederive(x, list[i]) : (list[i] = Tuple.derive(x));
	};
	
	prototype._fn = function(data, on, out) {
	  var i, j, n, m, d, t;
	  for (i=0, n=data.length; i<n; ++i) {
	    d = data[i];
	    for (j=0, m=on.field.length; j<m; ++j) {
	      t = this._tuple(d, j, m);
	      Tuple.set(t, this._output.key, on.field[j]);
	      Tuple.set(t, this._output.value, on.accessor[j](d));
	      out.push(t);
	    }
	  }
	};
	
	prototype.transform = function(input, reset) {
	  log.debug(input, ['folding']);
	
	  var fold = this,
	      on = this.param('fields'),
	      output = df.ChangeSet.create(input);
	
	  if (reset) this._reset(input, output);
	
	  this._fn(input.add, on, output.add);
	  this._fn(input.mod, on, reset ? output.add : output.mod);
	  input.rem.forEach(function(x) {
	    output.rem.push.apply(output.rem, fold._cache[x._id]);
	    fold._cache[x._id] = null;
	  });
	
	  // If we're only propagating values, don't mark key/value as updated.
	  if (input.add.length || input.rem.length ||
	      on.field.some(function(f) { return !!input.fields[f]; })) {
	    output.fields[this._output.key] = 1;
	    output.fields[this._output.value] = 1;
	  }
	  return output;
	};
	
	module.exports = Fold;
	
	Fold.schema = {
	  "$schema": "http://json-schema.org/draft-04/schema#",
	  "title": "Fold transform",
	  "description": "Collapse (\"fold\") one or more data properties into two properties.",
	  "type": "object",
	  "properties": {
	    "type": {"enum": ["fold"]},
	    "fields": {
	      "oneOf": [
	        {
	          "type": "array",
	          "description": "An array of field references indicating the data properties to fold.",
	          "items": {"oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}]},
	          "minItems": 1,
	          "uniqueItems": true
	        },
	        {"$ref": "#/refs/signal"}
	      ]
	    },
	    "output": {
	      "type": "object",
	      "description": "Rename the output data fields",
	      "properties": {
	        "key": {"type": "string", "default": "key"},
	        "value": {"type": "string", "default": "value"}
	      },
	      "additionalProperties": false
	    }
	  },
	  "additionalProperties": false,
	  "required": ["type", "fields"]
	};


/***/ },
/* 115 */
/***/ function(module, exports, __webpack_require__) {

	var d3 = __webpack_require__(2),
	    df = __webpack_require__(4),
	    Tuple = df.Tuple,
	    ChangeSet = df.ChangeSet,
	    log = __webpack_require__(8),
	    Transform = __webpack_require__(104);
	
	function Force(graph) {
	  Transform.prototype.init.call(this, graph);
	
	  this._prev = null;
	  this._interactive = false;
	  this._setup = true;
	  this._nodes  = [];
	  this._links = [];
	  this._layout = d3.layout.force();
	
	  Transform.addParameters(this, {
	    size: {type: 'array<value>', default: __webpack_require__(116).size},
	    bound: {type: 'value', default: true},
	    links: {type: 'data'},
	
	    // TODO: for now force these to be value params only (pun-intended)
	    // Can update to include fields after Parameter refactoring.
	    linkStrength: {type: 'value', default: 1},
	    linkDistance: {type: 'value', default: 20},
	    charge: {type: 'value', default: -30},
	
	    chargeDistance: {type: 'value', default: Infinity},
	    friction: {type: 'value', default: 0.9},
	    theta: {type: 'value', default: 0.8},
	    gravity: {type: 'value', default: 0.1},
	    alpha: {type: 'value', default: 0.1},
	    iterations: {type: 'value', default: 500},
	
	    interactive: {type: 'value', default: this._interactive},
	    active: {type: 'value', default: this._prev},
	    fixed: {type: 'data'}
	  });
	
	  this._output = {
	    'x': 'layout_x',
	    'y': 'layout_y'
	  };
	
	  return this.mutates(true);
	}
	
	var prototype = (Force.prototype = Object.create(Transform.prototype));
	prototype.constructor = Force;
	
	prototype.transform = function(nodeInput, reset) {
	  log.debug(nodeInput, ['force']);
	  reset = reset - (nodeInput.signals.active ? 1 : 0);
	
	  // get variables
	  var interactive = this.param('interactive'),
	      linkSource = this.param('links').source,
	      linkInput = linkSource.last(),
	      active = this.param('active'),
	      output = this._output,
	      layout = this._layout,
	      nodes = this._nodes,
	      links = this._links;
	
	  // configure nodes, links and layout
	  if (linkInput.stamp < nodeInput.stamp) linkInput = null;
	  this.configure(nodeInput, linkInput, interactive, reset);
	
	  // run batch layout
	  if (!interactive) {
	    var iterations = this.param('iterations');
	    for (var i=0; i<iterations; ++i) layout.tick();
	    layout.stop();
	  }
	
	  // update node positions
	  this.update(active);
	
	  // re-up alpha on parameter change
	  if (reset || active !== this._prev && active && active.update) {
	    layout.alpha(this.param('alpha')); // re-start layout
	  }
	
	  // update active node status,
	  if (active !== this._prev) {
	    this._prev = active;
	  }
	
	  // process removed nodes or edges
	  if (nodeInput.rem.length) {
	    layout.nodes(this._nodes = Tuple.idFilter(nodes, nodeInput.rem));
	  }
	  if (linkInput && linkInput.rem.length) {
	    layout.links(this._links = Tuple.idFilter(links, linkInput.rem));
	  }
	
	  // return changeset
	  nodeInput.fields[output.x] = 1;
	  nodeInput.fields[output.y] = 1;
	  return nodeInput;
	};
	
	prototype.configure = function(nodeInput, linkInput, interactive, reset) {
	  // check if we need to run configuration
	  var layout = this._layout,
	      update = this._setup || nodeInput.add.length ||
	            linkInput && linkInput.add.length ||
	            interactive !== this._interactive ||
	            this.param('charge') !== layout.charge() ||
	            this.param('linkStrength') !== layout.linkStrength() ||
	            this.param('linkDistance') !== layout.linkDistance();
	
	  if (update || reset) {
	    // a parameter changed, so update tick-only parameters
	    layout
	      .size(this.param('size'))
	      .chargeDistance(this.param('chargeDistance'))
	      .theta(this.param('theta'))
	      .gravity(this.param('gravity'))
	      .friction(this.param('friction'));
	  }
	
	  if (!update) return; // if no more updates needed, return now
	
	  this._setup = false;
	  this._interactive = interactive;
	
	  var force = this,
	      graph = this._graph,
	      nodes = this._nodes,
	      links = this._links, a, i;
	
	  // process added nodes
	  for (a=nodeInput.add, i=0; i<a.length; ++i) {
	    nodes.push({tuple: a[i]});
	  }
	
	  // process added edges
	  if (linkInput) for (a=linkInput.add, i=0; i<a.length; ++i) {
	    // TODO add configurable source/target accessors
	    // TODO support lookup by node id
	    // TODO process 'mod' of edge source or target?
	    links.push({
	      tuple:  a[i],
	      source: nodes[a[i].source],
	      target: nodes[a[i].target]
	    });
	  }
	
	  // setup handler for force layout tick events
	  var tickHandler = !interactive ? null : function() {
	    // re-schedule the transform, force reflow
	    graph.propagate(ChangeSet.create(null, true), force);
	  };
	
	  // configure the rest of the layout
	  layout
	    .linkStrength(this.param('linkStrength'))
	    .linkDistance(this.param('linkDistance'))
	    .charge(this.param('charge'))
	    .nodes(nodes)
	    .links(links)
	    .on('tick', tickHandler)
	    .start().alpha(this.param('alpha'));
	};
	
	prototype.update = function(active) {
	  var output = this._output,
	      bound = this.param('bound'),
	      fixed = this.param('fixed'),
	      size = this.param('size'),
	      nodes = this._nodes,
	      lut = {}, id, i, n, t, x, y;
	
	  if (fixed && fixed.source) {
	    // TODO: could cache and update as needed?
	    fixed = fixed.source.values();
	    for (i=0, n=fixed.length; i<n; ++i) {
	      lut[fixed[i].id] = 1;
	    }
	  }
	
	  for (i=0; i<nodes.length; ++i) {
	    n = nodes[i];
	    t = n.tuple;
	    id = t._id;
	
	    if (active && active.id === id) {
	      n.fixed = 1;
	      if (active.update) {
	        n.x = n.px = active.x;
	        n.y = n.py = active.y;
	      }
	    } else {
	      n.fixed = lut[id] || 0;
	    }
	
	    x = bound ? Math.max(0, Math.min(n.x, size[0])) : n.x;
	    y = bound ? Math.max(0, Math.min(n.y, size[1])) : n.y;
	    Tuple.set(t, output.x, x);
	    Tuple.set(t, output.y, y);
	  }
	};
	
	module.exports = Force;
	
	Force.schema = {
	  "$schema": "http://json-schema.org/draft-04/schema#",
	  "title": "Force transform",
	  "description": "Performs force-directed layout for network data.",
	  "type": "object",
	  "properties": {
	    "type": {"enum": ["force"]},
	    "size": {
	      "description": "The dimensions [width, height] of this force layout.",
	      "oneOf": [
	        {
	          "type": "array",
	          "minItems": 2,
	          "maxItems": 2,
	          "items": {"oneOf": [{"type": "number"}, {"$ref": "#/refs/signal"}]}
	        },
	        {"$ref": "#/refs/signal"}
	      ],
	
	      "default": [500, 500]
	    },
	    "links": {
	      "type": "string",
	      "description": "The name of the link (edge) data set."
	    },
	    "linkDistance": {
	      "description": "Determines the length of edges, in pixels.",
	      "oneOf": [{"type": "number"}, {"type": "string"}, {"$ref": "#/refs/signal"}],
	      "default": 20
	    },
	    "linkStrength": {
	      "oneOf": [{"type": "number"}, {"type": "string"}, {"$ref": "#/refs/signal"}],
	      "description": "Determines the tension of edges (the spring constant).",
	      "default": 1
	    },
	    "charge": {
	      "oneOf": [{"type": "number"}, {"type": "string"}, {"$ref": "#/refs/signal"}],
	      "description": "The strength of the charge each node exerts.",
	      "default": -30
	    },
	    "chargeDistance": {
	      "oneOf": [{"type": "number"}, {"$ref": "#/refs/signal"}],
	      "description": "The maximum distance over which charge forces are applied.",
	      "default": Infinity
	    },
	    "iterations": {
	      "description": "The number of iterations to run the force directed layout.",
	      "oneOf": [{"type": "number"}, {"$ref": "#/refs/signal"}],
	      "default": 500
	    },
	    "friction": {
	      "description": "The strength of the friction force used to stabilize the layout.",
	      "oneOf": [{"type": "number"}, {"$ref": "#/refs/signal"}],
	      "default": 0.9
	    },
	    "theta": {
	      "description": "The theta parameter for the Barnes-Hut algorithm, which is used to compute charge forces between nodes.",
	      "oneOf": [{"type": "number"}, {"$ref": "#/refs/signal"}],
	      "default": 0.8
	    },
	    "gravity": {
	      "description": "The strength of the pseudo-gravity force that pulls nodes towards the center of the layout area.",
	      "oneOf": [{"type": "number"}, {"$ref": "#/refs/signal"}],
	      "default": 0.1
	    },
	    "alpha": {
	      "description": "A \"temperature\" parameter that determines how much node positions are adjusted at each step.",
	      "oneOf": [{"type": "number"}, {"$ref": "#/refs/signal"}],
	      "default": 0.1
	    },
	    "interactive": {
	      "description": "Enables an interactive force-directed layout.",
	      "oneOf": [{"type": "boolean"}, {"$ref": "#/refs/signal"}],
	      "default": false
	    },
	    "active": {
	      "description": "A signal representing the active node.",
	      "$ref": "#/refs/signal"
	    },
	    "fixed": {
	      "description": "The name of a datasource containing the IDs of nodes with fixed positions.",
	      "type": "string"
	    },
	    "output": {
	      "type": "object",
	      "description": "Rename the output data fields",
	      "properties": {
	        "x": {"type": "string", "default": "layout_x"},
	        "y": {"type": "string", "default": "layout_y"}
	      },
	      "additionalProperties": false
	    }
	  },
	  "additionalProperties": false,
	  "required": ["type", "links"]
	};


/***/ },
/* 116 */
/***/ function(module, exports) {

	module.exports = {
	  size:   [{signal: 'width'}, {signal: 'height'}],
	  mid:    [{expr: 'width/2'}, {expr: 'height/2'}],
	  extent: [
	    {expr: '[-padding.left, -padding.top]'},
	    {expr: '[width+padding.right, height+padding.bottom]'}
	  ]
	};

/***/ },
/* 117 */
/***/ function(module, exports, __webpack_require__) {

	var df = __webpack_require__(4),
	    Tuple = df.Tuple,
	    log = __webpack_require__(8),
	    Transform = __webpack_require__(104);
	
	function Formula(graph) {
	  Transform.prototype.init.call(this, graph);
	  Transform.addParameters(this, {
	    field: {type: 'value'},
	    expr:  {type: 'expr'}
	  });
	
	  return this.mutates(true);
	}
	
	var prototype = (Formula.prototype = Object.create(Transform.prototype));
	prototype.constructor = Formula;
	
	prototype.transform = function(input) {
	  log.debug(input, ['formulating']);
	
	  var field = this.param('field'),
	      expr = this.param('expr');
	
	  function set(x) {
	    Tuple.set(x, field, expr(x));
	  }
	
	  input.add.forEach(set);
	
	  if (this.reevaluate(input)) {
	    input.mod.forEach(set);
	  }
	
	  input.fields[field] = 1;
	  return input;
	};
	
	module.exports = Formula;
	
	Formula.schema = {
	  "$schema": "http://json-schema.org/draft-04/schema#",
	  "title": "Formula transform",
	  "description": "Extends data elements with new values according to a calculation formula.",
	  "type": "object",
	  "properties": {
	    "type": {"enum": ["formula"]},
	    "field": {
	      "type": "string",
	      "description": "The property name in which to store the computed formula value."
	    },
	    "expr": {
	      "type": "string",
	      "description": "A string containing an expression (in JavaScript syntax) for the formula."
	    }
	  },
	  "required": ["type", "field", "expr"]
	};


/***/ },
/* 118 */
/***/ function(module, exports, __webpack_require__) {

	var d3 = __webpack_require__(2),
	    dl = __webpack_require__(12),
	    Tuple = __webpack_require__(4).Tuple,
	    log = __webpack_require__(8),
	    Transform = __webpack_require__(104);
	
	function Geo(graph) {
	  Transform.prototype.init.call(this, graph);
	  Transform.addParameters(this, Geo.Parameters);
	  Transform.addParameters(this, {
	    lon: {type: 'field'},
	    lat: {type: 'field'}
	  });
	
	  this._output = {
	    'x': 'layout_x',
	    'y': 'layout_y'
	  };
	  return this.mutates(true);
	}
	
	Geo.Parameters = {
	  projection: {type: 'value', default: 'mercator'},
	  center:     {type: 'array<value>'},
	  translate:  {type: 'array<value>', default: __webpack_require__(116).center},
	  rotate:     {type: 'array<value>'},
	  scale:      {type: 'value'},
	  precision:  {type: 'value'},
	  clipAngle:  {type: 'value'},
	  clipExtent: {type: 'value'}
	};
	
	Geo.d3Projection = function() {
	  var p = this.param('projection'),
	      param = Geo.Parameters,
	      proj, name, value;
	
	  if (p !== this._mode) {
	    this._mode = p;
	    this._projection = d3.geo[p]();
	  }
	  proj = this._projection;
	
	  for (name in param) {
	    if (name === 'projection' || !proj[name]) continue;
	    value = this.param(name);
	    if (value === undefined || (dl.isArray(value) && value.length === 0)) {
	      continue;
	    }
	    if (value !== proj[name]()) {
	      proj[name](value);
	    }
	  }
	
	  return proj;
	};
	
	var prototype = (Geo.prototype = Object.create(Transform.prototype));
	prototype.constructor = Geo;
	
	prototype.transform = function(input) {
	  log.debug(input, ['geo']);
	
	  var output = this._output,
	      lon = this.param('lon').accessor,
	      lat = this.param('lat').accessor,
	      proj = Geo.d3Projection.call(this);
	
	  function set(t) {
	    var ll = [lon(t), lat(t)];
	    var xy = proj(ll) || [null, null];
	    Tuple.set(t, output.x, xy[0]);
	    Tuple.set(t, output.y, xy[1]);
	  }
	
	  input.add.forEach(set);
	  if (this.reevaluate(input)) {
	    input.mod.forEach(set);
	    input.rem.forEach(set);
	  }
	
	  input.fields[output.x] = 1;
	  input.fields[output.y] = 1;
	  return input;
	};
	
	module.exports = Geo;
	
	Geo.baseSchema = {
	  "projection": {
	    "description": "The type of cartographic projection to use.",
	    "oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}],
	    "default": "mercator"
	  },
	  "center": {
	    "description": "The center of the projection.",
	    "oneOf": [
	      {
	        "type": "array",
	        "items": {"oneOf": [{"type": "number"}, {"$ref": "#/refs/signal"}]},
	        "minItems": 2,
	        "maxItems": 2
	      },
	      {"$ref": "#/refs/signal"}
	    ]
	  },
	  "translate": {
	    "description": "The translation of the projection.",
	    "oneOf": [
	      {
	        "type": "array",
	        "items": {"oneOf": [{"type": "number"}, {"$ref": "#/refs/signal"}]},
	        "minItems": 2,
	        "maxItems": 2
	      },
	      {"$ref": "#/refs/signal"}
	    ]
	  },
	  "rotate": {
	    "description": "The rotation of the projection.",
	    "oneOf": [{"type": "number"}, {"$ref": "#/refs/signal"}]
	  },
	  "scale": {
	    "description": "The scale of the projection.",
	    "oneOf": [{"type": "number"}, {"$ref": "#/refs/signal"}]
	  },
	  "precision": {
	    "description": "The desired precision of the projection.",
	    "oneOf": [{"type": "number"}, {"$ref": "#/refs/signal"}]
	  },
	  "clipAngle": {
	    "description": "The clip angle of the projection.",
	    "oneOf": [{"type": "number"}, {"$ref": "#/refs/signal"}]
	  },
	  "clipExtent": {
	    "description": "The clip extent of the projection.",
	    "oneOf": [{"type": "number"}, {"$ref": "#/refs/signal"}]
	  }
	};
	
	Geo.schema = {
	  "$schema": "http://json-schema.org/draft-04/schema#",
	  "title": "Geo transform",
	  "description": "Performs a cartographic projection. Given longitude and latitude values, sets corresponding x and y properties for a mark.",
	  "type": "object",
	  "properties": dl.extend({
	    "type": {"enum": ["geo"]},
	    "lon": {
	      "description": "The input longitude values.",
	      "oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}]
	    },
	    "lat": {
	      "description": "The input latitude values.",
	      "oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}]
	    },
	    "output": {
	      "type": "object",
	      "description": "Rename the output data fields",
	      "properties": {
	        "x": {"type": "string", "default": "layout_x"},
	        "y": {"type": "string", "default": "layout_y"}
	      },
	      "additionalProperties": false
	    }
	  }, Geo.baseSchema),
	  "required": ["type", "lon", "lat"],
	  "additionalProperties": false
	};
	


/***/ },
/* 119 */
/***/ function(module, exports, __webpack_require__) {

	var d3 = __webpack_require__(2),
	    dl = __webpack_require__(12),
	    Tuple = __webpack_require__(4).Tuple,
	    log = __webpack_require__(8),
	    Geo = __webpack_require__(118),
	    Transform = __webpack_require__(104);
	
	function GeoPath(graph) {
	  Transform.prototype.init.call(this, graph);
	  Transform.addParameters(this, Geo.Parameters);
	  Transform.addParameters(this, {
	    field: {type: 'field', default: null},
	  });
	
	  this._output = {
	    'path': 'layout_path'
	  };
	  return this.mutates(true);
	}
	
	var prototype = (GeoPath.prototype = Object.create(Transform.prototype));
	prototype.constructor = GeoPath;
	
	prototype.transform = function(input) {
	  log.debug(input, ['geopath']);
	
	  var output = this._output,
	      geojson = this.param('field').accessor || dl.identity,
	      proj = Geo.d3Projection.call(this),
	      path = d3.geo.path().projection(proj);
	
	  function set(t) {
	    Tuple.set(t, output.path, path(geojson(t)));
	  }
	
	  input.add.forEach(set);
	  if (this.reevaluate(input)) {
	    input.mod.forEach(set);
	    input.rem.forEach(set);
	  }
	
	  input.fields[output.path] = 1;
	  return input;
	};
	
	module.exports = GeoPath;
	
	GeoPath.schema = {
	  "$schema": "http://json-schema.org/draft-04/schema#",
	  "title": "GeoPath transform",
	  "description": "Creates paths for geographic regions, such as countries, states and counties.",
	  "type": "object",
	  "properties": dl.extend({
	    "type": {"enum": ["geopath"]},
	    "field": {
	      "description": "The data field containing GeoJSON Feature data.",
	      "oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}]
	    },
	    "output": {
	      "type": "object",
	      "description": "Rename the output data fields",
	      "properties": {
	        "path": {"type": "string", "default": "layout_path"}
	      },
	      "additionalProperties": false
	    }
	  }, Geo.baseSchema),
	  "required": ["type"],
	  "additionalProperties": false
	};

/***/ },
/* 120 */
/***/ function(module, exports, __webpack_require__) {

	var d3 = __webpack_require__(2),
	    dl = __webpack_require__(12),
	    Tuple = __webpack_require__(4).Tuple,
	    log = __webpack_require__(8),
	    Transform = __webpack_require__(104),
	    BatchTransform = __webpack_require__(108);
	
	function Hierarchy(graph) {
	  BatchTransform.prototype.init.call(this, graph);
	  Transform.addParameters(this, {
	    // hierarchy parameters
	    sort: {type: 'array<field>', default: null},
	    children: {type: 'field', default: 'children'},
	    parent: {type: 'field', default: 'parent'},
	    field: {type: 'value', default: null},
	    // layout parameters
	    mode: {type: 'value', default: 'tidy'}, // tidy, cluster, partition
	    size: {type: 'array<value>', default: __webpack_require__(116).size},
	    nodesize: {type: 'array<value>', default: null},
	    orient: {type: 'value', default: 'cartesian'}
	  });
	
	  this._mode = null;
	  this._output = {
	    'x':      'layout_x',
	    'y':      'layout_y',
	    'width':  'layout_width',
	    'height': 'layout_height',
	    'depth':  'layout_depth'
	  };
	  return this.mutates(true);
	}
	
	var PARTITION = 'partition';
	
	var SEPARATION = {
	  cartesian: function(a, b) { return (a.parent === b.parent ? 1 : 2); },
	  radial: function(a, b) { return (a.parent === b.parent ? 1 : 2) / a.depth; }
	};
	
	var prototype = (Hierarchy.prototype = Object.create(BatchTransform.prototype));
	prototype.constructor = Hierarchy;
	
	prototype.batchTransform = function(input, data) {
	  log.debug(input, ['hierarchy layout']);
	
	  // get variables
	  var layout = this._layout,
	      output = this._output,
	      mode   = this.param('mode'),
	      sort   = this.param('sort'),
	      nodesz = this.param('nodesize'),
	      parent = this.param('parent').accessor,
	      root = data.filter(function(d) { return parent(d) === null; })[0];
	
	  if (mode !== this._mode) {
	    this._mode = mode;
	    if (mode === 'tidy') mode = 'tree';
	    layout = (this._layout = d3.layout[mode]());
	  }
	
	  input.fields[output.x] = 1;
	  input.fields[output.y] = 1;
	  input.fields[output.depth] = 1;
	  if (mode === PARTITION) {
	    input.fields[output.width] = 1;
	    input.fields[output.height] = 1;
	    layout.value(this.param('field').accessor);
	  } else {
	    layout.separation(SEPARATION[this.param('orient')]);
	  }
	
	  if (nodesz.length && mode !== PARTITION) {
	    layout.nodeSize(nodesz);
	  } else {
	    layout.size(this.param('size'));
	  }
	
	  layout
	    .sort(sort.field.length ? dl.comparator(sort.field) : null)
	    .children(this.param('children').accessor)
	    .nodes(root);
	
	  // copy layout values to nodes
	  data.forEach(function(n) {
	    Tuple.set(n, output.x, n.x);
	    Tuple.set(n, output.y, n.y);
	    Tuple.set(n, output.depth, n.depth);
	    if (mode === PARTITION) {
	      Tuple.set(n, output.width, n.dx);
	      Tuple.set(n, output.height, n.dy);
	    }
	  });
	
	  // return changeset
	  return input;
	};
	
	module.exports = Hierarchy;
	
	Hierarchy.schema = {
	  "$schema": "http://json-schema.org/draft-04/schema#",
	  "title": "Hierarchy transform",
	  "type": "object",
	  "properties": {
	    "type": {"enum": ["hierarchy"]},
	    "sort": {
	      "description": "A list of fields to use as sort criteria for sibling nodes.",
	      "oneOf": [
	        {
	          "type": "array",
	          "items": {"oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}]}
	        },
	        {"$ref": "#/refs/signal"}
	      ]
	    },
	    "children": {
	      "description": "The data field for the children node array",
	      "oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}],
	      "default": "children"
	    },
	    "parent": {
	      "description": "The data field for the parent node",
	      "oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}],
	      "default": "parent"
	    },
	    "field": {
	      "description": "The value for the area of each leaf-level node for partition layouts.",
	      "oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}]
	    },
	    "mode": {
	      "description": "The layout algorithm mode to use.",
	      "oneOf": [
	        {"enum": ["tidy", "cluster", "partition"]},
	        {"$ref": "#/refs/signal"}
	      ],
	      "default": "tidy"
	    },
	    "orient": {
	      "description": "The layout orientation to use.",
	      "oneOf": [
	        {"enum": ["cartesian", "radial"]},
	        {"$ref": "#/refs/signal"}
	      ],
	      "default": "cartesian"
	    },
	    "size": {
	      "description": "The dimensions of the tree layout",
	      "oneOf": [
	        {
	          "type": "array",
	          "items": {"oneOf": [{"type": "number"}, {"$ref": "#/refs/signal"}]},
	          "minItems": 2,
	          "maxItems": 2
	        },
	        {"$ref": "#/refs/signal"}
	      ],
	      "default": [500, 500]
	    },
	    "nodesize": {
	      "description": "Sets a fixed x,y size for each node (overrides the size parameter)",
	      "oneOf": [
	        {
	          "type": "array",
	          "items": {"oneOf": [{"type": "number"}, {"$ref": "#/refs/signal"}]},
	          "minItems": 2,
	          "maxItems": 2
	        },
	        {"$ref": "#/refs/signal"}
	      ],
	      "default": null
	    },
	    "output": {
	      "type": "object",
	      "description": "Rename the output data fields",
	      "properties": {
	        "x": {"type": "string", "default": "layout_x"},
	        "y": {"type": "string", "default": "layout_y"},
	        "width": {"type": "string", "default": "layout_width"},
	        "height": {"type": "string", "default": "layout_height"},
	        "depth": {"type": "string", "default": "layout_depth"}
	      },
	      "additionalProperties": false
	    }
	  },
	  "additionalProperties": false,
	  "required": ["type"]
	};


/***/ },
/* 121 */
/***/ function(module, exports, __webpack_require__) {

	var dl = __webpack_require__(12),
	    log = __webpack_require__(8),
	    Tuple = __webpack_require__(4).Tuple,
	    Transform = __webpack_require__(104),
	    BatchTransform = __webpack_require__(108);
	
	function Impute(graph) {
	  BatchTransform.prototype.init.call(this, graph);
	  Transform.addParameters(this, {
	    groupby: {type: 'array<field>'},
	    orderby: {type: 'array<field>'},
	    field:   {type: 'field'},
	    method:  {type: 'value', default: 'value'},
	    value:   {type: 'value', default: 0}
	  });
	
	  return this.router(true).produces(true);
	}
	
	var prototype = (Impute.prototype = Object.create(BatchTransform.prototype));
	prototype.constructor = Impute;
	
	prototype.batchTransform = function(input, data) {
	  log.debug(input, ['imputing']);
	
	  var groupby = this.param('groupby'),
	      orderby = this.param('orderby'),
	      method = this.param('method'),
	      value = this.param('value'),
	      field = this.param('field'),
	      get = field.accessor,
	      name = field.field,
	      prev = this._imputed || [], curr = [],
	      groups = partition(data, groupby.accessor, orderby.accessor),
	      domain = groups.domain,
	      group, i, j, n, m, t;
	
	  function getval(x) {
	    return x == null ? null : get(x);
	  }
	
	  for (j=0, m=groups.length; j<m; ++j) {
	    group = groups[j];
	
	    // determine imputation value
	    if (method !== 'value') {
	      value = dl[method](group, getval);
	    }
	
	    // add tuples for missing values
	    for (i=0, n=group.length; i<n; ++i) {
	      if (group[i] == null) {
	        t = tuple(groupby.field, group.values, orderby.field, domain[i]);
	        t[name] = value;
	        curr.push(t);
	      }
	    }
	  }
	
	  // update changeset with imputed tuples
	  for (i=0, n=curr.length; i<n; ++i) {
	    input.add.push(curr[i]);
	  }
	  for (i=0, n=prev.length; i<n; ++i) {
	    input.rem.push(prev[i]);
	  }
	  this._imputed = curr;
	
	  return input;
	};
	
	function tuple(gb, gv, ob, ov) {
	  var t = {_imputed: true}, i;
	  for (i=0; i<gv.length; ++i) t[gb[i]] = gv[i];
	  for (i=0; i<ov.length; ++i) t[ob[i]] = ov[i];
	  return Tuple.ingest(t);
	}
	
	function partition(data, groupby, orderby) {
	  var groups = [],
	      get = function(f) { return f(x); },
	      val = function(d) { return (x=d, orderby.map(get)); },
	      map, i, x, k, g, domain, lut, N;
	
	  domain = groups.domain = dl.unique(data, val);
	  N = domain.length;
	  lut = domain.reduce(function(m, d, i) {
	    return (m[d] = {value:d, index:i}, m);
	  }, {});
	
	  // partition data points into groups
	  for (map={}, i=0; i<data.length; ++i) {
	    x = data[i];
	    k = groupby == null ? [] : groupby.map(get);
	    g = map[k] || (groups.push(map[k] = Array(N)), map[k].values = k, map[k]);
	    g[lut[val(x)].index] = x;
	  }
	
	  return groups;
	}
	
	module.exports = Impute;
	
	Impute.schema = {
	  "$schema": "http://json-schema.org/draft-04/schema#",
	  "title": "Impute transform",
	  "description": "Performs imputation of missing values.",
	  "type": "object",
	  "properties": {
	    "type": {"enum": ["impute"]},
	    "method": {
	      "description": "The imputation method to use.",
	      "oneOf": [
	        {"enum": ["value", "mean", "median", "min", "max"]},
	        {"$ref": "#/refs/signal"}
	      ],
	      "default": "value"
	    },
	    "value": {
	      "description": "The value to use for missing data if the method is 'value'.",
	      "oneOf": [
	        {"type": "number"},
	        {"type": "string"},
	        {"type": "boolean"},
	        {"type": "null"},
	        {"$ref": "#/refs/signal"}
	      ],
	      "default": 0
	    },
	    "field": {
	      "description": "The data field to impute.",
	      "oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}]
	    },
	    "groupby": {
	      "description": "A list of fields to group the data into series.",
	      "oneOf": [
	        {
	          "type": "array",
	          "items": {"oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}]}
	        },
	        {"$ref": "#/refs/signal"}
	      ],
	    },
	    "orderby": {
	      "description": "A list of fields to determine ordering within series.",
	      "oneOf": [
	        {
	          "type": "array",
	          "items": {"oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}]}
	        },
	        {"$ref": "#/refs/signal"}
	      ],
	    }
	  },
	  "additionalProperties": false,
	  "required": ["type", "groupby", "orderby", "field"]
	};


/***/ },
/* 122 */
/***/ function(module, exports, __webpack_require__) {

	var Tuple = __webpack_require__(4).Tuple,
	    log = __webpack_require__(8),
	    Transform = __webpack_require__(104);
	
	function Lookup(graph) {
	  Transform.prototype.init.call(this, graph);
	  Transform.addParameters(this, {
	    on:      {type: 'data'},
	    onKey:   {type: 'field', default: null},
	    as:      {type: 'array<value>'},
	    keys:    {type: 'array<field>', default: ['data']},
	    default: {type: 'value'}
	  });
	
	  return this.mutates(true);
	}
	
	var prototype = (Lookup.prototype = Object.create(Transform.prototype));
	prototype.constructor = Lookup;
	
	prototype.transform = function(input, reset) {
	  log.debug(input, ['lookup']);
	
	  var on = this.param('on'),
	      onLast = on.source.last(),
	      onData = on.source.values(),
	      onKey = this.param('onKey'),
	      onF = onKey.field,
	      keys = this.param('keys'),
	      get = keys.accessor,
	      as = this.param('as'),
	      defaultValue = this.param('default'),
	      lut = this._lut,
	      i, v;
	
	  // build lookup table on init, withKey modified, or tuple add/rem
	  if (lut == null || this._on !== onF || onF && onLast.fields[onF] ||
	      onLast.add.length || onLast.rem.length)
	  {
	    if (onF) { // build hash from withKey field
	      onKey = onKey.accessor;
	      for (lut={}, i=0; i<onData.length; ++i) {
	        lut[onKey(v = onData[i])] = v;
	      }
	    } else { // otherwise, use index-based lookup
	      lut = onData;
	    }
	    this._lut = lut;
	    this._on = onF;
	    reset = true;
	  }
	
	  function set(t) {
	    for (var i=0; i<get.length; ++i) {
	      var v = lut[get[i](t)] || defaultValue;
	      Tuple.set(t, as[i], v);
	    }
	  }
	
	  input.add.forEach(set);
	  var run = keys.field.some(function(f) { return input.fields[f]; });
	  if (run || reset) {
	    input.mod.forEach(set);
	    input.rem.forEach(set);
	  }
	
	  as.forEach(function(k) { input.fields[k] = 1; });
	  return input;
	};
	
	module.exports = Lookup;
	
	Lookup.schema = {
	  "$schema": "http://json-schema.org/draft-04/schema#",
	  "title": "Lookup transform",
	  "description": "Extends a data set by looking up values in another data set.",
	  "type": "object",
	  "properties": {
	    "type": {"enum": ["lookup"]},
	    "on": {
	      "type": "string",
	      "description": "The name of the secondary data set on which to lookup values."
	    },
	    "onKey": {
	      "description": "The key field to lookup, or null for index-based lookup.",
	      "oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}]
	    },
	    "keys": {
	      "description": "One or more fields in the primary data set to match against the secondary data set.",
	      "type": "array",
	      "items": {"oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}]}
	    },
	    "as": {
	      "type": "array",
	      "description": "The names of the fields in which to store looked-up values.",
	      "items": {"type": "string"}
	    },
	    "default": {
	      // "type": "any",
	      "description": "The default value to use if a lookup match fails."
	    }
	  },
	  "required": ["type", "on", "as", "keys"],
	  "additionalProperties": false
	};


/***/ },
/* 123 */
/***/ function(module, exports, __webpack_require__) {

	var dl = __webpack_require__(12),
	    Tuple = __webpack_require__(4).Tuple,
	    log = __webpack_require__(8),
	    Transform = __webpack_require__(104),
	    BatchTransform = __webpack_require__(108);
	
	function Pie(graph) {
	  BatchTransform.prototype.init.call(this, graph);
	  Transform.addParameters(this, {
	    field:      {type: 'field', default: null},
	    startAngle: {type: 'value', default: 0},
	    endAngle:   {type: 'value', default: 2 * Math.PI},
	    sort:       {type: 'value', default: false}
	  });
	
	  this._output = {
	    'start': 'layout_start',
	    'end':   'layout_end',
	    'mid':   'layout_mid'
	  };
	
	  return this.mutates(true);
	}
	
	var prototype = (Pie.prototype = Object.create(BatchTransform.prototype));
	prototype.constructor = Pie;
	
	function ones() { return 1; }
	
	prototype.batchTransform = function(input, data) {
	  log.debug(input, ['pie']);
	
	  var output = this._output,
	      field = this.param('field').accessor || ones,
	      start = this.param('startAngle'),
	      stop = this.param('endAngle'),
	      sort = this.param('sort');
	
	  var values = data.map(field),
	      a = start,
	      k = (stop - start) / dl.sum(values),
	      index = dl.range(data.length),
	      i, t, v;
	
	  if (sort) {
	    index.sort(function(a, b) {
	      return values[a] - values[b];
	    });
	  }
	
	  for (i=0; i<index.length; ++i) {
	    t = data[index[i]];
	    v = values[index[i]];
	    Tuple.set(t, output.start, a);
	    Tuple.set(t, output.mid, (a + 0.5 * v * k));
	    Tuple.set(t, output.end, (a += v * k));
	  }
	
	  input.fields[output.start] = 1;
	  input.fields[output.end] = 1;
	  input.fields[output.mid] = 1;
	  return input;
	};
	
	module.exports = Pie;
	
	Pie.schema = {
	  "$schema": "http://json-schema.org/draft-04/schema#",
	  "title": "Pie transform",
	  "description": "Computes a pie chart layout.",
	  "type": "object",
	  "properties": {
	    "type": {"enum": ["pie"]},
	    "field": {
	      "oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}],
	      "description": "The data values to encode as angular spans. " +
	        "If this property is omitted, all pie slices will have equal spans."
	    },
	    "startAngle": {
	      "oneOf": [
	        {
	          "type": "number",
	          "minimum": 0,
	          "maximum": 2 * Math.PI
	        },
	        {"$ref": "#/refs/signal"}
	      ],
	      "default": 0
	    },
	    "endAngle": {
	      "oneOf": [
	        {
	          "type": "number",
	          "minimum": 0,
	          "maximum": 2 * Math.PI
	        },
	        {"$ref": "#/refs/signal"}
	      ],
	      "default": 2 * Math.PI,
	    },
	    "sort": {
	      "description": " If true, will sort the data prior to computing angles.",
	      "oneOf": [{"type": "boolean"}, {"$ref": "#/refs/signal"}],
	      "default": false
	    },
	    "output": {
	      "type": "object",
	      "description": "Rename the output data fields",
	      "properties": {
	        "start": {"type": "string", "default": "layout_start"},
	        "end": {"type": "string", "default": "layout_end"},
	        "mid": {"type": "string", "default": "layout_mid"}
	      }
	    }
	  },
	  "required": ["type"]
	};


/***/ },
/* 124 */
/***/ function(module, exports, __webpack_require__) {

	var Tuple = __webpack_require__(4).Tuple,
	    log = __webpack_require__(8),
	    Transform = __webpack_require__(104),
	    BatchTransform = __webpack_require__(108);
	
	function Rank(graph) {
	  BatchTransform.prototype.init.call(this, graph);
	  Transform.addParameters(this, {
	    field: {type: 'field', default: null},
	    normalize: {type: 'value', default: false}
	  });
	
	  this._output = {
	    'rank': 'rank'
	  };
	
	  return this.mutates(true);
	}
	
	var prototype = (Rank.prototype = Object.create(BatchTransform.prototype));
	prototype.constructor = Rank;
	
	prototype.batchTransform = function(input, data) {
	  log.debug(input, ['rank']);
	
	  var rank  = this._output.rank,
	      norm  = this.param('normalize'),
	      field = this.param('field').accessor,
	      keys = {}, 
	      i, len = data.length, klen, d, f;
	
	  // If we have a field accessor, first compile distinct keys.
	  if (field) {
	    for (i=0, klen=0; i<len; ++i) {
	      d = data[i];
	      keys[f=field(d)] = keys[f] || (keys[f] = ++klen);
	    }
	  }
	
	  // Assign ranks to all tuples.
	  for (i=0; i<len && (d=data[i]); ++i) {
	    if (field && (f=field(d))) {
	      Tuple.set(d, rank, norm ? keys[f] / klen : keys[f]);
	    } else {
	      Tuple.set(d, rank, norm ? (i+1) / len : (i+1));
	    }
	  }
	
	  input.fields[rank] = 1;
	  return input;
	};
	
	module.exports = Rank;
	
	Rank.schema = {
	  "$schema": "http://json-schema.org/draft-04/schema#",
	  "title": "Rank transform",
	  "description": "Computes ascending rank scores for data tuples.",
	  "type": "object",
	  "properties": {
	    "type": {"enum": ["rank"]},
	    "field": {
	      "oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}],
	      "description": "A key field to used to rank tuples. " +
	        "If undefined, tuples will be ranked in their observed order."
	    },
	    "normalize": {
	      "description": "If true, values of the output field will lie in the range [0, 1].",
	      "oneOf": [{"type": "boolean"}, {"$ref": "#/refs/signal"}],
	      "default": false
	    },
	    "output": {
	      "type": "object",
	      "description": "Rename the output data fields",
	      "properties": {
	        "rank": {"type": "string", "default": "rank"}
	      },
	      "additionalProperties": false
	    }
	  },
	  "additionalProperties": false,
	  "required": ["type"]
	};


/***/ },
/* 125 */
/***/ function(module, exports, __webpack_require__) {

	var dl = __webpack_require__(12),
	    log  = __webpack_require__(8),
	    Transform = __webpack_require__(104);
	
	function Sort(graph) {
	  Transform.prototype.init.call(this, graph);
	  Transform.addParameters(this, {by: {type: 'array<field>'} });
	  this.router(true);
	}
	
	var prototype = (Sort.prototype = Object.create(Transform.prototype));
	prototype.constructor = Sort;
	
	prototype.transform = function(input) {
	  log.debug(input, ['sorting']);
	
	  if (input.add.length || input.mod.length || input.rem.length) {
	    input.sort = dl.comparator(this.param('by').field);
	  }
	  return input;
	};
	
	module.exports = Sort;
	
	Sort.schema = {
	  "$schema": "http://json-schema.org/draft-04/schema#",
	  "title": "Sort transform",
	  "description": "Sorts the values of a data set.",
	  "type": "object",
	  "properties": {
	    "type": {"enum": ["sort"]},
	    "by": {
	      "oneOf": [
	        {"type": "string"},
	        {"type": "array", "items": {"type": "string"}}
	      ],
	      "description": "A list of fields to use as sort criteria."
	    }
	  },
	  "required": ["type", "by"]
	};


/***/ },
/* 126 */
/***/ function(module, exports, __webpack_require__) {

	var dl = __webpack_require__(12),
	    Tuple = __webpack_require__(4).Tuple,
	    log = __webpack_require__(8),
	    Transform = __webpack_require__(104),
	    BatchTransform = __webpack_require__(108);
	
	function Stack(graph) {
	  BatchTransform.prototype.init.call(this, graph);
	  Transform.addParameters(this, {
	    groupby: {type: 'array<field>'},
	    sortby: {type: 'array<field>'},
	    field: {type: 'field'},
	    offset: {type: 'value', default: 'zero'}
	  });
	
	  this._output = {
	    'start': 'layout_start',
	    'end':   'layout_end',
	    'mid':   'layout_mid'
	  };
	  return this.mutates(true);
	}
	
	var prototype = (Stack.prototype = Object.create(BatchTransform.prototype));
	prototype.constructor = Stack;
	
	prototype.batchTransform = function(input, data) {
	  log.debug(input, ['stacking']);
	
	  var groupby = this.param('groupby').accessor,
	      sortby = dl.comparator(this.param('sortby').field),
	      field = this.param('field').accessor,
	      offset = this.param('offset'),
	      output = this._output;
	
	  // partition, sum, and sort the stack groups
	  var groups = partition(data, groupby, sortby, field);
	
	  // compute stack layouts per group
	  for (var i=0, max=groups.max; i<groups.length; ++i) {
	    var group = groups[i],
	        sum = group.sum,
	        off = offset==='center' ? (max - sum)/2 : 0,
	        scale = offset==='normalize' ? (1/sum) : 1,
	        j, x, a, b = off, v = 0;
	
	    // set stack coordinates for each datum in group
	    for (j=0; j<group.length; ++j) {
	      x = group[j];
	      a = b; // use previous value for start point
	      v += field(x);
	      b = scale * v + off; // compute end point
	      Tuple.set(x, output.start, a);
	      Tuple.set(x, output.end, b);
	      Tuple.set(x, output.mid, 0.5 * (a + b));
	    }
	  }
	
	  input.fields[output.start] = 1;
	  input.fields[output.end] = 1;
	  input.fields[output.mid] = 1;
	  return input;
	};
	
	function partition(data, groupby, sortby, field) {
	  var groups = [],
	      get = function(f) { return f(x); },
	      map, i, x, k, g, s, max;
	
	  // partition data points into stack groups
	  if (groupby == null) {
	    groups.push(data.slice());
	  } else {
	    for (map={}, i=0; i<data.length; ++i) {
	      x = data[i];
	      k = groupby.map(get);
	      g = map[k] || (groups.push(map[k] = []), map[k]);
	      g.push(x);
	    }
	  }
	
	  // compute sums of groups, sort groups as needed
	  for (k=0, max=0; k<groups.length; ++k) {
	    g = groups[k];
	    for (i=0, s=0; i<g.length; ++i) {
	      s += field(g[i]);
	    }
	    g.sum = s;
	    if (s > max) max = s;
	    if (sortby != null) g.sort(sortby);
	  }
	  groups.max = max;
	
	  return groups;
	}
	
	module.exports = Stack;
	
	Stack.schema = {
	  "$schema": "http://json-schema.org/draft-04/schema#",
	  "title": "Stack transform",
	  "description": "Computes layout values for stacked graphs, as in stacked bar charts or stream graphs.",
	  "type": "object",
	  "properties": {
	    "type": {"enum": ["stack"]},
	    "groupby": {
	      "description": "A list of fields to split the data into groups (stacks).",
	      "oneOf": [
	        {
	          "type": "array",
	          "items": {"oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}]}
	        },
	        {"$ref": "#/refs/signal"}
	      ],
	    },
	    "sortby": {
	      "description": "A list of fields to determine the sort order of stacks.",
	      "oneOf": [
	        {
	          "type": "array",
	          "items": {"oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}]}
	        },
	        {"$ref": "#/refs/signal"}
	      ],
	    },
	    "field": {
	      "description": "The data field that determines the thickness/height of stacks.",
	      "oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}]
	    },
	    "offset": {
	      "description": "The baseline offset",
	      "oneOf": [{"enum": ["zero", "center", "normalize"]}, {"$ref": "#/refs/signal"}],
	      "default": "zero"
	    },
	    "output": {
	      "type": "object",
	      "description": "Rename the output data fields",
	      "properties": {
	        "start": {"type": "string", "default": "layout_start"},
	        "end": {"type": "string", "default": "layout_end"},
	        "mid": {"type": "string", "default": "layout_mid"}
	      },
	      "additionalProperties": false
	    }
	  },
	  "additionalProperties": false,
	  "required": ["type", "groupby", "field"]
	};


/***/ },
/* 127 */
/***/ function(module, exports, __webpack_require__) {

	var dl = __webpack_require__(12),
	    Tuple = __webpack_require__(4).Tuple,
	    log = __webpack_require__(8),
	    Transform = __webpack_require__(104),
	    BatchTransform = __webpack_require__(108);
	
	function Treeify(graph) {
	  BatchTransform.prototype.init.call(this, graph);
	  Transform.addParameters(this, {
	    groupby: {type: 'array<field>'}
	  });
	
	  this._output = {
	    'children': 'children',
	    'parent':   'parent'
	  };
	  return this.router(true).produces(true);
	}
	
	var prototype = (Treeify.prototype = Object.create(BatchTransform.prototype));
	prototype.constructor = Treeify;
	
	prototype.batchTransform = function(input, data) {
	  log.debug(input, ['treeifying']);
	
	  var fields = this.param('groupby').field,
	      childField = this._output.children,
	      parentField = this._output.parent,
	      summary = [{name:'*', ops: ['values'], as: [childField]}],
	      aggrs = fields.map(function(f) {
	        return dl.groupby(f).summarize(summary);
	      }),
	      prev = this._internal || [], curr = [], i, n;
	
	  function level(index, node, values) {
	    var vals = aggrs[index].execute(values);
	
	    node[childField] = vals;
	    vals.forEach(function(n) {
	      n[parentField] = node;
	      curr.push(Tuple.ingest(n));
	      if (index+1 < fields.length) level(index+1, n, n[childField]);
	      else n[childField].forEach(function(c) { c[parentField] = n; });
	    });
	  }
	
	  var root = Tuple.ingest({});
	  root[parentField] = null;
	  curr.push(root);
	  level(0, root, data);
	
	  // update changeset with internal nodes
	  for (i=0, n=curr.length; i<n; ++i) {
	    input.add.push(curr[i]);
	  }
	  for (i=0, n=prev.length; i<n; ++i) {
	    input.rem.push(prev[i]);
	  }
	  this._internal = curr;
	
	  return input;
	};
	
	module.exports = Treeify;
	
	Treeify.schema = {
	  "$schema": "http://json-schema.org/draft-04/schema#",
	  "title": "Treeify transform",
	  "type": "object",
	  "properties": {
	    "type": {"enum": ["treeify"]},
	    "groupby": {
	      "description": "An ordered list of fields by which to group tuples into a tree.",
	      "oneOf": [
	        {
	          "type": "array",
	          "items": {"oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}]}
	        },
	        {"$ref": "#/refs/signal"}
	      ]
	    },
	    "output": {
	      "type": "object",
	      "description": "Rename the output data fields",
	      "properties": {
	        "children": {"type": "string", "default": "children"},
	        "parent": {"type": "string", "default": "parent"}
	      },
	      "additionalProperties": false
	    }
	  },
	  "additionalProperties": false,
	  "required": ["type", "groupby"]
	};


/***/ },
/* 128 */
/***/ function(module, exports, __webpack_require__) {

	var d3 = __webpack_require__(2),
	    dl = __webpack_require__(12),
	    Tuple = __webpack_require__(4).Tuple,
	    log = __webpack_require__(8),
	    Transform = __webpack_require__(104),
	    BatchTransform = __webpack_require__(108);
	
	var defaultRatio = 0.5 * (1 + Math.sqrt(5));
	
	function Treemap(graph) {
	  BatchTransform.prototype.init.call(this, graph);
	  Transform.addParameters(this, {
	    // hierarchy parameters
	    sort: {type: 'array<field>', default: ['-value']},
	    children: {type: 'field', default: 'children'},
	    parent: {type: 'field', default: 'parent'},
	    field: {type: 'field', default: 'value'},
	    // treemap parameters
	    size: {type: 'array<value>', default: __webpack_require__(116).size},
	    round: {type: 'value', default: true},
	    sticky: {type: 'value', default: false},
	    ratio: {type: 'value', default: defaultRatio},
	    padding: {type: 'value', default: null},
	    mode: {type: 'value', default: 'squarify'}
	  });
	
	  this._layout = d3.layout.treemap();
	
	  this._output = {
	    'x':      'layout_x',
	    'y':      'layout_y',
	    'width':  'layout_width',
	    'height': 'layout_height',
	    'depth':  'layout_depth',
	  };
	  return this.mutates(true);
	}
	
	var prototype = (Treemap.prototype = Object.create(BatchTransform.prototype));
	prototype.constructor = Treemap;
	
	prototype.batchTransform = function(input, data) {
	  log.debug(input, ['treemap']);
	
	  // get variables
	  var layout = this._layout,
	      output = this._output,
	      sticky = this.param('sticky'),
	      parent = this.param('parent').accessor,
	      root = data.filter(function(d) { return parent(d) === null; })[0];
	
	  // layout.sticky resets state _regardless_ of input value
	  // so, we perform out own check first
	  if (layout.sticky() !== sticky) { layout.sticky(sticky); }
	
	  // configure layout
	  layout
	    .sort(dl.comparator(this.param('sort').field))
	    .children(this.param('children').accessor)
	    .value(this.param('field').accessor)
	    .size(this.param('size'))
	    .round(this.param('round'))
	    .ratio(this.param('ratio'))
	    .padding(this.param('padding'))
	    .mode(this.param('mode'))
	    .nodes(root);
	
	  // copy layout values to nodes
	  data.forEach(function(n) {
	    Tuple.set(n, output.x, n.x);
	    Tuple.set(n, output.y, n.y);
	    Tuple.set(n, output.width, n.dx);
	    Tuple.set(n, output.height, n.dy);
	    Tuple.set(n, output.depth, n.depth);
	  });
	
	  // return changeset
	  input.fields[output.x] = 1;
	  input.fields[output.y] = 1;
	  input.fields[output.width] = 1;
	  input.fields[output.height] = 1;
	  input.fields[output.depth] = 1;
	  return input;
	};
	
	module.exports = Treemap;
	
	Treemap.schema = {
	  "$schema": "http://json-schema.org/draft-04/schema#",
	  "title": "Treemap transform",
	  "type": "object",
	  "properties": {
	    "type": {"enum": ["treemap"]},
	    "sort": {
	      "description": "A list of fields to use as sort criteria for sibling nodes.",
	      "oneOf": [
	        {
	          "type": "array",
	          "items": {"oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}]}
	        },
	        {"$ref": "#/refs/signal"}
	      ],
	      "default": ["-value"]
	    },
	    "children": {
	      "description": "The data field for the children node array",
	      "oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}],
	      "default": "children"
	    },
	    "parent": {
	      "description": "The data field for the parent node",
	      "oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}],
	      "default": "parent"
	    },
	    "field": {
	      "description": "The values to use to determine the area of each leaf-level treemap cell.",
	      "oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}]
	    },
	    "mode": {
	      "description": "The treemap layout algorithm to use.",
	      "oneOf": [
	        {"enum": ["squarify", "slice", "dice", "slice-dice"]},
	        {"$ref": "#/refs/signal"}
	      ],
	      "default": "squarify"
	    },
	    "size": {
	      "description": "The dimensions of the treemap layout",
	      "oneOf": [
	        {
	          "type": "array",
	          "items": {"oneOf": [{"type": "number"}, {"$ref": "#/refs/signal"}]},
	          "minItems": 2,
	          "maxItems": 2
	        },
	        {"$ref": "#/refs/signal"}
	      ],
	      "default": [500, 500]
	    },
	    "round": {
	      "description": "If true, treemap cell dimensions will be rounded to integer pixels.",
	      "oneOf": [{"type": "boolean"}, {"$ref": "#/refs/signal"}],
	      "default": true
	    },
	    "sticky": {
	      "description": "If true, repeated runs of the treemap will use cached partition boundaries.",
	      "oneOf": [{"type": "boolean"}, {"$ref": "#/refs/signal"}],
	      "default": false
	    },
	    "ratio": {
	      "description": "The target aspect ratio for the layout to optimize.",
	      "oneOf": [{"type": "number"}, {"$ref": "#/refs/signal"}],
	      "default": defaultRatio
	    },
	    "padding": {
	      "oneOf": [
	        {"type": "number"},
	        {
	          "type": "array",
	          "items": {"oneOf": [{"type": "number"}, {"$ref": "#/refs/signal"}]},
	          "minItems": 4,
	          "maxItems": 4
	        },
	        {"$ref": "#/refs/signal"}
	      ],
	      "description": "he padding (in pixels) to provide around internal nodes in the treemap."
	    },
	    "output": {
	      "type": "object",
	      "description": "Rename the output data fields",
	      "properties": {
	        "x": {"type": "string", "default": "layout_x"},
	        "y": {"type": "string", "default": "layout_y"},
	        "width": {"type": "string", "default": "layout_width"},
	        "height": {"type": "string", "default": "layout_height"},
	        "depth": {"type": "string", "default": "layout_depth"}
	      },
	      "additionalProperties": false
	    }
	  },
	  "additionalProperties": false,
	  "required": ["type"]
	};


/***/ },
/* 129 */
/***/ function(module, exports, __webpack_require__) {

	var d3 = __webpack_require__(2),
	    Tuple = __webpack_require__(9),
	    log = __webpack_require__(8),
	    Transform = __webpack_require__(104),
	    BatchTransform = __webpack_require__(108);
	
	function Voronoi(graph) {
	  BatchTransform.prototype.init.call(this, graph);
	  Transform.addParameters(this, {
	    clipExtent: {type: 'array<value>', default: __webpack_require__(116).extent},
	    x: {type: 'field', default: 'layout_x'},
	    y: {type: 'field', default: 'layout_y'}
	  });
	
	  this._layout = d3.geom.voronoi();
	  this._output = {'path': 'layout_path'};
	
	  return this.mutates(true);
	}
	
	var prototype = (Voronoi.prototype = Object.create(BatchTransform.prototype));
	prototype.constructor = Voronoi;
	
	prototype.batchTransform = function(input, data) {
	  log.debug(input, ['voronoi']);
	
	  // get variables
	  var pathname = this._output.path;
	
	  // configure layout
	  var polygons = this._layout
	    .clipExtent(this.param('clipExtent'))
	    .x(this.param('x').accessor)
	    .y(this.param('y').accessor)
	    (data);
	
	  // build and assign path strings
	  for (var i=0; i<data.length; ++i) {
	    Tuple.set(data[i], pathname, 'M' + polygons[i].join('L') + 'Z');
	  }
	
	  // return changeset
	  input.fields[pathname] = 1;
	  return input;
	};
	
	module.exports = Voronoi;
	
	Voronoi.schema = {
	  "$schema": "http://json-schema.org/draft-04/schema#",
	  "title": "Voronoi transform",
	  "type": "object",
	  "properties": {
	    "type": {"enum": ["voronoi"]},
	    "clipExtent": {
	      "description": "The min and max points at which to clip the voronoi diagram.",
	      "oneOf": [
	        {
	          "type": "array",
	          "items": {
	            "oneOf": [
	              {
	                "type": "array",
	                "items": {"oneOf": [{"type": "number"}, {"$ref": "#/refs/signal"}]},
	                "minItems": 2,
	                "maxItems": 2
	              },
	              {"$ref": "#/refs/signal"}
	            ]
	          },
	          "minItems": 2,
	          "maxItems": 2
	        },
	        {"$ref": "#/refs/signal"}
	      ],
	      "default": [[-1e5,-1e5],[1e5,1e5]]
	    },
	    "x": {
	      "description": "The input x coordinates.",
	      "oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}]
	    },
	    "y": {
	      "description": "The input y coordinates.",
	      "oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}]
	    },
	    "output": {
	      "type": "object",
	      "description": "Rename the output data fields",
	      "properties": {
	        "path": {"type": "string", "default": "layout_path"}
	      },
	      "additionalProperties": false
	    }
	  },
	  "additionalProperties": false,
	  "required": ["type"]
	};


/***/ },
/* 130 */
/***/ function(module, exports, __webpack_require__) {

	var dl = __webpack_require__(12),
	    d3 = __webpack_require__(2),
	    d3_cloud = __webpack_require__(131),
	    canvas = __webpack_require__(59).canvas,
	    Tuple = __webpack_require__(9),
	    log = __webpack_require__(8),
	    Transform = __webpack_require__(104),
	    BatchTransform = __webpack_require__(108);
	
	function Wordcloud(graph) {
	  BatchTransform.prototype.init.call(this, graph);
	  Transform.addParameters(this, {
	    size: {type: 'array<value>', default: __webpack_require__(116).size},
	    text: {type: 'field', default: 'data'},
	    rotate: {type: 'field|value', default: 0},
	    font: {type: 'field|value', default: {value: 'sans-serif'}},
	    fontSize: {type: 'field|value', default: 14},
	    fontStyle: {type: 'field|value', default: {value: 'normal'}},
	    fontWeight: {type: 'field|value', default: {value: 'normal'}},
	    fontScale: {type: 'array<value>', default: [10, 50]},
	    padding: {type: 'value', default: 1},
	    spiral: {type: 'value', default: 'archimedean'}
	  });
	
	  this._layout = d3_cloud().canvas(canvas.instance);
	
	  this._output = {
	    'x':          'layout_x',
	    'y':          'layout_y',
	    'font':       'layout_font',
	    'fontSize':   'layout_fontSize',
	    'fontStyle':  'layout_fontStyle',
	    'fontWeight': 'layout_fontWeight',
	    'rotate':     'layout_rotate',
	  };
	
	  return this.mutates(true);
	}
	
	var prototype = (Wordcloud.prototype = Object.create(BatchTransform.prototype));
	prototype.constructor = Wordcloud;
	
	function get(p) {
	  return (p && p.accessor) || p;
	}
	
	function wrap(tuple) {
	  var x = Object.create(tuple);
	  x._tuple = tuple;
	  return x;
	}
	
	prototype.batchTransform = function(input, data) {
	  log.debug(input, ['wordcloud']);
	
	  // get variables
	  var layout = this._layout,
	      output = this._output,
	      fontSize = this.param('fontSize'),
	      range = fontSize.accessor && this.param('fontScale'),
	      size, scale;
	  fontSize = fontSize.accessor || d3.functor(fontSize);
	
	  // create font size scaling function as needed
	  if (range.length) {
	    scale = d3.scale.sqrt()
	      .domain(dl.extent(data, size=fontSize))
	      .range(range);
	    fontSize = function(x) { return scale(size(x)); };
	  }
	
	  // configure layout
	  layout
	    .size(this.param('size'))
	    .text(get(this.param('text')))
	    .padding(this.param('padding'))
	    .spiral(this.param('spiral'))
	    .rotate(get(this.param('rotate')))
	    .font(get(this.param('font')))
	    .fontStyle(get(this.param('fontStyle')))
	    .fontWeight(get(this.param('fontWeight')))
	    .fontSize(fontSize)
	    .words(data.map(wrap)) // wrap to avoid tuple writes
	    .on('end', function(words) {
	      var size = layout.size(),
	          dx = size[0] >> 1,
	          dy = size[1] >> 1,
	          w, t, i, len;
	
	      for (i=0, len=words.length; i<len; ++i) {
	        w = words[i];
	        t = w._tuple;
	        Tuple.set(t, output.x, w.x + dx);
	        Tuple.set(t, output.y, w.y + dy);
	        Tuple.set(t, output.font, w.font);
	        Tuple.set(t, output.fontSize, w.size);
	        Tuple.set(t, output.fontStyle, w.style);
	        Tuple.set(t, output.fontWeight, w.weight);
	        Tuple.set(t, output.rotate, w.rotate);
	      }
	    })
	    .start();
	
	  // return changeset
	  for (var key in output) input.fields[output[key]] = 1;
	  return input;
	};
	
	module.exports = Wordcloud;
	
	var Parameter = __webpack_require__(105);
	Wordcloud.schema = {
	  "$schema": "http://json-schema.org/draft-04/schema#",
	  "title": "Wordcloud transform",
	  "type": "object",
	  "properties": {
	    "type": {"enum": ["wordcloud"]},
	    "size": {
	      "description": "The dimensions of the wordcloud layout",
	      "oneOf": [
	        {
	          "type": "array",
	          "items": {"oneOf": [{"type": "number"}, {"$ref": "#/refs/signal"}]},
	          "minItems": 2,
	          "maxItems": 2
	        },
	        {"$ref": "#/refs/signal"}
	      ],
	      "default": [900, 500]
	    },
	    "font": {
	      "description": "The font face to use for a word.",
	      "oneOf": [{"type": "string"}, Parameter.schema, {"$ref": "#/refs/signal"}],
	      "default": "sans-serif"
	    },
	    "fontStyle": {
	      "description": "The font style to use for a word.",
	      "oneOf": [{"type": "string"}, Parameter.schema, {"$ref": "#/refs/signal"}],
	      "default": "normal"
	    },
	    "fontWeight": {
	      "description": "The font weight to use for a word.",
	      "oneOf": [{"type": "string"}, Parameter.schema, {"$ref": "#/refs/signal"}],
	      "default": "normal"
	    },
	    "fontSize": {
	      "description": "The font size to use for a word.",
	      "oneOf": [{"type": "number"}, Parameter.schema, {"type": "string"}, {"$ref": "#/refs/signal"}],
	      "default": 14
	    },
	    "fontScale": {
	      "description": "The minimum and maximum scaled font sizes, or null to prevent scaling.",
	      "oneOf": [
	        { "type": "null" },
	        {
	          "type": "array",
	          "minItems": 2,
	          "maxItems": 2,
	          "items": {"oneOf": [{"type":"number"}, {"$ref": "#/refs/signal"}]}
	        }
	      ],
	      "default": [10, 50]
	    },
	    "rotate": {
	      "description": "The field or number to set the roration angle (in degrees).",
	      "oneOf": [
	        {"type": "number"}, {"type": "string"},
	        Parameter.schema, {"$ref": "#/refs/signal"}
	      ],
	      "default": 0
	    },
	    "text": {
	      "description": "The field containing the text to use for each word.",
	      "oneOf": [{"type": "string"}, Parameter.schema, {"$ref": "#/refs/signal"}],
	      "default": 'data'
	    },
	    "spiral": {
	      "description": "The type of spiral used for positioning words, either 'archimedean' or 'rectangular'.",
	      "oneOf": [{"enum": ["archimedean", "rectangular"]}, Parameter.schema, {"$ref": "#/refs/signal"}],
	      "default": "archimedean"
	    },
	    "padding": {
	      "description": "The padding around each word.",
	      "oneOf": [{"type": "number"}, Parameter.schema, {"$ref": "#/refs/signal"}],
	      "default": 1
	    },
	    "output": {
	      "type": "object",
	      "description": "Rename the output data fields",
	      "properties": {
	        "x": {"type": "string", "default": "layout_x"},
	        "y": {"type": "string", "default": "layout_y"},
	        "font": {"type": "string", "default": "layout_font"},
	        "fontSize": {"type": "string", "default": "layout_fontSize"},
	        "fontStyle": {"type": "string", "default": "layout_fontStyle"},
	        "fontWeight": {"type": "string", "default": "layout_fontWeight"},
	        "rotate": {"type": "string", "default": "layout_rotate"}
	      },
	      "additionalProperties": false
	    }
	  },
	  "additionalProperties": false,
	  "required": ["type"]
	};


/***/ },
/* 131 */
/***/ function(module, exports, __webpack_require__) {

	// Word cloud layout by Jason Davies, https://www.jasondavies.com/wordcloud/
	// Algorithm due to Jonathan Feinberg, http://static.mrfeinberg.com/bv_ch03.pdf
	
	var dispatch = __webpack_require__(132).dispatch;
	
	var cloudRadians = Math.PI / 180,
	    cw = 1 << 11 >> 5,
	    ch = 1 << 11;
	
	module.exports = function() {
	  var size = [256, 256],
	      text = cloudText,
	      font = cloudFont,
	      fontSize = cloudFontSize,
	      fontStyle = cloudFontNormal,
	      fontWeight = cloudFontNormal,
	      rotate = cloudRotate,
	      padding = cloudPadding,
	      spiral = archimedeanSpiral,
	      words = [],
	      timeInterval = Infinity,
	      event = dispatch("word", "end"),
	      timer = null,
	      random = Math.random,
	      cloud = {},
	      canvas = cloudCanvas;
	
	  cloud.canvas = function(_) {
	    return arguments.length ? (canvas = functor(_), cloud) : canvas;
	  };
	
	  cloud.start = function() {
	    var contextAndRatio = getContext(canvas()),
	        board = zeroArray((size[0] >> 5) * size[1]),
	        bounds = null,
	        n = words.length,
	        i = -1,
	        tags = [],
	        data = words.map(function(d, i) {
	          d.text = text.call(this, d, i);
	          d.font = font.call(this, d, i);
	          d.style = fontStyle.call(this, d, i);
	          d.weight = fontWeight.call(this, d, i);
	          d.rotate = rotate.call(this, d, i);
	          d.size = ~~fontSize.call(this, d, i);
	          d.padding = padding.call(this, d, i);
	          return d;
	        }).sort(function(a, b) { return b.size - a.size; });
	
	    if (timer) clearInterval(timer);
	    timer = setInterval(step, 0);
	    step();
	
	    return cloud;
	
	    function step() {
	      var start = Date.now();
	      while (Date.now() - start < timeInterval && ++i < n && timer) {
	        var d = data[i];
	        d.x = (size[0] * (random() + .5)) >> 1;
	        d.y = (size[1] * (random() + .5)) >> 1;
	        cloudSprite(contextAndRatio, d, data, i);
	        if (d.hasText && place(board, d, bounds)) {
	          tags.push(d);
	          event.word(d);
	          if (bounds) cloudBounds(bounds, d);
	          else bounds = [{x: d.x + d.x0, y: d.y + d.y0}, {x: d.x + d.x1, y: d.y + d.y1}];
	          // Temporary hack
	          d.x -= size[0] >> 1;
	          d.y -= size[1] >> 1;
	        }
	      }
	      if (i >= n) {
	        cloud.stop();
	        event.end(tags, bounds);
	      }
	    }
	  }
	
	  cloud.stop = function() {
	    if (timer) {
	      clearInterval(timer);
	      timer = null;
	    }
	    return cloud;
	  };
	
	  function getContext(canvas) {
	    canvas.width = canvas.height = 1;
	    var ratio = Math.sqrt(canvas.getContext("2d").getImageData(0, 0, 1, 1).data.length >> 2);
	    canvas.width = (cw << 5) / ratio;
	    canvas.height = ch / ratio;
	
	    var context = canvas.getContext("2d");
	    context.fillStyle = context.strokeStyle = "red";
	    context.textAlign = "center";
	
	    return {context: context, ratio: ratio};
	  }
	
	  function place(board, tag, bounds) {
	    var perimeter = [{x: 0, y: 0}, {x: size[0], y: size[1]}],
	        startX = tag.x,
	        startY = tag.y,
	        maxDelta = Math.sqrt(size[0] * size[0] + size[1] * size[1]),
	        s = spiral(size),
	        dt = random() < .5 ? 1 : -1,
	        t = -dt,
	        dxdy,
	        dx,
	        dy;
	
	    while (dxdy = s(t += dt)) {
	      dx = ~~dxdy[0];
	      dy = ~~dxdy[1];
	
	      if (Math.min(Math.abs(dx), Math.abs(dy)) >= maxDelta) break;
	
	      tag.x = startX + dx;
	      tag.y = startY + dy;
	
	      if (tag.x + tag.x0 < 0 || tag.y + tag.y0 < 0 ||
	          tag.x + tag.x1 > size[0] || tag.y + tag.y1 > size[1]) continue;
	      // TODO only check for collisions within current bounds.
	      if (!bounds || !cloudCollide(tag, board, size[0])) {
	        if (!bounds || collideRects(tag, bounds)) {
	          var sprite = tag.sprite,
	              w = tag.width >> 5,
	              sw = size[0] >> 5,
	              lx = tag.x - (w << 4),
	              sx = lx & 0x7f,
	              msx = 32 - sx,
	              h = tag.y1 - tag.y0,
	              x = (tag.y + tag.y0) * sw + (lx >> 5),
	              last;
	          for (var j = 0; j < h; j++) {
	            last = 0;
	            for (var i = 0; i <= w; i++) {
	              board[x + i] |= (last << msx) | (i < w ? (last = sprite[j * w + i]) >>> sx : 0);
	            }
	            x += sw;
	          }
	          delete tag.sprite;
	          return true;
	        }
	      }
	    }
	    return false;
	  }
	
	  cloud.timeInterval = function(_) {
	    return arguments.length ? (timeInterval = _ == null ? Infinity : _, cloud) : timeInterval;
	  };
	
	  cloud.words = function(_) {
	    return arguments.length ? (words = _, cloud) : words;
	  };
	
	  cloud.size = function(_) {
	    return arguments.length ? (size = [+_[0], +_[1]], cloud) : size;
	  };
	
	  cloud.font = function(_) {
	    return arguments.length ? (font = functor(_), cloud) : font;
	  };
	
	  cloud.fontStyle = function(_) {
	    return arguments.length ? (fontStyle = functor(_), cloud) : fontStyle;
	  };
	
	  cloud.fontWeight = function(_) {
	    return arguments.length ? (fontWeight = functor(_), cloud) : fontWeight;
	  };
	
	  cloud.rotate = function(_) {
	    return arguments.length ? (rotate = functor(_), cloud) : rotate;
	  };
	
	  cloud.text = function(_) {
	    return arguments.length ? (text = functor(_), cloud) : text;
	  };
	
	  cloud.spiral = function(_) {
	    return arguments.length ? (spiral = spirals[_] || _, cloud) : spiral;
	  };
	
	  cloud.fontSize = function(_) {
	    return arguments.length ? (fontSize = functor(_), cloud) : fontSize;
	  };
	
	  cloud.padding = function(_) {
	    return arguments.length ? (padding = functor(_), cloud) : padding;
	  };
	
	  cloud.random = function(_) {
	    return arguments.length ? (random = _, cloud) : random;
	  };
	
	  cloud.on = function() {
	    var value = event.on.apply(event, arguments);
	    return value === event ? cloud : value;
	  };
	
	  return cloud;
	};
	
	function cloudText(d) {
	  return d.text;
	}
	
	function cloudFont() {
	  return "serif";
	}
	
	function cloudFontNormal() {
	  return "normal";
	}
	
	function cloudFontSize(d) {
	  return Math.sqrt(d.value);
	}
	
	function cloudRotate() {
	  return (~~(Math.random() * 6) - 3) * 30;
	}
	
	function cloudPadding() {
	  return 1;
	}
	
	// Fetches a monochrome sprite bitmap for the specified text.
	// Load in batches for speed.
	function cloudSprite(contextAndRatio, d, data, di) {
	  if (d.sprite) return;
	  var c = contextAndRatio.context,
	      ratio = contextAndRatio.ratio;
	
	  c.clearRect(0, 0, (cw << 5) / ratio, ch / ratio);
	  var x = 0,
	      y = 0,
	      maxh = 0,
	      n = data.length;
	  --di;
	  while (++di < n) {
	    d = data[di];
	    c.save();
	    c.font = d.style + " " + d.weight + " " + ~~((d.size + 1) / ratio) + "px " + d.font;
	    var w = c.measureText(d.text + "m").width * ratio,
	        h = d.size << 1;
	    if (d.rotate) {
	      var sr = Math.sin(d.rotate * cloudRadians),
	          cr = Math.cos(d.rotate * cloudRadians),
	          wcr = w * cr,
	          wsr = w * sr,
	          hcr = h * cr,
	          hsr = h * sr;
	      w = (Math.max(Math.abs(wcr + hsr), Math.abs(wcr - hsr)) + 0x1f) >> 5 << 5;
	      h = ~~Math.max(Math.abs(wsr + hcr), Math.abs(wsr - hcr));
	    } else {
	      w = (w + 0x1f) >> 5 << 5;
	    }
	    if (h > maxh) maxh = h;
	    if (x + w >= (cw << 5)) {
	      x = 0;
	      y += maxh;
	      maxh = 0;
	    }
	    if (y + h >= ch) break;
	    c.translate((x + (w >> 1)) / ratio, (y + (h >> 1)) / ratio);
	    if (d.rotate) c.rotate(d.rotate * cloudRadians);
	    c.fillText(d.text, 0, 0);
	    if (d.padding) c.lineWidth = 2 * d.padding, c.strokeText(d.text, 0, 0);
	    c.restore();
	    d.width = w;
	    d.height = h;
	    d.xoff = x;
	    d.yoff = y;
	    d.x1 = w >> 1;
	    d.y1 = h >> 1;
	    d.x0 = -d.x1;
	    d.y0 = -d.y1;
	    d.hasText = true;
	    x += w;
	  }
	  var pixels = c.getImageData(0, 0, (cw << 5) / ratio, ch / ratio).data,
	      sprite = [];
	  while (--di >= 0) {
	    d = data[di];
	    if (!d.hasText) continue;
	    var w = d.width,
	        w32 = w >> 5,
	        h = d.y1 - d.y0;
	    // Zero the buffer
	    for (var i = 0; i < h * w32; i++) sprite[i] = 0;
	    x = d.xoff;
	    if (x == null) return;
	    y = d.yoff;
	    var seen = 0,
	        seenRow = -1;
	    for (var j = 0; j < h; j++) {
	      for (var i = 0; i < w; i++) {
	        var k = w32 * j + (i >> 5),
	            m = pixels[((y + j) * (cw << 5) + (x + i)) << 2] ? 1 << (31 - (i % 32)) : 0;
	        sprite[k] |= m;
	        seen |= m;
	      }
	      if (seen) seenRow = j;
	      else {
	        d.y0++;
	        h--;
	        j--;
	        y++;
	      }
	    }
	    d.y1 = d.y0 + seenRow;
	    d.sprite = sprite.slice(0, (d.y1 - d.y0) * w32);
	  }
	}
	
	// Use mask-based collision detection.
	function cloudCollide(tag, board, sw) {
	  sw >>= 5;
	  var sprite = tag.sprite,
	      w = tag.width >> 5,
	      lx = tag.x - (w << 4),
	      sx = lx & 0x7f,
	      msx = 32 - sx,
	      h = tag.y1 - tag.y0,
	      x = (tag.y + tag.y0) * sw + (lx >> 5),
	      last;
	  for (var j = 0; j < h; j++) {
	    last = 0;
	    for (var i = 0; i <= w; i++) {
	      if (((last << msx) | (i < w ? (last = sprite[j * w + i]) >>> sx : 0))
	          & board[x + i]) return true;
	    }
	    x += sw;
	  }
	  return false;
	}
	
	function cloudBounds(bounds, d) {
	  var b0 = bounds[0],
	      b1 = bounds[1];
	  if (d.x + d.x0 < b0.x) b0.x = d.x + d.x0;
	  if (d.y + d.y0 < b0.y) b0.y = d.y + d.y0;
	  if (d.x + d.x1 > b1.x) b1.x = d.x + d.x1;
	  if (d.y + d.y1 > b1.y) b1.y = d.y + d.y1;
	}
	
	function collideRects(a, b) {
	  return a.x + a.x1 > b[0].x && a.x + a.x0 < b[1].x && a.y + a.y1 > b[0].y && a.y + a.y0 < b[1].y;
	}
	
	function archimedeanSpiral(size) {
	  var e = size[0] / size[1];
	  return function(t) {
	    return [e * (t *= .1) * Math.cos(t), t * Math.sin(t)];
	  };
	}
	
	function rectangularSpiral(size) {
	  var dy = 4,
	      dx = dy * size[0] / size[1],
	      x = 0,
	      y = 0;
	  return function(t) {
	    var sign = t < 0 ? -1 : 1;
	    // See triangular numbers: T_n = n * (n + 1) / 2.
	    switch ((Math.sqrt(1 + 4 * sign * t) - sign) & 3) {
	      case 0:  x += dx; break;
	      case 1:  y += dy; break;
	      case 2:  x -= dx; break;
	      default: y -= dy; break;
	    }
	    return [x, y];
	  };
	}
	
	// TODO reuse arrays?
	function zeroArray(n) {
	  var a = [],
	      i = -1;
	  while (++i < n) a[i] = 0;
	  return a;
	}
	
	function cloudCanvas() {
	  return document.createElement("canvas");
	}
	
	function functor(d) {
	  return typeof d === "function" ? d : function() { return d; };
	}
	
	var spirals = {
	  archimedean: archimedeanSpiral,
	  rectangular: rectangularSpiral
	};


/***/ },
/* 132 */
/***/ function(module, exports, __webpack_require__) {

	(function (global, factory) {
	   true ? factory(exports) :
	  typeof define === 'function' && define.amd ? define(['exports'], factory) :
	  (factory((global.d3_dispatch = {})));
	}(this, function (exports) { 'use strict';
	
	  function dispatch() {
	    return new Dispatch(arguments);
	  }
	
	  function Dispatch(types) {
	    var i = -1,
	        n = types.length,
	        callbacksByType = {},
	        callbackByName = {},
	        type,
	        that = this;
	
	    that.on = function(type, callback) {
	      type = parseType(type);
	
	      // Return the current callback, if any.
	      if (arguments.length < 2) {
	        return (callback = callbackByName[type.name]) && callback.value;
	      }
	
	      // If a type was specified…
	      if (type.type) {
	        var callbacks = callbacksByType[type.type],
	            callback0 = callbackByName[type.name],
	            i;
	
	        // Remove the current callback, if any, using copy-on-remove.
	        if (callback0) {
	          callback0.value = null;
	          i = callbacks.indexOf(callback0);
	          callbacksByType[type.type] = callbacks = callbacks.slice(0, i).concat(callbacks.slice(i + 1));
	          delete callbackByName[type.name];
	        }
	
	        // Add the new callback, if any.
	        if (callback) {
	          callback = {value: callback};
	          callbackByName[type.name] = callback;
	          callbacks.push(callback);
	        }
	      }
	
	      // Otherwise, if a null callback was specified, remove all callbacks with the given name.
	      else if (callback == null) {
	        for (var otherType in callbacksByType) {
	          if (callback = callbackByName[otherType + type.name]) {
	            callback.value = null;
	            callbacks = callbacksByType[otherType];
	            i = callbacks.indexOf(callback);
	            callbacksByType[otherType] = callbacks.slice(0, i).concat(callbacks.slice(i + 1));
	            delete callbackByName[callback.name];
	          }
	        }
	      }
	
	      return that;
	    };
	
	    while (++i < n) {
	      type = types[i] + "";
	      if (!type || (type in that)) throw new Error("illegal or duplicate type: " + type);
	      callbacksByType[type] = [];
	      that[type] = applier(type);
	    }
	
	    function parseType(type) {
	      var i = (type += "").indexOf("."), name = type;
	      if (i >= 0) type = type.slice(0, i); else name += ".";
	      if (type && !callbacksByType.hasOwnProperty(type)) throw new Error("unknown type: " + type);
	      return {type: type, name: name};
	    }
	
	    function applier(type) {
	      return function() {
	        var callbacks = callbacksByType[type], // Defensive reference; copy-on-remove.
	            callbackValue,
	            i = -1,
	            n = callbacks.length;
	
	        while (++i < n) {
	          if (callbackValue = callbacks[i].value) {
	            callbackValue.apply(this, arguments);
	          }
	        }
	
	        return that;
	      };
	    }
	  }
	
	  dispatch.prototype = Dispatch.prototype;
	
	  var version = "0.2.6";
	
	  exports.version = version;
	  exports.dispatch = dispatch;
	
	}));

/***/ },
/* 133 */
/***/ function(module, exports, __webpack_require__) {

	var dl = __webpack_require__(12),
	    log = __webpack_require__(8),
	    df = __webpack_require__(4),
	    Node = df.Node, // jshint ignore:line
	    Tuple = df.Tuple,
	    Deps = df.Dependencies;
	
	var Types = {
	  INSERT: "insert",
	  REMOVE: "remove",
	  UPSERT: "upsert",
	  TOGGLE: "toggle",
	  CLEAR:  "clear"
	};
	
	var EMPTY = [];
	
	function filter(fields, value, src, dest) {
	  var splice = true, len = fields.length, i, j, f, v;
	  for (i = src.length - 1; i >= 0; --i) {
	    for (j=0; j<len; ++j) {
	      f = fields[j];
	      v = value && f(value) || value;
	      if (f(src[i]) !== v) {
	        splice = false;
	        break;
	      }
	    }
	
	    if (splice) dest.push.apply(dest, src.splice(i, 1));
	    splice = true;
	  }
	}
	
	function insert(input, datum, source) {
	  var t = Tuple.ingest(datum);
	  input.add.push(t);
	  source._data.push(t);
	}
	
	function parseModify(model, def, ds) {
	  var signal = def.signal ? dl.field(def.signal) : null,
	      signalName  = signal ? signal[0] : null,
	      predicate   = def.predicate ? model.predicate(def.predicate.name || def.predicate) : null,
	      exprTrigger = def.test ? model.expr(def.test) : null,
	      reeval  = (predicate === null && exprTrigger === null),
	      isClear = def.type === Types.CLEAR,
	      fields  = dl.array(def.field || 'data'),
	      getters = fields.map(dl.accessor),
	      setters = fields.map(dl.mutator),
	      node = new Node(model).router(isClear);
	
	  node.evaluate = function(input) {
	    var db, sg;
	
	    if (predicate !== null) {  // TODO: predicate args
	      db = model.values(Deps.DATA, predicate.data || EMPTY);
	      sg = model.values(Deps.SIGNALS, predicate.signals || EMPTY);
	      reeval = predicate.call(predicate, {}, db, sg, model._predicates);
	    }
	
	    if (exprTrigger !== null) {
	      sg = model.values(Deps.SIGNALS, exprTrigger.globals || EMPTY);
	      reeval = exprTrigger.fn();
	    }
	
	    log.debug(input, [def.type+"ing", reeval]);
	    if (!reeval || (!isClear && !input.signals[signalName])) return input;
	
	    var value = signal ? model.signalRef(def.signal) : null,
	        d = model.data(ds.name),
	        t = null, add = [], rem = [], up = 0, datum;
	
	    if (dl.isObject(value)) {
	      datum = value;
	      if (!def.field) {
	        fields = dl.keys(datum);
	        getters = fields.map(dl.accessor);
	        setters = fields.map(dl.mutator);
	      }
	    } else {
	      datum = {};
	      setters.forEach(function(f) { f(datum, value); });
	    }
	
	    // We have to modify ds._data so that subsequent pulses contain
	    // our dynamic data. W/o modifying ds._data, only the output
	    // collector will contain dynamic tuples.
	    if (def.type === Types.INSERT) {
	      insert(input, datum, d);
	    } else if (def.type === Types.REMOVE) {
	      filter(getters, value, input.mod, input.rem);
	      filter(getters, value, input.add, rem);
	      filter(getters, value, d._data, rem);
	    } else if (def.type === Types.UPSERT) {
	      input.mod.forEach(function(x) {
	        var every = getters.every(function(f) {
	          return f(x) === f(datum);
	        });
	
	        if (every) up = (dl.extend(x, datum), up+1);
	      });
	
	      if (up === 0) insert(input, datum, d);
	    } else if (def.type === Types.TOGGLE) {
	      // If tuples are in mod, remove them.
	      filter(getters, value, input.mod, rem);
	      input.rem.push.apply(input.rem, rem);
	
	      // If tuples are in add, they've been added to backing data source,
	      // but no downstream operators will have seen it yet.
	      filter(getters, value, input.add, add);
	
	      if (add.length || rem.length) {
	        d._data = d._data.filter(function(x) {
	          return rem.indexOf(x) < 0 && add.indexOf(x) < 0;
	        });
	      } else {
	        // If the tuples aren't seen in the changeset, add a new tuple.
	        // Note, tuple might be in input.rem, but we ignore this and just
	        // re-add a new tuple for simplicity.
	        input.add.push(t=Tuple.ingest(datum));
	        d._data.push(t);
	      }
	    } else if (def.type === Types.CLEAR) {
	      input.rem.push.apply(input.rem, input.mod.splice(0));
	      input.add.splice(0);
	      d._data.splice(0);
	    }
	
	    fields.forEach(function(f) { input.fields[f] = 1; });
	    return input;
	  };
	
	  if (signalName) node.dependency(Deps.SIGNALS, signalName);
	
	  if (predicate) {
	    node.dependency(Deps.DATA, predicate.data);
	    node.dependency(Deps.SIGNALS, predicate.signals);
	  }
	
	  if (exprTrigger) {
	    node.dependency(Deps.SIGNALS, exprTrigger.globals);
	    node.dependency(Deps.DATA,    exprTrigger.dataSources);
	  }
	
	  return node;
	}
	
	module.exports = parseModify;
	parseModify.schema = {
	  "defs": {
	    "modify": {
	      "type": "array",
	      "items": {
	        "type": "object",
	        "oneOf": [{
	          "properties": {
	            "type": {"enum": [
	              Types.INSERT, Types.REMOVE, Types.UPSERT, Types.TOGGLE
	            ]},
	            "signal": {"type": "string"},
	            "field": {"type": "string"}
	          },
	          "required": ["type", "signal"]
	        }, {
	          "properties": {
	            "type": {"enum": [Types.CLEAR]},
	            "predicate": {"type": "string"}  // TODO predicate args
	          },
	          "required": ["type", "predicate"]
	        },
	        {
	          "properties": {
	            "type": {"enum": [Types.CLEAR]},
	            "test": {"type": "string"}
	          },
	          "required": ["type", "test"]
	        }]
	      }
	    }
	  }
	};


/***/ },
/* 134 */
/***/ function(module, exports) {

	module.exports = (function() {
	  "use strict";
	
	  /*
	   * Generated by PEG.js 0.9.0.
	   *
	   * http://pegjs.org/
	   */
	
	  function peg$subclass(child, parent) {
	    function ctor() { this.constructor = child; }
	    ctor.prototype = parent.prototype;
	    child.prototype = new ctor();
	  }
	
	  function peg$SyntaxError(message, expected, found, location) {
	    this.message  = message;
	    this.expected = expected;
	    this.found    = found;
	    this.location = location;
	    this.name     = "SyntaxError";
	
	    if (typeof Error.captureStackTrace === "function") {
	      Error.captureStackTrace(this, peg$SyntaxError);
	    }
	  }
	
	  peg$subclass(peg$SyntaxError, Error);
	
	  function peg$parse(input) {
	    var options = arguments.length > 1 ? arguments[1] : {},
	        parser  = this,
	
	        peg$FAILED = {},
	
	        peg$startRuleFunctions = { start: peg$parsestart },
	        peg$startRuleFunction  = peg$parsestart,
	
	        peg$c0 = ",",
	        peg$c1 = { type: "literal", value: ",", description: "\",\"" },
	        peg$c2 = function(o, m) { return [o].concat(m); },
	        peg$c3 = function(o) { return [o]; },
	        peg$c4 = "[",
	        peg$c5 = { type: "literal", value: "[", description: "\"[\"" },
	        peg$c6 = "]",
	        peg$c7 = { type: "literal", value: "]", description: "\"]\"" },
	        peg$c8 = ">",
	        peg$c9 = { type: "literal", value: ">", description: "\">\"" },
	        peg$c10 = function(f1, f2, o) {
	            return {
	              start: f1, middle: o, end: f2,
	              str: '['+f1.str+', '+f2.str+'] > '+o.str};
	            },
	        peg$c11 = function(s, f) {
	            s.filters = f;
	            s.str += f.map(function(x) { return '['+x+']'; }).join('');
	            return s;
	          },
	        peg$c12 = function(s) { return s; },
	        peg$c13 = "(",
	        peg$c14 = { type: "literal", value: "(", description: "\"(\"" },
	        peg$c15 = ")",
	        peg$c16 = { type: "literal", value: ")", description: "\")\"" },
	        peg$c17 = function(m) {
	            return {
	              stream: m,
	              str: '('+m.map(function(m) { return m.str; }).join(', ')+')'
	            };
	          },
	        peg$c18 = "@",
	        peg$c19 = { type: "literal", value: "@", description: "\"@\"" },
	        peg$c20 = ":",
	        peg$c21 = { type: "literal", value: ":", description: "\":\"" },
	        peg$c22 = function(n, e) { return {event: e, name: n, str: '@'+n+':'+e}; },
	        peg$c23 = function(m, e) { return {event: e, mark: m, str: m+':'+e}; },
	        peg$c24 = function(t, e) { return {event: e, target: t, str: t+':'+e}; },
	        peg$c25 = function(e) { return {event: e, str: e}; },
	        peg$c26 = function(s) { return {signal: s, str: s}; },
	        peg$c27 = "rect",
	        peg$c28 = { type: "literal", value: "rect", description: "\"rect\"" },
	        peg$c29 = "symbol",
	        peg$c30 = { type: "literal", value: "symbol", description: "\"symbol\"" },
	        peg$c31 = "path",
	        peg$c32 = { type: "literal", value: "path", description: "\"path\"" },
	        peg$c33 = "arc",
	        peg$c34 = { type: "literal", value: "arc", description: "\"arc\"" },
	        peg$c35 = "area",
	        peg$c36 = { type: "literal", value: "area", description: "\"area\"" },
	        peg$c37 = "line",
	        peg$c38 = { type: "literal", value: "line", description: "\"line\"" },
	        peg$c39 = "rule",
	        peg$c40 = { type: "literal", value: "rule", description: "\"rule\"" },
	        peg$c41 = "image",
	        peg$c42 = { type: "literal", value: "image", description: "\"image\"" },
	        peg$c43 = "text",
	        peg$c44 = { type: "literal", value: "text", description: "\"text\"" },
	        peg$c45 = "group",
	        peg$c46 = { type: "literal", value: "group", description: "\"group\"" },
	        peg$c47 = "mousedown",
	        peg$c48 = { type: "literal", value: "mousedown", description: "\"mousedown\"" },
	        peg$c49 = "mouseup",
	        peg$c50 = { type: "literal", value: "mouseup", description: "\"mouseup\"" },
	        peg$c51 = "click",
	        peg$c52 = { type: "literal", value: "click", description: "\"click\"" },
	        peg$c53 = "dblclick",
	        peg$c54 = { type: "literal", value: "dblclick", description: "\"dblclick\"" },
	        peg$c55 = "wheel",
	        peg$c56 = { type: "literal", value: "wheel", description: "\"wheel\"" },
	        peg$c57 = "keydown",
	        peg$c58 = { type: "literal", value: "keydown", description: "\"keydown\"" },
	        peg$c59 = "keypress",
	        peg$c60 = { type: "literal", value: "keypress", description: "\"keypress\"" },
	        peg$c61 = "keyup",
	        peg$c62 = { type: "literal", value: "keyup", description: "\"keyup\"" },
	        peg$c63 = "mousewheel",
	        peg$c64 = { type: "literal", value: "mousewheel", description: "\"mousewheel\"" },
	        peg$c65 = "mousemove",
	        peg$c66 = { type: "literal", value: "mousemove", description: "\"mousemove\"" },
	        peg$c67 = "mouseout",
	        peg$c68 = { type: "literal", value: "mouseout", description: "\"mouseout\"" },
	        peg$c69 = "mouseover",
	        peg$c70 = { type: "literal", value: "mouseover", description: "\"mouseover\"" },
	        peg$c71 = "mouseenter",
	        peg$c72 = { type: "literal", value: "mouseenter", description: "\"mouseenter\"" },
	        peg$c73 = "touchstart",
	        peg$c74 = { type: "literal", value: "touchstart", description: "\"touchstart\"" },
	        peg$c75 = "touchmove",
	        peg$c76 = { type: "literal", value: "touchmove", description: "\"touchmove\"" },
	        peg$c77 = "touchend",
	        peg$c78 = { type: "literal", value: "touchend", description: "\"touchend\"" },
	        peg$c79 = "dragenter",
	        peg$c80 = { type: "literal", value: "dragenter", description: "\"dragenter\"" },
	        peg$c81 = "dragover",
	        peg$c82 = { type: "literal", value: "dragover", description: "\"dragover\"" },
	        peg$c83 = "dragleave",
	        peg$c84 = { type: "literal", value: "dragleave", description: "\"dragleave\"" },
	        peg$c85 = function(e) { return e; },
	        peg$c86 = /^[a-zA-Z0-9_\-]/,
	        peg$c87 = { type: "class", value: "[a-zA-Z0-9_-]", description: "[a-zA-Z0-9_-]" },
	        peg$c88 = function(n) { return n.join(''); },
	        peg$c89 = /^[a-zA-Z0-9\-_  #.>+~[\]=|\^$*]/,
	        peg$c90 = { type: "class", value: "[a-zA-Z0-9-_  #\\.\\>\\+~\\[\\]=|\\^\\$\\*]", description: "[a-zA-Z0-9-_  #\\.\\>\\+~\\[\\]=|\\^\\$\\*]" },
	        peg$c91 = function(c) { return c.join(''); },
	        peg$c92 = /^['"a-zA-Z0-9_().><=! \t-&|~]/,
	        peg$c93 = { type: "class", value: "['\"a-zA-Z0-9_\\(\\)\\.\\>\\<\\=\\! \\t-&|~]", description: "['\"a-zA-Z0-9_\\(\\)\\.\\>\\<\\=\\! \\t-&|~]" },
	        peg$c94 = function(v) { return v.join(''); },
	        peg$c95 = /^[ \t\r\n]/,
	        peg$c96 = { type: "class", value: "[ \\t\\r\\n]", description: "[ \\t\\r\\n]" },
	
	        peg$currPos          = 0,
	        peg$savedPos         = 0,
	        peg$posDetailsCache  = [{ line: 1, column: 1, seenCR: false }],
	        peg$maxFailPos       = 0,
	        peg$maxFailExpected  = [],
	        peg$silentFails      = 0,
	
	        peg$result;
	
	    if ("startRule" in options) {
	      if (!(options.startRule in peg$startRuleFunctions)) {
	        throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
	      }
	
	      peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
	    }
	
	    function text() {
	      return input.substring(peg$savedPos, peg$currPos);
	    }
	
	    function location() {
	      return peg$computeLocation(peg$savedPos, peg$currPos);
	    }
	
	    function expected(description) {
	      throw peg$buildException(
	        null,
	        [{ type: "other", description: description }],
	        input.substring(peg$savedPos, peg$currPos),
	        peg$computeLocation(peg$savedPos, peg$currPos)
	      );
	    }
	
	    function error(message) {
	      throw peg$buildException(
	        message,
	        null,
	        input.substring(peg$savedPos, peg$currPos),
	        peg$computeLocation(peg$savedPos, peg$currPos)
	      );
	    }
	
	    function peg$computePosDetails(pos) {
	      var details = peg$posDetailsCache[pos],
	          p, ch;
	
	      if (details) {
	        return details;
	      } else {
	        p = pos - 1;
	        while (!peg$posDetailsCache[p]) {
	          p--;
	        }
	
	        details = peg$posDetailsCache[p];
	        details = {
	          line:   details.line,
	          column: details.column,
	          seenCR: details.seenCR
	        };
	
	        while (p < pos) {
	          ch = input.charAt(p);
	          if (ch === "\n") {
	            if (!details.seenCR) { details.line++; }
	            details.column = 1;
	            details.seenCR = false;
	          } else if (ch === "\r" || ch === "\u2028" || ch === "\u2029") {
	            details.line++;
	            details.column = 1;
	            details.seenCR = true;
	          } else {
	            details.column++;
	            details.seenCR = false;
	          }
	
	          p++;
	        }
	
	        peg$posDetailsCache[pos] = details;
	        return details;
	      }
	    }
	
	    function peg$computeLocation(startPos, endPos) {
	      var startPosDetails = peg$computePosDetails(startPos),
	          endPosDetails   = peg$computePosDetails(endPos);
	
	      return {
	        start: {
	          offset: startPos,
	          line:   startPosDetails.line,
	          column: startPosDetails.column
	        },
	        end: {
	          offset: endPos,
	          line:   endPosDetails.line,
	          column: endPosDetails.column
	        }
	      };
	    }
	
	    function peg$fail(expected) {
	      if (peg$currPos < peg$maxFailPos) { return; }
	
	      if (peg$currPos > peg$maxFailPos) {
	        peg$maxFailPos = peg$currPos;
	        peg$maxFailExpected = [];
	      }
	
	      peg$maxFailExpected.push(expected);
	    }
	
	    function peg$buildException(message, expected, found, location) {
	      function cleanupExpected(expected) {
	        var i = 1;
	
	        expected.sort(function(a, b) {
	          if (a.description < b.description) {
	            return -1;
	          } else if (a.description > b.description) {
	            return 1;
	          } else {
	            return 0;
	          }
	        });
	
	        while (i < expected.length) {
	          if (expected[i - 1] === expected[i]) {
	            expected.splice(i, 1);
	          } else {
	            i++;
	          }
	        }
	      }
	
	      function buildMessage(expected, found) {
	        function stringEscape(s) {
	          function hex(ch) { return ch.charCodeAt(0).toString(16).toUpperCase(); }
	
	          return s
	            .replace(/\\/g,   '\\\\')
	            .replace(/"/g,    '\\"')
	            .replace(/\x08/g, '\\b')
	            .replace(/\t/g,   '\\t')
	            .replace(/\n/g,   '\\n')
	            .replace(/\f/g,   '\\f')
	            .replace(/\r/g,   '\\r')
	            .replace(/[\x00-\x07\x0B\x0E\x0F]/g, function(ch) { return '\\x0' + hex(ch); })
	            .replace(/[\x10-\x1F\x80-\xFF]/g,    function(ch) { return '\\x'  + hex(ch); })
	            .replace(/[\u0100-\u0FFF]/g,         function(ch) { return '\\u0' + hex(ch); })
	            .replace(/[\u1000-\uFFFF]/g,         function(ch) { return '\\u'  + hex(ch); });
	        }
	
	        var expectedDescs = new Array(expected.length),
	            expectedDesc, foundDesc, i;
	
	        for (i = 0; i < expected.length; i++) {
	          expectedDescs[i] = expected[i].description;
	        }
	
	        expectedDesc = expected.length > 1
	          ? expectedDescs.slice(0, -1).join(", ")
	              + " or "
	              + expectedDescs[expected.length - 1]
	          : expectedDescs[0];
	
	        foundDesc = found ? "\"" + stringEscape(found) + "\"" : "end of input";
	
	        return "Expected " + expectedDesc + " but " + foundDesc + " found.";
	      }
	
	      if (expected !== null) {
	        cleanupExpected(expected);
	      }
	
	      return new peg$SyntaxError(
	        message !== null ? message : buildMessage(expected, found),
	        expected,
	        found,
	        location
	      );
	    }
	
	    function peg$parsestart() {
	      var s0;
	
	      s0 = peg$parsemerged();
	
	      return s0;
	    }
	
	    function peg$parsemerged() {
	      var s0, s1, s2, s3, s4, s5;
	
	      s0 = peg$currPos;
	      s1 = peg$parseordered();
	      if (s1 !== peg$FAILED) {
	        s2 = peg$parsesep();
	        if (s2 !== peg$FAILED) {
	          if (input.charCodeAt(peg$currPos) === 44) {
	            s3 = peg$c0;
	            peg$currPos++;
	          } else {
	            s3 = peg$FAILED;
	            if (peg$silentFails === 0) { peg$fail(peg$c1); }
	          }
	          if (s3 !== peg$FAILED) {
	            s4 = peg$parsesep();
	            if (s4 !== peg$FAILED) {
	              s5 = peg$parsemerged();
	              if (s5 !== peg$FAILED) {
	                peg$savedPos = s0;
	                s1 = peg$c2(s1, s5);
	                s0 = s1;
	              } else {
	                peg$currPos = s0;
	                s0 = peg$FAILED;
	              }
	            } else {
	              peg$currPos = s0;
	              s0 = peg$FAILED;
	            }
	          } else {
	            peg$currPos = s0;
	            s0 = peg$FAILED;
	          }
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	      if (s0 === peg$FAILED) {
	        s0 = peg$currPos;
	        s1 = peg$parseordered();
	        if (s1 !== peg$FAILED) {
	          peg$savedPos = s0;
	          s1 = peg$c3(s1);
	        }
	        s0 = s1;
	      }
	
	      return s0;
	    }
	
	    function peg$parseordered() {
	      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13;
	
	      s0 = peg$currPos;
	      if (input.charCodeAt(peg$currPos) === 91) {
	        s1 = peg$c4;
	        peg$currPos++;
	      } else {
	        s1 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c5); }
	      }
	      if (s1 !== peg$FAILED) {
	        s2 = peg$parsesep();
	        if (s2 !== peg$FAILED) {
	          s3 = peg$parsefiltered();
	          if (s3 !== peg$FAILED) {
	            s4 = peg$parsesep();
	            if (s4 !== peg$FAILED) {
	              if (input.charCodeAt(peg$currPos) === 44) {
	                s5 = peg$c0;
	                peg$currPos++;
	              } else {
	                s5 = peg$FAILED;
	                if (peg$silentFails === 0) { peg$fail(peg$c1); }
	              }
	              if (s5 !== peg$FAILED) {
	                s6 = peg$parsesep();
	                if (s6 !== peg$FAILED) {
	                  s7 = peg$parsefiltered();
	                  if (s7 !== peg$FAILED) {
	                    s8 = peg$parsesep();
	                    if (s8 !== peg$FAILED) {
	                      if (input.charCodeAt(peg$currPos) === 93) {
	                        s9 = peg$c6;
	                        peg$currPos++;
	                      } else {
	                        s9 = peg$FAILED;
	                        if (peg$silentFails === 0) { peg$fail(peg$c7); }
	                      }
	                      if (s9 !== peg$FAILED) {
	                        s10 = peg$parsesep();
	                        if (s10 !== peg$FAILED) {
	                          if (input.charCodeAt(peg$currPos) === 62) {
	                            s11 = peg$c8;
	                            peg$currPos++;
	                          } else {
	                            s11 = peg$FAILED;
	                            if (peg$silentFails === 0) { peg$fail(peg$c9); }
	                          }
	                          if (s11 !== peg$FAILED) {
	                            s12 = peg$parsesep();
	                            if (s12 !== peg$FAILED) {
	                              s13 = peg$parseordered();
	                              if (s13 !== peg$FAILED) {
	                                peg$savedPos = s0;
	                                s1 = peg$c10(s3, s7, s13);
	                                s0 = s1;
	                              } else {
	                                peg$currPos = s0;
	                                s0 = peg$FAILED;
	                              }
	                            } else {
	                              peg$currPos = s0;
	                              s0 = peg$FAILED;
	                            }
	                          } else {
	                            peg$currPos = s0;
	                            s0 = peg$FAILED;
	                          }
	                        } else {
	                          peg$currPos = s0;
	                          s0 = peg$FAILED;
	                        }
	                      } else {
	                        peg$currPos = s0;
	                        s0 = peg$FAILED;
	                      }
	                    } else {
	                      peg$currPos = s0;
	                      s0 = peg$FAILED;
	                    }
	                  } else {
	                    peg$currPos = s0;
	                    s0 = peg$FAILED;
	                  }
	                } else {
	                  peg$currPos = s0;
	                  s0 = peg$FAILED;
	                }
	              } else {
	                peg$currPos = s0;
	                s0 = peg$FAILED;
	              }
	            } else {
	              peg$currPos = s0;
	              s0 = peg$FAILED;
	            }
	          } else {
	            peg$currPos = s0;
	            s0 = peg$FAILED;
	          }
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	      if (s0 === peg$FAILED) {
	        s0 = peg$parsefiltered();
	      }
	
	      return s0;
	    }
	
	    function peg$parsefiltered() {
	      var s0, s1, s2, s3;
	
	      s0 = peg$currPos;
	      s1 = peg$parsestream();
	      if (s1 !== peg$FAILED) {
	        s2 = [];
	        s3 = peg$parsefilter();
	        if (s3 !== peg$FAILED) {
	          while (s3 !== peg$FAILED) {
	            s2.push(s3);
	            s3 = peg$parsefilter();
	          }
	        } else {
	          s2 = peg$FAILED;
	        }
	        if (s2 !== peg$FAILED) {
	          peg$savedPos = s0;
	          s1 = peg$c11(s1, s2);
	          s0 = s1;
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	      if (s0 === peg$FAILED) {
	        s0 = peg$currPos;
	        s1 = peg$parsestream();
	        if (s1 !== peg$FAILED) {
	          peg$savedPos = s0;
	          s1 = peg$c12(s1);
	        }
	        s0 = s1;
	      }
	
	      return s0;
	    }
	
	    function peg$parsestream() {
	      var s0, s1, s2, s3, s4;
	
	      s0 = peg$currPos;
	      if (input.charCodeAt(peg$currPos) === 40) {
	        s1 = peg$c13;
	        peg$currPos++;
	      } else {
	        s1 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c14); }
	      }
	      if (s1 !== peg$FAILED) {
	        s2 = peg$parsemerged();
	        if (s2 !== peg$FAILED) {
	          if (input.charCodeAt(peg$currPos) === 41) {
	            s3 = peg$c15;
	            peg$currPos++;
	          } else {
	            s3 = peg$FAILED;
	            if (peg$silentFails === 0) { peg$fail(peg$c16); }
	          }
	          if (s3 !== peg$FAILED) {
	            peg$savedPos = s0;
	            s1 = peg$c17(s2);
	            s0 = s1;
	          } else {
	            peg$currPos = s0;
	            s0 = peg$FAILED;
	          }
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	      if (s0 === peg$FAILED) {
	        s0 = peg$currPos;
	        if (input.charCodeAt(peg$currPos) === 64) {
	          s1 = peg$c18;
	          peg$currPos++;
	        } else {
	          s1 = peg$FAILED;
	          if (peg$silentFails === 0) { peg$fail(peg$c19); }
	        }
	        if (s1 !== peg$FAILED) {
	          s2 = peg$parsename();
	          if (s2 !== peg$FAILED) {
	            if (input.charCodeAt(peg$currPos) === 58) {
	              s3 = peg$c20;
	              peg$currPos++;
	            } else {
	              s3 = peg$FAILED;
	              if (peg$silentFails === 0) { peg$fail(peg$c21); }
	            }
	            if (s3 !== peg$FAILED) {
	              s4 = peg$parseeventType();
	              if (s4 !== peg$FAILED) {
	                peg$savedPos = s0;
	                s1 = peg$c22(s2, s4);
	                s0 = s1;
	              } else {
	                peg$currPos = s0;
	                s0 = peg$FAILED;
	              }
	            } else {
	              peg$currPos = s0;
	              s0 = peg$FAILED;
	            }
	          } else {
	            peg$currPos = s0;
	            s0 = peg$FAILED;
	          }
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	        if (s0 === peg$FAILED) {
	          s0 = peg$currPos;
	          s1 = peg$parsemarkType();
	          if (s1 !== peg$FAILED) {
	            if (input.charCodeAt(peg$currPos) === 58) {
	              s2 = peg$c20;
	              peg$currPos++;
	            } else {
	              s2 = peg$FAILED;
	              if (peg$silentFails === 0) { peg$fail(peg$c21); }
	            }
	            if (s2 !== peg$FAILED) {
	              s3 = peg$parseeventType();
	              if (s3 !== peg$FAILED) {
	                peg$savedPos = s0;
	                s1 = peg$c23(s1, s3);
	                s0 = s1;
	              } else {
	                peg$currPos = s0;
	                s0 = peg$FAILED;
	              }
	            } else {
	              peg$currPos = s0;
	              s0 = peg$FAILED;
	            }
	          } else {
	            peg$currPos = s0;
	            s0 = peg$FAILED;
	          }
	          if (s0 === peg$FAILED) {
	            s0 = peg$currPos;
	            s1 = peg$parsecss();
	            if (s1 !== peg$FAILED) {
	              if (input.charCodeAt(peg$currPos) === 58) {
	                s2 = peg$c20;
	                peg$currPos++;
	              } else {
	                s2 = peg$FAILED;
	                if (peg$silentFails === 0) { peg$fail(peg$c21); }
	              }
	              if (s2 !== peg$FAILED) {
	                s3 = peg$parseeventType();
	                if (s3 !== peg$FAILED) {
	                  peg$savedPos = s0;
	                  s1 = peg$c24(s1, s3);
	                  s0 = s1;
	                } else {
	                  peg$currPos = s0;
	                  s0 = peg$FAILED;
	                }
	              } else {
	                peg$currPos = s0;
	                s0 = peg$FAILED;
	              }
	            } else {
	              peg$currPos = s0;
	              s0 = peg$FAILED;
	            }
	            if (s0 === peg$FAILED) {
	              s0 = peg$currPos;
	              s1 = peg$parseeventType();
	              if (s1 !== peg$FAILED) {
	                peg$savedPos = s0;
	                s1 = peg$c25(s1);
	              }
	              s0 = s1;
	              if (s0 === peg$FAILED) {
	                s0 = peg$currPos;
	                s1 = peg$parsename();
	                if (s1 !== peg$FAILED) {
	                  peg$savedPos = s0;
	                  s1 = peg$c26(s1);
	                }
	                s0 = s1;
	              }
	            }
	          }
	        }
	      }
	
	      return s0;
	    }
	
	    function peg$parsemarkType() {
	      var s0;
	
	      if (input.substr(peg$currPos, 4) === peg$c27) {
	        s0 = peg$c27;
	        peg$currPos += 4;
	      } else {
	        s0 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c28); }
	      }
	      if (s0 === peg$FAILED) {
	        if (input.substr(peg$currPos, 6) === peg$c29) {
	          s0 = peg$c29;
	          peg$currPos += 6;
	        } else {
	          s0 = peg$FAILED;
	          if (peg$silentFails === 0) { peg$fail(peg$c30); }
	        }
	        if (s0 === peg$FAILED) {
	          if (input.substr(peg$currPos, 4) === peg$c31) {
	            s0 = peg$c31;
	            peg$currPos += 4;
	          } else {
	            s0 = peg$FAILED;
	            if (peg$silentFails === 0) { peg$fail(peg$c32); }
	          }
	          if (s0 === peg$FAILED) {
	            if (input.substr(peg$currPos, 3) === peg$c33) {
	              s0 = peg$c33;
	              peg$currPos += 3;
	            } else {
	              s0 = peg$FAILED;
	              if (peg$silentFails === 0) { peg$fail(peg$c34); }
	            }
	            if (s0 === peg$FAILED) {
	              if (input.substr(peg$currPos, 4) === peg$c35) {
	                s0 = peg$c35;
	                peg$currPos += 4;
	              } else {
	                s0 = peg$FAILED;
	                if (peg$silentFails === 0) { peg$fail(peg$c36); }
	              }
	              if (s0 === peg$FAILED) {
	                if (input.substr(peg$currPos, 4) === peg$c37) {
	                  s0 = peg$c37;
	                  peg$currPos += 4;
	                } else {
	                  s0 = peg$FAILED;
	                  if (peg$silentFails === 0) { peg$fail(peg$c38); }
	                }
	                if (s0 === peg$FAILED) {
	                  if (input.substr(peg$currPos, 4) === peg$c39) {
	                    s0 = peg$c39;
	                    peg$currPos += 4;
	                  } else {
	                    s0 = peg$FAILED;
	                    if (peg$silentFails === 0) { peg$fail(peg$c40); }
	                  }
	                  if (s0 === peg$FAILED) {
	                    if (input.substr(peg$currPos, 5) === peg$c41) {
	                      s0 = peg$c41;
	                      peg$currPos += 5;
	                    } else {
	                      s0 = peg$FAILED;
	                      if (peg$silentFails === 0) { peg$fail(peg$c42); }
	                    }
	                    if (s0 === peg$FAILED) {
	                      if (input.substr(peg$currPos, 4) === peg$c43) {
	                        s0 = peg$c43;
	                        peg$currPos += 4;
	                      } else {
	                        s0 = peg$FAILED;
	                        if (peg$silentFails === 0) { peg$fail(peg$c44); }
	                      }
	                      if (s0 === peg$FAILED) {
	                        if (input.substr(peg$currPos, 5) === peg$c45) {
	                          s0 = peg$c45;
	                          peg$currPos += 5;
	                        } else {
	                          s0 = peg$FAILED;
	                          if (peg$silentFails === 0) { peg$fail(peg$c46); }
	                        }
	                      }
	                    }
	                  }
	                }
	              }
	            }
	          }
	        }
	      }
	
	      return s0;
	    }
	
	    function peg$parseeventType() {
	      var s0;
	
	      if (input.substr(peg$currPos, 9) === peg$c47) {
	        s0 = peg$c47;
	        peg$currPos += 9;
	      } else {
	        s0 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c48); }
	      }
	      if (s0 === peg$FAILED) {
	        if (input.substr(peg$currPos, 7) === peg$c49) {
	          s0 = peg$c49;
	          peg$currPos += 7;
	        } else {
	          s0 = peg$FAILED;
	          if (peg$silentFails === 0) { peg$fail(peg$c50); }
	        }
	        if (s0 === peg$FAILED) {
	          if (input.substr(peg$currPos, 5) === peg$c51) {
	            s0 = peg$c51;
	            peg$currPos += 5;
	          } else {
	            s0 = peg$FAILED;
	            if (peg$silentFails === 0) { peg$fail(peg$c52); }
	          }
	          if (s0 === peg$FAILED) {
	            if (input.substr(peg$currPos, 8) === peg$c53) {
	              s0 = peg$c53;
	              peg$currPos += 8;
	            } else {
	              s0 = peg$FAILED;
	              if (peg$silentFails === 0) { peg$fail(peg$c54); }
	            }
	            if (s0 === peg$FAILED) {
	              if (input.substr(peg$currPos, 5) === peg$c55) {
	                s0 = peg$c55;
	                peg$currPos += 5;
	              } else {
	                s0 = peg$FAILED;
	                if (peg$silentFails === 0) { peg$fail(peg$c56); }
	              }
	              if (s0 === peg$FAILED) {
	                if (input.substr(peg$currPos, 7) === peg$c57) {
	                  s0 = peg$c57;
	                  peg$currPos += 7;
	                } else {
	                  s0 = peg$FAILED;
	                  if (peg$silentFails === 0) { peg$fail(peg$c58); }
	                }
	                if (s0 === peg$FAILED) {
	                  if (input.substr(peg$currPos, 8) === peg$c59) {
	                    s0 = peg$c59;
	                    peg$currPos += 8;
	                  } else {
	                    s0 = peg$FAILED;
	                    if (peg$silentFails === 0) { peg$fail(peg$c60); }
	                  }
	                  if (s0 === peg$FAILED) {
	                    if (input.substr(peg$currPos, 5) === peg$c61) {
	                      s0 = peg$c61;
	                      peg$currPos += 5;
	                    } else {
	                      s0 = peg$FAILED;
	                      if (peg$silentFails === 0) { peg$fail(peg$c62); }
	                    }
	                    if (s0 === peg$FAILED) {
	                      if (input.substr(peg$currPos, 10) === peg$c63) {
	                        s0 = peg$c63;
	                        peg$currPos += 10;
	                      } else {
	                        s0 = peg$FAILED;
	                        if (peg$silentFails === 0) { peg$fail(peg$c64); }
	                      }
	                      if (s0 === peg$FAILED) {
	                        if (input.substr(peg$currPos, 9) === peg$c65) {
	                          s0 = peg$c65;
	                          peg$currPos += 9;
	                        } else {
	                          s0 = peg$FAILED;
	                          if (peg$silentFails === 0) { peg$fail(peg$c66); }
	                        }
	                        if (s0 === peg$FAILED) {
	                          if (input.substr(peg$currPos, 8) === peg$c67) {
	                            s0 = peg$c67;
	                            peg$currPos += 8;
	                          } else {
	                            s0 = peg$FAILED;
	                            if (peg$silentFails === 0) { peg$fail(peg$c68); }
	                          }
	                          if (s0 === peg$FAILED) {
	                            if (input.substr(peg$currPos, 9) === peg$c69) {
	                              s0 = peg$c69;
	                              peg$currPos += 9;
	                            } else {
	                              s0 = peg$FAILED;
	                              if (peg$silentFails === 0) { peg$fail(peg$c70); }
	                            }
	                            if (s0 === peg$FAILED) {
	                              if (input.substr(peg$currPos, 10) === peg$c71) {
	                                s0 = peg$c71;
	                                peg$currPos += 10;
	                              } else {
	                                s0 = peg$FAILED;
	                                if (peg$silentFails === 0) { peg$fail(peg$c72); }
	                              }
	                              if (s0 === peg$FAILED) {
	                                if (input.substr(peg$currPos, 10) === peg$c73) {
	                                  s0 = peg$c73;
	                                  peg$currPos += 10;
	                                } else {
	                                  s0 = peg$FAILED;
	                                  if (peg$silentFails === 0) { peg$fail(peg$c74); }
	                                }
	                                if (s0 === peg$FAILED) {
	                                  if (input.substr(peg$currPos, 9) === peg$c75) {
	                                    s0 = peg$c75;
	                                    peg$currPos += 9;
	                                  } else {
	                                    s0 = peg$FAILED;
	                                    if (peg$silentFails === 0) { peg$fail(peg$c76); }
	                                  }
	                                  if (s0 === peg$FAILED) {
	                                    if (input.substr(peg$currPos, 8) === peg$c77) {
	                                      s0 = peg$c77;
	                                      peg$currPos += 8;
	                                    } else {
	                                      s0 = peg$FAILED;
	                                      if (peg$silentFails === 0) { peg$fail(peg$c78); }
	                                    }
	                                    if (s0 === peg$FAILED) {
	                                      if (input.substr(peg$currPos, 9) === peg$c79) {
	                                        s0 = peg$c79;
	                                        peg$currPos += 9;
	                                      } else {
	                                        s0 = peg$FAILED;
	                                        if (peg$silentFails === 0) { peg$fail(peg$c80); }
	                                      }
	                                      if (s0 === peg$FAILED) {
	                                        if (input.substr(peg$currPos, 8) === peg$c81) {
	                                          s0 = peg$c81;
	                                          peg$currPos += 8;
	                                        } else {
	                                          s0 = peg$FAILED;
	                                          if (peg$silentFails === 0) { peg$fail(peg$c82); }
	                                        }
	                                        if (s0 === peg$FAILED) {
	                                          if (input.substr(peg$currPos, 9) === peg$c83) {
	                                            s0 = peg$c83;
	                                            peg$currPos += 9;
	                                          } else {
	                                            s0 = peg$FAILED;
	                                            if (peg$silentFails === 0) { peg$fail(peg$c84); }
	                                          }
	                                        }
	                                      }
	                                    }
	                                  }
	                                }
	                              }
	                            }
	                          }
	                        }
	                      }
	                    }
	                  }
	                }
	              }
	            }
	          }
	        }
	      }
	
	      return s0;
	    }
	
	    function peg$parsefilter() {
	      var s0, s1, s2, s3;
	
	      s0 = peg$currPos;
	      if (input.charCodeAt(peg$currPos) === 91) {
	        s1 = peg$c4;
	        peg$currPos++;
	      } else {
	        s1 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c5); }
	      }
	      if (s1 !== peg$FAILED) {
	        s2 = peg$parseexpr();
	        if (s2 !== peg$FAILED) {
	          if (input.charCodeAt(peg$currPos) === 93) {
	            s3 = peg$c6;
	            peg$currPos++;
	          } else {
	            s3 = peg$FAILED;
	            if (peg$silentFails === 0) { peg$fail(peg$c7); }
	          }
	          if (s3 !== peg$FAILED) {
	            peg$savedPos = s0;
	            s1 = peg$c85(s2);
	            s0 = s1;
	          } else {
	            peg$currPos = s0;
	            s0 = peg$FAILED;
	          }
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	
	      return s0;
	    }
	
	    function peg$parsename() {
	      var s0, s1, s2;
	
	      s0 = peg$currPos;
	      s1 = [];
	      if (peg$c86.test(input.charAt(peg$currPos))) {
	        s2 = input.charAt(peg$currPos);
	        peg$currPos++;
	      } else {
	        s2 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c87); }
	      }
	      if (s2 !== peg$FAILED) {
	        while (s2 !== peg$FAILED) {
	          s1.push(s2);
	          if (peg$c86.test(input.charAt(peg$currPos))) {
	            s2 = input.charAt(peg$currPos);
	            peg$currPos++;
	          } else {
	            s2 = peg$FAILED;
	            if (peg$silentFails === 0) { peg$fail(peg$c87); }
	          }
	        }
	      } else {
	        s1 = peg$FAILED;
	      }
	      if (s1 !== peg$FAILED) {
	        peg$savedPos = s0;
	        s1 = peg$c88(s1);
	      }
	      s0 = s1;
	
	      return s0;
	    }
	
	    function peg$parsecss() {
	      var s0, s1, s2;
	
	      s0 = peg$currPos;
	      s1 = [];
	      if (peg$c89.test(input.charAt(peg$currPos))) {
	        s2 = input.charAt(peg$currPos);
	        peg$currPos++;
	      } else {
	        s2 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c90); }
	      }
	      if (s2 !== peg$FAILED) {
	        while (s2 !== peg$FAILED) {
	          s1.push(s2);
	          if (peg$c89.test(input.charAt(peg$currPos))) {
	            s2 = input.charAt(peg$currPos);
	            peg$currPos++;
	          } else {
	            s2 = peg$FAILED;
	            if (peg$silentFails === 0) { peg$fail(peg$c90); }
	          }
	        }
	      } else {
	        s1 = peg$FAILED;
	      }
	      if (s1 !== peg$FAILED) {
	        peg$savedPos = s0;
	        s1 = peg$c91(s1);
	      }
	      s0 = s1;
	
	      return s0;
	    }
	
	    function peg$parseexpr() {
	      var s0, s1, s2;
	
	      s0 = peg$currPos;
	      s1 = [];
	      if (peg$c92.test(input.charAt(peg$currPos))) {
	        s2 = input.charAt(peg$currPos);
	        peg$currPos++;
	      } else {
	        s2 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c93); }
	      }
	      if (s2 !== peg$FAILED) {
	        while (s2 !== peg$FAILED) {
	          s1.push(s2);
	          if (peg$c92.test(input.charAt(peg$currPos))) {
	            s2 = input.charAt(peg$currPos);
	            peg$currPos++;
	          } else {
	            s2 = peg$FAILED;
	            if (peg$silentFails === 0) { peg$fail(peg$c93); }
	          }
	        }
	      } else {
	        s1 = peg$FAILED;
	      }
	      if (s1 !== peg$FAILED) {
	        peg$savedPos = s0;
	        s1 = peg$c94(s1);
	      }
	      s0 = s1;
	
	      return s0;
	    }
	
	    function peg$parsesep() {
	      var s0, s1;
	
	      s0 = [];
	      if (peg$c95.test(input.charAt(peg$currPos))) {
	        s1 = input.charAt(peg$currPos);
	        peg$currPos++;
	      } else {
	        s1 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c96); }
	      }
	      while (s1 !== peg$FAILED) {
	        s0.push(s1);
	        if (peg$c95.test(input.charAt(peg$currPos))) {
	          s1 = input.charAt(peg$currPos);
	          peg$currPos++;
	        } else {
	          s1 = peg$FAILED;
	          if (peg$silentFails === 0) { peg$fail(peg$c96); }
	        }
	      }
	
	      return s0;
	    }
	
	    peg$result = peg$startRuleFunction();
	
	    if (peg$result !== peg$FAILED && peg$currPos === input.length) {
	      return peg$result;
	    } else {
	      if (peg$result !== peg$FAILED && peg$currPos < input.length) {
	        peg$fail({ type: "end", description: "end of input" });
	      }
	
	      throw peg$buildException(
	        null,
	        peg$maxFailExpected,
	        peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null,
	        peg$maxFailPos < input.length
	          ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1)
	          : peg$computeLocation(peg$maxFailPos, peg$maxFailPos)
	      );
	    }
	  }
	
	  return {
	    SyntaxError: peg$SyntaxError,
	    parse:       peg$parse
	  };
	})();


/***/ },
/* 135 */
/***/ function(module, exports, __webpack_require__) {

	var dl = __webpack_require__(12),
	    template = dl.template,
	    expr = __webpack_require__(136),
	    args = ['datum', 'event', 'signals'];
	
	var compile = expr.compiler(args, {
	  idWhiteList: args,
	  fieldVar:    args[0],
	  globalVar:   function(id) {
	    return 'this.sig[' + dl.str(id) + ']._value';
	  },
	  functions:   function(codegen) {
	    var fn = expr.functions(codegen);
	    fn.eventItem  = 'event.vg.getItem';
	    fn.eventGroup = 'event.vg.getGroup';
	    fn.eventX     = 'event.vg.getX';
	    fn.eventY     = 'event.vg.getY';
	    fn.open       = 'window.open';
	    fn.scale      = scaleGen(codegen, false);
	    fn.iscale     = scaleGen(codegen, true);
	    fn.inrange    = 'this.defs.inrange';
	    fn.indata     = indataGen(codegen);
	    fn.format     = 'this.defs.format';
	    fn.timeFormat = 'this.defs.timeFormat';
	    fn.utcFormat  = 'this.defs.utcFormat';
	    return fn;
	  },
	  functionDefs: function(/*codegen*/) {
	    return {
	      'scale':      scale,
	      'inrange':    inrange,
	      'indata':     indata,
	      'format':     numberFormat,
	      'timeFormat': timeFormat,
	      'utcFormat':  utcFormat
	    };
	  }
	});
	
	function scaleGen(codegen, invert) {
	  return function(args) {
	    args = args.map(codegen);
	    var n = args.length;
	    if (n < 2 || n > 3) {
	      throw Error("scale takes exactly 2 or 3 arguments.");
	    }
	    return 'this.defs.scale(this.model, ' + invert + ', ' +
	      args[0] + ',' + args[1] + (n > 2 ? ',' + args[2] : '') + ')';
	  };
	}
	
	function scale(model, invert, name, value, scope) {
	  if (!scope || !scope.scale) {
	    scope = (scope && scope.mark) ? scope.mark.group : model.scene().items[0];
	  }
	  // Verify scope is valid
	  if (model.group(scope._id) !== scope) {
	    throw Error('Scope for scale "'+name+'" is not a valid group item.');
	  }
	  var s = scope.scale(name);
	  return !s ? value : (invert ? s.invert(value) : s(value));
	}
	
	function inrange(val, a, b, exclusive) {
	  var min = a, max = b;
	  if (a > b) { min = b; max = a; }
	  return exclusive ?
	    (min < val && max > val) :
	    (min <= val && max >= val);
	}
	
	function indataGen(codegen) {
	  return function(args, globals, fields, dataSources) {
	    var data;
	    if (args.length !== 3) {
	      throw Error("indata takes 3 arguments.");
	    }
	    if (args[0].type !== 'Literal') {
	      throw Error("Data source name must be a literal for indata.");
	    }
	
	    data = args[0].value;
	    dataSources[data] = 1;
	    if (args[2].type === 'Literal') {
	      indataGen.model.requestIndex(data, args[2].value);
	    }
	
	    args = args.map(codegen);
	    return 'this.defs.indata(this.model,' + 
	      args[0] + ',' + args[1] + ',' + args[2] + ')';
	  };
	}
	
	function indata(model, dataname, val, field) {
	  var data = model.data(dataname),
	      index = data.getIndex(field);
	  return index[val] > 0;
	}
	
	function numberFormat(specifier, v) {
	  return template.format(specifier, 'number')(v);
	}
	
	function timeFormat(specifier, d) {
	  return template.format(specifier, 'time')(d);
	}
	
	function utcFormat(specifier, d) {
	  return template.format(specifier, 'utc')(d);
	}
	
	function wrap(model) {
	  return function(str) {
	    indataGen.model = model;
	    var x = compile(str);
	    x.model = model;
	    x.sig = model ? model._signals : {};
	    return x;
	  };
	}
	
	wrap.scale = scale;
	wrap.codegen = compile.codegen;
	module.exports = wrap;


/***/ },
/* 136 */
/***/ function(module, exports, __webpack_require__) {

	var parser = __webpack_require__(137),
	    codegen = __webpack_require__(138);
	
	var expr = module.exports = {
	  parse: function(input, opt) {
	      return parser.parse('('+input+')', opt);
	    },
	  code: function(opt) {
	      return codegen(opt);
	    },
	  compiler: function(args, opt) {
	      args = args.slice();
	      var generator = codegen(opt),
	          len = args.length,
	          compile = function(str) {
	            var value = generator(expr.parse(str));
	            args[len] = '"use strict"; return (' + value.code + ');';
	            var fn = Function.apply(null, args);
	            value.fn = (args.length > 8) ?
	              function() { return fn.apply(value, arguments); } :
	              function(a, b, c, d, e, f, g) {
	                return fn.call(value, a, b, c, d, e, f, g);
	              }; // call often faster than apply, use if args low enough
	            return value;
	          };
	      compile.codegen = generator;
	      return compile;
	    },
	  functions: __webpack_require__(140),
	  constants: __webpack_require__(139)
	};

/***/ },
/* 137 */
/***/ function(module, exports) {

	/*
	  The following expression parser is based on Esprima (http://esprima.org/).
	  Original header comment and license for Esprima is included here:
	
	  Copyright (C) 2013 Ariya Hidayat <ariya.hidayat@gmail.com>
	  Copyright (C) 2013 Thaddee Tyl <thaddee.tyl@gmail.com>
	  Copyright (C) 2013 Mathias Bynens <mathias@qiwi.be>
	  Copyright (C) 2012 Ariya Hidayat <ariya.hidayat@gmail.com>
	  Copyright (C) 2012 Mathias Bynens <mathias@qiwi.be>
	  Copyright (C) 2012 Joost-Wim Boekesteijn <joost-wim@boekesteijn.nl>
	  Copyright (C) 2012 Kris Kowal <kris.kowal@cixar.com>
	  Copyright (C) 2012 Yusuke Suzuki <utatane.tea@gmail.com>
	  Copyright (C) 2012 Arpad Borsos <arpad.borsos@googlemail.com>
	  Copyright (C) 2011 Ariya Hidayat <ariya.hidayat@gmail.com>
	
	  Redistribution and use in source and binary forms, with or without
	  modification, are permitted provided that the following conditions are met:
	
	    * Redistributions of source code must retain the above copyright
	      notice, this list of conditions and the following disclaimer.
	    * Redistributions in binary form must reproduce the above copyright
	      notice, this list of conditions and the following disclaimer in the
	      documentation and/or other materials provided with the distribution.
	
	  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
	  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
	  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
	  ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
	  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
	  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
	  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
	  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
	  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
	*/
	/* istanbul ignore next */
	module.exports = (function() {
	  'use strict';
	
	  var Token,
	      TokenName,
	      Syntax,
	      PropertyKind,
	      Messages,
	      Regex,
	      source,
	      strict,
	      index,
	      lineNumber,
	      lineStart,
	      length,
	      lookahead,
	      state,
	      extra;
	
	  Token = {
	      BooleanLiteral: 1,
	      EOF: 2,
	      Identifier: 3,
	      Keyword: 4,
	      NullLiteral: 5,
	      NumericLiteral: 6,
	      Punctuator: 7,
	      StringLiteral: 8,
	      RegularExpression: 9
	  };
	
	  TokenName = {};
	  TokenName[Token.BooleanLiteral] = 'Boolean';
	  TokenName[Token.EOF] = '<end>';
	  TokenName[Token.Identifier] = 'Identifier';
	  TokenName[Token.Keyword] = 'Keyword';
	  TokenName[Token.NullLiteral] = 'Null';
	  TokenName[Token.NumericLiteral] = 'Numeric';
	  TokenName[Token.Punctuator] = 'Punctuator';
	  TokenName[Token.StringLiteral] = 'String';
	  TokenName[Token.RegularExpression] = 'RegularExpression';
	
	  Syntax = {
	      AssignmentExpression: 'AssignmentExpression',
	      ArrayExpression: 'ArrayExpression',
	      BinaryExpression: 'BinaryExpression',
	      CallExpression: 'CallExpression',
	      ConditionalExpression: 'ConditionalExpression',
	      ExpressionStatement: 'ExpressionStatement',
	      Identifier: 'Identifier',
	      Literal: 'Literal',
	      LogicalExpression: 'LogicalExpression',
	      MemberExpression: 'MemberExpression',
	      ObjectExpression: 'ObjectExpression',
	      Program: 'Program',
	      Property: 'Property',
	      UnaryExpression: 'UnaryExpression'
	  };
	
	  PropertyKind = {
	      Data: 1,
	      Get: 2,
	      Set: 4
	  };
	
	  // Error messages should be identical to V8.
	  Messages = {
	      UnexpectedToken:  'Unexpected token %0',
	      UnexpectedNumber:  'Unexpected number',
	      UnexpectedString:  'Unexpected string',
	      UnexpectedIdentifier:  'Unexpected identifier',
	      UnexpectedReserved:  'Unexpected reserved word',
	      UnexpectedEOS:  'Unexpected end of input',
	      NewlineAfterThrow:  'Illegal newline after throw',
	      InvalidRegExp: 'Invalid regular expression',
	      UnterminatedRegExp:  'Invalid regular expression: missing /',
	      InvalidLHSInAssignment:  'Invalid left-hand side in assignment',
	      InvalidLHSInForIn:  'Invalid left-hand side in for-in',
	      MultipleDefaultsInSwitch: 'More than one default clause in switch statement',
	      NoCatchOrFinally:  'Missing catch or finally after try',
	      UnknownLabel: 'Undefined label \'%0\'',
	      Redeclaration: '%0 \'%1\' has already been declared',
	      IllegalContinue: 'Illegal continue statement',
	      IllegalBreak: 'Illegal break statement',
	      IllegalReturn: 'Illegal return statement',
	      StrictModeWith:  'Strict mode code may not include a with statement',
	      StrictCatchVariable:  'Catch variable may not be eval or arguments in strict mode',
	      StrictVarName:  'Variable name may not be eval or arguments in strict mode',
	      StrictParamName:  'Parameter name eval or arguments is not allowed in strict mode',
	      StrictParamDupe: 'Strict mode function may not have duplicate parameter names',
	      StrictFunctionName:  'Function name may not be eval or arguments in strict mode',
	      StrictOctalLiteral:  'Octal literals are not allowed in strict mode.',
	      StrictDelete:  'Delete of an unqualified identifier in strict mode.',
	      StrictDuplicateProperty:  'Duplicate data property in object literal not allowed in strict mode',
	      AccessorDataProperty:  'Object literal may not have data and accessor property with the same name',
	      AccessorGetSet:  'Object literal may not have multiple get/set accessors with the same name',
	      StrictLHSAssignment:  'Assignment to eval or arguments is not allowed in strict mode',
	      StrictLHSPostfix:  'Postfix increment/decrement may not have eval or arguments operand in strict mode',
	      StrictLHSPrefix:  'Prefix increment/decrement may not have eval or arguments operand in strict mode',
	      StrictReservedWord:  'Use of future reserved word in strict mode'
	  };
	
	  // See also tools/generate-unicode-regex.py.
	  Regex = {
	      NonAsciiIdentifierStart: new RegExp('[\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u05D0-\u05EA\u05F0-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u08A0-\u08B2\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58\u0C59\u0C60\u0C61\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D60\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F4\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u170C\u170E-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1877\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19C1-\u19C7\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1CE9-\u1CEC\u1CEE-\u1CF1\u1CF5\u1CF6\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2E2F\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303C\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FCC\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6EF\uA717-\uA71F\uA722-\uA788\uA78B-\uA78E\uA790-\uA7AD\uA7B0\uA7B1\uA7F7-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB5F\uAB64\uAB65\uABC0-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]'),
	      NonAsciiIdentifierPart: new RegExp('[\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0300-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u0483-\u0487\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u05D0-\u05EA\u05F0-\u05F2\u0610-\u061A\u0620-\u0669\u066E-\u06D3\u06D5-\u06DC\u06DF-\u06E8\u06EA-\u06FC\u06FF\u0710-\u074A\u074D-\u07B1\u07C0-\u07F5\u07FA\u0800-\u082D\u0840-\u085B\u08A0-\u08B2\u08E4-\u0963\u0966-\u096F\u0971-\u0983\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BC-\u09C4\u09C7\u09C8\u09CB-\u09CE\u09D7\u09DC\u09DD\u09DF-\u09E3\u09E6-\u09F1\u0A01-\u0A03\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A59-\u0A5C\u0A5E\u0A66-\u0A75\u0A81-\u0A83\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABC-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AD0\u0AE0-\u0AE3\u0AE6-\u0AEF\u0B01-\u0B03\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3C-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B56\u0B57\u0B5C\u0B5D\u0B5F-\u0B63\u0B66-\u0B6F\u0B71\u0B82\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD0\u0BD7\u0BE6-\u0BEF\u0C00-\u0C03\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C58\u0C59\u0C60-\u0C63\u0C66-\u0C6F\u0C81-\u0C83\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBC-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CDE\u0CE0-\u0CE3\u0CE6-\u0CEF\u0CF1\u0CF2\u0D01-\u0D03\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D-\u0D44\u0D46-\u0D48\u0D4A-\u0D4E\u0D57\u0D60-\u0D63\u0D66-\u0D6F\u0D7A-\u0D7F\u0D82\u0D83\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DE6-\u0DEF\u0DF2\u0DF3\u0E01-\u0E3A\u0E40-\u0E4E\u0E50-\u0E59\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB9\u0EBB-\u0EBD\u0EC0-\u0EC4\u0EC6\u0EC8-\u0ECD\u0ED0-\u0ED9\u0EDC-\u0EDF\u0F00\u0F18\u0F19\u0F20-\u0F29\u0F35\u0F37\u0F39\u0F3E-\u0F47\u0F49-\u0F6C\u0F71-\u0F84\u0F86-\u0F97\u0F99-\u0FBC\u0FC6\u1000-\u1049\u1050-\u109D\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u135D-\u135F\u1380-\u138F\u13A0-\u13F4\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u170C\u170E-\u1714\u1720-\u1734\u1740-\u1753\u1760-\u176C\u176E-\u1770\u1772\u1773\u1780-\u17D3\u17D7\u17DC\u17DD\u17E0-\u17E9\u180B-\u180D\u1810-\u1819\u1820-\u1877\u1880-\u18AA\u18B0-\u18F5\u1900-\u191E\u1920-\u192B\u1930-\u193B\u1946-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u19D0-\u19D9\u1A00-\u1A1B\u1A20-\u1A5E\u1A60-\u1A7C\u1A7F-\u1A89\u1A90-\u1A99\u1AA7\u1AB0-\u1ABD\u1B00-\u1B4B\u1B50-\u1B59\u1B6B-\u1B73\u1B80-\u1BF3\u1C00-\u1C37\u1C40-\u1C49\u1C4D-\u1C7D\u1CD0-\u1CD2\u1CD4-\u1CF6\u1CF8\u1CF9\u1D00-\u1DF5\u1DFC-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u200C\u200D\u203F\u2040\u2054\u2071\u207F\u2090-\u209C\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D7F-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2DE0-\u2DFF\u2E2F\u3005-\u3007\u3021-\u302F\u3031-\u3035\u3038-\u303C\u3041-\u3096\u3099\u309A\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FCC\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA62B\uA640-\uA66F\uA674-\uA67D\uA67F-\uA69D\uA69F-\uA6F1\uA717-\uA71F\uA722-\uA788\uA78B-\uA78E\uA790-\uA7AD\uA7B0\uA7B1\uA7F7-\uA827\uA840-\uA873\uA880-\uA8C4\uA8D0-\uA8D9\uA8E0-\uA8F7\uA8FB\uA900-\uA92D\uA930-\uA953\uA960-\uA97C\uA980-\uA9C0\uA9CF-\uA9D9\uA9E0-\uA9FE\uAA00-\uAA36\uAA40-\uAA4D\uAA50-\uAA59\uAA60-\uAA76\uAA7A-\uAAC2\uAADB-\uAADD\uAAE0-\uAAEF\uAAF2-\uAAF6\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB5F\uAB64\uAB65\uABC0-\uABEA\uABEC\uABED\uABF0-\uABF9\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE00-\uFE0F\uFE20-\uFE2D\uFE33\uFE34\uFE4D-\uFE4F\uFE70-\uFE74\uFE76-\uFEFC\uFF10-\uFF19\uFF21-\uFF3A\uFF3F\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]')
	  };
	
	  // Ensure the condition is true, otherwise throw an error.
	  // This is only to have a better contract semantic, i.e. another safety net
	  // to catch a logic error. The condition shall be fulfilled in normal case.
	  // Do NOT use this to enforce a certain condition on any user input.
	
	  function assert(condition, message) {
	      if (!condition) {
	          throw new Error('ASSERT: ' + message);
	      }
	  }
	
	  function isDecimalDigit(ch) {
	      return (ch >= 0x30 && ch <= 0x39);   // 0..9
	  }
	
	  function isHexDigit(ch) {
	      return '0123456789abcdefABCDEF'.indexOf(ch) >= 0;
	  }
	
	  function isOctalDigit(ch) {
	      return '01234567'.indexOf(ch) >= 0;
	  }
	
	  // 7.2 White Space
	
	  function isWhiteSpace(ch) {
	      return (ch === 0x20) || (ch === 0x09) || (ch === 0x0B) || (ch === 0x0C) || (ch === 0xA0) ||
	          (ch >= 0x1680 && [0x1680, 0x180E, 0x2000, 0x2001, 0x2002, 0x2003, 0x2004, 0x2005, 0x2006, 0x2007, 0x2008, 0x2009, 0x200A, 0x202F, 0x205F, 0x3000, 0xFEFF].indexOf(ch) >= 0);
	  }
	
	  // 7.3 Line Terminators
	
	  function isLineTerminator(ch) {
	      return (ch === 0x0A) || (ch === 0x0D) || (ch === 0x2028) || (ch === 0x2029);
	  }
	
	  // 7.6 Identifier Names and Identifiers
	
	  function isIdentifierStart(ch) {
	      return (ch === 0x24) || (ch === 0x5F) ||  // $ (dollar) and _ (underscore)
	          (ch >= 0x41 && ch <= 0x5A) ||         // A..Z
	          (ch >= 0x61 && ch <= 0x7A) ||         // a..z
	          (ch === 0x5C) ||                      // \ (backslash)
	          ((ch >= 0x80) && Regex.NonAsciiIdentifierStart.test(String.fromCharCode(ch)));
	  }
	
	  function isIdentifierPart(ch) {
	      return (ch === 0x24) || (ch === 0x5F) ||  // $ (dollar) and _ (underscore)
	          (ch >= 0x41 && ch <= 0x5A) ||         // A..Z
	          (ch >= 0x61 && ch <= 0x7A) ||         // a..z
	          (ch >= 0x30 && ch <= 0x39) ||         // 0..9
	          (ch === 0x5C) ||                      // \ (backslash)
	          ((ch >= 0x80) && Regex.NonAsciiIdentifierPart.test(String.fromCharCode(ch)));
	  }
	
	  // 7.6.1.2 Future Reserved Words
	
	  function isFutureReservedWord(id) {
	      switch (id) {
	      case 'class':
	      case 'enum':
	      case 'export':
	      case 'extends':
	      case 'import':
	      case 'super':
	          return true;
	      default:
	          return false;
	      }
	  }
	
	  function isStrictModeReservedWord(id) {
	      switch (id) {
	      case 'implements':
	      case 'interface':
	      case 'package':
	      case 'private':
	      case 'protected':
	      case 'public':
	      case 'static':
	      case 'yield':
	      case 'let':
	          return true;
	      default:
	          return false;
	      }
	  }
	
	  // 7.6.1.1 Keywords
	
	  function isKeyword(id) {
	      if (strict && isStrictModeReservedWord(id)) {
	          return true;
	      }
	
	      // 'const' is specialized as Keyword in V8.
	      // 'yield' and 'let' are for compatiblity with SpiderMonkey and ES.next.
	      // Some others are from future reserved words.
	
	      switch (id.length) {
	      case 2:
	          return (id === 'if') || (id === 'in') || (id === 'do');
	      case 3:
	          return (id === 'var') || (id === 'for') || (id === 'new') ||
	              (id === 'try') || (id === 'let');
	      case 4:
	          return (id === 'this') || (id === 'else') || (id === 'case') ||
	              (id === 'void') || (id === 'with') || (id === 'enum');
	      case 5:
	          return (id === 'while') || (id === 'break') || (id === 'catch') ||
	              (id === 'throw') || (id === 'const') || (id === 'yield') ||
	              (id === 'class') || (id === 'super');
	      case 6:
	          return (id === 'return') || (id === 'typeof') || (id === 'delete') ||
	              (id === 'switch') || (id === 'export') || (id === 'import');
	      case 7:
	          return (id === 'default') || (id === 'finally') || (id === 'extends');
	      case 8:
	          return (id === 'function') || (id === 'continue') || (id === 'debugger');
	      case 10:
	          return (id === 'instanceof');
	      default:
	          return false;
	      }
	  }
	
	  function skipComment() {
	      var ch, start;
	
	      start = (index === 0);
	      while (index < length) {
	          ch = source.charCodeAt(index);
	
	          if (isWhiteSpace(ch)) {
	              ++index;
	          } else if (isLineTerminator(ch)) {
	              ++index;
	              if (ch === 0x0D && source.charCodeAt(index) === 0x0A) {
	                  ++index;
	              }
	              ++lineNumber;
	              lineStart = index;
	              start = true;
	          } else {
	              break;
	          }
	      }
	  }
	
	  function scanHexEscape(prefix) {
	      var i, len, ch, code = 0;
	
	      len = (prefix === 'u') ? 4 : 2;
	      for (i = 0; i < len; ++i) {
	          if (index < length && isHexDigit(source[index])) {
	              ch = source[index++];
	              code = code * 16 + '0123456789abcdef'.indexOf(ch.toLowerCase());
	          } else {
	              return '';
	          }
	      }
	      return String.fromCharCode(code);
	  }
	
	  function scanUnicodeCodePointEscape() {
	      var ch, code, cu1, cu2;
	
	      ch = source[index];
	      code = 0;
	
	      // At least, one hex digit is required.
	      if (ch === '}') {
	          throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	      }
	
	      while (index < length) {
	          ch = source[index++];
	          if (!isHexDigit(ch)) {
	              break;
	          }
	          code = code * 16 + '0123456789abcdef'.indexOf(ch.toLowerCase());
	      }
	
	      if (code > 0x10FFFF || ch !== '}') {
	          throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	      }
	
	      // UTF-16 Encoding
	      if (code <= 0xFFFF) {
	          return String.fromCharCode(code);
	      }
	      cu1 = ((code - 0x10000) >> 10) + 0xD800;
	      cu2 = ((code - 0x10000) & 1023) + 0xDC00;
	      return String.fromCharCode(cu1, cu2);
	  }
	
	  function getEscapedIdentifier() {
	      var ch, id;
	
	      ch = source.charCodeAt(index++);
	      id = String.fromCharCode(ch);
	
	      // '\u' (U+005C, U+0075) denotes an escaped character.
	      if (ch === 0x5C) {
	          if (source.charCodeAt(index) !== 0x75) {
	              throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	          }
	          ++index;
	          ch = scanHexEscape('u');
	          if (!ch || ch === '\\' || !isIdentifierStart(ch.charCodeAt(0))) {
	              throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	          }
	          id = ch;
	      }
	
	      while (index < length) {
	          ch = source.charCodeAt(index);
	          if (!isIdentifierPart(ch)) {
	              break;
	          }
	          ++index;
	          id += String.fromCharCode(ch);
	
	          // '\u' (U+005C, U+0075) denotes an escaped character.
	          if (ch === 0x5C) {
	              id = id.substr(0, id.length - 1);
	              if (source.charCodeAt(index) !== 0x75) {
	                  throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	              }
	              ++index;
	              ch = scanHexEscape('u');
	              if (!ch || ch === '\\' || !isIdentifierPart(ch.charCodeAt(0))) {
	                  throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	              }
	              id += ch;
	          }
	      }
	
	      return id;
	  }
	
	  function getIdentifier() {
	      var start, ch;
	
	      start = index++;
	      while (index < length) {
	          ch = source.charCodeAt(index);
	          if (ch === 0x5C) {
	              // Blackslash (U+005C) marks Unicode escape sequence.
	              index = start;
	              return getEscapedIdentifier();
	          }
	          if (isIdentifierPart(ch)) {
	              ++index;
	          } else {
	              break;
	          }
	      }
	
	      return source.slice(start, index);
	  }
	
	  function scanIdentifier() {
	      var start, id, type;
	
	      start = index;
	
	      // Backslash (U+005C) starts an escaped character.
	      id = (source.charCodeAt(index) === 0x5C) ? getEscapedIdentifier() : getIdentifier();
	
	      // There is no keyword or literal with only one character.
	      // Thus, it must be an identifier.
	      if (id.length === 1) {
	          type = Token.Identifier;
	      } else if (isKeyword(id)) {
	          type = Token.Keyword;
	      } else if (id === 'null') {
	          type = Token.NullLiteral;
	      } else if (id === 'true' || id === 'false') {
	          type = Token.BooleanLiteral;
	      } else {
	          type = Token.Identifier;
	      }
	
	      return {
	          type: type,
	          value: id,
	          lineNumber: lineNumber,
	          lineStart: lineStart,
	          start: start,
	          end: index
	      };
	  }
	
	  // 7.7 Punctuators
	
	  function scanPunctuator() {
	      var start = index,
	          code = source.charCodeAt(index),
	          code2,
	          ch1 = source[index],
	          ch2,
	          ch3,
	          ch4;
	
	      switch (code) {
	
	      // Check for most common single-character punctuators.
	      case 0x2E:  // . dot
	      case 0x28:  // ( open bracket
	      case 0x29:  // ) close bracket
	      case 0x3B:  // ; semicolon
	      case 0x2C:  // , comma
	      case 0x7B:  // { open curly brace
	      case 0x7D:  // } close curly brace
	      case 0x5B:  // [
	      case 0x5D:  // ]
	      case 0x3A:  // :
	      case 0x3F:  // ?
	      case 0x7E:  // ~
	          ++index;
	          if (extra.tokenize) {
	              if (code === 0x28) {
	                  extra.openParenToken = extra.tokens.length;
	              } else if (code === 0x7B) {
	                  extra.openCurlyToken = extra.tokens.length;
	              }
	          }
	          return {
	              type: Token.Punctuator,
	              value: String.fromCharCode(code),
	              lineNumber: lineNumber,
	              lineStart: lineStart,
	              start: start,
	              end: index
	          };
	
	      default:
	          code2 = source.charCodeAt(index + 1);
	
	          // '=' (U+003D) marks an assignment or comparison operator.
	          if (code2 === 0x3D) {
	              switch (code) {
	              case 0x2B:  // +
	              case 0x2D:  // -
	              case 0x2F:  // /
	              case 0x3C:  // <
	              case 0x3E:  // >
	              case 0x5E:  // ^
	              case 0x7C:  // |
	              case 0x25:  // %
	              case 0x26:  // &
	              case 0x2A:  // *
	                  index += 2;
	                  return {
	                      type: Token.Punctuator,
	                      value: String.fromCharCode(code) + String.fromCharCode(code2),
	                      lineNumber: lineNumber,
	                      lineStart: lineStart,
	                      start: start,
	                      end: index
	                  };
	
	              case 0x21: // !
	              case 0x3D: // =
	                  index += 2;
	
	                  // !== and ===
	                  if (source.charCodeAt(index) === 0x3D) {
	                      ++index;
	                  }
	                  return {
	                      type: Token.Punctuator,
	                      value: source.slice(start, index),
	                      lineNumber: lineNumber,
	                      lineStart: lineStart,
	                      start: start,
	                      end: index
	                  };
	              }
	          }
	      }
	
	      // 4-character punctuator: >>>=
	
	      ch4 = source.substr(index, 4);
	
	      if (ch4 === '>>>=') {
	          index += 4;
	          return {
	              type: Token.Punctuator,
	              value: ch4,
	              lineNumber: lineNumber,
	              lineStart: lineStart,
	              start: start,
	              end: index
	          };
	      }
	
	      // 3-character punctuators: === !== >>> <<= >>=
	
	      ch3 = ch4.substr(0, 3);
	
	      if (ch3 === '>>>' || ch3 === '<<=' || ch3 === '>>=') {
	          index += 3;
	          return {
	              type: Token.Punctuator,
	              value: ch3,
	              lineNumber: lineNumber,
	              lineStart: lineStart,
	              start: start,
	              end: index
	          };
	      }
	
	      // Other 2-character punctuators: ++ -- << >> && ||
	      ch2 = ch3.substr(0, 2);
	
	      if ((ch1 === ch2[1] && ('+-<>&|'.indexOf(ch1) >= 0)) || ch2 === '=>') {
	          index += 2;
	          return {
	              type: Token.Punctuator,
	              value: ch2,
	              lineNumber: lineNumber,
	              lineStart: lineStart,
	              start: start,
	              end: index
	          };
	      }
	
	      // 1-character punctuators: < > = ! + - * % & | ^ /
	
	      if ('<>=!+-*%&|^/'.indexOf(ch1) >= 0) {
	          ++index;
	          return {
	              type: Token.Punctuator,
	              value: ch1,
	              lineNumber: lineNumber,
	              lineStart: lineStart,
	              start: start,
	              end: index
	          };
	      }
	
	      throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	  }
	
	  // 7.8.3 Numeric Literals
	
	  function scanHexLiteral(start) {
	      var number = '';
	
	      while (index < length) {
	          if (!isHexDigit(source[index])) {
	              break;
	          }
	          number += source[index++];
	      }
	
	      if (number.length === 0) {
	          throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	      }
	
	      if (isIdentifierStart(source.charCodeAt(index))) {
	          throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	      }
	
	      return {
	          type: Token.NumericLiteral,
	          value: parseInt('0x' + number, 16),
	          lineNumber: lineNumber,
	          lineStart: lineStart,
	          start: start,
	          end: index
	      };
	  }
	
	  function scanOctalLiteral(start) {
	      var number = '0' + source[index++];
	      while (index < length) {
	          if (!isOctalDigit(source[index])) {
	              break;
	          }
	          number += source[index++];
	      }
	
	      if (isIdentifierStart(source.charCodeAt(index)) || isDecimalDigit(source.charCodeAt(index))) {
	          throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	      }
	
	      return {
	          type: Token.NumericLiteral,
	          value: parseInt(number, 8),
	          octal: true,
	          lineNumber: lineNumber,
	          lineStart: lineStart,
	          start: start,
	          end: index
	      };
	  }
	
	  function scanNumericLiteral() {
	      var number, start, ch;
	
	      ch = source[index];
	      assert(isDecimalDigit(ch.charCodeAt(0)) || (ch === '.'),
	          'Numeric literal must start with a decimal digit or a decimal point');
	
	      start = index;
	      number = '';
	      if (ch !== '.') {
	          number = source[index++];
	          ch = source[index];
	
	          // Hex number starts with '0x'.
	          // Octal number starts with '0'.
	          if (number === '0') {
	              if (ch === 'x' || ch === 'X') {
	                  ++index;
	                  return scanHexLiteral(start);
	              }
	              if (isOctalDigit(ch)) {
	                  return scanOctalLiteral(start);
	              }
	
	              // decimal number starts with '0' such as '09' is illegal.
	              if (ch && isDecimalDigit(ch.charCodeAt(0))) {
	                  throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	              }
	          }
	
	          while (isDecimalDigit(source.charCodeAt(index))) {
	              number += source[index++];
	          }
	          ch = source[index];
	      }
	
	      if (ch === '.') {
	          number += source[index++];
	          while (isDecimalDigit(source.charCodeAt(index))) {
	              number += source[index++];
	          }
	          ch = source[index];
	      }
	
	      if (ch === 'e' || ch === 'E') {
	          number += source[index++];
	
	          ch = source[index];
	          if (ch === '+' || ch === '-') {
	              number += source[index++];
	          }
	          if (isDecimalDigit(source.charCodeAt(index))) {
	              while (isDecimalDigit(source.charCodeAt(index))) {
	                  number += source[index++];
	              }
	          } else {
	              throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	          }
	      }
	
	      if (isIdentifierStart(source.charCodeAt(index))) {
	          throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	      }
	
	      return {
	          type: Token.NumericLiteral,
	          value: parseFloat(number),
	          lineNumber: lineNumber,
	          lineStart: lineStart,
	          start: start,
	          end: index
	      };
	  }
	
	  // 7.8.4 String Literals
	
	  function scanStringLiteral() {
	      var str = '', quote, start, ch, code, unescaped, restore, octal = false, startLineNumber, startLineStart;
	      startLineNumber = lineNumber;
	      startLineStart = lineStart;
	
	      quote = source[index];
	      assert((quote === '\'' || quote === '"'),
	          'String literal must starts with a quote');
	
	      start = index;
	      ++index;
	
	      while (index < length) {
	          ch = source[index++];
	
	          if (ch === quote) {
	              quote = '';
	              break;
	          } else if (ch === '\\') {
	              ch = source[index++];
	              if (!ch || !isLineTerminator(ch.charCodeAt(0))) {
	                  switch (ch) {
	                  case 'u':
	                  case 'x':
	                      if (source[index] === '{') {
	                          ++index;
	                          str += scanUnicodeCodePointEscape();
	                      } else {
	                          restore = index;
	                          unescaped = scanHexEscape(ch);
	                          if (unescaped) {
	                              str += unescaped;
	                          } else {
	                              index = restore;
	                              str += ch;
	                          }
	                      }
	                      break;
	                  case 'n':
	                      str += '\n';
	                      break;
	                  case 'r':
	                      str += '\r';
	                      break;
	                  case 't':
	                      str += '\t';
	                      break;
	                  case 'b':
	                      str += '\b';
	                      break;
	                  case 'f':
	                      str += '\f';
	                      break;
	                  case 'v':
	                      str += '\x0B';
	                      break;
	
	                  default:
	                      if (isOctalDigit(ch)) {
	                          code = '01234567'.indexOf(ch);
	
	                          // \0 is not octal escape sequence
	                          if (code !== 0) {
	                              octal = true;
	                          }
	
	                          if (index < length && isOctalDigit(source[index])) {
	                              octal = true;
	                              code = code * 8 + '01234567'.indexOf(source[index++]);
	
	                              // 3 digits are only allowed when string starts
	                              // with 0, 1, 2, 3
	                              if ('0123'.indexOf(ch) >= 0 &&
	                                      index < length &&
	                                      isOctalDigit(source[index])) {
	                                  code = code * 8 + '01234567'.indexOf(source[index++]);
	                              }
	                          }
	                          str += String.fromCharCode(code);
	                      } else {
	                          str += ch;
	                      }
	                      break;
	                  }
	              } else {
	                  ++lineNumber;
	                  if (ch ===  '\r' && source[index] === '\n') {
	                      ++index;
	                  }
	                  lineStart = index;
	              }
	          } else if (isLineTerminator(ch.charCodeAt(0))) {
	              break;
	          } else {
	              str += ch;
	          }
	      }
	
	      if (quote !== '') {
	          throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	      }
	
	      return {
	          type: Token.StringLiteral,
	          value: str,
	          octal: octal,
	          startLineNumber: startLineNumber,
	          startLineStart: startLineStart,
	          lineNumber: lineNumber,
	          lineStart: lineStart,
	          start: start,
	          end: index
	      };
	  }
	
	  function testRegExp(pattern, flags) {
	      var tmp = pattern,
	          value;
	
	      if (flags.indexOf('u') >= 0) {
	          // Replace each astral symbol and every Unicode code point
	          // escape sequence with a single ASCII symbol to avoid throwing on
	          // regular expressions that are only valid in combination with the
	          // `/u` flag.
	          // Note: replacing with the ASCII symbol `x` might cause false
	          // negatives in unlikely scenarios. For example, `[\u{61}-b]` is a
	          // perfectly valid pattern that is equivalent to `[a-b]`, but it
	          // would be replaced by `[x-b]` which throws an error.
	          tmp = tmp
	              .replace(/\\u\{([0-9a-fA-F]+)\}/g, function ($0, $1) {
	                  if (parseInt($1, 16) <= 0x10FFFF) {
	                      return 'x';
	                  }
	                  throwError({}, Messages.InvalidRegExp);
	              })
	              .replace(/[\uD800-\uDBFF][\uDC00-\uDFFF]/g, 'x');
	      }
	
	      // First, detect invalid regular expressions.
	      try {
	          value = new RegExp(tmp);
	      } catch (e) {
	          throwError({}, Messages.InvalidRegExp);
	      }
	
	      // Return a regular expression object for this pattern-flag pair, or
	      // `null` in case the current environment doesn't support the flags it
	      // uses.
	      try {
	          return new RegExp(pattern, flags);
	      } catch (exception) {
	          return null;
	      }
	  }
	
	  function scanRegExpBody() {
	      var ch, str, classMarker, terminated, body;
	
	      ch = source[index];
	      assert(ch === '/', 'Regular expression literal must start with a slash');
	      str = source[index++];
	
	      classMarker = false;
	      terminated = false;
	      while (index < length) {
	          ch = source[index++];
	          str += ch;
	          if (ch === '\\') {
	              ch = source[index++];
	              // ECMA-262 7.8.5
	              if (isLineTerminator(ch.charCodeAt(0))) {
	                  throwError({}, Messages.UnterminatedRegExp);
	              }
	              str += ch;
	          } else if (isLineTerminator(ch.charCodeAt(0))) {
	              throwError({}, Messages.UnterminatedRegExp);
	          } else if (classMarker) {
	              if (ch === ']') {
	                  classMarker = false;
	              }
	          } else {
	              if (ch === '/') {
	                  terminated = true;
	                  break;
	              } else if (ch === '[') {
	                  classMarker = true;
	              }
	          }
	      }
	
	      if (!terminated) {
	          throwError({}, Messages.UnterminatedRegExp);
	      }
	
	      // Exclude leading and trailing slash.
	      body = str.substr(1, str.length - 2);
	      return {
	          value: body,
	          literal: str
	      };
	  }
	
	  function scanRegExpFlags() {
	      var ch, str, flags, restore;
	
	      str = '';
	      flags = '';
	      while (index < length) {
	          ch = source[index];
	          if (!isIdentifierPart(ch.charCodeAt(0))) {
	              break;
	          }
	
	          ++index;
	          if (ch === '\\' && index < length) {
	              ch = source[index];
	              if (ch === 'u') {
	                  ++index;
	                  restore = index;
	                  ch = scanHexEscape('u');
	                  if (ch) {
	                      flags += ch;
	                      for (str += '\\u'; restore < index; ++restore) {
	                          str += source[restore];
	                      }
	                  } else {
	                      index = restore;
	                      flags += 'u';
	                      str += '\\u';
	                  }
	                  throwErrorTolerant({}, Messages.UnexpectedToken, 'ILLEGAL');
	              } else {
	                  str += '\\';
	                  throwErrorTolerant({}, Messages.UnexpectedToken, 'ILLEGAL');
	              }
	          } else {
	              flags += ch;
	              str += ch;
	          }
	      }
	
	      return {
	          value: flags,
	          literal: str
	      };
	  }
	
	  function scanRegExp() {
	      var start, body, flags, value;
	
	      lookahead = null;
	      skipComment();
	      start = index;
	
	      body = scanRegExpBody();
	      flags = scanRegExpFlags();
	      value = testRegExp(body.value, flags.value);
	
	      if (extra.tokenize) {
	          return {
	              type: Token.RegularExpression,
	              value: value,
	              regex: {
	                  pattern: body.value,
	                  flags: flags.value
	              },
	              lineNumber: lineNumber,
	              lineStart: lineStart,
	              start: start,
	              end: index
	          };
	      }
	
	      return {
	          literal: body.literal + flags.literal,
	          value: value,
	          regex: {
	              pattern: body.value,
	              flags: flags.value
	          },
	          start: start,
	          end: index
	      };
	  }
	
	  function collectRegex() {
	      var pos, loc, regex, token;
	
	      skipComment();
	
	      pos = index;
	      loc = {
	          start: {
	              line: lineNumber,
	              column: index - lineStart
	          }
	      };
	
	      regex = scanRegExp();
	
	      loc.end = {
	          line: lineNumber,
	          column: index - lineStart
	      };
	
	      if (!extra.tokenize) {
	          // Pop the previous token, which is likely '/' or '/='
	          if (extra.tokens.length > 0) {
	              token = extra.tokens[extra.tokens.length - 1];
	              if (token.range[0] === pos && token.type === 'Punctuator') {
	                  if (token.value === '/' || token.value === '/=') {
	                      extra.tokens.pop();
	                  }
	              }
	          }
	
	          extra.tokens.push({
	              type: 'RegularExpression',
	              value: regex.literal,
	              regex: regex.regex,
	              range: [pos, index],
	              loc: loc
	          });
	      }
	
	      return regex;
	  }
	
	  function isIdentifierName(token) {
	      return token.type === Token.Identifier ||
	          token.type === Token.Keyword ||
	          token.type === Token.BooleanLiteral ||
	          token.type === Token.NullLiteral;
	  }
	
	  function advanceSlash() {
	      var prevToken,
	          checkToken;
	      // Using the following algorithm:
	      // https://github.com/mozilla/sweet.js/wiki/design
	      prevToken = extra.tokens[extra.tokens.length - 1];
	      if (!prevToken) {
	          // Nothing before that: it cannot be a division.
	          return collectRegex();
	      }
	      if (prevToken.type === 'Punctuator') {
	          if (prevToken.value === ']') {
	              return scanPunctuator();
	          }
	          if (prevToken.value === ')') {
	              checkToken = extra.tokens[extra.openParenToken - 1];
	              if (checkToken &&
	                      checkToken.type === 'Keyword' &&
	                      (checkToken.value === 'if' ||
	                       checkToken.value === 'while' ||
	                       checkToken.value === 'for' ||
	                       checkToken.value === 'with')) {
	                  return collectRegex();
	              }
	              return scanPunctuator();
	          }
	          if (prevToken.value === '}') {
	              // Dividing a function by anything makes little sense,
	              // but we have to check for that.
	              if (extra.tokens[extra.openCurlyToken - 3] &&
	                      extra.tokens[extra.openCurlyToken - 3].type === 'Keyword') {
	                  // Anonymous function.
	                  checkToken = extra.tokens[extra.openCurlyToken - 4];
	                  if (!checkToken) {
	                      return scanPunctuator();
	                  }
	              } else if (extra.tokens[extra.openCurlyToken - 4] &&
	                      extra.tokens[extra.openCurlyToken - 4].type === 'Keyword') {
	                  // Named function.
	                  checkToken = extra.tokens[extra.openCurlyToken - 5];
	                  if (!checkToken) {
	                      return collectRegex();
	                  }
	              } else {
	                  return scanPunctuator();
	              }
	              return scanPunctuator();
	          }
	          return collectRegex();
	      }
	      if (prevToken.type === 'Keyword' && prevToken.value !== 'this') {
	          return collectRegex();
	      }
	      return scanPunctuator();
	  }
	
	  function advance() {
	      var ch;
	
	      skipComment();
	
	      if (index >= length) {
	          return {
	              type: Token.EOF,
	              lineNumber: lineNumber,
	              lineStart: lineStart,
	              start: index,
	              end: index
	          };
	      }
	
	      ch = source.charCodeAt(index);
	
	      if (isIdentifierStart(ch)) {
	          return scanIdentifier();
	      }
	
	      // Very common: ( and ) and ;
	      if (ch === 0x28 || ch === 0x29 || ch === 0x3B) {
	          return scanPunctuator();
	      }
	
	      // String literal starts with single quote (U+0027) or double quote (U+0022).
	      if (ch === 0x27 || ch === 0x22) {
	          return scanStringLiteral();
	      }
	
	
	      // Dot (.) U+002E can also start a floating-point number, hence the need
	      // to check the next character.
	      if (ch === 0x2E) {
	          if (isDecimalDigit(source.charCodeAt(index + 1))) {
	              return scanNumericLiteral();
	          }
	          return scanPunctuator();
	      }
	
	      if (isDecimalDigit(ch)) {
	          return scanNumericLiteral();
	      }
	
	      // Slash (/) U+002F can also start a regex.
	      if (extra.tokenize && ch === 0x2F) {
	          return advanceSlash();
	      }
	
	      return scanPunctuator();
	  }
	
	  function collectToken() {
	      var loc, token, value, entry;
	
	      skipComment();
	      loc = {
	          start: {
	              line: lineNumber,
	              column: index - lineStart
	          }
	      };
	
	      token = advance();
	      loc.end = {
	          line: lineNumber,
	          column: index - lineStart
	      };
	
	      if (token.type !== Token.EOF) {
	          value = source.slice(token.start, token.end);
	          entry = {
	              type: TokenName[token.type],
	              value: value,
	              range: [token.start, token.end],
	              loc: loc
	          };
	          if (token.regex) {
	              entry.regex = {
	                  pattern: token.regex.pattern,
	                  flags: token.regex.flags
	              };
	          }
	          extra.tokens.push(entry);
	      }
	
	      return token;
	  }
	
	  function lex() {
	      var token;
	
	      token = lookahead;
	      index = token.end;
	      lineNumber = token.lineNumber;
	      lineStart = token.lineStart;
	
	      lookahead = (typeof extra.tokens !== 'undefined') ? collectToken() : advance();
	
	      index = token.end;
	      lineNumber = token.lineNumber;
	      lineStart = token.lineStart;
	
	      return token;
	  }
	
	  function peek() {
	      var pos, line, start;
	
	      pos = index;
	      line = lineNumber;
	      start = lineStart;
	      lookahead = (typeof extra.tokens !== 'undefined') ? collectToken() : advance();
	      index = pos;
	      lineNumber = line;
	      lineStart = start;
	  }
	
	  function Position() {
	      this.line = lineNumber;
	      this.column = index - lineStart;
	  }
	
	  function SourceLocation() {
	      this.start = new Position();
	      this.end = null;
	  }
	
	  function WrappingSourceLocation(startToken) {
	      if (startToken.type === Token.StringLiteral) {
	          this.start = {
	              line: startToken.startLineNumber,
	              column: startToken.start - startToken.startLineStart
	          };
	      } else {
	          this.start = {
	              line: startToken.lineNumber,
	              column: startToken.start - startToken.lineStart
	          };
	      }
	      this.end = null;
	  }
	
	  function Node() {
	      // Skip comment.
	      index = lookahead.start;
	      if (lookahead.type === Token.StringLiteral) {
	          lineNumber = lookahead.startLineNumber;
	          lineStart = lookahead.startLineStart;
	      } else {
	          lineNumber = lookahead.lineNumber;
	          lineStart = lookahead.lineStart;
	      }
	      if (extra.range) {
	          this.range = [index, 0];
	      }
	      if (extra.loc) {
	          this.loc = new SourceLocation();
	      }
	  }
	
	  function WrappingNode(startToken) {
	      if (extra.range) {
	          this.range = [startToken.start, 0];
	      }
	      if (extra.loc) {
	          this.loc = new WrappingSourceLocation(startToken);
	      }
	  }
	
	  WrappingNode.prototype = Node.prototype = {
	
	      finish: function () {
	          if (extra.range) {
	              this.range[1] = index;
	          }
	          if (extra.loc) {
	              this.loc.end = new Position();
	              if (extra.source) {
	                  this.loc.source = extra.source;
	              }
	          }
	      },
	
	      finishArrayExpression: function (elements) {
	          this.type = Syntax.ArrayExpression;
	          this.elements = elements;
	          this.finish();
	          return this;
	      },
	
	      finishAssignmentExpression: function (operator, left, right) {
	          this.type = Syntax.AssignmentExpression;
	          this.operator = operator;
	          this.left = left;
	          this.right = right;
	          this.finish();
	          return this;
	      },
	
	      finishBinaryExpression: function (operator, left, right) {
	          this.type = (operator === '||' || operator === '&&') ? Syntax.LogicalExpression : Syntax.BinaryExpression;
	          this.operator = operator;
	          this.left = left;
	          this.right = right;
	          this.finish();
	          return this;
	      },
	
	      finishCallExpression: function (callee, args) {
	          this.type = Syntax.CallExpression;
	          this.callee = callee;
	          this.arguments = args;
	          this.finish();
	          return this;
	      },
	
	      finishConditionalExpression: function (test, consequent, alternate) {
	          this.type = Syntax.ConditionalExpression;
	          this.test = test;
	          this.consequent = consequent;
	          this.alternate = alternate;
	          this.finish();
	          return this;
	      },
	
	      finishExpressionStatement: function (expression) {
	          this.type = Syntax.ExpressionStatement;
	          this.expression = expression;
	          this.finish();
	          return this;
	      },
	
	      finishIdentifier: function (name) {
	          this.type = Syntax.Identifier;
	          this.name = name;
	          this.finish();
	          return this;
	      },
	
	      finishLiteral: function (token) {
	          this.type = Syntax.Literal;
	          this.value = token.value;
	          this.raw = source.slice(token.start, token.end);
	          if (token.regex) {
	              if (this.raw == '//') {
	                this.raw = '/(?:)/';
	              }
	              this.regex = token.regex;
	          }
	          this.finish();
	          return this;
	      },
	
	      finishMemberExpression: function (accessor, object, property) {
	          this.type = Syntax.MemberExpression;
	          this.computed = accessor === '[';
	          this.object = object;
	          this.property = property;
	          this.finish();
	          return this;
	      },
	
	      finishObjectExpression: function (properties) {
	          this.type = Syntax.ObjectExpression;
	          this.properties = properties;
	          this.finish();
	          return this;
	      },
	
	      finishProgram: function (body) {
	          this.type = Syntax.Program;
	          this.body = body;
	          this.finish();
	          return this;
	      },
	
	      finishProperty: function (kind, key, value) {
	          this.type = Syntax.Property;
	          this.key = key;
	          this.value = value;
	          this.kind = kind;
	          this.finish();
	          return this;
	      },
	
	      finishUnaryExpression: function (operator, argument) {
	          this.type = Syntax.UnaryExpression;
	          this.operator = operator;
	          this.argument = argument;
	          this.prefix = true;
	          this.finish();
	          return this;
	      }
	  };
	
	  // Return true if there is a line terminator before the next token.
	
	  function peekLineTerminator() {
	      var pos, line, start, found;
	
	      pos = index;
	      line = lineNumber;
	      start = lineStart;
	      skipComment();
	      found = lineNumber !== line;
	      index = pos;
	      lineNumber = line;
	      lineStart = start;
	
	      return found;
	  }
	
	  // Throw an exception
	
	  function throwError(token, messageFormat) {
	      var error,
	          args = Array.prototype.slice.call(arguments, 2),
	          msg = messageFormat.replace(
	              /%(\d)/g,
	              function (whole, index) {
	                  assert(index < args.length, 'Message reference must be in range');
	                  return args[index];
	              }
	          );
	
	      if (typeof token.lineNumber === 'number') {
	          error = new Error('Line ' + token.lineNumber + ': ' + msg);
	          error.index = token.start;
	          error.lineNumber = token.lineNumber;
	          error.column = token.start - lineStart + 1;
	      } else {
	          error = new Error('Line ' + lineNumber + ': ' + msg);
	          error.index = index;
	          error.lineNumber = lineNumber;
	          error.column = index - lineStart + 1;
	      }
	
	      error.description = msg;
	      throw error;
	  }
	
	  function throwErrorTolerant() {
	      try {
	          throwError.apply(null, arguments);
	      } catch (e) {
	          if (extra.errors) {
	              extra.errors.push(e);
	          } else {
	              throw e;
	          }
	      }
	  }
	
	
	  // Throw an exception because of the token.
	
	  function throwUnexpected(token) {
	      if (token.type === Token.EOF) {
	          throwError(token, Messages.UnexpectedEOS);
	      }
	
	      if (token.type === Token.NumericLiteral) {
	          throwError(token, Messages.UnexpectedNumber);
	      }
	
	      if (token.type === Token.StringLiteral) {
	          throwError(token, Messages.UnexpectedString);
	      }
	
	      if (token.type === Token.Identifier) {
	          throwError(token, Messages.UnexpectedIdentifier);
	      }
	
	      if (token.type === Token.Keyword) {
	          if (isFutureReservedWord(token.value)) {
	              throwError(token, Messages.UnexpectedReserved);
	          } else if (strict && isStrictModeReservedWord(token.value)) {
	              throwErrorTolerant(token, Messages.StrictReservedWord);
	              return;
	          }
	          throwError(token, Messages.UnexpectedToken, token.value);
	      }
	
	      // BooleanLiteral, NullLiteral, or Punctuator.
	      throwError(token, Messages.UnexpectedToken, token.value);
	  }
	
	  // Expect the next token to match the specified punctuator.
	  // If not, an exception will be thrown.
	
	  function expect(value) {
	      var token = lex();
	      if (token.type !== Token.Punctuator || token.value !== value) {
	          throwUnexpected(token);
	      }
	  }
	
	  /**
	   * @name expectTolerant
	   * @description Quietly expect the given token value when in tolerant mode, otherwise delegates
	   * to <code>expect(value)</code>
	   * @param {String} value The value we are expecting the lookahead token to have
	   * @since 2.0
	   */
	  function expectTolerant(value) {
	      if (extra.errors) {
	          var token = lookahead;
	          if (token.type !== Token.Punctuator && token.value !== value) {
	              throwErrorTolerant(token, Messages.UnexpectedToken, token.value);
	          } else {
	              lex();
	          }
	      } else {
	          expect(value);
	      }
	  }
	
	  // Return true if the next token matches the specified punctuator.
	
	  function match(value) {
	      return lookahead.type === Token.Punctuator && lookahead.value === value;
	  }
	
	  // Return true if the next token matches the specified keyword
	
	  function matchKeyword(keyword) {
	      return lookahead.type === Token.Keyword && lookahead.value === keyword;
	  }
	
	  function consumeSemicolon() {
	      var line;
	
	      // Catch the very common case first: immediately a semicolon (U+003B).
	      if (source.charCodeAt(index) === 0x3B || match(';')) {
	          lex();
	          return;
	      }
	
	      line = lineNumber;
	      skipComment();
	      if (lineNumber !== line) {
	          return;
	      }
	
	      if (lookahead.type !== Token.EOF && !match('}')) {
	          throwUnexpected(lookahead);
	      }
	  }
	
	  // 11.1.4 Array Initialiser
	
	  function parseArrayInitialiser() {
	      var elements = [], node = new Node();
	
	      expect('[');
	
	      while (!match(']')) {
	          if (match(',')) {
	              lex();
	              elements.push(null);
	          } else {
	              elements.push(parseAssignmentExpression());
	
	              if (!match(']')) {
	                  expect(',');
	              }
	          }
	      }
	
	      lex();
	
	      return node.finishArrayExpression(elements);
	  }
	
	  // 11.1.5 Object Initialiser
	
	  function parseObjectPropertyKey() {
	      var token, node = new Node();
	
	      token = lex();
	
	      // Note: This function is called only from parseObjectProperty(), where
	      // EOF and Punctuator tokens are already filtered out.
	
	      if (token.type === Token.StringLiteral || token.type === Token.NumericLiteral) {
	          if (strict && token.octal) {
	              throwErrorTolerant(token, Messages.StrictOctalLiteral);
	          }
	          return node.finishLiteral(token);
	      }
	
	      return node.finishIdentifier(token.value);
	  }
	
	  function parseObjectProperty() {
	      var token, key, id, value, node = new Node();
	
	      token = lookahead;
	
	      if (token.type === Token.Identifier) {
	          id = parseObjectPropertyKey();
	          expect(':');
	          value = parseAssignmentExpression();
	          return node.finishProperty('init', id, value);
	      }
	      if (token.type === Token.EOF || token.type === Token.Punctuator) {
	          throwUnexpected(token);
	      } else {
	          key = parseObjectPropertyKey();
	          expect(':');
	          value = parseAssignmentExpression();
	          return node.finishProperty('init', key, value);
	      }
	  }
	
	  function parseObjectInitialiser() {
	      var properties = [], property, name, key, kind, map = {}, toString = String, node = new Node();
	
	      expect('{');
	
	      while (!match('}')) {
	          property = parseObjectProperty();
	
	          if (property.key.type === Syntax.Identifier) {
	              name = property.key.name;
	          } else {
	              name = toString(property.key.value);
	          }
	          kind = (property.kind === 'init') ? PropertyKind.Data : (property.kind === 'get') ? PropertyKind.Get : PropertyKind.Set;
	
	          key = '$' + name;
	          if (Object.prototype.hasOwnProperty.call(map, key)) {
	              if (map[key] === PropertyKind.Data) {
	                  if (strict && kind === PropertyKind.Data) {
	                      throwErrorTolerant({}, Messages.StrictDuplicateProperty);
	                  } else if (kind !== PropertyKind.Data) {
	                      throwErrorTolerant({}, Messages.AccessorDataProperty);
	                  }
	              } else {
	                  if (kind === PropertyKind.Data) {
	                      throwErrorTolerant({}, Messages.AccessorDataProperty);
	                  } else if (map[key] & kind) {
	                      throwErrorTolerant({}, Messages.AccessorGetSet);
	                  }
	              }
	              map[key] |= kind;
	          } else {
	              map[key] = kind;
	          }
	
	          properties.push(property);
	
	          if (!match('}')) {
	              expectTolerant(',');
	          }
	      }
	
	      expect('}');
	
	      return node.finishObjectExpression(properties);
	  }
	
	  // 11.1.6 The Grouping Operator
	
	  function parseGroupExpression() {
	      var expr;
	
	      expect('(');
	
	      ++state.parenthesisCount;
	
	      expr = parseExpression();
	
	      expect(')');
	
	      return expr;
	  }
	
	
	  // 11.1 Primary Expressions
	
	  var legalKeywords = {"if":1, "this":1};
	
	  function parsePrimaryExpression() {
	      var type, token, expr, node;
	
	      if (match('(')) {
	          return parseGroupExpression();
	      }
	
	      if (match('[')) {
	          return parseArrayInitialiser();
	      }
	
	      if (match('{')) {
	          return parseObjectInitialiser();
	      }
	
	      type = lookahead.type;
	      node = new Node();
	
	      if (type === Token.Identifier || legalKeywords[lookahead.value]) {
	          expr = node.finishIdentifier(lex().value);
	      } else if (type === Token.StringLiteral || type === Token.NumericLiteral) {
	          if (strict && lookahead.octal) {
	              throwErrorTolerant(lookahead, Messages.StrictOctalLiteral);
	          }
	          expr = node.finishLiteral(lex());
	      } else if (type === Token.Keyword) {
	          throw new Error("Disabled.");
	      } else if (type === Token.BooleanLiteral) {
	          token = lex();
	          token.value = (token.value === 'true');
	          expr = node.finishLiteral(token);
	      } else if (type === Token.NullLiteral) {
	          token = lex();
	          token.value = null;
	          expr = node.finishLiteral(token);
	      } else if (match('/') || match('/=')) {
	          if (typeof extra.tokens !== 'undefined') {
	              expr = node.finishLiteral(collectRegex());
	          } else {
	              expr = node.finishLiteral(scanRegExp());
	          }
	          peek();
	      } else {
	          throwUnexpected(lex());
	      }
	
	      return expr;
	  }
	
	  // 11.2 Left-Hand-Side Expressions
	
	  function parseArguments() {
	      var args = [];
	
	      expect('(');
	
	      if (!match(')')) {
	          while (index < length) {
	              args.push(parseAssignmentExpression());
	              if (match(')')) {
	                  break;
	              }
	              expectTolerant(',');
	          }
	      }
	
	      expect(')');
	
	      return args;
	  }
	
	  function parseNonComputedProperty() {
	      var token, node = new Node();
	
	      token = lex();
	
	      if (!isIdentifierName(token)) {
	          throwUnexpected(token);
	      }
	
	      return node.finishIdentifier(token.value);
	  }
	
	  function parseNonComputedMember() {
	      expect('.');
	
	      return parseNonComputedProperty();
	  }
	
	  function parseComputedMember() {
	      var expr;
	
	      expect('[');
	
	      expr = parseExpression();
	
	      expect(']');
	
	      return expr;
	  }
	
	  function parseLeftHandSideExpressionAllowCall() {
	      var expr, args, property, startToken, previousAllowIn = state.allowIn;
	
	      startToken = lookahead;
	      state.allowIn = true;
	      expr = parsePrimaryExpression();
	
	      for (;;) {
	          if (match('.')) {
	              property = parseNonComputedMember();
	              expr = new WrappingNode(startToken).finishMemberExpression('.', expr, property);
	          } else if (match('(')) {
	              args = parseArguments();
	              expr = new WrappingNode(startToken).finishCallExpression(expr, args);
	          } else if (match('[')) {
	              property = parseComputedMember();
	              expr = new WrappingNode(startToken).finishMemberExpression('[', expr, property);
	          } else {
	              break;
	          }
	      }
	      state.allowIn = previousAllowIn;
	
	      return expr;
	  }
	
	  // 11.3 Postfix Expressions
	
	  function parsePostfixExpression() {
	      var expr = parseLeftHandSideExpressionAllowCall();
	
	      if (lookahead.type === Token.Punctuator) {
	          if ((match('++') || match('--')) && !peekLineTerminator()) {
	              throw new Error("Disabled.");
	          }
	      }
	
	      return expr;
	  }
	
	  // 11.4 Unary Operators
	
	  function parseUnaryExpression() {
	      var token, expr, startToken;
	
	      if (lookahead.type !== Token.Punctuator && lookahead.type !== Token.Keyword) {
	          expr = parsePostfixExpression();
	      } else if (match('++') || match('--')) {
	          throw new Error("Disabled.");
	      } else if (match('+') || match('-') || match('~') || match('!')) {
	          startToken = lookahead;
	          token = lex();
	          expr = parseUnaryExpression();
	          expr = new WrappingNode(startToken).finishUnaryExpression(token.value, expr);
	      } else if (matchKeyword('delete') || matchKeyword('void') || matchKeyword('typeof')) {
	          throw new Error("Disabled.");
	      } else {
	          expr = parsePostfixExpression();
	      }
	
	      return expr;
	  }
	
	  function binaryPrecedence(token, allowIn) {
	      var prec = 0;
	
	      if (token.type !== Token.Punctuator && token.type !== Token.Keyword) {
	          return 0;
	      }
	
	      switch (token.value) {
	      case '||':
	          prec = 1;
	          break;
	
	      case '&&':
	          prec = 2;
	          break;
	
	      case '|':
	          prec = 3;
	          break;
	
	      case '^':
	          prec = 4;
	          break;
	
	      case '&':
	          prec = 5;
	          break;
	
	      case '==':
	      case '!=':
	      case '===':
	      case '!==':
	          prec = 6;
	          break;
	
	      case '<':
	      case '>':
	      case '<=':
	      case '>=':
	      case 'instanceof':
	          prec = 7;
	          break;
	
	      case 'in':
	          prec = allowIn ? 7 : 0;
	          break;
	
	      case '<<':
	      case '>>':
	      case '>>>':
	          prec = 8;
	          break;
	
	      case '+':
	      case '-':
	          prec = 9;
	          break;
	
	      case '*':
	      case '/':
	      case '%':
	          prec = 11;
	          break;
	
	      default:
	          break;
	      }
	
	      return prec;
	  }
	
	  // 11.5 Multiplicative Operators
	  // 11.6 Additive Operators
	  // 11.7 Bitwise Shift Operators
	  // 11.8 Relational Operators
	  // 11.9 Equality Operators
	  // 11.10 Binary Bitwise Operators
	  // 11.11 Binary Logical Operators
	
	  function parseBinaryExpression() {
	      var marker, markers, expr, token, prec, stack, right, operator, left, i;
	
	      marker = lookahead;
	      left = parseUnaryExpression();
	
	      token = lookahead;
	      prec = binaryPrecedence(token, state.allowIn);
	      if (prec === 0) {
	          return left;
	      }
	      token.prec = prec;
	      lex();
	
	      markers = [marker, lookahead];
	      right = parseUnaryExpression();
	
	      stack = [left, token, right];
	
	      while ((prec = binaryPrecedence(lookahead, state.allowIn)) > 0) {
	
	          // Reduce: make a binary expression from the three topmost entries.
	          while ((stack.length > 2) && (prec <= stack[stack.length - 2].prec)) {
	              right = stack.pop();
	              operator = stack.pop().value;
	              left = stack.pop();
	              markers.pop();
	              expr = new WrappingNode(markers[markers.length - 1]).finishBinaryExpression(operator, left, right);
	              stack.push(expr);
	          }
	
	          // Shift.
	          token = lex();
	          token.prec = prec;
	          stack.push(token);
	          markers.push(lookahead);
	          expr = parseUnaryExpression();
	          stack.push(expr);
	      }
	
	      // Final reduce to clean-up the stack.
	      i = stack.length - 1;
	      expr = stack[i];
	      markers.pop();
	      while (i > 1) {
	          expr = new WrappingNode(markers.pop()).finishBinaryExpression(stack[i - 1].value, stack[i - 2], expr);
	          i -= 2;
	      }
	
	      return expr;
	  }
	
	  // 11.12 Conditional Operator
	
	  function parseConditionalExpression() {
	      var expr, previousAllowIn, consequent, alternate, startToken;
	
	      startToken = lookahead;
	
	      expr = parseBinaryExpression();
	
	      if (match('?')) {
	          lex();
	          previousAllowIn = state.allowIn;
	          state.allowIn = true;
	          consequent = parseAssignmentExpression();
	          state.allowIn = previousAllowIn;
	          expect(':');
	          alternate = parseAssignmentExpression();
	
	          expr = new WrappingNode(startToken).finishConditionalExpression(expr, consequent, alternate);
	      }
	
	      return expr;
	  }
	
	  // 11.13 Assignment Operators
	
	  function parseAssignmentExpression() {
	      var oldParenthesisCount, token, expr, startToken;
	
	      oldParenthesisCount = state.parenthesisCount;
	
	      startToken = lookahead;
	      token = lookahead;
	
	      expr = parseConditionalExpression();
	
	      return expr;
	  }
	
	  // 11.14 Comma Operator
	
	  function parseExpression() {
	      var expr = parseAssignmentExpression();
	
	      if (match(',')) {
	          throw new Error("Disabled."); // no sequence expressions
	      }
	
	      return expr;
	  }
	
	  // 12.4 Expression Statement
	
	  function parseExpressionStatement(node) {
	      var expr = parseExpression();
	      consumeSemicolon();
	      return node.finishExpressionStatement(expr);
	  }
	
	  // 12 Statements
	
	  function parseStatement() {
	      var type = lookahead.type,
	          expr,
	          node;
	
	      if (type === Token.EOF) {
	          throwUnexpected(lookahead);
	      }
	
	      if (type === Token.Punctuator && lookahead.value === '{') {
	          throw new Error("Disabled."); // block statement
	      }
	
	      node = new Node();
	
	      if (type === Token.Punctuator) {
	          switch (lookahead.value) {
	          case ';':
	              throw new Error("Disabled."); // empty statement
	          case '(':
	              return parseExpressionStatement(node);
	          default:
	              break;
	          }
	      } else if (type === Token.Keyword) {
	          throw new Error("Disabled."); // keyword
	      }
	
	      expr = parseExpression();
	      consumeSemicolon();
	      return node.finishExpressionStatement(expr);
	  }
	
	  // 14 Program
	
	  function parseSourceElement() {
	      if (lookahead.type === Token.Keyword) {
	          switch (lookahead.value) {
	          case 'const':
	          case 'let':
	              throw new Error("Disabled.");
	          case 'function':
	              throw new Error("Disabled.");
	          default:
	              return parseStatement();
	          }
	      }
	
	      if (lookahead.type !== Token.EOF) {
	          return parseStatement();
	      }
	  }
	
	  function parseSourceElements() {
	      var sourceElement, sourceElements = [], token, directive, firstRestricted;
	
	      while (index < length) {
	          token = lookahead;
	          if (token.type !== Token.StringLiteral) {
	              break;
	          }
	
	          sourceElement = parseSourceElement();
	          sourceElements.push(sourceElement);
	          if (sourceElement.expression.type !== Syntax.Literal) {
	              // this is not directive
	              break;
	          }
	          directive = source.slice(token.start + 1, token.end - 1);
	          if (directive === 'use strict') {
	              strict = true;
	              if (firstRestricted) {
	                  throwErrorTolerant(firstRestricted, Messages.StrictOctalLiteral);
	              }
	          } else {
	              if (!firstRestricted && token.octal) {
	                  firstRestricted = token;
	              }
	          }
	      }
	
	      while (index < length) {
	          sourceElement = parseSourceElement();
	          if (typeof sourceElement === 'undefined') {
	              break;
	          }
	          sourceElements.push(sourceElement);
	      }
	      return sourceElements;
	  }
	
	  function parseProgram() {
	      var body, node;
	
	      skipComment();
	      peek();
	      node = new Node();
	      strict = true; // assume strict
	
	      body = parseSourceElements();
	      return node.finishProgram(body);
	  }
	
	  function filterTokenLocation() {
	      var i, entry, token, tokens = [];
	
	      for (i = 0; i < extra.tokens.length; ++i) {
	          entry = extra.tokens[i];
	          token = {
	              type: entry.type,
	              value: entry.value
	          };
	          if (entry.regex) {
	              token.regex = {
	                  pattern: entry.regex.pattern,
	                  flags: entry.regex.flags
	              };
	          }
	          if (extra.range) {
	              token.range = entry.range;
	          }
	          if (extra.loc) {
	              token.loc = entry.loc;
	          }
	          tokens.push(token);
	      }
	
	      extra.tokens = tokens;
	  }
	
	  function tokenize(code, options) {
	      var toString,
	          tokens;
	
	      toString = String;
	      if (typeof code !== 'string' && !(code instanceof String)) {
	          code = toString(code);
	      }
	
	      source = code;
	      index = 0;
	      lineNumber = (source.length > 0) ? 1 : 0;
	      lineStart = 0;
	      length = source.length;
	      lookahead = null;
	      state = {
	          allowIn: true,
	          labelSet: {},
	          inFunctionBody: false,
	          inIteration: false,
	          inSwitch: false,
	          lastCommentStart: -1
	      };
	
	      extra = {};
	
	      // Options matching.
	      options = options || {};
	
	      // Of course we collect tokens here.
	      options.tokens = true;
	      extra.tokens = [];
	      extra.tokenize = true;
	      // The following two fields are necessary to compute the Regex tokens.
	      extra.openParenToken = -1;
	      extra.openCurlyToken = -1;
	
	      extra.range = (typeof options.range === 'boolean') && options.range;
	      extra.loc = (typeof options.loc === 'boolean') && options.loc;
	
	      if (typeof options.tolerant === 'boolean' && options.tolerant) {
	          extra.errors = [];
	      }
	
	      try {
	          peek();
	          if (lookahead.type === Token.EOF) {
	              return extra.tokens;
	          }
	
	          lex();
	          while (lookahead.type !== Token.EOF) {
	              try {
	                  lex();
	              } catch (lexError) {
	                  if (extra.errors) {
	                      extra.errors.push(lexError);
	                      // We have to break on the first error
	                      // to avoid infinite loops.
	                      break;
	                  } else {
	                      throw lexError;
	                  }
	              }
	          }
	
	          filterTokenLocation();
	          tokens = extra.tokens;
	          if (typeof extra.errors !== 'undefined') {
	              tokens.errors = extra.errors;
	          }
	      } catch (e) {
	          throw e;
	      } finally {
	          extra = {};
	      }
	      return tokens;
	  }
	
	  function parse(code, options) {
	      var program, toString;
	
	      toString = String;
	      if (typeof code !== 'string' && !(code instanceof String)) {
	          code = toString(code);
	      }
	
	      source = code;
	      index = 0;
	      lineNumber = (source.length > 0) ? 1 : 0;
	      lineStart = 0;
	      length = source.length;
	      lookahead = null;
	      state = {
	          allowIn: true,
	          labelSet: {},
	          parenthesisCount: 0,
	          inFunctionBody: false,
	          inIteration: false,
	          inSwitch: false,
	          lastCommentStart: -1
	      };
	
	      extra = {};
	      if (typeof options !== 'undefined') {
	          extra.range = (typeof options.range === 'boolean') && options.range;
	          extra.loc = (typeof options.loc === 'boolean') && options.loc;
	
	          if (extra.loc && options.source !== null && options.source !== undefined) {
	              extra.source = toString(options.source);
	          }
	
	          if (typeof options.tokens === 'boolean' && options.tokens) {
	              extra.tokens = [];
	          }
	          if (typeof options.tolerant === 'boolean' && options.tolerant) {
	              extra.errors = [];
	          }
	      }
	
	      try {
	          program = parseProgram();
	          if (typeof extra.tokens !== 'undefined') {
	              filterTokenLocation();
	              program.tokens = extra.tokens;
	          }
	          if (typeof extra.errors !== 'undefined') {
	              program.errors = extra.errors;
	          }
	      } catch (e) {
	          throw e;
	      } finally {
	          extra = {};
	      }
	
	      return program;
	  }
	
	  return {
	    tokenize: tokenize,
	    parse: parse
	  };
	
	})();

/***/ },
/* 138 */
/***/ function(module, exports, __webpack_require__) {

	function toMap(list) {
	  var map = {}, i, n;
	  for (i=0, n=list.length; i<n; ++i) map[list[i]] = 1;
	  return map;
	}
	
	function keys(object) {
	  var list = [], k;
	  for (k in object) list.push(k);
	  return list;
	}
	
	module.exports = function(opt) {
	  opt = opt || {};
	  var constants = opt.constants || __webpack_require__(139),
	      functions = (opt.functions || __webpack_require__(140))(codegen),
	      functionDefs = opt.functionDefs ? opt.functionDefs(codegen) : {},
	      idWhiteList = opt.idWhiteList ? toMap(opt.idWhiteList) : null,
	      idBlackList = opt.idBlackList ? toMap(opt.idBlackList) : null,
	      memberDepth = 0,
	      FIELD_VAR = opt.fieldVar || 'datum',
	      GLOBAL_VAR = opt.globalVar || 'signals',
	      globals = {},
	      fields = {},
	      dataSources = {};
	
	  function codegen_wrap(ast) {
	    var retval = {
	      code: codegen(ast),
	      globals: keys(globals),
	      fields: keys(fields),
	      dataSources: keys(dataSources),
	      defs: functionDefs
	    };
	    globals = {};
	    fields = {};
	    dataSources = {};
	    return retval;
	  }
	
	  /* istanbul ignore next */
	  var lookupGlobal = typeof GLOBAL_VAR === 'function' ? GLOBAL_VAR :
	    function (id) {
	      return GLOBAL_VAR + '["' + id + '"]';
	    };
	
	  function codegen(ast) {
	    if (typeof ast === 'string') return ast;
	    var generator = CODEGEN_TYPES[ast.type];
	    if (generator == null) {
	      throw new Error('Unsupported type: ' + ast.type);
	    }
	    return generator(ast);
	  }
	
	  var CODEGEN_TYPES = {
	    'Literal': function(n) {
	        return n.raw;
	      },
	    'Identifier': function(n) {
	        var id = n.name;
	        if (memberDepth > 0) {
	          return id;
	        }
	        if (constants.hasOwnProperty(id)) {
	          return constants[id];
	        }
	        if (idWhiteList) {
	          if (idWhiteList.hasOwnProperty(id)) {
	            return id;
	          } else {
	            globals[id] = 1;
	            return lookupGlobal(id);
	          }
	        }
	        if (idBlackList && idBlackList.hasOwnProperty(id)) {
	          throw new Error('Illegal identifier: ' + id);
	        }
	        return id;
	      },
	    'Program': function(n) {
	        return n.body.map(codegen).join('\n');
	      },
	    'MemberExpression': function(n) {
	        var d = !n.computed;
	        var o = codegen(n.object);
	        if (d) memberDepth += 1;
	        var p = codegen(n.property);
	        if (o === FIELD_VAR) { fields[p] = 1; } // HACKish...
	        if (d) memberDepth -= 1;
	        return o + (d ? '.'+p : '['+p+']');
	      },
	    'CallExpression': function(n) {
	        if (n.callee.type !== 'Identifier') {
	          throw new Error('Illegal callee type: ' + n.callee.type);
	        }
	        var callee = n.callee.name;
	        var args = n.arguments;
	        var fn = functions.hasOwnProperty(callee) && functions[callee];
	        if (!fn) throw new Error('Unrecognized function: ' + callee);
	        return fn instanceof Function ?
	          fn(args, globals, fields, dataSources) :
	          fn + '(' + args.map(codegen).join(',') + ')';
	      },
	    'ArrayExpression': function(n) {
	        return '[' + n.elements.map(codegen).join(',') + ']';
	      },
	    'BinaryExpression': function(n) {
	        return '(' + codegen(n.left) + n.operator + codegen(n.right) + ')';
	      },
	    'UnaryExpression': function(n) {
	        return '(' + n.operator + codegen(n.argument) + ')';
	      },
	    'ConditionalExpression': function(n) {
	        return '(' + codegen(n.test) +
	          '?' + codegen(n.consequent) +
	          ':' + codegen(n.alternate) +
	          ')';
	      },
	    'LogicalExpression': function(n) {
	        return '(' + codegen(n.left) + n.operator + codegen(n.right) + ')';
	      },
	    'ObjectExpression': function(n) {
	        return '{' + n.properties.map(codegen).join(',') + '}';
	      },
	    'Property': function(n) {
	        memberDepth += 1;
	        var k = codegen(n.key);
	        memberDepth -= 1;
	        return k + ':' + codegen(n.value);
	      },
	    'ExpressionStatement': function(n) {
	        return codegen(n.expression);
	      }
	  };
	
	  codegen_wrap.functions = functions;
	  codegen_wrap.functionDefs = functionDefs;
	  codegen_wrap.constants = constants;
	  return codegen_wrap;
	};


/***/ },
/* 139 */
/***/ function(module, exports) {

	module.exports = {
	  'NaN':     'NaN',
	  'E':       'Math.E',
	  'LN2':     'Math.LN2',
	  'LN10':    'Math.LN10',
	  'LOG2E':   'Math.LOG2E',
	  'LOG10E':  'Math.LOG10E',
	  'PI':      'Math.PI',
	  'SQRT1_2': 'Math.SQRT1_2',
	  'SQRT2':   'Math.SQRT2'
	};

/***/ },
/* 140 */
/***/ function(module, exports) {

	module.exports = function(codegen) {
	
	  function fncall(name, args, cast, type)