
import argparse
import utm

parser = argparse.ArgumentParser(description='Bidirectional UTM-WGS84 converter for python')
subparsers = parser.add_subparsers()

parser_latlon = subparsers.add_parser('latlon', help='Convert a latitude/longitude pair WGS84 to UTM')
parser_latlon.add_argument('latitude', type=float, help='Latitude of the WGS84 coordinate')
parser_latlon.add_argument('longitude', type=float, help='Longitude of the WGS84 coordinate')

parser_utm = subparsers.add_parser('utm', help='Convert a UTM coordinate to WGS84')
parser_utm.add_argument('easting', type=int, help='Easting component of the UTM coordinate')
parser_utm.add_argument('northing', type=int, help='Northing component of the UTM coordinate')
parser_utm.add_argument('zone_number', type=int, help='Zone number of the UTM coordinate')
parser_utm.add_argument('zone_letter', help='Zone letter of the UTM coordinate')

args = parser.parse_args()

if all(arg in args for arg in ['easting', 'northing', 'zone_number', 'zone_letter']):
    if args.zone_letter == '':
        parser_utm.print_usage()
        print "utm-converter utm: error: too few arguments"
        exit()

    coordinate = utm.to_latlon(args.easting, args.northing,
                        args.zone_number, args.zone_letter)

elif all(arg in args for arg in ['latitude', 'longitude']):
    coordinate = utm.from_latlon(args.latitude, args.longitude)

print ','.join([str(component) for component in coordinate])
