from . import AWSObject, AWSProperty, Tags
from .compat import policytypes


class LifecyclePolicy(AWSProperty):
    props = {
        'LifecyclePolicyText': (str, False),
        'RegistryId': (str, False),
    }


class Repository(AWSObject):
    resource_type = "AWS::ECR::Repository"

    props = {
        'LifecyclePolicy': (LifecyclePolicy, False),
        'RepositoryName': (str, False),
        'RepositoryPolicyText': (policytypes, False),
        'Tags': (Tags, False),
    }
