# Copyright (c) 2012-2019, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 8.1.0


from . import AWSObject
from . import AWSProperty
from .validators import integer


class RoutingStrategy(AWSProperty):
    props = {
        'FleetId': (str, False),
        'Message': (str, False),
        'Type': (str, True),
    }


class Alias(AWSObject):
    resource_type = "AWS::GameLift::Alias"

    props = {
        'Description': (str, False),
        'Name': (str, True),
        'RoutingStrategy': (RoutingStrategy, True),
    }


class S3Location(AWSProperty):
    props = {
        'Bucket': (str, True),
        'Key': (str, True),
        'ObjectVersion': (str, False),
        'RoleArn': (str, True),
    }


class Build(AWSObject):
    resource_type = "AWS::GameLift::Build"

    props = {
        'Name': (str, False),
        'OperatingSystem': (str, False),
        'StorageLocation': (S3Location, False),
        'Version': (str, False),
    }


class CertificateConfiguration(AWSProperty):
    props = {
        'CertificateType': (str, True),
    }


class IpPermission(AWSProperty):
    props = {
        'FromPort': (integer, True),
        'IpRange': (str, True),
        'Protocol': (str, True),
        'ToPort': (integer, True),
    }


class ResourceCreationLimitPolicy(AWSProperty):
    props = {
        'NewGameSessionsPerCreator': (integer, False),
        'PolicyPeriodInMinutes': (integer, False),
    }


class ServerProcess(AWSProperty):
    props = {
        'ConcurrentExecutions': (integer, True),
        'LaunchPath': (str, True),
        'Parameters': (str, False),
    }


class RuntimeConfiguration(AWSProperty):
    props = {
        'GameSessionActivationTimeoutSeconds': (integer, False),
        'MaxConcurrentGameSessionActivations': (integer, False),
        'ServerProcesses': ([ServerProcess], False),
    }


class Fleet(AWSObject):
    resource_type = "AWS::GameLift::Fleet"

    props = {
        'BuildId': (str, False),
        'CertificateConfiguration': (CertificateConfiguration, False),
        'Description': (str, False),
        'DesiredEC2Instances': (integer, False),
        'EC2InboundPermissions': ([IpPermission], False),
        'EC2InstanceType': (str, True),
        'FleetType': (str, False),
        'InstanceRoleARN': (str, False),
        'LogPaths': ([str], False),
        'MaxSize': (integer, False),
        'MetricGroups': ([str], False),
        'MinSize': (integer, False),
        'Name': (str, True),
        'NewGameSessionProtectionPolicy': (str, False),
        'PeerVpcAwsAccountId': (str, False),
        'PeerVpcId': (str, False),
        'ResourceCreationLimitPolicy': (ResourceCreationLimitPolicy, False),
        'RuntimeConfiguration': (RuntimeConfiguration, False),
        'ScriptId': (str, False),
        'ServerLaunchParameters': (str, False),
        'ServerLaunchPath': (str, False),
    }
