# Copyright (c) 2012-2019, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 6.1.0


from . import AWSObject
from . import AWSProperty
from troposphere import Tags
from .validators import boolean
from .validators import integer


class EgressFilter(AWSProperty):
    props = {
        'Type': (str, True),
    }


class MeshSpec(AWSProperty):
    props = {
        'EgressFilter': (EgressFilter, False),
    }


class Mesh(AWSObject):
    resource_type = "AWS::AppMesh::Mesh"

    props = {
        'MeshName': (str, True),
        'Spec': (MeshSpec, False),
        'Tags': (Tags, False),
    }


class Duration(AWSProperty):
    props = {
        'Unit': (str, True),
        'Value': (integer, True),
    }


class HttpRetryPolicy(AWSProperty):
    props = {
        'HttpRetryEvents': ([str], False),
        'MaxRetries': (integer, True),
        'PerRetryTimeout': (Duration, True),
        'TcpRetryEvents': ([str], False),
    }


class WeightedTarget(AWSProperty):
    props = {
        'VirtualNode': (str, True),
        'Weight': (integer, True),
    }


class HttpRouteAction(AWSProperty):
    props = {
        'WeightedTargets': ([WeightedTarget], True),
    }


class MatchRange(AWSProperty):
    props = {
        'End': (integer, True),
        'Start': (integer, True),
    }


class HeaderMatchMethod(AWSProperty):
    props = {
        'Exact': (str, False),
        'Prefix': (str, False),
        'Range': (MatchRange, False),
        'Regex': (str, False),
        'Suffix': (str, False),
    }


class HttpRouteHeader(AWSProperty):
    props = {
        'Invert': (boolean, False),
        'Match': (HeaderMatchMethod, False),
        'Name': (str, True),
    }


class HttpRouteMatch(AWSProperty):
    props = {
        'Headers': ([HttpRouteHeader], False),
        'Method': (str, False),
        'Prefix': (str, True),
        'Scheme': (str, False),
    }


class HttpRoute(AWSProperty):
    props = {
        'Action': (HttpRouteAction, True),
        'Match': (HttpRouteMatch, True),
        'RetryPolicy': (HttpRetryPolicy, False),
    }


class TcpRouteAction(AWSProperty):
    props = {
        'WeightedTargets': ([WeightedTarget], True),
    }


class TcpRoute(AWSProperty):
    props = {
        'Action': (TcpRouteAction, True),
    }


class RouteSpec(AWSProperty):
    props = {
        'HttpRoute': (HttpRoute, False),
        'Priority': (integer, False),
        'TcpRoute': (TcpRoute, False),
    }


class Route(AWSObject):
    resource_type = "AWS::AppMesh::Route"

    props = {
        'MeshName': (str, True),
        'RouteName': (str, True),
        'Spec': (RouteSpec, True),
        'Tags': (Tags, False),
        'VirtualRouterName': (str, True),
    }


class VirtualServiceBackend(AWSProperty):
    props = {
        'VirtualServiceName': (str, True),
    }


class Backend(AWSProperty):
    props = {
        'VirtualService': (VirtualServiceBackend, False),
    }


class HealthCheck(AWSProperty):
    props = {
        'HealthyThreshold': (integer, True),
        'IntervalMillis': (integer, True),
        'Path': (str, False),
        'Port': (integer, False),
        'Protocol': (str, True),
        'TimeoutMillis': (integer, True),
        'UnhealthyThreshold': (integer, True),
    }


class PortMapping(AWSProperty):
    props = {
        'Port': (integer, True),
        'Protocol': (str, True),
    }


class Listener(AWSProperty):
    props = {
        'HealthCheck': (HealthCheck, False),
        'PortMapping': (PortMapping, True),
    }


class FileAccessLog(AWSProperty):
    props = {
        'Path': (str, True),
    }


class AccessLog(AWSProperty):
    props = {
        'File': (FileAccessLog, False),
    }


class Logging(AWSProperty):
    props = {
        'AccessLog': (AccessLog, False),
    }


class AwsCloudMapInstanceAttribute(AWSProperty):
    props = {
        'Key': (str, True),
        'Value': (str, True),
    }


class AwsCloudMapServiceDiscovery(AWSProperty):
    props = {
        'Attributes': ([AwsCloudMapInstanceAttribute], False),
        'NamespaceName': (str, True),
        'ServiceName': (str, True),
    }


class DnsServiceDiscovery(AWSProperty):
    props = {
        'Hostname': (str, True),
    }


class ServiceDiscovery(AWSProperty):
    props = {
        'AWSCloudMap': (AwsCloudMapServiceDiscovery, False),
        'DNS': (DnsServiceDiscovery, False),
    }


class VirtualNodeSpec(AWSProperty):
    props = {
        'Backends': ([Backend], False),
        'Listeners': ([Listener], False),
        'Logging': (Logging, False),
        'ServiceDiscovery': (ServiceDiscovery, False),
    }


class VirtualNode(AWSObject):
    resource_type = "AWS::AppMesh::VirtualNode"

    props = {
        'MeshName': (str, True),
        'Spec': (VirtualNodeSpec, True),
        'Tags': (Tags, False),
        'VirtualNodeName': (str, True),
    }


class VirtualRouterListener(AWSProperty):
    props = {
        'PortMapping': (PortMapping, True),
    }


class VirtualRouterSpec(AWSProperty):
    props = {
        'Listeners': ([VirtualRouterListener], True),
    }


class VirtualRouter(AWSObject):
    resource_type = "AWS::AppMesh::VirtualRouter"

    props = {
        'MeshName': (str, True),
        'Spec': (VirtualRouterSpec, True),
        'Tags': (Tags, False),
        'VirtualRouterName': (str, True),
    }


class VirtualNodeServiceProvider(AWSProperty):
    props = {
        'VirtualNodeName': (str, True),
    }


class VirtualRouterServiceProvider(AWSProperty):
    props = {
        'VirtualRouterName': (str, True),
    }


class VirtualServiceProvider(AWSProperty):
    props = {
        'VirtualNode': (VirtualNodeServiceProvider, False),
        'VirtualRouter': (VirtualRouterServiceProvider, False),
    }


class VirtualServiceSpec(AWSProperty):
    props = {
        'Provider': (VirtualServiceProvider, False),
    }


class VirtualService(AWSObject):
    resource_type = "AWS::AppMesh::VirtualService"

    props = {
        'MeshName': (str, True),
        'Spec': (VirtualServiceSpec, True),
        'Tags': (Tags, False),
        'VirtualServiceName': (str, True),
    }
