# Copyright (c) 2012-2019, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 3.4.0


from . import AWSObject
from . import AWSProperty
from troposphere import Tags
from .validators import boolean


class BasicAuthConfig(AWSProperty):
    props = {
        'EnableBasicAuth': (boolean, False),
        'Password': (basestring, True),
        'Username': (basestring, True),
    }


class CustomRule(AWSProperty):
    props = {
        'Condition': (basestring, False),
        'Source': (basestring, True),
        'Status': (basestring, False),
        'Target': (basestring, True),
    }


class EnvironmentVariable(AWSProperty):
    props = {
        'Name': (basestring, True),
        'Value': (basestring, True),
    }


class AutoBranchCreationConfig(AWSProperty):
    props = {
        'AutoBranchCreationPatterns': ([basestring], False),
        'BasicAuthConfig': (BasicAuthConfig, False),
        'BuildSpec': (basestring, False),
        'EnableAutoBranchCreation': (boolean, False),
        'EnableAutoBuild': (boolean, False),
        'EnvironmentVariables': ([EnvironmentVariable], False),
        'Stage': (basestring, False),
    }


class App(AWSObject):
    resource_type = "AWS::Amplify::App"

    props = {
        'AccessToken': (basestring, False),
        'AutoBranchCreationConfig': (AutoBranchCreationConfig, False),
        'BasicAuthConfig': (BasicAuthConfig, False),
        'BuildSpec': (basestring, False),
        'CustomRules': ([CustomRule], False),
        'Description': (basestring, False),
        'EnvironmentVariables': ([EnvironmentVariable], False),
        'IAMServiceRole': (basestring, False),
        'Name': (basestring, True),
        'OauthToken': (basestring, False),
        'Repository': (basestring, True),
        'Tags': (Tags, False),
    }


class Branch(AWSObject):
    resource_type = "AWS::Amplify::Branch"

    props = {
        'AppId': (basestring, True),
        'BasicAuthConfig': (BasicAuthConfig, False),
        'BranchName': (basestring, True),
        'BuildSpec': (basestring, False),
        'Description': (basestring, False),
        'EnableAutoBuild': (boolean, False),
        'EnvironmentVariables': ([EnvironmentVariable], False),
        'Stage': (basestring, False),
        'Tags': (Tags, False),
    }


class SubDomainSetting(AWSProperty):
    props = {
        'BranchName': (basestring, True),
        'Prefix': (basestring, True),
    }


class Domain(AWSObject):
    resource_type = "AWS::Amplify::Domain"

    props = {
        'AppId': (basestring, True),
        'DomainName': (basestring, True),
        'SubDomainSettings': ([SubDomainSetting], True),
    }
