# Copyright (c) 2012-2019, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 3.3.0


from . import AWSObject
from . import AWSProperty
from troposphere import Tags
from .validators import boolean


class DeliveryOptions(AWSProperty):
    props = {
        'SendingPoolName': (basestring, False),
    }


class ReputationOptions(AWSProperty):
    props = {
        'ReputationMetricsEnabled': (boolean, False),
    }


class SendingOptions(AWSProperty):
    props = {
        'SendingEnabled': (boolean, False),
    }


class TrackingOptions(AWSProperty):
    props = {
        'CustomRedirectDomain': (basestring, False),
    }


class ConfigurationSet(AWSObject):
    resource_type = "AWS::PinpointEmail::ConfigurationSet"

    props = {
        'DeliveryOptions': (DeliveryOptions, False),
        'Name': (basestring, True),
        'ReputationOptions': (ReputationOptions, False),
        'SendingOptions': (SendingOptions, False),
        'Tags': (Tags, False),
        'TrackingOptions': (TrackingOptions, False),
    }


class DimensionConfiguration(AWSProperty):
    props = {
        'DefaultDimensionValue': (basestring, True),
        'DimensionName': (basestring, True),
        'DimensionValueSource': (basestring, True),
    }


class CloudWatchDestination(AWSProperty):
    props = {
        'DimensionConfigurations': ([DimensionConfiguration], False),
    }


class KinesisFirehoseDestination(AWSProperty):
    props = {
        'DeliveryStreamArn': (basestring, True),
        'IamRoleArn': (basestring, True),
    }


class PinpointDestination(AWSProperty):
    props = {
        'ApplicationArn': (basestring, False),
    }


class SnsDestination(AWSProperty):
    props = {
        'TopicArn': (basestring, True),
    }


class EventDestination(AWSProperty):
    props = {
        'CloudWatchDestination': (CloudWatchDestination, False),
        'Enabled': (boolean, False),
        'KinesisFirehoseDestination': (KinesisFirehoseDestination, False),
        'MatchingEventTypes': ([basestring], True),
        'PinpointDestination': (PinpointDestination, False),
        'SnsDestination': (SnsDestination, False),
    }


class ConfigurationSetEventDestination(AWSObject):
    resource_type = "AWS::PinpointEmail::ConfigurationSetEventDestination"

    props = {
        'ConfigurationSetName': (basestring, True),
        'EventDestination': (EventDestination, False),
        'EventDestinationName': (basestring, True),
    }


class DedicatedIpPool(AWSObject):
    resource_type = "AWS::PinpointEmail::DedicatedIpPool"

    props = {
        'PoolName': (basestring, False),
        'Tags': (Tags, False),
    }


class MailFromAttributes(AWSProperty):
    props = {
        'BehaviorOnMxFailure': (basestring, False),
        'MailFromDomain': (basestring, False),
    }


class Identity(AWSObject):
    resource_type = "AWS::PinpointEmail::Identity"

    props = {
        'DkimSigningEnabled': (boolean, False),
        'FeedbackForwardingEnabled': (boolean, False),
        'MailFromAttributes': (MailFromAttributes, False),
        'Name': (basestring, True),
        'Tags': (Tags, False),
    }
