# Copyright (c) 2012-2019, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 5.3.0


from . import AWSObject
from . import AWSProperty
from .validators import integer


class MemberFabricConfiguration(AWSProperty):
    props = {
        'AdminPassword': (basestring, True),
        'AdminUsername': (basestring, True),
    }


class MemberFrameworkConfiguration(AWSProperty):
    props = {
        'MemberFabricConfiguration': (MemberFabricConfiguration, False),
    }


class MemberConfiguration(AWSProperty):
    props = {
        'Description': (basestring, False),
        'MemberFrameworkConfiguration':
            (MemberFrameworkConfiguration, False),
        'Name': (basestring, True),
    }


class NetworkFabricConfiguration(AWSProperty):
    props = {
        'Edition': (basestring, True),
    }


class NetworkFrameworkConfiguration(AWSProperty):
    props = {
        'NetworkFabricConfiguration': (NetworkFabricConfiguration, False),
    }


class ApprovalThresholdPolicy(AWSProperty):
    props = {
        'ProposalDurationInHours': (integer, False),
        'ThresholdComparator': (basestring, False),
        'ThresholdPercentage': (integer, False),
    }


class VotingPolicy(AWSProperty):
    props = {
        'ApprovalThresholdPolicy': (ApprovalThresholdPolicy, False),
    }


class NetworkConfiguration(AWSProperty):
    props = {
        'Description': (basestring, False),
        'Framework': (basestring, True),
        'FrameworkVersion': (basestring, True),
        'Name': (basestring, True),
        'NetworkFrameworkConfiguration':
            (NetworkFrameworkConfiguration, False),
        'VotingPolicy': (VotingPolicy, True),
    }


class Member(AWSObject):
    resource_type = "AWS::ManagedBlockchain::Member"

    props = {
        'InvitationId': (basestring, False),
        'MemberConfiguration': (MemberConfiguration, True),
        'NetworkConfiguration': (NetworkConfiguration, False),
        'NetworkId': (basestring, False),
    }


class NodeConfiguration(AWSProperty):
    props = {
        'AvailabilityZone': (basestring, True),
        'InstanceType': (basestring, True),
    }


class Node(AWSObject):
    resource_type = "AWS::ManagedBlockchain::Node"

    props = {
        'MemberId': (basestring, True),
        'NetworkId': (basestring, True),
        'NodeConfiguration': (NodeConfiguration, True),
    }
