# Copyright (c) 2012-2019, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 4.3.0


from . import AWSObject
from . import AWSProperty
from troposphere import Tags
from .validators import boolean
from .validators import integer


class ClearTimer(AWSProperty):
    props = {
        'TimerName': (basestring, False),
    }


class Firehose(AWSProperty):
    props = {
        'DeliveryStreamName': (basestring, False),
        'Separator': (basestring, False),
    }


class IotEvents(AWSProperty):
    props = {
        'InputName': (basestring, False),
    }


class IotTopicPublish(AWSProperty):
    props = {
        'MqttTopic': (basestring, False),
    }


class Lambda(AWSProperty):
    props = {
        'FunctionArn': (basestring, False),
    }


class ResetTimer(AWSProperty):
    props = {
        'TimerName': (basestring, False),
    }


class SetTimer(AWSProperty):
    props = {
        'Seconds': (integer, False),
        'TimerName': (basestring, False),
    }


class SetVariable(AWSProperty):
    props = {
        'Value': (basestring, False),
        'VariableName': (basestring, False),
    }


class Sns(AWSProperty):
    props = {
        'TargetArn': (basestring, False),
    }


class Sqs(AWSProperty):
    props = {
        'QueueUrl': (basestring, False),
        'UseBase64': (boolean, False),
    }


class Action(AWSProperty):
    props = {
        'ClearTimer': (ClearTimer, False),
        'Firehose': (Firehose, False),
        'IotEvents': (IotEvents, False),
        'IotTopicPublish': (IotTopicPublish, False),
        'Lambda': (Lambda, False),
        'ResetTimer': (ResetTimer, False),
        'SetTimer': (SetTimer, False),
        'SetVariable': (SetVariable, False),
        'Sns': (Sns, False),
        'Sqs': (Sqs, False),
    }


class Event(AWSProperty):
    props = {
        'Actions': ([Action], False),
        'Condition': (basestring, False),
        'EventName': (basestring, False),
    }


class OnEnter(AWSProperty):
    props = {
        'Events': ([Event], False),
    }


class OnExit(AWSProperty):
    props = {
        'Events': ([Event], False),
    }


class TransitionEvent(AWSProperty):
    props = {
        'Actions': ([Action], False),
        'Condition': (basestring, False),
        'EventName': (basestring, False),
        'NextState': (basestring, False),
    }


class OnInput(AWSProperty):
    props = {
        'Events': ([Event], False),
        'TransitionEvents': ([TransitionEvent], False),
    }


class State(AWSProperty):
    props = {
        'OnEnter': (OnEnter, False),
        'OnExit': (OnExit, False),
        'OnInput': (OnInput, False),
        'StateName': (basestring, False),
    }


class DetectorModelDefinition(AWSProperty):
    props = {
        'InitialStateName': (basestring, False),
        'States': ([State], False),
    }


class DetectorModel(AWSObject):
    resource_type = "AWS::IoTEvents::DetectorModel"

    props = {
        'DetectorModelDefinition': (DetectorModelDefinition, False),
        'DetectorModelDescription': (basestring, False),
        'DetectorModelName': (basestring, False),
        'Key': (basestring, False),
        'RoleArn': (basestring, False),
        'Tags': (Tags, False),
    }


class Attribute(AWSProperty):
    props = {
        'JsonPath': (basestring, False),
    }


class InputDefinition(AWSProperty):
    props = {
        'Attributes': ([Attribute], False),
    }


class Input(AWSObject):
    resource_type = "AWS::IoTEvents::Input"

    props = {
        'InputDefinition': (InputDefinition, False),
        'InputDescription': (basestring, False),
        'InputName': (basestring, False),
        'Tags': (Tags, False),
    }
