#
# Copyright (c) 2014-2021 National Technology and Engineering
# Solutions of Sandia, LLC. Under the terms of Contract DE-NA0003525
# with National Technology and Engineering Solutions of Sandia, LLC,
# the U.S. Government retains certain rights in this software.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
# FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
# COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
# ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

# -*- encoding: utf-8; -*-

"""
city_table.py - Position and population data for lots of cities
"""

#
# This code is derived from a list of cities provided by MaxMind at
# http://www.maxmind.com/en/worldcities.  Here is the license under
# which we use the data:
#
# OPEN DATA LICENSE for MaxMind WorldCities and Postal Code Databases
#
# Copyright (c) 2008 MaxMind Inc.  All Rights Reserved.
#
# The database uses toponymic information, based on the Geographic
# Names Data Base, containing official standard names approved by the
# United States Board on Geographic Names and maintained by the
# National Geospatial-Intelligence Agency. More information is
# available at the Maps and Geodata link at www.nga.mil. The National
# Geospatial-Intelligence Agency name, initials, and seal are
# protected by 10 United States Code Section 445.
#
# It also uses free population data from Stefan Helders www.world-gazetteer.com.
# Visit his website to download the free population data.  Our database
# combines Stefan's population data with the list of all cities in the world.
#
# All advertising materials and documentation mentioning features or
# use of this database must display the following acknowledgment:
# "This product includes data created by MaxMind, available from
# http://www.maxmind.com/"
#
# Redistribution and use with or without modification, are permitted provided
# that the following conditions are met:
#
# 1. Redistributions must retain the above copyright notice, this list of
# conditions and the following disclaimer in the documentation and/or other
# materials provided with the distribution.
#
# 2. All advertising materials and documentation mentioning features or use of
# this database must display the following acknowledgement:
# "This product includes data created by MaxMind, available from
# http://www.maxmind.com/"
#
# 3. "MaxMind" may not be used to endorse or promote products derived from this
# database without specific prior written permission.
#
# THIS DATABASE IS PROVIDED BY MAXMIND.COM ``AS IS'' AND ANY EXPRESS
# OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL MAXMIND.COM BE LIABLE FOR ANY
# DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
# GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
# IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
# OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS DATABASE, EVEN
# IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

table_headings = [ u"Country",u"AccentCity",'Population','Latitude','Longitude' ]
city_table = [
    [ u"ad",u"Andorra la Vella",20430,42.5,1.5166667 ],
    [ u"ad",u"Canillo",3292,42.5666667,1.6 ],
    [ u"ad",u"Encamp",11224,42.5333333,1.5833333 ],
    [ u"ad",u"La Massana",7211,42.55,1.5166667 ],
    [ u"ad",u"Les Escaldes",15854,42.5,1.5333333 ],
    [ u"ad",u"Ordino",2553,42.55,1.5333333 ],
    [ u"ad",u"Sant Julià de Lòria",8020,42.4666667,1.5 ],
    [ u"ae",u"Abu Dhabi",603687,24.466667,54.366667 ],
    [ u"ae",u"Dubai",1137376,25.258172,55.304717 ],
    [ u"ae",u"Sharjah",543942,25.35731,55.403304 ],
    [ u"af",u"Acin",15098,34.082481,70.668152 ],
    [ u"af",u"Anar Darreh",10023,32.758698,61.653969 ],
    [ u"af",u"Andarab",27034,35.633484,69.260195 ],
    [ u"af",u"Asadabad",48400,34.873113,71.14697 ],
    [ u"af",u"Asmar",15708,35.033328,71.358087 ],
    [ u"af",u"Aybak",47877,36.26468,68.015512 ],
    [ u"af",u"Azrow",12526,34.173553,69.645728 ],
    [ u"af",u"Baglan",108481,36.130684,68.708286 ],
    [ u"af",u"Bagrami",30256,34.493761,69.274274 ],
    [ u"af",u"Baraki Barak",22305,33.9675,68.948611 ],
    [ u"af",u"Cah Ab",23424,37.397734,69.814644 ],
    [ u"af",u"Carikar",53693,35.016585,69.174011 ],
    [ u"af",u"Ciras",12778,35.416737,65.982341 ],
    [ u"af",u"Dawlatabad",13603,36.432589,64.920713 ],
    [ u"af",u"Dawlatabad",17674,36.98782,66.82066 ],
    [ u"af",u"Deh Rawud",25683,32.624131,65.459659 ],
    [ u"af",u"Eskasem",12120,36.706932,71.570658 ],
    [ u"af",u"Farah",43574,32.374508,62.116383 ],
    [ u"af",u"Gardan Diwal",6815,34.508977,68.260739 ],
    [ u"af",u"Gardez",103732,33.597439,69.225922 ],
    [ u"af",u"Gazni",143049,33.550833,68.4225 ],
    [ u"af",u"Geresk",43638,31.820894,64.570048 ],
    [ u"af",u"Herat",272880,34.348167,62.199673 ],
    [ u"af",u"Jalalabad",200389,34.426468,70.45153 ],
    [ u"af",u"Jurm",12121,36.864768,70.834207 ],
    [ u"af",u"Kabul",3043589,34.516667,69.183333 ],
    [ u"af",u"Kholm",64954,36.697362,67.698255 ],
    [ u"af",u"Khowst",96246,33.339512,69.92041 ],
    [ u"af",u"Kuhestan",12087,34.653889,61.197778 ],
    [ u"af",u"Kusk",16952,33.29565,61.952206 ],
    [ u"af",u"Lar Gerd",11635,35.489361,66.664088 ],
    [ u"af",u"Mehtar Lam",17350,34.671389,70.209444 ],
    [ u"af",u"Mirabad",14160,30.436244,61.838304 ],
    [ u"af",u"Nahrin",22389,36.064904,69.13343 ],
    [ u"af",u"Nuristan",17072,34.95,70.4 ],
    [ u"af",u"Orgun",10665,32.901111,69.152798 ],
    [ u"af",u"Pagman",49173,34.5875,68.953333 ],
    [ u"af",u"Panjab",13471,34.387949,67.023273 ],
    [ u"af",u"Qandahar",391230,31.613323,65.710126 ],
    [ u"af",u"Qarchi Gak",8942,37.039988,66.788912 ],
    [ u"af",u"Qarqin",15023,37.404464,66.074375 ],
    [ u"af",u"Qunduz",161943,36.728955,68.857001 ],
    [ u"af",u"Rostaq",25644,37.126035,69.83045 ],
    [ u"af",u"Rudbar",11034,30.15,62.6 ],
    [ u"af",u"Sahrak",15967,34.107375,64.305199 ],
    [ u"af",u"Sangin",13579,32.072752,64.835903 ],
    [ u"af",u"Sar-e Pul",52138,36.215443,65.932487 ],
    [ u"af",u"Sharan",7368,33.146667,68.791667 ],
    [ u"af",u"Shibarghan",55658,36.667567,65.752904 ],
    [ u"af",u"Sindand",29273,33.302944,62.1474 ],
    [ u"af",u"Tagab",6400,34.855007,69.64917 ],
    [ u"af",u"Taloqan",64275,36.734133,69.533559 ],
    [ u"af",u"Taywarah",14398,33.521176,64.421156 ],
    [ u"af",u"Tir Pol",6979,34.594307,61.268951 ],
    [ u"af",u"Tokzar",12021,35.948308,66.42132 ],
    [ u"af",u"Uruzgan",13400,32.927751,66.632534 ],
    [ u"af",u"Zaranj",33894,30.966667,61.883333 ],
    [ u"ag",u"All Saints",2526,17.05,-61.8 ],
    [ u"ag",u"Carlisle",831,17.1333333,-61.8 ],
    [ u"ag",u"Codrington",682,17.6333333,-61.8333333 ],
    [ u"ag",u"Freetown",623,17.05,-61.7 ],
    [ u"ag",u"Liberta",1668,17.0333333,-61.7833333 ],
    [ u"ag",u"Old Road",623,17.0166667,-61.8333333 ],
    [ u"ag",u"Parham",969,17.0833333,-61.7666667 ],
    [ u"ag",u"Swetes",727,17.05,-61.8 ],
    [ u"ai",u"The Valley",1379,18.2166667,-63.05 ],
    [ u"al",u"Bajram Curri",7967,42.3572222,20.0730556 ],
    [ u"al",u"Ballsh",10361,40.5988889,19.7347222 ],
    [ u"al",u"Berat",47606,40.7058333,19.9522222 ],
    [ u"al",u"Bilisht",7114,40.6275,20.99 ],
    [ u"al",u"Bulqizë",11212,41.4916667,20.2219444 ],
    [ u"al",u"Burrel",15539,41.6102778,20.0088889 ],
    [ u"al",u"Cërrik",14269,41.0316667,19.9758333 ],
    [ u"al",u"Çorovodë",14046,40.5041667,20.2272222 ],
    [ u"al",u"Delvinë",3916,39.9511111,20.0977778 ],
    [ u"al",u"Durrës",122034,41.3230556,19.4413889 ],
    [ u"al",u"Elbasan",100903,41.1125,20.0822222 ],
    [ u"al",u"Ersekë",7890,40.3377778,20.6788889 ],
    [ u"al",u"Fier",59719,40.7238889,19.5561111 ],
    [ u"al",u"Fierzë",742,42.2647222,20.0269444 ],
    [ u"al",u"Fierzë",742,42.2605556,20.0169444 ],
    [ u"al",u"Fushë-Arrëz",2438,42.0622222,20.0166667 ],
    [ u"al",u"Fushë-Krujë",10458,41.4783333,19.7177778 ],
    [ u"al",u"Gjirokastër",23437,40.0758333,20.1388889 ],
    [ u"al",u"Gramsh",11556,40.8697222,20.1844444 ],
    [ u"al",u"Himarë",4596,40.1016667,19.7447222 ],
    [ u"al",u"Kamzë",11026,41.3816667,19.7602778 ],
    [ u"al",u"Kavajë",29354,41.1855556,19.5569444 ],
    [ u"al",u"Këlcyrë",2486,40.3130556,20.1894444 ],
    [ u"al",u"Kërrabë",1177,41.2155556,19.9713889 ],
    [ u"al",u"Klos",683,41.4844444,20.1080556 ],
    [ u"al",u"Konispol",1349,39.6588889,20.1813889 ],
    [ u"al",u"Koplik",4078,42.2136111,19.4363889 ],
    [ u"al",u"Korçë",58259,40.6186111,20.7808333 ],
    [ u"al",u"Krastë",1168,41.4225,20.205 ],
    [ u"al",u"Krujë",21286,41.5091667,19.7927778 ],
    [ u"al",u"Kuçovë",18166,40.8002778,19.9166667 ],
    [ u"al",u"Kukës",17972,42.0769444,20.4219444 ],
    [ u"al",u"Kurbnesh",1429,41.7797222,20.0836111 ],
    [ u"al",u"Laç",24825,41.6355556,19.7130556 ],
    [ u"al",u"Leskovik",2655,40.1513889,20.5972222 ],
    [ u"al",u"Lezhë",18695,41.7836111,19.6436111 ],
    [ u"al",u"Libohovë",3651,40.0311111,20.2630556 ],
    [ u"al",u"Librazhd",12691,41.1794444,20.315 ],
    [ u"al",u"Lushnjë",41423,40.9419444,19.705 ],
    [ u"al",u"Maliq",3735,40.7058333,20.6997222 ],
    [ u"al",u"Mamurras",8282,41.5775,19.6922222 ],
    [ u"al",u"Memaliaj",4951,40.3458333,19.9791667 ],
    [ u"al",u"Milot",2157,41.6802778,19.7244444 ],
    [ u"al",u"Orikum",2604,40.3252778,19.4713889 ],
    [ u"al",u"Patos",22679,40.6833333,19.6194444 ],
    [ u"al",u"Peqin",7513,41.0461111,19.7511111 ],
    [ u"al",u"Përmet",10686,40.2336111,20.3516667 ],
    [ u"al",u"Përrenjas",4015,41.0730556,20.5488889 ],
    [ u"al",u"Peshkopi",15261,41.685,20.4288889 ],
    [ u"al",u"Pogradec",25758,40.9025,20.6525 ],
    [ u"al",u"Poliçan",10663,40.6122222,20.0980556 ],
    [ u"al",u"Pukë",6495,42.0444444,19.8997222 ],
    [ u"al",u"Roskovec",6657,40.7375,19.7022222 ],
    [ u"al",u"Rrëshen",10064,41.7675,19.8755556 ],
    [ u"al",u"Rrogozhinë",5620,41.0763889,19.6652778 ],
    [ u"al",u"Rubik",2332,41.7744444,19.7861111 ],
    [ u"al",u"Sarandë",15147,39.8755556,20.0052778 ],
    [ u"al",u"Selenicë",6912,40.5305556,19.6358333 ],
    [ u"al",u"Shëngjin",2698,41.8136111,19.5938889 ],
    [ u"al",u"Shijak",14138,41.3455556,19.5672222 ],
    [ u"al",u"Shkodër",89102,42.0675,19.5130556 ],
    [ u"al",u"Tepelenë",11955,40.2958333,20.0191667 ],
    [ u"al",u"Tirana",374801,41.3275,19.8188889 ],
    [ u"al",u"Ulzë",600,41.6827778,19.8933333 ],
    [ u"al",u"Vlorë",89528,40.4666667,19.4897222 ],
    [ u"al",u"Vorë",4973,41.3908333,19.655 ],
    [ u"am",u"Abovyan",1379,40.0488889,44.5475 ],
    [ u"am",u"Abovyan",35677,40.2691667,44.6244444 ],
    [ u"am",u"Agarakadzor",1195,39.7363889,45.3455556 ],
    [ u"am",u"Agarak",1575,40.3077778,44.2847222 ],
    [ u"am",u"Agarak",1278,41.0105556,44.4675 ],
    [ u"am",u"Agarak",4707,39.2038889,46.5472222 ],
    [ u"am",u"Aghavnadzor",1252,40.5841667,44.6913889 ],
    [ u"am",u"Aghavnadzor",1925,39.7836111,45.2280556 ],
    [ u"am",u"Aghavnatun",2913,40.2336111,44.2513889 ],
    [ u"am",u"Akhuryan",7672,40.7813889,43.8963889 ],
    [ u"am",u"Aknalich",2654,40.1430556,44.1483333 ],
    [ u"am",u"Aknashen",1362,40.0958333,44.2861111 ],
    [ u"am",u"Alaverdi",13186,41.1305556,44.6519444 ],
    [ u"am",u"Amasia",1675,40.9466667,43.7813889 ],
    [ u"am",u"Amberd",1267,40.2416667,44.2727778 ],
    [ u"am",u"Anushavan",1532,40.6419444,43.9822222 ],
    [ u"am",u"Apaga",1634,40.0961111,44.2511111 ],
    [ u"am",u"Aparan",5670,40.5961111,44.3536111 ],
    [ u"am",u"Aragats",2952,40.3330556,43.6580556 ],
    [ u"am",u"Aragats",5092,40.2183333,44.2327778 ],
    [ u"am",u"Aragyukh",999,40.4025,44.5436111 ],
    [ u"am",u"Aramus",3214,40.2511111,44.6630556 ],
    [ u"am",u"Arapi",1738,40.7797222,43.8005556 ],
    [ u"am",u"Ararat",6554,39.8094444,44.7144444 ],
    [ u"am",u"Arazap",1373,40.0427778,44.1458333 ],
    [ u"am",u"Archis",1235,41.1641667,44.8725 ],
    [ u"am",u"Areni",1718,39.7208333,45.1838889 ],
    [ u"am",u"Arevabuyr",1041,40.0361111,44.4688889 ],
    [ u"am",u"Arevashat",1403,40.1416667,44.3708333 ],
    [ u"am",u"Arevashogh",2435,40.8613889,44.2727778 ],
    [ u"am",u"Arevik",2455,40.1005556,44.0969444 ],
    [ u"am",u"Arevik",1522,40.7361111,43.8927778 ],
    [ u"am",u"Arevshat",2089,40.0391667,44.5416667 ],
    [ u"am",u"Arevshat",1623,40.6486111,44.0444444 ],
    [ u"am",u"Argavand",1703,40.1580556,44.44 ],
    [ u"am",u"Argavand",2047,40.0608333,44.0952778 ],
    [ u"am",u"Argel",2528,40.3794444,44.5994444 ],
    [ u"am",u"Armash",2434,39.7666667,44.8083333 ],
    [ u"am",u"Armavir",2752,40.0897222,44.0483333 ],
    [ u"am",u"Arshaluys",3808,40.1688889,44.2141667 ],
    [ u"am",u"Artashat",20562,39.9538889,44.5505556 ],
    [ u"am",u"Arteni",3086,40.2983333,43.7541667 ],
    [ u"am",u"Artimet",1501,40.1513889,44.2663889 ],
    [ u"am",u"Artsvaberd",3193,40.8336111,45.4711111 ],
    [ u"am",u"Artsvanist",2819,40.1544444,45.5022222 ],
    [ u"am",u"Arzakan",2660,40.4494444,44.6063889 ],
    [ u"am",u"Arzni",2244,40.2963889,44.5958333 ],
    [ u"am",u"Ashnak",1131,40.3275,43.9166667 ],
    [ u"am",u"Ashtarak",18779,40.3016667,44.3591667 ],
    [ u"am",u"Astghadzor",3520,40.1238889,45.3566667 ],
    [ u"am",u"Avshar",4215,39.8405556,44.6836111 ],
    [ u"am",u"Aygavan",3758,39.8647222,44.6702778 ],
    [ u"am",u"Aygedzor",2535,39.4627778,46.4152778 ],
    [ u"am",u"Aygehovit",2888,40.9744444,45.2519444 ],
    [ u"am",u"Aygek",1095,40.1886111,44.3833333 ],
    [ u"am",u"Aygepat",1349,39.95,44.6 ],
    [ u"am",u"Aygeshat",1358,40.2355556,44.2866667 ],
    [ u"am",u"Aygeshat",1606,40.0666667,44.0666667 ],
    [ u"am",u"Aygestan",2431,40.0030556,44.5575 ],
    [ u"am",u"Aygezard",3192,39.9458333,44.6088889 ],
    [ u"am",u"Aygut",997,40.6841667,45.1730556 ],
    [ u"am",u"Ayrum",2174,41.195,44.8925 ],
    [ u"am",u"Ayrum",2174,41.1716667,44.8191667 ],
    [ u"am",u"Azatamut",1850,40.9758333,45.1980556 ],
    [ u"am",u"Azatan",4448,40.7238889,43.8205556 ],
    [ u"am",u"Azatavan",2886,39.9833333,44.5 ],
    [ u"am",u"Azatavan",2886,40.1333333,44.0666667 ],
    [ u"am",u"Baghramyan",1690,40.1908333,43.8494444 ],
    [ u"am",u"Bagratashen",3024,41.2458333,44.8211111 ],
    [ u"am",u"Balahovit",2982,40.2536111,44.6038889 ],
    [ u"am",u"Bambakashat",3089,40.1144444,44.0122222 ],
    [ u"am",u"Bardzrashen",1273,40.0852778,44.5786111 ],
    [ u"am",u"Bazum",1114,40.8680556,44.4455556 ],
    [ u"am",u"Berdavan",3150,41.2027778,45.0033333 ],
    [ u"am",u"Berd",8374,40.8808333,45.3916667 ],
    [ u"am",u"Brnakot",1912,39.4969444,45.9730556 ],
    [ u"am",u"Brun",1028,39.5338889,46.3030556 ],
    [ u"am",u"Buzhakan",1678,40.4552778,44.5205556 ],
    [ u"am",u"Byurakan",3902,40.3413889,44.2736111 ],
    [ u"am",u"Byuravan",1228,40.0161111,44.5186111 ],
    [ u"am",u"Byureghavan",6972,40.3147222,44.5936111 ],
    [ u"am",u"Chambarak",6153,40.5952778,45.3475 ],
    [ u"am",u"Chochkan",1740,41.1861111,44.8313889 ],
    [ u"am",u"Dalar",2504,39.9669444,44.5363889 ],
    [ u"am",u"Dalarik",3080,40.2183333,43.8602778 ],
    [ u"am",u"Darakert",2325,40.1058333,44.4138889 ],
    [ u"am",u"Darpas",1785,40.8380556,44.4233333 ],
    [ u"am",u"Dashtavan",1762,40.1016667,44.3905556 ],
    [ u"am",u"Ddmashen",2157,40.5719444,44.8122222 ],
    [ u"am",u"Dilijan",13480,40.7408333,44.8630556 ],
    [ u"am",u"Dimitrov",1212,40.0080556,44.4880556 ],
    [ u"am",u"Doghs",1186,40.2227778,44.2716667 ],
    [ u"am",u"Drakhtik",1016,40.5688889,45.2319444 ],
    [ u"am",u"Dsegh",2484,40.9633333,44.6516667 ],
    [ u"am",u"Dvin",2795,40.02,44.5852778 ],
    [ u"am",u"Dzitankov",1162,40.5155556,43.8133333 ],
    [ u"am",u"Dzoraghbyur",2011,40.205,44.6430556 ],
    [ u"am",u"Dzoragyukh",3570,40.1752778,45.175 ],
    [ u"am",u"Fantan",1019,40.3941667,44.685 ],
    [ u"am",u"Fioletovo",1264,40.7247222,44.7138889 ],
    [ u"am",u"Gagarin",1305,40.5369444,44.8577778 ],
    [ u"am",u"Gandzak",3841,40.3147222,45.1113889 ],
    [ u"am",u"Garni",6827,40.1194444,44.7230556 ],
    [ u"am",u"Gavar",21681,40.3588889,45.1266667 ],
    [ u"am",u"Gay",3309,40.0838889,44.3055556 ],
    [ u"am",u"Geghamasar",1060,40.3116667,45.68 ],
    [ u"am",u"Geghamavan",1597,40.5619444,44.8827778 ],
    [ u"am",u"Geghanist",2409,40.1497222,44.4344444 ],
    [ u"am",u"Getahovit",2005,40.8958333,45.1313889 ],
    [ u"am",u"Getashen",2114,40.0433333,43.9447222 ],
    [ u"am",u"Getazat",1947,40.0380556,44.5638889 ],
    [ u"am",u"Ghukasavan",2113,40.1261111,44.4177778 ],
    [ u"am",u"Gladzor",2080,39.7783333,45.3477778 ],
    [ u"am",u"Gogaran",1088,40.8955556,44.1991667 ],
    [ u"am",u"Goris",20379,39.5077778,46.3386111 ],
    [ u"am",u"Gosh",994,40.7225,45.0033333 ],
    [ u"am",u"Griboyedov",1879,40.1130556,44.2716667 ],
    [ u"am",u"Gyulagarak",2109,40.9697222,44.4713889 ],
    [ u"am",u"Gyumri",148383,40.7894444,43.8475 ],
    [ u"am",u"Haghartsin",3370,40.7780556,44.9625 ],
    [ u"am",u"Hayanist",2031,40.1197222,44.3775 ],
    [ u"am",u"Haykashen",1140,40.0727778,44.3069444 ],
    [ u"am",u"Haykavan",1201,40.7558333,43.77 ],
    [ u"am",u"Hnaberd",1817,40.6427778,44.1444444 ],
    [ u"am",u"Hoktember",5348,40.1361111,44.0138889 ],
    [ u"am",u"Horom",1893,40.6541667,43.8822222 ],
    [ u"am",u"Hovtashat",3472,40.1019444,44.3427778 ],
    [ u"am",u"Hovtashen",1134,40.0244444,44.45 ],
    [ u"am",u"Hrazdan",40796,40.5016667,44.7547222 ],
    [ u"am",u"Ijevan",14737,40.8755556,45.1491667 ],
    [ u"am",u"Janfida",2986,40.0455556,44.0208333 ],
    [ u"am",u"Jermuk",4582,39.8416667,45.6722222 ],
    [ u"am",u"Jrahovit",1032,40.0452778,44.4736111 ],
    [ u"am",u"Jrashen",3078,40.7875,44.1972222 ],
    [ u"am",u"Jrashen",1696,40.0547222,44.5133333 ],
    [ u"am",u"Kamaris",2064,40.2358333,44.6938889 ],
    [ u"am",u"Kamo",1340,40.8280556,43.9483333 ],
    [ u"am",u"Kanakeravan",2950,40.2472222,44.5366667 ],
    [ u"am",u"Kapan",33161,39.2011111,46.415 ],
    [ u"am",u"Kaputan",1252,40.3244444,44.6938889 ],
    [ u"am",u"Karbi",3521,40.3338889,44.3777778 ],
    [ u"am",u"Karchaghbyur",2274,40.1638889,45.5722222 ],
    [ u"am",u"Kasakh",4247,40.5333333,44.4166667 ],
    [ u"am",u"Khashtarak",1728,40.9386111,45.1797222 ],
    [ u"am",u"Khndzoresk",1940,39.5122222,46.4336111 ],
    [ u"am",u"Kosh",2581,40.3072222,44.16 ],
    [ u"am",u"Lanjaghbyur",2097,40.2730556,45.1444444 ],
    [ u"am",u"Lchashen",4182,40.5202778,44.9308333 ],
    [ u"am",u"Lenughi",1499,40.1238889,43.9652778 ],
    [ u"am",u"Lernakert",1306,40.5669444,43.9361111 ],
    [ u"am",u"Lernanist",2511,40.4675,44.7980556 ],
    [ u"am",u"Lernantsk",1192,40.7955556,44.2783333 ],
    [ u"am",u"Lernapat",1710,40.82,44.3972222 ],
    [ u"am",u"Lernavan",1517,40.7883333,44.1844444 ],
    [ u"am",u"Lorut",1101,40.9388889,44.7725 ],
    [ u"am",u"Lukashin",2197,40.1758333,44.0186111 ],
    [ u"am",u"Madina",1024,40.0802778,45.2511111 ],
    [ u"am",u"Maisyan",1521,40.8530556,43.8294444 ],
    [ u"am",u"Malishka",4174,39.7369444,45.3875 ],
    [ u"am",u"Maralik",4959,40.5722222,43.8669444 ],
    [ u"am",u"Margahovit",3308,40.7380556,44.6875 ],
    [ u"am",u"Margara",1360,40.0336111,44.1738889 ],
    [ u"am",u"Marmarashen",2946,40.0575,44.4711111 ],
    [ u"am",u"Marmashen",1644,40.8375,43.7719444 ],
    [ u"am",u"Martuni",11037,40.1447222,45.3063889 ],
    [ u"am",u"Masis",18911,40.0138889,44.4858333 ],
    [ u"am",u"Mayakovski",1727,40.2522222,44.6383333 ],
    [ u"am",u"Meghradzor",2659,40.6147222,44.6522222 ],
    [ u"am",u"Meghrashen",1107,40.6758333,43.9486111 ],
    [ u"am",u"Meghri",4540,38.9022222,46.2383333 ],
    [ u"am",u"Merdzavan",2702,40.1816667,44.3991667 ],
    [ u"am",u"Metsamor",8789,40.0713889,44.2891667 ],
    [ u"am",u"Metsavan",4767,41.2016667,44.2288889 ],
    [ u"am",u"Mets Masrik",2570,40.2186111,45.7694444 ],
    [ u"am",u"Mets Parni",1934,40.8372222,44.1091667 ],
    [ u"am",u"Mosesgegh",1964,40.9063889,45.4913889 ],
    [ u"am",u"Mrganush",1032,40.0286111,44.5586111 ],
    [ u"am",u"Mrgashat",4961,40.1297222,44.0705556 ],
    [ u"am",u"Mrgashen",1623,40.285,44.5422222 ],
    [ u"am",u"Mrgavan",1713,39.9661111,44.5333333 ],
    [ u"am",u"Mrgavet",2131,40.0283333,44.4827778 ],
    [ u"am",u"Musaler",2323,40.1544444,44.3777778 ],
    [ u"am",u"Musayelyan",1499,40.7652778,43.9908333 ],
    [ u"am",u"Myasnikyan",3458,40.1775,43.9063889 ],
    [ u"am",u"Nalbandyan",4019,40.0677778,43.9855556 ],
    [ u"am",u"Navur",1227,40.8613889,45.3175 ],
    [ u"am",u"Nizami",1060,40.0913889,44.4041667 ],
    [ u"am",u"Norakert",2485,40.1922222,44.3466667 ],
    [ u"am",u"Noramarg",1811,40.0236111,44.4244444 ],
    [ u"am",u"Nor Armavir",1597,40.0866667,43.99 ],
    [ u"am",u"Norashen",3049,40.0041667,44.5947222 ],
    [ u"am",u"Norashen",1386,41.1880556,44.3272222 ],
    [ u"am",u"Noratus",5426,40.3822222,45.1783333 ],
    [ u"am",u"Nor Geghi",4896,40.3211111,44.5797222 ],
    [ u"am",u"Nor Gyukh",1462,40.2666667,44.6563889 ],
    [ u"am",u"Nor Yerznka",1459,40.3133333,44.4047222 ],
    [ u"am",u"Noyakert",1751,39.8166667,44.6669444 ],
    [ u"am",u"Noyemberyan",5119,41.1725,44.9936111 ],
    [ u"am",u"Nshavan",1916,40.0263889,44.5252778 ],
    [ u"am",u"Odzun",4524,41.0538889,44.6113889 ],
    [ u"am",u"Oshakan",4768,40.2705556,44.2691667 ],
    [ u"am",u"Paravakar",1637,40.9805556,45.3991667 ],
    [ u"am",u"Pemzashen",2436,40.5933333,43.94 ],
    [ u"am",u"Pokr Mantash",1838,40.65,44.05 ],
    [ u"am",u"Proshyan",4333,40.2480556,44.415 ],
    [ u"am",u"Pshatavan",2159,40.0405556,44.0675 ],
    [ u"am",u"Ptghni",1231,40.2566667,44.585 ],
    [ u"am",u"Ranchpar",989,40.0252778,44.3702778 ],
    [ u"am",u"Rind",1368,39.7597222,45.18 ],
    [ u"am",u"Samaghar",2343,40.1852778,44.2422222 ],
    [ u"am",u"Saramech",1111,40.7725,44.2191667 ],
    [ u"am",u"Saratak",1115,40.67,43.8663889 ],
    [ u"am",u"Sarigyukh",1096,41.0563889,45.1458333 ],
    [ u"am",u"Sarukhan",6173,40.2891667,45.1341667 ],
    [ u"am",u"Sasunik",1959,40.2472222,44.3380556 ],
    [ u"am",u"Sevan",17083,40.555,44.9536111 ],
    [ u"am",u"Shaghat",1011,39.5616667,45.9122222 ],
    [ u"am",u"Shahumyan",3905,39.9308333,44.5783333 ],
    [ u"am",u"Shahumyan",1843,40.7883333,44.5316667 ],
    [ u"am",u"Shatin",1671,39.8333333,45.3016667 ],
    [ u"am",u"Shenavan",1587,40.4861111,44.3825 ],
    [ u"am",u"Shenavan",1757,40.05,43.9333333 ],
    [ u"am",u"Shinuhayr",2206,39.4341667,46.3155556 ],
    [ u"am",u"Shirakamut",2008,40.8605556,44.1527778 ],
    [ u"am",u"Shirak",1007,40.8480556,43.9213889 ],
    [ u"am",u"Shnogh",2872,41.1477778,44.8377778 ],
    [ u"am",u"Sisavan",1793,39.9,44.6666667 ],
    [ u"am",u"Sisian",15208,39.4627778,45.9730556 ],
    [ u"am",u"Sis",1135,40.0586111,44.3863889 ],
    [ u"am",u"Solak",2295,40.4636111,44.7086111 ],
    [ u"am",u"Sovetakan",1613,40.1133333,44.0552778 ],
    [ u"am",u"Spandaryan",1226,40.665,44.0188889 ],
    [ u"am",u"Spitak",15063,40.7955556,44.2783333 ],
    [ u"am",u"Surenavan",2241,39.75,44.8 ],
    [ u"am",u"Talin",4945,40.3369444,43.8588889 ],
    [ u"am",u"Tandzut",1816,40.0772222,44.0886111 ],
    [ u"am",u"Taronik",1874,40.1330556,44.1991667 ],
    [ u"am",u"Tashir",7318,41.1244444,44.2819444 ],
    [ u"am",u"Tazagyukh",2248,40.1416667,45.1913889 ],
    [ u"am",u"Tegh",2120,39.5547222,46.4758333 ],
    [ u"am",u"Tsaghkaber",1207,40.7986111,44.1072222 ],
    [ u"am",u"Tsaghkadzor",1408,40.5386111,44.7113889 ],
    [ u"am",u"Tsaghkahovit",1551,40.6361111,44.2230556 ],
    [ u"am",u"Tsiatsan",1050,40.1869444,44.2666667 ],
    [ u"am",u"Tsovagyugh",3857,40.6330556,44.9522222 ],
    [ u"am",u"Tsovak",2531,40.1819444,45.635 ],
    [ u"am",u"Tsovazard",1949,40.4769444,45.0375 ],
    [ u"am",u"Tsovinar",3968,40.1608333,45.4538889 ],
    [ u"am",u"Tumanyan",1693,40.9633333,44.6516667 ],
    [ u"am",u"Urut",1102,41.0711111,44.3969444 ],
    [ u"am",u"Ushi",1276,40.3536111,44.3686111 ],
    [ u"am",u"Vagharshapat",49514,40.1727778,44.2925 ],
    [ u"am",u"Vaghashen",3235,40.1377778,45.3291667 ],
    [ u"am",u"Vahagni",1184,40.9080556,44.6069444 ],
    [ u"am",u"Vahan",1153,40.57,45.3955556 ],
    [ u"am",u"Vanadzor",101099,40.8127778,44.4883333 ],
    [ u"am",u"Vardablur",1297,40.95,44.4666667 ],
    [ u"am",u"Vardadzor",2095,40.1916667,45.1875 ],
    [ u"am",u"Vardenik",7709,40.135,45.4363889 ],
    [ u"am",u"Vardenis",11382,40.1805556,45.7283333 ],
    [ u"am",u"Varser",1614,40.5561111,44.9111111 ],
    [ u"am",u"Vedi",12192,39.9105556,44.7277778 ],
    [ u"am",u"Verin Artashat",3931,40.0005556,44.585 ],
    [ u"am",u"Verin Dvin",1853,40.0252778,44.5908333 ],
    [ u"am",u"Verin Getashen",4173,40.1327778,45.2486111 ],
    [ u"am",u"Verishen",2114,39.5358333,46.3119444 ],
    [ u"am",u"Vernashen",1162,39.7938889,45.3633333 ],
    [ u"am",u"Voskehask",1803,40.7383333,43.7758333 ],
    [ u"am",u"Voskehat",2181,40.1413889,44.3291667 ],
    [ u"am",u"Voskevan",1287,41.1191667,45.0652778 ],
    [ u"am",u"Voskevaz",3789,40.2797222,44.295 ],
    [ u"am",u"Vostan",2925,39.9588889,44.5591667 ],
    [ u"am",u"Yeghegnavan",1221,39.8277778,44.6372222 ],
    [ u"am",u"Yeghegnut",1746,40.0902778,44.1625 ],
    [ u"am",u"Yeghegnut",1154,40.9041667,44.6325 ],
    [ u"am",u"Yeghvard",10705,40.3216667,44.4813889 ],
    [ u"am",u"Yeraskhahun",1346,40.0722222,44.2158333 ],
    [ u"am",u"Yerazgavors",1285,40.7,43.75 ],
    [ u"am",u"Yerevan",1093499,40.1811111,44.5136111 ],
    [ u"am",u"Zangakatun",1130,39.8094444,45.0511111 ],
    [ u"am",u"Zaritap",1323,39.6372222,45.5086111 ],
    [ u"am",u"Zar",1340,40.2611111,44.7361111 ],
    [ u"am",u"Zhdanov",1512,40.1616667,44.0883333 ],
    [ u"am",u"Zorak",1390,40.0925,44.3919444 ],
    [ u"am",u"Zoravan",1167,40.3569444,44.5230556 ],
    [ u"am",u"Zovaber",1470,40.5736111,44.7863889 ],
    [ u"am",u"Zovuni",4484,40.5108333,44.4288889 ],
    [ u"an",u"Barber",2424,12.2833333,-69.0666667 ],
    [ u"an",u"Golden Rock",823,17.4833333,-62.9833333 ],
    [ u"an",u"Hato",13,12.1833333,-68.2833333 ],
    [ u"an",u"Kralendijk",3081,12.15,-68.2666667 ],
    [ u"an",u"Lagún",289,12.3166667,-69.1666667 ],
    [ u"an",u"Nieuwpoort",1937,12.05,-68.8166667 ],
    [ u"an",u"Oranjestad",1097,17.4666667,-62.9833333 ],
    [ u"an",u"Rincón",1496,12.2333333,-68.3333333 ],
    [ u"an",u"Sint Michiel",5138,12.1333333,-68.9833333 ],
    [ u"an",u"Soto",1987,12.2666667,-69.1 ],
    [ u"an",u"The Bottom",488,17.6333333,-63.25 ],
    [ u"an",u"Westpunt",783,12.3666667,-69.1666667 ],
    [ u"an",u"Willemstad",97590,12.1,-68.9166667 ],
    [ u"an",u"Windward Side",442,17.6333333,-63.2333333 ],
    [ u"ao",u"Benguela",151235,-12.578333,13.407222 ],
    [ u"ao",u"Caála",21205,-12.8525,15.560556 ],
    [ u"ao",u"Cabinda",66020,-5.55,12.2 ],
    [ u"ao",u"Caconda",10551,-13.733333,15.066667 ],
    [ u"ao",u"Caluquembe",30305,-13.783333,14.683333 ],
    [ u"ao",u"Camabatela",12839,-8.18812,15.37495 ],
    [ u"ao",u"Camacupa",19150,-12.016667,17.483333 ],
    [ u"ao",u"Catabola",18858,-12.15,17.283333 ],
    [ u"ao",u"Catumbela",16980,-12.431389,13.547222 ],
    [ u"ao",u"Caxito",28229,-8.58,13.664167 ],
    [ u"ao",u"Cazaje",4764,-11.067147,20.701483 ],
    [ u"ao",u"Chissamba",7677,-12.166667,17.333333 ],
    [ u"ao",u"Huambo",226177,-12.776111,15.739167 ],
    [ u"ao",u"Kibala",8915,-10.73366,14.979949 ],
    [ u"ao",u"Kuito",113624,-12.383333,16.933333 ],
    [ u"ao",u"Leúa",5168,-11.65,20.45 ],
    [ u"ao",u"Lobito",207957,-12.319722,13.599722 ],
    [ u"ao",u"Longonjo",24350,-12.906667,15.253333 ],
    [ u"ao",u"Luanda",2776125,-8.836804,13.233174 ],
    [ u"ao",u"Luau",18465,-10.707273,22.22466 ],
    [ u"ao",u"Lubango",102541,-14.916667,13.5 ],
    [ u"ao",u"Lucapa",20115,-8.419151,20.744655 ],
    [ u"ao",u"Luena",21115,-11.783333,19.916667 ],
    [ u"ao",u"Lumeje",4972,-11.55,20.783333 ],
    [ u"ao",u"Malanje",87047,-9.544722,16.345278 ],
    [ u"ao",u"Menongue",19141,-14.661639,17.688224 ],
    [ u"ao",u"Namibe",80150,-15.196111,12.152222 ],
    [ u"ao",u"Ondjiva",10169,-17.066667,15.733333 ],
    [ u"ao",u"Saurimo",40498,-9.66078,20.391553 ],
    [ u"ao",u"Soyo",67553,-6.134903,12.368935 ],
    [ u"ao",u"Sumbe",33278,-11.206048,13.843713 ],
    [ u"ao",u"Uíge",60008,-7.613282,15.056621 ],
    [ u"ar",u"Alta Gracia",40385,-31.652925,-64.428259 ],
    [ u"ar",u"Azul",52333,-36.776976,-59.858539 ],
    [ u"ar",u"Bahia Blanca",282950,-38.719595,-62.272432 ],
    [ u"ar",u"Bell Ville",35106,-32.625906,-62.68873 ],
    [ u"ar",u"Campana",83175,-34.168742,-58.95914 ],
    [ u"ar",u"Catamarca",213601,-28.469574,-65.785239 ],
    [ u"ar",u"Chacabuco",34587,-34.641667,-60.473889 ],
    [ u"ar",u"Chivilcoy",52307,-34.895661,-60.016667 ],
    [ u"ar",u"Comodoro Rivadavia",142597,-45.864135,-67.496558 ],
    [ u"ar",u"Concepcion del Uruguay",72904,-32.482493,-58.237217 ],
    [ u"ar",u"Concordia",155686,-31.392959,-58.02089 ],
    [ u"ar",u"Cordoba",1441007,-31.413496,-64.181052 ],
    [ u"ar",u"Corrientes",390481,-27.480596,-58.834099 ],
    [ u"ar",u"Dolores",25190,-36.313215,-57.679185 ],
    [ u"ar",u"Eldorado",62823,-26.404841,-54.624784 ],
    [ u"ar",u"Formosa",248756,-26.177534,-58.178139 ],
    [ u"ar",u"General Pico",55900,-35.656622,-63.756815 ],
    [ u"ar",u"General Roca",76066,-39.02797,-67.573711 ],
    [ u"ar",u"Goya",70340,-29.14003,-59.262564 ],
    [ u"ar",u"Gualeguaychu",88218,-33.009375,-58.51722 ],
    [ u"ar",u"Gualeguay",33120,-33.141559,-59.309657 ],
    [ u"ar",u"Jujuy",277150,-24.194565,-65.297116 ],
    [ u"ar",u"Junin",76369,-34.583816,-60.943318 ],
    [ u"ar",u"La Plata",684318,-34.921454,-57.954533 ],
    [ u"ar",u"La Rioja",178497,-29.411048,-66.850668 ],
    [ u"ar",u"Libertador General San Martin",49273,-23.806443,-64.787574 ],
    [ u"ar",u"Lincoln",24798,-34.866494,-61.530197 ],
    [ u"ar",u"Lujan",74823,-34.570278,-59.105 ],
    [ u"ar",u"Lujan",77625,-33.035471,-68.877823 ],
    [ u"ar",u"Mar del Plata",645771,-38.002278,-57.557539 ],
    [ u"ar",u"Mendoza",973047,-32.890845,-68.827171 ],
    [ u"ar",u"Mercedes",49067,-34.651455,-59.430676 ],
    [ u"ar",u"Mercedes",30649,-29.181858,-58.078951 ],
    [ u"ar",u"Mercedes",126559,-33.674359,-65.461405 ],
    [ u"ar",u"Necochea",84969,-38.547259,-58.736753 ],
    [ u"ar",u"Neuquen",359037,-38.951606,-68.059102 ],
    [ u"ar",u"Nueve de Julio",34717,-35.444374,-60.883131 ],
    [ u"ar",u"Obera",58939,-27.487059,-55.11994 ],
    [ u"ar",u"Olavarria",80005,-36.892715,-60.32254 ],
    [ u"ar",u"Parana",299257,-31.731967,-60.523802 ],
    [ u"ar",u"Pergamino",86708,-33.889949,-60.573568 ],
    [ u"ar",u"Posadas",313438,-27.367077,-55.896078 ],
    [ u"ar",u"Presidencia Roque Saenz Pena",89584,-26.785221,-60.438761 ],
    [ u"ar",u"Puerto Madryn",95547,-42.769201,-65.038513 ],
    [ u"ar",u"Punta Alta",53117,-38.875875,-62.073589 ],
    [ u"ar",u"Rafaela",84025,-31.250332,-61.486696 ],
    [ u"ar",u"Rawson",26341,-43.300158,-65.10228 ],
    [ u"ar",u"Reconquista",95979,-29.15,-59.65 ],
    [ u"ar",u"Resistencia",406967,-27.46056,-58.983886 ],
    [ u"ar",u"Rio Cuarto",174058,-33.130671,-64.349918 ],
    [ u"ar",u"Rio Gallegos",93234,-51.622613,-69.218127 ],
    [ u"ar",u"Rio Tercero",53396,-32.173008,-64.114055 ],
    [ u"ar",u"Rivadavia",65641,-33.190509,-68.46081 ],
    [ u"ar",u"Rosario",1218497,-32.946818,-60.639317 ],
    [ u"ar",u"Salta",548288,-24.785896,-65.411664 ],
    [ u"ar",u"San Carlos de Bariloche",110044,-41.140293,-71.301369 ],
    [ u"ar",u"San Francisco",71444,-31.427971,-62.082656 ],
    [ u"ar",u"San Juan",469958,-31.5375,-68.536389 ],
    [ u"ar",u"San Lorenzo",47627,-28.133061,-58.767331 ],
    [ u"ar",u"San Luis",184869,-33.295012,-66.335627 ],
    [ u"ar",u"San Martin",107554,-33.081031,-68.468138 ],
    [ u"ar",u"San Nicolas",130705,-33.335784,-60.225233 ],
    [ u"ar",u"San Pedro",67514,-33.679127,-59.666635 ],
    [ u"ar",u"San Pedro",43124,-24.231266,-64.866141 ],
    [ u"ar",u"San Rafael",125033,-34.617717,-68.330066 ],
    [ u"ar",u"San Ramon de la Nueva Oran",84504,-23.13398,-64.324645 ],
    [ u"ar",u"Santa Fe",456044,-31.629484,-60.701036 ],
    [ u"ar",u"Santa Rosa",89478,-36.616667,-64.283333 ],
    [ u"ar",u"Santiago del Estero",407636,-27.795112,-64.261489 ],
    [ u"ar",u"San Vicente",84333,-34.982645,-58.376169 ],
    [ u"ar",u"Tandil",100127,-37.321674,-59.133164 ],
    [ u"ar",u"Tartagal",63600,-22.516365,-63.801314 ],
    [ u"ar",u"Trelew",107883,-43.250075,-65.313295 ],
    [ u"ar",u"Tres Arroyos",47143,-38.373939,-60.279781 ],
    [ u"ar",u"Tucuman",828402,-26.824144,-65.2226 ],
    [ u"ar",u"Ushuaia",58045,-54.8,-68.3 ],
    [ u"ar",u"Veinticinco de Mayo",24668,-35.432303,-60.172707 ],
    [ u"ar",u"Venado Tuerto",71794,-33.745564,-61.968845 ],
    [ u"ar",u"Victoria",25139,-32.619888,-60.153907 ],
    [ u"ar",u"Viedma",76553,-40.813452,-62.996676 ],
    [ u"ar",u"Villa Carlos Paz",61095,-31.424138,-64.497778 ],
    [ u"ar",u"Villa Constitucion",44278,-33.227778,-60.329699 ],
    [ u"ar",u"Villa Maria",92337,-32.407514,-63.240161 ],
    [ u"ar",u"Zarate",88222,-34.098142,-59.028585 ],
    [ u"at",u"Absam",6594,47.3,11.5 ],
    [ u"at",u"Abtenau",5829,47.55,13.35 ],
    [ u"at",u"Altach",6040,47.35,9.65 ],
    [ u"at",u"Althofen",4833,47.15,14.233333 ],
    [ u"at",u"Altmunster",9652,47.9,13.75 ],
    [ u"at",u"Amstetten",22832,48.116667,14.866667 ],
    [ u"at",u"Anif",4154,47.75,13.066667 ],
    [ u"at",u"Ansfelden",14936,48.2,14.283333 ],
    [ u"at",u"Arnoldstein",6923,46.546111,13.71 ],
    [ u"at",u"Asten",6517,48.216667,14.4 ],
    [ u"at",u"Axams",5560,47.233333,11.3 ],
    [ u"at",u"Bad Aussee",5210,47.6,13.783333 ],
    [ u"at",u"Baden",24893,48.016667,16.233333 ],
    [ u"at",u"Bad Goisern",7869,47.633333,13.616667 ],
    [ u"at",u"Bad Hall",4935,48.033333,14.2 ],
    [ u"at",u"Bad Hofgastein",7002,47.166667,13.1 ],
    [ u"at",u"Bad Ischl",14267,47.716667,13.616667 ],
    [ u"at",u"Bad Sankt Leonhard",4775,46.962778,14.791667 ],
    [ u"at",u"Bad Voslau",11013,47.966667,16.2 ],
    [ u"at",u"Barnbach",4850,46.983333,16.05 ],
    [ u"at",u"Bergheim",5031,47.833333,13.033333 ],
    [ u"at",u"Berndorf",8796,47.95,16.1 ],
    [ u"at",u"Bischofshofen",10145,47.416667,13.216667 ],
    [ u"at",u"Bludenz",13904,47.149722,9.816667 ],
    [ u"at",u"Braunau",16403,48.266667,13.033333 ],
    [ u"at",u"Bregenz",26928,47.5,9.766667 ],
    [ u"at",u"Bruck an der Leitha",7339,48.016667,16.766667 ],
    [ u"at",u"Bruck an der Mur",13254,47.416667,15.283333 ],
    [ u"at",u"Deutschlandsberg",8049,46.815278,15.222222 ],
    [ u"at",u"Deutsch-Wagram",7153,48.299722,16.566667 ],
    [ u"at",u"Dornbirn",43013,47.416667,9.733056 ],
    [ u"at",u"Ebbs",5088,47.633333,12.216667 ],
    [ u"at",u"Ebensee",8376,47.8,13.766667 ],
    [ u"at",u"Ebenthal",7809,46.608056,14.364167 ],
    [ u"at",u"Eberndorf",6089,46.591389,14.643611 ],
    [ u"at",u"Ebreichsdorf",9509,47.95,16.4 ],
    [ u"at",u"Eisenerz",5987,47.533333,14.883333 ],
    [ u"at",u"Eisenstadt",11767,47.85,16.516667 ],
    [ u"at",u"Engerwitzdorf",8510,48.35,14.45 ],
    [ u"at",u"Enns",10816,48.2,14.466667 ],
    [ u"at",u"Feldbach",4877,46.953056,15.888333 ],
    [ u"at",u"Feldkirchen an der Donau",5286,48.35,14.05 ],
    [ u"at",u"Feldkirchen",14440,46.716667,14.1 ],
    [ u"at",u"Feldkirch",29446,47.233056,9.6 ],
    [ u"at",u"Ferlach",7661,46.526944,14.301944 ],
    [ u"at",u"Finkenstein",8406,46.565556,13.865278 ],
    [ u"at",u"Fohnsdorf",8203,47.2,14.683333 ],
    [ u"at",u"Frankenburg",5162,48.066667,13.483333 ],
    [ u"at",u"Freistadt",7574,48.5,14.5 ],
    [ u"at",u"Friesach",5369,46.955278,14.405833 ],
    [ u"at",u"Frohnleiten",6629,47.266667,15.316667 ],
    [ u"at",u"Fugen",3734,47.35,11.85 ],
    [ u"at",u"Furstenfeld",5962,47.05,16.083333 ],
    [ u"at",u"Gallneukirchen",6282,48.35,14.416667 ],
    [ u"at",u"Ganserndorf",8588,48.35,16.733333 ],
    [ u"at",u"Garsten",6657,48.016667,14.4 ],
    [ u"at",u"Gleisdorf",5245,47.1,15.716667 ],
    [ u"at",u"Gloggnitz",6213,47.666667,15.933333 ],
    [ u"at",u"Gmunden",13287,47.916667,13.8 ],
    [ u"at",u"Gmund",5811,48.766667,14.983333 ],
    [ u"at",u"Gotzis",10342,47.333056,9.633056 ],
    [ u"at",u"Gratkorn",6806,47.133333,15.35 ],
    [ u"at",u"Graz",222326,47.066667,15.45 ],
    [ u"at",u"Grieskirchen",4766,48.233333,13.833333 ],
    [ u"at",u"Grodig",6918,47.733333,13.033333 ],
    [ u"at",u"Guntramsdorf",9071,48.033333,16.3 ],
    [ u"at",u"Haag",5164,48.15,15.5 ],
    [ u"at",u"Hainburg",5622,48.15,16.933333 ],
    [ u"at",u"Hallein",18980,47.683333,13.1 ],
    [ u"at",u"Hall",11197,47.6,14.45 ],
    [ u"at",u"Hard",11766,47.483056,9.683056 ],
    [ u"at",u"Heidenreichstein",4472,48.866667,15.116667 ],
    [ u"at",u"Hermagor",7242,46.627222,13.367222 ],
    [ u"at",u"Herzogenburg",7866,48.266667,15.683333 ],
    [ u"at",u"Himberg",5534,48.083333,16.433333 ],
    [ u"at",u"Hochst",7207,47.466667,9.633056 ],
    [ u"at",u"Hohenems",14072,47.366667,9.683056 ],
    [ u"at",u"Hollabrunn",10966,48.55,16.083333 ],
    [ u"at",u"Hopfgarten",5314,47.45,12.166667 ],
    [ u"at",u"Horbranz",6414,47.55,9.75 ],
    [ u"at",u"Horn",6485,48.65,15.65 ],
    [ u"at",u"Horsching",5312,48.233333,14.183333 ],
    [ u"at",u"Imst",9225,47.233333,10.733333 ],
    [ u"at",u"Innsbruck",112467,47.266667,11.4 ],
    [ u"at",u"Jenbach",6806,47.4,11.783333 ],
    [ u"at",u"Jennersdorf",4319,46.939167,16.146667 ],
    [ u"at",u"Judenburg",9992,47.166667,14.666667 ],
    [ u"at",u"Kapfenberg",21819,47.433333,15.3 ],
    [ u"at",u"Kindberg",5790,47.5,15.45 ],
    [ u"at",u"Kirchbichl",5115,47.516667,12.083333 ],
    [ u"at",u"Kitzbuhel",8818,47.45,12.383333 ],
    [ u"at",u"Klagenfurt",90610,46.624722,14.305278 ],
    [ u"at",u"Klosterneuburg",24843,48.3,16.316667 ],
    [ u"at",u"Knittelfeld",12704,47.216667,14.816667 ],
    [ u"at",u"Koflach",10447,47.066667,15.083333 ],
    [ u"at",u"Korneuburg",11498,48.35,16.333333 ],
    [ u"at",u"Kottingbrunn",7184,47.95,16.216667 ],
    [ u"at",u"Krems",24092,48.416667,15.6 ],
    [ u"at",u"Kremsmunster",6626,48.05,14.133333 ],
    [ u"at",u"Krieglach",5236,47.533333,15.55 ],
    [ u"at",u"Kuchl",6668,47.616667,13.15 ],
    [ u"at",u"Kufstein",16116,47.583333,12.166667 ],
    [ u"at",u"Laakirchen",9569,47.966667,13.816667 ],
    [ u"at",u"Laa",6084,48.716667,16.383333 ],
    [ u"at",u"Landeck",7351,47.133333,10.566667 ],
    [ u"at",u"Langenlois",7081,48.466667,15.666667 ],
    [ u"at",u"Langenzersdorf",7733,48.3,16.35 ],
    [ u"at",u"Lauterach",9212,47.483056,9.733056 ],
    [ u"at",u"Leibnitz",7029,46.781667,15.541667 ],
    [ u"at",u"Lenzing",5044,47.966667,13.616667 ],
    [ u"at",u"Leoben",24809,47.383333,15.1 ],
    [ u"at",u"Leonding",22736,48.266667,14.25 ],
    [ u"at",u"Lienz",12270,46.831111,12.759722 ],
    [ u"at",u"Liezen",6903,47.566667,14.233333 ],
    [ u"at",u"Linz",181163,48.3,14.3 ],
    [ u"at",u"Lochau",5209,47.533333,9.75 ],
    [ u"at",u"Lustenau",20218,47.433056,9.65 ],
    [ u"at",u"Marchtrenk",11666,48.183333,14.116667 ],
    [ u"at",u"Maria Enzersdorf",8085,48.1,16.283333 ],
    [ u"at",u"Matrei",5076,47,12.533333 ],
    [ u"at",u"Mattersburg",6448,47.733333,16.4 ],
    [ u"at",u"Melk",5272,48.216667,15.316667 ],
    [ u"at",u"Micheldorf",5902,47.85,14.133333 ],
    [ u"at",u"Mistelbach",10820,48.57,16.576667 ],
    [ u"at",u"Mittelberg",4627,47.2,9.65 ],
    [ u"at",u"Mittersill",5680,47.266667,12.483333 ],
    [ u"at",u"Modling",20710,48.083333,16.283333 ],
    [ u"at",u"Moosburg",4602,46.6575,14.174722 ],
    [ u"at",u"Murzzuschlag",9410,47.6,15.683333 ],
    [ u"at",u"Nenzing",5856,47.183056,9.7 ],
    [ u"at",u"Neudorfl",4183,47.783333,16.283333 ],
    [ u"at",u"Neulengbach",7521,48.2,15.9 ],
    [ u"at",u"Neunkirchen",11313,47.716667,16.083333 ],
    [ u"at",u"Neusiedl am See",5949,47.933333,16.833333 ],
    [ u"at",u"Nuziders",4628,47.166667,9.8 ],
    [ u"at",u"Oberndorf",5738,48.25,13.333333 ],
    [ u"at",u"Oberwart",6879,47.283333,16.2 ],
    [ u"at",u"Pasching",6143,48.25,14.2 ],
    [ u"at",u"Paternion",6301,46.714167,13.636111 ],
    [ u"at",u"Perchtoldsdorf",14041,48.116667,16.266667 ],
    [ u"at",u"Perg",7644,48.25,14.633333 ],
    [ u"at",u"Pinkafeld",5257,47.366667,16.116667 ],
    [ u"at",u"Pottendorf",6105,47.9,16.383333 ],
    [ u"at",u"Poysdorf",5653,48.666667,16.633333 ],
    [ u"at",u"Pressbaum",6083,48.183333,16.083333 ],
    [ u"at",u"Purgstall",5247,48.05,15.133333 ],
    [ u"at",u"Purkersdorf",8327,48.2,16.166667 ],
    [ u"at",u"Radstadt",4926,47.383333,13.45 ],
    [ u"at",u"Rankweil",11455,47.283056,9.65 ],
    [ u"at",u"Reichenau",2673,47.7,15.833333 ],
    [ u"at",u"Retz",4139,48.75,15.95 ],
    [ u"at",u"Reutte",5851,47.483333,10.716667 ],
    [ u"at",u"Ried",11511,48.216667,13.5 ],
    [ u"at",u"Rottenmann",5561,47.516667,14.35 ],
    [ u"at",u"Rum",8498,47.283333,11.45 ],
    [ u"at",u"Rust",1726,47.8,16.666667 ],
    [ u"at",u"Saalfelden",16119,47.416667,12.85 ],
    [ u"at",u"Salzburg",145310,47.8,13.033333 ],
    [ u"at",u"Sankt Andra",10825,46.766111,14.823611 ],
    [ u"at",u"Sankt Florian",5760,48.166667,13.133333 ],
    [ u"at",u"Sankt Georgen",4180,47.933333,13.483333 ],
    [ u"at",u"Sankt Jakob",4481,46.547778,14.057222 ],
    [ u"at",u"Sankt Johann im Pongau",10887,47.35,13.2 ],
    [ u"at",u"Sankt Polten",49000,48.2,15.633333 ],
    [ u"at",u"Sankt Valentin",9063,48.166667,14.516667 ],
    [ u"at",u"Sankt Veit",13116,46.768056,14.360278 ],
    [ u"at",u"Scharding",4919,48.45,13.433333 ],
    [ u"at",u"Scharnstein",4631,47.9,13.95 ],
    [ u"at",u"Schladming",4659,47.383333,13.683333 ],
    [ u"at",u"Schrems",5811,48.783333,15.066667 ],
    [ u"at",u"Schruns",3506,47.066667,9.916667 ],
    [ u"at",u"Schwaz",12507,47.333333,11.7 ],
    [ u"at",u"Schwechat",15711,48.133333,16.466667 ],
    [ u"at",u"Seeboden",6221,46.821944,13.495 ],
    [ u"at",u"Seekirchen",9865,47.9,13.133333 ],
    [ u"at",u"Seewalchen",4959,47.95,13.583333 ],
    [ u"at",u"Sieghartskirchen",7062,48.25,16 ],
    [ u"at",u"Sierning",8722,48.033333,14.3 ],
    [ u"at",u"Spittal",16363,46.8,13.5 ],
    [ u"at",u"Steyregg",4856,48.283333,14.366667 ],
    [ u"at",u"Steyr",39567,48.05,14.416667 ],
    [ u"at",u"Stockerau",14831,48.383333,16.216667 ],
    [ u"at",u"Strasshof",7637,48.316667,16.666667 ],
    [ u"at",u"Tamsweg",6126,47.133333,13.8 ],
    [ u"at",u"Telfs",14028,47.3,11.066667 ],
    [ u"at",u"Ternitz",15153,47.716667,16.033333 ],
    [ u"at",u"Thalgau",5501,47.833333,13.25 ],
    [ u"at",u"Timelkam",5855,48,13.6 ],
    [ u"at",u"Traiskirchen",16212,48.016667,16.283333 ],
    [ u"at",u"Traismauer",5815,48.35,15.733333 ],
    [ u"at",u"Traun",23959,48.216667,14.233333 ],
    [ u"at",u"Trofaiach",8313,47.416667,15 ],
    [ u"at",u"Tulln",14201,48.333333,16.05 ],
    [ u"at",u"Velden am Worthersee",8817,46.616111,14.045833 ],
    [ u"at",u"Vienna",1569315,48.2,16.366667 ],
    [ u"at",u"Villach",58882,46.610278,13.855833 ],
    [ u"at",u"Vocklabruck",11887,48.016667,13.65 ],
    [ u"at",u"Vocklamarkt",4869,48,13.483333 ],
    [ u"at",u"Voitsberg",9980,47.033333,15.15 ],
    [ u"at",u"Volkermarkt",11543,46.662222,14.634444 ],
    [ u"at",u"Vols",6573,47.25,11.333333 ],
    [ u"at",u"Vomp",4628,47.333333,11.683333 ],
    [ u"at",u"Vorchdorf",7456,48,13.916667 ],
    [ u"at",u"Waidhofen",11774,47.966667,14.766667 ],
    [ u"at",u"Wattens",7517,47.283333,11.6 ],
    [ u"at",u"Weiz",9128,47.216667,15.616667 ],
    [ u"at",u"Wels",57947,48.166667,14.033333 ],
    [ u"at",u"Wernberg",5070,46.616667,13.933333 ],
    [ u"at",u"Wiener Neudorf",8530,48.066667,16.316667 ],
    [ u"at",u"Wiener Neustadt",38481,47.8,16.25 ],
    [ u"at",u"Wilhelmsburg",6718,48.1,15.6 ],
    [ u"at",u"Wolfsberg",25610,46.840556,14.844167 ],
    [ u"at",u"Wolfurt",8110,47.466667,9.75 ],
    [ u"at",u"Wolkersdorf",6416,48.383333,16.516667 ],
    [ u"at",u"Worgl",11265,47.483333,12.066667 ],
    [ u"at",u"Ybbs",5676,48.166667,15.083333 ],
    [ u"at",u"Zell am See",10046,47.316667,12.783333 ],
    [ u"at",u"Zeltweg",7726,47.183333,14.75 ],
    [ u"at",u"Zirl",6567,47.283333,11.233333 ],
    [ u"at",u"Zistersdorf",5661,48.533333,16.75 ],
    [ u"at",u"Zwettl",11718,48.616667,15.166667 ],
    [ u"au",u"Adelaide",1074168,-34.928661,138.598633 ],
    [ u"au",u"Albany",23913,-35.003101,117.865952 ],
    [ u"au",u"Albury",104261,-36.07494,146.923935 ],
    [ u"au",u"Alice Springs",26188,-23.697479,133.883621 ],
    [ u"au",u"Alyangula",1289,-13.85413,136.421295 ],
    [ u"au",u"Ararat",6111,-37.285419,142.927277 ],
    [ u"au",u"Armidale",22673,-30.50828,151.671234 ],
    [ u"au",u"Atherton",6959,-17.268641,145.47522 ],
    [ u"au",u"Australind",6621,-33.279202,115.715042 ],
    [ u"au",u"Ayr",9079,-19.573931,147.406662 ],
    [ u"au",u"Bairnsdale",11006,-37.822891,147.610413 ],
    [ u"au",u"Ballarat",85110,-37.56266,143.862579 ],
    [ u"au",u"Ballina",14248,-28.86414,153.565414 ],
    [ u"au",u"Batemans Bay",10557,-35.706581,150.175415 ],
    [ u"au",u"Benalla",9020,-36.551128,145.984253 ],
    [ u"au",u"Bendigo",81658,-36.758179,144.280243 ],
    [ u"au",u"Biloela",6309,-24.416667,150.5 ],
    [ u"au",u"Blackwater",7250,-23.583509,148.87912 ],
    [ u"au",u"Bongaree",13649,-27.08367,153.159424 ],
    [ u"au",u"Bowen",10983,-20.01367,148.247543 ],
    [ u"au",u"Bowral",9605,-34.477501,150.420395 ],
    [ u"au",u"Brisbane",1843459,-27.47101,153.024292 ],
    [ u"au",u"Broken Hill",17395,-31.961729,141.459976 ],
    [ u"au",u"Broome",13218,-17.955379,122.23922 ],
    [ u"au",u"Buderim",15228,-26.684429,153.057053 ],
    [ u"au",u"Bunbury",26370,-33.32711,115.641373 ],
    [ u"au",u"Bundaberg",52478,-24.866211,152.3479 ],
    [ u"au",u"Burnie",19976,-41.05584,145.903748 ],
    [ u"au",u"Burpengary",8280,-27.161131,152.959442 ],
    [ u"au",u"Busselton",12374,-33.652489,115.345497 ],
    [ u"au",u"Byron Bay",6764,-28.64201,153.611938 ],
    [ u"au",u"Caboolture",21478,-27.08465,152.951096 ],
    [ u"au",u"Cairns",154318,-16.92304,145.766251 ],
    [ u"au",u"Caloundra",38714,-26.797091,153.137711 ],
    [ u"au",u"Canberra",324025,-35.27603,149.13435 ],
    [ u"au",u"Carnarvon",7392,-24.88073,113.659401 ],
    [ u"au",u"Casino",9539,-28.858191,153.047485 ],
    [ u"au",u"Castlemaine",6604,-37.067089,144.216843 ],
    [ u"au",u"Cessnock",16394,-32.832111,151.356232 ],
    [ u"au",u"Charters Towers",9574,-20.07671,146.263535 ],
    [ u"au",u"Clifton Springs",7413,-38.1567,144.555099 ],
    [ u"au",u"Coffs Harbour",62978,-30.296261,153.11351 ],
    [ u"au",u"Colac",9089,-38.339001,143.584885 ],
    [ u"au",u"Collie",6337,-33.362061,116.156174 ],
    [ u"au",u"Coolum Beach",8555,-26.533331,153.091232 ],
    [ u"au",u"Cooma",6520,-36.234692,149.125977 ],
    [ u"au",u"Cootamundra",4934,-34.640949,148.028381 ],
    [ u"au",u"Corowa",5179,-35.999619,146.385803 ],
    [ u"au",u"Cowra",6799,-33.835541,148.696625 ],
    [ u"au",u"Craigieburn",19728,-37.6,144.95 ],
    [ u"au",u"Cranbourne",39420,-38.113419,145.283264 ],
    [ u"au",u"Crib Point",6908,-38.35,145.2 ],
    [ u"au",u"Dalby",9848,-27.18169,151.262054 ],
    [ u"au",u"Darwin",93081,-12.45722,130.836639 ],
    [ u"au",u"Deception Bay",16090,-27.193541,153.026306 ],
    [ u"au",u"Deniliquin",8024,-35.527409,144.959579 ],
    [ u"au",u"Devonport",19318,-41.176949,146.351517 ],
    [ u"au",u"Dubbo",29362,-32.24295,148.604843 ],
    [ u"au",u"Emerald",9399,-23.522961,148.157837 ],
    [ u"au",u"Esperance",7889,-33.86013,121.882591 ],
    [ u"au",u"Flinders",15000,-32.79924,134.211594 ],
    [ u"au",u"Forbes",4838,-33.384361,148.007599 ],
    [ u"au",u"Galiwinku",1347,-12.02811,135.564865 ],
    [ u"au",u"Gatton",6513,-27.558729,152.276184 ],
    [ u"au",u"Gawler",16362,-34.602509,138.749023 ],
    [ u"au",u"Geelong",150438,-38.153461,144.358093 ],
    [ u"au",u"Geraldton",27259,-28.778971,114.614594 ],
    [ u"au",u"Gladstone",30493,-23.84761,151.256348 ],
    [ u"au",u"Gold Coast",501175,-28.00029,153.430878 ],
    [ u"au",u"Goulburn",20941,-34.751549,149.720856 ],
    [ u"au",u"Grafton",16399,-29.690121,152.933365 ],
    [ u"au",u"Griffith",15456,-34.288528,146.050934 ],
    [ u"au",u"Gunnedah",7148,-30.98065,150.258377 ],
    [ u"au",u"Gympie",11029,-26.189159,152.658188 ],
    [ u"au",u"Hamilton",8869,-37.74334,142.028915 ],
    [ u"au",u"Hastings",6583,-38.3,145.183333 ],
    [ u"au",u"Healesville",7098,-37.65395,145.517181 ],
    [ u"au",u"Hervey Bay",47561,-25.285,152.873 ],
    [ u"au",u"Hobart",204863,-42.883209,147.331665 ],
    [ u"au",u"Horsham",12830,-36.711311,142.199814 ],
    [ u"au",u"Howard Springs",3359,-12.49576,131.044464 ],
    [ u"au",u"Ingham",6127,-18.645519,146.162476 ],
    [ u"au",u"Innisfail",10144,-17.522091,146.031021 ],
    [ u"au",u"Inverell",8561,-29.774031,151.111664 ],
    [ u"au",u"Jabiru",1892,-12.67558,132.831406 ],
    [ u"au",u"Karratha",11694,-20.73649,116.84638 ],
    [ u"au",u"Katherine",10142,-14.46517,132.263474 ],
    [ u"au",u"Kawana Waters",19881,-26.705999,153.131577 ],
    [ u"au",u"Kempsey",9522,-31.078979,152.830933 ],
    [ u"au",u"Kiama",10380,-34.668282,150.852188 ],
    [ u"au",u"Kingaroy",8573,-26.53994,151.837296 ],
    [ u"au",u"Kununurra",5679,-15.77813,128.744141 ],
    [ u"au",u"Kurri Kurri",10991,-32.819328,151.47908 ],
    [ u"au",u"Kwinana",20087,-32.230129,115.781281 ],
    [ u"au",u"Kyabram",6396,-36.313351,145.050354 ],
    [ u"au",u"Lakes Entrance",5849,-37.878941,147.995132 ],
    [ u"au",u"Lara",8179,-38.02388,144.406174 ],
    [ u"au",u"Launceston",72462,-41.438759,147.134674 ],
    [ u"au",u"Leeton",7299,-34.551048,146.404831 ],
    [ u"au",u"Lemon Tree Passage",5865,-32.731579,152.037186 ],
    [ u"au",u"Leopold",6120,-38.19001,144.468246 ],
    [ u"au",u"Lismore",31433,-28.81328,153.275803 ],
    [ u"au",u"Lithgow",11129,-33.482471,150.136307 ],
    [ u"au",u"Mackay",75924,-21.15345,149.165543 ],
    [ u"au",u"Mandurah",73369,-32.526901,115.721703 ],
    [ u"au",u"Maningrida",1391,-12.05111,134.22258 ],
    [ u"au",u"Mareeba",8403,-16.995001,145.423233 ],
    [ u"au",u"Maryborough",20680,-25.54073,152.704926 ],
    [ u"au",u"Maryborough",7046,-37.04562,143.739227 ],
    [ u"au",u"Medowie",5841,-32.741501,151.867599 ],
    [ u"au",u"Melbourne",3730212,-37.813938,144.963425 ],
    [ u"au",u"Melton",32369,-37.683392,144.585434 ],
    [ u"au",u"Mildura",47867,-34.185509,142.162506 ],
    [ u"au",u"Milingimbi",986,-12.10188,134.919006 ],
    [ u"au",u"Mittagong",6717,-34.45002,150.445724 ],
    [ u"au",u"Moranbah",7955,-21.99828,148.034836 ],
    [ u"au",u"Morayfield",10261,-27.108761,152.949066 ],
    [ u"au",u"Moree",8205,-29.46278,149.841568 ],
    [ u"au",u"Morwell",11585,-38.23476,146.394989 ],
    [ u"au",u"Moss Vale",6739,-34.553741,150.371155 ],
    [ u"au",u"Mount Barker",8357,-35.066667,138.866667 ],
    [ u"au",u"Mount Gambier",23210,-37.831799,140.77919 ],
    [ u"au",u"Mount Isa",22564,-20.725229,139.497269 ],
    [ u"au",u"Mudgee",9042,-32.433333,149.583333 ],
    [ u"au",u"Murray Bridge",11356,-35.119862,139.273453 ],
    [ u"au",u"Murwillumbah",6868,-28.32732,153.393387 ],
    [ u"au",u"Muswellbrook",11630,-32.261181,150.890091 ],
    [ u"au",u"Nambour",14919,-26.626129,152.959412 ],
    [ u"au",u"Nambucca Heads",6899,-30.643181,153.008835 ],
    [ u"au",u"Narrabri",7082,-30.32612,149.783707 ],
    [ u"au",u"Nelson Bay",7725,-32.720428,152.143982 ],
    [ u"au",u"Nerang",17684,-27.98941,153.336334 ],
    [ u"au",u"Newcastle",497961,-32.927792,151.784485 ],
    [ u"au",u"New Norfolk",5526,-42.78075,147.059387 ],
    [ u"au",u"Nguiu",1250,-11.75911,130.638153 ],
    [ u"au",u"Ngukurr",947,-14.73081,134.731018 ],
    [ u"au",u"Nhulunbuy",3202,-12.18652,136.782013 ],
    [ u"au",u"Northam",5858,-31.649321,116.674232 ],
    [ u"au",u"Orange",30402,-33.283089,149.100006 ],
    [ u"au",u"Pakenham",10602,-38.070179,145.474106 ],
    [ u"au",u"Palmerston",31075,-12.45722,130.836639 ],
    [ u"au",u"Parkes",11137,-33.137199,148.175903 ],
    [ u"au",u"Perth",1446715,-31.95224,115.861397 ],
    [ u"au",u"Port Augusta",12133,-32.495972,137.772812 ],
    [ u"au",u"Port Hedland",14289,-20.312149,118.610588 ],
    [ u"au",u"Port Keats",1351,-14.24029,129.52092 ],
    [ u"au",u"Portland",8842,-38.352612,141.605743 ],
    [ u"au",u"Port Lincoln",11247,-34.72625,135.87442 ],
    [ u"au",u"Port Macquarie",48553,-31.43084,152.908936 ],
    [ u"au",u"Port Pirie",12328,-33.191761,138.017456 ],
    [ u"au",u"Queanbeyan",32249,-35.354931,149.231995 ],
    [ u"au",u"Raymond Terrace",13606,-32.75,151.75 ],
    [ u"au",u"Rockhampton",65851,-23.38032,150.505951 ],
    [ u"au",u"Roebourne",19264,-20.772289,117.146477 ],
    [ u"au",u"Roma",5497,-26.56741,148.787506 ],
    [ u"au",u"Sale",12917,-38.11095,147.068024 ],
    [ u"au",u"Sawtell",14608,-30.36459,153.10141 ],
    [ u"au",u"Singleton",13813,-32.567421,151.166031 ],
    [ u"au",u"Somerville",7015,-38.216667,145.166667 ],
    [ u"au",u"Stawell",6991,-37.05632,142.780884 ],
    [ u"au",u"Sunbury",29926,-37.577419,144.726074 ],
    [ u"au",u"Swan Hill",9276,-35.3386,143.559525 ],
    [ u"au",u"Sydney",4394585,-33.861481,151.205475 ],
    [ u"au",u"Tamworth",38552,-31.090481,150.929047 ],
    [ u"au",u"Taree",44183,-31.91099,152.453873 ],
    [ u"au",u"Toowoomba",92802,-27.56056,151.953857 ],
    [ u"au",u"Torquay",6670,-25.283333,152.866667 ],
    [ u"au",u"Townsville",138959,-19.26639,146.805695 ],
    [ u"au",u"Traralgon",18226,-38.195278,146.541504 ],
    [ u"au",u"Tumut",6526,-35.300159,148.225052 ],
    [ u"au",u"Ulladulla",9250,-35.359058,150.472473 ],
    [ u"au",u"Ulverstone",9605,-41.160259,146.182419 ],
    [ u"au",u"Victor Harbor",7760,-35.550419,138.621536 ],
    [ u"au",u"Victoria Point",11930,-27.58329,153.311722 ],
    [ u"au",u"Wagga Wagga",55382,-35.125771,147.353745 ],
    [ u"au",u"Wangaratta",14023,-36.358459,146.320557 ],
    [ u"au",u"Warragul",9128,-38.159119,145.931183 ],
    [ u"au",u"Warrnambool",29928,-38.38176,142.487991 ],
    [ u"au",u"Warwick",12347,-28.219009,152.034378 ],
    [ u"au",u"Wellington",5428,-32.555882,148.945084 ],
    [ u"au",u"Whyalla",19646,-33.032681,137.564835 ],
    [ u"au",u"Wodonga",31518,-36.121792,146.888092 ],
    [ u"au",u"Wollongong",260918,-34.424,150.893448 ],
    [ u"au",u"Wonthaggi",5985,-38.605862,145.593552 ],
    [ u"au",u"Yeppoon",10769,-23.126829,150.744064 ],
    [ u"au",u"Young",7501,-34.313499,148.301071 ],
    [ u"au",u"Yulara",3903,-25.245291,130.980545 ],
    [ u"aw",u"Oranjestad",29998,12.5166667,-70.0333333 ],
    [ u"az",u"Agdam",39451,39.99096,46.927356 ],
    [ u"az",u"Agdas",23528,40.65,47.476111 ],
    [ u"az",u"Agstafa",12542,41.118889,45.453889 ],
    [ u"az",u"Agsu",17209,40.569167,48.396476 ],
    [ u"az",u"Alunitdag",857,40.521667,46.080556 ],
    [ u"az",u"Aran",6724,40.625278,46.975556 ],
    [ u"az",u"Artyom",13435,40.472255,50.333041 ],
    [ u"az",u"Astara",15190,38.455977,48.87498 ],
    [ u"az",u"Badamdar",11398,40.339444,49.803889 ],
    [ u"az",u"Baku",1116513,40.395278,49.882222 ],
    [ u"az",u"Basqal",1234,40.7552,48.391044 ],
    [ u"az",u"Buzovna",24795,40.517888,50.113901 ],
    [ u"az",u"Ceyranbatan",5684,40.540833,49.659722 ],
    [ u"az",u"Corat",8624,40.5725,49.706389 ],
    [ u"az",u"Culfa",10820,38.9558,45.6308 ],
    [ u"az",u"Gilazi",3277,40.903896,49.335522 ],
    [ u"az",u"Gilazi",3277,40.870977,49.342333 ],
    [ u"az",u"Goranboy",7334,40.610278,46.789722 ],
    [ u"az",u"Göyçay",35348,40.653056,47.740556 ],
    [ u"az",u"Gürgan",712,40.397462,50.336733 ],
    [ u"az",u"Guzdak",2462,40.374444,49.681944 ],
    [ u"az",u"Hadrut",2523,39.520018,47.0318 ],
    [ u"az",u"Haftoni",2003,38.763253,48.762231 ],
    [ u"az",u"Hasanabad",4308,39.336672,49.214143 ],
    [ u"az",u"Horadiz",2714,39.448771,47.335313 ],
    [ u"az",u"Hövsan",36293,40.374444,50.085278 ],
    [ u"az",u"Imisli",31381,39.871307,48.064094 ],
    [ u"az",u"Istisu",929,39.947532,45.962121 ],
    [ u"az",u"Kesla",17913,40.397778,49.898611 ],
    [ u"az",u"Kijäba",4567,38.532778,48.816667 ],
    [ u"az",u"Kirovskiy",34488,40.433333,49.85 ],
    [ u"az",u"Korgöz",2036,40.303056,49.62 ],
    [ u"az",u"Lerik",7094,38.772633,48.412788 ],
    [ u"az",u"Lökbatan",30694,40.323718,49.728038 ],
    [ u"az",u"Masalli",9603,39.027781,48.670276 ],
    [ u"az",u"Mastaga",40092,40.532778,50.003889 ],
    [ u"az",u"Mincivan",6353,39.029348,46.718471 ],
    [ u"az",u"Mugan",4410,40.095182,48.821136 ],
    [ u"az",u"Naftalan",7045,40.506667,46.825 ],
    [ u"az",u"Nardaran",7700,40.556111,50.005556 ],
    [ u"az",u"Neftçala",18661,39.37417,49.247224 ],
    [ u"az",u"Ordubad",9781,38.905954,46.023411 ],
    [ u"az",u"Pirsagi",5102,40.564032,49.8913 ],
    [ u"az",u"Pushkino",18182,39.458333,48.545 ],
    [ u"az",u"Puta",1018,40.296667,49.660278 ],
    [ u"az",u"Qabaqçöl",1293,41.72,46.264722 ],
    [ u"az",u"Qala",2709,40.44182,50.168121 ],
    [ u"az",u"Qaraçala",4211,39.813178,48.952303 ],
    [ u"az",u"Qaraçuxur",72989,40.396667,49.973611 ],
    [ u"az",u"Qarayeri",5565,40.78862,46.306589 ],
    [ u"az",u"Qax",11993,41.4225,46.924167 ],
    [ u"az",u"Qazanbulaq",980,40.618611,46.645278 ],
    [ u"az",u"Qazax",18904,41.093333,45.366111 ],
    [ u"az",u"Qobu",7377,40.404722,49.713056 ],
    [ u"az",u"Qobustan",13398,40.08238,49.412048 ],
    [ u"az",u"Qovlar",12819,40.942137,45.732171 ],
    [ u"az",u"Quba",22405,41.362587,48.515186 ],
    [ u"az",u"Qusar",16022,41.427284,48.42893 ],
    [ u"az",u"Quscu",408,40.555556,46.091944 ],
    [ u"az",u"Ramana",8855,40.442222,49.980556 ],
    [ u"az",u"Sabirabad",28076,40.009458,48.475154 ],
    [ u"az",u"Sabunçu",20996,40.4425,49.948056 ],
    [ u"az",u"Sahbuz",2674,39.407222,45.573889 ],
    [ u"az",u"Salyan",36555,39.593615,48.980552 ],
    [ u"az",u"Samur",1760,41.632544,48.430248 ],
    [ u"az",u"Saray",10173,40.532222,49.716389 ],
    [ u"az",u"Sollar",205,41.639727,48.664408 ],
    [ u"az",u"Sonqar",730,40.322099,49.601085 ],
    [ u"az",u"Suraabad",1945,40.819244,49.468745 ],
    [ u"az",u"Susa",18663,39.758934,46.749187 ],
    [ u"az",u"Tovuz",12626,40.992222,45.628889 ],
    [ u"az",u"Türkan",9699,40.363889,50.215 ],
    [ u"az",u"Türyançay",307,40.7088,47.54326 ],
    [ u"az",u"Ucar",15741,40.518333,47.654167 ],
    [ u"az",u"Vurgun",2635,41.094229,45.471616 ],
    [ u"az",u"Xaçmaz",37175,41.463489,48.80605 ],
    [ u"az",u"Xanlar",17816,40.586944,46.315833 ],
    [ u"az",u"Xocali",5810,39.9,46.866667 ],
    [ u"az",u"Xocali",5810,39.912973,46.790284 ],
    [ u"az",u"Xocasan",5089,40.413484,49.772088 ],
    [ u"az",u"Xudat",13625,41.630965,48.681 ],
    [ u"az",u"Yevlax",53715,40.612732,47.142329 ],
    [ u"az",u"Zabrat",21396,40.476104,49.941582 ],
    [ u"az",u"Zaqatala",18277,41.633611,46.643333 ],
    [ u"az",u"Zig",6001,40.343889,49.969167 ],
    [ u"ba",u"Banja Luka",221100,44.7758333,17.1855556 ],
    [ u"ba",u"Banovici",7211,44.4041667,18.4475 ],
    [ u"ba",u"Barice",3697,44.5405556,18.4811111 ],
    [ u"ba",u"Batkovici",4923,44.8536111,19.1963889 ],
    [ u"ba",u"Bihac",75641,44.8169444,15.8708333 ],
    [ u"ba",u"Bijela",3484,43.6086111,17.9519444 ],
    [ u"ba",u"Bijeljina",37691,44.7569444,19.2161111 ],
    [ u"ba",u"Bila",4397,43.7825,16.9252778 ],
    [ u"ba",u"Bileca",13256,42.8719444,18.4297222 ],
    [ u"ba",u"Blagaj",4715,43.2575,17.8886111 ],
    [ u"ba",u"Blatnica",5675,44.3530556,17.5894444 ],
    [ u"ba",u"Bosanska Dubica",9959,45.1766667,16.8094444 ],
    [ u"ba",u"Bosanska Gradiska",13345,45.1411111,17.25 ],
    [ u"ba",u"Bosanska Kostajnica",4739,45.2197222,16.5358333 ],
    [ u"ba",u"Bosanska Krupa",15193,44.8825,16.1513889 ],
    [ u"ba",u"Bosanski Brod",9249,45.1375,17.9897222 ],
    [ u"ba",u"Bosanski Novi",8920,45.0458333,16.3802778 ],
    [ u"ba",u"Bosanski Samac",3599,45.0591667,18.4669444 ],
    [ u"ba",u"Bosansko Grahovo",5642,44.1794444,16.3638889 ],
    [ u"ba",u"Bratunac",4717,44.1875,19.3394444 ],
    [ u"ba",u"Brcko",38478,44.8727778,18.8083333 ],
    [ u"ba",u"Breza",3732,44.0161111,18.2588889 ],
    [ u"ba",u"Bronzani Majdan",3945,44.7869444,16.9311111 ],
    [ u"ba",u"Bugojno",41378,44.0572222,17.4508333 ],
    [ u"ba",u"Busovaca",4775,44.0975,17.8788889 ],
    [ u"ba",u"Buzim",7229,45.0547222,16.0319444 ],
    [ u"ba",u"Cajnice",3908,43.5575,19.0711111 ],
    [ u"ba",u"Capljina",7923,43.1138889,17.7036111 ],
    [ u"ba",u"Careva Cuprija",3954,44.2658333,18.4291667 ],
    [ u"ba",u"Cazin",21741,44.9669444,15.9430556 ],
    [ u"ba",u"Cecava",3847,44.6866667,17.7705556 ],
    [ u"ba",u"Celinac",6670,44.7227778,17.3277778 ],
    [ u"ba",u"Cim",3966,43.3527778,17.7772222 ],
    [ u"ba",u"Citluk",5718,43.2286111,17.7008333 ],
    [ u"ba",u"Coralici",5223,44.9830556,15.9041667 ],
    [ u"ba",u"Crnici",5789,43.1288889,17.8666667 ],
    [ u"ba",u"Derventa",9772,44.9772222,17.9102778 ],
    [ u"ba",u"Divicani",7250,44.3666667,17.3261111 ],
    [ u"ba",u"Doboj",27234,44.7347222,18.0877778 ],
    [ u"ba",u"Dobrinje",3987,44.0497222,18.1194444 ],
    [ u"ba",u"Dobrljin",3581,45.1469444,16.5033333 ],
    [ u"ba",u"Donja Dubica",3489,45.075,18.4113889 ],
    [ u"ba",u"Donja Mahala",5565,45.0469444,18.6663889 ],
    [ u"ba",u"Donja Medjidja",3782,44.8025,18.4033333 ],
    [ u"ba",u"Donja Orahovica",5612,44.6530556,18.3702778 ],
    [ u"ba",u"Donje Dubrave",3811,44.4811111,18.6961111 ],
    [ u"ba",u"Donje Vukovije",3535,44.4636111,18.7538889 ],
    [ u"ba",u"Donji Vakuf",7955,44.1436111,17.4 ],
    [ u"ba",u"Dreznica",3908,43.5288889,17.2819444 ],
    [ u"ba",u"Drinovci",3791,43.355,17.3538889 ],
    [ u"ba",u"Dubravica",3868,44.4419444,18.1180556 ],
    [ u"ba",u"Foca",14614,43.505,18.7786111 ],
    [ u"ba",u"Fojnica",8244,43.9625,17.8983333 ],
    [ u"ba",u"Gacko",3417,43.1672222,18.5352778 ],
    [ u"ba",u"Glamoc",4015,44.0458333,16.8486111 ],
    [ u"ba",u"Gnojnica",3985,44.6205556,18.4466667 ],
    [ u"ba",u"Gorazde",17649,43.6669444,18.9763889 ],
    [ u"ba",u"Gornja Koprivna",4600,45.0119444,15.9572222 ],
    [ u"ba",u"Gornja Tuzla",4864,44.5561111,18.7613889 ],
    [ u"ba",u"Gornje Dubrave",4821,44.4713889,18.7297222 ],
    [ u"ba",u"Gornje Zivinice",4661,44.4286111,18.6169444 ],
    [ u"ba",u"Gornji Vakuf",7014,43.9380556,17.5883333 ],
    [ u"ba",u"Gostovici",5802,44.415,18.1583333 ],
    [ u"ba",u"Gracanica",15758,44.7033333,18.3097222 ],
    [ u"ba",u"Gradacac",15659,44.8808333,18.4269444 ],
    [ u"ba",u"Gromiljak",6457,43.9666667,18.0530556 ],
    [ u"ba",u"Grude",4627,43.3641667,17.4205556 ],
    [ u"ba",u"Hadzici",7173,43.8222222,18.2066667 ],
    [ u"ba",u"Hotonj",4013,43.8947222,18.3727778 ],
    [ u"ba",u"Ilici",3688,43.3472222,17.7680556 ],
    [ u"ba",u"Ilijas",5854,43.9508333,18.2708333 ],
    [ u"ba",u"Izacic",4089,44.875,15.7819444 ],
    [ u"ba",u"Jablanica",6209,43.6602778,17.7616667 ],
    [ u"ba",u"Jajce",9762,44.3422222,17.2655556 ],
    [ u"ba",u"Janja",5543,44.6652778,19.2477778 ],
    [ u"ba",u"Jelah",5291,44.6541667,17.9580556 ],
    [ u"ba",u"Jezerski",4361,44.9808333,16.0841667 ],
    [ u"ba",u"Kacuni",5042,44.065,17.9386111 ],
    [ u"ba",u"Kakanj",12405,44.1272222,18.1180556 ],
    [ u"ba",u"Karadaglije",3700,44.5716667,18.0183333 ],
    [ u"ba",u"Kiseljak",3447,44.4888889,18.5688889 ],
    [ u"ba",u"Kladanj",6783,44.2263889,18.6913889 ],
    [ u"ba",u"Kljuc",7244,44.535,16.7722222 ],
    [ u"ba",u"Knezica",4792,45.1027778,16.6775 ],
    [ u"ba",u"Kobilja Glava",3666,43.8819444,18.3891667 ],
    [ u"ba",u"Kocerin",3516,43.3897222,17.485 ],
    [ u"ba",u"Konjic",15950,43.6519444,17.9613889 ],
    [ u"ba",u"Koran",3394,43.8102778,18.5688889 ],
    [ u"ba",u"Laktasi",6464,44.9080556,17.3008333 ],
    [ u"ba",u"Lamovita",4582,44.9255556,16.9072222 ],
    [ u"ba",u"Lijesnica",3559,44.4941667,18.0741667 ],
    [ u"ba",u"Listica",9370,43.3833333,17.5927778 ],
    [ u"ba",u"Livno",11748,43.8269444,17.0077778 ],
    [ u"ba",u"Ljubinje",4235,42.9508333,18.0886111 ],
    [ u"ba",u"Ljubuski",9987,43.1969444,17.545 ],
    [ u"ba",u"Lokvine",3928,44.2047222,17.8563889 ],
    [ u"ba",u"Lopare",3614,44.6377778,18.8427778 ],
    [ u"ba",u"Lukavac",12607,44.5419444,18.5258333 ],
    [ u"ba",u"Lukavica",4084,44.7627778,18.1688889 ],
    [ u"ba",u"Maglajani",4221,44.9486111,17.3494444 ],
    [ u"ba",u"Maglaj",7398,44.5491667,18.0966667 ],
    [ u"ba",u"Mala Kladusa",6033,45.1341667,15.8586111 ],
    [ u"ba",u"Malesici",3764,44.7380556,18.2738889 ],
    [ u"ba",u"Maricka",3707,44.8588889,16.8522222 ],
    [ u"ba",u"Maslovare",4899,44.5655556,17.5336111 ],
    [ u"ba",u"Milici",8210,44.1316667,19.0316667 ],
    [ u"ba",u"Mionica",8701,44.8672222,18.4630556 ],
    [ u"ba",u"Modrica",5135,44.9544444,18.3036111 ],
    [ u"ba",u"Mostar",104517,43.3433333,17.8080556 ],
    [ u"ba",u"Mostre",4009,44.025,18.1413889 ],
    [ u"ba",u"Mramor",3918,44.5916667,18.5644444 ],
    [ u"ba",u"Mrkonjic Grad",14737,44.4158333,17.0861111 ],
    [ u"ba",u"Nevesinje",7312,43.2586111,18.1133333 ],
    [ u"ba",u"Novi Seher",4416,44.5102778,18.0258333 ],
    [ u"ba",u"Novi Travnik",10006,44.1711111,17.6575 ],
    [ u"ba",u"Obudovac",2171,44.965,18.6122222 ],
    [ u"ba",u"Odzak",11621,45.0111111,18.3266667 ],
    [ u"ba",u"Olovo",3305,44.13,18.5827778 ],
    [ u"ba",u"Omarska",6466,44.89,16.8991667 ],
    [ u"ba",u"Orasac",3856,44.6288889,16.0711111 ],
    [ u"ba",u"Orasje",3613,45.0355556,18.6933333 ],
    [ u"ba",u"Orguz",4371,43.7738889,16.8638889 ],
    [ u"ba",u"Ostra Luka",3923,45.0,18.5883333 ],
    [ u"ba",u"Ostrozac",5456,44.9086111,15.9402778 ],
    [ u"ba",u"Otoka",6595,44.96,16.1791667 ],
    [ u"ba",u"Pajic Polje",4026,43.9758333,17.5275 ],
    [ u"ba",u"Pale",7458,43.8161111,18.5694444 ],
    [ u"ba",u"Pazaric",4787,43.7886111,18.1608333 ],
    [ u"ba",u"Pecigrad",6514,45.0544444,15.8969444 ],
    [ u"ba",u"Peci",3650,44.6272222,16.7861111 ],
    [ u"ba",u"Petkovci",2211,44.4530556,19.0761111 ],
    [ u"ba",u"Piskavica",3797,44.8341667,16.9888889 ],
    [ u"ba",u"Pjanici",3537,44.9836111,15.8227778 ],
    [ u"ba",u"Podbrdo",4028,44.4408333,17.0138889 ],
    [ u"ba",u"Podhum",5801,43.7230556,17.0011111 ],
    [ u"ba",u"Podzvizd",6665,45.1741667,15.8736111 ],
    [ u"ba",u"Polje",3799,43.8805556,18.0744444 ],
    [ u"ba",u"Posusje",5114,43.4722222,17.3266667 ],
    [ u"ba",u"Potoci",8311,43.4086111,17.8786111 ],
    [ u"ba",u"Pribinic",3558,44.6105556,17.6905556 ],
    [ u"ba",u"Priboj",4351,44.6027778,18.9313889 ],
    [ u"ba",u"Prijedor",36346,44.9813889,16.7130556 ],
    [ u"ba",u"Prnjavor",7098,44.8702778,17.6627778 ],
    [ u"ba",u"Prozor",10349,43.8222222,17.6091667 ],
    [ u"ba",u"Puracic",3461,44.5469444,18.4766667 ],
    [ u"ba",u"Radisici",4071,43.2219444,17.5430556 ],
    [ u"ba",u"Rodoc",5159,43.3088889,17.8069444 ],
    [ u"ba",u"Rogatica",4946,43.8008333,19.0025 ],
    [ u"ba",u"Rumboci",3854,43.8322222,17.5011111 ],
    [ u"ba",u"Sanica",5666,44.6141667,16.6411111 ],
    [ u"ba",u"Sanski Most",13550,44.7652778,16.6655556 ],
    [ u"ba",u"Sarajevo",696726,43.85,18.3833333 ],
    [ u"ba",u"Sekovici",6315,44.2986111,18.8527778 ],
    [ u"ba",u"Serici",3663,44.4652778,18.5580556 ],
    [ u"ba",u"Sipovo",10737,44.2813889,17.0838889 ],
    [ u"ba",u"Skender Vakuf",6866,44.4908333,17.3775 ],
    [ u"ba",u"Skokovi",3553,45.0313889,15.9144444 ],
    [ u"ba",u"Sladna",4304,44.7294444,18.4241667 ],
    [ u"ba",u"Sokolac",8842,43.9397222,18.8016667 ],
    [ u"ba",u"Solina",4780,44.5602778,18.6947222 ],
    [ u"ba",u"Srbac",7380,45.0977778,17.525 ],
    [ u"ba",u"Srebrenica",2861,44.1063889,19.2969444 ],
    [ u"ba",u"Srebrenik",6723,44.7077778,18.4880556 ],
    [ u"ba",u"Stanari",3590,44.7472222,17.8294444 ],
    [ u"ba",u"Stijena",10844,44.9352778,16.0172222 ],
    [ u"ba",u"Stolac",7733,43.0844444,17.9575 ],
    [ u"ba",u"Stupari",4424,44.3147222,18.6841667 ],
    [ u"ba",u"Sturlic",5013,45.0638889,15.7780556 ],
    [ u"ba",u"Sumatac",4987,45.0988889,15.8575 ],
    [ u"ba",u"Svodna",4387,45.0372222,16.5383333 ],
    [ u"ba",u"Svojat",3515,44.3947222,18.7391667 ],
    [ u"ba",u"Tesanjka",5666,44.6730556,18.0127778 ],
    [ u"ba",u"Tesanj",7549,44.6116667,17.9872222 ],
    [ u"ba",u"Teslic",6404,44.6063889,17.8597222 ],
    [ u"ba",u"Todorovo",9560,45.0883333,15.9308333 ],
    [ u"ba",u"Tojsici",6587,44.4813889,18.7869444 ],
    [ u"ba",u"Tolisa",4282,45.0430556,18.6427778 ],
    [ u"ba",u"Tomislavgrad",7737,43.7180556,17.2266667 ],
    [ u"ba",u"Travnik",31127,44.2266667,17.6705556 ],
    [ u"ba",u"Trebinje",33177,42.7119444,18.3441667 ],
    [ u"ba",u"Trn",7553,44.8597222,17.2363889 ],
    [ u"ba",u"Trzacka Rastela",6617,44.9733333,15.7902778 ],
    [ u"ba",u"Turbe",4766,44.2436111,17.5713889 ],
    [ u"ba",u"Tuzla",142484,44.5427778,18.6694444 ],
    [ u"ba",u"Ugljevik",3452,44.6636111,19.0202778 ],
    [ u"ba",u"Ustikolina",4446,43.5836111,18.79 ],
    [ u"ba",u"Vares",7193,44.1644444,18.3283333 ],
    [ u"ba",u"Varoska Rijeka",6573,45.0847222,16.0141667 ],
    [ u"ba",u"Velagici",4972,44.5572222,16.7316667 ],
    [ u"ba",u"Velika Kladusa",19330,45.1894444,15.8116667 ],
    [ u"ba",u"Velika Obarska",5142,44.8052778,19.1641667 ],
    [ u"ba",u"Vidosi",3905,43.7713889,17.0283333 ],
    [ u"ba",u"Visegrad",6086,43.7847222,19.2991667 ],
    [ u"ba",u"Visoko",17890,43.9888889,18.1780556 ],
    [ u"ba",u"Vitez",8140,44.1544444,17.7902778 ],
    [ u"ba",u"Vitina",4384,43.2375,17.4838889 ],
    [ u"ba",u"Vlasenica",4508,44.1819444,18.9405556 ],
    [ u"ba",u"Vogosca",8179,43.9019444,18.3480556 ],
    [ u"ba",u"Voljevac",3764,43.8786111,17.6591667 ],
    [ u"ba",u"Vozuca",3209,44.3613889,18.3577778 ],
    [ u"ba",u"Vrnograc",6859,45.1636111,15.9536111 ],
    [ u"ba",u"Zabrisce",4261,43.7925,16.9422222 ],
    [ u"ba",u"Zavidovici",14380,44.4458333,18.1497222 ],
    [ u"ba",u"Zboriste",4922,45.1458333,16.0177778 ],
    [ u"ba",u"Zeljezno Polje",5783,44.4083333,17.9319444 ],
    [ u"ba",u"Zenica",164422,44.2013889,17.9063889 ],
    [ u"ba",u"Zepce",8502,44.4266667,18.0377778 ],
    [ u"ba",u"Zivinice",13640,44.4494444,18.6497222 ],
    [ u"ba",u"Zivinice",3718,44.5472222,17.375 ],
    [ u"ba",u"Zvornik",8024,44.3869444,19.1013889 ],
    [ u"bb",u"Bathsheba",1765,13.2166667,-59.5166667 ],
    [ u"bb",u"Blackmans",623,13.1833333,-59.5333333 ],
    [ u"bb",u"Bridgetown",98511,13.1,-59.6166667 ],
    [ u"bb",u"Crab Hill",727,13.3166667,-59.6333333 ],
    [ u"bb",u"Greenland",623,13.25,-59.5666667 ],
    [ u"bb",u"Hillaby",519,13.2166667,-59.5833333 ],
    [ u"bb",u"Holetown",1350,13.1833333,-59.65 ],
    [ u"bb",u"Oistins",2285,13.0666667,-59.5333333 ],
    [ u"bb",u"Speightstown",3634,13.25,-59.65 ],
    [ u"bd",u"Abhaynagar",42658,23.0166667,89.4666667 ],
    [ u"bd",u"Badarganj",32604,25.6666667,89.05 ],
    [ u"bd",u"Bajitpur",34564,24.2166667,90.95 ],
    [ u"bd",u"Bandarban",32526,22.2,92.2166667 ],
    [ u"bd",u"Baniachang",37812,24.5166667,91.3666667 ],
    [ u"bd",u"Barisal",280437,22.7,90.3666667 ],
    [ u"bd",u"Bera",39608,24.0833333,89.6166667 ],
    [ u"bd",u"Bhairab Bazar",105470,24.0666667,90.9666667 ],
    [ u"bd",u"Bhandaria",30222,22.4833333,90.0666667 ],
    [ u"bd",u"Bheramara",38164,24.0333333,88.9666667 ],
    [ u"bd",u"Bhola",99090,22.6833333,90.65 ],
    [ u"bd",u"Chandpur",120183,23.15,90.7166667 ],
    [ u"bd",u"Char Bhadrasan",34427,23.3166667,90.2166667 ],
    [ u"bd",u"Chhagalnaiya",39339,23.03,91.5069444 ],
    [ u"bd",u"Chhatak",39223,25.0333333,91.6666667 ],
    [ u"bd",u"Chilmari",49742,25.55,89.7166667 ],
    [ u"bd",u"Dhaka",6493177,23.7230556,90.4086111 ],
    [ u"bd",u"Dhamrai",38003,23.9122222,90.2683333 ],
    [ u"bd",u"Dinajpur",206251,25.6333333,88.6333333 ],
    [ u"bd",u"Dohar",45549,23.5883333,90.1469444 ],
    [ u"bd",u"Faridpur",112200,23.6,89.8333333 ],
    [ u"bd",u"Fatikchhari",39974,22.725,91.7675 ],
    [ u"bd",u"Feni",84038,23.0186111,91.41 ],
    [ u"bd",u"Gafargaon",34181,24.4333333,90.5666667 ],
    [ u"bd",u"Gaurnadi",40524,22.9666667,90.2333333 ],
    [ u"bd",u"Gazipur",132249,23.8,90.65 ],
    [ u"bd",u"Habiganj",88770,24.3833333,91.4166667 ],
    [ u"bd",u"Hajiganj",44349,23.2511111,90.8591667 ],
    [ u"bd",u"Ishurdi",82005,24.1333333,89.0833333 ],
    [ u"bd",u"Jaipur Hat",73076,25.1,89.0166667 ],
    [ u"bd",u"Jamalpur",167914,24.9166667,89.9333333 ],
    [ u"bd",u"Jhikargachha",41962,23.1166667,89.1166667 ],
    [ u"bd",u"Kalia",40497,23.05,89.6333333 ],
    [ u"bd",u"Kaliganj",45636,23.4166667,89.1333333 ],
    [ u"bd",u"Keshabpur",30930,22.9166667,89.2166667 ],
    [ u"bd",u"Khagrachari",50364,23.1,91.9666667 ],
    [ u"bd",u"Khulna",1342429,22.8,89.55 ],
    [ u"bd",u"Kishorganj",90700,24.4333333,90.7666667 ],
    [ u"bd",u"Laksham",82299,23.2472222,91.1425 ],
    [ u"bd",u"Lakshmipur",61710,22.95,90.8333333 ],
    [ u"bd",u"Lalmanir Hat",65135,25.9,89.45 ],
    [ u"bd",u"Lalmohan",42225,22.3166667,90.7166667 ],
    [ u"bd",u"Madaripur",84799,23.1752778,90.2072222 ],
    [ u"bd",u"Manikchhari",24836,22.8386111,91.8455556 ],
    [ u"bd",u"Manikganj",85800,23.8552778,90.0125 ],
    [ u"bd",u"Mathbaria",29764,22.3,89.95 ],
    [ u"bd",u"Maulvi Bazar",57448,24.4833333,91.7833333 ],
    [ u"bd",u"Mehendiganj",39429,22.8166667,90.5333333 ],
    [ u"bd",u"Mirzapur",41142,24.1,90.1 ],
    [ u"bd",u"Morrelganj",31651,22.4666667,89.85 ],
    [ u"bd",u"Muktagachha",24687,24.7666667,90.2333333 ],
    [ u"bd",u"Nabinagar",31675,23.8916667,90.9733333 ],
    [ u"bd",u"Nageshwari",49431,25.9666667,89.7166667 ],
    [ u"bd",u"Nalchiti",38708,22.6333333,90.2833333 ],
    [ u"bd",u"Naral",55118,23.1666667,89.5 ],
    [ u"bd",u"Narayanganj",223773,23.6233333,90.5011111 ],
    [ u"bd",u"Narsingdi",281110,23.9208333,90.7180556 ],
    [ u"bd",u"Nawabganj",142373,24.6,88.2833333 ],
    [ u"bd",u"Netrakona",79025,24.8833333,90.7166667 ],
    [ u"bd",u"Pabna",137904,24.0,89.25 ],
    [ u"bd",u"Palang",67659,23.2166667,90.35 ],
    [ u"bd",u"Panchagarh",48536,26.3333333,88.5666667 ],
    [ u"bd",u"Parbatipur",48026,25.65,88.9166667 ],
    [ u"bd",u"Patiya",51367,22.3030556,91.9783333 ],
    [ u"bd",u"Phultala",37990,22.7,89.5166667 ],
    [ u"bd",u"Pirganj",34610,25.8666667,88.3666667 ],
    [ u"bd",u"Pirojpur",54424,22.5666667,89.9833333 ],
    [ u"bd",u"Rajshahi",700206,24.3666667,88.6 ],
    [ u"bd",u"Ramganj",55247,23.1,90.85 ],
    [ u"bd",u"Ramgarh",28017,22.9702778,91.7966667 ],
    [ u"bd",u"Rangpur",285586,25.75,89.25 ],
    [ u"bd",u"Raozan",25711,22.5661111,91.9325 ],
    [ u"bd",u"Raypur",64659,23.05,90.7666667 ],
    [ u"bd",u"Sakhipur",40874,24.3,90.1833333 ],
    [ u"bd",u"Sarankhola",36475,22.3,89.7833333 ],
    [ u"bd",u"Sarishabari",81334,24.7333333,89.8333333 ],
    [ u"bd",u"Satkhira",128933,22.7166667,89.1 ],
    [ u"bd",u"Sherpur",107431,25.0166667,90.0166667 ],
    [ u"bd",u"Shibganj",35965,24.6833333,88.1666667 ],
    [ u"bd",u"Sirajganj",167501,24.45,89.7166667 ],
    [ u"bd",u"Sunamganj",76491,25.0666667,91.4 ],
    [ u"bd",u"Teknaf",40562,20.8666667,92.3 ],
    [ u"bd",u"Thakurgaon",71104,26.0333333,88.4666667 ],
    [ u"bd",u"Tungi",337620,23.89,90.4058333 ],
    [ u"be",u"Aalst",77534,50.933333,4.033333 ],
    [ u"be",u"Aalter",18802,51.083333,3.45 ],
    [ u"be",u"Aarschot",27656,50.983333,4.833333 ],
    [ u"be",u"Aartselaar",14193,51.133333,4.383333 ],
    [ u"be",u"Alken",10933,50.866667,5.3 ],
    [ u"be",u"Alveringem",4910,51.016667,2.716667 ],
    [ u"be",u"Amay",13307,50.55,5.316667 ],
    [ u"be",u"Amel",5221,50.35,6.15 ],
    [ u"be",u"Andenne",24055,50.483333,5.1 ],
    [ u"be",u"Anderlues",11597,50.4,4.266667 ],
    [ u"be",u"Anhée",7125,50.316667,4.883333 ],
    [ u"be",u"Ans",27297,50.65,5.533333 ],
    [ u"be",u"Anthisnes",4116,50.483333,5.516667 ],
    [ u"be",u"Antoing",7507,50.566667,3.45 ],
    [ u"be",u"Antwerp",459805,51.216667,4.416667 ],
    [ u"be",u"Anzegem",13920,50.833333,3.466667 ],
    [ u"be",u"Ardooie",9161,50.983333,3.2 ],
    [ u"be",u"Arendonk",12247,51.316667,5.083333 ],
    [ u"be",u"Arlon",26179,49.683333,5.816667 ],
    [ u"be",u"As",7250,51.016667,5.583333 ],
    [ u"be",u"Asse",28985,50.916667,4.2 ],
    [ u"be",u"Assenede",13495,51.233333,3.75 ],
    [ u"be",u"Assesse",6279,50.366667,5.016667 ],
    [ u"be",u"Ath",26681,50.633333,3.783333 ],
    [ u"be",u"Attert",4491,49.766667,5.783333 ],
    [ u"be",u"Aubange",14932,49.583333,5.8 ],
    [ u"be",u"Aubel",4119,50.7,5.85 ],
    [ u"be",u"Avelgem",9106,50.766667,3.433333 ],
    [ u"be",u"Awans",8612,50.666667,5.466667 ],
    [ u"be",u"Aywaille",10636,50.466667,5.666667 ],
    [ u"be",u"Baarle-Hertog",2305,51.45,4.933333 ],
    [ u"be",u"Baelen",3928,50.633333,5.966667 ],
    [ u"be",u"Balen",19978,51.166667,5.15 ],
    [ u"be",u"Bassenge",8151,50.766667,5.6 ],
    [ u"be",u"Bastogne",14395,50,5.716667 ],
    [ u"be",u"Beaumont",6645,50.233333,4.233333 ],
    [ u"be",u"Beauraing",8242,50.116667,4.966667 ],
    [ u"be",u"Beauvechain",6334,50.783333,4.766667 ],
    [ u"be",u"Beernem",14512,51.15,3.333333 ],
    [ u"be",u"Beerse",16208,51.316667,4.866667 ],
    [ u"be",u"Beersel",23228,50.766667,4.3 ],
    [ u"be",u"Begijnendijk",9178,51.016667,4.766667 ],
    [ u"be",u"Bekkevoort",5714,50.95,4.966667 ],
    [ u"be",u"Beloeil",13405,50.55,3.716667 ],
    [ u"be",u"Beringen",40930,51.05,5.216667 ],
    [ u"be",u"Berlaar",10370,51.116667,4.65 ],
    [ u"be",u"Berlare",13853,51.033333,4 ],
    [ u"be",u"Berloz",2770,50.7,5.216667 ],
    [ u"be",u"Bernissart",11588,50.466667,3.633333 ],
    [ u"be",u"Bertem",9215,50.866667,4.633333 ],
    [ u"be",u"Bertogne",2852,50.083333,5.666667 ],
    [ u"be",u"Bertrix",8063,49.85,5.25 ],
    [ u"be",u"Bever",1932,50.916667,4.316667 ],
    [ u"be",u"Beveren",45179,51.216667,4.25 ],
    [ u"be",u"Beyne-Heusay",11608,50.616667,5.65 ],
    [ u"be",u"Bierbeek",8994,50.833333,4.766667 ],
    [ u"be",u"Bièvre",3207,49.933333,5.016667 ],
    [ u"be",u"Bilzen",29622,50.866667,5.516667 ],
    [ u"be",u"Binche",32030,50.4,4.166667 ],
    [ u"be",u"Blankenberge",18230,51.316667,3.133333 ],
    [ u"be",u"Blegny",12745,50.666667,5.733333 ],
    [ u"be",u"Bocholt",12346,51.166667,5.583333 ],
    [ u"be",u"Boechout",12145,51.166667,4.5 ],
    [ u"be",u"Bonheiden",14260,51.033333,4.533333 ],
    [ u"be",u"Boom",15810,51.083333,4.366667 ],
    [ u"be",u"Boortmeerbeek",11570,50.983333,4.566667 ],
    [ u"be",u"Borgloon",9955,50.8,5.333333 ],
    [ u"be",u"Bornem",19997,51.1,4.233333 ],
    [ u"be",u"Borsbeek",10334,51.2,4.483333 ],
    [ u"be",u"Bouillon",5347,49.8,5.066667 ],
    [ u"be",u"Boussu",20058,50.433333,3.8 ],
    [ u"be",u"Boutersem",7702,50.85,4.833333 ],
    [ u"be",u"Braine-le-Château",9627,50.683333,4.266667 ],
    [ u"be",u"Braine-le-Comte",20133,50.6,4.133333 ],
    [ u"be",u"Braives",5672,50.633333,5.15 ],
    [ u"be",u"Brasschaat",37040,51.283333,4.45 ],
    [ u"be",u"Brecht",25908,51.35,4.633333 ],
    [ u"be",u"Bredene",14862,51.233333,2.966667 ],
    [ u"be",u"Bree",14363,51.133333,5.6 ],
    [ u"be",u"Brugelette",3358,50.6,3.85 ],
    [ u"be",u"Brugge",116709,51.216667,3.233333 ],
    [ u"be",u"Brunehaut",7592,50.5,4.416667 ],
    [ u"be",u"Brussels",1019022,50.833333,4.333333 ],
    [ u"be",u"Buggenhout",13510,51.016667,4.2 ],
    [ u"be",u"Bullingen",5340,50.416667,6.266667 ],
    [ u"be",u"Burdinne",2799,50.583333,5.066667 ],
    [ u"be",u"Butgenbach",5516,50.433333,6.2 ],
    [ u"be",u"Celles",5471,50.716667,3.45 ],
    [ u"be",u"Cerfontaine",4500,50.166667,4.416667 ],
    [ u"be",u"Chapelle-lez-Herlaimont",14353,50.466667,4.283333 ],
    [ u"be",u"Charleroi",200132,50.416667,4.433333 ],
    [ u"be",u"Chastre",6243,50.6,4.633333 ],
    [ u"be",u"Châtelet",35238,50.4,4.516667 ],
    [ u"be",u"Chaudfontaine",20960,50.583333,5.633333 ],
    [ u"be",u"Chaumont-Gistoux",10943,50.683333,4.733333 ],
    [ u"be",u"Chièvres",6045,50.583333,3.8 ],
    [ u"be",u"Chimay",9720,50.05,4.316667 ],
    [ u"be",u"Chiny",4897,49.733333,5.333333 ],
    [ u"be",u"Ciney",14830,50.3,5.1 ],
    [ u"be",u"Clavier",4092,50.416667,5.366667 ],
    [ u"be",u"Colfontaine",19964,50.383333,3.866667 ],
    [ u"be",u"Comblain-au-Pont",5308,50.466667,5.583333 ],
    [ u"be",u"Courcelles",29473,50.466667,4.366667 ],
    [ u"be",u"Court-Saint-Étienne",9353,50.65,4.566667 ],
    [ u"be",u"Couvin",13518,50.05,4.483333 ],
    [ u"be",u"Crisnée",2587,50.716667,5.4 ],
    [ u"be",u"Dalhem",6391,50.716667,5.716667 ],
    [ u"be",u"Damme",10924,51.25,3.283333 ],
    [ u"be",u"Daverdisse",1299,50.016667,5.116667 ],
    [ u"be",u"Deerlijk",11292,50.85,3.35 ],
    [ u"be",u"De Haan",11766,51.266667,3.033333 ],
    [ u"be",u"Deinze",27777,50.983333,3.533333 ],
    [ u"be",u"Denderleeuw",16969,50.883333,4.066667 ],
    [ u"be",u"Dendermonde",43055,51.033333,4.116667 ],
    [ u"be",u"Dentergem",8038,50.966667,3.416667 ],
    [ u"be",u"De Panne",9799,51.1,2.583333 ],
    [ u"be",u"De Pinte",10020,51,3.65 ],
    [ u"be",u"Dessel",8707,51.233333,5.116667 ],
    [ u"be",u"Destelbergen",16853,51.05,3.8 ],
    [ u"be",u"Diepenbeek",17699,50.9,5.4 ],
    [ u"be",u"Diest",22516,50.983333,5.05 ],
    [ u"be",u"Diksmuide",15515,51.033333,2.866667 ],
    [ u"be",u"Dilbeek",39482,50.85,4.266667 ],
    [ u"be",u"Dinant",12875,50.266667,4.916667 ],
    [ u"be",u"Dison",13642,50.616667,5.85 ],
    [ u"be",u"Doische",2739,50.133333,4.75 ],
    [ u"be",u"Donceel",2712,50.65,5.316667 ],
    [ u"be",u"Dour",16861,50.4,3.783333 ],
    [ u"be",u"Drogenbos",4843,50.783333,4.316667 ],
    [ u"be",u"Duffel",16011,51.1,4.516667 ],
    [ u"be",u"Durbuy",10251,50.35,5.466667 ],
    [ u"be",u"Edegem",21839,51.15,4.45 ],
    [ u"be",u"Eeklo",19116,51.183333,3.566667 ],
    [ u"be",u"Éghezée",14352,50.6,4.9 ],
    [ u"be",u"Ellezelles",5566,50.733333,3.683333 ],
    [ u"be",u"Enghien",11367,50.7,4.033333 ],
    [ u"be",u"Engis",5737,50.583333,5.416667 ],
    [ u"be",u"Érezée",2930,50.3,5.55 ],
    [ u"be",u"Erquelinnes",9396,50.3,4.116667 ],
    [ u"be",u"Esneux",13497,50.533333,5.566667 ],
    [ u"be",u"Essen",16754,51.466667,4.466667 ],
    [ u"be",u"Estaimpuis",9340,50.7,3.25 ],
    [ u"be",u"Étalle",5228,49.683333,5.6 ],
    [ u"be",u"Eupen",18029,50.633333,6.033333 ],
    [ u"be",u"Evergem",31615,51.116667,3.7 ],
    [ u"be",u"Faimes",3349,50.666667,5.266667 ],
    [ u"be",u"Farciennes",11488,50.433333,4.55 ],
    [ u"be",u"Fauvillers",1952,49.85,5.666667 ],
    [ u"be",u"Ferrières",4434,50.4,5.6 ],
    [ u"be",u"Fexhe-le-Haut-Clocher",3082,50.666667,5.4 ],
    [ u"be",u"Fléron",15994,50.616667,5.683333 ],
    [ u"be",u"Fleurus",22080,50.483333,4.533333 ],
    [ u"be",u"Flobecq",3142,50.733333,3.733333 ],
    [ u"be",u"Floreffe",7480,50.433333,4.783333 ],
    [ u"be",u"Florennes",10723,50.25,4.616667 ],
    [ u"be",u"Florenville",5464,49.7,5.3 ],
    [ u"be",u"Frameries",20598,50.4,3.9 ],
    [ u"be",u"Galmaarden",7939,50.75,3.966667 ],
    [ u"be",u"Gavere",11888,50.933333,3.666667 ],
    [ u"be",u"Gedinne",4416,49.983333,4.933333 ],
    [ u"be",u"Geel",34697,51.166667,5 ],
    [ u"be",u"Geer",2682,50.666667,5.166667 ],
    [ u"be",u"Geetbets",5813,50.883333,5.116667 ],
    [ u"be",u"Gembloux",21676,50.566667,4.683333 ],
    [ u"be",u"Genappe",14266,50.6,4.45 ],
    [ u"be",u"Genk",63666,50.966667,5.5 ],
    [ u"be",u"Gent",231493,51.05,3.716667 ],
    [ u"be",u"Geraardsbergen",30807,50.766667,3.866667 ],
    [ u"be",u"Gerpinnes",11977,50.333333,4.516667 ],
    [ u"be",u"Gesves",6150,50.4,5.066667 ],
    [ u"be",u"Gingelom",7930,50.75,5.116667 ],
    [ u"be",u"Gistel",11084,51.166667,2.95 ],
    [ u"be",u"Glabbeek",5070,50.866667,4.95 ],
    [ u"be",u"Gooik",8957,50.8,4.116667 ],
    [ u"be",u"Gouvy",4706,50.185,5.941111 ],
    [ u"be",u"Grez-Doiceau",12367,50.733333,4.7 ],
    [ u"be",u"Grimbergen",33561,50.933333,4.383333 ],
    [ u"be",u"Grobbendonk",10724,51.2,4.716667 ],
    [ u"be",u"Haacht",13541,50.983333,4.633333 ],
    [ u"be",u"Haaltert",17129,50.9,4 ],
    [ u"be",u"Habay",7704,49.733333,5.616667 ],
    [ u"be",u"Halen",8548,50.95,5.1 ],
    [ u"be",u"Halle",34479,50.733333,4.233333 ],
    [ u"be",u"Hamme",22891,51.1,4.133333 ],
    [ u"be",u"Hamoir",3500,50.433333,5.533333 ],
    [ u"be",u"Hamois",6662,50.333333,5.133333 ],
    [ u"be",u"Hannut",14129,50.666667,5.083333 ],
    [ u"be",u"Harelbeke",25978,50.85,3.3 ],
    [ u"be",u"Hasselt",69222,50.933333,5.333333 ],
    [ u"be",u"Hastière",5147,50.216667,4.833333 ],
    [ u"be",u"Havelange",4790,50.383333,5.233333 ],
    [ u"be",u"Heers",6689,50.75,5.283333 ],
    [ u"be",u"Heist-op-den-Berg",37873,51.083333,4.716667 ],
    [ u"be",u"Hemiksem",9504,51.15,4.35 ],
    [ u"be",u"Hensies",6390,50.433333,3.666667 ],
    [ u"be",u"Herbeumont",1612,49.783333,5.233333 ],
    [ u"be",u"Herentals",25912,51.183333,4.833333 ],
    [ u"be",u"Herent",19218,50.9,4.666667 ],
    [ u"be",u"Herenthout",8379,51.15,4.766667 ],
    [ u"be",u"Herk-de-Stad",11566,50.933333,5.166667 ],
    [ u"be",u"Herne",6459,50.716667,4.033333 ],
    [ u"be",u"Héron",4305,50.55,5.083333 ],
    [ u"be",u"Herselt",13493,51.05,4.883333 ],
    [ u"be",u"Herstal",36503,50.666667,5.633333 ],
    [ u"be",u"Herstappe",93,50.733333,5.416667 ],
    [ u"be",u"Herve",16544,50.633333,5.8 ],
    [ u"be",u"Herzele",16523,50.883333,3.883333 ],
    [ u"be",u"Hoegaarden",6110,50.783333,4.9 ],
    [ u"be",u"Hoeilaart",10272,50.766667,4.466667 ],
    [ u"be",u"Hoeselt",9265,50.85,5.483333 ],
    [ u"be",u"Holsbeek",9094,50.916667,4.75 ],
    [ u"be",u"Hooglede",9900,50.983333,3.083333 ],
    [ u"be",u"Hoogstraten",18524,51.4,4.766667 ],
    [ u"be",u"Hotton",4969,50.266667,5.45 ],
    [ u"be",u"Houffalize",4614,50.133333,5.783333 ],
    [ u"be",u"Houthulst",8951,50.983333,2.95 ],
    [ u"be",u"Houyet",4505,50.183333,5.016667 ],
    [ u"be",u"Hove",7968,51.15,4.466667 ],
    [ u"be",u"Huldenberg",9137,50.783333,4.583333 ],
    [ u"be",u"Hulshout",9198,51.083333,4.783333 ],
    [ u"be",u"Huy",19973,50.516667,5.233333 ],
    [ u"be",u"Ichtegem",13582,51.1,3 ],
    [ u"be",u"Ieper",35089,50.85,2.883333 ],
    [ u"be",u"Incourt",4395,50.7,4.783333 ],
    [ u"be",u"Ingelmunster",10603,50.916667,3.25 ],
    [ u"be",u"Ittre",6014,50.65,4.266667 ],
    [ u"be",u"Izegem",26382,50.916667,3.2 ],
    [ u"be",u"Jabbeke",13488,51.183333,3.083333 ],
    [ u"be",u"Jalhay",7688,50.566667,5.966667 ],
    [ u"be",u"Jodoigne",11930,50.716667,4.866667 ],
    [ u"be",u"Juprelle",8354,50.716667,5.533333 ],
    [ u"be",u"Jurbise",9483,50.533333,3.933333 ],
    [ u"be",u"Kalmthout",17485,51.383333,4.466667 ],
    [ u"be",u"Kampenhout",10784,50.95,4.55 ],
    [ u"be",u"Kapellen",26410,51.316667,4.433333 ],
    [ u"be",u"Kapelle-op-den-Bos",8859,51.016667,4.366667 ],
    [ u"be",u"Kaprijke",6114,51.216667,3.6 ],
    [ u"be",u"Kasterlee",17765,51.25,4.95 ],
    [ u"be",u"Keerbergen",12363,51,4.616667 ],
    [ u"be",u"Kinrooi",11946,51.15,5.75 ],
    [ u"be",u"Knesselare",7889,51.133333,3.416667 ],
    [ u"be",u"Knokke-Heist",33781,51.35,3.266667 ],
    [ u"be",u"Koekelare",8317,51.083333,2.966667 ],
    [ u"be",u"Koksijde",21027,51.1,2.65 ],
    [ u"be",u"Kontich",20290,51.133333,4.45 ],
    [ u"be",u"Kortemark",11937,51.033333,3.033333 ],
    [ u"be",u"Kortenaken",7374,50.916667,5.066667 ],
    [ u"be",u"Kortenberg",17774,50.883333,4.533333 ],
    [ u"be",u"Kortessem",8042,50.866667,5.366667 ],
    [ u"be",u"Kortrijk",73879,50.833333,3.266667 ],
    [ u"be",u"Kraainem",12815,50.866667,4.466667 ],
    [ u"be",u"Kruibeke",14815,51.166667,4.316667 ],
    [ u"be",u"Kruishoutem",8179,50.9,3.516667 ],
    [ u"be",u"Kuurne",12638,50.85,3.283333 ],
    [ u"be",u"Laarne",11600,51.033333,3.85 ],
    [ u"be",u"La Bruyère",8194,50.283333,4.583333 ],
    [ u"be",u"La Hulpe",7415,50.733333,4.483333 ],
    [ u"be",u"La Louvière",76668,50.466667,4.183333 ],
    [ u"be",u"Lanaken",24771,50.883333,5.65 ],
    [ u"be",u"Landen",14458,50.75,5.083333 ],
    [ u"be",u"La Roche-en-Ardenne",4200,50.183333,5.583333 ],
    [ u"be",u"Lebbeke",17372,51,4.133333 ],
    [ u"be",u"Ledegem",9102,50.85,3.116667 ],
    [ u"be",u"Lede",16813,50.966667,3.983333 ],
    [ u"be",u"Léglise",3865,49.8,5.533333 ],
    [ u"be",u"Lendelede",5393,50.883333,3.233333 ],
    [ u"be",u"Lennik",8818,50.8,4.15 ],
    [ u"be",u"Lens",3902,50.55,3.9 ],
    [ u"be",u"Leopoldsburg",14149,51.116667,5.25 ],
    [ u"be",u"Lessines",17687,50.716667,3.833333 ],
    [ u"be",u"Leuven",92892,50.883333,4.7 ],
    [ u"be",u"Libin",4609,49.983333,5.25 ],
    [ u"be",u"Lichtervelde",8169,51.033333,3.15 ],
    [ u"be",u"Liedekerke",11980,50.866667,4.083333 ],
    [ u"be",u"Liège",182597,50.633333,5.566667 ],
    [ u"be",u"Lierneux",3332,50.283333,5.8 ],
    [ u"be",u"Lille",15466,51.233333,4.833333 ],
    [ u"be",u"Limbourg",5612,50.616667,5.933333 ],
    [ u"be",u"Lincent",2884,50.716667,5.033333 ],
    [ u"be",u"Linkebeek",4823,50.766667,4.333333 ],
    [ u"be",u"Lint",7982,51.133333,4.5 ],
    [ u"be",u"Lobbes",5467,50.35,4.25 ],
    [ u"be",u"Lochristi",19696,51.1,3.833333 ],
    [ u"be",u"Lokeren",37567,51.1,3.983333 ],
    [ u"be",u"Lommel",31993,51.233333,5.3 ],
    [ u"be",u"Londerzeel",17274,51,4.3 ],
    [ u"be",u"Lontzen",4862,50.683333,6 ],
    [ u"be",u"Lovendegem",9272,51.1,3.6 ],
    [ u"be",u"Lubbeek",13574,50.883333,4.833333 ],
    [ u"be",u"Lummen",13689,50.983333,5.2 ],
    [ u"be",u"Maaseik",23684,51.1,5.8 ],
    [ u"be",u"Maasmechelen",36251,50.816667,5.666667 ],
    [ u"be",u"Machelen",12252,50.916667,4.433333 ],
    [ u"be",u"Maldegem",22092,51.216667,3.45 ],
    [ u"be",u"Malmédy",11514,50.416667,6.033333 ],
    [ u"be",u"Manage",22196,50.5,4.216667 ],
    [ u"be",u"Manhay",3128,50.3,5.666667 ],
    [ u"be",u"Marche-en-Famenne",16856,50.2,5.333333 ],
    [ u"be",u"Marchin",5063,50.466667,5.233333 ],
    [ u"be",u"Martelange",1440,49.833333,5.733333 ],
    [ u"be",u"Mechelen",77531,51.033333,4.466667 ],
    [ u"be",u"Meerhout",9346,51.133333,5.083333 ],
    [ u"be",u"Meise",18497,50.933333,4.333333 ],
    [ u"be",u"Meix-devant-Virton",2637,49.6,5.483333 ],
    [ u"be",u"Melle",10687,51,3.8 ],
    [ u"be",u"Menen",31916,50.8,3.116667 ],
    [ u"be",u"Merbes-le-Château",3999,50.316667,4.15 ],
    [ u"be",u"Merchtem",14660,50.966667,4.233333 ],
    [ u"be",u"Merelbeke",22047,51,3.75 ],
    [ u"be",u"Merksplas",7963,51.366667,4.866667 ],
    [ u"be",u"Mesen",975,50.766667,2.9 ],
    [ u"be",u"Messancy",7144,49.6,5.816667 ],
    [ u"be",u"Mettet",12014,50.316667,4.666667 ],
    [ u"be",u"Meulebeke",10948,50.95,3.283333 ],
    [ u"be",u"Middelkerke",17789,51.183333,2.816667 ],
    [ u"be",u"Modave",3825,50.45,5.3 ],
    [ u"be",u"Moerbeke",5855,51.166667,3.933333 ],
    [ u"be",u"Mol",32659,51.183333,5.1 ],
    [ u"be",u"Momignies",5183,50.033333,4.166667 ],
    [ u"be",u"Mons",91277,50.45,3.933333 ],
    [ u"be",u"Mont-Saint-Guibert",6557,50.633333,4.616667 ],
    [ u"be",u"Moorslede",10720,50.883333,3.066667 ],
    [ u"be",u"Morlanwelz",18233,50.45,4.233333 ],
    [ u"be",u"Mortsel",24525,51.166667,4.466667 ],
    [ u"be",u"Mouscron",52069,50.733333,3.216667 ],
    [ u"be",u"Musson",4225,49.566667,5.7 ],
    [ u"be",u"Namur",106284,50.466667,4.866667 ],
    [ u"be",u"Nandrin",5480,50.5,5.416667 ],
    [ u"be",u"Nassogne",5081,50.133333,5.35 ],
    [ u"be",u"Nazareth",10890,50.966667,3.6 ],
    [ u"be",u"Neerpelt",16122,51.216667,5.416667 ],
    [ u"be",u"Neufchâteau",6416,49.833333,5.433333 ],
    [ u"be",u"Nevele",11153,51.033333,3.55 ],
    [ u"be",u"Niel",8656,51.116667,4.333333 ],
    [ u"be",u"Nieuwerkerken",6466,50.866667,5.183333 ],
    [ u"be",u"Nieuwpoort",10845,51.133333,2.75 ],
    [ u"be",u"Nijlen",20792,51.166667,4.65 ],
    [ u"be",u"Ninove",34795,50.833333,4.016667 ],
    [ u"be",u"Nivelles",24149,50.6,4.333333 ],
    [ u"be",u"Ohey",4324,50.433333,5.133333 ],
    [ u"be",u"Olen",11070,51.15,4.85 ],
    [ u"be",u"Olne",3836,50.583333,5.75 ],
    [ u"be",u"Onhaye",3014,50.25,4.833333 ],
    [ u"be",u"Oosterzele",13151,50.95,3.8 ],
    [ u"be",u"Oostkamp",21489,51.15,3.233333 ],
    [ u"be",u"Oostrozebeke",7489,50.916667,3.333333 ],
    [ u"be",u"Opglabbeek",9452,51.05,5.583333 ],
    [ u"be",u"Opwijk",12045,50.966667,4.183333 ],
    [ u"be",u"Oreye",3373,50.733333,5.366667 ],
    [ u"be",u"Ostend",69011,51.216667,2.916667 ],
    [ u"be",u"Oudenaarde",27935,50.85,3.6 ],
    [ u"be",u"Oudenburg",8752,51.183333,3 ],
    [ u"be",u"Oud-Heverlee",10533,50.833333,4.666667 ],
    [ u"be",u"Oud-Turnhout",12354,51.316667,4.983333 ],
    [ u"be",u"Ouffet",2477,50.433333,5.466667 ],
    [ u"be",u"Oupeye",23594,50.7,5.65 ],
    [ u"be",u"Overijse",23486,50.766667,4.533333 ],
    [ u"be",u"Overpelt",13344,51.216667,5.416667 ],
    [ u"be",u"Paliseul",5037,49.9,5.133333 ],
    [ u"be",u"Pecq",5302,50.683333,3.333333 ],
    [ u"be",u"Peer",15551,51.133333,5.466667 ],
    [ u"be",u"Pepingen",4261,50.75,4.15 ],
    [ u"be",u"Pepinster",9530,50.566667,5.816667 ],
    [ u"be",u"Péruwelz",16647,50.516667,3.583333 ],
    [ u"be",u"Perwez",7340,50.616667,4.816667 ],
    [ u"be",u"Philippeville",8051,50.2,4.533333 ],
    [ u"be",u"Pittem",6589,51,3.266667 ],
    [ u"be",u"Plombières",9596,50.733333,5.95 ],
    [ u"be",u"Pont-à-Celles",15909,50.5,4.35 ],
    [ u"be",u"Poperinge",19537,50.85,2.716667 ],
    [ u"be",u"Profondeville",11401,50.383333,4.866667 ],
    [ u"be",u"Putte",15276,51.066667,4.633333 ],
    [ u"be",u"Puurs",15944,51.083333,4.283333 ],
    [ u"be",u"Quaregnon",18491,50.433333,3.85 ],
    [ u"be",u"Quiévrain",6560,50.4,3.683333 ],
    [ u"be",u"Raeren",9925,50.683333,6.116667 ],
    [ u"be",u"Ranst",17405,51.2,4.55 ],
    [ u"be",u"Ravels",13560,51.366667,5 ],
    [ u"be",u"Remicourt",5050,50.683333,5.333333 ],
    [ u"be",u"Rendeux",2320,50.233333,5.5 ],
    [ u"be",u"Retie",10069,51.266667,5.066667 ],
    [ u"be",u"Riemst",15809,50.8,5.6 ],
    [ u"be",u"Rijkevorsel",10606,51.35,4.766667 ],
    [ u"be",u"Rixensart",21616,50.716667,4.533333 ],
    [ u"be",u"Rochefort",11978,50.166667,5.216667 ],
    [ u"be",u"Roeselare",56016,50.95,3.133333 ],
    [ u"be",u"Ronse",24204,50.75,3.6 ],
    [ u"be",u"Rotselaar",15007,50.95,4.716667 ],
    [ u"be",u"Rouvroy",1946,49.533333,5.5 ],
    [ u"be",u"Ruiselede",5129,51.05,3.4 ],
    [ u"be",u"Rumes",4918,50.55,3.3 ],
    [ u"be",u"Rumst",14521,51.083333,4.416667 ],
    [ u"be",u"Sainte-Ode",2310,50.083333,5.533333 ],
    [ u"be",u"Saint-Ghislain",22500,50.45,3.816667 ],
    [ u"be",u"Saint-Hubert",5538,50.016667,5.383333 ],
    [ u"be",u"Saint-Léger",3092,49.616667,5.65 ],
    [ u"be",u"Saint-Nicolas",22586,50.633333,5.533333 ],
    [ u"be",u"Schelle",7675,51.133333,4.333333 ],
    [ u"be",u"Schilde",20373,51.233333,4.566667 ],
    [ u"be",u"Schoten",33622,51.25,4.5 ],
    [ u"be",u"Seneffe",11025,50.516667,4.25 ],
    [ u"be",u"Seraing",60737,50.6,5.483333 ],
    [ u"be",u"Silly",7887,50.65,3.916667 ],
    [ u"be",u"Sint-Amands",7653,51.05,4.2 ],
    [ u"be",u"Sint-Genesius-Rode",17990,50.75,4.35 ],
    [ u"be",u"Sint-Gillis-Waas",17658,51.216667,4.133333 ],
    [ u"be",u"Sint-Katelijne-Waver",19487,51.066667,4.533333 ],
    [ u"be",u"Sint-Laureins",6657,51.25,3.516667 ],
    [ u"be",u"Sint-Lievens-Houtem",9146,50.916667,3.85 ],
    [ u"be",u"Sint-Martens-Latem",8303,51.016667,3.633333 ],
    [ u"be",u"Sint-Niklaas",69010,51.166667,4.133333 ],
    [ u"be",u"Sint-Pieters-Leeuw",30446,50.783333,4.233333 ],
    [ u"be",u"Sint-Truiden",37859,50.8,5.2 ],
    [ u"be",u"Soignies",24869,50.583333,4.066667 ],
    [ u"be",u"Sombreffe",7452,50.516667,4.6 ],
    [ u"be",u"Somme-Leuze",4532,50.333333,5.366667 ],
    [ u"be",u"Soumagne",15237,50.616667,5.75 ],
    [ u"be",u"Spa",10756,50.5,5.866667 ],
    [ u"be",u"Sprimont",12945,50.5,5.666667 ],
    [ u"be",u"Stabroek",17294,51.333333,4.366667 ],
    [ u"be",u"Staden",10786,50.983333,3.016667 ],
    [ u"be",u"Stavelot",6646,50.383333,5.933333 ],
    [ u"be",u"Steenokkerzeel",10566,50.916667,4.516667 ],
    [ u"be",u"Stekene",16989,51.2,4.033333 ],
    [ u"be",u"Stoumont",2970,50.416667,5.8 ],
    [ u"be",u"Tellin",2353,50.083333,5.216667 ],
    [ u"be",u"Temse",26054,51.133333,4.216667 ],
    [ u"be",u"Tenneville",2510,50.1,5.533333 ],
    [ u"be",u"Ternat",14569,50.866667,4.183333 ],
    [ u"be",u"Tervuren",20623,50.816667,4.516667 ],
    [ u"be",u"Tessenderlo",16574,51.066667,5.083333 ],
    [ u"be",u"Theux",11587,50.533333,5.816667 ],
    [ u"be",u"Thuin",14682,50.333333,4.283333 ],
    [ u"be",u"Tielt",19299,51,3.316667 ],
    [ u"be",u"Tienen",31743,50.8,4.95 ],
    [ u"be",u"Tinlot",2236,50.483333,5.366667 ],
    [ u"be",u"Tintigny",3538,49.683333,5.516667 ],
    [ u"be",u"Tongeren",29816,50.783333,5.466667 ],
    [ u"be",u"Torhout",18933,51.066667,3.1 ],
    [ u"be",u"Tournai",67720,50.6,3.383333 ],
    [ u"be",u"Tremelo",13721,50.983333,4.7 ],
    [ u"be",u"Trooz",7559,50.566667,5.683333 ],
    [ u"be",u"Tubize",21859,50.683333,4.2 ],
    [ u"be",u"Turnhout",39654,51.316667,4.95 ],
    [ u"be",u"Vaux-sur-Sûre",4581,49.916667,5.583333 ],
    [ u"be",u"Verlaine",3600,50.6,5.316667 ],
    [ u"be",u"Verviers",52824,50.583333,5.866667 ],
    [ u"be",u"Veurne",11983,51.066667,2.666667 ],
    [ u"be",u"Vielsalm",7291,50.284722,5.918611 ],
    [ u"be",u"Villers-la-Ville",9592,50.583333,4.533333 ],
    [ u"be",u"Villers-le-Bouillet",6059,50.583333,5.266667 ],
    [ u"be",u"Vilvoorde",36955,50.933333,4.433333 ],
    [ u"be",u"Virton",11259,49.566667,5.533333 ],
    [ u"be",u"Visé",17054,50.733333,5.7 ],
    [ u"be",u"Vorselaar",7238,51.2,4.766667 ],
    [ u"be",u"Vosselaar",10317,51.316667,4.883333 ],
    [ u"be",u"Waarschoot",7762,51.15,3.6 ],
    [ u"be",u"Waasmunster",10460,51.1,4.083333 ],
    [ u"be",u"Wachtebeke",6911,51.166667,3.866667 ],
    [ u"be",u"Waimes",6661,50.416667,6.116667 ],
    [ u"be",u"Walcourt",17501,50.25,4.416667 ],
    [ u"be",u"Walhain",5992,50.616667,4.7 ],
    [ u"be",u"Wanze",12918,50.533333,5.216667 ],
    [ u"be",u"Waregem",35896,50.883333,3.416667 ],
    [ u"be",u"Waremme",13737,50.683333,5.25 ],
    [ u"be",u"Wasseiges",2471,50.616667,5 ],
    [ u"be",u"Waterloo",28910,50.716667,4.383333 ],
    [ u"be",u"Wavre",32112,50.716667,4.616667 ],
    [ u"be",u"Welkenraedt",9006,50.65,5.966667 ],
    [ u"be",u"Wellen",6804,50.85,5.316667 ],
    [ u"be",u"Wellin",2937,50.083333,5.116667 ],
    [ u"be",u"Wemmel",14406,50.916667,4.3 ],
    [ u"be",u"Wervik",17340,50.783333,3.033333 ],
    [ u"be",u"Westerlo",22579,51.083333,4.916667 ],
    [ u"be",u"Wetteren",22930,51,3.883333 ],
    [ u"be",u"Wevelgem",30954,50.8,3.166667 ],
    [ u"be",u"Wezembeek-Oppem",13245,50.85,4.483333 ],
    [ u"be",u"Wichelen",11014,51,3.983333 ],
    [ u"be",u"Wielsbeke",8828,50.9,3.366667 ],
    [ u"be",u"Wijnegem",8932,51.233333,4.533333 ],
    [ u"be",u"Willebroek",22808,51.066667,4.366667 ],
    [ u"be",u"Wingene",12887,51.066667,3.266667 ],
    [ u"be",u"Wommelgem",11917,51.2,4.516667 ],
    [ u"be",u"Wuustwezel",18117,51.383333,4.6 ],
    [ u"be",u"Yvoir",8169,50.333333,4.883333 ],
    [ u"be",u"Zandhoven",12306,51.216667,4.65 ],
    [ u"be",u"Zaventem",28188,50.883333,4.466667 ],
    [ u"be",u"Zedelgem",21968,51.15,3.133333 ],
    [ u"be",u"Zele",20236,51.066667,4.033333 ],
    [ u"be",u"Zelzate",11901,51.2,3.816667 ],
    [ u"be",u"Zemst",21096,50.983333,4.466667 ],
    [ u"be",u"Zingem",6588,50.9,3.65 ],
    [ u"be",u"Zoersel",20642,51.266667,4.7 ],
    [ u"be",u"Zomergem",8158,51.116667,3.55 ],
    [ u"be",u"Zonhoven",19922,50.983333,5.35 ],
    [ u"be",u"Zonnebeke",11581,50.866667,2.983333 ],
    [ u"be",u"Zottegem",24434,50.866667,3.8 ],
    [ u"be",u"Zoutleeuw",7897,50.833333,5.1 ],
    [ u"be",u"Zuienkerke",2736,51.266667,3.166667 ],
    [ u"be",u"Zulte",14670,50.916667,3.433333 ],
    [ u"be",u"Zutendaal",6962,50.933333,5.566667 ],
    [ u"be",u"Zwevegem",23358,50.8,3.333333 ],
    [ u"be",u"Zwijndrecht",18249,51.216667,4.333333 ],
    [ u"bf",u"Banfora",63883,10.6333333,-4.7666667 ],
    [ u"bf",u"Batié",6525,9.8833333,-2.9166667 ],
    [ u"bf",u"Bobo Dioulasso",370809,11.2,-4.3 ],
    [ u"bf",u"Bogandé",9916,12.9713889,-0.1436111 ],
    [ u"bf",u"Boromo",13240,11.75,-2.9333333 ],
    [ u"bf",u"Boulsa",17623,12.6675,-0.5758333 ],
    [ u"bf",u"Boussé",11093,13.1,-3.3833333 ],
    [ u"bf",u"Dano",11224,11.15,-3.0666667 ],
    [ u"bf",u"Dédougou",47235,12.4666667,-3.4666667 ],
    [ u"bf",u"Diapaga",24302,12.0708333,1.7888889 ],
    [ u"bf",u"Diébougou",12814,10.9666667,-3.25 ],
    [ u"bf",u"Djibo",22821,14.1022222,-1.6305556 ],
    [ u"bf",u"Dori",27554,14.0333333,-0.0333333 ],
    [ u"bf",u"Gaoua",7300,10.2991667,-3.2508333 ],
    [ u"bf",u"Garango",29076,11.8,-0.5505556 ],
    [ u"bf",u"Gayéri",2004,12.6497222,0.4930556 ],
    [ u"bf",u"Gorom-Gorom",6743,14.4438889,-0.2361111 ],
    [ u"bf",u"Goulouré",6719,12.2305556,-1.9288889 ],
    [ u"bf",u"Gourcy",17982,13.2166667,-2.35 ],
    [ u"bf",u"Houndé",23617,11.5,-3.5166667 ],
    [ u"bf",u"Kaya",39130,13.0916667,-1.0844444 ],
    [ u"bf",u"Kokologo",25958,12.1897222,-1.8855556 ],
    [ u"bf",u"Kombissiri",19180,12.0655556,-1.3375 ],
    [ u"bf",u"Kongoussi",26338,13.3258333,-1.5347222 ],
    [ u"bf",u"Koudougou",86965,12.25,-2.3666667 ],
    [ u"bf",u"Koupéla",19850,12.1794444,-0.3516667 ],
    [ u"bf",u"Léo",21151,11.1,-2.1 ],
    [ u"bf",u"Manga",15269,11.6636111,-1.0730556 ],
    [ u"bf",u"Nouna",21144,12.7333333,-3.8666667 ],
    [ u"bf",u"Orodara",18635,10.9491667,-4.9341667 ],
    [ u"bf",u"Ouagadougou",1031330,12.3702778,-1.5247222 ],
    [ u"bf",u"Ouahigouya",61439,13.5833333,-2.4166667 ],
    [ u"bf",u"Ouargaye",30726,11.5033333,0.0572222 ],
    [ u"bf",u"Pitmoaga",8041,12.2397222,-1.8766667 ],
    [ u"bf",u"Pô",21003,11.1697222,-1.145 ],
    [ u"bf",u"Réo",24616,12.3166667,-2.4666667 ],
    [ u"bf",u"Sapouy",3862,11.5544444,-1.7736111 ],
    [ u"bf",u"Sindou",3942,10.6666667,-5.1666667 ],
    [ u"bf",u"Solenzo",10451,12.1833333,-4.0833333 ],
    [ u"bf",u"Tenkodogo",37123,11.78,-0.3697222 ],
    [ u"bf",u"Toma",9926,12.65,-4.4166667 ],
    [ u"bf",u"Tougan",17702,13.0666667,-3.0666667 ],
    [ u"bf",u"Yako",23080,12.9666667,-2.2666667 ],
    [ u"bf",u"Ziniaré",12783,12.5822222,-1.2983333 ],
    [ u"bf",u"Zorgo",19789,12.2488889,-0.6158333 ],
    [ u"bg",u"Ahtopol",857,42.1,27.95 ],
    [ u"bg",u"Ajtos",21177,42.7,27.25 ],
    [ u"bg",u"Alfatar",1941,43.95,27.2833333 ],
    [ u"bg",u"Antonovo",1950,43.15,26.1666667 ],
    [ u"bg",u"Ardino",3497,41.5833333,25.1333333 ],
    [ u"bg",u"Asenovgrad",50735,42.0166667,24.8666667 ],
    [ u"bg",u"Balgarovo",2344,42.6166667,27.3 ],
    [ u"bg",u"Bankja",8104,42.7,23.1333333 ],
    [ u"bg",u"Bansko",8412,41.8394444,23.5 ],
    [ u"bg",u"Batak",4103,41.95,24.2166667 ],
    [ u"bg",u"Batanovci",2532,42.5997222,22.9505556 ],
    [ u"bg",u"Belene",10401,43.65,25.1166667 ],
    [ u"bg",u"Belica",3334,41.9569444,23.5725 ],
    [ u"bg",u"Belogradcik",4865,43.6272222,22.6836111 ],
    [ u"bg",u"Beloslav",7817,43.1833333,27.7 ],
    [ u"bg",u"Belovo",4533,42.2166667,24.0166667 ],
    [ u"bg",u"Berkovica",13574,43.2361111,23.1258333 ],
    [ u"bg",u"Bjala",1753,43.45,25.7333333 ],
    [ u"bg",u"Bjala",10284,42.8833333,27.8833333 ],
    [ u"bg",u"Blagoevgrad",69547,42.0166667,23.1 ],
    [ u"bg",u"Bobosevo",1528,42.1597222,23.0163889 ],
    [ u"bg",u"Bobovdol",7222,42.3697222,23.0172222 ],
    [ u"bg",u"Boljarovo",1474,42.15,26.8166667 ],
    [ u"bg",u"Borovo",2520,43.5,25.8 ],
    [ u"bg",u"Botevgrad",20497,42.9,23.7833333 ],
    [ u"bg",u"Bracigovo",4600,42.0166667,24.3666667 ],
    [ u"bg",u"Bregovo",2629,44.1516667,22.6425 ],
    [ u"bg",u"Breznik",4150,42.7413889,22.8980556 ],
    [ u"bg",u"Brezovo",1920,42.35,25.0833333 ],
    [ u"bg",u"Buhovo",3069,42.7666667,23.5666667 ],
    [ u"bg",u"Burgas",188554,42.5,27.4666667 ],
    [ u"bg",u"Carevo",5023,42.1666667,27.85 ],
    [ u"bg",u"Cepelare",5342,41.7333333,24.6833333 ],
    [ u"bg",u"Cirpan",17622,42.2,25.3333333 ],
    [ u"bg",u"Dalgopol",4911,43.05,27.35 ],
    [ u"bg",u"Debelec",4396,43.0333333,25.6166667 ],
    [ u"bg",u"Devin",6766,41.7333333,24.4 ],
    [ u"bg",u"Dimitrovgrad",42827,42.05,25.6 ],
    [ u"bg",u"Dimovo",1145,43.7416667,22.7269444 ],
    [ u"bg",u"Dobric",92309,43.5666667,27.8333333 ],
    [ u"bg",u"Dolna Banja",4471,42.3,23.7666667 ],
    [ u"bg",u"Dolna Mitropolija",3746,43.4666667,24.5333333 ],
    [ u"bg",u"Dolni Dabnik",5561,43.4,24.4333333 ],
    [ u"bg",u"Dospat",2391,41.65,24.1666667 ],
    [ u"bg",u"Dragoman",3196,42.9188889,22.9316667 ],
    [ u"bg",u"Drjanovo",8017,42.9827778,25.4922222 ],
    [ u"bg",u"Dulovo",6463,43.8166667,27.15 ],
    [ u"bg",u"Dupnica",38656,42.2666667,23.1166667 ],
    [ u"bg",u"Dve Mogili",4561,43.6,25.8666667 ],
    [ u"bg",u"Elena",6171,42.9333333,25.8833333 ],
    [ u"bg",u"Elhovo",11723,42.1666667,26.5666667 ],
    [ u"bg",u"Elin Pelin",4699,42.6666667,23.6 ],
    [ u"bg",u"Etropole",11024,42.8333333,24.0 ],
    [ u"bg",u"Gabrovo",61109,42.8747222,25.3341667 ],
    [ u"bg",u"Galabovo",9080,42.1333333,25.85 ],
    [ u"bg",u"Godec",4551,43.015,23.0441667 ],
    [ u"bg",u"Gramada",1812,43.8344444,22.6586111 ],
    [ u"bg",u"Guljanci",4135,43.6333333,24.7 ],
    [ u"bg",u"Gurkovo",2933,42.6666667,25.7333333 ],
    [ u"bg",u"Gurkovo",2933,42.6666667,25.8 ],
    [ u"bg",u"Harmanli",20065,41.9333333,25.9 ],
    [ u"bg",u"Haskovo",78865,41.9402778,25.5694444 ],
    [ u"bg",u"Ihtiman",11554,42.4333333,23.8166667 ],
    [ u"bg",u"Iskar",4109,43.3833333,27.4833333 ],
    [ u"bg",u"Isperih",8276,43.7166667,26.8333333 ],
    [ u"bg",u"Ivajlovgrad",4451,41.5333333,26.1333333 ],
    [ u"bg",u"Jablanica",2662,43.0313889,24.1127778 ],
    [ u"bg",u"Jakoruda",5931,42.0252778,23.6841667 ],
    [ u"bg",u"Jambol",75290,42.4833333,26.5 ],
    [ u"bg",u"Kalofer",3736,42.6166667,24.9833333 ],
    [ u"bg",u"Kameno",5133,42.5666667,27.3 ],
    [ u"bg",u"Kaolinovo",1489,43.6166667,27.1166667 ],
    [ u"bg",u"Karlovo",24464,42.6333333,24.8 ],
    [ u"bg",u"Karnobat",19902,42.65,26.9833333 ],
    [ u"bg",u"Kaspican",3211,43.3,27.1833333 ],
    [ u"bg",u"Kavarna",10626,43.4333333,28.3333333 ],
    [ u"bg",u"Kazanlak",50336,42.6166667,25.4 ],
    [ u"bg",u"Kermen",2172,42.5,26.25 ],
    [ u"bg",u"Kilifarevo",2484,42.9833333,25.6333333 ],
    [ u"bg",u"Kjustendil",47315,42.2838889,22.6911111 ],
    [ u"bg",u"Klisura",1708,42.7,24.45 ],
    [ u"bg",u"Kneza",9201,43.5,24.0833333 ],
    [ u"bg",u"Kocerinovo",2431,42.0833333,23.0666667 ],
    [ u"bg",u"Kojnare",3678,43.35,24.1333333 ],
    [ u"bg",u"Koprivstica",2618,42.6333333,24.35 ],
    [ u"bg",u"Kostenec",9660,42.2666667,23.8166667 ],
    [ u"bg",u"Kostinbrod",11239,42.8166667,23.2166667 ],
    [ u"bg",u"Kotel",7117,42.8833333,26.45 ],
    [ u"bg",u"Kozloduj",10602,43.7833333,23.7333333 ],
    [ u"bg",u"Kresna",3756,41.7333333,23.15 ],
    [ u"bg",u"Kresna",3756,41.8,23.1833333 ],
    [ u"bg",u"Kricim",8478,42.05,24.4666667 ],
    [ u"bg",u"Krivodol",2646,43.3744444,23.4844444 ],
    [ u"bg",u"Krumovgrad",4478,41.4666667,25.65 ],
    [ u"bg",u"Kubrat",7327,43.8,26.5 ],
    [ u"bg",u"Kula",3393,43.8877778,22.5213889 ],
    [ u"bg",u"Laki",2720,41.85,24.8166667 ],
    [ u"bg",u"Letnica",3980,43.3116667,25.0733333 ],
    [ u"bg",u"Levski",13203,43.3666667,25.1333333 ],
    [ u"bg",u"Ljaskovec",9000,43.1111111,25.7283333 ],
    [ u"bg",u"Ljubimec",7623,41.8333333,26.0833333 ],
    [ u"bg",u"Lom",24906,43.8138889,23.2361111 ],
    [ u"bg",u"Lovec",39788,43.1333333,24.7166667 ],
    [ u"bg",u"Loznica",2512,43.9666667,27.9166667 ],
    [ u"bg",u"Lukovit",9020,43.2,24.1666667 ],
    [ u"bg",u"Madan",7179,41.5,24.95 ],
    [ u"bg",u"Magliz",3465,42.6,25.55 ],
    [ u"bg",u"Malko Tarnovo",2920,41.9833333,27.5333333 ],
    [ u"bg",u"Melnik",251,41.5166667,23.4 ],
    [ u"bg",u"Mericleri",2233,42.1333333,25.5 ],
    [ u"bg",u"Mezdra",8667,43.15,23.7 ],
    [ u"bg",u"Momcilgrad",6974,41.5333333,25.4166667 ],
    [ u"bg",u"Montana",44982,43.4125,23.225 ],
    [ u"bg",u"Nedelino",4676,41.45,25.0833333 ],
    [ u"bg",u"Nesebar",5864,42.65,27.7333333 ],
    [ u"bg",u"Nikolaevo",2834,43.3166667,25.9833333 ],
    [ u"bg",u"Nikopol",4884,43.7,24.9 ],
    [ u"bg",u"Nova Zagora",24034,42.4833333,26.0166667 ],
    [ u"bg",u"Novi Iskar",13194,42.8,23.35 ],
    [ u"bg",u"Novi Pazar",13017,43.35,27.2 ],
    [ u"bg",u"Obzor",1864,42.8166667,27.8833333 ],
    [ u"bg",u"Omurtag",8858,43.1,26.4166667 ],
    [ u"bg",u"Opaka",3353,43.45,26.1666667 ],
    [ u"bg",u"Orjahovo",4464,43.7333333,23.9666667 ],
    [ u"bg",u"Panagjuriste",18755,42.5,24.1833333 ],
    [ u"bg",u"Pavlikeni",12129,43.2427778,25.3219444 ],
    [ u"bg",u"Pazardzik",76254,42.2,24.3333333 ],
    [ u"bg",u"Pernik",82185,42.6,23.0333333 ],
    [ u"bg",u"Perustica",5248,42.05,24.55 ],
    [ u"bg",u"Pestera",19161,42.0333333,24.3 ],
    [ u"bg",u"Petric",29956,41.4,23.2166667 ],
    [ u"bg",u"Pirdop",7923,42.7,24.1833333 ],
    [ u"bg",u"Plackovci",2098,42.8166667,25.4666667 ],
    [ u"bg",u"Pleven",132542,43.4166667,24.6166667 ],
    [ u"bg",u"Pliska",1115,43.3666667,27.1166667 ],
    [ u"bg",u"Plovdiv",332088,42.15,24.75 ],
    [ u"bg",u"Pomorie",12941,42.55,27.65 ],
    [ u"bg",u"Popovo",18836,43.35,26.2333333 ],
    [ u"bg",u"Pordim",2711,43.3833333,24.85 ],
    [ u"bg",u"Pravec",5071,42.8833333,23.9166667 ],
    [ u"bg",u"Primorsko",1807,42.2666667,27.7666667 ],
    [ u"bg",u"Provadija",14253,43.1833333,27.4333333 ],
    [ u"bg",u"Radnevo",13157,42.3,25.9333333 ],
    [ u"bg",u"Radomir",14971,42.5444444,22.9577778 ],
    [ u"bg",u"Rakitovo",8029,41.9833333,24.0833333 ],
    [ u"bg",u"Rakovski",16009,42.3,24.9666667 ],
    [ u"bg",u"Razgrad",31791,43.5333333,26.5166667 ],
    [ u"bg",u"Razlog",12347,41.8902778,23.4791667 ],
    [ u"bg",u"Rila",2936,42.1333333,23.1333333 ],
    [ u"bg",u"Roman",2329,43.15,23.9166667 ],
    [ u"bg",u"Rudozem",4041,41.4833333,24.85 ],
    [ u"bg",u"Ruse",157519,43.8563889,25.9708333 ],
    [ u"bg",u"Sabla",3603,43.5333333,28.5333333 ],
    [ u"bg",u"Sadovo",2461,42.1333333,24.9333333 ],
    [ u"bg",u"Saedinenie",6363,42.2666667,24.55 ],
    [ u"bg",u"Samokov",26582,42.3333333,23.55 ],
    [ u"bg",u"Sandanski",26282,41.5666667,23.2833333 ],
    [ u"bg",u"Senovo",1481,43.65,26.3666667 ],
    [ u"bg",u"Septemvri",8741,42.2166667,24.1 ],
    [ u"bg",u"Sevlievo",23574,43.0258333,25.1136111 ],
    [ u"bg",u"Silistra",38166,44.1166667,27.2666667 ],
    [ u"bg",u"Simeonovgrad",7509,42.0333333,25.8333333 ],
    [ u"bg",u"Simitli",7275,41.8833333,23.1166667 ],
    [ u"bg",u"Sipka",1520,42.7166667,25.3333333 ],
    [ u"bg",u"Slavjanovo",5160,43.4666667,24.8666667 ],
    [ u"bg",u"Sliven",94252,42.6858333,26.3291667 ],
    [ u"bg",u"Smoljan",31870,41.5852778,24.6919444 ],
    [ u"bg",u"Sofia",1062065,42.6833333,23.3166667 ],
    [ u"bg",u"Sopot",10141,43.0166667,24.4166667 ],
    [ u"bg",u"Sozopol",3548,42.4166667,27.7 ],
    [ u"bg",u"Sredec",9362,42.3488889,27.1941667 ],
    [ u"bg",u"Stara Zagora",137760,42.4327778,25.6419444 ],
    [ u"bg",u"Straldza",5865,42.6,26.6833333 ],
    [ u"bg",u"Strazica",5006,43.2333333,25.9666667 ],
    [ u"bg",u"Strelca",4699,42.5,24.3166667 ],
    [ u"bg",u"Suhindol",2407,43.1916667,25.1811111 ],
    [ u"bg",u"Sumen",85394,43.2766667,26.9291667 ],
    [ u"bg",u"Sungurlare",3441,42.7666667,26.7833333 ],
    [ u"bg",u"Suvorovo",4514,43.3333333,27.6 ],
    [ u"bg",u"Svilengrad",17378,41.7666667,26.2 ],
    [ u"bg",u"Svistov",29762,43.6230556,25.3538889 ],
    [ u"bg",u"Svoge",7093,42.9666667,23.35 ],
    [ u"bg",u"Tervel",7019,43.75,27.4 ],
    [ u"bg",u"Teteven",10697,42.9166667,24.2666667 ],
    [ u"bg",u"Topolovgrad",5824,42.0833333,26.3333333 ],
    [ u"bg",u"Tran",2608,42.8352778,22.6516667 ],
    [ u"bg",u"Trastenik",5627,43.5166667,24.4666667 ],
    [ u"bg",u"Trjavna",10180,42.8666667,25.5 ],
    [ u"bg",u"Trojan",22431,42.8833333,24.7166667 ],
    [ u"bg",u"Tutrakan",9472,44.05,26.6166667 ],
    [ u"bg",u"Tvardica",6434,42.7,25.9 ],
    [ u"bg",u"Ugarcin",2896,43.1,24.4166667 ],
    [ u"bg",u"Varna",307952,43.2166667,27.9166667 ],
    [ u"bg",u"Veliki Preslav",8669,43.1666667,26.8166667 ],
    [ u"bg",u"Velingrad",24129,42.0166667,24.0 ],
    [ u"bg",u"Vetovo",4835,43.7,26.2666667 ],
    [ u"bg",u"Vidin",50315,43.99,22.8725 ],
    [ u"bg",u"Vraca",48995,43.21,23.5625 ],
    [ u"bg",u"Zavet",2979,43.7666667,26.6666667 ],
    [ u"bg",u"Zemen",2145,42.4788889,22.7491667 ],
    [ u"bg",u"Zlatarica",2847,43.05,25.9 ],
    [ u"bg",u"Zlatica",4881,42.7166667,24.1333333 ],
    [ u"bg",u"Zlatograd",7673,41.3833333,25.1 ],
    [ u"bh",u"Manama",147097,26.2361111,50.5830556 ],
    [ u"bh",u"Sitrah",37690,26.1547222,50.6205556 ],
    [ u"bi",u"Bubanza",12728,-3.0833333,29.3944444 ],
    [ u"bi",u"Bujumbura",330539,-3.3761111,29.36 ],
    [ u"bi",u"Bururi",19740,-3.9511111,29.6166667 ],
    [ u"bi",u"Cankuzo",6585,-3.2194444,30.5527778 ],
    [ u"bi",u"Cibitoke",14220,-2.8861111,29.1236111 ],
    [ u"bi",u"Gitega",23168,-3.425,29.9333333 ],
    [ u"bi",u"Karuzi",10705,-3.1013889,30.1647222 ],
    [ u"bi",u"Kayanza",19443,-2.9222222,29.6222222 ],
    [ u"bi",u"Kirundo",6084,-2.5847222,30.0972222 ],
    [ u"bi",u"Makamba",19642,-4.1347222,29.805 ],
    [ u"bi",u"Muramvya",18039,-3.2680556,29.6166667 ],
    [ u"bi",u"Muyinga",71095,-2.8494444,30.3361111 ],
    [ u"bi",u"Mwaro",4924,-3.5263889,29.7027778 ],
    [ u"bi",u"Ngozi",21506,-2.9083333,29.8277778 ],
    [ u"bi",u"Rumonge",6074,-3.9722222,29.4388889 ],
    [ u"bi",u"Rutana",20894,-3.9191667,29.9936111 ],
    [ u"bi",u"Ruyigi",38459,-3.4763889,30.2486111 ],
    [ u"bj",u"Abomey",82158,7.1833333,1.9833333 ],
    [ u"bj",u"Abomey-Calavi",385823,6.45,2.35 ],
    [ u"bj",u"Allada",20094,6.65,2.15 ],
    [ u"bj",u"Aplahoué",19862,6.9333333,1.6833333 ],
    [ u"bj",u"Athiémé",13585,6.5833333,1.6666667 ],
    [ u"bj",u"Banikoara",22487,11.3,2.4333333 ],
    [ u"bj",u"Bassila",23616,9.0166667,1.6666667 ],
    [ u"bj",u"Bembèrèkè",24006,10.2288889,2.6652778 ],
    [ u"bj",u"Bétérou",13108,9.2,2.2666667 ],
    [ u"bj",u"Bohicon",125116,7.2,2.0666667 ],
    [ u"bj",u"Comé",29208,6.4,1.8833333 ],
    [ u"bj",u"Cotonou",690584,6.35,2.4333333 ],
    [ u"bj",u"Cové",38566,7.2333333,2.3 ],
    [ u"bj",u"Djougou",202834,9.705,1.6669444 ],
    [ u"bj",u"Dogbo",41312,6.8166667,1.7833333 ],
    [ u"bj",u"Kandi",109705,11.1341667,2.9386111 ],
    [ u"bj",u"Kétou",22341,7.3666667,2.6 ],
    [ u"bj",u"Lokossa",86987,6.6333333,1.7166667 ],
    [ u"bj",u"Malanville",37117,11.8613889,3.3858333 ],
    [ u"bj",u"Natitingou",80896,10.3066667,1.375 ],
    [ u"bj",u"Nikki",54009,9.9338889,3.2044444 ],
    [ u"bj",u"Ouidah",83506,6.3666667,2.0833333 ],
    [ u"bj",u"Parakou",163759,9.35,2.6166667 ],
    [ u"bj",u"Pobé",32983,6.9666667,2.6833333 ],
    [ u"bj",u"Sakété",30111,6.7166667,2.6666667 ],
    [ u"bj",u"Savalou",30187,7.9333333,1.9666667 ],
    [ u"bj",u"Savé",75973,8.0333333,2.4833333 ],
    [ u"bj",u"Tchaourou",20971,8.8833333,2.6 ],
    [ u"bm",u"Hamilton",902,32.2941667,-64.7838889 ],
    [ u"bm",u"Saint George",1802,32.3816667,-64.6780556 ],
    [ u"bo",u"Abapó",2419,-18.8333333,-63.4666667 ],
    [ u"bo",u"Achacachi",8447,-16.05,-68.6833333 ],
    [ u"bo",u"Aiquile",8225,-18.1666667,-65.1666667 ],
    [ u"bo",u"Arani",3906,-17.5666667,-65.7666667 ],
    [ u"bo",u"Ascensión",14431,-15.7,-63.0833333 ],
    [ u"bo",u"Atocha",1833,-20.9333333,-66.2333333 ],
    [ u"bo",u"Bermejo",28287,-22.65,-64.3666667 ],
    [ u"bo",u"Betanzos",4847,-19.5505556,-65.4533333 ],
    [ u"bo",u"Boyuibe",3075,-20.4166667,-63.2833333 ],
    [ u"bo",u"Buena Vista",4283,-17.45,-63.6666667 ],
    [ u"bo",u"Camargo",4715,-20.65,-65.2166667 ],
    [ u"bo",u"Camiri",27971,-20.05,-63.5166667 ],
    [ u"bo",u"Capinota",5157,-17.7166667,-66.2333333 ],
    [ u"bo",u"Caracollo",4708,-17.65,-67.1666667 ],
    [ u"bo",u"Caranavi",14915,-15.8166667,-67.55 ],
    [ u"bo",u"Challapata",8016,-18.9,-66.7666667 ],
    [ u"bo",u"Charagua",3026,-19.8,-63.2166667 ],
    [ u"bo",u"Chimoré",5147,-16.9833333,-65.1333333 ],
    [ u"bo",u"Chulumani",2953,-16.4,-67.5166667 ],
    [ u"bo",u"Cliza",8655,-17.6,-65.9333333 ],
    [ u"bo",u"Cobija",26583,-11.0333333,-68.7333333 ],
    [ u"bo",u"Cochabamba",900440,-17.3833333,-66.15 ],
    [ u"bo",u"Colomi",3923,-17.35,-65.8666667 ],
    [ u"bo",u"Colquechaca",1706,-18.6666667,-66.0166667 ],
    [ u"bo",u"Colquiri",3934,-17.4166667,-67.1333333 ],
    [ u"bo",u"Comarapa",4446,-17.9,-64.4833333 ],
    [ u"bo",u"Concepción",6901,-16.4333333,-60.9 ],
    [ u"bo",u"Copacabana",4508,-16.15,-69.0833333 ],
    [ u"bo",u"Coripata",2107,-16.3,-67.6 ],
    [ u"bo",u"Coroico",2361,-16.1833333,-67.7333333 ],
    [ u"bo",u"Cotoca",18349,-17.75,-62.9833333 ],
    [ u"bo",u"El Carmen",14297,-17.85,-63.2166667 ],
    [ u"bo",u"El Torno",15544,-17.9833333,-63.3833333 ],
    [ u"bo",u"Entre Ríos",2685,-21.5333333,-64.2 ],
    [ u"bo",u"Eucaliptus",2373,-17.5833333,-67.5166667 ],
    [ u"bo",u"Guanay",3915,-15.4833333,-67.8833333 ],
    [ u"bo",u"Guayaramerín",36010,-10.8,-65.3833333 ],
    [ u"bo",u"Huanuni",15492,-18.2666667,-66.85 ],
    [ u"bo",u"Irpa Irpa",2968,-17.7166667,-66.2666667 ],
    [ u"bo",u"Jorochito",4013,-18.05,-63.4333333 ],
    [ u"bo",u"La Bélgica",5504,-17.55,-63.2166667 ],
    [ u"bo",u"La Guardia",10259,-17.9,-63.3333333 ],
    [ u"bo",u"Lahuachaca",3235,-17.3666667,-67.6666667 ],
    [ u"bo",u"La Paz",812819,-16.5,-68.15 ],
    [ u"bo",u"Limoncito",3622,-18.0166667,-63.4 ],
    [ u"bo",u"Llallagua",28070,-18.4166667,-66.6333333 ],
    [ u"bo",u"Los Negros",3046,-17.7333333,-63.4333333 ],
    [ u"bo",u"Machacamarca",2045,-18.1666667,-67.0333333 ],
    [ u"bo",u"Mairana",4298,-18.1166667,-63.9333333 ],
    [ u"bo",u"Mapiri",2598,-15.25,-68.1666667 ],
    [ u"bo",u"Mineros",14386,-17.1166667,-63.2333333 ],
    [ u"bo",u"Mizque",2911,-17.9333333,-65.3166667 ],
    [ u"bo",u"Monteagudo",8290,-19.8166667,-63.9833333 ],
    [ u"bo",u"Montero",88623,-17.3333333,-63.25 ],
    [ u"bo",u"Oruro",208687,-17.9833333,-67.15 ],
    [ u"bo",u"Padilla",2920,-19.3,-64.3 ],
    [ u"bo",u"Pailón",9304,-17.65,-62.75 ],
    [ u"bo",u"Patacamaya",12261,-17.2333333,-67.9166667 ],
    [ u"bo",u"Poopó",1720,-18.3666667,-66.9666667 ],
    [ u"bo",u"Portachuelo",11486,-17.35,-63.4 ],
    [ u"bo",u"Potosí",141254,-19.5836111,-65.7530556 ],
    [ u"bo",u"Puerto Pailas",2675,-17.65,-62.8 ],
    [ u"bo",u"Puerto Quijarro",10393,-17.7833333,-57.7666667 ],
    [ u"bo",u"Puerto Suárez",12254,-18.95,-57.8 ],
    [ u"bo",u"Punata",15195,-17.55,-65.8333333 ],
    [ u"bo",u"Quime",2405,-16.9833333,-67.2166667 ],
    [ u"bo",u"Reyes",7376,-14.3166667,-67.3833333 ],
    [ u"bo",u"Riberalta",74018,-10.9833333,-66.1 ],
    [ u"bo",u"Roboré",9883,-18.3333333,-59.75 ],
    [ u"bo",u"Rurrenabaque",11750,-14.4666667,-67.5666667 ],
    [ u"bo",u"Samaipata",3250,-18.15,-63.8666667 ],
    [ u"bo",u"San Borja",19641,-14.8166667,-66.85 ],
    [ u"bo",u"San Carlos",4180,-17.4,-63.75 ],
    [ u"bo",u"San Ignacio",23570,-16.3666667,-60.95 ],
    [ u"bo",u"San Javier",7025,-16.3333333,-62.6333333 ],
    [ u"bo",u"San Joaquín",3557,-18.45,-59.55 ],
    [ u"bo",u"San José",9749,-17.85,-60.75 ],
    [ u"bo",u"San Julian",7706,-17.7833333,-62.8666667 ],
    [ u"bo",u"San Lorenzo",2921,-21.4333333,-64.7833333 ],
    [ u"bo",u"San Matías",6352,-16.3666667,-58.4 ],
    [ u"bo",u"San Miguel",4906,-16.7,-61.0166667 ],
    [ u"bo",u"San Pedro",2990,-18.2833333,-59.8166667 ],
    [ u"bo",u"San Rafael",2384,-16.75,-60.5666667 ],
    [ u"bo",u"San Ramón",4390,-13.2833333,-64.7166667 ],
    [ u"bo",u"San Ramón",6422,-14.4833333,-63.15 ],
    [ u"bo",u"Santa Bárbara",2434,-20.9166667,-66.05 ],
    [ u"bo",u"Santa Rita",2444,-17.9666667,-63.35 ],
    [ u"bo",u"Santa Rosa",4459,-14.1666667,-66.8833333 ],
    [ u"bo",u"Santa Rosa",4575,-16.7833333,-61.8 ],
    [ u"bo",u"Sipe Sipe",3777,-17.45,-66.3833333 ],
    [ u"bo",u"Sorata",2190,-15.7666667,-68.6333333 ],
    [ u"bo",u"Sucre",224846,-19.0430556,-65.2591667 ],
    [ u"bo",u"Tarabuco",2428,-19.1666667,-64.9166667 ],
    [ u"bo",u"Tarata",8045,-17.6166667,-66.0166667 ],
    [ u"bo",u"Tarija",159275,-21.5166667,-64.75 ],
    [ u"bo",u"Tipuani",2585,-15.55,-68.0 ],
    [ u"bo",u"Totoral",1645,-18.5166667,-66.8666667 ],
    [ u"bo",u"Trinidad",84264,-14.8333333,-64.9 ],
    [ u"bo",u"Tupiza",22234,-21.45,-65.7166667 ],
    [ u"bo",u"Uncia",5142,-18.45,-66.6166667 ],
    [ u"bo",u"Urubichá",3269,-15.3833333,-62.95 ],
    [ u"bo",u"Uyuni",10294,-20.4666667,-66.8333333 ],
    [ u"bo",u"Villamontes",18762,-21.25,-63.5 ],
    [ u"bo",u"Villazón",30254,-22.1,-65.6 ],
    [ u"bo",u"Viloco",1900,-16.95,-67.55 ],
    [ u"bo",u"Warnes",22038,-17.5,-63.1666667 ],
    [ u"bo",u"Yacuiba",82808,-22.0333333,-63.6833333 ],
    [ u"br",u"Abadiânia",7062,-16.1,-48.8 ],
    [ u"br",u"Abaeté",20371,-19.15,-45.45 ],
    [ u"br",u"Abaetetuba",78052,-1.7,-48.9 ],
    [ u"br",u"Abreu e Lima",81960,-7.9,-34.883333 ],
    [ u"br",u"Acajutiba",14349,-11.666667,-38.016667 ],
    [ u"br",u"Acará",12803,-1.95,-48.183333 ],
    [ u"br",u"Acaraú",28389,-2.883333,-40.116667 ],
    [ u"br",u"Acari",9159,-6.516667,-36.633333 ],
    [ u"br",u"Acopiara",24562,-6.1,-39.45 ],
    [ u"br",u"Açu",36126,-5.577222,-36.9075 ],
    [ u"br",u"Açucena",14506,-19.066667,-42.533333 ],
    [ u"br",u"Adamantina",31079,-21.683333,-51.066667 ],
    [ u"br",u"Afogados da Ingàzeira",25060,-7.75,-37.65 ],
    [ u"br",u"Afonso Bezerra",6947,-5.498056,-36.509167 ],
    [ u"br",u"Afonso Cláudio",13543,-20.083333,-41.133333 ],
    [ u"br",u"Afuá",7031,-.166667,-50.383333 ],
    [ u"br",u"Agrestina",14453,-8.45,-35.95 ],
    [ u"br",u"Água Branca",5161,-9.283333,-37.916667 ],
    [ u"br",u"Água Branca",13912,-5.883333,-42.633333 ],
    [ u"br",u"Aguaí",27503,-22.066667,-46.966667 ],
    [ u"br",u"Água Preta",16444,-8.7,-35.516667 ],
    [ u"br",u"Águas Belas",22563,-9.116667,-37.116667 ],
    [ u"br",u"Águas de Lindóia",18806,-22.483333,-46.65 ],
    [ u"br",u"Águas Formosas",11512,-17.083333,-40.95 ],
    [ u"br",u"Águas Vermelhas",16410,-15.75,-41.466667 ],
    [ u"br",u"Agudos",30808,-22.466667,-49 ],
    [ u"br",u"Águia Branca",2554,-18.983333,-40.733333 ],
    [ u"br",u"Aimorés",19133,-19.5,-41.066667 ],
    [ u"br",u"Alagoa Grande",16406,-7.05,-35.633333 ],
    [ u"br",u"Alagoa Nova",9182,-7.066667,-35.766667 ],
    [ u"br",u"Alagoinha",7474,-6.933333,-35.55 ],
    [ u"br",u"Alagoinhas",122692,-12.116667,-38.433333 ],
    [ u"br",u"Alcântara",5655,-2.4,-44.4 ],
    [ u"br",u"Alegre",19758,-20.766667,-41.533333 ],
    [ u"br",u"Alegrete",77540,-29.766667,-55.766667 ],
    [ u"br",u"Além Paraíba",33907,-21.866667,-42.683333 ],
    [ u"br",u"Alenquer",26291,-1.933333,-54.766667 ],
    [ u"br",u"Alexandria",9769,-6.416667,-38.016667 ],
    [ u"br",u"Alfenas",71407,-21.433333,-45.95 ],
    [ u"br",u"Alfredo Chaves",6422,-20.633333,-40.75 ],
    [ u"br",u"Alhandra",10788,-7.433333,-34.9 ],
    [ u"br",u"Aliança",17329,-7.583333,-35.216667 ],
    [ u"br",u"Almeirim",20464,-1.533333,-52.566667 ],
    [ u"br",u"Almenara",29333,-16.183333,-40.7 ],
    [ u"br",u"Almirante Tamandaré",89500,-25.3,-49.316667 ],
    [ u"br",u"Alpinópolis",13286,-20.866667,-46.383333 ],
    [ u"br",u"Alta Floresta",40468,-9.9,-55.9 ],
    [ u"br",u"Altamira",70890,-3.2,-52.2 ],
    [ u"br",u"Alterosa",9277,-21.25,-46.133333 ],
    [ u"br",u"Altinho",11913,-8.483333,-36.066667 ],
    [ u"br",u"Altinópolis",14616,-21.025278,-47.374444 ],
    [ u"br",u"Alto Araguaia",8780,-17.316667,-53.2 ],
    [ u"br",u"Alto Longá",4435,-5.25,-42.2 ],
    [ u"br",u"Altônia",11242,-23.933333,-53.9 ],
    [ u"br",u"Alto Paraguai",6149,-14.5,-56.516667 ],
    [ u"br",u"Alto Paraná",10888,-23.083333,-52.366667 ],
    [ u"br",u"Alto Piquiri",10039,-24.016667,-53.466667 ],
    [ u"br",u"Altos",28769,-5.05,-42.466667 ],
    [ u"br",u"Alvarães",5527,-3.2,-64.833333 ],
    [ u"br",u"Álvares Machado",21642,-22.133333,-51.5 ],
    [ u"br",u"Alvinópolis",12068,-20.1,-43.05 ],
    [ u"br",u"Alvorada",10232,-12.47,-49.082222 ],
    [ u"br",u"Amambaí",20261,-23.083333,-55.216667 ],
    [ u"br",u"Amapá",6256,2.05,-50.8 ],
    [ u"br",u"Amaraji",16660,-8.4,-35.45 ],
    [ u"br",u"Amarante",8828,-6.233333,-42.833333 ],
    [ u"br",u"Amarante do Maranhão",11510,-5.6,-46.75 ],
    [ u"br",u"Amargosa",22531,-13.033333,-39.6 ],
    [ u"br",u"América Dourada",14018,-11.466667,-41.433333 ],
    [ u"br",u"Americana",196026,-22.740278,-47.334444 ],
    [ u"br",u"Américo Brasiliense",34332,-21.716667,-48.116667 ],
    [ u"br",u"Amontada",13520,-3.383333,-39.833333 ],
    [ u"br",u"Amparo",41498,-22.7,-46.783333 ],
    [ u"br",u"Ampère",14275,-25.916667,-53.466667 ],
    [ u"br",u"Anadia",9574,-9.7,-36.3 ],
    [ u"br",u"Anagé",3762,-14.6,-41.133333 ],
    [ u"br",u"Anajatuba",5627,-3.266667,-44.616667 ],
    [ u"br",u"Ananás",8874,-6.360278,-47.91 ],
    [ u"br",u"Ananindeua",433956,-1.366667,-48.383333 ],
    [ u"br",u"Anápolis",319592,-16.333333,-48.966667 ],
    [ u"br",u"Anastácio",18817,-20.516667,-55.8 ],
    [ u"br",u"Andirá",20758,-23.0488,-50.2276 ],
    [ u"br",u"Andradas",26773,-22.066667,-46.566667 ],
    [ u"br",u"Andradina",52407,-20.9,-51.383333 ],
    [ u"br",u"Andrelândia",10079,-21.733333,-44.3 ],
    [ u"br",u"Angatuba",14476,-23.483333,-48.416667 ],
    [ u"br",u"Angicos",7729,-5.666389,-36.600833 ],
    [ u"br",u"Angra dos Reis",153637,-23,-44.3 ],
    [ u"br",u"Anicuns",15685,-16.466667,-49.966667 ],
    [ u"br",u"Anori",8064,-3.783333,-61.633333 ],
    [ u"br",u"Antonina",16152,-25.4314,-48.7184 ],
    [ u"br",u"Aparecida",34237,-22.8418,-45.2287 ],
    [ u"br",u"Aparecida do Taboado",17332,-20.083333,-51.083333 ],
    [ u"br",u"Apiaí",18260,-24.511926,-48.844671 ],
    [ u"br",u"Apodi",16757,-5.65,-37.8 ],
    [ u"br",u"Apucarana",107086,-23.55,-51.483333 ],
    [ u"br",u"Aquidabã",10596,-10.283333,-37.033333 ],
    [ u"br",u"Aquidauana",35304,-20.466667,-55.8 ],
    [ u"br",u"Aquiraz",65117,-3.9,-38.366667 ],
    [ u"br",u"Aracaju",490184,-10.916667,-37.066667 ],
    [ u"br",u"Aracati",44294,-4.566667,-37.766667 ],
    [ u"br",u"Araçatuba",170028,-21.2,-50.416667 ],
    [ u"br",u"Araci",15089,-11.333333,-38.95 ],
    [ u"br",u"Aracoiaba",13425,-4.383333,-38.816667 ],
    [ u"br",u"Araçoiaba",13095,-7.8,-35.05 ],
    [ u"br",u"Araçoiaba da Serra",15395,-23.5049,-47.6185 ],
    [ u"br",u"Aracruz",58272,-19.816667,-40.266667 ],
    [ u"br",u"Araçuaí",22005,-16.866667,-42.066667 ],
    [ u"br",u"Aragarças",16781,-15.916667,-52.25 ],
    [ u"br",u"Araguaçu",7603,-12.894167,-49.773056 ],
    [ u"br",u"Araguaína",114959,-7.16,-48.0575 ],
    [ u"br",u"Araguari",96567,-18.633333,-48.183333 ],
    [ u"br",u"Araguatins",17106,-5.600278,-47.933056 ],
    [ u"br",u"Araioses",8667,-2.89,-41.903611 ],
    [ u"br",u"Arapiraca",166566,-9.75,-36.65 ],
    [ u"br",u"Arapongas",97513,-23.383333,-51.45 ],
    [ u"br",u"Araquari",35691,-26.3692,-48.7221 ],
    [ u"br",u"Arara",7641,-6.833333,-35.75 ],
    [ u"br",u"Araranguá",43445,-28.933333,-49.483333 ],
    [ u"br",u"Araraquara",185191,-21.783333,-48.166667 ],
    [ u"br",u"Araras",107465,-22.366667,-47.383333 ],
    [ u"br",u"Arari",16777,-3.466667,-44.783333 ],
    [ u"br",u"Araripe",11860,-7.2,-40.133333 ],
    [ u"br",u"Araripina",38570,-7.55,-40.566667 ],
    [ u"br",u"Araruama",109638,-22.883333,-42.333333 ],
    [ u"br",u"Araruna",7667,-6.533333,-35.733333 ],
    [ u"br",u"Arauá",4747,-11.266667,-37.616667 ],
    [ u"br",u"Araucária",111303,-25.583333,-49.416667 ],
    [ u"br",u"Araxá",82597,-19.583333,-46.916667 ],
    [ u"br",u"Arcos",33356,-20.283333,-45.533333 ],
    [ u"br",u"Arcoverde",57164,-8.416667,-36.916667 ],
    [ u"br",u"Areado",10689,-21.35,-46.15 ],
    [ u"br",u"Areal",11041,-22.228889,-43.106944 ],
    [ u"br",u"Areia",13825,-6.966667,-35.7 ],
    [ u"br",u"Areia Branca",18372,-4.953889,-37.132222 ],
    [ u"br",u"Areia Branca",7414,-10.766667,-37.316667 ],
    [ u"br",u"Arenápolis",9060,-14.433333,-56.816667 ],
    [ u"br",u"Arês",7231,-6.183333,-35.15 ],
    [ u"br",u"Arinos",10078,-15.916667,-46.066667 ],
    [ u"br",u"Aripuanã",27043,-9.166667,-60.633333 ],
    [ u"br",u"Ariquemes",58102,-9.933333,-63.066667 ],
    [ u"br",u"Armação dos Búzios",23463,-22.75,-41.883333 ],
    [ u"br",u"Aroeiras",7019,-7.516667,-35.683333 ],
    [ u"br",u"Arraial do Cabo",26164,-22.966667,-42.016667 ],
    [ u"br",u"Arraias",6881,-12.977222,-46.891667 ],
    [ u"br",u"Arroio do Meio",16331,-29.4,-51.95 ],
    [ u"br",u"Arroio dos Ratos",13405,-30.083333,-51.716667 ],
    [ u"br",u"Arroio Grande",16117,-32.233333,-53.083333 ],
    [ u"br",u"Artur Nogueira",40404,-22.583333,-47.15 ],
    [ u"br",u"Arujá",72078,-23.4,-46.333333 ],
    [ u"br",u"Assaí",12545,-23.366667,-50.816667 ],
    [ u"br",u"Assaré",11369,-6.866667,-39.866667 ],
    [ u"br",u"Assis",87473,-22.666667,-50.416667 ],
    [ u"br",u"Astolfo Dutra",10999,-21.316667,-42.866667 ],
    [ u"br",u"Astorga",20129,-23.216667,-51.666667 ],
    [ u"br",u"Atalaia",18908,-9.516667,-36.033333 ],
    [ u"br",u"Atibaia",110970,-23.124167,-46.562222 ],
    [ u"br",u"Augusto Correa",16280,-1.033333,-46.666667 ],
    [ u"br",u"Auriflama",11971,-20.683333,-50.566667 ],
    [ u"br",u"Aurora",10757,-6.95,-38.966667 ],
    [ u"br",u"Autazes",9614,-3.583333,-59.133333 ],
    [ u"br",u"Avaré",81287,-23.083333,-48.916667 ],
    [ u"br",u"Axixá do Tocantins",9007,-5.551111,-47.595556 ],
    [ u"br",u"Bacabal",72374,-4.233333,-44.783333 ],
    [ u"br",u"Bady Bassitt",14216,-20.933333,-49.466667 ],
    [ u"br",u"Baependi",12853,-21.95,-44.883333 ],
    [ u"br",u"Bagé",98943,-31.333333,-54.1 ],
    [ u"br",u"Baião",12316,-2.683333,-49.683333 ],
    [ u"br",u"Baixa Grande",7534,-11.95,-40.183333 ],
    [ u"br",u"Baixo Guandu",19292,-19.516667,-41.016667 ],
    [ u"br",u"Balsas",68058,-7.516667,-46.033333 ],
    [ u"br",u"Bambuí",18840,-20.016667,-45.966667 ],
    [ u"br",u"Bananeiras",7371,-6.75,-35.616667 ],
    [ u"br",u"Bandeirantes",29495,-23.1,-50.35 ],
    [ u"br",u"Barão de Cocais",22387,-19.933333,-43.466667 ],
    [ u"br",u"Barão de Melgaço",4353,-16.216667,-55.966667 ],
    [ u"br",u"Baraúna",14113,-5.083333,-37.616667 ],
    [ u"br",u"Barbacena",122213,-21.233333,-43.766667 ],
    [ u"br",u"Barbalha",33944,-7.316667,-39.283333 ],
    [ u"br",u"Barbosa Ferraz",9048,-24.066667,-52.05 ],
    [ u"br",u"Barcarena",29872,-1.5,-48.666667 ],
    [ u"br",u"Barcelos",7356,-1,-62.966667 ],
    [ u"br",u"Bariri",28802,-22.066667,-48.733333 ],
    [ u"br",u"Barra",20895,-11.083333,-43.166667 ],
    [ u"br",u"Barra Bonita",37247,-22.483333,-48.533333 ],
    [ u"br",u"Barra da Estiva",12618,-13.633333,-41.316667 ],
    [ u"br",u"Barra de São Francisco",20743,-18.75,-40.866667 ],
    [ u"br",u"Barra do Bugres",31313,-15.083333,-57.183333 ],
    [ u"br",u"Barra do Corda",48902,-5.5,-45.25 ],
    [ u"br",u"Barra do Garças",52402,-15.883333,-52.25 ],
    [ u"br",u"Barra do Piraí",87669,-22.466111,-43.827778 ],
    [ u"br",u"Barra dos Coqueiros",28590,-10.9,-37.05 ],
    [ u"br",u"Barra Mansa",164054,-22.533333,-44.183333 ],
    [ u"br",u"Barras",21597,-4.25,-42.3 ],
    [ u"br",u"Barra Velha",17665,-26.6406,-48.6851 ],
    [ u"br",u"Barreiras",158296,-12.133333,-45 ],
    [ u"br",u"Barreirinha",11257,-2.793611,-57.068889 ],
    [ u"br",u"Barreirinhas",17437,-2.75,-42.833333 ],
    [ u"br",u"Barreiros",35565,-8.816667,-35.2 ],
    [ u"br",u"Barretos",101222,-20.55,-48.55 ],
    [ u"br",u"Barrinha",26981,-21.2,-48.15 ],
    [ u"br",u"Barro",11519,-6.716667,-38.866667 ],
    [ u"br",u"Barroquinha",12410,-2.983333,-41.083333 ],
    [ u"br",u"Barroso",16975,-21.183333,-43.966667 ],
    [ u"br",u"Barueri",251999,-23.516667,-46.883333 ],
    [ u"br",u"Bastos",17681,-21.933333,-50.716667 ],
    [ u"br",u"Bataiporã",7346,-22.333333,-53.283333 ],
    [ u"br",u"Batalha",11820,-9.683333,-37.133333 ],
    [ u"br",u"Batalha",8744,-4.016667,-42.083333 ],
    [ u"br",u"Batatais",51977,-20.883333,-47.616667 ],
    [ u"br",u"Baturité",22417,-4.333333,-38.883333 ],
    [ u"br",u"Bauru",335031,-22.316667,-49.066667 ],
    [ u"br",u"Bayeux",91058,-7.133333,-34.933333 ],
    [ u"br",u"Bebedouro",71863,-20.933333,-48.466667 ],
    [ u"br",u"Beberibe",37028,-4.183333,-38.133333 ],
    [ u"br",u"Bela Cruz",12715,-3.05,-40.183333 ],
    [ u"br",u"Bela Vista",18127,-22.1,-56.516667 ],
    [ u"br",u"Bela Vista de Goiás",14289,-16.966667,-48.95 ],
    [ u"br",u"Bela Vista do Paraíso",14332,-23,-51.2 ],
    [ u"br",u"Belém",1407737,-1.45,-48.483333 ],
    [ u"br",u"Belém",15550,-6.716667,-35.5 ],
    [ u"br",u"Belém de São Francisco",11124,-8.766667,-38.966667 ],
    [ u"br",u"Belford Roxo",466101,-22.761995,-43.404654 ],
    [ u"br",u"Belmonte",9806,-15.85,-38.9 ],
    [ u"br",u"Belo Horizonte",2373255,-19.916667,-43.933333 ],
    [ u"br",u"Belo Jardim",49923,-8.333333,-36.433333 ],
    [ u"br",u"Belo Oriente",18471,-19.233333,-42.466667 ],
    [ u"br",u"Beneditinos",5005,-5.45,-42.366667 ],
    [ u"br",u"Benevides",49813,-1.366667,-48.25 ],
    [ u"br",u"Benjamin Constant",13998,-4.374444,-70.029722 ],
    [ u"br",u"Bento Gonçalves",90854,-29.166667,-51.516667 ],
    [ u"br",u"Bequimão",5695,-2.433333,-44.783333 ],
    [ u"br",u"Bernardino de Campos",9342,-23.033333,-49.483333 ],
    [ u"br",u"Betim",384038,-19.966667,-44.216667 ],
    [ u"br",u"Bezerros",51437,-8.233333,-35.75 ],
    [ u"br",u"Bicas",12684,-21.716667,-43.066667 ],
    [ u"br",u"Biguaçu",51993,-27.5,-48.666667 ],
    [ u"br",u"Birigui",102279,-21.3,-50.316667 ],
    [ u"br",u"Biritiba-Mirim",26459,-23.583333,-46.033333 ],
    [ u"br",u"Blumenau",293955,-26.9222,-49.0615 ],
    [ u"br",u"Boa Esperança",9254,-18.55,-40.283333 ],
    [ u"br",u"Boa Esperança",33840,-21.083333,-45.566667 ],
    [ u"br",u"Boa Esperança do Sul",10787,-21.983333,-48.383333 ],
    [ u"br",u"Boa Viagem",24671,-5.116667,-39.733333 ],
    [ u"br",u"Boa Vista",235159,2.816667,-60.666667 ],
    [ u"br",u"Bôca da Mata",17834,-9.6,-36.25 ],
    [ u"br",u"Bôca do Acre",14427,-8.75,-67.383333 ],
    [ u"br",u"Bocaiúva",32115,-17.116667,-43.816667 ],
    [ u"br",u"Bodocó",11329,-7.783333,-39.916667 ],
    [ u"br",u"Boituva",48756,-23.283333,-47.683333 ],
    [ u"br",u"Bom Conselho",27801,-9.166667,-36.683333 ],
    [ u"br",u"Bom Despacho",40304,-19.716667,-45.25 ],
    [ u"br",u"Bom Jardim",12343,-7.016667,-46.483333 ],
    [ u"br",u"Bom Jardim",11716,-22.15,-42.416667 ],
    [ u"br",u"Bom Jardim",13523,-7.783333,-35.583333 ],
    [ u"br",u"Bom Jesus",12666,-9.066667,-44.366667 ],
    [ u"br",u"Bom Jesus da Lapa",40693,-13.25,-43.416667 ],
    [ u"br",u"Bom Jesus do Galho",12476,-19.833333,-42.316667 ],
    [ u"br",u"Bom Jesus do Itabapoana",30822,-21.133333,-41.683333 ],
    [ u"br",u"Bom Jesus dos Perdões",12422,-23.133333,-46.466667 ],
    [ u"br",u"Bom Sucesso",13786,-21.033333,-44.766667 ],
    [ u"br",u"Bonfim",5769,3.083333,-59.95 ],
    [ u"br",u"Bonito",14504,-21.133333,-56.466667 ],
    [ u"br",u"Bonito",8867,-8.483333,-35.733333 ],
    [ u"br",u"Boqueirão",11566,-7.483333,-36.116667 ],
    [ u"br",u"Boquim",14848,-11.15,-37.616667 ],
    [ u"br",u"Boquira",6306,-12.816667,-42.766667 ],
    [ u"br",u"Borba",11918,-4.388889,-59.593611 ],
    [ u"br",u"Borborema",11759,-21.616667,-49.066667 ],
    [ u"br",u"Borda da Mata",12814,-22.266667,-46.166667 ],
    [ u"br",u"Botelhos",11073,-21.65,-46.4 ],
    [ u"br",u"Botucatu",113865,-22.866667,-48.433333 ],
    [ u"br",u"Braço do Norte",22375,-28.283333,-49.183333 ],
    [ u"br",u"Bragança",57164,-1.05,-46.766667 ],
    [ u"br",u"Bragança Paulista",125099,-22.95,-46.566667 ],
    [ u"br",u"Brasiléia",11200,-11,-68.733333 ],
    [ u"br",u"Brasília",2207812,-15.783333,-47.916667 ],
    [ u"br",u"Brasília de Minas",14730,-16.211944,-44.430833 ],
    [ u"br",u"Brejinho",7625,-6.183333,-35.35 ],
    [ u"br",u"Brejo",11636,-3.683333,-42.783333 ],
    [ u"br",u"Brejo da Madre de Deus",27370,-8.15,-36.366667 ],
    [ u"br",u"Brejo Santo",27384,-7.483333,-39 ],
    [ u"br",u"Breves",46474,-1.666667,-50.483333 ],
    [ u"br",u"Brodowski",18366,-20.983333,-47.666667 ],
    [ u"br",u"Brotas",18690,-22.283333,-48.116667 ],
    [ u"br",u"Brumadinho",27564,-20.133333,-44.216667 ],
    [ u"br",u"Brumado",41990,-14.216667,-41.666667 ],
    [ u"br",u"Brusque",88286,-27.1,-48.933333 ],
    [ u"br",u"Bueno Brandão",5777,-22.45,-46.35 ],
    [ u"br",u"Buerarema",16002,-14.95,-39.316667 ],
    [ u"br",u"Buíque",20324,-8.616667,-37.15 ],
    [ u"br",u"Bujaru",6189,-1.516667,-48.016667 ],
    [ u"br",u"Buri",15959,-23.8,-48.583333 ],
    [ u"br",u"Buritama",12712,-21.05,-50.133333 ],
    [ u"br",u"Buriti Alegre",9427,-18.15,-49.05 ],
    [ u"br",u"Buriti Bravo",17693,-5.833333,-43.833333 ],
    [ u"br",u"Buriti",7025,-3.916667,-42.95 ],
    [ u"br",u"Buriti dos Lopes",9475,-3.166667,-41.866667 ],
    [ u"br",u"Buritis",16243,-15.616667,-46.433333 ],
    [ u"br",u"Buritizeiro",25104,-17.35,-44.966667 ],
    [ u"br",u"Butiá",19494,-30.116667,-51.966667 ],
    [ u"br",u"Caaporã",13770,-7.516667,-34.9 ],
    [ u"br",u"Caarapó",13863,-22.633333,-54.8 ],
    [ u"br",u"Cabedelo",54841,-6.966667,-34.833333 ],
    [ u"br",u"Cabo Frio",108241,-22.883333,-42.016667 ],
    [ u"br",u"Cabreúva",38743,-23.3,-47.133333 ],
    [ u"br",u"Cabrobó",16096,-8.516667,-39.316667 ],
    [ u"br",u"Caçador",63727,-26.783333,-51 ],
    [ u"br",u"Caçapava",72341,-23.1,-45.716667 ],
    [ u"br",u"Caçapava do Sul",17522,-30.5,-53.5 ],
    [ u"br",u"Cacequi",12868,-29.883333,-54.816667 ],
    [ u"br",u"Cáceres",73431,-16.066667,-57.683333 ],
    [ u"br",u"Cachoeira",16145,-12.6,-38.966667 ],
    [ u"br",u"Cachoeira do Sul",74696,-30.033333,-52.9 ],
    [ u"br",u"Cachoeiras de Macacu",46178,-22.466667,-42.65 ],
    [ u"br",u"Cachoeirinha",121086,-29.95,-51.083333 ],
    [ u"br",u"Cachoeirinha",12905,-8.483333,-36.233333 ],
    [ u"br",u"Cachoeiro de Itapemirim",187023,-20.85,-41.1 ],
    [ u"br",u"Cacimba de Dentro",7447,-6.65,-35.783333 ],
    [ u"br",u"Cacimbinhas",4618,-9.4,-37 ],
    [ u"br",u"Cacoal",55566,-11.5,-61.416667 ],
    [ u"br",u"Caconde",12434,-21.55,-46.633333 ],
    [ u"br",u"Caçu",10098,-18.616667,-51.066667 ],
    [ u"br",u"Caculé",12143,-14.5,-42.216667 ],
    [ u"br",u"Caeté",33232,-19.9,-43.666667 ],
    [ u"br",u"Caetés",5386,-8.766667,-36.633333 ],
    [ u"br",u"Caetité",27188,-14.066667,-42.483333 ],
    [ u"br",u"Cafarnaum",12940,-11.7,-41.466667 ],
    [ u"br",u"Cafelândia",13777,-21.816667,-49.583333 ],
    [ u"br",u"Caiapônia",10947,-16.95,-51.816667 ],
    [ u"br",u"Caicó",54935,-6.45,-37.1 ],
    [ u"br",u"Caieiras",87199,-23.36193,-46.740681 ],
    [ u"br",u"Cajamar",56684,-23.35,-46.883333 ],
    [ u"br",u"Cajati",27566,-24.728502,-48.110541 ],
    [ u"br",u"Cajàzeiras",43914,-6.9,-38.566667 ],
    [ u"br",u"Cajueiro",15063,-9.716667,-36.45 ],
    [ u"br",u"Cajuru",19540,-21.283333,-47.3 ],
    [ u"br",u"Caldas Novas",63681,-17.75,-48.633333 ],
    [ u"br",u"Camaçari",188763,-12.483333,-38.216667 ],
    [ u"br",u"Camamu",13924,-13.95,-39.116667 ],
    [ u"br",u"Camanducaia",17823,-22.766667,-46.15 ],
    [ u"br",u"Camapuã",11119,-19.5,-54.083333 ],
    [ u"br",u"Camaquã",53170,-30.85,-51.816667 ],
    [ u"br",u"Camaragibe",148966,-8.016667,-34.966667 ],
    [ u"br",u"Cambará",21380,-23.0411,-50.0741 ],
    [ u"br",u"Cambé",91081,-23.233333,-51.25 ],
    [ u"br",u"Camboriú",49101,-26.983333,-48.633333 ],
    [ u"br",u"Cambuci",9395,-21.566667,-41.916667 ],
    [ u"br",u"Cambuí",21247,-22.616667,-46.066667 ],
    [ u"br",u"Cambuquira",10116,-21.85,-45.3 ],
    [ u"br",u"Cametá",45202,-2.25,-49.5 ],
    [ u"br",u"Camocim",44482,-2.89,-40.846111 ],
    [ u"br",u"Camocim de São Félix",10270,-8.35,-35.766667 ],
    [ u"br",u"Campanha",12507,-21.833333,-45.4 ],
    [ u"br",u"Campestre",11802,-21.716667,-46.25 ],
    [ u"br",u"Campina Grande",348943,-7.216667,-35.883333 ],
    [ u"br",u"Campina Grande do Sul",31112,-25.3,-49.083333 ],
    [ u"br",u"Campinas",1031573,-22.9,-47.083333 ],
    [ u"br",u"Campina Verde",13137,-19.516667,-49.466667 ],
    [ u"br",u"Campo Alegre",16786,-9.8,-36.35 ],
    [ u"br",u"Campo Bom",54762,-29.683333,-51.05 ],
    [ u"br",u"Campo do Brito",8011,-10.75,-37.5 ],
    [ u"br",u"Campo Formoso",23921,-10.516667,-40.333333 ],
    [ u"br",u"Campo Grande",3054,-10.233333,-36.5 ],
    [ u"br",u"Campo Grande",729164,-20.45,-54.616667 ],
    [ u"br",u"Campo Largo",94669,-25.433333,-49.533333 ],
    [ u"br",u"Campo Maior",31740,-4.816667,-42.166667 ],
    [ u"br",u"Campos Altos",12648,-19.683333,-46.166667 ],
    [ u"br",u"Campos Belos",15583,-13.05,-46.883333 ],
    [ u"br",u"Campos",387422,-21.75,-41.3 ],
    [ u"br",u"Campos do Jordão",53320,-22.7264,-45.5792 ],
    [ u"br",u"Campos Gerais",22260,-21.233333,-45.766667 ],
    [ u"br",u"Campos Novos",22563,-27.4,-51.2 ],
    [ u"br",u"Campos Sales",17648,-7.066667,-40.383333 ],
    [ u"br",u"Campo Verde",22842,-20.416667,-54.066667 ],
    [ u"br",u"Cananéia",13786,-25.016667,-47.95 ],
    [ u"br",u"Canapi",4219,-9.133333,-37.5 ],
    [ u"br",u"Canarana",10785,-11.683333,-41.766667 ],
    [ u"br",u"Canavieiras",26376,-15.65,-38.95 ],
    [ u"br",u"Candeias",75673,-12.666667,-38.55 ],
    [ u"br",u"Candelária",15200,-29.666667,-52.8 ],
    [ u"br",u"Cândido de Abreu",5102,-24.583333,-51.333333 ],
    [ u"br",u"Cândido Mendes",8613,-1.45,-45.716667 ],
    [ u"br",u"Cândido Mota",28145,-22.716667,-50.383333 ],
    [ u"br",u"Canela",33529,-29.366667,-50.833333 ],
    [ u"br",u"Canguaretama",18873,-6.383333,-35.133333 ],
    [ u"br",u"Canguçu",20134,-31.4,-52.683333 ],
    [ u"br",u"Canhotinho",12074,-8.883333,-36.2 ],
    [ u"br",u"Canindé",42721,-4.366667,-39.316667 ],
    [ u"br",u"Canindé de São Francisco",11053,-9.65,-37.8 ],
    [ u"br",u"Canoas",328297,-29.933333,-51.183333 ],
    [ u"br",u"Canoinhas",38863,-26.166667,-50.4 ],
    [ u"br",u"Cansanção",9905,-10.683333,-39.516667 ],
    [ u"br",u"Cantagalo",14019,-21.966667,-42.366667 ],
    [ u"br",u"Cantanhede",8344,-3.65,-44.4 ],
    [ u"br",u"Canto do Buriti",11715,-8.116667,-42.966667 ],
    [ u"br",u"Canutama",6320,-6.533333,-64.333333 ],
    [ u"br",u"Capanema",47768,-1.2,-47.183333 ],
    [ u"br",u"Capão Bonito",37207,-24.016667,-48.333333 ],
    [ u"br",u"Capão da Canoa",35896,-29.766667,-50.016667 ],
    [ u"br",u"Capela",12520,-9.416667,-36.066667 ],
    [ u"br",u"Capela",16024,-10.5,-37.066667 ],
    [ u"br",u"Capela do Alto",11991,-23.466667,-47.75 ],
    [ u"br",u"Capelinha",20074,-17.7,-42.516667 ],
    [ u"br",u"Capim Grosso",17322,-11.366667,-40.016667 ],
    [ u"br",u"Capinópolis",12486,-18.683333,-49.583333 ],
    [ u"br",u"Capinzal",23799,-27.333333,-51.6 ],
    [ u"br",u"Capitão Poço",32704,-1.75,-47.083333 ],
    [ u"br",u"Capivari",35519,-23.000722,-47.502026 ],
    [ u"br",u"Capoeiras",4861,-8.75,-36.633333 ],
    [ u"br",u"Caraguatatuba",90844,-23.616667,-45.416667 ],
    [ u"br",u"Caraí",6750,-17.2,-41.7 ],
    [ u"br",u"Carambeí",13466,-24.933333,-50.083333 ],
    [ u"br",u"Carandaí",16657,-20.933333,-43.916667 ],
    [ u"br",u"Carangola",25322,-20.733333,-42.033333 ],
    [ u"br",u"Carapicuíba",361120,-23.516667,-46.833333 ],
    [ u"br",u"Caratinga",60067,-19.783333,-42.133333 ],
    [ u"br",u"Carauari",18059,-4.879167,-66.898056 ],
    [ u"br",u"Caraúbas",12462,-5.53,-37.303056 ],
    [ u"br",u"Caravelas",11322,-17.75,-39.25 ],
    [ u"br",u"Caràzinho",59418,-28.3,-52.8 ],
    [ u"br",u"Cardoso",10556,-20.066667,-49.9 ],
    [ u"br",u"Careiro",6659,-3.2,-59.75 ],
    [ u"br",u"Careiro da Várzea",1092,-3.2,-59.75 ],
    [ u"br",u"Cariacica",330681,-20.266667,-40.416667 ],
    [ u"br",u"Carinhanha",11408,-14.3,-43.783333 ],
    [ u"br",u"Carira",10276,-10.35,-37.7 ],
    [ u"br",u"Cariré",5488,-3.95,-40.45 ],
    [ u"br",u"Caririaçu",12971,-7.033333,-39.283333 ],
    [ u"br",u"Carlos Barbosa",19106,-29.3,-51.5 ],
    [ u"br",u"Carlos Chagas",13206,-17.716667,-40.75 ],
    [ u"br",u"Carmo",11555,-21.933333,-42.616667 ],
    [ u"br",u"Carmo do Cajuru",16333,-20.183333,-44.766667 ],
    [ u"br",u"Carmo do Paranaíba",26537,-18.983333,-46.35 ],
    [ u"br",u"Carmo do Rio Claro",14446,-20.966667,-46.116667 ],
    [ u"br",u"Carmo do Rio Verde",6053,-15.35,-49.7 ],
    [ u"br",u"Carnaíba",6019,-8.7,-37.666667 ],
    [ u"br",u"Carolina",16229,-7.333333,-47.466667 ],
    [ u"br",u"Carpina",70690,-7.85,-35.25 ],
    [ u"br",u"Caruaru",235375,-8.283333,-35.966667 ],
    [ u"br",u"Carutapera",12819,-1.216667,-46.016667 ],
    [ u"br",u"Casa Branca",22498,-21.766667,-47.083333 ],
    [ u"br",u"Casa Nova",33319,-9.416667,-41.133333 ],
    [ u"br",u"Cascavel",52357,-4.116667,-38.233333 ],
    [ u"br",u"Cascavel",257174,-24.95,-53.466667 ],
    [ u"br",u"Casimiro de Abreu",19087,-22.483333,-42.2 ],
    [ u"br",u"Cássia",14391,-20.6,-46.933333 ],
    [ u"br",u"Cassilândia",18498,-19.15,-51.75 ],
    [ u"br",u"Castanhal",137410,-1.3,-47.916667 ],
    [ u"br",u"Castelo",20198,-20.6,-41.2 ],
    [ u"br",u"Castelo do Piauí",8589,-5.333333,-41.55 ],
    [ u"br",u"Castilho",11419,-20.866667,-51.483333 ],
    [ u"br",u"Castro Alves",13869,-12.75,-39.433333 ],
    [ u"br",u"Castro",42092,-24.783333,-50 ],
    [ u"br",u"Cataguases",62619,-21.4,-42.683333 ],
    [ u"br",u"Catalão",63545,-18.166667,-47.95 ],
    [ u"br",u"Catanduva",109615,-21.133333,-48.966667 ],
    [ u"br",u"Catende",23323,-8.666667,-35.716667 ],
    [ u"br",u"Catolé do Rocha",19812,-6.35,-37.75 ],
    [ u"br",u"Catu",39933,-12.35,-38.383333 ],
    [ u"br",u"Caucaia",275023,-3.7,-38.65 ],
    [ u"br",u"Cavalcante",3747,-13.8,-47.5 ],
    [ u"br",u"Caxambu",22701,-21.983333,-44.933333 ],
    [ u"br",u"Caxias",117393,-4.833333,-43.35 ],
    [ u"br",u"Caxias do Sul",381277,-29.1689,-51.1785 ],
    [ u"br",u"Ceará-Mirim",32668,-5.633333,-35.433333 ],
    [ u"br",u"Cedro",14644,-6.6,-39.05 ],
    [ u"br",u"Centenário do Sul",8358,-22.8,-51.616667 ],
    [ u"br",u"Centralina",9497,-18.566667,-49.216667 ],
    [ u"br",u"Ceres",18760,-15.283333,-49.583333 ],
    [ u"br",u"Cerqueira César",14261,-23.05,-49.166667 ],
    [ u"br",u"Cerquilho",35367,-23.201218,-47.757822 ],
    [ u"br",u"Cêrro Largo",9548,-28.15,-54.75 ],
    [ u"br",u"Chã Grande",17117,-8.233333,-35.45 ],
    [ u"br",u"Chapada dos Guimarães",13657,-15.433333,-55.75 ],
    [ u"br",u"Chapadinha",40805,-3.733333,-43.35 ],
    [ u"br",u"Chapecó",160160,-27.083333,-52.983333 ],
    [ u"br",u"Charqueada",12391,-22.5,-47.766667 ],
    [ u"br",u"Charqueadas",32076,-29.966667,-51.633333 ],
    [ u"br",u"Chavantes",10306,-23.033333,-49.716667 ],
    [ u"br",u"Chopinzinho",14142,-25.85,-52.5 ],
    [ u"br",u"Choròzinho",9755,-4.3,-38.483333 ],
    [ u"br",u"Cianorte",55995,-23.616667,-52.616667 ],
    [ u"br",u"Cícero Dantas",18317,-10.6,-38.383333 ],
    [ u"br",u"Cidreira",8965,-30.183333,-50.2 ],
    [ u"br",u"Cláudio",21825,-20.433333,-44.766667 ],
    [ u"br",u"Clevelândia",14701,-26.4,-52.35 ],
    [ u"br",u"Coaraci",32345,-14.633333,-39.533333 ],
    [ u"br",u"Coari",50491,-4.109444,-63.138889 ],
    [ u"br",u"Cocal",12097,-3.466667,-41.566667 ],
    [ u"br",u"Codajás",11185,-3.833333,-62.083333 ],
    [ u"br",u"Codó",83289,-4.483333,-43.883333 ],
    [ u"br",u"Coelho Neto",36185,-4.25,-43 ],
    [ u"br",u"Coité do Nóia",2529,-9.666667,-36.5 ],
    [ u"br",u"Colatina",101193,-19.533333,-40.616667 ],
    [ u"br",u"Colina",15042,-20.733333,-48.583333 ],
    [ u"br",u"Colinas",25159,-6.033333,-44.233333 ],
    [ u"br",u"Colombo",217002,-25.283333,-49.233333 ],
    [ u"br",u"Colônia Leopoldina",11914,-8.95,-35.65 ],
    [ u"br",u"Colorado",20449,-22.816667,-51.95 ],
    [ u"br",u"Conceição da Barra",19310,-18.583333,-39.75 ],
    [ u"br",u"Conceição da Feira",15838,-12.5,-39 ],
    [ u"br",u"Conceição das Alagoas",16152,-19.916667,-48.383333 ],
    [ u"br",u"Conceição do Almeida",9691,-12.8,-39.2 ],
    [ u"br",u"Conceição do Araguaia",27116,-8.241111,-49.296111 ],
    [ u"br",u"Conceição do Castelo",4538,-20.366667,-41.25 ],
    [ u"br",u"Conceição do Coité",35172,-11.55,-39.266667 ],
    [ u"br",u"Conceição do Mato Dentro",10708,-19.016667,-43.416667 ],
    [ u"br",u"Conceição do Rio Verde",12402,-21.883333,-45.083333 ],
    [ u"br",u"Conchal",21351,-22.333333,-47.166667 ],
    [ u"br",u"Conchas",14301,-23.016667,-48 ],
    [ u"br",u"Concórdia",55368,-27.233333,-52.016667 ],
    [ u"br",u"Condado",19585,-7.583333,-35.1 ],
    [ u"br",u"Conde",15565,-11.816667,-37.616667 ],
    [ u"br",u"Congonhas",48819,-20.5,-43.866667 ],
    [ u"br",u"Conselheiro Lafaiete",111598,-20.666667,-43.8 ],
    [ u"br",u"Conselheiro Pena",12735,-19.166667,-41.5 ],
    [ u"br",u"Contagem",627132,-19.916667,-44.1 ],
    [ u"br",u"Coração de Jesus",12410,-16.684444,-44.360278 ],
    [ u"br",u"Coração de Maria",6571,-12.233333,-38.75 ],
    [ u"br",u"Corbélia",12725,-24.8,-53.3 ],
    [ u"br",u"Cordeiro",15602,-22.033333,-42.366667 ],
    [ u"br",u"Cordeirópolis",25639,-22.483333,-47.466667 ],
    [ u"br",u"Coreaú",12383,-3.55,-40.65 ],
    [ u"br",u"Coremas",11897,-7.016667,-37.966667 ],
    [ u"br",u"Corinto",22121,-18.35,-44.45 ],
    [ u"br",u"Cornélio Procópio",45031,-23.133333,-50.65 ],
    [ u"br",u"Coroatá",34130,-4.133333,-44.133333 ],
    [ u"br",u"Coromandel",22648,-18.466667,-47.216667 ],
    [ u"br",u"Coronel Fabriciano",100918,-19.516667,-42.633333 ],
    [ u"br",u"Coronel Vivida",15841,-25.966667,-52.566667 ],
    [ u"br",u"Correia Pinto",13752,-27.583333,-50.4 ],
    [ u"br",u"Corrente",13967,-10.436111,-45.131111 ],
    [ u"br",u"Correntina",13187,-13.333333,-44.65 ],
    [ u"br",u"Corumbá",96523,-19.016667,-57.65 ],
    [ u"br",u"Coruripe",31428,-10.133333,-36.166667 ],
    [ u"br",u"Cosmópolis",47773,-22.633333,-47.2 ],
    [ u"br",u"Costa Rica",12931,-23.416667,-54.65 ],
    [ u"br",u"Cotia",174832,-23.616667,-46.933333 ],
    [ u"br",u"Coxim",30216,-18.5,-54.75 ],
    [ u"br",u"Crateús",52934,-5.166667,-40.666667 ],
    [ u"br",u"Crato",88788,-7.233333,-39.383333 ],
    [ u"br",u"Cravinhos",32690,-21.316667,-47.75 ],
    [ u"br",u"Criciúma",161957,-28.666667,-49.383333 ],
    [ u"br",u"Cristalina",36532,-16.75,-47.6 ],
    [ u"br",u"Cristinápolis",6430,-11.483333,-37.766667 ],
    [ u"br",u"Crixás",11560,-14.45,-49.966667 ],
    [ u"br",u"Cruz Alta",65276,-28.65,-53.6 ],
    [ u"br",u"Cruz",8723,-2.95,-40.183333 ],
    [ u"br",u"Cruz das Almas",47846,-12.666667,-39.1 ],
    [ u"br",u"Cruz do Espírito Santo",5812,-7.133333,-35.1 ],
    [ u"br",u"Cruzeiro",72023,-22.566667,-44.966667 ],
    [ u"br",u"Cruzeiro do Oeste",15058,-23.766667,-53.066667 ],
    [ u"br",u"Cruzeiro do Sul",45517,-7.633333,-72.6 ],
    [ u"br",u"Cruzília",12816,-21.833333,-44.8 ],
    [ u"br",u"Cubatão",118412,-23.883333,-46.416667 ],
    [ u"br",u"Cuiabá",521961,-15.583333,-56.083333 ],
    [ u"br",u"Cuité",11392,-6.483333,-36.15 ],
    [ u"br",u"Cumaru",6861,-8,-35.7 ],
    [ u"br",u"Cunha",11896,-23.083333,-44.966667 ],
    [ u"br",u"Cupira",19096,-8.616667,-35.95 ],
    [ u"br",u"Curaçá",11858,-8.983333,-39.9 ],
    [ u"br",u"Curitiba",1718433,-25.416667,-49.25 ],
    [ u"br",u"Curitibanos",32142,-27.3,-50.6 ],
    [ u"br",u"Currais Novos",35561,-6.25,-36.516667 ],
    [ u"br",u"Curuçá",10843,-.716667,-47.833333 ],
    [ u"br",u"Cururupu",22007,-1.833333,-44.866667 ],
    [ u"br",u"Curvelo",63955,-18.75,-44.416667 ],
    [ u"br",u"Custódia",18107,-8.116667,-37.65 ],
    [ u"br",u"Delmiro Gouveia",35260,-9.383333,-37.983333 ],
    [ u"br",u"Demerval Lobão",15285,-5.366667,-42.683333 ],
    [ u"br",u"Descalvado",26138,-21.9,-47.616667 ],
    [ u"br",u"Destêrro",5374,-7.283333,-37.1 ],
    [ u"br",u"Diadema",390641,-23.7,-46.616667 ],
    [ u"br",u"Diamantina",37344,-18.25,-43.6 ],
    [ u"br",u"Diamantino",15700,-14.416667,-56.45 ],
    [ u"br",u"Dianópolis",12896,-11.700556,-46.743056 ],
    [ u"br",u"Divinópolis",193835,-20.15,-44.9 ],
    [ u"br",u"Dois Córregos",20975,-22.366667,-48.35 ],
    [ u"br",u"Dois Irmãos",28926,-29.583333,-51.083333 ],
    [ u"br",u"Dois Riachos",4565,-9.383333,-37.083333 ],
    [ u"br",u"Dois Vizinhos",22766,-25.783333,-53.083333 ],
    [ u"br",u"Domingos Martins",6061,-20.366667,-40.666667 ],
    [ u"br",u"Dom Pedrito",36912,-30.983333,-54.666667 ],
    [ u"br",u"Dom Pedro",15570,-4.483333,-44.45 ],
    [ u"br",u"Dona Inês",3709,-6.616667,-35.633333 ],
    [ u"br",u"Dores do Indaiá",12859,-19.45,-45.6 ],
    [ u"br",u"Dourados",162206,-22.216667,-54.8 ],
    [ u"br",u"Dracena",37940,-21.533333,-51.483333 ],
    [ u"br",u"Duartina",11903,-22.4,-49.416667 ],
    [ u"br",u"Duque de Caxias",818339,-22.790321,-43.325009 ],
    [ u"br",u"Ecoporanga",13774,-18.383333,-40.833333 ],
    [ u"br",u"Edéia",9838,-17.3,-49.916667 ],
    [ u"br",u"Eirunepé",17175,-6.666667,-69.866667 ],
    [ u"br",u"Eldorado",9075,-23.783333,-54.316667 ],
    [ u"br",u"Elesbão Veloso",10430,-6.216667,-42.133333 ],
    [ u"br",u"Elias Fausto",12705,-23.033333,-47.383333 ],
    [ u"br",u"Elói Mendes",19413,-21.616667,-45.566667 ],
    [ u"br",u"Embu",221737,-23.65,-46.85 ],
    [ u"br",u"Embu-Guaçu",76311,-23.816667,-46.8 ],
    [ u"br",u"Encantado",16637,-29.25,-51.883333 ],
    [ u"br",u"Encruzilhada do Sul",17199,-30.533333,-52.516667 ],
    [ u"br",u"Encruzilhada",4711,-15.516667,-40.9 ],
    [ u"br",u"Engenheiro Beltrão",14955,-23.783333,-52.25 ],
    [ u"br",u"Entre Rios",27406,-11.933333,-38.083333 ],
    [ u"br",u"Envira",9957,-7.3,-70.216667 ],
    [ u"br",u"Erechim",96089,-27.633333,-52.283333 ],
    [ u"br",u"Escada",48084,-8.366667,-35.233333 ],
    [ u"br",u"Esmeraldas",103252,-19.75,-44.316667 ],
    [ u"br",u"Espera Feliz",13031,-20.65,-41.916667 ],
    [ u"br",u"Esperança",18817,-7.016667,-35.85 ],
    [ u"br",u"Esperantina",21044,-3.9,-42.233333 ],
    [ u"br",u"Esperantinópolis",13167,-4.883333,-44.883333 ],
    [ u"br",u"Espinosa",17549,-14.933333,-42.833333 ],
    [ u"br",u"Espirito Santo do Pinhal",37449,-22.2,-46.75 ],
    [ u"br",u"Esplanada",18859,-11.783333,-37.95 ],
    [ u"br",u"Espumoso",10340,-28.733333,-52.85 ],
    [ u"br",u"Estância",55655,-11.266667,-37.433333 ],
    [ u"br",u"Estância Velha",40391,-29.65,-51.183333 ],
    [ u"br",u"Esteio",84903,-29.85,-51.166667 ],
    [ u"br",u"Estreito",17647,-5.783333,-43.25 ],
    [ u"br",u"Estrêla",24200,-28.1,-50.983333 ],
    [ u"br",u"Euclides da Cunha",29739,-10.516667,-39.016667 ],
    [ u"br",u"Eusébio",37290,-3.9,-38.45 ],
    [ u"br",u"Extrema",13682,-22.85,-46.316667 ],
    [ u"br",u"Extremóz",17992,-5.7,-35.3 ],
    [ u"br",u"Exu",10875,-7.516667,-39.716667 ],
    [ u"br",u"Fagundes",5137,-7.35,-35.8 ],
    [ u"br",u"Farias Brito",11288,-6.916667,-39.566667 ],
    [ u"br",u"Farroupilha",57651,-29.233333,-51.35 ],
    [ u"br",u"Fartura",12405,-23.383333,-49.5 ],
    [ u"br",u"Faxinal",13464,-23.983333,-51.366667 ],
    [ u"br",u"Feijó",12951,-8.15,-70.35 ],
    [ u"br",u"Feira de Santana",481926,-12.25,-38.95 ],
    [ u"br",u"Feira Grande",3985,-9.85,-36.7 ],
    [ u"br",u"Feira Nova",12985,-7.933333,-35.35 ],
    [ u"br",u"Fernandópolis",61932,-20.266667,-50.233333 ],
    [ u"br",u"Ferraz de Vasconcelos",167904,-23.533333,-46.366667 ],
    [ u"br",u"Firminópolis",9084,-16.666667,-50.316667 ],
    [ u"br",u"Flexeiras",7783,-9.266667,-35.716667 ],
    [ u"br",u"Flores da Cunha",20522,-29.0287,-51.1822 ],
    [ u"br",u"Flores",11694,-7.85,-37.983333 ],
    [ u"br",u"Floresta",18100,-8.6,-38.566667 ],
    [ u"br",u"Florestópolis",13250,-22.866667,-51.4 ],
    [ u"br",u"Floriano",48588,-6.783333,-43.016667 ],
    [ u"br",u"Florianópolis",412731,-27.583333,-48.566667 ],
    [ u"br",u"Fonte Boa",16060,-2.533333,-66.016667 ],
    [ u"br",u"Formiga",56405,-20.45,-45.416667 ],
    [ u"br",u"Formosa do Rio Prêto",14365,-11.046389,-45.059722 ],
    [ u"br",u"Formosa",81233,-15.533333,-47.333333 ],
    [ u"br",u"Formoso do Araguaia",14963,-11.796667,-49.466944 ],
    [ u"br",u"Forquilhinha",23021,-28.75,-49.466667 ],
    [ u"br",u"Fortaleza",2416920,-3.316667,-41.416667 ],
    [ u"br",u"Fortuna",9755,-5.683333,-44.066667 ],
    [ u"br",u"Foz do Iguaçu",293526,-25.55,-54.583333 ],
    [ u"br",u"Franca",305047,-20.533333,-47.4 ],
    [ u"br",u"Francisco Beltrão",57618,-26.083333,-53.066667 ],
    [ u"br",u"Francisco Morato",171793,-23.279503,-46.746403 ],
    [ u"br",u"Francisco Sá",13997,-16.466667,-43.5 ],
    [ u"br",u"Franco da Rocha",108860,-23.324821,-46.718475 ],
    [ u"br",u"Frederico Westphalen",20896,-27.366667,-53.4 ],
    [ u"br",u"Frei Paulo",7047,-10.55,-37.533333 ],
    [ u"br",u"Frutal",40931,-20.033333,-48.916667 ],
    [ u"br",u"Fundão",12715,-19.916667,-40.4 ],
    [ u"br",u"Gameleira",19424,-8.583333,-35.4 ],
    [ u"br",u"Gandu",21566,-13.75,-39.5 ],
    [ u"br",u"Garanhuns",110087,-8.9,-36.483333 ],
    [ u"br",u"Gararu",2977,-9.966667,-37.083333 ],
    [ u"br",u"Garça",41303,-22.233333,-49.616667 ],
    [ u"br",u"Garibaldi",30364,-29.25,-51.533333 ],
    [ u"br",u"Gaspar",33659,-26.933333,-48.966667 ],
    [ u"br",u"General Salgado",8084,-20.65,-50.366667 ],
    [ u"br",u"Getúlio Vargas",13695,-27.833333,-52.266667 ],
    [ u"br",u"Gilbués",4920,-9.838889,-45.353889 ],
    [ u"br",u"Girau do Ponciano",9606,-9.916667,-36.833333 ],
    [ u"br",u"Giruá",12170,-28.033333,-54.35 ],
    [ u"br",u"Glória do Goitá",17374,-8.016667,-35.283333 ],
    [ u"br",u"Goiana",43981,-7.55,-34.983333 ],
    [ u"br",u"Goianápolis",10114,-16.5,-49.016667 ],
    [ u"br",u"Goianésia",47884,-15.3,-49.116667 ],
    [ u"br",u"Goiânia",1171209,-16.666667,-49.266667 ],
    [ u"br",u"Goianinha",13434,-6.266667,-35.2 ],
    [ u"br",u"Goianira",22823,-16.5,-49.433333 ],
    [ u"br",u"Goiás",19098,-15.933333,-50.133333 ],
    [ u"br",u"Goiatuba",25925,-18.016667,-49.366667 ],
    [ u"br",u"Governador Dix-Sept Rosado",6626,-5.466667,-37.516667 ],
    [ u"br",u"Governador Valadares",250882,-18.85,-41.933333 ],
    [ u"br",u"Grajaú",30218,-5.816667,-46.133333 ],
    [ u"br",u"Gramado",26365,-29.4,-50.9 ],
    [ u"br",u"Granja",25880,-3.1,-40.833333 ],
    [ u"br",u"Grão Mogol",3278,-16.566667,-42.9 ],
    [ u"br",u"Gravatá",61250,-8.2,-35.566667 ],
    [ u"br",u"Gravataí",238782,-29.9426,-50.9933 ],
    [ u"br",u"Guaçuí",19787,-20.766667,-41.683333 ],
    [ u"br",u"Guaíba",101026,-30.111111,-51.316667 ],
    [ u"br",u"Guaíra",27611,-24.066667,-54.25 ],
    [ u"br",u"Guaíra",34093,-20.316667,-48.3 ],
    [ u"br",u"Guaiuba",21822,-4.033333,-38.633333 ],
    [ u"br",u"Guajará",9776,-2.966667,-57.666667 ],
    [ u"br",u"Guajará-Mirim",34123,-10.8,-65.366667 ],
    [ u"br",u"Guanambi",58879,-14.216667,-42.783333 ],
    [ u"br",u"Guanhães",23728,-18.783333,-42.95 ],
    [ u"br",u"Guapiaçu",14065,-20.833333,-49.216667 ],
    [ u"br",u"Guapimirim",31202,-22.533333,-42.983333 ],
    [ u"br",u"Guapó",10075,-16.816667,-49.533333 ],
    [ u"br",u"Guaporé",20050,-28.85,-51.9 ],
    [ u"br",u"Guarabira",43750,-6.85,-35.483333 ],
    [ u"br",u"Guaraciaba do Norte",18186,-4.166667,-40.766667 ],
    [ u"br",u"Guará",18263,-20.433333,-47.833333 ],
    [ u"br",u"Guaramirim",21422,-26.45,-49 ],
    [ u"br",u"Guaranésia",17437,-21.3,-46.8 ],
    [ u"br",u"Guaraniaçu",7781,-25.1,-52.866667 ],
    [ u"br",u"Guarapari",100927,-20.666667,-40.5 ],
    [ u"br",u"Guarapuava",150851,-25.383333,-51.45 ],
    [ u"br",u"Guararapes",27558,-21.25,-50.633333 ],
    [ u"br",u"Guararema",23572,-23.4132,-46.0377 ],
    [ u"br",u"Guaratinga",9519,-16.566667,-39.566667 ],
    [ u"br",u"Guaratinguetá",105882,-22.815156,-45.18923 ],
    [ u"br",u"Guaratuba",18906,-25.8804,-48.571 ],
    [ u"br",u"Guariba",30464,-21.35,-48.233333 ],
    [ u"br",u"Guarujá",310430,-24,-46.266667 ],
    [ u"br",u"Guarulhos",1169601,-23.45068,-46.526175 ],
    [ u"br",u"Guaxupé",47890,-21.3,-46.7 ],
    [ u"br",u"Guia Lopes da Laguna",9681,-21.433333,-56.116667 ],
    [ u"br",u"Guiratinga",10938,-16.35,-53.75 ],
    [ u"br",u"Gurinhém",5618,-7.133333,-35.45 ],
    [ u"br",u"Gurupá",6461,-1.416667,-51.65 ],
    [ u"br",u"Gurupi",64790,-11.7225,-49.012222 ],
    [ u"br",u"Hidrolândia",10299,-4.416667,-40.416667 ],
    [ u"br",u"Hidrolândia",7082,-16.966667,-49.233333 ],
    [ u"br",u"Horizonte",51181,-4.083333,-38.483333 ],
    [ u"br",u"Horizontina",14416,-27.616667,-54.316667 ],
    [ u"br",u"Hortolândia",203537,-22.85,-47.25 ],
    [ u"br",u"Humaitá",31207,-7.516389,-63.022222 ],
    [ u"br",u"Humberto de Campos",5208,-2.616667,-43.45 ],
    [ u"br",u"Iaciara",9207,-14.15,-46.666667 ],
    [ u"br",u"Iaçu",22665,-12.75,-40.216667 ],
    [ u"br",u"Ibaiti",25797,-23.8469,-50.1886 ],
    [ u"br",u"Ibateguara",8755,-8.983333,-35.866667 ],
    [ u"br",u"Ibaté",29550,-21.95,-48 ],
    [ u"br",u"Ibatiba",12265,-20.233333,-41.516667 ],
    [ u"br",u"Ibiá",18428,-19.483333,-46.533333 ],
    [ u"br",u"Ibiapina",9205,-3.916667,-40.9 ],
    [ u"br",u"Ibicaraí",19575,-14.85,-39.6 ],
    [ u"br",u"Ibicuí",10640,-14.85,-39.983333 ],
    [ u"br",u"Ibimirim",12272,-8.533333,-37.7 ],
    [ u"br",u"Ibipeba",14444,-11.633333,-42.033333 ],
    [ u"br",u"Ibiporã",44791,-23.283333,-51.05 ],
    [ u"br",u"Ibiraçu",8921,-19.833333,-40.366667 ],
    [ u"br",u"Ibirama",18360,-27.0546,-49.516 ],
    [ u"br",u"Ibirapitanga",7302,-14.15,-39.366667 ],
    [ u"br",u"Ibirataia",19943,-14.066667,-39.633333 ],
    [ u"br",u"Ibirité",141376,-20.033333,-44.066667 ],
    [ u"br",u"Ibirubá",14180,-28.633333,-53.1 ],
    [ u"br",u"Ibitinga",49075,-21.75,-48.816667 ],
    [ u"br",u"Ibiúna",22860,-23.654522,-47.218152 ],
    [ u"br",u"Ibotirama",17354,-12.183333,-43.216667 ],
    [ u"br",u"Içara",51455,-28.7,-49.3 ],
    [ u"br",u"Icatu",3648,-2.766667,-44.066667 ],
    [ u"br",u"Icó",28323,-6.4,-38.85 ],
    [ u"br",u"Iconha",5051,-20.8,-40.8 ],
    [ u"br",u"Igaci",6480,-9.55,-36.633333 ],
    [ u"br",u"Igaraçu do Tietê",22758,-22.516667,-48.566667 ],
    [ u"br",u"Igarapava",29058,-20.05,-47.783333 ],
    [ u"br",u"Igarapé-Açu",24136,-1.116667,-47.616667 ],
    [ u"br",u"Igarapé",21427,-20.066667,-44.3 ],
    [ u"br",u"Igarapé-Miri",26838,-1.983333,-48.966667 ],
    [ u"br",u"Igarassu",86458,-7.833333,-34.9 ],
    [ u"br",u"Igreja Nova",4606,-10.116667,-36.65 ],
    [ u"br",u"Igrejinha",28680,-29.566667,-50.8 ],
    [ u"br",u"Iguaba Grande",11104,-22.833333,-42.216667 ],
    [ u"br",u"Iguaí",14218,-14.75,-40.066667 ],
    [ u"br",u"Iguape",23785,-24.716667,-47.55 ],
    [ u"br",u"Iguatemi",9619,-23.666667,-54.566667 ],
    [ u"br",u"Iguatu",70381,-6.366667,-39.3 ],
    [ u"br",u"Ijuí",71203,-28.383333,-53.916667 ],
    [ u"br",u"Ilhabela",32903,-23.783333,-45.35 ],
    [ u"br",u"Ilhéus",155503,-14.816667,-39.033333 ],
    [ u"br",u"Imaculada",4014,-7.366667,-37.5 ],
    [ u"br",u"Imbituba",43450,-28.233333,-48.666667 ],
    [ u"br",u"Imbituva",19671,-25.2,-50.583333 ],
    [ u"br",u"Imperatriz",218110,-5.533333,-47.483333 ],
    [ u"br",u"Indaial",44360,-26.8922,-49.2239 ],
    [ u"br",u"Indaiatuba",179914,-23.083333,-47.233333 ],
    [ u"br",u"Independência",11113,-5.383333,-40.316667 ],
    [ u"br",u"Indiaroba",4989,-11.533333,-37.516667 ],
    [ u"br",u"Ingá",8751,-7.283333,-35.6 ],
    [ u"br",u"Inhambupe",14735,-11.783333,-38.35 ],
    [ u"br",u"Inhapi",7550,-9.233333,-37.75 ],
    [ u"br",u"Inhapim",13594,-19.55,-42.116667 ],
    [ u"br",u"Inhuma",7056,-6.666667,-41.7 ],
    [ u"br",u"Inhumas",44058,-16.366667,-49.5 ],
    [ u"br",u"Ipaba",15971,-19.383333,-42.416667 ],
    [ u"br",u"Ipameri",18607,-17.716667,-48.15 ],
    [ u"br",u"Ipanema",11705,-19.783333,-41.733333 ],
    [ u"br",u"Ipanguaçu",4624,-5.497778,-36.853333 ],
    [ u"br",u"Ipatinga",228750,-19.5,-42.533333 ],
    [ u"br",u"Ipaussú",10833,-23.05,-49.616667 ],
    [ u"br",u"Iperó",17161,-23.35,-47.683333 ],
    [ u"br",u"Ipiaú",38763,-14.133333,-39.733333 ],
    [ u"br",u"Ipirá",27218,-12.166667,-39.733333 ],
    [ u"br",u"Ipixuna",5814,-7.051667,-71.693056 ],
    [ u"br",u"Ipojuca",53365,-8.4,-35.066667 ],
    [ u"br",u"Iporã",10353,-23.983333,-53.616667 ],
    [ u"br",u"Iporá",28254,-16.466667,-51.116667 ],
    [ u"br",u"Ipuã",12370,-20.45,-48.033333 ],
    [ u"br",u"Ipubi",16424,-7.65,-40.116667 ],
    [ u"br",u"Ipueiras",17111,-7.033333,-40.45 ],
    [ u"br",u"Ipu",26679,-4.333333,-40.7 ],
    [ u"br",u"Iracemápolis",16796,-22.583333,-47.533333 ],
    [ u"br",u"Iranduba",11181,-3.25,-60.1 ],
    [ u"br",u"Iraquara",5131,-12.25,-41.6 ],
    [ u"br",u"Irará",9099,-12.033333,-38.766667 ],
    [ u"br",u"Irati",45831,-25.4735,-50.6524 ],
    [ u"br",u"Irauçuba",13282,-3.75,-39.783333 ],
    [ u"br",u"Irecê",63628,-11.3,-41.866667 ],
    [ u"br",u"Irituia",5602,-1.766667,-47.433333 ],
    [ u"br",u"Irupi",3505,-20.35,-41.633333 ],
    [ u"br",u"Itabaiana",19101,-7.333333,-35.333333 ],
    [ u"br",u"Itabaiana",63889,-10.683333,-37.433333 ],
    [ u"br",u"Itabaianinha",17149,-11.266667,-37.783333 ],
    [ u"br",u"Itaberaba",47303,-12.533333,-40.3 ],
    [ u"br",u"Itaberaí",22130,-16.033333,-49.8 ],
    [ u"br",u"Itaberá",11098,-23.85,-49.15 ],
    [ u"br",u"Itabira",99498,-19.616667,-43.216667 ],
    [ u"br",u"Itabirito",39453,-20.2484,-43.8063 ],
    [ u"br",u"Itaboraí",182500,-22.75,-42.866667 ],
    [ u"br",u"Itabuna",205666,-14.8,-39.266667 ],
    [ u"br",u"Itacarambi",13084,-15.016667,-44.05 ],
    [ u"br",u"Itacaré",12490,-14.3,-39 ],
    [ u"br",u"Itacoatiara",45995,-3.05,-58.433333 ],
    [ u"br",u"Itagibá",9843,-14.283333,-39.85 ],
    [ u"br",u"Itagi",10534,-14.166667,-40.016667 ],
    [ u"br",u"Itaguaçu",8202,-19.8,-40.85 ],
    [ u"br",u"Itaguaí",100756,-22.870755,-43.773821 ],
    [ u"br",u"Itaíba",13870,-8.95,-37.416667 ],
    [ u"br",u"Itaí",22305,-23.4,-49.1 ],
    [ u"br",u"Itainópolis",2922,-7.4,-41.516667 ],
    [ u"br",u"Itaitinga",30939,-3.966667,-38.516667 ],
    [ u"br",u"Itaituba",64758,-4.216667,-56.016667 ],
    [ u"br",u"Itajaí",155719,-26.883333,-48.65 ],
    [ u"br",u"Itajobi",12231,-21.316667,-49.066667 ],
    [ u"br",u"Itajubá",81871,-22.433333,-45.45 ],
    [ u"br",u"Itajuípe",15517,-14.683333,-39.366667 ],
    [ u"br",u"Itamaracá",14969,-7.75,-34.833333 ],
    [ u"br",u"Itamaraju",47630,-17.066667,-39.533333 ],
    [ u"br",u"Itamarandiba",18064,-17.85,-42.85 ],
    [ u"br",u"Itambacuri",14652,-18.016667,-41.7 ],
    [ u"br",u"Itambé",23559,-15.25,-40.616667 ],
    [ u"br",u"Itanhaém",90387,-24.183333,-46.783333 ],
    [ u"br",u"Itanhandu",11274,-22.3,-44.95 ],
    [ u"br",u"Itanhém",13517,-17.15,-40.333333 ],
    [ u"br",u"Itaobim",15938,-16.566667,-41.833333 ],
    [ u"br",u"Itaocara",16763,-21.683333,-42.066667 ],
    [ u"br",u"Itapaci",16118,-14.95,-49.566667 ],
    [ u"br",u"Itapagé",32043,-3.683333,-39.566667 ],
    [ u"br",u"Itaparica",20101,-12.9,-38.7 ],
    [ u"br",u"Itapecerica da Serra",151608,-23.716667,-46.833333 ],
    [ u"br",u"Itapecerica",16684,-20.466667,-45.116667 ],
    [ u"br",u"Itapema",36766,-27.099167,-48.615 ],
    [ u"br",u"Itapemirim",17536,-21.016667,-40.833333 ],
    [ u"br",u"Itaperuçu",26552,-25.2,-49.366667 ],
    [ u"br",u"Itaperuna",84436,-21.2,-41.9 ],
    [ u"br",u"Itapetinga",59723,-15.25,-40.25 ],
    [ u"br",u"Itapetininga",126245,-23.6,-48.05 ],
    [ u"br",u"Itapeva",62958,-23.966667,-48.866667 ],
    [ u"br",u"Itapevi",201752,-23.55,-46.933333 ],
    [ u"br",u"Itapicuru",4994,-11.316667,-38.25 ],
    [ u"br",u"Itapipoca",55785,-3.5,-39.583333 ],
    [ u"br",u"Itapira",61608,-22.433333,-46.833333 ],
    [ u"br",u"Itapirapuã",7923,-15.866667,-50.6 ],
    [ u"br",u"Itapissuma",16674,-7.766667,-34.9 ],
    [ u"br",u"Itápolis",34553,-21.583333,-48.766667 ],
    [ u"br",u"Itaporã",12327,-22.016667,-54.9 ],
    [ u"br",u"Itaporanga",15890,-7.3,-38.166667 ],
    [ u"br",u"Itaporanga",10202,-23.7,-49.483333 ],
    [ u"br",u"Itapuí",10445,-22.233333,-48.683333 ],
    [ u"br",u"Itapuranga",19709,-15.583333,-49.983333 ],
    [ u"br",u"Itaquaquecetuba",336686,-23.483333,-46.35 ],
    [ u"br",u"Itaqui",34631,-29.133333,-56.55 ],
    [ u"br",u"Itaquitinga",11128,-7.666667,-35.1 ],
    [ u"br",u"Itarana",4060,-19.85,-40.866667 ],
    [ u"br",u"Itarantim",12370,-15.65,-40.05 ],
    [ u"br",u"Itararé",44810,-24.116667,-49.333333 ],
    [ u"br",u"Itarema",10330,-2.9,-39.966667 ],
    [ u"br",u"Itatiaia",12571,-22.5,-44.566667 ],
    [ u"br",u"Itatiba",67935,-23,-46.85 ],
    [ u"br",u"Itatinga",15696,-23.116667,-48.6 ],
    [ u"br",u"Itatuba",4951,-7.383333,-35.65 ],
    [ u"br",u"Itaú de Minas",14888,-20.716667,-46.75 ],
    [ u"br",u"Itaueira",5146,-7.6,-43.033333 ],
    [ u"br",u"Itaúna",77402,-20.066667,-44.566667 ],
    [ u"br",u"Itinga",4917,-16.6,-41.783333 ],
    [ u"br",u"Itirapina",13229,-22.25,-47.816667 ],
    [ u"br",u"Itiruçu",11499,-13.516667,-40.15 ],
    [ u"br",u"Itiúba",9410,-10.716667,-39.85 ],
    [ u"br",u"Itororó",17325,-15.116667,-40.1 ],
    [ u"br",u"Ituaçu",4891,-13.816667,-41.3 ],
    [ u"br",u"Ituberá",19888,-13.733333,-39.15 ],
    [ u"br",u"Itu",137589,-23.266667,-47.316667 ],
    [ u"br",u"Ituiutaba",85346,-18.966667,-49.466667 ],
    [ u"br",u"Itumbiara",79583,-18.416667,-49.216667 ],
    [ u"br",u"Itupeva",25183,-17.416667,-40.483333 ],
    [ u"br",u"Itupiranga",21301,-5.15,-49.333333 ],
    [ u"br",u"Ituporanga",13038,-27.416667,-49.6 ],
    [ u"br",u"Iturama",29805,-19.733333,-50.183333 ],
    [ u"br",u"Ituverava",36998,-20.333333,-47.783333 ],
    [ u"br",u"Iúna",14290,-20.35,-41.533333 ],
    [ u"br",u"Ivaiporã",23316,-24.25,-51.75 ],
    [ u"br",u"Ivoti",18172,-29.6,-51.166667 ],
    [ u"br",u"Jaboatão",702632,-8.116667,-35.016667 ],
    [ u"br",u"Jaboticabal",69396,-21.266667,-48.316667 ],
    [ u"br",u"Jacaraú",7035,-6.666667,-35.3 ],
    [ u"br",u"Jacareacanga",1402,-6.266667,-57.65 ],
    [ u"br",u"Jacareí",213114,-23.316667,-45.966667 ],
    [ u"br",u"Jacarezinho",35090,-23.171382,-49.991453 ],
    [ u"br",u"Jaciara",22739,-15.983333,-54.95 ],
    [ u"br",u"Jacobina",47639,-11.183333,-40.516667 ],
    [ u"br",u"Jacupiranga",11149,-24.700034,-48.004445 ],
    [ u"br",u"Jacutinga",18470,-22.283333,-46.616667 ],
    [ u"br",u"Jaguaquara",41499,-13.533333,-39.966667 ],
    [ u"br",u"Jaguarão",29613,-32.566667,-53.383333 ],
    [ u"br",u"Jaguarari",22617,-10.266667,-40.2 ],
    [ u"br",u"Jaguariaíva",30627,-24.25,-49.7 ],
    [ u"br",u"Jaguaribe",23066,-5.883333,-38.616667 ],
    [ u"br",u"Jaguariúna",31718,-22.683333,-46.983333 ],
    [ u"br",u"Jaguaruana",21791,-4.833333,-37.783333 ],
    [ u"br",u"Jaguaruna",11650,-28.6,-49.033333 ],
    [ u"br",u"Jaicós",7107,-7.35,-41.133333 ],
    [ u"br",u"Jales",43832,-20.266667,-50.55 ],
    [ u"br",u"Janaúba",56573,-15.8,-43.316667 ],
    [ u"br",u"Jandaia do Sul",17507,-23.6,-51.65 ],
    [ u"br",u"Jandira",113607,-23.516667,-46.9 ],
    [ u"br",u"Januária",34812,-15.483333,-44.366667 ],
    [ u"br",u"Japaratuba",8092,-10.583333,-36.95 ],
    [ u"br",u"Japeri",95102,-22.648889,-43.658611 ],
    [ u"br",u"Japoatã",4207,-10.333333,-36.8 ],
    [ u"br",u"Japurá",1908,-1.395833,-69.422222 ],
    [ u"br",u"Jaraguá do Sul",130132,-26.483333,-49.066667 ],
    [ u"br",u"Jaraguá",30410,-15.75,-49.333333 ],
    [ u"br",u"Jardim de Piranhas",10935,-6.366667,-37.333333 ],
    [ u"br",u"Jardim do Seridó",9520,-6.583333,-36.766667 ],
    [ u"br",u"Jardim",7189,-3.433333,-39.016667 ],
    [ u"br",u"Jardim",23781,-21.466667,-56.15 ],
    [ u"br",u"Jardinópolis",34719,-21.033333,-47.766667 ],
    [ u"br",u"Jarinu",17905,-23.103333,-46.728056 ],
    [ u"br",u"Jaru",28018,-10.433333,-62.45 ],
    [ u"br",u"Jataí",76548,-17.883333,-51.716667 ],
    [ u"br",u"Jataìzinho",10014,-23.216667,-50.966667 ],
    [ u"br",u"Jaú",119209,-22.3,-48.55 ],
    [ u"br",u"Jequié",127479,-13.85,-40.083333 ],
    [ u"br",u"Jequitinhonha",15463,-16.433333,-41 ],
    [ u"br",u"Jeremoabo",16642,-10.066667,-38.35 ],
    [ u"br",u"Jerônimo Monteiro",6902,-20.783333,-41.4 ],
    [ u"br",u"Ji-Paraná",100128,-10.833333,-61.966667 ],
    [ u"br",u"Jitaúna",11619,-14.016667,-39.95 ],
    [ u"br",u"Joaçaba",23516,-27.166667,-51.5 ],
    [ u"br",u"Joaíma",9022,-16.65,-41.033333 ],
    [ u"br",u"Joanópolis",11772,-22.933333,-46.283333 ],
    [ u"br",u"João Alfredo",11334,-7.866667,-35.583333 ],
    [ u"br",u"João Câmara",19886,-5.533333,-35.8 ],
    [ u"br",u"João Monlevade",72763,-19.833333,-43.133333 ],
    [ u"br",u"João Neiva",10383,-19.75,-40.4 ],
    [ u"br",u"João Pessoa",650896,-7.116667,-34.866667 ],
    [ u"br",u"João Pinheiro",28083,-17.75,-46.166667 ],
    [ u"br",u"Joaquim Gomes",14808,-9.2,-35.716667 ],
    [ u"br",u"Joaquim Nabuco",9965,-8.616667,-35.533333 ],
    [ u"br",u"Joinville",461312,-26.3,-48.833333 ],
    [ u"br",u"José Bonifácio",27828,-21.05,-49.683333 ],
    [ u"br",u"José de Freitas",21433,-4.75,-42.583333 ],
    [ u"br",u"Juatuba",24551,-19.95,-44.333333 ],
    [ u"br",u"Juàzeirinho",8846,-6.816667,-38.05 ],
    [ u"br",u"Juazeiro do Norte",225234,-7.2,-39.333333 ],
    [ u"br",u"Juàzeiro",137807,-9.5,-40.5 ],
    [ u"br",u"Jucás",14822,-6.533333,-39.533333 ],
    [ u"br",u"Jucurutu",11535,-6.033333,-37.016667 ],
    [ u"br",u"Juiz de Fora",470201,-21.751667,-43.352778 ],
    [ u"br",u"Júlio de Castilhos",16487,-29.233333,-53.683333 ],
    [ u"br",u"Jundiaí",321595,-23.183333,-46.866667 ],
    [ u"br",u"Jundiá",2267,-8.933333,-35.566667 ],
    [ u"br",u"Junqueiro",7740,-9.933333,-36.483333 ],
    [ u"br",u"Junqueirópolis",13965,-21.533333,-51.433333 ],
    [ u"br",u"Juquiá",13497,-24.316667,-47.633333 ],
    [ u"br",u"Juquitiba",13961,-23.927482,-47.069543 ],
    [ u"br",u"Juripiranga",8320,-7.366667,-35.233333 ],
    [ u"br",u"Juru",3796,-7.533333,-37.816667 ],
    [ u"br",u"Juruti",13333,-2.166667,-56.066667 ],
    [ u"br",u"Jussara",16374,-23.6,-52.466667 ],
    [ u"br",u"Jutaí",5863,-5.183333,-68.9 ],
    [ u"br",u"Lábrea",19624,-7.266667,-64.783333 ],
    [ u"br",u"Ladário",15790,-19.016667,-57.583333 ],
    [ u"br",u"Lagarto",45446,-10.9,-37.683333 ],
    [ u"br",u"Lages",164679,-27.8,-50.316667 ],
    [ u"br",u"Lagoa da Canoa",13428,-9.816667,-36.766667 ],
    [ u"br",u"Lagoa da Prata",43119,-20.016667,-45.55 ],
    [ u"br",u"Lagoa do Itaenga",17719,-7.916667,-35.333333 ],
    [ u"br",u"Lagoa Formosa",11822,-18.783333,-46.4 ],
    [ u"br",u"Lagoa Nova",5984,-6.1,-36.483333 ],
    [ u"br",u"Lagoa Santa",38487,-19.633333,-43.883333 ],
    [ u"br",u"Lagoa Sêca",8103,-7.15,-35.85 ],
    [ u"br",u"Lagoa Vermelha",24446,-28.216667,-51.533333 ],
    [ u"br",u"Lago da Pedra",25996,-4.333333,-45.166667 ],
    [ u"br",u"Laguna",39712,-28.483333,-48.783333 ],
    [ u"br",u"Lajeado",65408,-29.45,-51.966667 ],
    [ u"br",u"Lajedo",25262,-8.383333,-36.55 ],
    [ u"br",u"Laje",4708,-10.183333,-40.966667 ],
    [ u"br",u"Lambari",14516,-21.966667,-45.35 ],
    [ u"br",u"Lapa",25621,-25.765833,-49.717778 ],
    [ u"br",u"Lapão",11253,-11.4,-41.833333 ],
    [ u"br",u"Laranja da Terra",3016,-19.9,-41.066667 ],
    [ u"br",u"Laranjal Paulista",21264,-23.048726,-47.835968 ],
    [ u"br",u"Laranjeiras do Sul",18425,-25.416667,-52.416667 ],
    [ u"br",u"Laranjeiras",23251,-10.8,-37.166667 ],
    [ u"br",u"Lauro Müller",10036,-28.4,-49.383333 ],
    [ u"br",u"Lavras da Mangabeira",17221,-6.75,-38.95 ],
    [ u"br",u"Lavras",81474,-21.233333,-45 ],
    [ u"br",u"Leme",81211,-22.2,-47.4 ],
    [ u"br",u"Lençóis Paulista",57376,-22.6,-48.783333 ],
    [ u"br",u"Leopoldina",46743,-21.533333,-42.633333 ],
    [ u"br",u"Lima Duarte",13480,-21.85,-43.8 ],
    [ u"br",u"Limeira",289671,-22.561667,-47.402778 ],
    [ u"br",u"Limoeiro de Anadia",2770,-9.733333,-36.516667 ],
    [ u"br",u"Limoeiro do Ajuru",4109,-1.916667,-49.383333 ],
    [ u"br",u"Limoeiro do Norte",29450,-5.133333,-38.083333 ],
    [ u"br",u"Limoeiro",42329,-7.866667,-35.45 ],
    [ u"br",u"Linhares",105084,-19.416667,-40.066667 ],
    [ u"br",u"Lins",69452,-21.666667,-49.75 ],
    [ u"br",u"Livramento",19914,-13.65,-41.833333 ],
    [ u"br",u"Loanda",18233,-22.9,-53.166667 ],
    [ u"br",u"Londrina",471836,-23.3,-51.15 ],
    [ u"br",u"Lorena",76507,-22.733333,-45.133333 ],
    [ u"br",u"Louveira",31098,-23.066667,-46.966667 ],
    [ u"br",u"Lucélia",14807,-21.733333,-51.016667 ],
    [ u"br",u"Luís Correia",11480,-2.883611,-41.666111 ],
    [ u"br",u"Luziânia",143601,-16.25,-47.933333 ],
    [ u"br",u"Luzilândia",12999,-3.466667,-42.366667 ],
    [ u"br",u"Luz",14396,-19.8,-45.666667 ],
    [ u"br",u"Macaé",143031,-22.383333,-41.783333 ],
    [ u"br",u"Macaíba",40016,-5.716667,-35.55 ],
    [ u"br",u"Macapá",338937,.033333,-51.05 ],
    [ u"br",u"Macaparana",14363,-7.566667,-35.45 ],
    [ u"br",u"Macatuba",16180,-22.516667,-48.683333 ],
    [ u"br",u"Macaúbas",14598,-13.033333,-42.7 ],
    [ u"br",u"Macau",18070,-5.116667,-36.633333 ],
    [ u"br",u"Maceió",955010,-9.666667,-35.716667 ],
    [ u"br",u"Machado",33003,-21.683333,-45.933333 ],
    [ u"br",u"Madre de Deus",14887,-12.733333,-38.616667 ],
    [ u"br",u"Mafra",40081,-26.1181,-49.8023 ],
    [ u"br",u"Magé",216342,-22.655556,-43.015278 ],
    [ u"br",u"Mairi",13475,-11.716667,-40.133333 ],
    [ u"br",u"Mairinque",44457,-23.544368,-47.183467 ],
    [ u"br",u"Mairiporã",54417,-23.322628,-46.586935 ],
    [ u"br",u"Major Isidoro",8507,-9.533333,-37 ],
    [ u"br",u"Malacacheta",8820,-17.833333,-42.083333 ],
    [ u"br",u"Malhador",5574,-10.65,-37.3 ],
    [ u"br",u"Mamanguape",27607,-6.833333,-35.116667 ],
    [ u"br",u"Manacapuru",52460,-3.3,-60.616667 ],
    [ u"br",u"Manaíra",4913,-7.7,-38.166667 ],
    [ u"br",u"Manaquiri",9986,-3.316667,-60.35 ],
    [ u"br",u"Manaus",1598227,-3.113333,-60.025278 ],
    [ u"br",u"Mâncio Lima",7086,-7.616667,-72.9 ],
    [ u"br",u"Mandaguaçu",14866,-23.333333,-52.083333 ],
    [ u"br",u"Mandaguari",38239,-23.533333,-51.7 ],
    [ u"br",u"Manga",11733,-14.766667,-43.933333 ],
    [ u"br",u"Mangaratiba",27023,-22.9609,-44.0402 ],
    [ u"br",u"Manhuaçu",54608,-20.25,-42.033333 ],
    [ u"br",u"Manhumirim",15544,-20.366667,-41.95 ],
    [ u"br",u"Manicoré",14058,-5.812222,-61.2975 ],
    [ u"br",u"Manoel Urbano",4066,-8.883333,-69.3 ],
    [ u"br",u"Mantena",18715,-18.783333,-40.983333 ],
    [ u"br",u"Mantenópolis",8547,-18.883333,-41.1 ],
    [ u"br",u"Maraã",4387,-1.833333,-65.366667 ],
    [ u"br",u"Marabá",145865,-5.35,-49.116667 ],
    [ u"br",u"Maracaçumé",14164,-2.05,-45.933333 ],
    [ u"br",u"Maracaí",11960,-22.6,-50.65 ],
    [ u"br",u"Maracaju",22690,-21.633333,-55.15 ],
    [ u"br",u"Maracanã",12683,-.766667,-47.45 ],
    [ u"br",u"Maracanaú",193532,-3.866667,-38.633333 ],
    [ u"br",u"Maracás",22050,-13.433333,-40.45 ],
    [ u"br",u"Maragogi",16066,-9.016667,-35.216667 ],
    [ u"br",u"Maragogipe",20921,-12.766667,-38.916667 ],
    [ u"br",u"Maraial",14204,-8.783333,-35.833333 ],
    [ u"br",u"Marapanim",10236,-.7,-47.7 ],
    [ u"br",u"Marataízes",25397,-21.033333,-40.833333 ],
    [ u"br",u"Maraú",2956,-14.1,-39 ],
    [ u"br",u"Marau",26860,-28.45,-52.2 ],
    [ u"br",u"Maravilha",13865,-26.783333,-53.15 ],
    [ u"br",u"Marco",14502,-3.133333,-40.15 ],
    [ u"br",u"Mar de Espanha",9678,-21.865833,-43.009722 ],
    [ u"br",u"Marechal Cândido Rondon",43028,-24.566667,-54.066667 ],
    [ u"br",u"Marechal Deodoro",50579,-9.716667,-35.9 ],
    [ u"br",u"Marechal Floriano",5869,-20.416667,-40.666667 ],
    [ u"br",u"Marialva",26001,-23.466667,-51.7 ],
    [ u"br",u"Mariana",45237,-20.383333,-43.416667 ],
    [ u"br",u"Maribondo",10475,-9.583333,-36.233333 ],
    [ u"br",u"Maricá",79552,-22.916667,-42.816667 ],
    [ u"br",u"Marilândia",3900,-19.416667,-40.516667 ],
    [ u"br",u"Marília",212222,-22.216667,-49.933333 ],
    [ u"br",u"Mari",17535,-7.083333,-35.333333 ],
    [ u"br",u"Maringá",311727,-23.416667,-51.916667 ],
    [ u"br",u"Martinho Campos",9198,-19.333333,-45.216667 ],
    [ u"br",u"Martinópolis",18488,-22.183333,-51.2 ],
    [ u"br",u"Maruim",12153,-10.75,-37.083333 ],
    [ u"br",u"Mascote",18899,-15.55,-39.283333 ],
    [ u"br",u"Massapê",22193,-3.516667,-40.316667 ],
    [ u"br",u"Massaranduba",3153,-7.183333,-35.766667 ],
    [ u"br",u"Mata de São João",26680,-12.516667,-38.283333 ],
    [ u"br",u"Mata Grande",4654,-9.111667,-37.7 ],
    [ u"br",u"Matão",72469,-21.583333,-48.366667 ],
    [ u"br",u"Matelândia",10816,-25.2413,-53.983 ],
    [ u"br",u"Mateus Leme",24890,-19.983333,-44.416667 ],
    [ u"br",u"Matias Barbosa",12072,-21.869722,-43.318611 ],
    [ u"br",u"Matias Olímpio",4012,-3.716667,-42.55 ],
    [ u"br",u"Matinha",6851,-3.1,-45.033333 ],
    [ u"br",u"Matinhos",32008,-25.816667,-48.533333 ],
    [ u"br",u"Matipó",12997,-20.283333,-42.35 ],
    [ u"br",u"Mato Verde",7783,-15.383333,-42.866667 ],
    [ u"br",u"Matozinhos",30844,-19.583333,-44.116667 ],
    [ u"br",u"Matriz de Camaragibe",18705,-9.15,-35.516667 ],
    [ u"br",u"Mauá",386077,-23.666667,-46.45 ],
    [ u"br",u"Maués",22476,-3.4,-57.7 ],
    [ u"br",u"Mauriti",20064,-7.383333,-38.766667 ],
    [ u"br",u"Mazagão",6500,-.116667,-51.283333 ],
    [ u"br",u"Medeiros Neto",15255,-17.333333,-40.233333 ],
    [ u"br",u"Medianeira",34069,-25.283333,-54.083333 ],
    [ u"br",u"Medina",14686,-16.25,-41.483333 ],
    [ u"br",u"Mendes",17308,-22.526111,-43.724722 ],
    [ u"br",u"Messias",12376,-9.416667,-35.833333 ],
    [ u"br",u"Miguel Alves",10439,-4.166667,-42.9 ],
    [ u"br",u"Miguel Calmon",13748,-11.433333,-40.6 ],
    [ u"br",u"Miguelópolis",18262,-20.2,-48.05 ],
    [ u"br",u"Miguel Pereira",23850,-22.452778,-43.476389 ],
    [ u"br",u"Milagres",12588,-7.283333,-38.95 ],
    [ u"br",u"Mimoso do Sul",14045,-21.066667,-41.366667 ],
    [ u"br",u"Minador do Negrão",1986,-9.333333,-36.866667 ],
    [ u"br",u"Minas Novas",7365,-17.25,-42.6 ],
    [ u"br",u"Mineiros",38951,-17.566667,-52.566667 ],
    [ u"br",u"Mirabela",8934,-16.258056,-44.159167 ],
    [ u"br",u"Miracatu",11679,-24.283333,-47.466667 ],
    [ u"br",u"Miracema do Tocantins",29181,-9.529167,-48.319722 ],
    [ u"br",u"Miracema",26684,-21.416667,-42.183333 ],
    [ u"br",u"Mirador",6955,-6.366667,-44.366667 ],
    [ u"br",u"Miraí",8500,-21.2,-42.616667 ],
    [ u"br",u"Miranda",13189,-20.233333,-56.366667 ],
    [ u"br",u"Mirandópolis",23379,-21.15,-51.1 ],
    [ u"br",u"Miranorte",12446,-9.476667,-48.480278 ],
    [ u"br",u"Mirante do Paranapanema",9387,-22.283333,-51.9 ],
    [ u"br",u"Mirassol",51559,-20.766667,-49.466667 ],
    [ u"br",u"Missão Velha",13106,-7.25,-39.133333 ],
    [ u"br",u"Mocajuba",16567,-2.583333,-49.5 ],
    [ u"br",u"Mococa",59656,-21.466667,-47.016667 ],
    [ u"br",u"Mogeiro",4767,-7.3,-35.466667 ],
    [ u"br",u"Moita Bonita",3602,-10.583333,-37.366667 ],
    [ u"br",u"Moji das Cruzes",325753,-23.516667,-46.183333 ],
    [ u"br",u"Moji-Mirim",78245,-22.433333,-46.95 ],
    [ u"br",u"Moju",21511,-1.883333,-48.766667 ],
    [ u"br",u"Mombaça",17065,-5.75,-39.633333 ],
    [ u"br",u"Monção",11051,-3.5,-45.25 ],
    [ u"br",u"Mongaguá",45931,-24.1,-46.616667 ],
    [ u"br",u"Monsenhor Gil",4751,-5.583333,-42.616667 ],
    [ u"br",u"Montanha",11934,-18.133333,-40.35 ],
    [ u"br",u"Montanhas",8442,-6.483333,-35.3 ],
    [ u"br",u"Monte Alegre de Minas",12451,-18.866667,-48.866667 ],
    [ u"br",u"Monte Alegre de Sergipe",6816,-10.033333,-37.55 ],
    [ u"br",u"Monte Alegre",22841,-2.016667,-54.066667 ],
    [ u"br",u"Monte Alegre",6643,-5.889722,-36.301389 ],
    [ u"br",u"Monte Alto",41894,-21.283333,-48.483333 ],
    [ u"br",u"Monte Aprazível",16308,-20.75,-49.7 ],
    [ u"br",u"Monte Azul",11222,-15.15,-42.883333 ],
    [ u"br",u"Monte Azul Paulista",18117,-20.916667,-48.633333 ],
    [ u"br",u"Monte Carmelo",44041,-18.716667,-47.483333 ],
    [ u"br",u"Monteiro",17727,-7.883333,-37.116667 ],
    [ u"br",u"Monte Mor",40291,-22.95,-47.333333 ],
    [ u"br",u"Montenegro",54058,-29.7,-51.466667 ],
    [ u"br",u"Montes Altos",3518,-5.833333,-47.066667 ],
    [ u"br",u"Monte Santo de Minas",16617,-21.2,-46.983333 ],
    [ u"br",u"Monte Santo",7398,-10.433333,-39.333333 ],
    [ u"br",u"Montes Claros",332384,-16.716667,-43.866667 ],
    [ u"br",u"Monte Sião",11090,-22.433333,-46.566667 ],
    [ u"br",u"Morada Nova",37390,-5.116667,-38.383333 ],
    [ u"br",u"Moreira Sales",8699,-24.016667,-53.05 ],
    [ u"br",u"Moreno",45238,-8.116667,-35.1 ],
    [ u"br",u"Morrinhos",34144,-17.733333,-49.116667 ],
    [ u"br",u"Morro Agudo",25266,-20.733333,-48.066667 ],
    [ u"br",u"Morro da Fumaça",13952,-28.666667,-49.2 ],
    [ u"br",u"Morros",4829,-9.446667,-46.300278 ],
    [ u"br",u"Mossoró",202010,-5.191389,-37.344722 ],
    [ u"br",u"Mozarlândia",11252,-14.783333,-50.583333 ],
    [ u"br",u"Muaná",7464,-1.533333,-49.216667 ],
    [ u"br",u"Mucurici",9524,-18.1,-40.516667 ],
    [ u"br",u"Mucuri",26823,-18.083333,-39.566667 ],
    [ u"br",u"Mulungu",4181,-7.033333,-35.466667 ],
    [ u"br",u"Mundo Novo",11912,-11.866667,-40.466667 ],
    [ u"br",u"Muniz Freire",8312,-20.466667,-41.416667 ],
    [ u"br",u"Muqui",8614,-20.95,-41.3 ],
    [ u"br",u"Muriaé",91174,-21.133333,-42.366667 ],
    [ u"br",u"Murici",20420,-9.316667,-35.933333 ],
    [ u"br",u"Muritiba",22388,-12.916667,-39.25 ],
    [ u"br",u"Mutuípe",10016,-13.25,-39.516667 ],
    [ u"br",u"Mutum",12582,-19.816667,-41.433333 ],
    [ u"br",u"Muzambinho",16254,-21.366667,-46.533333 ],
    [ u"br",u"Nanuque",37825,-17.833333,-40.35 ],
    [ u"br",u"Não-Me-Toque",12556,-28.466667,-52.816667 ],
    [ u"br",u"Natal",763057,-5.783333,-35.216667 ],
    [ u"br",u"Natividade",12014,-21.05,-41.983333 ],
    [ u"br",u"Natuba",3333,-7.633333,-35.566667 ],
    [ u"br",u"Navegantes",47782,-26.9,-48.65 ],
    [ u"br",u"Naviraí",36453,-23.133333,-54.216667 ],
    [ u"br",u"Nazaré da Mata",26485,-7.733333,-35.233333 ],
    [ u"br",u"Nazaré",25604,-13.033333,-39 ],
    [ u"br",u"Neópolis",12422,-10.3,-36.583333 ],
    [ u"br",u"Nepomuceno",18911,-21.233333,-45.25 ],
    [ u"br",u"Nerópolis",21870,-16.416667,-49.233333 ],
    [ u"br",u"Nhamundá",7772,-2.233333,-56.716667 ],
    [ u"br",u"Nilópolis",147283,-22.808487,-43.419792 ],
    [ u"br",u"Nioaque",6899,-21.133333,-55.8 ],
    [ u"br",u"Niquelândia",27544,-14.45,-48.45 ],
    [ u"br",u"Nísia Floresta",10115,-6.066667,-35.133333 ],
    [ u"br",u"Niterói",456461,-22.90214,-43.130301 ],
    [ u"br",u"Nobres",12010,-14.733333,-56.333333 ],
    [ u"br",u"Nortelândia",9636,-14.416667,-56.8 ],
    [ u"br",u"Nossa Senhora da Glória",18613,-10.233333,-37.416667 ],
    [ u"br",u"Nossa Senhora das Dores",14550,-10.483333,-37.216667 ],
    [ u"br",u"Nossa Senhora do Socorro",163996,-10.866667,-37.116667 ],
    [ u"br",u"Nova Aurora",9013,-22.866667,-52.566667 ],
    [ u"br",u"Nova Cruz",23166,-6.466667,-35.433333 ],
    [ u"br",u"Nova Era",15595,-19.75,-43.05 ],
    [ u"br",u"Nova Esperança",24833,-23.182485,-52.203005 ],
    [ u"br",u"Nova Floresta",8623,-6.45,-36.2 ],
    [ u"br",u"Nova Friburgo",153363,-22.266667,-42.533333 ],
    [ u"br",u"Nova Granada",15716,-20.483333,-49.316667 ],
    [ u"br",u"Nova Iguaçu",1002129,-22.759188,-43.431887 ],
    [ u"br",u"Nova Lima",88400,-19.983333,-43.85 ],
    [ u"br",u"Nova Londrina",11042,-22.75,-53 ],
    [ u"br",u"Nova Odessa",49433,-22.783333,-47.3 ],
    [ u"br",u"Nova Olímpia",19283,-14.816667,-57.333333 ],
    [ u"br",u"Nova Olinda do Norte",12344,-3.75,-59.05 ],
    [ u"br",u"Nova Petrópolis",16050,-29.366667,-51.133333 ],
    [ u"br",u"Nova Prata",17943,-28.783333,-51.6 ],
    [ u"br",u"Nova Russas",21986,-4.7,-40.566667 ],
    [ u"br",u"Nova Serrana",51103,-19.866667,-44.983333 ],
    [ u"br",u"Nova Soure",11340,-11.233333,-38.483333 ],
    [ u"br",u"Nova Venécia",28363,-18.716667,-40.4 ],
    [ u"br",u"Nova Viçosa",56001,-17.883333,-39.366667 ],
    [ u"br",u"Novo Aripuanã",11044,-5.120278,-60.378889 ],
    [ u"br",u"Novo Cruzeiro",10385,-17.483333,-41.883333 ],
    [ u"br",u"Novo Hamburgo",253846,-29.683333,-51.133333 ],
    [ u"br",u"Novo Horizonte",30159,-21.466667,-49.216667 ],
    [ u"br",u"Novo Lino",5538,-9.016667,-35.616667 ],
    [ u"br",u"Nôvo Oriente",14529,-5.533333,-40.766667 ],
    [ u"br",u"Óbidos",24971,-1.908333,-55.518889 ],
    [ u"br",u"Ocara",6793,-4.483333,-38.616667 ],
    [ u"br",u"Oeiras do Pará",10163,-1.966667,-49.85 ],
    [ u"br",u"Oeiras",21071,-7.016667,-42.133333 ],
    [ u"br",u"Olímpia",45200,-20.733333,-48.9 ],
    [ u"br",u"Olinda",366761,-8.016667,-34.85 ],
    [ u"br",u"Olindina",12317,-11.366667,-38.35 ],
    [ u"br",u"Oliveira dos Brejinhos",5596,-12.316667,-42.9 ],
    [ u"br",u"Oliveira",34711,-20.683333,-44.816667 ],
    [ u"br",u"Olivença",2848,-9.516667,-37.183333 ],
    [ u"br",u"Oriximiná",35582,-1.765278,-55.863889 ],
    [ u"br",u"Orizona",7583,-17.05,-48.3 ],
    [ u"br",u"Orlândia",44767,-20.716667,-47.883333 ],
    [ u"br",u"Orleans",16422,-28.35,-49.3 ],
    [ u"br",u"Orobó",5884,-7.733333,-35.6 ],
    [ u"br",u"Orós",16329,-6.25,-38.916667 ],
    [ u"br",u"Ortigueira",11541,-24.2,-50.916667 ],
    [ u"br",u"Osasco",677869,-23.566667,-46.783333 ],
    [ u"br",u"Osório",34628,-29.9,-50.266667 ],
    [ u"br",u"Osvaldo Cruz",25747,-21.783333,-50.833333 ],
    [ u"br",u"Otacílio Costa",14557,-27.566667,-50.116667 ],
    [ u"br",u"Ourém",8145,-1.55,-47.1 ],
    [ u"br",u"Ouricuri",29318,-7.883333,-40.083333 ],
    [ u"br",u"Ourinhos",97801,-22.983333,-49.866667 ],
    [ u"br",u"Ouro Branco",26687,-20.533333,-43.7 ],
    [ u"br",u"Ouro Fino",21076,-28.983333,-52.816667 ],
    [ u"br",u"Ouro Prêto do Oeste",26686,-10.666667,-62.3 ],
    [ u"br",u"Ouro Prêto",63679,-20.383333,-43.5 ],
    [ u"br",u"Pacaembu",10101,-21.566667,-51.283333 ],
    [ u"br",u"Pacajus",41558,-4.166667,-38.466667 ],
    [ u"br",u"Pacatuba",55292,-3.966667,-38.616667 ],
    [ u"br",u"Pacatuba",2616,-10.433333,-36.65 ],
    [ u"br",u"Padre Bernardo",16118,-15.35,-48.5 ],
    [ u"br",u"Padre Paraíso",10608,-17.1,-41.516667 ],
    [ u"br",u"Paiçandu",34365,-23.45,-52.033333 ],
    [ u"br",u"Palhoça",122425,-27.633333,-48.666667 ],
    [ u"br",u"Palmares do Sul",8393,-30.266667,-50.516667 ],
    [ u"br",u"Palmares",41680,-8.683333,-35.6 ],
    [ u"br",u"Palmas de Monte Alto",7091,-14.266667,-43.166667 ],
    [ u"br",u"Palmas",39150,-26.5,-52 ],
    [ u"br",u"Palmas",196332,-10.222778,-48.277778 ],
    [ u"br",u"Palmeira das Missões",30954,-27.916667,-53.283333 ],
    [ u"br",u"Palmeirais",4262,-5.966667,-43.066667 ],
    [ u"br",u"Palmeira",18630,-25.426111,-50.003333 ],
    [ u"br",u"Palmeiras de Goiás",13573,-16.816667,-49.916667 ],
    [ u"br",u"Palmital",18540,-22.783333,-50.2 ],
    [ u"br",u"Palotina",23059,-24.283333,-53.833333 ],
    [ u"br",u"Panambi",30408,-28.3,-53.5 ],
    [ u"br",u"Pancas",8184,-19.233333,-40.85 ],
    [ u"br",u"Panelas",12625,-8.666667,-36.016667 ],
    [ u"br",u"Panorama",14227,-21.35,-51.85 ],
    [ u"br",u"Pão de Açúcar",11497,-9.75,-37.433333 ],
    [ u"br",u"Papagaios",11850,-19.533333,-44.75 ],
    [ u"br",u"Paracambi",36099,-22.608611,-43.712778 ],
    [ u"br",u"Paracatu",70754,-17.216667,-46.866667 ],
    [ u"br",u"Paracuru",21197,-3.4,-39.066667 ],
    [ u"br",u"Pará de Minas",75787,-19.85,-44.616667 ],
    [ u"br",u"Paragominas",69616,-2.966667,-47.483333 ],
    [ u"br",u"Paraguaçu",15742,-21.55,-45.733333 ],
    [ u"br",u"Paraguaçu Paulista",39120,-22.416667,-50.566667 ],
    [ u"br",u"Paraíba do Sul",35518,-22.1575,-43.290556 ],
    [ u"br",u"Paraibano",12364,-6.5,-44.016667 ],
    [ u"br",u"Paraipaba",18424,-3.433333,-39.116667 ],
    [ u"br",u"Paraisópolis",13563,-22.55,-45.783333 ],
    [ u"br",u"Parambu",14656,-6.216667,-40.716667 ],
    [ u"br",u"Paramirim",7421,-13.433333,-42.25 ],
    [ u"br",u"Paranaguá",141014,-25.516667,-48.5 ],
    [ u"br",u"Paranaíba",32218,-19.666667,-51.183333 ],
    [ u"br",u"Paranapanema",16218,-23.383333,-48.716667 ],
    [ u"br",u"Paranã",2751,-12.640556,-47.7925 ],
    [ u"br",u"Paranavaí",72849,-23.066667,-52.466667 ],
    [ u"br",u"Paranhos",6516,-23.916667,-55.416667 ],
    [ u"br",u"Paraopeba",19151,-19.3,-44.416667 ],
    [ u"br",u"Paratinga",10262,-12.7,-43.166667 ],
    [ u"br",u"Parati",15118,-23.216667,-44.716667 ],
    [ u"br",u"Paraúna",9731,-17.033333,-50.433333 ],
    [ u"br",u"Parelhas",16377,-6.683333,-36.65 ],
    [ u"br",u"Parintins",64429,-2.6,-56.733333 ],
    [ u"br",u"Paripiranga",6965,-10.683333,-37.866667 ],
    [ u"br",u"Pariquera-Açu",13436,-24.716667,-47.883333 ],
    [ u"br",u"Parnaíba",138011,-2.909167,-41.774722 ],
    [ u"br",u"Parnamirim",150347,-5.916667,-35.25 ],
    [ u"br",u"Parnamirim",7928,-8.083333,-39.566667 ],
    [ u"br",u"Parnarama",12202,-5.683333,-43.1 ],
    [ u"br",u"Parobé",48560,-29.633333,-50.833333 ],
    [ u"br",u"Passagem Franca",7376,-6.166667,-43.783333 ],
    [ u"br",u"Passa Quatro",12765,-22.383333,-44.966667 ],
    [ u"br",u"Passira",12664,-7.95,-35.633333 ],
    [ u"br",u"Passo de Camaragibe",5523,-9.25,-35.433333 ],
    [ u"br",u"Passo Fundo",179532,-28.266667,-52.4 ],
    [ u"br",u"Passos",98753,-20.716667,-46.616667 ],
    [ u"br",u"Pastos Bons",10469,-6.6,-44.083333 ],
    [ u"br",u"Pato Branco",65754,-26.216667,-52.666667 ],
    [ u"br",u"Patos de Minas",126236,-18.583333,-46.533333 ],
    [ u"br",u"Patos",92577,-7.016667,-37.266667 ],
    [ u"br",u"Patrocínio",71964,-18.95,-46.983333 ],
    [ u"br",u"Patu",8842,-6.1,-37.633333 ],
    [ u"br",u"Pau Brasil",8136,-15.45,-39.65 ],
    [ u"br",u"Pau dos Ferros",25051,-6.116667,-38.166667 ],
    [ u"br",u"Pauini",7633,-7.666667,-66.966667 ],
    [ u"br",u"Paulínia",65596,-22.75,-47.166667 ],
    [ u"br",u"Paulista",3677,-6.583333,-37.616667 ],
    [ u"br",u"Paulista",289977,-7.95,-34.883333 ],
    [ u"br",u"Paulo Afonso",85353,-9.35,-38.233333 ],
    [ u"br",u"Paulo Ramos",8888,-4.216667,-45.183333 ],
    [ u"br",u"Peabiru",12345,-23.9,-52.333333 ],
    [ u"br",u"Peçanha",6903,-18.55,-42.566667 ],
    [ u"br",u"Pederneiras",38020,-22.383333,-48.766667 ],
    [ u"br",u"Pedra Azul",20899,-16.016667,-41.266667 ],
    [ u"br",u"Pedra Branca",20072,-5.45,-39.716667 ],
    [ u"br",u"Pedra",11197,-8.5,-36.95 ],
    [ u"br",u"Pedras de Fogo",13894,-7.383333,-35.116667 ],
    [ u"br",u"Pedregulho",11216,-20.266667,-47.483333 ],
    [ u"br",u"Pedreira",39199,-22.716667,-46.916667 ],
    [ u"br",u"Pedreiras",33909,-4.566667,-44.65 ],
    [ u"br",u"Pedro II",22039,-4.416667,-41.466667 ],
    [ u"br",u"Pedro Leopoldo",49262,-19.633333,-44.05 ],
    [ u"br",u"Pedro Velho",6366,-6.433333,-35.233333 ],
    [ u"br",u"Pelotas",320680,-31.766667,-52.333333 ],
    [ u"br",u"Penalva",17186,-3.3,-45.166667 ],
    [ u"br",u"Penápolis",54478,-21.4,-50.066667 ],
    [ u"br",u"Pendências",9363,-5.263333,-36.723056 ],
    [ u"br",u"Penedo",42099,-10.283333,-36.6 ],
    [ u"br",u"Penha",20097,-26.766667,-48.65 ],
    [ u"br",u"Pentecoste",19681,-3.8,-39.283333 ],
    [ u"br",u"Perdões",17821,-21.083333,-45.083333 ],
    [ u"br",u"Pereira Barreto",22537,-20.633333,-51.116667 ],
    [ u"br",u"Peruíbe",63032,-24.316667,-47 ],
    [ u"br",u"Pesqueira",41896,-8.366667,-36.7 ],
    [ u"br",u"Petrolândia",20575,-9.083333,-38.3 ],
    [ u"br",u"Petrolina de Goiás",7710,-16.1,-49.333333 ],
    [ u"br",u"Petrolina",194653,-9.4,-40.5 ],
    [ u"br",u"Petrópolis",272694,-22.510833,-43.184444 ],
    [ u"br",u"Piaçabuçu",9862,-10.4,-36.416667 ],
    [ u"br",u"Piancó",10482,-7.2,-37.95 ],
    [ u"br",u"Picos",57496,-7.083333,-41.466667 ],
    [ u"br",u"Picuí",10779,-6.516667,-36.35 ],
    [ u"br",u"Piedade",27913,-23.713098,-47.414578 ],
    [ u"br",u"Pilão Arcado",6715,-10.15,-42.433333 ],
    [ u"br",u"Pilar do Sul",19107,-23.816667,-47.7 ],
    [ u"br",u"Pilar",30617,-9.6,-35.933333 ],
    [ u"br",u"Pilar",7588,-7.25,-35.266667 ],
    [ u"br",u"Pimenta Bueno",25785,-11.65,-61.2 ],
    [ u"br",u"Pimenteiras",3819,-6.233333,-41.416667 ],
    [ u"br",u"Pindamonhangaba",132220,-22.916667,-45.466667 ],
    [ u"br",u"Pindobaçu",17242,-10.733333,-40.35 ],
    [ u"br",u"Pindorama",12248,-21.2,-48.916667 ],
    [ u"br",u"Pinhão",15141,-25.716667,-51.633333 ],
    [ u"br",u"Pinheiral",19469,-22.516667,-43.983333 ],
    [ u"br",u"Pinheiro Machado",11176,-31.566667,-53.383333 ],
    [ u"br",u"Pinheiro",38894,-2.516667,-45.083333 ],
    [ u"br",u"Pio IX",4973,-6.833333,-40.616667 ],
    [ u"br",u"Pio XII",14773,-3.883333,-45.283333 ],
    [ u"br",u"Piquete",13845,-22.6,-45.183333 ],
    [ u"br",u"Piracaia",26076,-23.05,-46.35 ],
    [ u"br",u"Piracanjuba",16736,-17.3,-49.016667 ],
    [ u"br",u"Piracicaba",342216,-22.716667,-47.633333 ],
    [ u"br",u"Piracuruca",18852,-3.933333,-41.7 ],
    [ u"br",u"Piraí do Sul",16409,-24.516667,-49.933333 ],
    [ u"br",u"Piraí",19105,-22.627778,-43.901944 ],
    [ u"br",u"Pirajuí",17503,-21.983333,-49.483333 ],
    [ u"br",u"Piraju",25271,-23.2,-49.383333 ],
    [ u"br",u"Piranhas",1170,-9.45,-37.766667 ],
    [ u"br",u"Piranhas",9887,-16.516667,-51.85 ],
    [ u"br",u"Pirapemas",6441,-3.716667,-44.233333 ],
    [ u"br",u"Pirapora do Bom Jesus",14690,-23.4,-47 ],
    [ u"br",u"Pirapora",51657,-17.35,-44.933333 ],
    [ u"br",u"Pirapòzinho",21711,-22.25,-51.5 ],
    [ u"br",u"Piraquara",41162,-25.433333,-49.066667 ],
    [ u"br",u"Pirassununga",60414,-21.983333,-47.416667 ],
    [ u"br",u"Pirenópolis",13615,-15.85,-48.95 ],
    [ u"br",u"Pires do Rio",24823,-17.3,-48.283333 ],
    [ u"br",u"Piripiri",44866,-4.266667,-41.783333 ],
    [ u"br",u"Piritiba",16230,-11.733333,-40.566667 ],
    [ u"br",u"Pirpirituba",8355,-6.766667,-35.5 ],
    [ u"br",u"Pitanga",18652,-24.766667,-51.733333 ],
    [ u"br",u"Pitangueiras",28541,-21.033333,-48.216667 ],
    [ u"br",u"Pitangui",18859,-19.666667,-44.9 ],
    [ u"br",u"Pitimbu",7862,-7.466667,-34.8 ],
    [ u"br",u"Piúma",17634,-20.833333,-40.716667 ],
    [ u"br",u"Plácido de Castro",11950,-10.333333,-67.183333 ],
    [ u"br",u"Planaltina",88855,-15.616667,-47.666667 ],
    [ u"br",u"Poá",107434,-23.533333,-46.333333 ],
    [ u"br",u"Poção de Pedras",12337,-4.75,-44.933333 ],
    [ u"br",u"Pocinhos",7803,-7.066667,-36.05 ],
    [ u"br",u"Poço Branco",7112,-5.633333,-35.666667 ],
    [ u"br",u"Poço das Trincheiras",1775,-9.3,-37.266667 ],
    [ u"br",u"Poções",35255,-14.516667,-40.35 ],
    [ u"br",u"Poconé",21485,-16.259722,-56.626944 ],
    [ u"br",u"Poços de Caldas",146590,-21.8,-46.566667 ],
    [ u"br",u"Poço Verde",12167,-10.7,-38.183333 ],
    [ u"br",u"Pojuca",25102,-12.35,-38.333333 ],
    [ u"br",u"Pombal",21751,-6.766667,-37.783333 ],
    [ u"br",u"Pombos",15895,-8.15,-35.4 ],
    [ u"br",u"Pomerode",21898,-26.75,-49.183333 ],
    [ u"br",u"Pompéia",18015,-22.133333,-50.166667 ],
    [ u"br",u"Pompeu",25278,-19.166667,-45.1 ],
    [ u"br",u"Ponta Grossa",292179,-25.083333,-50.15 ],
    [ u"br",u"Pontal do Paraná",14969,-25.58,-48.354167 ],
    [ u"br",u"Pontalina",13640,-17.516667,-49.45 ],
    [ u"br",u"Pontal",32567,-21.05,-48.083333 ],
    [ u"br",u"Ponta Porã",55765,-22.533333,-55.716667 ],
    [ u"br",u"Ponte Nova",48188,-20.4,-42.9 ],
    [ u"br",u"Pontes e Lacerda",29383,-15.2,-59.366667 ],
    [ u"br",u"Ponto Novo",7141,-10.866667,-40.133333 ],
    [ u"br",u"Porangatu",32758,-13.433333,-49.166667 ],
    [ u"br",u"Porciúncula",12511,-20.966667,-42.033333 ],
    [ u"br",u"Porecatu",11390,-22.716667,-51.4 ],
    [ u"br",u"Portão",21051,-29.7,-51.25 ],
    [ u"br",u"Porteirinha",14144,-15.733333,-43.033333 ],
    [ u"br",u"Portel",21315,-1.95,-50.816667 ],
    [ u"br",u"Porto Alegre",1372763,-30.033333,-51.2 ],
    [ u"br",u"Porto Belo",14722,-27.1575,-48.539722 ],
    [ u"br",u"Pôrto Calvo",17347,-9.066667,-35.4 ],
    [ u"br",u"Pôrto da Fôlha",9420,-9.916667,-37.283333 ],
    [ u"br",u"Pôrto de Moz",9912,-1.75,-52.233333 ],
    [ u"br",u"Porto Feliz",41016,-23.213333,-47.523056 ],
    [ u"br",u"Pôrto Ferreira",49128,-21.85,-47.466667 ],
    [ u"br",u"Pôrto Franco",14874,-6.333333,-47.4 ],
    [ u"br",u"Pôrto Murtinho",12672,-21.7,-57.866667 ],
    [ u"br",u"Porto Nacional",40862,-10.708056,-48.308333 ],
    [ u"br",u"Pôrto",6535,-3.9,-42.7 ],
    [ u"br",u"Pôrto Real do Colégio",6001,-10.183333,-36.816667 ],
    [ u"br",u"Porto Real",12061,-22.4172,-44.2861 ],
    [ u"br",u"Pôrto Seguro",123196,-16.433333,-39.083333 ],
    [ u"br",u"Pôrto União",28907,-26.25,-51.083333 ],
    [ u"br",u"Pôrto Velho",306206,-8.766667,-63.9 ],
    [ u"br",u"Pôrto Walter",1816,-8.261111,-72.738889 ],
    [ u"br",u"Posse",20003,-14.083333,-46.366667 ],
    [ u"br",u"Pouso Alegre",115203,-22.216667,-45.933333 ],
    [ u"br",u"Pradópolis",13193,-21.366667,-48.066667 ],
    [ u"br",u"Prado",15466,-17.35,-39.216667 ],
    [ u"br",u"Praia Grande",250032,-24,-46.4 ],
    [ u"br",u"Prainha",6481,-1.8,-53.483333 ],
    [ u"br",u"Prata",19896,-19.3,-48.916667 ],
    [ u"br",u"Presidente Bernardes",12954,-22.05,-51.55 ],
    [ u"br",u"Presidente Dutra",30330,-5.25,-44.5 ],
    [ u"br",u"Presidente Epitácio",38742,-21.766667,-52.1 ],
    [ u"br",u"Presidente Médici",11923,-11.283333,-61.916667 ],
    [ u"br",u"Presidente Olegário",13587,-18.416667,-46.416667 ],
    [ u"br",u"Presidente Prudente",209507,-22.116667,-51.366667 ],
    [ u"br",u"Presidente Venceslau",34026,-21.866667,-51.833333 ],
    [ u"br",u"Princesa Isabel",12616,-7.733333,-38 ],
    [ u"br",u"Promissão",27032,-21.533333,-49.866667 ],
    [ u"br",u"Propriá",23787,-10.216667,-36.85 ],
    [ u"br",u"Prudentópolis",19611,-25.2,-50.95 ],
    [ u"br",u"Puxinanã",3210,-7.15,-35.966667 ],
    [ u"br",u"Quaraí",23229,-30.383333,-56.45 ],
    [ u"br",u"Quatá",10370,-22.266667,-50.7 ],
    [ u"br",u"Quatis",10289,-22.4099,-44.2594 ],
    [ u"br",u"Quatro Barras",17526,-25.366667,-49.083333 ],
    [ u"br",u"Quebrângulo",6587,-9.333333,-36.483333 ],
    [ u"br",u"Queimadas",10439,-10.966667,-39.633333 ],
    [ u"br",u"Queimadas",20446,-7.35,-35.916667 ],
    [ u"br",u"Queimados",135742,-22.722897,-43.556316 ],
    [ u"br",u"Quijingue",4293,-10.75,-39.2 ],
    [ u"br",u"Quipapá",11533,-8.833333,-36.033333 ],
    [ u"br",u"Quirinópolis",32104,-18.533333,-50.5 ],
    [ u"br",u"Quixadá",49328,-4.966667,-39.016667 ],
    [ u"br",u"Quixeramobim",34322,-5.2,-39.283333 ],
    [ u"br",u"Quixeré",11258,-5.083333,-37.983333 ],
    [ u"br",u"Rancharia",25531,-22.25,-50.916667 ],
    [ u"br",u"Raposa",11883,-6.516667,-44.183333 ],
    [ u"br",u"Raposos",13263,-19.95,-43.8 ],
    [ u"br",u"Raul Soares",13210,-20.083333,-42.366667 ],
    [ u"br",u"Realeza",10389,-25.783333,-53.516667 ],
    [ u"br",u"Recife",1478118,-8.05,-34.9 ],
    [ u"br",u"Recreio",8882,-21.533333,-42.466667 ],
    [ u"br",u"Redenção",14174,-4.216667,-38.716667 ],
    [ u"br",u"Regeneração",13608,-6.25,-42.683333 ],
    [ u"br",u"Regente Feijó",17219,-22.25,-51.333333 ],
    [ u"br",u"Registro",45698,-24.5,-47.833333 ],
    [ u"br",u"Remanso",22780,-9.683333,-42.066667 ],
    [ u"br",u"Remígio",9659,-6.933333,-35.783333 ],
    [ u"br",u"Reriutaba",12076,-4.166667,-40.583333 ],
    [ u"br",u"Resende",111515,-22.4679,-44.4575 ],
    [ u"br",u"Reserva",11097,-24.633333,-50.866667 ],
    [ u"br",u"Resplendor",15131,-19.333333,-41.25 ],
    [ u"br",u"Riachão das Neves",11236,-11.766667,-44.933333 ],
    [ u"br",u"Riachão do Dantas",4615,-11.066667,-37.733333 ],
    [ u"br",u"Riachão do Jacuípe",16911,-11.8,-39.35 ],
    [ u"br",u"Riachão",12428,-7.366667,-46.616667 ],
    [ u"br",u"Riacho de Santana",12658,-13.616667,-42.95 ],
    [ u"br",u"Rialma",9270,-15.3,-49.566667 ],
    [ u"br",u"Ribas do Rio Pardo",11935,-20.45,-53.766667 ],
    [ u"br",u"Ribeira do Pombal",28236,-10.833333,-38.533333 ],
    [ u"br",u"Ribeirão Bonito",10877,-22.066667,-48.166667 ],
    [ u"br",u"Ribeirão Branco",9718,-24.216667,-48.783333 ],
    [ u"br",u"Ribeirão das Neves",406840,-19.783333,-44.1 ],
    [ u"br",u"Ribeirão do Pinhal",11275,-23.4,-50.3 ],
    [ u"br",u"Ribeirão Pires",111890,-23.716667,-46.416667 ],
    [ u"br",u"Ribeirão Prêto",551278,-21.166667,-47.8 ],
    [ u"br",u"Ribeirão",29819,-8.516667,-35.383333 ],
    [ u"br",u"Ribeirópolis",11215,-10.533333,-37.433333 ],
    [ u"br",u"Rio Bananal",4814,-19.266667,-40.333333 ],
    [ u"br",u"Rio Bonito",35997,-22.716667,-42.616667 ],
    [ u"br",u"Rio Branco do Sul",26441,-25.166667,-49.3 ],
    [ u"br",u"Rio Branco",257645,-9.966667,-67.8 ],
    [ u"br",u"Rio Brilhante",18837,-21.8,-54.55 ],
    [ u"br",u"Rio Casca",11769,-20.216667,-42.65 ],
    [ u"br",u"Rio Claro",12620,-22.716667,-44.15 ],
    [ u"br",u"Rio Claro",180151,-22.4,-47.55 ],
    [ u"br",u"Rio das Ostras",46619,-22.533333,-41.95 ],
    [ u"br",u"Rio das Pedras",23722,-22.833333,-47.6 ],
    [ u"br",u"Rio de Janeiro",6023742,-22.9,-43.233333 ],
    [ u"br",u"Rio do Sul",51945,-27.2181,-49.6436 ],
    [ u"br",u"Rio Formoso",15518,-8.666667,-35.15 ],
    [ u"br",u"Rio Grande da Serra",38162,-23.8,-46.333333 ],
    [ u"br",u"Rio Grande",187842,-32.033333,-52.083333 ],
    [ u"br",u"Rio Largo",63389,-9.483333,-35.85 ],
    [ u"br",u"Rio Negrinho",41915,-26.239449,-49.499857 ],
    [ u"br",u"Rio Negro",23007,-26.0934,-49.7895 ],
    [ u"br",u"Rio Novo do Sul",6717,-20.866667,-40.933333 ],
    [ u"br",u"Rio Novo",6258,-21.483333,-43.133333 ],
    [ u"br",u"Rio Pardo de Minas",9540,-15.616667,-42.55 ],
    [ u"br",u"Rio Pardo",26999,-29.983333,-52.366667 ],
    [ u"br",u"Rio Piracicaba",10439,-19.916667,-43.183333 ],
    [ u"br",u"Rio Pomba",13707,-21.283333,-43.183333 ],
    [ u"br",u"Rio Real",24006,-11.466667,-37.933333 ],
    [ u"br",u"Rio Tinto",11804,-6.8,-35.083333 ],
    [ u"br",u"Rio Verde de Mato Grosso",16613,-18.933333,-54.866667 ],
    [ u"br",u"Rodrigues Alves",3827,-11.9,-65 ],
    [ u"br",u"Rolândia",51005,-23.3,-51.366667 ],
    [ u"br",u"Rolante",15594,-29.666667,-50.566667 ],
    [ u"br",u"Rolim de Moura",37953,-13.083333,-62.266667 ],
    [ u"br",u"Rondonópolis",152921,-16.466667,-54.633333 ],
    [ u"br",u"Rosário do Sul",36722,-30.25,-54.916667 ],
    [ u"br",u"Rosário Oeste",10469,-14.833333,-56.416667 ],
    [ u"br",u"Rosário",23271,-2.95,-44.233333 ],
    [ u"br",u"Rubiataba",16128,-15.133333,-49.8 ],
    [ u"br",u"Russas",39465,-4.933333,-37.966667 ],
    [ u"br",u"Ruy Barbosa",21093,-12.3,-40.45 ],
    [ u"br",u"Sabará",158359,-19.9,-43.8 ],
    [ u"br",u"Sabinópolis",9713,-18.666667,-43.1 ],
    [ u"br",u"Sacramento",16983,-19.883333,-47.45 ],
    [ u"br",u"Salgado de São Félix",4266,-7.35,-35.433333 ],
    [ u"br",u"Salgado",5457,-11.033333,-37.466667 ],
    [ u"br",u"Salgueiro",42153,-8.066667,-39.1 ],
    [ u"br",u"Salinas",25747,-16.166667,-42.283333 ],
    [ u"br",u"Salinópolis",40999,-.616667,-47.333333 ],
    [ u"br",u"Salto de Pirapora",32228,-23.6494,-47.5715 ],
    [ u"br",u"Salto",98389,-23.2,-47.283333 ],
    [ u"br",u"Salvador",2711903,-12.983333,-38.516667 ],
    [ u"br",u"Sananduva",9601,-27.95,-51.8 ],
    [ u"br",u"Santa Adélia",12585,-21.266667,-48.8 ],
    [ u"br",u"Santa Bárbara",19991,-19.933333,-43.4 ],
    [ u"br",u"Santa Branca",8661,-23.4,-45.883333 ],
    [ u"br",u"Santa Cecília",15092,-26.933333,-50.45 ],
    [ u"br",u"Santa Cruz Cabrália",19549,-16.283333,-39.033333 ],
    [ u"br",u"Santa Cruz das Palmeiras",25801,-21.816667,-47.25 ],
    [ u"br",u"Santa Cruz do Capibaribe",76451,-7.95,-36.2 ],
    [ u"br",u"Santa Cruz do Rio Pardo",37336,-22.916667,-49.616667 ],
    [ u"br",u"Santa Cruz do Sul",106115,-29.716667,-52.433333 ],
    [ u"br",u"Santa Cruz",27776,-6.216667,-36.016667 ],
    [ u"br",u"Santa Fé do Sul",25802,-20.216667,-50.933333 ],
    [ u"br",u"Santa Gertrudes",18490,-22.466667,-47.516667 ],
    [ u"br",u"Santa Helena de Goiás",34254,-17.716667,-50.583333 ],
    [ u"br",u"Santa Helena",16045,-2.233333,-45.3 ],
    [ u"br",u"Santa Inês",10521,-13.283333,-39.8 ],
    [ u"br",u"Santa Inês",67426,-3.65,-45.366667 ],
    [ u"br",u"Santa Isabel do Pará",39284,-1.266667,-48.183333 ],
    [ u"br",u"Santa Isabel do Rio Negro",4142,-.4,-65.033333 ],
    [ u"br",u"Santa Isabel",33709,-23.3158,-46.2241 ],
    [ u"br",u"Santa Leopoldina",2327,-20.1,-40.533333 ],
    [ u"br",u"Santa Luzia",22910,-7.633333,-47.2 ],
    [ u"br",u"Santa Luzia",243506,-19.783333,-43.866667 ],
    [ u"br",u"Santa Luzia",13243,-6.883333,-36.933333 ],
    [ u"br",u"Santa Maria da Boa Vista",14695,-8.816667,-39.816667 ],
    [ u"br",u"Santa Maria da Vitória",23489,-13.4,-44.2 ],
    [ u"br",u"Santa Maria do Pará",12915,-1.35,-47.566667 ],
    [ u"br",u"Santa Maria do Suaçuí",9936,-18.2,-42.416667 ],
    [ u"br",u"Santa Maria",249224,-29.683333,-53.8 ],
    [ u"br",u"Santana de Parnaíba",98991,-23.45,-46.916667 ],
    [ u"br",u"Santana do Acaraú",14707,-3.45,-40.2 ],
    [ u"br",u"Santana do Ipanema",26147,-9.366667,-37.233333 ],
    [ u"br",u"Santana do Livramento",89696,-30.883333,-55.516667 ],
    [ u"br",u"Santana do Matos",8050,-5.956111,-36.652778 ],
    [ u"br",u"Santana do Mundaú",6439,-9.15,-36.183333 ],
    [ u"br",u"Santana do Paraíso",25537,-19.366667,-42.533333 ],
    [ u"br",u"Santana",12629,-14.466667,-41.8 ],
    [ u"br",u"Santa Quitéria do Maranhão",17180,-3.516667,-42.533333 ],
    [ u"br",u"Santa Quitéria",24391,-4.333333,-40.166667 ],
    [ u"br",u"Santarém",189053,-2.433333,-54.7 ],
    [ u"br",u"Santa Rita do Passa Quatro",24579,-21.7,-47.466667 ],
    [ u"br",u"Santa Rita do Sapucaí",28766,-22.25,-45.7 ],
    [ u"br",u"Santa Rita",13226,-3.833333,-43.883333 ],
    [ u"br",u"Santa Rita",119895,-7.133333,-34.966667 ],
    [ u"br",u"Santa Rosa de Viterbo",21473,-21.466667,-47.35 ],
    [ u"br",u"Santa Rosa",58958,-27.866667,-54.483333 ],
    [ u"br",u"Santa Teresa",9160,-19.916667,-40.6 ],
    [ u"br",u"Santa Vitória do Palmar",27776,-33.516667,-53.35 ],
    [ u"br",u"Santa Vitória",11657,-18.833333,-50.133333 ],
    [ u"br",u"Santiago",46612,-29.183333,-54.883333 ],
    [ u"br",u"Santo Amaro da Imperatriz",18420,-27.683333,-48.766667 ],
    [ u"br",u"Santo Amaro das Brotas",9302,-10.783333,-37.066667 ],
    [ u"br",u"Santo Amaro",46749,-12.533333,-38.716667 ],
    [ u"br",u"Santo Anastácio",17233,-21.966667,-51.65 ],
    [ u"br",u"Santo André",662387,-23.666667,-46.516667 ],
    [ u"br",u"Santo Ângelo",64607,-28.3,-54.266667 ],
    [ u"br",u"Santo Antônio da Platina",35260,-23.2942,-50.075 ],
    [ u"br",u"Santo Antônio de Jesus",73959,-12.966667,-39.266667 ],
    [ u"br",u"Santo Antônio de Pádua",33076,-21.533333,-42.183333 ],
    [ u"br",u"Santo Antônio de Posse",18149,-22.6,-46.916667 ],
    [ u"br",u"Santo Antônio do Amparo",16730,-20.95,-44.916667 ],
    [ u"br",u"Santo Antônio do Içá",9302,-3.083333,-67.95 ],
    [ u"br",u"Santo Antônio do Leverger",6387,-15.866667,-56.083333 ],
    [ u"br",u"Santo Antônio do Monte",22592,-20.083333,-45.283333 ],
    [ u"br",u"Santo Antônio do Sudoeste",11723,-26.068889,-53.725278 ],
    [ u"br",u"Santo Antônio do Tauá",8921,-1.183333,-48.133333 ],
    [ u"br",u"Santo Antônio",12529,-6.3,-35.45 ],
    [ u"br",u"Santo Augusto",10305,-27.85,-53.783333 ],
    [ u"br",u"Santo Estêvão",27280,-12.433333,-39.216667 ],
    [ u"br",u"Santos Dumont",41582,-21.466667,-43.566667 ],
    [ u"br",u"Santos",411411,-23.95,-46.333333 ],
    [ u"br",u"São Benedito do Rio Prêto",12081,-3.333333,-43.583333 ],
    [ u"br",u"São Bento do Sul",77598,-26.249722,-49.3825 ],
    [ u"br",u"São Bento do Una",24506,-8.533333,-36.366667 ],
    [ u"br",u"São Bento",17245,-2.7,-44.833333 ],
    [ u"br",u"São Bento",24749,-6.283333,-37.75 ],
    [ u"br",u"São Bernardo do Campo",743386,-23.7,-46.55 ],
    [ u"br",u"São Bernardo",11171,-3.366667,-42.4 ],
    [ u"br",u"São Borja",59614,-28.65,-56 ],
    [ u"br",u"São Caetano de Odivelas",8862,-.75,-48.033333 ],
    [ u"br",u"São Caetano do Sul",136456,-23.6,-46.566667 ],
    [ u"br",u"São Caitano",25259,-8.35,-36.1 ],
    [ u"br",u"São Carlos",205039,-22.016667,-47.9 ],
    [ u"br",u"São Cristóvão",71540,-11.016667,-37.2 ],
    [ u"br",u"São Desidério",7295,-12.366667,-44.966667 ],
    [ u"br",u"São Domingos do Maranhão",18275,-5.7,-44.366667 ],
    [ u"br",u"São Domingos do Prata",9466,-19.866667,-42.966667 ],
    [ u"br",u"São Domingos",4784,-13.4,-46.316667 ],
    [ u"br",u"São Felipe",9574,-14.816667,-41.383333 ],
    [ u"br",u"São Félix do Xingu",16478,-6.633333,-51.983333 ],
    [ u"br",u"São Fidélis",27793,-21.65,-41.733333 ],
    [ u"br",u"São Francisco de Assis",14305,-29.55,-55.133333 ],
    [ u"br",u"São Francisco de Paula",13292,-29.45,-50.583333 ],
    [ u"br",u"São Francisco do Conde",24615,-12.65,-38.683333 ],
    [ u"br",u"São Francisco do Sul",36225,-26.233333,-48.65 ],
    [ u"br",u"São Francisco",33033,-15.95,-44.866667 ],
    [ u"br",u"São Gabriel da Cachoeira",15232,-.133333,-67.083333 ],
    [ u"br",u"São Gabriel",55435,-30.333333,-54.316667 ],
    [ u"br",u"São Geraldo do Araguaia",12925,-6.4,-48.533333 ],
    [ u"br",u"São Gonçalo do Amarante",23583,-3.6,-38.966667 ],
    [ u"br",u"São Gonçalo do Amarante",10381,-5.766667,-35.333333 ],
    [ u"br",u"São Gonçalo do Sapucaí",19487,-21.9,-45.6 ],
    [ u"br",u"São Gonçalo dos Campos",14822,-12.416667,-38.966667 ],
    [ u"br",u"São Gonçalo",939101,-22.800278,-43.025556 ],
    [ u"br",u"São Gotardo",34145,-19.316667,-46.05 ],
    [ u"br",u"São Jerônimo",17057,-29.966667,-51.716667 ],
    [ u"br",u"São João Batista",3634,-2.966667,-44.85 ],
    [ u"br",u"São João Batista",14539,-27.266667,-48.833333 ],
    [ u"br",u"São João da Barra",20606,-21.633333,-41.05 ],
    [ u"br",u"São João da Boa Vista",76541,-21.966667,-46.783333 ],
    [ u"br",u"São João da Ponte",8373,-15.933333,-44.016667 ],
    [ u"br",u"São João del Rei",78593,-21.15,-44.266667 ],
    [ u"br",u"São João de Meriti",454855,-22.798614,-43.360894 ],
    [ u"br",u"São João de Pirabas",10065,-.766667,-47.166667 ],
    [ u"br",u"São João do Paraíso",8859,-15.316667,-42.016667 ],
    [ u"br",u"São João do Piauí",12689,-8.35,-42.25 ],
    [ u"br",u"São João dos Patos",19539,-6.5,-43.7 ],
    [ u"br",u"São João Evangelista",10049,-18.533333,-42.75 ],
    [ u"br",u"São João Nepomuceno",23155,-21.55,-43.016667 ],
    [ u"br",u"São João",6926,-8.866667,-36.366667 ],
    [ u"br",u"São Joaquim da Barra",42720,-20.583333,-47.883333 ],
    [ u"br",u"São Joaquim de Bicas",14630,-20.05,-44.283333 ],
    [ u"br",u"São Joaquim do Monte",13520,-8.416667,-35.85 ],
    [ u"br",u"São Joaquim",16250,-28.3,-49.933333 ],
    [ u"br",u"São José da Coroa Grande",11512,-8.9,-35.15 ],
    [ u"br",u"São José da Laje",12811,-9,-36.033333 ],
    [ u"br",u"São José da Tapera",12392,-9.633333,-37.383333 ],
    [ u"br",u"São José de Mipibu",15317,-6.083333,-35.25 ],
    [ u"br",u"São José de Piranhas",7628,-7.116667,-38.5 ],
    [ u"br",u"São José de Ribamar",27777,-2.55,-44.05 ],
    [ u"br",u"São José do Belmonte",14211,-7.866667,-38.766667 ],
    [ u"br",u"São José do Calçado",7442,-21.033333,-41.666667 ],
    [ u"br",u"São José do Campestre",10254,-6.3,-35.7 ],
    [ u"br",u"São José do Egito",18219,-7.466667,-37.266667 ],
    [ u"br",u"São José do Rio Pardo",46990,-21.6,-46.9 ],
    [ u"br",u"São José do Rio Prêto",374706,-20.8,-49.383333 ],
    [ u"br",u"São José dos Campos",613776,-23.183333,-45.883333 ],
    [ u"br",u"São José dos Pinhais",229988,-25.516667,-49.216667 ],
    [ u"br",u"São José",203142,-27.633333,-48.65 ],
    [ u"br",u"São Leopoldo",209233,-29.766667,-51.15 ],
    [ u"br",u"São Lourenço da Mata",88417,-8,-35.05 ],
    [ u"br",u"São Lourenço da Serra",13331,-23.866667,-46.95 ],
    [ u"br",u"São Lourenço do Oeste",14872,-26.4,-52.766667 ],
    [ u"br",u"São Lourenço do Sul",25341,-31.366667,-51.966667 ],
    [ u"br",u"São Lourenço",41144,-22.116667,-45.05 ],
    [ u"br",u"São Luís de Montes Belos",23619,-16.533333,-50.333333 ],
    [ u"br",u"São Luís do Quitunde",20564,-9.333333,-35.55 ],
    [ u"br",u"São Luís",917252,-2.516667,-44.266667 ],
    [ u"br",u"São Luiz Gonzaga",31798,-28.4,-54.966667 ],
    [ u"br",u"São Manuel",33588,-22.733333,-48.566667 ],
    [ u"br",u"São Marcos",18591,-28.966667,-51.066667 ],
    [ u"br",u"São Mateus do Maranhão",28234,-4.033333,-44.466667 ],
    [ u"br",u"São Mateus do Sul",24904,-25.866667,-50.383333 ],
    [ u"br",u"São Mateus",77119,-18.733333,-39.85 ],
    [ u"br",u"São Miguel do Araguaia",18810,-13.316667,-50.216667 ],
    [ u"br",u"São Miguel do Guamá",28266,-1.616667,-47.45 ],
    [ u"br",u"São Miguel do Iguaçu",15434,-25.35,-54.166667 ],
    [ u"br",u"São Miguel do Oeste",27360,-26.75,-53.566667 ],
    [ u"br",u"São Miguel dos Campos",40891,-9.783333,-36.083333 ],
    [ u"br",u"São Miguel do Tapuio",7964,-5.5,-41.333333 ],
    [ u"br",u"São Miguel",12838,-5.466667,-35.366667 ],
    [ u"br",u"São Paulo de Olivença",11763,-3.45,-68.8 ],
    [ u"br",u"São Paulo do Potengi",9334,-5.916667,-35.75 ],
    [ u"br",u"São Paulo",10021437,-23.473293,-46.665803 ],
    [ u"br",u"São Pedro da Aldeia",55014,-22.85,-42.1 ],
    [ u"br",u"São Pedro do Piauí",7408,-5.933333,-42.716667 ],
    [ u"br",u"São Pedro do Sul",12137,-29.616667,-54.166667 ],
    [ u"br",u"São Pedro",27068,-22.55,-47.9 ],
    [ u"br",u"São Raimundo das Mangabeiras",10216,-7.016667,-45.483333 ],
    [ u"br",u"São Raimundo Nonato",19569,-9.016667,-42.7 ],
    [ u"br",u"São Roque",50541,-23.528458,-47.135273 ],
    [ u"br",u"São Sebastião do Caí",19013,-29.583333,-51.383333 ],
    [ u"br",u"São Sebastião do Paraíso",57239,-20.916667,-47 ],
    [ u"br",u"São Sebastião do Passé",31050,-12.516667,-38.466667 ],
    [ u"br",u"São Sebastião",9551,-9.933333,-36.566667 ],
    [ u"br",u"São Sebastião",76369,-23.8,-45.416667 ],
    [ u"br",u"São Sepé",19182,-30.166667,-53.566667 ],
    [ u"br",u"São Simão",12351,-21.5,-47.55 ],
    [ u"br",u"São Tomé",6137,-5.971389,-36.073611 ],
    [ u"br",u"São Vicente",324464,-23.966667,-46.383333 ],
    [ u"br",u"Sapé",36149,-7.1,-35.216667 ],
    [ u"br",u"Sapiranga",76053,-29.633333,-51 ],
    [ u"br",u"Sapucaia",12329,-22,-42.9 ],
    [ u"br",u"Sapucaia",130939,-29.833333,-51.15 ],
    [ u"br",u"Saquarema",62057,-22.933333,-42.5 ],
    [ u"br",u"Sarandi",84698,-23.433333,-51.866667 ],
    [ u"br",u"Sarandi",15159,-27.933333,-52.916667 ],
    [ u"br",u"Sarzedo",20800,-20.033333,-44.15 ],
    [ u"br",u"Satuba",15898,-9.566667,-35.816667 ],
    [ u"br",u"Saubara",15669,-12.75,-38.75 ],
    [ u"br",u"Schroeder",15515,-26.433333,-49.066667 ],
    [ u"br",u"Seabra",16765,-12.416667,-41.766667 ],
    [ u"br",u"Seara",10976,-27.116667,-52.283333 ],
    [ u"br",u"Senador Canedo",61801,-16.716667,-49.083333 ],
    [ u"br",u"Senador Guiomard",11727,-10.166667,-67.833333 ],
    [ u"br",u"Senador José Porfírio",5708,-2.583333,-51.916667 ],
    [ u"br",u"Senador Pompeu",16516,-5.583333,-39.366667 ],
    [ u"br",u"Sena Madureira",20516,-9.066667,-68.666667 ],
    [ u"br",u"Sengés",14868,-24.1,-49.483333 ],
    [ u"br",u"Senhor do Bonfim",48472,-10.45,-40.183333 ],
    [ u"br",u"Sento Sé",19596,-9.666667,-41.3 ],
    [ u"br",u"Seropédica",54846,-22.747222,-43.716944 ],
    [ u"br",u"Serra Branca",8765,-6.533333,-38.266667 ],
    [ u"br",u"Serrana",39826,-21.233333,-47.6 ],
    [ u"br",u"Serra Negra",22632,-22.6,-46.7 ],
    [ u"br",u"Serra",394160,-20.116667,-40.3 ],
    [ u"br",u"Serra Talhada",51204,-7.983333,-38.3 ],
    [ u"br",u"Serrinha",49079,-11.65,-39 ],
    [ u"br",u"Sêrro",12616,-18.616667,-43.383333 ],
    [ u"br",u"Sertânia",18190,-8.083333,-37.266667 ],
    [ u"br",u"Sertanópolis",13904,-23.066667,-51.033333 ],
    [ u"br",u"Sertãozinho",99213,-21.133333,-47.983333 ],
    [ u"br",u"Sete Lagoas",201337,-19.45,-44.233333 ],
    [ u"br",u"Severiano Melo",2503,-5.766667,-37.95 ],
    [ u"br",u"Severínia",13212,-20.833333,-48.8 ],
    [ u"br",u"Siderópolis",8536,-28.583333,-49.433333 ],
    [ u"br",u"Sidrolândia",16878,-20.916667,-54.966667 ],
    [ u"br",u"Silva Jardim",16889,-22.466667,-42.3 ],
    [ u"br",u"Silvânia",11377,-16.666667,-48.6 ],
    [ u"br",u"Simão Dias",18386,-10.733333,-37.816667 ],
    [ u"br",u"Simões",4332,-7.6,-40.816667 ],
    [ u"br",u"Simplício Mendes",7076,-7.85,-41.9 ],
    [ u"br",u"Sítio Novo do Tocantins",5787,-5.518333,-47.461111 ],
    [ u"br",u"Sobradinho",19304,-12.5,-39.116667 ],
    [ u"br",u"Sobradinho",13397,-29.4,-53.05 ],
    [ u"br",u"Sobral",157998,-3.7,-40.35 ],
    [ u"br",u"Socorro",24272,-22.6,-46.533333 ],
    [ u"br",u"Solânea",17031,-6.75,-35.65 ],
    [ u"br",u"Soledade",8090,-7.05,-36.35 ],
    [ u"br",u"Soledade",24791,-28.833333,-52.5 ],
    [ u"br",u"Sombrio",14864,-29.116667,-49.666667 ],
    [ u"br",u"Sorocaba",558874,-23.483333,-47.45 ],
    [ u"br",u"Soure",18212,-.733333,-48.516667 ],
    [ u"br",u"Sousa",47927,-6.75,-38.233333 ],
    [ u"br",u"Sumaré",227982,-22.8,-47.283333 ],
    [ u"br",u"Sumé",10441,-7.65,-36.916667 ],
    [ u"br",u"Surubim",34581,-7.833333,-35.75 ],
    [ u"br",u"Suzano",283319,-23.533333,-46.333333 ],
    [ u"br",u"Tabatinga",28230,-4.240833,-69.942222 ],
    [ u"br",u"Tabatinga",11617,-21.716667,-48.683333 ],
    [ u"br",u"Tabira",16926,-7.583333,-37.55 ],
    [ u"br",u"Taboão da Serra",214527,-23.6,-46.766667 ],
    [ u"br",u"Tabuleiro do Norte",16633,-5.25,-38.116667 ],
    [ u"br",u"Taguatinga",9330,-12.465556,-46.366944 ],
    [ u"br",u"Taiobeiras",24351,-15.816667,-42.233333 ],
    [ u"br",u"Taipu",4606,-5.616667,-35.6 ],
    [ u"br",u"Tamandaré",17954,-8.75,-35.1 ],
    [ u"br",u"Tambaú",19957,-21.7,-47.266667 ],
    [ u"br",u"Tamboril",14292,-4.833333,-40.333333 ],
    [ u"br",u"Tanabi",18228,-20.616667,-49.616667 ],
    [ u"br",u"Tangará",8067,-6.183333,-35.816667 ],
    [ u"br",u"Tanguá",23740,-22.733333,-42.716667 ],
    [ u"br",u"Tanhaçu",6620,-14.016667,-41.283333 ],
    [ u"br",u"Tapauá",13211,-5.620278,-63.1875 ],
    [ u"br",u"Tapejara",10726,-23.683333,-52.883333 ],
    [ u"br",u"Tapejara",14064,-28.066667,-52 ],
    [ u"br",u"Taperoá",8095,-13.516667,-39.1 ],
    [ u"br",u"Taperoá",8879,-7.2,-36.816667 ],
    [ u"br",u"Tapes",18570,-30.666667,-51.383333 ],
    [ u"br",u"Tapiramutá",16549,-11.85,-40.783333 ],
    [ u"br",u"Taquarana",5288,-9.633333,-36.483333 ],
    [ u"br",u"Taquara",48052,-29.65,-50.783333 ],
    [ u"br",u"Taquari",27108,-29.8,-51.85 ],
    [ u"br",u"Taquaritinga do Norte",13379,-7.9,-36.05 ],
    [ u"br",u"Taquaritinga",50099,-21.4,-48.5 ],
    [ u"br",u"Taquarituba",21493,-23.516667,-49.25 ],
    [ u"br",u"Tarauacá",16526,-8.166667,-70.766667 ],
    [ u"br",u"Tarumã",10337,-22.75,-50.566667 ],
    [ u"br",u"Tatuí",93582,-23.346655,-47.848368 ],
    [ u"br",u"Tauá",29189,-5.966667,-40.3 ],
    [ u"br",u"Taubaté",251647,-23.033333,-45.55 ],
    [ u"br",u"Tavares",4939,-7.633333,-37.9 ],
    [ u"br",u"Tefé",44943,-3.366667,-64.7 ],
    [ u"br",u"Teixeira",9954,-7.216667,-37.25 ],
    [ u"br",u"Telêmaco Borba",58880,-24.35,-50.616667 ],
    [ u"br",u"Teodoro Sampaio",15193,-22.516667,-52.166667 ],
    [ u"br",u"Teófilo Otoni",101172,-17.85,-41.5 ],
    [ u"br",u"Terenos",6086,-20.433333,-54.833333 ],
    [ u"br",u"Teresina",744526,-5.083333,-42.816667 ],
    [ u"br",u"Teresópolis",123980,-22.424064,-42.968013 ],
    [ u"br",u"Terra Boa",12958,-23.75,-52.45 ],
    [ u"br",u"Terra Nova",11169,-12.366667,-40.666667 ],
    [ u"br",u"Terra Rica",10346,-22.716667,-52.633333 ],
    [ u"br",u"Terra Roxa",10911,-23.855708,-50.031397 ],
    [ u"br",u"Terra Santa",13512,-2.1,-56.483333 ],
    [ u"br",u"Teutônia",21834,-29.433333,-51.8 ],
    [ u"br",u"Tianguá",45697,-3.733333,-40.983333 ],
    [ u"br",u"Tibagi",12644,-24.5,-50.4 ],
    [ u"br",u"Tietê",32062,-23.100174,-47.714392 ],
    [ u"br",u"Tijucas",22482,-27.241111,-48.631389 ],
    [ u"br",u"Timbaúba",45122,-7.516667,-35.316667 ],
    [ u"br",u"Timbiras",17875,-4.25,-43.95 ],
    [ u"br",u"Timbó",33766,-26.833333,-49.3 ],
    [ u"br",u"Timon",124429,-5.1,-42.816667 ],
    [ u"br",u"Timóteo",91723,-19.583333,-42.666667 ],
    [ u"br",u"Tiradentes",4439,-21.116667,-44.183333 ],
    [ u"br",u"Tobias Barreto",29741,-11.183333,-38.016667 ],
    [ u"br",u"Tocantinópolis",23383,-6.324444,-47.277778 ],
    [ u"br",u"Tocantins",12876,-21.166667,-43.033333 ],
    [ u"br",u"Toledo",97846,-24.733333,-53.75 ],
    [ u"br",u"Tomar do Geru",4394,-11.383333,-37.85 ],
    [ u"br",u"Tomé-Açu",34054,-2.416667,-48.15 ],
    [ u"br",u"Tonantins",4561,-2.783333,-67.783333 ],
    [ u"br",u"Toritama",23941,-8.016667,-36.066667 ],
    [ u"br",u"Tôrres",32791,-29.35,-49.733333 ],
    [ u"br",u"Touros",7662,-5.2,-35.466667 ],
    [ u"br",u"Traipu",8427,-9.966667,-36.983333 ],
    [ u"br",u"Trairi",23135,-3.283333,-39.25 ],
    [ u"br",u"Tramandaí",34735,-29.966667,-50.133333 ],
    [ u"br",u"Tremedal",3252,-14.966667,-41.4 ],
    [ u"br",u"Tremembé",31720,-22.966667,-45.55 ],
    [ u"br",u"Três Barras",14855,-26.1,-50.316667 ],
    [ u"br",u"Três Corações",63458,-21.7,-45.266667 ],
    [ u"br",u"Três Coroas",21051,-29.533333,-50.8 ],
    [ u"br",u"Três de Maio",18278,-27.783333,-54.233333 ],
    [ u"br",u"Três Lagoas",78714,-20.8,-51.716667 ],
    [ u"br",u"Três Passos",17286,-27.45,-53.933333 ],
    [ u"br",u"Três Pontas",43750,-21.366667,-45.516667 ],
    [ u"br",u"Três Rios",71945,-22.111389,-43.207778 ],
    [ u"br",u"Trindade",97523,-16.666667,-49.5 ],
    [ u"br",u"Trindade",19313,-7.8,-40.283333 ],
    [ u"br",u"Triunfo",3871,-6.566667,-38.6 ],
    [ u"br",u"Triunfo",14749,-29.933333,-51.716667 ],
    [ u"br",u"Tubarão",67246,-28.5,-49.016667 ],
    [ u"br",u"Tucano",31209,-10.966667,-38.8 ],
    [ u"br",u"Tucumã",15031,-.183333,-50.05 ],
    [ u"br",u"Tucuruí",76339,-3.7,-49.7 ],
    [ u"br",u"Tuntum",16402,-5.233333,-44.65 ],
    [ u"br",u"Tupaciguara",24398,-18.583333,-48.7 ],
    [ u"br",u"Tupanatinga",5768,-8.75,-37.333333 ],
    [ u"br",u"Tupanciretã",17488,-29.083333,-53.85 ],
    [ u"br",u"Tupã",62036,-21.933333,-50.5 ],
    [ u"br",u"Tupi Paulista",10877,-21.4,-51.566667 ],
    [ u"br",u"Turiaçu",10471,-1.683333,-45.35 ],
    [ u"br",u"Turmalina",8798,-17.283333,-42.75 ],
    [ u"br",u"Tutóia",12212,-2.75,-42.266667 ],
    [ u"br",u"Uarini",2796,-2.916667,-65.133333 ],
    [ u"br",u"Uauá",11425,-9.833333,-39.466667 ],
    [ u"br",u"Ubaíra",8069,-13.266667,-39.65 ],
    [ u"br",u"Ubaitaba",28376,-14.3,-39.333333 ],
    [ u"br",u"Ubajara",13802,-3.85,-40.933333 ],
    [ u"br",u"Ubatã",15605,-14.2,-39.516667 ],
    [ u"br",u"Ubatuba",79008,-23.433333,-45.066667 ],
    [ u"br",u"Ubá",97829,-21.116667,-42.933333 ],
    [ u"br",u"Uberaba",260847,-19.75,-47.916667 ],
    [ u"br",u"Uberlândia",563545,-18.916667,-48.3 ],
    [ u"br",u"Uiraúna",7823,-6.516667,-38.416667 ],
    [ u"br",u"Umarizal",8781,-5.983333,-37.816667 ],
    [ u"br",u"Umbaúba",12880,-11.366667,-37.65 ],
    [ u"br",u"Umbuzeiro",4588,-7.683333,-35.666667 ],
    [ u"br",u"Umbuzeiro",4588,-7.7,-35.666667 ],
    [ u"br",u"Umirim",12220,-3.683333,-39.333333 ],
    [ u"br",u"Umuarama",89688,-23.75,-53.333333 ],
    [ u"br",u"Unaí",60203,-16.383333,-46.883333 ],
    [ u"br",u"Una",22650,-15.3,-39.066667 ],
    [ u"br",u"União da Victoria",48741,-26.216667,-51.083333 ],
    [ u"br",u"União dos Palmares",41179,-9.166667,-36.033333 ],
    [ u"br",u"União",15678,-4.583333,-42.866667 ],
    [ u"br",u"Upanema",6704,-5.644444,-37.257778 ],
    [ u"br",u"Urbano Santos",12268,-3.2,-43.383333 ],
    [ u"br",u"Uruaçu",30088,-14.5,-49.166667 ],
    [ u"br",u"Uruana",10258,-15.5,-49.683333 ],
    [ u"br",u"Uruburetama",12076,-3.633333,-39.5 ],
    [ u"br",u"Urucará",8603,-2.536667,-57.758056 ],
    [ u"br",u"Uruçuca",24414,-14.583333,-39.266667 ],
    [ u"br",u"Uruçuí",12243,-7.233333,-44.55 ],
    [ u"br",u"Urucurituba",10180,-2.683333,-57.666667 ],
    [ u"br",u"Uruguaiana",123482,-29.75,-57.083333 ],
    [ u"br",u"Urupês",10745,-21.216667,-49.283333 ],
    [ u"br",u"Urussanga",10670,-28.516667,-49.316667 ],
    [ u"br",u"Utinga",11949,-10.983333,-42.95 ],
    [ u"br",u"Vacaria",56766,-28.5,-50.933333 ],
    [ u"br",u"Valença do Piauí",15881,-6.4,-41.75 ],
    [ u"br",u"Valença",63233,-13.366667,-39.083333 ],
    [ u"br",u"Valença",61145,-22.241944,-43.701389 ],
    [ u"br",u"Valente",12591,-11.566667,-39.45 ],
    [ u"br",u"Valinhos",88631,-22.95,-47.016667 ],
    [ u"br",u"Valparaíso",15939,-21.216667,-50.85 ],
    [ u"br",u"Vargem Alta",4672,-20.666667,-41 ],
    [ u"br",u"Vargem Grande do Sul",36214,-21.833333,-46.883333 ],
    [ u"br",u"Vargem Grande",21420,-3.55,-43.933333 ],
    [ u"br",u"Varginha",116573,-21.55,-45.433333 ],
    [ u"br",u"Varjota",16462,-4.133333,-40.5 ],
    [ u"br",u"Várzea Alegre",21842,-5.35,-40.383333 ],
    [ u"br",u"Várzea da Palma",28706,-17.6,-44.733333 ],
    [ u"br",u"Várzea Grande",249766,-15.65,-56.133333 ],
    [ u"br",u"Várzea Paulista",110938,-23.2,-46.833333 ],
    [ u"br",u"Varzelândia",6398,-15.7,-44.033333 ],
    [ u"br",u"Vassouras",21175,-22.406111,-43.664167 ],
    [ u"br",u"Vazante",15459,-18,-46.9 ],
    [ u"br",u"Venâncio Aires",40628,-29.6,-52.183333 ],
    [ u"br",u"Vera Cruz",30557,-12.633333,-41.033333 ],
    [ u"br",u"Veranópolis",19862,-28.95,-51.55 ],
    [ u"br",u"Vespasiano",94750,-19.666667,-43.916667 ],
    [ u"br",u"Viamão",285274,-30.083333,-51.033333 ],
    [ u"br",u"Viana",55123,-20.383333,-40.5 ],
    [ u"br",u"Viana",26690,-3.216667,-45 ],
    [ u"br",u"Vianópolis",7807,-16.75,-48.533333 ],
    [ u"br",u"Vicência",10378,-7.666667,-35.333333 ],
    [ u"br",u"Viçosa do Ceará",16637,-3.566667,-41.083333 ],
    [ u"br",u"Viçosa",19574,-9.4,-36.233333 ],
    [ u"br",u"Viçosa",68681,-20.75,-42.883333 ],
    [ u"br",u"Videira",42441,-27,-51.133333 ],
    [ u"br",u"Vigia",29229,-.8,-48.133333 ],
    [ u"br",u"Vila Velha",394937,-20.333333,-40.283333 ],
    [ u"br",u"Vilhena",63237,-12.716667,-60.116667 ],
    [ u"br",u"Vinhedo",56493,-23.016667,-46.983333 ],
    [ u"br",u"Viradouro",17172,-20.883333,-48.3 ],
    [ u"br",u"Visconde do Rio Branco",29010,-21.016667,-42.833333 ],
    [ u"br",u"Viseu",18958,-1.2,-46.116667 ],
    [ u"br",u"Vitória da Conquista",253144,-14.85,-40.85 ],
    [ u"br",u"Vitória de Santo Antão",107385,-8.116667,-35.3 ],
    [ u"br",u"Vitória do Mearim",15775,-3.466667,-44.883333 ],
    [ u"br",u"Vitória",312662,-20.316667,-40.35 ],
    [ u"br",u"Vitorino Freire",13267,-4.066667,-45.166667 ],
    [ u"br",u"Volta Redonda",249584,-22.533333,-44.116667 ],
    [ u"br",u"Votorantim",99392,-23.541318,-47.444671 ],
    [ u"br",u"Wanderlândia",6545,-6.835833,-47.799167 ],
    [ u"br",u"Wenceslau Braz",15726,-23.85,-49.8 ],
    [ u"br",u"Xambioá",9281,-6.4325,-48.381944 ],
    [ u"br",u"Xanxerê",32958,-26.883333,-52.383333 ],
    [ u"br",u"Xapuri",5721,-10.65,-68.516667 ],
    [ u"br",u"Xaxim",21376,-26.933333,-52.516667 ],
    [ u"br",u"Xique-Xique",35435,-10.833333,-42.733333 ],
    [ u"bs",u"Albert Town",25,22.6,-74.35 ],
    [ u"bs",u"Alice Town",950,25.7166667,-79.3 ],
    [ u"bs",u"Andros Town",2456,24.7,-77.7666667 ],
    [ u"bs",u"Clarence Town",1751,23.1,-74.9833333 ],
    [ u"bs",u"Cockburn Town",831,24.0333333,-74.5166667 ],
    [ u"bs",u"Colonel Hill",240,22.7666667,-74.2166667 ],
    [ u"bs",u"Duncan Town",70,22.1908333,-75.7258333 ],
    [ u"bs",u"Dunmore Town",1523,25.5,-76.65 ],
    [ u"bs",u"Freeport",46535,26.5333333,-78.7 ],
    [ u"bs",u"High Rock",3744,26.6208333,-78.2833333 ],
    [ u"bs",u"Marsh Harbour",5314,26.55,-77.05 ],
    [ u"bs",u"Matthew Town",452,20.95,-73.6666667 ],
    [ u"bs",u"Nassau",227936,25.0833333,-77.35 ],
    [ u"bs",u"Nicholls Town",270,25.1333333,-78.0 ],
    [ u"bs",u"Pirates Well",217,22.4333333,-73.0666667 ],
    [ u"bs",u"Port Nelson",91,23.6333333,-74.8333333 ],
    [ u"bs",u"Rock Sound",1396,24.9,-76.2 ],
    [ u"bs",u"Snug Corner",407,22.5333333,-73.8833333 ],
    [ u"bs",u"Sweeting Cay",483,26.6,-77.8833333 ],
    [ u"bt",u"Chhukha",1203,27.0666667,89.5833333 ],
    [ u"bt",u"Damphu",2040,27.0166667,90.1 ],
    [ u"bt",u"Gasa",1612,27.9166667,89.6833333 ],
    [ u"bt",u"Geylegphug",7464,26.85,90.5 ],
    [ u"bt",u"Ha",1505,27.3666667,89.2833333 ],
    [ u"bt",u"Jakar",4829,27.55,90.7333333 ],
    [ u"bt",u"Lhuntshi",1935,27.65,91.15 ],
    [ u"bt",u"Mongar",1397,27.25,91.2 ],
    [ u"bt",u"Paro",4536,27.4333333,89.4166667 ],
    [ u"bt",u"Pemagatsel",1720,27.0333333,91.45 ],
    [ u"bt",u"Phuntsholing",65892,26.85,89.3833333 ],
    [ u"bt",u"Punakha",18170,27.6166667,89.8666667 ],
    [ u"bt",u"Samdrup Jongkhar",14134,26.8166667,91.5666667 ],
    [ u"bt",u"Shemgang",1182,27.2333333,90.65 ],
    [ u"bt",u"Taga Dzong",3168,27.0666667,89.8833333 ],
    [ u"bt",u"Tashigang",4519,27.3166667,91.5666667 ],
    [ u"bt",u"Tongsa",2365,27.5166667,90.5 ],
    [ u"bt",u"Wangdiphodrang",3393,27.4833333,89.9 ],
    [ u"bw",u"Boatlaname",853,-23.6,25.8333333 ],
    [ u"bw",u"Bobonong",18136,-21.9666667,28.3333333 ],
    [ u"bw",u"Bokaa",4131,-24.45,26.0166667 ],
    [ u"bw",u"Bokspits",547,-26.9,20.7 ],
    [ u"bw",u"Bonwapitse",568,-23.0166667,26.6666667 ],
    [ u"bw",u"Dekar",1043,-21.5333333,21.9333333 ],
    [ u"bw",u"Dutlwe",1126,-23.9833333,23.9 ],
    [ u"bw",u"Francistown",89979,-21.1666667,27.5166667 ],
    [ u"bw",u"Gabane",12884,-24.6666667,25.7822222 ],
    [ u"bw",u"Gaborone",208411,-24.6463889,25.9119444 ],
    [ u"bw",u"Ghanzi",12141,-21.5666667,21.7833333 ],
    [ u"bw",u"Gweta",4689,-20.1833333,25.2333333 ],
    [ u"bw",u"Hukuntsi",4403,-24.0,21.75 ],
    [ u"bw",u"Kachikau",961,-18.1666667,24.4666667 ],
    [ u"bw",u"Kalakamati",962,-20.6333333,27.3 ],
    [ u"bw",u"Kalamare",2339,-22.8666667,26.5 ],
    [ u"bw",u"Kang",4229,-23.75,22.8333333 ],
    [ u"bw",u"Kanye",44718,-24.9833333,25.35 ],
    [ u"bw",u"Kasane",9250,-17.8166667,25.15 ],
    [ u"bw",u"Khakhea",2133,-24.65,23.5 ],
    [ u"bw",u"Khudumelapye",2035,-23.8833333,24.75 ],
    [ u"bw",u"Kobojango",1756,-21.8166667,28.7833333 ],
    [ u"bw",u"Kopong",6896,-24.4833333,25.8833333 ],
    [ u"bw",u"Lehututu",1942,-23.9666667,21.8666667 ],
    [ u"bw",u"Lephepe",822,-23.3166667,25.8 ],
    [ u"bw",u"Letlhakane",18137,-21.4166667,25.5833333 ],
    [ u"bw",u"Letlhakeng",6782,-24.0666667,25.0333333 ],
    [ u"bw",u"Lobatse",30883,-25.2166667,25.6666667 ],
    [ u"bw",u"Machaneng",2139,-23.1833333,27.5 ],
    [ u"bw",u"Mahalapye",44473,-23.0666667,26.8333333 ],
    [ u"bw",u"Makalamabedi",376,-20.3333333,23.8166667 ],
    [ u"bw",u"Makaleng",1166,-20.9,27.2833333 ],
    [ u"bw",u"Manyana",3338,-23.4,21.7166667 ],
    [ u"bw",u"Masunga",3640,-20.6666667,27.4166667 ],
    [ u"bw",u"Mathathane",1987,-22.2666667,28.75 ],
    [ u"bw",u"Maunatlala",3361,-22.5666667,27.5666667 ],
    [ u"bw",u"Maun",49948,-19.9833333,23.4166667 ],
    [ u"bw",u"Mmathubudukwane",2221,-24.6,26.4333333 ],
    [ u"bw",u"Mochudi",41834,-24.4166667,26.15 ],
    [ u"bw",u"Mogapi",1917,-22.3333333,27.8333333 ],
    [ u"bw",u"Mogapinyana",1515,-22.3666667,27.6 ],
    [ u"bw",u"Mogoditshane",43417,-24.6269444,25.8655556 ],
    [ u"bw",u"Moiyabana",2768,-22.4333333,26.4166667 ],
    [ u"bw",u"Mokobeng",1822,-22.9833333,27.5833333 ],
    [ u"bw",u"Molepolole",63251,-24.4166667,25.5333333 ],
    [ u"bw",u"Mookane",2397,-23.7333333,26.6333333 ],
    [ u"bw",u"Mopipi",3301,-21.1833333,24.8833333 ],
    [ u"bw",u"Mosetse",1780,-20.75,26.65 ],
    [ u"bw",u"Moshupa",19563,-24.8,25.3833333 ],
    [ u"bw",u"Nata",4794,-20.2166667,26.1833333 ],
    [ u"bw",u"Nkoyaphiri",1578,-24.6322222,25.8313889 ],
    [ u"bw",u"Nokaneng",1763,-19.6666667,22.2666667 ],
    [ u"bw",u"Orapa",9190,-21.2833333,25.3666667 ],
    [ u"bw",u"Otse",6275,-25.0166667,25.7333333 ],
    [ u"bw",u"Palapye",30652,-22.55,27.1333333 ],
    [ u"bw",u"Pandamatenga",1685,-18.2666667,25.65 ],
    [ u"bw",u"Pilane",1277,-24.45,26.1333333 ],
    [ u"bw",u"Pilikwe",1375,-22.7833333,27.2333333 ],
    [ u"bw",u"Ramotswa",21451,-24.8666667,25.8166667 ],
    [ u"bw",u"Ratholo",2377,-22.6833333,27.5833333 ],
    [ u"bw",u"Sebina",3030,-20.8666667,27.25 ],
    [ u"bw",u"Sefophe",4114,-22.1833333,27.9666667 ],
    [ u"bw",u"Sehithwa",1614,-20.4666667,22.7166667 ],
    [ u"bw",u"Sekoma",1083,-24.4,23.8833333 ],
    [ u"bw",u"Serowe",47421,-22.3833333,26.7166667 ],
    [ u"bw",u"Shakawe",5651,-18.3666667,21.85 ],
    [ u"bw",u"Tamasane",1070,-22.3166667,27.3666667 ],
    [ u"bw",u"Thamaga",20757,-24.7166667,25.5333333 ],
    [ u"bw",u"Tobane",1925,-21.95,27.9 ],
    [ u"bw",u"Tonota",17760,-21.4833333,27.4833333 ],
    [ u"bw",u"Tsabong",8326,-26.05,22.45 ],
    [ u"bw",u"Tshane",969,-24.0333333,21.9 ],
    [ u"bw",u"Tsienyane",5222,-21.0166667,24.3333333 ],
    [ u"bw",u"Werda",2149,-25.2666667,23.2833333 ],
    [ u"by",u"Braslav",12378,55.6338889,27.0538889 ],
    [ u"by",u"Brest",300716,52.1,23.7 ],
    [ u"by",u"Disna",2738,55.5666667,28.2166667 ],
    [ u"by",u"Dzerzhinsk",24610,53.685,27.1419444 ],
    [ u"by",u"Gomel",481000,52.4416667,30.9833333 ],
    [ u"by",u"Haradok",13380,55.4602778,30.0 ],
    [ u"by",u"Horki",33897,54.2833333,30.9911111 ],
    [ u"by",u"Hrodna",317366,53.6813889,23.8147222 ],
    [ u"by",u"Ivanava",13614,52.1325,25.5461111 ],
    [ u"by",u"Kleck",9641,53.0652778,26.6416667 ],
    [ u"by",u"Kobryn",50691,52.2161111,24.3663889 ],
    [ u"by",u"Lida",98036,53.8833333,25.2997222 ],
    [ u"by",u"Lyuban",10107,52.8,28.0 ],
    [ u"by",u"Malaryta",9692,51.7833333,24.0833333 ],
    [ u"by",u"Masty",16102,53.4077778,24.5327778 ],
    [ u"by",u"Mazyr",112136,52.05,29.2666667 ],
    [ u"by",u"Minsk",1742123,53.9,27.5666667 ],
    [ u"by",u"Navahrudak",30748,53.6,25.8333333 ],
    [ u"by",u"Orsha",125347,54.5152778,30.4052778 ],
    [ u"by",u"Pastavy",20218,55.1163889,26.8338889 ],
    [ u"by",u"Pinsk",130777,52.1213889,26.0727778 ],
    [ u"by",u"Salihorsk",101614,52.8,27.5333333 ],
    [ u"by",u"Senno",9987,54.8041667,29.7044444 ],
    [ u"by",u"Slonim",51435,53.0866667,25.3219444 ],
    [ u"by",u"Stolin",10491,51.8833333,26.85 ],
    [ u"by",u"Vawkavysk",47300,53.1519444,24.4555556 ],
    [ u"by",u"Zabinka",10921,52.2005556,24.0233333 ],
    [ u"by",u"Zlobin",73089,52.8922222,30.0280556 ],
    [ u"bz",u"Belize",61462,17.4833333,-88.1833333 ],
    [ u"bz",u"Belmopan",13381,17.25,-88.7666667 ],
    [ u"bz",u"Benque Viejo",7092,17.075,-89.1391667 ],
    [ u"bz",u"Corozal",8724,18.3833333,-88.3833333 ],
    [ u"bz",u"Dangriga",10750,16.9666667,-88.2166667 ],
    [ u"bz",u"Orange Walk",15298,18.0666667,-88.55 ],
    [ u"bz",u"Punta Gorda",5026,16.1,-88.8 ],
    [ u"bz",u"San Ignacio",16813,17.1561111,-89.0713889 ],
    [ u"bz",u"San Pedro",8418,17.9166667,-87.95 ],
    [ u"ca",u"Abbotsford",151685,49.05,-122.3 ],
    [ u"ca",u"Acton",8204,43.633333,-80.033333 ],
    [ u"ca",u"Acton Vale",5135,45.633333,-72.566667 ],
    [ u"ca",u"Airdrie",24673,51.266667,-114.016667 ],
    [ u"ca",u"Aklavik",648,68.216667,-135 ],
    [ u"ca",u"Albanel",1087,48.866667,-72.416667 ],
    [ u"ca",u"Alberton",1147,46.8,-64.066667 ],
    [ u"ca",u"Aldergrove",11963,49.06,-122.46 ],
    [ u"ca",u"Alexandria",3559,45.3,-74.633333 ],
    [ u"ca",u"Alfred",1424,45.55,-74.866667 ],
    [ u"ca",u"Alliston",10224,44.15,-79.866667 ],
    [ u"ca",u"Alma",29527,48.55,-71.65 ],
    [ u"ca",u"Almonte",4921,45.216667,-76.2 ],
    [ u"ca",u"Altona",3613,49.1,-97.566667 ],
    [ u"ca",u"Amherst",9336,45.833333,-64.2 ],
    [ u"ca",u"Amherstburg",11459,42.1,-83.1 ],
    [ u"ca",u"Amos",10435,48.566667,-78.116667 ],
    [ u"ca",u"Amqui",5117,48.466667,-67.433333 ],
    [ u"ca",u"Antigonish",5003,45.616667,-61.966667 ],
    [ u"ca",u"Armstrong",4275,50.45,-119.183333 ],
    [ u"ca",u"Arnprior",9607,45.433333,-76.366667 ],
    [ u"ca",u"Arthur",2413,43.833333,-80.533333 ],
    [ u"ca",u"Asbestos",7190,45.783333,-71.933333 ],
    [ u"ca",u"Ashcroft",1796,50.716667,-121.266667 ],
    [ u"ca",u"Assiniboia",2320,49.616667,-105.983333 ],
    [ u"ca",u"Athabasca",2539,54.716667,-113.266667 ],
    [ u"ca",u"Atikokan",3760,48.75,-91.616667 ],
    [ u"ca",u"Attawapiskat",1366,52.916667,-82.433333 ],
    [ u"ca",u"Aylmer",7527,42.783333,-80.983333 ],
    [ u"ca",u"Ayr",3841,43.283333,-80.45 ],
    [ u"ca",u"Bagotville",1081,48.35,-70.883333 ],
    [ u"ca",u"Baie-Comeau",10435,49.216667,-68.15 ],
    [ u"ca",u"Baie-Saint-Paul",4512,47.433333,-70.5 ],
    [ u"ca",u"Banff",7502,51.166667,-115.566667 ],
    [ u"ca",u"Barraute",1180,48.433333,-77.633333 ],
    [ u"ca",u"Barrhead",4430,54.116667,-114.4 ],
    [ u"ca",u"Barrie",182070,44.383333,-79.7 ],
    [ u"ca",u"Bassano",1388,50.783333,-112.466667 ],
    [ u"ca",u"Bathurst",18179,47.6,-65.65 ],
    [ u"ca",u"Bay Roberts",13735,47.583333,-53.3 ],
    [ u"ca",u"Beamsville",9556,43.166667,-79.466667 ],
    [ u"ca",u"Beauceville",4480,46.2,-70.766667 ],
    [ u"ca",u"Beaumont",7366,53.37,-113.41 ],
    [ u"ca",u"Beaupré",5287,47.05,-70.883333 ],
    [ u"ca",u"Beauséjour",2886,50.066667,-96.516667 ],
    [ u"ca",u"Beaverlodge",2219,55.2,-119.45 ],
    [ u"ca",u"Beaverton",3237,44.433333,-79.15 ],
    [ u"ca",u"Bedford",2711,45.116667,-72.983333 ],
    [ u"ca",u"Belleville",65368,44.166667,-77.383333 ],
    [ u"ca",u"Beloeil",43016,45.566667,-73.2 ],
    [ u"ca",u"Berthierville",4411,46.083333,-73.166667 ],
    [ u"ca",u"Berwick",2271,45.033333,-64.733333 ],
    [ u"ca",u"Betsiamites",1652,48.95,-68.65 ],
    [ u"ca",u"Biggar",2068,52.05,-107.983333 ],
    [ u"ca",u"Black Diamond",3663,50.7,-114.233333 ],
    [ u"ca",u"Blackfalds",3198,52.383333,-113.8 ],
    [ u"ca",u"Blairmore",2095,49.6,-114.433333 ],
    [ u"ca",u"Blenheim",5065,42.333333,-82 ],
    [ u"ca",u"Blind River",2966,46.183333,-82.95 ],
    [ u"ca",u"Bobcaygeon",3015,44.533333,-78.55 ],
    [ u"ca",u"Boissevain",1557,49.233333,-100.05 ],
    [ u"ca",u"Bolton",21709,43.883333,-79.733333 ],
    [ u"ca",u"Bon Accord",1611,53.833333,-113.416667 ],
    [ u"ca",u"Bonaventure",1480,48.05,-65.466667 ],
    [ u"ca",u"Bonavista",3658,48.633333,-53.1 ],
    [ u"ca",u"Bonnyville",6003,54.267778,-110.750833 ],
    [ u"ca",u"Botwood",2940,49.15,-55.366667 ],
    [ u"ca",u"Bow Island",1792,49.866667,-111.366667 ],
    [ u"ca",u"Bracebridge",8238,45.033333,-79.3 ],
    [ u"ca",u"Bradford",18811,44.116667,-79.566667 ],
    [ u"ca",u"Brandon",26234,49.833333,-99.95 ],
    [ u"ca",u"Brantford",87761,43.133333,-80.266667 ],
    [ u"ca",u"Bridgetown",1063,44.85,-65.15 ],
    [ u"ca",u"Bridgewater",8070,44.366667,-64.516667 ],
    [ u"ca",u"Brighton",5152,44.033333,-77.733333 ],
    [ u"ca",u"Brockville",23887,44.583333,-75.683333 ],
    [ u"ca",u"Brooks",12745,50.566667,-111.9 ],
    [ u"ca",u"Brownsburg",2597,45.683333,-74.4 ],
    [ u"ca",u"Buckingham",21373,45.583333,-75.416667 ],
    [ u"ca",u"Burgeo",1627,47.6,-57.633333 ],
    [ u"ca",u"Burns Lake",2635,54.216667,-125.766667 ],
    [ u"ca",u"Cabano",2710,47.683333,-68.883333 ],
    [ u"ca",u"Cache Creek",1061,50.8,-121.316667 ],
    [ u"ca",u"Caledon East",2085,43.866667,-79.866667 ],
    [ u"ca",u"Caledonia",9065,43.066667,-79.95 ],
    [ u"ca",u"Calgary",968475,51.083333,-114.083333 ],
    [ u"ca",u"Calmar",2000,53.25,-113.783333 ],
    [ u"ca",u"Campbellford",3882,44.3,-77.8 ],
    [ u"ca",u"Campbell River",33430,50.016667,-125.25 ],
    [ u"ca",u"Campbellton",12064,48,-66.666667 ],
    [ u"ca",u"Camrose",15687,53.016667,-112.816667 ],
    [ u"ca",u"Canmore",12289,51.1,-115.35 ],
    [ u"ca",u"Cannington",2120,44.35,-79.033333 ],
    [ u"ca",u"Canora",2055,51.633333,-102.433333 ],
    [ u"ca",u"Cap-aux-Meules",1686,47.383333,-61.866667 ],
    [ u"ca",u"Cap-Chat",1466,49.083333,-66.683333 ],
    [ u"ca",u"Capreol",3666,46.7,-80.916667 ],
    [ u"ca",u"Caraquet",4620,47.783333,-64.95 ],
    [ u"ca",u"Carberry",1575,49.866667,-99.35 ],
    [ u"ca",u"Carbonear",6814,47.733333,-53.25 ],
    [ u"ca",u"Cardinal",1837,44.783333,-75.366667 ],
    [ u"ca",u"Cardston",3654,49.2,-113.316667 ],
    [ u"ca",u"Carleton Place",9743,45.133333,-76.133333 ],
    [ u"ca",u"Carlyle",1177,49.633333,-102.266667 ],
    [ u"ca",u"Carman",2948,49.5,-98 ],
    [ u"ca",u"Carnduff",950,49.166667,-101.783333 ],
    [ u"ca",u"Caronport",972,50.45,-105.816667 ],
    [ u"ca",u"Carstairs",2370,51.533333,-114.1 ],
    [ u"ca",u"Casselman",3074,45.3,-75.083333 ],
    [ u"ca",u"Castlegar",8715,49.316667,-117.666667 ],
    [ u"ca",u"Catalina",1352,48.516667,-53.083333 ],
    [ u"ca",u"Causapscal",2033,48.35,-67.216667 ],
    [ u"ca",u"Chandler",2863,48.333333,-64.666667 ],
    [ u"ca",u"Channel-Port aux Basques",4220,47.566667,-59.15 ],
    [ u"ca",u"Chapais",1824,49.783333,-74.866667 ],
    [ u"ca",u"Chapleau",2991,47.833333,-83.4 ],
    [ u"ca",u"Charlottetown",42403,46.233333,-63.133333 ],
    [ u"ca",u"Chase",2471,50.816667,-119.683333 ],
    [ u"ca",u"Chatham",44554,42.4,-82.183333 ],
    [ u"ca",u"Chemainus",2718,48.916667,-123.7 ],
    [ u"ca",u"Chesley",1986,44.3,-81.1 ],
    [ u"ca",u"Chester",1531,44.533333,-64.233333 ],
    [ u"ca",u"Chestermere",3590,51.03,-113.83 ],
    [ u"ca",u"Chesterville",1582,45.1,-75.216667 ],
    [ u"ca",u"Chilliwack",51942,49.166667,-121.95 ],
    [ u"ca",u"Chute-aux-Outardes",2000,49.116667,-68.383333 ],
    [ u"ca",u"Clairmont",1483,55.266667,-118.8 ],
    [ u"ca",u"Claresholm",3808,50.033333,-113.583333 ],
    [ u"ca",u"Clermont",2912,47.683333,-70.233333 ],
    [ u"ca",u"Clinton",3292,43.6,-81.533333 ],
    [ u"ca",u"Clyde River",1017,70.45,-68.566667 ],
    [ u"ca",u"Coaldale",6317,49.733333,-112.616667 ],
    [ u"ca",u"Coaticook",7021,45.133333,-71.8 ],
    [ u"ca",u"Cobourg",18100,43.966667,-78.166667 ],
    [ u"ca",u"Cochrane",16367,51.2,-114.45 ],
    [ u"ca",u"Cochrane",4407,49.066667,-81.016667 ],
    [ u"ca",u"Colborne",2155,44.016667,-77.883333 ],
    [ u"ca",u"Colchester",2307,41.983333,-82.933333 ],
    [ u"ca",u"Collingwood",15809,44.5,-80.216667 ],
    [ u"ca",u"Contrecoeur",3587,45.85,-73.233333 ],
    [ u"ca",u"Cookshire",1568,45.416667,-71.616667 ],
    [ u"ca",u"Corner Brook",18693,48.95,-57.933333 ],
    [ u"ca",u"Cornwall",48823,45.016667,-74.733333 ],
    [ u"ca",u"Cornwall",2272,46.24,-63.21 ],
    [ u"ca",u"Courtenay",32793,49.683333,-125 ],
    [ u"ca",u"Cowansville",10888,45.2,-72.75 ],
    [ u"ca",u"Crabtree",2248,45.966667,-73.466667 ],
    [ u"ca",u"Cranbrook",18610,49.516667,-115.766667 ],
    [ u"ca",u"Creemore",1391,44.316667,-80.1 ],
    [ u"ca",u"Creston",4816,49.1,-116.516667 ],
    [ u"ca",u"Crossfield",2512,51.433333,-114.033333 ],
    [ u"ca",u"Crystal Beach",7062,45.05,-79.4 ],
    [ u"ca",u"Cumberland",2630,49.616667,-125.016667 ],
    [ u"ca",u"Dalhousie",4137,48.066667,-66.366667 ],
    [ u"ca",u"Dalmeny",1504,52.333333,-106.783333 ],
    [ u"ca",u"Danville",1761,45.783333,-72.016667 ],
    [ u"ca",u"Dauphin",8418,51.15,-100.05 ],
    [ u"ca",u"Davidson",967,51.266667,-105.966667 ],
    [ u"ca",u"Dawson Creek",10802,55.766667,-120.233333 ],
    [ u"ca",u"Deep River",4296,46.166667,-77.566667 ],
    [ u"ca",u"Deer Lake",4163,49.183333,-57.433333 ],
    [ u"ca",u"Delhi",4227,42.85,-80.5 ],
    [ u"ca",u"Deloraine",1068,49.183333,-100.5 ],
    [ u"ca",u"Desbiens",1147,48.416667,-71.95 ],
    [ u"ca",u"Deseronto",1897,44.2,-77.033333 ],
    [ u"ca",u"Devon",5225,53.366667,-113.733333 ],
    [ u"ca",u"Didsbury",4134,51.666667,-114.133333 ],
    [ u"ca",u"Digby",2052,44.6,-65.75 ],
    [ u"ca",u"Disraeli",2678,45.9,-71.35 ],
    [ u"ca",u"Dolbeau",12916,48.866667,-72.233333 ],
    [ u"ca",u"Donnacona",8014,46.666667,-71.733333 ],
    [ u"ca",u"Drayton Valley",6099,53.216667,-114.983333 ],
    [ u"ca",u"Dresden",2727,42.583333,-82.166667 ],
    [ u"ca",u"Drumheller",6557,51.466667,-112.7 ],
    [ u"ca",u"Drummondville",59489,45.883333,-72.483333 ],
    [ u"ca",u"Dryden",6924,49.783333,-92.833333 ],
    [ u"ca",u"Duncan",22199,48.783333,-123.7 ],
    [ u"ca",u"Dunnville",6006,42.9,-79.616667 ],
    [ u"ca",u"Durham",2861,44.183333,-80.816667 ],
    [ u"ca",u"East Angus",3634,45.483333,-71.666667 ],
    [ u"ca",u"Edmonton",822319,53.55,-113.5 ],
    [ u"ca",u"Edmundston",17937,47.366667,-68.333333 ],
    [ u"ca",u"Edson",7975,53.583333,-116.416667 ],
    [ u"ca",u"Eganville",1299,45.533333,-77.1 ],
    [ u"ca",u"Elk Point",1514,53.9,-110.9 ],
    [ u"ca",u"Elliot Lake",12508,46.383333,-82.65 ],
    [ u"ca",u"Elmira",8614,43.6,-80.55 ],
    [ u"ca",u"Elmvale",2298,44.583333,-79.866667 ],
    [ u"ca",u"Enderby",2830,50.55,-119.133333 ],
    [ u"ca",u"Englehart",1685,47.816667,-79.866667 ],
    [ u"ca",u"Erin",3053,43.766667,-80.066667 ],
    [ u"ca",u"Espanola",4682,46.25,-81.766667 ],
    [ u"ca",u"Essex",7396,42.166667,-82.816667 ],
    [ u"ca",u"Esterhazy",2194,50.65,-102.083333 ],
    [ u"ca",u"Estevan",9904,49.15,-103 ],
    [ u"ca",u"Eston",979,51.15,-108.75 ],
    [ u"ca",u"Exeter",4702,43.35,-81.483333 ],
    [ u"ca",u"Fairview",3312,56.066667,-118.4 ],
    [ u"ca",u"Farnham",6061,45.283333,-72.966667 ],
    [ u"ca",u"Fenelon Falls",1979,44.533333,-78.75 ],
    [ u"ca",u"Fergus",17673,43.7,-80.366667 ],
    [ u"ca",u"Ferme-Neuve",2115,46.7,-75.45 ],
    [ u"ca",u"Fernie",5019,49.5,-115.066667 ],
    [ u"ca",u"Flin Flon",6002,54.766667,-101.883333 ],
    [ u"ca",u"Foam Lake",1138,51.65,-103.533333 ],
    [ u"ca",u"Forest",3018,43.1,-82 ],
    [ u"ca",u"Forestville",3570,48.733333,-69.066667 ],
    [ u"ca",u"Fort Erie",15953,42.9,-78.933333 ],
    [ u"ca",u"Fort Frances",7931,48.616667,-93.416667 ],
    [ u"ca",u"Fort Nelson",4207,58.816667,-122.533333 ],
    [ u"ca",u"Fort Saint James",2392,54.433333,-124.25 ],
    [ u"ca",u"Fort Saint John",16656,56.25,-120.833333 ],
    [ u"ca",u"Fredericton",52337,45.95,-66.633333 ],
    [ u"ca",u"Fruitvale",3790,49.116667,-117.55 ],
    [ u"ca",u"Gambo",1614,48.783333,-54.216667 ],
    [ u"ca",u"Gananoque",5458,44.333333,-76.166667 ],
    [ u"ca",u"Gander",8772,48.95,-54.55 ],
    [ u"ca",u"Gaspé",3331,48.833333,-64.483333 ],
    [ u"ca",u"Georgetown",32372,43.65,-79.933333 ],
    [ u"ca",u"Geraldton",2349,49.716667,-86.966667 ],
    [ u"ca",u"Gibsons",6821,49.4,-123.5 ],
    [ u"ca",u"Gimli",2009,50.633333,-97 ],
    [ u"ca",u"Glace Bay",21504,46.2,-59.966667 ],
    [ u"ca",u"Glencoe",2273,42.75,-81.7 ],
    [ u"ca",u"Goderich",8032,43.733333,-81.7 ],
    [ u"ca",u"Golden",4038,51.3,-116.966667 ],
    [ u"ca",u"Granby",53979,45.383333,-72.733333 ],
    [ u"ca",u"Grand Bank",4623,47.1,-55.783333 ],
    [ u"ca",u"Grand Bend",2059,43.316667,-81.75 ],
    [ u"ca",u"Grand Centre",12386,54.416667,-110.215278 ],
    [ u"ca",u"Grande Prairie",41463,55.166667,-118.8 ],
    [ u"ca",u"Grande-Rivière",1508,48.383333,-64.5 ],
    [ u"ca",u"Grand Falls",5675,47.05,-67.733333 ],
    [ u"ca",u"Grand Forks",4208,49.05,-118.466667 ],
    [ u"ca",u"Grand Valley",1856,43.9,-80.316667 ],
    [ u"ca",u"Gravelbourg",1109,49.883333,-106.55 ],
    [ u"ca",u"Gravenhurst",5839,44.916667,-79.366667 ],
    [ u"ca",u"Grenfell",997,50.416667,-102.916667 ],
    [ u"ca",u"Grimshaw",2560,56.183333,-117.6 ],
    [ u"ca",u"Guelph",115763,43.55,-80.25 ],
    [ u"ca",u"Gull Lake",949,50.1,-108.483333 ],
    [ u"ca",u"Hagersville",2624,42.95,-80.05 ],
    [ u"ca",u"Haileybury",10991,47.433333,-79.633333 ],
    [ u"ca",u"Haines Junction",1148,60.75,-137.5 ],
    [ u"ca",u"Halifax",266012,44.65,-63.6 ],
    [ u"ca",u"Hamilton",653637,43.25,-79.833333 ],
    [ u"ca",u"Hampton",2637,45.533333,-65.833333 ],
    [ u"ca",u"Hanna",3140,51.633333,-111.916667 ],
    [ u"ca",u"Hanover",7255,44.15,-81.033333 ],
    [ u"ca",u"Hantsport",1253,45.066667,-64.183333 ],
    [ u"ca",u"Harbour Breton",1898,47.483333,-55.833333 ],
    [ u"ca",u"Hare Bay",968,48.85,-54.016667 ],
    [ u"ca",u"Harriston",2148,43.916667,-80.883333 ],
    [ u"ca",u"Harrow",3100,42.033333,-82.916667 ],
    [ u"ca",u"Hastings",1276,44.3,-77.95 ],
    [ u"ca",u"Hauterive",12816,49.183333,-68.266667 ],
    [ u"ca",u"Havelock",1403,44.433333,-77.883333 ],
    [ u"ca",u"Havre-Saint-Pierre",2966,50.25,-63.583333 ],
    [ u"ca",u"Hawkesbury",12283,45.616667,-74.6 ],
    [ u"ca",u"Hay River",3030,60.85,-115.7 ],
    [ u"ca",u"Hearst",4746,49.7,-83.666667 ],
    [ u"ca",u"Hébertville",1691,48.4,-71.683333 ],
    [ u"ca",u"Hensall",1261,43.433333,-81.5 ],
    [ u"ca",u"High Level",3621,58.516667,-117.133333 ],
    [ u"ca",u"High Prairie",2878,55.433333,-116.483333 ],
    [ u"ca",u"High River",9826,50.583333,-113.866667 ],
    [ u"ca",u"Hinton",9889,53.4,-117.583333 ],
    [ u"ca",u"Hope",4598,49.383333,-121.433333 ],
    [ u"ca",u"Hornepayne",1386,49.216667,-84.783333 ],
    [ u"ca",u"Houston",2884,54.4,-126.65 ],
    [ u"ca",u"Hudson Bay",1661,52.85,-102.383333 ],
    [ u"ca",u"Humboldt",4822,52.2,-105.116667 ],
    [ u"ca",u"Huntingdon",2865,45.083333,-74.183333 ],
    [ u"ca",u"Huntsville",7972,45.333333,-79.216667 ],
    [ u"ca",u"Indian Head",1642,50.533333,-103.666667 ],
    [ u"ca",u"Ingersoll",11874,43.033333,-80.883333 ],
    [ u"ca",u"Inuvik",3022,68.35,-133.7 ],
    [ u"ca",u"Invermere",2871,50.5,-116.033333 ],
    [ u"ca",u"Inverness",1639,46.233333,-61.283333 ],
    [ u"ca",u"Iqaluit",6124,63.733333,-68.5 ],
    [ u"ca",u"Iroquois Falls",4232,48.766667,-80.666667 ],
    [ u"ca",u"Iroquois",1297,44.85,-75.316667 ],
    [ u"ca",u"Irricana",1091,51.316667,-113.616667 ],
    [ u"ca",u"Jasper",3907,52.883333,-118.083333 ],
    [ u"ca",u"Joliette",34772,46.033333,-73.433333 ],
    [ u"ca",u"Kamloops",68715,50.666667,-120.333333 ],
    [ u"ca",u"Kamsack",1877,51.566667,-101.9 ],
    [ u"ca",u"Kanata",93541,45.333333,-75.9 ],
    [ u"ca",u"Kapuskasing",9240,49.416667,-82.433333 ],
    [ u"ca",u"Kedgwick",1146,47.633333,-67.333333 ],
    [ u"ca",u"Kelowna",125110,49.9,-119.483333 ],
    [ u"ca",u"Kelvington",941,52.166667,-103.516667 ],
    [ u"ca",u"Kemptville",4229,45.016667,-75.633333 ],
    [ u"ca",u"Kenora",13075,49.766667,-94.466667 ],
    [ u"ca",u"Kensington",1424,46.433333,-63.65 ],
    [ u"ca",u"Kentville",12636,45.066667,-64.5 ],
    [ u"ca",u"Kerrobert",1038,51.916667,-109.133333 ],
    [ u"ca",u"Killam",1056,52.783333,-111.85 ],
    [ u"ca",u"Killarney",2362,49.183333,-99.666667 ],
    [ u"ca",u"Kimberley",6513,49.683333,-115.983333 ],
    [ u"ca",u"Kincardine",6771,44.166667,-81.633333 ],
    [ u"ca",u"Kindersley",4249,51.466667,-109.133333 ],
    [ u"ca",u"Kingston",114243,44.233333,-76.483333 ],
    [ u"ca",u"Kirkland Lake",7776,48.15,-80.033333 ],
    [ u"ca",u"Kitchener",409111,43.45,-80.5 ],
    [ u"ca",u"Kitimat",10278,54,-128.7 ],
    [ u"ca",u"Labelle",1239,46.283333,-74.733333 ],
    [ u"ca",u"Lac-au-Saumon",1198,48.416667,-67.333333 ],
    [ u"ca",u"Lac du Bonnet",1134,50.266667,-96.05 ],
    [ u"ca",u"Lachute",9562,45.65,-74.333333 ],
    [ u"ca",u"Lac-Mégantic",4658,45.583333,-70.883333 ],
    [ u"ca",u"Lacolle",1528,45.083333,-73.366667 ],
    [ u"ca",u"Lacombe",10059,52.466667,-113.733333 ],
    [ u"ca",u"Ladysmith",8740,48.983333,-123.816667 ],
    [ u"ca",u"Lake Cowichan",2870,48.816667,-124.033333 ],
    [ u"ca",u"Lakefield",2888,44.433333,-78.266667 ],
    [ u"ca",u"La Malbaie",4447,47.65,-70.166667 ],
    [ u"ca",u"Lamont",1779,53.75,-112.783333 ],
    [ u"ca",u"Langenburg",1034,50.833333,-101.7 ],
    [ u"ca",u"Langham",1070,52.366667,-106.966667 ],
    [ u"ca",u"Lanigan",1204,51.85,-105.033333 ],
    [ u"ca",u"La Ronge",3071,55.1,-105.3 ],
    [ u"ca",u"La Sarre",7206,48.8,-79.2 ],
    [ u"ca",u"La Tuque",9503,47.45,-72.783333 ],
    [ u"ca",u"Laurentides",4922,45.85,-73.766667 ],
    [ u"ca",u"Lavaltrie",8762,45.883333,-73.283333 ],
    [ u"ca",u"Leamington",30428,42.05,-82.583333 ],
    [ u"ca",u"Leduc",15562,53.266667,-113.533333 ],
    [ u"ca",u"Les Escoumins",2042,48.35,-69.416667 ],
    [ u"ca",u"Lethbridge",70619,49.7,-112.833333 ],
    [ u"ca",u"Lewisporte",2935,49.233333,-55.066667 ],
    [ u"ca",u"Lillooet",2585,50.683333,-121.933333 ],
    [ u"ca",u"Lindsay",17987,44.35,-78.733333 ],
    [ u"ca",u"Linière",2167,46.05,-70.516667 ],
    [ u"ca",u"Listowel",6237,43.733333,-80.966667 ],
    [ u"ca",u"Little Current",1652,45.966667,-81.933333 ],
    [ u"ca",u"Lively",7081,46.433333,-81.15 ],
    [ u"ca",u"Liverpool",2781,44.033333,-64.716667 ],
    [ u"ca",u"Lloydminster",22677,53.27,-110.03 ],
    [ u"ca",u"Lloydminster",22677,53.283333,-110 ],
    [ u"ca",u"Logan Lake",2190,50.48,-120.81 ],
    [ u"ca",u"London",346774,42.983333,-81.25 ],
    [ u"ca",u"Longlac",1846,49.783333,-86.55 ],
    [ u"ca",u"Louisbourg",1031,45.916667,-59.983333 ],
    [ u"ca",u"Louiseville",5819,46.25,-72.933333 ],
    [ u"ca",u"Lucan",2123,43.183333,-81.4 ],
    [ u"ca",u"Luceville",1373,48.516667,-68.333333 ],
    [ u"ca",u"Lucknow",1275,43.95,-81.516667 ],
    [ u"ca",u"Lumby",1625,50.25,-118.966667 ],
    [ u"ca",u"Lumsden",1477,50.65,-104.866667 ],
    [ u"ca",u"Lunenburg",2473,44.366667,-64.316667 ],
    [ u"ca",u"Macamic",1559,48.766667,-79 ],
    [ u"ca",u"Mackenzie",4978,55.33,-123.09 ],
    [ u"ca",u"Macklin",1257,52.333333,-109.95 ],
    [ u"ca",u"Madoc",1827,44.516667,-77.483333 ],
    [ u"ca",u"Magog",15550,45.266667,-72.15 ],
    [ u"ca",u"Magrath",2095,49.416667,-112.883333 ],
    [ u"ca",u"Malartic",3710,48.133333,-78.116667 ],
    [ u"ca",u"Manitouwadge",3115,49.133333,-85.8 ],
    [ u"ca",u"Maniwaki",4236,46.366667,-75.966667 ],
    [ u"ca",u"Maple Creek",2121,49.916667,-109.466667 ],
    [ u"ca",u"Marathon",4627,48.75,-86.366667 ],
    [ u"ca",u"Marieville",5600,45.433333,-73.166667 ],
    [ u"ca",u"Markdale",1514,44.316667,-80.65 ],
    [ u"ca",u"Marmora",1678,44.483333,-77.683333 ],
    [ u"ca",u"Marystown",4558,47.166667,-55.166667 ],
    [ u"ca",u"Maskinongé",1105,46.216667,-73.016667 ],
    [ u"ca",u"Matagami",1966,49.75,-77.633333 ],
    [ u"ca",u"Matane",11826,48.85,-67.516667 ],
    [ u"ca",u"Mattawa",2415,46.316667,-78.7 ],
    [ u"ca",u"Mayo",540,63.6,-135.916667 ],
    [ u"ca",u"Meadow Lake",4281,54.129722,-108.434722 ],
    [ u"ca",u"Meaford",4816,44.6,-80.583333 ],
    [ u"ca",u"Medicine Hat",63140,50.033333,-110.683333 ],
    [ u"ca",u"Melfort",5410,52.866667,-104.6 ],
    [ u"ca",u"Melita",1167,49.266667,-100.983333 ],
    [ u"ca",u"Melville",4279,50.933333,-102.8 ],
    [ u"ca",u"Merritt",7179,50.116667,-120.783333 ],
    [ u"ca",u"Metabetchouan",2329,48.433333,-71.866667 ],
    [ u"ca",u"Middleton",1680,44.95,-65.066667 ],
    [ u"ca",u"Midland",31502,44.75,-79.9 ],
    [ u"ca",u"Mildmay",1258,44.033333,-81.116667 ],
    [ u"ca",u"Millbrook",1550,44.15,-78.45 ],
    [ u"ca",u"Millet",2142,53.083333,-113.466667 ],
    [ u"ca",u"Milton",23472,43.516667,-79.883333 ],
    [ u"ca",u"Milverton",1803,43.566667,-80.933333 ],
    [ u"ca",u"Minnedosa",2526,50.25,-99.833333 ],
    [ u"ca",u"Mitchell",4416,43.466667,-81.183333 ],
    [ u"ca",u"Moncton",87467,46.083333,-64.766667 ],
    [ u"ca",u"Montague",2005,46.166667,-62.65 ],
    [ u"ca",u"Mont-Joli",6124,48.583333,-68.183333 ],
    [ u"ca",u"Montmagny",9645,46.966667,-70.55 ],
    [ u"ca",u"Montreal",3268513,45.5,-73.583333 ],
    [ u"ca",u"Moose Factory",2060,51.25,-80.6 ],
    [ u"ca",u"Moose Jaw",32166,50.4,-105.55 ],
    [ u"ca",u"Moosomin",2206,50.15,-101.666667 ],
    [ u"ca",u"Morden",6395,49.183333,-98.1 ],
    [ u"ca",u"Morinville",8108,53.8,-113.65 ],
    [ u"ca",u"Morrisburg",2728,44.9,-75.183333 ],
    [ u"ca",u"Morris",1742,49.35,-97.366667 ],
    [ u"ca",u"Mount Forest",4842,43.966667,-80.733333 ],
    [ u"ca",u"Murdochville",1139,48.966667,-65.516667 ],
    [ u"ca",u"Nakusp",1706,50.233333,-117.8 ],
    [ u"ca",u"Nanaimo",84906,49.15,-123.916667 ],
    [ u"ca",u"Nanticoke",24732,42.8,-80.066667 ],
    [ u"ca",u"Nanton",1936,50.35,-113.766667 ],
    [ u"ca",u"Napanee",8197,44.25,-76.95 ],
    [ u"ca",u"Napierville",3124,45.183333,-73.4 ],
    [ u"ca",u"Neepawa",3151,50.233333,-99.45 ],
    [ u"ca",u"Nelson",9813,49.483333,-117.283333 ],
    [ u"ca",u"New Glasgow",20322,45.583333,-62.633333 ],
    [ u"ca",u"New Richmond",2213,48.166667,-65.833333 ],
    [ u"ca",u"New Waterford",11026,46.25,-60.083333 ],
    [ u"ca",u"Nicolet",5257,46.216667,-72.6 ],
    [ u"ca",u"Nipawin",3994,53.366667,-104.016667 ],
    [ u"ca",u"Normandin",2728,48.833333,-72.516667 ],
    [ u"ca",u"Norman Wells",1027,65.283333,-126.85 ],
    [ u"ca",u"North Battleford",19440,52.766667,-108.283333 ],
    [ u"ca",u"North Bay",50171,46.3,-79.45 ],
    [ u"ca",u"Norwich",2651,42.983333,-80.6 ],
    [ u"ca",u"Norwood",1746,44.383333,-77.983333 ],
    [ u"ca",u"Notre-Dame-du-Lac",1545,47.6,-68.8 ],
    [ u"ca",u"Okotoks",14827,50.716667,-113.966667 ],
    [ u"ca",u"Olds",6947,51.783333,-114.1 ],
    [ u"ca",u"Oliver",4647,49.183333,-119.55 ],
    [ u"ca",u"Omemee",1393,44.3,-78.55 ],
    [ u"ca",u"One Hundred Mile House",1737,51.65,-121.283333 ],
    [ u"ca",u"Orangeville",32641,43.916667,-80.083333 ],
    [ u"ca",u"Orillia",30179,44.6,-79.416667 ],
    [ u"ca",u"Ormstown",1562,45.133333,-74 ],
    [ u"ca",u"Oromocto",8998,45.85,-66.466667 ],
    [ u"ca",u"Oshawa",247989,43.9,-78.866667 ],
    [ u"ca",u"Osoyoos",4314,49.033333,-119.466667 ],
    [ u"ca",u"Ottawa",874433,45.416667,-75.7 ],
    [ u"ca",u"Outlook",1989,51.5,-107.05 ],
    [ u"ca",u"Owen Sound",22625,44.566667,-80.85 ],
    [ u"ca",u"Oxbow",1058,49.216667,-102.166667 ],
    [ u"ca",u"Oxford",1283,45.733333,-63.866667 ],
    [ u"ca",u"Paisley",1091,44.3,-81.283333 ],
    [ u"ca",u"Palmerston",2660,43.833333,-80.85 ],
    [ u"ca",u"Pangnirtung",1320,66.133333,-65.75 ],
    [ u"ca",u"Papineauville",1600,45.616667,-75.016667 ],
    [ u"ca",u"Paris",10437,43.2,-80.383333 ],
    [ u"ca",u"Parkhill",1851,43.166667,-81.683333 ],
    [ u"ca",u"Parksville",21150,49.3,-124.316667 ],
    [ u"ca",u"Parrsboro",1472,45.4,-64.316667 ],
    [ u"ca",u"Parry Sound",6469,45.333333,-80.033333 ],
    [ u"ca",u"Peace River",5340,56.233333,-117.283333 ],
    [ u"ca",u"Peachland",1305,49.766667,-119.75 ],
    [ u"ca",u"Pemberton",1644,50.316667,-122.816667 ],
    [ u"ca",u"Pembroke",15551,45.816667,-77.116667 ],
    [ u"ca",u"Penhold",1818,52.133333,-113.866667 ],
    [ u"ca",u"Penticton",37721,49.5,-119.583333 ],
    [ u"ca",u"Perth",6481,44.883333,-76.233333 ],
    [ u"ca",u"Petawawa",11256,45.9,-77.283333 ],
    [ u"ca",u"Peterborough",75879,44.3,-78.333333 ],
    [ u"ca",u"Petrolia",5453,42.883333,-82.15 ],
    [ u"ca",u"Picton",4820,44.016667,-77.15 ],
    [ u"ca",u"Pictou",3732,45.666667,-62.7 ],
    [ u"ca",u"Pierreville",2172,46.066667,-72.8 ],
    [ u"ca",u"Pilot Butte",1728,50.466667,-104.416667 ],
    [ u"ca",u"Pinawa",1562,50.15,-95.883333 ],
    [ u"ca",u"Pincher Creek",3855,49.483333,-113.95 ],
    [ u"ca",u"Plaster Rock",1180,46.9,-67.383333 ],
    [ u"ca",u"Plessisville",7186,46.216667,-71.766667 ],
    [ u"ca",u"Ponoka",6656,52.683333,-113.566667 ],
    [ u"ca",u"Pont-Rouge",4978,46.75,-71.7 ],
    [ u"ca",u"Port Alberni",21282,49.233333,-124.8 ],
    [ u"ca",u"Port-Cartier",5851,50.016667,-66.866667 ],
    [ u"ca",u"Port Dover",5838,42.783333,-80.2 ],
    [ u"ca",u"Port Elgin",7147,44.433333,-81.383333 ],
    [ u"ca",u"Port Hardy",4628,50.716667,-127.5 ],
    [ u"ca",u"Port Hawkesbury",3564,45.6,-61.35 ],
    [ u"ca",u"Port Hope",11765,43.95,-78.3 ],
    [ u"ca",u"Portneuf",2694,46.683333,-71.883333 ],
    [ u"ca",u"Port Perry",7652,44.1,-78.933333 ],
    [ u"ca",u"Port Stanley",2663,42.666667,-81.216667 ],
    [ u"ca",u"Powassan",1243,46.066667,-79.35 ],
    [ u"ca",u"Powell River",12779,49.883333,-124.55 ],
    [ u"ca",u"Preeceville",1003,51.95,-102.666667 ],
    [ u"ca",u"Prescott",4466,44.716667,-75.516667 ],
    [ u"ca",u"Price",1830,48.6,-68.116667 ],
    [ u"ca",u"Prince Albert",34608,53.2,-105.75 ],
    [ u"ca",u"Prince George",65558,53.916667,-122.766667 ],
    [ u"ca",u"Prince Rupert",14708,54.316667,-130.333333 ],
    [ u"ca",u"Princeton",2706,49.45,-120.5 ],
    [ u"ca",u"Princeville",4041,46.166667,-71.883333 ],
    [ u"ca",u"Provost",2082,52.35,-110.266667 ],
    [ u"ca",u"Quebec",645623,46.8,-71.25 ],
    [ u"ca",u"Quesnel",13788,52.983333,-122.483333 ],
    [ u"ca",u"Rawdon",4978,46.033333,-73.7 ],
    [ u"ca",u"Raymond",3365,49.466667,-112.666667 ],
    [ u"ca",u"Red Deer",73595,52.266667,-113.8 ],
    [ u"ca",u"Redwater",2284,46.9,-79.633333 ],
    [ u"ca",u"Regina",176182,50.45,-104.616667 ],
    [ u"ca",u"Renfrew",8018,45.466667,-76.683333 ],
    [ u"ca",u"Revelstoke",7533,51,-118.183333 ],
    [ u"ca",u"Richmond",3472,45.183333,-75.833333 ],
    [ u"ca",u"Richmond",3485,45.666667,-72.15 ],
    [ u"ca",u"Ridgetown",3547,42.433333,-81.883333 ],
    [ u"ca",u"Rigaud",2525,45.466667,-74.3 ],
    [ u"ca",u"Rimbey",2227,52.633333,-114.216667 ],
    [ u"ca",u"Rimouski",38420,48.433333,-68.516667 ],
    [ u"ca",u"Rivers",1165,50.033333,-100.216667 ],
    [ u"ca",u"Riviere-au-Renard",2565,48.983333,-64.383333 ],
    [ u"ca",u"Rivière-du-Loup",15219,47.833333,-69.533333 ],
    [ u"ca",u"Roberval",9287,48.516667,-72.216667 ],
    [ u"ca",u"Roblin",1903,51.233333,-101.35 ],
    [ u"ca",u"Rockland",9023,45.533333,-75.283333 ],
    [ u"ca",u"Rocky Mountain House",6527,52.366667,-114.916667 ],
    [ u"ca",u"Rodney",1164,42.566667,-81.683333 ],
    [ u"ca",u"Rosetown",2309,51.55,-107.983333 ],
    [ u"ca",u"Rossland",3619,49.083333,-117.816667 ],
    [ u"ca",u"Sackville",2891,45.883333,-64.35 ],
    [ u"ca",u"Saint-Agapit",2048,46.566667,-71.433333 ],
    [ u"ca",u"Saint-Alexandre",1139,47.683333,-69.633333 ],
    [ u"ca",u"Saint-Ambroise",2015,48.55,-71.316667 ],
    [ u"ca",u"Saint-André-Avellin",1868,45.716667,-75.05 ],
    [ u"ca",u"Saint Andrews",1809,45.066667,-67.033333 ],
    [ u"ca",u"Saint-Anselme",1861,46.616667,-70.966667 ],
    [ u"ca",u"Saint Anthony",2492,51.383333,-55.6 ],
    [ u"ca",u"Saint-Augustin",3961,51.233333,-58.65 ],
    [ u"ca",u"Saint-Césaire",3175,45.4,-73 ],
    [ u"ca",u"Saint-Denis",1067,45.783333,-73.15 ],
    [ u"ca",u"Saint-Donat-de-Montcalm",1685,46.316667,-74.216667 ],
    [ u"ca",u"Sainte-Adèle",5467,45.95,-74.15 ],
    [ u"ca",u"Sainte-Agathe-des-Monts",5706,46.033333,-74.283333 ],
    [ u"ca",u"Sainte-Anne-des-Monts",5602,49.116667,-66.483333 ],
    [ u"ca",u"Sainte-Claire",2565,46.6,-70.85 ],
    [ u"ca",u"Sainte-Julienne",3211,45.966667,-73.716667 ],
    [ u"ca",u"Sainte-Marie",8735,46.433333,-71.016667 ],
    [ u"ca",u"Sainte-Martine",2535,45.233333,-73.8 ],
    [ u"ca",u"Sainte-Thècle",1340,46.8,-72.5 ],
    [ u"ca",u"Saint-Fabien",1157,48.283333,-68.866667 ],
    [ u"ca",u"Saint-Félicien",8088,48.65,-72.45 ],
    [ u"ca",u"Saint-Félix-de-Valois",3165,46.166667,-73.416667 ],
    [ u"ca",u"Saint-Gabriel",2901,46.283333,-73.366667 ],
    [ u"ca",u"Saint-Gédéon",1859,48.483333,-71.783333 ],
    [ u"ca",u"Saint-Georges",21416,46.116667,-70.666667 ],
    [ u"ca",u"Saint-Germain-de-Grantham",2145,45.833333,-72.566667 ],
    [ u"ca",u"Saint-Henri-de-Lévis",1380,46.683333,-71.066667 ],
    [ u"ca",u"Saint-Honoré",1742,47.716667,-69.133333 ],
    [ u"ca",u"Saint-Hyacinthe",50327,45.633333,-72.933333 ],
    [ u"ca",u"Saint-Jacques",2985,45.95,-73.583333 ],
    [ u"ca",u"Saint-Jean-de-Dieu",1161,48.016667,-69.05 ],
    [ u"ca",u"Saint-Jean-Port-Joli",1929,47.2,-70.266667 ],
    [ u"ca",u"Saint-Jérôme",54948,45.766667,-74 ],
    [ u"ca",u"Saint John",87857,45.266667,-66.066667 ],
    [ u"ca",u"Saint-Jovite",4020,46.116667,-74.583333 ],
    [ u"ca",u"Saint Leonard",1350,47.166667,-67.916667 ],
    [ u"ca",u"Saint-Marc-des-Carrières",2358,46.683333,-72.033333 ],
    [ u"ca",u"Saint Marys",6647,43.25,-81.133333 ],
    [ u"ca",u"Saint-Michel-des-Saints",1835,46.666667,-73.916667 ],
    [ u"ca",u"Saint-Pacôme",1371,47.416667,-69.95 ],
    [ u"ca",u"Saint-Pascal",2465,47.516667,-69.816667 ],
    [ u"ca",u"Saint Paul",5321,53.983333,-111.283333 ],
    [ u"ca",u"Saint-Pie",3034,45.5,-72.9 ],
    [ u"ca",u"Saint-Prosper",3095,46.2,-70.483333 ],
    [ u"ca",u"Saint Quentin",2207,47.5,-67.383333 ],
    [ u"ca",u"Saint-Raphaël",1276,46.783333,-70.75 ],
    [ u"ca",u"Saint-Raymond",3570,46.883333,-71.833333 ],
    [ u"ca",u"Saint-Rémi",4192,45.25,-73.6 ],
    [ u"ca",u"Saint-Sauveur-des-Monts",4869,45.9,-74.166667 ],
    [ u"ca",u"Saint Stephen",4518,45.2,-67.266667 ],
    [ u"ca",u"Saint Thomas",38694,42.783333,-81.183333 ],
    [ u"ca",u"Saint-Tite",2456,46.716667,-72.566667 ],
    [ u"ca",u"Salaberry-de-Valleyfield",38662,45.25,-74.133333 ],
    [ u"ca",u"Salisbury",1891,46.033333,-65.05 ],
    [ u"ca",u"Salmon Arm",10093,50.7,-119.283333 ],
    [ u"ca",u"Salmo",1125,49.2,-117.283333 ],
    [ u"ca",u"Sarnia",82998,42.966667,-82.4 ],
    [ u"ca",u"Saskatoon",198957,52.133333,-106.666667 ],
    [ u"ca",u"Sault Sainte Marie",63967,46.5,-84.333333 ],
    [ u"ca",u"Sayabec",1702,48.55,-67.683333 ],
    [ u"ca",u"Seaforth",2843,43.55,-81.383333 ],
    [ u"ca",u"Sechelt",5977,49.466667,-123.766667 ],
    [ u"ca",u"Selkirk",9653,50.15,-96.883333 ],
    [ u"ca",u"Senneterre",3228,48.4,-77.25 ],
    [ u"ca",u"Sept-Îles",22582,50.2,-66.383333 ],
    [ u"ca",u"Sexsmith",1743,55.35,-118.783333 ],
    [ u"ca",u"Shaunavon",1658,49.65,-108.416667 ],
    [ u"ca",u"Shawinigan",49161,46.55,-72.733333 ],
    [ u"ca",u"Shawville",1608,45.6,-76.483333 ],
    [ u"ca",u"Shediac",4735,46.216667,-64.533333 ],
    [ u"ca",u"Shelburne",1939,43.766667,-65.316667 ],
    [ u"ca",u"Shelburne",4390,44.066667,-80.2 ],
    [ u"ca",u"Shellbrook",1192,53.216667,-106.4 ],
    [ u"ca",u"Sherbrooke",129447,45.4,-71.9 ],
    [ u"ca",u"Sicamous",2732,50.833333,-119 ],
    [ u"ca",u"Simcoe",13446,42.833333,-80.3 ],
    [ u"ca",u"Sioux Lookout",3730,50.1,-91.916667 ],
    [ u"ca",u"Slave Lake",7661,55.283333,-114.783333 ],
    [ u"ca",u"Smithers",5438,54.766667,-127.166667 ],
    [ u"ca",u"Smiths Falls",10553,44.9,-76.016667 ],
    [ u"ca",u"Smithville",3504,43.1,-79.533333 ],
    [ u"ca",u"Smoky Lake",1063,54.113056,-112.473611 ],
    [ u"ca",u"Sooke",6145,48.383333,-123.733333 ],
    [ u"ca",u"Sorel",33591,46.05,-73.116667 ],
    [ u"ca",u"Souris",1752,49.616667,-100.25 ],
    [ u"ca",u"Souris",1284,46.35,-62.25 ],
    [ u"ca",u"Southampton",3549,44.5,-81.366667 ],
    [ u"ca",u"South River",1193,45.85,-79.366667 ],
    [ u"ca",u"Spirit River",1157,55.783333,-118.833333 ],
    [ u"ca",u"Springdale",2779,49.483333,-56.1 ],
    [ u"ca",u"Springhill",3940,45.633333,-64.05 ],
    [ u"ca",u"Spruce Grove",17767,53.533333,-113.916667 ],
    [ u"ca",u"Stayner",4104,44.416667,-80.083333 ],
    [ u"ca",u"Steinbach",9607,49.516667,-96.683333 ],
    [ u"ca",u"Stephenville Crossing",1183,48.516667,-58.416667 ],
    [ u"ca",u"Stephenville",6278,48.55,-58.566667 ],
    [ u"ca",u"Stettler",5494,52.333333,-112.683333 ],
    [ u"ca",u"Stirling",2270,44.3,-77.55 ],
    [ u"ca",u"Stonewall",4177,50.133333,-97.316667 ],
    [ u"ca",u"Stony Mountain",1770,50.066667,-97.216667 ],
    [ u"ca",u"Stony Plain",8939,53.533333,-114 ],
    [ u"ca",u"Stratford",30234,43.366667,-80.983333 ],
    [ u"ca",u"Strathmore",10009,51.04,-113.42 ],
    [ u"ca",u"Strathroy",13525,42.95,-81.616667 ],
    [ u"ca",u"Sturgeon Falls",6314,46.366667,-79.933333 ],
    [ u"ca",u"Sudbury",109724,46.5,-80.966667 ],
    [ u"ca",u"Summerland",6292,49.6,-119.666667 ],
    [ u"ca",u"Summerside",14808,46.4,-63.783333 ],
    [ u"ca",u"Sussex",4048,45.716667,-65.516667 ],
    [ u"ca",u"Sutton",6680,44.3,-79.366667 ],
    [ u"ca",u"Swan River",4198,52.1,-101.266667 ],
    [ u"ca",u"Swift Current",14702,50.283333,-107.766667 ],
    [ u"ca",u"Sydney Mines",15474,46.233333,-60.216667 ],
    [ u"ca",u"Sydney",32660,46.15,-60.166667 ],
    [ u"ca",u"Sylvan Lake",10520,52.3,-114.083333 ],
    [ u"ca",u"Taber",8163,49.783333,-112.15 ],
    [ u"ca",u"Tavistock",2654,43.316667,-80.833333 ],
    [ u"ca",u"Teeswater",1171,43.983333,-81.283333 ],
    [ u"ca",u"Temiscaming",1854,46.716667,-79.083333 ],
    [ u"ca",u"Terrace Bay",2060,48.783333,-87.1 ],
    [ u"ca",u"Terrace",19443,54.5,-128.583333 ],
    [ u"ca",u"The Pas",6055,53.816667,-101.233333 ],
    [ u"ca",u"Thessalon",1464,46.25,-83.55 ],
    [ u"ca",u"Thetford Mines",22007,46.083333,-71.3 ],
    [ u"ca",u"Thompson",12467,55.75,-97.866667 ],
    [ u"ca",u"Thornbury",1970,44.55,-80.45 ],
    [ u"ca",u"Three Hills",3051,51.7,-113.266667 ],
    [ u"ca",u"Thunder Bay",99336,48.4,-89.233333 ],
    [ u"ca",u"Thurso",2476,45.583333,-75.233333 ],
    [ u"ca",u"Tilbury",4858,42.25,-82.433333 ],
    [ u"ca",u"Tilsonburg",14843,42.866667,-80.733333 ],
    [ u"ca",u"Timmins",32901,48.466667,-81.333333 ],
    [ u"ca",u"Tofield",1911,53.366667,-112.666667 ],
    [ u"ca",u"Torbay",3097,47.65,-52.733333 ],
    [ u"ca",u"Toronto",4612187,43.666667,-79.416667 ],
    [ u"ca",u"Tottenham",5101,44.016667,-79.8 ],
    [ u"ca",u"Trail",9707,49.1,-117.716667 ],
    [ u"ca",u"Trois-Pistoles",3695,48.116667,-69.166667 ],
    [ u"ca",u"Trois-Rivières",119693,46.35,-72.55 ],
    [ u"ca",u"Truro",20650,45.366667,-63.3 ],
    [ u"ca",u"Tuktoyaktuk",978,69.45,-133.066667 ],
    [ u"ca",u"Tweed",1626,44.466667,-77.3 ],
    [ u"ca",u"Two Hills",1147,53.716667,-111.75 ],
    [ u"ca",u"Ucluelet",1566,48.933333,-125.516667 ],
    [ u"ca",u"Unity",2096,52.433333,-109.166667 ],
    [ u"ca",u"Uxbridge",9020,44.1,-79.116667 ],
    [ u"ca",u"Valcourt",2451,45.483333,-72.316667 ],
    [ u"ca",u"Val-David",1211,46.033333,-74.2 ],
    [ u"ca",u"Vallée-Jonction",1216,46.366667,-70.916667 ],
    [ u"ca",u"Valleyview",1951,55.066667,-117.283333 ],
    [ u"ca",u"Vancouver",1837970,49.25,-123.133333 ],
    [ u"ca",u"Vanderhoof",1462,54.016667,-124.016667 ],
    [ u"ca",u"Vankleek Hill",2136,45.516667,-74.65 ],
    [ u"ca",u"Vegreville",5678,53.5,-112.05 ],
    [ u"ca",u"Verchères",4030,45.766667,-73.35 ],
    [ u"ca",u"Vermilion",4151,53.35,-110.85 ],
    [ u"ca",u"Vernon",47275,50.266667,-119.266667 ],
    [ u"ca",u"Victoria",289625,48.433333,-123.35 ],
    [ u"ca",u"Victoriaville",34426,46.05,-71.966667 ],
    [ u"ca",u"Viking",1106,53.083333,-111.783333 ],
    [ u"ca",u"Ville-Marie",2831,47.333333,-79.433333 ],
    [ u"ca",u"Virden",3237,49.85,-100.933333 ],
    [ u"ca",u"Vulcan",1853,50.4,-113.25 ],
    [ u"ca",u"Wabana",2362,47.65,-52.933333 ],
    [ u"ca",u"Wadena",1319,51.95,-103.8 ],
    [ u"ca",u"Wainwright",5380,52.833333,-110.866667 ],
    [ u"ca",u"Walkerton",5250,44.133333,-81.15 ],
    [ u"ca",u"Wallaceburg",10693,42.583333,-82.366667 ],
    [ u"ca",u"Warman",3252,52.316667,-106.566667 ],
    [ u"ca",u"Warwick",3340,45.95,-71.983333 ],
    [ u"ca",u"Wasaga Beach",7567,44.52,-79.99 ],
    [ u"ca",u"Waterford",3033,42.933333,-80.283333 ],
    [ u"ca",u"Waterloo",110800,43.466667,-80.533333 ],
    [ u"ca",u"Waterloo",4064,45.35,-72.516667 ],
    [ u"ca",u"Watford",1716,42.95,-81.883333 ],
    [ u"ca",u"Watrous",1689,51.666667,-105.466667 ],
    [ u"ca",u"Wawa",3463,48,-84.783333 ],
    [ u"ca",u"Wellington",2052,43.95,-77.35 ],
    [ u"ca",u"Wembley",1574,55.15,-119.15 ],
    [ u"ca",u"Westlock",5067,54.15,-113.866667 ],
    [ u"ca",u"West Lorne",1540,42.6,-81.6 ],
    [ u"ca",u"Wetaskiwin",11302,52.966667,-113.383333 ],
    [ u"ca",u"Weyburn",9362,49.666667,-103.85 ],
    [ u"ca",u"Wheatley",2028,42.1,-82.45 ],
    [ u"ca",u"Whitchurch-Stouffville",11696,43.966667,-79.25 ],
    [ u"ca",u"Whitecourt",8763,54.133333,-115.683333 ],
    [ u"ca",u"Whitehorse",19616,60.716667,-135.05 ],
    [ u"ca",u"White Rock",66450,49.033333,-122.816667 ],
    [ u"ca",u"Wiarton",2481,44.733333,-81.133333 ],
    [ u"ca",u"Wilkie",1198,52.416667,-108.7 ],
    [ u"ca",u"Williams Lake",14168,52.116667,-122.15 ],
    [ u"ca",u"Winchester",2564,45.1,-75.35 ],
    [ u"ca",u"Windsor",3864,44.983333,-64.133333 ],
    [ u"ca",u"Windsor",278013,42.333333,-83.033333 ],
    [ u"ca",u"Windsor",5408,45.583333,-72 ],
    [ u"ca",u"Wingham",3047,43.883333,-81.3 ],
    [ u"ca",u"Winkler",8270,49.183333,-97.933333 ],
    [ u"ca",u"Winnipeg",632069,49.883333,-97.166667 ],
    [ u"ca",u"Wolfville",3523,45.083333,-64.366667 ],
    [ u"ca",u"Woodstock",5032,46.15,-67.566667 ],
    [ u"ca",u"Woodstock",33893,43.133333,-80.75 ],
    [ u"ca",u"Wynyard",1793,51.766667,-104.183333 ],
    [ u"ca",u"Wyoming",2324,42.95,-82.116667 ],
    [ u"ca",u"Yamachiche",1255,46.283333,-72.833333 ],
    [ u"ca",u"Yarmouth",7500,43.833333,-66.116667 ],
    [ u"ca",u"Yellowknife",15866,62.45,-114.35 ],
    [ u"ca",u"Yorkton",15172,51.216667,-102.466667 ],
    [ u"cd",u"Aketi",35158,2.733333,23.766667 ],
    [ u"cd",u"Bandundu",118203,-3.316667,17.366667 ],
    [ u"cd",u"Basoko",43706,1.233333,23.6 ],
    [ u"cd",u"Beni",89643,.5,29.466667 ],
    [ u"cd",u"Binga",60037,2.383333,20.5 ],
    [ u"cd",u"Boende",32089,-.216667,20.866667 ],
    [ u"cd",u"Bolobo",27860,-2.166667,16.233333 ],
    [ u"cd",u"Boma",344522,-5.85,13.05 ],
    [ u"cd",u"Bondo",17858,3.816667,23.666667 ],
    [ u"cd",u"Bongandanga",4104,1.5,21.05 ],
    [ u"cd",u"Bosobolo",14552,4.183333,19.9 ],
    [ u"cd",u"Bukama",38801,-9.2,25.85 ],
    [ u"cd",u"Bukavu",225431,-2.508333,28.860833 ],
    [ u"cd",u"Bulungu",48340,-4.55,18.6 ],
    [ u"cd",u"Bumba",95514,2.183333,22.466667 ],
    [ u"cd",u"Bunia",96757,1.566667,30.25 ],
    [ u"cd",u"Businga",28917,3.333333,20.883333 ],
    [ u"cd",u"Buta",45674,2.8,24.733333 ],
    [ u"cd",u"Butembo",154649,.15,29.283333 ],
    [ u"cd",u"Demba",22261,-5.51,22.266667 ],
    [ u"cd",u"Dibaya",4571,-6.5,22.95 ],
    [ u"cd",u"Gandajika",154414,-6.75,23.95 ],
    [ u"cd",u"Gbadolite",50489,4.283333,21.016667 ],
    [ u"cd",u"Gemena",117631,3.25,19.766667 ],
    [ u"cd",u"Goma",144151,-1.679167,29.222778 ],
    [ u"cd",u"Ilebo",107086,-4.316667,20.583333 ],
    [ u"cd",u"Inongo",40110,-1.95,18.266667 ],
    [ u"cd",u"Isiro",127068,2.766667,27.616667 ],
    [ u"cd",u"Kabalo",29857,-6.05,26.916667 ],
    [ u"cd",u"Kabare",37031,-2.468333,28.824167 ],
    [ u"cd",u"Kabinda",58999,-6.133333,24.483333 ],
    [ u"cd",u"Kalemie",147065,-5.933333,29.2 ],
    [ u"cd",u"Kambove",36731,-10.876389,26.596944 ],
    [ u"cd",u"Kamina",73616,-8.738611,24.990556 ],
    [ u"cd",u"Kampene",37031,-3.6,26.666667 ],
    [ u"cd",u"Kananga",463556,-5.895833,22.417778 ],
    [ u"cd",u"Kaniama",29435,-7.516667,24.183333 ],
    [ u"cd",u"Kasangulu",27960,-4.591111,15.170833 ],
    [ u"cd",u"Kasongo",55115,-4.45,26.666667 ],
    [ u"cd",u"Kasongo-Lunda",20059,-6.466667,16.816667 ],
    [ u"cd",u"Kikwit",186995,-5.038611,18.818056 ],
    [ u"cd",u"Kindu",135690,-2.95,25.95 ],
    [ u"cd",u"Kinshasa",7787832,-4.3,15.3 ],
    [ u"cd",u"Kipushi",62382,-11.766667,27.233333 ],
    [ u"cd",u"Kisangani",539164,.516667,25.2 ],
    [ u"cd",u"Kongolo",31969,-5.383333,27 ],
    [ u"cd",u"Libenge",27051,3.65,18.633333 ],
    [ u"cd",u"Likasi",422726,-10.981389,26.733333 ],
    [ u"cd",u"Lisala",70082,2.15,21.516667 ],
    [ u"cd",u"Lodja",68239,-3.483333,23.433333 ],
    [ u"cd",u"Lubao",43065,-5.366667,25.75 ],
    [ u"cd",u"Lubumbashi",1374808,-11.666667,27.466667 ],
    [ u"cd",u"Luebo",35181,-5.35,21.416667 ],
    [ u"cd",u"Lusambo",41413,-4.966667,23.45 ],
    [ u"cd",u"Mangai",37185,-4.05,19.533333 ],
    [ u"cd",u"Manono",37583,-7.3,27.416667 ],
    [ u"cd",u"Matadi",180115,-5.816667,13.45 ],
    [ u"cd",u"Mbandaka",184189,.066667,18.266667 ],
    [ u"cd",u"Mbanza-Ngungu",86351,-5.25,14.866667 ],
    [ u"cd",u"Mbuji-Mayi",874974,-6.15,23.6 ],
    [ u"cd",u"Moba",29854,-7.05,29.783333 ],
    [ u"cd",u"Mushie",33060,-3.016667,16.9 ],
    [ u"cd",u"Mweka",50672,-4.85,21.566667 ],
    [ u"cd",u"Mwene-Ditu",189215,-7,23.45 ],
    [ u"cd",u"Nioki",40692,-2.716667,17.683333 ],
    [ u"cd",u"Tshela",38843,-4.983333,12.933333 ],
    [ u"cd",u"Tshikapa",267508,-6.416667,20.8 ],
    [ u"cd",u"Uvira",170422,-3.406667,29.145833 ],
    [ u"cd",u"Wamba",17371,2.15,28 ],
    [ u"cd",u"Watsa",24515,3.05,29.533333 ],
    [ u"cd",u"Yangambi",35529,.783333,24.466667 ],
    [ u"cf",u"Alindao",20125,5.0333333,21.2166667 ],
    [ u"cf",u"Baboua",9034,5.8,14.8166667 ],
    [ u"cf",u"Bambari",54783,5.7619444,20.6672222 ],
    [ u"cf",u"Bangassou",34720,4.7333333,22.8166667 ],
    [ u"cf",u"Bangui",684190,4.3666667,18.5833333 ],
    [ u"cf",u"Baoro",8937,5.6666667,15.9666667 ],
    [ u"cf",u"Batangafo",19810,7.3,18.3 ],
    [ u"cf",u"Berbérati",59963,4.2666667,15.7833333 ],
    [ u"cf",u"Bimbo",55849,4.3,18.55 ],
    [ u"cf",u"Birao",11833,10.2833333,22.7833333 ],
    [ u"cf",u"Boali",4696,4.8,18.1166667 ],
    [ u"cf",u"Bocaranga",14002,6.9833333,15.65 ],
    [ u"cf",u"Boda",20621,4.3166667,17.4666667 ],
    [ u"cf",u"Bossangoa",39607,6.4833333,17.45 ],
    [ u"cf",u"Bossembélé",11518,5.2666667,17.65 ],
    [ u"cf",u"Bouar",55031,5.95,15.6 ],
    [ u"cf",u"Bouca",19383,6.5,18.2833333 ],
    [ u"cf",u"Bozoum",36548,6.3166667,16.3833333 ],
    [ u"cf",u"Bria",47190,6.5333333,21.9833333 ],
    [ u"cf",u"Carnot",83761,4.9333333,15.8666667 ],
    [ u"cf",u"Damara",16056,4.9666667,18.7 ],
    [ u"cf",u"Dekoa",17390,6.3166667,19.0666667 ],
    [ u"cf",u"Gambo",6210,4.65,22.2666667 ],
    [ u"cf",u"Gamboula",8028,4.1333333,15.15 ],
    [ u"cf",u"Grimari",16486,5.7333333,20.05 ],
    [ u"cf",u"Ippy",24274,6.25,21.2 ],
    [ u"cf",u"Kabo",17683,7.5833333,18.6333333 ],
    [ u"cf",u"Kembé",22348,4.6,21.9 ],
    [ u"cf",u"Kouango",9694,4.9666667,19.9833333 ],
    [ u"cf",u"Mbaïki",76350,3.8833333,18.0 ],
    [ u"cf",u"Mobaye",24518,4.3166667,21.1833333 ],
    [ u"cf",u"Mongoumba",11663,3.6333333,18.6 ],
    [ u"cf",u"Ndélé",11941,8.4091667,20.6530556 ],
    [ u"cf",u"Nola",53270,3.5333333,16.0666667 ],
    [ u"cf",u"Obo",14038,5.4,26.5 ],
    [ u"cf",u"Ouadda",5901,8.0666667,22.4 ],
    [ u"cf",u"Ouango",5453,4.3166667,22.55 ],
    [ u"cf",u"Paoua",31595,7.25,16.4333333 ],
    [ u"cf",u"Rafaï",16814,4.95,23.9166667 ],
    [ u"cf",u"Sibut",32547,5.7333333,19.0833333 ],
    [ u"cf",u"Zemio",7453,5.0333333,25.1333333 ],
    [ u"cg",u"Brazzaville",1115773,-4.2591667,15.2847222 ],
    [ u"cg",u"Djambala",9650,-2.5447222,14.7533333 ],
    [ u"cg",u"Ewo",4923,-0.8725,14.8205556 ],
    [ u"cg",u"Gamboma",20877,-1.8763889,15.8644444 ],
    [ u"cg",u"Impfondo",20859,1.6380556,18.0666667 ],
    [ u"cg",u"Kinkala",13882,-4.3613889,14.7644444 ],
    [ u"cg",u"Loandjili",26387,-4.7561111,11.8577778 ],
    [ u"cg",u"Loubomo",70734,-4.1997222,12.6738889 ],
    [ u"cg",u"Madingou",22760,-4.1536111,13.55 ],
    [ u"cg",u"Matsanga",3582,-1.9158333,12.6680556 ],
    [ u"cg",u"Mossendjo",21555,-2.9505556,12.7261111 ],
    [ u"cg",u"Nkayi",70945,-4.1655556,13.2927778 ],
    [ u"cg",u"Ouésso",16691,1.6136111,16.0516667 ],
    [ u"cg",u"Owando",16590,-0.4869444,15.9080556 ],
    [ u"cg",u"Sémbé",2514,1.6480556,14.5805556 ],
    [ u"cg",u"Sibiti",19089,-3.6858333,13.3458333 ],
    [ u"ch",u"Aadorf",7100,47.492721,8.898326 ],
    [ u"ch",u"Aarau",15007,47.389616,8.052354 ],
    [ u"ch",u"Aarburg",6484,47.319634,7.901413 ],
    [ u"ch",u"Adliswil",16144,47.311896,8.528684 ],
    [ u"ch",u"Aesch",10396,47.469456,7.595763 ],
    [ u"ch",u"Affoltern",10415,47.281224,8.45346 ],
    [ u"ch",u"Aigle",7897,46.318103,6.964567 ],
    [ u"ch",u"Allschwil",18745,47.550744,7.535994 ],
    [ u"ch",u"Alpnach",5139,46.940195,8.274263 ],
    [ u"ch",u"Altdorf",8833,46.880422,8.644409 ],
    [ u"ch",u"Altstatten",10585,47.379433,9.548989 ],
    [ u"ch",u"Amriswil",11543,47.546992,9.298365 ],
    [ u"ch",u"Appenzell",5541,47.328914,9.410547 ],
    [ u"ch",u"Arbon",13125,47.515392,9.434779 ],
    [ u"ch",u"Arlesheim",9737,47.495875,7.619839 ],
    [ u"ch",u"Arosa",2162,46.777926,9.676206 ],
    [ u"ch",u"Arth",10100,47.06337,8.523485 ],
    [ u"ch",u"Ascona",5236,46.156255,8.778395 ],
    [ u"ch",u"Au",6864,47.432211,9.633869 ],
    [ u"ch",u"Baar",20752,47.196254,8.529544 ],
    [ u"ch",u"Baden",16659,47.478029,8.302764 ],
    [ u"ch",u"Bad Ragaz",4786,47.005367,9.501217 ],
    [ u"ch",u"Bagnes",7114,46.083333,7.216667 ],
    [ u"ch",u"Balsthal",5576,47.31591,7.693047 ],
    [ u"ch",u"Basel",164474,47.558395,7.573271 ],
    [ u"ch",u"Bassersdorf",9860,47.443184,8.625859 ],
    [ u"ch",u"Bellinzona",17006,46.195201,9.02283 ],
    [ u"ch",u"Belp",9594,46.890805,7.499042 ],
    [ u"ch",u"Bern",123018,46.916667,7.466667 ],
    [ u"ch",u"Bernex",9266,46.177162,6.074159 ],
    [ u"ch",u"Bex",5995,46.252137,7.011408 ],
    [ u"ch",u"Biasca",5937,46.360581,8.969103 ],
    [ u"ch",u"Biberist",7463,47.185591,7.56005 ],
    [ u"ch",u"Biel",49675,47.141666,7.257589 ],
    [ u"ch",u"Binningen",15046,47.533588,7.568512 ],
    [ u"ch",u"Birmensdorf",5630,47.35465,8.437566 ],
    [ u"ch",u"Birsfelden",10627,47.554953,7.645868 ],
    [ u"ch",u"Blonay",5294,46.465737,6.895053 ],
    [ u"ch",u"Bolligen",6291,46.974194,7.495697 ],
    [ u"ch",u"Bottmingen",5956,47.522735,7.569016 ],
    [ u"ch",u"Boudry",5038,46.953019,6.83897 ],
    [ u"ch",u"Bremgarten",6702,47.352604,8.329955 ],
    [ u"ch",u"Brugg",9159,47.481527,8.203014 ],
    [ u"ch",u"Bubikon",6160,47.267748,8.818391 ],
    [ u"ch",u"Buchrain",5802,47.086016,8.346213 ],
    [ u"ch",u"Buchs",6397,47.387774,8.073525 ],
    [ u"ch",u"Buchs",10361,47.169856,9.47544 ],
    [ u"ch",u"Bulach",14776,47.518898,8.536967 ],
    [ u"ch",u"Bulle",12460,46.619499,7.056743 ],
    [ u"ch",u"Buochs",5272,46.973976,8.422788 ],
    [ u"ch",u"Burgdorf",14943,47.058495,7.622139 ],
    [ u"ch",u"Bussigny",7317,46.551102,6.555973 ],
    [ u"ch",u"Carouge",19688,46.186153,6.13463 ],
    [ u"ch",u"Cham",13431,47.182126,8.463576 ],
    [ u"ch",u"Chavannes",5740,46.528825,6.592058 ],
    [ u"ch",u"Chene-Bougeries",9821,46.197545,6.162082 ],
    [ u"ch",u"Chene-Bourg",8038,46.193049,6.196567 ],
    [ u"ch",u"Chiasso",8232,45.83491,9.02054 ],
    [ u"ch",u"Chur",32874,46.856753,9.526918 ],
    [ u"ch",u"Colombier",5133,46.967085,6.856604 ],
    [ u"ch",u"Conthey",6747,46.225283,7.303715 ],
    [ u"ch",u"Crissier",6915,46.55165,6.571253 ],
    [ u"ch",u"Delemont",11567,47.366429,7.329005 ],
    [ u"ch",u"Derendingen",5916,47.198505,7.588438 ],
    [ u"ch",u"Diepoldsau",5351,47.384835,9.655969 ],
    [ u"ch",u"Dietikon",22443,47.404446,8.394984 ],
    [ u"ch",u"Dietlikon",7121,47.425084,8.618775 ],
    [ u"ch",u"Domat",6818,46.834827,9.450752 ],
    [ u"ch",u"Dornach",5940,47.478042,7.616417 ],
    [ u"ch",u"Dubendorf",23051,47.395395,8.618366 ],
    [ u"ch",u"Dudingen",7088,46.849152,7.188475 ],
    [ u"ch",u"Durnten",6225,47.277691,8.842176 ],
    [ u"ch",u"Ebikon",11473,47.079366,8.340411 ],
    [ u"ch",u"Ebnat-Kappel",4740,47.261951,9.124726 ],
    [ u"ch",u"Ecublens",10655,46.60915,6.808706 ],
    [ u"ch",u"Egg",8585,47.300555,8.687429 ],
    [ u"ch",u"Einsiedeln",13188,47.126727,8.745245 ],
    [ u"ch",u"Embrach",8517,47.507063,8.595681 ],
    [ u"ch",u"Emmen",27290,47.081101,8.30477 ],
    [ u"ch",u"Epalinges",7521,46.551775,6.668288 ],
    [ u"ch",u"Eschenbach",5167,47.239806,8.921562 ],
    [ u"ch",u"Ettingen",4917,47.482675,7.549821 ],
    [ u"ch",u"Fallanden",6987,47.370719,8.639834 ],
    [ u"ch",u"Flawil",9878,47.414611,9.182838 ],
    [ u"ch",u"Flums",4936,47.092512,9.342604 ],
    [ u"ch",u"Frauenfeld",22639,47.558159,8.898544 ],
    [ u"ch",u"Freienbach",14900,47.204077,8.756933 ],
    [ u"ch",u"Frenkendorf",5984,47.506858,7.716483 ],
    [ u"ch",u"Fribourg",33806,46.79572,7.154748 ],
    [ u"ch",u"Frutigen",6668,46.58782,7.64751 ],
    [ u"ch",u"Fully",5965,46.138485,7.114872 ],
    [ u"ch",u"Gelterkinden",5541,47.464968,7.85174 ],
    [ u"ch",u"Geneva",181492,46.195602,6.148113 ],
    [ u"ch",u"Gerlafingen",5032,47.169782,7.575051 ],
    [ u"ch",u"Giubiasco",7926,46.176481,9.008847 ],
    [ u"ch",u"Gland",11194,46.421233,6.266986 ],
    [ u"ch",u"Glarus",5889,47.04057,9.068036 ],
    [ u"ch",u"Gossau",17268,47.41694,9.251252 ],
    [ u"ch",u"Gossau",9028,47.306992,8.757972 ],
    [ u"ch",u"Grabs",6244,47.182061,9.443083 ],
    [ u"ch",u"Granichen",6444,47.359297,8.10243 ],
    [ u"ch",u"Greifensee",5080,47.367869,8.680017 ],
    [ u"ch",u"Grenchen",16135,47.19354,7.396577 ],
    [ u"ch",u"Heimberg",5586,46.794824,7.604332 ],
    [ u"ch",u"Hergiswil",5477,46.984209,8.310356 ],
    [ u"ch",u"Herisau",15444,47.386276,9.280779 ],
    [ u"ch",u"Herrliberg",5922,47.288144,8.612224 ],
    [ u"ch",u"Herzogenbuchsee",5734,47.187406,7.707457 ],
    [ u"ch",u"Hinwil",10533,47.300822,8.842076 ],
    [ u"ch",u"Hochdorf",7793,47.168408,8.291788 ],
    [ u"ch",u"Hombrechtikon",7795,47.25208,8.77437 ],
    [ u"ch",u"Horgen",18055,47.255924,8.598672 ],
    [ u"ch",u"Horw",12110,47.016917,8.309556 ],
    [ u"ch",u"Hunenberg",8060,47.178931,8.423515 ],
    [ u"ch",u"Huttwil",4480,47.11502,7.862087 ],
    [ u"ch",u"Igis",7078,46.945308,9.57218 ],
    [ u"ch",u"Ingenbohl",7964,47.004642,8.614768 ],
    [ u"ch",u"Interlaken",5057,46.683872,7.866376 ],
    [ u"ch",u"Jona",17806,47.230265,8.841838 ],
    [ u"ch",u"Kerns",5375,46.900882,8.276516 ],
    [ u"ch",u"Kilchberg",6918,47.318309,8.551172 ],
    [ u"ch",u"Kirchberg",8073,47.411412,9.039848 ],
    [ u"ch",u"Kirchberg",5279,47.086574,7.588896 ],
    [ u"ch",u"Kloten",18141,47.449817,8.594777 ],
    [ u"ch",u"Koniz",35961,46.923391,7.408688 ],
    [ u"ch",u"Konolfingen",4509,46.879674,7.622618 ],
    [ u"ch",u"Kreuzlingen",17233,47.648212,9.180338 ],
    [ u"ch",u"Kriens",26117,47.035366,8.276307 ],
    [ u"ch",u"Kusnacht",13000,47.31776,8.581943 ],
    [ u"ch",u"Kussnacht",11771,47.085571,8.442057 ],
    [ u"ch",u"Kuttigen",5092,47.415658,8.047673 ],
    [ u"ch",u"La Chaux-de-Fonds",36971,47.104417,6.828892 ],
    [ u"ch",u"Lachen",6879,47.191524,8.856195 ],
    [ u"ch",u"Langenthal",14533,47.21526,7.796072 ],
    [ u"ch",u"Langnau",8731,46.93936,7.78738 ],
    [ u"ch",u"Langnau",6721,47.285027,8.534167 ],
    [ u"ch",u"La Tour-de-Peilz",10835,46.453552,6.858596 ],
    [ u"ch",u"Laufen",5223,47.420878,7.507521 ],
    [ u"ch",u"Lausanne",118015,46.533333,6.666667 ],
    [ u"ch",u"Lausen",5043,47.475823,7.765687 ],
    [ u"ch",u"Le Grand-Saconnex",8457,46.226419,6.123303 ],
    [ u"ch",u"Le Locle",9933,47.059533,6.752278 ],
    [ u"ch",u"Le Mont-sur-Lausanne",5139,46.557743,6.634562 ],
    [ u"ch",u"Lengnau",4302,47.183824,7.373714 ],
    [ u"ch",u"Lenzburg",7616,47.384048,8.181798 ],
    [ u"ch",u"Liestal",12491,47.482779,7.742975 ],
    [ u"ch",u"Littau",16403,47.050004,8.262739 ],
    [ u"ch",u"Locarno",13998,46.16497,8.799253 ],
    [ u"ch",u"Losone",6060,46.133333,8.75 ],
    [ u"ch",u"Lugano",26327,46.006182,8.951142 ],
    [ u"ch",u"Lutry",8625,46.504873,6.685161 ],
    [ u"ch",u"Luzern",57269,47.083333,8.266667 ],
    [ u"ch",u"Lyss",10892,47.077573,7.31162 ],
    [ u"ch",u"Malters",6303,47.03628,8.181928 ],
    [ u"ch",u"Mannedorf",10164,47.252851,8.690581 ],
    [ u"ch",u"Martigny",14413,46.104593,7.076771 ],
    [ u"ch",u"Massagno",5918,46.015621,8.945343 ],
    [ u"ch",u"Maur",9577,47.339262,8.671352 ],
    [ u"ch",u"Meggen",6593,47.04722,8.369489 ],
    [ u"ch",u"Meilen",11723,47.270429,8.643675 ],
    [ u"ch",u"Meiringen",4708,46.726776,8.183961 ],
    [ u"ch",u"Mendrisio",6192,45.86741,8.982097 ],
    [ u"ch",u"Menziken",5645,47.242487,8.19047 ],
    [ u"ch",u"Meyrin",19691,46.228245,6.064189 ],
    [ u"ch",u"Minusio",6772,46.175242,8.820102 ],
    [ u"ch",u"Mohlin",8353,47.556412,7.846873 ],
    [ u"ch",u"Monthey",16002,46.255457,6.960665 ],
    [ u"ch",u"Montreux",23703,46.433715,6.913179 ],
    [ u"ch",u"Morges",13759,46.511255,6.495693 ],
    [ u"ch",u"Moutier",7476,47.277733,7.369712 ],
    [ u"ch",u"Munchenbuchsee",10774,47.020946,7.448956 ],
    [ u"ch",u"Munchenstein",12059,47.510513,7.617668 ],
    [ u"ch",u"Munsingen",11326,46.87309,7.568647 ],
    [ u"ch",u"Muri",6307,47.270428,8.3382 ],
    [ u"ch",u"Muri",12280,46.931714,7.494164 ],
    [ u"ch",u"Murten",5377,46.92684,7.110343 ],
    [ u"ch",u"Muttenz",16646,47.525259,7.644511 ],
    [ u"ch",u"Naters",7472,46.32448,7.99137 ],
    [ u"ch",u"Nendaz",5477,46.191142,7.311152 ],
    [ u"ch",u"Neuchatel",31216,46.993089,6.93005 ],
    [ u"ch",u"Neuenhof",7358,47.452596,8.325772 ],
    [ u"ch",u"Neuenkirch",5683,47.099891,8.204161 ],
    [ u"ch",u"Nidau",6932,47.129167,7.238464 ],
    [ u"ch",u"Nyon",17071,46.388848,6.239319 ],
    [ u"ch",u"Oberengstringen",6106,47.410151,8.460978 ],
    [ u"ch",u"Oberentfelden",6981,47.360291,8.039193 ],
    [ u"ch",u"Oberglatt",5346,47.475281,8.520368 ],
    [ u"ch",u"Oberriet",7717,47.319883,9.566079 ],
    [ u"ch",u"Obersiggenthal",7683,47.489554,8.290437 ],
    [ u"ch",u"Oberuzwil",5600,47.430722,9.124194 ],
    [ u"ch",u"Oberwil",9957,47.508519,7.555238 ],
    [ u"ch",u"Oftringen",10062,47.31382,7.925327 ],
    [ u"ch",u"Ollon",6494,46.297564,6.99499 ],
    [ u"ch",u"Olten",16555,47.357058,7.909101 ],
    [ u"ch",u"Onex",16796,46.183909,6.101809 ],
    [ u"ch",u"Opfikon",13395,47.432553,8.580231 ],
    [ u"ch",u"Orbe",5466,46.724717,6.530103 ],
    [ u"ch",u"Payerne",7758,46.82201,6.93608 ],
    [ u"ch",u"Peseux",5580,46.982998,6.881593 ],
    [ u"ch",u"Pfaffikon",9987,47.364528,8.78395 ],
    [ u"ch",u"Plan-les-Ouates",8135,46.167615,6.119125 ],
    [ u"ch",u"Porrentruy",6453,47.415327,7.075221 ],
    [ u"ch",u"Pratteln",14861,47.52118,7.688415 ],
    [ u"ch",u"Pregassona",7491,46.02142,8.969476 ],
    [ u"ch",u"Prilly",10774,46.522445,6.622151 ],
    [ u"ch",u"Pully",16640,46.510544,6.656071 ],
    [ u"ch",u"Rapperswil",7959,47.227986,8.825954 ],
    [ u"ch",u"Regensdorf",15756,47.429855,8.465128 ],
    [ u"ch",u"Reinach",7756,47.259435,8.188453 ],
    [ u"ch",u"Renens",17530,46.539894,6.588096 ],
    [ u"ch",u"Rheinfelden",10657,47.562979,7.780108 ],
    [ u"ch",u"Richterswil",11398,47.207416,8.705841 ],
    [ u"ch",u"Risch",8645,46.409984,7.338869 ],
    [ u"ch",u"Romanshorn",9060,47.565858,9.378694 ],
    [ u"ch",u"Rothrist",7141,47.305162,7.890945 ],
    [ u"ch",u"Rumlang",6304,47.451787,8.526777 ],
    [ u"ch",u"Ruschlikon",5246,47.307744,8.555743 ],
    [ u"ch",u"Ruswil",6441,47.084253,8.126446 ],
    [ u"ch",u"Ruti",11361,47.261507,8.852445 ],
    [ u"ch",u"Saanen",6644,46.489557,7.259609 ],
    [ u"ch",u"Saint-Imier",4701,47.152195,6.995124 ],
    [ u"ch",u"Sankt Margrethen",4995,47.442304,9.629598 ],
    [ u"ch",u"Sargans",4991,47.048421,9.444797 ],
    [ u"ch",u"Sarnen",9405,46.898509,8.250681 ],
    [ u"ch",u"Saviese",5653,46.251153,7.345578 ],
    [ u"ch",u"Schaffhausen",34445,47.697316,8.634929 ],
    [ u"ch",u"Schattdorf",4779,46.865501,8.654655 ],
    [ u"ch",u"Schlieren",13762,47.39646,8.448587 ],
    [ u"ch",u"Schonenwerd",4470,47.3691,8.001674 ],
    [ u"ch",u"Schubelbach",8292,47.173785,8.927867 ],
    [ u"ch",u"Schwyz",14425,47.027858,8.656112 ],
    [ u"ch",u"Seon",4556,47.3449,8.156071 ],
    [ u"ch",u"Seuzach",7061,47.536974,8.731668 ],
    [ u"ch",u"Sevelen",4450,47.122292,9.489926 ],
    [ u"ch",u"Sierre",14648,46.293235,7.536934 ],
    [ u"ch",u"Sion",28246,46.229076,7.359417 ],
    [ u"ch",u"Sirnach",6658,47.463275,8.990668 ],
    [ u"ch",u"Sissach",5680,47.467368,7.799596 ],
    [ u"ch",u"Solothurn",15292,47.206649,7.516605 ],
    [ u"ch",u"Spiez",12310,46.684733,7.691108 ],
    [ u"ch",u"Spreitenbach",10544,47.420159,8.363006 ],
    [ u"ch",u"Stafa",13040,47.239059,8.725646 ],
    [ u"ch",u"Stans",7620,46.958449,8.365995 ],
    [ u"ch",u"Steffisburg",15396,46.778074,7.63249 ],
    [ u"ch",u"Steinhausen",8640,47.195101,8.485809 ],
    [ u"ch",u"Suhr",9522,47.371725,8.079669 ],
    [ u"ch",u"Sulgen",3081,47.5377,9.18497 ],
    [ u"ch",u"Sumiswald",5072,47.027467,7.745257 ],
    [ u"ch",u"Sursee",7962,47.170881,8.111132 ],
    [ u"ch",u"Teufen",5621,47.390723,9.389564 ],
    [ u"ch",u"Thalwil",16389,47.289515,8.567546 ],
    [ u"ch",u"Therwil",8986,47.501166,7.552859 ],
    [ u"ch",u"Thonex",13018,46.188186,6.196893 ],
    [ u"ch",u"Thun",41539,46.751176,7.621663 ],
    [ u"ch",u"Trimbach",6127,47.365605,7.886797 ],
    [ u"ch",u"Uetendorf",5538,46.773917,7.572506 ],
    [ u"ch",u"Unterageri",7248,47.136445,8.585305 ],
    [ u"ch",u"Unterseen",5283,46.6853,7.847225 ],
    [ u"ch",u"Untersiggenthal",6551,47.503174,8.254838 ],
    [ u"ch",u"Urdorf",9247,47.382958,8.428597 ],
    [ u"ch",u"Urtenen",5255,47.026668,7.500814 ],
    [ u"ch",u"Uster",29583,47.351997,8.713687 ],
    [ u"ch",u"Uznach",5648,47.224209,8.982634 ],
    [ u"ch",u"Uzwil",12185,47.438134,9.139218 ],
    [ u"ch",u"Vernier",29767,46.217693,6.08511 ],
    [ u"ch",u"Versoix",11660,46.284017,6.161659 ],
    [ u"ch",u"Vevey",16014,46.465264,6.841168 ],
    [ u"ch",u"Veyrier",9375,46.166485,6.185442 ],
    [ u"ch",u"Viganello",6330,46.015037,8.967779 ],
    [ u"ch",u"Villars-sur-Glane",9379,46.791892,7.117215 ],
    [ u"ch",u"Villmergen",5244,47.349173,8.245828 ],
    [ u"ch",u"Visp",6560,46.294524,7.884736 ],
    [ u"ch",u"Volketswil",14592,47.389983,8.691548 ],
    [ u"ch",u"Wadenswil",19473,47.228726,8.670585 ],
    [ u"ch",u"Wahlern",6292,46.828062,7.353178 ],
    [ u"ch",u"Wald",9016,47.276331,8.914128 ],
    [ u"ch",u"Wallisellen",12820,47.418328,8.589816 ],
    [ u"ch",u"Wattwil",8129,47.302253,9.08757 ],
    [ u"ch",u"Weinfelden",9529,47.566194,9.107546 ],
    [ u"ch",u"Wettingen",18509,47.470495,8.31636 ],
    [ u"ch",u"Wetzikon",19377,47.325771,8.795716 ],
    [ u"ch",u"Wil",17234,47.462147,9.04289 ],
    [ u"ch",u"Windisch",6815,47.476756,8.220846 ],
    [ u"ch",u"Winterthur",91368,47.500035,8.7251 ],
    [ u"ch",u"Wittenbach",8283,47.463075,9.37761 ],
    [ u"ch",u"Wohlen",14163,47.352359,8.278768 ],
    [ u"ch",u"Wohlen",9310,46.972336,7.358493 ],
    [ u"ch",u"Wollerau",6891,47.19478,8.719029 ],
    [ u"ch",u"Worb",11586,46.930286,7.562099 ],
    [ u"ch",u"Yverdon",23756,46.777908,6.635502 ],
    [ u"ch",u"Zermatt",5607,46.021256,7.74912 ],
    [ u"ch",u"Zofingen",12327,47.289945,7.947274 ],
    [ u"ch",u"Zollikofen",9144,46.995678,7.459013 ],
    [ u"ch",u"Zollikon",12534,47.338967,8.577801 ],
    [ u"ch",u"Zuchwil",8815,47.207778,7.561126 ],
    [ u"ch",u"Zug",24197,47.172421,8.517445 ],
    [ u"ch",u"Zumikon",5082,47.327409,8.620752 ],
    [ u"ch",u"Zurich",346185,47.366667,8.55 ],
    [ u"ci",u"Abengourou",144074,6.729722,-3.496389 ],
    [ u"ci",u"Abidjan",3692570,5.309657,-4.012656 ],
    [ u"ci",u"Aboisso",48148,5.467794,-3.207111 ],
    [ u"ci",u"Adiaké",22030,5.286337,-3.304025 ],
    [ u"ci",u"Adzopé",81150,6.106944,-3.861944 ],
    [ u"ci",u"Affery",37424,6.320352,-3.952347 ],
    [ u"ci",u"Agboville",108684,5.92801,-4.213186 ],
    [ u"ci",u"Agnibilékrou",59780,7.131132,-3.204147 ],
    [ u"ci",u"Akoupé",51387,6.38423,-3.887589 ],
    [ u"ci",u"Alépé",11794,5.500397,-3.663083 ],
    [ u"ci",u"Anyama",158250,5.494622,-4.051831 ],
    [ u"ci",u"Arrah",43408,6.673419,-3.969383 ],
    [ u"ci",u"Ayamé",15442,5.605204,-3.157086 ],
    [ u"ci",u"Bangolo",17712,7.01232,-7.486395 ],
    [ u"ci",u"Béoumi",25940,7.673951,-5.580855 ],
    [ u"ci",u"Biankouma",42756,7.739093,-7.613774 ],
    [ u"ci",u"Bingerville",83105,5.355809,-3.885371 ],
    [ u"ci",u"Bocanda",14051,7.062635,-4.499484 ],
    [ u"ci",u"Bondoukou",79013,8.040201,-2.800034 ],
    [ u"ci",u"Bongouanou",38756,6.651749,-4.204061 ],
    [ u"ci",u"Bonoua",40637,5.27247,-3.596248 ],
    [ u"ci",u"Botro",15581,7.852488,-5.310628 ],
    [ u"ci",u"Bouaflé",89344,6.990406,-5.744204 ],
    [ u"ci",u"Bouaké",572149,7.693846,-5.030307 ],
    [ u"ci",u"Bouna",40188,9.269265,-2.995098 ],
    [ u"ci",u"Boundiali",61998,9.521667,-6.486944 ],
    [ u"ci",u"Dabakala",22834,8.363209,-4.428628 ],
    [ u"ci",u"Dabou",95057,5.325556,-4.376853 ],
    [ u"ci",u"Daloa",217876,6.877355,-6.450221 ],
    [ u"ci",u"Danané",68687,7.259572,-8.154981 ],
    [ u"ci",u"Daoukro",56310,7.058552,-3.964625 ],
    [ u"ci",u"Dimbokro",73789,6.64678,-4.70519 ],
    [ u"ci",u"Divo",184481,5.83739,-5.357229 ],
    [ u"ci",u"Duekoué",68872,6.74202,-7.349183 ],
    [ u"ci",u"Ferkessédougou",74966,9.5928,-5.194487 ],
    [ u"ci",u"Gagnoa",125647,6.131934,-5.950601 ],
    [ u"ci",u"Grand-Lahou",13205,5.135526,-5.023964 ],
    [ u"ci",u"Guibéroua",16030,6.238687,-6.171465 ],
    [ u"ci",u"Guiglo",63528,6.543682,-7.493495 ],
    [ u"ci",u"Hiré",30232,6.188777,-5.294634 ],
    [ u"ci",u"Issia",88251,6.492241,-6.585576 ],
    [ u"ci",u"Jacqueville",14743,5.205148,-4.414604 ],
    [ u"ci",u"Katiola",83695,8.137278,-5.10095 ],
    [ u"ci",u"Korhogo",172114,9.458031,-5.629608 ],
    [ u"ci",u"Lakota",50651,5.847523,-5.681997 ],
    [ u"ci",u"Mankono",25351,8.058611,-6.189722 ],
    [ u"ci",u"Man",140217,7.412513,-7.55383 ],
    [ u"ci",u"Ndiékro",11794,7.426754,-4.765391 ],
    [ u"ci",u"Ndouci",25134,5.863835,-4.760897 ],
    [ u"ci",u"Odienné",71188,9.505114,-7.564332 ],
    [ u"ci",u"Oumé",78872,6.383086,-5.417591 ],
    [ u"ci",u"Sakassou",15068,7.454624,-5.292628 ],
    [ u"ci",u"San-Pédro",195873,4.748508,-6.636301 ],
    [ u"ci",u"Sassandra",30124,4.95,-6.083333 ],
    [ u"ci",u"Séguéla",79565,7.961111,-6.673056 ],
    [ u"ci",u"Sinfra",85875,6.621026,-5.911442 ],
    [ u"ci",u"Soubré",123214,5.783766,-6.59388 ],
    [ u"ci",u"Tabou",21511,4.42295,-7.3528 ],
    [ u"ci",u"Tanda",27098,7.803355,-3.168325 ],
    [ u"ci",u"Tiassalé",52186,5.898394,-4.822926 ],
    [ u"ci",u"Tiebissou",24605,7.157722,-5.2248 ],
    [ u"ci",u"Tingréla",67746,10.48115,-6.406939 ],
    [ u"ci",u"Touba",47538,8.283333,-7.683333 ],
    [ u"ci",u"Toulépleu",17965,6.579742,-8.410906 ],
    [ u"ci",u"Toumodi",51560,6.557986,-5.017688 ],
    [ u"ci",u"Vavoua",54249,7.381944,-6.477778 ],
    [ u"ci",u"Yamoussoukro",200659,6.820548,-5.276741 ],
    [ u"ci",u"Zuénoula",52630,7.430272,-6.050541 ],
    [ u"ck",u"Amuri",285,-18.8538889,-159.7963889 ],
    [ u"ck",u"Avarua",13374,-21.2077778,-159.775 ],
    [ u"ck",u"Omoka",180,-8.9816667,-158.0605556 ],
    [ u"ck",u"Roto",74,-10.8833333,-165.8333333 ],
    [ u"ck",u"Tauhunu",69,-10.425,-161.0352778 ],
    [ u"cl",u"Ancud",28020,-41.869722,-73.820278 ],
    [ u"cl",u"Angol",44856,-37.8,-72.716667 ],
    [ u"cl",u"Antofagasta",309835,-23.65,-70.4 ],
    [ u"cl",u"Arauco",24659,-37.25,-73.316667 ],
    [ u"cl",u"Arica",186000,-18.475,-70.30417 ],
    [ u"cl",u"Buin",55440,-33.733333,-70.75 ],
    [ u"cl",u"Bulnes",12715,-36.733333,-72.3 ],
    [ u"cl",u"Cabildo",12784,-32.432778,-71.133611 ],
    [ u"cl",u"Cabrero",18327,-37.033333,-72.4 ],
    [ u"cl",u"Calama",143085,-22.466667,-68.933333 ],
    [ u"cl",u"Calbuco",12490,-41.768011,-73.127296 ],
    [ u"cl",u"Calera",49107,-32.783333,-71.2 ],
    [ u"cl",u"Canete",20158,-37.8,-73.383333 ],
    [ u"cl",u"Carahue",11875,-38.7,-73.166667 ],
    [ u"cl",u"Castro",29926,-42.463611,-73.808333 ],
    [ u"cl",u"Cauquenes",31363,-35.966667,-72.35 ],
    [ u"cl",u"Chiguayante",82545,-36.916667,-73.016667 ],
    [ u"cl",u"Chillan",150396,-36.6,-72.116667 ],
    [ u"cl",u"Chimbarongo",17356,-34.7,-71.05 ],
    [ u"cl",u"Coihaique",45788,-45.566667,-72.066667 ],
    [ u"cl",u"Coihueco",7346,-36.616667,-71.833333 ],
    [ u"cl",u"Collipulli",16392,-37.95,-72.433333 ],
    [ u"cl",u"Concepcion",215414,-36.833333,-73.05 ],
    [ u"cl",u"Constitucion",37917,-35.333333,-72.416667 ],
    [ u"cl",u"Copiapo",129281,-27.366667,-70.333333 ],
    [ u"cl",u"Coquimbo",161319,-29.953333,-71.343611 ],
    [ u"cl",u"Coronel",92941,-37.016667,-73.133333 ],
    [ u"cl",u"Curanilahue",30611,-37.466667,-73.35 ],
    [ u"cl",u"Curico",102439,-34.983333,-71.233333 ],
    [ u"cl",u"Diego de Almagro",18137,-26.366667,-70.05 ],
    [ u"cl",u"El Monte",23090,-33.683333,-71.016667 ],
    [ u"cl",u"Freire",7813,-38.95,-72.633333 ],
    [ u"cl",u"Graneros",23301,-34.066667,-70.733333 ],
    [ u"cl",u"Illapel",22816,-31.630833,-71.165278 ],
    [ u"cl",u"Iquique",227501,-20.22083,-70.14306 ],
    [ u"cl",u"Laja",16550,-37.266667,-72.7 ],
    [ u"cl",u"La Ligua",24857,-32.433333,-71.233333 ],
    [ u"cl",u"Lampa",29250,-33.283333,-70.9 ],
    [ u"cl",u"La Serena",154523,-29.907778,-71.254167 ],
    [ u"cl",u"La Union",26299,-40.283333,-73.083333 ],
    [ u"cl",u"Lautaro",21579,-38.516667,-72.45 ],
    [ u"cl",u"Lebu",22345,-37.616667,-73.65 ],
    [ u"cl",u"Limache",35876,-32.983333,-71.283333 ],
    [ u"cl",u"Linares",69536,-35.85,-71.6 ],
    [ u"cl",u"Llaillay",16646,-32.85,-70.966667 ],
    [ u"cl",u"Loncoche",15590,-39.366667,-72.633333 ],
    [ u"cl",u"Longavi",6325,-35.966667,-71.683333 ],
    [ u"cl",u"Los Andes",56859,-32.833333,-70.616667 ],
    [ u"cl",u"Los Angeles",125431,-37.466667,-72.35 ],
    [ u"cl",u"Lota",49763,-37.083333,-73.166667 ],
    [ u"cl",u"Machali",27595,-34.183333,-70.666667 ],
    [ u"cl",u"Melipilla",63100,-33.7,-71.216667 ],
    [ u"cl",u"Molina",28775,-35.116667,-71.283333 ],
    [ u"cl",u"Monte Patria",13945,-30.691944,-70.946667 ],
    [ u"cl",u"Mulchen",22170,-37.716667,-72.233333 ],
    [ u"cl",u"Nacimiento",21220,-37.5,-72.666667 ],
    [ u"cl",u"Nueva Imperial",18777,-38.733333,-72.95 ],
    [ u"cl",u"Osorno",135774,-40.566667,-73.15 ],
    [ u"cl",u"Ovalle",77139,-30.598333,-71.200278 ],
    [ u"cl",u"Paine",32765,-33.816667,-70.75 ],
    [ u"cl",u"Panguipulli",16312,-39.633333,-72.333333 ],
    [ u"cl",u"Parral",26905,-36.15,-71.833333 ],
    [ u"cl",u"Penaflor",65494,-33.616667,-70.916667 ],
    [ u"cl",u"Penco",46091,-36.733333,-72.983333 ],
    [ u"cl",u"Pitrufquen",13743,-38.983333,-72.65 ],
    [ u"cl",u"Puerto Montt",160055,-41.469848,-72.944745 ],
    [ u"cl",u"Puerto Varas",24958,-41.319461,-72.985378 ],
    [ u"cl",u"Punta Arenas",117432,-53.15,-70.916667 ],
    [ u"cl",u"Purranque",13619,-40.916667,-73.166667 ],
    [ u"cl",u"Quillota",67779,-32.883333,-71.266667 ],
    [ u"cl",u"Quilpue",130264,-33.045,-71.449444 ],
    [ u"cl",u"Rancagua",212696,-34.17083,-70.74444 ],
    [ u"cl",u"Rengo",38101,-34.416667,-70.866667 ],
    [ u"cl",u"Rio Bueno",15456,-40.316667,-72.966667 ],
    [ u"cl",u"Salamanca",13265,-31.775,-70.972222 ],
    [ u"cl",u"San Antonio",85651,-33.593333,-71.621667 ],
    [ u"cl",u"San Bernardo",249856,-33.6,-70.716667 ],
    [ u"cl",u"San Carlos",31517,-36.416667,-71.966667 ],
    [ u"cl",u"San Clemente",13656,-35.55,-71.483333 ],
    [ u"cl",u"San Felipe",59294,-32.75,-70.733333 ],
    [ u"cl",u"San Javier",22427,-35.6,-71.75 ],
    [ u"cl",u"Santa Cruz",33283,-34.633333,-71.366667 ],
    [ u"cl",u"Santiago",4837248,-33.45,-70.666667 ],
    [ u"cl",u"San Vicente",22573,-34.433333,-71.083333 ],
    [ u"cl",u"Talagante",51763,-33.666667,-70.933333 ],
    [ u"cl",u"Talcahuano",252969,-36.716667,-73.116667 ],
    [ u"cl",u"Talca",197480,-35.433333,-71.666667 ],
    [ u"cl",u"Taltal",10018,-25.4,-70.483333 ],
    [ u"cl",u"Temuco",238131,-38.733333,-72.6 ],
    [ u"cl",u"Teno",6858,-34.866667,-71.183333 ],
    [ u"cl",u"Tocopilla",24461,-22.09198,-70.19792 ],
    [ u"cl",u"Tome",46698,-36.616667,-72.95 ],
    [ u"cl",u"Traiguen",14481,-38.25,-72.683333 ],
    [ u"cl",u"Valdivia",133420,-39.8,-73.233333 ],
    [ u"cl",u"Vallenar",44895,-28.570833,-70.758056 ],
    [ u"cl",u"Valparaiso",282450,-33.047778,-71.601111 ],
    [ u"cl",u"Victoria",24555,-38.216667,-72.333333 ],
    [ u"cl",u"Vicuna",13496,-30.031944,-70.708056 ],
    [ u"cl",u"Vilcun",9241,-38.65,-72.233333 ],
    [ u"cl",u"Villa Alemana",97320,-33.042222,-71.373333 ],
    [ u"cl",u"Villarrica",31603,-39.266667,-72.216667 ],
    [ u"cl",u"Vina del Mar",294553,-33.008056,-71.519722 ],
    [ u"cl",u"Yumbel",11111,-37.083333,-72.566667 ],
    [ u"cm",u"Abong Mbang",14661,3.9833333,13.1833333 ],
    [ u"cm",u"Akom",9709,2.7833333,10.5666667 ],
    [ u"cm",u"Akonolinga",17181,3.7666667,12.25 ],
    [ u"cm",u"Ambam",8476,2.3833333,11.2833333 ],
    [ u"cm",u"Bafang",80966,5.15,10.1833333 ],
    [ u"cm",u"Bafia",69511,4.75,11.2333333 ],
    [ u"cm",u"Bafoussam",290798,5.4666667,10.4166667 ],
    [ u"cm",u"Bafut",18946,6.0833333,10.1 ],
    [ u"cm",u"Bali",72909,5.8833333,10.0166667 ],
    [ u"cm",u"Bamenda",393871,5.9333333,10.1666667 ],
    [ u"cm",u"Bana",5727,5.15,10.2666667 ],
    [ u"cm",u"Bangangté",65608,5.15,10.5166667 ],
    [ u"cm",u"Banyo",40936,6.75,11.8166667 ],
    [ u"cm",u"Batouri",43970,4.4333333,14.3666667 ],
    [ u"cm",u"Bertoua",218217,4.5833333,13.6833333 ],
    [ u"cm",u"Bétaré Oya",11866,5.6,14.0833333 ],
    [ u"cm",u"Bogo",16952,10.7361111,14.6108333 ],
    [ u"cm",u"Bonabéri",8091,4.0844444,9.6661111 ],
    [ u"cm",u"Buea",64372,4.1594444,9.2366667 ],
    [ u"cm",u"Dibombari",4811,4.1816667,9.645 ],
    [ u"cm",u"Djang",96436,5.45,10.0666667 ],
    [ u"cm",u"Douala",1338144,4.0502778,9.7 ],
    [ u"cm",u"Doumé",5609,4.2333333,13.45 ],
    [ u"cm",u"Ébolowa",88140,2.9,11.15 ],
    [ u"cm",u"Edéa",203170,3.8,10.1333333 ],
    [ u"cm",u"Eséka",22221,3.65,10.7666667 ],
    [ u"cm",u"Fontem",42835,5.4666667,9.8833333 ],
    [ u"cm",u"Foumban",92673,5.7166667,10.9166667 ],
    [ u"cm",u"Foumbot",84417,5.5,10.6333333 ],
    [ u"cm",u"Fundong",43693,6.25,10.2666667 ],
    [ u"cm",u"Garoua Boulaï",46771,5.8833333,14.55 ],
    [ u"cm",u"Garoua",436932,9.3,13.4 ],
    [ u"cm",u"Guider",84928,9.9341667,13.9486111 ],
    [ u"cm",u"Idenao",17800,4.2475,9.0047222 ],
    [ u"cm",u"Kaélé",25199,10.1091667,14.4508333 ],
    [ u"cm",u"Kousséri",435986,12.0783333,15.0308333 ],
    [ u"cm",u"Kribi",55401,2.95,9.9166667 ],
    [ u"cm",u"Kumba",144428,4.6438889,9.4386111 ],
    [ u"cm",u"Kumbo",53970,6.2,10.6666667 ],
    [ u"cm",u"Lagdo",24596,9.05,13.7333333 ],
    [ u"cm",u"Limbe",72106,4.0127778,9.2202778 ],
    [ u"cm",u"Lolodorf",22345,3.2333333,10.7333333 ],
    [ u"cm",u"Loum",177448,4.7161111,9.7463889 ],
    [ u"cm",u"Manjo",37795,4.8452778,9.8247222 ],
    [ u"cm",u"Maroua",319974,10.5955556,14.3247222 ],
    [ u"cm",u"Mbalmayo",80483,3.5166667,11.5 ],
    [ u"cm",u"Mbengwi",9785,6.0166667,10.0 ],
    [ u"cm",u"Mbouda",111690,5.6333333,10.25 ],
    [ u"cm",u"Meïganga",80355,6.5166667,14.3 ],
    [ u"cm",u"Melong",37216,5.1166667,9.95 ],
    [ u"cm",u"Mfou",10033,3.9666667,11.9333333 ],
    [ u"cm",u"Mindif",10538,10.4027778,14.44 ],
    [ u"cm",u"Mme",6149,6.3333333,10.2333333 ],
    [ u"cm",u"Mokolo",275750,10.7402778,13.8027778 ],
    [ u"cm",u"Monatélé",11327,4.2666667,11.2 ],
    [ u"cm",u"Mora",55488,11.0425,14.1447222 ],
    [ u"cm",u"Mutengene",47638,4.0994444,9.3080556 ],
    [ u"cm",u"Muyuka",31384,4.2972222,9.4055556 ],
    [ u"cm",u"Mvangué",1908,2.9666667,11.5166667 ],
    [ u"cm",u"Nanga Eboko",29909,4.6833333,12.3666667 ],
    [ u"cm",u"Ngaoundéré",231376,7.3166667,13.5833333 ],
    [ u"cm",u"Njinikom",8247,6.2333333,10.2833333 ],
    [ u"cm",u"Nkongsamba",117076,4.9533333,9.9325 ],
    [ u"cm",u"Nkoteng",50622,4.5166667,12.0333333 ],
    [ u"cm",u"Obala",30012,4.1666667,11.5333333 ],
    [ u"cm",u"Ombessa",1833,4.6,11.25 ],
    [ u"cm",u"Poli",5727,8.4833333,13.25 ],
    [ u"cm",u"Rey Bouba",11454,8.6666667,14.1833333 ],
    [ u"cm",u"Saa",5727,4.3666667,11.45 ],
    [ u"cm",u"Sangmélima",54427,2.9333333,11.9833333 ],
    [ u"cm",u"Tcholliré",23267,8.4,14.1666667 ],
    [ u"cm",u"Tibati",35711,6.4666667,12.6333333 ],
    [ u"cm",u"Tignère",4353,7.3666667,12.65 ],
    [ u"cm",u"Tiko",56104,4.0786111,9.3680556 ],
    [ u"cm",u"Wum",69072,6.3833333,10.0666667 ],
    [ u"cm",u"Yabassi",7560,4.4544444,9.9655556 ],
    [ u"cm",u"Yagoua",80510,10.3427778,15.2405556 ],
    [ u"cm",u"Yaoundé",1299446,3.8666667,11.5166667 ],
    [ u"cm",u"Yokadouma",13287,3.5166667,15.05 ],
    [ u"cn",u"Acheng",144665,45.545452,126.977031 ],
    [ u"cn",u"Aksu",340020,41.123056,80.264444 ],
    [ u"cn",u"Alihe",61582,50.566667,123.716667 ],
    [ u"cn",u"Altay",139341,47.866667,88.116667 ],
    [ u"cn",u"Anbu",162964,23.448953,116.680916 ],
    [ u"cn",u"Anda",181271,46.4,125.316667 ],
    [ u"cn",u"Angangxi",59211,47.15,123.81 ],
    [ u"cn",u"Anjiang",55421,27.319444,110.103056 ],
    [ u"cn",u"Anju",54098,30.349556,105.455937 ],
    [ u"cn",u"Ankang",132654,32.68,109.017222 ],
    [ u"cn",u"Anlu",71198,31.2575,113.678333 ],
    [ u"cn",u"Anqing",358661,30.509167,117.050556 ],
    [ u"cn",u"Anqiu",105665,36.434167,119.1925 ],
    [ u"cn",u"Anshan",1199275,41.123611,122.99 ],
    [ u"cn",u"Anshun",351936,26.25,105.933333 ],
    [ u"cn",u"Anyang",781129,36.099444,114.328889 ],
    [ u"cn",u"Aojiang",74636,27.59564,120.555371 ],
    [ u"cn",u"Babu",65603,24.416667,111.516667 ],
    [ u"cn",u"Badaojiang",183880,41.943056,126.428611 ],
    [ u"cn",u"Baicheng",316970,45.616667,122.816667 ],
    [ u"cn",u"Baijiantan",93697,45.633333,85.183333 ],
    [ u"cn",u"Baiquan",70472,47.583333,126.083333 ],
    [ u"cn",u"Baisha",57417,29.959702,115.064265 ],
    [ u"cn",u"Baishishan",56992,43.583333,127.566667 ],
    [ u"cn",u"Baiyin",188533,36.558333,104.208056 ],
    [ u"cn",u"Bamiantong",66170,44.933333,130.533333 ],
    [ u"cn",u"Bantou",118557,25.443056,118.403333 ],
    [ u"cn",u"Baoding",995652,38.851111,115.490278 ],
    [ u"cn",u"Baoji",438295,34.365907,107.359045 ],
    [ u"cn",u"Baoning",60542,31.55037,105.99381 ],
    [ u"cn",u"Baoqing",62991,46.331667,132.211111 ],
    [ u"cn",u"Baoshan",123791,46.558611,131.424444 ],
    [ u"cn",u"Baoying",80292,33.229167,119.309167 ],
    [ u"cn",u"Bayan",55186,46.083333,127.4 ],
    [ u"cn",u"Beian",145670,48.266667,126.6 ],
    [ u"cn",u"Beibei",112019,29.825556,106.433889 ],
    [ u"cn",u"Beidao",74767,34.568611,105.893333 ],
    [ u"cn",u"Beihai",289568,21.483333,109.1 ],
    [ u"cn",u"Beipiao",154999,41.791944,120.779167 ],
    [ u"cn",u"Bengbu",576648,32.940833,117.360833 ],
    [ u"cn",u"Benxi",987717,41.288611,123.765 ],
    [ u"cn",u"Bianzhuang",65381,34.848611,118.044722 ],
    [ u"cn",u"Bijie",77645,27.3125,105.294167 ],
    [ u"cn",u"Binzhou",62017,45.752809,127.479863 ],
    [ u"cn",u"Binzhou",70013,23.223785,108.802165 ],
    [ u"cn",u"Binzhou",115893,37.366667,118.016667 ],
    [ u"cn",u"Boli",95260,45.766667,130.516667 ],
    [ u"cn",u"Bose",90603,23.899722,106.613333 ],
    [ u"cn",u"Boshan",153596,36.483333,117.833333 ],
    [ u"cn",u"Botou",63045,38.066667,116.566667 ],
    [ u"cn",u"Bozhou",174140,33.877222,115.770278 ],
    [ u"cn",u"Buhe",106347,30.287567,112.229788 ],
    [ u"cn",u"Caidian",71891,30.583333,114.033333 ],
    [ u"cn",u"Cangzhou",527681,38.316667,116.866667 ],
    [ u"cn",u"Caohai",56744,26.85,104.233333 ],
    [ u"cn",u"Caohe",67370,30.2297,115.433461 ],
    [ u"cn",u"Chaihe",67963,44.766667,129.7 ],
    [ u"cn",u"Changchun",2537421,43.88,125.322778 ],
    [ u"cn",u"Changde",517780,29.046378,111.678304 ],
    [ u"cn",u"Changji",198776,44.016667,87.316667 ],
    [ u"cn",u"Changli",64476,39.704167,119.150556 ],
    [ u"cn",u"Changping",93174,40.218611,116.219722 ],
    [ u"cn",u"Changqing",82598,36.5575,116.727222 ],
    [ u"cn",u"Changtu",71284,42.778842,124.095447 ],
    [ u"cn",u"Changying",66392,34.116667,114.6 ],
    [ u"cn",u"Changzhou",949018,31.783333,119.966667 ],
    [ u"cn",u"Chaohu",138463,31.6,117.866667 ],
    [ u"cn",u"Chaoyang",410005,41.570278,120.458611 ],
    [ u"cn",u"Chaozhou",424787,23.665129,116.637864 ],
    [ u"cn",u"Chengde",449325,40.770278,118.169722 ],
    [ u"cn",u"Chengdu",3950437,30.666667,104.066667 ],
    [ u"cn",u"Chenghai",152453,23.461319,116.770071 ],
    [ u"cn",u"Chengmai",68720,19.6825,110.090278 ],
    [ u"cn",u"Chengzihe",98188,45.333333,131.066667 ],
    [ u"cn",u"Chenzhou",179038,25.8,113.033333 ],
    [ u"cn",u"Chifeng",346654,42.268333,118.963611 ],
    [ u"cn",u"Chizhou",148375,30.657778,117.483056 ],
    [ u"cn",u"Chongqing",3967028,29.562778,106.552778 ],
    [ u"cn",u"Choucheng",89629,29.315056,120.076764 ],
    [ u"cn",u"Chuncheng",153547,22.166667,111.783333 ],
    [ u"cn",u"Chuzhou",280582,32.321944,118.297778 ],
    [ u"cn",u"Cuiluan",54804,47.85,128.533333 ],
    [ u"cn",u"Daan",120340,29.382222,106.015 ],
    [ u"cn",u"Dafeng",84323,33.199728,120.457805 ],
    [ u"cn",u"Dalian",2035307,38.912222,121.602222 ],
    [ u"cn",u"Daliang",210411,22.850416,113.247006 ],
    [ u"cn",u"Dalianwan",55841,39.008611,121.715833 ],
    [ u"cn",u"Dali",134040,25.7,100.183333 ],
    [ u"cn",u"Dalinghe",56176,41.165278,121.366667 ],
    [ u"cn",u"Dancheng",65411,33.633333,115.183333 ],
    [ u"cn",u"Dandong",631973,40.129167,124.394722 ],
    [ u"cn",u"Dangtu",60335,31.559777,118.482888 ],
    [ u"cn",u"Danjiangkou",92008,32.542778,111.508611 ],
    [ u"cn",u"Danshui",126701,22.798396,114.467158 ],
    [ u"cn",u"Daokou",56637,35.563889,114.505833 ],
    [ u"cn",u"Dashiqiao",80223,40.637318,122.502508 ],
    [ u"cn",u"Dashitou",65683,43.306667,128.511389 ],
    [ u"cn",u"Datong",1052678,40.093611,113.291389 ],
    [ u"cn",u"Dawukou",131880,39.041944,106.395833 ],
    [ u"cn",u"Daxian",130749,31.215921,107.500922 ],
    [ u"cn",u"Daye",61847,30.083333,114.95 ],
    [ u"cn",u"Dayong",86083,29.129444,110.478333 ],
    [ u"cn",u"Dehui",108818,44.533333,125.7 ],
    [ u"cn",u"Dengfeng",62375,34.455278,113.028056 ],
    [ u"cn",u"Dengzhou",59338,32.682222,112.081944 ],
    [ u"cn",u"Dengzhou",85279,37.808611,120.750833 ],
    [ u"cn",u"Deqing",87576,30.541667,119.9575 ],
    [ u"cn",u"Deyang",152194,31.130192,104.381981 ],
    [ u"cn",u"Dezhou",379555,37.448611,116.2925 ],
    [ u"cn",u"Didao",109561,45.366667,130.8 ],
    [ u"cn",u"Dinghai",84380,30.010754,122.204649 ],
    [ u"cn",u"Dingtao",58206,35.068333,115.5625 ],
    [ u"cn",u"Dingzhou",152934,38.513056,114.995556 ],
    [ u"cn",u"Dongdu",72957,35.85,117.7 ],
    [ u"cn",u"Dongfeng",67820,42.640309,125.511762 ],
    [ u"cn",u"Donghai",188602,22.945935,115.642043 ],
    [ u"cn",u"Dongkan",72789,33.999722,119.830833 ],
    [ u"cn",u"Dongli",110107,20.791389,110.349722 ],
    [ u"cn",u"Dongling",171454,41.814444,123.575833 ],
    [ u"cn",u"Dongning",61440,44.062188,131.120752 ],
    [ u"cn",u"Dongsheng",99809,39.816085,109.977629 ],
    [ u"cn",u"Dongtai",110988,32.852311,120.309472 ],
    [ u"cn",u"Dongying",306450,37.456389,118.485556 ],
    [ u"cn",u"Dongzhen",98259,22.373029,110.947456 ],
    [ u"cn",u"Ducheng",95525,23.237294,111.53172 ],
    [ u"cn",u"Dunhua",148844,43.3725,128.2425 ],
    [ u"cn",u"Duobao",90257,30.670005,112.689517 ],
    [ u"cn",u"Duyun",91136,26.266667,107.516667 ],
    [ u"cn",u"Encheng",110921,22.183892,112.302597 ],
    [ u"cn",u"Enshi",95227,30.3,109.483333 ],
    [ u"cn",u"Erdaojiang",60831,41.776389,126.031944 ],
    [ u"cn",u"Erenhot",16427,43.6475,111.976667 ],
    [ u"cn",u"Ezhou",193652,30.396072,114.886546 ],
    [ u"cn",u"Fangshan",97026,39.698333,115.9925 ],
    [ u"cn",u"Feicheng",80929,35.260556,117.9675 ],
    [ u"cn",u"Fengcheng",120514,40.453611,124.071667 ],
    [ u"cn",u"Fengkou",67139,30.083333,113.266667 ],
    [ u"cn",u"Fengrun",65150,39.833333,118.116667 ],
    [ u"cn",u"Fengxian",57153,34.703882,116.587167 ],
    [ u"cn",u"Fengzhen",72444,40.439444,113.153611 ],
    [ u"cn",u"Fenyi",58478,27.811166,114.668047 ],
    [ u"cn",u"Foshan",627348,23.026771,113.131483 ],
    [ u"cn",u"Fujin",89442,47.26,132.032222 ],
    [ u"cn",u"Fuli",59160,46.721667,131.139444 ],
    [ u"cn",u"Fuling",166507,29.702222,107.391944 ],
    [ u"cn",u"Fulitun",76465,46.721667,131.139444 ],
    [ u"cn",u"Fushan",65622,37.495833,121.258056 ],
    [ u"cn",u"Fushun",1400646,41.7,123.883333 ],
    [ u"cn",u"Fuxin",689050,42.015556,121.658889 ],
    [ u"cn",u"Fuyang",170023,32.9,115.816667 ],
    [ u"cn",u"Fuyang",70183,30.053333,119.951944 ],
    [ u"cn",u"Fuyu",138704,45.183333,124.816667 ],
    [ u"cn",u"Fuyü",75147,47.641389,124.679444 ],
    [ u"cn",u"Fuzhou",1179720,26.061389,119.306111 ],
    [ u"cn",u"Gannan",59239,47.914722,123.503056 ],
    [ u"cn",u"Ganzhou",249071,25.85,114.933333 ],
    [ u"cn",u"Gaogou",56214,34.0175,119.188611 ],
    [ u"cn",u"Gaomi",150793,36.383333,119.752778 ],
    [ u"cn",u"Gaoyou",90911,32.785833,119.427778 ],
    [ u"cn",u"Gaozhou",166069,21.939243,110.846074 ],
    [ u"cn",u"Gejiu",136135,23.306022,103.163512 ],
    [ u"cn",u"Genhe",73631,50.783333,121.516667 ],
    [ u"cn",u"Gongzhuling",140909,43.507222,124.812222 ],
    [ u"cn",u"Guangshui",154771,31.616111,113.815556 ],
    [ u"cn",u"Guangyuan",213365,32.442015,105.822996 ],
    [ u"cn",u"Guangzhou",3152825,23.116667,113.25 ],
    [ u"cn",u"Gucheng",74038,32.266043,111.634759 ],
    [ u"cn",u"Guicheng",76430,23.096389,109.609167 ],
    [ u"cn",u"Guilin",649352,25.281944,110.286389 ],
    [ u"cn",u"Guiren",57446,33.669722,118.188889 ],
    [ u"cn",u"Guiyang",1171633,26.583333,106.716667 ],
    [ u"cn",u"Guozhen",85415,34.365907,107.359045 ],
    [ u"cn",u"Gushi",80666,32.2,115.8 ],
    [ u"cn",u"Guye",41484,39.733333,118.416667 ],
    [ u"cn",u"Haian",72654,32.543611,120.45 ],
    [ u"cn",u"Haibowan",218427,39.664722,106.812222 ],
    [ u"cn",u"Haicheng",191651,40.851582,122.747537 ],
    [ u"cn",u"Haicheng",130386,22.975326,115.331794 ],
    [ u"cn",u"Haikou",112644,24.779854,102.575483 ],
    [ u"cn",u"Haikou",615835,20.045833,110.341667 ],
    [ u"cn",u"Hailar",211066,49.2,119.7 ],
    [ u"cn",u"Hailin",85578,44.583333,129.416667 ],
    [ u"cn",u"Hailun",109881,47.45,126.933333 ],
    [ u"cn",u"Haimen",125427,23.193486,116.614218 ],
    [ u"cn",u"Haizhou",59098,34.581667,119.128889 ],
    [ u"cn",u"Hami",137072,42.8,93.45 ],
    [ u"cn",u"Hanchuan",87737,30.65,113.766667 ],
    [ u"cn",u"Handan",1358318,36.566667,114.533333 ],
    [ u"cn",u"Hangu",208369,39.248889,117.789167 ],
    [ u"cn",u"Hangzhou",1878129,30.29365,120.161419 ],
    [ u"cn",u"Hanting",90637,36.770833,119.210833 ],
    [ u"cn",u"Hanyang",71053,27.089167,119.645278 ],
    [ u"cn",u"Hanzhong",145986,33.072778,107.030278 ],
    [ u"cn",u"Harbin",3229883,45.75,126.65 ],
    [ u"cn",u"Hebi",244662,35.899167,114.1925 ],
    [ u"cn",u"Hecun",83009,36.533333,114.111111 ],
    [ u"cn",u"Hede",89107,33.768056,120.251667 ],
    [ u"cn",u"Hefei",1388904,31.863889,117.280833 ],
    [ u"cn",u"Hegang",743307,47.4,130.366667 ],
    [ u"cn",u"Heihe",109427,50.266667,127.466667 ],
    [ u"cn",u"Heishan",68603,41.689167,122.112778 ],
    [ u"cn",u"Helong",85756,42.539744,128.99722 ],
    [ u"cn",u"Hengshan",164844,45.2,130.916667 ],
    [ u"cn",u"Hengshui",456356,37.732222,115.701111 ],
    [ u"cn",u"Hengyang",759602,26.888056,112.615 ],
    [ u"cn",u"Heyang",97575,29.994722,106.257222 ],
    [ u"cn",u"Heze",254602,35.243056,115.441111 ],
    [ u"cn",u"Hohhot",774477,40.810556,111.652222 ],
    [ u"cn",u"Hongan",64831,31.362075,114.63689 ],
    [ u"cn",u"Honggang",147977,46.466667,124.866667 ],
    [ u"cn",u"Honghu",175761,29.816667,113.466667 ],
    [ u"cn",u"Hongjiang",59199,27.11,109.995556 ],
    [ u"cn",u"Houma",100630,35.61358,111.356601 ],
    [ u"cn",u"Huadian",139047,42.963333,126.747778 ],
    [ u"cn",u"Huaibei",903039,33.974444,116.791667 ],
    [ u"cn",u"Huaicheng",89294,23.905134,112.193144 ],
    [ u"cn",u"Huaidian",89978,33.433333,115.033333 ],
    [ u"cn",u"Huaihua",127322,27.549444,109.959167 ],
    [ u"cn",u"Huainan",1027655,32.626389,116.996944 ],
    [ u"cn",u"Huaiyin",555230,33.588611,119.019167 ],
    [ u"cn",u"Huaiyuan",65530,32.958933,117.165658 ],
    [ u"cn",u"Huanan",66087,46.216667,130.516667 ],
    [ u"cn",u"Huangchuan",72663,32.127222,115.039444 ],
    [ u"cn",u"Huangcun",104904,39.721389,116.329167 ],
    [ u"cn",u"Huangmei",77633,30.192347,116.024959 ],
    [ u"cn",u"Huangnihe",54959,43.558333,128.023889 ],
    [ u"cn",u"Huangpi",57554,30.884534,114.377886 ],
    [ u"cn",u"Huangpu",116307,23.053325,113.512148 ],
    [ u"cn",u"Huangyan",150448,28.647778,121.259444 ],
    [ u"cn",u"Huangzhai",60037,33.5,114.783333 ],
    [ u"cn",u"Huangzhou",122563,30.45,114.8 ],
    [ u"cn",u"Huanren",66147,41.260501,125.406431 ],
    [ u"cn",u"Huayang",90365,30.510299,104.054219 ],
    [ u"cn",u"Huazhou",91701,21.633333,110.583333 ],
    [ u"cn",u"Huicheng",125919,23.038449,116.28988 ],
    [ u"cn",u"Huilong",74818,31.811111,121.655 ],
    [ u"cn",u"Huinan",66315,42.6225,126.261389 ],
    [ u"cn",u"Huizhou",289201,23.083333,114.4 ],
    [ u"cn",u"Hulan Ergi",265344,47.204167,123.633333 ],
    [ u"cn",u"Hulan",109104,45.983333,126.6 ],
    [ u"cn",u"Humen",191891,22.818985,113.673064 ],
    [ u"cn",u"Hunchun",77028,42.8675,130.358056 ],
    [ u"cn",u"Huoqiu",61904,32.354727,116.293898 ],
    [ u"cn",u"Hushitai",61979,41.932222,123.511389 ],
    [ u"cn",u"Hutang",56370,31.533333,119.483333 ],
    [ u"cn",u"Huzhou",158320,30.870301,120.093297 ],
    [ u"cn",u"Jiamusi",549549,46.833333,130.35 ],
    [ u"cn",u"Jiancheng",82563,30.390968,104.549121 ],
    [ u"cn",u"Jiangdu",83936,32.436667,119.550833 ],
    [ u"cn",u"Jiangkou",59902,25.487222,119.198611 ],
    [ u"cn",u"Jiangmen",532419,22.583333,113.083333 ],
    [ u"cn",u"Jiangyan",70375,32.506111,120.142778 ],
    [ u"cn",u"Jiangyin",107918,31.905063,120.26851 ],
    [ u"cn",u"Jiangyin",107918,31.928249,120.312567 ],
    [ u"cn",u"Jiangyou",127225,31.766667,104.716667 ],
    [ u"cn",u"Jianhu",72474,33.277587,119.959845 ],
    [ u"cn",u"Jian",171718,27.05,114.9 ],
    [ u"cn",u"Jiaocheng",65170,26.661667,119.522778 ],
    [ u"cn",u"Jiaohe",123018,43.728611,127.344722 ],
    [ u"cn",u"Jiaojiang",470804,28.680278,121.442778 ],
    [ u"cn",u"Jiaonan",75656,35.878611,119.975278 ],
    [ u"cn",u"Jiaozhou",165026,36.283889,120.003333 ],
    [ u"cn",u"Jiaozuo",517540,35.239722,113.233056 ],
    [ u"cn",u"Jiaxing",466101,30.752198,120.749997 ],
    [ u"cn",u"Jiayuguan",122396,39.816667,98.3 ],
    [ u"cn",u"Jiazi",130298,22.877914,116.067054 ],
    [ u"cn",u"Jidong",58520,45.216667,131.083333 ],
    [ u"cn",u"Jiehu",69245,35.542778,118.455 ],
    [ u"cn",u"Jieshi",137444,22.813377,115.825742 ],
    [ u"cn",u"Jieshou",141993,33.25,115.35 ],
    [ u"cn",u"Jiexiu",77178,37.024444,111.9125 ],
    [ u"cn",u"Jijiang",61161,29.290556,106.254167 ],
    [ u"cn",u"Jilin",1881977,43.850833,126.560278 ],
    [ u"cn",u"Jimo",70733,36.389722,120.462222 ],
    [ u"cn",u"Jinan",2069266,36.668333,116.997222 ],
    [ u"cn",u"Jinchang",144363,38.495278,102.173889 ],
    [ u"cn",u"Jinchengjiang",104138,24.7,108.033333 ],
    [ u"cn",u"Jingcheng",61772,32.014167,120.2625 ],
    [ u"cn",u"Jingdezhen",310565,29.2947,117.207887 ],
    [ u"cn",u"Jinhua",142206,29.107778,119.654722 ],
    [ u"cn",u"Jining",258757,41.0275,113.105833 ],
    [ u"cn",u"Jining",450327,35.405,116.581389 ],
    [ u"cn",u"Jinji",56816,23.228056,110.826111 ],
    [ u"cn",u"Jinsha",95647,32.089817,121.073546 ],
    [ u"cn",u"Jinxiang",84231,27.432654,120.60625 ],
    [ u"cn",u"Jinxi",313247,40.764317,120.85327 ],
    [ u"cn",u"Jinzhou",604269,41.107778,121.141667 ],
    [ u"cn",u"Jishou",102332,28.316667,109.716667 ],
    [ u"cn",u"Jishui",77540,33.733333,115.4 ],
    [ u"cn",u"Jishu",103988,44.316667,126.8 ],
    [ u"cn",u"Jiujiang",258807,29.60794,115.887205 ],
    [ u"cn",u"Jiupu",123843,41.066667,122.95 ],
    [ u"cn",u"Jiuquan",72732,39.73817,98.499328 ],
    [ u"cn",u"Jiutai",175115,44.1525,125.832778 ],
    [ u"cn",u"Jixi",403759,45.3,130.966667 ],
    [ u"cn",u"Juegang",73317,32.31737,121.185525 ],
    [ u"cn",u"Juxian",66588,35.579444,118.832778 ],
    [ u"cn",u"Juye",58107,35.394722,116.088333 ],
    [ u"cn",u"Kaifeng",576915,34.744167,114.418611 ],
    [ u"cn",u"Kaihua",64404,23.368701,104.279996 ],
    [ u"cn",u"Kaili",151956,26.5,107.583333 ],
    [ u"cn",u"Kaitong",62537,44.813513,123.149999 ],
    [ u"cn",u"Kaiyuan",198423,23.697668,103.303723 ],
    [ u"cn",u"Karamay",174828,45.600376,84.860142 ],
    [ u"cn",u"Kashi",274717,39.454722,75.979722 ],
    [ u"cn",u"Keshan",84292,48.066667,125.9 ],
    [ u"cn",u"Korla",179465,41.759722,86.146944 ],
    [ u"cn",u"Kouqian",55957,43.639137,126.457835 ],
    [ u"cn",u"Kuandian",70867,40.728611,124.784722 ],
    [ u"cn",u"Kuche",68105,41.727778,82.936389 ],
    [ u"cn",u"Kunming",1023674,25.038889,102.718333 ],
    [ u"cn",u"Kunyang",65009,27.665833,120.565833 ],
    [ u"cn",u"Kuytun",187242,44.416667,85 ],
    [ u"cn",u"Laibin",59835,23.7,109.266667 ],
    [ u"cn",u"Laiwu",124108,36.192778,117.656944 ],
    [ u"cn",u"Laiyang",169594,36.975833,120.713611 ],
    [ u"cn",u"Laizhou",90070,37.171667,119.921389 ],
    [ u"cn",u"Langfang",720119,39.509722,116.694722 ],
    [ u"cn",u"Langxiang",57318,46.95,128.883333 ],
    [ u"cn",u"Lanxi",73706,29.21946,119.476953 ],
    [ u"cn",u"Lanxi",72528,46.262222,126.285556 ],
    [ u"cn",u"Lanzhou",1417742,36.056389,103.792222 ],
    [ u"cn",u"Laohekou",253112,32.385833,111.667778 ],
    [ u"cn",u"Lasa",118721,29.65,91.1 ],
    [ u"cn",u"Leiyang",129116,26.402382,112.859078 ],
    [ u"cn",u"Lengshuijiang",115399,27.688056,111.429444 ],
    [ u"cn",u"Lengshuitan",88935,26.411098,111.595592 ],
    [ u"cn",u"Leshan",154477,29.562275,103.76386 ],
    [ u"cn",u"Liancheng",100341,21.646734,110.28172 ],
    [ u"cn",u"Liangxiang",76744,39.731944,116.14 ],
    [ u"cn",u"Lianran",106795,24.922707,102.484959 ],
    [ u"cn",u"Lianyuan",66501,27.688333,111.664167 ],
    [ u"cn",u"Lianzhou",71423,21.668198,109.16946 ],
    [ u"cn",u"Lianzhou",92827,24.781111,112.3825 ],
    [ u"cn",u"Liaocheng",226930,36.443889,115.964722 ],
    [ u"cn",u"Liaoyang",687890,41.226111,123.056111 ],
    [ u"cn",u"Liaozhong",54691,41.506111,122.724167 ],
    [ u"cn",u"Licheng",172775,23.295537,113.828357 ],
    [ u"cn",u"Lichuan",72653,30.3,108.85 ],
    [ u"cn",u"Liling",98162,27.666667,113.5 ],
    [ u"cn",u"Linchuan",125847,27.938274,116.292688 ],
    [ u"cn",u"Linfen",232566,36.088889,111.518889 ],
    [ u"cn",u"Lingao",64874,19.907778,109.685833 ],
    [ u"cn",u"Lingdong",83636,46.566944,131.145278 ],
    [ u"cn",u"Lingyuan",91418,41.24,119.401111 ],
    [ u"cn",u"Linhai",152937,28.85,121.116667 ],
    [ u"cn",u"Linjiang",69149,41.806944,126.907778 ],
    [ u"cn",u"Linkou",77754,45.3,130.283333 ],
    [ u"cn",u"Linping",78180,30.4225,120.297222 ],
    [ u"cn",u"Linqing",110046,36.845556,115.711667 ],
    [ u"cn",u"Linqiong",55587,30.415872,103.460885 ],
    [ u"cn",u"Linqu",77472,36.515556,118.539722 ],
    [ u"cn",u"Linshui",109955,36.424722,114.204722 ],
    [ u"cn",u"Linshu",63285,34.916111,118.638889 ],
    [ u"cn",u"Linxia",202402,35.600278,103.206389 ],
    [ u"cn",u"Linxi",100316,39.7,118.433333 ],
    [ u"cn",u"Lishan",75882,34.378027,109.208925 ],
    [ u"cn",u"Lishui",98946,28.460417,119.910291 ],
    [ u"cn",u"Lishu",61584,43.304722,124.327778 ],
    [ u"cn",u"Liuhe",66975,42.240066,125.717173 ],
    [ u"cn",u"Liusha",118023,23.310722,116.168691 ],
    [ u"cn",u"Liuzhou",763168,24.312582,109.389157 ],
    [ u"cn",u"Liyang",72276,31.430795,119.523993 ],
    [ u"cn",u"Longfeng",152074,46.55,125.116667 ],
    [ u"cn",u"Longhua",65565,29.116667,107.266667 ],
    [ u"cn",u"Longjiang",106384,47.330278,123.183611 ],
    [ u"cn",u"Longjing",117185,42.771389,129.423333 ],
    [ u"cn",u"Longkou",60444,37.650833,120.328611 ],
    [ u"cn",u"Longyan",125778,25.107222,117.0225 ],
    [ u"cn",u"Loudi",150684,27.734444,111.994444 ],
    [ u"cn",u"Luancheng",597130,37.879167,114.651667 ],
    [ u"cn",u"Luan",179665,31.756944,116.491389 ],
    [ u"cn",u"Lubu",95820,23.174221,112.280936 ],
    [ u"cn",u"Lujiang",89119,31.233572,117.280566 ],
    [ u"cn",u"Luocheng",73581,29.384813,104.028621 ],
    [ u"cn",u"Luohe",417356,33.571667,114.035278 ],
    [ u"cn",u"Luorong",67593,24.405833,109.608611 ],
    [ u"cn",u"Luoyang",66188,24.959379,118.682998 ],
    [ u"cn",u"Luoyang",1390581,34.683611,112.453611 ],
    [ u"cn",u"Luoyang",123144,23.162442,114.273423 ],
    [ u"cn",u"Luqiao",427890,28.580835,121.377148 ],
    [ u"cn",u"Lushunkou",82345,38.8,121.266667 ],
    [ u"cn",u"Luyang",55489,33.735638,112.905085 ],
    [ u"cn",u"Luzhou",295056,28.872391,105.44049 ],
    [ u"cn",u"Maanshan",540198,31.695678,118.498248 ],
    [ u"cn",u"Mabai",63569,23.012792,104.450813 ],
    [ u"cn",u"Maba",113609,24.684125,113.598386 ],
    [ u"cn",u"Macheng",126366,31.178333,115.031944 ],
    [ u"cn",u"Manzhouli",54808,49.6,117.433333 ],
    [ u"cn",u"Maoming",473251,21.65,110.9 ],
    [ u"cn",u"Mata",81166,21.617844,111.336796 ],
    [ u"cn",u"Meihekou",99419,42.527222,125.675278 ],
    [ u"cn",u"Meilu",104168,21.45713,110.765907 ],
    [ u"cn",u"Mengcheng",69916,33.266109,116.566052 ],
    [ u"cn",u"Mengyin",65889,35.706944,117.926389 ],
    [ u"cn",u"Mentougou",197772,39.939167,116.091667 ],
    [ u"cn",u"Mianyang",264136,31.459339,104.754235 ],
    [ u"cn",u"Minggang",67945,32.458611,114.048611 ],
    [ u"cn",u"Mingguang",68351,32.780169,117.963776 ],
    [ u"cn",u"Mingshui",59369,47.166667,125.916667 ],
    [ u"cn",u"Mingshui",114858,36.716667,117.5 ],
    [ u"cn",u"Mingyue",58872,43.106944,128.921667 ],
    [ u"cn",u"Mishan",87257,45.543056,131.882222 ],
    [ u"cn",u"Miyang",72485,24.404167,103.442778 ],
    [ u"cn",u"Mudanjiang",665915,44.583333,129.6 ],
    [ u"cn",u"Mudu",61902,31.251958,120.511792 ],
    [ u"cn",u"Mujiayingzi",60627,42.116667,118.783333 ],
    [ u"cn",u"Nancha",121367,47.133333,129.266667 ],
    [ u"cn",u"Nanchang",1871351,28.55,115.933333 ],
    [ u"cn",u"Nanchong",204368,30.775757,106.102938 ],
    [ u"cn",u"Nanding",85495,36.748333,118.055833 ],
    [ u"cn",u"Nandu",61881,22.8525,110.823333 ],
    [ u"cn",u"Nanfeng",86129,23.743439,111.795934 ],
    [ u"cn",u"Nangong",82386,37.358056,115.374444 ],
    [ u"cn",u"Nanhai",80290,30.128189,111.778369 ],
    [ u"cn",u"Nanjing",3087010,32.061667,118.777778 ],
    [ u"cn",u"Nanlong",63405,31.35333,106.06309 ],
    [ u"cn",u"Nanma",74406,36.181667,118.158333 ],
    [ u"cn",u"Nanning",803788,22.816667,108.316667 ],
    [ u"cn",u"Nanpiao",157044,41.098218,120.747923 ],
    [ u"cn",u"Nantai",56478,40.924101,122.80437 ],
    [ u"cn",u"Nantong",666251,32.030278,120.874722 ],
    [ u"cn",u"Nanyang",251532,32.994722,112.532778 ],
    [ u"cn",u"Nanzhang",83604,31.783941,111.827518 ],
    [ u"cn",u"Nanzhou",54449,29.359551,112.402433 ],
    [ u"cn",u"Nehe",108253,48.483333,124.833333 ],
    [ u"cn",u"Neijiang",546854,29.583536,105.06216 ],
    [ u"cn",u"Nenjiang",87236,49.183333,125.216667 ],
    [ u"cn",u"Nianzishan",62131,47.516667,122.883333 ],
    [ u"cn",u"Ningan",66549,44.383333,129.433333 ],
    [ u"cn",u"Ningbo",719867,29.878186,121.549453 ],
    [ u"cn",u"Ninghai",68330,29.289167,121.424722 ],
    [ u"cn",u"Ninghai",56937,37.383333,121.583333 ],
    [ u"cn",u"Ningxiang",55312,28.25,112.55 ],
    [ u"cn",u"Ningyang",82994,35.764167,116.791389 ],
    [ u"cn",u"Nongan",98087,44.381982,125.168469 ],
    [ u"cn",u"Panshi",80200,42.942222,126.056111 ],
    [ u"cn",u"Panzhihua",461513,26.547902,101.705386 ],
    [ u"cn",u"Peking",7480601,39.928889,116.388333 ],
    [ u"cn",u"Pengcheng",68442,36.431111,114.17 ],
    [ u"cn",u"Pingdingshan",889675,33.738472,113.301194 ],
    [ u"cn",u"Pingdu",91077,36.784444,119.946389 ],
    [ u"cn",u"Pingliang",108156,35.539167,106.686111 ],
    [ u"cn",u"Pingshan",113631,22.993761,114.713109 ],
    [ u"cn",u"Pingxiang",372123,27.616667,113.85 ],
    [ u"cn",u"Pingyin",62050,36.283056,116.445278 ],
    [ u"cn",u"Pingyi",78254,35.500556,117.630833 ],
    [ u"cn",u"Pingzhuang",67273,42.037222,119.288889 ],
    [ u"cn",u"Pulandian",104277,39.395278,121.966944 ],
    [ u"cn",u"Pumiao",61690,22.75,108.483333 ],
    [ u"cn",u"Puqi",132891,29.716667,113.883333 ],
    [ u"cn",u"Puyang",666322,35.702778,115.005278 ],
    [ u"cn",u"Qianan",62337,44.993243,124.058109 ],
    [ u"cn",u"Qianguo",113611,45.117115,124.856761 ],
    [ u"cn",u"Qianjiang",179079,30.415128,112.88595 ],
    [ u"cn",u"Qidong",58287,26.768369,112.108136 ],
    [ u"cn",u"Qingan",60408,46.879444,127.506667 ],
    [ u"cn",u"Qingdao",1642245,36.098611,120.371944 ],
    [ u"cn",u"Qinggang",64182,46.683333,126.083333 ],
    [ u"cn",u"Qingquan",76154,30.45113,115.255931 ],
    [ u"cn",u"Qingyuan",151287,23.7,113.033333 ],
    [ u"cn",u"Qinhuangdao",759718,39.931667,119.588333 ],
    [ u"cn",u"Qinnan",55975,33.253056,119.913333 ],
    [ u"cn",u"Qinzhou",100996,21.95,108.616667 ],
    [ u"cn",u"Qiongshan",87657,20.005833,110.354167 ],
    [ u"cn",u"Qiqihar",882364,47.340833,123.967222 ],
    [ u"cn",u"Qitaihe",345033,45.8,130.85 ],
    [ u"cn",u"Qixia",79106,37.2975,120.825556 ],
    [ u"cn",u"Qixingtai",60169,30.413547,111.887388 ],
    [ u"cn",u"Qiyang",66442,26.573073,111.841839 ],
    [ u"cn",u"Quanzhou",184143,24.913889,118.585833 ],
    [ u"cn",u"Qufu",85144,35.596667,116.991111 ],
    [ u"cn",u"Qujing",146015,25.483333,103.783333 ],
    [ u"cn",u"Quzhou",82216,28.959444,118.868611 ],
    [ u"cn",u"Ranghulu",226298,46.65,124.866667 ],
    [ u"cn",u"Renqiu",98569,38.698889,116.093611 ],
    [ u"cn",u"Rizhao",246387,35.390278,119.545833 ],
    [ u"cn",u"Rongcheng",67397,25.725,119.379444 ],
    [ u"cn",u"Rongcheng",108908,29.845047,112.951441 ],
    [ u"cn",u"Rongcheng",102157,26.266667,104.016667 ],
    [ u"cn",u"Rongcheng",1001985,23.528858,116.364159 ],
    [ u"cn",u"Rucheng",77947,32.388333,120.555278 ],
    [ u"cn",u"Ruian",125208,27.776047,120.658588 ],
    [ u"cn",u"Sanbu",140454,22.36078,112.688088 ],
    [ u"cn",u"Sanchazi",66576,42.081667,126.600278 ],
    [ u"cn",u"Sanmenxia",357767,34.774722,111.181389 ],
    [ u"cn",u"Sanming",209444,26.248611,117.618611 ],
    [ u"cn",u"Shache",82509,38.416667,77.240556 ],
    [ u"cn",u"Shahe",125132,36.854722,114.4975 ],
    [ u"cn",u"Shancheng",74459,34.795278,116.081667 ],
    [ u"cn",u"Shanghai",14608512,31.045556,121.399722 ],
    [ u"cn",u"Shangqiu",181218,34.383333,115.616667 ],
    [ u"cn",u"Shangrao",318769,28.453221,117.968604 ],
    [ u"cn",u"Shangzhi",82419,45.214033,127.950313 ],
    [ u"cn",u"Shanhetun",57550,44.7,127.2 ],
    [ u"cn",u"Shanting",80843,35.075278,117.457778 ],
    [ u"cn",u"Shaoguan",628749,24.8,113.583333 ],
    [ u"cn",u"Shaowu",112585,27.340891,117.483096 ],
    [ u"cn",u"Shaoxing",421283,30.011019,120.571528 ],
    [ u"cn",u"Shaoyang",649452,26.965893,111.241376 ],
    [ u"cn",u"Shaping",107589,22.477547,112.845784 ],
    [ u"cn",u"Shashi",498780,30.307222,112.244722 ],
    [ u"cn",u"Shenjiamen",95433,29.957625,122.298017 ],
    [ u"cn",u"Shenxian",79196,36.241111,115.667222 ],
    [ u"cn",u"Shenyang",3512192,41.792222,123.432778 ],
    [ u"cn",u"Shenzhen",1002592,22.533333,114.133333 ],
    [ u"cn",u"Shihezi",572772,44.3,86.033333 ],
    [ u"cn",u"Shilong",109733,23.112269,113.842476 ],
    [ u"cn",u"Shima",68375,24.447778,117.811111 ],
    [ u"cn",u"Shishou",122411,29.716667,112.4 ],
    [ u"cn",u"Shitanjing",78765,39.234167,106.343889 ],
    [ u"cn",u"Shiyan",408055,32.6475,110.778056 ],
    [ u"cn",u"Shizilu",86749,35.171111,118.828889 ],
    [ u"cn",u"Shizuishan",136570,39.041944,106.395833 ],
    [ u"cn",u"Shouguang",79212,36.88,118.7375 ],
    [ u"cn",u"Shuangcheng",130710,45.35,126.283333 ],
    [ u"cn",u"Shuangyang",62137,43.524167,125.673611 ],
    [ u"cn",u"Shuangyashan",209521,46.636111,131.153889 ],
    [ u"cn",u"Shuiji",75849,36.859167,120.526944 ],
    [ u"cn",u"Shulan",77420,44.35,126.8 ],
    [ u"cn",u"Shunyi",117623,40.125,116.645278 ],
    [ u"cn",u"Simao",71094,22.788627,100.974807 ],
    [ u"cn",u"Sishui",90175,35.648889,117.275833 ],
    [ u"cn",u"Songjianghe",67672,42.185903,127.478946 ],
    [ u"cn",u"Songling",77566,31.193303,120.717577 ],
    [ u"cn",u"Suicheng",61430,33.896298,117.933066 ],
    [ u"cn",u"Suicheng",79141,21.414225,110.236498 ],
    [ u"cn",u"Suifenhe",15183,44.4,131.166667 ],
    [ u"cn",u"Suihua",252245,46.640556,126.996944 ],
    [ u"cn",u"Suileng",57124,47.166667,127.3 ],
    [ u"cn",u"Suining",124924,30.508017,105.573324 ],
    [ u"cn",u"Suixi",74172,33.890673,116.774725 ],
    [ u"cn",u"Sujiatun",148113,41.659167,123.339167 ],
    [ u"cn",u"Suozhen",58766,36.953889,118.104722 ],
    [ u"cn",u"Suzhou",205130,33.636111,116.978889 ],
    [ u"cn",u"Suzhou",1343091,31.311389,120.618056 ],
    [ u"cn",u"Tahe",60874,52.333333,124.733333 ],
    [ u"cn",u"Taian",750340,36.185278,117.12 ],
    [ u"cn",u"Taicheng",145440,22.251347,112.779904 ],
    [ u"cn",u"Taihe",83018,30.871229,105.384542 ],
    [ u"cn",u"Taikang",55316,46.833333,124.416667 ],
    [ u"cn",u"Tailai",66623,46.383333,123.4 ],
    [ u"cn",u"Taixing",79655,32.166667,120.013611 ],
    [ u"cn",u"Taiyuan",2722475,37.726944,112.470833 ],
    [ u"cn",u"Taizhou",612356,32.493333,119.910627 ],
    [ u"cn",u"Tancheng",83467,34.613611,118.339722 ],
    [ u"cn",u"Tanggu",535298,39.021111,117.646944 ],
    [ u"cn",u"Tangjiazhuang",79489,39.733333,118.45 ],
    [ u"cn",u"Tangping",81729,22.026471,111.93229 ],
    [ u"cn",u"Tangshan",2054526,37.3325,114.701389 ],
    [ u"cn",u"Tangzhai",67936,34.432778,116.591111 ],
    [ u"cn",u"Taonan",112819,45.333333,122.783333 ],
    [ u"cn",u"Taozhuang",60137,34.85,117.333333 ],
    [ u"cn",u"Tengzhou",105456,35.077061,117.151758 ],
    [ u"cn",u"Tianjin",3766207,39.142222,117.176667 ],
    [ u"cn",u"Tianmen",224871,30.65,113.1 ],
    [ u"cn",u"Tianpeng",60797,30.986641,103.939333 ],
    [ u"cn",u"Tieling",333907,42.293056,123.841389 ],
    [ u"cn",u"Tieli",109636,46.95,128.05 ],
    [ u"cn",u"Tongchuan",223603,34.898799,108.950562 ],
    [ u"cn",u"Tongchuan",58346,31.094069,105.087312 ],
    [ u"cn",u"Tongliao",261110,43.6125,122.265278 ],
    [ u"cn",u"Tongling",312588,30.933333,117.816667 ],
    [ u"cn",u"Tongren",90593,27.717222,109.185278 ],
    [ u"cn",u"Tongzhou",163326,39.905278,116.599444 ],
    [ u"cn",u"Tongzi",80344,28.1375,106.82 ],
    [ u"cn",u"Tumen",78719,42.966111,129.8425 ],
    [ u"cn",u"Tunxi",77000,29.711389,118.3125 ],
    [ u"cn",u"Ürümqi",1508225,43.800965,87.600459 ],
    [ u"cn",u"Wangkui",69915,46.833333,126.5 ],
    [ u"cn",u"Wangou",65298,42.059722,126.915833 ],
    [ u"cn",u"Wangqing",88732,43.321787,129.763416 ],
    [ u"cn",u"Wanning",64954,18.800278,110.396667 ],
    [ u"cn",u"Wanxian",188980,30.803889,108.389722 ],
    [ u"cn",u"Weifang",394732,36.71,119.101944 ],
    [ u"cn",u"Weihai",152595,37.501667,122.113611 ],
    [ u"cn",u"Weihe",71344,44.966667,128.383333 ],
    [ u"cn",u"Weinan",172321,34.503546,109.508908 ],
    [ u"cn",u"Wencheng",115370,37.193611,122.051111 ],
    [ u"cn",u"Wenling",67433,28.366944,121.36 ],
    [ u"cn",u"Wenshang",59455,35.7275,116.496111 ],
    [ u"cn",u"Wenzhou",865672,27.999416,120.66682 ],
    [ u"cn",u"Wuan",66523,36.694444,114.196389 ],
    [ u"cn",u"Wuchang",94786,44.914282,127.150007 ],
    [ u"cn",u"Wucheng",60212,29.600768,118.174951 ],
    [ u"cn",u"Wuda",129922,39.499444,106.711667 ],
    [ u"cn",u"Wufeng",101728,27.45,104.833333 ],
    [ u"cn",u"Wuhan",4184206,30.580125,114.273405 ],
    [ u"cn",u"Wuhu",507524,31.14607,118.57069 ],
    [ u"cn",u"Wulanhaote",165846,46.083333,122.083333 ],
    [ u"cn",u"Wuning",130387,29.258873,120.231083 ],
    [ u"cn",u"Wuwei",109319,37.928056,102.641389 ],
    [ u"cn",u"Wuxi",1108647,31.568873,120.288573 ],
    [ u"cn",u"Wuxue",220661,29.850578,115.552504 ],
    [ u"cn",u"Wuzhou",265846,23.483333,111.316667 ],
    [ u"cn",u"Xiamen",578337,24.479794,118.081869 ],
    [ u"cn",u"Xiangdong",103815,27.7,113.7 ],
    [ u"cn",u"Xiangfan",462956,32.042203,112.144794 ],
    [ u"cn",u"Xiangxiang",87592,27.733333,112.533333 ],
    [ u"cn",u"Xianshuigu",74028,38.985,117.382778 ],
    [ u"cn",u"Xiantao",239406,30.383333,113.4 ],
    [ u"cn",u"Xian",3953191,34.258333,108.928611 ],
    [ u"cn",u"Xianyang",1034081,34.33778,108.70261 ],
    [ u"cn",u"Xiaolan",187865,22.673811,113.231874 ],
    [ u"cn",u"Xiaolingwei",66031,32.033333,118.85 ],
    [ u"cn",u"Xiaoshan",95234,30.167456,120.258831 ],
    [ u"cn",u"Xiaoshi",68994,41.297111,124.120918 ],
    [ u"cn",u"Xiaoweizhai",58913,26.190278,107.5125 ],
    [ u"cn",u"Xiaoyi",56033,34.76,112.971389 ],
    [ u"cn",u"Xiashi",70171,30.536294,120.686384 ],
    [ u"cn",u"Xiazhen",125667,34.802222,117.111667 ],
    [ u"cn",u"Xichang",126787,27.896422,102.263415 ],
    [ u"cn",u"Xifeng",61087,42.737222,124.722222 ],
    [ u"cn",u"Xihe",90422,31.686355,113.465846 ],
    [ u"cn",u"Xihua",66848,33.783333,114.516667 ],
    [ u"cn",u"Ximei",94326,24.963889,118.379444 ],
    [ u"cn",u"Xinan",61816,34.375833,118.345 ],
    [ u"cn",u"Xingcheng",98968,40.616667,120.716667 ],
    [ u"cn",u"Xinglongshan",58432,43.956111,125.466111 ],
    [ u"cn",u"Xingtai",611739,37.063056,114.494167 ],
    [ u"cn",u"Xingyi",119000,25.05,104.983333 ],
    [ u"cn",u"Xining",767531,36.616667,101.766667 ],
    [ u"cn",u"Xinmin",74139,41.990833,122.825278 ],
    [ u"cn",u"Xinpu",392444,34.599722,119.159444 ],
    [ u"cn",u"Xinqing",55415,48.233333,129.5 ],
    [ u"cn",u"Xintai",222459,35.900556,117.751944 ],
    [ u"cn",u"Xinxiang",743601,35.308889,113.867222 ],
    [ u"cn",u"Xinyang",1590668,32.095833,114.120278 ],
    [ u"cn",u"Xinye",61633,32.518611,112.352222 ],
    [ u"cn",u"Xinyu",97480,27.804294,114.933354 ],
    [ u"cn",u"Xinzhi",72303,36.498889,111.704722 ],
    [ u"cn",u"Xinzhou",78767,30.866667,114.8 ],
    [ u"cn",u"Xinzhou",154003,38.409167,112.733333 ],
    [ u"cn",u"Xiongshi",73732,28.288572,117.213291 ],
    [ u"cn",u"Xiongyue",89887,40.177368,122.122844 ],
    [ u"cn",u"Xiongzhou",79050,25.116667,114.3 ],
    [ u"cn",u"Xiuyan",71614,40.276985,123.282968 ],
    [ u"cn",u"Xixiang",60745,35.162778,112.865 ],
    [ u"cn",u"Xuanhua",373422,40.610278,115.044722 ],
    [ u"cn",u"Xuanwu",56195,33.966667,115.233333 ],
    [ u"cn",u"Xuanzhou",127758,30.9525,118.755278 ],
    [ u"cn",u"Xuchang",449258,34.016667,113.816667 ],
    [ u"cn",u"Xucheng",83267,20.350001,110.128837 ],
    [ u"cn",u"Xunchang",64580,28.454332,104.714984 ],
    [ u"cn",u"Xushan",80299,30.176405,121.245702 ],
    [ u"cn",u"Xuzhou",1199193,34.180454,117.15707 ],
    [ u"cn",u"Yaan",108758,29.989788,103.003694 ],
    [ u"cn",u"Yakeshi",116284,49.283333,120.733333 ],
    [ u"cn",u"Yanan",107960,36.598889,109.491667 ],
    [ u"cn",u"Yancheng",628441,33.385556,120.125278 ],
    [ u"cn",u"Yangcun",63756,39.363889,117.060278 ],
    [ u"cn",u"Yanggu",74725,36.110556,115.775278 ],
    [ u"cn",u"Yangjiang",399735,21.85,111.966667 ],
    [ u"cn",u"Yangliuqing",76387,39.1375,116.999722 ],
    [ u"cn",u"Yangshan",57240,35.183333,116.25 ],
    [ u"cn",u"Yangshe",66039,31.889945,120.605215 ],
    [ u"cn",u"Yangzhou",539715,32.397222,119.435833 ],
    [ u"cn",u"Yanji",326957,42.771389,129.423333 ],
    [ u"cn",u"Yanliang",60891,34.659177,109.22921 ],
    [ u"cn",u"Yantai",719332,37.533333,121.4 ],
    [ u"cn",u"Yantongshan",57515,43.291944,126.009444 ],
    [ u"cn",u"Yanzhou",77276,35.552778,116.828611 ],
    [ u"cn",u"Yashan",56629,22.1975,109.941944 ],
    [ u"cn",u"Yatou",91517,37.15,122.383333 ],
    [ u"cn",u"Yebaishou",65536,41.3975,119.640833 ],
    [ u"cn",u"Yian",73299,47.883333,125.3 ],
    [ u"cn",u"Yibin",242111,28.699702,104.549173 ],
    [ u"cn",u"Yichang",476725,30.77135,111.321458 ],
    [ u"cn",u"Yicheng",61027,31.704722,112.256111 ],
    [ u"cn",u"Yichun",152169,27.833333,114.4 ],
    [ u"cn",u"Yichun",155762,47.7,128.9 ],
    [ u"cn",u"Yidu",117056,36.696667,118.479722 ],
    [ u"cn",u"Yigou",59073,35.811389,114.316667 ],
    [ u"cn",u"Yilan",71180,46.316667,129.566667 ],
    [ u"cn",u"Yima",82509,34.738056,111.883889 ],
    [ u"cn",u"Yinchuan",475101,38.468056,106.273056 ],
    [ u"cn",u"Yingcheng",265886,30.95,113.55 ],
    [ u"cn",u"Yingcheng",115538,24.165876,113.412675 ],
    [ u"cn",u"Yingkou",591159,40.637318,122.502508 ],
    [ u"cn",u"Yingshang",61771,32.629453,116.270135 ],
    [ u"cn",u"Yingzhong",108883,31.166111,112.583056 ],
    [ u"cn",u"Yining",257671,43.881111,81.245833 ],
    [ u"cn",u"Yishui",94115,35.784722,118.628056 ],
    [ u"cn",u"Yiyang",202608,28.589167,112.328333 ],
    [ u"cn",u"Yizheng",176006,32.269167,119.178889 ],
    [ u"cn",u"Yongan",134858,25.98,117.364167 ],
    [ u"cn",u"Yongchang",94465,29.351389,105.894722 ],
    [ u"cn",u"Yongzhou",86095,26.423889,111.613056 ],
    [ u"cn",u"Youhao",78402,47.866667,128.833333 ],
    [ u"cn",u"Yuancheng",93718,23.733333,114.683333 ],
    [ u"cn",u"Yuanping",82883,38.715278,112.7575 ],
    [ u"cn",u"Yuci",235929,37.680278,112.731944 ],
    [ u"cn",u"Yudong",81408,29.385,106.519444 ],
    [ u"cn",u"Yueyang",528140,29.140833,113.111111 ],
    [ u"cn",u"Yulin",148485,22.633333,110.15 ],
    [ u"cn",u"Yumen",84769,39.833333,97.733333 ],
    [ u"cn",u"Yuncheng",201950,35.023056,110.992778 ],
    [ u"cn",u"Yuncheng",64511,35.598333,115.934722 ],
    [ u"cn",u"Yuncheng",96192,22.930558,112.037297 ],
    [ u"cn",u"Yunhe",82641,34.311389,117.950278 ],
    [ u"cn",u"Yunjinghong",62105,21.991015,100.734086 ],
    [ u"cn",u"Yunyang",73922,33.447432,112.714225 ],
    [ u"cn",u"Yushan",140039,31.377623,120.954305 ],
    [ u"cn",u"Yushu",124736,44.8,126.533333 ],
    [ u"cn",u"Yuxia",60206,34.061535,108.629046 ],
    [ u"cn",u"Yuyao",114177,30.05,121.149444 ],
    [ u"cn",u"Yuzhou",87961,34.162778,113.463889 ],
    [ u"cn",u"Zalantun",132224,48,122.716667 ],
    [ u"cn",u"Zaoyang",184509,32.127222,112.754167 ],
    [ u"cn",u"Zaozhuang",183665,34.864722,117.554167 ],
    [ u"cn",u"Zhangdian",669770,36.790556,118.063333 ],
    [ u"cn",u"Zhangjiakou",692602,40.81,114.879444 ],
    [ u"cn",u"Zhangye",96228,38.934167,100.451667 ],
    [ u"cn",u"Zhangzhou",589831,24.513333,117.655556 ],
    [ u"cn",u"Zhanjiang",637790,21.281452,110.342713 ],
    [ u"cn",u"Zhaocheng",100774,37.359167,120.396389 ],
    [ u"cn",u"Zhaodong",154406,46.083333,125.983333 ],
    [ u"cn",u"Zhaoqing",361969,23.051157,112.459722 ],
    [ u"cn",u"Zhaotong",109400,27.316667,103.716667 ],
    [ u"cn",u"Zhaoyang",105918,32.939167,119.834167 ],
    [ u"cn",u"Zhaoyuan",59370,45.5,125.133333 ],
    [ u"cn",u"Zhaozhou",62373,45.683333,125.316667 ],
    [ u"cn",u"Zhengjiatun",93666,43.506389,123.506389 ],
    [ u"cn",u"Zhenhai",61979,29.969497,121.687529 ],
    [ u"cn",u"Zhenjiang",632552,32.209167,119.434167 ],
    [ u"cn",u"Zhenlai",67760,45.849549,123.297296 ],
    [ u"cn",u"Zhicheng",63753,31.006111,119.903611 ],
    [ u"cn",u"Zhicheng",59187,27.046944,118.325278 ],
    [ u"cn",u"Zhicheng",159383,30.295556,111.504722 ],
    [ u"cn",u"Zhifang",76682,30.35,114.316667 ],
    [ u"cn",u"Zhongshan",342306,22.520576,113.382318 ],
    [ u"cn",u"Zhongshu",91750,24.516667,103.766667 ],
    [ u"cn",u"Zhongxing",57338,33.703889,118.679167 ],
    [ u"cn",u"Zhoucheng",72070,35.912222,116.311667 ],
    [ u"cn",u"Zhoucheng",103829,24.355,102.542222 ],
    [ u"cn",u"Zhoucun",122402,36.816667,117.816667 ],
    [ u"cn",u"Zhoukou",377061,33.633333,114.633333 ],
    [ u"cn",u"Zhuanghe",80384,39.700833,122.991111 ],
    [ u"cn",u"Zhucheng",109968,35.994722,119.3975 ],
    [ u"cn",u"Zhuhai",501199,22.276944,113.567778 ],
    [ u"cn",u"Zhuji",110721,29.718765,120.242333 ],
    [ u"cn",u"Zhumadian",253536,32.979444,114.029444 ],
    [ u"cn",u"Zhuozhou",116310,39.481111,115.963333 ],
    [ u"cn",u"Zhuzhou",709358,27.691868,113.152137 ],
    [ u"cn",u"Zigong",689961,29.341622,104.776887 ],
    [ u"cn",u"Ziyang",87400,30.121083,104.648106 ],
    [ u"cn",u"Zouxian",190537,35.400556,116.965556 ],
    [ u"cn",u"Zunyi",466292,27.543056,106.823056 ],
    [ u"co",u"Abejorral",7360,5.789281,-75.427252 ],
    [ u"co",u"Ábrego",10823,8.080647,-73.220543 ],
    [ u"co",u"Abriaquí",1281,6.631477,-76.064437 ],
    [ u"co",u"Acacías",40628,3.986946,-73.757971 ],
    [ u"co",u"Acandí",4840,8.506334,-77.277839 ],
    [ u"co",u"Acaricuará",430,.7,-70.233333 ],
    [ u"co",u"Acevedo",4451,1.836055,-75.854985 ],
    [ u"co",u"Achí",8434,8.568178,-74.554052 ],
    [ u"co",u"Agrado",4531,2.257254,-75.771421 ],
    [ u"co",u"Aguachica",73361,8.308442,-73.6166 ],
    [ u"co",u"Aguadas",19727,5.611612,-75.456235 ],
    [ u"co",u"Agua de Dios",10876,4.376478,-74.669952 ],
    [ u"co",u"Aguazul",15670,5.172819,-72.547058 ],
    [ u"co",u"Agustín Codazzi",51479,10.034087,-73.236111 ],
    [ u"co",u"Aipe",7964,3.222222,-75.236667 ],
    [ u"co",u"Albán",1684,4.876608,-74.437683 ],
    [ u"co",u"Albania",4160,1.328661,-75.878235 ],
    [ u"co",u"Albania",6365,11.160987,-72.592385 ],
    [ u"co",u"Albania",810,5.761389,-73.917778 ],
    [ u"co",u"Alcalá",9135,4.674722,-75.7825 ],
    [ u"co",u"Aldana",1956,.882828,-77.701026 ],
    [ u"co",u"Alejandría",2725,6.377447,-75.140649 ],
    [ u"co",u"Algarrobo",10042,10.1,-74.266667 ],
    [ u"co",u"Algeciras",10792,2.522953,-75.314922 ],
    [ u"co",u"Almaguer",3120,1.917,-76.852331 ],
    [ u"co",u"Almeida",754,4.970833,-73.379722 ],
    [ u"co",u"Altamira",2123,2.062778,-75.787222 ],
    [ u"co",u"Alto Baudó",3242,5.516042,-76.97449 ],
    [ u"co",u"Altos del Rosario",5220,8.794444,-74.165833 ],
    [ u"co",u"Alvarado",2049,4.566124,-74.962294 ],
    [ u"co",u"Amagá",12170,6.040011,-75.703151 ],
    [ u"co",u"Amalfi",9733,6.910163,-75.077644 ],
    [ u"co",u"Ambalema",4892,4.78405,-74.762682 ],
    [ u"co",u"Anapoima",4953,4.520278,-74.539444 ],
    [ u"co",u"Ancuya",5852,1.2703,-77.515749 ],
    [ u"co",u"Andalucía",17432,4.17061,-76.166411 ],
    [ u"co",u"Andes",16420,5.656098,-75.878772 ],
    [ u"co",u"Angelópolis",1917,6.083333,-75.7 ],
    [ u"co",u"Angostura",3640,6.885077,-75.334669 ],
    [ u"co",u"Anolaima",5585,4.765904,-74.465477 ],
    [ u"co",u"Anorí",4762,7.072725,-75.147677 ],
    [ u"co",u"Anserma",25242,5.332778,-75.791111 ],
    [ u"co",u"Ansermanuevo",12332,4.797222,-75.995 ],
    [ u"co",u"Antioquia",11829,6.556867,-75.828056 ],
    [ u"co",u"Anzoátegui",2229,4.629963,-75.09539 ],
    [ u"co",u"Apartadó",86439,7.866667,-76.666667 ],
    [ u"co",u"Apía",6940,5.10645,-75.943177 ],
    [ u"co",u"Aquitania",5718,5.519722,-72.8875 ],
    [ u"co",u"Aracataca",27704,10.591812,-74.189831 ],
    [ u"co",u"Aranzazu",9327,5.271232,-75.490438 ],
    [ u"co",u"Aratoca",2101,6.693532,-73.020826 ],
    [ u"co",u"Arauca",69266,7.084512,-70.755366 ],
    [ u"co",u"Arbeláez",5252,4.272543,-74.415128 ],
    [ u"co",u"Arboleda",1736,1.508584,-77.124435 ],
    [ u"co",u"Arboledas",2702,7.642333,-72.799442 ],
    [ u"co",u"Arboletes",8381,8.85051,-76.426939 ],
    [ u"co",u"Arcabuco",1564,5.754629,-73.436694 ],
    [ u"co",u"Arenal",5346,8.459278,-73.943309 ],
    [ u"co",u"Argelia",3474,5.731269,-75.142573 ],
    [ u"co",u"Argelia",4262,2.25563,-77.248762 ],
    [ u"co",u"Argelia",3419,4.723415,-76.119091 ],
    [ u"co",u"Ariguaní",26246,10.25,-74 ],
    [ u"co",u"Arjona",50406,10.254444,-75.343889 ],
    [ u"co",u"Armenia",2035,6.156389,-75.787222 ],
    [ u"co",u"Armenia",315332,4.533889,-75.681111 ],
    [ u"co",u"Arroyohondo",3622,10.252204,-75.019801 ],
    [ u"co",u"Astrea",8996,9.498276,-73.975914 ],
    [ u"co",u"Ataco",4105,3.591466,-75.381776 ],
    [ u"co",u"Ayapel",22602,8.313721,-75.139822 ],
    [ u"co",u"Bagadó",4561,5.411637,-76.415202 ],
    [ u"co",u"Bajo Baudó",6168,4.953336,-77.365975 ],
    [ u"co",u"Balboa",6272,2.039556,-77.216839 ],
    [ u"co",u"Balboa",2302,4.951667,-75.957222 ],
    [ u"co",u"Baranoa",44079,10.794084,-74.9164 ],
    [ u"co",u"Baraya",4402,3.153333,-75.053056 ],
    [ u"co",u"Barbacoas",7634,1.671536,-78.139782 ],
    [ u"co",u"Barbosa",16707,6.438088,-75.331355 ],
    [ u"co",u"Barbosa",20373,5.931675,-73.615065 ],
    [ u"co",u"Barichara",4150,6.635725,-73.222824 ],
    [ u"co",u"Barrancabermeja",191406,7.065278,-73.854722 ],
    [ u"co",u"Barranca de Upía",1178,4.569634,-72.966758 ],
    [ u"co",u"Barrancas",17350,10.957561,-72.787693 ],
    [ u"co",u"Barranco de Loba",5933,8.945973,-74.10647 ],
    [ u"co",u"Barranquilla",1380437,10.963889,-74.796389 ],
    [ u"co",u"Becerril",9002,9.704134,-73.279298 ],
    [ u"co",u"Belalcázar",6367,4.995278,-75.812778 ],
    [ u"co",u"Belén",3131,1.597871,-77.013993 ],
    [ u"co",u"Belén",5411,5.988921,-72.912544 ],
    [ u"co",u"Belén de Umbría",15698,5.200875,-75.868652 ],
    [ u"co",u"Bello",392945,6.337315,-75.557951 ],
    [ u"co",u"Belmira",1388,6.605082,-75.666193 ],
    [ u"co",u"Beltrán",296,4.801653,-74.741772 ],
    [ u"co",u"Berbeo",266,5.226752,-73.126076 ],
    [ u"co",u"Betania",3800,5.607778,-75.7125 ],
    [ u"co",u"Betéitiva",374,5.911024,-72.809263 ],
    [ u"co",u"Betulia",5216,6.112836,-75.983784 ],
    [ u"co",u"Betulia",1716,6.900694,-73.283472 ],
    [ u"co",u"Bituima",473,4.872516,-74.539255 ],
    [ u"co",u"Boavita",3749,6.33031,-72.58505 ],
    [ u"co",u"Bochalema",2511,7.610955,-72.647735 ],
    [ u"co",u"Bogotá",7102602,4.649178,-74.062827 ],
    [ u"co",u"Bojacá",4399,4.731762,-74.341289 ],
    [ u"co",u"Bojayá",1396,6.521299,-76.972342 ],
    [ u"co",u"Bolívar",15493,1.839944,-76.968889 ],
    [ u"co",u"Bolívar",2230,5.989426,-73.770208 ],
    [ u"co",u"Bolívar",4165,4.3387,-76.183416 ],
    [ u"co",u"Bosconia",24508,9.968889,-73.883611 ],
    [ u"co",u"Boyacá",731,5.453715,-73.362497 ],
    [ u"co",u"Briceño",2214,7.110957,-75.551523 ],
    [ u"co",u"Briceño",632,5.688221,-73.917838 ],
    [ u"co",u"Bucaramanga",571827,7.125393,-73.119804 ],
    [ u"co",u"Bucarasica",783,8.040955,-72.865376 ],
    [ u"co",u"Buenaventura",240391,3.880099,-77.031164 ],
    [ u"co",u"Buenavista",5062,9.049634,-76.002799 ],
    [ u"co",u"Buenavista",2084,4.353898,-75.717821 ],
    [ u"co",u"Buenos Aires",2144,3.015033,-76.642748 ],
    [ u"co",u"Buesaco",4177,1.390167,-77.159815 ],
    [ u"co",u"Buga",118006,3.900889,-76.297829 ],
    [ u"co",u"Bugalagrande",12418,4.212073,-76.155638 ],
    [ u"co",u"Buriticá",2388,6.718732,-75.907344 ],
    [ u"co",u"Busbanzá",164,5.830471,-72.884192 ],
    [ u"co",u"Cabrera",363,6.593261,-73.245453 ],
    [ u"co",u"Cabrera",1397,3.985982,-74.482834 ],
    [ u"co",u"Cabuyaro",1140,4.281704,-72.793994 ],
    [ u"co",u"Cáceres",4987,7.580779,-75.348422 ],
    [ u"co",u"Cachipay",4260,5.266667,-74.566667 ],
    [ u"co",u"Cáchira",2097,7.741035,-73.0483 ],
    [ u"co",u"Cácota",1415,7.267872,-72.641969 ],
    [ u"co",u"Caicedo",1617,6.405108,-75.982548 ],
    [ u"co",u"Caicedonia",32417,4.332396,-75.826654 ],
    [ u"co",u"Caimito",2925,8.812288,-75.410663 ],
    [ u"co",u"Cajamarca",9310,4.441724,-75.426783 ],
    [ u"co",u"Cajibío",3365,2.622712,-76.570388 ],
    [ u"co",u"Cajicá",25000,4.918574,-74.027993 ],
    [ u"co",u"Calamar",3745,1.959598,-72.653147 ],
    [ u"co",u"Calamar",9180,10.251103,-74.914617 ],
    [ u"co",u"Calarcá",62171,4.529486,-75.640914 ],
    [ u"co",u"Caldas",65566,6.091056,-75.63569 ],
    [ u"co",u"Caldas",475,5.554556,-73.865667 ],
    [ u"co",u"Caldono",3518,2.797395,-76.483165 ],
    [ u"co",u"Cali",2392897,3.437222,-76.5225 ],
    [ u"co",u"California",573,7.347089,-72.945185 ],
    [ u"co",u"Caloto",6479,3.035863,-76.407883 ],
    [ u"co",u"Campamento",1870,6.979196,-75.297235 ],
    [ u"co",u"Campoalegre",22569,2.684892,-75.323109 ],
    [ u"co",u"Campo de la Cruz",22804,10.378077,-74.883561 ],
    [ u"co",u"Campohermoso",695,5.031323,-73.103271 ],
    [ u"co",u"Canalete",2620,8.676111,-76.204167 ],
    [ u"co",u"Cañasgordas",6026,6.749891,-76.025393 ],
    [ u"co",u"Candelaria",11427,10.459117,-74.879697 ],
    [ u"co",u"Candelaria",23989,3.406711,-76.348192 ],
    [ u"co",u"Cantagallo",4672,7.375989,-73.919626 ],
    [ u"co",u"Caparrapí",4477,5.346438,-74.491473 ],
    [ u"co",u"Capitanejo",3791,6.528812,-72.695949 ],
    [ u"co",u"Cáqueza",7958,4.405687,-73.946828 ],
    [ u"co",u"Caracolí",3120,6.409196,-74.757153 ],
    [ u"co",u"Caramanta",3044,5.547819,-75.643677 ],
    [ u"co",u"Carcasí",862,6.627114,-72.626249 ],
    [ u"co",u"Carepa",20627,7.758489,-76.652545 ],
    [ u"co",u"Carmen de Apicalá",5640,4.147252,-74.720141 ],
    [ u"co",u"Carmen de Carupa",1928,5.348619,-73.901683 ],
    [ u"co",u"Carmen de Viboral",21152,6.082358,-75.335088 ],
    [ u"co",u"Carolina",3160,6.724393,-75.28168 ],
    [ u"co",u"Cartagena",952036,10.399722,-75.514444 ],
    [ u"co",u"Cartagena del Chairá",7586,1.334884,-74.842886 ],
    [ u"co",u"Cartago",134829,4.746389,-75.911667 ],
    [ u"co",u"Casabianca",1593,5.079586,-75.120591 ],
    [ u"co",u"Caucasia",58035,7.986544,-75.193488 ],
    [ u"co",u"Cepitá",377,6.754266,-72.974395 ],
    [ u"co",u"Cereté",55514,8.884788,-75.790522 ],
    [ u"co",u"Cerinza",1499,5.955676,-72.947826 ],
    [ u"co",u"Cerrito",2435,6.843147,-72.694041 ],
    [ u"co",u"Cerro San Antonio",7058,10.325853,-74.869331 ],
    [ u"co",u"Cértegui",2855,5.370729,-76.604398 ],
    [ u"co",u"Chaguaní",1108,4.948286,-74.593922 ],
    [ u"co",u"Chalán",2897,9.54765,-75.311285 ],
    [ u"co",u"Chámeza",948,5.214209,-72.869481 ],
    [ u"co",u"Chaparral",19982,3.723149,-75.483165 ],
    [ u"co",u"Charalá",5727,5.836474,-73.281049 ],
    [ u"co",u"Charta",650,7.280252,-72.967815 ],
    [ u"co",u"Chía",64570,4.858755,-74.058659 ],
    [ u"co",u"Chigorodó",48444,7.666379,-76.681059 ],
    [ u"co",u"Chimá",2785,9.148927,-75.628406 ],
    [ u"co",u"Chima",786,6.34431,-73.373929 ],
    [ u"co",u"Chimichagua",16746,9.257778,-73.81228 ],
    [ u"co",u"Chinácota",9667,7.607313,-72.601078 ],
    [ u"co",u"Chinavita",1113,5.167231,-73.368231 ],
    [ u"co",u"Chinchiná",68513,4.9825,-75.603611 ],
    [ u"co",u"Chinú",19596,9.10569,-75.398116 ],
    [ u"co",u"Chipaque",2707,4.4425,-74.044167 ],
    [ u"co",u"Chipatá",868,6.061956,-73.637181 ],
    [ u"co",u"Chiquinquirá",45295,5.616373,-73.817484 ],
    [ u"co",u"Chíquiza",730,5.604123,-73.485181 ],
    [ u"co",u"Chiriguaná",15181,9.362379,-73.603135 ],
    [ u"co",u"Chiscas",1356,6.552358,-72.499761 ],
    [ u"co",u"Chita",2914,6.187147,-72.472597 ],
    [ u"co",u"Chitagá",3871,7.137813,-72.664558 ],
    [ u"co",u"Chivatá",664,5.558233,-73.281983 ],
    [ u"co",u"Chivolo",11457,10.025022,-74.622789 ],
    [ u"co",u"Chivor",1622,4.885556,-73.368889 ],
    [ u"co",u"Choachí",4281,4.528969,-73.922727 ],
    [ u"co",u"Chocontá",7592,5.14468,-73.685782 ],
    [ u"co",u"Cicuco",7662,9.263056,-74.656944 ],
    [ u"co",u"Ciénaga",88313,11.007029,-74.247646 ],
    [ u"co",u"Ciénaga de Oro",17623,8.874433,-75.620278 ],
    [ u"co",u"Ciénega",1172,5.408669,-73.295722 ],
    [ u"co",u"Cimitarra",11267,6.314192,-73.949684 ],
    [ u"co",u"Circasia",20113,4.618889,-75.635833 ],
    [ u"co",u"Cisneros",8204,6.538333,-75.088611 ],
    [ u"co",u"Clemencia",8775,10.566455,-75.324986 ],
    [ u"co",u"Cocorná",5257,6.057299,-75.185241 ],
    [ u"co",u"Coello",769,4.289084,-74.898248 ],
    [ u"co",u"Cogua",4755,5.060515,-73.979253 ],
    [ u"co",u"Colombia",2388,3.376064,-74.801495 ],
    [ u"co",u"Colón",1348,1.643222,-77.024333 ],
    [ u"co",u"Colón",3269,1.191167,-76.9685 ],
    [ u"co",u"Colosó",3749,9.491496,-75.361451 ],
    [ u"co",u"Cómbita",1034,5.633118,-73.323981 ],
    [ u"co",u"Concepción",1513,6.394081,-75.258301 ],
    [ u"co",u"Concepción",2520,6.766195,-72.694004 ],
    [ u"co",u"Concordia",9324,6.046392,-75.907055 ],
    [ u"co",u"Concordia",6625,9.835452,-74.455478 ],
    [ u"co",u"Condoto",9898,5.093506,-76.649728 ],
    [ u"co",u"Confines",472,6.363601,-73.243959 ],
    [ u"co",u"Consacá",2239,1.215444,-77.469554 ],
    [ u"co",u"Contadero",1604,.907001,-77.547289 ],
    [ u"co",u"Contratación",3505,6.290053,-73.473536 ],
    [ u"co",u"Convención",9915,8.386944,-73.339722 ],
    [ u"co",u"Copacabana",49170,6.346328,-75.508875 ],
    [ u"co",u"Coper",814,5.476806,-74.044163 ],
    [ u"co",u"Córdoba",4063,4.393185,-75.689353 ],
    [ u"co",u"Córdoba",6597,9.586119,-74.827054 ],
    [ u"co",u"Córdoba",6597,9.633333,-74.783333 ],
    [ u"co",u"Corinto",16579,3.174072,-76.259928 ],
    [ u"co",u"Coromoro",1010,6.294611,-73.040219 ],
    [ u"co",u"Corozal",39801,9.315046,-75.292827 ],
    [ u"co",u"Corrales",1561,5.829683,-72.843321 ],
    [ u"co",u"Cota",7615,4.809384,-74.098001 ],
    [ u"co",u"Cotorra",4880,9.03886,-75.789688 ],
    [ u"co",u"Covarachía",590,6.505634,-72.733095 ],
    [ u"co",u"Coyaima",3893,3.799359,-75.194669 ],
    [ u"co",u"Cravo Norte",4787,6.301735,-70.204154 ],
    [ u"co",u"Cuaspud",2010,.861944,-77.814722 ],
    [ u"co",u"Cubará",1466,7.00078,-72.108524 ],
    [ u"co",u"Cubarral",2280,3.793524,-73.840634 ],
    [ u"co",u"Cucaita",1417,5.543728,-73.454331 ],
    [ u"co",u"Cucunubá",1699,5.249578,-73.766096 ],
    [ u"co",u"Cúcuta",721406,7.893907,-72.507821 ],
    [ u"co",u"Cucutilla",1950,7.539411,-72.772384 ],
    [ u"co",u"Cuítiva",233,5.580067,-72.966871 ],
    [ u"co",u"Cumaral",11264,4.270802,-73.486694 ],
    [ u"co",u"Cumaribo",629,4.445515,-69.798969 ],
    [ u"co",u"Cumbal",7529,.90875,-77.791451 ],
    [ u"co",u"Cumbitara",1091,1.651744,-77.582248 ],
    [ u"co",u"Cunday",2082,4.060035,-74.692117 ],
    [ u"co",u"Curillo",9540,1.033271,-75.919065 ],
    [ u"co",u"Curití",3417,6.60519,-73.068094 ],
    [ u"co",u"Curumaní",22085,9.199918,-73.542738 ],
    [ u"co",u"Dabeiba",11548,7.001719,-76.267225 ],
    [ u"co",u"Dagua",12320,3.656852,-76.68859 ],
    [ u"co",u"Darién",11724,3.930645,-76.484811 ],
    [ u"co",u"Dibulla",4402,11.272506,-73.309107 ],
    [ u"co",u"Distracción",4742,10.896933,-72.886099 ],
    [ u"co",u"Don Matías",10011,6.485685,-75.394959 ],
    [ u"co",u"Dos Quebradas",179586,4.839164,-75.667265 ],
    [ u"co",u"Duitama",92041,5.824499,-73.034083 ],
    [ u"co",u"Durania",3471,7.713073,-72.657591 ],
    [ u"co",u"Ebéjico",2583,6.325983,-75.768348 ],
    [ u"co",u"El Águila",2725,4.91345,-76.040042 ],
    [ u"co",u"El Bagre",40799,7.592724,-74.80858 ],
    [ u"co",u"El Banco",54524,9.001137,-73.975807 ],
    [ u"co",u"El Bordo",12072,2.116958,-76.982137 ],
    [ u"co",u"El Cairo",3268,4.666667,-76.016667 ],
    [ u"co",u"El Calvario",557,4.353424,-73.711467 ],
    [ u"co",u"El Carmen de Bolívar",47958,9.717396,-75.120232 ],
    [ u"co",u"El Carmen",2258,5.887778,-75.164167 ],
    [ u"co",u"El Carmen",5286,8.510637,-73.447755 ],
    [ u"co",u"El Carmen",1602,6.697358,-73.511165 ],
    [ u"co",u"El Castillo",2581,3.563629,-73.794885 ],
    [ u"co",u"El Cerrito",38391,3.685486,-76.313716 ],
    [ u"co",u"El Cocuy",2706,6.407836,-72.444637 ],
    [ u"co",u"El Copey",18137,10.150311,-73.961397 ],
    [ u"co",u"El Doncello",13082,1.678168,-75.284655 ],
    [ u"co",u"El Dorado",1011,2.774106,-72.868341 ],
    [ u"co",u"El Dovio",7943,4.5079,-76.236193 ],
    [ u"co",u"El Espino",1313,6.48277,-72.497181 ],
    [ u"co",u"El Guacamayo",428,6.245179,-73.496553 ],
    [ u"co",u"El Guamo",4732,10.031553,-74.976121 ],
    [ u"co",u"Elías",1117,2.011696,-75.939685 ],
    [ u"co",u"El Molino",5265,10.652246,-72.924046 ],
    [ u"co",u"El Paso",6367,9.660567,-73.747231 ],
    [ u"co",u"El Paujil",7619,1.57006,-75.328629 ],
    [ u"co",u"El Peñol",2294,1.459868,-77.44544 ],
    [ u"co",u"El Peñón",831,6.55,-72.833333 ],
    [ u"co",u"El Peñón",728,5.252638,-74.290689 ],
    [ u"co",u"El Peñón",4204,8.989155,-73.948571 ],
    [ u"co",u"El Piñón",7481,10.402827,-74.824153 ],
    [ u"co",u"El Playón",5334,7.471313,-73.203104 ],
    [ u"co",u"El Retén",15901,10.611353,-74.268237 ],
    [ u"co",u"El Retorno",3362,2.330225,-72.627648 ],
    [ u"co",u"El Roble",3324,9.101935,-75.19508 ],
    [ u"co",u"El Rosal",5552,4.853142,-74.259955 ],
    [ u"co",u"El Rosario",2607,1.741734,-77.3352 ],
    [ u"co",u"El Tambo",6355,2.451994,-76.810288 ],
    [ u"co",u"El Tambo",7279,1.418142,-77.396784 ],
    [ u"co",u"El Tarra",3336,8.575621,-73.094891 ],
    [ u"co",u"El Zulia",13521,7.932478,-72.601252 ],
    [ u"co",u"Encino",412,6.137349,-73.098474 ],
    [ u"co",u"Enciso",698,6.668082,-72.699861 ],
    [ u"co",u"Entrerríos",3462,6.565397,-75.516905 ],
    [ u"co",u"Envigado",163010,6.170643,-75.585307 ],
    [ u"co",u"Espinal",56214,4.149245,-74.884292 ],
    [ u"co",u"Facatativá",94613,4.813668,-74.354529 ],
    [ u"co",u"Falan",5234,5.115636,-74.94894 ],
    [ u"co",u"Filadelfia",5064,5.29606,-75.561197 ],
    [ u"co",u"Filandia",6851,4.674722,-75.658333 ],
    [ u"co",u"Firavitoba",2136,5.668847,-72.99289 ],
    [ u"co",u"Flandes",20919,4.294127,-74.819011 ],
    [ u"co",u"Florencia",130339,1.614382,-75.606229 ],
    [ u"co",u"Florencia",1467,1.68318,-77.073305 ],
    [ u"co",u"Floresta",1127,5.859027,-72.918818 ],
    [ u"co",u"Florián",1227,5.804874,-73.970287 ],
    [ u"co",u"Floridablanca",252271,7.062222,-73.08644 ],
    [ u"co",u"Florida",47173,3.322297,-76.234804 ],
    [ u"co",u"Fómeque",5390,4.487967,-73.897488 ],
    [ u"co",u"Fonseca",23510,10.886063,-72.848696 ],
    [ u"co",u"Fosca",1451,4.339159,-73.938522 ],
    [ u"co",u"Fredonia",8951,5.925833,-75.670556 ],
    [ u"co",u"Fresno",17669,5.152643,-75.036235 ],
    [ u"co",u"Frontino",8603,6.780054,-76.128801 ],
    [ u"co",u"Fuente de Oro",3610,3.459444,-73.612778 ],
    [ u"co",u"Fundación",59177,10.520664,-74.185037 ],
    [ u"co",u"Funes",2508,1.002657,-77.450668 ],
    [ u"co",u"Funza",54422,4.716381,-74.211954 ],
    [ u"co",u"Fúquene",563,5.404253,-73.7964 ],
    [ u"co",u"Fusagasuga",88822,4.336463,-74.363779 ],
    [ u"co",u"Gachalá",1661,4.692441,-73.520421 ],
    [ u"co",u"Gachancipá",3119,4.991109,-73.871538 ],
    [ u"co",u"Gachantiva",534,5.756615,-73.539495 ],
    [ u"co",u"Gachetá",4088,4.818539,-73.636586 ],
    [ u"co",u"Galán",1122,6.637808,-73.288778 ],
    [ u"co",u"Galapa",19733,10.896863,-74.885996 ],
    [ u"co",u"Galeras",9460,9.160948,-75.048108 ],
    [ u"co",u"Gama",584,4.762881,-73.610905 ],
    [ u"co",u"Gamarra",7327,8.322793,-73.742684 ],
    [ u"co",u"Gámbita",742,5.945969,-73.344348 ],
    [ u"co",u"Gámeza",1690,5.80263,-72.805865 ],
    [ u"co",u"Garagoa",11102,5.082356,-73.363342 ],
    [ u"co",u"Garzón",29452,2.19593,-75.627773 ],
    [ u"co",u"Génova",7140,4.316667,-75.766667 ],
    [ u"co",u"Gigante",9829,2.386767,-75.545312 ],
    [ u"co",u"Ginebra",6088,3.724614,-76.266749 ],
    [ u"co",u"Giraldo",1464,6.683056,-75.989167 ],
    [ u"co",u"Girardot",130292,4.298659,-74.804681 ],
    [ u"co",u"Girón",108468,7.068205,-73.169809 ],
    [ u"co",u"Gómez Plata",4097,6.681779,-75.219065 ],
    [ u"co",u"González",5634,8.389442,-73.379893 ],
    [ u"co",u"Gramalote",3577,7.887518,-72.797487 ],
    [ u"co",u"Granada",5661,6.143526,-75.185323 ],
    [ u"co",u"Granada",32366,3.538611,-73.700556 ],
    [ u"co",u"Granada",1100,5.056885,-74.556405 ],
    [ u"co",u"Guaca",1637,6.876209,-72.85594 ],
    [ u"co",u"Guacamayas",772,6.459169,-72.50104 ],
    [ u"co",u"Guacarí",19637,3.763828,-76.332916 ],
    [ u"co",u"Guachetá",4246,5.38425,-73.686172 ],
    [ u"co",u"Guachucal",4014,.960931,-77.731605 ],
    [ u"co",u"Guadalupe",1734,6.81449,-75.240634 ],
    [ u"co",u"Guadalupe",4761,2.024796,-75.755894 ],
    [ u"co",u"Guadalupe",2181,6.246397,-73.418333 ],
    [ u"co",u"Guaduas",14392,5.06692,-74.594986 ],
    [ u"co",u"Guaitarilla",6280,1.138554,-77.553006 ],
    [ u"co",u"Gualmatán",2510,.918884,-77.566507 ],
    [ u"co",u"Guamal",5026,3.880427,-73.765659 ],
    [ u"co",u"Guamal",9016,9.143338,-74.223844 ],
    [ u"co",u"Guamo",14881,4.030782,-74.970097 ],
    [ u"co",u"Guapi",13854,2.570823,-77.885421 ],
    [ u"co",u"Guapotá",564,6.307976,-73.320197 ],
    [ u"co",u"Guarne",14270,6.280456,-75.443537 ],
    [ u"co",u"Guasca",3540,4.86601,-73.877475 ],
    [ u"co",u"Guatapé",5389,6.232741,-75.158638 ],
    [ u"co",u"Guataquí",1139,4.515728,-74.789351 ],
    [ u"co",u"Guatavita",1920,4.936581,-73.833141 ],
    [ u"co",u"Guateque",7069,5.006189,-73.472736 ],
    [ u"co",u"Guática",4369,5.315691,-75.79826 ],
    [ u"co",u"Guavatá",943,5.95502,-73.700182 ],
    [ u"co",u"Guayabal de Síquima",1051,4.877388,-74.467444 ],
    [ u"co",u"Guayabal",5340,5.031034,-74.886825 ],
    [ u"co",u"Guayabetal",2017,4.214724,-73.817192 ],
    [ u"co",u"Guayatá",2857,4.964167,-73.4875 ],
    [ u"co",u"Güepsa",2471,6.02505,-73.573126 ],
    [ u"co",u"Güicán",2101,6.461843,-72.41129 ],
    [ u"co",u"Gutiérrez",772,4.254722,-74.0025 ],
    [ u"co",u"Hacarí",1502,8.323333,-73.148889 ],
    [ u"co",u"Hatillo de Loba",3639,8.95635,-74.078195 ],
    [ u"co",u"Hato",600,6.543016,-73.308264 ],
    [ u"co",u"Heliconia",2403,6.206891,-75.733671 ],
    [ u"co",u"Herrán",1648,7.506108,-72.483321 ],
    [ u"co",u"Herveo",3490,5.080042,-75.175558 ],
    [ u"co",u"Hispania",2468,5.799253,-75.907184 ],
    [ u"co",u"Hobo",4445,2.583333,-75.45 ],
    [ u"co",u"Honda",28158,5.20856,-74.735842 ],
    [ u"co",u"Ibagué",421689,4.438889,-75.232222 ],
    [ u"co",u"Icononzo",3540,4.176977,-74.532538 ],
    [ u"co",u"Iles",1879,.974909,-77.527408 ],
    [ u"co",u"Imués",1736,1.060715,-77.500442 ],
    [ u"co",u"Inírida",7299,3.865278,-67.923889 ],
    [ u"co",u"Inzá",2972,2.551295,-76.065455 ],
    [ u"co",u"Ipiales",77730,.830178,-77.649594 ],
    [ u"co",u"Íquira",3942,2.648673,-75.634573 ],
    [ u"co",u"Isnos",5185,1.928741,-76.211036 ],
    [ u"co",u"Istmina",13788,5.160538,-76.683971 ],
    [ u"co",u"Itagüí",281858,6.171944,-75.611389 ],
    [ u"co",u"Ituango",10770,7.171172,-75.764041 ],
    [ u"co",u"Iza",748,5.612029,-72.9793 ],
    [ u"co",u"Jambalo",1972,2.788333,-76.3225 ],
    [ u"co",u"Jamundí",44834,3.26074,-76.534989 ],
    [ u"co",u"Jardín",7747,5.599018,-75.819758 ],
    [ u"co",u"Jenesano",1200,5.385406,-73.363644 ],
    [ u"co",u"Jericó",7750,5.792106,-75.786012 ],
    [ u"co",u"Jericó",865,6.145921,-72.570804 ],
    [ u"co",u"Jerusalén",697,4.563094,-74.69519 ],
    [ u"co",u"Jesús María",823,5.877153,-73.780968 ],
    [ u"co",u"Jordán",112,6.732996,-73.095885 ],
    [ u"co",u"Juan de Acosta",8655,10.828133,-75.03341 ],
    [ u"co",u"Junín",1499,4.79027,-73.66011 ],
    [ u"co",u"Juradó",2351,7.10534,-77.76413 ],
    [ u"co",u"La Argentina",3082,2.196111,-75.98 ],
    [ u"co",u"Labateca",1639,7.298474,-72.494432 ],
    [ u"co",u"La Belleza",1649,5.790833,-73.848889 ],
    [ u"co",u"Labranzagrande",902,5.56223,-72.574991 ],
    [ u"co",u"La Calera",10175,4.383333,-73.983333 ],
    [ u"co",u"La Capilla",1375,5.704931,-73.475272 ],
    [ u"co",u"La Ceja",36585,6.030823,-75.431501 ],
    [ u"co",u"La Celia",4940,5.043333,-76.016667 ],
    [ u"co",u"La Cruz",8752,1.603013,-76.969008 ],
    [ u"co",u"La Cumbre",2432,3.7225,-76.020833 ],
    [ u"co",u"La Dorada",81951,5.44783,-74.663111 ],
    [ u"co",u"La Esperanza",2718,8.210434,-72.46399 ],
    [ u"co",u"La Estrella",49387,6.15769,-75.643173 ],
    [ u"co",u"La Florida",2882,1.298512,-77.406139 ],
    [ u"co",u"La Gloria",6810,8.618676,-73.802654 ],
    [ u"co",u"La Jagua del Pilar",894,10.516667,-73.083333 ],
    [ u"co",u"La Llanada",2747,1.489973,-77.583474 ],
    [ u"co",u"La Macarena",3466,2.183674,-73.784847 ],
    [ u"co",u"La Merced",3851,5.401944,-75.884722 ],
    [ u"co",u"La Merced",3851,5.086667,-75.8925 ],
    [ u"co",u"La Montañita",3305,1.476602,-75.439796 ],
    [ u"co",u"Landázuri",3483,6.218262,-73.811208 ],
    [ u"co",u"La Palma",8093,5.359201,-74.390467 ],
    [ u"co",u"La Paz",1135,6.178477,-73.589485 ],
    [ u"co",u"La Peña",1667,5.198474,-74.393677 ],
    [ u"co",u"La Pintada",5342,5.748673,-75.606261 ],
    [ u"co",u"La Plata",19276,2.393406,-75.892319 ],
    [ u"co",u"La Playa",1215,8.216389,-73.241389 ],
    [ u"co",u"La Primavera",3920,5.490556,-70.409167 ],
    [ u"co",u"La Salina",360,6.1,-72.35 ],
    [ u"co",u"La Sierra",2129,2.178346,-76.762648 ],
    [ u"co",u"La Tebaida",27099,4.452649,-75.787463 ],
    [ u"co",u"La Unión",8361,5.974309,-75.361954 ],
    [ u"co",u"La Unión",15061,1.604496,-77.131523 ],
    [ u"co",u"La Unión",4427,8.860556,-75.280556 ],
    [ u"co",u"La Unión",23459,4.532819,-76.103177 ],
    [ u"co",u"La Uribe",2103,3.240549,-74.354159 ],
    [ u"co",u"La Uvita",1708,6.316839,-72.560321 ],
    [ u"co",u"La Vega",3469,2.006277,-76.780276 ],
    [ u"co",u"La Vega",5706,4.968915,-74.609452 ],
    [ u"co",u"La Victoria",11064,4.522711,-76.03738 ],
    [ u"co",u"La Victoria",314,5.522778,-74.232778 ],
    [ u"co",u"La Virginia",33836,4.899722,-75.8825 ],
    [ u"co",u"Lebrija",8950,7.113168,-73.2178 ],
    [ u"co",u"Leiva",3668,1.933891,-77.302531 ],
    [ u"co",u"Leiva",5103,5.645,-73.566667 ],
    [ u"co",u"Lejanías",5157,3.525104,-74.021561 ],
    [ u"co",u"Lenguazaque",2555,5.307108,-73.711525 ],
    [ u"co",u"Lérida",20069,4.862417,-74.909768 ],
    [ u"co",u"Leticia",29666,-4.215278,-69.940556 ],
    [ u"co",u"Líbano",28212,4.921795,-75.062317 ],
    [ u"co",u"Liborina",2373,6.677901,-75.812185 ],
    [ u"co",u"Linares",3512,1.35783,-77.527246 ],
    [ u"co",u"Litoral del San Juan",1448,4.258748,-77.365164 ],
    [ u"co",u"Lloró",2651,5.496047,-76.549448 ],
    [ u"co",u"López",3700,2.1177,-76.775248 ],
    [ u"co",u"Lorica",40606,9.236484,-75.813499 ],
    [ u"co",u"Los Andes",4839,1.514686,-77.504435 ],
    [ u"co",u"Los Córdobas",2007,8.894026,-76.354551 ],
    [ u"co",u"Los Palmitos",14385,9.378988,-75.267692 ],
    [ u"co",u"Los Patios",58663,7.837931,-72.503696 ],
    [ u"co",u"Los Santos",1310,7.17,-73.093056 ],
    [ u"co",u"Lourdes",1500,7.944111,-72.83253 ],
    [ u"co",u"Luruaco",13237,10.609214,-75.143091 ],
    [ u"co",u"Macanal",734,4.972141,-73.319588 ],
    [ u"co",u"Macaravita",538,6.505669,-72.592988 ],
    [ u"co",u"Maceo",3109,6.551958,-74.787415 ],
    [ u"co",u"Machetá",1742,5.081541,-73.607613 ],
    [ u"co",u"Madrid",50438,4.732445,-74.264192 ],
    [ u"co",u"Magangué",100315,9.242024,-74.754671 ],
    [ u"co",u"Magüí",2892,1.935,-78.205 ],
    [ u"co",u"Mahates",9224,10.232927,-75.189849 ],
    [ u"co",u"Maicao",130351,11.383208,-72.243208 ],
    [ u"co",u"Majagual",11139,8.538865,-74.62038 ],
    [ u"co",u"Málaga",18740,6.699027,-72.732327 ],
    [ u"co",u"Malambo",101536,10.859533,-74.773861 ],
    [ u"co",u"Mallama",1788,1.137396,-77.848901 ],
    [ u"co",u"Manatí",14141,10.445893,-74.958694 ],
    [ u"co",u"Manaure",9703,11.775047,-72.444472 ],
    [ u"co",u"Maní",7031,4.817222,-72.288611 ],
    [ u"co",u"Manizales",357819,5.06889,-75.517383 ],
    [ u"co",u"Manta",1410,5.008643,-73.54115 ],
    [ u"co",u"Manzanares",16278,5.324722,-75.156944 ],
    [ u"co",u"Mapiripán",1993,2.889155,-72.125591 ],
    [ u"co",u"Margarita",1939,9.155957,-74.266183 ],
    [ u"co",u"María la Baja",23401,9.983205,-75.30155 ],
    [ u"co",u"Marinilla",24172,6.173579,-75.336208 ],
    [ u"co",u"Maripí",1143,5.551944,-74.008611 ],
    [ u"co",u"Mariquita",23104,5.198894,-74.89295 ],
    [ u"co",u"Marmato",1456,5.478427,-75.592667 ],
    [ u"co",u"Marquetalia",6224,5.296591,-75.054962 ],
    [ u"co",u"Marsella",11158,4.937222,-75.737778 ],
    [ u"co",u"Marulanda",1256,5.28393,-75.26016 ],
    [ u"co",u"Matanza",1669,7.322333,-73.015161 ],
    [ u"co",u"Medellín",2000001,6.25184,-75.563591 ],
    [ u"co",u"Medina",3098,4.510053,-73.349816 ],
    [ u"co",u"Melgar",25980,4.204748,-74.640746 ],
    [ u"co",u"Mercaderes",4684,1.800937,-77.165963 ],
    [ u"co",u"Mesetas",4163,3.384635,-74.044242 ],
    [ u"co",u"Milán",2618,1.292047,-75.511666 ],
    [ u"co",u"Miraflores",4864,1.336667,-71.951111 ],
    [ u"co",u"Miraflores",2766,5.196077,-73.14504 ],
    [ u"co",u"Miranda",13223,3.249907,-76.228145 ],
    [ u"co",u"Mistrató",6263,5.297302,-75.883217 ],
    [ u"co",u"Mitú",5917,1.198333,-70.173333 ],
    [ u"co",u"Mocoa",22035,1.149327,-76.64661 ],
    [ u"co",u"Mogotes",3438,6.475588,-72.970459 ],
    [ u"co",u"Molagavita",1205,6.673153,-72.808749 ],
    [ u"co",u"Momil",6441,9.237675,-75.674889 ],
    [ u"co",u"Mompos",30862,9.237864,-74.425329 ],
    [ u"co",u"Mongua",2322,5.750835,-72.803387 ],
    [ u"co",u"Monguí",2299,5.721507,-72.84908 ],
    [ u"co",u"Moniquirá",9785,5.876376,-73.572843 ],
    [ u"co",u"Moñitos",5385,8.25,-76.05 ],
    [ u"co",u"Montebello",2007,5.9449,-75.524279 ],
    [ u"co",u"Montecristo",5608,8.297102,-74.473298 ],
    [ u"co",u"Montelíbano",34162,9.58265,-74.103108 ],
    [ u"co",u"Montenegro",36500,4.566389,-75.751111 ],
    [ u"co",u"Montería",272424,8.747984,-75.881428 ],
    [ u"co",u"Monterrey",7759,4.872057,-72.898791 ],
    [ u"co",u"Morales",4074,2.757011,-76.617231 ],
    [ u"co",u"Morales",4773,8.270276,-73.868267 ],
    [ u"co",u"Morelia",2257,1.487474,-75.725807 ],
    [ u"co",u"Morroa",4949,9.333479,-75.305423 ],
    [ u"co",u"Mosquera",3471,2.50861,-78.451102 ],
    [ u"co",u"Mosquera",27006,4.705921,-74.230208 ],
    [ u"co",u"Motavita",392,5.576547,-73.366963 ],
    [ u"co",u"Murillo",1860,4.87393,-75.17151 ],
    [ u"co",u"Murindó",2372,6.984806,-76.754394 ],
    [ u"co",u"Mutatá",4811,7.244074,-76.435645 ],
    [ u"co",u"Mutiscua",918,7.300606,-72.746675 ],
    [ u"co",u"Mutis",3079,6.22622,-77.404393 ],
    [ u"co",u"Muzo",7977,5.535278,-74.107778 ],
    [ u"co",u"Nariño",3186,5.60893,-75.176561 ],
    [ u"co",u"Nariño",2933,1.295456,-77.360496 ],
    [ u"co",u"Nariño",1213,4.397808,-74.827313 ],
    [ u"co",u"Natagaima",11217,3.620569,-75.094148 ],
    [ u"co",u"Nátaga",2232,2.543593,-75.80852 ],
    [ u"co",u"Nechí",6694,8.094189,-74.775733 ],
    [ u"co",u"Necoclí",10835,8.423417,-76.785967 ],
    [ u"co",u"Neira",11755,5.166498,-75.520008 ],
    [ u"co",u"Neiva",352859,2.927299,-75.281885 ],
    [ u"co",u"Nemocón",5467,5.05,-73.883333 ],
    [ u"co",u"Nilo",1117,4.306041,-74.620833 ],
    [ u"co",u"Nimaima",604,5.126143,-74.384945 ],
    [ u"co",u"Nobsa",3360,5.769779,-72.940991 ],
    [ u"co",u"Nocaima",2475,5.069831,-74.377999 ],
    [ u"co",u"Norcasia",5976,5.577815,-74.885206 ],
    [ u"co",u"Nóvita",1898,4.955112,-76.605258 ],
    [ u"co",u"Nueva Granada",2714,9.801677,-74.393036 ],
    [ u"co",u"Nuevo Colón",863,5.353681,-73.456605 ],
    [ u"co",u"Nunchía",1282,5.640556,-72.198611 ],
    [ u"co",u"Nuquí",2741,5.7125,-77.270833 ],
    [ u"co",u"Obando",7298,4.575833,-75.973889 ],
    [ u"co",u"Ocamonte",883,6.340007,-73.122053 ],
    [ u"co",u"Ocaña",83513,8.237727,-73.356038 ],
    [ u"co",u"Oiba",3959,6.263875,-73.298764 ],
    [ u"co",u"Oicatá",327,5.595478,-73.3082 ],
    [ u"co",u"Olaya Herrera",9821,1.256086,-77.496649 ],
    [ u"co",u"Olaya",710,6.629881,-75.802985 ],
    [ u"co",u"Onzaga",1393,6.344336,-72.817258 ],
    [ u"co",u"Oporapa",2310,2.050146,-75.976749 ],
    [ u"co",u"Orito",13708,.676558,-76.877116 ],
    [ u"co",u"Orocué",2835,4.791175,-71.335423 ],
    [ u"co",u"Ortega",6871,3.936105,-75.221692 ],
    [ u"co",u"Ospina",2747,1.059503,-77.565539 ],
    [ u"co",u"Ospina Pérez",1307,4.088081,-74.477463 ],
    [ u"co",u"Otanche",3589,5.656721,-74.182491 ],
    [ u"co",u"Ovejas",13284,9.532482,-75.22382 ],
    [ u"co",u"Pachavita",959,5.139686,-73.397393 ],
    [ u"co",u"Pacho",16698,5.132778,-74.159771 ],
    [ u"co",u"Pácora",8218,5.527084,-75.459301 ],
    [ u"co",u"Padilla",4472,3.220376,-76.313851 ],
    [ u"co",u"Páez",5179,2.654722,-75.992778 ],
    [ u"co",u"Páez",1220,5.101123,-73.051225 ],
    [ u"co",u"Paicol",1681,2.449623,-75.775003 ],
    [ u"co",u"Pailitas",10481,8.956518,-73.625485 ],
    [ u"co",u"Paime",799,5.363596,-74.145788 ],
    [ u"co",u"Paipa",13554,5.78013,-73.117082 ],
    [ u"co",u"Pajarito",1258,5.292903,-72.70277 ],
    [ u"co",u"Palermo",9896,2.891667,-75.4375 ],
    [ u"co",u"Palestina",2028,1.723624,-76.134028 ],
    [ u"co",u"Palestina",7865,5.019405,-75.622424 ],
    [ u"co",u"Palmar de Varela",28085,10.740548,-74.754429 ],
    [ u"co",u"Palmar",360,6.537727,-73.292339 ],
    [ u"co",u"Palmas del Socorro",657,6.406667,-73.286944 ],
    [ u"co",u"Palmira",247991,3.539444,-76.303611 ],
    [ u"co",u"Palmito",3993,9.331894,-75.541704 ],
    [ u"co",u"Palocabildo",3534,5.11705,-75.017323 ],
    [ u"co",u"Pamplona",53588,7.375647,-72.647949 ],
    [ u"co",u"Pamplonita",941,7.436366,-72.638082 ],
    [ u"co",u"Pandi",1336,4.191111,-74.4875 ],
    [ u"co",u"Panqueba",668,6.442553,-72.458821 ],
    [ u"co",u"Páramo",843,6.416389,-73.17 ],
    [ u"co",u"Paratebueno",2027,4.375754,-73.215472 ],
    [ u"co",u"Pasca",3169,4.307222,-74.300556 ],
    [ u"co",u"Pasto",382242,1.213611,-77.281111 ],
    [ u"co",u"Pauna",2663,5.658611,-73.9825 ],
    [ u"co",u"Paya",336,5.624923,-72.423454 ],
    [ u"co",u"Paz de Ariporo",16666,5.880556,-71.891944 ],
    [ u"co",u"Pedraza",3677,10.187386,-74.915036 ],
    [ u"co",u"Pelaya",11306,8.688187,-73.664515 ],
    [ u"co",u"Peñol",7698,6.218293,-75.24298 ],
    [ u"co",u"Pensilvania",8173,5.383456,-75.161219 ],
    [ u"co",u"Peque",1793,7.021225,-75.909262 ],
    [ u"co",u"Pereira",440123,4.813333,-75.696111 ],
    [ u"co",u"Pesca",5113,5.55,-73.05 ],
    [ u"co",u"Piedecuesta",86388,6.987892,-73.049533 ],
    [ u"co",u"Piedras",1173,4.538328,-74.881747 ],
    [ u"co",u"Pijao",5668,4.334189,-75.703479 ],
    [ u"co",u"Pijiño",5390,9.329079,-74.45302 ],
    [ u"co",u"Pinchote",674,6.532258,-73.173088 ],
    [ u"co",u"Pinillos",6218,8.919248,-74.467711 ],
    [ u"co",u"Piojó",3388,10.748462,-75.107756 ],
    [ u"co",u"Pisba",307,5.723962,-72.486462 ],
    [ u"co",u"Pitalito",53686,1.849656,-76.047849 ],
    [ u"co",u"Pital",3957,2.266503,-75.804422 ],
    [ u"co",u"Pivijay",33493,10.461675,-74.616208 ],
    [ u"co",u"Pizarro",6105,2.101944,-78.721667 ],
    [ u"co",u"Planadas",9710,3.196977,-75.645061 ],
    [ u"co",u"Planeta Rica",37298,8.414722,-75.588333 ],
    [ u"co",u"Plato",48607,9.790289,-74.782442 ],
    [ u"co",u"Policarpa",2377,1.632313,-77.461988 ],
    [ u"co",u"Ponedera",11222,10.641035,-74.750257 ],
    [ u"co",u"Pore",4134,5.727222,-71.994722 ],
    [ u"co",u"Potosí",3980,.807392,-77.572165 ],
    [ u"co",u"Pradera",44631,3.421111,-76.244722 ],
    [ u"co",u"Prado",3556,3.750243,-74.929325 ],
    [ u"co",u"Providencia",3326,1.555713,-77.550121 ],
    [ u"co",u"Pueblo Bello",6295,10.417065,-73.580404 ],
    [ u"co",u"Pueblo Nuevo",9076,8.241098,-74.958147 ],
    [ u"co",u"Pueblo Rico",4165,5.238333,-76.036389 ],
    [ u"co",u"Pueblorrico",5327,5.791756,-75.841012 ],
    [ u"co",u"Puebloviejo",13524,10.993761,-74.284385 ],
    [ u"co",u"Puente Nacional",5775,5.877395,-73.6781 ],
    [ u"co",u"Puerres",3812,1.193738,-77.266613 ],
    [ u"co",u"Puerto Asís",29783,.513278,-76.500748 ],
    [ u"co",u"Puerto Berrío",33983,6.491565,-74.403264 ],
    [ u"co",u"Puerto Boyacá",27311,5.975838,-74.588455 ],
    [ u"co",u"Puerto Carreño",10216,6.189031,-67.485879 ],
    [ u"co",u"Puerto Colombia",26228,10.987778,-74.954722 ],
    [ u"co",u"Puerto Concordia",4313,2.622059,-72.757242 ],
    [ u"co",u"Puerto Escondido",3020,9.018105,-76.26413 ],
    [ u"co",u"Puerto Gaitán",5928,4.313279,-72.08157 ],
    [ u"co",u"Puerto Guzmán",4094,.964538,-76.407953 ],
    [ u"co",u"Puerto Leguízamo",9098,-.193368,-74.781886 ],
    [ u"co",u"Puerto Lleras",5076,3.022247,-73.404402 ],
    [ u"co",u"Puerto López",16678,4.084514,-72.955974 ],
    [ u"co",u"Puerto Nariño",2113,-3.770278,-70.383056 ],
    [ u"co",u"Puerto Parra",1448,6.651493,-74.057343 ],
    [ u"co",u"Puerto Rico",12306,1.905743,-75.154059 ],
    [ u"co",u"Puerto Rico",5029,2.938333,-73.208333 ],
    [ u"co",u"Puerto Rondón",3724,6.280477,-71.1 ],
    [ u"co",u"Puerto Salgar",9864,5.463041,-74.654363 ],
    [ u"co",u"Puerto Santander",16275,8.363611,-72.406295 ],
    [ u"co",u"Puerto Tejada",53675,3.231136,-76.416684 ],
    [ u"co",u"Puerto Triunfo",4056,5.872619,-74.640286 ],
    [ u"co",u"Puerto Wilches",13705,7.348285,-73.896011 ],
    [ u"co",u"Pulí",596,4.681159,-74.714056 ],
    [ u"co",u"Pupiales",6760,.87136,-77.640269 ],
    [ u"co",u"Puracé",4837,2.342491,-76.495809 ],
    [ u"co",u"Purificación",10847,3.858705,-74.931288 ],
    [ u"co",u"Purísima",7043,9.23657,-75.721905 ],
    [ u"co",u"Quebradanegra",753,5.117369,-74.479443 ],
    [ u"co",u"Quetame",1374,4.332342,-73.861415 ],
    [ u"co",u"Quibdó",75105,5.694722,-76.661111 ],
    [ u"co",u"Quimbaya",31392,4.623056,-75.762778 ],
    [ u"co",u"Quinchía",10896,5.339573,-75.730184 ],
    [ u"co",u"Quípama",3571,5.519404,-74.177653 ],
    [ u"co",u"Quipile",1896,4.748056,-74.563056 ],
    [ u"co",u"Rafael Reyes",4084,4.519521,-74.59293 ],
    [ u"co",u"Ragonvalia",3543,7.577487,-72.475738 ],
    [ u"co",u"Ramiriquí",5039,5.400205,-73.335437 ],
    [ u"co",u"Ráquira",2120,5.537932,-73.632006 ],
    [ u"co",u"Recetor",205,5.231836,-72.760369 ],
    [ u"co",u"Regidor",3386,8.665653,-73.821506 ],
    [ u"co",u"Remedios",6415,7.030833,-74.533333 ],
    [ u"co",u"Remolino",8308,10.701985,-74.716019 ],
    [ u"co",u"Repelón",18686,10.491944,-75.129167 ],
    [ u"co",u"Restrepo",7511,4.258334,-73.561423 ],
    [ u"co",u"Restrepo",9545,3.822034,-76.522423 ],
    [ u"co",u"Retiro",7941,6.058611,-75.503056 ],
    [ u"co",u"Ricaurte",2682,4.280754,-74.764687 ],
    [ u"co",u"Rioblanco",6210,3.530833,-75.680556 ],
    [ u"co",u"Río de Oro",6122,8.291901,-73.384853 ],
    [ u"co",u"Riofrío",9236,4.157104,-76.288518 ],
    [ u"co",u"Ríohacha",92433,11.544444,-72.907222 ],
    [ u"co",u"Rionegro",62292,6.155149,-75.373708 ],
    [ u"co",u"Rionegro",9515,7.153611,-73.153611 ],
    [ u"co",u"Riosucio",7163,7.44027,-77.1167 ],
    [ u"co",u"Riosucio",18950,5.42164,-75.703177 ],
    [ u"co",u"Río Viejo",6963,8.587399,-73.839013 ],
    [ u"co",u"Risaralda",5421,5.16647,-75.765954 ],
    [ u"co",u"Rivera",8044,2.77717,-75.256415 ],
    [ u"co",u"Roberto Payán",1772,1.696594,-78.244817 ],
    [ u"co",u"Roldanillo",27562,4.412557,-76.154567 ],
    [ u"co",u"Roncesvalles",3918,4.010796,-75.60493 ],
    [ u"co",u"Rondón",504,5.356415,-73.209178 ],
    [ u"co",u"Rosas",1830,2.260928,-76.739863 ],
    [ u"co",u"Rovira",6950,4.239221,-75.239963 ],
    [ u"co",u"Sabana de Torres",11292,7.391498,-73.495739 ],
    [ u"co",u"Sabanagrande",21167,10.789605,-74.755254 ],
    [ u"co",u"Sabanagrande",21167,10.719722,-74.682778 ],
    [ u"co",u"Sabanalarga",2517,6.848931,-75.817106 ],
    [ u"co",u"Sabanalarga",68536,10.629617,-74.92063 ],
    [ u"co",u"Sabanalarga",1419,4.854299,-73.040032 ],
    [ u"co",u"Sabaneta",34173,6.15,-75.6 ],
    [ u"co",u"Saboyá",1375,5.696357,-73.769316 ],
    [ u"co",u"Sácama",744,6.098915,-72.248082 ],
    [ u"co",u"Sáchica",1774,5.584528,-73.54184 ],
    [ u"co",u"Sahagún",59189,8.946165,-75.442749 ],
    [ u"co",u"Saladoblanco",1662,1.992439,-76.043353 ],
    [ u"co",u"Salamina",18076,5.407328,-75.487487 ],
    [ u"co",u"Salamina",6166,10.490274,-74.79463 ],
    [ u"co",u"Saldaña",9237,3.929225,-75.015174 ],
    [ u"co",u"Salento",4136,4.6375,-75.570278 ],
    [ u"co",u"Salgar",6429,5.965025,-75.965407 ],
    [ u"co",u"Samacá",3689,5.492735,-73.485368 ],
    [ u"co",u"Samana",7781,5.412581,-74.992189 ],
    [ u"co",u"Samaniego",13515,1.338495,-77.595695 ],
    [ u"co",u"Sampués",21204,9.183611,-75.381667 ],
    [ u"co",u"San Agustín",9481,1.878629,-76.275566 ],
    [ u"co",u"San Alberto",10628,7.761066,-73.392201 ],
    [ u"co",u"San Andrés",3154,6.903333,-75.6825 ],
    [ u"co",u"San Andrés",58258,12.584722,-81.700556 ],
    [ u"co",u"San Andrés",3032,6.811478,-72.849292 ],
    [ u"co",u"San Antero",11610,9.374101,-75.758909 ],
    [ u"co",u"San Antonio del Tequendama",1577,4.618889,-74.353889 ],
    [ u"co",u"San Antonio",5185,3.653056,-75.632778 ],
    [ u"co",u"San Benito Abad",18181,8.929007,-75.02709 ],
    [ u"co",u"San Benito",426,6.132694,-73.490651 ],
    [ u"co",u"San Bernardo",2988,1.521189,-77.03091 ],
    [ u"co",u"San Bernardo",7625,4.178642,-74.423112 ],
    [ u"co",u"San Calixto",2080,8.402096,-73.207374 ],
    [ u"co",u"San Carlos",7742,6.18789,-74.993149 ],
    [ u"co",u"San Carlos",3447,8.74372,-75.713306 ],
    [ u"co",u"San Cayetano",1430,7.877066,-72.624298 ],
    [ u"co",u"San Cayetano",699,5.301532,-74.069542 ],
    [ u"co",u"San Cristóbal",4738,9.878093,-75.252482 ],
    [ u"co",u"San Diego",8014,10.334271,-73.180045 ],
    [ u"co",u"Sandoná",10402,1.291512,-77.474094 ],
    [ u"co",u"San Eduardo",524,5.226752,-73.126076 ],
    [ u"co",u"San Estanislao",12596,10.398333,-75.151111 ],
    [ u"co",u"San Fernando",1615,9.268325,-74.530213 ],
    [ u"co",u"San Francisco",2779,6.116667,-75.983333 ],
    [ u"co",u"San Francisco",4350,1.178666,-76.878501 ],
    [ u"co",u"San Francisco",2785,4.973721,-74.290055 ],
    [ u"co",u"San Gil",33592,6.555734,-73.133088 ],
    [ u"co",u"San Jacinto",20265,9.827668,-75.121701 ],
    [ u"co",u"San Jerónimo",3356,6.443442,-75.728147 ],
    [ u"co",u"San Joaquín",844,6.430037,-72.86768 ],
    [ u"co",u"San José del Guaviare",22136,2.572858,-72.645914 ],
    [ u"co",u"San José del Palmar",2392,4.974167,-76.228333 ],
    [ u"co",u"San José de Miranda",1096,6.658701,-72.73344 ],
    [ u"co",u"San José de Pare",941,6.017465,-73.547035 ],
    [ u"co",u"San José",1724,5.001667,-75.752222 ],
    [ u"co",u"San Juan de Arama",2636,3.346389,-73.889444 ],
    [ u"co",u"San Juan de Betulia",9092,9.27345,-75.241032 ],
    [ u"co",u"San Juan del Cesar",26849,10.771075,-73.00314 ],
    [ u"co",u"San Juan de Urabá",10825,8.759241,-76.529689 ],
    [ u"co",u"San Juanito",396,4.509815,-72.968486 ],
    [ u"co",u"San Juan Nepomuceno",29619,9.951565,-75.081979 ],
    [ u"co",u"San Lorenzo",2394,1.506278,-77.218979 ],
    [ u"co",u"San Luis de Gaceno",2579,4.820522,-73.168507 ],
    [ u"co",u"San Luis de Palenque",2032,5.421389,-71.731667 ],
    [ u"co",u"San Luis",6448,6.041667,-74.992778 ],
    [ u"co",u"San Luis",4184,4.132578,-75.094994 ],
    [ u"co",u"San Marcos",36549,8.659723,-75.12809 ],
    [ u"co",u"San Martín",7029,8.00151,-73.511263 ],
    [ u"co",u"San Martín",16274,3.696373,-73.699575 ],
    [ u"co",u"San Mateo",1634,6.401106,-72.555629 ],
    [ u"co",u"San Miguel de Sema",647,5.518472,-73.722383 ],
    [ u"co",u"San Miguel",7186,.343144,-76.911243 ],
    [ u"co",u"San Miguel",624,6.575828,-72.645909 ],
    [ u"co",u"San Onofre",32958,9.735863,-75.526261 ],
    [ u"co",u"San Pablo de Borbur",1519,5.660339,-74.062116 ],
    [ u"co",u"San Pablo",6522,1.67145,-77.014082 ],
    [ u"co",u"San Pablo",13984,10.051537,-75.267746 ],
    [ u"co",u"San Pedro de Cartago",1524,1.563054,-77.117602 ],
    [ u"co",u"San Pedro de Urabá",11095,8.275147,-76.376407 ],
    [ u"co",u"San Pedro",8801,6.462213,-75.556556 ],
    [ u"co",u"San Pedro",11489,9.395603,-75.064758 ],
    [ u"co",u"San Pedro",5473,3.992185,-76.239261 ],
    [ u"co",u"San Pelayo",5637,8.958328,-75.836272 ],
    [ u"co",u"San Rafael",7245,6.294359,-75.025892 ],
    [ u"co",u"San Roque",5576,6.485112,-75.019605 ],
    [ u"co",u"San Sebastián",931,1.838611,-76.771889 ],
    [ u"co",u"San Sebastian",6520,9.242169,-74.500369 ],
    [ u"co",u"San Sebastián",6520,9.237779,-74.351658 ],
    [ u"co",u"Santa Ana",13951,9.321247,-74.568478 ],
    [ u"co",u"Santa Bárbara",12743,5.874583,-75.567056 ],
    [ u"co",u"Santá Barbara",4875,2.450069,-77.979357 ],
    [ u"co",u"Santa Barbará",291,6.990221,-72.907004 ],
    [ u"co",u"Santa Catalina",6084,10.603607,-75.288235 ],
    [ u"co",u"Santacruz",2469,1.520896,-77.262058 ],
    [ u"co",u"Santa Helena",865,6.3,-73.583333 ],
    [ u"co",u"Santa Isabel",2035,4.71418,-75.097986 ],
    [ u"co",u"Santa Lucía",15760,10.324198,-74.960169 ],
    [ u"co",u"Santa María",2761,2.861389,-75.597778 ],
    [ u"co",u"Santa María",2238,4.860483,-73.262338 ],
    [ u"co",u"Santa Marta",431788,11.240791,-74.19904 ],
    [ u"co",u"Santana",2091,6.057497,-73.481123 ],
    [ u"co",u"Santander de Quilichao",40799,3.009452,-76.484937 ],
    [ u"co",u"Santa Rosa de Cabal",57929,4.868056,-75.621389 ],
    [ u"co",u"Santa Rosa del Sur",8905,7.964444,-74.054444 ],
    [ u"co",u"Santa Rosa de Osos",10191,6.647375,-75.460305 ],
    [ u"co",u"Santa Rosa de Viterbo",6924,5.874008,-72.982166 ],
    [ u"co",u"Santa Rosa",2385,1.702666,-76.573891 ],
    [ u"co",u"Santa Rosa",10604,10.444722,-75.369722 ],
    [ u"co",u"Santa Sofía",1058,5.709077,-73.604037 ],
    [ u"co",u"Santiago",1032,7.864318,-72.716202 ],
    [ u"co",u"Santiago",2716,1.148444,-77.0045 ],
    [ u"co",u"Santo Domingo",2873,6.471423,-75.16395 ],
    [ u"co",u"Santo Tomás",25847,10.75773,-74.754509 ],
    [ u"co",u"Santuario",17722,6.138333,-75.264167 ],
    [ u"co",u"Santuario",6815,5.072367,-75.963407 ],
    [ u"co",u"San Vicente de Chucurí",11265,6.881,-73.409766 ],
    [ u"co",u"San Vicente",5021,6.232778,-75.336111 ],
    [ u"co",u"San Zenón",4340,9.214331,-74.313634 ],
    [ u"co",u"Sapúyes",2628,1.033333,-77.6 ],
    [ u"co",u"Saravena",33817,6.953758,-71.87523 ],
    [ u"co",u"Sardinata",7872,8.082888,-72.800707 ],
    [ u"co",u"Sasaima",2948,4.898056,-74.436944 ],
    [ u"co",u"Sativanorte",792,6.131564,-72.708947 ],
    [ u"co",u"Sativasur",579,6.089589,-72.724316 ],
    [ u"co",u"Segovia",39938,7.07993,-74.6989 ],
    [ u"co",u"Sesquilé",1876,5.044628,-73.797243 ],
    [ u"co",u"Sevilla",41613,4.264249,-75.930852 ],
    [ u"co",u"Siachoque",1375,5.512376,-73.244358 ],
    [ u"co",u"Sibaté",23208,4.484249,-74.24499 ],
    [ u"co",u"Sibundoy",9458,1.204777,-76.923664 ],
    [ u"co",u"Silos",1300,7.205245,-72.756386 ],
    [ u"co",u"Silvania",8237,4.403671,-74.3867 ],
    [ u"co",u"Silvia",7474,2.611029,-76.378533 ],
    [ u"co",u"Simacota",2157,6.442898,-73.336882 ],
    [ u"co",u"Simijaca",4767,5.50291,-73.852267 ],
    [ u"co",u"Simití",6670,7.9579,-73.9436 ],
    [ u"co",u"Sincelejo",261190,9.304722,-75.397778 ],
    [ u"co",u"Sincé",30769,9.243913,-75.146748 ],
    [ u"co",u"Sipí",332,4.658056,-76.476667 ],
    [ u"co",u"Sitionuevo",11817,10.777367,-74.720491 ],
    [ u"co",u"Soacha",313950,4.579368,-74.216819 ],
    [ u"co",u"Soatá",10945,6.333691,-72.682826 ],
    [ u"co",u"Socha",3353,5.981701,-72.715027 ],
    [ u"co",u"Socorro",17752,6.468382,-73.260224 ],
    [ u"co",u"Socotá",2194,6.040285,-72.635094 ],
    [ u"co",u"Sogamoso",126553,5.714344,-72.933908 ],
    [ u"co",u"Solano",2973,.69937,-75.253526 ],
    [ u"co",u"Soledad",342562,10.918433,-74.76459 ],
    [ u"co",u"Somondoco",1029,4.985437,-73.432703 ],
    [ u"co",u"Sonsón",17232,5.71062,-75.310685 ],
    [ u"co",u"Sopetrán",4902,6.670278,-75.7475 ],
    [ u"co",u"Soplaviento",8067,10.3875,-75.135556 ],
    [ u"co",u"Sopó",8396,4.907499,-73.938398 ],
    [ u"co",u"Soracá",827,5.500548,-73.332992 ],
    [ u"co",u"Sora",508,5.565142,-73.450173 ],
    [ u"co",u"Sotaquirá",1352,5.764828,-73.247583 ],
    [ u"co",u"Sotará",1390,2.254617,-76.610856 ],
    [ u"co",u"Suaita",2691,6.101404,-73.440412 ],
    [ u"co",u"Suan",10382,10.333471,-74.880161 ],
    [ u"co",u"Suárez",9986,2.953951,-76.696436 ],
    [ u"co",u"Suárez",1243,4.049058,-74.83198 ],
    [ u"co",u"Suaza",2481,1.976108,-75.79454 ],
    [ u"co",u"Subachoque",4088,4.926139,-74.17299 ],
    [ u"co",u"Sucre",2552,2.038049,-76.924461 ],
    [ u"co",u"Sucre",1095,5.918328,-73.79109 ],
    [ u"co",u"Sucre",23210,8.81136,-74.720839 ],
    [ u"co",u"Suesca",4877,5.102891,-73.798453 ],
    [ u"co",u"Supatá",1907,5.060967,-74.237205 ],
    [ u"co",u"Supía",12784,5.45303,-75.650717 ],
    [ u"co",u"Suratá",806,7.366332,-72.983608 ],
    [ u"co",u"Susacón",1207,6.229783,-72.690099 ],
    [ u"co",u"Susa",1609,5.451899,-73.814362 ],
    [ u"co",u"Sutamarchán",1432,5.615375,-73.617006 ],
    [ u"co",u"Sutatausa",1332,5.247794,-73.852378 ],
    [ u"co",u"Sutatenza",827,5.024027,-73.440502 ],
    [ u"co",u"Tabio",4180,4.917264,-74.093635 ],
    [ u"co",u"Tadó",10095,5.265977,-76.564874 ],
    [ u"co",u"Talaigua",6217,9.303472,-74.56477 ],
    [ u"co",u"Tamalameque",4972,8.852212,-73.812289 ],
    [ u"co",u"Tamara",2007,5.829722,-72.163333 ],
    [ u"co",u"Támesis",6407,5.664622,-75.713389 ],
    [ u"co",u"Tame",29100,6.460995,-71.730043 ],
    [ u"co",u"Taminango",2919,1.574908,-77.286658 ],
    [ u"co",u"Tangua",3348,1.094727,-77.394821 ],
    [ u"co",u"Taraira",341,.493889,-69.666944 ],
    [ u"co",u"Tarazá",13639,7.583583,-75.400684 ],
    [ u"co",u"Tarqui",4144,2.112485,-75.82419 ],
    [ u"co",u"Tarso",2700,5.864672,-75.821916 ],
    [ u"co",u"Tasco",1811,5.910443,-72.780012 ],
    [ u"co",u"Tauramena",4805,5.01831,-72.749187 ],
    [ u"co",u"Tausa",895,5.199029,-73.891282 ],
    [ u"co",u"Tello",4868,3.066944,-75.137778 ],
    [ u"co",u"Tena",696,4.660006,-74.392584 ],
    [ u"co",u"Tenerife",8476,9.900932,-74.859852 ],
    [ u"co",u"Tenjo",3858,4.872701,-74.144351 ],
    [ u"co",u"Tenza",1312,5.076644,-73.420767 ],
    [ u"co",u"Teruel",3921,2.741933,-75.567381 ],
    [ u"co",u"Tesalia",3981,2.485866,-75.729209 ],
    [ u"co",u"Tibacuy",1028,4.351111,-72.456389 ],
    [ u"co",u"Tibaná",1802,5.317284,-73.396548 ],
    [ u"co",u"Tibasosa",3535,5.746306,-72.998329 ],
    [ u"co",u"Tibirita",920,5.052274,-73.504585 ],
    [ u"co",u"Tibú",13566,8.638955,-72.73583 ],
    [ u"co",u"Tierralta",26242,8.173611,-76.059167 ],
    [ u"co",u"Timaná",8203,1.971357,-75.931233 ],
    [ u"co",u"Timbío",9606,2.350169,-76.683413 ],
    [ u"co",u"Timbiquí",6267,2.771697,-77.665359 ],
    [ u"co",u"Tinjacá",400,5.579163,-73.644855 ],
    [ u"co",u"Tipacoque",1036,6.42031,-72.691842 ],
    [ u"co",u"Tiquisio",4255,8.559722,-74.266944 ],
    [ u"co",u"Titiribí",3787,6.062765,-75.793703 ],
    [ u"co",u"Tocaima",10235,4.458201,-74.634343 ],
    [ u"co",u"Tocancipá",6027,4.965313,-73.913013 ],
    [ u"co",u"Toca",3946,5.563925,-73.18398 ],
    [ u"co",u"Togüí",829,5.390556,-73.516667 ],
    [ u"co",u"Toledo",4480,7.013056,-75.695278 ],
    [ u"co",u"Toledo",5911,7.309844,-72.482949 ],
    [ u"co",u"Tolú",27390,9.523919,-75.581392 ],
    [ u"co",u"Toluviejo",8260,9.450819,-75.438641 ],
    [ u"co",u"Tona",627,7.20221,-72.965018 ],
    [ u"co",u"Tópaga",1014,5.759792,-72.82583 ],
    [ u"co",u"Topaipí",1099,5.334567,-74.302917 ],
    [ u"co",u"Toribío",3912,2.954813,-76.268389 ],
    [ u"co",u"Toro",13764,4.611667,-76.081389 ],
    [ u"co",u"Tota",774,5.558327,-72.987567 ],
    [ u"co",u"Totoró",1888,2.512044,-76.40124 ],
    [ u"co",u"Trinidad",4752,5.407377,-71.661397 ],
    [ u"co",u"Trujillo",5874,4.212168,-76.319454 ],
    [ u"co",u"Tubará",8181,10.874444,-74.978889 ],
    [ u"co",u"Tuluá",165504,4.084656,-76.19536 ],
    [ u"co",u"Tumaco",86714,1.798611,-78.815556 ],
    [ u"co",u"Tunja",117480,5.535278,-73.367778 ],
    [ u"co",u"Tununguá",178,5.729673,-73.94137 ],
    [ u"co",u"Túquerres",20185,1.092341,-77.620852 ],
    [ u"co",u"Turbaco",56173,10.329444,-75.411367 ],
    [ u"co",u"Turbaná",10236,10.271695,-75.44222 ],
    [ u"co",u"Turbo",50509,8.093678,-76.726908 ],
    [ u"co",u"Turmequé",2901,5.323605,-73.490669 ],
    [ u"co",u"Tutasá",292,6.032282,-72.856387 ],
    [ u"co",u"Tuta",1639,5.689655,-73.227789 ],
    [ u"co",u"Ubalá",1886,4.747778,-72.536944 ],
    [ u"co",u"Ubaque",1009,4.486675,-73.937477 ],
    [ u"co",u"Ubaté",20486,5.309326,-73.815745 ],
    [ u"co",u"Ulloa",2621,4.704444,-75.740278 ],
    [ u"co",u"Umbita",1295,5.220408,-73.456953 ],
    [ u"co",u"Une",3208,4.403056,-74.025278 ],
    [ u"co",u"Unguía",4179,8.043346,-77.094527 ],
    [ u"co",u"Uramita",2292,6.899444,-76.174167 ],
    [ u"co",u"Uribia",7519,11.713897,-72.266035 ],
    [ u"co",u"Urrao",18846,6.315197,-76.134201 ],
    [ u"co",u"Urumita",8509,10.558938,-73.012319 ],
    [ u"co",u"Usiacurí",9147,10.75,-74.983333 ],
    [ u"co",u"Utica",2945,5.187271,-74.481047 ],
    [ u"co",u"Valdivia",3398,7.288889,-75.397778 ],
    [ u"co",u"Valencia",10653,8.258014,-76.149275 ],
    [ u"co",u"Valle del Guamuez",9969,.4525,-76.919167 ],
    [ u"co",u"Valle de San Juan",1486,4.198688,-75.117332 ],
    [ u"co",u"Valledupar",308242,10.46314,-73.253224 ],
    [ u"co",u"Valparaíso",3626,5.615003,-75.624218 ],
    [ u"co",u"Valparaíso",3767,1.19512,-75.707053 ],
    [ u"co",u"Vegachí",9618,6.761409,-74.794731 ],
    [ u"co",u"Vélez",10905,6.013351,-73.673521 ],
    [ u"co",u"Venadillo",11311,4.719295,-74.929181 ],
    [ u"co",u"Venecia",5462,5.962778,-75.738056 ],
    [ u"co",u"Ventaquemada",1680,5.367531,-73.520746 ],
    [ u"co",u"Vergara",2267,5.118412,-74.345492 ],
    [ u"co",u"Versalles",3543,4.30003,-76.302927 ],
    [ u"co",u"Vetas",1210,7.309107,-72.871218 ],
    [ u"co",u"Vianí",1586,4.87384,-74.562439 ],
    [ u"co",u"Victoria",4723,5.316481,-74.911006 ],
    [ u"co",u"Vigía del Fuerte",4638,6.578911,-76.886278 ],
    [ u"co",u"Vijes",4071,3.699335,-76.442304 ],
    [ u"co",u"Villa del Rosario",64952,7.833889,-72.474167 ],
    [ u"co",u"Villagarzon",7015,1.029049,-76.62022 ],
    [ u"co",u"Villagómez",779,5.273718,-74.196143 ],
    [ u"co",u"Villahermosa",4156,5.030673,-75.116068 ],
    [ u"co",u"Villamaría",35303,5.044923,-75.514604 ],
    [ u"co",u"Villanueva",18700,10.605278,-72.98 ],
    [ u"co",u"Villanueva",3707,6.671693,-73.174205 ],
    [ u"co",u"Villanueva",20033,5.283333,-71.966667 ],
    [ u"co",u"Villanueva",12792,10.443611,-75.273056 ],
    [ u"co",u"Villapinzón",5874,5.216171,-73.5949 ],
    [ u"co",u"Villa Rica",9070,2.509491,-76.844185 ],
    [ u"co",u"Villarrica",3081,3.935024,-74.600359 ],
    [ u"co",u"Villavicencio",321721,4.142002,-73.626645 ],
    [ u"co",u"Villavieja",2730,3.220523,-75.218643 ],
    [ u"co",u"Villeta",20689,5.008856,-74.472264 ],
    [ u"co",u"Viotá",5840,4.437129,-74.521573 ],
    [ u"co",u"Viracachá",541,5.436373,-73.296059 ],
    [ u"co",u"Vista Hermosa",4282,3.124283,-73.751561 ],
    [ u"co",u"Viterbo",15216,5.062421,-75.87159 ],
    [ u"co",u"Yacopí",3202,5.459477,-74.338226 ],
    [ u"co",u"Yacuanquer",2643,1.115772,-77.401687 ],
    [ u"co",u"Yaguará",5724,2.663548,-75.517532 ],
    [ u"co",u"Yalí",3908,6.674565,-74.834296 ],
    [ u"co",u"Yarumal",22368,6.890278,-75.670833 ],
    [ u"co",u"Yavaraté",38,.615,-69.208056 ],
    [ u"co",u"Yolombó",6033,6.598411,-75.011402 ],
    [ u"co",u"Yondó",7516,7.006208,-73.909717 ],
    [ u"co",u"Yopal",61031,5.337752,-72.395859 ],
    [ u"co",u"Yotoco",8362,3.860478,-76.383644 ],
    [ u"co",u"Yumbo",71438,3.582335,-76.491455 ],
    [ u"co",u"Zambrano",9565,9.747238,-74.815298 ],
    [ u"co",u"Zapatoca",6052,6.815319,-73.267684 ],
    [ u"co",u"Zaragoza",18795,7.489707,-74.869189 ],
    [ u"co",u"Zarzal",28761,4.394621,-76.071499 ],
    [ u"co",u"Zetaquira",1047,5.282152,-73.168956 ],
    [ u"co",u"Zipacón",1480,4.758807,-74.380167 ],
    [ u"co",u"Zipaquirá",91237,5.022079,-74.004812 ],
    [ u"cr",u"Alajuela",47503,10.016247,-84.211628 ],
    [ u"cr",u"Alajuelita",13848,9.901627,-84.10042 ],
    [ u"cr",u"Aserrí",25874,9.858758,-84.092301 ],
    [ u"cr",u"Atenas",7014,9.978058,-84.380319 ],
    [ u"cr",u"Bagaces",4108,10.527091,-85.254825 ],
    [ u"cr",u"Batán",4584,10.084435,-83.340997 ],
    [ u"cr",u"Buenos Aires",11680,8.859576,-83.502242 ],
    [ u"cr",u"Calle Blancos",20714,9.95,-84.066667 ],
    [ u"cr",u"Cañas",20309,10.429397,-85.093113 ],
    [ u"cr",u"Carmen",15920,10.200948,-83.477775 ],
    [ u"cr",u"Cartago",26615,9.853281,-83.902296 ],
    [ u"cr",u"Chacarita",26354,9.982886,-84.772319 ],
    [ u"cr",u"Cinco Esquinas",7158,10.10374,-84.167815 ],
    [ u"cr",u"Colón",9687,9.916362,-84.241832 ],
    [ u"cr",u"Concepción",22036,9.933333,-84 ],
    [ u"cr",u"Corredor",7084,8.640016,-82.945997 ],
    [ u"cr",u"Curridabat",34592,9.911785,-84.034068 ],
    [ u"cr",u"Daniel Flores",10028,9.335538,-83.669397 ],
    [ u"cr",u"Desamparados",39276,9.896798,-84.06294 ],
    [ u"cr",u"Escazú",12073,9.918872,-84.139895 ],
    [ u"cr",u"Esparta",15575,9.994468,-84.664658 ],
    [ u"cr",u"Florencia",888,10.361309,-84.474961 ],
    [ u"cr",u"Golfito",6778,8.639011,-83.166029 ],
    [ u"cr",u"Grecia",12677,10.072427,-84.311242 ],
    [ u"cr",u"Guácimo",7022,10.21044,-83.680666 ],
    [ u"cr",u"Guácimo",11720,8.948405,-83.109585 ],
    [ u"cr",u"Guadalupe",13754,9.860578,-83.935301 ],
    [ u"cr",u"Guadalupe",13754,9.652861,-84.007966 ],
    [ u"cr",u"Guápiles",19097,10.215878,-83.786609 ],
    [ u"cr",u"Heredia",21968,10.002362,-84.11651 ],
    [ u"cr",u"Ipís",26674,9.967455,-84.013255 ],
    [ u"cr",u"Juntas",4737,10.280895,-84.959506 ],
    [ u"cr",u"La Cruz",4319,11.073771,-85.632716 ],
    [ u"cr",u"La Suiza",2434,9.85238,-83.613307 ],
    [ u"cr",u"Liberia",45405,10.635039,-85.43772 ],
    [ u"cr",u"Limón",63094,9.992861,-83.030533 ],
    [ u"cr",u"Los Chiles",3342,11.033333,-84.716667 ],
    [ u"cr",u"Matina",2315,10.076088,-83.289527 ],
    [ u"cr",u"Mercedes",26013,10.006955,-84.133963 ],
    [ u"cr",u"Miramar",6540,10.092499,-84.729783 ],
    [ u"cr",u"Naranjo",11856,10.09866,-84.378243 ],
    [ u"cr",u"Nicoya",15315,10.148275,-85.452013 ],
    [ u"cr",u"Orotina",6135,9.911972,-84.52337 ],
    [ u"cr",u"Pacayas",1556,9.807087,-84.047638 ],
    [ u"cr",u"Palmares",4645,9.324647,-83.666597 ],
    [ u"cr",u"Palmar",4657,10.021289,-84.773365 ],
    [ u"cr",u"Palmar",4657,9.872758,-84.455337 ],
    [ u"cr",u"Paraíso",39709,9.83832,-83.865565 ],
    [ u"cr",u"Parrita",3734,9.52012,-84.322487 ],
    [ u"cr",u"Pital",2046,10.450558,-84.274065 ],
    [ u"cr",u"Pocosol",2947,10.366667,-84.616667 ],
    [ u"cr",u"Puerto Cortés",3850,8.959878,-83.523813 ],
    [ u"cr",u"Puntarenas",35655,9.976149,-84.838754 ],
    [ u"cr",u"Purral",30034,9.958084,-84.030498 ],
    [ u"cr",u"Quepos",7810,9.423574,-84.165224 ],
    [ u"cr",u"Quesada",27316,10.323807,-84.427141 ],
    [ u"cr",u"Río Segundo",9853,10.002992,-84.190393 ],
    [ u"cr",u"Roxana",2351,10.275277,-83.75133 ],
    [ u"cr",u"Sabanilla",13253,9.945223,-84.039265 ],
    [ u"cr",u"San Antonio",12965,10.068342,-84.325441 ],
    [ u"cr",u"San Antonio",12965,9.983333,-84.183333 ],
    [ u"cr",u"San Diego",16991,9.898985,-84.00287 ],
    [ u"cr",u"San Felipe",24985,9.904882,-84.105512 ],
    [ u"cr",u"San Francisco",55933,10.0035,-84.072127 ],
    [ u"cr",u"San Francisco",55933,9.95,-84.066667 ],
    [ u"cr",u"San Ignacio",3072,9.79853,-84.161733 ],
    [ u"cr",u"San Isidro",17617,10.017035,-84.055565 ],
    [ u"cr",u"San Isidro",17617,9.977033,-84.007743 ],
    [ u"cr",u"San Josecito",12195,10.016667,-84.1 ],
    [ u"cr",u"San José",31430,10.951731,-85.136096 ],
    [ u"cr",u"San José",335056,9.933333,-84.083333 ],
    [ u"cr",u"San Juan",7729,10.099047,-84.242856 ],
    [ u"cr",u"San Juan",26051,9.959738,-84.081653 ],
    [ u"cr",u"San Marcos de Tarrazú",4255,9.660105,-84.020261 ],
    [ u"cr",u"San Miguel",28827,9.871206,-84.06084 ],
    [ u"cr",u"San Pablo",21666,10.030131,-84.122144 ],
    [ u"cr",u"San Pedro",27482,9.928293,-84.050735 ],
    [ u"cr",u"San Rafael Abajo",27424,9.831002,-84.290079 ],
    [ u"cr",u"San Rafael Arriba",15054,9.875563,-84.076613 ],
    [ u"cr",u"San Rafael",3624,10.046182,-84.247053 ],
    [ u"cr",u"San Rafael",9951,9.764961,-83.827298 ],
    [ u"cr",u"San Rafael",8889,10.013202,-84.100157 ],
    [ u"cr",u"San Rafael",25415,9.875563,-84.076613 ],
    [ u"cr",u"San Ramón",10774,10.088021,-84.470217 ],
    [ u"cr",u"Santa Ana",8031,9.932598,-84.182545 ],
    [ u"cr",u"Santa Cruz",12283,10.26053,-85.585097 ],
    [ u"cr",u"Santiago",8292,9.846358,-84.314281 ],
    [ u"cr",u"Santo Domingo",5750,10.063885,-84.154987 ],
    [ u"cr",u"San Vicente",34453,9.98433,-84.08223 ],
    [ u"cr",u"San Vicente",34453,9.960158,-84.04762 ],
    [ u"cr",u"San Vito",3981,8.820786,-82.970919 ],
    [ u"cr",u"Siquirres",18235,10.09748,-83.506588 ],
    [ u"cr",u"Tilarán",7301,10.470292,-84.967094 ],
    [ u"cr",u"Tres Ríos",10432,9.90644,-83.987602 ],
    [ u"cr",u"Turrialba",28960,9.904666,-83.683519 ],
    [ u"cr",u"Upala",4185,10.897918,-85.014536 ],
    [ u"cr",u"Zarcero",3559,10.18561,-84.390757 ],
    [ u"cu",u"Abreus",16711,22.2775,-80.5675 ],
    [ u"cu",u"Agramonte",5376,22.6761111,-81.1163889 ],
    [ u"cu",u"Aguada de Pasajeros",23606,22.385,-80.8508333 ],
    [ u"cu",u"Alacranes",5843,22.7675,-81.5675 ],
    [ u"cu",u"Alquízar",15275,22.8058333,-82.5841667 ],
    [ u"cu",u"Amancio",26914,20.8225,-77.5786111 ],
    [ u"cu",u"Artemisa",68076,22.8130556,-82.7619444 ],
    [ u"cu",u"Báguanos",15176,20.7488889,-76.0258333 ],
    [ u"cu",u"Bahía Honda",19834,22.9036111,-83.1591667 ],
    [ u"cu",u"Banes",53107,20.9625,-75.7186111 ],
    [ u"cu",u"Baracoa",48365,20.3466667,-74.4958333 ],
    [ u"cu",u"Baraguá",15268,21.6966667,-78.6327778 ],
    [ u"cu",u"Batabanó",13832,22.6869444,-82.2927778 ],
    [ u"cu",u"Bauta",45771,22.9827778,-82.5463889 ],
    [ u"cu",u"Bayamo",192641,20.3791667,-76.6433333 ],
    [ u"cu",u"Bejucal",18123,22.9286111,-82.3886111 ],
    [ u"cu",u"Bolondrón",6778,22.7633333,-81.4469444 ],
    [ u"cu",u"Cabaiguán",44516,22.0788889,-79.4991667 ],
    [ u"cu",u"Cabañas",5894,22.9758333,-82.9219444 ],
    [ u"cu",u"Caibarién",39142,22.5205556,-79.4669444 ],
    [ u"cu",u"Calabazar de Sagua",10455,22.6447222,-79.8961111 ],
    [ u"cu",u"Calimete",23255,22.5333333,-80.9061111 ],
    [ u"cu",u"Camagüey",347572,21.3808333,-77.9169444 ],
    [ u"cu",u"Camajuaní",35517,22.465,-79.7244444 ],
    [ u"cu",u"Campechuela",25069,20.2341667,-77.2788889 ],
    [ u"cu",u"Candelaria",12675,22.7405556,-82.9611111 ],
    [ u"cu",u"Cárdenas",98519,23.0375,-81.2047222 ],
    [ u"cu",u"Chambas",24113,22.1927778,-78.9136111 ],
    [ u"cu",u"Ciego de Ávila",142032,21.84,-78.7619444 ],
    [ u"cu",u"Cienfuegos",186648,22.1461111,-80.4355556 ],
    [ u"cu",u"Cifuentes",40142,22.645,-80.0461111 ],
    [ u"cu",u"Colombia",20096,20.9880556,-77.4297222 ],
    [ u"cu",u"Colón",63885,22.7191667,-80.9058333 ],
    [ u"cu",u"Condado",38249,21.8766667,-79.8402778 ],
    [ u"cu",u"Consolación del Sur",69859,22.5047222,-83.5136111 ],
    [ u"cu",u"Contramaestre",70441,20.2977778,-76.2413889 ],
    [ u"cu",u"Corralillo",51900,22.9819444,-80.5855556 ],
    [ u"cu",u"Cruces",24907,22.3411111,-80.2666667 ],
    [ u"cu",u"Cueto",26527,20.6438889,-75.9355556 ],
    [ u"cu",u"Cumanayagua",38689,22.1494444,-80.2022222 ],
    [ u"cu",u"El Cobre",4768,20.0488889,-75.9469444 ],
    [ u"cu",u"Encrucijada",26155,22.6169444,-79.8711111 ],
    [ u"cu",u"Esmeralda",20274,21.8525,-78.1169444 ],
    [ u"cu",u"Esperanza",10462,22.3333333,-80.05 ],
    [ u"cu",u"Florida",63009,21.5247222,-78.2258333 ],
    [ u"cu",u"Fomento",19991,22.1038889,-79.7216667 ],
    [ u"cu",u"Gibara",27603,21.1097222,-76.1316667 ],
    [ u"cu",u"Guáimaro",39360,21.05,-77.35 ],
    [ u"cu",u"Guanajay",25258,22.9263889,-82.6875 ],
    [ u"cu",u"Guane",16548,22.2025,-84.0875 ],
    [ u"cu",u"Guantánamo",272808,20.1444444,-75.2091667 ],
    [ u"cu",u"Güines",68938,22.8361111,-82.0280556 ],
    [ u"cu",u"Güira de Melena",69897,22.7905556,-82.5052778 ],
    [ u"cu",u"Guisa",18408,20.255,-76.5386111 ],
    [ u"cu",u"Holguín",319114,20.8872222,-76.2630556 ],
    [ u"cu",u"Jagüey Grande",54365,22.5269444,-81.1286111 ],
    [ u"cu",u"Jaruco",20207,23.0430556,-82.0108333 ],
    [ u"cu",u"Jatibonico",19644,21.9419444,-79.17 ],
    [ u"cu",u"Jiguaní",41109,20.3666667,-76.4272222 ],
    [ u"cu",u"Jobabo",17804,20.9691667,-76.2994444 ],
    [ u"cu",u"Jovellanos",47166,22.8044444,-81.1944444 ],
    [ u"cu",u"Las Tunas",203690,20.9616667,-76.9511111 ],
    [ u"cu",u"Los Arabos",12504,22.7280556,-80.7213889 ],
    [ u"cu",u"Los Palacios",25703,22.5872222,-83.2486111 ],
    [ u"cu",u"Madruga",33798,22.9113889,-81.8561111 ],
    [ u"cu",u"Manati",13278,21.3047222,-76.8402778 ],
    [ u"cu",u"Manguito",3155,22.5880556,-80.9144444 ],
    [ u"cu",u"Manicaragua",41532,22.1494444,-79.9736111 ],
    [ u"cu",u"Mantua",10797,22.2888889,-84.2844444 ],
    [ u"cu",u"Manzanillo",128194,20.3433333,-77.1166667 ],
    [ u"cu",u"Mariel",28987,22.9875,-82.7536111 ],
    [ u"cu",u"Martí",13439,22.9475,-80.9202778 ],
    [ u"cu",u"Matanzas",146738,23.0411111,-81.5775 ],
    [ u"cu",u"Mayarí",83631,20.6541667,-75.6819444 ],
    [ u"cu",u"Media Luna",16713,20.1419444,-77.435 ],
    [ u"cu",u"Minas",20863,21.4833333,-77.6166667 ],
    [ u"cu",u"Moa",92885,20.6569444,-74.9402778 ],
    [ u"cu",u"Morón",66062,22.1094444,-78.6275 ],
    [ u"cu",u"Niquero",18771,20.0430556,-77.5827778 ],
    [ u"cu",u"Nueva Gerona",20264,21.8833333,-82.8 ],
    [ u"cu",u"Nuevitas",54024,21.5452778,-77.2644444 ],
    [ u"cu",u"Palma Soriano",102830,20.2172222,-75.9988889 ],
    [ u"cu",u"Palmira",23078,22.2416667,-80.3902778 ],
    [ u"cu",u"Pedro Betancourt",26761,22.7272222,-81.29 ],
    [ u"cu",u"Perico",24073,22.7691667,-81.0188889 ],
    [ u"cu",u"Pinar del Río",186997,22.4175,-83.6980556 ],
    [ u"cu",u"Placetas",55410,22.3119444,-79.6533333 ],
    [ u"cu",u"Primero de Enero",17934,21.9469444,-78.4283333 ],
    [ u"cu",u"Puerto Padre",76841,21.195,-76.6027778 ],
    [ u"cu",u"Quemado de Güines",12736,22.7852778,-80.2536111 ],
    [ u"cu",u"Rancho Veloz",4549,22.8805556,-80.3916667 ],
    [ u"cu",u"Ranchuelo",43696,22.3772222,-80.1488889 ],
    [ u"cu",u"Remedios",34109,22.4947222,-79.5458333 ],
    [ u"cu",u"Río Cauto",23737,20.5602778,-76.9161111 ],
    [ u"cu",u"Rodas",19212,22.3408333,-80.5572222 ],
    [ u"cu",u"Sagua de Tánamo",18282,20.5819444,-75.2413889 ],
    [ u"cu",u"Sagua la Grande",62075,22.8066667,-80.0755556 ],
    [ u"cu",u"San Antonio de los Baños",42726,22.8911111,-82.4991667 ],
    [ u"cu",u"San Cristóbal",59582,22.7141667,-83.0480556 ],
    [ u"cu",u"Sancti Spíritus",127073,21.9297222,-79.4425 ],
    [ u"cu",u"San Diego de los Baños",1643,22.6466667,-83.3697222 ],
    [ u"cu",u"San José de las Lajas",54850,22.9613889,-82.1511111 ],
    [ u"cu",u"San Luis",6690,22.2786111,-83.7611111 ],
    [ u"cu",u"San Luis",67296,20.0997222,-75.7472222 ],
    [ u"cu",u"San Nicolás",14914,22.7844444,-81.9133333 ],
    [ u"cu",u"Santa Clara",250518,22.1666667,-79.7666667 ],
    [ u"cu",u"Santa Cruz del Norte",18403,23.1538889,-81.9236111 ],
    [ u"cu",u"Santa Cruz del Sur",34602,20.7147222,-77.9955556 ],
    [ u"cu",u"Santa Fe",4595,21.7422222,-82.755 ],
    [ u"cu",u"Santiago de Cuba",555878,20.0247222,-75.8219444 ],
    [ u"cu",u"Santiago de las Vegas",35241,22.97,-82.3869444 ],
    [ u"cu",u"Santo Domingo",45477,22.5866667,-80.2436111 ],
    [ u"cu",u"Sibanicú",16856,21.235,-77.5263889 ],
    [ u"cu",u"Trinidad",60208,21.8019444,-79.9841667 ],
    [ u"cu",u"Unión de Reyes",33647,22.7952778,-81.5375 ],
    [ u"cu",u"Varadero",17178,23.1536111,-81.2513889 ],
    [ u"cu",u"Venezuela",16601,21.7352778,-78.7963889 ],
    [ u"cu",u"Vertientes",29704,21.2594444,-78.1463889 ],
    [ u"cu",u"Yaguajay",42220,22.3272222,-79.2377778 ],
    [ u"cu",u"Yara",28944,20.2752778,-76.9533333 ],
    [ u"cu",u"Zaza del Medio",8667,21.9961111,-79.3669444 ],
    [ u"cu",u"Zulueta",6141,22.3669444,-79.5691667 ],
    [ u"cv",u"Assomada",7808,15.1,-23.6833333 ],
    [ u"cv",u"Mindelo",69441,16.8833333,-25.0 ],
    [ u"cv",u"Pombas",1790,17.15,-25.0166667 ],
    [ u"cv",u"Ponta do Sol",4001,17.2,-25.1 ],
    [ u"cv",u"Porto Novo",5494,17.0333333,-25.0666667 ],
    [ u"cv",u"Praia",111611,14.9166667,-23.5166667 ],
    [ u"cv",u"Ribeira Brava",5242,16.6166667,-24.3 ],
    [ u"cv",u"Sal Rei",2089,16.1833333,-22.9166667 ],
    [ u"cv",u"Santa Maria",16967,16.6,-22.9 ],
    [ u"cv",u"São Filipe",8063,14.9,-24.5166667 ],
    [ u"cv",u"Tarrafal",6366,15.2833333,-23.7666667 ],
    [ u"cv",u"Vila do Maio",2962,15.1333333,-23.2166667 ],
    [ u"cy",u"Aradippou",13351,34.95,33.5916667 ],
    [ u"cy",u"Chlorakas",3619,34.8041667,32.4083333 ],
    [ u"cy",u"Dipkarpaz",5215,35.6,34.375 ],
    [ u"cy",u"Dromolaxia",5241,34.8791667,33.5833333 ],
    [ u"cy",u"Empa",4520,34.8083333,32.425 ],
    [ u"cy",u"Gazimagusa",42532,35.125,33.95 ],
    [ u"cy",u"Geri",7640,35.1,33.4166667 ],
    [ u"cy",u"Girne",26720,35.3416667,33.3166667 ],
    [ u"cy",u"Güzelyurt",14836,35.1980556,32.9913889 ],
    [ u"cy",u"Iskele",4491,35.2875,33.8916667 ],
    [ u"cy",u"Lapithos",5215,35.3125,33.1416667 ],
    [ u"cy",u"Larnaca",48954,34.9166667,33.6291667 ],
    [ u"cy",u"Lefka",7836,35.1105556,32.8505556 ],
    [ u"cy",u"Lemesos",154018,34.675,33.0333333 ],
    [ u"cy",u"Livadia",5329,34.9541667,33.6291667 ],
    [ u"cy",u"Nicosia",42342,35.1666667,33.3666667 ],
    [ u"cy",u"Páfos",35966,34.7666667,32.4166667 ],
    [ u"cy",u"Pano Polemidia",3781,34.7,33.0 ],
    [ u"cy",u"Paralimni",11838,35.0375,33.9833333 ],
    [ u"cy",u"Polis",1975,35.0366667,32.4263889 ],
    [ u"cy",u"Ypsonas",7349,34.6833333,32.9583333 ],
    [ u"cy",u"Ziyamet",1593,35.4708333,34.1416667 ],
    [ u"cz",u"Adamov",4951,49.301409,16.655487 ],
    [ u"cz",u"Albrechtice",4055,50.857945,15.033725 ],
    [ u"cz",u"Bakov nad Jizerou",4684,50.478355,14.939416 ],
    [ u"cz",u"Banov",2072,48.988364,17.721403 ],
    [ u"cz",u"Baska",3145,49.64417,18.371902 ],
    [ u"cz",u"Batelov",2383,49.313905,15.396317 ],
    [ u"cz",u"Bechyne",5900,49.299118,14.469875 ],
    [ u"cz",u"Becov",2069,50.44922,13.717491 ],
    [ u"cz",u"Bela pod Bezdezem",4937,50.503175,14.799517 ],
    [ u"cz",u"Benatky nad Jizerou",6853,50.28619,14.834337 ],
    [ u"cz",u"Benesov",16321,49.782377,14.686569 ],
    [ u"cz",u"Benesov nad Ploucnici",4042,50.738658,14.311497 ],
    [ u"cz",u"Beroun",17422,49.966171,14.060086 ],
    [ u"cz",u"Bilina",15866,50.548752,13.775444 ],
    [ u"cz",u"Bilovec",7465,49.75703,18.016558 ],
    [ u"cz",u"Bilovice nad Svitavou",2293,49.245536,16.671772 ],
    [ u"cz",u"Blansko",20643,49.363931,16.647513 ],
    [ u"cz",u"Blatna",6609,49.427165,13.884526 ],
    [ u"cz",u"Blovice",3852,49.583231,13.533991 ],
    [ u"cz",u"Blucina",1998,49.055618,16.647764 ],
    [ u"cz",u"Bludov",3177,49.942862,16.926266 ],
    [ u"cz",u"Bochov",1940,50.150569,13.046016 ],
    [ u"cz",u"Bohumin",23310,49.901831,18.360679 ],
    [ u"cz",u"Bohunovice",2354,49.66286,17.289043 ],
    [ u"cz",u"Bohusovice nad Ohri",2523,50.494477,14.149776 ],
    [ u"cz",u"Bojkovice",4747,49.037279,17.816865 ],
    [ u"cz",u"Bolatice",4118,49.953699,18.082143 ],
    [ u"cz",u"Bor",3944,49.713098,12.776297 ],
    [ u"cz",u"Borohradek",2127,50.096142,16.092833 ],
    [ u"cz",u"Borovany",3565,48.899809,14.642921 ],
    [ u"cz",u"Borsice",2273,49.061597,17.350058 ],
    [ u"cz",u"Boskovice",11356,49.490899,16.659172 ],
    [ u"cz",u"Brandys nad Labem-Stara Boleslav",15375,50.183608,14.659499 ],
    [ u"cz",u"Brasy",2024,49.832415,13.568605 ],
    [ u"cz",u"Breclav",26905,48.757723,16.890041 ],
    [ u"cz",u"Breznice",3772,49.558764,13.950916 ],
    [ u"cz",u"Brezova",2767,50.196603,12.87048 ],
    [ u"cz",u"Bridlicna",3796,49.911432,17.365002 ],
    [ u"cz",u"Brno",377407,49.2,16.633333 ],
    [ u"cz",u"Brodek u Prerova",1908,49.484523,17.336783 ],
    [ u"cz",u"Broumov",8325,50.585292,16.331815 ],
    [ u"cz",u"Brtnice",3641,49.310551,15.674454 ],
    [ u"cz",u"Bruntal",17610,49.989638,17.463217 ],
    [ u"cz",u"Brusperk",3573,49.699167,18.222021 ],
    [ u"cz",u"Buchlovice",2437,49.088463,17.340304 ],
    [ u"cz",u"Bucovice",6297,49.150789,17.002631 ],
    [ u"cz",u"Budisov nad Budisovkou",3220,49.794289,17.628931 ],
    [ u"cz",u"Bustehrad",2343,50.154904,14.187483 ],
    [ u"cz",u"Bystrice",4972,49.641899,18.730349 ],
    [ u"cz",u"Bystrice",3991,49.731793,14.667197 ],
    [ u"cz",u"Bystrice nad Pernstejnem",9030,49.52333,16.25941 ],
    [ u"cz",u"Bystrice pod Hostynem",8748,49.399643,17.674172 ],
    [ u"cz",u"Bzenec",4184,48.970968,17.269298 ],
    [ u"cz",u"Caslav",10209,49.912041,15.39483 ],
    [ u"cz",u"Cejkovice",2554,48.883333,16.283333 ],
    [ u"cz",u"Celadna",2027,49.552926,18.346749 ],
    [ u"cz",u"Celakovice",10086,50.163545,14.755924 ],
    [ u"cz",u"Cercany",2689,49.849118,14.706445 ],
    [ u"cz",u"Cerna Hora",1906,49.41309,16.581007 ],
    [ u"cz",u"Cernilov",2160,50.263472,15.914827 ],
    [ u"cz",u"Cernosice",4774,49.958377,14.319865 ],
    [ u"cz",u"Cervena Voda",3214,50.042613,16.742237 ],
    [ u"cz",u"Cerveny Kostelec",8431,50.476607,16.093114 ],
    [ u"cz",u"Ceska Kamenice",5468,50.800341,14.418459 ],
    [ u"cz",u"Ceska Lipa",39398,50.686736,14.538125 ],
    [ u"cz",u"Ceska Skalice",5384,50.394014,16.049184 ],
    [ u"cz",u"Ceska Trebova",17103,49.901115,16.445046 ],
    [ u"cz",u"Ceska Ves",2475,50.257388,17.228514 ],
    [ u"cz",u"Ceske Budejovice",97530,48.983333,14.466667 ],
    [ u"cz",u"Ceske Velenice",3504,48.764608,14.95924 ],
    [ u"cz",u"Cesky Brod",6875,50.07358,14.858163 ],
    [ u"cz",u"Cesky Dub",2835,50.660313,14.995326 ],
    [ u"cz",u"Cesky Krumlov",14404,48.81264,14.318207 ],
    [ u"cz",u"Cesky Tesin",26478,49.745479,18.621783 ],
    [ u"cz",u"Chabarovice",2223,50.67493,13.939411 ],
    [ u"cz",u"Cheb",32778,50.075777,12.374676 ],
    [ u"cz",u"Chlumcany",2371,49.631497,13.310957 ],
    [ u"cz",u"Chlumec",4090,50.699732,13.936998 ],
    [ u"cz",u"Chlumec nad Cidlinou",5229,50.156747,15.45845 ],
    [ u"cz",u"Chlum u Trebone",2253,48.961325,14.92961 ],
    [ u"cz",u"Chocen",9002,50.004354,16.22068 ],
    [ u"cz",u"Chodov",14661,50.239093,12.748613 ],
    [ u"cz",u"Chomutov",51054,50.463532,13.41365 ],
    [ u"cz",u"Chotebor",9829,49.717964,15.672295 ],
    [ u"cz",u"Chotesov",2592,49.655302,13.201168 ],
    [ u"cz",u"Chrastava",5918,50.816043,14.968178 ],
    [ u"cz",u"Chropyne",5232,49.361302,17.367619 ],
    [ u"cz",u"Chrudim",23909,49.95,15.8 ],
    [ u"cz",u"Chvaletice",3308,50.027712,15.445573 ],
    [ u"cz",u"Chynov",2059,49.408237,14.811225 ],
    [ u"cz",u"Cvikov",4430,50.777624,14.632985 ],
    [ u"cz",u"Dacice",7895,49.079485,15.4357 ],
    [ u"cz",u"Decin",52521,50.77137,14.198248 ],
    [ u"cz",u"Desna",3534,50.757871,15.311269 ],
    [ u"cz",u"Detmarovice",3768,49.894051,18.462384 ],
    [ u"cz",u"Dobra",2920,49.672268,18.414883 ],
    [ u"cz",u"Dobrany",5642,49.653671,13.29378 ],
    [ u"cz",u"Dobrichovice",2863,49.930846,14.27753 ],
    [ u"cz",u"Dobris",8066,49.780879,14.170542 ],
    [ u"cz",u"Dobronin",1897,49.48208,15.679466 ],
    [ u"cz",u"Dobrovice",3027,50.366759,14.961847 ],
    [ u"cz",u"Dobruska",7150,50.291973,16.161633 ],
    [ u"cz",u"Dobsice",2333,48.85,16.083333 ],
    [ u"cz",u"Doksy",5041,50.565654,14.654607 ],
    [ u"cz",u"Dolany",1932,49.64881,17.322268 ],
    [ u"cz",u"Dolni Benesov",4353,49.922199,18.113812 ],
    [ u"cz",u"Dolni Bojanovice",2870,48.857761,17.028111 ],
    [ u"cz",u"Dolni Bousov",2362,50.437513,15.127006 ],
    [ u"cz",u"Dolni Dobrouc",2553,49.992745,16.498762 ],
    [ u"cz",u"Dolni Kounice",2297,49.07548,16.458775 ],
    [ u"cz",u"Dolni Lutyne",4752,49.902974,18.423696 ],
    [ u"cz",u"Dolni Nemci",3002,48.968436,17.584023 ],
    [ u"cz",u"Dolni Poustevna",1938,50.991419,14.293227 ],
    [ u"cz",u"Domazlice",11036,49.441403,12.925536 ],
    [ u"cz",u"Doudleby nad Orlici",1927,50.107118,16.258362 ],
    [ u"cz",u"Drnovice",2178,49.274783,16.950789 ],
    [ u"cz",u"Dubi",7592,50.674556,13.79464 ],
    [ u"cz",u"Dubnany",6635,48.922718,17.104341 ],
    [ u"cz",u"Duchcov",8737,50.608973,13.744816 ],
    [ u"cz",u"Dvur Kralove",16364,50.429766,15.813812 ],
    [ u"cz",u"Frantiskovy Lazne",5234,50.12425,12.348123 ],
    [ u"cz",u"Frenstat",11348,49.544884,18.210243 ],
    [ u"cz",u"Frycovice",2114,49.674995,18.228693 ],
    [ u"cz",u"Frydek-Mistek",61584,49.683333,18.35 ],
    [ u"cz",u"Frydlant",7481,50.923446,15.077856 ],
    [ u"cz",u"Frydlant nad Ostravici",9753,49.591096,18.359548 ],
    [ u"cz",u"Frystak",3457,49.291023,17.693884 ],
    [ u"cz",u"Fulnek",6030,49.713098,17.900844 ],
    [ u"cz",u"Golcuv Jenikov",2593,49.816395,15.477346 ],
    [ u"cz",u"Habartov",5367,50.193493,12.574425 ],
    [ u"cz",u"Haj ve Slezsku",3299,49.898602,18.098483 ],
    [ u"cz",u"Halenkov",2349,49.319523,18.146193 ],
    [ u"cz",u"Hanusovice",3585,50.079228,16.93492 ],
    [ u"cz",u"Havirov",85829,49.8,18.4 ],
    [ u"cz",u"Havlickuv Brod",24373,49.614082,15.564558 ],
    [ u"cz",u"Hejnice",2692,50.878539,15.181515 ],
    [ u"cz",u"Hermanuv Mestec",4865,49.936342,15.678921 ],
    [ u"cz",u"Hlinsko",10538,49.763832,15.909317 ],
    [ u"cz",u"Hlubocky",4556,49.628217,17.403569 ],
    [ u"cz",u"Hluboka nad Vltavou",4514,49.05379,14.454533 ],
    [ u"cz",u"Hlucin",14341,49.896907,18.191661 ],
    [ u"cz",u"Hluk",4340,48.987772,17.526427 ],
    [ u"cz",u"Hodkovice nad Mohelkou",2588,50.665805,15.090202 ],
    [ u"cz",u"Hodonin",27600,48.856013,17.123073 ],
    [ u"cz",u"Holesov",12455,49.329979,17.577216 ],
    [ u"cz",u"Holice",6192,50.069729,15.992836 ],
    [ u"cz",u"Holysov",4562,49.592964,13.100612 ],
    [ u"cz",u"Horice",9052,50.369111,15.630551 ],
    [ u"cz",u"Horka nad Moravou",2048,49.638936,17.207852 ],
    [ u"cz",u"Horni Becva",2408,49.433333,18.283333 ],
    [ u"cz",u"Horni Benesov",2473,49.967143,17.603331 ],
    [ u"cz",u"Horni Briza",4468,49.842714,13.361977 ],
    [ u"cz",u"Horni Jiretin",1908,50.566667,13.566667 ],
    [ u"cz",u"Horni Plana",2281,48.768088,14.043873 ],
    [ u"cz",u"Horni Slavkov",5942,50.139647,12.806378 ],
    [ u"cz",u"Horni Sucha",4353,49.804997,18.476979 ],
    [ u"cz",u"Horomerice",2105,50.133877,14.334353 ],
    [ u"cz",u"Horovice",6570,49.836564,13.902058 ],
    [ u"cz",u"Hostinne",4865,50.540171,15.730411 ],
    [ u"cz",u"Hostivice",4727,50.080782,14.255397 ],
    [ u"cz",u"Hovezi",2302,49.304997,18.06167 ],
    [ u"cz",u"Hovorany",2212,48.95513,16.990661 ],
    [ u"cz",u"Hradec Kralove",97427,50.207744,15.829455 ],
    [ u"cz",u"Hradek",2888,49.26142,13.495013 ],
    [ u"cz",u"Hranice",2254,50.303473,12.17667 ],
    [ u"cz",u"Hranice",19666,49.556306,17.735236 ],
    [ u"cz",u"Hrob",1979,50.656467,13.724949 ],
    [ u"cz",u"Hronov",6491,50.476002,16.182718 ],
    [ u"cz",u"Hrusovany nad Jevisovkou",3261,48.833333,16.4 ],
    [ u"cz",u"Hrusovany u Brna",2881,49.036583,16.591713 ],
    [ u"cz",u"Hukvaldy",1897,49.624767,18.22096 ],
    [ u"cz",u"Hulin",7576,49.314891,17.471896 ],
    [ u"cz",u"Humpolec",10915,49.541739,15.35586 ],
    [ u"cz",u"Hustopece",5858,48.941028,16.73353 ],
    [ u"cz",u"Ivancice",9314,49.101315,16.37623 ],
    [ u"cz",u"Ivanovice na Hane",2893,49.304928,17.093292 ],
    [ u"cz",u"Jablonec",45289,50.720474,15.171128 ],
    [ u"cz",u"Jablonec nad Jizerou",1967,50.704428,15.42863 ],
    [ u"cz",u"Jablonne nad Orlici",3106,50.030388,16.603926 ],
    [ u"cz",u"Jablonne v Podjestedi",3674,50.763952,14.761264 ],
    [ u"cz",u"Jablunka",1965,49.38369,17.950487 ],
    [ u"cz",u"Jablunkov",5911,49.574677,18.769523 ],
    [ u"cz",u"Jachymov",2816,50.365752,12.922539 ],
    [ u"cz",u"Janovice nad Uhlavou",2025,49.344417,13.217585 ],
    [ u"cz",u"Jaromerice nad Rokytnou",4089,49.095265,15.891582 ],
    [ u"cz",u"Jaromer",12911,50.349199,15.920442 ],
    [ u"cz",u"Javornik",2935,50.395669,17.01267 ],
    [ u"cz",u"Jedovnice",2477,49.344289,16.755841 ],
    [ u"cz",u"Jemnice",4289,49.017549,15.576795 ],
    [ u"cz",u"Jesenice",2551,49.969168,14.514608 ],
    [ u"cz",u"Jesenik",12693,50.229906,17.203426 ],
    [ u"cz",u"Jevicko",2817,49.632619,16.711918 ],
    [ u"cz",u"Jicin",16516,50.435841,15.355569 ],
    [ u"cz",u"Jihlava",50818,49.4,15.583333 ],
    [ u"cz",u"Jilemnice",5728,50.605466,15.50996 ],
    [ u"cz",u"Jilove",5233,50.751482,14.109192 ],
    [ u"cz",u"Jilove u Prahy",3427,49.898235,14.496985 ],
    [ u"cz",u"Jince",2296,49.788652,13.976619 ],
    [ u"cz",u"Jindrichuv Hradec",22646,49.144852,15.0025 ],
    [ u"cz",u"Jirikov",3901,50.993215,14.572155 ],
    [ u"cz",u"Jirkov",20648,50.5,13.45 ],
    [ u"cz",u"Jistebnice",2035,49.485539,14.527817 ],
    [ u"cz",u"Kadan",17559,50.384339,13.267338 ],
    [ u"cz",u"Kamenice",2901,49.901177,14.5812 ],
    [ u"cz",u"Kamenice nad Lipou",4202,49.302353,15.076126 ],
    [ u"cz",u"Kamenicky Senov",4055,50.773234,14.472826 ],
    [ u"cz",u"Kaplice",7087,48.739407,14.493856 ],
    [ u"cz",u"Kardasova Recice",2022,49.184224,14.853137 ],
    [ u"cz",u"Karlovy Vary",53585,50.237003,12.875042 ],
    [ u"cz",u"Karolinka",2881,49.351904,18.24642 ],
    [ u"cz",u"Karvina",65441,49.856792,18.546907 ],
    [ u"cz",u"Kaznejov",2986,49.893351,13.381569 ],
    [ u"cz",u"Kdyne",4879,49.392123,13.039451 ],
    [ u"cz",u"Kelc",2569,49.478455,17.819404 ],
    [ u"cz",u"Kladno",71262,50.142037,14.096549 ],
    [ u"cz",u"Klasterec nad Ohri",15724,50.388821,13.182397 ],
    [ u"cz",u"Klatovy",23059,49.39717,13.289064 ],
    [ u"cz",u"Klecany",2018,50.176478,14.412374 ],
    [ u"cz",u"Klimkovice",3755,49.788341,18.127265 ],
    [ u"cz",u"Koberice",3198,49.984879,18.056068 ],
    [ u"cz",u"Kobyli",2084,48.931754,16.888425 ],
    [ u"cz",u"Kojetin",6407,49.350476,17.302747 ],
    [ u"cz",u"Kolin",30351,50.026904,15.202311 ],
    [ u"cz",u"Komarov",2542,49.807361,13.858013 ],
    [ u"cz",u"Konice",3019,49.592494,16.888092 ],
    [ u"cz",u"Kopidlno",2195,50.333198,15.26877 ],
    [ u"cz",u"Koprivnice",23798,49.598453,18.145241 ],
    [ u"cz",u"Korycany",2827,49.109827,17.166496 ],
    [ u"cz",u"Kosmonosy",4005,50.436676,14.928258 ],
    [ u"cz",u"Kostelec nad Cernymi Lesy",3345,49.995688,14.861005 ],
    [ u"cz",u"Kostelec nad Labem",3029,50.226468,14.58672 ],
    [ u"cz",u"Kostelec nad Orlici",6153,50.123826,16.211445 ],
    [ u"cz",u"Kostelec na Hane",2713,49.514288,17.058101 ],
    [ u"cz",u"Kozlovice",2811,49.600238,18.257268 ],
    [ u"cz",u"Kraliky",4806,50.084047,16.759172 ],
    [ u"cz",u"Kralovice",3475,49.98058,13.485576 ],
    [ u"cz",u"Kralupy nad Vltavou",17493,50.239486,14.300742 ],
    [ u"cz",u"Kraluv Dvur",5509,49.947837,14.038397 ],
    [ u"cz",u"Kraslice",7236,50.327579,12.511121 ],
    [ u"cz",u"Krasna Lipa",3621,50.48378,13.357497 ],
    [ u"cz",u"Kravare",6667,49.932857,18.017489 ],
    [ u"cz",u"Kremze",2475,48.905005,14.309279 ],
    [ u"cz",u"Krnov",25769,50.089054,17.698012 ],
    [ u"cz",u"Kromeriz",29211,49.295955,17.395659 ],
    [ u"cz",u"Krupka",13281,50.681912,13.864749 ],
    [ u"cz",u"Kryry",2434,50.17508,13.42508 ],
    [ u"cz",u"Kuncice pod Ondrejnikem",1954,49.56047,18.255484 ],
    [ u"cz",u"Kunovice",5129,49.040529,17.466141 ],
    [ u"cz",u"Kunstat",2532,49.506871,16.521307 ],
    [ u"cz",u"Kurim",8896,49.302631,16.532675 ],
    [ u"cz",u"Kutna Hora",21474,49.95,15.266667 ],
    [ u"cz",u"Kvasice",2275,49.23974,17.471008 ],
    [ u"cz",u"Kynsperk nad Ohri",5134,50.11917,12.531531 ],
    [ u"cz",u"Lanskroun",9980,49.911432,16.612503 ],
    [ u"cz",u"Lanzhot",3756,48.723731,16.96522 ],
    [ u"cz",u"Lazne Belohrad",3780,50.428875,15.582745 ],
    [ u"cz",u"Lazne Bohdanec",3083,50.076389,15.682222 ],
    [ u"cz",u"Ledec",6101,49.696295,15.274891 ],
    [ u"cz",u"Ledenice",2135,48.933078,14.621598 ],
    [ u"cz",u"Lednice",2347,48.797895,16.803683 ],
    [ u"cz",u"Lesna",1951,49.519404,17.93131 ],
    [ u"cz",u"Letohrad",6257,50.035969,16.496683 ],
    [ u"cz",u"Letovice",6614,49.547591,16.576105 ],
    [ u"cz",u"Libcice nad Vltavou",3404,50.197949,14.354321 ],
    [ u"cz",u"Liberec",99416,50.763889,15.065278 ],
    [ u"cz",u"Libochovice",3659,50.4097,14.069006 ],
    [ u"cz",u"Libusin",2539,50.167322,14.054582 ],
    [ u"cz",u"Line",2230,49.69531,13.257388 ],
    [ u"cz",u"Lisov",3897,49.016476,14.6081 ],
    [ u"cz",u"Litomerice",24930,50.538408,14.130347 ],
    [ u"cz",u"Litomysl",10351,49.86898,16.313674 ],
    [ u"cz",u"Litovel",10026,49.706317,17.076908 ],
    [ u"cz",u"Litvinov",27424,50.601105,13.612673 ],
    [ u"cz",u"Loket",3186,50.185921,12.754252 ],
    [ u"cz",u"Lom",3603,50.59408,13.660254 ],
    [ u"cz",u"Lomnice nad Popelkou",6108,50.532459,15.370539 ],
    [ u"cz",u"Lostice",3051,49.745003,16.930656 ],
    [ u"cz",u"Loucna nad Desnou",1925,50.073687,17.091196 ],
    [ u"cz",u"Loucovice",1960,48.620897,14.249763 ],
    [ u"cz",u"Louny",19720,50.355707,13.809376 ],
    [ u"cz",u"Lovosice",9266,50.514231,14.052128 ],
    [ u"cz",u"Luby",2465,50.253328,12.404506 ],
    [ u"cz",u"Ludgerovice",4577,49.884296,18.249405 ],
    [ u"cz",u"Luhacovice",5596,49.097632,17.749896 ],
    [ u"cz",u"Luka nad Jihlavou",2470,49.375568,15.700632 ],
    [ u"cz",u"Lutin",3198,49.556673,17.139519 ],
    [ u"cz",u"Luze",2601,49.893878,16.029931 ],
    [ u"cz",u"Luzice",2731,48.83974,17.07035 ],
    [ u"cz",u"Lysa nad Labem",8461,50.201139,14.841773 ],
    [ u"cz",u"Marianske Lazne",14709,49.960197,12.700682 ],
    [ u"cz",u"Melnik",19318,50.361082,14.472342 ],
    [ u"cz",u"Merin",1901,49.391768,15.88687 ],
    [ u"cz",u"Mestec Kralove",3010,50.205726,15.296462 ],
    [ u"cz",u"Mesto Albrechtice",3612,50.16305,17.572759 ],
    [ u"cz",u"Mezibori",4945,50.621852,13.60102 ],
    [ u"cz",u"Mezimesti",2840,50.626582,16.242148 ],
    [ u"cz",u"Mikulasovice",2385,50.965381,14.364363 ],
    [ u"cz",u"Mikulcice",1899,48.817654,17.05 ],
    [ u"cz",u"Mikulovice",2771,50.300642,17.324338 ],
    [ u"cz",u"Mikulov",7653,48.806314,16.637074 ],
    [ u"cz",u"Milevsko",9436,49.451895,14.361574 ],
    [ u"cz",u"Milin",2107,49.633333,14.046329 ],
    [ u"cz",u"Milotice",1940,48.955224,17.142277 ],
    [ u"cz",u"Milovice",4342,50.228034,14.889739 ],
    [ u"cz",u"Mimon",6708,50.65575,14.729251 ],
    [ u"cz",u"Miroslav",2998,48.95,16.316667 ],
    [ u"cz",u"Mirosov",2228,49.690165,13.66891 ],
    [ u"cz",u"Mlada Boleslav",44417,50.42311,14.919316 ],
    [ u"cz",u"Mlada Vozice",2721,49.538113,14.813137 ],
    [ u"cz",u"Mlade Buky",2199,50.604513,15.84315 ],
    [ u"cz",u"Mnichovice",2204,49.936421,14.708604 ],
    [ u"cz",u"Mnichovo Hradiste",8652,50.522981,14.974758 ],
    [ u"cz",u"Mnisek pod Brdy",4208,49.865009,14.264299 ],
    [ u"cz",u"Modrice",3491,49.130176,16.611011 ],
    [ u"cz",u"Mohelnice",9808,49.777384,16.918452 ],
    [ u"cz",u"Moravska Nova Ves",2518,48.804341,17.012853 ],
    [ u"cz",u"Moravska Trebova",11564,49.755711,16.657149 ],
    [ u"cz",u"Moravske Budejovice",7970,49.052105,15.810128 ],
    [ u"cz",u"Moravsky Beroun",3418,49.796431,17.444735 ],
    [ u"cz",u"Moravsky Krumlov",6079,49.046745,16.30917 ],
    [ u"cz",u"Moravsky Pisek",2140,48.988068,17.329189 ],
    [ u"cz",u"Morkovice-Slizany",2799,49.247255,17.21128 ],
    [ u"cz",u"Morkov",2365,49.536277,18.06176 ],
    [ u"cz",u"Most",68254,50.509611,13.639121 ],
    [ u"cz",u"Mosty u Jablunkova",3981,49.534671,18.753926 ],
    [ u"cz",u"Mutenice",3655,48.902988,17.026664 ],
    [ u"cz",u"Nachod",21196,50.416667,16.166667 ],
    [ u"cz",u"Napajedla",7573,49.177848,17.517417 ],
    [ u"cz",u"Navsi",3750,49.589936,18.754532 ],
    [ u"cz",u"Nechanice",2186,50.237115,15.635234 ],
    [ u"cz",u"Nejdek",8556,50.32224,12.730727 ],
    [ u"cz",u"Nemcice nad Hanou",2102,49.342743,17.209161 ],
    [ u"cz",u"Nepomuk",3531,49.487615,13.583583 ],
    [ u"cz",u"Neratovice",16285,50.262281,14.508592 ],
    [ u"cz",u"Netolice",2606,49.050948,14.198223 ],
    [ u"cz",u"Neveklov",2432,49.751765,14.544805 ],
    [ u"cz",u"Nivnice",3221,48.97692,17.64596 ],
    [ u"cz",u"Nova Bystrice",3389,49.019462,15.104118 ],
    [ u"cz",u"Nova Paka",9259,50.489941,15.516498 ],
    [ u"cz",u"Nova Role",4027,50.271955,12.786849 ],
    [ u"cz",u"Nova Vcelnice",2463,49.239363,15.072403 ],
    [ u"cz",u"Nove Hrady",2588,48.790466,14.778111 ],
    [ u"cz",u"Nove Mesto nad Metuji",10074,50.354135,16.139448 ],
    [ u"cz",u"Nove Mesto na Morave",10459,49.562994,16.074353 ],
    [ u"cz",u"Nove Mesto pod Smrkem",4001,50.92634,15.22973 ],
    [ u"cz",u"Nove Sedlo",2626,50.210998,12.739372 ],
    [ u"cz",u"Nove Straseci",5210,50.153997,13.90082 ],
    [ u"cz",u"Novosedlice",2143,50.65795,13.822201 ],
    [ u"cz",u"Novy Bor",12325,50.757126,14.556747 ],
    [ u"cz",u"Novy Bydzov",7170,50.2411,15.491409 ],
    [ u"cz",u"Novy Hrozenkov",2738,49.339768,18.205008 ],
    [ u"cz",u"Novy Jicin",27043,49.598334,18.012384 ],
    [ u"cz",u"Novy Malin",2303,49.95,17.033333 ],
    [ u"cz",u"Nydek",1944,49.659767,18.763336 ],
    [ u"cz",u"Nymburk",14498,50.190375,15.03947 ],
    [ u"cz",u"Nyrany",6884,49.714397,13.207057 ],
    [ u"cz",u"Nyrsko",5088,49.292258,13.142736 ],
    [ u"cz",u"Obrnice",2610,50.503511,13.697048 ],
    [ u"cz",u"Odolena Voda",4478,50.232887,14.411094 ],
    [ u"cz",u"Odry",7415,49.666667,17.833333 ],
    [ u"cz",u"Okrisky",2014,49.24487,15.768936 ],
    [ u"cz",u"Olomouc",102792,49.59404,17.25119 ],
    [ u"cz",u"Olovi",1891,50.244662,12.55825 ],
    [ u"cz",u"Opatovice nad Labem",2171,50.151404,15.791597 ],
    [ u"cz",u"Opava",61514,49.93846,17.902628 ],
    [ u"cz",u"Opocno",3124,50.269932,16.110817 ],
    [ u"cz",u"Orechov",2344,49.11351,16.517417 ],
    [ u"cz",u"Orlova",34938,49.860351,18.444873 ],
    [ u"cz",u"Osek",5005,50.624513,13.694421 ],
    [ u"cz",u"Oslavany",4527,49.121758,16.338463 ],
    [ u"cz",u"Ostrava",317136,49.811852,18.255282 ],
    [ u"cz",u"Ostrov",17453,50.307349,12.94792 ],
    [ u"cz",u"Ostrozska Nova Ves",3333,49.004698,17.437016 ],
    [ u"cz",u"Otrokovice",19303,49.207366,17.523862 ],
    [ u"cz",u"Pacov",5210,49.471272,15.004092 ],
    [ u"cz",u"Palkovice",2590,49.628455,18.302271 ],
    [ u"cz",u"Pardubice",90853,50.027778,15.775833 ],
    [ u"cz",u"Paskov",3704,49.733452,18.290601 ],
    [ u"cz",u"Pecky",4386,50.090851,15.030752 ],
    [ u"cz",u"Pelhrimov",16590,49.428201,15.223368 ],
    [ u"cz",u"Peruc",2058,50.342619,13.960352 ],
    [ u"cz",u"Petrovice u Karvine",4499,49.898572,18.532976 ],
    [ u"cz",u"Petrvald",6785,49.828425,18.390542 ],
    [ u"cz",u"Pisek",29756,49.308408,14.149171 ],
    [ u"cz",u"Plana nad Luznici",3027,49.344926,14.713605 ],
    [ u"cz",u"Plana",5377,49.867527,12.74151 ],
    [ u"cz",u"Plasy",2610,49.931803,13.382054 ],
    [ u"cz",u"Plesna",1972,50.217447,12.349792 ],
    [ u"cz",u"Plumlov",2259,49.466667,17.016667 ],
    [ u"cz",u"Plzen",165531,49.75,13.366667 ],
    [ u"cz",u"Pocatky",2743,49.261044,15.238458 ],
    [ u"cz",u"Podborany",6082,50.226883,13.409585 ],
    [ u"cz",u"Podebrady",13445,50.147421,15.118661 ],
    [ u"cz",u"Podivin",2876,48.829387,16.849737 ],
    [ u"cz",u"Pohorelice",4345,48.983333,16.516667 ],
    [ u"cz",u"Polesovice",1980,49.033464,17.342672 ],
    [ u"cz",u"Police nad Metuji",4377,50.538067,16.234725 ],
    [ u"cz",u"Policka",9149,49.715579,16.268436 ],
    [ u"cz",u"Polna",4849,49.487442,15.716744 ],
    [ u"cz",u"Postoloprty",4812,50.359982,13.696013 ],
    [ u"cz",u"Postrelmov",3222,49.910957,16.916429 ],
    [ u"cz",u"Povrly",2099,50.673057,14.160202 ],
    [ u"cz",u"Pozorice",1968,49.210654,16.791883 ],
    [ u"cz",u"Prachatice",11825,49.014417,13.999526 ],
    [ u"cz",u"Prague",1154508,50.083333,14.466667 ],
    [ u"cz",u"Prelouc",9106,50.038042,15.560284 ],
    [ u"cz",u"Prerov",48513,49.453926,17.452379 ],
    [ u"cz",u"Prestice",6426,49.574825,13.328597 ],
    [ u"cz",u"Pribor",8720,49.640482,18.150476 ],
    [ u"cz",u"Pribram",35963,49.691355,14.020575 ],
    [ u"cz",u"Pribyslav",3965,49.57721,15.738639 ],
    [ u"cz",u"Probostov",2229,50.666667,13.833333 ],
    [ u"cz",u"Prosec",2089,49.807075,16.116531 ],
    [ u"cz",u"Prostejov",48258,49.47333,17.113455 ],
    [ u"cz",u"Protivin",4926,49.201066,14.214535 ],
    [ u"cz",u"Pruhonice",2008,50.001471,14.559534 ],
    [ u"cz",u"Prusanky",2087,48.828992,16.983727 ],
    [ u"cz",u"Rajec-Jestrebi",3548,49.416667,16.633333 ],
    [ u"cz",u"Rajhrad",2703,49.087673,16.604472 ],
    [ u"cz",u"Rakovnik",16725,50.10257,13.728775 ],
    [ u"cz",u"Rakvice",2066,48.856971,16.814168 ],
    [ u"cz",u"Rapotin",2887,49.983333,17.016667 ],
    [ u"cz",u"Raspenava",2835,50.899712,15.133397 ],
    [ u"cz",u"Ratiskovice",4032,48.918075,17.162063 ],
    [ u"cz",u"Revnice",3047,49.913114,14.240644 ],
    [ u"cz",u"Ricany",10928,49.992672,14.658531 ],
    [ u"cz",u"Rohatec",3358,48.933333,17.166667 ],
    [ u"cz",u"Rokycany",14295,49.74047,13.592556 ],
    [ u"cz",u"Rokytnice nad Jizerou",3373,50.72763,15.445253 ],
    [ u"cz",u"Rosice",5276,49.181825,16.393079 ],
    [ u"cz",u"Rotava",3431,50.297435,12.573072 ],
    [ u"cz",u"Roudnice",13114,50.421241,14.257235 ],
    [ u"cz",u"Rousinov",4903,49.82358,14.813137 ],
    [ u"cz",u"Rozmital pod Tremsinem",4491,49.607461,13.8706 ],
    [ u"cz",u"Roznov",17964,49.4606,18.136664 ],
    [ u"cz",u"Roztoky",5910,50.161771,14.392392 ],
    [ u"cz",u"Rtyne v Podkrkonosi",3040,50.506405,16.069229 ],
    [ u"cz",u"Ruda nad Moravou",2464,49.981072,16.877622 ],
    [ u"cz",u"Rudna",3170,50.032859,14.225905 ],
    [ u"cz",u"Rudnik",2178,50.608353,15.737229 ],
    [ u"cz",u"Rudolfov",2377,48.989583,14.542241 ],
    [ u"cz",u"Rumburk",11000,50.953564,14.553788 ],
    [ u"cz",u"Rychnov nad Kneznou",11721,50.166667,16.283333 ],
    [ u"cz",u"Rychvald",6743,49.868333,18.375828 ],
    [ u"cz",u"Sadska",3153,50.136909,14.985015 ],
    [ u"cz",u"Sardice",2189,48.963116,17.03136 ],
    [ u"cz",u"Sazava",3843,49.870565,14.895367 ],
    [ u"cz",u"Sedlcany",8088,49.65885,14.423418 ],
    [ u"cz",u"Semily",9247,50.602889,15.33768 ],
    [ u"cz",u"Senov",5385,49.790917,18.375858 ],
    [ u"cz",u"Sezemice",2995,50.066321,15.850651 ],
    [ u"cz",u"Sezimovo Usti",7455,49.377523,14.702868 ],
    [ u"cz",u"Sitborice",1940,49.014957,16.777808 ],
    [ u"cz",u"Skutec",5322,49.842468,15.994781 ],
    [ u"cz",u"Slany",15330,50.232504,14.074934 ],
    [ u"cz",u"Slapanice",6190,49.165352,16.725835 ],
    [ u"cz",u"Slatinany",3957,49.918333,15.815192 ],
    [ u"cz",u"Slavicin",7127,49.087973,17.879764 ],
    [ u"cz",u"Slavkov u Brna",5858,49.153157,16.879558 ],
    [ u"cz",u"Slavonice",2703,48.998229,15.350296 ],
    [ u"cz",u"Sluknov",5630,51.004656,14.453761 ],
    [ u"cz",u"Slusovice",2972,49.250592,17.79852 ],
    [ u"cz",u"Smirice",3131,50.300086,15.865792 ],
    [ u"cz",u"Smrzovka",3415,50.735331,15.244694 ],
    [ u"cz",u"Sobeslav",7252,49.259093,14.718653 ],
    [ u"cz",u"Sobotin",2502,50.016667,17.1 ],
    [ u"cz",u"Sobotka",2279,50.467115,15.175501 ],
    [ u"cz",u"Sokolov",25079,50.178428,12.647147 ],
    [ u"cz",u"Solnice",2076,50.203468,16.238854 ],
    [ u"cz",u"Spalene Porici",2501,49.612487,13.605553 ],
    [ u"cz",u"Stankov",3053,49.552243,13.06993 ],
    [ u"cz",u"Stara Paka",2015,50.510833,15.49 ],
    [ u"cz",u"Stara Ves nad Ondrejnici",2439,49.726075,18.19404 ],
    [ u"cz",u"Stare Mesto",2137,50.161224,16.946342 ],
    [ u"cz",u"Stare Mesto",6661,49.076493,17.437993 ],
    [ u"cz",u"Stary Jicin",2400,49.577494,17.961908 ],
    [ u"cz",u"Stary Plzenec",4225,49.694596,13.474666 ],
    [ u"cz",u"Stepankovice",3030,49.957387,18.03714 ],
    [ u"cz",u"Stepanov",3316,50.162384,16.917024 ],
    [ u"cz",u"Sternberk",14130,49.726551,17.292981 ],
    [ u"cz",u"Steti",9152,50.453141,14.378383 ],
    [ u"cz",u"Stity",2021,49.961908,16.763931 ],
    [ u"cz",u"Stochov",5563,50.139507,13.965953 ],
    [ u"cz",u"Stod",3429,49.639961,13.16422 ],
    [ u"cz",u"Strakonice",23863,49.260997,13.905073 ],
    [ u"cz",u"Stramberk",3395,49.590958,18.117846 ],
    [ u"cz",u"Strani",3831,48.905327,17.705316 ],
    [ u"cz",u"Strasice",2456,49.735474,13.757592 ],
    [ u"cz",u"Straznice",5960,48.898948,17.311932 ],
    [ u"cz",u"Straz pod Ralskem",4010,50.698886,14.794952 ],
    [ u"cz",u"Strelice",2527,49.15342,16.500263 ],
    [ u"cz",u"Stribro",7748,49.754845,12.995478 ],
    [ u"cz",u"Studena",2482,49.187082,15.28649 ],
    [ u"cz",u"Studenka",10503,49.719889,18.074529 ],
    [ u"cz",u"Suchdol nad Luznici",3628,48.89419,14.878038 ],
    [ u"cz",u"Sumperk",29604,49.965811,16.978874 ],
    [ u"cz",u"Susice",11452,49.237292,13.523972 ],
    [ u"cz",u"Svetla nad Sazavou",7158,49.667892,15.402449 ],
    [ u"cz",u"Svitavy",17625,49.755945,16.466791 ],
    [ u"cz",u"Svoboda nad Upou",2249,50.623117,15.817125 ],
    [ u"cz",u"Tabor",36546,49.411005,14.672771 ],
    [ u"cz",u"Tachov",12684,49.798116,12.635752 ],
    [ u"cz",u"Tanvald",6971,50.740333,15.274131 ],
    [ u"cz",u"Telc",6028,49.18228,15.458117 ],
    [ u"cz",u"Tepla",3085,49.979968,12.864322 ],
    [ u"cz",u"Teplice",50972,50.646569,13.840138 ],
    [ u"cz",u"Terezin",2916,50.510696,14.149776 ],
    [ u"cz",u"Terlicko",4110,49.752945,18.482957 ],
    [ u"cz",u"Tisnov",8279,49.347502,16.425956 ],
    [ u"cz",u"Tlucna",2307,49.724768,13.239043 ],
    [ u"cz",u"Tlumacov",2393,49.252762,17.500987 ],
    [ u"cz",u"Touzim",3779,50.055655,12.990823 ],
    [ u"cz",u"Tovacov",2656,49.430834,17.287735 ],
    [ u"cz",u"Trebechovice pod Orebem",5406,50.201595,15.988212 ],
    [ u"cz",u"Trebic",39038,49.210649,15.881458 ],
    [ u"cz",u"Trebon",8968,49.005636,14.763256 ],
    [ u"cz",u"Tremosna",4605,49.82666,13.391741 ],
    [ u"cz",u"Tremosnice",3390,49.870259,15.577777 ],
    [ u"cz",u"Trhove Sviny",4596,48.841687,14.638371 ],
    [ u"cz",u"Trinec",39054,49.680358,18.665348 ],
    [ u"cz",u"Trmice",2678,50.642224,14.001877 ],
    [ u"cz",u"Trojanovice",2054,49.515596,18.233463 ],
    [ u"cz",u"Troubky",1980,49.429764,17.347977 ],
    [ u"cz",u"Trutnov",32085,50.565612,15.914355 ],
    [ u"cz",u"Tuchlovice",2211,50.136983,13.990812 ],
    [ u"cz",u"Turnov",14500,50.592134,15.164575 ],
    [ u"cz",u"Tvrdonice",2059,48.76088,16.992502 ],
    [ u"cz",u"Tynec nad Sazavou",5374,49.827817,14.598529 ],
    [ u"cz",u"Tyniste nad Orlici",6259,50.152992,16.076118 ],
    [ u"cz",u"Tyn nad Vltavou",8100,49.225516,14.418562 ],
    [ u"cz",u"Uherske Hradiste",26954,49.066667,17.463943 ],
    [ u"cz",u"Uhersky Brod",17625,49.025539,17.646646 ],
    [ u"cz",u"Uhersky Ostroh",4499,48.98866,17.394875 ],
    [ u"cz",u"Uhlirske Janovice",3172,49.881494,15.064461 ],
    [ u"cz",u"Unicov",12474,49.772259,17.122268 ],
    [ u"cz",u"Upice",5906,50.512965,16.016914 ],
    [ u"cz",u"Ustek",2649,50.58494,14.345113 ],
    [ u"cz",u"Usti nad Orlici",15194,49.975283,16.397151 ],
    [ u"cz",u"Usti",95556,50.666667,14.033333 ],
    [ u"cz",u"Uvaly",4834,50.073111,14.725905 ],
    [ u"cz",u"Vacenovice",2075,48.948027,17.174783 ],
    [ u"cz",u"Valasska Bystrice",2172,49.414654,18.109637 ],
    [ u"cz",u"Valasske Klobouky",5168,49.143456,18.01618 ],
    [ u"cz",u"Valasske Mezirici",27562,49.473211,17.972378 ],
    [ u"cz",u"Valtice",3616,48.741812,16.757793 ],
    [ u"cz",u"Vamberk",4794,50.117637,16.293932 ],
    [ u"cz",u"Varnsdorf",16018,50.915389,14.617839 ],
    [ u"cz",u"Vejprnice",2509,49.73007,13.277113 ],
    [ u"cz",u"Vejprty",3320,50.49575,13.033892 ],
    [ u"cz",u"Velesin",4006,48.83049,14.463114 ],
    [ u"cz",u"Velim",2046,50.061389,15.101479 ],
    [ u"cz",u"Velka Bites",4868,49.28905,16.227124 ],
    [ u"cz",u"Velka Bystrice",2857,49.594408,17.360232 ],
    [ u"cz",u"Velka nad Velickou",3216,48.883333,17.533333 ],
    [ u"cz",u"Velke Bilovice",3785,48.849474,16.89145 ],
    [ u"cz",u"Velke Hamry",2709,50.717417,15.296648 ],
    [ u"cz",u"Velke Karlovice",2664,49.36405,18.3069 ],
    [ u"cz",u"Velke Losiny",2878,50.043327,17.053093 ],
    [ u"cz",u"Velke Mezirici",11795,49.355442,16.01449 ],
    [ u"cz",u"Velke Opatovice",4176,49.613217,16.676185 ],
    [ u"cz",u"Velke Pavlovice",3089,48.902269,16.814891 ],
    [ u"cz",u"Velke Porici",2272,50.458755,16.192494 ],
    [ u"cz",u"Velky Osek",2188,50.100358,15.192194 ],
    [ u"cz",u"Velky Senov",2004,50.992377,14.382757 ],
    [ u"cz",u"Velky Tynec",2114,49.551547,17.335117 ],
    [ u"cz",u"Velvary",3001,50.281733,14.24153 ],
    [ u"cz",u"Vendryne",3827,49.655127,18.699643 ],
    [ u"cz",u"Verovice",1934,49.538936,18.119879 ],
    [ u"cz",u"Veseli nad Luznici",6606,49.184951,14.698235 ],
    [ u"cz",u"Veseli nad Moravou",12245,48.950888,17.382144 ],
    [ u"cz",u"Vetrni",3756,48.77493,14.287545 ],
    [ u"cz",u"Veverska Bityska",2779,49.275743,16.436621 ],
    [ u"cz",u"Vikyrovice",2014,49.983333,17.016667 ],
    [ u"cz",u"Vimperk",8237,49.056271,13.785015 ],
    [ u"cz",u"Vitkov",6312,49.775114,17.752379 ],
    [ u"cz",u"Vizovice",4481,49.221403,17.853332 ],
    [ u"cz",u"Vlasim",12350,49.703603,14.899412 ],
    [ u"cz",u"Vlcnov",3016,49.580239,17.952866 ],
    [ u"cz",u"Vnorovy",3065,48.929189,17.350493 ],
    [ u"cz",u"Vodnany",6546,49.147394,14.170186 ],
    [ u"cz",u"Volary",4047,48.91039,13.889017 ],
    [ u"cz",u"Volyne",3177,50.448742,13.211491 ],
    [ u"cz",u"Votice",4599,49.639484,14.640219 ],
    [ u"cz",u"Vracov",4514,48.974388,17.21088 ],
    [ u"cz",u"Vranovice",1918,48.966667,16.6 ],
    [ u"cz",u"Vratimov",6431,49.768571,18.315002 ],
    [ u"cz",u"Vrbno pod Pradedem",6220,50.121807,17.379478 ],
    [ u"cz",u"Vrchlabi",13155,50.624091,15.61315 ],
    [ u"cz",u"Vrdy",3049,49.920754,15.471089 ],
    [ u"cz",u"Vresina",2328,49.946431,18.191672 ],
    [ u"cz",u"Vsetaty",2001,50.28187,14.592122 ],
    [ u"cz",u"Vsetin",29302,49.341899,17.983582 ],
    [ u"cz",u"Vyskov",22549,49.278302,17.002565 ],
    [ u"cz",u"Vysoke Myto",12173,49.953254,16.154723 ],
    [ u"cz",u"Vyssi Brod",2547,48.617733,14.31264 ],
    [ u"cz",u"Zabreh",14574,49.884404,16.873092 ],
    [ u"cz",u"Zacler",3617,50.65811,15.908241 ],
    [ u"cz",u"Zakupy",2582,50.68491,14.646469 ],
    [ u"cz",u"Zamberk",6128,50.086091,16.463802 ],
    [ u"cz",u"Zasova",2738,49.476432,18.044408 ],
    [ u"cz",u"Zastavka",2350,49.2,16.366667 ],
    [ u"cz",u"Zatec",19961,50.326309,13.544673 ],
    [ u"cz",u"Zbiroh",2582,49.8565,13.769114 ],
    [ u"cz",u"Zbysov",3925,49.130834,16.806276 ],
    [ u"cz",u"Zdanice",2731,49.067259,17.0284 ],
    [ u"cz",u"Zdice",3936,49.914201,13.976926 ],
    [ u"cz",u"Zdounky",2018,49.229255,17.314168 ],
    [ u"cz",u"Zelezna Ruda",2009,49.137768,13.232492 ],
    [ u"cz",u"Zelezny Brod",6516,50.645106,15.255259 ],
    [ u"cz",u"Zidlochovice",3075,49.038068,16.614826 ],
    [ u"cz",u"Zirovnice",3043,49.252133,15.188454 ],
    [ u"cz",u"Zlate Hory",4489,50.260746,17.395136 ],
    [ u"cz",u"Zlin",81066,49.216667,17.666667 ],
    [ u"cz",u"Zliv",3679,49.066667,14.366667 ],
    [ u"cz",u"Zlonice",2261,50.286003,14.091592 ],
    [ u"cz",u"Zlutice",2854,50.090704,13.162844 ],
    [ u"cz",u"Znojmo",35791,48.856116,16.056412 ],
    [ u"cz",u"Zruc nad Sazavou",5175,49.744364,15.103751 ],
    [ u"de",u"Aachen",251104,50.770833,6.105278 ],
    [ u"de",u"Aalen",67593,48.833333,10.1 ],
    [ u"de",u"Abensberg",12543,48.816667,11.85 ],
    [ u"de",u"Achern",24272,48.633333,8.066667 ],
    [ u"de",u"Achim",30117,53.033333,9.016667 ],
    [ u"de",u"Adendorf",9917,53.283333,10.45 ],
    [ u"de",u"Aerzen",12114,52.033333,9.266667 ],
    [ u"de",u"Ahaus",38932,52.066667,7 ],
    [ u"de",u"Ahlen",55112,51.75,7.916667 ],
    [ u"de",u"Ahrensburg",30797,53.683333,10.25 ],
    [ u"de",u"Aichach",20935,48.466667,11.133333 ],
    [ u"de",u"Ainring",9852,47.816667,12.95 ],
    [ u"de",u"Aken",9350,51.85,12.05 ],
    [ u"de",u"Albstadt",47064,48.25,9.016667 ],
    [ u"de",u"Aldenhoven",14335,50.9,6.283333 ],
    [ u"de",u"Alfeld",21258,51.983333,9.833333 ],
    [ u"de",u"Alfter",22028,50.733333,7.016667 ],
    [ u"de",u"Alpen",12970,51.583333,6.516667 ],
    [ u"de",u"Alsdorf",46558,50.883333,6.166667 ],
    [ u"de",u"Alsfeld",17968,50.75,9.266667 ],
    [ u"de",u"Altdorf",11709,48.15,12.183333 ],
    [ u"de",u"Altena",20641,51.3,7.666667 ],
    [ u"de",u"Altenburg",38338,50.983333,12.45 ],
    [ u"de",u"Altenholz",9721,54.4,10.133333 ],
    [ u"de",u"Altenstadt",12388,50.283333,8.95 ],
    [ u"de",u"Altensteig",11122,48.583333,8.6 ],
    [ u"de",u"Altötting",12998,48.233333,12.683333 ],
    [ u"de",u"Altusried",10084,47.8,10.216667 ],
    [ u"de",u"Alzenau",19083,50.083333,9.066667 ],
    [ u"de",u"Alzey",17945,49.751667,8.116111 ],
    [ u"de",u"Amberg",44873,49.441389,11.862222 ],
    [ u"de",u"Andernach",29089,50.433333,7.4 ],
    [ u"de",u"Angermünde",18200,53.033333,14 ],
    [ u"de",u"Anklam",14533,53.866667,13.7 ],
    [ u"de",u"Annaberg-Buchholz",22849,50.566667,13 ],
    [ u"de",u"Anröchte",10981,51.566667,8.333333 ],
    [ u"de",u"Ansbach",40822,49.3,10.583333 ],
    [ u"de",u"Apen",11093,53.216667,7.8 ],
    [ u"de",u"Apolda",24380,51.016667,11.5 ],
    [ u"de",u"Arnsberg",77415,51.383333,8.083333 ],
    [ u"de",u"Arnstadt",25995,50.833333,10.95 ],
    [ u"de",u"Aschaffenburg",69248,49.973889,9.149167 ],
    [ u"de",u"Ascheberg",15327,51.783333,7.616667 ],
    [ u"de",u"Aschersleben",24569,51.75,11.466667 ],
    [ u"de",u"Asperg",12627,48.9,9.116667 ],
    [ u"de",u"Attendorn",25014,51.116667,7.9 ],
    [ u"de",u"Aue",18630,50.583333,12.7 ],
    [ u"de",u"Auerbach",25430,50.516667,12.4 ],
    [ u"de",u"Augsburg",261842,48.366667,10.883333 ],
    [ u"de",u"Augustdorf",10275,51.9,8.733333 ],
    [ u"de",u"Aurich",40987,53.466667,7.483333 ],
    [ u"de",u"Babenhausen",16551,49.966667,8.957778 ],
    [ u"de",u"Backnang",36477,48.95,9.433333 ],
    [ u"de",u"Bad Aibling",17926,47.866667,12 ],
    [ u"de",u"Bad Bentheim",15436,52.316667,7.166667 ],
    [ u"de",u"Bad Berleburg",20830,51.05,8.4 ],
    [ u"de",u"Bad Bevensen",8808,53.083333,10.583333 ],
    [ u"de",u"Bad Bramstedt",13303,53.916667,9.883333 ],
    [ u"de",u"Bad Camberg",13920,50.3,8.266667 ],
    [ u"de",u"Bad Doberan",11373,54.1,11.9 ],
    [ u"de",u"Bad Driburg",19743,51.733333,9.016667 ],
    [ u"de",u"Bad Dürkheim",18751,49.468611,8.166389 ],
    [ u"de",u"Bad Dürrenberg",11587,51.3,12.066667 ],
    [ u"de",u"Bad Dürrheim",12668,48.016667,8.533333 ],
    [ u"de",u"Bad Ems",9468,50.333333,7.716667 ],
    [ u"de",u"Baden-Baden",54802,48.75,8.25 ],
    [ u"de",u"Bad Essen",15858,52.316667,8.333333 ],
    [ u"de",u"Bad Frankenhausen",9102,51.35,11.1 ],
    [ u"de",u"Bad Freienwalde",15108,52.783333,14.033333 ],
    [ u"de",u"Bad Gandersheim",11100,51.866667,10.033333 ],
    [ u"de",u"Bad Harzburg",22670,51.883333,10.566667 ],
    [ u"de",u"Bad Hersfeld",30630,50.866667,9.7 ],
    [ u"de",u"Bad Homburg",51923,50.216667,8.616667 ],
    [ u"de",u"Bad Iburg",11790,52.15,8.05 ],
    [ u"de",u"Bad Kissingen",21527,50.2,10.083333 ],
    [ u"de",u"Bad Kreuznach",43317,49.833333,7.866667 ],
    [ u"de",u"Bad Krozingen",16051,47.916272,7.700622 ],
    [ u"de",u"Bad Laasphe",15268,50.933333,8.4 ],
    [ u"de",u"Bad Laer",9514,52.1,8.083333 ],
    [ u"de",u"Bad Langensalza",20144,51.1,10.65 ],
    [ u"de",u"Bad Lauterberg",11813,51.65,10.466667 ],
    [ u"de",u"Bad Liebenwerda",10880,51.516667,13.4 ],
    [ u"de",u"Bad Liebenzell",9665,48.766667,8.733333 ],
    [ u"de",u"Bad Lippspringe",15054,51.783333,8.816667 ],
    [ u"de",u"Bad Mergentheim",22072,49.4925,9.773611 ],
    [ u"de",u"Bad Münder",18692,52.2,9.466667 ],
    [ u"de",u"Bad Münstereifel",19166,50.55,6.766667 ],
    [ u"de",u"Bad Nauheim",30369,50.366667,8.75 ],
    [ u"de",u"Bad Nenndorf",10323,52.333333,9.366667 ],
    [ u"de",u"Bad Neuenahr-Ahrweiler",27972,50.55,7.1 ],
    [ u"de",u"Bad Neustadt",16268,50.333333,10.216667 ],
    [ u"de",u"Bad Oeynhausen",49698,52.2,8.8 ],
    [ u"de",u"Bad Oldesloe",23982,53.816667,10.383333 ],
    [ u"de",u"Bad Orb",10051,50.216667,9.35 ],
    [ u"de",u"Bad Pyrmont",21741,51.983333,9.25 ],
    [ u"de",u"Bad Rappenau",20868,49.240556,9.1025 ],
    [ u"de",u"Bad Reichenhall",16823,47.733333,12.883333 ],
    [ u"de",u"Bad Sachsa",8245,51.6,10.55 ],
    [ u"de",u"Bad Säckingen",16483,47.55,7.95 ],
    [ u"de",u"Bad Salzdetfurth",14590,52.05,10 ],
    [ u"de",u"Bad Salzuflen",55348,52.083333,8.766667 ],
    [ u"de",u"Bad Salzungen",16610,50.816667,10.233333 ],
    [ u"de",u"Bad Sassendorf",11552,51.583333,8.166667 ],
    [ u"de",u"Bad Schwalbach",11259,50.133333,8.066667 ],
    [ u"de",u"Bad Schwartau",20052,53.916667,10.7 ],
    [ u"de",u"Bad Segeberg",16097,53.933333,10.316667 ],
    [ u"de",u"Bad Soden",21418,50.133333,8.5 ],
    [ u"de",u"Bad Soden-Salmünster",13960,50.283333,9.366667 ],
    [ u"de",u"Bad Sooden-Allendorf",8955,51.283333,9.983333 ],
    [ u"de",u"Bad Tölz",17378,47.766667,11.566667 ],
    [ u"de",u"Bad Urach",13007,48.5,9.4 ],
    [ u"de",u"Bad Vilbel",30933,50.183333,8.75 ],
    [ u"de",u"Bad Waldsee",19749,47.916667,9.766667 ],
    [ u"de",u"Bad Wildbad",11411,48.75,8.55 ],
    [ u"de",u"Bad Wildungen",18078,51.116667,9.116667 ],
    [ u"de",u"Bad Windsheim",12033,49.5,10.416667 ],
    [ u"de",u"Bad Wörishofen",13922,48.016667,10.6 ],
    [ u"de",u"Bad Wurzach",14288,47.9,9.9 ],
    [ u"de",u"Bad Zwischenahn",26641,53.183333,8 ],
    [ u"de",u"Baesweiler",27865,50.9,6.183333 ],
    [ u"de",u"Baiersbronn",16156,48.5,8.383333 ],
    [ u"de",u"Balingen",34680,48.283333,8.85 ],
    [ u"de",u"Balve",12288,51.333333,7.866667 ],
    [ u"de",u"Bamberg",70471,49.866667,10.866667 ],
    [ u"de",u"Bargteheide",14123,53.733333,10.266667 ],
    [ u"de",u"Barmstedt",9558,53.783333,9.766667 ],
    [ u"de",u"Barntrup",9666,51.983333,9.116667 ],
    [ u"de",u"Barsbüttel",12395,53.566667,10.166667 ],
    [ u"de",u"Barsinghausen",34322,52.3,9.45 ],
    [ u"de",u"Barth",9344,54.366667,12.733333 ],
    [ u"de",u"Bassum",16204,52.85,8.733333 ],
    [ u"de",u"Baunatal",28338,51.25,9.416667 ],
    [ u"de",u"Bautzen",41606,51.183333,14.433333 ],
    [ u"de",u"Bayreuth",74840,49.948056,11.578333 ],
    [ u"de",u"Bebra",14798,50.966667,9.8 ],
    [ u"de",u"Beckingen",15959,49.4,6.7 ],
    [ u"de",u"Beckum",37914,51.75,8.033333 ],
    [ u"de",u"Bedburg",25224,51,6.583333 ],
    [ u"de",u"Beeskow",8547,52.166667,14.25 ],
    [ u"de",u"Belm",14073,52.3,8.133333 ],
    [ u"de",u"Bendorf",17224,50.433333,7.566667 ],
    [ u"de",u"Bensheim",39450,49.680278,8.616111 ],
    [ u"de",u"Bergen",13586,52.816667,9.966667 ],
    [ u"de",u"Bergen",14621,54.416667,13.433333 ],
    [ u"de",u"Bergheim",64082,50.966667,6.65 ],
    [ u"de",u"Bergisch Gladbach",106611,50.983333,7.133333 ],
    [ u"de",u"Bergkamen",52670,51.633333,7.633333 ],
    [ u"de",u"Bergneustadt",20865,51.033333,7.65 ],
    [ u"de",u"Berlin",3398362,52.516667,13.4 ],
    [ u"de",u"Bernau",33481,52.666667,13.583333 ],
    [ u"de",u"Bernburg",32859,51.8,11.733333 ],
    [ u"de",u"Besigheim",11667,48.983333,9.133333 ],
    [ u"de",u"Bestwig",11819,51.366667,8.4 ],
    [ u"de",u"Betzdorf",10615,50.783333,7.883333 ],
    [ u"de",u"Beverungen",15230,51.666667,9.366667 ],
    [ u"de",u"Bexbach",19372,49.333333,7.266667 ],
    [ u"de",u"Biberach",32501,48.1,9.8 ],
    [ u"de",u"Biblis",8824,49.691667,8.458611 ],
    [ u"de",u"Biedenkopf",13736,50.916667,8.533333 ],
    [ u"de",u"Bielefeld",327198,52.033333,8.533333 ],
    [ u"de",u"Bietigheim-Bissingen",41979,48.966667,9.133333 ],
    [ u"de",u"Billerbeck",11578,51.966667,7.3 ],
    [ u"de",u"Bingen",24844,49.966667,7.9 ],
    [ u"de",u"Birkenau",10406,49.5625,8.706944 ],
    [ u"de",u"Birkenfeld",10444,48.866667,8.633333 ],
    [ u"de",u"Bischofsheim",12114,49.993889,8.367222 ],
    [ u"de",u"Bischofswerda",13577,51.116667,14.183333 ],
    [ u"de",u"Bissendorf",14431,52.233333,8.166667 ],
    [ u"de",u"Bitburg",13154,49.966667,6.533333 ],
    [ u"de",u"Bitterfeld",15486,51.616667,12.316667 ],
    [ u"de",u"Blankenburg",15887,51.783333,10.95 ],
    [ u"de",u"Blaubeuren",11900,48.4,9.783333 ],
    [ u"de",u"Blieskastel",22938,49.233333,7.25 ],
    [ u"de",u"Blomberg",17295,51.933333,9.083333 ],
    [ u"de",u"Blumberg",10666,47.833333,8.533333 ],
    [ u"de",u"Bobenheim-Roxheim",10129,49.5875,8.357778 ],
    [ u"de",u"Bobingen",16595,48.266667,10.833333 ],
    [ u"de",u"Böblingen",46830,48.683333,9.016667 ],
    [ u"de",u"Bocholt",73872,51.833333,6.6 ],
    [ u"de",u"Bochum",387061,51.483333,7.216667 ],
    [ u"de",u"Bockenem",11328,52.016667,10.133333 ],
    [ u"de",u"Bogen",10458,48.916667,12.683333 ],
    [ u"de",u"Böhl-Iggelheim",10694,49.380556,8.303889 ],
    [ u"de",u"Bohmte",13432,52.366667,8.316667 ],
    [ u"de",u"Boizenburg",10634,53.383333,10.716667 ],
    [ u"de",u"Bönen",18950,51.6,7.766667 ],
    [ u"de",u"Bonn",314081,50.733333,7.1 ],
    [ u"de",u"Bopfingen",12669,48.85,10.35 ],
    [ u"de",u"Boppard",16606,50.233333,7.6 ],
    [ u"de",u"Borgentreich",9813,51.566667,9.25 ],
    [ u"de",u"Borken",13656,51.05,9.283333 ],
    [ u"de",u"Borken",41179,51.85,6.866667 ],
    [ u"de",u"Borna",18504,51.116667,12.5 ],
    [ u"de",u"Bornheim",49126,50.766667,7 ],
    [ u"de",u"Bottrop",120829,51.516667,6.916667 ],
    [ u"de",u"Bovenden",13376,51.583333,9.933333 ],
    [ u"de",u"Brackenheim",15031,49.079722,9.065 ],
    [ u"de",u"Brake",16199,53.333333,8.483333 ],
    [ u"de",u"Brakel",17782,51.716667,9.183333 ],
    [ u"de",u"Bramsche",28773,52.4,7.983333 ],
    [ u"de",u"Brandenburg",75507,52.416667,12.55 ],
    [ u"de",u"Brand-Erbisdorf",12098,50.866667,13.333333 ],
    [ u"de",u"Braunfels",11398,50.516667,8.4 ],
    [ u"de",u"Breisach",14083,48.032791,7.582937 ],
    [ u"de",u"Bremen",546429,53.083333,8.8 ],
    [ u"de",u"Bremerhaven",119688,53.55,8.583333 ],
    [ u"de",u"Bremervörde",18983,53.483333,9.133333 ],
    [ u"de",u"Bretten",28774,49.039167,8.702778 ],
    [ u"de",u"Bretzfeld",12223,49.179444,9.438333 ],
    [ u"de",u"Brilon",27186,51.4,8.583333 ],
    [ u"de",u"Bruchköbel",20820,50.183333,8.916667 ],
    [ u"de",u"Bruchsal",43615,49.128056,8.583611 ],
    [ u"de",u"Bruckmühl",16178,47.883333,11.916667 ],
    [ u"de",u"Brüggen",16224,51.25,6.183333 ],
    [ u"de",u"Brühl",14344,49.397222,8.533611 ],
    [ u"de",u"Brühl",44588,50.833333,6.9 ],
    [ u"de",u"Brunsbüttel",13840,53.9,9.15 ],
    [ u"de",u"Brunswick",245259,52.266667,10.533333 ],
    [ u"de",u"Buchen",19276,49.523889,9.323056 ],
    [ u"de",u"Buchloe",11997,48.033333,10.733333 ],
    [ u"de",u"Bückeburg",21077,52.266667,9.05 ],
    [ u"de",u"Büdelsdorf",10060,54.316667,9.683333 ],
    [ u"de",u"Büdingen",22157,50.3,9.116667 ],
    [ u"de",u"Bühl",29434,48.7,8.15 ],
    [ u"de",u"Bünde",45389,52.2,8.583333 ],
    [ u"de",u"Burbach",14984,50.75,8.083333 ],
    [ u"de",u"Büren",22703,51.55,8.566667 ],
    [ u"de",u"Burg",28602,52.266667,11.85 ],
    [ u"de",u"Burgdorf",30288,52.45,10.016667 ],
    [ u"de",u"Burghausen",18376,48.166667,12.833333 ],
    [ u"de",u"Burgkirchen",10795,48.166667,12.733333 ],
    [ u"de",u"Burglengenfeld",12098,49.205556,12.041389 ],
    [ u"de",u"Burgstädt",12506,50.916667,12.816667 ],
    [ u"de",u"Burgthann",11615,49.35,11.3 ],
    [ u"de",u"Burladingen",13249,48.283333,9.116667 ],
    [ u"de",u"Burscheid",19579,51.1,7.116667 ],
    [ u"de",u"Bürstadt",15365,49.643611,8.46 ],
    [ u"de",u"Büttelborn",13326,49.903333,8.523333 ],
    [ u"de",u"Butzbach",25804,50.433333,8.683333 ],
    [ u"de",u"Bützow",8163,53.85,11.983333 ],
    [ u"de",u"Buxtehude",38236,53.45,9.7 ],
    [ u"de",u"Cadolzburg",10188,49.45,10.866667 ],
    [ u"de",u"Calbe",11666,51.9,11.766667 ],
    [ u"de",u"Calw",24220,48.716667,8.733333 ],
    [ u"de",u"Castrop-Rauxel",78587,51.55,7.316667 ],
    [ u"de",u"Celle",71106,52.616667,10.083333 ],
    [ u"de",u"Cham",17393,49.225556,12.663611 ],
    [ u"de",u"Chemnitz",246654,50.833333,12.916667 ],
    [ u"de",u"Clausthal-Zellerfeld",15082,51.8,10.333333 ],
    [ u"de",u"Cleves",49448,51.783333,6.15 ],
    [ u"de",u"Cloppenburg",31030,52.85,8.033333 ],
    [ u"de",u"Coburg",42413,50.25,10.966667 ],
    [ u"de",u"Coesfeld",36929,51.933333,7.15 ],
    [ u"de",u"Cologne",968823,50.933333,6.95 ],
    [ u"de",u"Coswig",21965,51.133333,13.583333 ],
    [ u"de",u"Coswig",8729,51.883333,12.45 ],
    [ u"de",u"Cottbus",115246,51.766667,14.333333 ],
    [ u"de",u"Crailsheim",32666,49.15,10.083333 ],
    [ u"de",u"Cremlingen",12811,52.25,10.65 ],
    [ u"de",u"Crimmitschau",22410,50.816667,12.383333 ],
    [ u"de",u"Cuxhaven",52873,53.883333,8.7 ],
    [ u"de",u"Dachau",39815,48.266667,11.433333 ],
    [ u"de",u"Damme",16236,52.516667,8.2 ],
    [ u"de",u"Dannenberg",8612,53.1,11.1 ],
    [ u"de",u"Darmstadt",139757,49.870556,8.649444 ],
    [ u"de",u"Dassel",11319,51.8,9.683333 ],
    [ u"de",u"Datteln",37130,51.666667,7.383333 ],
    [ u"de",u"Deggendorf",31146,48.833333,12.966667 ],
    [ u"de",u"Delbrück",30699,51.766667,8.566667 ],
    [ u"de",u"Delitzsch",25160,51.533333,12.35 ],
    [ u"de",u"Delmenhorst",75740,53.05,8.616667 ],
    [ u"de",u"Demmin",12263,53.9,13.033333 ],
    [ u"de",u"Denkendorf",10096,48.683333,9.316667 ],
    [ u"de",u"Denzlingen",13388,48.066667,7.883333 ],
    [ u"de",u"Dessau",76628,51.833333,12.25 ],
    [ u"de",u"Detmold",74853,51.933333,8.883333 ],
    [ u"de",u"Dettingen",9282,48.533333,9.35 ],
    [ u"de",u"Dieburg",15452,49.898889,8.844444 ],
    [ u"de",u"Diedorf",10348,48.35,10.766667 ],
    [ u"de",u"Diepholz",16874,52.6,8.366667 ],
    [ u"de",u"Dietzenbach",32975,50.016667,8.783333 ],
    [ u"de",u"Diez",11065,50.366667,8.016667 ],
    [ u"de",u"Dillenburg",24772,50.733333,8.283333 ],
    [ u"de",u"Dillingen",19013,48.566667,10.483333 ],
    [ u"de",u"Dillingen",21451,49.35,6.733333 ],
    [ u"de",u"Dingolfing",18733,48.633333,12.5 ],
    [ u"de",u"Dinkelsbühl",11581,49.066667,10.316667 ],
    [ u"de",u"Dinklage",12802,52.65,8.116667 ],
    [ u"de",u"Dinslaken",71632,51.566667,6.733333 ],
    [ u"de",u"Ditzingen",24255,48.833333,9.066667 ],
    [ u"de",u"Döbeln",21318,51.116667,13.116667 ],
    [ u"de",u"Donaueschingen",21699,47.95,8.5 ],
    [ u"de",u"Donauwörth",18550,48.7,10.8 ],
    [ u"de",u"Donzdorf",11038,48.683333,9.816667 ],
    [ u"de",u"Dorfen",13425,48.266667,12.15 ],
    [ u"de",u"Dormagen",64129,51.1,6.833333 ],
    [ u"de",u"Dornstadt",8374,48.466667,9.95 ],
    [ u"de",u"Dorsten",80180,51.666667,6.966667 ],
    [ u"de",u"Dortmund",594255,51.516667,7.45 ],
    [ u"de",u"Dörverden",9805,52.85,9.233333 ],
    [ u"de",u"Dossenheim",11794,49.450278,8.674722 ],
    [ u"de",u"Dreieich",41054,50,8.7 ],
    [ u"de",u"Drensteinfurt",15234,51.8,7.75 ],
    [ u"de",u"Dresden",480801,51.05,13.75 ],
    [ u"de",u"Drochtersen",12404,53.7,9.383333 ],
    [ u"de",u"Drolshagen",12438,51.016667,7.766667 ],
    [ u"de",u"Duderstadt",22842,51.516667,10.266667 ],
    [ u"de",u"Duisburg",505271,51.433333,6.75 ],
    [ u"de",u"Dülmen",47899,51.833333,7.3 ],
    [ u"de",u"Düren",92956,50.8,6.483333 ],
    [ u"de",u"Durmersheim",11742,48.933333,8.266667 ],
    [ u"de",u"Düsseldorf",577139,51.216667,6.766667 ],
    [ u"de",u"Eberbach",15526,49.469444,8.992778 ],
    [ u"de",u"Ebersbach",16143,48.716667,9.533333 ],
    [ u"de",u"Ebersbach",9056,51.016667,14.583333 ],
    [ u"de",u"Ebersberg",11082,48.083333,11.966667 ],
    [ u"de",u"Eberswalde",41384,52.833333,13.833333 ],
    [ u"de",u"Eching",13247,48.3,11.616667 ],
    [ u"de",u"Eckernförde",23184,54.466667,9.833333 ],
    [ u"de",u"Edemissen",12838,52.383333,10.266667 ],
    [ u"de",u"Edewecht",20519,53.133333,7.983333 ],
    [ u"de",u"Edingen-Neckarhausen",13935,49.457222,8.606389 ],
    [ u"de",u"Egelsbach",9703,49.971111,8.670278 ],
    [ u"de",u"Eggenfelden",12988,48.4,12.766667 ],
    [ u"de",u"Eggenstein-Leopoldshafen",15222,49.095278,8.390556 ],
    [ u"de",u"Ehingen",26154,48.283333,9.733333 ],
    [ u"de",u"Eichenau",11614,48.166667,11.316667 ],
    [ u"de",u"Eichenzell",10708,50.483333,9.7 ],
    [ u"de",u"Eichstätt",13166,48.883333,11.183333 ],
    [ u"de",u"Eilenburg",17120,51.466667,12.616667 ],
    [ u"de",u"Einbeck",28179,51.816667,9.866667 ],
    [ u"de",u"Eisenach",44399,50.983333,10.316667 ],
    [ u"de",u"Eisenberg",9970,49.565833,8.07 ],
    [ u"de",u"Eisenberg",11616,50.966667,11.9 ],
    [ u"de",u"Eisenhüttenstadt",35839,52.15,14.65 ],
    [ u"de",u"Eislingen",20343,48.7,9.7 ],
    [ u"de",u"Eitorf",19867,50.766667,7.45 ],
    [ u"de",u"Ellwangen",25396,48.966667,10.133333 ],
    [ u"de",u"Elmshorn",48744,53.75,9.65 ],
    [ u"de",u"Elsdorf",21901,50.933333,6.566667 ],
    [ u"de",u"Elsfleth",9286,53.233333,8.466667 ],
    [ u"de",u"Elsterwerda",9714,51.45,13.533333 ],
    [ u"de",u"Eltville",16858,50.033333,8.116667 ],
    [ u"de",u"Elze",9686,52.116667,9.733333 ],
    [ u"de",u"Emden",51639,53.366667,7.216667 ],
    [ u"de",u"Emmendingen",26820,48.133333,7.85 ],
    [ u"de",u"Emmerich",29753,51.833333,6.25 ],
    [ u"de",u"Emsdetten",35383,52.183333,7.533333 ],
    [ u"de",u"Engelskirchen",20883,50.983333,7.4 ],
    [ u"de",u"Engen",10195,47.85,8.766667 ],
    [ u"de",u"Enger",20417,52.133333,8.566667 ],
    [ u"de",u"Eningen",10715,48.483333,9.25 ],
    [ u"de",u"Ennepetal",32426,51.3,7.35 ],
    [ u"de",u"Ennigerloh",20678,51.833333,8.016667 ],
    [ u"de",u"Eppelborn",18400,49.4,6.966667 ],
    [ u"de",u"Eppelheim",14647,49.4025,8.633056 ],
    [ u"de",u"Eppingen",21457,49.136944,8.910278 ],
    [ u"de",u"Eppstein",13512,50.133333,8.4 ],
    [ u"de",u"Erbach",13238,48.333333,9.883333 ],
    [ u"de",u"Erbach",13501,49.656111,8.996389 ],
    [ u"de",u"Erding",32377,48.3,11.933333 ],
    [ u"de",u"Erftstadt",51606,50.816667,6.766667 ],
    [ u"de",u"Erfurt",196719,50.983333,11.033333 ],
    [ u"de",u"Ergolding",11513,48.583333,12.166667 ],
    [ u"de",u"Erkelenz",44479,51.083333,6.316667 ],
    [ u"de",u"Erkner",11866,52.416667,13.75 ],
    [ u"de",u"Erkrath",47908,51.216667,6.9 ],
    [ u"de",u"Erlangen",102781,49.589722,11.003889 ],
    [ u"de",u"Erlenbach",10095,49.803889,9.163889 ],
    [ u"de",u"Erlensee",12407,50.15,8.95 ],
    [ u"de",u"Erwitte",16097,51.616667,8.35 ],
    [ u"de",u"Eschborn",20438,50.133333,8.55 ],
    [ u"de",u"Eschwege",21546,51.183333,10.066667 ],
    [ u"de",u"Eschweiler",55888,50.816667,6.283333 ],
    [ u"de",u"Espelkamp",26684,52.383333,8.616667 ],
    [ u"de",u"Essenbach",11013,48.616667,12.216667 ],
    [ u"de",u"Essen",576914,51.45,7.016667 ],
    [ u"de",u"Esslingen",92710,48.75,9.3 ],
    [ u"de",u"Ettenheim",11956,48.25,7.816667 ],
    [ u"de",u"Ettlingen",39635,48.95,8.4 ],
    [ u"de",u"Euskirchen",54855,50.666667,6.783333 ],
    [ u"de",u"Eutin",17258,54.133333,10.616667 ],
    [ u"de",u"Falkensee",37916,52.566667,13.083333 ],
    [ u"de",u"Falkenstein",9859,50.483333,12.366667 ],
    [ u"de",u"Fallingbostel",13639,52.866667,9.7 ],
    [ u"de",u"Feldkirchen-Westerham",10177,47.9,11.85 ],
    [ u"de",u"Fellbach",44142,48.8,9.283333 ],
    [ u"de",u"Felsberg",11244,51.133333,9.416667 ],
    [ u"de",u"Feucht",13585,49.376667,11.213889 ],
    [ u"de",u"Feuchtwangen",12207,49.166667,10.333333 ],
    [ u"de",u"Filderstadt",43580,48.666667,9.216667 ],
    [ u"de",u"Finnentrop",18466,51.166667,7.966667 ],
    [ u"de",u"Finsterwalde",18733,51.633333,13.716667 ],
    [ u"de",u"Flensburg",85158,54.783333,9.433333 ],
    [ u"de",u"Flöha",11427,50.866667,13.066667 ],
    [ u"de",u"Flörsheim",19936,50.016667,8.433333 ],
    [ u"de",u"Forchheim",30838,49.723056,11.066944 ],
    [ u"de",u"Forst",22521,51.733333,14.633333 ],
    [ u"de",u"Frankenberg",19366,51.066667,8.8 ],
    [ u"de",u"Frankenberg",16819,50.916667,13.033333 ],
    [ u"de",u"Frankenthal",47523,49.537222,8.355 ],
    [ u"de",u"Frankfurt",648034,50.116667,8.683333 ],
    [ u"de",u"Frankfurt",64399,52.35,14.55 ],
    [ u"de",u"Frechen",48198,50.916667,6.816667 ],
    [ u"de",u"Freiberg",15517,48.933333,9.2 ],
    [ u"de",u"Freiberg",43160,50.916667,13.366667 ],
    [ u"de",u"Freiburg",213920,48,7.85 ],
    [ u"de",u"Freilassing",16033,47.85,12.983333 ],
    [ u"de",u"Freising",42322,48.4,11.733333 ],
    [ u"de",u"Freital",38815,51.016667,13.65 ],
    [ u"de",u"Freudenberg",18440,50.9,7.866667 ],
    [ u"de",u"Freudenstadt",24384,48.433333,8.416667 ],
    [ u"de",u"Frickenhausen",8917,48.6,9.366667 ],
    [ u"de",u"Friedberg",29581,48.35,10.983333 ],
    [ u"de",u"Friedberg",28164,50.35,8.766667 ],
    [ u"de",u"Friedeburg",10822,53.45,7.833333 ],
    [ u"de",u"Friedland",10472,51.416667,9.933333 ],
    [ u"de",u"Friedrichsdorf",24897,50.266667,8.65 ],
    [ u"de",u"Friedrichshafen",58005,47.65,9.483333 ],
    [ u"de",u"Friedrichsthal",11425,49.316667,7.1 ],
    [ u"de",u"Friesenheim",12616,49.498333,8.422778 ],
    [ u"de",u"Friesoythe",20178,53.016667,7.85 ],
    [ u"de",u"Fritzlar",14798,51.133333,9.283333 ],
    [ u"de",u"Fröndenberg",23499,51.466667,7.766667 ],
    [ u"de",u"Fuldabrück",9098,51.266667,9.483333 ],
    [ u"de",u"Fulda",63851,50.55,9.666667 ],
    [ u"de",u"Fuldatal",12102,51.383333,9.566667 ],
    [ u"de",u"Fürstenfeldbruck",34194,48.183333,11.25 ],
    [ u"de",u"Fürstenwalde",33199,52.366667,14.066667 ],
    [ u"de",u"Fürth",112959,49.466667,10.966667 ],
    [ u"de",u"Furth im Wald",9400,49.309722,12.84 ],
    [ u"de",u"Furtwangen",9763,48.05,8.2 ],
    [ u"de",u"Füssen",14002,47.566667,10.7 ],
    [ u"de",u"Gaggenau",29800,48.8,8.333333 ],
    [ u"de",u"Gaildorf",12683,49.003889,9.771111 ],
    [ u"de",u"Gaimersheim",10998,48.816667,11.366667 ],
    [ u"de",u"Ganderkesee",31262,53.033333,8.533333 ],
    [ u"de",u"Gangelt",11647,50.983333,6 ],
    [ u"de",u"Garbsen",63354,52.416667,9.6 ],
    [ u"de",u"Garching",15380,48.25,11.65 ],
    [ u"de",u"Gardelegen",11771,52.533333,11.366667 ],
    [ u"de",u"Garmisch-Partenkirchen",26346,47.5,11.1 ],
    [ u"de",u"Garrel",12515,52.95,8.016667 ],
    [ u"de",u"Gärtringen",11438,48.65,8.9 ],
    [ u"de",u"Gauting",19381,48.066667,11.366667 ],
    [ u"de",u"Geeste",11456,52.6,7.266667 ],
    [ u"de",u"Geesthacht",29853,53.433333,10.366667 ],
    [ u"de",u"Gehrden",15139,52.316667,9.6 ],
    [ u"de",u"Geilenkirchen",28587,50.966667,6.116667 ],
    [ u"de",u"Geisenheim",11959,49.983333,7.966667 ],
    [ u"de",u"Geldern",34291,51.516667,6.333333 ],
    [ u"de",u"Gelnhausen",21417,50.2,9.183333 ],
    [ u"de",u"Gelsenkirchen",271647,51.516667,7.05 ],
    [ u"de",u"Gemünden",11560,50.05,9.7 ],
    [ u"de",u"Gengenbach",11035,48.4,8.016667 ],
    [ u"de",u"Genthin",14573,52.4,12.166667 ],
    [ u"de",u"Georgsmarienhütte",32945,52.2,8.05 ],
    [ u"de",u"Gera",104463,50.866667,12.083333 ],
    [ u"de",u"Geretsried",23377,47.866667,11.466667 ],
    [ u"de",u"Gerlingen",18977,48.8,9.066667 ],
    [ u"de",u"Germering",36905,48.133333,11.366667 ],
    [ u"de",u"Germersheim",20706,49.223056,8.363889 ],
    [ u"de",u"Gernsbach",14548,48.766667,8.333333 ],
    [ u"de",u"Gernsheim",9435,49.76,8.495833 ],
    [ u"de",u"Gerstetten",12407,48.633333,10.033333 ],
    [ u"de",u"Gersthofen",20322,48.416667,10.883333 ],
    [ u"de",u"Gescher",16937,51.95,7.016667 ],
    [ u"de",u"Geseke",20790,51.65,8.516667 ],
    [ u"de",u"Gevelsberg",32978,51.316667,7.333333 ],
    [ u"de",u"Giengen",20211,48.616667,10.25 ],
    [ u"de",u"Gifhorn",42699,52.483333,10.55 ],
    [ u"de",u"Gilching",17204,48.116667,11.3 ],
    [ u"de",u"Ginsheim-Gustavsburg",16283,49.985833,8.3425 ],
    [ u"de",u"Gladbeck",77264,51.566667,6.983333 ],
    [ u"de",u"Gladenbach",12613,50.766667,8.566667 ],
    [ u"de",u"Glauchau",26260,50.816667,12.533333 ],
    [ u"de",u"Glinde",16106,53.55,10.2 ],
    [ u"de",u"Glückstadt",11976,53.783333,9.416667 ],
    [ u"de",u"Goch",34045,51.666667,6.166667 ],
    [ u"de",u"Goldbach",10038,49.988889,9.186389 ],
    [ u"de",u"Göppingen",58021,48.7,9.666667 ],
    [ u"de",u"Görlitz",57097,51.166667,15 ],
    [ u"de",u"Goslar",43461,51.9,10.433333 ],
    [ u"de",u"Gotha",47214,50.95,10.716667 ],
    [ u"de",u"Göttingen",123570,51.533333,9.933333 ],
    [ u"de",u"Gottmadingen",10242,47.733333,8.783333 ],
    [ u"de",u"Graben-Neudorf",11683,49.170278,8.487778 ],
    [ u"de",u"Gräfelfing",12992,48.1,11.45 ],
    [ u"de",u"Grafenau",9180,48.85,13.4 ],
    [ u"de",u"Gräfenhainichen",8026,51.733333,12.45 ],
    [ u"de",u"Grafing",12469,48.05,11.966667 ],
    [ u"de",u"Grefrath",16167,51.3,6.316667 ],
    [ u"de",u"Greifswald",51935,54.1,13.383333 ],
    [ u"de",u"Greiz",23931,50.65,12.2 ],
    [ u"de",u"Grenzach-Wyhlen",13994,47.552573,7.660567 ],
    [ u"de",u"Grevenbroich",64851,51.083333,6.583333 ],
    [ u"de",u"Greven",35732,52.1,7.616667 ],
    [ u"de",u"Grevesmühlen",10993,53.866667,11.183333 ],
    [ u"de",u"Griesheim",25432,49.862778,8.575278 ],
    [ u"de",u"Grimma",17780,51.233333,12.716667 ],
    [ u"de",u"Grimmen",10764,54.1,13.05 ],
    [ u"de",u"Gröbenzell",19181,48.2,11.366667 ],
    [ u"de",u"Gröditz",8086,51.416667,13.45 ],
    [ u"de",u"Gronau",46061,52.2,7.033333 ],
    [ u"de",u"Grünberg",14360,50.6,8.95 ],
    [ u"de",u"Grünstadt",13219,49.569167,8.168056 ],
    [ u"de",u"Grünwald",11173,48.05,11.516667 ],
    [ u"de",u"Guben",21602,51.95,14.716667 ],
    [ u"de",u"Gummersbach",53244,51.033333,7.55 ],
    [ u"de",u"Gundelfingen",11475,48.05,7.866667 ],
    [ u"de",u"Günzburg",19507,48.45,10.266667 ],
    [ u"de",u"Gunzenhausen",16666,49.1,10.75 ],
    [ u"de",u"Güstrow",30869,53.8,12.166667 ],
    [ u"de",u"Gütersloh",96332,51.9,8.383333 ],
    [ u"de",u"Haan",29369,51.2,7 ],
    [ u"de",u"Haar",17810,48.1,11.733333 ],
    [ u"de",u"Hagen",14349,52.2,7.983333 ],
    [ u"de",u"Hagen",199497,51.35,7.466667 ],
    [ u"de",u"Hagenow",12253,53.433333,11.183333 ],
    [ u"de",u"Haiger",20134,50.75,8.216667 ],
    [ u"de",u"Haigerloch",11066,48.366667,8.8 ],
    [ u"de",u"Hainichen",9628,50.966667,13.116667 ],
    [ u"de",u"Halberstadt",39391,51.9,11.05 ],
    [ u"de",u"Haldensleben",20131,52.3,11.416667 ],
    [ u"de",u"Halle",20921,52.066667,8.366667 ],
    [ u"de",u"Halle",232452,51.5,12 ],
    [ u"de",u"Halstenbek",16074,53.633333,9.85 ],
    [ u"de",u"Haltern",38212,51.733333,7.183333 ],
    [ u"de",u"Halver",17660,51.2,7.483333 ],
    [ u"de",u"Hamburg",1733846,53.55,10 ],
    [ u"de",u"Hameln",59349,52.1,9.35 ],
    [ u"de",u"Hammelburg",11798,50.116667,9.9 ],
    [ u"de",u"Hamm",186289,51.683333,7.8 ],
    [ u"de",u"Hamminkeln",27755,51.733333,6.583333 ],
    [ u"de",u"Hanau",89938,50.133333,8.916667 ],
    [ u"de",u"Hannoversch Münden",25612,51.416667,9.683333 ],
    [ u"de",u"Hanover",519144,52.366667,9.716667 ],
    [ u"de",u"Haren",23038,52.783333,7.233333 ],
    [ u"de",u"Harrislee",11600,54.8,9.383333 ],
    [ u"de",u"Harsewinkel",23910,51.966667,8.233333 ],
    [ u"de",u"Harsum",12401,52.216667,9.966667 ],
    [ u"de",u"Hasbergen",10863,52.233333,7.933333 ],
    [ u"de",u"Haselünne",12748,52.666667,7.483333 ],
    [ u"de",u"Hatten",13342,53.016667,8.35 ],
    [ u"de",u"Hattersheim",25544,50.066667,8.466667 ],
    [ u"de",u"Hattingen",58076,51.4,7.166667 ],
    [ u"de",u"Hauzenberg",12471,48.65,13.633333 ],
    [ u"de",u"Havixbeck",12249,51.983333,7.416667 ],
    [ u"de",u"Hechingen",19671,48.35,8.983333 ],
    [ u"de",u"Heddesheim",11673,49.505556,8.603611 ],
    [ u"de",u"Heide",20309,54.2,9.1 ],
    [ u"de",u"Heidelberg",144703,49.416667,8.7 ],
    [ u"de",u"Heidenau",16719,50.983333,13.866667 ],
    [ u"de",u"Heidenheim",50684,48.683333,10.15 ],
    [ u"de",u"Heilbad Heiligenstadt",17056,51.383333,10.133333 ],
    [ u"de",u"Heilbronn",121822,49.140278,9.22 ],
    [ u"de",u"Heiligenhafen",9328,54.366667,10.983333 ],
    [ u"de",u"Heiligenhaus",28312,51.316667,6.966667 ],
    [ u"de",u"Heinsberg",42409,51.066667,6.083333 ],
    [ u"de",u"Helmbrechts",9539,50.233333,11.7 ],
    [ u"de",u"Helmstedt",25686,52.233333,11 ],
    [ u"de",u"Hemer",39288,51.383333,7.766667 ],
    [ u"de",u"Hemmingen",18956,52.316667,9.75 ],
    [ u"de",u"Hemsbach",12442,49.591667,8.646389 ],
    [ u"de",u"Hennef",45829,50.783333,7.283333 ],
    [ u"de",u"Hennigsdorf",26498,52.633333,13.2 ],
    [ u"de",u"Henstedt-Ulzburg",26062,53.783333,10 ],
    [ u"de",u"Heppenheim",25580,49.640833,8.637222 ],
    [ u"de",u"Herborn",21404,50.683333,8.316667 ],
    [ u"de",u"Herbrechtingen",13244,48.616667,10.183333 ],
    [ u"de",u"Herdecke",25954,51.4,7.433333 ],
    [ u"de",u"Herford",65834,52.133333,8.683333 ],
    [ u"de",u"Hermsdorf",8728,50.9,11.866667 ],
    [ u"de",u"Herne",173121,51.55,7.216667 ],
    [ u"de",u"Herrenberg",31401,48.6,8.866667 ],
    [ u"de",u"Hersbruck",12506,49.5125,11.433889 ],
    [ u"de",u"Herten",65367,51.6,7.133333 ],
    [ u"de",u"Herxheim",10443,49.509167,8.179167 ],
    [ u"de",u"Herzberg",14832,51.65,10.333333 ],
    [ u"de",u"Herzberg",12188,51.683333,13.233333 ],
    [ u"de",u"Herzogenaurach",23229,49.55,10.883333 ],
    [ u"de",u"Herzogenrath",47425,50.866667,6.1 ],
    [ u"de",u"Hessisch Lichtenau",13394,51.2,9.716667 ],
    [ u"de",u"Hessisch Oldendorf",19871,52.166667,9.25 ],
    [ u"de",u"Hettstedt",15876,51.65,11.5 ],
    [ u"de",u"Heubach",10164,48.783333,9.933333 ],
    [ u"de",u"Heusenstamm",19257,50.066667,8.8 ],
    [ u"de",u"Heusweiler",20094,49.35,6.933333 ],
    [ u"de",u"Hiddenhausen",20742,52.166667,8.616667 ],
    [ u"de",u"Hilchenbach",16784,50.983333,8.1 ],
    [ u"de",u"Hildburghausen",12422,50.416667,10.75 ],
    [ u"de",u"Hilden",57036,51.166667,6.933333 ],
    [ u"de",u"Hildesheim",102958,52.15,9.966667 ],
    [ u"de",u"Hille",16620,52.333333,8.75 ],
    [ u"de",u"Hilpoltstein",12968,49.19,11.188611 ],
    [ u"de",u"Hilter",10312,52.15,8.15 ],
    [ u"de",u"Hirschaid",11514,49.819444,10.990833 ],
    [ u"de",u"Hochheim",17203,50.016667,8.35 ],
    [ u"de",u"Höchstadt",13470,49.7,10.8 ],
    [ u"de",u"Höchst",10143,49.799722,8.999444 ],
    [ u"de",u"Hockenheim",20814,49.322778,8.545833 ],
    [ u"de",u"Hofgeismar",16199,51.483333,9.4 ],
    [ u"de",u"Hofheim",38482,50.083333,8.45 ],
    [ u"de",u"Hof",49353,50.316667,11.916667 ],
    [ u"de",u"Hohen Neuendorf",22687,52.666667,13.283333 ],
    [ u"de",u"Hohenstein-Ernstthal",16416,50.8,12.716667 ],
    [ u"de",u"Höhr-Grenzhausen",9906,50.433333,7.666667 ],
    [ u"de",u"Holzgerlingen",11567,48.633333,9.016667 ],
    [ u"de",u"Holzkirchen",15459,47.883333,11.7 ],
    [ u"de",u"Holzminden",21028,51.816667,9.45 ],
    [ u"de",u"Holzwickede",17867,51.5,7.633333 ],
    [ u"de",u"Homberg",14893,51.033333,9.4 ],
    [ u"de",u"Homburg",45010,49.316667,7.333333 ],
    [ u"de",u"Horb",26287,48.433333,8.683333 ],
    [ u"de",u"Hörstel",19979,52.316667,7.583333 ],
    [ u"de",u"Hösbach",13258,50,9.2 ],
    [ u"de",u"Hövelhof",16349,51.816667,8.65 ],
    [ u"de",u"Höxter",32962,51.766667,9.383333 ],
    [ u"de",u"Hoyerswerda",43267,51.433333,14.25 ],
    [ u"de",u"Hückelhoven",39765,51.05,6.216667 ],
    [ u"de",u"Hückeswagen",16499,51.15,7.35 ],
    [ u"de",u"Hude",15858,53.116667,8.466667 ],
    [ u"de",u"Hüllhorst",13913,52.283333,8.666667 ],
    [ u"de",u"Hünfeld",16454,50.666667,9.766667 ],
    [ u"de",u"Hungen",12844,50.466667,8.9 ],
    [ u"de",u"Hünxe",13707,51.65,6.783333 ],
    [ u"de",u"Hürth",55217,50.866667,6.866667 ],
    [ u"de",u"Husum",20753,54.466667,9.05 ],
    [ u"de",u"Ibbenbüren",51305,52.266667,7.733333 ],
    [ u"de",u"Idar-Oberstein",32876,49.7,7.3 ],
    [ u"de",u"Idstein",23432,50.233333,8.266667 ],
    [ u"de",u"Ihlow",12757,51.883333,13.333333 ],
    [ u"de",u"Illertissen",16623,48.216667,10.1 ],
    [ u"de",u"Illingen",18312,49.366667,7.05 ],
    [ u"de",u"Ilmenau",27471,50.683333,10.9 ],
    [ u"de",u"Ilsede",12326,52.266667,10.2 ],
    [ u"de",u"Immenstadt",14282,47.566667,10.216667 ],
    [ u"de",u"Ingelheim",25296,49.980556,8.073611 ],
    [ u"de",u"Ingolstadt",120598,48.766667,11.433333 ],
    [ u"de",u"Iserlohn",98190,51.366667,7.7 ],
    [ u"de",u"Ismaning",14722,48.233333,11.633333 ],
    [ u"de",u"Isny",14461,47.7,10.033333 ],
    [ u"de",u"Isselburg",11274,51.833333,6.466667 ],
    [ u"de",u"Issum",12257,51.533333,6.433333 ],
    [ u"de",u"Itzehoe",33415,53.916667,9.516667 ],
    [ u"de",u"Jena",99269,50.933333,11.583333 ],
    [ u"de",u"Jever",14079,53.583333,7.9 ],
    [ u"de",u"Jork",11878,53.533333,9.683333 ],
    [ u"de",u"Jüchen",22333,51.1,6.5 ],
    [ u"de",u"Jülich",34888,50.933333,6.366667 ],
    [ u"de",u"Jüterbog",13483,51.983333,13.083333 ],
    [ u"de",u"Kaarst",42876,51.233333,6.616667 ],
    [ u"de",u"Kaiserslautern",98947,49.45,7.75 ],
    [ u"de",u"Kalkar",14405,51.733333,6.3 ],
    [ u"de",u"Kall",12074,50.55,6.55 ],
    [ u"de",u"Kaltenkirchen",19161,53.833333,9.966667 ],
    [ u"de",u"Kamen",46076,51.6,7.666667 ],
    [ u"de",u"Kamenz",18122,51.266667,14.1 ],
    [ u"de",u"Kamp-Lintfort",39949,51.5,6.533333 ],
    [ u"de",u"Kappeln",9801,54.666667,9.933333 ],
    [ u"de",u"Karben",21718,50.233333,8.75 ],
    [ u"de",u"Karlsfeld",17958,48.216667,11.466667 ],
    [ u"de",u"Karlsruhe",284786,49.004722,8.385833 ],
    [ u"de",u"Karlstadt",15247,49.960278,9.772222 ],
    [ u"de",u"Kassel",193117,51.316667,9.5 ],
    [ u"de",u"Kaufbeuren",43454,47.883333,10.616667 ],
    [ u"de",u"Kaufungen",12804,51.281111,9.618611 ],
    [ u"de",u"Kehl",34493,48.583333,7.816667 ],
    [ u"de",u"Kelheim",16227,48.916667,11.866667 ],
    [ u"de",u"Kelkheim",26823,50.133333,8.45 ],
    [ u"de",u"Kelsterbach",14146,50.066667,8.533333 ],
    [ u"de",u"Kempen",36506,51.366667,6.416667 ],
    [ u"de",u"Kempten",61800,47.716667,10.316667 ],
    [ u"de",u"Kerpen",64729,50.866667,6.7 ],
    [ u"de",u"Ketsch",12960,49.367778,8.531111 ],
    [ u"de",u"Kevelaer",28148,51.583333,6.25 ],
    [ u"de",u"Kiel",235264,54.333333,10.133333 ],
    [ u"de",u"Kierspe",18281,51.133333,7.583333 ],
    [ u"de",u"Kirchen",9354,50.8,7.883333 ],
    [ u"de",u"Kirchhain",16432,50.816667,8.966667 ],
    [ u"de",u"Kirchheim",40144,48.65,9.45 ],
    [ u"de",u"Kirchheim",11982,48.183333,11.75 ],
    [ u"de",u"Kirchhundem",13059,51.1,8.1 ],
    [ u"de",u"Kirchlengern",16557,52.2,8.633333 ],
    [ u"de",u"Kirchlinteln",10644,52.95,9.316667 ],
    [ u"de",u"Kirchzarten",9575,47.966667,7.95 ],
    [ u"de",u"Kirkel",10509,49.283333,7.233333 ],
    [ u"de",u"Kirn",8879,49.783333,7.45 ],
    [ u"de",u"Kissing",11072,48.3,10.983333 ],
    [ u"de",u"Kitzingen",21705,49.733333,10.166667 ],
    [ u"de",u"Kleinblittersdorf",12940,49.15,7.033333 ],
    [ u"de",u"Kleinmachnow",18306,52.4,13.25 ],
    [ u"de",u"Klingenthal",8984,50.366667,12.466667 ],
    [ u"de",u"Koblenz",108146,50.35,7.6 ],
    [ u"de",u"Kolbermoor",18488,47.85,12.066667 ],
    [ u"de",u"Kolkwitz",10336,51.75,14.25 ],
    [ u"de",u"Köngen",9879,48.683333,9.366667 ],
    [ u"de",u"Königslutter",16614,52.25,10.816667 ],
    [ u"de",u"Königstein",15767,50.183333,8.466667 ],
    [ u"de",u"Königswinter",41248,50.683333,7.183333 ],
    [ u"de",u"Königs Wusterhausen",33872,52.283333,13.616667 ],
    [ u"de",u"Konstanz",81951,47.666667,9.183333 ],
    [ u"de",u"Korbach",24657,51.283333,8.866667 ],
    [ u"de",u"Korb",10305,48.85,9.366667 ],
    [ u"de",u"Korntal-Münchingen",18358,48.816667,9.116667 ],
    [ u"de",u"Kornwestheim",30756,48.866667,9.183333 ],
    [ u"de",u"Korschenbroich",33588,51.183333,6.516667 ],
    [ u"de",u"Köthen",28700,51.75,11.966667 ],
    [ u"de",u"Krefeld",239908,51.333333,6.566667 ],
    [ u"de",u"Kreuzau",18670,50.75,6.483333 ],
    [ u"de",u"Kreuztal",31720,50.966667,7.983333 ],
    [ u"de",u"Kriftel",10590,50.083333,8.483333 ],
    [ u"de",u"Kronach",18349,50.233333,11.316667 ],
    [ u"de",u"Kronberg",17649,50.183333,8.5 ],
    [ u"de",u"Kronshagen",11826,54.333333,10.083333 ],
    [ u"de",u"Krumbach",12518,48.25,10.366667 ],
    [ u"de",u"Kulmbach",27346,50.1,11.45 ],
    [ u"de",u"Kümmersbruck",10458,49.419167,11.888333 ],
    [ u"de",u"Künzell",16356,50.55,9.716667 ],
    [ u"de",u"Künzelsau",15128,49.281944,9.688889 ],
    [ u"de",u"Kürten",20588,51.05,7.266667 ],
    [ u"de",u"Kyritz",11321,52.95,12.4 ],
    [ u"de",u"Laatzen",40245,52.316667,9.8 ],
    [ u"de",u"Ladenburg",11621,49.475,8.606944 ],
    [ u"de",u"Lage",36709,51.983333,8.8 ],
    [ u"de",u"Lahnstein",18572,50.3,7.616667 ],
    [ u"de",u"Lahr",43676,48.35,7.866667 ],
    [ u"de",u"Lahstedt",10882,52.25,10.216667 ],
    [ u"de",u"Laichingen",11063,48.5,9.683333 ],
    [ u"de",u"Lampertheim",31873,49.601944,8.471944 ],
    [ u"de",u"Landau",13026,48.683333,12.683333 ],
    [ u"de",u"Landau",42031,49.2075,8.113333 ],
    [ u"de",u"Landsberg",26624,48.05,10.866667 ],
    [ u"de",u"Landshut",61131,48.533333,12.15 ],
    [ u"de",u"Langelsheim",13234,51.933333,10.333333 ],
    [ u"de",u"Langenau",14411,48.5,10.1 ],
    [ u"de",u"Langenfeld",58803,51.1,6.95 ],
    [ u"de",u"Langenhagen",49958,52.45,9.75 ],
    [ u"de",u"Langen",35755,49.993333,8.672778 ],
    [ u"de",u"Langen",18685,53.616667,8.6 ],
    [ u"de",u"Langenselbold",12652,50.183333,9.033333 ],
    [ u"de",u"Langenzenn",10767,49.5,10.8 ],
    [ u"de",u"Langerwehe",14222,50.816667,6.35 ],
    [ u"de",u"Langgöns",12251,50.5,8.666667 ],
    [ u"de",u"Langwedel",15200,52.966667,9.216667 ],
    [ u"de",u"Lappersdorf",12817,49.056944,12.09 ],
    [ u"de",u"Laubach",10262,50.55,8.983333 ],
    [ u"de",u"Lauchhammer",18948,51.5,13.8 ],
    [ u"de",u"Lauda-Königshofen",15138,49.565278,9.704167 ],
    [ u"de",u"Lauenburg",11796,53.366667,10.566667 ],
    [ u"de",u"Lauffen",11191,49.074444,9.146944 ],
    [ u"de",u"Lauf",26181,49.510278,11.2775 ],
    [ u"de",u"Lauingen",10991,48.566667,10.433333 ],
    [ u"de",u"Laupheim",19111,48.233333,9.883333 ],
    [ u"de",u"Lauterbach",14665,50.633333,9.4 ],
    [ u"de",u"Lebach",21665,49.4,6.916667 ],
    [ u"de",u"Leer",34081,53.233333,7.433333 ],
    [ u"de",u"Lehre",11664,52.333333,10.666667 ],
    [ u"de",u"Lehrte",44495,52.383333,9.966667 ],
    [ u"de",u"Leichlingen",27532,51.116667,7.016667 ],
    [ u"de",u"Leimen",27323,49.351111,8.689444 ],
    [ u"de",u"Leinefelde",13794,51.383333,10.333333 ],
    [ u"de",u"Leinfelden-Echterdingen",37210,48.7,9.15 ],
    [ u"de",u"Leipzig",492637,51.3,12.333333 ],
    [ u"de",u"Lemgo",42036,52.033333,8.9 ],
    [ u"de",u"Lengede",13196,52.2,10.3 ],
    [ u"de",u"Lengerich",22642,52.183333,7.866667 ],
    [ u"de",u"Lenggries",9409,47.683333,11.566667 ],
    [ u"de",u"Lennestadt",28142,51.116667,8.066667 ],
    [ u"de",u"Leonberg",46276,48.8,9.016667 ],
    [ u"de",u"Leopoldshöhe",16324,52.016667,8.7 ],
    [ u"de",u"Leuna",7100,51.316667,12.016667 ],
    [ u"de",u"Leutenbach",10718,48.883333,9.4 ],
    [ u"de",u"Leutkirch",22645,47.825,10.016667 ],
    [ u"de",u"Leverkusen",159088,51.016667,6.983333 ],
    [ u"de",u"Lich",13410,50.516667,8.833333 ],
    [ u"de",u"Lichtenau",11350,51.616667,8.9 ],
    [ u"de",u"Lichtenfels",21586,50.15,11.066667 ],
    [ u"de",u"Lichtenstein",13583,50.75,12.65 ],
    [ u"de",u"Liebenburg",9649,52.016667,10.45 ],
    [ u"de",u"Lilienthal",17851,53.133333,8.916667 ],
    [ u"de",u"Limbach-Oberfrohna",26721,50.866667,12.75 ],
    [ u"de",u"Limburgerhof",10750,49.424444,8.391944 ],
    [ u"de",u"Limburg",33955,50.383333,8.05 ],
    [ u"de",u"Lindau",24161,47.55,9.683333 ],
    [ u"de",u"Lindenberg",11614,47.6,9.9 ],
    [ u"de",u"Lindlar",22752,51.016667,7.383333 ],
    [ u"de",u"Lingen",51577,52.516667,7.316667 ],
    [ u"de",u"Linkenheim-Hochstetten",11783,49.137222,8.403333 ],
    [ u"de",u"Linnich",13983,50.983333,6.266667 ],
    [ u"de",u"Lippstadt",67638,51.666667,8.35 ],
    [ u"de",u"Löbau",21398,51.1,14.666667 ],
    [ u"de",u"Lohfelden",13910,51.266667,9.533333 ],
    [ u"de",u"Lohmar",31802,50.833333,7.216667 ],
    [ u"de",u"Lohne",25332,52.666667,8.233333 ],
    [ u"de",u"Löhne",41805,52.183333,8.666667 ],
    [ u"de",u"Lohr",16297,49.993611,9.578333 ],
    [ u"de",u"Lollar",10206,50.65,8.7 ],
    [ u"de",u"Löningen",13315,52.733333,7.766667 ],
    [ u"de",u"Lorch",11503,48.8,9.683333 ],
    [ u"de",u"Lörrach",47666,47.616288,7.664842 ],
    [ u"de",u"Lorsch",12829,49.654722,8.568611 ],
    [ u"de",u"Losheim",16418,49.516667,6.75 ],
    [ u"de",u"Lotte",13564,52.283333,7.916667 ],
    [ u"de",u"Loxstedt",16783,53.466667,8.65 ],
    [ u"de",u"Lübbecke",27131,52.3,8.616667 ],
    [ u"de",u"Lübbenau",21356,51.866667,13.966667 ],
    [ u"de",u"Lübben",14985,51.95,13.9 ],
    [ u"de",u"Lübeck",213171,53.866667,10.7 ],
    [ u"de",u"Lüchow",9763,52.966667,11.15 ],
    [ u"de",u"Luckenwalde",21217,52.083333,13.166667 ],
    [ u"de",u"Lüdenscheid",80045,51.216667,7.616667 ],
    [ u"de",u"Lüdinghausen",24218,51.766667,7.466667 ],
    [ u"de",u"Ludwigsburg",87855,48.9,9.183333 ],
    [ u"de",u"Ludwigsfelde",24823,52.3,13.266667 ],
    [ u"de",u"Ludwigshafen",162514,49.481111,8.435278 ],
    [ u"de",u"Ludwigslust",12209,53.316667,11.5 ],
    [ u"de",u"Lugau",7779,50.733333,12.75 ],
    [ u"de",u"Lügde",11448,51.95,9.25 ],
    [ u"de",u"Lüneburg",73252,53.25,10.4 ],
    [ u"de",u"Lünen",91912,51.616667,7.516667 ],
    [ u"de",u"Magdeburg",224428,52.166667,11.666667 ],
    [ u"de",u"Mainburg",13944,48.65,11.783333 ],
    [ u"de",u"Maintal",38656,50.15,8.833333 ],
    [ u"de",u"Mainz",187940,50,8.271111 ],
    [ u"de",u"Maisach",12623,48.216667,11.266667 ],
    [ u"de",u"Malchin",8413,53.733333,12.783333 ],
    [ u"de",u"Malente",10731,54.183333,10.566667 ],
    [ u"de",u"Malsch",14364,48.883333,8.333333 ],
    [ u"de",u"Manching",11297,48.716667,11.5 ],
    [ u"de",u"Mannheim",309626,49.488333,8.464722 ],
    [ u"de",u"Marbach",15353,48.933333,9.25 ],
    [ u"de",u"Marburg",79300,50.816667,8.766667 ],
    [ u"de",u"Marienberg",15600,50.65,13.166667 ],
    [ u"de",u"Marienheide",13645,51.083333,7.533333 ],
    [ u"de",u"Markdorf",12701,47.716667,9.4 ],
    [ u"de",u"Markgröningen",14766,48.9,9.066667 ],
    [ u"de",u"Markkleeberg",23220,51.283333,12.4 ],
    [ u"de",u"Marktheidenfeld",11023,49.844167,9.603889 ],
    [ u"de",u"Marktoberdorf",18701,47.783333,10.616667 ],
    [ u"de",u"Marktredwitz",18359,50.005,12.081111 ],
    [ u"de",u"Markt Schwaben",11251,48.2,11.883333 ],
    [ u"de",u"Marl",91262,51.65,7.083333 ],
    [ u"de",u"Marpingen",11439,49.45,7.05 ],
    [ u"de",u"Marsberg",22361,51.45,8.85 ],
    [ u"de",u"Maxhütte-Haidhof",10610,49.2025,12.098056 ],
    [ u"de",u"Mayen",19372,50.333333,7.216667 ],
    [ u"de",u"Mechernich",27551,50.6,6.65 ],
    [ u"de",u"Meckenbeuren",13121,47.7,9.566667 ],
    [ u"de",u"Meckenheim",25491,50.633333,7.016667 ],
    [ u"de",u"Meerane",17646,50.85,12.466667 ],
    [ u"de",u"Meerbusch",55053,51.283333,6.666667 ],
    [ u"de",u"Meinerzhagen",21907,51.116667,7.65 ],
    [ u"de",u"Meiningen",21570,50.55,10.416667 ],
    [ u"de",u"Meitingen",11245,48.55,10.85 ],
    [ u"de",u"Melle",46745,52.2,8.35 ],
    [ u"de",u"Melsungen",14122,51.133333,9.55 ],
    [ u"de",u"Memmingen",41210,47.983333,10.166667 ],
    [ u"de",u"Menden",58939,51.433333,7.8 ],
    [ u"de",u"Mengen",10155,48.05,9.333333 ],
    [ u"de",u"Meppen",34205,52.683333,7.316667 ],
    [ u"de",u"Merchweiler",10795,49.35,7.05 ],
    [ u"de",u"Mering",12437,48.266667,10.983333 ],
    [ u"de",u"Merseburg",34440,51.366667,12 ],
    [ u"de",u"Merzig",31141,49.45,6.633333 ],
    [ u"de",u"Meschede",32593,51.35,8.283333 ],
    [ u"de",u"Mettingen",12869,52.316667,7.783333 ],
    [ u"de",u"Mettlach",12705,49.5,6.6 ],
    [ u"de",u"Mettmann",39371,51.25,6.966667 ],
    [ u"de",u"Metzingen",22034,48.533333,9.266667 ],
    [ u"de",u"Meuselwitz",9953,51.05,12.3 ],
    [ u"de",u"Michelstadt",17363,49.673611,9.0025 ],
    [ u"de",u"Miesbach",11394,47.783333,11.833333 ],
    [ u"de",u"Miltenberg",9706,49.703889,9.264444 ],
    [ u"de",u"Mindelheim",14221,48.05,10.483333 ],
    [ u"de",u"Minden",83402,52.283333,8.916667 ],
    [ u"de",u"Mittweida",16494,50.983333,12.983333 ],
    [ u"de",u"Moers",109167,51.45,6.65 ],
    [ u"de",u"Möglingen",10460,48.883333,9.133333 ],
    [ u"de",u"Möhnesee",11612,51.5,8.133333 ],
    [ u"de",u"Mölln",18396,53.633333,10.683333 ],
    [ u"de",u"Mömbris",12393,50.066667,9.166667 ],
    [ u"de",u"Mönchengladbach",264969,51.2,6.433333 ],
    [ u"de",u"Monheim",43905,51.083333,6.883333 ],
    [ u"de",u"Monschau",13167,50.55,6.25 ],
    [ u"de",u"Montabaur",12518,50.433333,7.833333 ],
    [ u"de",u"Moosburg",17394,48.466667,11.933333 ],
    [ u"de",u"Morbach",11184,49.816667,7.116667 ],
    [ u"de",u"Mörfelden-Walldorf",34194,49.994722,8.583611 ],
    [ u"de",u"Mörlenbach",10566,49.599167,8.734722 ],
    [ u"de",u"Morsbach",11743,50.866667,7.75 ],
    [ u"de",u"Mosbach",25474,49.353889,9.142778 ],
    [ u"de",u"Mössingen",20197,48.4,9.066667 ],
    [ u"de",u"Much",15327,50.916667,7.4 ],
    [ u"de",u"Mühlacker",26674,48.95,8.833333 ],
    [ u"de",u"Mühldorf",17940,48.25,12.533333 ],
    [ u"de",u"Mühlhausen",36287,51.216667,10.45 ],
    [ u"de",u"Mühlheim",26753,50.116667,8.833333 ],
    [ u"de",u"Mülheim-Kärlich",10414,50.383333,7.5 ],
    [ u"de",u"Mülheim",172779,51.433333,6.883333 ],
    [ u"de",u"Müllheim",18518,47.811248,7.6285 ],
    [ u"de",u"Münchberg",11646,50.2,11.783333 ],
    [ u"de",u"Munich",1246133,48.1500,11.5833 ],
    [ u"de",u"Münsingen",14466,48.416667,9.5 ],
    [ u"de",u"Münster",13957,49.922778,8.867778 ],
    [ u"de",u"Munster",18090,52.983333,10.083333 ],
    [ u"de",u"Münster",272452,51.966667,7.633333 ],
    [ u"de",u"Murnau",12223,47.683333,11.2 ],
    [ u"de",u"Murrhardt",14381,48.966667,9.566667 ],
    [ u"de",u"Mutterstadt",12565,49.441389,8.356111 ],
    [ u"de",u"Nagold",23486,48.55,8.716667 ],
    [ u"de",u"Naila",8349,50.316667,11.7 ],
    [ u"de",u"Nalbach",9616,49.383333,6.783333 ],
    [ u"de",u"Nauen",19203,52.6,12.883333 ],
    [ u"de",u"Naumburg",30040,51.15,11.816667 ],
    [ u"de",u"Neckargemünd",14111,49.392222,8.794167 ],
    [ u"de",u"Neckarsulm",27530,49.192778,9.226111 ],
    [ u"de",u"Netphen",25187,50.916667,8.1 ],
    [ u"de",u"Nettetal",42959,51.316667,6.283333 ],
    [ u"de",u"Neu-Anspach",15609,50.316667,8.5 ],
    [ u"de",u"Neubiberg",13057,48.083333,11.683333 ],
    [ u"de",u"Neubrandenburg",67393,53.566667,13.266667 ],
    [ u"de",u"Neuenburg",11538,47.813418,7.563494 ],
    [ u"de",u"Neuenhagen",16111,52.533333,13.683333 ],
    [ u"de",u"Neuenkirchen",14068,52.25,7.366667 ],
    [ u"de",u"Neuenrade",12505,51.283333,7.783333 ],
    [ u"de",u"Neufahrn",18487,48.316667,11.666667 ],
    [ u"de",u"Neuhausen",11566,48.683333,9.283333 ],
    [ u"de",u"Neuhof",11437,50.433333,9.616667 ],
    [ u"de",u"Neumünster",79429,54.066667,9.983333 ],
    [ u"de",u"Neunkirchen",14295,50.8,8 ],
    [ u"de",u"Neunkirchen",50432,49.35,7.183333 ],
    [ u"de",u"Neuruppin",32173,52.933333,12.8 ],
    [ u"de",u"Neuss",152975,51.2,6.683333 ],
    [ u"de",u"Neustadt",12470,49.583333,10.6 ],
    [ u"de",u"Neustadt",45661,52.5,9.466667 ],
    [ u"de",u"Neustadt",16680,54.1,10.816667 ],
    [ u"de",u"Neustadt",10649,51.033333,14.216667 ],
    [ u"de",u"Neustadt",9142,50.733333,11.75 ],
    [ u"de",u"Neustrelitz",22312,53.366667,13.083333 ],
    [ u"de",u"Neutraubling",12645,48.983333,12.2 ],
    [ u"de",u"Neu-Ulm",51654,48.4,10.016667 ],
    [ u"de",u"Neuwied",66901,50.433333,7.466667 ],
    [ u"de",u"Neu Wulmstorf",20988,53.466667,9.8 ],
    [ u"de",u"Nidda",18335,50.416667,9 ],
    [ u"de",u"Nidderau",20274,50.25,8.9 ],
    [ u"de",u"Nideggen",11075,50.7,6.483333 ],
    [ u"de",u"Niederkassel",36426,50.816667,7.033333 ],
    [ u"de",u"Niederkrüchten",15697,51.2,6.216667 ],
    [ u"de",u"Niedernhausen",14703,50.15,8.316667 ],
    [ u"de",u"Niederzier",14648,50.883333,6.466667 ],
    [ u"de",u"Niefern-Öschelbronn",12299,48.916667,8.783333 ],
    [ u"de",u"Nienburg",32512,52.633333,9.216667 ],
    [ u"de",u"Niesky",11260,51.3,14.816667 ],
    [ u"de",u"Nohfelden",10666,49.583333,7.15 ],
    [ u"de",u"Nordenham",27783,53.5,8.483333 ],
    [ u"de",u"Norden",24686,53.6,7.2 ],
    [ u"de",u"Norderstedt",72011,53.7,10.016667 ],
    [ u"de",u"Nordhausen",43709,51.516667,10.8 ],
    [ u"de",u"Nordhorn",52906,52.433333,7.083333 ],
    [ u"de",u"Nördlingen",19646,48.85,10.5 ],
    [ u"de",u"Nordstemmen",13436,52.166667,9.783333 ],
    [ u"de",u"Northeim",30751,51.7,10 ],
    [ u"de",u"Nörvenich",11778,50.8,6.65 ],
    [ u"de",u"Nottuln",20256,51.933333,7.35 ],
    [ u"de",u"Nümbrecht",17492,50.9,7.55 ],
    [ u"de",u"Nuremberg",497593,49.447778,11.068333 ],
    [ u"de",u"Nürtingen",41002,48.633333,9.35 ],
    [ u"de",u"Oberasbach",17343,49.433333,10.95 ],
    [ u"de",u"Oberhaching",12416,48.033333,11.6 ],
    [ u"de",u"Oberhausen",220916,51.466667,6.85 ],
    [ u"de",u"Oberhausen-Rheinhausen",9580,49.273889,8.471667 ],
    [ u"de",u"Oberkirch",20264,48.533333,8.083333 ],
    [ u"de",u"Oberndorf",14890,48.283333,8.566667 ],
    [ u"de",u"Obernkirchen",10155,52.266667,9.133333 ],
    [ u"de",u"Ober-Ramstadt",15695,49.833611,8.751944 ],
    [ u"de",u"Oberstdorf",9895,47.4,10.283333 ],
    [ u"de",u"Obertshausen",24280,50.083333,8.85 ],
    [ u"de",u"Oberursel",42880,50.2,8.583333 ],
    [ u"de",u"Ochsenfurt",11531,49.65,10.083333 ],
    [ u"de",u"Ochtrup",19543,52.216667,7.183333 ],
    [ u"de",u"Odenthal",15537,51.033333,7.116667 ],
    [ u"de",u"Oelde",29608,51.816667,8.15 ],
    [ u"de",u"Oer-Erkenschwick",30474,51.633333,7.25 ],
    [ u"de",u"Oerlinghausen",17555,51.966667,8.666667 ],
    [ u"de",u"Offenbach",120641,50.1,8.766667 ],
    [ u"de",u"Offenburg",59109,48.483333,7.933333 ],
    [ u"de",u"Oftersheim",10228,49.365278,8.583056 ],
    [ u"de",u"Öhringen",23068,49.201667,9.503889 ],
    [ u"de",u"Olbernhau",11206,50.666667,13.333333 ],
    [ u"de",u"Olching",24526,48.2,11.333333 ],
    [ u"de",u"Oldenburg",160347,53.166667,8.2 ],
    [ u"de",u"Olfen",12450,51.7,7.4 ],
    [ u"de",u"Olpe",25939,51.033333,7.85 ],
    [ u"de",u"Olsberg",15923,51.35,8.5 ],
    [ u"de",u"Oranienburg",43275,52.75,13.233333 ],
    [ u"de",u"Oschatz",16348,51.3,13.116667 ],
    [ u"de",u"Oschersleben",19929,52.033333,11.25 ],
    [ u"de",u"Osnabrück",165372,52.266667,8.05 ],
    [ u"de",u"Osterburg",7255,52.783333,11.766667 ],
    [ u"de",u"Ostercappeln",9677,52.35,8.233333 ],
    [ u"de",u"Osterhofen",12010,48.7,13.016667 ],
    [ u"de",u"Osterholz-Scharmbeck",31469,53.233333,8.8 ],
    [ u"de",u"Ostfildern",34162,48.716667,9.266667 ],
    [ u"de",u"Östringen",12887,49.22,8.712222 ],
    [ u"de",u"Ottersberg",12392,53.1,9.15 ],
    [ u"de",u"Ottobrunn",19254,48.066667,11.683333 ],
    [ u"de",u"Ottweiler",15692,49.383333,7.166667 ],
    [ u"de",u"Overath",27073,50.95,7.3 ],
    [ u"de",u"Oyten",15694,53.05,9.016667 ],
    [ u"de",u"Paderborn",143096,51.716667,8.766667 ],
    [ u"de",u"Papenburg",34715,53.066667,7.4 ],
    [ u"de",u"Parchim",19146,53.433333,11.85 ],
    [ u"de",u"Pasewalk",12059,53.516667,13.983333 ],
    [ u"de",u"Passau",51091,48.583333,13.483333 ],
    [ u"de",u"Pattensen",13496,52.266667,9.766667 ],
    [ u"de",u"Pegnitz",14337,49.756389,11.545 ],
    [ u"de",u"Peine",49776,52.316667,10.233333 ],
    [ u"de",u"Peiting",12048,47.8,10.933333 ],
    [ u"de",u"Penzberg",16243,47.75,11.383333 ],
    [ u"de",u"Perleberg",13394,53.066667,11.866667 ],
    [ u"de",u"Petersberg",14350,50.566667,9.716667 ],
    [ u"de",u"Petershagen",27148,52.383333,8.966667 ],
    [ u"de",u"Pfarrkirchen",12029,48.433333,12.933333 ],
    [ u"de",u"Pforzheim",120366,48.883333,8.7 ],
    [ u"de",u"Pfullendorf",13278,47.916667,9.25 ],
    [ u"de",u"Pfullingen",18426,48.45,9.233333 ],
    [ u"de",u"Pfungstadt",25151,49.806389,8.606944 ],
    [ u"de",u"Philippsburg",12403,49.235833,8.456389 ],
    [ u"de",u"Pinneberg",40679,53.65,9.8 ],
    [ u"de",u"Pirmasens",43539,49.2,7.6 ],
    [ u"de",u"Pirna",39701,50.966667,13.933333 ],
    [ u"de",u"Planegg",10669,48.1,11.416667 ],
    [ u"de",u"Plankstadt",9300,49.394444,8.596111 ],
    [ u"de",u"Plattling",12590,48.783333,12.866667 ],
    [ u"de",u"Plauen",69378,50.5,12.133333 ],
    [ u"de",u"Plettenberg",28247,51.216667,7.883333 ],
    [ u"de",u"Plochingen",14627,48.716667,9.416667 ],
    [ u"de",u"Plön",12876,54.166667,10.416667 ],
    [ u"de",u"Plüderhausen",9697,48.8,9.6 ],
    [ u"de",u"Pocking",14816,48.4,13.316667 ],
    [ u"de",u"Poing",11498,48.166667,11.816667 ],
    [ u"de",u"Porta Westfalica",36419,52.216667,8.933333 ],
    [ u"de",u"Potsdam",145291,52.4,13.066667 ],
    [ u"de",u"Preetz",15540,54.233333,10.283333 ],
    [ u"de",u"Premnitz",11176,52.533333,12.333333 ],
    [ u"de",u"Prenzlau",20922,53.316667,13.866667 ],
    [ u"de",u"Prien",10264,47.866667,12.333333 ],
    [ u"de",u"Pritzwalk",15286,53.15,12.183333 ],
    [ u"de",u"Puchheim",19278,48.15,11.35 ],
    [ u"de",u"Pulheim",54209,51,6.8 ],
    [ u"de",u"Püttlingen",21142,49.283333,6.883333 ],
    [ u"de",u"Quakenbrück",13170,52.683333,7.95 ],
    [ u"de",u"Quedlinburg",23057,51.783333,11.15 ],
    [ u"de",u"Querfurt",9436,51.383333,11.6 ],
    [ u"de",u"Quickborn",20281,53.733333,9.9 ],
    [ u"de",u"Quierschied",14626,49.316667,7.05 ],
    [ u"de",u"Radeberg",18529,51.116667,13.916667 ],
    [ u"de",u"Radebeul",32698,51.1,13.65 ],
    [ u"de",u"Radevormwald",24298,51.2,7.35 ],
    [ u"de",u"Radolfzell",30385,47.733333,8.966667 ],
    [ u"de",u"Raesfeld",11430,51.766667,6.85 ],
    [ u"de",u"Rahden",16218,52.433333,8.616667 ],
    [ u"de",u"Rastatt",48452,48.85,8.2 ],
    [ u"de",u"Rastede",20358,53.25,8.2 ],
    [ u"de",u"Ratekau",16031,53.95,10.733333 ],
    [ u"de",u"Rathenow",27058,52.6,12.333333 ],
    [ u"de",u"Ratingen",92306,51.3,6.85 ],
    [ u"de",u"Ratisbon",129643,49.015,12.095556 ],
    [ u"de",u"Ratzeburg",13719,53.7,10.766667 ],
    [ u"de",u"Raubling",11403,47.783333,12.1 ],
    [ u"de",u"Raunheim",13993,50.016667,8.45 ],
    [ u"de",u"Ravensburg",48441,47.783333,9.616667 ],
    [ u"de",u"Recke",11867,52.383333,7.716667 ],
    [ u"de",u"Recklinghausen",122727,51.616667,7.2 ],
    [ u"de",u"Rees",22654,51.766667,6.4 ],
    [ u"de",u"Regen",12591,48.966667,13.133333 ],
    [ u"de",u"Regenstauf",15078,49.121667,12.129167 ],
    [ u"de",u"Rehau",10279,50.25,12.033333 ],
    [ u"de",u"Rehburg-Loccum",11180,52.466667,9.2 ],
    [ u"de",u"Rehlingen-Siersburg",16121,49.366667,6.683333 ],
    [ u"de",u"Reichenbach",22569,50.616667,12.3 ],
    [ u"de",u"Reinbek",25357,53.516667,10.25 ],
    [ u"de",u"Reinheim",17839,49.826944,8.836111 ],
    [ u"de",u"Reiskirchen",10771,50.6,8.833333 ],
    [ u"de",u"Rellingen",13856,53.65,9.816667 ],
    [ u"de",u"Remagen",16360,50.566667,7.233333 ],
    [ u"de",u"Remscheid",118230,51.183333,7.2 ],
    [ u"de",u"Rendsburg",28814,54.3,9.666667 ],
    [ u"de",u"Renningen",17725,48.766667,8.933333 ],
    [ u"de",u"Reutlingen",113625,48.483333,9.216667 ],
    [ u"de",u"Rheda-Wiedenbrück",46378,51.833333,8.316667 ],
    [ u"de",u"Rhede",18774,51.833333,6.7 ],
    [ u"de",u"Rheinau",10885,48.866667,8.2 ],
    [ u"de",u"Rheinbach",26195,50.633333,6.95 ],
    [ u"de",u"Rheinberg",32178,51.55,6.6 ],
    [ u"de",u"Rheine",76474,52.283333,7.45 ],
    [ u"de",u"Rheinfelden",32538,47.566667,7.8 ],
    [ u"de",u"Ribnitz-Damgarten",17176,54.25,12.466667 ],
    [ u"de",u"Riedlingen",10466,48.15,9.466667 ],
    [ u"de",u"Riegelsberg",15476,49.3,6.933333 ],
    [ u"de",u"Rielasingen-Worblingen",12006,47.733333,8.833333 ],
    [ u"de",u"Riesa",36788,51.3,13.3 ],
    [ u"de",u"Rietberg",28683,51.783333,8.433333 ],
    [ u"de",u"Rinteln",28048,52.183333,9.083333 ],
    [ u"de",u"Ritterhude",14143,53.183333,8.75 ],
    [ u"de",u"Rodenbach",11455,50.15,9.033333 ],
    [ u"de",u"Rödental",13973,50.283333,11.066667 ],
    [ u"de",u"Rodgau",43760,50.016667,8.833333 ],
    [ u"de",u"Roding",11428,49.196389,12.518611 ],
    [ u"de",u"Rommerskirchen",12554,51.033333,6.683333 ],
    [ u"de",u"Ronnenberg",23604,52.316667,9.65 ],
    [ u"de",u"Rosbach",11674,50.8,7.616667 ],
    [ u"de",u"Rosdorf",11844,51.5,9.9 ],
    [ u"de",u"Rosendahl",11132,51.766667,7.95 ],
    [ u"de",u"Rosenheim",60768,47.85,12.133333 ],
    [ u"de",u"Rösrath",27353,50.9,7.2 ],
    [ u"de",u"Rostock",196833,54.083333,12.133333 ],
    [ u"de",u"Rotenburg",14346,50.983333,9.716667 ],
    [ u"de",u"Rotenburg",22108,53.116667,9.4 ],
    [ u"de",u"Röthenbach",12084,49.485,11.2475 ],
    [ u"de",u"Roth",24959,49.245,11.091111 ],
    [ u"de",u"Rottenburg",43117,48.466667,8.933333 ],
    [ u"de",u"Rottweil",25783,48.166667,8.616667 ],
    [ u"de",u"Rudersberg",11651,48.883333,9.533333 ],
    [ u"de",u"Rüdersdorf",17943,52.45,13.783333 ],
    [ u"de",u"Rüdesheim",9811,49.983333,7.916667 ],
    [ u"de",u"Rudolstadt",25773,50.716667,11.333333 ],
    [ u"de",u"Runkel",9794,50.4,8.166667 ],
    [ u"de",u"Rüsselsheim",59911,49.9925,8.435 ],
    [ u"de",u"Rutesheim",10175,48.8,8.95 ],
    [ u"de",u"Rüthen",11453,51.483333,8.45 ],
    [ u"de",u"Saalfeld",28152,50.65,11.366667 ],
    [ u"de",u"Saarbrücken",181779,49.233333,7 ],
    [ u"de",u"Saarlouis",37663,49.316667,6.75 ],
    [ u"de",u"Saarwellingen",13882,49.35,6.816667 ],
    [ u"de",u"Salzgitter",111622,52.083333,10.333333 ],
    [ u"de",u"Salzhemmendorf",10709,52.066667,9.616667 ],
    [ u"de",u"Salzkotten",24369,51.666667,8.6 ],
    [ u"de",u"Salzwedel",24144,52.85,11.15 ],
    [ u"de",u"Sandhausen",14329,49.342778,8.659167 ],
    [ u"de",u"Sangerhausen",23301,51.466667,11.3 ],
    [ u"de",u"Sankt Augustin",56258,50.766667,7.183333 ],
    [ u"de",u"Sankt Georgen",13825,48.133333,8.333333 ],
    [ u"de",u"Sankt Ingbert",38654,49.283333,7.116667 ],
    [ u"de",u"Sankt Leon-Rot",12143,49.266389,8.616667 ],
    [ u"de",u"Sankt Wendel",27162,49.466667,7.166667 ],
    [ u"de",u"Sarstedt",18555,52.233333,9.85 ],
    [ u"de",u"Sassenberg",14507,52,8.05 ],
    [ u"de",u"Schalksmühle",11859,51.233333,7.533333 ],
    [ u"de",u"Scharbeutz",11973,54.033333,10.75 ],
    [ u"de",u"Schenefeld",17887,53.6,9.816667 ],
    [ u"de",u"Schermbeck",13758,51.683333,6.866667 ],
    [ u"de",u"Schieder-Schwalenberg",9382,51.883333,9.183333 ],
    [ u"de",u"Schiffdorf",14424,53.533333,8.65 ],
    [ u"de",u"Schifferstadt",18933,49.387222,8.374722 ],
    [ u"de",u"Schiffweiler",17356,49.366667,7.133333 ],
    [ u"de",u"Schkeuditz",19337,51.4,12.216667 ],
    [ u"de",u"Schleiden",13972,50.533333,6.466667 ],
    [ u"de",u"Schleswig",24061,54.516667,9.55 ],
    [ u"de",u"Schlitz",10248,50.666667,9.566667 ],
    [ u"de",u"Schlüchtern",17362,50.35,9.516667 ],
    [ u"de",u"Schmalkalden",17963,50.716667,10.45 ],
    [ u"de",u"Schmallenberg",26218,51.15,8.3 ],
    [ u"de",u"Schmelz",17494,49.433333,6.85 ],
    [ u"de",u"Schmölln",13118,50.9,12.366667 ],
    [ u"de",u"Schneeberg",16833,50.6,12.633333 ],
    [ u"de",u"Schneverdingen",19537,53.116667,9.8 ],
    [ u"de",u"Schönaich",10145,48.65,9.066667 ],
    [ u"de",u"Schönebeck",34358,52.016667,11.75 ],
    [ u"de",u"Schöneiche",11812,52.216667,13.516667 ],
    [ u"de",u"Schongau",12634,47.816667,10.9 ],
    [ u"de",u"Schöningen",13313,52.133333,10.95 ],
    [ u"de",u"Schopfheim",19919,47.65,7.816667 ],
    [ u"de",u"Schorndorf",39919,48.8,9.533333 ],
    [ u"de",u"Schortens",21251,53.533333,7.95 ],
    [ u"de",u"Schotten",11570,50.5,9.133333 ],
    [ u"de",u"Schramberg",18637,48.233333,8.383333 ],
    [ u"de",u"Schriesheim",14448,49.477778,8.672778 ],
    [ u"de",u"Schrobenhausen",16177,48.55,11.266667 ],
    [ u"de",u"Schüttorf",11762,52.316667,7.233333 ],
    [ u"de",u"Schwabach",38921,49.329167,11.025556 ],
    [ u"de",u"Schwäbisch Gmünd",61379,48.8,9.783333 ],
    [ u"de",u"Schwäbisch Hall",36590,49.105833,9.734167 ],
    [ u"de",u"Schwabmünchen",13209,48.183333,10.75 ],
    [ u"de",u"Schwaigern",11032,49.143889,9.055 ],
    [ u"de",u"Schwalbach",14074,50.15,8.533333 ],
    [ u"de",u"Schwalbach",18801,49.3,6.816667 ],
    [ u"de",u"Schwalmstadt",20002,50.933333,9.216667 ],
    [ u"de",u"Schwalmtal",19510,51.216667,6.266667 ],
    [ u"de",u"Schwandorf",28124,49.326389,12.109722 ],
    [ u"de",u"Schwanewede",19985,53.233333,8.6 ],
    [ u"de",u"Schwarzenbach",5074,50.216667,11.933333 ],
    [ u"de",u"Schwarzenbek",15310,53.5,10.483333 ],
    [ u"de",u"Schwarzenberg",18406,50.55,12.783333 ],
    [ u"de",u"Schwedt",40005,53.066667,14.3 ],
    [ u"de",u"Schweinfurt",54801,50.05,10.233333 ],
    [ u"de",u"Schwelm",30470,51.283333,7.283333 ],
    [ u"de",u"Schwerin",96329,53.633333,11.383333 ],
    [ u"de",u"Schwerte",50757,51.45,7.566667 ],
    [ u"de",u"Schwetzingen",23270,49.378056,8.581944 ],
    [ u"de",u"Schwieberdingen",10308,48.883333,9.066667 ],
    [ u"de",u"Sebnitz",9359,50.966667,14.283333 ],
    [ u"de",u"Seeheim-Jugenheim",16776,49.765,8.651944 ],
    [ u"de",u"Seelze",33224,52.4,9.6 ],
    [ u"de",u"Seesen",21976,51.9,10.183333 ],
    [ u"de",u"Seevetal",41557,53.4,9.966667 ],
    [ u"de",u"Sehnde",22400,52.316667,9.95 ],
    [ u"de",u"Selb",17172,50.166667,12.133333 ],
    [ u"de",u"Seligenstadt",19711,50.05,8.983333 ],
    [ u"de",u"Selm",27596,51.7,7.466667 ],
    [ u"de",u"Sendenhorst",13469,51.833333,7.833333 ],
    [ u"de",u"Senden",22199,48.316667,10.066667 ],
    [ u"de",u"Senden",19880,51.85,7.5 ],
    [ u"de",u"Senftenberg",28812,51.516667,14.016667 ],
    [ u"de",u"Siegburg",38818,50.8,7.2 ],
    [ u"de",u"Siegen",108228,50.866667,8.033333 ],
    [ u"de",u"Sigmaringen",17023,48.083333,9.216667 ],
    [ u"de",u"Simbach",10015,48.266667,13.016667 ],
    [ u"de",u"Simmerath",15981,50.6,6.3 ],
    [ u"de",u"Sindelfingen",61686,48.7,9.016667 ],
    [ u"de",u"Singen",46386,47.766667,8.833333 ],
    [ u"de",u"Sinsheim",35740,49.255278,8.877222 ],
    [ u"de",u"Sinzheim",11131,48.766667,8.166667 ],
    [ u"de",u"Sinzig",17708,50.55,7.25 ],
    [ u"de",u"Soest",48720,51.583333,8.116667 ],
    [ u"de",u"Solingen",165192,51.183333,7.083333 ],
    [ u"de",u"Solms",13982,50.766667,9.6 ],
    [ u"de",u"Soltau",22108,52.983333,9.833333 ],
    [ u"de",u"Sömmerda",20872,51.15,11.1 ],
    [ u"de",u"Sondershausen",21954,51.366667,10.866667 ],
    [ u"de",u"Sonneberg",24351,50.35,11.166667 ],
    [ u"de",u"Sonthofen",21512,47.516667,10.283333 ],
    [ u"de",u"Sontra",8618,51.066667,9.933333 ],
    [ u"de",u"Spaichingen",12258,48.083333,8.716667 ],
    [ u"de",u"Spenge",15569,52.133333,8.483333 ],
    [ u"de",u"Spiesen-Elversberg",14633,49.316667,7.133333 ],
    [ u"de",u"Spremberg",28444,51.55,14.366667 ],
    [ u"de",u"Springe",30284,52.216667,9.55 ],
    [ u"de",u"Sprockhövel",26125,51.35,7.25 ],
    [ u"de",u"Stade",45419,53.6,9.483333 ],
    [ u"de",u"Stadtallendorf",21789,50.833333,9.016667 ],
    [ u"de",u"Stadtbergen",14837,48.366667,10.85 ],
    [ u"de",u"Stadthagen",23474,52.316667,9.2 ],
    [ u"de",u"Stadtlohn",20726,51.983333,6.933333 ],
    [ u"de",u"Starnberg",22827,48,11.35 ],
    [ u"de",u"Steinau",11199,50.316667,9.466667 ],
    [ u"de",u"Steinbach",10223,50.166667,8.566667 ],
    [ u"de",u"Steinen",10038,47.647177,7.741135 ],
    [ u"de",u"Steinfurt",34478,52.15,7.35 ],
    [ u"de",u"Steinhagen",20143,52,8.4 ],
    [ u"de",u"Steinheim",11493,48.966667,9.283333 ],
    [ u"de",u"Steinheim",14059,51.85,9.1 ],
    [ u"de",u"Stein",13885,49.416667,11.016667 ],
    [ u"de",u"Stelle",11396,53.383333,10.116667 ],
    [ u"de",u"Stendal",37402,52.6,11.85 ],
    [ u"de",u"Stephanskirchen",9812,47.85,12.183333 ],
    [ u"de",u"Stockach",16800,47.85,9.016667 ],
    [ u"de",u"Stockelsdorf",16449,53.9,10.65 ],
    [ u"de",u"Stolberg",58900,50.766667,6.233333 ],
    [ u"de",u"Stollberg",13304,50.716667,12.8 ],
    [ u"de",u"Straelen",15531,51.45,6.266667 ],
    [ u"de",u"Stralsund",57959,54.3,13.1 ],
    [ u"de",u"Straubing",44504,48.883333,12.566667 ],
    [ u"de",u"Strausberg",26835,52.583333,13.883333 ],
    [ u"de",u"Stuhr",33110,53.033333,8.75 ],
    [ u"de",u"Stuttgart",591688,48.766667,9.183333 ],
    [ u"de",u"Suhl",43269,50.6,10.7 ],
    [ u"de",u"Sulingen",12905,52.683333,8.8 ],
    [ u"de",u"Sulzbach-Rosenberg",20511,49.498333,11.751667 ],
    [ u"de",u"Sulzbach",18802,49.3,7.066667 ],
    [ u"de",u"Sulz",12834,48.366667,8.65 ],
    [ u"de",u"Sundern",29648,51.333333,8 ],
    [ u"de",u"Syke",24084,52.9,8.833333 ],
    [ u"de",u"Tamm",12327,48.916667,9.116667 ],
    [ u"de",u"Tangermünde",9686,52.55,11.95 ],
    [ u"de",u"Tauberbischofsheim",13276,49.624722,9.662778 ],
    [ u"de",u"Taucha",14669,51.383333,12.483333 ],
    [ u"de",u"Taufkirchen",17922,48.05,11.616667 ],
    [ u"de",u"Taunusstein",29461,50.15,8.15 ],
    [ u"de",u"Tecklenburg",9510,52.216667,7.833333 ],
    [ u"de",u"Telgte",19739,51.983333,7.783333 ],
    [ u"de",u"Teltow",19624,52.4,13.266667 ],
    [ u"de",u"Templin",19764,53.116667,13.5 ],
    [ u"de",u"Teningen",11939,48.133333,7.816667 ],
    [ u"de",u"Teterow",9683,53.783333,12.566667 ],
    [ u"de",u"Tettnang",18365,47.666667,9.6 ],
    [ u"de",u"Thale",13544,51.75,11.05 ],
    [ u"de",u"Thalheim",7622,50.7,12.85 ],
    [ u"de",u"Tholey",13266,49.483333,7.066667 ],
    [ u"de",u"Timmendorfer Strand",9090,54,10.783333 ],
    [ u"de",u"Tirschenreuth",9379,49.8825,12.333056 ],
    [ u"de",u"Titisee-Neustadt",12092,47.9,8.166667 ],
    [ u"de",u"Töging",9830,48.25,12.583333 ],
    [ u"de",u"Tönisvorst",30579,51.316667,6.45 ],
    [ u"de",u"Torgau",18883,51.566667,13 ],
    [ u"de",u"Torgelow",10551,53.633333,14.016667 ],
    [ u"de",u"Tornesch",13045,53.7,9.716667 ],
    [ u"de",u"Tostedt",13695,53.283333,9.716667 ],
    [ u"de",u"Traunreut",21535,47.966667,12.6 ],
    [ u"de",u"Traunstein",18275,47.883333,12.65 ],
    [ u"de",u"Trebur",13016,49.931111,8.416111 ],
    [ u"de",u"Treuchtlingen",13208,48.95,10.916667 ],
    [ u"de",u"Trier",100649,49.75,6.633333 ],
    [ u"de",u"Troisdorf",75641,50.816667,7.166667 ],
    [ u"de",u"Trossingen",15123,48.066667,8.65 ],
    [ u"de",u"Trostberg",11640,48.033333,12.55 ],
    [ u"de",u"Tübingen",83815,48.533333,9.05 ],
    [ u"de",u"Tuttlingen",35133,47.983333,8.816667 ],
    [ u"de",u"Tutzing",9411,47.916667,11.283333 ],
    [ u"de",u"Twistringen",12675,52.8,8.65 ],
    [ u"de",u"Übach-Palenberg",25957,50.933333,6.116667 ],
    [ u"de",u"Überherrn",12145,49.25,6.7 ],
    [ u"de",u"Überlingen",21613,47.766667,9.166667 ],
    [ u"de",u"Ubstadt-Weiher",12939,49.170833,8.618889 ],
    [ u"de",u"Ueckermünde",10951,53.733333,14.05 ],
    [ u"de",u"Uelzen",35096,52.966667,10.566667 ],
    [ u"de",u"Uetersen",18155,53.683333,9.666667 ],
    [ u"de",u"Uetze",20477,52.466667,10.2 ],
    [ u"de",u"Uhingen",14220,48.7,9.583333 ],
    [ u"de",u"Ulm",120745,48.4,10 ],
    [ u"de",u"Unna",69138,51.533333,7.683333 ],
    [ u"de",u"Unterhaching",20751,48.05,11.633333 ],
    [ u"de",u"Usingen",13469,50.333333,8.533333 ],
    [ u"de",u"Uslar",15982,51.666667,9.65 ],
    [ u"de",u"Vaihingen",29284,48.933333,8.966667 ],
    [ u"de",u"Vallendar",9055,50.4,7.616667 ],
    [ u"de",u"Varel",25303,53.4,8.133333 ],
    [ u"de",u"Vaterstetten",20962,48.116667,11.783333 ],
    [ u"de",u"Vechelde",16165,52.266667,10.383333 ],
    [ u"de",u"Vechta",30178,52.716667,8.283333 ],
    [ u"de",u"Velbert",88876,51.333333,7.05 ],
    [ u"de",u"Velen",13236,51.9,6.983333 ],
    [ u"de",u"Vellmar",18464,51.35,9.466667 ],
    [ u"de",u"Velten",11697,52.683333,13.183333 ],
    [ u"de",u"Verden",26364,52.916667,9.233333 ],
    [ u"de",u"Verl",24532,51.883333,8.516667 ],
    [ u"de",u"Versmold",21227,52.05,8.15 ],
    [ u"de",u"Vienenburg",11518,51.95,10.566667 ],
    [ u"de",u"Viernheim",32921,49.541667,8.578611 ],
    [ u"de",u"Viersen",76771,51.25,6.383333 ],
    [ u"de",u"Villingen-Schwenningen",82286,48.066667,8.45 ],
    [ u"de",u"Vilsbiburg",11538,48.45,12.35 ],
    [ u"de",u"Vilshofen",16800,48.633333,13.183333 ],
    [ u"de",u"Visselhövede",10757,52.983333,9.6 ],
    [ u"de",u"Vlotho",20219,52.166667,8.85 ],
    [ u"de",u"Voerde",39052,51.6,6.683333 ],
    [ u"de",u"Vöhringen",13092,48.283333,10.083333 ],
    [ u"de",u"Volkach",9424,49.866667,10.233333 ],
    [ u"de",u"Völklingen",41799,49.25,6.85 ],
    [ u"de",u"Vreden",22250,52.033333,6.833333 ],
    [ u"de",u"Wachtberg",20004,50.633333,7.1 ],
    [ u"de",u"Wächtersbach",12497,50.266667,9.3 ],
    [ u"de",u"Wadern",17236,49.533333,6.883333 ],
    [ u"de",u"Wadersloh",13212,51.733333,8.25 ],
    [ u"de",u"Wadgassen",18787,49.266667,6.783333 ],
    [ u"de",u"Waghäusel",19373,49.256389,8.507222 ],
    [ u"de",u"Wahlstedt",9462,53.95,10.216667 ],
    [ u"de",u"Waiblingen",53515,48.833333,9.3 ],
    [ u"de",u"Waldbröl",19660,50.883333,7.616667 ],
    [ u"de",u"Waldheim",9150,51.066667,13.016667 ],
    [ u"de",u"Waldkirchen",10716,48.733333,13.6 ],
    [ u"de",u"Waldkirch",20193,48.1,7.966667 ],
    [ u"de",u"Waldkraiburg",24939,48.216667,12.4 ],
    [ u"de",u"Wald-Michelbach",11447,49.57,8.831667 ],
    [ u"de",u"Waldshut-Tiengen",22648,47.616667,8.216667 ],
    [ u"de",u"Walldorf",14488,49.306389,8.645278 ],
    [ u"de",u"Walldürn",11960,49.583333,9.366667 ],
    [ u"de",u"Wallenhorst",24279,52.35,8.016667 ],
    [ u"de",u"Wallerfangen",9880,49.333333,6.716667 ],
    [ u"de",u"Walsrode",24439,52.866667,9.6 ],
    [ u"de",u"Waltershausen",11345,50.9,10.566667 ],
    [ u"de",u"Waltrop",30150,51.633333,7.4 ],
    [ u"de",u"Warburg",24399,51.5,9.166667 ],
    [ u"de",u"Wardenburg",16019,53.066667,8.2 ],
    [ u"de",u"Warendorf",39281,51.95,7.983333 ],
    [ u"de",u"Waren",21504,53.516667,12.683333 ],
    [ u"de",u"Warstein",29029,51.45,8.366667 ],
    [ u"de",u"Wassenberg",16603,51.1,6.15 ],
    [ u"de",u"Wasserburg",12539,48.066667,12.233333 ],
    [ u"de",u"Wedel",32619,53.583333,9.716667 ],
    [ u"de",u"Weener",15794,53.166667,7.35 ],
    [ u"de",u"Weeze",10371,51.633333,6.2 ],
    [ u"de",u"Wegberg",29931,51.15,6.266667 ],
    [ u"de",u"Wehr",13042,47.633333,7.9 ],
    [ u"de",u"Weida",8355,50.766667,12.066667 ],
    [ u"de",u"Weiden",42387,49.6775,12.156667 ],
    [ u"de",u"Weilburg",13833,50.483333,8.25 ],
    [ u"de",u"Weil der Stadt",19310,48.75,8.866667 ],
    [ u"de",u"Weilerswist",16515,50.766667,6.833333 ],
    [ u"de",u"Weilheim",21635,47.833333,11.15 ],
    [ u"de",u"Weil im Schönbuch",10245,48.616667,9.066667 ],
    [ u"de",u"Weilmünster",9637,50.433333,8.366667 ],
    [ u"de",u"Weimar",65113,50.983333,11.316667 ],
    [ u"de",u"Weingarten",23928,47.8,9.633333 ],
    [ u"de",u"Weinheim",43217,49.548333,8.666111 ],
    [ u"de",u"Weinsberg",11910,49.150278,9.288333 ],
    [ u"de",u"Weiterstadt",24499,49.907778,8.595278 ],
    [ u"de",u"Welver",13142,51.616667,7.966667 ],
    [ u"de",u"Welzheim",11286,48.883333,9.65 ],
    [ u"de",u"Wendelstein",16108,49.353611,11.148333 ],
    [ u"de",u"Wenden",19977,50.966667,7.866667 ],
    [ u"de",u"Wendlingen",16199,48.683333,9.383333 ],
    [ u"de",u"Wennigsen",14122,52.266667,9.583333 ],
    [ u"de",u"Werdau",24299,50.733333,12.383333 ],
    [ u"de",u"Werder",25913,52.383333,12.95 ],
    [ u"de",u"Werdohl",20481,51.266667,7.766667 ],
    [ u"de",u"Werl",32304,51.55,7.916667 ],
    [ u"de",u"Wermelskirchen",36952,51.15,7.216667 ],
    [ u"de",u"Wernau",12668,48.7,9.416667 ],
    [ u"de",u"Werneck",10764,49.983333,10.1 ],
    [ u"de",u"Wernigerode",34674,51.833333,10.783333 ],
    [ u"de",u"Wertheim",24920,49.7575,9.509444 ],
    [ u"de",u"Werther",11910,52.066667,8.416667 ],
    [ u"de",u"Wesel",61768,51.666667,6.616667 ],
    [ u"de",u"Wesseling",36296,50.833333,6.983333 ],
    [ u"de",u"Westerkappeln",11443,52.316667,7.883333 ],
    [ u"de",u"Westerland",8927,54.9,8.3 ],
    [ u"de",u"Westerstede",22209,53.25,7.933333 ],
    [ u"de",u"Wetter",9430,50.9,8.716667 ],
    [ u"de",u"Wetter",29328,51.383333,7.4 ],
    [ u"de",u"Wetzlar",52869,50.55,8.5 ],
    [ u"de",u"Wickede",12681,51.483333,7.866667 ],
    [ u"de",u"Wiefelstede",14816,53.25,8.116667 ],
    [ u"de",u"Wiehl",26784,50.95,7.533333 ],
    [ u"de",u"Wiesbaden",272337,50.083333,8.25 ],
    [ u"de",u"Wiesloch",26642,49.297778,8.701389 ],
    [ u"de",u"Wiesmoor",13180,53.416667,7.733333 ],
    [ u"de",u"Wildberg",10186,48.633333,8.75 ],
    [ u"de",u"Wildeshausen",18276,52.9,8.433333 ],
    [ u"de",u"Wilhelmshaven",84209,53.516667,8.133333 ],
    [ u"de",u"Willich",52100,51.266667,6.55 ],
    [ u"de",u"Wilnsdorf",21498,50.816667,8.1 ],
    [ u"de",u"Winnenden",28230,48.883333,9.4 ],
    [ u"de",u"Winterberg",14603,51.2,8.533333 ],
    [ u"de",u"Wipperfürth",23507,51.116667,7.4 ],
    [ u"de",u"Wismar",45432,53.9,11.466667 ],
    [ u"de",u"Wittenberge",20322,53,11.75 ],
    [ u"de",u"Witten",101122,51.433333,7.333333 ],
    [ u"de",u"Wittingen",12401,52.733333,10.716667 ],
    [ u"de",u"Wittlich",17902,49.983333,6.883333 ],
    [ u"de",u"Wittmund",21417,53.566667,7.783333 ],
    [ u"de",u"Wittstock",19811,53.15,12.5 ],
    [ u"de",u"Witzenhausen",16001,51.333333,9.866667 ],
    [ u"de",u"Wolfenbüttel",54911,52.166667,10.55 ],
    [ u"de",u"Wolfen",25144,51.666667,12.283333 ],
    [ u"de",u"Wolfhagen",13265,51.316667,9.166667 ],
    [ u"de",u"Wolfratshausen",17190,47.916667,11.416667 ],
    [ u"de",u"Wolfsburg",123184,52.433333,10.8 ],
    [ u"de",u"Wolgast",12539,54.05,13.766667 ],
    [ u"de",u"Wolmirstedt",10589,52.25,11.633333 ],
    [ u"de",u"Wolnzach",11071,48.6,11.616667 ],
    [ u"de",u"Worms",82104,49.635556,8.359722 ],
    [ u"de",u"Worpswede",9580,53.216667,8.933333 ],
    [ u"de",u"Wörth",17507,49.058056,8.248611 ],
    [ u"de",u"Wülfrath",22549,51.283333,7.05 ],
    [ u"de",u"Wunsiedel",10319,50.033333,12.016667 ],
    [ u"de",u"Wunstorf",42145,52.433333,9.416667 ],
    [ u"de",u"Wuppertal",363240,51.266667,7.183333 ],
    [ u"de",u"Würselen",37594,50.816667,6.133333 ],
    [ u"de",u"Würzburg",134499,49.787778,9.936111 ],
    [ u"de",u"Wurzen",15066,51.366667,12.733333 ],
    [ u"de",u"Xanten",21294,51.666667,6.45 ],
    [ u"de",u"Zehdenick",16310,52.983333,13.333333 ],
    [ u"de",u"Zeitz",29582,51.05,12.15 ],
    [ u"de",u"Zella-Mehlis",12664,50.65,10.65 ],
    [ u"de",u"Zerbst",16054,51.966667,12.083333 ],
    [ u"de",u"Zetel",12037,53.416667,7.983333 ],
    [ u"de",u"Zeulenroda",13760,50.65,11.983333 ],
    [ u"de",u"Zeven",12577,53.3,9.283333 ],
    [ u"de",u"Zirndorf",25237,49.45,10.95 ],
    [ u"de",u"Zittau",25527,50.9,14.833333 ],
    [ u"de",u"Zschopau",12016,50.75,13.066667 ],
    [ u"de",u"Zülpich",20010,50.7,6.65 ],
    [ u"de",u"Zweibrücken",35970,49.25,7.366667 ],
    [ u"de",u"Zwickau",99343,50.733333,12.5 ],
    [ u"de",u"Zwiesel",10484,49.016667,13.233333 ],
    [ u"de",u"Zwönitz",12424,50.633333,12.8 ],
    [ u"dj",u"Jibuti",623891,11.595,43.1480556 ],
    [ u"dk",u"Aabenraa",16344,55.036217,9.417999 ],
    [ u"dk",u"Aabybro",4849,57.15,9.75 ],
    [ u"dk",u"Aakirkeby",2195,55.068666,14.925412 ],
    [ u"dk",u"Aalborg",122219,57.035498,9.941163 ],
    [ u"dk",u"Aalestrup",2787,56.694701,9.493357 ],
    [ u"dk",u"Aars",7247,56.803809,9.515814 ],
    [ u"dk",u"Aarup",2592,55.37315,10.041314 ],
    [ u"dk",u"Allingåbro",1842,56.464948,10.334087 ],
    [ u"dk",u"Arden",2516,56.768987,9.861842 ],
    [ u"dk",u"Århus",226716,56.153423,10.22553 ],
    [ u"dk",u"Årslev",3228,55.303526,10.46428 ],
    [ u"dk",u"Asnæs",2441,55.812292,11.501293 ],
    [ u"dk",u"Assens",5913,55.271213,9.905333 ],
    [ u"dk",u"Assentoft",2432,56.442095,10.151695 ],
    [ u"dk",u"Augustenborg",3132,54.952008,9.872163 ],
    [ u"dk",u"Aulum",2875,56.26539,8.79256 ],
    [ u"dk",u"Auning",2509,56.430791,10.378184 ],
    [ u"dk",u"Beder",4214,56.056426,10.217645 ],
    [ u"dk",u"Bellinge",4129,55.33535,10.320446 ],
    [ u"dk",u"Billund",6160,55.731157,9.113309 ],
    [ u"dk",u"Birkerød",18901,55.842331,12.433477 ],
    [ u"dk",u"Bjæverskov",2619,55.457556,12.036508 ],
    [ u"dk",u"Bjerringbro",7390,56.377973,9.66065 ],
    [ u"dk",u"Blovstrød",2137,55.870377,12.386399 ],
    [ u"dk",u"Bogense",3410,55.565192,10.092923 ],
    [ u"dk",u"Bording",2104,56.144141,9.276501 ],
    [ u"dk",u"Børkop",3561,55.637935,9.648225 ],
    [ u"dk",u"Borup",3120,55.494716,11.975843 ],
    [ u"dk",u"Brædstrup",3130,55.970793,9.608549 ],
    [ u"dk",u"Bramming",6726,55.469456,8.700074 ],
    [ u"dk",u"Brande",6357,55.938142,9.121783 ],
    [ u"dk",u"Brejning",2220,55.6613,9.677034 ],
    [ u"dk",u"Broager",3376,54.887358,9.680958 ],
    [ u"dk",u"Brønderslev",11671,57.265112,9.959859 ],
    [ u"dk",u"Brørup",4233,55.481936,9.017558 ],
    [ u"dk",u"Brovst",2710,57.095615,9.528007 ],
    [ u"dk",u"Bullerup",2982,55.426861,10.47137 ],
    [ u"dk",u"Christiansfeld",2709,55.358172,9.487014 ],
    [ u"dk",u"Copenhagen",1089958,55.666667,12.583333 ],
    [ u"dk",u"Dianalund",3605,55.531326,11.492499 ],
    [ u"dk",u"Dragør",11045,55.594566,12.668952 ],
    [ u"dk",u"Dronninglund",3084,57.160353,10.29287 ],
    [ u"dk",u"Dybbøl",2303,54.910792,9.736011 ],
    [ u"dk",u"Ebeltoft",5888,56.201801,10.682258 ],
    [ u"dk",u"Egtved",2151,55.617955,9.301021 ],
    [ u"dk",u"Ejby",1987,55.68923,11.847246 ],
    [ u"dk",u"Ejby",1996,55.430102,9.929729 ],
    [ u"dk",u"Esbjerg",72206,55.470276,8.451869 ],
    [ u"dk",u"Espergærde",11358,56,12.566667 ],
    [ u"dk",u"Faaborg",7239,55.09671,10.240669 ],
    [ u"dk",u"Fakse",3747,55.246862,12.117637 ],
    [ u"dk",u"Fakse Ladeplads",2837,55.219805,12.170133 ],
    [ u"dk",u"Farsø",3271,56.772758,9.339255 ],
    [ u"dk",u"Farum",11552,55.809873,12.362286 ],
    [ u"dk",u"Fensmark",4203,55.277637,11.808131 ],
    [ u"dk",u"Fjerritslev",3441,57.081343,9.266428 ],
    [ u"dk",u"Fløng",11108,55.662115,12.186975 ],
    [ u"dk",u"Forlev",2058,55.367176,11.260613 ],
    [ u"dk",u"Framlev",3067,56.148796,10.004024 ],
    [ u"dk",u"Fredensborg",8249,55.973475,12.40386 ],
    [ u"dk",u"Fredericia",36946,55.575781,9.761693 ],
    [ u"dk",u"Frederiksberg",3142,55.416182,11.569336 ],
    [ u"dk",u"Frederikshavn",24103,57.443803,10.547177 ],
    [ u"dk",u"Frederikssund",14564,55.838923,12.067612 ],
    [ u"dk",u"Frederiksværk",12176,55.967671,12.021482 ],
    [ u"dk",u"Frejlev",2286,57.006234,9.81711 ],
    [ u"dk",u"Fuglebjerg",1985,55.303365,11.549197 ],
    [ u"dk",u"Ganløse",2843,55.791236,12.264206 ],
    [ u"dk",u"Gilleleje",5799,56.121959,12.310561 ],
    [ u"dk",u"Gistrup",3622,56.994302,9.990851 ],
    [ u"dk",u"Give",4240,55.839773,9.249978 ],
    [ u"dk",u"Gjellerup Kirkeby",3627,56.143407,9.049882 ],
    [ u"dk",u"Glamsbjerg",3099,55.27237,10.104829 ],
    [ u"dk",u"Gørlev",2269,55.540585,11.228593 ],
    [ u"dk",u"Græsted",3310,56.065579,12.285119 ],
    [ u"dk",u"Gram",2548,55.291189,9.049695 ],
    [ u"dk",u"Gråsten",4022,54.919179,9.595232 ],
    [ u"dk",u"Grenaa",14317,56.41285,10.895649 ],
    [ u"dk",u"Greve Strand",41560,55.583333,12.3 ],
    [ u"dk",u"Grindsted",9414,55.754,8.912307 ],
    [ u"dk",u"Guderup",2424,54.989785,9.871742 ],
    [ u"dk",u"Gundsømagle",2149,55.735649,12.151579 ],
    [ u"dk",u"Haarby",2400,55.215019,10.122624 ],
    [ u"dk",u"Haderslev",20825,55.252434,9.489315 ],
    [ u"dk",u"Hadsten",7020,56.328528,10.048493 ],
    [ u"dk",u"Hadsund",5066,56.720861,10.11403 ],
    [ u"dk",u"Hals",2388,56.996091,10.308066 ],
    [ u"dk",u"Hammel",6138,56.257615,9.863157 ],
    [ u"dk",u"Hammerum",3025,56.133613,9.061214 ],
    [ u"dk",u"Hanstholm",2418,57.116667,8.616667 ],
    [ u"dk",u"Harboøre",1745,56.617356,8.182675 ],
    [ u"dk",u"Hårlev",2423,55.349357,12.233823 ],
    [ u"dk",u"Haslev",10588,55.317917,11.974003 ],
    [ u"dk",u"Havdrup",3828,55.544811,12.123917 ],
    [ u"dk",u"Hedensted",10048,55.770131,9.696694 ],
    [ u"dk",u"Hellebæk",5243,56.068234,12.557821 ],
    [ u"dk",u"Helsinge",7354,56.019659,12.198974 ],
    [ u"dk",u"Helsingør",35048,56.029377,12.586267 ],
    [ u"dk",u"Herning",30329,56.133333,8.983333 ],
    [ u"dk",u"Hillerød",28313,55.933333,12.316667 ],
    [ u"dk",u"Hinnerup",7055,56.266078,10.062993 ],
    [ u"dk",u"Hirtshals",6653,57.588135,9.951498 ],
    [ u"dk",u"Hjallerup",3320,57.164661,10.145708 ],
    [ u"dk",u"Hjørring",24634,57.466323,9.988917 ],
    [ u"dk",u"Hjortshøj",2515,56.24811,10.265325 ],
    [ u"dk",u"Hobro",11064,56.638115,9.795317 ],
    [ u"dk",u"Højby",4406,55.342179,10.436844 ],
    [ u"dk",u"Højslev",1857,56.585648,9.136366 ],
    [ u"dk",u"Holbæk",24544,55.713537,11.716903 ],
    [ u"dk",u"Holeby",1844,54.711475,11.464165 ],
    [ u"dk",u"Holstebro",32072,56.359471,8.620799 ],
    [ u"dk",u"Holsted",3096,55.510864,8.918721 ],
    [ u"dk",u"Høng",3789,55.51027,11.290181 ],
    [ u"dk",u"Hornbæk",3223,56.08541,12.450485 ],
    [ u"dk",u"Hørning",6085,56.087014,10.037162 ],
    [ u"dk",u"Hornslet",4906,56.315496,10.320412 ],
    [ u"dk",u"Horsens",50074,55.865675,9.873531 ],
    [ u"dk",u"Hørsholm",36670,55.88098,12.501106 ],
    [ u"dk",u"Høruphav",2514,54.910167,9.89872 ],
    [ u"dk",u"Hørve",2382,55.75292,11.452976 ],
    [ u"dk",u"Humlebæk",8965,55.961269,12.532432 ],
    [ u"dk",u"Hundested",8615,55.966667,11.866667 ],
    [ u"dk",u"Hurup",2770,56.749436,8.419525 ],
    [ u"dk",u"Hvalsø",3930,55.59575,11.861583 ],
    [ u"dk",u"Hvide Sande",3291,55.996387,8.127307 ],
    [ u"dk",u"Ikast",14692,56.136747,9.160023 ],
    [ u"dk",u"Ishøj",19453,55.618404,12.328128 ],
    [ u"dk",u"Jægerspris",3805,55.855443,11.967863 ],
    [ u"dk",u"Jelling",3059,55.755883,9.425798 ],
    [ u"dk",u"Juelsminde",3667,55.708759,10.016679 ],
    [ u"dk",u"Jyderup",3984,55.663991,11.420289 ],
    [ u"dk",u"Jyllinge",9981,55.758426,12.112271 ],
    [ u"dk",u"Kalundborg",15939,55.681984,11.100426 ],
    [ u"dk",u"Karup",2176,56.309808,9.170866 ],
    [ u"dk",u"Kås",1990,57.197744,9.671734 ],
    [ u"dk",u"Kerteminde",5748,55.450484,10.658433 ],
    [ u"dk",u"Kibæk",2656,56.031701,8.856974 ],
    [ u"dk",u"Kjellerup",4514,56.285809,9.435276 ],
    [ u"dk",u"Klarup",3352,57.011935,10.056171 ],
    [ u"dk",u"Køge",33885,55.460008,12.183415 ],
    [ u"dk",u"Kolding",55363,55.494131,9.458997 ],
    [ u"dk",u"Kolt",5061,56.108448,10.069856 ],
    [ u"dk",u"Korsør",15029,55.326574,11.150012 ],
    [ u"dk",u"Kruså",1694,54.85097,9.40129 ],
    [ u"dk",u"Langå",2710,56.390257,9.89486 ],
    [ u"dk",u"Langeskov",3713,55.356547,10.58447 ],
    [ u"dk",u"Lejre",2036,55.604318,11.974851 ],
    [ u"dk",u"Lillerød",15359,55.868749,12.345809 ],
    [ u"dk",u"Lind",3777,56.1,8.983333 ],
    [ u"dk",u"Liseleje",2906,56.005313,11.948266 ],
    [ u"dk",u"Løgstør",4469,56.962451,9.258304 ],
    [ u"dk",u"Løgten",5048,56.274591,10.31181 ],
    [ u"dk",u"Løgumkloster",3056,55.059411,8.955079 ],
    [ u"dk",u"Løjt Kirkeby",1975,55.083333,9.466667 ],
    [ u"dk",u"Lunderskov",2687,55.48375,9.299174 ],
    [ u"dk",u"Lynge",4284,55.839412,12.277248 ],
    [ u"dk",u"Lystrup",9107,56.237504,10.237777 ],
    [ u"dk",u"Malling",3339,56.036323,10.19632 ],
    [ u"dk",u"Måløv",8513,55.755283,12.323269 ],
    [ u"dk",u"Mariager",2433,56.649851,9.975148 ],
    [ u"dk",u"Maribo",5349,54.775198,11.502437 ],
    [ u"dk",u"Mårslet",2698,56.063605,10.162305 ],
    [ u"dk",u"Marstal",2265,54.856205,10.517255 ],
    [ u"dk",u"Middelfart",13596,55.499223,9.744498 ],
    [ u"dk",u"Munkebo",5225,55.461837,10.555769 ],
    [ u"dk",u"Næstved",40660,55.224898,11.784213 ],
    [ u"dk",u"Nakskov",14081,54.837343,11.12839 ],
    [ u"dk",u"Neder Holluf",5612,55.364514,10.448243 ],
    [ u"dk",u"Neder Vindinge",1900,55.032107,11.883556 ],
    [ u"dk",u"Nexø",3841,55.058981,15.132815 ],
    [ u"dk",u"Nibe",4376,56.981502,9.639167 ],
    [ u"dk",u"Nivå",8035,55.934052,12.50485 ],
    [ u"dk",u"Nødebo",1875,55.978767,12.34685 ],
    [ u"dk",u"Nordborg",7406,55.057319,9.740799 ],
    [ u"dk",u"Nordby",2512,55.446031,8.39786 ],
    [ u"dk",u"Nørre Aaby",2678,55.461074,9.8794 ],
    [ u"dk",u"Nørre Alslev",2128,54.897835,11.884136 ],
    [ u"dk",u"Nyborg",15826,55.305846,10.803394 ],
    [ u"dk",u"Nykøbing",9326,56.791688,8.849895 ],
    [ u"dk",u"Nykøbing",16807,54.7655,11.875085 ],
    [ u"dk",u"Nyråd",2224,55.00511,11.960597 ],
    [ u"dk",u"Odder",11009,55.977212,10.168293 ],
    [ u"dk",u"Odense",145931,55.393475,10.394935 ],
    [ u"dk",u"Oksbøl",2845,55.626805,8.28757 ],
    [ u"dk",u"Ølgod",3891,55.806823,8.628588 ],
    [ u"dk",u"Ølstykke",5348,55.791587,12.145033 ],
    [ u"dk",u"Ørslev",1801,55.043558,11.967918 ],
    [ u"dk",u"Osted",2122,55.562283,11.957861 ],
    [ u"dk",u"Otterup",4522,55.51527,10.397562 ],
    [ u"dk",u"Padborg",4684,54.826572,9.362473 ],
    [ u"dk",u"Pandrup",2942,57.221197,9.67273 ],
    [ u"dk",u"Præstø",3695,55.117772,12.057272 ],
    [ u"dk",u"Randers",55780,56.460704,10.03639 ],
    [ u"dk",u"Ribe",7983,55.329462,8.781352 ],
    [ u"dk",u"Ringe",4849,55.245059,10.470646 ],
    [ u"dk",u"Ringkøbing",9315,56.08642,8.248684 ],
    [ u"dk",u"Ringsted",18794,55.441121,11.809437 ],
    [ u"dk",u"Rødbyhavn",2145,54.654424,11.352033 ],
    [ u"dk",u"Rødby",2379,54.694952,11.38885 ],
    [ u"dk",u"Rødding",2769,55.365691,9.063161 ],
    [ u"dk",u"Rødekro",5452,55.070155,9.31641 ],
    [ u"dk",u"Rønde",2213,56.301453,10.475055 ],
    [ u"dk",u"Rønnede",2395,55.257102,12.021245 ],
    [ u"dk",u"Rønne",13889,55.100907,14.706636 ],
    [ u"dk",u"Roskilde",44285,55.640094,12.08054 ],
    [ u"dk",u"Rudkøbing",4666,54.937994,10.721368 ],
    [ u"dk",u"Ryomgård",1952,56.384305,10.502952 ],
    [ u"dk",u"Ry",4909,56.090375,9.765053 ],
    [ u"dk",u"Sabro",1977,56.213327,10.034414 ],
    [ u"dk",u"Sæby",8435,57.331881,10.52251 ],
    [ u"dk",u"Sakskøbing",4928,54.798046,11.630404 ],
    [ u"dk",u"Seden",3350,55.426479,10.44265 ],
    [ u"dk",u"Silkeborg",38760,56.170146,9.565162 ],
    [ u"dk",u"Sindal",2898,57.476296,10.200914 ],
    [ u"dk",u"Skælskør",6455,55.250578,11.293522 ],
    [ u"dk",u"Skærbæk",3174,55.157353,8.769011 ],
    [ u"dk",u"Skagen",9747,57.726972,10.589686 ],
    [ u"dk",u"Skanderborg",13543,56.031296,9.931704 ],
    [ u"dk",u"Skibby",2661,55.751225,11.960827 ],
    [ u"dk",u"Skive",20815,56.563814,9.040245 ],
    [ u"dk",u"Skjern",7145,55.95,8.5 ],
    [ u"dk",u"Skørping",2722,56.83626,9.892549 ],
    [ u"dk",u"Skovby",2489,56.153396,9.956951 ],
    [ u"dk",u"Slagelse",31896,55.402719,11.354142 ],
    [ u"dk",u"Slangerup",6829,55.85,12.183333 ],
    [ u"dk",u"Smørumnedre",8968,55.742322,12.302763 ],
    [ u"dk",u"Snejbjerg",3513,56.138752,8.898956 ],
    [ u"dk",u"Snoghøj",2371,55.522527,9.721248 ],
    [ u"dk",u"Søften",2030,56.23801,10.085101 ],
    [ u"dk",u"Solbjerg",2964,56.04009,10.093077 ],
    [ u"dk",u"Solrød",14634,55.536009,12.182229 ],
    [ u"dk",u"Sønder Bjert",1815,55.452724,9.56741 ],
    [ u"dk",u"Sønderborg",27033,54.910634,9.792843 ],
    [ u"dk",u"Søndersø",2850,55.485263,10.255404 ],
    [ u"dk",u"Sorø",7167,55.438715,11.560856 ],
    [ u"dk",u"Spentrup",2155,56.537031,10.037917 ],
    [ u"dk",u"Starup",2091,55.24097,9.535032 ],
    [ u"dk",u"Stavnsholt",5658,55.814788,12.405454 ],
    [ u"dk",u"Stavtrup",3519,56.13124,10.119871 ],
    [ u"dk",u"Stege",3881,54.987043,12.284609 ],
    [ u"dk",u"Stenlille",1905,55.540225,11.591458 ],
    [ u"dk",u"Stenløse",13302,55.767676,12.196011 ],
    [ u"dk",u"Stige",2182,55.439413,10.409399 ],
    [ u"dk",u"Stilling",3655,56.062239,9.988215 ],
    [ u"dk",u"Stoholm",2202,56.484541,9.146167 ],
    [ u"dk",u"Store Heddinge",3679,55.309962,12.389795 ],
    [ u"dk",u"Storvorde",2796,57.003916,10.101252 ],
    [ u"dk",u"Støvring",6239,56.890869,9.830965 ],
    [ u"dk",u"Strandby",2518,57.491501,10.496085 ],
    [ u"dk",u"Strib",4339,55.540213,9.767479 ],
    [ u"dk",u"Strøby Egede",2700,55.413822,12.245015 ],
    [ u"dk",u"Struer",11317,56.486241,8.60442 ],
    [ u"dk",u"Stubbekøbing",2301,54.88942,12.040204 ],
    [ u"dk",u"Sundby",2922,54.863996,11.79302 ],
    [ u"dk",u"Sunds",3525,56.204169,9.012656 ],
    [ u"dk",u"Svebölle",2186,55.636785,11.317163 ],
    [ u"dk",u"Svejbæk",3743,56.132548,9.632894 ],
    [ u"dk",u"Svendborg",27553,55.058732,10.591346 ],
    [ u"dk",u"Svenstrup",4550,56.972304,9.848058 ],
    [ u"dk",u"Svinninge",2376,55.721114,11.465466 ],
    [ u"dk",u"Svogerslev",4355,55.634232,12.014654 ],
    [ u"dk",u"Taastrup",30977,55.647521,12.312019 ],
    [ u"dk",u"Tarm",4080,55.908615,8.530412 ],
    [ u"dk",u"Tårs",1856,57.383333,10.116667 ],
    [ u"dk",u"Taulov",2898,55.536919,9.609314 ],
    [ u"dk",u"Thisted",13020,56.958788,8.696409 ],
    [ u"dk",u"Thurø",3350,55.047398,10.663847 ],
    [ u"dk",u"Thyborøn",2587,56.698459,8.21238 ],
    [ u"dk",u"Tinglev",2829,54.93099,9.252433 ],
    [ u"dk",u"Tjæreborg",2146,55.464574,8.579683 ],
    [ u"dk",u"Toftlund",3438,55.18858,9.069251 ],
    [ u"dk",u"Tølløse",3457,55.612505,11.770344 ],
    [ u"dk",u"Tommerup",2072,55.319521,10.206589 ],
    [ u"dk",u"Tønder",7841,54.943118,8.869335 ],
    [ u"dk",u"Tørring",2370,55.853926,9.484182 ],
    [ u"dk",u"Tranbjerg",7307,56.090105,10.11937 ],
    [ u"dk",u"Trige",2475,56.252906,10.148399 ],
    [ u"dk",u"Trørød",8576,55.839465,12.544316 ],
    [ u"dk",u"Tune",5168,55.595283,12.183192 ],
    [ u"dk",u"Ulfborg",1994,56.267253,8.321668 ],
    [ u"dk",u"Ullerslev",2962,55.361722,10.651905 ],
    [ u"dk",u"Ulstrup",1963,56.389942,9.793545 ],
    [ u"dk",u"Vadum",1978,57.117904,9.857 ],
    [ u"dk",u"Værløse",12842,55.725,12.375 ],
    [ u"dk",u"Vamdrup",4685,55.427637,9.284347 ],
    [ u"dk",u"Varde",12735,55.62157,8.48073 ],
    [ u"dk",u"Vejen",8525,55.48117,9.137948 ],
    [ u"dk",u"Vejle",51177,55.708391,9.542763 ],
    [ u"dk",u"Veksø",1921,55.754734,12.238366 ],
    [ u"dk",u"Vestbjerg",2251,57.131656,9.959421 ],
    [ u"dk",u"Vester Hassing",2298,57.067674,10.125581 ],
    [ u"dk",u"Viborg",33844,56.45282,9.404291 ],
    [ u"dk",u"Viby",4505,55.548724,12.023912 ],
    [ u"dk",u"Videbæk",4052,56.087595,8.628517 ],
    [ u"dk",u"Vildbjerg",3773,56.2,8.766667 ],
    [ u"dk",u"Vindeby",2144,55.044891,10.613089 ],
    [ u"dk",u"Vinderup",2991,56.475147,8.790811 ],
    [ u"dk",u"Vindinge",2045,55.622977,12.138696 ],
    [ u"dk",u"Vipperød",2345,55.667675,11.739673 ],
    [ u"dk",u"Virklund",3113,56.132181,9.555824 ],
    [ u"dk",u"Vissenbjerg",3055,55.384825,10.137836 ],
    [ u"dk",u"Vodskov",4406,57.108539,10.022151 ],
    [ u"dk",u"Vojens",8019,55.246393,9.306035 ],
    [ u"dk",u"Vordingborg",8960,54.983333,11.9 ],
    [ u"dk",u"Vrå",2273,57.347626,9.951537 ],
    [ u"dm",u"Atkinson",2506,15.5166667,-61.2666667 ],
    [ u"dm",u"Barroui",1498,15.4333333,-61.45 ],
    [ u"dm",u"Berekua",3195,15.2333333,-61.3166667 ],
    [ u"dm",u"Castle Bruce",1997,15.4333333,-61.2666667 ],
    [ u"dm",u"Coulihaut",1604,15.4833333,-61.4833333 ],
    [ u"dm",u"La Plaine",2504,15.3333333,-61.25 ],
    [ u"dm",u"Mahaut",2405,15.35,-61.4 ],
    [ u"dm",u"Marigot",2907,15.5333333,-61.3 ],
    [ u"dm",u"Pointe Michel",1202,15.25,-61.3833333 ],
    [ u"dm",u"Pont Cassé",702,15.3666667,-61.35 ],
    [ u"dm",u"Portsmouth",3608,15.5833333,-61.4666667 ],
    [ u"dm",u"Roseau",16571,15.3,-61.4 ],
    [ u"dm",u"Wesley",1997,15.5666667,-61.3166667 ],
    [ u"do",u"Azua",59141,18.45,-70.7333333 ],
    [ u"do",u"Bajos de Haina",66810,18.4166667,-70.0333333 ],
    [ u"do",u"Baní",66712,18.2833333,-70.3333333 ],
    [ u"do",u"Barahona",77161,18.2,-71.1 ],
    [ u"do",u"Bayaguana",21059,18.75,-69.6333333 ],
    [ u"do",u"Bonao",73273,18.9333333,-70.4166667 ],
    [ u"do",u"Cabral",12303,18.25,-71.2166667 ],
    [ u"do",u"Comendador",12072,18.8775,-71.7027778 ],
    [ u"do",u"Constanza",29485,18.9166667,-70.75 ],
    [ u"do",u"Cotuí",41643,19.05,-70.15 ],
    [ u"do",u"Dajabón",16402,19.55,-71.7 ],
    [ u"do",u"Duvergé",13405,18.3666667,-71.5166667 ],
    [ u"do",u"El Peñón",4088,18.3,-71.1833333 ],
    [ u"do",u"El Seibo",23554,18.7666667,-69.0333333 ],
    [ u"do",u"Esperanza",42173,19.5833333,-71.0 ],
    [ u"do",u"Fantino",10025,19.1166667,-70.3 ],
    [ u"do",u"Hato Mayor",36002,18.7666667,-69.25 ],
    [ u"do",u"Higüey",123803,18.6166667,-68.7 ],
    [ u"do",u"Jarabacoa",29991,19.1166667,-70.6333333 ],
    [ u"do",u"Jimaní",6567,18.4908333,-71.8508333 ],
    [ u"do",u"La Mata",10295,19.15,-70.65 ],
    [ u"do",u"La Romana",208439,18.4166667,-68.9666667 ],
    [ u"do",u"Las Guáranas",9588,19.2,-70.2166667 ],
    [ u"do",u"Las Matas de Farfán",21803,18.8736111,-71.5213889 ],
    [ u"do",u"La Vega",102431,19.2166667,-70.5166667 ],
    [ u"do",u"Maimón",15297,19.8,-70.7833333 ],
    [ u"do",u"Mao",48297,19.5666667,-71.0833333 ],
    [ u"do",u"Moca",61838,19.4166667,-70.5666667 ],
    [ u"do",u"Monte Cristi",17001,19.8666667,-71.65 ],
    [ u"do",u"Monte Plata",15533,18.8,-69.7833333 ],
    [ u"do",u"Nagua",33863,19.3833333,-69.8333333 ],
    [ u"do",u"Neiba",18675,18.4666667,-71.4166667 ],
    [ u"do",u"Pedernales",11071,18.0333333,-71.75 ],
    [ u"do",u"Pimentel",9550,19.1833333,-70.1 ],
    [ u"do",u"Puerto Plata",119908,19.8,-70.6833333 ],
    [ u"do",u"Quisqueya",17697,18.55,-69.4166667 ],
    [ u"do",u"Sabana Grande de Boyá",16835,18.95,-69.8 ],
    [ u"do",u"Salcedo",11676,19.3833333,-70.4166667 ],
    [ u"do",u"Samaná",11433,19.2166667,-69.3166667 ],
    [ u"do",u"Sánchez",11368,19.2333333,-69.6 ],
    [ u"do",u"San Cristóbal",154045,18.4166667,-70.1 ],
    [ u"do",u"San Francisco de Macorís",124772,19.3,-70.25 ],
    [ u"do",u"San Ignacio de Sabaneta",16381,19.4666667,-71.3333333 ],
    [ u"do",u"San José de Ocoa",21149,18.55,-70.5 ],
    [ u"do",u"San Juan de la Maguana",72952,18.8,-71.2333333 ],
    [ u"do",u"San Pedro de Macorís",217901,18.45,-69.3 ],
    [ u"do",u"Santiago",555911,19.45,-70.7 ],
    [ u"do",u"Santo Domingo",2202016,18.4666667,-69.9 ],
    [ u"do",u"Sosúa",9483,19.75,-70.5166667 ],
    [ u"do",u"Tamayo",6431,18.4,-71.2 ],
    [ u"do",u"Tamboril",23305,19.4833333,-70.6 ],
    [ u"do",u"Villa Altagracia",40029,18.6666667,-70.1666667 ],
    [ u"do",u"Villa Bisonó",33141,19.5666667,-70.8666667 ],
    [ u"do",u"Villa Vázquez",11645,19.75,-71.45 ],
    [ u"dz",u"Adrar",89441,27.9,-0.2833333 ],
    [ u"dz",u"Aflu",84998,34.1088889,2.1019444 ],
    [ u"dz",u"Algiers",1980242,36.7630556,3.0505556 ],
    [ u"dz",u"Birin",51460,35.635,3.225 ],
    [ u"dz",u"Constantine",450126,36.365,6.6147222 ],
    [ u"dz",u"Médéa",147710,36.2675,2.75 ],
    [ u"dz",u"Sidi Ali",25309,36.1005556,0.42 ],
    [ u"dz",u"Tazmalt",21497,36.3872222,4.4016667 ],
    [ u"dz",u"Tigzirt",19748,36.8938889,4.1225 ],
    [ u"dz",u"Timizart",41398,36.8,4.2666667 ],
    [ u"dz",u"Tuggurt",49051,33.1,6.0666667 ],
    [ u"dz",u"Wahran",646025,35.6911111,-0.6416667 ],
    [ u"dz",u"Warqla",150611,31.9575,5.3277778 ],
    [ u"ec",u"Alamor",6391,-4.0333333,-80.0333333 ],
    [ u"ec",u"Alausí",14294,-2.2,-78.8333333 ],
    [ u"ec",u"Alfredo Baquerizo Moreno",12617,-1.9166667,-79.5166667 ],
    [ u"ec",u"Ambato",154369,-1.25,-78.6166667 ],
    [ u"ec",u"Archidona",7309,-0.9166667,-77.8 ],
    [ u"ec",u"Arenillas",15852,-3.55,-80.0666667 ],
    [ u"ec",u"Atuntaqui",17456,0.3333333,-78.2166667 ],
    [ u"ec",u"Azogues",34877,-2.7333333,-78.8333333 ],
    [ u"ec",u"Babahoyo",76279,-1.8166667,-79.5166667 ],
    [ u"ec",u"Bahía de Caráquez",37056,-0.6,-80.4166667 ],
    [ u"ec",u"Balao",12205,-2.7333333,-79.75 ],
    [ u"ec",u"Baños",9501,-1.4,-78.4166667 ],
    [ u"ec",u"Calceta",17286,-0.85,-80.1666667 ],
    [ u"ec",u"Cañar",9900,-2.55,-78.9333333 ],
    [ u"ec",u"Cariamanga",16862,-4.3333333,-79.55 ],
    [ u"ec",u"Catacocha",10872,-4.0666667,-79.6333333 ],
    [ u"ec",u"Catamayo",18565,-3.9833333,-79.35 ],
    [ u"ec",u"Catarama",9723,-1.5833333,-79.4666667 ],
    [ u"ec",u"Cayambe",26582,0.05,-78.1333333 ],
    [ u"ec",u"Celica",5499,-4.1166667,-79.95 ],
    [ u"ec",u"Chone",44751,-0.6833333,-80.1 ],
    [ u"ec",u"Colimes",9384,-1.55,-80.0166667 ],
    [ u"ec",u"Coronel Maridueña",7303,-2.2,-79.4166667 ],
    [ u"ec",u"Cotacachi",8238,0.3,-78.2666667 ],
    [ u"ec",u"Cuenca",276964,-2.8833333,-78.9833333 ],
    [ u"ec",u"Daule",48505,-1.8666667,-79.9333333 ],
    [ u"ec",u"El Ángel",3983,0.6166667,-77.9333333 ],
    [ u"ec",u"El Carmen",63371,-1.3166667,-80.0166667 ],
    [ u"ec",u"El Triunfo",32282,-1.9333333,-79.9666667 ],
    [ u"ec",u"Esmeraldas",95630,0.9833333,-79.7 ],
    [ u"ec",u"Gualaceo",17122,-2.9,-78.7833333 ],
    [ u"ec",u"Gualaquiza",4611,-3.4,-78.55 ],
    [ u"ec",u"Guano",12659,-1.5833333,-78.6333333 ],
    [ u"ec",u"Guaranda",22199,-1.6,-79.0 ],
    [ u"ec",u"Guayaquil",1952029,-2.1666667,-79.9 ],
    [ u"ec",u"Huaquillas",39757,-3.4833333,-80.2333333 ],
    [ u"ec",u"Ibarra",108666,0.35,-78.1166667 ],
    [ u"ec",u"Jipijapa",35901,-1.3333333,-80.5833333 ],
    [ u"ec",u"Junín",9128,-0.9333333,-80.2166667 ],
    [ u"ec",u"La Libertad",75881,-2.2333333,-80.9 ],
    [ u"ec",u"La Maná",16450,-0.9333333,-79.2166667 ],
    [ u"ec",u"Latacunga",51717,-0.9333333,-78.6166667 ],
    [ u"ec",u"La Troncal",36353,-2.4,-79.3333333 ],
    [ u"ec",u"Loja",117796,-4.0,-79.2166667 ],
    [ u"ec",u"Lomas de Sargentillo",7542,-1.8833333,-80.0833333 ],
    [ u"ec",u"Macará",13035,-4.3833333,-79.95 ],
    [ u"ec",u"Macas",23687,-2.3166667,-78.1166667 ],
    [ u"ec",u"Machachi",25742,-0.5,-78.5666667 ],
    [ u"ec",u"Machala",198123,-3.2666667,-79.9666667 ],
    [ u"ec",u"Manta",183166,-0.95,-80.7333333 ],
    [ u"ec",u"Milagro",110093,-2.0666667,-79.5333333 ],
    [ u"ec",u"Montalvo",15547,-1.8,-79.3333333 ],
    [ u"ec",u"Montecristi",18351,-1.05,-80.6666667 ],
    [ u"ec",u"Muisne",13393,0.6080556,-80.0441667 ],
    [ u"ec",u"Naranjal",32045,-2.6666667,-79.6166667 ],
    [ u"ec",u"Naranjito",34206,-2.2166667,-79.4833333 ],
    [ u"ec",u"Nueva Loja",24211,0.0847222,-76.8827778 ],
    [ u"ec",u"Otavalo",32330,0.2333333,-78.2666667 ],
    [ u"ec",u"Paján",9183,-1.5666667,-80.4166667 ],
    [ u"ec",u"Palenque",9083,-1.45,-79.7333333 ],
    [ u"ec",u"Palestina",9364,-1.9333333,-79.7333333 ],
    [ u"ec",u"Palora",6472,-1.7,-77.9333333 ],
    [ u"ec",u"Pasaje",44860,-3.3333333,-79.8166667 ],
    [ u"ec",u"Pedernales",5983,0.0833333,-80.05 ],
    [ u"ec",u"Pedro Carbo",23372,-1.8333333,-80.2333333 ],
    [ u"ec",u"Pelileo",16572,-1.3166667,-78.5333333 ],
    [ u"ec",u"Píllaro",7462,-1.1666667,-78.5333333 ],
    [ u"ec",u"Pimampiro",7408,0.4,-77.9666667 ],
    [ u"ec",u"Piñas",16981,-3.6666667,-79.65 ],
    [ u"ec",u"Playas",30564,-2.6333333,-80.3833333 ],
    [ u"ec",u"Portovelo",9708,-3.7166667,-79.6166667 ],
    [ u"ec",u"Portoviejo",170326,-1.05,-80.45 ],
    [ u"ec",u"Puebloviejo",10335,-3.7333333,-79.2833333 ],
    [ u"ec",u"Puerto Ayora",8996,-0.75,-90.3166667 ],
    [ u"ec",u"Puerto Baquerizo Moreno",4214,-0.9,-89.6 ],
    [ u"ec",u"Pujilí",16168,-0.95,-78.6833333 ],
    [ u"ec",u"Puyo",24881,-1.4666667,-77.9833333 ],
    [ u"ec",u"Quevedo",119436,-1.0333333,-79.45 ],
    [ u"ec",u"Quito",1399814,-0.2166667,-78.5 ],
    [ u"ec",u"Riobamba",124478,-1.6666667,-78.6333333 ],
    [ u"ec",u"Rocafuerte",10274,-0.9166667,-80.4333333 ],
    [ u"ec",u"Rosa Zárate",42121,0.3333333,-79.4666667 ],
    [ u"ec",u"Salinas",43862,-2.2166667,-80.9666667 ],
    [ u"ec",u"Samborondón",24118,-1.95,-79.7333333 ],
    [ u"ec",u"San Cristóbal",6164,-0.9166667,-89.5666667 ],
    [ u"ec",u"San Gabriel",15112,0.6,-77.8166667 ],
    [ u"ec",u"Sangolquí",5114,-0.3166667,-78.45 ],
    [ u"ec",u"San Lorenzo",20209,1.2883333,-78.8369444 ],
    [ u"ec",u"San Miguel",12575,-1.7,-79.0333333 ],
    [ u"ec",u"San Miguel",10838,-1.0333333,-78.5666667 ],
    [ u"ec",u"Santa Ana",12833,-1.2166667,-80.3833333 ],
    [ u"ec",u"Santa Elena",42214,-2.2333333,-80.85 ],
    [ u"ec",u"Santa Lucía",12523,-2.1833333,-80.0 ],
    [ u"ec",u"Santa Rosa",41816,-3.45,-79.9666667 ],
    [ u"ec",u"Santo Domingo",200421,-0.25,-79.15 ],
    [ u"ec",u"Saquisilí",3778,-0.8333333,-78.6666667 ],
    [ u"ec",u"Sucre",15286,-1.2666667,-80.4333333 ],
    [ u"ec",u"Sucúa",7413,-2.4666667,-78.1666667 ],
    [ u"ec",u"Tena",17172,-0.9833333,-77.8166667 ],
    [ u"ec",u"Tosagua",14680,-0.7833333,-80.25 ],
    [ u"ec",u"Valdez",11441,1.2491667,-78.9830556 ],
    [ u"ec",u"Velasco Ibarra",48754,-1.05,-79.6166667 ],
    [ u"ec",u"Ventanas",46708,-1.45,-79.4666667 ],
    [ u"ec",u"Vinces",32497,-1.55,-79.7333333 ],
    [ u"ec",u"Yaguachi",27947,-2.1166667,-79.6833333 ],
    [ u"ec",u"Yantzaza",9970,-3.8277778,-78.7594444 ],
    [ u"ec",u"Zamora",15276,-4.0691667,-78.9566667 ],
    [ u"ec",u"Zaruma",12505,-3.6833333,-79.6166667 ],
    [ u"ee",u"Aakre",295,58.1013889,26.1944444 ],
    [ u"ee",u"Ääsmäe",638,59.2380556,24.5086111 ],
    [ u"ee",u"Aaspere",315,59.4169444,26.1172222 ],
    [ u"ee",u"Abja-Paluoja",1372,58.1252778,25.3497222 ],
    [ u"ee",u"Adavere",646,58.7061111,25.8991667 ],
    [ u"ee",u"Aegviidu",910,59.2858333,25.6141667 ],
    [ u"ee",u"Ahja",616,58.2038889,27.0733333 ],
    [ u"ee",u"Ahula",329,59.1091667,25.7388889 ],
    [ u"ee",u"Äksi",453,58.5269444,26.6441667 ],
    [ u"ee",u"Alatskivi",430,58.5980556,27.1336111 ],
    [ u"ee",u"Alavere",427,59.2433333,25.3244444 ],
    [ u"ee",u"Albu",349,59.1505556,25.6669444 ],
    [ u"ee",u"Alliku",220,59.3538889,24.55 ],
    [ u"ee",u"Ämari",579,59.3666667,24.5833333 ],
    [ u"ee",u"Ambla",352,59.1911111,25.8455556 ],
    [ u"ee",u"Annikoru",329,58.2672222,26.3005556 ],
    [ u"ee",u"Antsla",1468,57.8255556,26.5405556 ],
    [ u"ee",u"Aravete",955,59.1416667,25.7613889 ],
    [ u"ee",u"Aravu",144,58.2313889,27.3858333 ],
    [ u"ee",u"Ardu",559,59.1005556,25.3708333 ],
    [ u"ee",u"Are",408,58.5216667,24.5675 ],
    [ u"ee",u"Aruküla",1829,59.3644444,25.0772222 ],
    [ u"ee",u"Aseri",1831,59.4505556,26.8675 ],
    [ u"ee",u"Assaku",402,59.3775,24.8447222 ],
    [ u"ee",u"Aste",546,58.3436111,22.4588889 ],
    [ u"ee",u"Audru",1430,58.4086111,24.3738889 ],
    [ u"ee",u"Avinurme",779,58.9822222,26.8641667 ],
    [ u"ee",u"Eidapere",325,58.7513889,24.9427778 ],
    [ u"ee",u"Elva",5820,58.2225,26.4211111 ],
    [ u"ee",u"Erastvere",311,57.9697222,26.7938889 ],
    [ u"ee",u"Esku",413,58.6475,25.8830556 ],
    [ u"ee",u"Essu",302,59.4325,26.365 ],
    [ u"ee",u"Haabneeme",2077,59.5113889,24.8211111 ],
    [ u"ee",u"Häädemeeste",851,58.0813889,24.5102778 ],
    [ u"ee",u"Haage",370,58.365,26.6272222 ],
    [ u"ee",u"Haapsalu",11805,58.9430556,23.5413889 ],
    [ u"ee",u"Habaja",345,59.0994444,25.1752778 ],
    [ u"ee",u"Haiba",395,59.1266667,24.4672222 ],
    [ u"ee",u"Haljala",1233,59.4336111,26.2613889 ],
    [ u"ee",u"Halliste",362,58.3366667,25.0983333 ],
    [ u"ee",u"Harju-Risti",387,59.2341667,24.0183333 ],
    [ u"ee",u"Harku",781,59.1325,24.3711111 ],
    [ u"ee",u"Harkujärve",453,59.4172222,24.5872222 ],
    [ u"ee",u"Helme",407,58.0119444,25.8972222 ],
    [ u"ee",u"Himmaste",545,58.0769444,27.0741667 ],
    [ u"ee",u"Hulja",569,59.3522222,26.2141667 ],
    [ u"ee",u"Hummuli",404,57.9036111,26.0583333 ],
    [ u"ee",u"Hüüru",349,59.3819444,24.5297222 ],
    [ u"ee",u"Ignase",106,58.2611111,26.8469444 ],
    [ u"ee",u"Iisaku",916,59.1013889,27.3080556 ],
    [ u"ee",u"Ilmatsalu",512,58.3863889,26.5466667 ],
    [ u"ee",u"Imavere",486,58.7330556,25.7725 ],
    [ u"ee",u"Jämejala",294,58.3894444,25.5661111 ],
    [ u"ee",u"Jäneda",448,59.2458333,25.7044444 ],
    [ u"ee",u"Järva-Jaani",1051,59.0386111,25.8863889 ],
    [ u"ee",u"Järvakandi",1471,58.7788889,24.8258333 ],
    [ u"ee",u"Jarve",682,59.3986111,27.2730556 ],
    [ u"ee",u"Jõesuu",393,58.4927778,24.9113889 ],
    [ u"ee",u"Jõgeva",6396,58.7466667,26.3938889 ],
    [ u"ee",u"Jõhvi",11469,59.3591667,27.4211111 ],
    [ u"ee",u"Jõõpre",448,58.4733333,24.3241667 ],
    [ u"ee",u"Jüri",2581,59.3541667,24.8941667 ],
    [ u"ee",u"Juuru",571,59.0647222,24.9502778 ],
    [ u"ee",u"Kaagjärve",317,57.7672222,26.1772222 ],
    [ u"ee",u"Kääpa",306,57.8708333,27.1063889 ],
    [ u"ee",u"Käärdi",573,58.2080556,26.4113889 ],
    [ u"ee",u"Kaarepere",334,58.6633333,26.5269444 ],
    [ u"ee",u"Kabala",366,58.6897222,25.6272222 ],
    [ u"ee",u"Kabli",365,58.3358333,24.7361111 ],
    [ u"ee",u"Kadrina",2406,59.3347222,26.145 ],
    [ u"ee",u"Kaerepere",544,58.9655556,24.8436111 ],
    [ u"ee",u"Käina",854,58.8255556,22.7897222 ],
    [ u"ee",u"Kaiu",595,59.0105556,25.0597222 ],
    [ u"ee",u"Kallaste",1171,58.655,27.1591667 ],
    [ u"ee",u"Kambja",722,58.2305556,26.7005556 ],
    [ u"ee",u"Kanepi",638,57.9830556,26.7563889 ],
    [ u"ee",u"Käravete",295,59.1911111,25.7541667 ],
    [ u"ee",u"Kärdla",3763,58.9977778,22.7491667 ],
    [ u"ee",u"Karjaküla",362,59.3402778,24.3855556 ],
    [ u"ee",u"Karksi",528,58.1033333,25.5627778 ],
    [ u"ee",u"Karksi-Nuia",1986,58.1033333,25.5627778 ],
    [ u"ee",u"Kärla",988,58.3358333,22.2597222 ],
    [ u"ee",u"Kärstna",300,58.145,25.81 ],
    [ u"ee",u"Käru",460,58.8338889,25.1480556 ],
    [ u"ee",u"Kauksi",317,58.0883333,27.2205556 ],
    [ u"ee",u"Keava",294,58.9463889,24.9033333 ],
    [ u"ee",u"Keeni",351,57.9538889,26.2797222 ],
    [ u"ee",u"Kehra",3183,59.3361111,25.3211111 ],
    [ u"ee",u"Kehtna",1579,58.9302778,24.8780556 ],
    [ u"ee",u"Keila-Joa",378,59.3997222,24.3044444 ],
    [ u"ee",u"Keila",9411,59.3036111,24.4130556 ],
    [ u"ee",u"Kihelkonna",476,58.3522222,22.0469444 ],
    [ u"ee",u"Kiili",942,59.3069444,24.8377778 ],
    [ u"ee",u"Kiisa",551,59.2369444,24.6888889 ],
    [ u"ee",u"Kiiu",833,59.4477778,25.3794444 ],
    [ u"ee",u"Kilingi-Nõmme",2175,58.1502778,24.9641667 ],
    [ u"ee",u"Kiviõli",6953,59.3530556,26.9711111 ],
    [ u"ee",u"Kivi-Vigala",293,58.7152778,24.3769444 ],
    [ u"ee",u"Klooga",983,59.3197222,24.2113889 ],
    [ u"ee",u"Kobela",468,57.8419444,26.4638889 ],
    [ u"ee",u"Kodila",336,59.0425,24.6683333 ],
    [ u"ee",u"Koeru",1300,58.9630556,26.0308333 ],
    [ u"ee",u"Kohila",3355,59.1680556,24.7575 ],
    [ u"ee",u"Kohtla-Järve",46060,59.3986111,27.2730556 ],
    [ u"ee",u"Kohtla-Nõmme",1075,59.3516667,27.175 ],
    [ u"ee",u"Koigi",448,59.1716667,25.9730556 ],
    [ u"ee",u"Kolga-Jaani",420,58.5330556,25.9458333 ],
    [ u"ee",u"Kolga",520,59.4866667,25.6191667 ],
    [ u"ee",u"Kolkja",397,58.5455556,27.215 ],
    [ u"ee",u"Kollino",301,57.8158333,26.5588889 ],
    [ u"ee",u"Koluvere",494,58.9052778,24.1083333 ],
    [ u"ee",u"Kõo",318,58.6291667,25.7211111 ],
    [ u"ee",u"Koonga",303,58.5825,24.1541667 ],
    [ u"ee",u"Koosa",548,58.52,27.0741667 ],
    [ u"ee",u"Kõpu",363,58.3269444,25.3116667 ],
    [ u"ee",u"Kõrveküla",571,58.4241667,26.7822222 ],
    [ u"ee",u"Kose",2232,59.4580556,24.8783333 ],
    [ u"ee",u"Kose",549,57.8127778,27.0369444 ],
    [ u"ee",u"Kose-Uuemõisa",980,59.2,25.1052778 ],
    [ u"ee",u"Kostivere",790,59.4255556,25.1036111 ],
    [ u"ee",u"Krootuse",417,58.0711111,26.835 ],
    [ u"ee",u"Kudjape",450,58.2552778,22.5491667 ],
    [ u"ee",u"Kuimetsa",385,59.0433333,25.1252778 ],
    [ u"ee",u"Külitse",361,58.3230556,26.6122222 ],
    [ u"ee",u"Kullamaa",332,58.8788889,24.0816667 ],
    [ u"ee",u"Kumna",315,59.325,24.4388889 ],
    [ u"ee",u"Kunda",3764,59.4833333,26.5333333 ],
    [ u"ee",u"Kuremaa",594,58.7366667,26.5225 ],
    [ u"ee",u"Kuremäe",369,59.2025,27.5363889 ],
    [ u"ee",u"Kuressaare",14922,58.2480556,22.5038889 ],
    [ u"ee",u"Kurtna",331,59.2313889,24.7183333 ],
    [ u"ee",u"Kuusalu",1238,59.4438889,25.4413889 ],
    [ u"ee",u"Laagri",4135,59.3513889,24.5988889 ],
    [ u"ee",u"Laekvere",472,59.0655556,26.5655556 ],
    [ u"ee",u"Laeva",468,58.4919444,26.3616667 ],
    [ u"ee",u"Lagedi",939,59.4055556,24.9422222 ],
    [ u"ee",u"Lähte",487,58.4891667,26.6702778 ],
    [ u"ee",u"Laiuse",461,58.7880556,26.4841667 ],
    [ u"ee",u"Lasva",309,57.8627778,27.1841667 ],
    [ u"ee",u"Lavassaare",548,58.5113889,24.3888889 ],
    [ u"ee",u"Lehola",530,59.2925,24.3113889 ],
    [ u"ee",u"Lehtmetsa",789,59.32,25.3569444 ],
    [ u"ee",u"Lehtse",493,59.2494444,25.8230556 ],
    [ u"ee",u"Leie",284,58.42,26.0258333 ],
    [ u"ee",u"Leisi",329,58.5705556,22.6969444 ],
    [ u"ee",u"Lelle",431,58.8636111,25.0044444 ],
    [ u"ee",u"Libatse",488,58.6588889,24.4830556 ],
    [ u"ee",u"Lihula",1457,58.6813889,23.8452778 ],
    [ u"ee",u"Linna",456,58.0316667,25.8525 ],
    [ u"ee",u"Linnamäe",460,58.9961111,23.7069444 ],
    [ u"ee",u"Linte",286,58.1552778,27.4591667 ],
    [ u"ee",u"Lohkva",776,58.3691667,26.7980556 ],
    [ u"ee",u"Lohusuu",394,58.9436111,27.045 ],
    [ u"ee",u"Loksa",3463,59.5763889,25.7213889 ],
    [ u"ee",u"Loo",2175,59.4363889,24.9483333 ],
    [ u"ee",u"Lüganuse",454,59.3805556,27.0302778 ],
    [ u"ee",u"Luige",562,59.3388889,24.7616667 ],
    [ u"ee",u"Luke",335,58.2402778,26.5366667 ],
    [ u"ee",u"Lüllemäe",290,57.7511111,26.3838889 ],
    [ u"ee",u"Lustivere",477,58.6669444,26.0836111 ],
    [ u"ee",u"Luua",432,58.6513889,26.5972222 ],
    [ u"ee",u"Luunja",579,58.3558333,26.8808333 ],
    [ u"ee",u"Maardu",16630,59.4280556,25.025 ],
    [ u"ee",u"Mäetaguse",542,59.2297222,27.2722222 ],
    [ u"ee",u"Mammaste",616,58.0666667,27.0452778 ],
    [ u"ee",u"Märjamaa",3063,58.9038889,24.4305556 ],
    [ u"ee",u"Melliste",484,58.3288889,26.9813889 ],
    [ u"ee",u"Miiduranna",399,59.5002778,24.8208333 ],
    [ u"ee",u"Mikitamäe",345,58.0008333,27.5480556 ],
    [ u"ee",u"Misso",324,57.6022222,27.2377778 ],
    [ u"ee",u"Mõisaküla",1090,58.0922222,25.1863889 ],
    [ u"ee",u"Mooste",450,58.1561111,27.1927778 ],
    [ u"ee",u"Muraste",337,59.4572222,24.4308333 ],
    [ u"ee",u"Mustjala",295,58.4613889,22.2416667 ],
    [ u"ee",u"Mustla",928,58.1341667,25.1002778 ],
    [ u"ee",u"Mustvee",1662,58.8486111,26.9397222 ],
    [ u"ee",u"Näpi",404,59.3647222,26.4025 ],
    [ u"ee",u"Narva-Jõesuu",2802,59.4588889,28.0408333 ],
    [ u"ee",u"Narva",66980,59.3772222,28.1902778 ],
    [ u"ee",u"Nasva",330,58.2294444,22.385 ],
    [ u"ee",u"Nõo",1476,58.2755556,26.5375 ],
    [ u"ee",u"Oisu",418,58.7536111,25.565 ],
    [ u"ee",u"Õisu",351,58.1972222,25.5502778 ],
    [ u"ee",u"Olgina",504,59.3952778,28.1252778 ],
    [ u"ee",u"Olustvere",647,58.5536111,25.5627778 ],
    [ u"ee",u"Orava",300,57.8966667,27.4591667 ],
    [ u"ee",u"Orgita",540,58.9286111,24.4288889 ],
    [ u"ee",u"Orissaare",1065,58.5597222,23.0930556 ],
    [ u"ee",u"Oru",394,59.1877778,24.9805556 ],
    [ u"ee",u"Osula",335,57.8858333,26.8197222 ],
    [ u"ee",u"Otepää",351,58.0583333,26.4966667 ],
    [ u"ee",u"Padise",392,59.2311111,24.1405556 ],
    [ u"ee",u"Paide",9735,58.8855556,25.5572222 ],
    [ u"ee",u"Paikuse",1996,58.3791667,24.6344444 ],
    [ u"ee",u"Paistu",346,58.2705556,25.6227778 ],
    [ u"ee",u"Pajusti",756,59.2744444,26.4233333 ],
    [ u"ee",u"Palamuse",541,58.685,26.5788889 ],
    [ u"ee",u"Paldiski",4202,59.3566667,24.0530556 ],
    [ u"ee",u"Palivere",968,58.9702778,23.9033333 ],
    [ u"ee",u"Panga",290,58.8166667,23.55 ],
    [ u"ee",u"Papsaare",497,58.4047222,24.4069444 ],
    [ u"ee",u"Päri",475,58.3452778,25.5033333 ],
    [ u"ee",u"Parksepa",737,57.9097222,26.9830556 ],
    [ u"ee",u"Pärnu-Jaagupi",1341,58.6058333,24.5152778 ],
    [ u"ee",u"Pärnu",44193,58.3747222,24.5136111 ],
    [ u"ee",u"Peetri",824,59.3941667,24.8133333 ],
    [ u"ee",u"Peetri",307,58.95,25.8333333 ],
    [ u"ee",u"Piira",371,59.3102778,26.3938889 ],
    [ u"ee",u"Pisisaare",300,58.7238889,25.9683333 ],
    [ u"ee",u"Põlgaste",372,57.9802778,26.88 ],
    [ u"ee",u"Põltsamaa",4764,58.6525,25.9705556 ],
    [ u"ee",u"Põlva",6504,58.0602778,27.0694444 ],
    [ u"ee",u"Prillimäe",406,59.1883333,24.805 ],
    [ u"ee",u"Pringi",603,59.5394444,24.7938889 ],
    [ u"ee",u"Puhja",1072,58.3419444,26.3147222 ],
    [ u"ee",u"Puiatu",291,58.3616667,25.4205556 ],
    [ u"ee",u"Puiga",332,57.7961111,27.0388889 ],
    [ u"ee",u"Puka",748,58.0497222,26.2263889 ],
    [ u"ee",u"Purtse",298,59.4188889,27.0163889 ],
    [ u"ee",u"Püssi",1840,59.36,27.0497222 ],
    [ u"ee",u"Püünsi",729,59.5508333,24.7958333 ],
    [ u"ee",u"Puurmani",646,58.5783333,26.2752778 ],
    [ u"ee",u"Raasiku",1317,59.3663889,25.1830556 ],
    [ u"ee",u"Rahinge",346,58.3844444,26.6105556 ],
    [ u"ee",u"Raikküla",301,58.9386111,24.7613889 ],
    [ u"ee",u"Raja",469,58.7963889,26.9497222 ],
    [ u"ee",u"Rakke",1045,58.9816667,26.2544444 ],
    [ u"ee",u"Rakvere",16736,59.3463889,26.3558333 ],
    [ u"ee",u"Ramsi",732,58.3058333,25.5352778 ],
    [ u"ee",u"Randvere",513,59.5088889,24.8997222 ],
    [ u"ee",u"Räni",498,58.3575,26.6505556 ],
    [ u"ee",u"Rannu",439,58.2366667,26.2180556 ],
    [ u"ee",u"Räpina",2901,58.0980556,27.4636111 ],
    [ u"ee",u"Rapla",5684,59.0072222,24.7927778 ],
    [ u"ee",u"Ravila",377,59.1786111,25.2163889 ],
    [ u"ee",u"Reiu",376,58.2930556,24.5891667 ],
    [ u"ee",u"Riisipere",1058,59.1141667,24.3105556 ],
    [ u"ee",u"Risti",597,58.5605556,23.8394444 ],
    [ u"ee",u"Roela",596,59.1702778,26.6002778 ],
    [ u"ee",u"Rohuneeme",316,59.5569444,24.7972222 ],
    [ u"ee",u"Roiu",485,58.3,26.8713889 ],
    [ u"ee",u"Rõngu",738,58.1452778,26.2480556 ],
    [ u"ee",u"Roosna-Alliku",488,59.0272222,25.7083333 ],
    [ u"ee",u"Rosma",377,58.0361111,27.0719444 ],
    [ u"ee",u"Rõuge",442,57.7277778,26.9097222 ],
    [ u"ee",u"Rummu",3488,59.5352778,24.7997222 ],
    [ u"ee",u"Saarepeedi",330,58.4305556,25.6905556 ],
    [ u"ee",u"Sääse",495,59.1586111,26.1538889 ],
    [ u"ee",u"Sadala",306,58.8652778,26.6019444 ],
    [ u"ee",u"Saku",4548,59.3022222,24.6577778 ],
    [ u"ee",u"Salme",576,58.1613889,22.2622222 ],
    [ u"ee",u"Särevere",1035,58.79,25.4280556 ],
    [ u"ee",u"Saru",299,57.6047222,26.5386111 ],
    [ u"ee",u"Saue",5022,59.3202778,24.5525 ],
    [ u"ee",u"Sauga",1062,58.4166667,24.4333333 ],
    [ u"ee",u"Saverna",398,58.0688889,26.7247222 ],
    [ u"ee",u"Seljametsa",318,58.3608333,24.6658333 ],
    [ u"ee",u"Selja",405,58.5136111,24.8088889 ],
    [ u"ee",u"Sihva",362,58.0194444,26.4347222 ],
    [ u"ee",u"Siimusti",797,58.7297222,26.3394444 ],
    [ u"ee",u"Sillamäe",16672,59.3997222,27.7547222 ],
    [ u"ee",u"Simuna",474,59.0430556,26.4038889 ],
    [ u"ee",u"Sindi",4036,58.4005556,24.6675 ],
    [ u"ee",u"Sinimäe",352,59.3722222,27.8747222 ],
    [ u"ee",u"Sipa",338,58.9227778,24.3155556 ],
    [ u"ee",u"Soe",307,58.2133333,25.9280556 ],
    [ u"ee",u"Soinaste",336,58.3388889,26.6897222 ],
    [ u"ee",u"Sõmerpalu",413,57.85,26.8252778 ],
    [ u"ee",u"Sõmeru",1350,59.3611111,26.4375 ],
    [ u"ee",u"Sonda",594,59.3436111,26.8363889 ],
    [ u"ee",u"Sooru",294,57.8533333,26.1158333 ],
    [ u"ee",u"Suigu",295,58.5286111,24.6966667 ],
    [ u"ee",u"Suislepa",305,58.1497222,25.9569444 ],
    [ u"ee",u"Sürgavere",423,58.4925,25.4841667 ],
    [ u"ee",u"Surju",320,58.235,24.7175 ],
    [ u"ee",u"Suure-Jaani",1254,58.5361111,25.4705556 ],
    [ u"ee",u"Suuremõisa",316,58.865,22.9522222 ],
    [ u"ee",u"Tabasalu",2166,59.4302778,24.5330556 ],
    [ u"ee",u"Tabivere",1062,58.5541667,26.5955556 ],
    [ u"ee",u"Taebla",990,58.9538889,23.7522222 ],
    [ u"ee",u"Tali",345,58.0591667,24.7888889 ],
    [ u"ee",u"Tallinn",394023,59.4338889,24.7280556 ],
    [ u"ee",u"Tamme",349,58.9283333,24.6438889 ],
    [ u"ee",u"Tammiku",376,59.3294444,27.3816667 ],
    [ u"ee",u"Tammiste",354,58.3886111,24.5819444 ],
    [ u"ee",u"Tamsalu",2594,59.1586111,26.1152778 ],
    [ u"ee",u"Tapa",6551,59.2247222,25.9188889 ],
    [ u"ee",u"Tapa",6551,59.2605556,25.9586111 ],
    [ u"ee",u"Tarbja",355,58.9297222,25.5880556 ],
    [ u"ee",u"Tartu",101092,58.3661111,26.7361111 ],
    [ u"ee",u"Tihemetsa",894,58.1452778,25.0441667 ],
    [ u"ee",u"Tilsi",430,57.975,27.0122222 ],
    [ u"ee",u"Toila",750,59.4236111,27.5025 ],
    [ u"ee",u"Tootsi",1010,58.5780556,24.7925 ],
    [ u"ee",u"Tõravere",311,58.2694444,26.4586111 ],
    [ u"ee",u"Tori",526,58.4788889,24.8241667 ],
    [ u"ee",u"Torma",533,58.8127778,26.7383333 ],
    [ u"ee",u"Tõrva",3112,58.0027778,25.935 ],
    [ u"ee",u"Tõstamaa",639,58.3325,23.9997222 ],
    [ u"ee",u"Triigi",291,59.1138889,26.34 ],
    [ u"ee",u"Tsirguliina",515,57.86,26.1969444 ],
    [ u"ee",u"Tsooru",313,57.7402778,26.6555556 ],
    [ u"ee",u"Tudulinna",295,59.0372222,27.0852778 ],
    [ u"ee",u"Tudu",441,59.1772222,26.8580556 ],
    [ u"ee",u"Turba",1096,59.0830556,24.225 ],
    [ u"ee",u"Türi-Alliku",507,58.8158333,25.4538889 ],
    [ u"ee",u"Türi",6138,58.8086111,25.4325 ],
    [ u"ee",u"Ubja",311,59.4122222,26.4272222 ],
    [ u"ee",u"Uhti",327,58.2786111,26.73 ],
    [ u"ee",u"Uhtna",355,59.3916667,26.5622222 ],
    [ u"ee",u"Ülenurme",1047,58.3158333,26.7241667 ],
    [ u"ee",u"Ulila",349,58.3633333,26.4261111 ],
    [ u"ee",u"Ulvi",290,59.3241667,26.6361111 ],
    [ u"ee",u"Uuemõisa",1068,58.9394444,23.5894444 ],
    [ u"ee",u"Uulu",524,58.2836111,24.5872222 ],
    [ u"ee",u"Uusna",368,58.3891667,25.7283333 ],
    [ u"ee",u"Väätsa",679,58.8855556,25.4463889 ],
    [ u"ee",u"Vaida",1016,59.2905556,24.9658333 ],
    [ u"ee",u"Väike-Kamari",489,58.6111111,25.9841667 ],
    [ u"ee",u"Väike-Maarja",2155,59.1263889,26.25 ],
    [ u"ee",u"Vaimastvere",346,58.8127778,26.2916667 ],
    [ u"ee",u"Väimela",799,57.8908333,27.0188889 ],
    [ u"ee",u"Vajangu",401,59.0975,26.0333333 ],
    [ u"ee",u"Valga",13946,57.7744444,26.0452778 ],
    [ u"ee",u"Valjala",503,58.4061111,22.8011111 ],
    [ u"ee",u"Valkla",663,59.4744444,25.3186111 ],
    [ u"ee",u"Vana-Antsla",313,57.8661111,26.5322222 ],
    [ u"ee",u"Vanamõisa",353,59.3244444,24.5347222 ],
    [ u"ee",u"Vana-Vigala",572,58.7697222,24.2736111 ],
    [ u"ee",u"Vana-Võidu",517,58.3905556,25.6541667 ],
    [ u"ee",u"Vändra",2544,58.6158333,25.0969444 ],
    [ u"ee",u"Vao",431,59.1058333,26.1902778 ],
    [ u"ee",u"Vara",406,58.5208333,26.8816667 ],
    [ u"ee",u"Varbola",323,59.0433333,24.4491667 ],
    [ u"ee",u"Värska",563,57.9580556,27.6380556 ],
    [ u"ee",u"Varstu",437,57.6391667,26.6597222 ],
    [ u"ee",u"Vasalemma",856,59.2441667,24.29 ],
    [ u"ee",u"Vaskjala",325,59.3608333,24.9436111 ],
    [ u"ee",u"Vastemõisa",450,58.4422222,25.4330556 ],
    [ u"ee",u"Vastse-Kuuste",510,58.1677778,26.9286111 ],
    [ u"ee",u"Vastseliina",773,57.7263889,27.3583333 ],
    [ u"ee",u"Veltsi",293,59.3986111,26.2652778 ],
    [ u"ee",u"Veriora",549,58.0041667,27.3519444 ],
    [ u"ee",u"Vihtra",309,58.5875,25.0152778 ],
    [ u"ee",u"Viimsi",1740,59.4966667,24.8422222 ],
    [ u"ee",u"Viiratsi",1338,58.36,25.6372222 ],
    [ u"ee",u"Viljandi",20310,58.3638889,25.59 ],
    [ u"ee",u"Vinni",1032,59.2894444,26.3969444 ],
    [ u"ee",u"Virtsu",731,58.57,23.5238889 ],
    [ u"ee",u"Viru-Jaagupi",376,59.2425,26.4758333 ],
    [ u"ee",u"Viru-Nigula",364,59.4441667,26.6875 ],
    [ u"ee",u"Võhma",1551,58.6283333,25.5483333 ],
    [ u"ee",u"Võisiku",516,58.6283333,25.9205556 ],
    [ u"ee",u"Võiste",520,58.4666667,24.4833333 ],
    [ u"ee",u"Voka",1046,59.3997222,27.5816667 ],
    [ u"ee",u"Võnnu",630,58.2783333,27.0480556 ],
    [ u"ee",u"Voore",321,58.7152778,26.7513889 ],
    [ u"ee",u"Võru",14630,57.8338889,27.0194444 ],
    [ u"ee",u"Võsu",481,59.5725,25.9752778 ],
    [ u"eg",u"Abnub",68756,27.2666667,31.1502778 ],
    [ u"eg",u"Aja",34692,30.9416667,31.2922222 ],
    [ u"eg",u"Akhmim",99459,26.5666667,31.7333333 ],
    [ u"eg",u"Alexandria",3811512,31.1980556,29.9191667 ],
    [ u"eg",u"Aswan",241282,24.0875,32.8988889 ],
    [ u"eg",u"Asyut",420614,27.1827778,31.1827778 ],
    [ u"eg",u"Beba",59937,28.925,30.9833333 ],
    [ u"eg",u"Benha",167070,30.4608333,31.1875 ],
    [ u"eg",u"Beni Mazâr",58158,28.5036111,30.7991667 ],
    [ u"eg",u"Beni Suef",189637,29.0638889,31.0888889 ],
    [ u"eg",u"Cairo",7734602,30.05,31.25 ],
    [ u"eg",u"Damietta",76906,31.4194444,31.815 ],
    [ u"eg",u"Dekernes",137559,31.0883333,31.5969444 ],
    [ u"eg",u"Deshna",54197,26.1211111,32.4652778 ],
    [ u"eg",u"Diyarb Najm",51841,30.7541667,31.4405556 ],
    [ u"eg",u"El Badâri",44132,26.9922222,31.4152778 ],
    [ u"eg",u"El Balyana",48801,26.2386111,32.0030556 ],
    [ u"eg",u"El Faiyûm",306421,29.3077778,30.84 ],
    [ u"eg",u"El Mahalla el Kubra",431088,30.9761111,31.1669444 ],
    [ u"eg",u"El Wasta",37453,29.3377778,31.2055556 ],
    [ u"eg",u"Esna",69335,25.2930556,32.5527778 ],
    [ u"eg",u"Fowa",63310,31.2025,30.5472222 ],
    [ u"eg",u"Gizeh",2443490,30.0086111,31.2122222 ],
    [ u"eg",u"Hihya",43432,30.67,31.5872222 ],
    [ u"eg",u"Hurghada",95689,27.2388889,33.8361111 ],
    [ u"eg",u"Ismailia",284851,30.5833333,32.2666667 ],
    [ u"eg",u"Luxor",422408,25.6833333,32.65 ],
    [ u"eg",u"Madinat Sittah Uktubar",41930,29.8166667,31.05 ],
    [ u"eg",u"Marsa Matruh",62049,31.35,27.2333333 ],
    [ u"eg",u"Matay",45215,28.4222222,30.7555556 ],
    [ u"eg",u"Port Said",538377,31.2666667,32.3 ],
    [ u"eg",u"Qalyub",100521,30.1830556,31.2052778 ],
    [ u"eg",u"Qena",235390,26.17,32.7272222 ],
    [ u"eg",u"Rosetta",64489,31.4044444,30.4163889 ],
    [ u"eg",u"Safaga",32944,26.7333333,33.9333333 ],
    [ u"eg",u"Sohag",209440,26.55,31.7 ],
    [ u"eg",u"Suez",488124,29.9666667,32.55 ],
    [ u"eg",u"Tahta",90604,26.7680556,31.4938889 ],
    [ u"eg",u"Tala",51498,30.6819444,30.9475 ],
    [ u"eg",u"Talkha",157756,31.0530556,31.3738889 ],
    [ u"eg",u"Tanta",404934,30.7911111,30.9980556 ],
    [ u"er",u"Addi Ugri",17784,14.8855556,38.8163889 ],
    [ u"er",u"Asmara",563948,15.3333333,38.9333333 ],
    [ u"er",u"Barentu",15891,15.1138889,37.5927778 ],
    [ u"er",u"Edd",11259,13.9297222,41.6925 ],
    [ u"er",u"Ginda",11560,15.4491667,39.0886111 ],
    [ u"er",u"Teseney",3753,15.11,36.6575 ],
    [ u"es",u"Abarán",13850,38.205507,-1.399072 ],
    [ u"es",u"A Coruña",236010,43.366609,-8.406812 ],
    [ u"es",u"Adeje",22245,28.11984,-16.725581 ],
    [ u"es",u"Adra",23988,36.747398,-3.015989 ],
    [ u"es",u"Aguilar de la Frontera",13557,37.514454,-4.656173 ],
    [ u"es",u"Águilas",30739,37.405983,-1.5853 ],
    [ u"es",u"Agüimes",21908,27.905052,-15.445395 ],
    [ u"es",u"Albacete",155083,38.995845,-1.857773 ],
    [ u"es",u"Albal",13507,39.4,-.416667 ],
    [ u"es",u"Albolote",14355,37.230062,-3.655454 ],
    [ u"es",u"Alboraya",19431,39.5,-.35 ],
    [ u"es",u"Albox",10688,37.388557,-2.149495 ],
    [ u"es",u"Alcalá de Guadaira",58934,37.337906,-5.839506 ],
    [ u"es",u"Alcalá de Henares",195152,40.482048,-3.359957 ],
    [ u"es",u"Alcalá la Real",21377,37.461402,-3.923013 ],
    [ u"es",u"Alcañiz",13884,41.05,-.133333 ],
    [ u"es",u"Alcantarilla",37969,37.96939,-1.217138 ],
    [ u"es",u"Alcaudete",11197,37.590912,-4.082367 ],
    [ u"es",u"Alcázar de San Juan",26976,39.391324,-3.209756 ],
    [ u"es",u"Alcobendas",101860,40.543933,-3.635688 ],
    [ u"es",u"Alcorcón",169343,40.346467,-3.812453 ],
    [ u"es",u"Alcudia",14436,39.853605,3.122404 ],
    [ u"es",u"Alfafar",19880,39.416667,-.383333 ],
    [ u"es",u"Algeciras",104766,36.133257,-5.450511 ],
    [ u"es",u"Algemesí",26222,39.183333,-.433333 ],
    [ u"es",u"Algete",17554,40.597109,-3.49743 ],
    [ u"es",u"Alginet",12754,39.266667,-.466667 ],
    [ u"es",u"Alhama de Murcia",18060,37.851027,-1.425066 ],
    [ u"es",u"Alhaurín de la Torre",25791,36.663106,-4.562716 ],
    [ u"es",u"Alhaurín el Grande",19605,36.643002,-4.687276 ],
    [ u"es",u"Aller",14428,43.16148,-5.623441 ],
    [ u"es",u"Almansa",24502,38.869166,-1.097131 ],
    [ u"es",u"Almendralejo",27423,38.683159,-6.407468 ],
    [ u"es",u"Almería",181497,36.833333,-2.45 ],
    [ u"es",u"Almonte",18280,37.261589,-6.51691 ],
    [ u"es",u"Almoradí",16415,38.108786,-.791966 ],
    [ u"es",u"Almuñécar",22157,36.733594,-3.690619 ],
    [ u"es",u"Alora",13644,36.82389,-4.705908 ],
    [ u"es",u"Altea",18588,38.599844,-.050217 ],
    [ u"es",u"Amés",18960,42.9,-8.633333 ],
    [ u"es",u"Amposta",19140,40.710754,.578086 ],
    [ u"es",u"Amurrio",9806,43.05,-3 ],
    [ u"es",u"Andoain",13961,43.220711,-2.020336 ],
    [ u"es",u"Andújar",36594,38.039221,-4.050775 ],
    [ u"es",u"Antequera",44464,37.019382,-4.561228 ],
    [ u"es",u"Arahal",18847,37.262727,-5.545297 ],
    [ u"es",u"Aranda de Duero",30326,41.671664,-3.68795 ],
    [ u"es",u"Aranjuez",45125,40.031084,-3.602463 ],
    [ u"es",u"Archena",16563,38.116312,-1.300426 ],
    [ u"es",u"Archidona",9002,37.096046,-4.389942 ],
    [ u"es",u"Arcos de la Frontera",28754,36.750752,-5.81056 ],
    [ u"es",u"Arenys de Mar",13869,41.581905,2.549358 ],
    [ u"es",u"Armilla",15934,37.142181,-3.624931 ],
    [ u"es",u"Arnedo",14299,42.226301,-2.101386 ],
    [ u"es",u"Arona",44838,28.098519,-16.682201 ],
    [ u"es",u"Arrecife",48968,28.965706,-13.551378 ],
    [ u"es",u"Arrigorriaga",11118,43.210062,-2.885616 ],
    [ u"es",u"Arucas",35344,28.115992,-15.518724 ],
    [ u"es",u"Aspe",19430,38.345112,-.767215 ],
    [ u"es",u"Astorga",12037,42.458786,-6.056013 ],
    [ u"es",u"Atarfe",11535,37.224321,-3.686515 ],
    [ u"es",u"Ávila",49408,40.657237,-4.699511 ],
    [ u"es",u"Avilés",81984,43.554728,-5.924832 ],
    [ u"es",u"Ayamonte",17026,37.209938,-7.402661 ],
    [ u"es",u"Azpeitia",13854,43.18143,-2.263527 ],
    [ u"es",u"Azuaga",8435,38.266667,-5.683333 ],
    [ u"es",u"Azuqueca de Henares",24117,40.566881,-3.259921 ],
    [ u"es",u"Badajoz",133042,38.877894,-6.970613 ],
    [ u"es",u"Badalona",222413,41.447145,2.244789 ],
    [ u"es",u"Baena",19349,37.616696,-4.322453 ],
    [ u"es",u"Baeza",15149,37.993839,-3.471029 ],
    [ u"es",u"Bailén",17660,38.096386,-3.777855 ],
    [ u"es",u"Balaguer",14207,41.791172,.810942 ],
    [ u"es",u"Barañáin",22264,42.805668,-1.677313 ],
    [ u"es",u"Barbastro",15598,42.035573,.127019 ],
    [ u"es",u"Barbate",22524,36.192368,-5.921862 ],
    [ u"es",u"Barcelona",1570378,41.398371,2.1741 ],
    [ u"es",u"Baza",22558,37.487098,-2.771589 ],
    [ u"es",u"Beasain",12237,43.05,-2.183333 ],
    [ u"es",u"Béjar",15008,40.386411,-5.763406 ],
    [ u"es",u"Bembibre",9978,42.61771,-6.41545 ],
    [ u"es",u"Benalmádena",38147,36.595372,-4.573222 ],
    [ u"es",u"Benavente",16159,42.002491,-5.678255 ],
    [ u"es",u"Benicarló",22871,40.416501,.427087 ],
    [ u"es",u"Benidorm",60603,38.539234,-.136386 ],
    [ u"es",u"Berga",15860,42.098215,1.844004 ],
    [ u"es",u"Berja",14526,36.847369,-2.946839 ],
    [ u"es",u"Bermeo",16904,43.420416,-2.724232 ],
    [ u"es",u"Betanzos",12629,43.280418,-8.214674 ],
    [ u"es",u"Bétera",16267,39.583333,-.45 ],
    [ u"es",u"Bilbao",349270,43.260919,-2.938764 ],
    [ u"es",u"Blanes",34894,41.675766,2.789078 ],
    [ u"es",u"Boadilla del Monte",30354,40.402784,-3.875623 ],
    [ u"es",u"Boiro",17916,42.65,-8.9 ],
    [ u"es",u"Bolaños de Calatrava",11535,38.906904,-3.663455 ],
    [ u"es",u"Brenes",11078,37.549445,-5.871389 ],
    [ u"es",u"Bueu",12597,42.324579,-8.784973 ],
    [ u"es",u"Bullas",12184,38.046667,-1.672271 ],
    [ u"es",u"Buñol",9704,39.416667,-.783333 ],
    [ u"es",u"Burgos",168319,42.350221,-3.675273 ],
    [ u"es",u"Burriana",29791,39.889007,-.084989 ],
    [ u"es",u"Cabra",20806,37.47249,-4.44206 ],
    [ u"es",u"Cáceres",90938,39.481877,-6.373222 ],
    [ u"es",u"Cadiz",137698,36.515789,-6.279692 ],
    [ u"es",u"Calafell",15325,41.187937,1.569665 ],
    [ u"es",u"Calahorra",21923,42.30506,-1.965209 ],
    [ u"es",u"Calatayud",18623,41.353534,-1.643184 ],
    [ u"es",u"Calella",14797,41.618024,2.667809 ],
    [ u"es",u"Callosa de Segura",18465,38.123647,-.877392 ],
    [ u"es",u"Calviá",41549,39.566156,2.503669 ],
    [ u"es",u"Camargo",25107,43.407436,-3.884978 ],
    [ u"es",u"Camas",25622,37.402023,-6.033141 ],
    [ u"es",u"Cambados",13653,42.512806,-8.814421 ],
    [ u"es",u"Cambre",19445,43.294376,-8.34736 ],
    [ u"es",u"Cambrils",23833,41.074787,1.052436 ],
    [ u"es",u"Campo de Criptana",13470,39.404637,-3.123583 ],
    [ u"es",u"Canals",13569,38.962507,-.584431 ],
    [ u"es",u"Candelaria",15647,28.3548,-16.372684 ],
    [ u"es",u"Cangas",24460,42.264128,-8.784625 ],
    [ u"es",u"Carballo",28409,43.214403,-8.691015 ],
    [ u"es",u"Cardedeu",13822,41.639757,2.357387 ],
    [ u"es",u"Carlet",15173,39.233333,-.516667 ],
    [ u"es",u"Carmona",26471,37.471248,-5.646083 ],
    [ u"es",u"Cartagena",201977,37.605121,-.986232 ],
    [ u"es",u"Cártama",15604,36.711591,-4.630105 ],
    [ u"es",u"Cartaya",13854,37.281136,-7.150706 ],
    [ u"es",u"Castelldefels",50167,41.277658,1.968755 ],
    [ u"es",u"Castilleja de la Cuesta",16672,37.385937,-6.052577 ],
    [ u"es",u"Castrillón",22176,43.383333,-6.783333 ],
    [ u"es",u"Castro-Urdiales",21605,43.382855,-3.220433 ],
    [ u"es",u"Catarroja",22408,39.4,-.4 ],
    [ u"es",u"Cehegín",15959,38.092913,-1.797605 ],
    [ u"es",u"Cervo",4848,43.670188,-7.410134 ],
    [ u"es",u"Ceuta",71436,35.888688,-5.319247 ],
    [ u"es",u"Chantada",9086,42.609929,-7.769607 ],
    [ u"es",u"Chiclana",63012,36.421075,-6.148614 ],
    [ u"es",u"Chipiona",17400,36.736628,-6.437033 ],
    [ u"es",u"Ciempozuelos",16606,40.156067,-3.616453 ],
    [ u"es",u"Cieza",36545,38.239984,-1.419874 ],
    [ u"es",u"Ciudad Real",64625,38.986258,-3.92907 ],
    [ u"es",u"Cocentaina",12404,38.739751,-.439759 ],
    [ u"es",u"Colmenar Viejo",38913,40.6596,-3.766346 ],
    [ u"es",u"Conil",18644,36.277194,-6.088497 ],
    [ u"es",u"Consuegra",11223,39.462457,-3.608002 ],
    [ u"es",u"Córdoba",311186,37.89155,-4.772748 ],
    [ u"es",u"Coria",13287,39.987879,-6.537718 ],
    [ u"es",u"Coria del Río",24671,37.287661,-6.054101 ],
    [ u"es",u"Cornellá",86420,41.352784,2.070769 ],
    [ u"es",u"Coslada",85168,40.423776,-3.561287 ],
    [ u"es",u"Cuenca",47500,40.066667,-2.133333 ],
    [ u"es",u"Cullera",21756,39.166667,-.25 ],
    [ u"es",u"Culleredo",22560,43.28788,-8.38858 ],
    [ u"es",u"Daimiel",17466,39.07004,-3.614978 ],
    [ u"es",u"Denia",38953,38.841344,.10797 ],
    [ u"es",u"Don Benito",31425,38.956274,-5.861622 ],
    [ u"es",u"Dos Hermanas",104666,37.282867,-5.920884 ],
    [ u"es",u"Durango",24953,43.171235,-2.633795 ],
    [ u"es",u"Écija",37865,37.542203,-5.082599 ],
    [ u"es",u"Éibar",28520,43.18476,-2.473804 ],
    [ u"es",u"Ejea de los Caballeros",16586,42.126324,-1.137158 ],
    [ u"es",u"El Astillero",14710,43.400942,-3.820511 ],
    [ u"es",u"Elda",60276,38.477827,-.791573 ],
    [ u"es",u"El Ejido",63155,36.773804,-2.816556 ],
    [ u"es",u"El Escorial",12131,40.584557,-4.127668 ],
    [ u"es",u"Elgóibar",10551,43.214669,-2.416271 ],
    [ u"es",u"El Prat de Llobregat",66796,41.327836,2.094718 ],
    [ u"es",u"El Puerto de Santa María",78714,36.59952,-6.227507 ],
    [ u"es",u"El Vendrell",26947,41.220468,1.533654 ],
    [ u"es",u"El Viso del Alcor",16762,37.391063,-5.719934 ],
    [ u"es",u"Erandio",22377,43.305502,-2.945754 ],
    [ u"es",u"Ermúa",16761,43.1879,-2.503497 ],
    [ u"es",u"Estepa",12194,37.292487,-4.878709 ],
    [ u"es",u"Estepona",47577,36.427879,-5.145451 ],
    [ u"es",u"Felanitx",17187,39.471912,3.15082 ],
    [ u"es",u"Fene",14633,43.45,-8.15 ],
    [ u"es",u"Fernán-Núñez",9484,37.670436,-4.726395 ],
    [ u"es",u"Ferrol",78689,43.483213,-8.236893 ],
    [ u"es",u"Foz",9170,43.569197,-7.254405 ],
    [ u"es",u"Fraga",12538,41.521508,.35 ],
    [ u"es",u"Fuengirola",54823,36.543322,-4.626904 ],
    [ u"es",u"Fuenlabrada",202088,40.284189,-3.794147 ],
    [ u"es",u"Fuente Palmera",9925,37.704938,-5.09965 ],
    [ u"es",u"Galapagar",28271,40.576801,-4.006317 ],
    [ u"es",u"Gáldar",24118,28.14252,-15.654224 ],
    [ u"es",u"Gandía",63893,38.967418,-.18158 ],
    [ u"es",u"Gavá",43021,41.306068,2.002676 ],
    [ u"es",u"Getafe",167550,40.308423,-3.70596 ],
    [ u"es",u"Gibraleón",10904,37.37628,-6.968952 ],
    [ u"es",u"Gijón",262573,43.535731,-5.661519 ],
    [ u"es",u"Girona",85128,41.984444,2.821111 ],
    [ u"es",u"Godella",11829,39.533333,-.416667 ],
    [ u"es",u"Gondomar",12419,42.111554,-8.74971 ],
    [ u"es",u"Grado",11289,43.388014,-6.074327 ],
    [ u"es",u"Granada",248942,37.178354,-3.599201 ],
    [ u"es",u"Granadilla de Abona",23212,28.118816,-16.575989 ],
    [ u"es",u"Granollers",57382,41.607816,2.289721 ],
    [ u"es",u"Guadalajara",79616,40.628621,-3.161849 ],
    [ u"es",u"Guadix",18814,37.299324,-3.13922 ],
    [ u"es",u"Guía de Isora",16454,28.208587,-16.789471 ],
    [ u"es",u"Güimar",16772,28.3039,-16.432545 ],
    [ u"es",u"Hellín",28691,38.510605,-1.700961 ],
    [ u"es",u"Hernani",18482,43.264057,-1.978942 ],
    [ u"es",u"Huelva",145901,37.271447,-6.949464 ],
    [ u"es",u"Huércal-Overa",16204,37.388968,-1.945362 ],
    [ u"es",u"Huesca",47919,42.13868,-.409411 ],
    [ u"es",u"Huéscar",8182,37.811036,-2.54116 ],
    [ u"es",u"Ibi",25467,38.625334,-.572246 ],
    [ u"es",u"Icod de los Vinos",23885,28.372414,-16.711881 ],
    [ u"es",u"Igualada",35711,41.580977,1.6172 ],
    [ u"es",u"Illescas",13114,40.122128,-3.847038 ],
    [ u"es",u"Illora",10876,37.288253,-3.87954 ],
    [ u"es",u"Inca",26595,39.720034,2.910287 ],
    [ u"es",u"Ingenio",26606,27.918285,-15.447214 ],
    [ u"es",u"Irún",57205,43.338685,-1.793086 ],
    [ u"es",u"Jaca",11811,42.568976,-.549868 ],
    [ u"es",u"Jaén",116291,37.772404,-3.79013 ],
    [ u"es",u"Jerez",189230,36.686454,-6.136063 ],
    [ u"es",u"Jódar",12031,37.840641,-3.352622 ],
    [ u"es",u"Jumilla",24476,38.475721,-1.326995 ],
    [ u"es",u"La Algaba",13346,37.463671,-6.012938 ],
    [ u"es",u"La Bañeza",10019,42.30026,-5.897718 ],
    [ u"es",u"La Carlota",10865,37.673592,-4.931216 ],
    [ u"es",u"La Carolina",14836,38.275591,-3.615345 ],
    [ u"es",u"La Garriga",13006,41.683047,2.28626 ],
    [ u"es",u"Laguna de Duero",19362,41.581514,-4.723322 ],
    [ u"es",u"La Línea",61369,36.168024,-5.347195 ],
    [ u"es",u"Lalín",20266,42.660853,-8.112852 ],
    [ u"es",u"La Llagosta",13012,41.514348,2.19297 ],
    [ u"es",u"Langreo",45071,43.300086,-5.684644 ],
    [ u"es",u"La Orotava",41446,28.387309,-16.516774 ],
    [ u"es",u"La Palma del Condado",9904,37.386047,-6.55231 ],
    [ u"es",u"La Puebla de Cazalla",10794,37.221548,-5.311534 ],
    [ u"es",u"La Puebla del Río",10775,37.267874,-6.062641 ],
    [ u"es",u"Laredo",12871,43.409802,-3.416131 ],
    [ u"es",u"La Rinconada",30051,37.487342,-5.982579 ],
    [ u"es",u"La Roda",14535,39.216667,-2.15 ],
    [ u"es",u"La Solana",15374,38.944216,-3.238096 ],
    [ u"es",u"Las Palmas",365418,28.099727,-15.41343 ],
    [ u"es",u"Las Rozas de Madrid",70110,40.492113,-3.871271 ],
    [ u"es",u"Las Torres de Cotillas",18208,38.027933,-1.244291 ],
    [ u"es",u"La Unión",16095,37.619154,-.877993 ],
    [ u"es",u"Laviana",14321,43.245385,-5.562896 ],
    [ u"es",u"Lebrija",24754,36.920774,-6.075286 ],
    [ u"es",u"Leganés",192000,40.326946,-3.760422 ],
    [ u"es",u"Lena",13377,43.160886,-5.828783 ],
    [ u"es",u"León",127480,42.600031,-5.570316 ],
    [ u"es",u"Lepe",20176,37.254819,-7.204334 ],
    [ u"es",u"Linares",56982,38.095193,-3.63602 ],
    [ u"es",u"Llanera",12124,43.433333,-5.883333 ],
    [ u"es",u"Llanes",13084,43.422601,-4.756861 ],
    [ u"es",u"Lleida",119320,41.616667,0.633333 ],
    [ u"es",u"Llodio",19623,43.143222,-2.962042 ],
    [ u"es",u"Lloret de Mar",23009,41.699929,2.845646 ],
    [ u"es",u"Logroño",142103,42.466667,-2.45 ],
    [ u"es",u"Loja",20750,37.164893,-4.148524 ],
    [ u"es",u"Lora del Río",18761,37.658961,-5.52751 ],
    [ u"es",u"Lorca",85756,37.671192,-1.701699 ],
    [ u"es",u"Los Barrios",18314,36.184704,-5.489539 ],
    [ u"es",u"Los Corrales de Buelna",11066,43.263577,-4.072621 ],
    [ u"es",u"Los Llanos de Aridane",19461,28.658507,-17.918211 ],
    [ u"es",u"Lucena",37402,37.410533,-4.486109 ],
    [ u"es",u"Lugo",85450,43.013813,-7.558543 ],
    [ u"es",u"Madridejos",11743,39.468226,-3.531957 ],
    [ u"es",u"Madrid",3102644,40.408566,-3.69222 ],
    [ u"es",u"Mahón",26926,39.883333,4.25 ],
    [ u"es",u"Mairena del Alcor",17263,37.373014,-5.749515 ],
    [ u"es",u"Mairena del Aljarafe",36774,37.34461,-6.063913 ],
    [ u"es",u"Majadahonda",56060,40.4717,-3.869451 ],
    [ u"es",u"Málaga",557875,36.726666,-4.434802 ],
    [ u"es",u"Malgrat de Mar",15524,41.646217,2.741505 ],
    [ u"es",u"Manacor",36095,39.570524,3.211409 ],
    [ u"es",u"Manises",27420,39.483333,-.45 ],
    [ u"es",u"Manlleu",18944,42.002284,2.28476 ],
    [ u"es",u"Manresa",69134,41.726337,1.825837 ],
    [ u"es",u"Manzanares",18306,38.999149,-3.369911 ],
    [ u"es",u"Maracena",17085,37.208244,-3.633508 ],
    [ u"es",u"Marbella",115484,36.510485,-4.885745 ],
    [ u"es",u"Marchena",18319,37.329,-5.416815 ],
    [ u"es",u"Marín",25497,42.383333,-8.7 ],
    [ u"es",u"Marratxi",27035,39.65,2.8 ],
    [ u"es",u"Martorell",24877,41.47402,1.93062 ],
    [ u"es",u"Martos",22441,37.721072,-3.972645 ],
    [ u"es",u"Mataró",114923,41.542113,2.444503 ],
    [ u"es",u"Mazarrón",23068,37.598791,-1.315541 ],
    [ u"es",u"Medina del Campo",20273,41.312394,-4.914133 ],
    [ u"es",u"Mejorada del Campo",19019,40.392826,-3.481941 ],
    [ u"es",u"Melilla",66419,35.283924,-2.943075 ],
    [ u"es",u"Mérida",50333,38.916109,-6.343657 ],
    [ u"es",u"Miajadas",10733,39.151274,-5.908408 ],
    [ u"es",u"Mieres",45510,43.25,-5.766667 ],
    [ u"es",u"Mijas",51023,36.595299,-4.639861 ],
    [ u"es",u"Miranda de Ebro",36386,42.686503,-2.94695 ],
    [ u"es",u"Mislata",43287,39.466667,-.416667 ],
    [ u"es",u"Moaña",18244,42.283333,-8.75 ],
    [ u"es",u"Moguer",15606,37.275593,-6.838507 ],
    [ u"es",u"Molina de Segura",51917,38.054559,-1.207631 ],
    [ u"es",u"Mollet del Vallès",51077,41.538293,2.212456 ],
    [ u"es",u"Moncada",19890,39.55,-.4 ],
    [ u"es",u"Monforte de Lemos",18451,42.522226,-7.514324 ],
    [ u"es",u"Montijo",15199,38.908388,-6.617854 ],
    [ u"es",u"Montilla",23157,37.586266,-4.638054 ],
    [ u"es",u"Montornés del Vallés",13904,41.540328,2.26524 ],
    [ u"es",u"Montoro",9502,38.024086,-4.383405 ],
    [ u"es",u"Monzón",15461,41.913584,.194091 ],
    [ u"es",u"Morón de la Frontera",28438,37.120836,-5.45403 ],
    [ u"es",u"Móstoles",212504,40.320923,-3.862849 ],
    [ u"es",u"Motril",54313,36.750665,-3.517902 ],
    [ u"es",u"Mula",16172,38.040945,-1.490138 ],
    [ u"es",u"Murcia",410364,37.987041,-1.130042 ],
    [ u"es",u"Muros",10252,42.776173,-9.060316 ],
    [ u"es",u"Narón",32509,43.516667,-8.152778 ],
    [ u"es",u"Navalcarnero",16396,40.289078,-4.011966 ],
    [ u"es",u"Navalmoral de la Mata",16752,39.891585,-5.540639 ],
    [ u"es",u"Nerja",18536,36.750498,-3.873931 ],
    [ u"es",u"Nigrán",16432,42.147784,-8.801099 ],
    [ u"es",u"Níjar",19449,36.966298,-2.204491 ],
    [ u"es",u"Novelda",28974,38.384786,-.767731 ],
    [ u"es",u"Oleiros",27510,43.333333,-8.316667 ],
    [ u"es",u"Oliva",22422,38.919708,-.119349 ],
    [ u"es",u"Olivenza",10788,38.68402,-7.101034 ],
    [ u"es",u"Olot",31901,42.181691,2.48476 ],
    [ u"es",u"Onda",22289,39.966667,-.25 ],
    [ u"es",u"Ondárroa",9712,43.325088,-2.423304 ],
    [ u"es",u"Oria",17378,43.255304,-2.019831 ],
    [ u"es",u"Orihuela",63147,38.084834,-.944011 ],
    [ u"es",u"Osuna",17290,37.237651,-5.107465 ],
    [ u"es",u"Oviedo",198250,43.363223,-5.853128 ],
    [ u"es",u"Padrón",8925,42.740047,-8.663136 ],
    [ u"es",u"Paiporta",20134,39.433333,-.416667 ],
    [ u"es",u"Palafrugell",20830,41.917381,3.163098 ],
    [ u"es",u"Palamós",16874,41.84843,3.129121 ],
    [ u"es",u"Palencia",77438,42.009552,-4.524063 ],
    [ u"es",u"Palma del Río",19265,37.700239,-5.281208 ],
    [ u"es",u"Palma",378884,39.574337,2.655222 ],
    [ u"es",u"Pamplona",191549,42.814075,-1.641153 ],
    [ u"es",u"Parla",88983,40.236045,-3.767524 ],
    [ u"es",u"Paterna",50148,39.5,-.433333 ],
    [ u"es",u"Peñarroya-Pueblonuevo",12566,38.3,-5.266667 ],
    [ u"es",u"Pilar de la Horadada",14874,37.863021,-.791864 ],
    [ u"es",u"Pilas",11480,37.303373,-6.300969 ],
    [ u"es",u"Pinos Puente",13884,37.251095,-3.749671 ],
    [ u"es",u"Pinto",34665,40.240899,-3.696467 ],
    [ u"es",u"Plasencia",40337,43.173899,-2.411053 ],
    [ u"es",u"Ponferrada",61134,42.546638,-6.596187 ],
    [ u"es",u"Pontevedra",77595,42.433333,-8.633333 ],
    [ u"es",u"Portugalete",50964,43.319379,-3.020307 ],
    [ u"es",u"Pozoblanco",16534,38.379061,-4.848268 ],
    [ u"es",u"Pozuelo de Alarcón",83173,40.432931,-3.813375 ],
    [ u"es",u"Pravia",9132,43.492473,-6.111303 ],
    [ u"es",u"Premiá de Mar",28455,41.492256,2.359029 ],
    [ u"es",u"Priego de Córdoba",22604,37.436801,-4.196104 ],
    [ u"es",u"Puerto de la Cruz",29039,28.383333,-16.55 ],
    [ u"es",u"Puerto del Rosario",23184,28.50038,-13.862719 ],
    [ u"es",u"Puertollano",49130,38.6889,-4.108297 ],
    [ u"es",u"Puerto Lumbreras",12542,37.562904,-1.810008 ],
    [ u"es",u"Puerto Real",36946,36.528604,-6.191022 ],
    [ u"es",u"Punta Umbría",12578,37.182131,-6.96605 ],
    [ u"es",u"Redondela",29583,42.283366,-8.609603 ],
    [ u"es",u"Reinosa",10960,42.999585,-4.138007 ],
    [ u"es",u"Requena",20428,39.483333,-1.1 ],
    [ u"es",u"Reus",97508,41.155913,1.107423 ],
    [ u"es",u"Rianxo",11793,42.649765,-8.81763 ],
    [ u"es",u"Rincón de la Victoria",27924,36.716141,-4.287813 ],
    [ u"es",u"Ripollet",32670,41.496859,2.157387 ],
    [ u"es",u"Ripoll",12047,42.20033,2.190467 ],
    [ u"es",u"Ronda",38040,36.746115,-5.161443 ],
    [ u"es",u"Roquetas de Mar",54665,36.764072,-2.615144 ],
    [ u"es",u"Rota",25867,36.622363,-6.358589 ],
    [ u"es",u"Rubí",66084,41.492256,2.033047 ],
    [ u"es",u"Rute",10113,37.32617,-4.367592 ],
    [ u"es",u"Sabadell",198589,41.54329,2.109423 ],
    [ u"es",u"Sada",11573,43.356187,-8.257964 ],
    [ u"es",u"Salamanca",155175,40.9681,-5.66202 ],
    [ u"es",u"Salobreña",10725,36.742774,-3.587171 ],
    [ u"es",u"Salou",16075,41.076036,1.139829 ],
    [ u"es",u"Salt",24145,41.973982,2.791613 ],
    [ u"es",u"San Andrés del Rabanedo",25618,42.611745,-5.616709 ],
    [ u"es",u"San Bartolomé de Tirajana",37575,27.923673,-15.573557 ],
    [ u"es",u"San Bartolomé",14185,29.001726,-13.611669 ],
    [ u"es",u"San Fernando de Henares",40089,40.423857,-3.53261 ],
    [ u"es",u"San Fernando",90936,36.4759,-6.198166 ],
    [ u"es",u"San Javier",22276,37.804917,-.8373 ],
    [ u"es",u"San Juan de Aznalfarache",19848,37.358125,-6.037314 ],
    [ u"es",u"San Lorenzo de El Escorial",14422,40.593993,-4.144851 ],
    [ u"es",u"Sanlúcar de Barrameda",62213,36.778081,-6.351504 ],
    [ u"es",u"Sanlúcar la Mayor",11143,37.38714,-6.201059 ],
    [ u"es",u"San Pedro del Pinatar",18460,37.83399,-.791974 ],
    [ u"es",u"San Roque",24198,36.210667,-5.38415 ],
    [ u"es",u"San Sebastián de los Reyes",69954,40.550535,-3.626052 ],
    [ u"es",u"Santa Brígida",19158,28.031968,-15.50425 ],
    [ u"es",u"Santa Comba",10896,43.033062,-8.80925 ],
    [ u"es",u"Santa Cruz de la Palma",20501,28.682798,-17.763732 ],
    [ u"es",u"Santa Cruz de Tenerife",193852,28.460238,-16.280616 ],
    [ u"es",u"Santa Eulalia del Río",22876,38.985192,1.535644 ],
    [ u"es",u"Santa Lucía",51877,27.911307,-15.543416 ],
    [ u"es",u"Santa Marta de Tormes",11998,40.950653,-5.627226 ],
    [ u"es",u"Santander",185209,43.464722,-3.804444 ],
    [ u"es",u"Santa Pola",23111,38.19273,-.557868 ],
    [ u"es",u"Sant Cugat del Vallès",65118,41.471379,2.081834 ],
    [ u"es",u"Sant Feliu de Guíxols",20457,41.78476,3.028978 ],
    [ u"es",u"Santiago de Compostela",91141,42.880035,-8.544826 ],
    [ u"es",u"Sant Just Desvern",14987,41.383333,2.083333 ],
    [ u"es",u"Santomera",12979,38.06173,-1.048283 ],
    [ u"es",u"Santoña",11328,43.443864,-3.457571 ],
    [ u"es",u"Sant Pere de Ribes",24997,41.26126,1.772075 ],
    [ u"es",u"Segovia",55902,40.948083,-4.11839 ],
    [ u"es",u"Sestao",31709,43.310134,-3.002997 ],
    [ u"es",u"Sevilla",686647,37.382408,-5.976133 ],
    [ u"es",u"Siero",47199,43.39228,-5.66335 ],
    [ u"es",u"Silla",17303,39.366667,-.416667 ],
    [ u"es",u"Silleda",9271,42.696049,-8.24653 ],
    [ u"es",u"Sitges",21495,41.237045,1.807316 ],
    [ u"es",u"Socuéllamos",11920,39.285808,-2.792055 ],
    [ u"es",u"Sóller",12658,39.768206,2.716361 ],
    [ u"es",u"Sopelana",10688,43.380522,-2.982098 ],
    [ u"es",u"Soria",35129,41.764335,-2.468251 ],
    [ u"es",u"Sueca",27085,39.2,-.316667 ],
    [ u"es",u"Tacoronte",22289,28.476885,-16.410157 ],
    [ u"es",u"Tafalla",10881,42.526865,-1.674461 ],
    [ u"es",u"Talavera de la Reina",82704,39.963485,-4.830759 ],
    [ u"es",u"Tarancón",12081,40.008511,-3.00731 ],
    [ u"es",u"Tarazona",10935,41.903426,-1.726016 ],
    [ u"es",u"Tarifa",16179,36.01393,-5.606949 ],
    [ u"es",u"Tarragona",128391,41.116667,1.25 ],
    [ u"es",u"Tárrega",13663,41.648983,1.1396 ],
    [ u"es",u"Teguise",13491,29.060494,-13.563975 ],
    [ u"es",u"Telde",95503,27.992425,-15.419153 ],
    [ u"es",u"Teo",15623,42.75,-8.5 ],
    [ u"es",u"Teror",13110,28.064123,-15.548099 ],
    [ u"es",u"Terrassa",187770,41.561111,2.008056 ],
    [ u"es",u"Teruel",32210,40.345073,-1.104106 ],
    [ u"es",u"Tías",13957,28.961076,-13.645021 ],
    [ u"es",u"Tineo",12416,43.337651,-6.414516 ],
    [ u"es",u"Toledo",75054,39.867263,-4.02981 ],
    [ u"es",u"Tolosa",17830,43.137037,-2.075728 ],
    [ u"es",u"Tomares",18796,37.372807,-6.04589 ],
    [ u"es",u"Tomelloso",31320,39.158516,-3.020826 ],
    [ u"es",u"Tomiño",11598,41.987722,-8.755018 ],
    [ u"es",u"Torelló",13275,42.048215,2.263955 ],
    [ u"es",u"Toro",9041,41.524175,-5.395335 ],
    [ u"es",u"Torre del Campo",13235,37.772009,-3.897411 ],
    [ u"es",u"Torredonjimeno",13701,37.767478,-3.957762 ],
    [ u"es",u"Torrejón de Ardoz",111998,40.455354,-3.469734 ],
    [ u"es",u"Torrelavega",56856,43.349435,-4.047852 ],
    [ u"es",u"Torrelodones",17214,40.57466,-3.925302 ],
    [ u"es",u"Torremolinos",49412,36.625085,-4.498327 ],
    [ u"es",u"Torre-Pacheco",26932,37.742931,-.953964 ],
    [ u"es",u"Torrevieja",59528,37.978718,-.682222 ],
    [ u"es",u"Torrijos",11284,39.981945,-4.283494 ],
    [ u"es",u"Torrox",12610,36.759304,-3.952495 ],
    [ u"es",u"Tortosa",32836,40.812492,.521602 ],
    [ u"es",u"Totana",27292,37.768801,-1.502288 ],
    [ u"es",u"Tudela",31687,42.061308,-1.607164 ],
    [ u"es",u"Úbeda",33052,38.013284,-3.370496 ],
    [ u"es",u"Ubrique",17961,36.677775,-5.446004 ],
    [ u"es",u"Utiel",12277,39.566667,-1.2 ],
    [ u"es",u"Utrera",46361,37.185161,-5.78093 ],
    [ u"es",u"Valdemoro",36688,40.189007,-3.675662 ],
    [ u"es",u"Valdepeñas",26840,38.762112,-3.384829 ],
    [ u"es",u"Valencia",769897,39.466667,-.366667 ],
    [ u"es",u"Valladolid",315859,41.655181,-4.72372 ],
    [ u"es",u"Valls",22961,41.286117,1.249929 ],
    [ u"es",u"Valverde del Camino",12747,37.575112,-6.75432 ],
    [ u"es",u"Vélez-Málaga",63064,36.772621,-4.100447 ],
    [ u"es",u"Verín",12663,41.941548,-7.433918 ],
    [ u"es",u"Vícar",18315,36.83181,-2.642391 ],
    [ u"es",u"Vic",35337,41.929335,2.255497 ],
    [ u"es",u"Vigo",286585,42.232823,-8.722637 ],
    [ u"es",u"Viladecáns",61419,41.316881,2.016775 ],
    [ u"es",u"Vilanova del Camí",11015,41.571646,1.637509 ],
    [ u"es",u"Villablino",12250,42.939316,-6.319434 ],
    [ u"es",u"Villacarrillo",11063,38.115603,-3.084799 ],
    [ u"es",u"Villafranca de los Barros",12442,38.561445,-6.338095 ],
    [ u"es",u"Villamartín",12342,36.859787,-5.64485 ],
    [ u"es",u"Villanueva de Córdoba",9880,38.322774,-4.628725 ],
    [ u"es",u"Villanueva de la Serena",24006,38.976552,-5.797398 ],
    [ u"es",u"Villarrobledo",23663,39.269922,-2.601185 ],
    [ u"es",u"Villarrubia de los Ojos",9933,39.220846,-3.608023 ],
    [ u"es",u"Villaviciosa de Odón",24958,40.356923,-3.900107 ],
    [ u"es",u"Villaviciosa",13750,43.480936,-5.435249 ],
    [ u"es",u"Villena",38150,38.637303,-.865682 ],
    [ u"es",u"Vitoria",224774,42.85,-2.666667 ],
    [ u"es",u"Yecla",34118,38.613188,-1.111795 ],
    [ u"es",u"Zafra",15199,38.416667,-6.416667 ],
    [ u"es",u"Zamora",63160,41.50494,-5.745296 ],
    [ u"es",u"Zaragoza",635509,41.64531,-.884861 ],
    [ u"es",u"Zarautz",21303,43.283333,-2.166667 ],
    [ u"es",u"Zumárraga",10284,43.092848,-2.313718 ],
    [ u"et",u"Abiy Adi",10385,13.560833,38.973889 ],
    [ u"et",u"Abomsa",15261,9.983333,39.983333 ],
    [ u"et",u"Addis Abeba",2757807,9.024325,38.749226 ],
    [ u"et",u"Addis Zemen",22526,12.116667,37.783333 ],
    [ u"et",u"Adet",22950,11.266667,37.483333 ],
    [ u"et",u"Adwa",43582,14.163471,38.899237 ],
    [ u"et",u"Agaro",28273,7.85,36.65 ],
    [ u"et",u"Aksum",41256,14.124482,38.724442 ],
    [ u"et",u"Areka",33187,7.066667,37.7 ],
    [ u"et",u"Asasa",23794,7.1,39.2 ],
    [ u"et",u"Asayita",20342,11.563611,41.439444 ],
    [ u"et",u"Asbe Teferi",30777,9.083333,40.866667 ],
    [ u"et",u"Asosa",30544,10.066667,34.533333 ],
    [ u"et",u"Assela",60191,7.95,39.133333 ],
    [ u"et",u"Awash",11415,8.983333,40.166667 ],
    [ u"et",u"Awassa",133120,7.05,38.466667 ],
    [ u"et",u"Bahir Dar",168929,11.6,37.383333 ],
    [ u"et",u"Bako",17875,5.783333,36.566667 ],
    [ u"et",u"Bati",19263,11.183333,40.016667 ],
    [ u"et",u"Bedele",20297,8.456003,36.353024 ],
    [ u"et",u"Bedesa",17529,8.9,40.783333 ],
    [ u"et",u"Bichena",16411,10.45,38.2 ],
    [ u"et",u"Boditi",33068,6.966667,37.866667 ],
    [ u"et",u"Bonga",18976,7.266667,36.25 ],
    [ u"et",u"Bure",22042,10.7,37.066667 ],
    [ u"et",u"Butajira",30507,8.116667,38.366667 ],
    [ u"et",u"Dabat",11544,12.984167,37.765 ],
    [ u"et",u"Debre Birhan",57797,9.683333,39.533333 ],
    [ u"et",u"Debre Sina",9409,9.85,39.766667 ],
    [ u"et",u"Debre Tabor",32665,11.85,38.016667 ],
    [ u"et",u"Debre Zeyit",104234,8.75,38.983333 ],
    [ u"et",u"Deder",8884,9.316667,41.45 ],
    [ u"et",u"Dejen",11739,10.166667,38.133333 ],
    [ u"et",u"Dembi Dolo",26753,8.533333,34.8 ],
    [ u"et",u"Dese",136080,11.133333,39.633333 ],
    [ u"et",u"Dilla",47029,6.416667,38.316667 ],
    [ u"et",u"Dire Dawa",252347,9.593056,41.866111 ],
    [ u"et",u"Dodola",23120,6.983333,39.183333 ],
    [ u"et",u"Dubti",26375,11.736111,41.085278 ],
    [ u"et",u"Fiche",25763,9.8,38.733333 ],
    [ u"et",u"Finote Selam",23467,10.7,37.266667 ],
    [ u"et",u"Gambela",42474,8.25,34.583333 ],
    [ u"et",u"Gebre Guracha",16586,9.8,38.4 ],
    [ u"et",u"Gedo",7499,9.016667,37.45 ],
    [ u"et",u"Gelemso",16067,8.816667,40.516667 ],
    [ u"et",u"Gewane",11279,10.166389,40.645278 ],
    [ u"et",u"Gidole",10736,5.65,37.366667 ],
    [ u"et",u"Gimbi",31815,9.166667,35.833333 ],
    [ u"et",u"Ginir",16760,7.133333,40.7 ],
    [ u"et",u"Giyon",38401,8.533333,37.983333 ],
    [ u"et",u"Goba",34375,7.016667,39.983333 ],
    [ u"et",u"Gondar",153942,12.6,37.466667 ],
    [ u"et",u"Gore",9352,8.15,35.533333 ],
    [ u"et",u"Guder",12569,8.966667,37.766667 ],
    [ u"et",u"Hagere Hiywet",43928,8.983333,37.85 ],
    [ u"et",u"Hagere Selam",5169,6.483333,38.516667 ],
    [ u"et",u"Harer",90226,9.309444,42.125833 ],
    [ u"et",u"Himora",19708,14.290593,36.608076 ],
    [ u"et",u"Hirna",12295,9.216667,41.1 ],
    [ u"et",u"Huruta",12442,8.15,39.35 ],
    [ u"et",u"Jijiga",57146,9.35,42.8 ],
    [ u"et",u"Jimma",128330,7.666667,36.833333 ],
    [ u"et",u"Jinka",32151,5.65,36.65 ],
    [ u"et",u"Kembolcha",93709,11.083333,39.733333 ],
    [ u"et",u"Kemise",23888,10.716667,39.866667 ],
    [ u"et",u"Kibre Mengist",27859,5.883333,38.983333 ],
    [ u"et",u"Kofele",9643,7.066667,38.783333 ],
    [ u"et",u"Korem",30638,12.505833,39.522778 ],
    [ u"et",u"Lalibela",11152,12.033333,39.033333 ],
    [ u"et",u"Leku",11398,6.866667,38.45 ],
    [ u"et",u"Mega",6884,4.05,38.3 ],
    [ u"et",u"Mendi",25267,9.8,35.1 ],
    [ u"et",u"Metehara",23408,8.9,39.916667 ],
    [ u"et",u"Metu",29654,8.3,35.583333 ],
    [ u"et",u"Mizan Teferi",14002,6.983333,35.583333 ],
    [ u"et",u"Mojo",34553,8.6,39.116667 ],
    [ u"et",u"Moyale",25993,3.569167,39.083333 ],
    [ u"et",u"Nazret",214034,8.55,39.266667 ],
    [ u"et",u"Nedjo",20170,9.5,35.5 ],
    [ u"et",u"Negele",42358,7.35,38.7 ],
    [ u"et",u"Robe",41280,7.866667,39.633333 ],
    [ u"et",u"Sebeta",19537,8.916667,38.616667 ],
    [ u"et",u"Sendafa",7326,9.15,39.033333 ],
    [ u"et",u"Shakiso",34116,5.75,38.916667 ],
    [ u"et",u"Shambu",15357,9.566667,37.1 ],
    [ u"et",u"Sire",10089,8.283333,39.45 ],
    [ u"et",u"Tulu Bolo",10531,8.666667,38.216667 ],
    [ u"et",u"Wendo",12948,6.6,38.416667 ],
    [ u"et",u"Were Ilu",7636,10.6,39.433333 ],
    [ u"et",u"Werota",26818,11.916667,37.7 ],
    [ u"et",u"Wonji",17190,8.45,39.283333 ],
    [ u"et",u"Yabelo",17822,4.883333,38.083333 ],
    [ u"et",u"Ziway",49522,7.933333,38.716667 ],
    [ u"fi",u"Äänekoski",13406,62.6,25.733333 ],
    [ u"fi",u"Espoo",229528,60.216667,24.666667 ],
    [ u"fi",u"Eura",9338,61.133333,22.133333 ],
    [ u"fi",u"Eurajoki",5656,61.2,21.733333 ],
    [ u"fi",u"Forssa",17852,60.816667,23.633333 ],
    [ u"fi",u"Hämeenlinna",47261,61,24.45 ],
    [ u"fi",u"Hamina",21712,60.566667,27.2 ],
    [ u"fi",u"Hanko",9962,59.833333,22.95 ],
    [ u"fi",u"Harjavalta",7572,61.316667,22.133333 ],
    [ u"fi",u"Haukipudas",17298,65.183333,25.35 ],
    [ u"fi",u"Heinola",20849,61.216667,26.033333 ],
    [ u"fi",u"Helsinki",558457,60.175556,24.934167 ],
    [ u"fi",u"Hollola",20405,61.05,25.433333 ],
    [ u"fi",u"Huittinen",8952,61.183333,22.7 ],
    [ u"fi",u"Hyvinkää",43515,60.633333,24.866667 ],
    [ u"fi",u"Iisalmi",22588,63.566667,27.183333 ],
    [ u"fi",u"Ilmajoki",11694,62.733333,22.566667 ],
    [ u"fi",u"Imatra",29615,61.166667,28.766667 ],
    [ u"fi",u"Jämsä",15261,61.866667,25.2 ],
    [ u"fi",u"Janakkala",15698,60.9,24.6 ],
    [ u"fi",u"Järvenpää",38148,60.466667,25.1 ],
    [ u"fi",u"Joensuu",53389,62.6,29.766667 ],
    [ u"fi",u"Joutseno",10603,61.1,28.5 ],
    [ u"fi",u"Jyväskylä",85026,62.233333,25.733333 ],
    [ u"fi",u"Kaarina",21684,60.416667,22.416667 ],
    [ u"fi",u"Kajaani",35375,64.233333,27.683333 ],
    [ u"fi",u"Kangasala",24291,61.466667,24.083333 ],
    [ u"fi",u"Kankaanpää",12381,61.8,22.416667 ],
    [ u"fi",u"Kauhajoki",14526,62.433333,22.183333 ],
    [ u"fi",u"Kemijärvi",9341,66.666667,27.416667 ],
    [ u"fi",u"Kemi",22629,65.733333,24.566667 ],
    [ u"fi",u"Kempele",14293,64.916667,25.5 ],
    [ u"fi",u"Kerava",31347,60.4,25.116667 ],
    [ u"fi",u"Keuruu",10942,62.266667,24.7 ],
    [ u"fi",u"Kirkkonummi",32921,60.116667,24.433333 ],
    [ u"fi",u"Kokemäki",8390,61.25,22.35 ],
    [ u"fi",u"Kokkola",35586,63.833333,23.116667 ],
    [ u"fi",u"Kotka",54616,60.466667,26.916667 ],
    [ u"fi",u"Kouvola",31133,60.866667,26.7 ],
    [ u"fi",u"Kristiinankaupunki",7712,62.283333,21.383333 ],
    [ u"fi",u"Kuopio",89104,62.9,27.683333 ],
    [ u"fi",u"Kurikka",10628,62.616667,22.416667 ],
    [ u"fi",u"Kuusamo",17401,65.966667,29.183333 ],
    [ u"fi",u"Kuusankoski",19986,60.9,26.633333 ],
    [ u"fi",u"Lahti",98826,60.966667,25.666667 ],
    [ u"fi",u"Lappeenranta",59276,61.066667,28.183333 ],
    [ u"fi",u"Lapua",14091,62.95,23 ],
    [ u"fi",u"Laukaa",17093,62.416667,25.95 ],
    [ u"fi",u"Lempäälä",18096,61.316667,23.75 ],
    [ u"fi",u"Lieksa",13704,63.316667,30.016667 ],
    [ u"fi",u"Lieto",15258,60.5,22.45 ],
    [ u"fi",u"Lohja",35960,60.25,24.083333 ],
    [ u"fi",u"Loviisa",7264,60.45,26.233333 ],
    [ u"fi",u"Maarianhamina",10682,60.1,19.95 ],
    [ u"fi",u"Mäntsälä",18074,60.633333,25.316667 ],
    [ u"fi",u"Mikkeli",46550,61.683333,27.25 ],
    [ u"fi",u"Muhos",8232,64.766667,26.1 ],
    [ u"fi",u"Mustasaari",17176,63.116667,21.716667 ],
    [ u"fi",u"Naantali",13607,60.45,22.033333 ],
    [ u"fi",u"Nakkila",5792,61.366667,22 ],
    [ u"fi",u"Nastola",14911,60.95,25.933333 ],
    [ u"fi",u"Nivala",10610,63.916667,24.966667 ],
    [ u"fi",u"Nokia",28676,61.466667,23.5 ],
    [ u"fi",u"Noormarkku",6076,61.583333,21.866667 ],
    [ u"fi",u"Nurmijärvi",37074,60.466667,24.8 ],
    [ u"fi",u"Orimattila",14603,60.8,25.75 ],
    [ u"fi",u"Oulainen",8300,64.266667,24.8 ],
    [ u"fi",u"Oulu",128618,65.016667,25.466667 ],
    [ u"fi",u"Parainen",11962,60.3,22.3 ],
    [ u"fi",u"Pietarsaari",19238,63.65,22.683333 ],
    [ u"fi",u"Pirkkala",14914,61.466667,23.566667 ],
    [ u"fi",u"Pori",76773,61.483333,21.783333 ],
    [ u"fi",u"Porvoo",47192,60.4,25.666667 ],
    [ u"fi",u"Raahe",22217,64.683333,24.483333 ],
    [ u"fi",u"Raisio",23598,60.483333,22.183333 ],
    [ u"fi",u"Rauma",36550,61.133333,21.5 ],
    [ u"fi",u"Riihimäki",26451,60.75,24.766667 ],
    [ u"fi",u"Rovaniemi",34781,66.5,25.716667 ],
    [ u"fi",u"Säkylä",4870,61.033333,22.333333 ],
    [ u"fi",u"Salo",24900,60.383333,23.133333 ],
    [ u"fi",u"Savonlinna",27353,61.866667,28.883333 ],
    [ u"fi",u"Seinäjoki",32149,62.8,22.833333 ],
    [ u"fi",u"Siilinjärvi",20210,63.083333,27.666667 ],
    [ u"fi",u"Sipoo",19430,60.366667,25.266667 ],
    [ u"fi",u"Tammisaari",14377,59.966667,23.433333 ],
    [ u"fi",u"Tampere",202688,61.5,23.75 ],
    [ u"fi",u"Tornio",21236,65.85,24.183333 ],
    [ u"fi",u"Turku",175944,60.45,22.283333 ],
    [ u"fi",u"Tuusula",34725,60.416667,25.033333 ],
    [ u"fi",u"Ulvila",12314,61.433333,21.883333 ],
    [ u"fi",u"Uusikaupunki",16226,60.8,21.416667 ],
    [ u"fi",u"Vaasa",57014,63.1,21.6 ],
    [ u"fi",u"Valkeakoski",20376,61.266667,24.033333 ],
    [ u"fi",u"Valkeala",11059,60.95,26.8 ],
    [ u"fi",u"Vammala",14982,61.333333,22.9 ],
    [ u"fi",u"Varkaus",22365,62.316667,27.916667 ],
    [ u"fi",u"Vihti",26280,60.416667,24.333333 ],
    [ u"fi",u"Ylivieska",13159,64.083333,24.55 ],
    [ u"fi",u"Ylöjärvi",22140,61.55,23.6 ],
    [ u"fo",u"Akrar",13,61.45,-6.75 ],
    [ u"fo",u"Ánirnar",18,62.25,-6.5666667 ],
    [ u"fo",u"Argir",1871,61.9833333,-6.75 ],
    [ u"fo",u"Bøur",67,62.0833333,-7.35 ],
    [ u"fo",u"Dalur",45,61.7833333,-6.6666667 ],
    [ u"fo",u"Elduvík",23,62.2833333,-6.9 ],
    [ u"fo",u"Fámjin",111,61.5166667,-6.8666667 ],
    [ u"fo",u"Funningur",66,62.2833333,-6.95 ],
    [ u"fo",u"Gásadalur",17,62.1166667,-7.4333333 ],
    [ u"fo",u"Gjánoyri",55,62.2333333,-7.0333333 ],
    [ u"fo",u"Gjov",53,62.3166667,-6.9333333 ],
    [ u"fo",u"Glyvrar",425,62.1333333,-6.7166667 ],
    [ u"fo",u"Gøtugjógv",46,62.1833333,-6.7333333 ],
    [ u"fo",u"Haldarsvík",175,62.2833333,-7.0833333 ],
    [ u"fo",u"Haraldssund",77,62.2666667,-6.6 ],
    [ u"fo",u"Hattarvík",19,62.3333333,-6.25 ],
    [ u"fo",u"Hellur",30,62.2666667,-6.8333333 ],
    [ u"fo",u"Hestur",44,61.95,-6.8666667 ],
    [ u"fo",u"Hósvík",344,62.15,-6.9333333 ],
    [ u"fo",u"Hove",149,61.5166667,-6.7333333 ],
    [ u"fo",u"Hoyvík",2777,62.0333333,-6.75 ],
    [ u"fo",u"Húsar",60,62.2666667,-6.6833333 ],
    [ u"fo",u"Húsavík",82,61.8,-6.6666667 ],
    [ u"fo",u"Hvalba",673,61.6,-6.95 ],
    [ u"fo",u"Hvalvík",183,62.1833333,-7.0166667 ],
    [ u"fo",u"Hvannasund",271,62.3,-6.5 ],
    [ u"fo",u"Hvítanes",104,62.05,-6.7666667 ],
    [ u"fo",u"Kaldbak",229,62.05,-6.8166667 ],
    [ u"fo",u"Kirkja",31,62.3166667,-6.3 ],
    [ u"fo",u"Kirkjubøur",81,61.95,-6.7833333 ],
    [ u"fo",u"Klaksvík",4664,62.2333333,-6.6 ],
    [ u"fo",u"Kunoy",70,62.2833333,-6.6666667 ],
    [ u"fo",u"Kvívík",372,62.1166667,-7.0666667 ],
    [ u"fo",u"Lambi",148,62.1333333,-6.6833333 ],
    [ u"fo",u"Leirvík",960,62.2166667,-6.6833333 ],
    [ u"fo",u"Leynar",114,62.1166667,-7.0333333 ],
    [ u"fo",u"Ljósá",33,62.2666667,-7.05 ],
    [ u"fo",u"Lopra",124,61.4333333,-6.7666667 ],
    [ u"fo",u"Mikladalur",60,62.3333333,-6.75 ],
    [ u"fo",u"Morskranes",45,62.1333333,-6.8333333 ],
    [ u"fo",u"Mykines",25,62.1,-7.6333333 ],
    [ u"fo",u"Nes",233,62.0833333,-6.7166667 ],
    [ u"fo",u"Nólsoy",283,62.0166667,-6.6666667 ],
    [ u"fo",u"Øravík",36,61.5333333,-6.8 ],
    [ u"fo",u"Oyrarbakki",104,62.2,-6.9833333 ],
    [ u"fo",u"Oyri",140,62.1833333,-6.9666667 ],
    [ u"fo",u"Porkeri",396,61.4833333,-6.7333333 ],
    [ u"fo",u"Rituvík",268,62.1,-6.6666667 ],
    [ u"fo",u"Runavík",503,62.1166667,-6.7166667 ],
    [ u"fo",u"Saksun",37,62.25,-7.1666667 ],
    [ u"fo",u"Saltangará",799,62.1166667,-6.7166667 ],
    [ u"fo",u"Saltnes",163,62.1,-6.7333333 ],
    [ u"fo",u"Sandavágur",779,62.05,-7.1333333 ],
    [ u"fo",u"Sandur",608,61.8333333,-6.8 ],
    [ u"fo",u"Sandvík",116,61.6333333,-6.9166667 ],
    [ u"fo",u"Skælingur",11,62.1,-7.0 ],
    [ u"fo",u"Skálabotnur",105,62.2,-6.85 ],
    [ u"fo",u"Skálavík",171,61.8333333,-6.65 ],
    [ u"fo",u"Skáli",621,62.15,-6.7666667 ],
    [ u"fo",u"Skipanes",61,62.1666667,-6.75 ],
    [ u"fo",u"Skopun",464,61.9,-6.8666667 ],
    [ u"fo",u"Skúvoy",53,61.7666667,-6.8 ],
    [ u"fo",u"Sörvag",1066,62.0666667,-7.3 ],
    [ u"fo",u"Strendur",854,62.1166667,-6.75 ],
    [ u"fo",u"Streymnes",189,62.2,-7.0166667 ],
    [ u"fo",u"Sumba",289,61.4,-6.7 ],
    [ u"fo",u"Svínáir",23,62.2333333,-7.0166667 ],
    [ u"fo",u"Svínoy",95,62.2833333,-6.3333333 ],
    [ u"fo",u"Tjørnuvík",66,62.2833333,-7.1333333 ],
    [ u"fo",u"Toftir",854,61.6,-6.95 ],
    [ u"fo",u"Tórshavn",13200,62.0166667,-6.7666667 ],
    [ u"fo",u"Trøllanes",26,62.3666667,-6.7833333 ],
    [ u"fo",u"Tvøroyri",1230,61.55,-6.8 ],
    [ u"fo",u"Vágur",1569,61.4666667,-6.8166667 ],
    [ u"fo",u"Vatnsoyrar",41,62.0666667,-7.2333333 ],
    [ u"fo",u"Vestmanna",1284,62.15,-7.1666667 ],
    [ u"fr",u"Abbeville",25274,50.106602,1.832691 ],
    [ u"fr",u"Achères",22282,48.961155,2.068824 ],
    [ u"fr",u"Agde",21950,43.310991,3.47534 ],
    [ u"fr",u"Agen",30236,44.199912,.626641 ],
    [ u"fr",u"Aire-sur-la-Lys",9829,50.638713,2.398759 ],
    [ u"fr",u"Aix-en-Provence",142133,43.528695,5.448791 ],
    [ u"fr",u"Aix-les-Bains",26688,45.683378,5.922406 ],
    [ u"fr",u"Ajaccio",51058,41.927226,8.734619 ],
    [ u"fr",u"Albert",10180,50.000906,2.650961 ],
    [ u"fr",u"Albertville",17485,45.669738,6.387059 ],
    [ u"fr",u"Albi",46510,43.927186,2.149255 ],
    [ u"fr",u"Alençon",28505,48.434758,.093111 ],
    [ u"fr",u"Alès",38661,44.131126,4.087188 ],
    [ u"fr",u"Alfortville",36566,48.80575,2.420402 ],
    [ u"fr",u"Allauch",21156,43.335552,5.482769 ],
    [ u"fr",u"Allonnes",11707,47.967395,.158067 ],
    [ u"fr",u"Ambérieu-en-Bugey",12289,45.958853,5.343197 ],
    [ u"fr",u"Amboise",11896,47.412491,.98266 ],
    [ u"fr",u"Amiens",138816,49.9,2.3 ],
    [ u"fr",u"Amilly",11965,47.972812,2.771859 ],
    [ u"fr",u"Amnéville",9640,49.257495,6.142026 ],
    [ u"fr",u"Andrésy",12646,48.982345,2.056872 ],
    [ u"fr",u"Angers",158585,47.473806,-.54774 ],
    [ u"fr",u"Anglet",36946,43.476642,-1.513456 ],
    [ u"fr",u"Angoulême",43509,45.65,.15 ],
    [ u"fr",u"Aniche",9905,50.329955,3.253457 ],
    [ u"fr",u"Annecy",51119,45.906206,6.126699 ],
    [ u"fr",u"Annecy-le-Vieux",20103,45.919715,6.143929 ],
    [ u"fr",u"Annemasse",27386,46.186519,6.241324 ],
    [ u"fr",u"Annoeullin",10442,50.528492,2.933615 ],
    [ u"fr",u"Annonay",17082,45.239695,4.670747 ],
    [ u"fr",u"Antibes",75311,43.562407,7.127766 ],
    [ u"fr",u"Antony",61595,48.758283,2.305568 ],
    [ u"fr",u"Anzin",14153,50.372014,3.50387 ],
    [ u"fr",u"Apt",11115,43.87566,5.392292 ],
    [ u"fr",u"Arcachon",11391,44.659252,-1.169382 ],
    [ u"fr",u"Arcueil",16869,48.799931,2.332555 ],
    [ u"fr",u"Argentan",16845,48.745175,-.018062 ],
    [ u"fr",u"Argenteuil",95075,48.939396,2.2367 ],
    [ u"fr",u"Arles",49925,43.681659,4.636331 ],
    [ u"fr",u"Armentières",25468,50.685679,2.882139 ],
    [ u"fr",u"Arnouville-lès-Gonesse",12543,48.983333,2.416667 ],
    [ u"fr",u"Arras",41551,50.291799,2.780306 ],
    [ u"fr",u"Athis-Mons",30025,48.705224,2.391474 ],
    [ u"fr",u"Aubagne",43979,43.290958,5.586814 ],
    [ u"fr",u"Aubenas",11076,44.620057,4.389937 ],
    [ u"fr",u"Aubergenville",11785,48.959957,1.854673 ],
    [ u"fr",u"Aubière",10529,45.751574,3.112506 ],
    [ u"fr",u"Auch",21221,43.645401,.587933 ],
    [ u"fr",u"Auchel",11227,50.503451,2.473462 ],
    [ u"fr",u"Audincourt",15114,47.483271,6.853407 ],
    [ u"fr",u"Aulnay-sous-Bois",79622,48.938138,2.494022 ],
    [ u"fr",u"Aulnoye-Aymeries",8864,50.201412,3.838439 ],
    [ u"fr",u"Auray",11425,47.670252,-2.991828 ],
    [ u"fr",u"Aurillac",30652,44.9214,2.437319 ],
    [ u"fr",u"Autun",15684,46.954878,4.300357 ],
    [ u"fr",u"Auxerre",37515,47.7996,3.57033 ],
    [ u"fr",u"Avallon",8053,47.49181,3.914723 ],
    [ u"fr",u"Avignon",85848,43.945404,4.810226 ],
    [ u"fr",u"Avion",18305,50.410379,2.830534 ],
    [ u"fr",u"Avon",14436,48.402195,2.720223 ],
    [ u"fr",u"Avrillé",13219,47.5,-.583333 ],
    [ u"fr",u"Bagneux",38003,48.795645,2.307962 ],
    [ u"fr",u"Bagnolet",32781,48.866667,2.416667 ],
    [ u"fr",u"Bagnols-sur-Cèze",18497,44.159897,4.617757 ],
    [ u"fr",u"Bailleul",14450,50.735924,2.735944 ],
    [ u"fr",u"Balma",13955,43.610145,1.503705 ],
    [ u"fr",u"Barentin",13031,49.545327,.955152 ],
    [ u"fr",u"Bar-le-Duc",16686,48.772749,5.161085 ],
    [ u"fr",u"Bastia",37668,42.702778,9.45 ],
    [ u"fr",u"Bayeux",15286,49.281062,-.705711 ],
    [ u"fr",u"Bayonne",40336,43.483333,-1.483333 ],
    [ u"fr",u"Beaucaire",14162,43.808365,4.63946 ],
    [ u"fr",u"Beauchamps",9173,48.83238,-1.360005 ],
    [ u"fr",u"Beaumont",11742,45.751226,3.083551 ],
    [ u"fr",u"Beaune",22573,47.02441,4.838925 ],
    [ u"fr",u"Beausoleil",13268,43.749038,7.417022 ],
    [ u"fr",u"Beauvais",56526,49.433333,2.083333 ],
    [ u"fr",u"Bègles",22658,44.808446,-.548086 ],
    [ u"fr",u"Behren-lès-Forbach",10010,49.166397,6.943363 ],
    [ u"fr",u"Belfort",50809,47.638831,6.854187 ],
    [ u"fr",u"Bellegarde-sur-Valserine",10815,46.110377,5.830437 ],
    [ u"fr",u"Berck",14638,50.408139,1.577515 ],
    [ u"fr",u"Bergerac",25766,44.852547,.484862 ],
    [ u"fr",u"Bernay",11491,49.09378,.601411 ],
    [ u"fr",u"Besançon",120139,47.248778,6.018152 ],
    [ u"fr",u"Béthune",29961,50.529848,2.641221 ],
    [ u"fr",u"Béziers",68264,43.345287,3.222374 ],
    [ u"fr",u"Bezons",27094,48.924257,2.212803 ],
    [ u"fr",u"Biarritz",31231,43.480119,-1.555581 ],
    [ u"fr",u"Bihorel",8954,49.454685,1.122298 ],
    [ u"fr",u"Billère",14055,43.299999,-.4 ],
    [ u"fr",u"Biscarrosse",9515,44.394434,-1.164097 ],
    [ u"fr",u"Bischheim",17164,48.610191,7.742446 ],
    [ u"fr",u"Bischwiller",12109,48.765883,7.858307 ],
    [ u"fr",u"Blagnac",23313,43.632759,1.393986 ],
    [ u"fr",u"Blanquefort",14791,44.91248,-.636633 ],
    [ u"fr",u"Blois",49510,47.594322,1.329122 ],
    [ u"fr",u"Bobigny",44153,48.909825,2.45012 ],
    [ u"fr",u"Bois-Colombes",23663,48.919363,2.274845 ],
    [ u"fr",u"Bois-Guillaume",13395,49.460197,1.12219 ],
    [ u"fr",u"Boissy-Saint-Léger",15451,48.751495,2.511632 ],
    [ u"fr",u"Bolbec",12847,49.573209,.473389 ],
    [ u"fr",u"Bollène",14470,44.28476,4.75303 ],
    [ u"fr",u"Bondues",11026,50.701956,3.094972 ],
    [ u"fr",u"Bondy",47242,48.901797,2.489312 ],
    [ u"fr",u"Bonneuil",17644,48.974455,2.431536 ],
    [ u"fr",u"Bonneville",10931,46.084257,6.404214 ],
    [ u"fr",u"Bordeaux",219311,44.840439,-.5805 ],
    [ u"fr",u"Bouc-Bel-Air",12946,43.45223,5.413189 ],
    [ u"fr",u"Bouguenais",16135,47.177624,-1.621426 ],
    [ u"fr",u"Boulogne-Billancourt",109765,48.835684,2.247342 ],
    [ u"fr",u"Boulogne-sur-Mer",45715,50.720702,1.604562 ],
    [ u"fr",u"Bourg-en-Bresse",40856,46.20445,5.227911 ],
    [ u"fr",u"Bourges",71500,47.083333,2.4 ],
    [ u"fr",u"Bourg-la-Reine",18179,48.778882,2.317807 ],
    [ u"fr",u"Bourg-lès-Valence",18645,44.956009,4.910227 ],
    [ u"fr",u"Bressuire",17952,46.839886,-.489639 ],
    [ u"fr",u"Brest",150554,48.390756,-4.486165 ],
    [ u"fr",u"Brétigny-sur-Orge",23336,48.61892,2.309158 ],
    [ u"fr",u"Briançon",10627,44.900465,6.638075 ],
    [ u"fr",u"Brie-Comte-Robert",15080,48.692468,2.610902 ],
    [ u"fr",u"Brignais",12121,45.673577,4.754842 ],
    [ u"fr",u"Brignoles",13579,43.405419,6.062253 ],
    [ u"fr",u"Brive-la-Gaillarde",49092,45.158003,1.535048 ],
    [ u"fr",u"Bron",36263,45.740218,4.922415 ],
    [ u"fr",u"Bruges",12117,44.87981,-.612194 ],
    [ u"fr",u"Brunoy",23418,48.694204,2.492233 ],
    [ u"fr",u"Bry-sur-Marne",15911,48.838106,2.524879 ],
    [ u"fr",u"Bully-les-Mines",11819,50.443805,2.727029 ],
    [ u"fr",u"Bures-sur-Yvette",10115,48.699812,2.170636 ],
    [ u"fr",u"Cachan",25391,48.796324,2.336609 ],
    [ u"fr",u"Caen",115358,49.197188,-.326822 ],
    [ u"fr",u"Cagnes-sur-Mer",46624,43.664595,7.153389 ],
    [ u"fr",u"Cahors",20336,44.454598,1.43924 ],
    [ u"fr",u"Calais",79010,50.951241,1.85899 ],
    [ u"fr",u"Caluire-et-Cuire",41524,45.790412,4.841124 ],
    [ u"fr",u"Cambrai",34140,50.177216,3.233826 ],
    [ u"fr",u"Cannes",66687,43.549744,6.9943 ],
    [ u"fr",u"Canteleu",15157,49.440654,1.024586 ],
    [ u"fr",u"Cappelle-la-Grande",8495,50.999793,2.358484 ],
    [ u"fr",u"Carcassonne",44697,43.213513,2.351625 ],
    [ u"fr",u"Carmaux",9876,44.050993,2.15795 ],
    [ u"fr",u"Carpentras",27734,44.054413,5.047716 ],
    [ u"fr",u"Carquefou",17387,47.298215,-1.490244 ],
    [ u"fr",u"Carrières-sous-Poissy",15261,48.949521,2.040682 ],
    [ u"fr",u"Carrières-sur-Seine",12635,48.906872,2.179199 ],
    [ u"fr",u"Carros",10849,43.789413,7.18395 ],
    [ u"fr",u"Carvin",18397,50.492985,2.96826 ],
    [ u"fr",u"Castelnaudary",10730,43.318288,1.954494 ],
    [ u"fr",u"Castelnau-le-Lez",16890,43.633331,3.9 ],
    [ u"fr",u"Castres",43013,43.604992,2.243259 ],
    [ u"fr",u"Caudebec-lès-Elbeuf",9998,49.280817,1.02195 ],
    [ u"fr",u"Caudry",13503,50.124905,3.411859 ],
    [ u"fr",u"Cavaillon",25890,43.836033,5.040492 ],
    [ u"fr",u"Cenon",21483,44.8559,-.51839 ],
    [ u"fr",u"Cergy",60288,49.036448,2.076133 ],
    [ u"fr",u"Cernay",10614,47.808694,7.175062 ],
    [ u"fr",u"Cestas",17230,44.743446,-.67905 ],
    [ u"fr",u"Châlette-sur-Loing",13771,48.013368,2.735871 ],
    [ u"fr",u"Challans",17688,46.843626,-1.874905 ],
    [ u"fr",u"Châlons-en-Champagne",46981,48.953926,4.367238 ],
    [ u"fr",u"Chalon-sur-Saône",47968,46.78875,4.84877 ],
    [ u"fr",u"Chamalières",18853,45.77559,3.063097 ],
    [ u"fr",u"Chambéry",57591,45.564646,5.926453 ],
    [ u"fr",u"Chamonix-Mont-Blanc",10061,45.924308,6.867316 ],
    [ u"fr",u"Champagnole",8313,46.744516,5.913538 ],
    [ u"fr",u"Champigny-sur-Marne",71985,48.81642,2.493656 ],
    [ u"fr",u"Chanteloup-les-Vignes",9311,48.976144,2.032614 ],
    [ u"fr",u"Chantilly",10772,49.192811,2.464271 ],
    [ u"fr",u"Charenton-le-Pont",30298,48.822086,2.412167 ],
    [ u"fr",u"Charleville-Mézières",54946,49.768501,4.724866 ],
    [ u"fr",u"Chartres",41229,48.448201,1.491737 ],
    [ u"fr",u"Châteaudun",14786,48.068709,1.343312 ],
    [ u"fr",u"Château-Gontier",11267,47.827711,-.700268 ],
    [ u"fr",u"Châteauneuf-lès-Martigues",11225,43.384848,5.16283 ],
    [ u"fr",u"Châteaurenard",14088,43.882248,4.853279 ],
    [ u"fr",u"Châteauroux",49170,46.812479,1.693623 ],
    [ u"fr",u"Château-Thierry",14873,49.05,3.4 ],
    [ u"fr",u"Châtellerault",34022,46.815274,.541305 ],
    [ u"fr",u"Châtenay-Malabry",31708,48.765068,2.266547 ],
    [ u"fr",u"Châtillon",30261,48.802396,2.293464 ],
    [ u"fr",u"Chatou",29450,48.889803,2.158627 ],
    [ u"fr",u"Chaumont",25562,48.12282,5.141413 ],
    [ u"fr",u"Chauny",12374,49.615144,3.218571 ],
    [ u"fr",u"Chaville",18166,48.805653,2.188642 ],
    [ u"fr",u"Chelles",46390,48.883333,2.6 ],
    [ u"fr",u"Chenôve",15551,47.293232,5.004569 ],
    [ u"fr",u"Cherbourg",24435,49.639971,-1.615505 ],
    [ u"fr",u"Chevilly-Larue",19630,48.76476,2.350297 ],
    [ u"fr",u"Chilly-Mazarin",18523,48.714893,2.316378 ],
    [ u"fr",u"Choisy-le-Roi",34757,48.768463,2.418736 ],
    [ u"fr",u"Cholet",54292,47.060836,-.875481 ],
    [ u"fr",u"Clamart",49508,48.802987,2.266917 ],
    [ u"fr",u"Claye-Souilly",10648,48.944924,2.68566 ],
    [ u"fr",u"Clermont",10368,49.380338,2.411622 ],
    [ u"fr",u"Clermont-Ferrand",137364,45.779657,3.086281 ],
    [ u"fr",u"Clichy",50908,48.90018,2.309525 ],
    [ u"fr",u"Clichy-sous-Bois",28642,48.910197,2.553235 ],
    [ u"fr",u"Cluses",18907,46.064816,6.588355 ],
    [ u"fr",u"Cognac",19585,45.7,-.333333 ],
    [ u"fr",u"Colmar",66637,48.078708,7.355401 ],
    [ u"fr",u"Colombes",76209,48.918824,2.254044 ],
    [ u"fr",u"Colomiers",29888,43.613709,1.334631 ],
    [ u"fr",u"Combs-la-Ville",22067,48.664967,2.569571 ],
    [ u"fr",u"Comines",12467,50.761503,3.010633 ],
    [ u"fr",u"Compiègne",41508,49.416667,2.833333 ],
    [ u"fr",u"Concarneau",20178,47.875019,-3.922449 ],
    [ u"fr",u"Conflans-Sainte-Honorine",35122,49.001575,2.096945 ],
    [ u"fr",u"Corbeil-Essonnes",38760,48.606034,2.487571 ],
    [ u"fr",u"Cormeilles-en-Parisis",21487,48.971112,2.204912 ],
    [ u"fr",u"Coudekerque-Branche",24669,51.022884,2.393586 ],
    [ u"fr",u"Couëron",19016,47.215077,-1.721712 ],
    [ u"fr",u"Coulommiers",14672,48.81451,3.084983 ],
    [ u"fr",u"Courbevoie",70896,48.897,2.2564 ],
    [ u"fr",u"Courcouronnes",14617,48.614287,2.407623 ],
    [ u"fr",u"Courrières",10202,50.457013,2.947245 ],
    [ u"fr",u"Coutances",9503,49.052141,-1.438687 ],
    [ u"fr",u"Cran-Gévrier",17317,45.903908,6.101226 ],
    [ u"fr",u"Creil",30250,49.256722,2.484771 ],
    [ u"fr",u"Crépy-en-Valois",15487,49.233587,2.888071 ],
    [ u"fr",u"Créteil",84133,48.792661,2.465694 ],
    [ u"fr",u"Creutzwald",13970,49.199657,6.689863 ],
    [ u"fr",u"Croissy-sur-Seine",10501,48.879248,2.138365 ],
    [ u"fr",u"Croix",21062,50.678464,3.149304 ],
    [ u"fr",u"Cugnaux",14348,43.536188,1.344141 ],
    [ u"fr",u"Cusset",13359,46.130017,3.459632 ],
    [ u"fr",u"Darnétal",8993,49.445327,1.151438 ],
    [ u"fr",u"Dax",19827,43.706102,-1.053855 ],
    [ u"fr",u"Décines-Charpieu",24661,45.768991,4.972767 ],
    [ u"fr",u"Denain",20736,50.329295,3.394298 ],
    [ u"fr",u"Deuil-la-Barre",21233,48.976743,2.327222 ],
    [ u"fr",u"Déville-lès-Rouen",10483,49.469423,1.052144 ],
    [ u"fr",u"Dieppe",34788,49.920403,1.086542 ],
    [ u"fr",u"Digoin",8368,46.481236,3.979459 ],
    [ u"fr",u"Dijon",153692,47.316667,5.016667 ],
    [ u"fr",u"Dinan",10257,48.454561,-2.048525 ],
    [ u"fr",u"Dinard",10880,48.631433,-2.061445 ],
    [ u"fr",u"Dole",24186,47.092847,5.493003 ],
    [ u"fr",u"Dombasle-sur-Meurthe",8896,48.625201,6.349671 ],
    [ u"fr",u"Domont",16314,49.027821,2.326384 ],
    [ u"fr",u"Douai",43404,50.372362,3.088996 ],
    [ u"fr",u"Douchy-les-Mines",10174,50.300795,3.392699 ],
    [ u"fr",u"Dourdan",10036,48.527725,2.011133 ],
    [ u"fr",u"Draguignan",35217,43.536545,6.463455 ],
    [ u"fr",u"Drancy",63535,48.925785,2.445327 ],
    [ u"fr",u"Draveil",28638,48.684657,2.414175 ],
    [ u"fr",u"Dreux",30303,48.735358,1.365537 ],
    [ u"fr",u"Dunkirk",71740,51.05,2.366667 ],
    [ u"fr",u"Eaubonne",23739,48.997124,2.282494 ],
    [ u"fr",u"Échirolles",32133,45.143898,5.728831 ],
    [ u"fr",u"Écully",17940,45.77726,4.77481 ],
    [ u"fr",u"Élancourt",30088,48.784205,1.955195 ],
    [ u"fr",u"Elbeuf",16613,49.286688,1.002876 ],
    [ u"fr",u"Enghien-les-Bains",10675,48.966667,2.316667 ],
    [ u"fr",u"Épernay",25573,49.042267,3.95809 ],
    [ u"fr",u"Épinal",35423,48.18324,6.453043 ],
    [ u"fr",u"Épinay-sous-Sénart",12620,48.689701,2.511863 ],
    [ u"fr",u"Épinay-sur-Orge",9351,48.673384,2.310739 ],
    [ u"fr",u"Épinay-sur-Seine",45614,48.953505,2.315139 ],
    [ u"fr",u"Éragny",15040,49.016667,2.1 ],
    [ u"fr",u"Ermont",27575,48.990043,2.25804 ],
    [ u"fr",u"Escaudain",9252,50.333147,3.344296 ],
    [ u"fr",u"Étampes",22399,48.433046,2.175806 ],
    [ u"fr",u"Étaples",11191,50.516667,1.640689 ],
    [ u"fr",u"Évreux",53040,49.023288,1.155517 ],
    [ u"fr",u"Évry",51978,48.632804,2.440492 ],
    [ u"fr",u"Eysines",19925,44.883522,-.646859 ],
    [ u"fr",u"Ézanville",8770,49.027941,2.367865 ],
    [ u"fr",u"Fameck",11966,49.30335,6.108598 ],
    [ u"fr",u"Fécamp",21300,49.756728,.372873 ],
    [ u"fr",u"Figeac",9720,44.611598,2.033065 ],
    [ u"fr",u"Firminy",17356,45.387323,4.290744 ],
    [ u"fr",u"Flers",16502,48.737217,-.574657 ],
    [ u"fr",u"Fleury-les-Aubrais",20981,47.933276,1.918111 ],
    [ u"fr",u"Fleury-Mérogis",8834,48.63108,2.361942 ],
    [ u"fr",u"Floirac",15928,44.83238,-.514107 ],
    [ u"fr",u"Florange",10533,49.323732,6.121196 ],
    [ u"fr",u"Foix",8661,42.960457,1.607872 ],
    [ u"fr",u"Fontainebleau",16217,48.405367,2.700199 ],
    [ u"fr",u"Fontaine",23869,45.198394,5.682654 ],
    [ u"fr",u"Fontenay-aux-Roses",23784,48.793253,2.29275 ],
    [ u"fr",u"Fontenay-le-Comte",13535,46.465715,-.800487 ],
    [ u"fr",u"Fontenay-le-Fleury",12403,48.812532,2.048632 ],
    [ u"fr",u"Fontenay-sous-Bois",51077,48.854419,2.482676 ],
    [ u"fr",u"Forbach",20938,49.185575,6.891406 ],
    [ u"fr",u"Fosses",10421,49.098083,2.509573 ],
    [ u"fr",u"Fos-sur-Mer",15783,43.438569,4.945717 ],
    [ u"fr",u"Fougères",21710,48.350305,-1.194229 ],
    [ u"fr",u"Fourmies",13610,50.015318,4.047837 ],
    [ u"fr",u"Francheville",11724,45.738792,4.772185 ],
    [ u"fr",u"Franconville",33870,48.983333,2.233333 ],
    [ u"fr",u"Fréjus",51514,43.432858,6.735237 ],
    [ u"fr",u"Fresnes",24335,48.757423,2.321484 ],
    [ u"fr",u"Frontignan",21511,43.448478,3.753997 ],
    [ u"fr",u"Gagny",37511,48.883333,2.533333 ],
    [ u"fr",u"Gaillac",11635,43.901111,1.902021 ],
    [ u"fr",u"Gaillard",10253,46.186794,6.21614 ],
    [ u"fr",u"Gap",38617,44.561514,6.081061 ],
    [ u"fr",u"Garches",18170,48.842257,2.182317 ],
    [ u"fr",u"Gardanne",20541,43.454638,5.469878 ],
    [ u"fr",u"Garges-lès-Gonesse",39285,48.966188,2.410676 ],
    [ u"fr",u"Genas",12584,45.732153,4.99943 ],
    [ u"fr",u"Gennevillers",41553,48.933333,2.3 ],
    [ u"fr",u"Gentilly",15639,48.812937,2.341701 ],
    [ u"fr",u"Gérardmer",8839,48.073456,6.877869 ],
    [ u"fr",u"Gerzat",9050,45.82432,3.144044 ],
    [ u"fr",u"Gien",14842,47.693316,2.630939 ],
    [ u"fr",u"Gif-sur-Yvette",22774,48.683333,2.133333 ],
    [ u"fr",u"Gisors",12062,49.281783,1.780098 ],
    [ u"fr",u"Givors",17777,45.584146,4.772558 ],
    [ u"fr",u"Gonesse",26212,48.986928,2.448922 ],
    [ u"fr",u"Goussainville",29494,49.013672,2.465948 ],
    [ u"fr",u"Gouvieux",9324,49.187047,2.41439 ],
    [ u"fr",u"Gradignan",22760,44.772615,-.613931 ],
    [ u"fr",u"Grand-Couronne",9311,49.355631,1.00647 ],
    [ u"fr",u"Grande-Synthe",22738,51.015397,2.299748 ],
    [ u"fr",u"Granville",13003,48.837401,-1.593931 ],
    [ u"fr",u"Grasse",46221,43.660921,6.92917 ],
    [ u"fr",u"Graulhet",12246,43.762838,1.988349 ],
    [ u"fr",u"Grenoble",154853,45.171546,5.722387 ],
    [ u"fr",u"Grigny",24600,48.659982,2.384137 ],
    [ u"fr",u"Guebwiller",12005,47.908124,7.209761 ],
    [ u"fr",u"Guérande",15124,47.329107,-2.428291 ],
    [ u"fr",u"Guéret",13834,46.172337,1.874562 ],
    [ u"fr",u"Gueugnon",7962,46.603569,4.06286 ],
    [ u"fr",u"Guipavas",13109,48.435221,-4.397224 ],
    [ u"fr",u"Gujan-Mestras",17953,44.633333,-1.066667 ],
    [ u"fr",u"Guyancourt",31107,48.773336,2.073927 ],
    [ u"fr",u"Hagondange",8935,49.251339,6.168115 ],
    [ u"fr",u"Haguenau",35807,48.814228,7.786232 ],
    [ u"fr",u"Halluin",20075,50.786277,3.126114 ],
    [ u"fr",u"Harfleur",8175,49.511248,.192722 ],
    [ u"fr",u"Harnes",13440,50.446427,2.904812 ],
    [ u"fr",u"Haubourdin",15508,50.608263,2.991429 ],
    [ u"fr",u"Hautmont",15289,50.247704,3.924607 ],
    [ u"fr",u"Hayange",14729,49.334278,6.052675 ],
    [ u"fr",u"Hazebrouck",22109,50.723741,2.537292 ],
    [ u"fr",u"Hem",19497,50.656636,3.189708 ],
    [ u"fr",u"Hendaye",13423,43.37172,-1.773821 ],
    [ u"fr",u"Hénin-Beaumont",24725,50.413587,2.964852 ],
    [ u"fr",u"Hennebont",13423,47.805121,-3.273366 ],
    [ u"fr",u"Herblay",24116,48.989935,2.169902 ],
    [ u"fr",u"Héricourt",10488,47.573048,6.761392 ],
    [ u"fr",u"Hérouville-Saint-Clair",23792,49.210875,-.30653 ],
    [ u"fr",u"Hirson",10529,49.922619,4.082586 ],
    [ u"fr",u"Hoenheim",10834,48.620287,7.770066 ],
    [ u"fr",u"Hombourg-Haut",9522,49.123586,6.773968 ],
    [ u"fr",u"Houilles",30101,48.921609,2.192631 ],
    [ u"fr",u"Hyères",54588,43.119539,6.13897 ],
    [ u"fr",u"Igny",9484,48.744369,2.224277 ],
    [ u"fr",u"Illkirch-Graffenstaden",25023,48.523635,7.71542 ],
    [ u"fr",u"Illzach",14729,47.780882,7.346624 ],
    [ u"fr",u"Issoire",14034,45.548695,3.249423 ],
    [ u"fr",u"Issoudun",13676,46.948477,1.993623 ],
    [ u"fr",u"Issy-les-Moulineaux",57127,48.821042,2.277183 ],
    [ u"fr",u"Istres",42036,43.509052,4.987973 ],
    [ u"fr",u"Ivry-sur-Seine",49463,48.81568,2.384868 ],
    [ u"fr",u"Jarville-la-Malgrange",9658,48.66907,6.206364 ],
    [ u"fr",u"Jeumont",10687,50.295338,4.098979 ],
    [ u"fr",u"Joigny",10355,47.982883,3.400958 ],
    [ u"fr",u"Joinville-le-Pont",17542,48.82538,2.474576 ],
    [ u"fr",u"Joué-lés-Tours",36725,47.352234,.669055 ],
    [ u"fr",u"Jouy-le-Moutier",18705,49.010676,2.040282 ],
    [ u"fr",u"Juvisy-sur-Orge",12185,48.683333,2.383333 ],
    [ u"fr",u"Kingersheim",12528,47.792586,7.334908 ],
    [ u"fr",u"La Baule-Escoublac",16658,47.285604,-2.394031 ],
    [ u"fr",u"La Celle-Saint-Cloud",21069,48.85029,2.145234 ],
    [ u"fr",u"La Chapelle-sur-Erdre",17646,47.295835,-1.553093 ],
    [ u"fr",u"La Ciotat",32596,43.176032,5.607892 ],
    [ u"fr",u"La Courneuve",35862,48.92805,2.396273 ],
    [ u"fr",u"La Crau",17335,43.149807,6.074247 ],
    [ u"fr",u"La Ferté-Bernard",9245,48.18633,.653568 ],
    [ u"fr",u"La Flèche",15559,47.703042,-.077532 ],
    [ u"fr",u"La Garde",28016,43.122773,6.007453 ],
    [ u"fr",u"La Garenne-Colombes",25781,48.904718,2.2469 ],
    [ u"fr",u"La Madeleine",23098,50.660329,3.071575 ],
    [ u"fr",u"Lamballe",11085,48.467617,-2.514361 ],
    [ u"fr",u"Lambersart",28256,50.65,3.033333 ],
    [ u"fr",u"La Motte-Servolex",12172,45.594156,5.87575 ],
    [ u"fr",u"Landerneau",14419,48.452517,-4.252517 ],
    [ u"fr",u"Lanester",22065,47.761319,-3.339652 ],
    [ u"fr",u"Langres",9416,47.85896,5.332966 ],
    [ u"fr",u"Lannion",19495,48.732445,-3.459116 ],
    [ u"fr",u"Laon",26340,49.563098,3.627137 ],
    [ u"fr",u"La Queue-en-Brie",11589,48.785198,2.58112 ],
    [ u"fr",u"La Ricamarie",7527,45.416843,4.311988 ],
    [ u"fr",u"La Rochelle",80406,46.166667,-1.15 ],
    [ u"fr",u"La Roche-sur-Yon",52595,46.666667,-1.433333 ],
    [ u"fr",u"La Seyne-sur-Mer",61417,43.098184,5.884715 ],
    [ u"fr",u"La Teste-de-Buch",25116,44.628749,-1.140591 ],
    [ u"fr",u"La Trinité",10101,43.741487,7.313533 ],
    [ u"fr",u"Lattes",16857,43.567522,3.904604 ],
    [ u"fr",u"La Valette-du-Var",22816,43.137413,5.983139 ],
    [ u"fr",u"Laval",51626,48.073203,-.763399 ],
    [ u"fr",u"Laxou",15264,48.683146,6.147995 ],
    [ u"fr",u"Le Blanc-Mesnil",47234,48.938725,2.461383 ],
    [ u"fr",u"Le Bourget",12503,48.934052,2.435838 ],
    [ u"fr",u"Le Bouscat",23331,44.866002,-.59411 ],
    [ u"fr",u"Le Cannet",42659,43.574445,7.006431 ],
    [ u"fr",u"Le Chambon-Feugerolles",13080,45.396887,4.325923 ],
    [ u"fr",u"Le Chesnay",28353,48.822203,2.122129 ],
    [ u"fr",u"Le Creusot",24836,46.807138,4.41632 ],
    [ u"fr",u"Leers",9741,50.682172,3.244289 ],
    [ u"fr",u"Le Grand-Quevilly",26342,49.400761,1.045824 ],
    [ u"fr",u"Le Havre",188605,49.5,.133333 ],
    [ u"fr",u"Le Kremlin-Bicêtre",27194,48.814713,2.360728 ],
    [ u"fr",u"Le Mans",147413,48.000386,.204709 ],
    [ u"fr",u"Le Mée-sur-Seine",21861,48.531566,2.628287 ],
    [ u"fr",u"Lens",36979,50.431178,2.833213 ],
    [ u"fr",u"Le Passage",8887,45.531697,5.505376 ],
    [ u"fr",u"Le Pecq",16151,48.89317,2.103714 ],
    [ u"fr",u"Le Petit-Quevilly",22373,49.413384,1.06155 ],
    [ u"fr",u"Le Plessis-Robinson",21931,48.788887,2.270778 ],
    [ u"fr",u"Le Plessis-Trévise",18254,48.810737,2.573626 ],
    [ u"fr",u"Le Pont-de-Claix",11597,45.124434,5.706396 ],
    [ u"fr",u"Le Pontet",15747,43.96625,4.860409 ],
    [ u"fr",u"Le Portel",10880,50.705587,1.575745 ],
    [ u"fr",u"Le Pradet",12070,43.106607,6.017185 ],
    [ u"fr",u"Le Pré-Saint-Gervais",17220,48.88549,2.404224 ],
    [ u"fr",u"Le Raincy",12770,48.895926,2.526372 ],
    [ u"fr",u"Les Clayes-sous-Bois",17491,48.822056,1.986773 ],
    [ u"fr",u"Les Herbiers",14433,46.866667,-1.016667 ],
    [ u"fr",u"Les Lilas",20499,48.879918,2.420573 ],
    [ u"fr",u"Les Mureaux",31406,48.991733,1.909718 ],
    [ u"fr",u"Les Pavillons-sous-Bois",19309,48.90683,2.506483 ],
    [ u"fr",u"Les Ponts-de-Cé",11757,47.424076,-.524165 ],
    [ u"fr",u"Levallois-Perret",59434,48.893889,2.288635 ],
    [ u"fr",u"Le Vésinet",16162,48.892811,2.133082 ],
    [ u"fr",u"Libercourt",8393,50.483225,3.015844 ],
    [ u"fr",u"Libourne",22514,44.916667,-.233333 ],
    [ u"fr",u"Liévin",33588,50.419797,2.78068 ],
    [ u"fr",u"Lillebonne",10099,49.520298,.536166 ],
    [ u"fr",u"Lille",189746,50.632971,3.058585 ],
    [ u"fr",u"Lillers",9929,50.56345,2.48042 ],
    [ u"fr",u"Limay",18306,48.995532,1.740814 ],
    [ u"fr",u"Limeil-Brévannes",18658,48.744795,2.48705 ],
    [ u"fr",u"Limoges",134549,45.831534,1.257805 ],
    [ u"fr",u"Limoux",9353,43.054021,2.218795 ],
    [ u"fr",u"Lingolsheim",17242,48.558334,7.684356 ],
    [ u"fr",u"Lisieux",23100,49.147664,.226625 ],
    [ u"fr",u"Livry-Gargan",38935,48.919303,2.543051 ],
    [ u"fr",u"Lognes",15391,48.835407,2.62998 ],
    [ u"fr",u"Lomme",29084,50.643579,2.987148 ],
    [ u"fr",u"Longjumeau",20301,48.695029,2.307355 ],
    [ u"fr",u"Longuenesse",12570,50.733954,2.235195 ],
    [ u"fr",u"Longwy",13971,49.519364,5.768815 ],
    [ u"fr",u"Lons-le-Saunier",18245,46.675351,5.55575 ],
    [ u"fr",u"Lons",12684,43.316666,-.4 ],
    [ u"fr",u"Loos",21167,50.609823,3.018743 ],
    [ u"fr",u"Lorient",59242,47.75,-3.366667 ],
    [ u"fr",u"Lormont",21437,44.874949,-.517819 ],
    [ u"fr",u"Loudéac",9177,48.178258,-2.75433 ],
    [ u"fr",u"Lourdes",14671,43.099998,-.05 ],
    [ u"fr",u"Louviers",18401,49.216667,1.166667 ],
    [ u"fr",u"Lucé",17295,48.436895,1.463588 ],
    [ u"fr",u"Lunel",25598,43.675482,4.136189 ],
    [ u"fr",u"Lunéville",20017,48.591172,6.495426 ],
    [ u"fr",u"Lure",8736,47.685152,6.498127 ],
    [ u"fr",u"Luxeuil-les-Bains",8261,47.817099,6.364997 ],
    [ u"fr",u"Lyon",463700,45.748457,4.846711 ],
    [ u"fr",u"Mâcon",33004,46.314074,4.828233 ],
    [ u"fr",u"Maisons-Alfort",50249,48.811707,2.43945 ],
    [ u"fr",u"Maisons-Laffitte",22006,48.952636,2.145207 ],
    [ u"fr",u"Maizières-lès-Metz",9708,49.207544,6.160515 ],
    [ u"fr",u"Malakoff",28583,48.819988,2.299977 ],
    [ u"fr",u"Manosque",20170,43.832871,5.783948 ],
    [ u"fr",u"Mantes-la-Jolie",43439,48.990163,1.70792 ],
    [ u"fr",u"Mantes-la-Ville",19639,48.973736,1.702529 ],
    [ u"fr",u"Marck",9012,50.948965,1.943275 ],
    [ u"fr",u"Marcq-en-Baroeul",37837,50.681615,3.09561 ],
    [ u"fr",u"Marignane",35453,43.416043,5.214526 ],
    [ u"fr",u"Marly-le-Roi",17041,48.866667,2.083333 ],
    [ u"fr",u"Marly",10637,49.062188,6.151934 ],
    [ u"fr",u"Marly",11497,50.345561,3.549588 ],
    [ u"fr",u"Marmande",17143,44.500371,.16546 ],
    [ u"fr",u"Maromme",12302,49.479248,1.023748 ],
    [ u"fr",u"Marseille",792823,43.285413,5.37606 ],
    [ u"fr",u"Martigues",44437,43.405088,5.05348 ],
    [ u"fr",u"Massy",37529,48.726924,2.283007 ],
    [ u"fr",u"Maubeuge",33017,50.278499,3.974426 ],
    [ u"fr",u"Mauguio",17688,43.618096,4.007387 ],
    [ u"fr",u"Maurepas",19817,48.764859,1.92923 ],
    [ u"fr",u"Mayenne",13969,48.302042,-.618914 ],
    [ u"fr",u"Mazamet",10071,43.490014,2.373037 ],
    [ u"fr",u"Meaux",50910,48.963579,2.882403 ],
    [ u"fr",u"Melun",36223,48.545699,2.653562 ],
    [ u"fr",u"Mende",12214,44.518486,3.50372 ],
    [ u"fr",u"Mennecy",14216,48.569028,2.443839 ],
    [ u"fr",u"Menton",29199,43.774227,7.499087 ],
    [ u"fr",u"Méricourt",11450,50.401157,2.86246 ],
    [ u"fr",u"Mérignac",65847,44.832475,-.633809 ],
    [ u"fr",u"Méru",13430,49.233333,2.133333 ],
    [ u"fr",u"Merville",8894,50.643294,2.641251 ],
    [ u"fr",u"Metz",128021,49.115461,6.175875 ],
    [ u"fr",u"Meudon",42802,48.813807,2.235 ],
    [ u"fr",u"Meylan",19569,45.219879,5.790074 ],
    [ u"fr",u"Meyzieu",28198,45.770489,5.00007 ],
    [ u"fr",u"Millau",21215,44.098553,3.080528 ],
    [ u"fr",u"Mions",11171,45.664319,4.949939 ],
    [ u"fr",u"Miramas",23354,43.586663,5.00464 ],
    [ u"fr",u"Mitry-Mory",18409,48.983333,2.616667 ],
    [ u"fr",u"Moissac",12686,44.102361,1.094502 ],
    [ u"fr",u"Moissy-Cramayel",16104,48.626052,2.601247 ],
    [ u"fr",u"Mondeville",11193,49.170604,-.317979 ],
    [ u"fr",u"Mons-en-Baroeul",22710,50.636925,3.110259 ],
    [ u"fr",u"Montargis",15048,48.001158,2.753601 ],
    [ u"fr",u"Montataire",12031,49.258999,2.437766 ],
    [ u"fr",u"Montauban",52818,44.018194,1.364319 ],
    [ u"fr",u"Montbéliard",26895,47.510316,6.798629 ],
    [ u"fr",u"Montbrison",15072,45.606096,4.067416 ],
    [ u"fr",u"Montceau-les-Mines",19375,46.666667,4.366667 ],
    [ u"fr",u"Mont-de-Marsan",30529,43.889518,-.500476 ],
    [ u"fr",u"Montélimar",32631,44.558379,4.750937 ],
    [ u"fr",u"Montesson",14947,48.909238,2.137539 ],
    [ u"fr",u"Montfermeil",23484,48.898203,2.579128 ],
    [ u"fr",u"Montgeron",22319,48.705431,2.45039 ],
    [ u"fr",u"Montigny-en-Gohelle",10603,50.425403,2.939019 ],
    [ u"fr",u"Montigny-le-Bretonneux",38264,48.766356,2.03405 ],
    [ u"fr",u"Montigny-lès-Cormeilles",17587,48.982015,2.200347 ],
    [ u"fr",u"Montigny-lès-Metz",24655,49.094353,6.151673 ],
    [ u"fr",u"Montivilliers",16390,49.545182,.187688 ],
    [ u"fr",u"Montluçon",39664,46.333333,2.6 ],
    [ u"fr",u"Montmagny",14305,48.973377,2.346885 ],
    [ u"fr",u"Montmorency",20723,48.988258,2.343398 ],
    [ u"fr",u"Montpellier",238887,43.61092,3.87723 ],
    [ u"fr",u"Montreuil",89125,48.864151,2.443218 ],
    [ u"fr",u"Montrouge",37670,48.816202,2.313935 ],
    [ u"fr",u"Mont-Saint-Aignan",22380,49.463073,1.093637 ],
    [ u"fr",u"Morangis",11145,48.703827,2.339084 ],
    [ u"fr",u"Morlaix",15696,48.58733,-3.825005 ],
    [ u"fr",u"Morsang-sur-Orge",19567,48.661805,2.353385 ],
    [ u"fr",u"Mougins",18615,43.598726,7.004343 ],
    [ u"fr",u"Moulins",21425,46.566667,3.333333 ],
    [ u"fr",u"Mouvaux",13035,50.699435,3.134292 ],
    [ u"fr",u"Moyeuvre-Grande",8826,49.251646,6.047541 ],
    [ u"fr",u"Mulhouse",111972,47.738082,7.347932 ],
    [ u"fr",u"Muret",22819,43.465874,1.327316 ],
    [ u"fr",u"Nancy",106857,48.69211,6.187756 ],
    [ u"fr",u"Nanterre",84448,48.891373,2.20027 ],
    [ u"fr",u"Nantes",284677,47.216509,-1.552379 ],
    [ u"fr",u"Narbonne",47433,43.184417,3.008816 ],
    [ u"fr",u"Nemours",13743,48.27511,2.690778 ],
    [ u"fr",u"Neuilly-Plaisance",18446,48.859523,2.502783 ],
    [ u"fr",u"Neuilly-sur-Marne",33940,48.853733,2.549027 ],
    [ u"fr",u"Neuilly-sur-Seine",57141,48.883333,2.266667 ],
    [ u"fr",u"Neuville-en-Ferrain",9372,50.748391,3.156756 ],
    [ u"fr",u"Nevers",40520,46.991203,3.157084 ],
    [ u"fr",u"Nice",341621,43.713644,7.25952 ],
    [ u"fr",u"Nîmes",137532,43.833778,4.359623 ],
    [ u"fr",u"Niort",56715,46.323875,-.461334 ],
    [ u"fr",u"Noeux-les-Mines",11828,50.475481,2.667939 ],
    [ u"fr",u"Nogent-le-Rotrou",11657,48.320197,.820593 ],
    [ u"fr",u"Nogent-sur-Marne",30453,48.838814,2.478642 ],
    [ u"fr",u"Nogent-sur-Oise",19184,49.271579,2.470741 ],
    [ u"fr",u"Noisiel",15205,48.848675,2.624346 ],
    [ u"fr",u"Noisy-le-Grand",61650,48.849792,2.562658 ],
    [ u"fr",u"Noisy-le-Sec",38153,48.891481,2.46451 ],
    [ u"fr",u"Notre-Dame-de-Gravenchon",8511,49.489405,.571878 ],
    [ u"fr",u"Noyon",14711,49.583333,3 ],
    [ u"fr",u"Obernai",11146,48.462783,7.481764 ],
    [ u"fr",u"Octeville",16417,49.626118,-1.643486 ],
    [ u"fr",u"Oignies",10539,50.463311,2.993761 ],
    [ u"fr",u"Oissel",11100,49.333093,1.094129 ],
    [ u"fr",u"Olivet",20579,47.862194,1.8991 ],
    [ u"fr",u"Ollioules",13730,43.135174,5.848004 ],
    [ u"fr",u"Oloron-Sainte-Marie",11007,43.200001,-.6 ],
    [ u"fr",u"Onnaing",8603,50.38584,3.599627 ],
    [ u"fr",u"Orange",29053,44.139195,4.807906 ],
    [ u"fr",u"Orléans",118190,47.902891,1.903887 ],
    [ u"fr",u"Orly",19830,48.747921,2.392525 ],
    [ u"fr",u"Ormesson-sur-Marne",9710,48.786295,2.544712 ],
    [ u"fr",u"Orsay",17418,48.695722,2.187268 ],
    [ u"fr",u"Orthez",10203,43.488385,-.77244 ],
    [ u"fr",u"Orvault",24080,47.270949,-1.621902 ],
    [ u"fr",u"Osny",16027,49.059366,2.061833 ],
    [ u"fr",u"Ostwald",11224,48.544203,7.71087 ],
    [ u"fr",u"Oullins",24803,45.717743,4.80382 ],
    [ u"fr",u"Outreau",15316,50.705354,1.589696 ],
    [ u"fr",u"Oyonnax",24712,46.250567,5.659845 ],
    [ u"fr",u"Ozoir-la-Ferrière",22320,48.766993,2.668712 ],
    [ u"fr",u"Palaiseau",29749,48.716736,2.249106 ],
    [ u"fr",u"Pantin",52147,48.894369,2.409346 ],
    [ u"fr",u"Paray-le-Monial",8867,46.454574,4.115844 ],
    [ u"fr",u"Paris",2110694,48.866667,2.333333 ],
    [ u"fr",u"Parthenay",10352,46.645813,-.24463 ],
    [ u"fr",u"Passy",10859,45.920277,6.687651 ],
    [ u"fr",u"Pau",77475,43.299999,-.366667 ],
    [ u"fr",u"Périgueux",30198,45.183333,.716667 ],
    [ u"fr",u"Perpignan",104783,42.696172,2.897098 ],
    [ u"fr",u"Persan",9138,49.153355,2.272179 ],
    [ u"fr",u"Pertuis",19530,43.69252,5.502854 ],
    [ u"fr",u"Pessac",59818,44.810112,-.641294 ],
    [ u"fr",u"Pierre-Bénite",10304,45.700895,4.825112 ],
    [ u"fr",u"Pierrefitte-sur-Seine",27441,48.966907,2.361036 ],
    [ u"fr",u"Pierrelatte",12201,44.377556,4.701976 ],
    [ u"fr",u"Pithiviers",9313,48.175047,2.252062 ],
    [ u"fr",u"Plaisance-du-Touch",17770,43.565663,1.297494 ],
    [ u"fr",u"Plaisir",35407,48.823186,1.954099 ],
    [ u"fr",u"Plan-de-Cuques",10995,43.346437,5.462554 ],
    [ u"fr",u"Plérin",12890,48.542494,-2.779835 ],
    [ u"fr",u"Ploemeur",18944,47.733333,-3.433333 ],
    [ u"fr",u"Ploufragan",10651,48.491411,-2.794576 ],
    [ u"fr",u"Plougastel-Daoulas",13128,48.366667,-4.366667 ],
    [ u"fr",u"Plouzané",12588,48.383333,-4.616667 ],
    [ u"fr",u"Poissy",35663,48.92902,2.049521 ],
    [ u"fr",u"Poitiers",86639,46.583333,.333333 ],
    [ u"fr",u"Pont-à-Mousson",14657,48.907861,6.058897 ],
    [ u"fr",u"Pontarlier",18665,46.908792,6.35917 ],
    [ u"fr",u"Pont-Audemer",9125,49.35,.516667 ],
    [ u"fr",u"Pontivy",13789,48.066539,-2.96442 ],
    [ u"fr",u"Pontoise",28186,49.055272,2.105512 ],
    [ u"fr",u"Pont-Sainte-Maxence",13709,49.301677,2.604673 ],
    [ u"fr",u"Pont-Saint-Esprit",9382,44.254942,4.647364 ],
    [ u"fr",u"Port-de-Bouc",15621,43.406069,4.981073 ],
    [ u"fr",u"Porto-Vecchio",11065,41.589364,9.279907 ],
    [ u"fr",u"Privas",8722,44.733939,4.597013 ],
    [ u"fr",u"Provins",11958,48.561463,3.297725 ],
    [ u"fr",u"Puteaux",39752,48.878888,2.239264 ],
    [ u"fr",u"Quétigny",9628,47.31417,5.110176 ],
    [ u"fr",u"Quimperlé",11015,47.866667,-3.55 ],
    [ u"fr",u"Quimper",66251,48,-4.1 ],
    [ u"fr",u"Raismes",13554,50.383333,3.483333 ],
    [ u"fr",u"Rambouillet",25429,48.642276,1.831259 ],
    [ u"fr",u"Ramonville-Saint-Agne",11732,43.547937,1.470791 ],
    [ u"fr",u"Reims",192688,49.25,4.033333 ],
    [ u"fr",u"Remiremont",8274,48.017537,6.5882 ],
    [ u"fr",u"Rennes",213334,48.111981,-1.674291 ],
    [ u"fr",u"Revin",8770,49.936162,4.643896 ],
    [ u"fr",u"Rezé",37338,47.181441,-1.549654 ],
    [ u"fr",u"Riom",18557,45.892557,3.113549 ],
    [ u"fr",u"Riorges",10303,46.041786,4.049655 ],
    [ u"fr",u"Ris-Orangis",24628,48.651104,2.414057 ],
    [ u"fr",u"Rive-de-Gier",13733,45.530668,4.621306 ],
    [ u"fr",u"Rixheim",13348,47.751403,7.400913 ],
    [ u"fr",u"Roanne",37144,46.043291,4.068553 ],
    [ u"fr",u"Rochefort",26150,45.941828,-.967334 ],
    [ u"fr",u"Roche-la-Molière",10160,45.43408,4.322765 ],
    [ u"fr",u"Rodez",23268,44.35237,2.572616 ],
    [ u"fr",u"Rognac",12096,43.488925,5.229288 ],
    [ u"fr",u"Roissy-en-Brie",20799,48.791594,2.64747 ],
    [ u"fr",u"Romainville",24158,48.8854,2.434819 ],
    [ u"fr",u"Romans-sur-Isère",32933,45.046388,5.056197 ],
    [ u"fr",u"Rombas",10764,49.249107,6.094054 ],
    [ u"fr",u"Romilly-sur-Seine",14158,48.510852,3.726338 ],
    [ u"fr",u"Ronchin",18177,50.598832,3.09056 ],
    [ u"fr",u"Roncq",13251,50.753296,3.121314 ],
    [ u"fr",u"Roquebrune-Cap-Martin",11416,43.764078,7.482065 ],
    [ u"fr",u"Rosny-sous-Bois",40571,48.870172,2.499104 ],
    [ u"fr",u"Roubaix",96806,50.694207,3.174556 ],
    [ u"fr",u"Rouen",108101,49.433333,1.083333 ],
    [ u"fr",u"Rouvroy",9072,49.854572,3.317458 ],
    [ u"fr",u"Royan",17408,45.628461,-1.0281 ],
    [ u"fr",u"Rueil-Malmaison",78645,48.876503,2.189666 ],
    [ u"fr",u"Rumilly",12278,45.868733,5.936522 ],
    [ u"fr",u"Sablé-sur-Sarthe",13182,47.839422,-.329716 ],
    [ u"fr",u"Saint-Amand-les-Eaux",17568,50.447176,3.43076 ],
    [ u"fr",u"Saint-André-les-Vergers",11085,48.285266,4.052104 ],
    [ u"fr",u"Saint-André-lez-Lille",10201,50.660169,3.040672 ],
    [ u"fr",u"Saint-Avertin",15619,47.363569,.739933 ],
    [ u"fr",u"Saint-Avold",17340,49.102696,6.700636 ],
    [ u"fr",u"Saint-Brice-sous-Forêt",13356,49.001318,2.353607 ],
    [ u"fr",u"Saint-Brieuc",43522,48.510504,-2.765927 ],
    [ u"fr",u"Saint-Chamond",36734,45.473646,4.525411 ],
    [ u"fr",u"Saint-Claude",12169,46.390153,5.863737 ],
    [ u"fr",u"Saint-Cloud",28009,48.845985,2.202889 ],
    [ u"fr",u"Saint-Cyr-sur-Loire",16907,47.4,.666667 ],
    [ u"fr",u"Saint-Denis",84027,48.934172,2.354805 ],
    [ u"fr",u"Saint-Dié",22682,48.281037,6.959461 ],
    [ u"fr",u"Saint-Dizier",29573,48.638001,4.945553 ],
    [ u"fr",u"Saint-Doulchard",9058,47.103712,2.351999 ],
    [ u"fr",u"Sainte-Foy-lès-Lyon",21206,45.73692,4.796883 ],
    [ u"fr",u"Sainte-Geneviève-des-Bois",33133,48.646824,2.319653 ],
    [ u"fr",u"Sainte-Luce-sur-Loire",12550,47.253807,-1.484296 ],
    [ u"fr",u"Sainte-Maxime",13291,43.309716,6.628328 ],
    [ u"fr",u"Sainte-Savine",10631,48.296369,4.046417 ],
    [ u"fr",u"Saintes",25616,45.745604,-.631674 ],
    [ u"fr",u"Saint-Estève",9919,42.711755,2.844896 ],
    [ u"fr",u"Saint-Étienne-du-Rouvray",28344,49.377941,1.104673 ],
    [ u"fr",u"Saint-Étienne",170416,45.435382,4.391051 ],
    [ u"fr",u"Saint-Fons",15760,45.708803,4.860567 ],
    [ u"fr",u"Saint-Gaudens",10698,43.110387,.725481 ],
    [ u"fr",u"Saint-Genis-Laval",19668,45.695582,4.793397 ],
    [ u"fr",u"Saint-Germain-en-Laye",38098,48.904194,2.086688 ],
    [ u"fr",u"Saint-Gilles",11995,43.677923,4.432586 ],
    [ u"fr",u"Saint-Gratien",19521,48.973497,2.287287 ],
    [ u"fr",u"Saint-Herblain",44790,47.217646,-1.64841 ],
    [ u"fr",u"Saint-Jean-de-Braye",18949,47.913029,1.977047 ],
    [ u"fr",u"Saint-Jean-de-la-Ruelle",16931,47.911271,1.864833 ],
    [ u"fr",u"Saint-Jean-de-Luz",13523,43.389075,-1.658095 ],
    [ u"fr",u"Saint-Jean-de-Maurienne",8671,45.284946,6.384018 ],
    [ u"fr",u"Saint-Junien",10779,45.888671,.901429 ],
    [ u"fr",u"Saint-Laurent-du-Var",29461,43.670968,7.17606 ],
    [ u"fr",u"Saint-Leu-la-Forêt",15812,49.016667,2.25 ],
    [ u"fr",u"Saint-Lô",19411,49.113813,-1.081905 ],
    [ u"fr",u"Saint-Louis",20387,47.588364,7.562469 ],
    [ u"fr",u"Saint-Malo",52909,48.6361,-2.004935 ],
    [ u"fr",u"Saint-Mandé",20516,48.838642,2.415791 ],
    [ u"fr",u"Saint-Martin-Boulogne",11892,50.726909,1.618642 ],
    [ u"fr",u"Saint-Martin-de-Crau",11117,43.638328,4.813693 ],
    [ u"fr",u"Saint-Maur-des-Fossés",71267,48.793945,2.493233 ],
    [ u"fr",u"Saint-Maurice",13975,48.821815,2.427157 ],
    [ u"fr",u"Saint-Maximin-la-Sainte-Baume",14807,43.452141,5.862186 ],
    [ u"fr",u"Saint-Max",10926,48.704294,6.209989 ],
    [ u"fr",u"Saint-Médard-en-Jalles",28405,44.896921,-.721356 ],
    [ u"fr",u"Saint-Michel-sur-Orge",20413,48.634788,2.30831 ],
    [ u"fr",u"Saint-Nazaire",66937,47.279883,-2.208804 ],
    [ u"fr",u"Saint-Omer",16785,50.748345,2.257656 ],
    [ u"fr",u"Saint-Orens-de-Gameville",12024,43.554021,1.534106 ],
    [ u"fr",u"Saint-Ouen",38590,48.9,2.333333 ],
    [ u"fr",u"Saint-Paul-lès-Dax",10850,43.727147,-1.051618 ],
    [ u"fr",u"Saint-Pierre-des-Corps",14679,47.386229,.748487 ],
    [ u"fr",u"Saint-Pol-sur-Mer",23205,51.03116,2.339835 ],
    [ u"fr",u"Saint-Priest",40824,45.696125,4.938915 ],
    [ u"fr",u"Saint-Quentin",58399,49.849176,3.288062 ],
    [ u"fr",u"Saint-Raphaël",33115,43.424758,6.770236 ],
    [ u"fr",u"Saint-Rémy-de-Provence",10211,43.787747,4.831401 ],
    [ u"fr",u"Saint-Saulve",11061,50.371412,3.556119 ],
    [ u"fr",u"Saint-Sébastien-sur-Loire",27631,47.195847,-1.509875 ],
    [ u"fr",u"Saint-Vallier",9332,46.641066,4.371069 ],
    [ u"fr",u"Sallanches",15747,45.936882,6.636638 ],
    [ u"fr",u"Sallaumines",10544,50.417491,2.861742 ],
    [ u"fr",u"Salon-de-Provence",39598,43.640737,5.095449 ],
    [ u"fr",u"Sanary-sur-Mer",18928,43.117835,5.800065 ],
    [ u"fr",u"Sannois",25858,48.966667,2.25 ],
    [ u"fr",u"Saran",15983,47.950127,1.876014 ],
    [ u"fr",u"Sarcelles",59372,48.99365,2.410771 ],
    [ u"fr",u"Sarlat-la-Canéda",9670,44.883333,1.216667 ],
    [ u"fr",u"Sarrebourg",13458,48.734217,7.056016 ],
    [ u"fr",u"Sarreguemines",23427,49.113579,7.072387 ],
    [ u"fr",u"Sartrouville",50954,48.948203,2.19169 ],
    [ u"fr",u"Saumur",30036,47.256629,-.075025 ],
    [ u"fr",u"Saverne",11925,48.740039,7.365086 ],
    [ u"fr",u"Savigny-le-Temple",25707,48.574087,2.582871 ],
    [ u"fr",u"Savigny-sur-Orge",38818,48.676775,2.348351 ],
    [ u"fr",u"Sceaux",20564,48.776442,2.290258 ],
    [ u"fr",u"Schiltigheim",32138,48.60557,7.747763 ],
    [ u"fr",u"Seclin",12061,50.548729,3.027313 ],
    [ u"fr",u"Sedan",19997,49.70022,4.948389 ],
    [ u"fr",u"Sélestat",18457,48.259323,7.454285 ],
    [ u"fr",u"Senlis",17910,49.207668,2.584531 ],
    [ u"fr",u"Sens",27060,48.2,3.283333 ],
    [ u"fr",u"Septèmes-les-Vallons",10165,43.400537,5.36979 ],
    [ u"fr",u"Sète",38788,43.406283,3.693041 ],
    [ u"fr",u"Sevran",46648,48.944716,2.527462 ],
    [ u"fr",u"Sèvres",22993,48.822916,2.217569 ],
    [ u"fr",u"Seynod",17733,45.885488,6.088313 ],
    [ u"fr",u"Seyssinet-Pariset",13135,45.176755,5.693872 ],
    [ u"fr",u"Sin-le-Noble",17431,50.361594,3.131128 ],
    [ u"fr",u"Soissons",29480,49.380825,3.327146 ],
    [ u"fr",u"Soisy-sous-Montmorency",17214,48.988126,2.301558 ],
    [ u"fr",u"Solliès-Pont",11933,43.189784,6.043205 ],
    [ u"fr",u"Somain",12132,50.359606,3.281081 ],
    [ u"fr",u"Sorgues",17978,44.008367,4.874924 ],
    [ u"fr",u"Sotteville-lès-Rouen",29848,49.409718,1.090055 ],
    [ u"fr",u"Soyaux",10156,45.65,.2 ],
    [ u"fr",u"Stains",31921,48.95,2.383333 ],
    [ u"fr",u"Stiring-Wendel",12872,49.2,6.933333 ],
    [ u"fr",u"Strasbourg",273506,48.600381,7.787355 ],
    [ u"fr",u"Sucy-en-Brie",24354,48.768716,2.534738 ],
    [ u"fr",u"Suresnes",42243,48.87143,2.229289 ],
    [ u"fr",u"Talant",11877,47.336935,5.008876 ],
    [ u"fr",u"Talence",39514,44.804768,-.595431 ],
    [ u"fr",u"Tarare",10319,45.897614,4.432722 ],
    [ u"fr",u"Tarascon",14080,43.805769,4.665598 ],
    [ u"fr",u"Tarbes",45628,43.233334,.083333 ],
    [ u"fr",u"Tarnos",10850,43.541205,-1.461599 ],
    [ u"fr",u"Tassin-la-Demi-Lune",16450,45.754987,4.788123 ],
    [ u"fr",u"Taverny",26828,49.025425,2.216907 ],
    [ u"fr",u"Tergnier",15296,49.656068,3.301071 ],
    [ u"fr",u"Thiais",28905,48.764965,2.3961 ],
    [ u"fr",u"Thiers",12576,45.858139,3.556275 ],
    [ u"fr",u"Thionville",41802,49.356794,6.167606 ],
    [ u"fr",u"Thonon-les-Bains",29698,46.372465,6.487007 ],
    [ u"fr",u"Thouars",10601,46.976018,-.215073 ],
    [ u"fr",u"Tinqueux",10137,49.25,3.983333 ],
    [ u"fr",u"Tonneins",8951,44.392063,.312408 ],
    [ u"fr",u"Torcy",24189,48.854483,2.650567 ],
    [ u"fr",u"Toulon",154465,43.117705,5.941712 ],
    [ u"fr",u"Toulouse",411145,43.599516,1.433188 ],
    [ u"fr",u"Toul",16848,48.674594,5.892905 ],
    [ u"fr",u"Tourcoing",93835,50.723907,3.161168 ],
    [ u"fr",u"Tourlaville",17763,49.638285,-1.566392 ],
    [ u"fr",u"Tournefeuille",28022,43.583905,1.34685 ],
    [ u"fr",u"Tournon-sur-Rhône",10314,45.065816,4.835274 ],
    [ u"fr",u"Tours",135143,47.394836,.703977 ],
    [ u"fr",u"Trappes",28013,48.774129,2.017811 ],
    [ u"fr",u"Trélazé",11481,47.445648,-.465395 ],
    [ u"fr",u"Triel-sur-Seine",12351,48.978181,2.007429 ],
    [ u"fr",u"Troyes",61903,48.300727,4.085244 ],
    [ u"fr",u"Tulle",14728,45.270009,1.773087 ],
    [ u"fr",u"Uckange",7264,49.303036,6.149202 ],
    [ u"fr",u"Ussel",10420,45.55,2.316667 ],
    [ u"fr",u"Vaires-sur-Marne",12418,48.876492,2.639816 ],
    [ u"fr",u"Valbonne",11782,43.641272,7.005747 ],
    [ u"fr",u"Valence",63754,44.92801,4.895103 ],
    [ u"fr",u"Valenciennes",42941,50.357065,3.527885 ],
    [ u"fr",u"Valentigney",12221,47.463879,6.83168 ],
    [ u"fr",u"Valenton",11716,48.74527,2.464669 ],
    [ u"fr",u"Vallauris",27144,43.577483,7.062556 ],
    [ u"fr",u"Valréas",9792,44.383661,4.990843 ],
    [ u"fr",u"Vandoeuvre-lès-Nancy",31012,48.662127,6.178281 ],
    [ u"fr",u"Vannes",56649,47.657897,-2.755735 ],
    [ u"fr",u"Vanves",25184,48.823451,2.290253 ],
    [ u"fr",u"Vaulx-en-Velin",36564,45.781801,4.920852 ],
    [ u"fr",u"Vauréal",20250,49.033333,2.033333 ],
    [ u"fr",u"Vauvert",10377,43.695289,4.277051 ],
    [ u"fr",u"Vélizy-Villacoublay",20426,48.781981,2.193947 ],
    [ u"fr",u"Vence",18399,43.721624,7.112324 ],
    [ u"fr",u"Vendôme",18006,47.807543,1.057611 ],
    [ u"fr",u"Vénissieux",53678,45.702538,4.871473 ],
    [ u"fr",u"Verdun",19048,49.158146,5.388608 ],
    [ u"fr",u"Verneuil-sur-Seine",16261,48.980817,1.966678 ],
    [ u"fr",u"Vernon",24688,49.092918,1.463324 ],
    [ u"fr",u"Vernouillet",11554,48.97146,1.980817 ],
    [ u"fr",u"Verrières-le-Buisson",16288,48.745653,2.267956 ],
    [ u"fr",u"Versailles",85134,48.803593,2.134236 ],
    [ u"fr",u"Vertou",21897,47.16869,-1.469294 ],
    [ u"fr",u"Vesoul",17050,47.626044,6.142506 ],
    [ u"fr",u"Vichy",25900,46.128264,3.423472 ],
    [ u"fr",u"Vienne",30651,45.524785,4.873453 ],
    [ u"fr",u"Vierzon",28503,47.216667,2.083333 ],
    [ u"fr",u"Vieux-Condé",10586,50.45944,3.567375 ],
    [ u"fr",u"Vigneux-sur-Seine",26310,48.702911,2.413574 ],
    [ u"fr",u"Villebon-sur-Yvette",9700,48.705944,2.240194 ],
    [ u"fr",u"Villefontaine",19076,45.612505,5.145577 ],
    [ u"fr",u"Villefranche-de-Rouergue",11775,44.350712,2.034177 ],
    [ u"fr",u"Villefranche-sur-Saône",31543,45.987214,4.728309 ],
    [ u"fr",u"Villejuif",46913,48.793899,2.359919 ],
    [ u"fr",u"Villemomble",27351,48.883333,2.5 ],
    [ u"fr",u"Villeneuve-la-Garenne",21557,48.939354,2.31478 ],
    [ u"fr",u"Villeneuve-le-Roi",17229,48.736837,2.400812 ],
    [ u"fr",u"Villeneuve-lès-Avignon",12688,43.968405,4.796298 ],
    [ u"fr",u"Villeneuve-Loubet",14120,43.666628,7.120396 ],
    [ u"fr",u"Villeneuve-Saint-Georges",29506,48.732194,2.44925 ],
    [ u"fr",u"Villeneuve-sur-Lot",22933,44.4071,.705603 ],
    [ u"fr",u"Villeparisis",23557,48.94208,2.61463 ],
    [ u"fr",u"Villepinte",36557,48.962034,2.532534 ],
    [ u"fr",u"Villers-lès-Nancy",15296,48.67103,6.150832 ],
    [ u"fr",u"Villerupt",9514,49.46737,5.932854 ],
    [ u"fr",u"Villeurbanne",126230,45.765502,4.875522 ],
    [ u"fr",u"Villiers-le-Bel",26611,49.008747,2.39819 ],
    [ u"fr",u"Villiers-sur-Marne",29652,48.830999,2.548441 ],
    [ u"fr",u"Vincennes",44781,48.848603,2.437692 ],
    [ u"fr",u"Vire",12898,48.843564,-.885237 ],
    [ u"fr",u"Viroflay",15803,48.800785,2.161808 ],
    [ u"fr",u"Viry-Châtillon",30479,48.672115,2.393179 ],
    [ u"fr",u"Vitré",16026,48.117755,-1.205771 ],
    [ u"fr",u"Vitrolles",38052,43.454847,5.24598 ],
    [ u"fr",u"Vitry-le-François",16714,48.727074,4.591969 ],
    [ u"fr",u"Vitry-sur-Seine",77035,48.787159,2.403322 ],
    [ u"fr",u"Voiron",20795,45.363948,5.592093 ],
    [ u"fr",u"Voisins-le-Bretonneux",12987,48.75793,2.051366 ],
    [ u"fr",u"Wasquehal",19030,50.670426,3.133819 ],
    [ u"fr",u"Wattignies",14474,50.586392,3.043938 ],
    [ u"fr",u"Wattrelos",42522,50.70118,3.218116 ],
    [ u"fr",u"Waziers",7431,50.387171,3.114902 ],
    [ u"fr",u"Wittelsheim",10164,47.802546,7.236579 ],
    [ u"fr",u"Wittenheim",15612,47.807801,7.337023 ],
    [ u"fr",u"Woippy",13508,49.149465,6.149088 ],
    [ u"fr",u"Yerres",28052,48.717853,2.493384 ],
    [ u"fr",u"Yvetot",10857,49.617442,.758138 ],
    [ u"fr",u"Yzeure",12306,46.564383,3.354949 ],
    [ u"ga",u"Bitam",10297,2.0833333,11.4833333 ],
    [ u"ga",u"Booué",5787,-0.1,11.9333333 ],
    [ u"ga",u"Cocobeach",1653,0.9833333,9.6 ],
    [ u"ga",u"Fougamou",5649,-1.2166667,10.6 ],
    [ u"ga",u"Gamba",9928,-2.65,10.0 ],
    [ u"ga",u"Kango",1516,0.15,10.1333333 ],
    [ u"ga",u"Koulamoutou",16222,-1.1333333,12.4833333 ],
    [ u"ga",u"Lambaréné",20714,-0.7,10.2166667 ],
    [ u"ga",u"Lastoursville",8340,-0.8166667,12.7 ],
    [ u"ga",u"Lékoni",3583,-1.5833333,14.2333333 ],
    [ u"ga",u"Libreville",578156,0.3833333,9.45 ],
    [ u"ga",u"Makokou",13571,0.5666667,12.8666667 ],
    [ u"ga",u"Mayumba",3996,-3.4166667,10.65 ],
    [ u"ga",u"Mbigou",4134,-1.8833333,11.9333333 ],
    [ u"ga",u"Mimongo",3307,-1.6333333,11.65 ],
    [ u"ga",u"Mitzic",3886,0.7833333,11.5666667 ],
    [ u"ga",u"Moanda",30151,-1.5666667,13.2 ],
    [ u"ga",u"Mouila",22469,-1.8666667,11.0166667 ],
    [ u"ga",u"Mounana",8780,-1.4333333,13.1666667 ],
    [ u"ga",u"Ndendé",6200,-2.3833333,11.3833333 ],
    [ u"ga",u"Ndjolé",5098,-0.1833333,10.75 ],
    [ u"ga",u"Nkan",8526,0.7166667,9.6666667 ],
    [ u"ga",u"Ntoum",8569,0.3666667,9.7833333 ],
    [ u"ga",u"Okandja",7155,-0.6833333,13.7833333 ],
    [ u"ga",u"Omboué",1667,-1.5666667,9.25 ],
    [ u"ga",u"Oyem",30870,1.6166667,11.5833333 ],
    [ u"ga",u"Port-Gentil",109163,-0.7166667,8.7833333 ],
    [ u"ga",u"Tchibanga",19365,-2.85,11.0333333 ],
    [ u"ga",u"Tsogni",9957,-2.8,10.1666667 ],
    [ u"gb",u"Aberchirder",1159,57.55,-2.616667 ],
    [ u"gb",u"Aberdare",32756,51.715,-3.454167 ],
    [ u"gb",u"Aberdeen",183791,57.133333,-2.1 ],
    [ u"gb",u"Aberdour",1742,56.05,-3.3 ],
    [ u"gb",u"Aberfeldy",1937,56.616667,-3.85 ],
    [ u"gb",u"Aberfoyle",577,56.183333,-4.383333 ],
    [ u"gb",u"Aberlady",876,56,-2.85 ],
    [ u"gb",u"Aberlour",828,57.466667,-3.233333 ],
    [ u"gb",u"Abernethy",1010,56.333333,-3.333333 ],
    [ u"gb",u"Aberystwyth",18392,52.416667,-4.066667 ],
    [ u"gb",u"Abingdon",37192,51.666667,-1.283333 ],
    [ u"gb",u"Aboyne",2236,57.083333,-2.833333 ],
    [ u"gb",u"Accrington",35318,53.766667,-2.35 ],
    [ u"gb",u"Airdrie",35440,55.85,-3.983333 ],
    [ u"gb",u"Airth",1414,56.066667,-3.766667 ],
    [ u"gb",u"Aldershot",61339,51.25,-.766667 ],
    [ u"gb",u"Alford",2237,57.216667,-2.7 ],
    [ u"gb",u"Alfreton",22550,53.1,-1.383333 ],
    [ u"gb",u"Allanton",1266,55.783333,-2.216667 ],
    [ u"gb",u"Alloa",18885,56.116667,-3.8 ],
    [ u"gb",u"Almondbank",617,56.4,-3.55 ],
    [ u"gb",u"Alness",4921,57.683333,-4.25 ],
    [ u"gb",u"Altrincham",41548,53.383333,-2.35 ],
    [ u"gb",u"Alva",5130,56.15,-3.8 ],
    [ u"gb",u"Alyth",2354,56.616667,-3.216667 ],
    [ u"gb",u"Amersham",21731,51.666667,-.616667 ],
    [ u"gb",u"Andover",39951,51.2,-1.483333 ],
    [ u"gb",u"Annan",8231,54.983333,-3.266667 ],
    [ u"gb",u"Annbank",822,55.466667,-4.516667 ],
    [ u"gb",u"Anstruther",3527,56.216667,-2.7 ],
    [ u"gb",u"Antrim",25525,54.666667,-6.25 ],
    [ u"gb",u"Arbroath",22291,56.55,-2.583333 ],
    [ u"gb",u"Ardersier",930,57.566667,-4.033333 ],
    [ u"gb",u"Ardrishaig",1261,56.016667,-5.45 ],
    [ u"gb",u"Ardrossan",10936,55.616667,-4.816667 ],
    [ u"gb",u"Armadale",9026,55.883333,-3.7 ],
    [ u"gb",u"Arnold",37873,53,-1.133333 ],
    [ u"gb",u"Ashford",62787,51.133333,.883333 ],
    [ u"gb",u"Ashington",27546,55.163889,-1.586389 ],
    [ u"gb",u"Ashton-under-Lyne",43675,53.5,-2.1 ],
    [ u"gb",u"Atherton",20149,53.516667,-2.5 ],
    [ u"gb",u"Auchinleck",3282,55.466667,-4.3 ],
    [ u"gb",u"Auchterarder",4220,56.3,-3.7 ],
    [ u"gb",u"Auchtermuchty",2023,56.283333,-3.216667 ],
    [ u"gb",u"Aviemore",2545,57.2,-3.833333 ],
    [ u"gb",u"Avoch",843,57.566667,-4.166667 ],
    [ u"gb",u"Avonbridge",560,55.933333,-3.75 ],
    [ u"gb",u"Aylesbury",74565,51.816667,-.8 ],
    [ u"gb",u"Ayr",45514,55.45,-4.616667 ],
    [ u"gb",u"Ayton",548,55.85,-2.133333 ],
    [ u"gb",u"Balfron",1605,56.066667,-4.333333 ],
    [ u"gb",u"Balintore",1045,57.75,-3.9 ],
    [ u"gb",u"Ballachulish",633,56.666667,-5.116667 ],
    [ u"gb",u"Ballater",1466,57.05,-3.05 ],
    [ u"gb",u"Ballingry",5758,56.15,-3.333333 ],
    [ u"gb",u"Balloch",1743,56,-4.583333 ],
    [ u"gb",u"Ballymena",30997,54.833333,-6.25 ],
    [ u"gb",u"Balmedie",1814,57.25,-2.05 ],
    [ u"gb",u"Balmullo",1085,56.366667,-2.916667 ],
    [ u"gb",u"Banbury",46075,52.05,-1.333333 ],
    [ u"gb",u"Banchory",5978,57.05,-2.516667 ],
    [ u"gb",u"Banff",3914,57.666667,-2.533333 ],
    [ u"gb",u"Bangor",62568,54.65,-5.7 ],
    [ u"gb",u"Bankfoot",1178,56.5,-3.5 ],
    [ u"gb",u"Barnsley",71448,53.55,-1.483333 ],
    [ u"gb",u"Barnstaple",32532,51.083333,-4.05 ],
    [ u"gb",u"Barry",51681,51.406667,-3.269444 ],
    [ u"gb",u"Basildon",101363,51.566667,.466667 ],
    [ u"gb",u"Basingstoke",96349,51.266667,-1.083333 ],
    [ u"gb",u"Bath",93238,51.379444,-2.365556 ],
    [ u"gb",u"Bathgate",15337,55.9,-3.633333 ],
    [ u"gb",u"Batley",50807,53.7,-1.616667 ],
    [ u"gb",u"Bearsden",27839,55.916667,-4.35 ],
    [ u"gb",u"Beauly",1169,57.466667,-4.466667 ],
    [ u"gb",u"Bebington",56803,53.35,-3.016667 ],
    [ u"gb",u"Bedford",86659,52.133333,-.45 ],
    [ u"gb",u"Bedworth",29981,52.466667,-1.466667 ],
    [ u"gb",u"Beith",6288,55.733333,-4.633333 ],
    [ u"gb",u"Belfast",585994,54.583333,-5.933333 ],
    [ u"gb",u"Bellshill",20201,55.816667,-4.016667 ],
    [ u"gb",u"Benfleet",48824,51.533333,.55 ],
    [ u"gb",u"Bentley",34821,53.533333,-1.15 ],
    [ u"gb",u"Beverley",31968,53.833333,-.416667 ],
    [ u"gb",u"Bexhill",40478,50.85,.483333 ],
    [ u"gb",u"Bicester",35902,51.9,-1.15 ],
    [ u"gb",u"Bideford",16624,51.016667,-4.216667 ],
    [ u"gb",u"Biggar",2120,55.616667,-3.516667 ],
    [ u"gb",u"Billericay",34467,51.616667,.416667 ],
    [ u"gb",u"Billingham",35709,54.6,-1.3 ],
    [ u"gb",u"Birkenhead",81806,53.4,-3.033333 ],
    [ u"gb",u"Birmingham",984336,52.466667,-1.916667 ],
    [ u"gb",u"Bishop Auckland",25665,54.65,-1.666667 ],
    [ u"gb",u"Bishopbriggs",22668,55.9,-4.233333 ],
    [ u"gb",u"Bishopton",5029,55.9,-4.5 ],
    [ u"gb",u"Blackburn",106154,53.75,-2.483333 ],
    [ u"gb",u"Blackburn",1136,57.2,-2.3 ],
    [ u"gb",u"Blackburn",4631,55.866667,-3.633333 ],
    [ u"gb",u"Blackford",541,56.25,-3.766667 ],
    [ u"gb",u"Blackpool",143101,53.816667,-3.05 ],
    [ u"gb",u"Blackwood",1901,55.666667,-3.916667 ],
    [ u"gb",u"Blairgowrie",8081,56.583333,-3.333333 ],
    [ u"gb",u"Blairhall",651,56.066667,-3.6 ],
    [ u"gb",u"Blantyre",16739,55.766667,-4.1 ],
    [ u"gb",u"Bletchley",50193,51.983333,-.733333 ],
    [ u"gb",u"Blyth",36356,55.120556,-1.514167 ],
    [ u"gb",u"Boat of Garten",517,57.333333,-3.733333 ],
    [ u"gb",u"Boddam",1327,57.466667,-1.783333 ],
    [ u"gb",u"Bodmin",13063,50.466389,-4.725556 ],
    [ u"gb",u"Bognor Regis",65391,50.783333,-.65 ],
    [ u"gb",u"Bolton",141331,53.583333,-2.433333 ],
    [ u"gb",u"Bonnybridge",7123,56,-3.883333 ],
    [ u"gb",u"Bootle",57791,53.466667,-3.016667 ],
    [ u"gb",u"Borehamwood",32176,51.65,-.266667 ],
    [ u"gb",u"Boston",35859,52.983333,-.016667 ],
    [ u"gb",u"Bourne",12060,52.766667,-.383333 ],
    [ u"gb",u"Bournemouth",175017,50.716667,-1.883333 ],
    [ u"gb",u"Bowmore",852,55.75,-6.283333 ],
    [ u"gb",u"Bracknell",76103,51.416667,-.75 ],
    [ u"gb",u"Braco",455,56.25,-3.883333 ],
    [ u"gb",u"Bradford",299310,53.783333,-1.75 ],
    [ u"gb",u"Brae",622,60.383333,-1.35 ],
    [ u"gb",u"Braintree",46765,51.883333,.566667 ],
    [ u"gb",u"Brechin",6977,56.733333,-2.65 ],
    [ u"gb",u"Brentwood",47606,51.616667,.316667 ],
    [ u"gb",u"Bridgend",41352,51.505833,-3.577222 ],
    [ u"gb",u"Bridge of Earn",2231,56.333333,-3.4 ],
    [ u"gb",u"Bridge of Weir",4418,55.85,-4.583333 ],
    [ u"gb",u"Bridgwater",38021,51.129722,-3.000556 ],
    [ u"gb",u"Bridlington",35057,54.095,-.208056 ],
    [ u"gb",u"Brigg",5988,53.55,-.483333 ],
    [ u"gb",u"Brighouse",32873,53.7,-1.783333 ],
    [ u"gb",u"Brighton",139001,50.833333,-.15 ],
    [ u"gb",u"Bristol",430714,51.45,-2.583333 ],
    [ u"gb",u"Broadford",522,57.233333,-5.916667 ],
    [ u"gb",u"Broadstairs",23283,51.366667,1.45 ],
    [ u"gb",u"Brodick",655,55.583333,-5.166667 ],
    [ u"gb",u"Brora",1095,58.016667,-3.866667 ],
    [ u"gb",u"Broxburn",13288,55.933333,-3.466667 ],
    [ u"gb",u"Brynmawr",14924,51.8,-3.183333 ],
    [ u"gb",u"Buchlyvie",448,56.116667,-4.3 ],
    [ u"gb",u"Buckhaven",16063,56.166667,-3.033333 ],
    [ u"gb",u"Buckie",7860,57.666667,-2.966667 ],
    [ u"gb",u"Burgess Hill",31183,50.966667,-.133333 ],
    [ u"gb",u"Burghead",1684,57.7,-3.483333 ],
    [ u"gb",u"Burnley",73480,53.8,-2.233333 ],
    [ u"gb",u"Burntwood",29766,52.683333,-1.9 ],
    [ u"gb",u"Bury",61045,53.6,-2.3 ],
    [ u"gb",u"Bury Saint Edmunds",38622,52.25,.716667 ],
    [ u"gb",u"Buxton",21300,53.25,-1.916667 ],
    [ u"gb",u"Caernarfon",9836,53.15,-4.266667 ],
    [ u"gb",u"Cairneyhill",2660,56.05,-3.533333 ],
    [ u"gb",u"Caldercruix",1980,55.883333,-3.883333 ],
    [ u"gb",u"Callander",2782,56.25,-4.233333 ],
    [ u"gb",u"Cambridge",128489,52.2,.116667 ],
    [ u"gb",u"Campbeltown",4939,55.433333,-5.633333 ],
    [ u"gb",u"Cannock",68067,52.683333,-2.016667 ],
    [ u"gb",u"Canterbury",46978,51.266667,1.083333 ],
    [ u"gb",u"Cardenden",4913,56.133333,-3.25 ],
    [ u"gb",u"Cardiff",302142,51.5,-3.2 ],
    [ u"gb",u"Cardross",1897,55.966667,-4.633333 ],
    [ u"gb",u"Carlisle",72633,54.883333,-2.933333 ],
    [ u"gb",u"Carlton",49687,52.95,-1.083333 ],
    [ u"gb",u"Carluke",13465,55.716667,-3.833333 ],
    [ u"gb",u"Carmarthen",15244,51.859167,-4.311667 ],
    [ u"gb",u"Carmunnock",1080,55.783333,-4.266667 ],
    [ u"gb",u"Carnoustie",10500,56.5,-2.716667 ],
    [ u"gb",u"Carnwath",1471,55.683333,-3.633333 ],
    [ u"gb",u"Carradale",497,55.583333,-5.483333 ],
    [ u"gb",u"Carrickfergus",33080,54.716667,-5.733333 ],
    [ u"gb",u"Carstairs",691,55.7,-3.7 ],
    [ u"gb",u"Castle Douglas",3631,54.933333,-3.95 ],
    [ u"gb",u"Castleford",37713,53.716667,-1.35 ],
    [ u"gb",u"Castletown",772,58.583333,-3.383333 ],
    [ u"gb",u"Catrine",1974,55.483333,-4.316667 ],
    [ u"gb",u"Ceres",1023,56.283333,-2.966667 ],
    [ u"gb",u"Chapelton",760,55.716667,-4.083333 ],
    [ u"gb",u"Chapeltown",22785,53.466667,-1.466667 ],
    [ u"gb",u"Chatham",75510,51.383333,.516667 ],
    [ u"gb",u"Chelmsford",102671,51.733333,.483333 ],
    [ u"gb",u"Cheltenham",103249,51.9,-2.083333 ],
    [ u"gb",u"Chesham",20649,51.7,-.6 ],
    [ u"gb",u"Cheshunt",57374,51.7,-.033333 ],
    [ u"gb",u"Chester",81313,53.2,-2.916667 ],
    [ u"gb",u"Chesterfield",70680,53.25,-1.416667 ],
    [ u"gb",u"Chester-le-Street",36917,54.85,-1.566667 ],
    [ u"gb",u"Chichester",28222,50.833333,-.783333 ],
    [ u"gb",u"Chippenham",36890,51.46,-2.124722 ],
    [ u"gb",u"Chipping Sodbury",36108,51.533333,-2.383333 ],
    [ u"gb",u"Chirnside",1176,55.8,-2.2 ],
    [ u"gb",u"Chorley",33888,53.65,-2.616667 ],
    [ u"gb",u"Christchurch",42397,50.733333,-1.766667 ],
    [ u"gb",u"Chryston",2495,55.9,-4.1 ],
    [ u"gb",u"Clackmannan",3432,56.1,-3.75 ],
    [ u"gb",u"Clacton-on-Sea",54674,51.783333,1.166667 ],
    [ u"gb",u"Cleethorpes",32017,53.55,-.033333 ],
    [ u"gb",u"Cleland",2733,55.8,-3.9 ],
    [ u"gb",u"Clevedon",22414,51.435278,-2.8525 ],
    [ u"gb",u"Clydebank",29867,55.9,-4.4 ],
    [ u"gb",u"Coalburn",1267,55.583333,-3.9 ],
    [ u"gb",u"Coalville",33288,52.716667,-1.366667 ],
    [ u"gb",u"Coatbridge",39752,55.866667,-4.033333 ],
    [ u"gb",u"Cockenzie",5962,55.95,-2.95 ],
    [ u"gb",u"Colchester",109415,51.883333,.9 ],
    [ u"gb",u"Coldingham",631,55.883333,-2.166667 ],
    [ u"gb",u"Coldstream",1823,55.65,-2.25 ],
    [ u"gb",u"Coleraine",24509,55.083333,-6.666667 ],
    [ u"gb",u"Colwyn Bay",30829,53.3,-3.75 ],
    [ u"gb",u"Comrie",2033,56.366667,-4 ],
    [ u"gb",u"Congleton",26030,53.15,-2.2 ],
    [ u"gb",u"Consett",21016,54.85,-1.833333 ],
    [ u"gb",u"Corby",50029,52.483333,-.666667 ],
    [ u"gb",u"Coupar Angus",2160,56.55,-3.266667 ],
    [ u"gb",u"Coventry",308314,52.416667,-1.55 ],
    [ u"gb",u"Cowdenbeath",11350,56.116667,-3.35 ],
    [ u"gb",u"Cowie",2506,56.066667,-3.866667 ],
    [ u"gb",u"Coylton",2607,55.433333,-4.483333 ],
    [ u"gb",u"Cramlington",29985,55.066667,-1.583333 ],
    [ u"gb",u"Crawley",107061,51.116667,-.183333 ],
    [ u"gb",u"Creetown",677,54.9,-4.383333 ],
    [ u"gb",u"Crewe",70456,53.1,-2.433333 ],
    [ u"gb",u"Crieff",6685,56.366667,-3.833333 ],
    [ u"gb",u"Crimond",758,57.6,-1.9 ],
    [ u"gb",u"Cromarty",712,57.666667,-4.033333 ],
    [ u"gb",u"Crosby",52140,53.477778,-3.033333 ],
    [ u"gb",u"Crossford",2448,56.05,-3.5 ],
    [ u"gb",u"Crossford",702,55.7,-3.866667 ],
    [ u"gb",u"Crossgates",2200,56.066667,-3.383333 ],
    [ u"gb",u"Crosshill",495,55.316667,-4.633333 ],
    [ u"gb",u"Crosshouse",2418,55.633333,-4.55 ],
    [ u"gb",u"Crowthorne",25522,51.366667,-.816667 ],
    [ u"gb",u"Croy",641,57.516667,-4.033333 ],
    [ u"gb",u"Cruden Bay",1620,57.416667,-1.833333 ],
    [ u"gb",u"Cullen",1283,57.683333,-2.816667 ],
    [ u"gb",u"Cumbernauld",49393,55.95,-3.983333 ],
    [ u"gb",u"Cuminestown",492,57.533333,-2.333333 ],
    [ u"gb",u"Cumnock",9189,55.45,-4.266667 ],
    [ u"gb",u"Cupar",8822,56.316667,-3.016667 ],
    [ u"gb",u"Cwmbran",48157,51.653056,-3.026667 ],
    [ u"gb",u"Dailly",866,55.266667,-4.716667 ],
    [ u"gb",u"Dalbeattie",4205,54.933333,-3.833333 ],
    [ u"gb",u"Dalkeith",11502,55.866667,-3.066667 ],
    [ u"gb",u"Dalry",5234,55.683333,-4.716667 ],
    [ u"gb",u"Dalrymple",1264,55.383333,-4.583333 ],
    [ u"gb",u"Darlington",87205,54.533333,-1.566667 ],
    [ u"gb",u"Dartford",56694,51.45,.216667 ],
    [ u"gb",u"Darvel",3225,55.583333,-4.283333 ],
    [ u"gb",u"Darwen",32566,53.7,-2.466667 ],
    [ u"gb",u"Dawlish",10676,50.583333,-3.466667 ],
    [ u"gb",u"Denholm",609,55.45,-2.683333 ],
    [ u"gb",u"Denton",27464,53.45,-2.116667 ],
    [ u"gb",u"Derby",235029,52.933333,-1.5 ],
    [ u"gb",u"Dewsbury",56641,53.7,-1.616667 ],
    [ u"gb",u"Dingwall",4687,57.6,-4.45 ],
    [ u"gb",u"Dirleton",496,56.033333,-2.766667 ],
    [ u"gb",u"Dollar",2845,56.15,-3.666667 ],
    [ u"gb",u"Doncaster",67671,53.533333,-1.116667 ],
    [ u"gb",u"Dorchester",16879,50.716667,-2.433333 ],
    [ u"gb",u"Dornoch",1261,57.866667,-4.033333 ],
    [ u"gb",u"Douglas",1685,55.55,-3.85 ],
    [ u"gb",u"Doune",1616,56.2,-4.083333 ],
    [ u"gb",u"Droitwich",23589,52.266667,-2.15 ],
    [ u"gb",u"Dronfield",20942,53.3,-1.466667 ],
    [ u"gb",u"Droylsden",23689,53.483333,-2.15 ],
    [ u"gb",u"Drumnadrochit",881,57.333333,-4.483333 ],
    [ u"gb",u"Drymen",623,56.066667,-4.433333 ],
    [ u"gb",u"Dudley",199060,52.5,-2.083333 ],
    [ u"gb",u"Dufftown",1384,57.433333,-3.133333 ],
    [ u"gb",u"Dumbarton",19878,55.95,-4.566667 ],
    [ u"gb",u"Dumfries",30656,55.066667,-3.55 ],
    [ u"gb",u"Dunbar",6414,56,-2.516667 ],
    [ u"gb",u"Dunblane",8056,56.2,-3.966667 ],
    [ u"gb",u"Dundee",151593,56.5,-2.966667 ],
    [ u"gb",u"Dundonald",2399,55.566667,-4.583333 ],
    [ u"gb",u"Dunfermline",38961,56.083333,-3.466667 ],
    [ u"gb",u"Dunlop",844,55.7,-4.533333 ],
    [ u"gb",u"Dunning",955,56.3,-3.583333 ],
    [ u"gb",u"Dunoon",7981,55.95,-4.95 ],
    [ u"gb",u"Duns",2630,55.766667,-2.35 ],
    [ u"gb",u"Dunstable",51974,51.883333,-.516667 ],
    [ u"gb",u"Durham",45696,54.766667,-1.566667 ],
    [ u"gb",u"Eaglesfield",601,55.05,-3.2 ],
    [ u"gb",u"Eaglesham",3077,55.733333,-4.266667 ],
    [ u"gb",u"Earlston",1728,55.633333,-2.666667 ],
    [ u"gb",u"Eastbourne",112906,50.8,.25 ],
    [ u"gb",u"East Grinstead",26523,51.116667,-.016667 ],
    [ u"gb",u"East Kilbride",74231,55.766667,-4.166667 ],
    [ u"gb",u"Eastleigh",54225,50.966667,-1.35 ],
    [ u"gb",u"East Linton",2008,55.983333,-2.65 ],
    [ u"gb",u"East Retford",21897,53.316667,-.933333 ],
    [ u"gb",u"East Wemyss",1856,56.15,-3.066667 ],
    [ u"gb",u"Eaton Socon",12712,52.216667,-.283333 ],
    [ u"gb",u"Ebbw Vale",18345,51.783333,-3.2 ],
    [ u"gb",u"Ecclefechan",705,55.05,-3.266667 ],
    [ u"gb",u"Eccles",37275,53.483333,-2.333333 ],
    [ u"gb",u"Edinburgh",435794,55.95,-3.2 ],
    [ u"gb",u"Edzell",790,56.8,-2.65 ],
    [ u"gb",u"Egham",29663,51.416667,-.566667 ],
    [ u"gb",u"Elgin",21236,57.65,-3.333333 ],
    [ u"gb",u"Elie",949,56.2,-2.816667 ],
    [ u"gb",u"Ellesmere Port",67768,53.283333,-2.9 ],
    [ u"gb",u"Ellon",8750,57.35,-2.083333 ],
    [ u"gb",u"Errol",1039,56.383333,-3.2 ],
    [ u"gb",u"Evanton",1138,57.666667,-4.333333 ],
    [ u"gb",u"Exeter",113119,50.7,-3.533333 ],
    [ u"gb",u"Exmouth",35154,50.583333,-3.4 ],
    [ u"gb",u"Eyemouth",3395,55.866667,-2.1 ],
    [ u"gb",u"Failsworth",20210,53.516667,-2.133333 ],
    [ u"gb",u"Fairlie",1568,55.75,-4.85 ],
    [ u"gb",u"Falkirk",32479,56,-3.75 ],
    [ u"gb",u"Falkland",1168,56.25,-3.2 ],
    [ u"gb",u"Falmouth",22222,50.148333,-5.076111 ],
    [ u"gb",u"Fareham",57390,50.85,-1.183333 ],
    [ u"gb",u"Farnborough",59902,51.266667,-.733333 ],
    [ u"gb",u"Farnham",36971,51.2,-.8 ],
    [ u"gb",u"Farnworth",25680,53.55,-2.4 ],
    [ u"gb",u"Fauldhouse",4610,55.816667,-3.716667 ],
    [ u"gb",u"Felling",34355,54.955,-1.56 ],
    [ u"gb",u"Fenwick",828,55.65,-4.433333 ],
    [ u"gb",u"Findhorn",1040,57.65,-3.6 ],
    [ u"gb",u"Findochty",1102,57.683333,-2.9 ],
    [ u"gb",u"Fleet",34218,51.283333,-.833333 ],
    [ u"gb",u"Fleetwood",27077,53.916667,-3 ],
    [ u"gb",u"Fochabers",1494,57.616667,-3.083333 ],
    [ u"gb",u"Folkestone",45992,51.083333,1.183333 ],
    [ u"gb",u"Forfar",13237,56.65,-2.883333 ],
    [ u"gb",u"Formby",24225,53.55,-3.05 ],
    [ u"gb",u"Forres",9134,57.6,-3.616667 ],
    [ u"gb",u"Fort Augustus",499,57.133333,-4.683333 ],
    [ u"gb",u"Forth",2087,55.75,-3.683333 ],
    [ u"gb",u"Fortrose",1206,57.583333,-4.133333 ],
    [ u"gb",u"Fort William",9652,56.816667,-5.116667 ],
    [ u"gb",u"Fraserburgh",12249,57.683333,-2.016667 ],
    [ u"gb",u"Freuchie",1120,56.233333,-3.15 ],
    [ u"gb",u"Friockheim",787,56.633333,-2.633333 ],
    [ u"gb",u"Frome",24948,51.229167,-2.318333 ],
    [ u"gb",u"Fyvie",499,57.416667,-2.383333 ],
    [ u"gb",u"Gainsborough",19871,53.383333,-.766667 ],
    [ u"gb",u"Galashiels",14351,55.6,-2.816667 ],
    [ u"gb",u"Galston",4902,55.583333,-4.383333 ],
    [ u"gb",u"Gardenstown",700,57.666667,-2.333333 ],
    [ u"gb",u"Garelochhead",1296,56.083333,-4.85 ],
    [ u"gb",u"Gargunnock",677,56.116667,-4.083333 ],
    [ u"gb",u"Gatehouse of Fleet",875,54.883333,-4.183333 ],
    [ u"gb",u"Gateshead",77649,54.945,-1.6175 ],
    [ u"gb",u"Giffnock",16038,55.8,-4.283333 ],
    [ u"gb",u"Gifford",674,55.9,-2.733333 ],
    [ u"gb",u"Gillingham",101187,51.4,.566667 ],
    [ u"gb",u"Girvan",6821,55.233333,-4.866667 ],
    [ u"gb",u"Glasgow",610271,55.833333,-4.25 ],
    [ u"gb",u"Glassford",606,55.7,-4.033333 ],
    [ u"gb",u"Glenboig",1468,55.883333,-4.033333 ],
    [ u"gb",u"Glenfarg",449,56.266667,-3.4 ],
    [ u"gb",u"Glenluce",618,54.866667,-4.833333 ],
    [ u"gb",u"Glenrothes",38734,56.2,-3.183333 ],
    [ u"gb",u"Glossop",33243,53.416667,-1.9 ],
    [ u"gb",u"Gloucester",128722,51.833333,-2.166667 ],
    [ u"gb",u"Godalming",22199,51.183333,-.6 ],
    [ u"gb",u"Golborne",24021,53.466667,-2.6 ],
    [ u"gb",u"Golspie",1381,57.966667,-3.966667 ],
    [ u"gb",u"Gorebridge",5874,55.833333,-3.05 ],
    [ u"gb",u"Gosforth",23975,55,-1.616667 ],
    [ u"gb",u"Gosport",70793,50.8,-1.133333 ],
    [ u"gb",u"Gourdon",569,56.816667,-2.283333 ],
    [ u"gb",u"Grantham",35720,52.9,-.633333 ],
    [ u"gb",u"Gravesend",54264,51.433333,.366667 ],
    [ u"gb",u"Grays",70935,51.483333,.333333 ],
    [ u"gb",u"Great Malvern",37663,52.116667,-2.316667 ],
    [ u"gb",u"Great Sankey",43793,53.383333,-2.616667 ],
    [ u"gb",u"Great Yarmouth",59601,52.633333,1.75 ],
    [ u"gb",u"Greenlaw",570,55.7,-2.466667 ],
    [ u"gb",u"Greenock",43496,55.933333,-4.75 ],
    [ u"gb",u"Gretna",2692,54.983333,-3.066667 ],
    [ u"gb",u"Grimsby",87819,53.533333,-.05 ],
    [ u"gb",u"Guildford",71873,51.216667,-.566667 ],
    [ u"gb",u"Gullane",2133,56.033333,-2.816667 ],
    [ u"gb",u"Haddington",8780,55.916667,-2.75 ],
    [ u"gb",u"Halesowen",55265,52.45,-2.05 ],
    [ u"gb",u"Halifax",82625,53.716667,-1.85 ],
    [ u"gb",u"Halkirk",897,58.5,-3.5 ],
    [ u"gb",u"Harlow",94365,51.783333,.166667 ],
    [ u"gb",u"Harpenden",28966,51.8,-.35 ],
    [ u"gb",u"Harrogate",87024,53.983333,-1.533333 ],
    [ u"gb",u"Harthill",3464,55.866667,-3.75 ],
    [ u"gb",u"Hartlepool",86713,54.686111,-1.2125 ],
    [ u"gb",u"Hastings",89100,50.85,.6 ],
    [ u"gb",u"Hatfield",14199,53.566667,-.983333 ],
    [ u"gb",u"Hatfield",33044,51.766667,-.166667 ],
    [ u"gb",u"Havant",45574,50.85,-.983333 ],
    [ u"gb",u"Haverfordwest",13469,51.801667,-4.970833 ],
    [ u"gb",u"Hawick",14053,55.433333,-2.783333 ],
    [ u"gb",u"Hawkhead",968,55.833333,-4.383333 ],
    [ u"gb",u"Haywards Heath",29660,50.983333,-.1 ],
    [ u"gb",u"Heanor",23122,53,-1.3 ],
    [ u"gb",u"Helensburgh",14108,56.016667,-4.733333 ],
    [ u"gb",u"Helmsdale",637,58.116667,-3.666667 ],
    [ u"gb",u"Hemel Hempstead",85630,51.75,-.466667 ],
    [ u"gb",u"Hereford",58281,52.05,-2.716667 ],
    [ u"gb",u"Herne Bay",36642,51.366667,1.133333 ],
    [ u"gb",u"Hertford",25848,51.8,-.066667 ],
    [ u"gb",u"Heswall",30065,53.316667,-3.1 ],
    [ u"gb",u"Heywood",28016,53.583333,-2.216667 ],
    [ u"gb",u"High Valleyfield",2837,56.05,-3.6 ],
    [ u"gb",u"High Wycombe",80357,51.633333,-.766667 ],
    [ u"gb",u"Hillside",999,56.733333,-2.483333 ],
    [ u"gb",u"Hinckley",45130,52.533333,-1.366667 ],
    [ u"gb",u"Hindley",24169,53.533333,-2.583333 ],
    [ u"gb",u"Hitchin",33830,51.95,-.266667 ],
    [ u"gb",u"Hoddesdon",35174,51.75,0 ],
    [ u"gb",u"Holbeach",7408,52.8,.016667 ],
    [ u"gb",u"Honiton",11463,50.8,-3.183333 ],
    [ u"gb",u"Hopeman",1675,57.7,-3.416667 ],
    [ u"gb",u"Horsham",50680,51.05,-.333333 ],
    [ u"gb",u"Houston",7031,55.866667,-4.55 ],
    [ u"gb",u"Hove",75174,50.833333,-.183333 ],
    [ u"gb",u"Huddersfield",149018,53.65,-1.783333 ],
    [ u"gb",u"Huntingdon",21059,52.333333,-.183333 ],
    [ u"gb",u"Huntly",4390,57.45,-2.783333 ],
    [ u"gb",u"Hyde",31926,53.45,-2.083333 ],
    [ u"gb",u"Ilfracombe",10486,51.216667,-4.116667 ],
    [ u"gb",u"Ilkeston",38587,52.966667,-1.3 ],
    [ u"gb",u"Inchture",715,56.433333,-3.166667 ],
    [ u"gb",u"Innellan",1132,55.883333,-4.966667 ],
    [ u"gb",u"Innerleithen",2591,55.616667,-3.066667 ],
    [ u"gb",u"Insch",1504,57.333333,-2.616667 ],
    [ u"gb",u"Inveraray",568,56.233333,-5.066667 ],
    [ u"gb",u"Inverbervie",2162,56.85,-2.266667 ],
    [ u"gb",u"Invergordon",3949,57.683333,-4.183333 ],
    [ u"gb",u"Inverkeithing",5163,56.033333,-3.383333 ],
    [ u"gb",u"Inverkip",1733,55.9,-4.866667 ],
    [ u"gb",u"Inverness",40755,57.466667,-4.233333 ],
    [ u"gb",u"Inverurie",11324,57.266667,-2.366667 ],
    [ u"gb",u"Ipswich",143768,52.083333,1.166667 ],
    [ u"gb",u"Irvine",32749,55.6,-4.666667 ],
    [ u"gb",u"Ivybridge",13277,50.383333,-3.916667 ],
    [ u"gb",u"Jarrow",27264,54.980556,-1.450833 ],
    [ u"gb",u"Jedburgh",4045,55.466667,-2.566667 ],
    [ u"gb",u"Johnshaven",641,56.783333,-2.333333 ],
    [ u"gb",u"Keighley",50171,53.883333,-1.916667 ],
    [ u"gb",u"Keith",4396,57.533333,-2.933333 ],
    [ u"gb",u"Kelso",5154,55.583333,-2.433333 ],
    [ u"gb",u"Kelty",5644,56.133333,-3.383333 ],
    [ u"gb",u"Kemnay",3889,57.233333,-2.45 ],
    [ u"gb",u"Kendal",29468,54.316667,-2.75 ],
    [ u"gb",u"Kenilworth",22799,52.35,-1.583333 ],
    [ u"gb",u"Kennoway",4596,56.2,-3.05 ],
    [ u"gb",u"Kettering",53329,52.4,-.716667 ],
    [ u"gb",u"Kidderminster",56657,52.383333,-2.25 ],
    [ u"gb",u"Kidsgrove",29480,53.083333,-2.233333 ],
    [ u"gb",u"Kilbirnie",6972,55.75,-4.7 ],
    [ u"gb",u"Kilcreggan",1343,55.983333,-4.833333 ],
    [ u"gb",u"Killin",666,56.466667,-4.316667 ],
    [ u"gb",u"Kilmacolm",3887,55.883333,-4.616667 ],
    [ u"gb",u"Kilmarnock",42905,55.633333,-4.533333 ],
    [ u"gb",u"Kilmaurs",2528,55.633333,-4.533333 ],
    [ u"gb",u"Kilsyth",9662,55.966667,-4.05 ],
    [ u"gb",u"Kilwinning",16000,55.65,-4.716667 ],
    [ u"gb",u"Kincardine",3014,56.066667,-3.716667 ],
    [ u"gb",u"Kinghorn",2776,56.066667,-3.166667 ],
    [ u"gb",u"Kinglassie",1274,56.166667,-3.233333 ],
    [ u"gb",u"Kingseat",500,56.683333,-3.4 ],
    [ u"gb",u"Kingskettle",993,56.25,-3.116667 ],
    [ u"gb",u"Kingsteignton",11360,50.55,-3.583333 ],
    [ u"gb",u"Kingston upon Hull",302297,53.716667,-.333333 ],
    [ u"gb",u"Kingswood",64793,51.452778,-2.508333 ],
    [ u"gb",u"Kingussie",1442,57.083333,-4.05 ],
    [ u"gb",u"Kinlochleven",831,56.7,-4.966667 ],
    [ u"gb",u"Kinloss",2011,57.616667,-3.566667 ],
    [ u"gb",u"Kinross",4691,56.2,-3.416667 ],
    [ u"gb",u"Kintore",1688,57.216667,-2.35 ],
    [ u"gb",u"Kippen",990,56.116667,-4.166667 ],
    [ u"gb",u"Kirkby in Ashfield",27539,53.083333,-1.266667 ],
    [ u"gb",u"Kirkby",39208,53.483333,-2.9 ],
    [ u"gb",u"Kirkconnel",1993,55.383333,-4 ],
    [ u"gb",u"Kirkcudbright",3367,54.833333,-4.033333 ],
    [ u"gb",u"Kirkintilloch",19489,55.916667,-4.166667 ],
    [ u"gb",u"Kirkliston",3139,55.95,-3.4 ],
    [ u"gb",u"Kirknewton",1755,55.883333,-3.416667 ],
    [ u"gb",u"Kirkton of Largo",496,56.216667,-2.916667 ],
    [ u"gb",u"Kirkwall",6196,58.966667,-2.95 ],
    [ u"gb",u"Kirriemuir",6108,56.666667,-3 ],
    [ u"gb",u"Kyle of Lochalsh",734,57.266667,-5.716667 ],
    [ u"gb",u"Ladybank",1519,56.266667,-3.133333 ],
    [ u"gb",u"Lamlash",1046,55.533333,-5.15 ],
    [ u"gb",u"Lanark",8152,55.65,-3.783333 ],
    [ u"gb",u"Lancaster",47162,54.066667,-2.833333 ],
    [ u"gb",u"Langbank",884,55.916667,-4.583333 ],
    [ u"gb",u"Langholm",2213,55.15,-3 ],
    [ u"gb",u"Largs",11126,55.783333,-4.85 ],
    [ u"gb",u"Larkhall",15410,55.733333,-3.966667 ],
    [ u"gb",u"Lauder",1078,55.7,-2.75 ],
    [ u"gb",u"Laurencekirk",1916,56.816667,-2.45 ],
    [ u"gb",u"Law",2994,55.75,-3.883333 ],
    [ u"gb",u"Leatherhead",43544,51.283333,-.316667 ],
    [ u"gb",u"Leeds",455124,53.8,-1.583333 ],
    [ u"gb",u"Leicester",339240,52.633333,-1.133333 ],
    [ u"gb",u"Leicester",339240,52.664913,-1.034894 ],
    [ u"gb",u"Leigh",43627,53.483333,-2.516667 ],
    [ u"gb",u"Leighton Buzzard",33467,51.916667,-.65 ],
    [ u"gb",u"Lennoxtown",3795,55.966667,-4.2 ],
    [ u"gb",u"Lerwick",6594,60.15,-1.15 ],
    [ u"gb",u"Lesmahagow",3823,55.616667,-3.9 ],
    [ u"gb",u"Letchworth",33955,51.966667,-.216667 ],
    [ u"gb",u"Letham",1591,56.616667,-2.766667 ],
    [ u"gb",u"Leuchars",2341,56.383333,-2.883333 ],
    [ u"gb",u"Lewes",16479,50.866667,-.016667 ],
    [ u"gb",u"Leyland",37615,53.683333,-2.7 ],
    [ u"gb",u"Lhanbryde",1845,57.616667,-3.216667 ],
    [ u"gb",u"Lichfield",28973,52.683333,-1.816667 ],
    [ u"gb",u"Limekilns",1329,56.033333,-3.466667 ],
    [ u"gb",u"Lincoln",89228,53.233333,-.533333 ],
    [ u"gb",u"Linlithgow",13863,55.889082,-3.569419 ],
    [ u"gb",u"Lisburn",45314,54.516667,-6.066667 ],
    [ u"gb",u"Litherland",22971,53.466667,-3 ],
    [ u"gb",u"Littlehampton",58714,50.8,-.533333 ],
    [ u"gb",u"Liverpool",468946,53.416667,-3 ],
    [ u"gb",u"Livingston",53798,55.883333,-3.533333 ],
    [ u"gb",u"Llandrindod Wells",5350,52.233333,-3.383333 ],
    [ u"gb",u"Llanelli",47206,51.676111,-4.156667 ],
    [ u"gb",u"Llangefni",4361,53.266667,-4.333333 ],
    [ u"gb",u"Loanhead",6358,55.866667,-3.15 ],
    [ u"gb",u"Loans",825,55.55,-4.633333 ],
    [ u"gb",u"Locharbriggs",6333,55.1,-3.583333 ],
    [ u"gb",u"Lochgilphead",2272,56.033333,-5.416667 ],
    [ u"gb",u"Lochmaben",1910,55.116667,-3.45 ],
    [ u"gb",u"Lochwinnoch",2684,55.783333,-4.633333 ],
    [ u"gb",u"Lockerbie",3986,55.116667,-3.35 ],
    [ u"gb",u"Londonderry",86312,55,-7.25 ],
    [ u"gb",u"London",7421228,51.514125,-.093689 ],
    [ u"gb",u"Long Eaton",47898,52.9,-1.266667 ],
    [ u"gb",u"Longforgan",678,56.45,-3.116667 ],
    [ u"gb",u"Longniddry",2482,55.966667,-2.883333 ],
    [ u"gb",u"Longside",722,57.516667,-1.933333 ],
    [ u"gb",u"Lossiemouth",6841,57.7,-3.283333 ],
    [ u"gb",u"Loughborough",59317,52.766667,-1.2 ],
    [ u"gb",u"Loughton",42229,51.633333,.066667 ],
    [ u"gb",u"Louth",16635,53.366667,-.016667 ],
    [ u"gb",u"Lowestoft",71479,52.483333,1.75 ],
    [ u"gb",u"Luncarty",1236,56.45,-3.466667 ],
    [ u"gb",u"Lundin Links",2124,56.2,-2.95 ],
    [ u"gb",u"Lurgan",23602,54.466667,-6.333333 ],
    [ u"gb",u"Luton",193670,51.883333,-.416667 ],
    [ u"gb",u"Macclesfield",51739,53.25,-2.116667 ],
    [ u"gb",u"Macduff",3747,57.666667,-2.483333 ],
    [ u"gb",u"Macmerry",1082,55.933333,-2.9 ],
    [ u"gb",u"Maesteg",17830,51.605,-3.650833 ],
    [ u"gb",u"Maidenhead",59463,51.516667,-.7 ],
    [ u"gb",u"Maidens",530,55.333333,-4.816667 ],
    [ u"gb",u"Maidstone",90894,51.266667,.516667 ],
    [ u"gb",u"Mallaig",742,57,-5.833333 ],
    [ u"gb",u"Manchester",395516,53.5,-2.216667 ],
    [ u"gb",u"Mangotsfield",36427,51.493056,-2.508611 ],
    [ u"gb",u"Mansfield",70447,53.133333,-1.2 ],
    [ u"gb",u"Margate",60134,51.383333,1.416667 ],
    [ u"gb",u"Matlock",11516,53.133333,-1.533333 ],
    [ u"gb",u"Mauchline",4137,55.516667,-4.366667 ],
    [ u"gb",u"Maud",673,57.516667,-2.1 ],
    [ u"gb",u"Maybole",4447,55.333333,-4.7 ],
    [ u"gb",u"Melrose",1640,55.583333,-2.716667 ],
    [ u"gb",u"Melton Mowbray",26405,52.766667,-.883333 ],
    [ u"gb",u"Merthyr Tydfil",30821,51.75,-3.383333 ],
    [ u"gb",u"Methven",1161,56.416667,-3.566667 ],
    [ u"gb",u"Middlesbrough",142708,54.572778,-1.162778 ],
    [ u"gb",u"Middleton",45589,53.55,-2.2 ],
    [ u"gb",u"Millport",1260,55.75,-4.95 ],
    [ u"gb",u"Milnathort",1885,56.216667,-3.416667 ],
    [ u"gb",u"Milton Keynes",31967,52.033333,-.7 ],
    [ u"gb",u"Mintlaw",2673,57.516667,-2 ],
    [ u"gb",u"Moffat",2077,55.316667,-3.45 ],
    [ u"gb",u"Mold",9995,53.166667,-3.133333 ],
    [ u"gb",u"Monkton",668,55.5,-4.6 ],
    [ u"gb",u"Montrose",10620,56.7,-2.45 ],
    [ u"gb",u"Morecambe",51645,54.066667,-2.85 ],
    [ u"gb",u"Morley",57386,53.733333,-1.583333 ],
    [ u"gb",u"Motherwell",29908,55.783333,-4 ],
    [ u"gb",u"Muirkirk",1539,55.516667,-4.05 ],
    [ u"gb",u"Muir of Ord",1807,57.516667,-4.45 ],
    [ u"gb",u"Musselburgh",22656,55.933333,-3.05 ],
    [ u"gb",u"Muthill",668,56.316667,-3.833333 ],
    [ u"gb",u"Nailsea",16537,51.430278,-2.7625 ],
    [ u"gb",u"Nairn",8551,57.5,-3.833333 ],
    [ u"gb",u"Neath",46126,51.656111,-3.802222 ],
    [ u"gb",u"Neilston",5091,55.783333,-4.416667 ],
    [ u"gb",u"Nelson",29317,53.833333,-2.2 ],
    [ u"gb",u"Netherburn",710,55.7,-3.916667 ],
    [ u"gb",u"Newburgh",1377,57.3,-2 ],
    [ u"gb",u"Newburgh",1909,56.333333,-3.25 ],
    [ u"gb",u"Newburn",41347,54.966667,-1.733333 ],
    [ u"gb",u"Newbury",33065,51.4,-1.316667 ],
    [ u"gb",u"Newcastleton",751,55.166667,-2.816667 ],
    [ u"gb",u"Newcastle upon Tyne",192382,54.988056,-1.619444 ],
    [ u"gb",u"New Cumnock",2884,55.4,-4.183333 ],
    [ u"gb",u"New Deer",559,57.5,-2.2 ],
    [ u"gb",u"New Pitsligo",907,57.583333,-2.183333 ],
    [ u"gb",u"Newport",24200,50.7,-1.3 ],
    [ u"gb",u"Newport",117327,51.583333,-2.983333 ],
    [ u"gb",u"Newry",26271,54.183333,-6.333333 ],
    [ u"gb",u"New Scone",4355,56.416667,-3.4 ],
    [ u"gb",u"Newton Abbot",25789,50.533333,-3.6 ],
    [ u"gb",u"Newton Aycliffe",26269,54.616667,-1.566667 ],
    [ u"gb",u"Newtonhill",3284,57.033333,-2.15 ],
    [ u"gb",u"Newtonmore",988,57.066667,-4.133333 ],
    [ u"gb",u"Newton Stewart",3548,54.966667,-4.483333 ],
    [ u"gb",u"Newtownards",28878,54.583333,-5.666667 ],
    [ u"gb",u"Newtown Saint Boswells",1225,55.583333,-2.683333 ],
    [ u"gb",u"Newtyle",731,56.55,-3.133333 ],
    [ u"gb",u"Northallerton",16480,54.333333,-1.433333 ],
    [ u"gb",u"Northam",7668,51.033333,-4.216667 ],
    [ u"gb",u"Northampton",197323,52.25,-.883333 ],
    [ u"gb",u"North Berwick",6439,56.066667,-2.716667 ],
    [ u"gb",u"North Kessock",881,57.5,-4.25 ],
    [ u"gb",u"North Shields",39747,55.004722,-1.472778 ],
    [ u"gb",u"Northwich",42113,53.266667,-2.5 ],
    [ u"gb",u"Norwich",177636,52.633333,1.3 ],
    [ u"gb",u"Nottingham",246655,52.966667,-1.166667 ],
    [ u"gb",u"Nuneaton",73555,52.516667,-1.466667 ],
    [ u"gb",u"Oakham",10150,52.666667,-.733333 ],
    [ u"gb",u"Oakley",4067,56.066667,-3.55 ],
    [ u"gb",u"Oban",8082,56.416667,-5.466667 ],
    [ u"gb",u"Ochiltree",665,55.45,-4.366667 ],
    [ u"gb",u"Oldham",104783,53.55,-2.116667 ],
    [ u"gb",u"Oldmeldrum",2023,57.316667,-2.316667 ],
    [ u"gb",u"Omagh",18463,54.583333,-7.25 ],
    [ u"gb",u"Ormiston",2062,55.9,-2.933333 ],
    [ u"gb",u"Ormskirk",23792,53.566667,-2.9 ],
    [ u"gb",u"Ossett",21616,53.666667,-1.566667 ],
    [ u"gb",u"Overtown",2519,55.75,-3.916667 ],
    [ u"gb",u"Oxford",154567,51.75,-1.25 ],
    [ u"gb",u"Paignton",49886,50.433333,-3.566667 ],
    [ u"gb",u"Paisley",73074,55.833333,-4.433333 ],
    [ u"gb",u"Patna",2088,55.35,-4.5 ],
    [ u"gb",u"Peebles",8404,55.633333,-3.183333 ],
    [ u"gb",u"Penarth",23438,51.434722,-3.18 ],
    [ u"gb",u"Pencaitland",1671,55.9,-2.883333 ],
    [ u"gb",u"Penicuik",14314,55.816667,-3.233333 ],
    [ u"gb",u"Penzance",20812,50.113611,-5.547778 ],
    [ u"gb",u"Perth",43634,56.4,-3.433333 ],
    [ u"gb",u"Peterborough",140142,52.583333,-.25 ],
    [ u"gb",u"Peterhead",17627,57.5,-1.783333 ],
    [ u"gb",u"Peterlee",29979,54.762222,-1.3475 ],
    [ u"gb",u"Pitlochry",2551,56.7,-3.716667 ],
    [ u"gb",u"Pitmedden",1246,57.333333,-2.183333 ],
    [ u"gb",u"Pittenweem",1807,56.2,-2.733333 ],
    [ u"gb",u"Plean",1752,56.05,-3.866667 ],
    [ u"gb",u"Plymouth",247298,50.396389,-4.138611 ],
    [ u"gb",u"Pontefract",28620,53.683333,-1.3 ],
    [ u"gb",u"Pontypool",35687,51.701111,-3.044444 ],
    [ u"gb",u"Pontypridd",30420,51.601389,-3.344722 ],
    [ u"gb",u"Poole",150092,50.716667,-2 ],
    [ u"gb",u"Portadown",21617,54.433333,-6.45 ],
    [ u"gb",u"Port Bannatyne",1331,55.85,-5.066667 ],
    [ u"gb",u"Port Ellen",779,55.633333,-6.183333 ],
    [ u"gb",u"Portgordon",763,57.65,-3.016667 ],
    [ u"gb",u"Portknockie",1179,57.683333,-2.85 ],
    [ u"gb",u"Portlethen",6841,57.05,-2.1 ],
    [ u"gb",u"Portpatrick",599,54.85,-5.116667 ],
    [ u"gb",u"Portree",1886,57.4,-6.2 ],
    [ u"gb",u"Portsmouth",194151,50.7967,-1.083333 ],
    [ u"gb",u"Portsoy",1688,57.683333,-2.683333 ],
    [ u"gb",u"Port Talbot",35180,51.6,-3.783333 ],
    [ u"gb",u"Port William",466,54.75,-4.6 ],
    [ u"gb",u"Potters Bar",22192,51.683333,-.166667 ],
    [ u"gb",u"Prescot",40889,53.416667,-2.8 ],
    [ u"gb",u"Prestonpans",7145,55.933333,-2.966667 ],
    [ u"gb",u"Preston",190688,53.766667,-2.716667 ],
    [ u"gb",u"Prestwich",32125,53.533333,-2.283333 ],
    [ u"gb",u"Pudsey",33109,53.783333,-1.666667 ],
    [ u"gb",u"Quarter",959,55.733333,-4.033333 ],
    [ u"gb",u"Queensferry",9477,55.983333,-3.4 ],
    [ u"gb",u"Radcliffe",35638,53.55,-2.333333 ],
    [ u"gb",u"Ramsgate",38624,51.333333,1.433333 ],
    [ u"gb",u"Ratho",1515,55.916667,-3.366667 ],
    [ u"gb",u"Rawtenstall",22115,53.7,-2.283333 ],
    [ u"gb",u"Reading",244071,51.433333,-1 ],
    [ u"gb",u"Redcar",37203,54.6075,-1.059444 ],
    [ u"gb",u"Redditch",77129,52.3,-1.933333 ],
    [ u"gb",u"Reigate",52123,51.233333,-.216667 ],
    [ u"gb",u"Rhondda",59450,51.65,-3.483333 ],
    [ u"gb",u"Rhyl",25874,53.316667,-3.5 ],
    [ u"gb",u"Rhymney",7089,51.766667,-3.283333 ],
    [ u"gb",u"Rochdale",97550,53.616667,-2.15 ],
    [ u"gb",u"Rochester",28671,51.383333,.516667 ],
    [ u"gb",u"Rosehearty",1320,57.683333,-2.116667 ],
    [ u"gb",u"Rosneath",901,56.016667,-4.816667 ],
    [ u"gb",u"Rotherham",117619,53.433333,-1.35 ],
    [ u"gb",u"Rothesay",4912,55.833333,-5.066667 ],
    [ u"gb",u"Rothes",1132,57.516667,-3.216667 ],
    [ u"gb",u"Rottingdean",21756,50.8,-.05 ],
    [ u"gb",u"Royal Leamington Spa",64641,52.3,-1.533333 ],
    [ u"gb",u"Royal Tunbridge Wells",61075,51.133333,.283333 ],
    [ u"gb",u"Royton",22848,53.566667,-2.116667 ],
    [ u"gb",u"Rugby",63323,52.366667,-1.25 ],
    [ u"gb",u"Rugeley",22937,52.766667,-1.933333 ],
    [ u"gb",u"Runcorn",59679,53.333333,-2.75 ],
    [ u"gb",u"Rushden",26307,52.283333,-.583333 ],
    [ u"gb",u"Ruthin",5344,53.116667,-3.3 ],
    [ u"gb",u"Ryde",24107,50.716667,-1.166667 ],
    [ u"gb",u"Saint Albans",84561,51.75,-.333333 ],
    [ u"gb",u"Saint Andrews",15435,56.333333,-2.783333 ],
    [ u"gb",u"Saint Austell",23432,50.338333,-4.765833 ],
    [ u"gb",u"Saint Boswells",1062,55.566667,-2.65 ],
    [ u"gb",u"Saint Combs",719,57.65,-1.9 ],
    [ u"gb",u"Saint Cyrus",914,56.766667,-2.4 ],
    [ u"gb",u"Saint Helens",102555,53.45,-2.733333 ],
    [ u"gb",u"Saint Monans",1447,56.2,-2.766667 ],
    [ u"gb",u"Sale",55689,53.416667,-2.3 ],
    [ u"gb",u"Salford",70905,53.483333,-2.266667 ],
    [ u"gb",u"Saline",1161,56.1,-3.566667 ],
    [ u"gb",u"Salisbury",45600,51.066667,-1.783333 ],
    [ u"gb",u"Sandhaven",690,57.683333,-2.066667 ],
    [ u"gb",u"Sandwick",1217,60,-1.25 ],
    [ u"gb",u"Sanquhar",1987,55.35,-3.916667 ],
    [ u"gb",u"Scalloway",809,60.133333,-1.3 ],
    [ u"gb",u"Scarborough",38909,54.287222,-.414167 ],
    [ u"gb",u"Scunthorpe",72515,53.583333,-.65 ],
    [ u"gb",u"Seafield",1386,55.966667,-3.15 ],
    [ u"gb",u"Seaham",21170,54.836667,-1.338056 ],
    [ u"gb",u"Selkirk",5629,55.533333,-2.85 ],
    [ u"gb",u"Sevenoaks",27871,51.266667,.2 ],
    [ u"gb",u"Sheffield",447048,53.366667,-1.5 ],
    [ u"gb",u"Shipley",28544,53.833333,-1.766667 ],
    [ u"gb",u"Shotts",7981,55.833333,-3.85 ],
    [ u"gb",u"Shrewsbury",69520,52.716667,-2.733333 ],
    [ u"gb",u"Sidmouth",11853,50.683333,-3.25 ],
    [ u"gb",u"Sittingbourne",41148,51.333333,.75 ],
    [ u"gb",u"Skegness",17072,53.133333,.35 ],
    [ u"gb",u"Skelmersdale",38944,53.533333,-2.8 ],
    [ u"gb",u"Skelmorlie",1859,55.866667,-4.9 ],
    [ u"gb",u"Slamannan",1195,55.933333,-3.833333 ],
    [ u"gb",u"Sleaford",15558,52.983333,-.4 ],
    [ u"gb",u"Slough",134072,51.5,-.583333 ],
    [ u"gb",u"Solihull",96268,52.416667,-1.783333 ],
    [ u"gb",u"Southampton",246201,50.9,-1.4 ],
    [ u"gb",u"Southend-on-Sea",163378,51.533333,.7 ],
    [ u"gb",u"Southport",93044,53.666667,-3 ],
    [ u"gb",u"South Shields",83656,54.987778,-1.421389 ],
    [ u"gb",u"Spalding",22357,52.783333,-.166667 ],
    [ u"gb",u"Springside",1114,55.616667,-4.6 ],
    [ u"gb",u"Stafford",65290,52.8,-2.1 ],
    [ u"gb",u"Stafford",65290,52.833333,-2 ],
    [ u"gb",u"Staines",51040,51.433333,-.516667 ],
    [ u"gb",u"Stalybridge",22748,53.483333,-2.066667 ],
    [ u"gb",u"Stamford",20526,52.65,-.483333 ],
    [ u"gb",u"Stanley",1491,56.466667,-3.45 ],
    [ u"gb",u"Staveley",25719,53.266667,-1.35 ],
    [ u"gb",u"Stevenage",84652,51.916667,-.216667 ],
    [ u"gb",u"Stewarton",6615,55.666667,-4.5 ],
    [ u"gb",u"Stirling",33013,56.116667,-3.95 ],
    [ u"gb",u"Stockport",139053,53.4,-2.15 ],
    [ u"gb",u"Stockton-on-Tees",79957,54.583333,-1.416667 ],
    [ u"gb",u"Stoke-on-Trent",260420,53,-2.183333 ],
    [ u"gb",u"Stonehaven",9592,56.95,-2.2 ],
    [ u"gb",u"Stonehouse",4950,55.666667,-3.983333 ],
    [ u"gb",u"Stornoway",5423,58.216667,-6.366667 ],
    [ u"gb",u"Stourbridge",56284,52.466667,-2.133333 ],
    [ u"gb",u"Stow",551,55.7,-2.85 ],
    [ u"gb",u"Stranraer",10582,54.9,-5.033333 ],
    [ u"gb",u"Stratford-upon-Avon",22576,52.183333,-1.7 ],
    [ u"gb",u"Strathaven",8190,55.666667,-4.066667 ],
    [ u"gb",u"Strathblane",1803,55.966667,-4.3 ],
    [ u"gb",u"Strathmiglo",926,56.266667,-3.266667 ],
    [ u"gb",u"Strathpeffer",893,57.583333,-4.55 ],
    [ u"gb",u"Stretford",41954,53.45,-2.316667 ],
    [ u"gb",u"Strichen",857,57.566667,-2.083333 ],
    [ u"gb",u"Stromness",1564,58.95,-3.3 ],
    [ u"gb",u"Strone",502,55.983333,-4.9 ],
    [ u"gb",u"Strood",33381,51.383333,.5 ],
    [ u"gb",u"Stroud",30600,51.75,-2.2 ],
    [ u"gb",u"Stuartfield",649,57.5,-2.05 ],
    [ u"gb",u"Sunbury",27784,51.4,-.4 ],
    [ u"gb",u"Sunderland",177965,54.911944,-1.383333 ],
    [ u"gb",u"Sutton Coldfield",107030,52.566667,-1.816667 ],
    [ u"gb",u"Sutton in Ashfield",43912,53.116667,-1.266667 ],
    [ u"gb",u"Swadlincote",40961,52.766667,-1.55 ],
    [ u"gb",u"Swansea",170885,51.633333,-3.966667 ],
    [ u"gb",u"Swindon",162439,51.516667,-1.783333 ],
    [ u"gb",u"Symington",997,55.533333,-4.566667 ],
    [ u"gb",u"Tain",3409,57.8,-4.066667 ],
    [ u"gb",u"Tamworth",74130,52.616667,-1.683333 ],
    [ u"gb",u"Tarbert",1364,55.866667,-5.433333 ],
    [ u"gb",u"Tarbolton",1649,55.5,-4.483333 ],
    [ u"gb",u"Tarland",550,57.133333,-2.866667 ],
    [ u"gb",u"Tarves",978,57.366667,-2.216667 ],
    [ u"gb",u"Taunton",60433,51.021111,-3.104722 ],
    [ u"gb",u"Tayport",4093,56.45,-2.883333 ],
    [ u"gb",u"Teignmouth",15498,50.55,-3.466667 ],
    [ u"gb",u"Telford",43244,52.633333,-2.5 ],
    [ u"gb",u"Thatcham",24275,51.4,-1.266667 ],
    [ u"gb",u"Thornaby",22356,54.533333,-1.3 ],
    [ u"gb",u"Thornhill",1504,55.233333,-3.766667 ],
    [ u"gb",u"Thornton",1743,56.166667,-3.15 ],
    [ u"gb",u"Thurso",7492,58.6,-3.5 ],
    [ u"gb",u"Tighnabruaich",603,55.9,-5.216667 ],
    [ u"gb",u"Tillicoultry",5404,56.15,-3.75 ],
    [ u"gb",u"Tiverton",16799,50.9,-3.483333 ],
    [ u"gb",u"Tobermory",993,56.633333,-6.083333 ],
    [ u"gb",u"Tonbridge",36894,51.183333,.283333 ],
    [ u"gb",u"Torphichen",605,55.933333,-3.65 ],
    [ u"gb",u"Torphins",1245,57.1,-2.616667 ],
    [ u"gb",u"Torquay",65389,50.45,-3.5 ],
    [ u"gb",u"Totton",29261,50.916667,-1.483333 ],
    [ u"gb",u"Townhill",1190,56.083333,-3.433333 ],
    [ u"gb",u"Tranent",9042,55.933333,-2.95 ],
    [ u"gb",u"Troon",14900,55.533333,-4.666667 ],
    [ u"gb",u"Trowbridge",36922,51.318889,-2.208611 ],
    [ u"gb",u"Truro",22044,50.261667,-5.043333 ],
    [ u"gb",u"Turriff",4711,57.533333,-2.45 ],
    [ u"gb",u"Tyldesley",35932,53.516667,-2.466667 ],
    [ u"gb",u"Ullapool",1327,57.9,-5.166667 ],
    [ u"gb",u"Uplawmoor",581,55.75,-4.483333 ],
    [ u"gb",u"Urmston",41198,53.45,-2.35 ],
    [ u"gb",u"Wakefield",78978,53.7,-1.483333 ],
    [ u"gb",u"Walkden",35938,53.516667,-2.4 ],
    [ u"gb",u"Walkerburn",638,55.633333,-3.016667 ],
    [ u"gb",u"Wallasey",58794,53.433333,-3.066667 ],
    [ u"gb",u"Wallsend",42739,54.991389,-1.559722 ],
    [ u"gb",u"Walsall",172142,52.6,-2 ],
    [ u"gb",u"Warrington",81238,53.383333,-2.6 ],
    [ u"gb",u"Warwick",24040,52.283333,-1.583333 ],
    [ u"gb",u"Washington",53527,54.9,-1.516667 ],
    [ u"gb",u"Waterfoot",1286,55.05,-6.066667 ],
    [ u"gb",u"Waterlooville",64350,50.866667,-1.016667 ],
    [ u"gb",u"Watford",125708,51.666667,-.4 ],
    [ u"gb",u"Wellingborough",49783,52.3,-.7 ],
    [ u"gb",u"Welwyn Garden City",44725,51.8,-.2 ],
    [ u"gb",u"West Bridgeford",48314,52.916667,-1.116667 ],
    [ u"gb",u"West Bromwich",135618,52.516667,-2 ],
    [ u"gb",u"West Calder",2769,55.833333,-3.566667 ],
    [ u"gb",u"Westhoughton",22994,53.55,-2.516667 ],
    [ u"gb",u"West Kilbride",4322,55.683333,-4.85 ],
    [ u"gb",u"West Linton",1578,55.75,-3.35 ],
    [ u"gb",u"Weston-super-Mare",82903,51.345833,-2.967778 ],
    [ u"gb",u"Weymouth",50253,50.6,-2.45 ],
    [ u"gb",u"Whitburn",10137,55.866667,-3.683333 ],
    [ u"gb",u"Whitefield",23546,53.55,-2.3 ],
    [ u"gb",u"Whitehaven",24803,54.55,-3.6 ],
    [ u"gb",u"Whitehills",1019,57.666667,-2.583333 ],
    [ u"gb",u"Whithorn",830,54.733333,-4.416667 ],
    [ u"gb",u"Whitley Bay",38055,55.050833,-1.453889 ],
    [ u"gb",u"Whitstable",31166,51.35,1.1 ],
    [ u"gb",u"Wickford",32975,51.6,.516667 ],
    [ u"gb",u"Wick",7147,58.433333,-3.083333 ],
    [ u"gb",u"Widnes",56098,53.35,-2.733333 ],
    [ u"gb",u"Wigan",80789,53.533333,-2.616667 ],
    [ u"gb",u"Wigston",33720,52.583333,-1.1 ],
    [ u"gb",u"Wigtown",934,54.866667,-4.45 ],
    [ u"gb",u"Wilmslow",36618,53.333333,-2.233333 ],
    [ u"gb",u"Winchester",44094,51.016667,-1.316667 ],
    [ u"gb",u"Winsford",30812,53.183333,-2.516667 ],
    [ u"gb",u"Wishaw",27627,55.766667,-3.916667 ],
    [ u"gb",u"Witham",22995,51.783333,.633333 ],
    [ u"gb",u"Witney",24103,51.783333,-1.483333 ],
    [ u"gb",u"Wokingham",41144,51.416667,-.833333 ],
    [ u"gb",u"Wolverhampton",252792,52.583333,-2.133333 ],
    [ u"gb",u"Worcester",100023,52.166667,-2.166667 ],
    [ u"gb",u"Workington",20618,54.65,-3.566667 ],
    [ u"gb",u"Worksop",40443,53.3,-1.133333 ],
    [ u"gb",u"Worthing",99110,50.8,-.366667 ],
    [ u"gb",u"Wrexham",43650,53.05,-3 ],
    [ u"gb",u"Yeovil",43733,50.95,-2.633333 ],
    [ u"gb",u"Yetholm",584,55.55,-2.266667 ],
    [ u"gb",u"York",144202,53.954115,-1.064262 ],
    [ u"gd",u"Gouyave",3378,12.1666667,-61.7333333 ],
    [ u"gd",u"Grenville",2476,12.1166667,-61.6166667 ],
    [ u"gd",u"Hillsborough",770,12.4833333,-61.4666667 ],
    [ u"gd",u"Sauteurs",1320,12.2166667,-61.6333333 ],
    [ u"gd",u"Victoria",2256,12.1833333,-61.7 ],
    [ u"ge",u"Abasha",6222,42.1941667,42.2241667 ],
    [ u"ge",u"Abastumani",1285,41.7,42.85 ],
    [ u"ge",u"Adigeni",1313,41.6858333,42.7102778 ],
    [ u"ge",u"Agara",5811,42.035,43.8352778 ],
    [ u"ge",u"Akhaldaba",3640,41.6530556,42.1580556 ],
    [ u"ge",u"Akhalgori",1420,42.1241667,44.4858333 ],
    [ u"ge",u"Akhmeta",8569,42.0311111,45.2075 ],
    [ u"ge",u"Ambrolauri",2408,42.5211111,43.1622222 ],
    [ u"ge",u"Aspindza",3940,41.5738889,43.2561111 ],
    [ u"ge",u"Bakuriani",2392,41.7497222,43.5325 ],
    [ u"ge",u"Bakurianis Andeziti",1085,41.7338889,43.4702778 ],
    [ u"ge",u"Bediani",227,41.5441667,44.2444444 ],
    [ u"ge",u"Bolnisi",9030,41.445,44.5411111 ],
    [ u"ge",u"Borjomi",13826,41.8375,43.3791667 ],
    [ u"ge",u"Didi Lilo",3349,41.7363889,44.9658333 ],
    [ u"ge",u"Dioknisi",7727,41.6311111,42.4152778 ],
    [ u"ge",u"Dmanisi",3040,41.5227778,44.3533333 ],
    [ u"ge",u"Gagra",8266,43.3222222,40.2436111 ],
    [ u"ge",u"Gali",11861,42.6405556,41.7372222 ],
    [ u"ge",u"Gardabani",10973,41.4547222,45.0947222 ],
    [ u"ge",u"Gori",46680,41.9736111,44.1111111 ],
    [ u"ge",u"Gurjaani",9467,41.7430556,45.8027778 ],
    [ u"ge",u"Java",426,42.3997222,43.9366667 ],
    [ u"ge",u"Jvari",4756,42.7138889,42.0536111 ],
    [ u"ge",u"Kaspi",14735,41.9161111,44.4241667 ],
    [ u"ge",u"Kazbegi",2628,42.6566667,44.6433333 ],
    [ u"ge",u"Kharagauli",5096,42.0202778,43.2138889 ],
    [ u"ge",u"Khashuri",27814,41.9911111,43.59 ],
    [ u"ge",u"Khobi",5376,42.3269444,41.8972222 ],
    [ u"ge",u"Khoni",10796,42.3241667,42.43 ],
    [ u"ge",u"Khulo",768,41.6463889,42.3111111 ],
    [ u"ge",u"Kojori",678,41.6608333,44.6916667 ],
    [ u"ge",u"Kornisi",208,42.2708333,43.8175 ],
    [ u"ge",u"Kulashi",2691,42.2041667,42.3566667 ],
    [ u"ge",u"Kvaisi",237,42.5230556,43.6486111 ],
    [ u"ge",u"Kvareli",8613,41.9513889,45.8016667 ],
    [ u"ge",u"Lagodekhi",6551,41.8227778,46.2755556 ],
    [ u"ge",u"Lajanurhesi",95,42.6180556,42.8355556 ],
    [ u"ge",u"Lentekhi",10442,42.7855556,42.7261111 ],
    [ u"ge",u"Makhinjauri",2736,41.6794444,41.6983333 ],
    [ u"ge",u"Manglisi",4817,41.6930556,44.3780556 ],
    [ u"ge",u"Marneuli",18757,41.4636111,44.8108333 ],
    [ u"ge",u"Martvili",5484,42.4152778,42.3738889 ],
    [ u"ge",u"Mestia",3187,43.0455556,42.7297222 ],
    [ u"ge",u"Naruja",3065,41.9052778,41.9341667 ],
    [ u"ge",u"Ninotsminda",6142,41.2669444,43.5905556 ],
    [ u"ge",u"Ochamchira",15517,42.6966667,41.4783333 ],
    [ u"ge",u"Oni",3014,42.5794444,43.4425 ],
    [ u"ge",u"Pitsunda",8402,43.1569444,40.35 ],
    [ u"ge",u"Sagarejo",12174,41.7363889,45.3302778 ],
    [ u"ge",u"Samtredia",28751,42.1538889,42.335 ],
    [ u"ge",u"Senaki",27755,42.2688889,42.0791667 ],
    [ u"ge",u"Shaumiani",5237,41.3494444,44.7563889 ],
    [ u"ge",u"Shorapani",1699,42.0958333,43.1155556 ],
    [ u"ge",u"Shuakhevi",380,41.63,42.1908333 ],
    [ u"ge",u"Signagi",1923,41.6188889,45.9216667 ],
    [ u"ge",u"Sioni",777,42.6072222,44.5852778 ],
    [ u"ge",u"Sukhumi",81546,43.0033333,41.0152778 ],
    [ u"ge",u"Surami",10091,42.0225,43.5555556 ],
    [ u"ge",u"Tbilisi",1049516,41.725,44.7908333 ],
    [ u"ge",u"Tkibuli",13203,42.3441667,42.99 ],
    [ u"ge",u"Tkvarcheli",17847,42.8525,41.6788889 ],
    [ u"ge",u"Tsagveri",2745,41.8047222,43.4819444 ],
    [ u"ge",u"Tsalenjikha",8881,42.6044444,42.0772222 ],
    [ u"ge",u"Tsalka",1572,41.5913889,44.0869444 ],
    [ u"ge",u"Tskaltubo",16737,42.3397222,42.5991667 ],
    [ u"ge",u"Tskneti",4172,41.6947222,44.6986111 ],
    [ u"ge",u"Tsnori",6613,41.6169444,45.9719444 ],
    [ u"ge",u"Ureki",1625,41.9886111,41.7633333 ],
    [ u"ge",u"Vale",4734,41.6186111,42.8627778 ],
    [ u"ge",u"Vani",4266,42.0813889,42.5244444 ],
    [ u"ge",u"Zahesi",1933,41.8244444,44.7577778 ],
    [ u"ge",u"Zugdidi",73014,42.5013889,41.8613889 ],
    [ u"gf",u"Apatou",4753,5.15,-54.3333333 ],
    [ u"gf",u"Camopi",1295,3.1666667,-52.35 ],
    [ u"gf",u"Cayenne",61642,4.9333333,-52.3333333 ],
    [ u"gf",u"Grand-Santi",3942,4.25,-54.3833333 ],
    [ u"gf",u"Iracoubo",1539,5.4833333,-53.2166667 ],
    [ u"gf",u"Kourou",24035,5.15,-52.65 ],
    [ u"gf",u"Macouria",8786,4.9166667,-52.3666667 ],
    [ u"gf",u"Mana",5887,5.6666667,-53.7833333 ],
    [ u"gf",u"Matoury",26357,4.85,-52.3333333 ],
    [ u"gf",u"Roura",2230,4.7333333,-52.3333333 ],
    [ u"gf",u"Saint-Georges",2743,3.9,-51.8 ],
    [ u"gf",u"Sinnamary",3190,5.3833333,-52.95 ],
    [ u"gh",u"Aboso",8790,5.3666667,-1.9333333 ],
    [ u"gh",u"Aburi",15053,5.85,-0.1833333 ],
    [ u"gh",u"Accra",1963460,5.55,-0.2166667 ],
    [ u"gh",u"Aflao",29991,6.1177778,1.1927778 ],
    [ u"gh",u"Agogo",37123,6.8,-1.0833333 ],
    [ u"gh",u"Akim Swedru",8355,5.9,-1.0166667 ],
    [ u"gh",u"Akropong",11096,5.9666667,-0.0833333 ],
    [ u"gh",u"Akwatia",20451,6.05,-0.8 ],
    [ u"gh",u"Anloga",29748,5.8,0.9 ],
    [ u"gh",u"Apam",20148,5.2833333,-0.7333333 ],
    [ u"gh",u"Asamankese",36589,5.8666667,-0.6666667 ],
    [ u"gh",u"Axim",24500,4.8683333,-2.2413889 ],
    [ u"gh",u"Bawku",41808,11.0580556,-0.2416667 ],
    [ u"gh",u"Bechem",14391,7.0833333,-2.0333333 ],
    [ u"gh",u"Begoro",23759,6.3833333,-0.3833333 ],
    [ u"gh",u"Bekwai",4260,6.45,-1.5833333 ],
    [ u"gh",u"Berekum",36409,7.45,-2.5833333 ],
    [ u"gh",u"Bibiani",19076,6.4666667,-2.3333333 ],
    [ u"gh",u"Bolgatanga",39870,10.7855556,-0.8513889 ],
    [ u"gh",u"Cape Coast",143044,5.1,-1.25 ],
    [ u"gh",u"Duayaw Nkwanta",14227,7.1666667,-2.1 ],
    [ u"gh",u"Dunkwa",25410,5.9666667,-1.7833333 ],
    [ u"gh",u"Ejura",43403,7.3833333,-1.3666667 ],
    [ u"gh",u"Elmina",25560,5.0833333,-1.35 ],
    [ u"gh",u"Foso",15637,5.7,-1.2833333 ],
    [ u"gh",u"Ho",54199,6.6,0.4666667 ],
    [ u"gh",u"Hohoe",30120,7.15,0.4666667 ],
    [ u"gh",u"Kade",13315,6.0833333,-0.8333333 ],
    [ u"gh",u"Keta",18077,5.9166667,0.9833333 ],
    [ u"gh",u"Kibi",9399,6.1666667,-0.55 ],
    [ u"gh",u"Kintampo",22731,8.05,-1.7166667 ],
    [ u"gh",u"Koforidua",76669,6.0833333,-0.25 ],
    [ u"gh",u"Konongo",26909,6.6166667,-1.2166667 ],
    [ u"gh",u"Kpandae",8652,8.4666667,-0.0166667 ],
    [ u"gh",u"Kpandu",22525,7.0,0.3 ],
    [ u"gh",u"Kumasi",1468797,6.6833333,-1.6166667 ],
    [ u"gh",u"Madina",68591,5.6833333,-0.1666667 ],
    [ u"gh",u"Mampong",39732,7.0666667,-1.4 ],
    [ u"gh",u"Mpraeso",9007,6.5833333,-0.7333333 ],
    [ u"gh",u"Mumford",13983,5.2666667,-0.75 ],
    [ u"gh",u"Navrongo",25470,10.895,-1.0938889 ],
    [ u"gh",u"Nkawkaw",41493,6.55,-0.7666667 ],
    [ u"gh",u"Nsawam",26682,5.8,-0.35 ],
    [ u"gh",u"Nungua",70482,5.6,-0.0666667 ],
    [ u"gh",u"Obuasi",119063,6.2,-1.6666667 ],
    [ u"gh",u"Oda",32151,5.9166667,-0.9833333 ],
    [ u"gh",u"Prestea",31607,5.4333333,-2.15 ],
    [ u"gh",u"Salaga",19609,8.55,-0.5166667 ],
    [ u"gh",u"Saltpond",18794,5.2,-1.0666667 ],
    [ u"gh",u"Savelugu",29310,9.6247222,-0.8277778 ],
    [ u"gh",u"Sekondi",104194,4.9333333,-1.7 ],
    [ u"gh",u"Shama",20946,5.0,-1.65 ],
    [ u"gh",u"Suhum",25192,6.0333333,-0.45 ],
    [ u"gh",u"Sunyani",63180,7.3333333,-2.3333333 ],
    [ u"gh",u"Swedru",46950,5.5333333,-0.7 ],
    [ u"gh",u"Tafo",50456,6.7333333,-1.6166667 ],
    [ u"gh",u"Takoradi",114989,4.8833333,-1.75 ],
    [ u"gh",u"Tamale",360644,9.4,-0.8333333 ],
    [ u"gh",u"Tarkwa",41345,5.3,-1.9833333 ],
    [ u"gh",u"Techiman",41315,7.5833333,-1.9333333 ],
    [ u"gh",u"Tema",351556,5.6166667,-0.0166667 ],
    [ u"gh",u"Teshie",144012,5.5833333,-0.1 ],
    [ u"gh",u"Wa",50268,10.05,-2.4833333 ],
    [ u"gh",u"Wenchi",30389,7.7333333,-2.1 ],
    [ u"gh",u"Winneba",40754,5.3333333,-0.6166667 ],
    [ u"gh",u"Yendi",54411,9.4333333,-0.0166667 ],
    [ u"gi",u"Gibraltar",26544,36.1333333,-5.35 ],
    [ u"gl",u"Aappilattoq",208,72.8833333,-55.6 ],
    [ u"gl",u"Aasiaat",3115,68.7166667,-52.8666667 ],
    [ u"gl",u"Akunnaaq",107,68.75,-52.3333333 ],
    [ u"gl",u"Alluitsup Paa",364,60.45,-45.55 ],
    [ u"gl",u"Ammassivik",83,60.6,-45.3833333 ],
    [ u"gl",u"Arsuk",145,61.1666667,-48.45 ],
    [ u"gl",u"Atammik",250,64.8,-52.2166667 ],
    [ u"gl",u"Attu",281,67.95,-53.6333333 ],
    [ u"gl",u"Igaliku",49,60.9833333,-45.4166667 ],
    [ u"gl",u"Iginniarfik",103,68.15,-53.1666667 ],
    [ u"gl",u"Ikamiut",92,68.6333333,-51.8333333 ],
    [ u"gl",u"Ikerasaarsuk",116,68.1333333,-53.5333333 ],
    [ u"gl",u"Ikerasak",286,70.5,-51.3 ],
    [ u"gl",u"Ilimanaq",84,69.0833333,-51.1166667 ],
    [ u"gl",u"Illoqqortoormiut",531,70.4833333,-21.9666667 ],
    [ u"gl",u"Illorsuit",97,71.2333333,-53.5666667 ],
    [ u"gl",u"Ilulissat",4413,69.2166667,-51.1 ],
    [ u"gl",u"Isortoq",113,65.5333333,-38.9833333 ],
    [ u"gl",u"Itilleq",121,66.5833333,-53.5 ],
    [ u"gl",u"Itterajivit",15,70.45,-22.3833333 ],
    [ u"gl",u"Ivittuut",11,61.2,-48.1666667 ],
    [ u"gl",u"Kangaamiut",396,65.8333333,-53.3333333 ],
    [ u"gl",u"Kangaatsiaq",680,68.3,-53.4666667 ],
    [ u"gl",u"Kangersuatsiaq",244,72.3833333,-55.5333333 ],
    [ u"gl",u"Kapisillit",89,64.4333333,-50.2666667 ],
    [ u"gl",u"Kullorsuaq",408,74.5833333,-57.2 ],
    [ u"gl",u"Kulusuk",312,65.5666667,-37.1833333 ],
    [ u"gl",u"Maarmorilik",50,71.1333333,-51.2833333 ],
    [ u"gl",u"Maniitsoq",2866,65.4166667,-52.9 ],
    [ u"gl",u"Moriusaq",21,76.7561111,-69.8863889 ],
    [ u"gl",u"Nanortalik",1509,60.1166667,-45.2166667 ],
    [ u"gl",u"Napasoq",99,65.05,-52.4 ],
    [ u"gl",u"Narsaq Kujalleq",110,60.0030556,-44.6636111 ],
    [ u"gl",u"Narsaq",1709,77.3025,-68.8425 ],
    [ u"gl",u"Narsarsuaq",154,61.1666667,-45.4166667 ],
    [ u"gl",u"Neriunaq",7,64.4666667,-50.3166667 ],
    [ u"gl",u"Niaqornaarsuk",336,68.2333333,-52.8666667 ],
    [ u"gl",u"Niaqornat",60,70.8,-53.65 ],
    [ u"gl",u"Nuugaatsiaq",99,71.55,-53.2166667 ],
    [ u"gl",u"Nuuk",14799,64.1833333,-51.75 ],
    [ u"gl",u"Paamiut",1862,62.0,-49.75 ],
    [ u"gl",u"Qaanaaq",616,77.4894444,-69.3322222 ],
    [ u"gl",u"Qaarsut",204,70.7333333,-52.65 ],
    [ u"gl",u"Qallimiut",12,60.7,-45.3333333 ],
    [ u"gl",u"Qaqortoq",3224,60.7166667,-46.0333333 ],
    [ u"gl",u"Qasigiannguit",1341,68.8166667,-51.1833333 ],
    [ u"gl",u"Qassiarsuk",40,61.15,-45.5166667 ],
    [ u"gl",u"Qassimiut",49,60.7833333,-47.1666667 ],
    [ u"gl",u"Qeqertaq",154,70.0,-51.3166667 ],
    [ u"gl",u"Qeqertarsuatsiaat",261,63.0833333,-50.6666667 ],
    [ u"gl",u"Qeqertat",18,77.5097222,-66.6477778 ],
    [ u"gl",u"Saarloq",48,60.5333333,-46.0333333 ],
    [ u"gl",u"Saattut",211,70.8166667,-51.6333333 ],
    [ u"gl",u"Saqqaq",169,70.0166667,-51.95 ],
    [ u"gl",u"Sarfannguit",110,66.9,-52.8666667 ],
    [ u"gl",u"Savissivik",82,76.0233333,-65.0813889 ],
    [ u"gl",u"Sermiligaaq",223,65.9,-36.3666667 ],
    [ u"gl",u"Siorapaluk",75,77.7952778,-70.7558333 ],
    [ u"gl",u"Sisimiut",5227,66.9333333,-53.6833333 ],
    [ u"gl",u"Tasiilaq",1829,65.6,-37.6333333 ],
    [ u"gl",u"Tasiusaq",7,73.3666667,-56.05 ],
    [ u"gl",u"Timerliit",7,65.8333333,-53.25 ],
    [ u"gl",u"Tiniteqilaaq",169,65.8833333,-37.7833333 ],
    [ u"gl",u"Ukkusissat",195,71.05,-51.8833333 ],
    [ u"gl",u"Upernaviarsuk",13,60.75,-45.8833333 ],
    [ u"gl",u"Upernavik Kujalleq",205,72.15,-55.5333333 ],
    [ u"gl",u"Upernavik",1129,72.7833333,-56.1666667 ],
    [ u"gm",u"Bakau",47654,13.4780556,-16.6819444 ],
    [ u"gm",u"Banjul",34598,13.4530556,-16.5775 ],
    [ u"gm",u"Bansang",7152,13.4333333,-14.65 ],
    [ u"gm",u"Barra",5323,13.4827778,-16.5455556 ],
    [ u"gm",u"Basse",16190,13.3166667,-14.2166667 ],
    [ u"gm",u"Brikama",101805,13.2675,-16.6461111 ],
    [ u"gm",u"Brufut",9332,13.3841667,-16.7513889 ],
    [ u"gm",u"Essau",4997,13.4838889,-16.5347222 ],
    [ u"gm",u"Farafenni",36831,13.5666667,-15.6 ],
    [ u"gm",u"Gambissara",6755,13.2333333,-14.3166667 ],
    [ u"gm",u"Gunjur",12530,13.1816667,-16.7583333 ],
    [ u"gm",u"Kerewan",3017,13.4894444,-16.0911111 ],
    [ u"gm",u"Kuntaur",11399,13.65,-14.8666667 ],
    [ u"gm",u"Lamin",16525,13.3522222,-16.4338889 ],
    [ u"gm",u"Sabi",7738,13.2333333,-14.2 ],
    [ u"gm",u"Serekunda",218790,13.4425,-16.6813889 ],
    [ u"gm",u"Sukuta",15131,13.4113889,-16.7088889 ],
    [ u"gn",u"Beyla",14053,8.6833333,-8.6333333 ],
    [ u"gn",u"Boffa",2332,10.1666667,-14.0333333 ],
    [ u"gn",u"Boké",15462,10.9333333,-14.3 ],
    [ u"gn",u"Conakry",1871185,9.5091667,-13.7122222 ],
    [ u"gn",u"Coyah",1632,9.7055556,-13.3769444 ],
    [ u"gn",u"Dabola",13056,10.75,-11.1166667 ],
    [ u"gn",u"Dalaba",12823,10.7,-12.25 ],
    [ u"gn",u"Dinguiraye",6062,11.3,-10.7166667 ],
    [ u"gn",u"Dubréka",10363,9.7911111,-13.5233333 ],
    [ u"gn",u"Faranah",9349,10.0333333,-10.7333333 ],
    [ u"gn",u"Forécariah",12357,9.4305556,-13.0880556 ],
    [ u"gn",u"Fria",9326,10.45,-13.5333333 ],
    [ u"gn",u"Gaoual",7461,11.75,-13.2 ],
    [ u"gn",u"Guékédou",5534,8.5625,-10.1325 ],
    [ u"gn",u"Kankan",114103,10.3833333,-9.3 ],
    [ u"gn",u"Kérouané",7228,9.2666667,-9.0166667 ],
    [ u"gn",u"Kindia",117095,10.0666667,-12.85 ],
    [ u"gn",u"Kissidougou",47097,9.1833333,-10.1 ],
    [ u"gn",u"Koubia",9909,11.5833333,-11.9 ],
    [ u"gn",u"Koundara",13989,12.4833333,-13.3 ],
    [ u"gn",u"Kouroussa",14222,10.65,-9.8833333 ],
    [ u"gn",u"Labé",46510,11.3166667,-12.2833333 ],
    [ u"gn",u"Lola",1982,7.8,-8.5333333 ],
    [ u"gn",u"Macenta",43107,8.5461111,-9.4694444 ],
    [ u"gn",u"Mali",5479,12.0833333,-12.3 ],
    [ u"gn",u"Mamou",41618,10.15,-11.95 ],
    [ u"gn",u"Mandiana",10608,10.6333333,-8.6833333 ],
    [ u"gn",u"Nzérékoré",132842,7.7472222,-8.8238889 ],
    [ u"gn",u"Pita",20051,11.0833333,-12.4 ],
    [ u"gn",u"Sanguéya",6117,10.7,-14.3666667 ],
    [ u"gn",u"Siguiri",43599,11.4166667,-9.1666667 ],
    [ u"gn",u"Télimélé",30310,10.9,-13.0333333 ],
    [ u"gn",u"Tokonou",6729,9.65,-9.7833333 ],
    [ u"gn",u"Tondon",12235,10.3666667,-13.35 ],
    [ u"gn",u"Tougué",25530,11.45,-11.6833333 ],
    [ u"gn",u"Yomou",3614,7.5602778,-9.2652778 ],
    [ u"gn",u"Youkounkoun",7952,12.5333333,-13.1333333 ],
    [ u"gp",u"Anse-Bertrand",5146,16.4666667,-61.5 ],
    [ u"gp",u"Baie-Mahault",30553,16.2666667,-61.5833333 ],
    [ u"gp",u"Baillif",5705,16.0166667,-61.7333333 ],
    [ u"gp",u"Basse-Terre",11472,16.0,-61.7166667 ],
    [ u"gp",u"Bouillante",7541,16.1333333,-61.7666667 ],
    [ u"gp",u"Capesterre-Belle-Eau",19823,16.05,-61.55 ],
    [ u"gp",u"Gourbeyre",8572,15.9833333,-61.6833333 ],
    [ u"gp",u"Grand-Bourg",5869,15.8833333,-61.3 ],
    [ u"gp",u"Lamentin",14892,16.2666667,-61.6166667 ],
    [ u"gp",u"Le Gosier",28700,16.2,-61.4833333 ],
    [ u"gp",u"Le Moule",22694,16.3333333,-61.3333333 ],
    [ u"gp",u"Les Abymes",63061,16.2666667,-61.5 ],
    [ u"gp",u"Marigot",3368,18.0666667,-63.0833333 ],
    [ u"gp",u"Petit-Bourg",24996,16.1833333,-61.5833333 ],
    [ u"gp",u"Petit-Canal",8554,16.3833333,-61.4833333 ],
    [ u"gp",u"Pointe-Noire",7750,16.2333333,-61.7833333 ],
    [ u"gp",u"Port-Louis",5515,16.4166667,-61.5166667 ],
    [ u"gp",u"Saint-Claude",10135,16.0166667,-61.6833333 ],
    [ u"gp",u"Sainte-Anne",22861,16.2333333,-61.3666667 ],
    [ u"gp",u"Sainte-Rose",20194,16.3333333,-61.6833333 ],
    [ u"gp",u"Saint-François",12733,16.25,-61.2666667 ],
    [ u"gp",u"Terre-de-Bas",1315,15.85,-61.6333333 ],
    [ u"gp",u"Trois-Rivières",8812,15.9666667,-61.6333333 ],
    [ u"gp",u"Vieux-Habitants",7729,16.05,-61.75 ],
    [ u"gq",u"Aconibe",11199,1.3,10.9333333 ],
    [ u"gq",u"Acurenam",2738,1.0333333,10.6666667 ],
    [ u"gq",u"Añisoc",10197,1.85,10.7666667 ],
    [ u"gq",u"Bata",173036,1.85,9.75 ],
    [ u"gq",u"Ebebiyín",24857,2.15,11.3333333 ],
    [ u"gq",u"Evinayong",8468,1.45,10.5666667 ],
    [ u"gq",u"Luba",8668,3.45,8.55 ],
    [ u"gq",u"Malabo",156039,3.75,8.7833333 ],
    [ u"gq",u"Mbini",4061,1.5833333,9.6166667 ],
    [ u"gq",u"Micomeseng",5818,2.1333333,10.6166667 ],
    [ u"gq",u"Mongomo",6397,1.6333333,11.3166667 ],
    [ u"gq",u"Riaba",972,3.3833333,8.7666667 ],
    [ u"gr",u"Adámas",1478,36.7333333,24.4333333 ],
    [ u"gr",u"Ádendron",2312,40.6716667,22.6044444 ],
    [ u"gr",u"Afántou",5562,36.3,28.15 ],
    [ u"gr",u"Áfitos",1428,40.1,23.4333333 ],
    [ u"gr",u"Áfra",879,39.6197222,19.8577778 ],
    [ u"gr",u"Afrátion",1365,38.45,23.6833333 ],
    [ u"gr",u"Agnanterón",1859,39.4872222,21.8455556 ],
    [ u"gr",u"Ágra",983,39.1666667,26.0666667 ],
    [ u"gr",u"Ágrafa",820,39.1372222,21.65 ],
    [ u"gr",u"Ágras",855,40.805,22.0005556 ],
    [ u"gr",u"Agriá",5519,39.3333333,23.0166667 ],
    [ u"gr",u"Agrínion",43526,38.6213889,21.4077778 ],
    [ u"gr",u"Aianí",2119,40.1666667,21.8166667 ],
    [ u"gr",u"Aiántion",3936,37.9166667,23.4666667 ],
    [ u"gr",u"Aigáleo",72320,37.9833333,23.6833333 ],
    [ u"gr",u"Aitolikón",4323,38.4333333,21.35 ],
    [ u"gr",u"Aíyina",7823,37.7466667,23.4275 ],
    [ u"gr",u"Aiyínion",4275,40.5013889,22.54 ],
    [ u"gr",u"Aíyion",20665,38.2486111,22.0819444 ],
    [ u"gr",u"Aíyira",1666,38.15,22.35 ],
    [ u"gr",u"Akharnaí",82376,38.0833333,23.7333333 ],
    [ u"gr",u"Akhinós",898,38.9,22.7333333 ],
    [ u"gr",u"Akraífnion",1195,38.45,23.2166667 ],
    [ u"gr",u"Akráta",1833,38.15,22.3166667 ],
    [ u"gr",u"Akriní",1113,40.4333333,21.9 ],
    [ u"gr",u"Akrolímni",1398,40.6791667,22.2638889 ],
    [ u"gr",u"Alepoú",1640,39.6102778,19.8888889 ],
    [ u"gr",u"Alexándria",13665,40.6266667,22.4441667 ],
    [ u"gr",u"Alexandroúpoli",52978,40.8475,25.8744444 ],
    [ u"gr",u"Alfioúsa",1067,37.65,21.5333333 ],
    [ u"gr",u"Alíartos",4275,38.3666667,23.1 ],
    [ u"gr",u"Alistráti",2965,41.0666667,23.95 ],
    [ u"gr",u"Alivérion",5184,38.4166667,24.0333333 ],
    [ u"gr",u"Álli Meriá",1189,39.3666667,22.9833333 ],
    [ u"gr",u"Almirós",7253,39.1822222,22.7594444 ],
    [ u"gr",u"Alónia",653,40.3944444,22.5416667 ],
    [ u"gr",u"Amaliás",19580,37.8,21.35 ],
    [ u"gr",u"Amárinthos",4360,38.4,23.8833333 ],
    [ u"gr",u"Amaroúsion",72310,38.05,23.8 ],
    [ u"gr",u"Ambelákia",4671,37.9513889,23.5275 ],
    [ u"gr",u"Ambelíai",1070,40.8336111,22.3786111 ],
    [ u"gr",u"Ámbeloi",1118,41.0,23.3666667 ],
    [ u"gr",u"Ambelókipoi",1218,37.7666667,20.8666667 ],
    [ u"gr",u"Ambelón",5961,39.75,22.3666667 ],
    [ u"gr",u"Amfíklia",3674,38.6333333,22.5833333 ],
    [ u"gr",u"Amfilokhía",4023,38.8594444,21.1663889 ],
    [ u"gr",u"Ámfissa",6854,38.525,22.3730556 ],
    [ u"gr",u"Amisianá",1293,40.9333333,24.35 ],
    [ u"gr",u"Ammokhórion",1192,40.7833333,21.4833333 ],
    [ u"gr",u"Análipsis",1259,35.3166667,25.5666667 ],
    [ u"gr",u"Anarrákhi",1147,40.4833333,21.5666667 ],
    [ u"gr",u"Anatolí",6422,39.6388889,20.8652778 ],
    [ u"gr",u"Anatolikón",959,40.55,21.75 ],
    [ u"gr",u"Anatolikón",2583,40.6630556,22.7113889 ],
    [ u"gr",u"Anávissos",8459,37.7333333,23.95 ],
    [ u"gr",u"Anávra",1024,39.0666667,22.55 ],
    [ u"gr",u"Anayénnisis",990,41.1166667,23.3333333 ],
    [ u"gr",u"Andravída",3626,37.9,21.2666667 ],
    [ u"gr",u"Ándros",1556,37.8333333,24.9333333 ],
    [ u"gr",u"Anéza",1197,39.0866667,20.9233333 ],
    [ u"gr",u"Angelókastron",1614,38.5666667,21.3 ],
    [ u"gr",u"Angelokhórion",1526,40.6783333,22.1991667 ],
    [ u"gr",u"Angelokhórion",991,40.4972222,22.8344444 ],
    [ u"gr",u"Anífion",922,37.6666667,22.7833333 ],
    [ u"gr",u"Ánoixis",6482,38.1333333,23.85 ],
    [ u"gr",u"Áno Kastrítsion",1003,38.2666667,21.8333333 ],
    [ u"gr",u"Áno Kómi",1547,40.2333333,21.8333333 ],
    [ u"gr",u"Áno Korakiána",837,39.7077778,19.7916667 ],
    [ u"gr",u"Áno Lekhónia",1214,39.3333333,23.05 ],
    [ u"gr",u"Áno Liósia",28529,38.0833333,23.7 ],
    [ u"gr",u"Áno Merá",1611,37.45,25.4 ],
    [ u"gr",u"Áno Poróïa",1558,41.2833333,23.0333333 ],
    [ u"gr",u"Áno Síros",1138,37.45,24.9333333 ],
    [ u"gr",u"Anóyia",2545,35.2833333,24.8833333 ],
    [ u"gr",u"Ánthia",914,40.8666667,25.9833333 ],
    [ u"gr",u"Anthíli",1381,38.85,22.4666667 ],
    [ u"gr",u"Antimakhia",2251,36.8108333,27.0997222 ],
    [ u"gr",u"Ántissa",841,39.2333333,25.9833333 ],
    [ u"gr",u"Apóllona",982,36.25,27.9666667 ],
    [ u"gr",u"Apollonía",1054,36.9666667,24.7166667 ],
    [ u"gr",u"Ápsalos",1149,40.8927778,22.0544444 ],
    [ u"gr",u"Arakhnaíon",803,37.6833333,22.9666667 ],
    [ u"gr",u"Arákhova",3992,38.4833333,22.5833333 ],
    [ u"gr",u"Áratos",1152,41.0833333,25.55 ],
    [ u"gr",u"Aravissós",1513,40.84,22.2955556 ],
    [ u"gr",u"Árdassa",934,40.4833333,21.6333333 ],
    [ u"gr",u"Aréthousa",905,40.75,23.5833333 ],
    [ u"gr",u"Arfará",1285,37.15,22.0333333 ],
    [ u"gr",u"Argalastí",1285,39.2333333,23.2166667 ],
    [ u"gr",u"Árgos",25091,37.6333333,22.7333333 ],
    [ u"gr",u"Árgos Orestikón",7894,40.4666667,21.2666667 ],
    [ u"gr",u"Argostólion",9820,38.1730556,20.4819444 ],
    [ u"gr",u"Ária",2080,37.5666667,22.8333333 ],
    [ u"gr",u"Aridaía",6091,40.9730556,22.0563889 ],
    [ u"gr",u"Áris",1036,37.1,22.0 ],
    [ u"gr",u"Arísvi",1068,41.0666667,25.5833333 ],
    [ u"gr",u"Arkalokhórion",3537,35.15,25.2666667 ],
    [ u"gr",u"Arkhaía Kórinthos",1701,37.9166667,22.8833333 ],
    [ u"gr",u"Arkhaía Olimbía",1208,37.65,21.6333333 ],
    [ u"gr",u"Arkhángelos",5398,36.1833333,28.1333333 ],
    [ u"gr",u"Árma",1078,38.35,23.4833333 ],
    [ u"gr",u"Arménion",727,39.4833333,22.7 ],
    [ u"gr",u"Armenokhórion",1079,40.8,21.4666667 ],
    [ u"gr",u"Arnaía",2271,40.4819444,23.5927778 ],
    [ u"gr",u"Árnissa",1556,40.8,21.8333333 ],
    [ u"gr",u"Arrianá",1158,41.0833333,25.7 ],
    [ u"gr",u"Arsénion",1389,40.7141667,22.1622222 ],
    [ u"gr",u"Árta",19541,39.1605556,20.9852778 ],
    [ u"gr",u"Artesianón",1412,39.4027778,21.8947222 ],
    [ u"gr",u"Aryiropoúlion",1782,39.8333333,22.3 ],
    [ u"gr",u"Asímion",1259,35.05,25.1 ],
    [ u"gr",u"Asíni",1081,37.55,22.8666667 ],
    [ u"gr",u"Askós",1406,40.75,23.3833333 ],
    [ u"gr",u"Asopía",1375,38.3,23.5 ],
    [ u"gr",u"Asopós",1279,36.7333333,22.8666667 ],
    [ u"gr",u"Asprópirgos",32712,38.0666667,23.5833333 ],
    [ u"gr",u"Áspros",891,40.8991667,22.6222222 ],
    [ u"gr",u"Asproválta",3333,40.7166667,23.7 ],
    [ u"gr",u"Ássiros",2409,40.8166667,23.0333333 ],
    [ u"gr",u"Ássos",2730,37.9333333,22.8333333 ],
    [ u"gr",u"Astakós",2569,38.5333333,21.0833333 ],
    [ u"gr",u"Astipálaia",1129,36.55,26.35 ],
    [ u"gr",u"Ástros",2222,37.4,22.7166667 ],
    [ u"gr",u"Asvestokhórion",5345,40.65,23.0333333 ],
    [ u"gr",u"Atalánti",5859,38.6511111,22.9991667 ],
    [ u"gr",u"Athens",729139,37.9833333,23.7333333 ],
    [ u"gr",u"Athíkia",2058,37.8166667,22.9333333 ],
    [ u"gr",u"Áthira",1722,40.8252778,22.5833333 ],
    [ u"gr",u"Atsikí",886,39.95,25.2166667 ],
    [ u"gr",u"Atsipópoulon",1826,35.35,24.4333333 ],
    [ u"gr",u"Ávaton",1357,40.9666667,24.8 ],
    [ u"gr",u"Axioúpoli",3368,40.9836111,22.535 ],
    [ u"gr",u"Axós",1336,40.7988889,22.3558333 ],
    [ u"gr",u"Ayía Ánna",823,38.8666667,23.4 ],
    [ u"gr",u"Ayiá",2827,39.7177778,22.7636111 ],
    [ u"gr",u"Ayía Galíni",1369,35.1,24.6833333 ],
    [ u"gr",u"Ayía Marína",732,40.5977778,22.2152778 ],
    [ u"gr",u"Ayía Marína",2731,37.75,23.5333333 ],
    [ u"gr",u"Ayía Marína",1671,35.5166667,23.9333333 ],
    [ u"gr",u"Ayía Marína",2743,37.15,26.8666667 ],
    [ u"gr",u"Ayía Paraskeví",978,40.95,23.4666667 ],
    [ u"gr",u"Ayía Paraskeví",1501,40.4833333,23.05 ],
    [ u"gr",u"Ayía Paraskeví",998,38.5833333,22.75 ],
    [ u"gr",u"Ayía Paraskeví",60662,38.0166667,23.8333333 ],
    [ u"gr",u"Ayía Paraskeví",2193,39.2480556,26.2716667 ],
    [ u"gr",u"Ayíasma",1185,40.9088889,24.6572222 ],
    [ u"gr",u"Ayiásos",2357,39.085,26.37 ],
    [ u"gr",u"Ayía Triás",3580,40.4994444,22.8761111 ],
    [ u"gr",u"Ayía Triás",754,39.2947222,21.7330556 ],
    [ u"gr",u"Ayía Triás",1098,38.35,22.9166667 ],
    [ u"gr",u"Ayía Varvára",31218,37.9833333,23.6666667 ],
    [ u"gr",u"Ayía Varvára",2167,35.1333333,25.0 ],
    [ u"gr",u"Áyioi Apóstoloi",4338,38.3,23.9 ],
    [ u"gr",u"Áyios Andréas",1033,37.35,22.7666667 ],
    [ u"gr",u"Áyios Athanásios",4648,40.7172222,22.7280556 ],
    [ u"gr",u"Áyios Athanásios",3419,41.0666667,24.25 ],
    [ u"gr",u"Áyios Ioánnis",983,38.45,24.0 ],
    [ u"gr",u"Áyios Kírikos",1908,37.6147222,26.2944444 ],
    [ u"gr",u"Áyios Loukás",1666,40.7194444,22.295 ],
    [ u"gr",u"Áyios Loukás",955,38.4333333,24.0333333 ],
    [ u"gr",u"Áyios Mámas",1044,40.2666667,23.3333333 ],
    [ u"gr",u"Áyios Matthaíos",1640,39.4958333,19.8730556 ],
    [ u"gr",u"Áyios Nikólaos",1913,40.25,23.7 ],
    [ u"gr",u"Áyios Nikólaos",982,38.7333333,21.1166667 ],
    [ u"gr",u"Áyios Nikólaos",2880,38.4166667,23.65 ],
    [ u"gr",u"Áyios Nikólaos",1305,37.85,21.1166667 ],
    [ u"gr",u"Áyios Nikólaos",10799,35.1913889,25.7133333 ],
    [ u"gr",u"Áyios Pétros",1763,40.8647222,22.5763889 ],
    [ u"gr",u"Áyios Pétros",857,37.3333333,22.55 ],
    [ u"gr",u"Áyios Serafím",1071,38.8,22.7 ],
    [ u"gr",u"Áyios Stéfanos",10940,38.15,23.85 ],
    [ u"gr",u"Áyios Thomás",1433,38.2833333,23.5833333 ],
    [ u"gr",u"Áyios Vasílios",1328,40.6666667,23.1166667 ],
    [ u"gr",u"Áyios Vasílios",2303,38.3166667,21.8166667 ],
    [ u"gr",u"Áyios Vasílios",1462,37.8,22.8 ],
    [ u"gr",u"Áyios Yeóryios",1767,40.6011111,22.1941667 ],
    [ u"gr",u"Áyios Yeóryios",2046,38.4,22.9333333 ],
    [ u"gr",u"Darátsos",3747,35.5,23.9833333 ],
    [ u"gr",u"Dervéni",1379,38.1333333,22.4166667 ],
    [ u"gr",u"Deskáti",3856,39.9225,21.8027778 ],
    [ u"gr",u"Diavatá",10216,40.6888889,22.8569444 ],
    [ u"gr",u"Diavatós",1294,40.5455556,22.2669444 ],
    [ u"gr",u"Díkaia",737,41.7041667,26.2933333 ],
    [ u"gr",u"Díon",1413,40.1733333,22.4866667 ],
    [ u"gr",u"Dolianá",616,39.9019444,20.5794444 ],
    [ u"gr",u"Domokós",1433,39.1272222,22.3002778 ],
    [ u"gr",u"Domvraína",1138,38.25,22.9833333 ],
    [ u"gr",u"Dráma",44225,41.1544444,24.1394444 ],
    [ u"gr",u"Drosáton",1148,41.1627778,22.7988889 ],
    [ u"gr",u"Édessa",18669,40.8005556,22.0472222 ],
    [ u"gr",u"Ekáli",5666,38.1166667,23.8333333 ],
    [ u"gr",u"Ekhínos",2162,41.2833333,24.9666667 ],
    [ u"gr",u"Elassón",7060,39.8947222,22.1886111 ],
    [ u"gr",u"Elátia",2449,38.6333333,22.7666667 ],
    [ u"gr",u"Eláti",886,39.5038889,21.5347222 ],
    [ u"gr",u"Eleón",656,38.35,23.4833333 ],
    [ u"gr",u"Eleoúsa",3064,39.7063889,20.7925 ],
    [ u"gr",u"Eleoúsa",963,39.1513889,20.9855556 ],
    [ u"gr",u"Eleusis",27055,38.0333333,23.5333333 ],
    [ u"gr",u"Ellinikón",18094,37.8833333,23.7333333 ],
    [ u"gr",u"Élos",957,36.8333333,22.7 ],
    [ u"gr",u"Émbonas",1211,36.2166667,27.8666667 ],
    [ u"gr",u"Embórion",1033,40.4833333,21.55 ],
    [ u"gr",u"Emboríon",1946,36.35,25.45 ],
    [ u"gr",u"Emmanouíl Pappás",1129,41.0833333,23.7166667 ],
    [ u"gr",u"Epáno Arkhánai",3913,35.2333333,25.1666667 ],
    [ u"gr",u"Epanomí",8121,40.4272222,22.9283333 ],
    [ u"gr",u"Epinianá",682,39.1419444,21.6133333 ],
    [ u"gr",u"Episkopí",967,35.25,25.2333333 ],
    [ u"gr",u"Epitálion",1953,37.6333333,21.5 ],
    [ u"gr",u"Eratinón",920,40.95,24.6333333 ],
    [ u"gr",u"Erátira",1383,40.35,21.5166667 ],
    [ u"gr",u"Eresós",1042,39.1666667,25.9333333 ],
    [ u"gr",u"Erétria",3217,38.4,23.8 ],
    [ u"gr",u"Erikoússa",863,39.8808333,19.5913889 ],
    [ u"gr",u"Erithraí",3250,38.2166667,23.3166667 ],
    [ u"gr",u"Ermióni",2856,37.3833333,23.25 ],
    [ u"gr",u"Ermoúpolis",11351,37.45,24.9333333 ],
    [ u"gr",u"Esóvalta",988,40.7072222,22.2630556 ],
    [ u"gr",u"Examília",1631,37.9,22.9333333 ],
    [ u"gr",u"Exaplátanos",1665,40.9772222,22.125 ],
    [ u"gr",u"Éxarkhos",965,38.5833333,22.95 ],
    [ u"gr",u"Exokhí",1739,40.0975,20.7402778 ],
    [ u"gr",u"Fálanna",3557,39.7166667,22.4 ],
    [ u"gr",u"Fánai",868,36.35,27.9833333 ],
    [ u"gr",u"Fáros",1195,38.4,23.6166667 ],
    [ u"gr",u"Fársala",10380,39.2947222,22.3847222 ],
    [ u"gr",u"Férai",5403,40.8955556,26.17 ],
    [ u"gr",u"Fíki",1098,39.5169444,21.6555556 ],
    [ u"gr",u"Filiátes",2129,39.6011111,20.3119444 ],
    [ u"gr",u"Filiatrá",6970,37.15,21.5833333 ],
    [ u"gr",u"Filí",2875,38.1,23.6666667 ],
    [ u"gr",u"Filippiás",4256,39.2047222,20.8822222 ],
    [ u"gr",u"Fíliron",4362,40.6833333,23.0 ],
    [ u"gr",u"Fílla",1276,38.4333333,23.6833333 ],
    [ u"gr",u"Fillíra",1041,41.1166667,25.6333333 ],
    [ u"gr",u"Filótas",1774,40.6333333,21.7 ],
    [ u"gr",u"Filótion",1744,37.05,25.5 ],
    [ u"gr",u"Fitíai",1516,38.7,21.1833333 ],
    [ u"gr",u"Flámbouron",762,40.9333333,23.5666667 ],
    [ u"gr",u"Flórina",14910,40.7833333,21.4 ],
    [ u"gr",u"Floyitá",1589,40.2666667,23.2166667 ],
    [ u"gr",u"Fotolívos",1844,41.0666667,24.0666667 ],
    [ u"gr",u"Foúrnoi",1033,37.7794444,26.7516667 ],
    [ u"gr",u"Fteliá",1006,41.0833333,24.1833333 ],
    [ u"gr",u"Gaïtánion",1584,37.7833333,20.8666667 ],
    [ u"gr",u"Galatádes",2459,40.7544444,22.2716667 ],
    [ u"gr",u"Galatás",1057,38.35,21.5666667 ],
    [ u"gr",u"Galatás",2759,37.5,23.45 ],
    [ u"gr",u"Galatás",2377,35.5,23.9666667 ],
    [ u"gr",u"Galatiní",2085,40.3166667,21.55 ],
    [ u"gr",u"Galátista",2710,40.4666667,23.2833333 ],
    [ u"gr",u"Galátsion",58625,38.0166667,23.75 ],
    [ u"gr",u"Galiá",852,35.0833333,24.8666667 ],
    [ u"gr",u"Gallikós",1239,40.8591667,22.8755556 ],
    [ u"gr",u"Gargaliánoi",6282,37.0666667,21.6333333 ],
    [ u"gr",u"Gastoúni",8114,37.85,21.25 ],
    [ u"gr",u"Gastóuri",1129,39.56,19.8975 ],
    [ u"gr",u"Gavaloú",1419,38.5333333,21.5333333 ],
    [ u"gr",u"Gázion",9721,35.3333333,25.0666667 ],
    [ u"gr",u"Gázoros",1677,41.0166667,23.7666667 ],
    [ u"gr",u"Glóssa",987,39.1666667,23.6166667 ],
    [ u"gr",u"Gómfoi",1064,39.4636111,21.6925 ],
    [ u"gr",u"Gónnoi",2113,39.8666667,22.4666667 ],
    [ u"gr",u"Gorgópi",913,40.9588889,22.5130556 ],
    [ u"gr",u"Gouménissa",4010,40.9438889,22.4441667 ],
    [ u"gr",u"Goúmeron",1072,37.7666667,21.6166667 ],
    [ u"gr",u"Gouriá",1096,38.4666667,21.2666667 ],
    [ u"gr",u"Goúrnai",1539,35.3166667,25.2833333 ],
    [ u"gr",u"Gouviá",874,39.6502778,19.8433333 ],
    [ u"gr",u"Graikokhórion",1264,39.4788889,20.295 ],
    [ u"gr",u"Gra Liyiá",1282,35.0166667,25.6833333 ],
    [ u"gr",u"Grammatikón",1334,38.2,23.9666667 ],
    [ u"gr",u"Grammatikoú",1061,38.5333333,21.5 ],
    [ u"gr",u"Grammenítsa",1193,39.1830556,20.9805556 ],
    [ u"gr",u"Grevená",10563,40.0833333,21.4166667 ],
    [ u"gr",u"Grízanon",1528,39.6333333,22.05 ],
    [ u"gr",u"Ialisós",11473,36.4,28.1666667 ],
    [ u"gr",u"Íasmos",2787,41.1333333,25.1833333 ],
    [ u"gr",u"Ierápetra",12536,35.01,25.7352778 ],
    [ u"gr",u"Ierissós",3135,40.4,23.8833333 ],
    [ u"gr",u"Igoumenítsa",9496,39.5038889,20.2655556 ],
    [ u"gr",u"Ioánnina",64012,39.6675,20.8508333 ],
    [ u"gr",u"Íos",1803,36.7333333,25.2833333 ],
    [ u"gr",u"Ípsos",769,39.6947222,19.8366667 ],
    [ u"gr",u"Iráklia",3424,41.1666667,23.2666667 ],
    [ u"gr",u"Iráklion",876,40.7666667,23.0333333 ],
    [ u"gr",u"Iráklion",47007,38.0666667,23.7666667 ],
    [ u"gr",u"Iráklion",137155,35.325,25.1305556 ],
    [ u"gr",u"Isthmía",1043,37.9166667,23.0 ],
    [ u"gr",u"Istiaía",4199,38.9558333,23.1527778 ],
    [ u"gr",u"Itéa",1301,39.4666667,22.1666667 ],
    [ u"gr",u"Itéa",4782,38.4333333,22.4166667 ],
    [ u"gr",u"Itháki",1842,38.3602778,20.7161111 ],
    [ u"gr",u"Kainoúryion",1214,38.8,22.7166667 ],
    [ u"gr",u"Kainoúryion",2946,38.6,21.5 ],
    [ u"gr",u"Kaisarianí",26126,37.9666667,23.8 ],
    [ u"gr",u"Kalamákion",820,37.7333333,20.9166667 ],
    [ u"gr",u"Kalamákion",40490,37.9166667,23.7166667 ],
    [ u"gr",u"Kalamariá",91617,40.5825,22.9502778 ],
    [ u"gr",u"Kalamáta",51108,37.0388889,22.1141667 ],
    [ u"gr",u"Kalambáka",8138,39.7044444,21.6269444 ],
    [ u"gr",u"Kalambákion",3514,41.05,24.1833333 ],
    [ u"gr",u"Kalamiá",1197,39.1655556,20.9316667 ],
    [ u"gr",u"Kálamos",2158,38.2833333,23.8666667 ],
    [ u"gr",u"Kalamotón",871,40.5666667,23.3666667 ],
    [ u"gr",u"Kalá Nerá",841,39.3,23.1166667 ],
    [ u"gr",u"Kalávrita",1629,38.0322222,22.1125 ],
    [ u"gr",u"Kalí",1773,40.82,22.1752778 ],
    [ u"gr",u"Kálimnos",10002,36.95,26.9833333 ],
    [ u"gr",u"Kalívai",1288,35.45,24.1666667 ],
    [ u"gr",u"Kalívai Poliyírou",1147,40.2833333,23.4 ],
    [ u"gr",u"Kalívia",1130,40.7561111,22.2136111 ],
    [ u"gr",u"Kalívia",990,38.6166667,21.3 ],
    [ u"gr",u"Kalívia Thorikoú",14712,37.8333333,23.9166667 ],
    [ u"gr",u"Kalí Vrísi",1163,41.15,23.9 ],
    [ u"gr",u"Kallífitos",1098,41.1666667,24.2166667 ],
    [ u"gr",u"Kallifónion",1208,39.2725,21.9561111 ],
    [ u"gr",u"Kallimasiá",895,38.2941667,26.1011111 ],
    [ u"gr",u"Kallithéa",976,40.0833333,23.45 ],
    [ u"gr",u"Kallithéa",1131,41.25,24.7333333 ],
    [ u"gr",u"Kallithéa",3100,40.2763889,22.5783333 ],
    [ u"gr",u"Kallithéa",107767,37.95,23.7 ],
    [ u"gr",u"Kallithéa",949,37.55,21.8166667 ],
    [ u"gr",u"Kallíthiron",1098,39.2816667,21.9061111 ],
    [ u"gr",u"Kalloní",1776,39.2327778,26.2080556 ],
    [ u"gr",u"Kalokhórion",4162,40.6413889,22.8566667 ],
    [ u"gr",u"Kalós Agrós",1275,41.1,24.0833333 ],
    [ u"gr",u"Kamárai",1200,38.3,22.0 ],
    [ u"gr",u"Kamárion",1166,38.1,22.5833333 ],
    [ u"gr",u"Kamárion",1599,36.8,25.8166667 ],
    [ u"gr",u"Kamariótissa",1022,40.4833333,25.4666667 ],
    [ u"gr",u"Kamaterón",24310,38.0666667,23.7 ],
    [ u"gr",u"Kambánis",1523,40.8880556,22.9102778 ],
    [ u"gr",u"Kambí",1027,39.2166667,20.9 ],
    [ u"gr",u"Kaména Voúrla",2881,38.7833333,22.7833333 ],
    [ u"gr",u"Kamínia",850,38.15,21.6166667 ],
    [ u"gr",u"Kanália",1144,39.5,22.8833333 ],
    [ u"gr",u"Kanálion",964,39.0652778,20.6986111 ],
    [ u"gr",u"Kanálion",3953,39.6055556,19.8925 ],
    [ u"gr",u"Kanallákion",2446,39.2336111,20.6 ],
    [ u"gr",u"Kandíla",1245,38.7,20.9333333 ],
    [ u"gr",u"Kapandrítion",2672,38.2166667,23.8833333 ],
    [ u"gr",u"Kaparéllion",1478,38.2333333,23.2166667 ],
    [ u"gr",u"Karátoulas",1004,37.7333333,21.5333333 ],
    [ u"gr",u"Kardámaina",1926,36.7813889,27.1425 ],
    [ u"gr",u"Kardamás",1138,37.7666667,21.3333333 ],
    [ u"gr",u"Kardiá",1751,40.4677778,22.9947222 ],
    [ u"gr",u"Kardítsa",32789,39.3655556,21.9216667 ],
    [ u"gr",u"Karditsomagoúla",2200,39.3919444,21.9241667 ],
    [ u"gr",u"Kariaí",237,40.25,24.25 ],
    [ u"gr",u"Kariaí",1048,37.3,22.5 ],
    [ u"gr",u"Kariá",994,38.7666667,20.65 ],
    [ u"gr",u"Kariótissa",1965,40.7683333,22.3052778 ],
    [ u"gr",u"Káristos",5091,38.0133333,24.4161111 ],
    [ u"gr",u"Karítsa",2225,40.1875,22.4819444 ],
    [ u"gr",u"Karotí",663,41.4,26.4166667 ],
    [ u"gr",u"Karousádes",993,39.7808333,19.7411111 ],
    [ u"gr",u"Kárpathos",2243,35.5,27.2333333 ],
    [ u"gr",u"Karpenísion",6888,38.9166667,21.7833333 ],
    [ u"gr",u"Karperí",1035,41.1166667,23.3 ],
    [ u"gr",u"Karpokhórion",1059,39.3333333,22.0166667 ],
    [ u"gr",u"Kassiópi",1165,39.7886111,19.9186111 ],
    [ u"gr",u"Kastanéai",1213,41.65,26.4666667 ],
    [ u"gr",u"Kastélla",1370,38.5666667,23.6333333 ],
    [ u"gr",u"Kastéllion",1828,35.2,25.3333333 ],
    [ u"gr",u"Kastoriá",14665,40.5166667,21.2666667 ],
    [ u"gr",u"Kastrákion",1172,39.7155556,21.6180556 ],
    [ u"gr",u"Kastrákion",912,38.4166667,21.9 ],
    [ u"gr",u"Kástron",818,38.5,23.1666667 ],
    [ u"gr",u"Katastárion",1321,37.8333333,20.7666667 ],
    [ u"gr",u"Kateríni",53294,40.2719444,22.5025 ],
    [ u"gr",u"Káto Akhaïa",5752,38.15,21.55 ],
    [ u"gr",u"Káto Asítai",1264,35.2,25.0 ],
    [ u"gr",u"Káto Ássos",1617,37.95,22.8333333 ],
    [ u"gr",u"Káto Glikóvrisi",1753,36.8333333,22.7833333 ],
    [ u"gr",u"Káto Kamíla",1398,41.0166667,23.4833333 ],
    [ u"gr",u"Katokhí",2850,38.4166667,21.25 ],
    [ u"gr",u"Káto Khoríon",1110,35.05,25.7833333 ],
    [ u"gr",u"Káto Korakiána",1055,39.6897222,19.8252778 ],
    [ u"gr",u"Káto Lekhónia",1751,39.3333333,23.0333333 ],
    [ u"gr",u"Káto Mazarákion",1005,38.0666667,21.65 ],
    [ u"gr",u"Káto Miléa",1286,40.2483333,22.3377778 ],
    [ u"gr",u"Káto Mitroúsion",662,41.0666667,23.45 ],
    [ u"gr",u"Káto Skholárion",1904,40.4333333,23.0333333 ],
    [ u"gr",u"Káto Soúlion",1493,38.1666667,24.0 ],
    [ u"gr",u"Káto Tithoréa",2753,38.6,22.7166667 ],
    [ u"gr",u"Katoúna",2235,38.7833333,21.1166667 ],
    [ u"gr",u"Katsikás",2993,39.6225,20.8875 ],
    [ u"gr",u"Kavála",59240,40.9397222,24.4019444 ],
    [ u"gr",u"Kavallárion",2025,40.7166667,23.05 ],
    [ u"gr",u"Kavásilas",1623,37.8666667,21.2666667 ],
    [ u"gr",u"Kavíli",1531,41.5666667,26.5166667 ],
    [ u"gr",u"Kávos",923,39.3838889,20.1133333 ],
    [ u"gr",u"Kéfalos",2528,36.7452778,26.9588889 ],
    [ u"gr",u"Kefalóvrison",1011,40.0144444,20.5625 ],
    [ u"gr",u"Kefalóvrison",959,39.5805556,21.6930556 ],
    [ u"gr",u"Kélla",746,40.7833333,21.6833333 ],
    [ u"gr",u"Keramotí",1338,40.8583333,24.7061111 ],
    [ u"gr",u"Keratéa",7701,37.8,23.9833333 ],
    [ u"gr",u"Keratsínion",77222,37.9625,23.6197222 ],
    [ u"gr",u"Kerkíni",1573,41.2166667,23.0833333 ],
    [ u"gr",u"Kérkira",27004,39.62,19.9197222 ],
    [ u"gr",u"Khalándrion",74211,38.0333333,23.8 ],
    [ u"gr",u"Khalandrítsa",949,38.1166667,21.7833333 ],
    [ u"gr",u"Khalástra",7360,40.6286111,22.7327778 ],
    [ u"gr",u"Khálki",1837,39.5666667,22.5333333 ],
    [ u"gr",u"Khalkís",54559,38.4636111,23.5994444 ],
    [ u"gr",u"Khalkoútsion",2293,38.3333333,23.7333333 ],
    [ u"gr",u"Khaniá",54565,35.5122222,24.0155556 ],
    [ u"gr",u"Khánion toú Kokkíni",1385,35.3333333,25.25 ],
    [ u"gr",u"Khaniótis",1177,40.0,23.5833333 ],
    [ u"gr",u"Kharíessa",926,40.6519444,22.1666667 ],
    [ u"gr",u"Kharopón",1523,41.2666667,23.3833333 ],
    [ u"gr",u"Khavárion",1467,37.85,21.3833333 ],
    [ u"gr",u"Khersónisos",938,35.3,25.3666667 ],
    [ u"gr",u"Khiliomodion",1769,37.8166667,22.8666667 ],
    [ u"gr",u"Khímarros",950,41.1166667,23.25 ],
    [ u"gr",u"Khíos",23953,38.3677778,26.1358333 ],
    [ u"gr",u"Kholargós",31545,38.0,23.8 ],
    [ u"gr",u"Khóra",3591,37.05,21.7166667 ],
    [ u"gr",u"Khóra",1498,37.7036111,26.9055556 ],
    [ u"gr",u"Khoríon",3331,36.9666667,26.9666667 ],
    [ u"gr",u"Khoristí",2719,41.1333333,24.2166667 ],
    [ u"gr",u"Khoríyion",928,40.9941667,22.7205556 ],
    [ u"gr",u"Khortiátis",3466,40.6,23.1 ],
    [ u"gr",u"Khrisókastron",767,40.8833333,24.1833333 ],
    [ u"gr",u"Khrisokhórafa",1302,41.1833333,23.2333333 ],
    [ u"gr",u"Khrisokhórion",1866,40.9333333,24.7166667 ],
    [ u"gr",u"Khrisón",2079,41.0666667,23.65 ],
    [ u"gr",u"Kiáto",10032,38.0166667,22.75 ],
    [ u"gr",u"Kifisiá",45755,38.0666667,23.8166667 ],
    [ u"gr",u"Kilkís",19734,40.9919444,22.8708333 ],
    [ u"gr",u"Killíni",1133,37.9333333,21.15 ],
    [ u"gr",u"Kími",2979,38.6333333,24.1 ],
    [ u"gr",u"Kímina",3775,40.6147222,22.6911111 ],
    [ u"gr",u"Kimméria",3423,41.15,24.9333333 ],
    [ u"gr",u"Kinéta",2004,37.9666667,23.2 ],
    [ u"gr",u"Kinopiástai",1463,39.5694444,19.8825 ],
    [ u"gr",u"Kiparissía",5033,37.2511111,21.6736111 ],
    [ u"gr",u"Kipía",737,40.8833333,24.2 ],
    [ u"gr",u"Kiprínos",1095,41.5755556,26.2305556 ],
    [ u"gr",u"Kipséli",2096,38.0,23.7333333 ],
    [ u"gr",u"Kirás Vrísi",1151,37.9166667,22.9833333 ],
    [ u"gr",u"Kiriákion",2227,38.35,22.7833333 ],
    [ u"gr",u"Kíria",1611,41.1,24.2833333 ],
    [ u"gr",u"Kírra",1348,38.4333333,22.45 ],
    [ u"gr",u"Kíssamos",4205,35.4938889,23.6569444 ],
    [ u"gr",u"Kítros",1412,40.3755556,22.5783333 ],
    [ u"gr",u"Kivérion",979,37.5166667,22.7333333 ],
    [ u"gr",u"Klítos",1382,40.4333333,21.8666667 ],
    [ u"gr",u"Koíla",1493,40.3333333,21.7833333 ],
    [ u"gr",u"Koilás",1126,37.4166667,23.1333333 ],
    [ u"gr",u"Koímisis",1490,41.2166667,23.3 ],
    [ u"gr",u"Kokkárion",1003,37.7763889,26.8938889 ],
    [ u"gr",u"Kokkínion",891,39.6105556,19.8102778 ],
    [ u"gr",u"Kokkinókhoma",1934,40.9333333,24.3 ],
    [ u"gr",u"Kókkinon",744,38.4833333,23.2333333 ],
    [ u"gr",u"Kokkónion",1221,37.9666667,22.7833333 ],
    [ u"gr",u"Kolimvári",1032,35.55,23.7833333 ],
    [ u"gr",u"Kolindrós",3590,40.4758333,22.4808333 ],
    [ u"gr",u"Kolkhikón",2010,40.75,23.1333333 ],
    [ u"gr",u"Kombótion",2150,39.1022222,21.0852778 ],
    [ u"gr",u"Komniná",1126,40.6,21.7833333 ],
    [ u"gr",u"Komotiní",45630,41.1227778,25.3963889 ],
    [ u"gr",u"Kónitsa",2875,40.0486111,20.7566667 ],
    [ u"gr",u"Kontariótissa",2088,40.2288889,22.4622222 ],
    [ u"gr",u"Kontokálion",1798,39.6452778,19.8494444 ],
    [ u"gr",u"Kopanós",2202,40.6336111,22.1302778 ],
    [ u"gr",u"Korifí",1552,40.6,22.5 ],
    [ u"gr",u"Korinós",4191,40.315,22.5852778 ],
    [ u"gr",u"Kórinthos",30900,37.9166667,22.8833333 ],
    [ u"gr",u"Korisós",1389,40.5,21.3833333 ],
    [ u"gr",u"Kormísta",1008,40.9833333,24.05 ],
    [ u"gr",u"Koromiléa",774,41.0741667,22.8480556 ],
    [ u"gr",u"Koróni",1620,36.8,21.95 ],
    [ u"gr",u"Koropíon",17151,37.9,23.8833333 ],
    [ u"gr",u"Kos",19244,36.8933333,27.2888889 ],
    [ u"gr",u"Kostakioí",1417,39.1375,20.9588889 ],
    [ u"gr",u"Kostaléxis",951,38.85,22.3666667 ],
    [ u"gr",u"Kostarázion",935,40.4333333,21.3333333 ],
    [ u"gr",u"Koufália",8305,40.7777778,22.5719444 ],
    [ u"gr",u"Koufóvounon",883,41.35,26.4333333 ],
    [ u"gr",u"Kouloúra",1156,40.5452778,22.3180556 ],
    [ u"gr",u"Koutouloufárion",751,35.3,25.3833333 ],
    [ u"gr",u"Koutsélion",1177,39.5888889,20.9141667 ],
    [ u"gr",u"Koutsourás",869,35.0333333,25.95 ],
    [ u"gr",u"Kouvarás",1381,37.8333333,23.9666667 ],
    [ u"gr",u"Kozáni",36481,40.3011111,21.7863889 ],
    [ u"gr",u"Kranéa Elassónos",2936,39.9483333,21.9658333 ],
    [ u"gr",u"Kranídion",4442,37.3816667,23.1552778 ],
    [ u"gr",u"Kremastí",4700,36.4,28.1166667 ],
    [ u"gr",u"Kréstena",4733,37.6166667,21.6333333 ],
    [ u"gr",u"Kría Vrísi",6839,40.6872222,22.3022222 ],
    [ u"gr",u"Krikellos",1312,38.95,21.1833333 ],
    [ u"gr",u"Kríni",845,39.6166667,22.0166667 ],
    [ u"gr",u"Krionérion",928,40.8166667,23.2833333 ],
    [ u"gr",u"Krionérion",3393,38.15,23.8333333 ],
    [ u"gr",u"Krionérion",968,37.9666667,22.6333333 ],
    [ u"gr",u"Kristallopiyí",699,40.6380556,21.0852778 ],
    [ u"gr",u"Kristóni",1195,40.9555556,22.8552778 ],
    [ u"gr",u"Krithiá",1374,40.8411111,22.9777778 ],
    [ u"gr",u"Kritsá",1560,35.1666667,25.65 ],
    [ u"gr",u"Krokeaí",1329,36.8833333,22.55 ],
    [ u"gr",u"Krókos",3004,40.2666667,21.8166667 ],
    [ u"gr",u"Krousón",2811,35.2333333,24.9833333 ],
    [ u"gr",u"Lagós",1535,41.45,26.4666667 ],
    [ u"gr",u"Lakkíon",1956,37.1333333,26.85 ],
    [ u"gr",u"Lákkoma",1280,40.3833333,23.05 ],
    [ u"gr",u"Lálas",1168,37.7166667,21.7166667 ],
    [ u"gr",u"Lamía",47246,38.9,22.4333333 ],
    [ u"gr",u"Lápas",1377,38.1,21.4166667 ],
    [ u"gr",u"Lárdos",1348,36.1,28.0166667 ],
    [ u"gr",u"Lárimna",1196,38.5666667,23.2833333 ],
    [ u"gr",u"Lárisa",128760,39.6372222,22.4202778 ],
    [ u"gr",u"Lávara",1447,41.2666667,26.3833333 ],
    [ u"gr",u"Layiná",2649,40.7230556,23.0 ],
    [ u"gr",u"Lekhainá",3714,37.9333333,21.2666667 ],
    [ u"gr",u"Lékhaion",4837,37.9333333,22.85 ],
    [ u"gr",u"Lékhovon",1188,40.5833333,21.4833333 ],
    [ u"gr",u"Leonídion",3020,37.1686111,22.8552778 ],
    [ u"gr",u"Lepenoú",2170,38.7,21.2833333 ],
    [ u"gr",u"Lianovéryion",1712,40.6377778,22.5030556 ],
    [ u"gr",u"Liapádes",928,39.6694444,19.7363889 ],
    [ u"gr",u"Lidoríkion",840,38.5238889,22.1997222 ],
    [ u"gr",u"Ligourión",2817,37.6166667,23.0333333 ],
    [ u"gr",u"Líkion",1081,41.05,25.6833333 ],
    [ u"gr",u"Likoporiá",801,38.1333333,22.5166667 ],
    [ u"gr",u"Likóvrisi",9087,38.0666667,23.7833333 ],
    [ u"gr",u"Limenária",2503,40.6333333,24.5833333 ],
    [ u"gr",u"Limín Khersonísou",3103,35.3166667,25.3833333 ],
    [ u"gr",u"Límnai",862,37.7166667,22.8833333 ],
    [ u"gr",u"Límni",2072,38.7666667,23.3166667 ],
    [ u"gr",u"Lithakiá",1300,37.7166667,20.8333333 ],
    [ u"gr",u"Lití",3226,40.7452778,22.9786111 ],
    [ u"gr",u"Litókhoron",6709,40.1005556,22.4977778 ],
    [ u"gr",u"Livaderón",1663,40.0333333,21.9333333 ],
    [ u"gr",u"Livádi",2655,40.125,22.1516667 ],
    [ u"gr",u"Livanátai",3142,38.7166667,23.05 ],
    [ u"gr",u"Lixoúrion",3758,38.2019444,20.4313889 ],
    [ u"gr",u"Lófos",1772,40.2447222,22.3797222 ],
    [ u"gr",u"Longá",983,36.8666667,21.9 ],
    [ u"gr",u"Loudías",981,40.6772222,22.5413889 ],
    [ u"gr",u"Loukísia",1038,38.4833333,23.45 ],
    [ u"gr",u"Loúros",2034,39.1627778,20.7519444 ],
    [ u"gr",u"Loutrá Ipátis",579,38.9,22.2833333 ],
    [ u"gr",u"Loutrákion",12276,37.9833333,22.9666667 ],
    [ u"gr",u"Loutrá",1115,39.0569444,26.545 ],
    [ u"gr",u"Loutrós",984,40.8791667,26.0436111 ],
    [ u"gr",u"Loutrós",1296,40.5883333,22.3994444 ],
    [ u"gr",u"Magoúla",1036,39.4555556,21.8027778 ],
    [ u"gr",u"Magoúla",1552,38.4166667,23.8333333 ],
    [ u"gr",u"Magoúla",4219,38.0833333,23.5166667 ],
    [ u"gr",u"Magoúla",1545,37.0833333,22.4166667 ],
    [ u"gr",u"Makrakómi",2065,38.9333333,22.1166667 ],
    [ u"gr",u"Makrikápa",878,38.6166667,23.75 ],
    [ u"gr",u"Makrikhórion",1835,39.8,22.4833333 ],
    [ u"gr",u"Makrikhórion",1188,39.44,21.9663889 ],
    [ u"gr",u"Makrinítsa",1014,39.4,22.9833333 ],
    [ u"gr",u"Makrísia",1902,37.6166667,21.6 ],
    [ u"gr",u"Makríyialos",2009,40.4163889,22.6027778 ],
    [ u"gr",u"Makrokhórion",4965,40.5513889,22.25 ],
    [ u"gr",u"Malesína",4281,38.6166667,23.2333333 ],
    [ u"gr",u"Mália",4343,35.2833333,25.4666667 ],
    [ u"gr",u"Mándalon",1204,40.8583333,22.2097222 ],
    [ u"gr",u"Mándra",11294,38.0666667,23.5 ],
    [ u"gr",u"Maniákoi",2771,40.5,21.25 ],
    [ u"gr",u"Manolás",1650,38.05,21.35 ],
    [ u"gr",u"Mantamádos",1120,39.3116667,26.3338889 ],
    [ u"gr",u"Mantoúdion",1794,38.8,23.4833333 ],
    [ u"gr",u"Marathókambos",1268,37.7263889,26.69 ],
    [ u"gr",u"Marathón",4051,38.15,23.9666667 ],
    [ u"gr",u"Marathópolis",877,37.0666667,21.5833333 ],
    [ u"gr",u"Marína",1091,40.6961111,22.1008333 ],
    [ u"gr",u"Markópoulon",4214,38.2833333,23.8333333 ],
    [ u"gr",u"Marmárion",1013,38.05,24.3166667 ],
    [ u"gr",u"Mármaron",953,38.5408333,26.1130556 ],
    [ u"gr",u"Martínon",3038,38.5666667,23.2166667 ],
    [ u"gr",u"Megála Kalívia",2092,39.5,21.7875 ],
    [ u"gr",u"Megáli Khóra",1191,38.6333333,21.3666667 ],
    [ u"gr",u"Megáli Panayía",2782,40.45,23.6833333 ],
    [ u"gr",u"Megáli Vrísi",963,38.8833333,22.4833333 ],
    [ u"gr",u"Megalokhórion",741,41.25,23.2166667 ],
    [ u"gr",u"Megalokhórion",1564,39.5594444,21.8408333 ],
    [ u"gr",u"Megalópoli",5283,37.4011111,22.1422222 ],
    [ u"gr",u"Méga Pistón",966,41.15,25.3 ],
    [ u"gr",u"Mégara",24047,38.0,23.3455556 ],
    [ u"gr",u"Meligalás",1431,37.2166667,21.9666667 ],
    [ u"gr",u"Melíki",3033,40.5166667,22.3952778 ],
    [ u"gr",u"Melíssia",22385,38.05,23.8333333 ],
    [ u"gr",u"Melíssion",1024,40.7741667,22.3441667 ],
    [ u"gr",u"Melíssion",864,38.05,22.6833333 ],
    [ u"gr",u"Melissokhórion",2002,40.7666667,22.925 ],
    [ u"gr",u"Melissourgoí",593,39.5094444,21.1466667 ],
    [ u"gr",u"Melíti",1521,40.8333333,21.5833333 ],
    [ u"gr",u"Melívoia",1249,39.75,22.8 ],
    [ u"gr",u"Meneméni",15706,40.6569444,22.9 ],
    [ u"gr",u"Menídion",1110,39.0419444,21.1177778 ],
    [ u"gr",u"Mesariá",1233,36.4,25.45 ],
    [ u"gr",u"Mesimérion",899,40.7905556,22.0222222 ],
    [ u"gr",u"Mesimérion",1491,40.4166667,23.0 ],
    [ u"gr",u"Mesolóngion",12702,38.3691667,21.4291667 ],
    [ u"gr",u"Mesopotamiá",1812,40.5,21.1666667 ],
    [ u"gr",u"Messíni",6773,37.0511111,22.0077778 ],
    [ u"gr",u"Metamórfosis",873,40.2333333,23.6 ],
    [ u"gr",u"Metaxádes",818,41.4219444,26.2252778 ],
    [ u"gr",u"Méthana",1183,37.5833333,23.3833333 ],
    [ u"gr",u"Methóni",973,40.4483333,22.5869444 ],
    [ u"gr",u"Methóni",1166,36.8166667,21.7 ],
    [ u"gr",u"Métsovon",3305,39.7694444,21.1822222 ],
    [ u"gr",u"Míki",1130,41.25,24.9166667 ],
    [ u"gr",u"Míkonos",7739,37.45,25.3333333 ],
    [ u"gr",u"Mikrókambos",1207,40.8386111,22.7697222 ],
    [ u"gr",u"Mikrománi",997,37.0833333,22.0333333 ],
    [ u"gr",u"Mikrón Monastírion",1518,40.7058333,22.5413889 ],
    [ u"gr",u"Mikrópolis",1094,41.2,23.8166667 ],
    [ u"gr",u"Miléai",577,39.3333333,23.15 ],
    [ u"gr",u"Miléa",426,40.2502778,22.2958333 ],
    [ u"gr",u"Milésion",1121,38.2833333,23.8 ],
    [ u"gr",u"Míloi",833,37.55,22.7166667 ],
    [ u"gr",u"Mílos",844,36.75,24.4333333 ],
    [ u"gr",u"Mírina",5406,39.8797222,25.0741667 ],
    [ u"gr",u"Mirsíni",1213,37.9166667,21.2333333 ],
    [ u"gr",u"Míthimna",1558,39.3666667,26.1666667 ],
    [ u"gr",u"Mítikas",934,38.6666667,20.9333333 ],
    [ u"gr",u"Mítikas",1632,38.4333333,23.65 ],
    [ u"gr",u"Mitilíni",28322,39.11,26.5547222 ],
    [ u"gr",u"Mitilinioí",2255,37.7286111,26.9083333 ],
    [ u"gr",u"Mitrópoli",1572,39.3394444,21.8369444 ],
    [ u"gr",u"Moírai",6450,35.05,24.8666667 ],
    [ u"gr",u"Mokhós",1132,35.2666667,25.4166667 ],
    [ u"gr",u"Moláoi",3018,36.8002778,22.8558333 ],
    [ u"gr",u"Mólos",3280,38.8166667,22.65 ],
    [ u"gr",u"Monastirákion",1299,38.85,20.95 ],
    [ u"gr",u"Monóspita",897,40.6172222,22.1769444 ],
    [ u"gr",u"Morfovoúnion",1271,39.3525,21.75 ],
    [ u"gr",u"Mória",1176,39.1333333,26.5166667 ],
    [ u"gr",u"Moskháton",23533,37.95,23.6666667 ],
    [ u"gr",u"Moskhokhórion",763,38.8333333,22.45 ],
    [ u"gr",u"Moúlkion",1316,38.0,22.7333333 ],
    [ u"gr",u"Mouriaí",988,41.2494444,22.7905556 ],
    [ u"gr",u"Mourniés",6879,35.4763889,24.0091667 ],
    [ u"gr",u"Mousthéni",1159,40.8666667,24.1166667 ],
    [ u"gr",u"Mouzákion",2127,39.4297222,21.6636111 ],
    [ u"gr",u"Mouzákion",1545,37.7333333,20.8166667 ],
    [ u"gr",u"Mouzourás",1462,35.5333333,24.15 ],
    [ u"gr",u"Náousa",19887,40.6294444,22.0680556 ],
    [ u"gr",u"Náousa",2596,37.1166667,25.2333333 ],
    [ u"gr",u"Nauplion",14582,37.5636111,22.8075 ],
    [ u"gr",u"Náxos",7574,37.1055556,25.3763889 ],
    [ u"gr",u"Néa Alikarnassós",11886,35.3333333,25.15 ],
    [ u"gr",u"Néa Ankhíalos",5908,39.2833333,22.8166667 ],
    [ u"gr",u"Néa Apollonía",1953,40.6333333,23.45 ],
    [ u"gr",u"Néa Artáki",9193,38.5166667,23.6333333 ],
    [ u"gr",u"Néa Éfesos",2006,40.23,22.4963889 ],
    [ u"gr",u"Néa Erithraía",16432,38.1,23.8166667 ],
    [ u"gr",u"Néa Fókaia",1941,40.1333333,23.4 ],
    [ u"gr",u"Néa Ionía",67835,38.0333333,23.75 ],
    [ u"gr",u"Néa Iraklítsa",1147,40.8644444,24.3158333 ],
    [ u"gr",u"Néa Kallikrátia",7078,40.3166667,23.0666667 ],
    [ u"gr",u"Néa Kariá",1820,40.9075,24.7083333 ],
    [ u"gr",u"Néa Karváli",2380,40.9616667,24.51 ],
    [ u"gr",u"Néa Kerasiá",1300,40.3666667,23.2333333 ],
    [ u"gr",u"Néa Kíos",4214,37.5833333,22.75 ],
    [ u"gr",u"Néa Magnisía",4144,40.6875,22.8469444 ],
    [ u"gr",u"Néa Mákri",14723,38.0833333,23.9833333 ],
    [ u"gr",u"Néa Málgara",2476,40.6094444,22.6816667 ],
    [ u"gr",u"Néa Manolás",2219,38.05,21.3833333 ],
    [ u"gr",u"Néa Mesimvría",2349,40.7513889,22.7625 ],
    [ u"gr",u"Néa Mikhanióna",7908,40.4644444,22.8608333 ],
    [ u"gr",u"Néa Palátia",2400,38.3166667,23.8 ],
    [ u"gr",u"Néa Pélla",1595,40.7661111,22.4855556 ],
    [ u"gr",u"Néa Péramos",2642,40.8388889,24.3036111 ],
    [ u"gr",u"Néa Péramos",7705,38.0,23.4333333 ],
    [ u"gr",u"Néa Pláyia",1332,40.2666667,23.2 ],
    [ u"gr",u"Neápolis",2809,35.2538889,25.6097222 ],
    [ u"gr",u"Néa Sánta",1420,40.8416667,22.9144444 ],
    [ u"gr",u"Néa Smírni",75421,37.95,23.7166667 ],
    [ u"gr",u"Néa Stíra",1061,38.1833333,24.2 ],
    [ u"gr",u"Néa Tírins",1305,37.6,22.8166667 ],
    [ u"gr",u"Néa Tríglia",3028,40.3,23.2 ],
    [ u"gr",u"Néa Víssa",2673,41.5833333,26.5333333 ],
    [ u"gr",u"Néa Zíkhni",2400,41.0330556,23.8297222 ],
    [ u"gr",u"Neméa",4344,37.8166667,22.6666667 ],
    [ u"gr",u"Nénita",1032,38.2388889,26.0930556 ],
    [ u"gr",u"Néoi Epivátai",5077,40.5002778,22.9111111 ],
    [ u"gr",u"Neokaisária",805,39.5866667,20.8777778 ],
    [ u"gr",u"Neokhórion",1160,41.5166667,26.45 ],
    [ u"gr",u"Neokhórion",1189,41.1833333,23.25 ],
    [ u"gr",u"Neokhórion",2103,39.0694444,21.0188889 ],
    [ u"gr",u"Neokhórion",1121,39.2769444,21.7330556 ],
    [ u"gr",u"Neokhórion",3116,38.4166667,21.2833333 ],
    [ u"gr",u"Neokhórion",1105,37.9166667,21.2 ],
    [ u"gr",u"Neokhorópoulon",1088,39.6286111,20.8341667 ],
    [ u"gr",u"Néon Ayionérion",1649,40.8086111,22.7002778 ],
    [ u"gr",u"Néon Karlovásion",5925,37.7902778,26.7044444 ],
    [ u"gr",u"Néon Monastírion",1497,39.2333333,22.25 ],
    [ u"gr",u"Néon Petrítsion",2322,41.2833333,23.3 ],
    [ u"gr",u"Néon Rísion",3012,40.4966667,22.9886111 ],
    [ u"gr",u"Néon Soúlion",2725,41.1,23.65 ],
    [ u"gr",u"Néos Marmarás",3013,40.1,23.7833333 ],
    [ u"gr",u"Néos Milótopos",2835,40.8163889,22.3463889 ],
    [ u"gr",u"Néos Oropós",1375,39.1513889,20.7366667 ],
    [ u"gr",u"Néos Pírgos",932,41.5,26.5 ],
    [ u"gr",u"Néos Pírgos",890,38.9333333,23.0666667 ],
    [ u"gr",u"Néos Skopós",2560,41.0166667,23.6166667 ],
    [ u"gr",u"Nerokoúros",4388,35.4833333,24.0333333 ],
    [ u"gr",u"Nestórion",884,40.4127778,21.0622222 ],
    [ u"gr",u"Nigríta",5320,40.9052778,23.4994444 ],
    [ u"gr",u"Níkaia",3274,39.5666667,22.4666667 ],
    [ u"gr",u"Níkaia",94608,37.9666667,23.65 ],
    [ u"gr",u"Nikísiani",2454,40.95,24.15 ],
    [ u"gr",u"Nikóklia",1502,40.9333333,23.4333333 ],
    [ u"gr",u"Nisíon",1473,40.6369444,22.3877778 ],
    [ u"gr",u"Oía",934,36.4666667,25.3666667 ],
    [ u"gr",u"Oinófita",2971,38.3166667,23.6333333 ],
    [ u"gr",u"Oinóï",898,38.1666667,23.4166667 ],
    [ u"gr",u"Oinoússai",1182,38.5141667,26.2202778 ],
    [ u"gr",u"Ólinthos",1155,40.2833333,23.35 ],
    [ u"gr",u"Omvriakí",1213,39.1,22.2666667 ],
    [ u"gr",u"Oraiókastron",15006,40.7308333,22.9172222 ],
    [ u"gr",u"Oreoí",1293,38.95,23.1 ],
    [ u"gr",u"Orestiás",16221,41.5030556,26.5297222 ],
    [ u"gr",u"Orkhomenós",5920,38.5,22.9833333 ],
    [ u"gr",u"Orménion",750,41.7191667,26.2144444 ],
    [ u"gr",u"Ormília",3436,40.3,23.55 ],
    [ u"gr",u"Órmos Korthíou",903,37.7666667,24.95 ],
    [ u"gr",u"Othonoí",761,39.8436111,19.4097222 ],
    [ u"gr",u"Ouranópolis",1047,40.3333333,23.9833333 ],
    [ u"gr",u"Ovriá",5838,38.1833333,21.7166667 ],
    [ u"gr",u"Oxílithos",1062,38.5833333,24.1166667 ],
    [ u"gr",u"Pagóndas",695,37.6727778,26.8319444 ],
    [ u"gr",u"Pagoúria",843,41.0333333,25.3166667 ],
    [ u"gr",u"Paianía",14246,37.95,23.85 ],
    [ u"gr",u"Pákhni",1110,41.3,24.9 ],
    [ u"gr",u"Palaiá Fókaia",2824,37.7166667,23.95 ],
    [ u"gr",u"Palaífiton",1475,40.7816667,22.2661111 ],
    [ u"gr",u"Palaíkastron",1094,35.2,26.25 ],
    [ u"gr",u"Palaiokhóra",923,40.5,23.45 ],
    [ u"gr",u"Palaiokhóra",2372,35.2333333,23.6833333 ],
    [ u"gr",u"Palaiokhórion",1607,40.95,24.1833333 ],
    [ u"gr",u"Palaiokhórion",1474,40.5,23.65 ],
    [ u"gr",u"Palaiókipos",1184,39.0558333,26.4511111 ],
    [ u"gr",u"Palaiokómi",1862,40.8666667,23.9 ],
    [ u"gr",u"Palaiománina",855,38.55,21.2333333 ],
    [ u"gr",u"Palaiomonástiron",1182,39.4625,21.6586111 ],
    [ u"gr",u"Palaión Ayionérion",997,40.8133333,22.7216667 ],
    [ u"gr",u"Palaión Fáliron",66292,37.9333333,23.7 ],
    [ u"gr",u"Palaiópirgos",1035,39.6072222,21.8172222 ],
    [ u"gr",u"Pálairos",2589,38.7833333,20.8833333 ],
    [ u"gr",u"Palamás",5719,39.4666667,22.0833333 ],
    [ u"gr",u"Paliámbela",996,38.9166667,20.95 ],
    [ u"gr",u"Pallíni",14808,38.0,23.8833333 ],
    [ u"gr",u"Pámfila",1251,39.1566667,26.5216667 ],
    [ u"gr",u"Panaitólion",2915,38.5833333,21.45 ],
    [ u"gr",u"Panórama",16551,40.5833333,23.0333333 ],
    [ u"gr",u"Pánormos",1157,35.4166667,24.7 ],
    [ u"gr",u"Papágos",12903,37.9833333,23.8166667 ],
    [ u"gr",u"Pappadátai",1313,39.3133333,20.7925 ],
    [ u"gr",u"Pappádos",1534,39.0394444,26.4547222 ],
    [ u"gr",u"Pappayiánnis",1055,40.8333333,21.5 ],
    [ u"gr",u"Parákoila",881,39.1666667,26.1333333 ],
    [ u"gr",u"Paralía",1801,40.2680556,22.5952778 ],
    [ u"gr",u"Paralía",804,38.3833333,23.6333333 ],
    [ u"gr",u"Paralía",7299,38.2,21.7 ],
    [ u"gr",u"Parálion Ástros",827,37.4166667,22.7666667 ],
    [ u"gr",u"Paramithiá",2569,39.4711111,20.5111111 ],
    [ u"gr",u"Parapótamos",1126,39.5491667,20.3227778 ],
    [ u"gr",u"Paravóla",1215,38.6166667,21.5166667 ],
    [ u"gr",u"Párga",2379,39.2830556,20.3963889 ],
    [ u"gr",u"Páros",5289,37.0833333,25.15 ],
    [ u"gr",u"Pásion",1150,38.0166667,22.7333333 ],
    [ u"gr",u"Patitírion",1647,39.15,23.8666667 ],
    [ u"gr",u"Pátrai",163361,38.2444444,21.7344444 ],
    [ u"gr",u"Patrís",1330,40.5611111,22.1861111 ],
    [ u"gr",u"Pediní",2128,39.5997222,20.8433333 ],
    [ u"gr",u"Pedinón",1133,40.9088889,22.8666667 ],
    [ u"gr",u"Pelasyía",1586,38.95,22.8333333 ],
    [ u"gr",u"Pélla",2476,40.76,22.5191667 ],
    [ u"gr",u"Pelópion",1073,37.6833333,21.5833333 ],
    [ u"gr",u"Pentálofos",2107,40.7416667,22.8519444 ],
    [ u"gr",u"Pentaplátanon",1015,40.8166667,22.4086111 ],
    [ u"gr",u"Pentápolis",1607,41.05,23.6833333 ],
    [ u"gr",u"Péplos",1037,40.9583333,26.2655556 ],
    [ u"gr",u"Peraía",16067,40.5002778,22.925 ],
    [ u"gr",u"Perakhóra",1246,38.0333333,22.95 ],
    [ u"gr",u"Pérama",3066,39.6952778,20.8486111 ],
    [ u"gr",u"Pérama",26288,37.9680556,23.565 ],
    [ u"gr",u"Pérama",1655,35.3697222,24.6972222 ],
    [ u"gr",u"Pérdika",1875,39.3688889,20.3038889 ],
    [ u"gr",u"Perístasis",2454,40.2741667,22.5411111 ],
    [ u"gr",u"Peristerá",1137,40.55,23.1666667 ],
    [ u"gr",u"Peristérion",137660,38.0166667,23.7 ],
    [ u"gr",u"Perivólia",3320,35.4833333,23.9833333 ],
    [ u"gr",u"Perivólion",1432,39.4205556,20.0147222 ],
    [ u"gr",u"Periyiálion",2042,37.95,22.8333333 ],
    [ u"gr",u"Pérni",913,41.0,24.6333333 ],
    [ u"gr",u"Péta",1952,39.1666667,21.0347222 ],
    [ u"gr",u"Petinós",1014,41.1,24.9 ],
    [ u"gr",u"Petraía",939,40.7208333,22.1444444 ],
    [ u"gr",u"Pétra",1299,39.3333333,26.1833333 ],
    [ u"gr",u"Petrokhórion",1052,41.1166667,24.8333333 ],
    [ u"gr",u"Petrotón",842,39.5861111,21.9630556 ],
    [ u"gr",u"Petroússa",1985,41.2,24.0166667 ],
    [ u"gr",u"Pigaí",1037,40.9041667,24.6708333 ],
    [ u"gr",u"Pikérmion",1385,38.0,23.95 ],
    [ u"gr",u"Pilaía",23494,40.6005556,22.9875 ],
    [ u"gr",u"Pilíon",2430,36.8477778,27.1613889 ],
    [ u"gr",u"Píli",1791,39.4580556,21.6188889 ],
    [ u"gr",u"Pílos",2135,36.91,21.6986111 ],
    [ u"gr",u"Pírgos",22402,37.6833333,21.45 ],
    [ u"gr",u"Pírgos",1134,35.0,25.15 ],
    [ u"gr",u"Piryetós",1681,39.9186111,22.5927778 ],
    [ u"gr",u"Piryíon",1002,38.2258333,25.9952778 ],
    [ u"gr",u"Pithárion",1302,35.5166667,24.0833333 ],
    [ u"gr",u"Piyí",1158,39.5119444,21.7011111 ],
    [ u"gr",u"Plános",1033,37.8166667,20.85 ],
    [ u"gr",u"Plataiaí",919,38.2166667,23.2666667 ],
    [ u"gr",u"Plátanos",745,40.5647222,22.5494444 ],
    [ u"gr",u"Plátanos",1764,37.6666667,21.6166667 ],
    [ u"gr",u"Plátanos",1077,35.4666667,23.6 ],
    [ u"gr",u"Platariá",1044,39.4525,20.2761111 ],
    [ u"gr",u"Platíkambos",1889,39.6166667,22.5333333 ],
    [ u"gr",u"Platí",2228,40.6402778,22.5338889 ],
    [ u"gr",u"Playiá",939,38.8,20.7666667 ],
    [ u"gr",u"Playiárion",4561,40.4741667,22.9572222 ],
    [ u"gr",u"Plomárion",3338,38.9766667,26.3680556 ],
    [ u"gr",u"Polikárpion",1045,40.9272222,22.0136111 ],
    [ u"gr",u"Políkastron",6961,40.9936111,22.5658333 ],
    [ u"gr",u"Políkhni",39765,40.6616667,22.9463889 ],
    [ u"gr",u"Polikhnítos",2667,39.0811111,26.1833333 ],
    [ u"gr",u"Políkhronon",1174,40.0166667,23.5333333 ],
    [ u"gr",u"Poliplátanos",892,40.6825,22.1913889 ],
    [ u"gr",u"Politiká",1499,38.6,23.55 ],
    [ u"gr",u"Políyiros",5258,40.3744444,23.4383333 ],
    [ u"gr",u"Pómbia",953,35.0166667,24.8666667 ],
    [ u"gr",u"Póros",1059,38.15,20.7833333 ],
    [ u"gr",u"Póros",4454,37.4994444,23.4536111 ],
    [ u"gr",u"Portariá",1468,40.2833333,23.3 ],
    [ u"gr",u"Portariá",1429,39.3833333,23.0 ],
    [ u"gr",u"Portokhélion",2219,37.3166667,23.15 ],
    [ u"gr",u"Potamiá",1260,40.7166667,24.7333333 ],
    [ u"gr",u"Potamós",2556,39.625,19.8755556 ],
    [ u"gr",u"Prámanta",1570,39.5230556,21.1013889 ],
    [ u"gr",u"Préveza",17283,38.95,20.75 ],
    [ u"gr",u"Prínos",1174,40.7333333,24.6166667 ],
    [ u"gr",u"Proástion",1766,39.4886111,21.9025 ],
    [ u"gr",u"Pródromos",994,39.3752778,21.9752778 ],
    [ u"gr",u"Profítis Ilías",1225,40.8127778,22.1569444 ],
    [ u"gr",u"Profítis Ilías",1482,35.2,25.1 ],
    [ u"gr",u"Profítis",963,40.6833333,23.2833333 ],
    [ u"gr",u"Prókhoma",1422,40.7969444,22.6583333 ],
    [ u"gr",u"Prokópion",1108,38.7333333,23.4833333 ],
    [ u"gr",u"Prómakhoi",1809,41.0252778,22.0 ],
    [ u"gr",u"Prosotsáni",4021,41.1833333,23.9666667 ],
    [ u"gr",u"Próti",1783,40.95,24.0 ],
    [ u"gr",u"Provatás",1275,41.0666667,23.3833333 ],
    [ u"gr",u"Provatón",766,41.0225,26.2583333 ],
    [ u"gr",u"Psakhná",5828,38.5833333,23.6333333 ],
    [ u"gr",u"Psikhikón",1142,41.0,23.6333333 ],
    [ u"gr",u"Psikhikón",10995,38.0166667,23.7666667 ],
    [ u"gr",u"Pteleós",1349,39.05,22.95 ],
    [ u"gr",u"Ptolemais",30045,40.5147222,21.6786111 ],
    [ u"gr",u"Rafína",12745,38.0166667,24.0 ],
    [ u"gr",u"Rapsáni",909,39.9022222,22.5488889 ],
    [ u"gr",u"Rentína",828,39.0638889,21.9752778 ],
    [ u"gr",u"Réthimnon",29907,35.3647222,24.4713889 ],
    [ u"gr",u"Ríon",6084,38.3,21.7833333 ],
    [ u"gr",u"Ritíni",1711,40.2869444,22.2808333 ],
    [ u"gr",u"Rizárion",1098,40.7872222,22.0838889 ],
    [ u"gr",u"Rizarión",821,39.5383333,21.7997222 ],
    [ u"gr",u"Rízia",1645,41.6166667,26.4333333 ],
    [ u"gr",u"Rízoma",1410,39.665,21.735 ],
    [ u"gr",u"Rizómata",1157,40.3472222,22.2036111 ],
    [ u"gr",u"Rizómilos",1594,39.4333333,22.75 ],
    [ u"gr",u"Rizón",1106,40.7338889,22.1358333 ],
    [ u"gr",u"Rodópolis",1250,41.2577778,22.9983333 ],
    [ u"gr",u"Ródos",56128,36.4408333,28.2225 ],
    [ u"gr",u"Rodotópion",1130,39.7083333,20.7258333 ],
    [ u"gr",u"Roviaí",1206,38.8166667,23.2333333 ],
    [ u"gr",u"Royítika",1206,38.1833333,21.6833333 ],
    [ u"gr",u"Salamís",26964,37.9666667,23.4833333 ],
    [ u"gr",u"Samarína",839,40.1013889,21.0152778 ],
    [ u"gr",u"Sámi",1347,38.2541667,20.6513889 ],
    [ u"gr",u"Sámos",6389,37.7572222,26.9769444 ],
    [ u"gr",u"Sápai",4506,41.0286111,25.6930556 ],
    [ u"gr",u"Sardínia",1064,38.8833333,21.2 ],
    [ u"gr",u"Sárti",1258,40.1,23.9833333 ],
    [ u"gr",u"Savália",1339,37.8166667,21.2833333 ],
    [ u"gr",u"Séleron",1811,41.1333333,25.0 ],
    [ u"gr",u"Selianítika",1210,38.2833333,22.0333333 ],
    [ u"gr",u"Selínia",2331,37.9336111,23.5336111 ],
    [ u"gr",u"Sérrai",55886,41.0855556,23.5497222 ],
    [ u"gr",u"Sérvia",3390,40.1797222,21.9944444 ],
    [ u"gr",u"Sevastianá",1561,40.7680556,22.1202778 ],
    [ u"gr",u"Sevastí",842,40.3586111,22.5438889 ],
    [ u"gr",u"Siátista",5612,40.2619444,21.5441667 ],
    [ u"gr",u"Sidirókastron",5825,41.2347222,23.3866667 ],
    [ u"gr",u"Sikéai",44955,40.6494444,22.9508333 ],
    [ u"gr",u"Sikéa",2336,40.0333333,23.9333333 ],
    [ u"gr",u"Sikéa",1031,36.7666667,22.9333333 ],
    [ u"gr",u"Sikión",1131,37.9833333,22.7333333 ],
    [ u"gr",u"Sikoúrion",2318,39.7583333,22.5786111 ],
    [ u"gr",u"Silivainiótika",1595,38.1666667,22.3333333 ],
    [ u"gr",u"Sími",2508,36.6133333,27.8408333 ],
    [ u"gr",u"Sinarádes",1150,39.5647222,19.8458333 ],
    [ u"gr",u"Síndos",8228,40.6697222,22.8047222 ],
    [ u"gr",u"Sisamía",1168,40.95,23.4166667 ],
    [ u"gr",u"Sísion",875,35.3,25.5166667 ],
    [ u"gr",u"Sitagroí",1105,41.1166667,24.0333333 ],
    [ u"gr",u"Sitía",8707,35.2,26.0986111 ],
    [ u"gr",u"Sívota",973,39.4066667,20.25 ],
    [ u"gr",u"Skála Foúrkas",853,40.0,23.3833333 ],
    [ u"gr",u"Skalánion",1012,35.2833333,25.1833333 ],
    [ u"gr",u"Skála Oropoú",1284,38.3333333,23.7833333 ],
    [ u"gr",u"Skála",2817,36.85,22.6666667 ],
    [ u"gr",u"Skála",1849,37.3166667,26.5333333 ],
    [ u"gr",u"Skhimatárion",5007,38.35,23.5833333 ],
    [ u"gr",u"Skhísma",1968,35.2666667,25.7166667 ],
    [ u"gr",u"Skíathos",5187,39.1666667,23.4833333 ],
    [ u"gr",u"Skíros",1732,38.9041667,24.5630556 ],
    [ u"gr",u"Skópelos",2886,39.1247222,23.7247222 ],
    [ u"gr",u"Skópelos",1728,39.0297222,26.4483333 ],
    [ u"gr",u"Skotína",953,39.9936111,22.5341667 ],
    [ u"gr",u"Skotoússa",1371,41.1333333,23.3833333 ],
    [ u"gr",u"Skoúrta",982,38.2166667,23.55 ],
    [ u"gr",u"Skoútari",2690,41.0166667,23.5166667 ],
    [ u"gr",u"Skoutáros",952,39.3,26.1333333 ],
    [ u"gr",u"Sofikón",1799,37.8,23.05 ],
    [ u"gr",u"Sokhós",2748,40.8166667,23.35 ],
    [ u"gr",u"Sosándra",1217,40.9983333,22.0294444 ],
    [ u"gr",u"Soúda",6729,35.4844444,24.0744444 ],
    [ u"gr",u"Souflíon",4149,41.1919444,26.2994444 ],
    [ u"gr",u"Sourotí",1048,40.4666667,23.0833333 ],
    [ u"gr",u"Soúrpi",2137,39.1,22.9 ],
    [ u"gr",u"Sozópolis",925,40.2833333,23.15 ],
    [ u"gr",u"Spárta",801,38.0333333,23.1666667 ],
    [ u"gr",u"Spárti",15497,37.0733333,22.4297222 ],
    [ u"gr",u"Spáta",8137,37.9666667,23.9166667 ],
    [ u"gr",u"Sperkhiás",2844,38.9,22.1166667 ],
    [ u"gr",u"Sperkhóyia",1004,37.0666667,22.0666667 ],
    [ u"gr",u"Spétsai",3972,37.2666667,23.15 ],
    [ u"gr",u"Spoláïta",632,38.7,21.35 ],
    [ u"gr",u"Stalís",1182,35.3,25.4333333 ],
    [ u"gr",u"Stamáta",2904,38.1333333,23.8833333 ],
    [ u"gr",u"Stamná",921,38.5166667,21.2833333 ],
    [ u"gr",u"Stános",1132,38.8,21.1666667 ],
    [ u"gr",u"Stefanovíkion",2016,39.4666667,22.7333333 ],
    [ u"gr",u"Stérnai",836,35.5166667,24.15 ],
    [ u"gr",u"Stérna",815,41.5666667,26.45 ],
    [ u"gr",u"Stilís",5132,38.9166667,22.6166667 ],
    [ u"gr",u"Stípsi",1020,39.3116667,26.2197222 ],
    [ u"gr",u"Stírion",1056,38.4,22.7166667 ],
    [ u"gr",u"Stournaraíïka",537,39.4516667,21.4905556 ],
    [ u"gr",u"Stratónion",1150,40.5166667,23.8333333 ],
    [ u"gr",u"Strátos",1110,38.6666667,21.3166667 ],
    [ u"gr",u"Strimonikón",1869,41.05,23.3166667 ],
    [ u"gr",u"Svorónos",2066,40.2644444,22.46 ],
    [ u"gr",u"Taxiárkhis",1055,40.4333333,23.5166667 ],
    [ u"gr",u"Témeni",1125,38.2333333,22.1166667 ],
    [ u"gr",u"Terpní",2132,40.9166667,23.4833333 ],
    [ u"gr",u"Terpsithéa",1308,39.6166667,22.3666667 ],
    [ u"gr",u"Thásos",3339,40.77,24.7238889 ],
    [ u"gr",u"Theodóriana",999,39.4341667,21.2086111 ],
    [ u"gr",u"Theológos",655,40.6666667,24.7 ],
    [ u"gr",u"Thérmi",14373,40.55,23.0166667 ],
    [ u"gr",u"Thérmon",1958,38.5833333,21.6666667 ],
    [ u"gr",u"Thespiaí",1437,38.3,23.15 ],
    [ u"gr",u"Thesprotikón",1718,39.25,20.7847222 ],
    [ u"gr",u"Thessaloníki",354291,40.6402778,22.9438889 ],
    [ u"gr",u"Thimianá",1483,38.315,26.1336111 ],
    [ u"gr",u"Thíra",2376,36.4166667,25.4333333 ],
    [ u"gr",u"Thírion",753,38.8666667,20.9833333 ],
    [ u"gr",u"Thívai",22028,38.325,23.3188889 ],
    [ u"gr",u"Tholós",854,41.0,23.7833333 ],
    [ u"gr",u"Thouría",1302,37.0833333,22.05 ],
    [ u"gr",u"Thrapsanón",1499,35.1833333,25.2833333 ],
    [ u"gr",u"Tikherón",2029,41.0333333,26.2833333 ],
    [ u"gr",u"Tílisos",1026,35.3,25.0166667 ],
    [ u"gr",u"Timbákion",4923,35.0666667,24.7666667 ],
    [ u"gr",u"Tínos",4573,37.5333333,25.1666667 ],
    [ u"gr",u"Tírnavos",10797,39.7377778,22.2891667 ],
    [ u"gr",u"Tithoréa",865,38.5833333,22.6666667 ],
    [ u"gr",u"Tolón",2322,37.5166667,22.85 ],
    [ u"gr",u"Toúmba",947,41.0166667,23.7 ],
    [ u"gr",u"Toúmba",993,40.9322222,22.5375 ],
    [ u"gr",u"Tragána",1320,38.6166667,23.1166667 ],
    [ u"gr",u"Traganón",2414,37.8833333,21.3166667 ],
    [ u"gr",u"Triandría",11082,40.6227778,22.9711111 ],
    [ u"gr",u"Trífos",708,38.8333333,21.0666667 ],
    [ u"gr",u"Tríkala",1704,40.5980556,22.5566667 ],
    [ u"gr",u"Tríkala",49810,39.5552778,21.7675 ],
    [ u"gr",u"Tríkerion",1182,39.1,23.0833333 ],
    [ u"gr",u"Trílofon",4362,40.4672222,22.9694444 ],
    [ u"gr",u"Trípoli",26562,37.5088889,22.3794444 ],
    [ u"gr",u"Tsákoi",1004,40.9586111,22.0363889 ],
    [ u"gr",u"Tsarítsani",2514,39.8833333,22.2333333 ],
    [ u"gr",u"Tsikalariá",1204,35.4833333,24.0666667 ],
    [ u"gr",u"Tsotílion",1695,40.2666667,21.3166667 ],
    [ u"gr",u"Tzermiádon",682,35.2036111,25.4847222 ],
    [ u"gr",u"Valíra",991,37.1666667,21.9833333 ],
    [ u"gr",u"Valsamáta",1008,38.1666667,20.6 ],
    [ u"gr",u"Valterón",1285,41.1833333,23.3166667 ],
    [ u"gr",u"Valtotópion",1106,41.0,23.6 ],
    [ u"gr",u"Vamvakófiton",1161,41.1833333,23.4 ],
    [ u"gr",u"Vamvakoú",1104,39.3333333,22.4166667 ],
    [ u"gr",u"Vanáton",944,37.8,20.85 ],
    [ u"gr",u"Várda",3307,38.0333333,21.3666667 ],
    [ u"gr",u"Variá",1518,39.0833333,26.5666667 ],
    [ u"gr",u"Vári",12090,37.8333333,23.8 ],
    [ u"gr",u"Vári",1266,37.4,24.95 ],
    [ u"gr",u"Varnávas",1516,38.2166667,23.9166667 ],
    [ u"gr",u"Vartholomió",3068,37.8666667,21.2 ],
    [ u"gr",u"Varvásaina",1280,37.6833333,21.5 ],
    [ u"gr",u"Vasilíai",984,35.2666667,25.1333333 ],
    [ u"gr",u"Vasiliká",4519,40.4666667,23.1333333 ],
    [ u"gr",u"Vasilikí",1388,39.6388889,21.7047222 ],
    [ u"gr",u"Vasilikón",7039,38.4333333,23.6666667 ],
    [ u"gr",u"Vathílakkos",2218,40.7694444,22.7016667 ],
    [ u"gr",u"Vathí",2575,38.4,23.6 ],
    [ u"gr",u"Vathí",1615,37.7666667,23.4833333 ],
    [ u"gr",u"Vathí",1885,37.75,26.9833333 ],
    [ u"gr",u"Váyia",4535,38.3166667,23.1833333 ],
    [ u"gr",u"Velestínon",3211,39.3833333,22.75 ],
    [ u"gr",u"Vélon",3018,37.9666667,22.7666667 ],
    [ u"gr",u"Velventós",3378,40.2516667,22.0630556 ],
    [ u"gr",u"Veneráton",938,35.2,25.0333333 ],
    [ u"gr",u"Verdikoússa",1603,39.7802778,21.9722222 ],
    [ u"gr",u"Véroia",44465,40.5233333,22.2036111 ],
    [ u"gr",u"Veryína",1242,40.4811111,22.3136111 ],
    [ u"gr",u"Véryi",1382,40.95,23.4 ],
    [ u"gr",u"Vília",1967,38.1666667,23.3333333 ],
    [ u"gr",u"Virónia",858,41.2833333,23.2333333 ],
    [ u"gr",u"Víron",61888,37.9666667,23.75 ],
    [ u"gr",u"Virós",1057,39.5838889,19.8819444 ],
    [ u"gr",u"Vitína",906,37.6666667,22.1833333 ],
    [ u"gr",u"Vlakhiótis",2404,36.8666667,22.7 ],
    [ u"gr",u"Vlakhokeraséa",773,37.3666667,22.3833333 ],
    [ u"gr",u"Vlakhópoulon",1446,37.0333333,21.7833333 ],
    [ u"gr",u"Vlakhoyiánnion",855,39.75,22.0833333 ],
    [ u"gr",u"Vokhaïkón",961,37.95,22.8 ],
    [ u"gr",u"Vólax",1225,41.3166667,24.0 ],
    [ u"gr",u"Vólos",84427,39.3666667,22.9458333 ],
    [ u"gr",u"Vónitsa",3770,38.9163889,20.8863889 ],
    [ u"gr",u"Voúla",29033,37.85,23.7666667 ],
    [ u"gr",u"Vouliagméni",7717,37.8166667,23.7833333 ],
    [ u"gr",u"Vrakhátion",3252,37.9666667,22.8166667 ],
    [ u"gr",u"Vrakhnaíika",2780,38.1666667,21.6666667 ],
    [ u"gr",u"Vrína",860,37.5666667,21.6333333 ],
    [ u"gr",u"Vríses",982,35.3833333,24.2 ],
    [ u"gr",u"Vrontádos",4600,38.4088889,26.1327778 ],
    [ u"gr",u"Vrontoú",2196,40.1922222,22.4327778 ],
    [ u"gr",u"Xánthi",48221,41.1413889,24.8836111 ],
    [ u"gr",u"Xilaganí",1445,40.9833333,25.4166667 ],
    [ u"gr",u"Xilókastron",5256,38.0833333,22.6333333 ],
    [ u"gr",u"Xilópolis",1442,40.9333333,23.1833333 ],
    [ u"gr",u"Xinón Nerón",1176,40.6833333,21.6166667 ],
    [ u"gr",u"Xirokámbion",995,36.9666667,22.45 ],
    [ u"gr",u"Xirókambos",879,37.1,26.8666667 ],
    [ u"gr",u"Xiropótamos",2670,41.2,24.1 ],
    [ u"gr",u"Yéfira",3451,40.7333333,22.6922222 ],
    [ u"gr",u"Yéfira",1465,36.6833333,23.0333333 ],
    [ u"gr",u"Yeniséa",1935,41.0666667,24.9666667 ],
    [ u"gr",u"Yeoryianí",642,40.95,24.15 ],
    [ u"gr",u"Yerakaroú",1308,40.6333333,23.2166667 ],
    [ u"gr",u"Yerákion",1323,37.0,22.7 ],
    [ u"gr",u"Yeráni",804,35.35,24.4 ],
    [ u"gr",u"Yéryeri",1444,35.1333333,24.95 ],
    [ u"gr",u"Yialós",873,35.2333333,23.6333333 ],
    [ u"gr",u"Yiannitsá",27818,40.7919444,22.4075 ],
    [ u"gr",u"Yiánnouli",7031,39.6666667,22.3833333 ],
    [ u"gr",u"Yimnón",2041,38.4333333,23.8833333 ],
    [ u"gr",u"Yíthion",4576,36.755,22.5641667 ],
    [ u"gr",u"Zagorá",2385,39.45,23.1 ],
    [ u"gr",u"Zakháro",5894,37.4833333,21.65 ],
    [ u"gr",u"Zákinthos",11540,37.7913889,20.8952778 ],
    [ u"gr",u"Zárakes",936,38.3,24.2 ],
    [ u"gr",u"Zárkos",1407,39.6166667,22.1333333 ],
    [ u"gr",u"Zarós",2205,35.1333333,24.9 ],
    [ u"gr",u"Zélion",868,38.6666667,22.8833333 ],
    [ u"gr",u"Zigós",1504,41.0166667,24.3833333 ],
    [ u"gr",u"Zipárion",2706,36.875,27.2041667 ],
    [ u"gr",u"Zítsa",914,39.7530556,20.6486111 ],
    [ u"gr",u"Zonianá",1703,35.3,24.8333333 ],
    [ u"gt",u"Acatenango",6905,14.551944,-90.942222 ],
    [ u"gt",u"Agua Blanca",2719,14.5,-89.65 ],
    [ u"gt",u"Aguacatán",5457,15.343056,-91.311667 ],
    [ u"gt",u"Almolonga",11668,14.816667,-91.5 ],
    [ u"gt",u"Alotenango",17052,14.480278,-90.8075 ],
    [ u"gt",u"Amatitlán",70357,14.4875,-90.615278 ],
    [ u"gt",u"Antigua Guatemala",38560,14.561111,-90.734444 ],
    [ u"gt",u"Asunción Mita",15287,14.330833,-89.710833 ],
    [ u"gt",u"Atescatempa",11306,14.174444,-89.7425 ],
    [ u"gt",u"Ayutla",11197,14.666667,-92.15 ],
    [ u"gt",u"Barberena",29861,14.309444,-90.361111 ],
    [ u"gt",u"Barillas",13810,15.803611,-91.315833 ],
    [ u"gt",u"Cabañas",4582,14.933333,-89.8 ],
    [ u"gt",u"Cabricán",11663,15.133333,-91.616667 ],
    [ u"gt",u"Cahabón",4575,15.566667,-89.816667 ],
    [ u"gt",u"Cajolá",2867,14.916667,-91.616667 ],
    [ u"gt",u"Camotán",1565,14.816667,-89.366667 ],
    [ u"gt",u"Canillá",1663,15.166667,-90.85 ],
    [ u"gt",u"Cantel",25485,14.816667,-91.45 ],
    [ u"gt",u"Casillas",8786,14.422222,-90.244167 ],
    [ u"gt",u"Catarina",2977,14.85,-92.083333 ],
    [ u"gt",u"Chahal",5100,15.75,-89.566667 ],
    [ u"gt",u"Chajul",11416,15.485278,-91.034167 ],
    [ u"gt",u"Champerico",7602,14.3,-91.916667 ],
    [ u"gt",u"Chiantla",8290,15.354722,-91.458333 ],
    [ u"gt",u"Chicacao",20006,14.533333,-91.316667 ],
    [ u"gt",u"Chicamán",2046,15.4,-90.766667 ],
    [ u"gt",u"Chiché",2357,15.008611,-91.065 ],
    [ u"gt",u"Chichicastenango",77861,14.933333,-91.116667 ],
    [ u"gt",u"Chimaltenango",80680,14.668611,-90.816667 ],
    [ u"gt",u"Chinautla",94508,14.708333,-90.499444 ],
    [ u"gt",u"Chinique",2637,15.044722,-91.025833 ],
    [ u"gt",u"Chiquimula",40669,14.8,-89.55 ],
    [ u"gt",u"Chiquimulilla",12578,14.085833,-90.376667 ],
    [ u"gt",u"Chisec",12038,15.816667,-90.283333 ],
    [ u"gt",u"Chuarrancho",7001,14.821667,-90.508611 ],
    [ u"gt",u"Ciudad Vieja",29584,14.526389,-90.759722 ],
    [ u"gt",u"Cobán",46726,15.483333,-90.366667 ],
    [ u"gt",u"Colomba",18722,14.716667,-91.733333 ],
    [ u"gt",u"Colotenango",1656,15.416667,-91.716667 ],
    [ u"gt",u"Comalapa",20311,14.741111,-90.8875 ],
    [ u"gt",u"Comapa",1462,14.116667,-89.916667 ],
    [ u"gt",u"Comitancillo",19203,15.083333,-91.716667 ],
    [ u"gt",u"Concepción Chiquirichapa",7914,14.85,-91.616667 ],
    [ u"gt",u"Concepción",8741,15.616667,-91.683333 ],
    [ u"gt",u"Concepción",3224,14.783333,-91.15 ],
    [ u"gt",u"Concepción Tutuapa",1147,15.283333,-91.783333 ],
    [ u"gt",u"Conguaco",3345,14.044167,-90.031111 ],
    [ u"gt",u"Cubulco",10073,15.133333,-90.583333 ],
    [ u"gt",u"Cuilapa",16484,14.276389,-90.300278 ],
    [ u"gt",u"Cuilco",1677,15.4,-91.966667 ],
    [ u"gt",u"Cunén",8227,15.3375,-91.026944 ],
    [ u"gt",u"Cuyotenango",10602,14.533333,-91.566667 ],
    [ u"gt",u"Dolores",10385,16.514167,-89.415833 ],
    [ u"gt",u"El Adelanto",1923,14.166667,-89.833333 ],
    [ u"gt",u"El Asintal",6018,14.6,-91.733333 ],
    [ u"gt",u"El Chol",2480,14.964167,-90.480556 ],
    [ u"gt",u"El Estor",15516,15.533333,-89.35 ],
    [ u"gt",u"El Jícaro",4155,14.866667,-90.266667 ],
    [ u"gt",u"El Palmar",14828,14.65,-91.583333 ],
    [ u"gt",u"El Progreso",7199,14.35,-89.85 ],
    [ u"gt",u"El Quetzal",11853,14.766667,-91.816667 ],
    [ u"gt",u"El Rodeo",1849,14.916667,-91.966667 ],
    [ u"gt",u"El Tejar",15445,14.647778,-90.792778 ],
    [ u"gt",u"El Tumbador",7406,14.866667,-91.933333 ],
    [ u"gt",u"Escuintla",101047,14.305,-90.785 ],
    [ u"gt",u"Esquipulas",20249,14.566667,-89.35 ],
    [ u"gt",u"Esquipulas Palo Gordo",1502,14.933333,-91.816667 ],
    [ u"gt",u"Estanzuela",8753,15,-89.566667 ],
    [ u"gt",u"Flores Costa Cuca",11716,14.65,-91.816667 ],
    [ u"gt",u"Flores",20002,16.933333,-89.883333 ],
    [ u"gt",u"Fraijanes",27852,14.465278,-90.440833 ],
    [ u"gt",u"Génova",3667,14.616667,-91.833333 ],
    [ u"gt",u"Granados",1120,14.913611,-90.522778 ],
    [ u"gt",u"Gualán",18957,15.133333,-89.366667 ],
    [ u"gt",u"Guanagazapa",2784,14.225278,-90.643333 ],
    [ u"gt",u"Guastatoya",13190,14.853889,-90.064722 ],
    [ u"gt",u"Guatemala City",973208,14.621111,-90.526944 ],
    [ u"gt",u"Guatemala",973208,14.621111,-90.526944 ],
    [ u"gt",u"Guazacapán",6935,14.074167,-90.416667 ],
    [ u"gt",u"Huehuetenango",77797,15.319722,-91.470833 ],
    [ u"gt",u"Huitán",9737,15.1,-91.616667 ],
    [ u"gt",u"Huité",2656,14.933333,-89.716667 ],
    [ u"gt",u"Ipala",5174,14.616667,-89.616667 ],
    [ u"gt",u"Ixchiguán",2217,15.2,-91.883333 ],
    [ u"gt",u"Ixtahuacán",3631,15.416667,-91.766667 ],
    [ u"gt",u"Iztapa",3937,13.933333,-90.7075 ],
    [ u"gt",u"Jacaltenango",33384,15.666667,-91.733333 ],
    [ u"gt",u"Jalapa",44896,14.633333,-89.983333 ],
    [ u"gt",u"Jalpatagua",10254,14.141667,-90.008611 ],
    [ u"gt",u"Jerez",4330,14.1,-89.75 ],
    [ u"gt",u"Jocotán",4829,14.816667,-89.383333 ],
    [ u"gt",u"Jocotenango",17550,14.581944,-90.743611 ],
    [ u"gt",u"Joyabaj",12893,14.995,-90.806111 ],
    [ u"gt",u"Jutiapa",33626,14.283333,-89.9 ],
    [ u"gt",u"La Democracia",5366,14.230833,-90.947222 ],
    [ u"gt",u"La Esperanza",16095,14.866667,-91.566667 ],
    [ u"gt",u"La Gomera",23460,14.083333,-91.05 ],
    [ u"gt",u"La Libertad",6307,15.5,-91.833333 ],
    [ u"gt",u"La Libertad",8467,16.783333,-90.116667 ],
    [ u"gt",u"Lanquín",1949,15.566667,-89.966667 ],
    [ u"gt",u"La Reforma",4804,14.8,-91.816667 ],
    [ u"gt",u"La Unión",3606,14.966667,-89.283333 ],
    [ u"gt",u"Lívingston",14056,15.833333,-88.75 ],
    [ u"gt",u"Los Amates",3347,15.266667,-89.1 ],
    [ u"gt",u"Magdalena Milpas Altas",5467,14.545278,-90.675278 ],
    [ u"gt",u"Malacatancito",2078,15.216667,-91.516667 ],
    [ u"gt",u"Malacatán",14616,14.9,-92.05 ],
    [ u"gt",u"Masagua",9818,14.203056,-90.848056 ],
    [ u"gt",u"Mataquescuintla",7384,14.529167,-90.184167 ],
    [ u"gt",u"Mazatenango",43225,14.533333,-91.5 ],
    [ u"gt",u"Melchor de Mencos",11220,17.068611,-89.152222 ],
    [ u"gt",u"Mixco",460576,14.633333,-90.606389 ],
    [ u"gt",u"Momostenango",31088,15.043611,-91.408611 ],
    [ u"gt",u"Monjas",10138,14.5,-89.866667 ],
    [ u"gt",u"Morales",18571,15.483333,-88.816667 ],
    [ u"gt",u"Morazán",2502,14.932778,-90.143056 ],
    [ u"gt",u"Moyuta",7978,14.038611,-90.080833 ],
    [ u"gt",u"Nahualá",27076,14.85,-91.316667 ],
    [ u"gt",u"Nebaj",22821,15.405833,-91.146111 ],
    [ u"gt",u"Nentón",2478,15.8,-91.75 ],
    [ u"gt",u"Nueva Concepción",10892,14.2,-91.3 ],
    [ u"gt",u"Nueva Santa Rosa",9922,14.381111,-90.276111 ],
    [ u"gt",u"Nuevo Progreso",7947,14.8,-91.916667 ],
    [ u"gt",u"Nuevo San Carlos",18681,14.6,-91.7 ],
    [ u"gt",u"Ocós",9252,14.509444,-92.193333 ],
    [ u"gt",u"Olintepeque",28239,14.883333,-91.516667 ],
    [ u"gt",u"Olopa",1655,14.683333,-89.35 ],
    [ u"gt",u"Oratorio",9946,14.228056,-90.175833 ],
    [ u"gt",u"Ostuncalco",28301,14.866667,-91.616667 ],
    [ u"gt",u"Pachalum",2295,14.924722,-90.662778 ],
    [ u"gt",u"Pajapita",7996,14.716667,-92.033333 ],
    [ u"gt",u"Palencia",18192,14.664722,-90.358611 ],
    [ u"gt",u"Palestina de los Altos",1657,14.933333,-91.7 ],
    [ u"gt",u"Palín",30684,14.405556,-90.698333 ],
    [ u"gt",u"Panajachel",12599,14.733333,-91.15 ],
    [ u"gt",u"Panzós",18302,15.4,-89.666667 ],
    [ u"gt",u"Parramos",9415,14.607778,-90.803056 ],
    [ u"gt",u"Pasaco",1834,13.977222,-90.206389 ],
    [ u"gt",u"Pastores",10180,14.596667,-90.754722 ],
    [ u"gt",u"Patulul",13905,14.416667,-91.166667 ],
    [ u"gt",u"Patzicía",16155,14.631667,-90.926944 ],
    [ u"gt",u"Patzité",983,14.966667,-91.216667 ],
    [ u"gt",u"Patzún",18319,14.683333,-91.016667 ],
    [ u"gt",u"Petapa",137839,14.502778,-90.551667 ],
    [ u"gt",u"Pochuta",3799,14.55,-91.083333 ],
    [ u"gt",u"Poptún",16963,16.331111,-89.416944 ],
    [ u"gt",u"Pueblo Nuevo",3051,14.65,-91.533333 ],
    [ u"gt",u"Pueblo Nuevo Viñas",4125,14.225833,-90.474167 ],
    [ u"gt",u"Puerto Barrios",55445,15.716667,-88.6 ],
    [ u"gt",u"Purulhá",5606,15.266667,-90.2 ],
    [ u"gt",u"Quetzaltenango",132231,14.833333,-91.516667 ],
    [ u"gt",u"Quezada",2203,14.270278,-90.040278 ],
    [ u"gt",u"Quezaltepeque",4041,14.633333,-89.45 ],
    [ u"gt",u"Rabinal",12641,15.1,-90.45 ],
    [ u"gt",u"Retalhuleu",35903,14.533333,-91.683333 ],
    [ u"gt",u"Río Blanco",812,15.033333,-91.683333 ],
    [ u"gt",u"Río Bravo",7412,14.4,-91.316667 ],
    [ u"gt",u"Río Hondo",5874,15.066667,-89.583333 ],
    [ u"gt",u"Sacapulas",11839,15.286667,-91.087222 ],
    [ u"gt",u"Salamá",22247,15.1,-90.266667 ],
    [ u"gt",u"Salcajá",11720,14.883333,-91.45 ],
    [ u"gt",u"Samayac",8809,14.583333,-91.466667 ],
    [ u"gt",u"San Agustín Acasaguastlán",10123,14.95,-89.966667 ],
    [ u"gt",u"San Andrés Itzapa",18263,14.62,-90.844167 ],
    [ u"gt",u"San Andrés Sajcabajá",1947,15.216667,-90.916667 ],
    [ u"gt",u"San Andrés",7086,16.966667,-89.916667 ],
    [ u"gt",u"San Andrés Semetabaj",2552,14.75,-91.133333 ],
    [ u"gt",u"San Andrés Villa Seca",4988,14.566667,-91.583333 ],
    [ u"gt",u"San Andrés Xecul",11884,14.9,-91.483333 ],
    [ u"gt",u"San Antonio Aguas Calientes",7650,14.539722,-90.769444 ],
    [ u"gt",u"San Antonio Huista",5553,15.65,-91.766667 ],
    [ u"gt",u"San Antonio Ilotenango",1979,15.054722,-91.229722 ],
    [ u"gt",u"San Antonio Palopó",3514,14.7,-91.116667 ],
    [ u"gt",u"San Antonio Sacatepéquez",1623,14.966667,-91.733333 ],
    [ u"gt",u"San Antonio Suchitepéquez",10726,14.533333,-91.416667 ],
    [ u"gt",u"Sanarate",15517,14.795,-90.192222 ],
    [ u"gt",u"San Bartolomé Jocotenango",1586,15.192778,-91.077222 ],
    [ u"gt",u"San Bartolomé Milpas Altas",6132,14.606111,-90.68 ],
    [ u"gt",u"San Bartolo",1264,15.084444,-91.455833 ],
    [ u"gt",u"San Benito",30131,16.916667,-89.9 ],
    [ u"gt",u"San Bernardino",5388,14.533333,-91.45 ],
    [ u"gt",u"San Carlos Sija",6691,14.983333,-91.55 ],
    [ u"gt",u"San Cristóbal Acasaguastlán",2127,14.916667,-89.883333 ],
    [ u"gt",u"San Cristóbal Cucho",8948,14.9,-91.783333 ],
    [ u"gt",u"San Cristóbal Totonicapán",4104,14.916667,-91.433333 ],
    [ u"gt",u"San Cristóbal Verapaz",18748,15.383333,-90.4 ],
    [ u"gt",u"San Diego",546,14.783333,-89.783333 ],
    [ u"gt",u"San Felipe",8737,14.616667,-91.6 ],
    [ u"gt",u"San Francisco El Alto",53226,14.95,-91.45 ],
    [ u"gt",u"San Francisco",3873,16.8,-89.933333 ],
    [ u"gt",u"San Francisco Zapotitlán",13544,14.583333,-91.516667 ],
    [ u"gt",u"San Gabriel",4033,14.516667,-91.516667 ],
    [ u"gt",u"San Gaspar Ixchil",540,15.383333,-91.716667 ],
    [ u"gt",u"San Jacinto",1488,14.666667,-89.5 ],
    [ u"gt",u"San Jerónimo",8317,15.05,-90.2 ],
    [ u"gt",u"San José Acatempa",6236,14.265278,-90.126944 ],
    [ u"gt",u"San José Chacayá",820,14.766667,-91.216667 ],
    [ u"gt",u"San José del Golfo",4807,14.762778,-90.376389 ],
    [ u"gt",u"San José El Ídolo",2362,14.45,-91.416667 ],
    [ u"gt",u"San José Ojetenán",1243,15.216667,-91.966667 ],
    [ u"gt",u"San José Pinula",46188,14.546111,-90.411389 ],
    [ u"gt",u"San José Poaquil",5864,14.819722,-90.906389 ],
    [ u"gt",u"San José",18270,13.925556,-90.824444 ],
    [ u"gt",u"San José",1176,16.983333,-89.9 ],
    [ u"gt",u"San Juan Atitán",1870,15.433333,-91.633333 ],
    [ u"gt",u"San Juan Bautista",2625,14.416667,-91.183333 ],
    [ u"gt",u"San Juan Chamelco",11389,15.433333,-90.333333 ],
    [ u"gt",u"San Juan Cotzal",10818,15.434167,-91.034167 ],
    [ u"gt",u"San Juan Ermita",1590,14.766667,-89.433333 ],
    [ u"gt",u"San Juan Ixcoy",2483,15.599722,-91.445278 ],
    [ u"gt",u"San Juan Sacatepéquez",133613,14.718889,-90.644167 ],
    [ u"gt",u"San Juan Tecuaco",2164,14.082222,-90.261111 ],
    [ u"gt",u"San Lorenzo",925,15.033333,-91.733333 ],
    [ u"gt",u"San Lorenzo",2121,14.483333,-91.516667 ],
    [ u"gt",u"San Lucas Sacatepéquez",17590,14.609722,-90.656944 ],
    [ u"gt",u"San Lucas Tolimán",14246,14.633333,-91.133333 ],
    [ u"gt",u"San Luis Jilotepeque",10094,14.65,-89.733333 ],
    [ u"gt",u"San Luis",6636,16.198889,-89.440278 ],
    [ u"gt",u"San Manuel Chaparrón",2570,14.516667,-89.766667 ],
    [ u"gt",u"San Marcos",24573,14.966667,-91.8 ],
    [ u"gt",u"San Martín Jilotepeque",9643,14.787778,-90.7925 ],
    [ u"gt",u"San Martín Sacatepéquez",3582,14.816667,-91.65 ],
    [ u"gt",u"San Martín Zapotitlán",4328,14.6,-91.6 ],
    [ u"gt",u"San Mateo Ixtatán",12942,15.831944,-91.478056 ],
    [ u"gt",u"San Mateo",5421,14.866667,-91.583333 ],
    [ u"gt",u"San Miguel Acatán",2716,15.7,-91.616667 ],
    [ u"gt",u"San Miguel Chicaj",12708,15.1,-90.4 ],
    [ u"gt",u"San Miguel Dueñas",8251,14.523889,-90.798333 ],
    [ u"gt",u"San Miguel Ixtahuacán",3587,15.25,-91.75 ],
    [ u"gt",u"San Miguel Panán",1983,14.533333,-91.366667 ],
    [ u"gt",u"San Miguel Sigüilá",7384,14.9,-91.616667 ],
    [ u"gt",u"San Pablo Jocopilas",19774,14.583333,-91.45 ],
    [ u"gt",u"San Pablo",13340,14.933333,-92 ],
    [ u"gt",u"San Pedro Ayampuc",45755,14.786667,-90.451111 ],
    [ u"gt",u"San Pedro Carchá",12941,15.483333,-90.266667 ],
    [ u"gt",u"San Pedro Jocopilas",1019,15.094444,-91.151389 ],
    [ u"gt",u"San Pedro Necta",3481,15.5,-91.766667 ],
    [ u"gt",u"San Pedro Pinula",3235,14.666667,-89.85 ],
    [ u"gt",u"San Pedro Sacatepéquez",14020,14.684167,-90.644167 ],
    [ u"gt",u"San Pedro Sacatepéquez",39200,14.966667,-91.766667 ],
    [ u"gt",u"San Rafael Petzal",1494,15.416667,-91.666667 ],
    [ u"gt",u"San Raymundo",8510,14.764722,-90.595556 ],
    [ u"gt",u"Sansare",3714,14.747222,-90.1125 ],
    [ u"gt",u"San Sebastián Coatán",784,15.733333,-91.566667 ],
    [ u"gt",u"San Sebastián Huehuetenango",1284,15.383333,-91.583333 ],
    [ u"gt",u"San Sebastián",14519,14.566667,-91.65 ],
    [ u"gt",u"Santa Ana Huista",1963,15.683333,-91.816667 ],
    [ u"gt",u"Santa Ana",9309,16.8,-89.833333 ],
    [ u"gt",u"Santa Apolonia",2346,14.791389,-90.970833 ],
    [ u"gt",u"Santa Bárbara",868,15.316667,-91.616667 ],
    [ u"gt",u"Santa Bárbara",12618,14.433333,-91.233333 ],
    [ u"gt",u"Santa Catarina Barahona",3148,14.548889,-90.788333 ],
    [ u"gt",u"Santa Catarina Ixtahuacán",14405,14.8,-91.366667 ],
    [ u"gt",u"Santa Catarina Mita",10595,14.45,-89.75 ],
    [ u"gt",u"Santa Catarina Palopó",2887,14.716667,-91.133333 ],
    [ u"gt",u"Santa Catarina Pinula",66351,14.568889,-90.495278 ],
    [ u"gt",u"Santa Cruz Balanyá",7664,14.687222,-90.915 ],
    [ u"gt",u"Santa Cruz del Quiché",23131,15.030556,-91.148889 ],
    [ u"gt",u"Santa Cruz Muluá",2650,14.583333,-91.616667 ],
    [ u"gt",u"Santa Cruz Naranjo",6126,14.388056,-90.369722 ],
    [ u"gt",u"Santa Cruz Verapaz",5656,15.366667,-90.433333 ],
    [ u"gt",u"Santa Eulalia",4820,15.733056,-91.456944 ],
    [ u"gt",u"Santa Lucía Cotzumalguapa",60821,14.333333,-91.016667 ],
    [ u"gt",u"Santa Lucía Milpas Altas",12711,14.575833,-90.678611 ],
    [ u"gt",u"Santa Lucía Utatlán",1278,14.766667,-91.266667 ],
    [ u"gt",u"Santa María Chiquimula",6837,15.030278,-91.329167 ],
    [ u"gt",u"Santa María de Jesús",15210,14.518333,-90.726667 ],
    [ u"gt",u"Santa María Ixhuatán",3559,14.19,-90.274722 ],
    [ u"gt",u"Santa María Visitación",1456,14.716667,-91.316667 ],
    [ u"gt",u"Santa Rosa de Lima",5861,14.388056,-90.295556 ],
    [ u"gt",u"Santiago Atitlán",32625,14.633333,-91.233333 ],
    [ u"gt",u"Santiago Chimaltenango",2958,15.466667,-91.716667 ],
    [ u"gt",u"Santiago Sacatepéquez",23713,14.635278,-90.676389 ],
    [ u"gt",u"Santo Domingo Suchitepéquez",6141,14.466667,-91.483333 ],
    [ u"gt",u"Santo Domingo Xenacoj",8610,14.677778,-90.697778 ],
    [ u"gt",u"San Vicente Pacaya",7014,14.416111,-90.639167 ],
    [ u"gt",u"Sayaxché",8913,16.516667,-90.166667 ],
    [ u"gt",u"Senahú",5378,15.4,-89.833333 ],
    [ u"gt",u"Sibilia",1155,15,-91.616667 ],
    [ u"gt",u"Sibinal",1623,15.133333,-92.05 ],
    [ u"gt",u"Sipacapa",647,15.2,-91.666667 ],
    [ u"gt",u"Siquinalá",12881,14.306111,-90.965 ],
    [ u"gt",u"Sololá",44443,14.766667,-91.183333 ],
    [ u"gt",u"Soloma",10692,15.716667,-91.45 ],
    [ u"gt",u"Sumpango",20454,14.646389,-90.733889 ],
    [ u"gt",u"Tacaná",6305,15.233333,-92.083333 ],
    [ u"gt",u"Tactic",8723,15.333333,-90.3 ],
    [ u"gt",u"Tajumulco",4226,15.083333,-91.883333 ],
    [ u"gt",u"Tamahú",1078,15.333333,-90.166667 ],
    [ u"gt",u"Taxisco",6384,14.070833,-90.463056 ],
    [ u"gt",u"Tecpán Guatemala",21526,14.766944,-90.994167 ],
    [ u"gt",u"Tectitán",728,15.333333,-92.033333 ],
    [ u"gt",u"Teculután",6275,14.983333,-89.716667 ],
    [ u"gt",u"Tejutla",2599,15.116667,-91.8 ],
    [ u"gt",u"Tiquisate",17814,14.283333,-91.366667 ],
    [ u"gt",u"Todos Santos Cuchumatán",3221,15.516667,-91.616667 ],
    [ u"gt",u"Totonicapán",68213,14.916667,-91.366667 ],
    [ u"gt",u"Tucurú",3961,15.3,-90.066667 ],
    [ u"gt",u"Uspantán",4617,15.383333,-90.833333 ],
    [ u"gt",u"Usumatlán",4884,14.95,-89.783333 ],
    [ u"gt",u"Villa Canales",119084,14.481389,-90.531667 ],
    [ u"gt",u"Villa Nueva",397158,14.526944,-90.5875 ],
    [ u"gt",u"Yepocapa",8777,14.504167,-90.956944 ],
    [ u"gt",u"Yupiltepeque",2966,14.2,-89.783333 ],
    [ u"gt",u"Zacapa",35349,14.966667,-89.533333 ],
    [ u"gt",u"Zacualpa",9050,15.083333,-90.833333 ],
    [ u"gt",u"Zapotitlán",1583,14.133333,-89.833333 ],
    [ u"gt",u"Zaragoza",9168,14.654444,-90.889444 ],
    [ u"gt",u"Zunilito",2688,14.616667,-91.516667 ],
    [ u"gt",u"Zunil",9780,14.783333,-91.483333 ],
    [ u"gw",u"Bafatá",22521,12.1666667,-14.6666667 ],
    [ u"gw",u"Bissau",388094,11.85,-15.5833333 ],
    [ u"gw",u"Bissorã",12688,12.04,-15.4280556 ],
    [ u"gw",u"Bolama",10769,11.5833333,-15.4666667 ],
    [ u"gw",u"Buba",7779,11.5833333,-15.0 ],
    [ u"gw",u"Bubaque",9941,11.2833333,-15.8333333 ],
    [ u"gw",u"Cacheu",10490,12.2705556,-16.1658333 ],
    [ u"gw",u"Canchungo",6853,12.0672222,-16.0333333 ],
    [ u"gw",u"Catió",9898,11.2833333,-15.25 ],
    [ u"gw",u"Farim",6792,12.4838889,-15.2216667 ],
    [ u"gw",u"Fulacunda",1327,11.7666667,-15.1666667 ],
    [ u"gw",u"Gabú",14430,12.2833333,-14.2166667 ],
    [ u"gw",u"Mansôa",7821,12.0733333,-15.3188889 ],
    [ u"gw",u"Quebo",7072,11.3333333,-14.9333333 ],
    [ u"gy",u"Bartica",11159,6.4,-58.6166667 ],
    [ u"gy",u"Fort Wellington",2253,6.4,-57.6 ],
    [ u"gy",u"Georgetown",235017,6.8,-58.1666667 ],
    [ u"gy",u"Ituni",4567,5.5333333,-58.25 ],
    [ u"gy",u"Lethem",716,3.3833333,-59.8 ],
    [ u"gy",u"Linden",44690,6.0,-58.3 ],
    [ u"gy",u"Mabaruma",717,8.2,-59.7833333 ],
    [ u"gy",u"Mahaicony",2130,6.55,-57.8 ],
    [ u"gy",u"New Amsterdam",35039,6.25,-57.5166667 ],
    [ u"gy",u"Rosignol",5782,6.2833333,-57.5333333 ],
    [ u"gy",u"Skeldon",5859,5.8833333,-57.1333333 ],
    [ u"gy",u"Vreed en Hoop",3073,6.8,-58.1833333 ],
    [ u"hn",u"Achiotal",1210,14.0833333,-88.75 ],
    [ u"hn",u"Agalteca",1029,14.45,-87.2666667 ],
    [ u"hn",u"Agua Azul Rancho",1043,14.9,-87.95 ],
    [ u"hn",u"Agua Azul Sierra",1079,14.9166667,-87.9666667 ],
    [ u"hn",u"Agua Blanca Sur",7592,15.25,-87.8833333 ],
    [ u"hn",u"Agua Caliente",1075,14.8833333,-88.8166667 ],
    [ u"hn",u"Agua Caliente de Linaca",973,13.4352778,-87.2316667 ],
    [ u"hn",u"Agua Dulcita",1017,14.7,-87.75 ],
    [ u"hn",u"Agua Fría",3196,13.45,-87.55 ],
    [ u"hn",u"Agualote",1759,15.3352778,-88.5530556 ],
    [ u"hn",u"Aguas del Padre",1104,14.5666667,-87.8833333 ],
    [ u"hn",u"Ahuás",1505,15.4833333,-84.3333333 ],
    [ u"hn",u"Ajuterique",5354,14.3833333,-87.7 ],
    [ u"hn",u"Alubarén",983,13.7961111,-87.4688889 ],
    [ u"hn",u"Amapala",2137,13.2922222,-87.6538889 ],
    [ u"hn",u"Antigua Ocotepeque",1862,14.4,-89.2 ],
    [ u"hn",u"Apacilagua",1251,13.4780556,-87.0755556 ],
    [ u"hn",u"Arada",2913,14.85,-88.3 ],
    [ u"hn",u"Aramecina",1071,13.75,-87.7166667 ],
    [ u"hn",u"Araulí",1160,13.95,-86.55 ],
    [ u"hn",u"Arenal",1722,15.35,-86.8333333 ],
    [ u"hn",u"Arimís",1817,14.7833333,-86.0 ],
    [ u"hn",u"Arizona",4444,15.6333333,-87.3166667 ],
    [ u"hn",u"Armenia",1488,15.4666667,-86.3666667 ],
    [ u"hn",u"Armenta",2989,15.5,-88.05 ],
    [ u"hn",u"Atenas de San Cristóbal",1783,15.6833333,-87.3166667 ],
    [ u"hn",u"Atima",1703,14.9333333,-88.4833333 ],
    [ u"hn",u"Auka",1254,14.9333333,-83.8333333 ],
    [ u"hn",u"Ayapa",1559,15.1,-87.15 ],
    [ u"hn",u"Azacualpa",966,14.2666667,-88.3833333 ],
    [ u"hn",u"Azacualpa",966,14.2166667,-88.45 ],
    [ u"hn",u"Azacualpa",1258,14.7166667,-88.1 ],
    [ u"hn",u"Bálsamo Oriental",1465,15.4833333,-86.3333333 ],
    [ u"hn",u"Baracoa",9202,15.7666667,-87.85 ],
    [ u"hn",u"Barra Patuca",2759,15.8,-84.2833333 ],
    [ u"hn",u"Bejuco",1276,15.1333333,-87.9333333 ],
    [ u"hn",u"Belén Gualcho",2359,14.4833333,-88.8 ],
    [ u"hn",u"Berlín",1050,14.8333333,-88.5 ],
    [ u"hn",u"Bonito Oriental",3732,15.7333333,-85.7333333 ],
    [ u"hn",u"Brus Laguna",4067,15.75,-84.4833333 ],
    [ u"hn",u"Buenos Aires",1131,15.0333333,-88.9666667 ],
    [ u"hn",u"Buenos Aires",979,15.4833333,-88.1833333 ],
    [ u"hn",u"Buenos Aires",980,15.35,-86.7333333 ],
    [ u"hn",u"Callejones",1033,15.1666667,-88.65 ],
    [ u"hn",u"Camalote",1319,15.3333333,-88.3333333 ],
    [ u"hn",u"Camasca",1150,14.0,-88.3833333 ],
    [ u"hn",u"Campamento",6560,14.55,-86.65 ],
    [ u"hn",u"Cañaveral",2137,14.9833333,-88.0166667 ],
    [ u"hn",u"Cane",2190,14.2833333,-87.6666667 ],
    [ u"hn",u"Carbajales",1102,15.5166667,-86.35 ],
    [ u"hn",u"Casa Quemada",3036,15.1166667,-88.0833333 ],
    [ u"hn",u"Casa Quemada",1030,15.2666667,-88.55 ],
    [ u"hn",u"Catacamas",33052,14.8,-85.9 ],
    [ u"hn",u"Cedeño",1503,13.1727778,-87.4316667 ],
    [ u"hn",u"Cedros",1041,14.6,-87.1166667 ],
    [ u"hn",u"Ceguaca",1239,14.8,-88.2 ],
    [ u"hn",u"Cerro Blanco",1169,14.6666667,-87.7833333 ],
    [ u"hn",u"Cerro Grande",1093,13.8166667,-87.25 ],
    [ u"hn",u"Chalmeca",2008,15.1,-88.6833333 ],
    [ u"hn",u"Chiquila",983,15.2333333,-88.5833333 ],
    [ u"hn",u"Chirinos",921,15.4,-86.5833333 ],
    [ u"hn",u"Chivana",1018,15.75,-87.9833333 ],
    [ u"hn",u"Choloma",139117,15.6166667,-87.95 ],
    [ u"hn",u"Choluteca",75880,13.3002778,-87.1908333 ],
    [ u"hn",u"Chotepe",1564,15.4166667,-87.9833333 ],
    [ u"hn",u"Cofradía",20353,15.4,-88.15 ],
    [ u"hn",u"Cofradía",1301,14.2166667,-87.1833333 ],
    [ u"hn",u"Cololaca",1014,14.3,-88.8833333 ],
    [ u"hn",u"Comayagua",58791,14.45,-87.6333333 ],
    [ u"hn",u"Concepción de Guasistagua",1470,14.6,-87.65 ],
    [ u"hn",u"Concepción del Norte",946,15.1666667,-88.1333333 ],
    [ u"hn",u"Concepción del Sur",1049,14.8,-88.1666667 ],
    [ u"hn",u"Concepción de María",923,13.2166667,-87.0 ],
    [ u"hn",u"Concordia",1272,14.6166667,-86.65 ],
    [ u"hn",u"Copán",6337,14.8333333,-89.15 ],
    [ u"hn",u"Corinto",954,15.5833333,-88.3666667 ],
    [ u"hn",u"Corocito",2855,15.75,-85.7833333 ],
    [ u"hn",u"Corozal",2261,15.8,-86.7166667 ],
    [ u"hn",u"Corquín",4753,14.5666667,-88.8666667 ],
    [ u"hn",u"Correderos",1162,15.4166667,-88.45 ],
    [ u"hn",u"Coyoles Central",1144,15.4,-86.6666667 ],
    [ u"hn",u"Coyoles",949,15.4666667,-86.6833333 ],
    [ u"hn",u"Cubulero",1286,13.4833333,-87.6833333 ],
    [ u"hn",u"Cucuyagua",2939,14.65,-88.8666667 ],
    [ u"hn",u"Cusuna",1441,15.85,-85.2333333 ],
    [ u"hn",u"Cuyalí",1572,13.8833333,-86.55 ],
    [ u"hn",u"Cuyamel",5022,15.6666667,-88.2 ],
    [ u"hn",u"Danlí",44805,14.0333333,-86.5833333 ],
    [ u"hn",u"Dolores",1107,14.8666667,-88.8333333 ],
    [ u"hn",u"Dulce Nombre de Culmí",2091,15.1,-85.5333333 ],
    [ u"hn",u"Dulce Nombre",3590,14.85,-88.8333333 ],
    [ u"hn",u"Duyure",1164,13.6333333,-86.8166667 ],
    [ u"hn",u"El Bálsamo",1741,15.0666667,-87.4666667 ],
    [ u"hn",u"El Benque",1101,14.0333333,-86.4666667 ],
    [ u"hn",u"El Buen Pastor",942,14.8666667,-87.65 ],
    [ u"hn",u"El Caimito",832,13.4463889,-87.475 ],
    [ u"hn",u"El Chichicaste",1671,14.0666667,-86.3 ],
    [ u"hn",u"El Chimbo",1145,14.1333333,-87.1166667 ],
    [ u"hn",u"El Ciruelo",2980,15.3,-88.5 ],
    [ u"hn",u"El Corozal",1039,15.0666667,-88.6166667 ],
    [ u"hn",u"El Corpus",1199,13.2888889,-87.0347222 ],
    [ u"hn",u"El Corpus",1193,14.7,-88.9166667 ],
    [ u"hn",u"El Derrumbo",929,14.75,-88.7833333 ],
    [ u"hn",u"El Durazno",923,14.1333333,-87.2666667 ],
    [ u"hn",u"El Edén",954,14.95,-88.0166667 ],
    [ u"hn",u"El Ermitano",947,15.25,-88.6833333 ],
    [ u"hn",u"El Escanito",1184,14.6666667,-87.1 ],
    [ u"hn",u"El Escaño de Tepale",1026,14.75,-87.0666667 ],
    [ u"hn",u"El Granzal",876,14.4,-88.8666667 ],
    [ u"hn",u"El Guante",1082,14.55,-87.1 ],
    [ u"hn",u"El Guantillo",1223,14.6,-87.3 ],
    [ u"hn",u"El Guapinol",1817,13.7666667,-87.4666667 ],
    [ u"hn",u"El Guayabito",1404,14.8333333,-86.0333333 ],
    [ u"hn",u"El Guayabo",889,13.4894444,-87.4438889 ],
    [ u"hn",u"El Higuero",1052,14.5666667,-87.7166667 ],
    [ u"hn",u"Elíxir",3079,15.4833333,-86.3 ],
    [ u"hn",u"El Juncal",1286,15.45,-86.4333333 ],
    [ u"hn",u"El Llano",1923,15.15,-87.8833333 ],
    [ u"hn",u"El Lolo",1438,14.1166667,-87.2666667 ],
    [ u"hn",u"El Marañón",1836,15.4,-88.05 ],
    [ u"hn",u"El Milagro",1916,15.4,-87.9666667 ],
    [ u"hn",u"El Mochito",1950,14.8666667,-88.0833333 ],
    [ u"hn",u"El Negrito",9304,15.3166667,-87.7 ],
    [ u"hn",u"El Níspero",2474,14.7666667,-88.3333333 ],
    [ u"hn",u"El Obraje",1172,13.1541667,-87.1308333 ],
    [ u"hn",u"El Obraje",1703,14.0,-86.4333333 ],
    [ u"hn",u"El Ocote",1908,15.4166667,-86.5666667 ],
    [ u"hn",u"El Ocotón",1038,15.0333333,-88.8833333 ],
    [ u"hn",u"El Olivar",1279,15.0833333,-87.8833333 ],
    [ u"hn",u"El Paraíso",18782,13.8666667,-86.55 ],
    [ u"hn",u"El Paraíso",4126,14.4833333,-88.7833333 ],
    [ u"hn",u"El Pedernal",1648,14.7,-87.1166667 ],
    [ u"hn",u"El Perico",957,13.1388889,-87.0322222 ],
    [ u"hn",u"El Perico",1141,15.0833333,-88.1 ],
    [ u"hn",u"El Pescadero",909,13.9333333,-86.55 ],
    [ u"hn",u"El Pino",3004,15.7,-86.9333333 ],
    [ u"hn",u"El Plan",2176,15.2833333,-87.9666667 ],
    [ u"hn",u"El Porvenir",2269,15.75,-86.9333333 ],
    [ u"hn",u"El Porvenir",1337,14.5833333,-87.8833333 ],
    [ u"hn",u"El Porvenir",2940,15.8333333,-87.9333333 ],
    [ u"hn",u"El Porvenir",3153,13.7616667,-87.3458333 ],
    [ u"hn",u"El Progreso",100821,15.4,-87.8 ],
    [ u"hn",u"El Puente",1325,13.2833333,-87.1166667 ],
    [ u"hn",u"El Rancho",1101,15.6666667,-87.95 ],
    [ u"hn",u"El Rincón",1522,14.5833333,-87.9333333 ],
    [ u"hn",u"El Rodeo",893,14.2833333,-86.6 ],
    [ u"hn",u"El Rosario",2575,14.5833333,-87.7333333 ],
    [ u"hn",u"El Rosario",962,14.9,-86.6833333 ],
    [ u"hn",u"El Rusio",1016,14.4666667,-86.3666667 ],
    [ u"hn",u"El Sauce",1389,14.4,-87.7833333 ],
    [ u"hn",u"El Socorro",1092,14.6333333,-87.9166667 ],
    [ u"hn",u"El Suyatal",2027,14.5166667,-87.2166667 ],
    [ u"hn",u"El Tablón",1121,14.0333333,-87.1666667 ],
    [ u"hn",u"El Terrero",1087,14.0666667,-87.0666667 ],
    [ u"hn",u"El Tigre",1435,14.9333333,-87.9833333 ],
    [ u"hn",u"El Tizatillo",798,13.9994444,-87.195 ],
    [ u"hn",u"El Tránsito",1025,14.3833333,-88.9166667 ],
    [ u"hn",u"El Triunfo",7183,13.1166667,-87.0 ],
    [ u"hn",u"El Tular",1927,13.45,-87.5166667 ],
    [ u"hn",u"El Zapote",970,15.0166667,-87.85 ],
    [ u"hn",u"Erandique",1882,14.2333333,-88.4666667 ],
    [ u"hn",u"Esparta",1115,15.7166667,-87.2 ],
    [ u"hn",u"Esquías",1339,14.7333333,-87.3666667 ],
    [ u"hn",u"Flores",3018,14.2833333,-87.5666667 ],
    [ u"hn",u"Florida",5340,15.0333333,-88.8333333 ],
    [ u"hn",u"Francia",1331,15.85,-85.5833333 ],
    [ u"hn",u"French Harbor",2698,16.35,-86.4333333 ],
    [ u"hn",u"Goascorán",1350,13.5833333,-87.6166667 ],
    [ u"hn",u"Gracias",7910,14.5833333,-88.5833333 ],
    [ u"hn",u"Guacamaya",1250,15.0166667,-88.15 ],
    [ u"hn",u"Guaimaca",12901,14.5333333,-86.8166667 ],
    [ u"hn",u"Gualaco",3601,15.05,-86.05 ],
    [ u"hn",u"Gualjoco",1432,14.95,-88.2333333 ],
    [ u"hn",u"Guanaja",1942,16.4,-85.9 ],
    [ u"hn",u"Guarizama",1300,14.9166667,-86.3333333 ],
    [ u"hn",u"Guata",1217,15.0833333,-86.3833333 ],
    [ u"hn",u"Guatemalita",950,14.1166667,-88.6166667 ],
    [ u"hn",u"Guayape",1703,14.7166667,-86.8333333 ],
    [ u"hn",u"Guaymitas",2321,15.5,-87.7166667 ],
    [ u"hn",u"Güinope",2716,13.8833333,-86.9333333 ],
    [ u"hn",u"Hicaque",903,15.6666667,-87.3833333 ],
    [ u"hn",u"Ilama",1811,15.0666667,-88.2166667 ],
    [ u"hn",u"Intibucá",13743,14.3166667,-88.1666667 ],
    [ u"hn",u"Iralaya",1520,15.0,-83.2333333 ],
    [ u"hn",u"Jacaleapa",2578,14.0166667,-86.6666667 ],
    [ u"hn",u"Jamalteca",1107,14.7,-87.5833333 ],
    [ u"hn",u"Jardines",953,14.7,-87.9833333 ],
    [ u"hn",u"Jericó",2364,15.95,-85.9666667 ],
    [ u"hn",u"Jesús de Otoro",6988,14.4833333,-87.9833333 ],
    [ u"hn",u"Jícaro Galán",1370,13.5316667,-87.4388889 ],
    [ u"hn",u"Jiquinlaca",1248,14.0,-88.35 ],
    [ u"hn",u"Joconal",1206,15.3544444,-88.6355556 ],
    [ u"hn",u"Jocón",1731,15.2833333,-86.9666667 ],
    [ u"hn",u"Jutiapa",2815,15.7666667,-86.5166667 ],
    [ u"hn",u"Jutiapa",1153,13.9833333,-86.4 ],
    [ u"hn",u"Juticalpa",33690,14.65,-86.2 ],
    [ u"hn",u"Jutiquile",3585,14.7166667,-86.0833333 ],
    [ u"hn",u"La Brea",1055,15.8,-85.9666667 ],
    [ u"hn",u"La Bueso",1139,15.5833333,-87.8833333 ],
    [ u"hn",u"La Campana",2268,13.8833333,-87.4 ],
    [ u"hn",u"La Ceiba",130230,15.7833333,-86.8 ],
    [ u"hn",u"La Colorada",979,15.6166667,-86.8166667 ],
    [ u"hn",u"La Concepción",1985,14.7,-86.2333333 ],
    [ u"hn",u"La Criba",1001,13.4536111,-87.4133333 ],
    [ u"hn",u"La Curva",981,15.8,-85.7666667 ],
    [ u"hn",u"La Empalizada",933,14.65,-86.1333333 ],
    [ u"hn",u"La Encarnación",1484,14.6666667,-89.0833333 ],
    [ u"hn",u"La Entrada",14705,15.05,-88.7333333 ],
    [ u"hn",u"La Ermita",2495,14.4166667,-87.1 ],
    [ u"hn",u"La Esperanza",2014,15.6333333,-85.7666667 ],
    [ u"hn",u"La Esperanza",919,15.05,-89.1 ],
    [ u"hn",u"La Esperanza",985,15.4166667,-88.1833333 ],
    [ u"hn",u"La Esperanza",5319,14.3,-88.1833333 ],
    [ u"hn",u"La Estancia",1508,15.05,-86.35 ],
    [ u"hn",u"La Estancia",1668,15.2833333,-87.55 ],
    [ u"hn",u"La Flecha",2136,15.2833333,-88.4833333 ],
    [ u"hn",u"La Florida",899,14.0166667,-87.9666667 ],
    [ u"hn",u"La Guacamaya",2525,15.25,-87.8 ],
    [ u"hn",u"La Guama",1242,14.8833333,-87.9333333 ],
    [ u"hn",u"Laguna Seca",1131,14.7,-86.1 ],
    [ u"hn",u"Lagunas",986,14.6166667,-88.4833333 ],
    [ u"hn",u"Laguna Verde",1460,15.2,-88.1666667 ],
    [ u"hn",u"La Jigua",971,15.0333333,-88.8 ],
    [ u"hn",u"La Jutosa",4183,15.6333333,-88.0 ],
    [ u"hn",u"La Labor",1416,14.4833333,-89.0 ],
    [ u"hn",u"La Laguna del Pedernal",888,14.8166667,-88.5666667 ],
    [ u"hn",u"La Libertad",4673,14.45,-87.45 ],
    [ u"hn",u"La Libertad",1444,14.8,-88.5833333 ],
    [ u"hn",u"La Lima",45962,15.4333333,-87.9166667 ],
    [ u"hn",u"Lamaní",1791,14.2,-87.6166667 ],
    [ u"hn",u"La Masica",4022,15.6166667,-87.1166667 ],
    [ u"hn",u"La Mina",2690,15.3166667,-87.8333333 ],
    [ u"hn",u"Langue",3680,13.6166667,-87.65 ],
    [ u"hn",u"La Paz",17557,14.3166667,-87.6833333 ],
    [ u"hn",u"La Playona",1285,15.1166667,-88.9833333 ],
    [ u"hn",u"La Reina",954,15.1166667,-88.6333333 ],
    [ u"hn",u"La Rosa",1552,15.0666667,-87.1666667 ],
    [ u"hn",u"La Sabana",1524,15.3666667,-87.9333333 ],
    [ u"hn",u"Las Ánimas",1117,14.25,-86.5666667 ],
    [ u"hn",u"La Sarrosa",2188,15.2333333,-87.8333333 ],
    [ u"hn",u"Las Conchas",1084,13.3252778,-87.3955556 ],
    [ u"hn",u"Las Delicias",1326,14.7166667,-87.6166667 ],
    [ u"hn",u"Las Lajas",3011,14.7833333,-87.75 ],
    [ u"hn",u"Las Mercedes",1000,14.2833333,-87.5666667 ],
    [ u"hn",u"Las Tapias",814,14.0666667,-87.2833333 ],
    [ u"hn",u"Las Tejeras",1140,14.8,-88.6 ],
    [ u"hn",u"Las Vegas",7487,14.8666667,-88.0666667 ],
    [ u"hn",u"Las Vegas",1308,15.0166667,-87.45 ],
    [ u"hn",u"La Tajeada",882,13.2525,-87.0877778 ],
    [ u"hn",u"La Trinidad",880,14.7166667,-87.6666667 ],
    [ u"hn",u"La Trinidad",1314,15.1,-87.2 ],
    [ u"hn",u"La Unión",2382,15.7166667,-87.0 ],
    [ u"hn",u"La Unión",3054,14.8166667,-88.4 ],
    [ u"hn",u"La Unión",827,15.1333333,-88.55 ],
    [ u"hn",u"La Virtud",1315,14.05,-88.7 ],
    [ u"hn",u"La Zumbadora",1086,15.0166667,-88.9 ],
    [ u"hn",u"Lejamaní",3835,14.3666667,-87.7 ],
    [ u"hn",u"Lepaera",3137,14.7833333,-88.5833333 ],
    [ u"hn",u"Lepaterique",2090,14.0666667,-87.4666667 ],
    [ u"hn",u"Limón",2434,15.8666667,-85.5 ],
    [ u"hn",u"Liure",1022,13.5358333,-87.0919444 ],
    [ u"hn",u"Llano Largo",910,14.45,-88.75 ],
    [ u"hn",u"Loma Alta",1067,15.3966667,-88.5597222 ],
    [ u"hn",u"Lomitas",1552,15.1,-87.2166667 ],
    [ u"hn",u"Los Arroyos",916,14.65,-88.8833333 ],
    [ u"hn",u"Los Caminos",1146,14.95,-87.9666667 ],
    [ u"hn",u"Los Llanitos",1040,13.25,-87.0 ],
    [ u"hn",u"Los Naranjos",1684,14.9,-88.05 ],
    [ u"hn",u"Los Planes",1320,14.05,-88.0166667 ],
    [ u"hn",u"Los Tangos",1424,15.15,-88.6833333 ],
    [ u"hn",u"Lucerna",1452,14.55,-88.9333333 ],
    [ u"hn",u"Macholoa",989,14.9166667,-88.3 ],
    [ u"hn",u"Macuelizo",2867,15.3,-88.5333333 ],
    [ u"hn",u"Magdalena",966,13.8666667,-88.3 ],
    [ u"hn",u"Mandasta",940,13.7333333,-86.9166667 ],
    [ u"hn",u"Mangulile",1263,15.0666667,-86.8 ],
    [ u"hn",u"Manto",1098,14.9166667,-86.3833333 ],
    [ u"hn",u"Marale",1523,14.8833333,-87.15 ],
    [ u"hn",u"Marcala",10055,14.15,-88.0333333 ],
    [ u"hn",u"Marcovia",1928,13.2880556,-87.3097222 ],
    [ u"hn",u"Mata de Plátano",1151,14.6,-87.2833333 ],
    [ u"hn",u"Mateo",1021,14.0833333,-87.3166667 ],
    [ u"hn",u"Meámbar",902,14.7833333,-87.7666667 ],
    [ u"hn",u"Mercedes",984,14.3166667,-88.9833333 ],
    [ u"hn",u"Mezapa",6324,15.5833333,-87.65 ],
    [ u"hn",u"Minas de Oro",3554,14.8,-87.35 ],
    [ u"hn",u"Mojimán",1498,15.2666667,-87.6 ],
    [ u"hn",u"Monjarás",6772,13.2005556,-87.3741667 ],
    [ u"hn",u"Monterrey",2234,15.5833333,-87.8833333 ],
    [ u"hn",u"Morazán",11077,15.3166667,-87.6 ],
    [ u"hn",u"Morocelí",2984,14.1166667,-86.8666667 ],
    [ u"hn",u"Morolica",973,13.5666667,-86.9 ],
    [ u"hn",u"Nacaome",13931,13.5361111,-87.4875 ],
    [ u"hn",u"Naco",3966,15.3833333,-88.1833333 ],
    [ u"hn",u"Namasigüe",1804,13.2047222,-87.1388889 ],
    [ u"hn",u"Naranjito",3814,14.95,-88.6833333 ],
    [ u"hn",u"Nombre de Jesús",1250,15.35,-86.6833333 ],
    [ u"hn",u"Nueva Armenia",1392,15.8166667,-86.5 ],
    [ u"hn",u"Nueva Armenia",875,15.0333333,-89.1 ],
    [ u"hn",u"Nueva Esperanza",2121,15.2666667,-87.6 ],
    [ u"hn",u"Nueva Florida",904,15.4666667,-87.5 ],
    [ u"hn",u"Nueva Granada",939,15.1166667,-88.1 ],
    [ u"hn",u"Nuevo Celilac",950,14.9833333,-88.3333333 ],
    [ u"hn",u"Nuevo Chamelecón",2098,15.3833333,-88.0166667 ],
    [ u"hn",u"Nuevo Jalapa",1094,14.9166667,-88.3333333 ],
    [ u"hn",u"Ocote Paulino",1697,15.4166667,-87.6 ],
    [ u"hn",u"Ocotepeque",8781,14.4333333,-89.1833333 ],
    [ u"hn",u"Ojo de Agua",2330,14.0166667,-86.35 ],
    [ u"hn",u"Ojojona",2790,13.9338889,-87.2958333 ],
    [ u"hn",u"Ojos de Agua",1146,14.6,-87.9333333 ],
    [ u"hn",u"Ojos de Agua",1340,14.7,-88.8166667 ],
    [ u"hn",u"Olanchito",25972,15.5,-86.5666667 ],
    [ u"hn",u"Omoa",4763,15.7666667,-88.0333333 ],
    [ u"hn",u"Orica",2342,14.7,-86.95 ],
    [ u"hn",u"Orocuina",1655,13.4816667,-87.105 ],
    [ u"hn",u"Oropéndolas",1333,15.0166667,-87.9333333 ],
    [ u"hn",u"Oropolí",1412,13.8166667,-86.8166667 ],
    [ u"hn",u"Ostumán",862,14.8333333,-89.1666667 ],
    [ u"hn",u"Palkaka",909,15.3166667,-83.8666667 ],
    [ u"hn",u"Palo Pintado",909,14.5166667,-87.6833333 ],
    [ u"hn",u"Paptalaya",1227,15.5,-84.3166667 ],
    [ u"hn",u"Paujiles",1244,15.1,-87.35 ],
    [ u"hn",u"Peña Blanca",3552,15.5333333,-88.05 ],
    [ u"hn",u"Pespire",3172,13.5922222,-87.3616667 ],
    [ u"hn",u"Petoa",1067,15.2666667,-88.2833333 ],
    [ u"hn",u"Piedras Amarillas",999,15.6833333,-86.5666667 ],
    [ u"hn",u"Pimienta",8761,15.2833333,-87.9666667 ],
    [ u"hn",u"Pinalejo",3767,15.3833333,-88.4 ],
    [ u"hn",u"Portillo de Gonzalez",958,15.2833333,-87.6 ],
    [ u"hn",u"Potrerillos",1334,14.55,-87.8666667 ],
    [ u"hn",u"Potrerillos",1102,15.6333333,-88.3 ],
    [ u"hn",u"Potrerillos",900,15.2666667,-88.4333333 ],
    [ u"hn",u"Prieta",1103,15.5833333,-86.1833333 ],
    [ u"hn",u"Protección",2101,15.0333333,-88.65 ],
    [ u"hn",u"Pueblo Nuevo",1053,15.0,-88.75 ],
    [ u"hn",u"Pueblo Nuevo",3556,15.2833333,-88.0166667 ],
    [ u"hn",u"Pueblo Nuevo",958,14.3833333,-87.2833333 ],
    [ u"hn",u"Puente Alto",1385,15.7,-87.8666667 ],
    [ u"hn",u"Puerto Castilla",1220,16.0166667,-85.9666667 ],
    [ u"hn",u"Puerto Cortés",48020,15.8833333,-87.95 ],
    [ u"hn",u"Puerto Lempira",4857,15.2666667,-83.7666667 ],
    [ u"hn",u"Punta de Piedra",1188,15.9,-85.2833333 ],
    [ u"hn",u"Punta Ocote",1399,15.2,-87.2833333 ],
    [ u"hn",u"Punuare",1905,14.7333333,-85.9666667 ],
    [ u"hn",u"Quebrada de Arena",2723,15.7666667,-85.9166667 ],
    [ u"hn",u"Quebrada de Yoro",896,15.4333333,-87.7833333 ],
    [ u"hn",u"Quebrada Larga",1217,14.1,-86.3666667 ],
    [ u"hn",u"Quebrada Seca",2248,15.6666667,-87.95 ],
    [ u"hn",u"Quezailica",1115,14.8833333,-88.7333333 ],
    [ u"hn",u"Quimistán",3517,15.35,-88.4 ],
    [ u"hn",u"Rancho Grande",1484,14.6833333,-87.5 ],
    [ u"hn",u"Reitoca",1094,13.8258333,-87.4652778 ],
    [ u"hn",u"Río Abajo",2055,14.1666667,-87.2166667 ],
    [ u"hn",u"Río Amarillo",1000,14.9666667,-89.1333333 ],
    [ u"hn",u"Río Arriba",995,13.1763889,-87.0486111 ],
    [ u"hn",u"Río Blanquito",2458,15.7333333,-87.9 ],
    [ u"hn",u"Río Bonito",1054,14.7666667,-87.8833333 ],
    [ u"hn",u"Río Chiquito",1405,15.6333333,-88.25 ],
    [ u"hn",u"Río Esteban",1208,15.8333333,-86.3 ],
    [ u"hn",u"Río Lindo",3479,15.0333333,-87.9833333 ],
    [ u"hn",u"Roatán",7515,16.3,-86.55 ],
    [ u"hn",u"Sabana Abajo",884,14.6,-86.5833333 ],
    [ u"hn",u"Sabanagrande",2056,13.8077778,-87.2591667 ],
    [ u"hn",u"Sabá",9666,15.4666667,-86.25 ],
    [ u"hn",u"Salamá",1737,15.75,-85.9666667 ],
    [ u"hn",u"Salamá",2820,14.8333333,-86.5833333 ],
    [ u"hn",u"Sambo Creek",2532,15.8166667,-86.6833333 ],
    [ u"hn",u"San Agustín",938,13.2,-87.1166667 ],
    [ u"hn",u"San Agustín",1777,14.8166667,-88.9333333 ],
    [ u"hn",u"San Antonio de Cortés",4955,15.1166667,-88.0333333 ],
    [ u"hn",u"San Antonio del Norte",1002,13.8833333,-87.7 ],
    [ u"hn",u"San Antonio",1151,15.6,-87.15 ],
    [ u"hn",u"San Antonio",1638,14.4333333,-88.5833333 ],
    [ u"hn",u"San Antonio",962,14.3,-89.0 ],
    [ u"hn",u"San Antonio",1711,15.3333333,-87.15 ],
    [ u"hn",u"San Buenaventura",1452,15.0166667,-88.0 ],
    [ u"hn",u"San Diego",1306,14.05,-86.4666667 ],
    [ u"hn",u"Sandy Bay",1072,16.3166667,-86.5666667 ],
    [ u"hn",u"San Esteban",3439,15.2,-85.75 ],
    [ u"hn",u"San Fernando",1026,14.6833333,-89.1166667 ],
    [ u"hn",u"San Francisco de Becerra",2411,14.6333333,-86.1 ],
    [ u"hn",u"San Francisco de Cones",1066,14.5166667,-88.9 ],
    [ u"hn",u"San Francisco de Coray",1330,13.65,-87.5333333 ],
    [ u"hn",u"San Francisco del Valle",1878,14.4333333,-88.95 ],
    [ u"hn",u"San Francisco de Ojuera",853,14.75,-88.1833333 ],
    [ u"hn",u"San Francisco de Yojoa",1946,15.0166667,-87.9666667 ],
    [ u"hn",u"San Francisco",2806,15.65,-87.05 ],
    [ u"hn",u"San Francisco",883,13.1808333,-87.0983333 ],
    [ u"hn",u"San Ignacio",2330,14.65,-87.0333333 ],
    [ u"hn",u"San Jerónimo",2381,13.1766667,-87.1363889 ],
    [ u"hn",u"San Jerónimo",1789,14.6333333,-87.6 ],
    [ u"hn",u"San Jerónimo",1046,14.9666667,-88.8666667 ],
    [ u"hn",u"San Joaquín",1130,15.05,-88.9 ],
    [ u"hn",u"San José de Colinas",3985,15.0333333,-88.3 ],
    [ u"hn",u"San José de Comayagua",1066,14.7333333,-88.0333333 ],
    [ u"hn",u"San José del Boquerón",1432,15.4833333,-87.8666667 ],
    [ u"hn",u"San José del Potrero",1091,14.8333333,-87.2833333 ],
    [ u"hn",u"San José de Oriente",888,15.0333333,-88.1166667 ],
    [ u"hn",u"San José de Pane",958,14.4833333,-87.8333333 ],
    [ u"hn",u"San José de Río Tinto",1071,14.9333333,-85.7 ],
    [ u"hn",u"San José de Tarros",1634,15.3,-88.7 ],
    [ u"hn",u"San José",1789,14.9,-88.7166667 ],
    [ u"hn",u"San José",1463,14.1166667,-87.9166667 ],
    [ u"hn",u"San José",1897,15.1166667,-87.3166667 ],
    [ u"hn",u"San Juancito",895,14.2166667,-87.0666667 ],
    [ u"hn",u"San Juan de Flores",3633,14.2666667,-87.0333333 ],
    [ u"hn",u"San Juan de Opoa",1636,14.7833333,-88.7 ],
    [ u"hn",u"San Juan de Planes",1048,14.9333333,-88.7833333 ],
    [ u"hn",u"San Juan Pueblo",5735,15.5833333,-87.2333333 ],
    [ u"hn",u"San Juan",1512,15.7333333,-87.5 ],
    [ u"hn",u"San Lorenzo",22291,13.4241667,-87.4472222 ],
    [ u"hn",u"San Lucas",1307,13.7333333,-86.95 ],
    [ u"hn",u"San Luis de Planes",1111,14.9833333,-88.1333333 ],
    [ u"hn",u"San Luis",1967,14.75,-87.4166667 ],
    [ u"hn",u"San Luis",5733,15.0833333,-88.3833333 ],
    [ u"hn",u"San Manuel",6389,15.3333333,-87.9166667 ],
    [ u"hn",u"San Marcos de Colón",8821,13.4333333,-86.8 ],
    [ u"hn",u"San Marcos",5346,14.4,-88.95 ],
    [ u"hn",u"San Marcos",3924,15.3,-88.4166667 ],
    [ u"hn",u"San Matías",1251,13.9833333,-86.6333333 ],
    [ u"hn",u"San Nicolás",976,14.7166667,-87.35 ],
    [ u"hn",u"San Nicolás",2231,15.0,-88.75 ],
    [ u"hn",u"San Nicolás",1313,14.55,-86.25 ],
    [ u"hn",u"San Nicolás",3523,14.9333333,-88.3166667 ],
    [ u"hn",u"San Pedro de Tutule",1876,14.25,-87.85 ],
    [ u"hn",u"San Pedro Sula",489506,15.5,-88.0333333 ],
    [ u"hn",u"San Pedro Zacapa",1065,14.75,-88.1166667 ],
    [ u"hn",u"San Sebastián",1471,14.25,-87.6333333 ],
    [ u"hn",u"Santa Ana de Yusguare",1823,13.3005556,-87.1138889 ],
    [ u"hn",u"Santa Ana",3579,15.65,-87.0666667 ],
    [ u"hn",u"Santa Ana",1052,13.9316667,-87.2713889 ],
    [ u"hn",u"Santa Bárbara",15121,14.9166667,-88.2333333 ],
    [ u"hn",u"Santa Cruz de Yojoa",10230,14.9833333,-87.9 ],
    [ u"hn",u"Santa Cruz",1174,13.2580556,-87.3483333 ],
    [ u"hn",u"Santa Cruz",863,14.75,-88.9833333 ],
    [ u"hn",u"Santa Cruz",1430,13.8666667,-86.6333333 ],
    [ u"hn",u"Santa Elena",1361,15.3833333,-88.1333333 ],
    [ u"hn",u"Santa Fe",915,14.5166667,-89.2333333 ],
    [ u"hn",u"Santa Lucía",2288,14.1,-87.1166667 ],
    [ u"hn",u"Santa Lucía",1224,14.4166667,-89.2 ],
    [ u"hn",u"Santa María del Real",4587,14.7666667,-85.95 ],
    [ u"hn",u"Santa Rita",2704,14.8666667,-89.1 ],
    [ u"hn",u"Santa Rita",1687,14.9166667,-88.2166667 ],
    [ u"hn",u"Santa Rita",12871,15.1666667,-87.2833333 ],
    [ u"hn",u"Santa Rosa de Aguán",1304,15.95,-85.7166667 ],
    [ u"hn",u"Santa Rosa de Copán",27756,14.7666667,-88.7833333 ],
    [ u"hn",u"Santa Teresa",914,14.3833333,-89.0 ],
    [ u"hn",u"Santiago de Puringla",2433,14.35,-87.9 ],
    [ u"hn",u"San Vicente Centenario",2430,14.8833333,-88.2833333 ],
    [ u"hn",u"Savannah Bight",1031,16.45,-85.85 ],
    [ u"hn",u"Sensenti",1551,14.4833333,-88.9333333 ],
    [ u"hn",u"Siguatepeque",43146,14.6,-87.8333333 ],
    [ u"hn",u"Silca",1112,14.8333333,-86.5333333 ],
    [ u"hn",u"Sinuapa",2389,14.45,-89.1833333 ],
    [ u"hn",u"Sonaguera",11444,15.6333333,-86.3333333 ],
    [ u"hn",u"Subirana",1362,15.2,-87.45 ],
    [ u"hn",u"Sulaco",2760,14.9166667,-87.2666667 ],
    [ u"hn",u"Sula",2502,15.25,-88.5666667 ],
    [ u"hn",u"Suyapa de Lean",941,15.5166667,-87.4 ],
    [ u"hn",u"Talanga",13492,14.4,-87.0833333 ],
    [ u"hn",u"Támara",2683,14.15,-87.3333333 ],
    [ u"hn",u"Taragual",1043,14.75,-88.4833333 ],
    [ u"hn",u"Taujica",1271,15.7,-85.9166667 ],
    [ u"hn",u"Taulabé",4660,14.7,-87.9666667 ],
    [ u"hn",u"Teguajinal",1117,15.3666667,-86.6 ],
    [ u"hn",u"Tegucigalpa",850961,14.1,-87.2166667 ],
    [ u"hn",u"Tela",29329,15.7833333,-87.45 ],
    [ u"hn",u"Tepanguare",1040,14.3333333,-87.75 ],
    [ u"hn",u"Tepusteca",1638,15.4166667,-86.3166667 ],
    [ u"hn",u"Teupasenti",4208,14.2166667,-86.7 ],
    [ u"hn",u"Texíguat",1012,13.6497222,-87.0225 ],
    [ u"hn",u"Tocoa",30789,15.6833333,-86.0 ],
    [ u"hn",u"Toloa Adentro",981,15.6166667,-87.7166667 ],
    [ u"hn",u"Tornabé",1452,15.75,-87.55 ],
    [ u"hn",u"Toyós",2530,15.55,-87.65 ],
    [ u"hn",u"Travesía",1283,15.8666667,-87.9 ],
    [ u"hn",u"Trinidad de Copán",2232,14.95,-88.75 ],
    [ u"hn",u"Trinidad de Quebradas",1405,14.5,-87.35 ],
    [ u"hn",u"Trinidad",4276,15.1333333,-88.2333333 ],
    [ u"hn",u"Trojas",1068,15.35,-86.7 ],
    [ u"hn",u"Trojes",6253,14.0666667,-85.9833333 ],
    [ u"hn",u"Trujillo",9647,15.9166667,-86.0 ],
    [ u"hn",u"Urraco",5711,15.2333333,-87.85 ],
    [ u"hn",u"Urrutia",799,14.75,-87.0333333 ],
    [ u"hn",u"Utilá",1834,15.65,-86.35 ],
    [ u"hn",u"Vallecillo",1986,14.5166667,-87.4 ],
    [ u"hn",u"Valle de Ángeles",1101,14.5,-87.6333333 ],
    [ u"hn",u"Valle de Ángeles",4649,14.15,-87.0333333 ],
    [ u"hn",u"Veracruz",1045,14.9166667,-88.7833333 ],
    [ u"hn",u"Victoria",2884,15.4833333,-87.8166667 ],
    [ u"hn",u"Villa de San Antonio",5390,14.3166667,-87.6166667 ],
    [ u"hn",u"Villa de San Francisco",5914,14.1666667,-86.9666667 ],
    [ u"hn",u"Villanueva",31570,15.3166667,-88.0 ],
    [ u"hn",u"Villa Nueva",2295,14.0166667,-87.15 ],
    [ u"hn",u"Vivistorio",949,14.9,-88.7333333 ],
    [ u"hn",u"Waksma",969,15.4333333,-84.4 ],
    [ u"hn",u"Wampusirpi",1462,15.1833333,-84.6166667 ],
    [ u"hn",u"Wawina",1481,15.4166667,-84.4333333 ],
    [ u"hn",u"Yaguacire",1449,14.0166667,-87.2166667 ],
    [ u"hn",u"Yamaranguila",1187,14.2833333,-88.25 ],
    [ u"hn",u"Yaruchel",1105,14.5333333,-88.8166667 ],
    [ u"hn",u"Yarumela",3059,14.3333333,-87.6333333 ],
    [ u"hn",u"Yorito",2169,15.0666667,-87.2833333 ],
    [ u"hn",u"Yoro",15776,15.1333333,-87.1333333 ],
    [ u"hn",u"Yuscarán",2371,13.9333333,-86.85 ],
    [ u"hn",u"Zambrano",3873,14.2666667,-87.4 ],
    [ u"hn",u"Zamora",2999,15.6333333,-86.0666667 ],
    [ u"hn",u"Zapotal del Norte",2507,15.5166667,-88.05 ],
    [ u"hn",u"Zopilotepe",1300,14.6,-86.2666667 ],
    [ u"hr",u"Beli Manastir",8713,45.77,18.6036111 ],
    [ u"hr",u"Biograd na Moru",5285,43.9433333,15.4519444 ],
    [ u"hr",u"Bjelovar",28275,45.8986111,16.8488889 ],
    [ u"hr",u"Buje",3016,45.41,13.6619444 ],
    [ u"hr",u"Cakovec",15867,46.3844444,16.4338889 ],
    [ u"hr",u"Dubrovnik",28428,42.6505556,18.0913889 ],
    [ u"hr",u"Gospic",6118,44.5461111,15.3747222 ],
    [ u"hr",u"Gracac",2702,44.2986111,15.8444444 ],
    [ u"hr",u"Karlovac",48123,45.4872222,15.5477778 ],
    [ u"hr",u"Knin",11182,44.0438889,16.2 ],
    [ u"hr",u"Koprivnica",25579,46.1627778,16.8275 ],
    [ u"hr",u"Korcula",3141,42.9622222,17.1369444 ],
    [ u"hr",u"Krapina",4725,46.1608333,15.8788889 ],
    [ u"hr",u"Krizevci",11597,46.0219444,16.5425 ],
    [ u"hr",u"Krk",3380,45.0258333,14.5730556 ],
    [ u"hr",u"Kutina",14886,45.475,16.7819444 ],
    [ u"hr",u"Makarska",13446,43.2969444,17.0177778 ],
    [ u"hr",u"Metkovic",13941,43.0541667,17.6483333 ],
    [ u"hr",u"Nasice",8213,45.4886111,18.0877778 ],
    [ u"hr",u"Nova Gradiska",13329,45.255,17.3830556 ],
    [ u"hr",u"Novska",7306,45.3405556,16.9769444 ],
    [ u"hr",u"Ogulin",8755,45.2661111,15.2286111 ],
    [ u"hr",u"Omis",6597,43.4447222,16.6886111 ],
    [ u"hr",u"Opatija",7888,45.3391667,14.3083333 ],
    [ u"hr",u"Osijek",88141,45.5511111,18.6938889 ],
    [ u"hr",u"Pag",2714,44.445,15.0575 ],
    [ u"hr",u"Petrinja",13868,45.4375,16.29 ],
    [ u"hr",u"Porec",10499,45.2258333,13.5938889 ],
    [ u"hr",u"Pozega",21153,45.3402778,17.6852778 ],
    [ u"hr",u"Pula",59079,44.8683333,13.8480556 ],
    [ u"hr",u"Rab",557,44.7569444,14.7608333 ],
    [ u"hr",u"Rijeka",141173,45.3430556,14.4091667 ],
    [ u"hr",u"Rovinj",13533,45.08,13.64 ],
    [ u"hr",u"Senj",5518,44.9894444,14.9058333 ],
    [ u"hr",u"Sesvete",52412,45.8311111,16.1163889 ],
    [ u"hr",u"Sibenik",37113,43.7272222,15.9058333 ],
    [ u"hr",u"Sinj",11524,43.7036111,16.6394444 ],
    [ u"hr",u"Sisak",35749,45.4661111,16.3783333 ],
    [ u"hr",u"Slatina",10973,45.7033333,17.7027778 ],
    [ u"hr",u"Slavonski Brod",60742,45.1602778,18.0155556 ],
    [ u"hr",u"Solin",15927,43.55,16.5 ],
    [ u"hr",u"Split",176315,43.5138889,16.4558333 ],
    [ u"hr",u"Trogir",10960,43.5125,16.2516667 ],
    [ u"hr",u"Varazdin",41808,46.3044444,16.3377778 ],
    [ u"hr",u"Velika Gorica",35073,45.7125,16.0755556 ],
    [ u"hr",u"Vinkovci",33315,45.2883333,18.8047222 ],
    [ u"hr",u"Virovitica",15665,45.8319444,17.3838889 ],
    [ u"hr",u"Vukovar",29584,45.3433333,18.9997222 ],
    [ u"hr",u"Zadar",71258,44.1197222,15.2422222 ],
    [ u"hr",u"Zagreb",698967,45.8,16.0 ],
    [ u"hr",u"Zapresic",17624,45.8563889,15.8077778 ],
    [ u"hr",u"Zupanja",13842,45.0775,18.6975 ],
    [ u"ht",u"Aquin",5219,18.2833333,-73.4 ],
    [ u"ht",u"Cap-Haïtien",134823,19.7577778,-72.2041667 ],
    [ u"ht",u"Carrefour",439590,18.5383333,-72.4122222 ],
    [ u"ht",u"Delmas",377194,18.5447222,-72.3027778 ],
    [ u"ht",u"Dérac",1808,19.65,-71.8166667 ],
    [ u"ht",u"Desdunes",12990,19.2833333,-72.65 ],
    [ u"ht",u"Dessalines",12313,19.2833333,-72.5 ],
    [ u"ht",u"Gonaïves",84966,19.45,-72.6833333 ],
    [ u"ht",u"Grande Rivière du Nord",8826,19.5833333,-72.1833333 ],
    [ u"ht",u"Hinche",18580,19.15,-72.0166667 ],
    [ u"ht",u"Jacmel",33569,18.2341667,-72.5347222 ],
    [ u"ht",u"Jeremie",30920,18.6166667,-74.0833333 ],
    [ u"ht",u"Kenscoff",5176,18.4505556,-72.2869444 ],
    [ u"ht",u"Lascahobas",7564,18.8294444,-71.9363889 ],
    [ u"ht",u"Léogâne",11545,18.5108333,-72.6338889 ],
    [ u"ht",u"Les Cayes",59323,18.2,-73.75 ],
    [ u"ht",u"Limbé",32652,19.7,-72.4 ],
    [ u"ht",u"Miragoâne",6009,18.45,-73.1 ],
    [ u"ht",u"Mirebalais",9088,18.8333333,-72.1052778 ],
    [ u"ht",u"Ouanaminthe",10152,19.55,-71.7333333 ],
    [ u"ht",u"Pétionville",108235,18.5125,-72.2852778 ],
    [ u"ht",u"Petit Goâve",14531,18.4313889,-72.8669444 ],
    [ u"ht",u"Pignon",6766,19.3333333,-72.1166667 ],
    [ u"ht",u"Port-au-Prince",1234750,18.5391667,-72.335 ],
    [ u"ht",u"Port-de-Paix",34659,19.95,-72.8333333 ],
    [ u"ht",u"Saint-Marc",66230,19.1166667,-72.7 ],
    [ u"ht",u"Saint-Raphaël",6002,19.4333333,-72.2 ],
    [ u"ht",u"Verrettes",48811,19.05,-72.4666667 ],
    [ u"hu",u"Aba",4479,47.029072,18.521721 ],
    [ u"hu",u"Abádszalók",4654,47.466667,20.6 ],
    [ u"hu",u"Abasár",3189,47.797049,20.003236 ],
    [ u"hu",u"Abaújszántó",3366,48.283333,21.2 ],
    [ u"hu",u"Abda",2997,47.694641,17.544885 ],
    [ u"hu",u"Abony",16342,47.1899,20.004759 ],
    [ u"hu",u"Ács",7180,47.712314,18.011313 ],
    [ u"hu",u"Adács",2890,47.6921,19.976956 ],
    [ u"hu",u"Ádánd",2306,46.85931,18.164423 ],
    [ u"hu",u"Adony",3812,47.119398,18.864929 ],
    [ u"hu",u"Ágasegyháza",1898,46.840255,19.452077 ],
    [ u"hu",u"Ágfalva",1971,47.68991,16.516576 ],
    [ u"hu",u"Ajak",3983,48.176636,22.062734 ],
    [ u"hu",u"Ajka",31407,47.101963,17.558923 ],
    [ u"hu",u"Akasztó",3480,46.691667,19.204233 ],
    [ u"hu",u"Alap",2149,46.799145,18.689383 ],
    [ u"hu",u"Alattyán",2004,47.427051,20.042195 ],
    [ u"hu",u"Albertirsa",11864,47.243147,19.616858 ],
    [ u"hu",u"Almasfuzito",2348,47.727519,18.265382 ],
    [ u"hu",u"Alsónémedi",4974,47.315243,19.158426 ],
    [ u"hu",u"Alsózsolca",6107,48.066667,20.883333 ],
    [ u"hu",u"Anarcs",2021,48.176423,22.111671 ],
    [ u"hu",u"Andornaktálya",2636,47.85,20.416667 ],
    [ u"hu",u"Apagy",2348,47.964305,21.935387 ],
    [ u"hu",u"Apátfalva",3268,46.166667,20.583333 ],
    [ u"hu",u"Apc",2754,47.794194,19.694289 ],
    [ u"hu",u"Apostag",2099,46.882079,18.962102 ],
    [ u"hu",u"Aranyosapáti",2142,48.205949,22.259163 ],
    [ u"hu",u"Arló",4129,48.183333,20.266667 ],
    [ u"hu",u"Arnót",2493,48.133333,20.866667 ],
    [ u"hu",u"Ásotthalom",4134,46.198752,19.783342 ],
    [ u"hu",u"Ásványráró",1985,47.832358,17.503532 ],
    [ u"hu",u"Aszaló",2008,48.216667,20.966667 ],
    [ u"hu",u"Aszód",6184,47.653902,19.498001 ],
    [ u"hu",u"Babócsa",1877,46.041546,17.343316 ],
    [ u"hu",u"Bábolna",3885,47.643612,17.977979 ],
    [ u"hu",u"Bácsalmás",7608,46.12648,19.332596 ],
    [ u"hu",u"Bácsbokod",3077,46.124996,19.156207 ],
    [ u"hu",u"Badacsonytomaj",2271,46.807114,17.513846 ],
    [ u"hu",u"Bagamér",2433,47.448816,21.989005 ],
    [ u"hu",u"Bag",4071,47.633333,19.483333 ],
    [ u"hu",u"Baja",37714,46.174957,18.956388 ],
    [ u"hu",u"Baj",2664,47.645931,18.364097 ],
    [ u"hu",u"Bajna",2024,47.654002,18.597205 ],
    [ u"hu",u"Bakonycsernye",3177,47.323948,18.075088 ],
    [ u"hu",u"Bakonyszentlászló",1913,47.389008,17.803212 ],
    [ u"hu",u"Baks",2292,46.54297,20.102127 ],
    [ u"hu",u"Baktalórántháza",4265,48,22.083333 ],
    [ u"hu",u"Balassagyarmat",17541,48.07296,19.296138 ],
    [ u"hu",u"Balástya",3564,46.422772,20.008158 ],
    [ u"hu",u"Balatonalmádi",8364,47.03526,18.020763 ],
    [ u"hu",u"Balatonboglár",5964,46.775247,17.644145 ],
    [ u"hu",u"Balatonfenyves",1885,46.715423,17.492226 ],
    [ u"hu",u"Balatonföldvár",2069,46.852549,17.881227 ],
    [ u"hu",u"Balatonfüred",13054,46.96188,17.871866 ],
    [ u"hu",u"Balatonfuzfo",4260,47.063241,18.046895 ],
    [ u"hu",u"Balatonkenese",3326,47.040186,18.106709 ],
    [ u"hu",u"Balatonlelle",4910,46.783182,17.694983 ],
    [ u"hu",u"Balatonszabadi",2838,46.893975,18.137375 ],
    [ u"hu",u"Balatonszárszó",1992,46.829455,17.824258 ],
    [ u"hu",u"Balkány",6798,47.766667,21.866667 ],
    [ u"hu",u"Ballószög",2753,46.862155,19.570924 ],
    [ u"hu",u"Balmazújváros",18012,47.616667,21.35 ],
    [ u"hu",u"Bánd",641,47.123235,17.776729 ],
    [ u"hu",u"Baracs",3294,46.882015,18.906583 ],
    [ u"hu",u"Baracska",2701,47.282249,18.758535 ],
    [ u"hu",u"Báránd",2728,47.3,21.233333 ],
    [ u"hu",u"Barcs",12116,45.96,17.458611 ],
    [ u"hu",u"Báta",1891,46.128641,18.770267 ],
    [ u"hu",u"Bátaszék",6820,46.193726,18.723074 ],
    [ u"hu",u"Bátonyterenye",14214,47.969618,19.840757 ],
    [ u"hu",u"Battonya",6604,46.283333,21.016667 ],
    [ u"hu",u"Bátya",2190,46.487997,18.954188 ],
    [ u"hu",u"Becsehely",2255,46.447551,16.777103 ],
    [ u"hu",u"Bekecs",2446,48.15,21.183333 ],
    [ u"hu",u"Békés",21198,46.766667,21.133333 ],
    [ u"hu",u"Békéscsaba",65956,46.683333,21.1 ],
    [ u"hu",u"Békéssámson",2581,46.416667,20.633333 ],
    [ u"hu",u"Békésszentandrás",4103,46.866667,20.483333 ],
    [ u"hu",u"Bélapátfalva",3401,48.05,20.366667 ],
    [ u"hu",u"Beled",2933,47.465936,17.092936 ],
    [ u"hu",u"Bercel",1991,47.87057,19.407149 ],
    [ u"hu",u"Beremend",2775,45.791084,18.432628 ],
    [ u"hu",u"Berettyóújfalu",16090,47.216667,21.55 ],
    [ u"hu",u"Berhida",5822,47.111313,18.129478 ],
    [ u"hu",u"Berzence",2694,46.209075,17.148103 ],
    [ u"hu",u"Besenyotelek",2847,47.7,20.433333 ],
    [ u"hu",u"Besenyszög",3460,47.3,20.266667 ],
    [ u"hu",u"Biatorbágy",8632,47.4706,18.818915 ],
    [ u"hu",u"Bicske",11072,47.484189,18.644038 ],
    [ u"hu",u"Biharkeresztes",4237,47.133333,21.716667 ],
    [ u"hu",u"Biharnagybajom",2936,47.216667,21.233333 ],
    [ u"hu",u"Bocs",2677,48.05,20.966667 ],
    [ u"hu",u"Bodajk",4069,47.32352,18.233119 ],
    [ u"hu",u"Bogács",2112,47.9,20.533333 ],
    [ u"hu",u"Bogyiszló",2348,46.386378,18.829621 ],
    [ u"hu",u"Böhönye",2437,46.413447,17.380365 ],
    [ u"hu",u"Bokod",2229,47.491862,18.24743 ],
    [ u"hu",u"Bököny",3310,47.733333,21.75 ],
    [ u"hu",u"Bölcske",2946,46.741023,18.967357 ],
    [ u"hu",u"Boldog",3131,47.602855,19.688388 ],
    [ u"hu",u"Boldva",2456,48.216667,20.8 ],
    [ u"hu",u"Bóly",3642,45.967222,18.518333 ],
    [ u"hu",u"Bony",2225,47.65,17.869772 ],
    [ u"hu",u"Bonyhád",14184,46.3,18.52905 ],
    [ u"hu",u"Bordány",3097,46.31843,19.923058 ],
    [ u"hu",u"Borsodnádasd",3546,48.116667,20.25 ],
    [ u"hu",u"Bosarkany",2208,47.688205,17.25 ],
    [ u"hu",u"Bucsa",2479,47.2,21 ],
    [ u"hu",u"Budakalász",9696,47.616667,19.05 ],
    [ u"hu",u"Budakeszi",13248,47.510832,18.927171 ],
    [ u"hu",u"Budaörs",25089,47.460614,18.96434 ],
    [ u"hu",u"Budapest",1708088,47.5,19.083333 ],
    [ u"hu",u"Bugac",3066,46.687039,19.680739 ],
    [ u"hu",u"Bugyi",5412,47.227478,19.146645 ],
    [ u"hu",u"Buják",2343,47.883523,19.543813 ],
    [ u"hu",u"Buj",2496,48.1,21.65 ],
    [ u"hu",u"Bük",3174,47.38486,16.750654 ],
    [ u"hu",u"Cece",2843,46.76885,18.633219 ],
    [ u"hu",u"Ceglédbercel",4710,47.223696,19.66828 ],
    [ u"hu",u"Cegléd",39287,47.172663,19.799524 ],
    [ u"hu",u"Celldömölk",11421,47.257125,17.150274 ],
    [ u"hu",u"Cibakháza",4565,46.959761,20.197533 ],
    [ u"hu",u"Cigánd",3245,48.255613,21.891946 ],
    [ u"hu",u"Csabacsud",2085,46.833333,20.65 ],
    [ u"hu",u"Csabrendek",2948,47.013558,17.291083 ],
    [ u"hu",u"Csákvár",5259,47.393174,18.46044 ],
    [ u"hu",u"Csanádapáca",2811,46.55,20.883333 ],
    [ u"hu",u"Csanádpalota",3224,46.25,20.733333 ],
    [ u"hu",u"Csány",2279,47.648287,19.829716 ],
    [ u"hu",u"Csanytelek",2937,46.595005,20.123419 ],
    [ u"hu",u"Császár",1922,47.498001,18.142719 ],
    [ u"hu",u"Császártöltés",2649,46.421944,19.183611 ],
    [ u"hu",u"Csávoly",2080,46.189167,19.146667 ],
    [ u"hu",u"Csemo",4411,47.117993,19.690923 ],
    [ u"hu",u"Csengele",2004,46.542336,19.863584 ],
    [ u"hu",u"Csenger",5225,47.835822,22.680956 ],
    [ u"hu",u"Csengod",2291,46.715434,19.268024 ],
    [ u"hu",u"Csepreg",3568,47.400982,16.708814 ],
    [ u"hu",u"Cserkeszolo",2182,46.863199,20.187009 ],
    [ u"hu",u"Cserszegtomaj",1941,46.80165,17.220957 ],
    [ u"hu",u"Csetény",2039,47.318059,17.992076 ],
    [ u"hu",u"Csobánka",2881,47.644599,18.967226 ],
    [ u"hu",u"Csokmo",2170,47.033333,21.3 ],
    [ u"hu",u"Csolnok",3381,47.691155,18.716109 ],
    [ u"hu",u"Csömör",7544,47.55,19.233333 ],
    [ u"hu",u"Csongrád",18580,46.713319,20.142415 ],
    [ u"hu",u"Csorna",10825,47.611552,17.250122 ],
    [ u"hu",u"Csorvás",5643,46.633333,20.833333 ],
    [ u"hu",u"Csurgó",5682,46.253139,17.100604 ],
    [ u"hu",u"Dabas",16590,47.185938,19.310908 ],
    [ u"hu",u"Dánszentmiklós",2838,47.214859,19.546954 ],
    [ u"hu",u"Dány",4378,47.519998,19.544004 ],
    [ u"hu",u"Dávod",2240,45.995,18.917222 ],
    [ u"hu",u"Debrecen",204825,47.533333,21.633333 ],
    [ u"hu",u"Decs",4210,46.284285,18.760005 ],
    [ u"hu",u"Dég",2354,46.868068,18.45042 ],
    [ u"hu",u"Délegyháza",2506,47.241351,19.090186 ],
    [ u"hu",u"Demecser",4558,48.111085,21.917491 ],
    [ u"hu",u"Derecske",9207,47.35,21.566667 ],
    [ u"hu",u"Deszk",3245,46.218024,20.243217 ],
    [ u"hu",u"Dévaványa",8796,47.033333,20.966667 ],
    [ u"hu",u"Devecser",5140,47.103163,17.438023 ],
    [ u"hu",u"Diósd",6168,47.409497,18.948976 ],
    [ u"hu",u"Diosjeno",2746,47.939683,19.043174 ],
    [ u"hu",u"Doboz",4466,46.733333,21.25 ],
    [ u"hu",u"Döbrököz",2120,46.42178,18.239525 ],
    [ u"hu",u"Döge",2181,48.262459,22.063388 ],
    [ u"hu",u"Domaszék",4242,46.249167,20.011111 ],
    [ u"hu",u"Dombegyház",2380,46.333333,21.133333 ],
    [ u"hu",u"Dombóvár",20748,46.376568,18.136962 ],
    [ u"hu",u"Dombrád",4276,48.233333,21.933333 ],
    [ u"hu",u"Domony",2031,47.65552,19.432286 ],
    [ u"hu",u"Domoszló",2105,47.833333,20.116667 ],
    [ u"hu",u"Dömsöd",5942,47.090047,19.011058 ],
    [ u"hu",u"Dorog",12658,47.72095,18.736405 ],
    [ u"hu",u"Dunabogdány",3059,47.790517,19.041247 ],
    [ u"hu",u"Dunaföldvár",9073,46.807995,18.926385 ],
    [ u"hu",u"Dunaharaszti",16973,47.354495,19.098223 ],
    [ u"hu",u"Dunakeszi",30246,47.636405,19.13864 ],
    [ u"hu",u"Dunapataj",3693,46.643997,18.996321 ],
    [ u"hu",u"Dunaszekcso",2151,46.086631,18.758647 ],
    [ u"hu",u"Dunaszentgyörgy",2624,46.528522,18.81771 ],
    [ u"hu",u"Dunaújváros",53396,46.980651,18.932674 ],
    [ u"hu",u"Dunavarsány",6016,47.278588,19.066168 ],
    [ u"hu",u"Dunavecse",4201,46.914068,18.974332 ],
    [ u"hu",u"Dusnok",3284,46.390852,18.962955 ],
    [ u"hu",u"Ebes",4468,47.466667,21.5 ],
    [ u"hu",u"Ecséd",3457,47.732667,19.766962 ],
    [ u"hu",u"Ecser",3333,47.443893,19.324505 ],
    [ u"hu",u"Edelény",11037,48.3,20.733333 ],
    [ u"hu",u"Eger",56302,47.9,20.383333 ],
    [ u"hu",u"Egerszalók",1952,47.866667,20.333333 ],
    [ u"hu",u"Egyek",5573,47.633333,20.9 ],
    [ u"hu",u"Elek",5465,46.533333,21.25 ],
    [ u"hu",u"Eloszallas",2556,46.830945,18.834809 ],
    [ u"hu",u"Emod",5382,47.933333,20.816667 ],
    [ u"hu",u"Encs",6886,48.333333,21.133333 ],
    [ u"hu",u"Encsencs",2087,47.733333,22.116667 ],
    [ u"hu",u"Enying",7171,46.930465,18.242019 ],
    [ u"hu",u"Ercsi",8383,47.251944,18.89623 ],
    [ u"hu",u"Érd",59242,47.394886,18.913605 ],
    [ u"hu",u"Erdokertes",5996,47.672609,19.30786 ],
    [ u"hu",u"Erdotelek",3443,47.683333,20.316667 ],
    [ u"hu",u"Érsekcsanád",2863,46.253522,18.98457 ],
    [ u"hu",u"Érsekvadkert",3762,47.996187,19.202312 ],
    [ u"hu",u"Esztergom",28785,47.7928,18.741476 ],
    [ u"hu",u"Etyek",3626,47.44794,18.753278 ],
    [ u"hu",u"Fábiánháza",1919,47.847591,22.35346 ],
    [ u"hu",u"Fábiánsebestyén",2276,46.683333,20.466667 ],
    [ u"hu",u"Fadd",4442,46.464764,18.819246 ],
    [ u"hu",u"Farád",1936,47.606333,17.200244 ],
    [ u"hu",u"Farkaslyuk",1922,48.183333,20.316667 ],
    [ u"hu",u"Farmos",3793,47.360671,19.846193 ],
    [ u"hu",u"Fegyvernek",6972,47.266667,20.533333 ],
    [ u"hu",u"Fehérgyarmat",9031,47.983333,22.516667 ],
    [ u"hu",u"Fehérvárcsurgó",1886,47.293147,18.26474 ],
    [ u"hu",u"Felsopakony",3040,47.343285,19.236984 ],
    [ u"hu",u"Felsoszentivan",1998,46.197127,19.186855 ],
    [ u"hu",u"Felsotarkany",3223,47.966667,20.416667 ],
    [ u"hu",u"Felsozsolca",7040,48.1,20.866667 ],
    [ u"hu",u"Fényeslitke",2425,48.271333,22.100091 ],
    [ u"hu",u"Fertod",3396,47.619469,16.886764 ],
    [ u"hu",u"Fertorakos",2179,47.71411,16.655207 ],
    [ u"hu",u"Fertoszentmiklos",3877,47.583476,16.879679 ],
    [ u"hu",u"Földeák",3255,46.316667,20.5 ],
    [ u"hu",u"Földes",4345,47.3,21.366667 ],
    [ u"hu",u"Fonyód",5199,46.755525,17.579452 ],
    [ u"hu",u"Forráskút",2287,46.36528,19.90973 ],
    [ u"hu",u"Forró",2473,47.455044,19.660005 ],
    [ u"hu",u"Fót",16770,47.617703,19.188701 ],
    [ u"hu",u"Fülöpszállás",2503,46.820752,19.237483 ],
    [ u"hu",u"Füzesabony",8182,47.75,20.416667 ],
    [ u"hu",u"Füzesgyarmat",6426,47.1,21.216667 ],
    [ u"hu",u"Gádoros",4008,46.666667,20.6 ],
    [ u"hu",u"Galgahéviz",2641,47.616667,19.566667 ],
    [ u"hu",u"Galgamácsa",2061,47.695622,19.387235 ],
    [ u"hu",u"Gara",2656,46.031944,19.042778 ],
    [ u"hu",u"Gárdony",8105,47.209063,18.64491 ],
    [ u"hu",u"Gégény",2093,48.15,21.95 ],
    [ u"hu",u"Gencsapáti",2580,47.281478,16.597928 ],
    [ u"hu",u"Gesztely",2839,48.1,20.966667 ],
    [ u"hu",u"Göd",15874,47.683241,19.134171 ],
    [ u"hu",u"Godollo",32374,47.596574,19.355151 ],
    [ u"hu",u"Gödre",957,46.286117,17.972883 ],
    [ u"hu",u"Gomba",2861,47.37095,19.530573 ],
    [ u"hu",u"Gönc",2217,48.466667,21.283333 ],
    [ u"hu",u"Gonyu",3021,47.733654,17.828836 ],
    [ u"hu",u"Görbeháza",2626,47.833333,21.233333 ],
    [ u"hu",u"Gyál",21937,47.384493,19.221395 ],
    [ u"hu",u"Gyenesdiás",2796,46.770585,17.286603 ],
    [ u"hu",u"Gyomaendrod",15194,46.933333,20.833333 ],
    [ u"hu",u"Gyomro",14155,47.427327,19.401333 ],
    [ u"hu",u"Gyöngyös",32938,47.782571,19.928003 ],
    [ u"hu",u"Gyöngyöshalász",2585,47.741613,19.928764 ],
    [ u"hu",u"Gyöngyöspata",2724,47.815049,19.789245 ],
    [ u"hu",u"Gyöngyössolymos",3160,47.817238,19.936188 ],
    [ u"hu",u"Gyöngyöstarján",2463,47.813688,19.867242 ],
    [ u"hu",u"Gyönk",2148,46.557145,18.477029 ],
    [ u"hu",u"Gyor",129009,47.687281,17.637616 ],
    [ u"hu",u"Gyorszemere",2964,47.552558,17.563561 ],
    [ u"hu",u"Gyorujbarat",4603,47.606425,17.648751 ],
    [ u"hu",u"Gyula",32269,46.65,21.283333 ],
    [ u"hu",u"Gyulaháza",2059,48.133333,22.116667 ],
    [ u"hu",u"Hajdubagos",1959,47.4,21.666667 ],
    [ u"hu",u"Hajdúböszörmény",31957,47.666667,21.516667 ],
    [ u"hu",u"Hajdúdorog",9514,47.816667,21.5 ],
    [ u"hu",u"Hajdúhadház",12892,47.683333,21.666667 ],
    [ u"hu",u"Hajdúnánás",18032,47.85,21.433333 ],
    [ u"hu",u"Hajdúsámson",10854,47.6,21.766667 ],
    [ u"hu",u"Hajdúszoboszló",23496,47.45,21.4 ],
    [ u"hu",u"Hajdúszovát",3167,47.383333,21.483333 ],
    [ u"hu",u"Hajmáskér",2793,47.147189,18.022931 ],
    [ u"hu",u"Hajós",3520,46.398611,19.120556 ],
    [ u"hu",u"Halászi",2850,47.889301,17.326147 ],
    [ u"hu",u"Halásztelek",7245,47.361733,18.981191 ],
    [ u"hu",u"Halmaj",1869,48.25,21 ],
    [ u"hu",u"Harkány",3450,45.850016,18.236679 ],
    [ u"hu",u"Harsány",2059,47.966667,20.75 ],
    [ u"hu",u"Harta",3716,46.698465,19.030532 ],
    [ u"hu",u"Hatvan",22710,47.666667,19.683333 ],
    [ u"hu",u"Hegyeshalom",3507,47.508101,20.032932 ],
    [ u"hu",u"Hejobaba",1949,47.9,20.95 ],
    [ u"hu",u"Helvécia",3918,46.836614,19.622512 ],
    [ u"hu",u"Hercegszántó",2308,45.95,18.939167 ],
    [ u"hu",u"Heréd",2039,47.706377,19.633142 ],
    [ u"hu",u"Herend",3385,47.133333,17.75 ],
    [ u"hu",u"Hernád",3689,47.162384,19.432952 ],
    [ u"hu",u"Hernádnémeti",3629,48.066667,20.983333 ],
    [ u"hu",u"Heves",11311,47.6,20.283333 ],
    [ u"hu",u"Hévizgyörk",3101,47.627241,19.521141 ],
    [ u"hu",u"Hévíz",4439,46.788778,17.183333 ],
    [ u"hu",u"Hidas",2274,46.257763,18.49526 ],
    [ u"hu",u"Hodász",3489,47.918339,22.201534 ],
    [ u"hu",u"Hodmezovasarhely",47699,46.416667,20.333333 ],
    [ u"hu",u"Hogyesz",3029,46.495902,18.420875 ],
    [ u"hu",u"Hort",3797,47.689435,19.788663 ],
    [ u"hu",u"Hortobágy",1745,47.583333,21.166667 ],
    [ u"hu",u"Hosszúhetény",3299,46.161214,18.354379 ],
    [ u"hu",u"Hosszúpályi",5478,47.4,21.75 ],
    [ u"hu",u"Ibrány",6880,48.133333,21.716667 ],
    [ u"hu",u"Iklad",2194,47.665335,19.436104 ],
    [ u"hu",u"Inárcs",4262,47.262001,19.327 ],
    [ u"hu",u"Iregszemcse",2772,46.692857,18.185813 ],
    [ u"hu",u"Isaszeg",10754,47.530111,19.402054 ],
    [ u"hu",u"Iváncsa",2807,47.156704,18.820298 ],
    [ u"hu",u"Izsák",6117,46.804542,19.351723 ],
    [ u"hu",u"Izsófalva",1871,48.3,20.666667 ],
    [ u"hu",u"Ják",2310,47.142495,16.581478 ],
    [ u"hu",u"Jánoshalma",9755,46.298611,19.325833 ],
    [ u"hu",u"Jánosháza",2754,47.119367,17.165031 ],
    [ u"hu",u"Jánoshida",2709,47.383333,20.066667 ],
    [ u"hu",u"Jánossomorja",5985,47.786207,17.136033 ],
    [ u"hu",u"Járdánháza",1938,48.15,20.25 ],
    [ u"hu",u"Jászalsószentgyörgy",3777,47.366667,20.1 ],
    [ u"hu",u"Jászapáti",9806,47.516667,20.15 ],
    [ u"hu",u"Jászárokszállás",8107,47.642375,19.980382 ],
    [ u"hu",u"Jászberény",27835,47.5,19.916667 ],
    [ u"hu",u"Jászdózsa",2225,47.566096,20.015335 ],
    [ u"hu",u"Jászjákóhalma",3088,47.520379,19.990863 ],
    [ u"hu",u"Jaszkarajeno",3125,47.05,20.066667 ],
    [ u"hu",u"Jászkisér",5741,47.45,20.216667 ],
    [ u"hu",u"Jászladány",6215,47.366667,20.166667 ],
    [ u"hu",u"Jászszentandrás",2640,47.583333,20.183333 ],
    [ u"hu",u"Jászszentlászló",2602,46.566854,19.760649 ],
    [ u"hu",u"Jobbágyi",2329,47.832381,19.677622 ],
    [ u"hu",u"Kaba",6392,47.35,21.283333 ],
    [ u"hu",u"Kadarkút",2740,46.236232,17.620138 ],
    [ u"hu",u"Kakucs",2707,47.242005,19.364668 ],
    [ u"hu",u"Kál",3683,47.733333,20.266667 ],
    [ u"hu",u"Kállósemjén",3968,47.86081,21.939285 ],
    [ u"hu",u"Kálmánháza",2086,47.883333,21.583333 ],
    [ u"hu",u"Kalocsa",18242,46.526389,18.985833 ],
    [ u"hu",u"Káloz",2527,46.954645,18.482588 ],
    [ u"hu",u"Kántorjánosi",2244,47.933333,22.15 ],
    [ u"hu",u"Kápolnásnyék",3224,47.240037,18.675636 ],
    [ u"hu",u"Kaposmero",2506,46.361672,17.703997 ],
    [ u"hu",u"Kaposvár",66947,46.366667,17.8 ],
    [ u"hu",u"Kapuvár",10661,47.592235,17.028857 ],
    [ u"hu",u"Karácsond",3132,47.729621,20.030763 ],
    [ u"hu",u"Karád",1733,46.690758,17.841356 ],
    [ u"hu",u"Karancskeszi",1924,48.163526,19.696859 ],
    [ u"hu",u"Karancslapujto",2845,48.15,19.733333 ],
    [ u"hu",u"Karcag",22370,47.316667,20.933333 ],
    [ u"hu",u"Karcsa",1984,48.311298,21.805369 ],
    [ u"hu",u"Kartal",6017,47.671331,19.542005 ],
    [ u"hu",u"Kaszaper",2063,46.466667,20.833333 ],
    [ u"hu",u"Katymár",2374,46.03398,19.209353 ],
    [ u"hu",u"Kazár",2080,48.049524,19.861432 ],
    [ u"hu",u"Kazincbarcika",32396,48.25,20.633333 ],
    [ u"hu",u"Kecel",9155,46.525278,19.251944 ],
    [ u"hu",u"Kecskéd",1908,47.522985,18.309386 ],
    [ u"hu",u"Kecskemét",106062,46.9,19.783333 ],
    [ u"hu",u"Kék",2044,48.116667,21.883333 ],
    [ u"hu",u"Kelebia",2985,46.196802,19.616592 ],
    [ u"hu",u"Kemecse",5029,48.075319,21.806253 ],
    [ u"hu",u"Kenderes",5243,47.25,20.683333 ],
    [ u"hu",u"Kengyel",4299,47.083333,20.333333 ],
    [ u"hu",u"Kerecsend",2217,47.8,20.35 ],
    [ u"hu",u"Kerekegyháza",5983,46.937222,19.478056 ],
    [ u"hu",u"Kerepes",8755,47.542839,19.263312 ],
    [ u"hu",u"Keszthely",21534,46.768121,17.24317 ],
    [ u"hu",u"Kesztölc",2559,47.712664,18.801769 ],
    [ u"hu",u"Kétegyháza",4331,46.533333,21.183333 ],
    [ u"hu",u"Kéthely",2408,46.646051,17.393616 ],
    [ u"hu",u"Kevermes",2401,46.416667,21.183333 ],
    [ u"hu",u"Kimle",2312,47.817256,17.366424 ],
    [ u"hu",u"Kisbér",5850,47.502891,18.036652 ],
    [ u"hu",u"Kisköre",3038,47.5,20.5 ],
    [ u"hu",u"Kiskoros",15091,46.621389,19.285281 ],
    [ u"hu",u"Kiskunfélegyháza",31721,46.712131,19.844576 ],
    [ u"hu",u"Kiskunhalas",29354,46.434025,19.484795 ],
    [ u"hu",u"Kiskunlacháza",8980,47.188388,19.0093 ],
    [ u"hu",u"Kiskunmajsa",11955,46.490278,19.74 ],
    [ u"hu",u"Kisláng",2641,46.957438,18.388127 ],
    [ u"hu",u"Kisléta",1944,47.842438,22.003931 ],
    [ u"hu",u"Kisszállás",2846,46.28009,19.489544 ],
    [ u"hu",u"Kistarcsa",9637,47.542839,19.263312 ],
    [ u"hu",u"Kistelek",7430,46.4725,19.979722 ],
    [ u"hu",u"Kisújszállás",12661,47.216667,20.766667 ],
    [ u"hu",u"Kisvárda",18190,48.216667,22.083333 ],
    [ u"hu",u"Kiszombor",4131,46.183333,20.433333 ],
    [ u"hu",u"Kocsér",2096,47.001654,19.920666 ],
    [ u"hu",u"Kocs",2655,47.607495,18.215168 ],
    [ u"hu",u"Kocsord",3054,47.939115,22.383333 ],
    [ u"hu",u"Kóka",4376,47.485522,19.578764 ],
    [ u"hu",u"Komádi",6091,47,21.5 ],
    [ u"hu",u"Komárom",19646,47.743184,18.11913 ],
    [ u"hu",u"Komló",26924,46.188855,18.260645 ],
    [ u"hu",u"Kompolt",2166,47.733333,20.25 ],
    [ u"hu",u"Kondoros",5793,46.766667,20.8 ],
    [ u"hu",u"Konyár",2257,47.316667,21.666667 ],
    [ u"hu",u"Kóny",2609,47.630531,17.357167 ],
    [ u"hu",u"Körmend",12368,47.014377,16.599673 ],
    [ u"hu",u"Környe",4359,47.546681,18.320805 ],
    [ u"hu",u"Körösladány",5006,46.966667,21.083333 ],
    [ u"hu",u"Köröstarcsa",2786,46.883333,21.033333 ],
    [ u"hu",u"Kosd",2371,47.807912,19.178213 ],
    [ u"hu",u"Koszeg",11500,47.389223,16.541001 ],
    [ u"hu",u"Kótaj",4553,48.05,21.716667 ],
    [ u"hu",u"Kozármisleny",4093,46.029669,18.292097 ],
    [ u"hu",u"Kunágota",2951,46.433333,21.05 ],
    [ u"hu",u"Kunfehértó",2281,46.360914,19.41454 ],
    [ u"hu",u"Kunhegyes",8462,47.366667,20.633333 ],
    [ u"hu",u"Kunmadaras",5826,47.433333,20.8 ],
    [ u"hu",u"Kunszentmárton",9606,46.83916,20.28879 ],
    [ u"hu",u"Kunszentmiklós",8976,47.026995,19.125753 ],
    [ u"hu",u"Lábatlan",5357,47.74735,18.496226 ],
    [ u"hu",u"Lábod",2244,46.205351,17.454187 ],
    [ u"hu",u"Lajoskomárom",2365,46.842005,18.337627 ],
    [ u"hu",u"Lajosmizse",11034,47.021331,19.561707 ],
    [ u"hu",u"Lakitelek",4435,46.876009,19.995042 ],
    [ u"hu",u"Lánycsók",2707,46.011699,18.621176 ],
    [ u"hu",u"Leányfalu",2534,47.717785,19.085847 ],
    [ u"hu",u"Lébény",3161,47.736073,17.391554 ],
    [ u"hu",u"Lengyeltóti",3380,46.670132,17.643978 ],
    [ u"hu",u"Lenti",8399,46.624027,16.538631 ],
    [ u"hu",u"Lepsény",3224,46.990363,18.243575 ],
    [ u"hu",u"Létavértes",7157,47.383333,21.9 ],
    [ u"hu",u"Letenye",4527,46.433013,16.725832 ],
    [ u"hu",u"Levelek",2948,47.962816,21.985367 ],
    [ u"hu",u"Litér",2010,47.101044,18.004541 ],
    [ u"hu",u"Lokoshaza",2017,46.433333,21.233333 ],
    [ u"hu",u"Lorinci",6089,47.732952,19.678669 ],
    [ u"hu",u"Lovasberény",2674,47.309972,18.551771 ],
    [ u"hu",u"Madaras",3246,46.0587,19.26121 ],
    [ u"hu",u"Mád",2589,48.2,21.283333 ],
    [ u"hu",u"Madocsa",1935,46.687901,18.957911 ],
    [ u"hu",u"Maglód",10144,47.442576,19.364383 ],
    [ u"hu",u"Mágocs",2652,46.349983,18.232405 ],
    [ u"hu",u"Magyarbánhegyes",2634,46.45,20.966667 ],
    [ u"hu",u"Maklár",2340,47.8,20.416667 ],
    [ u"hu",u"Makó",25135,46.216667,20.483333 ],
    [ u"hu",u"Mályi",4128,48.016667,20.833333 ],
    [ u"hu",u"Mándok",4566,48.321494,22.191066 ],
    [ u"hu",u"Mány",2294,47.53352,18.656273 ],
    [ u"hu",u"Marcali",12344,46.584983,17.411965 ],
    [ u"hu",u"Máriapócs",2182,47.883025,22.025015 ],
    [ u"hu",u"Maroslele",2157,46.266667,20.35 ],
    [ u"hu",u"Martfu",7247,47.016667,20.283333 ],
    [ u"hu",u"Martonvásár",5166,47.316012,18.79045 ],
    [ u"hu",u"Mátészalka",18718,47.955279,22.323478 ],
    [ u"hu",u"Mátraderecske",2232,47.95,20.083333 ],
    [ u"hu",u"Mátranovák",1972,48.038092,19.982571 ],
    [ u"hu",u"Mátraterenye",1995,48.032667,19.947621 ],
    [ u"hu",u"Mátraverebély",2197,47.974209,19.78049 ],
    [ u"hu",u"Medgyesegyháza",4037,46.5,21.033333 ],
    [ u"hu",u"Megyaszó",3072,48.183333,21.05 ],
    [ u"hu",u"Méhkerék",2274,46.783333,21.45 ],
    [ u"hu",u"Mélykút",5766,46.215088,19.381024 ],
    [ u"hu",u"Mende",4250,47.431325,19.456282 ],
    [ u"hu",u"Mérk",2335,47.788236,22.380375 ],
    [ u"hu",u"Mezobereny",11306,46.816667,21.033333 ],
    [ u"hu",u"Mezocsat",6519,47.816667,20.916667 ],
    [ u"hu",u"Mezofalva",4910,46.93184,18.771774 ],
    [ u"hu",u"Mezohegyes",6220,46.316667,20.816667 ],
    [ u"hu",u"Mezokeresztes",4116,47.833333,20.7 ],
    [ u"hu",u"Mezokovacshaza",6877,46.4,20.916667 ],
    [ u"hu",u"Mezokovesd",17701,47.816667,20.583333 ],
    [ u"hu",u"Mezoszilas",2309,46.811093,18.477891 ],
    [ u"hu",u"Mezotur",19168,47,20.633333 ],
    [ u"hu",u"Mezozombor",2549,48.15,21.266667 ],
    [ u"hu",u"Mihályi",1137,47.513835,17.095067 ],
    [ u"hu",u"Mikepércs",3430,47.45,21.633333 ],
    [ u"hu",u"Mindszent",7243,46.523621,20.190381 ],
    [ u"hu",u"Miskolc",179430,48.1,20.783333 ],
    [ u"hu",u"Mocsa",2265,47.669987,18.185046 ],
    [ u"hu",u"Mogyoród",4949,47.597484,19.240703 ],
    [ u"hu",u"Mohács",18711,45.993056,18.683056 ],
    [ u"hu",u"Monok",1786,48.216667,21.15 ],
    [ u"hu",u"Monor",21720,47.351333,19.447335 ],
    [ u"hu",u"Monostorpályi",2221,47.4,21.783333 ],
    [ u"hu",u"Mórahalom",5445,46.218056,19.885099 ],
    [ u"hu",u"Mór",14690,47.377872,18.203534 ],
    [ u"hu",u"Mosonmagyaróvár",30359,47.867885,17.269935 ],
    [ u"hu",u"Mosonszentmiklós",2517,47.736073,17.391554 ],
    [ u"hu",u"Múcsony",3486,48.266667,20.683333 ],
    [ u"hu",u"Murakeresztúr",1969,46.364215,16.881767 ],
    [ u"hu",u"Nádudvar",9135,47.416667,21.166667 ],
    [ u"hu",u"Nagyatád",11843,46.228066,17.360968 ],
    [ u"hu",u"Nagybajom",3532,46.392325,17.51147 ],
    [ u"hu",u"Nagybaracska",2445,46.042481,18.905901 ],
    [ u"hu",u"Nagycserkesz",1907,47.966667,21.533333 ],
    [ u"hu",u"Nagydobos",2282,48.05759,22.304235 ],
    [ u"hu",u"Nagydorog",2787,46.627488,18.655647 ],
    [ u"hu",u"Nagyecsed",6919,47.865467,22.391595 ],
    [ u"hu",u"Nagyhalász",5924,48.133333,21.766667 ],
    [ u"hu",u"Nagyhegyes",2683,47.516667,21.416667 ],
    [ u"hu",u"Nagyigmánd",3132,47.640935,18.081298 ],
    [ u"hu",u"Nagykálló",10796,47.875124,21.84536 ],
    [ u"hu",u"Nagykanizsa",51383,46.514167,16.971667 ],
    [ u"hu",u"Nagykáta",13322,47.415144,19.744099 ],
    [ u"hu",u"Nagykoros",26711,47.034189,19.778574 ],
    [ u"hu",u"Nagykovácsi",4861,47.575232,18.87337 ],
    [ u"hu",u"Nagymányok",2504,46.284123,18.461961 ],
    [ u"hu",u"Nagymaros",4629,47.792797,18.959841 ],
    [ u"hu",u"Nagyoroszi",2250,48.005028,19.090503 ],
    [ u"hu",u"Nagyrábé",2380,47.2,21.333333 ],
    [ u"hu",u"Nagyréde",3308,47.76543,19.848192 ],
    [ u"hu",u"Nagyszénás",5617,46.683333,20.666667 ],
    [ u"hu",u"Nagytarcsa",2846,47.531282,19.283426 ],
    [ u"hu",u"Nagyvenyim",3949,46.956673,18.857805 ],
    [ u"hu",u"Napkor",3786,47.937973,21.867628 ],
    [ u"hu",u"Naszály",2239,47.703293,18.257512 ],
    [ u"hu",u"Nemesnádudvar",2041,46.340505,19.051153 ],
    [ u"hu",u"Nemesvámos",2508,47.05514,17.874767 ],
    [ u"hu",u"Németkér",1901,46.716371,18.763114 ],
    [ u"hu",u"Nyáregyháza",3770,47.261751,19.501458 ],
    [ u"hu",u"Nyarlorinc",2384,46.860171,19.878358 ],
    [ u"hu",u"Nyékládháza",4939,47.983333,20.833333 ],
    [ u"hu",u"Nyergesújfalu",7667,47.757627,18.557456 ],
    [ u"hu",u"Nyírábrány",3940,47.553108,22.024008 ],
    [ u"hu",u"Nyíracsád",4047,47.603298,21.972084 ],
    [ u"hu",u"Nyíradony",7827,47.697457,21.918782 ],
    [ u"hu",u"Nyírbátor",13434,47.833333,22.133333 ],
    [ u"hu",u"Nyírbéltek",3021,47.7,22.133333 ],
    [ u"hu",u"Nyírbogát",3336,47.803395,22.065606 ],
    [ u"hu",u"Nyírbogdány",3039,48.05723,21.882418 ],
    [ u"hu",u"Nyírcsaholy",2251,47.903827,22.336302 ],
    [ u"hu",u"Nyíregyháza",116809,47.95,21.716667 ],
    [ u"hu",u"Nyírgyulaj",2130,47.886218,22.097814 ],
    [ u"hu",u"Nyírkarász",2395,48.101669,22.097939 ],
    [ u"hu",u"Nyírlugos",3004,47.693149,22.044756 ],
    [ u"hu",u"Nyírmada",4743,48.066667,22.2 ],
    [ u"hu",u"Nyírmártonfalva",2130,47.583333,21.9 ],
    [ u"hu",u"Nyírmeggyes",2757,47.916667,22.266667 ],
    [ u"hu",u"Nyírmihálydi",1997,47.739755,21.964446 ],
    [ u"hu",u"Nyírpazony",3162,47.983333,21.8 ],
    [ u"hu",u"Nyírtass",2194,48.116667,22.033333 ],
    [ u"hu",u"Nyírtelek",7138,48.016667,21.633333 ],
    [ u"hu",u"Nyírvasvári",1971,47.816667,22.186829 ],
    [ u"hu",u"Nyúl",3816,47.590471,17.689043 ],
    [ u"hu",u"Ócsa",9097,47.299862,19.230569 ],
    [ u"hu",u"Ocseny",2536,46.313697,18.757493 ],
    [ u"hu",u"Öcsöd",3730,46.9,20.4 ],
    [ u"hu",u"Ófehértó",2727,47.933333,22.05 ],
    [ u"hu",u"Okány",2930,46.9,21.35 ],
    [ u"hu",u"Ököritófülpös",2034,47.918619,22.508095 ],
    [ u"hu",u"Olaszliszka",1799,48.25,21.433333 ],
    [ u"hu",u"Onga",4697,48.116667,20.916667 ],
    [ u"hu",u"Ónod",2461,48,20.916667 ],
    [ u"hu",u"Ópályi",3035,47.997712,22.32617 ],
    [ u"hu",u"Ópusztaszer",2260,46.485923,20.087218 ],
    [ u"hu",u"Orbottyan",5495,47.687107,19.282394 ],
    [ u"hu",u"Orgovány",3472,46.750867,19.472586 ],
    [ u"hu",u"Örkény",5119,47.129906,19.433238 ],
    [ u"hu",u"Orosháza",31373,46.566667,20.666667 ],
    [ u"hu",u"Oroszlány",20271,47.486706,18.31225 ],
    [ u"hu",u"Osi",2146,47.147216,18.188329 ],
    [ u"hu",u"Öskü",2272,47.160029,18.073268 ],
    [ u"hu",u"Ostoros",2362,47.866667,20.433333 ],
    [ u"hu",u"Öttevény",2725,47.724807,17.491006 ],
    [ u"hu",u"Ózd",38475,48.216667,20.3 ],
    [ u"hu",u"Ozora",1742,46.751333,18.400095 ],
    [ u"hu",u"Pacsa",1878,46.719808,17.01401 ],
    [ u"hu",u"Pákozd",2721,47.213694,18.533055 ],
    [ u"hu",u"Paks",20638,46.62648,18.859624 ],
    [ u"hu",u"Pálmonostora",2052,46.624171,19.951564 ],
    [ u"hu",u"Pánd",2041,47.353331,19.635712 ],
    [ u"hu",u"Pannonhalma",4089,47.549465,17.755354 ],
    [ u"hu",u"Pápa",32990,47.330044,17.467398 ],
    [ u"hu",u"Parád",2111,47.923235,20.029716 ],
    [ u"hu",u"Pásztó",10119,47.920189,19.698287 ],
    [ u"hu",u"Pátroha",2976,48.166667,22 ],
    [ u"hu",u"Páty",5475,47.517086,18.828514 ],
    [ u"hu",u"Pázmánd",1985,47.287547,18.653557 ],
    [ u"hu",u"Pécel",13193,47.489615,19.341624 ],
    [ u"hu",u"Pécs",156661,46.075363,18.232845 ],
    [ u"hu",u"Pécsvárad",4024,46.161732,18.427501 ],
    [ u"hu",u"Pellérd",1881,46.03438,18.154026 ],
    [ u"hu",u"Perbál",2167,47.589572,18.760988 ],
    [ u"hu",u"Perkáta",4166,47.047006,18.787336 ],
    [ u"hu",u"Pér",2372,47.611528,17.806317 ],
    [ u"hu",u"Péteri",1970,47.391042,19.409814 ],
    [ u"hu",u"Pétervására",2568,48.016667,20.1 ],
    [ u"hu",u"Petfurdo",4877,47.159814,18.119772 ],
    [ u"hu",u"Petneháza",1993,48.060842,22.074852 ],
    [ u"hu",u"Petofibanya",3061,47.779425,19.705504 ],
    [ u"hu",u"Pilisborosjeno",3180,47.60866,18.991062 ],
    [ u"hu",u"Piliscsaba",6468,47.634172,18.828864 ],
    [ u"hu",u"Piliscsév",2310,47.679236,18.818716 ],
    [ u"hu",u"Pilismarót",1952,47.784636,18.875388 ],
    [ u"hu",u"Pilis",11102,47.289043,19.548477 ],
    [ u"hu",u"Pilisszántó",2245,47.669088,18.887617 ],
    [ u"hu",u"Pilisszentiván",4218,47.609405,18.8973 ],
    [ u"hu",u"Pilisszentkereszt",2224,47.691434,18.905028 ],
    [ u"hu",u"Pilisvörösvár",13150,47.617785,18.911081 ],
    [ u"hu",u"Pincehely",2548,46.680951,18.439353 ],
    [ u"hu",u"Pocsaj",2709,47.283333,21.816667 ],
    [ u"hu",u"Polgárdi",6564,47.060993,18.301999 ],
    [ u"hu",u"Polgár",8347,47.866667,21.116667 ],
    [ u"hu",u"Pomáz",14917,47.642272,19.027839 ],
    [ u"hu",u"Porcsalma",2770,47.883333,22.566667 ],
    [ u"hu",u"Poroszló",3030,47.65,20.666667 ],
    [ u"hu",u"Prügy",2568,48.083333,21.25 ],
    [ u"hu",u"Püspökladány",15990,47.316667,21.116667 ],
    [ u"hu",u"Pusztaföldvár",1887,46.533333,20.8 ],
    [ u"hu",u"Pusztaszabolcs",6355,47.137181,18.76704 ],
    [ u"hu",u"Pusztaszer",1642,46.550832,19.988235 ],
    [ u"hu",u"Pusztavám",2521,47.429478,18.22648 ],
    [ u"hu",u"Putnok",7501,48.3,20.433333 ],
    [ u"hu",u"Rábapatona",2497,47.632237,17.480044 ],
    [ u"hu",u"Rácalmás",4148,47.022632,18.940556 ],
    [ u"hu",u"Ráckeresztúr",3117,47.273597,18.833426 ],
    [ u"hu",u"Ráckeve",9229,47.160951,18.944781 ],
    [ u"hu",u"Rajka",2601,47.996427,17.198214 ],
    [ u"hu",u"Rakamaz",5197,48.133333,21.466667 ],
    [ u"hu",u"Rákóczifalva",5481,47.083333,20.233333 ],
    [ u"hu",u"Rákócziújfalu",2012,47.066667,20.266667 ],
    [ u"hu",u"Recsk",2992,47.933333,20.116667 ],
    [ u"hu",u"Répcelak",2644,47.421052,17.017946 ],
    [ u"hu",u"Rétság",3004,47.927612,19.13669 ],
    [ u"hu",u"Ricse",1907,48.325645,21.970694 ],
    [ u"hu",u"Rimóc",1874,48.03695,19.530097 ],
    [ u"hu",u"Romhány",2421,47.919296,19.263627 ],
    [ u"hu",u"Röszke",3241,46.187957,20.033721 ],
    [ u"hu",u"Rózsaszentmárton",2028,47.782,19.7421 ],
    [ u"hu",u"Rudabánya",2941,48.383333,20.633333 ],
    [ u"hu",u"Ruzsa",2764,46.288057,19.747137 ],
    [ u"hu",u"Sajóbábony",3113,48.166667,20.733333 ],
    [ u"hu",u"Sajókaza",3494,48.283333,20.583333 ],
    [ u"hu",u"Sajólád",3001,48.05,20.9 ],
    [ u"hu",u"Sajószentpéter",13125,48.216667,20.716667 ],
    [ u"hu",u"Sajószöged",2289,47.95,21 ],
    [ u"hu",u"Sajóvámos",2206,48.183333,20.85 ],
    [ u"hu",u"Salgótarján",44289,48.103363,19.805237 ],
    [ u"hu",u"Sály",2174,47.95,20.666667 ],
    [ u"hu",u"Sándorfalva",7738,46.360871,20.09889 ],
    [ u"hu",u"Sáránd",2322,47.4,21.633333 ],
    [ u"hu",u"Sárbogárd",13424,46.886555,18.619464 ],
    [ u"hu",u"Sárisáp",2911,47.677001,18.679329 ],
    [ u"hu",u"Sarkad",10698,46.75,21.383333 ],
    [ u"hu",u"Sárkeresztúr",2443,47.005401,18.543906 ],
    [ u"hu",u"Sármellék",1836,46.712212,17.168647 ],
    [ u"hu",u"Sárosd",3474,47.042731,18.643569 ],
    [ u"hu",u"Sárospatak",14478,48.316667,21.583333 ],
    [ u"hu",u"Sárrétudvari",3023,47.233333,21.2 ],
    [ u"hu",u"Sárszentmihály",2824,47.153212,18.338794 ],
    [ u"hu",u"Sárvár",15343,47.255481,16.93041 ],
    [ u"hu",u"Sásd",3500,46.255197,18.107757 ],
    [ u"hu",u"Sátoraljaújhely",18052,48.4,21.666667 ],
    [ u"hu",u"Segesd",2674,46.34142,17.35132 ],
    [ u"hu",u"Sellye",3184,45.872468,17.84711 ],
    [ u"hu",u"Seregélyes",4539,47.110504,18.565 ],
    [ u"hu",u"Siklós",10180,45.854992,18.297523 ],
    [ u"hu",u"Simontornya",4536,46.754623,18.554903 ],
    [ u"hu",u"Siófok",23028,46.904125,18.058002 ],
    [ u"hu",u"Sirok",2068,47.933333,20.2 ],
    [ u"hu",u"Solt",6984,46.800674,18.999931 ],
    [ u"hu",u"Soltvadkert",7695,46.578889,19.39389 ],
    [ u"hu",u"Solymár",9242,47.592457,18.932122 ],
    [ u"hu",u"Somogyvár",2023,46.581404,17.662886 ],
    [ u"hu",u"Soponya",1996,47.014847,18.453426 ],
    [ u"hu",u"Sopron",55623,47.683333,16.6 ],
    [ u"hu",u"Sóskút",2998,47.406649,18.82247 ],
    [ u"hu",u"Sükösd",3987,46.28181,18.995241 ],
    [ u"hu",u"Sümeg",6726,46.97957,17.280388 ],
    [ u"hu",u"Sutto",1998,47.758865,18.448728 ],
    [ u"hu",u"Szabadbattyán",4492,47.119023,18.368235 ],
    [ u"hu",u"Szabadkígyós",2959,46.616667,21.1 ],
    [ u"hu",u"Szabadszállás",6605,46.875752,19.223244 ],
    [ u"hu",u"Szada",3370,47.633333,19.316667 ],
    [ u"hu",u"Szajol",3991,47.183333,20.3 ],
    [ u"hu",u"Szakoly",2925,47.766667,21.916667 ],
    [ u"hu",u"Szalkszentmárton",2982,46.975654,19.011775 ],
    [ u"hu",u"Szamosszeg",2084,48.04561,22.36582 ],
    [ u"hu",u"Szank",2506,46.557126,19.66103 ],
    [ u"hu",u"Szany",2300,47.464231,17.304019 ],
    [ u"hu",u"Szarvas",18170,46.866667,20.55 ],
    [ u"hu",u"Szászvár",2684,46.277561,18.376198 ],
    [ u"hu",u"Szatymaz",4187,46.343063,20.040196 ],
    [ u"hu",u"Százhalombatta",17566,47.325791,18.921415 ],
    [ u"hu",u"Szécsény",6446,48.080573,19.520189 ],
    [ u"hu",u"Szedres",2478,46.47551,18.683052 ],
    [ u"hu",u"Szeged",160609,46.25,20.166667 ],
    [ u"hu",u"Szeghalom",9985,47.033333,21.166667 ],
    [ u"hu",u"Szegvár",4897,46.587403,20.224083 ],
    [ u"hu",u"Székesfehérvár",103772,47.195503,18.4096 ],
    [ u"hu",u"Székkutas",2586,46.5,20.533333 ],
    [ u"hu",u"Szekszárd",35327,46.350137,18.709051 ],
    [ u"hu",u"Szendro",4284,48.4,20.733333 ],
    [ u"hu",u"Szentendre",23606,47.664712,19.068063 ],
    [ u"hu",u"Szentes",30495,46.65,20.266667 ],
    [ u"hu",u"Szentgál",2815,46.374791,18.626006 ],
    [ u"hu",u"Szentgotthárd",8911,46.946513,16.315555 ],
    [ u"hu",u"Szentistván",2629,47.766667,20.666667 ],
    [ u"hu",u"Szentkirályszabadja",2042,47.057602,17.970522 ],
    [ u"hu",u"Szentkirály",1965,46.918923,19.918463 ],
    [ u"hu",u"Szentlorinckata",2005,47.519474,19.752865 ],
    [ u"hu",u"Szentlorinc",7123,46.040164,17.987194 ],
    [ u"hu",u"Szentmártonkáta",4868,47.454188,19.701428 ],
    [ u"hu",u"Szerencs",10046,48.166667,21.2 ],
    [ u"hu",u"Szigetcsép",2455,47.264921,18.970484 ],
    [ u"hu",u"Szigethalom",13092,47.322283,19.002622 ],
    [ u"hu",u"Szigetszentmiklós",24874,47.343819,19.043351 ],
    [ u"hu",u"Szigetújfalu",2158,47.234172,18.927461 ],
    [ u"hu",u"Szigetvár",11267,46.04865,17.805536 ],
    [ u"hu",u"Szihalom",2120,47.766667,20.483333 ],
    [ u"hu",u"Szikszó",5963,48.2,20.933333 ],
    [ u"hu",u"Szilvásvárad",1885,48.1,20.4 ],
    [ u"hu",u"Szirmabesenyo",4697,48.15,20.8 ],
    [ u"hu",u"Szob",3065,47.819212,18.870205 ],
    [ u"hu",u"Szodliget",4350,47.732588,19.147486 ],
    [ u"hu",u"Szod",3059,47.724394,19.170458 ],
    [ u"hu",u"Szolnok",75998,47.183333,20.2 ],
    [ u"hu",u"Szombathely",80210,47.233333,16.616667 ],
    [ u"hu",u"Szomód",2020,47.684919,18.34061 ],
    [ u"hu",u"Szurdokpüspöki",1947,47.859232,19.692184 ],
    [ u"hu",u"Táborfalva",3509,47.099418,19.478374 ],
    [ u"hu",u"Tab",4824,46.731353,18.032013 ],
    [ u"hu",u"Tahitófalu",4677,47.753025,19.091234 ],
    [ u"hu",u"Taksony",6129,47.329681,19.066945 ],
    [ u"hu",u"Taktaharkány",4076,48.083333,21.133333 ],
    [ u"hu",u"Taktaszada",2067,48.116667,21.183333 ],
    [ u"hu",u"Tállya",2169,48.233333,21.233333 ],
    [ u"hu",u"Tamási",9682,46.633333,18.283333 ],
    [ u"hu",u"Tápióbicske",3514,47.360957,19.686093 ],
    [ u"hu",u"Tápiógyörgye",3817,47.335046,19.95276 ],
    [ u"hu",u"Tápióság",2760,47.401999,19.630468 ],
    [ u"hu",u"Tapioszecso",6628,47.45,19.609232 ],
    [ u"hu",u"Tápiószele",6214,47.336093,19.877241 ],
    [ u"hu",u"Tápiószentmárton",5596,47.3399,19.746478 ],
    [ u"hu",u"Tapioszolos",3155,47.302475,19.851333 ],
    [ u"hu",u"Táplánszentkereszt",2342,47.198582,16.694219 ],
    [ u"hu",u"Tapolca",17598,46.881518,17.44117 ],
    [ u"hu",u"Tarcal",3283,48.133333,21.35 ],
    [ u"hu",u"Tarján",2825,47.610423,18.510703 ],
    [ u"hu",u"Tarnalelesz",1805,48.05,20.183333 ],
    [ u"hu",u"Tárnok",7990,47.373269,18.845786 ],
    [ u"hu",u"Tarpa",2331,48.104797,22.537444 ],
    [ u"hu",u"Tar",1972,47.953712,19.746098 ],
    [ u"hu",u"Tass",2963,47.020954,19.029884 ],
    [ u"hu",u"Taszár",2013,46.37467,17.905942 ],
    [ u"hu",u"Tatabánya",71527,47.584941,18.393253 ],
    [ u"hu",u"Tata",23868,47.652891,18.31838 ],
    [ u"hu",u"Tát",5575,47.741478,18.648127 ],
    [ u"hu",u"Tázlár",1984,46.548241,19.514358 ],
    [ u"hu",u"Téglás",6285,47.716667,21.683333 ],
    [ u"hu",u"Telki",2071,47.547905,18.828165 ],
    [ u"hu",u"Tengelic",2445,46.528784,18.711166 ],
    [ u"hu",u"Tét",4104,47.519225,17.50802 ],
    [ u"hu",u"Tiszaalpár",5070,46.812788,19.998411 ],
    [ u"hu",u"Tiszabercel",2047,48.15,21.65 ],
    [ u"hu",u"Tiszabezdéd",2054,48.366667,22.15 ],
    [ u"hu",u"Tiszabo",2000,47.3,20.483333 ],
    [ u"hu",u"Tiszabura",2730,47.45,20.466667 ],
    [ u"hu",u"Tiszacsege",4961,47.7,21 ],
    [ u"hu",u"Tiszadada",2505,48.033333,21.25 ],
    [ u"hu",u"Tiszadob",3311,48.016667,21.166667 ],
    [ u"hu",u"Tiszaeszlár",2857,48.05,21.466667 ],
    [ u"hu",u"Tiszaföldvár",11873,46.983333,20.25 ],
    [ u"hu",u"Tiszafüred",12000,47.616667,20.766667 ],
    [ u"hu",u"Tiszakarád",2522,48.2,21.716667 ],
    [ u"hu",u"Tiszakécske",11745,46.932615,20.103487 ],
    [ u"hu",u"Tiszakeszi",2692,47.783333,21 ],
    [ u"hu",u"Tiszalök",6122,48.016667,21.383333 ],
    [ u"hu",u"Tiszalúc",5551,48.033333,21.083333 ],
    [ u"hu",u"Tiszanagyfalu",2010,48.1,21.483333 ],
    [ u"hu",u"Tiszanána",2607,47.566667,20.533333 ],
    [ u"hu",u"Tiszapüspöki",2096,47.216667,20.316667 ],
    [ u"hu",u"Tiszaroff",1874,47.4,20.45 ],
    [ u"hu",u"Tiszasüly",1737,47.383333,20.4 ],
    [ u"hu",u"Tiszaszentimre",2340,47.483333,20.733333 ],
    [ u"hu",u"Tiszaújváros",17294,47.933333,21.083333 ],
    [ u"hu",u"Tiszavasvári",13631,47.966667,21.35 ],
    [ u"hu",u"Tóalmás",3434,47.507816,19.666572 ],
    [ u"hu",u"Tokaj",5071,48.116667,21.416667 ],
    [ u"hu",u"Tokod",4271,47.722768,18.658887 ],
    [ u"hu",u"Tököl",9112,47.31854,18.967791 ],
    [ u"hu",u"Tolcsva",1860,48.283333,21.45 ],
    [ u"hu",u"Tolna",12011,46.426765,18.782476 ],
    [ u"hu",u"Töltéstava",1902,47.62609,17.733761 ],
    [ u"hu",u"Tömörkény",1944,46.617161,20.043569 ],
    [ u"hu",u"Tompa",4844,46.206054,19.539101 ],
    [ u"hu",u"Tornyospálca",2725,48.266667,22.183333 ],
    [ u"hu",u"Törökbálint",11658,47.436454,18.912422 ],
    [ u"hu",u"Törökszentmiklós",22770,47.183333,20.416667 ],
    [ u"hu",u"Törtel",4733,47.122092,19.93714 ],
    [ u"hu",u"Tószeg",4621,47.1,20.15 ],
    [ u"hu",u"Tótkomlós",6497,46.416667,20.733333 ],
    [ u"hu",u"Tunyogmatolcs",2629,47.966667,22.466667 ],
    [ u"hu",u"Tura",8294,47.609242,19.60279 ],
    [ u"hu",u"Türje",1868,46.98366,17.107417 ],
    [ u"hu",u"Túrkeve",10016,47.1,20.75 ],
    [ u"hu",u"Tuzsér",3332,48.34407,22.117621 ],
    [ u"hu",u"Tyukod",2188,47.853778,22.5633 ],
    [ u"hu",u"Újfehértó",13542,47.8,21.683333 ],
    [ u"hu",u"Újhartyán",2852,47.219808,19.386378 ],
    [ u"hu",u"Újkígyós",5602,46.583333,21.033333 ],
    [ u"hu",u"Újszász",6855,47.3,20.083333 ],
    [ u"hu",u"Újszilvás",2722,47.274767,19.924767 ],
    [ u"hu",u"Üllés",3145,46.336114,19.844544 ],
    [ u"hu",u"Ullo",10232,47.387711,19.35533 ],
    [ u"hu",u"Úri",2718,47.414288,19.527622 ],
    [ u"hu",u"Úrkút",2178,47.085046,17.643933 ],
    [ u"hu",u"Üröm",4753,47.596741,19.015829 ],
    [ u"hu",u"Vácszentlászló",2085,47.574005,19.537711 ],
    [ u"hu",u"Vác",35108,47.780715,19.131006 ],
    [ u"hu",u"Vaja",3774,48.005739,22.167609 ],
    [ u"hu",u"Vajszló",1888,45.859575,17.984056 ],
    [ u"hu",u"Valkó",2461,47.563907,19.51267 ],
    [ u"hu",u"Vál",2348,47.36264,18.679306 ],
    [ u"hu",u"Vámosgyörk",2020,47.684285,19.92924 ],
    [ u"hu",u"Vámospércs",5451,47.533333,21.9 ],
    [ u"hu",u"Városföld",2248,46.817206,19.759822 ],
    [ u"hu",u"Várpalota",21299,47.199358,18.139543 ],
    [ u"hu",u"Vásárosnamény",9310,48.133333,22.316667 ],
    [ u"hu",u"Vaskút",3613,46.107816,18.985141 ],
    [ u"hu",u"Vasvár",4613,47.049018,16.804145 ],
    [ u"hu",u"Vecsés",19327,47.407047,19.286483 ],
    [ u"hu",u"Velence",4832,47.238547,18.654842 ],
    [ u"hu",u"Vép",3460,47.22537,16.716098 ],
    [ u"hu",u"Veresegyház",11087,47.645899,19.295355 ],
    [ u"hu",u"Veroce",3087,47.828517,19.014648 ],
    [ u"hu",u"Verpelét",4016,47.85,20.233333 ],
    [ u"hu",u"Vertesszolos",2747,47.621057,18.381298 ],
    [ u"hu",u"Veszprém",60387,47.094289,17.911956 ],
    [ u"hu",u"Veszto",7494,46.916667,21.266667 ],
    [ u"hu",u"Villány",2738,45.868889,18.453889 ],
    [ u"hu",u"Visegrád",1713,47.78526,18.970897 ],
    [ u"hu",u"Vonyarcvashegy",1902,46.757425,17.311717 ],
    [ u"hu",u"Zagyvarékas",3700,47.266667,20.133333 ],
    [ u"hu",u"Zagyvaszántó",2067,47.777031,19.670922 ],
    [ u"hu",u"Záhony",4807,48.409062,22.176139 ],
    [ u"hu",u"Zákányszék",2747,46.274529,19.889751 ],
    [ u"hu",u"Zalaegerszeg",60919,46.84,16.843889 ],
    [ u"hu",u"Zalakomár",3103,46.537955,17.18094 ],
    [ u"hu",u"Zalalovo",3195,46.848016,16.587496 ],
    [ u"hu",u"Zalaszentgrót",7796,46.944739,17.079253 ],
    [ u"hu",u"Zamárdi",2211,46.884884,17.953657 ],
    [ u"hu",u"Zámoly",2194,47.316667,18.408101 ],
    [ u"hu",u"Zirc",7314,47.262384,17.870522 ],
    [ u"hu",u"Zomba",2286,46.410838,18.565767 ],
    [ u"hu",u"Zsámbék",4791,47.548138,18.720112 ],
    [ u"hu",u"Zsámbok",2474,47.543813,19.610481 ],
    [ u"hu",u"Zsombó",3268,46.325656,19.974638 ],
    [ u"id",u"Adiwerna",134202,-6.9375,109.1325 ],
    [ u"id",u"Amahai",47651,-3.333333,128.916667 ],
    [ u"id",u"Ambarawa",84380,-7.263333,110.3975 ],
    [ u"id",u"Ambon",355607,-3.695426,128.181405 ],
    [ u"id",u"Ambulu",27503,-8.3504,113.6069 ],
    [ u"id",u"Amuntai",55596,-2.433333,115.25 ],
    [ u"id",u"Arjawinangun",105852,-6.645278,108.410278 ],
    [ u"id",u"Astanajapura",148055,-6.8017,108.6311 ],
    [ u"id",u"Atambua",35794,-9.106111,124.8925 ],
    [ u"id",u"Babakan",124801,-6.8275,108.498333 ],
    [ u"id",u"Babat",27039,-7.075,112.304 ],
    [ u"id",u"Bae",57927,-6.7674,110.8541 ],
    [ u"id",u"Baki",58916,-7.612778,110.783889 ],
    [ u"id",u"Balaipungut",56453,1.05,101.283333 ],
    [ u"id",u"Balapulang",28484,-7.05,109.083333 ],
    [ u"id",u"Balikpapan",433939,-1.283333,116.833333 ],
    [ u"id",u"Balung",47631,-7.733333,113.916667 ],
    [ u"id",u"Bambanglipuro",44717,-7.95,110.283333 ],
    [ u"id",u"Banda Aceh",250796,5.5577,95.3222 ],
    [ u"id",u"Bandar",31443,2.05,99.75 ],
    [ u"id",u"Bandung",1699822,-6.903889,107.618611 ],
    [ u"id",u"Bangil",62513,-7.5993,112.784 ],
    [ u"id",u"Bangkalan",62185,-7.0455,112.7351 ],
    [ u"id",u"Banjaran",165136,-6.871667,107.77 ],
    [ u"id",u"Banjar",37282,-7.1955,107.4313 ],
    [ u"id",u"Banjarmasin",572910,-3.333333,114.583333 ],
    [ u"id",u"Bantul",58658,-7.888056,110.328889 ],
    [ u"id",u"Banyumas",48379,-7.514167,109.294167 ],
    [ u"id",u"Banyuwangi",108178,-8.2215,114.3646 ],
    [ u"id",u"Barabai",60231,-2.583333,115.383333 ],
    [ u"id",u"Batu",75640,-7.87,112.528333 ],
    [ u"id",u"Baturaden",42395,-7.3,109.216667 ],
    [ u"id",u"Baturaja",134824,-4.133333,104.166667 ],
    [ u"id",u"Bekasi",1520204,-6.2349,106.9896 ],
    [ u"id",u"Belawan",102709,3.7755,98.6832 ],
    [ u"id",u"Bengkalis",41705,1.466667,102.133333 ],
    [ u"id",u"Bengkulu",309759,-3.8,102.266667 ],
    [ u"id",u"Besuki",55466,-7.75,113.683333 ],
    [ u"id",u"Biak",40907,-1.166007,136.09717 ],
    [ u"id",u"Bima",66972,-8.466667,118.716667 ],
    [ u"id",u"Binjai",228794,3.564,98.724 ],
    [ u"id",u"Bireun",25794,5.203,96.7009 ],
    [ u"id",u"Bitung",137361,1.4451,125.1824 ],
    [ u"id",u"Blitar",132431,-8.0983,112.1681 ],
    [ u"id",u"Blora",51812,-6.9698,111.4186 ],
    [ u"id",u"Bogor",769328,-6.594444,106.789167 ],
    [ u"id",u"Bojonegoro",86578,-7.1502,111.8817 ],
    [ u"id",u"Bondowoso",69791,-7.9159,113.8256 ],
    [ u"id",u"Bone",81631,-4.5386,120.3279 ],
    [ u"id",u"Bontang",101693,.133333,117.5 ],
    [ u"id",u"Boyolali",59852,-7.533056,110.595833 ],
    [ u"id",u"Boyolangu",32287,-8.1181,111.8935 ],
    [ u"id",u"Brebes",186936,-6.8691,109.0378 ],
    [ u"id",u"Buaran",38774,-6.915162,109.657035 ],
    [ u"id",u"Buduran",48152,-7.270278,112.561111 ],
    [ u"id",u"Bulakamba",27367,-6.8748,108.9559 ],
    [ u"id",u"Bumiayu",54044,-7.25,109 ],
    [ u"id",u"Ceper",28647,-7.674167,110.678889 ],
    [ u"id",u"Cepu",55056,-7.1475,111.5906 ],
    [ u"id",u"Ciamis",123631,-7.3257,108.3534 ],
    [ u"id",u"Ciampea",207445,-6.540278,106.695556 ],
    [ u"id",u"Cianjur",146883,-6.822222,107.139444 ],
    [ u"id",u"Ciawi",67902,-6.525278,106.579722 ],
    [ u"id",u"Cibadak",229745,-6.536389,106.770278 ],
    [ u"id",u"Cibeureum",52774,-7.0218,108.3031 ],
    [ u"id",u"Cibinong",188674,-6.398611,106.688611 ],
    [ u"id",u"Cibitung",198119,-6.272222,107.103611 ],
    [ u"id",u"Cicalengka",158211,-6.932222,107.470278 ],
    [ u"id",u"Cidahu",50240,-6.769444,106.758889 ],
    [ u"id",u"Cikampek",145613,-6.419722,107.455833 ],
    [ u"id",u"Cikarang",106486,-6.261111,107.152778 ],
    [ u"id",u"Cikeruh",85328,-6.933056,107.774722 ],
    [ u"id",u"Cikupa",174184,-6.228889,106.519444 ],
    [ u"id",u"Cikupa",174184,-6.3724,106.1945 ],
    [ u"id",u"Ciledug",98524,-6.9142,108.7343 ],
    [ u"id",u"Cilegon",299790,-6.0144,106.0542 ],
    [ u"id",u"Cileungsi",202360,-6.394722,106.959167 ],
    [ u"id",u"Cileunyi",111570,-6.793889,107.851944 ],
    [ u"id",u"Cimahi",378027,-6.698333,107.275278 ],
    [ u"id",u"Ciomas",152335,-6.601389,106.771389 ],
    [ u"id",u"Ciparay",114226,-6.941667,107.349167 ],
    [ u"id",u"Ciputat",207848,-6.2375,106.695556 ],
    [ u"id",u"Ciranjang",77755,-6.813333,107.26 ],
    [ u"id",u"Cirebon",254314,-6.7063,108.557 ],
    [ u"id",u"Cisaat",141005,-6.775278,106.771389 ],
    [ u"id",u"Cisarua",103933,-6.448333,107.120556 ],
    [ u"id",u"Citeureup",110162,-6.362778,106.675278 ],
    [ u"id",u"Comal",51092,-6.9053,109.5347 ],
    [ u"id",u"Curug",191617,-6.253333,106.617222 ],
    [ u"id",u"Curug",191617,-6.3367,106.2256 ],
    [ u"id",u"Curup",46246,-3.466667,102.533333 ],
    [ u"id",u"Dampit",23094,-8.042222,112.515278 ],
    [ u"id",u"Delanggu",24440,-7.616667,110.683333 ],
    [ u"id",u"Deli Tua",27944,3.5078,98.6839 ],
    [ u"id",u"Demak",27251,-6.8909,110.6396 ],
    [ u"id",u"Denpasar",405959,-8.65,115.216667 ],
    [ u"id",u"Depok",104537,-7.696667,110.2175 ],
    [ u"id",u"Depok",1198195,-6.343333,106.498889 ],
    [ u"id",u"Diwek",41719,-7.583333,112.233333 ],
    [ u"id",u"Driyorejo",26827,-7.3659,112.6219 ],
    [ u"id",u"Dukuhturi",98084,-6.8865,108.8432 ],
    [ u"id",u"Dumai",143775,1.683333,101.45 ],
    [ u"id",u"Ende",77212,-8.8432,121.6623 ],
    [ u"id",u"Galesong",83052,-5.3166,119.3661 ],
    [ u"id",u"Gambiran",22525,-8.3939,114.1464 ],
    [ u"id",u"Gampengrejo",49119,-7.7087,112.1008 ],
    [ u"id",u"Gamping",66116,-7.783333,110.316667 ],
    [ u"id",u"Garut",122421,-7.2024,107.8878 ],
    [ u"id",u"Gatak",48964,-7.4475,110.554167 ],
    [ u"id",u"Gebog",43757,-6.735,110.8444 ],
    [ u"id",u"Gedangan",79239,-7.390833,112.726667 ],
    [ u"id",u"Gempol",31151,-7.252778,112.591389 ],
    [ u"id",u"Genteng",79653,-8.366667,114.15 ],
    [ u"id",u"Godean",63170,-7.769722,110.293889 ],
    [ u"id",u"Gombong",31965,-7.607222,109.514167 ],
    [ u"id",u"Gondang",24616,-7.8779,112.1148 ],
    [ u"id",u"Gondanglegi",22468,-8.175288,112.635935 ],
    [ u"id",u"Gorontalo",144202,.5412,123.0595 ],
    [ u"id",u"Gresik",73638,-7.153889,112.656111 ],
    [ u"id",u"Grogol",100624,-7.296389,110.746944 ],
    [ u"id",u"Indramayu",123271,-6.326389,108.32 ],
    [ u"id",u"Jakarta",8540306,-6.174444,106.829444 ],
    [ u"id",u"Jambi",420391,-1.6,103.616667 ],
    [ u"id",u"Jaten",32379,-7.344444,110.8875 ],
    [ u"id",u"Jatibarang",28817,-6.9658,109.055 ],
    [ u"id",u"Jatibarang",73006,-6.474722,108.315278 ],
    [ u"id",u"Jati",85816,-6.5198,110.9306 ],
    [ u"id",u"Jatiroto",50065,-7.883333,111.116667 ],
    [ u"id",u"Jatiwangi",57970,-6.722778,108.2475 ],
    [ u"id",u"Jeluko",37522,-6.5855,110.9897 ],
    [ u"id",u"Jember",298620,-8.1705,113.702 ],
    [ u"id",u"Jepara",54324,-6.5924,110.671 ],
    [ u"id",u"Jetis",49292,-7.642778,110.278611 ],
    [ u"id",u"Jetis",49292,-7.668333,110.463056 ],
    [ u"id",u"Jogonalan",28114,-7.703611,110.536111 ],
    [ u"id",u"Jombang",126479,-7.55,112.233333 ],
    [ u"id",u"Juwana",40178,-6.715,111.1514 ],
    [ u"id",u"Kabanjahe",57160,3.1001,98.4908 ],
    [ u"id",u"Kadipaten",26970,-6.760833,108.166111 ],
    [ u"id",u"Kadungora",77255,-6.994722,107.837778 ],
    [ u"id",u"Kalianget",23897,-7.05,113.933333 ],
    [ u"id",u"Kaliwungu",48916,-6.95,110.233333 ],
    [ u"id",u"Kamal",22515,-7.167778,112.719167 ],
    [ u"id",u"Kanigoro",36467,-8.130027,112.218962 ],
    [ u"id",u"Karangampel",31232,-6.462222,108.451944 ],
    [ u"id",u"Karanganom",50671,-7.608889,110.976667 ],
    [ u"id",u"Karanganyar",34923,-7.293889,109.576667 ],
    [ u"id",u"Karangasem",31869,-8.4994,115.5465 ],
    [ u"id",u"Karangsembung",75852,-6.8487,108.6422 ],
    [ u"id",u"Karang Tengah",138471,-6.908611,106.910556 ],
    [ u"id",u"Karawang",198894,-6.303333,107.305556 ],
    [ u"id",u"Kasihan",86242,-7.826944,110.329167 ],
    [ u"id",u"Katobu",42751,-4.9186,122.5218 ],
    [ u"id",u"Kawalu",50538,-7.3817,108.2082 ],
    [ u"id",u"Kebomas",75990,-7.166667,112.633333 ],
    [ u"id",u"Kebonarum",21745,-7.553333,110.594722 ],
    [ u"id",u"Kebumen",144457,-7.323333,109.600833 ],
    [ u"id",u"Kediri",235171,-7.816667,112.016667 ],
    [ u"id",u"Kedungwaru",80267,-8.0348,112.2037 ],
    [ u"id",u"Kedungwuni",117262,-6.970383,109.647942 ],
    [ u"id",u"Kefamenanu",29491,-9.446667,124.478056 ],
    [ u"id",u"Kemang",111027,-6.741389,107.019167 ],
    [ u"id",u"Kembaran",77977,-7.373889,109.316944 ],
    [ u"id",u"Kencong",43047,-8.2726,113.3651 ],
    [ u"id",u"Kendal",50637,-6.9213,110.2022 ],
    [ u"id",u"Kendari",235329,-3.945,122.498889 ],
    [ u"id",u"Kepanjen",51920,-8.1303,112.5727 ],
    [ u"id",u"Kertosono",60789,-7.5946,112.1059 ],
    [ u"id",u"Ketanggungan",44288,-6.9158,109.0965 ],
    [ u"id",u"Kijang",41343,.9,104.633333 ],
    [ u"id",u"Kisaran",129928,2.9845,99.6158 ],
    [ u"id",u"Klangenan",88373,-6.709444,108.44 ],
    [ u"id",u"Klaten",126845,-7.705833,110.606389 ],
    [ u"id",u"Klungkung",27837,-8.533333,115.4 ],
    [ u"id",u"Kraksaan",28249,-7.760384,113.413192 ],
    [ u"id",u"Kramat",48074,-6.8688,109.2074 ],
    [ u"id",u"Kresek",110304,-6.131389,106.379722 ],
    [ u"id",u"Krian",38604,-7.1163,112.4194 ],
    [ u"id",u"Kroya",23255,-7.483889,108.923611 ],
    [ u"id",u"Kualakapuas",35632,-3.1,114.35 ],
    [ u"id",u"Kudus",92166,-6.8048,110.8405 ],
    [ u"id",u"Kuningan",72090,-6.975833,108.483056 ],
    [ u"id",u"Kupang",282421,-10.166667,123.583333 ],
    [ u"id",u"Kutoarjo",31353,-7.716944,109.912778 ],
    [ u"id",u"Labuhan Deli",49675,3.7278,98.6738 ],
    [ u"id",u"Labuhan",33574,-6.3784,105.83 ],
    [ u"id",u"Lahat",65903,-3.8,103.533333 ],
    [ u"id",u"Lamongan",59224,-7.1194,112.4172 ],
    [ u"id",u"Langsa",54466,4.4683,97.9683 ],
    [ u"id",u"Lasem",28948,-6.6922,111.4527 ],
    [ u"id",u"Lawang",159517,-7.8353,112.6947 ],
    [ u"id",u"Lebaksiu",33607,-7.0496,109.1441 ],
    [ u"id",u"Lembang",183283,-6.786389,107.7025 ],
    [ u"id",u"Leuwiliang",191992,-6.575833,106.636944 ],
    [ u"id",u"Lhokseumawe",88976,5.1801,97.1507 ],
    [ u"id",u"Loa Janan",212820,-.583333,117.083333 ],
    [ u"id",u"Lubuk Pakam",87457,3.5592,98.8733 ],
    [ u"id",u"Lumajang",123640,-8.1335,113.2248 ],
    [ u"id",u"Luwuk",47779,-.9516,122.7875 ],
    [ u"id",u"Madiun",186116,-7.6298,111.5239 ],
    [ u"id",u"Magelang",111470,-7.470556,110.217778 ],
    [ u"id",u"Magetan",79716,-7.656667,111.331389 ],
    [ u"id",u"Majalaya",226720,-7.0485,107.7631 ],
    [ u"id",u"Majalengka",87775,-6.836111,108.227778 ],
    [ u"id",u"Majenang",38898,-7.2975,108.7642 ],
    [ u"id",u"Majene",37716,-3.5403,118.9707 ],
    [ u"id",u"Makasar",1321832,-5.14,119.4221 ],
    [ u"id",u"Malang",746780,-7.9797,112.6304 ],
    [ u"id",u"Manado",451910,1.487,124.8455 ],
    [ u"id",u"Manggar",34522,-2.883333,108.266667 ],
    [ u"id",u"Manokwari",53191,-.866667,134.083333 ],
    [ u"id",u"Margahayu",83124,-6.970833,107.5675 ],
    [ u"id",u"Margasari",27814,-7.1,109.016667 ],
    [ u"id",u"Martapura",131452,-3.416667,114.85 ],
    [ u"id",u"Mataram",318712,-8.583333,116.116667 ],
    [ u"id",u"Maumere",47599,-8.6199,122.2111 ],
    [ u"id",u"Mayong",24176,-6.75,110.75 ],
    [ u"id",u"Medan",1751190,3.583333,98.666667 ],
    [ u"id",u"Mendahara",56269,-1.033333,103.583333 ],
    [ u"id",u"Mentok",26708,-2.066667,105.183333 ],
    [ u"id",u"Merauke",49079,-8.466667,140.333333 ],
    [ u"id",u"Mertoyudan",69872,-7.52,110.226389 ],
    [ u"id",u"Metro",149552,-5.113056,105.306667 ],
    [ u"id",u"Meulaboh",35063,4.1363,96.1285 ],
    [ u"id",u"Mlati",67092,-7.733333,110.366667 ],
    [ u"id",u"Mlonggo",33543,-6.533333,110.7 ],
    [ u"id",u"Mojoagung",23534,-7.5684,112.3344 ],
    [ u"id",u"Mojokerto",112570,-7.4664,112.4338 ],
    [ u"id",u"Mojosari",36298,-7.3503,112.5946 ],
    [ u"id",u"Mranggen",28026,-6.9688,110.2524 ],
    [ u"id",u"Muncar",64538,-8.4365,114.3391 ],
    [ u"id",u"Mundu",50426,-6.463611,108.3925 ],
    [ u"id",u"Muntilan",44859,-7.581111,110.292778 ],
    [ u"id",u"Nabire",43899,-3.366667,135.483333 ],
    [ u"id",u"Negara",33192,-8.3601,114.631 ],
    [ u"id",u"Ngaglik",34328,-7.684167,110.326111 ],
    [ u"id",u"Ngaglik",34328,-7.654167,110.448333 ],
    [ u"id",u"Nganjuk",69019,-7.6051,111.9035 ],
    [ u"id",u"Ngawen",44401,-7.834722,110.685556 ],
    [ u"id",u"Ngawi",22412,-7.4038,111.4461 ],
    [ u"id",u"Ngemplak",23751,-7.216667,110.631111 ],
    [ u"id",u"Ngoro",22871,-7.6899,112.2709 ],
    [ u"id",u"Ngunut",26297,-7.9598,112.1984 ],
    [ u"id",u"Pacet",328324,-6.750278,107.046667 ],
    [ u"id",u"Paciran",27072,-6.866667,112.333333 ],
    [ u"id",u"Padalarang",124953,-6.8425,107.484722 ],
    [ u"id",u"Padang",840458,-.953154,100.367659 ],
    [ u"id",u"Pakisaji",30214,-8.0665,112.5981 ],
    [ u"id",u"Palabuhanratu",42999,-6.9875,106.551389 ],
    [ u"id",u"Palembang",1241334,-2.916667,104.75 ],
    [ u"id",u"Palimanan",92606,-6.706944,108.424167 ],
    [ u"id",u"Palu",282461,-.8917,119.8707 ],
    [ u"id",u"Pamanukan",114386,-6.284167,107.810556 ],
    [ u"id",u"Pamekasan",92457,-7.1568,113.4746 ],
    [ u"id",u"Pameungpeuk",48297,-6.669167,107.549722 ],
    [ u"id",u"Pamulang",174549,-6.342778,106.738333 ],
    [ u"id",u"Panarukan",30749,-7.7008,113.9529 ],
    [ u"id",u"Pandaan",34184,-7.586,112.5015 ],
    [ u"id",u"Pandak",56048,-7.913056,110.293611 ],
    [ u"id",u"Pandegelang",92361,-6.3084,106.1067 ],
    [ u"id",u"Pangkah",113387,-6.9745,109.1732 ],
    [ u"id",u"Pangkalanbuun",38058,-2.683333,111.616667 ],
    [ u"id",u"Panji",42789,-7.695,114.0317 ],
    [ u"id",u"Parakan",23795,-6.9517,110.0676 ],
    [ u"id",u"Pare",56700,-7.6823,111.8866 ],
    [ u"id",u"Parung",193991,-6.3276,106.9715 ],
    [ u"id",u"Pasarkemis",154227,-6.170278,106.530278 ],
    [ u"id",u"Paseh",126287,-6.803889,107.867222 ],
    [ u"id",u"Pasuruan",158618,-7.6453,112.9075 ],
    [ u"id",u"Pati",122798,-6.7559,111.038 ],
    [ u"id",u"Payakumbuh",121652,-.22019,100.630781 ],
    [ u"id",u"Pecangakan",61047,-6.6978,110.7107 ],
    [ u"id",u"Pedan",28738,-7.688333,110.697222 ],
    [ u"id",u"Pekalongan",257973,-6.8886,109.6753 ],
    [ u"id",u"Pemalang",184169,-6.9,109.366667 ],
    [ u"id",u"Pemangkat",34030,1.166667,108.966667 ],
    [ u"id",u"Perbaungan",157378,3.5679,98.956 ],
    [ u"id",u"Peterongan",22726,-7.1988,112.2022 ],
    [ u"id",u"Plered",25122,-6.640556,107.386389 ],
    [ u"id",u"Plumbon",167187,-6.576944,108.317778 ],
    [ u"id",u"Polewali",58191,-3.4324,119.3435 ],
    [ u"id",u"Ponorogo",79034,-7.8685,111.462 ],
    [ u"id",u"Pontianak",455226,-.033333,109.333333 ],
    [ u"id",u"Porong",54698,-7.5406,112.6888 ],
    [ u"id",u"Poso",47115,-1.3959,120.7524 ],
    [ u"id",u"Prabumulih",103476,-3.45,104.25 ],
    [ u"id",u"Prambanan",44926,-7.75,110.494167 ],
    [ u"id",u"Praya",35184,-8.705362,116.270357 ],
    [ u"id",u"Prigen",24164,-7.6816,112.6393 ],
    [ u"id",u"Pringsewu",124791,-5.358215,104.974407 ],
    [ u"id",u"Probolinggo",181678,-7.7543,113.2159 ],
    [ u"id",u"Pundong",24082,-7.765833,110.330833 ],
    [ u"id",u"Purbalingga",56909,-7.388056,109.363889 ],
    [ u"id",u"Purwakarta",215816,-6.556944,107.443333 ],
    [ u"id",u"Purwodadi",150278,-7.0868,110.9158 ],
    [ u"id",u"Purwokerto",217245,-7.421389,109.234444 ],
    [ u"id",u"Purworejo",105077,-7.763611,112.738889 ],
    [ u"id",u"Rajapolah",39838,-7.221,108.1896 ],
    [ u"id",u"Rancaekek",152108,-6.960278,107.7575 ],
    [ u"id",u"Randudongkal",28532,-7.0981,109.3243 ],
    [ u"id",u"Rangkasbitung",126904,-6.3591,106.2494 ],
    [ u"id",u"Rantauprapat",103011,2.1,99.833333 ],
    [ u"id",u"Rantepao",40439,-2.9701,119.8978 ],
    [ u"id",u"Rembang",44030,-6.7036,111.3416 ],
    [ u"id",u"Rengasdengklok",201687,-6.159167,107.298056 ],
    [ u"id",u"Ruteng",34570,-8.6136,120.4721 ],
    [ u"id",u"Sabang",24519,5.893333,95.321389 ],
    [ u"id",u"Salatiga",172664,-7.321389,110.507778 ],
    [ u"id",u"Samarinda",355223,-.5,117.15 ],
    [ u"id",u"Sampang",53270,-7.1872,113.2394 ],
    [ u"id",u"Sampit",66054,-2.533333,112.95 ],
    [ u"id",u"Sawangan",114063,-6.2775,106.529444 ],
    [ u"id",u"Selogiri",30180,-7.783333,110.866667 ],
    [ u"id",u"Semarang",1288221,-6.9932,110.4203 ],
    [ u"id",u"Sembakung",8098,3.816667,117.25 ],
    [ u"id",u"Sepatan",118434,-6.118889,106.575 ],
    [ u"id",u"Serang",164777,-6.1149,106.1502 ],
    [ u"id",u"Serpong",80189,-6.316944,106.664167 ],
    [ u"id",u"Sewon",73592,-7.684722,110.466389 ],
    [ u"id",u"Seyegan",23427,-7.720278,110.299167 ],
    [ u"id",u"Sibolga",79725,1.7427,98.7792 ],
    [ u"id",u"Sidareja",30314,-7.239167,108.964444 ],
    [ u"id",u"Sidoarjo",139205,-7.4478,112.7183 ],
    [ u"id",u"Sigli",17505,5.3848,95.9609 ],
    [ u"id",u"Sijunjung",27787,-.687623,100.953652 ],
    [ u"id",u"Simpang",36653,-1.266667,104.083333 ],
    [ u"id",u"Sindang",27957,-6.334167,108.316111 ],
    [ u"id",u"Singaparna",48880,-7.3515,108.111 ],
    [ u"id",u"Singaraja",133796,-8.1127,115.0949 ],
    [ u"id",u"Singkang",59524,-4.1279,120.0297 ],
    [ u"id",u"Singkawang",101851,.9,109 ],
    [ u"id",u"Singojuruh",29418,-8.3097,114.2394 ],
    [ u"id",u"Singosari",57794,-7.8924,112.6658 ],
    [ u"id",u"Sinjai",40798,-5.1241,120.253 ],
    [ u"id",u"Situbondo",51058,-7.7082,114.0008 ],
    [ u"id",u"Slawi",61213,-6.9816,109.1407 ],
    [ u"id",u"Sleman",56216,-7.715556,110.355556 ],
    [ u"id",u"Soe",27718,-9.866667,124.283333 ],
    [ u"id",u"Solok",48373,-.791834,100.659315 ],
    [ u"id",u"Sooko",25494,-7.3532,112.5203 ],
    [ u"id",u"Soreang",151135,-7.033056,107.518333 ],
    [ u"id",u"Sorong",125538,-.883333,131.25 ],
    [ u"id",u"Sragen",71530,-7.426389,111.022222 ],
    [ u"id",u"Srandakan",29532,-7.938611,110.250556 ],
    [ u"id",u"Srono",36260,-8.4023,114.264 ],
    [ u"id",u"Stabat",26863,3.761,98.4513 ],
    [ u"id",u"Subang",129009,-6.57,107.756667 ],
    [ u"id",u"Sukabumi",276431,-6.918056,106.926667 ],
    [ u"id",u"Sukaraja",66489,-7.458056,109.288056 ],
    [ u"id",u"Sukaraja",157205,-6.587778,106.8375 ],
    [ u"id",u"Sumbawa",52655,-8.5,117.433333 ],
    [ u"id",u"Sumber",93466,-6.760278,108.483056 ],
    [ u"id",u"Sumedang",206919,-6.858611,107.916389 ],
    [ u"id",u"Sumenep",84665,-7.016667,113.866667 ],
    [ u"id",u"Sungaipenuh",95990,-2.083333,101.383333 ],
    [ u"id",u"Sungairaya",47736,.7,108.9 ],
    [ u"id",u"Sunggal",157936,3.5765,98.6151 ],
    [ u"id",u"Surabaya",2374920,-7.249167,112.750833 ],
    [ u"id",u"Surakarta",555368,-7.556111,110.831667 ],
    [ u"id",u"Tabanan",33668,-8.5384,115.1282 ],
    [ u"id",u"Talang",98971,-6.9,109.133333 ],
    [ u"id",u"Taman",181626,-6.9,109.383333 ],
    [ u"id",u"Taman",126875,-7.1785,112.8978 ],
    [ u"id",u"Tambun",314271,-6.105278,107.222222 ],
    [ u"id",u"Tanete",105109,-5.3306,120.1371 ],
    [ u"id",u"Tangerang",1372185,-6.178056,106.63 ],
    [ u"id",u"Tanggulangin",32867,-7.2409,112.4642 ],
    [ u"id",u"Tanggul",35909,-8.1645,113.4525 ],
    [ u"id",u"Tanjung Morawa",157908,3.5193,98.7914 ],
    [ u"id",u"Tarakan",97496,3.3,117.633333 ],
    [ u"id",u"Tarogong",77165,-7.056389,107.636667 ],
    [ u"id",u"Tarub",75740,-6.933333,109.166667 ],
    [ u"id",u"Tasikmalaya",271160,-7.3274,108.2207 ],
    [ u"id",u"Tayu",26414,-6.5397,111.0518 ],
    [ u"id",u"Tebingtinggi",117547,3.3285,99.1625 ],
    [ u"id",u"Tegal",237110,-6.8694,109.1402 ],
    [ u"id",u"Teluknaga",128336,-6.065,106.644167 ],
    [ u"id",u"Teluk Nibung",25146,3.001,99.8164 ],
    [ u"id",u"Temanggung",42081,-7.175556,110.258333 ],
    [ u"id",u"Ternate",101736,.8,127.4 ],
    [ u"id",u"Tidore",46146,.666667,127.433333 ],
    [ u"id",u"Tomohon",27623,1.3346,124.8392 ],
    [ u"id",u"Tondano",33315,1.3038,124.9112 ],
    [ u"id",u"Trenggalek",29083,-8.05,111.716667 ],
    [ u"id",u"Trucuk",23584,-7.689167,110.341389 ],
    [ u"id",u"Tual",39501,-5.666667,132.75 ],
    [ u"id",u"Tuban",76251,-6.8976,112.0649 ],
    [ u"id",u"Tulangan",63890,-7.4737,112.6505 ],
    [ u"id",u"Tulungagung",65270,-8.0657,111.9025 ],
    [ u"id",u"Ubud",28373,-8.4203,115.223 ],
    [ u"id",u"Ungaran",127873,-7.139722,110.405 ],
    [ u"id",u"Waingapu",48829,-9.6567,120.2641 ],
    [ u"id",u"Wanaraja",26239,-7.1749,107.9808 ],
    [ u"id",u"Wanasari",25892,-6.8884,109.0283 ],
    [ u"id",u"Waru",147506,-7.36,112.724722 ],
    [ u"id",u"Wates",22916,-7.6072,112.0505 ],
    [ u"id",u"Wedi",55300,-7.743056,110.579444 ],
    [ u"id",u"Welahan",26163,-6.8,110.716667 ],
    [ u"id",u"Weleri",58454,-6.9713,110.0666 ],
    [ u"id",u"Weru",139013,-6.711,108.5037 ],
    [ u"id",u"Wlingi",29582,-8.0776,112.3311 ],
    [ u"id",u"Wonogiri",38623,-7.814444,110.920556 ],
    [ u"id",u"Wonopringgo",38430,-6.983333,109.616667 ],
    [ u"id",u"Wonosari",62961,-7.306111,110.773889 ],
    [ u"id",u"Wonosari",27458,-7.688056,110.391389 ],
    [ u"id",u"Wonosobo",93000,-7.0425,109.8851 ],
    [ u"id",u"Yogyakarta",636711,-7.782778,110.360833 ],
    [ u"ie",u"Abbeyfeale",1734,52.3813889,-9.3025 ],
    [ u"ie",u"Abbeyleix",1711,52.8991667,-7.3575 ],
    [ u"ie",u"Ardee",4008,53.8597222,-6.5405556 ],
    [ u"ie",u"Arklow",10622,52.7930556,-6.1413889 ],
    [ u"ie",u"Ashbourne",7001,53.5108333,-6.4272222 ],
    [ u"ie",u"Athboy",1656,53.6186111,-6.9205556 ],
    [ u"ie",u"Athenry",2419,53.2963889,-8.7430556 ],
    [ u"ie",u"Athlone",15951,53.4227778,-7.9372222 ],
    [ u"ie",u"Athy",6382,52.9913889,-6.9802778 ],
    [ u"ie",u"Bagenalstown",3033,52.6958333,-6.9897222 ],
    [ u"ie",u"Bailieborough",1703,53.9166667,-6.9666667 ],
    [ u"ie",u"Balbriggan",11293,53.6127778,-6.1819444 ],
    [ u"ie",u"Ballaghaderreen",1389,53.9,-8.5833333 ],
    [ u"ie",u"Ballina",10087,54.1166667,-9.1666667 ],
    [ u"ie",u"Ballinasloe",6388,53.3275,-8.2194444 ],
    [ u"ie",u"Ballinrobe",1707,53.6333333,-9.2333333 ],
    [ u"ie",u"Ballybofey",3848,54.8,-7.7833333 ],
    [ u"ie",u"Ballyhaunis",1344,53.7666667,-8.7666667 ],
    [ u"ie",u"Ballyshannon",2683,54.5,-8.1833333 ],
    [ u"ie",u"Banagher",1586,53.1886111,-7.9866667 ],
    [ u"ie",u"Bandon",5493,51.7469444,-8.7425 ],
    [ u"ie",u"Bantry",3234,51.6833333,-9.45 ],
    [ u"ie",u"Belturbet",1277,54.1,-7.45 ],
    [ u"ie",u"Birr",4549,53.0913889,-7.9133333 ],
    [ u"ie",u"Blarney",2215,51.9333333,-8.5666667 ],
    [ u"ie",u"Blessington",2874,53.17,-6.5325 ],
    [ u"ie",u"Boyle",2199,53.9666667,-8.3 ],
    [ u"ie",u"Bray",32317,53.2027778,-6.0983333 ],
    [ u"ie",u"Buncrana",5546,55.1333333,-7.45 ],
    [ u"ie",u"Bundoran",1865,54.4666667,-8.2833333 ],
    [ u"ie",u"Cahir",3057,52.3769444,-7.9216667 ],
    [ u"ie",u"Carlow",20055,52.8408333,-6.9261111 ],
    [ u"ie",u"Carndonagh",1581,55.25,-7.2666667 ],
    [ u"ie",u"Carrickmacross",3995,53.9727778,-6.7188889 ],
    [ u"ie",u"Carrick-on-Suir",5710,52.3491667,-7.4130556 ],
    [ u"ie",u"Carrigaline",12902,51.8116667,-8.3986111 ],
    [ u"ie",u"Cashel",2798,52.5158333,-7.8855556 ],
    [ u"ie",u"Castlebar",12874,53.85,-9.3 ],
    [ u"ie",u"Castleblayney",3006,54.1166667,-6.7333333 ],
    [ u"ie",u"Castlecomer",1686,52.8061111,-7.2105556 ],
    [ u"ie",u"Castleisland",2122,52.2333333,-9.4666667 ],
    [ u"ie",u"Castlerea",1770,53.7666667,-8.5 ],
    [ u"ie",u"Cavan",6388,53.9908333,-7.3605556 ],
    [ u"ie",u"Celbridge",18167,53.3386111,-6.5436111 ],
    [ u"ie",u"Charleville",2674,52.35,-8.6833333 ],
    [ u"ie",u"Clane",5155,53.2913889,-6.6891667 ],
    [ u"ie",u"Clara",2783,53.3425,-7.6138889 ],
    [ u"ie",u"Claremorris",2168,53.7166667,-9.0 ],
    [ u"ie",u"Clonakilty",4065,51.6230556,-8.8705556 ],
    [ u"ie",u"Clones",1834,54.1833333,-7.2333333 ],
    [ u"ie",u"Clonmel",17394,52.355,-7.7038889 ],
    [ u"ie",u"Cobh",10501,51.8572222,-8.2991667 ],
    [ u"ie",u"Cootehill",1713,54.0725,-7.0819444 ],
    [ u"ie",u"Cork",188908,51.8986111,-8.4958333 ],
    [ u"ie",u"Dingle",1971,52.1408333,-10.2688889 ],
    [ u"ie",u"Donabate",3936,53.4872222,-6.1519444 ],
    [ u"ie",u"Donegal",2513,54.65,-8.1166667 ],
    [ u"ie",u"Drogheda",33441,53.7188889,-6.3477778 ],
    [ u"ie",u"Dublin",1024027,53.3330556,-6.2488889 ],
    [ u"ie",u"Duleek",2376,53.6566667,-6.4191667 ],
    [ u"ie",u"Dunboyne",6718,53.4,-6.4666667 ],
    [ u"ie",u"Dundalk",33428,54.0,-6.4166667 ],
    [ u"ie",u"Dungarvan",7551,52.0880556,-7.6252778 ],
    [ u"ie",u"Dunmanway",1566,51.7166667,-9.1166667 ],
    [ u"ie",u"Dunmore East",1795,52.1513889,-6.9861111 ],
    [ u"ie",u"Dunshaughlin",3567,53.5125,-6.54 ],
    [ u"ie",u"Edenderry",4890,53.3452778,-7.0497222 ],
    [ u"ie",u"Enniscorthy",9709,52.5008333,-6.5577778 ],
    [ u"ie",u"Ennis",24427,52.8436111,-8.9863889 ],
    [ u"ie",u"Enniskerry",1990,53.1925,-6.1691667 ],
    [ u"ie",u"Fermoy",4933,52.1358333,-8.2758333 ],
    [ u"ie",u"Galway",70686,53.2719444,-9.0488889 ],
    [ u"ie",u"Gorey",6040,52.6747222,-6.2925 ],
    [ u"ie",u"Gort",2098,53.0663889,-8.8166667 ],
    [ u"ie",u"Granard",1292,53.7666667,-7.5 ],
    [ u"ie",u"Greystones",12260,53.1408333,-6.0630556 ],
    [ u"ie",u"Kanturk",1628,52.1666667,-8.9 ],
    [ u"ie",u"Kells",4820,53.7263889,-6.8791667 ],
    [ u"ie",u"Kenmare",2023,51.8833333,-9.5833333 ],
    [ u"ie",u"Kilcock",3293,53.4022222,-6.6708333 ],
    [ u"ie",u"Kilcoole",2869,53.1027778,-6.065 ],
    [ u"ie",u"Kilcormac",1200,53.1741667,-7.7255556 ],
    [ u"ie",u"Kilcullen",2110,53.1302778,-6.7444444 ],
    [ u"ie",u"Kildare",6380,53.1561111,-6.9144444 ],
    [ u"ie",u"Kilkenny",21589,52.6541667,-7.2522222 ],
    [ u"ie",u"Kill",2304,52.1761111,-7.335 ],
    [ u"ie",u"Killorglin",1409,52.1,-9.7833333 ],
    [ u"ie",u"Killybegs",1725,54.6333333,-8.45 ],
    [ u"ie",u"Kilmallock",1523,52.4,-8.5772222 ],
    [ u"ie",u"Kilrush",2712,52.6397222,-9.4833333 ],
    [ u"ie",u"Kinsale",3843,51.7075,-8.5305556 ],
    [ u"ie",u"Laytown",6342,53.6819444,-6.2391667 ],
    [ u"ie",u"Leixlip",15729,53.3658333,-6.4955556 ],
    [ u"ie",u"Letterkenny",16903,54.95,-7.7333333 ],
    [ u"ie",u"Lifford",1617,54.8319444,-7.4836111 ],
    [ u"ie",u"Limerick",90054,52.6647222,-8.6230556 ],
    [ u"ie",u"Listowel",4143,52.4463889,-9.485 ],
    [ u"ie",u"Longford",7787,53.7333333,-7.8 ],
    [ u"ie",u"Loughrea",4296,53.1969444,-8.5669444 ],
    [ u"ie",u"Lusk",2508,53.5280556,-6.1691667 ],
    [ u"ie",u"Macroom",3169,51.9,-8.95 ],
    [ u"ie",u"Malahide",14057,53.4508333,-6.1544444 ],
    [ u"ie",u"Mallow",9495,52.1333333,-8.6333333 ],
    [ u"ie",u"Maynooth",11318,53.385,-6.5936111 ],
    [ u"ie",u"Midleton",8891,51.9094444,-8.1736111 ],
    [ u"ie",u"Mitchelstown",3357,52.2658333,-8.2680556 ],
    [ u"ie",u"Moate",1504,53.55,-7.7166667 ],
    [ u"ie",u"Monaghan",5937,54.25,-6.9666667 ],
    [ u"ie",u"Monasterevan",2704,53.1405556,-7.0663889 ],
    [ u"ie",u"Mountmellick",3547,53.1136111,-7.32 ],
    [ u"ie",u"Mountrath",1597,52.9988889,-7.4727778 ],
    [ u"ie",u"Moville",1402,55.1833333,-7.05 ],
    [ u"ie",u"Mullingar",17262,53.5333333,-7.35 ],
    [ u"ie",u"Naas",20554,53.2158333,-6.6669444 ],
    [ u"ie",u"Navan",24545,53.6527778,-6.6813889 ],
    [ u"ie",u"Nenagh",6672,52.8619444,-8.1966667 ],
    [ u"ie",u"Newbridge",18860,53.1819444,-6.7966667 ],
    [ u"ie",u"Newcastle",4184,52.4491667,-9.0611111 ],
    [ u"ie",u"New Ross",6695,52.3966667,-6.9366667 ],
    [ u"ie",u"Oranmore",1758,53.2683333,-8.92 ],
    [ u"ie",u"Passage West",4907,51.8738889,-8.3444444 ],
    [ u"ie",u"Portarlington",4293,53.1622222,-7.1911111 ],
    [ u"ie",u"Portmarnock",8037,53.4230556,-6.1375 ],
    [ u"ie",u"Prosperous",1649,53.2902778,-6.7538889 ],
    [ u"ie",u"Rathangan",1961,53.2213889,-6.995 ],
    [ u"ie",u"Rathcoole",2443,53.2827778,-6.4727778 ],
    [ u"ie",u"Rathdrum",1649,52.9263889,-6.2355556 ],
    [ u"ie",u"Rathkeale",1470,52.5244444,-8.9380556 ],
    [ u"ie",u"Ratoath",4084,53.5080556,-6.4625 ],
    [ u"ie",u"Roscommon",4860,53.6333333,-8.1833333 ],
    [ u"ie",u"Roscrea",4721,52.9511111,-7.8016667 ],
    [ u"ie",u"Rush",7294,53.5247222,-6.1097222 ],
    [ u"ie",u"Sallins",3164,53.2488889,-6.6661111 ],
    [ u"ie",u"Shannon",8781,52.7038889,-8.8641667 ],
    [ u"ie",u"Skerries",10014,53.5827778,-6.1083333 ],
    [ u"ie",u"Skibbereen",2098,51.55,-9.2666667 ],
    [ u"ie",u"Sligo",20228,54.2666667,-8.4833333 ],
    [ u"ie",u"Swinford",1241,53.95,-8.95 ],
    [ u"ie",u"Swords",29816,53.4597222,-6.2180556 ],
    [ u"ie",u"Templemore",2264,52.7947222,-7.8338889 ],
    [ u"ie",u"Thomastown",1603,52.5266667,-7.1372222 ],
    [ u"ie",u"Thurles",7588,52.6819444,-7.8022222 ],
    [ u"ie",u"Tipperary",4976,52.4733333,-8.1558333 ],
    [ u"ie",u"Tower",3099,51.9166667,-8.6 ],
    [ u"ie",u"Tralee",22941,52.2666667,-9.7166667 ],
    [ u"ie",u"Tramore",9164,52.1588889,-7.1463889 ],
    [ u"ie",u"Trim",6781,53.555,-6.7916667 ],
    [ u"ie",u"Tuam",6130,53.5166667,-8.85 ],
    [ u"ie",u"Tullamore",11575,53.2738889,-7.4888889 ],
    [ u"ie",u"Tullow",2424,52.8002778,-6.7369444 ],
    [ u"ie",u"Waterford",47904,52.2583333,-7.1119444 ],
    [ u"ie",u"Westport",6200,53.8,-9.5166667 ],
    [ u"ie",u"Wexford",17708,52.3341667,-6.4575 ],
    [ u"ie",u"Wicklow",10461,52.975,-6.0494444 ],
    [ u"ie",u"Youghal",6868,51.95,-7.8505556 ],
    [ u"il",u"Abu Ghosh",5570,31.805925,35.1093 ],
    [ u"il",u"Ashdod",202681,31.736056,34.655944 ],
    [ u"il",u"Ashdod",202681,31.792133,34.649656 ],
    [ u"il",u"Ashqelon",108342,31.669256,34.57149 ],
    [ u"il",u"Azur",10338,32.019167,34.810556 ],
    [ u"il",u"Bat Yam",130973,32.023056,34.750278 ],
    [ u"il",u"Beit Jann",10001,32.964638,35.381522 ],
    [ u"il",u"Bene Ayish",8193,31.789593,34.760655 ],
    [ u"il",u"Bene Beraq",140849,32.090278,34.839722 ],
    [ u"il",u"Bet Dagan",5990,32.001389,34.830278 ],
    [ u"il",u"Bet Shemesh",64838,31.749587,34.988768 ],
    [ u"il",u"Bet Yizhaq",1674,32.327511,34.88878 ],
    [ u"il",u"Deir Hanna",8658,32.861963,35.363652 ],
    [ u"il",u"Dimona",33354,31.066667,35.033333 ],
    [ u"il",u"Elat",46707,29.558049,34.948212 ],
    [ u"il",u"Elyakhin",2728,32.407931,34.924332 ],
    [ u"il",u"Even Yehuda",9091,32.269593,34.887592 ],
    [ u"il",u"Fassuta",2985,33.048952,35.308935 ],
    [ u"il",u"Fureidis",9805,32.6,34.95 ],
    [ u"il",u"Ganne Tiqwa",12408,32.060278,34.874722 ],
    [ u"il",u"Gan Yavne",14830,31.787373,34.706592 ],
    [ u"il",u"Gedera",14267,31.814561,34.779979 ],
    [ u"il",u"Haifa",269961,32.815556,34.989167 ],
    [ u"il",u"Hod HaSharon",42996,32.150833,34.888333 ],
    [ u"il",u"Hurfeish",5252,33.017108,35.348352 ],
    [ u"il",u"Ibtin",2020,32.761667,35.100833 ],
    [ u"il",u"Iksal",11213,32.68164,35.323646 ],
    [ u"il",u"Jaljulye",7580,32.155833,34.952778 ],
    [ u"il",u"Jerusalem",714685,31.78,35.23 ],
    [ u"il",u"Jish",2684,33.022157,35.446941 ],
    [ u"il",u"Kabul",9301,32.866667,35.213056 ],
    [ u"il",u"Kafar Kama",2990,32.721288,35.441217 ],
    [ u"il",u"Kafar Manda",14771,32.807222,35.260278 ],
    [ u"il",u"Kafar Qasem",17189,32.114167,34.973889 ],
    [ u"il",u"Kefar Habad",4771,31.986667,34.851111 ],
    [ u"il",u"Kefar Sava",80922,32.175,34.906944 ],
    [ u"il",u"Kefar Shemaryahu",1774,32.185556,34.821944 ],
    [ u"il",u"Kefar Tavor",2323,32.686555,35.421177 ],
    [ u"il",u"Kefar Weradim",5559,32.993849,35.277933 ],
    [ u"il",u"Kefar Yona",12771,32.316692,34.935073 ],
    [ u"il",u"Lod",68095,31.951389,34.895278 ],
    [ u"il",u"Mazkeret Batya",8283,31.853889,34.838611 ],
    [ u"il",u"Mizpe Ramon",4769,30.609444,34.801111 ],
    [ u"il",u"Nahariyya",50881,33.005855,35.094087 ],
    [ u"il",u"Nahef",10077,32.933333,35.316667 ],
    [ u"il",u"Nehalim",2061,32.061944,34.913889 ],
    [ u"il",u"Nein",1588,32.630634,35.348847 ],
    [ u"il",u"Nesher",21811,32.765,35.05 ],
    [ u"il",u"Netanya",172405,32.332915,34.859918 ],
    [ u"il",u"Netivot",24933,31.42215,34.588581 ],
    [ u"il",u"Nordiyya",2264,32.314697,34.89617 ],
    [ u"il",u"Ofaqim",24633,31.314099,34.620254 ],
    [ u"il",u"Or Yehuda",30977,32.031111,34.845833 ],
    [ u"il",u"Pardesiyya",6348,32.305774,34.909111 ],
    [ u"il",u"Qesarya",4300,32.507982,34.904867 ],
    [ u"il",u"Qiryat Atta",49548,32.800556,35.106389 ],
    [ u"il",u"Qiryat Bialik",37385,32.8275,35.085833 ],
    [ u"il",u"Qiryat Gat",48946,31.609981,34.764224 ],
    [ u"il",u"Qiryat Motzkin",40694,32.836389,35.075278 ],
    [ u"il",u"Qiryat Ono",24907,32.063611,34.855278 ],
    [ u"il",u"Qiryat Ono",24907,32.022222,34.866667 ],
    [ u"il",u"Qiryat Shemona",22738,33.207334,35.572118 ],
    [ u"il",u"Qiryat Yam",38122,32.850833,35.070278 ],
    [ u"il",u"Ramat Gan",126864,32.080556,34.814167 ],
    [ u"il",u"Ramat HaSharon",35556,32.147222,34.841667 ],
    [ u"il",u"Ramat Yishay",5722,32.700556,35.179722 ],
    [ u"il",u"Ramla",63837,31.925278,34.866944 ],
    [ u"il",u"Reine",16157,32.723611,35.3125 ],
    [ u"il",u"Rekhasim",8521,32.75,35.1 ],
    [ u"il",u"Rosh Pinna",2492,32.968938,35.542584 ],
    [ u"il",u"Rumat Heib",1588,32.779167,35.306944 ],
    [ u"il",u"Sajur",3547,32.942661,35.341358 ],
    [ u"il",u"Sakhnin",24401,32.862222,35.293333 ],
    [ u"il",u"Sallama",1800,32.89443,35.369313 ],
    [ u"il",u"Savyon",3434,32.053056,34.877778 ],
    [ u"il",u"Sederot",20865,31.524995,34.59693 ],
    [ u"il",u"Sheikh Dannun",2305,32.992306,35.147901 ],
    [ u"il",u"Shelomi",5784,33.074719,35.146075 ],
    [ u"il",u"Sulam",2426,32.606057,35.334078 ],
    [ u"il",u"Tamra",25839,32.848611,35.204722 ],
    [ u"il",u"Tayibe",32736,32.266161,35.008932 ],
    [ u"il",u"Tel Aviv-Yafo",370480,32.067778,34.764722 ],
    [ u"il",u"Tel Mond",8939,32.249947,34.917368 ],
    [ u"il",u"Tiberias",41029,32.792205,35.531244 ],
    [ u"il",u"Timrat",1789,32.703611,35.226667 ],
    [ u"il",u"Tirat Karmel",19234,32.761667,34.971944 ],
    [ u"il",u"Uzeir",2591,32.792124,35.329841 ],
    [ u"il",u"Yavne",32394,31.81555,34.7208 ],
    [ u"il",u"Yeroham",9148,30.987222,34.931389 ],
    [ u"in",u"Abhayapuri",15803,26.333333,90.666667 ],
    [ u"in",u"Abiramam",6837,9.466667,78.45 ],
    [ u"in",u"Abohar",130613,30.15,74.183333 ],
    [ u"in",u"Abu Road",50266,24.483333,72.783333 ],
    [ u"in",u"Achalpur",111287,21.257222,77.508611 ],
    [ u"in",u"Achhnera",20534,27.183333,77.766667 ],
    [ u"in",u"Adalaj",10423,23.166667,72.583333 ],
    [ u"in",u"Addanki",28547,15.816667,79.983333 ],
    [ u"in",u"Adilabad",118539,19.666667,78.533333 ],
    [ u"in",u"Adoni",163649,15.633333,77.283333 ],
    [ u"in",u"Adra",22183,23.5,86.666667 ],
    [ u"in",u"Adur",29655,9.166667,76.733333 ],
    [ u"in",u"Aduturai",11434,11.033333,79.483333 ],
    [ u"in",u"Afzalgarh",27756,29.4,78.683333 ],
    [ u"in",u"Afzalpur",20094,17.2,76.35 ],
    [ u"in",u"Agar",34536,23.7,76.016667 ],
    [ u"in",u"Agartala",203292,23.836389,91.275 ],
    [ u"in",u"Agra",1430194,27.183333,78.016667 ],
    [ u"in",u"Ahmadabad",3719933,23.033333,72.616667 ],
    [ u"in",u"Ahmadnagar",367168,19.083333,74.733333 ],
    [ u"in",u"Ahmadpur",40221,18.7,76.933333 ],
    [ u"in",u"Ahmadpur",8855,23.833333,87.7 ],
    [ u"in",u"Ahraura",25078,25.016667,83.016667 ],
    [ u"in",u"Ahwa",14321,20.75,73.683333 ],
    [ u"in",u"Aizawl",265353,23.724444,92.7175 ],
    [ u"in",u"Ajaigarh",14642,24.9,80.266667 ],
    [ u"in",u"Ajjampur",10795,13.728056,76.009444 ],
    [ u"in",u"Ajmer",517947,26.45,74.633333 ],
    [ u"in",u"Ajnala",19691,31.8425,74.758889 ],
    [ u"in",u"Ajra",15864,16.116667,74.2 ],
    [ u"in",u"Akalgarh",6993,29.816667,75.883333 ],
    [ u"in",u"Akalkot",39229,17.533333,76.216667 ],
    [ u"in",u"Akaltara",21335,22.016667,82.433333 ],
    [ u"in",u"Akbarpur",18837,26.383333,79.95 ],
    [ u"in",u"Akhnur",12803,32.866667,74.733333 ],
    [ u"in",u"Akividu",40421,16.6,81.383333 ],
    [ u"in",u"Aklera",19684,24.416667,76.566667 ],
    [ u"in",u"Akodia",11280,23.383333,76.6 ],
    [ u"in",u"Akola",428892,20.733333,77 ],
    [ u"in",u"Akot",86924,21.096389,77.058611 ],
    [ u"in",u"Alampur",14060,15.883333,78.15 ],
    [ u"in",u"Alampur",10020,26.024444,78.7925 ],
    [ u"in",u"Aland",39067,17.566667,76.566667 ],
    [ u"in",u"Alandi",21385,18.666667,73.9 ],
    [ u"in",u"Alandur",153789,13.0025,80.206111 ],
    [ u"in",u"Alanganallur",11400,10.066667,78.05 ],
    [ u"in",u"Alangayam",17357,12.6,78.75 ],
    [ u"in",u"Alangudi",10618,10.366667,78.983333 ],
    [ u"in",u"Alangulam",28585,8.866667,77.5 ],
    [ u"in",u"Alappuzha",176799,9.494167,76.3275 ],
    [ u"in",u"Alapur",22622,27.9136,79.2458 ],
    [ u"in",u"Alawalpur",7411,31.432778,75.650833 ],
    [ u"in",u"Aldona",6606,15.583333,73.866667 ],
    [ u"in",u"Alibag",20754,18.641111,72.879167 ],
    [ u"in",u"Aliganj",26655,27.5,79.183333 ],
    [ u"in",u"Aligarh",753280,27.883333,78.083333 ],
    [ u"in",u"Alipur",20738,28.8,77.15 ],
    [ u"in",u"Alipur Duar",75936,26.483333,89.566667 ],
    [ u"in",u"Alirajpur",26446,22.3,74.35 ],
    [ u"in",u"Allahabad",1073544,25.45,81.85 ],
    [ u"in",u"Allahganj",13825,27.5461,79.6878 ],
    [ u"in",u"Allapalli",10772,19.416667,80.066667 ],
    [ u"in",u"Almora",32446,29.616667,79.666667 ],
    [ u"in",u"Alnavar",16928,15.433333,74.733333 ],
    [ u"in",u"Along",18427,28.166667,94.766667 ],
    [ u"in",u"Alot",23136,23.766667,75.55 ],
    [ u"in",u"Alur",6605,12.983333,75.983333 ],
    [ u"in",u"Alwar",283248,27.566667,76.6 ],
    [ u"in",u"Alwar Tirunagari",8888,8.6,77.95 ],
    [ u"in",u"Alwaye",23705,10.109167,76.364444 ],
    [ u"in",u"Amalapuram",52696,16.583333,82.016667 ],
    [ u"in",u"Amalner",97377,21.05,75.066667 ],
    [ u"in",u"Amanganj",13169,24.433333,80.033333 ],
    [ u"in",u"Amanpur",10363,27.716667,78.75 ],
    [ u"in",u"Amarkantak",7613,22.666667,81.75 ],
    [ u"in",u"Amarpatan",16860,24.316667,80.983333 ],
    [ u"in",u"Amarpur",11908,23.53,91.644722 ],
    [ u"in",u"Amarpur",22796,25.033333,86.9 ],
    [ u"in",u"Amarwara",13259,22.3,79.166667 ],
    [ u"in",u"Ambad",29849,19.616667,75.8 ],
    [ u"in",u"Ambagarh Chauki",9266,20.783333,80.716667 ],
    [ u"in",u"Ambah",40528,26.7075,78.226111 ],
    [ u"in",u"Ambahta",14304,29.85,77.333333 ],
    [ u"in",u"Ambajogai",74120,18.733333,76.383333 ],
    [ u"in",u"Ambala",146797,30.378333,76.780833 ],
    [ u"in",u"Ambarnath",217778,19.2,73.166667 ],
    [ u"in",u"Ambasamudram",32022,8.7,77.466667 ],
    [ u"in",u"Ambattur",341078,13.076667,80.088611 ],
    [ u"in",u"Ambikapur",72829,23.116667,83.2 ],
    [ u"in",u"Ambur",109883,12.783333,78.7 ],
    [ u"in",u"Amet",17435,25.3,73.933333 ],
    [ u"in",u"Amethi",12207,28.016667,81.05 ],
    [ u"in",u"Amguri",8496,26.8,94.533333 ],
    [ u"in",u"Amla",29998,21.933333,78.116667 ],
    [ u"in",u"Amlagora",19038,22.833333,87.333333 ],
    [ u"in",u"Amli",33368,20.283333,73.016667 ],
    [ u"in",u"Amloh",13860,30.6084,76.2319 ],
    [ u"in",u"Ammapettai",14529,10.8,79.333333 ],
    [ u"in",u"Amod",18742,21.983333,72.9 ],
    [ u"in",u"Amravati",603885,20.933333,77.75 ],
    [ u"in",u"Amreli",99748,21.616667,71.233333 ],
    [ u"in",u"Amritsar",1092528,31.633056,74.865556 ],
    [ u"in",u"Amroha",176271,28.916667,78.466667 ],
    [ u"in",u"Amroli",17082,21.3,72.85 ],
    [ u"in",u"Amta",16753,22.58,88.008333 ],
    [ u"in",u"Amtala",8267,22.371389,88.294444 ],
    [ u"in",u"Amudalavalasa",39129,18.416667,83.9 ],
    [ u"in",u"Amur",40811,18.8,78.283333 ],
    [ u"in",u"Anaimalai",16132,10.583333,76.933333 ],
    [ u"in",u"Anakapalle",84367,17.683333,83.016667 ],
    [ u"in",u"Anand",138018,22.566667,72.933333 ],
    [ u"in",u"Anandnagar",11221,27.1,83.283333 ],
    [ u"in",u"Anandpur Sahib",15230,31.25,76.5 ],
    [ u"in",u"Anantapur",240469,14.683333,77.6 ],
    [ u"in",u"Anantnag",79827,33.733333,75.15 ],
    [ u"in",u"Andippatti",24450,9.983333,77.633333 ],
    [ u"in",u"Anekal",36696,12.7,77.7 ],
    [ u"in",u"Angamali",34402,10.2,76.4 ],
    [ u"in",u"Angul",44390,20.85,85.1 ],
    [ u"in",u"Anjad",24289,22.033333,75.05 ],
    [ u"in",u"Anjangaon",55003,21.163056,77.309444 ],
    [ u"in",u"Anjar",66887,23.133333,70.016667 ],
    [ u"in",u"Anklesvar",74747,21.6,73 ],
    [ u"in",u"Ankola",14541,14.666667,74.3 ],
    [ u"in",u"Annamalainagar",8828,11.4,79.733333 ],
    [ u"in",u"Annavasal",7861,10.466667,78.7 ],
    [ u"in",u"Annigeri",25755,15.433333,75.433333 ],
    [ u"in",u"Annur",19964,11.233333,77.133333 ],
    [ u"in",u"Antri",9788,26.056667,78.214444 ],
    [ u"in",u"Antu",8317,26.05,81.916667 ],
    [ u"in",u"Anupgarh",33311,29.191111,73.208611 ],
    [ u"in",u"Anuppur",18124,23.1,81.683333 ],
    [ u"in",u"Anupshahr",25308,28.366667,78.266667 ],
    [ u"in",u"Aonla",50016,28.283333,79.15 ],
    [ u"in",u"Ara",223700,25.566667,84.666667 ],
    [ u"in",u"Arambagh",60644,22.883333,87.783333 ],
    [ u"in",u"Arang",17505,21.2,81.966667 ],
    [ u"in",u"Arani",62863,12.666667,79.283333 ],
    [ u"in",u"Arantangi",35624,10.166667,78.983333 ],
    [ u"in",u"Araria",67482,26.15,87.516667 ],
    [ u"in",u"Aravankadu",5176,11.366667,76.766667 ],
    [ u"in",u"Arcot",51948,12.9,79.333333 ],
    [ u"in",u"Arimalam",8048,10.266667,78.9 ],
    [ u"in",u"Ariyalur",29146,11.133333,79.083333 ],
    [ u"in",u"Arkalgud",15803,12.765,76.056944 ],
    [ u"in",u"Arki",3293,31.15,76.966667 ],
    [ u"in",u"Arnia",9662,32.516667,74.8 ],
    [ u"in",u"Aron",24277,24.383333,77.416667 ],
    [ u"in",u"Arsikere",44272,13.313889,76.256111 ],
    [ u"in",u"Arukutti",17945,9.866667,76.35 ],
    [ u"in",u"Arumbavur",11419,11.383333,78.733333 ],
    [ u"in",u"Arumuganeri",25154,8.566667,78.116667 ],
    [ u"in",u"Aruppukkottai",85377,9.516667,78.1 ],
    [ u"in",u"Arvi",41840,20.983333,78.233333 ],
    [ u"in",u"Asandh",25325,29.516667,76.6 ],
    [ u"in",u"Asansol",504320,23.683333,86.983333 ],
    [ u"in",u"Asarganj",6020,25.15,86.683333 ],
    [ u"in",u"Ashoknagar",64729,24.566667,77.716667 ],
    [ u"in",u"Ashta",35500,16.95,74.4 ],
    [ u"in",u"Ashta",45370,23.016667,76.716667 ],
    [ u"in",u"Ashti",13083,19.383333,76.233333 ],
    [ u"in",u"Asifabad",21216,19.366667,79.283333 ],
    [ u"in",u"Asind",15390,25.733333,74.333333 ],
    [ u"in",u"Aska",21136,19.6,84.65 ],
    [ u"in",u"Atarra",46173,25.283333,80.566667 ],
    [ u"in",u"Ateli",6177,28.1,76.283333 ],
    [ u"in",u"Athgarh",16667,20.533333,85.616667 ],
    [ u"in",u"Athmallik",11918,20.716667,84.533333 ],
    [ u"in",u"Athni",42051,16.733333,75.066667 ],
    [ u"in",u"Atmakur",35137,15.883333,78.583333 ],
    [ u"in",u"Atraulia",11849,26.333333,82.95 ],
    [ u"in",u"Atrauli",47516,28.033333,78.283333 ],
    [ u"in",u"Attayyampatti",13628,11.533333,78.066667 ],
    [ u"in",u"Attingal",36599,8.683333,76.833333 ],
    [ u"in",u"Attur",58707,11.6,78.616667 ],
    [ u"in",u"Aurad",17019,18.25,77.433333 ],
    [ u"in",u"Auraiya",70515,26.466667,79.516667 ],
    [ u"in",u"Aurangabad",22108,28.033333,77.333333 ],
    [ u"in",u"Aurangabad",1016520,19.883333,75.333333 ],
    [ u"in",u"Aurangabad",95939,24.75,84.366667 ],
    [ u"in",u"Auras",6592,26.916667,80.516667 ],
    [ u"in",u"Ausa",34164,18.25,76.5 ],
    [ u"in",u"Avadi",250066,13.115556,80.101667 ],
    [ u"in",u"Avanashi",24329,11.2,77.283333 ],
    [ u"in",u"Avanigadda",25761,16.016667,80.916667 ],
    [ u"in",u"Ayakudi",24120,10.45,77.55 ],
    [ u"in",u"Ayodhya",53298,26.8,82.2 ],
    [ u"in",u"Ayyampettai",14704,10.9,79.183333 ],
    [ u"in",u"Azamgarh",116655,26.06,83.186111 ],
    [ u"in",u"Babai",16177,22.7,77.933333 ],
    [ u"in",u"Baberu",15608,25.55,80.716667 ],
    [ u"in",u"Babina",35542,25.25,78.466667 ],
    [ u"in",u"Babra",18993,21.85,71.3 ],
    [ u"in",u"Babrala",16671,28.266667,78.4 ],
    [ u"in",u"Babugarh",7156,28.716667,77.85 ],
    [ u"in",u"Bachhraon",29235,28.933333,78.216667 ],
    [ u"in",u"Badami",28316,15.916667,75.683333 ],
    [ u"in",u"Badarpur",11033,24.9,92.6 ],
    [ u"in",u"Badarwas",11135,24.966667,77.566667 ],
    [ u"in",u"Badgam",20948,34.016667,74.716667 ],
    [ u"in",u"Badhni Kalan",6072,30.683333,75.283333 ],
    [ u"in",u"Badlapur",104636,19.15,73.266667 ],
    [ u"in",u"Badnawar",18792,23.016667,75.216667 ],
    [ u"in",u"Baduria",49552,22.741667,88.785833 ],
    [ u"in",u"Badvel",16238,14.75,79.05 ],
    [ u"in",u"Bagaha",103866,27.1,84.083333 ],
    [ u"in",u"Bagalkot",97277,16.183333,75.7 ],
    [ u"in",u"Bagar",15671,28.1874,75.5005 ],
    [ u"in",u"Bagasara",32946,21.483333,70.95 ],
    [ u"in",u"Bagepalli",24033,13.784722,77.793056 ],
    [ u"in",u"Bageshwar",8708,29.85,79.766667 ],
    [ u"in",u"Bagh",7764,22.366667,74.766667 ],
    [ u"in",u"Baghdogra",17373,26.7,88.316667 ],
    [ u"in",u"Baghmara",9950,22.253611,88.870556 ],
    [ u"in",u"Baghpat",41770,28.95,77.216667 ],
    [ u"in",u"Bagli",10765,22.65,76.35 ],
    [ u"in",u"Bagnan",8501,22.924167,88.14 ],
    [ u"in",u"Bagra",11364,23.733333,86.316667 ],
    [ u"in",u"Bagru",25102,26.8084,75.5435 ],
    [ u"in",u"Bagula",20999,23.316667,88.65 ],
    [ u"in",u"Bahadurganj",31408,26.266667,87.816667 ],
    [ u"in",u"Bahadurgarh",153666,28.683333,76.916667 ],
    [ u"in",u"Baharampur",180564,24.1,88.25 ],
    [ u"in",u"Bah",15360,26.87,78.5975 ],
    [ u"in",u"Baheri",63959,28.783333,79.5 ],
    [ u"in",u"Bahjoi",33756,28.4,78.616667 ],
    [ u"in",u"Bahraich",182236,27.583333,81.6 ],
    [ u"in",u"Bahsuma",11158,29.216667,77.966667 ],
    [ u"in",u"Bahua",10244,25.85,80.633333 ],
    [ u"in",u"Baidyabati",115515,22.785,88.324722 ],
    [ u"in",u"Baihar",16170,22.1,80.55 ],
    [ u"in",u"Baikunthpur",10180,24.716667,81.416667 ],
    [ u"in",u"Baikunthpur",10791,23.25,82.55 ],
    [ u"in",u"Bail Hongal",47067,15.816667,74.866667 ],
    [ u"in",u"Baindur",20322,13.866667,74.633333 ],
    [ u"in",u"Baj Baj",76166,22.474722,88.170278 ],
    [ u"in",u"Bajna",7674,27.9,77.683333 ],
    [ u"in",u"Bakani",8621,24.283333,76.233333 ],
    [ u"in",u"Bakewar",14219,26.666667,79.183333 ],
    [ u"in",u"Bakhtiyarpur",34537,25.466667,85.516667 ],
    [ u"in",u"Bakloh",1737,32.466667,75.916667 ],
    [ u"in",u"Bakreswar",1739,23.883333,87.366667 ],
    [ u"in",u"Balaghat",80368,21.783333,80.25 ],
    [ u"in",u"Balangir",91249,20.716667,83.483333 ],
    [ u"in",u"Balapur",42404,20.666667,76.766667 ],
    [ u"in",u"Balarampur",22849,23.116667,86.216667 ],
    [ u"in",u"Balasinor",35151,22.95,73.333333 ],
    [ u"in",u"Baldeo",10537,27.416667,77.816667 ],
    [ u"in",u"Baldeogarh",8283,24.755,79.0681 ],
    [ u"in",u"Baleshwar",114331,21.494167,86.931667 ],
    [ u"in",u"Bali",19260,25.183333,73.283333 ],
    [ u"in",u"Bali Chak",12958,22.366667,87.55 ],
    [ u"in",u"Ballarpur",92154,19.833333,79.35 ],
    [ u"in",u"Ballia",109722,25.75,84.166667 ],
    [ u"in",u"Bally",297001,22.646111,88.340278 ],
    [ u"in",u"Baloda",12039,22.15,82.483333 ],
    [ u"in",u"Baloda Bazar",25238,21.666667,82.166667 ],
    [ u"in",u"Balod",22277,20.73,81.204722 ],
    [ u"in",u"Balotra",68125,25.833333,72.233333 ],
    [ u"in",u"Balrampur",77404,27.433333,82.183333 ],
    [ u"in",u"Balugaon",17240,20.166667,85.1 ],
    [ u"in",u"Balurghat",141418,25.216667,88.766667 ],
    [ u"in",u"Bambolim",5441,15.45,73.85 ],
    [ u"in",u"Bamora",7981,24.0552,78.0909 ],
    [ u"in",u"Banapur",17501,19.783333,85.183333 ],
    [ u"in",u"Banat",21582,29.466667,77.35 ],
    [ u"in",u"Banavar",7827,13.413611,76.168333 ],
    [ u"in",u"Banda",28981,24.0448,78.9626 ],
    [ u"in",u"Banda",152233,25.483333,80.333333 ],
    [ u"in",u"Bandikui",16166,27.05,76.566667 ],
    [ u"in",u"Bandipur",31980,34.416667,74.65 ],
    [ u"in",u"Bandora",12819,15.4,73.966667 ],
    [ u"in",u"Banga",19236,31.186944,75.992222 ],
    [ u"in",u"Bangalore",4931603,12.983333,77.583333 ],
    [ u"in",u"Banganapalle",25325,15.316667,78.233333 ],
    [ u"in",u"Bangaon",111704,23.066667,88.816667 ],
    [ u"in",u"Bangarapet",42793,12.966667,78.2 ],
    [ u"in",u"Bangarmau",37429,26.9,80.216667 ],
    [ u"in",u"Banihal",3278,33.416667,75.2 ],
    [ u"in",u"Banjar",1351,31.633333,77.35 ],
    [ u"in",u"Banka",38943,24.883333,86.916667 ],
    [ u"in",u"Banki",16557,20.383333,85.533333 ],
    [ u"in",u"Bankra",56278,22.6275,88.298056 ],
    [ u"in",u"Bankura",133979,23.25,87.066667 ],
    [ u"in",u"Banmankhi",26809,25.883333,87.183333 ],
    [ u"in",u"Bannur",25457,12.330833,76.863056 ],
    [ u"in",u"Banposh",10431,22.25,84.8 ],
    [ u"in",u"Bansbaria",108485,22.971944,88.399444 ],
    [ u"in",u"Bansda",12702,20.75,73.366667 ],
    [ u"in",u"Bansdih",21459,25.883333,84.216667 ],
    [ u"in",u"Bansgaon",14284,26.558611,83.348056 ],
    [ u"in",u"Bansi",39930,27.183333,82.933333 ],
    [ u"in",u"Banswada",22665,18.383333,77.883333 ],
    [ u"in",u"Banswara",93654,23.55,74.45 ],
    [ u"in",u"Bantva",15052,21.486389,70.068889 ],
    [ u"in",u"Bapatla",70125,15.9,80.466667 ],
    [ u"in",u"Baragaon",11362,25.433333,82.816667 ],
    [ u"in",u"Barakpur",148188,22.761389,88.371944 ],
    [ u"in",u"Baramati",53923,18.15,74.583333 ],
    [ u"in",u"Baramula",77282,34.211111,74.340833 ],
    [ u"in",u"Baranagar",260097,22.643333,88.365278 ],
    [ u"in",u"Baran",87484,25.1,76.516667 ],
    [ u"in",u"Barasat",298270,22.684167,88.441111 ],
    [ u"in",u"Barauli",37306,26.4,84.583333 ],
    [ u"in",u"Baraut",93553,29.1,77.266667 ],
    [ u"in",u"Bar Bigha",41763,25.216667,85.733333 ],
    [ u"in",u"Barddhaman",301754,23.240556,87.869444 ],
    [ u"in",u"Bardoli",57814,21.116667,73.116667 ],
    [ u"in",u"Barela",11649,23.1,80.05 ],
    [ u"in",u"Bareli",745509,28.35,79.416667 ],
    [ u"in",u"Bargarh",68676,21.333333,83.616667 ],
    [ u"in",u"Barghat",11221,22.033333,79.716667 ],
    [ u"in",u"Bargi",17589,22.983333,79.866667 ],
    [ u"in",u"Bargur",12959,12.55,78.366667 ],
    [ u"in",u"Barh",49562,25.483333,85.716667 ],
    [ u"in",u"Barhi",12138,23.9,80.8 ],
    [ u"in",u"Barhi",10655,24.3,85.416667 ],
    [ u"in",u"Barhiya",43049,25.283333,86.033333 ],
    [ u"in",u"Bari",56140,26.65,77.6 ],
    [ u"in",u"Baripada",116227,21.935,86.721389 ],
    [ u"in",u"Bari Sadri",15617,24.416667,74.466667 ],
    [ u"in",u"Barjora",12296,23.433333,87.283333 ],
    [ u"in",u"Barka Kana",18184,23.616667,85.483333 ],
    [ u"in",u"Barkhera",11210,28.45,79.8 ],
    [ u"in",u"Barkot",7726,30.816667,78.2 ],
    [ u"in",u"Barmer",89493,25.75,71.383333 ],
    [ u"in",u"Barnala",105024,30.383333,75.55 ],
    [ u"in",u"Barpali",20204,21.2,83.583333 ],
    [ u"in",u"Barpathar",7445,26.3,93.866667 ],
    [ u"in",u"Barpeta",48826,26.316667,91 ],
    [ u"in",u"Barsana",9816,27.65,77.383333 ],
    [ u"in",u"Barsi",110992,18.233333,75.7 ],
    [ u"in",u"Baruipur",47878,22.349722,88.439167 ],
    [ u"in",u"Baruni",84889,25.483333,85.983333 ],
    [ u"in",u"Barwadih",7402,23.833333,84.116667 ],
    [ u"in",u"Barwaha",24423,22.266667,76.05 ],
    [ u"in",u"Barwala",36696,29.383333,75.916667 ],
    [ u"in",u"Barwani",47348,22.033333,74.9 ],
    [ u"in",u"Basar",4157,27.983333,94.666667 ],
    [ u"in",u"Basavakalyan",65810,17.866667,76.95 ],
    [ u"in",u"Basavana Bagevadi",30829,16.583333,75.966667 ],
    [ u"in",u"Basi",21096,26.833333,76.033333 ],
    [ u"in",u"Basirhat",117431,22.657222,88.894167 ],
    [ u"in",u"Basmat",63977,19.316667,77.166667 ],
    [ u"in",u"Basna",9305,21.283333,82.816667 ],
    [ u"in",u"Basoda",69285,23.6,78.183333 ],
    [ u"in",u"Basti",115126,26.8,82.716667 ],
    [ u"in",u"Basudebpur",31830,21.135278,86.738611 ],
    [ u"in",u"Basugaon",12833,26.466667,90.4 ],
    [ u"in",u"Baswa",22515,27.15,76.583333 ],
    [ u"in",u"Batala",145479,31.818611,75.202778 ],
    [ u"in",u"Batote",4209,33.1,75.316667 ],
    [ u"in",u"Baudh",18947,20.833333,84.316667 ],
    [ u"in",u"Bawal",13319,28.083333,76.583333 ],
    [ u"in",u"Bawana",24908,28.8,77.033333 ],
    [ u"in",u"Bayana",36402,26.9,77.283333 ],
    [ u"in",u"Bazpur",23902,29.15,79.116667 ],
    [ u"in",u"Beawar",130786,26.1,74.316667 ],
    [ u"in",u"Bedi",21328,22.5,70.05 ],
    [ u"in",u"Begamganj",33470,23.6,78.333333 ],
    [ u"in",u"Begampur",9832,22.741667,88.243333 ],
    [ u"in",u"Begowal",10175,31.616667,75.516667 ],
    [ u"in",u"Begun",20837,24.983333,75 ],
    [ u"in",u"Begusarai",103071,25.416667,86.133333 ],
    [ u"in",u"Behat",18225,30.166667,77.616667 ],
    [ u"in",u"Bela",74000,25.933333,81.983333 ],
    [ u"in",u"Belaguntha",10361,19.883333,84.65 ],
    [ u"in",u"Beldanga",27491,23.933333,88.25 ],
    [ u"in",u"Belgaum",428756,15.866667,74.5 ],
    [ u"in",u"Beliator",6014,23.333333,87.216667 ],
    [ u"in",u"Bellary",336710,15.15,76.933333 ],
    [ u"in",u"Belluru",7626,12.991111,76.744444 ],
    [ u"in",u"Belonia",16737,23.252778,91.451389 ],
    [ u"in",u"Belsand",19398,26.45,85.4 ],
    [ u"in",u"Beltangadi",7676,13.983333,75.3 ],
    [ u"in",u"Belur",21553,13.166667,75.866667 ],
    [ u"in",u"Belur",9281,11.7,78.416667 ],
    [ u"in",u"Benaulim",10225,15.25,73.916667 ],
    [ u"in",u"Beniganj",10419,27.283333,80.45 ],
    [ u"in",u"Beohari",22110,24.05,81.383333 ],
    [ u"in",u"Berasia",27093,23.633333,77.433333 ],
    [ u"in",u"Beri",16729,28.7,76.583333 ],
    [ u"in",u"Beswan",5897,27.65,77.883333 ],
    [ u"in",u"Betamcherla",35421,15.466667,78.166667 ],
    [ u"in",u"Betma",13818,22.683333,75.616667 ],
    [ u"in",u"Bettiah",127022,26.8,84.5 ],
    [ u"in",u"Betul Bazar",9641,21.856111,77.9275 ],
    [ u"in",u"Betul",91963,21.856111,77.9275 ],
    [ u"in",u"Bewar",23283,27.2184,79.3005 ],
    [ u"in",u"Beypur",70758,11.183333,75.816667 ],
    [ u"in",u"Bhabua",48646,25.05,83.616667 ],
    [ u"in",u"Bhachau",24044,23.283333,70.35 ],
    [ u"in",u"Bhadasar",33009,28.283333,74.316667 ],
    [ u"in",u"Bhaderwah",13430,32.983333,75.716667 ],
    [ u"in",u"Bhadohi",78576,25.416667,82.566667 ],
    [ u"in",u"Bhadra",37632,29.116667,75.166667 ],
    [ u"in",u"Bhadrachalam",45661,17.666667,80.883333 ],
    [ u"in",u"Bhadrak",98657,21.052778,86.52 ],
    [ u"in",u"Bhadravati",163917,13.866667,75.716667 ],
    [ u"in",u"Bhadreswar",121674,22.824444,88.350556 ],
    [ u"in",u"Bhagalpur",361587,25.25,87 ],
    [ u"in",u"Bhagwantnagar",6597,26.233333,80.75 ],
    [ u"in",u"Bhainsa",46125,19.1,77.966667 ],
    [ u"in",u"Bhainsdehi",16402,21.646667,77.6325 ],
    [ u"in",u"Bhalki",38586,18.033333,77.216667 ],
    [ u"in",u"Bhandara",90190,21.166667,79.65 ],
    [ u"in",u"Bhandardaha",5079,22.616944,88.214444 ],
    [ u"in",u"Bhander",22484,25.733333,78.75 ],
    [ u"in",u"Bhanjanagar",20649,19.933333,84.583333 ],
    [ u"in",u"Bhanpura",17084,24.513,75.7469 ],
    [ u"in",u"Bhanpuri",17270,21.1,80.916667 ],
    [ u"in",u"Bhanvad",20824,21.926389,69.773611 ],
    [ u"in",u"Bharatpur",229400,27.216667,77.483333 ],
    [ u"in",u"Bharthana",41059,26.7571,79.2248 ],
    [ u"in",u"Bharuch",153538,21.7,72.966667 ],
    [ u"in",u"Bharwari",16413,25.55,81.5 ],
    [ u"in",u"Bhasawar",18997,27.033333,77.033333 ],
    [ u"in",u"Bhatapara",51756,21.733333,81.933333 ],
    [ u"in",u"Bhatgaon",8045,21.15,81.7 ],
    [ u"in",u"Bhatkal",31738,13.966667,74.566667 ],
    [ u"in",u"Bhatpara",483175,22.871389,88.408889 ],
    [ u"in",u"Bhattiprolu",18001,16.1,80.783333 ],
    [ u"in",u"Bhavani",39748,11.45,77.683333 ],
    [ u"in",u"Bhavnagar",555014,21.766667,72.15 ],
    [ u"in",u"Bhawanigarh",19377,30.266667,76.035 ],
    [ u"in",u"Bhawanipatna",64474,19.9,83.166667 ],
    [ u"in",u"Bhayavadar",19458,21.85,70.25 ],
    [ u"in",u"Bhigvan",8753,18.316667,74.766667 ],
    [ u"in",u"Bhikangaon",15323,21.866667,75.95 ],
    [ u"in",u"Bhikhi",15960,30.066667,75.533333 ],
    [ u"in",u"Bhilai",625203,21.216667,81.433333 ],
    [ u"in",u"Bhilwara",326454,25.35,74.633333 ],
    [ u"in",u"Bhimavaram",142979,16.533333,81.533333 ],
    [ u"in",u"Bhim Tal",6626,29.35,79.566667 ],
    [ u"in",u"Bhimunipatnam",44848,17.883333,83.433333 ],
    [ u"in",u"Bhindar",16946,24.5,74.183333 ],
    [ u"in",u"Bhind",174053,26.564167,78.788333 ],
    [ u"in",u"Bhinga",22018,27.716667,81.933333 ],
    [ u"in",u"Bhinmal",42866,25,72.25 ],
    [ u"in",u"Bhitarwar",17681,25.8,78.116667 ],
    [ u"in",u"Bhiwandi",707090,19.3,73.066667 ],
    [ u"in",u"Bhiwani",190868,28.783333,76.133333 ],
    [ u"in",u"Bhojudih",9110,23.633333,86.45 ],
    [ u"in",u"Bhongaon",29914,27.25,79.183333 ],
    [ u"in",u"Bhongir",50100,17.510833,78.888889 ],
    [ u"in",u"Bhopal",1600080,23.266667,77.4 ],
    [ u"in",u"Bhor",18984,18.166667,73.85 ],
    [ u"in",u"Bhowali",5686,29.383333,79.516667 ],
    [ u"in",u"Bhuban",20480,20.883333,85.833333 ],
    [ u"in",u"Bhubaneswar",762307,20.233333,85.833333 ],
    [ u"in",u"Bhuj",133458,23.266667,69.666667 ],
    [ u"in",u"Bhum",18545,18.466667,75.666667 ],
    [ u"in",u"Bhusawal",183016,21.05,75.766667 ],
    [ u"in",u"Bhuvanagiri",20658,11.466667,79.633333 ],
    [ u"in",u"Biaora",41993,23.866667,76.916667 ],
    [ u"in",u"Bicholim",15317,15.6,73.95 ],
    [ u"in",u"Bidar",204088,17.9,77.55 ],
    [ u"in",u"Bid",148477,18.983333,75.766667 ],
    [ u"in",u"Bidhuna",27161,26.8022,79.5088 ],
    [ u"in",u"Bighapur",6409,26.35,80.683333 ],
    [ u"in",u"Bihar",244256,25.183333,85.516667 ],
    [ u"in",u"Bihariganj",32806,25.733333,86.983333 ],
    [ u"in",u"Bijapur",271087,16.833333,75.7 ],
    [ u"in",u"Bijawar",19470,24.633333,79.5 ],
    [ u"in",u"Bijbiara",24592,33.8,75.1 ],
    [ u"in",u"Bijni",12991,26.495883,90.702977 ],
    [ u"in",u"Bijnor",84601,29.15,78.266667 ],
    [ u"in",u"Bikaner",576056,28.016667,73.3 ],
    [ u"in",u"Bikapur",13179,26.6,82.133333 ],
    [ u"in",u"Bikramganj",42631,25.2,84.25 ],
    [ u"in",u"Bilara",41713,26.179167,73.705556 ],
    [ u"in",u"Bilari",29669,28.633333,78.8 ],
    [ u"in",u"Bilasipara",37741,26.231954,90.234747 ],
    [ u"in",u"Bilaspur",10710,30.316667,77.316667 ],
    [ u"in",u"Bilaspur",14038,31.333333,76.75 ],
    [ u"in",u"Bilaspur",39877,28.883333,79.266667 ],
    [ u"in",u"Bilaspur",282736,22.083333,82.15 ],
    [ u"in",u"Bilaua",11996,26.033333,78.259722 ],
    [ u"in",u"Bilgi",16257,16.35,75.616667 ],
    [ u"in",u"Bilgram",27176,27.183333,80.033333 ],
    [ u"in",u"Bilhaur",19335,26.85,80.083333 ],
    [ u"in",u"Bilimora",54582,20.75,72.95 ],
    [ u"in",u"Bilkha",14421,21.433333,70.6 ],
    [ u"in",u"Biloli",14717,18.766667,77.733333 ],
    [ u"in",u"Bilsanda",15540,28.25,79.95 ],
    [ u"in",u"Bilsi",26323,28.133333,78.916667 ],
    [ u"in",u"Bina-Etawa",55191,24.1855,78.2031 ],
    [ u"in",u"Bindki",36062,26.033333,80.6 ],
    [ u"in",u"Binika",15096,21.033333,83.8 ],
    [ u"in",u"Birmitrapur",27882,22.4,84.766667 ],
    [ u"in",u"Birpur",18970,26.516667,87.016667 ],
    [ u"in",u"Birur",23495,13.616667,75.966667 ],
    [ u"in",u"Bisalpur",68362,28.3,79.8 ],
    [ u"in",u"Bisauli",32158,28.316667,78.933333 ],
    [ u"in",u"Bishna",11646,32.616667,74.866667 ],
    [ u"in",u"Bishnupur",4429,22.383333,88.266667 ],
    [ u"in",u"Bissau",22622,28.25,75.083333 ],
    [ u"in",u"Biswan",52522,27.5,81 ],
    [ u"in",u"Bithur",10603,26.633333,80.283333 ],
    [ u"in",u"Bobbili",52849,18.566667,83.366667 ],
    [ u"in",u"Bodhan",73946,18.666667,77.9 ],
    [ u"in",u"Bodh Gaya",35192,24.7,84.983333 ],
    [ u"in",u"Bodinayakkanur",75687,10.016667,77.35 ],
    [ u"in",u"Bodri",14493,23.166667,81.433333 ],
    [ u"in",u"Boisar",15692,19.8,72.75 ],
    [ u"in",u"Bokajan",16561,26.016667,93.783333 ],
    [ u"in",u"Bokaro",418578,23.783333,85.966667 ],
    [ u"in",u"Bolpur",71005,23.666667,87.716667 ],
    [ u"in",u"Bombay",12692717,18.975,72.825833 ],
    [ u"in",u"Bongaigaon",64905,26.478224,90.556764 ],
    [ u"in",u"Borsad",60275,22.416667,72.9 ],
    [ u"in",u"Botad",117060,22.166667,71.666667 ],
    [ u"in",u"Brahmapur",324753,19.316667,84.783333 ],
    [ u"in",u"Brahmapuri",32961,20.6,79.866667 ],
    [ u"in",u"Brajrajnagar",79428,21.816667,83.916667 ],
    [ u"in",u"Budaun",161571,28.05,79.116667 ],
    [ u"in",u"Budhgaon",15737,16.9,74.6 ],
    [ u"in",u"Budhlada",25433,29.933333,75.566667 ],
    [ u"in",u"Buguda",14298,19.816667,84.8 ],
    [ u"in",u"Bulandshahr",198631,28.4,77.85 ],
    [ u"in",u"Buldana",66996,20.533333,76.183333 ],
    [ u"in",u"Bundi",98576,25.441667,75.641667 ],
    [ u"in",u"Bundu",19469,23.183333,85.583333 ],
    [ u"in",u"Burhanpur",202717,21.3,76.233333 ],
    [ u"in",u"Burhar",18193,23.216667,81.533333 ],
    [ u"in",u"Burla",40820,21.5,83.866667 ],
    [ u"in",u"Buxar",96130,25.583333,83.983333 ],
    [ u"in",u"Byadgi",27722,14.683333,75.483333 ],
    [ u"in",u"Calcutta",4631819,22.569722,88.369722 ],
    [ u"in",u"Candolim",9198,15.516667,73.75 ],
    [ u"in",u"Canning",42132,22.318889,88.671389 ],
    [ u"in",u"Carapur",5576,15.55,73.966667 ],
    [ u"in",u"Chabua",7623,27.4825,95.173611 ],
    [ u"in",u"Chaibasa",66259,22.566667,85.816667 ],
    [ u"in",u"Chail",8408,25.433333,81.633333 ],
    [ u"in",u"Chakan",23161,18.75,73.85 ],
    [ u"in",u"Chakia",17833,26.416667,85.05 ],
    [ u"in",u"Chakia",15000,25.05,83.216667 ],
    [ u"in",u"Chaklasi",38434,22.65,72.933333 ],
    [ u"in",u"Chakradharpur",40604,22.7,85.633333 ],
    [ u"in",u"Chakrata",3349,30.7,77.85 ],
    [ u"in",u"Chakulia",14953,22.483333,86.716667 ],
    [ u"in",u"Chalakudi",49335,10.3,76.35 ],
    [ u"in",u"Chalala",17082,21.416667,71.166667 ],
    [ u"in",u"Chalisgaon",96389,20.466667,75.016667 ],
    [ u"in",u"Challakere",53510,14.316667,76.65 ],
    [ u"in",u"Challapalle",16841,16.116667,80.933333 ],
    [ u"in",u"Chamba",21504,32.566667,76.133333 ],
    [ u"in",u"Champa",41257,22.05,82.65 ],
    [ u"in",u"Champahati",8922,22.395833,88.484722 ],
    [ u"in",u"Champawat",4669,29.333333,80.1 ],
    [ u"in",u"Champdani",103699,22.797778,88.365833 ],
    [ u"in",u"Champua",9488,22.083333,85.666667 ],
    [ u"in",u"Chamrajnagar",67998,11.916667,76.95 ],
    [ u"in",u"Chanasma",15573,23.716667,72.116667 ],
    [ u"in",u"Chandannagar",180640,22.869167,88.377222 ],
    [ u"in",u"Chandauli",25038,25.266667,83.266667 ],
    [ u"in",u"Chandausi",112646,28.45,78.766667 ],
    [ u"in",u"Chandbali",9918,20.783333,86.766667 ],
    [ u"in",u"Chanderi",32552,24.716667,78.133333 ],
    [ u"in",u"Chandia",13100,23.65,80.7 ],
    [ u"in",u"Chandigarh",914374,30.7343,76.7933 ],
    [ u"in",u"Chandil",4657,22.966667,86.05 ],
    [ u"in",u"Chandla",11196,25.083333,80.2 ],
    [ u"in",u"Chandpur",73562,29.15,78.266667 ],
    [ u"in",u"Chandrakona",21858,22.733333,87.516667 ],
    [ u"in",u"Chandrapur",328377,19.95,79.3 ],
    [ u"in",u"Chandur Bazar",18781,21.241667,77.745556 ],
    [ u"in",u"Chandur",19165,20.816667,77.966667 ],
    [ u"in",u"Chandvad",19592,20.333333,74.25 ],
    [ u"in",u"Changanacheri",51435,9.466667,76.55 ],
    [ u"in",u"Channagiri",20378,14.033333,75.933333 ],
    [ u"in",u"Channapatna",66652,12.65,77.216667 ],
    [ u"in",u"Channarayapatna",37684,12.904444,76.391667 ],
    [ u"in",u"Chapar",19302,26.266667,90.466667 ],
    [ u"in",u"Charkhari",24883,25.4,79.75 ],
    [ u"in",u"Charkhi Dadri",50562,28.6,76.266667 ],
    [ u"in",u"Charthawal",19944,29.55,77.583333 ],
    [ u"in",u"Chas",112153,23.633333,86.166667 ],
    [ u"in",u"Chatakonda",2816,17.55,80.65 ],
    [ u"in",u"Chatra",46849,24.216667,84.866667 ],
    [ u"in",u"Chatrapur",21125,19.35,84.983333 ],
    [ u"in",u"Chatsu",33100,26.6,75.95 ],
    [ u"in",u"Chaupal",1701,30.95,77.583333 ],
    [ u"in",u"Chavakkad",38014,10.533333,76.05 ],
    [ u"in",u"Chechat",11138,24.766667,75.883333 ],
    [ u"in",u"Chengalpattu",65695,12.7,79.983333 ],
    [ u"in",u"Chengam",23904,12.3,78.8 ],
    [ u"in",u"Chengannur",25046,9.333333,76.633333 ],
    [ u"in",u"Cherrapunji",11090,25.3,91.7 ],
    [ u"in",u"Chetpet",18326,13.07,80.240833 ],
    [ u"in",u"Chettipalaiyam",24091,10.9,77.066667 ],
    [ u"in",u"Cheyur",11060,12.348056,80.004722 ],
    [ u"in",u"Chhabra",25678,24.666667,76.833333 ],
    [ u"in",u"Chhachhrauli",10751,30.25,77.366667 ],
    [ u"in",u"Chhapar",18729,27.816667,74.4 ],
    [ u"in",u"Chhapra",197350,25.766667,84.75 ],
    [ u"in",u"Chhaprauli",19224,29.216667,77.183333 ],
    [ u"in",u"Chhata",21262,27.716667,77.5 ],
    [ u"in",u"Chhatapur",23425,26.216667,87.016667 ],
    [ u"in",u"Chhatarpur",111606,24.9,79.6 ],
    [ u"in",u"Chhibramau",57076,27.1483,79.4979 ],
    [ u"in",u"Chhindwara",134862,22.066667,78.933333 ],
    [ u"in",u"Chhoti Sadri",17336,24.383333,74.7 ],
    [ u"in",u"Chhuikhadan",6485,21.533333,80.983333 ],
    [ u"in",u"Chicalim",7787,15.4,73.833333 ],
    [ u"in",u"Chichli",10226,22.833333,78.816667 ],
    [ u"in",u"Chicholi",18866,21.466667,79.683333 ],
    [ u"in",u"Chidambaram",58655,11.4,79.7 ],
    [ u"in",u"Chik Ballapur",57836,13.434167,77.724167 ],
    [ u"in",u"Chikhli",7487,20.75,73.066667 ],
    [ u"in",u"Chikhli",52845,20.35,76.25 ],
    [ u"in",u"Chikitigarh",11056,19.2,84.616667 ],
    [ u"in",u"Chikmagalur",121494,13.316667,75.783333 ],
    [ u"in",u"Chiknayakanhalli",24294,13.417222,76.622778 ],
    [ u"in",u"Chikodi",34987,16.433333,74.6 ],
    [ u"in",u"Chilakalurupet",94021,16.083333,80.166667 ],
    [ u"in",u"Chinchani",14357,19.866667,72.7 ],
    [ u"in",u"Chinchinim",7356,15.2,73.966667 ],
    [ u"in",u"Chincholi",20449,17.466667,77.433333 ],
    [ u"in",u"Chinnammanur",39217,9.833333,77.383333 ],
    [ u"in",u"Chinna Salem",20111,11.65,78.9 ],
    [ u"in",u"Chintamani",71804,13.4,78.066667 ],
    [ u"in",u"Chiplun",51441,17.533333,73.516667 ],
    [ u"in",u"Chipurupalle",25904,18.3,83.566667 ],
    [ u"in",u"Chirala",87011,15.816667,80.35 ],
    [ u"in",u"Chirawa",41322,28.2401,75.6456 ],
    [ u"in",u"Chirgaon",14149,25.583333,78.816667 ],
    [ u"in",u"Chiria",3947,22.3,85.266667 ],
    [ u"in",u"Chitapur",30141,17.116667,77.083333 ],
    [ u"in",u"Chit Baragaon",21659,25.75,84.016667 ],
    [ u"in",u"Chitradurga",138599,14.233333,76.4 ],
    [ u"in",u"Chitrakonda",7260,18.116667,82.083333 ],
    [ u"in",u"Chittaranjan",45309,23.866667,86.866667 ],
    [ u"in",u"Chittaurgarh",106718,24.883333,74.633333 ],
    [ u"in",u"Chittur",31611,10.7,76.75 ],
    [ u"in",u"Chodavaram",25074,17.45,81.766667 ],
    [ u"in",u"Chomun",55965,27.166667,75.716667 ],
    [ u"in",u"Chopan",13587,24.516667,83.033333 ],
    [ u"in",u"Chopda",65603,21.25,75.3 ],
    [ u"in",u"Chotila",15197,22.416667,71.183333 ],
    [ u"in",u"Chuari Khas",3431,32.433333,76.016667 ],
    [ u"in",u"Chunar",36462,25.133333,82.9 ],
    [ u"in",u"Churachandpur",47774,24.333333,93.666667 ],
    [ u"in",u"Churhat",14101,24.433333,81.683333 ],
    [ u"in",u"Churu",103541,28.3,74.95 ],
    [ u"in",u"Clement Town",20807,30.266667,78.066667 ],
    [ u"in",u"Colgong",24081,25.266667,87.216667 ],
    [ u"in",u"Colonelganj",25506,27.133333,81.7 ],
    [ u"in",u"Colvale",5723,15.616667,73.833333 ],
    [ u"in",u"Contai",88710,21.778611,87.753611 ],
    [ u"in",u"Cortalim",7564,15.383333,73.883333 ],
    [ u"in",u"Courtalam",2440,8.916667,77.283333 ],
    [ u"in",u"Cuddapah",127024,14.466667,78.816667 ],
    [ u"in",u"Cumbum",15212,15.566667,79.116667 ],
    [ u"in",u"Cuncolim",16124,15.166667,73.983333 ],
    [ u"in",u"Curchorem",22512,15.25,74.1 ],
    [ u"in",u"Curti",13662,15.416667,74.016667 ],
    [ u"in",u"Dabhoi",56257,22.183333,73.433333 ],
    [ u"in",u"Dabhol",9142,17.6,73.166667 ],
    [ u"in",u"Daboh",18299,26.0025,78.876111 ],
    [ u"in",u"Dabra",60842,25.9,78.333333 ],
    [ u"in",u"Dabwali",62118,29.95,74.733333 ],
    [ u"in",u"Dadri",70616,28.566667,77.55 ],
    [ u"in",u"Dagshai",2994,30.883333,77.05 ],
    [ u"in",u"Dahanu",49052,19.966667,72.733333 ],
    [ u"in",u"Dahegam",40674,23.166667,72.816667 ],
    [ u"in",u"Dahod",83972,22.833333,74.266667 ],
    [ u"in",u"Daitari",4147,21.1,85.75 ],
    [ u"in",u"Dakor",25020,22.75,73.15 ],
    [ u"in",u"Dalhousie",7602,32.533333,75.983333 ],
    [ u"in",u"Dalkola",15287,25.85,87.85 ],
    [ u"in",u"Dalmau",11433,26.066667,81.033333 ],
    [ u"in",u"Dalsingh Sarai",21613,25.666667,85.833333 ],
    [ u"in",u"Daltenganj",77712,24.033333,84.066667 ],
    [ u"in",u"Daman",39741,20.416667,72.85 ],
    [ u"in",u"Damnagar",17767,21.7,71.516667 ],
    [ u"in",u"Damoh",118789,23.833333,79.45 ],
    [ u"in",u"Dandeli",52300,15.266667,74.616667 ],
    [ u"in",u"Dankaur",13021,28.35,77.55 ],
    [ u"in",u"Daosa",73039,26.883333,76.333333 ],
    [ u"in",u"Darbhanga",287180,26.166667,85.9 ],
    [ u"in",u"Dariba",3076,24.95,74.133333 ],
    [ u"in",u"Darjiling",123808,27.033333,88.266667 ],
    [ u"in",u"Darlawn",3962,24.016667,92.9 ],
    [ u"in",u"Daryapur",35784,20.933333,77.333333 ],
    [ u"in",u"Dasna",27928,28.683333,77.533333 ],
    [ u"in",u"Dasuya",20699,31.818333,75.659722 ],
    [ u"in",u"Dataganj",24564,28.033333,79.4 ],
    [ u"in",u"Datia",90638,25.666667,78.466667 ],
    [ u"in",u"Dattapur",21765,20.766667,78.166667 ],
    [ u"in",u"Daudnagar",41240,25.033333,84.4 ],
    [ u"in",u"Daulatpur",3592,32.066667,76.25 ],
    [ u"in",u"Daund",45444,18.466667,74.6 ],
    [ u"in",u"Daurala",10917,29.116667,77.683333 ],
    [ u"in",u"Davorlim",11418,15.25,73.983333 ],
    [ u"in",u"Dayal Bagh",3369,27.216667,78.016667 ],
    [ u"in",u"Dehra Dun",522135,30.316667,78.033333 ],
    [ u"in",u"Dehri",129952,24.866667,84.183333 ],
    [ u"in",u"Dehu",5604,18.716667,73.766667 ],
    [ u"in",u"Delhi",10928270,28.666667,77.216667 ],
    [ u"in",u"Delvada",11912,20.766667,71.033333 ],
    [ u"in",u"Deoband",88180,29.7,77.683333 ],
    [ u"in",u"Deogarh",21136,21.533333,84.733333 ],
    [ u"in",u"Deolali",52962,19.95,73.833333 ],
    [ u"in",u"Deoli",16687,20.666667,78.483333 ],
    [ u"in",u"Deoranian",19790,28.633333,79.483333 ],
    [ u"in",u"Deoria",113638,26.504722,83.787222 ],
    [ u"in",u"Deori",12286,21.45,82.616667 ],
    [ u"in",u"Deori Khas",24937,23.4,79.016667 ],
    [ u"in",u"Depalpur",16938,22.85,75.55 ],
    [ u"in",u"Dera Baba Nanak",7492,32.033333,75.016667 ],
    [ u"in",u"Dera Gopipur",4735,31.9,76.216667 ],
    [ u"in",u"Dergaon",13366,26.7,93.966667 ],
    [ u"in",u"Deshnok",16721,27.8,73.35 ],
    [ u"in",u"Desur",5312,12.433333,79.483333 ],
    [ u"in",u"Deulgaon Raja",26690,20.016667,76.033333 ],
    [ u"in",u"Devadanapatti",14190,10.15,77.65 ],
    [ u"in",u"Devanhalli",25230,13.2325,77.699167 ],
    [ u"in",u"Devaprayag",2131,30.15,78.616667 ],
    [ u"in",u"Devarkonda",29730,16.7,78.933333 ],
    [ u"in",u"Devgarh",17502,25.533333,73.9 ],
    [ u"in",u"Devli",21299,25.75,75.383333 ],
    [ u"in",u"Dewa",14377,27.033333,81.166667 ],
    [ u"in",u"Dewas",261245,22.966667,76.066667 ],
    [ u"in",u"Dhaka",36115,26.683333,85.166667 ],
    [ u"in",u"Dhali",6494,10.5,77.166667 ],
    [ u"in",u"Dhamnod",29684,22.216667,75.466667 ],
    [ u"in",u"Dhampur",49978,29.316667,78.516667 ],
    [ u"in",u"Dhamtari",87161,20.707222,81.549722 ],
    [ u"in",u"Dhana",10642,23.75,78.85 ],
    [ u"in",u"Dhanaula",19283,30.283333,75.583333 ],
    [ u"in",u"Dhanaura",28288,28.966667,78.25 ],
    [ u"in",u"Dhanbad",219660,23.8,86.45 ],
    [ u"in",u"Dhandhuka",30051,22.366667,71.983333 ],
    [ u"in",u"Dhanera",23656,24.516667,72.016667 ],
    [ u"in",u"Dhanwar",8512,24.416667,85.983333 ],
    [ u"in",u"Dharampur",21209,20.533333,73.183333 ],
    [ u"in",u"Dharampuri",14179,22.166667,75.35 ],
    [ u"in",u"Dharangaon",33721,21.016667,75.266667 ],
    [ u"in",u"Dharapuram",72297,10.733333,77.516667 ],
    [ u"in",u"Dharchula",7332,29.85,80.533333 ],
    [ u"in",u"Dhar",82447,22.6,75.3 ],
    [ u"in",u"Dhari",29346,21.333333,71.016667 ],
    [ u"in",u"Dhariwal",20605,31.954167,75.319167 ],
    [ u"in",u"Dharmabad",32354,18.9,77.85 ],
    [ u"in",u"Dharmadam",29946,11.783333,75.433333 ],
    [ u"in",u"Dharmanagar",32917,24.366667,92.166667 ],
    [ u"in",u"Dharmapuri",66022,12.133333,78.166667 ],
    [ u"in",u"Dharmavaram",114062,14.433333,77.716667 ],
    [ u"in",u"Dharur",19062,18.816667,76.116667 ],
    [ u"in",u"Dhaulpur",102469,26.7,77.9 ],
    [ u"in",u"Dhekiajuli",21272,26.7,92.5 ],
    [ u"in",u"Dhemaji",13059,27.483333,94.583333 ],
    [ u"in",u"Dhenkanal",62235,20.666667,85.6 ],
    [ u"in",u"Dhilwan",8447,31.516944,75.35 ],
    [ u"in",u"Dhing",20827,26.466667,92.466667 ],
    [ u"in",u"Dhola",8206,21.883333,71.783333 ],
    [ u"in",u"Dholka",54981,22.716667,72.466667 ],
    [ u"in",u"Dhone",39689,15.416667,77.883333 ],
    [ u"in",u"Dhoraji",81450,21.733333,70.45 ],
    [ u"in",u"Dhrangadhra",75582,22.983333,71.466667 ],
    [ u"in",u"Dhrol",26497,22.566667,70.416667 ],
    [ u"in",u"Dhuburi",62528,26.033333,89.966667 ],
    [ u"in",u"Dhulagari",21080,22.586944,88.173056 ],
    [ u"in",u"Dhule",367010,20.9,74.783333 ],
    [ u"in",u"Dhulian",77078,24.683333,87.966667 ],
    [ u"in",u"Dhupgari",41172,26.585747,89.014496 ],
    [ u"in",u"Dhuri",54306,30.366667,75.866667 ],
    [ u"in",u"Dhuwaran",11473,22.233333,72.8 ],
    [ u"in",u"Diamond Harbour",40099,22.191667,88.184722 ],
    [ u"in",u"Dibai",37877,28.216667,78.25 ],
    [ u"in",u"Dibrugarh",122160,27.481667,94.902778 ],
    [ u"in",u"Didwana",49856,27.4,74.566667 ],
    [ u"in",u"Digapahandi",11167,19.366667,84.583333 ],
    [ u"in",u"Digboi",20685,27.383333,95.618056 ],
    [ u"in",u"Dig",43489,27.466667,77.333333 ],
    [ u"in",u"Digha",3667,21.683333,87.55 ],
    [ u"in",u"Dighwara",29273,25.733333,85 ],
    [ u"in",u"Diglur",52600,18.55,77.6 ],
    [ u"in",u"Digras",41557,20.116667,77.716667 ],
    [ u"in",u"Dimapur",135866,25.9,93.733333 ],
    [ u"in",u"Dinanagar",23341,32.15,75.466667 ],
    [ u"in",u"Dindigul",200814,10.35,77.95 ],
    [ u"in",u"Dindori",19265,22.95,81.083333 ],
    [ u"in",u"Dinhata",42401,26.133333,89.466667 ],
    [ u"in",u"Diphu",57099,25.833333,93.433333 ],
    [ u"in",u"Dirba",13838,30.066667,75.983333 ],
    [ u"in",u"Disa",92230,24.25,72.166667 ],
    [ u"in",u"Dispur",8282,26.1425,91.788889 ],
    [ u"in",u"Diu",23790,20.7,70.983333 ],
    [ u"in",u"Doda",17755,33.133333,75.566667 ],
    [ u"in",u"Dod Ballapur",78682,13.291944,77.543056 ],
    [ u"in",u"Dohrighat",11182,26.264444,83.516389 ],
    [ u"in",u"Doiwala",8248,30.183333,78.116667 ],
    [ u"in",u"Dondaicha",46021,21.333333,74.566667 ],
    [ u"in",u"Dongargaon",12507,20.966667,80.85 ],
    [ u"in",u"Doraha",23553,30.816667,76.016667 ],
    [ u"in",u"Dostpur",12689,26.283333,82.466667 ],
    [ u"in",u"Dubrajpur",35090,23.8,87.383333 ],
    [ u"in",u"Dudhani",12736,17.366667,76.366667 ],
    [ u"in",u"Dugda",20402,23.75,86.166667 ],
    [ u"in",u"Duliagaon",23530,27.366667,95.316667 ],
    [ u"in",u"Dum Duma",21707,27.566667,95.566667 ],
    [ u"in",u"Dum Dum",122731,22.622222,88.416944 ],
    [ u"in",u"Dumjor",17973,22.640833,88.220278 ],
    [ u"in",u"Dumka",47668,24.266667,87.25 ],
    [ u"in",u"Dumra",15780,26.566667,85.516667 ],
    [ u"in",u"Dumraon",50529,25.55,84.15 ],
    [ u"in",u"Dundwaraganj",46319,27.733333,78.95 ],
    [ u"in",u"Dungarpur",6105,21.283333,71.733333 ],
    [ u"in",u"Dungarpur",45198,23.833333,73.716667 ],
    [ u"in",u"Durgapur",18561,20,79.3 ],
    [ u"in",u"Durgapur",518922,23.483333,87.316667 ],
    [ u"in",u"Durg",255310,21.183333,81.283333 ],
    [ u"in",u"Dusi",5257,12.766667,79.683333 ],
    [ u"in",u"Dwarahat",2443,29.783333,79.433333 ],
    [ u"in",u"Dwarka",35839,22.239444,68.967778 ],
    [ u"in",u"Egra",32866,21.9,87.533333 ],
    [ u"in",u"Elayirampannai",6473,9.266667,77.833333 ],
    [ u"in",u"Ellenabad",37683,29.45,74.65 ],
    [ u"in",u"Elumalai",14456,9.866667,77.7 ],
    [ u"in",u"Elur",30832,10.066667,76.283333 ],
    [ u"in",u"Eluru",183401,16.7,81.1 ],
    [ u"in",u"Eral",9188,8.633333,78.016667 ],
    [ u"in",u"Eraniel",9844,8.2,77.3 ],
    [ u"in",u"Erattupetta",33411,9.7,76.783333 ],
    [ u"in",u"Erode",147283,11.35,77.733333 ],
    [ u"in",u"Etah",120020,27.633333,78.666667 ],
    [ u"in",u"Etawah",257472,26.7769,79.0239 ],
    [ u"in",u"Ettaiyapuram",12957,9.15,77.983333 ],
    [ u"in",u"Faizabad",153062,26.783333,82.133333 ],
    [ u"in",u"Faizpur",24536,21.166667,75.85 ],
    [ u"in",u"Falakata",20120,26.520841,89.205448 ],
    [ u"in",u"Farah",9236,27.333333,77.766667 ],
    [ u"in",u"Farakka",21836,24.816667,87.9 ],
    [ u"in",u"Faridabad",1280909,28.433333,77.316667 ],
    [ u"in",u"Faridkot",77455,30.666667,74.75 ],
    [ u"in",u"Faridnagar",11372,28.766667,77.616667 ],
    [ u"in",u"Faridpur",71790,28.216667,79.55 ],
    [ u"in",u"Farrukhabad",241176,27.4,79.566667 ],
    [ u"in",u"Farrukhnagar",39771,17.077778,78.201111 ],
    [ u"in",u"Farrukhnagar",10092,28.45,76.816667 ],
    [ u"in",u"Fatehabad",66017,29.516667,75.45 ],
    [ u"in",u"Fatehabad",21959,27.016667,78.316667 ],
    [ u"in",u"Fatehgarh Churian",18053,31.862071,74.955344 ],
    [ u"in",u"Fatehgarh",14849,27.366667,79.633333 ],
    [ u"in",u"Fatehpur Chaurasi",5932,26.783333,80.266667 ],
    [ u"in",u"Fatehpur",83176,27.983333,74.95 ],
    [ u"in",u"Fatehpur",166496,25.933333,80.8 ],
    [ u"in",u"Fatehpur Sikri",30029,27.1,77.666667 ],
    [ u"in",u"Fatwa",41652,25.516667,85.316667 ],
    [ u"in",u"Fazilka",70893,30.4,74.033333 ],
    [ u"in",u"Feroke",30229,11.183333,75.85 ],
    [ u"in",u"Firozabad",306439,27.15,78.416667 ],
    [ u"in",u"Firozpur",102138,30.916667,74.6 ],
    [ u"in",u"Firozpur Jhirka",20196,27.8,76.95 ],
    [ u"in",u"Forbesganj",45103,26.3,87.25 ],
    [ u"in",u"Fort Gloster",18349,22.504444,88.183333 ],
    [ u"in",u"Gadag",162583,15.416667,75.616667 ],
    [ u"in",u"Gadarwara",41424,22.916667,78.783333 ],
    [ u"in",u"Gadwal",55958,16.233333,77.8 ],
    [ u"in",u"Gagret",3026,31.666667,76.066667 ],
    [ u"in",u"Gairatganj",8779,23.4,78.216667 ],
    [ u"in",u"Gajendragarh",29752,15.733333,75.983333 ],
    [ u"in",u"Gajraula",50385,28.85,78.233333 ],
    [ u"in",u"Galiakot",6907,23.516667,74 ],
    [ u"in",u"Gandai",12477,21.666667,81.1 ],
    [ u"in",u"Gandevi",16241,20.816667,72.983333 ],
    [ u"in",u"Gandhidham",136605,23.083333,70.133333 ],
    [ u"in",u"Gandhinagar",231314,23.216667,72.683333 ],
    [ u"in",u"Gangakher",46369,18.95,76.75 ],
    [ u"in",u"Ganganagar",231855,29.916667,73.883333 ],
    [ u"in",u"Gangapur",24120,19.683333,75.016667 ],
    [ u"in",u"Gangapur",120123,26.483333,76.716667 ],
    [ u"in",u"Gangarampur",65323,25.4,88.516667 ],
    [ u"in",u"Gangavalli",10905,11.483333,78.65 ],
    [ u"in",u"Gangawati",106259,15.433333,76.533333 ],
    [ u"in",u"Gangoh",59525,29.766667,77.25 ],
    [ u"in",u"Gangotri",811,30.983333,78.933333 ],
    [ u"in",u"Gangtok",30702,27.333333,88.616667 ],
    [ u"in",u"Ganjam",11430,19.316667,84.783333 ],
    [ u"in",u"Ganj Muradabad",9971,26.966667,80.183333 ],
    [ u"in",u"Gannavaram",19410,16.533333,80.8 ],
    [ u"in",u"Garautha",9490,25.566667,79.3 ],
    [ u"in",u"Gardhiwala",6694,31.7325,75.750556 ],
    [ u"in",u"Garhakota",28117,23.766667,79.15 ],
    [ u"in",u"Garhshankar",16471,31.216667,76.133333 ],
    [ u"in",u"Gariaband",10416,20.635,82.061389 ],
    [ u"in",u"Gariadhar",35695,21.533333,71.583333 ],
    [ u"in",u"Garui",16499,22.633333,88.4 ],
    [ u"in",u"Garulia",74404,22.821111,88.374444 ],
    [ u"in",u"Garwa",40666,24.183333,83.816667 ],
    [ u"in",u"Gaurela",14593,22.75,81.9 ],
    [ u"in",u"Gauribidanur",32450,13.611111,77.516667 ],
    [ u"in",u"Gauripur",24695,26.083524,89.961584 ],
    [ u"in",u"Gawan",8745,28.433333,78.35 ],
    [ u"in",u"Gaya",423737,24.783333,85 ],
    [ u"in",u"Gevrai",30408,19.266667,75.75 ],
    [ u"in",u"Gezing",869,27.283333,88.266667 ],
    [ u"in",u"Ghamarwin",6691,31.45,76.716667 ],
    [ u"in",u"Ghanaur",6091,30.332222,76.607222 ],
    [ u"in",u"Ghansor",6597,22.65,79.95 ],
    [ u"in",u"Gharghoda",8513,22.166667,83.35 ],
    [ u"in",u"Ghatal",54663,22.666667,87.716667 ],
    [ u"in",u"Ghatampur",40439,26.166667,80.166667 ],
    [ u"in",u"Ghatanji",20786,20.133333,78.316667 ],
    [ u"in",u"Ghatsila",40022,22.6,86.483333 ],
    [ u"in",u"Ghaziabad",1199306,28.666667,77.433333 ],
    [ u"in",u"Ghazipur",103105,25.583333,83.566667 ],
    [ u"in",u"Ghiror",14012,27.183333,78.8 ],
    [ u"in",u"Ghogha",11362,21.683333,72.283333 ],
    [ u"in",u"Ghorawal",7493,24.766667,82.783333 ],
    [ u"in",u"Ghosi",39142,26.108333,83.543611 ],
    [ u"in",u"Ghoti",22097,19.716667,73.633333 ],
    [ u"in",u"Ghugus",31861,19.933333,79.133333 ],
    [ u"in",u"Gidam",6228,18.983333,81.4 ],
    [ u"in",u"Giddalur",28142,15.35,78.916667 ],
    [ u"in",u"Giddarbaha",39246,30.2,74.666667 ],
    [ u"in",u"Goalpara",50761,26.166667,90.616667 ],
    [ u"in",u"Goa Velha",5656,15.433333,73.866667 ],
    [ u"in",u"Gobardanga",43812,22.874722,88.758611 ],
    [ u"in",u"Gobindapur",11781,22.593056,88.091389 ],
    [ u"in",u"Gobindpur",27069,22.633333,86.066667 ],
    [ u"in",u"Godda",43663,24.833333,87.216667 ],
    [ u"in",u"Godhra",131921,22.75,73.633333 ],
    [ u"in",u"Gogapur",6857,23.55,75.516667 ],
    [ u"in",u"Gohad",51640,26.426111,78.444722 ],
    [ u"in",u"Gohana",56097,29.133333,76.7 ],
    [ u"in",u"Gohand",7287,25.7,79.55 ],
    [ u"in",u"Gohpur",9896,26.883333,93.633333 ],
    [ u"in",u"Gokak",73484,16.166667,74.833333 ],
    [ u"in",u"Gokul",4351,27.45,77.716667 ],
    [ u"in",u"Gola Bazar",10937,26.343056,83.355278 ],
    [ u"in",u"Golaghat",34374,26.516667,93.966667 ],
    [ u"in",u"Gola Gokarannath",58992,28.083333,80.466667 ],
    [ u"in",u"Golakganj",8125,26.1,89.833333 ],
    [ u"in",u"Gomoh",31398,23.866667,86.166667 ],
    [ u"in",u"Gonda",133596,27.133333,81.933333 ],
    [ u"in",u"Gondal",101808,21.966667,70.8 ],
    [ u"in",u"Gopalganj",63731,26.466667,84.433333 ],
    [ u"in",u"Gopalpur",7163,19.266667,84.916667 ],
    [ u"in",u"Gopalpur",6900,22.614444,88.751389 ],
    [ u"in",u"Gopalur",3324,16.616667,77.8 ],
    [ u"in",u"Gopamau",13582,27.55,80.283333 ],
    [ u"in",u"Gopichettipalaiyam",57532,11.466667,77.45 ],
    [ u"in",u"Gopinathpur",5255,22.65,86.066667 ],
    [ u"in",u"Gorakhpur",674312,26.755,83.373889 ],
    [ u"in",u"Goregaon",6946,18.166667,73.3 ],
    [ u"in",u"Gormi",16889,26.599444,78.515 ],
    [ u"in",u"Gorur",6192,12.819444,76.071667 ],
    [ u"in",u"Gosainganj",13177,26.583333,82.383333 ],
    [ u"in",u"Gossaigaon",13933,26.437868,89.97882 ],
    [ u"in",u"Govardhan",20046,27.5,77.466667 ],
    [ u"in",u"Govindgarh",10956,27.5,76.983333 ],
    [ u"in",u"Govindgarh",10194,24.383333,81.3 ],
    [ u"in",u"Gua",11390,22.2,85.383333 ],
    [ u"in",u"Gubbi",17985,13.310556,76.944444 ],
    [ u"in",u"Gudalur",160993,11.75,79.75 ],
    [ u"in",u"Gudari",6895,19.35,83.783333 ],
    [ u"in",u"Gudibanda",9256,13.669444,77.698333 ],
    [ u"in",u"Gudivada",116174,16.45,80.983333 ],
    [ u"in",u"Gudiyattam",93981,12.95,78.866667 ],
    [ u"in",u"Gudur",5647,17.483333,78.816667 ],
    [ u"in",u"Guhagar",3425,17.466667,73.2 ],
    [ u"in",u"Guirim",7058,15.583333,73.8 ],
    [ u"in",u"Gulabpura",26469,25.9,74.666667 ],
    [ u"in",u"Gulaothi",46652,28.6,77.783333 ],
    [ u"in",u"Gulbarga",483655,17.333333,76.833333 ],
    [ u"in",u"Gulmarg",730,34.05,74.383333 ],
    [ u"in",u"Gumia",47127,23.783333,85.816667 ],
    [ u"in",u"Gumla",44956,23.05,84.55 ],
    [ u"in",u"Gummidipundi",16605,13.4,80.15 ],
    [ u"in",u"Guna",153705,24.65,77.316667 ],
    [ u"in",u"Gundlupet",27200,11.8,76.683333 ],
    [ u"in",u"Gunnaur",20982,28.25,78.433333 ],
    [ u"in",u"Guntakal",120978,15.166667,77.383333 ],
    [ u"in",u"Guntur",530636,16.3,80.45 ],
    [ u"in",u"Gunupur",22266,19.083333,83.816667 ],
    [ u"in",u"Gurdaha",13103,22.734722,88.759444 ],
    [ u"in",u"Gurdaspur",72503,32.033333,75.516667 ],
    [ u"in",u"Gurgaon",197353,28.466667,77.033333 ],
    [ u"in",u"Gurh",13104,24.516667,81.516667 ],
    [ u"in",u"Gurmatkal",18238,16.866667,77.4 ],
    [ u"in",u"Gursahaiganj",40217,27.116667,79.716667 ],
    [ u"in",u"Gursarai",25193,25.6148,79.1788 ],
    [ u"in",u"Guru Har Sahai",16029,30.716667,74.416667 ],
    [ u"in",u"Guruvayur",21418,10.6,76.05 ],
    [ u"in",u"Guskhara",33783,23.5,87.75 ],
    [ u"in",u"Guwahati",899132,26.183333,91.733333 ],
    [ u"in",u"Gwalior",882551,26.223611,78.179167 ],
    [ u"in",u"Gyanpur",13468,25.35,82.466667 ],
    [ u"in",u"Habra",139310,22.834444,88.6275 ],
    [ u"in",u"Hadgaon",26453,19.5,77.666667 ],
    [ u"in",u"Haflong",39983,25.183333,93.033333 ],
    [ u"in",u"Hailakandi",31032,24.683333,92.566667 ],
    [ u"in",u"Hajan",10800,34.35,74.301389 ],
    [ u"in",u"Hajipur",5680,31.975556,75.757778 ],
    [ u"in",u"Hajipur",133621,25.683333,85.216667 ],
    [ u"in",u"Haldaur",18688,29.3,78.283333 ],
    [ u"in",u"Haldia",207466,22.025278,88.058333 ],
    [ u"in",u"Haldibari",14101,26.333333,88.766667 ],
    [ u"in",u"Haldwani",139512,29.216667,79.516667 ],
    [ u"in",u"Halisahar",128184,22.949722,88.419444 ],
    [ u"in",u"Haliyal",21627,15.333333,74.766667 ],
    [ u"in",u"Halol",45744,22.5,73.466667 ],
    [ u"in",u"Halvad",26207,23.016667,71.183333 ],
    [ u"in",u"Hamirpur",19281,31.683333,76.516667 ],
    [ u"in",u"Hamirpur",34148,25.95,80.15 ],
    [ u"in",u"Handia",17862,25.383333,82.183333 ],
    [ u"in",u"Handwara",12639,34.4,74.283333 ],
    [ u"in",u"Hangal",26607,14.766667,75.133333 ],
    [ u"in",u"Hansi",82412,29.1,75.966667 ],
    [ u"in",u"Hansot",12525,21.583333,72.8 ],
    [ u"in",u"Hanumangarh",155698,29.583333,74.316667 ],
    [ u"in",u"Haora",1027771,22.589167,88.310278 ],
    [ u"in",u"Hapur",242944,28.716667,77.783333 ],
    [ u"in",u"Harda",67394,22.333333,77.1 ],
    [ u"in",u"Hardoi",122647,27.116667,80.15 ],
    [ u"in",u"Harduaganj",12329,27.95,78.166667 ],
    [ u"in",u"Hariana",8333,31.637778,75.840833 ],
    [ u"in",u"Haridwar",186099,29.966667,78.166667 ],
    [ u"in",u"Harihar",78041,14.516667,75.8 ],
    [ u"in",u"Harij",18965,23.7,71.9 ],
    [ u"in",u"Harindanga",6254,22.038333,88.321389 ],
    [ u"in",u"Haringhata",9705,22.95,88.566667 ],
    [ u"in",u"Haripur",7327,22.936111,88.231944 ],
    [ u"in",u"Harpalpur",17733,25.2884,79.3347 ],
    [ u"in",u"Harpanahalli",44981,14.8,75.983333 ],
    [ u"in",u"Harrai",10251,22.616667,79.216667 ],
    [ u"in",u"Harsud",16738,22.1,76.733333 ],
    [ u"in",u"Harur",20407,12.066667,78.5 ],
    [ u"in",u"Hasanpur",9906,27.966667,77.5 ],
    [ u"in",u"Hasanpur",57487,28.716667,78.283333 ],
    [ u"in",u"Hassan",128542,13.000556,76.099444 ],
    [ u"in",u"Hastinapur",24095,29.166667,78.016667 ],
    [ u"in",u"Hata",12051,26.746111,83.740278 ],
    [ u"in",u"Hathras",126895,27.6,78.05 ],
    [ u"in",u"Hatod",9350,22.8,75.733333 ],
    [ u"in",u"Hatta",30858,24.116667,79.6 ],
    [ u"in",u"Haveri",60161,14.8,75.4 ],
    [ u"in",u"Hazaribag",140079,23.983333,85.35 ],
    [ u"in",u"Herbertpur",9479,30.45,77.733333 ],
    [ u"in",u"Hesla",6286,24.066667,85.883333 ],
    [ u"in",u"Hilsa",41115,25.316667,85.283333 ],
    [ u"in",u"Himatnagar",60638,23.6,72.95 ],
    [ u"in",u"Hindaun",95600,26.716667,77.016667 ],
    [ u"in",u"Hindoria",15144,23.9,79.566667 ],
    [ u"in",u"Hindupur",133313,13.828889,77.493333 ],
    [ u"in",u"Hinganghat",97576,20.566667,78.833333 ],
    [ u"in",u"Hingoli",75884,19.716667,77.15 ],
    [ u"in",u"Hinjilikatu",22781,19.483333,84.75 ],
    [ u"in",u"Hirakud",27279,21.516667,83.866667 ],
    [ u"in",u"Hiranagar",9447,32.45,75.266667 ],
    [ u"in",u"Hirapur",6069,21.533333,79.766667 ],
    [ u"in",u"Hirekerur",16688,14.466667,75.383333 ],
    [ u"in",u"Hiriyur",53524,13.945556,76.619167 ],
    [ u"in",u"Hisar",296456,29.166667,75.716667 ],
    [ u"in",u"Hisua",27946,24.833333,85.416667 ],
    [ u"in",u"Hodal",44304,27.9,77.366667 ],
    [ u"in",u"Hojai",36871,26,92.866667 ],
    [ u"in",u"Holalkere",15481,14.033333,76.183333 ],
    [ u"in",u"Hole Narsipur",28288,12.782778,76.243056 ],
    [ u"in",u"Homnabad",41489,17.766667,77.133333 ],
    [ u"in",u"Honavar",18393,14.283333,74.45 ],
    [ u"in",u"Honnali",16755,14.25,75.666667 ],
    [ u"in",u"Hosakote",11692,14.283333,77.183333 ],
    [ u"in",u"Hosanagara",5188,13.916667,75.066667 ],
    [ u"in",u"Hosangadi",2609,13.7,74.95 ],
    [ u"in",u"Hosdurga",24687,13.798056,76.286111 ],
    [ u"in",u"Hoshangabad",109370,22.75,77.716667 ],
    [ u"in",u"Hoshiarpur",158154,31.532222,75.917222 ],
    [ u"in",u"Hoskote",41240,13.066944,77.798333 ],
    [ u"in",u"Hospet",197862,15.266667,76.4 ],
    [ u"in",u"Hosur",103769,12.716667,77.816667 ],
    [ u"in",u"Hubli",840285,15.35,75.166667 ],
    [ u"in",u"Hukeri",20826,16.233333,74.6 ],
    [ u"in",u"Hungund",19037,16.066667,76.05 ],
    [ u"in",u"Hunsur",47648,12.3075,76.287778 ],
    [ u"in",u"Husainabad",26187,24.533333,84.016667 ],
    [ u"in",u"Hyderabad",3598199,17.375278,78.474444 ],
    [ u"in",u"Ichalkaranji",274405,16.7,74.466667 ],
    [ u"in",u"Ichchapuram",33757,19.116667,84.7 ],
    [ u"in",u"Ichhawar",13657,23.016667,77.016667 ],
    [ u"in",u"Idappadi",51647,11.583333,77.85 ],
    [ u"in",u"Ïdar",31316,23.833333,73 ],
    [ u"in",u"Idukki",11249,9.85,76.966667 ],
    [ u"in",u"Igatpuri",35463,19.7,73.55 ],
    [ u"in",u"Iglas",13748,27.716667,77.933333 ],
    [ u"in",u"Ikauna",14218,27.55,81.966667 ],
    [ u"in",u"Ilampillai",11309,11.6,78 ],
    [ u"in",u"Ilkal",56941,15.966667,76.133333 ],
    [ u"in",u"Iluppur",12472,10.516667,78.633333 ],
    [ u"in",u"Imphal",223537,24.816667,93.95 ],
    [ u"in",u"Indapur",26754,18.3,73.25 ],
    [ u"in",u"Indergarh",17368,26.9352,79.6724 ],
    [ u"in",u"Indi",34078,17.166667,75.966667 ],
    [ u"in",u"Indore",1837230,22.716667,75.833333 ],
    [ u"in",u"Indri",15955,29.88,77.071111 ],
    [ u"in",u"Ingraj Bazar",170056,25,88.15 ],
    [ u"in",u"Irinjalakuda",29211,10.333333,76.233333 ],
    [ u"in",u"Irugur",19166,11.016667,77.066667 ],
    [ u"in",u"Isagarh",10370,24.833333,77.883333 ],
    [ u"in",u"Islamnagar",29147,28.333333,78.716667 ],
    [ u"in",u"Islampur",55696,26.266667,88.2 ],
    [ u"in",u"Islampur",31879,25.15,85.2 ],
    [ u"in",u"Itanagar",44995,27.1,93.616667 ],
    [ u"in",u"Itarsi",100585,22.616667,77.75 ],
    [ u"in",u"Itaunja",6727,27.083333,80.916667 ],
    [ u"in",u"Itimadpur",22700,27.25,78.2 ],
    [ u"in",u"Jabalpur",1030276,23.166667,79.95 ],
    [ u"in",u"Jafarpur",14798,22.320833,88.230556 ],
    [ u"in",u"Jagadhri",112590,30.166667,77.3 ],
    [ u"in",u"Jagalur",15789,14.533333,76.35 ],
    [ u"in",u"Jagannathpur",7020,22.233333,85.65 ],
    [ u"in",u"Jagatsinghapur",32948,20.266667,86.166667 ],
    [ u"in",u"Jagdalpur",76473,19.066667,82.033333 ],
    [ u"in",u"Jagdispur",31032,25.483333,84.416667 ],
    [ u"in",u"Jaggayyapeta",41185,16.9,80.1 ],
    [ u"in",u"Jagraon",65310,30.783333,75.483333 ],
    [ u"in",u"Jagtial",99046,18.8,78.933333 ],
    [ u"in",u"Jahanabad",96397,25.216667,84.983333 ],
    [ u"in",u"Jahanabad",13619,28.633333,79.716667 ],
    [ u"in",u"Jahangirabad",57369,28.416667,78.1 ],
    [ u"in",u"Jahangirpur",10043,28.183333,77.716667 ],
    [ u"in",u"Jahazpur",20351,25.616667,75.283333 ],
    [ u"in",u"Jaipur",2711937,26.916667,75.816667 ],
    [ u"in",u"Jaisalmer",67609,26.916667,70.9 ],
    [ u"in",u"Jaisinghnagar",7601,23.7,81.383333 ],
    [ u"in",u"Jais",25729,26.25,81.533333 ],
    [ u"in",u"Jaitaran",21405,26.203056,73.936389 ],
    [ u"in",u"Jakhal Mandi",7411,29.8,75.833333 ],
    [ u"in",u"Jalakandapuram",14530,11.7,77.883333 ],
    [ u"in",u"Jalalabad",29826,30.616667,74.25 ],
    [ u"in",u"Jalalabad",25305,29.618611,77.438333 ],
    [ u"in",u"Jalali",18179,27.866667,78.266667 ],
    [ u"in",u"Jalalpore",17325,20.966667,72.9 ],
    [ u"in",u"Jalalpur",31391,26.316667,82.733333 ],
    [ u"in",u"Jalandhar",785234,31.325556,75.579167 ],
    [ u"in",u"Jalaun",55304,26.1451,79.3366 ],
    [ u"in",u"Jalesar",38618,27.483333,78.316667 ],
    [ u"in",u"Jaleswar",23282,21.816667,87.216667 ],
    [ u"in",u"Jalgaon",27796,21.048611,76.534444 ],
    [ u"in",u"Jalna",262055,19.833333,75.883333 ],
    [ u"in",u"Jalor",49686,25.35,72.616667 ],
    [ u"in",u"Jalpaiguri",107843,26.516667,88.733333 ],
    [ u"in",u"Jamadoba",34778,23.716667,86.4 ],
    [ u"in",u"Jamai",22590,22.2,78.583333 ],
    [ u"in",u"Jamalpur",100791,25.3,86.5 ],
    [ u"in",u"Jambusar",41596,22.05,72.8 ],
    [ u"in",u"Jamkhandi",61696,16.516667,75.3 ],
    [ u"in",u"Jamkhed",29591,18.666667,75.183333 ],
    [ u"in",u"Jammalamadugu",43875,14.833333,78.4 ],
    [ u"in",u"Jammu",465600,32.733333,74.866667 ],
    [ u"in",u"Jamnagar",492087,22.466667,70.066667 ],
    [ u"in",u"Jamshedpur",616404,22.8,86.183333 ],
    [ u"in",u"Jamtara",24391,23.95,86.8 ],
    [ u"in",u"Jamui",78189,24.916667,86.216667 ],
    [ u"in",u"Jamuria",160257,23.7,87.083333 ],
    [ u"in",u"Janakpur Road",15071,26.483333,85.716667 ],
    [ u"in",u"Jandiala",25633,31.166667,75.616667 ],
    [ u"in",u"Jangaon",47563,17.5975,78.876111 ],
    [ u"in",u"Jangipur",82555,24.466667,88.066667 ],
    [ u"in",u"Jansath",19469,29.333333,77.85 ],
    [ u"in",u"Jaora",67210,23.633333,75.133333 ],
    [ u"in",u"Jarwal",17577,27.166667,81.55 ],
    [ u"in",u"Jasdan",43864,22.033333,71.2 ],
    [ u"in",u"Jashpurnagar",22609,22.9,84.15 ],
    [ u"in",u"Jasidih",16339,24.516667,86.65 ],
    [ u"in",u"Jaspur",42529,29.283333,78.816667 ],
    [ u"in",u"Jasrana",9884,27.25,78.683333 ],
    [ u"in",u"Jaswantnagar",27780,26.878611,78.902778 ],
    [ u"in",u"Jatara",17003,25.016667,79.05 ],
    [ u"in",u"Jatni",56008,20.166667,85.7 ],
    [ u"in",u"Jaunpur",169589,25.733333,82.683333 ],
    [ u"in",u"Jawad",16889,24.6,74.85 ],
    [ u"in",u"Jawala Mukhi",5281,31.883333,76.316667 ],
    [ u"in",u"Jawar",7753,23,76.5 ],
    [ u"in",u"Jawhar",12083,19.916667,73.233333 ],
    [ u"in",u"Jaynagar",20498,26.583333,86.15 ],
    [ u"in",u"Jaynagar-Majilpur",24512,22.175833,88.417778 ],
    [ u"in",u"Jaypur",80844,18.85,82.583333 ],
    [ u"in",u"Jaysingpur",46946,16.8,74.566667 ],
    [ u"in",u"Jejuri",14064,18.283333,74.166667 ],
    [ u"in",u"Jetalsar",14771,21.7,70.583333 ],
    [ u"in",u"Jetpur",118076,21.733333,70.616667 ],
    [ u"in",u"Jevargi",20157,17.016667,76.766667 ],
    [ u"in",u"Jewar",29319,28.133333,77.55 ],
    [ u"in",u"Jhabua",34138,22.766667,74.6 ],
    [ u"in",u"Jha Jha",38628,24.766667,86.366667 ],
    [ u"in",u"Jhajjar",44125,28.616667,76.65 ],
    [ u"in",u"Jhalawar",51888,24.6,76.15 ],
    [ u"in",u"Jhalida",18059,23.366667,85.966667 ],
    [ u"in",u"Jhalrapatan",33123,24.55,76.166667 ],
    [ u"in",u"Jhalu",20358,29.35,78.25 ],
    [ u"in",u"Jhanjharpur",31323,26.266667,86.283333 ],
    [ u"in",u"Jhansi",412968,25.433333,78.583333 ],
    [ u"in",u"Jhargram",57802,22.45,86.983333 ],
    [ u"in",u"Jharia",86947,23.75,86.4 ],
    [ u"in",u"Jharsuguda",79499,21.85,84.033333 ],
    [ u"in",u"Jhinjhak",23501,26.566667,79.733333 ],
    [ u"in",u"Jhinjhana",19713,29.516667,77.216667 ],
    [ u"in",u"Jhunjhunun",113201,28.1307,75.4014 ],
    [ u"in",u"Jhusi",16644,25.433333,81.933333 ],
    [ u"in",u"Jind",161271,29.316667,76.316667 ],
    [ u"in",u"Jintur",42423,19.616667,76.7 ],
    [ u"in",u"Jiran",10983,24.316667,74.883333 ],
    [ u"in",u"Jobat",10786,22.416667,74.566667 ],
    [ u"in",u"Jobner",10829,26.966667,75.383333 ],
    [ u"in",u"Jodhpur",921540,26.286667,73.03 ],
    [ u"in",u"Jodiya",15788,22.716667,70.283333 ],
    [ u"in",u"Jogbani",33303,26.416667,87.25 ],
    [ u"in",u"Jogighopa",2415,26.233333,90.583333 ],
    [ u"in",u"Jogindarnagar",5234,31.983333,76.766667 ],
    [ u"in",u"Jorhat",69036,26.75,94.216667 ],
    [ u"in",u"Joshimath",13866,30.566667,79.566667 ],
    [ u"in",u"Joura",26341,26.333333,77.816667 ],
    [ u"in",u"Jua",5470,15.533333,73.933333 ],
    [ u"in",u"Jubbal",1327,31.116667,77.666667 ],
    [ u"in",u"Jugsalai",49411,22.766667,86.183333 ],
    [ u"in",u"Julana",14509,29.133333,76.416667 ],
    [ u"in",u"Junagadh",184459,21.516667,70.466667 ],
    [ u"in",u"Junagarh",16857,19.866667,82.933333 ],
    [ u"in",u"Junnar",25999,19.2,73.883333 ],
    [ u"in",u"Jutogh",2470,31.1,77.116667 ],
    [ u"in",u"Kabrai",24774,25.416667,80.016667 ],
    [ u"in",u"Kachhwa",15383,25.216667,82.716667 ],
    [ u"in",u"Kadambur",4512,8.983333,77.866667 ],
    [ u"in",u"Kadaura",13785,25.983333,79.85 ],
    [ u"in",u"Kadayanallur",77779,9.083333,77.35 ],
    [ u"in",u"Kadi",58070,23.3,72.333333 ],
    [ u"in",u"Kadipur",7473,26.166667,82.383333 ],
    [ u"in",u"Kadiri",81507,14.116667,78.166667 ],
    [ u"in",u"Kadur",32938,13.553333,76.013056 ],
    [ u"in",u"Kagal",25481,16.583333,74.316667 ],
    [ u"in",u"Kagaznagar",60163,19.333333,79.483333 ],
    [ u"in",u"Kaikalur",20763,16.566667,81.2 ],
    [ u"in",u"Kailaras",24542,26.316667,77.616667 ],
    [ u"in",u"Kailasahar",22124,24.333333,92.016667 ],
    [ u"in",u"Kaimganj",32861,27.566667,79.35 ],
    [ u"in",u"Kaimur",20156,23.383333,79.75 ],
    [ u"in",u"Kairana",80440,29.4,77.2 ],
    [ u"in",u"Kaithal",140614,29.8,76.383333 ],
    [ u"in",u"Kakching",30420,24.483333,93.983333 ],
    [ u"in",u"Kakinada",292956,16.933333,82.216667 ],
    [ u"in",u"Kakori",18334,26.883333,80.8 ],
    [ u"in",u"Kakrala",35694,27.8927,79.1965 ],
    [ u"in",u"Kalagarh",13298,29.5,78.75 ],
    [ u"in",u"Kalaikunda",3232,22.35,87.25 ],
    [ u"in",u"Kalamb",27287,19.05,73.95 ],
    [ u"in",u"Kalamnuri",22709,19.666667,77.333333 ],
    [ u"in",u"Kalanaur",13671,32.016667,75.15 ],
    [ u"in",u"Kalanwali",27357,29.85,74.95 ],
    [ u"in",u"Kalas",14858,18.166667,74.8 ],
    [ u"in",u"Kalavad",26289,22.216667,70.383333 ],
    [ u"in",u"Kalavai",10057,12.766667,79.416667 ],
    [ u"in",u"Kalghatgi",15428,15.183333,74.966667 ],
    [ u"in",u"Kalikapur",4061,22.616667,86.283333 ],
    [ u"in",u"Kalinagar",10729,28.616667,80.1 ],
    [ u"in",u"Kaliyaganj",51753,25.633333,88.316667 ],
    [ u"in",u"Kalka",32207,30.834444,76.933333 ],
    [ u"in",u"Kallidaikurichchi",25515,8.666667,77.483333 ],
    [ u"in",u"Kallupatti",9725,9.716667,77.866667 ],
    [ u"in",u"Kalmeshwar",19387,21.233333,78.9 ],
    [ u"in",u"Kalna",53969,23.216667,88.366667 ],
    [ u"in",u"Kalol",106958,23.25,72.483333 ],
    [ u"in",u"Kalpi",44343,26.116667,79.733333 ],
    [ u"in",u"Kalugumalai",15425,9.15,77.716667 ],
    [ u"in",u"Kalyani",93193,22.983333,88.483333 ],
    [ u"in",u"Kalyan",1262355,19.25,73.15 ],
    [ u"in",u"Kamakhyanagar",15820,20.933333,85.55 ],
    [ u"in",u"Kamalapuram",14677,14.583333,78.65 ],
    [ u"in",u"Kamalganj",16223,27.266667,79.65 ],
    [ u"in",u"Kamalpur",5509,24.2,91.833333 ],
    [ u"in",u"Kaman",33527,27.65,77.266667 ],
    [ u"in",u"Kamareddi",71049,18.316667,78.35 ],
    [ u"in",u"Kamarhati",332997,22.671111,88.374722 ],
    [ u"in",u"Kambam",60834,9.733333,77.3 ],
    [ u"in",u"Kampil",9201,27.616667,79.283333 ],
    [ u"in",u"Kampli",36644,15.4,76.616667 ],
    [ u"in",u"Kamthi",86220,21.233333,79.2 ],
    [ u"in",u"Kanadukathan",4814,10.166667,78.783333 ],
    [ u"in",u"Kanakapura",50757,12.55,77.416667 ],
    [ u"in",u"Kanchipuram",155043,12.833333,79.716667 ],
    [ u"in",u"Kanchrapara",136967,22.97,88.431944 ],
    [ u"in",u"Kandhla",43391,29.316667,77.266667 ],
    [ u"in",u"Kandi",54853,23.95,88.033333 ],
    [ u"in",u"Kandla",25845,23.033333,70.216667 ],
    [ u"in",u"Kandra",6902,22.85,86.05 ],
    [ u"in",u"Kandri",8323,21.416667,79.266667 ],
    [ u"in",u"Kangayam",31367,11,77.566667 ],
    [ u"in",u"Kangra",9159,32.1,76.266667 ],
    [ u"in",u"Kanigiri",25045,15.4,79.516667 ],
    [ u"in",u"Kanina",10816,28.333333,76.316667 ],
    [ u"in",u"Kankavli",15735,16.266667,73.7 ],
    [ u"in",u"Kanke",16714,23.433333,85.316667 ],
    [ u"in",u"Kanker",25987,20.271944,81.493056 ],
    [ u"in",u"Kankipadu",14249,16.45,80.783333 ],
    [ u"in",u"Kankon",12446,15.016667,74.016667 ],
    [ u"in",u"Kannad",42059,20.266667,75.133333 ],
    [ u"in",u"Kannangad",68456,12.316667,75.066667 ],
    [ u"in",u"Kannauj",76721,27.0546,79.922 ],
    [ u"in",u"Kanniyakumari",20542,8.076111,77.548333 ],
    [ u"in",u"Kannod",15872,22.666667,76.733333 ],
    [ u"in",u"Kannur",7625,11.866667,75.365278 ],
    [ u"in",u"Kanodar",11954,24.1,72.383333 ],
    [ u"in",u"Kanor",13090,24.433333,74.266667 ],
    [ u"in",u"Kanpur",2823523,26.466667,80.35 ],
    [ u"in",u"Kantabanji",21026,20.483333,82.916667 ],
    [ u"in",u"Kanth",24886,29.066667,78.633333 ],
    [ u"in",u"Kantilo",8862,20.35,85.183333 ],
    [ u"in",u"Kant",24432,27.8,79.8 ],
    [ u"in",u"Kapasan",19732,24.9,74.333333 ],
    [ u"in",u"Kapra",198349,17.486667,78.566111 ],
    [ u"in",u"Kaptanganj",12300,26.926667,83.715278 ],
    [ u"in",u"Kapurthala",92674,31.379444,75.384722 ],
    [ u"in",u"Karad",55667,17.283333,74.2 ],
    [ u"in",u"Karaikkudi",91916,10.066667,78.783333 ],
    [ u"in",u"Karamadai",31190,11.266667,76.966667 ],
    [ u"in",u"Karambakkudi",12371,10.466667,79.133333 ],
    [ u"in",u"Karamsad",32382,22.55,72.9 ],
    [ u"in",u"Karanja",64740,20.483333,77.483333 ],
    [ u"in",u"Karanpura",21606,29.841944,73.454167 ],
    [ u"in",u"Karari",14404,25.45,81.433333 ],
    [ u"in",u"Karauli",73722,26.5,77.016667 ],
    [ u"in",u"Kareli",27811,22.916667,79.066667 ],
    [ u"in",u"Karera",26215,25.466667,78.15 ],
    [ u"in",u"Kargil",13843,34.566667,76.1 ],
    [ u"in",u"Karhal",26696,27.000278,78.941389 ],
    [ u"in",u"Kariapatti",14398,9.7,78.1 ],
    [ u"in",u"Karimganj",55293,24.866667,92.35 ],
    [ u"in",u"Karimnagar",228770,18.433333,79.15 ],
    [ u"in",u"Karimpur",9565,23.966667,88.616667 ],
    [ u"in",u"Karjat",34577,18.916667,73.333333 ],
    [ u"in",u"Karkal",25376,13.2,74.983333 ],
    [ u"in",u"Karmala",22811,18.416667,75.2 ],
    [ u"in",u"Karnal",225064,29.683333,76.983333 ],
    [ u"in",u"Karrapur",9993,23.95,78.85 ],
    [ u"in",u"Karsiyang",46431,26.882511,88.27729 ],
    [ u"in",u"Kartarpur",26703,31.44,75.499722 ],
    [ u"in",u"Karumbakkam",11992,12.699167,80.093333 ],
    [ u"in",u"Karur",76922,10.95,78.083333 ],
    [ u"in",u"Karwar",64462,14.813611,74.129722 ],
    [ u"in",u"Kasaragod",53313,12.5,75 ],
    [ u"in",u"Kasauli",5215,30.898889,76.964722 ],
    [ u"in",u"Kasba",26940,25.85,87.55 ],
    [ u"in",u"Kasganj",99472,27.816667,78.65 ],
    [ u"in",u"Kashipur",103149,29.216667,78.95 ],
    [ u"in",u"Kasimbazar",10727,24.116667,88.283333 ],
    [ u"in",u"Kasrawad",21486,22.133333,75.6 ],
    [ u"in",u"Katangi",15323,21.783333,79.783333 ],
    [ u"in",u"Katghora",20115,22.5,82.55 ],
    [ u"in",u"Kathor",15311,21.3,72.933333 ],
    [ u"in",u"Kathua",48555,32.366667,75.516667 ],
    [ u"in",u"Katihar",192575,25.533333,87.583333 ],
    [ u"in",u"Katol",41896,21.266667,78.583333 ],
    [ u"in",u"Katpadi",16408,12.983333,79.133333 ],
    [ u"in",u"Katra",9107,32.983333,74.95 ],
    [ u"in",u"Katra",6853,27.516667,82.016667 ],
    [ u"in",u"Katras",57355,23.8,86.283333 ],
    [ u"in",u"Kattivakkam",34598,13.216667,80.316667 ],
    [ u"in",u"Katwa",78416,23.65,88.133333 ],
    [ u"in",u"Kavali",83361,14.916667,79.983333 ],
    [ u"in",u"Kavant",8618,22.1,74.05 ],
    [ u"in",u"Kavaratti",10689,10.566667,72.616667 ],
    [ u"in",u"Kaveripattinam",14209,12.416667,78.233333 ],
    [ u"in",u"Kawardha",35241,22.016667,81.25 ],
    [ u"in",u"Kayalpattinam",36178,8.566667,78.116667 ],
    [ u"in",u"Kayankulam",64189,9.183333,76.5 ],
    [ u"in",u"Kayattar",10008,8.95,77.8 ],
    [ u"in",u"Kedarnath",508,30.733333,79.066667 ],
    [ u"in",u"Kekri",37853,25.966667,75.15 ],
    [ u"in",u"Kelamangalam",11328,12.6,77.85 ],
    [ u"in",u"Kemri",26729,28.816667,79.216667 ],
    [ u"in",u"Kenda",15132,23.2,86.533333 ],
    [ u"in",u"Kendrapara",43847,20.5,86.416667 ],
    [ u"in",u"Kenduadih",9033,23.783333,86.383333 ],
    [ u"in",u"Kerur",17930,16.016667,75.566667 ],
    [ u"in",u"Kesabpur",10921,22.968333,88.262778 ],
    [ u"in",u"Keshod",68523,21.3,70.25 ],
    [ u"in",u"Keshorai Patan",23466,25.3,75.933333 ],
    [ u"in",u"Kesinga",17995,20.2,83.233333 ],
    [ u"in",u"Khachrod",31829,23.416667,75.283333 ],
    [ u"in",u"Khadki",75660,18.566667,73.866667 ],
    [ u"in",u"Khaga",13339,25.783333,81.116667 ],
    [ u"in",u"Khagaria",49988,25.5,86.483333 ],
    [ u"in",u"Khagaul",51583,25.583333,85.05 ],
    [ u"in",u"Khailar",13334,25.35,78.533333 ],
    [ u"in",u"Khairabad",42129,27.533333,80.75 ],
    [ u"in",u"Khairagarh",20097,26.95,77.816667 ],
    [ u"in",u"Khairagarh",15736,21.416667,80.966667 ],
    [ u"in",u"Khair",30176,27.95,77.833333 ],
    [ u"in",u"Khajuraho",25681,24.85,79.933333 ],
    [ u"in",u"Khalilabad",45325,26.775,83.073611 ],
    [ u"in",u"Khamanon",9395,30.818611,76.350833 ],
    [ u"in",u"Khamaria",15034,23.216667,79.883333 ],
    [ u"in",u"Khambhaliya",38123,22.207222,69.668333 ],
    [ u"in",u"Khambhat",81334,22.3,72.616667 ],
    [ u"in",u"Khamgaon",94612,20.683333,76.566667 ],
    [ u"in",u"Khammam",170522,17.25,80.15 ],
    [ u"in",u"Khanapur",17217,15.633333,74.516667 ],
    [ u"in",u"Khandela",23165,27.6,75.5 ],
    [ u"in",u"Khandwa",182860,21.833333,76.333333 ],
    [ u"in",u"Khanna",117146,30.704444,76.223056 ],
    [ u"in",u"Khanpur",14854,24.716667,76.383333 ],
    [ u"in",u"Khanpur",14689,28.533333,78.05 ],
    [ u"in",u"Khapa",15176,21.433333,78.966667 ],
    [ u"in",u"Kharagpur",219686,22.333333,87.333333 ],
    [ u"in",u"Kharagpur",27495,25.116667,86.55 ],
    [ u"in",u"Kharakvasla",23677,18.433333,73.766667 ],
    [ u"in",u"Kharar",45694,30.744444,76.647778 ],
    [ u"in",u"Kharar",12051,22.7,87.683333 ],
    [ u"in",u"Khardaha",128358,22.718611,88.378056 ],
    [ u"in",u"Kharela",13800,25.55,79.816667 ],
    [ u"in",u"Khargapur",13508,24.823,79.144 ],
    [ u"in",u"Khargone",94995,21.816667,75.6 ],
    [ u"in",u"Khargupur",9577,27.383333,81.983333 ],
    [ u"in",u"Kharhial",14008,20.283333,82.766667 ],
    [ u"in",u"Kharod",8927,21.75,82.566667 ],
    [ u"in",u"Kharsawan",7217,22.8,85.833333 ],
    [ u"in",u"Kharsia",18258,21.966667,83.116667 ],
    [ u"in",u"Khatauli",64737,29.283333,77.716667 ],
    [ u"in",u"Khategaon",23407,22.6,76.916667 ],
    [ u"in",u"Khatima",15716,28.916667,79.966667 ],
    [ u"in",u"Khatra",16484,22.983333,86.85 ],
    [ u"in",u"Khawhai",2537,23.366667,93.116667 ],
    [ u"in",u"Kheda",24768,22.75,72.683333 ],
    [ u"in",u"Khed Brahma",29404,24.033333,73.05 ],
    [ u"in",u"Khed",14830,17.716667,73.383333 ],
    [ u"in",u"Khekra",42412,28.866667,77.283333 ],
    [ u"in",u"Khem Karan",12637,31.142778,74.566667 ],
    [ u"in",u"Kheralu",20757,23.883333,72.616667 ],
    [ u"in",u"Kheri",26330,27.9,80.8 ],
    [ u"in",u"Khetia",15022,21.666667,74.583333 ],
    [ u"in",u"Khetri",17178,27.983333,75.8 ],
    [ u"in",u"Khilchipur",16412,24.033333,76.566667 ],
    [ u"in",u"Khirkiya",18500,22.166667,76.85 ],
    [ u"in",u"Khonsa",10188,27.016667,95.566667 ],
    [ u"in",u"Khopoli",64465,18.783333,73.333333 ],
    [ u"in",u"Khour",6690,32.6,74.8 ],
    [ u"in",u"Khowai",20049,24.1,91.633333 ],
    [ u"in",u"Khudaganj",12638,28.15,79.716667 ],
    [ u"in",u"Khujner",9951,23.783333,76.6 ],
    [ u"in",u"Khuldabad",14415,20.05,75.183333 ],
    [ u"in",u"Khunti",31370,23.083333,85.283333 ],
    [ u"in",u"Khurai",31617,24.0436,78.3319 ],
    [ u"in",u"Khurda",42530,20.183333,85.616667 ],
    [ u"in",u"Khurja",105920,28.25,77.85 ],
    [ u"in",u"Khutar",15620,28.2,80.283333 ],
    [ u"in",u"Kichha",34908,28.916667,79.5 ],
    [ u"in",u"Kilakarai",30471,9.233333,78.783333 ],
    [ u"in",u"Kilvelur",7629,10.766667,79.733333 ],
    [ u"in",u"Kinwat",25958,19.633333,78.2 ],
    [ u"in",u"Kiranur",10134,10.566667,78.783333 ],
    [ u"in",u"Kiraoli",21026,27.15,77.783333 ],
    [ u"in",u"Kiratpur",60229,29.516667,78.2 ],
    [ u"in",u"Kiri Buru",9720,22.083333,85.35 ],
    [ u"in",u"Kishanganj",94817,26.116667,87.933333 ],
    [ u"in",u"Kishangarh",10288,27.816667,76.716667 ],
    [ u"in",u"Kishanpur",6105,25.65,81.016667 ],
    [ u"in",u"Kishni",9853,27.0247,79.2634 ],
    [ u"in",u"Kishtwar",20561,33.316667,75.766667 ],
    [ u"in",u"Koath",16727,25.316667,84.266667 ],
    [ u"in",u"Koch Bihar",78744,26.316667,89.433333 ],
    [ u"in",u"Kochi",604751,9.966667,76.233333 ],
    [ u"in",u"Kochinda",14083,21.733333,84.35 ],
    [ u"in",u"Kodaikanal",35024,10.233333,77.483333 ],
    [ u"in",u"Kodala",13188,19.633333,84.95 ],
    [ u"in",u"Kodar",59182,16.983333,79.966667 ],
    [ u"in",u"Kodarma",19182,24.433333,85.516667 ],
    [ u"in",u"Kodigenahalli",5727,13.72,77.390278 ],
    [ u"in",u"Kodinar",34933,20.790278,70.703056 ],
    [ u"in",u"Kodlipet",2686,12.8,75.883333 ],
    [ u"in",u"Kodoli",17537,16.883333,74.2 ],
    [ u"in",u"Kodumudi",13053,11.083333,77.883333 ],
    [ u"in",u"Kodungallur",34213,10.222222,76.199167 ],
    [ u"in",u"Kohima",92117,25.666667,94.116667 ],
    [ u"in",u"Kokrajhar",31972,26.399042,90.271819 ],
    [ u"in",u"Kolaras",17176,25.233333,77.6 ],
    [ u"in",u"Kolar",126452,13.133333,78.133333 ],
    [ u"in",u"Kolhapur",516184,16.7,74.216667 ],
    [ u"in",u"Kollam",394198,8.880556,76.591667 ],
    [ u"in",u"Kollegal",56502,12.15,77.116667 ],
    [ u"in",u"Kombai",13209,9.833333,77.316667 ],
    [ u"in",u"Konanur",9555,12.626389,76.054167 ],
    [ u"in",u"Konch",52778,25.983333,79.15 ],
    [ u"in",u"Kondagaon",27630,19.6,81.666667 ],
    [ u"in",u"Kondapalle",38722,16.616667,80.533333 ],
    [ u"in",u"Konganapuram",8331,11.583333,77.916667 ],
    [ u"in",u"Konnagar",76090,22.7,88.3475 ],
    [ u"in",u"Konnur",19168,16.2,74.75 ],
    [ u"in",u"Kopaganj",33543,26.023333,83.565833 ],
    [ u"in",u"Kopargaon",65121,19.883333,74.483333 ],
    [ u"in",u"Koppa",5124,13.55,75.35 ],
    [ u"in",u"Koppal",60873,15.35,76.15 ],
    [ u"in",u"Koradacheri",6151,10.766667,79.483333 ],
    [ u"in",u"Korampallam",3228,8.766667,78.1 ],
    [ u"in",u"Koraput",41174,18.816667,82.716667 ],
    [ u"in",u"Koratagere",14446,13.522778,77.233056 ],
    [ u"in",u"Koratla",60238,18.816667,78.716667 ],
    [ u"in",u"Korba",419326,22.35,82.683333 ],
    [ u"in",u"Koregaon",25846,18.65,74.083333 ],
    [ u"in",u"Kosamba",33221,21.483333,72.95 ],
    [ u"in",u"Kosgi",15455,15.85,77.266667 ],
    [ u"in",u"Kotagiri",28850,11.433333,76.883333 ],
    [ u"in",u"Kota",763141,25.183333,75.833333 ],
    [ u"in",u"Kota",14632,24.45,83.133333 ],
    [ u"in",u"Kota",15584,22.3,82.033333 ],
    [ u"in",u"Kotaparh",15480,19.15,82.35 ],
    [ u"in",u"Kotar",6959,24.716667,80.983333 ],
    [ u"in",u"Kotdwara",27012,29.75,78.533333 ],
    [ u"in",u"Kothapet",4266,19.333333,79.483333 ],
    [ u"in",u"Kothi",7796,24.75,80.783333 ],
    [ u"in",u"Kot Isa Khan",9639,30.95,75.133333 ],
    [ u"in",u"Kot Kapura",88360,30.583333,74.9 ],
    [ u"in",u"Kot Khai",1253,31.116667,77.533333 ],
    [ u"in",u"Kotma",31759,23.2,81.966667 ],
    [ u"in",u"Kot Putli",43654,27.716667,76.2 ],
    [ u"in",u"Kotra",8535,25.816667,79.316667 ],
    [ u"in",u"Kottagudem",79255,17.55,80.633333 ],
    [ u"in",u"Kottaiyur",11520,10.116667,78.816667 ],
    [ u"in",u"Kottapalli",9901,18.483333,79.1 ],
    [ u"in",u"Kottayam",59442,9.583333,76.516667 ],
    [ u"in",u"Kotturu",24006,14.816667,76.216667 ],
    [ u"in",u"Kovilpatti",90304,9.166667,77.866667 ],
    [ u"in",u"Kovur",35607,14.483333,79.983333 ],
    [ u"in",u"Kovvur",40383,17.016667,81.733333 ],
    [ u"in",u"Koyilandi",70666,11.433333,75.7 ],
    [ u"in",u"Krishnagiri",66425,12.533333,78.233333 ],
    [ u"in",u"Krishnanagar",145941,23.4,88.5 ],
    [ u"in",u"Krishnapur",7336,22.670278,88.269444 ],
    [ u"in",u"Krishnarajasagara",8713,12.436667,76.382778 ],
    [ u"in",u"Krishnarajpet",24291,12.655,76.488333 ],
    [ u"in",u"Kuchaman",56729,27.15,74.85 ],
    [ u"in",u"Kuchera",21798,26.983889,73.971944 ],
    [ u"in",u"Kudal",14433,16.033333,73.683333 ],
    [ u"in",u"Kudchi",19274,16.633333,74.85 ],
    [ u"in",u"Kud",1242,33.083333,75.283333 ],
    [ u"in",u"Kudligi",22975,14.9,76.383333 ],
    [ u"in",u"Kuju",19392,23.716667,85.5 ],
    [ u"in",u"Kukshi",26185,22.2,74.75 ],
    [ u"in",u"Kulgam",16247,33.65,75.016667 ],
    [ u"in",u"Kulpahar",18978,25.316667,79.65 ],
    [ u"in",u"Kulti",305434,23.733333,86.85 ],
    [ u"in",u"Kulu",19832,31.966667,77.1 ],
    [ u"in",u"Kumbakonam",139276,10.966667,79.383333 ],
    [ u"in",u"Kumbhraj",16393,24.366667,77.05 ],
    [ u"in",u"Kumhari",38351,21.266667,81.516667 ],
    [ u"in",u"Kumher",21904,27.316667,77.366667 ],
    [ u"in",u"Kumsi",6468,14.066667,75.4 ],
    [ u"in",u"Kumta",28002,14.416667,74.4 ],
    [ u"in",u"Kunda",24951,25.716667,81.516667 ],
    [ u"in",u"Kundarki",27200,28.7,78.783333 ],
    [ u"in",u"Kundgol",17618,15.25,75.25 ],
    [ u"in",u"Kundla",76814,21.333333,71.3 ],
    [ u"in",u"Kunigal",33276,13.022222,77.026667 ],
    [ u"in",u"Kunnamangalam",38372,11.316667,75.883333 ],
    [ u"in",u"Kunnamkulam",63950,10.65,76.083333 ],
    [ u"in",u"Kuppam",19856,12.75,78.366667 ],
    [ u"in",u"Kurali",25332,30.833056,76.573333 ],
    [ u"in",u"Kurandvad",21389,16.683333,74.583333 ],
    [ u"in",u"Kurara",12731,25.983333,79.983333 ],
    [ u"in",u"Kurduvadi",23132,18.083333,75.433333 ],
    [ u"in",u"Kurgunta",8682,17.2,77.35 ],
    [ u"in",u"Kurinjippadi",23019,11.566667,79.6 ],
    [ u"in",u"Kurud",11296,20.832222,81.721389 ],
    [ u"in",u"Kushalgarh",10350,23.166667,74.45 ],
    [ u"in",u"Kushalnagar",14962,12.466667,75.966667 ],
    [ u"in",u"Kushtagi",24182,15.766667,76.2 ],
    [ u"in",u"Kutiyana",16879,21.623333,69.981667 ],
    [ u"in",u"Kuttanallur",23260,10.7,79.533333 ],
    [ u"in",u"Kuzhithurai",20613,8.316667,77.183333 ],
    [ u"in",u"Lachhmangarh",48145,27.816667,75.033333 ],
    [ u"in",u"Ladnun",60494,27.65,74.383333 ],
    [ u"in",u"Ladwa",23567,29.994444,77.044444 ],
    [ u"in",u"Lahar",32889,26.198333,78.945 ],
    [ u"in",u"Laharpur",55917,27.716667,80.9 ],
    [ u"in",u"Lakheri",28466,25.666667,76.166667 ],
    [ u"in",u"Lakhimpur",59844,27.233333,94.116667 ],
    [ u"in",u"Lakhimpur",140237,27.95,80.766667 ],
    [ u"in",u"Lakhipur",12873,24.8,93.016667 ],
    [ u"in",u"Lakhisarai",89509,25.183333,86.083333 ],
    [ u"in",u"Lakhnadon",15591,22.6,79.6 ],
    [ u"in",u"Lakhna",11390,26.65,79.15 ],
    [ u"in",u"Lakhnau",2472250,26.85,80.916667 ],
    [ u"in",u"Lakhtar",14534,22.85,71.783333 ],
    [ u"in",u"Laksar",19272,29.766667,78.05 ],
    [ u"in",u"Lakshettipet",11164,18.866667,79.216667 ],
    [ u"in",u"Lakshmeshwar",35143,15.133333,75.466667 ],
    [ u"in",u"Lala",10942,24.55,92.6 ],
    [ u"in",u"Lalganj",31882,25.866667,85.183333 ],
    [ u"in",u"Lalganj",23730,25.933333,81.7 ],
    [ u"in",u"Lalgudi",20918,10.866667,78.833333 ],
    [ u"in",u"Lalitpur",126487,24.683333,78.416667 ],
    [ u"in",u"Lalpur",15076,22.2,69.966667 ],
    [ u"in",u"Lalsot",31482,26.566667,76.333333 ],
    [ u"in",u"Lanja",13120,16.85,73.55 ],
    [ u"in",u"Lar",26691,26.203889,83.971667 ],
    [ u"in",u"Lasalgaon",13666,20.15,74.233333 ],
    [ u"in",u"Latehar",20771,23.75,84.5 ],
    [ u"in",u"Lathi",22747,21.716667,71.383333 ],
    [ u"in",u"Latur",348994,18.4,76.583333 ],
    [ u"in",u"Lawar",19558,29.116667,77.766667 ],
    [ u"in",u"Leh",37498,34.166667,77.583333 ],
    [ u"in",u"Limbdi",41743,22.566667,71.8 ],
    [ u"in",u"Lingsugur",29785,16.166667,76.516667 ],
    [ u"in",u"Lodhikheda",9995,21.583333,78.833333 ],
    [ u"in",u"Lohardaga",53037,23.433333,84.683333 ],
    [ u"in",u"Loharu",12411,28.45,75.816667 ],
    [ u"in",u"Lonar",21767,19.983333,76.533333 ],
    [ u"in",u"Lonavale",58567,18.75,73.416667 ],
    [ u"in",u"Londa",6132,15.466667,74.516667 ],
    [ u"in",u"Loni",164927,28.75,77.283333 ],
    [ u"in",u"Lormi",12858,22.283333,81.733333 ],
    [ u"in",u"Losal",27966,27.4,74.916667 ],
    [ u"in",u"Loyabad",33165,23.666667,86.666667 ],
    [ u"in",u"Ludhiana",1545476,30.9,75.85 ],
    [ u"in",u"Lumding",25777,25.75,93.166667 ],
    [ u"in",u"Lunavada",35433,23.133333,73.616667 ],
    [ u"in",u"Lunglei",52734,22.883333,92.733333 ],
    [ u"in",u"Machalpur",8557,24.133333,76.3 ],
    [ u"in",u"Macherla",51044,16.483333,79.433333 ],
    [ u"in",u"Machhiwara",20448,30.914722,76.198333 ],
    [ u"in",u"Machhlishahr",25250,25.683333,82.416667 ],
    [ u"in",u"Machilipatnam",192848,16.166667,81.133333 ],
    [ u"in",u"Madanapalle",108605,13.55,78.5 ],
    [ u"in",u"Madanpur",12960,23.016667,88.483333 ],
    [ u"in",u"Maddur",28143,12.6,77.066667 ],
    [ u"in",u"Madgaon",86827,15.3,73.95 ],
    [ u"in",u"Madhavaram",90052,13.149167,80.236667 ],
    [ u"in",u"Madhipura",50575,25.916667,86.783333 ],
    [ u"in",u"Madhoganj",10300,27.116667,80.15 ],
    [ u"in",u"Madhogarh",5052,24.566667,80.9 ],
    [ u"in",u"Madhogarh",10531,26.276,79.1869 ],
    [ u"in",u"Madhubani",71590,26.366667,86.083333 ],
    [ u"in",u"Madhugiri",28127,13.660556,77.209167 ],
    [ u"in",u"Madhupur",50677,24.25,86.65 ],
    [ u"in",u"Madhyamgram",161142,22.7,88.45 ],
    [ u"in",u"Madikeri",33543,12.416667,75.733333 ],
    [ u"in",u"Madras",4328416,13.083333,80.283333 ],
    [ u"in",u"Madukkarai",29147,10.9,76.966667 ],
    [ u"in",u"Madukkur",15631,10.483333,79.4 ],
    [ u"in",u"Madurai",909988,9.933333,78.116667 ],
    [ u"in",u"Magadi",27215,12.966667,77.233333 ],
    [ u"in",u"Magam",4690,34.083333,74.583333 ],
    [ u"in",u"Maghar",17013,26.757222,83.127778 ],
    [ u"in",u"Mahabaleshwar",13599,17.916667,73.666667 ],
    [ u"in",u"Mahaban",9515,27.433333,77.75 ],
    [ u"in",u"Mahad",26667,18.083333,73.416667 ],
    [ u"in",u"Mahalingpur",32702,16.383333,75.116667 ],
    [ u"in",u"Maham",19385,28.983333,76.3 ],
    [ u"in",u"Maharajganj",22433,26.116667,84.483333 ],
    [ u"in",u"Maharajganj",30551,27.133333,83.566667 ],
    [ u"in",u"Mahasamund",50447,21.1,82.1 ],
    [ u"in",u"Mahbubabad",37957,17.616667,80.016667 ],
    [ u"in",u"Mahbubnagar",136150,16.733333,77.983333 ],
    [ u"in",u"Mahe",38188,11.7,75.533333 ],
    [ u"in",u"Mahemdavad",32506,22.833333,72.766667 ],
    [ u"in",u"Mahendragarh",25730,28.283333,76.15 ],
    [ u"in",u"Mahesana",102675,23.6,72.4 ],
    [ u"in",u"Maheshwar",21502,22.183333,75.583333 ],
    [ u"in",u"Mahiari",17053,22.592222,88.237778 ],
    [ u"in",u"Mahishadal",17988,22.183333,87.983333 ],
    [ u"in",u"Mahmudabad",45925,27.3,81.116667 ],
    [ u"in",u"Mahoba",89179,25.283333,79.866667 ],
    [ u"in",u"Maholi",19345,27.666667,80.466667 ],
    [ u"in",u"Mahroni",8899,24.5862,78.7288 ],
    [ u"in",u"Mahudha",16828,22.816667,72.933333 ],
    [ u"in",u"Mahur",7178,25.166667,93.116667 ],
    [ u"in",u"Mahuva",74625,21.083333,71.8 ],
    [ u"in",u"Mahwa",22626,27.05,76.933333 ],
    [ u"in",u"Maibong",8365,25.3,93.166667 ],
    [ u"in",u"Maihar",37917,24.266667,80.75 ],
    [ u"in",u"Mailani",14213,28.283333,80.35 ],
    [ u"in",u"Mainaguri",29462,26.566667,88.816667 ],
    [ u"in",u"Maindargi",11445,17.466667,76.3 ],
    [ u"in",u"Mainpuri",94629,27.233333,79.016667 ],
    [ u"in",u"Mairang",12586,25.566667,91.633333 ],
    [ u"in",u"Mairwa",20165,26.233333,84.15 ],
    [ u"in",u"Maisuru",868385,12.307222,76.649722 ],
    [ u"in",u"Majalgaon",47848,19.15,76.233333 ],
    [ u"in",u"Majholi",11554,23.5,79.916667 ],
    [ u"in",u"Majitha",13901,31.758333,74.954444 ],
    [ u"in",u"Makhu",12885,31.103333,74.997778 ],
    [ u"in",u"Makrana",93911,27.05,74.716667 ],
    [ u"in",u"Maksi",20096,23.266667,76.15 ],
    [ u"in",u"Makum",16226,27.5,95.45 ],
    [ u"in",u"Malappuram",61749,11.066667,76.066667 ],
    [ u"in",u"Malaut",76621,30.216667,74.483333 ],
    [ u"in",u"Malavalli",38132,12.383333,77.083333 ],
    [ u"in",u"Malegaon",435397,20.55,74.533333 ],
    [ u"in",u"Maler Kotla",113848,30.516667,75.883333 ],
    [ u"in",u"Malhargarh",7621,24.283333,74.983333 ],
    [ u"in",u"Malia",14423,23.083333,70.766667 ],
    [ u"in",u"Malihabad",16651,26.916667,80.716667 ],
    [ u"in",u"Malkangiri",25056,18.35,81.9 ],
    [ u"in",u"Malkapur",5582,16.933333,73.916667 ],
    [ u"in",u"Malkera",12593,23.783333,86.3 ],
    [ u"in",u"Mallapuram",11837,11.966667,78.25 ],
    [ u"in",u"Mallasamudram",18822,11.483333,78.033333 ],
    [ u"in",u"Mallur",10525,11.55,78.133333 ],
    [ u"in",u"Malpe",23496,13.35,74.716667 ],
    [ u"in",u"Malpura",28602,26.283333,75.383333 ],
    [ u"in",u"Malpur",6972,23.35,73.45 ],
    [ u"in",u"Malur",30680,13.0075,77.937778 ],
    [ u"in",u"Malwan",18860,16.066667,73.466667 ],
    [ u"in",u"Mamallapuram",12415,12.626389,80.172222 ],
    [ u"in",u"Mamit",6104,23.933333,92.483333 ],
    [ u"in",u"Manali",8344,32.266667,77.166667 ],
    [ u"in",u"Manali",32366,13.166667,80.266667 ],
    [ u"in",u"Manalurpet",7626,12.016667,79.1 ],
    [ u"in",u"Manamadurai",27496,9.7,78.483333 ],
    [ u"in",u"Manapparai",36930,10.6,78.416667 ],
    [ u"in",u"Manasa",24081,24.483333,75.15 ],
    [ u"in",u"Manavadar",29107,21.5,70.133333 ],
    [ u"in",u"Manavalakurichi",10720,8.133333,77.3 ],
    [ u"in",u"Manawar",27640,22.233333,75.083333 ],
    [ u"in",u"Manchar",14739,19,73.933333 ],
    [ u"in",u"Mancheral",78006,18.866667,79.433333 ],
    [ u"in",u"Mandalgarh",21570,25.2,75.1 ],
    [ u"in",u"Mandal",13345,23.3,71.916667 ],
    [ u"in",u"Mandal",23478,25.45,74.566667 ],
    [ u"in",u"Mandapam",15080,9.283333,79.116667 ],
    [ u"in",u"Mandapeta",48858,16.866667,81.933333 ],
    [ u"in",u"Mandasa",9289,18.866667,84.466667 ],
    [ u"in",u"Mandawar",10979,27.866667,76.55 ],
    [ u"in",u"Mandawar",21341,29.5,78.133333 ],
    [ u"in",u"Mandi",28219,31.716667,76.916667 ],
    [ u"in",u"Mandla",45189,22.6,80.383333 ],
    [ u"in",u"Mandleshwar",12051,22.183333,75.666667 ],
    [ u"in",u"Mandsaur",125002,24.066667,75.066667 ],
    [ u"in",u"Mandvi",18669,21.25,73.3 ],
    [ u"in",u"Mandya",134857,12.524167,76.895833 ],
    [ u"in",u"Maner",27904,25.65,84.883333 ],
    [ u"in",u"Mangalagiri",59398,16.433333,80.55 ],
    [ u"in",u"Mangalam",11379,9.766667,78.666667 ],
    [ u"in",u"Mangaldai",24872,26.433333,92.033333 ],
    [ u"in",u"Mangaluru",417423,12.863889,74.835278 ],
    [ u"in",u"Mangan",1464,27.516667,88.533333 ],
    [ u"in",u"Mangawan",12504,24.683333,81.55 ],
    [ u"in",u"Manglaur",46400,29.8,77.866667 ],
    [ u"in",u"Mangrol",58993,21.116667,70.116667 ],
    [ u"in",u"Mangrol",23897,25.333333,76.516667 ],
    [ u"in",u"Mangrul Pir",29200,20.316667,77.35 ],
    [ u"in",u"Manihari",23734,25.35,87.633333 ],
    [ u"in",u"Manikpur",14417,25.066667,81.116667 ],
    [ u"in",u"Manjeri",89209,11.116667,76.116667 ],
    [ u"in",u"Manjeshwar",8928,12.7,74.883333 ],
    [ u"in",u"Manjhanpur",16940,25.533333,81.383333 ],
    [ u"in",u"Mankachar",31092,25.533333,89.866667 ],
    [ u"in",u"Mankapur",9747,27.033333,82.233333 ],
    [ u"in",u"Manmad",76729,20.25,74.45 ],
    [ u"in",u"Mannarakkat",50921,10.983333,76.466667 ],
    [ u"in",u"Mannargudi",63154,10.666667,79.433333 ],
    [ u"in",u"Manoharpur",28928,27.3,75.95 ],
    [ u"in",u"Manoharpur",13190,22.383333,85.2 ],
    [ u"in",u"Manohar Thana",10100,24.233333,76.8 ],
    [ u"in",u"Manor",8918,19.75,72.916667 ],
    [ u"in",u"Manpur",6639,22.433333,75.616667 ],
    [ u"in",u"Mansa",29553,23.433333,72.666667 ],
    [ u"in",u"Mansa",80024,29.983333,75.383333 ],
    [ u"in",u"Mansar",6901,21.4,79.25 ],
    [ u"in",u"Manthani",15665,18.65,79.666667 ],
    [ u"in",u"Manvi",41650,15.983333,77.05 ],
    [ u"in",u"Manwath",30626,19.3,76.5 ],
    [ u"in",u"Marakkanam",19734,12.2,79.95 ],
    [ u"in",u"Marandahalli",10480,12.4,78 ],
    [ u"in",u"Margherita",24430,27.283333,95.683333 ],
    [ u"in",u"Marhaura",26140,25.966667,84.866667 ],
    [ u"in",u"Mariahu",22251,25.616667,82.616667 ],
    [ u"in",u"Mariani",23641,26.666667,94.333333 ],
    [ u"in",u"Markapur",63990,15.733333,79.283333 ],
    [ u"in",u"Masaurhi",53446,25.35,85.033333 ],
    [ u"in",u"Masila",11461,22.580833,88.232778 ],
    [ u"in",u"Masinigudi",9642,11.566667,76.666667 ],
    [ u"in",u"Masuri",25756,30.45,78.083333 ],
    [ u"in",u"Mataundh",8592,25.45,80.15 ],
    [ u"in",u"Matheran",5288,18.983333,73.266667 ],
    [ u"in",u"Mathura",330543,27.5,77.683333 ],
    [ u"in",u"Mau Aima",20125,25.7,81.916667 ],
    [ u"in",u"Maudaha",37848,25.683333,80.116667 ],
    [ u"in",u"Mauganj",25540,24.683333,81.883333 ],
    [ u"in",u"Mau",19301,26.043611,78.984722 ],
    [ u"in",u"Mau",246074,25.941667,83.561111 ],
    [ u"in",u"Maurawan",14918,26.433333,80.883333 ],
    [ u"in",u"Maur",28298,30.083333,75.25 ],
    [ u"in",u"Mavelikara",28303,9.266667,76.55 ],
    [ u"in",u"Mavur",28316,11.266667,75.916667 ],
    [ u"in",u"Mawana",76981,29.083333,77.866667 ],
    [ u"in",u"Mayakonda",6445,14.283333,76.083333 ],
    [ u"in",u"Mayang Imphal",22160,24.616667,93.883333 ],
    [ u"in",u"Medak",44356,18.033333,78.266667 ],
    [ u"in",u"Meghraj",10498,23.5,73.5 ],
    [ u"in",u"Mehkar",41140,20.15,76.566667 ],
    [ u"in",u"Mehnagar",14898,25.883333,83.116667 ],
    [ u"in",u"Mehndawal",25498,26.975278,83.111667 ],
    [ u"in",u"Melukote",4011,12.658889,76.650556 ],
    [ u"in",u"Melur",33842,10.05,78.333333 ],
    [ u"in",u"Memari",44452,23.2,88.116667 ],
    [ u"in",u"Merta",43761,26.65,74.033333 ],
    [ u"in",u"Methala",42444,10.222222,76.199167 ],
    [ u"in",u"Mettupalayam",9587,11.166667,78.45 ],
    [ u"in",u"Mettur",56748,11.8,77.8 ],
    [ u"in",u"Mhasla",9332,18.133333,73.116667 ],
    [ u"in",u"Mihijam",37259,23.866667,86.866667 ],
    [ u"in",u"Mihona",15832,26.284444,78.981667 ],
    [ u"in",u"Milak",28508,28.616667,79.183333 ],
    [ u"in",u"Minjur",24674,13.266667,80.266667 ],
    [ u"in",u"Miranpur",27392,29.3,77.933333 ],
    [ u"in",u"Mirganj",15336,28.55,79.2 ],
    [ u"in",u"Mirik",10110,26.894527,88.18484 ],
    [ u"in",u"Mirzapur",220051,25.15,82.583333 ],
    [ u"in",u"Misrikh",15014,27.45,80.516667 ],
    [ u"in",u"Modasa",58974,23.466667,73.3 ],
    [ u"in",u"Moga",130559,30.8,75.166667 ],
    [ u"in",u"Mohan",14710,26.783333,80.65 ],
    [ u"in",u"Mohanur",12846,11.083333,78.166667 ],
    [ u"in",u"Mohgaon",10447,21.65,78.716667 ],
    [ u"in",u"Mohiuddinagar",14940,25.583333,85.666667 ],
    [ u"in",u"Mohpa",7141,21.316667,78.816667 ],
    [ u"in",u"Moirang",17104,24.5,93.766667 ],
    [ u"in",u"Mokama",55209,25.4,85.916667 ],
    [ u"in",u"Mokokchung",34023,26.333333,94.533333 ],
    [ u"in",u"Mon",18743,26.75,95.1 ],
    [ u"in",u"Monoharpur",23364,22.108333,88.078889 ],
    [ u"in",u"Moradabad",721210,28.833333,78.783333 ],
    [ u"in",u"Moram",17697,17.8,76.466667 ],
    [ u"in",u"Morar",44456,26.226111,78.226111 ],
    [ u"in",u"Morena",152020,26.496944,78 ],
    [ u"in",u"Mormugao",102355,15.4,73.8 ],
    [ u"in",u"Morvi",118021,22.816667,70.833333 ],
    [ u"in",u"Morwa",20169,22.9,73.833333 ],
    [ u"in",u"Moth",14078,25.716667,78.95 ],
    [ u"in",u"Motihari",112156,26.65,84.916667 ],
    [ u"in",u"Mount Abu",24982,24.6,72.7 ],
    [ u"in",u"Mubarakpur",53268,26.09,83.292222 ],
    [ u"in",u"Mudbidri",30635,13.083333,74.983333 ],
    [ u"in",u"Muddebihal",31898,16.333333,76.133333 ],
    [ u"in",u"Mudgal",21007,16.016667,76.433333 ],
    [ u"in",u"Mudhol",47431,16.35,75.283333 ],
    [ u"in",u"Mudigere",9323,13.133333,75.633333 ],
    [ u"in",u"Mudkhed",20777,19.166667,77.516667 ],
    [ u"in",u"Mughal Sarai",98053,25.3,83.116667 ],
    [ u"in",u"Mugma",3195,23.766667,86.733333 ],
    [ u"in",u"Muhammadabad",22151,27.316667,79.45 ],
    [ u"in",u"Mukerian",22753,31.950556,75.615833 ],
    [ u"in",u"Muktsar",89840,30.483333,74.516667 ],
    [ u"in",u"Mulanur",12264,10.766667,77.716667 ],
    [ u"in",u"Mulbagal",47466,13.166667,78.4 ],
    [ u"in",u"Mulgund",18930,15.25,75.533333 ],
    [ u"in",u"Mulki",17260,13.1,74.8 ],
    [ u"in",u"Mul",23986,20.066667,79.666667 ],
    [ u"in",u"Multai",22031,21.766667,78.25 ],
    [ u"in",u"Munak",15802,29.516667,76.85 ],
    [ u"in",u"Mundargi",21828,15.216667,75.9 ],
    [ u"in",u"Mundgod",17000,14.966667,75.033333 ],
    [ u"in",u"Mundi",11410,22.066667,76.5 ],
    [ u"in",u"Mundra",15219,22.85,69.733333 ],
    [ u"in",u"Mundwa",17466,27.066667,73.816667 ],
    [ u"in",u"Mungaoli",20083,24.416667,78.1 ],
    [ u"in",u"Mungeli",27701,22.066667,81.683333 ],
    [ u"in",u"Munger",203185,25.383333,86.466667 ],
    [ u"in",u"Munirabad",8246,15.333333,76.333333 ],
    [ u"in",u"Muradnagar",89491,28.783333,77.5 ],
    [ u"in",u"Muragachha",10324,23.533333,88.4 ],
    [ u"in",u"Murbad",17495,19.25,73.4 ],
    [ u"in",u"Murgud",9396,16.4,74.2 ],
    [ u"in",u"Muri",12658,23.366667,85.866667 ],
    [ u"in",u"Murliganj",23846,25.9,86.983333 ],
    [ u"in",u"Mursan",12311,27.583333,77.933333 ],
    [ u"in",u"Murshidabad",39561,24.183333,88.266667 ],
    [ u"in",u"Murud",12666,18.325833,72.965 ],
    [ u"in",u"Murwara",195877,23.85,80.4 ],
    [ u"in",u"Musafirkhana",8082,26.366667,81.8 ],
    [ u"in",u"Mushabani",32765,22.516667,86.45 ],
    [ u"in",u"Musiri",30211,10.933333,78.45 ],
    [ u"in",u"Mustafabad",8975,30.2,77.15 ],
    [ u"in",u"Muttupet",21568,10.4,79.483333 ],
    [ u"in",u"Muvattupula",29666,9.966667,76.583333 ],
    [ u"in",u"Muzaffarnagar",349741,29.466667,77.683333 ],
    [ u"in",u"Muzaffarpur",333235,26.116667,85.4 ],
    [ u"in",u"Muzhappilangad",23033,11.8,75.45 ],
    [ u"in",u"Nabagram",34731,22.288056,88.509167 ],
    [ u"in",u"Nabha",64645,30.374722,76.148611 ],
    [ u"in",u"Nabinagar",20851,24.616667,84.116667 ],
    [ u"in",u"Nadapuram",39512,11.7,75.666667 ],
    [ u"in",u"Nadaun",4838,31.783333,76.35 ],
    [ u"in",u"Nadbai",23522,27.233333,77.2 ],
    [ u"in",u"Nadiad",202080,22.7,72.866667 ],
    [ u"in",u"Nadigaon",7598,26.116667,79.033333 ],
    [ u"in",u"Naduvattam",11675,11.483333,76.566667 ],
    [ u"in",u"Naenwa",16416,25.766667,75.85 ],
    [ u"in",u"Nagamangala",16761,12.815556,76.7575 ],
    [ u"in",u"Nagapattinam",94247,10.766667,79.833333 ],
    [ u"in",u"Nagari",25936,13.333333,79.583333 ],
    [ u"in",u"Nagar Karnul",29442,16.483333,78.333333 ],
    [ u"in",u"Nagar",23548,27.433333,77.1 ],
    [ u"in",u"Nagaur",96853,27.2,73.733333 ],
    [ u"in",u"Nagda",103513,23.45,75.416667 ],
    [ u"in",u"Nagercoil",213877,8.193889,77.431389 ],
    [ u"in",u"Nagina",76601,29.45,78.45 ],
    [ u"in",u"Nagireddipalle",10394,14.266667,79.1 ],
    [ u"in",u"Nagod",21734,24.566667,80.6 ],
    [ u"in",u"Nagothana",10866,18.533333,73.133333 ],
    [ u"in",u"Nagpur",2228191,21.15,79.1 ],
    [ u"in",u"Nagram",9859,26.616667,81.133333 ],
    [ u"in",u"Nahan",27547,30.55,77.3 ],
    [ u"in",u"Naigarhi",9392,24.783333,81.783333 ],
    [ u"in",u"Naihati",253245,22.902778,88.416944 ],
    [ u"in",u"Naini Tal",42314,29.383333,79.45 ],
    [ u"in",u"Nainpur",22338,22.433333,80.116667 ],
    [ u"in",u"Najibabad",84014,29.633333,78.333333 ],
    [ u"in",u"Nakodar",32407,31.125833,75.473333 ],
    [ u"in",u"Nakur",23086,29.916667,77.3 ],
    [ u"in",u"Nalagarh",10250,31.05,76.716667 ],
    [ u"in",u"Nalbari",24618,26.416667,91.433333 ],
    [ u"in",u"Naldurg",17262,17.816667,76.3 ],
    [ u"in",u"Nalgonda",121839,17.05,79.266667 ],
    [ u"in",u"Nalhati",25878,24.3,87.816667 ],
    [ u"in",u"Naliya",10586,23.266667,68.833333 ],
    [ u"in",u"Namagiripettai",22098,11.466667,78.266667 ],
    [ u"in",u"Namakkal",56002,11.233333,78.166667 ],
    [ u"in",u"Nambiyur",16126,11.366667,77.333333 ],
    [ u"in",u"Nambutalai",7914,9.716667,79 ],
    [ u"in",u"Namchi",1147,27.166667,88.35 ],
    [ u"in",u"Namli",9236,23.433333,75.05 ],
    [ u"in",u"Nanded",485150,19.15,77.333333 ],
    [ u"in",u"Nandgaon",24211,20.316667,74.65 ],
    [ u"in",u"Nandgaon",10450,27.716667,77.383333 ],
    [ u"in",u"Nandigama",38227,16.783333,80.3 ],
    [ u"in",u"Nandikotkur",45352,15.866667,78.266667 ],
    [ u"in",u"Nandura",39653,20.833333,76.45 ],
    [ u"in",u"Nandurbar",100711,21.366667,74.25 ],
    [ u"in",u"Nandyal",165355,15.483333,78.483333 ],
    [ u"in",u"Nangal",44179,31.366667,76.383333 ],
    [ u"in",u"Nangavalli",9902,11.75,77.883333 ],
    [ u"in",u"Nangloi Jat",194381,28.683333,77.066667 ],
    [ u"in",u"Nanguneri",6969,8.483333,77.666667 ],
    [ u"in",u"Nanjangud",50247,12.119722,76.682778 ],
    [ u"in",u"Nannilam",10180,10.883333,79.616667 ],
    [ u"in",u"Nanpara",46285,27.866667,81.5 ],
    [ u"in",u"Napasar",21749,27.966667,73.55 ],
    [ u"in",u"Naraina",17048,26.783333,75.2 ],
    [ u"in",u"Naraini",15078,25.183333,80.483333 ],
    [ u"in",u"Narasannapeta",24273,18.416667,84.05 ],
    [ u"in",u"Narasapur",59310,16.45,81.666667 ],
    [ u"in",u"Narasaraopet",97205,16.25,80.066667 ],
    [ u"in",u"Narasimharajapura",7776,13.616667,75.516667 ],
    [ u"in",u"Narasingapuram",10875,13.616667,79.333333 ],
    [ u"in",u"Narauli",17947,28.5,78.716667 ],
    [ u"in",u"Naraura",22434,28.2,78.383333 ],
    [ u"in",u"Naravarikuppam",18556,13.195556,80.174167 ],
    [ u"in",u"Narayanavanam",11432,13.416667,79.583333 ],
    [ u"in",u"Narayangarh",20087,30.2392,76.9329 ],
    [ u"in",u"Narayangarh",10234,24.283333,75.05 ],
    [ u"in",u"Narayanpet",39045,16.733333,77.5 ],
    [ u"in",u"Naregal",17405,15.583333,75.816667 ],
    [ u"in",u"Narendranagar",4734,30.166667,78.3 ],
    [ u"in",u"Narkanda",718,31.266667,77.45 ],
    [ u"in",u"Narnaul",66053,28.044444,76.108333 ],
    [ u"in",u"Narnaund",16300,29.216667,76.15 ],
    [ u"in",u"Naroda",5366,23.083333,72.666667 ],
    [ u"in",u"Narsimhapur",47516,22.95,79.2 ],
    [ u"in",u"Narsingi",6445,18.033333,78.433333 ],
    [ u"in",u"Narsipatnam",33759,17.666667,82.616667 ],
    [ u"in",u"Narwana",55854,29.616667,76.116667 ],
    [ u"in",u"Narwar",16949,25.65,77.9 ],
    [ u"in",u"Nasirabad",51751,26.3,74.733333 ],
    [ u"in",u"Naspur",15374,18.833333,79.45 ],
    [ u"in",u"Nasriganj",23287,25.05,84.333333 ],
    [ u"in",u"Nasrullaganj",18267,22.683333,77.266667 ],
    [ u"in",u"Nathdwara",39429,24.933333,73.816667 ],
    [ u"in",u"Nattam",21888,10.233333,78.233333 ],
    [ u"in",u"Nattarasankottai",5921,9.866667,78.566667 ],
    [ u"in",u"Naugachhia",41251,25.4,87.1 ],
    [ u"in",u"Nautanwa",32590,27.433333,83.416667 ],
    [ u"in",u"Navadwip",111134,23.416667,88.366667 ],
    [ u"in",u"Navalgund",23210,15.566667,75.366667 ],
    [ u"in",u"Navapur",32323,21.15,73.8 ],
    [ u"in",u"Navelim",12470,15.25,73.916667 ],
    [ u"in",u"Navsari",136204,20.85,72.916667 ],
    [ u"in",u"Nawabganj",17016,26.866667,82.133333 ],
    [ u"in",u"Nawada",96740,24.883333,85.533333 ],
    [ u"in",u"Nawalgarh",58350,27.85,75.266667 ],
    [ u"in",u"Nawa",20046,27.016667,75 ],
    [ u"in",u"Nawashahr",31123,31.116667,76.133333 ],
    [ u"in",u"Naya Bazar",1035,27.133333,88.266667 ],
    [ u"in",u"Nayagarh",16002,20.133333,85.1 ],
    [ u"in",u"Nayudupeta",45778,13.9,79.9 ],
    [ u"in",u"Nazira",14303,26.916667,94.733333 ],
    [ u"in",u"Nedumangad",58284,8.6,77 ],
    [ u"in",u"Nellikkuppam",44427,11.766667,79.683333 ],
    [ u"in",u"Nepa Nagar",32614,21.466667,76.4 ],
    [ u"in",u"Neral",16061,19.033333,73.316667 ],
    [ u"in",u"Nerkunram",47530,13.061944,80.209444 ],
    [ u"in",u"Netarhat",4424,23.483333,84.266667 ],
    [ u"in",u"New Delhi",10928270,28.6,77.2 ],
    [ u"in",u"Neyveli",131213,11.533333,79.483333 ],
    [ u"in",u"Neyyattinkara",88143,8.4,77.083333 ],
    [ u"in",u"Nichlaul",17569,27.316667,83.733333 ],
    [ u"in",u"Nidadavole",44176,16.916667,81.666667 ],
    [ u"in",u"Nidamangalam",9126,10.766667,79.416667 ],
    [ u"in",u"Nihtaur",48394,29.333333,78.383333 ],
    [ u"in",u"Nilagiri",15463,21.458056,86.766944 ],
    [ u"in",u"Nilakkottai",21685,10.166667,77.866667 ],
    [ u"in",u"Nilanga",34494,18.1,76.766667 ],
    [ u"in",u"Nileshwar",25404,12.25,75.1 ],
    [ u"in",u"Nilokheri",17361,29.833333,76.916667 ],
    [ u"in",u"Nimaj",20424,26.149722,74 ],
    [ u"in",u"Nimaparha",18224,20.066667,86.016667 ],
    [ u"in",u"Nimbahera",58089,24.616667,74.683333 ],
    [ u"in",u"Nim ka Thana",32692,27.733333,75.8 ],
    [ u"in",u"Nipani",60356,16.4,74.383333 ],
    [ u"in",u"Nirmali",17104,26.316667,86.583333 ],
    [ u"in",u"Nirmal",80991,19.1,78.35 ],
    