#
# Copyright (c) 2014-2021 National Technology and Engineering
# Solutions of Sandia, LLC. Under the terms of Contract DE-NA0003525
# with National Technology and Engineering Solutions of Sandia, LLC,
# the U.S. Government retains certain rights in this software.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


AIRPORTS_BY_TRAFFIC = {
    'ATL': 92365860,
    'PEK': 77403668,
    'LHR': 69433565,
    'ORD': 66561023,
    'HND': 62263025,
    'LAX': 61848449,
    'CDG': 60970551,
    'DFW': 57806152,
    'FRA': 56436255,
    'HKG': 53314213,
    'DEN': 52699298,
    'DXB': 50977960,
    'CGK': 50446618,
    'AMS': 49754910,
    'MAD': 49644302,
    'BKK': 47910744,
    'JFK': 47854283,
    'SIN': 46543845,
    'CAN': 45400156,
    'LAS': 41479572,
    'PVG': 41450211,
    'SFO': 40907389,
    'PHX': 40565677,
    'IAH': 40170844,
    'CLT': 39043708,
    'MIA': 38314389,
    'MUC': 37763701,
    'KUL': 37670586,
    'FCO': 37561222,
    'IST': 37398221,
    'SYD': 36022614,
    'MCO': 35356991,
    'ICN': 35191825,
    'DEL': 34729467,
    'BCN': 34387597,
    'LGW': 33668048,
    'EWR': 33577154,
    'YYZ': 33434199,
    'SHA': 33112442,
    'MSP': 33047443,
    'SEA': 32820060,
    'DTW': 32419181,
    'PHL': 30839130,
    'BOM': 30439122,
    'GRU': 30371131,
    'MNL': 29551394,
    'CTU': 29073990,
    'BOS': 28866313,
    'SZX': 28245745,
    'MEL': 28060111,
    'NRT': 28055772,
    'ORY': 27139076,
    'MEX': 26368861,
    'DME': 25701610,
    'AYT': 25183142,
    'TPE': 24947551,
    'ZRH': 24283941,
    'LGA': 24028400,
    'FLL': 23348804,
    'IAD': 23056291,
    'PMI': 22723837,
    'CPH': 22673477,
    'SVO': 22555309,
    'BWI': 22395638,
    'KMG': 22272776,
    'VIE': 21106330,
    'OSL': 21092873,
    'JED': 20929686,
    'BNE': 20589207,
    'SLC': 20440913,
    'DUS': 20339466,
    'BOG': 20327901,
    'MXP': 19291427,
    'JNB': 19114384,
    'ARN': 19088363,
    'MAN': 18991503,
    'MDW': 18882549,
    'DCA': 18811335,
    'BRU': 18756885,
    'DUB': 18735944,
    'GMP': 18513982,
    'DOH': 18202649,
    'STN': 18046777,
    'HGH': 17512034,
    'CJU': 17202278,
    'YVR': 17193080,
    'TXL': 16919820,
    'SAN': 16836027,
    'TPA': 16732051,
    'CGH': 16687731,
    'BSB': 15801122,
    'CTS': 15773073,
    'XMN': 15753183,
    'RUH': 15432950,
    'FUK': 15431078,
    'GIG': 15184350,
    'HEL': 14851675,
    'LIS': 14791260,
    'ATH': 14428032,
    'AKL': 14012329
}

# This table is way out of date

# AIRPORTS_BY_TRAFFIC = {
#     'KORD': 22405169,
#     'KLAX': 19277993,
#     'KATL': 18875521,
#     'KDFW': 16960080,
#     'KDEN': 14986578,
#     'KJFK': 14589720,
#     'KSFO': 14404066,
#     'CYYZ': 13363885,
#     'KIAH': 12486942,
#     'KEWR': 12326042,
#     'KLAS': 11143903,
#     'KMSP': 10648361,
#     'KPHX': 10624131,
#     'KSEA': 10577917,
#     'KBOS': 9904351,
#     'KCLT': 9777612,
#     'KPHL': 9542238,
#     'KDTW': 8814890,
#     'KIAD': 8160699,
#     'KLGA': 7910672,
#     'KMCO': 7461919,
#     'KMIA': 7415137,
#     'CYVR': 6603692,
#     'KSLC': 6444486,
#     'KMDW': 6319569,
#     'KDCA': 5755285,
#     'CYYC': 5534898,
#     'KMEM': 5507394,
#     'KBWI': 5504522,
#     'KFLL': 5461097,
#     'CYUL': 5298952,
#     'PANC': 5042085,
#     'KPDX': 4975790,
#     'KSAN': 4945769,
#     'EGLL': 4670244,
#     'KSTL': 3902312,
#     'KHOU': 3834450,
#     'KTPA': 3827526,
#     'KAUS': 3501936,
#     'KSDF': 3351449,
#     'KBNA': 3342296,
#     'KCLE': 3328543,
#     'KIND': 3265307,
#     'KOAK': 3230202,
#     'KCVG': 3111856,
#     'KMCI': 3008158,
#     'KSNA': 2972294,
#     'KSAT': 2957611,
#     'CYEG': 2900793,
#     'KTEB': 2856924,
#     'KSJC': 2841719,
#     'KRDU': 2800969,
#     'KMSY': 2612098,
#     'KMKE': 2479567,
#     'KPIT': 2443671,
#     'KDAL': 2429477,
#     'KCMH': 2359466,
#     'LFPG': 2280236,
#     'EDDF': 2170904,
#     'KSMF': 2170397,
#     'CYWG': 2055917,
#     'CYOW': 2001723,
#     'TJSJ': 1989440,
#     'KHPN': 1933760,
#     'KBDL': 1884239,
#     'KPBI': 1870671,
#     'KABQ': 1863878,
#     'KOMA': 1847169,
#     'RJAA': 1807235,
#     'EHAM': 1749521,
#     'MMMX': 1701420,
#     'CYHZ': 1691695,
#     'PHNL': 1585369,
#     'KBUF': 1580011,
#     'MMUN': 1520578,
#     'KBUR': 1502774,
#     'KJAX': 1498922,
#     'KRSW': 1485708,
#     'KOKC': 1405620,
#     'KONT': 1397297,
#     'KAPA': 1379267,
#     'KBHM': 1319024,
#     'KTUL': 1281483,
#     'KICT': 1246604,
#     'KRIC': 1230306,
#     'RKSI': 1227637,
#     'KBFI': 1211560,
#     'KELP': 1208635,
#     'KDSM': 1169303,
#     'KTUS': 1167125,
#     'KRNO': 1164184,
#     'KPVD': 1158230,
#     'KORF': 1151028,
#     'KBOI': 1136850,
#     'KLGB': 1111835,
#     'KCHS': 1094668,
#     'KLIT': 1065312,
#     'CYTZ': 1049182,
#     'KGRR': 1019423,
#     'KPDK': 1005510,
#     'KTYS': 1005055,
#     'KVNY': 997542,
#     'KALB': 980906,
#     'KSBA': 964061,
#     'KDAY': 949378,
#     'KROC': 925141,
#     'CYQB': 923046,
#     'CYYT': 898109,
#     'KSAV': 897674,
#     'KGEG': 886856,
#     'VHHH': 883149,
#     'KMHT': 880708,
#     'MYNN': 851211,
#     'KSYR': 839623,
#     'KGSO': 819881,
#     'KMSN': 811186,
#     'ZSPD': 807573,
#     'KLEX': 796277,
#     'KSUS': 794551,
#     'KBED': 776372,
#     'KADS': 774063,
#     'KCOS': 768848,
#     'KPWK': 761765,
#     'KFSD': 759145,
#     'KPWM': 747078,
#     'CYXE': 734288,
#     'ZBAA': 714841,
#     'KCAK': 679713,
#     'KBTR': 664990,
#     'KFAT': 662277,
#     'MDPC': 660375,
#     'KGSP': 646357,
#     'KPTK': 639581,
#     'KPNS': 633628,
#     'EDDM': 626544,
#     'KSFB': 624427,
#     'KASE': 623336,
#     'KFXE': 621781,
#     'LIRF': 621391,
#     'KCID': 616845,
#     'KMAF': 608637,
#     'KFAR': 603810,
#     'KBIL': 596796,
#     'KXNA': 590294,
#     'KMDT': 589966,
#     'KBTV': 586818,
#     'KMRY': 584216,
#     'LSZH': 582886,
#     'KCAE': 576597,
#     'EIDW': 573033,
#     'KSRQ': 562920,
#     'KMKC': 560573,
#     'CYQR': 560407,
#     'KPSP': 554884,
#     'KSDL': 549790,
#     'MKJS': 544511,
#     'KLBB': 541454,
#     'CYHM': 539897,
#     'KLUK': 536479,
#     'KOPF': 534389,
#     'LEMD': 533602,
#     'KACK': 527452,
#     'KSGF': 523494,
#     'CYQT': 522679,
#     'KBZN': 522130,
#     'KDTS': 519355,
#     'KRAP': 516457,
#     'KSGR': 512735,
#     'CYLW': 511254,
#     'KFTW': 503228,
#     'KCRQ': 501829,
#     'CYMM': 498751,
#     'KHSV': 496775,
#     'KAVL': 487168,
#     'KBGR': 475855,
#     'RCTP': 473251,
#     'KISP': 472644,
#     'CYQM': 471740,
#     'KGFK': 470721,
#     'KJAN': 467781,
#     'BIKF': 465344,
#     'KMMU': 463465,
#     'KJAC': 463339,
#     'KSHV': 461164,
#     'PAFA': 460837,
#     'MDSD': 460293,
#     'KCHA': 459487,
#     'KDWH': 458954,
#     'EGCC': 457359,
#     'CYYJ': 456201,
#     'KSMO': 454675,
#     'OMDB': 453282,
#     'KAMA': 451920,
#     'KMYR': 450956,
#     'KTLH': 448751,
#     'MMGL': 444441,
#     'KLFT': 443949,
#     'KPIE': 441571,
#     'KAPF': 440561,
#     'PHOG': 439551,
#     'EBBR': 428746,
#     'KEUG': 420697,
#     'KMLI': 420298,
#     'KIWA': 416139,
#     'KBJC': 409240,
#     'KSBN': 409236,
#     'KDPA': 407783,
#     'KNEW': 405514,
#     'SBGR': 402669,
#     'KCRW': 402153,
#     'KLNK': 401929,
#     'KMSO': 400206,
#     'KLRD': 399684,
#     'KORL': 397266,
#     'KDAB': 396657,
#     'KILM': 396301,
#     'KABE': 393440,
#     'KSBP': 393059,
#     'KFWA': 387510,
#     'KPIA': 386388,
#     'KMFR': 384964,
#     'KCRP': 383816,
#     'KBFL': 382908,
#     'KHIO': 379674,
#     'KTVC': 378747,
#     'KSAF': 376992,
#     'KGRB': 376570,
#     'KMFE': 374571,
#     'KBLI': 373986,
#     'KSTP': 373925,
#     'MPTO': 373905,
#     'KEYW': 373523,
#     'RJTT': 372480,
#     'KPWA': 369423,
#     'KGJT': 366912,
#     'KACY': 366000,
#     'KHEF': 365729,
#     'KFCM': 362662,
#     'KRST': 361372,
#     'EGKK': 361202,
#     'KGPT': 359260,
#     'LTBA': 357894,
#     'KEGE': 356801,
#     'KRFD': 355496,
#     'KFTY': 350436,
#     'KTMB': 350073,
#     'KROA': 348431,
#     'KSTS': 344707,
#     'SKBO': 341206,
#     'KFRG': 340369,
#     'KBIS': 339887,
#     'KGTF': 338381,
#     'KATW': 333729,
#     'KPHF': 333042,
#     'KPSC': 326348,
#     'EDDL': 324598,
#     'KCHO': 323923,
#     'PHKO': 321050,
#     'KGNV': 317654,
#     'KBCT': 317163,
#     'KGPI': 316236,
#     'MMSD': 314261,
#     'LLBG': 313842,
#     'KISN': 311589,
#     'KMOB': 310239,
#     'KFPR': 308193,
#     'KMYF': 305150,
#     'KYIP': 305063,
#     'KEVV': 303800,
#     'KSUN': 302961,
#     'KAPC': 302774,
#     'KLZU': 300016,
#     'KMOT': 295122,
#     'KMVY': 293947,
#     'KAFW': 292607,
#     'KFNT': 290129,
#     'KOSU': 289687,
#     'SVMI': 289025,
#     'KDLH': 284915,
#     'TIST': 284763,
#     'MSLP': 280796,
#     'CYFC': 277916,
#     'MMMY': 276516,
#     'KCPS': 273297,
#     'KCRG': 272199,
#     'UUEE': 271857,
#     'KVPS': 270500,
#     'KTTN': 269181,
#     'KCPR': 265112,
#     'KAGC': 264483,
#     'KAGS': 263898,
#     'KJWN': 262910,
#     'KANE': 258695,
#     'KUGN': 257285,
#     'KMLB': 257107,
#     'TTPP': 256840,
#     'EKCH': 256690,
#     'KJQF': 256628,
#     'EINN': 256290,
#     'KCMA': 255811,
#     'CYHU': 255136,
#     'KMLU': 254170,
#     'KLAN': 250904,
#     'KCLL': 248722,
#     'PAJN': 248385,
#     'KISM': 248286,
#     'KRVS': 247447,
#     'KECP': 247301,
#     'CYXU': 246486,
#     'KRDM': 246313,
#     'KAVP': 246020,
#     'KDTO': 245597,
#     'KSWF': 244671,
#     'CYYR': 242994,
#     'KHUM': 241103,
#     'KHXD': 241021,
#     'TNCA': 240621,
#     'KMGM': 239678,
#     'CYFB': 237616,
#     'KPAE': 236154,
#     'KBMI': 235343,
#     'KVRB': 235326,
#     'TNCM': 233235,
#     'KSLN': 232592,
#     'MBPV': 232526,
#     'MDST': 232520,
#     'CYZV': 231937,
#     'CYDF': 230607,
#     'KTRI': 230318,
#     'MROC': 229200,
#     'KEFD': 228814,
#     'MUVT': 227731,
#     'KFMY': 227418,
#     'KILG': 227307,
#     'KJKA': 227266,
#     'KMQY': 225806,
#     'KLOU': 224259,
#     'KFAY': 224221,
#     'TXKF': 223804,
#     'KHRL': 222074,
#     'KRYY': 219774,
#     'RJBB': 218708,
#     'KFOK': 218385,
#     'KDRO': 216161,
#     'KPNE': 214553,
#     'KSSI': 213082,
#     'KMHR': 211903,
#     'KOJC': 211571,
#     'KIXD': 210242,
#     'CYSJ': 210009,
#     'KAAO': 209711,
#     'KBRO': 209094,
#     'CYYG': 207392,
#     'KAEX': 204998,
#     'KIWS': 204997,
#     'KPUB': 204358,
#     'PHLI': 204246,
#     'MTPP': 203958,
#     'MUVR': 203699,
#     'CYZF': 203419,
#     'MYAM': 202122,
#     'KSPI': 201429,
#     'PGUM': 200751,
#     'KTOL': 200469,
#     'KELM': 199683,
#     'KTYR': 199330,
#     'MKJP': 197782,
#     'CYTS': 197567,
#     'KNYL': 196639,
#     'KABI': 195975,
#     'KHYA': 195602,
#     'KGGG': 195481,
#     'KAZO': 194632,
#     'KJYO': 194525,
#     'CYSB': 194171,
#     'CYAM': 193560,
#     'KIDA': 193330,
#     'KHWD': 193131,
#     'TJBQ': 191969,
#     'KSUA': 189421,
#     'OTBD': 189280,
#     'KROG': 189272,
#     'KUES': 188812,
#     'KDVT': 188181,
#     'KVGT': 186447,
#     'MMPR': 185923,
#     'CYQU': 185465,
#     'KGAI': 185402,
#     'KGYY': 184954,
#     'MUHA': 183716,
#     'CYXS': 181029,
#     'KFSM': 180929,
#     'CYMX': 180236,
#     'KOLV': 180203,
#     'PHTO': 179451,
#     'KPSM': 178632,
#     'KGKY': 178558,
#     'KSGJ': 174825,
#     'LEBL': 174629,
#     'KDTN': 174401,
#     'CYKF': 174284,
#     'KSMX': 173941,
#     'KMBS': 173598,
#     'KCSG': 173572,
#     'KBKL': 173482,
#     'CYTH': 173417,
#     'KCGF': 172528,
#     'KCMI': 171703,
#     'PAKT': 171608,
#     'KMTN': 171161,
#     'KARR': 167546,
#     'KLBE': 167152,
#     'YSSY': 164970,
#     'KCXO': 164717,
#     'SPIM': 164515,
#     'LIMC': 164056,
#     'KBFM': 163271,
#     'KDIK': 162871,
#     'CYXJ': 162574,
#     'KOSH': 162555,
#     'CYQX': 162056,
#     'CYQG': 161867,
#     'ESSA': 159459,
#     'KHTO': 159283,
#     'SBGL': 159246,
#     'KBHB': 159242,
#     'KOCF': 159098,
#     'MWCR': 157955,
#     'KRDD': 156429,
#     'KCOU': 156313,
#     'KLCK': 156199,
#     'KCOE': 156079,
#     'KPLN': 155962,
#     'KLBF': 155827,
#     'CYXL': 155582,
#     'KLEB': 154910,
#     'KSJT': 153774,
#     'KEWN': 152490,
#     'TBPB': 152021,
#     'KMEI': 151592,
#     'KPIR': 151518,
#     'KLSE': 151190,
#     'KGTU': 150933,
#     'KHLN': 150467,
#     'EDDK': 149790,
#     'KBPT': 149643,
#     'KITH': 148251,
#     'KGMU': 148112,
#     'EPWA': 147049,
#     'KJZI': 145955,
#     'KTKI': 145856,
#     'KHYI': 145698,
#     'KEYE': 145444,
#     'KGON': 144912,
#     'KERI': 143447,
#     'KPBG': 142832,
#     'KTCL': 142762,
#     'KSAC': 142366,
#     'KHND': 142336,
#     'RJGG': 141162,
#     'VIDP': 139889,
#     'MGGT': 139703,
#     'KSVH': 139527,
#     'KOTH': 138417,
#     'KBWG': 138288,
#     'KUAO': 138174,
#     'KAHN': 138130,
#     'KHTS': 137747,
#     'KLWB': 137558,
#     'KGRI': 136821,
#     'KCYS': 136118,
#     'ELLX': 136062,
#     'CYWK': 135983,
#     'KFMN': 135964,
#     'KDBQ': 135939,
#     'KOAJ': 135418,
#     'CYKA': 134377,
#     'LSGG': 134343,
#     'KINT': 134321,
#     'CYXD': 134097,
#     'KOWD': 133821,
#     'KACT': 133363,
#     'CYKZ': 133287,
#     'KMHK': 132960,
#     'KEAU': 132485,
#     'KACV': 132438,
#     'CYQY': 132219,
#     'CYPA': 130995,
#     'KBUY': 130454,
#     'KCWA': 130282,
#     'KIAG': 130236,
#     'KSEE': 130050,
#     'CYXT': 129268,
#     'KDHN': 128978,
#     'ESNN': 128518,
#     'KBDR': 128121,
#     'KLVK': 127195,
#     'EDDT': 127130,
#     'OMAA': 127040,
#     'KGRK': 126937,
#     'KLYH': 126777,
#     'KEVB': 126400,
#     'MYGF': 125718,
#     'EGPF': 125535,
#     'KDET': 125438,
#     'KSBM': 125287,
#     'KFNL': 125101,
#     'KMCN': 125013,
#     'LOWW': 124883,
#     'KLAL': 124740,
#     'KGCK': 123868,
#     'KHVN': 123494,
#     'KSGU': 123047,
#     'KSUX': 122747,
#     'KTUP': 122324,
#     'KTYQ': 122267,
#     'KRKS': 122198,
#     'KTRM': 122163,
#     'KBMG': 121759,
#     'KRBD': 121753,
#     'KMGY': 120467,
#     'EGSS': 119254,
#     'KJBR': 119186,
#     'SCEL': 118976,
#     'CYXX': 118463,
#     'KVIS': 118293,
#     'KPGA': 118251,
#     'KPVU': 117259,
#     'KDEC': 116971,
#     'KLCH': 116110,
#     'KTWF': 114925,
#     'KSBY': 114600,
#     'KBGM': 114582,
#     'KUNV': 114350,
#     'KCNO': 113671,
#     'PABE': 113013,
#     'KLNS': 112990,
#     'KJLN': 112968,
#     'LFPO': 112669,
#     'KIKV': 112026,
#     'KMTJ': 111893,
#     'KMTH': 111800,
#     'KRNT': 111259,
#     'KHDC': 111166,
#     'KGUC': 110906,
#     'KHFD': 109744,
#     'KPGD': 109430,
#     'SAEZ': 109293,
#     'KFDK': 109059,
#     'KJVY': 108983,
#     'KSHR': 108689,
#     'KABR': 108097,
#     'KFLG': 108081,
#     'KHAO': 107261,
#     'KMQJ': 107128,
#     'KHDN': 107028,
#     'KRDG': 107024,
#     'CYYB': 106949,
#     'KEAR': 106372,
#     'KROW': 106187,
#     'KLOT': 106085,
#     'KPRC': 105111,
#     'KMKG': 104808,
#     'KPKB': 104506,
#     'TAPA': 104417,
#     'KLBL': 104164,
#     'KTRK': 103972,
#     'KOXC': 103833,
#     'CYUY': 103570,
#     'KYNG': 102517,
#     'KMKL': 102337,
#     'KOWB': 102149,
#     'KTEX': 101830,
#     'KCCR': 100509,
#     'KHOT': 100453,
#     'KTXK': 100278,
#     'MMLO': 99953,
#     'KHKY': 99614,
#     'CYGK': 99578,
#     'KSLK': 99227,
#     'KJEF': 98942,
#     'KGCC': 98843,
#     'KVLD': 98787,
#     'CYBW': 98092,
#     'KHGR': 97836,
#     'KTOA': 97613,
#     'KBFF': 97568,
#     'KPAH': 96704,
#     'KCDW': 96448,
#     'KTTD': 96358,
#     'ENGM': 95939,
#     'KYKM': 95857,
#     'KSCK': 95206,
#     'MUSC': 94221,
#     'KBTL': 93961,
#     'KALO': 93578,
#     'CYVP': 93556,
#     'KASG': 93035,
#     'KUIN': 92622,
#     'KDNL': 92523,
#     'KCRE': 92393,
#     'KSTC': 91828,
#     'EGGW': 91726,
#     'KMBO': 91448,
#     'KLMT': 91437,
#     'KVDF': 91284,
#     'KBRD': 91242,
#     'KLWS': 91236,
#     'KRKD': 91146,
#     'KBLM': 90974,
#     'KDDC': 90751,
#     'PAKN': 90515,
#     'LIPZ': 90234,
#     'KBBG': 89287,
#     'UUDD': 89180,
#     'KCGI': 89143,
#     'PASI': 88492,
#     'MDPP': 88278,
#     'KCOD': 88219,
#     'TISX': 88217,
#     'PASC': 87864,
#     'CAL4': 87830,
#     'KABY': 87818,
#     'KMOD': 87505,
#     'KFFZ': 87497,
#     'KBKW': 87350,
#     'KIPT': 87308,
#     'VABB': 87244,
#     'KHKS': 87124,
#     'KMDD': 87036,
#     'KMQI': 87013,
#     'KSOP': 86980,
#     'LPPT': 86653,
#     'KASH': 86169,
#     'KGVL': 85852,
#     'CYGR': 85772,
#     'KART': 85572,
#     'KARV': 84611,
#     'KBAK': 84456,
#     'KCVX': 84145,
#     'TLPL': 84137,
#     'KMGW': 83516,
#     'KFCI': 83079,
#     'CYQQ': 82993,
#     'CYBG': 82787,
#     'KENW': 82703,
#     'CYXY': 82545,
#     'KBAF': 82525,
#     'KOUN': 82137,
#     'KIMT': 81834,
#     'KPGV': 81687,
#     'KSDM': 81635,
#     'EDDP': 81632,
#     'KLAF': 81437,
#     'KAIK': 81433,
#     'KUMP': 81207,
#     'KOGD': 80823,
#     'KFYV': 80705,
#     'KRIL': 80674,
#     'MRLB': 80636,
#     'CYXC': 80575,
#     'TNCC': 80440,
#     'KLCI': 80398,
#     'KAUO': 79818,
#     'KIOW': 78993,
#     'KTVF': 78876,
#     'KHYS': 78727,
#     'KMCC': 78427,
#     'KHUT': 78248,
#     'KGTR': 78174,
#     'KERV': 78031,
#     'KRHV': 77502,
#     'KEKM': 77433,
#     'KBIV': 77387,
#     'KOXR': 77057,
#     'KESN': 76580,
#     'KMWA': 76470,
#     'OJAI': 76107,
#     'KIFP': 76103,
#     'KMBT': 76047,
#     'KMDQ': 75995,
#     'KELD': 75902,
#     'KDVN': 75794,
#     'CYVO': 75715,
#     'MYEF': 75543,
#     'KGLS': 75115,
#     'KSNS': 75051,
#     'CYQF': 75022,
#     'KBVY': 74934,
#     'MMQT': 74910,
#     'CYQL': 74794,
#     'CYGL': 74772,
#     'NZAA': 74464,
#     'KDKX': 74170,
#     'KFFC': 74169,
#     'KEKO': 74111,
#     'KPQI': 74023,
#     'KDXR': 73914,
#     'KCXY': 73861,
#     'KMLE': 73755,
#     'KLEE': 73722,
#     'KSLE': 73640,
#     'KALN': 73632,
#     'KFWS': 73623,
#     'KRAL': 73491,
#     'KARB': 73462,
#     'KAIZ': 73416,
#     'KBRL': 73089,
#     'KWDG': 72883,
#     'KVPZ': 72747,
#     'KMQS': 72565,
#     'EDDS': 72507,
#     'RPLL': 71996,
#     'KFLO': 71898,
#     'MYEH': 71770,
#     'LGAV': 71737,
#     'KCKB': 71266,
#     'KSHD': 71211,
#     'MHLM': 70985,
#     'KMWC': 70918,
#     'KUOX': 70685,
#     'MMTO': 70647,
#     'EGPH': 70576,
#     'KVNC': 70346,
#     'KMWH': 70180,
#     'KRIW': 70118,
#     'KOQU': 70006,
#     'KSPG': 69745,
#     'KEQY': 69735,
#     'KRHI': 69119,
#     'CYXH': 69056,
#     'KCIC': 68460,
#     'LFMN': 68186,
#     'KHUF': 68173,
#     'MYAT': 68008,
#     'KBKV': 67983,
#     'KJVL': 67899,
#     'KMSL': 67891,
#     'EGNX': 67889,
#     'KINL': 67737,
#     'KVCT': 67387,
#     'KWHP': 67375,
#     'KPIH': 67272,
#     'KPIB': 67157,
#     'KHHR': 66970,
#     'KTDW': 66858,
#     'KDRT': 66454,
#     'KGPH': 65963,
#     'KSSF': 65582,
#     'KSQL': 65379,
#     'KEWB': 65212,
#     'KSAW': 65178,
#     'CYYY': 64813,
#     'KFTG': 64665,
#     'EFHK': 64202,
#     'CYVC': 64182,
#     'KCMX': 64170,
#     'KBTM': 64032,
#     'MNMG': 63991,
#     'KLOM': 63927,
#     'LTFJ': 63682,
#     'MZBZ': 63157,
#     'TKPK': 62994,
#     'KLWM': 62917,
#     'KEAT': 62770,
#     'KHPY': 62672,
#     'KMFD': 62403,
#     'CYMT': 62378,
#     'KPMP': 62343,
#     'KAFJ': 62291,
#     'KTPL': 61884,
#     'KIPL': 61799,
#     'KLAW': 61288,
#     'KCEC': 61074,
#     'KBJI': 60884,
#     'PADL': 60804,
#     'KGKT': 60796,
#     'MUHG': 60758,
#     'CZMT': 60712,
#     'CZBF': 60625,
#     'CYKL': 60562,
#     'PABR': 60475,
#     'KBQK': 60399,
#     'CYRL': 60157,
#     'KBAZ': 59800,
#     'KIRK': 59771,
#     'KSDY': 59603,
#     'KMER': 59601,
#     'SEGU': 59580,
#     'KFME': 59189,
#     'KCCO': 59061,
#     'UUWW': 59042,
#     'KLUL': 58671,
#     'PAOT': 58653,
#     'KODO': 58476,
#     'KSFF': 58290,
#     'KGXY': 58215,
#     'KOMN': 58193,
#     'KLXT': 58120,
#     'CYPR': 57788,
#     'CYRT': 57768,
#     'KMCK': 57594,
#     'KHNB': 57463,
#     'MUCC': 57270,
#     'KSPS': 57117,
#     'KFHR': 57067,
#     'SEQM': 56950,
#     'KOLM': 56933,
#     'KJHW': 56920,
#     'KTBN': 56822,
#     'KAEG': 56655,
#     'CYZT': 56506,
#     'CYBL': 56492,
#     'KSCH': 56386,
#     'KDMW': 56350,
#     'MDLR': 56281,
#     'KEDC': 56180,
#     'KAND': 56133,
#     'CFG6': 56128,
#     'KMIE': 56124,
#     'KTVI': 56027,
#     'KSRR': 55817,
#     'KMKT': 55566,
#     'KSPA': 55564,
#     'KRUT': 55549,
#     'WSSS': 55480,
#     'KRSN': 55348,
#     'KPUW': 55178,
#     'KCBF': 55157,
#     'KTNX': 55106,
#     'KTZR': 55085,
#     'KRME': 55005,
#     'KJST': 54988,
#     'KCPK': 54766,
#     'MMAN': 54672,
#     'KGYH': 54581,
#     'KATY': 54341,
#     'KLAR': 54248,
#     'KESC': 54232,
#     'KHOB': 54041,
#     'KJMS': 54033,
#     'CYYD': 53947,
#     'KMCD': 53682,
#     'KEET': 53642,
#     'KHQZ': 53626,
#     'OKBK': 53586,
#     '7FL6': 53348,
#     'KMCW': 52990,
#     'KTIX': 52971,
#     'EGBB': 52935,
#     'KAWM': 52902,
#     'CYBC': 52847,
#     'KOKV': 52727,
#     'PADQ': 52676,
#     'CET2': 52452,
#     'KLBX': 52330,
#     'CYNR': 51987,
#     'KVQQ': 51954,
#     'KFUL': 51952,
#     'KCHD': 51829,
#     'KCDC': 51799,
#     'KSTJ': 51754,
#     'KTPF': 51706,
#     'CYWL': 51624,
#     'PGSN': 51348,
#     'CYAG': 51313,
#     'SKRG': 51261,
#     'KEKA': 51191,
#     'KALS': 50950,
#     'KFMH': 50716,
#     'KCNY': 50629,
#     'KVEL': 50593,
#     'KFOE': 50537,
#     'KORH': 50271,
#     'MMHO': 50264,
#     'KTVL': 50176,
#     'KEKY': 50075,
#     'KLNA': 49965,
#     'KUZA': 49786,
#     'KSRC': 49725,
#     'CYCD': 49531,
#     'MMCU': 49364,
#     'TJPS': 49349,
#     'KBEC': 49121,
#     'KADM': 49114,
#     'KFLD': 49064,
#     'KSWO': 48905,
#     'KPOU': 48814,
#     'CYMO': 48620,
#     'KFFT': 48598,
#     'KPOC': 48544,
#     'KPSF': 48541,
#     'CYQK': 48476,
#     'KCEU': 48424,
#     'KRMG': 48395,
#     'KTHV': 48386,
#     'MMCZ': 48384,
#     'KHRO': 48221,
#     'KOFK': 48216,
#     'LFPB': 47451,
#     'CYYE': 47285,
#     'KBTP': 47285,
#     'KGLR': 47220,
#     'KHON': 47096,
#     'KTIW': 47049,
#     'CZBB': 46976,
#     'KCWS': 46729,
#     'KCVO': 46719,
#     'KHWO': 46335,
#     'KCWF': 46212,
#     'CYPE': 45985,
#     'KDZB': 45860,
#     'KTME': 45850,
#     'KPRB': 45586,
#     'LFAC': 45299,
#     'KOFP': 44927,
#     'SBBR': 44919,
#     'KGED': 44883,
#     'GMMN': 44706,
#     'KNQA': 44683,
#     'HESN': 44507,
#     'KGFL': 44453,
#     'KCLM': 44404,
#     'KAMW': 44373,
#     'MKPS': 44329,
#     'KAPN': 44174,
#     'ZGGG': 44080,
#     'KGBD': 43913,
#     'KPWT': 43846,
#     'KFOD': 43796,
#     'KGSH': 43766,
#     'KEGV': 43668,
#     '7LS3': 43540,
#     'KGGE': 43456,
#     'MMMM': 43452,
#     'KNUQ': 43447,
#     'KBEH': 43099,
#     'DNMM': 43097,
#     'CYYQ': 42936,
#     'KVPC': 42897,
#     'KFDY': 42637,
#     'KBVS': 42622,
#     'KCNM': 42541,
#     'KLPR': 42489,
#     'KAOO': 42458,
#     'KPMD': 42457,
#     'LGEE': 42285,
#     'KAUG': 42010,
#     'MMAS': 41958,
#     'KCVN': 41890,
#     'KCEZ': 41757,
#     'KSUE': 41746,
#     'KHFY': 41716,
#     'KVJI': 41668,
#     'KDVO': 41393,
#     'TJIG': 41287,
#     'KMIC': 41251,
#     'CYGP': 41222,
#     'TUPJ': 41186,
#     'KPDT': 41178,
#     'KMRH': 41142,
#     'KHYR': 41117,
#     'KMMH': 41043,
#     'KSGH': 40898,
#     'CYDQ': 40836,
#     'KALW': 40781,
#     'KPHN': 40765,
#     'KOXB': 40744,
#     'CYOO': 40608,
#     'KCOI': 40569,
#     'KRBG': 40560,
#     'KEEN': 40463,
#     'KMGN': 40443,
#     'OIGG': 40346,
#     'KWYS': 40323,
#     'KTOP': 39986,
#     'KAXH': 39907,
#     'CYYF': 39738,
#     'KLNN': 39555,
#     'KSOW': 39519,
#     'KCIU': 39503,
#     'KDIJ': 39404,
#     'KDLL': 39290,
#     'CYVB': 39206,
#     'CYLL': 39196,
#     'KDVL': 39161,
#     'MMSP': 39124,
#     'FTTD': 39037,
#     'KOGS': 39003,
#     'KJXN': 38989,
#     'KBPK': 38877,
#     'KDCU': 38794,
#     'KLPC': 38683,
#     'KLFK': 38555,
#     'KWVI': 38396,
#     'KSPW': 38252,
#     'KLOZ': 38108,
#     'KSNY': 38022,
#     'KMML': 38004,
#     'KBOW': 37970,
#     'KMEV': 37908,
#     'KMKY': 37766,
#     'KCTJ': 37648,
#     'KMSS': 37569,
#     'KSAA': 37531,
#     'KLWC': 37428,
#     'KLVN': 37423,
#     'KEMT': 37272,
#     'KRAC': 37270,
#     'KTKX': 37142,
#     'KHFJ': 37134,
#     'KMDH': 37104,
#     'KCXP': 37006,
#     '07FA': 36893,
#     'KDOV': 36798,
#     'KARA': 36756,
#     'KSTE': 36742,
#     'KWWR': 36655,
#     'KVCB': 36599,
#     'KBVO': 36497,
#     'KLEW': 36380,
#     'CYGV': 36343,
#     'KBVI': 36259,
#     'KSGS': 36064,
#     'KDHT': 35947,
#     'KDUJ': 35937,
#     'KCEW': 35694,
#     'CYFO': 35676,
#     'EDDH': 35530,
#     'KVCV': 35433,
#     'KWRI': 35283,
#     'KGUP': 35282,
#     'KUDD': 35133,
#     'KMYL': 35080,
#     'EDFH': 35079,
#     'KLGC': 35067,
#     'KDVK': 35031,
#     'CYZD': 34928,
#     'KHBG': 34922,
#     'KSUT': 34918,
#     'KCUB': 34880,
#     'OEJN': 34811,
#     'KDED': 34784,
#     'ETAR': 34740,
#     'KLRU': 34700,
#     'KVBT': 34625,
#     'KCPC': 34612,
#     'KSKX': 34587,
#     'KWWD': 34546,
#     'KALX': 34449,
#     'YSRI': 34406,
#     'EGAA': 34366,
#     'HECA': 34277,
#     'KASW': 34204,
#     'PAGA': 34197,
#     'KSMD': 34180,
#     'PAEN': 34025,
#     'KGLH': 34013,
#     'KRUQ': 33992,
#     'CYZP': 33929,
#     'KIGM': 33892,
#     'KNTU': 33773,
#     'CYQA': 33751,
#     'KSIK': 33741,
#     'KCQF': 33583,
#     'KDLZ': 33569,
#     'KMZZ': 33433,
#     'KFKL': 33384,
#     'KSFZ': 33345,
#     'UKLN': 33281,
#     'KFHB': 33202,
#     'KAXN': 33083,
#     'KLCQ': 33046,
#     'KLGU': 33034,
#     'KSBD': 32995,
#     'ZGSZ': 32987,
#     'MMVR': 32876,
#     'CYHD': 32862,
#     'KILE': 32735,
#     'KGUY': 32721,
#     'LS08': 32665,
#     'KMWL': 32658,
#     'PAUN': 32652,
#     'MHTG': 32569,
#     'EGLF': 32567,
#     'CYGW': 32559,
#     'KNZY': 32546,
#     'KMTO': 32529,
#     'KBCB': 32439,
#     'KISO': 32330,
#     'KHSA': 32261,
#     'OIBL': 32227,
#     'CYBF': 32220,
#     'KSBS': 32103,
#     'CYCG': 32061,
#     'DNAK': 32017,
#     'KUTA': 31912,
#     'KGPM': 31793,
#     'PACD': 31776,
#     'KAVQ': 31770,
#     'KSRB': 31706,
#     'KPWG': 31675,
#     'KMCE': 31638,
#     'KPVC': 31613,
#     'KRKP': 31466,
#     'KPLK': 31452,
#     'KOZW': 31391,
#     'KIDP': 31338,
#     'KIOB': 31304,
#     'KRPD': 31254,
#     'EBLG': 31226,
#     'KMBL': 31221,
#     'KRYV': 31198,
#     'KBDN': 31182,
#     'KCON': 31176,
#     'KBJJ': 31081,
#     'CYAZ': 31078,
#     'KTHA': 31068,
#     'KHQU': 30990,
#     'KPTW': 30857,
#     'KGCN': 30813,
#     'KPEA': 30743,
#     'KCTB': 30588,
#     'KZPH': 30511,
#     'KUVA': 30500,
#     'KSPF': 30485,
#     'KSZT': 30190,
#     'CYRC': 30147,
#     'TFFR': 30113,
#     'SKCG': 30009,
#     'CYND': 29904,
#     'KSFM': 29894,
#     'YBBN': 29836,
#     'KGLD': 29821,
#     'TGPY': 29758,
#     'KTBR': 29737,
#     'KHIB': 29716,
#     'KGYR': 29614,
#     'KLDM': 29601,
#     'KCKV': 29530,
#     'KHSD': 29529,
#     'KUNU': 29366,
#     'KBXM': 29291,
#     'ZZZZ': 29223,
#     'HRYG': 29119,
#     'KIWD': 28995,
#     'KHHG': 28993,
#     'KPKD': 28935,
#     'KAUW': 28911,
#     'KMRB': 28870,
#     'KMWO': 28785,
#     'KOLF': 28709,
#     'KPCW': 28657,
#     'KWJF': 28595,
#     'KGIF': 28561,
#     'KBWD': 28543,
#     'KHVC': 28541,
#     'KGEU': 28470,
#     'LEVD': 28411,
#     'KAAF': 28363,
#     'OH22': 28300,
#     'KDTL': 28259,
#     'FAOR': 27977,
#     'KBLH': 27944,
#     'NTAA': 27913,
#     'KCOT': 27912,
#     'KDUA': 27895,
#     'KPBF': 27778,
#     'CYSF': 27765,
#     'PASM': 27706,
#     'MYBS': 27662,
#     'MDCY': 27651,
#     'KFCH': 27570,
#     'KBGD': 27492,
#     'KUKI': 27400,
#     'MMIO': 27279,
#     'KGLE': 27255,
#     'KPNC': 27171,
#     'KEWK': 27160,
#     'NGTU': 27141,
#     'KMLC': 27071,
#     'KJGG': 26960,
#     'TQPF': 26960,
#     'KLBT': 26932,
#     'KMPO': 26911,
#     'PHMK': 26778,
#     'KASL': 26751,
#     'LPPD': 26700,
#     'KNDZ': 26696,
#     'KOKK': 26684,
#     'SYCJ': 26650,
#     'KRWI': 26618,
#     'KPOF': 26565,
#     'KGWO': 26542,
#     'CYZR': 26531,
#     'KEXX': 26501,
#     'CYBX': 26487,
#     'KLQK': 26434,
#     'KETB': 26367,
#     'KMTW': 26334,
#     'KSYI': 26293,
#     'KHLG': 26189,
#     'KECG': 26106,
#     'MMTC': 26078,
#     'KUKF': 26056,
#     'KASD': 25964,
#     'KCDR': 25953,
#     'KMMV': 25941,
#     'KRGK': 25916,
#     'KLHM': 25740,
#     'KMLS': 25720,
#     'MMTJ': 25714,
#     'OERK': 25667,
#     'PAHO': 25529,
#     'GMAT': 25516,
#     'KVTN': 25498,
#     'LPPR': 25479,
#     'KMRN': 25440,
#     'CEL8': 25428,
#     'KIKK': 25422,
#     'KSKY': 25382,
#     'KATS': 25342,
#     'KFET': 25307,
#     'MMPB': 25260,
#     'KCEF': 25212,
#     'KNKT': 25212,
#     'KRRT': 25159,
#     'KMHE': 25053,
#     'MDJB': 24996,
#     'KCGC': 24953,
#     'KGYI': 24938,
#     'KBFD': 24870,
#     'KLVJ': 24770,
#     'CZBA': 24742,
#     'KPQL': 24732,
#     'KDNV': 24663,
#     'KPPA': 24638,
#     'KHEZ': 24534,
#     'PANI': 24435,
#     'CYSN': 24431,
#     'KPYM': 24374,
#     'KGPZ': 24267,
#     'CYHY': 24175,
#     'KVYS': 24114,
#     'KLAA': 24101,
#     'KBLF': 24068,
#     'KPSK': 24036,
#     'KCLW': 24002,
#     'KHMZ': 23948,
#     'KCKM': 23943,
#     'KALM': 23834,
#     'KPVW': 23759,
#     'KBVX': 23746,
#     'KDLN': 23700,
#     'PAIL': 23695,
#     'LGWW': 23695,
#     'KZZV': 23693,
#     'KWST': 23693,
#     'RJFF': 23680,
#     'KTOC': 23660,
#     'KMFI': 23655,
#     'KSTF': 23631,
#     'KBIF': 23621,
#     'KGWW': 23539,
#     'KIER': 23536,
#     'CYYU': 23526,
#     'KDYL': 23476,
#     'KDNN': 23474,
#     'KDUX': 23468,
#     'LKPR': 23455,
#     'KIGX': 23434,
#     'KUNI': 23401,
#     'KLHQ': 23396,
#     'KAKR': 23297,
#     'CYIV': 23261,
#     'LFVP': 23182,
#     'EICK': 23160,
#     'KGVQ': 23135,
#     'CAD4': 23109,
#     'KJNX': 23079,
#     'CYGO': 23044,
#     'KIYK': 23022,
#     'GOOY': 23021,
#     'KMGC': 23003,
#     'SBBH': 22979,
#     'KRNV': 22931,
#     'MUGM': 22874,
#     'FEFR': 22856,
#     'KIGQ': 22753,
#     'KMJX': 22750,
#     'KTDZ': 22737,
#     'KAID': 22682,
#     'KGAD': 22649,
#     'CJW7': 22622,
#     'KSFQ': 22592,
#     'KPRX': 22533,
#     'KOLS': 22470,
#     'KLHZ': 22312,
#     'KCSV': 22289,
#     'KPTS': 22279,
#     'KENV': 22274,
#     'PACV': 22243,
#     'MMMZ': 22235,
#     'KMVN': 22195,
#     'KSVC': 22191,
#     'KIPJ': 22169,
#     'KDMO': 22169,
#     'PAYA': 22093,
#     'KMWK': 22076,
#     'KNGU': 22050,
#     'KANB': 21975,
#     'KORS': 21961,
#     'CYBR': 21915,
#     'KFFM': 21862,
#     'KPLR': 21681,
#     'KAOH': 21681,
#     'KMTV': 21661,
#     'LFML': 21497,
#     'KWDR': 21496,
#     'LRAR': 21492,
#     'CCL3': 21488,
#     'KTMA': 21473,
#     'KAST': 21466,
#     'KCNW': 21392,
#     'TNCB': 21384,
#     'YMML': 21360,
#     'KSME': 21328,
#     'KBLV': 21319,
#     'KMOX': 21269,
#     'KVTA': 21249,
#     'KCTY': 21189,
#     'FSIA': 21149,
#     'KGCM': 21144,
#     'CZSJ': 21103,
#     'KPEO': 21102,
#     'KAUN': 21057,
#     'KAIA': 20919,
#     'CYQD': 20888,
#     'CYNL': 20882,
#     'KPXE': 20844,
#     'KCZT': 20762,
#     'MUCM': 20759,
#     'KOTM': 20733,
#     'KRBW': 20637,
#     'CYSM': 20614,
#     'KVUO': 20601,
#     'KEHR': 20447,
#     'KBMQ': 20405,
#     'KCFD': 20361,
#     'KSUU': 20360,
#     'KDMN': 20316,
#     'KRID': 20274,
#     'KDKB': 20271,
#     'KBMT': 20266,
#     'SGME': 20250,
#     'CNC3': 20197,
#     'CYAV': 20142,
#     'SKCL': 20092,
#     'KMUT': 20056,
#     'KSEG': 20019,
#     'EGPK': 19960,
#     'KRNC': 19919,
#     'CZVL': 19865,
#     'KADH': 19788,
#     'KDBN': 19773,
#     'KPEQ': 19671,
#     'KMGR': 19537,
#     'KTNU': 19510,
#     'KWRL': 19484,
#     'KPIL': 19454,
#     'TFFF': 19353,
#     'KTDF': 19346,
#     'KFIT': 19342,
#     'CYPX': 19301,
#     'KMPV': 19264,
#     'KPCM': 19261,
#     'KYKN': 19242,
#     'KLWT': 19231,
#     'KMAE': 19215,
#     'MYLS': 19187,
#     'CYPY': 19140,
#     'KFQD': 19105,
#     'KPSO': 19064,
#     'KPPO': 19055,
#     'KMLJ': 18927,
#     'CYPQ': 18893,
#     'UHMA': 18820,
#     'KRIV': 18767,
#     'CYVK': 18743,
#     'KSEP': 18684,
#     'CYLS': 18668,
#     'KRQE': 18649,
#     'KUNO': 18633,
#     'KOLU': 18600,
#     'KHMT': 18590,
#     'LFSD': 18553,
#     'KLUF': 18440,
#     'KGBG': 18417,
#     'KONP': 18340,
#     'KCEY': 18286,
#     'CYLB': 18285,
#     'KPCZ': 18266,
#     'KOPN': 18255,
#     'CYQZ': 18234,
#     'KDLS': 18193,
#     'KSZL': 18189,
#     'SBCF': 18188,
#     'KFAM': 18139,
#     'EGQS': 18102,
#     'KCJR': 18023,
#     'CKM8': 18017,
#     'KGRD': 18012,
#     'KBKX': 17981,
#     'KINW': 17936,
#     'EDBT': 17914,
#     'KCBE': 17894,
#     'CYOJ': 17870,
#     'CYST': 17847,
#     'KPOB': 17845,
#     'KPMH': 17837,
#     'CSE4': 17819,
#     'FEFF': 17818,
#     'LFLC': 17774,
#     'KMIV': 17759,
#     'KDKK': 17737,
#     'KASN': 17649,
#     'KBDH': 17635,
#     'KDUC': 17604,
#     'KUCY': 17556,
#     'KCWI': 17501,
#     'KGOK': 17490,
#     'KARG': 17470,
#     'CYEL': 17463,
#     'PASN': 17412,
#     'CBBC': 17373,
#     'KEZM': 17335,
#     'KOXI': 17332,
#     'KLVM': 17322,
#     'KACB': 17314,
#     'KUTS': 17298,
#     'CYPW': 17280,
#     'KMSV': 17231,
#     'KRTN': 17231,
#     'CYNE': 17230,
#     'KSMS': 17220,
#     'CYFD': 17214,
#     'KTVR': 17195,
#     'KPSN': 17183,
#     'KBIE': 17105,
#     'SBKP': 17095,
#     'CYZH': 17088,
#     'KEDN': 17086,
#     'MYAF': 17079,
#     'KMKO': 17005,
#     'CZTM': 17003,
#     'KMOR': 16999,
#     'KMVL': 16937,
#     'KJYR': 16930,
#     'CYCL': 16930,
#     'NFFN': 16913,
#     'CRL4': 16874,
#     'KAYS': 16864,
#     'CYGX': 16836,
#     'KGKJ': 16831,
#     'KSEZ': 16794,
#     'MTCH': 16793,
#     'KPNA': 16782,
#     'MMMD': 16765,
#     'KGWB': 16762,
#     '81XA': 16662,
#     'KAXV': 16626,
#     'KWVL': 16607,
#     'MYAN': 16595,
#     'KPVB': 16582,
#     'KCQX': 16579,
#     'CYRQ': 16574,
#     'CYAY': 16553,
#     'KSJN': 16540,
#     'KLNC': 16537,
#     'KPTN': 16506,
#     'KVIH': 16476,
#     'KEKX': 16454,
#     'KAWO': 16399,
#     'KTOI': 16365,
#     'KASX': 16265,
#     'KIRS': 16237,
#     'KGAO': 16230,
#     'CYTL': 16134,
#     'KRUE': 16110,
#     'CYEN': 16064,
#     'KRNH': 16050,
#     'SBEG': 16026,
#     'KGVT': 16001,
#     'KLKP': 15978,
#     'KCLS': 15942,
#     'KMRC': 15933,
#     'SVVA': 15924,
#     'KHAI': 15911,
#     'KCRX': 15814,
#     'KLLQ': 15763,
#     'KBGE': 15685,
#     'KGCY': 15678,
#     'NTGB': 15635,
#     'RJOM': 15626,
#     '1LA9': 15574,
#     'KEFT': 15567,
#     'KOCH': 15513,
#     'KAUM': 15505,
#     'KRNM': 15466,
#     'KLVS': 15421,
#     'KDCY': 15345,
#     'KELO': 15185,
#     'CYSG': 15144,
#     'KMOP': 15142,
#     'PAMC': 15129,
#     'KJSO': 15124,
#     'KHAE': 15085,
#     'KHBI': 14996,
#     'PASA': 14967,
#     'CEE5': 14937,
#     'KEHO': 14929,
#     'CYTF': 14926,
#     'KELK': 14898,
#     'KJAS': 14878,
#     'KALI': 14830,
#     'KCAD': 14801,
#     'SBRF': 14778,
#     'CYCN': 14654,
#     'KJFX': 14605,
#     'KRBL': 14578,
#     'KSQI': 14576,
#     'CYGT': 14564,
#     'KLDJ': 14523,
#     'CYPN': 14445,
#     'KOXD': 14409,
#     'KROX': 14400,
#     'KFZY': 14363,
#     'KONA': 14346,
#     'KPGR': 14281,
#     'KELY': 14228,
#     'CYSK': 14221,
#     'KAFO': 14161,
#     'KOEO': 14115,
#     'KPTB': 14083,
#     'CYCH': 14079,
#     'KGDV': 14064,
#     'KHZL': 14053,
#     'KTAD': 14038,
#     'KCTK': 14032,
#     'PAED': 14016,
#     'KOGB': 13976,
#     'LFLL': 13957,
#     'KOSA': 13954,
#     'KONZ': 13950,
#     'KMMI': 13920,
#     'KHSP': 13918,
#     'KTRL': 13917,
#     'KGGW': 13872,
#     'PAGM': 13861,
#     'KCAG': 13808,
#     'KFYE': 13796,
#     'KSLG': 13765,
#     'KIWI': 13744,
#     'SVMC': 13732,
#     'KFRM': 13726,
#     'KMQB': 13723,
#     'KMTP': 13698,
#     'KHZY': 13659,
#     'KAJZ': 13646,
#     'CYCR': 13595,
#     'KHBZ': 13580,
#     'KPLD': 13568,
#     'KBYI': 13562,
#     'KJOT': 13473,
#     'KJZP': 13452,
#     'KBNL': 13405,
#     'KANJ': 13401,
#     'KSET': 13315,
#     'KAZE': 13302,
#     'SBSV': 13294,
#     'KDWU': 13293,
#     'KSIY': 13286,
#     'KHVR': 13257,
#     'CA35': 13251,
#     'SKMD': 13249,
#     'FNLU': 13237,
#     'KGMJ': 13229,
#     'FA54': 13204,
#     'CYFJ': 13149,
#     'KDUH': 13134,
#     'KLGD': 13083,
#     'KEUF': 13065,
#     'LPLA': 13043,
#     'ZYTX': 13031,
#     'KCDN': 13028,
#     'KBPG': 13017,
#     'KDRI': 13014,
#     'KELN': 13009,
#     'MMZC': 13008,
#     'KGNF': 13003,
#     'KHAF': 12946,
#     'CYYN': 12913,
#     'KDPL': 12869,
#     'KDAN': 12861,
#     'KFFL': 12855,
#     'KSNH': 12850,
#     'KEDE': 12844,
#     'CYHH': 12841,
#     'KITR': 12841,
#     'KUDG': 12838,
#     'KCGZ': 12814,
#     'PFYU': 12812,
#     'CYXK': 12807,
#     'FZVI': 12799,
#     'ENDU': 12774,
#     'KOSC': 12752,
#     'KSCX': 12748,
#     'CCR3': 12704,
#     'KMCB': 12632,
#     'MYBC': 12610,
#     'KPTD': 12610,
#     'KRLD': 12608,
#     'CYAQ': 12596,
#     'KRMN': 12581,
#     'KVDI': 12525,
#     'MYEM': 12522,
#     'KHRI': 12498,
#     'CZAM': 12488,
#     'KMRF': 12472,
#     'CYJT': 12462,
#     'KPHT': 12424,
#     'MHRO': 12376,
#     'KONL': 12376,
#     'MMZH': 12349,
#     'KCNI': 12302,
#     'KBRY': 12301,
#     'KTCC': 12298,
#     'KEUL': 12275,
#     'KHII': 12272,
#     'KLWV': 12270,
#     'DGAA': 12269,
#     'KBIH': 12095,
#     'CYRP': 12090,
#     'KHQM': 12048,
#     'KSGT': 11974,
#     'MMCE': 11962,
#     'KADW': 11931,
#     'KGEZ': 11920,
#     'KHSI': 11904,
#     'KTQK': 11871,
#     'KOEB': 11871,
#     'CTP9': 11855,
#     'MMTM': 11811,
#     'MMVA': 11796,
#     'KSEF': 11794,
#     'KHDE': 11752,
#     'KLND': 11738,
#     'VNSI': 11736,
#     'BGSF': 11733,
#     'KOTG': 11732,
#     'FACT': 11729,
#     'KISW': 11716,
#     'CYSC': 11709,
#     'KEVW': 11698,
#     'KXFL': 11687,
#     'KDQH': 11680,
#     'KBDE': 11636,
#     'KRZT': 11628,
#     'KMNN': 11627,
#     'KMIW': 11608,
#     'KTTA': 11548,
#     'KDFI': 11522,
#     'KANQ': 11517,
#     'KFLV': 11496,
#     'KAKH': 11486,
#     'KVGC': 11473,
#     'CYET': 11455,
#     'KSUW': 11446,
#     'KUYF': 11421,
#     'KPEZ': 11411,
#     'KAWG': 11316,
#     'KSLR': 11308,
#     'OINR': 11306,
#     'KHRJ': 11288,
#     'KOBE': 11280,
#     'KFYM': 11279,
#     'CYTE': 11264,
#     'KSJX': 11240,
#     'KLNR': 11234,
#     'CYWP': 11223,
#     'KAVX': 11198,
#     'KAMG': 11195,
#     'KSER': 11188,
#     'KFBL': 11182,
#     'LEMG': 11180,
#     'KHSE': 11128,
#     'KNIP': 11127,
#     'CYUX': 11104,
#     'CYPL': 11099,
#     'KILN': 11087,
#     'KEGT': 11071,
#     'CYOH': 11036,
#     'KDYB': 11030,
#     'KHRX': 11019,
#     'KPUC': 11007,
#     'KRZL': 10989,
#     'KPYX': 10988,
#     'KOPL': 10988,
#     'KCXL': 10985,
#     'KVES': 10949,
#     'KFRH': 10944,
#     'TLPC': 10935,
#     'KEVY': 10932,
#     'KANW': 10912,
#     'KPMV': 10896,
#     'CKQ8': 10892,
#     'KMBY': 10874,
#     'KSOY': 10873,
#     'TDPD': 10865,
#     'CSU2': 10854,
#     'KCCB': 10837,
#     'KPRO': 10829,
#     'KLUG': 10819,
#     'KMXO': 10792,
#     'CYRS': 10770,
#     'KHWV': 10755,
#     'KOWX': 10754,
#     'KTEW': 10731,
#     'MMSL': 10722,
#     'KCGE': 10717,
#     'KBUU': 10671,
#     'PAPB': 10622,
#     'MMBT': 10620,
#     'KMGJ': 10596,
#     'KMPE': 10593,
#     'KTSO': 10592,
#     'CYGQ': 10574,
#     'KFHU': 10542,
#     'CZPB': 10514,
#     'KSNK': 10440,
#     'KETN': 10438,
#     'KGGP': 10425,
#     'KMVC': 10368,
#     'KTAZ': 10367,
#     'KIAB': 10339,
#     'KRPH': 10328,
#     'CZRJ': 10325,
#     'EGWU': 10316,
#     'KCRS': 10309,
#     'CYXP': 10308,
#     'KJCT': 10292,
#     'KDDH': 10277,
#     '18AZ': 10271,
#     'KWMC': 10266,
#     'KSTK': 10247,
#     'CER4': 10235,
#     'KLNL': 10227,
#     'KNHK': 10205,
#     'KAJR': 10198,
#     'KAIO': 10191,
#     'CYKQ': 10186,
#     'KIMS': 10175,
#     'KCOQ': 10174,
#     'KTCM': 10149,
#     'KACJ': 10136,
#     'MPMG': 10127,
#     'KHDO': 10117,
#     'KFSW': 10083,
#     'KHQG': 10082,
#     'KMNM': 10062,
#     'CYHF': 10054,
#     'KMFV': 10021,
#     'KVKS': 10020,
#     'KKLS': 10004,
#     'KELZ': 9961,
#     'KVER': 9946,
#     'KMYV': 9937,
#     'KWLD': 9904,
#     'LIRN': 9900,
#     'LTAG': 9891,
#     'KMAW': 9857,
#     'KSNL': 9840,
#     'KCKN': 9826,
#     'KFST': 9815,
#     'KLHW': 9800,
#     'KSMN': 9786,
#     'KCBK': 9785,
#     'LFBO': 9785,
#     'KRYN': 9774,
#     'KCLI': 9771,
#     'KMHL': 9771,
#     'KHSB': 9767,
#     'CYBD': 9765,
#     'KBKD': 9738,
#     'KEKS': 9725,
#     'KVLL': 9711,
#     'CYAT': 9705,
#     'LIRP': 9704,
#     'CYQV': 9685,
#     'KNRN': 9680,
#     'KRWL': 9661,
#     'KEDW': 9648,
#     'KSAD': 9645,
#     'KMMK': 9635,
#     'KEYQ': 9635,
#     'KTPH': 9615,
#     'CYBV': 9610,
#     'CYZG': 9591,
#     'MKPL': 9590,
#     'KIJX': 9585,
#     'KPHD': 9577,
#     'KSKF': 9570,
#     'CYNA': 9567,
#     'KCVC': 9564,
#     'KRXE': 9547,
#     'CZWH': 9540,
#     'MUCL': 9538,
#     'PKMJ': 9491,
#     'KMKV': 9485,
#     'KONX': 9483,
#     'HLLT': 9476,
#     'KMCF': 9469,
#     'CYRO': 9424,
#     'KOKM': 9409,
#     'KHNZ': 9403,
#     'KSPB': 9402,
#     'KPVF': 9391,
#     'KAXS': 9360,
#     'KBDU': 9360,
#     'KOWA': 9345,
#     'CEZ3': 9341,
#     'MYBG': 9285,
#     'KLKU': 9245,
#     'KEOS': 9222,
#     'KRIF': 9222,
#     'KFKR': 9221,
#     'CZGI': 9220,
#     'CJL4': 9212,
#     'KAAS': 9173,
#     'MMLT': 9129,
#     'KRCR': 9119,
#     'KSEM': 9098,
#     'RJCC': 9072,
#     'KADG': 9042,
#     'PAQT': 9035,
#     'KEMP': 9022,
#     'KRWF': 8996,
#     'KHEE': 8991,
#     'KBTA': 8987,
#     'KLXN': 8973,
#     'KTOR': 8970,
#     'KCWC': 8964,
#     'KHHF': 8962,
#     'KUSE': 8958,
#     'KGZS': 8952,
#     'KAJO': 8936,
#     'KBST': 8922,
#     'CYKJ': 8911,
#     'KBAX': 8897,
#     'KAVK': 8889,
#     'CYRJ': 8888,
#     'KMAI': 8882,
#     'KJWY': 8882,
#     'KBTF': 8880,
#     'CYXZ': 8825,
#     'KUUU': 8804,
#     'CJR3': 8775,
#     'KFEP': 8764,
#     'KNLC': 8760,
#     'CYCC': 8748,
#     'KPIM': 8738,
#     'KMNV': 8736,
#     'KEKN': 8734,
#     'KHDI': 8725,
#     'CYCO': 8722,
#     'CYKP': 8720,
#     'KPBH': 8712,
#     'KULS': 8708,
#     'KSLB': 8701,
#     'KBBW': 8690,
#     'KSHL': 8686,
#     'KAGO': 8664,
#     'KPHK': 8641,
#     'FD04': 8635,
#     'KPWC': 8623,
#     'MMOX': 8609,
#     'CYER': 8600,
#     'MUGT': 8590,
#     'KARW': 8585,
#     'KOXV': 8578,
#     'KIZG': 8567,
#     'CYCK': 8556,
#     'CYWM': 8515,
#     'KCIN': 8499,
#     'KFVX': 8475,
#     'KBKE': 8474,
#     'CYPH': 8457,
#     'RJTY': 8455,
#     'KTTF': 8447,
#     'KMIT': 8434,
#     'SKBQ': 8432,
#     'MYSM': 8422,
#     'KLFI': 8418,
#     'CYHR': 8411,
#     'KOJA': 8401,
#     'KVAY': 8396,
#     'KCAV': 8396,
#     'KXVG': 8394,
#     'CYVQ': 8390,
#     'KORG': 8389,
#     'CYZE': 8388,
#     'KVNW': 8385,
#     'EVRA': 8385,
#     'CYXR': 8373,
#     'MYCB': 8362,
#     'KEYF': 8346,
#     'KSAR': 8322,
#     'KPAN': 8320,
#     '79KY': 8306,
#     'CYAH': 8288,
#     'KIDI': 8282,
#     'CYSL': 8275,
#     'KZER': 8274,
#     'KSBO': 8239,
#     'CYPM': 8231,
#     'KHBR': 8215,
#     'KLBO': 8208,
#     'KCQA': 8207,
#     'MUCU': 8206,
#     'CYCB': 8203,
#     'CZUM': 8198,
#     'KVUJ': 8189,
#     'EFHF': 8168,
#     'PHMU': 8162,
#     'KUCP': 8149,
#     'KUUV': 8136,
#     'PADK': 8135,
#     'KLNP': 8135,
#     'KVSF': 8127,
#     'KRKR': 8126,
#     'KGLW': 8116,
#     'CZKE': 8115,
#     'KOQN': 8084,
#     'KLXY': 8057,
#     'KEZZ': 8033,
#     'KBYG': 8010,
#     'KHYX': 8002,
#     'KHZD': 8000,
#     'KPAO': 7995,
#     'CYEK': 7964,
#     'KCNC': 7914,
#     'KRDK': 7871,
#     'KPBX': 7869,
#     'KFFA': 7866,
#     'CYZU': 7866,
#     'KOEL': 7858,
#     'KFTT': 7854,
#     'CFH4': 7829,
#     'KDYR': 7825,
#     'CBC7': 7824,
#     'KBNO': 7808,
#     'KLRO': 7805,
#     'KSMQ': 7801,
#     'KAKO': 7779,
#     'KEOK': 7773,
#     'KHKA': 7760,
#     'KCWV': 7759,
#     'KZEF': 7756,
#     'KMCX': 7717,
#     'CYKC': 7708,
#     'PHJR': 7703,
#     'KMRJ': 7700,
#     'SUMU': 7686,
#     'BIRK': 7677,
#     'CYCY': 7669,
#     'KRSV': 7667,
#     'KVOK': 7663,
#     'CYDL': 7660,
#     'CYBK': 7654,
#     'KMNI': 7644,
#     'KRMY': 7612,
#     'KDRM': 7596,
#     'KOMH': 7592,
#     'KCSM': 7568,
#     '2LS0': 7567,
#     'KIIB': 7566,
#     'MMAA': 7549,
#     'KCZG': 7518,
#     'GE99': 7499,
#     'KDEW': 7443,
#     'KAEL': 7420,
#     'CYIO': 7412,
#     'KCOF': 7401,
#     'KRQB': 7394,
#     'KJAU': 7392,
#     'PHIK': 7381,
#     'KAXA': 7360,
#     'KLCG': 7358,
#     'KPVG': 7356,
#     'CBF7': 7347,
#     'KUBS': 7346,
#     'CSZ4': 7336,
#     'FYLZ': 7333,
#     'KSIV': 7331,
#     'FD38': 7312,
#     'KCDH': 7301,
#     'KORK': 7287,
#     'KGUS': 7286,
#     'CVM2': 7282,
#     'CYDN': 7274,
#     'KESF': 7269,
#     'PAVD': 7268,
#     'MMCL': 7266,
#     'CZBM': 7246,
#     'CYPK': 7226,
#     'KGTB': 7221,
#     'MYER': 7214,
#     'CAT4': 7204,
#     'CYVD': 7200,
#     'KDXE': 7194,
#     'KPTT': 7185,
#     'KAVC': 7185,
#     'LFBD': 7176,
#     'KAHQ': 7174,
#     'KRAS': 7107,
#     'LFRS': 7098,
#     'CYEV': 7097,
#     'SCDA': 7094,
#     'KBKS': 7089,
#     'KHUA': 7088,
#     'KBFA': 7061,
#     'KEZI': 7059,
#     'KPPQ': 7025,
#     'KWAL': 7014,
#     'KISQ': 7002,
#     'KFZG': 6984,
#     'CYAC': 6979,
#     'CYPD': 6960,
#     'CEN4': 6948,
#     'KIWH': 6941,
#     'KOVE': 6932,
#     'KLMS': 6928,
#     'MYIG': 6926,
#     'CTT5': 6923,
#     'KCUH': 6922,
#     'KFLP': 6909,
#     'KDEH': 6906,
#     'KJES': 6906,
#     'KFVE': 6903,
#     'LFSB': 6895,
#     'CYQW': 6889,
#     'CYBT': 6882,
#     'CNM5': 6867,
#     'KCPT': 6861,
#     'EGKB': 6854,
#     'MMDO': 6844,
#     'KCLK': 6833,
#     'KGHG': 6822,
#     'KNTD': 6821,
#     'SLVR': 6815,
#     'KCCY': 6797,
#     'KEBS': 6794,
#     'KHOP': 6771,
#     'KPTV': 6766,
#     'RJSM': 6761,
#     'CFT8': 6742,
#     'ESNG': 6739,
#     'KONO': 6738,
#     'SESA': 6723,
#     'KHCD': 6723,
#     'CNE3': 6718,
#     'ZSQD': 6716,
#     'KGDB': 6712,
#     'KULM': 6694,
#     'CYOP': 6663,
#     'CSF3': 6660,
#     'KCUT': 6659,
#     'SLRB': 6645,
#     'KFOT': 6612,
#     'CYBQ': 6607,
#     'CYLH': 6582,
#     'CEA3': 6568,
#     'KAXQ': 6558,
#     'KSVN': 6553,
#     'KMEZ': 6550,
#     'KICR': 6542,
#     'KPJC': 6534,
#     'KJSV': 6525,
#     '38AZ': 6492,
#     'FCOM': 6491,
#     'KSCD': 6474,
#     'EGNT': 6466,
#     'KBGF': 6462,
#     'KHEG': 6439,
#     'KCDI': 6436,
#     'KCKC': 6429,
#     'KWBW': 6426,
#     'KFSK': 6422,
#     'CYVG': 6409,
#     'AK15': 6364,
#     'DABC': 6358,
#     'KOOA': 6350,
#     'CNK4': 6338,
#     'CYVZ': 6301,
#     'KCTZ': 6301,
#     'KCEK': 6294,
#     'KEKQ': 6292,
#     'KMEB': 6281,
#     'KEDJ': 6280,
#     'PTRO': 6279,
#     'KLTS': 6274,
#     '30GA': 6265,
#     'KBCE': 6260,
#     'CYIF': 6259,
#     'CSR3': 6238,
#     'KCOM': 6222,
#     'KGLY': 6219,
#     'KHJO': 6218,
#     'ZHCC': 6218,
#     'KOGA': 6203,
#     'KMIO': 6200,
#     'KHBV': 6200,
#     'LL22': 6158,
#     'KBID': 6128,
#     'GA04': 6104,
#     'KCZD': 6064,
#     'CYTN': 6045,
#     'CYSA': 6042,
#     'KDWA': 6037,
#     'CYLJ': 6033,
#     'KNKX': 6033,
#     'BGTL': 6019,
#     'KMZJ': 6011,
#     'KTEL': 5999,
#     'KEFK': 5998,
#     'KOLE': 5995,
#     'KFYG': 5992,
#     'KMVE': 5982,
#     'NC06': 5958,
#     'CKL3': 5934,
#     'KCKF': 5931,
#     'CEX3': 5928,
#     'MMMV': 5902,
#     'KOFF': 5899,
#     'BGBW': 5890,
#     'KCQB': 5875,
#     'KSWI': 5874,
#     'KPDC': 5870,
#     'KPRZ': 5867,
#     'KTCY': 5859,
#     'KOVS': 5856,
#     'KCFJ': 5848,
#     'KUKL': 5829,
#     'KEVM': 5816,
#     'KBMC': 5812,
#     'KEVU': 5808,
#     'KMHV': 5789,
#     'KEAN': 5768,
#     'KLKR': 5751,
#     'KMJQ': 5747,
#     'CYHK': 5737,
#     'TKPN': 5735,
#     'KAMN': 5719,
#     'KRRL': 5711,
#     'KCSQ': 5699,
#     'LPAZ': 5695,
#     'KPNT': 5675,
#     'PASY': 5674,
#     'KCIR': 5670,
#     'KLQR': 5669,
#     'EHRD': 5661,
#     'PASH': 5648,
#     'KHYW': 5631,
#     'KLWA': 5615,
#     'KBHK': 5610,
#     'KCPU': 5579,
#     'KLRJ': 5550,
#     'KWLW': 5548,
#     'KARM': 5541,
#     'KHHW': 5484,
#     'KWRB': 5467,
#     'CJV7': 5467,
#     'KMAC': 5460,
#     'KIZA': 5459,
#     'KPRN': 5458,
#     'KOCW': 5457,
#     'KPVJ': 5456,
#     'KTFP': 5445,
#     'KLJF': 5445,
#     'KMPR': 5428,
#     'PGRO': 5426,
#     'RKPK': 5420,
#     '17FL': 5416,
#     'KBWP': 5413,
#     'KBBD': 5407,
#     'KPMU': 5404,
#     'CSK3': 5401,
#     'KIMM': 5398,
#     'FA40': 5375,
#     'PPIZ': 5373,
#     'KGGI': 5368,
#     'KFGX': 5365,
#     'KTGC': 5364,
#     'CJT4': 5360,
#     'KLHV': 5331,
#     'CYKY': 5321,
#     'KPRG': 5297,
#     'KAUH': 5289,
#     'KFLX': 5285,
#     '3NJ6': 5280,
#     '15FL': 5270,
#     'KSWW': 5270,
#     'CYFH': 5268,
#     'CYFS': 5247,
#     'RJSF': 5245,
#     'CFB6': 5240,
#     'KGNG': 5237,
#     'KCQM': 5235,
#     'SVJC': 5224,
#     'MMZO': 5211,
#     'LIEO': 5209,
#     'KXLL': 5206,
#     'KGNC': 5200,
#     'CJZ3': 5198,
#     'CYVM': 5190,
#     'YARM': 5184,
#     'KTQH': 5176,
#     'CFX2': 5175,
#     'KHUL': 5159,
#     'CYML': 5157,
#     'KGNT': 5156,
#     'KPPF': 5152,
#     'LIML': 5151,
#     'KHZR': 5128,
#     'OPKC': 5095,
#     'KAEJ': 5090,
#     'KSLH': 5080,
#     'KTAN': 5079,
#     'SMJP': 5075,
#     'KACZ': 5057,
#     'CYAB': 5057,
#     'KAXX': 5045,
#     'KDTA': 5038,
#     '4LA4': 5030,
#     'CYQI': 5023,
#     'KLHB': 5021,
#     'KHIE': 5001,
#     'KCRT': 4991,
#     'KTVK': 4988,
#     'KPVE': 4978,
#     'EGJJ': 4976,
#     'KAFP': 4954,
#     'KMAN': 4943,
#     'KHXF': 4926,
#     'CYYH': 4921,
#     'CMB2': 4885,
#     'PAKW': 4884,
#     'KMPZ': 4882,
#     'KERY': 4877,
#     'MYAK': 4868,
#     'KEQA': 4865,
#     'FEFY': 4857,
#     'CZMD': 4846,
#     'KOMK': 4846,
#     'KFXY': 4845,
#     'KDLO': 4827,
#     'CTG3': 4818,
#     'KCDS': 4818,
#     'SVBC': 4815,
#     'KEST': 4815,
#     'KBML': 4788,
#     'KAVO': 4766,
#     'KBNW': 4765,
#     'KHEQ': 4754,
#     'KLXV': 4748,
#     'CJE3': 4735,
#     'KIFA': 4734,
#     'KUCA': 4730,
#     'CAJ4': 4728,
#     'EGVN': 4720,
#     'KDNS': 4719,
#     'KHNR': 4718,
#     'CEQ5': 4713,
#     'KAQW': 4697,
#     '0VA5': 4687,
#     'KEMV': 4681,
#     'OPRN': 4660,
#     'KLSF': 4660,
#     'KCPF': 4652,
#     'LL10': 4651,
#     'CYNJ': 4650,
#     'KJYM': 4646,
#     'KMDS': 4645,
#     '2NC0': 4631,
#     'OPLA': 4630,
#     'PATG': 4625,
#     'KBTN': 4622,
#     'KCHK': 4596,
#     'KORC': 4595,
#     'KKNB': 4592,
#     'PAAQ': 4588,
#     'PAPO': 4577,
#     'CEC4': 4575,
#     'KFZI': 4572,
#     'KBDG': 4568,
#     'KDGW': 4546,
#     'KLAM': 4540,
#     'CYSP': 4536,
#     'KINJ': 4535,
#     'CYBU': 4534,
#     'KBHC': 4517,
#     'TFFJ': 4505,
#     'KAPV': 4488,
#     'KMLT': 4485,
#     'VEAT': 4474,
#     'KNFW': 4470,
#     'AK40': 4469,
#     'KRVL': 4464,
#     'KENL': 4460,
#     'KCAR': 4458,
#     'KGHM': 4455,
#     'LTBH': 4452,
#     'KHZE': 4430,
#     'MYCC': 4422,
#     'KSWT': 4421,
#     '88NV': 4418,
#     'KIKW': 4398,
#     'CYFA': 4389,
#     'KFWB': 4380,
#     'KDZJ': 4367,
#     '0TX1': 4362,
#     'KVLA': 4352,
#     'KAJG': 4347,
#     'CYTA': 4343,
#     'CJQ3': 4319,
#     '57AZ': 4309,
#     'EGGD': 4305,
#     'KROS': 4304,
#     'LIRA': 4279,
#     'FMMV': 4277,
#     'ULLI': 4275,
#     'CYCZ': 4266,
#     'PHNY': 4262,
#     'CYQH': 4261,
#     'KDAW': 4260,
#     'KOIC': 4250,
#     'PTKK': 4248,
#     'KCYO': 4240,
#     'MO09': 4239,
#     'KUWL': 4235,
#     'KCNU': 4231,
#     'LTAD': 4224,
#     'KFKS': 4200,
#     'KDYA': 4193,
#     'KDLF': 4187,
#     'KOYM': 4180,
#     'NTGA': 4163,
#     'KRCM': 4156,
#     'KGEV': 4152,
#     'KMNZ': 4135,
#     'KCXU': 4134,
#     'KLMO': 4120,
#     'SBMN': 4120,
#     'CYTR': 4115,
#     'CER3': 4115,
#     'CYHA': 4102,
#     'CJY4': 4102,
#     'CKB6': 4101,
#     'KIJD': 4099,
#     'CYBB': 4095,
#     'CZWL': 4094,
#     'KHOC': 4075,
#     'CYEE': 4052,
#     'SELT': 4050,
#     'KBDQ': 4031,
#     'KAPT': 4028,
#     'SVMG': 4018,
#     'PGUA': 4018,
#     'TN44': 4014,
#     'KCVH': 4010,
#     'PTPN': 3993,
#     'KCSB': 3989,
#     'MMLP': 3986,
#     'KIML': 3983,
#     'KFKN': 3979,
#     'SVCS': 3978,
#     'KDWX': 3960,
#     'SLSU': 3960,
#     'CBQ2': 3948,
#     'KGCT': 3945,
#     'ZSNJ': 3936,
#     'KLSN': 3920,
#     'KJVW': 3914,
#     'CL68': 3910,
#     'CYQS': 3908,
#     'RODN': 3899,
#     'KCHT': 3898,
#     'LIBG': 3893,
#     'KJER': 3891,
#     'CYEY': 3891,
#     'KMRT': 3888,
#     'KRZN': 3883,
#     'KONY': 3878,
#     'KMBG': 3875,
#     'KCVS': 3867,
#     'KOKZ': 3867,
#     'KGNB': 3865,
#     'LICJ': 3864,
#     'MMTG': 3859,
#     'EDDB': 3857,
#     '68IS': 3845,
#     'SVBM': 3843,
#     'KINK': 3838,
#     'KHLC': 3830,
#     'KPKV': 3808,
#     'CCQ3': 3808,
#     'KZUN': 3790,
#     'CYDO': 3781,
#     'KPHG': 3774,
#     'KSFY': 3772,
#     'KUBE': 3771,
#     '1XA2': 3765,
#     'KHTL': 3763,
#     'CEN3': 3762,
#     '43NE': 3761,
#     'EHBK': 3737,
#     'KLHX': 3735,
#     'KHLX': 3712,
#     'RPUH': 3708,
#     'KAFK': 3683,
#     'MUCF': 3681,
#     'LEPA': 3670,
#     'WV12': 3668,
#     'EISG': 3662,
#     'KJYG': 3658,
#     'KOVO': 3655,
#     'LTCA': 3653,
#     'KOSX': 3652,
#     'KMUO': 3641,
#     'EDLV': 3625,
#     'CYLU': 3607,
#     'KTNP': 3602,
#     'LEGE': 3600,
#     'KFDW': 3598,
#     'KTLR': 3595,
#     'KVBW': 3595,
#     'KCHN': 3590,
#     'CYAS': 3575,
#     'KFFO': 3572,
#     'CYMW': 3571,
#     'KHWY': 3568,
#     'KIYA': 3567,
#     'KSUO': 3548,
#     'KUBX': 3537,
#     'KOZA': 3523,
#     'KRKW': 3509,
#     'EGSC': 3490,
#     'CZEE': 3487,
#     'KONM': 3485,
#     'KORE': 3477,
#     'KLXL': 3468,
#     'CSC3': 3463,
#     'CYRI': 3463,
#     'KSUZ': 3456,
#     'KPQN': 3444,
#     'MUNC': 3442,
#     'KOQW': 3436,
#     'CYAD': 3431,
#     'KBPI': 3431,
#     'KECS': 3422,
#     'CYPG': 3417,
#     'KRVJ': 3416,
#     'KAKQ': 3397,
#     'PABT': 3391,
#     'KBTY': 3389,
#     'SVPR': 3375,
#     '20GA': 3359,
#     'UHPP': 3344,
#     'CYOD': 3340,
#     'TTCP': 3329,
#     'CYRB': 3322,
#     'CAU3': 3319,
#     'KBAM': 3318,
#     'GA62': 3317,
#     'KSHN': 3315,
#     'KGQQ': 3315,
#     'KGIC': 3307,
#     'KFYJ': 3306,
#     'KTRX': 3304,
#     'KTCS': 3292,
#     'CAU4': 3291,
#     'KHSR': 3282,
#     'CJF3': 3280,
#     'KBXK': 3279,
#     'CYZS': 3268,
#     'KIBM': 3266,
#     'KNUW': 3263,
#     'CYIK': 3260,
#     'KRHP': 3255,
#     'CYNC': 3255,
#     'PA88': 3247,
#     'KSKI': 3226,
#     '2TS6': 3221,
#     'KDAA': 3214,
#     'CYUT': 3211,
#     'CEV3': 3208,
#     'KDAG': 3207,
#     'EDHI': 3205,
#     'KTQE': 3204,
#     'KBCK': 3182,
#     'KSLO': 3181,
#     'PKWA': 3180,
#     'KFWC': 3170,
#     'CTA4': 3164,
#     'KBYH': 3162,
#     'KLSV': 3151,
#     'KRYW': 3144,
#     '40XS': 3135,
#     'KSVE': 3120,
#     'SCFA': 3115,
#     'KEIK': 3112,
#     'KGRN': 3092,
#     'CYJQ': 3085,
#     'TVSC': 3067,
#     'TS07': 3059,
#     'KFWQ': 3054,
#     'CNY3': 3048,
#     'KOAR': 3048,
#     'KBYL': 3042,
#     'NSTU': 3037,
#     'KHAB': 3009,
#     'KHTW': 3005,
#     'KLKV': 2999,
#     'KSNC': 2996,
#     'CEB5': 2993,
#     'KNGP': 2981,
#     'CAJ9': 2981,
#     'KUKT': 2980,
#     'CEZ4': 2978,
#     'KCFV': 2967,
#     'LEIB': 2954,
#     '94FL': 2948,
#     'PAHP': 2947,
#     'MUMZ': 2937,
#     'ORBI': 2932,
#     'KFFX': 2930,
#     'CPV7': 2925,
#     'CYKG': 2911,
#     'KMZH': 2906,
#     'CSU3': 2893,
#     'KJMR': 2884,
#     'CZHP': 2880,
#     'KJYL': 2867,
#     'KSIF': 2863,
#     'KPNM': 2861,
#     'KVMR': 2858,
#     'CZFG': 2847,
#     'MBGT': 2843,
#     'KRZR': 2842,
#     'MMCN': 2842,
#     'KTOB': 2838,
#     'KHCO': 2834,
#     'KTSP': 2831,
#     'SGEN': 2828,
#     'CDK2': 2825,
#     '24NC': 2825,
#     'CEA5': 2814,
#     'KFSO': 2808,
#     'KVTI': 2795,
#     'KICL': 2794,
#     'CZEM': 2793,
#     'KCKI': 2792,
#     'KJFZ': 2780,
#     'CYVV': 2779,
#     'KMLF': 2777,
#     'KTWM': 2776,
#     'KCMY': 2770,
#     'KOZR': 2765,
#     'LS40': 2758,
#     'LEZG': 2757,
#     'MMML': 2753,
#     'CYHN': 2750,
#     'MA68': 2745,
#     'CYSH': 2743,
#     'CYKX': 2740,
#     '17XS': 2740,
#     'NBCR': 2728,
#     'SGAS': 2722,
#     'KOLZ': 2718,
#     'PAPG': 2714,
#     'PAGS': 2707,
#     'CZJN': 2702,
#     'KHVS': 2702,
#     'CYNM': 2697,
#     'KMKJ': 2695,
#     '24CL': 2694,
#     'KAIT': 2692,
#     'PARY': 2692,
#     '6NC1': 2680,
#     'KBWC': 2674,
#     'CSS3': 2662,
#     'KIDL': 2659,
#     'MSSS': 2658,
#     'KMNE': 2654,
#     'CSK6': 2653,
#     'KWAY': 2644,
#     'KUOS': 2638,
#     'FWMY': 2623,
#     'KEED': 2619,
#     'CTH7': 2591,
#     'KDSV': 2583,
#     'CYIB': 2583,
#     'TA50': 2582,
#     'CFS5': 2580,
#     'KCKP': 2580,
#     'KRSL': 2569,
#     'KBPP': 2568,
#     'KPLU': 2565,
#     'CYSU': 2563,
#     '5TX0': 2557,
#     'KCZL': 2546,
#     'KTZV': 2542,
#     'CAA8': 2542,
#     'KGRE': 2537,
#     'KBIX': 2529,
#     'LGSO': 2516,
#     'WY00': 2513,
#     'MMGM': 2506,
#     'HKGA': 2496,
#     'KEPM': 2495,
#     'CYGD': 2491,
#     '65LA': 2482,
#     'EGPE': 2481,
#     'CZFD': 2472,
#     'KFIG': 2465,
#     'KVHN': 2457,
#     'CSB2': 2439,
#     'SKSP': 2434,
#     'PATA': 2426,
#     'KGEY': 2425,
#     'PADU': 2423,
#     'KMEJ': 2418,
#     'LICA': 2415,
#     'KCKZ': 2414,
#     'FD15': 2404,
#     'YSCH': 2398,
#     'KCEV': 2394,
#     'CNP3': 2392,
#     'RKSS': 2383,
#     'PAWG': 2376,
#     '7CO0': 2365,
#     'KRTS': 2365,
#     'KAQO': 2362,
#     'DTTF': 2360,
#     'KBBP': 2339,
#     'KLIU': 2339,
#     'SKBG': 2332,
#     'EGUN': 2321,
#     'KPMZ': 2308,
#     'KMDZ': 2300,
#     'CFN5': 2297,
#     'KIXA': 2296,
#     'EGHI': 2293,
#     'KANK': 2290,
#     'KEGQ': 2289,
#     'SC99': 2278,
#     'CYLA': 2276,
#     '59FD': 2270,
#     'KMAO': 2253,
#     'CZAC': 2248,
#     'KMCZ': 2237,
#     'KGDJ': 2236,
#     'CCP6': 2235,
#     'EFRO': 2234,
#     'CMB7': 2232,
#     'EBOS': 2212,
#     'KBVN': 2209,
#     'KHIG': 2203,
#     'CNU8': 2201,
#     'KPWD': 2196,
#     'PHJH': 2188,
#     'KSZY': 2188,
#     'YPGV': 2187,
#     'LFCK': 2178,
#     'KLSB': 2178,
#     '09LA': 2171,
#     'CKQ3': 2166,
#     'CO12': 2166,
#     '7XS0': 2154,
#     'GQPA': 2149,
#     'CCN2': 2144,
#     'KBEA': 2134,
#     'MMCS': 2134,
#     'KBQR': 2131,
#     'SCTE': 2130,
#     'CYMG': 2122,
#     '99MN': 2099,
#     'CYPZ': 2094,
#     'CJS4': 2090,
#     'KEIW': 2082,
#     'KFOA': 2080,
#     'UT47': 2077,
#     'CYQN': 2071,
#     'KEBG': 2065,
#     'EGNS': 2065,
#     'KHMN': 2061,
#     'KUXL': 2059,
#     'RJOA': 2056,
#     'KLIC': 2051,
#     'CYXN': 2050,
#     'KSBX': 2049,
#     'KHST': 2045,
#     'SCCF': 2045,
#     'KIEN': 2041,
#     'KTZT': 2032,
#     'LDDU': 2032,
#     'KATA': 2026,
#     'KMXF': 2021,
#     'KHTF': 2020,
#     'KBXA': 2018,
#     'KFMM': 2013,
#     'KSYF': 2011,
#     'CYTB': 2011,
#     'CSR8': 2010,
#     'CJC5': 2008,
#     'KEPH': 2006,
#     'KBOK': 2002,
#     'KGHW': 2001,
#     'CYYL': 2000,
#     'CYCE': 1999,
#     'FL59': 1998,
#     'KIIY': 1998,
#     'KRWN': 1979,
#     'KANY': 1976,
#     'FALA': 1970,
#     'KMYJ': 1963,
#     'KOLG': 1962,
#     'CCS3': 1962,
#     '82IS': 1961,
#     'KBFR': 1960,
#     'KMWM': 1955,
#     'KCVK': 1954,
#     'FCOE': 1951,
#     'KBNG': 1950,
#     'LFTH': 1949,
#     'KOWI': 1949,
#     '75OA': 1948,
#     'KETC': 1940,
#     'KPOY': 1939,
#     'KXSA': 1932,
#     'KSAZ': 1926,
#     'KLUM': 1923,
#     'MD31': 1920,
#     'KHPT': 1914,
#     'KNBG': 1909,
#     'KMVI': 1905,
#     'MYES': 1904,
#     'CYHB': 1901,
#     'KOCQ': 1900,
#     'KSDC': 1889,
#     'KELA': 1882,
#     'KTIP': 1878,
#     'KFCY': 1874,
#     'KMAL': 1868,
#     'KCFT': 1858,
#     'CZGR': 1834,
#     'KHEI': 1833,
#     'CJB3': 1830,
#     'LFRG': 1825,
#     'KHRT': 1825,
#     'KCNK': 1821,
#     'XS20': 1821,
#     '5TE0': 1818,
#     'CZPO': 1817,
#     'KCII': 1813,
#     'SCIE': 1810,
#     'CFT9': 1806,
#     'KDUG': 1805,
#     'KBXG': 1796,
#     'CYJN': 1794,
#     'KPUJ': 1794,
#     'LFMV': 1793,
#     'KADT': 1786,
#     'CYWJ': 1782,
#     '92CA': 1782,
#     'KMHP': 1776,
#     'KBAD': 1776,
#     'CYCQ': 1771,
#     'CZNG': 1765,
#     'KLWL': 1765,
#     'SOCA': 1758,
#     'CYSZ': 1753,
#     'RJOB': 1748,
#     'LIRQ': 1745,
#     'KRCZ': 1743,
#     'KRAW': 1742,
#     'CYDA': 1740,
#     'KPHP': 1740,
#     'KNVD': 1739,
#     'KNUN': 1739,
#     'KCFE': 1736,
#     'KBBB': 1736,
#     'KOGM': 1735,
#     'CEF4': 1733,
#     'KCAO': 1730,
#     'TJRV': 1726,
#     '1GA0': 1717,
#     'KMKS': 1716,
#     'CDJ5': 1716,
#     'RJSS': 1714,
#     'KTWT': 1710,
#     'PATQ': 1709,
#     'KPOV': 1708,
#     'CYBE': 1706,
#     'SBBE': 1706,
#     'KPAM': 1704,
#     '0XA5': 1703,
#     'CEH3': 1697,
#     'KFMZ': 1692,
#     'KOLY': 1686,
#     'KAPG': 1683,
#     'PAFB': 1676,
#     'PASX': 1674,
#     'RJNA': 1671,
#     '3LA4': 1669,
#     'LIMJ': 1666,
#     'KMJD': 1662,
#     'OETF': 1662,
#     'KFWN': 1656,
#     'KSSC': 1655,
#     'LIMF': 1652,
#     'PTYA': 1650,
#     'EBMB': 1645,
#     'KNSE': 1640,
#     'RKSO': 1635,
#     'KFPK': 1633,
#     'KCHU': 1630,
#     '0ID2': 1630,
#     'CYGM': 1629,
#     'CVB2': 1614,
#     'EDSB': 1611,
#     'CYMU': 1600,
#     'MMPE': 1594,
#     'TS15': 1594,
#     'KNPA': 1589,
#     'KASJ': 1587,
#     'KEFW': 1582,
#     'CKK7': 1577,
#     'TX13': 1568,
#     'KMKA': 1566,
#     'YBCS': 1554,
#     'KAZC': 1553,
#     'CZPC': 1553,
#     'KAGZ': 1552,
#     'KDUB': 1549,
#     'MT53': 1541,
#     'UHHH': 1541,
#     '00NC': 1539,
#     'GMMX': 1539,
#     'MMCV': 1533,
#     'KINF': 1533,
#     'GVAC': 1530,
#     'CPV8': 1530,
#     'CJK2': 1526,
#     'CYKO': 1524,
#     'KVAD': 1523,
#     'CYKM': 1522,
#     '71TE': 1517,
#     'KVVV': 1516,
#     'KEMM': 1515,
#     'CYPO': 1515,
#     'KNJK': 1509,
#     'CEH5': 1509,
#     'CCW3': 1508,
#     'NCRG': 1507,
#     'TFFG': 1506,
#     'PAGK': 1504,
#     'KNBC': 1500,
#     'EKBI': 1497,
#     'KDEQ': 1489,
#     'KAOV': 1489,
#     'KDPG': 1483,
#     'EGQL': 1481,
#     'LGMK': 1481,
#     'KMIB': 1480,
#     'SKAR': 1480,
#     'KBYY': 1471,
#     'SLCA': 1470,
#     'CNE4': 1466,
#     'KBKF': 1463,
#     'FA44': 1462,
#     'CZJG': 1458,
#     'CEW3': 1456,
#     'KRCX': 1456,
#     '5KY7': 1448,
#     'CJP9': 1448,
#     'CYZY': 1443,
#     'KANP': 1442,
#     'KLRF': 1442,
#     'KSJS': 1440,
#     'KOKS': 1440,
#     'KEHA': 1435,
#     'CSD4': 1430,
#     'KVBG': 1428,
#     'KFSU': 1425,
#     'KFSE': 1420,
#     'NC25': 1419,
#     'KRED': 1414,
#     'KIKG': 1413,
#     'KWEA': 1409,
#     'RJOI': 1407,
#     'CYYW': 1402,
#     'KTHM': 1402,
#     'SEMT': 1401,
#     'KFAF': 1396,
#     'KPJY': 1394,
#     '16TA': 1390,
#     'PLCH': 1388,
#     'EGPD': 1388,
#     'CYCS': 1386,
#     'EFOU': 1385,
#     'MO32': 1380,
#     '2CN4': 1375,
#     '1AR6': 1360,
#     'CPT2': 1358,
#     'TA25': 1357,
#     'KPZQ': 1356,
#     'KOLD': 1355,
#     'KFLY': 1354,
#     'CNV9': 1348,
#     'MO00': 1347,
#     'CYOA': 1340,
#     'CEG8': 1340,
#     'CYLD': 1338,
#     'CYEM': 1335,
#     'KPOH': 1334,
#     'KGGF': 1334,
#     '81II': 1334,
#     'KTDO': 1332,
#     '9TE2': 1332,
#     'MY18': 1326,
#     'DE25': 1323,
#     '4TE9': 1320,
#     'LIPO': 1319,
#     'EGTH': 1315,
#     'CJV8': 1309,
#     'SC00': 1307,
#     'CYOS': 1303,
#     'KRIU': 1301,
#     'KTVY': 1296,
#     'PAMD': 1295,
#     '06AR': 1295,
#     '5LL8': 1289,
#     'LHBP': 1284,
#     'EDDN': 1283,
#     'KRFI': 1279,
#     'CEG4': 1277,
#     '32GA': 1271,
#     'ESSB': 1271,
#     'WIPA': 1269,
#     'KAIB': 1268,
#     'EDAC': 1267,
#     'CZTA': 1267,
#     'KHOE': 1266,
#     'KBAB': 1265,
#     'CJV5': 1257,
#     'CYRM': 1256,
#     'MKPF': 1247,
#     '3NR3': 1246,
#     '38WA': 1245,
#     'KBVU': 1245,
#     '89TE': 1242,
#     'ENBR': 1241,
#     'ESOE': 1240,
#     'KGAS': 1238,
#     'CYWV': 1233,
#     'KAMT': 1227,
#     'SABE': 1226,
#     'MMRX': 1225,
#     '18MO': 1218,
#     'TS36': 1215,
#     'LS99': 1214,
#     'CZML': 1213,
#     'MYLD': 1211,
#     'PAKK': 1210,
#     'KADF': 1208,
#     'FD51': 1207,
#     'KCYW': 1207,
#     'CYME': 1206,
#     'PAIK': 1202,
#     'CKZ3': 1201,
#     '08MS': 1197,
#     'CYHS': 1194,
#     'KAAT': 1189,
#     'KGOO': 1185,
#     'CYVT': 1184,
#     'CYAX': 1184,
#     'KINS': 1180,
#     'LA48': 1180,
#     'KLOL': 1177,
#     'AR62': 1176,
#     '36WI': 1176,
#     'KRQO': 1176,
#     'CYLQ': 1176,
#     '74PN': 1174,
#     'CYSW': 1173,
#     'KREI': 1172,
#     'MLGT': 1171,
#     'CDV2': 1166,
#     '31WI': 1162,
#     'MRPV': 1162,
#     'LFTW': 1159,
#     'KGDW': 1157,
#     'KGCD': 1156,
#     'MMPA': 1147,
#     'KOWP': 1146,
#     'SC72': 1137,
#     'MYAX': 1135,
#     'CYID': 1132,
#     'CDA4': 1130,
#     'KFGU': 1129,
#     'CEL5': 1123,
#     'PAAK': 1122,
#     'KPSX': 1116,
#     'CJQ4': 1116,
#     'TJVQ': 1114,
#     'KMNF': 1114,
#     'CED5': 1112,
#     '2IL9': 1109,
#     'AA03': 1108,
#     'NC14': 1104,
#     'LOWS': 1098,
#     'KBAC': 1090,
#     'RJSN': 1089,
#     'NSFA': 1087,
#     'UCFM': 1087,
#     'SCSE': 1087,
#     'EGNV': 1086,
#     'EGNM': 1085,
#     'CNS7': 1071,
#     'KTHP': 1069,
#     'LIPX': 1067,
#     'LFBT': 1065,
#     'FASB': 1064,
#     'CBW4': 1064,
#     'WI31': 1061,
#     'LA54': 1057,
#     'CNF4': 1056,
#     'MMPN': 1052,
#     'EGHH': 1049,
#     'CYTQ': 1048,
#     'KECU': 1046,
#     'CBS8': 1043,
#     'VEGK': 1043,
#     'LL45': 1040,
#     'MYGD': 1038,
#     'CSG5': 1037,
#     'CKH2': 1036,
#     'KGFZ': 1035,
#     'KTIK': 1030,
#     'SCHA': 1027,
#     'CYUB': 1024,
#     '1TA7': 1023,
#     '64OG': 1021,
#     'CBN9': 1013,
#     'EGFF': 1012,
#     'KGZH': 1007,
#     'CKX8': 1007,
#     '8TN2': 1006,
#     'CHIB': 1005,
#     'KAIV': 1005,
#     '7XS7': 1003,
#     'CFX4': 1002,
#     '0KS9': 1002,
#     '0TN8': 1002,
#     'SCAR': 1001,
#     'CND4': 1000,
#     'KLLJ': 997,
#     'EHEH': 997,
#     'KACP': 992,
#     'K5Y1': 990,
#     'CYLC': 989,
#     'FA36': 988,
#     'TN08': 984,
#     'CNV8': 980,
#     'KGBR': 979,
#     'KJXI': 978,
#     'KGOP': 976,
#     'CSM3': 976,
#     'KGWS': 975,
#     'KPNN': 973,
#     'KRCE': 970,
#     'AYPY': 969,
#     'CJR4': 968,
#     'CAJ3': 965,
#     'KTNT': 956,
#     'XA89': 956,
#     'CNB2': 955,
#     'KCFS': 954,
#     'LMML': 952,
#     'MMES': 951,
#     'KOWK': 947,
#     'ZUUU': 946,
#     'KBDJ': 945,
#     'XA66': 944,
#     'CYZX': 943,
#     'KBKT': 942,
#     'VA42': 939,
#     'PAFW': 936,
#     '64FA': 936,
#     'CSB3': 931,
#     'KADU': 929,
#     'KLUD': 925,
#     'MYCH': 925,
#     'OAFR': 925,
#     'W122': 923,
#     'MPPA': 918,
#     '81MU': 917,
#     'KCMD': 917,
#     'LIRZ': 915,
#     'LPMA': 914,
#     'KPOE': 912,
#     '11WY': 912,
#     'EDDV': 911,
#     'CEH6': 911,
#     'VIST': 907,
#     'KHRU': 906,
#     'PASV': 905,
#     'KRIR': 904,
#     '08AK': 904,
#     'KEZF': 900,
#     'FA37': 899,
#     'CEN5': 898,
#     'W291': 897,
#     'MMMA': 897,
#     'LIRS': 895,
#     'XS71': 893,
#     'EKSB': 892,
#     'KBFE': 892,
#     '15WI': 890,
#     'EKRK': 890,
#     '5KY4': 888,
#     'LL37': 886,
#     'KORB': 884,
#     'AK61': 883,
#     'KGSB': 881,
#     'KEOE': 878,
#     'KFBR': 878,
#     'LPFL': 874,
#     'ETSI': 873,
#     'SEQU': 872,
#     '2GA0': 872,
#     'CBH2': 868,
#     'CSE5': 868,
#     'BIAR': 867,
#     'KODX': 867,
#     '09FA': 867,
#     '01AA': 866,
#     'GCTS': 866,
#     'LEVC': 865,
#     'MMLM': 860,
#     'FD88': 859,
#     'CKZ7': 855,
#     '8MN3': 855,
#     'EGAC': 853,
#     'CYRV': 852,
#     'KSPH': 852,
#     'KGRF': 851,
#     'MYCA': 849,
#     'KRDR': 847,
#     'MS57': 847,
#     '62GA': 847,
#     'CEQ3': 845,
#     'LSGS': 845,
#     'PAEH': 845,
#     'KDYT': 844,
#     'LYTV': 844,
#     'KHBC': 840,
#     '5GA3': 839,
#     'MYEG': 839,
#     'NTTT': 839,
#     'KTMK': 837,
#     '7FA1': 834,
#     '03NC': 833,
#     'KCVB': 831,
#     'BGGH': 829,
#     'CNL3': 826,
#     'KCNB': 826,
#     '4TS5': 818,
#     'KRCA': 817,
#     'KJKL': 817,
#     'CYBP': 816,
#     '5CA7': 816,
#     'TVSV': 815,
#     'XA88': 814,
#     '7KS9': 813,
#     'CAJ7': 812,
#     'XS67': 811,
#     'CYHI': 807,
#     'LIPE': 806,
#     'CAF4': 806,
#     'KFBG': 804,
#     'PHNG': 803,
#     'KVVS': 801,
#     'FA12': 797,
#     '89NY': 797,
#     'CJJ4': 797,
#     'CHEN': 794,
#     'EGTE': 792,
#     '89TS': 792,
#     'MMCP': 791,
#     'KGYL': 791,
#     'CJE4': 790,
#     '14TS': 788,
#     'XS75': 786,
#     'KACQ': 785,
#     'CAQ5': 784,
#     'CNN8': 784,
#     'MMNL': 784,
#     'UKBB': 784,
#     '6TE6': 783,
#     '5AZ3': 781,
#     '66TE': 780,
#     'CZSN': 779,
#     '4AK6': 771,
#     '42XS': 770,
#     'KMTC': 769,
#     'FLSW': 768,
#     'KSDA': 768,
#     'KLSK': 767,
#     '87XS': 766,
#     'KRBO': 764,
#     'KPKF': 763,
#     'CMR2': 763,
#     'CSG9': 761,
#     'FA18': 760,
#     'FD08': 760,
#     'KMGE': 756,
#     'CJG4': 756,
#     '22FA': 753,
#     'EDMO': 751,
#     'KETH': 751,
#     'KRPX': 749,
#     'CPU6': 745,
#     'CNC4': 744,
#     'KOBI': 738,
#     '2TN2': 735,
#     '8NC8': 735,
#     'KLLR': 735,
#     'CA92': 734,
#     'KFOZ': 733,
#     'WA09': 732,
#     'MYAP': 730,
#     'EDVE': 729,
#     'VG18': 728,
#     '7WI5': 728,
#     'KCNH': 726,
#     'IA82': 725,
#     'CDT5': 723,
#     'CBQ7': 723,
#     '4TX2': 721,
#     'KEOP': 720,
#     'CAM3': 720,
#     'KBUM': 719,
#     'OR81': 719,
#     'CYDC': 718,
#     'PATC': 717,
#     'EBAW': 717,
#     'PACZ': 716,
#     'KCPM': 715,
#     'LTFE': 715,
#     'KLRG': 715,
#     'FA83': 714,
#     'TN85': 714,
#     'CYCW': 713,
#     'SLLP': 712,
#     'KAIG': 712,
#     'CJY3': 712,
#     'CPS5': 709,
#     'LA87': 709,
#     '15AR': 707,
#     'SCTC': 707,
#     '05XS': 707,
#     'SCCI': 705,
#     'CO15': 704,
#     'WI40': 703,
#     'SBFZ': 702,
#     'MYAW': 702,
#     'MS96': 700,
#     'EGMH': 698,
#     'MMTP': 698,
#     'KDYS': 696,
#     'KEZS': 693,
#     'SLJE': 692,
#     'KKIC': 688,
#     'KCMR': 687,
#     'CCP2': 685,
#     'CEL4': 685,
#     'PS78': 684,
#     '06FA': 683,
#     'CZBD': 682,
#     'KJSY': 681,
#     'KPSB': 679,
#     'PAEI': 676,
#     'KTKV': 675,
#     'KJHN': 673,
#     'KPMB': 673,
#     'LTBS': 672,
#     'CTNV': 672,
#     'VDST': 671,
#     'PATK': 671,
#     'KSCB': 670,
#     'LFRN': 670,
#     'CST3': 670,
#     'KPHH': 667,
#     'SAME': 666,
#     '12TN': 665,
#     '9IL2': 665,
#     'LFRB': 663,
#     'ENZV': 662,
#     'CYPT': 662,
#     'CEG3': 662,
#     'HKMO': 661,
#     '86KS': 659,
#     'PAPR': 658,
#     'LEAL': 658,
#     'KJAQ': 658,
#     'KLUX': 655,
#     'KNID': 654,
#     'KDXX': 652,
#     '4AR2': 649,
#     'KLLN': 648,
#     'KNJW': 648,
#     'CKF9': 647,
#     '5NC5': 644,
#     '1VA0': 643,
#     '90MS': 643,
#     'KJKJ': 642,
#     'KMUL': 642,
#     'KGOV': 639,
#     'EKKA': 638,
#     'TS21': 634,
#     'CYGE': 632,
#     'CYLR': 631,
#     'WS51': 631,
#     '09CL': 630,
#     'RJCN': 630,
#     'XS85': 624,
#     'PABV': 623,
#     'IA66': 623,
#     'KEDU': 619,
#     'CFM4': 617,
#     'ESMS': 617,
#     'TE78': 616,
#     'PALU': 615,
#     'UACC': 614,
#     'PGWT': 614,
#     'SC47': 612,
#     'VMMC': 611,
#     '9NC8': 608,
#     'TN80': 608,
#     'EIKY': 608,
#     'KHJH': 606,
#     'CEJ4': 605,
#     'CJX4': 603,
#     'KOIN': 600,
#     '1MS6': 595,
#     'KAHH': 594,
#     'KRBE': 591,
#     '6GA0': 591,
#     'TA65': 587,
#     'KAPY': 586,
#     'ZSHC': 586,
#     '5TS8': 585,
#     'LL34': 585,
#     'WY11': 583,
#     'OR40': 583,
#     'GMME': 583,
#     '3GE9': 582,
#     'PAOM': 581,
#     'TX25': 580,
#     'TJMZ': 578,
#     '75TA': 576,
#     '4GE3': 575,
#     '4AK1': 574,
#     'ENBO': 574,
#     'SACO': 571,
#     'KHLB': 571,
#     'CYIN': 571,
#     '5WN8': 570,
#     'AFIL': 569,
#     'CYPU': 569,
#     '24AK': 569,
#     'KNQI': 569,
#     'EHGG': 566,
#     'MYCI': 566,
#     'KNQX': 563,
#     'AK10': 563,
#     'CTM2': 556,
#     'LTAC': 555,
#     '01NC': 555,
#     'EBCI': 555,
#     'TX32': 555,
#     '61AR': 554,
#     'LFMP': 554,
#     '2TE2': 553,
#     '9VA0': 551,
#     'PABL': 551,
#     'CSH4': 551,
#     'W386': 549,
#     'CPF2': 549,
#     '5NC3': 549,
#     'PAAT': 549,
#     'CEU2': 546,
#     'TA67': 546,
#     'KBUB': 546,
#     'FKYS': 545,
#     'KFOM': 545,
#     '2AK6': 544,
#     '15MO': 543,
#     'KNMM': 543,
#     '00AL': 540,
#     'KRPB': 538,
#     'KCUL': 538,
#     'KFCA': 537,
#     'MS82': 536,
#     'KIDG': 536,
#     'PWAK': 534,
#     'KRPJ': 534,
#     'KLUA': 533,
#     '5TE5': 532,
#     'UATG': 532,
#     'LPFR': 532,
#     'KNFL': 531,
#     'CES4': 531,
#     'CSZ3': 531,
#     '00OI': 530,
#     'CZNL': 529,
#     'KHFF': 527,
#     'FL17': 526,
#     'TN98': 524,
#     'CSG3': 524,
#     '7NC2': 523,
#     'KRCP': 522,
#     'CSQ3': 522,
#     'EGPN': 519,
#     'CKB2': 514,
#     '2IS9': 514,
#     'UMMS': 512,
#     'CYOC': 512,
#     'CJL2': 512,
#     'KMVM': 512,
#     'PAHN': 512,
#     'KEFC': 509,
#     'SCBA': 509,
#     '5NC2': 508,
#     'XS83': 508,
#     '69KS': 506,
#     'KRRQ': 506,
#     'ENAL': 505,
#     'IS00': 505,
#     'NC21': 504,
#     'KDGL': 503,
#     'VLSV': 502,
#     'CYPC': 500,
#     'EGBP': 496,
#     'MI32': 496,
#     'KHIF': 496,
#     'EGNJ': 495,
#     'CBX7': 494,
#     'KHLM': 494,
#     '60TE': 494,
#     'KJRA': 493,
#     'KTTS': 492,
#     'ESGG': 492,
#     'PHHN': 491,
#     'WAMT': 491,
#     'KPRS': 491,
#     'KFBY': 490,
#     '2OR1': 490,
#     'MMMT': 486,
#     'CEC3': 486,
#     'CES2': 486,
#     '0GE5': 485,
#     'WA59': 483,
#     'WS27': 483,
#     '9MT0': 483,
#     'MMIA': 482,
#     'KRFG': 481,
#     'PHBK': 481,
#     'SVBL': 479,
#     'CSN7': 479,
#     'KDMA': 479,
#     'LEJR': 478,
#     'KMKN': 478,
#     '83FL': 478,
#     'CDA5': 477,
#     'LGSR': 475,
#     '0AZ5': 474,
#     'CYES': 474,
#     '6KS1': 474,
#     'CJS3': 473,
#     'LSZR': 470,
#     'NC81': 470,
#     'MY37': 468,
#     'CNZ8': 467,
#     '16TE': 466,
#     'LFLY': 465,
#     'FA38': 465,
#     '3KS5': 464,
#     'KLEM': 464,
#     'KLYV': 464,
#     'MBNC': 464,
#     'WN53': 463,
#     '06WN': 462,
#     'CCC2': 462,
#     'KCRO': 461,
#     'KMMS': 460,
#     'LHPR': 460,
#     'LFMK': 458,
#     'EPKT': 457,
#     'GE26': 456,
#     'UGTB': 455,
#     'CAH4': 453,
#     'CNQ3': 452,
#     'KMXA': 450,
#     'ZYHB': 449,
#     'KNRB': 449,
#     'LGKR': 448,
#     'PASL': 443,
#     '13ME': 443,
#     'KRNP': 443,
#     'LBWN': 442,
#     'KNUC': 441,
#     'RKPC': 440,
#     'KJDN': 437,
#     'KBFW': 436,
#     'KTIF': 435,
#     'LFBZ': 434,
#     'PTSA': 434,
#     '97MT': 434,
#     'VDPP': 432,
#     'WS46': 432,
#     'TA24': 431,
#     'CJW5': 430,
#     'UBBB': 429,
#     'VVNB': 428,
#     'KOVL': 427,
#     'KGTE': 426,
#     '5GA2': 426,
#     'MMPS': 425,
#     'HSOB': 423,
#     'KGTG': 421,
#     'MMSF': 421,
#     '8CA8': 419,
#     'DNLL': 419,
#     'CFN7': 418,
#     'EGMC': 416,
#     '3MN6': 416,
#     'CZST': 416,
#     'TN35': 415,
#     'WV62': 412,
#     'NM32': 412,
#     'KFTK': 411,
#     '15WA': 411,
#     '9IS0': 411,
#     'SN95': 409,
#     'FD22': 409,
#     'CJK4': 408,
#     'CJA3': 408,
#     'LFMU': 408,
#     'LFKF': 408,
#     '11LS': 407,
#     'SC82': 405,
#     'KJDD': 405,
#     '18FD': 405,
#     '27XS': 404,
#     'CED4': 403,
#     '21MU': 402,
#     'KRUG': 402,
#     'KNEL': 401,
#     'PMDY': 401,
#     '1MN8': 398,
#     'LEST': 397,
#     'KJWG': 397,
#     '4MS6': 396,
#     'CNL9': 395,
#     'CJT3': 393,
#     'FL20': 393,
#     'KNUI': 392,
#     '07TS': 392,
#     '21LS': 392,
#     'TE86': 391,
#     'MKBS': 391,
#     'KLGF': 390,
#     'ZYCC': 390,
#     'UTAA': 390,
#     'UHMD': 389,
#     'IS65': 387,
#     'CSP6': 386,
#     '2TX0': 385,
#     'LS77': 385,
#     'KAQR': 385,
#     '75FL': 381,
#     'CEA6': 381,
#     'NGTA': 381,
#     'KSLI': 381,
#     'RCKH': 380,
#     '48TE': 379,
#     '24MO': 378,
#     '1LL2': 377,
#     'CYSE': 376,
#     'KMPJ': 376,
#     'GA27': 375,
#     'NH82': 374,
#     'KFDR': 374,
#     'ESSL': 373,
#     '10FA': 372,
#     'OG39': 371,
#     'FOOL': 371,
#     'KDCM': 370,
#     'EGBE': 370,
#     'RJNW': 369,
#     '2SD9': 367,
#     'TE90': 364,
#     'CNJ4': 364,
#     'KGYB': 363,
#     'PAWT': 363,
#     'UAAA': 361,
#     'ESNO': 361,
#     'CJD5': 360,
#     'FAPJ': 360,
#     'LFOK': 360,
#     '6WA3': 359,
#     'CYLI': 356,
#     'SBFI': 355,
#     'XS90': 355,
#     'FL90': 355,
#     '0XA4': 352,
#     'AL55': 351,
#     'CNY4': 351,
#     'CPF6': 351,
#     'CKA9': 348,
#     'CEJ3': 348,
#     'SPHI': 347,
#     'XA93': 347,
#     'AL17': 347,
#     'PANT': 346,
#     'PLPA': 346,
#     'VNMG': 345,
#     'TNCE': 345,
#     'CSRS': 344,
#     'KGWR': 344,
#     'CZFM': 342,
#     'SBBV': 342,
#     'CT71': 342,
#     '2IG4': 340,
#     'KFNB': 338,
#     'OG51': 338,
#     'TDCF': 337,
#     'PA10': 337,
#     'CPR5': 337,
#     'SCVD': 336,
#     'CCS4': 335,
#     'LA93': 334,
#     'LICC': 333,
#     'CYPS': 333,
#     'CEK6': 333,
#     '3OH0': 332,
#     'GA06': 330,
#     '87TS': 330,
#     'CNR4': 329,
#     'CYNH': 328,
#     'LTFD': 326,
#     '2XS6': 326,
#     'EGTC': 326,
#     'SULS': 325,
#     '79PN': 325,
#     'CT41': 323,
#     'KSRE': 323,
#     'PAMR': 323,
#     'KHWQ': 323,
#     'CBF6': 322,
#     '8TN7': 322,
#     'ZSJN': 322,
#     'CGLO': 322,
#     '42KY': 321,
#     'LIPH': 320,
#     'HI01': 320,
#     'CYAU': 319,
#     'EGHQ': 319,
#     'PHUP': 318,
#     'EFTP': 318,
#     '38XS': 317,
#     'EDAH': 316,
#     '1SD9': 316,
#     'MHLC': 316,
#     'FKKC': 316,
#     'CJS5': 316,
#     'KBFK': 315,
#     'EGNO': 315,
#     'CPR2': 315,
#     'ORMM': 313,
#     'IN62': 313,
#     'CNN3': 313,
#     'CDY3': 313,
#     'IN06': 312,
#     'MPDA': 311,
#     '30PN': 310,
#     'TN77': 310,
#     '9FD7': 310,
#     'ESGP': 309,
#     'MMCM': 308,
#     'MS14': 308,
#     'RCSS': 307,
#     'IL93': 306,
#     'NV33': 306,
#     'KSKA': 306,
#     'LIME': 306,
#     'K0S9': 304,
#     'UDYZ': 304,
#     'CMN5': 304,
#     'KEAG': 303,
#     'CCA3': 302,
#     'WN26': 302,
#     'NC05': 302,
#     'KGAG': 301,
#     'SN65': 301,
#     'KCHQ': 300,
#     '7LS4': 300,
#     'TN20': 299,
#     'KPCU': 298,
#     'DAUG': 298,
#     'KBKN': 298,
#     'FD63': 296,
#     'EGNR': 295,
#     'OH66': 294,
#     '3TS0': 294,
#     'CAH3': 294,
#     'KCEA': 294,
#     'EGVA': 293,
#     'EPPO': 292,
#     'EGNH': 292,
#     'KBIJ': 291,
#     'TE26': 291,
#     'II18': 290,
#     'MMPG': 289,
#     'LRCK': 286,
#     'MRGF': 285,
#     '2SD1': 285,
#     'PATL': 284,
#     '7PS9': 284,
#     'WS98': 284,
#     'NY10': 283,
#     'CTU2': 282,
#     'LIMP': 281,
#     'AK51': 281,
#     'PAOR': 280,
#     '0AZ2': 280,
#     '57TN': 277,
#     'MGFL': 277,
#     '88TN': 276,
#     'LSZB': 276,
#     'CJL5': 275,
#     'CL33': 275,
#     'CZGF': 275,
#     'UNOO': 275,
#     'AVFR': 275,
#     'KNCA': 275,
#     'EYPA': 274,
#     '6IS0': 274,
#     'KGEO': 274,
#     'KVKX': 272,
#     'CEF3': 272,
#     'KGXF': 272,
#     'OLBA': 271,
#     'CCW4': 271,
#     'MD71': 271,
#     '1TX4': 271,
#     'NTTH': 271,
#     'LFLX': 270,
#     '85TE': 270,
#     'CKL5': 270,
#     'EGAE': 269,
#     'XA99': 269,
#     'KHES': 268,
#     'GA14': 268,
#     'GA16': 267,
#     '5LS9': 266,
#     'FL37': 266,
#     '54XS': 266,
#     'W283': 265,
#     'NC92': 265,
#     'PA28': 265,
#     '72TA': 264,
#     'NC19': 263,
#     'KGVE': 263,
#     'CJK3': 262,
#     'KGAF': 262,
#     'SAAR': 261,
#     'ENAT': 260,
#     'FCBZ': 260,
#     'YPDN': 260,
#     'WS38': 260,
#     'LFOH': 259,
#     '09TN': 259,
#     '2VG2': 259,
#     'KCQW': 259,
#     'CRB4': 258,
#     'MMEP': 258,
#     'DVMI': 257,
#     '06MO': 257,
#     'MTPO': 256,
#     'KXBP': 255,
#     'EGSH': 255,
#     'KTGI': 255,
#     '23TN': 254,
#     'LDZD': 254,
#     'CL69': 254,
#     'WS33': 254,
#     '15MT': 253,
#     'AL41': 253,
#     '8LA1': 253,
#     '61NC': 252,
#     '82CL': 252,
#     'WN07': 251,
#     '8IS5': 250,
#     'EFKT': 250,
#     'EDVK': 249,
#     'ETNL': 249,
#     'SCJO': 247,
#     'FL97': 247,
#     'EPKK': 246,
#     'LGIR': 246,
#     'ZSOF': 245,
#     'CFG3': 245,
#     'GCLP': 245,
#     'CEM5': 244,
#     'TN94': 244,
#     'KLWD': 243,
#     '0LA7': 243,
#     'FA30': 242,
#     'CRL2': 242,
#     'KLZZ': 242,
#     'UT25': 242,
#     '64PN': 241,
#     'LFJR': 241,
#     '7FL4': 240,
#     'LDZA': 240,
#     'LYBE': 240,
#     'KCBG': 239,
#     '01NK': 239,
#     'EGJB': 238,
#     'ENAN': 237,
#     'KU77': 237,
#     '4PN7': 237,
#     'MKPE': 236,
#     'IL82': 236,
#     'CPH3': 236,
#     'KPEX': 236,
#     'CLJ2': 236,
#     'LBBG': 235,
#     '3TA5': 235,
#     'AL05': 235,
#     '02FA': 234,
#     'LKPD': 234,
#     '04TN': 234,
#     'NH33': 234,
#     'LAKE': 233,
#     'MMSM': 233,
#     'CPM3': 233,
#     'NC30': 233,
#     'DNAA': 232,
#     '13WI': 231,
#     '6FL0': 231,
#     'KEND': 230,
#     '9MN1': 229,
#     'XS43': 229,
#     'CL53': 229,
#     'MMLC': 229,
#     '9CA7': 229,
#     'LROP': 229,
#     'CJA5': 228,
#     'LEPP': 228,
#     'AK71': 228,
#     'PA97': 227,
#     'MO64': 227,
#     'NC12': 227,
#     'CSY4': 227,
#     'KAFF': 226,
#     'K4I3': 226,
#     'FL10': 226,
#     'AK78': 225,
#     'BGJN': 225,
#     'KAFN': 225,
#     '6JY8': 225,
#     'TX40': 225,
#     'CPJ5': 225,
#     'CYNN': 225,
#     'LFKJ': 225,
#     'KLVL': 224,
#     'EDDW': 223,
#     'CGS2': 223,
#     'LFRK': 223,
#     'CAG3': 223,
#     'RJNT': 222,
#     'MMCB': 222,
#     'VG43': 222,
#     'CJQ9': 221,
#     'CBE2': 221,
#     'LFQQ': 221,
#     'LA46': 221,
#     'WI89': 221,
#     'CKE8': 221,
#     '8TA9': 220,
#     'TE37': 220,
#     'OMAL': 220,
#     'MYRP': 220,
#     'URWI': 220,
#     'KLRY': 220,
#     'CJB6': 219,
#     'NC35': 219,
#     'XS66': 219,
#     'KFKA': 218,
#     'URRR': 218,
#     'CYJM': 218,
#     'RJSY': 217,
#     'CSBM': 216,
#     'KPYN': 216,
#     'CKD9': 216,
#     '1XA7': 216,
#     '1FA3': 216,
#     'LZIB': 215,
#     'CNW3': 215,
#     'WV32': 215,
#     'MMJA': 215,
#     'LA04': 215,
#     'LTCI': 214,
#     'KRCK': 213,
#     '0PS8': 213,
#     'KMYZ': 213,
#     'KPLB': 213,
#     '7CA3': 212,
#     'NE56': 212,
#     '4AR1': 212,
#     'CAD5': 212,
#     'CZUC': 211,
#     '6NC3': 211,
#     'MYMM': 211,
#     'CYGH': 211,
#     '8FL3': 210,
#     'KPYP': 210,
#     'LRBS': 210,
#     'EPML': 210,
#     'DIKO': 209,
#     'ROAH': 209,
#     '41TS': 208,
#     'CJJ8': 208,
#     'TE83': 207,
#     'WS25': 206,
#     'RKTU': 206,
#     'IL45': 205,
#     'K0G7': 205,
#     '1AR9': 205,
#     'SBSL': 205,
#     'LIPQ': 204,
#     'VA22': 203,
#     'KFRR': 202,
#     'AZ82': 202,
#     '4IS9': 202,
#     'ETNG': 201,
#     'UKFB': 201,
#     'CYMA': 201,
#     '37AA': 200,
#     'KGZL': 200,
#     'RKTN': 199,
#     'KFRI': 199,
#     'MT04': 198,
#     'MWCB': 197,
#     'PA56': 197,
#     'NC26': 197,
#     'EGDX': 196,
#     'K38W': 196,
#     'CBX5': 195,
#     '7TX7': 195,
#     '25TA': 195,
#     'EDDE': 194,
#     '1MU2': 194,
#     '1AK3': 194,
#     'CYYO': 193,
#     'EIKN': 193,
#     'CJL8': 193,
#     '76LS': 192,
#     'LDPL': 191,
#     'FL74': 191,
#     'SD93': 191,
#     'MDBH': 190,
#     'CYCP': 190,
#     'SD94': 190,
#     'NK16': 189,
#     'CO00': 189,
#     'KAOC': 188,
#     'KASY': 188,
#     'KRND': 187,
#     'CYGB': 187,
#     '23IN': 187,
#     'KFSI': 187,
#     'CJS2': 187,
#     'KCBM': 187,
#     'NV74': 186,
#     'FDEP': 186,
#     'RJCM': 186,
#     '97TN': 185,
#     '61TE': 184,
#     'EFIV': 184,
#     'SARE': 183,
#     '81PN': 182,
#     '51WA': 181,
#     'CFL2': 181,
#     'EDLW': 181,
#     'KADC': 179,
#     'SBCT': 179,
#     'CBB9': 178,
#     'KREO': 178,
#     'AZ27': 178,
#     'KFCS': 178,
#     'MRPM': 177,
#     '30MN': 177,
#     'SN34': 177,
#     'KSXU': 177,
#     '25SC': 176,
#     '78NC': 175,
#     'MO30': 175,
#     'LFRD': 175,
#     'WV59': 174,
#     'ME64': 174,
#     'MS88': 174,
#     'NZMC': 173,
#     'KCCA': 172,
#     'KISB': 172,
#     'KN35': 172,
#     '9XS6': 172,
#     '02MO': 171,
#     'CPH2': 170,
#     '82TS': 170,
#     '19GA': 170,
#     'K5B2': 169,
#     'CJF8': 169,
#     'KSPZ': 168,
#     'IN55': 167,
#     'UTTT': 166,
#     'LFST': 166,
#     'UHMM': 166,
#     'NK26': 165,
#     '4TS8': 164,
#     '6XS7': 164,
#     'FOOT': 163,
#     'KMLD': 163,
#     'ZYTL': 163,
#     'HEDK': 163,
#     'MYCP': 163,
#     'AK47': 162,
#     'WS29': 162,
#     'SBCG': 161,
#     'SCIP': 161,
#     'SKCC': 161,
#     'K48Y': 160,
#     '5OH9': 160,
#     '12CL': 160,
#     'LFOE': 159,
#     '64GA': 159,
#     'KNFG': 159,
#     'FL75': 159,
#     '5KY2': 159,
#     'CN01': 159,
#     'CYSY': 158,
#     '89TN': 158,
#     'KRVN': 158,
#     'ESPA': 158,
#     'CSC9': 157,
#     'MY77': 157,
#     'OSAP': 157,
#     'LIBP': 156,
#     'SKPE': 156,
#     'SGEG': 156,
#     '42VA': 155,
#     '49KY': 155,
#     'SC39': 154,
#     'VTST': 153,
#     'CAM5': 153,
#     '1MN5': 153,
#     'CED3': 153,
#     'CJU4': 152,
#     '2SC5': 152,
#     '1WA6': 152,
#     'NY89': 152,
#     'TX35': 152,
#     'LFGJ': 151,
#     'AR29': 151,
#     'KBQP': 151,
#     '2XA5': 151,
#     'MO74': 150,
#     '39CN': 150,
#     'JSTR': 149,
#     '9WN2': 149,
#     '53XS': 149,
#     'KMGG': 149,
#     'LL87': 149,
#     'PHLU': 148,
#     '58WA': 148,
#     'IA27': 148,
#     'EETN': 148,
#     'CFG5': 147,
#     'K069': 147,
#     '5FL7': 147,
#     'IA22': 146,
#     'KLBR': 146,
#     'VA62': 146,
#     '5TN4': 146,
#     'LTBJ': 145,
#     '07MT': 145,
#     'OR70': 144,
#     '1AZ8': 144,
#     'KLZD': 144,
#     '2TA8': 143,
#     'VT61': 143,
#     'LOWI': 143,
#     'KRYM': 143,
#     'AK75': 142,
#     '58XS': 142,
#     'WIHH': 141,
#     'NC20': 141,
#     '91TS': 141,
#     '64WA': 140,
#     '53CL': 140,
#     'CGL4': 140,
#     '0WA1': 140,
#     'TE29': 139,
#     'KAQP': 139,
#     '4NY8': 139,
#     'CDU6': 139,
#     '31VA': 139,
#     'CFA7': 139,
#     'ABGR': 138,
#     'CFU4': 138,
#     '0KY0': 138,
#     'CNT7': 138,
#     'MYEN': 138,
#     'YPPH': 137,
#     'KDLC': 136,
#     'CDO2': 136,
#     'PS01': 136,
#     'W387': 136,
#     'MMZT': 136,
#     'KTKC': 136,
#     'MDSI': 135,
#     'CHM2': 134,
#     '74IS': 134,
#     'FL60': 134,
#     'CYFE': 134,
#     '64TE': 133,
#     'ZSSS': 133,
#     '38OH': 133,
#     'SBPA': 133,
#     'LL25': 132,
#     'CCE3': 132,
#     'WS39': 132,
#     'CYLK': 132,
#     'SAES': 132,
#     '02WA': 131,
#     'PN09': 131,
#     'K4D0': 131,
#     'NC99': 131,
#     'KSZP': 131,
#     'SBKO': 131,
#     'CZFA': 131,
#     'CO92': 130,
#     '73TE': 130,
#     'CJT5': 129,
#     'WMSA': 128,
#     '8XS9': 128,
#     '8IN1': 128,
#     '4WN7': 128,
#     'KSYV': 127,
#     'VVCT': 126,
#     'FL11': 126,
#     'CKQ6': 126,
#     'XA05': 125,
#     '30IS': 125,
#     'CFX6': 125,
#     'CLM2': 125,
#     'MD83': 124,
#     'KDKR': 124,
#     'KLYO': 124,
#     'CFF4': 122,
#     '0TE7': 122,
#     '8VA5': 122,
#     'LIBR': 122,
#     'PABA': 122,
#     'KMPI': 122,
#     'TS69': 121,
#     'MUHU': 121,
#     'K8D4': 121,
#     'KEBD': 120,
#     'MD97': 120,
#     '2NC7': 120,
#     'FD77': 120,
#     'KGDM': 120,
#     'OK03': 120,
#     'CEV5': 119,
#     'OERY': 119,
#     '90IA': 119,
#     'KN51': 119,
#     '74NY': 119,
#     '04FA': 119,
#     'TE02': 118,
#     '23PN': 117,
#     'CPE6': 117,
#     'CBR2': 117,
#     'TS04': 116,
#     'OH54': 116,
#     'LYPG': 116,
#     '1NK7': 115,
#     'CAP3': 115,
#     'KT20': 115,
#     'KJRB': 115,
#     'FGSL': 115,
#     'PAPH': 114,
#     'KTVB': 114,
#     'KD09': 113,
#     'CJV4': 113,
#     'KCDA': 113,
#     'ARWR': 112,
#     'MO56': 112,
#     '0OH8': 112,
#     '66CA': 112,
#     'W260': 111,
#     'K4J2': 111,
#     'PN76': 110,
#     'CSP5': 110,
#     'VVTS': 110,
#     'KHTH': 110,
#     'CCZ3': 109,
#     'AGGH': 109,
#     'IA25': 109,
#     'XS09': 109,
#     'HADR': 108,
#     'CA32': 108,
#     'CCJ3': 108,
#     'RKPD': 108,
#     'WA77': 108,
#     'NH69': 108,
#     'MD50': 108,
#     '36AL': 108,
#     'CCZ4': 107,
#     'PA25': 107,
#     '8MN1': 107,
#     'TE30': 106,
#     'MN34': 106,
#     '1PS8': 106,
#     '73WA': 105,
#     '9CL2': 105,
#     'TA34': 105,
#     'PAGY': 105,
#     'CSL5': 104,
#     'PA49': 104,
#     'CYCA': 104,
#     'BAY1': 104,
#     'PHDH': 104,
#     'MS59': 104,
#     'NJ08': 103,
#     'KEGI': 103,
#     'MO76': 103,
#     'CSL3': 103,
#     'RPLB': 103,
#     'CEM4': 103,
#     '37TN': 103,
#     'KOKB': 102,
#     '56MU': 102,
#     '13GA': 102,
#     'CSX7': 101,
#     'TE73': 101,
#     'CPR7': 101,
#     '2TA6': 101,
#     'CYFR': 101,
#     'TJCP': 101,
#     'AR22': 100,
#     'KODG': 100,
#     'YBTL': 100,
#     '0NY7': 100,
#     '40AR': 100,
#     'CKW6': 99,
#     'KMUI': 99,
#     'EKTS': 99,
#     '12ID': 98,
#     'WI34': 97,
#     '17MD': 97,
#     'KBYS': 96,
#     '0CO2': 96,
#     'SPYL': 96,
#     'SPZO': 95,
#     'CSN8': 95,
#     '68WI': 95,
#     '40IN': 95,
#     'CJN5': 95,
#     'CYMJ': 94,
#     'CYGZ': 94,
#     '41NY': 94,
#     'OEKK': 93,
#     '2WI4': 93,
#     '24TN': 93,
#     'CPW8': 93,
#     'NFNA': 93,
#     'TX42': 93,
#     'KNOG': 92,
#     '86WA': 92,
#     'ENML': 92,
#     '55KS': 92,
#     'CEN2': 92,
#     '08MO': 92,
#     'TN37': 92,
#     '62WI': 91,
#     'ZLXY': 91,
#     'CEP5': 91,
#     'MU37': 91,
#     'ZSFZ': 91,
#     '1GA2': 91,
#     'KRCT': 90,
#     '65KY': 90,
#     '7FA0': 90,
#     '01MT': 90,
#     'CYDP': 90,
#     'NR82': 89,
#     '41NC': 89,
#     'XS01': 89,
#     'CJN2': 89,
#     'CWAQ': 89,
#     'IA64': 89,
#     'CEJ6': 89,
#     'PASD': 88,
#     'SVCJ': 88,
#     'CDD3': 88,
#     'MBHB': 88,
#     '97MN': 88,
#     'KJQD': 88,
#     'KCXE': 88,
#     'RPLC': 87,
#     'CKB7': 87,
#     '7PA3': 87,
#     'ID92': 87,
#     'KCNP': 86,
#     '2AZ9': 86,
#     '58CL': 86,
#     'OH49': 86,
#     '04IL': 86,
#     'OH56': 86,
#     'TVSU': 86,
#     'GBYD': 85,
#     'CL56': 85,
#     'ARTR': 85,
#     'TXKR': 85,
#     'KMDA': 84,
#     '81NC': 84,
#     '7TS0': 84,
#     'LTCJ': 84,
#     'FL84': 84,
#     'CPB8': 83,
#     '51MO': 83,
#     'CYJA': 83,
#     'LDSP': 83,
#     'EWNR': 83,
#     'KSBU': 83,
#     'CAT5': 83,
#     '3TN3': 83,
#     'WIII': 83,
#     'XXXX': 83,
#     'DEAP': 82,
#     'FL12': 82,
#     'KHZX': 82,
#     'MMGT': 82,
#     'XS99': 82,
#     'LFMQ': 82,
#     'CEP3': 81,
#     'RJNK': 81,
#     'CYFT': 81,
#     'KAAA': 81,
#     'SBMO': 81,
#     'ELMR': 81,
#     'MD14': 81,
#     'KNJM': 80,
#     'VT52': 80,
#     '44TS': 80,
#     '7IS2': 80,
#     '3TS1': 79,
#     '5CT7': 79,
#     '0TE4': 79,
#     'WA53': 79,
#     '65CL': 79,
#     '48TX': 78,
#     '5GA4': 78,
#     'CNL4': 78,
#     'HXDR': 78,
#     'GLRB': 78,
#     '45XS': 78,
#     'LEVX': 78,
#     'KERR': 78,
#     'IA24': 78,
#     'GCXO': 78,
#     '61TA': 78,
#     'SVFM': 77,
#     'MKFP': 77,
#     '35TN': 77,
#     '57TE': 77,
#     '15CA': 76,
#     'HERE': 76,
#     'FA43': 76,
#     'FD93': 76,
#     '0PA6': 76,
#     'CFS6': 76,
#     'LA33': 76,
#     'MGTK': 76,
#     '43OK': 75,
#     '37LS': 75,
#     'USSS': 75,
#     'YMEN': 75,
#     'NVVV': 75,
#     'RJBE': 75,
#     'WA67': 75,
#     'CA37': 74,
#     'LCLK': 74,
#     'BGRR': 74,
#     'UEEE': 74,
#     '63XS': 73,
#     'RJNS': 73,
#     'CYEA': 73,
#     'MS39': 73,
#     '62MD': 73,
#     'KBLU': 72,
#     '15NJ': 72,
#     '82GA': 72,
#     'CBW7': 72,
#     'MKSP': 72,
#     'SKSM': 72,
#     'YMMB': 71,
#     'AK45': 70,
#     'NV27': 70,
#     'WA87': 70,
#     'CJP6': 70,
#     'CYHE': 69,
#     'LFVM': 69,
#     'CNF8': 69,
#     'LGKF': 69,
#     'AL71': 69,
#     'XA62': 69,
#     '9KY9': 69,
#     '6MS1': 69,
#     '9IS2': 69,
#     'KRBM': 69,
#     'KS21': 69,
#     'XS12': 69,
#     'SC81': 68,
#     '00IN': 67,
#     '7TE6': 67,
#     '4CA2': 67,
#     '24II': 67,
#     '2XS2': 67,
#     '8XS8': 66,
#     '53FD': 66,
#     'WI97': 66,
#     'KSXL': 65,
#     'MN86': 65,
#     '19NC': 65,
#     '5VG1': 65,
#     'VTBS': 65,
#     'MUOC': 65,
#     'PA91': 65,
#     '8WI2': 65,
#     '3MI2': 64,
#     '2NM9': 64,
#     'CPB9': 64,
#     'FA49': 64,
#     'MKPN': 64,
#     'NH78': 64,
#     'NC61': 64,
#     'CA20': 64,
#     'VTBD': 63,
#     '38MI': 63,
#     'KVIQ': 63,
#     'CNH2': 62,
#     'GGOV': 62,
#     '34TS': 62,
#     '2GA2': 62,
#     '04CA': 62,
#     '2TN5': 61,
#     'MD22': 61,
#     'TRIR': 61,
#     'WABB': 61,
#     'VGHS': 61,
#     '1GE7': 60,
#     '1MI3': 60,
#     'NC01': 60,
#     'MMXS': 60,
#     'CSY3': 60,
#     'CRF5': 60,
#     'LA15': 59,
#     'K4B8': 59,
#     '72FL': 59,
#     'KHLR': 59,
#     'K74S': 59,
#     'CJR2': 59,
#     'FL66': 59,
#     'OI68': 59,
#     '7LA5': 58,
#     'GMMI': 58,
#     '6WI3': 58,
#     'EDNR': 58,
#     'WI88': 57,
#     '68CA': 57,
#     'AK04': 57,
#     'MN14': 57,
#     '55LL': 56,
#     'ULWR': 56,
#     'PS81': 56,
#     'CEN9': 56,
#     'TUPW': 56,
#     'DFOO': 56,
#     'SPST': 56,
#     '03WT': 56,
#     '45LA': 56,
#     'KSOA': 56,
#     '7WA5': 55,
#     '4IA2': 55,
#     'MMZM': 55,
#     'LS96': 55,
#     'CA51': 54,
#     'CNC7': 54,
#     'NK83': 54,
#     '36MO': 54,
#     '4IS3': 54,
#     'CPD8': 53,
#     '67PN': 53,
#     'K9G0': 53,
#     'OR93': 53,
#     'GE05': 53,
#     '5WI2': 53,
#     'YMAV': 53,
#     'CT88': 53,
#     '0XA2': 52,
#     'WN18': 52,
#     'CRL7': 52,
#     'EFSO': 52,
#     'LA77': 52,
#     '16GA': 52,
#     'CJW4': 52,
#     'CSR6': 51,
#     '57NC': 51,
#     'BOQU': 51,
#     'ZGOW': 51,
#     '2CA4': 51,
#     'MMUW': 51,
#     '30AR': 50,
#     'CA03': 50,
#     'WV45': 50,
#     'CRS3': 50,
#     'RJOT': 50,
#     '1XS1': 50,
#     'LEZL': 50,
#     'OR41': 49,
#     'IS67': 49,
#     'OK06': 49,
#     'SABZ': 49,
#     '6GA4': 49,
#     'MPPO': 49,
#     '3J1R': 49,
#     'LIPY': 48,
#     'SPQU': 48,
#     'MD46': 48,
#     'VA85': 48,
#     'OI53': 48,
#     'YBCG': 47,
#     '9NY1': 47,
#     'CCP3': 47,
#     'RCNN': 47,
#     'ANYN': 47,
#     'TN24': 46,
#     '01CL': 46,
#     'MYRD': 46,
#     'KMQW': 46,
#     'CDJ4': 46,
#     'AR40': 46,
#     '23AR': 46,
#     '27AK': 45,
#     'SQEM': 45,
#     'MT95': 45,
#     '01WI': 45,
#     'CJP2': 45,
#     'PN22': 45,
#     'PS57': 45,
#     '08XA': 44,
#     'CCZ2': 44,
#     '0GA1': 44,
#     'LFLS': 44,
#     '7FD1': 44,
#     'CYXQ': 44,
#     '64FD': 44,
#     'MD05': 44,
#     'K1N7': 44,
#     'SCMI': 43,
#     '75DC': 43,
#     'CKD5': 43,
#     'CFB5': 43,
#     'KYYZ': 43,
#     'OH29': 43,
#     'MS71': 43,
#     'CYDM': 43,
#     'BGSS': 43,
#     'KUIL': 42,
#     '4NK0': 42,
#     'TPKN': 42,
#     'PHKR': 42,
#     'MEPB': 42,
#     'WMKL': 42,
#     'MNMF': 42,
#     'VYYY': 42,
#     'FD97': 42,
#     'NH17': 42,
#     '2NH4': 42,
#     '0OH7': 41,
#     'NK78': 41,
#     'CPL4': 41,
#     'SVBG': 41,
#     '0AL4': 41,
#     'KLTY': 41,
#     'CCD4': 40,
#     'CYHO': 40,
#     'VA47': 40,
#     '3TA4': 40,
#     'EGTK': 40,
#     '9OA5': 40,
#     'XS44': 39,
#     '8OR9': 39,
#     '9MN7': 39,
#     'MMCR': 39,
#     'FA61': 39,
#     'SVVG': 39,
#     'CYKD': 39,
#     'CTG2': 39,
#     'PN74': 38,
#     '29LA': 38,
#     'LDSB': 38,
#     'MCOC': 38,
#     'CJL6': 38,
#     '8GA1': 38,
#     'CNM6': 38,
#     'GE11': 38,
#     'SBRG': 38,
#     'CEY3': 37,
#     'KS43': 37,
#     'KW28': 37,
#     '01WN': 37,
#     'PA04': 37,
#     '7MD5': 37,
#     'KCDK': 37,
#     'PAHV': 37,
#     'JB01': 37,
#     'PA57': 37,
#     '2WV3': 36,
#     'CA90': 36,
#     'CKV8': 36,
#     'MA10': 36,
#     '82MN': 36,
#     'NZWN': 36,
#     'KTKO': 36,
#     'MMNG': 36,
#     '34TN': 36,
#     'NY49': 36,
#     '7NC6': 36,
#     '36KY': 36,
#     '8WA6': 36,
#     'CYWE': 36,
#     'UMRS': 35,
#     'CT24': 35,
#     'K9G3': 35,
#     'MY72': 35,
#     'CKX2': 34,
#     'CDU3': 34,
#     'LJFK': 34,
#     'VXVR': 34,
#     'WS89': 34,
#     'MYAB': 34,
#     'TA44': 34,
#     '1IA3': 34,
#     'KTYL': 34,
#     'OH46': 34,
#     'MUGN': 34,
#     'MTTP': 33,
#     'CGR3': 33,
#     '65KS': 33,
#     '4KY2': 33,
#     'SMVI': 33,
#     '1VG2': 33,
#     'ZWWW': 33,
#     'MS81': 32,
#     'KOCS': 32,
#     'LL42': 32,
#     'DRCT': 32,
#     '6NC7': 32,
#     'VG45': 32,
#     '49PN': 32,
#     'K17S': 32,
#     'LFBQ': 32,
#     'CSM5': 32,
#     'CAT6': 31,
#     '46KS': 31,
#     'LDOS': 31,
#     '93KY': 31,
#     '73TA': 31,
#     '2IN7': 31,
#     '19VA': 30,
#     '97IS': 30,
#     '25FA': 30,
#     'CNJ3': 30,
#     'FA81': 30,
#     'CYZW': 30,
#     '7WA2': 30,
#     'MD25': 30,
#     'AYBK': 30,
#     'WT01': 30,
#     'KMDF': 30,
#     'VT23': 30,
#     '98PN': 29,
#     'AK20': 29,
#     '4NC4': 29,
#     'TLHR': 29,
#     '97IL': 29,
#     '3WI9': 29,
#     'GA61': 29,
#     '8WA4': 28,
#     'CYCT': 28,
#     'XA61': 28,
#     'WN02': 28,
#     '77AK': 28,
#     'MBAC': 28,
#     '72VA': 28,
#     '61MN': 28,
#     'AR80': 28,
#     'GGGR': 28,
#     '0MN7': 28,
#     'CYEU': 27,
#     '55TN': 27,
#     'MPTD': 27,
#     'UHSS': 27,
#     'NZCH': 27,
#     '24SC': 27,
#     'BBAF': 27,
#     '49NY': 26,
#     'MD49': 26,
#     'MMTY': 26,
#     'KMMT': 26,
#     'KEEO': 26,
#     '4PA6': 26,
#     '13IN': 26,
#     '8MN7': 26,
#     'CL35': 26,
#     'VDSR': 26,
#     'MDLO': 25,
#     'CYMH': 25,
#     '5PS1': 25,
#     'NJ48': 25,
#     'VT11': 25,
#     'CBV8': 25,
#     'CBK8': 24,
#     'CYAL': 24,
#     'KS28': 24,
#     'CRT2': 24,
#     'XA08': 24,
#     'EGCN': 24,
#     'GA31': 23,
#     'KM19': 23,
#     '6MN9': 23,
#     '94PN': 23,
#     'NFTF': 23,
#     'TN19': 23,
#     'SLCP': 23,
#     'UKKM': 23,
#     'LICP': 23,
#     'AYWK': 23,
#     'CPP6': 23,
#     'OMDW': 23,
#     'LFRH': 22,
#     'NH27': 22,
#     '4AR8': 22,
#     'KS36': 22,
#     'AK59': 21,
#     'MDPV': 21,
#     'CKQ5': 21,
#     'CYJP': 21,
#     '9MN3': 21,
#     '25WI': 21,
#     '66PA': 21,
#     'PA29': 21,
#     'IS29': 21,
#     'MUCA': 20,
#     '26TN': 20,
#     '9NR8': 20,
#     'KS60': 20,
#     'NSAP': 20,
#     'WS35': 20,
#     'CMN4': 20,
#     'CKS8': 20,
#     'SD52': 20,
#     'PN40': 20,
#     'VIAG': 19,
#     'LA59': 19,
#     'WV69': 19,
#     'MN39': 19,
#     '45PA': 19,
#     'MQJP': 19,
#     '3MD4': 19,
#     'MSDS': 19,
#     'NV30': 19,
#     'KDVP': 19,
#     'KCDD': 18,
#     '29TN': 18,
#     'AK28': 18,
#     'NK19': 18,
#     'K7S3': 18,
#     '66OI': 18,
#     'K1G0': 18,
#     'GSBR': 18,
#     '9PA8': 18,
#     'CCD2': 18,
#     'MD12': 18,
#     '8MO9': 18,
#     'ZMUB': 18,
#     'CYJF': 18,
#     'CJX5': 17,
#     'LA09': 17,
#     '2WI3': 17,
#     'WN29': 17,
#     'CDL7': 17,
#     'K83D': 17,
#     '90AK': 17,
#     '48FD': 16,
#     '22PA': 16,
#     'KE25': 16,
#     'SVVC': 16,
#     '8PS5': 16,
#     'PAUT': 16,
#     '20TN': 16,
#     'AL52': 16,
#     'VT46': 15,
#     'CNG2': 15,
#     'ROAR': 15,
#     'LSZM': 15,
#     'VTCC': 15,
#     'MHSC': 15,
#     'MD47': 15,
#     'RCKW': 15,
#     'AA27': 15,
#     '0IL5': 15,
#     'CPE5': 15,
#     'RJCK': 15,
#     '19IA': 15,
#     '09IA': 15,
#     'CYVL': 15,
#     'DAAK': 15,
#     'XS11': 14,
#     '5CL2': 14,
#     'CT01': 14,
#     'IL89': 14,
#     'KPFC': 14,
#     'RCPT': 14,
#     'PN45': 14,
#     'K46U': 14,
#     'ZGSG': 14,
#     '27AR': 14,
#     'AK32': 14,
#     'PFTO': 14,
#     'KS50': 13,
#     'PPVD': 13,
#     '2VA9': 13,
#     '5MI5': 13,
#     'PA46': 12,
#     'W72A': 12,
#     'SGEM': 12,
#     'VG62': 12,
#     'CCK3': 12,
#     'MYGW': 12,
#     'XFCO': 12,
#     'MD24': 12,
#     'CPT9': 12,
#     '79WI': 11,
#     '7NK8': 11,
#     '01SC': 11,
#     'LPHR': 11,
#     'CEZ2': 11,
#     'CPD7': 10,
#     '3KY4': 10,
#     'TA00': 10,
#     'CD27': 10,
#     'PBIR': 10,
#     'RJAF': 9,
#     'PA24': 9,
#     'JY31': 9,
#     'KNYG': 9,
#     'KU02': 9,
#     'SC02': 9,
#     '09TA': 9,
#     '3MD0': 8,
#     'K4N1': 8,
#     'KI19': 8,
#     '63IN': 8,
#     'CYSQ': 8,
#     'CDV3': 7,
#     'CEL6': 7,
#     'CLA4': 7,
#     'CYDB': 7,
#     'KN98': 7,
#     '9NY9': 7,
#     'PA60': 7,
#     '3FL0': 7,
#     'IN74': 7,
#     'MO11': 7,
#     'KS31': 7,
#     'KEDG': 7,
#     'IS08': 7,
#     'MVUR': 7,
#     'PAII': 7,
#     'SEAZ': 7,
#     '50VA': 6,
#     'MPBO': 6,
#     'RPLI': 6,
#     'EGPC': 6,
#     'SC07': 6,
#     'KN66': 6,
#     'OK12': 6,
#     'CYWY': 6,
#     'W134': 5,
#     'WV52': 5,
#     '97FL': 5,
#     '8TN4': 5,
#     'DC08': 5,
#     'MBPC': 5,
#     'SC90': 5,
#     'MSDT': 5,
#     'KI17': 5,
#     'MD33': 5,
#     'KS39': 5,
#     'II74': 5,
#     'LEAS': 5,
#     'CYLT': 5,
#     'PODX': 5,
#     'MDSS': 5,
#     'K3CK': 5,
#     '7CL1': 5,
#     'K0A7': 5,
#     '2WA7': 5,
#     '60NC': 5,
#     'PAWS': 4,
#     '7NJ3': 4,
#     'KLRP': 4,
#     'K48D': 4,
#     'TE81': 4,
#     'PN75': 4,
#     'KIRW': 4,
#     'TN93': 4,
#     'KPVT': 4,
#     '7NC1': 4,
#     'KD95': 4,
#     'LECO': 4,
#     'LL84': 4,
#     'VA82': 4,
#     'CZFN': 4,
#     '37PN': 4,
#     'SKBR': 4,
#     '2FD7': 4,
#     'SAWG': 4,
#     'K2S6': 3,
#     'SAZS': 3,
#     'SBRP': 3,
#     'KNXP': 3,
#     'K23S': 3,
#     'NC91': 3,
#     'KD38': 3,
#     'MD11': 3,
#     'VA18': 3,
#     'LFBG': 3,
#     'SC21': 3,
#     '4AR5': 3,
#     'KMJS': 3,
#     '1MS3': 3,
#     'VI32': 3,
#     'MYAS': 3,
#     'MPTP': 3,
#     'CRE2': 3,
#     'KF70': 3,
#     'STC1': 3,
#     'K7G0': 3,
#     'NJ25': 3,
#     '08OK': 3,
#     'CHQE': 3,
#     'RDUR': 3,
#     '25TN': 3,
#     '4TN3': 3,
#     'TTTP': 3,
#     'MEMR': 3,
#     '49IS': 3,
#     'CHB3': 3,
#     'NH57': 3,
#     'NY15': 3,
#     'CCV4': 3,
#     'SLTR': 3,
#     'K39N': 3,
#     'EBFS': 3,
#     'LYZE': 3,
#     '25XS': 3,
#     '5IL3': 3,
#     'SVCY': 3,
#     'CEJ9': 3,
#     '67VT': 3,
#     'WI15': 3,
#     '4NC6': 2,
#     '9CO3': 2,
#     'NE40': 2,
#     'OI79': 2,
#     'LHPA': 2,
#     'MI97': 2,
#     '76OH': 2,
#     '5IS8': 2,
#     'SASA': 2,
#     'SPRU': 2,
#     'BSVR': 2,
#     'CSE3': 2,
#     '8II2': 2,
#     'KDRA': 2,
#     'WV06': 2,
#     '9IN3': 2,
#     '6MU4': 2,
#     '47IN': 2,
#     'SN78': 2,
#     'CCP4': 2,
#     'PN30': 2,
#     '10NC': 2,
#     'CFC4': 2,
#     'TJAB': 2,
#     '94KS': 2,
#     '0MD3': 2,
#     'KS24': 2,
#     'KCGS': 2,
#     'MD95': 2,
#     'MGMM': 2,
#     'LSPG': 2,
#     'MMUR': 2,
#     '9FL9': 2,
#     '13PA': 2,
#     'MNNG': 2,
#     'K36U': 2,
#     'CYHT': 2,
#     'K80T': 2,
#     '6NC8': 2,
#     '5IN0': 2,
#     'ALPR': 2,
#     'CKM2': 2,
#     'TN46': 2,
#     'MDOC': 2,
#     '47TX': 2,
#     'KSFD': 2,
#     'SECL': 2,
#     'SN36': 2,
#     'KS98': 2,
#     '91PN': 2,
#     'TN72': 2,
#     'KY73': 2,
#     'K6S0': 2,
#     'K2B7': 2,
#     'K02C': 2,
#     '05IA': 2,
#     '50XS': 2,
#     'CEU9': 2,
#     '64PA': 2,
#     'ME76': 2,
#     'K14G': 1,
#     'KBTO': 1,
#     'MHTO': 1,
#     'TA75': 1,
#     'SEKL': 1,
#     'MKHC': 1,
#     'K5U7': 1,
#     '1MS8': 1,
#     'KOED': 1,
#     'SUMI': 1,
#     'CKYT': 1,
#     'VA11': 1,
#     'K2W6': 1,
#     'SASV': 1,
#     '3IA6': 1,
#     'EGGL': 1,
#     'WI78': 1,
#     'KNY0': 1,
#     '1LBB': 1,
#     'CET4': 1,
#     '5PA5': 1,
#     'KLBG': 1,
#     'XLKE': 1,
#     'CLTR': 1,
#     '7OH0': 1,
#     'NM62': 1,
#     '15MA': 1,
#     'MHTF': 1,
#     'SYJC': 1,
#     'CPW2': 1,
#     'RECR': 1,
#     '3CL0': 1,
#     'AL43': 1,
#     'TAPH': 1,
#     'EIME': 1,
#     '6OH0': 1,
#     'K01G': 1,
#     'KCEO': 1,
#     'FSMR': 1,
#     'K6D6': 1,
#     'IA04': 1,
#     'AK13': 1,
#     'SBKB': 1,
#     'GNVR': 1,
#     'OR55': 1,
#     'W168': 1,
#     'KRAV': 1,
#     'KS52': 1,
#     'FNTT': 1,
#     '6OI8': 1,
#     '11WI': 1,
#     'SKGR': 1,
#     '8VA7': 1,
#     'K1B1': 1,
#     'CSM8': 1,
#     'KANC': 1,
#     'FAKR': 1,
#     'SPMS': 1,
#     'FL61': 1,
#     'LIRI': 1,
#     'K59B': 1,
#     'K7S1': 1,
#     'MKJB': 1,
#     'LL38': 1,
#     '75PN': 1,
#     'FIMP': 1,
#     'HMVR': 1,
#     'SFBB': 1,
#     'CRER': 1,
#     'KCWM': 1,
#     'KADA': 1,
#     'SPBA': 1,
#     'KO69': 1,
#     '9MI9': 1,
#     'NJ87': 1,
#     'NKTR': 1,
#     'SEGR': 1,
#     'WA55': 1,
#     'MO91': 1,
#     'CPS9': 1,
#     'BGPT': 1,
#     'K1RL': 1,
#     'SBBG': 1,
#     'CKH9': 1,
#     'K3T5': 1,
#     'HTSY': 1,
#     'SAEG': 1,
#     '76FL': 1,
#     'KTMT': 1,
#     'PA41': 1,
#     'HHXD': 1,
#     'K3CM': 1,
#     'WBGR': 1,
#     'OH59': 1,
#     'KPOA': 1,
#     'KLVY': 1,
#     'PNHL': 1,
#     'KN03': 1,
#     '65NJ': 1,
#     'MTHG': 1,
#     'CAL5': 1,
#     '09VG': 1,
#     'KITL': 1,
#     'SAWA': 1,
#     'K2S4': 1,
#     'CHSR': 1,
#     'TTCM': 1,
#     'SAZE': 1,
#     '8TA0': 1,
#     'FYER': 1,
#     'KS27': 1,
#     'SKRO': 1,
#     'MA72': 1,
#     '15GA': 1,
#     'XA00': 1,
#     'K4S2': 1,
#     '14OH': 1,
#     'WN73': 1,
#     'KS03': 1,
#     'K57B': 1,
#     'GTRR': 1,
#     'LOWL': 1,
#     'MUMG': 1,
#     'OK01': 1,
#     '16NC': 1,
#     'PACI': 1,
#     'LBER': 1,
#     '0MD9': 1,
#     'KN93': 1,
#     'MN16': 1,
#     'KHAD': 1,
#     'AFIN': 1,
#     '8PS9': 1,
#     '8PS7': 1,
#     '44NH': 1,
#     'MQPR': 1,
#     'FA45': 1,
#     'LBTA': 1,
#     'NK61': 1,
#     'KN07': 1,
#     'VA29': 1,
#     'KL35': 1,
#     'SQUM': 1,
#     'SBLF': 1,
#     'SVLR': 1,
#     'K1H2': 1,
#     '48FL': 1,
#     'MQQY': 1,
#     'ZBTJ': 1,
#     'MFPP': 1,
#     '48KY': 1,
#     'KBOC': 1,
#     'KDYW': 1,
#     'MD35': 1,
#     'UTAR': 1,
#     'ZBHH': 1,
#     'SCDE': 1,
#     'KC62': 1,
#     '7NC3': 1,
#     'DUCR': 1,
#     'K2O3': 1,
#     'MN59': 1
# }

