#!/usr/bin/env bash

set -ex

export THRUST_BUILD_DIR="${SRC_DIR}/build"
export BUILD_TESTS=OFF
export BUILD_EXAMPLES=OFF
export BUILD_TYPE=Release
export VERBOSE_FLAG="-v"

mkdir -p ${THRUST_BUILD_DIR}
cd ${SRC_DIR}

cmake -DCMAKE_INSTALL_PREFIX="${PREFIX}" \
      -DCMAKE_INSTALL_LIBDIR="${PREFIX}/lib" \
      -DCMAKE_BUILD_TYPE=${BUILD_TYPE} \
      -DTHRUST_ENABLE_HEADER_TESTING=${BUILD_TESTS} \
      -DTHRUST_ENABLE_TESTING=${BUILD_TESTS} \
      -DTHRUST_ENABLE_EXAMPLES=${BUILD_EXAMPLES} \
      -DTHRUST_INCLUDE_CUB_CMAKE=OFF \
      -DTHRUST_INSTALL_CUB_HEADERS=OFF \
      -B "${THRUST_BUILD_DIR}" \
      -S .

cmake --build "${THRUST_BUILD_DIR}" --target install ${VERBOSE_FLAGS}
