# Recommended cmake macro use to write a cmake config file.

####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was ThermoHubClientConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

# Ensure dependencies from the conda environment are used (e.g., Boost).
list(APPEND CMAKE_PREFIX_PATH $ENV{CONDA_PREFIX})

# Include the cmake targets of the project if they have not been yet.
if(NOT TARGET ThermoHubClient::ThermoHubClient)
    include("${PACKAGE_PREFIX_DIR}/lib/cmake/ThermoHubClient/ThermoHubClientTargets.cmake")
endif()

# Recommended check at the end of a cmake config file.
check_required_components(ThermoHubClient)
