// Copyright (C) 2020 G. D. Miron, D. A. Kulik, S. V Dmytrieva
// 
// thermohubclient is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// thermohubclient is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public License
// along with thermohubclient. If not, see <http://www.gnu.org/licenses/>.

#include <string>

namespace ThermoHubClient
{
const std::string aql_thermofun_database_from_thermodataset =   
"/* clean the result with vs code \n "
"replace ^.*null.*,$\n with empty \n "
" \n "
"replace ,\n^.*null.*$\n with \n \n "
" \n "
"*/ \n "
" \n "
"// Query works only for GEM and GEM-LMA ThermoDataSet traversing on edge pulls \n "
" \n "
"/* Get ThermoDataSet*/ \n"
"LET tds = ( \n"
"   FOR t in thermodatasets FILTER t._id == @idThermoDataSet RETURN t.properties.symbol \n"
") \n"
"/* Get Elements */ \n "
"LET elements_ = ( \n "
"   FOR v,e IN 1..1 INBOUND @idThermoDataSet basis \n "
"        FILTER v._label == 'element' \n "
"        LET references_ = ( \n "
"            FOR rf IN 1..1 OUTBOUND v citing \n "
"            RETURN rf.properties.shortname // substances_[*][*].id \n "
"        )  \n "
"        RETURN { \n "
"            symbol: v.properties.symbol, \n "
"            class_:   v.properties.class_, \n "
"            entropy : v.properties.entropy, \n "
"            atomic_mass : v.properties.atomic_mass, \n "
"            datasources : v.properties.datasources \n "
"//            _label : 'element' \n "
"        } \n "
") \n "
"/* Get Substances */ \n "
"LET substances_ = ( \n "
"   FOR s,e IN 1..1 INBOUND @idThermoDataSet pulls \n "
"        FILTER s._label == 'substance' \n "
"        FILTER s.properties.symbol IN @symbolList \n"
"        FILTER s.properties.class_ IN @class_List \n"
"        FILTER s.properties.aggregate_state IN @aggregate_stateList \n"
"        LET reaction_symbol = ( \n "
"            FOR r IN 1..1 INBOUND s defines \n "
"            RETURN r.properties.symbol \n "
"        ) \n "
"        LET references_ = ( \n "
"            FOR rf IN 1..1 OUTBOUND s citing \n "
"            RETURN rf.properties.shortname // substances_[*][*].id \n "
"        ) \n "
"        RETURN { \n " 
"            name:   s.properties.name, \n "
"            symbol: s.properties.symbol, \n "
"            formula:    s.properties.formula, \n "
"            formula_charge: s.properties.formula_charge, \n "
"            reaction : reaction_symbol[0], \n "
"//            mass_per_mole:  s.properties.mass_per_mole, \n "
"            aggregate_state:    s.properties.aggregate_state, \n "
"            class_:    s.properties.class_, \n "
"            limitsTP:   s.properties.limitsTP, \n "
"            Tst:    s.properties.Tst, \n "
"            Pst:    s.properties.Pst, \n "
"            TPMethods:  s.properties.TPMethods, \n "
"            sm_heat_capacity_p: s.properties.sm_heat_capacity_p, \n "
"            sm_gibbs_energy:    s.properties.sm_gibbs_energy, \n "
"            sm_enthalpy:    s.properties.sm_enthalpy, \n "
"            sm_entropy_abs: s.properties.sm_entropy_abs, \n "
"            sm_volume:  s.properties.sm_volume, \n "
"            m_compressibility: s.properties.m_compressibility, \n "
"            m_expansivity: s.properties.m_expansivity, \n "
"            datasources : s.properties.datasources \n "
"//            _label : 'substance' \n "
"//            id: s._id \n "
"        } \n "
") \n "
"/* Get Reactions */ \n "
"LET reactions_ = ( \n "
"   FOR s,e IN 1..1 INBOUND @idThermoDataSet pulls \n "
"        FILTER s._label == 'substance' \n "
"        FILTER s.properties.symbol IN @symbolList \n"
"        FILTER s.properties.class_ IN @class_List \n"
"        FILTER s.properties.aggregate_state IN @aggregate_stateList \n"
"        FOR r IN 1..1 INBOUND s defines \n "
"        LET reactants_ = ( \n "
"            FOR ss, t IN 1..1 INBOUND r takes \n "
"/*            LET ids_2 = PUSH(ids_, ss._id, true) /* add substance id to idlist */ \n "
"            RETURN { \n "
"                symbol: ss.properties.symbol, \n "
"                coefficient: t.properties.stoi_coeff \n "
"//                id: ss._id \n "
"            } \n "
"        ) \n "
"        LET references_ = ( \n "
"            FOR rf IN 1..1 OUTBOUND r citing \n "
"            RETURN rf.properties.shortname // substances_[*][*].id \n "
"        ) \n "
"        RETURN { \n "
"//            name:   r.properties.name, \n "
"            symbol: r.properties.symbol, \n "
"//            substance : s.properties.symbol, \n "
"            equation:    r.properties.equation, \n "
"            reactants: reactants_, \n "
"            limitsTP:   r.properties.limitsTP, \n "
"            Tst:    r.properties.Tst, \n "
"            Pst:    r.properties.Pst, \n "
"            TPMethods:  r.properties.TPMethods, \n "
"            logKr : r.properties.logKr, \n "
"            drsm_heat_capacity_p : r.properties.drsm_heat_capacity_p, \n "
"            drsm_gibbs_energy : r.properties.drsm_gibbs_energy, \n "
"            drsm_enthalpy : r.properties.drsm_enthalpy, \n "
"            drsm_entropy : r.properties.drsm_entropy, \n "
"            drsm_volume : r.properties.drsm_volume, \n "
"            datasources : r.properties.datasources \n "
"//            _label : 'reaction' \n "
"//            id: r._id \n "
"        } \n "
") \n "
"//LET data_ = (APPEND(SORTED_UNIQUE(FLATTEN(substances_,1)), SORTED_UNIQUE(FLATTEN(reactions_,1)), true) ) \n "
"//RETURN {result : APPEND(data_, SORTED_UNIQUE(FLATTEN(elements_,1)), true) } \n "
"RETURN { thermodataset : tds, datasources : ['db.thermohub.org'], date : DATE_FORMAT(DATE_NOW(), '%dd.%mm.%yyyy %hh:%ii:%ss'),  \n "
"          substances : SORTED_UNIQUE(FLATTEN(substances_,1)), reactions : SORTED_UNIQUE(FLATTEN(reactions_,1)), elements : SORTED_UNIQUE(FLATTEN(elements_,1))} \n ";

}