// Reaktoro is a unified framework for modeling chemically reactive systems.
//
// Copyright (C) 2014-2015 Allan Leal
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#pragma once

// C++ includes
#include <string>
namespace ThermoFun {
namespace units {

/// Convert a numeric value from a unit to another
/// @param value The value
/// @param from The string representing the unit from which the conversion is made
/// @param to The string representing the unit to which the conversion is made
/// @return The converted value
auto convert(double value, const std::string& from, const std::string& to) -> double;

/// Check if two units are convertible among each other
/// @return True if they are convertible, false otherwise
/// Units strings can be composite, for instance "J/K/mol" or "N*km/mol."
/// However, composing units must be known in the derivedUnitsMap. 
auto convertible(const std::string& from, const std::string& to) -> bool;

} /* namespace units */
} /* namespace ThermoFun */
