# -*- coding: utf-8 -*-
"""Executable that launches wctool command.
"""

from traceback import format_tb
import logging
import sys

from wordclasses import main

def exception_handler(exception_type, exception, traceback):
    """Exception handler. Writes stack trace in case of uncaught exceptions to
    debug log.
    """

    print("{}: {}".format(exception_type.__name__, exception))
    logging.debug("Traceback:")
    for item in format_tb(traceback):
        logging.debug(item.strip())
    sys.exit(2)

if __name__ == "__main__":
    sys.excepthook = exception_handler
    try:
        main()
    except KeyboardInterrupt:
        print('Interrupted from keyboard.')
