#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""A package that provides functions and classes related to basic computation.
"""

from theanolm.backend.exceptions import *
from theanolm.backend.filetypes import TextFileType
from theanolm.backend.gpu import get_default_device, log_free_mem
from theanolm.backend.parameters import Parameters
from theanolm.backend.classdistribution import UniformDistribution
from theanolm.backend.classdistribution import LogUniformDistribution
from theanolm.backend.classdistribution import MultinomialDistribution
from theanolm.backend.matrixfunctions import test_value
from theanolm.backend.probfunctions import interpolate_linear
from theanolm.backend.probfunctions import interpolate_loglinear
from theanolm.backend.probfunctions import logprob_type
from theanolm.backend.operations import conv1d, conv2d
from theanolm.backend.operations import l1_norm, sum_of_squares
