# This file is MACHINE GENERATED! Do not edit.
# Generated by: tensorflow/python/tools/api/generator/create_python_api.py script.
"""Math Operations.

Note: Functions taking `Tensor` arguments can also take anything accepted by
`tf.convert_to_tensor`.

Note: Elementwise binary operations in TensorFlow follow [numpy-style
broadcasting](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html).

TensorFlow provides a variety of math functions including:

* Basic arithmetic operators and trigonometric functions.
* Special math functions (like: `tf.math.igamma` and `tf.math.zeta`)
* Complex number functions (like: `tf.math.imag` and `tf.math.angle`)
* Reductions and scans (like: `tf.math.reduce_mean` and `tf.math.cumsum`)
* Segment functions (like: `tf.math.segment_sum`)

See: `tf.linalg` for matrix and tensor functions.

<a id=Segmentation></a>

## About Segmentation

TensorFlow provides several operations that you can use to perform common
math computations on tensor segments.
Here a segmentation is a partitioning of a tensor along
the first dimension, i.e. it  defines a mapping from the first dimension onto
`segment_ids`. The `segment_ids` tensor should be the size of
the first dimension, `d0`, with consecutive IDs in the range `0` to `k`,
where `k<d0`.
In particular, a segmentation of a matrix tensor is a mapping of rows to
segments.

For example:

```python
c = tf.constant([[1,2,3,4], [-1,-2,-3,-4], [5,6,7,8]])
tf.math.segment_sum(c, tf.constant([0, 0, 1]))
#  ==>  [[0 0 0 0]
#        [5 6 7 8]]
```

The standard `segment_*` functions assert that the segment indices are sorted.
If you have unsorted indices use the equivalent `unsorted_segment_` function.
Thses functions take an additional argument `num_segments` so that the output
tensor can be efficiently allocated.

``` python
c = tf.constant([[1,2,3,4], [-1,-2,-3,-4], [5,6,7,8]])
tf.math.unsorted_segment_sum(c, tf.constant([0, 1, 0]), num_segments=2)
# ==> [[ 6,  8, 10, 12],
#       [-1, -2, -3, -4]]
```


"""

from __future__ import print_function as _print_function

from tensorflow.python import abs
from tensorflow.python import accumulate_n
from tensorflow.python import acos
from tensorflow.python import acosh
from tensorflow.python import add
from tensorflow.python import add_n
from tensorflow.python import angle
from tensorflow.python import argmax_v2 as argmax
from tensorflow.python import argmin_v2 as argmin
from tensorflow.python import asin
from tensorflow.python import asinh
from tensorflow.python import atan
from tensorflow.python import atan2
from tensorflow.python import atanh
from tensorflow.python import bessel_i0
from tensorflow.python import bessel_i0e
from tensorflow.python import bessel_i1
from tensorflow.python import bessel_i1e
from tensorflow.python import betainc
from tensorflow.python import bincount
from tensorflow.python import ceil
from tensorflow.python import confusion_matrix
from tensorflow.python import conj
from tensorflow.python import cos
from tensorflow.python import cosh
from tensorflow.python import count_nonzero_v2 as count_nonzero
from tensorflow.python import cumprod
from tensorflow.python import cumsum
from tensorflow.python import digamma
from tensorflow.python import div_no_nan as divide_no_nan
from tensorflow.python import divide
from tensorflow.python import equal
from tensorflow.python import erf
from tensorflow.python import erfc
from tensorflow.python import exp
from tensorflow.python import expm1
from tensorflow.python import floor
from tensorflow.python import floor_mod as floormod
from tensorflow.python import floor_mod as mod
from tensorflow.python import floordiv
from tensorflow.python import greater
from tensorflow.python import greater_equal
from tensorflow.python import igamma
from tensorflow.python import igammac
from tensorflow.python import imag
from tensorflow.python import invert_permutation
from tensorflow.python import is_finite
from tensorflow.python import is_inf
from tensorflow.python import is_nan
from tensorflow.python import is_non_decreasing
from tensorflow.python import is_strictly_increasing
from tensorflow.python import lbeta
from tensorflow.python import less
from tensorflow.python import less_equal
from tensorflow.python import lgamma
from tensorflow.python import log
from tensorflow.python import log1p
from tensorflow.python import log_sigmoid
from tensorflow.python import logical_and
from tensorflow.python import logical_not
from tensorflow.python import logical_or
from tensorflow.python import logical_xor
from tensorflow.python import maximum
from tensorflow.python import minimum
from tensorflow.python import multiply
from tensorflow.python import multiply_no_nan
from tensorflow.python import neg as negative
from tensorflow.python import next_after as nextafter
from tensorflow.python import not_equal
from tensorflow.python import polygamma
from tensorflow.python import polyval
from tensorflow.python import pow
from tensorflow.python import real
from tensorflow.python import reciprocal
from tensorflow.python import reduce_all
from tensorflow.python import reduce_any
from tensorflow.python import reduce_euclidean_norm
from tensorflow.python import reduce_logsumexp
from tensorflow.python import reduce_max
from tensorflow.python import reduce_mean
from tensorflow.python import reduce_min
from tensorflow.python import reduce_prod
from tensorflow.python import reduce_std
from tensorflow.python import reduce_sum
from tensorflow.python import reduce_variance
from tensorflow.python import rint
from tensorflow.python import round
from tensorflow.python import rsqrt
from tensorflow.python import scalar_mul_v2 as scalar_mul
from tensorflow.python import segment_max
from tensorflow.python import segment_mean
from tensorflow.python import segment_min
from tensorflow.python import segment_prod
from tensorflow.python import segment_sum
from tensorflow.python import sigmoid
from tensorflow.python import sign
from tensorflow.python import sin
from tensorflow.python import sinh
from tensorflow.python import sqrt
from tensorflow.python import square
from tensorflow.python import squared_difference
from tensorflow.python import subtract
from tensorflow.python import tan
from tensorflow.python import tanh
from tensorflow.python import truediv
from tensorflow.python import unsorted_segment_max
from tensorflow.python import unsorted_segment_mean
from tensorflow.python import unsorted_segment_min
from tensorflow.python import unsorted_segment_prod
from tensorflow.python import unsorted_segment_sqrt_n
from tensorflow.python import unsorted_segment_sum
from tensorflow.python import xdivy
from tensorflow.python import xlogy
from tensorflow.python import zeta
from tensorflow.python.ops.gen_nn_ops import softplus
from tensorflow.python.ops.gen_nn_ops import softsign
from tensorflow.python.ops.nn import in_top_k_v2 as in_top_k
from tensorflow.python.ops.nn import l2_normalize_v2 as l2_normalize
from tensorflow.python.ops.nn import log_softmax_v2 as log_softmax
from tensorflow.python.ops.nn import softmax_v2 as softmax
from tensorflow.python.ops.nn import top_k
from tensorflow.python.ops.nn import zero_fraction

del _print_function
