"""Python wrappers around TensorFlow ops.

This file is MACHINE GENERATED! Do not edit.
"""

import collections as _collections

from tensorflow.python.eager import execute as _execute
from tensorflow.python.eager import context as _context
from tensorflow.python.eager import core as _core
from tensorflow.python.framework import dtypes as _dtypes
from tensorflow.python.framework import tensor_shape as _tensor_shape

from tensorflow.core.framework import op_def_pb2 as _op_def_pb2
# Needed to trigger the call to _set_call_cpp_shape_fn.
from tensorflow.python.framework import common_shapes as _common_shapes
from tensorflow.python.framework import op_def_registry as _op_def_registry
from tensorflow.python.framework import ops as _ops
from tensorflow.python.framework import op_def_library as _op_def_library


def copy(input, tensor_name="", debug_ops_spec=[], name=None):
  r"""Copy Op.

  Performs CPU-to-CPU or GPU-to-GPU deep-copying of tensor, depending on the
  device on which the tensor is allocated.
  N.B.: If the all downstream attached debug ops are disabled given the current
  gRPC gating status, the output will simply forward the input tensor without
  deep-copying. See the documentation of Debug* ops for more details.

  Unlike the CopyHost Op, this op does not have HostMemory constraint on its
  input or output.

  Args:
    input: A `Tensor`. Input tensor.
    tensor_name: An optional `string`. Defaults to `""`.
      The name of the input tensor.
    debug_ops_spec: An optional list of `strings`. Defaults to `[]`.
      A list of debug op spec (op, url, gated_grpc) for attached debug
      ops. Each element of the list has the format
      <debug_op>;<grpc_url>;<gated_grpc>, wherein gated_grpc is boolean represented
      as 0/1. E.g., "DebugIdentity;grpc://foo:3333;1",
      "DebugIdentity;file:///tmp/tfdbg_1;0".
    name: A name for the operation (optional).

  Returns:
    A `Tensor`. Has the same type as `input`.
    Output tensor, deep-copied from input.
  """
  if tensor_name is None:
    tensor_name = ""
  tensor_name = _execute.make_str(tensor_name, "tensor_name")
  if debug_ops_spec is None:
    debug_ops_spec = []
  if not isinstance(debug_ops_spec, (list, tuple)):
    raise TypeError(
        "Expected list for 'debug_ops_spec' argument to "
        "'copy' Op, not %r." % debug_ops_spec)
  debug_ops_spec = [_execute.make_str(_s, "debug_ops_spec") for _s in debug_ops_spec]
  _ctx = _context.context()
  if _ctx.in_graph_mode():
    _, _, _op = _op_def_lib._apply_op_helper(
        "Copy", input=input, tensor_name=tensor_name,
        debug_ops_spec=debug_ops_spec, name=name)
    _result = _op.outputs[:]
    _inputs_flat = _op.inputs
    _attrs = ("T", _op.get_attr("T"), "tensor_name",
              _op.get_attr("tensor_name"), "debug_ops_spec",
              _op.get_attr("debug_ops_spec"))
  else:
    _attr_T, (input,) = _execute.args_to_matching_eager([input], _ctx)
    _attr_T = _attr_T.as_datatype_enum
    _inputs_flat = [input]
    _attrs = ("T", _attr_T, "tensor_name", tensor_name, "debug_ops_spec",
              debug_ops_spec)
    _result = _execute.execute(b"Copy", 1, inputs=_inputs_flat, attrs=_attrs,
                               ctx=_ctx, name=name)
  _execute.record_gradient(
      "Copy", _inputs_flat, _attrs, _result, name)
  _result, = _result
  return _result


def copy_host(input, tensor_name="", debug_ops_spec=[], name=None):
  r"""Copy Host Op.

  Performs CPU-to-CPU deep-copying of tensor.
  N.B.: If the all downstream attached debug ops are disabled given the current
  gRPC gating status, the output will simply forward the input tensor without
  deep-copying. See the documentation of Debug* ops for more details.

  Unlike the Copy Op, this op has HostMemory constraint on its input or output.

  Args:
    input: A `Tensor`. Input tensor.
    tensor_name: An optional `string`. Defaults to `""`.
      The name of the input tensor.
    debug_ops_spec: An optional list of `strings`. Defaults to `[]`.
      A list of debug op spec (op, url, gated_grpc) for attached debug
      ops. Each element of the list has the format
      <debug_op>;<grpc_url>;<gated_grpc>, wherein gated_grpc is boolean represented
      as 0/1. E.g., "DebugIdentity;grpc://foo:3333;1",
      "DebugIdentity;file:///tmp/tfdbg_1;0".
    name: A name for the operation (optional).

  Returns:
    A `Tensor`. Has the same type as `input`.
    Output tensor, deep-copied from input.
  """
  if tensor_name is None:
    tensor_name = ""
  tensor_name = _execute.make_str(tensor_name, "tensor_name")
  if debug_ops_spec is None:
    debug_ops_spec = []
  if not isinstance(debug_ops_spec, (list, tuple)):
    raise TypeError(
        "Expected list for 'debug_ops_spec' argument to "
        "'copy_host' Op, not %r." % debug_ops_spec)
  debug_ops_spec = [_execute.make_str(_s, "debug_ops_spec") for _s in debug_ops_spec]
  _ctx = _context.context()
  if _ctx.in_graph_mode():
    _, _, _op = _op_def_lib._apply_op_helper(
        "CopyHost", input=input, tensor_name=tensor_name,
        debug_ops_spec=debug_ops_spec, name=name)
    _result = _op.outputs[:]
    _inputs_flat = _op.inputs
    _attrs = ("T", _op.get_attr("T"), "tensor_name",
              _op.get_attr("tensor_name"), "debug_ops_spec",
              _op.get_attr("debug_ops_spec"))
  else:
    _attr_T, (input,) = _execute.args_to_matching_eager([input], _ctx)
    _attr_T = _attr_T.as_datatype_enum
    _inputs_flat = [input]
    _attrs = ("T", _attr_T, "tensor_name", tensor_name, "debug_ops_spec",
              debug_ops_spec)
    _result = _execute.execute(b"CopyHost", 1, inputs=_inputs_flat,
                               attrs=_attrs, ctx=_ctx, name=name)
  _execute.record_gradient(
      "CopyHost", _inputs_flat, _attrs, _result, name)
  _result, = _result
  return _result


def debug_identity(input, device_name="", tensor_name="", debug_urls=[], gated_grpc=False, name=None):
  r"""Debug Identity Op.

  Provides an identity mapping of the non-Ref type input tensor for debugging.

  Args:
    input: A `Tensor`. Input tensor, non-Reference type.
    device_name: An optional `string`. Defaults to `""`.
    tensor_name: An optional `string`. Defaults to `""`.
      Name of the input tensor.
    debug_urls: An optional list of `strings`. Defaults to `[]`.
      List of URLs to debug targets, e.g.,
      file:///foo/tfdbg_dump, grpc:://localhost:11011
    gated_grpc: An optional `bool`. Defaults to `False`.
      Whether this op will be gated. If any of the debug_urls of this
      debug node is of the grpc:// scheme, when the value of this attribute is set
      to True, the data will not actually be sent via the grpc stream unless this
      debug op has been enabled at the debug_url. If all of the debug_urls of this
      debug node are of the grpc:// scheme and the debug op is enabled at none of
      them, the output will be an empty Tensor.
    name: A name for the operation (optional).

  Returns:
    A `Tensor`. Has the same type as `input`.
    Output tensor that equals the input tensor.
  """
  if device_name is None:
    device_name = ""
  device_name = _execute.make_str(device_name, "device_name")
  if tensor_name is None:
    tensor_name = ""
  tensor_name = _execute.make_str(tensor_name, "tensor_name")
  if debug_urls is None:
    debug_urls = []
  if not isinstance(debug_urls, (list, tuple)):
    raise TypeError(
        "Expected list for 'debug_urls' argument to "
        "'debug_identity' Op, not %r." % debug_urls)
  debug_urls = [_execute.make_str(_s, "debug_urls") for _s in debug_urls]
  if gated_grpc is None:
    gated_grpc = False
  gated_grpc = _execute.make_bool(gated_grpc, "gated_grpc")
  _ctx = _context.context()
  if _ctx.in_graph_mode():
    _, _, _op = _op_def_lib._apply_op_helper(
        "DebugIdentity", input=input, device_name=device_name,
        tensor_name=tensor_name, debug_urls=debug_urls, gated_grpc=gated_grpc,
        name=name)
    _result = _op.outputs[:]
    _inputs_flat = _op.inputs
    _attrs = ("T", _op.get_attr("T"), "device_name",
              _op.get_attr("device_name"), "tensor_name",
              _op.get_attr("tensor_name"), "debug_urls",
              _op.get_attr("debug_urls"), "gated_grpc",
              _op.get_attr("gated_grpc"))
  else:
    _attr_T, (input,) = _execute.args_to_matching_eager([input], _ctx)
    _attr_T = _attr_T.as_datatype_enum
    _inputs_flat = [input]
    _attrs = ("T", _attr_T, "device_name", device_name, "tensor_name",
              tensor_name, "debug_urls", debug_urls, "gated_grpc", gated_grpc)
    _result = _execute.execute(b"DebugIdentity", 1, inputs=_inputs_flat,
                               attrs=_attrs, ctx=_ctx, name=name)
  _execute.record_gradient(
      "DebugIdentity", _inputs_flat, _attrs, _result, name)
  _result, = _result
  return _result


def debug_nan_count(input, device_name="", tensor_name="", debug_urls=[], gated_grpc=False, name=None):
  r"""Debug NaN Value Counter Op

  Counts number of NaNs in the input tensor, for debugging.

  Args:
    input: A `Tensor`. Input tensor, non-Reference type.
    device_name: An optional `string`. Defaults to `""`.
    tensor_name: An optional `string`. Defaults to `""`.
      Name of the input tensor.
    debug_urls: An optional list of `strings`. Defaults to `[]`.
      List of URLs to debug targets, e.g.,
      file:///foo/tfdbg_dump, grpc:://localhost:11011.
    gated_grpc: An optional `bool`. Defaults to `False`.
      Whether this op will be gated. If any of the debug_urls of this
      debug node is of the grpc:// scheme, when the value of this attribute is set
      to True, the data will not actually be sent via the grpc stream unless this
      debug op has been enabled at the debug_url. If all of the debug_urls of this
      debug node are of the grpc:// scheme and the debug op is enabled at none of
      them, the output will be an empty Tensor.
    name: A name for the operation (optional).

  Returns:
    A `Tensor` of type `int64`.
    An integer output tensor that is the number of NaNs in the input.
  """
  if device_name is None:
    device_name = ""
  device_name = _execute.make_str(device_name, "device_name")
  if tensor_name is None:
    tensor_name = ""
  tensor_name = _execute.make_str(tensor_name, "tensor_name")
  if debug_urls is None:
    debug_urls = []
  if not isinstance(debug_urls, (list, tuple)):
    raise TypeError(
        "Expected list for 'debug_urls' argument to "
        "'debug_nan_count' Op, not %r." % debug_urls)
  debug_urls = [_execute.make_str(_s, "debug_urls") for _s in debug_urls]
  if gated_grpc is None:
    gated_grpc = False
  gated_grpc = _execute.make_bool(gated_grpc, "gated_grpc")
  _ctx = _context.context()
  if _ctx.in_graph_mode():
    _, _, _op = _op_def_lib._apply_op_helper(
        "DebugNanCount", input=input, device_name=device_name,
        tensor_name=tensor_name, debug_urls=debug_urls, gated_grpc=gated_grpc,
        name=name)
    _result = _op.outputs[:]
    _inputs_flat = _op.inputs
    _attrs = ("T", _op.get_attr("T"), "device_name",
              _op.get_attr("device_name"), "tensor_name",
              _op.get_attr("tensor_name"), "debug_urls",
              _op.get_attr("debug_urls"), "gated_grpc",
              _op.get_attr("gated_grpc"))
  else:
    _attr_T, (input,) = _execute.args_to_matching_eager([input], _ctx)
    _attr_T = _attr_T.as_datatype_enum
    _inputs_flat = [input]
    _attrs = ("T", _attr_T, "device_name", device_name, "tensor_name",
              tensor_name, "debug_urls", debug_urls, "gated_grpc", gated_grpc)
    _result = _execute.execute(b"DebugNanCount", 1, inputs=_inputs_flat,
                               attrs=_attrs, ctx=_ctx, name=name)
  _execute.record_gradient(
      "DebugNanCount", _inputs_flat, _attrs, _result, name)
  _result, = _result
  return _result


def debug_numeric_summary(input, device_name="", tensor_name="", debug_urls=[], lower_bound=float('-inf'), upper_bound=float('inf'), mute_if_healthy=False, gated_grpc=False, name=None):
  r"""Debug Numeric Summary Op.

  Provide a basic summary of numeric value types, range and distribution.

  Args:
    input: A `Tensor`. Input tensor, non-Reference type, float or double.
    device_name: An optional `string`. Defaults to `""`.
    tensor_name: An optional `string`. Defaults to `""`.
      Name of the input tensor.
    debug_urls: An optional list of `strings`. Defaults to `[]`.
      List of URLs to debug targets, e.g.,
      file:///foo/tfdbg_dump, grpc:://localhost:11011
    lower_bound: An optional `float`. Defaults to `float('-inf')`.
      (float) The lower bound <= which values will be included in the
      generalized -inf count. Default: -inf.
    upper_bound: An optional `float`. Defaults to `float('inf')`.
      (float) The upper bound >= which values will be included in the
      generalized +inf count. Default: +inf.
    mute_if_healthy: An optional `bool`. Defaults to `False`.
      (bool) Do not send data to the debug URLs unless at least one
      of elements [2], [3] and [7] (i.e., the nan count and the generalized -inf and
      inf counts) is non-zero.
    gated_grpc: An optional `bool`. Defaults to `False`.
      Whether this op will be gated. If any of the debug_urls of this
      debug node is of the grpc:// scheme, when the value of this attribute is set
      to True, the data will not actually be sent via the grpc stream unless this
      debug op has been enabled at the debug_url. If all of the debug_urls of this
      debug node are of the grpc:// scheme and the debug op is enabled at none of
      them, the output will be an empty Tensor.
    name: A name for the operation (optional).

  Returns:
    A `Tensor` of type `float64`.
    A double tensor of shape [14 + nDimensions], where nDimensions is the
      the number of dimensions of the tensor's shape. The elements of output are:
      [0]: is initialized (1.0) or not (0.0).
      [1]: total number of elements
      [2]: NaN element count
      [3]: generalized -inf count: elements <= lower_bound. lower_bound is -inf by
        default.
      [4]: negative element count (excluding -inf), if lower_bound is the default
        -inf. Otherwise, this is the count of elements > lower_bound and < 0.
      [5]: zero element count
      [6]: positive element count (excluding +inf), if upper_bound is the default
        -inf. Otherwise, this is the count of elements < upper_bound and > 0.
      [7]: generalized +inf count, elements >= upper_bound. upper_bound is +inf by
        default.
    Output elements [1:8] are all zero, if the tensor is uninitialized.
      [8]: minimum of all non-inf and non-NaN elements.
           If uninitialized or no such element exists: +inf.
      [9]: maximum of all non-inf and non-NaN elements.
           If uninitialized or no such element exists: -inf.
      [10]: mean of all non-inf and non-NaN elements.
            If uninitialized or no such element exists: NaN.
      [11]: variance of all non-inf and non-NaN elements.
            If uninitialized or no such element exists: NaN.
      [12]: Data type of the tensor encoded as an enum integer. See the DataType
            proto for more details.
      [13]: Number of dimensions of the tensor (ndims).
      [14+]: Sizes of the dimensions.
  """
  if device_name is None:
    device_name = ""
  device_name = _execute.make_str(device_name, "device_name")
  if tensor_name is None:
    tensor_name = ""
  tensor_name = _execute.make_str(tensor_name, "tensor_name")
  if debug_urls is None:
    debug_urls = []
  if not isinstance(debug_urls, (list, tuple)):
    raise TypeError(
        "Expected list for 'debug_urls' argument to "
        "'debug_numeric_summary' Op, not %r." % debug_urls)
  debug_urls = [_execute.make_str(_s, "debug_urls") for _s in debug_urls]
  if lower_bound is None:
    lower_bound = float('-inf')
  lower_bound = _execute.make_float(lower_bound, "lower_bound")
  if upper_bound is None:
    upper_bound = float('inf')
  upper_bound = _execute.make_float(upper_bound, "upper_bound")
  if mute_if_healthy is None:
    mute_if_healthy = False
  mute_if_healthy = _execute.make_bool(mute_if_healthy, "mute_if_healthy")
  if gated_grpc is None:
    gated_grpc = False
  gated_grpc = _execute.make_bool(gated_grpc, "gated_grpc")
  _ctx = _context.context()
  if _ctx.in_graph_mode():
    _, _, _op = _op_def_lib._apply_op_helper(
        "DebugNumericSummary", input=input, device_name=device_name,
        tensor_name=tensor_name, debug_urls=debug_urls,
        lower_bound=lower_bound, upper_bound=upper_bound,
        mute_if_healthy=mute_if_healthy, gated_grpc=gated_grpc, name=name)
    _result = _op.outputs[:]
    _inputs_flat = _op.inputs
    _attrs = ("T", _op.get_attr("T"), "device_name",
              _op.get_attr("device_name"), "tensor_name",
              _op.get_attr("tensor_name"), "debug_urls",
              _op.get_attr("debug_urls"), "lower_bound",
              _op.get_attr("lower_bound"), "upper_bound",
              _op.get_attr("upper_bound"), "mute_if_healthy",
              _op.get_attr("mute_if_healthy"), "gated_grpc",
              _op.get_attr("gated_grpc"))
  else:
    _attr_T, (input,) = _execute.args_to_matching_eager([input], _ctx)
    _attr_T = _attr_T.as_datatype_enum
    _inputs_flat = [input]
    _attrs = ("T", _attr_T, "device_name", device_name, "tensor_name",
              tensor_name, "debug_urls", debug_urls, "lower_bound",
              lower_bound, "upper_bound", upper_bound, "mute_if_healthy",
              mute_if_healthy, "gated_grpc", gated_grpc)
    _result = _execute.execute(b"DebugNumericSummary", 1, inputs=_inputs_flat,
                               attrs=_attrs, ctx=_ctx, name=name)
  _execute.record_gradient(
      "DebugNumericSummary", _inputs_flat, _attrs, _result, name)
  _result, = _result
  return _result

def _InitOpDefLibrary(op_list_proto_bytes):
  op_list = _op_def_pb2.OpList()
  op_list.ParseFromString(op_list_proto_bytes)
  _op_def_registry.register_op_list(op_list)
  op_def_lib = _op_def_library.OpDefLibrary()
  op_def_lib.add_op_list(op_list)
  return op_def_lib
# op {
#   name: "Copy"
#   input_arg {
#     name: "input"
#     type_attr: "T"
#   }
#   output_arg {
#     name: "output"
#     type_attr: "T"
#   }
#   attr {
#     name: "T"
#     type: "type"
#   }
#   attr {
#     name: "tensor_name"
#     type: "string"
#     default_value {
#       s: ""
#     }
#   }
#   attr {
#     name: "debug_ops_spec"
#     type: "list(string)"
#     default_value {
#       list {
#       }
#     }
#   }
#   allows_uninitialized_input: true
# }
# op {
#   name: "CopyHost"
#   input_arg {
#     name: "input"
#     type_attr: "T"
#   }
#   output_arg {
#     name: "output"
#     type_attr: "T"
#   }
#   attr {
#     name: "T"
#     type: "type"
#   }
#   attr {
#     name: "tensor_name"
#     type: "string"
#     default_value {
#       s: ""
#     }
#   }
#   attr {
#     name: "debug_ops_spec"
#     type: "list(string)"
#     default_value {
#       list {
#       }
#     }
#   }
#   allows_uninitialized_input: true
# }
# op {
#   name: "DebugIdentity"
#   input_arg {
#     name: "input"
#     type_attr: "T"
#   }
#   output_arg {
#     name: "output"
#     type_attr: "T"
#   }
#   attr {
#     name: "T"
#     type: "type"
#   }
#   attr {
#     name: "device_name"
#     type: "string"
#     default_value {
#       s: ""
#     }
#   }
#   attr {
#     name: "tensor_name"
#     type: "string"
#     default_value {
#       s: ""
#     }
#   }
#   attr {
#     name: "debug_urls"
#     type: "list(string)"
#     default_value {
#       list {
#       }
#     }
#   }
#   attr {
#     name: "gated_grpc"
#     type: "bool"
#     default_value {
#       b: false
#     }
#   }
#   allows_uninitialized_input: true
# }
# op {
#   name: "DebugNanCount"
#   input_arg {
#     name: "input"
#     type_attr: "T"
#   }
#   output_arg {
#     name: "output"
#     type: DT_INT64
#   }
#   attr {
#     name: "T"
#     type: "type"
#   }
#   attr {
#     name: "device_name"
#     type: "string"
#     default_value {
#       s: ""
#     }
#   }
#   attr {
#     name: "tensor_name"
#     type: "string"
#     default_value {
#       s: ""
#     }
#   }
#   attr {
#     name: "debug_urls"
#     type: "list(string)"
#     default_value {
#       list {
#       }
#     }
#   }
#   attr {
#     name: "gated_grpc"
#     type: "bool"
#     default_value {
#       b: false
#     }
#   }
#   allows_uninitialized_input: true
# }
# op {
#   name: "DebugNumericSummary"
#   input_arg {
#     name: "input"
#     type_attr: "T"
#   }
#   output_arg {
#     name: "output"
#     type: DT_DOUBLE
#   }
#   attr {
#     name: "T"
#     type: "type"
#   }
#   attr {
#     name: "device_name"
#     type: "string"
#     default_value {
#       s: ""
#     }
#   }
#   attr {
#     name: "tensor_name"
#     type: "string"
#     default_value {
#       s: ""
#     }
#   }
#   attr {
#     name: "debug_urls"
#     type: "list(string)"
#     default_value {
#       list {
#       }
#     }
#   }
#   attr {
#     name: "lower_bound"
#     type: "float"
#     default_value {
#       f: -inf
#     }
#   }
#   attr {
#     name: "upper_bound"
#     type: "float"
#     default_value {
#       f: inf
#     }
#   }
#   attr {
#     name: "mute_if_healthy"
#     type: "bool"
#     default_value {
#       b: false
#     }
#   }
#   attr {
#     name: "gated_grpc"
#     type: "bool"
#     default_value {
#       b: false
#     }
#   }
#   allows_uninitialized_input: true
# }
_op_def_lib = _InitOpDefLibrary(b"\nl\n\004Copy\022\n\n\005input\"\001T\032\013\n\006output\"\001T\"\t\n\001T\022\004type\"\031\n\013tensor_name\022\006string\032\002\022\000\"\"\n\016debug_ops_spec\022\014list(string)\032\002\n\000\230\001\001\np\n\010CopyHost\022\n\n\005input\"\001T\032\013\n\006output\"\001T\"\t\n\001T\022\004type\"\031\n\013tensor_name\022\006string\032\002\022\000\"\"\n\016debug_ops_spec\022\014list(string)\032\002\n\000\230\001\001\n\244\001\n\rDebugIdentity\022\n\n\005input\"\001T\032\013\n\006output\"\001T\"\t\n\001T\022\004type\"\031\n\013device_name\022\006string\032\002\022\000\"\031\n\013tensor_name\022\006string\032\002\022\000\"\036\n\ndebug_urls\022\014list(string)\032\002\n\000\"\026\n\ngated_grpc\022\004bool\032\002(\000\230\001\001\n\243\001\n\rDebugNanCount\022\n\n\005input\"\001T\032\n\n\006output\030\t\"\t\n\001T\022\004type\"\031\n\013device_name\022\006string\032\002\022\000\"\031\n\013tensor_name\022\006string\032\002\022\000\"\036\n\ndebug_urls\022\014list(string)\032\002\n\000\"\026\n\ngated_grpc\022\004bool\032\002(\000\230\001\001\n\200\002\n\023DebugNumericSummary\022\n\n\005input\"\001T\032\n\n\006output\030\002\"\t\n\001T\022\004type\"\031\n\013device_name\022\006string\032\002\022\000\"\031\n\013tensor_name\022\006string\032\002\022\000\"\036\n\ndebug_urls\022\014list(string)\032\002\n\000\"\033\n\013lower_bound\022\005float\032\005%\000\000\200\377\"\033\n\013upper_bound\022\005float\032\005%\000\000\200\177\"\033\n\017mute_if_healthy\022\004bool\032\002(\000\"\026\n\ngated_grpc\022\004bool\032\002(\000\230\001\001")
