/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.util.cache;

import java.util.Iterator;
import org.apache.pdfbox.jbig2.util.ServiceLookup;
import org.apache.pdfbox.jbig2.util.cache.Cache;
import org.apache.pdfbox.jbig2.util.cache.CacheBridge;

public class CacheFactory {
    private static CacheBridge cacheBridge;
    private static ClassLoader clsLoader;

    public static Cache getCache(ClassLoader classLoader) {
        if (null == cacheBridge) {
            ServiceLookup<CacheBridge> serviceLookup = new ServiceLookup<CacheBridge>();
            Iterator<CacheBridge> iterator = serviceLookup.getServices(CacheBridge.class, classLoader);
            if (!iterator.hasNext()) {
                throw new IllegalStateException("No implementation of " + CacheBridge.class + " was avaliable using META-INF/services lookup");
            }
            cacheBridge = iterator.next();
        }
        return cacheBridge.getCache();
    }

    public static Cache getCache() {
        return CacheFactory.getCache(clsLoader != null ? clsLoader : CacheBridge.class.getClassLoader());
    }

    public static void setClassLoader(ClassLoader classLoader) {
        clsLoader = classLoader;
    }
}

