/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import technology.tabula.Rectangle;
import technology.tabula.RectangleSpatialIndex;
import technology.tabula.Ruling;
import technology.tabula.TextElement;
import technology.tabula.Utils;

public class Page
extends Rectangle {
    private Integer rotation;
    private int pageNumber;
    private List<TextElement> texts;
    private List<Ruling> rulings;
    private List<Ruling> cleanRulings = null;
    private List<Ruling> verticalRulingLines = null;
    private List<Ruling> horizontalRulingLines = null;
    private float minCharWidth;
    private float minCharHeight;
    private RectangleSpatialIndex<TextElement> spatial_index;
    private PDPage pdPage;
    private PDDocument pdDoc;

    public Page(float top, float left, float width, float height, int rotation, int page_number, PDPage pdPage, PDDocument doc) {
        super(top, left, width, height);
        this.rotation = rotation;
        this.pageNumber = page_number;
        this.pdPage = pdPage;
        this.pdDoc = doc;
    }

    public Page(float top, float left, float width, float height, int rotation, int page_number, PDPage pdPage, PDDocument doc, List<TextElement> characters, List<Ruling> rulings) {
        this(top, left, width, height, rotation, page_number, pdPage, doc);
        this.texts = characters;
        this.rulings = rulings;
    }

    public Page(float top, float left, float width, float height, int rotation, int page_number, PDPage pdPage, PDDocument doc, List<TextElement> characters, List<Ruling> rulings, float minCharWidth, float minCharHeight, RectangleSpatialIndex<TextElement> index) {
        this(top, left, width, height, rotation, page_number, pdPage, doc, characters, rulings);
        this.minCharHeight = minCharHeight;
        this.minCharWidth = minCharWidth;
        this.spatial_index = index;
    }

    public Page getArea(Rectangle area) {
        List<TextElement> t = this.getText(area);
        float min_char_width = 7.0f;
        float min_char_height = 7.0f;
        if (t.size() > 0) {
            min_char_width = Collections.min(t, new Comparator<TextElement>(){

                @Override
                public int compare(TextElement te1, TextElement te2) {
                    return Float.compare(te1.width, te2.width);
                }
            }).width;
            min_char_height = Collections.min(t, new Comparator<TextElement>(){

                @Override
                public int compare(TextElement te1, TextElement te2) {
                    return Float.compare(te1.height, te2.height);
                }
            }).height;
        }
        Page rv = new Page(area.getTop(), area.getLeft(), (float)area.getWidth(), (float)area.getHeight(), this.rotation, this.pageNumber, this.pdPage, this.pdDoc, t, Ruling.cropRulingsToArea(this.getRulings(), area), min_char_width, min_char_height, this.spatial_index);
        rv.addRuling(new Ruling(new Point2D.Double(rv.getLeft(), rv.getTop()), new Point2D.Double(rv.getRight(), rv.getTop())));
        rv.addRuling(new Ruling(new Point2D.Double(rv.getRight(), rv.getTop()), new Point2D.Double(rv.getRight(), rv.getBottom())));
        rv.addRuling(new Ruling(new Point2D.Double(rv.getRight(), rv.getBottom()), new Point2D.Double(rv.getLeft(), rv.getBottom())));
        rv.addRuling(new Ruling(new Point2D.Double(rv.getLeft(), rv.getBottom()), new Point2D.Double(rv.getLeft(), rv.getTop())));
        return rv;
    }

    public Page getArea(float top, float left, float bottom, float right) {
        Rectangle area = new Rectangle(top, left, right - left, bottom - top);
        return this.getArea(area);
    }

    public List<TextElement> getText() {
        return this.texts;
    }

    public List<TextElement> getText(Rectangle area) {
        return this.spatial_index.contains(area);
    }

    @Deprecated
    public List<TextElement> getText(float top, float left, float bottom, float right) {
        return this.getText(new Rectangle(top, left, right - left, bottom - top));
    }

    public Integer getRotation() {
        return this.rotation;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    @Deprecated
    public List<TextElement> getTexts() {
        return this.texts;
    }

    public Rectangle getTextBounds() {
        List<TextElement> texts = this.getText();
        if (!texts.isEmpty()) {
            return Utils.bounds(texts);
        }
        return new Rectangle();
    }

    public List<Ruling> getRulings() {
        if (this.cleanRulings != null) {
            return this.cleanRulings;
        }
        if (this.rulings == null || this.rulings.isEmpty()) {
            this.verticalRulingLines = new ArrayList<Ruling>();
            this.horizontalRulingLines = new ArrayList<Ruling>();
            return new ArrayList<Ruling>();
        }
        Utils.snapPoints(this.rulings, this.minCharWidth, this.minCharHeight);
        ArrayList<Ruling> vrs = new ArrayList<Ruling>();
        for (Ruling vr : this.rulings) {
            if (!vr.vertical()) continue;
            vrs.add(vr);
        }
        this.verticalRulingLines = Ruling.collapseOrientedRulings(vrs);
        ArrayList<Ruling> hrs = new ArrayList<Ruling>();
        for (Ruling hr : this.rulings) {
            if (!hr.horizontal()) continue;
            hrs.add(hr);
        }
        this.horizontalRulingLines = Ruling.collapseOrientedRulings(hrs);
        this.cleanRulings = new ArrayList<Ruling>(this.verticalRulingLines);
        this.cleanRulings.addAll(this.horizontalRulingLines);
        return this.cleanRulings;
    }

    public List<Ruling> getVerticalRulings() {
        if (this.verticalRulingLines != null) {
            return this.verticalRulingLines;
        }
        this.getRulings();
        return this.verticalRulingLines;
    }

    public List<Ruling> getHorizontalRulings() {
        if (this.horizontalRulingLines != null) {
            return this.horizontalRulingLines;
        }
        this.getRulings();
        return this.horizontalRulingLines;
    }

    public void addRuling(Ruling r) {
        if (r.oblique()) {
            throw new UnsupportedOperationException("Can't add an oblique ruling");
        }
        this.rulings.add(r);
        this.verticalRulingLines = null;
        this.horizontalRulingLines = null;
        this.cleanRulings = null;
    }

    public List<Ruling> getUnprocessedRulings() {
        return this.rulings;
    }

    @Deprecated
    public float getMinCharWidth() {
        return this.minCharWidth;
    }

    @Deprecated
    public float getMinCharHeight() {
        return this.minCharHeight;
    }

    public PDPage getPDPage() {
        return this.pdPage;
    }

    public PDDocument getPDDoc() {
        return this.pdDoc;
    }

    @Deprecated
    public RectangleSpatialIndex<TextElement> getSpatialIndex() {
        return this.spatial_index;
    }

    @Deprecated
    public boolean hasText() {
        return this.texts.size() > 0;
    }
}

