/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.fontbox.util.BoundingBox;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;
import technology.tabula.RectangleSpatialIndex;
import technology.tabula.TextElement;
import technology.tabula.Utils;

public class TextStripper
extends PDFTextStripper {
    private static final String NBSP = "\u00a0";
    private static final float AVG_HEIGHT_MULT_THRESHOLD = 6.0f;
    private PDDocument document;
    public ArrayList<TextElement> textElements;
    public RectangleSpatialIndex<TextElement> spatialIndex;
    public float minCharWidth = Float.MAX_VALUE;
    public float minCharHeight = Float.MAX_VALUE;
    public float totalHeight = 0.0f;
    public int countHeight = 0;

    public TextStripper(PDDocument document, int pageNumber) throws IOException {
        this.document = document;
        this.setStartPage(pageNumber);
        this.setEndPage(pageNumber);
        this.textElements = new ArrayList();
        this.spatialIndex = new RectangleSpatialIndex();
    }

    public void process() throws IOException {
        this.getText(this.document);
    }

    @Override
    protected void writeString(String string, List<TextPosition> textPositions) throws IOException {
        for (TextPosition textPosition : textPositions) {
            String c;
            if (textPosition == null || !this.isPrintable(c = textPosition.getUnicode())) continue;
            Float h = Float.valueOf(textPosition.getHeightDir());
            if (c.equals(NBSP)) {
                c = " ";
            }
            float wos = textPosition.getWidthOfSpace();
            TextElement te = new TextElement(Utils.round(textPosition.getYDirAdj() - h.floatValue(), 2), Utils.round(textPosition.getXDirAdj(), 2), Utils.round(textPosition.getWidthDirAdj(), 2), Utils.round(textPosition.getHeightDir(), 2), textPosition.getFont(), textPosition.getFontSizeInPt(), c, wos, textPosition.getDir());
            this.minCharWidth = (float)Math.min((double)this.minCharWidth, te.getWidth());
            this.minCharHeight = (float)Math.min((double)this.minCharHeight, te.getHeight());
            ++this.countHeight;
            this.totalHeight = (float)((double)this.totalHeight + te.getHeight());
            float avgHeight = this.totalHeight / (float)this.countHeight;
            if (avgHeight > 0.0f && te.getHeight() >= (double)(avgHeight * 6.0f) && (te.getText() == null || te.getText().trim().equals(""))) continue;
            this.spatialIndex.add(te);
            this.textElements.add(te);
        }
    }

    @Override
    protected float computeFontHeight(PDFont font) throws IOException {
        BoundingBox bbox = font.getBoundingBox();
        if (bbox.getLowerLeftY() < -32768.0f) {
            bbox.setLowerLeftY(-(bbox.getLowerLeftY() + 65536.0f));
        }
        float glyphHeight = bbox.getHeight() / 2.0f;
        PDFontDescriptor fontDescriptor = font.getFontDescriptor();
        if (fontDescriptor != null) {
            float capHeight = fontDescriptor.getCapHeight();
            if (Float.compare(capHeight, 0.0f) != 0 && (capHeight < glyphHeight || Float.compare(glyphHeight, 0.0f) == 0)) {
                glyphHeight = capHeight;
            }
            float ascent = fontDescriptor.getAscent();
            float descent = fontDescriptor.getDescent();
            if (ascent > 0.0f && descent < 0.0f && ((ascent - descent) / 2.0f < glyphHeight || Float.compare(glyphHeight, 0.0f) == 0)) {
                glyphHeight = (ascent - descent) / 2.0f;
            }
        }
        float height = font instanceof PDType3Font ? font.getFontMatrix().transformPoint((float)0.0f, (float)glyphHeight).y : glyphHeight / 1000.0f;
        return height;
    }

    private boolean isPrintable(String s) {
        boolean printable = false;
        for (int i = 0; i < s.length(); ++i) {
            Character c = Character.valueOf(s.charAt(i));
            Character.UnicodeBlock block = Character.UnicodeBlock.of(c.charValue());
            printable |= !Character.isISOControl(c.charValue()) && block != null && block != Character.UnicodeBlock.SPECIALS;
        }
        return printable;
    }
}

