/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import technology.tabula.Rectangle;
import technology.tabula.RectangularTextContainer;
import technology.tabula.TextChunk;

public class Cell
extends RectangularTextContainer<TextChunk> {
    private boolean spanning;
    private boolean placeholder;
    private List<TextChunk> textElements;

    public Cell(float top, float left, float width, float height) {
        super(top, left, width, height);
        this.setPlaceholder(false);
        this.setSpanning(false);
        this.setTextElements(new ArrayList<TextChunk>());
    }

    public Cell(Point2D topLeft, Point2D bottomRight) {
        super((float)topLeft.getY(), (float)topLeft.getX(), (float)(bottomRight.getX() - topLeft.getX()), (float)(bottomRight.getY() - topLeft.getY()));
        this.setPlaceholder(false);
        this.setSpanning(false);
        this.setTextElements(new ArrayList<TextChunk>());
    }

    @Override
    public String getText(boolean useLineReturns) {
        if (this.textElements.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Collections.sort(this.textElements, Rectangle.ILL_DEFINED_ORDER);
        double curTop = this.textElements.get(0).getTop();
        for (TextChunk tc : this.textElements) {
            if (useLineReturns && (double)tc.getTop() > curTop) {
                sb.append('\r');
            }
            sb.append(tc.getText());
            curTop = tc.getTop();
        }
        return sb.toString().trim();
    }

    @Override
    public String getText() {
        return this.getText(true);
    }

    public boolean isSpanning() {
        return this.spanning;
    }

    public void setSpanning(boolean spanning) {
        this.spanning = spanning;
    }

    public boolean isPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(boolean placeholder) {
        this.placeholder = placeholder;
    }

    @Override
    public List<TextChunk> getTextElements() {
        return this.textElements;
    }

    public void setTextElements(List<TextChunk> textElements) {
        this.textElements = textElements;
    }
}

