/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.strtree.STRtree;
import technology.tabula.Rectangle;
import technology.tabula.Utils;

public class RectangleSpatialIndex<T extends Rectangle> {
    private final STRtree si = new STRtree();
    private final List<T> rectangles = new ArrayList<T>();

    public void add(T te) {
        this.rectangles.add(te);
        this.si.insert(new Envelope(((Rectangle)te).getLeft(), ((Rectangle)te).getRight(), ((Rectangle)te).getBottom(), ((Rectangle)te).getTop()), te);
    }

    public List<T> contains(Rectangle r) {
        List intersection = this.si.query(new Envelope(r.getLeft(), r.getRight(), r.getTop(), r.getBottom()));
        ArrayList<Rectangle> rv = new ArrayList<Rectangle>();
        for (Rectangle ir : intersection) {
            if (!r.contains(ir)) continue;
            rv.add(ir);
        }
        Utils.sort(rv, Rectangle.ILL_DEFINED_ORDER);
        return rv;
    }

    public List<T> intersects(Rectangle r) {
        List rv = this.si.query(new Envelope(r.getLeft(), r.getRight(), r.getTop(), r.getBottom()));
        return rv;
    }

    public Rectangle getBounds() {
        return Rectangle.boundingBoxOf(this.rectangles);
    }
}

