/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.pdfbox.contentstream.PDFGraphicsStreamEngine;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import technology.tabula.Ruling;
import technology.tabula.Utils;

class ObjectExtractorStreamEngine
extends PDFGraphicsStreamEngine {
    protected List<Ruling> rulings;
    private AffineTransform pageTransform = null;
    private boolean debugClippingPaths;
    private boolean extractRulingLines = true;
    private Logger log;
    private int clipWindingRule = -1;
    private GeneralPath currentPath = new GeneralPath();

    protected ObjectExtractorStreamEngine(PDPage page) {
        super(page);
        this.log = LoggerFactory.getLogger(ObjectExtractorStreamEngine.class);
        this.rulings = new ArrayList<Ruling>();
        PDRectangle cb = this.getPage().getCropBox();
        int rotation = this.getPage().getRotation();
        this.pageTransform = new AffineTransform();
        if (Math.abs(rotation) == 90 || Math.abs(rotation) == 270) {
            this.pageTransform = AffineTransform.getRotateInstance((double)rotation * (Math.PI / 180), 0.0, 0.0);
            this.pageTransform.concatenate(AffineTransform.getScaleInstance(1.0, -1.0));
        } else {
            this.pageTransform.concatenate(AffineTransform.getTranslateInstance(0.0, cb.getHeight()));
            this.pageTransform.concatenate(AffineTransform.getScaleInstance(1.0, -1.0));
        }
        this.pageTransform.translate(-cb.getLowerLeftX(), -cb.getLowerLeftY());
    }

    @Override
    public void appendRectangle(Point2D p0, Point2D p1, Point2D p2, Point2D p3) {
        this.currentPath.moveTo((float)p0.getX(), (float)p0.getY());
        this.currentPath.lineTo((float)p1.getX(), (float)p1.getY());
        this.currentPath.lineTo((float)p2.getX(), (float)p2.getY());
        this.currentPath.lineTo((float)p3.getX(), (float)p3.getY());
        this.currentPath.closePath();
    }

    @Override
    public void clip(int windingRule) {
        this.clipWindingRule = windingRule;
    }

    @Override
    public void closePath() {
        this.currentPath.closePath();
    }

    @Override
    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.currentPath.curveTo(x1, y1, x2, y2, x3, y3);
    }

    @Override
    public void drawImage(PDImage arg0) {
    }

    @Override
    public void endPath() {
        if (this.clipWindingRule != -1) {
            this.currentPath.setWindingRule(this.clipWindingRule);
            this.getGraphicsState().intersectClippingPath(this.currentPath);
            this.clipWindingRule = -1;
        }
        this.currentPath.reset();
    }

    @Override
    public void fillAndStrokePath(int arg0) {
        this.strokeOrFillPath(true);
    }

    @Override
    public void fillPath(int arg0) {
        this.strokeOrFillPath(true);
    }

    @Override
    public Point2D getCurrentPoint() {
        return this.currentPath.getCurrentPoint();
    }

    @Override
    public void lineTo(float x, float y) {
        this.currentPath.lineTo(x, y);
    }

    @Override
    public void moveTo(float x, float y) {
        this.currentPath.moveTo(x, y);
    }

    @Override
    public void shadingFill(COSName arg0) {
    }

    @Override
    public void strokePath() {
        this.strokeOrFillPath(false);
    }

    private void strokeOrFillPath(boolean isFill) {
        Point2D.Float start_pos;
        int currentSegment;
        float[] c;
        GeneralPath path = this.currentPath;
        if (!this.extractRulingLines) {
            this.currentPath.reset();
            return;
        }
        PathIterator pi = path.getPathIterator(this.getPageTransform());
        if (pi.currentSegment(c = new float[6]) != 0) {
            path.reset();
            return;
        }
        pi.next();
        while (!pi.isDone()) {
            currentSegment = pi.currentSegment(c);
            if (currentSegment != 1 && currentSegment != 4 && currentSegment != 0) {
                path.reset();
                return;
            }
            pi.next();
        }
        float[] first = new float[6];
        pi = path.getPathIterator(this.getPageTransform());
        pi.currentSegment(first);
        Point2D.Float last_move = start_pos = new Point2D.Float(Utils.round(first[0], 2), Utils.round(first[1], 2));
        Point2D.Float end_pos = null;
        PointComparator pc = new PointComparator();
        while (!pi.isDone()) {
            pi.next();
            try {
                currentSegment = pi.currentSegment(c);
            }
            catch (IndexOutOfBoundsException ex) {
                continue;
            }
            switch (currentSegment) {
                case 1: {
                    Ruling r;
                    Line2D.Float line;
                    end_pos = new Point2D.Float(c[0], c[1]);
                    if (start_pos == null || end_pos == null) break;
                    Line2D.Float float_ = line = pc.compare(start_pos, end_pos) == -1 ? new Line2D.Float(start_pos, end_pos) : new Line2D.Float(end_pos, start_pos);
                    if (!line.intersects(this.currentClippingPath()) || !((r = new Ruling(line.getP1(), line.getP2()).intersect(this.currentClippingPath())).length() > 0.01)) break;
                    this.rulings.add(r);
                    break;
                }
                case 0: {
                    end_pos = last_move = new Point2D.Float(c[0], c[1]);
                    break;
                }
                case 4: {
                    Ruling r;
                    Line2D.Float line;
                    if (start_pos == null || end_pos == null) break;
                    Line2D.Float float_ = line = pc.compare(end_pos, last_move) == -1 ? new Line2D.Float(end_pos, last_move) : new Line2D.Float(last_move, end_pos);
                    if (!line.intersects(this.currentClippingPath()) || !((r = new Ruling(line.getP1(), line.getP2()).intersect(this.currentClippingPath())).length() > 0.01)) break;
                    this.rulings.add(r);
                }
            }
            start_pos = end_pos;
        }
        path.reset();
    }

    public AffineTransform getPageTransform() {
        return this.pageTransform;
    }

    public Rectangle2D currentClippingPath() {
        Area clippingPath = this.getGraphicsState().getCurrentClippingPath();
        Shape transformedClippingPath = this.getPageTransform().createTransformedShape(clippingPath);
        return transformedClippingPath.getBounds2D();
    }

    class PointComparator
    implements Comparator<Point2D> {
        PointComparator() {
        }

        @Override
        public int compare(Point2D o1, Point2D o2) {
            float o1X = Utils.round(o1.getX(), 2);
            float o1Y = Utils.round(o1.getY(), 2);
            float o2X = Utils.round(o2.getX(), 2);
            float o2Y = Utils.round(o2.getY(), 2);
            if (o1Y > o2Y) {
                return 1;
            }
            if (o1Y < o2Y) {
                return -1;
            }
            if (o1X > o2X) {
                return 1;
            }
            if (o1X < o2X) {
                return -1;
            }
            return 0;
        }
    }
}

