/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.List;
import technology.tabula.RectangularTextContainer;
import technology.tabula.Table;

public final class TableSerializer
implements JsonSerializer<Table> {
    public static final TableSerializer INSTANCE = new TableSerializer();

    private TableSerializer() {
    }

    @Override
    public JsonElement serialize(Table src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        result.addProperty("extraction_method", src.getExtractionMethod());
        result.addProperty("top", Float.valueOf(src.getTop()));
        result.addProperty("left", Float.valueOf(src.getLeft()));
        result.addProperty("width", src.getWidth());
        result.addProperty("height", src.getHeight());
        result.addProperty("right", Float.valueOf(src.getRight()));
        result.addProperty("bottom", Float.valueOf(src.getBottom()));
        JsonArray data = new JsonArray();
        result.add("data", data);
        for (List<RectangularTextContainer> srcRow : src.getRows()) {
            JsonArray row = new JsonArray();
            for (RectangularTextContainer textChunk : srcRow) {
                row.add(context.serialize(textChunk));
            }
            data.add(row);
        }
        return result;
    }
}

