/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula.extractors;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import technology.tabula.Cell;
import technology.tabula.Page;
import technology.tabula.Rectangle;
import technology.tabula.Ruling;
import technology.tabula.Table;
import technology.tabula.TableWithRulingLines;
import technology.tabula.TextElement;
import technology.tabula.Utils;
import technology.tabula.extractors.BasicExtractionAlgorithm;
import technology.tabula.extractors.ExtractionAlgorithm;

public class SpreadsheetExtractionAlgorithm
implements ExtractionAlgorithm {
    private static final float MAGIC_HEURISTIC_NUMBER = 0.65f;
    private static final Comparator<Point2D> POINT_COMPARATOR = new Comparator<Point2D>(){

        @Override
        public int compare(Point2D arg0, Point2D arg1) {
            int rv = 0;
            float arg0X = Utils.round(arg0.getX(), 2);
            float arg0Y = Utils.round(arg0.getY(), 2);
            float arg1X = Utils.round(arg1.getX(), 2);
            float arg1Y = Utils.round(arg1.getY(), 2);
            if (arg0Y > arg1Y) {
                rv = 1;
            } else if (arg0Y < arg1Y) {
                rv = -1;
            } else if (arg0X > arg1X) {
                rv = 1;
            } else if (arg0X < arg1X) {
                rv = -1;
            }
            return rv;
        }
    };
    private static final Comparator<Point2D> X_FIRST_POINT_COMPARATOR = new Comparator<Point2D>(){

        @Override
        public int compare(Point2D arg0, Point2D arg1) {
            int rv = 0;
            float arg0X = Utils.round(arg0.getX(), 2);
            float arg0Y = Utils.round(arg0.getY(), 2);
            float arg1X = Utils.round(arg1.getX(), 2);
            float arg1Y = Utils.round(arg1.getY(), 2);
            if (arg0X > arg1X) {
                rv = 1;
            } else if (arg0X < arg1X) {
                rv = -1;
            } else if (arg0Y > arg1Y) {
                rv = 1;
            } else if (arg0Y < arg1Y) {
                rv = -1;
            }
            return rv;
        }
    };

    public List<Table> extract(Page page) {
        return this.extract(page, page.getRulings());
    }

    public List<Table> extract(Page page, List<Ruling> rulings) {
        List<Ruling> horizontalR = new ArrayList<Ruling>();
        List<Ruling> verticalR = new ArrayList<Ruling>();
        for (Ruling r : rulings) {
            if (r.horizontal()) {
                horizontalR.add(r);
                continue;
            }
            if (!r.vertical()) continue;
            verticalR.add(r);
        }
        horizontalR = Ruling.collapseOrientedRulings(horizontalR);
        verticalR = Ruling.collapseOrientedRulings(verticalR);
        List<Cell> cells = SpreadsheetExtractionAlgorithm.findCells(horizontalR, verticalR);
        List<Rectangle> spreadsheetAreas = SpreadsheetExtractionAlgorithm.findSpreadsheetsFromCells(cells);
        ArrayList<Table> spreadsheets = new ArrayList<Table>();
        for (Rectangle area : spreadsheetAreas) {
            Object hr2;
            ArrayList<Cell> overlappingCells = new ArrayList<Cell>();
            for (Cell cell : cells) {
                if (!cell.intersects(area)) continue;
                cell.setTextElements(TextElement.mergeWords(page.getText(cell)));
                overlappingCells.add(cell);
            }
            ArrayList<Ruling> horizontalOverlappingRulings = new ArrayList<Ruling>();
            for (Object hr2 : horizontalR) {
                if (!area.intersectsLine((Line2D)hr2)) continue;
                horizontalOverlappingRulings.add((Ruling)hr2);
            }
            ArrayList<Ruling> arrayList = new ArrayList<Ruling>();
            hr2 = verticalR.iterator();
            while (hr2.hasNext()) {
                Ruling vr = (Ruling)hr2.next();
                if (!area.intersectsLine(vr)) continue;
                arrayList.add(vr);
            }
            TableWithRulingLines t = new TableWithRulingLines(area, overlappingCells, horizontalOverlappingRulings, arrayList, this);
            spreadsheets.add(t);
        }
        Utils.sort(spreadsheets, Rectangle.ILL_DEFINED_ORDER);
        return spreadsheets;
    }

    public boolean isTabular(Page page) {
        if (page.getText().isEmpty()) {
            return false;
        }
        Page minimalRegion = page.getArea(Utils.bounds(page.getText()));
        List<Table> tables = new SpreadsheetExtractionAlgorithm().extract(minimalRegion);
        if (tables.size() == 0) {
            return false;
        }
        Table table = tables.get(0);
        int rowsDefinedByLines = table.getRowCount();
        int colsDefinedByLines = table.getColCount();
        tables = new BasicExtractionAlgorithm().extract(minimalRegion);
        if (tables.size() == 0) {
            // empty if block
        }
        table = tables.get(0);
        int rowsDefinedWithoutLines = table.getRowCount();
        int colsDefinedWithoutLines = table.getColCount();
        float ratio = ((float)colsDefinedByLines / (float)colsDefinedWithoutLines + (float)rowsDefinedByLines / (float)rowsDefinedWithoutLines) / 2.0f;
        return ratio > 0.65f && ratio < 1.5384616f;
    }

    public static List<Cell> findCells(List<Ruling> horizontalRulingLines, List<Ruling> verticalRulingLines) {
        ArrayList<Cell> cellsFound = new ArrayList<Cell>();
        Map<Point2D, Ruling[]> intersectionPoints = Ruling.findIntersections(horizontalRulingLines, verticalRulingLines);
        ArrayList<Point2D> intersectionPointsList = new ArrayList<Point2D>(intersectionPoints.keySet());
        Collections.sort(intersectionPointsList, POINT_COMPARATOR);
        boolean doBreak = false;
        block0: for (int i = 0; i < intersectionPointsList.size(); ++i) {
            Point2D topLeft = (Point2D)intersectionPointsList.get(i);
            Ruling[] hv = intersectionPoints.get(topLeft);
            doBreak = false;
            ArrayList<Point2D> xPoints = new ArrayList<Point2D>();
            ArrayList<Point2D> yPoints = new ArrayList<Point2D>();
            for (Point2D p : intersectionPointsList.subList(i, intersectionPointsList.size())) {
                if (p.getX() == topLeft.getX() && p.getY() > topLeft.getY()) {
                    xPoints.add(p);
                }
                if (p.getY() != topLeft.getY() || !(p.getX() > topLeft.getX())) continue;
                yPoints.add(p);
            }
            for (Point2D xPoint : xPoints) {
                if (doBreak) continue block0;
                if (!hv[1].equals(intersectionPoints.get(xPoint)[1])) continue;
                for (Point2D yPoint : yPoints) {
                    Point2D.Float btmRight;
                    if (!hv[0].equals(intersectionPoints.get(yPoint)[0]) || !intersectionPoints.containsKey(btmRight = new Point2D.Float((float)yPoint.getX(), (float)xPoint.getY())) || !intersectionPoints.get(btmRight)[0].equals(intersectionPoints.get(xPoint)[0]) || !intersectionPoints.get(btmRight)[1].equals(intersectionPoints.get(yPoint)[1])) continue;
                    cellsFound.add(new Cell(topLeft, btmRight));
                    doBreak = true;
                    continue block0;
                }
            }
        }
        return cellsFound;
    }

    public static List<Rectangle> findSpreadsheetsFromCells(List<? extends Rectangle> cells) {
        ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>();
        HashSet<Point2D> pointSet = new HashSet<Point2D>();
        HashMap edgesH = new HashMap();
        HashMap edgesV = new HashMap();
        int i = 0;
        cells = new ArrayList<Rectangle>(new HashSet<Rectangle>(cells));
        Utils.sort(cells, Rectangle.ILL_DEFINED_ORDER);
        for (Rectangle rectangle : cells) {
            for (Point2D point2D : rectangle.getPoints()) {
                if (pointSet.contains(point2D)) {
                    pointSet.remove(point2D);
                    continue;
                }
                pointSet.add(point2D);
            }
        }
        ArrayList pointsSortX = new ArrayList(pointSet);
        Collections.sort(pointsSortX, X_FIRST_POINT_COMPARATOR);
        ArrayList arrayList = new ArrayList(pointSet);
        Collections.sort(arrayList, POINT_COMPARATOR);
        while (i < pointSet.size()) {
            float currY = (float)((Point2D)arrayList.get(i)).getY();
            while (i < pointSet.size() && Utils.feq(((Point2D)arrayList.get(i)).getY(), currY)) {
                edgesH.put(arrayList.get(i), arrayList.get(i + 1));
                edgesH.put(arrayList.get(i + 1), arrayList.get(i));
                i += 2;
            }
        }
        i = 0;
        while (i < pointSet.size()) {
            float currX = (float)((Point2D)pointsSortX.get(i)).getX();
            while (i < pointSet.size() && Utils.feq(((Point2D)pointsSortX.get(i)).getX(), currX)) {
                edgesV.put(pointsSortX.get(i), pointsSortX.get(i + 1));
                edgesV.put(pointsSortX.get(i + 1), pointsSortX.get(i));
                i += 2;
            }
        }
        ArrayList polygons = new ArrayList();
        while (!edgesH.isEmpty()) {
            PolygonVertex lastAddedVertex;
            ArrayList<PolygonVertex> polygon = new ArrayList<PolygonVertex>();
            Point2D point2D = (Point2D)edgesH.keySet().iterator().next();
            polygon.add(new PolygonVertex(point2D, Direction.HORIZONTAL));
            edgesH.remove(point2D);
            do {
                Point2D nextVertex;
                PolygonVertex curr = (PolygonVertex)polygon.get(polygon.size() - 1);
                if (curr.direction == Direction.HORIZONTAL) {
                    nextVertex = (Point2D)edgesV.get(curr.point);
                    edgesV.remove(curr.point);
                    lastAddedVertex = new PolygonVertex(nextVertex, Direction.VERTICAL);
                    polygon.add(lastAddedVertex);
                    continue;
                }
                nextVertex = (Point2D)edgesH.get(curr.point);
                edgesH.remove(curr.point);
                lastAddedVertex = new PolygonVertex(nextVertex, Direction.HORIZONTAL);
                polygon.add(lastAddedVertex);
            } while (!lastAddedVertex.equals(polygon.get(0)));
            polygon.remove(polygon.size() - 1);
            for (PolygonVertex vertex : polygon) {
                edgesH.remove(vertex.point);
                edgesV.remove(vertex.point);
            }
            polygons.add(polygon);
        }
        for (List list : polygons) {
            float top = Float.MAX_VALUE;
            float left = Float.MAX_VALUE;
            float bottom = Float.MIN_VALUE;
            float right = Float.MIN_VALUE;
            for (PolygonVertex pt : list) {
                top = (float)Math.min((double)top, pt.point.getY());
                left = (float)Math.min((double)left, pt.point.getX());
                bottom = (float)Math.max((double)bottom, pt.point.getY());
                right = (float)Math.max((double)right, pt.point.getX());
            }
            rectangles.add(new Rectangle(top, left, right - left, bottom - top));
        }
        return rectangles;
    }

    @Override
    public String toString() {
        return "lattice";
    }

    static class PolygonVertex {
        Point2D point;
        Direction direction;

        public PolygonVertex(Point2D point, Direction direction) {
            this.direction = direction;
            this.point = point;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PolygonVertex)) {
                return false;
            }
            return this.point.equals(((PolygonVertex)other).point);
        }

        public int hashCode() {
            return this.point.hashCode();
        }

        public String toString() {
            return String.format("%s[point=%s,direction=%s]", this.getClass().getName(), this.point.toString(), this.direction.toString());
        }
    }

    private static enum Direction {
        HORIZONTAL,
        VERTICAL;

    }
}

