/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula.writers;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import technology.tabula.Cell;
import technology.tabula.RectangularTextContainer;
import technology.tabula.Table;
import technology.tabula.TextChunk;
import technology.tabula.json.RectangularTextContainerSerializer;
import technology.tabula.json.TableSerializer;
import technology.tabula.writers.Writer;

public class JSONWriter
implements Writer {
    private static final ExclusionStrategy ALLCLASSES_SKIPNONPUBLIC = new ExclusionStrategy(){

        @Override
        public boolean shouldSkipClass(Class<?> c) {
            return false;
        }

        @Override
        public boolean shouldSkipField(FieldAttributes fa) {
            return !fa.hasModifier(1);
        }
    };

    @Override
    public void write(Appendable out, Table table) throws IOException {
        out.append(JSONWriter.gson().toJson((Object)table, (Type)((Object)Table.class)));
    }

    @Override
    public void write(Appendable out, List<Table> tables) throws IOException {
        Gson gson = JSONWriter.gson();
        JsonArray array = new JsonArray();
        for (Table table : tables) {
            array.add(gson.toJsonTree(table, (Type)((Object)Table.class)));
        }
        out.append(gson.toJson(array));
    }

    private static Gson gson() {
        return new GsonBuilder().addSerializationExclusionStrategy(ALLCLASSES_SKIPNONPUBLIC).registerTypeAdapter((Type)((Object)Table.class), TableSerializer.INSTANCE).registerTypeAdapter((Type)((Object)RectangularTextContainer.class), RectangularTextContainerSerializer.INSTANCE).registerTypeAdapter((Type)((Object)Cell.class), RectangularTextContainerSerializer.INSTANCE).registerTypeAdapter((Type)((Object)TextChunk.class), RectangularTextContainerSerializer.INSTANCE).create();
    }
}

