# Demo of how to use STIR from python to display some images with matplotlib

# Copyright 2012-06-05 - 2013 Kris Thielemans

# This file is part of STIR.
#
# SPDX-License-Identifier: Apache-2.0
#
# See STIR/LICENSE.txt for details

#%% Initial imports
import matplotlib.pyplot as pylab
import stir
import stirextra

#%% image display

# read an image using STIR
image = stir.FloatVoxelsOnCartesianGrid.read_from_file(
    '../../recon_test_pack/test_image_3.hv')

# convert data to numpy 3d array
npimage = stirextra.to_numpy(image)

# make some plots
# first a bitmap
pylab.figure()
pylab.imshow(npimage[10, :, :], cmap='hot')
pylab.title('slice 10 (starting from 0)')
pylab.show(block=False)
# now a profile
pylab.figure()
pylab.plot(npimage[10, 45, :])
pylab.xlabel('x')
pylab.title('slice 10, line 45 (starting from 0)')
pylab.show(block=False)

#%% Let's read some projection data

projdata = stir.ProjData.read_from_file('../recon_demo/smalllong.hs')
# get stack of all sinograms
sinos = stirextra.to_numpy(projdata)
# display a single sinogram
fig = pylab.figure()
hdl = pylab.imshow(sinos[10, :, :])
pylab.title('sinogram 10 (starting from 0)')
# set some options as illustration how to use matplotlib
hdl.set_cmap('gray')
# change range of colormap
pylab.clim(0, sinos.max() * .9)
pylab.colorbar()
pylab.show(block=True)
