/*
    Copyright (C) 2016-2017, University College London
    This file is part of STIR.

    SPDX-License-Identifier: Apache-2.0

    See STIR/LICENSE.txt for details
*/
#ifndef __stir_config__H__
#define __stir_config__H__
/*!
  \file 
  \ingroup buildblock 
  \brief basic configuration include file 

  This file will be used by CMake to create stir/config.h based on local settings and CMake options.

  \author Kris Thielemans
*/

namespace stir {
  /*!
    \name Preprocessor symbols with version information
    \ingroup buildblock
    Values are set by CMake from the main CMakeLists.txt.
  */
  //@{
  #define STIR_VERSION 050000
  #define STIR_VERSION_STRING "5.0.0"
  /*! \def STIR_VERSION
      \brief numerical amalgation of the version info, as in 030100 (for version 3.1.0)
  */
  /*! \def STIR_VERSION_STRING
      \brief a string with the version info, as in "3.1.0" (for version 3.1.0)
  */
  
  //@}
}

#if defined(_MSC_VER)
#include "stir/config/visualc.h"
#endif
#if defined(__GNUC__)
#include "stir/config/gcc.h"
#endif

#include "boost/config.hpp"

/* #undef HAVE_ECAT */
#ifdef HAVE_ECAT
#define HAVE_LLN_MATRIX
#endif

/* #undef HAVE_CERN_ROOT */

/* #undef HAVE_AVW */

/* #undef HAVE_RDF */

/* #undef HAVE_HDF5 */

#define HAVE_ITK

#define HAVE_JSON

/* #undef STIR_WITH_NiftyPET_PROJECTOR */

/* #undef STIR_WITH_Parallelproj_PROJECTOR */
/* #undef parallelproj_built_with_CUDA */

#define STIR_OPENMP

/* #undef STIR_MPI */

#define STIR_CONFIG_DIR "D:/bld/stir_1650395331659/_h_env/Library/share/stir/config"

#define nlohmann_json_FOUND "1"

/* #undef STIR_USE_BOOST_SHARED_PTR */

/* #undef STIR_NO_UNIQUE_PTR */

/* #undef HAVE_SYSTEM_GETOPT */

/* #undef STIR_DEFAULT_PROJECTOR_AS_V2 */
#ifndef STIR_DEFAULT_PROJECTOR_AS_V2
#define USE_PMRT
#endif

/* #undef STIR_PROJECTORS_AS_V3 */
/* #undef STIR_LEGACY_IGNORE_VIEW_OFFSET */
#endif //  __stir_config__H__
