//
/*
    Copyright (C) 2000- 2007, Hammersmith Imanet Ltd
    This file is part of STIR.

    SPDX-License-Identifier: Apache-2.0

    See STIR/LICENSE.txt for details
*/
/*!
  \file
  \ingroup singles_buildblock

  \brief Declaration of class stir::SinglesRatesFromSglFile

  \author Kris Thielemans
  \author Sanida Mustafovic

*/

#ifndef __stir_data_SinglesRatesFromSglFile_H__
#define __stir_data_SinglesRatesFromSglFile_H__

#include "stir/data/SinglesRatesForTimeSlices.h"
#include "stir/RegisteredParsingObject.h"
#include "stir/IO/stir_ecat7.h"


START_NAMESPACE_STIR
START_NAMESPACE_ECAT
START_NAMESPACE_ECAT7


/*!
  \ingroup singles_buildblock
  \brief A class for reading/writing singles from an ECAT7 .sgl file

  .sgl files are generated by CTI/Siemens PET scanners ECAT HR+ and HR++ (aka EXACT3D) when doing a list mode scan
*/
class SinglesRatesFromSglFile : 
public RegisteredParsingObject<SinglesRatesFromSglFile, SinglesRates, SinglesRatesForTimeSlices>

{ 
public:

 struct sgl_str 
 {
  long int  time;
  long int  num_sgl;
  long int  sgl[126]; // Total prompts and total randoms at the end.
 };

 static const unsigned SIZE_OF_SINGLES_RECORD;

 //! Name which will be used when parsing a SinglesRatesFromSglFile object 
 static const char * const registered_name; 


 //! Default constructor 
 SinglesRatesFromSglFile();
 
 // IO Methods

 //! The function that reads singles from *.sgl file.
 int read_singles_from_sgl_file(const std::string& sgl_filename);

  /*!
  * \brief Write the object to a stream in SGL format.
  * \param[in] output The ostream to which the object will be written.
  */
 std::ostream& write(std::ostream& output);

private:
 
 std::vector<int> _total_prompts;
 std::vector<int> _total_randoms;


#ifdef HAVE_LLN_MATRIX
 Main_header _singles_main_header;
#endif
 
 std::string _sgl_filename;

 virtual void set_defaults();
 virtual void initialise_keymap();
 virtual bool post_processing();
 
};








END_NAMESPACE_ECAT7
END_NAMESPACE_ECAT
END_NAMESPACE_STIR


#endif
