# The original *cmake.in file is part of STIR.
#
# Author: Kris Thielemans
# Author Richard Brown
# Copyright 2016, 2019 University College London
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0.txt
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

# This file sets STIR_INCLUDE_DIRS, STIR_LIBRARIES and STIR_REGISTRIES.
# It also finds the packages that were used to build STIR as you need those
# to link against etc. It should normally not be required that you know about
# these, as they should be automatically added to the dependencies of the STIR
# libraries. Therefore, if you make a target that depends on ${STIR_LIBRARIES},
# its include_directories and linkage should automagically be ok.
#
# At this point in time, you do need to add
#  include_directories("${STIR_INCLUDE_DIRS}")
# to your CMake file to get the STIR_REGISTRIES to compile.
#
# The file also sets variables such as STIR_BUILT_WITH_ITK, STIR_BUILT_WITH_OpenMP etc
# in case you need to how it was built.

####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was STIRConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

#################################################################################### 

# add folder where this file resides to the cmake path such that it can use our find_package modules and .cmake files
set(CMAKE_MODULE_PATH "${CMAKE_CURRENT_LIST_DIR};${CMAKE_MODULE_PATH}")

include("${CMAKE_CURRENT_LIST_DIR}/STIRTargets.cmake")

set_and_check(STIR_INCLUDE_DIRS "${PACKAGE_PREFIX_DIR}/include")
# cannot use set_and_check on lists at present
# https://gitlab.kitware.com/cmake/cmake/issues/16219
#set(STIR_LIBRARY_DIRS "")
set(STIR_LIBRARIES analytic_FBP3DRP;analytic_FBP2D;iterative_OSMAPOSL;iterative_KOSMAPOSL;iterative_OSSPS;scatter_buildblock;modelling_buildblock;listmode_buildblock;recon_buildblock;display;IO;data_buildblock;numerics_buildblock;buildblock;spatial_transformation_buildblock;Shape_buildblock;eval_buildblock;numerics_buildblock;modelling_buildblock;listmode_buildblock;IO;modelling_buildblock;IO;buildblock)
set(STIR_REGISTRIES ${PACKAGE_PREFIX_DIR}/share/stir/src/buildblock_registries.cxx;${PACKAGE_PREFIX_DIR}/share/stir/src/data_buildblock_registries.cxx;${PACKAGE_PREFIX_DIR}/share/stir/src/IO_registries.cxx;${PACKAGE_PREFIX_DIR}/share/stir/src/recon_buildblock_registries.cxx;${PACKAGE_PREFIX_DIR}/share/stir/src/Shape_buildblock_registries.cxx;${PACKAGE_PREFIX_DIR}/share/stir/src/modelling_registries.cxx;${PACKAGE_PREFIX_DIR}/share/stir/src/spatial_transformation_registries.cxx;${PACKAGE_PREFIX_DIR}/share/stir/src/scatter_registries.cxx)

## find external packages
# we use a trick by Matt McCormick (kitware)
# to set ITK_DIR etc first before calling find_package
# to make sure we pick the same version of the external library
if (STIR_FIND_QUIETLY)
  SET(STIR_FIND_TYPE "QUIET")
else()
  SET(STIR_FIND_TYPE "REQUIRED")
endif()

if (1)
  message(STATUS "ITK support in STIR enabled.")
  set(ITK_DIR "D:/bld/stir_1590213879763/_h_env/Library/lib/cmake/ITK-5.1")
  find_package(ITK ${STIR_FIND_TYPE})
  if(NOT ITK_FOUND)
    SET(STIR_FOUND OFF)
  endif()
  include(${ITK_USE_FILE})
  set(STIR_BUILT_WITH_ITK TRUE)
endif()

if (FALSE)
  set(HAVE_ECAT ON)
  message(STATUS "ECAT support in STIR enabled.")
  # need to add this as stir_ecat7.h etc rely on it
  # would be better to add it to STIR_INCLUDE_DIRS (TODO)
  include_directories("LLN_INCLUDE_DIRS-NOTFOUND")
  set(STIR_BUILT_WITH_LLN_MATRIX TRUE)
endif()

if (FALSE)
  set(CERN_ROOT_CONFIG CERN_ROOT_CONFIG-NOTFOUND)
  find_package(CERN_ROOT ${STIR_FIND_TYPE})
  if(NOT CERN_ROOT_FOUND)
    SET(STIR_FOUND OFF)
  endif()
  message(STATUS "CERN ROOT support in STIR enabled.")
  # need to add this as registries rely on it
  # would be better to add it to STIR_INCLUDE_DIRS (TODO)
  include_directories(${CERN_ROOT_INCLUDE_DIRS})
  set(STIR_BUILT_WITH_CERN_ROOT TRUE)
endif()

if (FALSE)
  set(AVW_ROOT_DIR )
  find_package(AVW ${STIR_FIND_TYPE})
  if(NOT AVW_FOUND)
    SET(STIR_FOUND OFF)
  endif()
  message(STATUS "AVW support in STIR enabled.")
  # need to add this as registries rely on it
  # would be better to add it to STIR_INCLUDE_DIRS (TODO)
  include_directories(${AVW_INCLUDE_DIRS})
  set(STIR_BUILT_WITH_AVW TRUE)
endif()

if (OFF)
  find_package(MPI ${STIR_FIND_TYPE})
  if(NOT MPI_FOUND)
    SET(STIR_FOUND OFF)
  endif()
  set(STIR_BUILT_WITH_MPI TRUE)
endif()

if(ON)
  find_package(OpenMP ${STIR_FIND_TYPE})
  set(STIR_BUILT_WITH_OpenMP TRUE)
endif()
