/*
    Copyright (C) 2016-2017, University College London
    This file is part of STIR.

    This file is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2.1 of the License, or
    (at your option) any later version.

    This file is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    See STIR/LICENSE.txt for details
*/
#ifndef __stir_config__H__
#define __stir_config__H__
/*!
  \file 
  \ingroup buildblock 
  \brief basic configuration include file 

  This file will be used by CMake to create stir/config.h based on local settings and CMake options.

  \author Kris Thielemans
*/

namespace stir {
  /*!
    \name Preprocessor symbols with version information
    \ingroup buildblock
    Values are set by CMake from the main CMakeLists.txt.
  */
  //@{
  #define STIR_VERSION 040000
  #define STIR_VERSION_STRING "4.0.0-alpha"
  /*! \def STIR_VERSION
      \brief numerical amalgation of the version info, as in 030100 (for version 3.1.0)
  */
  /*! \def STIR_VERSION_STRING
      \brief a string with the version info, as in "3.1.0" (for version 3.1.0)
  */
  
  //@}
}

#if defined(_MSC_VER)
#include "stir/config/visualc.h"
#endif
#if defined(__GNUC__)
#include "stir/config/gcc.h"
#endif

#include "boost/config.hpp"

/* #undef HAVE_ECAT */
#ifdef HAVE_ECAT
#define HAVE_LLN_MATRIX
#endif

/* #undef HAVE_CERN_ROOT */

/* #undef HAVE_AVW */

/* #undef HAVE_RDF */

#define HAVE_ITK

/* #undef STIR_OPENMP */

/* #undef STIR_MPI */

/* #undef STIR_USE_BOOST_SHARED_PTR */

/* #undef STIR_NO_UNIQUE_PTR */

/* #undef HAVE_SYSTEM_GETOPT */

/* #undef STIR_DEFAULT_PROJECTOR_AS_V2 */
#ifndef STIR_DEFAULT_PROJECTOR_AS_V2
#define USE_PMRT
#endif

/* #undef STIR_PROJECTORS_AS_V3 */

#endif //  __stir_config__H__
