
import numpy as np
from matplotlib import pyplot
import spm1d



#(0) Load data:
np.random.seed(1)
y0         = spm1d.data.uv1d.normality.NormalityAppendixDataset('A12').Y
y1         = spm1d.data.uv1d.normality.NormalityAppendixDataset('A13').Y
y2         = spm1d.data.uv1d.normality.NormalityAppendixDataset('A14').Y


#(1) Compute normality metrics:
K2         = [spm1d.stats.normality.dagostinoK2(yy)  for yy in [y0,y1,y2]]
P          = [spm1d.stats.normality.shapirowilk(yy)[1]  for yy in [y0,y1,y2]]
logP       = -np.log10(P)



#(2) Plot:
pyplot.close('all')
figw       = 8
figh       = figw / 1.6
pyplot.figure(figsize=(figw,figh))
### create axes:
axw = axh  = 0.27
axx,axy    = np.linspace(0.08, 0.71, 3), [0.72, 0.42, 0.04]
AX         = np.array(  [[pyplot.axes([xx, yy, axw, axh])  for xx in axx]  for yy in axy]  )
### plot datasets:
[ax.plot(yy.T, 'k', lw=0.2)   for ax,yy in zip(AX[0], [y0,y1,y2])]
### plot K2 stats:
[k2.plot(ax=ax, color='b')   for ax,k2 in zip(AX[1], K2)]
### plot histograms:
bins       = 17
rng        = -7, 7
ind        = 50
[ax.hist(yy[:,ind], bins=bins, range=rng, facecolor='c')   for ax,yy in zip(AX[2], [y0,y1,y2])]
### adjust axis tick labels:
[pyplot.setp(ax.get_xticklabels() + ax.get_yticklabels(), size=8 )   for ax in AX.flatten()]
pyplot.setp(AX[0], ylim=(-7,7))
pyplot.setp(AX[1], ylim=(0, 55), ylabel='')
pyplot.setp(AX[2], ylim=(0, 220))
pyplot.setp(AX[:2],   xticklabels=[])
pyplot.setp(AX[:,1:], yticklabels=[])
### axis labels:
[ax.set_xlabel('Time  (%)', size=14)   for ax in AX[1]]
ylabels   = '', r'$K^2$', 'Frequency'
[ax.set_ylabel(label, size=14)   for ax,label in zip(AX[:,0], ylabels)]
### time instant labels:
[ax.text(0.05, 0.8, 'Time = %d%s'%(ind,'%'), size=9, transform=ax.transAxes)  for ax in AX[2]]
### dataset labels
[ax.text(0.5, 0.85, 'Dataset A%d'%(i+12), size=10, ha='center', bbox=dict(color='0.85'), transform=ax.transAxes)  for  i,ax in enumerate(AX[0])]
pyplot.show()







