#! /usr/bin/env python

############################################################################
# Copyright (c) 2012 Dr. Peter Bunting
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
#
# Purpose:  A class to populate a supplied shell script template
# Author: Pete Bunting
# Email: petebunting@mac.com
# Date: 06/02/2013
# Version: 1.0
#
# History:
# Version 1.0 - Created and adapted from RSGISLib.
#
#############################################################################

import os.path
import sys
from time import strftime
import optparse

class SPDPopSingleTemplate (object):

    def readInputTemplate(self, inputFile):
        shOutline = str()
        inputShellFile = open(inputFile, 'r')
        for eachLine in inputShellFile:
            shOutline = shOutline + eachLine
        return shOutline

    def constructOutFile(self, files, shOutline, outputfile, path, baseNames):
        outputXMLFile = open(outputfile, 'w')
        print("Replacing: $PATH with ", path)
        shOutlinereplacepath = shOutline.replace('$PATH', path, shOutline.count('$PATH'))

        shOutlinereplacebase = shOutlinereplacepath
        count = 1
        for baseName in baseNames:
            baseName = baseName.strip()
            symbolReplace = str("$FILENAME") + str(count)
            print("Replacing: ", symbolReplace, " with ", baseName)
            shOutlinereplacebase = shOutlinereplacebase.replace(symbolReplace, baseName, shOutlinereplacebase.count(symbolReplace))
            count = count + 1

        shOutlinereplaceFiles = shOutlinereplacebase
        count = 1
        for file in files:
            file = file.strip()
            symbolReplace = str("$FILEPATH") + str(count)
            print("Replacing: ", symbolReplace, " with ", file)
            shOutlinereplaceFiles = shOutlinereplaceFiles.replace(symbolReplace, file, shOutlinereplaceFiles.count(symbolReplace))
            count = count + 1

        outputXMLFile.write(shOutlinereplaceFiles)
        outputXMLFile.flush()
        outputXMLFile.close()

    def run(self, cmdargs):
        print('spdcmdgen.py script populates shell scripts SPDLib')
        print('library from a user defined template.')
        print('\nThis script was distributed with version 3.3.309 of the SPDLib library.')
        print('For maintenance email spdlib-develop@lists.sourceforge.net')

        inTemplateStr = self.readInputTemplate(cmdargs.inputFile)
        self.constructOutFile(cmdargs.files, inTemplateStr, cmdargs.outputFile.strip(), cmdargs.outFilePath.strip(), cmdargs.baseNames)
        print('File has been generated ' + cmdargs.outputFile.strip())


# Command arguments
class CmdArgs:
  def __init__(self):
    p = optparse.OptionParser()
    p.add_option("-i","--input", dest="inputFile", default=None, help="Input shell script template")
    p.add_option("-o","--output", dest="outputFile", default=None, help="Output shell script file")
    p.add_option("-b","--base", action="append", dest="baseNames", default=None, help="Output file base file names (\'$FILENAME1\', \'$FILENAME2\'...\'$FILENAMEn\')")
    p.add_option("-p","--path", dest="outFilePath", default=None, help="Output file path (\'$PATH\')")
    p.add_option("-f","--file", action="append", dest="files", default=None, help="Input files to be replaced using $FILEPATHx for files in order (e.g., $FILEPATH1, $FILEPATH2 ... $FILEPATHn).")

    (options, args) = p.parse_args()
    self.__dict__.update(options.__dict__)

    if self.inputFile is None:
        p.print_help()
        print("The input file must be provided.")
        sys.exit()

    if self.outputFile is None:
        p.print_help()
        print("The output filename must be provided.")
        sys.exit()

if __name__ == '__main__':
    cmdargs = CmdArgs()
    obj = SPDPopSingleTemplate()
    obj.run(cmdargs)

