from pathlib import Path
from typing import Any, Callable, Dict, Iterable, Iterator, List
from typing import NoReturn, Optional, Tuple, Union

from ..tokens.doc import Doc

from ..training import Example
from ..language import Language

class Pipe:
    def __call__(self, doc: Doc) -> Doc: ...
    def pipe(
        self, stream: Iterable[Doc], *, batch_size: int = ...
    ) -> Iterator[Doc]: ...
    def initialize(
        self,
        get_examples: Callable[[], Iterable[Example]],
        *,
        nlp: Language = ...,
    ) -> None: ...
    def score(
        self, examples: Iterable[Example], **kwargs: Any
    ) -> Dict[str, Union[float, Dict[str, float]]]: ...
    @property
    def is_trainable(self) -> bool: ...
    @property
    def labels(self) -> Tuple[str, ...]: ...
    @property
    def label_data(self) -> Any: ...
    def _require_labels(self) -> None: ...
    def set_error_handler(
        self, error_handler: Callable[[str, "Pipe", List[Doc], Exception], NoReturn]
    ) -> None: ...
    def get_error_handler(
        self,
    ) -> Callable[[str, "Pipe", List[Doc], Exception], NoReturn]: ...

def deserialize_config(path: Path) -> Any: ...
