from ...attrs import LIKE_NUM


_num_words = [
    "sero",
    "isa",
    "dalawa",
    "tatlo",
    "apat",
    "lima",
    "anim",
    "pito",
    "walo",
    "siyam",
    "sampu",
    "labing-isa",
    "labindalawa",
    "labintatlo",
    "labing-apat",
    "labinlima",
    "labing-anim",
    "labimpito",
    "labing-walo",
    "labinsiyam",
    "dalawampu",
    "tatlumpu",
    "apatnapu",
    "limampu",
    "animnapu",
    "pitumpu",
    "walumpu",
    "siyamnapu",
    "daan",
    "libo",
    "milyon",
    "bilyon",
    "trilyon",
    "quadrilyon",
    "gajilyon",
    "bazilyon",
]


def like_num(text):
    text = text.replace(",", "").replace(".", "")
    if text.isdigit():
        return True
    if text.count("/") == 1:
        num, denom = text.split("/")
        if num.isdigit() and denom.isdigit():
            return True
    if text in _num_words:
        return True
    return False


LEX_ATTRS = {LIKE_NUM: like_num}
