# coding: utf8
from __future__ import unicode_literals

from ...symbols import ORTH

# Extensive list of both common and uncommon dutch abbreviations copied from
# github.com/diasks2/pragmatic_segmenter, a Ruby library for rule-based
# sentence boundary detection (MIT, Copyright 2015 Kevin S. Dias).
# Source file: https://github.com/diasks2/pragmatic_segmenter/blob/master/lib/pragmatic_segmenter/languages/dutch.rb
# (Last commit: 4d1477b)

# Main purpose of such an extensive list: considerably improved sentence
# segmentation.

# Note: This list has been copied over largely as-is. Some of the abbreviations
# are extremely domain-specific. Tokenizer performance may benefit from some
# slight pruning, although no performance regression has been observed so far.

abbrevs = [
    "a.2d.",
    "a.a.",
    "a.a.j.b.",
    "a.f.t.",
    "a.g.j.b.",
    "a.h.v.",
    "a.h.w.",
    "a.hosp.",
    "a.i.",
    "a.j.b.",
    "a.j.t.",
    "a.m.",
    "a.m.r.",
    "a.p.m.",
    "a.p.r.",
    "a.p.t.",
    "a.s.",
    "a.t.d.f.",
    "a.u.b.",
    "a.v.a.",
    "a.w.",
    "aanbev.",
    "aanbev.comm.",
    "aant.",
    "aanv.st.",
    "aanw.",
    "vnw.",
    "aanw.vnw.",
    "abd.",
    "abm.",
    "abs.",
    "acc.act.",
    "acc.bedr.m.",
    "acc.bedr.t.",
    "achterv.",
    "act.dr.",
    "act.dr.fam.",
    "act.fisc.",
    "act.soc.",
    "adm.akk.",
    "adm.besl.",
    "adm.lex.",
    "adm.onderr.",
    "adm.ov.",
    "adv.",
    "adv.",
    "gen.",
    "adv.bl.",
    "afd.",
    "afl.",
    "aggl.verord.",
    "agr.",
    "al.",
    "alg.",
    "alg.richts.",
    "amén.",
    "ann.dr.",
    "ann.dr.lg.",
    "ann.dr.sc.pol.",
    "ann.ét.eur.",
    "ann.fac.dr.lg.",
    "ann.jur.créd.",
    "ann.jur.créd.règl.coll.",
    "ann.not.",
    "ann.parl.",
    "ann.prat.comm.",
    "app.",
    "arb.",
    "aud.",
    "arbbl.",
    "arbh.",
    "arbit.besl.",
    "arbrb.",
    "arr.",
    "arr.cass.",
    "arr.r.v.st.",
    "arr.verbr.",
    "arrondrb.",
    "art.",
    "artw.",
    "aud.",
    "b.",
    "b.",
    "b.&w.",
    "b.a.",
    "b.a.s.",
    "b.b.o.",
    "b.best.dep.",
    "b.br.ex.",
    "b.coll.fr.gem.comm.",
    "b.coll.vl.gem.comm.",
    "b.d.cult.r.",
    "b.d.gem.ex.",
    "b.d.gem.reg.",
    "b.dep.",
    "b.e.b.",
    "b.f.r.",
    "b.fr.gem.ex.",
    "b.fr.gem.reg.",
    "b.i.h.",
    "b.inl.j.d.",
    "b.inl.s.reg.",
    "b.j.",
    "b.l.",
    "b.o.z.",
    "b.prov.r.",
    "b.r.h.",
    "b.s.",
    "b.sr.",
    "b.stb.",
    "b.t.i.r.",
    "b.t.s.z.",
    "b.t.w.rev.",
    "b.v.",
    "b.ver.coll.gem.gem.comm.",
    "b.verg.r.b.",
    "b.versl.",
    "b.vl.ex.",
    "b.voorl.reg.",
    "b.w.",
    "b.w.gew.ex.",
    "b.z.d.g.",
    "b.z.v.",
    "bab.",
    "bedr.org.",
    "begins.",
    "beheersov.",
    "bekendm.comm.",
    "bel.",
    "bel.besch.",
    "bel.w.p.",
    "beleidsov.",
    "belg.",
    "grondw.",
    "ber.",
    "ber.w.",
    "besch.",
    "besl.",
    "beslagr.",
    "bestuurswet.",
    "bet.",
    "betr.",
    "betr.",
    "vnw.",
    "bevest.",
    "bew.",
    "bijbl.",
    "ind.",
    "eig.",
    "bijbl.n.bijdr.",
    "bijl.",
    "bijv.",
    "bijw.",
    "bijz.decr.",
    "bin.b.",
    "bkh.",
    "bl.",
    "blz.",
    "bm.",
    "bn.",
    "rh.",
    "bnw.",
    "bouwr.",
    "br.parl.",
    "bs.",
    "bull.",
    "bull.adm.pénit.",
    "bull.ass.",
    "bull.b.m.m.",
    "bull.bel.",
    "bull.best.strafinr.",
    "bull.bmm.",
    "bull.c.b.n.",
    "bull.c.n.c.",
    "bull.cbn.",
    "bull.centr.arb.",
    "bull.cnc.",
    "bull.contr.",
    "bull.doc.min.fin.",
    "bull.f.e.b.",
    "bull.feb.",
    "bull.fisc.fin.r.",
    "bull.i.u.m.",
    "bull.inf.ass.secr.soc.",
    "bull.inf.i.e.c.",
    "bull.inf.i.n.a.m.i.",
    "bull.inf.i.r.e.",
    "bull.inf.iec.",
    "bull.inf.inami.",
    "bull.inf.ire.",
    "bull.inst.arb.",
    "bull.ium.",
    "bull.jur.imm.",
    "bull.lég.b.",
    "bull.off.",
    "bull.trim.b.dr.comp.",
    "bull.us.",
    "bull.v.b.o.",
    "bull.vbo.",
    "bv.",
    "bw.",
    "bxh.",
    "byz.",
    "c.",
    "c.a.",
    "c.a.-a.",
    "c.a.b.g.",
    "c.c.",
    "c.c.i.",
    "c.c.s.",
    "c.conc.jur.",
    "c.d.e.",
    "c.d.p.k.",
    "c.e.",
    "c.ex.",
    "c.f.",
    "c.h.a.",
    "c.i.f.",
    "c.i.f.i.c.",
    "c.j.",
    "c.l.",
    "c.n.",
    "c.o.d.",
    "c.p.",
    "c.pr.civ.",
    "c.q.",
    "c.r.",
    "c.r.a.",
    "c.s.",
    "c.s.a.",
    "c.s.q.n.",
    "c.v.",
    "c.v.a.",
    "c.v.o.",
    "ca.",
    "cadeaust.",
    "cah.const.",
    "cah.dr.europ.",
    "cah.dr.immo.",
    "cah.dr.jud.",
    "cal.",
    "2d.",
    "cal.",
    "3e.",
    "cal.",
    "rprt.",
    "cap.",
    "carg.",
    "cass.",
    "cass.",
    "verw.",
    "cert.",
    "cf.",
    "ch.",
    "chron.",
    "chron.d.s.",
    "chron.dr.not.",
    "cie.",
    "cie.",
    "verz.schr.",
    "cir.",
    "circ.",
    "circ.z.",
    "cit.",
    "cit.loc.",
    "civ.",
    "cl.et.b.",
    "cmt.",
    "co.",
    "cognoss.v.",
    "coll.",
    "v.",
    "b.",
    "colp.w.",
    "com.",
    "com.",
    "cas.",
    "com.v.min.",
    "comm.",
    "comm.",
    "v.",
    "comm.bijz.ov.",
    "comm.erf.",
    "comm.fin.",
    "comm.ger.",
    "comm.handel.",
    "comm.pers.",
    "comm.pub.",
    "comm.straf.",
    "comm.v.",
    "comm.venn.",
    "comm.verz.",
    "comm.voor.",
    "comp.",
    "compt.w.",
    "computerr.",
    "con.m.",
    "concl.",
    "concr.",
    "conf.",
    "confl.w.",
    "confl.w.huwbetr.",
    "cons.",
    "conv.",
    "coöp.",
    "ver.",
    "corr.",
    "corr.bl.",
    "cour.fisc.",
    "cour.immo.",
    "cridon.",
    "crim.",
    "cur.",
    "cur.",
    "crt.",
    "curs.",
    "d.",
    "d.-g.",
    "d.a.",
    "d.a.v.",
    "d.b.f.",
    "d.c.",
    "d.c.c.r.",
    "d.d.",
    "d.d.p.",
    "d.e.t.",
    "d.gem.r.",
    "d.h.",
    "d.h.z.",
    "d.i.",
    "d.i.t.",
    "d.j.",
    "d.l.r.",
    "d.m.",
    "d.m.v.",
    "d.o.v.",
    "d.parl.",
    "d.w.z.",
    "dact.",
    "dat.",
    "dbesch.",
    "dbesl.",
    "dec.",
    "decr.",
    "decr.d.",
    "decr.fr.",
    "decr.vl.",
    "decr.w.",
    "def.",
    "dep.opv.",
    "dep.rtl.",
    "derg.",
    "desp.",
    "det.mag.",
    "deurw.regl.",
    "dez.",
    "dgl.",
    "dhr.",
    "disp.",
    "diss.",
    "div.",
    "div.act.",
    "div.bel.",
    "dl.",
    "dln.",
    "dnotz.",
    "doc.",
    "hist.",
    "doc.jur.b.",
    "doc.min.fin.",
    "doc.parl.",
    "doctr.",
    "dpl.",
    "dpl.besl.",
    "dr.",
    "dr.banc.fin.",
    "dr.circ.",
    "dr.inform.",
    "dr.mr.",
    "dr.pén.entr.",
    "dr.q.m.",
    "drs.",
    "ds.",
    "dtp.",
    "dwz.",
    "dyn.",
    "e.",
    "e.a.",
    "e.b.",
    "tek.mod.",
    "e.c.",
    "e.c.a.",
    "e.d.",
    "e.e.",
    "e.e.a.",
    "e.e.g.",
    "e.g.",
    "e.g.a.",
    "e.h.a.",
    "e.i.",
    "e.j.",
    "e.m.a.",
    "e.n.a.c.",
    "e.o.",
    "e.p.c.",
    "e.r.c.",
    "e.r.f.",
    "e.r.h.",
    "e.r.o.",
    "e.r.p.",
    "e.r.v.",
    "e.s.r.a.",
    "e.s.t.",
    "e.v.",
    "e.v.a.",
    "e.w.",
    "e&o.e.",
    "ec.pol.r.",
    "econ.",
    "ed.",
    "ed(s).",
    "eff.",
    "eig.",
    "eig.mag.",
    "eil.",
    "elektr.",
    "enmb.",
    "enz.",
    "err.",
    "etc.",
    "etq.",
    "eur.",
    "parl.",
    "eur.t.s.",
    "ev.",
    "evt.",
    "ex.",
    "ex.crim.",
    "exec.",
    "f.",
    "f.a.o.",
    "f.a.q.",
    "f.a.s.",
    "f.i.b.",
    "f.j.f.",
    "f.o.b.",
    "f.o.r.",
    "f.o.s.",
    "f.o.t.",
    "f.r.",
    "f.supp.",
    "f.suppl.",
    "fa.",
    "facs.",
    "fasc.",
    "fg.",
    "fid.ber.",
    "fig.",
    "fin.verh.w.",
    "fisc.",
    "fisc.",
    "tijdschr.",
    "fisc.act.",
    "fisc.koer.",
    "fl.",
    "form.",
    "foro.",
    "it.",
    "fr.",
    "fr.cult.r.",
    "fr.gem.r.",
    "fr.parl.",
    "fra.",
    "ft.",
    "g.",
    "g.a.",
    "g.a.v.",
    "g.a.w.v.",
    "g.g.d.",
    "g.m.t.",
    "g.o.",
    "g.omt.e.",
    "g.p.",
    "g.s.",
    "g.v.",
    "g.w.w.",
    "geb.",
    "gebr.",
    "gebrs.",
    "gec.",
    "gec.decr.",
    "ged.",
    "ged.st.",
    "gedipl.",
    "gedr.st.",
    "geh.",
    "gem.",
    "gem.",
    "gem.",
    "gem.gem.comm.",
    "gem.st.",
    "gem.stem.",
    "gem.w.",
    "gemeensch.optr.",
    "gemeensch.standp.",
    "gemeensch.strat.",
    "gemeent.",
    "gemeent.b.",
    "gemeent.regl.",
    "gemeent.verord.",
    "geol.",
    "geopp.",
    "gepubl.",
    "ger.deurw.",
    "ger.w.",
    "gerekw.",
    "gereq.",
    "gesch.",
    "get.",
    "getr.",
    "gev.m.",
    "gev.maatr.",
    "gew.",
    "ghert.",
    "gir.eff.verk.",
    "gk.",
    "gr.",
    "gramm.",
    "grat.w.",
    "grootb.w.",
    "grs.",
    "grvm.",
    "grw.",
    "gst.",
    "gw.",
    "h.a.",
    "h.a.v.o.",
    "h.b.o.",
    "h.e.a.o.",
    "h.e.g.a.",
    "h.e.geb.",
    "h.e.gestr.",
    "h.l.",
    "h.m.",
    "h.o.",
    "h.r.",
    "h.t.l.",
    "h.t.m.",
    "h.w.geb.",
    "hand.",
    "handelsn.w.",
    "handelspr.",
    "handelsr.w.",
    "handelsreg.w.",
    "handv.",
    "harv.l.rev.",
    "hc.",
    "herald.",
    "hert.",
    "herz.",
    "hfdst.",
    "hfst.",
    "hgrw.",
    "hhr.",
    "hist.",
    "hooggel.",
    "hoogl.",
    "hosp.",
    "hpw.",
    "hr.",
    "hr.",
    "ms.",
    "hr.ms.",
    "hregw.",
    "hrg.",
    "hst.",
    "huis.just.",
    "huisv.w.",
    "huurbl.",
    "hv.vn.",
    "hw.",
    "hyp.w.",
    "i.b.s.",
    "i.c.",
    "i.c.m.h.",
    "i.e.",
    "i.f.",
    "i.f.p.",
    "i.g.v.",
    "i.h.",
    "i.h.a.",
    "i.h.b.",
    "i.l.pr.",
    "i.o.",
    "i.p.o.",
    "i.p.r.",
    "i.p.v.",
    "i.pl.v.",
    "i.r.d.i.",
    "i.s.m.",
    "i.t.t.",
    "i.v.",
    "i.v.m.",
    "i.v.s.",
    "i.w.tr.",
    "i.z.",
    "ib.",
    "ibid.",
    "icip-ing.cons.",
    "iem.",
    "inc.",
    "indic.soc.",
    "indiv.",
    "inf.",
    "inf.i.d.a.c.",
    "inf.idac.",
    "inf.r.i.z.i.v.",
    "inf.riziv.",
    "inf.soc.secr.",
    "ing.",
    "ing.",
    "cons.",
    "ing.cons.",
    "inst.",
    "int.",
    "int.",
    "rechtsh.",
    "strafz.",
    "interm.",
    "intern.fisc.act.",
    "intern.vervoerr.",
    "inv.",
    "inv.",
    "f.",
    "inv.w.",
    "inv.wet.",
    "invord.w.",
    "inz.",
    "ir.",
    "irspr.",
    "iwtr.",
    "j.",
    "j.-cl.",
    "j.c.b.",
    "j.c.e.",
    "j.c.fl.",
    "j.c.j.",
    "j.c.p.",
    "j.d.e.",
    "j.d.f.",
    "j.d.s.c.",
    "j.dr.jeun.",
    "j.j.d.",
    "j.j.p.",
    "j.j.pol.",
    "j.l.",
    "j.l.m.b.",
    "j.l.o.",
    "j.p.a.",
    "j.r.s.",
    "j.t.",
    "j.t.d.e.",
    "j.t.dr.eur.",
    "j.t.o.",
    "j.t.t.",
    "jaarl.",
    "jb.hand.",
    "jb.kred.",
    "jb.kred.c.s.",
    "jb.l.r.b.",
    "jb.lrb.",
    "jb.markt.",
    "jb.mens.",
    "jb.t.r.d.",
    "jb.trd.",
    "jeugdrb.",
    "jeugdwerkg.w.",
    "jhr.",
    "jg.",
    "jis.",
    "jl.",
    "journ.jur.",
    "journ.prat.dr.fisc.fin.",
    "journ.proc.",
    "jr.",
    "jrg.",
    "jur.",
    "jur.comm.fl.",
    "jur.dr.soc.b.l.n.",
    "jur.f.p.e.",
    "jur.fpe.",
    "jur.niv.",
    "jur.trav.brux.",
    "jurambt.",
    "jv.cass.",
    "jv.h.r.j.",
    "jv.hrj.",
    "jw.",
    "k.",
    "k.",
    "k.b.",
    "k.g.",
    "k.k.",
    "k.m.b.o.",
    "k.o.o.",
    "k.v.k.",
    "k.v.v.v.",
    "kadasterw.",
    "kaderb.",
    "kador.",
    "kbo-nr.",
    "kg.",
    "kh.",
    "kiesw.",
    "kind.bes.v.",
    "kkr.",
    "kon.",
    "koopv.",
    "kr.",
    "krankz.w.",
    "ksbel.",
    "kt.",
    "ktg.",
    "ktr.",
    "kvdm.",
    "kw.r.",
    "kymr.",
    "kzr.",
    "kzw.",
    "l.",
    "l.b.",
    "l.b.o.",
    "l.bas.",
    "l.c.",
    "l.gew.",
    "l.j.",
    "l.k.",
    "l.l.",
    "l.o.",
    "l.p.",
    "l.r.b.",
    "l.u.v.i.",
    "l.v.r.",
    "l.v.w.",
    "l.w.",
    "l'exp.-compt.b..",
    "l’exp.-compt.b.",
    "landinr.w.",
    "landscrt.",
    "lat.",
    "law.ed.",
    "lett.",
    "levensverz.",
    "lgrs.",
    "lidw.",
    "limb.rechtsl.",
    "lit.",
    "litt.",
    "liw.",
    "liwet.",
    "lk.",
    "ll.",
    "ll.(l.)l.r.",
    "loonw.",
    "losbl.",
    "ltd.",
    "luchtv.",
    "luchtv.w.",
    "m.",
    "m.",
    "not.",
    "m.a.v.o.",
    "m.a.w.",
    "m.b.",
    "m.b.o.",
    "m.b.r.",
    "m.b.t.",
    "m.d.g.o.",
    "m.e.a.o.",
    "m.e.r.",
    "m.h.",
    "m.h.d.",
    "m.i.v.",
    "m.j.t.",
    "m.k.",
    "m.m.",
    "m.m.a.",
    "m.m.h.h.",
    "m.m.v.",
    "m.n.",
    "m.not.fisc.",
    "m.nt.",
    "m.o.",
    "m.r.",
    "m.s.a.",
    "m.u.p.",
    "m.v.a.",
    "m.v.h.n.",
    "m.v.t.",
    "m.z.",
    "maatr.teboekgest.luchtv.",
    "maced.",
    "mand.",
    "max.",
    "mbl.not.",
    "me.",
    "med.",
    "med.",
    "v.b.o.",
    "med.b.u.f.r.",
    "med.bufr.",
    "med.vbo.",
    "meerv.",
    "meetbr.w.",
    "mej.",
    "mevr.",
    "mém.adm.",
    "mgr.",
    "mgrs.",
    "mhd.",
    "mi.verantw.",
    "mil.",
    "mil.bed.",
    "mil.ger.",
    "min.",
    "min.",
    "aanbev.",
    "min.",
    "circ.",
    "min.",
    "fin.",
    "min.j.omz.",
    "min.just.circ.",
    "mitt.",
    "mln.",
    "mnd.",
    "mod.",
    "mon.",
    "mouv.comm.",
    "mr.",
    "ms.",
    "muz.",
    "mv.",
    "n.",
    "chr.",
    "n.a.",
    "n.a.g.",
    "n.a.v.",
    "n.b.",
    "n.c.",
    "n.chr.",
    "n.d.",
    "n.d.r.",
    "n.e.a.",
    "n.g.",
    "n.h.b.c.",
    "n.j.",
    "n.j.b.",
    "n.j.w.",
    "n.l.",
    "n.m.",
    "n.m.m.",
    "n.n.",
    "n.n.b.",
    "n.n.g.",
    "n.n.k.",
    "n.o.m.",
    "n.o.t.k.",
    "n.rapp.",
    "n.tijd.pol.",
    "n.v.",
    "n.v.d.r.",
    "n.v.d.v.",
    "n.v.o.b.",
    "n.v.t.",
    "nat.besch.w.",
    "nat.omb.",
    "nat.pers.",
    "ned.",
    "ned.cult.r.",
    "neg.verkl.",
    "nhd.",
    "wisk.",
    "njcm-bull.",
    "nl.",
    "nnd.",
    "no.",
    "not.fisc.m.",
    "not.w.",
    "not.wet.",
    "nr.",
    "nrs.",
    "nste.",
    "nt.",
    "numism.",
    "o.",
    "o.a.",
    "o.b.",
    "o.c.",
    "o.g.",
    "o.g.v.",
    "o.i.",
    "o.i.d.",
    "o.m.",
    "o.o.",
    "o.o.d.",
    "o.o.v.",
    "o.p.",
    "o.r.",
    "o.regl.",
    "o.s.",
    "o.t.s.",
    "o.t.t.",
    "o.t.t.t.",
    "o.t.t.z.",
    "o.tk.t.",
    "o.v.t.",
    "o.v.t.t.",
    "o.v.tk.t.",
    "o.v.v.",
    "ob.",
    "obsv.",
    "octr.",
    "octr.gem.regl.",
    "octr.regl.",
    "oe.",
    "off.pol.",
    "ofra.",
    "ohd.",
    "omb.",
    "omnil.",
    "omz.",
    "on.ww.",
    "onderr.",
    "onfrank.",
    "onteig.w.",
    "ontw.",
    "b.w.",
    "onuitg.",
    "onz.",
    "oorl.w.",
    "op.cit.",
    "opin.pa.",
    "opm.",
    "or.",
    "ord.br.",
    "ord.gem.",
    "ors.",
    "orth.",
    "os.",
    "osm.",
    "ov.",
    "ov.w.i.",
    "ov.w.ii.",
    "ov.ww.",
    "overg.w.",
    "overw.",
    "ovkst.",
    "oz.",
    "p.",
    "p.a.",
    "p.a.o.",
    "p.b.o.",
    "p.e.",
    "p.g.",
    "p.j.",
    "p.m.",
    "p.m.a.",
    "p.o.",
    "p.o.j.t.",
    "p.p.",
    "p.v.",
    "p.v.s.",
    "pachtw.",
    "pag.",
    "pan.",
    "pand.b.",
    "pand.pér.",
    "parl.gesch.",
    "parl.gesch.",
    "inv.",
    "parl.st.",
    "part.arb.",
    "pas.",
    "pasin.",
    "pat.",
    "pb.c.",
    "pb.l.",
    "pct.",
    "pens.",
    "pensioenverz.",
    "per.ber.i.b.r.",
    "per.ber.ibr.",
    "pers.",
    "st.",
    "pft.",
    "pk.",
    "pktg.",
    "plv.",
    "po.",
    "pol.",
    "pol.off.",
    "pol.r.",
    "pol.w.",
    "postbankw.",
    "postw.",
    "pp.",
    "pr.",
    "preadv.",
    "pres.",
    "prf.",
    "prft.",
    "prg.",
    "prijz.w.",
    "proc.",
    "procesregl.",
    "prof.",
    "prot.",
    "prov.",
    "prov.b.",
    "prov.instr.h.m.g.",
    "prov.regl.",
    "prov.verord.",
    "prov.w.",
    "publ.",
    "pun.",
    "pw.",
    "q.b.d.",
    "q.e.d.",
    "q.q.",
    "q.r.",
    "r.",
    "r.a.b.g.",
    "r.a.c.e.",
    "r.a.j.b.",
    "r.b.d.c.",
    "r.b.d.i.",
    "r.b.s.s.",
    "r.c.",
    "r.c.b.",
    "r.c.d.c.",
    "r.c.j.b.",
    "r.c.s.j.",
    "r.cass.",
    "r.d.c.",
    "r.d.i.",
    "r.d.i.d.c.",
    "r.d.j.b.",
    "r.d.j.p.",
    "r.d.p.c.",
    "r.d.s.",
    "r.d.t.i.",
    "r.e.",
    "r.f.s.v.p.",
    "r.g.a.r.",
    "r.g.c.f.",
    "r.g.d.c.",
    "r.g.f.",
    "r.g.z.",
    "r.h.a.",
    "r.i.c.",
    "r.i.d.a.",
    "r.i.e.j.",
    "r.i.n.",
    "r.i.s.a.",
    "r.j.d.a.",
    "r.j.i.",
    "r.k.",
    "r.l.",
    "r.l.g.b.",
    "r.med.",
    "r.med.rechtspr.",
    "r.n.b.",
    "r.o.",
    "r.ov.",
    "r.p.",
    "r.p.d.b.",
    "r.p.o.t.",
    "r.p.r.j.",
    "r.p.s.",
    "r.r.d.",
    "r.r.s.",
    "r.s.",
    "r.s.v.p.",
    "r.stvb.",
    "r.t.d.f.",
    "r.t.d.h.",
    "r.t.l.",
    "r.trim.dr.eur.",
    "r.v.a.",
    "r.verkb.",
    "r.w.",
    "r.w.d.",
    "rap.ann.c.a.",
    "rap.ann.c.c.",
    "rap.ann.c.e.",
    "rap.ann.c.s.j.",
    "rap.ann.ca.",
    "rap.ann.cass.",
    "rap.ann.cc.",
    "rap.ann.ce.",
    "rap.ann.csj.",
    "rapp.",
    "rb.",
    "rb.kh.",
    "rdn.",
    "rdnr.",
    "re.pers.",
    "rec.",
    "rec.c.i.j.",
    "rec.c.j.c.e.",
    "rec.cij.",
    "rec.cjce.",
    "rec.gén.enr.not.",
    "rechtsk.t.",
    "rechtspl.zeem.",
    "rechtspr.arb.br.",
    "rechtspr.b.f.e.",
    "rechtspr.bfe.",
    "rechtspr.soc.r.b.l.n.",
    "recl.reg.",
    "rect.",
    "red.",
    "reg.",
    "reg.huiz.bew.",
    "reg.w.",
    "registr.w.",
    "regl.",
    "regl.",
    "r.v.k.",
    "regl.besl.",
    "regl.onderr.",
    "regl.r.t.",
    "rep.",
    "rép.fisc.",
    "rép.not.",
    "rep.r.j.",
    "rep.rj.",
    "req.",
    "res.",
    "resp.",
    "rev.",
    "rev.",
    "comp.",
    "rev.",
    "trim.",
    "civ.",
    "rev.",
    "trim.",
    "comm.",
    "rev.acc.trav.",
    "rev.adm.",
    "rev.b.compt.",
    "rev.b.dr.const.",
    "rev.b.dr.intern.",
    "rev.b.séc.soc.",
    "rev.banc.fin.",
    "rev.comm.",
    "rev.cons.prud.",
    "rev.dr.b.",
    "rev.dr.commun.",
    "rev.dr.étr.",
    "rev.dr.fam.",
    "rev.dr.intern.comp.",
    "rev.dr.mil.",
    "rev.dr.min.",
    "rev.dr.pén.",
    "rev.dr.pén.mil.",
    "rev.dr.rur.",
    "rev.dr.u.l.b.",
    "rev.dr.ulb.",
    "rev.exp.",
    "rev.faill.",
    "rev.fisc.",
    "rev.gd.",
    "rev.hist.dr.",
    "rev.i.p.c.",
    "rev.ipc.",
    "rev.not.b.",
    "rev.prat.dr.comm.",
    "rev.prat.not.b.",
    "rev.prat.soc.",
    "rev.rec.",
    "rev.rw.",
    "rev.trav.",
    "rev.trim.d.h.",
    "rev.trim.dr.fam.",
    "rev.urb.",
    "richtl.",
    "riv.dir.int.",
    "riv.dir.int.priv.proc.",
    "rk.",
    "rln.",
    "roln.",
    "rom.",
    "rondz.",
    "rov.",
    "rtl.",
    "rubr.",
    "ruilv.wet.",
    "rv.verdr.",
    "rvkb.",
    "s.",
    "s.",
    "s.a.",
    "s.b.n.",
    "s.ct.",
    "s.d.",
    "s.e.c.",
    "s.e.et.o.",
    "s.e.w.",
    "s.exec.rept.",
    "s.hrg.",
    "s.j.b.",
    "s.l.",
    "s.l.e.a.",
    "s.l.n.d.",
    "s.p.a.",
    "s.s.",
    "s.t.",
    "s.t.b.",
    "s.v.",
    "s.v.p.",
    "samenw.",
    "sc.",
    "sch.",
    "scheidsr.uitspr.",
    "schepel.besl.",
    "sec.",
    "secr.comm.",
    "secr.gen.",
    "sect.soc.",
    "sess.",
    "cas.",
    "sir.",
    "soc.",
    "best.",
    "soc.",
    "handv.",
    "soc.",
    "verz.",
    "soc.act.",
    "soc.best.",
    "soc.kron.",
    "soc.r.",
    "soc.sw.",
    "soc.weg.",
    "sofi-nr.",
    "somm.",
    "somm.ann.",
    "sp.c.c.",
    "sr.",
    "ss.",
    "st.doc.b.c.n.a.r.",
    "st.doc.bcnar.",
    "st.vw.",
    "stagever.",
    "stas.",
    "stat.",
    "stb.",
    "stbl.",
    "stcrt.",
    "stud.dipl.",
    "su.",
    "subs.",
    "subst.",
    "succ.w.",
    "suppl.",
    "sv.",
    "sw.",
    "t.",
    "t.a.",
    "t.a.a.",
    "t.a.n.",
    "t.a.p.",
    "t.a.s.n.",
    "t.a.v.",
    "t.a.v.w.",
    "t.aann.",
    "t.acc.",
    "t.agr.r.",
    "t.app.",
    "t.b.b.r.",
    "t.b.h.",
    "t.b.m.",
    "t.b.o.",
    "t.b.p.",
    "t.b.r.",
    "t.b.s.",
    "t.b.v.",
    "t.bankw.",
    "t.belg.not.",
    "t.desk.",
    "t.e.m.",
    "t.e.p.",
    "t.f.r.",
    "t.fam.",
    "t.fin.r.",
    "t.g.r.",
    "t.g.t.",
    "t.g.v.",
    "t.gem.",
    "t.gez.",
    "t.huur.",
    "t.i.n.",
    "t.j.k.",
    "t.l.l.",
    "t.l.v.",
    "t.m.",
    "t.m.r.",
    "t.m.w.",
    "t.mil.r.",
    "t.mil.strafr.",
    "t.not.",
    "t.o.",
    "t.o.r.b.",
    "t.o.v.",
    "t.ontv.",
    "t.p.r.",
    "t.pol.",
    "t.r.",
    "t.r.g.",
    "t.r.o.s.",
    "t.r.v.",
    "t.s.r.",
    "t.strafr.",
    "t.t.",
    "t.u.",
    "t.v.c.",
    "t.v.g.",
    "t.v.m.r.",
    "t.v.o.",
    "t.v.v.",
    "t.v.v.d.b.",
    "t.v.w.",
    "t.verz.",
    "t.vred.",
    "t.vreemd.",
    "t.w.",
    "t.w.k.",
    "t.w.v.",
    "t.w.v.r.",
    "t.wrr.",
    "t.z.",
    "t.z.t.",
    "t.z.v.",
    "taalk.",
    "tar.burg.z.",
    "td.",
    "techn.",
    "telecomm.",
    "th.",
    "toel.",
    "toel.st.v.w.",
    "toep.",
    "toep.regl.",
    "tom.",
    "top.",
    "trans.b.",
    "transp.r.",
    "trb.",
    "trib.",
    "trib.civ.",
    "trib.gr.inst.",
    "ts.",
    "ts.",
    "best.",
    "ts.",
    "verv.",
    "turnh.rechtsl.",
    "tvpol.",
    "tvpr.",
    "tvrechtsgesch.",
    "tw.",
    "u.",
    "u.a.",
    "u.a.r.",
    "u.a.v.",
    "u.c.",
    "u.c.c.",
    "u.g.",
    "u.p.",
    "u.s.",
    "u.s.d.c.",
    "uitdr.",
    "uitl.w.",
    "uitv.besch.div.b.",
    "uitv.besl.",
    "uitv.besl.",
    "succ.w.",
    "uitv.besl.bel.rv.",
    "uitv.besl.l.b.",
    "uitv.reg.",
    "inv.w.",
    "uitv.reg.bel.d.",
    "uitv.reg.afd.verm.",
    "uitv.reg.lb.",
    "uitv.reg.succ.w.",
    "univ.",
    "univ.verkl.",
    "v.",
    "v.",
    "chr.",
    "v.a.",
    "v.a.v.",
    "v.c.",
    "v.C.",
    "v.Chr.",
    "v.chr.",
    "v.d.",
    "v.h.",
    "v.huw.verm.",
    "v.i.",
    "v.i.o.",
    "v.j.",
    "v.k.a.",
    "v.m.",
    "v.o.f.",
    "v.o.n.",
    "v.onderh.verpl.",
    "v.p.",
    "v.r.",
    "v.s.o.",
    "v.t.t.",
    "v.t.t.t.",
    "v.tk.t.",
    "v.toep.r.vert.",
    "v.v.b.",
    "v.v.g.",
    "v.v.t.",
    "v.v.t.t.",
    "v.v.tk.t.",
    "v.w.b.",
    "v.z.m.",
    "vb.",
    "vb.bo.",
    "vbb.",
    "vc.",
    "vd.",
    "veldw.",
    "ver.k.",
    "ver.verg.gem.",
    "gem.comm.",
    "verbr.",
    "verd.",
    "verdr.",
    "verdr.v.",
    "tek.mod.",
    "verenw.",
    "verg.",
    "verg.fr.gem.",
    "comm.",
    "verkl.",
    "verkl.herz.gw.",
    "verl.",
    "deelw.",
    "vern.",
    "verord.",
    "vers.r.",
    "versch.",
    "versl.c.s.w.",
    "versl.csw.",
    "vert.",
    "verw.",
    "verz.",
    "verz.w.",
    "verz.wett.besl.",
    "verz.wett.decr.besl.",
    "vgl.",
    "vid.",
    "viss.w.",
    "vl.parl.",
    "vl.r.",
    "vl.t.gez.",
    "vl.w.reg.",
    "vl.w.succ.",
    "vlg.",
    "vn.",
    "vnl.",
    "vnw.",
    "vo.",
    "vo.bl.",
    "voegw.",
    "vol.",
    "volg.",
    "volt.",
    "deelw.",
    "voorl.",
    "voorz.",
    "vord.w.",
    "vorst.d.",
    "vr.",
    "vred.",
    "vrg.",
    "vnw.",
    "vrijgrs.",
    "vs.",
    "vt.",
    "vw.",
    "vz.",
    "vzngr.",
    "vzr.",
    "w.",
    "w.a.",
    "w.b.r.",
    "w.c.h.",
    "w.conf.huw.",
    "w.conf.huwelijksb.",
    "w.consum.kr.",
    "w.f.r.",
    "w.g.",
    "w.gew.r.",
    "w.ident.pl.",
    "w.just.doc.",
    "w.kh.",
    "w.l.r.",
    "w.l.v.",
    "w.mil.straf.spr.",
    "w.n.",
    "w.not.ambt.",
    "w.o.",
    "w.o.d.huurcomm.",
    "w.o.d.k.",
    "w.openb.manif.",
    "w.parl.",
    "w.r.",
    "w.reg.",
    "w.succ.",
    "w.u.b.",
    "w.uitv.pl.verord.",
    "w.v.",
    "w.v.k.",
    "w.v.m.s.",
    "w.v.r.",
    "w.v.w.",
    "w.venn.",
    "wac.",
    "wd.",
    "wetb.",
    "n.v.h.",
    "wgb.",
    "winkelt.w.",
    "wisk.",
    "wka-verkl.",
    "wnd.",
    "won.w.",
    "woningw.",
    "woonr.w.",
    "wrr.",
    "wrr.ber.",
    "wrsch.",
    "ws.",
    "wsch.",
    "wsr.",
    "wtvb.",
    "ww.",
    "x.d.",
    "z.a.",
    "z.g.",
    "z.i.",
    "z.j.",
    "z.o.z.",
    "z.p.",
    "z.s.m.",
    "zg.",
    "zgn.",
    "zn.",
    "znw.",
    "zr.",
    "zr.",
    "ms.",
    "zr.ms.",
    "'m",
    "'n",
    "'ns",
    "'s",
    "'t",
]

_exc = {}
for orth in abbrevs:
    _exc[orth] = [{ORTH: orth}]
    uppered = orth.upper()
    capsed = orth.capitalize()
    for i in [uppered, capsed]:
        _exc[i] = [{ORTH: i}]


TOKENIZER_EXCEPTIONS = _exc
