# coding: utf8
from __future__ import unicode_literals

from ...symbols import POS, PUNCT, SYM, ADJ, NUM, DET, ADV, ADP, X, VERB, NOUN
from ...symbols import PROPN, PART, INTJ, PRON, SCONJ, AUX, CCONJ

# fmt: off
TAG_MAP = {
    "ADJ__Animacy=Anim|Case=Acc|Degree=Pos|Gender=Masc|Number=Sing": {POS: ADJ, "Animacy": "Anim", "Case": "Acc", "Degree": "Pos", "Gender": "Masc", "Number": "Sing"},
    "ADJ__Animacy=Anim|Case=Acc|Degree=Pos|Number=Plur": {POS: ADJ, "Animacy": "Anim", "Case": "Acc", "Degree": "Pos", "Number": "Plur"},
    "ADJ__Animacy=Anim|Case=Acc|Degree=Sup|Gender=Masc|Number=Sing": {POS: ADJ, "Animacy": "Anim", "Case": "Acc", "Degree": "Sup", "Gender": "Masc", "Number": "Sing"},
    "ADJ__Animacy=Anim|Case=Nom|Degree=Pos|Number=Plur": {POS: ADJ, "Animacy": "Anim", "Case": "Nom", "Degree": "Pos", "Number": "Plur"},
    "ADJ__Animacy=Inan|Case=Acc|Degree=Pos|Gender=Masc|Number=Sing": {POS: ADJ, "Animacy": "Inan", "Case": "Acc", "Degree": "Pos", "Gender": "Masc", "Number": "Sing"},
    "ADJ__Animacy=Inan|Case=Acc|Degree=Pos|Gender=Neut|Number=Sing": {POS: ADJ, "Animacy": "Inan", "Case": "Acc", "Degree": "Pos", "Gender": "Neut", "Number": "Sing"},
    "ADJ__Animacy=Inan|Case=Acc|Degree=Pos|Number=Plur": {POS: ADJ, "Animacy": "Inan", "Case": "Acc", "Degree": "Pos", "Number": "Plur"},
    "ADJ__Animacy=Inan|Case=Acc|Degree=Sup|Gender=Masc|Number=Sing": {POS: ADJ, "Animacy": "Inan", "Case": "Acc", "Degree": "Sup", "Gender": "Masc", "Number": "Sing"},
    "ADJ__Animacy=Inan|Case=Acc|Degree=Sup|Number=Plur": {POS: ADJ, "Animacy": "Inan", "Case": "Acc", "Degree": "Sup", "Number": "Plur"},
    "ADJ__Animacy=Inan|Case=Acc|Gender=Fem|Number=Sing": {POS: ADJ, "Animacy": "Inan", "Case": "Acc", "Gender": "Fem", "Number": "Sing"},
    "ADJ__Animacy=Inan|Case=Nom|Degree=Pos|Gender=Fem|Number=Sing": {POS: ADJ, "Animacy": "Inan", "Case": "Nom", "Degree": "Pos", "Gender": "Fem", "Number": "Sing"},
    "ADJ__Case=Acc|Degree=Pos|Gender=Fem|Number=Sing": {POS: ADJ, "Case": "Acc", "Degree": "Pos", "Gender": "Fem", "Number": "Sing"},
    "ADJ__Case=Acc|Degree=Pos|Gender=Neut|Number=Sing": {POS: ADJ, "Case": "Acc", "Degree": "Pos", "Gender": "Neut", "Number": "Sing"},
    "ADJ__Case=Acc|Degree=Sup|Gender=Fem|Number=Sing": {POS: ADJ, "Case": "Acc", "Degree": "Sup", "Gender": "Fem", "Number": "Sing"},
    "ADJ__Case=Acc|Degree=Sup|Gender=Neut|Number=Sing": {POS: ADJ, "Case": "Acc", "Degree": "Sup", "Gender": "Neut", "Number": "Sing"},
    "ADJ__Case=Dat|Degree=Pos|Gender=Fem|Number=Sing": {POS: ADJ, "Case": "Dat", "Degree": "Pos", "Gender": "Fem", "Number": "Sing"},
    "ADJ__Case=Dat|Degree=Pos|Gender=Masc|Number=Sing": {POS: ADJ, "Case": "Dat", "Degree": "Pos", "Gender": "Masc", "Number": "Sing"},
    "ADJ__Case=Dat|Degree=Pos|Gender=Neut|Number=Sing": {POS: ADJ, "Case": "Dat", "Degree": "Pos", "Gender": "Neut", "Number": "Sing"},
    "ADJ__Case=Dat|Degree=Pos|Number=Plur": {POS: ADJ, "Case": "Dat", "Degree": "Pos", "Number": "Plur"},
    "ADJ__Case=Dat|Degree=Sup|Gender=Masc|Number=Sing": {POS: ADJ, "Case": "Dat", "Degree": "Sup", "Gender": "Masc", "Number": "Sing"},
    "ADJ__Case=Dat|Degree=Sup|Gender=Neut|Number=Sing": {POS: ADJ, "Case": "Dat", "Degree": "Sup", "Gender": "Neut", "Number": "Sing"},
    "ADJ__Case=Dat|Degree=Sup|Number=Plur": {POS: ADJ, "Case": "Dat", "Degree": "Sup", "Number": "Plur"},
    "ADJ__Case=Gen|Degree=Pos|Gender=Fem|Number=Sing": {POS: ADJ, "Case": "Gen", "Degree": "Pos", "Gender": "Fem", "Number": "Sing"},
    "ADJ__Case=Gen|Degree=Pos|Gender=Fem|Number=Sing|Variant=Short": {POS: ADJ, "Case": "Gen", "Degree": "Pos", "Gender": "Fem", "Number": "Sing", },
    "ADJ__Case=Gen|Degree=Pos|Gender=Masc|Number=Sing": {POS: ADJ, "Case": "Gen", "Degree": "Pos", "Gender": "Masc", "Number": "Sing"},
    "ADJ__Case=Gen|Degree=Pos|Gender=Neut|Number=Sing": {POS: ADJ, "Case": "Gen", "Degree": "Pos", "Gender": "Neut", "Number": "Sing"},
    "ADJ__Case=Gen|Degree=Pos|Number=Plur": {POS: ADJ, "Case": "Gen", "Degree": "Pos", "Number": "Plur"},
    "ADJ__Case=Gen|Degree=Sup|Gender=Fem|Number=Sing": {POS: ADJ, "Case": "Gen", "Degree": "Sup", "Gender": "Fem", "Number": "Sing"},
    "ADJ__Case=Gen|Degree=Sup|Gender=Masc|Number=Sing": {POS: ADJ, "Case": "Gen", "Degree": "Sup", "Gender": "Masc", "Number": "Sing"},
    "ADJ__Case=Gen|Degree=Sup|Gender=Neut|Number=Sing": {POS: ADJ, "Case": "Gen", "Degree": "Sup", "Gender": "Neut", "Number": "Sing"},
    "ADJ__Case=Gen|Degree=Sup|Number=Plur": {POS: ADJ, "Case": "Gen", "Degree": "Sup", "Number": "Plur"},
    "ADJ__Case=Ins|Degree=Pos|Gender=Fem|Number=Sing": {POS: ADJ, "Case": "Ins", "Degree": "Pos", "Gender": "Fem", "Number": "Sing"},
    "ADJ__Case=Ins|Degree=Pos|Gender=Masc|Number=Sing": {POS: ADJ, "Case": "Ins", "Degree": "Pos", "Gender": "Masc", "Number": "Sing"},
    "ADJ__Case=Ins|Degree=Pos|Gender=Neut|Number=Sing": {POS: ADJ, "Case": "Ins", "Degree": "Pos", "Gender": "Neut", "Number": "Sing"},
    "ADJ__Case=Ins|Degree=Pos|Number=Plur": {POS: ADJ, "Case": "Ins", "Degree": "Pos", "Number": "Plur"},
    "ADJ__Case=Ins|Degree=Sup|Gender=Fem|Number=Sing": {POS: ADJ, "Case": "Ins", "Degree": "Sup", "Gender": "Fem", "Number": "Sing"},
    "ADJ__Case=Ins|Degree=Sup|Gender=Masc|Number=Sing": {POS: ADJ, "Case": "Ins", "Degree": "Sup", "Gender": "Masc", "Number": "Sing"},
    "ADJ__Case=Ins|Degree=Sup|Gender=Neut|Number=Sing": {POS: ADJ, "Case": "Ins", "Degree": "Sup", "Gender": "Neut", "Number": "Sing"},
    "ADJ__Case=Ins|Degree=Sup|Number=Plur": {POS: ADJ, "Case": "Ins", "Degree": "Sup", "Number": "Plur"},
    "ADJ__Case=Loc|Degree=Pos|Gender=Fem|Number=Sing": {POS: ADJ, "Case": "Loc", "Degree": "Pos", "Gender": "Fem", "Number": "Sing"},
    "ADJ__Case=Loc|Degree=Pos|Gender=Masc|Number=Sing": {POS: ADJ, "Case": "Loc", "Degree": "Pos", "Gender": "Masc", "Number": "Sing"},
    "ADJ__Case=Loc|Degree=Pos|Gender=Neut|Number=Sing": {POS: ADJ, "Case": "Loc", "Degree": "Pos", "Gender": "Neut", "Number": "Sing"},
    "ADJ__Case=Loc|Degree=Pos|Number=Plur": {POS: ADJ, "Case": "Loc", "Degree": "Pos", "Number": "Plur"},
    "ADJ__Case=Loc|Degree=Sup|Gender=Fem|Number=Sing": {POS: ADJ, "Case": "Loc", "Degree": "Sup", "Gender": "Fem", "Number": "Sing"},
    "ADJ__Case=Loc|Degree=Sup|Gender=Masc|Number=Sing": {POS: ADJ, "Case": "Loc", "Degree": "Sup", "Gender": "Masc", "Number": "Sing"},
    "ADJ__Case=Loc|Degree=Sup|Gender=Neut|Number=Sing": {POS: ADJ, "Case": "Loc", "Degree": "Sup", "Gender": "Neut", "Number": "Sing"},
    "ADJ__Case=Loc|Degree=Sup|Number=Plur": {POS: ADJ, "Case": "Loc", "Degree": "Sup", "Number": "Plur"},
    "ADJ__Case=Nom|Degree=Pos|Gender=Fem|Number=Sing": {POS: ADJ, "Case": "Nom", "Degree": "Pos", "Gender": "Fem", "Number": "Sing"},
    "ADJ__Case=Nom|Degree=Pos|Gender=Masc|Number=Sing": {POS: ADJ, "Case": "Nom", "Degree": "Pos", "Gender": "Masc", "Number": "Sing"},
    "ADJ__Case=Nom|Degree=Pos|Gender=Neut|Number=Sing": {POS: ADJ, "Case": "Nom", "Degree": "Pos", "Gender": "Neut", "Number": "Sing"},
    "ADJ__Case=Nom|Degree=Pos|Number=Plur": {POS: ADJ, "Case": "Nom", "Degree": "Pos", "Number": "Plur"},
    "ADJ__Case=Nom|Degree=Sup|Gender=Fem|Number=Sing": {POS: ADJ, "Case": "Nom", "Degree": "Sup", "Gender": "Fem", "Number": "Sing"},
    "ADJ__Case=Nom|Degree=Sup|Gender=Masc|Number=Sing": {POS: ADJ, "Case": "Nom", "Degree": "Sup", "Gender": "Masc", "Number": "Sing"},
    "ADJ__Case=Nom|Degree=Sup|Gender=Neut|Number=Sing": {POS: ADJ, "Case": "Nom", "Degree": "Sup", "Gender": "Neut", "Number": "Sing"},
    "ADJ__Case=Nom|Degree=Sup|Number=Plur": {POS: ADJ, "Case": "Nom", "Degree": "Sup", "Number": "Plur"},
    "ADJ__Degree=Cmp": {POS: ADJ, "Degree": "Cmp"},
    "ADJ__Degree=Pos": {POS: ADJ, "Degree": "Pos"},
    "ADJ__Degree=Pos|Gender=Fem|Number=Sing|Variant=Short": {POS: ADJ, "Degree": "Pos", "Gender": "Fem", "Number": "Sing", },
    "ADJ__Degree=Pos|Gender=Masc|Number=Sing|Variant=Short": {POS: ADJ, "Degree": "Pos", "Gender": "Masc", "Number": "Sing", },
    "ADJ__Degree=Pos|Gender=Neut|Number=Sing|Variant=Short": {POS: ADJ, "Degree": "Pos", "Gender": "Neut", "Number": "Sing", },
    "ADJ__Degree=Pos|Number=Plur|Variant=Short": {POS: ADJ, "Degree": "Pos", "Number": "Plur", },
    "ADJ__Foreign=Yes": {POS: ADJ, "Foreign": "Yes"},
    "ADJ___": {POS: ADJ},
    "ADJ": {POS: ADJ},
    "ADP___": {POS: ADP},
    "ADP": {POS: ADP},
    "ADV__Degree=Cmp": {POS: ADV, "Degree": "Cmp"},
    "ADV__Degree=Pos": {POS: ADV, "Degree": "Pos"},
    "ADV__Polarity=Neg": {POS: ADV, "Polarity": "Neg"},
    "AUX__Aspect=Imp|Case=Loc|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: AUX, "Aspect": "Imp", "Case": "Loc", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "AUX__Aspect=Imp|Case=Nom|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: AUX, "Aspect": "Imp", "Case": "Nom", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "AUX__Aspect=Imp|Case=Nom|Number=Plur|Tense=Past|VerbForm=Part|Voice=Act": {POS: AUX, "Aspect": "Imp", "Case": "Nom", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "AUX__Aspect=Imp|Gender=Fem|Mood=Ind|Number=Sing|Tense=Past|VerbForm=Fin|Voice=Act": {POS: AUX, "Aspect": "Imp", "Gender": "Fem", "Mood": "Ind", "Number": "Sing", "Tense": "Past", "VerbForm": "Fin", "Voice": "Act"},
    "AUX__Aspect=Imp|Gender=Masc|Mood=Ind|Number=Sing|Tense=Past|VerbForm=Fin|Voice=Act": {POS: AUX, "Aspect": "Imp", "Gender": "Masc", "Mood": "Ind", "Number": "Sing", "Tense": "Past", "VerbForm": "Fin", "Voice": "Act"},
    "AUX__Aspect=Imp|Gender=Neut|Mood=Ind|Number=Sing|Tense=Past|VerbForm=Fin|Voice=Act": {POS: AUX, "Aspect": "Imp", "Gender": "Neut", "Mood": "Ind", "Number": "Sing", "Tense": "Past", "VerbForm": "Fin", "Voice": "Act"},
    "AUX__Aspect=Imp|Mood=Imp|Number=Plur|Person=2|VerbForm=Fin|Voice=Act": {POS: AUX, "Aspect": "Imp", "Mood": "Imp", "Number": "Plur", "Person": "two", "VerbForm": "Fin", "Voice": "Act"},
    "AUX__Aspect=Imp|Mood=Imp|Number=Sing|Person=2|VerbForm=Fin|Voice=Act": {POS: AUX, "Aspect": "Imp", "Mood": "Imp", "Number": "Sing", "Person": "two", "VerbForm": "Fin", "Voice": "Act"},
    "AUX__Aspect=Imp|Mood=Ind|Number=Plur|Person=1|Tense=Pres|VerbForm=Fin|Voice=Act": {POS: AUX, "Aspect": "Imp", "Mood": "Ind", "Number": "Plur", "Person": "one", "Tense": "Pres", "VerbForm": "Fin", "Voice": "Act"},
    "AUX__Aspect=Imp|Mood=Ind|Number=Plur|Person=2|Tense=Pres|VerbForm=Fin|Voice=Act": {POS: AUX, "Aspect": "Imp", "Mood": "Ind", "Number": "Plur", "Person": "two", "Tense": "Pres", "VerbForm": "Fin", "Voice": "Act"},
    "AUX__Aspect=Imp|Mood=Ind|Number=Plur|Person=3|Tense=Pres|VerbForm=Fin|Voice=Act": {POS: AUX, "Aspect": "Imp", "Mood": "Ind", "Number": "Plur", "Person": "three", "Tense": "Pres", "VerbForm": "Fin", "Voice": "Act"},
    "AUX__Aspect=Imp|Mood=Ind|Number=Plur|Tense=Past|VerbForm=Fin|Voice=Act": {POS: AUX, "Aspect": "Imp", "Mood": "Ind", "Number": "Plur", "Tense": "Past", "VerbForm": "Fin", "Voice": "Act"},
    "AUX__Aspect=Imp|Mood=Ind|Number=Sing|Person=1|Tense=Pres|VerbForm=Fin|Voice=Act": {POS: AUX, "Aspect": "Imp", "Mood": "Ind", "Number": "Sing", "Person": "one", "Tense": "Pres", "VerbForm": "Fin", "Voice": "Act"},
    "AUX__Aspect=Imp|Mood=Ind|Number=Sing|Person=2|Tense=Pres|VerbForm=Fin|Voice=Act": {POS: AUX, "Aspect": "Imp", "Mood": "Ind", "Number": "Sing", "Person": "two", "Tense": "Pres", "VerbForm": "Fin", "Voice": "Act"},
    "AUX__Aspect=Imp|Mood=Ind|Number=Sing|Person=3|Tense=Pres|VerbForm=Fin|Voice=Act": {POS: AUX, "Aspect": "Imp", "Mood": "Ind", "Number": "Sing", "Person": "three", "Tense": "Pres", "VerbForm": "Fin", "Voice": "Act"},
    "AUX__Aspect=Imp|Tense=Pres|VerbForm=Conv|Voice=Act": {POS: AUX, "Aspect": "Imp", "Tense": "Pres", "VerbForm": "Conv", "Voice": "Act"},
    "AUX__Aspect=Imp|VerbForm=Inf|Voice=Act": {POS: AUX, "Aspect": "Imp", "VerbForm": "Inf", "Voice": "Act"},
    "CCONJ___": {POS: CCONJ},
    "CCONJ": {POS: CCONJ},
    "DET__Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing": {POS: DET, "Animacy": "Inan", "Case": "Acc", "Gender": "Masc", "Number": "Sing"},
    "DET__Animacy=Inan|Case=Acc|Gender=Neut|Number=Sing": {POS: DET, "Animacy": "Inan", "Case": "Acc", "Gender": "Neut", "Number": "Sing"},
    "DET__Animacy=Inan|Case=Gen|Gender=Fem|Number=Sing": {POS: DET, "Animacy": "Inan", "Case": "Gen", "Gender": "Fem", "Number": "Sing"},
    "DET__Animacy=Inan|Case=Gen|Number=Plur": {POS: DET, "Animacy": "Inan", "Case": "Gen", "Number": "Plur"},
    "DET__Case=Acc|Degree=Pos|Number=Plur": {POS: DET, "Case": "Acc", "Degree": "Pos", "Number": "Plur"},
    "DET__Case=Acc|Gender=Fem|Number=Sing": {POS: DET, "Case": "Acc", "Gender": "Fem", "Number": "Sing"},
    "DET__Case=Acc|Gender=Masc|Number=Sing": {POS: DET, "Case": "Acc", "Gender": "Masc", "Number": "Sing"},
    "DET__Case=Acc|Gender=Neut|Number=Sing": {POS: DET, "Case": "Acc", "Gender": "Neut", "Number": "Sing"},
    "DET__Case=Acc|Number=Plur": {POS: DET, "Case": "Acc", "Number": "Plur"},
    "DET__Case=Dat|Gender=Fem|Number=Sing": {POS: DET, "Case": "Dat", "Gender": "Fem", "Number": "Sing"},
    "DET__Case=Dat|Gender=Masc|Number=Plur": {POS: DET, "Case": "Dat", "Gender": "Masc", "Number": "Plur"},
    "DET__Case=Dat|Gender=Masc|Number=Sing": {POS: DET, "Case": "Dat", "Gender": "Masc", "Number": "Sing"},
    "DET__Case=Dat|Gender=Neut|Number=Sing": {POS: DET, "Case": "Dat", "Gender": "Neut", "Number": "Sing"},
    "DET__Case=Dat|Number=Plur": {POS: DET, "Case": "Dat", "Number": "Plur"},
    "DET__Case=Gen|Gender=Fem|Number=Sing": {POS: DET, "Case": "Gen", "Gender": "Fem", "Number": "Sing"},
    "DET__Case=Gen|Gender=Masc|Number=Sing": {POS: DET, "Case": "Gen", "Gender": "Masc", "Number": "Sing"},
    "DET__Case=Gen|Gender=Neut|Number=Sing": {POS: DET, "Case": "Gen", "Gender": "Neut", "Number": "Sing"},
    "DET__Case=Gen|Number=Plur": {POS: DET, "Case": "Gen", "Number": "Plur"},
    "DET__Case=Ins|Gender=Fem|Number=Sing": {POS: DET, "Case": "Ins", "Gender": "Fem", "Number": "Sing"},
    "DET__Case=Ins|Gender=Masc|Number=Sing": {POS: DET, "Case": "Ins", "Gender": "Masc", "Number": "Sing"},
    "DET__Case=Ins|Gender=Neut|Number=Sing": {POS: DET, "Case": "Ins", "Gender": "Neut", "Number": "Sing"},
    "DET__Case=Ins|Number=Plur": {POS: DET, "Case": "Ins", "Number": "Plur"},
    "DET__Case=Loc|Gender=Fem|Number=Sing": {POS: DET, "Case": "Loc", "Gender": "Fem", "Number": "Sing"},
    "DET__Case=Loc|Gender=Masc|Number=Sing": {POS: DET, "Case": "Loc", "Gender": "Masc", "Number": "Sing"},
    "DET__Case=Loc|Gender=Neut|Number=Sing": {POS: DET, "Case": "Loc", "Gender": "Neut", "Number": "Sing"},
    "DET__Case=Loc|Number=Plur": {POS: DET, "Case": "Loc", "Number": "Plur"},
    "DET__Case=Nom|Gender=Fem|Number=Sing": {POS: DET, "Case": "Nom", "Gender": "Fem", "Number": "Sing"},
    "DET__Case=Nom|Gender=Masc|Number=Plur": {POS: DET, "Case": "Nom", "Gender": "Masc", "Number": "Plur"},
    "DET__Case=Nom|Gender=Masc|Number=Sing": {POS: DET, "Case": "Nom", "Gender": "Masc", "Number": "Sing"},
    "DET__Case=Nom|Gender=Neut|Number=Sing": {POS: DET, "Case": "Nom", "Gender": "Neut", "Number": "Sing"},
    "DET__Case=Nom|Number=Plur": {POS: DET, "Case": "Nom", "Number": "Plur"},
    "DET__Gender=Masc|Number=Sing": {POS: DET, "Gender": "Masc", "Number": "Sing"},
    "INTJ___": {POS: INTJ},
    "INTJ": {POS: INTJ},
    "NOUN__Animacy=Anim|Case=Acc|Gender=Fem|Number=Plur": {POS: NOUN, "Animacy": "Anim", "Case": "Acc", "Gender": "Fem", "Number": "Plur"},
    "NOUN__Animacy=Anim|Case=Acc|Gender=Fem|Number=Sing": {POS: NOUN, "Animacy": "Anim", "Case": "Acc", "Gender": "Fem", "Number": "Sing"},
    "NOUN__Animacy=Anim|Case=Acc|Gender=Masc|Number=Plur": {POS: NOUN, "Animacy": "Anim", "Case": "Acc", "Gender": "Masc", "Number": "Plur"},
    "NOUN__Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing": {POS: NOUN, "Animacy": "Anim", "Case": "Acc", "Gender": "Masc", "Number": "Sing"},
    "NOUN__Animacy=Anim|Case=Acc|Gender=Neut|Number=Plur": {POS: NOUN, "Animacy": "Anim", "Case": "Acc", "Gender": "Neut", "Number": "Plur"},
    "NOUN__Animacy=Anim|Case=Acc|Gender=Neut|Number=Sing": {POS: NOUN, "Animacy": "Anim", "Case": "Acc", "Gender": "Neut", "Number": "Sing"},
    "NOUN__Animacy=Anim|Case=Acc|Number=Plur": {POS: NOUN, "Animacy": "Anim", "Case": "Acc", "Number": "Plur"},
    "NOUN__Animacy=Anim|Case=Dat|Gender=Fem|Number=Plur": {POS: NOUN, "Animacy": "Anim", "Case": "Dat", "Gender": "Fem", "Number": "Plur"},
    "NOUN__Animacy=Anim|Case=Dat|Gender=Fem|Number=Sing": {POS: NOUN, "Animacy": "Anim", "Case": "Dat", "Gender": "Fem", "Number": "Sing"},
    "NOUN__Animacy=Anim|Case=Dat|Gender=Masc|Number=Plur": {POS: NOUN, "Animacy": "Anim", "Case": "Dat", "Gender": "Masc", "Number": "Plur"},
    "NOUN__Animacy=Anim|Case=Dat|Gender=Masc|Number=Sing": {POS: NOUN, "Animacy": "Anim", "Case": "Dat", "Gender": "Masc", "Number": "Sing"},
    "NOUN__Animacy=Anim|Case=Dat|Gender=Neut|Number=Plur": {POS: NOUN, "Animacy": "Anim", "Case": "Dat", "Gender": "Neut", "Number": "Plur"},
    "NOUN__Animacy=Anim|Case=Dat|Gender=Neut|Number=Sing": {POS: NOUN, "Animacy": "Anim", "Case": "Dat", "Gender": "Neut", "Number": "Sing"},
    "NOUN__Animacy=Anim|Case=Dat|Number=Plur": {POS: NOUN, "Animacy": "Anim", "Case": "Dat", "Number": "Plur"},
    "NOUN__Animacy=Anim|Case=Gen|Gender=Fem|Number=Plur": {POS: NOUN, "Animacy": "Anim", "Case": "Gen", "Gender": "Fem", "Number": "Plur"},
    "NOUN__Animacy=Anim|Case=Gen|Gender=Fem|Number=Sing": {POS: NOUN, "Animacy": "Anim", "Case": "Gen", "Gender": "Fem", "Number": "Sing"},
    "NOUN__Animacy=Anim|Case=Gen|Gender=Masc|Number=Plur": {POS: NOUN, "Animacy": "Anim", "Case": "Gen", "Gender": "Masc", "Number": "Plur"},
    "NOUN__Animacy=Anim|Case=Gen|Gender=Masc|Number=Sing": {POS: NOUN, "Animacy": "Anim", "Case": "Gen", "Gender": "Masc", "Number": "Sing"},
    "NOUN__Animacy=Anim|Case=Gen|Gender=Neut|Number=Plur": {POS: NOUN, "Animacy": "Anim", "Case": "Gen", "Gender": "Neut", "Number": "Plur"},
    "NOUN__Animacy=Anim|Case=Gen|Gender=Neut|Number=Sing": {POS: NOUN, "Animacy": "Anim", "Case": "Gen", "Gender": "Neut", "Number": "Sing"},
    "NOUN__Animacy=Anim|Case=Gen|Number=Plur": {POS: NOUN, "Animacy": "Anim", "Case": "Gen", "Number": "Plur"},
    "NOUN__Animacy=Anim|Case=Ins|Gender=Fem|Number=Plur": {POS: NOUN, "Animacy": "Anim", "Case": "Ins", "Gender": "Fem", "Number": "Plur"},
    "NOUN__Animacy=Anim|Case=Ins|Gender=Fem|Number=Sing": {POS: NOUN, "Animacy": "Anim", "Case": "Ins", "Gender": "Fem", "Number": "Sing"},
    "NOUN__Animacy=Anim|Case=Ins|Gender=Masc|Number=Plur": {POS: NOUN, "Animacy": "Anim", "Case": "Ins", "Gender": "Masc", "Number": "Plur"},
    "NOUN__Animacy=Anim|Case=Ins|Gender=Masc|Number=Sing": {POS: NOUN, "Animacy": "Anim", "Case": "Ins", "Gender": "Masc", "Number": "Sing"},
    "NOUN__Animacy=Anim|Case=Ins|Gender=Neut|Number=Plur": {POS: NOUN, "Animacy": "Anim", "Case": "Ins", "Gender": "Neut", "Number": "Plur"},
    "NOUN__Animacy=Anim|Case=Ins|Gender=Neut|Number=Sing": {POS: NOUN, "Animacy": "Anim", "Case": "Ins", "Gender": "Neut", "Number": "Sing"},
    "NOUN__Animacy=Anim|Case=Ins|Number=Plur": {POS: NOUN, "Animacy": "Anim", "Case": "Ins", "Number": "Plur"},
    "NOUN__Animacy=Anim|Case=Loc|Gender=Fem|Number=Plur": {POS: NOUN, "Animacy": "Anim", "Case": "Loc", "Gender": "Fem", "Number": "Plur"},
    "NOUN__Animacy=Anim|Case=Loc|Gender=Fem|Number=Sing": {POS: NOUN, "Animacy": "Anim", "Case": "Loc", "Gender": "Fem", "Number": "Sing"},
    "NOUN__Animacy=Anim|Case=Loc|Gender=Masc|Number=Plur": {POS: NOUN, "Animacy": "Anim", "Case": "Loc", "Gender": "Masc", "Number": "Plur"},
    "NOUN__Animacy=Anim|Case=Loc|Gender=Masc|Number=Sing": {POS: NOUN, "Animacy": "Anim", "Case": "Loc", "Gender": "Masc", "Number": "Sing"},
    "NOUN__Animacy=Anim|Case=Loc|Gender=Neut|Number=Plur": {POS: NOUN, "Animacy": "Anim", "Case": "Loc", "Gender": "Neut", "Number": "Plur"},
    "NOUN__Animacy=Anim|Case=Loc|Gender=Neut|Number=Sing": {POS: NOUN, "Animacy": "Anim", "Case": "Loc", "Gender": "Neut", "Number": "Sing"},
    "NOUN__Animacy=Anim|Case=Loc|Number=Plur": {POS: NOUN, "Animacy": "Anim", "Case": "Loc", "Number": "Plur"},
    "NOUN__Animacy=Anim|Case=Nom|Gender=Fem|Number=Plur": {POS: NOUN, "Animacy": "Anim", "Case": "Nom", "Gender": "Fem", "Number": "Plur"},
    "NOUN__Animacy=Anim|Case=Nom|Gender=Fem|Number=Sing": {POS: NOUN, "Animacy": "Anim", "Case": "Nom", "Gender": "Fem", "Number": "Sing"},
    "NOUN__Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur": {POS: NOUN, "Animacy": "Anim", "Case": "Nom", "Gender": "Masc", "Number": "Plur"},
    "NOUN__Animacy=Anim|Case=Nom|Gender=Masc|Number=Sing": {POS: NOUN, "Animacy": "Anim", "Case": "Nom", "Gender": "Masc", "Number": "Sing"},
    "NOUN__Animacy=Anim|Case=Nom|Gender=Neut|Number=Plur": {POS: NOUN, "Animacy": "Anim", "Case": "Nom", "Gender": "Neut", "Number": "Plur"},
    "NOUN__Animacy=Anim|Case=Nom|Gender=Neut|Number=Sing": {POS: NOUN, "Animacy": "Anim", "Case": "Nom", "Gender": "Neut", "Number": "Sing"},
    "NOUN__Animacy=Anim|Case=Nom|Number=Plur": {POS: NOUN, "Animacy": "Anim", "Case": "Nom", "Number": "Plur"},
    "NOUN__Animacy=Anim|Case=Voc|Gender=Masc|Number=Sing": {POS: NOUN, "Animacy": "Anim", "Case": "Voc", "Gender": "Masc", "Number": "Sing"},
    "NOUN__Animacy=Inan|Case=Acc|Gender=Fem|Number=Plur": {POS: NOUN, "Animacy": "Inan", "Case": "Acc", "Gender": "Fem", "Number": "Plur"},
    "NOUN__Animacy=Inan|Case=Acc|Gender=Fem|Number=Sing": {POS: NOUN, "Animacy": "Inan", "Case": "Acc", "Gender": "Fem", "Number": "Sing"},
    "NOUN__Animacy=Inan|Case=Acc|Gender=Masc|Number=Plur": {POS: NOUN, "Animacy": "Inan", "Case": "Acc", "Gender": "Masc", "Number": "Plur"},
    "NOUN__Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing": {POS: NOUN, "Animacy": "Inan", "Case": "Acc", "Gender": "Masc", "Number": "Sing"},
    "NOUN__Animacy=Inan|Case=Acc|Gender=Neut|Number=Plur": {POS: NOUN, "Animacy": "Inan", "Case": "Acc", "Gender": "Neut", "Number": "Plur"},
    "NOUN__Animacy=Inan|Case=Acc|Gender=Neut|Number=Sing": {POS: NOUN, "Animacy": "Inan", "Case": "Acc", "Gender": "Neut", "Number": "Sing"},
    "NOUN__Animacy=Inan|Case=Acc|Number=Plur": {POS: NOUN, "Animacy": "Inan", "Case": "Acc", "Number": "Plur"},
    "NOUN__Animacy=Inan|Case=Dat|Gender=Fem|Number=Plur": {POS: NOUN, "Animacy": "Inan", "Case": "Dat", "Gender": "Fem", "Number": "Plur"},
    "NOUN__Animacy=Inan|Case=Dat|Gender=Fem|Number=Sing": {POS: NOUN, "Animacy": "Inan", "Case": "Dat", "Gender": "Fem", "Number": "Sing"},
    "NOUN__Animacy=Inan|Case=Dat|Gender=Masc|Number=Plur": {POS: NOUN, "Animacy": "Inan", "Case": "Dat", "Gender": "Masc", "Number": "Plur"},
    "NOUN__Animacy=Inan|Case=Dat|Gender=Masc|Number=Sing": {POS: NOUN, "Animacy": "Inan", "Case": "Dat", "Gender": "Masc", "Number": "Sing"},
    "NOUN__Animacy=Inan|Case=Dat|Gender=Neut|Number=Plur": {POS: NOUN, "Animacy": "Inan", "Case": "Dat", "Gender": "Neut", "Number": "Plur"},
    "NOUN__Animacy=Inan|Case=Dat|Gender=Neut|Number=Sing": {POS: NOUN, "Animacy": "Inan", "Case": "Dat", "Gender": "Neut", "Number": "Sing"},
    "NOUN__Animacy=Inan|Case=Dat|Number=Plur": {POS: NOUN, "Animacy": "Inan", "Case": "Dat", "Number": "Plur"},
    "NOUN__Animacy=Inan|Case=Gen|Gender=Fem|Number=Plur": {POS: NOUN, "Animacy": "Inan", "Case": "Gen", "Gender": "Fem", "Number": "Plur"},
    "NOUN__Animacy=Inan|Case=Gen|Gender=Fem|Number=Sing": {POS: NOUN, "Animacy": "Inan", "Case": "Gen", "Gender": "Fem", "Number": "Sing"},
    "NOUN__Animacy=Inan|Case=Gen|Gender=Masc|Number=Plur": {POS: NOUN, "Animacy": "Inan", "Case": "Gen", "Gender": "Masc", "Number": "Plur"},
    "NOUN__Animacy=Inan|Case=Gen|Gender=Masc|Number=Sing": {POS: NOUN, "Animacy": "Inan", "Case": "Gen", "Gender": "Masc", "Number": "Sing"},
    "NOUN__Animacy=Inan|Case=Gen|Gender=Neut|Number=Plur": {POS: NOUN, "Animacy": "Inan", "Case": "Gen", "Gender": "Neut", "Number": "Plur"},
    "NOUN__Animacy=Inan|Case=Gen|Gender=Neut|Number=Sing": {POS: NOUN, "Animacy": "Inan", "Case": "Gen", "Gender": "Neut", "Number": "Sing"},
    "NOUN__Animacy=Inan|Case=Gen|Number=Plur": {POS: NOUN, "Animacy": "Inan", "Case": "Gen", "Number": "Plur"},
    "NOUN__Animacy=Inan|Case=Ins|Gender=Fem|Number=Plur": {POS: NOUN, "Animacy": "Inan", "Case": "Ins", "Gender": "Fem", "Number": "Plur"},
    "NOUN__Animacy=Inan|Case=Ins|Gender=Fem|Number=Sing": {POS: NOUN, "Animacy": "Inan", "Case": "Ins", "Gender": "Fem", "Number": "Sing"},
    "NOUN__Animacy=Inan|Case=Ins|Gender=Masc|Number=Plur": {POS: NOUN, "Animacy": "Inan", "Case": "Ins", "Gender": "Masc", "Number": "Plur"},
    "NOUN__Animacy=Inan|Case=Ins|Gender=Masc|Number=Sing": {POS: NOUN, "Animacy": "Inan", "Case": "Ins", "Gender": "Masc", "Number": "Sing"},
    "NOUN__Animacy=Inan|Case=Ins|Gender=Neut|Number=Plur": {POS: NOUN, "Animacy": "Inan", "Case": "Ins", "Gender": "Neut", "Number": "Plur"},
    "NOUN__Animacy=Inan|Case=Ins|Gender=Neut|Number=Sing": {POS: NOUN, "Animacy": "Inan", "Case": "Ins", "Gender": "Neut", "Number": "Sing"},
    "NOUN__Animacy=Inan|Case=Ins|Number=Plur": {POS: NOUN, "Animacy": "Inan", "Case": "Ins", "Number": "Plur"},
    "NOUN__Animacy=Inan|Case=Loc|Gender=Fem|Number=Plur": {POS: NOUN, "Animacy": "Inan", "Case": "Loc", "Gender": "Fem", "Number": "Plur"},
    "NOUN__Animacy=Inan|Case=Loc|Gender=Fem|Number=Sing": {POS: NOUN, "Animacy": "Inan", "Case": "Loc", "Gender": "Fem", "Number": "Sing"},
    "NOUN__Animacy=Inan|Case=Loc|Gender=Masc|Number=Plur": {POS: NOUN, "Animacy": "Inan", "Case": "Loc", "Gender": "Masc", "Number": "Plur"},
    "NOUN__Animacy=Inan|Case=Loc|Gender=Masc|Number=Sing": {POS: NOUN, "Animacy": "Inan", "Case": "Loc", "Gender": "Masc", "Number": "Sing"},
    "NOUN__Animacy=Inan|Case=Loc|Gender=Neut|Number=Plur": {POS: NOUN, "Animacy": "Inan", "Case": "Loc", "Gender": "Neut", "Number": "Plur"},
    "NOUN__Animacy=Inan|Case=Loc|Gender=Neut|Number=Sing": {POS: NOUN, "Animacy": "Inan", "Case": "Loc", "Gender": "Neut", "Number": "Sing"},
    "NOUN__Animacy=Inan|Case=Loc|Number=Plur": {POS: NOUN, "Animacy": "Inan", "Case": "Loc", "Number": "Plur"},
    "NOUN__Animacy=Inan|Case=Nom|Gender=Fem|Number=Plur": {POS: NOUN, "Animacy": "Inan", "Case": "Nom", "Gender": "Fem", "Number": "Plur"},
    "NOUN__Animacy=Inan|Case=Nom|Gender=Fem|Number=Sing": {POS: NOUN, "Animacy": "Inan", "Case": "Nom", "Gender": "Fem", "Number": "Sing"},
    "NOUN__Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur": {POS: NOUN, "Animacy": "Inan", "Case": "Nom", "Gender": "Masc", "Number": "Plur"},
    "NOUN__Animacy=Inan|Case=Nom|Gender=Masc|Number=Sing": {POS: NOUN, "Animacy": "Inan", "Case": "Nom", "Gender": "Masc", "Number": "Sing"},
    "NOUN__Animacy=Inan|Case=Nom|Gender=Neut|Number=Plur": {POS: NOUN, "Animacy": "Inan", "Case": "Nom", "Gender": "Neut", "Number": "Plur"},
    "NOUN__Animacy=Inan|Case=Nom|Gender=Neut|Number=Sing": {POS: NOUN, "Animacy": "Inan", "Case": "Nom", "Gender": "Neut", "Number": "Sing"},
    "NOUN__Animacy=Inan|Case=Nom|Number=Plur": {POS: NOUN, "Animacy": "Inan", "Case": "Nom", "Number": "Plur"},
    "NOUN__Animacy=Inan|Case=Par|Gender=Masc|Number=Sing": {POS: NOUN, "Animacy": "Inan", "Case": "Par", "Gender": "Masc", "Number": "Sing"},
    "NOUN__Animacy=Inan|Gender=Fem": {POS: NOUN, "Animacy": "Inan", "Gender": "Fem"},
    "NOUN__Animacy=Inan|Gender=Masc": {POS: NOUN, "Animacy": "Inan", "Gender": "Masc"},
    "NOUN__Animacy=Inan|Gender=Neut": {POS: NOUN, "Animacy": "Inan", "Gender": "Neut"},
    "NOUN__Case=Gen|Degree=Pos|Gender=Fem|Number=Sing": {POS: NOUN, "Case": "Gen", "Degree": "Pos", "Gender": "Fem", "Number": "Sing"},
    "NOUN__Foreign=Yes": {POS: NOUN, "Foreign": "Yes"},
    "NOUN___": {POS: NOUN},
    "NOUN": {POS: NOUN},
    "NUM__Animacy=Anim|Case=Acc": {POS: NUM, "Animacy": "Anim", "Case": "Acc"},
    "NUM__Animacy=Anim|Case=Acc|Gender=Fem": {POS: NUM, "Animacy": "Anim", "Case": "Acc", "Gender": "Fem"},
    "NUM__Animacy=Anim|Case=Acc|Gender=Masc": {POS: NUM, "Animacy": "Anim", "Case": "Acc", "Gender": "Masc"},
    "NUM__Animacy=Inan|Case=Acc": {POS: NUM, "Animacy": "Inan", "Case": "Acc"},
    "NUM__Animacy=Inan|Case=Acc|Gender=Fem": {POS: NUM, "Animacy": "Inan", "Case": "Acc", "Gender": "Fem"},
    "NUM__Animacy=Inan|Case=Acc|Gender=Masc": {POS: NUM, "Animacy": "Inan", "Case": "Acc", "Gender": "Masc"},
    "NUM__Case=Acc": {POS: NUM, "Case": "Acc"},
    "NUM__Case=Acc|Gender=Fem": {POS: NUM, "Case": "Acc", "Gender": "Fem"},
    "NUM__Case=Acc|Gender=Masc": {POS: NUM, "Case": "Acc", "Gender": "Masc"},
    "NUM__Case=Acc|Gender=Neut": {POS: NUM, "Case": "Acc", "Gender": "Neut"},
    "NUM__Case=Dat": {POS: NUM, "Case": "Dat"},
    "NUM__Case=Dat|Gender=Fem": {POS: NUM, "Case": "Dat", "Gender": "Fem"},
    "NUM__Case=Dat|Gender=Masc": {POS: NUM, "Case": "Dat", "Gender": "Masc"},
    "NUM__Case=Dat|Gender=Neut": {POS: NUM, "Case": "Dat", "Gender": "Neut"},
    "NUM__Case=Gen": {POS: NUM, "Case": "Gen"},
    "NUM__Case=Gen|Gender=Fem": {POS: NUM, "Case": "Gen", "Gender": "Fem"},
    "NUM__Case=Gen|Gender=Masc": {POS: NUM, "Case": "Gen", "Gender": "Masc"},
    "NUM__Case=Gen|Gender=Neut": {POS: NUM, "Case": "Gen", "Gender": "Neut"},
    "NUM__Case=Ins": {POS: NUM, "Case": "Ins"},
    "NUM__Case=Ins|Gender=Fem": {POS: NUM, "Case": "Ins", "Gender": "Fem"},
    "NUM__Case=Ins|Gender=Masc": {POS: NUM, "Case": "Ins", "Gender": "Masc"},
    "NUM__Case=Ins|Gender=Neut": {POS: NUM, "Case": "Ins", "Gender": "Neut"},
    "NUM__Case=Loc": {POS: NUM, "Case": "Loc"},
    "NUM__Case=Loc|Gender=Fem": {POS: NUM, "Case": "Loc", "Gender": "Fem"},
    "NUM__Case=Loc|Gender=Masc": {POS: NUM, "Case": "Loc", "Gender": "Masc"},
    "NUM__Case=Loc|Gender=Neut": {POS: NUM, "Case": "Loc", "Gender": "Neut"},
    "NUM__Case=Nom": {POS: NUM, "Case": "Nom"},
    "NUM__Case=Nom|Gender=Fem": {POS: NUM, "Case": "Nom", "Gender": "Fem"},
    "NUM__Case=Nom|Gender=Masc": {POS: NUM, "Case": "Nom", "Gender": "Masc"},
    "NUM__Case=Nom|Gender=Neut": {POS: NUM, "Case": "Nom", "Gender": "Neut"},
    "NUM___": {POS: NUM},
    "NUM": {POS: NUM},
    "PART__Mood=Cnd": {POS: PART, "Mood": "Cnd"},
    "PART__Polarity=Neg": {POS: PART, "Polarity": "Neg"},
    "PART___": {POS: PART},
    "PART": {POS: PART},
    "PRON__Animacy=Anim|Case=Acc|Gender=Masc|Number=Plur": {POS: PRON, "Animacy": "Anim", "Case": "Acc", "Gender": "Masc", "Number": "Plur"},
    "PRON__Animacy=Anim|Case=Acc|Number=Plur": {POS: PRON, "Animacy": "Anim", "Case": "Acc", "Number": "Plur"},
    "PRON__Animacy=Anim|Case=Dat|Gender=Masc|Number=Sing": {POS: PRON, "Animacy": "Anim", "Case": "Dat", "Gender": "Masc", "Number": "Sing"},
    "PRON__Animacy=Anim|Case=Dat|Number=Plur": {POS: PRON, "Animacy": "Anim", "Case": "Dat", "Number": "Plur"},
    "PRON__Animacy=Anim|Case=Gen|Number=Plur": {POS: PRON, "Animacy": "Anim", "Case": "Gen", "Number": "Plur"},
    "PRON__Animacy=Anim|Case=Ins|Gender=Masc|Number=Sing": {POS: PRON, "Animacy": "Anim", "Case": "Ins", "Gender": "Masc", "Number": "Sing"},
    "PRON__Animacy=Anim|Case=Ins|Number=Plur": {POS: PRON, "Animacy": "Anim", "Case": "Ins", "Number": "Plur"},
    "PRON__Animacy=Anim|Case=Loc|Number=Plur": {POS: PRON, "Animacy": "Anim", "Case": "Loc", "Number": "Plur"},
    "PRON__Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur": {POS: PRON, "Animacy": "Anim", "Case": "Nom", "Gender": "Masc", "Number": "Plur"},
    "PRON__Animacy=Anim|Case=Nom|Number=Plur": {POS: PRON, "Animacy": "Anim", "Case": "Nom", "Number": "Plur"},
    "PRON__Animacy=Anim|Gender=Masc|Number=Plur": {POS: PRON, "Animacy": "Anim", "Gender": "Masc", "Number": "Plur"},
    "PRON__Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing": {POS: PRON, "Animacy": "Inan", "Case": "Acc", "Gender": "Masc", "Number": "Sing"},
    "PRON__Animacy=Inan|Case=Acc|Gender=Neut|Number=Sing": {POS: PRON, "Animacy": "Inan", "Case": "Acc", "Gender": "Neut", "Number": "Sing"},
    "PRON__Animacy=Inan|Case=Dat|Gender=Neut|Number=Sing": {POS: PRON, "Animacy": "Inan", "Case": "Dat", "Gender": "Neut", "Number": "Sing"},
    "PRON__Animacy=Inan|Case=Gen|Gender=Masc|Number=Sing": {POS: PRON, "Animacy": "Inan", "Case": "Gen", "Gender": "Masc", "Number": "Sing"},
    "PRON__Animacy=Inan|Case=Gen|Gender=Neut|Number=Sing": {POS: PRON, "Animacy": "Inan", "Case": "Gen", "Gender": "Neut", "Number": "Sing"},
    "PRON__Animacy=Inan|Case=Ins|Gender=Fem|Number=Sing": {POS: PRON, "Animacy": "Inan", "Case": "Ins", "Gender": "Fem", "Number": "Sing"},
    "PRON__Animacy=Inan|Case=Ins|Gender=Neut|Number=Sing": {POS: PRON, "Animacy": "Inan", "Case": "Ins", "Gender": "Neut", "Number": "Sing"},
    "PRON__Animacy=Inan|Case=Loc|Gender=Neut|Number=Sing": {POS: PRON, "Animacy": "Inan", "Case": "Loc", "Gender": "Neut", "Number": "Sing"},
    "PRON__Animacy=Inan|Case=Nom|Gender=Neut|Number=Sing": {POS: PRON, "Animacy": "Inan", "Case": "Nom", "Gender": "Neut", "Number": "Sing"},
    "PRON__Animacy=Inan|Gender=Neut|Number=Sing": {POS: PRON, "Animacy": "Inan", "Gender": "Neut", "Number": "Sing"},
    "PRON__Case=Acc": {POS: PRON, "Case": "Acc"},
    "PRON__Case=Acc|Gender=Fem|Number=Sing|Person=3": {POS: PRON, "Case": "Acc", "Gender": "Fem", "Number": "Sing", "Person": "three"},
    "PRON__Case=Acc|Gender=Masc|Number=Sing|Person=3": {POS: PRON, "Case": "Acc", "Gender": "Masc", "Number": "Sing", "Person": "three"},
    "PRON__Case=Acc|Gender=Neut|Number=Sing|Person=3": {POS: PRON, "Case": "Acc", "Gender": "Neut", "Number": "Sing", "Person": "three"},
    "PRON__Case=Acc|Number=Plur|Person=1": {POS: PRON, "Case": "Acc", "Number": "Plur", "Person": "one"},
    "PRON__Case=Acc|Number=Plur|Person=2": {POS: PRON, "Case": "Acc", "Number": "Plur", "Person": "two"},
    "PRON__Case=Acc|Number=Plur|Person=3": {POS: PRON, "Case": "Acc", "Number": "Plur", "Person": "three"},
    "PRON__Case=Acc|Number=Sing|Person=1": {POS: PRON, "Case": "Acc", "Number": "Sing", "Person": "one"},
    "PRON__Case=Acc|Number=Sing|Person=2": {POS: PRON, "Case": "Acc", "Number": "Sing", "Person": "two"},
    "PRON__Case=Dat": {POS: PRON, "Case": "Dat"},
    "PRON__Case=Dat|Gender=Fem|Number=Sing|Person=3": {POS: PRON, "Case": "Dat", "Gender": "Fem", "Number": "Sing", "Person": "three"},
    "PRON__Case=Dat|Gender=Masc|Number=Sing|Person=3": {POS: PRON, "Case": "Dat", "Gender": "Masc", "Number": "Sing", "Person": "three"},
    "PRON__Case=Dat|Gender=Neut|Number=Sing|Person=3": {POS: PRON, "Case": "Dat", "Gender": "Neut", "Number": "Sing", "Person": "three"},
    "PRON__Case=Dat|Number=Plur|Person=1": {POS: PRON, "Case": "Dat", "Number": "Plur", "Person": "one"},
    "PRON__Case=Dat|Number=Plur|Person=2": {POS: PRON, "Case": "Dat", "Number": "Plur", "Person": "two"},
    "PRON__Case=Dat|Number=Plur|Person=3": {POS: PRON, "Case": "Dat", "Number": "Plur", "Person": "three"},
    "PRON__Case=Dat|Number=Sing|Person=1": {POS: PRON, "Case": "Dat", "Number": "Sing", "Person": "one"},
    "PRON__Case=Dat|Number=Sing|Person=2": {POS: PRON, "Case": "Dat", "Number": "Sing", "Person": "two"},
    "PRON__Case=Gen": {POS: PRON, "Case": "Gen"},
    "PRON__Case=Gen|Gender=Fem|Number=Sing|Person=3": {POS: PRON, "Case": "Gen", "Gender": "Fem", "Number": "Sing", "Person": "three"},
    "PRON__Case=Gen|Gender=Masc|Number=Sing|Person=3": {POS: PRON, "Case": "Gen", "Gender": "Masc", "Number": "Sing", "Person": "three"},
    "PRON__Case=Gen|Gender=Neut|Number=Sing|Person=3": {POS: PRON, "Case": "Gen", "Gender": "Neut", "Number": "Sing", "Person": "three"},
    "PRON__Case=Gen|Number=Plur|Person=1": {POS: PRON, "Case": "Gen", "Number": "Plur", "Person": "one"},
    "PRON__Case=Gen|Number=Plur|Person=2": {POS: PRON, "Case": "Gen", "Number": "Plur", "Person": "two"},
    "PRON__Case=Gen|Number=Plur|Person=3": {POS: PRON, "Case": "Gen", "Number": "Plur", "Person": "three"},
    "PRON__Case=Gen|Number=Sing|Person=1": {POS: PRON, "Case": "Gen", "Number": "Sing", "Person": "one"},
    "PRON__Case=Gen|Number=Sing|Person=2": {POS: PRON, "Case": "Gen", "Number": "Sing", "Person": "two"},
    "PRON__Case=Ins": {POS: PRON, "Case": "Ins"},
    "PRON__Case=Ins|Gender=Fem|Number=Sing|Person=3": {POS: PRON, "Case": "Ins", "Gender": "Fem", "Number": "Sing", "Person": "three"},
    "PRON__Case=Ins|Gender=Masc|Number=Sing|Person=3": {POS: PRON, "Case": "Ins", "Gender": "Masc", "Number": "Sing", "Person": "three"},
    "PRON__Case=Ins|Gender=Neut|Number=Sing|Person=3": {POS: PRON, "Case": "Ins", "Gender": "Neut", "Number": "Sing", "Person": "three"},
    "PRON__Case=Ins|Number=Plur|Person=1": {POS: PRON, "Case": "Ins", "Number": "Plur", "Person": "one"},
    "PRON__Case=Ins|Number=Plur|Person=2": {POS: PRON, "Case": "Ins", "Number": "Plur", "Person": "two"},
    "PRON__Case=Ins|Number=Plur|Person=3": {POS: PRON, "Case": "Ins", "Number": "Plur", "Person": "three"},
    "PRON__Case=Ins|Number=Sing|Person=1": {POS: PRON, "Case": "Ins", "Number": "Sing", "Person": "one"},
    "PRON__Case=Ins|Number=Sing|Person=2": {POS: PRON, "Case": "Ins", "Number": "Sing", "Person": "two"},
    "PRON__Case=Loc": {POS: PRON, "Case": "Loc"},
    "PRON__Case=Loc|Gender=Fem|Number=Sing|Person=3": {POS: PRON, "Case": "Loc", "Gender": "Fem", "Number": "Sing", "Person": "three"},
    "PRON__Case=Loc|Gender=Masc|Number=Sing|Person=3": {POS: PRON, "Case": "Loc", "Gender": "Masc", "Number": "Sing", "Person": "three"},
    "PRON__Case=Loc|Gender=Neut|Number=Sing|Person=3": {POS: PRON, "Case": "Loc", "Gender": "Neut", "Number": "Sing", "Person": "three"},
    "PRON__Case=Loc|Number=Plur|Person=1": {POS: PRON, "Case": "Loc", "Number": "Plur", "Person": "one"},
    "PRON__Case=Loc|Number=Plur|Person=2": {POS: PRON, "Case": "Loc", "Number": "Plur", "Person": "two"},
    "PRON__Case=Loc|Number=Plur|Person=3": {POS: PRON, "Case": "Loc", "Number": "Plur", "Person": "three"},
    "PRON__Case=Loc|Number=Sing|Person=1": {POS: PRON, "Case": "Loc", "Number": "Sing", "Person": "one"},
    "PRON__Case=Loc|Number=Sing|Person=2": {POS: PRON, "Case": "Loc", "Number": "Sing", "Person": "two"},
    "PRON__Case=Nom": {POS: PRON, "Case": "Nom"},
    "PRON__Case=Nom|Gender=Fem|Number=Sing|Person=3": {POS: PRON, "Case": "Nom", "Gender": "Fem", "Number": "Sing", "Person": "three"},
    "PRON__Case=Nom|Gender=Masc|Number=Sing|Person=3": {POS: PRON, "Case": "Nom", "Gender": "Masc", "Number": "Sing", "Person": "three"},
    "PRON__Case=Nom|Gender=Neut|Number=Sing|Person=3": {POS: PRON, "Case": "Nom", "Gender": "Neut", "Number": "Sing", "Person": "three"},
    "PRON__Case=Nom|Number=Plur|Person=1": {POS: PRON, "Case": "Nom", "Number": "Plur", "Person": "one"},
    "PRON__Case=Nom|Number=Plur|Person=2": {POS: PRON, "Case": "Nom", "Number": "Plur", "Person": "two"},
    "PRON__Case=Nom|Number=Plur|Person=3": {POS: PRON, "Case": "Nom", "Number": "Plur", "Person": "three"},
    "PRON__Case=Nom|Number=Sing|Person=1": {POS: PRON, "Case": "Nom", "Number": "Sing", "Person": "one"},
    "PRON__Case=Nom|Number=Sing|Person=2": {POS: PRON, "Case": "Nom", "Number": "Sing", "Person": "two"},
    "PRON__Number=Sing|Person=1": {POS: PRON, "Number": "Sing", "Person": "one"},
    "PRON___": {POS: PRON},
    "PRON": {POS: PRON},
    "PROPN__Animacy=Anim|Case=Acc|Gender=Fem|Number=Plur": {POS: PROPN, "Animacy": "Anim", "Case": "Acc", "Gender": "Fem", "Number": "Plur"},
    "PROPN__Animacy=Anim|Case=Acc|Gender=Fem|Number=Sing": {POS: PROPN, "Animacy": "Anim", "Case": "Acc", "Gender": "Fem", "Number": "Sing"},
    "PROPN__Animacy=Anim|Case=Acc|Gender=Masc|Number=Plur": {POS: PROPN, "Animacy": "Anim", "Case": "Acc", "Gender": "Masc", "Number": "Plur"},
    "PROPN__Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing": {POS: PROPN, "Animacy": "Anim", "Case": "Acc", "Gender": "Masc", "Number": "Sing"},
    "PROPN__Animacy=Anim|Case=Acc|Gender=Neut|Number=Plur": {POS: PROPN, "Animacy": "Anim", "Case": "Acc", "Gender": "Neut", "Number": "Plur"},
    "PROPN__Animacy=Anim|Case=Dat|Gender=Fem|Number=Plur": {POS: PROPN, "Animacy": "Anim", "Case": "Dat", "Gender": "Fem", "Number": "Plur"},
    "PROPN__Animacy=Anim|Case=Dat|Gender=Fem|Number=Sing": {POS: PROPN, "Animacy": "Anim", "Case": "Dat", "Gender": "Fem", "Number": "Sing"},
    "PROPN__Animacy=Anim|Case=Dat|Gender=Masc|Number=Plur": {POS: PROPN, "Animacy": "Anim", "Case": "Dat", "Gender": "Masc", "Number": "Plur"},
    "PROPN__Animacy=Anim|Case=Dat|Gender=Masc|Number=Sing": {POS: PROPN, "Animacy": "Anim", "Case": "Dat", "Gender": "Masc", "Number": "Sing"},
    "PROPN__Animacy=Anim|Case=Dat|Gender=Neut|Number=Plur": {POS: PROPN, "Animacy": "Anim", "Case": "Dat", "Gender": "Neut", "Number": "Plur"},
    "PROPN__Animacy=Anim|Case=Gen|Foreign=Yes|Gender=Masc|Number=Sing": {POS: PROPN, "Animacy": "Anim", "Case": "Gen", "Foreign": "Yes", "Gender": "Masc", "Number": "Sing"},
    "PROPN__Animacy=Anim|Case=Gen|Gender=Fem|Number=Plur": {POS: PROPN, "Animacy": "Anim", "Case": "Gen", "Gender": "Fem", "Number": "Plur"},
    "PROPN__Animacy=Anim|Case=Gen|Gender=Fem|Number=Sing": {POS: PROPN, "Animacy": "Anim", "Case": "Gen", "Gender": "Fem", "Number": "Sing"},
    "PROPN__Animacy=Anim|Case=Gen|Gender=Masc|Number=Plur": {POS: PROPN, "Animacy": "Anim", "Case": "Gen", "Gender": "Masc", "Number": "Plur"},
    "PROPN__Animacy=Anim|Case=Gen|Gender=Masc|Number=Sing": {POS: PROPN, "Animacy": "Anim", "Case": "Gen", "Gender": "Masc", "Number": "Sing"},
    "PROPN__Animacy=Anim|Case=Ins|Gender=Fem|Number=Sing": {POS: PROPN, "Animacy": "Anim", "Case": "Ins", "Gender": "Fem", "Number": "Sing"},
    "PROPN__Animacy=Anim|Case=Ins|Gender=Masc|Number=Plur": {POS: PROPN, "Animacy": "Anim", "Case": "Ins", "Gender": "Masc", "Number": "Plur"},
    "PROPN__Animacy=Anim|Case=Ins|Gender=Masc|Number=Sing": {POS: PROPN, "Animacy": "Anim", "Case": "Ins", "Gender": "Masc", "Number": "Sing"},
    "PROPN__Animacy=Anim|Case=Ins|Gender=Neut|Number=Sing": {POS: PROPN, "Animacy": "Anim", "Case": "Ins", "Gender": "Neut", "Number": "Sing"},
    "PROPN__Animacy=Anim|Case=Loc|Gender=Fem|Number=Sing": {POS: PROPN, "Animacy": "Anim", "Case": "Loc", "Gender": "Fem", "Number": "Sing"},
    "PROPN__Animacy=Anim|Case=Loc|Gender=Masc|Number=Plur": {POS: PROPN, "Animacy": "Anim", "Case": "Loc", "Gender": "Masc", "Number": "Plur"},
    "PROPN__Animacy=Anim|Case=Loc|Gender=Masc|Number=Sing": {POS: PROPN, "Animacy": "Anim", "Case": "Loc", "Gender": "Masc", "Number": "Sing"},
    "PROPN__Animacy=Anim|Case=Nom|Foreign=Yes|Gender=Masc|Number=Sing": {POS: PROPN, "Animacy": "Anim", "Case": "Nom", "Foreign": "Yes", "Gender": "Masc", "Number": "Sing"},
    "PROPN__Animacy=Anim|Case=Nom|Gender=Fem|Number=Plur": {POS: PROPN, "Animacy": "Anim", "Case": "Nom", "Gender": "Fem", "Number": "Plur"},
    "PROPN__Animacy=Anim|Case=Nom|Gender=Fem|Number=Sing": {POS: PROPN, "Animacy": "Anim", "Case": "Nom", "Gender": "Fem", "Number": "Sing"},
    "PROPN__Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur": {POS: PROPN, "Animacy": "Anim", "Case": "Nom", "Gender": "Masc", "Number": "Plur"},
    "PROPN__Animacy=Anim|Case=Nom|Gender=Masc|Number=Sing": {POS: PROPN, "Animacy": "Anim", "Case": "Nom", "Gender": "Masc", "Number": "Sing"},
    "PROPN__Animacy=Anim|Case=Nom|Gender=Neut|Number=Plur": {POS: PROPN, "Animacy": "Anim", "Case": "Nom", "Gender": "Neut", "Number": "Plur"},
    "PROPN__Animacy=Anim|Case=Voc|Gender=Masc|Number=Sing": {POS: PROPN, "Animacy": "Anim", "Case": "Voc", "Gender": "Masc", "Number": "Sing"},
    "PROPN__Animacy=Anim|Gender=Masc|Number=Sing": {POS: PROPN, "Animacy": "Anim", "Gender": "Masc", "Number": "Sing"},
    "PROPN__Animacy=Inan|Case=Acc|Gender=Fem|Number=Plur": {POS: PROPN, "Animacy": "Inan", "Case": "Acc", "Gender": "Fem", "Number": "Plur"},
    "PROPN__Animacy=Inan|Case=Acc|Gender=Fem|Number=Sing": {POS: PROPN, "Animacy": "Inan", "Case": "Acc", "Gender": "Fem", "Number": "Sing"},
    "PROPN__Animacy=Inan|Case=Acc|Gender=Masc|Number=Plur": {POS: PROPN, "Animacy": "Inan", "Case": "Acc", "Gender": "Masc", "Number": "Plur"},
    "PROPN__Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing": {POS: PROPN, "Animacy": "Inan", "Case": "Acc", "Gender": "Masc", "Number": "Sing"},
    "PROPN__Animacy=Inan|Case=Acc|Gender=Neut|Number=Plur": {POS: PROPN, "Animacy": "Inan", "Case": "Acc", "Gender": "Neut", "Number": "Plur"},
    "PROPN__Animacy=Inan|Case=Acc|Gender=Neut|Number=Sing": {POS: PROPN, "Animacy": "Inan", "Case": "Acc", "Gender": "Neut", "Number": "Sing"},
    "PROPN__Animacy=Inan|Case=Acc|Number=Plur": {POS: PROPN, "Animacy": "Inan", "Case": "Acc", "Number": "Plur"},
    "PROPN__Animacy=Inan|Case=Dat|Gender=Fem|Number=Plur": {POS: PROPN, "Animacy": "Inan", "Case": "Dat", "Gender": "Fem", "Number": "Plur"},
    "PROPN__Animacy=Inan|Case=Dat|Gender=Fem|Number=Sing": {POS: PROPN, "Animacy": "Inan", "Case": "Dat", "Gender": "Fem", "Number": "Sing"},
    "PROPN__Animacy=Inan|Case=Dat|Gender=Masc|Number=Plur": {POS: PROPN, "Animacy": "Inan", "Case": "Dat", "Gender": "Masc", "Number": "Plur"},
    "PROPN__Animacy=Inan|Case=Dat|Gender=Masc|Number=Sing": {POS: PROPN, "Animacy": "Inan", "Case": "Dat", "Gender": "Masc", "Number": "Sing"},
    "PROPN__Animacy=Inan|Case=Dat|Gender=Neut|Number=Plur": {POS: PROPN, "Animacy": "Inan", "Case": "Dat", "Gender": "Neut", "Number": "Plur"},
    "PROPN__Animacy=Inan|Case=Dat|Gender=Neut|Number=Sing": {POS: PROPN, "Animacy": "Inan", "Case": "Dat", "Gender": "Neut", "Number": "Sing"},
    "PROPN__Animacy=Inan|Case=Dat|Number=Plur": {POS: PROPN, "Animacy": "Inan", "Case": "Dat", "Number": "Plur"},
    "PROPN__Animacy=Inan|Case=Gen|Foreign=Yes|Gender=Fem|Number=Sing": {POS: PROPN, "Animacy": "Inan", "Case": "Gen", "Foreign": "Yes", "Gender": "Fem", "Number": "Sing"},
    "PROPN__Animacy=Inan|Case=Gen|Gender=Fem|Number=Plur": {POS: PROPN, "Animacy": "Inan", "Case": "Gen", "Gender": "Fem", "Number": "Plur"},
    "PROPN__Animacy=Inan|Case=Gen|Gender=Fem|Number=Sing": {POS: PROPN, "Animacy": "Inan", "Case": "Gen", "Gender": "Fem", "Number": "Sing"},
    "PROPN__Animacy=Inan|Case=Gen|Gender=Masc|Number=Plur": {POS: PROPN, "Animacy": "Inan", "Case": "Gen", "Gender": "Masc", "Number": "Plur"},
    "PROPN__Animacy=Inan|Case=Gen|Gender=Masc|Number=Sing": {POS: PROPN, "Animacy": "Inan", "Case": "Gen", "Gender": "Masc", "Number": "Sing"},
    "PROPN__Animacy=Inan|Case=Gen|Gender=Neut|Number=Plur": {POS: PROPN, "Animacy": "Inan", "Case": "Gen", "Gender": "Neut", "Number": "Plur"},
    "PROPN__Animacy=Inan|Case=Gen|Gender=Neut|Number=Sing": {POS: PROPN, "Animacy": "Inan", "Case": "Gen", "Gender": "Neut", "Number": "Sing"},
    "PROPN__Animacy=Inan|Case=Gen|Number=Plur": {POS: PROPN, "Animacy": "Inan", "Case": "Gen", "Number": "Plur"},
    "PROPN__Animacy=Inan|Case=Ins|Gender=Fem|Number=Plur": {POS: PROPN, "Animacy": "Inan", "Case": "Ins", "Gender": "Fem", "Number": "Plur"},
    "PROPN__Animacy=Inan|Case=Ins|Gender=Fem|Number=Sing": {POS: PROPN, "Animacy": "Inan", "Case": "Ins", "Gender": "Fem", "Number": "Sing"},
    "PROPN__Animacy=Inan|Case=Ins|Gender=Masc|Number=Plur": {POS: PROPN, "Animacy": "Inan", "Case": "Ins", "Gender": "Masc", "Number": "Plur"},
    "PROPN__Animacy=Inan|Case=Ins|Gender=Masc|Number=Sing": {POS: PROPN, "Animacy": "Inan", "Case": "Ins", "Gender": "Masc", "Number": "Sing"},
    "PROPN__Animacy=Inan|Case=Ins|Gender=Neut|Number=Plur": {POS: PROPN, "Animacy": "Inan", "Case": "Ins", "Gender": "Neut", "Number": "Plur"},
    "PROPN__Animacy=Inan|Case=Ins|Gender=Neut|Number=Sing": {POS: PROPN, "Animacy": "Inan", "Case": "Ins", "Gender": "Neut", "Number": "Sing"},
    "PROPN__Animacy=Inan|Case=Ins|Number=Plur": {POS: PROPN, "Animacy": "Inan", "Case": "Ins", "Number": "Plur"},
    "PROPN__Animacy=Inan|Case=Loc|Gender=Fem|Number=Plur": {POS: PROPN, "Animacy": "Inan", "Case": "Loc", "Gender": "Fem", "Number": "Plur"},
    "PROPN__Animacy=Inan|Case=Loc|Gender=Fem|Number=Sing": {POS: PROPN, "Animacy": "Inan", "Case": "Loc", "Gender": "Fem", "Number": "Sing"},
    "PROPN__Animacy=Inan|Case=Loc|Gender=Masc|Number=Plur": {POS: PROPN, "Animacy": "Inan", "Case": "Loc", "Gender": "Masc", "Number": "Plur"},
    "PROPN__Animacy=Inan|Case=Loc|Gender=Masc|Number=Sing": {POS: PROPN, "Animacy": "Inan", "Case": "Loc", "Gender": "Masc", "Number": "Sing"},
    "PROPN__Animacy=Inan|Case=Loc|Gender=Neut|Number=Plur": {POS: PROPN, "Animacy": "Inan", "Case": "Loc", "Gender": "Neut", "Number": "Plur"},
    "PROPN__Animacy=Inan|Case=Loc|Gender=Neut|Number=Sing": {POS: PROPN, "Animacy": "Inan", "Case": "Loc", "Gender": "Neut", "Number": "Sing"},
    "PROPN__Animacy=Inan|Case=Loc|Number=Plur": {POS: PROPN, "Animacy": "Inan", "Case": "Loc", "Number": "Plur"},
    "PROPN__Animacy=Inan|Case=Nom|Foreign=Yes|Gender=Fem|Number=Sing": {POS: PROPN, "Animacy": "Inan", "Case": "Nom", "Foreign": "Yes", "Gender": "Fem", "Number": "Sing"},
    "PROPN__Animacy=Inan|Case=Nom|Foreign=Yes|Gender=Masc|Number=Sing": {POS: PROPN, "Animacy": "Inan", "Case": "Nom", "Foreign": "Yes", "Gender": "Masc", "Number": "Sing"},
    "PROPN__Animacy=Inan|Case=Nom|Foreign=Yes|Gender=Neut|Number=Sing": {POS: PROPN, "Animacy": "Inan", "Case": "Nom", "Foreign": "Yes", "Gender": "Neut", "Number": "Sing"},
    "PROPN__Animacy=Inan|Case=Nom|Gender=Fem|Number=Plur": {POS: PROPN, "Animacy": "Inan", "Case": "Nom", "Gender": "Fem", "Number": "Plur"},
    "PROPN__Animacy=Inan|Case=Nom|Gender=Fem|Number=Sing": {POS: PROPN, "Animacy": "Inan", "Case": "Nom", "Gender": "Fem", "Number": "Sing"},
    "PROPN__Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur": {POS: PROPN, "Animacy": "Inan", "Case": "Nom", "Gender": "Masc", "Number": "Plur"},
    "PROPN__Animacy=Inan|Case=Nom|Gender=Masc|Number=Sing": {POS: PROPN, "Animacy": "Inan", "Case": "Nom", "Gender": "Masc", "Number": "Sing"},
    "PROPN__Animacy=Inan|Case=Nom|Gender=Neut|Number=Plur": {POS: PROPN, "Animacy": "Inan", "Case": "Nom", "Gender": "Neut", "Number": "Plur"},
    "PROPN__Animacy=Inan|Case=Nom|Gender=Neut|Number=Sing": {POS: PROPN, "Animacy": "Inan", "Case": "Nom", "Gender": "Neut", "Number": "Sing"},
    "PROPN__Animacy=Inan|Case=Nom|Number=Plur": {POS: PROPN, "Animacy": "Inan", "Case": "Nom", "Number": "Plur"},
    "PROPN__Animacy=Inan|Case=Par|Gender=Masc|Number=Sing": {POS: PROPN, "Animacy": "Inan", "Case": "Par", "Gender": "Masc", "Number": "Sing"},
    "PROPN__Animacy=Inan|Gender=Fem": {POS: PROPN, "Animacy": "Inan", "Gender": "Fem"},
    "PROPN__Animacy=Inan|Gender=Masc": {POS: PROPN, "Animacy": "Inan", "Gender": "Masc"},
    "PROPN__Animacy=Inan|Gender=Masc|Number=Plur": {POS: PROPN, "Animacy": "Inan", "Gender": "Masc", "Number": "Plur"},
    "PROPN__Animacy=Inan|Gender=Masc|Number=Sing": {POS: PROPN, "Animacy": "Inan", "Gender": "Masc", "Number": "Sing"},
    "PROPN__Animacy=Inan|Gender=Neut|Number=Sing": {POS: PROPN, "Animacy": "Inan", "Gender": "Neut", "Number": "Sing"},
    "PROPN__Case=Acc|Degree=Pos|Gender=Fem|Number=Sing": {POS: PROPN, "Case": "Acc", "Degree": "Pos", "Gender": "Fem", "Number": "Sing"},
    "PROPN__Case=Dat|Degree=Pos|Gender=Masc|Number=Sing": {POS: PROPN, "Case": "Dat", "Degree": "Pos", "Gender": "Masc", "Number": "Sing"},
    "PROPN__Case=Ins|Degree=Pos|Gender=Fem|Number=Sing": {POS: PROPN, "Case": "Ins", "Degree": "Pos", "Gender": "Fem", "Number": "Sing"},
    "PROPN__Case=Ins|Degree=Pos|Number=Plur": {POS: PROPN, "Case": "Ins", "Degree": "Pos", "Number": "Plur"},
    "PROPN__Case=Nom|Degree=Pos|Gender=Fem|Number=Sing": {POS: PROPN, "Case": "Nom", "Degree": "Pos", "Gender": "Fem", "Number": "Sing"},
    "PROPN__Case=Nom|Degree=Pos|Gender=Masc|Number=Sing": {POS: PROPN, "Case": "Nom", "Degree": "Pos", "Gender": "Masc", "Number": "Sing"},
    "PROPN__Case=Nom|Degree=Pos|Gender=Neut|Number=Sing": {POS: PROPN, "Case": "Nom", "Degree": "Pos", "Gender": "Neut", "Number": "Sing"},
    "PROPN__Case=Nom|Degree=Pos|Number=Plur": {POS: PROPN, "Case": "Nom", "Degree": "Pos", "Number": "Plur"},
    "PROPN__Degree=Pos|Gender=Neut|Number=Sing|Variant=Short": {POS: PROPN, "Degree": "Pos", "Gender": "Neut", "Number": "Sing", },
    "PROPN__Degree=Pos|Number=Plur|Variant=Short": {POS: PROPN, "Degree": "Pos", "Number": "Plur", },
    "PROPN__Foreign=Yes": {POS: PROPN, "Foreign": "Yes"},
    "PROPN__Number=Sing": {POS: PROPN, "Number": "Sing"},
    "PROPN___": {POS: PROPN},
    "PROPN": {POS: PROPN},
    "PUNCT___": {POS: PUNCT},
    "PUNCT": {POS: PUNCT},
    "SCONJ__Mood=Cnd": {POS: SCONJ, "Mood": "Cnd"},
    "SCONJ___": {POS: SCONJ},
    "SCONJ": {POS: SCONJ},
    "SYM___": {POS: SYM},
    "SYM": {POS: SYM},
    "VERB__Animacy=Anim|Aspect=Imp|Case=Acc|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Animacy": "Anim", "Aspect": "Imp", "Case": "Acc", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Animacy=Anim|Aspect=Imp|Case=Acc|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Animacy": "Anim", "Aspect": "Imp", "Case": "Acc", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Animacy=Anim|Aspect=Imp|Case=Acc|Gender=Masc|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Act": {POS: VERB, "Animacy": "Anim", "Aspect": "Imp", "Case": "Acc", "Gender": "Masc", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Animacy=Anim|Aspect=Imp|Case=Acc|Gender=Masc|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Mid": {POS: VERB, "Animacy": "Anim", "Aspect": "Imp", "Case": "Acc", "Gender": "Masc", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Animacy=Anim|Aspect=Imp|Case=Acc|Gender=Masc|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Pass": {POS: VERB, "Animacy": "Anim", "Aspect": "Imp", "Case": "Acc", "Gender": "Masc", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Animacy=Anim|Aspect=Imp|Case=Acc|Number=Plur|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Animacy": "Anim", "Aspect": "Imp", "Case": "Acc", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Animacy=Anim|Aspect=Imp|Case=Acc|Number=Plur|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Animacy": "Anim", "Aspect": "Imp", "Case": "Acc", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Animacy=Anim|Aspect=Imp|Case=Acc|Number=Plur|Tense=Pres|VerbForm=Part|Voice=Act": {POS: VERB, "Animacy": "Anim", "Aspect": "Imp", "Case": "Acc", "Number": "Plur", "Tense": "Pres", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Animacy=Anim|Aspect=Imp|Case=Acc|Number=Plur|Tense=Pres|VerbForm=Part|Voice=Mid": {POS: VERB, "Animacy": "Anim", "Aspect": "Imp", "Case": "Acc", "Number": "Plur", "Tense": "Pres", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Animacy=Anim|Aspect=Imp|Case=Acc|Number=Plur|Tense=Pres|VerbForm=Part|Voice=Pass": {POS: VERB, "Animacy": "Anim", "Aspect": "Imp", "Case": "Acc", "Number": "Plur", "Tense": "Pres", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Animacy=Anim|Aspect=Perf|Case=Acc|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Animacy": "Anim", "Aspect": "Perf", "Case": "Acc", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Animacy=Anim|Aspect=Perf|Case=Acc|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Animacy": "Anim", "Aspect": "Perf", "Case": "Acc", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Animacy=Anim|Aspect=Perf|Case=Acc|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Animacy": "Anim", "Aspect": "Perf", "Case": "Acc", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Animacy=Anim|Aspect=Perf|Case=Acc|Number=Plur|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Animacy": "Anim", "Aspect": "Perf", "Case": "Acc", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Animacy=Anim|Aspect=Perf|Case=Acc|Number=Plur|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Animacy": "Anim", "Aspect": "Perf", "Case": "Acc", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Animacy=Anim|Aspect=Perf|Case=Acc|Number=Plur|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Animacy": "Anim", "Aspect": "Perf", "Case": "Acc", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Animacy=Inan|Aspect=Imp|Case=Acc|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Animacy": "Inan", "Aspect": "Imp", "Case": "Acc", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Animacy=Inan|Aspect=Imp|Case=Acc|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Animacy": "Inan", "Aspect": "Imp", "Case": "Acc", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Animacy=Inan|Aspect=Imp|Case=Acc|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Animacy": "Inan", "Aspect": "Imp", "Case": "Acc", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Animacy=Inan|Aspect=Imp|Case=Acc|Gender=Masc|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Act": {POS: VERB, "Animacy": "Inan", "Aspect": "Imp", "Case": "Acc", "Gender": "Masc", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Animacy=Inan|Aspect=Imp|Case=Acc|Gender=Masc|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Mid": {POS: VERB, "Animacy": "Inan", "Aspect": "Imp", "Case": "Acc", "Gender": "Masc", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Animacy=Inan|Aspect=Imp|Case=Acc|Gender=Masc|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Pass": {POS: VERB, "Animacy": "Inan", "Aspect": "Imp", "Case": "Acc", "Gender": "Masc", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Animacy=Inan|Aspect=Imp|Case=Acc|Number=Plur|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Animacy": "Inan", "Aspect": "Imp", "Case": "Acc", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Animacy=Inan|Aspect=Imp|Case=Acc|Number=Plur|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Animacy": "Inan", "Aspect": "Imp", "Case": "Acc", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Animacy=Inan|Aspect=Imp|Case=Acc|Number=Plur|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Animacy": "Inan", "Aspect": "Imp", "Case": "Acc", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Animacy=Inan|Aspect=Imp|Case=Acc|Number=Plur|Tense=Pres|VerbForm=Part|Voice=Act": {POS: VERB, "Animacy": "Inan", "Aspect": "Imp", "Case": "Acc", "Number": "Plur", "Tense": "Pres", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Animacy=Inan|Aspect=Imp|Case=Acc|Number=Plur|Tense=Pres|VerbForm=Part|Voice=Mid": {POS: VERB, "Animacy": "Inan", "Aspect": "Imp", "Case": "Acc", "Number": "Plur", "Tense": "Pres", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Animacy=Inan|Aspect=Imp|Case=Acc|Number=Plur|Tense=Pres|VerbForm=Part|Voice=Pass": {POS: VERB, "Animacy": "Inan", "Aspect": "Imp", "Case": "Acc", "Number": "Plur", "Tense": "Pres", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Animacy=Inan|Aspect=Perf|Case=Acc|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Animacy": "Inan", "Aspect": "Perf", "Case": "Acc", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Animacy=Inan|Aspect=Perf|Case=Acc|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Animacy": "Inan", "Aspect": "Perf", "Case": "Acc", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Animacy=Inan|Aspect=Perf|Case=Acc|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Animacy": "Inan", "Aspect": "Perf", "Case": "Acc", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Animacy=Inan|Aspect=Perf|Case=Acc|Number=Plur|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Animacy": "Inan", "Aspect": "Perf", "Case": "Acc", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Animacy=Inan|Aspect=Perf|Case=Acc|Number=Plur|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Animacy": "Inan", "Aspect": "Perf", "Case": "Acc", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Animacy=Inan|Aspect=Perf|Case=Acc|Number=Plur|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Animacy": "Inan", "Aspect": "Perf", "Case": "Acc", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Acc|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Acc", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Acc|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Acc", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Acc|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Acc", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Acc|Gender=Fem|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Acc", "Gender": "Fem", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Acc|Gender=Fem|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Acc", "Gender": "Fem", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Acc|Gender=Fem|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Acc", "Gender": "Fem", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Acc|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Acc", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Acc|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Acc", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Acc|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Acc", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Acc|Gender=Neut|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Acc", "Gender": "Neut", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Acc|Gender=Neut|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Acc", "Gender": "Neut", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Acc|Gender=Neut|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Acc", "Gender": "Neut", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Dat|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Dat", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Dat|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Dat", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Dat|Gender=Fem|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Dat", "Gender": "Fem", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Dat|Gender=Fem|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Dat", "Gender": "Fem", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Dat|Gender=Fem|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Dat", "Gender": "Fem", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Dat|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Dat", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Dat|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Dat", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Dat|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Dat", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Dat|Gender=Masc|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Dat", "Gender": "Masc", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Dat|Gender=Masc|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Dat", "Gender": "Masc", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Dat|Gender=Masc|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Dat", "Gender": "Masc", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Dat|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Dat", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Dat|Gender=Neut|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Dat", "Gender": "Neut", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Dat|Gender=Neut|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Dat", "Gender": "Neut", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Dat|Number=Plur|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Dat", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Dat|Number=Plur|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Dat", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Dat|Number=Plur|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Dat", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Dat|Number=Plur|Tense=Pres|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Dat", "Number": "Plur", "Tense": "Pres", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Dat|Number=Plur|Tense=Pres|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Dat", "Number": "Plur", "Tense": "Pres", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Dat|Number=Plur|Tense=Pres|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Dat", "Number": "Plur", "Tense": "Pres", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Gen|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Gen", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Gen|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Gen", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Gen|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Gen", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Gen|Gender=Fem|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Gen", "Gender": "Fem", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Gen|Gender=Fem|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Gen", "Gender": "Fem", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Gen|Gender=Fem|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Gen", "Gender": "Fem", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Gen|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Gen", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Gen|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Gen", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Gen|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Gen", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Gen|Gender=Masc|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Gen", "Gender": "Masc", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Gen|Gender=Masc|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Gen", "Gender": "Masc", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Gen|Gender=Masc|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Gen", "Gender": "Masc", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Gen|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Gen", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Gen|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Gen", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Gen|Gender=Neut|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Gen", "Gender": "Neut", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Gen|Gender=Neut|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Gen", "Gender": "Neut", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Gen|Gender=Neut|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Gen", "Gender": "Neut", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Gen|Number=Plur|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Gen", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Gen|Number=Plur|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Gen", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Gen|Number=Plur|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Gen", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Gen|Number=Plur|Tense=Pres|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Gen", "Number": "Plur", "Tense": "Pres", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Gen|Number=Plur|Tense=Pres|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Gen", "Number": "Plur", "Tense": "Pres", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Gen|Number=Plur|Tense=Pres|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Gen", "Number": "Plur", "Tense": "Pres", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Ins|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Ins", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Ins|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Ins", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Ins|Gender=Fem|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Ins", "Gender": "Fem", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Ins|Gender=Fem|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Ins", "Gender": "Fem", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Ins|Gender=Fem|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Ins", "Gender": "Fem", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Ins|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Ins", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Ins|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Ins", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Ins|Gender=Masc|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Ins", "Gender": "Masc", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Ins|Gender=Masc|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Ins", "Gender": "Masc", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Ins|Gender=Masc|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Ins", "Gender": "Masc", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Ins|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Ins", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Ins|Gender=Neut|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Ins", "Gender": "Neut", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Ins|Gender=Neut|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Ins", "Gender": "Neut", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Ins|Gender=Neut|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Ins", "Gender": "Neut", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Ins|Number=Plur|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Ins", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Ins|Number=Plur|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Ins", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Ins|Number=Plur|Tense=Pres|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Ins", "Number": "Plur", "Tense": "Pres", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Ins|Number=Plur|Tense=Pres|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Ins", "Number": "Plur", "Tense": "Pres", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Ins|Number=Plur|Tense=Pres|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Ins", "Number": "Plur", "Tense": "Pres", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Loc|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Loc", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Loc|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Loc", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Loc|Gender=Fem|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Loc", "Gender": "Fem", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Loc|Gender=Fem|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Loc", "Gender": "Fem", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Loc|Gender=Fem|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Loc", "Gender": "Fem", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Loc|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Loc", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Loc|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Loc", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Loc|Gender=Masc|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Loc", "Gender": "Masc", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Loc|Gender=Masc|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Loc", "Gender": "Masc", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Loc|Gender=Masc|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Loc", "Gender": "Masc", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Loc|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Loc", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Loc|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Loc", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Loc|Gender=Neut|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Loc", "Gender": "Neut", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Loc|Gender=Neut|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Loc", "Gender": "Neut", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Loc|Gender=Neut|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Loc", "Gender": "Neut", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Loc|Number=Plur|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Loc", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Loc|Number=Plur|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Loc", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Loc|Number=Plur|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Loc", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Loc|Number=Plur|Tense=Pres|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Loc", "Number": "Plur", "Tense": "Pres", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Loc|Number=Plur|Tense=Pres|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Loc", "Number": "Plur", "Tense": "Pres", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Loc|Number=Plur|Tense=Pres|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Loc", "Number": "Plur", "Tense": "Pres", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Nom|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Nom", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Nom|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Nom", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Nom|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Nom", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Nom|Gender=Fem|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Nom", "Gender": "Fem", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Nom|Gender=Fem|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Nom", "Gender": "Fem", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Nom|Gender=Fem|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Nom", "Gender": "Fem", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Nom|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Nom", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Nom|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Nom", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Nom|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Nom", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Nom|Gender=Masc|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Nom", "Gender": "Masc", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Nom|Gender=Masc|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Nom", "Gender": "Masc", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Nom|Gender=Masc|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Nom", "Gender": "Masc", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Nom|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Nom", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Nom|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Nom", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Nom|Gender=Neut|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Nom", "Gender": "Neut", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Nom|Gender=Neut|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Nom", "Gender": "Neut", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Nom|Gender=Neut|Number=Sing|Tense=Pres|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Nom", "Gender": "Neut", "Number": "Sing", "Tense": "Pres", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Nom|Number=Plur|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Nom", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Nom|Number=Plur|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Nom", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Nom|Number=Plur|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Nom", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Case=Nom|Number=Plur|Tense=Pres|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Imp", "Case": "Nom", "Number": "Plur", "Tense": "Pres", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Imp|Case=Nom|Number=Plur|Tense=Pres|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Case": "Nom", "Number": "Plur", "Tense": "Pres", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Imp|Case=Nom|Number=Plur|Tense=Pres|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Case": "Nom", "Number": "Plur", "Tense": "Pres", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Gender=Fem|Mood=Ind|Number=Sing|Tense=Past|VerbForm=Fin|Voice=Act": {POS: VERB, "Aspect": "Imp", "Gender": "Fem", "Mood": "Ind", "Number": "Sing", "Tense": "Past", "VerbForm": "Fin", "Voice": "Act"},
    "VERB__Aspect=Imp|Gender=Fem|Mood=Ind|Number=Sing|Tense=Past|VerbForm=Fin|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Gender": "Fem", "Mood": "Ind", "Number": "Sing", "Tense": "Past", "VerbForm": "Fin", "Voice": "Mid"},
    "VERB__Aspect=Imp|Gender=Fem|Mood=Ind|Number=Sing|Tense=Past|VerbForm=Fin|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Gender": "Fem", "Mood": "Ind", "Number": "Sing", "Tense": "Past", "VerbForm": "Fin", "Voice": "Pass"},
    "VERB__Aspect=Imp|Gender=Fem|Number=Sing|Tense=Past|Variant=Short|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Gender": "Fem", "Number": "Sing", "Tense": "Past",  "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Gender=Fem|Number=Sing|Tense=Pres|Variant=Short|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Gender": "Fem", "Number": "Sing", "Tense": "Pres",  "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Gender=Masc|Mood=Ind|Number=Sing|Tense=Past|VerbForm=Fin|Voice=Act": {POS: VERB, "Aspect": "Imp", "Gender": "Masc", "Mood": "Ind", "Number": "Sing", "Tense": "Past", "VerbForm": "Fin", "Voice": "Act"},
    "VERB__Aspect=Imp|Gender=Masc|Mood=Ind|Number=Sing|Tense=Past|VerbForm=Fin|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Gender": "Masc", "Mood": "Ind", "Number": "Sing", "Tense": "Past", "VerbForm": "Fin", "Voice": "Mid"},
    "VERB__Aspect=Imp|Gender=Masc|Mood=Ind|Number=Sing|Tense=Past|VerbForm=Fin|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Gender": "Masc", "Mood": "Ind", "Number": "Sing", "Tense": "Past", "VerbForm": "Fin", "Voice": "Pass"},
    "VERB__Aspect=Imp|Gender=Masc|Number=Sing|Tense=Past|Variant=Short|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Gender": "Masc", "Number": "Sing", "Tense": "Past",  "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Gender=Masc|Number=Sing|Tense=Pres|Variant=Short|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Gender": "Masc", "Number": "Sing", "Tense": "Pres",  "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Gender=Neut|Mood=Ind|Number=Sing|Tense=Past|VerbForm=Fin|Voice=Act": {POS: VERB, "Aspect": "Imp", "Gender": "Neut", "Mood": "Ind", "Number": "Sing", "Tense": "Past", "VerbForm": "Fin", "Voice": "Act"},
    "VERB__Aspect=Imp|Gender=Neut|Mood=Ind|Number=Sing|Tense=Past|VerbForm=Fin|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Gender": "Neut", "Mood": "Ind", "Number": "Sing", "Tense": "Past", "VerbForm": "Fin", "Voice": "Mid"},
    "VERB__Aspect=Imp|Gender=Neut|Mood=Ind|Number=Sing|Tense=Past|VerbForm=Fin|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Gender": "Neut", "Mood": "Ind", "Number": "Sing", "Tense": "Past", "VerbForm": "Fin", "Voice": "Pass"},
    "VERB__Aspect=Imp|Gender=Neut|Number=Sing|Tense=Past|Variant=Short|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Gender": "Neut", "Number": "Sing", "Tense": "Past",  "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Gender=Neut|Number=Sing|Tense=Pres|Variant=Short|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Gender": "Neut", "Number": "Sing", "Tense": "Pres",  "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Mood=Imp|Number=Plur|Person=2|VerbForm=Fin|Voice=Act": {POS: VERB, "Aspect": "Imp", "Mood": "Imp", "Number": "Plur", "Person": "two", "VerbForm": "Fin", "Voice": "Act"},
    "VERB__Aspect=Imp|Mood=Imp|Number=Plur|Person=2|VerbForm=Fin|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Mood": "Imp", "Number": "Plur", "Person": "two", "VerbForm": "Fin", "Voice": "Mid"},
    "VERB__Aspect=Imp|Mood=Imp|Number=Sing|Person=2|VerbForm=Fin|Voice=Act": {POS: VERB, "Aspect": "Imp", "Mood": "Imp", "Number": "Sing", "Person": "two", "VerbForm": "Fin", "Voice": "Act"},
    "VERB__Aspect=Imp|Mood=Imp|Number=Sing|Person=2|VerbForm=Fin|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Mood": "Imp", "Number": "Sing", "Person": "two", "VerbForm": "Fin", "Voice": "Mid"},
    "VERB__Aspect=Imp|Mood=Ind|Number=Plur|Person=1|Tense=Pres|VerbForm=Fin|Voice=Act": {POS: VERB, "Aspect": "Imp", "Mood": "Ind", "Number": "Plur", "Person": "one", "Tense": "Pres", "VerbForm": "Fin", "Voice": "Act"},
    "VERB__Aspect=Imp|Mood=Ind|Number=Plur|Person=1|Tense=Pres|VerbForm=Fin|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Mood": "Ind", "Number": "Plur", "Person": "one", "Tense": "Pres", "VerbForm": "Fin", "Voice": "Mid"},
    "VERB__Aspect=Imp|Mood=Ind|Number=Plur|Person=2|Tense=Pres|VerbForm=Fin|Voice=Act": {POS: VERB, "Aspect": "Imp", "Mood": "Ind", "Number": "Plur", "Person": "two", "Tense": "Pres", "VerbForm": "Fin", "Voice": "Act"},
    "VERB__Aspect=Imp|Mood=Ind|Number=Plur|Person=2|Tense=Pres|VerbForm=Fin|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Mood": "Ind", "Number": "Plur", "Person": "two", "Tense": "Pres", "VerbForm": "Fin", "Voice": "Mid"},
    "VERB__Aspect=Imp|Mood=Ind|Number=Plur|Person=3|Tense=Pres|VerbForm=Fin|Voice=Act": {POS: VERB, "Aspect": "Imp", "Mood": "Ind", "Number": "Plur", "Person": "three", "Tense": "Pres", "VerbForm": "Fin", "Voice": "Act"},
    "VERB__Aspect=Imp|Mood=Ind|Number=Plur|Person=3|Tense=Pres|VerbForm=Fin|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Mood": "Ind", "Number": "Plur", "Person": "three", "Tense": "Pres", "VerbForm": "Fin", "Voice": "Mid"},
    "VERB__Aspect=Imp|Mood=Ind|Number=Plur|Person=3|Tense=Pres|VerbForm=Fin|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Mood": "Ind", "Number": "Plur", "Person": "three", "Tense": "Pres", "VerbForm": "Fin", "Voice": "Pass"},
    "VERB__Aspect=Imp|Mood=Ind|Number=Plur|Tense=Past|VerbForm=Fin|Voice=Act": {POS: VERB, "Aspect": "Imp", "Mood": "Ind", "Number": "Plur", "Tense": "Past", "VerbForm": "Fin", "Voice": "Act"},
    "VERB__Aspect=Imp|Mood=Ind|Number=Plur|Tense=Past|VerbForm=Fin|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Mood": "Ind", "Number": "Plur", "Tense": "Past", "VerbForm": "Fin", "Voice": "Mid"},
    "VERB__Aspect=Imp|Mood=Ind|Number=Plur|Tense=Past|VerbForm=Fin|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Mood": "Ind", "Number": "Plur", "Tense": "Past", "VerbForm": "Fin", "Voice": "Pass"},
    "VERB__Aspect=Imp|Mood=Ind|Number=Sing|Person=1|Tense=Pres|VerbForm=Fin|Voice=Act": {POS: VERB, "Aspect": "Imp", "Mood": "Ind", "Number": "Sing", "Person": "one", "Tense": "Pres", "VerbForm": "Fin", "Voice": "Act"},
    "VERB__Aspect=Imp|Mood=Ind|Number=Sing|Person=1|Tense=Pres|VerbForm=Fin|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Mood": "Ind", "Number": "Sing", "Person": "one", "Tense": "Pres", "VerbForm": "Fin", "Voice": "Mid"},
    "VERB__Aspect=Imp|Mood=Ind|Number=Sing|Person=2|Tense=Pres|VerbForm=Fin|Voice=Act": {POS: VERB, "Aspect": "Imp", "Mood": "Ind", "Number": "Sing", "Person": "two", "Tense": "Pres", "VerbForm": "Fin", "Voice": "Act"},
    "VERB__Aspect=Imp|Mood=Ind|Number=Sing|Person=2|Tense=Pres|VerbForm=Fin|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Mood": "Ind", "Number": "Sing", "Person": "two", "Tense": "Pres", "VerbForm": "Fin", "Voice": "Mid"},
    "VERB__Aspect=Imp|Mood=Ind|Number=Sing|Person=3|Tense=Pres|VerbForm=Fin|Voice=Act": {POS: VERB, "Aspect": "Imp", "Mood": "Ind", "Number": "Sing", "Person": "three", "Tense": "Pres", "VerbForm": "Fin", "Voice": "Act"},
    "VERB__Aspect=Imp|Mood=Ind|Number=Sing|Person=3|Tense=Pres|VerbForm=Fin|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Mood": "Ind", "Number": "Sing", "Person": "three", "Tense": "Pres", "VerbForm": "Fin", "Voice": "Mid"},
    "VERB__Aspect=Imp|Mood=Ind|Number=Sing|Person=3|Tense=Pres|VerbForm=Fin|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Mood": "Ind", "Number": "Sing", "Person": "three", "Tense": "Pres", "VerbForm": "Fin", "Voice": "Pass"},
    "VERB__Aspect=Imp|Number=Plur|Tense=Past|Variant=Short|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Number": "Plur", "Tense": "Past",  "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Number=Plur|Tense=Pres|Variant=Short|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Number": "Plur", "Tense": "Pres",  "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Imp|Tense=Past|VerbForm=Conv|Voice=Act": {POS: VERB, "Aspect": "Imp", "Tense": "Past", "VerbForm": "Conv", "Voice": "Act"},
    "VERB__Aspect=Imp|Tense=Pres|VerbForm=Conv|Voice=Act": {POS: VERB, "Aspect": "Imp", "Tense": "Pres", "VerbForm": "Conv", "Voice": "Act"},
    "VERB__Aspect=Imp|Tense=Pres|VerbForm=Conv|Voice=Mid": {POS: VERB, "Aspect": "Imp", "Tense": "Pres", "VerbForm": "Conv", "Voice": "Mid"},
    "VERB__Aspect=Imp|Tense=Pres|VerbForm=Conv|Voice=Pass": {POS: VERB, "Aspect": "Imp", "Tense": "Pres", "VerbForm": "Conv", "Voice": "Pass"},
    "VERB__Aspect=Imp|VerbForm=Inf|Voice=Act": {POS: VERB, "Aspect": "Imp", "VerbForm": "Inf", "Voice": "Act"},
    "VERB__Aspect=Imp|VerbForm=Inf|Voice=Mid": {POS: VERB, "Aspect": "Imp", "VerbForm": "Inf", "Voice": "Mid"},
    "VERB__Aspect=Imp|VerbForm=Inf|Voice=Pass": {POS: VERB, "Aspect": "Imp", "VerbForm": "Inf", "Voice": "Pass"},
    "VERB__Aspect=Perf|Case=Acc|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Perf", "Case": "Acc", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Perf|Case=Acc|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Case": "Acc", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Perf|Case=Acc|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Perf", "Case": "Acc", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Perf|Case=Acc|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Perf", "Case": "Acc", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Perf|Case=Acc|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Case": "Acc", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Perf|Case=Acc|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Perf", "Case": "Acc", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Perf|Case=Dat|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Perf", "Case": "Dat", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Perf|Case=Dat|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Case": "Dat", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Perf|Case=Dat|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Perf", "Case": "Dat", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Perf|Case=Dat|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Perf", "Case": "Dat", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Perf|Case=Dat|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Case": "Dat", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Perf|Case=Dat|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Perf", "Case": "Dat", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Perf|Case=Dat|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Perf", "Case": "Dat", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Perf|Case=Dat|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Case": "Dat", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Perf|Case=Dat|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Perf", "Case": "Dat", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Perf|Case=Dat|Number=Plur|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Perf", "Case": "Dat", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Perf|Case=Dat|Number=Plur|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Case": "Dat", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Perf|Case=Dat|Number=Plur|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Perf", "Case": "Dat", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Perf|Case=Gen|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Perf", "Case": "Gen", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Perf|Case=Gen|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Case": "Gen", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Perf|Case=Gen|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Perf", "Case": "Gen", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Perf|Case=Gen|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Perf", "Case": "Gen", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Perf|Case=Gen|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Case": "Gen", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Perf|Case=Gen|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Perf", "Case": "Gen", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Perf|Case=Gen|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Perf", "Case": "Gen", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Perf|Case=Gen|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Case": "Gen", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Perf|Case=Gen|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Perf", "Case": "Gen", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Perf|Case=Gen|Number=Plur|Tense=Fut|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Perf", "Case": "Gen", "Number": "Plur", "Tense": "Fut", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Perf|Case=Gen|Number=Plur|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Perf", "Case": "Gen", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Perf|Case=Gen|Number=Plur|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Case": "Gen", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Perf|Case=Gen|Number=Plur|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Perf", "Case": "Gen", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Perf|Case=Ins|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Perf", "Case": "Ins", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Perf|Case=Ins|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Case": "Ins", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Perf|Case=Ins|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Perf", "Case": "Ins", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Perf|Case=Ins|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Perf", "Case": "Ins", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Perf|Case=Ins|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Case": "Ins", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Perf|Case=Ins|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Perf", "Case": "Ins", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Perf|Case=Ins|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Perf", "Case": "Ins", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Perf|Case=Ins|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Case": "Ins", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Perf|Case=Ins|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Perf", "Case": "Ins", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Perf|Case=Ins|Number=Plur|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Perf", "Case": "Ins", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Perf|Case=Ins|Number=Plur|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Case": "Ins", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Perf|Case=Ins|Number=Plur|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Perf", "Case": "Ins", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Perf|Case=Loc|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Perf", "Case": "Loc", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Perf|Case=Loc|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Case": "Loc", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Perf|Case=Loc|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Perf", "Case": "Loc", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Perf|Case=Loc|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Perf", "Case": "Loc", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Perf|Case=Loc|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Case": "Loc", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Perf|Case=Loc|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Perf", "Case": "Loc", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Perf|Case=Loc|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Perf", "Case": "Loc", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Perf|Case=Loc|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Case": "Loc", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Perf|Case=Loc|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Perf", "Case": "Loc", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Perf|Case=Loc|Number=Plur|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Perf", "Case": "Loc", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Perf|Case=Loc|Number=Plur|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Case": "Loc", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Perf|Case=Loc|Number=Plur|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Perf", "Case": "Loc", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Perf|Case=Nom|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Perf", "Case": "Nom", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Perf|Case=Nom|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Case": "Nom", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Perf|Case=Nom|Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Perf", "Case": "Nom", "Gender": "Fem", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Perf|Case=Nom|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Perf", "Case": "Nom", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Perf|Case=Nom|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Case": "Nom", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Perf|Case=Nom|Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Perf", "Case": "Nom", "Gender": "Masc", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Perf|Case=Nom|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Perf", "Case": "Nom", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Perf|Case=Nom|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Case": "Nom", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Perf|Case=Nom|Gender=Neut|Number=Sing|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Perf", "Case": "Nom", "Gender": "Neut", "Number": "Sing", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Perf|Case=Nom|Number=Plur|Tense=Past|VerbForm=Part|Voice=Act": {POS: VERB, "Aspect": "Perf", "Case": "Nom", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Act"},
    "VERB__Aspect=Perf|Case=Nom|Number=Plur|Tense=Past|VerbForm=Part|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Case": "Nom", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Mid"},
    "VERB__Aspect=Perf|Case=Nom|Number=Plur|Tense=Past|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Perf", "Case": "Nom", "Number": "Plur", "Tense": "Past", "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Perf|Gender=Fem|Mood=Ind|Number=Sing|Tense=Past|VerbForm=Fin|Voice=Act": {POS: VERB, "Aspect": "Perf", "Gender": "Fem", "Mood": "Ind", "Number": "Sing", "Tense": "Past", "VerbForm": "Fin", "Voice": "Act"},
    "VERB__Aspect=Perf|Gender=Fem|Mood=Ind|Number=Sing|Tense=Past|VerbForm=Fin|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Gender": "Fem", "Mood": "Ind", "Number": "Sing", "Tense": "Past", "VerbForm": "Fin", "Voice": "Mid"},
    "VERB__Aspect=Perf|Gender=Fem|Number=Sing|Tense=Past|Variant=Short|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Perf", "Gender": "Fem", "Number": "Sing", "Tense": "Past",  "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Perf|Gender=Masc|Mood=Ind|Number=Sing|Tense=Past|VerbForm=Fin|Voice=Act": {POS: VERB, "Aspect": "Perf", "Gender": "Masc", "Mood": "Ind", "Number": "Sing", "Tense": "Past", "VerbForm": "Fin", "Voice": "Act"},
    "VERB__Aspect=Perf|Gender=Masc|Mood=Ind|Number=Sing|Tense=Past|VerbForm=Fin|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Gender": "Masc", "Mood": "Ind", "Number": "Sing", "Tense": "Past", "VerbForm": "Fin", "Voice": "Mid"},
    "VERB__Aspect=Perf|Gender=Masc|Number=Sing|Tense=Past|Variant=Short|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Perf", "Gender": "Masc", "Number": "Sing", "Tense": "Past",  "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Perf|Gender=Neut|Mood=Ind|Number=Sing|Tense=Past|VerbForm=Fin|Voice=Act": {POS: VERB, "Aspect": "Perf", "Gender": "Neut", "Mood": "Ind", "Number": "Sing", "Tense": "Past", "VerbForm": "Fin", "Voice": "Act"},
    "VERB__Aspect=Perf|Gender=Neut|Mood=Ind|Number=Sing|Tense=Past|VerbForm=Fin|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Gender": "Neut", "Mood": "Ind", "Number": "Sing", "Tense": "Past", "VerbForm": "Fin", "Voice": "Mid"},
    "VERB__Aspect=Perf|Gender=Neut|Number=Sing|Tense=Past|Variant=Short|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Perf", "Gender": "Neut", "Number": "Sing", "Tense": "Past",  "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Perf|Mood=Imp|Number=Plur|Person=1|VerbForm=Fin|Voice=Act": {POS: VERB, "Aspect": "Perf", "Mood": "Imp", "Number": "Plur", "Person": "one", "VerbForm": "Fin", "Voice": "Act"},
    "VERB__Aspect=Perf|Mood=Imp|Number=Plur|Person=2|VerbForm=Fin|Voice=Act": {POS: VERB, "Aspect": "Perf", "Mood": "Imp", "Number": "Plur", "Person": "two", "VerbForm": "Fin", "Voice": "Act"},
    "VERB__Aspect=Perf|Mood=Imp|Number=Plur|Person=2|VerbForm=Fin|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Mood": "Imp", "Number": "Plur", "Person": "two", "VerbForm": "Fin", "Voice": "Mid"},
    "VERB__Aspect=Perf|Mood=Imp|Number=Sing|Person=2|VerbForm=Fin|Voice=Act": {POS: VERB, "Aspect": "Perf", "Mood": "Imp", "Number": "Sing", "Person": "two", "VerbForm": "Fin", "Voice": "Act"},
    "VERB__Aspect=Perf|Mood=Imp|Number=Sing|Person=2|VerbForm=Fin|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Mood": "Imp", "Number": "Sing", "Person": "two", "VerbForm": "Fin", "Voice": "Mid"},
    "VERB__Aspect=Perf|Mood=Ind|Number=Plur|Person=1|Tense=Fut|VerbForm=Fin|Voice=Act": {POS: VERB, "Aspect": "Perf", "Mood": "Ind", "Number": "Plur", "Person": "one", "Tense": "Fut", "VerbForm": "Fin", "Voice": "Act"},
    "VERB__Aspect=Perf|Mood=Ind|Number=Plur|Person=1|Tense=Fut|VerbForm=Fin|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Mood": "Ind", "Number": "Plur", "Person": "one", "Tense": "Fut", "VerbForm": "Fin", "Voice": "Mid"},
    "VERB__Aspect=Perf|Mood=Ind|Number=Plur|Person=2|Tense=Fut|VerbForm=Fin|Voice=Act": {POS: VERB, "Aspect": "Perf", "Mood": "Ind", "Number": "Plur", "Person": "two", "Tense": "Fut", "VerbForm": "Fin", "Voice": "Act"},
    "VERB__Aspect=Perf|Mood=Ind|Number=Plur|Person=2|Tense=Fut|VerbForm=Fin|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Mood": "Ind", "Number": "Plur", "Person": "two", "Tense": "Fut", "VerbForm": "Fin", "Voice": "Mid"},
    "VERB__Aspect=Perf|Mood=Ind|Number=Plur|Person=3|Tense=Fut|VerbForm=Fin|Voice=Act": {POS: VERB, "Aspect": "Perf", "Mood": "Ind", "Number": "Plur", "Person": "three", "Tense": "Fut", "VerbForm": "Fin", "Voice": "Act"},
    "VERB__Aspect=Perf|Mood=Ind|Number=Plur|Person=3|Tense=Fut|VerbForm=Fin|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Mood": "Ind", "Number": "Plur", "Person": "three", "Tense": "Fut", "VerbForm": "Fin", "Voice": "Mid"},
    "VERB__Aspect=Perf|Mood=Ind|Number=Plur|Person=3|Tense=Fut|VerbForm=Fin|Voice=Pass": {POS: VERB, "Aspect": "Perf", "Mood": "Ind", "Number": "Plur", "Person": "three", "Tense": "Fut", "VerbForm": "Fin", "Voice": "Pass"},
    "VERB__Aspect=Perf|Mood=Ind|Number=Plur|Tense=Past|VerbForm=Fin|Voice=Act": {POS: VERB, "Aspect": "Perf", "Mood": "Ind", "Number": "Plur", "Tense": "Past", "VerbForm": "Fin", "Voice": "Act"},
    "VERB__Aspect=Perf|Mood=Ind|Number=Plur|Tense=Past|VerbForm=Fin|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Mood": "Ind", "Number": "Plur", "Tense": "Past", "VerbForm": "Fin", "Voice": "Mid"},
    "VERB__Aspect=Perf|Mood=Ind|Number=Sing|Person=1|Tense=Fut|VerbForm=Fin|Voice=Act": {POS: VERB, "Aspect": "Perf", "Mood": "Ind", "Number": "Sing", "Person": "one", "Tense": "Fut", "VerbForm": "Fin", "Voice": "Act"},
    "VERB__Aspect=Perf|Mood=Ind|Number=Sing|Person=1|Tense=Fut|VerbForm=Fin|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Mood": "Ind", "Number": "Sing", "Person": "one", "Tense": "Fut", "VerbForm": "Fin", "Voice": "Mid"},
    "VERB__Aspect=Perf|Mood=Ind|Number=Sing|Person=2|Tense=Fut|VerbForm=Fin|Voice=Act": {POS: VERB, "Aspect": "Perf", "Mood": "Ind", "Number": "Sing", "Person": "two", "Tense": "Fut", "VerbForm": "Fin", "Voice": "Act"},
    "VERB__Aspect=Perf|Mood=Ind|Number=Sing|Person=2|Tense=Fut|VerbForm=Fin|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Mood": "Ind", "Number": "Sing", "Person": "two", "Tense": "Fut", "VerbForm": "Fin", "Voice": "Mid"},
    "VERB__Aspect=Perf|Mood=Ind|Number=Sing|Person=3|Tense=Fut|VerbForm=Fin|Voice=Act": {POS: VERB, "Aspect": "Perf", "Mood": "Ind", "Number": "Sing", "Person": "three", "Tense": "Fut", "VerbForm": "Fin", "Voice": "Act"},
    "VERB__Aspect=Perf|Mood=Ind|Number=Sing|Person=3|Tense=Fut|VerbForm=Fin|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Mood": "Ind", "Number": "Sing", "Person": "three", "Tense": "Fut", "VerbForm": "Fin", "Voice": "Mid"},
    "VERB__Aspect=Perf|Number=Plur|Tense=Past|Variant=Short|VerbForm=Part|Voice=Pass": {POS: VERB, "Aspect": "Perf", "Number": "Plur", "Tense": "Past",  "VerbForm": "Part", "Voice": "Pass"},
    "VERB__Aspect=Perf|Tense=Past|VerbForm=Conv|Voice=Act": {POS: VERB, "Aspect": "Perf", "Tense": "Past", "VerbForm": "Conv", "Voice": "Act"},
    "VERB__Aspect=Perf|Tense=Past|VerbForm=Conv|Voice=Mid": {POS: VERB, "Aspect": "Perf", "Tense": "Past", "VerbForm": "Conv", "Voice": "Mid"},
    "VERB__Aspect=Perf|VerbForm=Inf|Voice=Act": {POS: VERB, "Aspect": "Perf", "VerbForm": "Inf", "Voice": "Act"},
    "VERB__Aspect=Perf|VerbForm=Inf|Voice=Mid": {POS: VERB, "Aspect": "Perf", "VerbForm": "Inf", "Voice": "Mid"},
    "VERB__Voice=Act": {POS: VERB, "Voice": "Act"},
    "VERB___": {POS: VERB},
    "VERB": {POS: VERB},
    "X__Foreign=Yes": {POS: X, "Foreign": "Yes"},
    "X___": {POS: X},
    "X": {POS: X},
}
# fmt: on
