# coding: utf8
from __future__ import unicode_literals

from ...symbols import POS, AUX, ADJ, CCONJ, NUM, ADV, ADP, X, VERB, DET, SCONJ, PUNCT
from ...symbols import NOUN, PART, INTJ, PRON

# Source https://universaldependencies.org/tagset-conversion/cs-pdt-uposf.html
# fmt: off
TAG_MAP = {
    "A.-------------": {POS: ADJ, "morph": "Abbr=Yes"},
    "A2--------A----": {POS: ADJ, "morph": "Hyph=Yes|Polarity=Pos"},
    "A2--------A---1": {POS: ADJ, "morph": "Hyph=Yes|Polarity=Pos"},
    "A2--------N----": {POS: ADJ, "morph": "Hyph=Yes|Polarity=Neg"},
    "AAFD7----1A----": {POS: ADJ, "morph": "Case=Ins|Degree=Pos|Gender=Fem|Number=Dual|Polarity=Pos"},
    "AAFD7----1A---6": {POS: ADJ, "morph": "Case=Ins|Degree=Pos|Gender=Fem|Number=Dual|Polarity=Pos|Style=Coll"},
    "AAFD7----1N----": {POS: ADJ, "morph": "Case=Ins|Degree=Pos|Gender=Fem|Number=Dual|Polarity=Neg"},
    "AAFD7----1N---6": {POS: ADJ, "morph": "Case=Ins|Degree=Pos|Gender=Fem|Number=Dual|Polarity=Neg|Style=Coll"},
    "AAFD7----2A----": {POS: ADJ, "morph": "Case=Ins|Degree=Cmp|Gender=Fem|Number=Dual|Polarity=Pos"},
    "AAFD7----2A---6": {POS: ADJ, "morph": "Case=Ins|Degree=Cmp|Gender=Fem|Number=Dual|Polarity=Pos|Style=Coll"},
    "AAFD7----2N----": {POS: ADJ, "morph": "Case=Ins|Degree=Cmp|Gender=Fem|Number=Dual|Polarity=Neg"},
    "AAFD7----2N---6": {POS: ADJ, "morph": "Case=Ins|Degree=Cmp|Gender=Fem|Number=Dual|Polarity=Neg|Style=Coll"},
    "AAFD7----3A----": {POS: ADJ, "morph": "Case=Ins|Degree=Sup|Gender=Fem|Number=Dual|Polarity=Pos"},
    "AAFD7----3A---6": {POS: ADJ, "morph": "Case=Ins|Degree=Sup|Gender=Fem|Number=Dual|Polarity=Pos|Style=Coll"},
    "AAFD7----3N----": {POS: ADJ, "morph": "Case=Ins|Degree=Sup|Gender=Fem|Number=Dual|Polarity=Neg"},
    "AAFD7----3N---6": {POS: ADJ, "morph": "Case=Ins|Degree=Sup|Gender=Fem|Number=Dual|Polarity=Neg|Style=Coll"},
    "AAFP1----1A----": {POS: ADJ, "morph": "Case=Nom|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Pos"},
    "AAFP1----1A---6": {POS: ADJ, "morph": "Case=Nom|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAFP1----1N----": {POS: ADJ, "morph": "Case=Nom|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Neg"},
    "AAFP1----1N---6": {POS: ADJ, "morph": "Case=Nom|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAFP1----2A----": {POS: ADJ, "morph": "Case=Nom|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Pos"},
    "AAFP1----2A---6": {POS: ADJ, "morph": "Case=Nom|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAFP1----2N----": {POS: ADJ, "morph": "Case=Nom|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Neg"},
    "AAFP1----2N---6": {POS: ADJ, "morph": "Case=Nom|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAFP1----3A----": {POS: ADJ, "morph": "Case=Nom|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Pos"},
    "AAFP1----3A---6": {POS: ADJ, "morph": "Case=Nom|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAFP1----3N----": {POS: ADJ, "morph": "Case=Nom|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Neg"},
    "AAFP1----3N---6": {POS: ADJ, "morph": "Case=Nom|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAFP2----1A----": {POS: ADJ, "morph": "Case=Gen|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Pos"},
    "AAFP2----1A---6": {POS: ADJ, "morph": "Case=Gen|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAFP2----1N----": {POS: ADJ, "morph": "Case=Gen|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Neg"},
    "AAFP2----1N---6": {POS: ADJ, "morph": "Case=Gen|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAFP2----2A----": {POS: ADJ, "morph": "Case=Gen|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Pos"},
    "AAFP2----2A---6": {POS: ADJ, "morph": "Case=Gen|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAFP2----2N----": {POS: ADJ, "morph": "Case=Gen|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Neg"},
    "AAFP2----2N---6": {POS: ADJ, "morph": "Case=Gen|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAFP2----3A----": {POS: ADJ, "morph": "Case=Gen|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Pos"},
    "AAFP2----3A---6": {POS: ADJ, "morph": "Case=Gen|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAFP2----3N----": {POS: ADJ, "morph": "Case=Gen|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Neg"},
    "AAFP2----3N---6": {POS: ADJ, "morph": "Case=Gen|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAFP3----1A----": {POS: ADJ, "morph": "Case=Dat|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Pos"},
    "AAFP3----1A---6": {POS: ADJ, "morph": "Case=Dat|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAFP3----1N----": {POS: ADJ, "morph": "Case=Dat|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Neg"},
    "AAFP3----1N---6": {POS: ADJ, "morph": "Case=Dat|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAFP3----2A----": {POS: ADJ, "morph": "Case=Dat|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Pos"},
    "AAFP3----2A---6": {POS: ADJ, "morph": "Case=Dat|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAFP3----2N----": {POS: ADJ, "morph": "Case=Dat|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Neg"},
    "AAFP3----2N---6": {POS: ADJ, "morph": "Case=Dat|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAFP3----3A----": {POS: ADJ, "morph": "Case=Dat|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Pos"},
    "AAFP3----3A---6": {POS: ADJ, "morph": "Case=Dat|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAFP3----3N----": {POS: ADJ, "morph": "Case=Dat|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Neg"},
    "AAFP3----3N---6": {POS: ADJ, "morph": "Case=Dat|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAFP4----1A----": {POS: ADJ, "morph": "Case=Acc|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Pos"},
    "AAFP4----1A---6": {POS: ADJ, "morph": "Case=Acc|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAFP4----1N----": {POS: ADJ, "morph": "Case=Acc|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Neg"},
    "AAFP4----1N---6": {POS: ADJ, "morph": "Case=Acc|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAFP4----2A----": {POS: ADJ, "morph": "Case=Acc|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Pos"},
    "AAFP4----2A---6": {POS: ADJ, "morph": "Case=Acc|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAFP4----2N----": {POS: ADJ, "morph": "Case=Acc|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Neg"},
    "AAFP4----2N---6": {POS: ADJ, "morph": "Case=Acc|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAFP4----3A----": {POS: ADJ, "morph": "Case=Acc|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Pos"},
    "AAFP4----3A---6": {POS: ADJ, "morph": "Case=Acc|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAFP4----3N----": {POS: ADJ, "morph": "Case=Acc|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Neg"},
    "AAFP4----3N---6": {POS: ADJ, "morph": "Case=Acc|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAFP5----1A----": {POS: ADJ, "morph": "Case=Voc|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Pos"},
    "AAFP5----1A---6": {POS: ADJ, "morph": "Case=Voc|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAFP5----1N----": {POS: ADJ, "morph": "Case=Voc|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Neg"},
    "AAFP5----1N---6": {POS: ADJ, "morph": "Case=Voc|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAFP5----2A----": {POS: ADJ, "morph": "Case=Voc|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Pos"},
    "AAFP5----2A---6": {POS: ADJ, "morph": "Case=Voc|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAFP5----2N----": {POS: ADJ, "morph": "Case=Voc|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Neg"},
    "AAFP5----2N---6": {POS: ADJ, "morph": "Case=Voc|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAFP5----3A----": {POS: ADJ, "morph": "Case=Voc|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Pos"},
    "AAFP5----3A---6": {POS: ADJ, "morph": "Case=Voc|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAFP5----3N----": {POS: ADJ, "morph": "Case=Voc|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Neg"},
    "AAFP5----3N---6": {POS: ADJ, "morph": "Case=Voc|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAFP6----1A----": {POS: ADJ, "morph": "Case=Loc|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Pos"},
    "AAFP6----1A---6": {POS: ADJ, "morph": "Case=Loc|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAFP6----1N----": {POS: ADJ, "morph": "Case=Loc|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Neg"},
    "AAFP6----1N---6": {POS: ADJ, "morph": "Case=Loc|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAFP6----2A----": {POS: ADJ, "morph": "Case=Loc|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Pos"},
    "AAFP6----2A---6": {POS: ADJ, "morph": "Case=Loc|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAFP6----2N----": {POS: ADJ, "morph": "Case=Loc|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Neg"},
    "AAFP6----2N---6": {POS: ADJ, "morph": "Case=Loc|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAFP6----3A----": {POS: ADJ, "morph": "Case=Loc|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Pos"},
    "AAFP6----3A---6": {POS: ADJ, "morph": "Case=Loc|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAFP6----3N----": {POS: ADJ, "morph": "Case=Loc|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Neg"},
    "AAFP6----3N---6": {POS: ADJ, "morph": "Case=Loc|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAFP7----1A----": {POS: ADJ, "morph": "Case=Ins|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Pos"},
    "AAFP7----1A---6": {POS: ADJ, "morph": "Case=Ins|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAFP7----1A---7": {POS: ADJ, "morph": "Case=Ins|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAFP7----1N----": {POS: ADJ, "morph": "Case=Ins|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Neg"},
    "AAFP7----1N---6": {POS: ADJ, "morph": "Case=Ins|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAFP7----1N---7": {POS: ADJ, "morph": "Case=Ins|Degree=Pos|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAFP7----2A----": {POS: ADJ, "morph": "Case=Ins|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Pos"},
    "AAFP7----2A---6": {POS: ADJ, "morph": "Case=Ins|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAFP7----2A---7": {POS: ADJ, "morph": "Case=Ins|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAFP7----2N----": {POS: ADJ, "morph": "Case=Ins|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Neg"},
    "AAFP7----2N---6": {POS: ADJ, "morph": "Case=Ins|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAFP7----2N---7": {POS: ADJ, "morph": "Case=Ins|Degree=Cmp|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAFP7----3A----": {POS: ADJ, "morph": "Case=Ins|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Pos"},
    "AAFP7----3A---6": {POS: ADJ, "morph": "Case=Ins|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAFP7----3A---7": {POS: ADJ, "morph": "Case=Ins|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAFP7----3N----": {POS: ADJ, "morph": "Case=Ins|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Neg"},
    "AAFP7----3N---6": {POS: ADJ, "morph": "Case=Ins|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAFP7----3N---7": {POS: ADJ, "morph": "Case=Ins|Degree=Sup|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAFS1----1A----": {POS: ADJ, "morph": "Case=Nom|Degree=Pos|Gender=Fem|Number=Sing|Polarity=Pos"},
    "AAFS1----1A---6": {POS: ADJ, "morph": "Case=Nom|Degree=Pos|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAFS1----1N----": {POS: ADJ, "morph": "Case=Nom|Degree=Pos|Gender=Fem|Number=Sing|Polarity=Neg"},
    "AAFS1----1N---6": {POS: ADJ, "morph": "Case=Nom|Degree=Pos|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAFS1----2A----": {POS: ADJ, "morph": "Case=Nom|Degree=Cmp|Gender=Fem|Number=Sing|Polarity=Pos"},
    "AAFS1----2A---6": {POS: ADJ, "morph": "Case=Nom|Degree=Cmp|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAFS1----2N----": {POS: ADJ, "morph": "Case=Nom|Degree=Cmp|Gender=Fem|Number=Sing|Polarity=Neg"},
    "AAFS1----2N---6": {POS: ADJ, "morph": "Case=Nom|Degree=Cmp|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAFS1----3A----": {POS: ADJ, "morph": "Case=Nom|Degree=Sup|Gender=Fem|Number=Sing|Polarity=Pos"},
    "AAFS1----3A---6": {POS: ADJ, "morph": "Case=Nom|Degree=Sup|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAFS1----3N----": {POS: ADJ, "morph": "Case=Nom|Degree=Sup|Gender=Fem|Number=Sing|Polarity=Neg"},
    "AAFS1----3N---6": {POS: ADJ, "morph": "Case=Nom|Degree=Sup|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAFS2----1A----": {POS: ADJ, "morph": "Case=Gen|Degree=Pos|Gender=Fem|Number=Sing|Polarity=Pos"},
    "AAFS2----1A---6": {POS: ADJ, "morph": "Case=Gen|Degree=Pos|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAFS2----1N----": {POS: ADJ, "morph": "Case=Gen|Degree=Pos|Gender=Fem|Number=Sing|Polarity=Neg"},
    "AAFS2----1N---6": {POS: ADJ, "morph": "Case=Gen|Degree=Pos|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAFS2----2A----": {POS: ADJ, "morph": "Case=Gen|Degree=Cmp|Gender=Fem|Number=Sing|Polarity=Pos"},
    "AAFS2----2A---6": {POS: ADJ, "morph": "Case=Gen|Degree=Cmp|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAFS2----2N----": {POS: ADJ, "morph": "Case=Gen|Degree=Cmp|Gender=Fem|Number=Sing|Polarity=Neg"},
    "AAFS2----2N---6": {POS: ADJ, "morph": "Case=Gen|Degree=Cmp|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAFS2----3A----": {POS: ADJ, "morph": "Case=Gen|Degree=Sup|Gender=Fem|Number=Sing|Polarity=Pos"},
    "AAFS2----3A---6": {POS: ADJ, "morph": "Case=Gen|Degree=Sup|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAFS2----3N----": {POS: ADJ, "morph": "Case=Gen|Degree=Sup|Gender=Fem|Number=Sing|Polarity=Neg"},
    "AAFS2----3N---6": {POS: ADJ, "morph": "Case=Gen|Degree=Sup|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAFS3----1A----": {POS: ADJ, "morph": "Case=Dat|Degree=Pos|Gender=Fem|Number=Sing|Polarity=Pos"},
    "AAFS3----1A---6": {POS: ADJ, "morph": "Case=Dat|Degree=Pos|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAFS3----1N----": {POS: ADJ, "morph": "Case=Dat|Degree=Pos|Gender=Fem|Number=Sing|Polarity=Neg"},
    "AAFS3----1N---6": {POS: ADJ, "morph": "Case=Dat|Degree=Pos|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAFS3----2A----": {POS: ADJ, "morph": "Case=Dat|Degree=Cmp|Gender=Fem|Number=Sing|Polarity=Pos"},
    "AAFS3----2A---6": {POS: ADJ, "morph": "Case=Dat|Degree=Cmp|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAFS3----2N----": {POS: ADJ, "morph": "Case=Dat|Degree=Cmp|Gender=Fem|Number=Sing|Polarity=Neg"},
    "AAFS3----2N---6": {POS: ADJ, "morph": "Case=Dat|Degree=Cmp|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAFS3----3A----": {POS: ADJ, "morph": "Case=Dat|Degree=Sup|Gender=Fem|Number=Sing|Polarity=Pos"},
    "AAFS3----3A---6": {POS: ADJ, "morph": "Case=Dat|Degree=Sup|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAFS3----3N----": {POS: ADJ, "morph": "Case=Dat|Degree=Sup|Gender=Fem|Number=Sing|Polarity=Neg"},
    "AAFS3----3N---6": {POS: ADJ, "morph": "Case=Dat|Degree=Sup|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAFS4----1A----": {POS: ADJ, "morph": "Case=Acc|Degree=Pos|Gender=Fem|Number=Sing|Polarity=Pos"},
    "AAFS4----1A---6": {POS: ADJ, "morph": "Case=Acc|Degree=Pos|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAFS4----1N----": {POS: ADJ, "morph": "Case=Acc|Degree=Pos|Gender=Fem|Number=Sing|Polarity=Neg"},
    "AAFS4----1N---6": {POS: ADJ, "morph": "Case=Acc|Degree=Pos|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAFS4----2A----": {POS: ADJ, "morph": "Case=Acc|Degree=Cmp|Gender=Fem|Number=Sing|Polarity=Pos"},
    "AAFS4----2A---6": {POS: ADJ, "morph": "Case=Acc|Degree=Cmp|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAFS4----2N----": {POS: ADJ, "morph": "Case=Acc|Degree=Cmp|Gender=Fem|Number=Sing|Polarity=Neg"},
    "AAFS4----2N---6": {POS: ADJ, "morph": "Case=Acc|Degree=Cmp|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAFS4----3A----": {POS: ADJ, "morph": "Case=Acc|Degree=Sup|Gender=Fem|Number=Sing|Polarity=Pos"},
    "AAFS4----3A---6": {POS: ADJ, "morph": "Case=Acc|Degree=Sup|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAFS4----3N----": {POS: ADJ, "morph": "Case=Acc|Degree=Sup|Gender=Fem|Number=Sing|Polarity=Neg"},
    "AAFS4----3N---6": {POS: ADJ, "morph": "Case=Acc|Degree=Sup|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAFS5----1A----": {POS: ADJ, "morph": "Case=Voc|Degree=Pos|Gender=Fem|Number=Sing|Polarity=Pos"},
    "AAFS5----1A---6": {POS: ADJ, "morph": "Case=Voc|Degree=Pos|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAFS5----1N----": {POS: ADJ, "morph": "Case=Voc|Degree=Pos|Gender=Fem|Number=Sing|Polarity=Neg"},
    "AAFS5----1N---6": {POS: ADJ, "morph": "Case=Voc|Degree=Pos|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAFS5----2A----": {POS: ADJ, "morph": "Case=Voc|Degree=Cmp|Gender=Fem|Number=Sing|Polarity=Pos"},
    "AAFS5----2A---6": {POS: ADJ, "morph": "Case=Voc|Degree=Cmp|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAFS5----2N----": {POS: ADJ, "morph": "Case=Voc|Degree=Cmp|Gender=Fem|Number=Sing|Polarity=Neg"},
    "AAFS5----2N---6": {POS: ADJ, "morph": "Case=Voc|Degree=Cmp|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAFS5----3A----": {POS: ADJ, "morph": "Case=Voc|Degree=Sup|Gender=Fem|Number=Sing|Polarity=Pos"},
    "AAFS5----3A---6": {POS: ADJ, "morph": "Case=Voc|Degree=Sup|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAFS5----3N----": {POS: ADJ, "morph": "Case=Voc|Degree=Sup|Gender=Fem|Number=Sing|Polarity=Neg"},
    "AAFS5----3N---6": {POS: ADJ, "morph": "Case=Voc|Degree=Sup|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAFS6----1A----": {POS: ADJ, "morph": "Case=Loc|Degree=Pos|Gender=Fem|Number=Sing|Polarity=Pos"},
    "AAFS6----1A---6": {POS: ADJ, "morph": "Case=Loc|Degree=Pos|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAFS6----1N----": {POS: ADJ, "morph": "Case=Loc|Degree=Pos|Gender=Fem|Number=Sing|Polarity=Neg"},
    "AAFS6----1N---6": {POS: ADJ, "morph": "Case=Loc|Degree=Pos|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAFS6----2A----": {POS: ADJ, "morph": "Case=Loc|Degree=Cmp|Gender=Fem|Number=Sing|Polarity=Pos"},
    "AAFS6----2A---6": {POS: ADJ, "morph": "Case=Loc|Degree=Cmp|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAFS6----2N----": {POS: ADJ, "morph": "Case=Loc|Degree=Cmp|Gender=Fem|Number=Sing|Polarity=Neg"},
    "AAFS6----2N---6": {POS: ADJ, "morph": "Case=Loc|Degree=Cmp|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAFS6----3A----": {POS: ADJ, "morph": "Case=Loc|Degree=Sup|Gender=Fem|Number=Sing|Polarity=Pos"},
    "AAFS6----3A---6": {POS: ADJ, "morph": "Case=Loc|Degree=Sup|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAFS6----3N----": {POS: ADJ, "morph": "Case=Loc|Degree=Sup|Gender=Fem|Number=Sing|Polarity=Neg"},
    "AAFS6----3N---6": {POS: ADJ, "morph": "Case=Loc|Degree=Sup|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAFS7----1A----": {POS: ADJ, "morph": "Case=Ins|Degree=Pos|Gender=Fem|Number=Sing|Polarity=Pos"},
    "AAFS7----1A---6": {POS: ADJ, "morph": "Case=Ins|Degree=Pos|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAFS7----1N----": {POS: ADJ, "morph": "Case=Ins|Degree=Pos|Gender=Fem|Number=Sing|Polarity=Neg"},
    "AAFS7----1N---6": {POS: ADJ, "morph": "Case=Ins|Degree=Pos|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAFS7----2A----": {POS: ADJ, "morph": "Case=Ins|Degree=Cmp|Gender=Fem|Number=Sing|Polarity=Pos"},
    "AAFS7----2A---6": {POS: ADJ, "morph": "Case=Ins|Degree=Cmp|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAFS7----2N----": {POS: ADJ, "morph": "Case=Ins|Degree=Cmp|Gender=Fem|Number=Sing|Polarity=Neg"},
    "AAFS7----2N---6": {POS: ADJ, "morph": "Case=Ins|Degree=Cmp|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAFS7----3A----": {POS: ADJ, "morph": "Case=Ins|Degree=Sup|Gender=Fem|Number=Sing|Polarity=Pos"},
    "AAFS7----3A---6": {POS: ADJ, "morph": "Case=Ins|Degree=Sup|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAFS7----3N----": {POS: ADJ, "morph": "Case=Ins|Degree=Sup|Gender=Fem|Number=Sing|Polarity=Neg"},
    "AAFS7----3N---6": {POS: ADJ, "morph": "Case=Ins|Degree=Sup|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAFSX----1A----": {POS: ADJ, "morph": "Degree=Pos|Gender=Fem|Number=Sing|Polarity=Pos"},
    "AAFXX----1A----": {POS: ADJ, "morph": "Degree=Pos|Gender=Fem|Polarity=Pos"},
    "AAFXX----1A---8": {POS: ADJ, "morph": "Abbr=Yes|Degree=Pos|Gender=Fem|Polarity=Pos"},
    "AAFXX----1N---8": {POS: ADJ, "morph": "Abbr=Yes|Degree=Pos|Gender=Fem|Polarity=Neg"},
    "AAIP1----1A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Nom|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAIP1----1A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Nom|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAIP1----1N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Nom|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAIP1----1N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Nom|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAIP1----2A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Nom|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAIP1----2A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Nom|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAIP1----2N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Nom|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAIP1----2N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Nom|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAIP1----3A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Nom|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAIP1----3A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Nom|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAIP1----3N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Nom|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAIP1----3N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Nom|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAIP2----1A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Gen|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAIP2----1A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Gen|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAIP2----1N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Gen|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAIP2----1N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Gen|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAIP2----2A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Gen|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAIP2----2A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Gen|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAIP2----2N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Gen|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAIP2----2N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Gen|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAIP2----3A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Gen|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAIP2----3A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Gen|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAIP2----3N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Gen|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAIP2----3N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Gen|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAIP3----1A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Dat|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAIP3----1A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Dat|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAIP3----1N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Dat|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAIP3----1N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Dat|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAIP3----2A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Dat|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAIP3----2A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Dat|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAIP3----2N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Dat|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAIP3----2N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Dat|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAIP3----3A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Dat|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAIP3----3A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Dat|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAIP3----3N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Dat|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAIP3----3N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Dat|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAIP4----1A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Acc|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAIP4----1A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Acc|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAIP4----1N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Acc|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAIP4----1N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Acc|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAIP4----2A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Acc|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAIP4----2A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Acc|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAIP4----2N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Acc|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAIP4----2N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Acc|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAIP4----3A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Acc|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAIP4----3A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Acc|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAIP4----3N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Acc|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAIP4----3N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Acc|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAIP5----1A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Voc|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAIP5----1A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Voc|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAIP5----1N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Voc|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAIP5----1N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Voc|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAIP5----2A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Voc|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAIP5----2A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Voc|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAIP5----2N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Voc|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAIP5----2N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Voc|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAIP5----3A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Voc|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAIP5----3A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Voc|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAIP5----3N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Voc|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAIP5----3N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Voc|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAIP6----1A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Loc|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAIP6----1A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Loc|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAIP6----1N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Loc|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAIP6----1N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Loc|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAIP6----2A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Loc|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAIP6----2A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Loc|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAIP6----2N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Loc|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAIP6----2N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Loc|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAIP6----3A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Loc|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAIP6----3A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Loc|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAIP6----3N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Loc|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAIP6----3N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Loc|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAIP7----1A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Ins|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAIP7----1A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAIP7----1A---7": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAIP7----1N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Ins|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAIP7----1N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAIP7----1N---7": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAIP7----2A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Ins|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAIP7----2A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAIP7----2A---7": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAIP7----2N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Ins|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAIP7----2N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAIP7----2N---7": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAIP7----3A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Ins|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAIP7----3A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAIP7----3A---7": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAIP7----3N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Ins|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAIP7----3N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAIP7----3N---7": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAIPX----1A----": {POS: ADJ, "morph": "Animacy=Inan|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAIPX----1N----": {POS: ADJ, "morph": "Animacy=Inan|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAIPX----2A----": {POS: ADJ, "morph": "Animacy=Inan|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAIPX----2N----": {POS: ADJ, "morph": "Animacy=Inan|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAIPX----3A----": {POS: ADJ, "morph": "Animacy=Inan|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAIPX----3N----": {POS: ADJ, "morph": "Animacy=Inan|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAIS1----1A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Nom|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAIS1----1A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Nom|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAIS1----1N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Nom|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAIS1----1N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Nom|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAIS1----2A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Nom|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAIS1----2A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Nom|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAIS1----2N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Nom|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAIS1----2N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Nom|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAIS1----3A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Nom|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAIS1----3A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Nom|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAIS1----3N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Nom|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAIS1----3N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Nom|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAIS2----1A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Gen|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAIS2----1A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Gen|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAIS2----1N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Gen|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAIS2----1N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Gen|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAIS2----2A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Gen|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAIS2----2A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Gen|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAIS2----2N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Gen|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAIS2----2N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Gen|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAIS2----3A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Gen|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAIS2----3A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Gen|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAIS2----3N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Gen|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAIS2----3N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Gen|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAIS3----1A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Dat|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAIS3----1A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Dat|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAIS3----1N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Dat|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAIS3----1N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Dat|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAIS3----2A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Dat|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAIS3----2A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Dat|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAIS3----2N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Dat|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAIS3----2N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Dat|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAIS3----3A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Dat|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAIS3----3A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Dat|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAIS3----3N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Dat|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAIS3----3N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Dat|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAIS4----1A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Acc|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAIS4----1A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Acc|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAIS4----1N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Acc|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAIS4----1N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Acc|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAIS4----2A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Acc|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAIS4----2A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Acc|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAIS4----2N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Acc|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAIS4----2N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Acc|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAIS4----3A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Acc|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAIS4----3A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Acc|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAIS4----3N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Acc|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAIS4----3N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Acc|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAIS5----1A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Voc|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAIS5----1A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Voc|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAIS5----1N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Voc|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAIS5----1N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Voc|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAIS5----2A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Voc|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAIS5----2A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Voc|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAIS5----2N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Voc|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAIS5----2N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Voc|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAIS5----3A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Voc|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAIS5----3A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Voc|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAIS5----3N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Voc|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAIS5----3N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Voc|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAIS6----1A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Loc|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAIS6----1A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Loc|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAIS6----1A---7": {POS: ADJ,"morph": "Animacy=Inan|Case=Loc|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAIS6----1N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Loc|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAIS6----1N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Loc|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAIS6----1N---7": {POS: ADJ,"morph": "Animacy=Inan|Case=Loc|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAIS6----2A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Loc|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAIS6----2A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Loc|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAIS6----2N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Loc|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAIS6----2N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Loc|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAIS6----3A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Loc|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAIS6----3A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Loc|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAIS6----3N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Loc|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAIS6----3N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Loc|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAIS7----1A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Ins|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAIS7----1A---2": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos|Style=Arch"},
    "AAIS7----1A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAIS7----1N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Ins|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAIS7----1N---2": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg|Style=Arch"},
    "AAIS7----1N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAIS7----2A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Ins|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAIS7----2A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAIS7----2N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Ins|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAIS7----2N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAIS7----3A----": {POS: ADJ, "morph": "Animacy=Inan|Case=Ins|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAIS7----3A---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAIS7----3N----": {POS: ADJ, "morph": "Animacy=Inan|Case=Ins|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAIS7----3N---6": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAISX----1A----": {POS: ADJ, "morph": "Animacy=Inan|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAIXX----1A----": {POS: ADJ, "morph": "Animacy=Inan|Degree=Pos|Gender=Masc|Polarity=Pos"},
    "AAMP1----1A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Nom|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAMP1----1A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Nom|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAMP1----1N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Nom|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAMP1----1N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Nom|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAMP1----2A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Nom|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAMP1----2A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Nom|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAMP1----2N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Nom|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAMP1----2N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Nom|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAMP1----3A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Nom|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAMP1----3A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Nom|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAMP1----3N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Nom|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAMP1----3N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Nom|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAMP2----1A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Gen|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAMP2----1A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Gen|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAMP2----1N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Gen|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAMP2----1N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Gen|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAMP2----2A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Gen|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAMP2----2A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Gen|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAMP2----2N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Gen|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAMP2----2N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Gen|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAMP2----3A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Gen|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAMP2----3A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Gen|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAMP2----3N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Gen|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAMP2----3N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Gen|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAMP3----1A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Dat|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAMP3----1A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Dat|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAMP3----1N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Dat|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAMP3----1N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Dat|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAMP3----2A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Dat|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAMP3----2A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Dat|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAMP3----2N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Dat|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAMP3----2N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Dat|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAMP3----3A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Dat|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAMP3----3A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Dat|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAMP3----3N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Dat|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAMP3----3N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Dat|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAMP4----1A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Acc|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAMP4----1A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Acc|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAMP4----1N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Acc|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAMP4----1N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Acc|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAMP4----2A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Acc|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAMP4----2A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Acc|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAMP4----2N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Acc|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAMP4----2N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Acc|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAMP4----3A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Acc|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAMP4----3A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Acc|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAMP4----3N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Acc|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAMP4----3N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Acc|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAMP5----1A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Voc|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAMP5----1A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Voc|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAMP5----1N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Voc|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAMP5----1N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Voc|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAMP5----2A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Voc|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAMP5----2A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Voc|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAMP5----2N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Voc|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAMP5----2N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Voc|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAMP5----3A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Voc|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAMP5----3A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Voc|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAMP5----3N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Voc|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAMP5----3N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Voc|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAMP6----1A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Loc|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAMP6----1A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Loc|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAMP6----1N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Loc|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAMP6----1N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Loc|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAMP6----2A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Loc|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAMP6----2A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Loc|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAMP6----2N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Loc|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAMP6----2N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Loc|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAMP6----3A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Loc|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAMP6----3A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Loc|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAMP6----3N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Loc|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAMP6----3N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Loc|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAMP7----1A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Ins|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAMP7----1A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Ins|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAMP7----1A---7": {POS: ADJ,"morph": "Animacy=Anim|Case=Ins|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAMP7----1N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Ins|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAMP7----1N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Ins|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAMP7----1N---7": {POS: ADJ,"morph": "Animacy=Anim|Case=Ins|Degree=Pos|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAMP7----2A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Ins|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAMP7----2A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Ins|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAMP7----2A---7": {POS: ADJ,"morph": "Animacy=Anim|Case=Ins|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAMP7----2N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Ins|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAMP7----2N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Ins|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAMP7----2N---7": {POS: ADJ,"morph": "Animacy=Anim|Case=Ins|Degree=Cmp|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAMP7----3A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Ins|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos"},
    "AAMP7----3A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Ins|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAMP7----3A---7": {POS: ADJ,"morph": "Animacy=Anim|Case=Ins|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "AAMP7----3N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Ins|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg"},
    "AAMP7----3N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Ins|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAMP7----3N---7": {POS: ADJ,"morph": "Animacy=Anim|Case=Ins|Degree=Sup|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "AAMS1----1A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Nom|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAMS1----1A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Nom|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAMS1----1N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Nom|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAMS1----1N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Nom|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAMS1----2A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Nom|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAMS1----2A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Nom|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAMS1----2N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Nom|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAMS1----2N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Nom|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAMS1----3A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Nom|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAMS1----3A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Nom|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAMS1----3N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Nom|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAMS1----3N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Nom|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAMS2----1A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Gen|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAMS2----1A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Gen|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAMS2----1N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Gen|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAMS2----1N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Gen|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAMS2----2A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Gen|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAMS2----2A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Gen|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAMS2----2N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Gen|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAMS2----2N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Gen|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAMS2----3A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Gen|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAMS2----3A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Gen|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAMS2----3N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Gen|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAMS2----3N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Gen|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAMS3----1A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Dat|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAMS3----1A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Dat|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAMS3----1N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Dat|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAMS3----1N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Dat|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAMS3----2A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Dat|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAMS3----2A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Dat|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAMS3----2N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Dat|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAMS3----2N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Dat|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAMS3----3A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Dat|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAMS3----3A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Dat|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAMS3----3N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Dat|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAMS3----3N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Dat|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAMS4----1A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Acc|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAMS4----1A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Acc|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAMS4----1N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Acc|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAMS4----1N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Acc|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAMS4----2A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Acc|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAMS4----2A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Acc|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAMS4----2N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Acc|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAMS4----2N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Acc|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAMS4----3A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Acc|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAMS4----3A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Acc|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAMS4----3N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Acc|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAMS4----3N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Acc|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAMS5----1A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Voc|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAMS5----1A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Voc|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAMS5----1N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Voc|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAMS5----1N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Voc|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAMS5----2A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Voc|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAMS5----2A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Voc|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAMS5----2N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Voc|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAMS5----2N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Voc|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAMS5----3A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Voc|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAMS5----3A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Voc|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAMS5----3N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Voc|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAMS5----3N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Voc|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAMS6----1A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Loc|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAMS6----1A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Loc|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAMS6----1A---7": {POS: ADJ,"morph": "Animacy=Anim|Case=Loc|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAMS6----1N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Loc|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAMS6----1N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Loc|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAMS6----1N---7": {POS: ADJ,"morph": "Animacy=Anim|Case=Loc|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAMS6----2A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Loc|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAMS6----2A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Loc|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAMS6----2N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Loc|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAMS6----2N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Loc|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAMS6----3A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Loc|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAMS6----3A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Loc|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAMS6----3N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Loc|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAMS6----3N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Loc|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAMS7----1A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Ins|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAMS7----1A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Ins|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAMS7----1N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Ins|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAMS7----1N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Ins|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAMS7----2A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Ins|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAMS7----2A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Ins|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAMS7----2N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Ins|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAMS7----2N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Ins|Degree=Cmp|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAMS7----3A----": {POS: ADJ, "morph": "Animacy=Anim|Case=Ins|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAMS7----3A---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Ins|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "AAMS7----3N----": {POS: ADJ, "morph": "Animacy=Anim|Case=Ins|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Neg"},
    "AAMS7----3N---6": {POS: ADJ,"morph": "Animacy=Anim|Case=Ins|Degree=Sup|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "AAMSX----1A----": {POS: ADJ, "morph": "Animacy=Anim|Degree=Pos|Gender=Masc|Number=Sing|Polarity=Pos"},
    "AAND7----1A----": {POS: ADJ, "morph": "Case=Ins|Degree=Pos|Gender=Neut|Number=Dual|Polarity=Pos"},
    "AAND7----1A---6": {POS: ADJ, "morph": "Case=Ins|Degree=Pos|Gender=Neut|Number=Dual|Polarity=Pos|Style=Coll"},
    "AAND7----1N----": {POS: ADJ, "morph": "Case=Ins|Degree=Pos|Gender=Neut|Number=Dual|Polarity=Neg"},
    "AAND7----1N---6": {POS: ADJ, "morph": "Case=Ins|Degree=Pos|Gender=Neut|Number=Dual|Polarity=Neg|Style=Coll"},
    "AAND7----2A----": {POS: ADJ, "morph": "Case=Ins|Degree=Cmp|Gender=Neut|Number=Dual|Polarity=Pos"},
    "AAND7----2A---6": {POS: ADJ, "morph": "Case=Ins|Degree=Cmp|Gender=Neut|Number=Dual|Polarity=Pos|Style=Coll"},
    "AAND7----2N----": {POS: ADJ, "morph": "Case=Ins|Degree=Cmp|Gender=Neut|Number=Dual|Polarity=Neg"},
    "AAND7----2N---6": {POS: ADJ, "morph": "Case=Ins|Degree=Cmp|Gender=Neut|Number=Dual|Polarity=Neg|Style=Coll"},
    "AAND7----3A----": {POS: ADJ, "morph": "Case=Ins|Degree=Sup|Gender=Neut|Number=Dual|Polarity=Pos"},
    "AAND7----3A---6": {POS: ADJ, "morph": "Case=Ins|Degree=Sup|Gender=Neut|Number=Dual|Polarity=Pos|Style=Coll"},
    "AAND7----3N----": {POS: ADJ, "morph": "Case=Ins|Degree=Sup|Gender=Neut|Number=Dual|Polarity=Neg"},
    "AAND7----3N---6": {POS: ADJ, "morph": "Case=Ins|Degree=Sup|Gender=Neut|Number=Dual|Polarity=Neg|Style=Coll"},
    "AANP1----1A----": {POS: ADJ, "morph": "Case=Nom|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Pos"},
    "AANP1----1A---6": {POS: ADJ, "morph": "Case=Nom|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "AANP1----1N----": {POS: ADJ, "morph": "Case=Nom|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Neg"},
    "AANP1----1N---6": {POS: ADJ, "morph": "Case=Nom|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "AANP1----2A----": {POS: ADJ, "morph": "Case=Nom|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Pos"},
    "AANP1----2A---6": {POS: ADJ, "morph": "Case=Nom|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "AANP1----2N----": {POS: ADJ, "morph": "Case=Nom|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Neg"},
    "AANP1----2N---6": {POS: ADJ, "morph": "Case=Nom|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "AANP1----3A----": {POS: ADJ, "morph": "Case=Nom|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Pos"},
    "AANP1----3A---6": {POS: ADJ, "morph": "Case=Nom|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "AANP1----3N----": {POS: ADJ, "morph": "Case=Nom|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Neg"},
    "AANP1----3N---6": {POS: ADJ, "morph": "Case=Nom|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "AANP2----1A----": {POS: ADJ, "morph": "Case=Gen|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Pos"},
    "AANP2----1A---6": {POS: ADJ, "morph": "Case=Gen|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "AANP2----1N----": {POS: ADJ, "morph": "Case=Gen|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Neg"},
    "AANP2----1N---6": {POS: ADJ, "morph": "Case=Gen|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "AANP2----2A----": {POS: ADJ, "morph": "Case=Gen|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Pos"},
    "AANP2----2A---6": {POS: ADJ, "morph": "Case=Gen|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "AANP2----2N----": {POS: ADJ, "morph": "Case=Gen|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Neg"},
    "AANP2----2N---6": {POS: ADJ, "morph": "Case=Gen|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "AANP2----3A----": {POS: ADJ, "morph": "Case=Gen|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Pos"},
    "AANP2----3A---6": {POS: ADJ, "morph": "Case=Gen|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "AANP2----3N----": {POS: ADJ, "morph": "Case=Gen|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Neg"},
    "AANP2----3N---6": {POS: ADJ, "morph": "Case=Gen|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "AANP3----1A----": {POS: ADJ, "morph": "Case=Dat|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Pos"},
    "AANP3----1A---6": {POS: ADJ, "morph": "Case=Dat|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "AANP3----1N----": {POS: ADJ, "morph": "Case=Dat|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Neg"},
    "AANP3----1N---6": {POS: ADJ, "morph": "Case=Dat|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "AANP3----2A----": {POS: ADJ, "morph": "Case=Dat|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Pos"},
    "AANP3----2A---6": {POS: ADJ, "morph": "Case=Dat|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "AANP3----2N----": {POS: ADJ, "morph": "Case=Dat|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Neg"},
    "AANP3----2N---6": {POS: ADJ, "morph": "Case=Dat|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "AANP3----3A----": {POS: ADJ, "morph": "Case=Dat|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Pos"},
    "AANP3----3A---6": {POS: ADJ, "morph": "Case=Dat|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "AANP3----3N----": {POS: ADJ, "morph": "Case=Dat|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Neg"},
    "AANP3----3N---6": {POS: ADJ, "morph": "Case=Dat|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "AANP4----1A----": {POS: ADJ, "morph": "Case=Acc|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Pos"},
    "AANP4----1A---6": {POS: ADJ, "morph": "Case=Acc|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "AANP4----1N----": {POS: ADJ, "morph": "Case=Acc|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Neg"},
    "AANP4----1N---6": {POS: ADJ, "morph": "Case=Acc|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "AANP4----2A----": {POS: ADJ, "morph": "Case=Acc|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Pos"},
    "AANP4----2A---6": {POS: ADJ, "morph": "Case=Acc|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "AANP4----2N----": {POS: ADJ, "morph": "Case=Acc|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Neg"},
    "AANP4----2N---6": {POS: ADJ, "morph": "Case=Acc|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "AANP4----3A----": {POS: ADJ, "morph": "Case=Acc|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Pos"},
    "AANP4----3A---6": {POS: ADJ, "morph": "Case=Acc|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "AANP4----3N----": {POS: ADJ, "morph": "Case=Acc|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Neg"},
    "AANP4----3N---6": {POS: ADJ, "morph": "Case=Acc|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "AANP5----1A----": {POS: ADJ, "morph": "Case=Voc|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Pos"},
    "AANP5----1A---6": {POS: ADJ, "morph": "Case=Voc|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "AANP5----1N----": {POS: ADJ, "morph": "Case=Voc|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Neg"},
    "AANP5----1N---6": {POS: ADJ, "morph": "Case=Voc|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "AANP5----2A----": {POS: ADJ, "morph": "Case=Voc|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Pos"},
    "AANP5----2A---6": {POS: ADJ, "morph": "Case=Voc|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "AANP5----2N----": {POS: ADJ, "morph": "Case=Voc|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Neg"},
    "AANP5----2N---6": {POS: ADJ, "morph": "Case=Voc|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "AANP5----3A----": {POS: ADJ, "morph": "Case=Voc|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Pos"},
    "AANP5----3A---6": {POS: ADJ, "morph": "Case=Voc|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "AANP5----3N----": {POS: ADJ, "morph": "Case=Voc|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Neg"},
    "AANP5----3N---6": {POS: ADJ, "morph": "Case=Voc|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "AANP6----1A----": {POS: ADJ, "morph": "Case=Loc|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Pos"},
    "AANP6----1A---6": {POS: ADJ, "morph": "Case=Loc|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "AANP6----1N----": {POS: ADJ, "morph": "Case=Loc|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Neg"},
    "AANP6----1N---6": {POS: ADJ, "morph": "Case=Loc|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "AANP6----2A----": {POS: ADJ, "morph": "Case=Loc|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Pos"},
    "AANP6----2A---6": {POS: ADJ, "morph": "Case=Loc|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "AANP6----2N----": {POS: ADJ, "morph": "Case=Loc|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Neg"},
    "AANP6----2N---6": {POS: ADJ, "morph": "Case=Loc|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "AANP6----3A----": {POS: ADJ, "morph": "Case=Loc|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Pos"},
    "AANP6----3A---6": {POS: ADJ, "morph": "Case=Loc|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "AANP6----3N----": {POS: ADJ, "morph": "Case=Loc|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Neg"},
    "AANP6----3N---6": {POS: ADJ, "morph": "Case=Loc|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "AANP7----1A----": {POS: ADJ, "morph": "Case=Ins|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Pos"},
    "AANP7----1A---6": {POS: ADJ, "morph": "Case=Ins|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "AANP7----1A---7": {POS: ADJ, "morph": "Case=Ins|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "AANP7----1N----": {POS: ADJ, "morph": "Case=Ins|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Neg"},
    "AANP7----1N---6": {POS: ADJ, "morph": "Case=Ins|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "AANP7----1N---7": {POS: ADJ, "morph": "Case=Ins|Degree=Pos|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "AANP7----2A----": {POS: ADJ, "morph": "Case=Ins|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Pos"},
    "AANP7----2A---6": {POS: ADJ, "morph": "Case=Ins|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "AANP7----2A---7": {POS: ADJ, "morph": "Case=Ins|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "AANP7----2N----": {POS: ADJ, "morph": "Case=Ins|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Neg"},
    "AANP7----2N---6": {POS: ADJ, "morph": "Case=Ins|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "AANP7----2N---7": {POS: ADJ, "morph": "Case=Ins|Degree=Cmp|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "AANP7----3A----": {POS: ADJ, "morph": "Case=Ins|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Pos"},
    "AANP7----3A---6": {POS: ADJ, "morph": "Case=Ins|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "AANP7----3A---7": {POS: ADJ, "morph": "Case=Ins|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "AANP7----3N----": {POS: ADJ, "morph": "Case=Ins|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Neg"},
    "AANP7----3N---6": {POS: ADJ, "morph": "Case=Ins|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "AANP7----3N---7": {POS: ADJ, "morph": "Case=Ins|Degree=Sup|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "AANS1----1A----": {POS: ADJ, "morph": "Case=Nom|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Pos"},
    "AANS1----1A---6": {POS: ADJ, "morph": "Case=Nom|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "AANS1----1N----": {POS: ADJ, "morph": "Case=Nom|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Neg"},
    "AANS1----1N---6": {POS: ADJ, "morph": "Case=Nom|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "AANS1----2A----": {POS: ADJ, "morph": "Case=Nom|Degree=Cmp|Gender=Neut|Number=Sing|Polarity=Pos"},
    "AANS1----2A---6": {POS: ADJ, "morph": "Case=Nom|Degree=Cmp|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "AANS1----2N----": {POS: ADJ, "morph": "Case=Nom|Degree=Cmp|Gender=Neut|Number=Sing|Polarity=Neg"},
    "AANS1----2N---6": {POS: ADJ, "morph": "Case=Nom|Degree=Cmp|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "AANS1----3A----": {POS: ADJ, "morph": "Case=Nom|Degree=Sup|Gender=Neut|Number=Sing|Polarity=Pos"},
    "AANS1----3A---6": {POS: ADJ, "morph": "Case=Nom|Degree=Sup|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "AANS1----3N----": {POS: ADJ, "morph": "Case=Nom|Degree=Sup|Gender=Neut|Number=Sing|Polarity=Neg"},
    "AANS1----3N---6": {POS: ADJ, "morph": "Case=Nom|Degree=Sup|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "AANS2----1A----": {POS: ADJ, "morph": "Case=Gen|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Pos"},
    "AANS2----1A---6": {POS: ADJ, "morph": "Case=Gen|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "AANS2----1N----": {POS: ADJ, "morph": "Case=Gen|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Neg"},
    "AANS2----1N---6": {POS: ADJ, "morph": "Case=Gen|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "AANS2----2A----": {POS: ADJ, "morph": "Case=Gen|Degree=Cmp|Gender=Neut|Number=Sing|Polarity=Pos"},
    "AANS2----2A---6": {POS: ADJ, "morph": "Case=Gen|Degree=Cmp|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "AANS2----2N----": {POS: ADJ, "morph": "Case=Gen|Degree=Cmp|Gender=Neut|Number=Sing|Polarity=Neg"},
    "AANS2----2N---6": {POS: ADJ, "morph": "Case=Gen|Degree=Cmp|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "AANS2----3A----": {POS: ADJ, "morph": "Case=Gen|Degree=Sup|Gender=Neut|Number=Sing|Polarity=Pos"},
    "AANS2----3A---6": {POS: ADJ, "morph": "Case=Gen|Degree=Sup|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "AANS2----3N----": {POS: ADJ, "morph": "Case=Gen|Degree=Sup|Gender=Neut|Number=Sing|Polarity=Neg"},
    "AANS2----3N---6": {POS: ADJ, "morph": "Case=Gen|Degree=Sup|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "AANS3----1A----": {POS: ADJ, "morph": "Case=Dat|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Pos"},
    "AANS3----1A---6": {POS: ADJ, "morph": "Case=Dat|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "AANS3----1N----": {POS: ADJ, "morph": "Case=Dat|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Neg"},
    "AANS3----1N---6": {POS: ADJ, "morph": "Case=Dat|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "AANS3----2A----": {POS: ADJ, "morph": "Case=Dat|Degree=Cmp|Gender=Neut|Number=Sing|Polarity=Pos"},
    "AANS3----2A---6": {POS: ADJ, "morph": "Case=Dat|Degree=Cmp|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "AANS3----2N----": {POS: ADJ, "morph": "Case=Dat|Degree=Cmp|Gender=Neut|Number=Sing|Polarity=Neg"},
    "AANS3----2N---6": {POS: ADJ, "morph": "Case=Dat|Degree=Cmp|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "AANS3----3A----": {POS: ADJ, "morph": "Case=Dat|Degree=Sup|Gender=Neut|Number=Sing|Polarity=Pos"},
    "AANS3----3A---6": {POS: ADJ, "morph": "Case=Dat|Degree=Sup|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "AANS3----3N----": {POS: ADJ, "morph": "Case=Dat|Degree=Sup|Gender=Neut|Number=Sing|Polarity=Neg"},
    "AANS3----3N---6": {POS: ADJ, "morph": "Case=Dat|Degree=Sup|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "AANS4----1A----": {POS: ADJ, "morph": "Case=Acc|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Pos"},
    "AANS4----1A---6": {POS: ADJ, "morph": "Case=Acc|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "AANS4----1N----": {POS: ADJ, "morph": "Case=Acc|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Neg"},
    "AANS4----1N---6": {POS: ADJ, "morph": "Case=Acc|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "AANS4----2A----": {POS: ADJ, "morph": "Case=Acc|Degree=Cmp|Gender=Neut|Number=Sing|Polarity=Pos"},
    "AANS4----2A---6": {POS: ADJ, "morph": "Case=Acc|Degree=Cmp|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "AANS4----2N----": {POS: ADJ, "morph": "Case=Acc|Degree=Cmp|Gender=Neut|Number=Sing|Polarity=Neg"},
    "AANS4----2N---6": {POS: ADJ, "morph": "Case=Acc|Degree=Cmp|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "AANS4----3A----": {POS: ADJ, "morph": "Case=Acc|Degree=Sup|Gender=Neut|Number=Sing|Polarity=Pos"},
    "AANS4----3A---6": {POS: ADJ, "morph": "Case=Acc|Degree=Sup|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "AANS4----3N----": {POS: ADJ, "morph": "Case=Acc|Degree=Sup|Gender=Neut|Number=Sing|Polarity=Neg"},
    "AANS4----3N---6": {POS: ADJ, "morph": "Case=Acc|Degree=Sup|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "AANS5----1A----": {POS: ADJ, "morph": "Case=Voc|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Pos"},
    "AANS5----1A---6": {POS: ADJ, "morph": "Case=Voc|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "AANS5----1N----": {POS: ADJ, "morph": "Case=Voc|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Neg"},
    "AANS5----1N---6": {POS: ADJ, "morph": "Case=Voc|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "AANS5----2A----": {POS: ADJ, "morph": "Case=Voc|Degree=Cmp|Gender=Neut|Number=Sing|Polarity=Pos"},
    "AANS5----2A---6": {POS: ADJ, "morph": "Case=Voc|Degree=Cmp|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "AANS5----2N----": {POS: ADJ, "morph": "Case=Voc|Degree=Cmp|Gender=Neut|Number=Sing|Polarity=Neg"},
    "AANS5----2N---6": {POS: ADJ, "morph": "Case=Voc|Degree=Cmp|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "AANS5----3A----": {POS: ADJ, "morph": "Case=Voc|Degree=Sup|Gender=Neut|Number=Sing|Polarity=Pos"},
    "AANS5----3A---6": {POS: ADJ, "morph": "Case=Voc|Degree=Sup|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "AANS5----3N----": {POS: ADJ, "morph": "Case=Voc|Degree=Sup|Gender=Neut|Number=Sing|Polarity=Neg"},
    "AANS5----3N---6": {POS: ADJ, "morph": "Case=Voc|Degree=Sup|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "AANS6----1A----": {POS: ADJ, "morph": "Case=Loc|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Pos"},
    "AANS6----1A---6": {POS: ADJ, "morph": "Case=Loc|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "AANS6----1A---7": {POS: ADJ, "morph": "Case=Loc|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "AANS6----1N----": {POS: ADJ, "morph": "Case=Loc|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Neg"},
    "AANS6----1N---6": {POS: ADJ, "morph": "Case=Loc|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "AANS6----1N---7": {POS: ADJ, "morph": "Case=Loc|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "AANS6----2A----": {POS: ADJ, "morph": "Case=Loc|Degree=Cmp|Gender=Neut|Number=Sing|Polarity=Pos"},
    "AANS6----2A---6": {POS: ADJ, "morph": "Case=Loc|Degree=Cmp|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "AANS6----2N----": {POS: ADJ, "morph": "Case=Loc|Degree=Cmp|Gender=Neut|Number=Sing|Polarity=Neg"},
    "AANS6----2N---6": {POS: ADJ, "morph": "Case=Loc|Degree=Cmp|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "AANS6----3A----": {POS: ADJ, "morph": "Case=Loc|Degree=Sup|Gender=Neut|Number=Sing|Polarity=Pos"},
    "AANS6----3A---6": {POS: ADJ, "morph": "Case=Loc|Degree=Sup|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "AANS6----3N----": {POS: ADJ, "morph": "Case=Loc|Degree=Sup|Gender=Neut|Number=Sing|Polarity=Neg"},
    "AANS6----3N---6": {POS: ADJ, "morph": "Case=Loc|Degree=Sup|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "AANS7----1A----": {POS: ADJ, "morph": "Case=Ins|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Pos"},
    "AANS7----1A---6": {POS: ADJ, "morph": "Case=Ins|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "AANS7----1A---8": {POS: ADJ, "morph": "Abbr=Yes|Case=Ins|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Pos"},
    "AANS7----1N----": {POS: ADJ, "morph": "Case=Ins|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Neg"},
    "AANS7----1N---6": {POS: ADJ, "morph": "Case=Ins|Degree=Pos|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "AANS7----2A----": {POS: ADJ, "morph": "Case=Ins|Degree=Cmp|Gender=Neut|Number=Sing|Polarity=Pos"},
    "AANS7----2A---6": {POS: ADJ, "morph": "Case=Ins|Degree=Cmp|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "AANS7----2N----": {POS: ADJ, "morph": "Case=Ins|Degree=Cmp|Gender=Neut|Number=Sing|Polarity=Neg"},
    "AANS7----2N---6": {POS: ADJ, "morph": "Case=Ins|Degree=Cmp|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "AANS7----3A----": {POS: ADJ, "morph": "Case=Ins|Degree=Sup|Gender=Neut|Number=Sing|Polarity=Pos"},
    "AANS7----3A---6": {POS: ADJ, "morph": "Case=Ins|Degree=Sup|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "AANS7----3N----": {POS: ADJ, "morph": "Case=Ins|Degree=Sup|Gender=Neut|Number=Sing|Polarity=Neg"},
    "AANS7----3N---6": {POS: ADJ, "morph": "Case=Ins|Degree=Sup|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "AANSX----1A----": {POS: ADJ, "morph": "Degree=Pos|Gender=Neut|Number=Sing|Polarity=Pos"},
    "AAXPX----1A----": {POS: ADJ, "morph": "Degree=Pos|Number=Plur|Polarity=Pos"},
    "AAXPX----1N----": {POS: ADJ, "morph": "Degree=Pos|Number=Plur|Polarity=Neg"},
    "AAXXX----1A----": {POS: ADJ, "morph": "Degree=Pos|Polarity=Pos"},
    "AAXXX----1A---1": {POS: ADJ, "morph": "Degree=Pos|Polarity=Pos"},
    "AAXXX----1A---8": {POS: ADJ, "morph": "Abbr=Yes|Degree=Pos|Polarity=Pos"},
    "AAXXX----1A---9": {POS: ADJ, "morph": "Degree=Pos|Polarity=Pos"},
    "AAXXX----1N----": {POS: ADJ, "morph": "Degree=Pos|Polarity=Neg"},
    "AAXXX----1N---8": {POS: ADJ, "morph": "Abbr=Yes|Degree=Pos|Polarity=Neg"},
    "AAXXX----1N---9": {POS: ADJ, "morph": "Degree=Pos|Polarity=Neg"},
    "AAXXX----2A---8": {POS: ADJ, "morph": "Abbr=Yes|Degree=Cmp|Polarity=Pos"},
    "AAXXX----3A---8": {POS: ADJ, "morph": "Abbr=Yes|Degree=Sup|Polarity=Pos"},
    "ACFS4-----A----": {POS: ADJ, "morph": "Case=Acc|Gender=Fem|Number=Sing|Polarity=Pos|Variant=Short"},
    "ACFS4-----N----": {POS: ADJ, "morph": "Case=Acc|Gender=Fem|Number=Sing|Polarity=Neg|Variant=Short"},
    "ACMP------A----": {POS: ADJ, "morph": "Animacy=Anim|Gender=Masc|Number=Plur|Polarity=Pos|Variant=Short"},
    "ACMP------N----": {POS: ADJ, "morph": "Animacy=Anim|Gender=Masc|Number=Plur|Polarity=Neg|Variant=Short"},
    "ACNS------A----": {POS: ADJ, "morph": "Gender=Neut|Number=Sing|Polarity=Pos|Variant=Short"},
    "ACNS------N----": {POS: ADJ, "morph": "Gender=Neut|Number=Sing|Polarity=Neg|Variant=Short"},
    "ACQW------A----": {POS: ADJ, "morph": "Gender=Fem,Neut|Number=Plur,Sing|Polarity=Pos|Variant=Short"},
    "ACQW------N----": {POS: ADJ, "morph": "Gender=Fem,Neut|Number=Plur,Sing|Polarity=Neg|Variant=Short"},
    "ACTP------A----": {POS: ADJ, "morph": "Animacy=Inan|Gender=Fem,Masc|Number=Plur|Polarity=Pos|Variant=Short"},
    "ACTP------N----": {POS: ADJ, "morph": "Animacy=Inan|Gender=Fem,Masc|Number=Plur|Polarity=Neg|Variant=Short"},
    "ACYS------A----": {POS: ADJ, "morph": "Gender=Masc|Number=Sing|Polarity=Pos|Variant=Short"},
    "ACYS------N----": {POS: ADJ, "morph": "Gender=Masc|Number=Sing|Polarity=Neg|Variant=Short"},
    "AGFD7-----A----": {POS: ADJ, "morph": "Aspect=Imp|Case=Ins|Gender=Fem|Number=Dual|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFD7-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Ins|Gender=Fem|Number=Dual|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFD7-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Ins|Gender=Fem|Number=Dual|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFD7-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Ins|Gender=Fem|Number=Dual|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFP1-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Nom|Gender=Fem|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFP1-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Nom|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFP1-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Nom|Gender=Fem|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFP1-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Nom|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFP2-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Gen|Gender=Fem|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFP2-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Gen|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFP2-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Gen|Gender=Fem|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFP2-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Gen|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFP3-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Dat|Gender=Fem|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFP3-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Dat|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFP3-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Dat|Gender=Fem|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFP3-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Dat|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFP4-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Acc|Gender=Fem|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFP4-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Acc|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFP4-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Acc|Gender=Fem|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFP4-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Acc|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFP5-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Voc|Gender=Fem|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFP5-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Voc|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFP5-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Voc|Gender=Fem|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFP5-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Voc|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFP6-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Loc|Gender=Fem|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFP6-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Loc|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFP6-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Loc|Gender=Fem|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFP6-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Loc|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFP7-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Ins|Gender=Fem|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFP7-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Ins|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFP7-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Ins|Gender=Fem|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFP7-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Ins|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFS1-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Nom|Gender=Fem|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFS1-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Nom|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFS1-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Nom|Gender=Fem|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFS1-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Nom|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFS2-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Gen|Gender=Fem|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFS2-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Gen|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFS2-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Gen|Gender=Fem|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFS2-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Gen|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFS3-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Dat|Gender=Fem|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFS3-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Dat|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFS3-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Dat|Gender=Fem|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFS3-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Dat|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFS4-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Acc|Gender=Fem|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFS4-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Acc|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFS4-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Acc|Gender=Fem|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFS4-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Acc|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFS5-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Voc|Gender=Fem|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFS5-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Voc|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFS5-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Voc|Gender=Fem|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFS5-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Voc|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFS6-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Loc|Gender=Fem|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFS6-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Loc|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFS6-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Loc|Gender=Fem|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFS6-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Loc|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFS7-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Ins|Gender=Fem|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFS7-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Ins|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFS7-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Ins|Gender=Fem|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGFS7-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Ins|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIP1-----A----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Nom|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIP1-----A---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Nom|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIP1-----N----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Nom|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIP1-----N---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Nom|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIP2-----A----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Gen|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIP2-----A---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Gen|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIP2-----N----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Gen|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIP2-----N---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Gen|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIP3-----A----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Dat|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIP3-----A---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Dat|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIP3-----N----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Dat|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIP3-----N---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Dat|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIP4-----A----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Acc|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIP4-----A---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Acc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIP4-----N----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Acc|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIP4-----N---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Acc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIP5-----A----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Voc|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIP5-----A---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Voc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIP5-----N----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Voc|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIP5-----N---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Voc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIP6-----A----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Loc|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIP6-----A---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Loc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIP6-----N----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Loc|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIP6-----N---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Loc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIP7-----A----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Ins|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIP7-----A---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Ins|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIP7-----N----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Ins|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIP7-----N---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Ins|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS1-----A----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Nom|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS1-----A---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Nom|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS1-----N----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Nom|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS1-----N---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Nom|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS2-----A----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Gen|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS2-----A---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Gen|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS2-----N----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Gen|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS2-----N---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Gen|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS3-----A----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Dat|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS3-----A---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Dat|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS3-----N----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Dat|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS3-----N---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Dat|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS4-----A----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Acc|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS4-----A---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Acc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS4-----N----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Acc|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS4-----N---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Acc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS5-----A----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Voc|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS5-----A---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Voc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS5-----N----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Voc|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS5-----N---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Voc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS6-----A----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Loc|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS6-----A---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Loc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS6-----A---7": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Loc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS6-----N----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Loc|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS6-----N---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Loc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS6-----N---7": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Loc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS7-----A----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Ins|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS7-----A---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Ins|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS7-----N----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Ins|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGIS7-----N---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Imp|Case=Ins|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMP1-----A----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Nom|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMP1-----A---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Nom|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMP1-----N----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Nom|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMP1-----N---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Nom|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMP2-----A----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Gen|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMP2-----A---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Gen|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMP2-----N----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Gen|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMP2-----N---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Gen|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMP3-----A----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Dat|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMP3-----A---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Dat|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMP3-----N----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Dat|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMP3-----N---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Dat|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMP4-----A----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Acc|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMP4-----A---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Acc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMP4-----N----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Acc|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMP4-----N---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Acc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMP5-----A----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Voc|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMP5-----A---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Voc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMP5-----N----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Voc|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMP5-----N---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Voc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMP6-----A----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Loc|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMP6-----A---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Loc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMP6-----N----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Loc|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMP6-----N---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Loc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMP7-----A----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Ins|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMP7-----A---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Ins|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMP7-----N----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Ins|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMP7-----N---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Ins|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS1-----A----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Nom|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS1-----A---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Nom|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS1-----N----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Nom|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS1-----N---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Nom|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS2-----A----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Gen|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS2-----A---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Gen|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS2-----N----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Gen|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS2-----N---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Gen|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS3-----A----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Dat|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS3-----A---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Dat|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS3-----N----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Dat|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS3-----N---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Dat|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS4-----A----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Acc|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS4-----A---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Acc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS4-----N----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Acc|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS4-----N---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Acc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS5-----A----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Voc|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS5-----A---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Voc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS5-----N----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Voc|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS5-----N---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Voc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS6-----A----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Loc|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS6-----A---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Loc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS6-----A---7": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Loc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS6-----N----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Loc|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS6-----N---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Loc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS6-----N---7": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Loc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS7-----A----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Ins|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS7-----A---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Ins|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS7-----N----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Ins|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGMS7-----N---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Imp|Case=Ins|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGND7-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Ins|Gender=Neut|Number=Dual|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGND7-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Ins|Gender=Neut|Number=Dual|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGND7-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Ins|Gender=Neut|Number=Dual|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGND7-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Ins|Gender=Neut|Number=Dual|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNP1-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Nom|Gender=Neut|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNP1-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Nom|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNP1-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Nom|Gender=Neut|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNP1-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Nom|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNP2-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Gen|Gender=Neut|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNP2-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Gen|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNP2-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Gen|Gender=Neut|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNP2-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Gen|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNP3-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Dat|Gender=Neut|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNP3-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Dat|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNP3-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Dat|Gender=Neut|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNP3-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Dat|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNP4-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Acc|Gender=Neut|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNP4-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Acc|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNP4-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Acc|Gender=Neut|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNP4-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Acc|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNP5-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Voc|Gender=Neut|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNP5-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Voc|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNP5-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Voc|Gender=Neut|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNP5-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Voc|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNP6-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Loc|Gender=Neut|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNP6-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Loc|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNP6-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Loc|Gender=Neut|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNP6-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Loc|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNP7-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Ins|Gender=Neut|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNP7-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Ins|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNP7-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Ins|Gender=Neut|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNP7-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Ins|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS1-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Nom|Gender=Neut|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS1-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Nom|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS1-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Nom|Gender=Neut|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS1-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Nom|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS2-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Gen|Gender=Neut|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS2-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Gen|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS2-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Gen|Gender=Neut|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS2-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Gen|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS3-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Dat|Gender=Neut|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS3-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Dat|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS3-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Dat|Gender=Neut|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS3-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Dat|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS4-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Acc|Gender=Neut|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS4-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Acc|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS4-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Acc|Gender=Neut|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS4-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Acc|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS5-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Voc|Gender=Neut|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS5-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Voc|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS5-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Voc|Gender=Neut|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS5-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Voc|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS6-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Loc|Gender=Neut|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS6-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Loc|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS6-----A---7": {POS: ADJ,"morph": "Aspect=Imp|Case=Loc|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS6-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Loc|Gender=Neut|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS6-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Loc|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS6-----N---7": {POS: ADJ,"morph": "Aspect=Imp|Case=Loc|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS7-----A----": {POS: ADJ,"morph": "Aspect=Imp|Case=Ins|Gender=Neut|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS7-----A---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Ins|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS7-----N----": {POS: ADJ,"morph": "Aspect=Imp|Case=Ins|Gender=Neut|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AGNS7-----N---6": {POS: ADJ,"morph": "Aspect=Imp|Case=Ins|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Part|Voice=Act"},
    "AMFD7-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Ins|Gender=Fem|Number=Dual|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFD7-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Ins|Gender=Fem|Number=Dual|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFD7-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Ins|Gender=Fem|Number=Dual|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFD7-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Ins|Gender=Fem|Number=Dual|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFP1-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Nom|Gender=Fem|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFP1-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Nom|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFP1-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Nom|Gender=Fem|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFP1-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Nom|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFP2-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Gen|Gender=Fem|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFP2-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Gen|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFP2-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Gen|Gender=Fem|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFP2-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Gen|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFP3-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Dat|Gender=Fem|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFP3-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Dat|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFP3-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Dat|Gender=Fem|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFP3-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Dat|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFP4-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Acc|Gender=Fem|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFP4-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Acc|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFP4-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Acc|Gender=Fem|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFP4-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Acc|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFP5-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Voc|Gender=Fem|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFP5-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Voc|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFP5-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Voc|Gender=Fem|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFP5-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Voc|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFP6-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Loc|Gender=Fem|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFP6-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Loc|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFP6-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Loc|Gender=Fem|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFP6-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Loc|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFP7-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Ins|Gender=Fem|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFP7-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Ins|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFP7-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Ins|Gender=Fem|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFP7-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Ins|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFS1-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Nom|Gender=Fem|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFS1-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Nom|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFS1-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Nom|Gender=Fem|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFS1-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Nom|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFS2-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Gen|Gender=Fem|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFS2-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Gen|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFS2-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Gen|Gender=Fem|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFS2-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Gen|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFS3-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Dat|Gender=Fem|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFS3-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Dat|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFS3-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Dat|Gender=Fem|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFS3-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Dat|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFS4-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Acc|Gender=Fem|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFS4-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Acc|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFS4-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Acc|Gender=Fem|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFS4-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Acc|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFS5-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Voc|Gender=Fem|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFS5-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Voc|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFS5-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Voc|Gender=Fem|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFS5-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Voc|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFS6-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Loc|Gender=Fem|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFS6-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Loc|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFS6-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Loc|Gender=Fem|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFS6-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Loc|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFS7-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Ins|Gender=Fem|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFS7-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Ins|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFS7-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Ins|Gender=Fem|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMFS7-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Ins|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIP1-----A----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Nom|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIP1-----A---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Nom|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIP1-----N----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Nom|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIP1-----N---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Nom|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIP2-----A----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Gen|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIP2-----A---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Gen|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIP2-----N----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Gen|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIP2-----N---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Gen|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIP3-----A----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Dat|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIP3-----A---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Dat|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIP3-----N----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Dat|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIP3-----N---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Dat|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIP4-----A----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Acc|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIP4-----A---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Acc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIP4-----N----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Acc|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIP4-----N---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Acc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIP5-----A----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Voc|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIP5-----A---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Voc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIP5-----N----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Voc|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIP5-----N---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Voc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIP6-----A----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Loc|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIP6-----A---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Loc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIP6-----N----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Loc|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIP6-----N---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Loc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIP7-----A----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Ins|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIP7-----A---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Ins|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIP7-----N----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Ins|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIP7-----N---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Ins|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS1-----A----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Nom|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS1-----A---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Nom|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS1-----N----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Nom|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS1-----N---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Nom|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS2-----A----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Gen|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS2-----A---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Gen|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS2-----N----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Gen|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS2-----N---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Gen|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS3-----A----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Dat|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS3-----A---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Dat|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS3-----N----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Dat|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS3-----N---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Dat|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS4-----A----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Acc|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS4-----A---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Acc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS4-----N----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Acc|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS4-----N---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Acc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS5-----A----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Voc|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS5-----A---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Voc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS5-----N----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Voc|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS5-----N---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Voc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS6-----A----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Loc|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS6-----A---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Loc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS6-----A---7": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Loc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS6-----N----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Loc|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS6-----N---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Loc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS6-----N---7": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Loc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS7-----A----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Ins|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS7-----A---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Ins|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS7-----N----": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Ins|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMIS7-----N---6": {POS: ADJ,"morph": "Animacy=Inan|Aspect=Perf|Case=Ins|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMP1-----A----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Nom|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMP1-----A---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Nom|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMP1-----N----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Nom|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMP1-----N---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Nom|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMP2-----A----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Gen|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMP2-----A---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Gen|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMP2-----N----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Gen|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMP2-----N---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Gen|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMP3-----A----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Dat|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMP3-----A---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Dat|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMP3-----N----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Dat|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMP3-----N---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Dat|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMP4-----A----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Acc|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMP4-----A---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Acc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMP4-----N----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Acc|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMP4-----N---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Acc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMP5-----A----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Voc|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMP5-----A---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Voc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMP5-----N----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Voc|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMP5-----N---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Voc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMP6-----A----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Loc|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMP6-----A---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Loc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMP6-----N----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Loc|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMP6-----N---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Loc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMP7-----A----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Ins|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMP7-----A---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Ins|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMP7-----N----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Ins|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMP7-----N---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Ins|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS1-----A----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Nom|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS1-----A---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Nom|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS1-----N----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Nom|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS1-----N---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Nom|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS2-----A----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Gen|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS2-----A---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Gen|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS2-----N----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Gen|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS2-----N---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Gen|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS3-----A----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Dat|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS3-----A---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Dat|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS3-----N----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Dat|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS3-----N---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Dat|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS4-----A----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Acc|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS4-----A---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Acc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS4-----N----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Acc|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS4-----N---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Acc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS5-----A----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Voc|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS5-----A---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Voc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS5-----N----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Voc|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS5-----N---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Voc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS6-----A----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Loc|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS6-----A---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Loc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS6-----A---7": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Loc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS6-----N----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Loc|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS6-----N---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Loc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS6-----N---7": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Loc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS7-----A----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Ins|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS7-----A---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Ins|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS7-----N----": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Ins|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMMS7-----N---6": {POS: ADJ,"morph": "Animacy=Anim|Aspect=Perf|Case=Ins|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMND7-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Ins|Gender=Neut|Number=Dual|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMND7-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Ins|Gender=Neut|Number=Dual|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMND7-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Ins|Gender=Neut|Number=Dual|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMND7-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Ins|Gender=Neut|Number=Dual|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNP1-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Nom|Gender=Neut|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNP1-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Nom|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNP1-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Nom|Gender=Neut|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNP1-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Nom|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNP2-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Gen|Gender=Neut|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNP2-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Gen|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNP2-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Gen|Gender=Neut|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNP2-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Gen|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNP3-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Dat|Gender=Neut|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNP3-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Dat|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNP3-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Dat|Gender=Neut|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNP3-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Dat|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNP4-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Acc|Gender=Neut|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNP4-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Acc|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNP4-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Acc|Gender=Neut|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNP4-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Acc|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNP5-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Voc|Gender=Neut|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNP5-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Voc|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNP5-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Voc|Gender=Neut|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNP5-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Voc|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNP6-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Loc|Gender=Neut|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNP6-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Loc|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNP6-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Loc|Gender=Neut|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNP6-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Loc|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNP7-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Ins|Gender=Neut|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNP7-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Ins|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNP7-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Ins|Gender=Neut|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNP7-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Ins|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS1-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Nom|Gender=Neut|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS1-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Nom|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS1-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Nom|Gender=Neut|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS1-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Nom|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS2-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Gen|Gender=Neut|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS2-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Gen|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS2-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Gen|Gender=Neut|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS2-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Gen|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS3-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Dat|Gender=Neut|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS3-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Dat|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS3-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Dat|Gender=Neut|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS3-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Dat|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS4-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Acc|Gender=Neut|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS4-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Acc|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS4-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Acc|Gender=Neut|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS4-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Acc|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS5-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Voc|Gender=Neut|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS5-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Voc|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS5-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Voc|Gender=Neut|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS5-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Voc|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS6-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Loc|Gender=Neut|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS6-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Loc|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS6-----A---7": {POS: ADJ,"morph": "Aspect=Perf|Case=Loc|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS6-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Loc|Gender=Neut|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS6-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Loc|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS6-----N---7": {POS: ADJ,"morph": "Aspect=Perf|Case=Loc|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS7-----A----": {POS: ADJ,"morph": "Aspect=Perf|Case=Ins|Gender=Neut|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS7-----A---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Ins|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS7-----N----": {POS: ADJ,"morph": "Aspect=Perf|Case=Ins|Gender=Neut|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "AMNS7-----N---6": {POS: ADJ,"morph": "Aspect=Perf|Case=Ins|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "AOFP-----------": {POS: ADJ, "morph": "Gender=Fem|Number=Plur"},
    "AOFP----------1": {POS: ADJ, "morph": "Gender=Fem|Number=Plur"},
    "AOFP----------6": {POS: ADJ, "morph": "Gender=Fem|Number=Plur|Style=Coll"},
    "AOFS-----------": {POS: ADJ, "morph": "Gender=Fem|Number=Sing"},
    "AOFS----------1": {POS: ADJ, "morph": "Gender=Fem|Number=Sing"},
    "AOIP-----------": {POS: ADJ, "morph": "Animacy=Inan|Gender=Masc|Number=Plur"},
    "AOIP----------1": {POS: ADJ, "morph": "Animacy=Inan|Gender=Masc|Number=Plur"},
    "AOIP----------6": {POS: ADJ, "morph": "Animacy=Inan|Gender=Masc|Number=Plur|Style=Coll"},
    "AOMP-----------": {POS: ADJ, "morph": "Animacy=Anim|Gender=Masc|Number=Plur"},
    "AOMP----------1": {POS: ADJ, "morph": "Animacy=Anim|Gender=Masc|Number=Plur"},
    "AOMP----------6": {POS: ADJ, "morph": "Animacy=Anim|Gender=Masc|Number=Plur|Style=Coll"},
    "AONP-----------": {POS: ADJ, "morph": "Gender=Neut|Number=Plur"},
    "AONP----------1": {POS: ADJ, "morph": "Gender=Neut|Number=Plur"},
    "AONP----------6": {POS: ADJ, "morph": "Gender=Neut|Number=Plur|Style=Coll"},
    "AONS-----------": {POS: ADJ, "morph": "Gender=Neut|Number=Sing"},
    "AONS----------1": {POS: ADJ, "morph": "Gender=Neut|Number=Sing"},
    "AONS----------6": {POS: ADJ, "morph": "Gender=Neut|Number=Sing|Style=Coll"},
    "AOYS-----------": {POS: ADJ, "morph": "Gender=Masc|Number=Sing"},
    "AOYS----------6": {POS: ADJ, "morph": "Gender=Masc|Number=Sing|Style=Coll"},
    "AUFD7F---------": {POS: ADJ, "morph": "Case=Ins|Gender=Fem|Gender[psor]=Fem|Number=Dual|Poss=Yes"},
    "AUFD7F--------6": {POS: ADJ, "morph": "Case=Ins|Gender=Fem|Gender[psor]=Fem|Number=Dual|Poss=Yes|Style=Coll"},
    "AUFD7M---------": {POS: ADJ, "morph": "Case=Ins|Gender=Fem|Gender[psor]=Masc|Number=Dual|Poss=Yes"},
    "AUFD7M--------6": {POS: ADJ, "morph": "Case=Ins|Gender=Fem|Gender[psor]=Masc|Number=Dual|Poss=Yes|Style=Coll"},
    "AUFP1F---------": {POS: ADJ, "morph": "Case=Nom|Gender=Fem|Gender[psor]=Fem|Number=Plur|Poss=Yes"},
    "AUFP1F--------6": {POS: ADJ, "morph": "Case=Nom|Gender=Fem|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUFP1M---------": {POS: ADJ, "morph": "Case=Nom|Gender=Fem|Gender[psor]=Masc|Number=Plur|Poss=Yes"},
    "AUFP1M--------5": {POS: ADJ, "morph": "Case=Nom|Gender=Fem|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUFP1M--------6": {POS: ADJ, "morph": "Case=Nom|Gender=Fem|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUFP2F---------": {POS: ADJ, "morph": "Case=Gen|Gender=Fem|Gender[psor]=Fem|Number=Plur|Poss=Yes"},
    "AUFP2F--------6": {POS: ADJ, "morph": "Case=Gen|Gender=Fem|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUFP2M---------": {POS: ADJ, "morph": "Case=Gen|Gender=Fem|Gender[psor]=Masc|Number=Plur|Poss=Yes"},
    "AUFP2M--------6": {POS: ADJ, "morph": "Case=Gen|Gender=Fem|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUFP3F---------": {POS: ADJ, "morph": "Case=Dat|Gender=Fem|Gender[psor]=Fem|Number=Plur|Poss=Yes"},
    "AUFP3F--------6": {POS: ADJ, "morph": "Case=Dat|Gender=Fem|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUFP3M---------": {POS: ADJ, "morph": "Case=Dat|Gender=Fem|Gender[psor]=Masc|Number=Plur|Poss=Yes"},
    "AUFP3M--------6": {POS: ADJ, "morph": "Case=Dat|Gender=Fem|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUFP4F---------": {POS: ADJ, "morph": "Case=Acc|Gender=Fem|Gender[psor]=Fem|Number=Plur|Poss=Yes"},
    "AUFP4F--------6": {POS: ADJ, "morph": "Case=Acc|Gender=Fem|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUFP4M---------": {POS: ADJ, "morph": "Case=Acc|Gender=Fem|Gender[psor]=Masc|Number=Plur|Poss=Yes"},
    "AUFP4M--------6": {POS: ADJ, "morph": "Case=Acc|Gender=Fem|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUFP5F---------": {POS: ADJ, "morph": "Case=Voc|Gender=Fem|Gender[psor]=Fem|Number=Plur|Poss=Yes"},
    "AUFP5F--------6": {POS: ADJ, "morph": "Case=Voc|Gender=Fem|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUFP5M---------": {POS: ADJ, "morph": "Case=Voc|Gender=Fem|Gender[psor]=Masc|Number=Plur|Poss=Yes"},
    "AUFP5M--------6": {POS: ADJ, "morph": "Case=Voc|Gender=Fem|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUFP6F---------": {POS: ADJ, "morph": "Case=Loc|Gender=Fem|Gender[psor]=Fem|Number=Plur|Poss=Yes"},
    "AUFP6F--------6": {POS: ADJ, "morph": "Case=Loc|Gender=Fem|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUFP6M---------": {POS: ADJ, "morph": "Case=Loc|Gender=Fem|Gender[psor]=Masc|Number=Plur|Poss=Yes"},
    "AUFP6M--------6": {POS: ADJ, "morph": "Case=Loc|Gender=Fem|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUFP7F---------": {POS: ADJ, "morph": "Case=Ins|Gender=Fem|Gender[psor]=Fem|Number=Plur|Poss=Yes"},
    "AUFP7F--------6": {POS: ADJ, "morph": "Case=Ins|Gender=Fem|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUFP7F--------7": {POS: ADJ, "morph": "Case=Ins|Gender=Fem|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUFP7M---------": {POS: ADJ, "morph": "Case=Ins|Gender=Fem|Gender[psor]=Masc|Number=Plur|Poss=Yes"},
    "AUFP7M--------6": {POS: ADJ, "morph": "Case=Ins|Gender=Fem|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUFP7M--------7": {POS: ADJ, "morph": "Case=Ins|Gender=Fem|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUFS1F---------": {POS: ADJ, "morph": "Case=Nom|Gender=Fem|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUFS1F--------6": {POS: ADJ, "morph": "Case=Nom|Gender=Fem|Gender[psor]=Fem|Number=Sing|Poss=Yes|Style=Coll"},
    "AUFS1M---------": {POS: ADJ, "morph": "Case=Nom|Gender=Fem|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUFS1M--------6": {POS: ADJ, "morph": "Case=Nom|Gender=Fem|Gender[psor]=Masc|Number=Sing|Poss=Yes|Style=Coll"},
    "AUFS2F---------": {POS: ADJ, "morph": "Case=Gen|Gender=Fem|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUFS2F--------6": {POS: ADJ, "morph": "Case=Gen|Gender=Fem|Gender[psor]=Fem|Number=Sing|Poss=Yes|Style=Coll"},
    "AUFS2M---------": {POS: ADJ, "morph": "Case=Gen|Gender=Fem|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUFS2M--------6": {POS: ADJ, "morph": "Case=Gen|Gender=Fem|Gender[psor]=Masc|Number=Sing|Poss=Yes|Style=Coll"},
    "AUFS3F---------": {POS: ADJ, "morph": "Case=Dat|Gender=Fem|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUFS3F--------6": {POS: ADJ, "morph": "Case=Dat|Gender=Fem|Gender[psor]=Fem|Number=Sing|Poss=Yes|Style=Coll"},
    "AUFS3M---------": {POS: ADJ, "morph": "Case=Dat|Gender=Fem|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUFS3M--------6": {POS: ADJ, "morph": "Case=Dat|Gender=Fem|Gender[psor]=Masc|Number=Sing|Poss=Yes|Style=Coll"},
    "AUFS4F---------": {POS: ADJ, "morph": "Case=Acc|Gender=Fem|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUFS4F--------6": {POS: ADJ, "morph": "Case=Acc|Gender=Fem|Gender[psor]=Fem|Number=Sing|Poss=Yes|Style=Coll"},
    "AUFS4M---------": {POS: ADJ, "morph": "Case=Acc|Gender=Fem|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUFS4M--------6": {POS: ADJ, "morph": "Case=Acc|Gender=Fem|Gender[psor]=Masc|Number=Sing|Poss=Yes|Style=Coll"},
    "AUFS5F---------": {POS: ADJ, "morph": "Case=Voc|Gender=Fem|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUFS5F--------6": {POS: ADJ, "morph": "Case=Voc|Gender=Fem|Gender[psor]=Fem|Number=Sing|Poss=Yes|Style=Coll"},
    "AUFS5M---------": {POS: ADJ, "morph": "Case=Voc|Gender=Fem|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUFS5M--------6": {POS: ADJ, "morph": "Case=Voc|Gender=Fem|Gender[psor]=Masc|Number=Sing|Poss=Yes|Style=Coll"},
    "AUFS6F---------": {POS: ADJ, "morph": "Case=Loc|Gender=Fem|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUFS6F--------6": {POS: ADJ, "morph": "Case=Loc|Gender=Fem|Gender[psor]=Fem|Number=Sing|Poss=Yes|Style=Coll"},
    "AUFS6M---------": {POS: ADJ, "morph": "Case=Loc|Gender=Fem|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUFS6M--------6": {POS: ADJ, "morph": "Case=Loc|Gender=Fem|Gender[psor]=Masc|Number=Sing|Poss=Yes|Style=Coll"},
    "AUFS7F---------": {POS: ADJ, "morph": "Case=Ins|Gender=Fem|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUFS7F--------6": {POS: ADJ, "morph": "Case=Ins|Gender=Fem|Gender[psor]=Fem|Number=Sing|Poss=Yes|Style=Coll"},
    "AUFS7M---------": {POS: ADJ, "morph": "Case=Ins|Gender=Fem|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUFS7M--------6": {POS: ADJ, "morph": "Case=Ins|Gender=Fem|Gender[psor]=Masc|Number=Sing|Poss=Yes|Style=Coll"},
    "AUIP1F---------": {POS: ADJ, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes"},
    "AUIP1F--------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Nom|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUIP1M---------": {POS: ADJ, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes"},
    "AUIP1M--------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Nom|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUIP2F---------": {POS: ADJ, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes"},
    "AUIP2F--------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Gen|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUIP2M---------": {POS: ADJ, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes"},
    "AUIP2M--------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Gen|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUIP3F---------": {POS: ADJ, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes"},
    "AUIP3F--------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Dat|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUIP3M---------": {POS: ADJ, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes"},
    "AUIP3M--------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Dat|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUIP4F---------": {POS: ADJ, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes"},
    "AUIP4F--------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Acc|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUIP4M---------": {POS: ADJ, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes"},
    "AUIP4M--------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Acc|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUIP5F---------": {POS: ADJ, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes"},
    "AUIP5F--------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Voc|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUIP5M---------": {POS: ADJ, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes"},
    "AUIP5M--------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Voc|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUIP6F---------": {POS: ADJ, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes"},
    "AUIP6F--------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Loc|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUIP6M---------": {POS: ADJ, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes"},
    "AUIP6M--------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Loc|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUIP7F---------": {POS: ADJ, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes"},
    "AUIP7F--------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUIP7F--------7": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUIP7M---------": {POS: ADJ, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes"},
    "AUIP7M--------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUIP7M--------7": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUIS1F---------": {POS: ADJ, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUIS1F--------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Nom|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes|Style=Coll"},
    "AUIS1M---------": {POS: ADJ, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUIS1M--------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Nom|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes|Style=Coll"},
    "AUIS2F---------": {POS: ADJ, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUIS2F--------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Gen|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes|Style=Coll"},
    "AUIS2M---------": {POS: ADJ, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUIS2M--------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Gen|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes|Style=Coll"},
    "AUIS3F---------": {POS: ADJ, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUIS3F--------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Dat|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes|Style=Coll"},
    "AUIS3M---------": {POS: ADJ, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUIS3M--------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Dat|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes|Style=Coll"},
    "AUIS4F---------": {POS: ADJ, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUIS4F--------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Acc|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes|Style=Coll"},
    "AUIS4M---------": {POS: ADJ, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUIS4M--------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Acc|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes|Style=Coll"},
    "AUIS5F---------": {POS: ADJ, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUIS5F--------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Voc|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes|Style=Coll"},
    "AUIS5M---------": {POS: ADJ, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUIS5M--------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Voc|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes|Style=Coll"},
    "AUIS6F---------": {POS: ADJ, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUIS6F--------1": {POS: ADJ, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUIS6F--------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Loc|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes|Style=Coll"},
    "AUIS6M---------": {POS: ADJ, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUIS6M--------1": {POS: ADJ, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUIS6M--------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Loc|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes|Style=Coll"},
    "AUIS7F---------": {POS: ADJ, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUIS7F--------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes|Style=Coll"},
    "AUIS7M---------": {POS: ADJ, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUIS7M--------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes|Style=Coll"},
    "AUMP1F---------": {POS: ADJ, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes"},
    "AUMP1F--------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Nom|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUMP1M---------": {POS: ADJ, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes"},
    "AUMP1M--------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Nom|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUMP2F---------": {POS: ADJ, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes"},
    "AUMP2F--------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Gen|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUMP2M---------": {POS: ADJ, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes"},
    "AUMP2M--------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Gen|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUMP3F---------": {POS: ADJ, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes"},
    "AUMP3F--------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Dat|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUMP3M---------": {POS: ADJ, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes"},
    "AUMP3M--------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Dat|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUMP4F---------": {POS: ADJ, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes"},
    "AUMP4F--------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Acc|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUMP4M---------": {POS: ADJ, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes"},
    "AUMP4M--------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Acc|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUMP5F---------": {POS: ADJ, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes"},
    "AUMP5F--------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Voc|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUMP5M---------": {POS: ADJ, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes"},
    "AUMP5M--------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Voc|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUMP6F---------": {POS: ADJ, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes"},
    "AUMP6F--------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Loc|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUMP6M---------": {POS: ADJ, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes"},
    "AUMP6M--------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Loc|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUMP7F---------": {POS: ADJ, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes"},
    "AUMP7F--------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Ins|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUMP7F--------7": {POS: ADJ,"morph": "Animacy=Anim|Case=Ins|Gender=Masc|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUMP7M---------": {POS: ADJ, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes"},
    "AUMP7M--------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Ins|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUMP7M--------7": {POS: ADJ,"morph": "Animacy=Anim|Case=Ins|Gender=Masc|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUMS1F---------": {POS: ADJ, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUMS1F--------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Nom|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes|Style=Coll"},
    "AUMS1M---------": {POS: ADJ, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUMS1M--------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Nom|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes|Style=Coll"},
    "AUMS2F---------": {POS: ADJ, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUMS2F--------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Gen|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes|Style=Coll"},
    "AUMS2M---------": {POS: ADJ, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUMS2M--------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Gen|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes|Style=Coll"},
    "AUMS3F---------": {POS: ADJ, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUMS3F--------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Dat|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes|Style=Coll"},
    "AUMS3M---------": {POS: ADJ, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUMS3M--------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Dat|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes|Style=Coll"},
    "AUMS4F---------": {POS: ADJ, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUMS4F--------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Acc|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes|Style=Coll"},
    "AUMS4M---------": {POS: ADJ, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUMS4M--------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Acc|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes|Style=Coll"},
    "AUMS5F---------": {POS: ADJ, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUMS5F--------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Voc|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes|Style=Coll"},
    "AUMS5M---------": {POS: ADJ, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUMS5M--------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Voc|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes|Style=Coll"},
    "AUMS6F---------": {POS: ADJ, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUMS6F--------1": {POS: ADJ, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUMS6F--------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Loc|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes|Style=Coll"},
    "AUMS6M---------": {POS: ADJ, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUMS6M--------1": {POS: ADJ, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUMS6M--------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Loc|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes|Style=Coll"},
    "AUMS7F---------": {POS: ADJ, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUMS7F--------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Ins|Gender=Masc|Gender[psor]=Fem|Number=Sing|Poss=Yes|Style=Coll"},
    "AUMS7M---------": {POS: ADJ, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUMS7M--------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Ins|Gender=Masc|Gender[psor]=Masc|Number=Sing|Poss=Yes|Style=Coll"},
    "AUND7F---------": {POS: ADJ, "morph": "Case=Ins|Gender=Neut|Gender[psor]=Fem|Number=Dual|Poss=Yes"},
    "AUND7F--------6": {POS: ADJ, "morph": "Case=Ins|Gender=Neut|Gender[psor]=Fem|Number=Dual|Poss=Yes|Style=Coll"},
    "AUND7M---------": {POS: ADJ, "morph": "Case=Ins|Gender=Neut|Gender[psor]=Masc|Number=Dual|Poss=Yes"},
    "AUND7M--------6": {POS: ADJ, "morph": "Case=Ins|Gender=Neut|Gender[psor]=Masc|Number=Dual|Poss=Yes|Style=Coll"},
    "AUNP1F---------": {POS: ADJ, "morph": "Case=Nom|Gender=Neut|Gender[psor]=Fem|Number=Plur|Poss=Yes"},
    "AUNP1F--------6": {POS: ADJ, "morph": "Case=Nom|Gender=Neut|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUNP1M---------": {POS: ADJ, "morph": "Case=Nom|Gender=Neut|Gender[psor]=Masc|Number=Plur|Poss=Yes"},
    "AUNP1M--------6": {POS: ADJ, "morph": "Case=Nom|Gender=Neut|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUNP2F---------": {POS: ADJ, "morph": "Case=Gen|Gender=Neut|Gender[psor]=Fem|Number=Plur|Poss=Yes"},
    "AUNP2F--------6": {POS: ADJ, "morph": "Case=Gen|Gender=Neut|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUNP2M---------": {POS: ADJ, "morph": "Case=Gen|Gender=Neut|Gender[psor]=Masc|Number=Plur|Poss=Yes"},
    "AUNP2M--------6": {POS: ADJ, "morph": "Case=Gen|Gender=Neut|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUNP3F---------": {POS: ADJ, "morph": "Case=Dat|Gender=Neut|Gender[psor]=Fem|Number=Plur|Poss=Yes"},
    "AUNP3F--------6": {POS: ADJ, "morph": "Case=Dat|Gender=Neut|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUNP3M---------": {POS: ADJ, "morph": "Case=Dat|Gender=Neut|Gender[psor]=Masc|Number=Plur|Poss=Yes"},
    "AUNP3M--------6": {POS: ADJ, "morph": "Case=Dat|Gender=Neut|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUNP4F---------": {POS: ADJ, "morph": "Case=Acc|Gender=Neut|Gender[psor]=Fem|Number=Plur|Poss=Yes"},
    "AUNP4F--------6": {POS: ADJ, "morph": "Case=Acc|Gender=Neut|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUNP4M---------": {POS: ADJ, "morph": "Case=Acc|Gender=Neut|Gender[psor]=Masc|Number=Plur|Poss=Yes"},
    "AUNP4M--------6": {POS: ADJ, "morph": "Case=Acc|Gender=Neut|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUNP5F---------": {POS: ADJ, "morph": "Case=Voc|Gender=Neut|Gender[psor]=Fem|Number=Plur|Poss=Yes"},
    "AUNP5F--------6": {POS: ADJ, "morph": "Case=Voc|Gender=Neut|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUNP5M---------": {POS: ADJ, "morph": "Case=Voc|Gender=Neut|Gender[psor]=Masc|Number=Plur|Poss=Yes"},
    "AUNP5M--------6": {POS: ADJ, "morph": "Case=Voc|Gender=Neut|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUNP6F---------": {POS: ADJ, "morph": "Case=Loc|Gender=Neut|Gender[psor]=Fem|Number=Plur|Poss=Yes"},
    "AUNP6F--------6": {POS: ADJ, "morph": "Case=Loc|Gender=Neut|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUNP6M---------": {POS: ADJ, "morph": "Case=Loc|Gender=Neut|Gender[psor]=Masc|Number=Plur|Poss=Yes"},
    "AUNP6M--------6": {POS: ADJ, "morph": "Case=Loc|Gender=Neut|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUNP7F---------": {POS: ADJ, "morph": "Case=Ins|Gender=Neut|Gender[psor]=Fem|Number=Plur|Poss=Yes"},
    "AUNP7F--------6": {POS: ADJ, "morph": "Case=Ins|Gender=Neut|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUNP7F--------7": {POS: ADJ, "morph": "Case=Ins|Gender=Neut|Gender[psor]=Fem|Number=Plur|Poss=Yes|Style=Coll"},
    "AUNP7M---------": {POS: ADJ, "morph": "Case=Ins|Gender=Neut|Gender[psor]=Masc|Number=Plur|Poss=Yes"},
    "AUNP7M--------6": {POS: ADJ, "morph": "Case=Ins|Gender=Neut|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUNP7M--------7": {POS: ADJ, "morph": "Case=Ins|Gender=Neut|Gender[psor]=Masc|Number=Plur|Poss=Yes|Style=Coll"},
    "AUNS1F---------": {POS: ADJ, "morph": "Case=Nom|Gender=Neut|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUNS1F--------6": {POS: ADJ, "morph": "Case=Nom|Gender=Neut|Gender[psor]=Fem|Number=Sing|Poss=Yes|Style=Coll"},
    "AUNS1M---------": {POS: ADJ, "morph": "Case=Nom|Gender=Neut|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUNS1M--------6": {POS: ADJ, "morph": "Case=Nom|Gender=Neut|Gender[psor]=Masc|Number=Sing|Poss=Yes|Style=Coll"},
    "AUNS2F---------": {POS: ADJ, "morph": "Case=Gen|Gender=Neut|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUNS2F--------6": {POS: ADJ, "morph": "Case=Gen|Gender=Neut|Gender[psor]=Fem|Number=Sing|Poss=Yes|Style=Coll"},
    "AUNS2M---------": {POS: ADJ, "morph": "Case=Gen|Gender=Neut|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUNS2M--------6": {POS: ADJ, "morph": "Case=Gen|Gender=Neut|Gender[psor]=Masc|Number=Sing|Poss=Yes|Style=Coll"},
    "AUNS3F---------": {POS: ADJ, "morph": "Case=Dat|Gender=Neut|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUNS3F--------6": {POS: ADJ, "morph": "Case=Dat|Gender=Neut|Gender[psor]=Fem|Number=Sing|Poss=Yes|Style=Coll"},
    "AUNS3M---------": {POS: ADJ, "morph": "Case=Dat|Gender=Neut|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUNS3M--------6": {POS: ADJ, "morph": "Case=Dat|Gender=Neut|Gender[psor]=Masc|Number=Sing|Poss=Yes|Style=Coll"},
    "AUNS4F---------": {POS: ADJ, "morph": "Case=Acc|Gender=Neut|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUNS4F--------6": {POS: ADJ, "morph": "Case=Acc|Gender=Neut|Gender[psor]=Fem|Number=Sing|Poss=Yes|Style=Coll"},
    "AUNS4M---------": {POS: ADJ, "morph": "Case=Acc|Gender=Neut|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUNS4M--------6": {POS: ADJ, "morph": "Case=Acc|Gender=Neut|Gender[psor]=Masc|Number=Sing|Poss=Yes|Style=Coll"},
    "AUNS5F---------": {POS: ADJ, "morph": "Case=Voc|Gender=Neut|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUNS5F--------6": {POS: ADJ, "morph": "Case=Voc|Gender=Neut|Gender[psor]=Fem|Number=Sing|Poss=Yes|Style=Coll"},
    "AUNS5M---------": {POS: ADJ, "morph": "Case=Voc|Gender=Neut|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUNS5M--------6": {POS: ADJ, "morph": "Case=Voc|Gender=Neut|Gender[psor]=Masc|Number=Sing|Poss=Yes|Style=Coll"},
    "AUNS6F---------": {POS: ADJ, "morph": "Case=Loc|Gender=Neut|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUNS6F--------1": {POS: ADJ, "morph": "Case=Loc|Gender=Neut|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUNS6F--------6": {POS: ADJ, "morph": "Case=Loc|Gender=Neut|Gender[psor]=Fem|Number=Sing|Poss=Yes|Style=Coll"},
    "AUNS6M---------": {POS: ADJ, "morph": "Case=Loc|Gender=Neut|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUNS6M--------1": {POS: ADJ, "morph": "Case=Loc|Gender=Neut|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUNS6M--------6": {POS: ADJ, "morph": "Case=Loc|Gender=Neut|Gender[psor]=Masc|Number=Sing|Poss=Yes|Style=Coll"},
    "AUNS7F---------": {POS: ADJ, "morph": "Case=Ins|Gender=Neut|Gender[psor]=Fem|Number=Sing|Poss=Yes"},
    "AUNS7F--------6": {POS: ADJ, "morph": "Case=Ins|Gender=Neut|Gender[psor]=Fem|Number=Sing|Poss=Yes|Style=Coll"},
    "AUNS7M---------": {POS: ADJ, "morph": "Case=Ins|Gender=Neut|Gender[psor]=Masc|Number=Sing|Poss=Yes"},
    "AUNS7M--------6": {POS: ADJ, "morph": "Case=Ins|Gender=Neut|Gender[psor]=Masc|Number=Sing|Poss=Yes|Style=Coll"},
    "AUXXXF--------8": {POS: ADJ, "morph": "Abbr=Yes|Gender[psor]=Fem|Poss=Yes"},
    "AUXXXM---------": {POS: ADJ, "morph": "Gender[psor]=Masc|Poss=Yes"},
    "AUXXXM--------6": {POS: ADJ, "morph": "Gender[psor]=Masc|Poss=Yes|Style=Coll"},
    "AUXXXM--------8": {POS: ADJ, "morph": "Abbr=Yes|Gender[psor]=Masc|Poss=Yes"},
    "C=-------------": {POS: NUM, "morph": "NumForm=Digit|NumType=Card"},
    "C}-------------": {POS: NUM, "morph": "NumForm=Roman|NumType=Card"},
    "C?--1----------": {POS: DET, "morph": "Case=Nom|NumType=Card|PronType=Int,Rel"},
    "C}------------1": {POS: NUM, "morph": "NumForm=Roman|NumType=Card"},
    "C?--2----------": {POS: DET, "morph": "Case=Gen|NumType=Card|PronType=Int,Rel"},
    "C}------------2": {POS: NUM, "morph": "NumForm=Roman|NumType=Card|Style=Arch"},
    "C?--3----------": {POS: DET, "morph": "Case=Dat|NumType=Card|PronType=Int,Rel"},
    "C3-------------": {POS: NUM, "morph": "Abbr=Yes"},
    "C?--4----------": {POS: DET, "morph": "Case=Acc|NumType=Card|PronType=Int,Rel"},
    "C?--6----------": {POS: DET, "morph": "Case=Loc|NumType=Card|PronType=Int,Rel"},
    "C?--7----------": {POS: DET, "morph": "Case=Ins|NumType=Card|PronType=Int,Rel"},
    "Ca--1----------": {POS: DET, "morph": "Case=Nom|NumType=Card|PronType=Dem,Ind"},
    "Ca--2----------": {POS: DET, "morph": "Case=Gen|NumType=Card|PronType=Dem,Ind"},
    "Ca--2---------1": {POS: DET, "morph": "Case=Gen|NumType=Card|PronType=Dem,Ind"},
    "Ca--3----------": {POS: DET, "morph": "Case=Dat|NumType=Card|PronType=Dem,Ind"},
    "Ca--4----------": {POS: DET, "morph": "Case=Acc|NumType=Card|PronType=Dem,Ind"},
    "Ca--5----------": {POS: DET, "morph": "Case=Voc|NumType=Card|PronType=Dem,Ind"},
    "Ca--6----------": {POS: DET, "morph": "Case=Loc|NumType=Card|PronType=Dem,Ind"},
    "Ca--7----------": {POS: DET, "morph": "Case=Ins|NumType=Card|PronType=Dem,Ind"},
    "Ca--X----------": {POS: DET, "morph": "NumType=Card|PronType=Dem,Ind"},
    "Ca--X---------8": {POS: DET, "morph": "Abbr=Yes|NumType=Card|PronType=Dem,Ind"},
    "CdFD7----------": {POS: ADJ, "morph": "Case=Ins|Gender=Fem|Number=Dual|NumType=Mult,Sets"},
    "CdFD7---------6": {POS: ADJ, "morph": "Case=Ins|Gender=Fem|Number=Dual|NumType=Mult,Sets|Style=Coll"},
    "CdFP1----------": {POS: ADJ, "morph": "Case=Nom|Gender=Fem|Number=Plur|NumType=Mult,Sets"},
    "CdFP1---------6": {POS: ADJ, "morph": "Case=Nom|Gender=Fem|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdFP2----------": {POS: ADJ, "morph": "Case=Gen|Gender=Fem|Number=Plur|NumType=Mult,Sets"},
    "CdFP2---------6": {POS: ADJ, "morph": "Case=Gen|Gender=Fem|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdFP3----------": {POS: ADJ, "morph": "Case=Dat|Gender=Fem|Number=Plur|NumType=Mult,Sets"},
    "CdFP3---------6": {POS: ADJ, "morph": "Case=Dat|Gender=Fem|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdFP4----------": {POS: ADJ, "morph": "Case=Acc|Gender=Fem|Number=Plur|NumType=Mult,Sets"},
    "CdFP4---------6": {POS: ADJ, "morph": "Case=Acc|Gender=Fem|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdFP5----------": {POS: ADJ, "morph": "Case=Voc|Gender=Fem|Number=Plur|NumType=Mult,Sets"},
    "CdFP5---------6": {POS: ADJ, "morph": "Case=Voc|Gender=Fem|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdFP6----------": {POS: ADJ, "morph": "Case=Loc|Gender=Fem|Number=Plur|NumType=Mult,Sets"},
    "CdFP6---------6": {POS: ADJ, "morph": "Case=Loc|Gender=Fem|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdFP7----------": {POS: ADJ, "morph": "Case=Ins|Gender=Fem|Number=Plur|NumType=Mult,Sets"},
    "CdFP7---------6": {POS: ADJ, "morph": "Case=Ins|Gender=Fem|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdFP7---------7": {POS: ADJ, "morph": "Case=Ins|Gender=Fem|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdFS1----------": {POS: ADJ, "morph": "Case=Nom|Gender=Fem|Number=Sing|NumType=Mult,Sets"},
    "CdFS2----------": {POS: ADJ, "morph": "Case=Gen|Gender=Fem|Number=Sing|NumType=Mult,Sets"},
    "CdFS2---------6": {POS: ADJ, "morph": "Case=Gen|Gender=Fem|Number=Sing|NumType=Mult,Sets|Style=Coll"},
    "CdFS3----------": {POS: ADJ, "morph": "Case=Dat|Gender=Fem|Number=Sing|NumType=Mult,Sets"},
    "CdFS3---------6": {POS: ADJ, "morph": "Case=Dat|Gender=Fem|Number=Sing|NumType=Mult,Sets|Style=Coll"},
    "CdFS4----------": {POS: ADJ, "morph": "Case=Acc|Gender=Fem|Number=Sing|NumType=Mult,Sets"},
    "CdFS4---------2": {POS: ADJ, "morph": "Case=Acc|Gender=Fem|Number=Sing|NumType=Mult,Sets|Style=Arch"},
    "CdFS5----------": {POS: ADJ, "morph": "Case=Voc|Gender=Fem|Number=Sing|NumType=Mult,Sets"},
    "CdFS6----------": {POS: ADJ, "morph": "Case=Loc|Gender=Fem|Number=Sing|NumType=Mult,Sets"},
    "CdFS6---------6": {POS: ADJ, "morph": "Case=Loc|Gender=Fem|Number=Sing|NumType=Mult,Sets|Style=Coll"},
    "CdFS7----------": {POS: ADJ, "morph": "Case=Ins|Gender=Fem|Number=Sing|NumType=Mult,Sets"},
    "CdIP1----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|NumType=Mult,Sets"},
    "CdIP1---------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdIP2----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Plur|NumType=Mult,Sets"},
    "CdIP2---------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdIP3----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Plur|NumType=Mult,Sets"},
    "CdIP3---------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdIP4----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Plur|NumType=Mult,Sets"},
    "CdIP4---------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdIP5----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|NumType=Mult,Sets"},
    "CdIP5---------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdIP6----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Plur|NumType=Mult,Sets"},
    "CdIP6---------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdIP7----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Plur|NumType=Mult,Sets"},
    "CdIP7---------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdIP7---------7": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdIS1----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Sing|NumType=Mult,Sets"},
    "CdIS1---------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Sing|NumType=Mult,Sets|Style=Coll"},
    "CdIS2----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Sing|NumType=Mult,Sets"},
    "CdIS2---------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Sing|NumType=Mult,Sets|Style=Coll"},
    "CdIS3----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Sing|NumType=Mult,Sets"},
    "CdIS3---------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Sing|NumType=Mult,Sets|Style=Coll"},
    "CdIS4----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|NumType=Mult,Sets"},
    "CdIS4---------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|NumType=Mult,Sets|Style=Coll"},
    "CdIS5----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Sing|NumType=Mult,Sets"},
    "CdIS5---------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Sing|NumType=Mult,Sets|Style=Coll"},
    "CdIS6----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Sing|NumType=Mult,Sets"},
    "CdIS6---------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Sing|NumType=Mult,Sets|Style=Coll"},
    "CdIS7----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Sing|NumType=Mult,Sets"},
    "CdIS7---------6": {POS: ADJ,"morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Sing|NumType=Mult,Sets|Style=Coll"},
    "CdMP1----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|NumType=Mult,Sets"},
    "CdMP1---------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdMP2----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Plur|NumType=Mult,Sets"},
    "CdMP2---------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdMP3----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Plur|NumType=Mult,Sets"},
    "CdMP3---------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdMP4----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Plur|NumType=Mult,Sets"},
    "CdMP4---------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdMP5----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|NumType=Mult,Sets"},
    "CdMP5---------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdMP6----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Plur|NumType=Mult,Sets"},
    "CdMP6---------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdMP7----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Plur|NumType=Mult,Sets"},
    "CdMP7---------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdMP7---------7": {POS: ADJ,"morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdMS1----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Sing|NumType=Mult,Sets"},
    "CdMS1---------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Sing|NumType=Mult,Sets|Style=Coll"},
    "CdMS2----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Sing|NumType=Mult,Sets"},
    "CdMS2---------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Sing|NumType=Mult,Sets|Style=Coll"},
    "CdMS3----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Sing|NumType=Mult,Sets"},
    "CdMS3---------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Sing|NumType=Mult,Sets|Style=Coll"},
    "CdMS4----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|NumType=Mult,Sets"},
    "CdMS4---------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|NumType=Mult,Sets|Style=Coll"},
    "CdMS5----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Sing|NumType=Mult,Sets"},
    "CdMS5---------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Sing|NumType=Mult,Sets|Style=Coll"},
    "CdMS6----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Sing|NumType=Mult,Sets"},
    "CdMS6---------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Sing|NumType=Mult,Sets|Style=Coll"},
    "CdMS7----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Sing|NumType=Mult,Sets"},
    "CdMS7---------6": {POS: ADJ,"morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Sing|NumType=Mult,Sets|Style=Coll"},
    "CdND7----------": {POS: ADJ, "morph": "Case=Ins|Gender=Neut|Number=Dual|NumType=Mult,Sets"},
    "CdNP1----------": {POS: ADJ, "morph": "Case=Nom|Gender=Neut|Number=Plur|NumType=Mult,Sets"},
    "CdNP1---------6": {POS: ADJ, "morph": "Case=Nom|Gender=Neut|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdNP2----------": {POS: ADJ, "morph": "Case=Gen|Gender=Neut|Number=Plur|NumType=Mult,Sets"},
    "CdNP2---------6": {POS: ADJ, "morph": "Case=Gen|Gender=Neut|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdNP3----------": {POS: ADJ, "morph": "Case=Dat|Gender=Neut|Number=Plur|NumType=Mult,Sets"},
    "CdNP3---------6": {POS: ADJ, "morph": "Case=Dat|Gender=Neut|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdNP4----------": {POS: ADJ, "morph": "Case=Acc|Gender=Neut|Number=Plur|NumType=Mult,Sets"},
    "CdNP4---------6": {POS: ADJ, "morph": "Case=Acc|Gender=Neut|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdNP5----------": {POS: ADJ, "morph": "Case=Voc|Gender=Neut|Number=Plur|NumType=Mult,Sets"},
    "CdNP5---------6": {POS: ADJ, "morph": "Case=Voc|Gender=Neut|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdNP6----------": {POS: ADJ, "morph": "Case=Loc|Gender=Neut|Number=Plur|NumType=Mult,Sets"},
    "CdNP6---------6": {POS: ADJ, "morph": "Case=Loc|Gender=Neut|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdNP7----------": {POS: ADJ, "morph": "Case=Ins|Gender=Neut|Number=Plur|NumType=Mult,Sets"},
    "CdNP7---------6": {POS: ADJ, "morph": "Case=Ins|Gender=Neut|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdNP7---------7": {POS: ADJ, "morph": "Case=Ins|Gender=Neut|Number=Plur|NumType=Mult,Sets|Style=Coll"},
    "CdNS1----------": {POS: ADJ, "morph": "Case=Nom|Gender=Neut|Number=Sing|NumType=Mult,Sets"},
    "CdNS1---------1": {POS: ADJ, "morph": "Case=Nom|Gender=Neut|Number=Sing|NumType=Mult,Sets"},
    "CdNS1---------6": {POS: ADJ, "morph": "Case=Nom|Gender=Neut|Number=Sing|NumType=Mult,Sets|Style=Coll"},
    "CdNS2----------": {POS: ADJ, "morph": "Case=Gen|Gender=Neut|Number=Sing|NumType=Mult,Sets"},
    "CdNS2---------6": {POS: ADJ, "morph": "Case=Gen|Gender=Neut|Number=Sing|NumType=Mult,Sets|Style=Coll"},
    "CdNS3----------": {POS: ADJ, "morph": "Case=Dat|Gender=Neut|Number=Sing|NumType=Mult,Sets"},
    "CdNS3---------6": {POS: ADJ, "morph": "Case=Dat|Gender=Neut|Number=Sing|NumType=Mult,Sets|Style=Coll"},
    "CdNS4----------": {POS: ADJ, "morph": "Case=Acc|Gender=Neut|Number=Sing|NumType=Mult,Sets"},
    "CdNS4---------1": {POS: ADJ, "morph": "Case=Acc|Gender=Neut|Number=Sing|NumType=Mult,Sets"},
    "CdNS4---------6": {POS: ADJ, "morph": "Case=Acc|Gender=Neut|Number=Sing|NumType=Mult,Sets|Style=Coll"},
    "CdNS5----------": {POS: ADJ, "morph": "Case=Voc|Gender=Neut|Number=Sing|NumType=Mult,Sets"},
    "CdNS5---------6": {POS: ADJ, "morph": "Case=Voc|Gender=Neut|Number=Sing|NumType=Mult,Sets|Style=Coll"},
    "CdNS6----------": {POS: ADJ, "morph": "Case=Loc|Gender=Neut|Number=Sing|NumType=Mult,Sets"},
    "CdNS6---------6": {POS: ADJ, "morph": "Case=Loc|Gender=Neut|Number=Sing|NumType=Mult,Sets|Style=Coll"},
    "CdNS7----------": {POS: ADJ, "morph": "Case=Ins|Gender=Neut|Number=Sing|NumType=Mult,Sets"},
    "CdNS7---------6": {POS: ADJ, "morph": "Case=Ins|Gender=Neut|Number=Sing|NumType=Mult,Sets|Style=Coll"},
    "CdXP1----------": {POS: ADJ, "morph": "Case=Nom|Number=Plur|NumType=Mult,Sets"},
    "CdXP1---------1": {POS: ADJ, "morph": "Case=Nom|Number=Plur|NumType=Mult,Sets"},
    "CdXP2----------": {POS: ADJ, "morph": "Case=Gen|Number=Plur|NumType=Mult,Sets"},
    "CdXP3----------": {POS: ADJ, "morph": "Case=Dat|Number=Plur|NumType=Mult,Sets"},
    "CdXP4----------": {POS: ADJ, "morph": "Case=Acc|Number=Plur|NumType=Mult,Sets"},
    "CdXP4---------1": {POS: ADJ, "morph": "Case=Acc|Number=Plur|NumType=Mult,Sets"},
    "CdXP5----------": {POS: ADJ, "morph": "Case=Voc|Number=Plur|NumType=Mult,Sets"},
    "CdXP5---------1": {POS: ADJ, "morph": "Case=Voc|Number=Plur|NumType=Mult,Sets"},
    "CdXP6----------": {POS: ADJ, "morph": "Case=Loc|Number=Plur|NumType=Mult,Sets"},
    "CdXP7----------": {POS: ADJ, "morph": "Case=Ins|Number=Plur|NumType=Mult,Sets"},
    "CdXS1----------": {POS: ADJ, "morph": "Case=Nom|Number=Sing|NumType=Mult,Sets"},
    "CdXS5----------": {POS: ADJ, "morph": "Case=Voc|Number=Sing|NumType=Mult,Sets"},
    "CdYS2----------": {POS: ADJ, "morph": "Case=Gen|Gender=Masc|Number=Sing|NumType=Mult,Sets"},
    "CdYS3----------": {POS: ADJ, "morph": "Case=Dat|Gender=Masc|Number=Sing|NumType=Mult,Sets"},
    "CdYS6----------": {POS: ADJ, "morph": "Case=Loc|Gender=Masc|Number=Sing|NumType=Mult,Sets"},
    "CdYS7----------": {POS: ADJ, "morph": "Case=Ins|Gender=Masc|Number=Sing|NumType=Mult,Sets"},
    "ChFD7----------": {POS: ADJ, "morph": "Case=Ins|Gender=Fem|Number=Dual|NumType=Sets|NumValue=1"},
    "ChFP1----------": {POS: ADJ, "morph": "Case=Nom|Gender=Fem|Number=Plur|NumType=Sets|NumValue=1"},
    "ChFP4----------": {POS: ADJ, "morph": "Case=Acc|Gender=Fem|Number=Plur|NumType=Sets|NumValue=1"},
    "ChFP5----------": {POS: ADJ, "morph": "Case=Voc|Gender=Fem|Number=Plur|NumType=Sets|NumValue=1"},
    "ChIP1----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|NumType=Sets|NumValue=1"},
    "ChIP5----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|NumType=Sets|NumValue=1"},
    "ChMP1----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|NumType=Sets|NumValue=1"},
    "ChMP5----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|NumType=Sets|NumValue=1"},
    "ChNP1----------": {POS: ADJ, "morph": "Case=Nom|Gender=Neut|Number=Plur|NumType=Sets|NumValue=1"},
    "ChNP4----------": {POS: ADJ, "morph": "Case=Acc|Gender=Neut|Number=Plur|NumType=Sets|NumValue=1"},
    "ChNP5----------": {POS: ADJ, "morph": "Case=Voc|Gender=Neut|Number=Plur|NumType=Sets|NumValue=1"},
    "ChXP2----------": {POS: ADJ, "morph": "Case=Gen|Number=Plur|NumType=Sets|NumValue=1"},
    "ChXP3----------": {POS: ADJ, "morph": "Case=Dat|Number=Plur|NumType=Sets|NumValue=1"},
    "ChXP6----------": {POS: ADJ, "morph": "Case=Loc|Number=Plur|NumType=Sets|NumValue=1"},
    "ChXP7----------": {POS: ADJ, "morph": "Case=Ins|Number=Plur|NumType=Sets|NumValue=1"},
    "ChYP4----------": {POS: ADJ, "morph": "Case=Acc|Gender=Masc|Number=Plur|NumType=Sets|NumValue=1"},
    "Cj-S1----------": {POS: NUM, "morph": "Case=Nom|Number=Sing|NumType=Card"},
    "Cj-S2----------": {POS: NUM, "morph": "Case=Gen|Number=Sing|NumType=Card"},
    "Cj-S2---------1": {POS: NUM, "morph": "Case=Gen|Number=Sing|NumType=Card"},
    "Cj-S3----------": {POS: NUM, "morph": "Case=Dat|Number=Sing|NumType=Card"},
    "Cj-S3---------1": {POS: NUM, "morph": "Case=Dat|Number=Sing|NumType=Card"},
    "Cj-S4----------": {POS: NUM, "morph": "Case=Acc|Number=Sing|NumType=Card"},
    "Cj-S5----------": {POS: NUM, "morph": "Case=Voc|Number=Sing|NumType=Card"},
    "Cj-S6----------": {POS: NUM, "morph": "Case=Loc|Number=Sing|NumType=Card"},
    "Cj-S6---------1": {POS: NUM, "morph": "Case=Loc|Number=Sing|NumType=Card"},
    "Cj-S7----------": {POS: NUM, "morph": "Case=Ins|Number=Sing|NumType=Card"},
    "Cj-S7---------1": {POS: NUM, "morph": "Case=Ins|Number=Sing|NumType=Card"},
    "Ck-P1----------": {POS: ADJ, "morph": "Case=Nom|Number=Plur|NumType=Ord"},
    "Ck-P2----------": {POS: ADJ, "morph": "Case=Gen|Number=Plur|NumType=Ord"},
    "Ck-P3----------": {POS: ADJ, "morph": "Case=Dat|Number=Plur|NumType=Ord"},
    "Ck-P4----------": {POS: ADJ, "morph": "Case=Acc|Number=Plur|NumType=Ord"},
    "Ck-P5----------": {POS: ADJ, "morph": "Case=Voc|Number=Plur|NumType=Ord"},
    "Ck-P6----------": {POS: ADJ, "morph": "Case=Loc|Number=Plur|NumType=Ord"},
    "Ck-P7----------": {POS: ADJ, "morph": "Case=Ins|Number=Plur|NumType=Ord"},
    "ClFD7----------": {POS: NUM, "morph": "Case=Ins|Gender=Fem|Number=Dual|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClFD7---------6": {POS: NUM,"morph": "Case=Ins|Gender=Fem|Number=Dual|NumForm=Word|NumType=Card|NumValue=1,2,3|Style=Coll"},
    "ClFD7---------9": {POS: NUM, "morph": "Case=Ins|Gender=Fem|Number=Dual|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClFS1----------": {POS: NUM, "morph": "Case=Nom|Gender=Fem|Number=Sing|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClFS2----------": {POS: NUM, "morph": "Case=Gen|Gender=Fem|Number=Sing|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClFS3----------": {POS: NUM, "morph": "Case=Dat|Gender=Fem|Number=Sing|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClFS4----------": {POS: NUM, "morph": "Case=Acc|Gender=Fem|Number=Sing|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClFS5----------": {POS: NUM, "morph": "Case=Voc|Gender=Fem|Number=Sing|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClFS6----------": {POS: NUM, "morph": "Case=Loc|Gender=Fem|Number=Sing|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClFS7----------": {POS: NUM, "morph": "Case=Ins|Gender=Fem|Number=Sing|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClHP1----------": {POS: NUM,"morph": "Case=Nom|Gender=Fem,Neut|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClHP4----------": {POS: NUM,"morph": "Case=Acc|Gender=Fem,Neut|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClHP5----------": {POS: NUM,"morph": "Case=Voc|Gender=Fem,Neut|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClIS4----------": {POS: NUM,"morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClMS4----------": {POS: NUM,"morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClNS1----------": {POS: NUM, "morph": "Case=Nom|Gender=Neut|Number=Sing|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClNS4----------": {POS: NUM, "morph": "Case=Acc|Gender=Neut|Number=Sing|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClNS5----------": {POS: NUM, "morph": "Case=Voc|Gender=Neut|Number=Sing|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClXP1----------": {POS: NUM, "morph": "Case=Nom|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClXP1---------6": {POS: NUM, "morph": "Case=Nom|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3|Style=Coll"},
    "ClXP2----------": {POS: NUM, "morph": "Case=Gen|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClXP2---------1": {POS: NUM, "morph": "Case=Gen|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClXP2---------6": {POS: NUM, "morph": "Case=Gen|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3|Style=Coll"},
    "ClXP3----------": {POS: NUM, "morph": "Case=Dat|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClXP3---------1": {POS: NUM, "morph": "Case=Dat|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClXP3---------2": {POS: NUM, "morph": "Case=Dat|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3|Style=Arch"},
    "ClXP3---------6": {POS: NUM, "morph": "Case=Dat|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3|Style=Coll"},
    "ClXP3---------9": {POS: NUM, "morph": "Case=Dat|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClXP4----------": {POS: NUM, "morph": "Case=Acc|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClXP4---------6": {POS: NUM, "morph": "Case=Acc|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3|Style=Coll"},
    "ClXP5----------": {POS: NUM, "morph": "Case=Voc|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClXP5---------6": {POS: NUM, "morph": "Case=Voc|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3|Style=Coll"},
    "ClXP6----------": {POS: NUM, "morph": "Case=Loc|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClXP6---------1": {POS: NUM, "morph": "Case=Loc|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClXP6---------2": {POS: NUM, "morph": "Case=Loc|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3|Style=Arch"},
    "ClXP6---------6": {POS: NUM, "morph": "Case=Loc|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3|Style=Coll"},
    "ClXP7----------": {POS: NUM, "morph": "Case=Ins|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClXP7---------1": {POS: NUM, "morph": "Case=Ins|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClXP7---------2": {POS: NUM, "morph": "Case=Ins|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3|Style=Arch"},
    "ClXP7---------6": {POS: NUM, "morph": "Case=Ins|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3|Style=Coll"},
    "ClXP7---------9": {POS: NUM, "morph": "Case=Ins|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClXPX----------": {POS: NUM, "morph": "Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClXS2----------": {POS: NUM, "morph": "Case=Gen|Number=Sing|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClXS3----------": {POS: NUM, "morph": "Case=Dat|Number=Sing|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClXS6----------": {POS: NUM, "morph": "Case=Loc|Number=Sing|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClXS7----------": {POS: NUM, "morph": "Case=Ins|Number=Sing|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClXSX----------": {POS: NUM, "morph": "Number=Sing|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClYP1----------": {POS: NUM, "morph": "Case=Nom|Gender=Masc|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClYP4----------": {POS: NUM, "morph": "Case=Acc|Gender=Masc|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClYP5----------": {POS: NUM, "morph": "Case=Voc|Gender=Masc|Number=Plur|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClYS1----------": {POS: NUM, "morph": "Case=Nom|Gender=Masc|Number=Sing|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClYS5----------": {POS: NUM, "morph": "Case=Voc|Gender=Masc|Number=Sing|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClZS2----------": {POS: NUM,"morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClZS3----------": {POS: NUM,"morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClZS6----------": {POS: NUM,"morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "ClZS7----------": {POS: NUM,"morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|NumForm=Word|NumType=Card|NumValue=1,2,3"},
    "Cn-P2----------": {POS: NUM, "morph": "Case=Gen|Number=Plur|NumForm=Word|NumType=Card"},
    "Cn-P2---------1": {POS: NUM, "morph": "Case=Gen|Number=Plur|NumForm=Word|NumType=Card"},
    "Cn-P3----------": {POS: NUM, "morph": "Case=Dat|Number=Plur|NumForm=Word|NumType=Card"},
    "Cn-P3---------1": {POS: NUM, "morph": "Case=Dat|Number=Plur|NumForm=Word|NumType=Card"},
    "Cn-P6----------": {POS: NUM, "morph": "Case=Loc|Number=Plur|NumForm=Word|NumType=Card"},
    "Cn-P6---------1": {POS: NUM, "morph": "Case=Loc|Number=Plur|NumForm=Word|NumType=Card"},
    "Cn-P7----------": {POS: NUM, "morph": "Case=Ins|Number=Plur|NumForm=Word|NumType=Card"},
    "Cn-P7---------1": {POS: NUM, "morph": "Case=Ins|Number=Plur|NumForm=Word|NumType=Card"},
    "Cn-S1----------": {POS: NUM, "morph": "Case=Nom|Number=Sing|NumForm=Word|NumType=Card"},
    "Cn-S1---------1": {POS: NUM, "morph": "Case=Nom|Number=Sing|NumForm=Word|NumType=Card"},
    "Cn-S2----------": {POS: NUM, "morph": "Case=Gen|Number=Sing|NumForm=Word|NumType=Card"},
    "Cn-S2---------1": {POS: NUM, "morph": "Case=Gen|Number=Sing|NumForm=Word|NumType=Card"},
    "Cn-S3----------": {POS: NUM, "morph": "Case=Dat|Number=Sing|NumForm=Word|NumType=Card"},
    "Cn-S3---------1": {POS: NUM, "morph": "Case=Dat|Number=Sing|NumForm=Word|NumType=Card"},
    "Cn-S4----------": {POS: NUM, "morph": "Case=Acc|Number=Sing|NumForm=Word|NumType=Card"},
    "Cn-S4---------1": {POS: NUM, "morph": "Case=Acc|Number=Sing|NumForm=Word|NumType=Card"},
    "Cn-S5----------": {POS: NUM, "morph": "Case=Voc|Number=Sing|NumForm=Word|NumType=Card"},
    "Cn-S5---------1": {POS: NUM, "morph": "Case=Voc|Number=Sing|NumForm=Word|NumType=Card"},
    "Cn-S6----------": {POS: NUM, "morph": "Case=Loc|Number=Sing|NumForm=Word|NumType=Card"},
    "Cn-S6---------1": {POS: NUM, "morph": "Case=Loc|Number=Sing|NumForm=Word|NumType=Card"},
    "Cn-S7----------": {POS: NUM, "morph": "Case=Ins|Number=Sing|NumForm=Word|NumType=Card"},
    "Cn-S7---------1": {POS: NUM, "morph": "Case=Ins|Number=Sing|NumForm=Word|NumType=Card"},
    "Cn-SX----------": {POS: NUM, "morph": "Number=Sing|NumForm=Word|NumType=Card"},
    "Cn-XX----------": {POS: NUM, "morph": "NumForm=Word|NumType=Card"},
    "Co-------------": {POS: ADV, "morph": "NumType=Mult|PronType=Dem,Ind"},
    "Co------------1": {POS: ADV, "morph": "NumType=Mult|PronType=Dem,Ind"},
    "CrFD7----------": {POS: ADJ, "morph": "Case=Ins|Gender=Fem|Number=Dual|NumType=Ord"},
    "CrFD7---------6": {POS: ADJ, "morph": "Case=Ins|Gender=Fem|Number=Dual|NumType=Ord|Style=Coll"},
    "CrFP1----------": {POS: ADJ, "morph": "Case=Nom|Gender=Fem|Number=Plur|NumType=Ord"},
    "CrFP1---------6": {POS: ADJ, "morph": "Case=Nom|Gender=Fem|Number=Plur|NumType=Ord|Style=Coll"},
    "CrFP2----------": {POS: ADJ, "morph": "Case=Gen|Gender=Fem|Number=Plur|NumType=Ord"},
    "CrFP2---------6": {POS: ADJ, "morph": "Case=Gen|Gender=Fem|Number=Plur|NumType=Ord|Style=Coll"},
    "CrFP3----------": {POS: ADJ, "morph": "Case=Dat|Gender=Fem|Number=Plur|NumType=Ord"},
    "CrFP3---------6": {POS: ADJ, "morph": "Case=Dat|Gender=Fem|Number=Plur|NumType=Ord|Style=Coll"},
    "CrFP4----------": {POS: ADJ, "morph": "Case=Acc|Gender=Fem|Number=Plur|NumType=Ord"},
    "CrFP4---------6": {POS: ADJ, "morph": "Case=Acc|Gender=Fem|Number=Plur|NumType=Ord|Style=Coll"},
    "CrFP5----------": {POS: ADJ, "morph": "Case=Voc|Gender=Fem|Number=Plur|NumType=Ord"},
    "CrFP5---------6": {POS: ADJ, "morph": "Case=Voc|Gender=Fem|Number=Plur|NumType=Ord|Style=Coll"},
    "CrFP6----------": {POS: ADJ, "morph": "Case=Loc|Gender=Fem|Number=Plur|NumType=Ord"},
    "CrFP6---------6": {POS: ADJ, "morph": "Case=Loc|Gender=Fem|Number=Plur|NumType=Ord|Style=Coll"},
    "CrFP7----------": {POS: ADJ, "morph": "Case=Ins|Gender=Fem|Number=Plur|NumType=Ord"},
    "CrFP7---------6": {POS: ADJ, "morph": "Case=Ins|Gender=Fem|Number=Plur|NumType=Ord|Style=Coll"},
    "CrFP7---------7": {POS: ADJ, "morph": "Case=Ins|Gender=Fem|Number=Plur|NumType=Ord|Style=Coll"},
    "CrFS1----------": {POS: ADJ, "morph": "Case=Nom|Gender=Fem|Number=Sing|NumType=Ord"},
    "CrFS2----------": {POS: ADJ, "morph": "Case=Gen|Gender=Fem|Number=Sing|NumType=Ord"},
    "CrFS2---------6": {POS: ADJ, "morph": "Case=Gen|Gender=Fem|Number=Sing|NumType=Ord|Style=Coll"},
    "CrFS3----------": {POS: ADJ, "morph": "Case=Dat|Gender=Fem|Number=Sing|NumType=Ord"},
    "CrFS3---------6": {POS: ADJ, "morph": "Case=Dat|Gender=Fem|Number=Sing|NumType=Ord|Style=Coll"},
    "CrFS4----------": {POS: ADJ, "morph": "Case=Acc|Gender=Fem|Number=Sing|NumType=Ord"},
    "CrFS5----------": {POS: ADJ, "morph": "Case=Voc|Gender=Fem|Number=Sing|NumType=Ord"},
    "CrFS6----------": {POS: ADJ, "morph": "Case=Loc|Gender=Fem|Number=Sing|NumType=Ord"},
    "CrFS6---------6": {POS: ADJ, "morph": "Case=Loc|Gender=Fem|Number=Sing|NumType=Ord|Style=Coll"},
    "CrFS7----------": {POS: ADJ, "morph": "Case=Ins|Gender=Fem|Number=Sing|NumType=Ord"},
    "CrIP1----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|NumType=Ord"},
    "CrIP1---------6": {POS: ADJ, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|NumType=Ord|Style=Coll"},
    "CrIP2----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Plur|NumType=Ord"},
    "CrIP2---------6": {POS: ADJ, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Plur|NumType=Ord|Style=Coll"},
    "CrIP3----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Plur|NumType=Ord"},
    "CrIP3---------6": {POS: ADJ, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Plur|NumType=Ord|Style=Coll"},
    "CrIP4----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Plur|NumType=Ord"},
    "CrIP4---------6": {POS: ADJ, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Plur|NumType=Ord|Style=Coll"},
    "CrIP5----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|NumType=Ord"},
    "CrIP5---------6": {POS: ADJ, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|NumType=Ord|Style=Coll"},
    "CrIP6----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Plur|NumType=Ord"},
    "CrIP6---------6": {POS: ADJ, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Plur|NumType=Ord|Style=Coll"},
    "CrIP7----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Plur|NumType=Ord"},
    "CrIP7---------6": {POS: ADJ, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Plur|NumType=Ord|Style=Coll"},
    "CrIP7---------7": {POS: ADJ, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Plur|NumType=Ord|Style=Coll"},
    "CrIS1----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Sing|NumType=Ord"},
    "CrIS1---------6": {POS: ADJ, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Sing|NumType=Ord|Style=Coll"},
    "CrIS2----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Sing|NumType=Ord"},
    "CrIS2---------6": {POS: ADJ, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Sing|NumType=Ord|Style=Coll"},
    "CrIS3----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Sing|NumType=Ord"},
    "CrIS3---------6": {POS: ADJ, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Sing|NumType=Ord|Style=Coll"},
    "CrIS4----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|NumType=Ord"},
    "CrIS4---------6": {POS: ADJ, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|NumType=Ord|Style=Coll"},
    "CrIS5----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Sing|NumType=Ord"},
    "CrIS5---------6": {POS: ADJ, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Sing|NumType=Ord|Style=Coll"},
    "CrIS6----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Sing|NumType=Ord"},
    "CrIS6---------6": {POS: ADJ, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Sing|NumType=Ord|Style=Coll"},
    "CrIS6---------7": {POS: ADJ, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Sing|NumType=Ord|Style=Coll"},
    "CrIS7----------": {POS: ADJ, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Sing|NumType=Ord"},
    "CrIS7---------6": {POS: ADJ, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Sing|NumType=Ord|Style=Coll"},
    "CrMP1----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|NumType=Ord"},
    "CrMP1---------6": {POS: ADJ, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|NumType=Ord|Style=Coll"},
    "CrMP2----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Plur|NumType=Ord"},
    "CrMP2---------6": {POS: ADJ, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Plur|NumType=Ord|Style=Coll"},
    "CrMP3----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Plur|NumType=Ord"},
    "CrMP3---------6": {POS: ADJ, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Plur|NumType=Ord|Style=Coll"},
    "CrMP4----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Plur|NumType=Ord"},
    "CrMP4---------6": {POS: ADJ, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Plur|NumType=Ord|Style=Coll"},
    "CrMP5----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|NumType=Ord"},
    "CrMP5---------6": {POS: ADJ, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|NumType=Ord|Style=Coll"},
    "CrMP6----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Plur|NumType=Ord"},
    "CrMP6---------6": {POS: ADJ, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Plur|NumType=Ord|Style=Coll"},
    "CrMP7----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Plur|NumType=Ord"},
    "CrMP7---------6": {POS: ADJ, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Plur|NumType=Ord|Style=Coll"},
    "CrMP7---------7": {POS: ADJ, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Plur|NumType=Ord|Style=Coll"},
    "CrMS1----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Sing|NumType=Ord"},
    "CrMS1---------6": {POS: ADJ, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Sing|NumType=Ord|Style=Coll"},
    "CrMS2----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Sing|NumType=Ord"},
    "CrMS2---------6": {POS: ADJ, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Sing|NumType=Ord|Style=Coll"},
    "CrMS3----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Sing|NumType=Ord"},
    "CrMS3---------6": {POS: ADJ, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Sing|NumType=Ord|Style=Coll"},
    "CrMS4----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|NumType=Ord"},
    "CrMS4---------6": {POS: ADJ, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|NumType=Ord|Style=Coll"},
    "CrMS5----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Sing|NumType=Ord"},
    "CrMS5---------6": {POS: ADJ, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Sing|NumType=Ord|Style=Coll"},
    "CrMS6----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Sing|NumType=Ord"},
    "CrMS6---------6": {POS: ADJ, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Sing|NumType=Ord|Style=Coll"},
    "CrMS6---------7": {POS: ADJ, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Sing|NumType=Ord|Style=Coll"},
    "CrMS7----------": {POS: ADJ, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Sing|NumType=Ord"},
    "CrMS7---------6": {POS: ADJ, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Sing|NumType=Ord|Style=Coll"},
    "CrND7----------": {POS: ADJ, "morph": "Case=Ins|Gender=Neut|Number=Dual|NumType=Ord"},
    "CrNP1----------": {POS: ADJ, "morph": "Case=Nom|Gender=Neut|Number=Plur|NumType=Ord"},
    "CrNP1---------6": {POS: ADJ, "morph": "Case=Nom|Gender=Neut|Number=Plur|NumType=Ord|Style=Coll"},
    "CrNP2----------": {POS: ADJ, "morph": "Case=Gen|Gender=Neut|Number=Plur|NumType=Ord"},
    "CrNP2---------6": {POS: ADJ, "morph": "Case=Gen|Gender=Neut|Number=Plur|NumType=Ord|Style=Coll"},
    "CrNP3----------": {POS: ADJ, "morph": "Case=Dat|Gender=Neut|Number=Plur|NumType=Ord"},
    "CrNP3---------6": {POS: ADJ, "morph": "Case=Dat|Gender=Neut|Number=Plur|NumType=Ord|Style=Coll"},
    "CrNP4----------": {POS: ADJ, "morph": "Case=Acc|Gender=Neut|Number=Plur|NumType=Ord"},
    "CrNP4---------6": {POS: ADJ, "morph": "Case=Acc|Gender=Neut|Number=Plur|NumType=Ord|Style=Coll"},
    "CrNP5----------": {POS: ADJ, "morph": "Case=Voc|Gender=Neut|Number=Plur|NumType=Ord"},
    "CrNP5---------6": {POS: ADJ, "morph": "Case=Voc|Gender=Neut|Number=Plur|NumType=Ord|Style=Coll"},
    "CrNP6----------": {POS: ADJ, "morph": "Case=Loc|Gender=Neut|Number=Plur|NumType=Ord"},
    "CrNP6---------6": {POS: ADJ, "morph": "Case=Loc|Gender=Neut|Number=Plur|NumType=Ord|Style=Coll"},
    "CrNP7----------": {POS: ADJ, "morph": "Case=Ins|Gender=Neut|Number=Plur|NumType=Ord"},
    "CrNP7---------6": {POS: ADJ, "morph": "Case=Ins|Gender=Neut|Number=Plur|NumType=Ord|Style=Coll"},
    "CrNP7---------7": {POS: ADJ, "morph": "Case=Ins|Gender=Neut|Number=Plur|NumType=Ord|Style=Coll"},
    "CrNS1----------": {POS: ADJ, "morph": "Case=Nom|Gender=Neut|Number=Sing|NumType=Ord"},
    "CrNS1---------6": {POS: ADJ, "morph": "Case=Nom|Gender=Neut|Number=Sing|NumType=Ord|Style=Coll"},
    "CrNS2----------": {POS: ADJ, "morph": "Case=Gen|Gender=Neut|Number=Sing|NumType=Ord"},
    "CrNS2---------6": {POS: ADJ, "morph": "Case=Gen|Gender=Neut|Number=Sing|NumType=Ord|Style=Coll"},
    "CrNS3----------": {POS: ADJ, "morph": "Case=Dat|Gender=Neut|Number=Sing|NumType=Ord"},
    "CrNS3---------6": {POS: ADJ, "morph": "Case=Dat|Gender=Neut|Number=Sing|NumType=Ord|Style=Coll"},
    "CrNS4----------": {POS: ADJ, "morph": "Case=Acc|Gender=Neut|Number=Sing|NumType=Ord"},
    "CrNS4---------6": {POS: ADJ, "morph": "Case=Acc|Gender=Neut|Number=Sing|NumType=Ord|Style=Coll"},
    "CrNS5----------": {POS: ADJ, "morph": "Case=Voc|Gender=Neut|Number=Sing|NumType=Ord"},
    "CrNS5---------6": {POS: ADJ, "morph": "Case=Voc|Gender=Neut|Number=Sing|NumType=Ord|Style=Coll"},
    "CrNS6----------": {POS: ADJ, "morph": "Case=Loc|Gender=Neut|Number=Sing|NumType=Ord"},
    "CrNS6---------6": {POS: ADJ, "morph": "Case=Loc|Gender=Neut|Number=Sing|NumType=Ord|Style=Coll"},
    "CrNS6---------7": {POS: ADJ, "morph": "Case=Loc|Gender=Neut|Number=Sing|NumType=Ord|Style=Coll"},
    "CrNS7----------": {POS: ADJ, "morph": "Case=Ins|Gender=Neut|Number=Sing|NumType=Ord"},
    "CrNS7---------6": {POS: ADJ, "morph": "Case=Ins|Gender=Neut|Number=Sing|NumType=Ord|Style=Coll"},
    "CrXXX----------": {POS: ADJ, "morph": "NumType=Ord"},
    "Cu-------------": {POS: ADV, "morph": "NumType=Mult|PronType=Int,Rel"},
    "Cv-------------": {POS: ADV, "morph": "NumType=Mult"},
    "Cv------------1": {POS: ADV, "morph": "NumType=Mult"},
    "Cv------------6": {POS: ADV, "morph": "NumType=Mult|Style=Coll"},
    "CwFD7----------": {POS: DET, "morph": "Case=Ins|Gender=Fem|Number=Dual|NumType=Ord|PronType=Dem,Ind"},
    "CwFP1----------": {POS: DET, "morph": "Case=Nom|Gender=Fem|Number=Plur|NumType=Ord|PronType=Dem,Ind"},
    "CwFP4----------": {POS: DET, "morph": "Case=Acc|Gender=Fem|Number=Plur|NumType=Ord|PronType=Dem,Ind"},
    "CwFP5----------": {POS: DET, "morph": "Case=Voc|Gender=Fem|Number=Plur|NumType=Ord|PronType=Dem,Ind"},
    "CwFS1----------": {POS: DET, "morph": "Case=Nom|Gender=Fem|Number=Sing|NumType=Ord|PronType=Dem,Ind"},
    "CwFS2----------": {POS: DET, "morph": "Case=Gen|Gender=Fem|Number=Sing|NumType=Ord|PronType=Dem,Ind"},
    "CwFS3----------": {POS: DET, "morph": "Case=Dat|Gender=Fem|Number=Sing|NumType=Ord|PronType=Dem,Ind"},
    "CwFS4----------": {POS: DET, "morph": "Case=Acc|Gender=Fem|Number=Sing|NumType=Ord|PronType=Dem,Ind"},
    "CwFS5----------": {POS: DET, "morph": "Case=Voc|Gender=Fem|Number=Sing|NumType=Ord|PronType=Dem,Ind"},
    "CwFS6----------": {POS: DET, "morph": "Case=Loc|Gender=Fem|Number=Sing|NumType=Ord|PronType=Dem,Ind"},
    "CwFS7----------": {POS: DET, "morph": "Case=Ins|Gender=Fem|Number=Sing|NumType=Ord|PronType=Dem,Ind"},
    "CwIP1----------": {POS: DET,"morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|NumType=Ord|PronType=Dem,Ind"},
    "CwIP5----------": {POS: DET,"morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|NumType=Ord|PronType=Dem,Ind"},
    "CwIS4----------": {POS: DET,"morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|NumType=Ord|PronType=Dem,Ind"},
    "CwMP1----------": {POS: DET,"morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|NumType=Ord|PronType=Dem,Ind"},
    "CwMP5----------": {POS: DET,"morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|NumType=Ord|PronType=Dem,Ind"},
    "CwMS4----------": {POS: DET,"morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|NumType=Ord|PronType=Dem,Ind"},
    "CwNP1----------": {POS: DET, "morph": "Case=Nom|Gender=Neut|Number=Plur|NumType=Ord|PronType=Dem,Ind"},
    "CwNP4----------": {POS: DET, "morph": "Case=Acc|Gender=Neut|Number=Plur|NumType=Ord|PronType=Dem,Ind"},
    "CwNP5----------": {POS: DET, "morph": "Case=Voc|Gender=Neut|Number=Plur|NumType=Ord|PronType=Dem,Ind"},
    "CwNS1----------": {POS: DET, "morph": "Case=Nom|Gender=Neut|Number=Sing|NumType=Ord|PronType=Dem,Ind"},
    "CwNS4----------": {POS: DET, "morph": "Case=Acc|Gender=Neut|Number=Sing|NumType=Ord|PronType=Dem,Ind"},
    "CwNS5----------": {POS: DET, "morph": "Case=Voc|Gender=Neut|Number=Sing|NumType=Ord|PronType=Dem,Ind"},
    "CwXP2----------": {POS: DET, "morph": "Case=Gen|Number=Plur|NumType=Ord|PronType=Dem,Ind"},
    "CwXP3----------": {POS: DET, "morph": "Case=Dat|Number=Plur|NumType=Ord|PronType=Dem,Ind"},
    "CwXP6----------": {POS: DET, "morph": "Case=Loc|Number=Plur|NumType=Ord|PronType=Dem,Ind"},
    "CwXP7----------": {POS: DET, "morph": "Case=Ins|Number=Plur|NumType=Ord|PronType=Dem,Ind"},
    "CwYP4----------": {POS: DET, "morph": "Case=Acc|Gender=Masc|Number=Plur|NumType=Ord|PronType=Dem,Ind"},
    "CwYS1----------": {POS: DET, "morph": "Case=Nom|Gender=Masc|Number=Sing|NumType=Ord|PronType=Dem,Ind"},
    "CwYS5----------": {POS: DET, "morph": "Case=Voc|Gender=Masc|Number=Sing|NumType=Ord|PronType=Dem,Ind"},
    "CwZS2----------": {POS: DET, "morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|NumType=Ord|PronType=Dem,Ind"},
    "CwZS3----------": {POS: DET, "morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|NumType=Ord|PronType=Dem,Ind"},
    "CwZS6----------": {POS: DET, "morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|NumType=Ord|PronType=Dem,Ind"},
    "CwZS7----------": {POS: DET, "morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|NumType=Ord|PronType=Dem,Ind"},
    "CyFP1----------": {POS: NUM, "morph": "Case=Nom|Gender=Fem|Number=Plur|NumType=Frac"},
    "CyFP2----------": {POS: NUM, "morph": "Case=Gen|Gender=Fem|Number=Plur|NumType=Frac"},
    "CyFP3----------": {POS: NUM, "morph": "Case=Dat|Gender=Fem|Number=Plur|NumType=Frac"},
    "CyFP4----------": {POS: NUM, "morph": "Case=Acc|Gender=Fem|Number=Plur|NumType=Frac"},
    "CyFP5----------": {POS: NUM, "morph": "Case=Voc|Gender=Fem|Number=Plur|NumType=Frac"},
    "CyFP6----------": {POS: NUM, "morph": "Case=Loc|Gender=Fem|Number=Plur|NumType=Frac"},
    "CyFP7----------": {POS: NUM, "morph": "Case=Ins|Gender=Fem|Number=Plur|NumType=Frac"},
    "CyFP7---------6": {POS: NUM, "morph": "Case=Ins|Gender=Fem|Number=Plur|NumType=Frac|Style=Coll"},
    "CyFS1----------": {POS: NUM, "morph": "Case=Nom|Gender=Fem|Number=Sing|NumType=Frac"},
    "CyFS2----------": {POS: NUM, "morph": "Case=Gen|Gender=Fem|Number=Sing|NumType=Frac"},
    "CyFS3----------": {POS: NUM, "morph": "Case=Dat|Gender=Fem|Number=Sing|NumType=Frac"},
    "CyFS4----------": {POS: NUM, "morph": "Case=Acc|Gender=Fem|Number=Sing|NumType=Frac"},
    "CyFS5----------": {POS: NUM, "morph": "Case=Voc|Gender=Fem|Number=Sing|NumType=Frac"},
    "CyFS6----------": {POS: NUM, "morph": "Case=Loc|Gender=Fem|Number=Sing|NumType=Frac"},
    "CyFS7----------": {POS: NUM, "morph": "Case=Ins|Gender=Fem|Number=Sing|NumType=Frac"},
    "CzFD7----------": {POS: DET, "morph": "Case=Ins|Gender=Fem|Number=Dual|NumType=Ord|PronType=Int,Rel"},
    "CzFP1----------": {POS: DET, "morph": "Case=Nom|Gender=Fem|Number=Plur|NumType=Ord|PronType=Int,Rel"},
    "CzFP4----------": {POS: DET, "morph": "Case=Acc|Gender=Fem|Number=Plur|NumType=Ord|PronType=Int,Rel"},
    "CzFS1----------": {POS: DET, "morph": "Case=Nom|Gender=Fem|Number=Sing|NumType=Ord|PronType=Int,Rel"},
    "CzFS2----------": {POS: DET, "morph": "Case=Gen|Gender=Fem|Number=Sing|NumType=Ord|PronType=Int,Rel"},
    "CzFS3----------": {POS: DET, "morph": "Case=Dat|Gender=Fem|Number=Sing|NumType=Ord|PronType=Int,Rel"},
    "CzFS4----------": {POS: DET, "morph": "Case=Acc|Gender=Fem|Number=Sing|NumType=Ord|PronType=Int,Rel"},
    "CzFS6----------": {POS: DET, "morph": "Case=Loc|Gender=Fem|Number=Sing|NumType=Ord|PronType=Int,Rel"},
    "CzFS7----------": {POS: DET, "morph": "Case=Ins|Gender=Fem|Number=Sing|NumType=Ord|PronType=Int,Rel"},
    "CzIP1----------": {POS: DET,"morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|NumType=Ord|PronType=Int,Rel"},
    "CzIS4----------": {POS: DET,"morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|NumType=Ord|PronType=Int,Rel"},
    "CzMP1----------": {POS: DET,"morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|NumType=Ord|PronType=Int,Rel"},
    "CzMS4----------": {POS: DET,"morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|NumType=Ord|PronType=Int,Rel"},
    "CzNP1----------": {POS: DET, "morph": "Case=Nom|Gender=Neut|Number=Plur|NumType=Ord|PronType=Int,Rel"},
    "CzNP4----------": {POS: DET, "morph": "Case=Acc|Gender=Neut|Number=Plur|NumType=Ord|PronType=Int,Rel"},
    "CzNS1----------": {POS: DET, "morph": "Case=Nom|Gender=Neut|Number=Sing|NumType=Ord|PronType=Int,Rel"},
    "CzNS4----------": {POS: DET, "morph": "Case=Acc|Gender=Neut|Number=Sing|NumType=Ord|PronType=Int,Rel"},
    "CzXP2----------": {POS: DET, "morph": "Case=Gen|Number=Plur|NumType=Ord|PronType=Int,Rel"},
    "CzXP3----------": {POS: DET, "morph": "Case=Dat|Number=Plur|NumType=Ord|PronType=Int,Rel"},
    "CzXP6----------": {POS: DET, "morph": "Case=Loc|Number=Plur|NumType=Ord|PronType=Int,Rel"},
    "CzXP7----------": {POS: DET, "morph": "Case=Ins|Number=Plur|NumType=Ord|PronType=Int,Rel"},
    "CzYP4----------": {POS: DET, "morph": "Case=Acc|Gender=Masc|Number=Plur|NumType=Ord|PronType=Int,Rel"},
    "CzYS1----------": {POS: DET, "morph": "Case=Nom|Gender=Masc|Number=Sing|NumType=Ord|PronType=Int,Rel"},
    "CzZS2----------": {POS: DET, "morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|NumType=Ord|PronType=Int,Rel"},
    "CzZS3----------": {POS: DET, "morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|NumType=Ord|PronType=Int,Rel"},
    "CzZS6----------": {POS: DET, "morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|NumType=Ord|PronType=Int,Rel"},
    "CzZS7----------": {POS: DET, "morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|NumType=Ord|PronType=Int,Rel"},
    "D!-------------": {POS: ADV, "morph": "Abbr=Yes"},
    "Db-------------": {POS: ADV, "morph": "_"},
    "Db------------1": {POS: ADV, "morph": "_"},
    "Db------------2": {POS: ADV, "morph": "Style=Arch"},
    "Db------------4": {POS: ADV, "morph": "Style=Arch"},
    "Db------------6": {POS: ADV, "morph": "Style=Coll"},
    "Db------------7": {POS: ADV, "morph": "Style=Coll"},
    "Db------------8": {POS: ADV, "morph": "Abbr=Yes"},
    "Db------------9": {POS: ADV, "morph": "_"},
    "Db--------A----": {POS: ADV, "morph": "Polarity=Pos"},
    "Db--------N----": {POS: ADV, "morph": "Polarity=Neg"},
    "Dg-------1A----": {POS: ADV, "morph": "Degree=Pos|Polarity=Pos"},
    "Dg-------1A---1": {POS: ADV, "morph": "Degree=Pos|Polarity=Pos"},
    "Dg-------1A---3": {POS: ADV, "morph": "Degree=Pos|Polarity=Pos|Style=Arch"},
    "Dg-------1A---8": {POS: ADV, "morph": "Abbr=Yes|Degree=Pos|Polarity=Pos"},
    "Dg-------1N----": {POS: ADV, "morph": "Degree=Pos|Polarity=Neg"},
    "Dg-------1N---3": {POS: ADV, "morph": "Degree=Pos|Polarity=Neg|Style=Arch"},
    "Dg-------1N---8": {POS: ADV, "morph": "Abbr=Yes|Degree=Pos|Polarity=Neg"},
    "Dg-------2A----": {POS: ADV, "morph": "Degree=Cmp|Polarity=Pos"},
    "Dg-------2A---1": {POS: ADV, "morph": "Degree=Cmp|Polarity=Pos"},
    "Dg-------2A---2": {POS: ADV, "morph": "Degree=Cmp|Polarity=Pos|Style=Arch"},
    "Dg-------2A---3": {POS: ADV, "morph": "Degree=Cmp|Polarity=Pos|Style=Arch"},
    "Dg-------2A---6": {POS: ADV, "morph": "Degree=Cmp|Polarity=Pos|Style=Coll"},
    "Dg-------2N----": {POS: ADV, "morph": "Degree=Cmp|Polarity=Neg"},
    "Dg-------2N---1": {POS: ADV, "morph": "Degree=Cmp|Polarity=Neg"},
    "Dg-------2N---2": {POS: ADV, "morph": "Degree=Cmp|Polarity=Neg|Style=Arch"},
    "Dg-------2N---3": {POS: ADV, "morph": "Degree=Cmp|Polarity=Neg|Style=Arch"},
    "Dg-------2N---6": {POS: ADV, "morph": "Degree=Cmp|Polarity=Neg|Style=Coll"},
    "Dg-------3A----": {POS: ADV, "morph": "Degree=Sup|Polarity=Pos"},
    "Dg-------3A---1": {POS: ADV, "morph": "Degree=Sup|Polarity=Pos"},
    "Dg-------3A---2": {POS: ADV, "morph": "Degree=Sup|Polarity=Pos|Style=Arch"},
    "Dg-------3A---3": {POS: ADV, "morph": "Degree=Sup|Polarity=Pos|Style=Arch"},
    "Dg-------3A---6": {POS: ADV, "morph": "Degree=Sup|Polarity=Pos|Style=Coll"},
    "Dg-------3N----": {POS: ADV, "morph": "Degree=Sup|Polarity=Neg"},
    "Dg-------3N---1": {POS: ADV, "morph": "Degree=Sup|Polarity=Neg"},
    "Dg-------3N---2": {POS: ADV, "morph": "Degree=Sup|Polarity=Neg|Style=Arch"},
    "Dg-------3N---3": {POS: ADV, "morph": "Degree=Sup|Polarity=Neg|Style=Arch"},
    "Dg-------3N---6": {POS: ADV, "morph": "Degree=Sup|Polarity=Neg|Style=Coll"},
    "II-------------": {POS: INTJ, "morph": "_"},
    "J^-------------": {POS: CCONJ, "morph": "_"},
    "J,-------------": {POS: SCONJ, "morph": "_"},
    "J*-------------": {POS: CCONJ, "morph": "ConjType=Oper"},
    "J^------------1": {POS: CCONJ, "morph": "_"},
    "J,------------1": {POS: SCONJ, "morph": "_"},
    "J^------------2": {POS: CCONJ, "morph": "Style=Arch"},
    "J^------------8": {POS: CCONJ, "morph": "Abbr=Yes"},
    "J,------------8": {POS: SCONJ, "morph": "Abbr=Yes"},
    "J,-P---1-------": {POS: SCONJ, "morph": "Number=Plur|Person=1"},
    "J,-P---2-------": {POS: SCONJ, "morph": "Number=Plur|Person=2"},
    "J,-S---1-------": {POS: SCONJ, "morph": "Number=Sing|Person=1"},
    "J,-S---2-------": {POS: SCONJ, "morph": "Number=Sing|Person=2"},
    "J,-X---3-------": {POS: SCONJ, "morph": "Person=3"},
    "N;-------------": {POS: NOUN, "morph": "Abbr=Yes"},
    "NNFD7-----A----": {POS: NOUN, "morph": "Case=Ins|Gender=Fem|Number=Dual|Polarity=Pos"},
    "NNFD7-----N----": {POS: NOUN, "morph": "Case=Ins|Gender=Fem|Number=Dual|Polarity=Neg"},
    "NNFP1-----A----": {POS: NOUN, "morph": "Case=Nom|Gender=Fem|Number=Plur|Polarity=Pos"},
    "NNFP1-----A---1": {POS: NOUN, "morph": "Case=Nom|Gender=Fem|Number=Plur|Polarity=Pos"},
    "NNFP1-----A---4": {POS: NOUN, "morph": "Case=Nom|Gender=Fem|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNFP1-----A---6": {POS: NOUN, "morph": "Case=Nom|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNFP1-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Nom|Gender=Fem|Number=Plur|Polarity=Pos"},
    "NNFP1-----N----": {POS: NOUN, "morph": "Case=Nom|Gender=Fem|Number=Plur|Polarity=Neg"},
    "NNFP1-----N---1": {POS: NOUN, "morph": "Case=Nom|Gender=Fem|Number=Plur|Polarity=Neg"},
    "NNFP1-----N---4": {POS: NOUN, "morph": "Case=Nom|Gender=Fem|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNFP1-----N---6": {POS: NOUN, "morph": "Case=Nom|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNFP1-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Nom|Gender=Fem|Number=Plur|Polarity=Neg"},
    "NNFP2-----A----": {POS: NOUN, "morph": "Case=Gen|Gender=Fem|Number=Plur|Polarity=Pos"},
    "NNFP2-----A---1": {POS: NOUN, "morph": "Case=Gen|Gender=Fem|Number=Plur|Polarity=Pos"},
    "NNFP2-----A---6": {POS: NOUN, "morph": "Case=Gen|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNFP2-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Gen|Gender=Fem|Number=Plur|Polarity=Pos"},
    "NNFP2-----N----": {POS: NOUN, "morph": "Case=Gen|Gender=Fem|Number=Plur|Polarity=Neg"},
    "NNFP2-----N---1": {POS: NOUN, "morph": "Case=Gen|Gender=Fem|Number=Plur|Polarity=Neg"},
    "NNFP2-----N---6": {POS: NOUN, "morph": "Case=Gen|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNFP2-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Gen|Gender=Fem|Number=Plur|Polarity=Neg"},
    "NNFP3-----A----": {POS: NOUN, "morph": "Case=Dat|Gender=Fem|Number=Plur|Polarity=Pos"},
    "NNFP3-----A---1": {POS: NOUN, "morph": "Case=Dat|Gender=Fem|Number=Plur|Polarity=Pos"},
    "NNFP3-----A---6": {POS: NOUN, "morph": "Case=Dat|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNFP3-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Dat|Gender=Fem|Number=Plur|Polarity=Pos"},
    "NNFP3-----N----": {POS: NOUN, "morph": "Case=Dat|Gender=Fem|Number=Plur|Polarity=Neg"},
    "NNFP3-----N---1": {POS: NOUN, "morph": "Case=Dat|Gender=Fem|Number=Plur|Polarity=Neg"},
    "NNFP3-----N---6": {POS: NOUN, "morph": "Case=Dat|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNFP3-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Dat|Gender=Fem|Number=Plur|Polarity=Neg"},
    "NNFP4-----A----": {POS: NOUN, "morph": "Case=Acc|Gender=Fem|Number=Plur|Polarity=Pos"},
    "NNFP4-----A---1": {POS: NOUN, "morph": "Case=Acc|Gender=Fem|Number=Plur|Polarity=Pos"},
    "NNFP4-----A---4": {POS: NOUN, "morph": "Case=Acc|Gender=Fem|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNFP4-----A---6": {POS: NOUN, "morph": "Case=Acc|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNFP4-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Acc|Gender=Fem|Number=Plur|Polarity=Pos"},
    "NNFP4-----N----": {POS: NOUN, "morph": "Case=Acc|Gender=Fem|Number=Plur|Polarity=Neg"},
    "NNFP4-----N---1": {POS: NOUN, "morph": "Case=Acc|Gender=Fem|Number=Plur|Polarity=Neg"},
    "NNFP4-----N---4": {POS: NOUN, "morph": "Case=Acc|Gender=Fem|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNFP4-----N---6": {POS: NOUN, "morph": "Case=Acc|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNFP4-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Acc|Gender=Fem|Number=Plur|Polarity=Neg"},
    "NNFP5-----A----": {POS: NOUN, "morph": "Case=Voc|Gender=Fem|Number=Plur|Polarity=Pos"},
    "NNFP5-----A---1": {POS: NOUN, "morph": "Case=Voc|Gender=Fem|Number=Plur|Polarity=Pos"},
    "NNFP5-----A---4": {POS: NOUN, "morph": "Case=Voc|Gender=Fem|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNFP5-----A---6": {POS: NOUN, "morph": "Case=Voc|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNFP5-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Voc|Gender=Fem|Number=Plur|Polarity=Pos"},
    "NNFP5-----N----": {POS: NOUN, "morph": "Case=Voc|Gender=Fem|Number=Plur|Polarity=Neg"},
    "NNFP5-----N---1": {POS: NOUN, "morph": "Case=Voc|Gender=Fem|Number=Plur|Polarity=Neg"},
    "NNFP5-----N---4": {POS: NOUN, "morph": "Case=Voc|Gender=Fem|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNFP5-----N---6": {POS: NOUN, "morph": "Case=Voc|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNFP5-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Voc|Gender=Fem|Number=Plur|Polarity=Neg"},
    "NNFP6-----A----": {POS: NOUN, "morph": "Case=Loc|Gender=Fem|Number=Plur|Polarity=Pos"},
    "NNFP6-----A---1": {POS: NOUN, "morph": "Case=Loc|Gender=Fem|Number=Plur|Polarity=Pos"},
    "NNFP6-----A---6": {POS: NOUN, "morph": "Case=Loc|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNFP6-----A---7": {POS: NOUN, "morph": "Case=Loc|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNFP6-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Loc|Gender=Fem|Number=Plur|Polarity=Pos"},
    "NNFP6-----N----": {POS: NOUN, "morph": "Case=Loc|Gender=Fem|Number=Plur|Polarity=Neg"},
    "NNFP6-----N---1": {POS: NOUN, "morph": "Case=Loc|Gender=Fem|Number=Plur|Polarity=Neg"},
    "NNFP6-----N---6": {POS: NOUN, "morph": "Case=Loc|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNFP6-----N---7": {POS: NOUN, "morph": "Case=Loc|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNFP6-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Loc|Gender=Fem|Number=Plur|Polarity=Neg"},
    "NNFP7-----A----": {POS: NOUN, "morph": "Case=Ins|Gender=Fem|Number=Plur|Polarity=Pos"},
    "NNFP7-----A---1": {POS: NOUN, "morph": "Case=Ins|Gender=Fem|Number=Plur|Polarity=Pos"},
    "NNFP7-----A---2": {POS: NOUN, "morph": "Case=Ins|Gender=Fem|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNFP7-----A---6": {POS: NOUN, "morph": "Case=Ins|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNFP7-----A---7": {POS: NOUN, "morph": "Case=Ins|Gender=Fem|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNFP7-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Ins|Gender=Fem|Number=Plur|Polarity=Pos"},
    "NNFP7-----N----": {POS: NOUN, "morph": "Case=Ins|Gender=Fem|Number=Plur|Polarity=Neg"},
    "NNFP7-----N---1": {POS: NOUN, "morph": "Case=Ins|Gender=Fem|Number=Plur|Polarity=Neg"},
    "NNFP7-----N---2": {POS: NOUN, "morph": "Case=Ins|Gender=Fem|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNFP7-----N---6": {POS: NOUN, "morph": "Case=Ins|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNFP7-----N---7": {POS: NOUN, "morph": "Case=Ins|Gender=Fem|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNFP7-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Ins|Gender=Fem|Number=Plur|Polarity=Neg"},
    "NNFPX-----A----": {POS: NOUN, "morph": "Gender=Fem|Number=Plur|Polarity=Pos"},
    "NNFPX-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Gender=Fem|Number=Plur|Polarity=Pos"},
    "NNFPX-----N----": {POS: NOUN, "morph": "Gender=Fem|Number=Plur|Polarity=Neg"},
    "NNFPX-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Gender=Fem|Number=Plur|Polarity=Neg"},
    "NNFS1-----A----": {POS: NOUN, "morph": "Case=Nom|Gender=Fem|Number=Sing|Polarity=Pos"},
    "NNFS1-----A---1": {POS: NOUN, "morph": "Case=Nom|Gender=Fem|Number=Sing|Polarity=Pos"},
    "NNFS1-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Nom|Gender=Fem|Number=Sing|Polarity=Pos"},
    "NNFS1-----N----": {POS: NOUN, "morph": "Case=Nom|Gender=Fem|Number=Sing|Polarity=Neg"},
    "NNFS1-----N---1": {POS: NOUN, "morph": "Case=Nom|Gender=Fem|Number=Sing|Polarity=Neg"},
    "NNFS1-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Nom|Gender=Fem|Number=Sing|Polarity=Neg"},
    "NNFS2-----A----": {POS: NOUN, "morph": "Case=Gen|Gender=Fem|Number=Sing|Polarity=Pos"},
    "NNFS2-----A---1": {POS: NOUN, "morph": "Case=Gen|Gender=Fem|Number=Sing|Polarity=Pos"},
    "NNFS2-----A---2": {POS: NOUN, "morph": "Case=Gen|Gender=Fem|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNFS2-----A---6": {POS: NOUN, "morph": "Case=Gen|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNFS2-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Gen|Gender=Fem|Number=Sing|Polarity=Pos"},
    "NNFS2-----N----": {POS: NOUN, "morph": "Case=Gen|Gender=Fem|Number=Sing|Polarity=Neg"},
    "NNFS2-----N---1": {POS: NOUN, "morph": "Case=Gen|Gender=Fem|Number=Sing|Polarity=Neg"},
    "NNFS2-----N---2": {POS: NOUN, "morph": "Case=Gen|Gender=Fem|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNFS2-----N---6": {POS: NOUN, "morph": "Case=Gen|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNFS2-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Gen|Gender=Fem|Number=Sing|Polarity=Neg"},
    "NNFS3-----A----": {POS: NOUN, "morph": "Case=Dat|Gender=Fem|Number=Sing|Polarity=Pos"},
    "NNFS3-----A---1": {POS: NOUN, "morph": "Case=Dat|Gender=Fem|Number=Sing|Polarity=Pos"},
    "NNFS3-----A---2": {POS: NOUN, "morph": "Case=Dat|Gender=Fem|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNFS3-----A---6": {POS: NOUN, "morph": "Case=Dat|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNFS3-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Dat|Gender=Fem|Number=Sing|Polarity=Pos"},
    "NNFS3-----N----": {POS: NOUN, "morph": "Case=Dat|Gender=Fem|Number=Sing|Polarity=Neg"},
    "NNFS3-----N---1": {POS: NOUN, "morph": "Case=Dat|Gender=Fem|Number=Sing|Polarity=Neg"},
    "NNFS3-----N---2": {POS: NOUN, "morph": "Case=Dat|Gender=Fem|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNFS3-----N---6": {POS: NOUN, "morph": "Case=Dat|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNFS3-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Dat|Gender=Fem|Number=Sing|Polarity=Neg"},
    "NNFS4-----A----": {POS: NOUN, "morph": "Case=Acc|Gender=Fem|Number=Sing|Polarity=Pos"},
    "NNFS4-----A---1": {POS: NOUN, "morph": "Case=Acc|Gender=Fem|Number=Sing|Polarity=Pos"},
    "NNFS4-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Acc|Gender=Fem|Number=Sing|Polarity=Pos"},
    "NNFS4-----N----": {POS: NOUN, "morph": "Case=Acc|Gender=Fem|Number=Sing|Polarity=Neg"},
    "NNFS4-----N---1": {POS: NOUN, "morph": "Case=Acc|Gender=Fem|Number=Sing|Polarity=Neg"},
    "NNFS4-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Acc|Gender=Fem|Number=Sing|Polarity=Neg"},
    "NNFS5-----A----": {POS: NOUN, "morph": "Case=Voc|Gender=Fem|Number=Sing|Polarity=Pos"},
    "NNFS5-----A---1": {POS: NOUN, "morph": "Case=Voc|Gender=Fem|Number=Sing|Polarity=Pos"},
    "NNFS5-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Voc|Gender=Fem|Number=Sing|Polarity=Pos"},
    "NNFS5-----N----": {POS: NOUN, "morph": "Case=Voc|Gender=Fem|Number=Sing|Polarity=Neg"},
    "NNFS5-----N---1": {POS: NOUN, "morph": "Case=Voc|Gender=Fem|Number=Sing|Polarity=Neg"},
    "NNFS5-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Voc|Gender=Fem|Number=Sing|Polarity=Neg"},
    "NNFS6-----A----": {POS: NOUN, "morph": "Case=Loc|Gender=Fem|Number=Sing|Polarity=Pos"},
    "NNFS6-----A---1": {POS: NOUN, "morph": "Case=Loc|Gender=Fem|Number=Sing|Polarity=Pos"},
    "NNFS6-----A---6": {POS: NOUN, "morph": "Case=Loc|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNFS6-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Loc|Gender=Fem|Number=Sing|Polarity=Pos"},
    "NNFS6-----N----": {POS: NOUN, "morph": "Case=Loc|Gender=Fem|Number=Sing|Polarity=Neg"},
    "NNFS6-----N---1": {POS: NOUN, "morph": "Case=Loc|Gender=Fem|Number=Sing|Polarity=Neg"},
    "NNFS6-----N---6": {POS: NOUN, "morph": "Case=Loc|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNFS6-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Loc|Gender=Fem|Number=Sing|Polarity=Neg"},
    "NNFS7-----A----": {POS: NOUN, "morph": "Case=Ins|Gender=Fem|Number=Sing|Polarity=Pos"},
    "NNFS7-----A---1": {POS: NOUN, "morph": "Case=Ins|Gender=Fem|Number=Sing|Polarity=Pos"},
    "NNFS7-----A---3": {POS: NOUN, "morph": "Case=Ins|Gender=Fem|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNFS7-----A---6": {POS: NOUN, "morph": "Case=Ins|Gender=Fem|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNFS7-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Ins|Gender=Fem|Number=Sing|Polarity=Pos"},
    "NNFS7-----N----": {POS: NOUN, "morph": "Case=Ins|Gender=Fem|Number=Sing|Polarity=Neg"},
    "NNFS7-----N---1": {POS: NOUN, "morph": "Case=Ins|Gender=Fem|Number=Sing|Polarity=Neg"},
    "NNFS7-----N---3": {POS: NOUN, "morph": "Case=Ins|Gender=Fem|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNFS7-----N---6": {POS: NOUN, "morph": "Case=Ins|Gender=Fem|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNFS7-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Ins|Gender=Fem|Number=Sing|Polarity=Neg"},
    "NNFSX-----A----": {POS: NOUN, "morph": "Gender=Fem|Number=Sing|Polarity=Pos"},
    "NNFSX-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Gender=Fem|Number=Sing|Polarity=Pos"},
    "NNFSX-----N----": {POS: NOUN, "morph": "Gender=Fem|Number=Sing|Polarity=Neg"},
    "NNFSX-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Gender=Fem|Number=Sing|Polarity=Neg"},
    "NNFXX-----A----": {POS: NOUN, "morph": "Gender=Fem|Polarity=Pos"},
    "NNFXX-----A---1": {POS: NOUN, "morph": "Gender=Fem|Polarity=Pos"},
    "NNFXX-----A---2": {POS: NOUN, "morph": "Gender=Fem|Polarity=Pos|Style=Arch"},
    "NNFXX-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Gender=Fem|Polarity=Pos"},
    "NNFXX-----A---9": {POS: NOUN, "morph": "Gender=Fem|Polarity=Pos"},
    "NNFXX-----N----": {POS: NOUN, "morph": "Gender=Fem|Polarity=Neg"},
    "NNFXX-----N---1": {POS: NOUN, "morph": "Gender=Fem|Polarity=Neg"},
    "NNFXX-----N---2": {POS: NOUN, "morph": "Gender=Fem|Polarity=Neg|Style=Arch"},
    "NNFXX-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Gender=Fem|Polarity=Neg"},
    "NNFXX-----N---9": {POS: NOUN, "morph": "Gender=Fem|Polarity=Neg"},
    "NNIP1-----A----": {POS: NOUN, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIP1-----A---1": {POS: NOUN, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIP1-----A---2": {POS: NOUN, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNIP1-----A---3": {POS: NOUN, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNIP1-----A---6": {POS: NOUN, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNIP1-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIP1-----A---9": {POS: NOUN, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIP1-----N----": {POS: NOUN, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIP1-----N---1": {POS: NOUN, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIP1-----N---2": {POS: NOUN, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNIP1-----N---3": {POS: NOUN, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNIP1-----N---6": {POS: NOUN, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNIP1-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIP1-----N---9": {POS: NOUN, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIP2-----A----": {POS: NOUN, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIP2-----A---1": {POS: NOUN, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIP2-----A---2": {POS: NOUN, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNIP2-----A---3": {POS: NOUN, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNIP2-----A---6": {POS: NOUN, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNIP2-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Case=Gen|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIP2-----A---9": {POS: NOUN, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIP2-----N----": {POS: NOUN, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIP2-----N---1": {POS: NOUN, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIP2-----N---2": {POS: NOUN, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNIP2-----N---3": {POS: NOUN, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNIP2-----N---6": {POS: NOUN, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNIP2-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Case=Gen|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIP2-----N---9": {POS: NOUN, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIP3-----A----": {POS: NOUN, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIP3-----A---1": {POS: NOUN, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIP3-----A---2": {POS: NOUN, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNIP3-----A---6": {POS: NOUN, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNIP3-----A---7": {POS: NOUN, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNIP3-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Case=Dat|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIP3-----A---9": {POS: NOUN, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIP3-----N----": {POS: NOUN, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIP3-----N---1": {POS: NOUN, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIP3-----N---2": {POS: NOUN, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNIP3-----N---6": {POS: NOUN, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNIP3-----N---7": {POS: NOUN, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNIP3-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Case=Dat|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIP3-----N---9": {POS: NOUN, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIP4-----A----": {POS: NOUN, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIP4-----A---1": {POS: NOUN, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIP4-----A---2": {POS: NOUN, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNIP4-----A---3": {POS: NOUN, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNIP4-----A---6": {POS: NOUN, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNIP4-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Case=Acc|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIP4-----A---9": {POS: NOUN, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIP4-----N----": {POS: NOUN, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIP4-----N---1": {POS: NOUN, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIP4-----N---2": {POS: NOUN, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNIP4-----N---3": {POS: NOUN, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNIP4-----N---6": {POS: NOUN, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNIP4-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Case=Acc|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIP4-----N---9": {POS: NOUN, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIP5-----A----": {POS: NOUN, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIP5-----A---1": {POS: NOUN, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIP5-----A---2": {POS: NOUN, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNIP5-----A---3": {POS: NOUN, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNIP5-----A---6": {POS: NOUN, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNIP5-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIP5-----A---9": {POS: NOUN, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIP5-----N----": {POS: NOUN, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIP5-----N---1": {POS: NOUN, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIP5-----N---2": {POS: NOUN, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNIP5-----N---3": {POS: NOUN, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNIP5-----N---6": {POS: NOUN, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNIP5-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIP5-----N---9": {POS: NOUN, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIP6-----A----": {POS: NOUN, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIP6-----A---1": {POS: NOUN, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIP6-----A---2": {POS: NOUN, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNIP6-----A---3": {POS: NOUN, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNIP6-----A---6": {POS: NOUN, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNIP6-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Case=Loc|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIP6-----A---9": {POS: NOUN, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIP6-----N----": {POS: NOUN, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIP6-----N---1": {POS: NOUN, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIP6-----N---2": {POS: NOUN, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNIP6-----N---3": {POS: NOUN, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNIP6-----N---6": {POS: NOUN, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNIP6-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Case=Loc|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIP6-----N---9": {POS: NOUN, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIP7-----A----": {POS: NOUN, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIP7-----A---1": {POS: NOUN, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIP7-----A---2": {POS: NOUN, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNIP7-----A---6": {POS: NOUN, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNIP7-----A---7": {POS: NOUN, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNIP7-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Case=Ins|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIP7-----A---9": {POS: NOUN, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIP7-----N----": {POS: NOUN, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIP7-----N---1": {POS: NOUN, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIP7-----N---2": {POS: NOUN, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNIP7-----N---6": {POS: NOUN, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNIP7-----N---7": {POS: NOUN, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNIP7-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Case=Ins|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIP7-----N---9": {POS: NOUN, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIPX-----A----": {POS: NOUN, "morph": "Animacy=Inan|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIPX-----A---1": {POS: NOUN, "morph": "Animacy=Inan|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIPX-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNIPX-----N----": {POS: NOUN, "morph": "Animacy=Inan|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIPX-----N---1": {POS: NOUN, "morph": "Animacy=Inan|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIPX-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNIS1-----A----": {POS: NOUN, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNIS1-----A---1": {POS: NOUN, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNIS1-----A---2": {POS: NOUN, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNIS1-----A---6": {POS: NOUN, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNIS1-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Case=Nom|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNIS1-----N----": {POS: NOUN, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNIS1-----N---1": {POS: NOUN, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNIS1-----N---2": {POS: NOUN, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNIS1-----N---6": {POS: NOUN, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNIS1-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Case=Nom|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNIS2-----A----": {POS: NOUN, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNIS2-----A---1": {POS: NOUN, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNIS2-----A---2": {POS: NOUN, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNIS2-----A---6": {POS: NOUN, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNIS2-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Case=Gen|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNIS2-----A---9": {POS: NOUN, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNIS2-----N----": {POS: NOUN, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNIS2-----N---1": {POS: NOUN, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNIS2-----N---2": {POS: NOUN, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNIS2-----N---6": {POS: NOUN, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNIS2-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Case=Gen|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNIS2-----N---9": {POS: NOUN, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNIS3-----A----": {POS: NOUN, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNIS3-----A---1": {POS: NOUN, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNIS3-----A---2": {POS: NOUN, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNIS3-----A---6": {POS: NOUN, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNIS3-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Case=Dat|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNIS3-----A---9": {POS: NOUN, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNIS3-----N----": {POS: NOUN, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNIS3-----N---1": {POS: NOUN, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNIS3-----N---2": {POS: NOUN, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNIS3-----N---6": {POS: NOUN, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNIS3-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Case=Dat|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNIS3-----N---9": {POS: NOUN, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNIS4-----A----": {POS: NOUN, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNIS4-----A---1": {POS: NOUN, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNIS4-----A---2": {POS: NOUN, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNIS4-----A---6": {POS: NOUN, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNIS4-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNIS4-----N----": {POS: NOUN, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNIS4-----N---1": {POS: NOUN, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNIS4-----N---2": {POS: NOUN, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNIS4-----N---6": {POS: NOUN, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNIS4-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNIS5-----A----": {POS: NOUN, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNIS5-----A---1": {POS: NOUN, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNIS5-----A---2": {POS: NOUN, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNIS5-----A---6": {POS: NOUN, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNIS5-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Case=Voc|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNIS5-----A---9": {POS: NOUN, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNIS5-----N----": {POS: NOUN, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNIS5-----N---1": {POS: NOUN, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNIS5-----N---2": {POS: NOUN, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNIS5-----N---6": {POS: NOUN, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNIS5-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Case=Voc|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNIS5-----N---9": {POS: NOUN, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNIS6-----A----": {POS: NOUN, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNIS6-----A---1": {POS: NOUN, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNIS6-----A---2": {POS: NOUN, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNIS6-----A---6": {POS: NOUN, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNIS6-----A---7": {POS: NOUN, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNIS6-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Case=Loc|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNIS6-----A---9": {POS: NOUN, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNIS6-----N----": {POS: NOUN, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNIS6-----N---1": {POS: NOUN, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNIS6-----N---2": {POS: NOUN, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNIS6-----N---6": {POS: NOUN, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNIS6-----N---7": {POS: NOUN, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNIS6-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Case=Loc|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNIS6-----N---9": {POS: NOUN, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNIS7-----A----": {POS: NOUN, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNIS7-----A---1": {POS: NOUN, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNIS7-----A---2": {POS: NOUN, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNIS7-----A---6": {POS: NOUN, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNIS7-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Case=Ins|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNIS7-----A---9": {POS: NOUN, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNIS7-----N----": {POS: NOUN, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNIS7-----N---1": {POS: NOUN, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNIS7-----N---2": {POS: NOUN, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNIS7-----N---6": {POS: NOUN, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNIS7-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Case=Ins|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNIS7-----N---9": {POS: NOUN, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNISX-----A----": {POS: NOUN, "morph": "Animacy=Inan|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNISX-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNISX-----N----": {POS: NOUN, "morph": "Animacy=Inan|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNISX-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNIXX-----A----": {POS: NOUN, "morph": "Animacy=Inan|Gender=Masc|Polarity=Pos"},
    "NNIXX-----A---1": {POS: NOUN, "morph": "Animacy=Inan|Gender=Masc|Polarity=Pos"},
    "NNIXX-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Gender=Masc|Polarity=Pos"},
    "NNIXX-----N----": {POS: NOUN, "morph": "Animacy=Inan|Gender=Masc|Polarity=Neg"},
    "NNIXX-----N---1": {POS: NOUN, "morph": "Animacy=Inan|Gender=Masc|Polarity=Neg"},
    "NNIXX-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Inan|Gender=Masc|Polarity=Neg"},
    "NNMP1-----A----": {POS: NOUN, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNMP1-----A---1": {POS: NOUN, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNMP1-----A---2": {POS: NOUN, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNMP1-----A---6": {POS: NOUN, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNMP1-----A---7": {POS: NOUN, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNMP1-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNMP1-----N----": {POS: NOUN, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNMP1-----N---1": {POS: NOUN, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNMP1-----N---2": {POS: NOUN, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNMP1-----N---6": {POS: NOUN, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNMP1-----N---7": {POS: NOUN, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNMP1-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNMP2-----A----": {POS: NOUN, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNMP2-----A---1": {POS: NOUN, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNMP2-----A---2": {POS: NOUN, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNMP2-----A---6": {POS: NOUN, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNMP2-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Case=Gen|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNMP2-----N----": {POS: NOUN, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNMP2-----N---1": {POS: NOUN, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNMP2-----N---2": {POS: NOUN, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNMP2-----N---6": {POS: NOUN, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNMP2-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Case=Gen|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNMP3-----A----": {POS: NOUN, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNMP3-----A---1": {POS: NOUN, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNMP3-----A---2": {POS: NOUN, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNMP3-----A---6": {POS: NOUN, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNMP3-----A---7": {POS: NOUN, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNMP3-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Case=Dat|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNMP3-----N----": {POS: NOUN, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNMP3-----N---1": {POS: NOUN, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNMP3-----N---2": {POS: NOUN, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNMP3-----N---6": {POS: NOUN, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNMP3-----N---7": {POS: NOUN, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNMP3-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Case=Dat|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNMP4-----A----": {POS: NOUN, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNMP4-----A---1": {POS: NOUN, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNMP4-----A---2": {POS: NOUN, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNMP4-----A---6": {POS: NOUN, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNMP4-----A---7": {POS: NOUN, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNMP4-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Case=Acc|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNMP4-----N----": {POS: NOUN, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNMP4-----N---1": {POS: NOUN, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNMP4-----N---2": {POS: NOUN, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNMP4-----N---6": {POS: NOUN, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNMP4-----N---7": {POS: NOUN, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNMP4-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Case=Acc|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNMP5-----A----": {POS: NOUN, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNMP5-----A---1": {POS: NOUN, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNMP5-----A---2": {POS: NOUN, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNMP5-----A---5": {POS: NOUN, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNMP5-----A---6": {POS: NOUN, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNMP5-----A---7": {POS: NOUN, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNMP5-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNMP5-----N----": {POS: NOUN, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNMP5-----N---1": {POS: NOUN, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNMP5-----N---2": {POS: NOUN, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNMP5-----N---5": {POS: NOUN, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNMP5-----N---6": {POS: NOUN, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNMP5-----N---7": {POS: NOUN, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNMP5-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNMP6-----A----": {POS: NOUN, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNMP6-----A---1": {POS: NOUN, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNMP6-----A---2": {POS: NOUN, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNMP6-----A---6": {POS: NOUN, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNMP6-----A---7": {POS: NOUN, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNMP6-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Case=Loc|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNMP6-----N----": {POS: NOUN, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNMP6-----N---1": {POS: NOUN, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNMP6-----N---2": {POS: NOUN, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNMP6-----N---6": {POS: NOUN, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNMP6-----N---7": {POS: NOUN, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNMP6-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Case=Loc|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNMP7-----A----": {POS: NOUN, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNMP7-----A---1": {POS: NOUN, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNMP7-----A---2": {POS: NOUN, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNMP7-----A---6": {POS: NOUN, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNMP7-----A---7": {POS: NOUN, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNMP7-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Case=Ins|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNMP7-----N----": {POS: NOUN, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNMP7-----N---1": {POS: NOUN, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNMP7-----N---2": {POS: NOUN, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNMP7-----N---6": {POS: NOUN, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNMP7-----N---7": {POS: NOUN, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNMP7-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Case=Ins|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNMPX-----A----": {POS: NOUN, "morph": "Animacy=Anim|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNMPX-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Gender=Masc|Number=Plur|Polarity=Pos"},
    "NNMPX-----N----": {POS: NOUN, "morph": "Animacy=Anim|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNMPX-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Gender=Masc|Number=Plur|Polarity=Neg"},
    "NNMS1-----A----": {POS: NOUN, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNMS1-----A---1": {POS: NOUN, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNMS1-----A---2": {POS: NOUN, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNMS1-----A---6": {POS: NOUN, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNMS1-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Case=Nom|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNMS1-----N----": {POS: NOUN, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNMS1-----N---1": {POS: NOUN, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNMS1-----N---2": {POS: NOUN, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNMS1-----N---6": {POS: NOUN, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNMS1-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Case=Nom|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNMS2-----A----": {POS: NOUN, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNMS2-----A---1": {POS: NOUN, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNMS2-----A---2": {POS: NOUN, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNMS2-----A---3": {POS: NOUN, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNMS2-----A---6": {POS: NOUN, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNMS2-----A---7": {POS: NOUN, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNMS2-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Case=Gen|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNMS2-----N----": {POS: NOUN, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNMS2-----N---1": {POS: NOUN, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNMS2-----N---2": {POS: NOUN, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNMS2-----N---3": {POS: NOUN, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNMS2-----N---6": {POS: NOUN, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNMS2-----N---7": {POS: NOUN, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNMS2-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Case=Gen|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNMS3-----A----": {POS: NOUN, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNMS3-----A---1": {POS: NOUN, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNMS3-----A---2": {POS: NOUN, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNMS3-----A---3": {POS: NOUN, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNMS3-----A---6": {POS: NOUN, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNMS3-----A---7": {POS: NOUN, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNMS3-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Case=Dat|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNMS3-----N----": {POS: NOUN, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNMS3-----N---1": {POS: NOUN, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNMS3-----N---2": {POS: NOUN, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNMS3-----N---3": {POS: NOUN, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNMS3-----N---6": {POS: NOUN, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNMS3-----N---7": {POS: NOUN, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNMS3-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Case=Dat|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNMS4-----A----": {POS: NOUN, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNMS4-----A---1": {POS: NOUN, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNMS4-----A---2": {POS: NOUN, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNMS4-----A---6": {POS: NOUN, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNMS4-----A---7": {POS: NOUN, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNMS4-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNMS4-----N----": {POS: NOUN, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNMS4-----N---1": {POS: NOUN, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNMS4-----N---2": {POS: NOUN, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNMS4-----N---6": {POS: NOUN, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNMS4-----N---7": {POS: NOUN, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNMS4-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNMS5-----A----": {POS: NOUN, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNMS5-----A---1": {POS: NOUN, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNMS5-----A---2": {POS: NOUN, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNMS5-----A---4": {POS: NOUN, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNMS5-----A---5": {POS: NOUN, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNMS5-----A---6": {POS: NOUN, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNMS5-----A---7": {POS: NOUN, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNMS5-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Case=Voc|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNMS5-----N----": {POS: NOUN, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNMS5-----N---1": {POS: NOUN, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNMS5-----N---2": {POS: NOUN, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNMS5-----N---4": {POS: NOUN, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNMS5-----N---5": {POS: NOUN, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNMS5-----N---6": {POS: NOUN, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNMS5-----N---7": {POS: NOUN, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNMS5-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Case=Voc|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNMS6-----A----": {POS: NOUN, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNMS6-----A---1": {POS: NOUN, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNMS6-----A---2": {POS: NOUN, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNMS6-----A---3": {POS: NOUN, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNMS6-----A---6": {POS: NOUN, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNMS6-----A---7": {POS: NOUN, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNMS6-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Case=Loc|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNMS6-----N----": {POS: NOUN, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNMS6-----N---1": {POS: NOUN, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNMS6-----N---2": {POS: NOUN, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNMS6-----N---3": {POS: NOUN, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNMS6-----N---6": {POS: NOUN, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNMS6-----N---7": {POS: NOUN, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNMS6-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Case=Loc|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNMS7-----A----": {POS: NOUN, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNMS7-----A---1": {POS: NOUN, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNMS7-----A---2": {POS: NOUN, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNMS7-----A---6": {POS: NOUN, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNMS7-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Case=Ins|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNMS7-----N----": {POS: NOUN, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNMS7-----N---1": {POS: NOUN, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNMS7-----N---2": {POS: NOUN, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNMS7-----N---6": {POS: NOUN, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNMS7-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Case=Ins|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNMSX-----A----": {POS: NOUN, "morph": "Animacy=Anim|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNMSX-----A---1": {POS: NOUN, "morph": "Animacy=Anim|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNMSX-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Gender=Masc|Number=Sing|Polarity=Pos"},
    "NNMSX-----N----": {POS: NOUN, "morph": "Animacy=Anim|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNMSX-----N---1": {POS: NOUN, "morph": "Animacy=Anim|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNMSX-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Gender=Masc|Number=Sing|Polarity=Neg"},
    "NNMXX-----A----": {POS: NOUN, "morph": "Animacy=Anim|Gender=Masc|Polarity=Pos"},
    "NNMXX-----A---1": {POS: NOUN, "morph": "Animacy=Anim|Gender=Masc|Polarity=Pos"},
    "NNMXX-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Gender=Masc|Polarity=Pos"},
    "NNMXX-----N----": {POS: NOUN, "morph": "Animacy=Anim|Gender=Masc|Polarity=Neg"},
    "NNMXX-----N---1": {POS: NOUN, "morph": "Animacy=Anim|Gender=Masc|Polarity=Neg"},
    "NNMXX-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Animacy=Anim|Gender=Masc|Polarity=Neg"},
    "NNNP1-----A----": {POS: NOUN, "morph": "Case=Nom|Gender=Neut|Number=Plur|Polarity=Pos"},
    "NNNP1-----A---1": {POS: NOUN, "morph": "Case=Nom|Gender=Neut|Number=Plur|Polarity=Pos"},
    "NNNP1-----A---2": {POS: NOUN, "morph": "Case=Nom|Gender=Neut|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNNP1-----A---3": {POS: NOUN, "morph": "Case=Nom|Gender=Neut|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNNP1-----A---6": {POS: NOUN, "morph": "Case=Nom|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNNP1-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Nom|Gender=Neut|Number=Plur|Polarity=Pos"},
    "NNNP1-----N----": {POS: NOUN, "morph": "Case=Nom|Gender=Neut|Number=Plur|Polarity=Neg"},
    "NNNP1-----N---1": {POS: NOUN, "morph": "Case=Nom|Gender=Neut|Number=Plur|Polarity=Neg"},
    "NNNP1-----N---2": {POS: NOUN, "morph": "Case=Nom|Gender=Neut|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNNP1-----N---3": {POS: NOUN, "morph": "Case=Nom|Gender=Neut|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNNP1-----N---6": {POS: NOUN, "morph": "Case=Nom|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNNP1-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Nom|Gender=Neut|Number=Plur|Polarity=Neg"},
    "NNNP2-----A----": {POS: NOUN, "morph": "Case=Gen|Gender=Neut|Number=Plur|Polarity=Pos"},
    "NNNP2-----A---1": {POS: NOUN, "morph": "Case=Gen|Gender=Neut|Number=Plur|Polarity=Pos"},
    "NNNP2-----A---2": {POS: NOUN, "morph": "Case=Gen|Gender=Neut|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNNP2-----A---3": {POS: NOUN, "morph": "Case=Gen|Gender=Neut|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNNP2-----A---6": {POS: NOUN, "morph": "Case=Gen|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNNP2-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Gen|Gender=Neut|Number=Plur|Polarity=Pos"},
    "NNNP2-----N----": {POS: NOUN, "morph": "Case=Gen|Gender=Neut|Number=Plur|Polarity=Neg"},
    "NNNP2-----N---1": {POS: NOUN, "morph": "Case=Gen|Gender=Neut|Number=Plur|Polarity=Neg"},
    "NNNP2-----N---2": {POS: NOUN, "morph": "Case=Gen|Gender=Neut|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNNP2-----N---3": {POS: NOUN, "morph": "Case=Gen|Gender=Neut|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNNP2-----N---6": {POS: NOUN, "morph": "Case=Gen|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNNP2-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Gen|Gender=Neut|Number=Plur|Polarity=Neg"},
    "NNNP3-----A----": {POS: NOUN, "morph": "Case=Dat|Gender=Neut|Number=Plur|Polarity=Pos"},
    "NNNP3-----A---1": {POS: NOUN, "morph": "Case=Dat|Gender=Neut|Number=Plur|Polarity=Pos"},
    "NNNP3-----A---2": {POS: NOUN, "morph": "Case=Dat|Gender=Neut|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNNP3-----A---3": {POS: NOUN, "morph": "Case=Dat|Gender=Neut|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNNP3-----A---6": {POS: NOUN, "morph": "Case=Dat|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNNP3-----A---7": {POS: NOUN, "morph": "Case=Dat|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNNP3-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Dat|Gender=Neut|Number=Plur|Polarity=Pos"},
    "NNNP3-----N----": {POS: NOUN, "morph": "Case=Dat|Gender=Neut|Number=Plur|Polarity=Neg"},
    "NNNP3-----N---1": {POS: NOUN, "morph": "Case=Dat|Gender=Neut|Number=Plur|Polarity=Neg"},
    "NNNP3-----N---2": {POS: NOUN, "morph": "Case=Dat|Gender=Neut|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNNP3-----N---3": {POS: NOUN, "morph": "Case=Dat|Gender=Neut|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNNP3-----N---6": {POS: NOUN, "morph": "Case=Dat|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNNP3-----N---7": {POS: NOUN, "morph": "Case=Dat|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNNP3-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Dat|Gender=Neut|Number=Plur|Polarity=Neg"},
    "NNNP4-----A----": {POS: NOUN, "morph": "Case=Acc|Gender=Neut|Number=Plur|Polarity=Pos"},
    "NNNP4-----A---1": {POS: NOUN, "morph": "Case=Acc|Gender=Neut|Number=Plur|Polarity=Pos"},
    "NNNP4-----A---2": {POS: NOUN, "morph": "Case=Acc|Gender=Neut|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNNP4-----A---3": {POS: NOUN, "morph": "Case=Acc|Gender=Neut|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNNP4-----A---6": {POS: NOUN, "morph": "Case=Acc|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNNP4-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Acc|Gender=Neut|Number=Plur|Polarity=Pos"},
    "NNNP4-----N----": {POS: NOUN, "morph": "Case=Acc|Gender=Neut|Number=Plur|Polarity=Neg"},
    "NNNP4-----N---1": {POS: NOUN, "morph": "Case=Acc|Gender=Neut|Number=Plur|Polarity=Neg"},
    "NNNP4-----N---2": {POS: NOUN, "morph": "Case=Acc|Gender=Neut|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNNP4-----N---3": {POS: NOUN, "morph": "Case=Acc|Gender=Neut|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNNP4-----N---6": {POS: NOUN, "morph": "Case=Acc|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNNP4-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Acc|Gender=Neut|Number=Plur|Polarity=Neg"},
    "NNNP5-----A----": {POS: NOUN, "morph": "Case=Voc|Gender=Neut|Number=Plur|Polarity=Pos"},
    "NNNP5-----A---1": {POS: NOUN, "morph": "Case=Voc|Gender=Neut|Number=Plur|Polarity=Pos"},
    "NNNP5-----A---2": {POS: NOUN, "morph": "Case=Voc|Gender=Neut|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNNP5-----A---3": {POS: NOUN, "morph": "Case=Voc|Gender=Neut|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNNP5-----A---6": {POS: NOUN, "morph": "Case=Voc|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNNP5-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Voc|Gender=Neut|Number=Plur|Polarity=Pos"},
    "NNNP5-----N----": {POS: NOUN, "morph": "Case=Voc|Gender=Neut|Number=Plur|Polarity=Neg"},
    "NNNP5-----N---1": {POS: NOUN, "morph": "Case=Voc|Gender=Neut|Number=Plur|Polarity=Neg"},
    "NNNP5-----N---2": {POS: NOUN, "morph": "Case=Voc|Gender=Neut|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNNP5-----N---3": {POS: NOUN, "morph": "Case=Voc|Gender=Neut|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNNP5-----N---6": {POS: NOUN, "morph": "Case=Voc|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNNP5-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Voc|Gender=Neut|Number=Plur|Polarity=Neg"},
    "NNNP6-----A----": {POS: NOUN, "morph": "Case=Loc|Gender=Neut|Number=Plur|Polarity=Pos"},
    "NNNP6-----A---1": {POS: NOUN, "morph": "Case=Loc|Gender=Neut|Number=Plur|Polarity=Pos"},
    "NNNP6-----A---2": {POS: NOUN, "morph": "Case=Loc|Gender=Neut|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNNP6-----A---3": {POS: NOUN, "morph": "Case=Loc|Gender=Neut|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNNP6-----A---6": {POS: NOUN, "morph": "Case=Loc|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNNP6-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Loc|Gender=Neut|Number=Plur|Polarity=Pos"},
    "NNNP6-----N----": {POS: NOUN, "morph": "Case=Loc|Gender=Neut|Number=Plur|Polarity=Neg"},
    "NNNP6-----N---1": {POS: NOUN, "morph": "Case=Loc|Gender=Neut|Number=Plur|Polarity=Neg"},
    "NNNP6-----N---2": {POS: NOUN, "morph": "Case=Loc|Gender=Neut|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNNP6-----N---3": {POS: NOUN, "morph": "Case=Loc|Gender=Neut|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNNP6-----N---6": {POS: NOUN, "morph": "Case=Loc|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNNP6-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Loc|Gender=Neut|Number=Plur|Polarity=Neg"},
    "NNNP7-----A----": {POS: NOUN, "morph": "Case=Ins|Gender=Neut|Number=Plur|Polarity=Pos"},
    "NNNP7-----A---1": {POS: NOUN, "morph": "Case=Ins|Gender=Neut|Number=Plur|Polarity=Pos"},
    "NNNP7-----A---2": {POS: NOUN, "morph": "Case=Ins|Gender=Neut|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNNP7-----A---3": {POS: NOUN, "morph": "Case=Ins|Gender=Neut|Number=Plur|Polarity=Pos|Style=Arch"},
    "NNNP7-----A---6": {POS: NOUN, "morph": "Case=Ins|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNNP7-----A---7": {POS: NOUN, "morph": "Case=Ins|Gender=Neut|Number=Plur|Polarity=Pos|Style=Coll"},
    "NNNP7-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Ins|Gender=Neut|Number=Plur|Polarity=Pos"},
    "NNNP7-----N----": {POS: NOUN, "morph": "Case=Ins|Gender=Neut|Number=Plur|Polarity=Neg"},
    "NNNP7-----N---1": {POS: NOUN, "morph": "Case=Ins|Gender=Neut|Number=Plur|Polarity=Neg"},
    "NNNP7-----N---2": {POS: NOUN, "morph": "Case=Ins|Gender=Neut|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNNP7-----N---3": {POS: NOUN, "morph": "Case=Ins|Gender=Neut|Number=Plur|Polarity=Neg|Style=Arch"},
    "NNNP7-----N---6": {POS: NOUN, "morph": "Case=Ins|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNNP7-----N---7": {POS: NOUN, "morph": "Case=Ins|Gender=Neut|Number=Plur|Polarity=Neg|Style=Coll"},
    "NNNP7-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Ins|Gender=Neut|Number=Plur|Polarity=Neg"},
    "NNNPX-----A----": {POS: NOUN, "morph": "Gender=Neut|Number=Plur|Polarity=Pos"},
    "NNNPX-----A---1": {POS: NOUN, "morph": "Gender=Neut|Number=Plur|Polarity=Pos"},
    "NNNPX-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Gender=Neut|Number=Plur|Polarity=Pos"},
    "NNNPX-----N----": {POS: NOUN, "morph": "Gender=Neut|Number=Plur|Polarity=Neg"},
    "NNNPX-----N---1": {POS: NOUN, "morph": "Gender=Neut|Number=Plur|Polarity=Neg"},
    "NNNPX-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Gender=Neut|Number=Plur|Polarity=Neg"},
    "NNNS1-----A----": {POS: NOUN, "morph": "Case=Nom|Gender=Neut|Number=Sing|Polarity=Pos"},
    "NNNS1-----A---1": {POS: NOUN, "morph": "Case=Nom|Gender=Neut|Number=Sing|Polarity=Pos"},
    "NNNS1-----A---2": {POS: NOUN, "morph": "Case=Nom|Gender=Neut|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNNS1-----A---6": {POS: NOUN, "morph": "Case=Nom|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNNS1-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Nom|Gender=Neut|Number=Sing|Polarity=Pos"},
    "NNNS1-----N----": {POS: NOUN, "morph": "Case=Nom|Gender=Neut|Number=Sing|Polarity=Neg"},
    "NNNS1-----N---1": {POS: NOUN, "morph": "Case=Nom|Gender=Neut|Number=Sing|Polarity=Neg"},
    "NNNS1-----N---2": {POS: NOUN, "morph": "Case=Nom|Gender=Neut|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNNS1-----N---6": {POS: NOUN, "morph": "Case=Nom|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNNS1-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Nom|Gender=Neut|Number=Sing|Polarity=Neg"},
    "NNNS2-----A----": {POS: NOUN, "morph": "Case=Gen|Gender=Neut|Number=Sing|Polarity=Pos"},
    "NNNS2-----A---1": {POS: NOUN, "morph": "Case=Gen|Gender=Neut|Number=Sing|Polarity=Pos"},
    "NNNS2-----A---2": {POS: NOUN, "morph": "Case=Gen|Gender=Neut|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNNS2-----A---3": {POS: NOUN, "morph": "Case=Gen|Gender=Neut|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNNS2-----A---6": {POS: NOUN, "morph": "Case=Gen|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNNS2-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Gen|Gender=Neut|Number=Sing|Polarity=Pos"},
    "NNNS2-----N----": {POS: NOUN, "morph": "Case=Gen|Gender=Neut|Number=Sing|Polarity=Neg"},
    "NNNS2-----N---1": {POS: NOUN, "morph": "Case=Gen|Gender=Neut|Number=Sing|Polarity=Neg"},
    "NNNS2-----N---2": {POS: NOUN, "morph": "Case=Gen|Gender=Neut|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNNS2-----N---3": {POS: NOUN, "morph": "Case=Gen|Gender=Neut|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNNS2-----N---6": {POS: NOUN, "morph": "Case=Gen|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNNS2-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Gen|Gender=Neut|Number=Sing|Polarity=Neg"},
    "NNNS3-----A----": {POS: NOUN, "morph": "Case=Dat|Gender=Neut|Number=Sing|Polarity=Pos"},
    "NNNS3-----A---1": {POS: NOUN, "morph": "Case=Dat|Gender=Neut|Number=Sing|Polarity=Pos"},
    "NNNS3-----A---2": {POS: NOUN, "morph": "Case=Dat|Gender=Neut|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNNS3-----A---3": {POS: NOUN, "morph": "Case=Dat|Gender=Neut|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNNS3-----A---6": {POS: NOUN, "morph": "Case=Dat|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNNS3-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Dat|Gender=Neut|Number=Sing|Polarity=Pos"},
    "NNNS3-----N----": {POS: NOUN, "morph": "Case=Dat|Gender=Neut|Number=Sing|Polarity=Neg"},
    "NNNS3-----N---1": {POS: NOUN, "morph": "Case=Dat|Gender=Neut|Number=Sing|Polarity=Neg"},
    "NNNS3-----N---2": {POS: NOUN, "morph": "Case=Dat|Gender=Neut|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNNS3-----N---3": {POS: NOUN, "morph": "Case=Dat|Gender=Neut|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNNS3-----N---6": {POS: NOUN, "morph": "Case=Dat|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNNS3-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Dat|Gender=Neut|Number=Sing|Polarity=Neg"},
    "NNNS4-----A----": {POS: NOUN, "morph": "Case=Acc|Gender=Neut|Number=Sing|Polarity=Pos"},
    "NNNS4-----A---1": {POS: NOUN, "morph": "Case=Acc|Gender=Neut|Number=Sing|Polarity=Pos"},
    "NNNS4-----A---2": {POS: NOUN, "morph": "Case=Acc|Gender=Neut|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNNS4-----A---6": {POS: NOUN, "morph": "Case=Acc|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNNS4-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Acc|Gender=Neut|Number=Sing|Polarity=Pos"},
    "NNNS4-----N----": {POS: NOUN, "morph": "Case=Acc|Gender=Neut|Number=Sing|Polarity=Neg"},
    "NNNS4-----N---1": {POS: NOUN, "morph": "Case=Acc|Gender=Neut|Number=Sing|Polarity=Neg"},
    "NNNS4-----N---2": {POS: NOUN, "morph": "Case=Acc|Gender=Neut|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNNS4-----N---6": {POS: NOUN, "morph": "Case=Acc|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNNS4-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Acc|Gender=Neut|Number=Sing|Polarity=Neg"},
    "NNNS5-----A----": {POS: NOUN, "morph": "Case=Voc|Gender=Neut|Number=Sing|Polarity=Pos"},
    "NNNS5-----A---1": {POS: NOUN, "morph": "Case=Voc|Gender=Neut|Number=Sing|Polarity=Pos"},
    "NNNS5-----A---2": {POS: NOUN, "morph": "Case=Voc|Gender=Neut|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNNS5-----A---6": {POS: NOUN, "morph": "Case=Voc|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNNS5-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Voc|Gender=Neut|Number=Sing|Polarity=Pos"},
    "NNNS5-----N----": {POS: NOUN, "morph": "Case=Voc|Gender=Neut|Number=Sing|Polarity=Neg"},
    "NNNS5-----N---1": {POS: NOUN, "morph": "Case=Voc|Gender=Neut|Number=Sing|Polarity=Neg"},
    "NNNS5-----N---2": {POS: NOUN, "morph": "Case=Voc|Gender=Neut|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNNS5-----N---6": {POS: NOUN, "morph": "Case=Voc|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNNS5-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Voc|Gender=Neut|Number=Sing|Polarity=Neg"},
    "NNNS6-----A----": {POS: NOUN, "morph": "Case=Loc|Gender=Neut|Number=Sing|Polarity=Pos"},
    "NNNS6-----A---1": {POS: NOUN, "morph": "Case=Loc|Gender=Neut|Number=Sing|Polarity=Pos"},
    "NNNS6-----A---2": {POS: NOUN, "morph": "Case=Loc|Gender=Neut|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNNS6-----A---6": {POS: NOUN, "morph": "Case=Loc|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNNS6-----A---7": {POS: NOUN, "morph": "Case=Loc|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNNS6-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Loc|Gender=Neut|Number=Sing|Polarity=Pos"},
    "NNNS6-----N----": {POS: NOUN, "morph": "Case=Loc|Gender=Neut|Number=Sing|Polarity=Neg"},
    "NNNS6-----N---1": {POS: NOUN, "morph": "Case=Loc|Gender=Neut|Number=Sing|Polarity=Neg"},
    "NNNS6-----N---2": {POS: NOUN, "morph": "Case=Loc|Gender=Neut|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNNS6-----N---6": {POS: NOUN, "morph": "Case=Loc|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNNS6-----N---7": {POS: NOUN, "morph": "Case=Loc|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNNS6-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Loc|Gender=Neut|Number=Sing|Polarity=Neg"},
    "NNNS7-----A----": {POS: NOUN, "morph": "Case=Ins|Gender=Neut|Number=Sing|Polarity=Pos"},
    "NNNS7-----A---1": {POS: NOUN, "morph": "Case=Ins|Gender=Neut|Number=Sing|Polarity=Pos"},
    "NNNS7-----A---2": {POS: NOUN, "morph": "Case=Ins|Gender=Neut|Number=Sing|Polarity=Pos|Style=Arch"},
    "NNNS7-----A---6": {POS: NOUN, "morph": "Case=Ins|Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll"},
    "NNNS7-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Ins|Gender=Neut|Number=Sing|Polarity=Pos"},
    "NNNS7-----N----": {POS: NOUN, "morph": "Case=Ins|Gender=Neut|Number=Sing|Polarity=Neg"},
    "NNNS7-----N---1": {POS: NOUN, "morph": "Case=Ins|Gender=Neut|Number=Sing|Polarity=Neg"},
    "NNNS7-----N---2": {POS: NOUN, "morph": "Case=Ins|Gender=Neut|Number=Sing|Polarity=Neg|Style=Arch"},
    "NNNS7-----N---6": {POS: NOUN, "morph": "Case=Ins|Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll"},
    "NNNS7-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Case=Ins|Gender=Neut|Number=Sing|Polarity=Neg"},
    "NNNSX-----A----": {POS: NOUN, "morph": "Gender=Neut|Number=Sing|Polarity=Pos"},
    "NNNSX-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Gender=Neut|Number=Sing|Polarity=Pos"},
    "NNNSX-----N----": {POS: NOUN, "morph": "Gender=Neut|Number=Sing|Polarity=Neg"},
    "NNNSX-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Gender=Neut|Number=Sing|Polarity=Neg"},
    "NNNXX-----A----": {POS: NOUN, "morph": "Gender=Neut|Polarity=Pos"},
    "NNNXX-----A---1": {POS: NOUN, "morph": "Gender=Neut|Polarity=Pos"},
    "NNNXX-----A---2": {POS: NOUN, "morph": "Gender=Neut|Polarity=Pos|Style=Arch"},
    "NNNXX-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Gender=Neut|Polarity=Pos"},
    "NNNXX-----A---9": {POS: NOUN, "morph": "Gender=Neut|Polarity=Pos"},
    "NNNXX-----N----": {POS: NOUN, "morph": "Gender=Neut|Polarity=Neg"},
    "NNNXX-----N---1": {POS: NOUN, "morph": "Gender=Neut|Polarity=Neg"},
    "NNNXX-----N---2": {POS: NOUN, "morph": "Gender=Neut|Polarity=Neg|Style=Arch"},
    "NNNXX-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Gender=Neut|Polarity=Neg"},
    "NNNXX-----N---9": {POS: NOUN, "morph": "Gender=Neut|Polarity=Neg"},
    "NNXPX-----A----": {POS: NOUN, "morph": "Number=Plur|Polarity=Pos"},
    "NNXPX-----N----": {POS: NOUN, "morph": "Number=Plur|Polarity=Neg"},
    "NNXSX-----A----": {POS: NOUN, "morph": "Number=Sing|Polarity=Pos"},
    "NNXSX-----N----": {POS: NOUN, "morph": "Number=Sing|Polarity=Neg"},
    "NNXXX-----A----": {POS: NOUN, "morph": "Polarity=Pos"},
    "NNXXX-----A---8": {POS: NOUN, "morph": "Abbr=Yes|Polarity=Pos"},
    "NNXXX-----N----": {POS: NOUN, "morph": "Polarity=Neg"},
    "NNXXX-----N---8": {POS: NOUN, "morph": "Abbr=Yes|Polarity=Neg"},
    "P0-------------": {POS: PRON, "morph": "AdpType=Preppron|PronType=Prs"},
    "P1FD7FS3-------": {POS: DET,"morph": "Case=Ins|Gender=Fem|Gender[psor]=Fem|Number=Dual|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel"},
    "P1FD7FS3------2": {POS: DET,"morph": "Case=Ins|Gender=Fem|Gender[psor]=Fem|Number=Dual|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel|Style=Arch"},
    "P1FSXFS3-------": {POS: DET,"morph": "Gender=Fem|Gender[psor]=Fem|Number=Sing|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel"},
    "P1FSXFS3------2": {POS: DET,"morph": "Gender=Fem|Gender[psor]=Fem|Number=Sing|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel|Style=Arch"},
    "P1IS4FS3-------": {POS: DET,"morph": "Animacy=Inan|Case=Acc|Gender=Masc|Gender[psor]=Fem|Number=Sing|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel"},
    "P1IS4FS3------2": {POS: DET,"morph": "Animacy=Inan|Case=Acc|Gender=Masc|Gender[psor]=Fem|Number=Sing|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel|Style=Arch"},
    "P1MS4FS3-------": {POS: DET,"morph": "Animacy=Anim|Case=Acc|Gender=Masc|Gender[psor]=Fem|Number=Sing|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel"},
    "P1MS4FS3------2": {POS: DET,"morph": "Animacy=Anim|Case=Acc|Gender=Masc|Gender[psor]=Fem|Number=Sing|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel|Style=Arch"},
    "P1NS4FS3-------": {POS: DET,"morph": "Case=Acc|Gender=Neut|Gender[psor]=Fem|Number=Sing|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel"},
    "P1NS4FS3------2": {POS: DET,"morph": "Case=Acc|Gender=Neut|Gender[psor]=Fem|Number=Sing|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel|Style=Arch"},
    "P1XP1FS3-------": {POS: DET,"morph": "Case=Nom|Gender[psor]=Fem|Number=Plur|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel"},
    "P1XP1FS3------2": {POS: DET,"morph": "Case=Nom|Gender[psor]=Fem|Number=Plur|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel|Style=Arch"},
    "P1XP2FS3-------": {POS: DET,"morph": "Case=Gen|Gender[psor]=Fem|Number=Plur|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel"},
    "P1XP2FS3------2": {POS: DET,"morph": "Case=Gen|Gender[psor]=Fem|Number=Plur|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel|Style=Arch"},
    "P1XP3FS3-------": {POS: DET,"morph": "Case=Dat|Gender[psor]=Fem|Number=Plur|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel"},
    "P1XP3FS3------2": {POS: DET,"morph": "Case=Dat|Gender[psor]=Fem|Number=Plur|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel|Style=Arch"},
    "P1XP4FS3-------": {POS: DET,"morph": "Case=Acc|Gender[psor]=Fem|Number=Plur|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel"},
    "P1XP4FS3------2": {POS: DET,"morph": "Case=Acc|Gender[psor]=Fem|Number=Plur|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel|Style=Arch"},
    "P1XP6FS3-------": {POS: DET,"morph": "Case=Loc|Gender[psor]=Fem|Number=Plur|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel"},
    "P1XP6FS3------2": {POS: DET,"morph": "Case=Loc|Gender[psor]=Fem|Number=Plur|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel|Style=Arch"},
    "P1XP7FS3-------": {POS: DET,"morph": "Case=Ins|Gender[psor]=Fem|Number=Plur|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel"},
    "P1XP7FS3------2": {POS: DET,"morph": "Case=Ins|Gender[psor]=Fem|Number=Plur|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel|Style=Arch"},
    "P1XXXXP3-------": {POS: DET, "morph": "Number[psor]=Plur|Person=3|Poss=Yes|PronType=Rel"},
    "P1XXXXP3------2": {POS: DET, "morph": "Number[psor]=Plur|Person=3|Poss=Yes|PronType=Rel|Style=Arch"},
    "P1XXXZS3-------": {POS: DET, "morph": "Gender[psor]=Masc,Neut|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel"},
    "P1XXXZS3------2": {POS: DET,"morph": "Gender[psor]=Masc,Neut|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel|Style=Arch"},
    "P1ZS1FS3-------": {POS: DET,"morph": "Case=Nom|Gender=Masc,Neut|Gender[psor]=Fem|Number=Sing|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel"},
    "P1ZS1FS3------2": {POS: DET,"morph": "Case=Nom|Gender=Masc,Neut|Gender[psor]=Fem|Number=Sing|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel|Style=Arch"},
    "P1ZS2FS3-------": {POS: DET,"morph": "Case=Gen|Gender=Masc,Neut|Gender[psor]=Fem|Number=Sing|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel"},
    "P1ZS2FS3------2": {POS: DET,"morph": "Case=Gen|Gender=Masc,Neut|Gender[psor]=Fem|Number=Sing|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel|Style=Arch"},
    "P1ZS3FS3-------": {POS: DET,"morph": "Case=Dat|Gender=Masc,Neut|Gender[psor]=Fem|Number=Sing|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel"},
    "P1ZS3FS3------2": {POS: DET,"morph": "Case=Dat|Gender=Masc,Neut|Gender[psor]=Fem|Number=Sing|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel|Style=Arch"},
    "P1ZS6FS3-------": {POS: DET,"morph": "Case=Loc|Gender=Masc,Neut|Gender[psor]=Fem|Number=Sing|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel"},
    "P1ZS6FS3------2": {POS: DET,"morph": "Case=Loc|Gender=Masc,Neut|Gender[psor]=Fem|Number=Sing|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel|Style=Arch"},
    "P1ZS7FS3-------": {POS: DET,"morph": "Case=Ins|Gender=Masc,Neut|Gender[psor]=Fem|Number=Sing|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel"},
    "P1ZS7FS3------2": {POS: DET,"morph": "Case=Ins|Gender=Masc,Neut|Gender[psor]=Fem|Number=Sing|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Rel|Style=Arch"},
    "P4FD7----------": {POS: DET, "morph": "Case=Ins|Gender=Fem|Number=Dual|PronType=Int,Rel"},
    "P4FD7---------6": {POS: DET, "morph": "Case=Ins|Gender=Fem|Number=Dual|PronType=Int,Rel|Style=Coll"},
    "P4FP1----------": {POS: DET, "morph": "Case=Nom|Gender=Fem|Number=Plur|PronType=Int,Rel"},
    "P4FP1---------6": {POS: DET, "morph": "Case=Nom|Gender=Fem|Number=Plur|PronType=Int,Rel|Style=Coll"},
    "P4FP4----------": {POS: DET, "morph": "Case=Acc|Gender=Fem|Number=Plur|PronType=Int,Rel"},
    "P4FP4---------6": {POS: DET, "morph": "Case=Acc|Gender=Fem|Number=Plur|PronType=Int,Rel|Style=Coll"},
    "P4FS1----------": {POS: DET, "morph": "Case=Nom|Gender=Fem|Number=Sing|PronType=Int,Rel"},
    "P4FS1---------3": {POS: DET, "morph": "Case=Nom|Gender=Fem|Number=Sing|PronType=Int,Rel|Style=Arch"},
    "P4FS1---------6": {POS: DET, "morph": "Case=Nom|Gender=Fem|Number=Sing|PronType=Int,Rel|Style=Coll"},
    "P4FS2----------": {POS: DET, "morph": "Case=Gen|Gender=Fem|Number=Sing|PronType=Int,Rel"},
    "P4FS2---------6": {POS: DET, "morph": "Case=Gen|Gender=Fem|Number=Sing|PronType=Int,Rel|Style=Coll"},
    "P4FS3----------": {POS: DET, "morph": "Case=Dat|Gender=Fem|Number=Sing|PronType=Int,Rel"},
    "P4FS3---------6": {POS: DET, "morph": "Case=Dat|Gender=Fem|Number=Sing|PronType=Int,Rel|Style=Coll"},
    "P4FS4----------": {POS: DET, "morph": "Case=Acc|Gender=Fem|Number=Sing|PronType=Int,Rel"},
    "P4FS4---------6": {POS: DET, "morph": "Case=Acc|Gender=Fem|Number=Sing|PronType=Int,Rel|Style=Coll"},
    "P4FS6----------": {POS: DET, "morph": "Case=Loc|Gender=Fem|Number=Sing|PronType=Int,Rel"},
    "P4FS6---------6": {POS: DET, "morph": "Case=Loc|Gender=Fem|Number=Sing|PronType=Int,Rel|Style=Coll"},
    "P4FS7----------": {POS: DET, "morph": "Case=Ins|Gender=Fem|Number=Sing|PronType=Int,Rel"},
    "P4FS7---------6": {POS: DET, "morph": "Case=Ins|Gender=Fem|Number=Sing|PronType=Int,Rel|Style=Coll"},
    "P4IP1----------": {POS: DET, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|PronType=Int,Rel"},
    "P4IP1---------6": {POS: DET, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|PronType=Int,Rel|Style=Coll"},
    "P4IS4----------": {POS: DET, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|PronType=Int,Rel"},
    "P4IS4---------6": {POS: DET, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|PronType=Int,Rel|Style=Coll"},
    "P4MP1----------": {POS: DET, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|PronType=Int,Rel"},
    "P4MP1---------6": {POS: DET, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|PronType=Int,Rel|Style=Coll"},
    "P4MS4----------": {POS: DET, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|PronType=Int,Rel"},
    "P4MS4---------6": {POS: DET, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|PronType=Int,Rel|Style=Coll"},
    "P4NP1----------": {POS: DET, "morph": "Case=Nom|Gender=Neut|Number=Plur|PronType=Int,Rel"},
    "P4NP1---------6": {POS: DET, "morph": "Case=Nom|Gender=Neut|Number=Plur|PronType=Int,Rel|Style=Coll"},
    "P4NP1---------7": {POS: DET, "morph": "Case=Nom|Gender=Neut|Number=Plur|PronType=Int,Rel|Style=Coll"},
    "P4NP4----------": {POS: DET, "morph": "Case=Acc|Gender=Neut|Number=Plur|PronType=Int,Rel"},
    "P4NP4---------6": {POS: DET, "morph": "Case=Acc|Gender=Neut|Number=Plur|PronType=Int,Rel|Style=Coll"},
    "P4NS1----------": {POS: DET, "morph": "Case=Nom|Gender=Neut|Number=Sing|PronType=Int,Rel"},
    "P4NS1---------6": {POS: DET, "morph": "Case=Nom|Gender=Neut|Number=Sing|PronType=Int,Rel|Style=Coll"},
    "P4NS4----------": {POS: DET, "morph": "Case=Acc|Gender=Neut|Number=Sing|PronType=Int,Rel"},
    "P4NS4---------6": {POS: DET, "morph": "Case=Acc|Gender=Neut|Number=Sing|PronType=Int,Rel|Style=Coll"},
    "P4XD7----------": {POS: DET, "morph": "Case=Ins|Number=Dual|PronType=Int,Rel"},
    "P4XP2----------": {POS: DET, "morph": "Case=Gen|Number=Plur|PronType=Int,Rel"},
    "P4XP2---------6": {POS: DET, "morph": "Case=Gen|Number=Plur|PronType=Int,Rel|Style=Coll"},
    "P4XP3----------": {POS: DET, "morph": "Case=Dat|Number=Plur|PronType=Int,Rel"},
    "P4XP3---------6": {POS: DET, "morph": "Case=Dat|Number=Plur|PronType=Int,Rel|Style=Coll"},
    "P4XP6----------": {POS: DET, "morph": "Case=Loc|Number=Plur|PronType=Int,Rel"},
    "P4XP6---------6": {POS: DET, "morph": "Case=Loc|Number=Plur|PronType=Int,Rel|Style=Coll"},
    "P4XP7----------": {POS: DET, "morph": "Case=Ins|Number=Plur|PronType=Int,Rel"},
    "P4XP7---------6": {POS: DET, "morph": "Case=Ins|Number=Plur|PronType=Int,Rel|Style=Coll"},
    "P4XP7---------7": {POS: DET, "morph": "Case=Ins|Number=Plur|PronType=Int,Rel|Style=Coll"},
    "P4XXX----------": {POS: DET, "morph": "PronType=Int,Rel"},
    "P4YP4----------": {POS: DET, "morph": "Case=Acc|Gender=Masc|Number=Plur|PronType=Int,Rel"},
    "P4YP4---------6": {POS: DET, "morph": "Case=Acc|Gender=Masc|Number=Plur|PronType=Int,Rel|Style=Coll"},
    "P4YS1----------": {POS: DET, "morph": "Case=Nom|Gender=Masc|Number=Sing|PronType=Int,Rel"},
    "P4YS1---------3": {POS: DET, "morph": "Case=Nom|Gender=Masc|Number=Sing|PronType=Int,Rel|Style=Arch"},
    "P4YS1---------6": {POS: DET, "morph": "Case=Nom|Gender=Masc|Number=Sing|PronType=Int,Rel|Style=Coll"},
    "P4ZS2----------": {POS: DET, "morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|PronType=Int,Rel"},
    "P4ZS2---------6": {POS: DET, "morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|PronType=Int,Rel|Style=Coll"},
    "P4ZS3----------": {POS: DET, "morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|PronType=Int,Rel"},
    "P4ZS3---------6": {POS: DET, "morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|PronType=Int,Rel|Style=Coll"},
    "P4ZS6----------": {POS: DET, "morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|PronType=Int,Rel"},
    "P4ZS6---------6": {POS: DET, "morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|PronType=Int,Rel|Style=Coll"},
    "P4ZS7----------": {POS: DET, "morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|PronType=Int,Rel"},
    "P4ZS7---------6": {POS: DET, "morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|PronType=Int,Rel|Style=Coll"},
    "P5FS2--3-------": {POS: PRON, "morph": "Case=Gen|Gender=Fem|Number=Sing|Person=3|PrepCase=Pre|PronType=Prs"},
    "P5FS3--3-------": {POS: PRON, "morph": "Case=Dat|Gender=Fem|Number=Sing|Person=3|PrepCase=Pre|PronType=Prs"},
    "P5FS4--3-------": {POS: PRON, "morph": "Case=Acc|Gender=Fem|Number=Sing|Person=3|PrepCase=Pre|PronType=Prs"},
    "P5FS4--3------6": {POS: PRON,"morph": "Case=Acc|Gender=Fem|Number=Sing|Person=3|PrepCase=Pre|PronType=Prs|Style=Coll"},
    "P5FS6--3-------": {POS: PRON, "morph": "Case=Loc|Gender=Fem|Number=Sing|Person=3|PrepCase=Pre|PronType=Prs"},
    "P5FS7--3-------": {POS: PRON, "morph": "Case=Ins|Gender=Fem|Number=Sing|Person=3|PrepCase=Pre|PronType=Prs"},
    "P5NS4--3-------": {POS: PRON, "morph": "Case=Acc|Gender=Neut|Number=Sing|Person=3|PrepCase=Pre|PronType=Prs"},
    "P5XP2--3-------": {POS: PRON, "morph": "Case=Gen|Number=Plur|Person=3|PrepCase=Pre|PronType=Prs"},
    "P5XP3--3-------": {POS: PRON, "morph": "Case=Dat|Number=Plur|Person=3|PrepCase=Pre|PronType=Prs"},
    "P5XP4--3-------": {POS: PRON, "morph": "Case=Acc|Number=Plur|Person=3|PrepCase=Pre|PronType=Prs"},
    "P5XP6--3-------": {POS: PRON, "morph": "Case=Loc|Number=Plur|Person=3|PrepCase=Pre|PronType=Prs"},
    "P5XP7--3-------": {POS: PRON, "morph": "Case=Ins|Number=Plur|Person=3|PrepCase=Pre|PronType=Prs"},
    "P5ZS2--3-------": {POS: PRON, "morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|Person=3|PrepCase=Pre|PronType=Prs"},
    "P5ZS2--3------1": {POS: PRON, "morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|Person=3|PrepCase=Pre|PronType=Prs"},
    "P5ZS3--3-------": {POS: PRON, "morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|Person=3|PrepCase=Pre|PronType=Prs"},
    "P5ZS4--3-------": {POS: PRON, "morph": "Case=Acc|Gender=Masc,Neut|Number=Sing|Person=3|PrepCase=Pre|PronType=Prs"},
    "P5ZS4--3------1": {POS: PRON, "morph": "Case=Acc|Gender=Masc,Neut|Number=Sing|Person=3|PrepCase=Pre|PronType=Prs"},
    "P5ZS6--3-------": {POS: PRON, "morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|Person=3|PrepCase=Pre|PronType=Prs"},
    "P5ZS7--3-------": {POS: PRON, "morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|Person=3|PrepCase=Pre|PronType=Prs"},
    "P6-X2----------": {POS: PRON, "morph": "Case=Gen|PronType=Prs|Reflex=Yes"},
    "P6-X3----------": {POS: PRON, "morph": "Case=Dat|PronType=Prs|Reflex=Yes"},
    "P6-X4----------": {POS: PRON, "morph": "Case=Acc|PronType=Prs|Reflex=Yes"},
    "P6-X6----------": {POS: PRON, "morph": "Case=Loc|PronType=Prs|Reflex=Yes"},
    "P6-X7----------": {POS: PRON, "morph": "Case=Ins|PronType=Prs|Reflex=Yes"},
    "P7-S3----------": {POS: PRON, "morph": "Case=Dat|Number=Sing|PronType=Prs|Reflex=Yes|Variant=Short"},
    "P7-S3--2-------": {POS: PRON, "morph": "Case=Dat|Number=Sing|Person=2|PronType=Prs|Reflex=Yes|Variant=Short"},
    "P7-S4----------": {POS: PRON, "morph": "Case=Acc|Number=Sing|PronType=Prs|Reflex=Yes|Variant=Short"},
    "P7-S4--2-------": {POS: PRON, "morph": "Case=Acc|Number=Sing|Person=2|PronType=Prs|Reflex=Yes|Variant=Short"},
    "P7-X3----------": {POS: PRON, "morph": "Case=Dat|PronType=Prs|Reflex=Yes|Variant=Short"},
    "P7-X4----------": {POS: PRON, "morph": "Case=Acc|PronType=Prs|Reflex=Yes|Variant=Short"},
    "P8FD7----------": {POS: DET, "morph": "Case=Ins|Gender=Fem|Number=Dual|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8FD7---------6": {POS: DET,"morph": "Case=Ins|Gender=Fem|Number=Dual|Poss=Yes|PronType=Prs|Reflex=Yes|Style=Coll"},
    "P8FP1---------1": {POS: DET, "morph": "Case=Nom|Gender=Fem|Number=Plur|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8FP4---------1": {POS: DET, "morph": "Case=Acc|Gender=Fem|Number=Plur|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8FS1---------1": {POS: DET, "morph": "Case=Nom|Gender=Fem|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8FS2----------": {POS: DET, "morph": "Case=Gen|Gender=Fem|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8FS2---------1": {POS: DET, "morph": "Case=Gen|Gender=Fem|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8FS2---------6": {POS: DET,"morph": "Case=Gen|Gender=Fem|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes|Style=Coll"},
    "P8FS3----------": {POS: DET, "morph": "Case=Dat|Gender=Fem|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8FS3---------1": {POS: DET, "morph": "Case=Dat|Gender=Fem|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8FS3---------6": {POS: DET,"morph": "Case=Dat|Gender=Fem|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes|Style=Coll"},
    "P8FS4----------": {POS: DET, "morph": "Case=Acc|Gender=Fem|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8FS4---------1": {POS: DET, "morph": "Case=Acc|Gender=Fem|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8FS4---------6": {POS: DET,"morph": "Case=Acc|Gender=Fem|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes|Style=Coll"},
    "P8FS5---------1": {POS: DET, "morph": "Case=Voc|Gender=Fem|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8FS6----------": {POS: DET, "morph": "Case=Loc|Gender=Fem|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8FS6---------1": {POS: DET, "morph": "Case=Loc|Gender=Fem|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8FS6---------6": {POS: DET,"morph": "Case=Loc|Gender=Fem|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes|Style=Coll"},
    "P8FS7----------": {POS: DET, "morph": "Case=Ins|Gender=Fem|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8FS7---------1": {POS: DET, "morph": "Case=Ins|Gender=Fem|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8HP1----------": {POS: DET, "morph": "Case=Nom|Gender=Fem,Neut|Number=Plur|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8HP5----------": {POS: DET, "morph": "Case=Voc|Gender=Fem,Neut|Number=Plur|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8HP5---------7": {POS: DET,"morph": "Case=Voc|Gender=Fem,Neut|Number=Plur|Poss=Yes|PronType=Prs|Reflex=Yes|Style=Coll"},
    "P8HS1----------": {POS: DET, "morph": "Case=Nom|Gender=Fem,Neut|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8HS5----------": {POS: DET, "morph": "Case=Voc|Gender=Fem,Neut|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8IP1----------": {POS: DET,"morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8IP1---------1": {POS: DET,"morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8IP1---------7": {POS: DET,"morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|Poss=Yes|PronType=Prs|Reflex=Yes|Style=Coll"},
    "P8IP5----------": {POS: DET,"morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8IP5---------1": {POS: DET,"morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8IP5---------7": {POS: DET,"morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|Poss=Yes|PronType=Prs|Reflex=Yes|Style=Coll"},
    "P8IS4----------": {POS: DET,"morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8IS4---------6": {POS: DET,"morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes|Style=Coll"},
    "P8MP1----------": {POS: DET,"morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8MP1---------1": {POS: DET,"morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8MP5----------": {POS: DET,"morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8MP5---------1": {POS: DET,"morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8MS4----------": {POS: DET,"morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8MS4---------6": {POS: DET,"morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes|Style=Coll"},
    "P8NP1---------1": {POS: DET, "morph": "Case=Nom|Gender=Neut|Number=Plur|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8NP4---------1": {POS: DET, "morph": "Case=Acc|Gender=Neut|Number=Plur|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8NP5---------1": {POS: DET, "morph": "Case=Voc|Gender=Neut|Number=Plur|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8NS1---------1": {POS: DET, "morph": "Case=Nom|Gender=Neut|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8NS4----------": {POS: DET, "morph": "Case=Acc|Gender=Neut|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8NS4---------1": {POS: DET, "morph": "Case=Acc|Gender=Neut|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8NS5---------1": {POS: DET, "morph": "Case=Voc|Gender=Neut|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8XP2----------": {POS: DET, "morph": "Case=Gen|Number=Plur|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8XP2---------6": {POS: DET, "morph": "Case=Gen|Number=Plur|Poss=Yes|PronType=Prs|Reflex=Yes|Style=Coll"},
    "P8XP3----------": {POS: DET, "morph": "Case=Dat|Number=Plur|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8XP3---------6": {POS: DET, "morph": "Case=Dat|Number=Plur|Poss=Yes|PronType=Prs|Reflex=Yes|Style=Coll"},
    "P8XP4----------": {POS: DET, "morph": "Case=Acc|Number=Plur|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8XP4---------7": {POS: DET, "morph": "Case=Acc|Number=Plur|Poss=Yes|PronType=Prs|Reflex=Yes|Style=Coll"},
    "P8XP6----------": {POS: DET, "morph": "Case=Loc|Number=Plur|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8XP6---------6": {POS: DET, "morph": "Case=Loc|Number=Plur|Poss=Yes|PronType=Prs|Reflex=Yes|Style=Coll"},
    "P8XP7----------": {POS: DET, "morph": "Case=Ins|Number=Plur|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8YP4---------1": {POS: DET, "morph": "Case=Acc|Gender=Masc|Number=Plur|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8YS1----------": {POS: DET, "morph": "Case=Nom|Gender=Masc|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8YS1---------6": {POS: DET,"morph": "Case=Nom|Gender=Masc|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes|Style=Coll"},
    "P8YS5----------": {POS: DET, "morph": "Case=Voc|Gender=Masc|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8YS5---------6": {POS: DET,"morph": "Case=Voc|Gender=Masc|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes|Style=Coll"},
    "P8ZS2----------": {POS: DET, "morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8ZS2---------6": {POS: DET,"morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes|Style=Coll"},
    "P8ZS3----------": {POS: DET, "morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8ZS3---------6": {POS: DET,"morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes|Style=Coll"},
    "P8ZS6----------": {POS: DET, "morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8ZS6---------6": {POS: DET,"morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes|Style=Coll"},
    "P8ZS6---------7": {POS: DET,"morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes|Style=Coll"},
    "P8ZS7----------": {POS: DET, "morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes"},
    "P8ZS7---------6": {POS: DET,"morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|Poss=Yes|PronType=Prs|Reflex=Yes|Style=Coll"},
    "P9FS2----------": {POS: PRON, "morph": "Case=Gen|Gender=Fem|Number=Sing|PrepCase=Pre|PronType=Rel"},
    "P9FS2---------2": {POS: PRON, "morph": "Case=Gen|Gender=Fem|Number=Sing|PrepCase=Pre|PronType=Rel|Style=Arch"},
    "P9FS3----------": {POS: PRON, "morph": "Case=Dat|Gender=Fem|Number=Sing|PrepCase=Pre|PronType=Rel"},
    "P9FS3---------2": {POS: PRON, "morph": "Case=Dat|Gender=Fem|Number=Sing|PrepCase=Pre|PronType=Rel|Style=Arch"},
    "P9FS4----------": {POS: PRON, "morph": "Case=Acc|Gender=Fem|Number=Sing|PrepCase=Pre|PronType=Rel"},
    "P9FS4---------2": {POS: PRON, "morph": "Case=Acc|Gender=Fem|Number=Sing|PrepCase=Pre|PronType=Rel|Style=Arch"},
    "P9FS6----------": {POS: PRON, "morph": "Case=Loc|Gender=Fem|Number=Sing|PrepCase=Pre|PronType=Rel"},
    "P9FS6---------2": {POS: PRON, "morph": "Case=Loc|Gender=Fem|Number=Sing|PrepCase=Pre|PronType=Rel|Style=Arch"},
    "P9FS7----------": {POS: PRON, "morph": "Case=Ins|Gender=Fem|Number=Sing|PrepCase=Pre|PronType=Rel"},
    "P9FS7---------2": {POS: PRON, "morph": "Case=Ins|Gender=Fem|Number=Sing|PrepCase=Pre|PronType=Rel|Style=Arch"},
    "P9NS4----------": {POS: PRON, "morph": "Case=Acc|Gender=Neut|Number=Sing|PrepCase=Pre|PronType=Rel"},
    "P9NS4---------2": {POS: PRON, "morph": "Case=Acc|Gender=Neut|Number=Sing|PrepCase=Pre|PronType=Rel|Style=Arch"},
    "P9XP2----------": {POS: PRON, "morph": "Case=Gen|Number=Plur|PrepCase=Pre|PronType=Rel"},
    "P9XP2---------2": {POS: PRON, "morph": "Case=Gen|Number=Plur|PrepCase=Pre|PronType=Rel|Style=Arch"},
    "P9XP3----------": {POS: PRON, "morph": "Case=Dat|Number=Plur|PrepCase=Pre|PronType=Rel"},
    "P9XP3---------2": {POS: PRON, "morph": "Case=Dat|Number=Plur|PrepCase=Pre|PronType=Rel|Style=Arch"},
    "P9XP4----------": {POS: PRON, "morph": "Case=Acc|Number=Plur|PrepCase=Pre|PronType=Rel"},
    "P9XP4---------2": {POS: PRON, "morph": "Case=Acc|Number=Plur|PrepCase=Pre|PronType=Rel|Style=Arch"},
    "P9XP6----------": {POS: PRON, "morph": "Case=Loc|Number=Plur|PrepCase=Pre|PronType=Rel"},
    "P9XP6---------2": {POS: PRON, "morph": "Case=Loc|Number=Plur|PrepCase=Pre|PronType=Rel|Style=Arch"},
    "P9XP7----------": {POS: PRON, "morph": "Case=Ins|Number=Plur|PrepCase=Pre|PronType=Rel"},
    "P9XP7---------2": {POS: PRON, "morph": "Case=Ins|Number=Plur|PrepCase=Pre|PronType=Rel|Style=Arch"},
    "P9ZS2----------": {POS: PRON, "morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|PrepCase=Pre|PronType=Rel"},
    "P9ZS2---------1": {POS: PRON, "morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|PrepCase=Pre|PronType=Rel"},
    "P9ZS2---------2": {POS: PRON,"morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|PrepCase=Pre|PronType=Rel|Style=Arch"},
    "P9ZS2---------3": {POS: PRON,"morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|PrepCase=Pre|PronType=Rel|Style=Arch"},
    "P9ZS3----------": {POS: PRON, "morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|PrepCase=Pre|PronType=Rel"},
    "P9ZS3---------2": {POS: PRON,"morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|PrepCase=Pre|PronType=Rel|Style=Arch"},
    "P9ZS4----------": {POS: PRON, "morph": "Case=Acc|Gender=Masc,Neut|Number=Sing|PrepCase=Pre|PronType=Rel"},
    "P9ZS4---------1": {POS: PRON, "morph": "Case=Acc|Gender=Masc,Neut|Number=Sing|PrepCase=Pre|PronType=Rel"},
    "P9ZS4---------2": {POS: PRON,"morph": "Case=Acc|Gender=Masc,Neut|Number=Sing|PrepCase=Pre|PronType=Rel|Style=Arch"},
    "P9ZS4---------3": {POS: PRON,"morph": "Case=Acc|Gender=Masc,Neut|Number=Sing|PrepCase=Pre|PronType=Rel|Style=Arch"},
    "P9ZS6----------": {POS: PRON, "morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|PrepCase=Pre|PronType=Rel"},
    "P9ZS6---------2": {POS: PRON,"morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|PrepCase=Pre|PronType=Rel|Style=Arch"},
    "P9ZS7----------": {POS: PRON, "morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|PrepCase=Pre|PronType=Rel"},
    "P9ZS7---------2": {POS: PRON,"morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|PrepCase=Pre|PronType=Rel|Style=Arch"},
    "PDFD7----------": {POS: DET, "morph": "Case=Ins|Gender=Fem|Number=Dual|PronType=Dem"},
    "PDFD7---------2": {POS: DET, "morph": "Case=Ins|Gender=Fem|Number=Dual|PronType=Dem|Style=Arch"},
    "PDFD7---------5": {POS: DET, "morph": "Case=Ins|Gender=Fem|Number=Dual|PronType=Dem|Style=Coll"},
    "PDFD7---------6": {POS: DET, "morph": "Case=Ins|Gender=Fem|Number=Dual|PronType=Dem|Style=Coll"},
    "PDFP1----------": {POS: DET, "morph": "Case=Nom|Gender=Fem|Number=Plur|PronType=Dem"},
    "PDFP1---------5": {POS: DET, "morph": "Case=Nom|Gender=Fem|Number=Plur|PronType=Dem|Style=Coll"},
    "PDFP1---------6": {POS: DET, "morph": "Case=Nom|Gender=Fem|Number=Plur|PronType=Dem|Style=Coll"},
    "PDFP2----------": {POS: DET, "morph": "Case=Gen|Gender=Fem|Number=Plur|PronType=Dem"},
    "PDFP3----------": {POS: DET, "morph": "Case=Dat|Gender=Fem|Number=Plur|PronType=Dem"},
    "PDFP4----------": {POS: DET, "morph": "Case=Acc|Gender=Fem|Number=Plur|PronType=Dem"},
    "PDFP4---------5": {POS: DET, "morph": "Case=Acc|Gender=Fem|Number=Plur|PronType=Dem|Style=Coll"},
    "PDFP4---------6": {POS: DET, "morph": "Case=Acc|Gender=Fem|Number=Plur|PronType=Dem|Style=Coll"},
    "PDFP6----------": {POS: DET, "morph": "Case=Loc|Gender=Fem|Number=Plur|PronType=Dem"},
    "PDFP7----------": {POS: DET, "morph": "Case=Ins|Gender=Fem|Number=Plur|PronType=Dem"},
    "PDFS1----------": {POS: DET, "morph": "Case=Nom|Gender=Fem|Number=Sing|PronType=Dem"},
    "PDFS1---------5": {POS: DET, "morph": "Case=Nom|Gender=Fem|Number=Sing|PronType=Dem|Style=Coll"},
    "PDFS1---------6": {POS: DET, "morph": "Case=Nom|Gender=Fem|Number=Sing|PronType=Dem|Style=Coll"},
    "PDFS1---------8": {POS: DET, "morph": "Abbr=Yes|Case=Nom|Gender=Fem|Number=Sing|PronType=Dem"},
    "PDFS2----------": {POS: DET, "morph": "Case=Gen|Gender=Fem|Number=Sing|PronType=Dem"},
    "PDFS2---------5": {POS: DET, "morph": "Case=Gen|Gender=Fem|Number=Sing|PronType=Dem|Style=Coll"},
    "PDFS2---------6": {POS: DET, "morph": "Case=Gen|Gender=Fem|Number=Sing|PronType=Dem|Style=Coll"},
    "PDFS2---------8": {POS: DET, "morph": "Abbr=Yes|Case=Gen|Gender=Fem|Number=Sing|PronType=Dem"},
    "PDFS3----------": {POS: DET, "morph": "Case=Dat|Gender=Fem|Number=Sing|PronType=Dem"},
    "PDFS3---------5": {POS: DET, "morph": "Case=Dat|Gender=Fem|Number=Sing|PronType=Dem|Style=Coll"},
    "PDFS3---------6": {POS: DET, "morph": "Case=Dat|Gender=Fem|Number=Sing|PronType=Dem|Style=Coll"},
    "PDFS3---------8": {POS: DET, "morph": "Abbr=Yes|Case=Dat|Gender=Fem|Number=Sing|PronType=Dem"},
    "PDFS4----------": {POS: DET, "morph": "Case=Acc|Gender=Fem|Number=Sing|PronType=Dem"},
    "PDFS4---------5": {POS: DET, "morph": "Case=Acc|Gender=Fem|Number=Sing|PronType=Dem|Style=Coll"},
    "PDFS4---------6": {POS: DET, "morph": "Case=Acc|Gender=Fem|Number=Sing|PronType=Dem|Style=Coll"},
    "PDFS4---------8": {POS: DET, "morph": "Abbr=Yes|Case=Acc|Gender=Fem|Number=Sing|PronType=Dem"},
    "PDFS6----------": {POS: DET, "morph": "Case=Loc|Gender=Fem|Number=Sing|PronType=Dem"},
    "PDFS6---------5": {POS: DET, "morph": "Case=Loc|Gender=Fem|Number=Sing|PronType=Dem|Style=Coll"},
    "PDFS6---------6": {POS: DET, "morph": "Case=Loc|Gender=Fem|Number=Sing|PronType=Dem|Style=Coll"},
    "PDFS6---------8": {POS: DET, "morph": "Abbr=Yes|Case=Loc|Gender=Fem|Number=Sing|PronType=Dem"},
    "PDFS7----------": {POS: DET, "morph": "Case=Ins|Gender=Fem|Number=Sing|PronType=Dem"},
    "PDFS7---------5": {POS: DET, "morph": "Case=Ins|Gender=Fem|Number=Sing|PronType=Dem|Style=Coll"},
    "PDFS7---------6": {POS: DET, "morph": "Case=Ins|Gender=Fem|Number=Sing|PronType=Dem|Style=Coll"},
    "PDFS7---------8": {POS: DET, "morph": "Abbr=Yes|Case=Ins|Gender=Fem|Number=Sing|PronType=Dem"},
    "PDIP1----------": {POS: DET, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|PronType=Dem"},
    "PDIP1---------5": {POS: DET, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|PronType=Dem|Style=Coll"},
    "PDIP1---------6": {POS: DET, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|PronType=Dem|Style=Coll"},
    "PDIP2----------": {POS: DET, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Plur|PronType=Dem"},
    "PDIP3----------": {POS: DET, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Plur|PronType=Dem"},
    "PDIP4----------": {POS: DET, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Plur|PronType=Dem"},
    "PDIP4---------5": {POS: DET, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Plur|PronType=Dem|Style=Coll"},
    "PDIP4---------6": {POS: DET, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Plur|PronType=Dem|Style=Coll"},
    "PDIP6----------": {POS: DET, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Plur|PronType=Dem"},
    "PDIP7----------": {POS: DET, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Plur|PronType=Dem"},
    "PDIS1---------8": {POS: DET, "morph": "Abbr=Yes|Animacy=Inan|Case=Nom|Gender=Masc|Number=Sing|PronType=Dem"},
    "PDIS2----------": {POS: DET, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Sing|PronType=Dem"},
    "PDIS2---------8": {POS: DET, "morph": "Abbr=Yes|Animacy=Inan|Case=Gen|Gender=Masc|Number=Sing|PronType=Dem"},
    "PDIS3----------": {POS: DET, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Sing|PronType=Dem"},
    "PDIS3---------8": {POS: DET, "morph": "Abbr=Yes|Animacy=Inan|Case=Dat|Gender=Masc|Number=Sing|PronType=Dem"},
    "PDIS4----------": {POS: DET, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|PronType=Dem"},
    "PDIS4---------5": {POS: DET, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|PronType=Dem|Style=Coll"},
    "PDIS4---------6": {POS: DET, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|PronType=Dem|Style=Coll"},
    "PDIS4---------8": {POS: DET, "morph": "Abbr=Yes|Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|PronType=Dem"},
    "PDIS6----------": {POS: DET, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Sing|PronType=Dem"},
    "PDIS6---------8": {POS: DET, "morph": "Abbr=Yes|Animacy=Inan|Case=Loc|Gender=Masc|Number=Sing|PronType=Dem"},
    "PDIS7----------": {POS: DET, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Sing|PronType=Dem"},
    "PDIS7---------8": {POS: DET, "morph": "Abbr=Yes|Animacy=Inan|Case=Ins|Gender=Masc|Number=Sing|PronType=Dem"},
    "PDMP1----------": {POS: DET, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|PronType=Dem"},
    "PDMP1---------1": {POS: DET, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|PronType=Dem"},
    "PDMP1---------5": {POS: DET, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|PronType=Dem|Style=Coll"},
    "PDMP1---------6": {POS: DET, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|PronType=Dem|Style=Coll"},
    "PDMP2----------": {POS: DET, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Plur|PronType=Dem"},
    "PDMP3----------": {POS: DET, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Plur|PronType=Dem"},
    "PDMP4----------": {POS: DET, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Plur|PronType=Dem"},
    "PDMP4---------5": {POS: DET, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Plur|PronType=Dem|Style=Coll"},
    "PDMP4---------6": {POS: DET, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Plur|PronType=Dem|Style=Coll"},
    "PDMP6----------": {POS: DET, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Plur|PronType=Dem"},
    "PDMP7----------": {POS: DET, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Plur|PronType=Dem"},
    "PDMS1----------": {POS: DET, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Sing|PronType=Dem"},
    "PDMS1---------8": {POS: DET, "morph": "Abbr=Yes|Animacy=Anim|Case=Nom|Gender=Masc|Number=Sing|PronType=Dem"},
    "PDMS2----------": {POS: DET, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Sing|PronType=Dem"},
    "PDMS2---------8": {POS: DET, "morph": "Abbr=Yes|Animacy=Anim|Case=Gen|Gender=Masc|Number=Sing|PronType=Dem"},
    "PDMS3----------": {POS: DET, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Sing|PronType=Dem"},
    "PDMS3---------8": {POS: DET, "morph": "Abbr=Yes|Animacy=Anim|Case=Dat|Gender=Masc|Number=Sing|PronType=Dem"},
    "PDMS4----------": {POS: DET, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|PronType=Dem"},
    "PDMS4---------5": {POS: DET, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|PronType=Dem|Style=Coll"},
    "PDMS4---------6": {POS: DET, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|PronType=Dem|Style=Coll"},
    "PDMS4---------8": {POS: DET, "morph": "Abbr=Yes|Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|PronType=Dem"},
    "PDMS6---------8": {POS: DET, "morph": "Abbr=Yes|Animacy=Anim|Case=Loc|Gender=Masc|Number=Sing|PronType=Dem"},
    "PDMS7----------": {POS: DET, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Sing|PronType=Dem"},
    "PDMS7---------8": {POS: DET, "morph": "Abbr=Yes|Animacy=Anim|Case=Ins|Gender=Masc|Number=Sing|PronType=Dem"},
    "PDNP1----------": {POS: DET, "morph": "Case=Nom|Gender=Neut|Number=Plur|PronType=Dem"},
    "PDNP1---------5": {POS: DET, "morph": "Case=Nom|Gender=Neut|Number=Plur|PronType=Dem|Style=Coll"},
    "PDNP1---------6": {POS: DET, "morph": "Case=Nom|Gender=Neut|Number=Plur|PronType=Dem|Style=Coll"},
    "PDNP2----------": {POS: DET, "morph": "Case=Gen|Gender=Neut|Number=Plur|PronType=Dem"},
    "PDNP3----------": {POS: DET, "morph": "Case=Dat|Gender=Neut|Number=Plur|PronType=Dem"},
    "PDNP4----------": {POS: DET, "morph": "Case=Acc|Gender=Neut|Number=Plur|PronType=Dem"},
    "PDNP4---------5": {POS: DET, "morph": "Case=Acc|Gender=Neut|Number=Plur|PronType=Dem|Style=Coll"},
    "PDNP4---------6": {POS: DET, "morph": "Case=Acc|Gender=Neut|Number=Plur|PronType=Dem|Style=Coll"},
    "PDNP6----------": {POS: DET, "morph": "Case=Loc|Gender=Neut|Number=Plur|PronType=Dem"},
    "PDNP7----------": {POS: DET, "morph": "Case=Ins|Gender=Neut|Number=Plur|PronType=Dem"},
    "PDNS1----------": {POS: DET, "morph": "Case=Nom|Gender=Neut|Number=Sing|PronType=Dem"},
    "PDNS1---------2": {POS: DET, "morph": "Case=Nom|Gender=Neut|Number=Sing|PronType=Dem|Style=Arch"},
    "PDNS1---------5": {POS: DET, "morph": "Case=Nom|Gender=Neut|Number=Sing|PronType=Dem|Style=Coll"},
    "PDNS1---------6": {POS: DET, "morph": "Case=Nom|Gender=Neut|Number=Sing|PronType=Dem|Style=Coll"},
    "PDNS1---------8": {POS: DET, "morph": "Abbr=Yes|Case=Nom|Gender=Neut|Number=Sing|PronType=Dem"},
    "PDNS2----------": {POS: DET, "morph": "Case=Gen|Gender=Neut|Number=Sing|PronType=Dem"},
    "PDNS2---------8": {POS: DET, "morph": "Abbr=Yes|Case=Gen|Gender=Neut|Number=Sing|PronType=Dem"},
    "PDNS3----------": {POS: DET, "morph": "Case=Dat|Gender=Neut|Number=Sing|PronType=Dem"},
    "PDNS3---------8": {POS: DET, "morph": "Abbr=Yes|Case=Dat|Gender=Neut|Number=Sing|PronType=Dem"},
    "PDNS4----------": {POS: DET, "morph": "Case=Acc|Gender=Neut|Number=Sing|PronType=Dem"},
    "PDNS4---------2": {POS: DET, "morph": "Case=Acc|Gender=Neut|Number=Sing|PronType=Dem|Style=Arch"},
    "PDNS4---------5": {POS: DET, "morph": "Case=Acc|Gender=Neut|Number=Sing|PronType=Dem|Style=Coll"},
    "PDNS4---------6": {POS: DET, "morph": "Case=Acc|Gender=Neut|Number=Sing|PronType=Dem|Style=Coll"},
    "PDNS4---------8": {POS: DET, "morph": "Abbr=Yes|Case=Acc|Gender=Neut|Number=Sing|PronType=Dem"},
    "PDNS6----------": {POS: DET, "morph": "Case=Loc|Gender=Neut|Number=Sing|PronType=Dem"},
    "PDNS6---------8": {POS: DET, "morph": "Abbr=Yes|Case=Loc|Gender=Neut|Number=Sing|PronType=Dem"},
    "PDNS7----------": {POS: DET, "morph": "Case=Ins|Gender=Neut|Number=Sing|PronType=Dem"},
    "PDNS7---------8": {POS: DET, "morph": "Abbr=Yes|Case=Ins|Gender=Neut|Number=Sing|PronType=Dem"},
    "PDXP2----------": {POS: DET, "morph": "Case=Gen|Number=Plur|PronType=Dem"},
    "PDXP2---------1": {POS: DET, "morph": "Case=Gen|Number=Plur|PronType=Dem"},
    "PDXP2---------2": {POS: DET, "morph": "Case=Gen|Number=Plur|PronType=Dem|Style=Arch"},
    "PDXP2---------5": {POS: DET, "morph": "Case=Gen|Number=Plur|PronType=Dem|Style=Coll"},
    "PDXP2---------6": {POS: DET, "morph": "Case=Gen|Number=Plur|PronType=Dem|Style=Coll"},
    "PDXP3----------": {POS: DET, "morph": "Case=Dat|Number=Plur|PronType=Dem"},
    "PDXP3---------1": {POS: DET, "morph": "Case=Dat|Number=Plur|PronType=Dem"},
    "PDXP3---------2": {POS: DET, "morph": "Case=Dat|Number=Plur|PronType=Dem|Style=Arch"},
    "PDXP3---------5": {POS: DET, "morph": "Case=Dat|Number=Plur|PronType=Dem|Style=Coll"},
    "PDXP3---------6": {POS: DET, "morph": "Case=Dat|Number=Plur|PronType=Dem|Style=Coll"},
    "PDXP6----------": {POS: DET, "morph": "Case=Loc|Number=Plur|PronType=Dem"},
    "PDXP6---------1": {POS: DET, "morph": "Case=Loc|Number=Plur|PronType=Dem"},
    "PDXP6---------2": {POS: DET, "morph": "Case=Loc|Number=Plur|PronType=Dem|Style=Arch"},
    "PDXP6---------5": {POS: DET, "morph": "Case=Loc|Number=Plur|PronType=Dem|Style=Coll"},
    "PDXP6---------6": {POS: DET, "morph": "Case=Loc|Number=Plur|PronType=Dem|Style=Coll"},
    "PDXP7----------": {POS: DET, "morph": "Case=Ins|Number=Plur|PronType=Dem"},
    "PDXP7---------2": {POS: DET, "morph": "Case=Ins|Number=Plur|PronType=Dem|Style=Arch"},
    "PDXP7---------5": {POS: DET, "morph": "Case=Ins|Number=Plur|PronType=Dem|Style=Coll"},
    "PDXP7---------6": {POS: DET, "morph": "Case=Ins|Number=Plur|PronType=Dem|Style=Coll"},
    "PDXPX----------": {POS: DET, "morph": "Number=Plur|PronType=Dem"},
    "PDXPX---------8": {POS: DET, "morph": "Abbr=Yes|Number=Plur|PronType=Dem"},
    "PDXS1----------": {POS: DET, "morph": "Case=Nom|Number=Sing|PronType=Dem"},
    "PDXS2----------": {POS: DET, "morph": "Case=Gen|Number=Sing|PronType=Dem"},
    "PDXS3----------": {POS: DET, "morph": "Case=Dat|Number=Sing|PronType=Dem"},
    "PDXS4----------": {POS: DET, "morph": "Case=Acc|Number=Sing|PronType=Dem"},
    "PDXS6----------": {POS: DET, "morph": "Case=Loc|Number=Sing|PronType=Dem"},
    "PDXS7----------": {POS: DET, "morph": "Case=Ins|Number=Sing|PronType=Dem"},
    "PDXSX----------": {POS: DET, "morph": "Number=Sing|PronType=Dem"},
    "PDXSX---------8": {POS: DET, "morph": "Abbr=Yes|Number=Sing|PronType=Dem"},
    "PDXXX----------": {POS: DET, "morph": "PronType=Dem"},
    "PDXXX---------8": {POS: DET, "morph": "Abbr=Yes|PronType=Dem"},
    "PDYS1----------": {POS: DET, "morph": "Case=Nom|Gender=Masc|Number=Sing|PronType=Dem"},
    "PDYS1---------5": {POS: DET, "morph": "Case=Nom|Gender=Masc|Number=Sing|PronType=Dem|Style=Coll"},
    "PDYS1---------6": {POS: DET, "morph": "Case=Nom|Gender=Masc|Number=Sing|PronType=Dem|Style=Coll"},
    "PDYS4----------": {POS: DET, "morph": "Case=Acc|Gender=Masc|Number=Sing|PronType=Dem"},
    "PDZS2----------": {POS: DET, "morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|PronType=Dem"},
    "PDZS2---------5": {POS: DET, "morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|PronType=Dem|Style=Coll"},
    "PDZS2---------6": {POS: DET, "morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|PronType=Dem|Style=Coll"},
    "PDZS3----------": {POS: DET, "morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|PronType=Dem"},
    "PDZS3---------5": {POS: DET, "morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|PronType=Dem|Style=Coll"},
    "PDZS3---------6": {POS: DET, "morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|PronType=Dem|Style=Coll"},
    "PDZS6----------": {POS: DET, "morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|PronType=Dem"},
    "PDZS6---------1": {POS: DET, "morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|PronType=Dem"},
    "PDZS6---------2": {POS: DET, "morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|PronType=Dem|Style=Arch"},
    "PDZS6---------5": {POS: DET, "morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|PronType=Dem|Style=Coll"},
    "PDZS6---------6": {POS: DET, "morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|PronType=Dem|Style=Coll"},
    "PDZS7----------": {POS: DET, "morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|PronType=Dem"},
    "PDZS7---------5": {POS: DET, "morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|PronType=Dem|Style=Coll"},
    "PDZS7---------6": {POS: DET, "morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|PronType=Dem|Style=Coll"},
    "PE--1----------": {POS: PRON, "morph": "Case=Nom|PronType=Rel"},
    "PE--2----------": {POS: PRON, "morph": "Case=Gen|PronType=Rel"},
    "PE--3----------": {POS: PRON, "morph": "Case=Dat|PronType=Rel"},
    "PE--4----------": {POS: PRON, "morph": "Case=Acc|PronType=Rel"},
    "PE--6----------": {POS: PRON, "morph": "Case=Loc|PronType=Rel"},
    "PE--7----------": {POS: PRON, "morph": "Case=Ins|PronType=Rel"},
    "PH-S2--1-------": {POS: PRON, "morph": "Case=Gen|Number=Sing|Person=1|PronType=Prs|Variant=Short"},
    "PH-S2--2-------": {POS: PRON, "morph": "Case=Gen|Number=Sing|Person=2|PronType=Prs|Variant=Short"},
    "PH-S3--1-------": {POS: PRON, "morph": "Case=Dat|Number=Sing|Person=1|PronType=Prs|Variant=Short"},
    "PH-S3--2-------": {POS: PRON, "morph": "Case=Dat|Number=Sing|Person=2|PronType=Prs|Variant=Short"},
    "PH-S4--1-------": {POS: PRON, "morph": "Case=Acc|Number=Sing|Person=1|PronType=Prs|Variant=Short"},
    "PH-S4--2-------": {POS: PRON, "morph": "Case=Acc|Number=Sing|Person=2|PronType=Prs|Variant=Short"},
    "PHZS2--3-------": {POS: PRON,"morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|Person=3|PronType=Prs|Variant=Short"},
    "PHZS3--3-------": {POS: PRON,"morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|Person=3|PronType=Prs|Variant=Short"},
    "PHZS4--3-------": {POS: PRON,"morph": "Case=Acc|Gender=Masc,Neut|Number=Sing|Person=3|PronType=Prs|Variant=Short"},
    "PJFD7----------": {POS: PRON, "morph": "Case=Ins|Gender=Fem|Number=Dual|PrepCase=Npr|PronType=Rel"},
    "PJFP1----------": {POS: PRON, "morph": "Case=Nom|Gender=Fem|Number=Plur|PrepCase=Npr|PronType=Rel"},
    "PJFP4----------": {POS: PRON, "morph": "Case=Acc|Gender=Fem|Number=Plur|PrepCase=Npr|PronType=Rel"},
    "PJFS1----------": {POS: PRON, "morph": "Case=Nom|Gender=Fem|Number=Sing|PrepCase=Npr|PronType=Rel"},
    "PJFS1---------2": {POS: PRON, "morph": "Case=Nom|Gender=Fem|Number=Sing|PrepCase=Npr|PronType=Rel|Style=Arch"},
    "PJFS2----------": {POS: PRON, "morph": "Case=Gen|Gender=Fem|Number=Sing|PrepCase=Npr|PronType=Rel"},
    "PJFS2---------2": {POS: PRON, "morph": "Case=Gen|Gender=Fem|Number=Sing|PrepCase=Npr|PronType=Rel|Style=Arch"},
    "PJFS3----------": {POS: PRON, "morph": "Case=Dat|Gender=Fem|Number=Sing|PrepCase=Npr|PronType=Rel"},
    "PJFS3---------2": {POS: PRON, "morph": "Case=Dat|Gender=Fem|Number=Sing|PrepCase=Npr|PronType=Rel|Style=Arch"},
    "PJFS4----------": {POS: PRON, "morph": "Case=Acc|Gender=Fem|Number=Sing|PrepCase=Npr|PronType=Rel"},
    "PJFS4---------2": {POS: PRON, "morph": "Case=Acc|Gender=Fem|Number=Sing|PrepCase=Npr|PronType=Rel|Style=Arch"},
    "PJFS6----------": {POS: PRON, "morph": "Case=Loc|Gender=Fem|Number=Sing|PrepCase=Npr|PronType=Rel"},
    "PJFS7----------": {POS: PRON, "morph": "Case=Ins|Gender=Fem|Number=Sing|PrepCase=Npr|PronType=Rel"},
    "PJFS7---------2": {POS: PRON, "morph": "Case=Ins|Gender=Fem|Number=Sing|PrepCase=Npr|PronType=Rel|Style=Arch"},
    "PJIP1----------": {POS: PRON, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|PrepCase=Npr|PronType=Rel"},
    "PJIS4----------": {POS: PRON, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|PrepCase=Npr|PronType=Rel"},
    "PJIS4---------2": {POS: PRON,"morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|PrepCase=Npr|PronType=Rel|Style=Arch"},
    "PJMP1----------": {POS: PRON, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|PrepCase=Npr|PronType=Rel"},
    "PJMS4----------": {POS: PRON, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|PrepCase=Npr|PronType=Rel"},
    "PJMS4---------2": {POS: PRON,"morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|PrepCase=Npr|PronType=Rel|Style=Arch"},
    "PJNP1----------": {POS: PRON, "morph": "Case=Nom|Gender=Neut|Number=Plur|PrepCase=Npr|PronType=Rel"},
    "PJNP4----------": {POS: PRON, "morph": "Case=Acc|Gender=Neut|Number=Plur|PrepCase=Npr|PronType=Rel"},
    "PJNS1----------": {POS: PRON, "morph": "Case=Nom|Gender=Neut|Number=Sing|PrepCase=Npr|PronType=Rel"},
    "PJNS1---------2": {POS: PRON, "morph": "Case=Nom|Gender=Neut|Number=Sing|PrepCase=Npr|PronType=Rel|Style=Arch"},
    "PJNS4----------": {POS: PRON, "morph": "Case=Acc|Gender=Neut|Number=Sing|PrepCase=Npr|PronType=Rel"},
    "PJNS4---------2": {POS: PRON, "morph": "Case=Acc|Gender=Neut|Number=Sing|PrepCase=Npr|PronType=Rel|Style=Arch"},
    "PJXP1----------": {POS: PRON, "morph": "Case=Nom|Number=Plur|PrepCase=Npr|PronType=Rel"},
    "PJXP1---------2": {POS: PRON, "morph": "Case=Nom|Number=Plur|PrepCase=Npr|PronType=Rel|Style=Arch"},
    "PJXP2----------": {POS: PRON, "morph": "Case=Gen|Number=Plur|PrepCase=Npr|PronType=Rel"},
    "PJXP2---------2": {POS: PRON, "morph": "Case=Gen|Number=Plur|PrepCase=Npr|PronType=Rel|Style=Arch"},
    "PJXP3----------": {POS: PRON, "morph": "Case=Dat|Number=Plur|PrepCase=Npr|PronType=Rel"},
    "PJXP3---------2": {POS: PRON, "morph": "Case=Dat|Number=Plur|PrepCase=Npr|PronType=Rel|Style=Arch"},
    "PJXP4----------": {POS: PRON, "morph": "Case=Acc|Number=Plur|PrepCase=Npr|PronType=Rel"},
    "PJXP4---------2": {POS: PRON, "morph": "Case=Acc|Number=Plur|PrepCase=Npr|PronType=Rel|Style=Arch"},
    "PJXP6----------": {POS: PRON, "morph": "Case=Loc|Number=Plur|PrepCase=Npr|PronType=Rel"},
    "PJXP7----------": {POS: PRON, "morph": "Case=Ins|Number=Plur|PrepCase=Npr|PronType=Rel"},
    "PJXP7---------2": {POS: PRON, "morph": "Case=Ins|Number=Plur|PrepCase=Npr|PronType=Rel|Style=Arch"},
    "PJYP4----------": {POS: PRON, "morph": "Case=Acc|Gender=Masc|Number=Plur|PrepCase=Npr|PronType=Rel"},
    "PJYS1----------": {POS: PRON, "morph": "Case=Nom|Gender=Masc|Number=Sing|PrepCase=Npr|PronType=Rel"},
    "PJYS1---------2": {POS: PRON, "morph": "Case=Nom|Gender=Masc|Number=Sing|PrepCase=Npr|PronType=Rel|Style=Arch"},
    "PJZS2----------": {POS: PRON, "morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|PrepCase=Npr|PronType=Rel"},
    "PJZS2---------1": {POS: PRON, "morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|PrepCase=Npr|PronType=Rel"},
    "PJZS2---------2": {POS: PRON,"morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|PrepCase=Npr|PronType=Rel|Style=Arch"},
    "PJZS2---------3": {POS: PRON,"morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|PrepCase=Npr|PronType=Rel|Style=Arch"},
    "PJZS3----------": {POS: PRON, "morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|PrepCase=Npr|PronType=Rel"},
    "PJZS3---------2": {POS: PRON,"morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|PrepCase=Npr|PronType=Rel|Style=Arch"},
    "PJZS4---------1": {POS: PRON, "morph": "Case=Acc|Gender=Masc,Neut|Number=Sing|PrepCase=Npr|PronType=Rel"},
    "PJZS4---------3": {POS: PRON,"morph": "Case=Acc|Gender=Masc,Neut|Number=Sing|PrepCase=Npr|PronType=Rel|Style=Arch"},
    "PJZS6----------": {POS: PRON, "morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|PrepCase=Npr|PronType=Rel"},
    "PJZS7----------": {POS: PRON, "morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|PrepCase=Npr|PronType=Rel"},
    "PJZS7---------2": {POS: PRON,"morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|PrepCase=Npr|PronType=Rel|Style=Arch"},
    "PKM-1----------": {POS: PRON, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|PronType=Int,Rel"},
    "PKM-1---------1": {POS: PRON, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|PronType=Int,Rel"},
    "PKM-1---------2": {POS: PRON, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|PronType=Int,Rel|Style=Arch"},
    "PKM-1--2-------": {POS: PRON, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Person=2|PronType=Int,Rel"},
    "PKM-2----------": {POS: PRON, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|PronType=Int,Rel"},
    "PKM-2---------2": {POS: PRON, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|PronType=Int,Rel|Style=Arch"},
    "PKM-2--2-------": {POS: PRON, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Person=2|PronType=Int,Rel"},
    "PKM-3----------": {POS: PRON, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|PronType=Int,Rel"},
    "PKM-3---------2": {POS: PRON, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|PronType=Int,Rel|Style=Arch"},
    "PKM-3--2-------": {POS: PRON, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Person=2|PronType=Int,Rel"},
    "PKM-4----------": {POS: PRON, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|PronType=Int,Rel"},
    "PKM-4---------2": {POS: PRON, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|PronType=Int,Rel|Style=Arch"},
    "PKM-4--2-------": {POS: PRON, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Person=2|PronType=Int,Rel"},
    "PKM-6----------": {POS: PRON, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|PronType=Int,Rel"},
    "PKM-6---------2": {POS: PRON, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|PronType=Int,Rel|Style=Arch"},
    "PKM-6--2-------": {POS: PRON, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Person=2|PronType=Int,Rel"},
    "PKM-7----------": {POS: PRON, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|PronType=Int,Rel"},
    "PKM-7---------2": {POS: PRON, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|PronType=Int,Rel|Style=Arch"},
    "PKM-7--2-------": {POS: PRON, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Person=2|PronType=Int,Rel"},
    "PLFD7----------": {POS: PRON, "morph": "Case=Ins|Gender=Fem|Number=Dual|PronType=Tot"},
    "PLFP1----------": {POS: PRON, "morph": "Case=Nom|Gender=Fem|Number=Plur|PronType=Tot"},
    "PLFP1---------6": {POS: PRON, "morph": "Case=Nom|Gender=Fem|Number=Plur|PronType=Tot|Style=Coll"},
    "PLFP4----------": {POS: PRON, "morph": "Case=Acc|Gender=Fem|Number=Plur|PronType=Tot"},
    "PLFP5----------": {POS: PRON, "morph": "Case=Voc|Gender=Fem|Number=Plur|PronType=Tot"},
    "PLFS1----------": {POS: PRON, "morph": "Case=Nom|Gender=Fem|Number=Sing|PronType=Tot"},
    "PLFS2----------": {POS: PRON, "morph": "Case=Gen|Gender=Fem|Number=Sing|PronType=Tot"},
    "PLFS3----------": {POS: PRON, "morph": "Case=Dat|Gender=Fem|Number=Sing|PronType=Tot"},
    "PLFS4----------": {POS: PRON, "morph": "Case=Acc|Gender=Fem|Number=Sing|PronType=Tot"},
    "PLFS5----------": {POS: PRON, "morph": "Case=Voc|Gender=Fem|Number=Sing|PronType=Tot"},
    "PLFS5---------1": {POS: PRON, "morph": "Case=Voc|Gender=Fem|Number=Sing|PronType=Tot"},
    "PLFS6----------": {POS: PRON, "morph": "Case=Loc|Gender=Fem|Number=Sing|PronType=Tot"},
    "PLFS7----------": {POS: PRON, "morph": "Case=Ins|Gender=Fem|Number=Sing|PronType=Tot"},
    "PLIP1----------": {POS: PRON, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|PronType=Tot"},
    "PLIP1---------6": {POS: PRON, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|PronType=Tot|Style=Coll"},
    "PLIP5----------": {POS: PRON, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|PronType=Tot"},
    "PLIS4----------": {POS: PRON, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|PronType=Tot"},
    "PLIS4---------1": {POS: PRON, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|PronType=Tot"},
    "PLMP1----------": {POS: PRON, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|PronType=Tot"},
    "PLMP1---------6": {POS: PRON, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|PronType=Tot|Style=Coll"},
    "PLMP5----------": {POS: PRON, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|PronType=Tot"},
    "PLMS4----------": {POS: PRON, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|PronType=Tot"},
    "PLNP1----------": {POS: PRON, "morph": "Case=Nom|Gender=Neut|Number=Plur|PronType=Tot"},
    "PLNP1---------6": {POS: PRON, "morph": "Case=Nom|Gender=Neut|Number=Plur|PronType=Tot|Style=Coll"},
    "PLNP4----------": {POS: PRON, "morph": "Case=Acc|Gender=Neut|Number=Plur|PronType=Tot"},
    "PLNP5----------": {POS: PRON, "morph": "Case=Voc|Gender=Neut|Number=Plur|PronType=Tot"},
    "PLNS1----------": {POS: PRON, "morph": "Case=Nom|Gender=Neut|Number=Sing|PronType=Tot"},
    "PLNS1---------1": {POS: PRON, "morph": "Case=Nom|Gender=Neut|Number=Sing|PronType=Tot"},
    "PLNS1---------6": {POS: PRON, "morph": "Case=Nom|Gender=Neut|Number=Sing|PronType=Tot|Style=Coll"},
    "PLNS4----------": {POS: PRON, "morph": "Case=Acc|Gender=Neut|Number=Sing|PronType=Tot"},
    "PLNS4---------1": {POS: PRON, "morph": "Case=Acc|Gender=Neut|Number=Sing|PronType=Tot"},
    "PLNS4---------6": {POS: PRON, "morph": "Case=Acc|Gender=Neut|Number=Sing|PronType=Tot|Style=Coll"},
    "PLNS5----------": {POS: PRON, "morph": "Case=Voc|Gender=Neut|Number=Sing|PronType=Tot"},
    "PLNS5---------1": {POS: PRON, "morph": "Case=Voc|Gender=Neut|Number=Sing|PronType=Tot"},
    "PLXP2----------": {POS: PRON, "morph": "Case=Gen|Number=Plur|PronType=Tot"},
    "PLXP3----------": {POS: PRON, "morph": "Case=Dat|Number=Plur|PronType=Tot"},
    "PLXP6----------": {POS: PRON, "morph": "Case=Loc|Number=Plur|PronType=Tot"},
    "PLXP7----------": {POS: PRON, "morph": "Case=Ins|Number=Plur|PronType=Tot"},
    "PLXP7---------6": {POS: PRON, "morph": "Case=Ins|Number=Plur|PronType=Tot|Style=Coll"},
    "PLXXX----------": {POS: PRON, "morph": "PronType=Tot"},
    "PLXXX---------8": {POS: PRON, "morph": "Abbr=Yes|PronType=Tot"},
    "PLYP4----------": {POS: PRON, "morph": "Case=Acc|Gender=Masc|Number=Plur|PronType=Tot"},
    "PLYS1----------": {POS: PRON, "morph": "Case=Nom|Gender=Masc|Number=Sing|PronType=Tot"},
    "PLYS1---------1": {POS: PRON, "morph": "Case=Nom|Gender=Masc|Number=Sing|PronType=Tot"},
    "PLYS4----------": {POS: PRON, "morph": "Case=Acc|Gender=Masc|Number=Sing|PronType=Tot"},
    "PLYS5----------": {POS: PRON, "morph": "Case=Voc|Gender=Masc|Number=Sing|PronType=Tot"},
    "PLYS5---------1": {POS: PRON, "morph": "Case=Voc|Gender=Masc|Number=Sing|PronType=Tot"},
    "PLZS2----------": {POS: PRON, "morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|PronType=Tot"},
    "PLZS3----------": {POS: PRON, "morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|PronType=Tot"},
    "PLZS6----------": {POS: PRON, "morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|PronType=Tot"},
    "PLZS7----------": {POS: PRON, "morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|PronType=Tot"},
    "PPFP1--3-------": {POS: PRON, "morph": "Case=Nom|Gender=Fem|Number=Plur|Person=3|PronType=Prs"},
    "PPFP2--3-------": {POS: PRON, "morph": "Case=Gen|Gender=Fem|Number=Plur|Person=3|PronType=Prs"},
    "PPFP3--3-------": {POS: PRON, "morph": "Case=Dat|Gender=Fem|Number=Plur|Person=3|PronType=Prs"},
    "PPFP4--3-------": {POS: PRON, "morph": "Case=Acc|Gender=Fem|Number=Plur|Person=3|PronType=Prs"},
    "PPFP6--3-------": {POS: PRON, "morph": "Case=Loc|Gender=Fem|Number=Plur|Person=3|PronType=Prs"},
    "PPFP7--3-------": {POS: PRON, "morph": "Case=Ins|Gender=Fem|Number=Plur|Person=3|PronType=Prs"},
    "PPFPX--3-------": {POS: PRON, "morph": "Gender=Fem|Number=Plur|Person=3|PronType=Prs"},
    "PPFS1--3-------": {POS: PRON, "morph": "Case=Nom|Gender=Fem|Number=Sing|Person=3|PronType=Prs"},
    "PPFS2--3-------": {POS: PRON, "morph": "Case=Gen|Gender=Fem|Number=Sing|Person=3|PronType=Prs"},
    "PPFS3--3-------": {POS: PRON, "morph": "Case=Dat|Gender=Fem|Number=Sing|Person=3|PronType=Prs"},
    "PPFS4--3-------": {POS: PRON, "morph": "Case=Acc|Gender=Fem|Number=Sing|Person=3|PronType=Prs"},
    "PPFS6--3-------": {POS: PRON, "morph": "Case=Loc|Gender=Fem|Number=Sing|Person=3|PronType=Prs"},
    "PPFS7--3-------": {POS: PRON, "morph": "Case=Ins|Gender=Fem|Number=Sing|Person=3|PronType=Prs"},
    "PPFSX--3-------": {POS: PRON, "morph": "Gender=Fem|Number=Sing|Person=3|PronType=Prs"},
    "PPIP1--3-------": {POS: PRON, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|Person=3|PronType=Prs"},
    "PPIP2--3-------": {POS: PRON, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Plur|Person=3|PronType=Prs"},
    "PPIP3--3-------": {POS: PRON, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Plur|Person=3|PronType=Prs"},
    "PPIP4--3-------": {POS: PRON, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Plur|Person=3|PronType=Prs"},
    "PPIP6--3-------": {POS: PRON, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Plur|Person=3|PronType=Prs"},
    "PPIP7--3-------": {POS: PRON, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Plur|Person=3|PronType=Prs"},
    "PPIS2--3-------": {POS: PRON, "morph": "Animacy=Inan|Case=Gen|Gender=Masc|Number=Sing|Person=3|PronType=Prs"},
    "PPIS3--3-------": {POS: PRON, "morph": "Animacy=Inan|Case=Dat|Gender=Masc|Number=Sing|Person=3|PronType=Prs"},
    "PPIS4--3-------": {POS: PRON, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|Person=3|PronType=Prs"},
    "PPIS6--3-------": {POS: PRON, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Sing|Person=3|PronType=Prs"},
    "PPIS7--3-------": {POS: PRON, "morph": "Animacy=Inan|Case=Ins|Gender=Masc|Number=Sing|Person=3|PronType=Prs"},
    "PPMP1--3-------": {POS: PRON, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|Person=3|PronType=Prs"},
    "PPMP2--3-------": {POS: PRON, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Plur|Person=3|PronType=Prs"},
    "PPMP3--3-------": {POS: PRON, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Plur|Person=3|PronType=Prs"},
    "PPMP4--3-------": {POS: PRON, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Plur|Person=3|PronType=Prs"},
    "PPMP6--3-------": {POS: PRON, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Plur|Person=3|PronType=Prs"},
    "PPMP7--3-------": {POS: PRON, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Plur|Person=3|PronType=Prs"},
    "PPMPX--3-------": {POS: PRON, "morph": "Animacy=Anim|Gender=Masc|Number=Plur|Person=3|PronType=Prs"},
    "PPMS1--3-------": {POS: PRON, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Sing|Person=3|PronType=Prs"},
    "PPMS2--3-------": {POS: PRON, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|Number=Sing|Person=3|PronType=Prs"},
    "PPMS3--3-------": {POS: PRON, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|Number=Sing|Person=3|PronType=Prs"},
    "PPMS4--3-------": {POS: PRON, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|Person=3|PronType=Prs"},
    "PPMS6--3-------": {POS: PRON, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Sing|Person=3|PronType=Prs"},
    "PPMS7--3-------": {POS: PRON, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|Number=Sing|Person=3|PronType=Prs"},
    "PPMSX--3-------": {POS: PRON, "morph": "Animacy=Anim|Gender=Masc|Number=Sing|Person=3|PronType=Prs"},
    "PPNP1--3-------": {POS: PRON, "morph": "Case=Nom|Gender=Neut|Number=Plur|Person=3|PronType=Prs"},
    "PPNP2--3-------": {POS: PRON, "morph": "Case=Gen|Gender=Neut|Number=Plur|Person=3|PronType=Prs"},
    "PPNP3--3-------": {POS: PRON, "morph": "Case=Dat|Gender=Neut|Number=Plur|Person=3|PronType=Prs"},
    "PPNP4--3-------": {POS: PRON, "morph": "Case=Acc|Gender=Neut|Number=Plur|Person=3|PronType=Prs"},
    "PPNP7--3-------": {POS: PRON, "morph": "Case=Ins|Gender=Neut|Number=Plur|Person=3|PronType=Prs"},
    "PPNPX--3-------": {POS: PRON, "morph": "Gender=Neut|Number=Plur|Person=3|PronType=Prs"},
    "PPNS1--3-------": {POS: PRON, "morph": "Case=Nom|Gender=Neut|Number=Sing|Person=3|PronType=Prs"},
    "PPNS2--3-------": {POS: PRON, "morph": "Case=Gen|Gender=Neut|Number=Sing|Person=3|PronType=Prs"},
    "PPNS4--3-------": {POS: PRON, "morph": "Case=Acc|Gender=Neut|Number=Sing|Person=3|PronType=Prs"},
    "PPNS6--3-------": {POS: PRON, "morph": "Case=Loc|Gender=Neut|Number=Sing|Person=3|PronType=Prs"},
    "PPNS7--3-------": {POS: PRON, "morph": "Case=Ins|Gender=Neut|Number=Sing|Person=3|PronType=Prs"},
    "PPNSX--3-------": {POS: PRON, "morph": "Gender=Neut|Number=Sing|Person=3|PronType=Prs"},
    "PP-P1--1-------": {POS: PRON, "morph": "Case=Nom|Number=Plur|Person=1|PronType=Prs"},
    "PP-P1--2-------": {POS: PRON, "morph": "Case=Nom|Number=Plur|Person=2|PronType=Prs"},
    "PP-P2--1-------": {POS: PRON, "morph": "Case=Gen|Number=Plur|Person=1|PronType=Prs"},
    "PP-P2--2-------": {POS: PRON, "morph": "Case=Gen|Number=Plur|Person=2|PronType=Prs"},
    "PP-P3--1-------": {POS: PRON, "morph": "Case=Dat|Number=Plur|Person=1|PronType=Prs"},
    "PP-P3--2-------": {POS: PRON, "morph": "Case=Dat|Number=Plur|Person=2|PronType=Prs"},
    "PP-P4--1-------": {POS: PRON, "morph": "Case=Acc|Number=Plur|Person=1|PronType=Prs"},
    "PP-P4--2-------": {POS: PRON, "morph": "Case=Acc|Number=Plur|Person=2|PronType=Prs"},
    "PP-P5--1-------": {POS: PRON, "morph": "Case=Voc|Number=Plur|Person=1|PronType=Prs"},
    "PP-P5--2-------": {POS: PRON, "morph": "Case=Voc|Number=Plur|Person=2|PronType=Prs"},
    "PP-P6--1-------": {POS: PRON, "morph": "Case=Loc|Number=Plur|Person=1|PronType=Prs"},
    "PP-P6--2-------": {POS: PRON, "morph": "Case=Loc|Number=Plur|Person=2|PronType=Prs"},
    "PP-P7--1-------": {POS: PRON, "morph": "Case=Ins|Number=Plur|Person=1|PronType=Prs"},
    "PP-P7--1------6": {POS: PRON, "morph": "Case=Ins|Number=Plur|Person=1|PronType=Prs|Style=Coll"},
    "PP-P7--2-------": {POS: PRON, "morph": "Case=Ins|Number=Plur|Person=2|PronType=Prs"},
    "PP-PX--1-------": {POS: PRON, "morph": "Number=Plur|Person=1|PronType=Prs"},
    "PP-PX--2-------": {POS: PRON, "morph": "Number=Plur|Person=2|PronType=Prs"},
    "PP-S1--1-------": {POS: PRON, "morph": "Case=Nom|Number=Sing|Person=1|PronType=Prs"},
    "PP-S1--2-------": {POS: PRON, "morph": "Case=Nom|Number=Sing|Person=2|PronType=Prs"},
    "PP-S1--2P-AA---": {POS: PRON,"morph": "Case=Nom|Number=Sing|Person=2|Polarity=Pos|PronType=Prs|Tense=Pres|Voice=Act"},
    "PP-S2--1-------": {POS: PRON, "morph": "Case=Gen|Number=Sing|Person=1|PronType=Prs"},
    "PP-S2--2-------": {POS: PRON, "morph": "Case=Gen|Number=Sing|Person=2|PronType=Prs"},
    "PP-S3--1-------": {POS: PRON, "morph": "Case=Dat|Number=Sing|Person=1|PronType=Prs"},
    "PP-S3--2-------": {POS: PRON, "morph": "Case=Dat|Number=Sing|Person=2|PronType=Prs"},
    "PP-S4--1-------": {POS: PRON, "morph": "Case=Acc|Number=Sing|Person=1|PronType=Prs"},
    "PP-S4--2-------": {POS: PRON, "morph": "Case=Acc|Number=Sing|Person=2|PronType=Prs"},
    "PP-S5--1-------": {POS: PRON, "morph": "Case=Voc|Number=Sing|Person=1|PronType=Prs"},
    "PP-S5--2-------": {POS: PRON, "morph": "Case=Voc|Number=Sing|Person=2|PronType=Prs"},
    "PP-S6--1-------": {POS: PRON, "morph": "Case=Loc|Number=Sing|Person=1|PronType=Prs"},
    "PP-S6--2-------": {POS: PRON, "morph": "Case=Loc|Number=Sing|Person=2|PronType=Prs"},
    "PP-S7--1-------": {POS: PRON, "morph": "Case=Ins|Number=Sing|Person=1|PronType=Prs"},
    "PP-S7--2-------": {POS: PRON, "morph": "Case=Ins|Number=Sing|Person=2|PronType=Prs"},
    "PP-SX--1-------": {POS: PRON, "morph": "Number=Sing|Person=1|PronType=Prs"},
    "PP-SX--2-------": {POS: PRON, "morph": "Number=Sing|Person=2|PronType=Prs"},
    "PPXP1--3-------": {POS: PRON, "morph": "Case=Nom|Number=Plur|Person=3|PronType=Prs"},
    "PPXP2--3-------": {POS: PRON, "morph": "Case=Gen|Number=Plur|Person=3|PronType=Prs"},
    "PPXP3--3-------": {POS: PRON, "morph": "Case=Dat|Number=Plur|Person=3|PronType=Prs"},
    "PPXP4--3-------": {POS: PRON, "morph": "Case=Acc|Number=Plur|Person=3|PronType=Prs"},
    "PPXP7--3-------": {POS: PRON, "morph": "Case=Ins|Number=Plur|Person=3|PronType=Prs"},
    "PPXPX--3-------": {POS: PRON, "morph": "Number=Plur|Person=3|PronType=Prs"},
    "PPXS3--3-------": {POS: PRON, "morph": "Case=Dat|Number=Sing|Person=3|PronType=Prs"},
    "PP-XX--2-------": {POS: PRON, "morph": "Person=2|PronType=Prs"},
    "PPYS1--3-------": {POS: PRON, "morph": "Case=Nom|Gender=Masc|Number=Sing|Person=3|PronType=Prs"},
    "PPYS2--3-------": {POS: PRON, "morph": "Case=Gen|Gender=Masc|Number=Sing|Person=3|PronType=Prs"},
    "PPYS4--3-------": {POS: PRON, "morph": "Case=Acc|Gender=Masc|Number=Sing|Person=3|PronType=Prs"},
    "PPZS2--3------1": {POS: PRON, "morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|Person=3|PronType=Prs"},
    "PPZS3--3-------": {POS: PRON, "morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|Person=3|PronType=Prs"},
    "PPZS4--3------2": {POS: PRON, "morph": "Case=Acc|Gender=Masc,Neut|Number=Sing|Person=3|PronType=Prs|Style=Arch"},
    "PPZS7--3-------": {POS: PRON, "morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|Person=3|PronType=Prs"},
    "PQ--1----------": {POS: PRON, "morph": "Animacy=Inan|Case=Nom|PronType=Int,Rel"},
    "PQ--1---------9": {POS: PRON, "morph": "Animacy=Inan|Case=Nom|PronType=Int,Rel"},
    "PQ--2----------": {POS: PRON, "morph": "Animacy=Inan|Case=Gen|PronType=Int,Rel"},
    "PQ--2---------9": {POS: PRON, "morph": "Animacy=Inan|Case=Gen|PronType=Int,Rel"},
    "PQ--3----------": {POS: PRON, "morph": "Animacy=Inan|Case=Dat|PronType=Int,Rel"},
    "PQ--3---------9": {POS: PRON, "morph": "Animacy=Inan|Case=Dat|PronType=Int,Rel"},
    "PQ--4----------": {POS: PRON, "morph": "Animacy=Inan|Case=Acc|PronType=Int,Rel"},
    "PQ--4---------9": {POS: PRON, "morph": "Animacy=Inan|Case=Acc|PronType=Int,Rel"},
    "PQ--6----------": {POS: PRON, "morph": "Animacy=Inan|Case=Loc|PronType=Int,Rel"},
    "PQ--6---------9": {POS: PRON, "morph": "Animacy=Inan|Case=Loc|PronType=Int,Rel"},
    "PQ--7----------": {POS: PRON, "morph": "Animacy=Inan|Case=Ins|PronType=Int,Rel"},
    "PQ--7---------9": {POS: PRON, "morph": "Animacy=Inan|Case=Ins|PronType=Int,Rel"},
    "PQ--X----------": {POS: PRON, "morph": "Animacy=Inan|PronType=Int,Rel"},
    "PQ--X---------9": {POS: PRON, "morph": "Animacy=Inan|PronType=Int,Rel"},
    "PSFD7FS3-------": {POS: DET,"morph": "Case=Ins|Gender=Fem|Gender[psor]=Fem|Number=Dual|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Prs"},
    "PSFD7-P1-------": {POS: DET,"morph": "Case=Ins|Gender=Fem|Number=Dual|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSFD7-P2-------": {POS: DET,"morph": "Case=Ins|Gender=Fem|Number=Dual|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs"},
    "PSFD7-S1-------": {POS: DET,"morph": "Case=Ins|Gender=Fem|Number=Dual|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSFD7-S1------6": {POS: DET,"morph": "Case=Ins|Gender=Fem|Number=Dual|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSFD7-S2-------": {POS: DET,"morph": "Case=Ins|Gender=Fem|Number=Dual|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSFD7-S2------6": {POS: DET,"morph": "Case=Ins|Gender=Fem|Number=Dual|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSFP1-S1------1": {POS: DET,"morph": "Case=Nom|Gender=Fem|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSFP1-S2------1": {POS: DET,"morph": "Case=Nom|Gender=Fem|Number=Plur|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSFP4-S1------1": {POS: DET,"morph": "Case=Acc|Gender=Fem|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSFP4-S2------1": {POS: DET,"morph": "Case=Acc|Gender=Fem|Number=Plur|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSFPX-P1-------": {POS: DET, "morph": "Gender=Fem|Number=Plur|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSFPX-S1-------": {POS: DET, "morph": "Gender=Fem|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSFPX-X1-------": {POS: DET, "morph": "Gender=Fem|Number=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSFS1-S1------1": {POS: DET,"morph": "Case=Nom|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSFS1-S2------1": {POS: DET,"morph": "Case=Nom|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSFS2-P1-------": {POS: DET,"morph": "Case=Gen|Gender=Fem|Number=Sing|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSFS2-P2-------": {POS: DET,"morph": "Case=Gen|Gender=Fem|Number=Sing|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs"},
    "PSFS2-S1-------": {POS: DET,"morph": "Case=Gen|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSFS2-S1------1": {POS: DET,"morph": "Case=Gen|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSFS2-S1------6": {POS: DET,"morph": "Case=Gen|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSFS2-S2-------": {POS: DET,"morph": "Case=Gen|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSFS2-S2------1": {POS: DET,"morph": "Case=Gen|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSFS2-S2------6": {POS: DET,"morph": "Case=Gen|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSFS3-P1-------": {POS: DET,"morph": "Case=Dat|Gender=Fem|Number=Sing|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSFS3-P2-------": {POS: DET,"morph": "Case=Dat|Gender=Fem|Number=Sing|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs"},
    "PSFS3-S1-------": {POS: DET,"morph": "Case=Dat|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSFS3-S1------1": {POS: DET,"morph": "Case=Dat|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSFS3-S1------6": {POS: DET,"morph": "Case=Dat|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSFS3-S2-------": {POS: DET,"morph": "Case=Dat|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSFS3-S2------1": {POS: DET,"morph": "Case=Dat|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSFS3-S2------6": {POS: DET,"morph": "Case=Dat|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSFS4-P1-------": {POS: DET,"morph": "Case=Acc|Gender=Fem|Number=Sing|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSFS4-P1------6": {POS: DET,"morph": "Case=Acc|Gender=Fem|Number=Sing|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSFS4-P2-------": {POS: DET,"morph": "Case=Acc|Gender=Fem|Number=Sing|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs"},
    "PSFS4-P2------6": {POS: DET,"morph": "Case=Acc|Gender=Fem|Number=Sing|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSFS4-S1-------": {POS: DET,"morph": "Case=Acc|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSFS4-S1------1": {POS: DET,"morph": "Case=Acc|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSFS4-S1------6": {POS: DET,"morph": "Case=Acc|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSFS4-S2-------": {POS: DET,"morph": "Case=Acc|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSFS4-S2------1": {POS: DET,"morph": "Case=Acc|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSFS4-S2------6": {POS: DET,"morph": "Case=Acc|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSFS5-S1------1": {POS: DET,"morph": "Case=Voc|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSFS5-S2------1": {POS: DET,"morph": "Case=Voc|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSFS6-P1-------": {POS: DET,"morph": "Case=Loc|Gender=Fem|Number=Sing|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSFS6-P2-------": {POS: DET,"morph": "Case=Loc|Gender=Fem|Number=Sing|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs"},
    "PSFS6-S1-------": {POS: DET,"morph": "Case=Loc|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSFS6-S1------1": {POS: DET,"morph": "Case=Loc|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSFS6-S1------6": {POS: DET,"morph": "Case=Loc|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSFS6-S2-------": {POS: DET,"morph": "Case=Loc|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSFS6-S2------1": {POS: DET,"morph": "Case=Loc|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSFS6-S2------6": {POS: DET,"morph": "Case=Loc|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSFS7-P1-------": {POS: DET,"morph": "Case=Ins|Gender=Fem|Number=Sing|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSFS7-P2-------": {POS: DET,"morph": "Case=Ins|Gender=Fem|Number=Sing|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs"},
    "PSFS7-S1-------": {POS: DET,"morph": "Case=Ins|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSFS7-S1------1": {POS: DET,"morph": "Case=Ins|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSFS7-S2-------": {POS: DET,"morph": "Case=Ins|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSFS7-S2------1": {POS: DET,"morph": "Case=Ins|Gender=Fem|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSFSXFS3-------": {POS: DET,"morph": "Gender=Fem|Gender[psor]=Fem|Number=Sing|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Prs"},
    "PSFSX-P1-------": {POS: DET, "morph": "Gender=Fem|Number=Sing|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSFSX-S1-------": {POS: DET, "morph": "Gender=Fem|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSFSX-X1-------": {POS: DET, "morph": "Gender=Fem|Number=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSHP1-P1-------": {POS: DET,"morph": "Case=Nom|Gender=Fem,Neut|Number=Plur|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSHP1-P2-------": {POS: DET,"morph": "Case=Nom|Gender=Fem,Neut|Number=Plur|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs"},
    "PSHP1-S1-------": {POS: DET,"morph": "Case=Nom|Gender=Fem,Neut|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSHP1-S2-------": {POS: DET,"morph": "Case=Nom|Gender=Fem,Neut|Number=Plur|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSHP5-S1-------": {POS: DET,"morph": "Case=Voc|Gender=Fem,Neut|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSHP5-S1------7": {POS: DET,"morph": "Case=Voc|Gender=Fem,Neut|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSHP5-S2-------": {POS: DET,"morph": "Case=Voc|Gender=Fem,Neut|Number=Plur|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSHP5-S2------7": {POS: DET,"morph": "Case=Voc|Gender=Fem,Neut|Number=Plur|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSHS1-P1-------": {POS: DET,"morph": "Case=Nom|Gender=Fem,Neut|Number=Sing|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSHS1-P2-------": {POS: DET,"morph": "Case=Nom|Gender=Fem,Neut|Number=Sing|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs"},
    "PSHS1-S1-------": {POS: DET,"morph": "Case=Nom|Gender=Fem,Neut|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSHS1-S2-------": {POS: DET,"morph": "Case=Nom|Gender=Fem,Neut|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSHS5-P1-------": {POS: DET,"morph": "Case=Voc|Gender=Fem,Neut|Number=Sing|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSHS5-P2-------": {POS: DET,"morph": "Case=Voc|Gender=Fem,Neut|Number=Sing|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs"},
    "PSHS5-S1-------": {POS: DET,"morph": "Case=Voc|Gender=Fem,Neut|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSHS5-S2-------": {POS: DET,"morph": "Case=Voc|Gender=Fem,Neut|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSIP1-P1-------": {POS: DET,"morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSIP1-P2-------": {POS: DET,"morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs"},
    "PSIP1-S1-------": {POS: DET,"morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSIP1-S1------1": {POS: DET,"morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSIP1-S1------7": {POS: DET,"morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSIP1-S2-------": {POS: DET,"morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSIP1-S2------1": {POS: DET,"morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSIP1-S2------7": {POS: DET,"morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSIP5-S1-------": {POS: DET,"morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSIP5-S1------1": {POS: DET,"morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSIP5-S1------7": {POS: DET,"morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSIP5-S2-------": {POS: DET,"morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSIP5-S2------1": {POS: DET,"morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSIP5-S2------7": {POS: DET,"morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSIPX-P1-------": {POS: DET,"morph": "Animacy=Inan|Gender=Masc|Number=Plur|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSIPX-S1-------": {POS: DET,"morph": "Animacy=Inan|Gender=Masc|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSIPX-X1-------": {POS: DET, "morph": "Animacy=Inan|Gender=Masc|Number=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSIS4FS3-------": {POS: DET,"morph": "Animacy=Inan|Case=Acc|Gender=Masc|Gender[psor]=Fem|Number=Sing|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Prs"},
    "PSIS4-P1-------": {POS: DET,"morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSIS4-P2-------": {POS: DET,"morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs"},
    "PSIS4-S1-------": {POS: DET,"morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSIS4-S1------6": {POS: DET,"morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSIS4-S2-------": {POS: DET,"morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSIS4-S2------6": {POS: DET,"morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSISX-P1-------": {POS: DET,"morph": "Animacy=Inan|Gender=Masc|Number=Sing|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSISX-S1-------": {POS: DET,"morph": "Animacy=Inan|Gender=Masc|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSISX-X1-------": {POS: DET, "morph": "Animacy=Inan|Gender=Masc|Number=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSMP1-P1-------": {POS: DET,"morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSMP1-P2-------": {POS: DET,"morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs"},
    "PSMP1-S1-------": {POS: DET,"morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSMP1-S1------1": {POS: DET,"morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSMP1-S1------7": {POS: DET,"morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSMP1-S2-------": {POS: DET,"morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSMP1-S2------1": {POS: DET,"morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSMP5-P1-------": {POS: DET,"morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSMP5-P2-------": {POS: DET,"morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs"},
    "PSMP5-S1-------": {POS: DET,"morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSMP5-S1------1": {POS: DET,"morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSMP5-S1------7": {POS: DET,"morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSMP5-S2-------": {POS: DET,"morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSMP5-S2------1": {POS: DET,"morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSMPX-P1-------": {POS: DET,"morph": "Animacy=Anim|Gender=Masc|Number=Plur|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSMPX-S1-------": {POS: DET,"morph": "Animacy=Anim|Gender=Masc|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSMPX-X1-------": {POS: DET, "morph": "Animacy=Anim|Gender=Masc|Number=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSMS4FS3-------": {POS: DET,"morph": "Animacy=Anim|Case=Acc|Gender=Masc|Gender[psor]=Fem|Number=Sing|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Prs"},
    "PSMS4-P1-------": {POS: DET,"morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSMS4-P2-------": {POS: DET,"morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs"},
    "PSMS4-S1-------": {POS: DET,"morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSMS4-S1------6": {POS: DET,"morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSMS4-S2-------": {POS: DET,"morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSMS4-S2------6": {POS: DET,"morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSMSX-P1-------": {POS: DET,"morph": "Animacy=Anim|Gender=Masc|Number=Sing|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSMSX-S1-------": {POS: DET,"morph": "Animacy=Anim|Gender=Masc|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSMSX-X1-------": {POS: DET, "morph": "Animacy=Anim|Gender=Masc|Number=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSNP1-S1------1": {POS: DET,"morph": "Case=Nom|Gender=Neut|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSNP1-S2------1": {POS: DET,"morph": "Case=Nom|Gender=Neut|Number=Plur|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSNP4-S1------1": {POS: DET,"morph": "Case=Acc|Gender=Neut|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSNP4-S2------1": {POS: DET,"morph": "Case=Acc|Gender=Neut|Number=Plur|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSNP5-S1------1": {POS: DET,"morph": "Case=Voc|Gender=Neut|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSNP5-S2------1": {POS: DET,"morph": "Case=Voc|Gender=Neut|Number=Plur|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSNPX-P1-------": {POS: DET, "morph": "Gender=Neut|Number=Plur|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSNPX-S1-------": {POS: DET, "morph": "Gender=Neut|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSNPX-X1-------": {POS: DET, "morph": "Gender=Neut|Number=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSNS1-S1------1": {POS: DET,"morph": "Case=Nom|Gender=Neut|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSNS1-S2------1": {POS: DET,"morph": "Case=Nom|Gender=Neut|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSNS4FS3-------": {POS: DET,"morph": "Case=Acc|Gender=Neut|Gender[psor]=Fem|Number=Sing|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Prs"},
    "PSNS4-P1-------": {POS: DET,"morph": "Case=Acc|Gender=Neut|Number=Sing|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSNS4-P2-------": {POS: DET,"morph": "Case=Acc|Gender=Neut|Number=Sing|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs"},
    "PSNS4-S1-------": {POS: DET,"morph": "Case=Acc|Gender=Neut|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSNS4-S1------1": {POS: DET,"morph": "Case=Acc|Gender=Neut|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSNS4-S2-------": {POS: DET,"morph": "Case=Acc|Gender=Neut|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSNS4-S2------1": {POS: DET,"morph": "Case=Acc|Gender=Neut|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSNS5-S1------1": {POS: DET,"morph": "Case=Voc|Gender=Neut|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSNS5-S2------1": {POS: DET,"morph": "Case=Voc|Gender=Neut|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSNSX-P1-------": {POS: DET, "morph": "Gender=Neut|Number=Sing|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSNSX-S1-------": {POS: DET, "morph": "Gender=Neut|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSNSX-X1-------": {POS: DET, "morph": "Gender=Neut|Number=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSXP1FS3-------": {POS: DET,"morph": "Case=Nom|Gender[psor]=Fem|Number=Plur|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Prs"},
    "PSXP2FS3-------": {POS: DET,"morph": "Case=Gen|Gender[psor]=Fem|Number=Plur|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Prs"},
    "PSXP2-P1-------": {POS: DET, "morph": "Case=Gen|Number=Plur|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSXP2-P2-------": {POS: DET, "morph": "Case=Gen|Number=Plur|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs"},
    "PSXP2-S1-------": {POS: DET, "morph": "Case=Gen|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSXP2-S1------6": {POS: DET,"morph": "Case=Gen|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSXP2-S2-------": {POS: DET, "morph": "Case=Gen|Number=Plur|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSXP2-S2------6": {POS: DET,"morph": "Case=Gen|Number=Plur|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSXP3FS3-------": {POS: DET,"morph": "Case=Dat|Gender[psor]=Fem|Number=Plur|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Prs"},
    "PSXP3-P1-------": {POS: DET, "morph": "Case=Dat|Number=Plur|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSXP3-P2-------": {POS: DET, "morph": "Case=Dat|Number=Plur|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs"},
    "PSXP3-S1-------": {POS: DET, "morph": "Case=Dat|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSXP3-S1------6": {POS: DET,"morph": "Case=Dat|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSXP3-S2-------": {POS: DET, "morph": "Case=Dat|Number=Plur|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSXP3-S2------6": {POS: DET,"morph": "Case=Dat|Number=Plur|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSXP4FS3-------": {POS: DET,"morph": "Case=Acc|Gender[psor]=Fem|Number=Plur|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Prs"},
    "PSXP4-P1-------": {POS: DET, "morph": "Case=Acc|Number=Plur|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSXP4-P2-------": {POS: DET, "morph": "Case=Acc|Number=Plur|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs"},
    "PSXP4-S1-------": {POS: DET, "morph": "Case=Acc|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSXP4-S1------7": {POS: DET,"morph": "Case=Acc|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSXP4-S2-------": {POS: DET, "morph": "Case=Acc|Number=Plur|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSXP4-S2------7": {POS: DET,"morph": "Case=Acc|Number=Plur|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSXP5FS3-------": {POS: DET,"morph": "Case=Voc|Gender[psor]=Fem|Number=Plur|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Prs"},
    "PSXP6FS3-------": {POS: DET,"morph": "Case=Loc|Gender[psor]=Fem|Number=Plur|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Prs"},
    "PSXP6-P1-------": {POS: DET, "morph": "Case=Loc|Number=Plur|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSXP6-P2-------": {POS: DET, "morph": "Case=Loc|Number=Plur|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs"},
    "PSXP6-S1-------": {POS: DET, "morph": "Case=Loc|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSXP6-S1------6": {POS: DET,"morph": "Case=Loc|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSXP6-S2-------": {POS: DET, "morph": "Case=Loc|Number=Plur|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSXP6-S2------6": {POS: DET,"morph": "Case=Loc|Number=Plur|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSXP7FS3-------": {POS: DET,"morph": "Case=Ins|Gender[psor]=Fem|Number=Plur|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Prs"},
    "PSXP7FS3------6": {POS: DET,"morph": "Case=Ins|Gender[psor]=Fem|Number=Plur|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSXP7-P1-------": {POS: DET, "morph": "Case=Ins|Number=Plur|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSXP7-P1------6": {POS: DET,"morph": "Case=Ins|Number=Plur|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSXP7-P2-------": {POS: DET, "morph": "Case=Ins|Number=Plur|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs"},
    "PSXP7-P2------6": {POS: DET,"morph": "Case=Ins|Number=Plur|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSXP7-S1-------": {POS: DET, "morph": "Case=Ins|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSXP7-S2-------": {POS: DET, "morph": "Case=Ins|Number=Plur|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSXXXNS3-------": {POS: DET, "morph": "Gender[psor]=Neut|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Prs"},
    "PSXXX-P1-------": {POS: DET, "morph": "Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSXXX-S1-------": {POS: DET, "morph": "Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSXXX-X2-------": {POS: DET, "morph": "Person=2|Poss=Yes|PronType=Prs"},
    "PSXXXXP3-------": {POS: DET, "morph": "Number[psor]=Plur|Person=3|Poss=Yes|PronType=Prs"},
    "PSXXXYS3-------": {POS: DET, "morph": "Gender[psor]=Masc|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Prs"},
    "PSXXXZS3-------": {POS: DET, "morph": "Gender[psor]=Masc,Neut|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Prs"},
    "PSYP4-S1------1": {POS: DET,"morph": "Case=Acc|Gender=Masc|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSYP4-S1------7": {POS: DET,"morph": "Case=Acc|Gender=Masc|Number=Plur|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSYP4-S2------1": {POS: DET,"morph": "Case=Acc|Gender=Masc|Number=Plur|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSYS1-P1-------": {POS: DET,"morph": "Case=Nom|Gender=Masc|Number=Sing|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSYS1-P2-------": {POS: DET,"morph": "Case=Nom|Gender=Masc|Number=Sing|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs"},
    "PSYS1-S1-------": {POS: DET,"morph": "Case=Nom|Gender=Masc|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSYS1-S1------6": {POS: DET,"morph": "Case=Nom|Gender=Masc|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSYS1-S2-------": {POS: DET,"morph": "Case=Nom|Gender=Masc|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSYS1-S2------6": {POS: DET,"morph": "Case=Nom|Gender=Masc|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSYS5-P1-------": {POS: DET,"morph": "Case=Voc|Gender=Masc|Number=Sing|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSYS5-P2-------": {POS: DET,"morph": "Case=Voc|Gender=Masc|Number=Sing|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs"},
    "PSYS5-S1-------": {POS: DET,"morph": "Case=Voc|Gender=Masc|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSYS5-S1------6": {POS: DET,"morph": "Case=Voc|Gender=Masc|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSYS5-S2-------": {POS: DET,"morph": "Case=Voc|Gender=Masc|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSYS5-S2------6": {POS: DET,"morph": "Case=Voc|Gender=Masc|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSZS1FS3-------": {POS: DET,"morph": "Case=Nom|Gender=Masc,Neut|Gender[psor]=Fem|Number=Sing|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Prs"},
    "PSZS2FS3-------": {POS: DET,"morph": "Case=Gen|Gender=Masc,Neut|Gender[psor]=Fem|Number=Sing|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Prs"},
    "PSZS2-P1-------": {POS: DET,"morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSZS2-P2-------": {POS: DET,"morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs"},
    "PSZS2-S1-------": {POS: DET,"morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSZS2-S1------6": {POS: DET,"morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSZS2-S2-------": {POS: DET,"morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSZS2-S2------6": {POS: DET,"morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSZS3FS3-------": {POS: DET,"morph": "Case=Dat|Gender=Masc,Neut|Gender[psor]=Fem|Number=Sing|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Prs"},
    "PSZS3-P1-------": {POS: DET,"morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSZS3-P2-------": {POS: DET,"morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs"},
    "PSZS3-S1-------": {POS: DET,"morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSZS3-S1------6": {POS: DET,"morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSZS3-S2-------": {POS: DET,"morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSZS3-S2------6": {POS: DET,"morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSZS5FS3-------": {POS: DET,"morph": "Case=Voc|Gender=Masc,Neut|Gender[psor]=Fem|Number=Sing|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Prs"},
    "PSZS6FS3-------": {POS: DET,"morph": "Case=Loc|Gender=Masc,Neut|Gender[psor]=Fem|Number=Sing|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Prs"},
    "PSZS6-P1-------": {POS: DET,"morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSZS6-P2-------": {POS: DET,"morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs"},
    "PSZS6-S1-------": {POS: DET,"morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSZS6-S1------6": {POS: DET,"morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSZS6-S1------7": {POS: DET,"morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSZS6-S2-------": {POS: DET,"morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSZS6-S2------6": {POS: DET,"morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSZS6-S2------7": {POS: DET,"morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSZS7FS3-------": {POS: DET,"morph": "Case=Ins|Gender=Masc,Neut|Gender[psor]=Fem|Number=Sing|Number[psor]=Sing|Person=3|Poss=Yes|PronType=Prs"},
    "PSZS7-P1-------": {POS: DET,"morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSZS7-P1------6": {POS: DET,"morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSZS7-P1------8": {POS: DET,"morph": "Abbr=Yes|Case=Ins|Gender=Masc,Neut|Number=Sing|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs"},
    "PSZS7-P2-------": {POS: DET,"morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs"},
    "PSZS7-P2------6": {POS: DET,"morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|Number[psor]=Plur|Person=2|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSZS7-S1-------": {POS: DET,"morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs"},
    "PSZS7-S1------6": {POS: DET,"morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|Number[psor]=Sing|Person=1|Poss=Yes|PronType=Prs|Style=Coll"},
    "PSZS7-S2-------": {POS: DET,"morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs"},
    "PSZS7-S2------6": {POS: DET,"morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|Number[psor]=Sing|Person=2|Poss=Yes|PronType=Prs|Style=Coll"},
    "PW--1----------": {POS: PRON, "morph": "Case=Nom|PronType=Neg"},
    "PW--2----------": {POS: PRON, "morph": "Case=Gen|PronType=Neg"},
    "PW--2---------2": {POS: PRON, "morph": "Case=Gen|PronType=Neg|Style=Arch"},
    "PW--3----------": {POS: PRON, "morph": "Case=Dat|PronType=Neg"},
    "PW--3---------2": {POS: PRON, "morph": "Case=Dat|PronType=Neg|Style=Arch"},
    "PW--4----------": {POS: PRON, "morph": "Case=Acc|PronType=Neg"},
    "PW--6----------": {POS: PRON, "morph": "Case=Loc|PronType=Neg"},
    "PW--6---------2": {POS: PRON, "morph": "Case=Loc|PronType=Neg|Style=Arch"},
    "PW--7----------": {POS: PRON, "morph": "Case=Ins|PronType=Neg"},
    "PW--7---------2": {POS: PRON, "morph": "Case=Ins|PronType=Neg|Style=Arch"},
    "PWFD7----------": {POS: PRON, "morph": "Case=Ins|Gender=Fem|Number=Dual|PronType=Neg"},
    "PWFD7---------6": {POS: PRON, "morph": "Case=Ins|Gender=Fem|Number=Dual|PronType=Neg|Style=Coll"},
    "PWFP1----------": {POS: PRON, "morph": "Case=Nom|Gender=Fem|Number=Plur|PronType=Neg"},
    "PWFP1---------6": {POS: PRON, "morph": "Case=Nom|Gender=Fem|Number=Plur|PronType=Neg|Style=Coll"},
    "PWFP4----------": {POS: PRON, "morph": "Case=Acc|Gender=Fem|Number=Plur|PronType=Neg"},
    "PWFP4---------6": {POS: PRON, "morph": "Case=Acc|Gender=Fem|Number=Plur|PronType=Neg|Style=Coll"},
    "PWFP5----------": {POS: PRON, "morph": "Case=Voc|Gender=Fem|Number=Plur|PronType=Neg"},
    "PWFP5---------6": {POS: PRON, "morph": "Case=Voc|Gender=Fem|Number=Plur|PronType=Neg|Style=Coll"},
    "PWFS1----------": {POS: PRON, "morph": "Case=Nom|Gender=Fem|Number=Sing|PronType=Neg"},
    "PWFS2----------": {POS: PRON, "morph": "Case=Gen|Gender=Fem|Number=Sing|PronType=Neg"},
    "PWFS2---------6": {POS: PRON, "morph": "Case=Gen|Gender=Fem|Number=Sing|PronType=Neg|Style=Coll"},
    "PWFS3----------": {POS: PRON, "morph": "Case=Dat|Gender=Fem|Number=Sing|PronType=Neg"},
    "PWFS3---------6": {POS: PRON, "morph": "Case=Dat|Gender=Fem|Number=Sing|PronType=Neg|Style=Coll"},
    "PWFS4----------": {POS: PRON, "morph": "Case=Acc|Gender=Fem|Number=Sing|PronType=Neg"},
    "PWFS5----------": {POS: PRON, "morph": "Case=Voc|Gender=Fem|Number=Sing|PronType=Neg"},
    "PWFS6----------": {POS: PRON, "morph": "Case=Loc|Gender=Fem|Number=Sing|PronType=Neg"},
    "PWFS6---------6": {POS: PRON, "morph": "Case=Loc|Gender=Fem|Number=Sing|PronType=Neg|Style=Coll"},
    "PWFS7----------": {POS: PRON, "morph": "Case=Ins|Gender=Fem|Number=Sing|PronType=Neg"},
    "PWIP1----------": {POS: PRON, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|PronType=Neg"},
    "PWIP1---------6": {POS: PRON, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|PronType=Neg|Style=Coll"},
    "PWIP5----------": {POS: PRON, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|PronType=Neg"},
    "PWIP5---------6": {POS: PRON, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|PronType=Neg|Style=Coll"},
    "PWIS4----------": {POS: PRON, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|PronType=Neg"},
    "PWIS4---------6": {POS: PRON, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|PronType=Neg|Style=Coll"},
    "PWM-1----------": {POS: PRON, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|PronType=Neg"},
    "PWM-2----------": {POS: PRON, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|PronType=Neg"},
    "PWM-3----------": {POS: PRON, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|PronType=Neg"},
    "PWM-4----------": {POS: PRON, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|PronType=Neg"},
    "PWM-6----------": {POS: PRON, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|PronType=Neg"},
    "PWM-7----------": {POS: PRON, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|PronType=Neg"},
    "PWMP1----------": {POS: PRON, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|PronType=Neg"},
    "PWMP1---------6": {POS: PRON, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|PronType=Neg|Style=Coll"},
    "PWMP5----------": {POS: PRON, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|PronType=Neg"},
    "PWMP5---------6": {POS: PRON, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|PronType=Neg|Style=Coll"},
    "PWMS4----------": {POS: PRON, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|PronType=Neg"},
    "PWMS4---------6": {POS: PRON, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|PronType=Neg|Style=Coll"},
    "PWNP1----------": {POS: PRON, "morph": "Case=Nom|Gender=Neut|Number=Plur|PronType=Neg"},
    "PWNP1---------6": {POS: PRON, "morph": "Case=Nom|Gender=Neut|Number=Plur|PronType=Neg|Style=Coll"},
    "PWNP1---------7": {POS: PRON, "morph": "Case=Nom|Gender=Neut|Number=Plur|PronType=Neg|Style=Coll"},
    "PWNP4----------": {POS: PRON, "morph": "Case=Acc|Gender=Neut|Number=Plur|PronType=Neg"},
    "PWNP4---------6": {POS: PRON, "morph": "Case=Acc|Gender=Neut|Number=Plur|PronType=Neg|Style=Coll"},
    "PWNP5----------": {POS: PRON, "morph": "Case=Voc|Gender=Neut|Number=Plur|PronType=Neg"},
    "PWNP5---------6": {POS: PRON, "morph": "Case=Voc|Gender=Neut|Number=Plur|PronType=Neg|Style=Coll"},
    "PWNS1----------": {POS: PRON, "morph": "Case=Nom|Gender=Neut|Number=Sing|PronType=Neg"},
    "PWNS1---------6": {POS: PRON, "morph": "Case=Nom|Gender=Neut|Number=Sing|PronType=Neg|Style=Coll"},
    "PWNS4----------": {POS: PRON, "morph": "Case=Acc|Gender=Neut|Number=Sing|PronType=Neg"},
    "PWNS4---------6": {POS: PRON, "morph": "Case=Acc|Gender=Neut|Number=Sing|PronType=Neg|Style=Coll"},
    "PWNS5----------": {POS: PRON, "morph": "Case=Voc|Gender=Neut|Number=Sing|PronType=Neg"},
    "PWNS5---------6": {POS: PRON, "morph": "Case=Voc|Gender=Neut|Number=Sing|PronType=Neg|Style=Coll"},
    "PW--X----------": {POS: PRON, "morph": "PronType=Neg"},
    "PWXP2----------": {POS: PRON, "morph": "Case=Gen|Number=Plur|PronType=Neg"},
    "PWXP2---------6": {POS: PRON, "morph": "Case=Gen|Number=Plur|PronType=Neg|Style=Coll"},
    "PWXP3----------": {POS: PRON, "morph": "Case=Dat|Number=Plur|PronType=Neg"},
    "PWXP3---------6": {POS: PRON, "morph": "Case=Dat|Number=Plur|PronType=Neg|Style=Coll"},
    "PWXP6----------": {POS: PRON, "morph": "Case=Loc|Number=Plur|PronType=Neg"},
    "PWXP6---------6": {POS: PRON, "morph": "Case=Loc|Number=Plur|PronType=Neg|Style=Coll"},
    "PWXP7----------": {POS: PRON, "morph": "Case=Ins|Number=Plur|PronType=Neg"},
    "PWXP7---------6": {POS: PRON, "morph": "Case=Ins|Number=Plur|PronType=Neg|Style=Coll"},
    "PWXP7---------7": {POS: PRON, "morph": "Case=Ins|Number=Plur|PronType=Neg|Style=Coll"},
    "PWYP4----------": {POS: PRON, "morph": "Case=Acc|Gender=Masc|Number=Plur|PronType=Neg"},
    "PWYP4---------6": {POS: PRON, "morph": "Case=Acc|Gender=Masc|Number=Plur|PronType=Neg|Style=Coll"},
    "PWYS1----------": {POS: PRON, "morph": "Case=Nom|Gender=Masc|Number=Sing|PronType=Neg"},
    "PWYS1---------6": {POS: PRON, "morph": "Case=Nom|Gender=Masc|Number=Sing|PronType=Neg|Style=Coll"},
    "PWYS5----------": {POS: PRON, "morph": "Case=Voc|Gender=Masc|Number=Sing|PronType=Neg"},
    "PWYS5---------6": {POS: PRON, "morph": "Case=Voc|Gender=Masc|Number=Sing|PronType=Neg|Style=Coll"},
    "PWZS2----------": {POS: PRON, "morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|PronType=Neg"},
    "PWZS2---------6": {POS: PRON, "morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|PronType=Neg|Style=Coll"},
    "PWZS3----------": {POS: PRON, "morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|PronType=Neg"},
    "PWZS3---------6": {POS: PRON, "morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|PronType=Neg|Style=Coll"},
    "PWZS6----------": {POS: PRON, "morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|PronType=Neg"},
    "PWZS6---------6": {POS: PRON, "morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|PronType=Neg|Style=Coll"},
    "PWZS6---------7": {POS: PRON, "morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|PronType=Neg|Style=Coll"},
    "PWZS7----------": {POS: PRON, "morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|PronType=Neg"},
    "PWZS7---------6": {POS: PRON, "morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|PronType=Neg|Style=Coll"},
    "PY-------------": {POS: PRON, "morph": "AdpType=Preppron|PronType=Int,Rel"},
    "PZ--1----------": {POS: PRON, "morph": "Case=Nom|PronType=Ind"},
    "PZ--1---------1": {POS: PRON, "morph": "Case=Nom|PronType=Ind"},
    "PZ--1---------2": {POS: PRON, "morph": "Case=Nom|PronType=Ind|Style=Arch"},
    "PZ--1---------4": {POS: PRON, "morph": "Case=Nom|PronType=Ind|Style=Arch"},
    "PZ--2----------": {POS: PRON, "morph": "Case=Gen|PronType=Ind"},
    "PZ--2---------1": {POS: PRON, "morph": "Case=Gen|PronType=Ind"},
    "PZ--2---------2": {POS: PRON, "morph": "Case=Gen|PronType=Ind|Style=Arch"},
    "PZ--3----------": {POS: PRON, "morph": "Case=Dat|PronType=Ind"},
    "PZ--3---------1": {POS: PRON, "morph": "Case=Dat|PronType=Ind"},
    "PZ--3---------2": {POS: PRON, "morph": "Case=Dat|PronType=Ind|Style=Arch"},
    "PZ--4----------": {POS: PRON, "morph": "Case=Acc|PronType=Ind"},
    "PZ--4---------1": {POS: PRON, "morph": "Case=Acc|PronType=Ind"},
    "PZ--4---------2": {POS: PRON, "morph": "Case=Acc|PronType=Ind|Style=Arch"},
    "PZ--4---------4": {POS: PRON, "morph": "Case=Acc|PronType=Ind|Style=Arch"},
    "PZ--5----------": {POS: PRON, "morph": "Case=Voc|PronType=Ind"},
    "PZ--5---------1": {POS: PRON, "morph": "Case=Voc|PronType=Ind"},
    "PZ--5---------2": {POS: PRON, "morph": "Case=Voc|PronType=Ind|Style=Arch"},
    "PZ--6----------": {POS: PRON, "morph": "Case=Loc|PronType=Ind"},
    "PZ--6---------1": {POS: PRON, "morph": "Case=Loc|PronType=Ind"},
    "PZ--6---------2": {POS: PRON, "morph": "Case=Loc|PronType=Ind|Style=Arch"},
    "PZ--7----------": {POS: PRON, "morph": "Case=Ins|PronType=Ind"},
    "PZ--7---------1": {POS: PRON, "morph": "Case=Ins|PronType=Ind"},
    "PZ--7---------2": {POS: PRON, "morph": "Case=Ins|PronType=Ind|Style=Arch"},
    "PZFD7----------": {POS: PRON, "morph": "Case=Ins|Gender=Fem|Number=Dual|PronType=Ind"},
    "PZFD7---------1": {POS: PRON, "morph": "Case=Ins|Gender=Fem|Number=Dual|PronType=Ind"},
    "PZFD7---------6": {POS: PRON, "morph": "Case=Ins|Gender=Fem|Number=Dual|PronType=Ind|Style=Coll"},
    "PZFP1----------": {POS: PRON, "morph": "Case=Nom|Gender=Fem|Number=Plur|PronType=Ind"},
    "PZFP1---------1": {POS: PRON, "morph": "Case=Nom|Gender=Fem|Number=Plur|PronType=Ind"},
    "PZFP1---------6": {POS: PRON, "morph": "Case=Nom|Gender=Fem|Number=Plur|PronType=Ind|Style=Coll"},
    "PZFP4----------": {POS: PRON, "morph": "Case=Acc|Gender=Fem|Number=Plur|PronType=Ind"},
    "PZFP4---------1": {POS: PRON, "morph": "Case=Acc|Gender=Fem|Number=Plur|PronType=Ind"},
    "PZFP4---------6": {POS: PRON, "morph": "Case=Acc|Gender=Fem|Number=Plur|PronType=Ind|Style=Coll"},
    "PZFP5----------": {POS: PRON, "morph": "Case=Voc|Gender=Fem|Number=Plur|PronType=Ind"},
    "PZFP5---------1": {POS: PRON, "morph": "Case=Voc|Gender=Fem|Number=Plur|PronType=Ind"},
    "PZFP5---------6": {POS: PRON, "morph": "Case=Voc|Gender=Fem|Number=Plur|PronType=Ind|Style=Coll"},
    "PZFS1----------": {POS: PRON, "morph": "Case=Nom|Gender=Fem|Number=Sing|PronType=Ind"},
    "PZFS1---------1": {POS: PRON, "morph": "Case=Nom|Gender=Fem|Number=Sing|PronType=Ind"},
    "PZFS1---------6": {POS: PRON, "morph": "Case=Nom|Gender=Fem|Number=Sing|PronType=Ind|Style=Coll"},
    "PZFS2----------": {POS: PRON, "morph": "Case=Gen|Gender=Fem|Number=Sing|PronType=Ind"},
    "PZFS2---------1": {POS: PRON, "morph": "Case=Gen|Gender=Fem|Number=Sing|PronType=Ind"},
    "PZFS2---------6": {POS: PRON, "morph": "Case=Gen|Gender=Fem|Number=Sing|PronType=Ind|Style=Coll"},
    "PZFS3----------": {POS: PRON, "morph": "Case=Dat|Gender=Fem|Number=Sing|PronType=Ind"},
    "PZFS3---------1": {POS: PRON, "morph": "Case=Dat|Gender=Fem|Number=Sing|PronType=Ind"},
    "PZFS3---------6": {POS: PRON, "morph": "Case=Dat|Gender=Fem|Number=Sing|PronType=Ind|Style=Coll"},
    "PZFS4----------": {POS: PRON, "morph": "Case=Acc|Gender=Fem|Number=Sing|PronType=Ind"},
    "PZFS4---------1": {POS: PRON, "morph": "Case=Acc|Gender=Fem|Number=Sing|PronType=Ind"},
    "PZFS4---------6": {POS: PRON, "morph": "Case=Acc|Gender=Fem|Number=Sing|PronType=Ind|Style=Coll"},
    "PZFS5----------": {POS: PRON, "morph": "Case=Voc|Gender=Fem|Number=Sing|PronType=Ind"},
    "PZFS5---------1": {POS: PRON, "morph": "Case=Voc|Gender=Fem|Number=Sing|PronType=Ind"},
    "PZFS5---------6": {POS: PRON, "morph": "Case=Voc|Gender=Fem|Number=Sing|PronType=Ind|Style=Coll"},
    "PZFS6----------": {POS: PRON, "morph": "Case=Loc|Gender=Fem|Number=Sing|PronType=Ind"},
    "PZFS6---------1": {POS: PRON, "morph": "Case=Loc|Gender=Fem|Number=Sing|PronType=Ind"},
    "PZFS6---------6": {POS: PRON, "morph": "Case=Loc|Gender=Fem|Number=Sing|PronType=Ind|Style=Coll"},
    "PZFS7----------": {POS: PRON, "morph": "Case=Ins|Gender=Fem|Number=Sing|PronType=Ind"},
    "PZFS7---------1": {POS: PRON, "morph": "Case=Ins|Gender=Fem|Number=Sing|PronType=Ind"},
    "PZFS7---------6": {POS: PRON, "morph": "Case=Ins|Gender=Fem|Number=Sing|PronType=Ind|Style=Coll"},
    "PZIP1----------": {POS: PRON, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|PronType=Ind"},
    "PZIP1---------1": {POS: PRON, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|PronType=Ind"},
    "PZIP1---------6": {POS: PRON, "morph": "Animacy=Inan|Case=Nom|Gender=Masc|Number=Plur|PronType=Ind|Style=Coll"},
    "PZIP5----------": {POS: PRON, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|PronType=Ind"},
    "PZIP5---------1": {POS: PRON, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|PronType=Ind"},
    "PZIP5---------6": {POS: PRON, "morph": "Animacy=Inan|Case=Voc|Gender=Masc|Number=Plur|PronType=Ind|Style=Coll"},
    "PZIS4----------": {POS: PRON, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|PronType=Ind"},
    "PZIS4---------1": {POS: PRON, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|PronType=Ind"},
    "PZIS4---------6": {POS: PRON, "morph": "Animacy=Inan|Case=Acc|Gender=Masc|Number=Sing|PronType=Ind|Style=Coll"},
    "PZIS6---------7": {POS: PRON, "morph": "Animacy=Inan|Case=Loc|Gender=Masc|Number=Sing|PronType=Ind|Style=Coll"},
    "PZM-1----------": {POS: PRON, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|PronType=Ind"},
    "PZM-1---------1": {POS: PRON, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|PronType=Ind"},
    "PZM-2----------": {POS: PRON, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|PronType=Ind"},
    "PZM-2---------1": {POS: PRON, "morph": "Animacy=Anim|Case=Gen|Gender=Masc|PronType=Ind"},
    "PZM-3----------": {POS: PRON, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|PronType=Ind"},
    "PZM-3---------1": {POS: PRON, "morph": "Animacy=Anim|Case=Dat|Gender=Masc|PronType=Ind"},
    "PZM-4----------": {POS: PRON, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|PronType=Ind"},
    "PZM-4---------1": {POS: PRON, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|PronType=Ind"},
    "PZM-5----------": {POS: PRON, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|PronType=Ind"},
    "PZM-5---------1": {POS: PRON, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|PronType=Ind"},
    "PZM-6----------": {POS: PRON, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|PronType=Ind"},
    "PZM-6---------1": {POS: PRON, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|PronType=Ind"},
    "PZM-7----------": {POS: PRON, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|PronType=Ind"},
    "PZM-7---------1": {POS: PRON, "morph": "Animacy=Anim|Case=Ins|Gender=Masc|PronType=Ind"},
    "PZMP1----------": {POS: PRON, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|PronType=Ind"},
    "PZMP1---------1": {POS: PRON, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|PronType=Ind"},
    "PZMP1---------6": {POS: PRON, "morph": "Animacy=Anim|Case=Nom|Gender=Masc|Number=Plur|PronType=Ind|Style=Coll"},
    "PZMP5----------": {POS: PRON, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|PronType=Ind"},
    "PZMP5---------1": {POS: PRON, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|PronType=Ind"},
    "PZMP5---------6": {POS: PRON, "morph": "Animacy=Anim|Case=Voc|Gender=Masc|Number=Plur|PronType=Ind|Style=Coll"},
    "PZMS4----------": {POS: PRON, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|PronType=Ind"},
    "PZMS4---------1": {POS: PRON, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|PronType=Ind"},
    "PZMS4---------6": {POS: PRON, "morph": "Animacy=Anim|Case=Acc|Gender=Masc|Number=Sing|PronType=Ind|Style=Coll"},
    "PZMS6---------7": {POS: PRON, "morph": "Animacy=Anim|Case=Loc|Gender=Masc|Number=Sing|PronType=Ind|Style=Coll"},
    "PZNP1----------": {POS: PRON, "morph": "Case=Nom|Gender=Neut|Number=Plur|PronType=Ind"},
    "PZNP1---------1": {POS: PRON, "morph": "Case=Nom|Gender=Neut|Number=Plur|PronType=Ind"},
    "PZNP1---------6": {POS: PRON, "morph": "Case=Nom|Gender=Neut|Number=Plur|PronType=Ind|Style=Coll"},
    "PZNP4----------": {POS: PRON, "morph": "Case=Acc|Gender=Neut|Number=Plur|PronType=Ind"},
    "PZNP4---------1": {POS: PRON, "morph": "Case=Acc|Gender=Neut|Number=Plur|PronType=Ind"},
    "PZNP4---------6": {POS: PRON, "morph": "Case=Acc|Gender=Neut|Number=Plur|PronType=Ind|Style=Coll"},
    "PZNP5----------": {POS: PRON, "morph": "Case=Voc|Gender=Neut|Number=Plur|PronType=Ind"},
    "PZNP5---------1": {POS: PRON, "morph": "Case=Voc|Gender=Neut|Number=Plur|PronType=Ind"},
    "PZNP5---------6": {POS: PRON, "morph": "Case=Voc|Gender=Neut|Number=Plur|PronType=Ind|Style=Coll"},
    "PZNS1----------": {POS: PRON, "morph": "Case=Nom|Gender=Neut|Number=Sing|PronType=Ind"},
    "PZNS1---------1": {POS: PRON, "morph": "Case=Nom|Gender=Neut|Number=Sing|PronType=Ind"},
    "PZNS1---------6": {POS: PRON, "morph": "Case=Nom|Gender=Neut|Number=Sing|PronType=Ind|Style=Coll"},
    "PZNS4----------": {POS: PRON, "morph": "Case=Acc|Gender=Neut|Number=Sing|PronType=Ind"},
    "PZNS4---------1": {POS: PRON, "morph": "Case=Acc|Gender=Neut|Number=Sing|PronType=Ind"},
    "PZNS4---------6": {POS: PRON, "morph": "Case=Acc|Gender=Neut|Number=Sing|PronType=Ind|Style=Coll"},
    "PZNS5----------": {POS: PRON, "morph": "Case=Voc|Gender=Neut|Number=Sing|PronType=Ind"},
    "PZNS5---------1": {POS: PRON, "morph": "Case=Voc|Gender=Neut|Number=Sing|PronType=Ind"},
    "PZNS5---------6": {POS: PRON, "morph": "Case=Voc|Gender=Neut|Number=Sing|PronType=Ind|Style=Coll"},
    "PZNS6---------7": {POS: PRON, "morph": "Case=Loc|Gender=Neut|Number=Sing|PronType=Ind|Style=Coll"},
    "PZXP2----------": {POS: PRON, "morph": "Case=Gen|Number=Plur|PronType=Ind"},
    "PZXP2---------1": {POS: PRON, "morph": "Case=Gen|Number=Plur|PronType=Ind"},
    "PZXP2---------6": {POS: PRON, "morph": "Case=Gen|Number=Plur|PronType=Ind|Style=Coll"},
    "PZXP3----------": {POS: PRON, "morph": "Case=Dat|Number=Plur|PronType=Ind"},
    "PZXP3---------1": {POS: PRON, "morph": "Case=Dat|Number=Plur|PronType=Ind"},
    "PZXP3---------6": {POS: PRON, "morph": "Case=Dat|Number=Plur|PronType=Ind|Style=Coll"},
    "PZXP6----------": {POS: PRON, "morph": "Case=Loc|Number=Plur|PronType=Ind"},
    "PZXP6---------1": {POS: PRON, "morph": "Case=Loc|Number=Plur|PronType=Ind"},
    "PZXP6---------6": {POS: PRON, "morph": "Case=Loc|Number=Plur|PronType=Ind|Style=Coll"},
    "PZXP7----------": {POS: PRON, "morph": "Case=Ins|Number=Plur|PronType=Ind"},
    "PZXP7---------1": {POS: PRON, "morph": "Case=Ins|Number=Plur|PronType=Ind"},
    "PZXP7---------6": {POS: PRON, "morph": "Case=Ins|Number=Plur|PronType=Ind|Style=Coll"},
    "PZXP7---------7": {POS: PRON, "morph": "Case=Ins|Number=Plur|PronType=Ind|Style=Coll"},
    "PZXXX----------": {POS: PRON, "morph": "PronType=Ind"},
    "PZYP4----------": {POS: PRON, "morph": "Case=Acc|Gender=Masc|Number=Plur|PronType=Ind"},
    "PZYP4---------1": {POS: PRON, "morph": "Case=Acc|Gender=Masc|Number=Plur|PronType=Ind"},
    "PZYP4---------6": {POS: PRON, "morph": "Case=Acc|Gender=Masc|Number=Plur|PronType=Ind|Style=Coll"},
    "PZYS1----------": {POS: PRON, "morph": "Case=Nom|Gender=Masc|Number=Sing|PronType=Ind"},
    "PZYS1---------1": {POS: PRON, "morph": "Case=Nom|Gender=Masc|Number=Sing|PronType=Ind"},
    "PZYS1---------6": {POS: PRON, "morph": "Case=Nom|Gender=Masc|Number=Sing|PronType=Ind|Style=Coll"},
    "PZYS2----------": {POS: PRON, "morph": "Case=Gen|Gender=Masc|Number=Sing|PronType=Ind"},
    "PZYS3----------": {POS: PRON, "morph": "Case=Dat|Gender=Masc|Number=Sing|PronType=Ind"},
    "PZYS5----------": {POS: PRON, "morph": "Case=Voc|Gender=Masc|Number=Sing|PronType=Ind"},
    "PZYS5---------1": {POS: PRON, "morph": "Case=Voc|Gender=Masc|Number=Sing|PronType=Ind"},
    "PZYS5---------6": {POS: PRON, "morph": "Case=Voc|Gender=Masc|Number=Sing|PronType=Ind|Style=Coll"},
    "PZZS2----------": {POS: PRON, "morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|PronType=Ind"},
    "PZZS2---------1": {POS: PRON, "morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|PronType=Ind"},
    "PZZS2---------6": {POS: PRON, "morph": "Case=Gen|Gender=Masc,Neut|Number=Sing|PronType=Ind|Style=Coll"},
    "PZZS3----------": {POS: PRON, "morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|PronType=Ind"},
    "PZZS3---------1": {POS: PRON, "morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|PronType=Ind"},
    "PZZS3---------6": {POS: PRON, "morph": "Case=Dat|Gender=Masc,Neut|Number=Sing|PronType=Ind|Style=Coll"},
    "PZZS6----------": {POS: PRON, "morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|PronType=Ind"},
    "PZZS6---------1": {POS: PRON, "morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|PronType=Ind"},
    "PZZS6---------6": {POS: PRON, "morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|PronType=Ind|Style=Coll"},
    "PZZS6---------7": {POS: PRON, "morph": "Case=Loc|Gender=Masc,Neut|Number=Sing|PronType=Ind|Style=Coll"},
    "PZZS7----------": {POS: PRON, "morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|PronType=Ind"},
    "PZZS7---------1": {POS: PRON, "morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|PronType=Ind"},
    "PZZS7---------6": {POS: PRON, "morph": "Case=Ins|Gender=Masc,Neut|Number=Sing|PronType=Ind|Style=Coll"},
    "RF-------------": {POS: ADP, "morph": "AdpType=Comprep"},
    "RR--1----------": {POS: ADP, "morph": "AdpType=Prep|Case=Nom"},
    "RR--1---------8": {POS: ADP, "morph": "Abbr=Yes|AdpType=Prep|Case=Nom"},
    "RR--2----------": {POS: ADP, "morph": "AdpType=Prep|Case=Gen"},
    "RR--2---------1": {POS: ADP, "morph": "AdpType=Prep|Case=Gen"},
    "RR--2---------3": {POS: ADP, "morph": "AdpType=Prep|Case=Gen|Style=Arch"},
    "RR--2---------8": {POS: ADP, "morph": "Abbr=Yes|AdpType=Prep|Case=Gen"},
    "RR--3----------": {POS: ADP, "morph": "AdpType=Prep|Case=Dat"},
    "RR--3---------8": {POS: ADP, "morph": "Abbr=Yes|AdpType=Prep|Case=Dat"},
    "RR--4----------": {POS: ADP, "morph": "AdpType=Prep|Case=Acc"},
    "RR--4---------8": {POS: ADP, "morph": "Abbr=Yes|AdpType=Prep|Case=Acc"},
    "RR--6----------": {POS: ADP, "morph": "AdpType=Prep|Case=Loc"},
    "RR--7----------": {POS: ADP, "morph": "AdpType=Prep|Case=Ins"},
    "RR--7---------8": {POS: ADP, "morph": "Abbr=Yes|AdpType=Prep|Case=Ins"},
    "RR--X----------": {POS: ADP, "morph": "AdpType=Prep"},
    "RR--X---------8": {POS: ADP, "morph": "Abbr=Yes|AdpType=Prep"},
    "RV--1----------": {POS: ADP, "morph": "AdpType=Voc|Case=Nom"},
    "RV--2----------": {POS: ADP, "morph": "AdpType=Voc|Case=Gen"},
    "RV--2---------1": {POS: ADP, "morph": "AdpType=Voc|Case=Gen"},
    "RV--3----------": {POS: ADP, "morph": "AdpType=Voc|Case=Dat"},
    "RV--3---------1": {POS: ADP, "morph": "AdpType=Voc|Case=Dat"},
    "RV--4----------": {POS: ADP, "morph": "AdpType=Voc|Case=Acc"},
    "RV--4---------1": {POS: ADP, "morph": "AdpType=Voc|Case=Acc"},
    "RV--6----------": {POS: ADP, "morph": "AdpType=Voc|Case=Loc"},
    "RV--7----------": {POS: ADP, "morph": "AdpType=Voc|Case=Ins"},
    "TT-------------": {POS: PART, "morph": "_"},
    "TT------------1": {POS: PART, "morph": "_"},
    "TT------------8": {POS: PART, "morph": "Abbr=Yes"},
    "V~-------------": {POS: VERB, "morph": "Abbr=Yes"},
    "VB-P---1F-AA---": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=1|Polarity=Pos|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-P---1F-AA--6": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=1|Polarity=Pos|Style=Coll|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-P---1F-AA--7": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=1|Polarity=Pos|Style=Coll|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-P---1F-AA--8": {POS: VERB,"morph": "Abbr=Yes|Mood=Ind|Number=Plur|Person=1|Polarity=Pos|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-P---1F-NA---": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=1|Polarity=Neg|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-P---1F-NA--6": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=1|Polarity=Neg|Style=Coll|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-P---1F-NA--7": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=1|Polarity=Neg|Style=Coll|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-P---1F-NA--8": {POS: VERB,"morph": "Abbr=Yes|Mood=Ind|Number=Plur|Person=1|Polarity=Neg|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-P---1P-AA---": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=1|Polarity=Pos|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---1P-AA--1": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=1|Polarity=Pos|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---1P-AA--2": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=1|Polarity=Pos|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---1P-AA--3": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=1|Polarity=Pos|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---1P-AA--6": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=1|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---1P-AA--7": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=1|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---1P-NA---": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=1|Polarity=Neg|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---1P-NA--1": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=1|Polarity=Neg|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---1P-NA--2": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=1|Polarity=Neg|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---1P-NA--3": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=1|Polarity=Neg|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---1P-NA--6": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=1|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---1P-NA--7": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=1|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---2F-AA---": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=2|Polarity=Pos|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-P---2F-AA--7": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=2|Polarity=Pos|Style=Coll|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-P---2F-NA---": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=2|Polarity=Neg|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-P---2F-NA--7": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=2|Polarity=Neg|Style=Coll|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-P---2P-AA---": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=2|Polarity=Pos|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---2P-AA--1": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=2|Polarity=Pos|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---2P-AA--2": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=2|Polarity=Pos|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---2P-AA--3": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=2|Polarity=Pos|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---2P-AA--6": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=2|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---2P-NA---": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=2|Polarity=Neg|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---2P-NA--1": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=2|Polarity=Neg|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---2P-NA--2": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=2|Polarity=Neg|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---2P-NA--3": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=2|Polarity=Neg|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---2P-NA--6": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=2|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---3F-AA---": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Pos|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-P---3F-AA--1": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Pos|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-P---3F-AA--7": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Pos|Style=Coll|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-P---3F-NA---": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Neg|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-P---3F-NA--1": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Neg|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-P---3F-NA--7": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Neg|Style=Coll|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-P---3P-AA---": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Pos|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---3P-AA--1": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Pos|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---3P-AA--2": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Pos|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---3P-AA--3": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Pos|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---3P-AA--4": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Pos|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---3P-AA--5": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---3P-AA--6": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---3P-AA--7": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---3P-NA---": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Neg|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---3P-NA--1": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Neg|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---3P-NA--2": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Neg|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---3P-NA--3": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Neg|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---3P-NA--4": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Neg|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---3P-NA--5": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---3P-NA--6": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-P---3P-NA--7": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---1F-AA---": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=1|Polarity=Pos|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-S---1F-AA--1": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=1|Polarity=Pos|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-S---1F-AA--7": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=1|Polarity=Pos|Style=Coll|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-S---1F-NA---": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=1|Polarity=Neg|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-S---1F-NA--1": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=1|Polarity=Neg|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-S---1F-NA--7": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=1|Polarity=Neg|Style=Coll|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-S---1P-AA---": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=1|Polarity=Pos|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---1P-AA--1": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=1|Polarity=Pos|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---1P-AA--2": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=1|Polarity=Pos|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---1P-AA--3": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=1|Polarity=Pos|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---1P-AA--4": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=1|Polarity=Pos|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---1P-AA--6": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=1|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---1P-AA--7": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=1|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---1P-NA---": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=1|Polarity=Neg|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---1P-NA--1": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=1|Polarity=Neg|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---1P-NA--2": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=1|Polarity=Neg|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---1P-NA--3": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=1|Polarity=Neg|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---1P-NA--4": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=1|Polarity=Neg|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---1P-NA--6": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=1|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---2F-AA---": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=2|Polarity=Pos|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-S---2F-AA--7": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=2|Polarity=Pos|Style=Coll|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-S---2F-NA---": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=2|Polarity=Neg|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-S---2F-NA--7": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=2|Polarity=Neg|Style=Coll|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-S---2P-AA---": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=2|Polarity=Pos|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---2P-AA--1": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=2|Polarity=Pos|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---2P-AA--2": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=2|Polarity=Pos|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---2P-AA--3": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=2|Polarity=Pos|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---2P-AA--6": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=2|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---2P-AA--7": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=2|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---2P-NA---": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=2|Polarity=Neg|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---2P-NA--1": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=2|Polarity=Neg|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---2P-NA--2": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=2|Polarity=Neg|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---2P-NA--3": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=2|Polarity=Neg|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---2P-NA--6": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=2|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---3F-AA---": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=3|Polarity=Pos|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-S---3F-AA--7": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=3|Polarity=Pos|Style=Coll|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-S---3F-NA---": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=3|Polarity=Neg|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-S---3F-NA--7": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=3|Polarity=Neg|Style=Coll|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-S---3P-AA---": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=3|Polarity=Pos|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---3P-AA--1": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=3|Polarity=Pos|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---3P-AA--2": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=3|Polarity=Pos|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---3P-AA--3": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=3|Polarity=Pos|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---3P-AA--4": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=3|Polarity=Pos|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---3P-AA--5": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=3|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---3P-AA--6": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=3|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---3P-AA--7": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=3|Polarity=Pos|Style=Coll|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---3P-AA--8": {POS: VERB,"morph": "Abbr=Yes|Mood=Ind|Number=Sing|Person=3|Polarity=Pos|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---3P-NA---": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=3|Polarity=Neg|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---3P-NA--1": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=3|Polarity=Neg|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---3P-NA--2": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=3|Polarity=Neg|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---3P-NA--3": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=3|Polarity=Neg|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---3P-NA--4": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=3|Polarity=Neg|Style=Arch|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---3P-NA--5": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=3|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---3P-NA--6": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=3|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-S---3P-NA--7": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=3|Polarity=Neg|Style=Coll|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-X---XF-AA---": {POS: VERB, "morph": "Mood=Ind|Polarity=Pos|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-X---XF-NA---": {POS: VERB, "morph": "Mood=Ind|Polarity=Neg|Tense=Fut|VerbForm=Fin|Voice=Act"},
    "VB-X---XP-AA---": {POS: VERB, "morph": "Mood=Ind|Polarity=Pos|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "VB-X---XP-NA---": {POS: VERB, "morph": "Mood=Ind|Polarity=Neg|Tense=Pres|VerbForm=Fin|Voice=Act"},
    "Vc-P---1-------": {POS: VERB, "morph": "Mood=Cnd|Number=Plur|Person=1|VerbForm=Fin"},
    "Vc-P---1------6": {POS: VERB, "morph": "Mood=Cnd|Number=Plur|Person=1|Style=Coll|VerbForm=Fin"},
    "Vc-P---2-------": {POS: VERB, "morph": "Mood=Cnd|Number=Plur|Person=2|VerbForm=Fin"},
    "Vc-S---1-------": {POS: VERB, "morph": "Mood=Cnd|Number=Sing|Person=1|VerbForm=Fin"},
    "Vc-S---1------6": {POS: VERB, "morph": "Mood=Cnd|Number=Sing|Person=1|Style=Coll|VerbForm=Fin"},
    "Vc-S---2-------": {POS: VERB, "morph": "Mood=Cnd|Number=Sing|Person=2|VerbForm=Fin"},
    "Vc-X---3-------": {POS: VERB, "morph": "Mood=Cnd|Person=3|VerbForm=Fin"},
    "VeHS------A----": {POS: VERB,"morph": "Aspect=Imp|Gender=Fem,Neut|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Conv|Voice=Act"},
    "VeHS------A---2": {POS: VERB,"morph": "Aspect=Imp|Gender=Fem,Neut|Number=Sing|Polarity=Pos|Style=Arch|Tense=Pres|VerbForm=Conv|Voice=Act"},
    "VeHS------N----": {POS: VERB,"morph": "Aspect=Imp|Gender=Fem,Neut|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Conv|Voice=Act"},
    "VeHS------N---2": {POS: VERB,"morph": "Aspect=Imp|Gender=Fem,Neut|Number=Sing|Polarity=Neg|Style=Arch|Tense=Pres|VerbForm=Conv|Voice=Act"},
    "VeXP------A----": {POS: VERB, "morph": "Aspect=Imp|Number=Plur|Polarity=Pos|Tense=Pres|VerbForm=Conv|Voice=Act"},
    "VeXP------A---2": {POS: VERB,"morph": "Aspect=Imp|Number=Plur|Polarity=Pos|Style=Arch|Tense=Pres|VerbForm=Conv|Voice=Act"},
    "VeXP------N----": {POS: VERB, "morph": "Aspect=Imp|Number=Plur|Polarity=Neg|Tense=Pres|VerbForm=Conv|Voice=Act"},
    "VeXP------N---2": {POS: VERB,"morph": "Aspect=Imp|Number=Plur|Polarity=Neg|Style=Arch|Tense=Pres|VerbForm=Conv|Voice=Act"},
    "VeYS------A----": {POS: VERB,"morph": "Aspect=Imp|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Pres|VerbForm=Conv|Voice=Act"},
    "VeYS------N----": {POS: VERB,"morph": "Aspect=Imp|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Pres|VerbForm=Conv|Voice=Act"},
    "Vf--------A----": {POS: VERB, "morph": "Polarity=Pos|VerbForm=Inf"},
    "Vf--------A---1": {POS: VERB, "morph": "Polarity=Pos|VerbForm=Inf"},
    "Vf--------A---2": {POS: VERB, "morph": "Polarity=Pos|Style=Arch|VerbForm=Inf"},
    "Vf--------A---3": {POS: VERB, "morph": "Polarity=Pos|Style=Arch|VerbForm=Inf"},
    "Vf--------A---4": {POS: VERB, "morph": "Polarity=Pos|Style=Arch|VerbForm=Inf"},
    "Vf--------A---6": {POS: VERB, "morph": "Polarity=Pos|Style=Coll|VerbForm=Inf"},
    "Vf--------A---8": {POS: VERB, "morph": "Abbr=Yes|Polarity=Pos|VerbForm=Inf"},
    "Vf--------N----": {POS: VERB, "morph": "Polarity=Neg|VerbForm=Inf"},
    "Vf--------N---1": {POS: VERB, "morph": "Polarity=Neg|VerbForm=Inf"},
    "Vf--------N---2": {POS: VERB, "morph": "Polarity=Neg|Style=Arch|VerbForm=Inf"},
    "Vf--------N---3": {POS: VERB, "morph": "Polarity=Neg|Style=Arch|VerbForm=Inf"},
    "Vf--------N---4": {POS: VERB, "morph": "Polarity=Neg|Style=Arch|VerbForm=Inf"},
    "Vf--------N---6": {POS: VERB, "morph": "Polarity=Neg|Style=Coll|VerbForm=Inf"},
    "Vi-P---1--A----": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=1|Polarity=Pos|VerbForm=Fin"},
    "Vi-P---1--A---1": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=1|Polarity=Pos|VerbForm=Fin"},
    "Vi-P---1--A---2": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=1|Polarity=Pos|Style=Arch|VerbForm=Fin"},
    "Vi-P---1--A---3": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=1|Polarity=Pos|Style=Arch|VerbForm=Fin"},
    "Vi-P---1--A---6": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=1|Polarity=Pos|Style=Coll|VerbForm=Fin"},
    "Vi-P---1--N----": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=1|Polarity=Neg|VerbForm=Fin"},
    "Vi-P---1--N---1": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=1|Polarity=Neg|VerbForm=Fin"},
    "Vi-P---1--N---2": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=1|Polarity=Neg|Style=Arch|VerbForm=Fin"},
    "Vi-P---1--N---3": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=1|Polarity=Neg|Style=Arch|VerbForm=Fin"},
    "Vi-P---1--N---6": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=1|Polarity=Neg|Style=Coll|VerbForm=Fin"},
    "Vi-P---2--A----": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=2|Polarity=Pos|VerbForm=Fin"},
    "Vi-P---2--A---1": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=2|Polarity=Pos|VerbForm=Fin"},
    "Vi-P---2--A---2": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=2|Polarity=Pos|Style=Arch|VerbForm=Fin"},
    "Vi-P---2--A---3": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=2|Polarity=Pos|Style=Arch|VerbForm=Fin"},
    "Vi-P---2--A---6": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=2|Polarity=Pos|Style=Coll|VerbForm=Fin"},
    "Vi-P---2--A---7": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=2|Polarity=Pos|Style=Coll|VerbForm=Fin"},
    "Vi-P---2--N----": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=2|Polarity=Neg|VerbForm=Fin"},
    "Vi-P---2--N---1": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=2|Polarity=Neg|VerbForm=Fin"},
    "Vi-P---2--N---2": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=2|Polarity=Neg|Style=Arch|VerbForm=Fin"},
    "Vi-P---2--N---3": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=2|Polarity=Neg|Style=Arch|VerbForm=Fin"},
    "Vi-P---2--N---6": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=2|Polarity=Neg|Style=Coll|VerbForm=Fin"},
    "Vi-P---2--N---7": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=2|Polarity=Neg|Style=Coll|VerbForm=Fin"},
    "Vi-P---3--A---1": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=3|Polarity=Pos|VerbForm=Fin"},
    "Vi-P---3--A---2": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=3|Polarity=Pos|Style=Arch|VerbForm=Fin"},
    "Vi-P---3--A---3": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=3|Polarity=Pos|Style=Arch|VerbForm=Fin"},
    "Vi-P---3--A---4": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=3|Polarity=Pos|Style=Arch|VerbForm=Fin"},
    "Vi-P---3--A---9": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=3|Polarity=Pos|VerbForm=Fin"},
    "Vi-P---3--N---1": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=3|Polarity=Neg|VerbForm=Fin"},
    "Vi-P---3--N---2": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=3|Polarity=Neg|Style=Arch|VerbForm=Fin"},
    "Vi-P---3--N---3": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=3|Polarity=Neg|Style=Arch|VerbForm=Fin"},
    "Vi-P---3--N---4": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=3|Polarity=Neg|Style=Arch|VerbForm=Fin"},
    "Vi-P---3--N---9": {POS: VERB, "morph": "Mood=Imp|Number=Plur|Person=3|Polarity=Neg|VerbForm=Fin"},
    "Vi-S---2--A----": {POS: VERB, "morph": "Mood=Imp|Number=Sing|Person=2|Polarity=Pos|VerbForm=Fin"},
    "Vi-S---2--A---1": {POS: VERB, "morph": "Mood=Imp|Number=Sing|Person=2|Polarity=Pos|VerbForm=Fin"},
    "Vi-S---2--A---2": {POS: VERB, "morph": "Mood=Imp|Number=Sing|Person=2|Polarity=Pos|Style=Arch|VerbForm=Fin"},
    "Vi-S---2--A---6": {POS: VERB, "morph": "Mood=Imp|Number=Sing|Person=2|Polarity=Pos|Style=Coll|VerbForm=Fin"},
    "Vi-S---2--A---7": {POS: VERB, "morph": "Mood=Imp|Number=Sing|Person=2|Polarity=Pos|Style=Coll|VerbForm=Fin"},
    "Vi-S---2--A---8": {POS: VERB, "morph": "Abbr=Yes|Mood=Imp|Number=Sing|Person=2|Polarity=Pos|VerbForm=Fin"},
    "Vi-S---2--N----": {POS: VERB, "morph": "Mood=Imp|Number=Sing|Person=2|Polarity=Neg|VerbForm=Fin"},
    "Vi-S---2--N---1": {POS: VERB, "morph": "Mood=Imp|Number=Sing|Person=2|Polarity=Neg|VerbForm=Fin"},
    "Vi-S---2--N---2": {POS: VERB, "morph": "Mood=Imp|Number=Sing|Person=2|Polarity=Neg|Style=Arch|VerbForm=Fin"},
    "Vi-S---2--N---6": {POS: VERB, "morph": "Mood=Imp|Number=Sing|Person=2|Polarity=Neg|Style=Coll|VerbForm=Fin"},
    "Vi-S---2--N---7": {POS: VERB, "morph": "Mood=Imp|Number=Sing|Person=2|Polarity=Neg|Style=Coll|VerbForm=Fin"},
    "Vi-S---3--A----": {POS: VERB, "morph": "Mood=Imp|Number=Sing|Person=3|Polarity=Pos|VerbForm=Fin"},
    "Vi-S---3--A---2": {POS: VERB, "morph": "Mood=Imp|Number=Sing|Person=3|Polarity=Pos|Style=Arch|VerbForm=Fin"},
    "Vi-S---3--A---3": {POS: VERB, "morph": "Mood=Imp|Number=Sing|Person=3|Polarity=Pos|Style=Arch|VerbForm=Fin"},
    "Vi-S---3--A---4": {POS: VERB, "morph": "Mood=Imp|Number=Sing|Person=3|Polarity=Pos|Style=Arch|VerbForm=Fin"},
    "Vi-S---3--A---9": {POS: VERB, "morph": "Mood=Imp|Number=Sing|Person=3|Polarity=Pos|VerbForm=Fin"},
    "Vi-S---3--N----": {POS: VERB, "morph": "Mood=Imp|Number=Sing|Person=3|Polarity=Neg|VerbForm=Fin"},
    "Vi-S---3--N---2": {POS: VERB, "morph": "Mood=Imp|Number=Sing|Person=3|Polarity=Neg|Style=Arch|VerbForm=Fin"},
    "Vi-S---3--N---3": {POS: VERB, "morph": "Mood=Imp|Number=Sing|Person=3|Polarity=Neg|Style=Arch|VerbForm=Fin"},
    "Vi-S---3--N---4": {POS: VERB, "morph": "Mood=Imp|Number=Sing|Person=3|Polarity=Neg|Style=Arch|VerbForm=Fin"},
    "Vi-S---3--N---9": {POS: VERB, "morph": "Mood=Imp|Number=Sing|Person=3|Polarity=Neg|VerbForm=Fin"},
    "Vi-X---2--A----": {POS: VERB, "morph": "Mood=Imp|Person=2|Polarity=Pos|VerbForm=Fin"},
    "Vi-X---2--N----": {POS: VERB, "morph": "Mood=Imp|Person=2|Polarity=Neg|VerbForm=Fin"},
    "VmHS------A----": {POS: VERB,"morph": "Aspect=Perf|Gender=Fem,Neut|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Conv|Voice=Act"},
    "VmHS------A---4": {POS: VERB,"morph": "Aspect=Perf|Gender=Fem,Neut|Number=Sing|Polarity=Pos|Style=Arch|Tense=Past|VerbForm=Conv|Voice=Act"},
    "VmHS------N----": {POS: VERB,"morph": "Aspect=Perf|Gender=Fem,Neut|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Conv|Voice=Act"},
    "VmHS------N---4": {POS: VERB,"morph": "Aspect=Perf|Gender=Fem,Neut|Number=Sing|Polarity=Neg|Style=Arch|Tense=Past|VerbForm=Conv|Voice=Act"},
    "VmXP------A----": {POS: VERB, "morph": "Aspect=Perf|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Conv|Voice=Act"},
    "VmXP------A---4": {POS: VERB,"morph": "Aspect=Perf|Number=Plur|Polarity=Pos|Style=Arch|Tense=Past|VerbForm=Conv|Voice=Act"},
    "VmXP------N----": {POS: VERB, "morph": "Aspect=Perf|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Conv|Voice=Act"},
    "VmXP------N---4": {POS: VERB,"morph": "Aspect=Perf|Number=Plur|Polarity=Neg|Style=Arch|Tense=Past|VerbForm=Conv|Voice=Act"},
    "VmYS------A----": {POS: VERB,"morph": "Aspect=Perf|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Conv|Voice=Act"},
    "VmYS------A---4": {POS: VERB,"morph": "Aspect=Perf|Gender=Masc|Number=Sing|Polarity=Pos|Style=Arch|Tense=Past|VerbForm=Conv|Voice=Act"},
    "VmYS------N----": {POS: VERB,"morph": "Aspect=Perf|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Conv|Voice=Act"},
    "VmYS------N---4": {POS: VERB,"morph": "Aspect=Perf|Gender=Masc|Number=Sing|Polarity=Neg|Style=Arch|Tense=Past|VerbForm=Conv|Voice=Act"},
    "VpFS---2R-AA---": {POS: VERB,"morph": "Gender=Fem|Number=Sing|Person=2|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpFS---2R-AA--1": {POS: VERB,"morph": "Gender=Fem|Number=Sing|Person=2|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpFS---2R-AA--6": {POS: VERB,"morph": "Gender=Fem|Number=Sing|Person=2|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpFS---2R-NA---": {POS: VERB,"morph": "Gender=Fem|Number=Sing|Person=2|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpFS---2R-NA--1": {POS: VERB,"morph": "Gender=Fem|Number=Sing|Person=2|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpFS---2R-NA--6": {POS: VERB,"morph": "Gender=Fem|Number=Sing|Person=2|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpMP---XR-AA---": {POS: VERB,"morph": "Animacy=Anim|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpMP---XR-AA--1": {POS: VERB,"morph": "Animacy=Anim|Gender=Masc|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpMP---XR-AA--3": {POS: VERB,"morph": "Animacy=Anim|Gender=Masc|Number=Plur|Polarity=Pos|Style=Arch|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpMP---XR-AA--6": {POS: VERB,"morph": "Animacy=Anim|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpMP---XR-NA---": {POS: VERB,"morph": "Animacy=Anim|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpMP---XR-NA--1": {POS: VERB,"morph": "Animacy=Anim|Gender=Masc|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpMP---XR-NA--3": {POS: VERB,"morph": "Animacy=Anim|Gender=Masc|Number=Plur|Polarity=Neg|Style=Arch|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpMP---XR-NA--6": {POS: VERB,"morph": "Animacy=Anim|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpNS---2R-AA---": {POS: VERB,"morph": "Gender=Neut|Number=Sing|Person=2|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpNS---2R-AA--1": {POS: VERB,"morph": "Gender=Neut|Number=Sing|Person=2|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpNS---2R-AA--6": {POS: VERB,"morph": "Gender=Neut|Number=Sing|Person=2|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpNS---2R-NA---": {POS: VERB,"morph": "Gender=Neut|Number=Sing|Person=2|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpNS---2R-NA--1": {POS: VERB,"morph": "Gender=Neut|Number=Sing|Person=2|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpNS---2R-NA--6": {POS: VERB,"morph": "Gender=Neut|Number=Sing|Person=2|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpNS---XR-AA---": {POS: VERB, "morph": "Gender=Neut|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpNS---XR-AA--1": {POS: VERB, "morph": "Gender=Neut|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpNS---XR-AA--3": {POS: VERB,"morph": "Gender=Neut|Number=Sing|Polarity=Pos|Style=Arch|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpNS---XR-AA--6": {POS: VERB,"morph": "Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpNS---XR-NA---": {POS: VERB, "morph": "Gender=Neut|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpNS---XR-NA--1": {POS: VERB, "morph": "Gender=Neut|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpNS---XR-NA--3": {POS: VERB,"morph": "Gender=Neut|Number=Sing|Polarity=Neg|Style=Arch|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpNS---XR-NA--6": {POS: VERB,"morph": "Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpQW---XR-AA---": {POS: VERB,"morph": "Gender=Fem,Neut|Number=Plur,Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpQW---XR-AA--1": {POS: VERB,"morph": "Gender=Fem,Neut|Number=Plur,Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpQW---XR-AA--3": {POS: VERB,"morph": "Gender=Fem,Neut|Number=Plur,Sing|Polarity=Pos|Style=Arch|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpQW---XR-AA--6": {POS: VERB,"morph": "Gender=Fem,Neut|Number=Plur,Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpQW---XR-NA---": {POS: VERB,"morph": "Gender=Fem,Neut|Number=Plur,Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpQW---XR-NA--1": {POS: VERB,"morph": "Gender=Fem,Neut|Number=Plur,Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpQW---XR-NA--3": {POS: VERB,"morph": "Gender=Fem,Neut|Number=Plur,Sing|Polarity=Neg|Style=Arch|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpQW---XR-NA--6": {POS: VERB,"morph": "Gender=Fem,Neut|Number=Plur,Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpTP---XR-AA---": {POS: VERB,"morph": "Animacy=Inan|Gender=Fem,Masc|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpTP---XR-AA--1": {POS: VERB,"morph": "Animacy=Inan|Gender=Fem,Masc|Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpTP---XR-AA--3": {POS: VERB,"morph": "Animacy=Inan|Gender=Fem,Masc|Number=Plur|Polarity=Pos|Style=Arch|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpTP---XR-AA--6": {POS: VERB,"morph": "Animacy=Inan|Gender=Fem,Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpTP---XR-NA---": {POS: VERB,"morph": "Animacy=Inan|Gender=Fem,Masc|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpTP---XR-NA--1": {POS: VERB,"morph": "Animacy=Inan|Gender=Fem,Masc|Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpTP---XR-NA--3": {POS: VERB,"morph": "Animacy=Inan|Gender=Fem,Masc|Number=Plur|Polarity=Neg|Style=Arch|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpTP---XR-NA--6": {POS: VERB,"morph": "Animacy=Inan|Gender=Fem,Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpXP---XR-AA---": {POS: VERB, "morph": "Number=Plur|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpXP---XR-NA---": {POS: VERB, "morph": "Number=Plur|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpXS---XR-AA---": {POS: VERB, "morph": "Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpXS---XR-NA---": {POS: VERB, "morph": "Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpXX---XR-AA---": {POS: VERB, "morph": "Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpXX---XR-NA---": {POS: VERB, "morph": "Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpYS---2R-AA---": {POS: VERB,"morph": "Gender=Masc|Number=Sing|Person=2|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpYS---2R-AA--1": {POS: VERB,"morph": "Gender=Masc|Number=Sing|Person=2|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpYS---2R-AA--6": {POS: VERB,"morph": "Gender=Masc|Number=Sing|Person=2|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpYS---2R-NA---": {POS: VERB,"morph": "Gender=Masc|Number=Sing|Person=2|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpYS---2R-NA--1": {POS: VERB,"morph": "Gender=Masc|Number=Sing|Person=2|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpYS---2R-NA--6": {POS: VERB,"morph": "Gender=Masc|Number=Sing|Person=2|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpYS---XR-AA---": {POS: VERB, "morph": "Gender=Masc|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpYS---XR-AA--1": {POS: VERB, "morph": "Gender=Masc|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpYS---XR-AA--6": {POS: VERB,"morph": "Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpYS---XR-AA--8": {POS: VERB,"morph": "Abbr=Yes|Gender=Masc|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpYS---XR-AA--9": {POS: VERB, "morph": "Gender=Masc|Number=Sing|Polarity=Pos|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpYS---XR-NA---": {POS: VERB, "morph": "Gender=Masc|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpYS---XR-NA--1": {POS: VERB, "morph": "Gender=Masc|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpYS---XR-NA--6": {POS: VERB,"morph": "Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|Voice=Act"},
    "VpYS---XR-NA--8": {POS: VERB,"morph": "Abbr=Yes|Gender=Masc|Number=Sing|Polarity=Neg|Tense=Past|VerbForm=Part|Voice=Act"},
    "VqMP---XR-AA--2": {POS: VERB,"morph": "Animacy=Anim|Gender=Masc|Number=Plur|Polarity=Pos|Style=Arch|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqMP---XR-AA--3": {POS: VERB,"morph": "Animacy=Anim|Gender=Masc|Number=Plur|Polarity=Pos|Style=Arch|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqMP---XR-AA--7": {POS: VERB,"morph": "Animacy=Anim|Gender=Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqMP---XR-NA--2": {POS: VERB,"morph": "Animacy=Anim|Gender=Masc|Number=Plur|Polarity=Neg|Style=Arch|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqMP---XR-NA--3": {POS: VERB,"morph": "Animacy=Anim|Gender=Masc|Number=Plur|Polarity=Neg|Style=Arch|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqMP---XR-NA--7": {POS: VERB,"morph": "Animacy=Anim|Gender=Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqNS---XR-AA--2": {POS: VERB,"morph": "Gender=Neut|Number=Sing|Polarity=Pos|Style=Arch|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqNS---XR-AA--3": {POS: VERB,"morph": "Gender=Neut|Number=Sing|Polarity=Pos|Style=Arch|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqNS---XR-AA--7": {POS: VERB,"morph": "Gender=Neut|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqNS---XR-NA--2": {POS: VERB,"morph": "Gender=Neut|Number=Sing|Polarity=Neg|Style=Arch|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqNS---XR-NA--3": {POS: VERB,"morph": "Gender=Neut|Number=Sing|Polarity=Neg|Style=Arch|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqNS---XR-NA--7": {POS: VERB,"morph": "Gender=Neut|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqQW---XR-AA--2": {POS: VERB,"morph": "Gender=Fem,Neut|Number=Plur,Sing|Polarity=Pos|Style=Arch|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqQW---XR-AA--3": {POS: VERB,"morph": "Gender=Fem,Neut|Number=Plur,Sing|Polarity=Pos|Style=Arch|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqQW---XR-AA--7": {POS: VERB,"morph": "Gender=Fem,Neut|Number=Plur,Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqQW---XR-NA--2": {POS: VERB,"morph": "Gender=Fem,Neut|Number=Plur,Sing|Polarity=Neg|Style=Arch|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqQW---XR-NA--3": {POS: VERB,"morph": "Gender=Fem,Neut|Number=Plur,Sing|Polarity=Neg|Style=Arch|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqQW---XR-NA--7": {POS: VERB,"morph": "Gender=Fem,Neut|Number=Plur,Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqTP---XR-AA--2": {POS: VERB,"morph": "Animacy=Inan|Gender=Fem,Masc|Number=Plur|Polarity=Pos|Style=Arch|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqTP---XR-AA--3": {POS: VERB,"morph": "Animacy=Inan|Gender=Fem,Masc|Number=Plur|Polarity=Pos|Style=Arch|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqTP---XR-AA--7": {POS: VERB,"morph": "Animacy=Inan|Gender=Fem,Masc|Number=Plur|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqTP---XR-NA--2": {POS: VERB,"morph": "Animacy=Inan|Gender=Fem,Masc|Number=Plur|Polarity=Neg|Style=Arch|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqTP---XR-NA--3": {POS: VERB,"morph": "Animacy=Inan|Gender=Fem,Masc|Number=Plur|Polarity=Neg|Style=Arch|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqTP---XR-NA--7": {POS: VERB,"morph": "Animacy=Inan|Gender=Fem,Masc|Number=Plur|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqYS---XR-AA--2": {POS: VERB,"morph": "Gender=Masc|Number=Sing|Polarity=Pos|Style=Arch|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqYS---XR-AA--3": {POS: VERB,"morph": "Gender=Masc|Number=Sing|Polarity=Pos|Style=Arch|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqYS---XR-AA--7": {POS: VERB,"morph": "Gender=Masc|Number=Sing|Polarity=Pos|Style=Coll|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqYS---XR-NA--2": {POS: VERB,"morph": "Gender=Masc|Number=Sing|Polarity=Neg|Style=Arch|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqYS---XR-NA--3": {POS: VERB,"morph": "Gender=Masc|Number=Sing|Polarity=Neg|Style=Arch|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VqYS---XR-NA--7": {POS: VERB,"morph": "Gender=Masc|Number=Sing|Polarity=Neg|Style=Coll|Tense=Past|VerbForm=Part|VerbType=Verbconj|Voice=Act"},
    "VsFS---2H-AP---": {POS: VERB,"morph": "Gender=Fem|Number=Sing|Person=2|Polarity=Pos|Tense=Past,Pres|VerbForm=Part|Voice=Pass"},
    "VsFS---2H-AP--2": {POS: VERB,"morph": "Gender=Fem|Number=Sing|Person=2|Polarity=Pos|Style=Arch|Tense=Past,Pres|VerbForm=Part|Voice=Pass"},
    "VsFS---2H-NP---": {POS: VERB,"morph": "Gender=Fem|Number=Sing|Person=2|Polarity=Neg|Tense=Past,Pres|VerbForm=Part|Voice=Pass"},
    "VsFS---2H-NP--2": {POS: VERB,"morph": "Gender=Fem|Number=Sing|Person=2|Polarity=Neg|Style=Arch|Tense=Past,Pres|VerbForm=Part|Voice=Pass"},
    "VsFS4--XX-AP---": {POS: VERB, "morph": "Case=Acc|Gender=Fem|Number=Sing|Polarity=Pos|VerbForm=Part|Voice=Pass"},
    "VsFS4--XX-AP--2": {POS: VERB,"morph": "Case=Acc|Gender=Fem|Number=Sing|Polarity=Pos|Style=Arch|VerbForm=Part|Voice=Pass"},
    "VsFS4--XX-NP---": {POS: VERB, "morph": "Case=Acc|Gender=Fem|Number=Sing|Polarity=Neg|VerbForm=Part|Voice=Pass"},
    "VsFS4--XX-NP--2": {POS: VERB,"morph": "Case=Acc|Gender=Fem|Number=Sing|Polarity=Neg|Style=Arch|VerbForm=Part|Voice=Pass"},
    "VsMP---XX-AP---": {POS: VERB,"morph": "Animacy=Anim|Gender=Masc|Number=Plur|Polarity=Pos|VerbForm=Part|Voice=Pass"},
    "VsMP---XX-AP--2": {POS: VERB,"morph": "Animacy=Anim|Gender=Masc|Number=Plur|Polarity=Pos|Style=Arch|VerbForm=Part|Voice=Pass"},
    "VsMP---XX-NP---": {POS: VERB,"morph": "Animacy=Anim|Gender=Masc|Number=Plur|Polarity=Neg|VerbForm=Part|Voice=Pass"},
    "VsMP---XX-NP--2": {POS: VERB,"morph": "Animacy=Anim|Gender=Masc|Number=Plur|Polarity=Neg|Style=Arch|VerbForm=Part|Voice=Pass"},
    "VsNS---2H-AP---": {POS: VERB,"morph": "Gender=Neut|Number=Sing|Person=2|Polarity=Pos|Tense=Past,Pres|VerbForm=Part|Voice=Pass"},
    "VsNS---2H-AP--2": {POS: VERB,"morph": "Gender=Neut|Number=Sing|Person=2|Polarity=Pos|Style=Arch|Tense=Past,Pres|VerbForm=Part|Voice=Pass"},
    "VsNS---2H-NP---": {POS: VERB,"morph": "Gender=Neut|Number=Sing|Person=2|Polarity=Neg|Tense=Past,Pres|VerbForm=Part|Voice=Pass"},
    "VsNS---2H-NP--2": {POS: VERB,"morph": "Gender=Neut|Number=Sing|Person=2|Polarity=Neg|Style=Arch|Tense=Past,Pres|VerbForm=Part|Voice=Pass"},
    "VsNS---XX-AP---": {POS: VERB, "morph": "Gender=Neut|Number=Sing|Polarity=Pos|VerbForm=Part|Voice=Pass"},
    "VsNS---XX-AP--2": {POS: VERB, "morph": "Gender=Neut|Number=Sing|Polarity=Pos|Style=Arch|VerbForm=Part|Voice=Pass"},
    "VsNS---XX-NP---": {POS: VERB, "morph": "Gender=Neut|Number=Sing|Polarity=Neg|VerbForm=Part|Voice=Pass"},
    "VsNS---XX-NP--2": {POS: VERB, "morph": "Gender=Neut|Number=Sing|Polarity=Neg|Style=Arch|VerbForm=Part|Voice=Pass"},
    "VsQW---XX-AP---": {POS: VERB, "morph": "Gender=Fem,Neut|Number=Plur,Sing|Polarity=Pos|VerbForm=Part|Voice=Pass"},
    "VsQW---XX-AP--2": {POS: VERB,"morph": "Gender=Fem,Neut|Number=Plur,Sing|Polarity=Pos|Style=Arch|VerbForm=Part|Voice=Pass"},
    "VsQW---XX-NP---": {POS: VERB, "morph": "Gender=Fem,Neut|Number=Plur,Sing|Polarity=Neg|VerbForm=Part|Voice=Pass"},
    "VsQW---XX-NP--2": {POS: VERB,"morph": "Gender=Fem,Neut|Number=Plur,Sing|Polarity=Neg|Style=Arch|VerbForm=Part|Voice=Pass"},
    "VsTP---XX-AP---": {POS: VERB,"morph": "Animacy=Inan|Gender=Fem,Masc|Number=Plur|Polarity=Pos|VerbForm=Part|Voice=Pass"},
    "VsTP---XX-AP--2": {POS: VERB,"morph": "Animacy=Inan|Gender=Fem,Masc|Number=Plur|Polarity=Pos|Style=Arch|VerbForm=Part|Voice=Pass"},
    "VsTP---XX-NP---": {POS: VERB,"morph": "Animacy=Inan|Gender=Fem,Masc|Number=Plur|Polarity=Neg|VerbForm=Part|Voice=Pass"},
    "VsTP---XX-NP--2": {POS: VERB,"morph": "Animacy=Inan|Gender=Fem,Masc|Number=Plur|Polarity=Neg|Style=Arch|VerbForm=Part|Voice=Pass"},
    "VsYS---2H-AP---": {POS: VERB,"morph": "Gender=Masc|Number=Sing|Person=2|Polarity=Pos|Tense=Past,Pres|VerbForm=Part|Voice=Pass"},
    "VsYS---XX-AP---": {POS: VERB, "morph": "Gender=Masc|Number=Sing|Polarity=Pos|VerbForm=Part|Voice=Pass"},
    "VsYS---XX-AP--2": {POS: VERB, "morph": "Gender=Masc|Number=Sing|Polarity=Pos|Style=Arch|VerbForm=Part|Voice=Pass"},
    "VsYS---XX-NP---": {POS: VERB, "morph": "Gender=Masc|Number=Sing|Polarity=Neg|VerbForm=Part|Voice=Pass"},
    "VsYS---XX-NP--2": {POS: VERB, "morph": "Gender=Masc|Number=Sing|Polarity=Neg|Style=Arch|VerbForm=Part|Voice=Pass"},
    "Vt-P---1F-AA--2": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=1|Polarity=Pos|Style=Arch|Tense=Fut|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-P---1F-AA--3": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=1|Polarity=Pos|Style=Arch|Tense=Fut|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-P---1F-NA--2": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=1|Polarity=Neg|Style=Arch|Tense=Fut|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-P---1F-NA--3": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=1|Polarity=Neg|Style=Arch|Tense=Fut|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-P---1P-AA--2": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=1|Polarity=Pos|Style=Arch|Tense=Pres|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-P---1P-AA--3": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=1|Polarity=Pos|Style=Arch|Tense=Pres|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-P---1P-NA--2": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=1|Polarity=Neg|Style=Arch|Tense=Pres|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-P---1P-NA--3": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=1|Polarity=Neg|Style=Arch|Tense=Pres|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-P---2F-AA--2": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=2|Polarity=Pos|Style=Arch|Tense=Fut|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-P---2F-NA--2": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=2|Polarity=Neg|Style=Arch|Tense=Fut|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-P---2P-AA--2": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=2|Polarity=Pos|Style=Arch|Tense=Pres|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-P---2P-NA--2": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=2|Polarity=Neg|Style=Arch|Tense=Pres|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-P---3F-AA--2": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Pos|Style=Arch|Tense=Fut|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-P---3F-AA--3": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Pos|Style=Arch|Tense=Fut|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-P---3F-NA--2": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Neg|Style=Arch|Tense=Fut|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-P---3F-NA--3": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Neg|Style=Arch|Tense=Fut|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-P---3P-AA--2": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Pos|Style=Arch|Tense=Pres|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-P---3P-AA--3": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Pos|Style=Arch|Tense=Pres|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-P---3P-AA--9": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Pos|Tense=Pres|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-P---3P-NA--2": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Neg|Style=Arch|Tense=Pres|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-P---3P-NA--3": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Neg|Style=Arch|Tense=Pres|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-P---3P-NA--9": {POS: VERB,"morph": "Mood=Ind|Number=Plur|Person=3|Polarity=Neg|Tense=Pres|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-S---1F-AA--2": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=1|Polarity=Pos|Style=Arch|Tense=Fut|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-S---1F-AA--3": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=1|Polarity=Pos|Style=Arch|Tense=Fut|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-S---1F-NA--2": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=1|Polarity=Neg|Style=Arch|Tense=Fut|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-S---1F-NA--3": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=1|Polarity=Neg|Style=Arch|Tense=Fut|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-S---1P-AA--2": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=1|Polarity=Pos|Style=Arch|Tense=Pres|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-S---1P-AA--3": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=1|Polarity=Pos|Style=Arch|Tense=Pres|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-S---1P-NA--2": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=1|Polarity=Neg|Style=Arch|Tense=Pres|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-S---1P-NA--3": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=1|Polarity=Neg|Style=Arch|Tense=Pres|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-S---2F-AA--2": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=2|Polarity=Pos|Style=Arch|Tense=Fut|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-S---2F-NA--2": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=2|Polarity=Neg|Style=Arch|Tense=Fut|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-S---2P-AA--2": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=2|Polarity=Pos|Style=Arch|Tense=Pres|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-S---2P-NA--2": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=2|Polarity=Neg|Style=Arch|Tense=Pres|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-S---3F-AA--2": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=3|Polarity=Pos|Style=Arch|Tense=Fut|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-S---3F-NA--2": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=3|Polarity=Neg|Style=Arch|Tense=Fut|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-S---3P-AA--2": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=3|Polarity=Pos|Style=Arch|Tense=Pres|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "Vt-S---3P-NA--2": {POS: VERB,"morph": "Mood=Ind|Number=Sing|Person=3|Polarity=Neg|Style=Arch|Tense=Pres|VerbForm=Fin|VerbType=Verbconj|Voice=Act"},
    "X@-------------": {POS: X, "morph": "_"},
    "X@------------0": {POS: X, "morph": "_"},
    "X@------------1": {POS: X, "morph": "_"},
    "Xx-------------": {POS: X, "morph": "Abbr=Yes"},
    "XX-------------": {POS: X, "morph": "_"},
    "XX------------8": {POS: X, "morph": "Abbr=Yes"},
    "Z:-------------": {POS: PUNCT, "morph": "_"},
    "Z#-------------": {POS: PUNCT, "morph": "PunctType=Root"},
}
