# coding: utf8
from __future__ import unicode_literals

from ...symbols import POS, PUNCT, ADJ, NUM, DET, ADV, ADP, X, VERB
from ...symbols import NOUN, PROPN, SPACE, PRON, CONJ


TAG_MAP = {
    "ADJ__Number=Sing": {POS: ADJ},
    "ADJ___": {POS: ADJ},
    "ADP__AdpType=Prep": {POS: ADP},
    "ADP__AdpType=Preppron|Gender=Fem|Number=Sing": {POS: ADP},
    "ADP__AdpType=Preppron|Gender=Masc|Number=Plur": {POS: ADP},
    "ADP__AdpType=Preppron|Gender=Masc|Number=Sing": {POS: ADP},
    "ADV__Number=Sing": {POS: ADV},
    "ADV__PunctType=Comm": {POS: ADV},
    "ADV___": {POS: ADV},
    "Adj_Adj_N_N__Degree=Pos|Number=Sing": {POS: ADJ},
    "Adj_Adj_N__Degree=Pos|Number=Plur|Variant=Short": {POS: ADJ},
    "Adj_Adj_N__Degree=Pos|Number=Sing": {POS: ADJ},
    "Adj_Adj__Case=Nom|Degree=Pos": {POS: ADJ},
    "Adj_Adj__Degree=Pos": {POS: ADJ},
    "Adj_Adj__Degree=Pos|Variant=Short": {POS: ADJ},
    "Adj_Adv__Degree=Pos|Variant=Short": {POS: ADJ},
    "Adj_Adv|adv|stell|onverv_deelv__Degree=Pos|Variant=Short": {POS: ADJ},
    "Adj_Art__Degree=Pos|Number=Sing": {POS: ADJ},
    "Adj_Art__Degree=Pos|Number=Sing|Variant=Short": {POS: ADJ},
    "Adj_Conj_V__Degree=Pos|Mood=Sub|VerbForm=Fin": {POS: ADJ},
    "Adj_Int|attr|stell|vervneut__Case=Nom|Degree=Pos": {POS: ADJ},
    "Adj_Misc_Misc__Degree=Pos": {POS: ADJ},
    "Adj_N_Conj_N__Degree=Pos|Number=Sing": {POS: ADJ},
    "Adj_N_N_N_N__Degree=Pos|Number=Sing": {POS: ADJ},
    "Adj_N_N_N__Degree=Pos|Number=Sing": {POS: ADJ},
    "Adj_N_N__Degree=Pos|Number=Sing": {POS: ADJ},
    "Adj_N_Num__Definite=Def|Degree=Pos|Number=Sing": {POS: ADJ},
    "Adj_N_Prep_Art_Adj_N__Degree=Pos|Gender=Neut|Number=Sing": {POS: ADJ},
    "Adj_N_Prep_N_Conj_N__Degree=Pos|Number=Sing": {POS: ADJ},
    "Adj_N_Prep_N_N__Degree=Pos|Number=Sing": {POS: ADJ},
    "Adj_N_Prep_N__Degree=Pos|Number=Sing": {POS: ADJ},
    "Adj_N_Punc__Degree=Pos|Number=Sing": {POS: ADJ},
    "Adj_N__Degree=Pos|Number=Plur": {POS: ADJ},
    "Adj_N__Degree=Pos|Number=Sing": {POS: ADJ},
    "Adj_N__Degree=Pos|Number=Sing|Variant=Short": {POS: ADJ},
    "Adj_Num__Definite=Def|Degree=Pos": {POS: ADJ},
    "Adj_Num__Definite=Def|Degree=Pos|Variant=Short": {POS: ADJ},
    "Adj_Prep|adv|stell|vervneut_voor__Degree=Pos|Variant=Short": {POS: ADJ},
    "Adj_Prep|adv|vergr|onverv_voor__Degree=Cmp|Variant=Short": {POS: ADJ},
    "Adj_V_Conj_V__Degree=Pos|VerbForm=Inf": {POS: ADJ},
    "Adj_V_N__Degree=Pos|Number=Sing|Tense=Past|VerbForm=Part": {POS: ADJ},
    "Adj_V|adv|stell|onverv_intrans|inf__Degree=Pos|Variant=Short|VerbForm=Inf": {
        POS: ADJ
    },
    "Adj_V|adv|stell|onverv_trans|imp__Degree=Pos|Mood=Imp|Variant=Short|VerbForm=Fin": {
        POS: ADJ
    },
    "Adj|adv|stell|onverv__Degree=Pos|Variant=Short": {POS: ADJ},
    "Adj|adv|stell|vervneut__Case=Nom|Degree=Pos|Variant=Short": {POS: ADJ},
    "Adj|adv|vergr|onverv__Degree=Cmp|Variant=Short": {POS: ADJ},
    "Adj|adv|vergr|vervneut__Case=Nom|Degree=Cmp|Variant=Short": {POS: ADJ},
    "Adj|attr|overtr|onverv__Degree=Sup": {POS: ADJ},
    "Adj|attr|overtr|vervneut__Case=Nom|Degree=Sup": {POS: ADJ},
    "Adj|attr|stell|onverv__Degree=Pos": {POS: ADJ},
    "Adj|attr|stell|vervgen__Case=Gen|Degree=Pos": {POS: ADJ},
    "Adj|attr|stell|vervneut__Case=Nom|Degree=Pos": {POS: ADJ},
    "Adj|attr|vergr|onverv__Degree=Cmp": {POS: ADJ},
    "Adj|attr|vergr|vervgen__Case=Gen|Degree=Cmp": {POS: ADJ},
    "Adj|attr|vergr|vervneut__Case=Nom|Degree=Cmp": {POS: ADJ},
    "Adj|zelfst|overtr|vervneut__Case=Nom|Degree=Sup": {POS: ADJ},
    "Adj|zelfst|stell|onverv__Degree=Pos": {POS: ADJ},
    "Adj|zelfst|stell|vervmv__Degree=Pos|Number=Plur": {POS: ADJ},
    "Adj|zelfst|stell|vervneut__Case=Nom|Degree=Pos": {POS: ADJ},
    "Adj|zelfst|vergr|vervneut__Case=Nom|Degree=Cmp": {POS: ADJ},
    "Adv_Adj_Conj__Degree=Pos": {POS: ADV},
    "Adv_Adj__Degree=Cmp": {POS: ADV},
    "Adv_Adj__Degree=Pos": {POS: ADV},
    "Adv_Adv_Conj_Adv__PronType=Dem": {POS: ADV},
    "Adv_Adv__AdpType=Prep": {POS: ADV},
    "Adv_Adv__Degree=Pos": {POS: ADV},
    "Adv_Adv__Degree=Pos|PronType=Dem": {POS: ADV},
    "Adv_Adv|pron|vrag_deeladv___": {POS: ADV},
    "Adv_Art__Degree=Pos|Number=Sing": {POS: ADV},
    "Adv_Art__Number=Sing": {POS: ADV},
    "Adv_Conj_Adv__AdpType=Preppron|Gender=Masc|Number=Sing": {POS: ADV},
    "Adv_Conj_Adv__Degree=Pos": {POS: ADV},
    "Adv_Conj_Adv|gew|aanw_neven_gew|aanw__PronType=Dem": {POS: ADV},
    "Adv_Conj_Adv|gew|onbep_neven_gew|onbep__PronType=Ind": {POS: ADV},
    "Adv_Conj_N__Degree=Pos|Number=Sing": {POS: ADV},
    "Adv_Conj__Degree=Pos": {POS: ADV},
    "Adv_N__Degree=Pos|Number=Sing": {POS: ADV},
    "Adv_Num__Degree=Cmp|PronType=Ind": {POS: ADV},
    "Adv_N|gew|aanw_soort|ev|neut__Number=Sing": {POS: ADV},
    "Adv_Prep_N__Case=Dat|Degree=Pos|Number=Sing": {POS: ADV},
    "Adv_Prep_Pron__AdpType=Preppron|Gender=Masc|Number=Sing": {POS: ADV},
    "Adv_Prep__Degree=Pos": {POS: ADV},
    "Adv_Prep|gew|aanw_voor__AdpType=Prep": {POS: ADV},
    "Adv_Prep|gew|aanw_voor___": {POS: ADV},
    "Adv_Pron__Degree=Pos": {POS: ADV},
    "Adv|deeladv__PartType=Vbp": {POS: ADV},
    "Adv|deelv__PartType=Vbp": {POS: ADV},
    "Adv|gew|aanw__PronType=Dem": {POS: ADV},
    "Adv|gew|betr__PronType=Rel": {POS: ADV},
    "Adv|gew|er__AdvType=Ex": {POS: ADV},
    "Adv|gew|geenfunc|overtr|onverv__Degree=Sup": {POS: ADV},
    "Adv|gew|geenfunc|stell|onverv__Degree=Pos": {POS: ADV},
    "Adv|gew|geenfunc|vergr|onverv__Degree=Cmp": {POS: ADV},
    "Adv|gew|onbep__PronType=Ind": {POS: ADV},
    "Adv|gew|vrag__PronType=Int": {POS: ADV},
    "Adv|pron|aanw__PronType=Dem": {POS: ADV},
    "Adv|pron|betr__PronType=Rel": {POS: ADV},
    "Adv|pron|er__AdvType=Ex": {POS: ADV},
    "Adv|pron|onbep__PronType=Ind": {POS: ADV},
    "Adv|pron|vrag__PronType=Int": {POS: ADV},
    "Art_Adj_N__AdpType=Prep": {POS: DET},
    "Art_Adj_N__Definite=Def|Degree=Sup|Gender=Neut|Number=Sing": {POS: DET},
    "Art_Adj__Case=Nom|Definite=Def|Degree=Cmp|Gender=Neut": {POS: DET},
    "Art_Adj__Case=Nom|Definite=Def|Degree=Sup|Gender=Neut": {POS: DET},
    "Art_Adj__Definite=Def|Degree=Cmp|Gender=Neut": {POS: DET},
    "Art_Adj__Definite=Def|Degree=Sup|Gender=Neut": {POS: DET},
    "Art_Adv__Definite=Def|Degree=Sup|Gender=Neut": {POS: DET},
    "Art_Conj_Pron__Number=Sing|PronType=Ind": {POS: DET},
    "Art_N_Conj_Art_N__Definite=Def|Gender=Neut|Number=Sing": {POS: DET},
    "Art_N_Conj_Art_V__AdpType=Prep": {POS: DET},
    "Art_N_Conj_Pron_N__Definite=Def|Gender=Neut|Number=Plur|Person=3": {POS: DET},
    "Art_N_Conj__Number=Sing|PronType=Ind": {POS: DET},
    "Art_N_N__AdpType=Prep": {POS: DET},
    "Art_N_Prep_Adj__Degree=Pos|Number=Sing|PronType=Ind": {POS: DET},
    "Art_N_Prep_Art_N__Number=Sing|PronType=Ind": {POS: DET},
    "Art_N_Prep_N__AdpType=Prep": {POS: DET},
    "Art_N_Prep_N__Definite=Def|Gender=Neut|Number=Sing": {POS: DET},
    "Art_N_Prep_N__Number=Sing|PronType=Ind": {POS: DET},
    "Art_N_Prep_Pron_N__AdpType=Prep": {POS: DET},
    "Art_N__AdpType=Prep": {POS: DET},
    "Art_N__Case=Gen|Definite=Def|Number=Sing": {POS: DET},
    "Art_N__Number=Sing|PronType=Ind": {POS: DET},
    "Art_Num_Art_Adj__AdpType=Prep": {POS: DET},
    "Art_Num_N__AdpType=Prep": {POS: DET},
    "Art_Num__Definite=Def|Degree=Sup|Gender=Neut|PronType=Ind": {POS: DET},
    "Art_Num__Definite=Def|Gender=Neut": {POS: DET},
    "Art_Num__Degree=Pos|Number=Sing|PronType=Ind": {POS: DET},
    "Art_N|bep|onzijd|neut_eigen|ev|neut__Definite=Def|Gender=Neut|Number=Sing": {
        POS: DET
    },
    "Art_N|bep|onzijd|neut_soort|ev|neut__Definite=Def|Gender=Neut|Number=Sing": {
        POS: DET
    },
    "Art_Pron_N__Case=Gen|Number=Plur|PronType=Ind": {POS: DET},
    "Art_Pron__Number=Sing|PronType=Ind": {POS: DET},
    "Art_V_N__AdpType=Prep": {POS: DET},
    "Art|bep|onzijd|neut__Definite=Def|Gender=Neut|PronType=Art": {POS: DET},
    "Art|bep|zijdofmv|gen__Case=Gen|Definite=Def|PronType=Art": {POS: DET},
    "Art|bep|zijdofmv|neut__Definite=Def|PronType=Art": {POS: DET},
    "Art|bep|zijdofonzijd|gen__Case=Gen|Definite=Def|Number=Sing|PronType=Art": {
        POS: DET
    },
    "Art|bep|zijd|dat__Case=Dat|Definite=Def|Gender=Com|PronType=Art": {POS: DET},
    "Art|onbep|zijdofonzijd|neut__Definite=Ind|Number=Sing|PronType=Art": {POS: DET},
    "CCONJ___": {POS: CONJ},
    "Conj_Adj|neven_adv|vergr|onverv__Degree=Cmp": {POS: CONJ},
    "Conj_Adj|neven_attr|stell|onverv__Degree=Pos": {POS: CONJ},
    "Conj_Adv_Adv__Degree=Pos": {POS: CONJ},
    "Conj_Adv__AdpType=Prep": {POS: CONJ},
    "Conj_Adv__AdpType=Preppron|Gender=Masc|Number=Plur": {POS: CONJ},
    "Conj_Adv__Degree=Pos": {POS: CONJ},
    "Conj_Adv|neven_gew|aanw__PronType=Dem": {POS: CONJ},
    "Conj_Art_N__AdpType=Preppron|Gender=Masc|Number=Plur": {POS: CONJ},
    "Conj_Art_N__Gender=Neut|Number=Sing": {POS: CONJ},
    "Conj_Conj|neven_onder|metfin___": {POS: CONJ},
    "Conj_Int|neven___": {POS: CONJ},
    "Conj_Int|onder|metfin___": {POS: CONJ},
    "Conj_N_Adv__AdpType=Preppron|Gender=Masc|Number=Plur": {POS: CONJ},
    "Conj_N_Prep__AdpType=Preppron|Gender=Masc|Number=Plur": {POS: CONJ},
    "Conj_N|onder|metfin_soort|ev|neut__AdpType=Preppron|Gender=Masc|Number=Plur": {
        POS: CONJ
    },
    "Conj_Pron_Adv__Degree=Pos|Number=Sing|Person=3": {POS: CONJ},
    "Conj_Pron_V__AdpType=Preppron|Gender=Masc|Number=Plur": {POS: CONJ},
    "Conj_Pron|neven_aanw|neut|zelfst__AdpType=Prep": {POS: CONJ},
    "Conj_Punc_Conj|neven_schuinstreep_neven__AdpType=Prep": {POS: CONJ},
    "Conj_V|onder|metfin_intrans|ott|3|ev__AdpType=Preppron|Gender=Masc|Number=Plur": {
        POS: CONJ
    },
    "Conj|neven___": {POS: CONJ},
    "Conj|onder|metfin___": {POS: CONJ},
    "Conj|onder|metinf___": {POS: CONJ},
    "DET__Degree=Cmp|NumType=Card|PronType=Ind": {POS: DET},
    "DET__Gender=Fem|Number=Sing|Number[psor]=Plur|Person=1|Poss=Yes|PronType=Prs": {
        POS: DET
    },
    "DET__Gender=Fem|Number=Sing|PronType=Art": {POS: DET},
    "DET__Gender=Masc|Number=Plur|PronType=Art": {POS: DET},
    "DET__Gender=Masc|Number=Sing|PronType=Tot": {POS: DET},
    "Int_Adv|gew|aanw___": {POS: X},
    "Int_Int__NumType=Card": {POS: X},
    "Int_Int___": {POS: X},
    "Int_N_N_Misc_N___": {POS: X},
    "Int_N_Punc_Int_N__Number=Sing": {POS: X},
    "Int_Punc_Int|komma__PunctType=Comm": {POS: X},
    "Int___": {POS: X},
    "Misc_Misc_Misc_Misc_Misc_Misc_Misc_Misc_Misc___": {POS: X},
    "Misc_Misc_Misc_Misc_Misc_Misc_Misc___": {POS: X},
    "Misc_Misc_Misc_Misc_Misc_Misc_Punc_Misc_Misc_Misc___": {POS: X},
    "Misc_Misc_Misc_Misc_Misc_Misc___": {POS: X},
    "Misc_Misc_Misc_Misc_Misc_N_Misc_Misc_Misc_Misc_Misc_Misc___": {POS: X},
    "Misc_Misc_Misc_Misc|vreemd_vreemd_vreemd_vreemd__AdpType=Preppron|Gender=Masc|Number=Sing": {
        POS: X
    },
    "Misc_Misc_Misc_Misc|vreemd_vreemd_vreemd_vreemd___": {POS: X},
    "Misc_Misc_Misc_N__Number=Sing": {POS: X},
    "Misc_Misc_Misc|vreemd_vreemd_vreemd___": {POS: X},
    "Misc_Misc_N_N__Number=Sing": {POS: X},
    "Misc_Misc_N|vreemd_vreemd_soort|mv|neut__Number=Plur": {POS: X},
    "Misc_Misc_Punc_N_N__Number=Sing": {POS: X},
    "Misc_Misc|vreemd_vreemd__AdpType=Prep": {POS: X},
    "Misc_Misc|vreemd_vreemd__NumType=Card": {POS: X},
    "Misc_Misc|vreemd_vreemd___": {POS: X},
    "Misc_N_Misc_Misc__Number=Sing": {POS: X},
    "Misc_N_N__Number=Sing": {POS: X},
    "Misc_N|vreemd_eigen|ev|neut__Number=Sing": {POS: X},
    "Misc_N|vreemd_soort|ev|neut__Number=Sing": {POS: X},
    "Misc|vreemd__Foreign=Yes": {POS: X},
    "NUM__Case=Nom|Definite=Def|Degree=Pos|NumType=Card": {POS: NUM},
    "NUM__Definite=Def|Degree=Pos|NumType=Card": {POS: NUM},
    "NUM__Definite=Def|Degree=Pos|Number=Sing|NumType=Card": {POS: NUM},
    "NUM__Definite=Def|NumType=Card": {POS: NUM},
    "NUM__Definite=Def|Number=Plur|NumType=Card": {POS: NUM},
    "NUM__Definite=Def|Number=Sing|NumType=Card": {POS: NUM},
    "NUM__NumForm=Digit|NumType=Card": {POS: NUM},
    "NUM__NumType=Card": {POS: NUM},
    "N_Adj_N_Num__Definite=Def|Degree=Pos|Number=Sing": {POS: NOUN},
    "N_Adj_N__Degree=Pos|Number=Plur": {POS: NOUN},
    "N_Adj_N___": {POS: NOUN},
    "N_Adj__AdpType=Prep": {POS: NOUN},
    "N_Adj__Case=Nom|Degree=Pos|Number=Plur": {POS: NOUN},
    "N_Adj__Case=Nom|Degree=Pos|Number=Sing": {POS: NOUN},
    "N_Adj__Degree=Pos|Number=Plur": {POS: NOUN},
    "N_Adj__Degree=Pos|Number=Sing": {POS: NOUN},
    "N_Adj___": {POS: NOUN},
    "N_Adv_Punc_V_Pron_V__Aspect=Imp|Degree=Pos|Mood=Ind|Number=Sing|Person=2|Tense=Pres|VerbForm=Inf": {
        POS: NOUN
    },
    "N_Adv__Degree=Pos|Number=Sing": {POS: NOUN},
    "N_Adv___": {POS: NOUN},
    "N_Adv|soort|ev|neut_deelv__Number=Sing": {POS: NOUN},
    "N_Art_Adj_Prep_N___": {POS: NOUN},
    "N_Art_N__Case=Gen|Number=Sing": {POS: NOUN},
    "N_Art_N__Number=Plur": {POS: NOUN},
    "N_Art_N__Number=Sing": {POS: NOUN},
    "N_Art_N___": {POS: NOUN},
    "N_Conj_Adv__Degree=Pos|Number=Sing": {POS: NOUN},
    "N_Conj_Art_N___": {POS: NOUN},
    "N_Conj_N_N__Number=Sing": {POS: NOUN},
    "N_Conj_N_N___": {POS: NOUN},
    "N_Conj_N__Number=Plur": {POS: NOUN},
    "N_Conj_N__Number=Sing": {POS: NOUN},
    "N_Conj_N___": {POS: NOUN},
    "N_Conj|soort|ev|neut_neven__Number=Sing": {POS: NOUN},
    "N_Int_N|eigen|ev|neut_eigen|ev|neut___": {POS: NOUN},
    "N_Misc_Misc_Misc_Misc___": {POS: NOUN},
    "N_Misc_Misc_N___": {POS: NOUN},
    "N_Misc_Misc|eigen|ev|neut_vreemd_vreemd___": {POS: NOUN},
    "N_Misc_Misc|soort|mv|neut_vreemd_vreemd__Number=Plur": {POS: NOUN},
    "N_Misc_N_N_N_N___": {POS: NOUN},
    "N_Misc_N_N___": {POS: NOUN},
    "N_Misc_N___": {POS: NOUN},
    "N_Misc_Num___": {POS: NOUN},
    "N_Misc|eigen|ev|neut_vreemd___": {POS: NOUN},
    "N_Misc|soort|ev|neut_vreemd__Number=Sing": {POS: NOUN},
    "N_N_Adj_Art_N_N__Gender=Masc|Number=Plur|PronType=Art": {POS: NOUN},
    "N_N_Adj_N___": {POS: NOUN},
    "N_N_Adj__Degree=Pos|Number=Sing": {POS: NOUN},
    "N_N_Adj___": {POS: NOUN},
    "N_N_Art_Adv___": {POS: NOUN},
    "N_N_Art_N___": {POS: NOUN},
    "N_N_Conj_N_N_N_N_N___": {POS: NOUN},
    "N_N_Conj_N_N___": {POS: NOUN},
    "N_N_Conj_N__Number=Sing": {POS: NOUN},
    "N_N_Conj_N___": {POS: NOUN},
    "N_N_Conj___": {POS: NOUN},
    "N_N_Int_N_N___": {POS: NOUN},
    "N_N_Misc___": {POS: NOUN},
    "N_N_N_Adj_N___": {POS: NOUN},
    "N_N_N_Adv___": {POS: NOUN},
    "N_N_N_Int__AdpType=Prep": {POS: NOUN},
    "N_N_N_Misc___": {POS: NOUN},
    "N_N_N_N_Conj_N___": {POS: NOUN},
    "N_N_N_N_Misc___": {POS: NOUN},
    "N_N_N_N_N_N_Int__AdpType=Prep": {POS: NOUN},
    "N_N_N_N_N_N_N__AdpType=Prep": {POS: NOUN},
    "N_N_N_N_N_N_N__Gender=Fem|Number=Sing|PronType=Art": {POS: NOUN},
    "N_N_N_N_N_N_N___": {POS: NOUN},
    "N_N_N_N_N_N_Prep_N___": {POS: NOUN},
    "N_N_N_N_N_N__AdpType=Prep": {POS: NOUN},
    "N_N_N_N_N_N___": {POS: NOUN},
    "N_N_N_N_N_Prep_N___": {POS: NOUN},
    "N_N_N_N_N__AdpType=Prep": {POS: NOUN},
    "N_N_N_N_N__Number=Sing": {POS: NOUN},
    "N_N_N_N_N___": {POS: NOUN},
    "N_N_N_N_Prep_N___": {POS: NOUN},
    "N_N_N_N_Punc_N_Punc___": {POS: NOUN},
    "N_N_N_N_V___": {POS: NOUN},
    "N_N_N_N__Gender=Fem|Number=Plur|PronType=Art": {POS: NOUN},
    "N_N_N_N__Gender=Fem|Number=Sing|PronType=Art": {POS: NOUN},
    "N_N_N_N__NumType=Card": {POS: NOUN},
    "N_N_N_N__Number=Plur": {POS: NOUN},
    "N_N_N_N__Number=Sing": {POS: NOUN},
    "N_N_N_N___": {POS: NOUN},
    "N_N_N_Prep_Art_Adj_N___": {POS: NOUN},
    "N_N_N_Prep_N_N___": {POS: NOUN},
    "N_N_N_Prep_N___": {POS: NOUN},
    "N_N_N_Punc_N___": {POS: NOUN},
    "N_N_N_Punc___": {POS: NOUN},
    "N_N_N__AdpType=Prep": {POS: NOUN},
    "N_N_N__Gender=Fem|Number=Sing|PronType=Art": {POS: NOUN},
    "N_N_N__Gender=Masc|Number=Plur|PronType=Art": {POS: NOUN},
    "N_N_N__Number=Plur": {POS: NOUN},
    "N_N_N__Number=Sing": {POS: NOUN},
    "N_N_N___": {POS: NOUN},
    "N_N_Num_N___": {POS: NOUN},
    "N_N_Num__Definite=Def|Number=Sing": {POS: NOUN},
    "N_N_Num___": {POS: NOUN},
    "N_N_Prep_Art_Adj_N__Degree=Pos|Gender=Neut|Number=Sing": {POS: NOUN},
    "N_N_Prep_Art_N_Prep_Art_N___": {POS: NOUN},
    "N_N_Prep_Art_N___": {POS: NOUN},
    "N_N_Prep_N_N__AdpType=Prep": {POS: NOUN},
    "N_N_Prep_N_Prep_Adj_N___": {POS: NOUN},
    "N_N_Prep_N__AdpType=Prep": {POS: NOUN},
    "N_N_Prep_N__Number=Sing": {POS: NOUN},
    "N_N_Prep_N___": {POS: NOUN},
    "N_N_Punc_N_Punc___": {POS: NOUN},
    "N_Num_N_N__Definite=Def|Number=Sing": {POS: NOUN},
    "N_Num_N_Num___": {POS: NOUN},
    "N_Num_N___": {POS: NOUN},
    "N_Num_Num__Definite=Def|Number=Sing": {POS: NOUN},
    "N_Num__Definite=Def|Number=Plur": {POS: NOUN},
    "N_Num__Definite=Def|Number=Sing": {POS: NOUN},
    "N_Num___": {POS: NOUN},
    "N_N|eigen|ev|gen_eigen|ev|gen___": {POS: NOUN},
    "N_N|eigen|ev|gen_eigen|ev|neut___": {POS: NOUN},
    "N_N|eigen|ev|gen_soort|ev|neut___": {POS: NOUN},
    "N_N|eigen|ev|gen_soort|mv|neut___": {POS: NOUN},
    "N_N|eigen|ev|neut_eigen|ev|gen___": {POS: NOUN},
    "N_N|eigen|ev|neut_eigen|ev|neut__AdpType=Prep": {POS: NOUN},
    "N_N|eigen|ev|neut_eigen|ev|neut__AdpType=Preppron|Gender=Fem|Number=Plur": {
        POS: NOUN
    },
    "N_N|eigen|ev|neut_eigen|ev|neut__AdpType=Preppron|Gender=Masc|Number=Sing": {
        POS: NOUN
    },
    "N_N|eigen|ev|neut_eigen|ev|neut__Gender=Fem|Number=Plur|PronType=Art": {POS: NOUN},
    "N_N|eigen|ev|neut_eigen|ev|neut__Gender=Fem|Number=Sing|PronType=Art": {POS: NOUN},
    "N_N|eigen|ev|neut_eigen|ev|neut__Gender=Masc|Number=Plur|PronType=Art": {
        POS: NOUN
    },
    "N_N|eigen|ev|neut_eigen|ev|neut__Gender=Masc|Number=Sing|PronType=Art": {
        POS: NOUN
    },
    "N_N|eigen|ev|neut_eigen|ev|neut__NumType=Card": {POS: NOUN},
    "N_N|eigen|ev|neut_eigen|ev|neut__Number=Sing": {POS: NOUN},
    "N_N|eigen|ev|neut_eigen|ev|neut___": {POS: NOUN},
    "N_N|eigen|ev|neut_eigen|mv|neut___": {POS: NOUN},
    "N_N|eigen|ev|neut_soort|ev|neut__AdpType=Prep": {POS: NOUN},
    "N_N|eigen|ev|neut_soort|ev|neut___": {POS: NOUN},
    "N_N|eigen|ev|neut_soort|mv|neut___": {POS: NOUN},
    "N_N|eigen|mv|neut_eigen|mv|neut___": {POS: NOUN},
    "N_N|soort|ev|neut_eigen|ev|neut__Number=Sing": {POS: NOUN},
    "N_N|soort|ev|neut_soort|ev|neut__Gender=Masc|Number=Plur|PronType=Art": {
        POS: NOUN
    },
    "N_N|soort|ev|neut_soort|ev|neut__NumForm=Digit|NumType=Card": {POS: NOUN},
    "N_N|soort|ev|neut_soort|ev|neut__Number=Sing": {POS: NOUN},
    "N_N|soort|ev|neut_soort|mv|neut__Number=Plur": {POS: NOUN},
    "N_N|soort|mv|neut_eigen|ev|neut__Number=Sing": {POS: NOUN},
    "N_N|soort|mv|neut_soort|ev|neut__Number=Sing": {POS: NOUN},
    "N_N|soort|mv|neut_soort|mv|neut__Number=Plur": {POS: NOUN},
    "N_Prep_Adj_Adj_N__Degree=Pos|Number=Plur": {POS: NOUN},
    "N_Prep_Adj_N___": {POS: NOUN},
    "N_Prep_Art_N_Art_N__Number=Plur": {POS: NOUN},
    "N_Prep_Art_N_N__Number=Sing": {POS: NOUN},
    "N_Prep_Art_N_Prep_Art_N__Gender=Neut|Number=Sing": {POS: NOUN},
    "N_Prep_Art_N__Number=Plur": {POS: NOUN},
    "N_Prep_Art_N__Number=Sing": {POS: NOUN},
    "N_Prep_Art_N___": {POS: NOUN},
    "N_Prep_N_Art_Adj___": {POS: NOUN},
    "N_Prep_N_N__Number=Sing": {POS: NOUN},
    "N_Prep_N_N___": {POS: NOUN},
    "N_Prep_N_Prep_Art_N___": {POS: NOUN},
    "N_Prep_N_Prep_N_Conj_N_Prep_Art_N_N__Number=Sing": {POS: NOUN},
    "N_Prep_N_Punc_N_Conj_N__Number=Sing": {POS: NOUN},
    "N_Prep_N__Number=Plur": {POS: NOUN},
    "N_Prep_N__Number=Sing": {POS: NOUN},
    "N_Prep_N___": {POS: NOUN},
    "N_Prep_Num__Definite=Def|Number=Sing": {POS: NOUN},
    "N_Prep_Pron_N___": {POS: NOUN},
    "N_Prep|soort|ev|neut_voor__Number=Sing": {POS: NOUN},
    "N_Pron___": {POS: NOUN},
    "N_Punc_Adj_N___": {POS: NOUN},
    "N_Punc_Adj_Pron_Punc__Degree=Pos|Number=Sing|Person=2": {POS: NOUN},
    "N_Punc_Adv_V_Pron_N__Aspect=Imp|Mood=Ind|Number=Sing|Person=1|Tense=Pres|VerbForm=Fin": {
        POS: NOUN
    },
    "N_Punc_Misc_Punc_N___": {POS: NOUN},
    "N_Punc_N_N_N_N__Number=Sing": {POS: NOUN},
    "N_Punc_N_Punc_N__Number=Sing": {POS: NOUN},
    "N_Punc_N_Punc__Number=Sing": {POS: NOUN},
    "N_Punc_N__Number=Sing": {POS: NOUN},
    "N_Punc_Punc_N_N_Punc_Punc_N___": {POS: NOUN},
    "N_V_N_N___": {POS: NOUN},
    "N_V_N___": {POS: NOUN},
    "N_V__Aspect=Imp|Mood=Ind|Number=Sing|Tense=Past|VerbForm=Fin": {POS: NOUN},
    "N_V__Number=Sing|Tense=Past|VerbForm=Part": {POS: NOUN},
    "N_V___": {POS: NOUN},
    "N_V|eigen|ev|neut_trans|imp___": {POS: NOUN},
    "N_V|soort|ev|neut_hulpofkopp|conj__Mood=Sub|Number=Sing|VerbForm=Fin": {POS: NOUN},
    "N_V|soort|ev|neut_intrans|conj__Mood=Sub|Number=Sing|VerbForm=Fin": {POS: NOUN},
    "Num_Adj_Adj_N___": {POS: NUM},
    "Num_Adj_N___": {POS: NUM},
    "Num_Adj__Definite=Def|Degree=Pos|NumType=Card": {POS: NUM},
    "Num_Adj__NumForm=Digit|NumType=Card": {POS: NUM},
    "Num_Adj___": {POS: NUM},
    "Num_Conj_Adj__Case=Nom|Definite=Def|Degree=Pos|NumType=Card": {POS: NUM},
    "Num_Conj_Art_Adj__Definite=Def|Degree=Pos|Number=Sing|NumType=Card": {POS: NUM},
    "Num_Conj_Num_N__NumForm=Digit|NumType=Card": {POS: NUM},
    "Num_Conj_Num__Degree=Cmp|NumType=Card|PronType=Ind": {POS: NUM},
    "Num_N_N__Definite=Def|Number=Sing|NumType=Card": {POS: NUM},
    "Num_N_Num_Num_N__NumForm=Digit|NumType=Card": {POS: NUM},
    "Num_N_Num__Definite=Def|Number=Sing|NumType=Card": {POS: NUM},
    "Num_N_Num__NumForm=Digit|NumType=Card": {POS: NUM},
    "Num_N__Definite=Def|Number=Plur|NumType=Card": {POS: NUM},
    "Num_N__Definite=Def|Number=Sing|NumType=Card": {POS: NUM},
    "Num_N__NumForm=Digit|NumType=Card": {POS: NUM},
    "Num_N___": {POS: NUM},
    "Num_Num_N__NumForm=Digit|NumType=Card": {POS: NUM},
    "Num_Num__Definite=Def|NumType=Card": {POS: NUM},
    "Num_Num__NumForm=Digit|NumType=Card": {POS: NUM},
    "Num_Prep_Num__Definite=Def|NumType=Card": {POS: NUM},
    "Num_Punc_Num_N_N__NumForm=Digit|NumType=Card": {POS: NUM},
    "Num_Punc_Num__NumForm=Digit|NumType=Card": {POS: NUM},
    "Num_Punc__NumForm=Digit|NumType=Card": {POS: NUM},
    "Num__Case=Nom|Degree=Cmp|NumType=Card|PronType=Ind": {POS: NUM},
    "Num__Case=Nom|Degree=Pos|NumType=Card|PronType=Ind": {POS: NUM},
    "Num__Case=Nom|Degree=Sup|NumType=Card|PronType=Ind": {POS: NUM},
    "Num__Degree=Cmp|NumType=Card|PronType=Ind": {POS: NUM},
    "Num__Degree=Pos|NumType=Card|PronType=Ind": {POS: NUM},
    "Num__Degree=Pos|Number=Plur|NumType=Card|PronType=Ind": {POS: NUM},
    "Num__Degree=Sup|NumType=Card|PronType=Ind": {POS: NUM},
    "Num__Degree=Sup|Number=Plur|NumType=Card|PronType=Ind": {POS: NUM},
    "Num|hoofd|bep|attr|onverv__Definite=Def|NumType=Card": {POS: NUM},
    "Num|hoofd|bep|zelfst|onverv__Definite=Def|NumType=Card": {POS: NUM},
    "Num|hoofd|bep|zelfst|vervmv__Definite=Def|Number=Plur|NumType=Card": {POS: NUM},
    "Num|hoofd|onbep|attr|stell|onverv__Degree=Pos|NumType=Card|PronType=Ind": {
        POS: NUM
    },
    "Num|hoofd|onbep|attr|vergr|onverv__Degree=Cmp|NumType=Card|PronType=Ind": {
        POS: NUM
    },
    "Num|rang|bep|attr|onverv__Definite=Def|NumType=Ord": {POS: NUM},
    "Num|rang|bep|zelfst|onverv__Definite=Def|NumType=Ord": {POS: NUM},
    "N|eigen|ev|gen__Case=Gen|Number=Sing": {POS: NOUN},
    "N|eigen|ev|neut__Number=Sing": {POS: NOUN},
    "N|eigen|mv|neut__Number=Plur": {POS: NOUN},
    "N|soort|ev|dat__Case=Dat|Number=Sing": {POS: NOUN},
    "N|soort|ev|gen__Case=Gen|Number=Sing": {POS: NOUN},
    "N|soort|ev|neut__Number=Sing": {POS: NOUN},
    "N|soort|mv|neut__Number=Plur": {POS: NOUN},
    "PROPN___": {POS: PROPN},
    "PUNCT___": {POS: PUNCT},
    "Prep_Adj_Conj_Prep_N__Degree=Pos|Number=Sing": {POS: ADP},
    "Prep_Adj_N__Degree=Pos|Number=Plur": {POS: ADP},
    "Prep_Adj|voor_adv|vergr|vervneut__Case=Nom|Degree=Cmp": {POS: ADP},
    "Prep_Adj|voor_attr|stell|onverv__Degree=Pos": {POS: ADP},
    "Prep_Adj|voor_attr|stell|vervneut__Case=Nom|Degree=Pos": {POS: ADP},
    "Prep_Adv__AdpType=Prep": {POS: ADP},
    "Prep_Adv__Case=Nom|Degree=Pos": {POS: ADP},
    "Prep_Adv__Case=Nom|Degree=Sup": {POS: ADP},
    "Prep_Adv__Degree=Pos": {POS: ADP},
    "Prep_Adv|voor_gew|aanw__AdpType=Prep": {POS: ADP},
    "Prep_Adv|voor_gew|aanw__Gender=Masc|Number=Sing|PronType=Tot": {POS: ADP},
    "Prep_Adv|voor_gew|aanw__PronType=Dem": {POS: ADP},
    "Prep_Adv|voor_pron|vrag__PronType=Int": {POS: ADP},
    "Prep_Art_Adj_N__Degree=Pos|Number=Sing": {POS: ADP},
    "Prep_Art_Adj__AdpType=Prep": {POS: ADP},
    "Prep_Art_Adj__Case=Nom|Degree=Pos": {POS: ADP},
    "Prep_Art_Adj__Degree=Cmp|Gender=Neut": {POS: ADP},
    "Prep_Art_Misc_Misc___": {POS: ADP},
    "Prep_Art_N_Adv__Number=Sing": {POS: ADP},
    "Prep_Art_N_Adv__Number=Sing|PronType=Int": {POS: ADP},
    "Prep_Art_N_Art_N__AdpType=Prep": {POS: ADP},
    "Prep_Art_N_Prep_Art_N__AdpType=Prep": {POS: ADP},
    "Prep_Art_N_Prep__AdpType=Prep": {POS: ADP},
    "Prep_Art_N_Prep__Gender=Neut|Number=Sing": {POS: ADP},
    "Prep_Art_N_Prep__Number=Sing": {POS: ADP},
    "Prep_Art_N_V__Number=Plur|Tense=Past|VerbForm=Part": {POS: ADP},
    "Prep_Art_N__AdpType=Prep": {POS: ADP},
    "Prep_Art_N__Gender=Com|Number=Sing": {POS: ADP},
    "Prep_Art_N__Gender=Neut|Number=Sing": {POS: ADP},
    "Prep_Art_N__Number=Plur": {POS: ADP},
    "Prep_Art_N__Number=Sing": {POS: ADP},
    "Prep_Art_V__AdpType=Prep": {POS: ADP},
    "Prep_Art_V__Gender=Neut|VerbForm=Inf": {POS: ADP},
    "Prep_Art|voor_bep|onzijd|neut__Gender=Neut": {POS: ADP},
    "Prep_Art|voor_onbep|zijdofonzijd|neut__Number=Sing": {POS: ADP},
    "Prep_Conj_Prep|voor_neven_voor__Gender=Masc|Number=Sing|PronType=Tot": {POS: ADP},
    "Prep_Misc|voor_vreemd___": {POS: ADP},
    "Prep_N_Adv|voor_soort|ev|neut_deeladv__Number=Sing": {POS: ADP},
    "Prep_N_Adv|voor_soort|ev|neut_pron|aanw__AdpType=Prep": {POS: ADP},
    "Prep_N_Adv|voor_soort|ev|neut_pron|aanw__Number=Sing|PronType=Dem": {POS: ADP},
    "Prep_N_Adv|voor_soort|ev|neut_pron|vrag__Number=Sing|PronType=Int": {POS: ADP},
    "Prep_N_Adv|voor_soort|mv|neut_deelv__Gender=Masc|Number=Sing|PronType=Tot": {
        POS: ADP
    },
    "Prep_N_Conj_N__Number=Sing": {POS: ADP},
    "Prep_N_Conj__AdpType=Prep": {POS: ADP},
    "Prep_N_Prep_N__Number=Sing": {POS: ADP},
    "Prep_N_Prep|voor_soort|ev|dat_voor__Number=Sing": {POS: ADP},
    "Prep_N_Prep|voor_soort|ev|neut_voor__AdpType=Prep": {POS: ADP},
    "Prep_N_Prep|voor_soort|ev|neut_voor__Number=Sing": {POS: ADP},
    "Prep_N_Prep|voor_soort|mv|neut_voor__Number=Plur": {POS: ADP},
    "Prep_N_V__Case=Nom|Number=Sing|Tense=Past|VerbForm=Part": {POS: ADP},
    "Prep_Num_N__Definite=Def|Number=Sing": {POS: ADP},
    "Prep_Num__Case=Nom|Degree=Sup|PronType=Ind": {POS: ADP},
    "Prep_Num__Degree=Cmp|PronType=Ind": {POS: ADP},
    "Prep_N|voor_eigen|ev|neut__Number=Sing": {POS: ADP},
    "Prep_N|voor_soort|ev|dat__AdpType=Prep": {POS: ADP},
    "Prep_N|voor_soort|ev|dat__Case=Dat|Number=Sing": {POS: ADP},
    "Prep_N|voor_soort|ev|neut__AdpType=Prep": {POS: ADP},
    "Prep_N|voor_soort|ev|neut__Gender=Masc|Number=Sing|PronType=Tot": {POS: ADP},
    "Prep_N|voor_soort|ev|neut__Number=Sing": {POS: ADP},
    "Prep_N|voor_soort|mv|neut__AdpType=Prep": {POS: ADP},
    "Prep_N|voor_soort|mv|neut__Number=Plur": {POS: ADP},
    "Prep_Prep_Adj|voor_voor_adv|stell|onverv__Gender=Masc|Number=Sing|PronType=Tot": {
        POS: ADP
    },
    "Prep_Prep_Adv__Degree=Pos": {POS: ADP},
    "Prep_Pron_Adj__Degree=Cmp|Number=Sing|Person=3": {POS: ADP},
    "Prep_Pron_N_Adv__Number=Plur": {POS: ADP},
    "Prep_Pron_N__AdpType=Prep": {POS: ADP},
    "Prep_Pron_N__Case=Dat|Number=Sing": {POS: ADP},
    "Prep_Pron|voor_aanw|neut|zelfst___": {POS: ADP},
    "Prep_Pron|voor_onbep|neut|attr___": {POS: ADP},
    "Prep_Pron|voor_onbep|neut|zelfst___": {POS: ADP},
    "Prep_Pron|voor_rec|neut__AdpType=Prep": {POS: ADP},
    "Prep_Pron|voor_rec|neut___": {POS: ADP},
    "Prep_Pron|voor_ref|3|evofmv__Number=Plur,Sing|Person=3": {POS: ADP},
    "Prep_Punc_N_Conj_N__AdpType=Prep": {POS: ADP},
    "Prep_V_N__Number=Sing|Tense=Pres|VerbForm=Part": {POS: ADP},
    "Prep_V_Pron_Pron_Adv__Aspect=Imp|Mood=Ind|Number=Sing|Person=2|PronType=Dem|Tense=Pres|VerbForm=Fin": {
        POS: ADP
    },
    "Prep_V|voor_intrans|inf__VerbForm=Inf": {POS: ADP},
    "Prep_V|voorinf_trans|inf__VerbForm=Inf": {POS: ADP},
    "Prep|achter__AdpType=Post": {POS: ADP},
    "Prep|comb__AdpType=Circ": {POS: ADP},
    "Prep|voor__AdpType=Prep": {POS: ADP},
    "Prep|voorinf__AdpType=Prep|PartType=Inf": {POS: ADP},
    "Pron_Adj_N_Punc_Art_Adj_N_Prep_Art_Adj_N__NumType=Card": {POS: PRON},
    "Pron_Adj__Case=Nom|Degree=Sup|Number=Sing|Person=2|Poss=Yes|PronType=Prs": {
        POS: PRON
    },
    "Pron_Adj__Degree=Cmp|PronType=Ind": {POS: PRON},
    "Pron_Adv|vrag|neut|attr_deelv__PronType=Int": {POS: PRON},
    "Pron_Art_N_N__Number=Plur|PronType=Ind": {POS: PRON},
    "Pron_Art__Number=Sing|PronType=Int": {POS: PRON},
    "Pron_N_Adv__Number=Sing|PronType=Ind": {POS: PRON},
    "Pron_N_V_Adv_Num_Punc__Aspect=Imp|Definite=Def|Mood=Ind|Number=Sing|Person=3|PronType=Ind|Tense=Pres|VerbForm=Fin": {
        POS: PRON
    },
    "Pron_N_V_Conj_N__Aspect=Imp|Mood=Ind|Number=Sing|Person=3|PronType=Ind|Tense=Pres|VerbForm=Fin": {
        POS: PRON
    },
    "Pron_N__Case=Gen|Number=Sing|PronType=Ind": {POS: PRON},
    "Pron_N__Number=Sing|PronType=Ind": {POS: PRON},
    "Pron_N|aanw|gen|attr_soort|mv|neut__Case=Gen|Number=Plur|PronType=Dem": {
        POS: PRON
    },
    "Pron_N|onbep|neut|attr_soort|ev|neut__Number=Sing|PronType=Ind": {POS: PRON},
    "Pron_Prep_Art__Number=Sing|PronType=Int": {POS: PRON},
    "Pron_Prep_Art__Number=Sing|PronType=Rel": {POS: PRON},
    "Pron_Prep_N__Number=Plur|PronType=Int": {POS: PRON},
    "Pron_Prep|betr|neut|zelfst_voor__PronType=Rel": {POS: PRON},
    "Pron_Prep|onbep|neut|zelfst_voor__PronType=Ind": {POS: PRON},
    "Pron_Prep|vrag|neut|attr_voor__PronType=Int": {POS: PRON},
    "Pron_Pron_V__Aspect=Imp|Mood=Ind|Number=Sing|Person=2|PronType=Rel|Tense=Pres|VerbForm=Fin": {
        POS: PRON
    },
    "Pron_Pron__Person=3|PronType=Prs|Reflex=Yes": {POS: PRON},
    "Pron_V_V__Aspect=Imp|Mood=Ind|Person=3|PronType=Dem|Tense=Pres|VerbForm=Inf": {
        POS: PRON
    },
    "Pron_V__Case=Gen|Number=Sing|Person=3|Poss=Yes|PronType=Prs|VerbForm=Inf": {
        POS: PRON
    },
    "Pron_V__Number=Plur|Person=1|Poss=Yes|PronType=Prs|VerbForm=Inf": {POS: PRON},
    "Pron|aanw|dat|attr__Case=Dat|PronType=Dem": {POS: PRON},
    "Pron|aanw|gen|attr__Case=Gen|PronType=Dem": {POS: PRON},
    "Pron|aanw|neut|attr__PronType=Dem": {POS: PRON},
    "Pron|aanw|neut|attr|weigen__PronType=Dem": {POS: PRON},
    "Pron|aanw|neut|attr|wzelf__PronType=Dem": {POS: PRON},
    "Pron|aanw|neut|zelfst__PronType=Dem": {POS: PRON},
    "Pron|betr|gen|zelfst__Case=Gen|PronType=Rel": {POS: PRON},
    "Pron|betr|neut|attr__PronType=Rel": {POS: PRON},
    "Pron|betr|neut|zelfst__PronType=Rel": {POS: PRON},
    "Pron|bez|1|ev|neut|attr__Number=Sing|Person=1|Poss=Yes|PronType=Prs": {POS: PRON},
    "Pron|bez|1|mv|neut|attr__Number=Plur|Person=1|Poss=Yes|PronType=Prs": {POS: PRON},
    "Pron|bez|2|ev|neut|attr__Number=Sing|Person=2|Poss=Yes|PronType=Prs": {POS: PRON},
    "Pron|bez|2|mv|neut|attr__Number=Plur|Person=2|Poss=Yes|PronType=Prs": {POS: PRON},
    "Pron|bez|3|ev|gen|attr__Case=Gen|Number=Sing|Person=3|Poss=Yes|PronType=Prs": {
        POS: PRON
    },
    "Pron|bez|3|ev|neut|attr__Number=Sing|Person=3|Poss=Yes|PronType=Prs": {POS: PRON},
    "Pron|bez|3|ev|neut|zelfst__Number=Sing|Person=3|Poss=Yes|PronType=Prs": {
        POS: PRON
    },
    "Pron|bez|3|mv|neut|attr__Number=Plur|Person=3|Poss=Yes|PronType=Prs": {POS: PRON},
    "Pron|onbep|gen|attr__Case=Gen|PronType=Ind": {POS: PRON},
    "Pron|onbep|gen|zelfst__Case=Gen|PronType=Ind": {POS: PRON},
    "Pron|onbep|neut|attr__PronType=Ind": {POS: PRON},
    "Pron|onbep|neut|zelfst__PronType=Ind": {POS: PRON},
    "Pron|per|1|ev|datofacc__Case=Acc,Dat|Number=Sing|Person=1|PronType=Prs": {
        POS: PRON
    },
    "Pron|per|1|ev|nom__Case=Nom|Number=Sing|Person=1|PronType=Prs": {POS: PRON},
    "Pron|per|1|mv|datofacc__Case=Acc,Dat|Number=Plur|Person=1|PronType=Prs": {
        POS: PRON
    },
    "Pron|per|1|mv|nom__Case=Nom|Number=Plur|Person=1|PronType=Prs": {POS: PRON},
    "Pron|per|2|ev|datofacc__Case=Acc,Dat|Number=Sing|Person=2|PronType=Prs": {
        POS: PRON
    },
    "Pron|per|2|ev|nom__Case=Nom|Number=Sing|Person=2|PronType=Prs": {POS: PRON},
    "Pron|per|2|mv|datofacc__Case=Acc,Dat|Number=Plur|Person=2|PronType=Prs": {
        POS: PRON
    },
    "Pron|per|2|mv|nom__Case=Nom|Number=Plur|Person=2|PronType=Prs": {POS: PRON},
    "Pron|per|3|evofmv|datofacc__Case=Acc,Dat|Number=Plur,Sing|Person=3|PronType=Prs": {
        POS: PRON
    },
    "Pron|per|3|evofmv|nom__Case=Nom|Number=Plur,Sing|Person=3|PronType=Prs": {
        POS: PRON
    },
    "Pron|per|3|ev|datofacc__Case=Acc,Dat|Number=Sing|Person=3|PronType=Prs": {
        POS: PRON
    },
    "Pron|per|3|ev|nom__Case=Nom|Number=Sing|Person=3|PronType=Prs": {POS: PRON},
    "Pron|per|3|mv|datofacc__Case=Acc,Dat|Number=Plur|Person=3|PronType=Prs": {
        POS: PRON
    },
    "Pron|rec|gen__Case=Gen|PronType=Rcp": {POS: PRON},
    "Pron|rec|neut__PronType=Rcp": {POS: PRON},
    "Pron|ref|1|ev__Number=Sing|Person=1|PronType=Prs|Reflex=Yes": {POS: PRON},
    "Pron|ref|1|mv__Number=Plur|Person=1|PronType=Prs|Reflex=Yes": {POS: PRON},
    "Pron|ref|2|ev__Number=Sing|Person=2|PronType=Prs|Reflex=Yes": {POS: PRON},
    "Pron|ref|3|evofmv__Number=Plur,Sing|Person=3|PronType=Prs|Reflex=Yes": {POS: PRON},
    "Pron|vrag|neut|attr__PronType=Int": {POS: PRON},
    "Pron|vrag|neut|zelfst__PronType=Int": {POS: PRON},
    "Punc_Int_Punc_N_N_N_Punc_Pron_V_Pron_Adj_V_Punc___": {POS: PUNCT},
    "Punc_N_Punc_N___": {POS: PUNCT},
    "Punc_Num_Num___": {POS: PUNCT},
    "Punc_Num___": {POS: PUNCT},
    "Punc|aanhaaldubb__PunctType=Quot": {POS: PUNCT},
    "Punc|aanhaalenk__PunctType=Quot": {POS: PUNCT},
    "Punc|dubbpunt__PunctType=Colo": {POS: PUNCT},
    "Punc|haakopen__PunctSide=Ini|PunctType=Brck": {POS: PUNCT},
    "Punc|haaksluit__PunctSide=Fin|PunctType=Brck": {POS: PUNCT},
    "Punc|hellip__PunctType=Peri": {POS: PUNCT},
    "Punc|isgelijk___": {POS: PUNCT},
    "Punc|komma__PunctType=Comm": {POS: PUNCT},
    "Punc|liggstreep___": {POS: PUNCT},
    "Punc|maal___": {POS: PUNCT},
    "Punc|punt__PunctType=Peri": {POS: PUNCT},
    "Punc|puntkomma__PunctType=Semi": {POS: PUNCT},
    "Punc|schuinstreep___": {POS: PUNCT},
    "Punc|uitroep__PunctType=Excl": {POS: PUNCT},
    "Punc|vraag__PunctType=Qest": {POS: PUNCT},
    "V_Adv_Art_N_Prep_Pron_N__Degree=Pos|Number=Plur|Person=2|Subcat=Tran": {POS: VERB},
    "V_Adv__Degree=Pos|Subcat=Tran": {POS: VERB},
    "V_Art_N_Num_N__Aspect=Imp|Definite=Def|Mood=Ind|Number=Plur|Person=3|Tense=Pres|VerbForm=Fin|VerbType=Mod": {
        POS: VERB
    },
    "V_Art_N__Number=Sing|Subcat=Tran": {POS: VERB},
    "V_Conj_N_N__Number=Sing|Subcat=Tran|Tense=Past|VerbForm=Part": {POS: VERB},
    "V_Conj_Pron__Subcat=Tran|Tense=Past|VerbForm=Part": {POS: VERB},
    "V_N_Conj_Adj_N_Prep_Art_N__Degree=Pos|Number=Sing|Subcat=Tran|Tense=Past|VerbForm=Part": {
        POS: VERB
    },
    "V_N_N__Number=Sing|Subcat=Intr|Tense=Pres|VerbForm=Part": {POS: VERB},
    "V_N_N__Number=Sing|Subcat=Tran|Tense=Past|VerbForm=Part": {POS: VERB},
    "V_N_V__Aspect=Imp|Mood=Ind|Number=Sing|Subcat=Intr|Tense=Pres|VerbForm=Inf": {
        POS: VERB
    },
    "V_N__Number=Plur|Subcat=Tran|Tense=Past|VerbForm=Part": {POS: VERB},
    "V_N|trans|imp_eigen|ev|neut__Number=Sing|Subcat=Tran": {POS: VERB},
    "V_Prep|intrans|verldw|onverv_voor__Subcat=Intr|Tense=Past|VerbForm=Part": {
        POS: VERB
    },
    "V_Pron_Adv_Adv_Pron_V__Aspect=Imp|Mood=Ind|Number=Sing|Person=2|Subcat=Tran|Tense=Pres|VerbForm=Fin": {
        POS: VERB
    },
    "V_Pron_Adv__Aspect=Imp|Degree=Pos|Mood=Ind|Number=Sing|Person=2|Subcat=Tran|Tense=Pres|VerbForm=Fin": {
        POS: VERB
    },
    "V_Pron_V__Aspect=Imp|Mood=Ind|Number=Sing|Person=3|Subcat=Tran|Tense=Pres|VerbForm=Fin": {
        POS: VERB
    },
    "V_Pron__VerbType=Aux,Cop": {POS: VERB},
    "V_V|hulp|imp_intrans|inf__VerbForm=Inf|VerbType=Mod": {POS: VERB},
    "V|hulpofkopp|conj__Mood=Sub|VerbForm=Fin": {POS: VERB},
    "V|hulpofkopp|conj__Mood=Sub|VerbForm=Fin|VerbType=Aux,Cop": {POS: VERB},
    "V|hulpofkopp|imp__Mood=Imp|VerbForm=Fin": {POS: VERB},
    "V|hulpofkopp|imp__Mood=Imp|VerbForm=Fin|VerbType=Aux,Cop": {POS: VERB},
    "V|hulpofkopp|inf__VerbForm=Inf": {POS: VERB},
    "V|hulpofkopp|inf__VerbForm=Inf|VerbType=Aux,Cop": {POS: VERB},
    "V|hulpofkopp|inf|subst__VerbForm=Inf": {POS: VERB},
    "V|hulpofkopp|ott|1of2of3|mv__Aspect=Imp|Mood=Ind|Number=Plur|Tense=Pres|VerbForm=Fin": {
        POS: VERB
    },
    "V|hulpofkopp|ott|1of2of3|mv__Aspect=Imp|Mood=Ind|Number=Plur|Tense=Pres|VerbForm=Fin|VerbType=Aux,Cop": {
        POS: VERB
    },
    "V|hulpofkopp|ott|1|ev__Aspect=Imp|Mood=Ind|Number=Sing|Person=1|Tense=Pres|VerbForm=Fin": {
        POS: VERB
    },
    "V|hulpofkopp|ott|1|ev__Aspect=Imp|Mood=Ind|Number=Sing|Person=1|Tense=Pres|VerbForm=Fin|VerbType=Aux,Cop": {
        POS: VERB
    },
    "V|hulpofkopp|ott|2|ev__Aspect=Imp|Mood=Ind|Number=Sing|Person=2|Tense=Pres|VerbForm=Fin": {
        POS: VERB
    },
    "V|hulpofkopp|ott|2|ev__Aspect=Imp|Mood=Ind|Number=Sing|Person=2|Tense=Pres|VerbForm=Fin|VerbType=Aux,Cop": {
        POS: VERB
    },
    "V|hulpofkopp|ott|3|ev__Aspect=Imp|Mood=Ind|Number=Sing|Person=3|Tense=Pres|VerbForm=Fin": {
        POS: VERB
    },
    "V|hulpofkopp|ott|3|ev__Aspect=Imp|Mood=Ind|Number=Sing|Person=3|Tense=Pres|VerbForm=Fin|VerbType=Aux,Cop": {
        POS: VERB
    },
    "V|hulpofkopp|ovt|1of2of3|ev__Aspect=Imp|Mood=Ind|Number=Sing|Tense=Past|VerbForm=Fin": {
        POS: VERB
    },
    "V|hulpofkopp|ovt|1of2of3|ev__Aspect=Imp|Mood=Ind|Number=Sing|Tense=Past|VerbForm=Fin|VerbType=Aux,Cop": {
        POS: VERB
    },
    "V|hulpofkopp|ovt|1of2of3|mv__Aspect=Imp|Mood=Ind|Number=Plur|Tense=Past|VerbForm=Fin": {
        POS: VERB
    },
    "V|hulpofkopp|ovt|1of2of3|mv__Aspect=Imp|Mood=Ind|Number=Plur|Tense=Past|VerbForm=Fin|VerbType=Aux,Cop": {
        POS: VERB
    },
    "V|hulpofkopp|tegdw|vervneut__Case=Nom|Tense=Pres|VerbForm=Part": {POS: VERB},
    "V|hulpofkopp|tegdw|vervneut__Case=Nom|Tense=Pres|VerbForm=Part|VerbType=Aux,Cop": {
        POS: VERB
    },
    "V|hulpofkopp|verldw|onverv__Tense=Past|VerbForm=Part": {POS: VERB},
    "V|hulpofkopp|verldw|onverv__Tense=Past|VerbForm=Part|VerbType=Aux,Cop": {
        POS: VERB
    },
    "V|hulp|conj__Mood=Sub|VerbForm=Fin|VerbType=Mod": {POS: VERB},
    "V|hulp|inf__VerbForm=Inf": {POS: VERB},
    "V|hulp|inf__VerbForm=Inf|VerbType=Mod": {POS: VERB},
    "V|hulp|ott|1of2of3|mv__Aspect=Imp|Mood=Ind|Number=Plur|Tense=Pres|VerbForm=Fin": {
        POS: VERB
    },
    "V|hulp|ott|1of2of3|mv__Aspect=Imp|Mood=Ind|Number=Plur|Tense=Pres|VerbForm=Fin|VerbType=Mod": {
        POS: VERB
    },
    "V|hulp|ott|1|ev__Aspect=Imp|Mood=Ind|Number=Sing|Person=1|Tense=Pres|VerbForm=Fin": {
        POS: VERB
    },
    "V|hulp|ott|1|ev__Aspect=Imp|Mood=Ind|Number=Sing|Person=1|Tense=Pres|VerbForm=Fin|VerbType=Mod": {
        POS: VERB
    },
    "V|hulp|ott|2|ev__Aspect=Imp|Mood=Ind|Number=Sing|Person=2|Tense=Pres|VerbForm=Fin": {
        POS: VERB
    },
    "V|hulp|ott|2|ev__Aspect=Imp|Mood=Ind|Number=Sing|Person=2|Tense=Pres|VerbForm=Fin|VerbType=Mod": {
        POS: VERB
    },
    "V|hulp|ott|3|ev__Aspect=Imp|Mood=Ind|Number=Sing|Person=3|Tense=Pres|VerbForm=Fin": {
        POS: VERB
    },
    "V|hulp|ott|3|ev__Aspect=Imp|Mood=Ind|Number=Sing|Person=3|Tense=Pres|VerbForm=Fin|VerbType=Mod": {
        POS: VERB
    },
    "V|hulp|ovt|1of2of3|ev__Aspect=Imp|Mood=Ind|Number=Sing|Tense=Past|VerbForm=Fin": {
        POS: VERB
    },
    "V|hulp|ovt|1of2of3|ev__Aspect=Imp|Mood=Ind|Number=Sing|Tense=Past|VerbForm=Fin|VerbType=Mod": {
        POS: VERB
    },
    "V|hulp|ovt|1of2of3|mv__Aspect=Imp|Mood=Ind|Number=Plur|Tense=Past|VerbForm=Fin": {
        POS: VERB
    },
    "V|hulp|ovt|1of2of3|mv__Aspect=Imp|Mood=Ind|Number=Plur|Tense=Past|VerbForm=Fin|VerbType=Mod": {
        POS: VERB
    },
    "V|hulp|verldw|onverv__Tense=Past|VerbForm=Part": {POS: VERB},
    "V|hulp|verldw|onverv__Tense=Past|VerbForm=Part|VerbType=Mod": {POS: VERB},
    "V|intrans|conj__Mood=Sub|Subcat=Intr|VerbForm=Fin": {POS: VERB},
    "V|intrans|imp__Mood=Imp|Subcat=Intr|VerbForm=Fin": {POS: VERB},
    "V|intrans|inf__Subcat=Intr|VerbForm=Inf": {POS: VERB},
    "V|intrans|inf|subst__Subcat=Intr|VerbForm=Inf": {POS: VERB},
    "V|intrans|ott|1of2of3|mv__Aspect=Imp|Mood=Ind|Number=Plur|Subcat=Intr|Tense=Pres|VerbForm=Fin": {
        POS: VERB
    },
    "V|intrans|ott|1|ev__Aspect=Imp|Mood=Ind|Number=Sing|Person=1|Subcat=Intr|Tense=Pres|VerbForm=Fin": {
        POS: VERB
    },
    "V|intrans|ott|2|ev__Aspect=Imp|Mood=Ind|Number=Sing|Person=2|Subcat=Intr|Tense=Pres|VerbForm=Fin": {
        POS: VERB
    },
    "V|intrans|ott|3|ev__Aspect=Imp|Mood=Ind|Number=Sing|Person=3|Subcat=Intr|Tense=Pres|VerbForm=Fin": {
        POS: VERB
    },
    "V|intrans|ovt|1of2of3|ev__Aspect=Imp|Mood=Ind|Number=Sing|Subcat=Intr|Tense=Past|VerbForm=Fin": {
        POS: VERB
    },
    "V|intrans|ovt|1of2of3|mv__Aspect=Imp|Mood=Ind|Number=Plur|Subcat=Intr|Tense=Past|VerbForm=Fin": {
        POS: VERB
    },
    "V|intrans|tegdw|onverv__Subcat=Intr|Tense=Pres|VerbForm=Part": {POS: VERB},
    "V|intrans|tegdw|vervmv__Number=Plur|Subcat=Intr|Tense=Pres|VerbForm=Part": {
        POS: VERB
    },
    "V|intrans|tegdw|vervneut__Case=Nom|Subcat=Intr|Tense=Pres|VerbForm=Part": {
        POS: VERB
    },
    "V|intrans|tegdw|vervvergr__Degree=Cmp|Subcat=Intr|Tense=Pres|VerbForm=Part": {
        POS: VERB
    },
    "V|intrans|verldw|onverv__Subcat=Intr|Tense=Past|VerbForm=Part": {POS: VERB},
    "V|intrans|verldw|vervmv__Number=Plur|Subcat=Intr|Tense=Past|VerbForm=Part": {
        POS: VERB
    },
    "V|intrans|verldw|vervneut__Case=Nom|Subcat=Intr|Tense=Past|VerbForm=Part": {
        POS: VERB
    },
    "V|refl|imp__Mood=Imp|Reflex=Yes|VerbForm=Fin": {POS: VERB},
    "V|refl|inf__Reflex=Yes|VerbForm=Inf": {POS: VERB},
    "V|refl|inf|subst__Reflex=Yes|VerbForm=Inf": {POS: VERB},
    "V|refl|ott|1of2of3|mv__Aspect=Imp|Mood=Ind|Number=Plur|Reflex=Yes|Tense=Pres|VerbForm=Fin": {
        POS: VERB
    },
    "V|refl|ott|1|ev__Aspect=Imp|Mood=Ind|Number=Sing|Person=1|Reflex=Yes|Tense=Pres|VerbForm=Fin": {
        POS: VERB
    },
    "V|refl|ott|2|ev__Aspect=Imp|Mood=Ind|Number=Sing|Person=2|Reflex=Yes|Tense=Pres|VerbForm=Fin": {
        POS: VERB
    },
    "V|refl|ott|3|ev__Aspect=Imp|Mood=Ind|Number=Sing|Person=3|Reflex=Yes|Tense=Pres|VerbForm=Fin": {
        POS: VERB
    },
    "V|refl|ovt|1of2of3|ev__Aspect=Imp|Mood=Ind|Number=Sing|Reflex=Yes|Tense=Past|VerbForm=Fin": {
        POS: VERB
    },
    "V|refl|ovt|1of2of3|mv__Aspect=Imp|Mood=Ind|Number=Plur|Reflex=Yes|Tense=Past|VerbForm=Fin": {
        POS: VERB
    },
    "V|refl|tegdw|vervneut__Case=Nom|Reflex=Yes|Tense=Pres|VerbForm=Part": {POS: VERB},
    "V|refl|verldw|onverv__Reflex=Yes|Tense=Past|VerbForm=Part": {POS: VERB},
    "V|trans|conj__Mood=Sub|Subcat=Tran|VerbForm=Fin": {POS: VERB},
    "V|trans|imp__Mood=Imp|Subcat=Tran|VerbForm=Fin": {POS: VERB},
    "V|trans|inf__Subcat=Tran|VerbForm=Inf": {POS: VERB},
    "V|trans|inf|subst__Subcat=Tran|VerbForm=Inf": {POS: VERB},
    "V|trans|ott|1of2of3|mv__Aspect=Imp|Mood=Ind|Number=Plur|Subcat=Tran|Tense=Pres|VerbForm=Fin": {
        POS: VERB
    },
    "V|trans|ott|1|ev__Aspect=Imp|Mood=Ind|Number=Sing|Person=1|Subcat=Tran|Tense=Pres|VerbForm=Fin": {
        POS: VERB
    },
    "V|trans|ott|2|ev__Aspect=Imp|Mood=Ind|Number=Sing|Person=2|Subcat=Tran|Tense=Pres|VerbForm=Fin": {
        POS: VERB
    },
    "V|trans|ott|3|ev__Aspect=Imp|Mood=Ind|Number=Sing|Person=3|Subcat=Tran|Tense=Pres|VerbForm=Fin": {
        POS: VERB
    },
    "V|trans|ovt|1of2of3|ev__Aspect=Imp|Mood=Ind|Number=Sing|Subcat=Tran|Tense=Past|VerbForm=Fin": {
        POS: VERB
    },
    "V|trans|ovt|1of2of3|mv__Aspect=Imp|Mood=Ind|Number=Plur|Subcat=Tran|Tense=Past|VerbForm=Fin": {
        POS: VERB
    },
    "V|trans|tegdw|onverv__Subcat=Tran|Tense=Pres|VerbForm=Part": {POS: VERB},
    "V|trans|tegdw|vervneut__Case=Nom|Subcat=Tran|Tense=Pres|VerbForm=Part": {
        POS: VERB
    },
    "V|trans|verldw|onverv__Subcat=Tran|Tense=Past|VerbForm=Part": {POS: VERB},
    "V|trans|verldw|vervmv__Number=Plur|Subcat=Tran|Tense=Past|VerbForm=Part": {
        POS: VERB
    },
    "V|trans|verldw|vervneut__Case=Nom|Subcat=Tran|Tense=Past|VerbForm=Part": {
        POS: VERB
    },
    "V|trans|verldw|vervvergr__Degree=Cmp|Subcat=Tran|Tense=Past|VerbForm=Part": {
        POS: VERB
    },
    "X__Aspect=Imp|Definite=Def|Mood=Ind|Number=Plur|Person=3|Tense=Pres|VerbForm=Fin|VerbType=Mod": {
        POS: X
    },
    "X__Aspect=Imp|Definite=Def|Mood=Ind|Number=Sing|Person=3|PronType=Ind|Tense=Pres|VerbForm=Fin": {
        POS: X
    },
    "X__Aspect=Imp|Degree=Pos|Mood=Ind|Number=Sing|Person=2|Subcat=Tran|Tense=Pres|VerbForm=Fin": {
        POS: X
    },
    "X__Aspect=Imp|Degree=Pos|Mood=Ind|Number=Sing|Person=2|Tense=Past|VerbForm=Part": {
        POS: X
    },
    "X__Aspect=Imp|Degree=Pos|Mood=Ind|Number=Sing|Person=2|Tense=Pres|VerbForm=Inf": {
        POS: X
    },
    "X__Aspect=Imp|Mood=Ind|Number=Sing|Person=1|Tense=Pres|VerbForm=Fin": {POS: X},
    "X__Aspect=Imp|Mood=Ind|Number=Sing|Person=2|PronType=Dem|Tense=Pres|VerbForm=Fin": {
        POS: X
    },
    "X__Aspect=Imp|Mood=Ind|Number=Sing|Person=2|PronType=Rel|Tense=Pres|VerbForm=Fin": {
        POS: X
    },
    "X__Aspect=Imp|Mood=Ind|Number=Sing|Person=2|Subcat=Tran|Tense=Pres|VerbForm=Fin": {
        POS: X
    },
    "X__Aspect=Imp|Mood=Ind|Number=Sing|Person=3|PronType=Ind|Tense=Pres|VerbForm=Fin": {
        POS: X
    },
    "X__Aspect=Imp|Mood=Ind|Number=Sing|Person=3|Subcat=Tran|Tense=Pres|VerbForm=Fin": {
        POS: X
    },
    "X__Aspect=Imp|Mood=Ind|Number=Sing|Person=3|Tense=Pres|VerbForm=Fin": {POS: X},
    "X__Aspect=Imp|Mood=Ind|Number=Sing|Subcat=Intr|Tense=Pres|VerbForm=Inf": {POS: X},
    "X__Aspect=Imp|Mood=Ind|Number=Sing|Tense=Past|VerbForm=Fin": {POS: X},
    "X__Aspect=Imp|Mood=Ind|Person=3|PronType=Dem|Tense=Pres|VerbForm=Inf": {POS: X},
    "X__Case=Dat|Degree=Pos|Number=Sing": {POS: X},
    "X__Case=Dat|Number=Sing": {POS: X},
    "X__Case=Gen|Definite=Def|Number=Sing": {POS: X},
    "X__Case=Gen|Number=Plur|PronType=Dem": {POS: X},
    "X__Case=Gen|Number=Plur|PronType=Ind": {POS: X},
    "X__Case=Gen|Number=Sing": {POS: X},
    "X__Case=Gen|Number=Sing|Person=3|Poss=Yes|PronType=Prs|VerbForm=Inf": {POS: X},
    "X__Case=Gen|Number=Sing|PronType=Ind": {POS: X},
    "X__Case=Nom|Definite=Def|Degree=Cmp|Gender=Neut": {POS: X},
    "X__Case=Nom|Definite=Def|Degree=Sup": {POS: X},
    "X__Case=Nom|Definite=Def|Degree=Sup|Gender=Neut": {POS: X},
    "X__Case=Nom|Degree=Cmp": {POS: X},
    "X__Case=Nom|Degree=Pos": {POS: X},
    "X__Case=Nom|Degree=Pos|Gender=Neut": {POS: X},
    "X__Case=Nom|Degree=Pos|Number=Plur": {POS: X},
    "X__Case=Nom|Degree=Pos|Number=Sing": {POS: X},
    "X__Case=Nom|Degree=Sup": {POS: X},
    "X__Case=Nom|Degree=Sup|Number=Sing|Person=2|Poss=Yes|PronType=Prs": {POS: X},
    "X__Case=Nom|Degree=Sup|PronType=Ind": {POS: X},
    "X__Case=Nom|Number=Sing|Tense=Past|VerbForm=Part": {POS: X},
    "X__Definite=Def": {POS: X},
    "X__Definite=Def|Degree=Cmp|Gender=Neut": {POS: X},
    "X__Definite=Def|Degree=Pos": {POS: X},
    "X__Definite=Def|Degree=Pos|Number=Sing": {POS: X},
    "X__Definite=Def|Degree=Pos|Variant=Short": {POS: X},
    "X__Definite=Def|Degree=Sup|Gender=Neut": {POS: X},
    "X__Definite=Def|Degree=Sup|Gender=Neut|Number=Sing": {POS: X},
    "X__Definite=Def|Degree=Sup|Gender=Neut|PronType=Ind": {POS: X},
    "X__Definite=Def|Gender=Neut": {POS: X},
    "X__Definite=Def|Gender=Neut|Number=Plur|Person=3": {POS: X},
    "X__Definite=Def|Gender=Neut|Number=Sing": {POS: X},
    "X__Definite=Def|Number=Plur": {POS: X},
    "X__Definite=Def|Number=Sing": {POS: X},
    "X__Definite=Def|Number=Sing|Person=1": {POS: X},
    "X__Definite=Def|Number=Sing|Tense=Past|VerbForm=Part": {POS: X},
    "X__Definite=Def|Number=Sing|Tense=Pres|VerbForm=Part": {POS: X},
    "X__Degree=Cmp": {POS: X},
    "X__Degree=Cmp|Gender=Neut": {POS: X},
    "X__Degree=Cmp|Number=Sing|Person=3": {POS: X},
    "X__Degree=Cmp|PronType=Ind": {POS: X},
    "X__Degree=Cmp|Variant=Short": {POS: X},
    "X__Degree=Pos": {POS: X},
    "X__Degree=Pos|Gender=Neut|Number=Sing": {POS: X},
    "X__Degree=Pos|Mood=Imp|Variant=Short|VerbForm=Fin": {POS: X},
    "X__Degree=Pos|Mood=Sub|VerbForm=Fin": {POS: X},
    "X__Degree=Pos|Number=Plur": {POS: X},
    "X__Degree=Pos|Number=Plur|Person=2|Subcat=Tran": {POS: X},
    "X__Degree=Pos|Number=Plur|Variant=Short": {POS: X},
    "X__Degree=Pos|Number=Sing": {POS: X},
    "X__Degree=Pos|Number=Sing|Person=1|Poss=Yes|PronType=Prs": {POS: X},
    "X__Degree=Pos|Number=Sing|Person=2": {POS: X},
    "X__Degree=Pos|Number=Sing|Person=3": {POS: X},
    "X__Degree=Pos|Number=Sing|PronType=Ind": {POS: X},
    "X__Degree=Pos|Number=Sing|Subcat=Tran|Tense=Past|VerbForm=Part": {POS: X},
    "X__Degree=Pos|Number=Sing|Tense=Past|VerbForm=Part": {POS: X},
    "X__Degree=Pos|Number=Sing|Variant=Short": {POS: X},
    "X__Degree=Pos|PronType=Dem": {POS: X},
    "X__Degree=Pos|Subcat=Tran": {POS: X},
    "X__Degree=Pos|Variant=Short": {POS: X},
    "X__Degree=Pos|Variant=Short|VerbForm=Inf": {POS: X},
    "X__Degree=Pos|VerbForm=Inf": {POS: X},
    "X__Gender=Com|Number=Sing": {POS: X},
    "X__Gender=Neut": {POS: X},
    "X__Gender=Neut|Number=Sing": {POS: X},
    "X__Gender=Neut|VerbForm=Inf": {POS: X},
    "X__Mood=Sub|Number=Sing|VerbForm=Fin": {POS: X},
    "X__Mood=Sub|VerbForm=Fin": {POS: X},
    "X__Number=Plur": {POS: X},
    "X__Number=Plur,Sing|Person=3": {POS: X},
    "X__Number=Plur|Person=1|Poss=Yes|PronType=Prs|VerbForm=Inf": {POS: X},
    "X__Number=Plur|PronType=Ind": {POS: X},
    "X__Number=Plur|PronType=Int": {POS: X},
    "X__Number=Plur|Subcat=Tran|Tense=Past|VerbForm=Part": {POS: X},
    "X__Number=Plur|Tense=Past|VerbForm=Part": {POS: X},
    "X__Number=Sing": {POS: X},
    "X__Number=Sing|Person=3": {POS: X},
    "X__Number=Sing|PronType=Dem": {POS: X},
    "X__Number=Sing|PronType=Ind": {POS: X},
    "X__Number=Sing|PronType=Int": {POS: X},
    "X__Number=Sing|PronType=Rel": {POS: X},
    "X__Number=Sing|Subcat=Intr|Tense=Pres|VerbForm=Part": {POS: X},
    "X__Number=Sing|Subcat=Tran": {POS: X},
    "X__Number=Sing|Subcat=Tran|Tense=Past|VerbForm=Part": {POS: X},
    "X__Number=Sing|Tense=Past|VerbForm=Part": {POS: X},
    "X__Number=Sing|Tense=Pres|VerbForm=Part": {POS: X},
    "X__Person=3|PronType=Prs|Reflex=Yes": {POS: X},
    "X__PronType=Dem": {POS: X},
    "X__PronType=Ind": {POS: X},
    "X__PronType=Int": {POS: X},
    "X__PronType=Rel": {POS: X},
    "X__Subcat=Intr|Tense=Past|VerbForm=Part": {POS: X},
    "X__Subcat=Tran|Tense=Past|VerbForm=Part": {POS: X},
    "X__VerbForm=Inf": {POS: X},
    "X__VerbForm=Inf|VerbType=Mod": {POS: X},
    "X__VerbType=Aux,Cop": {POS: X},
    "X___": {POS: X},
    "_SP": {POS: SPACE},
}
