# coding: utf8
from __future__ import unicode_literals

from ...symbols import POS, ADJ, ADP, ADV, CONJ, INTJ, NOUN, NUM, PART
from ...symbols import PRON, PROPN, PUNCT, SYM, VERB, X


TAG_MAP = {
    "Agcfpan": {
        POS: ADJ,
        "Case": "Acc",
        "Degree": "Cmp",
        "Gender": "Fem",
        "Number": "Plur",
    },
    "Agcfpgn": {
        POS: ADJ,
        "Case": "Gen",
        "Degree": "Cmp",
        "Gender": "Fem",
        "Number": "Plur",
    },
    "Agcfpin": {
        POS: ADJ,
        "Case": "Ins",
        "Degree": "Cmp",
        "Gender": "Fem",
        "Number": "Plur",
    },
    "Agcfpln": {
        POS: ADJ,
        "Case": "Loc",
        "Degree": "Cmp",
        "Gender": "Fem",
        "Number": "Plur",
    },
    "Agcfpnn": {
        POS: ADJ,
        "Case": "Nom",
        "Degree": "Cmp",
        "Gender": "Fem",
        "Number": "Plur",
    },
    "Agcfsan": {
        POS: ADJ,
        "Case": "Acc",
        "Degree": "Cmp",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "Agcfsnn": {
        POS: ADJ,
        "Case": "Nom",
        "Degree": "Cmp",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "Agcfsny": {
        POS: ADJ,
        "Case": "Nom",
        "Degree": "Cmp",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "Agcmpan": {
        POS: ADJ,
        "Case": "Acc",
        "Degree": "Cmp",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "Agcmpgn": {
        POS: ADJ,
        "Case": "Gen",
        "Degree": "Cmp",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "Agcmpin": {
        POS: ADJ,
        "Case": "Ins",
        "Degree": "Cmp",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "Agcmpnn": {
        POS: ADJ,
        "Case": "Nom",
        "Degree": "Cmp",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "Agcmsa-": {
        POS: ADJ,
        "Case": "Acc",
        "Degree": "Cmp",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "Agcmsan": {
        POS: ADJ,
        "Case": "Acc",
        "Degree": "Cmp",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "Agcmsay": {
        POS: ADJ,
        "Case": "Acc",
        "Degree": "Cmp",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "Agcmsgn": {
        POS: ADJ,
        "Case": "Gen",
        "Degree": "Cmp",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "Agcmsnn": {
        POS: ADJ,
        "Case": "Nom",
        "Degree": "Cmp",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "Agpfpan": {
        POS: ADJ,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
    },
    "Agpfpay": {
        POS: ADJ,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
    },
    "Agpfpdn": {
        POS: ADJ,
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
    },
    "Agpfpdy": {
        POS: ADJ,
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
    },
    "Agpfpgn": {
        POS: ADJ,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
    },
    "Agpfpgy": {
        POS: ADJ,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
    },
    "Agpfpin": {
        POS: ADJ,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
    },
    "Agpfpiy": {
        POS: ADJ,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
    },
    "Agpfpln": {
        POS: ADJ,
        "Case": "Loc",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
    },
    "Agpfpnn": {
        POS: ADJ,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
    },
    "Agpfpny": {
        POS: ADJ,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
    },
    "Agpfsan": {
        POS: ADJ,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "Agpfsay": {
        POS: ADJ,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "Agpfsdn": {
        POS: ADJ,
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "Agpfsdy": {
        POS: ADJ,
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "Agpfsgn": {
        POS: ADJ,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "Agpfsgy": {
        POS: ADJ,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "Agpfsin": {
        POS: ADJ,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "Agpfsiy": {
        POS: ADJ,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "Agpfsln": {
        POS: ADJ,
        "Case": "Loc",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "Agpfsly": {
        POS: ADJ,
        "Case": "Loc",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "Agpfsnn": {
        POS: ADJ,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "Agpfsny": {
        POS: ADJ,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "Agpmpan": {
        POS: ADJ,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "Agpmpay": {
        POS: ADJ,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "Agpmpdn": {
        POS: ADJ,
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "Agpmpdy": {
        POS: ADJ,
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "Agpmpgn": {
        POS: ADJ,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "Agpmpgy": {
        POS: ADJ,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "Agpmpin": {
        POS: ADJ,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "Agpmpiy": {
        POS: ADJ,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "Agpmpln": {
        POS: ADJ,
        "Case": "Loc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "Agpmply": {
        POS: ADJ,
        "Case": "Loc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "Agpmpnn": {
        POS: ADJ,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "Agpmpny": {
        POS: ADJ,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "Agpmsan": {
        POS: ADJ,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "Agpmsay": {
        POS: ADJ,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "Agpmsdn": {
        POS: ADJ,
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "Agpmsdy": {
        POS: ADJ,
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "Agpmsgn": {
        POS: ADJ,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "Agpmsgy": {
        POS: ADJ,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "Agpmsin": {
        POS: ADJ,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "Agpmsiy": {
        POS: ADJ,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "Agpmsln": {
        POS: ADJ,
        "Case": "Loc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "Agpmsly": {
        POS: ADJ,
        "Case": "Loc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "Agpmsnn": {
        POS: ADJ,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "Agpmsny": {
        POS: ADJ,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "Agpmsvn": {
        POS: ADJ,
        "Case": "Voc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "Agpn--n": {POS: ADJ, "Degree": "Pos", "Gender": "Neut"},
    "Agpn-nn": {POS: ADJ, "Case": "Nom", "Degree": "Pos", "Gender": "Neut"},
    "Agsfpan": {
        POS: ADJ,
        "Case": "Acc",
        "Degree": "Sup",
        "Gender": "Fem",
        "Number": "Plur",
    },
    "Agsfpdn": {
        POS: ADJ,
        "Case": "Dat",
        "Degree": "Sup",
        "Gender": "Fem",
        "Number": "Plur",
    },
    "Agsfpgn": {
        POS: ADJ,
        "Case": "Gen",
        "Degree": "Sup",
        "Gender": "Fem",
        "Number": "Plur",
    },
    "Agsfpin": {
        POS: ADJ,
        "Case": "Ins",
        "Degree": "Sup",
        "Gender": "Fem",
        "Number": "Plur",
    },
    "Agsfpnn": {
        POS: ADJ,
        "Case": "Nom",
        "Degree": "Sup",
        "Gender": "Fem",
        "Number": "Plur",
    },
    "Agsfsgn": {
        POS: ADJ,
        "Case": "Gen",
        "Degree": "Sup",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "Agsfsgy": {
        POS: ADJ,
        "Case": "Gen",
        "Degree": "Sup",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "Agsfsin": {
        POS: ADJ,
        "Case": "Ins",
        "Degree": "Sup",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "Agsfsln": {
        POS: ADJ,
        "Case": "Loc",
        "Degree": "Sup",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "Agsfsnn": {
        POS: ADJ,
        "Case": "Nom",
        "Degree": "Sup",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "Agsfsny": {
        POS: ADJ,
        "Case": "Nom",
        "Degree": "Sup",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "Agsmpan": {
        POS: ADJ,
        "Case": "Acc",
        "Degree": "Sup",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "Agsmpgn": {
        POS: ADJ,
        "Case": "Gen",
        "Degree": "Sup",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "Agsmpin": {
        POS: ADJ,
        "Case": "Ins",
        "Degree": "Sup",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "Agsmpnn": {
        POS: ADJ,
        "Case": "Nom",
        "Degree": "Sup",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "Agsmsan": {
        POS: ADJ,
        "Case": "Acc",
        "Degree": "Sup",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "Agsmsgn": {
        POS: ADJ,
        "Case": "Gen",
        "Degree": "Sup",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "Agsmsin": {
        POS: ADJ,
        "Case": "Ins",
        "Degree": "Sup",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "Agsmsnn": {
        POS: ADJ,
        "Case": "Nom",
        "Degree": "Sup",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "Agsn--n": {POS: ADJ, "Degree": "Sup", "Gender": "Neut"},
    "Cg": {POS: CONJ},
    "Ig": {POS: INTJ},
    "M----d-": {POS: NUM, "NumForm": "Digit"},
    "M----r-": {POS: NUM, "NumForm": "Roman"},
    "M----rn": {POS: NUM, "NumForm": "Roman"},
    "Mc---l-": {POS: NUM, "NumForm": "Word", "NumType": "Card"},
    "Mc--gl-": {POS: NUM, "Case": "Gen", "NumForm": "Word", "NumType": "Card"},
    "Mcf-al-": {
        POS: NUM,
        "Case": "Acc",
        "Gender": "Fem",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcf-aln": {
        POS: NUM,
        "Case": "Acc",
        "Gender": "Fem",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcf-dl-": {
        POS: NUM,
        "Case": "Dat",
        "Gender": "Fem",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcf-gl-": {
        POS: NUM,
        "Case": "Gen",
        "Gender": "Fem",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcf-gln": {
        POS: NUM,
        "Case": "Gen",
        "Gender": "Fem",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcf-il-": {
        POS: NUM,
        "Case": "Ins",
        "Gender": "Fem",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcf-iln": {
        POS: NUM,
        "Case": "Ins",
        "Gender": "Fem",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcf-nl-": {
        POS: NUM,
        "Case": "Nom",
        "Gender": "Fem",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcf-nln": {
        POS: NUM,
        "Case": "Nom",
        "Gender": "Fem",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcfpnl-": {
        POS: NUM,
        "Case": "Nom",
        "Gender": "Fem",
        "Number": "Plur",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcfsal-": {
        POS: NUM,
        "Case": "Acc",
        "Gender": "Fem",
        "Number": "Sing",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcfsdl-": {
        POS: NUM,
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcfsgl-": {
        POS: NUM,
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcfsgln": {
        POS: NUM,
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcfsil-": {
        POS: NUM,
        "Case": "Ins",
        "Gender": "Fem",
        "Number": "Sing",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcm-al-": {
        POS: NUM,
        "Case": "Acc",
        "Gender": "Masc",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcm-aln": {
        POS: NUM,
        "Case": "Acc",
        "Gender": "Masc",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcm-dl-": {
        POS: NUM,
        "Case": "Dat",
        "Gender": "Masc",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcm-dln": {
        POS: NUM,
        "Case": "Dat",
        "Gender": "Masc",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcm-gl-": {
        POS: NUM,
        "Case": "Gen",
        "Gender": "Masc",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcm-gln": {
        POS: NUM,
        "Case": "Gen",
        "Gender": "Masc",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcm-il-": {
        POS: NUM,
        "Case": "Ins",
        "Gender": "Masc",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcm-nl-": {
        POS: NUM,
        "Case": "Nom",
        "Gender": "Masc",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcm-nln": {
        POS: NUM,
        "Case": "Nom",
        "Gender": "Masc",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcmpal-": {
        POS: NUM,
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Plur",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcmpaln": {
        POS: NUM,
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Plur",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcmpgl-": {
        POS: NUM,
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Plur",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcmpgln": {
        POS: NUM,
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Plur",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcmpnl-": {
        POS: NUM,
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Plur",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcmpnln": {
        POS: NUM,
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Plur",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcmsal-": {
        POS: NUM,
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcmsaln": {
        POS: NUM,
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcmsgl-": {
        POS: NUM,
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcmsgln": {
        POS: NUM,
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcmsnln": {
        POS: NUM,
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Mcnsnln": {
        POS: NUM,
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "NumForm": "Word",
        "NumType": "Card",
    },
    "Ml--aln": {POS: NUM, "Case": "Acc", "NumForm": "Word", "NumType": "Card"},
    "Mmm-aln": {
        POS: ADV,
        "Case": "Acc",
        "Gender": "Masc",
        "NumForm": "Word",
        "NumType": "Mult",
    },
    "Mmm-dln": {
        POS: ADV,
        "Case": "Dat",
        "Gender": "Masc",
        "NumForm": "Word",
        "NumType": "Mult",
    },
    "Mmm-gl-": {
        POS: ADV,
        "Case": "Gen",
        "Gender": "Masc",
        "NumForm": "Word",
        "NumType": "Mult",
    },
    "Mmm-nln": {
        POS: ADV,
        "Case": "Nom",
        "Gender": "Masc",
        "NumForm": "Word",
        "NumType": "Mult",
    },
    "Mofpily": {
        POS: ADJ,
        "Case": "Ins",
        "Gender": "Fem",
        "Number": "Plur",
        "NumForm": "Word",
        "NumType": "Ord",
    },
    "Mofsaly": {
        POS: ADJ,
        "Case": "Acc",
        "Gender": "Fem",
        "Number": "Sing",
        "NumForm": "Word",
        "NumType": "Ord",
    },
    "Mofsamn": {
        POS: ADJ,
        "Case": "Acc",
        "Gender": "Fem",
        "Number": "Sing",
        "NumForm": "Combi",
        "NumType": "Ord",
    },
    "Mofsily": {
        POS: ADJ,
        "Case": "Ins",
        "Gender": "Fem",
        "Number": "Sing",
        "NumForm": "Word",
        "NumType": "Ord",
    },
    "Mofsnly": {
        POS: ADJ,
        "Case": "Nom",
        "Gender": "Fem",
        "Number": "Sing",
        "NumForm": "Word",
        "NumType": "Ord",
    },
    "Mofsnmy": {
        POS: ADJ,
        "Case": "Nom",
        "Gender": "Fem",
        "Number": "Sing",
        "NumForm": "Combi",
        "NumType": "Ord",
    },
    "Mompgln": {
        POS: ADJ,
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Plur",
        "NumForm": "Word",
        "NumType": "Ord",
    },
    "Mompily": {
        POS: ADJ,
        "Case": "Ins",
        "Gender": "Masc",
        "Number": "Plur",
        "NumForm": "Word",
        "NumType": "Ord",
    },
    "Mompnln": {
        POS: ADJ,
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Plur",
        "NumForm": "Word",
        "NumType": "Ord",
    },
    "Mompnly": {
        POS: ADJ,
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Plur",
        "NumForm": "Word",
        "NumType": "Ord",
    },
    "Momsaln": {
        POS: ADJ,
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "NumForm": "Word",
        "NumType": "Ord",
    },
    "Momsaly": {
        POS: ADJ,
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "NumForm": "Word",
        "NumType": "Ord",
    },
    "Momsgln": {
        POS: ADJ,
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "NumForm": "Word",
        "NumType": "Ord",
    },
    "Momsgly": {
        POS: ADJ,
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "NumForm": "Word",
        "NumType": "Ord",
    },
    "Momslly": {
        POS: ADJ,
        "Case": "Loc",
        "Gender": "Masc",
        "Number": "Sing",
        "NumForm": "Word",
        "NumType": "Ord",
    },
    "Momsnln": {
        POS: ADJ,
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "NumForm": "Word",
        "NumType": "Ord",
    },
    "Momsnly": {
        POS: ADJ,
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "NumForm": "Word",
        "NumType": "Ord",
    },
    "Mon--ln": {POS: ADJ, "Gender": "Neut", "NumForm": "Word", "NumType": "Ord"},
    "Nccpnn-": {POS: NOUN, "Case": "Nom", "Number": "Plur"},
    "Nccsdn-": {POS: NOUN, "Case": "Dat", "Number": "Sing"},
    "Nccsgn-": {POS: NOUN, "Case": "Gen", "Number": "Sing"},
    "Nccsnn-": {POS: NOUN, "Case": "Nom", "Number": "Sing"},
    "Ncf--n-": {POS: NOUN, "Gender": "Fem"},
    "Ncfpan-": {POS: NOUN, "Case": "Acc", "Gender": "Fem", "Number": "Plur"},
    "Ncfpdn-": {POS: NOUN, "Case": "Dat", "Gender": "Fem", "Number": "Plur"},
    "Ncfpgn-": {POS: NOUN, "Case": "Gen", "Gender": "Fem", "Number": "Plur"},
    "Ncfpin-": {POS: NOUN, "Case": "Ins", "Gender": "Fem", "Number": "Plur"},
    "Ncfpln-": {POS: NOUN, "Case": "Loc", "Gender": "Fem", "Number": "Plur"},
    "Ncfpnn-": {POS: NOUN, "Case": "Nom", "Gender": "Fem", "Number": "Plur"},
    "Ncfsan-": {POS: NOUN, "Case": "Acc", "Gender": "Fem", "Number": "Sing"},
    "Ncfsdn-": {POS: NOUN, "Case": "Dat", "Gender": "Fem", "Number": "Sing"},
    "Ncfsgn-": {POS: NOUN, "Case": "Gen", "Gender": "Fem", "Number": "Sing"},
    "Ncfsin-": {POS: NOUN, "Case": "Ins", "Gender": "Fem", "Number": "Sing"},
    "Ncfsln-": {POS: NOUN, "Case": "Loc", "Gender": "Fem", "Number": "Sing"},
    "Ncfsnn-": {POS: NOUN, "Case": "Nom", "Gender": "Fem", "Number": "Sing"},
    "Ncfsvn-": {POS: NOUN, "Case": "Voc", "Gender": "Fem", "Number": "Sing"},
    "Ncfsxn-": {POS: NOUN, "Gender": "Fem", "Number": "Sing"},
    "Ncm--a-": {POS: NOUN, "Gender": "Masc"},
    "Ncm--n-": {POS: NOUN, "Gender": "Masc"},
    "Ncmpan-": {POS: NOUN, "Case": "Acc", "Gender": "Masc", "Number": "Plur"},
    "Ncmpdn-": {POS: NOUN, "Case": "Dat", "Gender": "Masc", "Number": "Plur"},
    "Ncmpgn-": {POS: NOUN, "Case": "Gen", "Gender": "Masc", "Number": "Plur"},
    "Ncmpin-": {POS: NOUN, "Case": "Ins", "Gender": "Masc", "Number": "Plur"},
    "Ncmpln-": {POS: NOUN, "Case": "Loc", "Gender": "Masc", "Number": "Plur"},
    "Ncmpnn-": {POS: NOUN, "Case": "Nom", "Gender": "Masc", "Number": "Plur"},
    "Ncmpny-": {
        POS: NOUN,
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Plur",
        "Reflex": "Yes",
    },
    "Ncmsan-": {POS: NOUN, "Case": "Acc", "Gender": "Masc", "Number": "Sing"},
    "Ncmsay-": {
        POS: NOUN,
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "Reflex": "Yes",
    },
    "Ncmsdn-": {POS: NOUN, "Case": "Dat", "Gender": "Masc", "Number": "Sing"},
    "Ncmsdy-": {
        POS: NOUN,
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
        "Reflex": "Yes",
    },
    "Ncmsgn-": {POS: NOUN, "Case": "Gen", "Gender": "Masc", "Number": "Sing"},
    "Ncmsgy-": {
        POS: NOUN,
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "Reflex": "Yes",
    },
    "Ncmsin-": {POS: NOUN, "Case": "Ins", "Gender": "Masc", "Number": "Sing"},
    "Ncmsiy-": {
        POS: NOUN,
        "Case": "Ins",
        "Gender": "Masc",
        "Number": "Sing",
        "Reflex": "Yes",
    },
    "Ncmsln-": {POS: NOUN, "Case": "Loc", "Gender": "Masc", "Number": "Sing"},
    "Ncmsnn-": {POS: NOUN, "Case": "Nom", "Gender": "Masc", "Number": "Sing"},
    "Ncmsny-": {
        POS: NOUN,
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "Reflex": "Yes",
    },
    "Ncmsvn-": {POS: NOUN, "Case": "Voc", "Gender": "Masc", "Number": "Sing"},
    "Ncmsxn-": {POS: NOUN, "Gender": "Masc", "Number": "Sing"},
    "Np---n-": {POS: PROPN},
    "Npc--n-": {POS: PROPN},
    "Npfpgn-": {POS: PROPN, "Case": "Gen", "Gender": "Fem", "Number": "Plur"},
    "Npfpgng": {
        POS: PROPN,
        "Case": "Gen",
        "Gender": "Fem",
        "NameType": "Geo",
        "Number": "Plur",
    },
    "Npfpln-": {POS: PROPN, "Case": "Loc", "Gender": "Fem", "Number": "Plur"},
    "Npfsan-": {POS: PROPN, "Case": "Acc", "Gender": "Fem", "Number": "Sing"},
    "Npfsanf": {
        POS: PROPN,
        "Case": "Acc",
        "Gender": "Fem",
        "NameType": "Giv",
        "Number": "Sing",
    },
    "Npfsang": {
        POS: PROPN,
        "Case": "Acc",
        "Gender": "Fem",
        "NameType": "Geo",
        "Number": "Sing",
    },
    "Npfsdn-": {POS: PROPN, "Case": "Dat", "Gender": "Fem", "Number": "Sing"},
    "Npfsdnf": {
        POS: PROPN,
        "Case": "Dat",
        "Gender": "Fem",
        "NameType": "Giv",
        "Number": "Sing",
    },
    "Npfsdng": {
        POS: PROPN,
        "Case": "Dat",
        "Gender": "Fem",
        "NameType": "Geo",
        "Number": "Sing",
    },
    "Npfsdns": {
        POS: PROPN,
        "Case": "Dat",
        "Gender": "Fem",
        "NameType": "Sur",
        "Number": "Sing",
    },
    "Npfsgn-": {POS: PROPN, "Case": "Gen", "Gender": "Fem", "Number": "Sing"},
    "Npfsgnf": {
        POS: PROPN,
        "Case": "Gen",
        "Gender": "Fem",
        "NameType": "Giv",
        "Number": "Sing",
    },
    "Npfsgng": {
        POS: PROPN,
        "Case": "Gen",
        "Gender": "Fem",
        "NameType": "Geo",
        "Number": "Sing",
    },
    "Npfsgns": {
        POS: PROPN,
        "Case": "Gen",
        "Gender": "Fem",
        "NameType": "Sur",
        "Number": "Sing",
    },
    "Npfsin-": {POS: PROPN, "Case": "Ins", "Gender": "Fem", "Number": "Sing"},
    "Npfsinf": {
        POS: PROPN,
        "Case": "Ins",
        "Gender": "Fem",
        "NameType": "Giv",
        "Number": "Sing",
    },
    "Npfsing": {
        POS: PROPN,
        "Case": "Ins",
        "Gender": "Fem",
        "NameType": "Geo",
        "Number": "Sing",
    },
    "Npfsins": {
        POS: PROPN,
        "Case": "Ins",
        "Gender": "Fem",
        "NameType": "Sur",
        "Number": "Sing",
    },
    "Npfslng": {
        POS: PROPN,
        "Case": "Loc",
        "Gender": "Fem",
        "NameType": "Geo",
        "Number": "Sing",
    },
    "Npfsnn-": {POS: PROPN, "Case": "Nom", "Gender": "Fem", "Number": "Sing"},
    "Npfsnnf": {
        POS: PROPN,
        "Case": "Nom",
        "Gender": "Fem",
        "NameType": "Giv",
        "Number": "Sing",
    },
    "Npfsnng": {
        POS: PROPN,
        "Case": "Nom",
        "Gender": "Fem",
        "NameType": "Geo",
        "Number": "Sing",
    },
    "Npfsnns": {
        POS: PROPN,
        "Case": "Nom",
        "Gender": "Fem",
        "NameType": "Sur",
        "Number": "Sing",
    },
    "Npm--nf": {POS: PROPN, "Gender": "Masc", "NameType": "Giv"},
    "Npmpgng": {
        POS: PROPN,
        "Case": "Gen",
        "Gender": "Masc",
        "NameType": "Geo",
        "Number": "Plur",
    },
    "Npmplng": {
        POS: PROPN,
        "Case": "Loc",
        "Gender": "Masc",
        "NameType": "Geo",
        "Number": "Plur",
    },
    "Npms-nf": {POS: PROPN, "Gender": "Masc", "NameType": "Giv", "Number": "Sing"},
    "Npmsan-": {POS: PROPN, "Case": "Acc", "Gender": "Masc", "Number": "Sing"},
    "Npmsanf": {
        POS: PROPN,
        "Case": "Acc",
        "Gender": "Masc",
        "NameType": "Giv",
        "Number": "Sing",
    },
    "Npmsang": {
        POS: PROPN,
        "Case": "Acc",
        "Gender": "Masc",
        "NameType": "Geo",
        "Number": "Sing",
    },
    "Npmsans": {
        POS: PROPN,
        "Case": "Acc",
        "Gender": "Masc",
        "NameType": "Sur",
        "Number": "Sing",
    },
    "Npmsdnf": {
        POS: PROPN,
        "Case": "Dat",
        "Gender": "Masc",
        "NameType": "Giv",
        "Number": "Sing",
    },
    "Npmsdng": {
        POS: PROPN,
        "Case": "Dat",
        "Gender": "Masc",
        "NameType": "Geo",
        "Number": "Sing",
    },
    "Npmsdns": {
        POS: PROPN,
        "Case": "Dat",
        "Gender": "Masc",
        "NameType": "Sur",
        "Number": "Sing",
    },
    "Npmsgn-": {POS: PROPN, "Case": "Gen", "Gender": "Masc", "Number": "Sing"},
    "Npmsgnf": {
        POS: PROPN,
        "Case": "Gen",
        "Gender": "Masc",
        "NameType": "Giv",
        "Number": "Sing",
    },
    "Npmsgng": {
        POS: PROPN,
        "Case": "Gen",
        "Gender": "Masc",
        "NameType": "Geo",
        "Number": "Sing",
    },
    "Npmsgns": {
        POS: PROPN,
        "Case": "Gen",
        "Gender": "Masc",
        "NameType": "Sur",
        "Number": "Sing",
    },
    "Npmsing": {
        POS: PROPN,
        "Case": "Ins",
        "Gender": "Masc",
        "NameType": "Geo",
        "Number": "Sing",
    },
    "Npmsins": {
        POS: PROPN,
        "Case": "Ins",
        "Gender": "Masc",
        "NameType": "Sur",
        "Number": "Sing",
    },
    "Npmslng": {
        POS: PROPN,
        "Case": "Loc",
        "Gender": "Masc",
        "NameType": "Geo",
        "Number": "Sing",
    },
    "Npmsngf": {
        POS: PROPN,
        "Case": "Nom",
        "Gender": "Masc",
        "NameType": "Giv",
        "Number": "Sing",
    },
    "Npmsnn-": {POS: PROPN, "Case": "Nom", "Gender": "Masc", "Number": "Sing"},
    "Npmsnnf": {
        POS: PROPN,
        "Case": "Nom",
        "Gender": "Masc",
        "NameType": "Giv",
        "Number": "Sing",
    },
    "Npmsnng": {
        POS: PROPN,
        "Case": "Nom",
        "Gender": "Masc",
        "NameType": "Geo",
        "Number": "Sing",
    },
    "Npmsnns": {
        POS: PROPN,
        "Case": "Nom",
        "Gender": "Masc",
        "NameType": "Sur",
        "Number": "Sing",
    },
    "Pg--an": {POS: PRON, "Case": "Acc"},
    "Pg--dn": {POS: PRON, "Case": "Dat"},
    "Pg--gn": {POS: PRON, "Case": "Gen"},
    "Pg--i-": {POS: PRON, "Case": "Ins"},
    "Pg--in": {POS: PRON, "Case": "Ins"},
    "Pg--nn": {POS: PRON, "Case": "Nom"},
    "Pg-dnn": {POS: PRON, "Case": "Nom", "Number": "Dual"},
    "Pg-pa-": {POS: PRON, "Case": "Acc", "Number": "Plur"},
    "Pg-pan": {POS: PRON, "Case": "Acc", "Number": "Plur"},
    "Pg-pdn": {POS: PRON, "Case": "Dat", "Number": "Plur"},
    "Pg-pgn": {POS: PRON, "Case": "Gen", "Number": "Plur"},
    "Pg-pin": {POS: PRON, "Case": "Ins", "Number": "Plur"},
    "Pg-pln": {POS: PRON, "Case": "Loc", "Number": "Plur"},
    "Pg-pnn": {POS: PRON, "Case": "Nom", "Number": "Plur"},
    "Pg-san": {POS: PRON, "Case": "Acc", "Number": "Sing"},
    "Pg-sd-": {POS: PRON, "Case": "Dat", "Number": "Sing"},
    "Pg-sdn": {POS: PRON, "Case": "Dat", "Number": "Sing"},
    "Pg-sgn": {POS: PRON, "Case": "Gen", "Number": "Sing"},
    "Pg-sin": {POS: PRON, "Case": "Ins", "Number": "Sing"},
    "Pg-sln": {POS: PRON, "Case": "Loc", "Number": "Sing"},
    "Pg-snn": {POS: PRON, "Case": "Nom", "Number": "Sing"},
    "Pgf-an": {POS: PRON, "Case": "Acc", "Gender": "Fem"},
    "Pgf-dn": {POS: PRON, "Case": "Dat", "Gender": "Fem"},
    "Pgf-nn": {POS: PRON, "Case": "Nom", "Gender": "Fem"},
    "Pgfpan": {POS: PRON, "Case": "Acc", "Gender": "Fem", "Number": "Plur"},
    "Pgfpdn": {POS: PRON, "Case": "Dat", "Gender": "Fem", "Number": "Plur"},
    "Pgfpgn": {POS: PRON, "Case": "Gen", "Gender": "Fem", "Number": "Plur"},
    "Pgfpin": {POS: PRON, "Case": "Ins", "Gender": "Fem", "Number": "Plur"},
    "Pgfpln": {POS: PRON, "Case": "Loc", "Gender": "Fem", "Number": "Plur"},
    "Pgfpnn": {POS: PRON, "Case": "Nom", "Gender": "Fem", "Number": "Plur"},
    "Pgfsan": {POS: PRON, "Case": "Acc", "Gender": "Fem", "Number": "Sing"},
    "Pgfsdn": {POS: PRON, "Case": "Dat", "Gender": "Fem", "Number": "Sing"},
    "Pgfsgn": {POS: PRON, "Case": "Gen", "Gender": "Fem", "Number": "Sing"},
    "Pgfsin": {POS: PRON, "Case": "Ins", "Gender": "Fem", "Number": "Sing"},
    "Pgfsln": {POS: PRON, "Case": "Loc", "Gender": "Fem", "Number": "Sing"},
    "Pgfsnn": {POS: PRON, "Case": "Nom", "Gender": "Fem", "Number": "Sing"},
    "Pgfsny": {POS: PRON, "Case": "Nom", "Gender": "Fem", "Number": "Sing"},
    "Pgfsny-": {POS: PRON, "Case": "Nom", "Gender": "Fem", "Number": "Sing"},
    "Pgm-a-": {POS: PRON, "Case": "Acc", "Gender": "Masc"},
    "Pgm-an": {POS: PRON, "Case": "Acc", "Gender": "Masc"},
    "Pgm-dn": {POS: PRON, "Case": "Dat", "Gender": "Masc"},
    "Pgm-gn": {POS: PRON, "Case": "Gen", "Gender": "Masc"},
    "Pgm-nn": {POS: PRON, "Case": "Nom", "Gender": "Masc"},
    "Pgmdan": {POS: PRON, "Case": "Acc", "Gender": "Masc", "Number": "Dual"},
    "Pgmdgn": {POS: PRON, "Case": "Gen", "Gender": "Masc", "Number": "Dual"},
    "Pgmdnn": {POS: PRON, "Case": "Nom", "Gender": "Masc", "Number": "Dual"},
    "Pgmpan": {POS: PRON, "Case": "Acc", "Gender": "Masc", "Number": "Plur"},
    "Pgmpan-": {POS: PRON, "Case": "Acc", "Gender": "Masc", "Number": "Plur"},
    "Pgmpdn": {POS: PRON, "Case": "Dat", "Gender": "Masc", "Number": "Plur"},
    "Pgmpgn": {POS: PRON, "Case": "Gen", "Gender": "Masc", "Number": "Plur"},
    "Pgmpin": {POS: PRON, "Case": "Ins", "Gender": "Masc", "Number": "Plur"},
    "Pgmpln": {POS: PRON, "Case": "Loc", "Gender": "Masc", "Number": "Plur"},
    "Pgmpnn": {POS: PRON, "Case": "Nom", "Gender": "Masc", "Number": "Plur"},
    "Pgmsan": {POS: PRON, "Case": "Acc", "Gender": "Masc", "Number": "Sing"},
    "Pgmsdn": {POS: PRON, "Case": "Dat", "Gender": "Masc", "Number": "Sing"},
    "Pgmsgn": {POS: PRON, "Case": "Gen", "Gender": "Masc", "Number": "Sing"},
    "Pgmsin": {POS: PRON, "Case": "Ins", "Gender": "Masc", "Number": "Sing"},
    "Pgmsln": {POS: PRON, "Case": "Loc", "Gender": "Masc", "Number": "Sing"},
    "Pgmsnn": {POS: PRON, "Case": "Nom", "Gender": "Masc", "Number": "Sing"},
    "Pgn--n": {POS: PRON, "Gender": "Neut"},
    "Pgnn--n": {POS: PRON, "Gender": "Neut"},
    "Pgsmdn": {POS: PRON, "Case": "Dat"},
    "Qg": {POS: PART},
    "Rgc": {POS: ADV, "Degree": "Cmp"},
    "Rgp": {POS: ADV, "Degree": "Pos"},
    "Rgs": {POS: ADV, "Degree": "Sup"},
    "Sag": {POS: ADP, "AdpType": "Prep", "Case": "Gen"},
    "Sga": {POS: ADP, "AdpType": "Prep", "Case": "Acc"},
    "Sgg": {POS: ADP, "AdpType": "Prep", "Case": "Gen"},
    "Sgi": {POS: ADP, "AdpType": "Prep", "Case": "Ins"},
    "Vgaa----n--n--": {
        POS: VERB,
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Ger",
    },
    "Vgaa----n--y--": {
        POS: VERB,
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Ger",
    },
    "Vgaa----y--n--": {
        POS: VERB,
        "Polarity": "Neg",
        "Tense": "Past",
        "VerbForm": "Ger",
    },
    "Vgaa----y--y--": {
        POS: VERB,
        "Polarity": "Neg",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Ger",
    },
    "Vgap----n--n--": {
        POS: VERB,
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Ger",
    },
    "Vgap----n--y": {
        POS: VERB,
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Ger",
    },
    "Vgap----n--y--": {
        POS: VERB,
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Ger",
    },
    "Vgap----y--n--": {
        POS: VERB,
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Ger",
    },
    "Vgap----y--y--": {
        POS: VERB,
        "Polarity": "Neg",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Ger",
    },
    "Vgas----n--y--": {
        POS: VERB,
        "Aspect": "Perf",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Ger",
    },
    "Vgb-----n--n--": {POS: ADV, "Polarity": "Pos", "VerbForm": "Conv"},
    "Vgh--pf-n--n--": {
        POS: VERB,
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "VerbForm": "Conv",
    },
    "Vgh--pf-y--n--": {
        POS: VERB,
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Neg",
        "VerbForm": "Conv",
    },
    "Vgh--pm-n--n--": {
        POS: VERB,
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "VerbForm": "Conv",
    },
    "Vgh--pm-n--y--": {
        POS: VERB,
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "VerbForm": "Conv",
    },
    "Vgh--pm-y--n--": {
        POS: VERB,
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Neg",
        "VerbForm": "Conv",
    },
    "Vgh--sf-n--n--": {
        POS: VERB,
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "VerbForm": "Conv",
    },
    "Vgh--sf-n--y--": {
        POS: VERB,
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "VerbForm": "Conv",
    },
    "Vgh--sf-y--n--": {
        POS: VERB,
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Neg",
        "VerbForm": "Conv",
    },
    "Vgh--sm-n--n--": {
        POS: VERB,
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "VerbForm": "Conv",
    },
    "Vgh--sm-n--y--": {
        POS: VERB,
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "VerbForm": "Conv",
    },
    "Vgh--sm-y--n--": {
        POS: VERB,
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Neg",
        "VerbForm": "Conv",
    },
    "Vgi-----n--n--": {POS: VERB, "Polarity": "Pos", "VerbForm": "Inf"},
    "Vgi-----n--y--": {
        POS: VERB,
        "Polarity": "Pos",
        "Reflex": "Yes",
        "VerbForm": "Inf",
    },
    "Vgi-----y--n--": {POS: VERB, "Polarity": "Neg", "VerbForm": "Inf"},
    "Vgi-----y--y--": {
        POS: VERB,
        "Polarity": "Neg",
        "Reflex": "Yes",
        "VerbForm": "Inf",
    },
    "Vgm-1p--n--nm-": {
        POS: VERB,
        "Mood": "Imp",
        "Number": "Plur",
        "Person": "one",
        "Polarity": "Pos",
        "VerbForm": "Fin",
    },
    "Vgm-1p--n--ns-": {
        POS: VERB,
        "Mood": "Cnd",
        "Number": "Plur",
        "Person": "one",
        "Polarity": "Pos",
        "VerbForm": "Fin",
    },
    "Vgm-1p--n--ym-": {
        POS: VERB,
        "Mood": "Imp",
        "Number": "Plur",
        "Person": "one",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "VerbForm": "Fin",
    },
    "Vgm-1p--y--nm-": {
        POS: VERB,
        "Mood": "Imp",
        "Number": "Plur",
        "Person": "one",
        "Polarity": "Neg",
        "VerbForm": "Fin",
    },
    "Vgm-1p--y--ys-": {
        POS: VERB,
        "Mood": "Cnd",
        "Number": "Plur",
        "Person": "one",
        "Polarity": "Neg",
        "Reflex": "Yes",
        "VerbForm": "Fin",
    },
    "Vgm-1s--n--ns-": {
        POS: VERB,
        "Mood": "Cnd",
        "Number": "Sing",
        "Person": "one",
        "Polarity": "Pos",
        "VerbForm": "Fin",
    },
    "Vgm-1s--n--ys-": {
        POS: VERB,
        "Mood": "Cnd",
        "Number": "Sing",
        "Person": "one",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "VerbForm": "Fin",
    },
    "Vgm-1s--y--ns-": {
        POS: VERB,
        "Mood": "Cnd",
        "Number": "Sing",
        "Person": "one",
        "Polarity": "Neg",
        "VerbForm": "Fin",
    },
    "Vgm-1s--y--ys-": {
        POS: VERB,
        "Mood": "Cnd",
        "Number": "Sing",
        "Person": "one",
        "Polarity": "Neg",
        "Reflex": "Yes",
        "VerbForm": "Fin",
    },
    "Vgm-2p--n--nm-": {
        POS: VERB,
        "Mood": "Imp",
        "Number": "Plur",
        "Person": "two",
        "Polarity": "Pos",
        "VerbForm": "Fin",
    },
    "Vgm-2p--n--ns-": {
        POS: VERB,
        "Mood": "Cnd",
        "Number": "Plur",
        "Person": "two",
        "Polarity": "Pos",
        "VerbForm": "Fin",
    },
    "Vgm-2p--n--ym-": {
        POS: VERB,
        "Mood": "Imp",
        "Number": "Plur",
        "Person": "two",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "VerbForm": "Fin",
    },
    "Vgm-2p--y--nm-": {
        POS: VERB,
        "Mood": "Imp",
        "Number": "Plur",
        "Person": "two",
        "Polarity": "Neg",
        "VerbForm": "Fin",
    },
    "Vgm-2p--y--ym-": {
        POS: VERB,
        "Mood": "Imp",
        "Number": "Plur",
        "Person": "two",
        "Polarity": "Neg",
        "Reflex": "Yes",
        "VerbForm": "Fin",
    },
    "Vgm-2s--n--nm-": {
        POS: VERB,
        "Mood": "Imp",
        "Number": "Sing",
        "Person": "two",
        "Polarity": "Pos",
        "VerbForm": "Fin",
    },
    "Vgm-2s--n--ns-": {
        POS: VERB,
        "Mood": "Cnd",
        "Number": "Sing",
        "Person": "two",
        "Polarity": "Pos",
        "VerbForm": "Fin",
    },
    "Vgm-2s--n--ym-": {
        POS: VERB,
        "Mood": "Imp",
        "Number": "Sing",
        "Person": "two",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "VerbForm": "Fin",
    },
    "Vgm-2s--y--nm-": {
        POS: VERB,
        "Mood": "Imp",
        "Number": "Sing",
        "Person": "two",
        "Polarity": "Neg",
        "VerbForm": "Fin",
    },
    "Vgm-2s--y--ns-": {
        POS: VERB,
        "Mood": "Cnd",
        "Number": "Sing",
        "Person": "two",
        "Polarity": "Neg",
        "VerbForm": "Fin",
    },
    "Vgm-3---n--ns-": {
        POS: VERB,
        "Mood": "Cnd",
        "Person": "three",
        "Polarity": "Pos",
        "VerbForm": "Fin",
    },
    "Vgm-3---n--ys-": {
        POS: VERB,
        "Mood": "Cnd",
        "Person": "three",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "VerbForm": "Fin",
    },
    "Vgm-3---y--ns-": {
        POS: VERB,
        "Mood": "Cnd",
        "Person": "three",
        "Polarity": "Neg",
        "VerbForm": "Fin",
    },
    "Vgm-3---y--ys-": {
        POS: VERB,
        "Mood": "Cnd",
        "Person": "three",
        "Polarity": "Neg",
        "Reflex": "Yes",
        "VerbForm": "Fin",
    },
    "Vgm-3p--n--ns-": {
        POS: VERB,
        "Mood": "Cnd",
        "Number": "Plur",
        "Person": "three",
        "Polarity": "Pos",
        "VerbForm": "Fin",
    },
    "Vgm-3p--n--ys-": {
        POS: VERB,
        "Mood": "Cnd",
        "Number": "Plur",
        "Person": "three",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "VerbForm": "Fin",
    },
    "Vgm-3p--y--ns-": {
        POS: VERB,
        "Mood": "Cnd",
        "Number": "Plur",
        "Person": "three",
        "Polarity": "Neg",
        "VerbForm": "Fin",
    },
    "Vgm-3s--n--ns-": {
        POS: VERB,
        "Mood": "Cnd",
        "Number": "Sing",
        "Person": "three",
        "Polarity": "Pos",
        "VerbForm": "Fin",
    },
    "Vgm-3s--n--ys-": {
        POS: VERB,
        "Mood": "Cnd",
        "Number": "Sing",
        "Person": "three",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "VerbForm": "Fin",
    },
    "Vgm-3s--y--ns-": {
        POS: VERB,
        "Mood": "Cnd",
        "Number": "Sing",
        "Person": "three",
        "Polarity": "Neg",
        "VerbForm": "Fin",
    },
    "Vgm-3s--y--ys-": {
        POS: VERB,
        "Mood": "Cnd",
        "Number": "Sing",
        "Person": "three",
        "Polarity": "Neg",
        "Reflex": "Yes",
        "VerbForm": "Fin",
    },
    "Vgma1p--n--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "one",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgma1p--n--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "one",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgma1p--y--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "one",
        "Polarity": "Neg",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgma1p--y--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "one",
        "Polarity": "Neg",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgma1s--n--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "one",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgma1s--n--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "one",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgma1s--y--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "one",
        "Polarity": "Neg",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgma1s--y--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "one",
        "Polarity": "Neg",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgma2p--n--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "two",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgma2p--n--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "two",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgma2p--y--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "two",
        "Polarity": "Neg",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgma2s--n--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "two",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgma2s--y--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "two",
        "Polarity": "Neg",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgma3---n--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Person": "three",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgma3---n--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Person": "three",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgma3---y--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Person": "three",
        "Polarity": "Neg",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgma3--y--ni-": {
        POS: VERB,
        "Case": "Nom",
        "Person": "three",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgma3p--n--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "three",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgma3p--n--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "three",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgma3p--y--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "three",
        "Polarity": "Neg",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgma3p--y--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "three",
        "Polarity": "Neg",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgma3s--n--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "three",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgma3s--n--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "three",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgma3s--n--yi--": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "three",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgma3s--y--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "three",
        "Polarity": "Neg",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgma3s--y--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "three",
        "Polarity": "Neg",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgmf1p--n--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "one",
        "Polarity": "Pos",
        "Tense": "Fut",
        "VerbForm": "Fin",
    },
    "Vgmf1p--n--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "one",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Fut",
        "VerbForm": "Fin",
    },
    "Vgmf1p--y--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "one",
        "Polarity": "Neg",
        "Tense": "Fut",
        "VerbForm": "Fin",
    },
    "Vgmf1s--n--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "one",
        "Polarity": "Pos",
        "Tense": "Fut",
        "VerbForm": "Fin",
    },
    "Vgmf1s--n--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "one",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Fut",
        "VerbForm": "Fin",
    },
    "Vgmf1s--y--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "one",
        "Polarity": "Neg",
        "Tense": "Fut",
        "VerbForm": "Fin",
    },
    "Vgmf2p--n--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "two",
        "Polarity": "Pos",
        "Tense": "Fut",
        "VerbForm": "Fin",
    },
    "Vgmf2p--n--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "two",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Fut",
        "VerbForm": "Fin",
    },
    "Vgmf2s--n--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "two",
        "Polarity": "Pos",
        "Tense": "Fut",
        "VerbForm": "Fin",
    },
    "Vgmf2s--n--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "two",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Fut",
        "VerbForm": "Fin",
    },
    "Vgmf2s--y--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "two",
        "Polarity": "Neg",
        "Tense": "Fut",
        "VerbForm": "Fin",
    },
    "Vgmf2s--y--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "two",
        "Polarity": "Neg",
        "Reflex": "Yes",
        "Tense": "Fut",
        "VerbForm": "Fin",
    },
    "Vgmf3---n--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Person": "three",
        "Polarity": "Pos",
        "Tense": "Fut",
        "VerbForm": "Fin",
    },
    "Vgmf3---y--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Person": "three",
        "Polarity": "Neg",
        "Tense": "Fut",
        "VerbForm": "Fin",
    },
    "Vgmf3p--n--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "three",
        "Polarity": "Pos",
        "Tense": "Fut",
        "VerbForm": "Fin",
    },
    "Vgmf3p--n--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "three",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Fut",
        "VerbForm": "Fin",
    },
    "Vgmf3p--y--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "three",
        "Polarity": "Neg",
        "Tense": "Fut",
        "VerbForm": "Fin",
    },
    "Vgmf3s--n--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "three",
        "Polarity": "Pos",
        "Tense": "Fut",
        "VerbForm": "Fin",
    },
    "Vgmf3s--n--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "three",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Fut",
        "VerbForm": "Fin",
    },
    "Vgmf3s--y--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "three",
        "Polarity": "Neg",
        "Tense": "Fut",
        "VerbForm": "Fin",
    },
    "Vgmf3s--y--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "three",
        "Polarity": "Neg",
        "Reflex": "Yes",
        "Tense": "Fut",
        "VerbForm": "Fin",
    },
    "Vgmp1p--n--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "one",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp1p--n--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "one",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp1p--y--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "one",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp1p--y--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "one",
        "Polarity": "Neg",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp1s--n--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "one",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp1s--n--ni--": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "one",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp1s--n--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "one",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp1s--y--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "one",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp1s--y--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "one",
        "Polarity": "Neg",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp2p--n--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "two",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp2p--n--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "two",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp2p--y--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "two",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp2p--y--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "two",
        "Polarity": "Neg",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp2s--n--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "two",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp2s--n--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "two",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp2s--y--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "two",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp3---n--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Person": "three",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp3---n--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Person": "three",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp3---y--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Person": "three",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp3---y--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Person": "three",
        "Polarity": "Neg",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp3p--n--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "three",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp3p--n--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "three",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp3p--y--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "three",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp3p--y--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "three",
        "Polarity": "Neg",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp3s--n--ni": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "three",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp3s--n--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "three",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp3s--n--ni--": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "three",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp3s--n--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "three",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp3s--y--ni-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "three",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmp3s--y--yi-": {
        POS: VERB,
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "three",
        "Polarity": "Neg",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "Vgmq1s--n--ni-": {
        POS: VERB,
        "Aspect": "Hab",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "one",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgmq1s--n--yi-": {
        POS: VERB,
        "Aspect": "Hab",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "one",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgmq1s--y--ni-": {
        POS: VERB,
        "Aspect": "Hab",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "one",
        "Polarity": "Neg",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgmq2s--n--ni-": {
        POS: VERB,
        "Aspect": "Hab",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "two",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgmq3---n--ni-": {
        POS: VERB,
        "Aspect": "Hab",
        "Mood": "Ind",
        "Person": "three",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgmq3p--n--ni-": {
        POS: VERB,
        "Aspect": "Hab",
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "three",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgmq3p--n--yi-": {
        POS: VERB,
        "Aspect": "Hab",
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "three",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgmq3s--n--ni-": {
        POS: VERB,
        "Aspect": "Hab",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "three",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgmq3s--n--yi-": {
        POS: VERB,
        "Aspect": "Hab",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "three",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgmq3s--y--ni-": {
        POS: VERB,
        "Aspect": "Hab",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "three",
        "Polarity": "Neg",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgms3s--n--ni-": {
        POS: VERB,
        "Aspect": "Perf",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "three",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "Vgp---nnnn-n-p": {
        POS: VERB,
        "Degree": "Pos",
        "Gender": "Neut",
        "Polarity": "Pos",
        "VerbForm": "Part",
    },
    "Vgp---nnyn-n-p": {
        POS: VERB,
        "Degree": "Pos",
        "Gender": "Neut",
        "Polarity": "Neg",
        "VerbForm": "Part",
    },
    "Vgp--pfnnnnn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "VerbForm": "Part",
    },
    "Vgp--sfnnnnn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "VerbForm": "Part",
    },
    "Vgp--smnnnvn-p": {
        POS: VERB,
        "Case": "Voc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "VerbForm": "Part",
    },
    "Vgp--smnynnn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Neg",
        "VerbForm": "Part",
    },
    "Vgpa--nann-n-p": {
        POS: VERB,
        "Degree": "Pos",
        "Gender": "Neut",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa--nann-y-p": {
        POS: VERB,
        "Degree": "Pos",
        "Gender": "Neut",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa--nayn-n-p": {
        POS: VERB,
        "Degree": "Pos",
        "Gender": "Neut",
        "Polarity": "Neg",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-pfannan-p": {
        POS: VERB,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-pfannay-p": {
        POS: VERB,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-pfanngn-p": {
        POS: VERB,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-pfannin-p": {
        POS: VERB,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-pfannnn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-pfannny-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-pmannan-p": {
        POS: VERB,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-pmanndn-p": {
        POS: VERB,
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-pmanngn-p": {
        POS: VERB,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-pmannin-p": {
        POS: VERB,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-pmannnn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-pmannny-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-pmanygn-p": {
        POS: VERB,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-pmaynny-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Neg",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-pmpnnnn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpa-sfannan-p": {
        POS: VERB,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-sfannay-p": {
        POS: VERB,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-sfanndn-p": {
        POS: VERB,
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-sfanngn-p": {
        POS: VERB,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-sfanngy-p": {
        POS: VERB,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-sfannin-p": {
        POS: VERB,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-sfannnn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-sfannny-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-sfannny-p-": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-sfanynn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-sfaynnn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Neg",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-smannan-p": {
        POS: VERB,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-smannay-p": {
        POS: VERB,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-smanngn-p": {
        POS: VERB,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-smanngy-p": {
        POS: VERB,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-smannin-p": {
        POS: VERB,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-smanniy-p": {
        POS: VERB,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-smannln-p": {
        POS: VERB,
        "Case": "Loc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-smannnn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-smannny-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-smanygn-p": {
        POS: VERB,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-smanyin-p": {
        POS: VERB,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-smanynn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpa-smaynnn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Neg",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpf-smannln-p": {
        POS: VERB,
        "Case": "Loc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Fut",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpf-smpnnan-p": {
        POS: VERB,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Fut",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpf-smpnndn-p": {
        POS: VERB,
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Fut",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp--fpnn-n-p": {
        POS: VERB,
        "Degree": "Pos",
        "Gender": "Fem",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp--npnn-n-p": {
        POS: VERB,
        "Degree": "Pos",
        "Gender": "Neut",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp--npnn-y-p": {
        POS: VERB,
        "Degree": "Pos",
        "Gender": "Neut",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp--npyn-n-p": {
        POS: VERB,
        "Degree": "Pos",
        "Gender": "Neut",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp--npyn-y-p": {
        POS: VERB,
        "Degree": "Pos",
        "Gender": "Neut",
        "Polarity": "Neg",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-pfannan-p": {
        POS: VERB,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-pfanndn-p": {
        POS: VERB,
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-pfanngn-p": {
        POS: VERB,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-pfanngy-p": {
        POS: VERB,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-pfannin-p": {
        POS: VERB,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-pfannnn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-pfannny-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-pfpnnan-p": {
        POS: VERB,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-pfpnndn-p": {
        POS: VERB,
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-pfpnngn-p": {
        POS: VERB,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-pfpnnin-p": {
        POS: VERB,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-pfpnnln-p": {
        POS: VERB,
        "Case": "Loc",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-pfpnnnn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-pfpnnny-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-pfpnygn-p": {
        POS: VERB,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-pfpnyin-p": {
        POS: VERB,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-pfpynan-p": {
        POS: VERB,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-pfpyngn-p": {
        POS: VERB,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-pfpynin-p": {
        POS: VERB,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-pfpynnn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-pmannan-p": {
        POS: VERB,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-pmannay-p": {
        POS: VERB,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-pmanndn-p": {
        POS: VERB,
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-pmanngn-p": {
        POS: VERB,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-pmanngy-p": {
        POS: VERB,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-pmannin-p": {
        POS: VERB,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-pmannln-p": {
        POS: VERB,
        "Case": "Loc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-pmannnn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-pmannny-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-pmanyan-p": {
        POS: VERB,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-pmayndn-p": {
        POS: VERB,
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-pmaynin-p": {
        POS: VERB,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-pmaynnn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-pmpnnan-p": {
        POS: VERB,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-pmpnndn-p": {
        POS: VERB,
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-pmpnngn-p": {
        POS: VERB,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-pmpnnin-p": {
        POS: VERB,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-pmpnniy-p": {
        POS: VERB,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-pmpnnnn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-pmpnygn-p": {
        POS: VERB,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-pmpnyin-p": {
        POS: VERB,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-pmpynan-p": {
        POS: VERB,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-pmpyngn-p": {
        POS: VERB,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-pmpynnn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-pmpyygn-p": {
        POS: VERB,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-sfannan-p": {
        POS: VERB,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-sfannay-p": {
        POS: VERB,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-sfanndn-p": {
        POS: VERB,
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-sfanndn-p-": {
        POS: VERB,
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-sfanngn-p": {
        POS: VERB,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-sfanngy-p": {
        POS: VERB,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-sfannin-p": {
        POS: VERB,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-sfannln-p": {
        POS: VERB,
        "Case": "Loc",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-sfannnn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-sfanyny-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-sfaynin-p": {
        POS: VERB,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-sfaynnn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-sfpnnan-p": {
        POS: VERB,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-sfpnndn-p": {
        POS: VERB,
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-sfpnngn-p": {
        POS: VERB,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-sfpnnin-p": {
        POS: VERB,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-sfpnnln-p": {
        POS: VERB,
        "Case": "Loc",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-sfpnnnn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-sfpnyan-p": {
        POS: VERB,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-sfpnygn-p": {
        POS: VERB,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-sfpnyin-p": {
        POS: VERB,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-sfpnynn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-sfpyngn-p": {
        POS: VERB,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-sfpynnn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-smannan-p": {
        POS: VERB,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-smanndy-p": {
        POS: VERB,
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-smanngn-p": {
        POS: VERB,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-smannin-p": {
        POS: VERB,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-smannln-p": {
        POS: VERB,
        "Case": "Loc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-smannly-p": {
        POS: VERB,
        "Case": "Loc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-smannnn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-smaynin-p": {
        POS: VERB,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-smaynnn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-smaynny-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Neg",
        "Reflex": "Yes",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Act",
    },
    "Vgpp-smpnnan-p": {
        POS: VERB,
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-smpnndn-p": {
        POS: VERB,
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-smpnngn-p": {
        POS: VERB,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-smpnnin-p": {
        POS: VERB,
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-smpnnnn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-smpnygn-p": {
        POS: VERB,
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-smpnynn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgpp-smpynnn-p": {
        POS: VERB,
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Neg",
        "Tense": "Pres",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps--mpnngn-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Masc",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps--npnn-n-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Degree": "Pos",
        "Gender": "Neut",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps--npnn-y-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Degree": "Pos",
        "Gender": "Neut",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps--npyn-n-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Degree": "Pos",
        "Gender": "Neut",
        "Polarity": "Neg",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-pfpnnan-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-pfpnndn-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-pfpnngn-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-pfpnnin-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-pfpnnln-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Loc",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-pfpnnnn-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-pmpnnan-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-pmpnnay-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-pmpnndn-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-pmpnngn-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-pmpnnin-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-pmpnnln-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Loc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-pmpnnnn-": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-pmpnnnn-n": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-pmpnnnn-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-pmpnygn-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-pmpnynn-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-pmpynin-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Neg",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-pmpynnn-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Neg",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-pmsnnnn-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Plur",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
    },
    "Vgps-sfpnnan-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-sfpnndn-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-sfpnngn-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-sfpnnin-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-sfpnnln-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Loc",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-sfpnnnn-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-sfpynan-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Neg",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-sfpyngn-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Neg",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-sfpynnn-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
        "Polarity": "Neg",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-smpnnan-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-smpnnay-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-smpnndn-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-smpnngn-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-smpnnin-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Ins",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-smpnnln-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Loc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-smpnnnn-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-smpnnny-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Reflex": "Yes",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-smpnynn-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-smpynan-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Neg",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-smpyngn-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Neg",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-smpynnn-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
        "Polarity": "Neg",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "Vgps-snpnn-n-p": {
        POS: VERB,
        "Aspect": "Perf",
        "Degree": "Pos",
        "Gender": "Neut",
        "Number": "Sing",
        "Polarity": "Pos",
        "Tense": "Past",
        "VerbForm": "Part",
        "Voice": "Pass",
    },
    "X-": {POS: X},
    "Xf": {POS: X, "Foreign": "Yes"},
    "Xh": {POS: SYM},
    "Ya": {POS: X, "Abbr": "Yes"},
    "Ys": {POS: X, "Abbr": "Yes"},
    "Z": {POS: PUNCT},
}
