# coding: utf8
from __future__ import unicode_literals

from ...symbols import POS, PUNCT, SYM, ADJ, NUM, DET, ADV, ADP, X, VERB, CCONJ
from ...symbols import NOUN, PROPN, PART, INTJ, SPACE, PRON, SCONJ, AUX


TAG_MAP = {
    "<-sam>|<Eg>|DET|F|P|@P<": {POS: PRON},
    "<-sam>|<Eg>|DET|M|P|@P<": {POS: PRON},
    "<-sam>|<artd>|ART|@>A": {POS: DET},
    "<-sam>|<artd>|ART|@>N": {POS: DET},
    "<-sam>|<artd>|ART|F|P|@>N": {POS: DET},
    "<-sam>|<artd>|ART|F|S|@>N": {POS: DET},
    "<-sam>|<artd>|ART|F|S|@P<": {POS: DET},
    "<-sam>|<artd>|ART|M|P|@>A": {POS: DET},
    "<-sam>|<artd>|ART|M|P|@>N": {POS: DET},
    "<-sam>|<artd>|ART|M|S|@<SUBJ": {POS: DET},
    "<-sam>|<artd>|ART|M|S|@>A": {POS: DET},
    "<-sam>|<artd>|ART|M|S|@>N": {POS: DET},
    "<-sam>|<artd>|ART|M|S|@N<": {POS: DET},
    "<-sam>|<artd>|ART|M|S|@P<": {POS: DET},
    "<-sam>|<artd>|DET|F|P|@>N": {POS: DET},
    "<-sam>|<artd>|DET|F|S|@>N": {POS: DET},
    "<-sam>|<artd>|DET|M|P|@>N": {POS: DET},
    "<-sam>|<artd>|DET|M|S/P|@>N": {POS: DET},
    "<-sam>|<artd>|DET|M|S|@>N": {POS: DET},
    "<-sam>|<artd>|DET|M|S|@P<": {POS: PRON},
    "<-sam>|<arti>|ART|F|S|@>N": {POS: DET},
    "<-sam>|<arti>|ART|M|S|@>N": {POS: DET},
    "<-sam>|<arti>|DET|F|S|@>N": {POS: DET},
    "<-sam>|<arti>|DET|M|S|@>N": {POS: DET},
    "<-sam>|<card>|NUM|M|S|@P<": {POS: NUM},
    "<-sam>|<dem>|<np-idf>|DET|M|S|@P<": {POS: PRON},
    "<-sam>|<dem>|DET|F|P|@>N": {POS: DET},
    "<-sam>|<dem>|DET|F|P|@P<": {POS: PRON},
    "<-sam>|<dem>|DET|F|S|@>N": {POS: DET},
    "<-sam>|<dem>|DET|F|S|@P<": {POS: PRON},
    "<-sam>|<dem>|DET|F|S|@SUBJ>": {POS: PRON},
    "<-sam>|<dem>|DET|M|P|@>N": {POS: DET},
    "<-sam>|<dem>|DET|M|P|@P<": {POS: PRON},
    "<-sam>|<dem>|DET|M|S|@>N": {POS: DET},
    "<-sam>|<dem>|DET|M|S|@P<": {POS: PRON},
    "<-sam>|<dem>|INDP|M|S|@P<": {POS: PRON},
    "<-sam>|<diff>|DET|F|P|@>N": {POS: DET},
    "<-sam>|<diff>|DET|F|P|@P<": {POS: PRON},
    "<-sam>|<diff>|DET|F|S|@>N": {POS: DET},
    "<-sam>|<diff>|DET|M|P|@>N": {POS: DET},
    "<-sam>|<diff>|DET|M|S|@>N": {POS: DET},
    "<-sam>|<diff>|DET|M|S|@P<": {POS: PRON},
    "<-sam>|<quant>|DET|F|P|@>N": {POS: DET},
    "<-sam>|<quant>|DET|F|P|@P<": {POS: PRON},
    "<-sam>|<quant>|DET|M|P|@>N": {POS: DET},
    "<-sam>|<refl>|PERS|F|3S|PIV|@P<": {POS: PRON},
    "<-sam>|<refl>|PERS|M|3S|PIV|@P<": {POS: PRON},
    "<-sam>|<rel>|INDP|M|P|@SUBJ>": {POS: PRON},
    "<-sam>|<rel>|INDP|M|S|@P<": {POS: PRON},
    "<-sam>|ADV|@ADVL>": {POS: ADV},
    "<-sam>|ADV|@P<": {POS: ADV},
    "<-sam>|ART|@>N": {POS: DET},
    "<-sam>|ART|F|P|@>N": {POS: DET},
    "<-sam>|ART|F|S|@>N": {POS: DET},
    "<-sam>|ART|M|P|@>N": {POS: DET},
    "<-sam>|ART|M|S|@>N": {POS: DET},
    "<-sam>|DET|@>N": {POS: DET},
    "<-sam>|DET|F|P|@P<": {POS: PRON},
    "<-sam>|DET|F|S|@>N": {POS: DET},
    "<-sam>|DET|F|S|@P<": {POS: PRON},
    "<-sam>|DET|M|P|@P<": {POS: PRON},
    "<-sam>|DET|M|S|@>A": {POS: DET},
    "<-sam>|DET|M|S|@>N": {POS: DET},
    "<-sam>|DET|M|S|@P<": {POS: PRON},
    "<-sam>|INDP|M|S|@P<": {POS: PRON},
    "<-sam>|INDP|M|S|@SUBJ>": {POS: PRON},
    "<-sam>|PERS|F|1P|PIV|@P<": {POS: PRON},
    "<-sam>|PERS|F|1S|PIV|@P<": {POS: PRON},
    "<-sam>|PERS|F|3P|NOM/PIV|@P<": {POS: PRON},
    "<-sam>|PERS|F|3P|NOM|@P<": {POS: PRON},
    "<-sam>|PERS|F|3P|PIV|@P<": {POS: PRON},
    "<-sam>|PERS|F|3S|ACC|@ACC>": {POS: PRON},
    "<-sam>|PERS|F|3S|NOM/PIV|@P<": {POS: PRON},
    "<-sam>|PERS|F|3S|NOM|@SUBJ>": {POS: PRON},
    "<-sam>|PERS|F|3S|PIV|@P<": {POS: PRON},
    "<-sam>|PERS|M/F|2P|PIV|@P<": {POS: PRON},
    "<-sam>|PERS|M|3P|NOM/PIV|@P<": {POS: PRON},
    "<-sam>|PERS|M|3P|NOM|@P<": {POS: PRON},
    "<-sam>|PERS|M|3P|PIV|@P<": {POS: PRON},
    "<-sam>|PERS|M|3S|ACC|@NPHR": {POS: PRON},
    "<-sam>|PERS|M|3S|NOM/PIV|@P<": {POS: PRON},
    "<-sam>|PERS|M|3S|NOM|@P<": {POS: PRON},
    "<-sam>|PERS|M|3S|NOM|@SUBJ>": {POS: PRON},
    "<-sam>|PERS|M|3S|PIV|@P<": {POS: PRON},
    "<-sam>|PRP|@N<": {POS: ADP},
    "<COMP>|ADJ|F|P|@<OC": {POS: ADJ},
    "<COMP>|ADJ|F|P|@<SC": {POS: ADJ},
    "<COMP>|ADJ|F|P|@>N": {POS: ADJ},
    "<COMP>|ADJ|F|P|@N<": {POS: ADJ},
    "<COMP>|ADJ|F|P|@P<": {POS: ADJ},
    "<COMP>|ADJ|F|S|@<OC": {POS: ADJ},
    "<COMP>|ADJ|F|S|@<SC": {POS: ADJ},
    "<COMP>|ADJ|F|S|@>N": {POS: ADJ},
    "<COMP>|ADJ|F|S|@N<": {POS: ADJ},
    "<COMP>|ADJ|F|S|@N<PRED": {POS: ADJ},
    "<COMP>|ADJ|F|S|@P<": {POS: ADJ},
    "<COMP>|ADJ|F|S|@SC>": {POS: ADJ},
    "<COMP>|ADJ|M/F|S|@<ACC": {POS: ADJ},
    "<COMP>|ADJ|M|P|@<SC": {POS: ADJ},
    "<COMP>|ADJ|M|P|@>N": {POS: ADJ},
    "<COMP>|ADJ|M|P|@ADVL>": {POS: ADJ},
    "<COMP>|ADJ|M|P|@N<": {POS: ADJ},
    "<COMP>|ADJ|M|S|@<ADVL": {POS: ADJ},
    "<COMP>|ADJ|M|S|@<OC": {POS: ADJ},
    "<COMP>|ADJ|M|S|@<SC": {POS: ADJ},
    "<COMP>|ADJ|M|S|@>A": {POS: ADJ},
    "<COMP>|ADJ|M|S|@>N": {POS: ADJ},
    "<COMP>|ADJ|M|S|@ADVL>": {POS: ADJ},
    "<COMP>|ADJ|M|S|@AS<": {POS: ADJ},
    "<COMP>|ADJ|M|S|@N<": {POS: ADJ},
    "<COMP>|ADJ|M|S|@P<": {POS: ADJ},
    "<COMP>|ADJ|M|S|@SC>": {POS: ADJ},
    "<E>|<sam->|PRP|@<ADVL": {POS: ADP},
    "<Eg>|<COMP>|ADJ|M|P|@N<": {POS: ADJ},
    "<Eg>|<dem>|DET|F|S|@P<": {POS: PRON},
    "<Eg>|<dem>|DET|M|P|@P<": {POS: PRON},
    "<Eg>|<first-cjt>|N|F|S|@SUBJ>": {POS: NOUN},
    "<Eg>|<n>|<np-def>|ADJ|F|S|@P<": {POS: ADJ},
    "<Eg>|<np-def>|N|M|P|@<ACC": {POS: SYM},
    "<Eg>|<np-idf>|N|F|P|@<ACC": {POS: NOUN},
    "<Eg>|ADV|@ICL-N<": {POS: ADV},
    "<Eg>|ADV|@N<PRED": {POS: ADV},
    "<Es>|ADV|@<ACC": {POS: ADV},
    "<Es>|ADV|@<ADVL": {POS: ADV},
    "<Es>|ADV|@>A": {POS: ADV},
    "<Es>|ADV|@ADVL>": {POS: ADV},
    "<Es>|ADV|@P<": {POS: ADV},
    "<KOMP>|<COMP>|ADJ|F|P|@<SC": {POS: ADJ},
    "<KOMP>|<COMP>|ADJ|F|P|@>N": {POS: ADJ},
    "<KOMP>|<COMP>|ADJ|F|P|@N<": {POS: ADJ},
    "<KOMP>|<COMP>|ADJ|F|S|@<SC": {POS: ADJ},
    "<KOMP>|<COMP>|ADJ|F|S|@>N": {POS: ADJ},
    "<KOMP>|<COMP>|ADJ|F|S|@N<": {POS: ADJ},
    "<KOMP>|<COMP>|ADJ|F|S|@N<PRED": {POS: ADJ},
    "<KOMP>|<COMP>|ADJ|F|S|@SC>": {POS: ADJ},
    "<KOMP>|<COMP>|ADJ|M/F|S|@<ACC": {POS: ADJ},
    "<KOMP>|<COMP>|ADJ|M/F|S|@<SC": {POS: ADJ},
    "<KOMP>|<COMP>|ADJ|M|P|@<OC": {POS: ADJ},
    "<KOMP>|<COMP>|ADJ|M|P|@<SC": {POS: ADJ},
    "<KOMP>|<COMP>|ADJ|M|P|@>N": {POS: ADJ},
    "<KOMP>|<COMP>|ADJ|M|P|@N<": {POS: ADJ},
    "<KOMP>|<COMP>|ADJ|M|P|@N<PRED": {POS: ADJ},
    "<KOMP>|<COMP>|ADJ|M|P|@P<": {POS: ADJ},
    "<KOMP>|<COMP>|ADJ|M|S|@<ADVL": {POS: ADJ},
    "<KOMP>|<COMP>|ADJ|M|S|@<OC": {POS: ADJ},
    "<KOMP>|<COMP>|ADJ|M|S|@<SC": {POS: ADJ},
    "<KOMP>|<COMP>|ADJ|M|S|@>N": {POS: ADJ},
    "<KOMP>|<COMP>|ADJ|M|S|@N<": {POS: ADJ},
    "<KOMP>|<COMP>|ADJ|M|S|@N<PRED": {POS: ADJ},
    "<KOMP>|<COMP>|ADJ|M|S|@P<": {POS: ADJ},
    "<KOMP>|<COMP>|ADJ|M|S|@PRED>": {POS: ADJ},
    "<KOMP>|<COMP>|ADJ|M|S|@SC>": {POS: ADJ},
    "<KOMP>|<COMP>|ADV|@<ADVL": {POS: ADV},
    "<KOMP>|<COMP>|ADV|@>N": {POS: ADV},
    "<KOMP>|<COMP>|ADV|@ADVL>": {POS: ADV},
    "<KOMP>|<SUP>|<COMP>|ADJ|F|P|@>N": {POS: ADJ},
    "<KOMP>|<SUP>|<COMP>|ADJ|F|S|@>N": {POS: ADJ},
    "<KOMP>|<SUP>|<COMP>|ADJ|F|S|@N<": {POS: ADJ},
    "<KOMP>|<SUP>|<COMP>|ADJ|M|P|@<SC": {POS: ADJ},
    "<KOMP>|<SUP>|<COMP>|ADJ|M|P|@>N": {POS: ADJ},
    "<KOMP>|<SUP>|<COMP>|ADJ|M|S|@<SC": {POS: ADJ},
    "<KOMP>|<SUP>|<COMP>|ADJ|M|S|@>N": {POS: ADJ},
    "<KOMP>|<SUP>|<COMP>|ADJ|M|S|@N<": {POS: ADJ},
    "<KOMP>|<SUP>|<COMP>|ADJ|M|S|@SC>": {POS: ADJ},
    "<KOMP>|<SUP>|<COMP>|ADV|@<ADVL": {POS: ADV},
    "<KOMP>|<SUP>|<COMP>|ADV|@ADVL>": {POS: ADV},
    "<KOMP>|<SUP>|<n>|<np-def>|<COMP>|ADJ|M|S|@<SC": {POS: ADJ},
    "<KOMP>|<SUP>|<n>|<np-def>|<COMP>|ADJ|M|S|@SC>": {POS: ADJ},
    "<KOMP>|<diff>|<np-def>|DET|M|P|@P<": {POS: PRON},
    "<KOMP>|<diff>|DET|F|P|@P<": {POS: PRON},
    "<KOMP>|<diff>|DET|F|S|@P<": {POS: PRON},
    "<KOMP>|<diff>|DET|M|S|@>N": {POS: DET},
    "<KOMP>|<diff>|DET|M|S|@P<": {POS: PRON},
    "<KOMP>|<first-cjt>|<COMP>|ADJ|F|S|@>N": {POS: ADJ},
    "<KOMP>|<first-cjt>|<COMP>|ADJ|F|S|@N<": {POS: ADJ},
    "<KOMP>|<n>|<COMP>|ADJ|F|S|@<SC": {POS: ADJ},
    "<KOMP>|<n>|<COMP>|ADJ|M/F|P|@P<": {POS: ADJ},
    "<KOMP>|<n>|<np-def>|<COMP>|ADJ|F|S|@P<": {POS: ADJ},
    "<KOMP>|<quant>|<np-def>|DET|M|S|@P<": {POS: PRON},
    "<KOMP>|<quant>|ADV|@<ADVL": {POS: ADV},
    "<KOMP>|<quant>|ADV|@>A": {POS: ADV},
    "<KOMP>|<quant>|ADV|@>P": {POS: ADV},
    "<KOMP>|<quant>|ADV|@ADVL>": {POS: ADV},
    "<KOMP>|<quant>|ADV|@P<": {POS: ADV},
    "<KOMP>|<quant>|DET|F|P|@>N": {POS: DET},
    "<KOMP>|<quant>|DET|M|S|@<ACC": {POS: PRON},
    "<NUM-fract>|<np-def>|N|M|P|@P<": {POS: NOUN},
    "<NUM-ord>|<Eg>|<n>|<np-def>|ADJ|@SUBJ>": {POS: ADJ},
    "<NUM-ord>|<Eg>|<n>|<np-def>|ADJ|M|S|@<SC": {POS: ADJ},
    "<NUM-ord>|<cjt>|ADJ|F|S|@>N": {POS: ADJ},
    "<NUM-ord>|<first-cjt>|ADJ|F|S|@>N": {POS: ADJ},
    "<NUM-ord>|<first-cjt>|ADJ|M|S|@>N": {POS: ADJ},
    "<NUM-ord>|<first-cjt>|ADJ|M|S|@N<": {POS: ADJ},
    "<NUM-ord>|<n>|<np-def>|ADJ|F|P|@<SUBJ": {POS: ADJ},
    "<NUM-ord>|<n>|<np-def>|ADJ|F|S|@<SC": {POS: ADJ},
    "<NUM-ord>|<n>|<np-def>|ADJ|F|S|@APP": {POS: ADJ},
    "<NUM-ord>|<n>|<np-def>|ADJ|F|S|@P<": {POS: ADJ},
    "<NUM-ord>|<n>|<np-def>|ADJ|F|S|@SUBJ>": {POS: ADJ},
    "<NUM-ord>|<n>|<np-def>|ADJ|M|P|@<SC": {POS: ADJ},
    "<NUM-ord>|<n>|<np-def>|ADJ|M|P|@P<": {POS: ADJ},
    "<NUM-ord>|<n>|<np-def>|ADJ|M|P|@SUBJ>": {POS: ADJ},
    "<NUM-ord>|<n>|<np-def>|ADJ|M|S|@<ACC": {POS: ADJ},
    "<NUM-ord>|<n>|<np-def>|ADJ|M|S|@<SC": {POS: ADJ},
    "<NUM-ord>|<n>|<np-def>|ADJ|M|S|@SUBJ>": {POS: ADJ},
    "<NUM-ord>|<n>|ADJ|F|S|@>N": {POS: ADJ},
    "<NUM-ord>|<n>|ADJ|M|P|@>N": {POS: ADJ},
    "<NUM-ord>|<n>|ADJ|M|S|@P<": {POS: ADJ},
    "<NUM-ord>|<np-def>|ADJ|F|S|@N<PRED": {POS: ADJ},
    "<NUM-ord>|ADJ|@A<": {POS: ADJ},
    "<NUM-ord>|ADJ|F|P|@>N": {POS: ADJ},
    "<NUM-ord>|ADJ|F|P|@N<": {POS: ADJ},
    "<NUM-ord>|ADJ|F|S|@>N": {POS: ADJ},
    "<NUM-ord>|ADJ|F|S|@N<": {POS: ADJ},
    "<NUM-ord>|ADJ|F|S|@N<PRED": {POS: ADJ},
    "<NUM-ord>|ADJ|M|P|@>N": {POS: ADJ},
    "<NUM-ord>|ADJ|M|P|@SUBJ>": {POS: ADJ},
    "<NUM-ord>|ADJ|M|S|@<ADVL": {POS: ADJ},
    "<NUM-ord>|ADJ|M|S|@>N": {POS: ADJ},
    "<NUM-ord>|ADJ|M|S|@ADVL>": {POS: ADJ},
    "<NUM-ord>|ADJ|M|S|@N<": {POS: ADJ},
    "<NUM-ord>|ADJ|M|S|@P<": {POS: ADJ},
    "<SUP>|<KOMP>|<COMP>|ADJ|F|P|@<SC": {POS: ADJ},
    "<SUP>|<KOMP>|<COMP>|ADJ|F|P|@>N": {POS: ADJ},
    "<SUP>|<KOMP>|<COMP>|ADJ|F|S|@<SC": {POS: ADJ},
    "<SUP>|<KOMP>|<COMP>|ADJ|F|S|@>N": {POS: ADJ},
    "<SUP>|<KOMP>|<COMP>|ADJ|F|S|@N<": {POS: ADJ},
    "<SUP>|<KOMP>|<COMP>|ADJ|M/F|S|@<SC": {POS: ADJ},
    "<SUP>|<KOMP>|<COMP>|ADJ|M|P|@>N": {POS: ADJ},
    "<SUP>|<KOMP>|<COMP>|ADJ|M|S|@>N": {POS: ADJ},
    "<SUP>|<KOMP>|<COMP>|ADJ|M|S|@N<": {POS: ADJ},
    "<SUP>|<KOMP>|<n>|<np-def>|<COMP>|ADJ|M|S|@P<": {POS: ADJ},
    "<SUP>|<KOMP>|<n>|<np-def>|ADJ|M|S|@P<": {POS: ADJ},
    "<SUP>|<n>|<np-def>|ADJ|M|S|@P<": {POS: ADJ},
    "<SUP>|ADJ|F|P|@>N": {POS: ADJ},
    "<SUP>|ADJ|F|P|@N<": {POS: ADJ},
    "<SUP>|ADJ|F|S|@>N": {POS: ADJ},
    "<SUP>|ADJ|F|S|@N<": {POS: ADJ},
    "<SUP>|ADJ|M|P|@>N": {POS: ADJ},
    "<SUP>|ADJ|M|P|@N<": {POS: ADJ},
    "<SUP>|ADJ|M|S|@<SC": {POS: ADJ},
    "<SUP>|ADJ|M|S|@>N": {POS: ADJ},
    "<SUP>|ADJ|M|S|@N<": {POS: ADJ},
    "<adv>|ADJ|M|S|@<ADVL": {POS: ADJ},
    "<artd>|<-sam>|ART|@>N": {POS: DET},
    "<artd>|<-sam>|ART|F|P|@>A": {POS: DET},
    "<artd>|<-sam>|ART|F|P|@>N": {POS: DET},
    "<artd>|<-sam>|ART|F|S|@>N": {POS: DET},
    "<artd>|<-sam>|ART|M|P|@>N": {POS: DET},
    "<artd>|<-sam>|ART|M|S|@>N": {POS: DET},
    "<artd>|<-sam>|DET|F|P|@>N": {POS: DET},
    "<artd>|<-sam>|DET|F|P|@P<": {POS: PRON},
    "<artd>|<-sam>|DET|F|S|@>N": {POS: DET},
    "<artd>|<-sam>|DET|M|P|@>N": {POS: DET},
    "<artd>|<-sam>|DET|M|S|@>N": {POS: DET},
    "<artd>|<Eg>|ART|M|S|@SC>": {POS: DET},
    "<artd>|<nil>|ART|F|S|@>N": {POS: DET},
    "<artd>|<np-idf>|ART|<UPOS:NOUN>|<UF:Definite=Def>|N|S|@>N": {POS: DET},
    "<artd>|<np-idf>|DET|M|S|@SUBJ>": {POS: PRON},
    "<artd>|ART|@>N": {POS: DET},
    "<artd>|ART|F|P|@>N": {POS: DET},
    "<artd>|ART|F|S|@<ACC": {POS: DET},
    "<artd>|ART|F|S|@<SC": {POS: DET},
    "<artd>|ART|F|S|@>A": {POS: DET},
    "<artd>|ART|F|S|@>N": {POS: DET},
    "<artd>|ART|F|S|@SUBJ>": {POS: DET},
    "<artd>|ART|M|P|@>A": {POS: DET},
    "<artd>|ART|M|P|@>N": {POS: DET},
    "<artd>|ART|M|P|@P<": {POS: DET},
    "<artd>|ART|M|S|@>A": {POS: DET},
    "<artd>|ART|M|S|@>N": {POS: DET},
    "<artd>|ART|M|S|@KOMP<": {POS: DET},
    "<artd>|DET|F|P|@>N": {POS: DET},
    "<artd>|DET|F|P|@A<": {POS: DET},
    "<artd>|DET|F|S|@<PIV": {POS: PRON},
    "<artd>|DET|F|S|@>N": {POS: DET},
    "<artd>|DET|F|S|@A<": {POS: DET},
    "<artd>|DET|M|P|@<ACC": {POS: PRON},
    "<artd>|DET|M|P|@>N": {POS: DET},
    "<artd>|DET|M|P|@A<": {POS: DET},
    "<artd>|DET|M|P|@SUBJ>": {POS: PRON},
    "<artd>|DET|M|S|@<SC": {POS: PRON},
    "<artd>|DET|M|S|@>N": {POS: DET},
    "<artd>|DET|M|S|@A<": {POS: DET},
    "<artd>|DET|M|S|@P<": {POS: PRON},
    "<artd>|DET|M|S|@SUBJ>": {POS: PRON},
    "<artd>|INDP|F|S|@>N": {POS: PRON},
    "<artd>|INDP|M|S|@ACC>": {POS: PRON},
    "<artd>|INDP|M|S|@P<": {POS: PRON},
    "<arti>|<-sam>|ART|M|S|@>N": {POS: DET},
    "<arti>|<nil>|ART|F|S|@>N": {POS: DET},
    "<arti>|ART|F|S|@>N": {POS: DET},
    "<arti>|ART|M|S|@>N": {POS: DET},
    "<arti>|DET|F|S@>N": {POS: DET},
    "<arti>|DET|F|S|@>N": {POS: DET},
    "<arti>|DET|M|S|@>N": {POS: DET},
    "<atemp>|ADV|@<ADVL": {POS: ADV},
    "<atemp>|ADV|@A<": {POS: ADV},
    "<atemp>|ADV|@ADVL>": {POS: ADV},
    "<aux>|<cjt>|<first-cjt>|V|INF|@ICL-AUX<": {POS: AUX},
    "<aux>|<cjt>|<first-cjt>|V|PCP|@ICL-AUX<": {POS: AUX},
    "<aux>|<cjt>|<first-cjt>|V|PS|1S|IND|@FS-N<": {POS: AUX},
    "<aux>|<cjt>|<hyphen>|V|PR|3S|IND|@FS-<ADVL": {POS: AUX},
    "<aux>|<cjt>|<hyphen>|V|PR|3S|IND|@FS-STA": {POS: AUX},
    "<aux>|<cjt>|<n>|V|PCP|F|S|@ICL-N<PRED": {POS: AUX},
    "<aux>|<cjt>|V|COND|3S|@FS-N<": {POS: AUX},
    "<aux>|<cjt>|V|INF|@ICL-AUX<": {POS: AUX},
    "<aux>|<cjt>|V|PCP|@ICL-AUX<": {POS: AUX},
    "<aux>|<cjt>|V|PCP|M|S|@ICL-AUX<": {POS: AUX},
    "<aux>|<cjt>|V|PR|3P|IND|@FS-N<": {POS: AUX},
    "<aux>|<cjt>|V|PR|3S|IND|@FS-N<": {POS: AUX},
    "<aux>|<first-cjt>|<cjt>|V|PS|3S|IND|@FS-STA": {POS: AUX},
    "<aux>|<first-cjt>|<hyphen>|<se-passive>|V|INF|@ICL-AUX<": {POS: AUX},
    "<aux>|<first-cjt>|<hyphen>|V|GER|@ICL-ADVL>": {POS: AUX},
    "<aux>|<first-cjt>|V|INF|@ICL-AUX<": {POS: AUX},
    "<aux>|<first-cjt>|V|PCP|@ICL-AUX<": {POS: AUX},
    "<aux>|<first-cjt>|V|PCP|F|P|@ICL-AUX<": {POS: AUX},
    "<aux>|<first-cjt>|V|PCP|F|S|@ICL-AUX<": {POS: AUX},
    "<aux>|<first-cjt>|V|PCP|M|P|@ICL-AUX<": {POS: AUX},
    "<aux>|<first-cjt>|V|PCP|M|S|@ICL-AUX<": {POS: AUX},
    "<aux>|<first-cjt>|V|PR|3S|IND|@FS-N<": {POS: AUX},
    "<aux>|<hyphen>|V|FUT|3S|IND|@FS-QUE": {POS: AUX},
    "<aux>|<hyphen>|V|FUT|3S|IND|@FS-STA": {POS: AUX},
    "<aux>|<hyphen>|V|IMPF|3S|IND|@FS-STA": {POS: AUX},
    "<aux>|<hyphen>|V|INF|@ICL-AUX<": {POS: AUX},
    "<aux>|<hyphen>|V|INF|@ICL-P<": {POS: AUX},
    "<aux>|<hyphen>|V|PR|3S|IND|@FS-ACC>": {POS: AUX},
    "<aux>|<hyphen>|V|PR|3S|IND|@FS-STA": {POS: AUX},
    "<aux>|<hyphen>|V|PS|3S|IND|@FS-ACC>": {POS: AUX},
    "<aux>|<hyphen>|V|PS|3S|IND|@FS-STA": {POS: AUX},
    "<aux>|<mqpc-ind>|V|PCP|@ICL-AUX<": {POS: AUX},
    "<aux>|<mqpc-ind>|V|PCP|M|S|@ICL-AUX<": {POS: AUX},
    "<aux>|<mqpc-subj>|V|PCP|@ICL-AUX<": {POS: AUX},
    "<aux>|<pc-ind>|V|PCP|@ICL-AUX<": {POS: AUX},
    "<aux>|<pc-subj>|V|PCP|@ICL-AUX<": {POS: AUX},
    "<aux>|<se-passive>|V|FUT|3P|IND|@FS-N<PRED": {POS: AUX},
    "<aux>|<se-passive>|V|FUT|3S|IND|@FS-<ACC": {POS: AUX},
    "<aux>|<se-passive>|V|FUT|3S|IND|@FS-QUE": {POS: AUX},
    "<aux>|<se-passive>|V|IMPF|3P|IND|@FS-<PIV": {POS: AUX},
    "<aux>|<se-passive>|V|IMPF|3P|IND|@FS-N<": {POS: AUX},
    "<aux>|<se-passive>|V|IMPF|3S|IND|@FS-N<PRED": {POS: AUX},
    "<aux>|<se-passive>|V|IMPF|3S|IND|@FS-STA": {POS: AUX},
    "<aux>|<se-passive>|V|INF|3P|@ICL-UTT": {POS: AUX},
    "<aux>|<se-passive>|V|INF|3S|@ICL-<ACC": {POS: AUX},
    "<aux>|<se-passive>|V|INF|@ICL-P<": {POS: AUX},
    "<aux>|<se-passive>|V|PR|3P|IND|@FS-<ACC": {POS: AUX},
    "<aux>|<se-passive>|V|PR|3P|IND|@FS-<SUBJ": {POS: AUX},
    "<aux>|<se-passive>|V|PR|3P|IND|@FS-ACC>": {POS: AUX},
    "<aux>|<se-passive>|V|PR|3P|IND|@FS-ADVL>": {POS: AUX},
    "<aux>|<se-passive>|V|PR|3P|IND|@FS-N<": {POS: AUX},
    "<aux>|<se-passive>|V|PR|3P|IND|@FS-N<PRED": {POS: AUX},
    "<aux>|<se-passive>|V|PR|3P|IND|@FS-QUE": {POS: AUX},
    "<aux>|<se-passive>|V|PR|3S|IND|@FS-<ACC": {POS: AUX},
    "<aux>|<se-passive>|V|PR|3S|IND|@FS-<SUBJ": {POS: AUX},
    "<aux>|<se-passive>|V|PR|3S|IND|@FS-ACC>": {POS: AUX},
    "<aux>|<se-passive>|V|PR|3S|IND|@FS-N<": {POS: AUX},
    "<aux>|<se-passive>|V|PR|3S|IND|@FS-N<PRED": {POS: AUX},
    "<aux>|<se-passive>|V|PR|3S|IND|@FS-STA": {POS: AUX},
    "<aux>|<se-passive>|V|PR|3S|SUBJ|@FS-<ADVL": {POS: AUX},
    "<aux>|<se-passive>|V|PR|3S|SUBJ|@FS-ADVL>": {POS: AUX},
    "<aux>|<se-passive>|V|PR|3S|SUBJ|@FS-P<": {POS: AUX},
    "<aux>|<se-passive>|V|PS|3P|IND|@FS-STA": {POS: AUX},
    "<aux>|<se-passive>|V|PS|3S|IND|@FS-N<PRED": {POS: AUX},
    "<aux>|V|COND|1S|@FS-N<": {POS: AUX},
    "<aux>|V|COND|3P|@FS-<ACC": {POS: AUX},
    "<aux>|V|COND|3P|@FS-<ADVL": {POS: AUX},
    "<aux>|V|COND|3P|@FS-N<": {POS: AUX},
    "<aux>|V|COND|3P|@FS-N<PRED": {POS: AUX},
    "<aux>|V|COND|3P|@FS-S<": {POS: AUX},
    "<aux>|V|COND|3P|@FS-STA": {POS: AUX},
    "<aux>|V|COND|3S|@FS-<ACC": {POS: AUX},
    "<aux>|V|COND|3S|@FS-<ADVL": {POS: AUX},
    "<aux>|V|COND|3S|@FS-<PIV": {POS: AUX},
    "<aux>|V|COND|3S|@FS-<SUBJ": {POS: AUX},
    "<aux>|V|COND|3S|@FS-ACC>": {POS: AUX},
    "<aux>|V|COND|3S|@FS-ADVL>": {POS: AUX},
    "<aux>|V|COND|3S|@FS-KOMP<": {POS: AUX},
    "<aux>|V|COND|3S|@FS-N<": {POS: AUX},
    "<aux>|V|COND|3S|@FS-N<PRED": {POS: AUX},
    "<aux>|V|COND|3S|@FS-P<": {POS: AUX},
    "<aux>|V|COND|3S|@FS-STA": {POS: AUX},
    "<aux>|V|COND|3S|@P<": {POS: AUX},
    "<aux>|V|FUT|1P|IND|@FS-<ACC": {POS: AUX},
    "<aux>|V|FUT|1P|IND|@FS-N<": {POS: AUX},
    "<aux>|V|FUT|1P|IND|@FS-STA": {POS: AUX},
    "<aux>|V|FUT|1S|IND|@FS-STA": {POS: AUX},
    "<aux>|V|FUT|1S|SUBJ|@FS-ADVL>": {POS: AUX},
    "<aux>|V|FUT|3P|IND|@FS-<ACC": {POS: AUX},
    "<aux>|V|FUT|3P|IND|@FS-<ADVL": {POS: AUX},
    "<aux>|V|FUT|3P|IND|@FS-<PIV": {POS: AUX},
    "<aux>|V|FUT|3P|IND|@FS-ACC>": {POS: AUX},
    "<aux>|V|FUT|3P|IND|@FS-N<": {POS: AUX},
    "<aux>|V|FUT|3P|IND|@FS-N<PRED": {POS: AUX},
    "<aux>|V|FUT|3P|IND|@FS-P<": {POS: AUX},
    "<aux>|V|FUT|3P|IND|@FS-QUE": {POS: AUX},
    "<aux>|V|FUT|3P|IND|@FS-STA": {POS: AUX},
    "<aux>|V|FUT|3P|SUBJ|@FS-<ADVL": {POS: AUX},
    "<aux>|V|FUT|3P|SUBJ|@FS-ADVL>": {POS: AUX},
    "<aux>|V|FUT|3P|SUBJ|@FS-N<": {POS: AUX},
    "<aux>|V|FUT|3S|IND|@FS-<ACC": {POS: AUX},
    "<aux>|V|FUT|3S|IND|@FS-<ADVL": {POS: AUX},
    "<aux>|V|FUT|3S|IND|@FS-<SC": {POS: AUX},
    "<aux>|V|FUT|3S|IND|@FS-<SUBJ": {POS: AUX},
    "<aux>|V|FUT|3S|IND|@FS-A<": {POS: AUX},
    "<aux>|V|FUT|3S|IND|@FS-ACC>": {POS: AUX},
    "<aux>|V|FUT|3S|IND|@FS-ADVL>": {POS: AUX},
    "<aux>|V|FUT|3S|IND|@FS-N<": {POS: AUX},
    "<aux>|V|FUT|3S|IND|@FS-N<PRED": {POS: AUX},
    "<aux>|V|FUT|3S|IND|@FS-P<": {POS: AUX},
    "<aux>|V|FUT|3S|IND|@FS-QUE": {POS: AUX},
    "<aux>|V|FUT|3S|IND|@FS-S<": {POS: AUX},
    "<aux>|V|FUT|3S|IND|@FS-STA": {POS: AUX},
    "<aux>|V|FUT|3S|SUBJ|@FS-<ADVL": {POS: AUX},
    "<aux>|V|FUT|3S|SUBJ|@FS-ADVL>": {POS: AUX},
    "<aux>|V|FUT|3S|SUBJ|@FS-N<": {POS: AUX},
    "<aux>|V|FUT|3S|SUBJ|@FS-N<PRED": {POS: AUX},
    "<aux>|V|FUT|3S|SUBJ|@FS-P<": {POS: AUX},
    "<aux>|V|FUT|3S|SUBJ|@FS-UTT": {POS: AUX},
    "<aux>|V|GER|@ICL-<ADVL": {POS: AUX},
    "<aux>|V|GER|@ICL-ADVL>": {POS: AUX},
    "<aux>|V|GER|@ICL-AUX": {POS: AUX},
    "<aux>|V|GER|@ICL-AUX<": {POS: AUX},
    "<aux>|V|GER|@ICL-N<": {POS: AUX},
    "<aux>|V|GER|@ICL-N<PRED": {POS: AUX},
    "<aux>|V|GER|@ICL-P<": {POS: AUX},
    "<aux>|V|GER|@ICL-PRED>": {POS: AUX},
    "<aux>|V|IMPF|1/3S|IND|@FS-STA": {POS: AUX},
    "<aux>|V|IMPF|1P|IND|@FS-<ACC": {POS: AUX},
    "<aux>|V|IMPF|1P|IND|@FS-ACC>": {POS: AUX},
    "<aux>|V|IMPF|1P|IND|@FS-STA": {POS: AUX},
    "<aux>|V|IMPF|1P|SUBJ|@FS-<ACC": {POS: AUX},
    "<aux>|V|IMPF|1S|IND|@FS-<SUBJ": {POS: AUX},
    "<aux>|V|IMPF|1S|IND|@FS-N<": {POS: AUX},
    "<aux>|V|IMPF|1S|IND|@FS-STA": {POS: AUX},
    "<aux>|V|IMPF|1S|IND|@FS-SUBJ>": {POS: AUX},
    "<aux>|V|IMPF|1S|SUBJ|@FS-<ADVL": {POS: AUX},
    "<aux>|V|IMPF|3P|IND|@FS-<ACC": {POS: AUX},
    "<aux>|V|IMPF|3P|IND|@FS-<ADVL": {POS: AUX},
    "<aux>|V|IMPF|3P|IND|@FS-<SUBJ": {POS: AUX},
    "<aux>|V|IMPF|3P|IND|@FS-ACC>": {POS: AUX},
    "<aux>|V|IMPF|3P|IND|@FS-ADVL>": {POS: AUX},
    "<aux>|V|IMPF|3P|IND|@FS-N<": {POS: AUX},
    "<aux>|V|IMPF|3P|IND|@FS-N<PRED": {POS: AUX},
    "<aux>|V|IMPF|3P|IND|@FS-P<": {POS: AUX},
    "<aux>|V|IMPF|3P|IND|@FS-STA": {POS: AUX},
    "<aux>|V|IMPF|3P|SUBJ|@FS-<ACC": {POS: AUX},
    "<aux>|V|IMPF|3P|SUBJ|@FS-<ADVL": {POS: AUX},
    "<aux>|V|IMPF|3P|SUBJ|@FS-<SUBJ": {POS: AUX},
    "<aux>|V|IMPF|3P|SUBJ|@FS-N<": {POS: AUX},
    "<aux>|V|IMPF|3P|SUBJ|@FS-N<PRED": {POS: AUX},
    "<aux>|V|IMPF|3P|SUBJ|@FS-P<": {POS: AUX},
    "<aux>|V|IMPF|3S|IND|@FS-<ACC": {POS: AUX},
    "<aux>|V|IMPF|3S|IND|@FS-<ADVL": {POS: AUX},
    "<aux>|V|IMPF|3S|IND|@FS-<SC": {POS: AUX},
    "<aux>|V|IMPF|3S|IND|@FS-ACC>": {POS: AUX},
    "<aux>|V|IMPF|3S|IND|@FS-ADVL>": {POS: AUX},
    "<aux>|V|IMPF|3S|IND|@FS-N<": {POS: AUX},
    "<aux>|V|IMPF|3S|IND|@FS-N<PRED": {POS: AUX},
    "<aux>|V|IMPF|3S|IND|@FS-STA": {POS: AUX},
    "<aux>|V|IMPF|3S|SUBJ|@FS-<ACC": {POS: AUX},
    "<aux>|V|IMPF|3S|SUBJ|@FS-<ADVL": {POS: AUX},
    "<aux>|V|IMPF|3S|SUBJ|@FS-<SUBJ": {POS: AUX},
    "<aux>|V|IMPF|3S|SUBJ|@FS-ADVL>": {POS: AUX},
    "<aux>|V|IMPF|3S|SUBJ|@FS-N<": {POS: AUX},
    "<aux>|V|IMPF|3S|SUBJ|@FS-P<": {POS: AUX},
    "<aux>|V|INF|1P|@ICL-P<": {POS: AUX},
    "<aux>|V|INF|3P|@ICL-<ADVL": {POS: AUX},
    "<aux>|V|INF|3P|@ICL-<SC": {POS: AUX},
    "<aux>|V|INF|3P|@ICL-A<": {POS: AUX},
    "<aux>|V|INF|3P|@ICL-N<": {POS: AUX},
    "<aux>|V|INF|3P|@ICL-P<": {POS: AUX},
    "<aux>|V|INF|3S|@ICL-<ACC": {POS: AUX},
    "<aux>|V|INF|3S|@ICL-<SUBJ": {POS: AUX},
    "<aux>|V|INF|3S|@ICL-N<": {POS: AUX},
    "<aux>|V|INF|3S|@ICL-P<": {POS: AUX},
    "<aux>|V|INF|@ICL-<ACC": {POS: AUX},
    "<aux>|V|INF|@ICL-<SUBJ": {POS: AUX},
    "<aux>|V|INF|@ICL-ADVL>": {POS: AUX},
    "<aux>|V|INF|@ICL-APP": {POS: AUX},
    "<aux>|V|INF|@ICL-AUX<": {POS: AUX},
    "<aux>|V|INF|@ICL-P<": {POS: AUX},
    "<aux>|V|INF|@ICL-QUE": {POS: AUX},
    "<aux>|V|INF|@ICL-SUBJ>": {POS: AUX},
    "<aux>|V|INF|FUT|3S|IND|@FS-ICL-STA": {POS: AUX},
    "<aux>|V|MQP|3P|IND|@FS-STA": {POS: AUX},
    "<aux>|V|MQP|3S|IND|@FS-<ACC": {POS: AUX},
    "<aux>|V|MQP|3S|IND|@FS-STA": {POS: AUX},
    "<aux>|V|PCP|@ICL-AUX<": {POS: AUX},
    "<aux>|V|PCP|@ICL-P<": {POS: AUX},
    "<aux>|V|PCP|F|P|@ICL-AUX<": {POS: AUX},
    "<aux>|V|PCP|M|P|@ICL-N<": {POS: AUX},
    "<aux>|V|PCP|M|S|@ICL-AUX<": {POS: AUX},
    "<aux>|V|PCP|M|S|@ICL-PRED>": {POS: AUX},
    "<aux>|V|PR|1P|IND|@FS-<ACC": {POS: AUX},
    "<aux>|V|PR|1P|IND|@FS-<ADVL": {POS: AUX},
    "<aux>|V|PR|1P|IND|@FS-<SUBJ": {POS: AUX},
    "<aux>|V|PR|1P|IND|@FS-ACC>": {POS: AUX},
    "<aux>|V|PR|1P|IND|@FS-ADVL>": {POS: AUX},
    "<aux>|V|PR|1P|IND|@FS-N<": {POS: AUX},
    "<aux>|V|PR|1P|IND|@FS-QUE": {POS: AUX},
    "<aux>|V|PR|1P|IND|@FS-STA": {POS: AUX},
    "<aux>|V|PR|1P|SUBJ|@FS-<ADVL": {POS: AUX},
    "<aux>|V|PR|1P|SUBJ|@FS-STA": {POS: AUX},
    "<aux>|V|PR|1S|IND|@FS-<ACC": {POS: AUX},
    "<aux>|V|PR|1S|IND|@FS-ACC>": {POS: AUX},
    "<aux>|V|PR|1S|IND|@FS-ADVL>": {POS: AUX},
    "<aux>|V|PR|1S|IND|@FS-EXC": {POS: AUX},
    "<aux>|V|PR|1S|IND|@FS-N<": {POS: AUX},
    "<aux>|V|PR|1S|IND|@FS-QUE": {POS: AUX},
    "<aux>|V|PR|1S|IND|@FS-STA": {POS: AUX},
    "<aux>|V|PR|1S|SUBJ|@FS-<ACC": {POS: AUX},
    "<aux>|V|PR|3P|IND|@FS-<ACC": {POS: AUX},
    "<aux>|V|PR|3P|IND|@FS-<ADVL": {POS: AUX},
    "<aux>|V|PR|3P|IND|@FS-<SC": {POS: AUX},
    "<aux>|V|PR|3P|IND|@FS-<SUBJ": {POS: AUX},
    "<aux>|V|PR|3P|IND|@FS-A<": {POS: AUX},
    "<aux>|V|PR|3P|IND|@FS-ACC>": {POS: AUX},
    "<aux>|V|PR|3P|IND|@FS-ADVL>": {POS: AUX},
    "<aux>|V|PR|3P|IND|@FS-APP": {POS: AUX},
    "<aux>|V|PR|3P|IND|@FS-KOMP<": {POS: AUX},
    "<aux>|V|PR|3P|IND|@FS-N<": {POS: AUX},
    "<aux>|V|PR|3P|IND|@FS-N<PRED": {POS: AUX},
    "<aux>|V|PR|3P|IND|@FS-P<": {POS: AUX},
    "<aux>|V|PR|3P|IND|@FS-STA": {POS: AUX},
    "<aux>|V|PR|3P|IND|@FS-SUBJ>": {POS: AUX},
    "<aux>|V|PR|3P|IND|@FS-UTT": {POS: AUX},
    "<aux>|V|PR|3P|SUBJ|@FS-<ACC": {POS: AUX},
    "<aux>|V|PR|3P|SUBJ|@FS-<ADVL": {POS: AUX},
    "<aux>|V|PR|3P|SUBJ|@FS-<SUBJ": {POS: AUX},
    "<aux>|V|PR|3P|SUBJ|@FS-ADVL>": {POS: AUX},
    "<aux>|V|PR|3P|SUBJ|@FS-N<": {POS: AUX},
    "<aux>|V|PR|3P|SUBJ|@FS-N<PRED": {POS: AUX},
    "<aux>|V|PR|3P|SUBJ|@FS-P<": {POS: AUX},
    "<aux>|V|PR|3S|IND|@FS-<ACC": {POS: AUX},
    "<aux>|V|PR|3S|IND|@FS-<ADVL": {POS: AUX},
    "<aux>|V|PR|3S|IND|@FS-<SC": {POS: AUX},
    "<aux>|V|PR|3S|IND|@FS-<SUBJ": {POS: AUX},
    "<aux>|V|PR|3S|IND|@FS-A<": {POS: AUX},
    "<aux>|V|PR|3S|IND|@FS-ACC>": {POS: AUX},
    "<aux>|V|PR|3S|IND|@FS-ADVL>": {POS: AUX},
    "<aux>|V|PR|3S|IND|@FS-APP": {POS: AUX},
    "<aux>|V|PR|3S|IND|@FS-EXC": {POS: AUX},
    "<aux>|V|PR|3S|IND|@FS-KOMP<": {POS: AUX},
    "<aux>|V|PR|3S|IND|@FS-N<": {POS: AUX},
    "<aux>|V|PR|3S|IND|@FS-N<PRED": {POS: AUX},
    "<aux>|V|PR|3S|IND|@FS-P<": {POS: AUX},
    "<aux>|V|PR|3S|IND|@FS-QUE": {POS: AUX},
    "<aux>|V|PR|3S|IND|@FS-S<": {POS: AUX},
    "<aux>|V|PR|3S|IND|@FS-STA": {POS: AUX},
    "<aux>|V|PR|3S|IND|@FS-SUBJ>": {POS: AUX},
    "<aux>|V|PR|3S|IND|@FS-UTT": {POS: AUX},
    "<aux>|V|PR|3S|SUBJ|@FS-<ACC": {POS: AUX},
    "<aux>|V|PR|3S|SUBJ|@FS-<ADVL": {POS: AUX},
    "<aux>|V|PR|3S|SUBJ|@FS-<SC": {POS: AUX},
    "<aux>|V|PR|3S|SUBJ|@FS-<SUBJ": {POS: AUX},
    "<aux>|V|PR|3S|SUBJ|@FS-A<": {POS: AUX},
    "<aux>|V|PR|3S|SUBJ|@FS-ACC>": {POS: AUX},
    "<aux>|V|PR|3S|SUBJ|@FS-ADVL>": {POS: AUX},
    "<aux>|V|PR|3S|SUBJ|@FS-N<": {POS: AUX},
    "<aux>|V|PR|3S|SUBJ|@FS-P<": {POS: AUX},
    "<aux>|V|PR|3S|SUBJ|@FS-STA": {POS: AUX},
    "<aux>|V|PR|3S|SUBJ|@FS-SUBJ>": {POS: AUX},
    "<aux>|V|PS/MQP|3P|IND|@FS-<ACC": {POS: AUX},
    "<aux>|V|PS/MQP|3P|IND|@FS-<ADVL": {POS: AUX},
    "<aux>|V|PS/MQP|3P|IND|@FS-ACC>": {POS: AUX},
    "<aux>|V|PS/MQP|3P|IND|@FS-N<": {POS: AUX},
    "<aux>|V|PS/MQP|3P|IND|@FS-N<PRED": {POS: AUX},
    "<aux>|V|PS/MQP|3P|IND|@FS-STA": {POS: AUX},
    "<aux>|V|PS|1P|IND|@FS-STA": {POS: AUX},
    "<aux>|V|PS|1S|IND|@FS-<ADVL": {POS: AUX},
    "<aux>|V|PS|1S|IND|@FS-ADVL>": {POS: AUX},
    "<aux>|V|PS|1S|IND|@FS-STA": {POS: AUX},
    "<aux>|V|PS|3P|IND|@FS-<ACC": {POS: AUX},
    "<aux>|V|PS|3P|IND|@FS-<ADVL": {POS: AUX},
    "<aux>|V|PS|3P|IND|@FS-ACC>": {POS: AUX},
    "<aux>|V|PS|3P|IND|@FS-ADVL>": {POS: AUX},
    "<aux>|V|PS|3P|IND|@FS-N<": {POS: AUX},
    "<aux>|V|PS|3P|IND|@FS-N<PRED": {POS: AUX},
    "<aux>|V|PS|3P|IND|@FS-STA": {POS: AUX},
    "<aux>|V|PS|3S|IND|@FS-<ACC": {POS: AUX},
    "<aux>|V|PS|3S|IND|@FS-<ADVL": {POS: AUX},
    "<aux>|V|PS|3S|IND|@FS-A<": {POS: AUX},
    "<aux>|V|PS|3S|IND|@FS-ACC>": {POS: AUX},
    "<aux>|V|PS|3S|IND|@FS-ADVL>": {POS: AUX},
    "<aux>|V|PS|3S|IND|@FS-EXC": {POS: AUX},
    "<aux>|V|PS|3S|IND|@FS-KOMP<": {POS: AUX},
    "<aux>|V|PS|3S|IND|@FS-N<": {POS: AUX},
    "<aux>|V|PS|3S|IND|@FS-N<PRED": {POS: AUX},
    "<aux>|V|PS|3S|IND|@FS-P<": {POS: AUX},
    "<aux>|V|PS|3S|IND|@FS-S<": {POS: AUX},
    "<aux>|V|PS|3S|IND|@FS-STA": {POS: AUX},
    "<aux>|V|PS|3S|SUBJ|@FS-STA": {POS: AUX},
    "<card>|<Eg>|NUM|@N<PRED": {POS: NUM},
    "<card>|<Eg>|NUM|F|P|@P<": {POS: NUM},
    "<card>|<Eg>|NUM|M|P|@<ACC": {POS: NUM},
    "<card>|<Eg>|NUM|M|P|@<SA": {POS: NUM},
    "<card>|<Eg>|NUM|M|P|@N<PRED": {POS: NUM},
    "<card>|<cjt>|NUM|M|P|@P<": {POS: NUM},
    "<card>|<date>|<np-def>|NUM|M|P|@>N": {POS: NUM},
    "<card>|<date>|NUM|M|S|@P<": {POS: NUM},
    "<card>|<first-cjt>|NUM|F|S|@<ACC": {POS: NUM},
    "<card>|<first-cjt>|NUM|M|P|@<ADVL": {POS: NUM},
    "<card>|<first-cjt>|NUM|M|P|@N<PRED": {POS: NUM},
    "<card>|<first-cjt>|NUM|M|P|@P<": {POS: NUM},
    "<card>|<n>|NUM|M|P|@P<": {POS: NUM},
    "<card>|<n>|NUM|M|P|@SUBJ>": {POS: NUM},
    "<card>|<n>|NUM|M|S|@P<": {POS: NUM},
    "<card>|<nil>|NUM|F|S|@>N": {POS: NUM},
    "<card>|<np-def>|NUM|F|P|@<ACC": {POS: NUM},
    "<card>|<np-def>|NUM|F|P|@P<": {POS: NUM},
    "<card>|<np-def>|NUM|F|S|@P<": {POS: NUM},
    "<card>|<np-def>|NUM|M/F|P|@<ADVL": {POS: NUM},
    "<card>|<np-def>|NUM|M|P|@<ACC": {POS: NUM},
    "<card>|<np-def>|NUM|M|P|@<SUBJ": {POS: NUM},
    "<card>|<np-def>|NUM|M|P|@>A": {POS: NUM},
    "<card>|<np-def>|NUM|M|P|@N<": {POS: NUM},
    "<card>|<np-def>|NUM|M|P|@P<": {POS: NUM},
    "<card>|<np-def>|NUM|M|P|@SUBJ>": {POS: NUM},
    "<card>|<np-def>|NUM|M|S|@P<": {POS: NUM},
    "<card>|<np-def>|N|M|P|@P<": {POS: NOUN},
    "<card>|<year>|<date>|<np-def>|NUM|M|S|<card>|P|@>": {POS: NUM},
    "<card>|<year>|<date>|NUM|M|S|<card>|M|P|@>": {POS: NUM},
    "<card>|<year>|<date>|NUM|M|S|<card>|P|@>": {POS: NUM},
    "<card>|<year>|<first-cjt>|<date>|NUM|M|S|<card>|P|@>": {POS: NUM},
    "<card>|<year>|<first-cjt>|<date>|NUM|M|S|@P<": {POS: NUM},
    "<card>|ADJ|M|S|@>N": {POS: ADJ},
    "<card>|ART|F|S|@>N": {POS: DET},
    "<card>|NUM|F|P|@<ACC": {POS: NUM},
    "<card>|NUM|F|P|@<SC": {POS: NUM},
    "<card>|NUM|F|P|@<SUBJ": {POS: NUM},
    "<card>|NUM|F|P|@>A": {POS: NUM},
    "<card>|NUM|F|P|@>N": {POS: NUM},
    "<card>|NUM|F|P|@APP": {POS: NUM},
    "<card>|NUM|F|P|@N<": {POS: NUM},
    "<card>|NUM|F|P|@N<PRED": {POS: NUM},
    "<card>|NUM|F|P|@P<": {POS: NUM},
    "<card>|NUM|F|P|@SUBJ>": {POS: NUM},
    "<card>|NUM|F|S|@<ACC": {POS: NUM},
    "<card>|NUM|F|S|@<SC": {POS: NUM},
    "<card>|NUM|F|S|@<SUBJ": {POS: NUM},
    "<card>|NUM|F|S|@>N": {POS: NUM},
    "<card>|NUM|F|S|@APP": {POS: NUM},
    "<card>|NUM|F|S|@N<": {POS: NUM},
    "<card>|NUM|F|S|@N<PRED": {POS: NUM},
    "<card>|NUM|F|S|@P<": {POS: NUM},
    "<card>|NUM|F|S|@PRED>": {POS: NUM},
    "<card>|NUM|F|S|@SUBJ>": {POS: NUM},
    "<card>|NUM|M/F|P|@<ACC": {POS: NUM},
    "<card>|NUM|M/F|P|@<ADVL": {POS: NUM},
    "<card>|NUM|M/F|P|@>A": {POS: NUM},
    "<card>|NUM|M/F|P|@>N": {POS: NUM},
    "<card>|NUM|M/F|P|@P<": {POS: NUM},
    "<card>|NUM|M/F|S|@P<": {POS: NUM},
    "<card>|NUM|M|P|@<ACC": {POS: NUM},
    "<card>|NUM|M|P|@<ADVL": {POS: NUM},
    "<card>|NUM|M|P|@<SC": {POS: NUM},
    "<card>|NUM|M|P|@<SUBJ": {POS: NUM},
    "<card>|NUM|M|P|@>A": {POS: NUM},
    "<card>|NUM|M|P|@>N": {POS: NUM},
    "<card>|NUM|M|P|@A<": {POS: NUM},
    "<card>|NUM|M|P|@ACC>": {POS: NUM},
    "<card>|NUM|M|P|@ADVL>": {POS: NUM},
    "<card>|NUM|M|P|@APP": {POS: NUM},
    "<card>|NUM|M|P|@AUX<": {POS: NUM},
    "<card>|NUM|M|P|@N<": {POS: NUM},
    "<card>|NUM|M|P|@N<PRED": {POS: NUM},
    "<card>|NUM|M|P|@P<": {POS: NUM},
    "<card>|NUM|M|P|@SUBJ>": {POS: NUM},
    "<card>|NUM|M|S|@<ACC": {POS: NUM},
    "<card>|NUM|M|S|@<ADVL": {POS: NUM},
    "<card>|NUM|M|S|@<OC": {POS: NUM},
    "<card>|NUM|M|S|@<SC": {POS: NUM},
    "<card>|NUM|M|S|@<SUBJ": {POS: NUM},
    "<card>|NUM|M|S|@>N": {POS: NUM},
    "<card>|NUM|M|S|@ADVL>": {POS: NUM},
    "<card>|NUM|M|S|@APP": {POS: NUM},
    "<card>|NUM|M|S|@N<": {POS: NUM},
    "<card>|NUM|M|S|@N<PRED": {POS: NUM},
    "<card>|NUM|M|S|@NPHR": {POS: NUM},
    "<card>|NUM|M|S|@P<": {POS: NUM},
    "<card>|NUM|M|S|@SC>": {POS: NUM},
    "<card>|NUM|M|S|@SUBJ>": {POS: NUM},
    "<card>|N|M|P|@>N": {POS: NOUN},
    "<card>|PROP|M|P|@P<": {POS: PROPN},
    "<cjt>|<COMP>|ADJ|F|P|@>N": {POS: ADJ},
    "<cjt>|<COMP>|ADJ|F|S|@ICL-N<": {POS: ADJ},
    "<cjt>|<COMP>|ADJ|M|P|@<PRED": {POS: ADJ},
    "<cjt>|<COMP>|ADJ|M|P|@N<": {POS: ADJ},
    "<cjt>|<COMP>|ADJ|M|S|@<SC": {POS: ADJ},
    "<cjt>|<COMP>|ADJ|M|S|@>N": {POS: ADJ},
    "<cjt>|<COMP>|ADJ|M|S|@N<": {POS: ADJ},
    "<cjt>|<Eg>|<card>|NUM|M|P|@<ACC": {POS: NUM},
    "<cjt>|<Eg>|<dem>|DET|F|P|@P<": {POS: PRON},
    "<cjt>|<Eg>|<dem>|DET|M|S|@P<": {POS: PRON},
    "<cjt>|<Eg>|<n>|<np-idf>|ADJ|M|S|@P<": {POS: ADJ},
    "<cjt>|<Eg>|ADV|@ADVL>": {POS: ADV},
    "<cjt>|<Eg>|ADV|@FS-N<": {POS: ADV},
    "<cjt>|<Eg>|ADV|@N<PRED": {POS: ADV},
    "<cjt>|<Eg>|NUM|F|P|@<ADVL": {POS: NUM},
    "<cjt>|<Eg>|NUM|M|P|@P<": {POS: NUM},
    "<cjt>|<Es>|ADV|@<ADVL": {POS: ADV},
    "<cjt>|<Es>|PRP|@<ADVL": {POS: ADP},
    "<cjt>|<Es>|PRP|@PASS": {POS: ADP},
    "<cjt>|<KOMP>|<COMP>|ADJ|F|S|@>N": {POS: ADJ},
    "<cjt>|<KOMP>|<COMP>|ADJ|F|S|@N<": {POS: ADJ},
    "<cjt>|<KOMP>|<COMP>|ADJ|M|S|@<SC": {POS: ADJ},
    "<cjt>|<KOMP>|<COMP>|ADJ|M|S|@>N": {POS: ADJ},
    "<cjt>|<KOMP>|<SUP>|<COMP>|ADJ|M|S|@N<": {POS: ADJ},
    "<cjt>|<KOMP>|<diff>|<first-cjt>|DET|F|P|@FS-STA": {POS: DET},
    "<cjt>|<KOMP>|<diff>|<np-idf>|DET|M|P|@P<": {POS: PRON},
    "<cjt>|<KOMP>|<diff>|DET|F|P|@<ACC": {POS: PRON},
    "<cjt>|<KOMP>|<diff>|DET|F|S|@NPHR": {POS: DET},
    "<cjt>|<KOMP>|<diff>|DET|F|S|@P<": {POS: PRON},
    "<cjt>|<KOMP>|<diff>|DET|M|P|@<ACC": {POS: PRON},
    "<cjt>|<KOMP>|<diff>|DET|M|S|@<ACC": {POS: PRON},
    "<cjt>|<KOMP>|<diff>|DET|M|S|@APP": {POS: DET},
    "<cjt>|<KOMP>|<diff>|DET|M|S|@N<PRED": {POS: DET},
    "<cjt>|<KOMP>|<first-cjt>|ADJ|M|S|@<SC": {POS: ADJ},
    "<cjt>|<KOMP>|<quant>|ADV|@P<": {POS: ADV},
    "<cjt>|<NUM-ord>|<first-cjt>|ADJ|F|S|@APP": {POS: ADJ},
    "<cjt>|<NUM-ord>|<n>|<np-def>|ADJ|M|S|@<SC": {POS: ADJ},
    "<cjt>|<NUM-ord>|<n>|<np-def>|ADJ|M|S|@P<": {POS: ADJ},
    "<cjt>|<NUM-ord>|<n>|<np-def>|ADJ|M|S|@SUBJ>": {POS: ADJ},
    "<cjt>|<NUM-ord>|<n>|<np-idf>|N|F|S|@ADVL": {POS: NOUN},
    "<cjt>|<NUM-ord>|<np-def>|ADJ|F|S|@N<PRED": {POS: ADJ},
    "<cjt>|<NUM-ord>|<np-idf>|ADJ|M|S|@ADVL>": {POS: ADJ},
    "<cjt>|<NUM-ord>|<prop>|ADJ|M|S|@N<": {POS: ADJ},
    "<cjt>|<NUM-ord>|ADJ|F|S|@>N": {POS: ADJ},
    "<cjt>|<NUM-ord>|ADJ|F|S|@APP": {POS: ADJ},
    "<cjt>|<NUM-ord>|ADJ|M|S|@<SC": {POS: ADJ},
    "<cjt>|<NUM-ord>|ADJ|M|S|@>N": {POS: ADJ},
    "<cjt>|<NUM-ord>|ADJ|M|S|@FS-UTT": {POS: ADJ},
    "<cjt>|<NUM-ord>|ADJ|M|S|@N<": {POS: ADJ},
    "<cjt>|<NUM-ord>|ADJ|M|S|@N<PRED": {POS: ADJ},
    "<cjt>|<SUP>|<KOMP>|<COMP>|ADJ|M|S|@N<": {POS: ADJ},
    "<cjt>|<SUP>|<KOMP>|ADJ|M|S|@>N": {POS: ADJ},
    "<cjt>|<SUP>|<n>|ADJ|M|S|@P<": {POS: ADJ},
    "<cjt>|<artd>|DET|M|P|@>N": {POS: DET},
    "<cjt>|<aux>|<first-cjt>|V|PCP|@ICL-P<": {POS: AUX},
    "<cjt>|<aux>|<se-passive>|V|FUT|3S|IND|@FS-N<": {POS: AUX},
    "<cjt>|<aux>|<se-passive>|V|INF|@ICL-P<": {POS: AUX},
    "<cjt>|<aux>|<se-passive>|V|PR|3P|IND|@FS-<ACC": {POS: AUX},
    "<cjt>|<aux>|V|COND|3P|@FS-<ACC": {POS: AUX},
    "<cjt>|<aux>|V|COND|3P|@FS-APP": {POS: AUX},
    "<cjt>|<aux>|V|COND|3P|@FS-STA": {POS: AUX},
    "<cjt>|<aux>|V|COND|3S|@FS-<ACC": {POS: AUX},
    "<cjt>|<aux>|V|COND|3S|@FS-N<PRED": {POS: AUX},
    "<cjt>|<aux>|V|COND|3S|@FS-STA": {POS: AUX},
    "<cjt>|<aux>|V|FUT|3P|IND|@FS-<ACC": {POS: AUX},
    "<cjt>|<aux>|V|FUT|3P|IND|@FS-<ADVL": {POS: AUX},
    "<cjt>|<aux>|V|FUT|3P|IND|@FS-N<PRED": {POS: AUX},
    "<cjt>|<aux>|V|FUT|3P|IND|@FS-STA": {POS: AUX},
    "<cjt>|<aux>|V|FUT|3P|IND|@ICL-N<": {POS: AUX},
    "<cjt>|<aux>|V|FUT|3P|SUBJ|@FS-ADVL>": {POS: AUX},
    "<cjt>|<aux>|V|FUT|3S|IND|@FS-<ACC": {POS: AUX},
    "<cjt>|<aux>|V|FUT|3S|IND|@FS-<ADVL": {POS: AUX},
    "<cjt>|<aux>|V|FUT|3S|IND|@FS-N<": {POS: AUX},
    "<cjt>|<aux>|V|FUT|3S|IND|@FS-N<PRED": {POS: AUX},
    "<cjt>|<aux>|V|FUT|3S|IND|@FS-STA": {POS: AUX},
    "<cjt>|<aux>|V|FUT|3S|IND|@ICL-<ACC": {POS: AUX},
    "<cjt>|<aux>|V|FUT|3S|IND|@N<PRED": {POS: AUX},
    "<cjt>|<aux>|V|FUT|3S|SUBJ|@FS-<SUBJ": {POS: AUX},
    "<cjt>|<aux>|V|GER|@ICL-<ADVL": {POS: AUX},
    "<cjt>|<aux>|V|GER|@ICL-ADVL>": {POS: AUX},
    "<cjt>|<aux>|V|IMPF|1S|IND|@FS-STA": {POS: AUX},
    "<cjt>|<aux>|V|IMPF|3P|IND|@FS-STA": {POS: AUX},
    "<cjt>|<aux>|V|IMPF|3S|IND|@FS-<ACC": {POS: AUX},
    "<cjt>|<aux>|V|IMPF|3S|IND|@FS-N<": {POS: AUX},
    "<cjt>|<aux>|V|IMPF|3S|IND|@FS-N<PRED": {POS: AUX},
    "<cjt>|<aux>|V|IMPF|3S|IND|@FS-STA": {POS: AUX},
    "<cjt>|<aux>|V|IMPF|3S|SUBJ|@FS-STA": {POS: AUX},
    "<cjt>|<aux>|V|INF|@ICL-<SC": {POS: AUX},
    "<cjt>|<aux>|V|INF|@ICL-AUX<": {POS: AUX},
    "<cjt>|<aux>|V|INF|@ICL-P<": {POS: AUX},
    "<cjt>|<aux>|V|MQP|3S|IND|@FS-STA": {POS: AUX},
    "<cjt>|<aux>|V|PCP|@ICL-AUX<": {POS: AUX},
    "<cjt>|<aux>|V|PR|1P|IND|@FS-ACC>": {POS: AUX},
    "<cjt>|<aux>|V|PR|1P|IND|@FS-STA": {POS: AUX},
    "<cjt>|<aux>|V|PR|1S|IND|@FS-<SUBJ": {POS: AUX},
    "<cjt>|<aux>|V|PR|1S|IND|@FS-ACC>": {POS: AUX},
    "<cjt>|<aux>|V|PR|1S|IND|@FS-STA": {POS: AUX},
    "<cjt>|<aux>|V|PR|2S|IND|@FS-STA": {POS: AUX},
    "<cjt>|<aux>|V|PR|3P|IND|@FS-<ACC": {POS: AUX},
    "<cjt>|<aux>|V|PR|3P|IND|@FS-N<PRED": {POS: AUX},
    "<cjt>|<aux>|V|PR|3P|IND|@FS-P<": {POS: AUX},
    "<cjt>|<aux>|V|PR|3P|IND|@FS-STA": {POS: AUX},
    "<cjt>|<aux>|V|PR|3P|SUBJ|@FS-<ACC": {POS: AUX},
    "<cjt>|<aux>|V|PR|3P|SUBJ|@FS-<ADVL": {POS: AUX},
    "<cjt>|<aux>|V|PR|3P|SUBJ|@FS-ADVL>": {POS: AUX},
    "<cjt>|<aux>|V|PR|3S|IND|@FS-<ACC": {POS: AUX},
    "<cjt>|<aux>|V|PR|3S|IND|@FS-<ADVL": {POS: AUX},
    "<cjt>|<aux>|V|PR|3S|IND|@FS-<SUBJ": {POS: AUX},
    "<cjt>|<aux>|V|PR|3S|IND|@FS-ACC>": {POS: AUX},
    "<cjt>|<aux>|V|PR|3S|IND|@FS-ADVL>": {POS: AUX},
    "<cjt>|<aux>|V|PR|3S|IND|@FS-APP": {POS: AUX},
    "<cjt>|<aux>|V|PR|3S|IND|@FS-KOMP<": {POS: AUX},
    "<cjt>|<aux>|V|PR|3S|IND|@FS-N<": {POS: AUX},
    "<cjt>|<aux>|V|PR|3S|IND|@FS-N<PRED": {POS: AUX},
    "<cjt>|<aux>|V|PR|3S|IND|@FS-P<": {POS: AUX},
    "<cjt>|<aux>|V|PR|3S|IND|@FS-QUE": {POS: AUX},
    "<cjt>|<aux>|V|PR|3S|IND|@FS-SC>": {POS: AUX},
    "<cjt>|<aux>|V|PR|3S|IND|@FS-STA": {POS: AUX},
    "<cjt>|<aux>|V|PR|3S|IND|@ICL-<ACC": {POS: AUX},
    "<cjt>|<aux>|V|PR|3S|IND|@ICL-N<": {POS: AUX},
    "<cjt>|<aux>|V|PR|3S|SUBJ|@ADVL>": {POS: AUX},
    "<cjt>|<aux>|V|PR|3S|SUBJ|@FS-<ACC": {POS: AUX},
    "<cjt>|<aux>|V|PR|3S|SUBJ|@FS-<SC": {POS: AUX},
    "<cjt>|<aux>|V|PR|3S|SUBJ|@FS-<SUBJ": {POS: AUX},
    "<cjt>|<aux>|V|PR|3S|SUBJ|@FS-P<": {POS: AUX},
    "<cjt>|<aux>|V|PR|3S|SUBJ|@FS-STA": {POS: AUX},
    "<cjt>|<aux>|V|PS/MQP|3P|IND|@FS-<ACC": {POS: AUX},
    "<cjt>|<aux>|V|PS/MQP|3P|IND|@FS-STA": {POS: AUX},
    "<cjt>|<aux>|V|PS|1P|IND|@FS-STA": {POS: AUX},
    "<cjt>|<aux>|V|PS|1S|IND|@FS-ACC>": {POS: AUX},
    "<cjt>|<aux>|V|PS|1S|IND|@FS-STA": {POS: AUX},
    "<cjt>|<aux>|V|PS|3P|IND|@FS-<SUBJ": {POS: AUX},
    "<cjt>|<aux>|V|PS|3P|IND|@FS-ACC>": {POS: AUX},
    "<cjt>|<aux>|V|PS|3P|IND|@FS-STA": {POS: AUX},
    "<cjt>|<aux>|V|PS|3P|IND|@N<ARG": {POS: AUX},
    "<cjt>|<aux>|V|PS|3S|IND|@FS-<ACC": {POS: AUX},
    "<cjt>|<aux>|V|PS|3S|IND|@FS-ADVL>": {POS: AUX},
    "<cjt>|<aux>|V|PS|3S|IND|@FS-N<": {POS: AUX},
    "<cjt>|<aux>|V|PS|3S|IND|@FS-N<PRED": {POS: AUX},
    "<cjt>|<aux>|V|PS|3S|IND|@FS-STA": {POS: AUX},
    "<cjt>|<aux>|V|PS|3S|IND|@ICL-STA": {POS: AUX},
    "<cjt>|<card>|<date>|NUM|M|S|@N<": {POS: NUM},
    "<cjt>|<card>|<first-cjt>|NUM|M|S|@APP": {POS: NUM},
    "<cjt>|<card>|<n>|NUM|M|P|@P<": {POS: NUM},
    "<cjt>|<card>|NUM|F|P|@<SUBJ": {POS: NUM},
    "<cjt>|<card>|NUM|F|P|@>A": {POS: NUM},
    "<cjt>|<card>|NUM|F|P|@>N": {POS: NUM},
    "<cjt>|<card>|NUM|F|P|@N<": {POS: NUM},
    "<cjt>|<card>|NUM|F|P|@N<PRED": {POS: NUM},
    "<cjt>|<card>|NUM|F|P|@NPHR": {POS: NUM},
    "<cjt>|<card>|NUM|F|P|@P<": {POS: NUM},
    "<cjt>|<card>|NUM|F|S|@<SC": {POS: NUM},
    "<cjt>|<card>|NUM|F|S|@N<": {POS: NUM},
    "<cjt>|<card>|NUM|F|S|@P<": {POS: NUM},
    "<cjt>|<card>|NUM|M/F|P|@N<": {POS: NUM},
    "<cjt>|<card>|NUM|M|P|@<ACC": {POS: NUM},
    "<cjt>|<card>|NUM|M|P|@<ADVL": {POS: NUM},
    "<cjt>|<card>|NUM|M|P|@<SC": {POS: NUM},
    "<cjt>|<card>|NUM|M|P|@>N": {POS: NUM},
    "<cjt>|<card>|NUM|M|P|@APP": {POS: NUM},
    "<cjt>|<card>|NUM|M|P|@N<": {POS: NUM},
    "<cjt>|<card>|NUM|M|P|@P<": {POS: NUM},
    "<cjt>|<card>|NUM|M|S|@>N": {POS: NUM},
    "<cjt>|<card>|NUM|M|S|@N<": {POS: NUM},
    "<cjt>|<card>|NUM|M|S|@N<PRED": {POS: NUM},
    "<cjt>|<card>|NUM|M|S|@P<": {POS: NUM},
    "<cjt>|<card>|NUM|M|S|@PRED>": {POS: NUM},
    "<cjt>|<co-prparg>|<np-idf>|N|M|P|@P<": {POS: NOUN},
    "<cjt>|<co-vfin>|KC|@<ADVL": {POS: CCONJ},
    "<cjt>|<com>|PRP|@<ADVL": {POS: ADP},
    "<cjt>|<com>|PRP|@PRED>": {POS: ADP},
    "<cjt>|<dem>|<first-cjt>|INDP|M|S|@KOMP<": {POS: PRON},
    "<cjt>|<dem>|<np-idf>|DET|F|P|@<SC": {POS: PRON},
    "<cjt>|<dem>|<np-idf>|DET|F|S|@N<PRED": {POS: DET},
    "<cjt>|<dem>|<np-idf>|DET|M|P|@<SC": {POS: PRON},
    "<cjt>|<dem>|DET|F|P|@<SC": {POS: PRON},
    "<cjt>|<dem>|DET|F|P|@<SUBJ": {POS: PRON},
    "<cjt>|<dem>|DET|F|P|@P<": {POS: PRON},
    "<cjt>|<dem>|DET|F|P|@SUBJ>": {POS: PRON},
    "<cjt>|<dem>|DET|F|S|@APP": {POS: DET},
    "<cjt>|<dem>|DET|M|P|@<ACC": {POS: PRON},
    "<cjt>|<dem>|DET|M|P|@P<": {POS: PRON},
    "<cjt>|<dem>|DET|M|P|@SUBJ>": {POS: PRON},
    "<cjt>|<dem>|DET|M|S|@<ACC": {POS: PRON},
    "<cjt>|<dem>|DET|M|S|@APP": {POS: DET},
    "<cjt>|<dem>|DET|M|S|@P<": {POS: PRON},
    "<cjt>|<dem>|DET|M|S|@SUBJ>": {POS: PRON},
    "<cjt>|<diff>|<KOMP>|<np-def>|DET|F|S|@SUBJ>": {POS: PRON},
    "<cjt>|<diff>|<KOMP>|DET|F|P|@P<": {POS: PRON},
    "<cjt>|<diff>|<KOMP>|DET|F|S|@P<": {POS: PRON},
    "<cjt>|<diff>|<KOMP>|DET|M|P|@P<": {POS: PRON},
    "<cjt>|<diff>|DET|F|S|@P<": {POS: PRON},
    "<cjt>|<diff>|DET|M|S|@N<PRED": {POS: DET},
    "<cjt>|<diff>|DET|M|S|@SUBJ>": {POS: PRON},
    "<cjt>|<first-cjt>|<COMP>|ADJ|M|S|@N<": {POS: ADJ},
    "<cjt>|<first-cjt>|<NUM-ord>|<np-def>|ADJ|M|S|@<ADVL": {POS: ADJ},
    "<cjt>|<first-cjt>|<n>|<np-def>|ADJ|M|S|@P<": {POS: ADJ},
    "<cjt>|<first-cjt>|<np-def>|N|F|P|@P<": {POS: NOUN},
    "<cjt>|<first-cjt>|<np-def>|N|F|S|@P<": {POS: NOUN},
    "<cjt>|<first-cjt>|<np-def>|N|F|S|@SUBJ>": {POS: NOUN},
    "<cjt>|<first-cjt>|<np-def>|N|M|P|@<ACC": {POS: NOUN},
    "<cjt>|<first-cjt>|<np-def>|N|M|P|@<SUBJ": {POS: NOUN},
    "<cjt>|<first-cjt>|<np-def>|N|M|S|@<SUBJ": {POS: NOUN},
    "<cjt>|<first-cjt>|<np-idf>|N|F|P|@P<": {POS: NOUN},
    "<cjt>|<first-cjt>|<np-idf>|N|F|S|@<ACC": {POS: NOUN},
    "<cjt>|<first-cjt>|<np-idf>|N|F|S|@APP": {POS: NOUN},
    "<cjt>|<first-cjt>|<np-idf>|N|F|S|@N<PRED": {POS: NOUN},
    "<cjt>|<first-cjt>|<np-idf>|N|F|S|@P<": {POS: NOUN},
    "<cjt>|<first-cjt>|<np-idf>|N|M|P|@<ACC": {POS: NOUN},
    "<cjt>|<first-cjt>|<np-idf>|N|M|P|@APP": {POS: NOUN},
    "<cjt>|<first-cjt>|<np-idf>|N|M|P|@P<": {POS: NOUN},
    "<cjt>|<first-cjt>|<np-idf>|N|M|S|@APP": {POS: NOUN},
    "<cjt>|<first-cjt>|<np-idf>|N|M|S|@N<PRED": {POS: NOUN},
    "<cjt>|<first-cjt>|<np-idf>|N|M|S|@P<": {POS: NOUN},
    "<cjt>|<first-cjt>|<sam->|PRP|@N<": {POS: ADP},
    "<cjt>|<first-cjt>|ADJ|F|S|@N<PRED": {POS: ADJ},
    "<cjt>|<first-cjt>|ADJ|F|S|@NPHR": {POS: ADJ},
    "<cjt>|<first-cjt>|ADJ|M|P|@FS-STA": {POS: ADJ},
    "<cjt>|<first-cjt>|ADJ|M|S|@N<PRED": {POS: ADJ},
    "<cjt>|<first-cjt>|ADV|@ADVL": {POS: ADV},
    "<cjt>|<first-cjt>|PERS|F|3S|NOM|@N<PRED": {POS: PRON},
    "<cjt>|<first-cjt>|PROP|F|S|@APP": {POS: PROPN},
    "<cjt>|<first-cjt>|PROP|F|S|@NPHR": {POS: PROPN},
    "<cjt>|<first-cjt>|PROP|M|S|@<ACC": {POS: PROPN},
    "<cjt>|<first-cjt>|PROP|M|S|@<SC": {POS: PROPN},
    "<cjt>|<first-cjt>|PROP|M|S|@APP": {POS: PROPN},
    "<cjt>|<first-cjt>|PROP|M|S|@N<PRED": {POS: PROPN},
    "<cjt>|<first-cjt>|PROP|M|S|@SUBJ>": {POS: PROPN},
    "<cjt>|<first-cjt>|PRP|@<ADVL": {POS: ADP},
    "<cjt>|<first-cjt>|PRP|@<PIV": {POS: ADP},
    "<cjt>|<first-cjt>|PRP|@N<": {POS: ADP},
    "<cjt>|<interr>|ADV|@<ADVL": {POS: ADV},
    "<cjt>|<interr>|ADV|@ADVL>": {POS: ADV},
    "<cjt>|<kc>|<first-cjt>|ADV|@ADVL>": {POS: ADV},
    "<cjt>|<meta>|<first-cjt>|<np-idf>|N|F|S|@<ACC": {POS: NOUN},
    "<cjt>|<meta>|<first-cjt>|<np-idf>|N|M|S|@P<": {POS: NOUN},
    "<cjt>|<mv>|<se-passive>|V|FUT|3S|SUBJ|@FS-<ADVL": {POS: VERB},
    "<cjt>|<mv>|<se-passive>|V|IMPF|3P|IND|@FS-N<": {POS: VERB},
    "<cjt>|<mv>|<se-passive>|V|IMPF|3P|IND|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|<se-passive>|V|IMPF|3S|IND|@FS-N<PRED": {POS: VERB},
    "<cjt>|<mv>|<se-passive>|V|IMPF|3S|IND|@ICL-N<": {POS: VERB},
    "<cjt>|<mv>|<se-passive>|V|IMPF|3S|SUBJ|@FS-P<": {POS: VERB},
    "<cjt>|<mv>|<se-passive>|V|INF|3P|@ICL-P<": {POS: VERB},
    "<cjt>|<mv>|<se-passive>|V|MQP|3S|IND|@FS-N<PRED": {POS: VERB},
    "<cjt>|<mv>|<se-passive>|V|PR|3P|IND|@FS-<ADVL": {POS: VERB},
    "<cjt>|<mv>|<se-passive>|V|PR|3P|IND|@FS-N<": {POS: VERB},
    "<cjt>|<mv>|<se-passive>|V|PR|3P|IND|@FS-N<PRED": {POS: VERB},
    "<cjt>|<mv>|<se-passive>|V|PR|3P|IND|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|<se-passive>|V|PR|3P|SUBJ|@FS-<ACC": {POS: VERB},
    "<cjt>|<mv>|<se-passive>|V|PR|3P|SUBJ|@FS-<SUBJ": {POS: VERB},
    "<cjt>|<mv>|<se-passive>|V|PR|3S|IND|@FS-N<": {POS: VERB},
    "<cjt>|<mv>|<se-passive>|V|PR|3S|IND|@FS-N<PRED": {POS: VERB},
    "<cjt>|<mv>|<se-passive>|V|PR|3S|IND|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|<se-passive>|V|PS/MQP|3P|IND|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|<se-passive>|V|PS|3P|IND|@FS-N<": {POS: VERB},
    "<cjt>|<mv>|<se-passive>|V|PS|3P|IND|@FS-QUE": {POS: VERB},
    "<cjt>|<mv>|<se-passive>|V|PS|3S|IND|@FS-<ACC": {POS: VERB},
    "<cjt>|<mv>|<se-passive>|V|PS|3S|IND|@FS-<SUBJ": {POS: VERB},
    "<cjt>|<mv>|<se-passive>|V|PS|3S|IND|@FS-N<": {POS: VERB},
    "<cjt>|<mv>|<se-passive>|V|PS|3S|IND|@FS-N<PRED": {POS: VERB},
    "<cjt>|<mv>|<se-passive>|V|PS|3S|IND|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|<se-passive>|V|PS|3S|IND|@N<PRED": {POS: VERB},
    "<cjt>|<mv>|V|COND|1P|@FS-<ACC": {POS: VERB},
    "<cjt>|<mv>|V|COND|1S|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|V|COND|3P|@FS-N<PRED": {POS: VERB},
    "<cjt>|<mv>|V|COND|3P|@FS-P<": {POS: VERB},
    "<cjt>|<mv>|V|COND|3S|@FS-<ACC": {POS: VERB},
    "<cjt>|<mv>|V|COND|3S|@FS-ACC>": {POS: AUX},
    "<cjt>|<mv>|V|COND|3S|@FS-P<": {POS: VERB},
    "<cjt>|<mv>|V|COND|3S|@FS-QUE": {POS: VERB},
    "<cjt>|<mv>|V|COND|3S|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|V|COND|3S|@N<ARG": {POS: AUX},
    "<cjt>|<mv>|V|FUT|1S|IND|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|V|FUT|3P|IND|@FS-<SC": {POS: AUX},
    "<cjt>|<mv>|V|FUT|3P|IND|@FS-<SUBJ": {POS: AUX},
    "<cjt>|<mv>|V|FUT|3P|IND|@FS-N<": {POS: VERB},
    "<cjt>|<mv>|V|FUT|3P|IND|@FS-N<PRED": {POS: VERB},
    "<cjt>|<mv>|V|FUT|3P|IND|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|V|FUT|3P|IND|@N<": {POS: VERB},
    "<cjt>|<mv>|V|FUT|3P|SUBJ|@FS-<ADVL": {POS: VERB},
    "<cjt>|<mv>|V|FUT|3P|SUBJ|@FS-ADVL>": {POS: VERB},
    "<cjt>|<mv>|V|FUT|3S|IND|@FS-<ACC": {POS: VERB},
    "<cjt>|<mv>|V|FUT|3S|IND|@FS-<SUBJ": {POS: AUX},
    "<cjt>|<mv>|V|FUT|3S|IND|@FS-N<": {POS: VERB},
    "<cjt>|<mv>|V|FUT|3S|IND|@FS-N<PRED": {POS: VERB},
    "<cjt>|<mv>|V|FUT|3S|IND|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|V|FUT|3S|IND|@FS-UTT": {POS: VERB},
    "<cjt>|<mv>|V|FUT|3S|IND|@N<ARG": {POS: VERB},
    "<cjt>|<mv>|V|FUT|3S|SUBJ|@FS-<ADVL": {POS: VERB},
    "<cjt>|<mv>|V|FUT|3S|SUBJ|@FS-ADVL>": {POS: VERB},
    "<cjt>|<mv>|V|FUT|3S|SUBJ|@ICL-P<": {POS: VERB},
    "<cjt>|<mv>|V|GER|@ADVL>": {POS: VERB},
    "<cjt>|<mv>|V|GER|@ICL-<ADVL": {POS: VERB},
    "<cjt>|<mv>|V|GER|@ICL-ADVL>": {POS: VERB},
    "<cjt>|<mv>|V|GER|@ICL-N<PRED": {POS: VERB},
    "<cjt>|<mv>|V|GER|@N<": {POS: VERB},
    "<cjt>|<mv>|V|IMPF|1P|IND|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|V|IMPF|1S|IND|@FS-A<": {POS: VERB},
    "<cjt>|<mv>|V|IMPF|1S|IND|@FS-ACC>": {POS: VERB},
    "<cjt>|<mv>|V|IMPF|1S|IND|@FS-KOMP<": {POS: VERB},
    "<cjt>|<mv>|V|IMPF|1S|IND|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|V|IMPF|3P|IND|@ADVL>": {POS: AUX},
    "<cjt>|<mv>|V|IMPF|3P|IND|@FS-<ACC": {POS: AUX},
    "<cjt>|<mv>|V|IMPF|3P|IND|@FS-<ADVL": {POS: VERB},
    "<cjt>|<mv>|V|IMPF|3P|IND|@FS-ADVL>": {POS: VERB},
    "<cjt>|<mv>|V|IMPF|3P|IND|@FS-KOMP<": {POS: VERB},
    "<cjt>|<mv>|V|IMPF|3P|IND|@FS-N<": {POS: VERB},
    "<cjt>|<mv>|V|IMPF|3P|IND|@FS-N<PRED": {POS: VERB},
    "<cjt>|<mv>|V|IMPF|3P|IND|@FS-P<": {POS: VERB},
    "<cjt>|<mv>|V|IMPF|3P|IND|@FS-QUE": {POS: AUX},
    "<cjt>|<mv>|V|IMPF|3P|IND|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|V|IMPF|3P|IND|@ICL-STA": {POS: VERB},
    "<cjt>|<mv>|V|IMPF|3P|SUBJ|@FS-<ACC": {POS: VERB},
    "<cjt>|<mv>|V|IMPF|3S|IND|@FS-<ACC": {POS: VERB},
    "<cjt>|<mv>|V|IMPF|3S|IND|@FS-<ADVL": {POS: VERB},
    "<cjt>|<mv>|V|IMPF|3S|IND|@FS-ACC>": {POS: AUX},
    "<cjt>|<mv>|V|IMPF|3S|IND|@FS-N<": {POS: VERB},
    "<cjt>|<mv>|V|IMPF|3S|IND|@FS-N<PRED": {POS: VERB},
    "<cjt>|<mv>|V|IMPF|3S|IND|@FS-P<": {POS: VERB},
    "<cjt>|<mv>|V|IMPF|3S|IND|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|V|IMPF|3S|IND|@FS-SUBJ>": {POS: VERB},
    "<cjt>|<mv>|V|IMPF|3S|IND|@ICL-N<": {POS: VERB},
    "<cjt>|<mv>|V|IMPF|3S|IND|@N<": {POS: VERB},
    "<cjt>|<mv>|V|IMPF|3S|SUBJ|@FS-<ADVL": {POS: VERB},
    "<cjt>|<mv>|V|INF|1P|@ICL-<SUBJ": {POS: VERB},
    "<cjt>|<mv>|V|INF|3P|@ICL-<SUBJ": {POS: VERB},
    "<cjt>|<mv>|V|INF|3P|@ICL-P<": {POS: VERB},
    "<cjt>|<mv>|V|INF|3S|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|V|INF|3S|@ICL-<SUBJ": {POS: VERB},
    "<cjt>|<mv>|V|INF|3S|@ICL-P<": {POS: VERB},
    "<cjt>|<mv>|V|INF|@FS-QUE": {POS: VERB},
    "<cjt>|<mv>|V|INF|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|V|INF|@ICL-<ACC": {POS: VERB},
    "<cjt>|<mv>|V|INF|@ICL-<SC": {POS: VERB},
    "<cjt>|<mv>|V|INF|@ICL-AUX<": {POS: VERB},
    "<cjt>|<mv>|V|INF|@ICL-KOMP<": {POS: VERB},
    "<cjt>|<mv>|V|INF|@ICL-N<PRED": {POS: VERB},
    "<cjt>|<mv>|V|INF|@ICL-P<": {POS: VERB},
    "<cjt>|<mv>|V|INF|@P<": {POS: VERB},
    "<cjt>|<mv>|V|MQP|3S|IND|@FS-N<PRED": {POS: VERB},
    "<cjt>|<mv>|V|MQP|3S|IND|@FS-P<": {POS: VERB},
    "<cjt>|<mv>|V|MQP|3S|IND|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|V|PCP|@ICL-AUX<": {POS: VERB},
    "<cjt>|<mv>|V|PCP|F|P|@ICL-AUX<": {POS: VERB},
    "<cjt>|<mv>|V|PCP|F|P|@ICL-N<": {POS: VERB},
    "<cjt>|<mv>|V|PCP|F|P|@ICL-N<PRED": {POS: VERB},
    "<cjt>|<mv>|V|PCP|F|P|@N<": {POS: ADJ},
    "<cjt>|<mv>|V|PCP|F|S|@ICL-<ADVL": {POS: VERB},
    "<cjt>|<mv>|V|PCP|F|S|@ICL-<SC": {POS: ADJ},
    "<cjt>|<mv>|V|PCP|F|S|@ICL-AUX<": {POS: VERB},
    "<cjt>|<mv>|V|PCP|F|S|@ICL-N<": {POS: VERB},
    "<cjt>|<mv>|V|PCP|F|S|@ICL-N<PRED": {POS: VERB},
    "<cjt>|<mv>|V|PCP|F|S|@ICL-PRED>": {POS: VERB},
    "<cjt>|<mv>|V|PCP|F|S|@N<": {POS: VERB},
    "<cjt>|<mv>|V|PCP|F|S|@PRED>": {POS: VERB},
    "<cjt>|<mv>|V|PCP|M|P|@FS-ACC>": {POS: VERB},
    "<cjt>|<mv>|V|PCP|M|P|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|V|PCP|M|P|@ICL-<ADVL": {POS: VERB},
    "<cjt>|<mv>|V|PCP|M|P|@ICL-AUX<": {POS: VERB},
    "<cjt>|<mv>|V|PCP|M|P|@ICL-N<": {POS: VERB},
    "<cjt>|<mv>|V|PCP|M|P|@ICL-N<PRED": {POS: VERB},
    "<cjt>|<mv>|V|PCP|M|P|@ICL-P<": {POS: VERB},
    "<cjt>|<mv>|V|PCP|M|P|@N<": {POS: VERB},
    "<cjt>|<mv>|V|PCP|M|S|@FS-N<PRED": {POS: VERB},
    "<cjt>|<mv>|V|PCP|M|S|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|V|PCP|M|S|@ICL-<ADVL": {POS: VERB},
    "<cjt>|<mv>|V|PCP|M|S|@ICL-<PRED": {POS: VERB},
    "<cjt>|<mv>|V|PCP|M|S|@ICL-<SC": {POS: VERB},
    "<cjt>|<mv>|V|PCP|M|S|@ICL-AUX<": {POS: VERB},
    "<cjt>|<mv>|V|PCP|M|S|@ICL-N<PRED": {POS: VERB},
    "<cjt>|<mv>|V|PCP|M|S|@ICL-PRED>": {POS: VERB},
    "<cjt>|<mv>|V|PCP|M|S|@N<": {POS: VERB},
    "<cjt>|<mv>|V|PCP|M|S|@N<PRED": {POS: VERB},
    "<cjt>|<mv>|V|PR|1P|IND|@FS-ACC>": {POS: VERB},
    "<cjt>|<mv>|V|PR|1P|IND|@FS-ADVL>": {POS: VERB},
    "<cjt>|<mv>|V|PR|1P|IND|@FS-EXC": {POS: VERB},
    "<cjt>|<mv>|V|PR|1P|IND|@FS-N<": {POS: VERB},
    "<cjt>|<mv>|V|PR|1P|IND|@FS-N<PRED": {POS: VERB},
    "<cjt>|<mv>|V|PR|1P|IND|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|V|PR|1P|SUBJ|@FS-N<PRED": {POS: VERB},
    "<cjt>|<mv>|V|PR|1S|IND|@FS-<ADVL": {POS: VERB},
    "<cjt>|<mv>|V|PR|1S|IND|@FS-ACC>": {POS: VERB},
    "<cjt>|<mv>|V|PR|1S|IND|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|V|PR|3P|IND|@<SC": {POS: VERB},
    "<cjt>|<mv>|V|PR|3P|IND|@FS-<ACC": {POS: VERB},
    "<cjt>|<mv>|V|PR|3P|IND|@FS-<ADVL": {POS: VERB},
    "<cjt>|<mv>|V|PR|3P|IND|@FS-<SUBJ": {POS: VERB},
    "<cjt>|<mv>|V|PR|3P|IND|@FS-ACC>": {POS: VERB},
    "<cjt>|<mv>|V|PR|3P|IND|@FS-ADVL>": {POS: VERB},
    "<cjt>|<mv>|V|PR|3P|IND|@FS-APP": {POS: VERB},
    "<cjt>|<mv>|V|PR|3P|IND|@FS-KOMP<": {POS: VERB},
    "<cjt>|<mv>|V|PR|3P|IND|@FS-N<": {POS: VERB},
    "<cjt>|<mv>|V|PR|3P|IND|@FS-N<PRED": {POS: VERB},
    "<cjt>|<mv>|V|PR|3P|IND|@FS-P<": {POS: VERB},
    "<cjt>|<mv>|V|PR|3P|IND|@FS-QUE": {POS: AUX},
    "<cjt>|<mv>|V|PR|3P|IND|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|V|PR|3P|IND|@N<": {POS: VERB},
    "<cjt>|<mv>|V|PR|3P|IND|@NPHR": {POS: AUX},
    "<cjt>|<mv>|V|PR|3P|SUBJ|@FS-<ACC": {POS: VERB},
    "<cjt>|<mv>|V|PR|3P|SUBJ|@FS-<ADVL": {POS: VERB},
    "<cjt>|<mv>|V|PR|3P|SUBJ|@FS-N<": {POS: VERB},
    "<cjt>|<mv>|V|PR|3P|SUBJ|@FS-P<": {POS: VERB},
    "<cjt>|<mv>|V|PR|3P|SUBJ|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|IND|@FS-<ACC": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|IND|@FS-<ADVL": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|IND|@FS-<PIV": {POS: AUX},
    "<cjt>|<mv>|V|PR|3S|IND|@FS-<SC": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|IND|@FS-<SUBJ": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|IND|@FS-A<": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|IND|@FS-ACC>": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|IND|@FS-ADVL>": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|IND|@FS-APP": {POS: AUX},
    "<cjt>|<mv>|V|PR|3S|IND|@FS-N<": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|IND|@FS-N<PRED": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|IND|@FS-P<": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|IND|@FS-QUE": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|IND|@FS-S<": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|IND|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|IND|@FS-SUBJ>": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|IND|@ICL-ADVL>": {POS: AUX},
    "<cjt>|<mv>|V|PR|3S|IND|@ICL-AUX<": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|IND|@N<ARG": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|IND|@N<PRED": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|IND|@NPHR": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|IND|@P<": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|IND|@STA": {POS: AUX},
    "<cjt>|<mv>|V|PR|3S|SUBJ|@FS-<ACC": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|SUBJ|@FS-<ADVL": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|SUBJ|@FS-<SC": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|SUBJ|@FS-<SUBJ": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|SUBJ|@FS-COM<": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|SUBJ|@FS-N<": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|SUBJ|@FS-P<": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|SUBJ|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|SUBJ|@ICL-N<": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|SUBJ|@ICL-P<": {POS: VERB},
    "<cjt>|<mv>|V|PR|3S|SUBJ|@N<": {POS: VERB},
    "<cjt>|<mv>|V|PS/MQP|3P|IND|@FS-<ACC": {POS: VERB},
    "<cjt>|<mv>|V|PS/MQP|3P|IND|@FS-N<PRED": {POS: VERB},
    "<cjt>|<mv>|V|PS/MQP|3P|IND|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|V|PS/MQP|3P|IND|@ICL-N<PRED": {POS: VERB},
    "<cjt>|<mv>|V|PS/MQP|3P|IND|@N<PRED": {POS: VERB},
    "<cjt>|<mv>|V|PS|1P|IND|@FS-<ACC": {POS: VERB},
    "<cjt>|<mv>|V|PS|1P|IND|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|V|PS|1S|IND|@FS-<ACC": {POS: VERB},
    "<cjt>|<mv>|V|PS|1S|IND|@FS-<ADVL": {POS: VERB},
    "<cjt>|<mv>|V|PS|1S|IND|@FS-ACC>": {POS: VERB},
    "<cjt>|<mv>|V|PS|1S|IND|@FS-ADVL>": {POS: VERB},
    "<cjt>|<mv>|V|PS|1S|IND|@FS-N<": {POS: VERB},
    "<cjt>|<mv>|V|PS|1S|IND|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|V|PS|3P|IND|@FS-<ACC": {POS: VERB},
    "<cjt>|<mv>|V|PS|3P|IND|@FS-<ADVL": {POS: VERB},
    "<cjt>|<mv>|V|PS|3P|IND|@FS-ACC>": {POS: VERB},
    "<cjt>|<mv>|V|PS|3P|IND|@FS-N<": {POS: VERB},
    "<cjt>|<mv>|V|PS|3P|IND|@FS-QUE": {POS: AUX},
    "<cjt>|<mv>|V|PS|3P|IND|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|V|PS|3S|IND|@<ADVL": {POS: VERB},
    "<cjt>|<mv>|V|PS|3S|IND|@FS-<ACC": {POS: VERB},
    "<cjt>|<mv>|V|PS|3S|IND|@FS-<ADVL": {POS: VERB},
    "<cjt>|<mv>|V|PS|3S|IND|@FS-ACC>": {POS: VERB},
    "<cjt>|<mv>|V|PS|3S|IND|@FS-ADVL>": {POS: VERB},
    "<cjt>|<mv>|V|PS|3S|IND|@FS-KOMP<": {POS: VERB},
    "<cjt>|<mv>|V|PS|3S|IND|@FS-N<": {POS: VERB},
    "<cjt>|<mv>|V|PS|3S|IND|@FS-N<PRED": {POS: VERB},
    "<cjt>|<mv>|V|PS|3S|IND|@FS-P<": {POS: VERB},
    "<cjt>|<mv>|V|PS|3S|IND|@FS-S<": {POS: VERB},
    "<cjt>|<mv>|V|PS|3S|IND|@FS-STA": {POS: VERB},
    "<cjt>|<mv>|V|PS|3S|IND|@FS-UTT": {POS: VERB},
    "<cjt>|<mv>|V|PS|3S|IND|@ICL-N<": {POS: VERB},
    "<cjt>|<mv>|V|PS|3S|IND|@ICL-N<PRED": {POS: VERB},
    "<cjt>|<mv>|V|PS|3S|IND|@ICL-QUE": {POS: VERB},
    "<cjt>|<mv>|V|PS|3S|IND|@ICL-STA": {POS: VERB},
    "<cjt>|<mv>|V|PS|3S|IND|@N<PRED": {POS: VERB},
    "<cjt>|<n>|<NUM-ord>|ADJ|M|S|@P<": {POS: ADJ},
    "<cjt>|<n>|<np-def>|ADJ|F|P|@<SUBJ": {POS: ADJ},
    "<cjt>|<n>|<np-def>|ADJ|F|S|@<ACC": {POS: ADJ},
    "<cjt>|<n>|<np-def>|ADJ|M|P|@<ACC": {POS: ADJ},
    "<cjt>|<n>|<np-def>|ADJ|M|P|@<SUBJ": {POS: ADJ},
    "<cjt>|<n>|<np-def>|ADJ|M|P|@ACC>": {POS: ADJ},
    "<cjt>|<n>|<np-def>|ADJ|M|P|@N<PRED": {POS: ADJ},
    "<cjt>|<n>|<np-def>|ADJ|M|P|@P<": {POS: ADJ},
    "<cjt>|<n>|<np-def>|ADJ|M|S|@<ACC": {POS: ADJ},
    "<cjt>|<n>|<np-def>|ADJ|M|S|@<SC": {POS: ADJ},
    "<cjt>|<n>|<np-def>|ADJ|M|S|@APP": {POS: ADJ},
    "<cjt>|<n>|<np-def>|ADJ|M|S|@NPHR": {POS: ADJ},
    "<cjt>|<n>|<np-def>|ADJ|M|S|@P<": {POS: ADJ},
    "<cjt>|<n>|<np-idf>|ADJ|F|S|@N<PRED": {POS: ADJ},
    "<cjt>|<n>|<np-idf>|ADJ|M|S|@SC>": {POS: ADJ},
    "<cjt>|<n>|ADJ|F|P|@SUBJ>": {POS: ADJ},
    "<cjt>|<n>|ADJ|F|S|@N<PRED": {POS: ADJ},
    "<cjt>|<n>|ADJ|F|S|@P<": {POS: ADJ},
    "<cjt>|<n>|ADJ|M/F|P|@SUBJ>": {POS: ADJ},
    "<cjt>|<n>|ADJ|M|P|@<SUBJ": {POS: ADJ},
    "<cjt>|<n>|ADJ|M|P|@APP": {POS: ADJ},
    "<cjt>|<n>|ADJ|M|P|@P<": {POS: ADJ},
    "<cjt>|<n>|ADJ|M|P|@SUBJ>": {POS: ADJ},
    "<cjt>|<n>|ADJ|M|S|@P<": {POS: ADJ},
    "<cjt>|<n>|ADJ|M|S|@SUBJ>": {POS: ADJ},
    "<cjt>|<n>|V|PCP|M|P|@<SUBJ": {POS: VERB},
    "<cjt>|<n>|V|PCP|M|P|@N<PRED": {POS: VERB},
    "<cjt>|<n>|V|PCP|M|P|@P<": {POS: VERB},
    "<cjt>|<n>|V|PCP|M|P|@SUBJ>": {POS: VERB},
    "<cjt>|<n>|V|PCP|M|S|@<SC": {POS: ADJ},
    "<cjt>|<np-def>|ADJ|M|S|@N<PRED": {POS: ADJ},
    "<cjt>|<np-def>|N|F|P|@<ACC": {POS: NOUN},
    "<cjt>|<np-def>|N|F|P|@<SC": {POS: NOUN},
    "<cjt>|<np-def>|N|F|P|@<SUBJ": {POS: NOUN},
    "<cjt>|<np-def>|N|F|P|@ACC>": {POS: NOUN},
    "<cjt>|<np-def>|N|F|P|@APP": {POS: NOUN},
    "<cjt>|<np-def>|N|F|P|@N<PRED": {POS: NOUN},
    "<cjt>|<np-def>|N|F|P|@P<": {POS: NOUN},
    "<cjt>|<np-def>|N|F|P|@SUBJ>": {POS: NOUN},
    "<cjt>|<np-def>|N|F|S|@<ACC": {POS: NOUN},
    "<cjt>|<np-def>|N|F|S|@<ADVL": {POS: NOUN},
    "<cjt>|<np-def>|N|F|S|@<OC": {POS: NOUN},
    "<cjt>|<np-def>|N|F|S|@<SC": {POS: NOUN},
    "<cjt>|<np-def>|N|F|S|@<SUBJ": {POS: NOUN},
    "<cjt>|<np-def>|N|F|S|@ACC>": {POS: NOUN},
    "<cjt>|<np-def>|N|F|S|@APP": {POS: NOUN},
    "<cjt>|<np-def>|N|F|S|@ICL-APP": {POS: NOUN},
    "<cjt>|<np-def>|N|F|S|@N<": {POS: NOUN},
    "<cjt>|<np-def>|N|F|S|@N<PRED": {POS: NOUN},
    "<cjt>|<np-def>|N|F|S|@P<": {POS: NOUN},
    "<cjt>|<np-def>|N|F|S|@SUBJ>": {POS: NOUN},
    "<cjt>|<np-def>|N|M|P|@<ACC": {POS: SYM},
    "<cjt>|<np-def>|N|M|P|@<ADVL": {POS: NOUN},
    "<cjt>|<np-def>|N|M|P|@<SC": {POS: NOUN},
    "<cjt>|<np-def>|N|M|P|@<SUBJ": {POS: NOUN},
    "<cjt>|<np-def>|N|M|P|@APP": {POS: NOUN},
    "<cjt>|<np-def>|N|M|P|@FS-N<": {POS: NOUN},
    "<cjt>|<np-def>|N|M|P|@N<": {POS: NOUN},
    "<cjt>|<np-def>|N|M|P|@N<PRED": {POS: SYM},
    "<cjt>|<np-def>|N|M|P|@P<": {POS: SYM},
    "<cjt>|<np-def>|N|M|P|@SUBJ>": {POS: NOUN},
    "<cjt>|<np-def>|N|M|S|@<ACC": {POS: NOUN},
    "<cjt>|<np-def>|N|M|S|@<ADVL": {POS: NOUN},
    "<cjt>|<np-def>|N|M|S|@<SC": {POS: NOUN},
    "<cjt>|<np-def>|N|M|S|@<SUBJ": {POS: NOUN},
    "<cjt>|<np-def>|N|M|S|@ACC>": {POS: NOUN},
    "<cjt>|<np-def>|N|M|S|@APP": {POS: NOUN},
    "<cjt>|<np-def>|N|M|S|@FS-STA": {POS: NOUN},
    "<cjt>|<np-def>|N|M|S|@ICL-<ACC": {POS: NOUN},
    "<cjt>|<np-def>|N|M|S|@ICL-PRED>": {POS: NOUN},
    "<cjt>|<np-def>|N|M|S|@KOMP<": {POS: NOUN},
    "<cjt>|<np-def>|N|M|S|@N<PRED": {POS: NOUN},
    "<cjt>|<np-def>|N|M|S|@NPHR": {POS: NOUN},
    "<cjt>|<np-def>|N|M|S|@P<": {POS: NOUN},
    "<cjt>|<np-def>|N|M|S|@SC>": {POS: NOUN},
    "<cjt>|<np-def>|N|M|S|@SUBJ>": {POS: NOUN},
    "<cjt>|<np-idf>|ADJ|M|P|@<ADVL": {POS: ADJ},
    "<cjt>|<np-idf>|ADJ|M|S|@N<PRED": {POS: ADJ},
    "<cjt>|<np-idf>|N|F|P|@<ACC": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|P|@<ADVL": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|P|@<OC": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|P|@<SC": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|P|@<SUBJ": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|P|@ACC>": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|P|@APP": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|P|@N<": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|P|@N<PRED": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|P|@NPHR": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|P|@P<": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|P|@PASS": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|P|@SUBJ>": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|S|@<ACC": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|S|@<ADVL": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|S|@<OC": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|S|@<SC": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|S|@<SUBJ": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|S|@ACC>": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|S|@ADVL": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|S|@APP": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|S|@FS-S<": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|S|@ICL-APP": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|S|@N<": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|S|@N<PRED": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|S|@NPHR": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|S|@P<": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|S|@PRED>": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|S|@SC>": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|S|@SUBJ>": {POS: NOUN},
    "<cjt>|<np-idf>|N|F|S|@VOK": {POS: NOUN},
    "<cjt>|<np-idf>|N|M/F|P|@P<": {POS: NOUN},
    "<cjt>|<np-idf>|N|M|P|@<ACC": {POS: NOUN},
    "<cjt>|<np-idf>|N|M|P|@<OC": {POS: NOUN},
    "<cjt>|<np-idf>|N|M|P|@<SC": {POS: NOUN},
    "<cjt>|<np-idf>|N|M|P|@<SUBJ": {POS: NOUN},
    "<cjt>|<np-idf>|N|M|P|@ACC>": {POS: NOUN},
    "<cjt>|<np-idf>|N|M|P|@APP": {POS: NOUN},
    "<cjt>|<np-idf>|N|M|P|@ICL-<SC": {POS: NOUN},
    "<cjt>|<np-idf>|N|M|P|@ICL-N<": {POS: NOUN},
    "<cjt>|<np-idf>|N|M|P|@N<": {POS: NOUN},
    "<cjt>|<np-idf>|N|M|P|@N<PRED": {POS: NOUN},
    "<cjt>|<np-idf>|N|M|P|@NPHR": {POS: NOUN},
    "<cjt>|<np-idf>|N|M|P|@P<": {POS: NOUN},
    "<cjt>|<np-idf>|N|M|P|@SUBJ>": {POS: NOUN},
    "<cjt>|<np-idf>|N|M|S|@<ACC": {POS: NOUN},
    "<cjt>|<np-idf>|N|M|S|@<ADVL": {POS: NOUN},
    "<cjt>|<np-idf>|N|M|S|@<SC": {POS: NOUN},
    "<cjt>|<np-idf>|N|M|S|@<SUBJ": {POS: NOUN},
    "<cjt>|<np-idf>|N|M|S|@ACC>": {POS: NOUN},
    "<cjt>|<np-idf>|N|M|S|@ADVL": {POS: NOUN},
    "<cjt>|<np-idf>|N|M|S|@ADVL>": {POS: NOUN},
    "<cjt>|<np-idf>|N|M|S|@APP": {POS: NOUN},
    "<cjt>|<np-idf>|N|M|S|@N<": {POS: NOUN},
    "<cjt>|<np-idf>|N|M|S|@N<PRED": {POS: NOUN},
    "<cjt>|<np-idf>|N|M|S|@NPHR": {POS: NOUN},
    "<cjt>|<np-idf>|N|M|S|@P<": {POS: NOUN},
    "<cjt>|<np-idf>|N|M|S|@PRED>": {POS: NOUN},
    "<cjt>|<np-idf>|N|M|S|@STA": {POS: NOUN},
    "<cjt>|<np-idf>|N|M|S|@SUBJ>": {POS: NOUN},
    "<cjt>|<poss>|DET|F|S|@>N": {POS: DET},
    "<cjt>|<poss>|DET|M|S|@P<": {POS: PRON},
    "<cjt>|<prd>|PRP|@<ADVL": {POS: ADP},
    "<cjt>|<prd>|PRP|@<OC": {POS: ADP},
    "<cjt>|<prd>|PRP|@<SC": {POS: ADP},
    "<cjt>|<prop>|<np-def>|N|F|S|@SUBJ>": {POS: NOUN},
    "<cjt>|<prop>|<np-def>|N|M|S|@<ACC": {POS: NOUN},
    "<cjt>|<prop>|<np-def>|N|M|S|@<SUBJ": {POS: NOUN},
    "<cjt>|<prop>|<np-def>|N|M|S|@NPHR": {POS: NOUN},
    "<cjt>|<prop>|<np-def>|N|M|S|@P<": {POS: NOUN},
    "<cjt>|<prop>|<np-idf>|N|F|S|@N<": {POS: NOUN},
    "<cjt>|<prop>|<np-idf>|N|F|S|@P<": {POS: NOUN},
    "<cjt>|<prop>|<np-idf>|N|F|S|@SUBJ>": {POS: NOUN},
    "<cjt>|<prop>|<np-idf>|N|M|S|@N<": {POS: NOUN},
    "<cjt>|<prop>|<np-idf>|N|M|S|@P<": {POS: NOUN},
    "<cjt>|<prp>|<rel>|<first-cjt>|ADV|@P<": {POS: ADV},
    "<cjt>|<prp>|<rel>|ADV|@N<PRED": {POS: ADV},
    "<cjt>|<quant>|<first-cjt>|DET|F|P|@FS-STA": {POS: DET},
    "<cjt>|<quant>|<rel>|ADV|@ADVL": {POS: ADV},
    "<cjt>|<quant>|ADV|@<ADVL": {POS: ADV},
    "<cjt>|<quant>|ADV|@>A": {POS: ADV},
    "<cjt>|<quant>|ADV|@P<": {POS: ADV},
    "<cjt>|<quant>|DET|F|P|@>N": {POS: DET},
    "<cjt>|<quant>|DET|F|P|@N<PRED": {POS: DET},
    "<cjt>|<quant>|DET|M|P|@>N": {POS: DET},
    "<cjt>|<quant>|DET|M|P|@N<PRED": {POS: DET},
    "<cjt>|<quant>|DET|M|P|@P<": {POS: PRON},
    "<cjt>|<quant>|DET|M|P|@SUBJ>": {POS: PRON},
    "<cjt>|<quant>|DET|M|S|@<ACC": {POS: PRON},
    "<cjt>|<quant>|DET|M|S|@<SC": {POS: PRON},
    "<cjt>|<quant>|DET|M|S|@>N": {POS: DET},
    "<cjt>|<quant>|INDP|M|S|@<ACC": {POS: PRON},
    "<cjt>|<quant>|INDP|M|S|@<SC": {POS: PRON},
    "<cjt>|<quant>|INDP|M|S|@P<": {POS: PRON},
    "<cjt>|<rel>|<first-cjt>|PRP|@FS-STA": {POS: ADP},
    "<cjt>|<sam->|<komp>|PRP|@KOMP<": {POS: ADP},
    "<cjt>|<sam->|PRP|@<ACC": {POS: ADP},
    "<cjt>|<sam->|PRP|@<ADVL": {POS: ADP},
    "<cjt>|<sam->|PRP|@<PIV": {POS: ADP},
    "<cjt>|<sam->|PRP|@<SA": {POS: ADP},
    "<cjt>|<sam->|PRP|@<SC": {POS: ADP},
    "<cjt>|<sam->|PRP|@<SUBJ": {POS: ADP},
    "<cjt>|<sam->|PRP|@A<": {POS: ADP},
    "<cjt>|<sam->|PRP|@ADVL": {POS: ADP},
    "<cjt>|<sam->|PRP|@ADVL>": {POS: ADP},
    "<cjt>|<sam->|PRP|@CJT": {POS: ADP},
    "<cjt>|<sam->|PRP|@KOMP<": {POS: ADP},
    "<cjt>|<sam->|PRP|@N<": {POS: ADP},
    "<cjt>|<sam->|PRP|@N<PRED": {POS: ADP},
    "<cjt>|<sam->|PRP|@P<": {POS: ADP},
    "<cjt>|<sam->|PRP|@PASS": {POS: ADP},
    "<cjt>|<sam->|PRP|@PIV>": {POS: ADP},
    "<cjt>|<sam->|PRP|@PRED>": {POS: ADP},
    "<cjt>|<year>|<card>|<date>|NUM|M|P|@P<": {POS: NUM},
    "<cjt>|<year>|<card>|<date>|NUM|M|S|@P<": {POS: NUM},
    "<cjt>|<year>|<card>|NUM|M|S|@P<": {POS: NUM},
    "<cjt>|<year>|<date>|NUM|M|P|@P<": {POS: NUM},
    "<cjt>|<year>|<date>|NUM|M|S|@P<": {POS: NUM},
    "<cjt>|ADJ|F|P|@<ADVL": {POS: ADJ},
    "<cjt>|ADJ|F|P|@<SC": {POS: ADJ},
    "<cjt>|ADJ|F|P|@>N": {POS: ADJ},
    "<cjt>|ADJ|F|P|@APP": {POS: ADJ},
    "<cjt>|ADJ|F|P|@ICL-<SC": {POS: ADJ},
    "<cjt>|ADJ|F|P|@N<": {POS: ADJ},
    "<cjt>|ADJ|F|P|@N<PRED": {POS: ADJ},
    "<cjt>|ADJ|F|S|@<OC": {POS: ADJ},
    "<cjt>|ADJ|F|S|@<SC": {POS: ADJ},
    "<cjt>|ADJ|F|S|@>N": {POS: ADJ},
    "<cjt>|ADJ|F|S|@ICL-N<": {POS: ADJ},
    "<cjt>|ADJ|F|S|@N<": {POS: ADJ},
    "<cjt>|ADJ|F|S|@PRED>": {POS: ADJ},
    "<cjt>|ADJ|M/F|P|@N<": {POS: ADJ},
    "<cjt>|ADJ|M/F|S|@<OC": {POS: ADJ},
    "<cjt>|ADJ|M|P|@<SC": {POS: ADJ},
    "<cjt>|ADJ|M|P|@>N": {POS: ADJ},
    "<cjt>|ADJ|M|P|@N<": {POS: ADJ},
    "<cjt>|ADJ|M|P|@N<PRED": {POS: ADJ},
    "<cjt>|ADJ|M|P|@P<": {POS: ADJ},
    "<cjt>|ADJ|M|S|@<ACC": {POS: ADJ},
    "<cjt>|ADJ|M|S|@<ADVL": {POS: ADJ},
    "<cjt>|ADJ|M|S|@<SC": {POS: ADJ},
    "<cjt>|ADJ|M|S|@>N": {POS: ADJ},
    "<cjt>|ADJ|M|S|@ICL-<SC": {POS: ADJ},
    "<cjt>|ADJ|M|S|@ICL-N<": {POS: ADJ},
    "<cjt>|ADJ|M|S|@ICL-N<PRED": {POS: ADJ},
    "<cjt>|ADJ|M|S|@N<": {POS: ADJ},
    "<cjt>|ADJ|M|S|@N<PRED": {POS: ADJ},
    "<cjt>|ADJ|M|S|@NPHR": {POS: ADJ},
    "<cjt>|ADJ|M|S|@P<": {POS: ADJ},
    "<cjt>|ADJ|M|S|@PRED>": {POS: ADJ},
    "<cjt>|ADV|@<ADVL": {POS: ADV},
    "<cjt>|ADV|@<PIV": {POS: ADV},
    "<cjt>|ADV|@>N": {POS: ADV},
    "<cjt>|ADV|@ADVL": {POS: ADV},
    "<cjt>|ADV|@ADVL>": {POS: ADV},
    "<cjt>|ADV|@AS<": {POS: ADV},
    "<cjt>|ADV|@FS-N<": {POS: ADV},
    "<cjt>|ADV|@FS-STA": {POS: ADV},
    "<cjt>|ADV|@ICL-<ACC": {POS: ADV},
    "<cjt>|ADV|@P<": {POS: ADV},
    "<cjt>|KS|@SUB": {POS: SCONJ},
    "<cjt>|NUM|M|P|@P<": {POS: NUM},
    "<cjt>|NUM|M|S|@P<": {POS: NUM},
    "<cjt>|PERS|F|1S|NOM|@FS-STA": {POS: PRON},
    "<cjt>|PERS|F|3S|NOM|@NPHR": {POS: PRON},
    "<cjt>|PERS|F|3S|NOM|@SUBJ>": {POS: PRON},
    "<cjt>|PERS|M|3S|NOM|@<SUBJ": {POS: PRON},
    "<cjt>|PROP|F|P|@P<": {POS: PROPN},
    "<cjt>|PROP|F|S|@<ACC": {POS: PROPN},
    "<cjt>|PROP|F|S|@<SA": {POS: PROPN},
    "<cjt>|PROP|F|S|@<SC": {POS: PROPN},
    "<cjt>|PROP|F|S|@<SUBJ": {POS: PROPN},
    "<cjt>|PROP|F|S|@APP": {POS: PROPN},
    "<cjt>|PROP|F|S|@N<": {POS: PROPN},
    "<cjt>|PROP|F|S|@N<PRED": {POS: PROPN},
    "<cjt>|PROP|F|S|@NPHR": {POS: PROPN},
    "<cjt>|PROP|F|S|@P<": {POS: PROPN},
    "<cjt>|PROP|F|S|@SUBJ>": {POS: PROPN},
    "<cjt>|PROP|M|P|@<ACC": {POS: PROPN},
    "<cjt>|PROP|M|P|@<SC": {POS: PROPN},
    "<cjt>|PROP|M|P|@P<": {POS: PROPN},
    "<cjt>|PROP|M|P|@SUBJ>": {POS: PROPN},
    "<cjt>|PROP|M|S|@<ACC": {POS: PROPN},
    "<cjt>|PROP|M|S|@<ADVL": {POS: PROPN},
    "<cjt>|PROP|M|S|@<SA": {POS: PROPN},
    "<cjt>|PROP|M|S|@<SC": {POS: PROPN},
    "<cjt>|PROP|M|S|@<SUBJ": {POS: PROPN},
    "<cjt>|PROP|M|S|@APP": {POS: PROPN},
    "<cjt>|PROP|M|S|@N<": {POS: PROPN},
    "<cjt>|PROP|M|S|@N<PRED": {POS: PROPN},
    "<cjt>|PROP|M|S|@NPHR": {POS: PROPN},
    "<cjt>|PROP|M|S|@P<": {POS: PROPN},
    "<cjt>|PROP|M|S|@SUBJ>": {POS: PROPN},
    "<cjt>|PRP|@<ACC": {POS: ADP},
    "<cjt>|PRP|@<ADVL": {POS: ADP},
    "<cjt>|PRP|@<OA": {POS: ADP},
    "<cjt>|PRP|@<OC": {POS: ADP},
    "<cjt>|PRP|@<PIV": {POS: ADP},
    "<cjt>|PRP|@<PRED": {POS: ADP},
    "<cjt>|PRP|@<SA": {POS: ADP},
    "<cjt>|PRP|@<SC": {POS: ADP},
    "<cjt>|PRP|@A<": {POS: ADP},
    "<cjt>|PRP|@A<ARG": {POS: ADP},
    "<cjt>|PRP|@ACC>": {POS: ADP},
    "<cjt>|PRP|@ADVL": {POS: ADP},
    "<cjt>|PRP|@ADVL>": {POS: ADP},
    "<cjt>|PRP|@AUX<": {POS: ADP},
    "<cjt>|PRP|@CO": {POS: ADP},
    "<cjt>|PRP|@FS-N<PRED": {POS: ADP},
    "<cjt>|PRP|@FS-STA": {POS: ADP},
    "<cjt>|PRP|@ICL-<ADVL": {POS: ADP},
    "<cjt>|PRP|@ICL-<SC": {POS: ADP},
    "<cjt>|PRP|@ICL-APP": {POS: ADP},
    "<cjt>|PRP|@ICL-N<": {POS: ADP},
    "<cjt>|PRP|@ICL-N<PRED": {POS: ADP},
    "<cjt>|PRP|@ICL-P<": {POS: ADP},
    "<cjt>|PRP|@ICL-PRED>": {POS: ADP},
    "<cjt>|PRP|@KOMP<": {POS: ADP},
    "<cjt>|PRP|@N<": {POS: ADP},
    "<cjt>|PRP|@N<ARG": {POS: ADP},
    "<cjt>|PRP|@N<PRED": {POS: ADP},
    "<cjt>|PRP|@P<": {POS: ADP},
    "<cjt>|PRP|@PASS": {POS: ADP},
    "<cjt>|PRP|@PIV>": {POS: ADP},
    "<cjt>|PRP|@PRED>": {POS: ADP},
    "<cjt>|PRP|@SUBJ>": {POS: ADP},
    "<cjt>|PRP|@UTT": {POS: ADP},
    "<cjt>|V|COND|3S|@FS-PAUX": {POS: VERB},
    "<cjt>|V|INF|@ICL-PMV": {POS: VERB},
    "<cjt>|V|PCP|F|P|@<ACC": {POS: VERB},
    "<cjt>|V|PCP|F|P|@>N": {POS: VERB},
    "<cjt>|V|PCP|F|S|@<ACC": {POS: VERB},
    "<cjt>|V|PCP|F|S|@>N": {POS: VERB},
    "<cjt>|V|PCP|F|S|@N<": {POS: VERB},
    "<cjt>|V|PCP|M|P|@<PRED": {POS: VERB},
    "<cjt>|V|PCP|M|P|@<SC": {POS: VERB},
    "<cjt>|V|PCP|M|P|@>N": {POS: VERB},
    "<cjt>|V|PCP|M|P|@N<": {POS: VERB},
    "<cjt>|V|PCP|M|P|@N<PRED": {POS: VERB},
    "<cjt>|V|PCP|M|P|@P<": {POS: VERB},
    "<cjt>|V|PCP|M|S|@<ADVL": {POS: VERB},
    "<cjt>|V|PCP|M|S|@<OC": {POS: VERB},
    "<cjt>|V|PCP|M|S|@>N": {POS: ADJ},
    "<cjt>|V|PCP|M|S|@N<": {POS: VERB},
    "<cjt>|V|PCP|M|S|@N<PRED": {POS: VERB},
    "<cjt>|V|PCP|M|S|@P<": {POS: VERB},
    "<co-a<>|<co-postad>|KC|@CO": {POS: CCONJ},
    "<co-a<>|<co-postnom>|KC|@CO": {POS: CCONJ},
    "<co-a<>|<kc>|ADV|@CO": {POS: ADV},
    "<co-a<>|KC|@CO": {POS: CCONJ},
    "<co-acc>|<co-app>|KC|@CO": {POS: CCONJ},
    "<co-acc>|<co-fmc>|<co-vfin>|<co-cu>|KC|@CO": {POS: CCONJ},
    "<co-acc>|<co-fmc>|<co-vfin>|<co-fcl>|KC|@CO": {POS: CCONJ},
    "<co-acc>|<co-fmc>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-acc>|<co-inf>|KC|@CO": {POS: CCONJ},
    "<co-acc>|<co-pred>|KC|@CO": {POS: CCONJ},
    "<co-acc>|<co-prparg>|KC|@CO": {POS: CCONJ},
    "<co-acc>|<co-vfin>|<co-fcl>|KC|@CO": {POS: CCONJ},
    "<co-acc>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-acc>|<kc>|ADV|@CO": {POS: ADV},
    "<co-acc>|ADV|@CO": {POS: ADV},
    "<co-acc>|KC|@CO": {POS: CCONJ},
    "<co-acl>|<co-acc>|KC|@CO": {POS: CCONJ},
    "<co-acl>|<co-advl>|KC|@CO": {POS: CCONJ},
    "<co-acl>|<co-oc>|KC|@CO": {POS: CCONJ},
    "<co-acl>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-acl>|KC|@CO": {POS: CCONJ},
    "<co-advl>|<co-acc>|KC|@CO": {POS: CCONJ},
    "<co-advl>|<co-acl>|KC|@CO": {POS: CCONJ},
    "<co-advl>|<co-cu>|KC|@CO": {POS: CCONJ},
    "<co-advl>|<co-fmc>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-advl>|<co-postnom>|KC|@CO": {POS: CCONJ},
    "<co-advl>|<co-prparg>|KC|@CO": {POS: CCONJ},
    "<co-advl>|<co-subj>|<co-acl>|KC|@CO": {POS: CCONJ},
    "<co-advl>|<co-subj>|KC|@CO": {POS: CCONJ},
    "<co-advl>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-advl>|<kc>|ADV|@CO": {POS: ADV},
    "<co-advl>|<parkc-2>|<co-sc>|ADV|@CO": {POS: ADV},
    "<co-advl>|<parkc-2>|<kc>|ADV|@CO": {POS: ADV},
    "<co-advl>|<prp>|<rel>|ADV|@CO": {POS: ADV},
    "<co-advl>|ADV|@CO": {POS: ADV},
    "<co-advl>|KC|@CO": {POS: CCONJ},
    "<co-advo>|KC|@CO": {POS: CCONJ},
    "<co-advs>|<co-advl>|KC|@CO": {POS: CCONJ},
    "<co-advs>|<co-postnom>|KC|@CO": {POS: CCONJ},
    "<co-advs>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-advs>|KC|@CO": {POS: CCONJ},
    "<co-app>|<co-acc>|KC|@CO": {POS: CCONJ},
    "<co-app>|<co-fcl>|KC|@CO": {POS: CCONJ},
    "<co-app>|<co-postnom>|KC|@CO": {POS: CCONJ},
    "<co-app>|<co-subj>|KC|@CO": {POS: CCONJ},
    "<co-app>|KC|@CO": {POS: CCONJ},
    "<co-as<>|KC|@CO": {POS: CCONJ},
    "<co-aux<>|<co-pcp>|<co-pcv>|KC|@CO": {POS: CCONJ},
    "<co-aux<>|<co-pcp>|KC|@CO": {POS: CCONJ},
    "<co-cjt>|<co-acc>|KC|@CO": {POS: CCONJ},
    "<co-cjt>|<co-fmc>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-cjt>|<co-piv>|KC|@CO": {POS: CCONJ},
    "<co-cjt>|<co-postnom>|KC|@CO": {POS: CCONJ},
    "<co-cjt>|<co-pred>|KC|@CO": {POS: CCONJ},
    "<co-cjt>|<co-prparg>|KC|@CO": {POS: CCONJ},
    "<co-cjt>|<co-subj>|KC|@CO": {POS: CCONJ},
    "<co-cjt>|KC|@CO": {POS: CCONJ},
    "<co-cu>|<co-fmc>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-cu>|<co-inf>|KC|@CO": {POS: CCONJ},
    "<co-fcl>|<co-acc>|KC|@CO": {POS: CCONJ},
    "<co-fcl>|<co-advl>|KC|@CO": {POS: CCONJ},
    "<co-fcl>|<co-cu>|KC|@CO": {POS: CCONJ},
    "<co-fcl>|<co-fmc>|<co-inf>|KC|@CO": {POS: CCONJ},
    "<co-fcl>|<co-fmc>|<co-vfin>|<co-cu>|KC|@CO": {POS: CCONJ},
    "<co-fcl>|<co-fmc>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-fcl>|<co-fmv>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-fcl>|<co-inf>|KC|@CO": {POS: CCONJ},
    "<co-fcl>|<co-pcv>|KC|@CO": {POS: CCONJ},
    "<co-fcl>|<co-postnom>|KC|@CO": {POS: CCONJ},
    "<co-fcl>|<co-pred>|KC|@CO": {POS: CCONJ},
    "<co-fcl>|<co-prparg>|KC|@CO|<co-prparg>|<co-fcl>": {POS: CCONJ},
    "<co-fcl>|<co-sc>|KC|@CO": {POS: CCONJ},
    "<co-fcl>|<co-subj>|KC|@CO": {POS: CCONJ},
    "<co-fcl>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-fcl>|<co-vfin>|KC|@CO|<co-vfin>|<co-fcl>": {POS: CCONJ},
    "<co-fcl>|<co-vfinco-fmc>|KC|@CO": {POS: CCONJ},
    "<co-fcl>|<kc>|ADV|@CO": {POS: ADV},
    "<co-fcl>|<parkc-2>|KC|@CO": {POS: CCONJ},
    "<co-fcl>|<rel>|ADV|@CO": {POS: ADV},
    "<co-fcl>|KC|@CO": {POS: CCONJ},
    "<co-fmc>|<co-vfin>|<co-fcl>|KC|@CO": {POS: CCONJ},
    "<co-ger>|KC|@CO": {POS: CCONJ},
    "<co-icl>|<co-acc>|KC|@CO": {POS: CCONJ},
    "<co-icl>|<co-advl>|KC|@CO": {POS: CCONJ},
    "<co-icl>|<co-app>|KC|@CO": {POS: CCONJ},
    "<co-icl>|<co-cu>|KC|@CO": {POS: CCONJ},
    "<co-icl>|<co-fmc>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-icl>|<co-ger>|KC|@CO": {POS: CCONJ},
    "<co-icl>|<co-inf>|KC|@CO": {POS: CCONJ},
    "<co-icl>|<co-pcv>|KC|@CO": {POS: CCONJ},
    "<co-icl>|<co-postnom>|KC|@CO": {POS: CCONJ},
    "<co-icl>|<co-pred>|KC|@CO": {POS: CCONJ},
    "<co-icl>|<co-prenom>|KC|@CO": {POS: CCONJ},
    "<co-icl>|<co-prparg>|KC|@CO": {POS: CCONJ},
    "<co-icl>|<co-sc>|KC|@CO": {POS: CCONJ},
    "<co-icl>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-icl>|<kc>|ADV|@CO": {POS: ADV},
    "<co-icl>|KC|@CO": {POS: CCONJ},
    "<co-inf>|<co-aux<>|KC|@CO": {POS: CCONJ},
    "<co-inf>|<co-icl>|KC|@CO": {POS: CCONJ},
    "<co-inf>|<co-sta>|KC|@CO": {POS: CCONJ},
    "<co-inf>|KC|@CO": {POS: CCONJ},
    "<co-komp<>|<co-fmc>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-komp<>|KC|@CO": {POS: CCONJ},
    "<co-n<>|<co-postnom>|KC|@CO": {POS: CCONJ},
    "<co-n<>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-n<pred>|<co-acc>|KC|@CO": {POS: CCONJ},
    "<co-n<pred>|<co-advl>|KC|@CO": {POS: CCONJ},
    "<co-n<pred>|<co-fmc>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-n<pred>|<co-postnom>|KC|@CO": {POS: CCONJ},
    "<co-n<pred>|<co-pred>|KC|@CO": {POS: CCONJ},
    "<co-n<pred>|<co-prparg>|KC|@CO": {POS: CCONJ},
    "<co-n<pred>|<co-subj>|KC|@CO": {POS: CCONJ},
    "<co-n<pred>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-n<pred>|KC|@CO": {POS: CCONJ},
    "<co-n>|<co-advl>|KC|@CO": {POS: CCONJ},
    "<co-n>|<co-prenom>|KC|@CO": {POS: CCONJ},
    "<co-n>|KC|@CO": {POS: CCONJ},
    "<co-oc>|KC|@CO": {POS: CCONJ},
    "<co-p<>|<co-prparg>|KC|@CO": {POS: CCONJ},
    "<co-p<>|<co-prparg>|KS|@CO": {POS: SCONJ},
    "<co-p<>|KC|@CO": {POS: CCONJ},
    "<co-pass>|<co-prparg>|KC|@CO": {POS: CCONJ},
    "<co-pass>|<kc>|ADV|@CO": {POS: ADV},
    "<co-pass>|KC|@CO": {POS: CCONJ},
    "<co-pcp>|<co-aux<>|KC|@CO": {POS: CCONJ},
    "<co-pcp>|<co-paux>|KC|@CO": {POS: CCONJ},
    "<co-pcp>|<co-pcv>|<co-aux<>|KC|@CO": {POS: CCONJ},
    "<co-pcp>|<co-pcv>|<co-sta>|KC|@CO": {POS: CCONJ},
    "<co-pcp>|<co-pcv>|KC|@CO": {POS: CCONJ},
    "<co-pcp>|KC|@CO": {POS: CCONJ},
    "<co-pcv>|<co-aux<>|KC|@CO": {POS: CCONJ},
    "<co-pcv>|<co-icl>|KC|@CO": {POS: CCONJ},
    "<co-pcv>|KC|@CO": {POS: CCONJ},
    "<co-piv>|<co-acc>|KC|@CO": {POS: CCONJ},
    "<co-piv>|<co-advl>|KC|@CO": {POS: CCONJ},
    "<co-piv>|<co-cu>|KC|@CO": {POS: CCONJ},
    "<co-piv>|<co-fmc>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-piv>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-piv>|KC|@CO": {POS: CCONJ},
    "<co-postnom>|<co-acc>|KC|@CO": {POS: CCONJ},
    "<co-postnom>|<co-advl>|KC|@CO": {POS: CCONJ},
    "<co-postnom>|<co-app>|KC|@CO": {POS: CCONJ},
    "<co-postnom>|<co-cu>|KC|@CO": {POS: CCONJ},
    "<co-postnom>|<co-fmc>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-postnom>|<co-piv>|KC|@CO": {POS: CCONJ},
    "<co-postnom>|<co-pred>|KC|@CO": {POS: CCONJ},
    "<co-postnom>|<co-prparg>|KC|@CO": {POS: CCONJ},
    "<co-postnom>|<co-sc>|KC|@CO": {POS: CCONJ},
    "<co-postnom>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-postnom>|<kc>|ADV|@CO": {POS: ADV},
    "<co-postnom>|<parkc-1>|<co-inf>|KC|@CO": {POS: CCONJ},
    "<co-postnom>|<parkc-2>|<co-advl>|ADV|@CO": {POS: ADV},
    "<co-postnom>|<parkc-2>|<co-inf>|KC|@CO": {POS: CCONJ},
    "<co-postnom>|<prp>|<rel>|ADV|@CO": {POS: ADV},
    "<co-postnom>|<rel>|ADV|@CO": {POS: ADV},
    "<co-postnom>|KC|@CO": {POS: CCONJ},
    "<co-pp>|KC|@CO": {POS: CCONJ},
    "<co-pred>|<co-subj>|KC|@CO": {POS: CCONJ},
    "<co-pred>|KC|@CO": {POS: CCONJ},
    "<co-prenom>|<co-n>|KC|@CO": {POS: CCONJ},
    "<co-prenom>|KC|@CO": {POS: CCONJ},
    "<co-prparg>|<co-acc>|KC|@CO": {POS: CCONJ},
    "<co-prparg>|<co-acl>|KC|@CO": {POS: CCONJ},
    "<co-prparg>|<co-advl>|KC|@CO": {POS: CCONJ},
    "<co-prparg>|<co-cu>|KC|@CO": {POS: CCONJ},
    "<co-prparg>|<co-fcl>|KC|@CO": {POS: CCONJ},
    "<co-prparg>|<co-fmc>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-prparg>|<co-inf>|KC|@CO": {POS: CCONJ},
    "<co-prparg>|<co-postnom>|KC|@CO": {POS: CCONJ},
    "<co-prparg>|<co-prenom>|KC|@CO": {POS: CCONJ},
    "<co-prparg>|<co-sc>|KC|@CO": {POS: CCONJ},
    "<co-prparg>|<co-subj>|KC|@CO": {POS: CCONJ},
    "<co-prparg>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-prparg>|<kc>|ADV|@CO": {POS: ADV},
    "<co-prparg>|ADV|@CO": {POS: ADV},
    "<co-prparg>|KC|@CO": {POS: CCONJ},
    "<co-que>|KC|@CO": {POS: CCONJ},
    "<co-sc>|<co-cu>|KC|@CO": {POS: CCONJ},
    "<co-sc>|<co-prparg>|<co-cu>|KC|@CO": {POS: CCONJ},
    "<co-sc>|<kc>|ADV|@CO": {POS: ADV},
    "<co-sc>|<parkc-1>|KC|@CO": {POS: CCONJ},
    "<co-sc>|ADV|@CO": {POS: ADV},
    "<co-sc>|KC|@CO": {POS: CCONJ},
    "<co-sta>|<co-advl>|KC|@CO": {POS: CCONJ},
    "<co-sta>|<co-fmc>|<co-inf>|KC|@CO": {POS: CCONJ},
    "<co-sta>|<co-fmc>|<co-vfin>|<co-fcl>|KC|@CO": {POS: CCONJ},
    "<co-sta>|<co-fmc>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-sta>|<co-ger>|KC|@CO": {POS: CCONJ},
    "<co-sta>|<co-inf>|KC|@CO": {POS: CCONJ},
    "<co-sta>|<co-pcv>|KC|@CO": {POS: CCONJ},
    "<co-sta>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-sta>|<kc>|ADV|@CO": {POS: ADV},
    "<co-sta>|KC|@CO": {POS: CCONJ},
    "<co-subj>|<co-acc>|KC|@CO": {POS: CCONJ},
    "<co-subj>|<co-cu>|KC|@CO": {POS: CCONJ},
    "<co-subj>|<co-fmc>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-subj>|<co-postnom>|KC|@CO": {POS: CCONJ},
    "<co-subj>|<co-prparg>|KC|@CO": {POS: CCONJ},
    "<co-subj>|<co-sc>|KC|@CO": {POS: CCONJ},
    "<co-subj>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-subj>|<parkc-2>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-subj>|<parkc-2>|KC|@CO": {POS: CCONJ},
    "<co-subj>|<quant>|ADV|@CO": {POS: ADV},
    "<co-subj>|KC|@CO": {POS: CCONJ},
    "<co-utt>|<co-advl>|KC|@CO": {POS: CCONJ},
    "<co-utt>|<co-fmc>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-utt>|<co-prenom>|KC|@CO": {POS: CCONJ},
    "<co-utt>|KC|@CO": {POS: CCONJ},
    "<co-vfin>|<co-fcl>|KC|@CO": {POS: CCONJ},
    "<co-vfin>|<co-icl>|KC|@CO": {POS: CCONJ},
    "<co-vfin>|<parkc-1>|KC|@CO": {POS: CCONJ},
    "<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-vp>|<co-aux<>|KC|@CO": {POS: CCONJ},
    "<co-vp>|<co-fmc>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-vp>|<co-pcv>|KC|@CO": {POS: CCONJ},
    "<co-vp>|<co-vfin>|<co-fcl>|<co-sta>|KC|@CO": {POS: CCONJ},
    "<co-vp>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-vp>|KC|@CO": {POS: CCONJ},
    "<co-x>|<co-fmc>|<co-vfin>|KC|@CO": {POS: CCONJ},
    "<co-x>|KC|@CO": {POS: CCONJ},
    "<com>|<np-def>|N|F|P|@P<": {POS: NOUN},
    "<com>|<np-def>|N|F|S|@P<": {POS: NOUN},
    "<com>|<np-idf>|N|F|S|@NPHR": {POS: NOUN},
    "<com>|<np-idf>|N|F|S|@P<": {POS: NOUN},
    "<com>|<np-idf>|N|F|S|@SUBJ>": {POS: NOUN},
    "<com>|ADV|@N<PRED": {POS: ADV},
    "<com>|PRP|@<ADVL": {POS: ADP},
    "<com>|PRP|@<OC": {POS: ADP},
    "<com>|PRP|@<SC": {POS: ADP},
    "<com>|PRP|@A<": {POS: ADP},
    "<com>|PRP|@ADVL>": {POS: ADP},
    "<com>|PRP|@COM": {POS: ADP},
    "<com>|PRP|@KOMP": {POS: ADP},
    "<com>|PRP|@KOMP<": {POS: ADP},
    "<com>|PRP|@KOMP>": {POS: ADP},
    "<com>|PRP|@N<": {POS: ADP},
    "<com>|PRP|@N<PRED": {POS: ADP},
    "<dem>|<-sam>|DET|F|P|@>N": {POS: DET},
    "<dem>|<-sam>|DET|F|S|@>N": {POS: DET},
    "<dem>|<-sam>|DET|F|S|@P<": {POS: PRON},
    "<dem>|<-sam>|DET|M|S|@>N": {POS: DET},
    "<dem>|<-sam>|DET|M|S|@P<": {POS: PRON},
    "<dem>|<-sam>|INDP|M|S|@P<": {POS: PRON},
    "<dem>|<Eg>|DET|F|S|@N<PRED": {POS: DET},
    "<dem>|<Eg>|DET|M|S|@N<PRED": {POS: DET},
    "<dem>|<Eg>|DET|M|S|@NPHR": {POS: DET},
    "<dem>|<Eg>|DET|M|S|@SUBJ>": {POS: PRON},
    "<dem>|<KOMP>|<quant>|ADV|@>A": {POS: ADV},
    "<dem>|<KOMP>|DET|F|P|@>N": {POS: DET},
    "<dem>|<KOMP>|DET|M|P|@>N": {POS: DET},
    "<dem>|<first-cjt>|DET|F|P|@P<": {POS: PRON},
    "<dem>|<foc>|DET|M|S|@TOP": {POS: DET},
    "<dem>|<np-idf>|DET|F|P|@<SC": {POS: PRON},
    "<dem>|<np-idf>|DET|F|P|@N<PRED": {POS: DET},
    "<dem>|<np-idf>|DET|F|P|@P<": {POS: PRON},
    "<dem>|<np-idf>|DET|M|P|@<ACC": {POS: PRON},
    "<dem>|<np-idf>|DET|M|P|@N<PRED": {POS: DET},
    "<dem>|<np-idf>|DET|M|P|@NPHR": {POS: DET},
    "<dem>|<quant>|ADV|@<SC": {POS: ADV},
    "<dem>|<quant>|ADV|@>A": {POS: ADV},
    "<dem>|<quant>|ADV|@SUBJ>": {POS: ADV},
    "<dem>|<quant>|DET|F|S|@>N": {POS: DET},
    "<dem>|<quant>|DET|M|S|@>N": {POS: DET},
    "<dem>|<sam->|PERS|M|P|@P<": {POS: PRON},
    "<dem>|ADV|@>A": {POS: ADV},
    "<dem>|ART|F|S|@>N": {POS: DET},
    "<dem>|ART|M|S|@>N": {POS: DET},
    "<dem>|ART|M|S|@P<": {POS: DET},
    "<dem>|DET|F|P<|@>N": {POS: DET},
    "<dem>|DET|F|P|@<ACC": {POS: PRON},
    "<dem>|DET|F|P|@<SC": {POS: PRON},
    "<dem>|DET|F|P|@<SUBJ": {POS: PRON},
    "<dem>|DET|F|P|@>A": {POS: DET},
    "<dem>|DET|F|P|@>N": {POS: DET},
    "<dem>|DET|F|P|@ACC>": {POS: PRON},
    "<dem>|DET|F|P|@N<": {POS: DET},
    "<dem>|DET|F|P|@N<PRED": {POS: DET},
    "<dem>|DET|F|P|@P<": {POS: PRON},
    "<dem>|DET|F|P|@SUBJ>": {POS: PRON},
    "<dem>|DET|F|S|@<SC": {POS: PRON},
    "<dem>|DET|F|S|@<SUBJ": {POS: PRON},
    "<dem>|DET|F|S|@>N": {POS: DET},
    "<dem>|DET|F|S|@APP": {POS: DET},
    "<dem>|DET|F|S|@N<": {POS: DET},
    "<dem>|DET|F|S|@P<": {POS: PRON},
    "<dem>|DET|F|S|@SUBJ>": {POS: PRON},
    "<dem>|DET|M|P|@<ACC": {POS: PRON},
    "<dem>|DET|M|P|@<SC": {POS: PRON},
    "<dem>|DET|M|P|@<SUBJ": {POS: PRON},
    "<dem>|DET|M|P|@>N": {POS: DET},
    "<dem>|DET|M|P|@ACC>": {POS: PRON},
    "<dem>|DET|M|P|@APP": {POS: DET},
    "<dem>|DET|M|P|@N<": {POS: DET},
    "<dem>|DET|M|P|@N<PRED": {POS: DET},
    "<dem>|DET|M|P|@P<": {POS: PRON},
    "<dem>|DET|M|P|@SUBJ>": {POS: PRON},
    "<dem>|DET|M|S|@<ACC": {POS: PRON},
    "<dem>|DET|M|S|@<SC": {POS: PRON},
    "<dem>|DET|M|S|@<SUBJ": {POS: PRON},
    "<dem>|DET|M|S|@>N": {POS: DET},
    "<dem>|DET|M|S|@APP": {POS: DET},
    "<dem>|DET|M|S|@N<": {POS: DET},
    "<dem>|DET|M|S|@N<PRED": {POS: DET},
    "<dem>|DET|M|S|@P<": {POS: PRON},
    "<dem>|DET|M|S|@SC>": {POS: PRON},
    "<dem>|DET|M|S|@SUBJ>": {POS: PRON},
    "<dem>|DET|M|S|@TOP": {POS: DET},
    "<dem>|INDP|M/F|S/P|@<ACC": {POS: PRON},
    "<dem>|INDP|M|S|@<ACC": {POS: PRON},
    "<dem>|INDP|M|S|@<SC": {POS: PRON},
    "<dem>|INDP|M|S|@<SUBJ": {POS: PRON},
    "<dem>|INDP|M|S|@A<": {POS: PRON},
    "<dem>|INDP|M|S|@ACC>": {POS: PRON},
    "<dem>|INDP|M|S|@N<": {POS: PRON},
    "<dem>|INDP|M|S|@N<PRED": {POS: PRON},
    "<dem>|INDP|M|S|@NPHR": {POS: PRON},
    "<dem>|INDP|M|S|@P<": {POS: PRON},
    "<dem>|INDP|M|S|@S<": {POS: PRON},
    "<dem>|INDP|M|S|@SC>": {POS: PRON},
    "<dem>|INDP|M|S|@SUBJ>": {POS: PRON},
    "<dem>|PERS|M|3S|ACC|@<SUBJ": {POS: PRON},
    "<dem>|PERS|M|S|@SUBJ>": {POS: PRON},
    "<diff>|<KOMP>|<np-def>|DET|F|S|@<SC": {POS: PRON},
    "<diff>|<KOMP>|<np-def>|DET|F|S|@P<": {POS: PRON},
    "<diff>|<KOMP>|<np-def>|DET|F|S|@SUBJ>": {POS: PRON},
    "<diff>|<KOMP>|<np-def>|DET|M|P|@P<": {POS: PRON},
    "<diff>|<KOMP>|<np-def>|DET|M|P|@SUBJ>": {POS: PRON},
    "<diff>|<KOMP>|<np-def>|DET|M|S|@<ACC": {POS: PRON},
    "<diff>|<KOMP>|<np-def>|DET|M|S|@<SC": {POS: PRON},
    "<diff>|<KOMP>|<np-def>|DET|M|S|@ACC>": {POS: PRON},
    "<diff>|<KOMP>|<np-def>|DET|M|S|@APP": {POS: ADJ},
    "<diff>|<KOMP>|<np-def>|DET|M|S|@N<PRED": {POS: ADJ},
    "<diff>|<KOMP>|<np-def>|DET|M|S|@P<": {POS: PRON},
    "<diff>|<KOMP>|<np-def>|DET|M|S|@SUBJ>": {POS: PRON},
    "<diff>|<KOMP>|<np-idf>|DET|F|P|@<ACC": {POS: PRON},
    "<diff>|<KOMP>|<np-idf>|DET|F|P|@P<": {POS: PRON},
    "<diff>|<KOMP>|<np-idf>|DET|M|P|@<ACC": {POS: PRON},
    "<diff>|<KOMP>|<np-idf>|DET|M|P|@P<": {POS: PRON},
    "<diff>|<KOMP>|DET|F|P|@<ACC": {POS: PRON},
    "<diff>|<KOMP>|DET|F|P|@>N": {POS: DET},
    "<diff>|<KOMP>|DET|F|P|@ACC>": {POS: PRON},
    "<diff>|<KOMP>|DET|F|P|@P<": {POS: PRON},
    "<diff>|<KOMP>|DET|F|P|@SUBJ>": {POS: PRON},
    "<diff>|<KOMP>|DET|F|S|@<ACC": {POS: PRON},
    "<diff>|<KOMP>|DET|F|S|@<ADVL": {POS: DET},
    "<diff>|<KOMP>|DET|F|S|@<SC": {POS: PRON},
    "<diff>|<KOMP>|DET|F|S|@>N": {POS: DET},
    "<diff>|<KOMP>|DET|F|S|@A<": {POS: ADJ},
    "<diff>|<KOMP>|DET|F|S|@N<PRED": {POS: DET},
    "<diff>|<KOMP>|DET|F|S|@P<": {POS: PRON},
    "<diff>|<KOMP>|DET|F|S|@SUBJ>": {POS: PRON},
    "<diff>|<KOMP>|DET|M/F|S|@>A": {POS: DET},
    "<diff>|<KOMP>|DET|M|P|@<ACC": {POS: PRON},
    "<diff>|<KOMP>|DET|M|P|@>N": {POS: DET},
    "<diff>|<KOMP>|DET|M|P|@A<": {POS: DET},
    "<diff>|<KOMP>|DET|M|P|@P<": {POS: PRON},
    "<diff>|<KOMP>|DET|M|P|@SUBJ>": {POS: PRON},
    "<diff>|<KOMP>|DET|M|S|@<SC": {POS: PRON},
    "<diff>|<KOMP>|DET|M|S|@>N": {POS: DET},
    "<diff>|<KOMP>|DET|M|S|@P<": {POS: PRON},
    "<diff>|<KOMP>|DET|M|S|@SUBJ>": {POS: PRON},
    "<diff>|<n>|<KOMP>|DET|F|S|@<SC": {POS: PRON},
    "<diff>|<np-def>|DET|F|S|@<SC": {POS: PRON},
    "<diff>|<np-def>|DET|M|P|@SUBJ>": {POS: PRON},
    "<diff>|<np-def>|DET|M|S|@<ACC": {POS: PRON},
    "<diff>|<np-def>|DET|M|S|@<SC": {POS: PRON},
    "<diff>|<np-def>|DET|M|S|@ACC>": {POS: PRON},
    "<diff>|<np-def>|DET|M|S|@SUBJ>": {POS: PRON},
    "<diff>|<np-idf>|DET|F|P|@P<": {POS: PRON},
    "<diff>|DET|F|P|@>N": {POS: DET},
    "<diff>|DET|F|P|@P<": {POS: PRON},
    "<diff>|DET|F|S|@<ACC": {POS: PRON},
    "<diff>|DET|F|S|@<SC": {POS: PRON},
    "<diff>|DET|F|S|@>N": {POS: DET},
    "<diff>|DET|F|S|@SC>": {POS: PRON},
    "<diff>|DET|M/F|S|@P<": {POS: PRON},
    "<diff>|DET|M|P|@<ACC": {POS: PRON},
    "<diff>|DET|M|P|@>N": {POS: DET},
    "<diff>|DET|M|P|@P<": {POS: PRON},
    "<diff>|DET|M|P|@SUBJ>": {POS: PRON},
    "<diff>|DET|M|S|@<SC": {POS: PRON},
    "<diff>|DET|M|S|@>N": {POS: DET},
    "<diff>|DET|M|S|@SUBJ>": {POS: PRON},
    "<diff>|INDP|M|S|@P<": {POS: PRON},
    "<error>|PROP|M|P|@N<PRED": {POS: PROPN},
    "<first-cjt>|<-sam>|ADV|@<ADVL": {POS: ADV},
    "<first-cjt>|<-sam>|DET|M|P|@P<": {POS: PRON},
    "<first-cjt>|<COMP>|ADJ|F|P|@N<": {POS: ADJ},
    "<first-cjt>|<COMP>|ADJ|F|S|@APP": {POS: ADJ},
    "<first-cjt>|<COMP>|ADJ|F|S|@N<": {POS: ADJ},
    "<first-cjt>|<COMP>|ADJ|M|P|@N<": {POS: ADJ},
    "<first-cjt>|<COMP>|ADJ|M|S|@<SC": {POS: ADJ},
    "<first-cjt>|<COMP>|ADJ|M|S|@>N": {POS: ADJ},
    "<first-cjt>|<COMP>|ADJ|M|S|@N<": {POS: ADJ},
    "<first-cjt>|<COMP>|ADJ|M|S|@P<": {POS: ADJ},
    "<first-cjt>|<COMP>|ADJ|M|S|@SC>": {POS: ADJ},
    "<first-cjt>|<Eg>|<dem>|DET|F|P|@KOMP<": {POS: DET},
    "<first-cjt>|<Eg>|<dem>|DET|M|S|@FS-STA": {POS: DET},
    "<first-cjt>|<Eg>|<dem>|DET|M|S|@P<": {POS: PRON},
    "<first-cjt>|<Eg>|<n>|<np-def>|ADJ|M|S|@N<PRED": {POS: ADJ},
    "<first-cjt>|<Eg>|NUM|M|P|@P<": {POS: NUM},
    "<first-cjt>|<Em>|<mente>|ADJ|F|S|@<ADVL": {POS: ADJ},
    "<first-cjt>|<Em>|<mente>|ADJ|F|S|@>N": {POS: ADJ},
    "<first-cjt>|<Em>|<mente>|ADJ|F|S|@ADVL>": {POS: ADJ},
    "<first-cjt>|<Em>|<mente>|ADV|@<ADVL": {POS: ADV},
    "<first-cjt>|<KOMP>|<COMP>|ADJ|M|S|@ADVL>": {POS: ADJ},
    "<first-cjt>|<KOMP>|<diff>|<np-def>|DET|M|P|@KOMP<": {POS: DET},
    "<first-cjt>|<KOMP>|<diff>|<np-def>|DET|M|P|@P<": {POS: PRON},
    "<first-cjt>|<KOMP>|<diff>|<np-def>|DET|M|S|@P<": {POS: PRON},
    "<first-cjt>|<KOMP>|<diff>|<np-idf>|DET|F|P|@KOMP<": {POS: DET},
    "<first-cjt>|<KOMP>|<diff>|DET|M|S|@>N": {POS: ADJ},
    "<first-cjt>|<KOMP>|<quant>|ADV|@ADVL": {POS: ADV},
    "<first-cjt>|<NUM-ord>|<n>|<np-def>|ADJ|M|S|@<SC": {POS: ADJ},
    "<first-cjt>|<NUM-ord>|<n>|<np-def>|ADJ|M|S|@P<": {POS: ADJ},
    "<first-cjt>|<NUM-ord>|<n>|<np-def>|ADJ|M|S|@SUBJ>": {POS: ADJ},
    "<first-cjt>|<NUM-ord>|<n>|ADJ|M|S|@<SC": {POS: ADJ},
    "<first-cjt>|<NUM-ord>|<np-def>|ADJ|M|S|@<ADVL": {POS: ADJ},
    "<first-cjt>|<NUM-ord>|<prop>|ADJ|M|S|@N<": {POS: ADJ},
    "<first-cjt>|<NUM-ord>|ADJ|F|S|@>N": {POS: ADJ},
    "<first-cjt>|<NUM-ord>|ADJ|F|S|@N<PRED": {POS: ADJ},
    "<first-cjt>|<NUM-ord>|ADJ|M|S|@>N": {POS: ADJ},
    "<first-cjt>|<artd>|<-sam>|ART|@P<": {POS: DET},
    "<first-cjt>|<artd>|<-sam>|ART|F|S|@P<": {POS: DET},
    "<first-cjt>|<artd>|<-sam>|ART|M|S|@>N": {POS: DET},
    "<first-cjt>|<artd>|<-sam>|ART|M|S|@P<": {POS: DET},
    "<first-cjt>|<artd>|<-sam>|DET|F|S|@P<": {POS: PRON},
    "<first-cjt>|<artd>|ART|F|S|@<sUBJ": {POS: DET},
    "<first-cjt>|<artd>|ART|F|S|@APP": {POS: DET},
    "<first-cjt>|<artd>|ART|F|S|@KOMP<": {POS: DET},
    "<first-cjt>|<artd>|ART|M|S|@<SC": {POS: DET},
    "<first-cjt>|<artd>|ART|M|S|@SUBJ>": {POS: DET},
    "<first-cjt>|<artd>|DET|F|S|@KOMP<": {POS: DET},
    "<first-cjt>|<aux>|<cjt>|V|INF|3S|@ICL-P<": {POS: AUX},
    "<first-cjt>|<aux>|<cjt>|V|INF|@ICL-AUX<": {POS: AUX},
    "<first-cjt>|<aux>|<cjt>|V|PS|3S|IND|@FS-STA": {POS: AUX},
    "<first-cjt>|<aux>|<se-passive>|V|INF|@ICL-P<": {POS: AUX},
    "<first-cjt>|<aux>|V|COND|3P|@FS-N<": {POS: AUX},
    "<first-cjt>|<aux>|V|COND|3P|@FS-STA": {POS: AUX},
    "<first-cjt>|<aux>|V|COND|3S|@FS-P<": {POS: AUX},
    "<first-cjt>|<aux>|V|COND|3S|@FS-STA": {POS: AUX},
    "<first-cjt>|<aux>|V|FUT|3P|IND|@FS-<ACC": {POS: AUX},
    "<first-cjt>|<aux>|V|FUT|3P|IND|@FS-STA": {POS: AUX},
    "<first-cjt>|<aux>|V|FUT|3S|IND|@FS-<ACC": {POS: AUX},
    "<first-cjt>|<aux>|V|FUT|3S|IND|@FS-N<": {POS: AUX},
    "<first-cjt>|<aux>|V|FUT|3S|IND|@FS-STA": {POS: AUX},
    "<first-cjt>|<aux>|V|IMPF|1P|IND|@FS-<ACC": {POS: AUX},
    "<first-cjt>|<aux>|V|IMPF|1P|IND|@FS-STA": {POS: AUX},
    "<first-cjt>|<aux>|V|IMPF|1S|IND|@FS-STA": {POS: AUX},
    "<first-cjt>|<aux>|V|IMPF|3P|IND|@FS-<ACC": {POS: AUX},
    "<first-cjt>|<aux>|V|IMPF|3P|IND|@FS-STA": {POS: AUX},
    "<first-cjt>|<aux>|V|IMPF|3S|IND|@FS-<ACC": {POS: AUX},
    "<first-cjt>|<aux>|V|IMPF|3S|IND|@FS-ADVL>": {POS: AUX},
    "<first-cjt>|<aux>|V|IMPF|3S|IND|@FS-N<PRED": {POS: AUX},
    "<first-cjt>|<aux>|V|IMPF|3S|IND|@FS-STA": {POS: AUX},
    "<first-cjt>|<aux>|V|IMPF|3S|SUBJ|@FS-<ACC": {POS: AUX},
    "<first-cjt>|<aux>|V|INF|3P|@ICL-P<": {POS: AUX},
    "<first-cjt>|<aux>|V|INF|3S|@ICL-N<PRED": {POS: AUX},
    "<first-cjt>|<aux>|V|INF|3S|@ICL-P<": {POS: AUX},
    "<first-cjt>|<aux>|V|INF|@ICL-<ACC": {POS: AUX},
    "<first-cjt>|<aux>|V|INF|@ICL-<SC": {POS: AUX},
    "<first-cjt>|<aux>|V|INF|@ICL-AUX<": {POS: AUX},
    "<first-cjt>|<aux>|V|INF|@ICL-P<": {POS: AUX},
    "<first-cjt>|<aux>|V|MQP|3S|IND|@FS-N<": {POS: AUX},
    "<first-cjt>|<aux>|V|PCP|@ICL-AUX<": {POS: AUX},
    "<first-cjt>|<aux>|V|PCP|M|S|@ICL-AUX<": {POS: AUX},
    "<first-cjt>|<aux>|V|PR|1P|IND|@FS-N<": {POS: AUX},
    "<first-cjt>|<aux>|V|PR|1P|IND|@FS-STA": {POS: AUX},
    "<first-cjt>|<aux>|V|PR|1S|IND|@FS-<ACC": {POS: AUX},
    "<first-cjt>|<aux>|V|PR|1S|IND|@FS-ACC>": {POS: AUX},
    "<first-cjt>|<aux>|V|PR|1S|IND|@FS-ADVL>": {POS: AUX},
    "<first-cjt>|<aux>|V|PR|1S|IND|@FS-N<PRED": {POS: AUX},
    "<first-cjt>|<aux>|V|PR|1S|IND|@FS-QUE": {POS: AUX},
    "<first-cjt>|<aux>|V|PR|1S|IND|@FS-STA": {POS: AUX},
    "<first-cjt>|<aux>|V|PR|3P|IND|@FS-<ACC": {POS: AUX},
    "<first-cjt>|<aux>|V|PR|3P|IND|@FS-N<": {POS: AUX},
    "<first-cjt>|<aux>|V|PR|3P|IND|@FS-N<PRED": {POS: AUX},
    "<first-cjt>|<aux>|V|PR|3P|IND|@FS-STA": {POS: AUX},
    "<first-cjt>|<aux>|V|PR|3P|SUBJ|@FS-<ACC": {POS: AUX},
    "<first-cjt>|<aux>|V|PR|3P|SUBJ|@FS-<ADVL": {POS: AUX},
    "<first-cjt>|<aux>|V|PR|3P|SUBJ|@FS-ADVL>": {POS: AUX},
    "<first-cjt>|<aux>|V|PR|3S|IND|@FS-<ACC": {POS: AUX},
    "<first-cjt>|<aux>|V|PR|3S|IND|@FS-A<": {POS: AUX},
    "<first-cjt>|<aux>|V|PR|3S|IND|@FS-ACC>": {POS: AUX},
    "<first-cjt>|<aux>|V|PR|3S|IND|@FS-APP": {POS: AUX},
    "<first-cjt>|<aux>|V|PR|3S|IND|@FS-N<": {POS: AUX},
    "<first-cjt>|<aux>|V|PR|3S|IND|@FS-N<PRED": {POS: AUX},
    "<first-cjt>|<aux>|V|PR|3S|IND|@FS-QUE": {POS: AUX},
    "<first-cjt>|<aux>|V|PR|3S|IND|@FS-STA": {POS: AUX},
    "<first-cjt>|<aux>|V|PR|3S|SUBJ|@FS-<ADVL": {POS: AUX},
    "<first-cjt>|<aux>|V|PR|3S|SUBJ|@FS-P<": {POS: AUX},
    "<first-cjt>|<aux>|V|PS/MQP|3P|IND|@FS-N<PRED": {POS: AUX},
    "<first-cjt>|<aux>|V|PS/MQP|3P|IND|@FS-QUE": {POS: AUX},
    "<first-cjt>|<aux>|V|PS/MQP|3P|IND|@FS-STA": {POS: AUX},
    "<first-cjt>|<aux>|V|PS|1S|IND|@FS-ACC>": {POS: AUX},
    "<first-cjt>|<aux>|V|PS|1S|IND|@FS-STA": {POS: AUX},
    "<first-cjt>|<aux>|V|PS|3P|IND|@FS-<ACC": {POS: AUX},
    "<first-cjt>|<aux>|V|PS|3P|IND|@FS-<ADVL": {POS: AUX},
    "<first-cjt>|<aux>|V|PS|3P|IND|@FS-ACC>": {POS: AUX},
    "<first-cjt>|<aux>|V|PS|3P|IND|@FS-N<PRED": {POS: AUX},
    "<first-cjt>|<aux>|V|PS|3P|IND|@FS-STA": {POS: AUX},
    "<first-cjt>|<aux>|V|PS|3S|IND|@FS-<ACC": {POS: AUX},
    "<first-cjt>|<aux>|V|PS|3S|IND|@FS-<ADVL": {POS: AUX},
    "<first-cjt>|<aux>|V|PS|3S|IND|@FS-ACC>": {POS: AUX},
    "<first-cjt>|<aux>|V|PS|3S|IND|@FS-ADVL>": {POS: AUX},
    "<first-cjt>|<aux>|V|PS|3S|IND|@FS-N<": {POS: AUX},
    "<first-cjt>|<aux>|V|PS|3S|IND|@FS-N<PRED": {POS: AUX},
    "<first-cjt>|<aux>|V|PS|3S|IND|@FS-STA": {POS: AUX},
    "<first-cjt>|<card>|<Eg>|<np-def>|NUM|M|P|@KOMP<": {POS: NUM},
    "<first-cjt>|<card>|<n>|<np-def>|NUM|M|P|@P<": {POS: NUM},
    "<first-cjt>|<card>|<np-def>|NUM|M|P|@<ACC": {POS: NUM},
    "<first-cjt>|<card>|NUM|F|P|@>N": {POS: NUM},
    "<first-cjt>|<card>|NUM|F|P|@N<": {POS: NUM},
    "<first-cjt>|<card>|NUM|F|P|@N<PRED": {POS: NUM},
    "<first-cjt>|<card>|NUM|F|P|@NPHR": {POS: NUM},
    "<first-cjt>|<card>|NUM|F|P|@P<": {POS: NUM},
    "<first-cjt>|<card>|NUM|F|S|@<ACC": {POS: NUM},
    "<first-cjt>|<card>|NUM|F|S|@>N": {POS: NUM},
    "<first-cjt>|<card>|NUM|F|S|@N<": {POS: NUM},
    "<first-cjt>|<card>|NUM|F|S|@N<PRED": {POS: NUM},
    "<first-cjt>|<card>|NUM|F|S|@NPHR": {POS: NUM},
    "<first-cjt>|<card>|NUM|F|S|@SUBJ>": {POS: NUM},
    "<first-cjt>|<card>|NUM|M|F|P|@>N": {POS: NUM},
    "<first-cjt>|<card>|NUM|M|P|@>N": {POS: NUM},
    "<first-cjt>|<card>|NUM|M|P|@APP": {POS: NUM},
    "<first-cjt>|<card>|NUM|M|P|@N<": {POS: NUM},
    "<first-cjt>|<card>|NUM|M|P|@N<PRED": {POS: NUM},
    "<first-cjt>|<card>|NUM|M|P|@P<": {POS: NUM},
    "<first-cjt>|<card>|NUM|M|S|@<SC": {POS: NUM},
    "<first-cjt>|<card>|NUM|M|S|@>A": {POS: NUM},
    "<first-cjt>|<card>|NUM|M|S|@>N": {POS: NUM},
    "<first-cjt>|<card>|NUM|M|S|@N<": {POS: NUM},
    "<first-cjt>|<card>|NUM|M|S|@N<PRED": {POS: NUM},
    "<first-cjt>|<card>|NUM|M|S|@NPHR": {POS: NUM},
    "<first-cjt>|<card>|NUM|M|S|@P<": {POS: NUM},
    "<first-cjt>|<card>|NUM|M|S|@SUBJ>": {POS: NUM},
    "<first-cjt>|<cjt>|<aux>|V|PS|3S|IND|@FS-STA": {POS: AUX},
    "<first-cjt>|<cjt>|<mv>|V|PS|1S|IND|@FS-STA": {POS: VERB},
    "<first-cjt>|<cjt>|<np-def>|N|F|S|@<SC": {POS: NOUN},
    "<first-cjt>|<cjt>|<np-def>|N|M|S|@N<PRED": {POS: NOUN},
    "<first-cjt>|<cjt>|<np-idf>|N|M|P|@P<": {POS: NOUN},
    "<first-cjt>|<cjt>|<sam->|PRP|@N<": {POS: ADP},
    "<first-cjt>|<cjt>|PROP|F|S|@FS-STA": {POS: PROPN},
    "<first-cjt>|<com>|PRP|@<ADVL": {POS: ADP},
    "<first-cjt>|<com>|PRP|@PRED>": {POS: ADP},
    "<first-cjt>|<dem>|<-sam>|DET|M|P|@P<": {POS: PRON},
    "<first-cjt>|<dem>|<n>|DET|M|S|@KOMP<": {POS: DET},
    "<first-cjt>|<dem>|DET|F|P|@KOMP<": {POS: DET},
    "<first-cjt>|<dem>|DET|F|S|@<SC": {POS: PRON},
    "<first-cjt>|<dem>|DET|F|S|@APP": {POS: DET},
    "<first-cjt>|<dem>|DET|F|S|@KOMP<": {POS: DET},
    "<first-cjt>|<dem>|DET|F|S|@P<": {POS: PRON},
    "<first-cjt>|<dem>|DET|M|P|@<ACC": {POS: PRON},
    "<first-cjt>|<dem>|DET|M|P|@KOMP<": {POS: DET},
    "<first-cjt>|<dem>|DET|M|P|@P<": {POS: PRON},
    "<first-cjt>|<dem>|DET|M|S|@APP": {POS: DET},
    "<first-cjt>|<dem>|DET|M|S|@KOMP<": {POS: DET},
    "<first-cjt>|<dem>|DET|M|S|@N<": {POS: DET},
    "<first-cjt>|<dem>|DET|M|S|@P<": {POS: PRON},
    "<first-cjt>|<dem>|INDP|M|S|@ACC>": {POS: PRON},
    "<first-cjt>|<dem>|INDP|M|S|@KOMP<": {POS: PRON},
    "<first-cjt>|<dem>|INDP|M|S|@P<": {POS: PRON},
    "<first-cjt>|<dem>|PERS|F|S|@P<": {POS: PRON},
    "<first-cjt>|<hyphen>|ADJ|F|P|@APP": {POS: ADJ},
    "<first-cjt>|<hyphen>|V|INF|@ICL-<PIV": {POS: VERB},
    "<first-cjt>|<interr>|ADV|@<ACC": {POS: ADV},
    "<first-cjt>|<interr>|ADV|@<ADVL": {POS: ADV},
    "<first-cjt>|<interr>|ADV|@ADVL": {POS: ADV},
    "<first-cjt>|<interr>|ADV|@ADVL>": {POS: ADV},
    "<first-cjt>|<interr>|ADV|@N<PRED": {POS: ADV},
    "<first-cjt>|<interr>|DET|F|P|@NPHR": {POS: DET},
    "<first-cjt>|<interr>|DET|F|S|@NPHR": {POS: DET},
    "<first-cjt>|<interr>|DET|M|S|@NPHR": {POS: DET},
    "<first-cjt>|<kc>|ADV|@ADVL": {POS: ADV},
    "<first-cjt>|<ks>|<rel>|ADV|@<ADVL": {POS: ADV},
    "<first-cjt>|<ks>|<rel>|PRP|@<ADVL": {POS: ADP},
    "<first-cjt>|<ks>|<rel>|PRP|@ADVL>": {POS: ADP},
    "<first-cjt>|<mv>|<cjt>|V|IMPF|3S|IND|@FS-N<": {POS: VERB},
    "<first-cjt>|<mv>|<cjt>|V|IMPF|3S|IND|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|<cjt>|V|INF|3P|@ICL-P<": {POS: VERB},
    "<first-cjt>|<mv>|<cjt>|V|INF|@FS-N<": {POS: AUX},
    "<first-cjt>|<mv>|<cjt>|V|INF|@ICL-P<": {POS: VERB},
    "<first-cjt>|<mv>|<cjt>|V|PR|1P|IND|@FS-ACC>": {POS: VERB},
    "<first-cjt>|<mv>|<cjt>|V|PR|3P|IND|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|<cjt>|V|PR|3S|IND|@FS-APP": {POS: VERB},
    "<first-cjt>|<mv>|<cjt>|V|PR|3S|IND|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|<cjt>|V|PR|3S|IND|@ICL-N<PRED": {POS: VERB},
    "<first-cjt>|<mv>|<cjt>|V|PS|3P|IND|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|<se-passive>|<cjt>|V|PS|3S|IND|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|<se-passive>|V|FUT|3S|SUBJ|@FS-<ADVL": {POS: VERB},
    "<first-cjt>|<mv>|<se-passive>|V|IMPF|3P|SUBJ|@FS-<ACC": {POS: VERB},
    "<first-cjt>|<mv>|<se-passive>|V|IMPF|3S|IND|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|<se-passive>|V|PR|3P|IND|@FS-N<": {POS: VERB},
    "<first-cjt>|<mv>|<se-passive>|V|PR|3P|IND|@FS-P<": {POS: VERB},
    "<first-cjt>|<mv>|<se-passive>|V|PR|3P|IND|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|<se-passive>|V|PR|3S|IND|@FS-<ACC": {POS: VERB},
    "<first-cjt>|<mv>|<se-passive>|V|PR|3S|IND|@FS-ADVL>": {POS: VERB},
    "<first-cjt>|<mv>|<se-passive>|V|PR|3S|IND|@FS-N<": {POS: VERB},
    "<first-cjt>|<mv>|<se-passive>|V|PR|3S|IND|@FS-N<PRED": {POS: VERB},
    "<first-cjt>|<mv>|<se-passive>|V|PR|3S|IND|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|<se-passive>|V|PR|3S|SUBJ|@FS-<ACC": {POS: VERB},
    "<first-cjt>|<mv>|<se-passive>|V|PS|3S|IND|@FS-<ACC": {POS: VERB},
    "<first-cjt>|<mv>|<se-passive>|V|PS|3S|IND|@FS-ACC>": {POS: VERB},
    "<first-cjt>|<mv>|<se-passive>|V|PS|3S|IND|@FS-N<": {POS: VERB},
    "<first-cjt>|<mv>|<se-passive>|V|PS|3S|IND|@FS-N<PRED": {POS: VERB},
    "<first-cjt>|<mv>|<se-passive>|V|PS|3S|IND|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|V|COND|1S|@FS-<ACC": {POS: VERB},
    "<first-cjt>|<mv>|V|COND|1S|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|V|COND|3P|@FS-ACC>": {POS: VERB},
    "<first-cjt>|<mv>|V|COND|3P|@FS-P<": {POS: VERB},
    "<first-cjt>|<mv>|V|COND|3S|@FS-<ACC": {POS: VERB},
    "<first-cjt>|<mv>|V|COND|3S|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|V|FUT|3P|IND|@FS-ACC>": {POS: VERB},
    "<first-cjt>|<mv>|V|FUT|3P|IND|@FS-N<PRED": {POS: VERB},
    "<first-cjt>|<mv>|V|FUT|3P|IND|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|V|FUT|3P|SUBJ|@FS-<ADVL": {POS: VERB},
    "<first-cjt>|<mv>|V|FUT|3P|SUBJ|@FS-ADVL>": {POS: VERB},
    "<first-cjt>|<mv>|V|FUT|3S|IND|@FS-N<": {POS: VERB},
    "<first-cjt>|<mv>|V|FUT|3S|IND|@FS-N<PRED": {POS: VERB},
    "<first-cjt>|<mv>|V|FUT|3S|IND|@FS-QUE": {POS: VERB},
    "<first-cjt>|<mv>|V|FUT|3S|IND|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|V|FUT|3S|SUBJ|@FS-<ADVL": {POS: VERB},
    "<first-cjt>|<mv>|V|FUT|3S|SUBJ|@FS-ADVL>": {POS: VERB},
    "<first-cjt>|<mv>|V|GER|@ICL-<ADVL": {POS: VERB},
    "<first-cjt>|<mv>|V|GER|@ICL-N<PRED": {POS: VERB},
    "<first-cjt>|<mv>|V|GER|@ICL-SUBJ>": {POS: VERB},
    "<first-cjt>|<mv>|V|IMPF|1S|IND|@FS-A<": {POS: VERB},
    "<first-cjt>|<mv>|V|IMPF|1S|IND|@FS-KOMP<": {POS: VERB},
    "<first-cjt>|<mv>|V|IMPF|1S|IND|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|V|IMPF|1S|SUBJ|@FS-ADVL>": {POS: AUX},
    "<first-cjt>|<mv>|V|IMPF|3P|IND|@FS-<ACC": {POS: AUX},
    "<first-cjt>|<mv>|V|IMPF|3P|IND|@FS-<SUBJ": {POS: VERB},
    "<first-cjt>|<mv>|V|IMPF|3P|IND|@FS-ACC>": {POS: VERB},
    "<first-cjt>|<mv>|V|IMPF|3P|IND|@FS-N<": {POS: VERB},
    "<first-cjt>|<mv>|V|IMPF|3P|IND|@FS-N<PRED": {POS: VERB},
    "<first-cjt>|<mv>|V|IMPF|3P|IND|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|V|IMPF|3P|SUBJ|@FS-P<": {POS: AUX},
    "<first-cjt>|<mv>|V|IMPF|3S|IND|@FS-<ACC": {POS: VERB},
    "<first-cjt>|<mv>|V|IMPF|3S|IND|@FS-<SUBJ": {POS: AUX},
    "<first-cjt>|<mv>|V|IMPF|3S|IND|@FS-ACC>": {POS: VERB},
    "<first-cjt>|<mv>|V|IMPF|3S|IND|@FS-ADVL>": {POS: AUX},
    "<first-cjt>|<mv>|V|IMPF|3S|IND|@FS-N<": {POS: VERB},
    "<first-cjt>|<mv>|V|IMPF|3S|IND|@FS-N<PRED": {POS: VERB},
    "<first-cjt>|<mv>|V|IMPF|3S|IND|@FS-P<": {POS: VERB},
    "<first-cjt>|<mv>|V|IMPF|3S|IND|@FS-QUE": {POS: AUX},
    "<first-cjt>|<mv>|V|IMPF|3S|IND|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|V|IMPF|3S|IND|@FS-SUBJ>": {POS: VERB},
    "<first-cjt>|<mv>|V|IMPF|3S|SUBJ|@FS-<ACC": {POS: VERB},
    "<first-cjt>|<mv>|V|IMPF|3S|SUBJ|@FS-<ADVL": {POS: VERB},
    "<first-cjt>|<mv>|V|IMPF|3S|SUBJ|@FS-P<": {POS: VERB},
    "<first-cjt>|<mv>|V|IMPF|3S|SUBJ|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|V|INF|1P|@ICL-<SUBJ": {POS: VERB},
    "<first-cjt>|<mv>|V|INF|1P|@ICL-P<": {POS: AUX},
    "<first-cjt>|<mv>|V|INF|1S|@ICL-<ACC": {POS: VERB},
    "<first-cjt>|<mv>|V|INF|3P|@ICL-P<": {POS: VERB},
    "<first-cjt>|<mv>|V|INF|3S|@ICL-<ACC": {POS: VERB},
    "<first-cjt>|<mv>|V|INF|3S|@ICL-P<": {POS: VERB},
    "<first-cjt>|<mv>|V|INF|@ICL-<ACC": {POS: VERB},
    "<first-cjt>|<mv>|V|INF|@ICL-<SC": {POS: VERB},
    "<first-cjt>|<mv>|V|INF|@ICL-AUX<": {POS: VERB},
    "<first-cjt>|<mv>|V|INF|@ICL-KOMP<": {POS: VERB},
    "<first-cjt>|<mv>|V|INF|@ICL-N<PRED": {POS: VERB},
    "<first-cjt>|<mv>|V|INF|@ICL-P<": {POS: VERB},
    "<first-cjt>|<mv>|V|INF|@ICL-UTT": {POS: VERB},
    "<first-cjt>|<mv>|V|MQP|1S|IND|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|V|MQP|3P|IND|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|V|MQP|3S|IND|@FS-N<": {POS: VERB},
    "<first-cjt>|<mv>|V|MQP|3S|IND|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|V|M|P|3S|IND|@STA": {POS: VERB},
    "<first-cjt>|<mv>|V|PCP|@ICL-AUX<": {POS: VERB},
    "<first-cjt>|<mv>|V|PCP|F|P|@ICL-N<PRED": {POS: VERB},
    "<first-cjt>|<mv>|V|PCP|F|S|@ICL-<SC": {POS: ADJ},
    "<first-cjt>|<mv>|V|PCP|F|S|@ICL-N<": {POS: VERB},
    "<first-cjt>|<mv>|V|PCP|F|S|@ICL-N<PRED": {POS: VERB},
    "<first-cjt>|<mv>|V|PCP|M|P|@ICL-<OC": {POS: VERB},
    "<first-cjt>|<mv>|V|PCP|M|P|@ICL-<SC": {POS: VERB},
    "<first-cjt>|<mv>|V|PCP|M|P|@ICL-AUX<": {POS: VERB},
    "<first-cjt>|<mv>|V|PCP|M|P|@ICL-N<": {POS: VERB},
    "<first-cjt>|<mv>|V|PCP|M|P|@ICL-N<PRED": {POS: VERB},
    "<first-cjt>|<mv>|V|PCP|M|S|@ICL-<ADVL": {POS: VERB},
    "<first-cjt>|<mv>|V|PCP|M|S|@ICL-<PRED": {POS: VERB},
    "<first-cjt>|<mv>|V|PCP|M|S|@ICL-<SC": {POS: VERB},
    "<first-cjt>|<mv>|V|PCP|M|S|@ICL-AUX<": {POS: VERB},
    "<first-cjt>|<mv>|V|PCP|M|S|@ICL-N<": {POS: VERB},
    "<first-cjt>|<mv>|V|PCP|M|S|@ICL-N<PRED": {POS: VERB},
    "<first-cjt>|<mv>|V|PCP|M|S|@ICL-P<": {POS: VERB},
    "<first-cjt>|<mv>|V|PCP|M|S|@ICL-PRED>": {POS: VERB},
    "<first-cjt>|<mv>|V|PCP|M|S|@ICL-STA": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|1P|IND|@FS-ACC>": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|1P|IND|@FS-EXC": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|1P|IND|@FS-N<PRED": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|1P|IND|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|1S|IND|@FS-<ADVL": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|1S|IND|@FS-ACC>": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|1S|IND|@FS-N<PRED": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|1S|IND|@FS-P<": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|1S|IND|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3P|IND|@FS-<ACC": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3P|IND|@FS-ACC>": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3P|IND|@FS-KOMP<": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3P|IND|@FS-N<": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3P|IND|@FS-N<PRED": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3P|IND|@FS-P<": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3P|IND|@FS-PASS": {POS: AUX},
    "<first-cjt>|<mv>|V|PR|3P|IND|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3P|SUBJ|@FS-<ACC": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3P|SUBJ|@FS-<ADVL": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3P|SUBJ|@FS-P<": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3S|IND|@FS-<ACC": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3S|IND|@FS-<ADVL": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3S|IND|@FS-<PIV": {POS: AUX},
    "<first-cjt>|<mv>|V|PR|3S|IND|@FS-<SC": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3S|IND|@FS-<SUBJ": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3S|IND|@FS-ACC>": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3S|IND|@FS-ADVL>": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3S|IND|@FS-APP": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3S|IND|@FS-KOMP<": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3S|IND|@FS-N<": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3S|IND|@FS-N<PRED": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3S|IND|@FS-P<": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3S|IND|@FS-QUE": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3S|IND|@FS-S<": {POS: AUX},
    "<first-cjt>|<mv>|V|PR|3S|IND|@FS-SC>": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3S|IND|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3S|IND|@FS-UTT": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3S|SUBJ|@FS-<ACC": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3S|SUBJ|@FS-<ADVL": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3S|SUBJ|@FS-<SC": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3S|SUBJ|@FS-<SUBJ": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3S|SUBJ|@FS-COM": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3S|SUBJ|@FS-N<": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3S|SUBJ|@FS-N<PRED": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3S|SUBJ|@FS-P<": {POS: VERB},
    "<first-cjt>|<mv>|V|PR|3S|SUBJ|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|V|PS/MQP|3P|IND|@FS-N<PRED": {POS: VERB},
    "<first-cjt>|<mv>|V|PS/MQP|3P|IND|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|V|PS|1P|IND|@FS-ACC>": {POS: VERB},
    "<first-cjt>|<mv>|V|PS|1P|IND|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|V|PS|1S|IND|@FS-<ACC": {POS: VERB},
    "<first-cjt>|<mv>|V|PS|1S|IND|@FS-<ADVL": {POS: VERB},
    "<first-cjt>|<mv>|V|PS|1S|IND|@FS-ACC>": {POS: VERB},
    "<first-cjt>|<mv>|V|PS|1S|IND|@FS-N<": {POS: VERB},
    "<first-cjt>|<mv>|V|PS|1S|IND|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|V|PS|2S|IND|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|V|PS|3P|IND|@FS-<ACC": {POS: VERB},
    "<first-cjt>|<mv>|V|PS|3P|IND|@FS-<ADVL": {POS: VERB},
    "<first-cjt>|<mv>|V|PS|3P|IND|@FS-ACC>": {POS: VERB},
    "<first-cjt>|<mv>|V|PS|3P|IND|@FS-N<": {POS: VERB},
    "<first-cjt>|<mv>|V|PS|3P|IND|@FS-N<PRED": {POS: VERB},
    "<first-cjt>|<mv>|V|PS|3P|IND|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|V|PS|3S|IND|@FS-<ACC": {POS: VERB},
    "<first-cjt>|<mv>|V|PS|3S|IND|@FS-<ADVL": {POS: VERB},
    "<first-cjt>|<mv>|V|PS|3S|IND|@FS-<SC": {POS: VERB},
    "<first-cjt>|<mv>|V|PS|3S|IND|@FS-ACC>": {POS: VERB},
    "<first-cjt>|<mv>|V|PS|3S|IND|@FS-ADVL>": {POS: VERB},
    "<first-cjt>|<mv>|V|PS|3S|IND|@FS-KOMP<": {POS: VERB},
    "<first-cjt>|<mv>|V|PS|3S|IND|@FS-N<": {POS: VERB},
    "<first-cjt>|<mv>|V|PS|3S|IND|@FS-N<PRED": {POS: VERB},
    "<first-cjt>|<mv>|V|PS|3S|IND|@FS-QUE": {POS: VERB},
    "<first-cjt>|<mv>|V|PS|3S|IND|@FS-STA": {POS: VERB},
    "<first-cjt>|<mv>|V|PS|3S|IND|@FS-SUBJ>": {POS: VERB},
    "<first-cjt>|<mv>|V|PS|3S|IND|@FS-UTT": {POS: VERB},
    "<first-cjt>|<n>|<SUP>|ADJ|M|S|@P<": {POS: ADJ},
    "<first-cjt>|<n>|<np-def>|ADJ|F|S|@<ACC": {POS: ADJ},
    "<first-cjt>|<n>|<np-def>|ADJ|M|P|@<ACC": {POS: ADJ},
    "<first-cjt>|<n>|<np-def>|ADJ|M|P|@N<PRED": {POS: ADJ},
    "<first-cjt>|<n>|<np-def>|ADJ|M|P|@P<": {POS: ADJ},
    "<first-cjt>|<n>|<np-def>|ADJ|M|P|@SUBJ>": {POS: ADJ},
    "<first-cjt>|<n>|<np-def>|ADJ|M|S|@APP": {POS: ADJ},
    "<first-cjt>|<n>|<np-def>|ADJ|M|S|@FS-N<PRED": {POS: ADJ},
    "<first-cjt>|<n>|<np-def>|ADJ|M|S|@N<PRED": {POS: ADJ},
    "<first-cjt>|<n>|<np-def>|ADJ|M|S|@NPHR": {POS: ADJ},
    "<first-cjt>|<n>|<np-def>|ADJ|M|S|@P<": {POS: ADJ},
    "<first-cjt>|<n>|<np-idf>|ADJ|F|P|@<SC": {POS: ADJ},
    "<first-cjt>|<n>|<np-idf>|ADJ|M|S|@APP": {POS: ADJ},
    "<first-cjt>|<n>|ADJ|F|P|@<SC": {POS: ADJ},
    "<first-cjt>|<n>|ADJ|F|S|@<SC": {POS: ADJ},
    "<first-cjt>|<n>|ADJ|M/F|P|@SUBJ>": {POS: ADJ},
    "<first-cjt>|<n>|ADJ|M|P|@<ACC": {POS: ADJ},
    "<first-cjt>|<n>|ADJ|M|P|@P<": {POS: ADJ},
    "<first-cjt>|<n>|ADJ|M|S|@<SC": {POS: ADJ},
    "<first-cjt>|<n>|ADJ|M|S|@P<": {POS: ADJ},
    "<first-cjt>|<np-def>|ADJ|F|P|@KOMP<": {POS: ADJ},
    "<first-cjt>|<np-def>|ADJ|F|P|@P<": {POS: ADJ},
    "<first-cjt>|<np-def>|N|F|P|@<ACC": {POS: NOUN},
    "<first-cjt>|<np-def>|N|F|P|@<SC": {POS: NOUN},
    "<first-cjt>|<np-def>|N|F|P|@<SUBJ": {POS: NOUN},
    "<first-cjt>|<np-def>|N|F|P|@A<": {POS: NOUN},
    "<first-cjt>|<np-def>|N|F|P|@APP": {POS: NOUN},
    "<first-cjt>|<np-def>|N|F|P|@FS-STA": {POS: NOUN},
    "<first-cjt>|<np-def>|N|F|P|@KOMP<": {POS: NOUN},
    "<first-cjt>|<np-def>|N|F|P|@N<PRED": {POS: NOUN},
    "<first-cjt>|<np-def>|N|F|P|@NPHR": {POS: NOUN},
    "<first-cjt>|<np-def>|N|F|P|@P<": {POS: NOUN},
    "<first-cjt>|<np-def>|N|F|P|@SUBJ>": {POS: NOUN},
    "<first-cjt>|<np-def>|N|F|S|@<ACC": {POS: NOUN},
    "<first-cjt>|<np-def>|N|F|S|@<ADVL": {POS: NOUN},
    "<first-cjt>|<np-def>|N|F|S|@<SC": {POS: NOUN},
    "<first-cjt>|<np-def>|N|F|S|@<SUBJ": {POS: NOUN},
    "<first-cjt>|<np-def>|N|F|S|@APP": {POS: NOUN},
    "<first-cjt>|<np-def>|N|F|S|@KOMP<": {POS: NOUN},
    "<first-cjt>|<np-def>|N|F|S|@N<": {POS: NOUN},
    "<first-cjt>|<np-def>|N|F|S|@N<PRED": {POS: NOUN},
    "<first-cjt>|<np-def>|N|F|S|@NPHR": {POS: NOUN},
    "<first-cjt>|<np-def>|N|F|S|@P<": {POS: NOUN},
    "<first-cjt>|<np-def>|N|F|S|@STA": {POS: NOUN},
    "<first-cjt>|<np-def>|N|F|S|@SUBJ>": {POS: NOUN},
    "<first-cjt>|<np-def>|N|M|P|@<ACC": {POS: SYM},
    "<first-cjt>|<np-def>|N|M|P|@<ADVL": {POS: NOUN},
    "<first-cjt>|<np-def>|N|M|P|@<SC": {POS: NOUN},
    "<first-cjt>|<np-def>|N|M|P|@<SUBJ": {POS: NOUN},
    "<first-cjt>|<np-def>|N|M|P|@A<": {POS: NOUN},
    "<first-cjt>|<np-def>|N|M|P|@APP": {POS: NOUN},
    "<first-cjt>|<np-def>|N|M|P|@FS-<ACC": {POS: NOUN},
    "<first-cjt>|<np-def>|N|M|P|@KOMP<": {POS: NOUN},
    "<first-cjt>|<np-def>|N|M|P|@N<PRED": {POS: SYM},
    "<first-cjt>|<np-def>|N|M|P|@NPHR": {POS: NOUN},
    "<first-cjt>|<np-def>|N|M|P|@P<": {POS: SYM},
    "<first-cjt>|<np-def>|N|M|P|@SUBJ>": {POS: NOUN},
    "<first-cjt>|<np-def>|N|M|S|@<ACC": {POS: NOUN},
    "<first-cjt>|<np-def>|N|M|S|@<ADVL": {POS: NOUN},
    "<first-cjt>|<np-def>|N|M|S|@<SC": {POS: NOUN},
    "<first-cjt>|<np-def>|N|M|S|@<SUBJ": {POS: NOUN},
    "<first-cjt>|<np-def>|N|M|S|@APP": {POS: NOUN},
    "<first-cjt>|<np-def>|N|M|S|@KOMP<": {POS: NOUN},
    "<first-cjt>|<np-def>|N|M|S|@N<PRED": {POS: NOUN},
    "<first-cjt>|<np-def>|N|M|S|@NPHR": {POS: NOUN},
    "<first-cjt>|<np-def>|N|M|S|@P<": {POS: NOUN},
    "<first-cjt>|<np-def>|N|M|S|@SUBJ>": {POS: NOUN},
    "<first-cjt>|<np-idf>|ADJ|M|S|@N<": {POS: ADJ},
    "<first-cjt>|<np-idf>|N|F|P|@<ACC": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|F|P|@<ADVL": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|F|P|@<OC": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|F|P|@<SC": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|F|P|@<SUBJ": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|F|P|@ACC>": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|F|P|@APP": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|F|P|@KOMP<": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|F|P|@N<PRED": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|F|P|@NPHR": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|F|P|@P<": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|F|P|@SUBJ>": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|F|S|@<ACC": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|F|S|@<ADVL": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|F|S|@<SC": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|F|S|@<SUBJ": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|F|S|@ACC>": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|F|S|@APP": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|F|S|@KOMP<": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|F|S|@N<": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|F|S|@N<PRED": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|F|S|@NPHR": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|F|S|@P<": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|F|S|@SUBJ>": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|M/F|P|@P<": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|M/F|P|@SUBJ>": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|M/F|S|@NPHR": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|M|P|@<ACC": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|M|P|@<OC": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|M|P|@<SC": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|M|P|@<SUBJ": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|M|P|@APP": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|M|P|@N<": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|M|P|@N<PRED": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|M|P|@NPHR": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|M|P|@P<": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|M|P|@SUBJ>": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|M|S|@<ACC": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|M|S|@<ADVL": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|M|S|@<OC": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|M|S|@<SC": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|M|S|@<SUBJ": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|M|S|@ACC>": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|M|S|@ADVL>": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|M|S|@APP": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|M|S|@KOMP<": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|M|S|@N<": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|M|S|@N<PRED": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|M|S|@NPHR": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|M|S|@P<": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|M|S|@PRED>": {POS: NOUN},
    "<first-cjt>|<np-idf>|N|M|S|@SUBJ>": {POS: NOUN},
    "<first-cjt>|<pass>|<mv>|V|PCP|M|S|@ICL-AUX<": {POS: VERB},
    "<first-cjt>|<prd>|PRP|@<ADVL": {POS: ADP},
    "<first-cjt>|<prd>|PRP|@<OC": {POS: ADP},
    "<first-cjt>|<prd>|PRP|@<SC": {POS: ADP},
    "<first-cjt>|<prd>|PRP|@ADVL>": {POS: ADP},
    "<first-cjt>|<prop>|<n>|<np-def>|ADJ|M|S|@P<": {POS: ADJ},
    "<first-cjt>|<prop>|<np-def>|N|F|P|@P<": {POS: NOUN},
    "<first-cjt>|<prop>|<np-def>|N|F|S|@<ACC": {POS: NOUN},
    "<first-cjt>|<prop>|<np-def>|N|F|S|@<SUBJ": {POS: NOUN},
    "<first-cjt>|<prop>|<np-def>|N|F|S|@NPHR": {POS: NOUN},
    "<first-cjt>|<prop>|<np-def>|N|F|S|@P<": {POS: NOUN},
    "<first-cjt>|<prop>|<np-def>|N|M|P|@P<": {POS: NOUN},
    "<first-cjt>|<prop>|<np-def>|N|M|P|@SUBJ>": {POS: NOUN},
    "<first-cjt>|<prop>|<np-def>|N|M|S|@<ACC": {POS: NOUN},
    "<first-cjt>|<prop>|<np-def>|N|M|S|@<SC": {POS: NOUN},
    "<first-cjt>|<prop>|<np-def>|N|M|S|@<SUBJ": {POS: NOUN},
    "<first-cjt>|<prop>|<np-def>|N|M|S|@FS-N<PRED": {POS: NOUN},
    "<first-cjt>|<prop>|<np-def>|N|M|S|@P<": {POS: NOUN},
    "<first-cjt>|<prop>|<np-def>|N|M|S|@SUBJ>": {POS: NOUN},
    "<first-cjt>|<prop>|<np-idf>|N|F|S|@N<": {POS: NOUN},
    "<first-cjt>|<prop>|<np-idf>|N|F|S|@P<": {POS: NOUN},
    "<first-cjt>|<prop>|<np-idf>|N|M|S|@N<": {POS: NOUN},
    "<first-cjt>|<prop>|<np-idf>|N|M|S|@P<": {POS: NOUN},
    "<first-cjt>|<prop>|PROP|M|S|@SUBJ>": {POS: PROPN},
    "<first-cjt>|<quant>|<KOMP>|<COMP>|DET|M|S|@<SC": {POS: PRON},
    "<first-cjt>|<quant>|ADV|@<ADVL": {POS: ADV},
    "<first-cjt>|<quant>|ADV|@<SC": {POS: ADV},
    "<first-cjt>|<quant>|ADV|@>A": {POS: ADV},
    "<first-cjt>|<quant>|ADV|@>N": {POS: ADV},
    "<first-cjt>|<quant>|DET|M|P|@P<": {POS: PRON},
    "<first-cjt>|<quant>|DET|M|S|@>N": {POS: DET},
    "<first-cjt>|<quant>|INDP|M|S|@<ACC": {POS: PRON},
    "<first-cjt>|<quant>|INDP|M|S|@ACC>": {POS: PRON},
    "<first-cjt>|<quant>|INDP|M|S|@NPHR": {POS: PRON},
    "<first-cjt>|<quant>|INDP|M|S|@P<": {POS: PRON},
    "<first-cjt>|<quant>|INDP|M|S|@SUBJ>": {POS: PRON},
    "<first-cjt>|<rel>|ADV|@<ADVL": {POS: ADV},
    "<first-cjt>|<rel>|ADV|@ADVL>": {POS: ADV},
    "<first-cjt>|<rel>|ADV|@AUX<": {POS: ADV},
    "<first-cjt>|<rel>|DET|F|S|@<ACC": {POS: PRON},
    "<first-cjt>|<rel>|INDP|F|P|@N<": {POS: PRON},
    "<first-cjt>|<rel>|INDP|F|S|@ACC>": {POS: PRON},
    "<first-cjt>|<rel>|INDP|F|S|@N<": {POS: PRON},
    "<first-cjt>|<rel>|INDP|M/F|S/P|@S<": {POS: PRON},
    "<first-cjt>|<rel>|INDP|M/F|S|@SUBJ>": {POS: PRON},
    "<first-cjt>|<rel>|INDP|M|S|@N<": {POS: PRON},
    "<first-cjt>|<rel>|INDP|M|S|@NPHR": {POS: PRON},
    "<first-cjt>|<rel>|PRP|@<ADVL": {POS: ADP},
    "<first-cjt>|<rel>|PRP|@<PRED": {POS: ADP},
    "<first-cjt>|<rel>|PRP|@ADVL>": {POS: ADP},
    "<first-cjt>|<rel>|PRP|@N<PRED": {POS: ADP},
    "<first-cjt>|<sam->|PRP|@<ACC": {POS: ADP},
    "<first-cjt>|<sam->|PRP|@<ADVL": {POS: ADP},
    "<first-cjt>|<sam->|PRP|@<OA": {POS: ADP},
    "<first-cjt>|<sam->|PRP|@<PIV": {POS: ADP},
    "<first-cjt>|<sam->|PRP|@<SA": {POS: ADP},
    "<first-cjt>|<sam->|PRP|@<SC": {POS: ADP},
    "<first-cjt>|<sam->|PRP|@A<": {POS: ADP},
    "<first-cjt>|<sam->|PRP|@ADVL": {POS: ADP},
    "<first-cjt>|<sam->|PRP|@ADVL>": {POS: ADP},
    "<first-cjt>|<sam->|PRP|@ICL-<ACC": {POS: ADP},
    "<first-cjt>|<sam->|PRP|@KOMP<": {POS: ADP},
    "<first-cjt>|<sam->|PRP|@N<": {POS: ADP},
    "<first-cjt>|<sam->|PRP|@N<ARG": {POS: ADP},
    "<first-cjt>|<sam->|PRP|@N<PRED": {POS: ADP},
    "<first-cjt>|<sam->|PRP|@P<": {POS: ADP},
    "<first-cjt>|<sam->|PRP|@PASS": {POS: ADP},
    "<first-cjt>|<sam->|PRP|@PIV>": {POS: ADP},
    "<first-cjt>|<sam->|PRP|@SC>": {POS: ADP},
    "<first-cjt>|<sam->|PRP|@STA": {POS: ADP},
    "<first-cjt>|<sam->|PRP|@UTT": {POS: ADP},
    "<first-cjt>|ADJ|F|P|@<ADVL": {POS: ADJ},
    "<first-cjt>|ADJ|F|P|@<SC": {POS: ADJ},
    "<first-cjt>|ADJ|F|P|@>N": {POS: ADJ},
    "<first-cjt>|ADJ|F|P|@N<": {POS: ADJ},
    "<first-cjt>|ADJ|F|P|@N<PRED": {POS: ADJ},
    "<first-cjt>|ADJ|F|S|@<OC": {POS: ADJ},
    "<first-cjt>|ADJ|F|S|@<SC": {POS: ADJ},
    "<first-cjt>|ADJ|F|S|@>N": {POS: ADJ},
    "<first-cjt>|ADJ|F|S|@KOMP<": {POS: ADJ},
    "<first-cjt>|ADJ|F|S|@N<": {POS: ADJ},
    "<first-cjt>|ADJ|F|S|@N<PRED": {POS: ADJ},
    "<first-cjt>|ADJ|F|S|@NPHR": {POS: ADJ},
    "<first-cjt>|ADJ|M/F|P|@N<": {POS: ADJ},
    "<first-cjt>|ADJ|M/F|P|@P<": {POS: ADJ},
    "<first-cjt>|ADJ|M/F|S|@<OC": {POS: ADJ},
    "<first-cjt>|ADJ|M|F|@>N": {POS: ADJ},
    "<first-cjt>|ADJ|M|P|@<PRED": {POS: ADJ},
    "<first-cjt>|ADJ|M|P|@<SC": {POS: ADJ},
    "<first-cjt>|ADJ|M|P|@>N": {POS: ADJ},
    "<first-cjt>|ADJ|M|P|@N<": {POS: ADJ},
    "<first-cjt>|ADJ|M|P|@N<PRED": {POS: ADJ},
    "<first-cjt>|ADJ|M|P|@P<": {POS: ADJ},
    "<first-cjt>|ADJ|M|P|@PRED>": {POS: ADJ},
    "<first-cjt>|ADJ|M|S|@<ADVL": {POS: ADJ},
    "<first-cjt>|ADJ|M|S|@<OC": {POS: ADJ},
    "<first-cjt>|ADJ|M|S|@<PRED": {POS: ADJ},
    "<first-cjt>|ADJ|M|S|@<SC": {POS: ADJ},
    "<first-cjt>|ADJ|M|S|@>N": {POS: ADJ},
    "<first-cjt>|ADJ|M|S|@APP": {POS: ADJ},
    "<first-cjt>|ADJ|M|S|@KOMP<": {POS: ADJ},
    "<first-cjt>|ADJ|M|S|@N<": {POS: ADJ},
    "<first-cjt>|ADJ|M|S|@N<PRED": {POS: ADJ},
    "<first-cjt>|ADJ|M|S|@NPHR": {POS: ADJ},
    "<first-cjt>|ADJ|M|S|@P<": {POS: ADJ},
    "<first-cjt>|ADJ|M|S|@PRED>": {POS: ADJ},
    "<first-cjt>|ADJ|M|S|@SC>": {POS: ADJ},
    "<first-cjt>|ADV|@<ACC": {POS: ADV},
    "<first-cjt>|ADV|@<ADVL": {POS: ADV},
    "<first-cjt>|ADV|@ADVL": {POS: ADV},
    "<first-cjt>|ADV|@ADVL>": {POS: ADV},
    "<first-cjt>|ADV|@FS-STA": {POS: ADV},
    "<first-cjt>|ADV|@KOMP<": {POS: ADV},
    "<first-cjt>|ADV|@N<": {POS: ADV},
    "<first-cjt>|ADV|@N<PRED": {POS: ADV},
    "<first-cjt>|ADV|@P<": {POS: ADV},
    "<first-cjt>|EC|M|S|@P<": {POS: PART},
    "<first-cjt>|INDP|M|S|@<ACC": {POS: PRON},
    "<first-cjt>|IN|@ACC>": {POS: INTJ},
    "<first-cjt>|IN|@EXC": {POS: INTJ},
    "<first-cjt>|IN|@UTT": {POS: INTJ},
    "<first-cjt>|IN|F|S|@UTT": {POS: INTJ},
    "<first-cjt>|IN|M|S|@<ACC": {POS: INTJ},
    "<first-cjt>|KS|@<ACC": {POS: SCONJ},
    "<first-cjt>|KS|@<ADVL": {POS: SCONJ},
    "<first-cjt>|KS|@A<": {POS: SCONJ},
    "<first-cjt>|KS|@ACC>": {POS: SCONJ},
    "<first-cjt>|KS|@ADVL>": {POS: SCONJ},
    "<first-cjt>|KS|@AUX<": {POS: SCONJ},
    "<first-cjt>|KS|@KOMP<": {POS: SCONJ},
    "<first-cjt>|KS|@N<PRED": {POS: SCONJ},
    "<first-cjt>|KS|@SC>": {POS: SCONJ},
    "<first-cjt>|KS|@SUB": {POS: SCONJ},
    "<first-cjt>|KS|@SUBJ>": {POS: SCONJ},
    "<first-cjt>|KS|@UTT": {POS: SCONJ},
    "<first-cjt>|NUM|M|P|@P<": {POS: NUM},
    "<first-cjt>|NUM|M|S|@N<": {POS: NUM},
    "<first-cjt>|PERS|F|1S|NOM|@SUBJ>": {POS: PRON},
    "<first-cjt>|PERS|F|3S|NOM|@<SUBJ": {POS: PRON},
    "<first-cjt>|PERS|M/F|1P|NOM|@KOMP<": {POS: PRON},
    "<first-cjt>|PERS|M/F|1P|NOM|@P<": {POS: PRON},
    "<first-cjt>|PERS|M/F|1S|NOM|@AUX<": {POS: PRON},
    "<first-cjt>|PERS|M/F|1S|NOM|@KOMP<": {POS: PRON},
    "<first-cjt>|PERS|M|3P|NOM|@ACC>": {POS: PRON},
    "<first-cjt>|PERS|M|3P|NOM|@N<PRED": {POS: PRON},
    "<first-cjt>|PERS|M|3P|NOM|@NPHR": {POS: PRON},
    "<first-cjt>|PERS|M|3P|PIV|@P<": {POS: PRON},
    "<first-cjt>|PERS|M|3S|ACC|@NPHR": {POS: PRON},
    "<first-cjt>|PERS|M|3S|NOM|@N<PRED": {POS: PRON},
    "<first-cjt>|PERS|M|3S|NOM|@NPHR": {POS: PRON},
    "<first-cjt>|PERS|M|3S|NOM|@SUBJ>": {POS: PRON},
    "<first-cjt>|PERS|M|3S|PIV|@KOMP<": {POS: PRON},
    "<first-cjt>|PERS|M|3S|PIV|@P<": {POS: PRON},
    "<first-cjt>|PERS|M|S|@NPHR": {POS: PRON},
    "<first-cjt>|PROP|F|P|@<SUBJ": {POS: PROPN},
    "<first-cjt>|PROP|F|P|@NPHR": {POS: PROPN},
    "<first-cjt>|PROP|F|P|@P<": {POS: PROPN},
    "<first-cjt>|PROP|F|S|@<ACC": {POS: PROPN},
    "<first-cjt>|PROP|F|S|@<SC": {POS: PROPN},
    "<first-cjt>|PROP|F|S|@<SUBJ": {POS: PROPN},
    "<first-cjt>|PROP|F|S|@APP": {POS: PROPN},
    "<first-cjt>|PROP|F|S|@KOMP<": {POS: PROPN},
    "<first-cjt>|PROP|F|S|@N<": {POS: PROPN},
    "<first-cjt>|PROP|F|S|@N<PRED": {POS: PROPN},
    "<first-cjt>|PROP|F|S|@NPHR": {POS: PROPN},
    "<first-cjt>|PROP|F|S|@P<": {POS: PROPN},
    "<first-cjt>|PROP|F|S|@SUBJ>": {POS: PROPN},
    "<first-cjt>|PROP|M/F|S|@P<": {POS: PROPN},
    "<first-cjt>|PROP|M/F|S|@SUBJ>": {POS: PROPN},
    "<first-cjt>|PROP|M|P|@<ACC": {POS: PROPN},
    "<first-cjt>|PROP|M|P|@<SC": {POS: PROPN},
    "<first-cjt>|PROP|M|P|@APP": {POS: PROPN},
    "<first-cjt>|PROP|M|P|@N<PRED": {POS: PROPN},
    "<first-cjt>|PROP|M|P|@P<": {POS: PROPN},
    "<first-cjt>|PROP|M|P|@SUBJ>": {POS: PROPN},
    "<first-cjt>|PROP|M|S|@<ACC": {POS: PROPN},
    "<first-cjt>|PROP|M|S|@<SC": {POS: PROPN},
    "<first-cjt>|PROP|M|S|@<SUBJ": {POS: PROPN},
    "<first-cjt>|PROP|M|S|@APP": {POS: PROPN},
    "<first-cjt>|PROP|M|S|@KOMP<": {POS: PROPN},
    "<first-cjt>|PROP|M|S|@N<": {POS: PROPN},
    "<first-cjt>|PROP|M|S|@N<PRED": {POS: PROPN},
    "<first-cjt>|PROP|M|S|@NPHR": {POS: PROPN},
    "<first-cjt>|PROP|M|S|@P<": {POS: PROPN},
    "<first-cjt>|PROP|M|S|@S<": {POS: PROPN},
    "<first-cjt>|PROP|M|S|@SUBJ>": {POS: PROPN},
    "<first-cjt>|PRP|@<ACC": {POS: ADP},
    "<first-cjt>|PRP|@<ADVL": {POS: ADP},
    "<first-cjt>|PRP|@<OA": {POS: ADP},
    "<first-cjt>|PRP|@<OC": {POS: ADP},
    "<first-cjt>|PRP|@<PIV": {POS: ADP},
    "<first-cjt>|PRP|@<PRED": {POS: ADP},
    "<first-cjt>|PRP|@<SA": {POS: ADP},
    "<first-cjt>|PRP|@<SC": {POS: ADP},
    "<first-cjt>|PRP|@A<": {POS: ADP},
    "<first-cjt>|PRP|@A<ARG": {POS: ADP},
    "<first-cjt>|PRP|@ADVL": {POS: ADP},
    "<first-cjt>|PRP|@ADVL>": {POS: ADP},
    "<first-cjt>|PRP|@FS-APP": {POS: ADP},
    "<first-cjt>|PRP|@FS-N<PRED": {POS: ADP},
    "<first-cjt>|PRP|@H": {POS: ADP},
    "<first-cjt>|PRP|@KOMP<": {POS: ADP},
    "<first-cjt>|PRP|@N<": {POS: ADP},
    "<first-cjt>|PRP|@N<ARG": {POS: ADP},
    "<first-cjt>|PRP|@N<PRED": {POS: ADP},
    "<first-cjt>|PRP|@OA>": {POS: ADP},
    "<first-cjt>|PRP|@P<": {POS: ADP},
    "<first-cjt>|PRP|@PASS": {POS: ADP},
    "<first-cjt>|PRP|@PIV>": {POS: ADP},
    "<first-cjt>|PRP|@PRED>": {POS: ADP},
    "<first-cjt>|PRP|@QUE": {POS: ADP},
    "<first-cjt>|PRP|@SC>": {POS: ADP},
    "<first-cjt>|PRP|@STA": {POS: ADP},
    "<first-cjt>|PRP|@UTT": {POS: ADP},
    "<first-cjt>|PU|@PU": {POS: PUNCT},
    "<first-cjt>|V|PCP|F|S|@N<": {POS: ADJ},
    "<first-cjt>|V|PS|3S|IND|@P<": {POS: VERB},
    "<foc>|ADV|@<ADVL": {POS: ADV},
    "<foc>|ADV|@<FOC": {POS: ADV},
    "<foc>|ADV|@>S": {POS: ADV},
    "<foc>|ADV|@ADVL>": {POS: ADV},
    "<foc>|ADV|@FOC>": {POS: ADV},
    "<foc>|ADV|@PU": {POS: ADV},
    "<hyphen>|<np-idf>|N|M|P|@<ACC": {POS: NOUN},
    "<hyphen>|<obj>|PERS|M|3S|ACC|@<ACC": {POS: PRON},
    "<hyphen>|<refl>|PERS|M/F|1S|DAT|@<DAT": {POS: PRON},
    "<hyphen>|EC|@>N": {POS: PART},
    "<hyphen>|PERS|F|3S|ACC|@<ACC": {POS: PRON},
    "<hyphen>|PERS|F|3S|ACC|@<ACC-PASS": {POS: PRON},
    "<hyphen>|PERS|M/F|3S/P|ACC|@<SUBJ": {POS: PRON},
    "<hyphen>|PERS|M|3S|ACC|@<ACC-PASS": {POS: PRON},
    "<hyphen>|PERS|M|3S|DAT|@<DAT": {POS: PRON},
    "<hyphen>|PROP|F|P|@P<": {POS: PROPN},
    "<ident>|<np-idf>|DET|F|S|@N<PRED": {POS: DET},
    "<ident>|DET|F|P|@>N": {POS: DET},
    "<ident>|DET|F|S|@>N": {POS: DET},
    "<ident>|DET|F|S|@N<": {POS: DET},
    "<ident>|DET|M|P|@>N": {POS: DET},
    "<ident>|DET|M|P|@N<": {POS: DET},
    "<ident>|DET|M|S|@>A": {POS: ADJ},
    "<ident>|DET|M|S|@>N": {POS: DET},
    "<ident>|DET|M|S|@N<": {POS: DET},
    "<interr>|<quant>|ADV|@P<": {POS: ADV},
    "<interr>|<quant>|DET|F|P|@>N": {POS: DET},
    "<interr>|<quant>|DET|M|P|@>N": {POS: DET},
    "<interr>|<quant>|DET|M|S|@>N": {POS: DET},
    "<interr>|<quant>|DET|M|S|@ACC>": {POS: PRON},
    "<interr>|<quant>|DET|M|S|@ADVL>": {POS: DET},
    "<interr>|<quant>|DET|M|S|@P<": {POS: PRON},
    "<interr>|ADV|@<ACC": {POS: ADV},
    "<interr>|ADV|@<ADVL": {POS: ADV},
    "<interr>|ADV|@>N": {POS: ADV},
    "<interr>|ADV|@ADVL": {POS: ADV},
    "<interr>|ADV|@ADVL>": {POS: ADV},
    "<interr>|ADV|@N<PRED": {POS: ADV},
    "<interr>|ADV|@P<": {POS: ADV},
    "<interr>|ADV|@SA>": {POS: ADV},
    "<interr>|ADV|@SC>": {POS: ADV},
    "<interr>|ADV|@SUB": {POS: ADV},
    "<interr>|DET|F|P|@>N": {POS: DET},
    "<interr>|DET|F|P|@SC>": {POS: PRON},
    "<interr>|DET|F|P|@SUBJ>": {POS: PRON},
    "<interr>|DET|F|S|@<SC": {POS: PRON},
    "<interr>|DET|F|S|@>N": {POS: DET},
    "<interr>|DET|F|S|@SC>": {POS: PRON},
    "<interr>|DET|M/F|S/P|@>A": {POS: DET},
    "<interr>|DET|M/F|S|@SC>": {POS: PRON},
    "<interr>|DET|M|P|@>N": {POS: DET},
    "<interr>|DET|M|P|@SC>": {POS: PRON},
    "<interr>|DET|M|S|@>N": {POS: DET},
    "<interr>|DET|M|S|@SC>": {POS: PRON},
    "<interr>|INDP|F|P|@ACC>": {POS: PRON},
    "<interr>|INDP|F|S|@SC>": {POS: PRON},
    "<interr>|INDP|M/F|P|@SUBJ>": {POS: PRON},
    "<interr>|INDP|M/F|S/P|@P<": {POS: PRON},
    "<interr>|INDP|M/F|S/P|@SUBJ>": {POS: PRON},
    "<interr>|INDP|M/F|S|@<ACC": {POS: PRON},
    "<interr>|INDP|M/F|S|@SC>": {POS: PRON},
    "<interr>|INDP|M/F|S|@SUBJ>": {POS: PRON},
    "<interr>|INDP|M|P|@SC>": {POS: PRON},
    "<interr>|INDP|M|P|@SUBJ>": {POS: PRON},
    "<interr>|INDP|M|S|@ACC>": {POS: PRON},
    "<interr>|INDP|M|S|@P<": {POS: PRON},
    "<interr>|INDP|M|S|@SC>": {POS: PRON},
    "<interr>|INDP|M|S|@SUBJ>": {POS: PRON},
    "<kc>|<-sam>|ADV|@P<": {POS: ADV},
    "<kc>|<co-icl>|ADV|@CO": {POS: ADV},
    "<kc>|<parkc-1>|<KOMP>|ADV|@CO": {POS: ADV},
    "<kc>|ADV|@<ACC": {POS: ADV},
    "<kc>|ADV|@<ADVL": {POS: ADV},
    "<kc>|ADV|@<SA": {POS: ADV},
    "<kc>|ADV|@<SC": {POS: ADV},
    "<kc>|ADV|@>A": {POS: ADV},
    "<kc>|ADV|@>N": {POS: ADV},
    "<kc>|ADV|@>P": {POS: ADV},
    "<kc>|ADV|@ADVL>": {POS: ADV},
    "<kc>|ADV|@CO": {POS: ADV},
    "<kc>|ADV|@P<": {POS: ADV},
    "<kc>|ADV|@SA>": {POS: ADV},
    "<kc>|ADV|@SUB": {POS: ADV},
    "<kc>|KS|@ADVL>": {POS: SCONJ},
    "<ks>|<rel>|ADV|@ADVL>": {POS: ADV},
    "<ks>|<rel>|PRP|@ADVL>": {POS: ADP},
    "<mente>|<NUM-ord>|ADJ|F|S|@>A": {POS: ADJ},
    "<mente>|<NUM-ord>|ADJ|M/F|S|@ADVL>": {POS: ADJ},
    "<mente>|ADJ|F|S|@<ADVL": {POS: ADJ},
    "<meta>|<cjt>|<np-idf>|N|M|P|@<ACC": {POS: NOUN},
    "<meta>|<first-cjt>|<np-def>|N|F|S|@P<": {POS: NOUN},
    "<meta>|<np-def>|N|F|P|@<ACC": {POS: NOUN},
    "<meta>|<np-def>|N|F|P|@P<": {POS: NOUN},
    "<meta>|<np-def>|N|F|P|@SUBJ>": {POS: NOUN},
    "<meta>|<np-def>|N|F|S|@<ACC": {POS: NOUN},
    "<meta>|<np-def>|N|F|S|@<SC": {POS: NOUN},
    "<meta>|<np-def>|N|F|S|@<SUBJ": {POS: NOUN},
    "<meta>|<np-def>|N|F|S|@P<": {POS: NOUN},
    "<meta>|<np-def>|N|F|S|@SUBJ>": {POS: NOUN},
    "<meta>|<np-def>|N|M|P|@<ACC": {POS: NOUN},
    "<meta>|<np-def>|N|M|P|@<SC": {POS: NOUN},
    "<meta>|<np-def>|N|M|P|@<SUBJ": {POS: NOUN},
    "<meta>|<np-def>|N|M|P|@P<": {POS: NOUN},
    "<meta>|<np-def>|N|M|P|@SUBJ>": {POS: NOUN},
    "<meta>|<np-def>|N|M|S|@<ACC": {POS: NOUN},
    "<meta>|<np-def>|N|M|S|@<SC": {POS: NOUN},
    "<meta>|<np-def>|N|M|S|@P<": {POS: NOUN},
    "<meta>|<np-def>|N|M|S|@SUBJ>": {POS: NOUN},
    "<meta>|<np-idf>|N|F|P|@P<": {POS: NOUN},
    "<meta>|<np-idf>|N|F|S|@<ACC": {POS: NOUN},
    "<meta>|<np-idf>|N|F|S|@<OC": {POS: NOUN},
    "<meta>|<np-idf>|N|F|S|@<SC": {POS: NOUN},
    "<meta>|<np-idf>|N|F|S|@<SUBJ": {POS: NOUN},
    "<meta>|<np-idf>|N|F|S|@N<PRED": {POS: NOUN},
    "<meta>|<np-idf>|N|F|S|@P<": {POS: NOUN},
    "<meta>|<np-idf>|N|M|S|@<ACC": {POS: NOUN},
    "<meta>|<np-idf>|N|M|S|@<SC": {POS: NOUN},
    "<meta>|<np-idf>|N|M|S|@ACC>": {POS: NOUN},
    "<meta>|<np-idf>|N|M|S|@NPHR": {POS: NOUN},
    "<meta>|<np-idf>|N|M|S|@P<": {POS: NOUN},
    "<meta>|<np-idf>|N|M|S|@SUBJ>": {POS: NOUN},
    "<meta>|ADV|@>S": {POS: ADV},
    "<meta>|ADV|@ADVL>": {POS: ADV},
    "<mv>|<cjt>|<first-cjt>|V|FUT|3P|IND|@FS-N<": {POS: VERB},
    "<mv>|<cjt>|<first-cjt>|V|FUT|3S|SUBJ|@FS-ADVL>": {POS: VERB},
    "<mv>|<cjt>|<first-cjt>|V|INF|@ICL-P<": {POS: VERB},
    "<mv>|<cjt>|<first-cjt>|V|PCP|@ICL-AUX<": {POS: VERB},
    "<mv>|<cjt>|<first-cjt>|V|PR|3P|IND|@FS-P<": {POS: VERB},
    "<mv>|<cjt>|<first-cjt>|V|PR|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|<first-cjt>|V|PS|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|<se-passive>|V|GER|@ICL-<ADVL": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|<se-passive>|V|IMPF|3S|IND|@FS-ACC>": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|<se-passive>|V|IMPF|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|<se-passive>|V|INF|3P|@ICL-P<": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|<se-passive>|V|INF|@ICL-<ACC": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|<se-passive>|V|PR|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|<se-passive>|V|PR|3S|IND|@FS-<ACC": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|<se-passive>|V|PR|3S|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|<se-passive>|V|PR|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|<se-passive>|V|PS|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|<se-passive>|V|PS|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|V|COND|3S|@FS-<ACC": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|V|GER|@ICL-<ADVL": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|V|GER|@ICL-ADVL>": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|V|IMPF|1S|IND|@FS-KOMP<": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|V|IMPF|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|V|INF|@ICL-<SC": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|V|INF|@ICL-AUX<": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|V|INF|@ICL-P<": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|V|PR|1S|IND|@FS-ACC>": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|V|PR|3P|IND|@FS-ACC>": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|V|PR|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|V|PR|3S|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|V|PR|3S|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|V|PR|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|V|PS|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|V|PS|3S|IND|@FS-<ACC": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|V|PS|3S|IND|@FS-ACC>": {POS: VERB},
    "<mv>|<cjt>|<hyphen>|V|PS|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|<n>|V|PCP|M|P|@ICL-P<": {POS: VERB},
    "<mv>|<cjt>|<n>|V|PCP|M|S|@ICL-P<": {POS: VERB},
    "<mv>|<cjt>|<nil>|V|PS|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|<sam->|V|PR|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|<se-passive>|V|PR|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|<se-passive>|V|PR|3P|IND|@NPHR": {POS: VERB},
    "<mv>|<cjt>|<se-passive>|V|PR|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|<se-passive>|V|PS|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|V|COND|1S|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|V|COND|3S|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|V|FUT|1S|IND|@FS-<ACC": {POS: VERB},
    "<mv>|<cjt>|V|FUT|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|V|FUT|3S|IND|@<ACC": {POS: VERB},
    "<mv>|<cjt>|V|FUT|3S|IND|@FS-N<": {POS: VERB},
    "<mv>|<cjt>|V|FUT|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|V|FUT|3S|SUBJ|@FS-ADVL>": {POS: VERB},
    "<mv>|<cjt>|V|GER|@ADVL>": {POS: VERB},
    "<mv>|<cjt>|V|GER|@ICL-<ADVL": {POS: VERB},
    "<mv>|<cjt>|V|GER|@ICL-<SC": {POS: VERB},
    "<mv>|<cjt>|V|GER|@ICL-A<": {POS: VERB},
    "<mv>|<cjt>|V|GER|@ICL-ADVL>": {POS: VERB},
    "<mv>|<cjt>|V|GER|@ICL-AUX<": {POS: VERB},
    "<mv>|<cjt>|V|GER|@ICL-N<": {POS: VERB},
    "<mv>|<cjt>|V|GER|@ICL-N<PRED": {POS: VERB},
    "<mv>|<cjt>|V|GER|@ICL-PRED>": {POS: VERB},
    "<mv>|<cjt>|V|GER|@ICL-STA": {POS: VERB},
    "<mv>|<cjt>|V|GER|@N<": {POS: VERB},
    "<mv>|<cjt>|V|GER|@PRED>": {POS: VERB},
    "<mv>|<cjt>|V|IMPF|1P|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|V|IMPF|1S|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|V|IMPF|3P|IND|@FS-ADVL>": {POS: VERB},
    "<mv>|<cjt>|V|IMPF|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|V|IMPF|3S|IND|@<ACC": {POS: VERB},
    "<mv>|<cjt>|V|IMPF|3S|IND|@FS-ADVL>": {POS: VERB},
    "<mv>|<cjt>|V|IMPF|3S|IND|@FS-N<": {POS: VERB},
    "<mv>|<cjt>|V|IMPF|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|V|IMPF|3S|IND|@ICL-<ACC": {POS: VERB},
    "<mv>|<cjt>|V|IMPF|3S|SUBJ|@FS-<ACC": {POS: VERB},
    "<mv>|<cjt>|V|INF|3P|@ICL-AUX<": {POS: VERB},
    "<mv>|<cjt>|V|INF|3P|@ICL-P<": {POS: VERB},
    "<mv>|<cjt>|V|INF|@<ADVL": {POS: VERB},
    "<mv>|<cjt>|V|INF|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|V|INF|@ICL-<ACC": {POS: VERB},
    "<mv>|<cjt>|V|INF|@ICL-<SC": {POS: VERB},
    "<mv>|<cjt>|V|INF|@ICL-<SUBJ": {POS: VERB},
    "<mv>|<cjt>|V|INF|@ICL-APP": {POS: VERB},
    "<mv>|<cjt>|V|INF|@ICL-AUX<": {POS: VERB},
    "<mv>|<cjt>|V|INF|@ICL-N<PRED": {POS: VERB},
    "<mv>|<cjt>|V|INF|@ICL-P<": {POS: VERB},
    "<mv>|<cjt>|V|INF|@ICL-SC>": {POS: VERB},
    "<mv>|<cjt>|V|INF|@ICL-STA": {POS: VERB},
    "<mv>|<cjt>|V|INF|@ICL-SUBJ>": {POS: VERB},
    "<mv>|<cjt>|V|MQP|1/3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|V|MQP|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|V|PCP|@ICL-AUX<": {POS: VERB},
    "<mv>|<cjt>|V|PCP|F|P|@ICL-<OC": {POS: VERB},
    "<mv>|<cjt>|V|PCP|F|P|@ICL-AUX<": {POS: VERB},
    "<mv>|<cjt>|V|PCP|F|P|@ICL-N<": {POS: VERB},
    "<mv>|<cjt>|V|PCP|F|P|@ICL-N<PRED": {POS: ADJ},
    "<mv>|<cjt>|V|PCP|F|S|@<SC": {POS: VERB},
    "<mv>|<cjt>|V|PCP|F|S|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|V|PCP|F|S|@ICL-AUX<": {POS: VERB},
    "<mv>|<cjt>|V|PCP|F|S|@ICL-N<": {POS: VERB},
    "<mv>|<cjt>|V|PCP|F|S|@ICL-UTT": {POS: VERB},
    "<mv>|<cjt>|V|PCP|F|S|@N<PRED": {POS: VERB},
    "<mv>|<cjt>|V|PCP|M|P|@ICL-<OC": {POS: VERB},
    "<mv>|<cjt>|V|PCP|M|P|@ICL-<PRED": {POS: ADJ},
    "<mv>|<cjt>|V|PCP|M|P|@ICL-<SC": {POS: VERB},
    "<mv>|<cjt>|V|PCP|M|P|@ICL-AUX<": {POS: VERB},
    "<mv>|<cjt>|V|PCP|M|P|@ICL-N<": {POS: VERB},
    "<mv>|<cjt>|V|PCP|M|P|@N<": {POS: VERB},
    "<mv>|<cjt>|V|PCP|M|S|@ICL-<OC": {POS: VERB},
    "<mv>|<cjt>|V|PCP|M|S|@ICL-<SC": {POS: VERB},
    "<mv>|<cjt>|V|PCP|M|S|@ICL-AUX<": {POS: VERB},
    "<mv>|<cjt>|V|PCP|M|S|@ICL-N<": {POS: VERB},
    "<mv>|<cjt>|V|PCP|M|S|@ICL-N<PRED": {POS: VERB},
    "<mv>|<cjt>|V|PCP|M|S|@ICL-PRED>": {POS: ADJ},
    "<mv>|<cjt>|V|PCP|M|S|@N<": {POS: VERB},
    "<mv>|<cjt>|V|PCP|M|S|@N<PRED": {POS: VERB},
    "<mv>|<cjt>|V|PCP|M|S|@PRED>": {POS: VERB},
    "<mv>|<cjt>|V|PR|1/3S|SUBJ|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|V|PR|1P|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|V|PR|1S|IND|@FS-<ADVL": {POS: AUX},
    "<mv>|<cjt>|V|PR|1S|IND|@FS-ACC>": {POS: VERB},
    "<mv>|<cjt>|V|PR|1S|IND|@FS-QUE": {POS: VERB},
    "<mv>|<cjt>|V|PR|1S|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|V|PR|1|SUBJ|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|V|PR|3P|IND|@FS-<ACC": {POS: VERB},
    "<mv>|<cjt>|V|PR|3P|IND|@FS-ACC>": {POS: VERB},
    "<mv>|<cjt>|V|PR|3P|IND|@FS-N<": {POS: VERB},
    "<mv>|<cjt>|V|PR|3P|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|<cjt>|V|PR|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|V|PR|3P|SUBJ|@FS-<ACC": {POS: VERB},
    "<mv>|<cjt>|V|PR|3P|SUBJ|@FS-<ADVL": {POS: VERB},
    "<mv>|<cjt>|V|PR|3P|SUBJ|@FS-N<": {POS: AUX},
    "<mv>|<cjt>|V|PR|3S|IND|@ADVL>": {POS: VERB},
    "<mv>|<cjt>|V|PR|3S|IND|@FS-<ACC": {POS: VERB},
    "<mv>|<cjt>|V|PR|3S|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|<cjt>|V|PR|3S|IND|@FS-<SUBJ": {POS: VERB},
    "<mv>|<cjt>|V|PR|3S|IND|@FS-ACC>": {POS: VERB},
    "<mv>|<cjt>|V|PR|3S|IND|@FS-EXC": {POS: VERB},
    "<mv>|<cjt>|V|PR|3S|IND|@FS-KOMP<": {POS: VERB},
    "<mv>|<cjt>|V|PR|3S|IND|@FS-N<": {POS: VERB},
    "<mv>|<cjt>|V|PR|3S|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|<cjt>|V|PR|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|V|PR|3S|IND|@N<": {POS: VERB},
    "<mv>|<cjt>|V|PR|3S|IND|@NPHR": {POS: VERB},
    "<mv>|<cjt>|V|PR|3S|SUBJ|@FS-ACC>": {POS: VERB},
    "<mv>|<cjt>|V|PR|3S|SUBJ|@FS-N<PRED": {POS: VERB},
    "<mv>|<cjt>|V|PR|3S|SUBJ|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|V|PS/MQP|3P|IND|@P<": {POS: VERB},
    "<mv>|<cjt>|V|PS|1P|IND|@FS-<SUBJ": {POS: VERB},
    "<mv>|<cjt>|V|PS|1P|IND|@FS-ACC>": {POS: VERB},
    "<mv>|<cjt>|V|PS|1P|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|<cjt>|V|PS|1P|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|V|PS|1S|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|<cjt>|V|PS|1S|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|V|PS|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<cjt>|V|PS|3P|IND|@N<": {POS: VERB},
    "<mv>|<cjt>|V|PS|3S|IND|@FS-<ACC": {POS: VERB},
    "<mv>|<cjt>|V|PS|3S|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|<cjt>|V|PS|3S|IND|@FS-<SUBJ": {POS: VERB},
    "<mv>|<cjt>|V|PS|3S|IND|@FS-ACC>": {POS: VERB},
    "<mv>|<cjt>|V|PS|3S|IND|@FS-N<": {POS: VERB},
    "<mv>|<cjt>|V|PS|3S|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|<cjt>|V|PS|3S|IND|@FS-P<": {POS: VERB},
    "<mv>|<cjt>|V|PS|3S|IND|@FS-QUE": {POS: VERB},
    "<mv>|<cjt>|V|PS|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|<cjt>|PERS|M/F|3S|ACC|@<ACC-PASS": {POS: PRON},
    "<mv>|<first-cjt>|<cjt>|V|INF|@ICL-N<PRED": {POS: VERB},
    "<mv>|<first-cjt>|<cjt>|V|PCP|M|S|@ICL-P<": {POS: VERB},
    "<mv>|<first-cjt>|<cjt>|V|PR|1S|IND|@FS-QUE": {POS: VERB},
    "<mv>|<first-cjt>|<cjt>|V|PR|3S|IND|@FS-KOMP<": {POS: VERB},
    "<mv>|<first-cjt>|<cjt>|V|PR|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|<hyphen>|<se-passive>|<cjt>|V|IMPF|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|<hyphen>|<se-passive>|V|GER|@ICL-<ADVL": {POS: VERB},
    "<mv>|<first-cjt>|<hyphen>|<se-passive>|V|INF|@ICL-<ACC": {POS: VERB},
    "<mv>|<first-cjt>|<hyphen>|<se-passive>|V|INF|@ICL-P<": {POS: VERB},
    "<mv>|<first-cjt>|<hyphen>|<se-passive>|V|PR|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|<hyphen>|<se-passive>|V|PR|3S|IND|@FS-ACC>": {POS: VERB},
    "<mv>|<first-cjt>|<hyphen>|<se-passive>|V|PR|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|<hyphen>|<se-passive>|V|PS/MQP|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|<hyphen>|<se-passive>|V|PS|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|<hyphen>|<se-passive>|V|PS|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|<hyphen>|V|GER|@ICL-<ADVL": {POS: VERB},
    "<mv>|<first-cjt>|<hyphen>|V|IMPF|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|<hyphen>|V|INF|1S|@ICL-P<": {POS: VERB},
    "<mv>|<first-cjt>|<hyphen>|V|INF|@ICL-<SUBJ": {POS: VERB},
    "<mv>|<first-cjt>|<hyphen>|V|INF|@ICL-P<": {POS: VERB},
    "<mv>|<first-cjt>|<hyphen>|V|PR|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|<hyphen>|V|PR|3S|IND|@FS-ACC>": {POS: VERB},
    "<mv>|<first-cjt>|<hyphen>|V|PR|3S|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|<first-cjt>|<hyphen>|V|PR|3S|IND|@FS-P<": {POS: VERB},
    "<mv>|<first-cjt>|<hyphen>|V|PR|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|<hyphen>|V|PR|3S|SUBJ|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|<hyphen>|V|PS|2S|IND|@FS-QUE": {POS: VERB},
    "<mv>|<first-cjt>|<hyphen>|V|PS|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|<hyphen>|V|PS|3S|IND|@FS-<ACC": {POS: VERB},
    "<mv>|<first-cjt>|<hyphen>|V|PS|3S|IND|@FS-ACC>": {POS: VERB},
    "<mv>|<first-cjt>|<hyphen>|V|PS|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|<n>|V|INF|3S|@ICL-P<": {POS: VERB},
    "<mv>|<first-cjt>|<n>|V|INF|@ICL-<ACC": {POS: VERB},
    "<mv>|<first-cjt>|<n>|V|PCP|F|P|@ICL-<ACC": {POS: VERB},
    "<mv>|<first-cjt>|<n>|V|PCP|F|S|@ICL-APP": {POS: VERB},
    "<mv>|<first-cjt>|<n>|V|PCP|M|P|@ICL-<ACC": {POS: VERB},
    "<mv>|<first-cjt>|<n>|V|PCP|M|P|@ICL-KOMP<": {POS: VERB},
    "<mv>|<first-cjt>|<n>|V|PCP|M|P|@ICL-P<": {POS: VERB},
    "<mv>|<first-cjt>|<n>|V|PCP|M|S|@ICL-KOMP<": {POS: VERB},
    "<mv>|<first-cjt>|<nil>|V|PCP|F|S|@ICL-N<PRED": {POS: VERB},
    "<mv>|<first-cjt>|<pc-ind>|V|PCP|@ICL-AUX<": {POS: VERB},
    "<mv>|<first-cjt>|<se-passive>|V|INF|3S|@ICL-P<": {POS: VERB},
    "<mv>|<first-cjt>|<se-passive>|V|PR|3S|IND|@FS-<ACC": {POS: VERB},
    "<mv>|<first-cjt>|<se-passive>|V|PR|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|V|COND|3S|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|V|FUT|1/3S|SUBJ|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|V|FUT|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|V|FUT|3S|IND|@FS-N<": {POS: VERB},
    "<mv>|<first-cjt>|V|FUT|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|V|FUT|3S|IND|@FS-UTT": {POS: VERB},
    "<mv>|<first-cjt>|V|FUT|3S|SUBJ|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|V|FUT|3S|SUBJ|@FS-UTT": {POS: VERB},
    "<mv>|<first-cjt>|V|GER|@ICL-<ACC": {POS: VERB},
    "<mv>|<first-cjt>|V|GER|@ICL-<ADVL": {POS: VERB},
    "<mv>|<first-cjt>|V|GER|@ICL-ADVL>": {POS: VERB},
    "<mv>|<first-cjt>|V|GER|@ICL-AUX<": {POS: VERB},
    "<mv>|<first-cjt>|V|GER|@ICL-N<": {POS: VERB},
    "<mv>|<first-cjt>|V|GER|@ICL-PRED>": {POS: VERB},
    "<mv>|<first-cjt>|V|GER|@ICL-STA": {POS: VERB},
    "<mv>|<first-cjt>|V|GER|@ICL-UTT": {POS: VERB},
    "<mv>|<first-cjt>|V|IMPF|1P|IND|@FS-ACC>": {POS: VERB},
    "<mv>|<first-cjt>|V|IMPF|1P|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|V|IMPF|1S|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|V|IMPF|3P|IND|@FS-P<": {POS: VERB},
    "<mv>|<first-cjt>|V|IMPF|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|V|IMPF|3S|IND|@FS-<ACC": {POS: AUX},
    "<mv>|<first-cjt>|V|IMPF|3S|IND|@FS-APP": {POS: VERB},
    "<mv>|<first-cjt>|V|IMPF|3S|IND|@FS-N<": {POS: VERB},
    "<mv>|<first-cjt>|V|IMPF|3S|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|<first-cjt>|V|IMPF|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|V|IMPF|3S|SUBJ|@FS-<ACC": {POS: VERB},
    "<mv>|<first-cjt>|V|INF|@ICL-<ACC": {POS: VERB},
    "<mv>|<first-cjt>|V|INF|@ICL-<PIV": {POS: VERB},
    "<mv>|<first-cjt>|V|INF|@ICL-<SC": {POS: VERB},
    "<mv>|<first-cjt>|V|INF|@ICL-<SUBJ": {POS: VERB},
    "<mv>|<first-cjt>|V|INF|@ICL-APP": {POS: VERB},
    "<mv>|<first-cjt>|V|INF|@ICL-AUX<": {POS: VERB},
    "<mv>|<first-cjt>|V|INF|@ICL-N<PRED": {POS: VERB},
    "<mv>|<first-cjt>|V|INF|@ICL-P<": {POS: VERB},
    "<mv>|<first-cjt>|V|INF|@ICL-QUE": {POS: VERB},
    "<mv>|<first-cjt>|V|INF|@ICL-SC>": {POS: VERB},
    "<mv>|<first-cjt>|V|INF|@ICL-SUBJ>": {POS: VERB},
    "<mv>|<first-cjt>|V|INF|@ICL-UTT": {POS: VERB},
    "<mv>|<first-cjt>|V|MQP|1/3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|V|MQP|1S|IND|@FS-STA": {POS: AUX},
    "<mv>|<first-cjt>|V|MQP|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|V|PCP|@ICL-AUX<": {POS: VERB},
    "<mv>|<first-cjt>|V|PCP|F|P|@ICL-<SC": {POS: VERB},
    "<mv>|<first-cjt>|V|PCP|F|P|@ICL-AUX<": {POS: VERB},
    "<mv>|<first-cjt>|V|PCP|F|P|@ICL-N<": {POS: VERB},
    "<mv>|<first-cjt>|V|PCP|F|P|@ICL-N<PRED": {POS: VERB},
    "<mv>|<first-cjt>|V|PCP|F|S|@ICL-<SC": {POS: VERB},
    "<mv>|<first-cjt>|V|PCP|F|S|@ICL->N": {POS: ADJ},
    "<mv>|<first-cjt>|V|PCP|F|S|@ICL-AUX<": {POS: VERB},
    "<mv>|<first-cjt>|V|PCP|F|S|@ICL-N<": {POS: VERB},
    "<mv>|<first-cjt>|V|PCP|F|S|@ICL-N<PRED": {POS: VERB},
    "<mv>|<first-cjt>|V|PCP|F|S|@ICL-PRED>": {POS: VERB},
    "<mv>|<first-cjt>|V|PCP|F|S|@ICL-UTT": {POS: VERB},
    "<mv>|<first-cjt>|V|PCP|M|P|@ICL-<SC": {POS: ADJ},
    "<mv>|<first-cjt>|V|PCP|M|P|@ICL-AUX<": {POS: VERB},
    "<mv>|<first-cjt>|V|PCP|M|P|@ICL-N<": {POS: VERB},
    "<mv>|<first-cjt>|V|PCP|M|P|@ICL-N<PRED": {POS: VERB},
    "<mv>|<first-cjt>|V|PCP|M|P|@ICL-PRED>": {POS: VERB},
    "<mv>|<first-cjt>|V|PCP|M|S|@ICL-<OC": {POS: VERB},
    "<mv>|<first-cjt>|V|PCP|M|S|@ICL-<SC": {POS: ADJ},
    "<mv>|<first-cjt>|V|PCP|M|S|@ICL-AUX<": {POS: VERB},
    "<mv>|<first-cjt>|V|PCP|M|S|@ICL-N<": {POS: VERB},
    "<mv>|<first-cjt>|V|PCP|M|S|@ICL-N<PRED": {POS: VERB},
    "<mv>|<first-cjt>|V|PCP|M|S|@ICL-PRED>": {POS: VERB},
    "<mv>|<first-cjt>|V|PCP|M|S|@ICL-STA": {POS: ADJ},
    "<mv>|<first-cjt>|V|PR|1/3S|SUBJ|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|V|PR|1P|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|V|PR|1S|IND|@FS-ACC>": {POS: VERB},
    "<mv>|<first-cjt>|V|PR|1S|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|V|PR|3P|IND|@FS-<ACC": {POS: VERB},
    "<mv>|<first-cjt>|V|PR|3P|IND|@FS-ACC>": {POS: VERB},
    "<mv>|<first-cjt>|V|PR|3P|IND|@FS-N<": {POS: VERB},
    "<mv>|<first-cjt>|V|PR|3P|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|<first-cjt>|V|PR|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|V|PR|3P|SUBJ|@FS-<ACC": {POS: VERB},
    "<mv>|<first-cjt>|V|PR|3P|SUBJ|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|V|PR|3S|IND|@FS-<ACC": {POS: VERB},
    "<mv>|<first-cjt>|V|PR|3S|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|<first-cjt>|V|PR|3S|IND|@FS-ACC>": {POS: VERB},
    "<mv>|<first-cjt>|V|PR|3S|IND|@FS-EXC": {POS: AUX},
    "<mv>|<first-cjt>|V|PR|3S|IND|@FS-N<": {POS: VERB},
    "<mv>|<first-cjt>|V|PR|3S|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|<first-cjt>|V|PR|3S|IND|@FS-QUE": {POS: VERB},
    "<mv>|<first-cjt>|V|PR|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|V|PR|3S|SUBJ|@FS-<ACC": {POS: VERB},
    "<mv>|<first-cjt>|V|PR|3S|SUBJ|@FS-N<PRED": {POS: VERB},
    "<mv>|<first-cjt>|V|PS|1P|IND|@FS-<SUBJ": {POS: VERB},
    "<mv>|<first-cjt>|V|PS|1P|IND|@FS-ACC>": {POS: VERB},
    "<mv>|<first-cjt>|V|PS|1P|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|<first-cjt>|V|PS|1P|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|V|PS|1S|IND|@FS-ACC>": {POS: VERB},
    "<mv>|<first-cjt>|V|PS|1S|IND|@FS-ADVL>": {POS: AUX},
    "<mv>|<first-cjt>|V|PS|1S|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|<first-cjt>|V|PS|1S|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|V|PS|3P|IND|@FS-N<": {POS: VERB},
    "<mv>|<first-cjt>|V|PS|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<first-cjt>|V|PS|3S|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|<first-cjt>|V|PS|3S|IND|@FS-ACC>": {POS: VERB},
    "<mv>|<first-cjt>|V|PS|3S|IND|@FS-N<": {POS: VERB},
    "<mv>|<first-cjt>|V|PS|3S|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|<first-cjt>|V|PS|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<foc>|V|PS|1P|@FS-<ADVL": {POS: AUX},
    "<mv>|<foreign>|V|IMP|2S|@FS-N<PRED": {POS: VERB},
    "<mv>|<hyphen>|<cjt>|V|INF|@ICL-<ACC": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|<cjt>|V|PR|3P|SUBJ|@FS-STA": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|COND|3S|@FS-STA": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|FUT|3S|IND|@FS-APP": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|FUT|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|GER|@ICL-<ADVL": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|GER|@ICL-<PRED": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|GER|@ICL-ADVL>": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|GER|@ICL-AUX<": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|GER|@ICL-P<": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|IMPF|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|IMPF|3S|IND|@FS-<ACC": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|IMPF|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|INF|3P|@ICL-<SUBJ": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|INF|3P|@ICL-P<": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|INF|3S|@ICL-<ACC": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|INF|3S|@ICL-P<": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|INF|@ICL-<ACC": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|INF|@ICL-<SC": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|INF|@ICL-<SUBJ": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|INF|@ICL-AUX<": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|INF|@ICL-P<": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|INF|@ICL-SUBJ>": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|MQP|1/3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|MQP|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|PR|1/3S|SUBJ|@FS-STA": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|PR|3P|IND|@FS-<ACC": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|PR|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|PR|3S|IND|@FS-<ACC": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|PR|3S|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|PR|3S|IND|@FS-ACC>": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|PR|3S|IND|@FS-QUE": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|PR|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|PR|3S|SUBJ|@FS-STA": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|PS|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|PS|3S|IND|@FS-<ACC": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|PS|3S|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|<hyphen>|<se-passive>|V|PS|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<hyphen>|V|COND|1S|@FS-STA": {POS: VERB},
    "<mv>|<hyphen>|V|COND|3S|@FS-STA": {POS: VERB},
    "<mv>|<hyphen>|V|FUT|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<hyphen>|V|GER|@ICL-<ADVL": {POS: VERB},
    "<mv>|<hyphen>|V|GER|@ICL-<PRED": {POS: AUX},
    "<mv>|<hyphen>|V|GER|@ICL-ADVL>": {POS: VERB},
    "<mv>|<hyphen>|V|GER|@ICL-AUX<": {POS: VERB},
    "<mv>|<hyphen>|V|GER|@ICL-UTT": {POS: AUX},
    "<mv>|<hyphen>|V|IMPF|3P|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|<hyphen>|V|IMPF|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<hyphen>|V|IMPF|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<hyphen>|V|INF|3P|@ICL-<ACC": {POS: VERB},
    "<mv>|<hyphen>|V|INF|@ICL-<ACC": {POS: VERB},
    "<mv>|<hyphen>|V|INF|@ICL-<ADVL": {POS: VERB},
    "<mv>|<hyphen>|V|INF|@ICL-<SC": {POS: VERB},
    "<mv>|<hyphen>|V|INF|@ICL-<SUBJ": {POS: VERB},
    "<mv>|<hyphen>|V|INF|@ICL-AUX<": {POS: VERB},
    "<mv>|<hyphen>|V|INF|@ICL-P<": {POS: VERB},
    "<mv>|<hyphen>|V|PR|1/3S|SUBJ|@FS-STA": {POS: VERB},
    "<mv>|<hyphen>|V|PR|1P|IND|@FS-<SC": {POS: VERB},
    "<mv>|<hyphen>|V|PR|1S|IND|@FS-STA": {POS: VERB},
    "<mv>|<hyphen>|V|PR|3P|IND|@FS-P<": {POS: VERB},
    "<mv>|<hyphen>|V|PR|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<hyphen>|V|PR|3P|SUBJ|@FS-STA": {POS: VERB},
    "<mv>|<hyphen>|V|PR|3S|IND|@FS-<ACC": {POS: VERB},
    "<mv>|<hyphen>|V|PR|3S|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|<hyphen>|V|PR|3S|IND|@FS-<SUBJ": {POS: VERB},
    "<mv>|<hyphen>|V|PR|3S|IND|@FS-ACC>": {POS: VERB},
    "<mv>|<hyphen>|V|PR|3S|IND|@FS-ADVL>": {POS: VERB},
    "<mv>|<hyphen>|V|PR|3S|IND|@FS-N<": {POS: VERB},
    "<mv>|<hyphen>|V|PR|3S|IND|@FS-P<": {POS: VERB},
    "<mv>|<hyphen>|V|PR|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<hyphen>|V|PR|3S|IND|@ICL-AUX<": {POS: VERB},
    "<mv>|<hyphen>|V|PR|3S|SUBJ|@FS-<ADVL": {POS: VERB},
    "<mv>|<hyphen>|V|PR|3S|SUBJ|@FS-ADVL>": {POS: AUX},
    "<mv>|<hyphen>|V|PR|3S|SUBJ|@FS-N<PRED": {POS: VERB},
    "<mv>|<hyphen>|V|PR|3S|SUBJ|@FS-STA": {POS: VERB},
    "<mv>|<hyphen>|V|PS/MQP|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<hyphen>|V|PS|1S|IND|@FS-ACC>": {POS: VERB},
    "<mv>|<hyphen>|V|PS|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<hyphen>|V|PS|3S|IND|@FS-ACC>": {POS: VERB},
    "<mv>|<hyphen>|V|PS|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<mqpc-ind>|V|PCP|@ICL-AUX<": {POS: VERB},
    "<mv>|<mqpc-ind>|V|PCP|M|S|@ICL-AUX<": {POS: VERB},
    "<mv>|<mqpc-subj>|V|PCP|@ICL-AUX<": {POS: VERB},
    "<mv>|<n>|<cjt>|V|PCP|M|P|@ICL-P<": {POS: VERB},
    "<mv>|<n>|V|INF|3S|@ICL-<ACC": {POS: VERB},
    "<mv>|<n>|V|INF|@ICL-P<": {POS: VERB},
    "<mv>|<n>|V|INF|@ICL-SUBJ>": {POS: VERB},
    "<mv>|<n>|V|INF|M|S|@ICL-UTT": {POS: VERB},
    "<mv>|<n>|V|PCP|F|P|@ICL-<SC": {POS: ADJ},
    "<mv>|<n>|V|PCP|F|P|@ICL-N<": {POS: VERB},
    "<mv>|<n>|V|PCP|F|P|@ICL-P<": {POS: VERB},
    "<mv>|<n>|V|PCP|F|P|@ICL-SUBJ>": {POS: VERB},
    "<mv>|<n>|V|PCP|F|S|@ICL-<ACC": {POS: VERB},
    "<mv>|<n>|V|PCP|F|S|@ICL-<OC": {POS: ADJ},
    "<mv>|<n>|V|PCP|F|S|@ICL-<SC": {POS: VERB},
    "<mv>|<n>|V|PCP|F|S|@ICL-APP": {POS: VERB},
    "<mv>|<n>|V|PCP|F|S|@ICL-N<": {POS: VERB},
    "<mv>|<n>|V|PCP|F|S|@ICL-P<": {POS: VERB},
    "<mv>|<n>|V|PCP|F|S|@ICL-SUBJ>": {POS: VERB},
    "<mv>|<n>|V|PCP|F|S|@ICL-UTT": {POS: VERB},
    "<mv>|<n>|V|PCP|M|P|@ICL-<ACC": {POS: VERB},
    "<mv>|<n>|V|PCP|M|P|@ICL-<OC": {POS: VERB},
    "<mv>|<n>|V|PCP|M|P|@ICL-<SC": {POS: VERB},
    "<mv>|<n>|V|PCP|M|P|@ICL-N<": {POS: VERB},
    "<mv>|<n>|V|PCP|M|P|@ICL-P<": {POS: VERB},
    "<mv>|<n>|V|PCP|M|P|@ICL-SUBJ>": {POS: VERB},
    "<mv>|<n>|V|PCP|M|P|@ICL-UTT": {POS: VERB},
    "<mv>|<n>|V|PCP|M|S|@ICL-<ACC": {POS: VERB},
    "<mv>|<n>|V|PCP|M|S|@ICL-<SC": {POS: VERB},
    "<mv>|<n>|V|PCP|M|S|@ICL-ADVL>": {POS: VERB},
    "<mv>|<n>|V|PCP|M|S|@ICL-N<": {POS: VERB},
    "<mv>|<n>|V|PCP|M|S|@ICL-P<": {POS: VERB},
    "<mv>|<n>|V|PCP|M|S|@ICL-PRED>": {POS: VERB},
    "<mv>|<n>|V|PCP|M|S|@ICL-SUBJ>": {POS: VERB},
    "<mv>|<n>|V|PR|3S|IND|@FS-<ACC": {POS: VERB},
    "<mv>|<nil>|V|INF|@ICL-<ACC": {POS: VERB},
    "<mv>|<nil>|V|PS|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<np-idf>|N|M|S|@N<": {POS: NOUN},
    "<mv>|<obj>|V|INF|@ICL-<ACC": {POS: VERB},
    "<mv>|<pass>|<error>|V|PCP|F|P|@ICL-AUX<": {POS: VERB},
    "<mv>|<pass>|<nil>|V|PCP|M|S|@ICL-AUX<": {POS: VERB},
    "<mv>|<pass>|V|PCP|F|P|@ICL-AUX<": {POS: VERB},
    "<mv>|<pass>|V|PCP|F|S|@ICL-AUX<": {POS: VERB},
    "<mv>|<pass>|V|PCP|M|P|@ICL-AUX<": {POS: VERB},
    "<mv>|<pass>|V|PCP|M|S|@ICL-AUX<": {POS: VERB},
    "<mv>|<pc-ind>|V|PCP|@ICL-AUX<": {POS: VERB},
    "<mv>|<pc-ind>|V|PCP|F|S|@ICL-AUX<": {POS: VERB},
    "<mv>|<pc-subj>|V|PCP|@ICL-AUX<": {POS: VERB},
    "<mv>|<prop>|V|PCP|F|S|@ICL-<SC": {POS: ADJ},
    "<mv>|<prop>|V|PCP|M|P|@ICL-STA": {POS: VERB},
    "<mv>|<se-passive>|<mqpc-ind>|V|PCP|@ICL-AUX<": {POS: VERB},
    "<mv>|<se-passive>|<mqpc-ind>|V|PCP|M|S|@ICL-AUX<": {POS: VERB},
    "<mv>|<se-passive>|<pc-ind>|V|PCP|@ICL-AUX<": {POS: VERB},
    "<mv>|<se-passive>|V|COND|3P|@FS-<ACC": {POS: VERB},
    "<mv>|<se-passive>|V|COND|3S|@FS-<ACC": {POS: VERB},
    "<mv>|<se-passive>|V|COND|3S|@FS-N<": {POS: VERB},
    "<mv>|<se-passive>|V|COND|3S|@FS-P<": {POS: VERB},
    "<mv>|<se-passive>|V|FUT|3P|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|<se-passive>|V|FUT|3P|IND|@FS-UTT": {POS: VERB},
    "<mv>|<se-passive>|V|FUT|3P|SUBJ|@FS-<ADVL": {POS: VERB},
    "<mv>|<se-passive>|V|FUT|3P|SUBJ|@FS-ADVL>": {POS: VERB},
    "<mv>|<se-passive>|V|FUT|3S|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|<se-passive>|V|FUT|3S|IND|@FS-APP": {POS: VERB},
    "<mv>|<se-passive>|V|FUT|3S|IND|@FS-N<": {POS: VERB},
    "<mv>|<se-passive>|V|FUT|3S|IND|@FS-QUE": {POS: VERB},
    "<mv>|<se-passive>|V|FUT|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<se-passive>|V|FUT|3S|SUBJ|@FS-ADVL>": {POS: VERB},
    "<mv>|<se-passive>|V|FUT|3S|SUBJ|@FS-P<": {POS: VERB},
    "<mv>|<se-passive>|V|FUT|3S|SUBJ|@FS-SUBJ>": {POS: VERB},
    "<mv>|<se-passive>|V|GER|@ICL-<ADVL": {POS: VERB},
    "<mv>|<se-passive>|V|GER|@ICL-AUX<": {POS: VERB},
    "<mv>|<se-passive>|V|IMPF|3P|IND|@FS-<ACC": {POS: VERB},
    "<mv>|<se-passive>|V|IMPF|3P|IND|@FS-KOMP<": {POS: VERB},
    "<mv>|<se-passive>|V|IMPF|3P|IND|@FS-N<": {POS: VERB},
    "<mv>|<se-passive>|V|IMPF|3P|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|<se-passive>|V|IMPF|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<se-passive>|V|IMPF|3P|SUBJ|@FS-<ACC": {POS: VERB},
    "<mv>|<se-passive>|V|IMPF|3P|SUBJ|@FS-N<": {POS: VERB},
    "<mv>|<se-passive>|V|IMPF|3S|IND|@FS-<ACC": {POS: VERB},
    "<mv>|<se-passive>|V|IMPF|3S|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|<se-passive>|V|IMPF|3S|IND|@FS-N<": {POS: VERB},
    "<mv>|<se-passive>|V|IMPF|3S|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|<se-passive>|V|IMPF|3S|IND|@FS-P<": {POS: VERB},
    "<mv>|<se-passive>|V|IMPF|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<se-passive>|V|IMPF|3S|SUBJ|@FS-<ACC": {POS: VERB},
    "<mv>|<se-passive>|V|IMPF|3S|SUBJ|@FS-<SUBJ": {POS: VERB},
    "<mv>|<se-passive>|V|IMPF|3S|SUBJ|@FS-KOMP<": {POS: VERB},
    "<mv>|<se-passive>|V|IMPF|3S|SUBJ|@FS-N<": {POS: VERB},
    "<mv>|<se-passive>|V|IMPF|3S|SUBJ|@FS-P<": {POS: VERB},
    "<mv>|<se-passive>|V|INF|3P|@ICL-P<": {POS: VERB},
    "<mv>|<se-passive>|V|INF|3S|@ICL-<ACC": {POS: VERB},
    "<mv>|<se-passive>|V|INF|3S|@ICL-AUX<": {POS: VERB},
    "<mv>|<se-passive>|V|INF|3S|@ICL-P<": {POS: VERB},
    "<mv>|<se-passive>|V|INF|@ICL-<ACC": {POS: VERB},
    "<mv>|<se-passive>|V|INF|@ICL-<SC": {POS: VERB},
    "<mv>|<se-passive>|V|INF|@ICL-<SUBJ": {POS: VERB},
    "<mv>|<se-passive>|V|INF|@ICL-AUX<": {POS: VERB},
    "<mv>|<se-passive>|V|INF|@ICL-P<": {POS: VERB},
    "<mv>|<se-passive>|V|MQP|3P|IND|@FS-N<": {POS: VERB},
    "<mv>|<se-passive>|V|MQP|3S|IND|@FS-N<": {POS: VERB},
    "<mv>|<se-passive>|V|PCP|@ICL-AUX<": {POS: VERB},
    "<mv>|<se-passive>|V|PCP|M|S|@ICL-AUX<": {POS: VERB},
    "<mv>|<se-passive>|V|PR|3P|IND|@FS-<ACC": {POS: VERB},
    "<mv>|<se-passive>|V|PR|3P|IND|@FS-<SC": {POS: VERB},
    "<mv>|<se-passive>|V|PR|3P|IND|@FS-<SUBJ": {POS: VERB},
    "<mv>|<se-passive>|V|PR|3P|IND|@FS-ADVL>": {POS: VERB},
    "<mv>|<se-passive>|V|PR|3P|IND|@FS-N<": {POS: VERB},
    "<mv>|<se-passive>|V|PR|3P|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|<se-passive>|V|PR|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<se-passive>|V|PR|3P|SUBJ|@FS-<ACC": {POS: VERB},
    "<mv>|<se-passive>|V|PR|3P|SUBJ|@FS-<ADVL": {POS: VERB},
    "<mv>|<se-passive>|V|PR|3P|SUBJ|@FS-ADVL>": {POS: VERB},
    "<mv>|<se-passive>|V|PR|3P|SUBJ|@FS-N<PRED": {POS: VERB},
    "<mv>|<se-passive>|V|PR|3P|SUBJ|@FS-P<": {POS: VERB},
    "<mv>|<se-passive>|V|PR|3S|IND|@FS-<ACC": {POS: VERB},
    "<mv>|<se-passive>|V|PR|3S|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|<se-passive>|V|PR|3S|IND|@FS-<SUBJ": {POS: VERB},
    "<mv>|<se-passive>|V|PR|3S|IND|@FS-A<": {POS: VERB},
    "<mv>|<se-passive>|V|PR|3S|IND|@FS-ACC>": {POS: VERB},
    "<mv>|<se-passive>|V|PR|3S|IND|@FS-ADVL>": {POS: VERB},
    "<mv>|<se-passive>|V|PR|3S|IND|@FS-N<": {POS: VERB},
    "<mv>|<se-passive>|V|PR|3S|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|<se-passive>|V|PR|3S|IND|@FS-P<": {POS: VERB},
    "<mv>|<se-passive>|V|PR|3S|IND|@FS-QUE": {POS: VERB},
    "<mv>|<se-passive>|V|PR|3S|IND|@FS-S<": {POS: VERB},
    "<mv>|<se-passive>|V|PR|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|<se-passive>|V|PR|3S|SUBJ|@FS-<ACC": {POS: VERB},
    "<mv>|<se-passive>|V|PR|3S|SUBJ|@FS-<SUBJ": {POS: VERB},
    "<mv>|<se-passive>|V|PR|3S|SUBJ|@FS-ADVL>": {POS: VERB},
    "<mv>|<se-passive>|V|PR|3S|SUBJ|@FS-P<": {POS: VERB},
    "<mv>|<se-passive>|V|PS/MQP|3P|IND|@FS-<ACC": {POS: VERB},
    "<mv>|<se-passive>|V|PS/MQP|3P|IND|@FS-N<": {POS: VERB},
    "<mv>|<se-passive>|V|PS/MQP|3P|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|<se-passive>|V|PS/MQP|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<se-passive>|V|PS|3P|IND|@FS-<ACC": {POS: VERB},
    "<mv>|<se-passive>|V|PS|3P|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|<se-passive>|V|PS|3P|IND|@FS-ACC>": {POS: VERB},
    "<mv>|<se-passive>|V|PS|3P|IND|@FS-ADVL>": {POS: VERB},
    "<mv>|<se-passive>|V|PS|3P|IND|@FS-N<": {POS: VERB},
    "<mv>|<se-passive>|V|PS|3P|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|<se-passive>|V|PS|3P|IND|@FS-P<": {POS: VERB},
    "<mv>|<se-passive>|V|PS|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|<se-passive>|V|PS|3S|IND|@FS-<ACC": {POS: VERB},
    "<mv>|<se-passive>|V|PS|3S|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|<se-passive>|V|PS|3S|IND|@FS-<SC": {POS: VERB},
    "<mv>|<se-passive>|V|PS|3S|IND|@FS-<SUBJ": {POS: VERB},
    "<mv>|<se-passive>|V|PS|3S|IND|@FS-ADVL>": {POS: VERB},
    "<mv>|<se-passive>|V|PS|3S|IND|@FS-N<": {POS: VERB},
    "<mv>|<se-passive>|V|PS|3S|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|<se-passive>|V|PS|3S|IND|@FS-P<": {POS: VERB},
    "<mv>|<se-passive>|V|PS|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|V|@<ADVL": {POS: VERB},
    "<mv>|V|COND|1/3S|@FS-STA": {POS: VERB},
    "<mv>|V|COND|1P|@FS-STA": {POS: VERB},
    "<mv>|V|COND|1S|@FS-<ACC": {POS: VERB},
    "<mv>|V|COND|1S|@FS-EXC": {POS: VERB},
    "<mv>|V|COND|1S|@FS-STA": {POS: VERB},
    "<mv>|V|COND|1|@FS-STA": {POS: VERB},
    "<mv>|V|COND|3P|@FS-<ACC": {POS: VERB},
    "<mv>|V|COND|3P|@FS-<SC": {POS: VERB},
    "<mv>|V|COND|3P|@FS-N<": {POS: VERB},
    "<mv>|V|COND|3P|@FS-N<PRED": {POS: AUX},
    "<mv>|V|COND|3P|@FS-P<": {POS: VERB},
    "<mv>|V|COND|3P|@FS-STA": {POS: VERB},
    "<mv>|V|COND|3S|@FS-<ACC": {POS: VERB},
    "<mv>|V|COND|3S|@FS-<ADVL": {POS: VERB},
    "<mv>|V|COND|3S|@FS-<SC": {POS: VERB},
    "<mv>|V|COND|3S|@FS-<SUBJ": {POS: VERB},
    "<mv>|V|COND|3S|@FS-ACC>": {POS: VERB},
    "<mv>|V|COND|3S|@FS-ADVL": {POS: VERB},
    "<mv>|V|COND|3S|@FS-ADVL>": {POS: VERB},
    "<mv>|V|COND|3S|@FS-KOMP<": {POS: VERB},
    "<mv>|V|COND|3S|@FS-N<": {POS: VERB},
    "<mv>|V|COND|3S|@FS-N<PRED": {POS: VERB},
    "<mv>|V|COND|3S|@FS-P<": {POS: VERB},
    "<mv>|V|COND|3S|@FS-QUE": {POS: VERB},
    "<mv>|V|COND|3S|@FS-S<": {POS: VERB},
    "<mv>|V|COND|3S|@FS-STA": {POS: VERB},
    "<mv>|V|FUT|1/3S|SUBJ|@FS-ADVL>": {POS: VERB},
    "<mv>|V|FUT|1/3S|SUBJ|@FS-STA": {POS: VERB},
    "<mv>|V|FUT|1P|IND|@FS-<ACC": {POS: AUX},
    "<mv>|V|FUT|1P|IND|@FS-ACC>": {POS: VERB},
    "<mv>|V|FUT|1P|IND|@FS-STA": {POS: VERB},
    "<mv>|V|FUT|1P|SUBJ|@FS-<ADVL": {POS: VERB},
    "<mv>|V|FUT|1P|SUBJ|@FS-ADVL>": {POS: VERB},
    "<mv>|V|FUT|1P|SUBJ|@FS-N<": {POS: VERB},
    "<mv>|V|FUT|1P|SUBJ|@FS-STA": {POS: VERB},
    "<mv>|V|FUT|1S|IND|@FS-<ACC": {POS: VERB},
    "<mv>|V|FUT|1S|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|V|FUT|1S|IND|@FS-STA": {POS: VERB},
    "<mv>|V|FUT|1S|SUBJ|@FS-N<": {POS: VERB},
    "<mv>|V|FUT|2S|IND|@FS-STA": {POS: VERB},
    "<mv>|V|FUT|3P|IND|@FS-<ACC": {POS: VERB},
    "<mv>|V|FUT|3P|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|V|FUT|3P|IND|@FS-<SC": {POS: AUX},
    "<mv>|V|FUT|3P|IND|@FS-<SUBJ": {POS: VERB},
    "<mv>|V|FUT|3P|IND|@FS-A<": {POS: VERB},
    "<mv>|V|FUT|3P|IND|@FS-ACC>": {POS: VERB},
    "<mv>|V|FUT|3P|IND|@FS-N<": {POS: VERB},
    "<mv>|V|FUT|3P|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|V|FUT|3P|IND|@FS-QUE": {POS: VERB},
    "<mv>|V|FUT|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|V|FUT|3P|SUBJ|@FS-<ADVL": {POS: VERB},
    "<mv>|V|FUT|3P|SUBJ|@FS-<SC": {POS: VERB},
    "<mv>|V|FUT|3P|SUBJ|@FS-ADVL>": {POS: VERB},
    "<mv>|V|FUT|3P|SUBJ|@FS-N<": {POS: VERB},
    "<mv>|V|FUT|3S|IND|@FS-<ACC": {POS: VERB},
    "<mv>|V|FUT|3S|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|V|FUT|3S|IND|@FS-<PRED": {POS: AUX},
    "<mv>|V|FUT|3S|IND|@FS-<SC": {POS: VERB},
    "<mv>|V|FUT|3S|IND|@FS-<SUBJ": {POS: VERB},
    "<mv>|V|FUT|3S|IND|@FS-A<": {POS: VERB},
    "<mv>|V|FUT|3S|IND|@FS-ACC>": {POS: VERB},
    "<mv>|V|FUT|3S|IND|@FS-N<": {POS: VERB},
    "<mv>|V|FUT|3S|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|V|FUT|3S|IND|@FS-P<": {POS: VERB},
    "<mv>|V|FUT|3S|IND|@FS-QUE": {POS: VERB},
    "<mv>|V|FUT|3S|IND|@FS-S<": {POS: VERB},
    "<mv>|V|FUT|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|V|FUT|3S|IND|@FS-UTT": {POS: VERB},
    "<mv>|V|FUT|3S|SUBJ|@FS-<ACC": {POS: VERB},
    "<mv>|V|FUT|3S|SUBJ|@FS-<ADVL": {POS: VERB},
    "<mv>|V|FUT|3S|SUBJ|@FS-<SC": {POS: VERB},
    "<mv>|V|FUT|3S|SUBJ|@FS-ADVL>": {POS: VERB},
    "<mv>|V|FUT|3S|SUBJ|@FS-AUX<": {POS: VERB},
    "<mv>|V|FUT|3S|SUBJ|@FS-KOMP<": {POS: VERB},
    "<mv>|V|FUT|3S|SUBJ|@FS-N<": {POS: VERB},
    "<mv>|V|FUT|3S|SUBJ|@FS-N<PRED": {POS: VERB},
    "<mv>|V|FUT|3S|SUBJ|@FS-P<": {POS: VERB},
    "<mv>|V|FUT|3S|SUBJ|@FS-STA": {POS: VERB},
    "<mv>|V|FUT|3S|SUBJ|@FS-SUBJ>": {POS: VERB},
    "<mv>|V|GER|@ADVL>": {POS: AUX},
    "<mv>|V|GER|@ICL-<ACC": {POS: VERB},
    "<mv>|V|GER|@ICL-<ADVL": {POS: VERB},
    "<mv>|V|GER|@ICL-<OC": {POS: VERB},
    "<mv>|V|GER|@ICL-<PRED": {POS: VERB},
    "<mv>|V|GER|@ICL-<SC": {POS: VERB},
    "<mv>|V|GER|@ICL-<SUBJ": {POS: VERB},
    "<mv>|V|GER|@ICL-ADVL>": {POS: VERB},
    "<mv>|V|GER|@ICL-AUX<": {POS: VERB},
    "<mv>|V|GER|@ICL-CO": {POS: VERB},
    "<mv>|V|GER|@ICL-N<": {POS: VERB},
    "<mv>|V|GER|@ICL-N<PRED": {POS: VERB},
    "<mv>|V|GER|@ICL-P<": {POS: VERB},
    "<mv>|V|GER|@ICL-PRED>": {POS: VERB},
    "<mv>|V|GER|@ICL-STA": {POS: VERB},
    "<mv>|V|GER|@ICL-UTT": {POS: VERB},
    "<mv>|V|GER|@P<": {POS: AUX},
    "<mv>|V|IMPF|1/3S|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|V|IMPF|1/3S|IND|@FS-STA": {POS: VERB},
    "<mv>|V|IMPF|1/3S|SUBJ|@FS-ADVL>": {POS: AUX},
    "<mv>|V|IMPF|1P|IND|@FS-<ACC": {POS: VERB},
    "<mv>|V|IMPF|1P|IND|@FS-<ADVL": {POS: AUX},
    "<mv>|V|IMPF|1P|IND|@FS-ADVL>": {POS: VERB},
    "<mv>|V|IMPF|1P|IND|@FS-KOMP<": {POS: VERB},
    "<mv>|V|IMPF|1P|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|V|IMPF|1P|IND|@FS-P<": {POS: VERB},
    "<mv>|V|IMPF|1P|IND|@FS-STA": {POS: VERB},
    "<mv>|V|IMPF|1P|SUBJ|@FS-ADVL>": {POS: VERB},
    "<mv>|V|IMPF|1P|SUBJ|@FS-STA": {POS: VERB},
    "<mv>|V|IMPF|1S|IND|@FS-<ACC": {POS: VERB},
    "<mv>|V|IMPF|1S|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|V|IMPF|1S|IND|@FS-<SUBJ": {POS: VERB},
    "<mv>|V|IMPF|1S|IND|@FS-ACC>": {POS: VERB},
    "<mv>|V|IMPF|1S|IND|@FS-ADVL>": {POS: AUX},
    "<mv>|V|IMPF|1S|IND|@FS-N<": {POS: VERB},
    "<mv>|V|IMPF|1S|IND|@FS-STA": {POS: VERB},
    "<mv>|V|IMPF|1S|SUBJ|@FS-<ACC": {POS: VERB},
    "<mv>|V|IMPF|1S|SUBJ|@FS-ADVL>": {POS: VERB},
    "<mv>|V|IMPF|1|IND|@FS-STA": {POS: VERB},
    "<mv>|V|IMPF|3P|IND|@FS-<ACC": {POS: VERB},
    "<mv>|V|IMPF|3P|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|V|IMPF|3P|IND|@FS-<PRED": {POS: VERB},
    "<mv>|V|IMPF|3P|IND|@FS-<SUBJ": {POS: VERB},
    "<mv>|V|IMPF|3P|IND|@FS-ADVL>": {POS: VERB},
    "<mv>|V|IMPF|3P|IND|@FS-N<": {POS: VERB},
    "<mv>|V|IMPF|3P|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|V|IMPF|3P|IND|@FS-P<": {POS: VERB},
    "<mv>|V|IMPF|3P|IND|@FS-QUE": {POS: VERB},
    "<mv>|V|IMPF|3P|IND|@FS-S<": {POS: VERB},
    "<mv>|V|IMPF|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|V|IMPF|3P|IND|@FS-SUBJ>": {POS: VERB},
    "<mv>|V|IMPF|3P|SUBJ|@FS-<ACC": {POS: VERB},
    "<mv>|V|IMPF|3P|SUBJ|@FS-<ADVL": {POS: VERB},
    "<mv>|V|IMPF|3P|SUBJ|@FS-<SUBJ": {POS: VERB},
    "<mv>|V|IMPF|3P|SUBJ|@FS-ADVL>": {POS: VERB},
    "<mv>|V|IMPF|3P|SUBJ|@FS-N<": {POS: VERB},
    "<mv>|V|IMPF|3P|SUBJ|@FS-P<": {POS: VERB},
    "<mv>|V|IMPF|3S|IND|@FS-<ACC": {POS: VERB},
    "<mv>|V|IMPF|3S|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|V|IMPF|3S|IND|@FS-<SC": {POS: VERB},
    "<mv>|V|IMPF|3S|IND|@FS-<SUBJ": {POS: VERB},
    "<mv>|V|IMPF|3S|IND|@FS-A<": {POS: VERB},
    "<mv>|V|IMPF|3S|IND|@FS-ACC>": {POS: VERB},
    "<mv>|V|IMPF|3S|IND|@FS-ADVL>": {POS: VERB},
    "<mv>|V|IMPF|3S|IND|@FS-EXC": {POS: VERB},
    "<mv>|V|IMPF|3S|IND|@FS-KOMP<": {POS: VERB},
    "<mv>|V|IMPF|3S|IND|@FS-N<": {POS: VERB},
    "<mv>|V|IMPF|3S|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|V|IMPF|3S|IND|@FS-P<": {POS: VERB},
    "<mv>|V|IMPF|3S|IND|@FS-QUE": {POS: VERB},
    "<mv>|V|IMPF|3S|IND|@FS-S<": {POS: VERB},
    "<mv>|V|IMPF|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|V|IMPF|3S|IND|@FS-SUBJ>": {POS: VERB},
    "<mv>|V|IMPF|3S|SUBJ|@FS-<ACC": {POS: VERB},
    "<mv>|V|IMPF|3S|SUBJ|@FS-<ADVL": {POS: VERB},
    "<mv>|V|IMPF|3S|SUBJ|@FS-<SC": {POS: VERB},
    "<mv>|V|IMPF|3S|SUBJ|@FS-<SUBJ": {POS: VERB},
    "<mv>|V|IMPF|3S|SUBJ|@FS-ADVL>": {POS: VERB},
    "<mv>|V|IMPF|3S|SUBJ|@FS-N<": {POS: VERB},
    "<mv>|V|IMPF|3S|SUBJ|@FS-P<": {POS: VERB},
    "<mv>|V|IMP|2S|@FS-<ADVL": {POS: VERB},
    "<mv>|V|IMP|2S|@FS-CMD": {POS: VERB},
    "<mv>|V|INF|1P|@ICL-<SUBJ": {POS: VERB},
    "<mv>|V|INF|1P|@ICL-P<": {POS: VERB},
    "<mv>|V|INF|1S|@ICL-<ACC": {POS: VERB},
    "<mv>|V|INF|3P|@ICL-<ACC": {POS: VERB},
    "<mv>|V|INF|3P|@ICL-<SC": {POS: VERB},
    "<mv>|V|INF|3P|@ICL-<SUBJ": {POS: VERB},
    "<mv>|V|INF|3P|@ICL-AUX<": {POS: VERB},
    "<mv>|V|INF|3P|@ICL-P<": {POS: VERB},
    "<mv>|V|INF|3S|@ICL-<ACC": {POS: VERB},
    "<mv>|V|INF|3S|@ICL-<SC": {POS: VERB},
    "<mv>|V|INF|3S|@ICL-<SUBJ": {POS: VERB},
    "<mv>|V|INF|3S|@ICL-ADVL>": {POS: VERB},
    "<mv>|V|INF|3S|@ICL-AUX<": {POS: VERB},
    "<mv>|V|INF|3S|@ICL-P<": {POS: VERB},
    "<mv>|V|INF|3S|@ICL-STA": {POS: VERB},
    "<mv>|V|INF|3S|@ICL-SUBJ>": {POS: AUX},
    "<mv>|V|INF|@ICL-<ACC": {POS: VERB},
    "<mv>|V|INF|@ICL-<ADVL": {POS: VERB},
    "<mv>|V|INF|@ICL-<OC": {POS: VERB},
    "<mv>|V|INF|@ICL-<PRED": {POS: VERB},
    "<mv>|V|INF|@ICL-<SC": {POS: VERB},
    "<mv>|V|INF|@ICL-<SUBJ": {POS: VERB},
    "<mv>|V|INF|@ICL-<sUBJ": {POS: VERB},
    "<mv>|V|INF|@ICL->>P": {POS: VERB},
    "<mv>|V|INF|@ICL-A<": {POS: VERB},
    "<mv>|V|INF|@ICL-ACC>": {POS: VERB},
    "<mv>|V|INF|@ICL-ADVL>": {POS: VERB},
    "<mv>|V|INF|@ICL-APP": {POS: VERB},
    "<mv>|V|INF|@ICL-AUX<": {POS: VERB},
    "<mv>|V|INF|@ICL-COM": {POS: VERB},
    "<mv>|V|INF|@ICL-KOMP<": {POS: VERB},
    "<mv>|V|INF|@ICL-N<": {POS: VERB},
    "<mv>|V|INF|@ICL-N<PRED": {POS: VERB},
    "<mv>|V|INF|@ICL-P<": {POS: VERB},
    "<mv>|V|INF|@ICL-QUE": {POS: VERB},
    "<mv>|V|INF|@ICL-STA": {POS: VERB},
    "<mv>|V|INF|@ICL-SUBJ>": {POS: VERB},
    "<mv>|V|INF|@ICL-UTT": {POS: VERB},
    "<mv>|V|MQP|3P|IND|@FS-<ACC": {POS: VERB},
    "<mv>|V|MQP|3P|IND|@FS-N<": {POS: VERB},
    "<mv>|V|MQP|3P|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|V|MQP|3P|IND|@FS-QUE": {POS: VERB},
    "<mv>|V|MQP|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|V|MQP|3S|IND|@FS-<ACC": {POS: VERB},
    "<mv>|V|MQP|3S|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|V|MQP|3S|IND|@FS-N<": {POS: VERB},
    "<mv>|V|MQP|3S|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|V|MQP|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|V|PCP2|PAS|F|P|@ICL-AUX<": {POS: VERB},
    "<mv>|V|PCP|@ICL-AUX<": {POS: VERB},
    "<mv>|V|PCP|@ICL-N<": {POS: VERB},
    "<mv>|V|PCP|F|P|@ICL-<ADVL": {POS: VERB},
    "<mv>|V|PCP|F|P|@ICL-<OC": {POS: VERB},
    "<mv>|V|PCP|F|P|@ICL-<PRED": {POS: VERB},
    "<mv>|V|PCP|F|P|@ICL-<SC": {POS: VERB},
    "<mv>|V|PCP|F|P|@ICL-ADVL>": {POS: VERB},
    "<mv>|V|PCP|F|P|@ICL-AUX<": {POS: VERB},
    "<mv>|V|PCP|F|P|@ICL-EXC": {POS: VERB},
    "<mv>|V|PCP|F|P|@ICL-N<": {POS: VERB},
    "<mv>|V|PCP|F|P|@ICL-N<PRED": {POS: VERB},
    "<mv>|V|PCP|F|P|@ICL-P<": {POS: VERB},
    "<mv>|V|PCP|F|P|@ICL-PRED>": {POS: VERB},
    "<mv>|V|PCP|F|P|@ICL-UTT": {POS: VERB},
    "<mv>|V|PCP|F|P|@N<": {POS: ADJ},
    "<mv>|V|PCP|F|S|@ICL-<ADVL": {POS: VERB},
    "<mv>|V|PCP|F|S|@ICL-<OC": {POS: VERB},
    "<mv>|V|PCP|F|S|@ICL-<PIV": {POS: VERB},
    "<mv>|V|PCP|F|S|@ICL-<PRED": {POS: VERB},
    "<mv>|V|PCP|F|S|@ICL-<SA": {POS: VERB},
    "<mv>|V|PCP|F|S|@ICL-<SC": {POS: VERB},
    "<mv>|V|PCP|F|S|@ICL-<sC": {POS: ADJ},
    "<mv>|V|PCP|F|S|@ICL-A<": {POS: VERB},
    "<mv>|V|PCP|F|S|@ICL-ADVL>": {POS: VERB},
    "<mv>|V|PCP|F|S|@ICL-APP": {POS: ADJ},
    "<mv>|V|PCP|F|S|@ICL-AUX<": {POS: VERB},
    "<mv>|V|PCP|F|S|@ICL-N<": {POS: VERB},
    "<mv>|V|PCP|F|S|@ICL-N<PRED": {POS: VERB},
    "<mv>|V|PCP|F|S|@ICL-P<": {POS: VERB},
    "<mv>|V|PCP|F|S|@ICL-PRED>": {POS: VERB},
    "<mv>|V|PCP|F|S|@ICL-SC>": {POS: VERB},
    "<mv>|V|PCP|F|S|@ICL-SUBJ>": {POS: ADJ},
    "<mv>|V|PCP|F|S|@ICL-UTT": {POS: VERB},
    "<mv>|V|PCP|M|P|@ICL-<ADVL": {POS: VERB},
    "<mv>|V|PCP|M|P|@ICL-<OC": {POS: VERB},
    "<mv>|V|PCP|M|P|@ICL-<PRED": {POS: VERB},
    "<mv>|V|PCP|M|P|@ICL-<SC": {POS: VERB},
    "<mv>|V|PCP|M|P|@ICL-A<": {POS: VERB},
    "<mv>|V|PCP|M|P|@ICL-ADVL>": {POS: VERB},
    "<mv>|V|PCP|M|P|@ICL-APP": {POS: VERB},
    "<mv>|V|PCP|M|P|@ICL-AUX<": {POS: VERB},
    "<mv>|V|PCP|M|P|@ICL-MV": {POS: VERB},
    "<mv>|V|PCP|M|P|@ICL-N<": {POS: VERB},
    "<mv>|V|PCP|M|P|@ICL-N<PRED": {POS: VERB},
    "<mv>|V|PCP|M|P|@ICL-P<": {POS: VERB},
    "<mv>|V|PCP|M|P|@ICL-PRED>": {POS: VERB},
    "<mv>|V|PCP|M|P|@ICL-UTT": {POS: VERB},
    "<mv>|V|PCP|M|S|@ICL-<ACC": {POS: VERB},
    "<mv>|V|PCP|M|S|@ICL-<ADVL": {POS: VERB},
    "<mv>|V|PCP|M|S|@ICL-<OC": {POS: VERB},
    "<mv>|V|PCP|M|S|@ICL-<PRED": {POS: VERB},
    "<mv>|V|PCP|M|S|@ICL-<SC": {POS: VERB},
    "<mv>|V|PCP|M|S|@ICL-<sC": {POS: VERB},
    "<mv>|V|PCP|M|S|@ICL->A": {POS: VERB},
    "<mv>|V|PCP|M|S|@ICL-A<": {POS: VERB},
    "<mv>|V|PCP|M|S|@ICL-ADVL>": {POS: VERB},
    "<mv>|V|PCP|M|S|@ICL-APP": {POS: VERB},
    "<mv>|V|PCP|M|S|@ICL-AUX<": {POS: VERB},
    "<mv>|V|PCP|M|S|@ICL-N<": {POS: VERB},
    "<mv>|V|PCP|M|S|@ICL-N<PRED": {POS: VERB},
    "<mv>|V|PCP|M|S|@ICL-P<": {POS: VERB},
    "<mv>|V|PCP|M|S|@ICL-PRED>": {POS: VERB},
    "<mv>|V|PCP|M|S|@ICL-STA": {POS: VERB},
    "<mv>|V|PCP|M|S|@ICL-SUBJ>": {POS: VERB},
    "<mv>|V|PCP|M|S|@ICL-UTT": {POS: VERB},
    "<mv>|V|PCP|M|S|@P<": {POS: VERB},
    "<mv>|V|PR|1/3S|SUBJ|@FS-CMD": {POS: VERB},
    "<mv>|V|PR|1/3S|SUBJ|@FS-STA": {POS: VERB},
    "<mv>|V|PR|1P|IND|@FS-<ACC": {POS: VERB},
    "<mv>|V|PR|1P|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|V|PR|1P|IND|@FS-<SC": {POS: VERB},
    "<mv>|V|PR|1P|IND|@FS-<SUBJ": {POS: VERB},
    "<mv>|V|PR|1P|IND|@FS-ACC>": {POS: VERB},
    "<mv>|V|PR|1P|IND|@FS-ADVL>": {POS: VERB},
    "<mv>|V|PR|1P|IND|@FS-N<": {POS: VERB},
    "<mv>|V|PR|1P|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|V|PR|1P|IND|@FS-QUE": {POS: VERB},
    "<mv>|V|PR|1P|IND|@FS-STA": {POS: VERB},
    "<mv>|V|PR|1P|IND|@FS-UTT": {POS: VERB},
    "<mv>|V|PR|1P|SUBJ|@FS-<ADVL": {POS: VERB},
    "<mv>|V|PR|1P|SUBJ|@FS-<SUBJ": {POS: VERB},
    "<mv>|V|PR|1P|SUBJ|@FS-CMD": {POS: VERB},
    "<mv>|V|PR|1P|SUBJ|@FS-N<PRED": {POS: VERB},
    "<mv>|V|PR|1P|SUBJ|@FS-P<": {POS: VERB},
    "<mv>|V|PR|1P|SUBJ|@FS-STA": {POS: VERB},
    "<mv>|V|PR|1S|IND|@FS-<ACC": {POS: VERB},
    "<mv>|V|PR|1S|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|V|PR|1S|IND|@FS-ACC>": {POS: VERB},
    "<mv>|V|PR|1S|IND|@FS-ADVL>": {POS: VERB},
    "<mv>|V|PR|1S|IND|@FS-EXC": {POS: VERB},
    "<mv>|V|PR|1S|IND|@FS-N<": {POS: VERB},
    "<mv>|V|PR|1S|IND|@FS-P<": {POS: VERB},
    "<mv>|V|PR|1S|IND|@FS-QUE": {POS: VERB},
    "<mv>|V|PR|1S|IND|@FS-STA": {POS: VERB},
    "<mv>|V|PR|1S|IND|@FS-SUBJ>": {POS: VERB},
    "<mv>|V|PR|1S|IND|@FS-UTT": {POS: VERB},
    "<mv>|V|PR|1S|SUBJ|@FS-<ACC": {POS: VERB},
    "<mv>|V|PR|1S|SUBJ|@FS-<ADVL": {POS: VERB},
    "<mv>|V|PR|1S|SUBJ|@FS-P<": {POS: VERB},
    "<mv>|V|PR|1S|SUBJ|@FS-STA": {POS: VERB},
    "<mv>|V|PR|2P|IND|@FS-P<": {POS: VERB},
    "<mv>|V|PR|2S|IND|@FS-<ACC": {POS: VERB},
    "<mv>|V|PR|2S|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|V|PR|2S|SUBJ|@FS-STA": {POS: VERB},
    "<mv>|V|PR|3P|IND|@FS-<ACC": {POS: VERB},
    "<mv>|V|PR|3P|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|V|PR|3P|IND|@FS-<SC": {POS: VERB},
    "<mv>|V|PR|3P|IND|@FS-<SUBJ": {POS: VERB},
    "<mv>|V|PR|3P|IND|@FS-ACC>": {POS: VERB},
    "<mv>|V|PR|3P|IND|@FS-ADVL>": {POS: VERB},
    "<mv>|V|PR|3P|IND|@FS-EXC": {POS: VERB},
    "<mv>|V|PR|3P|IND|@FS-N<": {POS: VERB},
    "<mv>|V|PR|3P|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|V|PR|3P|IND|@FS-P<": {POS: VERB},
    "<mv>|V|PR|3P|IND|@FS-QUE": {POS: VERB},
    "<mv>|V|PR|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|V|PR|3P|IND|@FS-SUBJ>": {POS: VERB},
    "<mv>|V|PR|3P|IND|@FS-UTT": {POS: VERB},
    "<mv>|V|PR|3P|SUBJ|@FS-<ACC": {POS: VERB},
    "<mv>|V|PR|3P|SUBJ|@FS-<ADVL": {POS: VERB},
    "<mv>|V|PR|3P|SUBJ|@FS-<SUBJ": {POS: VERB},
    "<mv>|V|PR|3P|SUBJ|@FS-A<": {POS: VERB},
    "<mv>|V|PR|3P|SUBJ|@FS-ADVL>": {POS: VERB},
    "<mv>|V|PR|3P|SUBJ|@FS-CMD": {POS: VERB},
    "<mv>|V|PR|3P|SUBJ|@FS-N<": {POS: VERB},
    "<mv>|V|PR|3P|SUBJ|@FS-N<PRED": {POS: VERB},
    "<mv>|V|PR|3P|SUBJ|@FS-P<": {POS: VERB},
    "<mv>|V|PR|3P|SUBJ|@FS-STA": {POS: VERB},
    "<mv>|V|PR|3S|@FS-<ADVL": {POS: VERB},
    "<mv>|V|PR|3S|@FS-STA": {POS: VERB},
    "<mv>|V|PR|3S|IND|@FS-<ACC": {POS: VERB},
    "<mv>|V|PR|3S|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|V|PR|3S|IND|@FS-<PIV": {POS: AUX},
    "<mv>|V|PR|3S|IND|@FS-<PRED": {POS: VERB},
    "<mv>|V|PR|3S|IND|@FS-<SC": {POS: VERB},
    "<mv>|V|PR|3S|IND|@FS-<SUBJ": {POS: VERB},
    "<mv>|V|PR|3S|IND|@FS->A": {POS: VERB},
    "<mv>|V|PR|3S|IND|@FS-A<": {POS: VERB},
    "<mv>|V|PR|3S|IND|@FS-ACC>": {POS: VERB},
    "<mv>|V|PR|3S|IND|@FS-ADVL>": {POS: VERB},
    "<mv>|V|PR|3S|IND|@FS-APP": {POS: VERB},
    "<mv>|V|PR|3S|IND|@FS-EXC": {POS: VERB},
    "<mv>|V|PR|3S|IND|@FS-KOMP<": {POS: VERB},
    "<mv>|V|PR|3S|IND|@FS-N<": {POS: VERB},
    "<mv>|V|PR|3S|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|V|PR|3S|IND|@FS-P<": {POS: VERB},
    "<mv>|V|PR|3S|IND|@FS-QUE": {POS: VERB},
    "<mv>|V|PR|3S|IND|@FS-S<": {POS: VERB},
    "<mv>|V|PR|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|V|PR|3S|IND|@FS-SUBJ>": {POS: VERB},
    "<mv>|V|PR|3S|IND|@FS-UTT": {POS: VERB},
    "<mv>|V|PR|3S|IND|@ICL-AUX<": {POS: VERB},
    "<mv>|V|PR|3S|IND|VFIN|@FS-<ADVL": {POS: VERB},
    "<mv>|V|PR|3S|IND|VFIN|@FS-ADVL>": {POS: VERB},
    "<mv>|V|PR|3S|SUBJ|@FS-<ACC": {POS: VERB},
    "<mv>|V|PR|3S|SUBJ|@FS-<ADVL": {POS: VERB},
    "<mv>|V|PR|3S|SUBJ|@FS-<SC": {POS: VERB},
    "<mv>|V|PR|3S|SUBJ|@FS-<SUBJ": {POS: VERB},
    "<mv>|V|PR|3S|SUBJ|@FS-ADVL>": {POS: VERB},
    "<mv>|V|PR|3S|SUBJ|@FS-CMD": {POS: VERB},
    "<mv>|V|PR|3S|SUBJ|@FS-COM": {POS: VERB},
    "<mv>|V|PR|3S|SUBJ|@FS-KOMP<": {POS: VERB},
    "<mv>|V|PR|3S|SUBJ|@FS-N<": {POS: VERB},
    "<mv>|V|PR|3S|SUBJ|@FS-N<PRED": {POS: VERB},
    "<mv>|V|PR|3S|SUBJ|@FS-P<": {POS: VERB},
    "<mv>|V|PR|3S|SUBJ|@FS-STA": {POS: VERB},
    "<mv>|V|PR|3S|SUBJ|@FS-SUBJ>": {POS: VERB},
    "<mv>|V|PS/MQP|3P|IND|@FS-<ACC": {POS: VERB},
    "<mv>|V|PS/MQP|3P|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|V|PS/MQP|3P|IND|@FS-ACC>": {POS: VERB},
    "<mv>|V|PS/MQP|3P|IND|@FS-ADVL>": {POS: VERB},
    "<mv>|V|PS/MQP|3P|IND|@FS-KOMP<": {POS: VERB},
    "<mv>|V|PS/MQP|3P|IND|@FS-N<": {POS: VERB},
    "<mv>|V|PS/MQP|3P|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|V|PS/MQP|3P|IND|@FS-P<": {POS: VERB},
    "<mv>|V|PS/MQP|3P|IND|@FS-QUE": {POS: VERB},
    "<mv>|V|PS/MQP|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|V|PS/MQP|3P|IND|@FS-UTT": {POS: VERB},
    "<mv>|V|PS|1P|IND|@FS-<ACC": {POS: VERB},
    "<mv>|V|PS|1P|IND|@FS-<SA": {POS: VERB},
    "<mv>|V|PS|1P|IND|@FS-ACC>": {POS: VERB},
    "<mv>|V|PS|1P|IND|@FS-N<": {POS: VERB},
    "<mv>|V|PS|1P|IND|@FS-P<": {POS: VERB},
    "<mv>|V|PS|1P|IND|@FS-STA": {POS: VERB},
    "<mv>|V|PS|1P|IND|@FS-SUBJ>": {POS: VERB},
    "<mv>|V|PS|1S|IND|@FS-<ACC": {POS: VERB},
    "<mv>|V|PS|1S|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|V|PS|1S|IND|@FS-ACC>": {POS: VERB},
    "<mv>|V|PS|1S|IND|@FS-ADVL>": {POS: VERB},
    "<mv>|V|PS|1S|IND|@FS-EXC": {POS: VERB},
    "<mv>|V|PS|1S|IND|@FS-N<": {POS: VERB},
    "<mv>|V|PS|1S|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|V|PS|1S|IND|@FS-P<": {POS: VERB},
    "<mv>|V|PS|1S|IND|@FS-STA": {POS: VERB},
    "<mv>|V|PS|2S|IND|@FS-<ACC": {POS: VERB},
    "<mv>|V|PS|2S|IND|@FS-QUE": {POS: VERB},
    "<mv>|V|PS|2S|IND|@FS-STA": {POS: VERB},
    "<mv>|V|PS|3P|IND|@FS-<ACC": {POS: VERB},
    "<mv>|V|PS|3P|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|V|PS|3P|IND|@FS-<SC": {POS: VERB},
    "<mv>|V|PS|3P|IND|@FS-ACC>": {POS: VERB},
    "<mv>|V|PS|3P|IND|@FS-ADVL>": {POS: VERB},
    "<mv>|V|PS|3P|IND|@FS-N<": {POS: VERB},
    "<mv>|V|PS|3P|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|V|PS|3P|IND|@FS-QUE": {POS: VERB},
    "<mv>|V|PS|3P|IND|@FS-STA": {POS: VERB},
    "<mv>|V|PS|3S|IND|@FS-<ACC": {POS: VERB},
    "<mv>|V|PS|3S|IND|@FS-<ADVL": {POS: VERB},
    "<mv>|V|PS|3S|IND|@FS-<SC": {POS: VERB},
    "<mv>|V|PS|3S|IND|@FS-<SUBJ": {POS: VERB},
    "<mv>|V|PS|3S|IND|@FS-A<": {POS: VERB},
    "<mv>|V|PS|3S|IND|@FS-ACC>": {POS: VERB},
    "<mv>|V|PS|3S|IND|@FS-ADVL>": {POS: VERB},
    "<mv>|V|PS|3S|IND|@FS-APP": {POS: VERB},
    "<mv>|V|PS|3S|IND|@FS-EXC": {POS: VERB},
    "<mv>|V|PS|3S|IND|@FS-KOMP<": {POS: VERB},
    "<mv>|V|PS|3S|IND|@FS-N<": {POS: VERB},
    "<mv>|V|PS|3S|IND|@FS-N<PRED": {POS: VERB},
    "<mv>|V|PS|3S|IND|@FS-P<": {POS: VERB},
    "<mv>|V|PS|3S|IND|@FS-QUE": {POS: VERB},
    "<mv>|V|PS|3S|IND|@FS-S<": {POS: VERB},
    "<mv>|V|PS|3S|IND|@FS-STA": {POS: VERB},
    "<mv>|V|PS|3S|IND|@FS-SUBJ>": {POS: VERB},
    "<mv>|V|PS|3S|IND|@FS-UTT": {POS: VERB},
    "<mv>|V|PS|P|3P|IND|@FS-STA": {POS: VERB},
    "<n>|<COMP>|ADJ|F|S|@<SC": {POS: ADJ},
    "<n>|<COMP>|ADJ|F|S|@APP": {POS: ADJ},
    "<n>|<COMP>|ADJ|F|S|@P<": {POS: ADJ},
    "<n>|<COMP>|ADJ|M/F|P|@<SC": {POS: ADJ},
    "<n>|<COMP>|ADJ|M|P|@<ACC": {POS: ADJ},
    "<n>|<COMP>|ADJ|M|P|@P<": {POS: ADJ},
    "<n>|<COMP>|ADJ|M|S|@<SC": {POS: ADJ},
    "<n>|<COMP>|ADJ|M|S|@APP": {POS: ADJ},
    "<n>|<COMP>|ADJ|M|S|@P<": {POS: ADJ},
    "<n>|<COMP>|ADJ|M|S|@SC>": {POS: ADJ},
    "<n>|<COMP>|ADJ|M|S|@SUBJ>": {POS: ADJ},
    "<n>|<Eg>|<KOMP>|<np-def>|ADJ|@P<": {POS: ADJ},
    "<n>|<Eg>|<NUM-ord>|<np-def>|ADJ|@P<": {POS: ADJ},
    "<n>|<Eg>|<NUM-ord>|<np-def>|ADJ|F|P|@P<": {POS: ADJ},
    "<n>|<Eg>|<NUM-ord>|<np-def>|ADJ|F|S|@<SC": {POS: ADJ},
    "<n>|<Eg>|<NUM-ord>|<np-def>|ADJ|F|S|@N<PRED": {POS: ADJ},
    "<n>|<Eg>|<NUM-ord>|<np-def>|ADJ|F|S|@SUBJ>": {POS: ADJ},
    "<n>|<Eg>|<NUM-ord>|<np-def>|ADJ|M|P|@<SC": {POS: ADJ},
    "<n>|<Eg>|<NUM-ord>|<np-def>|ADJ|M|P|@SUBJ>": {POS: ADJ},
    "<n>|<Eg>|<NUM-ord>|<np-def>|ADJ|M|S|@<ACC": {POS: ADJ},
    "<n>|<Eg>|<NUM-ord>|<np-def>|ADJ|M|S|@P<": {POS: ADJ},
    "<n>|<Eg>|<np-def>|ADJ|F|P|@SUBJ>": {POS: ADJ},
    "<n>|<Eg>|<np-def>|ADJ|F|S|@P<": {POS: ADJ},
    "<n>|<Eg>|<np-def>|ADJ|M|P|@P<": {POS: ADJ},
    "<n>|<Eg>|<np-def>|ADJ|M|P|@SUBJ>": {POS: ADJ},
    "<n>|<Eg>|<np-def>|ADJ|M|S|@P<": {POS: ADJ},
    "<n>|<KOMP>|<COMP>|ADJ|M|P|@P<": {POS: ADJ},
    "<n>|<KOMP>|<diff>|DET|M|P|@>N": {POS: DET},
    "<n>|<KOMP>|<np-def>|<COMP>|ADJ|F|P|@P<": {POS: ADJ},
    "<n>|<KOMP>|<np-def>|<COMP>|ADJ|F|S|@SUBJ>": {POS: ADJ},
    "<n>|<KOMP>|<np-def>|<COMP>|ADJ|M|S|@<ACC": {POS: ADJ},
    "<n>|<KOMP>|<np-def>|<COMP>|ADJ|M|S|@<SC": {POS: ADJ},
    "<n>|<NUM-ord>|<np-def>|ADJ|F|S|@<SC": {POS: ADJ},
    "<n>|<NUM-ord>|<np-def>|ADJ|F|S|@APP": {POS: ADJ},
    "<n>|<NUM-ord>|<np-def>|ADJ|F|S|@N<PRED": {POS: ADJ},
    "<n>|<NUM-ord>|<np-def>|ADJ|F|S|@P<": {POS: ADJ},
    "<n>|<NUM-ord>|<np-def>|ADJ|F|S|@SUBJ>": {POS: ADJ},
    "<n>|<NUM-ord>|<np-def>|ADJ|M|P|@<SUBJ": {POS: ADJ},
    "<n>|<NUM-ord>|<np-def>|ADJ|M|P|@P<": {POS: ADJ},
    "<n>|<NUM-ord>|<np-def>|ADJ|M|P|@SUBJ>": {POS: ADJ},
    "<n>|<NUM-ord>|<np-def>|ADJ|M|S|@<SC": {POS: ADJ},
    "<n>|<NUM-ord>|<np-def>|ADJ|M|S|@NPHR": {POS: ADJ},
    "<n>|<NUM-ord>|<np-def>|ADJ|M|S|@P<": {POS: ADJ},
    "<n>|<NUM-ord>|<np-def>|ADJ|M|S|@SUBJ>": {POS: ADJ},
    "<n>|<NUM-ord>|<np-idf>|ADJ|M|S|@<ACC": {POS: ADJ},
    "<n>|<NUM-ord>|<np-idf>|ADJ|M|S|@SUBJ>": {POS: ADJ},
    "<n>|<NUM-ord>|ADJ|M|S|@<SC": {POS: ADJ},
    "<n>|<NUM-ord>|ADJ|M|S|@N<": {POS: ADJ},
    "<n>|<NUM-ord>|ADJ|M|S|@N<PRED": {POS: ADJ},
    "<n>|<NUM-ord>|ADJ|M|S|@NPHR": {POS: ADJ},
    "<n>|<NUM-ord>|ADJ|M|S|@P<": {POS: ADJ},
    "<n>|<SUP>|<KOMP>|<np-def>|ADJ|F|P|@<SC": {POS: ADJ},
    "<n>|<SUP>|<KOMP>|<np-def>|ADJ|F|S|@P<": {POS: ADJ},
    "<n>|<SUP>|<KOMP>|<np-def>|ADJ|M|P|@<SC": {POS: ADJ},
    "<n>|<SUP>|<KOMP>|<np-def>|ADJ|M|P|@P<": {POS: ADJ},
    "<n>|<SUP>|<KOMP>|<np-def>|ADJ|M|S|@SC>": {POS: ADJ},
    "<n>|<SUP>|<KOMP>|<np-def>|ADJ|M|S|@SUBJ>": {POS: ADJ},
    "<n>|<SUP>|<np-def>|ADJ|F|S|@N<PRED": {POS: ADJ},
    "<n>|<SUP>|<np-def>|ADJ|M|S|@N<PRED": {POS: ADJ},
    "<n>|<SUP>|<np-def>|ADJ|M|S|@P<": {POS: ADJ},
    "<n>|<SUP>|<np-def>|ADJ|M|S|@SUBJ>": {POS: ADJ},
    "<n>|<card>|<np-def>|NUM|M|S|@SUBJ>": {POS: NUM},
    "<n>|<card>|NUM|M|S|@<ACC": {POS: NUM},
    "<n>|<cjt>|ADJ|M|S|@PRED>": {POS: ADJ},
    "<n>|<cjt>|V|PCP|M|P|@N<PRED": {POS: ADJ},
    "<n>|<cjt>|V|PCP|M|P|@P<": {POS: VERB},
    "<n>|<first-cjt>|ADJ|M|S|@>N": {POS: ADJ},
    "<n>|<np-def>|ADJ|@<SUBJ": {POS: ADJ},
    "<n>|<np-def>|ADJ|F|P|@<SC": {POS: ADJ},
    "<n>|<np-def>|ADJ|F|P|@<SUBJ": {POS: ADJ},
    "<n>|<np-def>|ADJ|F|P|@P<": {POS: ADJ},
    "<n>|<np-def>|ADJ|F|P|@SUBJ>": {POS: ADJ},
    "<n>|<np-def>|ADJ|F|S|@<ACC": {POS: ADJ},
    "<n>|<np-def>|ADJ|F|S|@<SC": {POS: ADJ},
    "<n>|<np-def>|ADJ|F|S|@NPHR": {POS: ADJ},
    "<n>|<np-def>|ADJ|F|S|@P<": {POS: ADJ},
    "<n>|<np-def>|ADJ|F|S|@SUBJ>": {POS: ADJ},
    "<n>|<np-def>|ADJ|M|P|@<ACC": {POS: ADJ},
    "<n>|<np-def>|ADJ|M|P|@<SC": {POS: ADJ},
    "<n>|<np-def>|ADJ|M|P|@<SUBJ": {POS: ADJ},
    "<n>|<np-def>|ADJ|M|P|@N<PRED": {POS: ADJ},
    "<n>|<np-def>|ADJ|M|P|@NPHR": {POS: ADJ},
    "<n>|<np-def>|ADJ|M|P|@P<": {POS: ADJ},
    "<n>|<np-def>|ADJ|M|P|@SUBJ>": {POS: ADJ},
    "<n>|<np-def>|ADJ|M|S|@<ACC": {POS: ADJ},
    "<n>|<np-def>|ADJ|M|S|@<OC": {POS: ADJ},
    "<n>|<np-def>|ADJ|M|S|@<SC": {POS: ADJ},
    "<n>|<np-def>|ADJ|M|S|@<SUBJ": {POS: ADJ},
    "<n>|<np-def>|ADJ|M|S|@APP": {POS: ADJ},
    "<n>|<np-def>|ADJ|M|S|@P<": {POS: ADJ},
    "<n>|<np-def>|ADJ|M|S|@SC>": {POS: ADJ},
    "<n>|<np-def>|ADJ|M|S|@SUBJ>": {POS: ADJ},
    "<n>|<np-def>|N|M|P|@<ACC": {POS: NOUN},
    "<n>|<np-def>|N|M|P|@P<": {POS: NOUN},
    "<n>|<np-def>|N|M|P|@SUBJ>": {POS: NOUN},
    "<n>|<np-def>|N|M|S|@<SUBJ": {POS: NOUN},
    "<n>|<np-idf>|ADJ|F|S|@<SUBJ": {POS: ADJ},
    "<n>|<np-idf>|ADJ|F|S|@P<": {POS: ADJ},
    "<n>|<np-idf>|ADJ|M/F|S|@P<": {POS: ADJ},
    "<n>|<np-idf>|ADJ|M|P|@<ACC": {POS: ADJ},
    "<n>|<np-idf>|ADJ|M|P|@<SC": {POS: ADJ},
    "<n>|<np-idf>|ADJ|M|P|@<SUBJ": {POS: ADJ},
    "<n>|<np-idf>|ADJ|M|P|@P<": {POS: ADJ},
    "<n>|<np-idf>|ADJ|M|S|@<ACC": {POS: ADJ},
    "<n>|<np-idf>|ADJ|M|S|@<SC": {POS: ADJ},
    "<n>|<np-idf>|ADJ|M|S|@<SUBJ": {POS: ADJ},
    "<n>|<np-idf>|ADJ|M|S|@>N": {POS: ADJ},
    "<n>|<np-idf>|ADJ|M|S|@N<PRED": {POS: ADJ},
    "<n>|<np-idf>|ADJ|M|S|@P<": {POS: ADJ},
    "<n>|<np-idf>|ADJ|M|S|@SUBJ>": {POS: ADJ},
    "<n>|<np-idf>|N|M|P|@P<": {POS: NOUN},
    "<n>|<np-idf>|N|M|S|@P<": {POS: NOUN},
    "<n>|ADJ|@<OC": {POS: ADJ},
    "<n>|ADJ|F|P|@<OC": {POS: ADJ},
    "<n>|ADJ|F|P|@<SC": {POS: ADJ},
    "<n>|ADJ|F|P|@>N": {POS: ADJ},
    "<n>|ADJ|F|P|@P<": {POS: ADJ},
    "<n>|ADJ|F|P|@SUBJ>": {POS: ADJ},
    "<n>|ADJ|F|S|@<ACC": {POS: ADJ},
    "<n>|ADJ|F|S|@<SC": {POS: ADJ},
    "<n>|ADJ|F|S|@>N": {POS: ADJ},
    "<n>|ADJ|F|S|@N<": {POS: ADJ},
    "<n>|ADJ|F|S|@N<PRED": {POS: ADJ},
    "<n>|ADJ|F|S|@P<": {POS: ADJ},
    "<n>|ADJ|M/F|P|@<ACC": {POS: ADJ},
    "<n>|ADJ|M/F|P|@NPHR": {POS: ADJ},
    "<n>|ADJ|M/F|P|@P<": {POS: ADJ},
    "<n>|ADJ|M/F|P|@SUBJ>": {POS: ADJ},
    "<n>|ADJ|M/F|S|@P<": {POS: ADJ},
    "<n>|ADJ|M|P|@<ACC": {POS: ADJ},
    "<n>|ADJ|M|P|@<OC": {POS: ADJ},
    "<n>|ADJ|M|P|@<SC": {POS: ADJ},
    "<n>|ADJ|M|P|@>N": {POS: ADJ},
    "<n>|ADJ|M|P|@N<PRED": {POS: ADJ},
    "<n>|ADJ|M|P|@P<": {POS: ADJ},
    "<n>|ADJ|M|P|@SUBJ>": {POS: ADJ},
    "<n>|ADJ|M|S|@<ADVL": {POS: ADJ},
    "<n>|ADJ|M|S|@<OC": {POS: ADJ},
    "<n>|ADJ|M|S|@<SC": {POS: ADJ},
    "<n>|ADJ|M|S|@>N": {POS: ADJ},
    "<n>|ADJ|M|S|@APP": {POS: ADJ},
    "<n>|ADJ|M|S|@N<": {POS: ADJ},
    "<n>|ADJ|M|S|@N<PRED": {POS: ADJ},
    "<n>|ADJ|M|S|@P<": {POS: ADJ},
    "<n>|ADJ|M|S|@SUBJ>": {POS: ADJ},
    "<n>|V|PCP|M|S|@P<": {POS: VERB},
    "<nadj>|<np-idf>|N|M|S|@P<": {POS: NOUN},
    "<nil>|<artd>|ART|M|S|@>N": {POS: DET},
    "<nil>|<dem>|<-sam>|DET|M|S|@>N": {POS: DET},
    "<nil>|<sam->|PRP|@<ADVL": {POS: ADP},
    "<nil>|ADV|@<ADVL": {POS: ADV},
    "<nil>|ADV|@>N": {POS: ADV},
    "<nil>|PERS|F|3S|ACC|@ACC>": {POS: PRON},
    "<nil>|PRP|@ADVL>": {POS: ADP},
    "<nil>|PRP|@N<": {POS: ADP},
    "<nil>|PRP|@P<": {POS: ADP},
    "<nil>|X|@X": {POS: X},
    "<np-def>|ADJ|F|S|@P<": {POS: ADJ},
    "<np-def>|ADJ|M|S|@N<": {POS: ADJ},
    "<np-def>|ADJ|M|S|@N<PRED": {POS: ADJ},
    "<np-def>|DET|F|P|@P<": {POS: PRON},
    "<np-def>|DET|M|P|@SUBJ>": {POS: PRON},
    "<np-def>|DET|M|S|@P<": {POS: PRON},
    "<np-def>|DET|M|S|@SUBJ>": {POS: PRON},
    "<np-def>|N|@P<": {POS: NOUN},
    "<np-def>|N|F|P|@<ACC": {POS: NOUN},
    "<np-def>|N|F|P|@<ADVL": {POS: NOUN},
    "<np-def>|N|F|P|@<SA": {POS: NOUN},
    "<np-def>|N|F|P|@<SC": {POS: NOUN},
    "<np-def>|N|F|P|@<SUBJ": {POS: NOUN},
    "<np-def>|N|F|P|@>A": {POS: NOUN},
    "<np-def>|N|F|P|@ADVL>": {POS: NOUN},
    "<np-def>|N|F|P|@APP": {POS: NOUN},
    "<np-def>|N|F|P|@KOMP<": {POS: NOUN},
    "<np-def>|N|F|P|@N<": {POS: NOUN},
    "<np-def>|N|F|P|@N<PRED": {POS: NOUN},
    "<np-def>|N|F|P|@NPHR": {POS: NOUN},
    "<np-def>|N|F|P|@P<": {POS: NOUN},
    "<np-def>|N|F|P|@SUBJ>": {POS: NOUN},
    "<np-def>|N|F|P|@TOP": {POS: NOUN},
    "<np-def>|N|F|S|@<ACC": {POS: NOUN},
    "<np-def>|N|F|S|@<ADVL": {POS: NOUN},
    "<np-def>|N|F|S|@<OC": {POS: NOUN},
    "<np-def>|N|F|S|@<PIV": {POS: NOUN},
    "<np-def>|N|F|S|@<SA": {POS: NOUN},
    "<np-def>|N|F|S|@<SC": {POS: NOUN},
    "<np-def>|N|F|S|@<SUBJ": {POS: NOUN},
    "<np-def>|N|F|S|@<sUBJ": {POS: NOUN},
    "<np-def>|N|F|S|@>A": {POS: NOUN},
    "<np-def>|N|F|S|@ACC>": {POS: NOUN},
    "<np-def>|N|F|S|@ADVL>": {POS: NOUN},
    "<np-def>|N|F|S|@APP": {POS: NOUN},
    "<np-def>|N|F|S|@AUX<": {POS: NOUN},
    "<np-def>|N|F|S|@FS-N<": {POS: NOUN},
    "<np-def>|N|F|S|@FS-N<PRED": {POS: NOUN},
    "<np-def>|N|F|S|@ICL-<ACC": {POS: NOUN},
    "<np-def>|N|F|S|@N<": {POS: NOUN},
    "<np-def>|N|F|S|@N<PRED": {POS: NOUN},
    "<np-def>|N|F|S|@NPHR": {POS: NOUN},
    "<np-def>|N|F|S|@P<": {POS: NOUN},
    "<np-def>|N|F|S|@SC>": {POS: NOUN},
    "<np-def>|N|F|S|@SUBJ>": {POS: NOUN},
    "<np-def>|N|M/F|P|@P<": {POS: NOUN},
    "<np-def>|N|M/F|P|@SUBJ>": {POS: NOUN},
    "<np-def>|N|M/F|S|@P<": {POS: NOUN},
    "<np-def>|N|M/F|S|@SUBJ>": {POS: NOUN},
    "<np-def>|N|M|P|@<ACC": {POS: SYM},
    "<np-def>|N|M|P|@<ADVL": {POS: SYM},
    "<np-def>|N|M|P|@<SA": {POS: NOUN},
    "<np-def>|N|M|P|@<SC": {POS: SYM},
    "<np-def>|N|M|P|@<SUBJ": {POS: SYM},
    "<np-def>|N|M|P|@>A": {POS: SYM},
    "<np-def>|N|M|P|@A<": {POS: NOUN},
    "<np-def>|N|M|P|@ACC>": {POS: NOUN},
    "<np-def>|N|M|P|@ADVL>": {POS: NOUN},
    "<np-def>|N|M|P|@APP": {POS: NOUN},
    "<np-def>|N|M|P|@ICL-P<": {POS: NOUN},
    "<np-def>|N|M|P|@N<": {POS: SYM},
    "<np-def>|N|M|P|@N<PRED": {POS: SYM},
    "<np-def>|N|M|P|@NPHR": {POS: SYM},
    "<np-def>|N|M|P|@P<": {POS: SYM},
    "<np-def>|N|M|P|@SC>": {POS: NOUN},
    "<np-def>|N|M|P|@SUBJ>": {POS: SYM},
    "<np-def>|N|M|P|@TOP": {POS: NOUN},
    "<np-def>|N|M|S/P|@P<": {POS: NOUN},
    "<np-def>|N|M|S|@<ACC": {POS: NOUN},
    "<np-def>|N|M|S|@<ADVL": {POS: NOUN},
    "<np-def>|N|M|S|@<OC": {POS: NOUN},
    "<np-def>|N|M|S|@<SC": {POS: NOUN},
    "<np-def>|N|M|S|@<SUBJ": {POS: NOUN},
    "<np-def>|N|M|S|@>A": {POS: NOUN},
    "<np-def>|N|M|S|@A<": {POS: NOUN},
    "<np-def>|N|M|S|@ACC>": {POS: NOUN},
    "<np-def>|N|M|S|@ADVL>": {POS: NOUN},
    "<np-def>|N|M|S|@APP": {POS: NOUN},
    "<np-def>|N|M|S|@AS<": {POS: NOUN},
    "<np-def>|N|M|S|@AUX<": {POS: NOUN},
    "<np-def>|N|M|S|@N<": {POS: NOUN},
    "<np-def>|N|M|S|@N<PRED": {POS: NOUN},
    "<np-def>|N|M|S|@NPHR": {POS: NOUN},
    "<np-def>|N|M|S|@P<": {POS: NOUN},
    "<np-def>|N|M|S|@SC>": {POS: NOUN},
    "<np-def>|N|M|S|@SUBJ>": {POS: NOUN},
    "<np-def>|PROP|<UPOS:NOUN>|<UF:Gender=Masc>|N|M|S|@SUBJ>": {POS: PROPN},
    "<np-def>|PROP|M|S|@P<": {POS: PROPN},
    "<np-idf>|<cjt>|N|F|P|@APP": {POS: NOUN},
    "<np-idf>|<cjt>|N|F|P|@N<PRED": {POS: NOUN},
    "<np-idf>|<cjt>|N|F|S|@<ACC": {POS: NOUN},
    "<np-idf>|<cjt>|N|M|P|@N<PRED": {POS: NOUN},
    "<np-idf>|<cjt>|N|M|P|@P<": {POS: NOUN},
    "<np-idf>|ADJ|F|S|@N<": {POS: ADJ},
    "<np-idf>|ADJ|F|S|@N<PRED": {POS: ADJ},
    "<np-idf>|ADJ|M|P|@N<": {POS: ADJ},
    "<np-idf>|ADJ|M|P|@N<PRED": {POS: ADJ},
    "<np-idf>|ADJ|M|S|@N<": {POS: ADJ},
    "<np-idf>|ADJ|M|S|@N<PRED": {POS: ADJ},
    "<np-idf>|N|@N<PRED": {POS: NOUN},
    "<np-idf>|N|@NPHR": {POS: NOUN},
    "<np-idf>|N|@P<": {POS: NOUN},
    "<np-idf>|N|F|P|@<ACC": {POS: NOUN},
    "<np-idf>|N|F|P|@<ADVL": {POS: NOUN},
    "<np-idf>|N|F|P|@<OC": {POS: NOUN},
    "<np-idf>|N|F|P|@<SC": {POS: NOUN},
    "<np-idf>|N|F|P|@<SUBJ": {POS: NOUN},
    "<np-idf>|N|F|P|@>N": {POS: NOUN},
    "<np-idf>|N|F|P|@ACC>": {POS: NOUN},
    "<np-idf>|N|F|P|@ADVL>": {POS: NOUN},
    "<np-idf>|N|F|P|@APP": {POS: NOUN},
    "<np-idf>|N|F|P|@N<": {POS: NOUN},
    "<np-idf>|N|F|P|@N<PRED": {POS: NOUN},
    "<np-idf>|N|F|P|@NPHR": {POS: NOUN},
    "<np-idf>|N|F|P|@P<": {POS: NOUN},
    "<np-idf>|N|F|P|@S<": {POS: NOUN},
    "<np-idf>|N|F|P|@SUBJ>": {POS: NOUN},
    "<np-idf>|N|F|P|@VOK": {POS: NOUN},
    "<np-idf>|N|F|S|@<ACC": {POS: NOUN},
    "<np-idf>|N|F|S|@<ADVL": {POS: NOUN},
    "<np-idf>|N|F|S|@<OC": {POS: NOUN},
    "<np-idf>|N|F|S|@<PRED": {POS: NOUN},
    "<np-idf>|N|F|S|@<SA": {POS: NOUN},
    "<np-idf>|N|F|S|@<SC": {POS: NOUN},
    "<np-idf>|N|F|S|@<SUBJ": {POS: NOUN},
    "<np-idf>|N|F|S|@<sC": {POS: NOUN},
    "<np-idf>|N|F|S|@<sUBJ": {POS: NOUN},
    "<np-idf>|N|F|S|@>N": {POS: NOUN},
    "<np-idf>|N|F|S|@A<": {POS: NOUN},
    "<np-idf>|N|F|S|@ACC>": {POS: NOUN},
    "<np-idf>|N|F|S|@ADVL>": {POS: NOUN},
    "<np-idf>|N|F|S|@APP": {POS: NOUN},
    "<np-idf>|N|F|S|@N<": {POS: NOUN},
    "<np-idf>|N|F|S|@N<PRED": {POS: NOUN},
    "<np-idf>|N|F|S|@NPHR": {POS: NOUN},
    "<np-idf>|N|F|S|@P<": {POS: NOUN},
    "<np-idf>|N|F|S|@PRED>": {POS: NOUN},
    "<np-idf>|N|F|S|@S<": {POS: NOUN},
    "<np-idf>|N|F|S|@SC>": {POS: NOUN},
    "<np-idf>|N|F|S|@SUBJ>": {POS: NOUN},
    "<np-idf>|N|F|S|@UTT": {POS: NOUN},
    "<np-idf>|N|F|S|@VOK": {POS: NOUN},
    "<np-idf>|N|M/F|P|@<ACC": {POS: NOUN},
    "<np-idf>|N|M/F|P|@<SUBJ": {POS: NOUN},
    "<np-idf>|N|M/F|P|@NPHR": {POS: NOUN},
    "<np-idf>|N|M/F|P|@P<": {POS: NOUN},
    "<np-idf>|N|M/F|P|@SUBJ>": {POS: NOUN},
    "<np-idf>|N|M/F|S|@NPHR": {POS: NOUN},
    "<np-idf>|N|M/F|S|@P<": {POS: NOUN},
    "<np-idf>|N|M|P|@<ACC": {POS: NOUN},
    "<np-idf>|N|M|P|@<ADVL": {POS: NOUN},
    "<np-idf>|N|M|P|@<OC": {POS: NOUN},
    "<np-idf>|N|M|P|@<PIV": {POS: NOUN},
    "<np-idf>|N|M|P|@<SA": {POS: NOUN},
    "<np-idf>|N|M|P|@<SC": {POS: NOUN},
    "<np-idf>|N|M|P|@<SUBJ": {POS: NOUN},
    "<np-idf>|N|M|P|@>A": {POS: NOUN},
    "<np-idf>|N|M|P|@>N": {POS: NOUN},
    "<np-idf>|N|M|P|@A<": {POS: NOUN},
    "<np-idf>|N|M|P|@ACC>": {POS: NOUN},
    "<np-idf>|N|M|P|@ADVL>": {POS: NOUN},
    "<np-idf>|N|M|P|@APP": {POS: NOUN},
    "<np-idf>|N|M|P|@AUX<": {POS: NOUN},
    "<np-idf>|N|M|P|@ICL-<ACC": {POS: NOUN},
    "<np-idf>|N|M|P|@ICL-P<": {POS: NOUN},
    "<np-idf>|N|M|P|@N<": {POS: NOUN},
    "<np-idf>|N|M|P|@N<PRED": {POS: NOUN},
    "<np-idf>|N|M|P|@NPHR": {POS: NOUN},
    "<np-idf>|N|M|P|@P<": {POS: NOUN},
    "<np-idf>|N|M|P|@PRED>": {POS: NOUN},
    "<np-idf>|N|M|P|@SUBJ>": {POS: PROPN},
    "<np-idf>|N|M|P|@TOP": {POS: NOUN},
    "<np-idf>|N|M|R|@<ACC": {POS: NOUN},
    "<np-idf>|N|M|S|@<ACC": {POS: NOUN},
    "<np-idf>|N|M|S|@<ADVL": {POS: NOUN},
    "<np-idf>|N|M|S|@<OC": {POS: NOUN},
    "<np-idf>|N|M|S|@<PRED": {POS: NOUN},
    "<np-idf>|N|M|S|@<SA": {POS: NOUN},
    "<np-idf>|N|M|S|@<SC": {POS: NOUN},
    "<np-idf>|N|M|S|@<SUBJ": {POS: NOUN},
    "<np-idf>|N|M|S|@<sC": {POS: NOUN},
    "<np-idf>|N|M|S|@<sUBJ": {POS: NOUN},
    "<np-idf>|N|M|S|@>A": {POS: NOUN},
    "<np-idf>|N|M|S|@>N": {POS: NOUN},
    "<np-idf>|N|M|S|@A<": {POS: NOUN},
    "<np-idf>|N|M|S|@ACC>": {POS: NOUN},
    "<np-idf>|N|M|S|@ADVL": {POS: NOUN},
    "<np-idf>|N|M|S|@ADVL>": {POS: NOUN},
    "<np-idf>|N|M|S|@APP": {POS: NOUN},
    "<np-idf>|N|M|S|@CO": {POS: NOUN},
    "<np-idf>|N|M|S|@ICL-<SC": {POS: NOUN},
    "<np-idf>|N|M|S|@ICL-P<": {POS: NOUN},
    "<np-idf>|N|M|S|@KOMP<": {POS: NOUN},
    "<np-idf>|N|M|S|@N<": {POS: NOUN},
    "<np-idf>|N|M|S|@N<PRED": {POS: NOUN},
    "<np-idf>|N|M|S|@NPHR": {POS: NOUN},
    "<np-idf>|N|M|S|@P<": {POS: NOUN},
    "<np-idf>|N|M|S|@PRED>": {POS: NOUN},
    "<np-idf>|N|M|S|@S<": {POS: NOUN},
    "<np-idf>|N|M|S|@SC>": {POS: NOUN},
    "<np-idf>|N|M|S|@SUBJ>": {POS: NOUN},
    "<np-idf>|N|M|S|@VOC": {POS: NOUN},
    "<np-idf>|N|M|S|@VOK": {POS: NOUN},
    "<np-idf>|N|M|s|@P<": {POS: NOUN},
    "<np-idf>|PROP|<UPOS:NOUN>|<UF:Gender=Fem>|N|F|S|@APP": {POS: PROPN},
    "<np-idf>|PROP|M|S|@P<": {POS: PROPN},
    "<obj>|PERS|F|3P|ACC|@<ACC": {POS: PRON},
    "<obj>|PERS|F|3P|ACC|@ACC>": {POS: PRON},
    "<obj>|PERS|F|3S|ACC|@<ACC": {POS: PRON},
    "<obj>|PERS|F|3S|ACC|@ACC>": {POS: PRON},
    "<obj>|PERS|M/F|3S|ACC|@<ACC": {POS: PRON},
    "<obj>|PERS|M|3P|ACC|@<ACC": {POS: PRON},
    "<obj>|PERS|M|3P|ACC|@ACC>": {POS: PRON},
    "<obj>|PERS|M|3S|ACC|@<ACC": {POS: PRON},
    "<obj>|PERS|M|3S|ACC|@ACC>": {POS: PRON},
    "<parkc-1>|ADV|@CO": {POS: ADV},
    "<parkc-1>|KC|@CO": {POS: CCONJ},
    "<parkc-2>|<co-subj>|KC|@CO": {POS: CCONJ},
    "<parkc-2>|KC|@CO": {POS: CCONJ},
    "<pass>|<cjt>|<mv>|V|PCP|F|P|@ICL-AUX<": {POS: VERB},
    "<pass>|<cjt>|<mv>|V|PCP|F|S|@ICL-AUX<": {POS: VERB},
    "<pass>|<cjt>|<mv>|V|PCP|M|S|@ICL-AUX<": {POS: VERB},
    "<pass>|<mv>|V|PCP|F|P|@ICL-AUX<": {POS: VERB},
    "<pass>|<mv>|V|PCP|F|S|@ICL-AUX<": {POS: VERB},
    "<pass>|<mv>|V|PCP|MVF|S|@ICL-AUX<": {POS: VERB},
    "<pass>|<mv>|V|PCP|M|P|@ICL-AUX<": {POS: VERB},
    "<pass>|<mv>|V|PCP|M|S|@ICL-AUX<": {POS: VERB},
    "<poss>|<np-def>|DET|M|P|@P<": {POS: PRON},
    "<poss>|<np-def>|DET|M|P|@SUBJ>": {POS: PRON},
    "<poss>|<np-def>|DET|M|S|@N<": {POS: DET},
    "<poss>|<np-idf>|DET|F|S|@N<": {POS: DET},
    "<poss>|<si>|<np-def>|DET|M|P|@>A": {POS: DET},
    "<poss>|<si>|DET|F|P|@>N": {POS: DET},
    "<poss>|<si>|DET|F|S|@>N": {POS: DET},
    "<poss>|<si>|DET|M|P|@>N": {POS: DET},
    "<poss>|<si>|DET|M|S|@>N": {POS: DET},
    "<poss>|DET|F|P|@>N": {POS: DET},
    "<poss>|DET|F|P|@N<": {POS: DET},
    "<poss>|DET|F|S|@<SC": {POS: PRON},
    "<poss>|DET|F|S|@>N": {POS: DET},
    "<poss>|DET|F|S|@N<": {POS: DET},
    "<poss>|DET|M|P|@>N": {POS: DET},
    "<poss>|DET|M|P|@N<": {POS: DET},
    "<poss>|DET|M|S|@<SC": {POS: PRON},
    "<poss>|DET|M|S|@>N": {POS: DET},
    "<poss>|DET|M|S|@N<": {POS: DET},
    "<prd>|ADV|@<ADVL": {POS: ADV},
    "<prd>|ADV|@<OC": {POS: ADV},
    "<prd>|ADV|@<SC": {POS: ADV},
    "<prd>|PRP|@<ADVL": {POS: ADP},
    "<prd>|PRP|@<OC": {POS: ADP},
    "<prd>|PRP|@<SC": {POS: ADP},
    "<prd>|PRP|@ADVL>": {POS: ADP},
    "<prd>|PRP|@COM": {POS: ADP},
    "<prd>|PRP|@N<": {POS: ADP},
    "<prd>|PRP|@N<ARG": {POS: ADP},
    "<prd>|PRP|@N<PRED": {POS: ADP},
    "<prd>|PRP|@OC": {POS: ADP},
    "<prd>|PRP|@OC>": {POS: ADP},
    "<prd>|PRP|@P<": {POS: ADP},
    "<prd>|PRP|@PRED>": {POS: ADP},
    "<premod>|<kc>|ADV|@ADVL>": {POS: ADV},
    "<premod>|<quant>|ADV|@ADVL>": {POS: ADV},
    "<premod>|ADV|@<ADVL": {POS: ADV},
    "<premod>|ADV|@ADVL>": {POS: ADV},
    "<prop>|<Eg>|<n>|<np-def>|ADJ|M|S|@<ACC": {POS: ADJ},
    "<prop>|<Eg>|<n>|<np-def>|ADJ|M|S|@<ADVL": {POS: ADJ},
    "<prop>|<Eg>|<n>|<np-def>|ADJ|M|S|@P<": {POS: ADJ},
    "<prop>|<NUM-ord>|ADJ|M|S|@N<": {POS: ADJ},
    "<prop>|<card>|<np-def>|NUM|M|P|@P<": {POS: NUM},
    "<prop>|<card>|NUM|F|P|@>N": {POS: NUM},
    "<prop>|<card>|NUM|M|P|@>N": {POS: NUM},
    "<prop>|<n>|<card>|<np-def>|NUM|M|P|@P<": {POS: NUM},
    "<prop>|<n>|<np-def>|ADJ|M|S|@<SUBJ": {POS: ADJ},
    "<prop>|<n>|<np-def>|ADJ|M|S|@P<": {POS: ADJ},
    "<prop>|<n>|<np-def>|ADJ|M|S|@SUBJ>": {POS: ADJ},
    "<prop>|<n>|<np-idf>|ADJ|M|S|@P<": {POS: ADJ},
    "<prop>|<n>|ADJ|M|S|@P<": {POS: ADJ},
    "<prop>|<np-def>|N|F|P|@<ACC": {POS: NOUN},
    "<prop>|<np-def>|N|F|P|@P<": {POS: NOUN},
    "<prop>|<np-def>|N|F|P|@SUBJ>": {POS: NOUN},
    "<prop>|<np-def>|N|F|S|@<ACC": {POS: NOUN},
    "<prop>|<np-def>|N|F|S|@<SUBJ": {POS: NOUN},
    "<prop>|<np-def>|N|F|S|@N<PRED": {POS: NOUN},
    "<prop>|<np-def>|N|F|S|@P<": {POS: NOUN},
    "<prop>|<np-def>|N|F|S|@SUBJ>": {POS: NOUN},
    "<prop>|<np-def>|N|M|P|@<ACC": {POS: NOUN},
    "<prop>|<np-def>|N|M|P|@<SUBJ": {POS: NOUN},
    "<prop>|<np-def>|N|M|P|@P<": {POS: NOUN},
    "<prop>|<np-def>|N|M|P|@SUBJ>": {POS: NOUN},
    "<prop>|<np-def>|N|M|S|@<ACC": {POS: NOUN},
    "<prop>|<np-def>|N|M|S|@<SC": {POS: NOUN},
    "<prop>|<np-def>|N|M|S|@<SUBJ": {POS: NOUN},
    "<prop>|<np-def>|N|M|S|@APP": {POS: NOUN},
    "<prop>|<np-def>|N|M|S|@NPHR": {POS: NOUN},
    "<prop>|<np-def>|N|M|S|@P<": {POS: NOUN},
    "<prop>|<np-def>|N|M|S|@SUBJ>": {POS: NOUN},
    "<prop>|<np-idf>|N|@P<": {POS: NOUN},
    "<prop>|<np-idf>|N|F|P|@P<": {POS: NOUN},
    "<prop>|<np-idf>|N|F|S|@<ACC": {POS: NOUN},
    "<prop>|<np-idf>|N|F|S|@<SC": {POS: NOUN},
    "<prop>|<np-idf>|N|F|S|@<SUBJ": {POS: NOUN},
    "<prop>|<np-idf>|N|F|S|@N<": {POS: NOUN},
    "<prop>|<np-idf>|N|F|S|@N<PRED": {POS: NOUN},
    "<prop>|<np-idf>|N|F|S|@NPHR": {POS: NOUN},
    "<prop>|<np-idf>|N|F|S|@P<": {POS: NOUN},
    "<prop>|<np-idf>|N|F|S|@SUBJ>": {POS: NOUN},
    "<prop>|<np-idf>|N|M/F|S|@P<": {POS: NOUN},
    "<prop>|<np-idf>|N|M|P|@<OC": {POS: NOUN},
    "<prop>|<np-idf>|N|M|P|@<SUBJ": {POS: NOUN},
    "<prop>|<np-idf>|N|M|P|@P<": {POS: NOUN},
    "<prop>|<np-idf>|N|M|S|@<ACC": {POS: NOUN},
    "<prop>|<np-idf>|N|M|S|@<SC": {POS: NOUN},
    "<prop>|<np-idf>|N|M|S|@<SUBJ": {POS: NOUN},
    "<prop>|<np-idf>|N|M|S|@N<": {POS: NOUN},
    "<prop>|<np-idf>|N|M|S|@N<PRED": {POS: NOUN},
    "<prop>|<np-idf>|N|M|S|@NPHR": {POS: NOUN},
    "<prop>|<np-idf>|N|M|S|@P<": {POS: NOUN},
    "<prop>|<np-idf>|N|M|S|@SUBJ>": {POS: NOUN},
    "<prop>|ADJ|F|P|@N<": {POS: ADJ},
    "<prop>|ADJ|F|S|@N<": {POS: ADJ},
    "<prop>|ADJ|M/F|S|@N<": {POS: ADJ},
    "<prop>|ADJ|M|P|@N<": {POS: ADJ},
    "<prop>|ADJ|M|S|@N<": {POS: ADJ},
    "<prp>|<cjt>|ADV|@<ADVL": {POS: ADV},
    "<prp>|<first-cjt>|PRP|@<ADVL": {POS: ADP},
    "<prp>|<rel>|<first-cjt>|PRP|@<SC": {POS: ADP},
    "<prp>|<rel>|PRP|@<ADVL": {POS: ADP},
    "<prp>|<rel>|PRP|@ADVL>": {POS: ADP},
    "<prp>|PRP|@<OC": {POS: ADP},
    "<prp>|PRP|@<SC": {POS: ADP},
    "<prp>|PRP|@A<": {POS: ADP},
    "<quant>|<KOMP>|<COMP>|ADV|@<ACC": {POS: ADV},
    "<quant>|<KOMP>|<COMP>|ADV|@<ADVL": {POS: ADV},
    "<quant>|<KOMP>|<COMP>|ADV|@<SC": {POS: ADV},
    "<quant>|<KOMP>|<COMP>|ADV|@>A": {POS: ADV},
    "<quant>|<KOMP>|<COMP>|ADV|@>N": {POS: ADV},
    "<quant>|<KOMP>|<COMP>|ADV|@A<": {POS: ADV},
    "<quant>|<KOMP>|<COMP>|ADV|@ACC>": {POS: ADV},
    "<quant>|<KOMP>|<COMP>|ADV|@ADVL": {POS: ADV},
    "<quant>|<KOMP>|<COMP>|ADV|@ADVL>": {POS: ADV},
    "<quant>|<KOMP>|<COMP>|ADV|@CO": {POS: ADV},
    "<quant>|<KOMP>|<COMP>|ADV|@N<": {POS: ADV},
    "<quant>|<KOMP>|<COMP>|ADV|@N<PRED": {POS: ADV},
    "<quant>|<KOMP>|<COMP>|ADV|@P<": {POS: ADV},
    "<quant>|<KOMP>|<COMP>|ADV|F|P|@<ADVL": {POS: ADV},
    "<quant>|<KOMP>|<COMP>|DET|F|P|@<ACC": {POS: PRON},
    "<quant>|<KOMP>|<COMP>|DET|F|P|@<SC": {POS: PRON},
    "<quant>|<KOMP>|<COMP>|DET|F|P|@>N": {POS: DET},
    "<quant>|<KOMP>|<COMP>|DET|F|S|@>N": {POS: DET},
    "<quant>|<KOMP>|<COMP>|DET|F|S|@SUBJ>": {POS: PRON},
    "<quant>|<KOMP>|<COMP>|DET|M/F|S/P|@<ACC": {POS: PRON},
    "<quant>|<KOMP>|<COMP>|DET|M/F|S/P|@P<": {POS: PRON},
    "<quant>|<KOMP>|<COMP>|DET|M|P|@>N": {POS: DET},
    "<quant>|<KOMP>|<COMP>|DET|M|P|@P<": {POS: PRON},
    "<quant>|<KOMP>|<COMP>|DET|M|P|@SUBJ>": {POS: PRON},
    "<quant>|<KOMP>|<COMP>|DET|M|S/P|@<SC": {POS: PRON},
    "<quant>|<KOMP>|<COMP>|DET|M|S|@<SC": {POS: PRON},
    "<quant>|<KOMP>|<COMP>|DET|M|S|@>N": {POS: DET},
    "<quant>|<KOMP>|<COMP>|DET|M|S|@P<": {POS: PRON},
    "<quant>|<KOMP>|<COMP>|DET|M|S|@SUBJ>": {POS: PRON},
    "<quant>|<KOMP>|<np-def>|<COMP>|DET|M|P|@P<": {POS: PRON},
    "<quant>|<KOMP>|ADV|@>A": {POS: ADV},
    "<quant>|<KOMP>|ADV|@CO": {POS: ADV},
    "<quant>|<KOMP>|DET|M/F|S/P|@>A": {POS: DET},
    "<quant>|<KOMP>|DET|M|P|@>A": {POS: DET},
    "<quant>|<KOMP>|DET|M|S|@>A": {POS: DET},
    "<quant>|<SUP>|DET|M|S|@>N": {POS: DET},
    "<quant>|<det>|ADV|@<ACC": {POS: ADV},
    "<quant>|<det>|ADV|@>A": {POS: ADV},
    "<quant>|<det>|ADV|@>N": {POS: ADV},
    "<quant>|<det>|ADV|@ADVL>": {POS: ADV},
    "<quant>|<det>|ADV|@P<": {POS: ADV},
    "<quant>|<det>|INDP|M|S|@P<": {POS: PRON},
    "<quant>|<interr>|ADV|@>N": {POS: ADV},
    "<quant>|<interr>|ADV|@P<": {POS: ADV},
    "<quant>|<np-def>|DET|M|P|@<ACC": {POS: PRON},
    "<quant>|<np-def>|DET|M|S|@P<": {POS: PRON},
    "<quant>|<np-def>|DET|M|S|@SUBJ>": {POS: PRON},
    "<quant>|<np-idf>|DET|F|S|@SUBJ>": {POS: PRON},
    "<quant>|<np-idf>|DET|M|P|@P<": {POS: PRON},
    "<quant>|<np-idf>|DET|M|P|@SUBJ>": {POS: PRON},
    "<quant>|<np-idf>|DET|M|S|@ACC>": {POS: PRON},
    "<quant>|<np-idf>|DET|M|S|@P<": {POS: PRON},
    "<quant>|<parkc-1>|<KOMP>|ADV|@CO": {POS: ADV},
    "<quant>|<parkc-1>|<KOMP>|KC|@CO": {POS: CCONJ},
    "<quant>|ADJ|F|P|@N<": {POS: ADJ},
    "<quant>|ADJ|F|S|@<SC": {POS: ADJ},
    "<quant>|ADJ|F|S|@>N": {POS: ADJ},
    "<quant>|ADJ|F|S|@N<": {POS: ADJ},
    "<quant>|ADJ|M|P|@<OC": {POS: ADJ},
    "<quant>|ADJ|M|P|@N<": {POS: ADJ},
    "<quant>|ADJ|M|S|@<SC": {POS: ADJ},
    "<quant>|ADV|@<ACC": {POS: ADV},
    "<quant>|ADV|@<ADVL": {POS: ADV},
    "<quant>|ADV|@<SA": {POS: ADV},
    "<quant>|ADV|@<SC": {POS: ADV},
    "<quant>|ADV|@>A": {POS: ADV},
    "<quant>|ADV|@>N": {POS: ADV},
    "<quant>|ADV|@>P": {POS: ADV},
    "<quant>|ADV|@A<": {POS: ADV},
    "<quant>|ADV|@ADVL>": {POS: ADV},
    "<quant>|ADV|@CO": {POS: ADV},
    "<quant>|ADV|@FS-STA": {POS: ADV},
    "<quant>|ADV|@N<": {POS: ADV},
    "<quant>|ADV|@N<|<MWE2>": {POS: ADV},
    "<quant>|ADV|@P<": {POS: ADV},
    "<quant>|ART|F|S|@>N": {POS: DET},
    "<quant>|ART|M|S|@>N": {POS: DET},
    "<quant>|DET|@>A": {POS: DET},
    "<quant>|DET|F|P|@<ACC": {POS: PRON},
    "<quant>|DET|F|P|@<SC": {POS: PRON},
    "<quant>|DET|F|P|@<SUBJ": {POS: PRON},
    "<quant>|DET|F|P|@>N": {POS: DET},
    "<quant>|DET|F|P|@N<": {POS: DET},
    "<quant>|DET|F|P|@N<PRED": {POS: DET},
    "<quant>|DET|F|P|@NPHR": {POS: DET},
    "<quant>|DET|F|P|@P<": {POS: PRON},
    "<quant>|DET|F|P|@SUBJ>": {POS: PRON},
    "<quant>|DET|F|S|@<ACC": {POS: PRON},
    "<quant>|DET|F|S|@<SC": {POS: PRON},
    "<quant>|DET|F|S|@>A": {POS: DET},
    "<quant>|DET|F|S|@>N": {POS: DET},
    "<quant>|DET|F|S|@A<": {POS: DET},
    "<quant>|DET|F|S|@N<": {POS: DET},
    "<quant>|DET|F|S|@N<PRED": {POS: DET},
    "<quant>|DET|F|S|@P<": {POS: PRON},
    "<quant>|DET|F|S|@SUBJ>": {POS: PRON},
    "<quant>|DET|M/F|P|@>N": {POS: DET},
    "<quant>|DET|M/F|S/P|@<ACC": {POS: PRON},
    "<quant>|DET|M/F|S|@>N": {POS: DET},
    "<quant>|DET|M|P|@<ACC": {POS: PRON},
    "<quant>|DET|M|P|@<SC": {POS: PRON},
    "<quant>|DET|M|P|@<SUBJ": {POS: PRON},
    "<quant>|DET|M|P|@>A": {POS: DET},
    "<quant>|DET|M|P|@>N": {POS: DET},
    "<quant>|DET|M|P|@N<": {POS: DET},
    "<quant>|DET|M|P|@N<PRED": {POS: DET},
    "<quant>|DET|M|P|@P<": {POS: PRON},
    "<quant>|DET|M|P|@PRED>": {POS: DET},
    "<quant>|DET|M|P|@SC>": {POS: PRON},
    "<quant>|DET|M|P|@SUBJ>": {POS: PRON},
    "<quant>|DET|M|S|@<ACC": {POS: PRON},
    "<quant>|DET|M|S|@<SC": {POS: PRON},
    "<quant>|DET|M|S|@>A": {POS: DET},
    "<quant>|DET|M|S|@>N": {POS: DET},
    "<quant>|DET|M|S|@>P": {POS: DET},
    "<quant>|DET|M|S|@ADVL>": {POS: DET},
    "<quant>|DET|M|S|@N<": {POS: DET},
    "<quant>|DET|M|S|@N<PRED": {POS: DET},
    "<quant>|DET|M|S|@P<": {POS: PRON},
    "<quant>|DET|M|S|@SUBJ>": {POS: PRON},
    "<quant>|INDP|M/F|S|@SUBJ>": {POS: PRON},
    "<quant>|INDP|M|S|@<ACC": {POS: PRON},
    "<quant>|INDP|M|S|@<SC": {POS: PRON},
    "<quant>|INDP|M|S|@<SUBJ": {POS: PRON},
    "<quant>|INDP|M|S|@>A": {POS: PRON},
    "<quant>|INDP|M|S|@>N": {POS: PRON},
    "<quant>|INDP|M|S|@ACC>": {POS: PRON},
    "<quant>|INDP|M|S|@N<": {POS: PRON},
    "<quant>|INDP|M|S|@N<PRED": {POS: PRON},
    "<quant>|INDP|M|S|@NPHR": {POS: PRON},
    "<quant>|INDP|M|S|@P<": {POS: PRON},
    "<quant>|INDP|M|S|@S<": {POS: PRON},
    "<quant>|INDP|M|S|@SC>": {POS: PRON},
    "<quant>|INDP|M|S|@SUBJ>": {POS: PRON},
    "<reci>|PERS|F|3P|ACC|@ACC>": {POS: PRON},
    "<reci>|PERS|M|3P|ACC|@ACC>": {POS: PRON},
    "<refl>|<first-cjt>|PERS|M|1S|DAT|@ACC>": {POS: PRON},
    "<refl>|PERS|3S|ACC|@ACC>": {POS: PRON},
    "<refl>|PERS|3S|PIV|@P<": {POS: PRON},
    "<refl>|PERS|F|1S|ACC|@<ACC": {POS: PRON},
    "<refl>|PERS|F|1S|ACC|@ACC>": {POS: PRON},
    "<refl>|PERS|F|1S|DAT|@<DAT": {POS: PRON},
    "<refl>|PERS|F|1S|DAT|@DAT>": {POS: PRON},
    "<refl>|PERS|F|3P|ACC|@<ACC": {POS: PRON},
    "<refl>|PERS|F|3S|ACC|@<ACC": {POS: PRON},
    "<refl>|PERS|F|3S|ACC|@ACC-PASS": {POS: PRON},
    "<refl>|PERS|F|3S|DAT|@<DAT": {POS: PRON},
    "<refl>|PERS|F|3S|DAT|@DAT>": {POS: PRON},
    "<refl>|PERS|F|3S|PIV|@P<": {POS: PRON},
    "<refl>|PERS|M/F|1P|ACC|@<ACC": {POS: PRON},
    "<refl>|PERS|M/F|1P|ACC|@<DAT": {POS: PRON},
    "<refl>|PERS|M/F|1P|ACC|@ACC>": {POS: PRON},
    "<refl>|PERS|M/F|1P|DAT|@<ACC": {POS: PRON},
    "<refl>|PERS|M/F|1P|DAT|@<DAT": {POS: PRON},
    "<refl>|PERS|M/F|1P|DAT|@DAT>": {POS: PRON},
    "<refl>|PERS|M/F|1S|ACC|@<ACC": {POS: PRON},
    "<refl>|PERS|M/F|1S|ACC|@<DAT": {POS: PRON},
    "<refl>|PERS|M/F|1S|ACC|@ACC>": {POS: PRON},
    "<refl>|PERS|M/F|1S|DAT|@<DAT": {POS: PRON},
    "<refl>|PERS|M/F|1S|DAT|@ACC>": {POS: PRON},
    "<refl>|PERS|M/F|1S|DAT|@DAT>": {POS: PRON},
    "<refl>|PERS|M/F|2P|ACC|@<ACC": {POS: PRON},
    "<refl>|PERS|M/F|2P|DAT|@DAT>": {POS: PRON},
    "<refl>|PERS|M/F|3P|ACC|@<ACC": {POS: PRON},
    "<refl>|PERS|M/F|3S/P|ACC/DAT|@VOC": {POS: PRON},
    "<refl>|PERS|M/F|3S/P|ACC|@VOC": {POS: PRON},
    "<refl>|PERS|M/F|3S/P|DAT|@DAT>": {POS: PRON},
    "<refl>|PERS|M/F|3S/P|PIV|@P<": {POS: PRON},
    "<refl>|PERS|M/F|3S|PIV|@P<": {POS: PRON},
    "<refl>|PERS|M|1P|ACC|@<ACC": {POS: PRON},
    "<refl>|PERS|M|1P|ACC|@ACC>": {POS: PRON},
    "<refl>|PERS|M|1P|DAT|@DAT>": {POS: PRON},
    "<refl>|PERS|M|1S|ACC|@<ACC": {POS: PRON},
    "<refl>|PERS|M|1S|ACC|@ACC>": {POS: PRON},
    "<refl>|PERS|M|1S|DAT|@<DAT": {POS: PRON},
    "<refl>|PERS|M|1S|DAT|@DAT>": {POS: PRON},
    "<refl>|PERS|M|2S|ACC|@<ACC": {POS: PRON},
    "<refl>|PERS|M|2S|ACC|@ACC>": {POS: PRON},
    "<refl>|PERS|M|2S|ACC|@DAT>": {POS: PRON},
    "<refl>|PERS|M|3P|ACC|@<ACC": {POS: PRON},
    "<refl>|PERS|M|3P|ACC|@ACC-PASS": {POS: PRON},
    "<refl>|PERS|M|3P|DAT|@<DAT": {POS: PRON},
    "<refl>|PERS|M|3P|DAT|@DAT>": {POS: PRON},
    "<refl>|PERS|M|3P|PIV|@P<": {POS: PRON},
    "<refl>|PERS|M|3S|ACC|@<ACC": {POS: PRON},
    "<refl>|PERS|M|3S|ACC|@<DAT": {POS: PRON},
    "<refl>|PERS|M|3S|ACC|@ACC>": {POS: PRON},
    "<refl>|PERS|M|3S|DAT|@<DAT": {POS: PRON},
    "<refl>|PERS|M|3S|DAT|@DAT>": {POS: PRON},
    "<refl>|PERS|M|3S|PIV|@P<": {POS: PRON},
    "<rel>|<com>|ADV|@<ADVL": {POS: ADV},
    "<rel>|<com>|ADV|@ADVL>": {POS: ADV},
    "<rel>|<com>|ADV|@COM": {POS: ADV},
    "<rel>|<com>|ADV|@N<PRED": {POS: ADV},
    "<rel>|<com>|PRP|@ADVL>": {POS: ADP},
    "<rel>|<com>|PRP|@KOMP<": {POS: ADP},
    "<rel>|<com>|PRP|@N<": {POS: ADP},
    "<rel>|<com>|PRP|@N<PRED": {POS: ADP},
    "<rel>|<first-cjt>|PRP|@ADVL>": {POS: ADP},
    "<rel>|<np-def>|DET|F|P|@P<": {POS: PRON},
    "<rel>|<np-def>|DET|F|S|@P<": {POS: PRON},
    "<rel>|<np-def>|DET|M|S|@P<": {POS: PRON},
    "<rel>|<prd>|ADV|@N<": {POS: ADV},
    "<rel>|<prd>|PRP|@<SC": {POS: ADP},
    "<rel>|<quant>|<ks>|ADV|@ADVL>": {POS: ADV},
    "<rel>|<quant>|ADV|@>A": {POS: ADV},
    "<rel>|<quant>|ADV|@COM": {POS: ADV},
    "<rel>|<quant>|DET|M|S|@N<|<MWE2>": {POS: DET},
    "<rel>|<quant>|INDP|M|S|@ACC>": {POS: PRON},
    "<rel>|<quant>|INDP|M|S|@SUBJ>": {POS: PRON},
    "<rel>|ADV|@<ADVL": {POS: ADV},
    "<rel>|ADV|@>A": {POS: ADV},
    "<rel>|ADV|@>N": {POS: ADV},
    "<rel>|ADV|@ADVL>": {POS: ADV},
    "<rel>|ADV|@COM": {POS: ADV},
    "<rel>|ADV|@P<": {POS: ADV},
    "<rel>|ADV|@SA>": {POS: ADV},
    "<rel>|ADV|@SUB": {POS: ADV},
    "<rel>|DET|F|P|@>N": {POS: DET},
    "<rel>|DET|F|P|@SUBJ>": {POS: PRON},
    "<rel>|DET|F|S|@>N": {POS: DET},
    "<rel>|DET|F|S|@ADVL>": {POS: DET},
    "<rel>|DET|F|S|@SC>": {POS: PRON},
    "<rel>|DET|M|P|@>N": {POS: DET},
    "<rel>|DET|M|P|@ACC>": {POS: PRON},
    "<rel>|DET|M|P|@SUBJ>": {POS: PRON},
    "<rel>|DET|M|S|@>N": {POS: DET},
    "<rel>|DET|M|S|@ACC>": {POS: PRON},
    "<rel>|DET|M|S|@P<": {POS: PRON},
    "<rel>|INDP|@SUBJ>": {POS: PRON},
    "<rel>|INDP|F|@SUBJ>": {POS: PRON},
    "<rel>|INDP|F|P|@ACC>": {POS: PRON},
    "<rel>|INDP|F|P|@P<": {POS: PRON},
    "<rel>|INDP|F|P|@PIV>": {POS: PRON},
    "<rel>|INDP|F|P|@SUBJ>": {POS: PRON},
    "<rel>|INDP|F|S|@>N": {POS: PRON},
    "<rel>|INDP|F|S|@ACC>": {POS: PRON},
    "<rel>|INDP|F|S|@ADVL>": {POS: PRON},
    "<rel>|INDP|F|S|@P<": {POS: PRON},
    "<rel>|INDP|F|S|@SC>": {POS: PRON},
    "<rel>|INDP|F|S|@SUB": {POS: PRON},
    "<rel>|INDP|F|S|@SUBJ>": {POS: PRON},
    "<rel>|INDP|M/F|P|@P<": {POS: PRON},
    "<rel>|INDP|M/F|P|@SC>": {POS: PRON},
    "<rel>|INDP|M/F|P|@SUBJ>": {POS: PRON},
    "<rel>|INDP|M/F|S/P|@ACC>": {POS: PRON},
    "<rel>|INDP|M/F|S/P|@P<": {POS: PRON},
    "<rel>|INDP|M/F|S/P|@SUB": {POS: PRON},
    "<rel>|INDP|M/F|S/P|@SUBJ>": {POS: PRON},
    "<rel>|INDP|M/F|S|@<SC": {POS: PRON},
    "<rel>|INDP|M/F|S|@ACC>": {POS: PRON},
    "<rel>|INDP|M/F|S|@P<": {POS: PRON},
    "<rel>|INDP|M/F|S|@SUBJ>": {POS: PRON},
    "<rel>|INDP|M|P|@ACC>": {POS: PRON},
    "<rel>|INDP|M|P|@P<": {POS: PRON},
    "<rel>|INDP|M|P|@SUB": {POS: PRON},
    "<rel>|INDP|M|P|@SUBJ>": {POS: PRON},
    "<rel>|INDP|M|S|@ACC>": {POS: PRON},
    "<rel>|INDP|M|S|@N<": {POS: PRON},
    "<rel>|INDP|M|S|@P<": {POS: PRON},
    "<rel>|INDP|M|S|@SC>": {POS: PRON},
    "<rel>|INDP|M|S|@SUB": {POS: PRON},
    "<rel>|INDP|M|S|@SUBJ>": {POS: PRON},
    "<rel>|INDP|S/P|@SUBJ>": {POS: PRON},
    "<rel>|PRP|@<ADVL": {POS: ADP},
    "<rel>|PRP|@ADVL>": {POS: ADP},
    "<sam->|<cjt>|PRP|@<ADVL": {POS: ADP},
    "<sam->|<cjt>|PRP|@<OA": {POS: ADP},
    "<sam->|<cjt>|PRP|@<PIV": {POS: ADP},
    "<sam->|<cjt>|PRP|@<SA": {POS: ADP},
    "<sam->|<cjt>|PRP|@>N": {POS: ADP},
    "<sam->|<cjt>|PRP|@A<": {POS: ADP},
    "<sam->|<cjt>|PRP|@ADVL>": {POS: ADP},
    "<sam->|<cjt>|PRP|@N<": {POS: ADP},
    "<sam->|<cjt>|PRP|@N<PRED": {POS: ADP},
    "<sam->|<cjt>|PRP|@P<": {POS: ADP},
    "<sam->|<cjt>|PRP|@PASS": {POS: ADP},
    "<sam->|<cjt>|PRP|@PIV>": {POS: ADP},
    "<sam->|<cjt>|PRP|@PRED>": {POS: ADP},
    "<sam->|<cjt>|PRP|@UTT": {POS: ADP},
    "<sam->|<first-cjt>|PRP|@<ADVL": {POS: ADP},
    "<sam->|<first-cjt>|PRP|@<OA": {POS: ADP},
    "<sam->|<first-cjt>|PRP|@<OC": {POS: ADP},
    "<sam->|<first-cjt>|PRP|@<PIV": {POS: ADP},
    "<sam->|<first-cjt>|PRP|@<SA": {POS: ADP},
    "<sam->|<first-cjt>|PRP|@<SC": {POS: ADP},
    "<sam->|<first-cjt>|PRP|@>N": {POS: ADP},
    "<sam->|<first-cjt>|PRP|@A<": {POS: ADP},
    "<sam->|<first-cjt>|PRP|@ADVL": {POS: ADP},
    "<sam->|<first-cjt>|PRP|@ADVL>": {POS: ADP},
    "<sam->|<first-cjt>|PRP|@KOMP<": {POS: ADP},
    "<sam->|<first-cjt>|PRP|@N<": {POS: ADP},
    "<sam->|<first-cjt>|PRP|@N<ARG": {POS: ADP},
    "<sam->|<first-cjt>|PRP|@N<PRED": {POS: ADP},
    "<sam->|<first-cjt>|PRP|@P<": {POS: ADP},
    "<sam->|<first-cjt>|PRP|@PASS": {POS: ADP},
    "<sam->|<first-cjt>|PRP|@PIV>": {POS: ADP},
    "<sam->|<first-cjt>|PRP|@PRED>": {POS: ADP},
    "<sam->|<first-cjt>|PRP|@STA": {POS: ADP},
    "<sam->|<first-cjt>|PRP|@UTT": {POS: ADP},
    "<sam->|<komp>|PRP|@KOMP<": {POS: ADP},
    "<sam->|ADV|@ADVL": {POS: ADV},
    "<sam->|PERS|M/F|3S|DAT|@DAT>": {POS: PRON},
    "<sam->|PRP|@-H": {POS: ADP},
    "<sam->|PRP|@<ACC": {POS: ADP},
    "<sam->|PRP|@<ADVL": {POS: ADP},
    "<sam->|PRP|@<OA": {POS: ADP},
    "<sam->|PRP|@<OC": {POS: ADP},
    "<sam->|PRP|@<PIV": {POS: ADP},
    "<sam->|PRP|@<PRED": {POS: ADP},
    "<sam->|PRP|@<SA": {POS: ADP},
    "<sam->|PRP|@<SC": {POS: ADP},
    "<sam->|PRP|@<SUBJ": {POS: ADP},
    "<sam->|PRP|@>A": {POS: ADP},
    "<sam->|PRP|@>N": {POS: ADP},
    "<sam->|PRP|@>P": {POS: ADP},
    "<sam->|PRP|@A<": {POS: ADP},
    "<sam->|PRP|@A<ADVL": {POS: ADP},
    "<sam->|PRP|@A<ARG": {POS: ADP},
    "<sam->|PRP|@ADVL": {POS: ADP},
    "<sam->|PRP|@ADVL>": {POS: ADP},
    "<sam->|PRP|@COM": {POS: ADP},
    "<sam->|PRP|@KOMP<": {POS: ADP},
    "<sam->|PRP|@N<": {POS: ADP},
    "<sam->|PRP|@N<ARG": {POS: ADP},
    "<sam->|PRP|@N<PRED": {POS: ADP},
    "<sam->|PRP|@OA>": {POS: ADP},
    "<sam->|PRP|@P<": {POS: ADP},
    "<sam->|PRP|@PASS": {POS: ADP},
    "<sam->|PRP|@PIV>": {POS: ADP},
    "<sam->|PRP|@PRED>": {POS: ADP},
    "<sam->|PRP|@SA>": {POS: ADP},
    "<sam->|PRP|@SUB": {POS: ADP},
    "<sam->|PRP|@UTT": {POS: ADP},
    "<setop>|ADV|@>A": {POS: ADV},
    "<setop>|ADV|@>N": {POS: ADV},
    "<setop>|ADV|@A<": {POS: ADV},
    "<setop>|ADV|@N<": {POS: ADV},
    "<setop>|ADV|M|P|@>N": {POS: ADV},
    "<setop>|ADV|M|S|@>A": {POS: ADV},
    "<year>|<card>|<date>|NUM|M|P|@<ACC": {POS: NUM},
    "<year>|<card>|<date>|NUM|M|P|@APP": {POS: NUM},
    "<year>|<card>|<date>|NUM|M|P|@N<": {POS: NUM},
    "<year>|<card>|<date>|NUM|M|P|@N<PRED": {POS: NUM},
    "<year>|<card>|<date>|NUM|M|P|@P<": {POS: NUM},
    "<year>|<card>|<date>|NUM|M|P|@SUBJ>": {POS: NUM},
    "<year>|<card>|<date>|NUM|M|S|@ADVL>": {POS: NUM},
    "<year>|<card>|<date>|NUM|M|S|@N<": {POS: NUM},
    "<year>|<card>|<date>|NUM|M|S|@N<PRED": {POS: NUM},
    "<year>|<card>|<date>|NUM|M|S|@P<": {POS: NUM},
    "<year>|<card>|<date>|NUM|M|S|@SUBJ>": {POS: NUM},
    "<year>|<card>|<first-cjt>|<date>|NUM|M|S|@P<": {POS: NUM},
    "<year>|<date>|NUM|M|P|@P<": {POS: NUM},
    "<year>|<date>|NUM|M|S|@N<PRED": {POS: NUM},
    "<year>|<date>|NUM|M|S|@P<": {POS: NUM},
    "<year>|<first-cjt>|<card>|<date>|NUM|M|P|@P<": {POS: NUM},
    "<year>|<first-cjt>|<card>|<date>|NUM|M|S|@N<": {POS: NUM},
    "<year>|<first-cjt>|<card>|<date>|NUM|M|S|@P<": {POS: NUM},
    "<year>|<first-cjt>|<date>|NUM|M|P|@P<": {POS: NUM},
    "<year>|<first-cjt>|<date>|NUM|M|S|@P<": {POS: NUM},
    "<year>|<n>|<date>|NUM|M|P|@P<": {POS: NUM},
    "ADJ|@<OC": {POS: ADJ},
    "ADJ|@A<": {POS: ADJ},
    "ADJ|@N<": {POS: ADJ},
    "ADJ|@P<": {POS: ADJ},
    "ADJ|F|P|@<OC": {POS: ADJ},
    "ADJ|F|P|@<SC": {POS: ADJ},
    "ADJ|F|P|@>N": {POS: ADJ},
    "ADJ|F|P|@A<": {POS: ADJ},
    "ADJ|F|P|@N<": {POS: ADJ},
    "ADJ|F|P|@N<PRED": {POS: ADJ},
    "ADJ|F|P|@NPHR": {POS: ADJ},
    "ADJ|F|P|@P<": {POS: ADJ},
    "ADJ|F|P|@SC>": {POS: ADJ},
    "ADJ|F|S|@<OC": {POS: ADJ},
    "ADJ|F|S|@<PRED": {POS: ADJ},
    "ADJ|F|S|@<SA": {POS: ADJ},
    "ADJ|F|S|@<SC": {POS: ADJ},
    "ADJ|F|S|@<sC": {POS: ADJ},
    "ADJ|F|S|@>N": {POS: ADJ},
    "ADJ|F|S|@ICL-<SC": {POS: ADJ},
    "ADJ|F|S|@ICL-N<": {POS: ADJ},
    "ADJ|F|S|@N<": {POS: ADJ},
    "ADJ|F|S|@N<PRED": {POS: ADJ},
    "ADJ|F|S|@NPHR": {POS: ADJ},
    "ADJ|F|S|@P<": {POS: ADJ},
    "ADJ|F|S|@PRED>": {POS: ADJ},
    "ADJ|F|S|@SC>": {POS: ADJ},
    "ADJ|M/F|P|@<SC": {POS: ADJ},
    "ADJ|M/F|P|@N<": {POS: ADJ},
    "ADJ|M/F|P|@P<": {POS: ADJ},
    "ADJ|M/F|S|@<SC": {POS: ADJ},
    "ADJ|M/F|S|@<sC": {POS: ADJ},
    "ADJ|M/F|S|@A<": {POS: ADJ},
    "ADJ|M/F|S|@NPHR": {POS: ADJ},
    "ADJ|M/F|S|@P<": {POS: ADJ},
    "ADJ|M/F|S|@PRED>": {POS: ADJ},
    "ADJ|M|P|@<OC": {POS: ADJ},
    "ADJ|M|P|@<SC": {POS: ADJ},
    "ADJ|M|P|@>N": {POS: ADJ},
    "ADJ|M|P|@A<": {POS: ADJ},
    "ADJ|M|P|@ADVL>": {POS: ADJ},
    "ADJ|M|P|@APP": {POS: ADJ},
    "ADJ|M|P|@ICL-<SC": {POS: ADJ},
    "ADJ|M|P|@ICL-N<": {POS: ADJ},
    "ADJ|M|P|@ICL-N<PRED": {POS: ADJ},
    "ADJ|M|P|@N<": {POS: ADJ},
    "ADJ|M|P|@N<PRED": {POS: ADJ},
    "ADJ|M|P|@P<": {POS: ADJ},
    "ADJ|M|P|@PRED>": {POS: ADJ},
    "ADJ|M|S|@<ACC": {POS: ADJ},
    "ADJ|M|S|@<ADVL": {POS: ADJ},
    "ADJ|M|S|@<OC": {POS: ADJ},
    "ADJ|M|S|@<PRED": {POS: ADJ},
    "ADJ|M|S|@<SC": {POS: ADJ},
    "ADJ|M|S|@>A": {POS: ADJ},
    "ADJ|M|S|@>N": {POS: ADJ},
    "ADJ|M|S|@A<": {POS: ADJ},
    "ADJ|M|S|@APP": {POS: ADJ},
    "ADJ|M|S|@ICL-N<": {POS: ADJ},
    "ADJ|M|S|@ICL-N<PRED": {POS: ADJ},
    "ADJ|M|S|@KOMP<": {POS: ADJ},
    "ADJ|M|S|@N<": {POS: ADJ},
    "ADJ|M|S|@N<PRED": {POS: ADJ},
    "ADJ|M|S|@NPHR": {POS: ADJ},
    "ADJ|M|S|@OC>": {POS: ADJ},
    "ADJ|M|S|@P<": {POS: ADJ},
    "ADJ|M|S|@PRED>": {POS: ADJ},
    "ADJ|M|S|@SC>": {POS: ADJ},
    "ADJ|M|S|@SUBJ>": {POS: ADJ},
    "ADP": {POS: ADP},
    "ADV|@<ACC": {POS: ADV},
    "ADV|@<ADVL": {POS: ADV},
    "ADV|@<FOC": {POS: ADV},
    "ADV|@<OA": {POS: ADV},
    "ADV|@<OC": {POS: ADV},
    "ADV|@<PIV": {POS: ADV},
    "ADV|@<SA": {POS: ADV},
    "ADV|@<SC": {POS: ADV},
    "ADV|@<sA": {POS: ADV},
    "ADV|@>A": {POS: ADV},
    "ADV|@>N": {POS: ADV},
    "ADV|@>P": {POS: ADV},
    "ADV|@>S": {POS: ADV},
    "ADV|@A<": {POS: ADV},
    "ADV|@ADVL": {POS: ADV},
    "ADV|@ADVL>": {POS: ADV},
    "ADV|@APP": {POS: ADV},
    "ADV|@AS-<ADVL": {POS: ADV},
    "ADV|@AS-ADVL>": {POS: ADV},
    "ADV|@AS-KOMP<": {POS: ADV},
    "ADV|@CO": {POS: ADV},
    "ADV|@FOC>": {POS: ADV},
    "ADV|@FS-N<": {POS: ADV},
    "ADV|@ICL-AUX<": {POS: ADV},
    "ADV|@KOMP<": {POS: ADV},
    "ADV|@N<": {POS: ADV},
    "ADV|@N<PRED": {POS: ADV},
    "ADV|@P<": {POS: ADV},
    "ADV|@PRED>": {POS: ADV},
    "ADV|@PRT-AUX<": {POS: ADV},
    "ADV|@PU": {POS: ADV},
    "ADV|@S<": {POS: ADV},
    "ADV|@SA>": {POS: ADV},
    "ADV|@SC>": {POS: ADV},
    "ADV|@STA": {POS: ADV},
    "ADV|@SUB": {POS: ADV},
    "ADV|@SUBJ>": {POS: ADV},
    "ADV|M|P|@<ADVL": {POS: ADV},
    "ADV|M|S|@<ADVL": {POS: ADV},
    "ADV|M|S|@APP": {POS: ADV},
    "ART|F|S|@>N": {POS: DET},
    "ART|M|P|@>N": {POS: DET},
    "ART|M|S|@>A": {POS: DET},
    "ART|M|S|@>N": {POS: DET},
    "CONJ": {POS: CCONJ},
    "DET|F|P|@>N": {POS: DET},
    "DET|F|P|@P<": {POS: PRON},
    "DET|F|P|@SUBJ>": {POS: PRON},
    "DET|F|S|@>A": {POS: DET},
    "DET|F|S|@>N": {POS: DET},
    "DET|F|S|@P<": {POS: PRON},
    "DET|F|S|@SUB": {POS: DET},
    "DET|F|S|@SUBJ>": {POS: PRON},
    "DET|M/F|S|@A<": {POS: DET},
    "DET|M/F|S|@SUBJ>": {POS: PRON},
    "DET|M|P|@<ADVL": {POS: DET},
    "DET|M|P|@>N": {POS: DET},
    "DET|M|P|@P<": {POS: PRON},
    "DET|M|P|@SUB": {POS: DET},
    "DET|M|S|@<ADVL": {POS: DET},
    "DET|M|S|@<SC": {POS: PRON},
    "DET|M|S|@>A": {POS: DET},
    "DET|M|S|@>N": {POS: DET},
    "DET|M|S|@>P": {POS: DET},
    "DET|M|S|@ADVL>": {POS: DET},
    "DET|M|S|@N<PRED": {POS: DET},
    "DET|M|S|@P<": {POS: PRON},
    "DET|M|S|@SUB": {POS: DET},
    "DET|M|S|@SUBJ>": {POS: PRON},
    "EC|@>N": {POS: PART},
    "INDP|F|S|@<ACC": {POS: PRON},
    "INDP|F|S|@P<": {POS: PRON},
    "INDP|F|S|@SUB": {POS: PRON},
    "INDP|F|S|@SUBJ>": {POS: PRON},
    "INDP|M/F|S/P|@P<": {POS: PRON},
    "INDP|M/F|S|@SUBJ>": {POS: PRON},
    "INDP|M|P|@ACC>": {POS: PRON},
    "INDP|M|P|@SUBJ>": {POS: PRON},
    "INDP|M|S/P|@P<": {POS: PRON},
    "INDP|M|S|@<ACC": {POS: PRON},
    "INDP|M|S|@<OC": {POS: PRON},
    "INDP|M|S|@<SUBJ": {POS: PRON},
    "INDP|M|S|@>N": {POS: PRON},
    "INDP|M|S|@ACC>": {POS: PRON},
    "INDP|M|S|@P<": {POS: PRON},
    "INDP|M|S|@S<": {POS: PRON},
    "INDP|M|S|@SUBJ>": {POS: PRON},
    "INDP|S/P|@SUBJ>": {POS: PRON},
    "IN|@<ACC": {POS: INTJ},
    "IN|@<ADVL": {POS: INTJ},
    "IN|@A<": {POS: INTJ},
    "IN|@ACC>": {POS: INTJ},
    "IN|@ADVL>": {POS: INTJ},
    "IN|@EXC": {POS: INTJ},
    "IN|@P<": {POS: INTJ},
    "IN|@UTT": {POS: INTJ},
    "IN|F|S|@<ADVL": {POS: INTJ},
    "IN|PS|3S|IND|@FS-<ADVL": {POS: INTJ},
    "KC|@CO": {POS: PUNCT},
    "KC|@N<": {POS: CCONJ},
    "KS|@<ACC": {POS: SCONJ},
    "KS|@<ADVL": {POS: SCONJ},
    "KS|@<FOC": {POS: SCONJ},
    "KS|@>S": {POS: SCONJ},
    "KS|@A<": {POS: SCONJ},
    "KS|@ADVL>": {POS: SCONJ},
    "KS|@COM": {POS: SCONJ},
    "KS|@KOMP<": {POS: SCONJ},
    "KS|@P<": {POS: SCONJ},
    "KS|@PRT-AUX<": {POS: SCONJ},
    "KS|@SUB": {POS: SCONJ},
    "KS|@SUBJ>": {POS: SCONJ},
    "NOUN": {POS: NOUN},
    "NUM|@A<": {POS: NUM},
    "NUM|@ADVL>": {POS: NUM},
    "NUM|@NPHR": {POS: NUM},
    "NUM|F|P|@<SUBJ": {POS: NUM},
    "NUM|M/F|P|@P<": {POS: NUM},
    "NUM|M|P|@<ADVL": {POS: NUM},
    "NUM|M|P|@>A": {POS: NUM},
    "NUM|M|P|@>N": {POS: NUM},
    "NUM|M|P|@A<PRED": {POS: NUM},
    "NUM|M|P|@N<": {POS: NUM},
    "NUM|M|P|@P<": {POS: NUM},
    "NUM|M|S|@>N": {POS: NUM},
    "NUM|M|S|@ADVL>": {POS: NUM},
    "NUM|M|S|@N<PRED": {POS: NUM},
    "NUM|M|S|@P<": {POS: NUM},
    "NUM|P|@>N": {POS: NUM},
    "NUM|P|@A<": {POS: NUM},
    "NUM|P|@P<": {POS: NUM},
    "N|@<ACC": {POS: NOUN},
    "N|@<OC": {POS: NOUN},
    "N|@<SC": {POS: NOUN},
    "N|@<SUBJ": {POS: NOUN},
    "N|@>N": {POS: NOUN},
    "N|@N<PRED": {POS: NOUN},
    "N|@P<": {POS: NOUN},
    "N|@PRED>": {POS: NOUN},
    "N|@SUBJ>": {POS: NOUN},
    "N|F|P|@>N": {POS: NOUN},
    "N|F|P|@N<PRED": {POS: NOUN},
    "N|F|P|@P<": {POS: NOUN},
    "N|F|S|@<ADVL": {POS: NOUN},
    "N|F|S|@>N": {POS: NOUN},
    "N|F|S|@>S": {POS: NOUN},
    "N|F|S|@ACC>": {POS: NOUN},
    "N|F|S|@ADVL>": {POS: NOUN},
    "N|F|S|@P<": {POS: NOUN},
    "N|M|P|@>N": {POS: NOUN},
    "N|M|P|@P<": {POS: NOUN},
    "N|M|P|@SUBJ>": {POS: NOUN},
    "N|M|S|@<ACC": {POS: NOUN},
    "N|M|S|@<ADVL": {POS: NOUN},
    "N|M|S|@>A": {POS: NOUN},
    "N|M|S|@>N": {POS: NOUN},
    "N|M|S|@ADVL>": {POS: NOUN},
    "N|M|S|@AS<": {POS: NOUN},
    "N|M|S|@FS-STA": {POS: NOUN},
    "N|M|S|@N<": {POS: NOUN},
    "N|M|S|@N<PRED": {POS: NOUN},
    "N|M|S|@P<": {POS: NOUN},
    "N|M|S|@SUBJ>": {POS: NOUN},
    "PERS|F/M|3S/P|ACC|@<SUBJ": {POS: PRON},
    "PERS|F|1P|NOM/PIV|@N<": {POS: PRON},
    "PERS|F|1S|NOM|@SUBJ>": {POS: PRON},
    "PERS|F|1S|PIV|@P<": {POS: PRON},
    "PERS|F|3P|ACC|@<ACC": {POS: PRON},
    "PERS|F|3P|ACC|@<ACC-PASS": {POS: PRON},
    "PERS|F|3P|ACC|@ACC-PASS": {POS: PRON},
    "PERS|F|3P|ACC|@ACC>": {POS: PRON},
    "PERS|F|3P|ACC|@ACC>-PASS": {POS: PRON},
    "PERS|F|3P|DAT|@<DAT": {POS: PRON},
    "PERS|F|3P|DAT|@DAT>": {POS: PRON},
    "PERS|F|3P|NOM/PIV|@P<": {POS: PRON},
    "PERS|F|3P|NOM|@SUBJ>": {POS: PRON},
    "PERS|F|3P|PIV|@P<": {POS: PRON},
    "PERS|F|3S/P|ACC|@<SUBJ": {POS: PRON},
    "PERS|F|3S/P|ACC|@SUBJ>": {POS: PRON},
    "PERS|F|3S|ACC|@<ACC": {POS: PRON},
    "PERS|F|3S|ACC|@<ACC-PASS": {POS: PRON},
    "PERS|F|3S|ACC|@<SUBJ": {POS: PRON},
    "PERS|F|3S|ACC|@>N": {POS: PRON},
    "PERS|F|3S|ACC|@ACC-PASS": {POS: PRON},
    "PERS|F|3S|ACC|@ACC>": {POS: PRON},
    "PERS|F|3S|ACC|@ACC>-PASS": {POS: PRON},
    "PERS|F|3S|ACC|@SUBJ>": {POS: PRON},
    "PERS|F|3S|DAT|@<DAT": {POS: PRON},
    "PERS|F|3S|DAT|@ACC>-PASS": {POS: PRON},
    "PERS|F|3S|DAT|@DAT>": {POS: PRON},
    "PERS|F|3S|NOM/PIV|@P<": {POS: PRON},
    "PERS|F|3S|NOM|@<SC": {POS: PRON},
    "PERS|F|3S|NOM|@<SUBJ": {POS: PRON},
    "PERS|F|3S|NOM|@SUBJ>": {POS: PRON},
    "PERS|F|3S|PIV|@P<": {POS: PRON},
    "PERS|F|P|@ACC>-PASS": {POS: PRON},
    "PERS|F|S|@ACC>": {POS: PRON},
    "PERS|F|S|@ACC>-PASS": {POS: PRON},
    "PERS|F|S|ACC|@<ACC": {POS: PRON},
    "PERS|M/F|1P|ACC|@SUBJ>": {POS: PRON},
    "PERS|M/F|1P|DAT|@<DAT": {POS: PRON},
    "PERS|M/F|1P|DAT|@DAT>": {POS: PRON},
    "PERS|M/F|1P|NOM/PIV|@P<": {POS: PRON},
    "PERS|M/F|1P|NOM|@<ACC": {POS: PRON},
    "PERS|M/F|1P|NOM|@SUBJ>": {POS: PRON},
    "PERS|M/F|1P|PIV|@P<": {POS: PRON},
    "PERS|M/F|1S|ACC|@SUBJ>": {POS: PRON},
    "PERS|M/F|1S|DAT|@<DAT": {POS: PRON},
    "PERS|M/F|1S|NOM|@<SC": {POS: PRON},
    "PERS|M/F|1S|NOM|@<SUBJ": {POS: PRON},
    "PERS|M/F|1S|NOM|@P<": {POS: PRON},
    "PERS|M/F|1S|NOM|@SUBJ>": {POS: PRON},
    "PERS|M/F|1S|PIV|@P<": {POS: PRON},
    "PERS|M/F|2P|NOM|@<SUBJ": {POS: PRON},
    "PERS|M/F|3P|ACC|@<ACC-PASS": {POS: PRON},
    "PERS|M/F|3P|ACC|@ACC>-PASS": {POS: PRON},
    "PERS|M/F|3P|DAT|@<DAT": {POS: PRON},
    "PERS|M/F|3P|DAT|@DAT>": {POS: PRON},
    "PERS|M/F|3P|NOM|@SUBJ>": {POS: PRON},
    "PERS|M/F|3S/P|ACC|@<ACC": {POS: PRON},
    "PERS|M/F|3S/P|ACC|@<ACC-PASS": {POS: PRON},
    "PERS|M/F|3S/P|ACC|@<SC": {POS: PRON},
    "PERS|M/F|3S/P|ACC|@<SUBJ": {POS: PRON},
    "PERS|M/F|3S/P|ACC|@ACC>": {POS: PRON},
    "PERS|M/F|3S/P|ACC|@ACC>-PASS": {POS: PRON},
    "PERS|M/F|3S/P|ACC|@SUBJ>": {POS: PRON},
    "PERS|M/F|3S/P|ACC|@VOC": {POS: PRON},
    "PERS|M/F|3S|ACC|@<ACC-PASS": {POS: PRON},
    "PERS|M/F|3S|ACC|@<SUBJ": {POS: PRON},
    "PERS|M/F|3S|ACC|@ACC>-PASS": {POS: PRON},
    "PERS|M/F|3S|ACC|@SUBJ>": {POS: PRON},
    "PERS|M/F|3S|DAT|@<DAT": {POS: PRON},
    "PERS|M/F|3S|DAT|@DAT>": {POS: PRON},
    "PERS|M/F|3S|NOM/PIV|@P<": {POS: PRON},
    "PERS|M/F|3S|NOM|@<SC": {POS: PRON},
    "PERS|M/F|3S|NOM|@SUBJ>": {POS: PRON},
    "PERS|M|1P|DAT|@DAT>": {POS: PRON},
    "PERS|M|1P|NOM/PIV|@P<": {POS: PRON},
    "PERS|M|1P|NOM|@<SC": {POS: PRON},
    "PERS|M|1P|NOM|@N<PRED": {POS: PRON},
    "PERS|M|1P|NOM|@SUBJ>": {POS: PRON},
    "PERS|M|1S|DAT|@<DAT": {POS: PRON},
    "PERS|M|1S|NOM|@<SC": {POS: PRON},
    "PERS|M|1S|NOM|@SUBJ>": {POS: PRON},
    "PERS|M|1S|PIV|@P<": {POS: PRON},
    "PERS|M|2S|PIV|@P<": {POS: PRON},
    "PERS|M|3P|ACC|@<ACC": {POS: PRON},
    "PERS|M|3P|ACC|@<ACC-PASS": {POS: PRON},
    "PERS|M|3P|ACC|@ACC-PASS": {POS: PRON},
    "PERS|M|3P|ACC|@ACC>": {POS: PRON},
    "PERS|M|3P|ACC|@ACC>-PASS": {POS: PRON},
    "PERS|M|3P|ACC|@SUBJ>": {POS: PRON},
    "PERS|M|3P|DAT|@<DAT": {POS: PRON},
    "PERS|M|3P|DAT|@DAT>": {POS: PRON},
    "PERS|M|3P|NOM/PIV|@NPHR": {POS: PRON},
    "PERS|M|3P|NOM/PIV|@P<": {POS: PRON},
    "PERS|M|3P|NOM|@<SC": {POS: PRON},
    "PERS|M|3P|NOM|@N<PRED": {POS: PRON},
    "PERS|M|3P|NOM|@P<": {POS: PRON},
    "PERS|M|3P|NOM|@SUBJ>": {POS: PRON},
    "PERS|M|3P|PIV|@P<": {POS: PRON},
    "PERS|M|3S/P|ACC|@<ACC-PASS": {POS: PRON},
    "PERS|M|3S/P|ACC|@<SUBJ": {POS: PRON},
    "PERS|M|3S/P|ACC|@ACC>-PASS": {POS: PRON},
    "PERS|M|3S/P|ACC|@SUBJ>": {POS: PRON},
    "PERS|M|3S|ACC|@<ACC": {POS: PRON},
    "PERS|M|3S|ACC|@<ACC-PASS": {POS: PRON},
    "PERS|M|3S|ACC|@<SC": {POS: PRON},
    "PERS|M|3S|ACC|@<SUBJ": {POS: PRON},
    "PERS|M|3S|ACC|@ACC-PASS": {POS: PRON},
    "PERS|M|3S|ACC|@ACC>": {POS: PRON},
    "PERS|M|3S|ACC|@ACC>-PASS": {POS: PRON},
    "PERS|M|3S|ACC|@DAT>": {POS: PRON},
    "PERS|M|3S|ACC|@SC>": {POS: PRON},
    "PERS|M|3S|ACC|@SUBJ>": {POS: PRON},
    "PERS|M|3S|DAT|@<DAT": {POS: PRON},
    "PERS|M|3S|DAT|@DAT>": {POS: PRON},
    "PERS|M|3S|NOM/PIV|@P<": {POS: PRON},
    "PERS|M|3S|NOM|@<SC": {POS: PRON},
    "PERS|M|3S|NOM|@<SUBJ": {POS: PRON},
    "PERS|M|3S|NOM|@N<PRED": {POS: PRON},
    "PERS|M|3S|NOM|@P<": {POS: PRON},
    "PERS|M|3S|NOM|@SUBJ>": {POS: PRON},
    "PERS|M|3S|NOM|@TOP": {POS: PRON},
    "PERS|M|3S|PIV|@P<": {POS: PRON},
    "PERS|M|P|@ACC-PASS": {POS: PRON},
    "PERS|M|P|@ACC>-PASS": {POS: PRON},
    "PERS|M|P|ACC|@ACC>-PASS": {POS: PRON},
    "PERS|M|S|@ACC>": {POS: PRON},
    "PERS|M|S|@ACC>-PASS": {POS: PRON},
    "PERS|M|S|@SUBJ>": {POS: PRON},
    "PERS|M|S|ACC|@SUBJ>": {POS: PRON},
    "PROP": {POS: PROPN},
    "PROPN": {POS: PROPN},
    "PROP|@<PIV": {POS: PROPN},
    "PROP|@N<": {POS: PROPN},
    "PROP|@P<": {POS: PROPN},
    "PROP|F/M|S|@P<": {POS: PROPN},
    "PROP|F|P|@<ACC": {POS: PROPN},
    "PROP|F|P|@APP": {POS: PROPN},
    "PROP|F|P|@N<": {POS: PROPN},
    "PROP|F|P|@N<PRED": {POS: PROPN},
    "PROP|F|P|@P<": {POS: PROPN},
    "PROP|F|P|@SUBJ>": {POS: PROPN},
    "PROP|F|S|@<ACC": {POS: PROPN},
    "PROP|F|S|@<OC": {POS: PROPN},
    "PROP|F|S|@<SC": {POS: PROPN},
    "PROP|F|S|@<SUBJ": {POS: PROPN},
    "PROP|F|S|@>N": {POS: PROPN},
    "PROP|F|S|@ADVL>": {POS: PROPN},
    "PROP|F|S|@APP": {POS: PROPN},
    "PROP|F|S|@KOMP<": {POS: PROPN},
    "PROP|F|S|@N<": {POS: PROPN},
    "PROP|F|S|@N<PRED": {POS: PROPN},
    "PROP|F|S|@NPHR": {POS: PROPN},
    "PROP|F|S|@P<": {POS: PROPN},
    "PROP|F|S|@S<": {POS: PROPN},
    "PROP|F|S|@SUBJ>": {POS: PROPN},
    "PROP|F|S|@UTT": {POS: PROPN},
    "PROP|F|S|@VOK": {POS: PROPN},
    "PROP|M/F|P|@P<": {POS: PROPN},
    "PROP|M/F|S|@<ACC": {POS: PROPN},
    "PROP|M/F|S|@<SC": {POS: PROPN},
    "PROP|M/F|S|@<SUBJ": {POS: PROPN},
    "PROP|M/F|S|@N<PRED": {POS: PROPN},
    "PROP|M/F|S|@NPHR": {POS: PROPN},
    "PROP|M/F|S|@P<": {POS: PROPN},
    "PROP|M/F|S|@SUBJ>": {POS: PROPN},
    "PROP|M|P|@<ACC": {POS: PROPN},
    "PROP|M|P|@<OC": {POS: PROPN},
    "PROP|M|P|@<SC": {POS: PROPN},
    "PROP|M|P|@<SUBJ": {POS: PROPN},
    "PROP|M|P|@APP": {POS: PROPN},
    "PROP|M|P|@N<": {POS: PROPN},
    "PROP|M|P|@N<PRED": {POS: PROPN},
    "PROP|M|P|@NPHR": {POS: PROPN},
    "PROP|M|P|@P<": {POS: PROPN},
    "PROP|M|P|@SUBJ>": {POS: PROPN},
    "PROP|M|P|@UTT": {POS: PROPN},
    "PROP|M|S|@<ACC": {POS: PROPN},
    "PROP|M|S|@<ADVL": {POS: PROPN},
    "PROP|M|S|@<OC": {POS: PROPN},
    "PROP|M|S|@<PIV": {POS: PROPN},
    "PROP|M|S|@<SC": {POS: PROPN},
    "PROP|M|S|@<SUBJ": {POS: PROPN},
    "PROP|M|S|@<sUBJ": {POS: PROPN},
    "PROP|M|S|@A<": {POS: PROPN},
    "PROP|M|S|@ACC>": {POS: PROPN},
    "PROP|M|S|@ADVL>": {POS: PROPN},
    "PROP|M|S|@APP": {POS: PROPN},
    "PROP|M|S|@N<": {POS: PROPN},
    "PROP|M|S|@N<PRED": {POS: PROPN},
    "PROP|M|S|@NPHR": {POS: PROPN},
    "PROP|M|S|@P<": {POS: PROPN},
    "PROP|M|S|@PRED>": {POS: PROPN},
    "PROP|M|S|@SUBJ>": {POS: PROPN},
    "PROP|M|S|@UTT": {POS: PROPN},
    "PRP|@<ACC": {POS: ADP},
    "PRP|@<ADVL": {POS: ADP},
    "PRP|@<ADVL|@P<": {POS: ADP},
    "PRP|@<FOC": {POS: ADP},
    "PRP|@<OA": {POS: ADP},
    "PRP|@<OC": {POS: ADP},
    "PRP|@<PIV": {POS: ADP},
    "PRP|@<PRED": {POS: ADP},
    "PRP|@<SA": {POS: ADP},
    "PRP|@<SC": {POS: ADP},
    "PRP|@<SUBJ": {POS: ADP},
    "PRP|@>A": {POS: ADP},
    "PRP|@>N": {POS: ADP},
    "PRP|@>P": {POS: ADP},
    "PRP|@>S": {POS: ADP},
    "PRP|@A<": {POS: ADP},
    "PRP|@A<ADVL": {POS: ADP},
    "PRP|@A<ARG": {POS: ADP},
    "PRP|@ACC>": {POS: ADP},
    "PRP|@ADVL": {POS: ADP},
    "PRP|@ADVL>": {POS: ADP},
    "PRP|@ADVL>>": {POS: ADP},
    "PRP|@AS-ADVL>": {POS: ADP},
    "PRP|@AS<": {POS: ADP},
    "PRP|@CO": {POS: ADP},
    "PRP|@COM": {POS: ADP},
    "PRP|@EXC": {POS: ADP},
    "PRP|@ICL-N<": {POS: ADP},
    "PRP|@ICL-N<PRED": {POS: ADP},
    "PRP|@KOMP<": {POS: ADP},
    "PRP|@N<": {POS: ADP},
    "PRP|@N<ARG": {POS: ADP},
    "PRP|@N<PRED": {POS: ADP},
    "PRP|@NUM<": {POS: ADP},
    "PRP|@OA>": {POS: ADP},
    "PRP|@P<": {POS: ADP},
    "PRP|@PASS": {POS: ADP},
    "PRP|@PIV>": {POS: ADP},
    "PRP|@PRED>": {POS: ADP},
    "PRP|@PRT-AUX<": {POS: ADP},
    "PRP|@QUE": {POS: ADP},
    "PRP|@SA>": {POS: ADP},
    "PRP|@SC>": {POS: ADP},
    "PRP|@SUB": {POS: ADP},
    "PRP|@SUBJ>": {POS: ADP},
    "PRP|@UTT": {POS: ADP},
    "PU|@PU": {POS: PUNCT},
    "V|GER|@SUB": {POS: VERB},
    "V|PCP|F|P|@ICL-OC>": {POS: VERB},
    "V|PCP|F|P|@N<PRED": {POS: ADJ},
    "V|PCP|F|S|@N<": {POS: ADJ},
    "V|PCP|F|S|@P<": {POS: VERB},
    "V|PCP|M|P|@>N": {POS: VERB},
    "V|PCP|M|S|@>N": {POS: VERB},
    "V|PCP|M|S|@ICL-CO": {POS: VERB},
    "V|PCP|M|S|@N<": {POS: ADJ},
    "V|PCP|M|S|@P<": {POS: ADJ},
    "V|PR|3S|IND|@FS-P<": {POS: VERB},
    "_": {POS: X},
    "adj|F|S": {POS: ADJ},
    "ADV": {POS: ADV},
    "art|<-sam>|<artd>|F|S": {POS: DET},
    "art|<artd>|M|P": {POS: DET},
    "n|F|S": {POS: NOUN},
    "n|M|P": {POS: NOUN},
    "n|M|S": {POS: NOUN},
    "prop|F|S": {POS: PROPN},
    "prop|M|P": {POS: PROPN},
    "prop|M|S": {POS: PROPN},
    "prp": {POS: ADP},
    "prp|<sam->": {POS: ADP},
    "punc": {POS: PUNCT},
    "v-pcp|M|P": {POS: VERB},
    "v-pcp|M|S": {POS: VERB},
    "_SP": {POS: SPACE},
}
