# coding: utf8
from __future__ import unicode_literals


# Adding a lemmatizer lookup table
# Documentation: https://spacy.io/docs/usage/adding-languages#lemmatizer
# Entries should be added in the following format:



LOOKUP = {
  "آ": "آنا",
  "آْباد": "آْباد",
  "آثار": "آثار",
  "آثارِ": "آثارِ",
  "آثارالصنادید": "آثارالصنادید",
  "آثارو": "آثار",
  "آثاروں": "آثار",
  "آڈیو": "آڈیو",
  "آڈیوز": "آڈیوز",
  "آغا": "آغا",
  "آغاحشر": "آغاحشر",
  "آغاز": "آغاز",
  "آغازو": "آغاز",
  "آغازوں": "آغاز",
  "آغوش": "آغوش",
  "آغوشو": "آغوش",
  "آغوشوں": "آغوش",
  "آغوشیں": "آغوش",
  "آحباب": "آحباب",
  "آحبابو": "آحباب",
  "آحبابوں": "آحباب",
  "آخَر": "آخَر",
  "آخِر": "آخِر",
  "آخر": "آخر",
  "آخرالذکر": "آخرالذکر",
  "آخرالزماں": "آخرالزماں",
  "آخرالزمان": "آخرالزمان",
  "آخردماغ": "آخردماغ",
  "آخرکار": "آخرکار",
  "آخرت": "آخرت",
  "آخرتو": "آخرت",
  "آخرتوں": "آخرت",
  "آخرتیں": "آخرت",
  "آٹے": "آٹا",
  "آٹا": "آٹا",
  "آٹو": "آٹا",
  "آٹوں": "آٹا",
  "آٹھ": "آٹھ",
  "آٹھواں": "آٹھواں",
  "آٹھووںں": "آٹھواں",
  "آٹھویں": "آٹھواں",
  "آشامی": "آشامی",
  "آشامیاں": "آشامی",
  "آشامیو": "آشامی",
  "آشامیوں": "آشامی",
  "آشانے": "آشانہ",
  "آشانہ": "آشانہ",
  "آشانو": "آشانہ",
  "آشانوں": "آشانہ",
  "آذاد": "آذاد",
  "آذان": "آذان",
  "آذانو": "آذان",
  "آذانوں": "آذان",
  "آذانیں": "آذان",
  "آب": "آب",
  "آبخورے": "آبخورہ",
  "آبخورہ": "آبخورہ",
  "آبخورو": "آبخورہ",
  "آبخوروں": "آبخورہ",
  "آبشار": "آبشار",
  "آبشارو": "آبشار",
  "آبشاروں": "آبشار",
  "آبشاریں": "آبشار",
  "آبا": "آبا",
  "آبادی": "آبادی",
  "آبادیاں": "آبادی",
  "آبادیو": "آبادی",
  "آبادیوں": "آبادی",
  "آباؤ": "آبا",
  "آباؤں": "آبا",
  "آبائ": "آبائ",
  "آبائو": "آبائ",
  "آبائوں": "آبائ",
  "آبائی": "آبائی",
  "آبگینے": "آبگینہ",
  "آبگینہ": "آبگینہ",
  "آبگینو": "آبگینہ",
  "آبگینوں": "آبگینہ",
  "آبلے": "آبلہ",
  "آبلہ": "آبلہ",
  "آبلو": "آبلہ",
  "آبلوں": "آبلہ",
  "آبرو": "آبرو",
  "آبروو": "آبرو",
  "آبرووں": "آبرو",
  "آبروؤ": "آبرو",
  "آبروؤں": "آبرو",
  "آبرویں": "آبرو",
  "آبروئیں": "آبرو",
  "آبی": "آبی",
  "آداب": "آداب",
  "آدم": "آدم",
  "آدمو": "آدم",
  "آدموں": "آدم",
  "آدمی": "آدمی",
  "آدمیاں": "آدمی",
  "آدمیو": "آدمی",
  "آدمیوں": "آدمی",
  "آدرش": "آدرش",
  "آدھمک": "آدھمکنا",
  "آدھمکے": "آدھمکنا",
  "آدھمکں": "آدھمکنا",
  "آدھمکا": "آدھمکنا",
  "آدھمکانے": "آدھمکنا",
  "آدھمکانا": "آدھمکنا",
  "آدھمکاتے": "آدھمکنا",
  "آدھمکاتا": "آدھمکنا",
  "آدھمکاتی": "آدھمکنا",
  "آدھمکاتیں": "آدھمکنا",
  "آدھمکاؤ": "آدھمکنا",
  "آدھمکاؤں": "آدھمکنا",
  "آدھمکائے": "آدھمکنا",
  "آدھمکائی": "آدھمکنا",
  "آدھمکائیے": "آدھمکنا",
  "آدھمکائیں": "آدھمکنا",
  "آدھمکایا": "آدھمکنا",
  "آدھمکنے": "آدھمکنا",
  "آدھمکنا": "آدھمکنا",
  "آدھمکنی": "آدھمکنا",
  "آدھمکتے": "آدھمکنا",
  "آدھمکتا": "آدھمکنا",
  "آدھمکتی": "آدھمکنا",
  "آدھمکتیں": "آدھمکنا",
  "آدھمکو": "آدھمکنا",
  "آدھمکوں": "آدھمکنا",
  "آدھمکی": "آدھمکنا",
  "آدھمکیے": "آدھمکنا",
  "آدھمکیں": "آدھمکنا",
  "آفاقے": "آفاقہ",
  "آفاقہ": "آفاقہ",
  "آفاقو": "آفاقہ",
  "آفاقوں": "آفاقہ",
  "آفاقی": "آفاقی",
  "آفاقیت": "آفاقیت",
  "آفریں": "آفریں",
  "آفریدے": "آفریدہ",
  "آفریدہ": "آفریدہ",
  "آفریدو": "آفریدہ",
  "آفریدوں": "آفریدہ",
  "آفرین": "آفرین",
  "آفرینو": "آفرین",
  "آفرینوں": "آفرین",
  "آفت": "آفت",
  "آفتاب": "آفتاب",
  "آفتابو": "آفتاب",
  "آفتابوں": "آفتاب",
  "آفتو": "آفت",
  "آفتوں": "آفت",
  "آفتیں": "آفت",
  "آفیسر": "آفیسر",
  "آفیسرو": "آفیسر",
  "آفیسروں": "آفیسر",
  "آگرے": "آگرا",
  "آگرا": "آگرا",
  "آگرہ": "آگرہ",
  "آگرو": "آگرا",
  "آگروں": "آگرا",
  "آگیا": "آگیا",
  "آگیاؤں": "آگیا",
  "آگیائیں": "آگیا",
  "آہ": "آہ",
  "آہٹ": "آہٹ",
  "آہٹو": "آہٹ",
  "آہٹوں": "آہٹ",
  "آہٹیں": "آہٹ",
  "آہو": "آہ",
  "آہوں": "آہ",
  "آہیں": "آہ",
  "آل": "آل",
  "آلُو": "آلُو",
  "آلُوؤ": "آلُو",
  "آلُوؤں": "آلُو",
  "آلے": "آلا",
  "آلا": "آلا",
  "آلو": "آلا",
  "آلوں": "آلا",
  "آلودگی": "آلودگی",
  "آلودگیاں": "آلودگی",
  "آلودگیو": "آلودگی",
  "آلودگیوں": "آلودگی",
  "آلوؤ": "آلو",
  "آلوؤں": "آلو",
  "آلیں": "آل",
  "آم": "آم",
  "آمد": "آمد",
  "آمدنی": "آمدنی",
  "آمدنیاں": "آمدنی",
  "آمدنیو": "آمدنی",
  "آمدنیوں": "آمدنی",
  "آمدو": "آمد",
  "آمدوں": "آمد",
  "آمدیں": "آمد",
  "آملے": "آملہ",
  "آملہ": "آملہ",
  "آملو": "آملہ",
  "آملوں": "آملہ",
  "آمنا": "آمنا",
  "آمر": "آمر",
  "آمرو": "آمر",
  "آمروں": "آمر",
  "آمو": "آم",
  "آموں": "آم",
  "آنے": "آنہ",
  "آنا": "آنا",
  "آندھی": "آندھی",
  "آندھیاں": "آندھی",
  "آندھیو": "آندھی",
  "آندھیوں": "آندھی",
  "آنگن": "آنگن",
  "آنگنو": "آنگن",
  "آنگنوں": "آنگن",
  "آنہ": "آنہ",
  "آنکے": "آنکہ",
  "آنکہ": "آنکہ",
  "آنکو": "آنکہ",
  "آنکوں": "آنکہ",
  "آنکھ": "آنکھ",
  "آنکھو": "آنکھ",
  "آنکھوں": "آنکھ",
  "آنکھیں": "آنکھ",
  "آنسو": "آنسو",
  "آنسوو": "آنسو",
  "آنسووں": "آنسو",
  "آنسوؤ": "آنسو",
  "آنسوؤں": "آنسو",
  "آنت": "آنت",
  "آنتو": "آنت",
  "آنتوں": "آنت",
  "آنتیں": "آنت",
  "آنو": "آنہ",
  "آنوں": "آنہ",
  "آنی": "آنا",
  "آپ": "آپ",
  "آپْکے": "میرا",
  "آپْکا": "میرا",
  "آپْکی": "میرا",
  "آپَس": "آپَس",
  "آپکے": "میرا",
  "آپکا": "میرا",
  "آپکی": "میرا",
  "آپس": "آپَس",
  "آقا": "آقا",
  "آقاؤ": "آقا",
  "آقاؤں": "آقا",
  "آرے": "آرہ",
  "آرٹسٹ": "آرٹسٹ",
  "آرٹسٹو": "آرٹسٹ",
  "آرٹسٹوں": "آرٹسٹ",
  "آرائش": "آرائش",
  "آرائشو": "آرائش",
  "آرائشوں": "آرائش",
  "آرائشیں": "آرائش",
  "آرائی": "آرائی",
  "آرائیاں": "آرائی",
  "آرائیو": "آرائی",
  "آرائیوں": "آرائی",
  "آرہ": "آرہ",
  "آرو": "آرہ",
  "آروں": "آرہ",
  "آرز": "آرز",
  "آرزے": "آرزہ",
  "آرزہ": "آرزہ",
  "آرزو": "آرزہ",
  "آرزوں": "آرزہ",
  "آرزوؤ": "آرزو",
  "آرزوؤں": "آرزو",
  "آرزوئیں": "آرزو",
  "آسامی": "آسامی",
  "آسامیاں": "آسامی",
  "آسامیو": "آسامی",
  "آسامیوں": "آسامی",
  "آسانی": "آسانی",
  "آسانیا": "آسانیا",
  "آسانیاں": "آسانی",
  "آسانیو": "آسانی",
  "آسانیوں": "آسانی",
  "آسائش": "آسائش",
  "آسائشو": "آسائش",
  "آسائشوں": "آسائش",
  "آسائشیں": "آسائش",
  "آسمان": "آسمان",
  "آسمانو": "آسمان",
  "آسمانوں": "آسمان",
  "آستانے": "آستانہ",
  "آستانہ": "آستانہ",
  "آستانو": "آستانہ",
  "آستانوں": "آستانہ",
  "آستن": "آستن",
  "آستنو": "آستن",
  "آستنوں": "آستن",
  "آستین": "آستین",
  "آستینو": "آستین",
  "آستینوں": "آستین",
  "آستینیں": "آستین",
  "آتے": "آنا",
  "آتا": "آنا",
  "آتی": "آنا",
  "آتیں": "آنا",
  "آؤ": "آؤ",
  "آؤں": "آنا",
  "آوارگی": "آوارگی",
  "آوارگیاں": "آوارگی",
  "آوارگیو": "آوارگی",
  "آوارگیوں": "آوارگی",
  "آواز": "آواز",
  "آوازے": "آوازہ",
  "آوازہ": "آوازہ",
  "آوازو": "آوازہ",
  "آوازوں": "آوازہ",
  "آوازیں": "آواز",
  "آور": "آور",
  "آورو": "آور",
  "آوروں": "آور",
  "آئے": "آنا",
  "آئنے": "آئنہ",
  "آئنہ": "آئنہ",
  "آئنو": "آئنہ",
  "آئنوں": "آئنہ",
  "آئی": "آئی",
  "آئیے": "آنا",
  "آئیں": "آنا",
  "آئین": "آئین",
  "آئینے": "آئینہ",
  "آئینہ": "آئینہ",
  "آئینو": "آئینہ",
  "آئینوں": "آئینہ",
  "آئیو": "آئی",
  "آئیوں": "آئی",
  "آیا": "آیا",
  "آیات": "آیات",
  "آیاتو": "آیات",
  "آیاتوں": "آیات",
  "آیاؤ": "آیا",
  "آیاؤں": "آیا",
  "آیائیں": "آیا",
  "آیت": "آیت",
  "آیتو": "آیت",
  "آیتوں": "آیت",
  "آیتیں": "آیت",
  "آزاد": "آزاد",
  "آزادو": "آزاد",
  "آزادوں": "آزاد",
  "آزادی": "آزادی",
  "آزادیاں": "آزادی",
  "آزادیو": "آزادی",
  "آزادیوں": "آزادی",
  "آزما": "آزمانا",
  "آزمانے": "آزمانا",
  "آزمانا": "آزمانا",
  "آزمانی": "آزمانا",
  "آزماتے": "آزمانا",
  "آزماتا": "آزمانا",
  "آزماتی": "آزمانا",
  "آزماتیں": "آزمانا",
  "آزماؤ": "آزمانا",
  "آزماؤں": "آزمانا",
  "آزمائے": "آزمانا",
  "آزمائش": "آزمائش",
  "آزمائشو": "آزمائش",
  "آزمائشوں": "آزمائش",
  "آزمائشیں": "آزمائش",
  "آزمائی": "آزمائی",
  "آزمائیے": "آزمانا",
  "آزمائیں": "آزمانا",
  "آزمائیاں": "آزمائی",
  "آزمائیو": "آزمائی",
  "آزمائیوں": "آزمائی",
  "آزمایا": "آزمانا",
  "ثقافت": "ثقافت",
  "ثقافتو": "ثقافت",
  "ثقافتوں": "ثقافت",
  "ثقافتیں": "ثقافت",
  "ڈِبْیا": "ڈِبْیا",
  "ڈِبْیاں": "ڈِبْیا",
  "ڈِبْیو": "ڈِبْیا",
  "ڈِبْیوں": "ڈِبْیا",
  "ڈاک": "ڈاک",
  "ڈاکُو": "ڈاکُو",
  "ڈاکُوؤ": "ڈاکُو",
  "ڈاکُوؤں": "ڈاکُو",
  "ڈاکے": "ڈاکا",
  "ڈاکخانے": "ڈاکخانہ",
  "ڈاکخانہ": "ڈاکخانہ",
  "ڈاکخانو": "ڈاکخانہ",
  "ڈاکخانوں": "ڈاکخانہ",
  "ڈاکٹر": "ڈاکٹر",
  "ڈاکٹرو": "ڈاکٹر",
  "ڈاکٹروں": "ڈاکٹر",
  "ڈاکا": "ڈاکا",
  "ڈاکہ": "ڈاکہ",
  "ڈاکو": "ڈاکا",
  "ڈاکوں": "ڈاکا",
  "ڈاکوؤ": "ڈاکو",
  "ڈاکوؤں": "ڈاکو",
  "ڈال": "ڈالنا",
  "ڈالے": "ڈالا",
  "ڈالں": "ڈالنا",
  "ڈالا": "ڈالا",
  "ڈالنے": "ڈالنا",
  "ڈالنا": "ڈالنا",
  "ڈالنی": "ڈالنا",
  "ڈالر": "ڈالر",
  "ڈالرو": "ڈالر",
  "ڈالروں": "ڈالر",
  "ڈالتے": "ڈالنا",
  "ڈالتا": "ڈالنا",
  "ڈالتی": "ڈالنا",
  "ڈالتیں": "ڈالنا",
  "ڈالو": "ڈالا",
  "ڈالوں": "ڈالا",
  "ڈالی": "ڈالی",
  "ڈالیے": "ڈالنا",
  "ڈالیں": "ڈالنا",
  "ڈالیاں": "ڈالی",
  "ڈالیو": "ڈالی",
  "ڈالیوں": "ڈالی",
  "ڈانٹ": "ڈانٹ",
  "ڈانٹو": "ڈانٹ",
  "ڈانٹوں": "ڈانٹ",
  "ڈانٹیں": "ڈانٹ",
  "ڈارمے": "ڈارمہ",
  "ڈارمہ": "ڈارمہ",
  "ڈارمو": "ڈارمہ",
  "ڈارموں": "ڈارمہ",
  "ڈائرکٹر": "ڈائرکٹر",
  "ڈائرکٹرو": "ڈائرکٹر",
  "ڈائرکٹروں": "ڈائرکٹر",
  "ڈائری": "ڈائری",
  "ڈائریاں": "ڈائری",
  "ڈائریو": "ڈائری",
  "ڈائریوں": "ڈائری",
  "ڈبے": "ڈبا",
  "ڈبا": "ڈبا",
  "ڈبہ": "ڈبہ",
  "ڈبکی": "ڈبکی",
  "ڈبکیاں": "ڈبکی",
  "ڈبکیو": "ڈبکی",
  "ڈبکیوں": "ڈبکی",
  "ڈبل": "ڈبل",
  "ڈبلو": "ڈبل",
  "ڈبلوں": "ڈبل",
  "ڈبو": "ڈبا",
  "ڈبوں": "ڈبا",
  "ڈبوا": "ڈوبنا",
  "ڈبوانے": "ڈوبنا",
  "ڈبوانا": "ڈوبنا",
  "ڈبواتے": "ڈوبنا",
  "ڈبواتا": "ڈوبنا",
  "ڈبواتی": "ڈوبنا",
  "ڈبواتیں": "ڈوبنا",
  "ڈبواؤ": "ڈوبنا",
  "ڈبواؤں": "ڈوبنا",
  "ڈبوائے": "ڈوبنا",
  "ڈبوائی": "ڈوبنا",
  "ڈبوائیے": "ڈوبنا",
  "ڈبوائیں": "ڈوبنا",
  "ڈبوایا": "ڈوبنا",
  "ڈبونے": "ڈوبنا",
  "ڈبونا": "ڈوبنا",
  "ڈبوتے": "ڈوبنا",
  "ڈبوتا": "ڈوبنا",
  "ڈبوتی": "ڈوبنا",
  "ڈبوتیں": "ڈوبنا",
  "ڈبوؤ": "ڈوبنا",
  "ڈبوؤں": "ڈوبنا",
  "ڈبوئے": "ڈوبنا",
  "ڈبوئی": "ڈوبنا",
  "ڈبوئیے": "ڈوبنا",
  "ڈبوئیں": "ڈوبنا",
  "ڈبویا": "ڈوبنا",
  "ڈبیے": "ڈبیا",
  "ڈبیا": "ڈبیا",
  "ڈبیاں": "ڈبیا",
  "ڈبیہ": "ڈبیہ",
  "ڈبیو": "ڈبیا",
  "ڈبیوں": "ڈبیا",
  "ڈگمگا": "ڈگمگانا",
  "ڈگمگانے": "ڈگمگانا",
  "ڈگمگانا": "ڈگمگانا",
  "ڈگمگانی": "ڈگمگانا",
  "ڈگمگاتے": "ڈگمگانا",
  "ڈگمگاتا": "ڈگمگانا",
  "ڈگمگاتی": "ڈگمگانا",
  "ڈگمگاتیں": "ڈگمگانا",
  "ڈگمگاؤ": "ڈگمگانا",
  "ڈگمگاؤں": "ڈگمگانا",
  "ڈگمگائے": "ڈگمگانا",
  "ڈگمگائی": "ڈگمگانا",
  "ڈگمگائیے": "ڈگمگانا",
  "ڈگمگائیں": "ڈگمگانا",
  "ڈگمگایا": "ڈگمگانا",
  "ڈگری": "ڈگری",
  "ڈگریاں": "ڈگری",
  "ڈگریو": "ڈگری",
  "ڈگریوں": "ڈگری",
  "ڈکٹیٹر": "ڈکٹیٹر",
  "ڈکٹیٹرو": "ڈکٹیٹر",
  "ڈکٹیٹروں": "ڈکٹیٹر",
  "ڈکار": "ڈکارنا",
  "ڈکارے": "ڈکارنا",
  "ڈکارں": "ڈکارنا",
  "ڈکارا": "ڈکارنا",
  "ڈکارنے": "ڈکارنا",
  "ڈکارنا": "ڈکارنا",
  "ڈکارنی": "ڈکارنا",
  "ڈکارتے": "ڈکارنا",
  "ڈکارتا": "ڈکارنا",
  "ڈکارتی": "ڈکارنا",
  "ڈکارتیں": "ڈکارنا",
  "ڈکارو": "ڈکارنا",
  "ڈکاروں": "ڈکارنا",
  "ڈکاری": "ڈکارنا",
  "ڈکاریے": "ڈکارنا",
  "ڈکاریں": "ڈکارنا",
  "ڈکیتی": "ڈکیتی",
  "ڈکیتیاں": "ڈکیتی",
  "ڈکیتیو": "ڈکیتی",
  "ڈکیتیوں": "ڈکیتی",
  "ڈل": "ڈلنا",
  "ڈلے": "ڈلا",
  "ڈلں": "ڈلنا",
  "ڈلا": "ڈلا",
  "ڈلانے": "ڈالنا",
  "ڈلانا": "ڈالنا",
  "ڈلاتے": "ڈالنا",
  "ڈلاتا": "ڈالنا",
  "ڈلاتی": "ڈالنا",
  "ڈلاتیں": "ڈالنا",
  "ڈلاؤ": "ڈالنا",
  "ڈلاؤں": "ڈالنا",
  "ڈلائے": "ڈالنا",
  "ڈلائی": "ڈالنا",
  "ڈلائیے": "ڈالنا",
  "ڈلائیں": "ڈالنا",
  "ڈلایا": "ڈالنا",
  "ڈلنے": "ڈلنا",
  "ڈلنا": "ڈلنا",
  "ڈلنی": "ڈلنا",
  "ڈلتے": "ڈلنا",
  "ڈلتا": "ڈلنا",
  "ڈلتی": "ڈلنا",
  "ڈلتیں": "ڈلنا",
  "ڈلو": "ڈلا",
  "ڈلوں": "ڈلا",
  "ڈلوا": "ڈالنا",
  "ڈلوانے": "ڈالنا",
  "ڈلوانا": "ڈالنا",
  "ڈلواتے": "ڈالنا",
  "ڈلواتا": "ڈالنا",
  "ڈلواتی": "ڈالنا",
  "ڈلواتیں": "ڈالنا",
  "ڈلواؤ": "ڈالنا",
  "ڈلواؤں": "ڈالنا",
  "ڈلوائے": "ڈالنا",
  "ڈلوائی": "ڈالنا",
  "ڈلوائیے": "ڈالنا",
  "ڈلوائیں": "ڈالنا",
  "ڈلوایا": "ڈالنا",
  "ڈلی": "ڈلنا",
  "ڈلیے": "ڈلنا",
  "ڈلیں": "ڈلنا",
  "ڈنڈے": "ڈنڈا",
  "ڈنڈا": "ڈنڈا",
  "ڈنڈو": "ڈنڈا",
  "ڈنڈوں": "ڈنڈا",
  "ڈنڈی": "ڈنڈی",
  "ڈنڈیاں": "ڈنڈی",
  "ڈنڈیو": "ڈنڈی",
  "ڈنڈیوں": "ڈنڈی",
  "ڈنگر": "ڈنگر",
  "ڈنگرو": "ڈنگر",
  "ڈنگروں": "ڈنگر",
  "ڈر": "ڈرنا",
  "ڈرے": "ڈرہ",
  "ڈرں": "ڈرنا",
  "ڈرا": "ڈرنا",
  "ڈرامے": "ڈراما",
  "ڈراما": "ڈراما",
  "ڈرامہ": "ڈرامہ",
  "ڈرامو": "ڈراما",
  "ڈراموں": "ڈراما",
  "ڈرانے": "ڈرنا",
  "ڈرانا": "ڈرنا",
  "ڈراتے": "ڈرنا",
  "ڈراتا": "ڈرنا",
  "ڈراتی": "ڈرنا",
  "ڈراتیں": "ڈرنا",
  "ڈراؤ": "ڈرنا",
  "ڈراؤں": "ڈرنا",
  "ڈرائے": "ڈرنا",
  "ڈرائی": "ڈرنا",
  "ڈرائیے": "ڈرنا",
  "ڈرائیں": "ڈرنا",
  "ڈرائیور": "ڈرائیور",
  "ڈرائیورو": "ڈرائیور",
  "ڈرائیوروں": "ڈرائیور",
  "ڈرایا": "ڈرنا",
  "ڈرہ": "ڈرہ",
  "ڈرنے": "ڈرنا",
  "ڈرنا": "ڈرنا",
  "ڈرنی": "ڈرنا",
  "ڈرپوک": "ڈرپوک",
  "ڈرپوکو": "ڈرپوک",
  "ڈرپوکوں": "ڈرپوک",
  "ڈرتے": "ڈرنا",
  "ڈرتا": "ڈرنا",
  "ڈرتی": "ڈرنا",
  "ڈرتیں": "ڈرنا",
  "ڈرو": "ڈرہ",
  "ڈروں": "ڈرہ",
  "ڈروا": "ڈرنا",
  "ڈروانے": "ڈرنا",
  "ڈروانا": "ڈرنا",
  "ڈرواتے": "ڈرنا",
  "ڈرواتا": "ڈرنا",
  "ڈرواتی": "ڈرنا",
  "ڈرواتیں": "ڈرنا",
  "ڈرواؤ": "ڈرنا",
  "ڈرواؤں": "ڈرنا",
  "ڈروائے": "ڈرنا",
  "ڈروائی": "ڈرنا",
  "ڈروائیے": "ڈرنا",
  "ڈروائیں": "ڈرنا",
  "ڈروایا": "ڈرنا",
  "ڈری": "ڈرنا",
  "ڈریے": "ڈرنا",
  "ڈریں": "ڈرنا",
  "ڈس": "ڈسنا",
  "ڈسے": "ڈسنا",
  "ڈسں": "ڈسنا",
  "ڈسا": "ڈسنا",
  "ڈسانے": "ڈسنا",
  "ڈسانا": "ڈسنا",
  "ڈساتے": "ڈسنا",
  "ڈساتا": "ڈسنا",
  "ڈساتی": "ڈسنا",
  "ڈساتیں": "ڈسنا",
  "ڈساؤ": "ڈسنا",
  "ڈساؤں": "ڈسنا",
  "ڈسائے": "ڈسنا",
  "ڈسائی": "ڈسنا",
  "ڈسائیے": "ڈسنا",
  "ڈسائیں": "ڈسنا",
  "ڈسایا": "ڈسنا",
  "ڈسنے": "ڈسنا",
  "ڈسنا": "ڈسنا",
  "ڈسنی": "ڈسنا",
  "ڈستے": "ڈسنا",
  "ڈستا": "ڈسنا",
  "ڈستی": "ڈسنا",
  "ڈستیں": "ڈسنا",
  "ڈسو": "ڈسنا",
  "ڈسوں": "ڈسنا",
  "ڈسوا": "ڈسنا",
  "ڈسوانے": "ڈسنا",
  "ڈسوانا": "ڈسنا",
  "ڈسواتے": "ڈسنا",
  "ڈسواتا": "ڈسنا",
  "ڈسواتی": "ڈسنا",
  "ڈسواتیں": "ڈسنا",
  "ڈسواؤ": "ڈسنا",
  "ڈسواؤں": "ڈسنا",
  "ڈسوائے": "ڈسنا",
  "ڈسوائی": "ڈسنا",
  "ڈسوائیے": "ڈسنا",
  "ڈسوائیں": "ڈسنا",
  "ڈسوایا": "ڈسنا",
  "ڈسی": "ڈسنا",
  "ڈسیے": "ڈسنا",
  "ڈسیں": "ڈسنا",
  "ڈوب": "ڈوبنا",
  "ڈوبے": "ڈوبنا",
  "ڈوبں": "ڈوبنا",
  "ڈوبا": "ڈوبنا",
  "ڈوبنے": "ڈوبنا",
  "ڈوبنا": "ڈوبنا",
  "ڈوبنی": "ڈوبنا",
  "ڈوبتے": "ڈوبنا",
  "ڈوبتا": "ڈوبنا",
  "ڈوبتی": "ڈوبنا",
  "ڈوبتیں": "ڈوبنا",
  "ڈوبو": "ڈوبنا",
  "ڈوبوں": "ڈوبنا",
  "ڈوبی": "ڈوبنا",
  "ڈوبیے": "ڈوبنا",
  "ڈوبیں": "ڈوبنا",
  "ڈور": "ڈور",
  "ڈورے": "ڈورا",
  "ڈورا": "ڈورا",
  "ڈورو": "ڈورا",
  "ڈوروں": "ڈورا",
  "ڈوری": "ڈوری",
  "ڈوریں": "ڈور",
  "ڈوریاں": "ڈوری",
  "ڈوریو": "ڈوری",
  "ڈوریوں": "ڈوری",
  "ڈیر": "ڈیر",
  "ڈیرے": "ڈیرا",
  "ڈیرا": "ڈیرا",
  "ڈیرہ": "ڈیرہ",
  "ڈیرو": "ڈیرا",
  "ڈیروں": "ڈیرا",
  "ڈیوڑھی": "ڈیوڑھی",
  "ڈیوڑھیاں": "ڈیوڑھی",
  "ڈیوڑھیو": "ڈیوڑھی",
  "ڈیوڑھیوں": "ڈیوڑھی",
  "ڈیوٹی": "ڈیوٹی",
  "ڈیوٹیاں": "ڈیوٹی",
  "ڈیوٹیو": "ڈیوٹی",
  "ڈیوٹیوں": "ڈیوٹی",
  "ڈھا": "ڈھانا",
  "ڈھال": "ڈھال",
  "ڈھالے": "ڈھالہ",
  "ڈھالں": "ڈھلنا",
  "ڈھالا": "ڈھلنا",
  "ڈھالہ": "ڈھالہ",
  "ڈھالنے": "ڈھلنا",
  "ڈھالنا": "ڈھلنا",
  "ڈھالتے": "ڈھلنا",
  "ڈھالتا": "ڈھلنا",
  "ڈھالتی": "ڈھلنا",
  "ڈھالتیں": "ڈھلنا",
  "ڈھالو": "ڈھالہ",
  "ڈھالوں": "ڈھالہ",
  "ڈھالی": "ڈھلنا",
  "ڈھالیے": "ڈھلنا",
  "ڈھالیں": "ڈھال",
  "ڈھانے": "ڈھانا",
  "ڈھانا": "ڈھانا",
  "ڈھانچے": "ڈھانچہ",
  "ڈھانچہ": "ڈھانچہ",
  "ڈھانچو": "ڈھانچہ",
  "ڈھانچوں": "ڈھانچہ",
  "ڈھانپ": "ڈھانپ",
  "ڈھانپے": "ڈھانپنا",
  "ڈھانپں": "ڈھانپنا",
  "ڈھانپا": "ڈھانپنا",
  "ڈھانپنے": "ڈھانپنا",
  "ڈھانپنا": "ڈھانپنا",
  "ڈھانپنی": "ڈھانپنا",
  "ڈھانپتے": "ڈھانپنا",
  "ڈھانپتا": "ڈھانپنا",
  "ڈھانپتی": "ڈھانپنا",
  "ڈھانپتیں": "ڈھانپنا",
  "ڈھانپو": "ڈھانپ",
  "ڈھانپوں": "ڈھانپ",
  "ڈھانپی": "ڈھانپنا",
  "ڈھانپیے": "ڈھانپنا",
  "ڈھانپیں": "ڈھانپنا",
  "ڈھانی": "ڈھانا",
  "ڈھاتے": "ڈھانا",
  "ڈھاتا": "ڈھانا",
  "ڈھاتی": "ڈھانا",
  "ڈھاتیں": "ڈھانا",
  "ڈھاؤ": "ڈھانا",
  "ڈھاؤں": "ڈھانا",
  "ڈھائے": "ڈھانا",
  "ڈھائی": "ڈھانا",
  "ڈھائیے": "ڈھانا",
  "ڈھائیں": "ڈھانا",
  "ڈھایا": "ڈھانا",
  "ڈھک": "ڈھکنا",
  "ڈھکے": "ڈھکنا",
  "ڈھکں": "ڈھکنا",
  "ڈھکا": "ڈھکا",
  "ڈھکانے": "ڈھکنا",
  "ڈھکانا": "ڈھکنا",
  "ڈھکاتے": "ڈھکنا",
  "ڈھکاتا": "ڈھکنا",
  "ڈھکاتی": "ڈھکنا",
  "ڈھکاتیں": "ڈھکنا",
  "ڈھکاؤ": "ڈھکنا",
  "ڈھکاؤں": "ڈھکنا",
  "ڈھکائے": "ڈھکنا",
  "ڈھکائی": "ڈھکنا",
  "ڈھکائیے": "ڈھکنا",
  "ڈھکائیں": "ڈھکنا",
  "ڈھکایا": "ڈھکنا",
  "ڈھکنے": "ڈھکنا",
  "ڈھکنا": "ڈھکنا",
  "ڈھکنی": "ڈھکنا",
  "ڈھکتے": "ڈھکنا",
  "ڈھکتا": "ڈھکنا",
  "ڈھکتی": "ڈھکنا",
  "ڈھکتیں": "ڈھکنا",
  "ڈھکو": "ڈھکنا",
  "ڈھکوں": "ڈھکنا",
  "ڈھکوا": "ڈھکنا",
  "ڈھکوانے": "ڈھکنا",
  "ڈھکوانا": "ڈھکنا",
  "ڈھکواتے": "ڈھکنا",
  "ڈھکواتا": "ڈھکنا",
  "ڈھکواتی": "ڈھکنا",
  "ڈھکواتیں": "ڈھکنا",
  "ڈھکواؤ": "ڈھکنا",
  "ڈھکواؤں": "ڈھکنا",
  "ڈھکوائے": "ڈھکنا",
  "ڈھکوائی": "ڈھکنا",
  "ڈھکوائیے": "ڈھکنا",
  "ڈھکوائیں": "ڈھکنا",
  "ڈھکوایا": "ڈھکنا",
  "ڈھکی": "ڈھکنا",
  "ڈھکیے": "ڈھکنا",
  "ڈھکیں": "ڈھکنا",
  "ڈھل": "ڈھلنا",
  "ڈھلے": "ڈھلنا",
  "ڈھلں": "ڈھلنا",
  "ڈھلا": "ڈھلنا",
  "ڈھلانے": "ڈھلنا",
  "ڈھلانا": "ڈھلنا",
  "ڈھلاتے": "ڈھلنا",
  "ڈھلاتا": "ڈھلنا",
  "ڈھلاتی": "ڈھلنا",
  "ڈھلاتیں": "ڈھلنا",
  "ڈھلاؤ": "ڈھلنا",
  "ڈھلاؤں": "ڈھلنا",
  "ڈھلائے": "ڈھلنا",
  "ڈھلائی": "ڈھلنا",
  "ڈھلائیے": "ڈھلنا",
  "ڈھلائیں": "ڈھلنا",
  "ڈھلایا": "ڈھلنا",
  "ڈھلنے": "ڈھلنا",
  "ڈھلنا": "ڈھلنا",
  "ڈھلنی": "ڈھلنا",
  "ڈھلتے": "ڈھلنا",
  "ڈھلتا": "ڈھلنا",
  "ڈھلتی": "ڈھلنا",
  "ڈھلتیں": "ڈھلنا",
  "ڈھلو": "ڈھلنا",
  "ڈھلوں": "ڈھلنا",
  "ڈھلی": "ڈھلنا",
  "ڈھلیے": "ڈھلنا",
  "ڈھلیں": "ڈھلنا",
  "ڈھر": "ڈھر",
  "ڈھرو": "ڈھر",
  "ڈھروں": "ڈھر",
  "ڈھول": "ڈھول",
  "ڈھولو": "ڈھول",
  "ڈھولوں": "ڈھول",
  "ڈھولیں": "ڈھول",
  "ڈھونڈ": "ڈھونڈنا",
  "ڈھونڈے": "ڈھونڈنا",
  "ڈھونڈں": "ڈھونڈنا",
  "ڈھونڈا": "ڈھونڈنا",
  "ڈھونڈانے": "ڈھونڈنا",
  "ڈھونڈانا": "ڈھونڈنا",
  "ڈھونڈاتے": "ڈھونڈنا",
  "ڈھونڈاتا": "ڈھونڈنا",
  "ڈھونڈاتی": "ڈھونڈنا",
  "ڈھونڈاتیں": "ڈھونڈنا",
  "ڈھونڈاؤ": "ڈھونڈنا",
  "ڈھونڈاؤں": "ڈھونڈنا",
  "ڈھونڈائے": "ڈھونڈنا",
  "ڈھونڈائی": "ڈھونڈنا",
  "ڈھونڈائیے": "ڈھونڈنا",
  "ڈھونڈائیں": "ڈھونڈنا",
  "ڈھونڈایا": "ڈھونڈنا",
  "ڈھونڈنے": "ڈھونڈنا",
  "ڈھونڈنا": "ڈھونڈنا",
  "ڈھونڈنی": "ڈھونڈنا",
  "ڈھونڈتے": "ڈھونڈنا",
  "ڈھونڈتا": "ڈھونڈنا",
  "ڈھونڈتی": "ڈھونڈنا",
  "ڈھونڈتیں": "ڈھونڈنا",
  "ڈھونڈو": "ڈھونڈنا",
  "ڈھونڈوں": "ڈھونڈنا",
  "ڈھونڈوا": "ڈھونڈنا",
  "ڈھونڈوانے": "ڈھونڈنا",
  "ڈھونڈوانا": "ڈھونڈنا",
  "ڈھونڈواتے": "ڈھونڈنا",
  "ڈھونڈواتا": "ڈھونڈنا",
  "ڈھونڈواتی": "ڈھونڈنا",
  "ڈھونڈواتیں": "ڈھونڈنا",
  "ڈھونڈواؤ": "ڈھونڈنا",
  "ڈھونڈواؤں": "ڈھونڈنا",
  "ڈھونڈوائے": "ڈھونڈنا",
  "ڈھونڈوائی": "ڈھونڈنا",
  "ڈھونڈوائیے": "ڈھونڈنا",
  "ڈھونڈوائیں": "ڈھونڈنا",
  "ڈھونڈوایا": "ڈھونڈنا",
  "ڈھونڈی": "ڈھونڈنا",
  "ڈھونڈیے": "ڈھونڈنا",
  "ڈھونڈیں": "ڈھونڈنا",
  "ڈھیل": "ڈھیل",
  "ڈھیلے": "ڈھیلا",
  "ڈھیلا": "ڈھیلا",
  "ڈھیلو": "ڈھیلا",
  "ڈھیلوں": "ڈھیلا",
  "ڈھیلیں": "ڈھیل",
  "ڈھیر": "ڈھیر",
  "ڈھیرے": "ڈھیرا",
  "ڈھیرا": "ڈھیرا",
  "ڈھیرو": "ڈھیرا",
  "ڈھیروں": "ڈھیرا",
  "ڈھیری": "ڈھیری",
  "ڈھیریاں": "ڈھیری",
  "ڈھیریو": "ڈھیری",
  "ڈھیریوں": "ڈھیری",
  "غُصے": "غُصہ",
  "غُصہ": "غُصہ",
  "غُصو": "غُصہ",
  "غُصوں": "غُصہ",
  "غصّے": "غصّہ",
  "غصّہ": "غصّہ",
  "غصّو": "غصّہ",
  "غصّوں": "غصّہ",
  "غصے": "غصہ",
  "غصہ": "غصہ",
  "غصو": "غصہ",
  "غصوں": "غصہ",
  "غذا": "غذا",
  "غذاؤ": "غذا",
  "غذاؤں": "غذا",
  "غذائیں": "غذا",
  "غافل": "غافل",
  "غافلو": "غافل",
  "غافلوں": "غافل",
  "غار": "غار",
  "غارو": "غار",
  "غاروں": "غار",
  "غاریں": "غار",
  "غازے": "غازہ",
  "غازہ": "غازہ",
  "غازو": "غازہ",
  "غازوں": "غازہ",
  "غازی": "غازی",
  "غازیو": "غازی",
  "غازیوں": "غازی",
  "غبارے": "غبارہ",
  "غبارہ": "غبارہ",
  "غبارو": "غبارہ",
  "غباروں": "غبارہ",
  "غلے": "غلہ",
  "غلاف": "غلاف",
  "غلافو": "غلاف",
  "غلافوں": "غلاف",
  "غلام": "غلام",
  "غلامو": "غلام",
  "غلاموں": "غلام",
  "غلاظت": "غلاظت",
  "غلاظتو": "غلاظت",
  "غلاظتوں": "غلاظت",
  "غلاظتیں": "غلاظت",
  "غلبے": "غلبہ",
  "غلبہ": "غلبہ",
  "غلبو": "غلبہ",
  "غلبوں": "غلبہ",
  "غلہ": "غلہ",
  "غلو": "غلہ",
  "غلوں": "غلہ",
  "غلطی": "غلطی",
  "غلطیاں": "غلطی",
  "غلطیو": "غلطی",
  "غلطیوں": "غلطی",
  "غم": "غم",
  "غمو": "غم",
  "غموں": "غم",
  "غمزے": "غمزہ",
  "غمزدے": "غمزدہ",
  "غمزدہ": "غمزدہ",
  "غمزدو": "غمزدہ",
  "غمزدوں": "غمزدہ",
  "غمزہ": "غمزہ",
  "غمزو": "غمزہ",
  "غمزوں": "غمزہ",
  "غنڈے": "غنڈا",
  "غنڈا": "غنڈا",
  "غنڈہ": "غنڈہ",
  "غنڈو": "غنڈا",
  "غنڈوں": "غنڈا",
  "غنچے": "غنچہ",
  "غنچہ": "غنچہ",
  "غنچو": "غنچہ",
  "غنچوں": "غنچہ",
  "غنیمت": "غنیمت",
  "غنیمتو": "غنیمت",
  "غنیمتوں": "غنیمت",
  "غنیمتیں": "غنیمت",
  "غرّا": "غرّانا",
  "غرّانے": "غرّانا",
  "غرّانا": "غرّانا",
  "غرّانی": "غرّانا",
  "غرّاتے": "غرّانا",
  "غرّاتا": "غرّانا",
  "غرّاتی": "غرّانا",
  "غرّاتیں": "غرّانا",
  "غرّاؤ": "غرّانا",
  "غرّاؤں": "غرّانا",
  "غرّائے": "غرّانا",
  "غرّائی": "غرّانا",
  "غرّائیے": "غرّانا",
  "غرّائیں": "غرّانا",
  "غرّایا": "غرّانا",
  "غرارے": "غرارہ",
  "غرارہ": "غرارہ",
  "غرارو": "غرارہ",
  "غراروں": "غرارہ",
  "غرب": "غرب",
  "غربو": "غرب",
  "غربوں": "غرب",
  "غریب": "غریب",
  "غریبو": "غریب",
  "غریبوں": "غریب",
  "غسلخانے": "غسلخانہ",
  "غسلخانہ": "غسلخانہ",
  "غسلخانو": "غسلخانہ",
  "غسلخانوں": "غسلخانہ",
  "غور": "غور",
  "غورو": "غور",
  "غوروں": "غور",
  "غوطے": "غوطہ",
  "غوطہ": "غوطہ",
  "غوطو": "غوطہ",
  "غوطوں": "غوطہ",
  "غیب": "غیب",
  "غیبو": "غیب",
  "غیبوں": "غیب",
  "غیر": "غیر",
  "غیرے": "غیرہ",
  "غیرہ": "غیرہ",
  "غیرملکی": "غیرملکی",
  "غیرملکیو": "غیرملکی",
  "غیرملکیوں": "غیرملکی",
  "غیرت": "غیرت",
  "غیرتو": "غیرت",
  "غیرتوں": "غیرت",
  "غیرتیں": "غیرت",
  "غیرو": "غیرہ",
  "غیروں": "غیرہ",
  "غزال": "غزال",
  "غزالے": "غزالہ",
  "غزالہ": "غزالہ",
  "غزالو": "غزالہ",
  "غزالوں": "غزالہ",
  "غزل": "غزل",
  "غزلو": "غزل",
  "غزلوں": "غزل",
  "غزلیں": "غزل",
  "حَیا": "حَیا",
  "حَیاؤں": "حَیا",
  "حَیائیں": "حَیا",
  "حِصّے": "حِصّہ",
  "حِصّہ": "حِصّہ",
  "حِصّو": "حِصّہ",
  "حِصّوں": "حِصّہ",
  "حصّے": "حصّہ",
  "حصّہ": "حصّہ",
  "حصّو": "حصّہ",
  "حصّوں": "حصّہ",
  "حصے": "حصہ",
  "حصار": "حصار",
  "حصارو": "حصار",
  "حصاروں": "حصار",
  "حصاریں": "حصار",
  "حصہ": "حصہ",
  "حصو": "حصہ",
  "حصوں": "حصہ",
  "حاشیے": "حاشیہ",
  "حاشیہ": "حاشیہ",
  "حاشیو": "حاشیہ",
  "حاشیوں": "حاشیہ",
  "حادثے": "حادثہ",
  "حادثہ": "حادثہ",
  "حادثو": "حادثہ",
  "حادثوں": "حادثہ",
  "حافظے": "حافظہ",
  "حافظہ": "حافظہ",
  "حافظو": "حافظہ",
  "حافظوں": "حافظہ",
  "حاجی": "حاجی",
  "حاجیو": "حاجی",
  "حاجیوں": "حاجی",
  "حاکم": "حاکم",
  "حاکمو": "حاکم",
  "حاکموں": "حاکم",
  "حال": "حال",
  "حالے": "حالا",
  "حالا": "حالا",
  "حالانکہ": "حالانکہ",
  "حالت": "حالت",
  "حالتو": "حالت",
  "حالتوں": "حالت",
  "حالتیں": "حالت",
  "حالو": "حالا",
  "حالوں": "حالا",
  "حامی": "حامی",
  "حامیو": "حامی",
  "حامیوں": "حامی",
  "حاسد": "حاسد",
  "حاسدو": "حاسد",
  "حاسدوں": "حاسد",
  "حد": "حد",
  "حدو": "حد",
  "حدوں": "حد",
  "حدیث": "حدیث",
  "حدیثو": "حدیث",
  "حدیثوں": "حدیث",
  "حدیثیں": "حدیث",
  "حدیں": "حد",
  "حجر": "حجر",
  "حجرے": "حجرہ",
  "حجرہ": "حجرہ",
  "حجرو": "حجرہ",
  "حجروں": "حجرہ",
  "حکایت": "حکایت",
  "حکایتو": "حکایت",
  "حکایتوں": "حکایت",
  "حکایتیں": "حکایت",
  "حکم": "حکم",
  "حکمران": "حکمران",
  "حکمرانو": "حکمران",
  "حکمرانوں": "حکمران",
  "حکمت": "حکمت",
  "حکمتو": "حکمت",
  "حکمتوں": "حکمت",
  "حکمتیں": "حکمت",
  "حکمو": "حکم",
  "حکموں": "حکم",
  "حکومت": "حکومت",
  "حکومتو": "حکومت",
  "حکومتوں": "حکومت",
  "حکومتیں": "حکومت",
  "حکیم": "حکیم",
  "حکیمو": "حکیم",
  "حکیموں": "حکیم",
  "حلے": "حلہ",
  "حلاوت": "حلاوت",
  "حلاوتو": "حلاوت",
  "حلاوتوں": "حلاوت",
  "حلاوتیں": "حلاوت",
  "حلہ": "حلہ",
  "حلق": "حلق",
  "حلقے": "حلقہ",
  "حلقہ": "حلقہ",
  "حلقو": "حلقہ",
  "حلقوں": "حلقہ",
  "حلو": "حلہ",
  "حلوے": "حلوہ",
  "حلوں": "حلہ",
  "حلوائی": "حلوائی",
  "حلوائیو": "حلوائی",
  "حلوائیوں": "حلوائی",
  "حلوہ": "حلوہ",
  "حلوو": "حلوہ",
  "حلووں": "حلوہ",
  "حلیے": "حلیہ",
  "حلیہ": "حلیہ",
  "حلیو": "حلیہ",
  "حلیوں": "حلیہ",
  "حمام": "حمام",
  "حمامو": "حمام",
  "حماموں": "حمام",
  "حماقت": "حماقت",
  "حماقتو": "حماقت",
  "حماقتوں": "حماقت",
  "حماقتیں": "حماقت",
  "حمائتی": "حمائتی",
  "حمائتیو": "حمائتی",
  "حمائتیوں": "حمائتی",
  "حمل": "حمل",
  "حملے": "حملہ",
  "حملہ": "حملہ",
  "حملو": "حملہ",
  "حملوں": "حملہ",
  "حنفی": "حنفی",
  "حنفیو": "حنفی",
  "حنفیوں": "حنفی",
  "حقّے": "حقّہ",
  "حقّہ": "حقّہ",
  "حقّو": "حقّہ",
  "حقّوں": "حقّہ",
  "حقے": "حقہ",
  "حقہ": "حقہ",
  "حقو": "حقہ",
  "حقوں": "حقہ",
  "حقیقت": "حقیقت",
  "حقیقتو": "حقیقت",
  "حقیقتوں": "حقیقت",
  "حقیقتیں": "حقیقت",
  "حرامی": "حرامی",
  "حرامیو": "حرامی",
  "حرامیوں": "حرامی",
  "حرامزادے": "حرامزادہ",
  "حرامزادہ": "حرامزادہ",
  "حرامزادو": "حرامزادہ",
  "حرامزادوں": "حرامزادہ",
  "حرب": "حرب",
  "حربے": "حربہ",
  "حربہ": "حربہ",
  "حربو": "حربہ",
  "حربوں": "حربہ",
  "حرف": "حرف",
  "حرفو": "حرف",
  "حرفوں": "حرف",
  "حرفی": "حرفی",
  "حرفیں": "حرف",
  "حرفیاں": "حرفی",
  "حرفیو": "حرفی",
  "حرفیوں": "حرفی",
  "حرکت": "حرکت",
  "حرکتو": "حرکت",
  "حرکتوں": "حرکت",
  "حرکتیں": "حرکت",
  "حرمزدگی": "حرمزدگی",
  "حرمزدگیاں": "حرمزدگی",
  "حرمزدگیو": "حرمزدگی",
  "حرمزدگیوں": "حرمزدگی",
  "حریف": "حریف",
  "حریفو": "حریف",
  "حریفوں": "حریف",
  "حساب": "حساب",
  "حسابو": "حساب",
  "حسابوں": "حساب",
  "حسن": "حسن",
  "حسنو": "حسن",
  "حسنوں": "حسن",
  "حسین": "حسین",
  "حسینے": "حسینہ",
  "حسینہ": "حسینہ",
  "حسینو": "حسینہ",
  "حسینوں": "حسینہ",
  "حوصل": "حوصل",
  "حوصلے": "حوصلہ",
  "حوصلہ": "حوصلہ",
  "حوصلو": "حوصلہ",
  "حوصلوں": "حوصلہ",
  "حوال": "حوال",
  "حوالے": "حوالہ",
  "حوالدار": "حوالدار",
  "حوالدارو": "حوالدار",
  "حوالداروں": "حوالدار",
  "حوالہ": "حوالہ",
  "حوالو": "حوالہ",
  "حوالوں": "حوالہ",
  "حوار": "حوار",
  "حوارو": "حوار",
  "حواروں": "حوار",
  "حواری": "حواری",
  "حواریو": "حواری",
  "حواریوں": "حواری",
  "حواس": "حواس",
  "حواسو": "حواس",
  "حواسوں": "حواس",
  "حور": "حور",
  "حورو": "حور",
  "حوروں": "حور",
  "حوریں": "حور",
  "حویلی": "حویلی",
  "حویلیاں": "حویلی",
  "حویلیو": "حویلی",
  "حویلیوں": "حویلی",
  "حیلے": "حیلہ",
  "حیلہ": "حیلہ",
  "حیلو": "حیلہ",
  "حیلوں": "حیلہ",
  "حیرت": "حیرت",
  "حیرتو": "حیرت",
  "حیرتوں": "حیرت",
  "حیرتیں": "حیرت",
  "حیوان": "حیوان",
  "حیوانات": "حیوان",
  "حیوانو": "حیوان",
  "حیوانوں": "حیوان",
  "خَراب": "خَراب",
  "خُدا": "خُدا",
  "خُداو": "خُدا",
  "خُداوں": "خُدا",
  "خُوے": "خُوش",
  "خُوش": "خُوش",
  "خُوب": "خُوب",
  "خُوی": "خُوش",
  "خصلت": "خصلت",
  "خصلتو": "خصلت",
  "خصلتوں": "خصلت",
  "خصلتیں": "خصلت",
  "خشبو": "خشبو",
  "خشبوؤ": "خشبو",
  "خشبوؤں": "خشبو",
  "خشبوئیں": "خشبو",
  "خشکے": "خشکہ",
  "خشکہ": "خشکہ",
  "خشکو": "خشکہ",
  "خشکوں": "خشکہ",
  "خاصے": "خاصہ",
  "خاصہ": "خاصہ",
  "خاصو": "خاصہ",
  "خاصوں": "خاصہ",
  "خاصیت": "خاصیت",
  "خاصیتو": "خاصیت",
  "خاصیتوں": "خاصیت",
  "خاصیتیں": "خاصیت",
  "خادم": "خادم",
  "خادمے": "خادمہ",
  "خادمہ": "خادمہ",
  "خادمو": "خادمہ",
  "خادموں": "خادمہ",
  "خاک": "خاک",
  "خاکے": "خاکہ",
  "خاکہ": "خاکہ",
  "خاکروب": "خاکروب",
  "خاکروبو": "خاکروب",
  "خاکروبوں": "خاکروب",
  "خاکستر": "خاکستر",
  "خاکسترو": "خاکستر",
  "خاکستروں": "خاکستر",
  "خاکو": "خاکہ",
  "خاکوں": "خاکہ",
  "خاکی": "خاکی",
  "خاکیاں": "خاکی",
  "خاکیو": "خاکی",
  "خاکیوں": "خاکی",
  "خالُو": "خالُو",
  "خالُوؤ": "خالُو",
  "خالُوؤں": "خالُو",
  "خالے": "خالہ",
  "خالہ": "خالہ",
  "خالو": "خالہ",
  "خالوں": "خالہ",
  "خام": "خام",
  "خامے": "خامہ",
  "خامہ": "خامہ",
  "خامو": "خامہ",
  "خاموں": "خامہ",
  "خاموشی": "خاموشی",
  "خاموشیاں": "خاموشی",
  "خاموشیو": "خاموشی",
  "خاموشیوں": "خاموشی",
  "خامی": "خامی",
  "خامیاں": "خامی",
  "خامیو": "خامی",
  "خامیوں": "خامی",
  "خان": "خان",
  "خانے": "خانہ",
  "خاندان": "خاندان",
  "خاندانو": "خاندان",
  "خاندانوں": "خاندان",
  "خانہ": "خانہ",
  "خانقاہ": "خانقاہ",
  "خانقاہو": "خانقاہ",
  "خانقاہوں": "خانقاہ",
  "خانقاہیں": "خانقاہ",
  "خانساماں": "خانساماں",
  "خانساماؤ": "خانساماں",
  "خانساماؤں": "خانساماں",
  "خانسامائیں": "خانساماں",
  "خانو": "خانہ",
  "خانوں": "خانہ",
  "خانوادے": "خانوادہ",
  "خانوادہ": "خانوادہ",
  "خانوادو": "خانوادہ",
  "خانوادوں": "خانوادہ",
  "خارجی": "خارجی",
  "خارجیو": "خارجی",
  "خارجیوں": "خارجی",
  "خاتمے": "خاتمہ",
  "خاتمہ": "خاتمہ",
  "خاتمو": "خاتمہ",
  "خاتموں": "خاتمہ",
  "خاوند": "خاوند",
  "خاوندو": "خاوند",
  "خاوندوں": "خاوند",
  "خاطر": "خاطر",
  "خاطرو": "خاطر",
  "خاطروں": "خاطر",
  "خاطریں": "خاطر",
  "خبر": "خبر",
  "خبرو": "خبر",
  "خبروں": "خبر",
  "خبریں": "خبر",
  "خچر": "خچر",
  "خچرو": "خچر",
  "خچروں": "خچر",
  "خدشے": "خدشہ",
  "خدشہ": "خدشہ",
  "خدشو": "خدشہ",
  "خدشوں": "خدشہ",
  "خدا": "خدا",
  "خداؤ": "خدا",
  "خداؤں": "خدا",
  "خدمت": "خدمت",
  "خدمتو": "خدمت",
  "خدمتوں": "خدمت",
  "خدمتیں": "خدمت",
  "خلا": "خلا",
  "خلاؤ": "خلا",
  "خلاؤں": "خلا",
  "خلائیں": "خلا",
  "خلیفے": "خلیفہ",
  "خلیفہ": "خلیفہ",
  "خلیفو": "خلیفہ",
  "خلیفوں": "خلیفہ",
  "خندق": "خندق",
  "خندقو": "خندق",
  "خندقوں": "خندق",
  "خندقیں": "خندق",
  "خنکی": "خنکی",
  "خنکیاں": "خنکی",
  "خنکیو": "خنکی",
  "خنکیوں": "خنکی",
  "خنزیر": "خنزیر",
  "خنزیرو": "خنزیر",
  "خنزیروں": "خنزیر",
  "خراش": "خراش",
  "خراشو": "خراش",
  "خراشوں": "خراش",
  "خراشیں": "خراش",
  "خرابے": "خرابہ",
  "خرابہ": "خرابہ",
  "خرابو": "خرابہ",
  "خرابوں": "خرابہ",
  "خرابی": "خرابی",
  "خرابیاں": "خرابی",
  "خرابیو": "خرابی",
  "خرابیوں": "خرابی",
  "خربوزے": "خربوزہ",
  "خربوزہ": "خربوزہ",
  "خربوزو": "خربوزہ",
  "خربوزوں": "خربوزہ",
  "خرچے": "خرچہ",
  "خرچہ": "خرچہ",
  "خرچو": "خرچہ",
  "خرچوں": "خرچہ",
  "خرچی": "خرچی",
  "خرچیاں": "خرچی",
  "خرچیو": "خرچی",
  "خرچیوں": "خرچی",
  "خرید": "خریدنا",
  "خریدے": "خریدا",
  "خریدں": "خریدنا",
  "خریدا": "خریدا",
  "خریدار": "خریدار",
  "خریدارو": "خریدار",
  "خریداروں": "خریدار",
  "خریدہ": "خریدہ",
  "خریدنے": "خریدنا",
  "خریدنا": "خریدنا",
  "خریدنی": "خریدنا",
  "خریدتے": "خریدنا",
  "خریدتا": "خریدنا",
  "خریدتی": "خریدنا",
  "خریدتیں": "خریدنا",
  "خریدو": "خریدا",
  "خریدوں": "خریدا",
  "خریدی": "خریدنا",
  "خریدیے": "خریدنا",
  "خریدیں": "خریدنا",
  "خسارے": "خسارہ",
  "خسارہ": "خسارہ",
  "خسارو": "خسارہ",
  "خساروں": "خسارہ",
  "خسر": "خسر",
  "خسرے": "خسرہ",
  "خسرہ": "خسرہ",
  "خسرو": "خسرہ",
  "خسروں": "خسرہ",
  "ختن": "ختن",
  "ختنے": "ختنہ",
  "ختنہ": "ختنہ",
  "ختنو": "ختنہ",
  "ختنوں": "ختنہ",
  "خوشْبُو": "خوشْبُو",
  "خوشْبُوؤ": "خوشْبُو",
  "خوشْبُوؤں": "خوشْبُو",
  "خوشْبُوئیں": "خوشْبُو",
  "خوشے": "خوشا",
  "خوشا": "خوشا",
  "خوشامد": "خوشامد",
  "خوشامدو": "خوشامد",
  "خوشامدوں": "خوشامد",
  "خوشامدیں": "خوشامد",
  "خوشبو": "خوشبو",
  "خوشبوؤ": "خوشبو",
  "خوشبوؤں": "خوشبو",
  "خوشبوئیں": "خوشبو",
  "خوشہ": "خوشہ",
  "خوشو": "خوشا",
  "خوشوں": "خوشا",
  "خوشی": "خوشی",
  "خوشیاں": "خوشی",
  "خوشیو": "خوشی",
  "خوشیوں": "خوشی",
  "خواب": "خواب",
  "خوابو": "خواب",
  "خوابوں": "خواب",
  "خواہش": "خواہش",
  "خواہشو": "خواہش",
  "خواہشوں": "خواہش",
  "خواہشیں": "خواہش",
  "خوان": "خوان",
  "خوانچے": "خوانچہ",
  "خوانچہ": "خوانچہ",
  "خوانچو": "خوانچہ",
  "خوانچوں": "خوانچہ",
  "خوانو": "خوان",
  "خوانوں": "خوان",
  "خوار": "خوار",
  "خوارو": "خوار",
  "خواروں": "خوار",
  "خوبصورت": "خوبصورت",
  "خوبصورتو": "خوبصورت",
  "خوبصورتوں": "خوبصورت",
  "خوبصورتی": "خوبصورتی",
  "خوبصورتیاں": "خوبصورتی",
  "خوبصورتیو": "خوبصورتی",
  "خوبصورتیوں": "خوبصورتی",
  "خوبی": "خوبی",
  "خوبیاں": "خوبی",
  "خوبیو": "خوبی",
  "خوبیوں": "خوبی",
  "خود": "خود",
  "خودبَخُود": "خودبَخُود",
  "خودبخود": "خودبَخُود",
  "خون": "خون",
  "خورے": "خورہ",
  "خوراک": "خوراک",
  "خوراکو": "خوراک",
  "خوراکوں": "خوراک",
  "خوراکیں": "خوراک",
  "خورہ": "خورہ",
  "خورو": "خورہ",
  "خوروں": "خورہ",
  "خیال": "خیال",
  "خیالو": "خیال",
  "خیالوں": "خیال",
  "خیانت": "خیانت",
  "خیانتو": "خیانت",
  "خیانتوں": "خیانت",
  "خیانتیں": "خیانت",
  "خیمے": "خیمہ",
  "خیمہ": "خیمہ",
  "خیمو": "خیمہ",
  "خیموں": "خیمہ",
  "خیر": "خیر",
  "خیرو": "خیر",
  "خیروں": "خیر",
  "خیریں": "خیر",
  "خزانے": "خزانہ",
  "خزانہ": "خزانہ",
  "خزانو": "خزانہ",
  "خزانوں": "خزانہ",
  "خزینے": "خزینہ",
  "خزینہ": "خزینہ",
  "خزینو": "خزینہ",
  "خزینوں": "خزینہ",
  "خط": "خط",
  "خطے": "خطہ",
  "خطا": "خطا",
  "خطاکار": "خطاکار",
  "خطاکارو": "خطاکار",
  "خطاکاروں": "خطاکار",
  "خطاؤ": "خطا",
  "خطاؤں": "خطا",
  "خطائیں": "خطا",
  "خطبے": "خطبہ",
  "خطبہ": "خطبہ",
  "خطبو": "خطبہ",
  "خطبوں": "خطبہ",
  "خطہ": "خطہ",
  "خطرے": "خطرہ",
  "خطرہ": "خطرہ",
  "خطرو": "خطرہ",
  "خطروں": "خطرہ",
  "خطو": "خطہ",
  "خطوں": "خطہ",
  "خطیں": "خط",
  "صَدا": "صَدا",
  "صَداؤ": "صَدا",
  "صَداؤں": "صَدا",
  "صَدائیں": "صَدا",
  "صُراحی": "صُراحی",
  "صُراحیاں": "صُراحی",
  "صُراحیو": "صُراحی",
  "صُراحیوں": "صُراحی",
  "صُورت": "صُورت",
  "صُورتو": "صُورت",
  "صُورتوں": "صُورت",
  "صُورتیں": "صُورت",
  "صحافی": "صحافی",
  "صحافیو": "صحافی",
  "صحافیوں": "صحافی",
  "صحبت": "صحبت",
  "صحبتو": "صحبت",
  "صحبتوں": "صحبت",
  "صحبتیں": "صحبت",
  "صحرا": "صحرا",
  "صحراؤ": "صحرا",
  "صحراؤں": "صحرا",
  "صحیفے": "صحیفہ",
  "صحیفہ": "صحیفہ",
  "صحیفو": "صحیفہ",
  "صحیفوں": "صحیفہ",
  "صاحب": "صاحب",
  "صاحبو": "صاحب",
  "صاحبوں": "صاحب",
  "صاحبزادے": "صاحبزادہ",
  "صاحبزادہ": "صاحبزادہ",
  "صاحبزادو": "صاحبزادہ",
  "صاحبزادوں": "صاحبزادہ",
  "صاحبزادی": "صاحبزادی",
  "صاحبزادیاں": "صاحبزادی",
  "صاحبزادیو": "صاحبزادی",
  "صاحبزادیوں": "صاحبزادی",
  "صابر": "صابر",
  "صابرو": "صابر",
  "صابروں": "صابر",
  "صافے": "صافہ",
  "صافہ": "صافہ",
  "صافو": "صافہ",
  "صافوں": "صافہ",
  "صبح": "صبح",
  "صبحو": "صبح",
  "صبحوں": "صبح",
  "صبحیں": "صبح",
  "صبر": "صبر",
  "صبرو": "صبر",
  "صبروں": "صبر",
  "صدا": "صدا",
  "صداقت": "صداقت",
  "صداقتو": "صداقت",
  "صداقتوں": "صداقت",
  "صداقتیں": "صداقت",
  "صدارت": "صدارت",
  "صدارتو": "صدارت",
  "صدارتوں": "صدارت",
  "صدارتیں": "صدارت",
  "صداؤ": "صدا",
  "صداؤں": "صدا",
  "صدائیں": "صدا",
  "صدمے": "صدمہ",
  "صدمہ": "صدمہ",
  "صدمو": "صدمہ",
  "صدموں": "صدمہ",
  "صدقے": "صدقہ",
  "صدقہ": "صدقہ",
  "صدقو": "صدقہ",
  "صدقوں": "صدقہ",
  "صدی": "صدی",
  "صدیاں": "صدی",
  "صدیو": "صدی",
  "صدیوں": "صدی",
  "صعوبت": "صعوبت",
  "صعوبتو": "صعوبت",
  "صعوبتوں": "صعوبت",
  "صعوبتیں": "صعوبت",
  "صف": "صف",
  "صفے": "صفہ",
  "صفحے": "صفحہ",
  "صفحہ": "صفحہ",
  "صفحو": "صفحہ",
  "صفحوں": "صفحہ",
  "صفائی": "صفائی",
  "صفائیاں": "صفائی",
  "صفائیو": "صفائی",
  "صفائیوں": "صفائی",
  "صفہ": "صفہ",
  "صفت": "صفت",
  "صفتو": "صفت",
  "صفتوں": "صفت",
  "صفتیں": "صفت",
  "صفو": "صفہ",
  "صفوں": "صفہ",
  "صفیں": "صف",
  "صلے": "صلہ",
  "صلاحیت": "صلاحیت",
  "صلاحیتو": "صلاحیت",
  "صلاحیتوں": "صلاحیت",
  "صلاحیتیں": "صلاحیت",
  "صلہ": "صلہ",
  "صلو": "صلہ",
  "صلوں": "صلہ",
  "صلیب": "صلیب",
  "صلیبو": "صلیب",
  "صلیبوں": "صلیب",
  "صلیبی": "صلیبی",
  "صلیبیں": "صلیب",
  "صلیبیو": "صلیبی",
  "صلیبیوں": "صلیبی",
  "صندوق": "صندوق",
  "صندوقو": "صندوق",
  "صندوقوں": "صندوق",
  "صندوقیں": "صندوق",
  "صنعت": "صنعت",
  "صنعتو": "صنعت",
  "صنعتوں": "صنعت",
  "صنعتیں": "صنعت",
  "صراحی": "صراحی",
  "صراحیاں": "صراحی",
  "صراحیو": "صراحی",
  "صراحیوں": "صراحی",
  "صوبے": "صوبہ",
  "صوبہ": "صوبہ",
  "صوبو": "صوبہ",
  "صوبوں": "صوبہ",
  "صوفے": "صوفہ",
  "صوفہ": "صوفہ",
  "صوفو": "صوفہ",
  "صوفوں": "صوفہ",
  "صوفی": "صوفی",
  "صوفیاں": "صوفی",
  "صوفیو": "صوفی",
  "صوفیوں": "صوفی",
  "صورت": "صورت",
  "صورتو": "صورت",
  "صورتوں": "صورت",
  "صورتی": "صورتی",
  "صورتیں": "صورت",
  "صورتیاں": "صورتی",
  "صورتیو": "صورتی",
  "صورتیوں": "صورتی",
  "صیغے": "صیغہ",
  "صیغہ": "صیغہ",
  "صیغو": "صیغہ",
  "صیغوں": "صیغہ",
  "ٹُوٹ": "ٹُوٹْنا",
  "ٹُوٹْں": "ٹُوٹْنا",
  "ٹُوٹْنے": "ٹُوٹْنا",
  "ٹُوٹْنا": "ٹُوٹْنا",
  "ٹُوٹْنی": "ٹُوٹْنا",
  "ٹُوٹْتے": "ٹُوٹْنا",
  "ٹُوٹْتا": "ٹُوٹْنا",
  "ٹُوٹْتی": "ٹُوٹْنا",
  "ٹُوٹْتیں": "ٹُوٹْنا",
  "ٹُوٹے": "ٹُوٹْنا",
  "ٹُوٹا": "ٹُوٹْنا",
  "ٹُوٹو": "ٹُوٹْنا",
  "ٹُوٹوں": "ٹُوٹْنا",
  "ٹُوٹی": "ٹُوٹْنا",
  "ٹُوٹیے": "ٹُوٹْنا",
  "ٹُوٹیں": "ٹُوٹْنا",
  "ٹٹول": "ٹٹولنا",
  "ٹٹولے": "ٹٹولنا",
  "ٹٹولں": "ٹٹولنا",
  "ٹٹولا": "ٹٹولنا",
  "ٹٹولنے": "ٹٹولنا",
  "ٹٹولنا": "ٹٹولنا",
  "ٹٹولنی": "ٹٹولنا",
  "ٹٹولتے": "ٹٹولنا",
  "ٹٹولتا": "ٹٹولنا",
  "ٹٹولتی": "ٹٹولنا",
  "ٹٹولتیں": "ٹٹولنا",
  "ٹٹولو": "ٹٹولنا",
  "ٹٹولوں": "ٹٹولنا",
  "ٹٹولی": "ٹٹولنا",
  "ٹٹولیے": "ٹٹولنا",
  "ٹٹولیں": "ٹٹولنا",
  "ٹٹی": "ٹٹی",
  "ٹٹیاں": "ٹٹی",
  "ٹٹیو": "ٹٹی",
  "ٹٹیوں": "ٹٹی",
  "ٹاکی": "ٹاکی",
  "ٹاکیاں": "ٹاکی",
  "ٹاکیو": "ٹاکی",
  "ٹاکیوں": "ٹاکی",
  "ٹال": "ٹال",
  "ٹالو": "ٹال",
  "ٹالوں": "ٹال",
  "ٹالیں": "ٹال",
  "ٹانگ": "ٹانگ",
  "ٹانگے": "ٹانگا",
  "ٹانگ`": "ٹانگ`",
  "ٹانگ`و": "ٹانگ`",
  "ٹانگ`وں": "ٹانگ`",
  "ٹانگ`یں": "ٹانگ`",
  "ٹانگا": "ٹانگا",
  "ٹانگہ": "ٹانگہ",
  "ٹانگو": "ٹانگا",
  "ٹانگوں": "ٹانگا",
  "ٹانگیں": "ٹانگ",
  "ٹانکے": "ٹانکا",
  "ٹانکا": "ٹانکا",
  "ٹانکو": "ٹانکا",
  "ٹانکوں": "ٹانکا",
  "ٹاپ": "ٹاپ",
  "ٹاپو": "ٹاپ",
  "ٹاپوں": "ٹاپ",
  "ٹاپیں": "ٹاپ",
  "ٹائل": "ٹائل",
  "ٹائلو": "ٹائل",
  "ٹائلوں": "ٹائل",
  "ٹائلیں": "ٹائل",
  "ٹائر": "ٹائر",
  "ٹائرو": "ٹائر",
  "ٹائروں": "ٹائر",
  "ٹائریں": "ٹائر",
  "ٹہل": "ٹہلنا",
  "ٹہلے": "ٹہلنا",
  "ٹہلں": "ٹہلنا",
  "ٹہلا": "ٹہلنا",
  "ٹہلانے": "ٹہلنا",
  "ٹہلانا": "ٹہلنا",
  "ٹہلاتے": "ٹہلنا",
  "ٹہلاتا": "ٹہلنا",
  "ٹہلاتی": "ٹہلنا",
  "ٹہلاتیں": "ٹہلنا",
  "ٹہلاؤ": "ٹہلنا",
  "ٹہلاؤں": "ٹہلنا",
  "ٹہلائے": "ٹہلنا",
  "ٹہلائی": "ٹہلنا",
  "ٹہلائیے": "ٹہلنا",
  "ٹہلائیں": "ٹہلنا",
  "ٹہلایا": "ٹہلنا",
  "ٹہلنے": "ٹہلنا",
  "ٹہلنا": "ٹہلنا",
  "ٹہلنی": "ٹہلنا",
  "ٹہلتے": "ٹہلنا",
  "ٹہلتا": "ٹہلنا",
  "ٹہلتی": "ٹہلنا",
  "ٹہلتیں": "ٹہلنا",
  "ٹہلو": "ٹہلنا",
  "ٹہلوں": "ٹہلنا",
  "ٹہلوا": "ٹہلنا",
  "ٹہلوانے": "ٹہلنا",
  "ٹہلوانا": "ٹہلنا",
  "ٹہلواتے": "ٹہلنا",
  "ٹہلواتا": "ٹہلنا",
  "ٹہلواتی": "ٹہلنا",
  "ٹہلواتیں": "ٹہلنا",
  "ٹہلواؤ": "ٹہلنا",
  "ٹہلواؤں": "ٹہلنا",
  "ٹہلوائے": "ٹہلنا",
  "ٹہلوائی": "ٹہلنا",
  "ٹہلوائیے": "ٹہلنا",
  "ٹہلوائیں": "ٹہلنا",
  "ٹہلوایا": "ٹہلنا",
  "ٹہلی": "ٹہلنا",
  "ٹہلیے": "ٹہلنا",
  "ٹہلیں": "ٹہلنا",
  "ٹہنی": "ٹہنی",
  "ٹہنیاں": "ٹہنی",
  "ٹہنیو": "ٹہنی",
  "ٹہنیوں": "ٹہنی",
  "ٹہر": "ٹہرنا",
  "ٹہرے": "ٹہرنا",
  "ٹہرں": "ٹہرنا",
  "ٹہرا": "ٹہرنا",
  "ٹہرانے": "ٹہرنا",
  "ٹہرانا": "ٹہرنا",
  "ٹہراتے": "ٹہرنا",
  "ٹہراتا": "ٹہرنا",
  "ٹہراتی": "ٹہرنا",
  "ٹہراتیں": "ٹہرنا",
  "ٹہراؤ": "ٹہرنا",
  "ٹہراؤں": "ٹہرنا",
  "ٹہرائے": "ٹہرنا",
  "ٹہرائی": "ٹہرنا",
  "ٹہرائیے": "ٹہرنا",
  "ٹہرائیں": "ٹہرنا",
  "ٹہرایا": "ٹہرنا",
  "ٹہرنے": "ٹہرنا",
  "ٹہرنا": "ٹہرنا",
  "ٹہرنی": "ٹہرنا",
  "ٹہرتے": "ٹہرنا",
  "ٹہرتا": "ٹہرنا",
  "ٹہرتی": "ٹہرنا",
  "ٹہرتیں": "ٹہرنا",
  "ٹہرو": "ٹہرنا",
  "ٹہروں": "ٹہرنا",
  "ٹہروا": "ٹہرنا",
  "ٹہروانے": "ٹہرنا",
  "ٹہروانا": "ٹہرنا",
  "ٹہرواتے": "ٹہرنا",
  "ٹہرواتا": "ٹہرنا",
  "ٹہرواتی": "ٹہرنا",
  "ٹہرواتیں": "ٹہرنا",
  "ٹہرواؤ": "ٹہرنا",
  "ٹہرواؤں": "ٹہرنا",
  "ٹہروائے": "ٹہرنا",
  "ٹہروائی": "ٹہرنا",
  "ٹہروائیے": "ٹہرنا",
  "ٹہروائیں": "ٹہرنا",
  "ٹہروایا": "ٹہرنا",
  "ٹہری": "ٹہرنا",
  "ٹہریے": "ٹہرنا",
  "ٹہریں": "ٹہرنا",
  "ٹہوکے": "ٹہوکہ",
  "ٹہوکہ": "ٹہوکہ",
  "ٹہوکو": "ٹہوکہ",
  "ٹہوکوں": "ٹہوکہ",
  "ٹک": "ٹیکنا",
  "ٹکے": "ٹکا",
  "ٹکں": "ٹیکنا",
  "ٹکڑے": "ٹکڑا",
  "ٹکڑا": "ٹکڑا",
  "ٹکڑو": "ٹکڑا",
  "ٹکڑوں": "ٹکڑا",
  "ٹکڑی": "ٹکڑی",
  "ٹکڑیاں": "ٹکڑی",
  "ٹکڑیو": "ٹکڑی",
  "ٹکڑیوں": "ٹکڑی",
  "ٹکٹ": "ٹکٹ",
  "ٹکٹو": "ٹکٹ",
  "ٹکٹوں": "ٹکٹ",
  "ٹکٹیں": "ٹکٹ",
  "ٹکا": "ٹکا",
  "ٹکہ": "ٹکہ",
  "ٹکنے": "ٹیکنا",
  "ٹکنا": "ٹیکنا",
  "ٹکر": "ٹکر",
  "ٹکرا": "ٹکرانا",
  "ٹکرانے": "ٹکرانا",
  "ٹکرانا": "ٹکرانا",
  "ٹکرانی": "ٹکرانا",
  "ٹکراتے": "ٹکرانا",
  "ٹکراتا": "ٹکرانا",
  "ٹکراتی": "ٹکرانا",
  "ٹکراتیں": "ٹکرانا",
  "ٹکراؤ": "ٹکرانا",
  "ٹکراؤں": "ٹکرانا",
  "ٹکرائے": "ٹکرانا",
  "ٹکرائی": "ٹکرانا",
  "ٹکرائیے": "ٹکرانا",
  "ٹکرائیں": "ٹکرانا",
  "ٹکرایا": "ٹکرانا",
  "ٹکرو": "ٹکر",
  "ٹکروں": "ٹکر",
  "ٹکروا": "ٹکرانا",
  "ٹکروانے": "ٹکرانا",
  "ٹکروانا": "ٹکرانا",
  "ٹکرواتے": "ٹکرانا",
  "ٹکرواتا": "ٹکرانا",
  "ٹکرواتی": "ٹکرانا",
  "ٹکرواتیں": "ٹکرانا",
  "ٹکرواؤ": "ٹکرانا",
  "ٹکرواؤں": "ٹکرانا",
  "ٹکروائے": "ٹکرانا",
  "ٹکروائی": "ٹکرانا",
  "ٹکروائیے": "ٹکرانا",
  "ٹکروائیں": "ٹکرانا",
  "ٹکروایا": "ٹکرانا",
  "ٹکریں": "ٹکر",
  "ٹکتے": "ٹیکنا",
  "ٹکتا": "ٹیکنا",
  "ٹکتی": "ٹیکنا",
  "ٹکتیں": "ٹیکنا",
  "ٹکو": "ٹکا",
  "ٹکوں": "ٹکا",
  "ٹکوا": "ٹیکنا",
  "ٹکوانے": "ٹیکنا",
  "ٹکوانا": "ٹیکنا",
  "ٹکواتے": "ٹیکنا",
  "ٹکواتا": "ٹیکنا",
  "ٹکواتی": "ٹیکنا",
  "ٹکواتیں": "ٹیکنا",
  "ٹکواؤ": "ٹیکنا",
  "ٹکواؤں": "ٹیکنا",
  "ٹکوائے": "ٹیکنا",
  "ٹکوائی": "ٹیکنا",
  "ٹکوائیے": "ٹیکنا",
  "ٹکوائیں": "ٹیکنا",
  "ٹکوایا": "ٹیکنا",
  "ٹکی": "ٹکی",
  "ٹکیے": "ٹیکنا",
  "ٹکیں": "ٹیکنا",
  "ٹکیا": "ٹکیا",
  "ٹکیاں": "ٹکی",
  "ٹکیو": "ٹکی",
  "ٹکیوں": "ٹکی",
  "ٹنڈ": "ٹنڈ",
  "ٹنڈو": "ٹنڈ",
  "ٹنڈوں": "ٹنڈ",
  "ٹنڈیں": "ٹنڈ",
  "ٹنکی": "ٹنکی",
  "ٹنکیاں": "ٹنکی",
  "ٹنکیو": "ٹنکی",
  "ٹنکیوں": "ٹنکی",
  "ٹرا": "ٹرانا",
  "ٹرام": "ٹرام",
  "ٹرامو": "ٹرام",
  "ٹراموں": "ٹرام",
  "ٹرامیں": "ٹرام",
  "ٹرانے": "ٹرانا",
  "ٹرانا": "ٹرانا",
  "ٹرانی": "ٹرانا",
  "ٹراتے": "ٹرانا",
  "ٹراتا": "ٹرانا",
  "ٹراتی": "ٹرانا",
  "ٹراتیں": "ٹرانا",
  "ٹراؤ": "ٹرانا",
  "ٹراؤں": "ٹرانا",
  "ٹرائے": "ٹرانا",
  "ٹرائی": "ٹرانا",
  "ٹرائیے": "ٹرانا",
  "ٹرائیں": "ٹرانا",
  "ٹرایا": "ٹرانا",
  "ٹرنک": "ٹرنک",
  "ٹرنکو": "ٹرنک",
  "ٹرنکوں": "ٹرنک",
  "ٹرنکیں": "ٹرنک",
  "ٹرسٹی": "ٹرسٹی",
  "ٹرسٹیو": "ٹرسٹی",
  "ٹرسٹیوں": "ٹرسٹی",
  "ٹرین": "ٹرین",
  "ٹرینو": "ٹرین",
  "ٹرینوں": "ٹرین",
  "ٹرینیں": "ٹرین",
  "ٹوٹ": "ٹوٹنا",
  "ٹوٹے": "ٹوٹنا",
  "ٹوٹں": "ٹوٹنا",
  "ٹوٹا": "ٹوٹنا",
  "ٹوٹکے": "ٹوٹکا",
  "ٹوٹکا": "ٹوٹکا",
  "ٹوٹکو": "ٹوٹکا",
  "ٹوٹکوں": "ٹوٹکا",
  "ٹوٹنے": "ٹوٹنا",
  "ٹوٹنا": "ٹوٹنا",
  "ٹوٹنی": "ٹوٹنا",
  "ٹوٹتے": "ٹوٹنا",
  "ٹوٹتا": "ٹوٹنا",
  "ٹوٹتی": "ٹوٹنا",
  "ٹوٹتیں": "ٹوٹنا",
  "ٹوٹو": "ٹوٹنا",
  "ٹوٹوں": "ٹوٹنا",
  "ٹوٹی": "ٹوٹنا",
  "ٹوٹیے": "ٹوٹنا",
  "ٹوٹیں": "ٹوٹنا",
  "ٹوک": "ٹوکنا",
  "ٹوکے": "ٹوکا",
  "ٹوکں": "ٹوکنا",
  "ٹوکا": "ٹوکا",
  "ٹوکنے": "ٹوکنا",
  "ٹوکنا": "ٹوکنا",
  "ٹوکنی": "ٹوکنا",
  "ٹوکرے": "ٹوکرا",
  "ٹوکرا": "ٹوکرا",
  "ٹوکرو": "ٹوکرا",
  "ٹوکروں": "ٹوکرا",
  "ٹوکری": "ٹوکری",
  "ٹوکریاں": "ٹوکری",
  "ٹوکریو": "ٹوکری",
  "ٹوکریوں": "ٹوکری",
  "ٹوکتے": "ٹوکنا",
  "ٹوکتا": "ٹوکنا",
  "ٹوکتی": "ٹوکنا",
  "ٹوکتیں": "ٹوکنا",
  "ٹوکو": "ٹوکا",
  "ٹوکوں": "ٹوکا",
  "ٹوکی": "ٹوکنا",
  "ٹوکیے": "ٹوکنا",
  "ٹوکیں": "ٹوکنا",
  "ٹول": "ٹول",
  "ٹولو": "ٹول",
  "ٹولوں": "ٹول",
  "ٹولی": "ٹولی",
  "ٹولیاں": "ٹولی",
  "ٹولیو": "ٹولی",
  "ٹولیوں": "ٹولی",
  "ٹونٹی": "ٹونٹی",
  "ٹونٹیاں": "ٹونٹی",
  "ٹونٹیو": "ٹونٹی",
  "ٹونٹیوں": "ٹونٹی",
  "ٹوپی": "ٹوپی",
  "ٹوپیاں": "ٹوپی",
  "ٹوپیو": "ٹوپی",
  "ٹوپیوں": "ٹوپی",
  "ٹیچر": "ٹیچر",
  "ٹیچرو": "ٹیچر",
  "ٹیچروں": "ٹیچر",
  "ٹیک": "ٹیک",
  "ٹیکے": "ٹیکا",
  "ٹیکں": "ٹیکنا",
  "ٹیکا": "ٹیکا",
  "ٹیکہ": "ٹیکہ",
  "ٹیکنے": "ٹیکنا",
  "ٹیکنا": "ٹیکنا",
  "ٹیکنی": "ٹیکنا",
  "ٹیکسی": "ٹیکسی",
  "ٹیکسیاں": "ٹیکسی",
  "ٹیکسیو": "ٹیکسی",
  "ٹیکسیوں": "ٹیکسی",
  "ٹیکتے": "ٹیکنا",
  "ٹیکتا": "ٹیکنا",
  "ٹیکتی": "ٹیکنا",
  "ٹیکتیں": "ٹیکنا",
  "ٹیکو": "ٹیکا",
  "ٹیکوں": "ٹیکا",
  "ٹیکی": "ٹیکنا",
  "ٹیکیے": "ٹیکنا",
  "ٹیکیں": "ٹیک",
  "ٹیلے": "ٹیلا",
  "ٹیلا": "ٹیلا",
  "ٹیلہ": "ٹیلہ",
  "ٹیلو": "ٹیلا",
  "ٹیلوں": "ٹیلا",
  "ٹیم": "ٹیم",
  "ٹیمو": "ٹیم",
  "ٹیموں": "ٹیم",
  "ٹیمیں": "ٹیم",
  "ٹینک": "ٹینک",
  "ٹینکو": "ٹینک",
  "ٹینکوں": "ٹینک",
  "ٹینکیں": "ٹینک",
  "ٹیپ": "ٹیپ",
  "ٹیپو": "ٹیپ",
  "ٹیپوں": "ٹیپ",
  "ٹیپیں": "ٹیپ",
  "ٹیس": "ٹیس",
  "ٹیسو": "ٹیس",
  "ٹیسوں": "ٹیس",
  "ٹیسیں": "ٹیس",
  "ٹھٹھے": "ٹھٹھا",
  "ٹھٹھا": "ٹھٹھا",
  "ٹھٹھہ": "ٹھٹھہ",
  "ٹھٹھو": "ٹھٹھا",
  "ٹھٹھوں": "ٹھٹھا",
  "ٹھاٹھ": "ٹھاٹھ",
  "ٹھاٹھو": "ٹھاٹھ",
  "ٹھاٹھوں": "ٹھاٹھ",
  "ٹھاٹھیں": "ٹھاٹھ",
  "ٹھگ": "ٹھگنا",
  "ٹھگے": "ٹھگنا",
  "ٹھگں": "ٹھگنا",
  "ٹھگا": "ٹھگنا",
  "ٹھگانے": "ٹھگنا",
  "ٹھگانا": "ٹھگنا",
  "ٹھگاتے": "ٹھگنا",
  "ٹھگاتا": "ٹھگنا",
  "ٹھگاتی": "ٹھگنا",
  "ٹھگاتیں": "ٹھگنا",
  "ٹھگاؤ": "ٹھگنا",
  "ٹھگاؤں": "ٹھگنا",
  "ٹھگائے": "ٹھگنا",
  "ٹھگائی": "ٹھگنا",
  "ٹھگائیے": "ٹھگنا",
  "ٹھگائیں": "ٹھگنا",
  "ٹھگایا": "ٹھگنا",
  "ٹھگنے": "ٹھگنا",
  "ٹھگنا": "ٹھگنا",
  "ٹھگنی": "ٹھگنا",
  "ٹھگتے": "ٹھگنا",
  "ٹھگتا": "ٹھگنا",
  "ٹھگتی": "ٹھگنا",
  "ٹھگتیں": "ٹھگنا",
  "ٹھگو": "ٹھگنا",
  "ٹھگوں": "ٹھگنا",
  "ٹھگوا": "ٹھگنا",
  "ٹھگوانے": "ٹھگنا",
  "ٹھگوانا": "ٹھگنا",
  "ٹھگواتے": "ٹھگنا",
  "ٹھگواتا": "ٹھگنا",
  "ٹھگواتی": "ٹھگنا",
  "ٹھگواتیں": "ٹھگنا",
  "ٹھگواؤ": "ٹھگنا",
  "ٹھگواؤں": "ٹھگنا",
  "ٹھگوائے": "ٹھگنا",
  "ٹھگوائی": "ٹھگنا",
  "ٹھگوائیے": "ٹھگنا",
  "ٹھگوائیں": "ٹھگنا",
  "ٹھگوایا": "ٹھگنا",
  "ٹھگی": "ٹھگنا",
  "ٹھگیے": "ٹھگنا",
  "ٹھگیں": "ٹھگنا",
  "ٹھہر": "ٹھہرنا",
  "ٹھہرے": "ٹھہرنا",
  "ٹھہرں": "ٹھہرنا",
  "ٹھہرا": "ٹھہرنا",
  "ٹھہرانے": "ٹھہرنا",
  "ٹھہرانا": "ٹھہرنا",
  "ٹھہراتے": "ٹھہرنا",
  "ٹھہراتا": "ٹھہرنا",
  "ٹھہراتی": "ٹھہرنا",
  "ٹھہراتیں": "ٹھہرنا",
  "ٹھہراؤ": "ٹھہرنا",
  "ٹھہراؤں": "ٹھہرنا",
  "ٹھہرائے": "ٹھہرنا",
  "ٹھہرائی": "ٹھہرنا",
  "ٹھہرائیے": "ٹھہرنا",
  "ٹھہرائیں": "ٹھہرنا",
  "ٹھہرایا": "ٹھہرنا",
  "ٹھہرنے": "ٹھہرنا",
  "ٹھہرنا": "ٹھہرنا",
  "ٹھہرنی": "ٹھہرنا",
  "ٹھہرتے": "ٹھہرنا",
  "ٹھہرتا": "ٹھہرنا",
  "ٹھہرتی": "ٹھہرنا",
  "ٹھہرتیں": "ٹھہرنا",
  "ٹھہرو": "ٹھہرنا",
  "ٹھہروں": "ٹھہرنا",
  "ٹھہروا": "ٹھہرنا",
  "ٹھہروانے": "ٹھہرنا",
  "ٹھہروانا": "ٹھہرنا",
  "ٹھہرواتے": "ٹھہرنا",
  "ٹھہرواتا": "ٹھہرنا",
  "ٹھہرواتی": "ٹھہرنا",
  "ٹھہرواتیں": "ٹھہرنا",
  "ٹھہرواؤ": "ٹھہرنا",
  "ٹھہرواؤں": "ٹھہرنا",
  "ٹھہروائے": "ٹھہرنا",
  "ٹھہروائی": "ٹھہرنا",
  "ٹھہروائیے": "ٹھہرنا",
  "ٹھہروائیں": "ٹھہرنا",
  "ٹھہروایا": "ٹھہرنا",
  "ٹھہری": "ٹھہرنا",
  "ٹھہریے": "ٹھہرنا",
  "ٹھہریں": "ٹھہرنا",
  "ٹھک": "ٹھکنا",
  "ٹھکے": "ٹھکنا",
  "ٹھکں": "ٹھکنا",
  "ٹھکا": "ٹھکنا",
  "ٹھکانے": "ٹھکانا",
  "ٹھکانا": "ٹھکانا",
  "ٹھکانہ": "ٹھکانہ",
  "ٹھکانو": "ٹھکانا",
  "ٹھکانوں": "ٹھکانا",
  "ٹھکاتے": "ٹھکنا",
  "ٹھکاتا": "ٹھکنا",
  "ٹھکاتی": "ٹھکنا",
  "ٹھکاتیں": "ٹھکنا",
  "ٹھکاؤ": "ٹھکنا",
  "ٹھکاؤں": "ٹھکنا",
  "ٹھکائے": "ٹھکنا",
  "ٹھکائی": "ٹھکنا",
  "ٹھکائیے": "ٹھکنا",
  "ٹھکائیں": "ٹھکنا",
  "ٹھکایا": "ٹھکنا",
  "ٹھکنے": "ٹھکنا",
  "ٹھکنا": "ٹھکنا",
  "ٹھکنی": "ٹھکنا",
  "ٹھکرا": "ٹھکرانا",
  "ٹھکرانے": "ٹھکرانہ",
  "ٹھکرانا": "ٹھکرانا",
  "ٹھکرانہ": "ٹھکرانہ",
  "ٹھکرانو": "ٹھکرانہ",
  "ٹھکرانوں": "ٹھکرانہ",
  "ٹھکرانی": "ٹھکرانا",
  "ٹھکراتے": "ٹھکرانا",
  "ٹھکراتا": "ٹھکرانا",
  "ٹھکراتی": "ٹھکرانا",
  "ٹھکراتیں": "ٹھکرانا",
  "ٹھکراؤ": "ٹھکرانا",
  "ٹھکراؤں": "ٹھکرانا",
  "ٹھکرائے": "ٹھکرانا",
  "ٹھکرائی": "ٹھکرانا",
  "ٹھکرائیے": "ٹھکرانا",
  "ٹھکرائیں": "ٹھکرانا",
  "ٹھکرایا": "ٹھکرانا",
  "ٹھکروا": "ٹھکرانا",
  "ٹھکروانے": "ٹھکرانا",
  "ٹھکروانا": "ٹھکرانا",
  "ٹھکرواتے": "ٹھکرانا",
  "ٹھکرواتا": "ٹھکرانا",
  "ٹھکرواتی": "ٹھکرانا",
  "ٹھکرواتیں": "ٹھکرانا",
  "ٹھکرواؤ": "ٹھکرانا",
  "ٹھکرواؤں": "ٹھکرانا",
  "ٹھکروائے": "ٹھکرانا",
  "ٹھکروائی": "ٹھکرانا",
  "ٹھکروائیے": "ٹھکرانا",
  "ٹھکروائیں": "ٹھکرانا",
  "ٹھکروایا": "ٹھکرانا",
  "ٹھکتے": "ٹھکنا",
  "ٹھکتا": "ٹھکنا",
  "ٹھکتی": "ٹھکنا",
  "ٹھکتیں": "ٹھکنا",
  "ٹھکو": "ٹھکنا",
  "ٹھکوں": "ٹھکنا",
  "ٹھکوا": "ٹھکنا",
  "ٹھکوانے": "ٹھکنا",
  "ٹھکوانا": "ٹھکنا",
  "ٹھکواتے": "ٹھکنا",
  "ٹھکواتا": "ٹھکنا",
  "ٹھکواتی": "ٹھکنا",
  "ٹھکواتیں": "ٹھکنا",
  "ٹھکواؤ": "ٹھکنا",
  "ٹھکواؤں": "ٹھکنا",
  "ٹھکوائے": "ٹھکنا",
  "ٹھکوائی": "ٹھکنا",
  "ٹھکوائیے": "ٹھکنا",
  "ٹھکوائیں": "ٹھکنا",
  "ٹھکوایا": "ٹھکنا",
  "ٹھکی": "ٹھکنا",
  "ٹھکیے": "ٹھکنا",
  "ٹھکیں": "ٹھکنا",
  "ٹھپے": "ٹھپا",
  "ٹھپا": "ٹھپا",
  "ٹھپہ": "ٹھپہ",
  "ٹھپو": "ٹھپا",
  "ٹھپوں": "ٹھپا",
  "ٹھس": "ٹھسنا",
  "ٹھسے": "ٹھسہ",
  "ٹھسں": "ٹھسنا",
  "ٹھسا": "ٹھسنا",
  "ٹھسانے": "ٹھسنا",
  "ٹھسانا": "ٹھسنا",
  "ٹھساتے": "ٹھسنا",
  "ٹھساتا": "ٹھسنا",
  "ٹھساتی": "ٹھسنا",
  "ٹھساتیں": "ٹھسنا",
  "ٹھساؤ": "ٹھسنا",
  "ٹھساؤں": "ٹھسنا",
  "ٹھسائے": "ٹھسنا",
  "ٹھسائی": "ٹھسنا",
  "ٹھسائیے": "ٹھسنا",
  "ٹھسائیں": "ٹھسنا",
  "ٹھسایا": "ٹھسنا",
  "ٹھسہ": "ٹھسہ",
  "ٹھسنے": "ٹھسنا",
  "ٹھسنا": "ٹھسنا",
  "ٹھسنی": "ٹھسنا",
  "ٹھستے": "ٹھسنا",
  "ٹھستا": "ٹھسنا",
  "ٹھستی": "ٹھسنا",
  "ٹھستیں": "ٹھسنا",
  "ٹھسو": "ٹھسہ",
  "ٹھسوں": "ٹھسہ",
  "ٹھسوا": "ٹھسنا",
  "ٹھسوانے": "ٹھسنا",
  "ٹھسوانا": "ٹھسنا",
  "ٹھسواتے": "ٹھسنا",
  "ٹھسواتا": "ٹھسنا",
  "ٹھسواتی": "ٹھسنا",
  "ٹھسواتیں": "ٹھسنا",
  "ٹھسواؤ": "ٹھسنا",
  "ٹھسواؤں": "ٹھسنا",
  "ٹھسوائے": "ٹھسنا",
  "ٹھسوائی": "ٹھسنا",
  "ٹھسوائیے": "ٹھسنا",
  "ٹھسوائیں": "ٹھسنا",
  "ٹھسوایا": "ٹھسنا",
  "ٹھسی": "ٹھسنا",
  "ٹھسیے": "ٹھسنا",
  "ٹھسیں": "ٹھسنا",
  "ٹھوڑی": "ٹھوڑی",
  "ٹھوڑیاں": "ٹھوڑی",
  "ٹھوڑیو": "ٹھوڑی",
  "ٹھوڑیوں": "ٹھوڑی",
  "ٹھوکر": "ٹھوکر",
  "ٹھوکرو": "ٹھوکر",
  "ٹھوکروں": "ٹھوکر",
  "ٹھوکریں": "ٹھوکر",
  "ٹھونک": "ٹھونکنا",
  "ٹھونکے": "ٹھونکنا",
  "ٹھونکں": "ٹھونکنا",
  "ٹھونکا": "ٹھونکنا",
  "ٹھونکنے": "ٹھونکنا",
  "ٹھونکنا": "ٹھونکنا",
  "ٹھونکنی": "ٹھونکنا",
  "ٹھونکتے": "ٹھونکنا",
  "ٹھونکتا": "ٹھونکنا",
  "ٹھونکتی": "ٹھونکنا",
  "ٹھونکتیں": "ٹھونکنا",
  "ٹھونکو": "ٹھونکنا",
  "ٹھونکوں": "ٹھونکنا",
  "ٹھونکوا": "ٹھونکنا",
  "ٹھونکوانے": "ٹھونکنا",
  "ٹھونکوانا": "ٹھونکنا",
  "ٹھونکواتے": "ٹھونکنا",
  "ٹھونکواتا": "ٹھونکنا",
  "ٹھونکواتی": "ٹھونکنا",
  "ٹھونکواتیں": "ٹھونکنا",
  "ٹھونکواؤ": "ٹھونکنا",
  "ٹھونکواؤں": "ٹھونکنا",
  "ٹھونکوائے": "ٹھونکنا",
  "ٹھونکوائی": "ٹھونکنا",
  "ٹھونکوائیے": "ٹھونکنا",
  "ٹھونکوائیں": "ٹھونکنا",
  "ٹھونکوایا": "ٹھونکنا",
  "ٹھونکی": "ٹھونکنا",
  "ٹھونکیے": "ٹھونکنا",
  "ٹھونکیں": "ٹھونکنا",
  "ٹھیکے": "ٹھیکا",
  "ٹھیکا": "ٹھیکا",
  "ٹھیکہ": "ٹھیکہ",
  "ٹھیکری": "ٹھیکری",
  "ٹھیکریاں": "ٹھیکری",
  "ٹھیکریو": "ٹھیکری",
  "ٹھیکریوں": "ٹھیکری",
  "ٹھیکو": "ٹھیکا",
  "ٹھیکوں": "ٹھیکا",
  "ٹھیلے": "ٹھیلا",
  "ٹھیلا": "ٹھیلا",
  "ٹھیلو": "ٹھیلا",
  "ٹھیلوں": "ٹھیلا",
  "شَفْقَت": "شَفْقَت",
  "شَفْقَتو": "شَفْقَت",
  "شَفْقَتوں": "شَفْقَت",
  "شَفْقَتیں": "شَفْقَت",
  "شَمْشِیر": "شَمْشِیر",
  "شَمْشِیرو": "شَمْشِیر",
  "شَمْشِیروں": "شَمْشِیر",
  "شَمْشِیریں": "شَمْشِیر",
  "شَوکَت": "شَوکَت",
  "شَوکَتو": "شَوکَت",
  "شَوکَتوں": "شَوکَت",
  "شَوکَتیں": "شَوکَت",
  "شے": "شہ",
  "شخص": "شخص",
  "شخصو": "شخص",
  "شخصوں": "شخص",
  "شخصیت": "شخصیت",
  "شخصیتو": "شخصیت",
  "شخصیتوں": "شخصیت",
  "شخصیتیں": "شخصیت",
  "شاخ": "شاخ",
  "شاخے": "شاخہ",
  "شاخہ": "شاخہ",
  "شاخسانے": "شاخسانہ",
  "شاخسانہ": "شاخسانہ",
  "شاخسانو": "شاخسانہ",
  "شاخسانوں": "شاخسانہ",
  "شاخو": "شاخہ",
  "شاخوں": "شاخہ",
  "شاخیں": "شاخ",
  "شادی": "شادی",
  "شادیاں": "شادی",
  "شادیو": "شادی",
  "شادیوں": "شادی",
  "شاعر": "شاعر",
  "شاعرو": "شاعر",
  "شاعروں": "شاعر",
  "شاعری": "شاعری",
  "شاگرد": "شاگرد",
  "شاگردو": "شاگرد",
  "شاگردوں": "شاگرد",
  "شاہد": "شاہد",
  "شاہدو": "شاہد",
  "شاہدوں": "شاہد",
  "شاہکار": "شاہکار",
  "شاہکارو": "شاہکار",
  "شاہکاروں": "شاہکار",
  "شاہراہ": "شاہراہ",
  "شاہراہو": "شاہراہ",
  "شاہراہوں": "شاہراہ",
  "شاہراہیں": "شاہراہ",
  "شال": "شال",
  "شالے": "شالہ",
  "شالہ": "شالہ",
  "شالو": "شالہ",
  "شالوں": "شالہ",
  "شالیں": "شال",
  "شام": "شام",
  "شامو": "شام",
  "شاموں": "شام",
  "شامیں": "شام",
  "شامیانے": "شامیانہ",
  "شامیانہ": "شامیانہ",
  "شامیانو": "شامیانہ",
  "شامیانوں": "شامیانہ",
  "شان": "شان",
  "شانے": "شانہ",
  "شانہ": "شانہ",
  "شانو": "شانہ",
  "شانوں": "شانہ",
  "شانیں": "شان",
  "شارے": "شارہ",
  "شارہ": "شارہ",
  "شارو": "شارہ",
  "شاروں": "شارہ",
  "شبد": "شبد",
  "شبدو": "شبد",
  "شبدوں": "شبد",
  "شبدیں": "شبد",
  "شعاع": "شعاع",
  "شعاعے": "شعاع",
  "شعاعو": "شعاع",
  "شعاعوں": "شعاع",
  "شعاعیں": "شعاع",
  "شعبے": "شعبہ",
  "شعبدے": "شعبدہ",
  "شعبدہ": "شعبدہ",
  "شعبدو": "شعبدہ",
  "شعبدوں": "شعبدہ",
  "شعبہ": "شعبہ",
  "شعبو": "شعبہ",
  "شعبوں": "شعبہ",
  "شعلے": "شعلہ",
  "شعلہ": "شعلہ",
  "شعلو": "شعلہ",
  "شعلوں": "شعلہ",
  "شعر": "شعر",
  "شعراءکے": "شعراءکا",
  "شعراءکا": "شعراءکا",
  "شعراءکو": "شعراءکا",
  "شعراءکوں": "شعراءکا",
  "شعرو": "شعر",
  "شعروں": "شعر",
  "شفٹ": "شفٹ",
  "شفٹو": "شفٹ",
  "شفٹوں": "شفٹ",
  "شفٹیں": "شفٹ",
  "شفقت": "شفقت",
  "شفقتو": "شفقت",
  "شفقتوں": "شفقت",
  "شفقتیں": "شفقت",
  "شگاف": "شگاف",
  "شگافو": "شگاف",
  "شگافوں": "شگاف",
  "شگوفے": "شگوفہ",
  "شگوفہ": "شگوفہ",
  "شگوفو": "شگوفہ",
  "شگوفوں": "شگوفہ",
  "شہ": "شہ",
  "شہادت": "شہادت",
  "شہادتو": "شہادت",
  "شہادتوں": "شہادت",
  "شہادتیں": "شہادت",
  "شہر": "شہر",
  "شہرے": "شہرہ",
  "شہرہ": "شہرہ",
  "شہرو": "شہرہ",
  "شہروں": "شہرہ",
  "شہری": "شہری",
  "شہریو": "شہری",
  "شہریوں": "شہری",
  "شہید": "شہید",
  "شہیدو": "شہید",
  "شہیدوں": "شہید",
  "شہزاد": "شہزاد",
  "شہزادے": "شہزادہ",
  "شہزادہ": "شہزادہ",
  "شہزادو": "شہزادہ",
  "شہزادوں": "شہزادہ",
  "شہزادی": "شہزادی",
  "شہزادیاں": "شہزادی",
  "شہزادیو": "شہزادی",
  "شہزادیوں": "شہزادی",
  "شجرے": "شجرہ",
  "شجرہ": "شجرہ",
  "شجرو": "شجرہ",
  "شجروں": "شجرہ",
  "شک": "شک",
  "شکائت": "شکائت",
  "شکائتو": "شکائت",
  "شکائتوں": "شکائت",
  "شکائتیں": "شکائت",
  "شکایت": "شکایت",
  "شکایتو": "شکایت",
  "شکایتوں": "شکایت",
  "شکایتیں": "شکایت",
  "شکل": "شکل",
  "شکلو": "شکل",
  "شکلوں": "شکل",
  "شکلیں": "شکل",
  "شکن": "شکن",
  "شکنجے": "شکنجہ",
  "شکنجہ": "شکنجہ",
  "شکنجو": "شکنجہ",
  "شکنجوں": "شکنجہ",
  "شکنو": "شکن",
  "شکنوں": "شکن",
  "شکنیں": "شکن",
  "شکرے": "شکرہ",
  "شکرانے": "شکرانہ",
  "شکرانہ": "شکرانہ",
  "شکرانو": "شکرانہ",
  "شکرانوں": "شکرانہ",
  "شکرہ": "شکرہ",
  "شکرو": "شکرہ",
  "شکروں": "شکرہ",
  "شکریے": "شکریہ",
  "شکریہ": "شکریہ",
  "شکریو": "شکریہ",
  "شکریوں": "شکریہ",
  "شکو": "شک",
  "شکوے": "شکوہ",
  "شکوں": "شک",
  "شکوہ": "شکوہ",
  "شکوو": "شکوہ",
  "شکووں": "شکوہ",
  "شکیں": "شک",
  "شلوار": "شلوار",
  "شلوارو": "شلوار",
  "شلواروں": "شلوار",
  "شلواریں": "شلوار",
  "شمے": "شمہ",
  "شمشیر": "شمشیر",
  "شمشیرو": "شمشیر",
  "شمشیروں": "شمشیر",
  "شمشیریں": "شمشیر",
  "شمارے": "شمارہ",
  "شمارہ": "شمارہ",
  "شمارو": "شمارہ",
  "شماروں": "شمارہ",
  "شمع": "شمع",
  "شمعو": "شمع",
  "شمعوں": "شمع",
  "شمعیں": "شمع",
  "شمہ": "شمہ",
  "شملے": "شملہ",
  "شملہ": "شملہ",
  "شملو": "شملہ",
  "شملوں": "شملہ",
  "شمو": "شمہ",
  "شموں": "شمہ",
  "شناس": "شناس",
  "شناسو": "شناس",
  "شناسوں": "شناس",
  "شق": "شق",
  "شقو": "شق",
  "شقوں": "شق",
  "شقیں": "شق",
  "شر": "شر",
  "شرح": "شرح",
  "شرحو": "شرح",
  "شرحوں": "شرح",
  "شرحیں": "شرح",
  "شراب": "شراب",
  "شرابے": "شرابہ",
  "شرابہ": "شرابہ",
  "شرابو": "شرابہ",
  "شرابوں": "شرابہ",
  "شرابی": "شرابی",
  "شرابیں": "شراب",
  "شرابیو": "شرابی",
  "شرابیوں": "شرابی",
  "شرارت": "شرارت",
  "شرارتو": "شرارت",
  "شرارتوں": "شرارت",
  "شرارتیں": "شرارت",
  "شرمگاہ": "شرمگاہ",
  "شرمگاہو": "شرمگاہ",
  "شرمگاہوں": "شرمگاہ",
  "شرمگاہیں": "شرمگاہ",
  "شرمندگی": "شرمندگی",
  "شرمندگیاں": "شرمندگی",
  "شرمندگیو": "شرمندگی",
  "شرمندگیوں": "شرمندگی",
  "شرو": "شر",
  "شروں": "شر",
  "شریف": "شریف",
  "شریفو": "شریف",
  "شریفوں": "شریف",
  "شریک": "شریک",
  "شریکو": "شریک",
  "شریکوں": "شریک",
  "شرط": "شرط",
  "شرطو": "شرط",
  "شرطوں": "شرط",
  "شرطیں": "شرط",
  "شو": "شہ",
  "شوے": "شوہ",
  "شوں": "شہ",
  "شوشے": "شوشہ",
  "شوشہ": "شوشہ",
  "شوشو": "شوشہ",
  "شوشوں": "شوشہ",
  "شوہ": "شوہ",
  "شوہر": "شوہر",
  "شوہرو": "شوہر",
  "شوہروں": "شوہر",
  "شور": "شور",
  "شورے": "شورہ",
  "شوربے": "شوربہ",
  "شوربہ": "شوربہ",
  "شوربو": "شوربہ",
  "شوربوں": "شوربہ",
  "شورہ": "شورہ",
  "شورو": "شورہ",
  "شوروں": "شورہ",
  "شوو": "شوہ",
  "شووں": "شوہ",
  "شیخ": "شیخ",
  "شیخو": "شیخ",
  "شیخوں": "شیخ",
  "شیخی": "شیخی",
  "شیخیاں": "شیخی",
  "شیخیو": "شیخی",
  "شیخیوں": "شیخی",
  "شیشے": "شیشہ",
  "شیشہ": "شیشہ",
  "شیشو": "شیشہ",
  "شیشوں": "شیشہ",
  "شیشی": "شیشی",
  "شیشیاں": "شیشی",
  "شیشیو": "شیشی",
  "شیشیوں": "شیشی",
  "شیعے": "شیعہ",
  "شیعہ": "شیعہ",
  "شیعو": "شیعہ",
  "شیعوں": "شیعہ",
  "شیر": "شیر",
  "شیرے": "شیرہ",
  "شیرہ": "شیرہ",
  "شیرو": "شیرہ",
  "شیروں": "شیرہ",
  "شیروانی": "شیروانی",
  "شیروانیاں": "شیروانی",
  "شیروانیو": "شیروانی",
  "شیروانیوں": "شیروانی",
  "شیریں": "شیر",
  "شیوے": "شیوہ",
  "شیوہ": "شیوہ",
  "شیوو": "شیوہ",
  "شیووں": "شیوہ",
  "شیطان": "شیطان",
  "شیطانو": "شیطان",
  "شیطانوں": "شیطان",
  "شیطانی": "شیطانی",
  "شیطانیاں": "شیطانی",
  "شیطانیو": "شیطانی",
  "شیطانیوں": "شیطانی",
  "ذخیرے": "ذخیرا",
  "ذخیرا": "ذخیرا",
  "ذخیرہ": "ذخیرہ",
  "ذخیرو": "ذخیرا",
  "ذخیروں": "ذخیرا",
  "ذات": "ذات",
  "ذاتو": "ذات",
  "ذاتوں": "ذات",
  "ذاتیں": "ذات",
  "ذائقے": "ذائقہ",
  "ذائقہ": "ذائقہ",
  "ذائقو": "ذائقہ",
  "ذائقوں": "ذائقہ",
  "ذہن": "ذہن",
  "ذہنو": "ذہن",
  "ذہنوں": "ذہن",
  "ذمّے": "ذمّہ",
  "ذمّہ": "ذمّہ",
  "ذمّو": "ذمّہ",
  "ذمّوں": "ذمّہ",
  "ذمے": "ذمہ",
  "ذمہ": "ذمہ",
  "ذمو": "ذمہ",
  "ذموں": "ذمہ",
  "ذر": "ذر",
  "ذرّ": "ذرّ",
  "ذرّے": "ذرّہ",
  "ذرّہ": "ذرّہ",
  "ذرّو": "ذرّہ",
  "ذرّوں": "ذرّہ",
  "ذرے": "ذرا",
  "ذرا": "ذرا",
  "ذرع": "ذرع",
  "ذرعے": "ذرع",
  "ذرعہ": "ذرعہ",
  "ذرعو": "ذرع",
  "ذرعوں": "ذرع",
  "ذرہ": "ذرہ",
  "ذرو": "ذرا",
  "ذروں": "ذرا",
  "ذریع": "ذریع",
  "ذریعے": "ذریع",
  "ذریعہ": "ذریعہ",
  "ذریعو": "ذریع",
  "ذریعوں": "ذریع",
  "اَے": "اَے",
  "اَخْبار": "اَخْبار",
  "اَخْبارات": "اَخْبار",
  "اَخْبارو": "اَخْبار",
  "اَخْباروں": "اَخْبار",
  "اَب": "اَب",
  "اَمْجَد": "اَمْجَد",
  "اَمر": "اَمر",
  "اَپْنےآپ": "اَپْنےآپ",
  "اَواخِر": "آخَر",
  "اَوامِر": "اَمر",
  "اَیسے": "اَیسا",
  "اَیسا": "اَیسا",
  "اَیسی": "اَیسا",
  "ا(اo)تر": "اُترنا",
  "ا(اo)ترے": "اُترنا",
  "ا(اo)ترں": "اُترنا",
  "ا(اo)ترا": "اُترنا",
  "ا(اo)ترنے": "اُترنا",
  "ا(اo)ترنا": "اُترنا",
  "ا(اo)ترتے": "اُترنا",
  "ا(اo)ترتا": "اُترنا",
  "ا(اo)ترتی": "اُترنا",
  "ا(اo)ترتیں": "اُترنا",
  "ا(اo)ترو": "اُترنا",
  "ا(اo)تروں": "اُترنا",
  "ا(اo)تری": "اُترنا",
  "ا(اo)تریے": "اُترنا",
  "ا(اo)تریں": "اُترنا",
  "اِحْسان": "اِحْسان",
  "اِحْسانات": "اِحْسان",
  "اِحْسانو": "اِحْسان",
  "اِحْسانوں": "اِحْسان",
  "اِخْبار": "اِخْبار",
  "اِخْبارات": "اِخْبار",
  "اِخْبارو": "اِخْبار",
  "اِخْباروں": "اِخْبار",
  "اِشْتِہار": "اِشْتِہار",
  "اِشْتِہارات": "اِشْتِہار",
  "اِشْتِہارو": "اِشْتِہار",
  "اِشْتِہاروں": "اِشْتِہار",
  "اِدَھر": "اِدَھر",
  "اِن": "میں",
  "اِس": "میں",
  "اِسکے": "میرا",
  "اِسکا": "میرا",
  "اِسکی": "میرا",
  "اِسی": "اِسی",
  "اِتنے": "اِتنا",
  "اِتنا": "اِتنا",
  "اِتنی": "اِتنا",
  "اِترا": "اِترانا",
  "اِترانے": "اِترانا",
  "اِترانا": "اِترانا",
  "اِترانی": "اِترانا",
  "اِتراتے": "اِترانا",
  "اِتراتا": "اِترانا",
  "اِتراتی": "اِترانا",
  "اِتراتیں": "اِترانا",
  "اِتراؤ": "اِترانا",
  "اِتراؤں": "اِترانا",
  "اِترائے": "اِترانا",
  "اِترائی": "اِترانا",
  "اِترائیے": "اِترانا",
  "اِترائیں": "اِترانا",
  "اِترایا": "اِترانا",
  "اُڑ": "اُڑنا",
  "اُڑے": "اُڑنا",
  "اُڑں": "اُڑنا",
  "اُڑا": "اُڑنا",
  "اُڑانے": "اُڑنا",
  "اُڑانا": "اُڑنا",
  "اُڑاتے": "اُڑنا",
  "اُڑاتا": "اُڑنا",
  "اُڑاتی": "اُڑنا",
  "اُڑاتیں": "اُڑنا",
  "اُڑاؤ": "اُڑنا",
  "اُڑاؤں": "اُڑنا",
  "اُڑائے": "اُڑنا",
  "اُڑائی": "اُڑنا",
  "اُڑائیے": "اُڑنا",
  "اُڑائیں": "اُڑنا",
  "اُڑایا": "اُڑنا",
  "اُڑنے": "اُڑنا",
  "اُڑنا": "اُڑنا",
  "اُڑنی": "اُڑنا",
  "اُڑس": "اُڑسنا",
  "اُڑسے": "اُڑسنا",
  "اُڑسں": "اُڑسنا",
  "اُڑسا": "اُڑسنا",
  "اُڑسانے": "اُڑسنا",
  "اُڑسانا": "اُڑسنا",
  "اُڑساتے": "اُڑسنا",
  "اُڑساتا": "اُڑسنا",
  "اُڑساتی": "اُڑسنا",
  "اُڑساتیں": "اُڑسنا",
  "اُڑساؤ": "اُڑسنا",
  "اُڑساؤں": "اُڑسنا",
  "اُڑسائے": "اُڑسنا",
  "اُڑسائی": "اُڑسنا",
  "اُڑسائیے": "اُڑسنا",
  "اُڑسائیں": "اُڑسنا",
  "اُڑسایا": "اُڑسنا",
  "اُڑسنے": "اُڑسنا",
  "اُڑسنا": "اُڑسنا",
  "اُڑسنی": "اُڑسنا",
  "اُڑستے": "اُڑسنا",
  "اُڑستا": "اُڑسنا",
  "اُڑستی": "اُڑسنا",
  "اُڑستیں": "اُڑسنا",
  "اُڑسو": "اُڑسنا",
  "اُڑسوں": "اُڑسنا",
  "اُڑسوا": "اُڑسنا",
  "اُڑسوانے": "اُڑسنا",
  "اُڑسوانا": "اُڑسنا",
  "اُڑسواتے": "اُڑسنا",
  "اُڑسواتا": "اُڑسنا",
  "اُڑسواتی": "اُڑسنا",
  "اُڑسواتیں": "اُڑسنا",
  "اُڑسواؤ": "اُڑسنا",
  "اُڑسواؤں": "اُڑسنا",
  "اُڑسوائے": "اُڑسنا",
  "اُڑسوائی": "اُڑسنا",
  "اُڑسوائیے": "اُڑسنا",
  "اُڑسوائیں": "اُڑسنا",
  "اُڑسوایا": "اُڑسنا",
  "اُڑسی": "اُڑسنا",
  "اُڑسیے": "اُڑسنا",
  "اُڑسیں": "اُڑسنا",
  "اُڑتے": "اُڑنا",
  "اُڑتا": "اُڑنا",
  "اُڑتی": "اُڑنا",
  "اُڑتیں": "اُڑنا",
  "اُڑو": "اُڑنا",
  "اُڑوں": "اُڑنا",
  "اُڑوا": "اُڑنا",
  "اُڑوانے": "اُڑنا",
  "اُڑوانا": "اُڑنا",
  "اُڑواتے": "اُڑنا",
  "اُڑواتا": "اُڑنا",
  "اُڑواتی": "اُڑنا",
  "اُڑواتیں": "اُڑنا",
  "اُڑواؤ": "اُڑنا",
  "اُڑواؤں": "اُڑنا",
  "اُڑوائے": "اُڑنا",
  "اُڑوائی": "اُڑنا",
  "اُڑوائیے": "اُڑنا",
  "اُڑوائیں": "اُڑنا",
  "اُڑوایا": "اُڑنا",
  "اُڑی": "اُڑنا",
  "اُڑیے": "اُڑنا",
  "اُڑیں": "اُڑنا",
  "اُٹھ": "اُٹھنا",
  "اُٹھے": "اُٹھنا",
  "اُٹھں": "اُٹھنا",
  "اُٹھا": "اُٹھنا",
  "اُٹھانے": "اُٹھنا",
  "اُٹھانا": "اُٹھنا",
  "اُٹھاتے": "اُٹھنا",
  "اُٹھاتا": "اُٹھنا",
  "اُٹھاتی": "اُٹھنا",
  "اُٹھاتیں": "اُٹھنا",
  "اُٹھاؤ": "اُٹھنا",
  "اُٹھاؤں": "اُٹھنا",
  "اُٹھائے": "اُٹھنا",
  "اُٹھائی": "اُٹھنا",
  "اُٹھائیے": "اُٹھنا",
  "اُٹھائیں": "اُٹھنا",
  "اُٹھایا": "اُٹھنا",
  "اُٹھنے": "اُٹھنا",
  "اُٹھنا": "اُٹھنا",
  "اُٹھنی": "اُٹھنا",
  "اُٹھتے": "اُٹھنا",
  "اُٹھتا": "اُٹھنا",
  "اُٹھتی": "اُٹھنا",
  "اُٹھتیں": "اُٹھنا",
  "اُٹھو": "اُٹھنا",
  "اُٹھوں": "اُٹھنا",
  "اُٹھوا": "اُٹھنا",
  "اُٹھوانے": "اُٹھنا",
  "اُٹھوانا": "اُٹھنا",
  "اُٹھواتے": "اُٹھنا",
  "اُٹھواتا": "اُٹھنا",
  "اُٹھواتی": "اُٹھنا",
  "اُٹھواتیں": "اُٹھنا",
  "اُٹھواؤ": "اُٹھنا",
  "اُٹھواؤں": "اُٹھنا",
  "اُٹھوائے": "اُٹھنا",
  "اُٹھوائی": "اُٹھنا",
  "اُٹھوائیے": "اُٹھنا",
  "اُٹھوائیں": "اُٹھنا",
  "اُٹھوایا": "اُٹھنا",
  "اُٹھی": "اُٹھنا",
  "اُٹھیے": "اُٹھنا",
  "اُٹھیں": "اُٹھنا",
  "اُبھار": "اُبھار",
  "اُبھارے": "اُبھرنا",
  "اُبھارں": "اُبھرنا",
  "اُبھارا": "اُبھرنا",
  "اُبھارنے": "اُبھرنا",
  "اُبھارنا": "اُبھرنا",
  "اُبھارتے": "اُبھرنا",
  "اُبھارتا": "اُبھرنا",
  "اُبھارتی": "اُبھرنا",
  "اُبھارتیں": "اُبھرنا",
  "اُبھارو": "اُبھار",
  "اُبھاروں": "اُبھار",
  "اُبھاری": "اُبھرنا",
  "اُبھاریے": "اُبھرنا",
  "اُبھاریں": "اُبھرنا",
  "اُبھر": "اُبھرنا",
  "اُبھرے": "اُبھرنا",
  "اُبھرں": "اُبھرنا",
  "اُبھرا": "اُبھرنا",
  "اُبھرنے": "اُبھرنا",
  "اُبھرنا": "اُبھرنا",
  "اُبھرنی": "اُبھرنا",
  "اُبھرتے": "اُبھرنا",
  "اُبھرتا": "اُبھرنا",
  "اُبھرتی": "اُبھرنا",
  "اُبھرتیں": "اُبھرنا",
  "اُبھرو": "اُبھرنا",
  "اُبھروں": "اُبھرنا",
  "اُبھروا": "اُبھرنا",
  "اُبھروانے": "اُبھرنا",
  "اُبھروانا": "اُبھرنا",
  "اُبھرواتے": "اُبھرنا",
  "اُبھرواتا": "اُبھرنا",
  "اُبھرواتی": "اُبھرنا",
  "اُبھرواتیں": "اُبھرنا",
  "اُبھرواؤ": "اُبھرنا",
  "اُبھرواؤں": "اُبھرنا",
  "اُبھروائے": "اُبھرنا",
  "اُبھروائی": "اُبھرنا",
  "اُبھروائیے": "اُبھرنا",
  "اُبھروائیں": "اُبھرنا",
  "اُبھروایا": "اُبھرنا",
  "اُبھری": "اُبھرنا",
  "اُبھریے": "اُبھرنا",
  "اُبھریں": "اُبھرنا",
  "اُچَھال": "اُچَھلْنا",
  "اُچَھالے": "اُچَھلْنا",
  "اُچَھالں": "اُچَھلْنا",
  "اُچَھالا": "اُچَھلْنا",
  "اُچَھالنے": "اُچَھلْنا",
  "اُچَھالنا": "اُچَھلْنا",
  "اُچَھالتے": "اُچَھلْنا",
  "اُچَھالتا": "اُچَھلْنا",
  "اُچَھالتی": "اُچَھلْنا",
  "اُچَھالتیں": "اُچَھلْنا",
  "اُچَھالو": "اُچَھلْنا",
  "اُچَھالوں": "اُچَھلْنا",
  "اُچَھالی": "اُچَھلْنا",
  "اُچَھالیے": "اُچَھلْنا",
  "اُچَھالیں": "اُچَھلْنا",
  "اُچَھل": "اُچَھلْنا",
  "اُچَھلْں": "اُچَھلْنا",
  "اُچَھلْنے": "اُچَھلْنا",
  "اُچَھلْنا": "اُچَھلْنا",
  "اُچَھلْنی": "اُچَھلْنا",
  "اُچَھلْتے": "اُچَھلْنا",
  "اُچَھلْتا": "اُچَھلْنا",
  "اُچَھلْتی": "اُچَھلْنا",
  "اُچَھلْتیں": "اُچَھلْنا",
  "اُچَھلْوا": "اُچَھلْنا",
  "اُچَھلْوانے": "اُچَھلْنا",
  "اُچَھلْوانا": "اُچَھلْنا",
  "اُچَھلْواتے": "اُچَھلْنا",
  "اُچَھلْواتا": "اُچَھلْنا",
  "اُچَھلْواتی": "اُچَھلْنا",
  "اُچَھلْواتیں": "اُچَھلْنا",
  "اُچَھلْواؤ": "اُچَھلْنا",
  "اُچَھلْواؤں": "اُچَھلْنا",
  "اُچَھلْوائے": "اُچَھلْنا",
  "اُچَھلْوائی": "اُچَھلْنا",
  "اُچَھلْوائیے": "اُچَھلْنا",
  "اُچَھلْوائیں": "اُچَھلْنا",
  "اُچَھلْوایا": "اُچَھلْنا",
  "اُچَھلے": "اُچَھلْنا",
  "اُچَھلا": "اُچَھلْنا",
  "اُچَھلو": "اُچَھلْنا",
  "اُچَھلوں": "اُچَھلْنا",
  "اُچَھلی": "اُچَھلْنا",
  "اُچَھلیے": "اُچَھلْنا",
  "اُچَھلیں": "اُچَھلْنا",
  "اُچھال": "اُچھلنا",
  "اُچھالے": "اُچھلنا",
  "اُچھالں": "اُچھلنا",
  "اُچھالا": "اُچھلنا",
  "اُچھالنے": "اُچھلنا",
  "اُچھالنا": "اُچھلنا",
  "اُچھالتے": "اُچھلنا",
  "اُچھالتا": "اُچھلنا",
  "اُچھالتی": "اُچھلنا",
  "اُچھالتیں": "اُچھلنا",
  "اُچھالو": "اُچھلنا",
  "اُچھالوں": "اُچھلنا",
  "اُچھالی": "اُچھلنا",
  "اُچھالیے": "اُچھلنا",
  "اُچھالیں": "اُچھلنا",
  "اُچھل": "اُچھلنا",
  "اُچھلے": "اُچھلنا",
  "اُچھلں": "اُچھلنا",
  "اُچھلا": "اُچھلنا",
  "اُچھلنے": "اُچھلنا",
  "اُچھلنا": "اُچھلنا",
  "اُچھلنی": "اُچھلنا",
  "اُچھلتے": "اُچھلنا",
  "اُچھلتا": "اُچھلنا",
  "اُچھلتی": "اُچھلنا",
  "اُچھلتیں": "اُچھلنا",
  "اُچھلو": "اُچھلنا",
  "اُچھلوں": "اُچھلنا",
  "اُچھلوا": "اُچھلنا",
  "اُچھلوانے": "اُچھلنا",
  "اُچھلوانا": "اُچھلنا",
  "اُچھلواتے": "اُچھلنا",
  "اُچھلواتا": "اُچھلنا",
  "اُچھلواتی": "اُچھلنا",
  "اُچھلواتیں": "اُچھلنا",
  "اُچھلواؤ": "اُچھلنا",
  "اُچھلواؤں": "اُچھلنا",
  "اُچھلوائے": "اُچھلنا",
  "اُچھلوائی": "اُچھلنا",
  "اُچھلوائیے": "اُچھلنا",
  "اُچھلوائیں": "اُچھلنا",
  "اُچھلوایا": "اُچھلنا",
  "اُچھلی": "اُچھلنا",
  "اُچھلیے": "اُچھلنا",
  "اُچھلیں": "اُچھلنا",
  "اُدَھر": "اُدَھر",
  "اُگ": "اُگنا",
  "اُگے": "اُگنا",
  "اُگں": "اُگنا",
  "اُگا": "اُگنا",
  "اُگانے": "اُگنا",
  "اُگانا": "اُگنا",
  "اُگاتے": "اُگنا",
  "اُگاتا": "اُگنا",
  "اُگاتی": "اُگنا",
  "اُگاتیں": "اُگنا",
  "اُگاؤ": "اُگنا",
  "اُگاؤں": "اُگنا",
  "اُگائے": "اُگنا",
  "اُگائی": "اُگنا",
  "اُگائیے": "اُگنا",
  "اُگائیں": "اُگنا",
  "اُگایا": "اُگنا",
  "اُگنے": "اُگنا",
  "اُگنا": "اُگنا",
  "اُگنی": "اُگنا",
  "اُگتے": "اُگنا",
  "اُگتا": "اُگنا",
  "اُگتی": "اُگنا",
  "اُگتیں": "اُگنا",
  "اُگو": "اُگنا",
  "اُگوں": "اُگنا",
  "اُگوا": "اُگنا",
  "اُگوانے": "اُگنا",
  "اُگوانا": "اُگنا",
  "اُگواتے": "اُگنا",
  "اُگواتا": "اُگنا",
  "اُگواتی": "اُگنا",
  "اُگواتیں": "اُگنا",
  "اُگواؤ": "اُگنا",
  "اُگواؤں": "اُگنا",
  "اُگوائے": "اُگنا",
  "اُگوائی": "اُگنا",
  "اُگوائیے": "اُگنا",
  "اُگوائیں": "اُگنا",
  "اُگوایا": "اُگنا",
  "اُگی": "اُگنا",
  "اُگیے": "اُگنا",
  "اُگیں": "اُگنا",
  "اُک": "اُکنا",
  "اُکے": "اُکنا",
  "اُکں": "اُکنا",
  "اُکا": "اُکنا",
  "اُکانے": "اُکنا",
  "اُکانا": "اُکنا",
  "اُکاتے": "اُکنا",
  "اُکاتا": "اُکنا",
  "اُکاتی": "اُکنا",
  "اُکاتیں": "اُکنا",
  "اُکاؤ": "اُکنا",
  "اُکاؤں": "اُکنا",
  "اُکائے": "اُکنا",
  "اُکائی": "اُکنا",
  "اُکائیے": "اُکنا",
  "اُکائیں": "اُکنا",
  "اُکایا": "اُکنا",
  "اُکنے": "اُکنا",
  "اُکنا": "اُکنا",
  "اُکنی": "اُکنا",
  "اُکتے": "اُکنا",
  "اُکتا": "اُکنا",
  "اُکتی": "اُکنا",
  "اُکتیں": "اُکنا",
  "اُکو": "اُکنا",
  "اُکوں": "اُکنا",
  "اُکوا": "اُکنا",
  "اُکوانے": "اُکنا",
  "اُکوانا": "اُکنا",
  "اُکواتے": "اُکنا",
  "اُکواتا": "اُکنا",
  "اُکواتی": "اُکنا",
  "اُکواتیں": "اُکنا",
  "اُکواؤ": "اُکنا",
  "اُکواؤں": "اُکنا",
  "اُکوائے": "اُکنا",
  "اُکوائی": "اُکنا",
  "اُکوائیے": "اُکنا",
  "اُکوائیں": "اُکنا",
  "اُکوایا": "اُکنا",
  "اُکی": "اُکنا",
  "اُکیے": "اُکنا",
  "اُکیں": "اُکنا",
  "اُمت": "اُمت",
  "اُمتو": "اُمت",
  "اُمتوں": "اُمت",
  "اُمتیں": "اُمت",
  "اُمید": "اُمید",
  "اُمیدو": "اُمید",
  "اُمیدوں": "اُمید",
  "اُمیدیں": "اُمید",
  "اُن": "میں",
  "اُنگلی": "اُنگلی",
  "اُنگلیاں": "اُنگلی",
  "اُنگلیو": "اُنگلی",
  "اُنگلیوں": "اُنگلی",
  "اُس": "میں",
  "اُسکے": "میرا",
  "اُسکا": "میرا",
  "اُسکی": "میرا",
  "اُستاد": "اُستاد",
  "اُستادو": "اُستاد",
  "اُستادوں": "اُستاد",
  "اُتار": "اُتار",
  "اُتارے": "اُتارا",
  "اُتارا": "اُتارا",
  "اُتارو": "اُتارا",
  "اُتاروں": "اُتارا",
  "اُتر": "اُترنا",
  "اُترے": "اُترنا",
  "اُترں": "اُترنا",
  "اُترا": "اُترنا",
  "اُترانے": "اُترنا",
  "اُترانا": "اُترنا",
  "اُتراتے": "اُترنا",
  "اُتراتا": "اُترنا",
  "اُتراتی": "اُترنا",
  "اُتراتیں": "اُترنا",
  "اُتراؤ": "اُترنا",
  "اُتراؤں": "اُترنا",
  "اُترائے": "اُترنا",
  "اُترائی": "اُترنا",
  "اُترائیے": "اُترنا",
  "اُترائیں": "اُترنا",
  "اُترایا": "اُترنا",
  "اُترنے": "اُترنا",
  "اُترنا": "اُترنا",
  "اُترنی": "اُترنا",
  "اُترتے": "اُترنا",
  "اُترتا": "اُترنا",
  "اُترتی": "اُترنا",
  "اُترتیں": "اُترنا",
  "اُترو": "اُترنا",
  "اُتروں": "اُترنا",
  "اُتروا": "اُترنا",
  "اُتروانے": "اُترنا",
  "اُتروانا": "اُترنا",
  "اُترواتے": "اُترنا",
  "اُترواتا": "اُترنا",
  "اُترواتی": "اُترنا",
  "اُترواتیں": "اُترنا",
  "اُترواؤ": "اُترنا",
  "اُترواؤں": "اُترنا",
  "اُتروائے": "اُترنا",
  "اُتروائی": "اُترنا",
  "اُتروائیے": "اُترنا",
  "اُتروائیں": "اُترنا",
  "اُتروایا": "اُترنا",
  "اُتری": "اُترنا",
  "اُتریے": "اُترنا",
  "اُتریں": "اُترنا",
  "اثر": "اثر",
  "اثرات": "اثر",
  "اثرو": "اثر",
  "اثروں": "اثر",
  "اثریں": "اثر",
  "اڈے": "اڈا",
  "اڈا": "اڈا",
  "اڈہ": "اڈہ",
  "اڈو": "اڈا",
  "اڈوں": "اڈا",
  "اے": "اے",
  "احاطے": "احاطہ",
  "احاطہ": "احاطہ",
  "احاطو": "احاطہ",
  "احاطوں": "احاطہ",
  "احمق": "احمق",
  "احمقو": "احمق",
  "احمقوں": "احمق",
  "احسان": "احسان",
  "احسانات": "احسان",
  "احسانو": "احسان",
  "احسانوں": "احسان",
  "احتیاج": "احتیاج",
  "احتیاجو": "احتیاج",
  "احتیاجوں": "احتیاج",
  "احتیاجیں": "احتیاج",
  "اخبار": "اخبار",
  "اخبارات": "اخبار",
  "اخبارو": "اخبار",
  "اخباروں": "اخبار",
  "اخباریں": "اخبار",
  "اخر": "اخر",
  "اختیار": "اختیار",
  "اختیارات": "اختیار",
  "اختیارو": "اختیار",
  "اختیاروں": "اختیار",
  "اڑ": "اڑنا",
  "اڑے": "اڑنا",
  "اڑں": "اڑنا",
  "اڑا": "اڑنا",
  "اڑانے": "اڑنا",
  "اڑانا": "اڑنا",
  "اڑات": "اڑات",
  "اڑاتے": "اڑنا",
  "اڑاتا": "اڑنا",
  "اڑاتو": "اڑات",
  "اڑاتوں": "اڑات",
  "اڑاتی": "اڑنا",
  "اڑاتیں": "اڑات",
  "اڑاؤ": "اڑنا",
  "اڑاؤں": "اڑنا",
  "اڑائے": "اڑنا",
  "اڑائی": "اڑنا",
  "اڑائیے": "اڑنا",
  "اڑائیں": "اڑنا",
  "اڑایا": "اڑنا",
  "اڑنے": "اڑنا",
  "اڑنا": "اڑنا",
  "اڑنی": "اڑنا",
  "اڑتے": "اڑنا",
  "اڑتا": "اڑنا",
  "اڑتی": "اڑنا",
  "اڑتیں": "اڑنا",
  "اڑو": "اڑنا",
  "اڑوں": "اڑنا",
  "اڑوا": "اڑنا",
  "اڑوانے": "اڑنا",
  "اڑوانا": "اڑنا",
  "اڑواتے": "اڑنا",
  "اڑواتا": "اڑنا",
  "اڑواتی": "اڑنا",
  "اڑواتیں": "اڑنا",
  "اڑواؤ": "اڑنا",
  "اڑواؤں": "اڑنا",
  "اڑوائے": "اڑنا",
  "اڑوائی": "اڑنا",
  "اڑوائیے": "اڑنا",
  "اڑوائیں": "اڑنا",
  "اڑوایا": "اڑنا",
  "اڑی": "اڑنا",
  "اڑیے": "اڑنا",
  "اڑیں": "اڑنا",
  "اڑھوا": "اوڑھنا",
  "اڑھوانے": "اوڑھنا",
  "اڑھوانا": "اوڑھنا",
  "اڑھواتے": "اوڑھنا",
  "اڑھواتا": "اوڑھنا",
  "اڑھواتی": "اوڑھنا",
  "اڑھواتیں": "اوڑھنا",
  "اڑھواؤ": "اوڑھنا",
  "اڑھواؤں": "اوڑھنا",
  "اڑھوائے": "اوڑھنا",
  "اڑھوائی": "اوڑھنا",
  "اڑھوائیے": "اوڑھنا",
  "اڑھوائیں": "اوڑھنا",
  "اڑھوایا": "اوڑھنا",
  "اصول": "اصول",
  "اصولو": "اصول",
  "اصولوں": "اصول",
  "اصطلاح": "اصطلاح",
  "اصطلاحو": "اصطلاح",
  "اصطلاحوں": "اصطلاح",
  "اصطلاحیں": "اصطلاح",
  "اٹک": "اٹکنا",
  "اٹکے": "اٹکنا",
  "اٹکں": "اٹکنا",
  "اٹکا": "اٹکنا",
  "اٹکانے": "اٹکنا",
  "اٹکانا": "اٹکنا",
  "اٹکاتے": "اٹکنا",
  "اٹکاتا": "اٹکنا",
  "اٹکاتی": "اٹکنا",
  "اٹکاتیں": "اٹکنا",
  "اٹکاؤ": "اٹکنا",
  "اٹکاؤں": "اٹکنا",
  "اٹکائے": "اٹکنا",
  "اٹکائی": "اٹکنا",
  "اٹکائیے": "اٹکنا",
  "اٹکائیں": "اٹکنا",
  "اٹکایا": "اٹکنا",
  "اٹکنے": "اٹکنا",
  "اٹکنا": "اٹکنا",
  "اٹکنی": "اٹکنا",
  "اٹکتے": "اٹکنا",
  "اٹکتا": "اٹکنا",
  "اٹکتی": "اٹکنا",
  "اٹکتیں": "اٹکنا",
  "اٹکو": "اٹکنا",
  "اٹکوں": "اٹکنا",
  "اٹکوا": "اٹکنا",
  "اٹکوانے": "اٹکنا",
  "اٹکوانا": "اٹکنا",
  "اٹکواتے": "اٹکنا",
  "اٹکواتا": "اٹکنا",
  "اٹکواتی": "اٹکنا",
  "اٹکواتیں": "اٹکنا",
  "اٹکواؤ": "اٹکنا",
  "اٹکواؤں": "اٹکنا",
  "اٹکوائے": "اٹکنا",
  "اٹکوائی": "اٹکنا",
  "اٹکوائیے": "اٹکنا",
  "اٹکوائیں": "اٹکنا",
  "اٹکوایا": "اٹکنا",
  "اٹکی": "اٹکنا",
  "اٹکیے": "اٹکنا",
  "اٹکیں": "اٹکنا",
  "اٹیچی": "اٹیچی",
  "اٹیچیو": "اٹیچی",
  "اٹیچیوں": "اٹیچی",
  "اٹھ": "اٹھنا",
  "اٹھے": "اٹھہ",
  "اٹھں": "اٹھنا",
  "اٹھا": "اٹھنا",
  "اٹھاے": "اٹھاا",
  "اٹھاا": "اٹھاا",
  "اٹھالے": "اٹھالا",
  "اٹھالا": "اٹھالا",
  "اٹھالو": "اٹھالا",
  "اٹھالوں": "اٹھالا",
  "اٹھانے": "اٹھنا",
  "اٹھانا": "اٹھنا",
  "اٹھارا": "اٹھارا",
  "اٹھاتے": "اٹھنا",
  "اٹھاتا": "اٹھنا",
  "اٹھاتی": "اٹھنا",
  "اٹھاتیں": "اٹھنا",
  "اٹھاو": "اٹھاا",
  "اٹھاوں": "اٹھاا",
  "اٹھاؤ": "اٹھنا",
  "اٹھاؤں": "اٹھنا",
  "اٹھائے": "اٹھنا",
  "اٹھائس": "اٹھائس",
  "اٹھائی": "اٹھنا",
  "اٹھائیے": "اٹھنا",
  "اٹھائیں": "اٹھنا",
  "اٹھایا": "اٹھنا",
  "اٹھہ": "اٹھہ",
  "اٹھنے": "اٹھنا",
  "اٹھنا": "اٹھنا",
  "اٹھنی": "اٹھنا",
  "اٹھتے": "اٹھنا",
  "اٹھتا": "اٹھنا",
  "اٹھتی": "اٹھنا",
  "اٹھتیں": "اٹھنا",
  "اٹھو": "اٹھہ",
  "اٹھوں": "اٹھہ",
  "اٹھوا": "اٹھنا",
  "اٹھوانے": "اٹھنا",
  "اٹھوانا": "اٹھنا",
  "اٹھواتے": "اٹھنا",
  "اٹھواتا": "اٹھنا",
  "اٹھواتی": "اٹھنا",
  "اٹھواتیں": "اٹھنا",
  "اٹھواؤ": "اٹھنا",
  "اٹھواؤں": "اٹھنا",
  "اٹھوائے": "اٹھنا",
  "اٹھوائی": "اٹھنا",
  "اٹھوائیے": "اٹھنا",
  "اٹھوائیں": "اٹھنا",
  "اٹھوایا": "اٹھنا",
  "اٹھی": "اٹھنا",
  "اٹھیے": "اٹھنا",
  "اٹھیں": "اٹھنا",
  "اشارے": "اشارا",
  "اشارا": "اشارا",
  "اشارو": "اشارا",
  "اشاروں": "اشارا",
  "اشک": "اشک",
  "اشکو": "اشک",
  "اشکوں": "اشک",
  "اشراف": "اشراف",
  "اشرافو": "اشراف",
  "اشرافوں": "اشراف",
  "اشرفی": "اشرفی",
  "اشرفیاں": "اشرفی",
  "اشرفیو": "اشرفی",
  "اشرفیوں": "اشرفی",
  "اشتہار": "اشتہار",
  "اشتہارات": "اشتہار",
  "اشتہارو": "اشتہار",
  "اشتہاروں": "اشتہار",
  "اشتہاریں": "اشتہار",
  "اذان": "اذان",
  "اذانو": "اذان",
  "اذانوں": "اذان",
  "اذانیں": "اذان",
  "اذیت": "اذیت",
  "اذیتو": "اذیت",
  "اذیتوں": "اذیت",
  "اذیتیں": "اذیت",
  "اب": "اَب",
  "ابے": "ابا",
  "ابٹن": "ابٹن",
  "ابٹنو": "ابٹن",
  "ابٹنوں": "ابٹن",
  "ابا": "ابا",
  "ابر": "ابر",
  "ابرو": "ابرو",
  "ابروں": "ابر",
  "ابروؤ": "ابرو",
  "ابروؤں": "ابرو",
  "ابروئیں": "ابرو",
  "ابتداء": "ابتداء",
  "ابتداءو": "ابتداء",
  "ابتداءوں": "ابتداء",
  "ابتداءیں": "ابتداء",
  "ابو": "ابا",
  "ابوں": "ابا",
  "ابھار": "ابھار",
  "ابھارے": "ابھرنا",
  "ابھارں": "ابھرنا",
  "ابھارا": "ابھرنا",
  "ابھارنے": "ابھرنا",
  "ابھارنا": "ابھرنا",
  "ابھارنی": "ابھارنا",
  "ابھارتے": "ابھرنا",
  "ابھارتا": "ابھرنا",
  "ابھارتی": "ابھرنا",
  "ابھارتیں": "ابھرنا",
  "ابھارو": "ابھار",
  "ابھاروں": "ابھار",
  "ابھاری": "ابھرنا",
  "ابھاریے": "ابھرنا",
  "ابھاریں": "ابھرنا",
  "ابھر": "ابھرنا",
  "ابھرے": "ابھرنا",
  "ابھرں": "ابھرنا",
  "ابھرا": "ابھرنا",
  "ابھرنے": "ابھرنا",
  "ابھرنا": "ابھرنا",
  "ابھرنی": "ابھرنا",
  "ابھرتے": "ابھرنا",
  "ابھرتا": "ابھرنا",
  "ابھرتی": "ابھرنا",
  "ابھرتیں": "ابھرنا",
  "ابھرو": "ابھرنا",
  "ابھروں": "ابھرنا",
  "ابھروا": "ابھرنا",
  "ابھروانے": "ابھرنا",
  "ابھروانا": "ابھرنا",
  "ابھرواتے": "ابھرنا",
  "ابھرواتا": "ابھرنا",
  "ابھرواتی": "ابھرنا",
  "ابھرواتیں": "ابھرنا",
  "ابھرواؤ": "ابھرنا",
  "ابھرواؤں": "ابھرنا",
  "ابھروائے": "ابھرنا",
  "ابھروائی": "ابھرنا",
  "ابھروائیے": "ابھرنا",
  "ابھروائیں": "ابھرنا",
  "ابھروایا": "ابھرنا",
  "ابھری": "ابھرنا",
  "ابھریے": "ابھرنا",
  "ابھریں": "ابھرنا",
  "اچّھے": "اچّھا",
  "اچّھا": "اچّھا",
  "اچّھو": "اچّھا",
  "اچّھوں": "اچّھا",
  "اچک": "اچکنا",
  "اچکے": "اچکنا",
  "اچکں": "اچکنا",
  "اچکا": "اچکنا",
  "اچکانے": "اچکنا",
  "اچکانا": "اچکنا",
  "اچکاتے": "اچکنا",
  "اچکاتا": "اچکنا",
  "اچکاتی": "اچکنا",
  "اچکاتیں": "اچکنا",
  "اچکاؤ": "اچکنا",
  "اچکاؤں": "اچکنا",
  "اچکائے": "اچکنا",
  "اچکائی": "اچکنا",
  "اچکائیے": "اچکنا",
  "اچکائیں": "اچکنا",
  "اچکایا": "اچکنا",
  "اچکنے": "اچکنا",
  "اچکنا": "اچکنا",
  "اچکنی": "اچکنا",
  "اچکتے": "اچکنا",
  "اچکتا": "اچکنا",
  "اچکتی": "اچکنا",
  "اچکتیں": "اچکنا",
  "اچکو": "اچکنا",
  "اچکوں": "اچکنا",
  "اچکوا": "اچکنا",
  "اچکوانے": "اچکنا",
  "اچکوانا": "اچکنا",
  "اچکواتے": "اچکنا",
  "اچکواتا": "اچکنا",
  "اچکواتی": "اچکنا",
  "اچکواتیں": "اچکنا",
  "اچکواؤ": "اچکنا",
  "اچکواؤں": "اچکنا",
  "اچکوائے": "اچکنا",
  "اچکوائی": "اچکنا",
  "اچکوائیے": "اچکنا",
  "اچکوائیں": "اچکنا",
  "اچکوایا": "اچکنا",
  "اچکی": "اچکنا",
  "اچکیے": "اچکنا",
  "اچکیں": "اچکنا",
  "اچھّے": "اچھّا",
  "اچھّا": "اچھّا",
  "اچھّو": "اچھّا",
  "اچھّوں": "اچھّا",
  "اچھے": "اچھا",
  "اچھا": "اچھا",
  "اچھال": "اچھلنا",
  "اچھالے": "اچھلنا",
  "اچھالں": "اچھلنا",
  "اچھالا": "اچھلنا",
  "اچھالنے": "اچھلنا",
  "اچھالنا": "اچھلنا",
  "اچھالتے": "اچھلنا",
  "اچھالتا": "اچھلنا",
  "اچھالتی": "اچھلنا",
  "اچھالتیں": "اچھلنا",
  "اچھالو": "اچھلنا",
  "اچھالوں": "اچھلنا",
  "اچھالی": "اچھلنا",
  "اچھالیے": "اچھلنا",
  "اچھالیں": "اچھلنا",
  "اچھائی": "اچھائی",
  "اچھائیاں": "اچھائی",
  "اچھائیو": "اچھائی",
  "اچھائیوں": "اچھائی",
  "اچھہ": "اچھہ",
  "اچھل": "اچھلنا",
  "اچھلے": "اچھلنا",
  "اچھلں": "اچھلنا",
  "اچھلا": "اچھلنا",
  "اچھلنے": "اچھلنا",
  "اچھلنا": "اچھلنا",
  "اچھلنی": "اچھلنا",
  "اچھلتے": "اچھلنا",
  "اچھلتا": "اچھلنا",
  "اچھلتی": "اچھلنا",
  "اچھلتیں": "اچھلنا",
  "اچھلو": "اچھلنا",
  "اچھلوں": "اچھلنا",
  "اچھلوا": "اچھلنا",
  "اچھلوانے": "اچھلنا",
  "اچھلوانا": "اچھلنا",
  "اچھلواتے": "اچھلنا",
  "اچھلواتا": "اچھلنا",
  "اچھلواتی": "اچھلنا",
  "اچھلواتیں": "اچھلنا",
  "اچھلواؤ": "اچھلنا",
  "اچھلواؤں": "اچھلنا",
  "اچھلوائے": "اچھلنا",
  "اچھلوائی": "اچھلنا",
  "اچھلوائیے": "اچھلنا",
  "اچھلوائیں": "اچھلنا",
  "اچھلوایا": "اچھلنا",
  "اچھلی": "اچھلنا",
  "اچھلیے": "اچھلنا",
  "اچھلیں": "اچھلنا",
  "اچھرے": "اچھرہ",
  "اچھرہ": "اچھرہ",
  "اچھرو": "اچھرہ",
  "اچھروں": "اچھرہ",
  "اچھو": "اچھا",
  "اچھوں": "اچھا",
  "ادا": "ادا",
  "اداکار": "اداکار",
  "اداکارے": "اداکارہ",
  "اداکارہ": "اداکارہ",
  "اداکارو": "اداکارہ",
  "اداکاروں": "اداکارہ",
  "ادارے": "ادارہ",
  "ادارہ": "ادارہ",
  "ادارو": "ادارہ",
  "اداروں": "ادارہ",
  "اداس": "اداس",
  "اداسو": "اداس",
  "اداسوں": "اداس",
  "اداسی": "اداسی",
  "اداسیاں": "اداسی",
  "اداسیو": "اداسی",
  "اداسیوں": "اداسی",
  "اداؤ": "ادا",
  "اداؤں": "ادا",
  "ادائیں": "ادا",
  "ادب": "ادب",
  "ادبو": "ادب",
  "ادبوں": "ادب",
  "ادبی": "ادبی",
  "ادبیو": "ادبی",
  "ادبیوں": "ادبی",
  "ادیب": "ادیب",
  "ادیبو": "ادیب",
  "ادیبوں": "ادیب",
  "ادھر": "اُدَھر",
  "اعمالی": "اعمالی",
  "اعمالیاں": "اعمالی",
  "اعمالیو": "اعمالی",
  "اعمالیوں": "اعمالی",
  "اعتبار": "اعتبار",
  "اعتبارات": "اعتبار",
  "اعتبارو": "اعتبار",
  "اعتباروں": "اعتبار",
  "اعتدالی": "اعتدالی",
  "اعتدالیاں": "اعتدالی",
  "اعتدالیو": "اعتدالی",
  "اعتدالیوں": "اعتدالی",
  "اعتراض": "اعتراض",
  "اعتراضو": "اعتراض",
  "اعتراضوں": "اعتراض",
  "افغانی": "افغانی",
  "افغانیو": "افغانی",
  "افغانیوں": "افغانی",
  "افریقی": "افریقی",
  "افریقیو": "افریقی",
  "افریقیوں": "افریقی",
  "افسانے": "افسانہ",
  "افسانہ": "افسانہ",
  "افسانو": "افسانہ",
  "افسانوں": "افسانہ",
  "افسر": "افسر",
  "افسرو": "افسر",
  "افسروں": "افسر",
  "افواہ": "افواہ",
  "افواہو": "افواہ",
  "افواہوں": "افواہ",
  "افواہیں": "افواہ",
  "اگ": "اگنا",
  "اگے": "اگنا",
  "اگں": "اگنا",
  "اگا": "اگنا",
  "اگانے": "اگنا",
  "اگانا": "اگنا",
  "اگاتے": "اگنا",
  "اگاتا": "اگنا",
  "اگاتی": "اگنا",
  "اگاتیں": "اگنا",
  "اگاؤ": "اگنا",
  "اگاؤں": "اگنا",
  "اگائے": "اگنا",
  "اگائی": "اگنا",
  "اگائیے": "اگنا",
  "اگائیں": "اگنا",
  "اگایا": "اگنا",
  "اگل": "اگلنا",
  "اگلے": "اگلا",
  "اگلں": "اگلنا",
  "اگلا": "اگلا",
  "اگلنے": "اگلنا",
  "اگلنا": "اگلنا",
  "اگلنی": "اگلنا",
  "اگلتے": "اگلنا",
  "اگلتا": "اگلنا",
  "اگلتی": "اگلنا",
  "اگلتیں": "اگلنا",
  "اگلو": "اگلا",
  "اگلوں": "اگلا",
  "اگلوا": "اگلنا",
  "اگلوانے": "اگلنا",
  "اگلوانا": "اگلنا",
  "اگلواتے": "اگلنا",
  "اگلواتا": "اگلنا",
  "اگلواتی": "اگلنا",
  "اگلواتیں": "اگلنا",
  "اگلواؤ": "اگلنا",
  "اگلواؤں": "اگلنا",
  "اگلوائے": "اگلنا",
  "اگلوائی": "اگلنا",
  "اگلوائیے": "اگلنا",
  "اگلوائیں": "اگلنا",
  "اگلوایا": "اگلنا",
  "اگلی": "اگلنا",
  "اگلیے": "اگلنا",
  "اگلیں": "اگلنا",
  "اگنے": "اگنا",
  "اگنا": "اگنا",
  "اگنی": "اگنا",
  "اگر": "اگر",
  "اگربتی": "اگربتی",
  "اگربتیاں": "اگربتی",
  "اگربتیو": "اگربتی",
  "اگربتیوں": "اگربتی",
  "اگرچہ": "اگرچہ",
  "اگتے": "اگنا",
  "اگتا": "اگنا",
  "اگتی": "اگنا",
  "اگتیں": "اگنا",
  "اگو": "اگنا",
  "اگوں": "اگنا",
  "اگوا": "اگنا",
  "اگوانے": "اگنا",
  "اگوانا": "اگنا",
  "اگواتے": "اگنا",
  "اگواتا": "اگنا",
  "اگواتی": "اگنا",
  "اگواتیں": "اگنا",
  "اگواؤ": "اگنا",
  "اگواؤں": "اگنا",
  "اگوائے": "اگنا",
  "اگوائی": "اگنا",
  "اگوائیے": "اگنا",
  "اگوائیں": "اگنا",
  "اگوایا": "اگنا",
  "اگی": "اگنا",
  "اگیے": "اگنا",
  "اگیں": "اگنا",
  "اہلکار": "اہلکار",
  "اہلکارو": "اہلکار",
  "اہلکاروں": "اہلکار",
  "اجالے": "اجالا",
  "اجالا": "اجالا",
  "اجالو": "اجالا",
  "اجالوں": "اجالا",
  "اجلاس": "اجلاس",
  "اجلاسو": "اجلاس",
  "اجلاسوں": "اجلاس",
  "اجنبی": "اجنبی",
  "اجنبیو": "اجنبی",
  "اجنبیوں": "اجنبی",
  "اجر": "اجر",
  "اجرک": "اجرک",
  "اجرکو": "اجرک",
  "اجرکوں": "اجرک",
  "اجرو": "اجر",
  "اجروں": "اجر",
  "اک": "اک",
  "اکّ": "اکّ",
  "اکّے": "اکّا",
  "اکّا": "اکّا",
  "اکّہ": "اکّہ",
  "اکّو": "اکّا",
  "اکّوں": "اکّا",
  "اکثر": "اکثر",
  "اکثرو": "اکثر",
  "اکثروں": "اکثر",
  "اکے": "اکا",
  "اکڑ": "اکڑنا",
  "اکڑے": "اکڑنا",
  "اکڑں": "اکڑنا",
  "اکڑا": "اکڑنا",
  "اکڑنے": "اکڑنا",
  "اکڑنا": "اکڑنا",
  "اکڑنی": "اکڑنا",
  "اکڑتے": "اکڑنا",
  "اکڑتا": "اکڑنا",
  "اکڑتی": "اکڑنا",
  "اکڑتیں": "اکڑنا",
  "اکڑو": "اکڑنا",
  "اکڑوں": "اکڑنا",
  "اکڑوا": "اکڑنا",
  "اکڑوانے": "اکڑنا",
  "اکڑوانا": "اکڑنا",
  "اکڑواتے": "اکڑنا",
  "اکڑواتا": "اکڑنا",
  "اکڑواتی": "اکڑنا",
  "اکڑواتیں": "اکڑنا",
  "اکڑواؤ": "اکڑنا",
  "اکڑواؤں": "اکڑنا",
  "اکڑوائے": "اکڑنا",
  "اکڑوائی": "اکڑنا",
  "اکڑوائیے": "اکڑنا",
  "اکڑوائیں": "اکڑنا",
  "اکڑوایا": "اکڑنا",
  "اکڑی": "اکڑنا",
  "اکڑیے": "اکڑنا",
  "اکڑیں": "اکڑنا",
  "اکا": "اکا",
  "اکہ": "اکہ",
  "اکنی": "اکنی",
  "اکنیاں": "اکنی",
  "اکنیو": "اکنی",
  "اکنیوں": "اکنی",
  "اکسا": "اکسانا",
  "اکسانے": "اکسانا",
  "اکسانا": "اکسانا",
  "اکسانی": "اکسانا",
  "اکساتے": "اکسانا",
  "اکساتا": "اکسانا",
  "اکساتی": "اکسانا",
  "اکساتیں": "اکسانا",
  "اکساؤ": "اکسانا",
  "اکساؤں": "اکسانا",
  "اکسائے": "اکسانا",
  "اکسائی": "اکسانا",
  "اکسائیے": "اکسانا",
  "اکسائیں": "اکسانا",
  "اکسایا": "اکسانا",
  "اکو": "اکا",
  "اکوں": "اکا",
  "اکیس": "اکیس",
  "اکیسواں": "اکیسواں",
  "اکیسووںں": "اکیسواں",
  "اکیسویں": "اکیسواں",
  "اکھڑ": "اکھڑنا",
  "اکھڑے": "اکھڑنا",
  "اکھڑں": "اکھڑنا",
  "اکھڑا": "اکھڑنا",
  "اکھڑنے": "اکھڑنا",
  "اکھڑنا": "اکھڑنا",
  "اکھڑنی": "اکھڑنا",
  "اکھڑتے": "اکھڑنا",
  "اکھڑتا": "اکھڑنا",
  "اکھڑتی": "اکھڑنا",
  "اکھڑتیں": "اکھڑنا",
  "اکھڑو": "اکھڑنا",
  "اکھڑوں": "اکھڑنا",
  "اکھڑوا": "اکھڑنا",
  "اکھڑوانے": "اکھڑنا",
  "اکھڑوانا": "اکھڑنا",
  "اکھڑواتے": "اکھڑنا",
  "اکھڑواتا": "اکھڑنا",
  "اکھڑواتی": "اکھڑنا",
  "اکھڑواتیں": "اکھڑنا",
  "اکھڑواؤ": "اکھڑنا",
  "اکھڑواؤں": "اکھڑنا",
  "اکھڑوائے": "اکھڑنا",
  "اکھڑوائی": "اکھڑنا",
  "اکھڑوائیے": "اکھڑنا",
  "اکھڑوائیں": "اکھڑنا",
  "اکھڑوایا": "اکھڑنا",
  "اکھڑی": "اکھڑنا",
  "اکھڑیے": "اکھڑنا",
  "اکھڑیں": "اکھڑنا",
  "اکھاڑ": "اکھڑنا",
  "اکھاڑے": "اکھاڑا",
  "اکھاڑں": "اکھڑنا",
  "اکھاڑا": "اکھاڑا",
  "اکھاڑہ": "اکھاڑہ",
  "اکھاڑنے": "اکھڑنا",
  "اکھاڑنا": "اکھڑنا",
  "اکھاڑتے": "اکھڑنا",
  "اکھاڑتا": "اکھڑنا",
  "اکھاڑتی": "اکھڑنا",
  "اکھاڑتیں": "اکھڑنا",
  "اکھاڑو": "اکھاڑا",
  "اکھاڑوں": "اکھاڑا",
  "اکھاڑی": "اکھڑنا",
  "اکھاڑیے": "اکھڑنا",
  "اکھاڑیں": "اکھڑنا",
  "اکھیڑ": "اکھیڑنا",
  "اکھیڑے": "اکھیڑنا",
  "اکھیڑں": "اکھیڑنا",
  "اکھیڑا": "اکھیڑنا",
  "اکھیڑنے": "اکھیڑنا",
  "اکھیڑنا": "اکھیڑنا",
  "اکھیڑنی": "اکھیڑنا",
  "اکھیڑتے": "اکھیڑنا",
  "اکھیڑتا": "اکھیڑنا",
  "اکھیڑتی": "اکھیڑنا",
  "اکھیڑتیں": "اکھیڑنا",
  "اکھیڑو": "اکھیڑنا",
  "اکھیڑوں": "اکھیڑنا",
  "اکھیڑوا": "اکھیڑنا",
  "اکھیڑوانے": "اکھیڑنا",
  "اکھیڑوانا": "اکھیڑنا",
  "اکھیڑواتے": "اکھیڑنا",
  "اکھیڑواتا": "اکھیڑنا",
  "اکھیڑواتی": "اکھیڑنا",
  "اکھیڑواتیں": "اکھیڑنا",
  "اکھیڑواؤ": "اکھیڑنا",
  "اکھیڑواؤں": "اکھیڑنا",
  "اکھیڑوائے": "اکھیڑنا",
  "اکھیڑوائی": "اکھیڑنا",
  "اکھیڑوائیے": "اکھیڑنا",
  "اکھیڑوائیں": "اکھیڑنا",
  "اکھیڑوایا": "اکھیڑنا",
  "اکھیڑی": "اکھیڑنا",
  "اکھیڑیے": "اکھیڑنا",
  "اکھیڑیں": "اکھیڑنا",
  "الّو": "الّو",
  "الّوؤ": "الّو",
  "الّوؤں": "الّو",
  "الے": "الہ",
  "الغوزے": "الغوزہ",
  "الغوزہ": "الغوزہ",
  "الغوزو": "الغوزہ",
  "الغوزوں": "الغوزہ",
  "الٹ": "الٹنا",
  "الٹے": "الٹنا",
  "الٹں": "الٹنا",
  "الٹا": "الٹنا",
  "الٹانے": "الٹنا",
  "الٹانا": "الٹنا",
  "الٹاتے": "الٹنا",
  "الٹاتا": "الٹنا",
  "الٹاتی": "الٹنا",
  "الٹاتیں": "الٹنا",
  "الٹاؤ": "الٹنا",
  "الٹاؤں": "الٹنا",
  "الٹائے": "الٹنا",
  "الٹائی": "الٹنا",
  "الٹائیے": "الٹنا",
  "الٹائیں": "الٹنا",
  "الٹایا": "الٹنا",
  "الٹنے": "الٹنا",
  "الٹنا": "الٹنا",
  "الٹنی": "الٹنا",
  "الٹتے": "الٹنا",
  "الٹتا": "الٹنا",
  "الٹتی": "الٹنا",
  "الٹتیں": "الٹنا",
  "الٹو": "الٹنا",
  "الٹوں": "الٹنا",
  "الٹوا": "الٹنا",
  "الٹوانے": "الٹنا",
  "الٹوانا": "الٹنا",
  "الٹواتے": "الٹنا",
  "الٹواتا": "الٹنا",
  "الٹواتی": "الٹنا",
  "الٹواتیں": "الٹنا",
  "الٹواؤ": "الٹنا",
  "الٹواؤں": "الٹنا",
  "الٹوائے": "الٹنا",
  "الٹوائی": "الٹنا",
  "الٹوائیے": "الٹنا",
  "الٹوائیں": "الٹنا",
  "الٹوایا": "الٹنا",
  "الٹی": "الٹنا",
  "الٹیے": "الٹنا",
  "الٹیں": "الٹنا",
  "الاؤ": "الاؤ",
  "الائچی": "الائچی",
  "الائچیاں": "الائچی",
  "الائچیو": "الائچی",
  "الائچیوں": "الائچی",
  "البم": "البم",
  "البمو": "البم",
  "البموں": "البم",
  "البمیں": "البم",
  "الہ": "الہ",
  "الجھ": "الجھنا",
  "الجھے": "الجھنا",
  "الجھں": "الجھنا",
  "الجھا": "الجھنا",
  "الجھانے": "الجھنا",
  "الجھانا": "الجھنا",
  "الجھاتے": "الجھنا",
  "الجھاتا": "الجھنا",
  "الجھاتی": "الجھنا",
  "الجھاتیں": "الجھنا",
  "الجھاؤ": "الجھاؤ",
  "الجھاؤں": "الجھنا",
  "الجھائے": "الجھنا",
  "الجھائی": "الجھنا",
  "الجھائیے": "الجھنا",
  "الجھائیں": "الجھنا",
  "الجھایا": "الجھنا",
  "الجھن": "الجھن",
  "الجھنے": "الجھنا",
  "الجھنا": "الجھنا",
  "الجھنو": "الجھن",
  "الجھنوں": "الجھن",
  "الجھنی": "الجھنا",
  "الجھنیں": "الجھن",
  "الجھتے": "الجھنا",
  "الجھتا": "الجھنا",
  "الجھتی": "الجھنا",
  "الجھتیں": "الجھنا",
  "الجھو": "الجھنا",
  "الجھوں": "الجھنا",
  "الجھوا": "الجھنا",
  "الجھوانے": "الجھنا",
  "الجھوانا": "الجھنا",
  "الجھواتے": "الجھنا",
  "الجھواتا": "الجھنا",
  "الجھواتی": "الجھنا",
  "الجھواتیں": "الجھنا",
  "الجھواؤ": "الجھنا",
  "الجھواؤں": "الجھنا",
  "الجھوائے": "الجھنا",
  "الجھوائی": "الجھنا",
  "الجھوائیے": "الجھنا",
  "الجھوائیں": "الجھنا",
  "الجھوایا": "الجھنا",
  "الجھی": "الجھنا",
  "الجھیے": "الجھنا",
  "الجھیں": "الجھنا",
  "الماری": "الماری",
  "الماریاں": "الماری",
  "الماریو": "الماری",
  "الماریوں": "الماری",
  "المیے": "المیہ",
  "المیہ": "المیہ",
  "المیو": "المیہ",
  "المیوں": "المیہ",
  "التجا": "التجا",
  "التجاؤ": "التجا",
  "التجاؤں": "التجا",
  "التجائیں": "التجا",
  "الو": "الہ",
  "الوں": "الہ",
  "الوؤ": "الو",
  "الوؤں": "الو",
  "امّت": "امّت",
  "امّتو": "امّت",
  "امّتوں": "امّت",
  "امّتیں": "امّت",
  "امام": "امام",
  "امامے": "امامہ",
  "امامہ": "امامہ",
  "امامو": "امامہ",
  "اماموں": "امامہ",
  "امانت": "امانت",
  "امانتو": "امانت",
  "امانتوں": "امانت",
  "امانتیں": "امانت",
  "امکان": "امکان",
  "امکانات": "امکان",
  "امکانو": "امکان",
  "امکانوں": "امکان",
  "امنڈ": "امنڈنا",
  "امنڈے": "امنڈنا",
  "امنڈں": "امنڈنا",
  "امنڈا": "امنڈنا",
  "امنڈنے": "امنڈنا",
  "امنڈنا": "امنڈنا",
  "امنڈنی": "امنڈنا",
  "امنڈتے": "امنڈنا",
  "امنڈتا": "امنڈنا",
  "امنڈتی": "امنڈنا",
  "امنڈتیں": "امنڈنا",
  "امنڈو": "امنڈنا",
  "امنڈوں": "امنڈنا",
  "امنڈی": "امنڈنا",
  "امنڈیے": "امنڈنا",
  "امنڈیں": "امنڈنا",
  "امنگ": "امنگ",
  "امنگو": "امنگ",
  "امنگوں": "امنگ",
  "امنگیں": "امنگ",
  "امپائر": "امپائر",
  "امپائرو": "امپائر",
  "امپائروں": "امپائر",
  "امر": "امر",
  "امراؤ": "امراؤ",
  "امرک": "امرک",
  "امرکو": "امرک",
  "امرکوں": "امرک",
  "امروہے": "امروہہ",
  "امروہہ": "امروہہ",
  "امروہو": "امروہہ",
  "امروہوں": "امروہہ",
  "امریکہ": "امریکہ",
  "امریکی": "امریکی",
  "امریکیو": "امریکی",
  "امریکیوں": "امریکی",
  "امت": "امت",
  "امتّ": "امتّ",
  "امتّو": "امتّ",
  "امتّوں": "امتّ",
  "امتّیں": "امتّ",
  "امتحان": "امتحان",
  "امتحانات": "امتحان",
  "امتحانو": "امتحان",
  "امتحانوں": "امتحان",
  "امتو": "امت",
  "امتوں": "امت",
  "امتیں": "امت",
  "امی": "امی",
  "امیاں": "امی",
  "امید": "امید",
  "امیدو": "امید",
  "امیدوں": "امید",
  "امیدوار": "امیدوار",
  "امیدوارو": "امیدوار",
  "امیدواروں": "امیدوار",
  "امیدیں": "امید",
  "امیر": "امیر",
  "امیرو": "امیر",
  "امیروں": "امیر",
  "امیو": "امی",
  "امیوں": "امی",
  "ان": "میں",
  "انڈے": "انڈا",
  "انڈا": "انڈا",
  "انڈہ": "انڈہ",
  "انڈو": "انڈا",
  "انڈوں": "انڈا",
  "انشائیے": "انشائیہ",
  "انشائیہ": "انشائیہ",
  "انشائیو": "انشائیہ",
  "انشائیوں": "انشائیہ",
  "انار": "انار",
  "انارو": "انار",
  "اناروں": "انار",
  "اناریں": "انار",
  "انداز": "انداز",
  "اندازے": "اندازہ",
  "اندازہ": "اندازہ",
  "اندازو": "اندازہ",
  "اندازوں": "اندازہ",
  "اندازی": "اندازی",
  "اندازیاں": "اندازی",
  "اندازیو": "اندازی",
  "اندازیوں": "اندازی",
  "اندر": "اندر",
  "اندرو": "اندر",
  "اندروں": "اندر",
  "اندیشے": "اندیشا",
  "اندیشا": "اندیشا",
  "اندیشہ": "اندیشہ",
  "اندیشو": "اندیشا",
  "اندیشوں": "اندیشا",
  "اندھے": "اندھا",
  "اندھا": "اندھا",
  "اندھو": "اندھا",
  "اندھوں": "اندھا",
  "اندھیر": "اندھیر",
  "اندھیرے": "اندھیرا",
  "اندھیرا": "اندھیرا",
  "اندھیرو": "اندھیرا",
  "اندھیروں": "اندھیرا",
  "اندھیری": "اندھیری",
  "اندھیریاں": "اندھیری",
  "اندھیریو": "اندھیری",
  "اندھیریوں": "اندھیری",
  "انگڑائی": "انگڑائی",
  "انگڑائیاں": "انگڑائی",
  "انگڑائیو": "انگڑائی",
  "انگڑائیوں": "انگڑائی",
  "انگار": "انگار",
  "انگارے": "انگارا",
  "انگارا": "انگارا",
  "انگارہ": "انگارہ",
  "انگارو": "انگارا",
  "انگاروں": "انگارا",
  "انگل": "انگل",
  "انگلو": "انگل",
  "انگلوں": "انگل",
  "انگلی": "انگلی",
  "انگلیاں": "انگلی",
  "انگلیو": "انگلی",
  "انگلیوں": "انگلی",
  "انگریز": "انگریز",
  "انگریزو": "انگریز",
  "انگریزوں": "انگریز",
  "انگوٹھے": "انگوٹھا",
  "انگوٹھا": "انگوٹھا",
  "انگوٹھو": "انگوٹھا",
  "انگوٹھوں": "انگوٹھا",
  "انگوٹھی": "انگوٹھی",
  "انگوٹھیاں": "انگوٹھی",
  "انگوٹھیو": "انگوٹھی",
  "انگوٹھیوں": "انگوٹھی",
  "انگور": "انگور",
  "انگورو": "انگور",
  "انگوروں": "انگور",
  "انگوریں": "انگور",
  "انگیٹھی": "انگیٹھی",
  "انگیٹھیاں": "انگیٹھی",
  "انگیٹھیو": "انگیٹھی",
  "انگیٹھیوں": "انگیٹھی",
  "انجمن": "انجمن",
  "انجمنو": "انجمن",
  "انجمنوں": "انجمن",
  "انجمنیں": "انجمن",
  "انجن": "انجن",
  "انجنو": "انجن",
  "انجنوں": "انجن",
  "انجینئر": "انجینئر",
  "انجینئرو": "انجینئر",
  "انجینئروں": "انجینئر",
  "انقلاب": "انقلاب",
  "انقلابو": "انقلاب",
  "انقلابوں": "انقلاب",
  "انقلابی": "انقلابی",
  "انقلابیو": "انقلابی",
  "انقلابیوں": "انقلابی",
  "انسان": "انسان",
  "انسانو": "انسان",
  "انسانوں": "انسان",
  "انسپکٹر": "انسپکٹر",
  "انسپکٹرو": "انسپکٹر",
  "انسپکٹروں": "انسپکٹر",
  "انتخاب": "انتخاب",
  "انتخابو": "انتخاب",
  "انتخابوں": "انتخاب",
  "انتساب": "انتساب",
  "انتسابو": "انتساب",
  "انتسابوں": "انتساب",
  "انتیس": "انتیس",
  "انتظارکر": "انتظارکر",
  "انتظارکرو": "انتظارکر",
  "انتظارکروں": "انتظارکر",
  "انی": "انی",
  "انیاں": "انی",
  "انین": "انین",
  "انیو": "انی",
  "انیوں": "انی",
  "اپنے": "اپنا",
  "اپنےآپ": "اَپْنےآپ",
  "اپنےاپنےگھر": "اپنےاپنےگھر",
  "اپنےاپنےگھرو": "اپنےاپنےگھر",
  "اپنےاپنےگھروں": "اپنےاپنےگھر",
  "اپنےگھر": "اپنےگھر",
  "اپنےگھرو": "اپنےگھر",
  "اپنےگھروں": "اپنےگھر",
  "اپنا": "اپنا",
  "اپنانے": "اپنانا",
  "اپنانا": "اپنانا",
  "اپنانی": "اپنانا",
  "اپناتے": "اپنانا",
  "اپناتا": "اپنانا",
  "اپناتی": "اپنانا",
  "اپناتیں": "اپنانا",
  "اپناؤ": "اپنانا",
  "اپناؤں": "اپنانا",
  "اپنائے": "اپنانا",
  "اپنائی": "اپنانا",
  "اپنائیے": "اپنانا",
  "اپنائیں": "اپنانا",
  "اپنایا": "اپنانا",
  "اپنو": "اپنا",
  "اپنوں": "اپنا",
  "ارے": "ارے",
  "ارادے": "ارادہ",
  "ارادہ": "ارادہ",
  "ارادو": "ارادہ",
  "ارادوں": "ارادہ",
  "ارمان": "ارمان",
  "ارمانو": "ارمان",
  "ارمانوں": "ارمان",
  "اس": "میں",
  "اسٹاپ": "اسٹاپ",
  "اسٹاپو": "اسٹاپ",
  "اسٹاپوں": "اسٹاپ",
  "اسٹاپیں": "اسٹاپ",
  "اسٹول": "اسٹول",
  "اسٹولو": "اسٹول",
  "اسٹولوں": "اسٹول",
  "اسٹولیں": "اسٹول",
  "اسٹیشن": "اسٹیشن",
  "اسٹیشنو": "اسٹیشن",
  "اسٹیشنوں": "اسٹیشن",
  "اسٹیشنیں": "اسٹیشن",
  "اسکے": "میرا",
  "اسکا": "میرا",
  "اسکالر": "اسکالر",
  "اسکالرو": "اسکالر",
  "اسکالروں": "اسکالر",
  "اسکول": "اسکول",
  "اسکولو": "اسکول",
  "اسکولوں": "اسکول",
  "اسکولیں": "اسکول",
  "اسکی": "میرا",
  "اسل": "اسل",
  "اسلحے": "اسلحہ",
  "اسلحہ": "اسلحہ",
  "اسلحو": "اسلحہ",
  "اسلحوں": "اسلحہ",
  "اسلو": "اسل",
  "اسلوں": "اسل",
  "اسماء": "اسماء",
  "اسماءو": "اسماء",
  "اسماءوں": "اسماء",
  "اسماءیں": "اسماء",
  "اسمبلی": "اسمبلی",
  "اسمبلیاں": "اسمبلی",
  "اسمبلیو": "اسمبلی",
  "اسمبلیوں": "اسمبلی",
  "اسپیچ": "اسپیچ",
  "اسپیچو": "اسپیچ",
  "اسپیچوں": "اسپیچ",
  "اسرائیلی": "اسرائیلی",
  "اسرائیلیو": "اسرائیلی",
  "اسرائیلیوں": "اسرائیلی",
  "استاد": "استاد",
  "استادے": "استادہ",
  "استادہ": "استادہ",
  "استادو": "استادہ",
  "استادوں": "استادہ",
  "استعارے": "استعارہ",
  "استعارہ": "استعارہ",
  "استعارو": "استعارہ",
  "استعاروں": "استعارہ",
  "استقبالیے": "استقبالیہ",
  "استقبالیہ": "استقبالیہ",
  "استقبالیو": "استقبالیہ",
  "استقبالیوں": "استقبالیہ",
  "اسیر": "اسیر",
  "اسیرو": "اسیر",
  "اسیروں": "اسیر",
  "اتحادی": "اتحادی",
  "اتحادیو": "اتحادی",
  "اتحادیوں": "اتحادی",
  "اتار": "اترنا",
  "اتارے": "اترنا",
  "اتارں": "اترنا",
  "اتارا": "اترنا",
  "اتارنے": "اترنا",
  "اتارنا": "اترنا",
  "اتارتے": "اترنا",
  "اتارتا": "اترنا",
  "اتارتی": "اترنا",
  "اتارتیں": "اترنا",
  "اتارو": "اترنا",
  "اتاروں": "اترنا",
  "اتاری": "اترنا",
  "اتاریے": "اترنا",
  "اتاریں": "اترنا",
  "اتنے": "اِتنا",
  "اتنا": "اِتنا",
  "اتنی": "اِتنا",
  "اتر": "اتر",
  "اترے": "اترنا",
  "اترں": "اترنا",
  "اترا": "اترانا",
  "اترانے": "اترانا",
  "اترانا": "اترانا",
  "اترانی": "اترانا",
  "اتراتے": "اترانا",
  "اتراتا": "اترانا",
  "اتراتی": "اترانا",
  "اتراتیں": "اترانا",
  "اتراؤ": "اترانا",
  "اتراؤں": "اترانا",
  "اترائے": "اترانا",
  "اترائی": "اترانا",
  "اترائیے": "اترانا",
  "اترائیں": "اترانا",
  "اترایا": "اترانا",
  "اترنے": "اترنا",
  "اترنا": "اترنا",
  "اترنی": "اترنا",
  "اترتے": "اترنا",
  "اترتا": "اترنا",
  "اترتی": "اترنا",
  "اترتیں": "اترنا",
  "اترو": "اتر",
  "اتروں": "اتر",
  "اتروا": "اترنا",
  "اتروانے": "اترنا",
  "اتروانا": "اترنا",
  "اترواتے": "اترنا",
  "اترواتا": "اترنا",
  "اترواتی": "اترنا",
  "اترواتیں": "اترنا",
  "اترواؤ": "اترنا",
  "اترواؤں": "اترنا",
  "اتروائے": "اترنا",
  "اتروائی": "اترنا",
  "اتروائیے": "اترنا",
  "اتروائیں": "اترنا",
  "اتروایا": "اترنا",
  "اتری": "اترنا",
  "اتریے": "اترنا",
  "اتریں": "اترنا",
  "او": "او",
  "اوڑھ": "اوڑھنا",
  "اوڑھے": "اوڑھنا",
  "اوڑھں": "اوڑھنا",
  "اوڑھا": "اوڑھنا",
  "اوڑھانے": "اوڑھنا",
  "اوڑھانا": "اوڑھنا",
  "اوڑھاتے": "اوڑھنا",
  "اوڑھاتا": "اوڑھنا",
  "اوڑھاتی": "اوڑھنا",
  "اوڑھاتیں": "اوڑھنا",
  "اوڑھاؤ": "اوڑھنا",
  "اوڑھاؤں": "اوڑھنا",
  "اوڑھائے": "اوڑھنا",
  "اوڑھائی": "اوڑھنا",
  "اوڑھائیے": "اوڑھنا",
  "اوڑھائیں": "اوڑھنا",
  "اوڑھایا": "اوڑھنا",
  "اوڑھنے": "اوڑھنا",
  "اوڑھنا": "اوڑھنا",
  "اوڑھنی": "اوڑھنی",
  "اوڑھنیاں": "اوڑھنی",
  "اوڑھنیو": "اوڑھنی",
  "اوڑھنیوں": "اوڑھنی",
  "اوڑھتے": "اوڑھنا",
  "اوڑھتا": "اوڑھنا",
  "اوڑھتی": "اوڑھنا",
  "اوڑھتیں": "اوڑھنا",
  "اوڑھو": "اوڑھنا",
  "اوڑھوں": "اوڑھنا",
  "اوڑھی": "اوڑھنا",
  "اوڑھیے": "اوڑھنا",
  "اوڑھیں": "اوڑھنا",
  "اودے": "اودا",
  "اودا": "اودا",
  "اودو": "اودا",
  "اودوں": "اودا",
  "اوہو": "اوہو",
  "اول": "اول",
  "اولے": "اولا",
  "اولا": "اولا",
  "اولاد": "اولاد",
  "اولادو": "اولاد",
  "اولادوں": "اولاد",
  "اولادیں": "اولاد",
  "اولو": "اولا",
  "اولوں": "اولا",
  "اونٹ": "اونٹ",
  "اونٹنی": "اونٹنی",
  "اونٹنیاں": "اونٹنی",
  "اونٹنیو": "اونٹنی",
  "اونٹنیوں": "اونٹنی",
  "اونٹو": "اونٹ",
  "اونٹوں": "اونٹ",
  "اونٹیں": "اونٹ",
  "اونگھ": "اونگھنا",
  "اونگھے": "اونگھنا",
  "اونگھں": "اونگھنا",
  "اونگھا": "اونگھنا",
  "اونگھنے": "اونگھنا",
  "اونگھنا": "اونگھنا",
  "اونگھنی": "اونگھنا",
  "اونگھتے": "اونگھنا",
  "اونگھتا": "اونگھنا",
  "اونگھتی": "اونگھنا",
  "اونگھتیں": "اونگھنا",
  "اونگھو": "اونگھنا",
  "اونگھوں": "اونگھنا",
  "اونگھی": "اونگھنا",
  "اونگھیے": "اونگھنا",
  "اونگھیں": "اونگھنا",
  "اور": "اور",
  "اوربان": "اوربان",
  "اوربانو": "اوربان",
  "اوربانوں": "اوربان",
  "اوربات": "اوربات",
  "اورباتو": "اوربات",
  "اورباتوں": "اوربات",
  "اورباتیں": "اوربات",
  "اوردوست": "اوردوست",
  "اوردوستو": "اوردوست",
  "اوردوستوں": "اوردوست",
  "اورو": "اور",
  "اوروں": "اور",
  "اوزار": "اوزار",
  "اوزارو": "اوزار",
  "اوزاروں": "اوزار",
  "اوزاریں": "اوزار",
  "ایثار": "ایثار",
  "ایثارو": "ایثار",
  "ایثاروں": "ایثار",
  "ایثاریں": "ایثار",
  "ایڑی": "ایڑی",
  "ایڑیاں": "ایڑی",
  "ایڑیو": "ایڑی",
  "ایڑیوں": "ایڑی",
  "ایش": "ایش",
  "ایشائی": "ایشائی",
  "ایشائیو": "ایشائی",
  "ایشائیوں": "ایشائی",
  "ایشو": "ایش",
  "ایشوں": "ایش",
  "ایشیں": "ایش",
  "ایجاد": "ایجاد",
  "ایجادو": "ایجاد",
  "ایجادوں": "ایجاد",
  "ایجادیں": "ایجاد",
  "ایجنڈے": "ایجنڈہ",
  "ایجنڈہ": "ایجنڈہ",
  "ایجنڈو": "ایجنڈہ",
  "ایجنڈوں": "ایجنڈہ",
  "ایجنٹ": "ایجنٹ",
  "ایجنٹو": "ایجنٹ",
  "ایجنٹوں": "ایجنٹ",
  "ایجنسی": "ایجنسی",
  "ایجنسیاں": "ایجنسی",
  "ایجنسیو": "ایجنسی",
  "ایجنسیوں": "ایجنسی",
  "ایک": "ایک",
  "ایکے": "ایکا",
  "ایکٹر": "ایکٹر",
  "ایکٹرس": "ایکٹرس",
  "ایکٹرسو": "ایکٹرس",
  "ایکٹرسوں": "ایکٹرس",
  "ایکٹرسیں": "ایکٹرس",
  "ایکٹرو": "ایکٹر",
  "ایکٹروں": "ایکٹر",
  "ایکا": "ایکا",
  "ایکہ": "ایکہ",
  "ایکو": "ایکا",
  "ایکوں": "ایکا",
  "اینٹ": "اینٹ",
  "اینٹو": "اینٹ",
  "اینٹوں": "اینٹ",
  "اینٹیں": "اینٹ",
  "اینگل": "اینگل",
  "اینگلو": "اینگل",
  "اینگلوں": "اینگل",
  "ایرپورٹ": "ایرپورٹ",
  "ایرپورٹو": "ایرپورٹ",
  "ایرپورٹوں": "ایرپورٹ",
  "ایسے": "ایسا",
  "ایسا": "ایسا",
  "ایسو": "ایسا",
  "ایسوں": "ایسا",
  "ایسی": "اَیسا",
  "ایوان": "ایوان",
  "ایوانو": "ایوان",
  "ایوانوں": "ایوان",
  "ازالے": "ازالہ",
  "ازالہ": "ازالہ",
  "ازالو": "ازالہ",
  "ازالوں": "ازالہ",
  "ازما": "ازمانا",
  "ازمانے": "ازمانا",
  "ازمانا": "ازمانا",
  "ازمانی": "ازمانا",
  "ازماتے": "ازمانا",
  "ازماتا": "ازمانا",
  "ازماتی": "ازمانا",
  "ازماتیں": "ازمانا",
  "ازماؤ": "ازمانا",
  "ازماؤں": "ازمانا",
  "ازمائے": "ازمانا",
  "ازمائی": "ازمانا",
  "ازمائیے": "ازمانا",
  "ازمائیں": "ازمانا",
  "ازمایا": "ازمانا",
  "اضافے": "اضافہ",
  "اضافہ": "اضافہ",
  "اضافو": "اضافہ",
  "اضافوں": "اضافہ",
  "بٍک": "بٍکنا",
  "بٍکے": "بٍکنا",
  "بٍکں": "بٍکنا",
  "بٍکا": "بٍکنا",
  "بٍکانے": "بٍکنا",
  "بٍکانا": "بٍکنا",
  "بٍکاتے": "بٍکنا",
  "بٍکاتا": "بٍکنا",
  "بٍکاتی": "بٍکنا",
  "بٍکاتیں": "بٍکنا",
  "بٍکاؤ": "بٍکنا",
  "بٍکاؤں": "بٍکنا",
  "بٍکائے": "بٍکنا",
  "بٍکائی": "بٍکنا",
  "بٍکائیے": "بٍکنا",
  "بٍکائیں": "بٍکنا",
  "بٍکایا": "بٍکنا",
  "بٍکنے": "بٍکنا",
  "بٍکنا": "بٍکنا",
  "بٍکنی": "بٍکنا",
  "بٍکتے": "بٍکنا",
  "بٍکتا": "بٍکنا",
  "بٍکتی": "بٍکنا",
  "بٍکتیں": "بٍکنا",
  "بٍکو": "بٍکنا",
  "بٍکوں": "بٍکنا",
  "بٍکوا": "بٍکنا",
  "بٍکوانے": "بٍکنا",
  "بٍکوانا": "بٍکنا",
  "بٍکواتے": "بٍکنا",
  "بٍکواتا": "بٍکنا",
  "بٍکواتی": "بٍکنا",
  "بٍکواتیں": "بٍکنا",
  "بٍکواؤ": "بٍکنا",
  "بٍکواؤں": "بٍکنا",
  "بٍکوائے": "بٍکنا",
  "بٍکوائی": "بٍکنا",
  "بٍکوائیے": "بٍکنا",
  "بٍکوائیں": "بٍکنا",
  "بٍکوایا": "بٍکنا",
  "بٍکی": "بٍکنا",
  "بٍکیے": "بٍکنا",
  "بٍکیں": "بٍکنا",
  "بَے": "بَد",
  "بَد": "بَد",
  "بَدتَر": "بَد",
  "بَدتَرین": "بَد",
  "بَدتر": "بَد",
  "بَدترین": "بَد",
  "بَعْض": "بَعْض",
  "بَہُت": "بَہُت",
  "بَل": "بَل",
  "بَلا": "بَلا",
  "بَلاؤ": "بَلا",
  "بَلاؤں": "بَلا",
  "بَلائیں": "بَلا",
  "بَلو": "بَل",
  "بَلوں": "بَل",
  "بَی": "بَد",
  "بَیٹْھ": "بَیٹْھنا",
  "بَیٹْھے": "بَیٹْھنا",
  "بَیٹْھں": "بَیٹْھنا",
  "بَیٹْھا": "بَیٹْھنا",
  "بَیٹْھنے": "بَیٹْھنا",
  "بَیٹْھنا": "بَیٹْھنا",
  "بَیٹْھنی": "بَیٹْھنا",
  "بَیٹْھتے": "بَیٹْھنا",
  "بَیٹْھتا": "بَیٹْھنا",
  "بَیٹْھتی": "بَیٹْھنا",
  "بَیٹْھتیں": "بَیٹْھنا",
  "بَیٹْھو": "بَیٹْھنا",
  "بَیٹْھوں": "بَیٹْھنا",
  "بَیٹْھی": "بَیٹْھنا",
  "بَیٹْھیے": "بَیٹْھنا",
  "بَیٹْھیں": "بَیٹْھنا",
  "بِٹْھا": "بَیٹْھنا",
  "بِٹْھانے": "بَیٹْھنا",
  "بِٹْھانا": "بَیٹْھنا",
  "بِٹْھاتے": "بَیٹْھنا",
  "بِٹْھاتا": "بَیٹْھنا",
  "بِٹْھاتی": "بَیٹْھنا",
  "بِٹْھاتیں": "بَیٹْھنا",
  "بِٹْھاؤ": "بَیٹْھنا",
  "بِٹْھاؤں": "بَیٹْھنا",
  "بِٹْھائے": "بَیٹْھنا",
  "بِٹْھائی": "بَیٹْھنا",
  "بِٹْھائیے": "بَیٹْھنا",
  "بِٹْھائیں": "بَیٹْھنا",
  "بِٹْھایا": "بَیٹْھنا",
  "بِٹْھوا": "بَیٹْھنا",
  "بِٹْھوانے": "بَیٹْھنا",
  "بِٹْھوانا": "بَیٹْھنا",
  "بِٹْھواتے": "بَیٹْھنا",
  "بِٹْھواتا": "بَیٹْھنا",
  "بِٹْھواتی": "بَیٹْھنا",
  "بِٹْھواتیں": "بَیٹْھنا",
  "بِٹْھواؤ": "بَیٹْھنا",
  "بِٹْھواؤں": "بَیٹْھنا",
  "بِٹْھوائے": "بَیٹْھنا",
  "بِٹْھوائی": "بَیٹْھنا",
  "بِٹْھوائیے": "بَیٹْھنا",
  "بِٹْھوائیں": "بَیٹْھنا",
  "بِٹْھوایا": "بَیٹْھنا",
  "بِچارے": "بِچارہ",
  "بِچارہ": "بِچارہ",
  "بِچارو": "بِچارہ",
  "بِچاروں": "بِچارہ",
  "بِدک": "بِدکنا",
  "بِدکے": "بِدکنا",
  "بِدکں": "بِدکنا",
  "بِدکا": "بِدکنا",
  "بِدکانے": "بِدکنا",
  "بِدکانا": "بِدکنا",
  "بِدکاتے": "بِدکنا",
  "بِدکاتا": "بِدکنا",
  "بِدکاتی": "بِدکنا",
  "بِدکاتیں": "بِدکنا",
  "بِدکاؤ": "بِدکنا",
  "بِدکاؤں": "بِدکنا",
  "بِدکائے": "بِدکنا",
  "بِدکائی": "بِدکنا",
  "بِدکائیے": "بِدکنا",
  "بِدکائیں": "بِدکنا",
  "بِدکایا": "بِدکنا",
  "بِدکنے": "بِدکنا",
  "بِدکنا": "بِدکنا",
  "بِدکنی": "بِدکنا",
  "بِدکتے": "بِدکنا",
  "بِدکتا": "بِدکنا",
  "بِدکتی": "بِدکنا",
  "بِدکتیں": "بِدکنا",
  "بِدکو": "بِدکنا",
  "بِدکوں": "بِدکنا",
  "بِدکوا": "بِدکنا",
  "بِدکوانے": "بِدکنا",
  "بِدکوانا": "بِدکنا",
  "بِدکواتے": "بِدکنا",
  "بِدکواتا": "بِدکنا",
  "بِدکواتی": "بِدکنا",
  "بِدکواتیں": "بِدکنا",
  "بِدکواؤ": "بِدکنا",
  "بِدکواؤں": "بِدکنا",
  "بِدکوائے": "بِدکنا",
  "بِدکوائی": "بِدکنا",
  "بِدکوائیے": "بِدکنا",
  "بِدکوائیں": "بِدکنا",
  "بِدکوایا": "بِدکنا",
  "بِدکی": "بِدکنا",
  "بِدکیے": "بِدکنا",
  "بِدکیں": "بِدکنا",
  "بِہ": "بِہ",
  "بِہتَر": "بِہ",
  "بِہتَرین": "بِہ",
  "بِہتر": "بِہ",
  "بِہترین": "بِہ",
  "بِھیگ": "بِھیگْنا",
  "بِھیگْں": "بِھیگْنا",
  "بِھیگْنے": "بِھیگْنا",
  "بِھیگْنا": "بِھیگْنا",
  "بِھیگْنی": "بِھیگْنا",
  "بِھیگْتے": "بِھیگْنا",
  "بِھیگْتا": "بِھیگْنا",
  "بِھیگْتی": "بِھیگْنا",
  "بِھیگْتیں": "بِھیگْنا",
  "بِھیگْوا": "بِھیگْنا",
  "بِھیگْوانے": "بِھیگْنا",
  "بِھیگْوانا": "بِھیگْنا",
  "بِھیگْواتے": "بِھیگْنا",
  "بِھیگْواتا": "بِھیگْنا",
  "بِھیگْواتی": "بِھیگْنا",
  "بِھیگْواتیں": "بِھیگْنا",
  "بِھیگْواؤ": "بِھیگْنا",
  "بِھیگْواؤں": "بِھیگْنا",
  "بِھیگْوائے": "بِھیگْنا",
  "بِھیگْوائی": "بِھیگْنا",
  "بِھیگْوائیے": "بِھیگْنا",
  "بِھیگْوائیں": "بِھیگْنا",
  "بِھیگْوایا": "بِھیگْنا",
  "بِھیگے": "بِھیگْنا",
  "بِھیگا": "بِھیگْنا",
  "بِھیگو": "بِھیگْنا",
  "بِھیگوں": "بِھیگْنا",
  "بِھیگی": "بِھیگْنا",
  "بِھیگیے": "بِھیگْنا",
  "بِھیگیں": "بِھیگْنا",
  "بُڑْھیا": "بُڑْھیا",
  "بُڑْھیاں": "بُڑْھیا",
  "بُڑْھیو": "بُڑْھیا",
  "بُڑْھیوں": "بُڑْھیا",
  "بُشرہ": "بُشرہ",
  "بُلْوا": "بولْنا",
  "بُلْوانے": "بولْنا",
  "بُلْوانا": "بولْنا",
  "بُلْواتے": "بولْنا",
  "بُلْواتا": "بولْنا",
  "بُلْواتی": "بولْنا",
  "بُلْواتیں": "بولْنا",
  "بُلْواؤ": "بولْنا",
  "بُلْواؤں": "بولْنا",
  "بُلْوائے": "بولْنا",
  "بُلْوائی": "بولْنا",
  "بُلْوائیے": "بولْنا",
  "بُلْوائیں": "بولْنا",
  "بُلْوایا": "بولْنا",
  "بُلا": "بولْنا",
  "بُلانے": "بولْنا",
  "بُلانا": "بولْنا",
  "بُلانی": "بُلانا",
  "بُلاتے": "بولْنا",
  "بُلاتا": "بولْنا",
  "بُلاتی": "بولْنا",
  "بُلاتیں": "بولْنا",
  "بُلاؤ": "بولْنا",
  "بُلاؤں": "بولْنا",
  "بُلائے": "بولْنا",
  "بُلائی": "بولْنا",
  "بُلائیے": "بولْنا",
  "بُلائیں": "بولْنا",
  "بُلایا": "بولْنا",
  "بُلوا": "بُلانا",
  "بُلوانے": "بُلانا",
  "بُلوانا": "بُلانا",
  "بُلواتے": "بُلانا",
  "بُلواتا": "بُلانا",
  "بُلواتی": "بُلانا",
  "بُلواتیں": "بُلانا",
  "بُلواؤ": "بُلانا",
  "بُلواؤں": "بُلانا",
  "بُلوائے": "بُلانا",
  "بُلوائی": "بُلانا",
  "بُلوائیے": "بُلانا",
  "بُلوائیں": "بُلانا",
  "بُلوایا": "بُلانا",
  "بُرْقَع": "بُرْقَع",
  "بُرْقَعے": "بُرْقَع",
  "بُرْقَعو": "بُرْقَع",
  "بُرْقَعوں": "بُرْقَع",
  "بُرے": "بُرا",
  "بُرا": "بُرا",
  "بُرو": "بُرا",
  "بُروں": "بُرا",
  "بُری": "بُرا",
  "بُزرگ": "بُزرگ",
  "بُزرگو": "بُزرگ",
  "بُزرگوں": "بُزرگ",
  "بُھول": "بُھول",
  "بُھولو": "بُھول",
  "بُھولوں": "بُھول",
  "بُھولیں": "بُھول",
  "بڈھے": "بڈھا",
  "بڈھا": "بڈھا",
  "بڈھو": "بڈھا",
  "بڈھوں": "بڈھا",
  "بے": "بد",
  "بےچارے": "بےچارہ",
  "بےچارہ": "بےچارہ",
  "بےچارو": "بےچارہ",
  "بےچاروں": "بےچارہ",
  "بغل": "بغل",
  "بغلو": "بغل",
  "بغلوں": "بغل",
  "بغلیں": "بغل",
  "بحث": "بحث",
  "بحثو": "بحث",
  "بحثوں": "بحث",
  "بحثیں": "بحث",
  "بحر": "بحر",
  "بحرو": "بحر",
  "بحروں": "بحر",
  "بحریں": "بحر",
  "بخش": "بخشنا",
  "بخشے": "بخشنا",
  "بخشں": "بخشنا",
  "بخشش": "بخشش",
  "بخششو": "بخشش",
  "بخششوں": "بخشش",
  "بخششیں": "بخشش",
  "بخشا": "بخشنا",
  "بخشانے": "بخشنا",
  "بخشانا": "بخشنا",
  "بخشاتے": "بخشنا",
  "بخشاتا": "بخشنا",
  "بخشاتی": "بخشنا",
  "بخشاتیں": "بخشنا",
  "بخشاؤ": "بخشنا",
  "بخشاؤں": "بخشنا",
  "بخشائے": "بخشنا",
  "بخشائی": "بخشنا",
  "بخشائیے": "بخشنا",
  "بخشائیں": "بخشنا",
  "بخشایا": "بخشنا",
  "بخشنے": "بخشنا",
  "بخشنا": "بخشنا",
  "بخشنی": "بخشنا",
  "بخشتے": "بخشنا",
  "بخشتا": "بخشنا",
  "بخشتی": "بخشنا",
  "بخشتیں": "بخشنا",
  "بخشو": "بخشنا",
  "بخشوں": "بخشنا",
  "بخشوا": "بخشنا",
  "بخشوانے": "بخشنا",
  "بخشوانا": "بخشنا",
  "بخشواتے": "بخشنا",
  "بخشواتا": "بخشنا",
  "بخشواتی": "بخشنا",
  "بخشواتیں": "بخشنا",
  "بخشواؤ": "بخشنا",
  "بخشواؤں": "بخشنا",
  "بخشوائے": "بخشنا",
  "بخشوائی": "بخشنا",
  "بخشوائیے": "بخشنا",
  "بخشوائیں": "بخشنا",
  "بخشوایا": "بخشنا",
  "بخشی": "بخشنا",
  "بخشیے": "بخشنا",
  "بخشیں": "بخشنا",
  "بخار": "بخار",
  "بخارات": "بخار",
  "بخارو": "بخار",
  "بخاروں": "بخار",
  "بخر": "بخر",
  "بخرو": "بخر",
  "بخروں": "بخر",
  "بخت": "بخت",
  "بختو": "بخت",
  "بختوں": "بخت",
  "بختی": "بختی",
  "بختیں": "بخت",
  "بختیاں": "بختی",
  "بختیو": "بختی",
  "بختیوں": "بختی",
  "بخیے": "بخیہ",
  "بخیہ": "بخیہ",
  "بخیو": "بخیہ",
  "بخیوں": "بخیہ",
  "بڑے": "بڑا",
  "بڑا": "بڑا",
  "بڑائی": "بڑائی",
  "بڑائیاں": "بڑائی",
  "بڑائیو": "بڑائی",
  "بڑائیوں": "بڑائی",
  "بڑبڑا": "بڑبڑانا",
  "بڑبڑانے": "بڑبڑانا",
  "بڑبڑانا": "بڑبڑانا",
  "بڑبڑانی": "بڑبڑانا",
  "بڑبڑاتے": "بڑبڑانا",
  "بڑبڑاتا": "بڑبڑانا",
  "بڑبڑاتی": "بڑبڑانا",
  "بڑبڑاتیں": "بڑبڑانا",
  "بڑبڑاؤ": "بڑبڑانا",
  "بڑبڑاؤں": "بڑبڑانا",
  "بڑبڑائے": "بڑبڑانا",
  "بڑبڑائی": "بڑبڑانا",
  "بڑبڑائیے": "بڑبڑانا",
  "بڑبڑائیں": "بڑبڑانا",
  "بڑبڑایا": "بڑبڑانا",
  "بڑو": "بڑا",
  "بڑوں": "بڑا",
  "بڑی": "بڑی",
  "بڑیاں": "بڑی",
  "بڑیو": "بڑی",
  "بڑیوں": "بڑی",
  "بڑھ": "بڑھنا",
  "بڑھے": "بڑھنا",
  "بڑھں": "بڑھنا",
  "بڑھا": "بڑھنا",
  "بڑھانے": "بڑھنا",
  "بڑھانا": "بڑھنا",
  "بڑھاتے": "بڑھنا",
  "بڑھاتا": "بڑھنا",
  "بڑھاتی": "بڑھنا",
  "بڑھاتیں": "بڑھنا",
  "بڑھاؤ": "بڑھنا",
  "بڑھاؤں": "بڑھنا",
  "بڑھائے": "بڑھنا",
  "بڑھائی": "بڑھنا",
  "بڑھائیے": "بڑھنا",
  "بڑھائیں": "بڑھنا",
  "بڑھایا": "بڑھنا",
  "بڑھنے": "بڑھنا",
  "بڑھنا": "بڑھنا",
  "بڑھنی": "بڑھنا",
  "بڑھتے": "بڑھنا",
  "بڑھتا": "بڑھنا",
  "بڑھتی": "بڑھنا",
  "بڑھتیں": "بڑھنا",
  "بڑھو": "بڑھنا",
  "بڑھوں": "بڑھنا",
  "بڑھوا": "بڑھنا",
  "بڑھوانے": "بڑھنا",
  "بڑھوانا": "بڑھنا",
  "بڑھواتے": "بڑھنا",
  "بڑھواتا": "بڑھنا",
  "بڑھواتی": "بڑھنا",
  "بڑھواتیں": "بڑھنا",
  "بڑھواؤ": "بڑھنا",
  "بڑھواؤں": "بڑھنا",
  "بڑھوائے": "بڑھنا",
  "بڑھوائی": "بڑھنا",
  "بڑھوائیے": "بڑھنا",
  "بڑھوائیں": "بڑھنا",
  "بڑھوایا": "بڑھنا",
  "بڑھی": "بڑھنا",
  "بڑھیے": "بڑھنا",
  "بڑھیں": "بڑھنا",
  "بٹ": "بٹنا",
  "بٹے": "بٹہ",
  "بٹں": "بٹنا",
  "بٹا": "بٹنا",
  "بٹانے": "بٹنا",
  "بٹانا": "بٹنا",
  "بٹاتے": "بٹنا",
  "بٹاتا": "بٹنا",
  "بٹاتی": "بٹنا",
  "بٹاتیں": "بٹنا",
  "بٹاؤ": "بٹنا",
  "بٹاؤں": "بٹنا",
  "بٹائے": "بٹنا",
  "بٹائی": "بٹنا",
  "بٹائیے": "بٹنا",
  "بٹائیں": "بٹنا",
  "بٹایا": "بٹنا",
  "بٹہ": "بٹہ",
  "بٹن": "بٹن",
  "بٹنے": "بٹنا",
  "بٹنا": "بٹنا",
  "بٹنو": "بٹن",
  "بٹنوں": "بٹن",
  "بٹنی": "بٹنا",
  "بٹتے": "بٹنا",
  "بٹتا": "بٹنا",
  "بٹتی": "بٹنا",
  "بٹتیں": "بٹنا",
  "بٹو": "بٹہ",
  "بٹوے": "بٹوہ",
  "بٹوں": "بٹہ",
  "بٹوا": "بٹنا",
  "بٹوانے": "بٹنا",
  "بٹوانا": "بٹنا",
  "بٹوارے": "بٹوارہ",
  "بٹوارہ": "بٹوارہ",
  "بٹوارو": "بٹوارہ",
  "بٹواروں": "بٹوارہ",
  "بٹواتے": "بٹنا",
  "بٹواتا": "بٹنا",
  "بٹواتی": "بٹنا",
  "بٹواتیں": "بٹنا",
  "بٹواؤ": "بٹنا",
  "بٹواؤں": "بٹنا",
  "بٹوائے": "بٹنا",
  "بٹوائی": "بٹنا",
  "بٹوائیے": "بٹنا",
  "بٹوائیں": "بٹنا",
  "بٹوایا": "بٹنا",
  "بٹوہ": "بٹوہ",
  "بٹور": "بٹورنا",
  "بٹورے": "بٹورنا",
  "بٹورں": "بٹورنا",
  "بٹورا": "بٹورنا",
  "بٹورنے": "بٹورنا",
  "بٹورنا": "بٹورنا",
  "بٹورنی": "بٹورنا",
  "بٹورتے": "بٹورنا",
  "بٹورتا": "بٹورنا",
  "بٹورتی": "بٹورنا",
  "بٹورتیں": "بٹورنا",
  "بٹورو": "بٹورنا",
  "بٹوروں": "بٹورنا",
  "بٹوری": "بٹورنا",
  "بٹوریے": "بٹورنا",
  "بٹوریں": "بٹورنا",
  "بٹوو": "بٹوہ",
  "بٹووں": "بٹوہ",
  "بٹی": "بٹی",
  "بٹیے": "بٹنا",
  "بٹیں": "بٹنا",
  "بٹیاں": "بٹی",
  "بٹیر": "بٹیر",
  "بٹیرو": "بٹیر",
  "بٹیروں": "بٹیر",
  "بٹیریں": "بٹیر",
  "بٹیو": "بٹی",
  "بٹیوں": "بٹی",
  "بٹھ": "بٹھنا",
  "بٹھے": "بٹھنا",
  "بٹھں": "بٹھنا",
  "بٹھا": "بٹھنا",
  "بٹھانے": "بٹھنا",
  "بٹھانا": "بٹھنا",
  "بٹھاتے": "بٹھنا",
  "بٹھاتا": "بٹھنا",
  "بٹھاتی": "بٹھنا",
  "بٹھاتیں": "بٹھنا",
  "بٹھاؤ": "بٹھنا",
  "بٹھاؤں": "بٹھنا",
  "بٹھائے": "بٹھنا",
  "بٹھائی": "بٹھنا",
  "بٹھائیے": "بٹھنا",
  "بٹھائیں": "بٹھنا",
  "بٹھایا": "بٹھنا",
  "بٹھنے": "بٹھنا",
  "بٹھنا": "بٹھنا",
  "بٹھنی": "بٹھنا",
  "بٹھتے": "بٹھنا",
  "بٹھتا": "بٹھنا",
  "بٹھتی": "بٹھنا",
  "بٹھتیں": "بٹھنا",
  "بٹھو": "بٹھنا",
  "بٹھوں": "بٹھنا",
  "بٹھوا": "بٹھنا",
  "بٹھوانے": "بٹھنا",
  "بٹھوانا": "بٹھنا",
  "بٹھواتے": "بٹھنا",
  "بٹھواتا": "بٹھنا",
  "بٹھواتی": "بٹھنا",
  "بٹھواتیں": "بٹھنا",
  "بٹھواؤ": "بٹھنا",
  "بٹھواؤں": "بٹھنا",
  "بٹھوائے": "بٹھنا",
  "بٹھوائی": "بٹھنا",
  "بٹھوائیے": "بٹھنا",
  "بٹھوائیں": "بٹھنا",
  "بٹھوایا": "بٹھنا",
  "بٹھی": "بٹھنا",
  "بٹھیے": "بٹھنا",
  "بٹھیں": "بٹھنا",
  "بشر": "بشر",
  "بشرو": "بشر",
  "بشروں": "بشر",
  "باغ": "باغ",
  "باغبان": "باغبان",
  "باغبانو": "باغبان",
  "باغبانوں": "باغبان",
  "باغو": "باغ",
  "باغوں": "باغ",
  "باغی": "باغی",
  "باغیں": "باغ",
  "باغیچے": "باغیچہ",
  "باغیچہ": "باغیچہ",
  "باغیچو": "باغیچہ",
  "باغیچوں": "باغیچہ",
  "باغیو": "باغی",
  "باغیوں": "باغی",
  "باڑے": "باڑہ",
  "باڑہ": "باڑہ",
  "باڑو": "باڑہ",
  "باڑوں": "باڑہ",
  "باشندے": "باشندہ",
  "باشندہ": "باشندہ",
  "باشندو": "باشندہ",
  "باشندوں": "باشندہ",
  "باب": "باب",
  "بابے": "بابا",
  "بابا": "بابا",
  "بابو": "بابا",
  "بابوں": "بابا",
  "بادے": "بادہ",
  "بادشاہت": "بادشاہت",
  "بادشاہتو": "بادشاہت",
  "بادشاہتوں": "بادشاہت",
  "بادشاہتیں": "بادشاہت",
  "بادام": "بادام",
  "بادامو": "بادام",
  "باداموں": "بادام",
  "بادامیں": "بادام",
  "بادبان": "بادبان",
  "بادبانو": "بادبان",
  "بادبانوں": "بادبان",
  "بادبانیں": "بادبان",
  "بادہ": "بادہ",
  "بادل": "بادل",
  "بادلو": "بادل",
  "بادلوں": "بادل",
  "بادو": "بادہ",
  "بادوں": "بادہ",
  "باجے": "باجا",
  "باجا": "باجا",
  "باجہ": "باجہ",
  "باجرے": "باجرہ",
  "باجرہ": "باجرہ",
  "باجرو": "باجرہ",
  "باجروں": "باجرہ",
  "باجو": "باجا",
  "باجوں": "باجا",
  "بال": "بال",
  "بالے": "بالا",
  "بالٹی": "بالٹی",
  "بالٹیاں": "بالٹی",
  "بالٹیو": "بالٹی",
  "بالٹیوں": "بالٹی",
  "بالشتیے": "بالشتیا",
  "بالشتیا": "بالشتیا",
  "بالشتیہ": "بالشتیہ",
  "بالشتیو": "بالشتیا",
  "بالشتیوں": "بالشتیا",
  "بالا": "بالا",
  "بالاخانے": "بالاخانہ",
  "بالاخانہ": "بالاخانہ",
  "بالاخانو": "بالاخانہ",
  "بالاخانوں": "بالاخانہ",
  "بالہ": "بالہ",
  "بالکن": "بالکن",
  "بالکنو": "بالکن",
  "بالکنوں": "بالکن",
  "بالکنیں": "بالکن",
  "بالو": "بالا",
  "بالوں": "بالا",
  "بالی": "بالا",
  "بالیں": "بال",
  "بالیاں": "بالی",
  "بالیو": "بالی",
  "بالیوں": "بالی",
  "بان": "بان",
  "بانے": "بانا",
  "بانٹ": "بانٹ",
  "بانٹے": "بنٹنا",
  "بانٹں": "بنٹنا",
  "بانٹا": "بنٹنا",
  "بانٹنے": "بنٹنا",
  "بانٹنا": "بنٹنا",
  "بانٹتے": "بنٹنا",
  "بانٹتا": "بنٹنا",
  "بانٹتی": "بنٹنا",
  "بانٹتیں": "بنٹنا",
  "بانٹو": "بانٹ",
  "بانٹوں": "بانٹ",
  "بانٹی": "بنٹنا",
  "بانٹیے": "بنٹنا",
  "بانٹیں": "بانٹ",
  "بانا": "بانا",
  "باندی": "باندی",
  "باندیاں": "باندی",
  "باندیو": "باندی",
  "باندیوں": "باندی",
  "باندھ": "باندھنا",
  "باندھے": "باندھا",
  "باندھں": "باندھنا",
  "باندھا": "باندھا",
  "باندھنے": "باندھنا",
  "باندھنا": "باندھنا",
  "باندھنی": "باندھنا",
  "باندھتے": "باندھنا",
  "باندھتا": "باندھنا",
  "باندھتی": "باندھنا",
  "باندھتیں": "باندھنا",
  "باندھو": "باندھا",
  "باندھوں": "باندھا",
  "باندھی": "باندھنا",
  "باندھیے": "باندھنا",
  "باندھیں": "باندھنا",
  "بانکے": "بانکا",
  "بانکا": "بانکا",
  "بانکو": "بانکا",
  "بانکوں": "بانکا",
  "بانس": "بانس",
  "بانسو": "بانس",
  "بانسوں": "بانس",
  "بانسیں": "بانس",
  "بانو": "بانا",
  "بانوں": "بانا",
  "بانی": "بانی",
  "بانیو": "بانی",
  "بانیوں": "بانی",
  "باپ": "باپ",
  "باپو": "باپ",
  "باپوں": "باپ",
  "بار": "بار",
  "بارش": "بارش",
  "بارشو": "بارش",
  "بارشوں": "بارش",
  "بارشیں": "بارش",
  "بارا": "بارا",
  "بارو": "بار",
  "باروں": "بار",
  "باریکی": "باریکی",
  "باریکیاں": "باریکی",
  "باریکیو": "باریکی",
  "باریکیوں": "باریکی",
  "باسی": "باسی",
  "باسیو": "باسی",
  "باسیوں": "باسی",
  "بات": "بات",
  "باتو": "بات",
  "باتوں": "بات",
  "باتیں": "بات",
  "باؤ": "باؤ",
  "باورچی": "باورچی",
  "باورچیو": "باورچی",
  "باورچیوں": "باورچی",
  "بائس": "بائس",
  "بائی": "بائی",
  "بائیاں": "بائی",
  "بائیو": "بائی",
  "بائیوں": "بائی",
  "بایاں": "بایاں",
  "باز": "باز",
  "بازار": "بازار",
  "بازارو": "بازار",
  "بازاروں": "بازار",
  "بازاریں": "بازار",
  "بازو": "بازو",
  "بازوں": "باز",
  "بازوو": "بازوو",
  "بازوؤ": "بازو",
  "بازوؤں": "بازو",
  "بازووؤ": "بازوو",
  "بازووؤں": "بازوو",
  "بازوئیں": "بازو",
  "بازی": "بازی",
  "بازیاں": "بازی",
  "بازیو": "بازی",
  "بازیوں": "بازی",
  "باطنی": "باطنی",
  "باطنیو": "باطنی",
  "باطنیوں": "باطنی",
  "بچ": "بچنا",
  "بچّے": "بچّہ",
  "بچّہ": "بچّہ",
  "بچّو": "بچّہ",
  "بچّوں": "بچّہ",
  "بچّی": "بچّی",
  "بچّیاں": "بچّی",
  "بچّیو": "بچّی",
  "بچّیوں": "بچّی",
  "بچے": "بچا",
  "بچں": "بچنا",
  "بچا": "بچا",
  "بچانے": "بچنا",
  "بچانا": "بچنا",
  "بچارے": "بچارہ",
  "بچارہ": "بچارہ",
  "بچارو": "بچارہ",
  "بچاروں": "بچارہ",
  "بچاتے": "بچنا",
  "بچاتا": "بچنا",
  "بچاتی": "بچنا",
  "بچاتیں": "بچنا",
  "بچاؤ": "بچنا",
  "بچاؤں": "بچنا",
  "بچاوا": "بچنا",
  "بچاوانے": "بچنا",
  "بچاوانا": "بچنا",
  "بچاواتے": "بچنا",
  "بچاواتا": "بچنا",
  "بچاواتی": "بچنا",
  "بچاواتیں": "بچنا",
  "بچاواؤ": "بچنا",
  "بچاواؤں": "بچنا",
  "بچاوائے": "بچنا",
  "بچاوائی": "بچنا",
  "بچاوائیے": "بچنا",
  "بچاوائیں": "بچنا",
  "بچاوایا": "بچنا",
  "بچائے": "بچنا",
  "بچائی": "بچنا",
  "بچائیے": "بچنا",
  "بچائیں": "بچنا",
  "بچایا": "بچنا",
  "بچہ": "بچہ",
  "بچنے": "بچنا",
  "بچنا": "بچنا",
  "بچنی": "بچنا",
  "بچپن": "بچپن",
  "بچپنو": "بچپن",
  "بچپنوں": "بچپن",
  "بچتے": "بچنا",
  "بچتا": "بچنا",
  "بچتی": "بچنا",
  "بچتیں": "بچنا",
  "بچو": "بچا",
  "بچوں": "بچا",
  "بچوا": "بچنا",
  "بچوانے": "بچنا",
  "بچوانا": "بچنا",
  "بچواتے": "بچنا",
  "بچواتا": "بچنا",
  "بچواتی": "بچنا",
  "بچواتیں": "بچنا",
  "بچواؤ": "بچنا",
  "بچواؤں": "بچنا",
  "بچوائے": "بچنا",
  "بچوائی": "بچنا",
  "بچوائیے": "بچنا",
  "بچوائیں": "بچنا",
  "بچوایا": "بچنا",
  "بچی": "بچی",
  "بچیے": "بچنا",
  "بچیں": "بچنا",
  "بچیاں": "بچی",
  "بچیو": "بچی",
  "بچیوں": "بچی",
  "بچھ": "بچھنا",
  "بچھے": "بچھنا",
  "بچھں": "بچھنا",
  "بچھا": "بچھنا",
  "بچھانے": "بچھنا",
  "بچھانا": "بچھنا",
  "بچھاتے": "بچھنا",
  "بچھاتا": "بچھنا",
  "بچھاتی": "بچھنا",
  "بچھاتیں": "بچھنا",
  "بچھاؤ": "بچھنا",
  "بچھاؤں": "بچھنا",
  "بچھائے": "بچھنا",
  "بچھائی": "بچھنا",
  "بچھائیے": "بچھنا",
  "بچھائیں": "بچھنا",
  "بچھایا": "بچھنا",
  "بچھنے": "بچھنا",
  "بچھنا": "بچھنا",
  "بچھنی": "بچھنا",
  "بچھتے": "بچھنا",
  "بچھتا": "بچھنا",
  "بچھتی": "بچھنا",
  "بچھتیں": "بچھنا",
  "بچھو": "بچھنا",
  "بچھوں": "بچھنا",
  "بچھوا": "بچھنا",
  "بچھوانے": "بچھنا",
  "بچھوانا": "بچھنا",
  "بچھواتے": "بچھنا",
  "بچھواتا": "بچھنا",
  "بچھواتی": "بچھنا",
  "بچھواتیں": "بچھنا",
  "بچھواؤ": "بچھنا",
  "بچھواؤں": "بچھنا",
  "بچھوائے": "بچھنا",
  "بچھوائی": "بچھنا",
  "بچھوائیے": "بچھنا",
  "بچھوائیں": "بچھنا",
  "بچھوایا": "بچھنا",
  "بچھونے": "بچھونا",
  "بچھونا": "بچھونا",
  "بچھونو": "بچھونا",
  "بچھونوں": "بچھونا",
  "بچھووا": "بچھنا",
  "بچھووانے": "بچھنا",
  "بچھووانا": "بچھنا",
  "بچھوواتے": "بچھنا",
  "بچھوواتا": "بچھنا",
  "بچھوواتی": "بچھنا",
  "بچھوواتیں": "بچھنا",
  "بچھوواؤ": "بچھنا",
  "بچھوواؤں": "بچھنا",
  "بچھووائے": "بچھنا",
  "بچھووائی": "بچھنا",
  "بچھووائیے": "بچھنا",
  "بچھووائیں": "بچھنا",
  "بچھووایا": "بچھنا",
  "بچھی": "بچھنا",
  "بچھیے": "بچھنا",
  "بچھیں": "بچھنا",
  "بد": "بد",
  "بدذات": "بدذات",
  "بدذاتو": "بدذات",
  "بدذاتوں": "بدذات",
  "بدذاتیں": "بدذات",
  "بداعمالی": "بداعمالی",
  "بداعمالیاں": "بداعمالی",
  "بداعمالیو": "بداعمالی",
  "بداعمالیوں": "بداعمالی",
  "بدبخت": "بدبخت",
  "بدبختو": "بدبخت",
  "بدبختوں": "بدبخت",
  "بدبختیں": "بدبخت",
  "بدبو": "بدبو",
  "بدبوؤ": "بدبو",
  "بدبوؤں": "بدبو",
  "بدبوئیں": "بدبو",
  "بددعا": "بددعا",
  "بددعاؤ": "بددعا",
  "بددعاؤں": "بددعا",
  "بددعائیں": "بددعا",
  "بدعہدی": "بدعہدی",
  "بدعہدیاں": "بدعہدی",
  "بدعہدیو": "بدعہدی",
  "بدعہدیوں": "بدعہدی",
  "بدعنوانی": "بدعنوانی",
  "بدعنوانیاں": "بدعنوانی",
  "بدعنوانیو": "بدعنوانی",
  "بدعنوانیوں": "بدعنوانی",
  "بدعت": "بدعت",
  "بدعتو": "بدعت",
  "بدعتوں": "بدعت",
  "بدعتیں": "بدعت",
  "بدگمانی": "بدگمانی",
  "بدگمانیاں": "بدگمانی",
  "بدگمانیو": "بدگمانی",
  "بدگمانیوں": "بدگمانی",
  "بدک": "بدکنا",
  "بدکے": "بدکنا",
  "بدکں": "بدکنا",
  "بدکا": "بدکنا",
  "بدکانے": "بدکنا",
  "بدکانا": "بدکنا",
  "بدکاتے": "بدکنا",
  "بدکاتا": "بدکنا",
  "بدکاتی": "بدکنا",
  "بدکاتیں": "بدکنا",
  "بدکاؤ": "بدکنا",
  "بدکاؤں": "بدکنا",
  "بدکائے": "بدکنا",
  "بدکائی": "بدکنا",
  "بدکائیے": "بدکنا",
  "بدکائیں": "بدکنا",
  "بدکایا": "بدکنا",
  "بدکنے": "بدکنا",
  "بدکنا": "بدکنا",
  "بدکنی": "بدکنا",
  "بدکردار": "بدکردار",
  "بدکردارو": "بدکردار",
  "بدکرداروں": "بدکردار",
  "بدکتے": "بدکنا",
  "بدکتا": "بدکنا",
  "بدکتی": "بدکنا",
  "بدکتیں": "بدکنا",
  "بدکو": "بدکنا",
  "بدکوں": "بدکنا",
  "بدکوا": "بدکنا",
  "بدکوانے": "بدکنا",
  "بدکوانا": "بدکنا",
  "بدکواتے": "بدکنا",
  "بدکواتا": "بدکنا",
  "بدکواتی": "بدکنا",
  "بدکواتیں": "بدکنا",
  "بدکواؤ": "بدکنا",
  "بدکواؤں": "بدکنا",
  "بدکوائے": "بدکنا",
  "بدکوائی": "بدکنا",
  "بدکوائیے": "بدکنا",
  "بدکوائیں": "بدکنا",
  "بدکوایا": "بدکنا",
  "بدکی": "بدکنا",
  "بدکیے": "بدکنا",
  "بدکیں": "بدکنا",
  "بدل": "بدلنا",
  "بدلے": "بدلہ",
  "بدلں": "بدلنا",
  "بدلا": "بدلنا",
  "بدلانے": "بدلنا",
  "بدلانا": "بدلنا",
  "بدلاتے": "بدلنا",
  "بدلاتا": "بدلنا",
  "بدلاتی": "بدلنا",
  "بدلاتیں": "بدلنا",
  "بدلاؤ": "بدلنا",
  "بدلاؤں": "بدلنا",
  "بدلائے": "بدلنا",
  "بدلائی": "بدلنا",
  "بدلائیے": "بدلنا",
  "بدلائیں": "بدلنا",
  "بدلایا": "بدلنا",
  "بدلہ": "بدلہ",
  "بدلنے": "بدلنا",
  "بدلنا": "بدلنا",
  "بدلنی": "بدلنا",
  "بدلتے": "بدلنا",
  "بدلتا": "بدلنا",
  "بدلتی": "بدلنا",
  "بدلتیں": "بدلنا",
  "بدلو": "بدلہ",
  "بدلوں": "بدلہ",
  "بدلوا": "بدلنا",
  "بدلوانے": "بدلنا",
  "بدلوانا": "بدلنا",
  "بدلواتے": "بدلنا",
  "بدلواتا": "بدلنا",
  "بدلواتی": "بدلنا",
  "بدلواتیں": "بدلنا",
  "بدلواؤ": "بدلنا",
  "بدلواؤں": "بدلنا",
  "بدلوائے": "بدلنا",
  "بدلوائی": "بدلنا",
  "بدلوائیے": "بدلنا",
  "بدلوائیں": "بدلنا",
  "بدلوایا": "بدلنا",
  "بدلی": "بدلی",
  "بدلیے": "بدلنا",
  "بدلیں": "بدلنا",
  "بدلیاں": "بدلی",
  "بدلیو": "بدلی",
  "بدلیوں": "بدلی",
  "بدمعاش": "بدمعاش",
  "بدمعاشو": "بدمعاش",
  "بدمعاشوں": "بدمعاش",
  "بدن": "بدن",
  "بدنصیب": "بدنصیب",
  "بدنصیبو": "بدنصیب",
  "بدنصیبوں": "بدنصیب",
  "بدنو": "بدن",
  "بدنوں": "بدن",
  "بدر": "بدر",
  "بدرو": "بدر",
  "بدروں": "بدر",
  "بدتَر": "بد",
  "بدتَرین": "بد",
  "بدتر": "بد",
  "بدترین": "بد",
  "بدو": "بدو",
  "بدؤ": "بدؤ",
  "بدولت": "بدولت",
  "بدولتو": "بدولت",
  "بدولتوں": "بدولت",
  "بدولتیں": "بدولت",
  "بدوؤ": "بدو",
  "بدوؤں": "بدو",
  "بدی": "بدی",
  "بدیو": "بدی",
  "بدیوں": "بدی",
  "بدھو": "بدھو",
  "بدھوؤ": "بدھو",
  "بدھوؤں": "بدھو",
  "بعدے": "بعدہ",
  "بعدہ": "بعدہ",
  "بعدو": "بعدہ",
  "بعدوں": "بعدہ",
  "بعض": "بعض",
  "بعضے": "بعضا",
  "بعضا": "بعضا",
  "بعضو": "بعضا",
  "بعضوں": "بعضا",
  "بگڑ": "بگڑنا",
  "بگڑے": "بگڑنا",
  "بگڑں": "بگڑنا",
  "بگڑا": "بگڑنا",
  "بگڑنے": "بگڑنا",
  "بگڑنا": "بگڑنا",
  "بگڑنی": "بگڑنا",
  "بگڑتے": "بگڑنا",
  "بگڑتا": "بگڑنا",
  "بگڑتی": "بگڑنا",
  "بگڑتیں": "بگڑنا",
  "بگڑو": "بگڑنا",
  "بگڑوں": "بگڑنا",
  "بگڑوا": "بگڑنا",
  "بگڑوانے": "بگڑنا",
  "بگڑوانا": "بگڑنا",
  "بگڑواتے": "بگڑنا",
  "بگڑواتا": "بگڑنا",
  "بگڑواتی": "بگڑنا",
  "بگڑواتیں": "بگڑنا",
  "بگڑواؤ": "بگڑنا",
  "بگڑواؤں": "بگڑنا",
  "بگڑوائے": "بگڑنا",
  "بگڑوائی": "بگڑنا",
  "بگڑوائیے": "بگڑنا",
  "بگڑوائیں": "بگڑنا",
  "بگڑوایا": "بگڑنا",
  "بگڑی": "بگڑنا",
  "بگڑیے": "بگڑنا",
  "بگڑیں": "بگڑنا",
  "بگٹی": "بگٹی",
  "بگٹیو": "بگٹی",
  "بگٹیوں": "بگٹی",
  "بگاڑ": "بگڑنا",
  "بگاڑے": "بگڑنا",
  "بگاڑں": "بگڑنا",
  "بگاڑا": "بگڑنا",
  "بگاڑنے": "بگڑنا",
  "بگاڑنا": "بگڑنا",
  "بگاڑتے": "بگڑنا",
  "بگاڑتا": "بگڑنا",
  "بگاڑتی": "بگڑنا",
  "بگاڑتیں": "بگڑنا",
  "بگاڑو": "بگڑنا",
  "بگاڑوں": "بگڑنا",
  "بگاڑی": "بگڑنا",
  "بگاڑیے": "بگڑنا",
  "بگاڑیں": "بگڑنا",
  "بگانے": "بگانہ",
  "بگانہ": "بگانہ",
  "بگانو": "بگانہ",
  "بگانوں": "بگانہ",
  "بگل": "بگل",
  "بگلے": "بگلا",
  "بگلا": "بگلا",
  "بگلو": "بگلا",
  "بگلوں": "بگلا",
  "بگولے": "بگولا",
  "بگولا": "بگولا",
  "بگولہ": "بگولہ",
  "بگولو": "بگولا",
  "بگولوں": "بگولا",
  "بگھار": "بگھار",
  "بگھارے": "بگھارنا",
  "بگھارں": "بگھارنا",
  "بگھارا": "بگھارنا",
  "بگھارنے": "بگھارنا",
  "بگھارنا": "بگھارنا",
  "بگھارنی": "بگھارنا",
  "بگھارتے": "بگھارنا",
  "بگھارتا": "بگھارنا",
  "بگھارتی": "بگھارنا",
  "بگھارتیں": "بگھارنا",
  "بگھارو": "بگھار",
  "بگھاروں": "بگھار",
  "بگھاری": "بگھارنا",
  "بگھاریے": "بگھارنا",
  "بگھاریں": "بگھار",
  "بگھی": "بگھی",
  "بگھیاں": "بگھی",
  "بگھیو": "بگھی",
  "بگھیوں": "بگھی",
  "بہ": "بہ",
  "بہُو": "بہُو",
  "بہُوؤ": "بہُو",
  "بہُوؤں": "بہُو",
  "بہُوئیں": "بہُو",
  "بہے": "بہہ",
  "بہں": "بہنا",
  "بہشت": "بہشت",
  "بہشتو": "بہشت",
  "بہشتوں": "بہشت",
  "بہشتیں": "بہشت",
  "بہا": "بہنا",
  "بہادر": "بہادر",
  "بہادرو": "بہادر",
  "بہادروں": "بہادر",
  "بہانے": "بہانا",
  "بہانا": "بہانا",
  "بہانہ": "بہانہ",
  "بہانو": "بہانا",
  "بہانوں": "بہانا",
  "بہار": "بہار",
  "بہارو": "بہار",
  "بہاروں": "بہار",
  "بہاری": "بہاری",
  "بہاریں": "بہار",
  "بہاریو": "بہاری",
  "بہاریوں": "بہاری",
  "بہاتے": "بہنا",
  "بہاتا": "بہنا",
  "بہاتی": "بہنا",
  "بہاتیں": "بہنا",
  "بہاؤ": "بہنا",
  "بہاؤں": "بہنا",
  "بہائے": "بہنا",
  "بہائی": "بہنا",
  "بہائیے": "بہنا",
  "بہائیں": "بہنا",
  "بہایا": "بہنا",
  "بہہ": "بہہ",
  "بہک": "بہکنا",
  "بہکے": "بہکنا",
  "بہکں": "بہکنا",
  "بہکا": "بہکنا",
  "بہکانے": "بہکنا",
  "بہکانا": "بہکنا",
  "بہکاتے": "بہکنا",
  "بہکاتا": "بہکنا",
  "بہکاتی": "بہکنا",
  "بہکاتیں": "بہکنا",
  "بہکاؤ": "بہکنا",
  "بہکاؤں": "بہکنا",
  "بہکائے": "بہکنا",
  "بہکائی": "بہکنا",
  "بہکائیے": "بہکنا",
  "بہکائیں": "بہکنا",
  "بہکایا": "بہکنا",
  "بہکنے": "بہکنا",
  "بہکنا": "بہکنا",
  "بہکنی": "بہکنا",
  "بہکتے": "بہکنا",
  "بہکتا": "بہکنا",
  "بہکتی": "بہکنا",
  "بہکتیں": "بہکنا",
  "بہکو": "بہکنا",
  "بہکوں": "بہکنا",
  "بہکوا": "بہکنا",
  "بہکوانے": "بہکنا",
  "بہکوانا": "بہکنا",
  "بہکواتے": "بہکنا",
  "بہکواتا": "بہکنا",
  "بہکواتی": "بہکنا",
  "بہکواتیں": "بہکنا",
  "بہکواؤ": "بہکنا",
  "بہکواؤں": "بہکنا",
  "بہکوائے": "بہکنا",
  "بہکوائی": "بہکنا",
  "بہکوائیے": "بہکنا",
  "بہکوائیں": "بہکنا",
  "بہکوایا": "بہکنا",
  "بہکی": "بہکنا",
  "بہکیے": "بہکنا",
  "بہکیں": "بہکنا",
  "بہل": "بہلنا",
  "بہلے": "بہلنا",
  "بہلں": "بہلنا",
  "بہلا": "بہلنا",
  "بہلانے": "بہلنا",
  "بہلانا": "بہلنا",
  "بہلاتے": "بہلنا",
  "بہلاتا": "بہلنا",
  "بہلاتی": "بہلنا",
  "بہلاتیں": "بہلنا",
  "بہلاؤ": "بہلنا",
  "بہلاؤں": "بہلنا",
  "بہلائے": "بہلنا",
  "بہلائی": "بہلنا",
  "بہلائیے": "بہلنا",
  "بہلائیں": "بہلنا",
  "بہلایا": "بہلنا",
  "بہلنے": "بہلنا",
  "بہلنا": "بہلنا",
  "بہلنی": "بہلنا",
  "بہلتے": "بہلنا",
  "بہلتا": "بہلنا",
  "بہلتی": "بہلنا",
  "بہلتیں": "بہلنا",
  "بہلو": "بہلنا",
  "بہلوں": "بہلنا",
  "بہلوا": "بہلنا",
  "بہلوانے": "بہلنا",
  "بہلوانا": "بہلنا",
  "بہلواتے": "بہلنا",
  "بہلواتا": "بہلنا",
  "بہلواتی": "بہلنا",
  "بہلواتیں": "بہلنا",
  "بہلواؤ": "بہلنا",
  "بہلواؤں": "بہلنا",
  "بہلوائے": "بہلنا",
  "بہلوائی": "بہلنا",
  "بہلوائیے": "بہلنا",
  "بہلوائیں": "بہلنا",
  "بہلوایا": "بہلنا",
  "بہلی": "بہلنا",
  "بہلیے": "بہلنا",
  "بہلیں": "بہلنا",
  "بہن": "بہن",
  "بہنے": "بہنا",
  "بہنا": "بہنا",
  "بہنو": "بہنا",
  "بہنوں": "بہنا",
  "بہنی": "بہنا",
  "بہنیں": "بہن",
  "بہر": "بہر",
  "بہرے": "بہرا",
  "بہرا": "بہرا",
  "بہرہ": "بہرہ",
  "بہرو": "بہرا",
  "بہروں": "بہرا",
  "بہروپیے": "بہروپیہ",
  "بہروپیہ": "بہروپیہ",
  "بہروپیو": "بہروپیہ",
  "بہروپیوں": "بہروپیہ",
  "بہریں": "بہر",
  "بہت": "بہت",
  "بہتَر": "بہ",
  "بہتَرین": "بہ",
  "بہتے": "بہتا",
  "بہتا": "بہتا",
  "بہتان": "بہتان",
  "بہتانو": "بہتان",
  "بہتانوں": "بہتان",
  "بہتر": "بہ",
  "بہترین": "بہ",
  "بہتو": "بہتا",
  "بہتوں": "بہتا",
  "بہتی": "بہنا",
  "بہتیں": "بہت",
  "بہو": "بہہ",
  "بہوں": "بہہ",
  "بہوا": "بہنا",
  "بہوانے": "بہنا",
  "بہوانا": "بہنا",
  "بہواتے": "بہنا",
  "بہواتا": "بہنا",
  "بہواتی": "بہنا",
  "بہواتیں": "بہنا",
  "بہواؤ": "بہنا",
  "بہواؤں": "بہنا",
  "بہوائے": "بہنا",
  "بہوائی": "بہنا",
  "بہوائیے": "بہنا",
  "بہوائیں": "بہنا",
  "بہوایا": "بہنا",
  "بہوؤ": "بہو",
  "بہوؤں": "بہو",
  "بہوئیں": "بہو",
  "بہی": "بہنا",
  "بہیے": "بہنا",
  "بہیں": "بہنا",
  "بج": "بجنا",
  "بجے": "بجنا",
  "بجں": "بجنا",
  "بجا": "بجنا",
  "بجانے": "بجنا",
  "بجانا": "بجنا",
  "بجاتے": "بجنا",
  "بجاتا": "بجنا",
  "بجاتی": "بجنا",
  "بجاتیں": "بجنا",
  "بجاؤ": "بجنا",
  "بجاؤں": "بجنا",
  "بجائے": "بجنا",
  "بجائی": "بجنا",
  "بجائیے": "بجنا",
  "بجائیں": "بجنا",
  "بجایا": "بجنا",
  "بجلی": "بجلی",
  "بجلیاں": "بجلی",
  "بجلیو": "بجلی",
  "بجلیوں": "بجلی",
  "بجنے": "بجنا",
  "بجنا": "بجنا",
  "بجنی": "بجنا",
  "بجتے": "بجنا",
  "بجتا": "بجنا",
  "بجتی": "بجنا",
  "بجتیں": "بجنا",
  "بجو": "بجنا",
  "بجوں": "بجنا",
  "بجوا": "بجنا",
  "بجوانے": "بجنا",
  "بجوانا": "بجنا",
  "بجواتے": "بجنا",
  "بجواتا": "بجنا",
  "بجواتی": "بجنا",
  "بجواتیں": "بجنا",
  "بجواؤ": "بجنا",
  "بجواؤں": "بجنا",
  "بجوائے": "بجنا",
  "بجوائی": "بجنا",
  "بجوائیے": "بجنا",
  "بجوائیں": "بجنا",
  "بجوایا": "بجنا",
  "بجی": "بجنا",
  "بجیے": "بجنا",
  "بجیں": "بجنا",
  "بجھ": "بجھنا",
  "بجھے": "بجھنا",
  "بجھں": "بجھنا",
  "بجھا": "بجھنا",
  "بجھانے": "بجھنا",
  "بجھانا": "بجھنا",
  "بجھاتے": "بجھنا",
  "بجھاتا": "بجھنا",
  "بجھاتی": "بجھنا",
  "بجھاتیں": "بجھنا",
  "بجھاؤ": "بجھاؤ",
  "بجھاؤں": "بجھنا",
  "بجھائے": "بجھنا",
  "بجھائی": "بجھنا",
  "بجھائیے": "بجھنا",
  "بجھائیں": "بجھنا",
  "بجھایا": "بجھنا",
  "بجھنے": "بجھنا",
  "بجھنا": "بجھنا",
  "بجھنی": "بجھنا",
  "بجھتے": "بجھنا",
  "بجھتا": "بجھنا",
  "بجھتی": "بجھنا",
  "بجھتیں": "بجھنا",
  "بجھو": "بجھنا",
  "بجھوں": "بجھنا",
  "بجھوا": "بجھنا",
  "بجھوانے": "بجھنا",
  "بجھوانا": "بجھنا",
  "بجھواتے": "بجھنا",
  "بجھواتا": "بجھنا",
  "بجھواتی": "بجھنا",
  "بجھواتیں": "بجھنا",
  "بجھواؤ": "بجھنا",
  "بجھواؤں": "بجھنا",
  "بجھوائے": "بجھنا",
  "بجھوائی": "بجھنا",
  "بجھوائیے": "بجھنا",
  "بجھوائیں": "بجھنا",
  "بجھوایا": "بجھنا",
  "بجھی": "بجھنا",
  "بجھیے": "بجھنا",
  "بجھیں": "بجھنا",
  "بک": "بکنا",
  "بکے": "بکنا",
  "بکں": "بکنا",
  "بکا": "بکنا",
  "بکانے": "بکنا",
  "بکانا": "بکنا",
  "بکاتے": "بکنا",
  "بکاتا": "بکنا",
  "بکاتی": "بکنا",
  "بکاتیں": "بکنا",
  "بکاؤ": "بکاؤ",
  "بکاؤں": "بکنا",
  "بکائے": "بکنا",
  "بکائی": "بکنا",
  "بکائیے": "بکنا",
  "بکائیں": "بکنا",
  "بکایا": "بکنا",
  "بکنے": "بکنا",
  "بکنا": "بکنا",
  "بکنی": "بکنا",
  "بکرے": "بکرا",
  "بکرا": "بکرا",
  "بکرہ": "بکرہ",
  "بکرو": "بکرا",
  "بکروں": "بکرا",
  "بکری": "بکری",
  "بکریاں": "بکری",
  "بکریو": "بکری",
  "بکریوں": "بکری",
  "بکس": "بکس",
  "بکسے": "بکسہ",
  "بکسہ": "بکسہ",
  "بکسو": "بکسہ",
  "بکسوں": "بکسہ",
  "بکتے": "بکنا",
  "بکتا": "بکنا",
  "بکتی": "بکنا",
  "بکتیں": "بکنا",
  "بکو": "بکنا",
  "بکوں": "بکنا",
  "بکوا": "بکنا",
  "بکوانے": "بکنا",
  "بکوانا": "بکنا",
  "بکواتے": "بکنا",
  "بکواتا": "بکنا",
  "بکواتی": "بکنا",
  "بکواتیں": "بکنا",
  "بکواؤ": "بکنا",
  "بکواؤں": "بکنا",
  "بکوائے": "بکنا",
  "بکوائی": "بکنا",
  "بکوائیے": "بکنا",
  "بکوائیں": "بکنا",
  "بکوایا": "بکنا",
  "بکی": "بکنا",
  "بکیے": "بکنا",
  "بکیں": "بکنا",
  "بکھر": "بکھرنا",
  "بکھرے": "بکھرنا",
  "بکھرں": "بکھرنا",
  "بکھرا": "بکھرنا",
  "بکھرنے": "بکھرنا",
  "بکھرنا": "بکھرنا",
  "بکھرنی": "بکھرنا",
  "بکھرتے": "بکھرنا",
  "بکھرتا": "بکھرنا",
  "بکھرتی": "بکھرنا",
  "بکھرتیں": "بکھرنا",
  "بکھرو": "بکھرنا",
  "بکھروں": "بکھرنا",
  "بکھروا": "بکھرنا",
  "بکھروانے": "بکھرنا",
  "بکھروانا": "بکھرنا",
  "بکھرواتے": "بکھرنا",
  "بکھرواتا": "بکھرنا",
  "بکھرواتی": "بکھرنا",
  "بکھرواتیں": "بکھرنا",
  "بکھرواؤ": "بکھرنا",
  "بکھرواؤں": "بکھرنا",
  "بکھروائے": "بکھرنا",
  "بکھروائی": "بکھرنا",
  "بکھروائیے": "بکھرنا",
  "بکھروائیں": "بکھرنا",
  "بکھروایا": "بکھرنا",
  "بکھری": "بکھرنا",
  "بکھریے": "بکھرنا",
  "بکھریں": "بکھرنا",
  "بکھیڑے": "بکھیڑا",
  "بکھیڑا": "بکھیڑا",
  "بکھیڑو": "بکھیڑا",
  "بکھیڑوں": "بکھیڑا",
  "بکھیر": "بکھرنا",
  "بکھیرے": "بکھرنا",
  "بکھیرں": "بکھرنا",
  "بکھیرا": "بکھرنا",
  "بکھیرنے": "بکھرنا",
  "بکھیرنا": "بکھرنا",
  "بکھیرتے": "بکھرنا",
  "بکھیرتا": "بکھرنا",
  "بکھیرتی": "بکھرنا",
  "بکھیرتیں": "بکھرنا",
  "بکھیرو": "بکھرنا",
  "بکھیروں": "بکھرنا",
  "بکھیری": "بکھرنا",
  "بکھیریے": "بکھرنا",
  "بکھیریں": "بکھرنا",
  "بل": "بل",
  "بلڈنگ": "بلڈنگ",
  "بلڈنگو": "بلڈنگ",
  "بلڈنگوں": "بلڈنگ",
  "بلڈنگیں": "بلڈنگ",
  "بلا": "بلانا",
  "بلانے": "بلانا",
  "بلانا": "بلانا",
  "بلانی": "بلانا",
  "بلاتے": "بلانا",
  "بلاتا": "بلانا",
  "بلاتی": "بلانا",
  "بلاتیں": "بلانا",
  "بلاؤ": "بلانا",
  "بلاؤں": "بلانا",
  "بلائے": "بلانا",
  "بلائی": "بلانا",
  "بلائیے": "بلانا",
  "بلائیں": "بلانا",
  "بلایا": "بلانا",
  "بلب": "بلب",
  "بلبل": "بلبل",
  "بلبلے": "بلبلا",
  "بلبلا": "بلبلا",
  "بلبلو": "بلبلا",
  "بلبلوں": "بلبلا",
  "بلبلیں": "بلبل",
  "بلبو": "بلب",
  "بلبوں": "بلب",
  "بلبیں": "بلب",
  "بلک": "بلکنا",
  "بلکے": "بلکنا",
  "بلکں": "بلکنا",
  "بلکا": "بلکنا",
  "بلکانے": "بلکنا",
  "بلکانا": "بلکنا",
  "بلکاتے": "بلکنا",
  "بلکاتا": "بلکنا",
  "بلکاتی": "بلکنا",
  "بلکاتیں": "بلکنا",
  "بلکاؤ": "بلکنا",
  "بلکاؤں": "بلکنا",
  "بلکائے": "بلکنا",
  "بلکائی": "بلکنا",
  "بلکائیے": "بلکنا",
  "بلکائیں": "بلکنا",
  "بلکایا": "بلکنا",
  "بلکہ": "بلکہ",
  "بلکنے": "بلکنا",
  "بلکنا": "بلکنا",
  "بلکنی": "بلکنا",
  "بلکتے": "بلکنا",
  "بلکتا": "بلکنا",
  "بلکتی": "بلکنا",
  "بلکتیں": "بلکنا",
  "بلکو": "بلکنا",
  "بلکوں": "بلکنا",
  "بلکوا": "بلکنا",
  "بلکوانے": "بلکنا",
  "بلکوانا": "بلکنا",
  "بلکواتے": "بلکنا",
  "بلکواتا": "بلکنا",
  "بلکواتی": "بلکنا",
  "بلکواتیں": "بلکنا",
  "بلکواؤ": "بلکنا",
  "بلکواؤں": "بلکنا",
  "بلکوائے": "بلکنا",
  "بلکوائی": "بلکنا",
  "بلکوائیے": "بلکنا",
  "بلکوائیں": "بلکنا",
  "بلکوایا": "بلکنا",
  "بلکی": "بلکنا",
  "بلکیے": "بلکنا",
  "بلکیں": "بلکنا",
  "بلندی": "بلندی",
  "بلندیاں": "بلندی",
  "بلندیو": "بلندی",
  "بلندیوں": "بلندی",
  "بلو": "بل",
  "بلوں": "بل",
  "بلوا": "بولنا",
  "بلوانے": "بولنا",
  "بلوانا": "بولنا",
  "بلواتے": "بولنا",
  "بلواتا": "بولنا",
  "بلواتی": "بولنا",
  "بلواتیں": "بولنا",
  "بلواؤ": "بولنا",
  "بلواؤں": "بولنا",
  "بلوائے": "بولنا",
  "بلوائی": "بلوائی",
  "بلوائیے": "بولنا",
  "بلوائیں": "بولنا",
  "بلوائیو": "بلوائی",
  "بلوائیوں": "بلوائی",
  "بلوایا": "بولنا",
  "بلوچ": "بلوچ",
  "بلوچو": "بلوچ",
  "بلوچوں": "بلوچ",
  "بلی": "بلی",
  "بلیڈ": "بلیڈ",
  "بلیڈو": "بلیڈ",
  "بلیڈوں": "بلیڈ",
  "بلیڈیں": "بلیڈ",
  "بلیاں": "بلی",
  "بلیو": "بلی",
  "بلیوں": "بلی",
  "بم": "بم",
  "بمب": "بمب",
  "بمبو": "بمب",
  "بمبوں": "بمب",
  "بمو": "بم",
  "بموں": "بم",
  "بن": "بننا",
  "بنڈل": "بنڈل",
  "بنڈلو": "بنڈل",
  "بنڈلوں": "بنڈل",
  "بنڈلیں": "بنڈل",
  "بنے": "بننا",
  "بنں": "بننا",
  "بنٹ": "بنٹنا",
  "بنٹے": "بنٹنا",
  "بنٹں": "بنٹنا",
  "بنٹا": "بنٹنا",
  "بنٹنے": "بنٹنا",
  "بنٹنا": "بنٹنا",
  "بنٹنی": "بنٹنا",
  "بنٹتے": "بنٹنا",
  "بنٹتا": "بنٹنا",
  "بنٹتی": "بنٹنا",
  "بنٹتیں": "بنٹنا",
  "بنٹو": "بنٹنا",
  "بنٹوں": "بنٹنا",
  "بنٹوا": "بنٹنا",
  "بنٹوانے": "بنٹنا",
  "بنٹوانا": "بنٹنا",
  "بنٹواتے": "بنٹنا",
  "بنٹواتا": "بنٹنا",
  "بنٹواتی": "بنٹنا",
  "بنٹواتیں": "بنٹنا",
  "بنٹواؤ": "بنٹنا",
  "بنٹواؤں": "بنٹنا",
  "بنٹوائے": "بنٹنا",
  "بنٹوائی": "بنٹنا",
  "بنٹوائیے": "بنٹنا",
  "بنٹوائیں": "بنٹنا",
  "بنٹوایا": "بنٹنا",
  "بنٹی": "بنٹنا",
  "بنٹیے": "بنٹنا",
  "بنٹیں": "بنٹنا",
  "بنا": "بننا",
  "بنانے": "بننا",
  "بنانا": "بننا",
  "بناتے": "بننا",
  "بناتا": "بننا",
  "بناتی": "بننا",
  "بناتیں": "بننا",
  "بناؤ": "بننا",
  "بناؤں": "بننا",
  "بنائے": "بننا",
  "بنائی": "بننا",
  "بنائیے": "بننا",
  "بنائیں": "بننا",
  "بنایا": "بننا",
  "بنچ": "بنچ",
  "بنچو": "بنچ",
  "بنچوں": "بنچ",
  "بنچیں": "بنچ",
  "بند": "بند",
  "بندے": "بندا",
  "بندش": "بندش",
  "بندشو": "بندش",
  "بندشوں": "بندش",
  "بندشیں": "بندش",
  "بندا": "بندا",
  "بندہ": "بندہ",
  "بندر": "بندر",
  "بندرو": "بندر",
  "بندروں": "بندر",
  "بندو": "بندا",
  "بندوں": "بندا",
  "بندوق": "بندوق",
  "بندوقو": "بندوق",
  "بندوقوں": "بندوق",
  "بندوقیں": "بندوق",
  "بندی": "بندی",
  "بندیں": "بند",
  "بندیا": "بندیا",
  "بندیاں": "بندی",
  "بندیو": "بندی",
  "بندیوں": "بندی",
  "بندھ": "بندھنا",
  "بندھے": "بندھا",
  "بندھں": "بندھنا",
  "بندھا": "بندھا",
  "بندھانے": "باندھنا",
  "بندھانا": "باندھنا",
  "بندھاتے": "باندھنا",
  "بندھاتا": "باندھنا",
  "بندھاتی": "باندھنا",
  "بندھاتیں": "باندھنا",
  "بندھاؤ": "باندھنا",
  "بندھاؤں": "باندھنا",
  "بندھائے": "باندھنا",
  "بندھائی": "باندھنا",
  "بندھائیے": "باندھنا",
  "بندھائیں": "باندھنا",
  "بندھایا": "باندھنا",
  "بندھن": "بندھن",
  "بندھنے": "بندھنا",
  "بندھنا": "بندھنا",
  "بندھنو": "بندھن",
  "بندھنوں": "بندھن",
  "بندھنی": "بندھنا",
  "بندھتے": "بندھنا",
  "بندھتا": "بندھنا",
  "بندھتی": "بندھنا",
  "بندھتیں": "بندھنا",
  "بندھو": "بندھا",
  "بندھوں": "بندھا",
  "بندھوا": "باندھنا",
  "بندھوانے": "باندھنا",
  "بندھوانا": "باندھنا",
  "بندھواتے": "باندھنا",
  "بندھواتا": "باندھنا",
  "بندھواتی": "باندھنا",
  "بندھواتیں": "باندھنا",
  "بندھواؤ": "باندھنا",
  "بندھواؤں": "باندھنا",
  "بندھوائے": "باندھنا",
  "بندھوائی": "باندھنا",
  "بندھوائیے": "باندھنا",
  "بندھوائیں": "باندھنا",
  "بندھوایا": "باندھنا",
  "بندھی": "بندھنا",
  "بندھیے": "بندھنا",
  "بندھیں": "بندھنا",
  "بنگال": "بنگال",
  "بنگالو": "بنگال",
  "بنگالوں": "بنگال",
  "بنگالی": "بنگالی",
  "بنگالیو": "بنگالی",
  "بنگالیوں": "بنگالی",
  "بنگلے": "بنگلا",
  "بنگلا": "بنگلا",
  "بنگلہ": "بنگلہ",
  "بنگلو": "بنگلا",
  "بنگلوں": "بنگلا",
  "بنک": "بنک",
  "بنکو": "بنک",
  "بنکوں": "بنک",
  "بننے": "بننا",
  "بننا": "بننا",
  "بننی": "بننا",
  "بنت": "بنت",
  "بنتے": "بننا",
  "بنتا": "بننا",
  "بنتو": "بنت",
  "بنتوں": "بنت",
  "بنتی": "بننا",
  "بنتیں": "بنت",
  "بنو": "بننا",
  "بنوں": "بننا",
  "بنوا": "بننا",
  "بنوانے": "بننا",
  "بنوانا": "بننا",
  "بنواتے": "بننا",
  "بنواتا": "بننا",
  "بنواتی": "بننا",
  "بنواتیں": "بننا",
  "بنواؤ": "بننا",
  "بنواؤں": "بننا",
  "بنوائے": "بننا",
  "بنوائی": "بننا",
  "بنوائیے": "بننا",
  "بنوائیں": "بننا",
  "بنوایا": "بننا",
  "بنی": "بننا",
  "بنیے": "بنیا",
  "بنیں": "بننا",
  "بنیا": "بنیا",
  "بنیاں": "بنیا",
  "بنیاد": "بنیاد",
  "بنیادو": "بنیاد",
  "بنیادوں": "بنیاد",
  "بنیادیں": "بنیاد",
  "بنیان": "بنیان",
  "بنیانو": "بنیان",
  "بنیانوں": "بنیان",
  "بنیانیں": "بنیان",
  "بنیو": "بنیا",
  "بنیوں": "بنیا",
  "بپھر": "بپھرنا",
  "بپھرے": "بپھرنا",
  "بپھرں": "بپھرنا",
  "بپھرا": "بپھرنا",
  "بپھرنے": "بپھرنا",
  "بپھرنا": "بپھرنا",
  "بپھرنی": "بپھرنا",
  "بپھرتے": "بپھرنا",
  "بپھرتا": "بپھرنا",
  "بپھرتی": "بپھرنا",
  "بپھرتیں": "بپھرنا",
  "بپھرو": "بپھرنا",
  "بپھروں": "بپھرنا",
  "بپھری": "بپھرنا",
  "بپھریے": "بپھرنا",
  "بپھریں": "بپھرنا",
  "بق": "بقنا",
  "بقے": "بقنا",
  "بقں": "بقنا",
  "بقا": "بقنا",
  "بقنے": "بقنا",
  "بقنا": "بقنا",
  "بقنی": "بقنا",
  "بقتے": "بقنا",
  "بقتا": "بقنا",
  "بقتی": "بقنا",
  "بقتیں": "بقنا",
  "بقو": "بقنا",
  "بقوں": "بقنا",
  "بقوا": "بقنا",
  "بقوانے": "بقنا",
  "بقوانا": "بقنا",
  "بقواتے": "بقنا",
  "بقواتا": "بقنا",
  "بقواتی": "بقنا",
  "بقواتیں": "بقنا",
  "بقواؤ": "بقنا",
  "بقواؤں": "بقنا",
  "بقوائے": "بقنا",
  "بقوائی": "بقنا",
  "بقوائیے": "بقنا",
  "بقوائیں": "بقنا",
  "بقوایا": "بقنا",
  "بقی": "بقنا",
  "بقیے": "بقنا",
  "بقیں": "بقنا",
  "بر": "بر",
  "برآمدے": "برآمدہ",
  "برآمدہ": "برآمدہ",
  "برآمدو": "برآمدہ",
  "برآمدوں": "برآمدہ",
  "برے": "برا",
  "برا": "برا",
  "برادے": "برادہ",
  "برادہ": "برادہ",
  "برادری": "برادری",
  "برادریاں": "برادری",
  "برادریو": "برادری",
  "برادریوں": "برادری",
  "برادو": "برادہ",
  "برادوں": "برادہ",
  "براہمن": "براہمن",
  "براہمنو": "براہمن",
  "براہمنوں": "براہمن",
  "برانڈ": "برانڈ",
  "برانڈو": "برانڈ",
  "برانڈوں": "برانڈ",
  "برائی": "برائی",
  "برائیاں": "برائی",
  "برائیو": "برائی",
  "برائیوں": "برائی",
  "برچھی": "برچھی",
  "برچھیاں": "برچھی",
  "برچھیو": "برچھی",
  "برچھیوں": "برچھی",
  "بردار": "بردار",
  "بردارو": "بردار",
  "برداروں": "بردار",
  "برداری": "برداری",
  "برداریاں": "برداری",
  "برداریو": "برداری",
  "برداریوں": "برداری",
  "برف": "برف",
  "برفو": "برف",
  "برفوں": "برف",
  "برفیں": "برف",
  "برج": "برج",
  "برجو": "برج",
  "برجوں": "برج",
  "برجیں": "برج",
  "برکت": "برکت",
  "برکتو": "برکت",
  "برکتوں": "برکت",
  "برکتیں": "برکت",
  "برقع": "برقع",
  "برقعے": "برقع",
  "برقعہ": "برقعہ",
  "برقعو": "برقع",
  "برقعوں": "برقع",
  "برس": "برس",
  "برسے": "برسنا",
  "برسں": "برسنا",
  "برسٹر": "برسٹر",
  "برسٹرو": "برسٹر",
  "برسٹروں": "برسٹر",
  "برسا": "برسنا",
  "برسانے": "برسنا",
  "برسانا": "برسنا",
  "برساتے": "برسنا",
  "برساتا": "برسنا",
  "برساتی": "برسنا",
  "برساتیں": "برسنا",
  "برساؤ": "برسنا",
  "برساؤں": "برسنا",
  "برسائے": "برسنا",
  "برسائی": "برسنا",
  "برسائیے": "برسنا",
  "برسائیں": "برسنا",
  "برسایا": "برسنا",
  "برسنے": "برسنا",
  "برسنا": "برسنا",
  "برسنی": "برسنا",
  "برستے": "برسنا",
  "برستا": "برسنا",
  "برستی": "برسنا",
  "برستیں": "برسنا",
  "برسو": "برس",
  "برسوں": "برس",
  "برسوا": "برسنا",
  "برسوانے": "برسنا",
  "برسوانا": "برسنا",
  "برسواتے": "برسنا",
  "برسواتا": "برسنا",
  "برسواتی": "برسنا",
  "برسواتیں": "برسنا",
  "برسواؤ": "برسنا",
  "برسواؤں": "برسنا",
  "برسوائے": "برسنا",
  "برسوائی": "برسنا",
  "برسوائیے": "برسنا",
  "برسوائیں": "برسنا",
  "برسوایا": "برسنا",
  "برسی": "برسنا",
  "برسیے": "برسنا",
  "برسیں": "برسنا",
  "برت": "برتنا",
  "برتَر": "بر",
  "برتَرین": "بر",
  "برتے": "برتنا",
  "برتں": "برتنا",
  "برتا": "برتنا",
  "برتانے": "برتنا",
  "برتانا": "برتنا",
  "برتاتے": "برتنا",
  "برتاتا": "برتنا",
  "برتاتی": "برتنا",
  "برتاتیں": "برتنا",
  "برتاؤ": "برتاؤ",
  "برتاؤں": "برتنا",
  "برتائے": "برتنا",
  "برتائی": "برتنا",
  "برتائیے": "برتنا",
  "برتائیں": "برتنا",
  "برتایا": "برتنا",
  "برتن": "برتن",
  "برتنے": "برتنا",
  "برتنا": "برتنا",
  "برتنو": "برتن",
  "برتنوں": "برتن",
  "برتنی": "برتنا",
  "برتر": "بر",
  "برترین": "بر",
  "برتتے": "برتنا",
  "برتتا": "برتنا",
  "برتتی": "برتنا",
  "برتتیں": "برتنا",
  "برتو": "برتنا",
  "برتوں": "برتنا",
  "برتوا": "برتنا",
  "برتوانے": "برتنا",
  "برتوانا": "برتنا",
  "برتواتے": "برتنا",
  "برتواتا": "برتنا",
  "برتواتی": "برتنا",
  "برتواتیں": "برتنا",
  "برتواؤ": "برتنا",
  "برتواؤں": "برتنا",
  "برتوائے": "برتنا",
  "برتوائی": "برتنا",
  "برتوائیے": "برتنا",
  "برتوائیں": "برتنا",
  "برتوایا": "برتنا",
  "برتی": "برتنا",
  "برتیے": "برتنا",
  "برتیں": "برتنا",
  "برو": "برا",
  "بروں": "برا",
  "بروزے": "بروزہ",
  "بروزہ": "بروزہ",
  "بروزو": "بروزہ",
  "بروزوں": "بروزہ",
  "بریک": "بریک",
  "بریکٹ": "بریکٹ",
  "بریکٹو": "بریکٹ",
  "بریکٹوں": "بریکٹ",
  "بریکٹیں": "بریکٹ",
  "بریکو": "بریک",
  "بریکوں": "بریک",
  "بریکیں": "بریک",
  "بس": "بس",
  "بسے": "بسنا",
  "بسں": "بسنا",
  "بسا": "بسنا",
  "بسانے": "بسنا",
  "بسانا": "بسنا",
  "بساتے": "بسنا",
  "بساتا": "بسنا",
  "بساتی": "بسنا",
  "بساتیں": "بسنا",
  "بساؤ": "بسنا",
  "بساؤں": "بسنا",
  "بسائے": "بسنا",
  "بسائی": "بسنا",
  "بسائیے": "بسنا",
  "بسائیں": "بسنا",
  "بسایا": "بسنا",
  "بسنے": "بسنا",
  "بسنا": "بسنا",
  "بسنی": "بسنا",
  "بستے": "بستہ",
  "بستا": "بسنا",
  "بستہ": "بستہ",
  "بستر": "بستر",
  "بسترے": "بسترا",
  "بسترا": "بسترا",
  "بسترو": "بسترا",
  "بستروں": "بسترا",
  "بستو": "بستہ",
  "بستوں": "بستہ",
  "بستی": "بستی",
  "بستیں": "بسنا",
  "بستیاں": "بستی",
  "بستیو": "بستی",
  "بستیوں": "بستی",
  "بسو": "بس",
  "بسوں": "بس",
  "بسوا": "بسنا",
  "بسوانے": "بسنا",
  "بسوانا": "بسنا",
  "بسواتے": "بسنا",
  "بسواتا": "بسنا",
  "بسواتی": "بسنا",
  "بسواتیں": "بسنا",
  "بسواؤ": "بسنا",
  "بسواؤں": "بسنا",
  "بسوائے": "بسنا",
  "بسوائی": "بسنا",
  "بسوائیے": "بسنا",
  "بسوائیں": "بسنا",
  "بسوایا": "بسنا",
  "بسولے": "بسولہ",
  "بسولہ": "بسولہ",
  "بسولو": "بسولہ",
  "بسولوں": "بسولہ",
  "بسور": "بسورنا",
  "بسورے": "بسورنا",
  "بسورں": "بسورنا",
  "بسورا": "بسورنا",
  "بسورنے": "بسورنا",
  "بسورنا": "بسورنا",
  "بسورنی": "بسورنا",
  "بسورتے": "بسورنا",
  "بسورتا": "بسورنا",
  "بسورتی": "بسورنا",
  "بسورتیں": "بسورنا",
  "بسورو": "بسورنا",
  "بسوروں": "بسورنا",
  "بسوری": "بسورنا",
  "بسوریے": "بسورنا",
  "بسوریں": "بسورنا",
  "بسی": "بسنا",
  "بسیے": "بسنا",
  "بسیں": "بس",
  "بت": "بت",
  "بتے": "بتہ",
  "بتا": "بتانا",
  "بتاں": "بتاں",
  "بتانے": "بتانا",
  "بتانا": "بتانا",
  "بتانی": "بتانا",
  "بتاتے": "بتانا",
  "بتاتا": "بتانا",
  "بتاتی": "بتانا",
  "بتاتیں": "بتانا",
  "بتاؤ": "بتانا",
  "بتاؤں": "بتانا",
  "بتائے": "بتانا",
  "بتائی": "بتانا",
  "بتائیے": "بتانا",
  "بتائیں": "بتانا",
  "بتایا": "بتانا",
  "بتہ": "بتہ",
  "بتلا": "بتلانا",
  "بتلانے": "بتلانا",
  "بتلانا": "بتلانا",
  "بتلانی": "بتلانا",
  "بتلاتے": "بتلانا",
  "بتلاتا": "بتلانا",
  "بتلاتی": "بتلانا",
  "بتلاتیں": "بتلانا",
  "بتلاؤ": "بتلانا",
  "بتلاؤں": "بتلانا",
  "بتلائے": "بتلانا",
  "بتلائی": "بتلانا",
  "بتلائیے": "بتلانا",
  "بتلائیں": "بتلانا",
  "بتلایا": "بتلانا",
  "بتلوا": "بتلانا",
  "بتلوانے": "بتلانا",
  "بتلوانا": "بتلانا",
  "بتلواتے": "بتلانا",
  "بتلواتا": "بتلانا",
  "بتلواتی": "بتلانا",
  "بتلواتیں": "بتلانا",
  "بتلواؤ": "بتلانا",
  "بتلواؤں": "بتلانا",
  "بتلوائے": "بتلانا",
  "بتلوائی": "بتلانا",
  "بتلوائیے": "بتلانا",
  "بتلوائیں": "بتلانا",
  "بتلوایا": "بتلانا",
  "بتو": "بتہ",
  "بتوں": "بتہ",
  "بتی": "بتی",
  "بتیاں": "بتی",
  "بتیو": "بتی",
  "بتیوں": "بتی",
  "بو": "بونا",
  "بوڑھے": "بوڑھا",
  "بوڑھا": "بوڑھا",
  "بوڑھو": "بوڑھا",
  "بوڑھوں": "بوڑھا",
  "بوڑھی": "بوڑھی",
  "بوڑھیا": "بوڑھیا",
  "بوڑھیاں": "بوڑھی",
  "بوڑھیو": "بوڑھی",
  "بوڑھیوں": "بوڑھی",
  "بوٹ": "بوٹ",
  "بوٹے": "بوٹا",
  "بوٹا": "بوٹا",
  "بوٹو": "بوٹا",
  "بوٹوں": "بوٹا",
  "بوٹی": "بوٹی",
  "بوٹیاں": "بوٹی",
  "بوٹیو": "بوٹی",
  "بوٹیوں": "بوٹی",
  "بوا": "بوا",
  "بواؤ": "بوا",
  "بواؤں": "بوا",
  "بوائیں": "بوا",
  "بول": "بول",
  "بولْں": "بولْنا",
  "بولْنے": "بولْنا",
  "بولْنا": "بولْنا",
  "بولْنی": "بولْنا",
  "بولْتے": "بولْنا",
  "بولْتا": "بولْنا",
  "بولْتی": "بولْنا",
  "بولْتیں": "بولْنا",
  "بولے": "بولْنا",
  "بولں": "بولنا",
  "بولا": "بولْنا",
  "بولنے": "بولنا",
  "بولنا": "بولنا",
  "بولنی": "بولنا",
  "بولتے": "بولنا",
  "بولتا": "بولنا",
  "بولتی": "بولنا",
  "بولتیں": "بولنا",
  "بولو": "بول",
  "بولوں": "بول",
  "بولی": "بولی",
  "بولیے": "بولْنا",
  "بولیں": "بولْنا",
  "بولیاں": "بولی",
  "بولیو": "بولی",
  "بولیوں": "بولی",
  "بونے": "بونا",
  "بونا": "بونا",
  "بوند": "بوند",
  "بوندو": "بوند",
  "بوندوں": "بوند",
  "بوندیں": "بوند",
  "بونگی": "بونگی",
  "بونگیاں": "بونگی",
  "بونگیو": "بونگی",
  "بونگیوں": "بونگی",
  "بونی": "بونا",
  "بوقوف": "بوقوف",
  "بوقوفو": "بوقوف",
  "بوقوفوں": "بوقوف",
  "بوقوفیں": "بوقوف",
  "بوری": "بوری",
  "بوریے": "بوریہ",
  "بوریا": "بوریا",
  "بوریاں": "بوری",
  "بوریہ": "بوریہ",
  "بوریو": "بوریہ",
  "بوریوں": "بوریہ",
  "بوسے": "بوسہ",
  "بوسہ": "بوسہ",
  "بوسو": "بوسہ",
  "بوسوں": "بوسہ",
  "بوتے": "بونا",
  "بوتا": "بونا",
  "بوتل": "بوتل",
  "بوتلو": "بوتل",
  "بوتلوں": "بوتل",
  "بوتلیں": "بوتل",
  "بوتی": "بونا",
  "بوتیں": "بونا",
  "بوؤ": "بونا",
  "بوؤں": "بونا",
  "بوئے": "بونا",
  "بوئی": "بونا",
  "بوئیے": "بونا",
  "بوئیں": "بونا",
  "بویا": "بونا",
  "بی": "بد",
  "بیڑے": "بیڑہ",
  "بیڑہ": "بیڑہ",
  "بیڑو": "بیڑہ",
  "بیڑوں": "بیڑہ",
  "بیڑی": "بیڑی",
  "بیڑیاں": "بیڑی",
  "بیڑیو": "بیڑی",
  "بیڑیوں": "بیڑی",
  "بیٹ": "بیٹ",
  "بیٹے": "بیٹا",
  "بیٹا": "بیٹا",
  "بیٹو": "بیٹا",
  "بیٹوں": "بیٹا",
  "بیٹی": "بیٹی",
  "بیٹیاں": "بیٹی",
  "بیٹیو": "بیٹی",
  "بیٹیوں": "بیٹی",
  "بیٹھ": "بیٹھنا",
  "بیٹھے": "بیٹھنا",
  "بیٹھں": "بیٹھنا",
  "بیٹھا": "بیٹھنا",
  "بیٹھانے": "بیٹھنا",
  "بیٹھانا": "بیٹھنا",
  "بیٹھاتے": "بیٹھنا",
  "بیٹھاتا": "بیٹھنا",
  "بیٹھاتی": "بیٹھنا",
  "بیٹھاتیں": "بیٹھنا",
  "بیٹھاؤ": "بیٹھنا",
  "بیٹھاؤں": "بیٹھنا",
  "بیٹھائے": "بیٹھنا",
  "بیٹھائی": "بیٹھنا",
  "بیٹھائیے": "بیٹھنا",
  "بیٹھائیں": "بیٹھنا",
  "بیٹھایا": "بیٹھنا",
  "بیٹھک": "بیٹھک",
  "بیٹھکو": "بیٹھک",
  "بیٹھکوں": "بیٹھک",
  "بیٹھکیں": "بیٹھک",
  "بیٹھنے": "بیٹھنا",
  "بیٹھنا": "بیٹھنا",
  "بیٹھنی": "بیٹھنا",
  "بیٹھتے": "بیٹھنا",
  "بیٹھتا": "بیٹھنا",
  "بیٹھتی": "بیٹھنا",
  "بیٹھتیں": "بیٹھنا",
  "بیٹھو": "بیٹھنا",
  "بیٹھوں": "بیٹھنا",
  "بیٹھی": "بیٹھنا",
  "بیٹھیے": "بیٹھنا",
  "بیٹھیں": "بیٹھنا",
  "بیش": "بیش",
  "بیابان": "بیابان",
  "بیابانو": "بیابان",
  "بیابانوں": "بیابان",
  "بیان": "بیان",
  "بیانے": "بیانا",
  "بیانا": "بیانا",
  "بیانات": "بیان",
  "بیانو": "بیانا",
  "بیانوں": "بیانا",
  "بیچ": "بیچنا",
  "بیچے": "بیچنا",
  "بیچں": "بیچنا",
  "بیچا": "بیچنا",
  "بیچارے": "بیچارا",
  "بیچارا": "بیچارا",
  "بیچارہ": "بیچارہ",
  "بیچارو": "بیچارا",
  "بیچاروں": "بیچارا",
  "بیچاری": "بیچاری",
  "بیچاریاں": "بیچاری",
  "بیچاریو": "بیچاری",
  "بیچاریوں": "بیچاری",
  "بیچنے": "بیچنا",
  "بیچنا": "بیچنا",
  "بیچنی": "بیچنا",
  "بیچتے": "بیچنا",
  "بیچتا": "بیچنا",
  "بیچتی": "بیچنا",
  "بیچتیں": "بیچنا",
  "بیچو": "بیچنا",
  "بیچوں": "بیچنا",
  "بیچوا": "بیچنا",
  "بیچوانے": "بیچنا",
  "بیچوانا": "بیچنا",
  "بیچواتے": "بیچنا",
  "بیچواتا": "بیچنا",
  "بیچواتی": "بیچنا",
  "بیچواتیں": "بیچنا",
  "بیچواؤ": "بیچنا",
  "بیچواؤں": "بیچنا",
  "بیچوائے": "بیچنا",
  "بیچوائی": "بیچنا",
  "بیچوائیے": "بیچنا",
  "بیچوائیں": "بیچنا",
  "بیچوایا": "بیچنا",
  "بیچی": "بیچنا",
  "بیچیے": "بیچنا",
  "بیچیں": "بیچنا",
  "بیگانے": "بیگانہ",
  "بیگانہ": "بیگانہ",
  "بیگانو": "بیگانہ",
  "بیگانوں": "بیگانہ",
  "بیج": "بیج",
  "بیجو": "بیج",
  "بیجوں": "بیج",
  "بیجیں": "بیج",
  "بیل": "بیل",
  "بیلے": "بیلنا",
  "بیلں": "بیلنا",
  "بیلا": "بیلنا",
  "بیلچے": "بیلچہ",
  "بیلچہ": "بیلچہ",
  "بیلچو": "بیلچہ",
  "بیلچوں": "بیلچہ",
  "بیلنے": "بیلنا",
  "بیلنا": "بیلنا",
  "بیلنی": "بیلنا",
  "بیلتے": "بیلنا",
  "بیلتا": "بیلنا",
  "بیلتی": "بیلنا",
  "بیلتیں": "بیلنا",
  "بیلو": "بیل",
  "بیلوں": "بیل",
  "بیلوا": "بیلنا",
  "بیلوانے": "بیلنا",
  "بیلوانا": "بیلنا",
  "بیلواتے": "بیلنا",
  "بیلواتا": "بیلنا",
  "بیلواتی": "بیلنا",
  "بیلواتیں": "بیلنا",
  "بیلواؤ": "بیلنا",
  "بیلواؤں": "بیلنا",
  "بیلوائے": "بیلنا",
  "بیلوائی": "بیلنا",
  "بیلوائیے": "بیلنا",
  "بیلوائیں": "بیلنا",
  "بیلوایا": "بیلنا",
  "بیلی": "بیلنا",
  "بیلیے": "بیلنا",
  "بیلیں": "بیل",
  "بیمار": "بیمار",
  "بیمارو": "بیمار",
  "بیماروں": "بیمار",
  "بیماری": "بیماری",
  "بیماریاں": "بیماری",
  "بیماریو": "بیماری",
  "بیماریوں": "بیماری",
  "بین": "بین",
  "بینچ": "بینچ",
  "بینچو": "بینچ",
  "بینچوں": "بینچ",
  "بینچیں": "بینچ",
  "بینگن": "بینگن",
  "بینگنو": "بینگن",
  "بینگنوں": "بینگن",
  "بینک": "بینک",
  "بینکو": "بینک",
  "بینکوں": "بینک",
  "بینکیں": "بینک",
  "بینو": "بین",
  "بینوں": "بین",
  "بیر": "بیر",
  "بیربہوٹی": "بیربہوٹی",
  "بیربہوٹیاں": "بیربہوٹی",
  "بیربہوٹیو": "بیربہوٹی",
  "بیربہوٹیوں": "بیربہوٹی",
  "بیرو": "بیر",
  "بیروں": "بیر",
  "بیری": "بیری",
  "بیریاں": "بیری",
  "بیریو": "بیری",
  "بیریوں": "بیری",
  "بیس": "بیس",
  "بیساکھی": "بیساکھی",
  "بیساکھیاں": "بیساکھی",
  "بیساکھیو": "بیساکھی",
  "بیساکھیوں": "بیساکھی",
  "بیسواں": "بیسواں",
  "بیسووںں": "بیسواں",
  "بیسویں": "بیسواں",
  "بیسی": "بیسی",
  "بیسیاں": "بیسی",
  "بیسیو": "بیسی",
  "بیسیوں": "بیسی",
  "بیوقوف": "بیوقوف",
  "بیوقوفو": "بیوقوف",
  "بیوقوفوں": "بیوقوف",
  "بیوی": "بیوی",
  "بیویاں": "بیوی",
  "بیویو": "بیوی",
  "بیویوں": "بیوی",
  "بیھج": "بیھجنا",
  "بیھجے": "بیھجنا",
  "بیھجں": "بیھجنا",
  "بیھجا": "بیھجنا",
  "بیھجنے": "بیھجنا",
  "بیھجنا": "بیھجنا",
  "بیھجنی": "بیھجنا",
  "بیھجتے": "بیھجنا",
  "بیھجتا": "بیھجنا",
  "بیھجتی": "بیھجنا",
  "بیھجتیں": "بیھجنا",
  "بیھجو": "بیھجنا",
  "بیھجوں": "بیھجنا",
  "بیھجی": "بیھجنا",
  "بیھجیے": "بیھجنا",
  "بیھجیں": "بیھجنا",
  "بزازے": "بزازہ",
  "بزازہ": "بزازہ",
  "بزازو": "بزازہ",
  "بزازوں": "بزازہ",
  "بزدل": "بزدل",
  "بزدلو": "بزدل",
  "بزدلوں": "بزدل",
  "بزرگ": "بزرگ",
  "بزرگو": "بزرگ",
  "بزرگوں": "بزرگ",
  "بھڑ": "بھڑ",
  "بھڑے": "بھڑنا",
  "بھڑں": "بھڑنا",
  "بھڑا": "بھڑنا",
  "بھڑانے": "بھڑنا",
  "بھڑانا": "بھڑنا",
  "بھڑاتے": "بھڑنا",
  "بھڑاتا": "بھڑنا",
  "بھڑاتی": "بھڑنا",
  "بھڑاتیں": "بھڑنا",
  "بھڑاؤ": "بھڑنا",
  "بھڑاؤں": "بھڑنا",
  "بھڑائے": "بھڑنا",
  "بھڑائی": "بھڑنا",
  "بھڑائیے": "بھڑنا",
  "بھڑائیں": "بھڑنا",
  "بھڑایا": "بھڑنا",
  "بھڑک": "بھڑکنا",
  "بھڑکے": "بھڑکنا",
  "بھڑکں": "بھڑکنا",
  "بھڑکا": "بھڑکنا",
  "بھڑکانے": "بھڑکنا",
  "بھڑکانا": "بھڑکنا",
  "بھڑکاتے": "بھڑکنا",
  "بھڑکاتا": "بھڑکنا",
  "بھڑکاتی": "بھڑکنا",
  "بھڑکاتیں": "بھڑکنا",
  "بھڑکاؤ": "بھڑکنا",
  "بھڑکاؤں": "بھڑکنا",
  "بھڑکائے": "بھڑکنا",
  "بھڑکائی": "بھڑکنا",
  "بھڑکائیے": "بھڑکنا",
  "بھڑکائیں": "بھڑکنا",
  "بھڑکایا": "بھڑکنا",
  "بھڑکنے": "بھڑکنا",
  "بھڑکنا": "بھڑکنا",
  "بھڑکنی": "بھڑکنا",
  "بھڑکتے": "بھڑکنا",
  "بھڑکتا": "بھڑکنا",
  "بھڑکتی": "بھڑکنا",
  "بھڑکتیں": "بھڑکنا",
  "بھڑکو": "بھڑکنا",
  "بھڑکوں": "بھڑکنا",
  "بھڑکوا": "بھڑکنا",
  "بھڑکوانے": "بھڑکنا",
  "بھڑکوانا": "بھڑکنا",
  "بھڑکواتے": "بھڑکنا",
  "بھڑکواتا": "بھڑکنا",
  "بھڑکواتی": "بھڑکنا",
  "بھڑکواتیں": "بھڑکنا",
  "بھڑکواؤ": "بھڑکنا",
  "بھڑکواؤں": "بھڑکنا",
  "بھڑکوائے": "بھڑکنا",
  "بھڑکوائی": "بھڑکنا",
  "بھڑکوائیے": "بھڑکنا",
  "بھڑکوائیں": "بھڑکنا",
  "بھڑکوایا": "بھڑکنا",
  "بھڑکی": "بھڑکنا",
  "بھڑکیے": "بھڑکنا",
  "بھڑکیں": "بھڑکنا",
  "بھڑنے": "بھڑنا",
  "بھڑنا": "بھڑنا",
  "بھڑنی": "بھڑنا",
  "بھڑتے": "بھڑنا",
  "بھڑتا": "بھڑنا",
  "بھڑتی": "بھڑنا",
  "بھڑتیں": "بھڑنا",
  "بھڑو": "بھڑ",
  "بھڑوں": "بھڑ",
  "بھڑوا": "بھڑنا",
  "بھڑوانے": "بھڑنا",
  "بھڑوانا": "بھڑنا",
  "بھڑواتے": "بھڑنا",
  "بھڑواتا": "بھڑنا",
  "بھڑواتی": "بھڑنا",
  "بھڑواتیں": "بھڑنا",
  "بھڑواؤ": "بھڑنا",
  "بھڑواؤں": "بھڑنا",
  "بھڑوائے": "بھڑنا",
  "بھڑوائی": "بھڑنا",
  "بھڑوائیے": "بھڑنا",
  "بھڑوائیں": "بھڑنا",
  "بھڑوایا": "بھڑنا",
  "بھڑی": "بھڑنا",
  "بھڑیے": "بھڑنا",
  "بھڑیں": "بھڑ",
  "بھٹ": "بھٹ",
  "بھٹّے": "بھٹّہ",
  "بھٹّہ": "بھٹّہ",
  "بھٹّو": "بھٹّہ",
  "بھٹّوں": "بھٹّہ",
  "بھٹک": "بھٹکنا",
  "بھٹکے": "بھٹکنا",
  "بھٹکں": "بھٹکنا",
  "بھٹکا": "بھٹکنا",
  "بھٹکانے": "بھٹکنا",
  "بھٹکانا": "بھٹکنا",
  "بھٹکاتے": "بھٹکنا",
  "بھٹکاتا": "بھٹکنا",
  "بھٹکاتی": "بھٹکنا",
  "بھٹکاتیں": "بھٹکنا",
  "بھٹکاؤ": "بھٹکنا",
  "بھٹکاؤں": "بھٹکنا",
  "بھٹکائے": "بھٹکنا",
  "بھٹکائی": "بھٹکنا",
  "بھٹکائیے": "بھٹکنا",
  "بھٹکائیں": "بھٹکنا",
  "بھٹکایا": "بھٹکنا",
  "بھٹکنے": "بھٹکنا",
  "بھٹکنا": "بھٹکنا",
  "بھٹکنی": "بھٹکنا",
  "بھٹکتے": "بھٹکنا",
  "بھٹکتا": "بھٹکنا",
  "بھٹکتی": "بھٹکنا",
  "بھٹکتیں": "بھٹکنا",
  "بھٹکو": "بھٹکنا",
  "بھٹکوں": "بھٹکنا",
  "بھٹکوا": "بھٹکنا",
  "بھٹکوانے": "بھٹکنا",
  "بھٹکوانا": "بھٹکنا",
  "بھٹکواتے": "بھٹکنا",
  "بھٹکواتا": "بھٹکنا",
  "بھٹکواتی": "بھٹکنا",
  "بھٹکواتیں": "بھٹکنا",
  "بھٹکواؤ": "بھٹکنا",
  "بھٹکواؤں": "بھٹکنا",
  "بھٹکوائے": "بھٹکنا",
  "بھٹکوائی": "بھٹکنا",
  "بھٹکوائیے": "بھٹکنا",
  "بھٹکوائیں": "بھٹکنا",
  "بھٹکوایا": "بھٹکنا",
  "بھٹکی": "بھٹکنا",
  "بھٹکیے": "بھٹکنا",
  "بھٹکیں": "بھٹکنا",
  "بھٹو": "بھٹ",
  "بھٹوں": "بھٹ",
  "بھٹی": "بھٹی",
  "بھٹیاں": "بھٹی",
  "بھٹیو": "بھٹی",
  "بھٹیوں": "بھٹی",
  "بھاڑ": "بھاڑ",
  "بھاڑے": "بھاڑا",
  "بھاڑا": "بھاڑا",
  "بھاڑو": "بھاڑا",
  "بھاڑوں": "بھاڑا",
  "بھاشا": "بھاشا",
  "بھاشاؤ": "بھاشا",
  "بھاشاؤں": "بھاشا",
  "بھاشائیں": "بھاشا",
  "بھابی": "بھابی",
  "بھابیاں": "بھابی",
  "بھابیو": "بھابی",
  "بھابیوں": "بھابی",
  "بھاگ": "بھاگْنا",
  "بھاگْں": "بھاگْنا",
  "بھاگْنے": "بھاگْنا",
  "بھاگْنا": "بھاگْنا",
  "بھاگْنی": "بھاگْنا",
  "بھاگْتے": "بھاگْنا",
  "بھاگْتا": "بھاگْنا",
  "بھاگْتی": "بھاگْنا",
  "بھاگْتیں": "بھاگْنا",
  "بھاگے": "بھاگْنا",
  "بھاگں": "بھاگنا",
  "بھاگا": "بھاگْنا",
  "بھاگنے": "بھاگنا",
  "بھاگنا": "بھاگنا",
  "بھاگنی": "بھاگنا",
  "بھاگتے": "بھاگنا",
  "بھاگتا": "بھاگنا",
  "بھاگتی": "بھاگنا",
  "بھاگتیں": "بھاگنا",
  "بھاگو": "بھاگْنا",
  "بھاگوں": "بھاگْنا",
  "بھاگوان": "بھاگوان",
  "بھاگوانو": "بھاگوان",
  "بھاگوانوں": "بھاگوان",
  "بھاگی": "بھاگْنا",
  "بھاگیے": "بھاگْنا",
  "بھاگیں": "بھاگْنا",
  "بھال": "بھال",
  "بھالے": "بھالا",
  "بھالا": "بھالا",
  "بھالو": "بھالا",
  "بھالوں": "بھالا",
  "بھانڈ": "بھانڈ",
  "بھانڈے": "بھانڈا",
  "بھانڈا": "بھانڈا",
  "بھانڈہ": "بھانڈہ",
  "بھانڈو": "بھانڈا",
  "بھانڈوں": "بھانڈا",
  "بھانڈیں": "بھانڈ",
  "بھانجے": "بھانجا",
  "بھانجا": "بھانجا",
  "بھانجو": "بھانجا",
  "بھانجوں": "بھانجا",
  "بھانجی": "بھانجی",
  "بھانجیاں": "بھانجی",
  "بھانجیو": "بھانجی",
  "بھانجیوں": "بھانجی",
  "بھارتی": "بھارتی",
  "بھارتیے": "بھارتیہ",
  "بھارتیہ": "بھارتیہ",
  "بھارتیو": "بھارتیہ",
  "بھارتیوں": "بھارتیہ",
  "بھاؤ": "بھاؤ",
  "بھائی": "بھائی",
  "بھائیو": "بھائی",
  "بھائیوں": "بھائی",
  "بھچا": "بھینچنا",
  "بھچانے": "بھینچنا",
  "بھچانا": "بھینچنا",
  "بھچاتے": "بھینچنا",
  "بھچاتا": "بھینچنا",
  "بھچاتی": "بھینچنا",
  "بھچاتیں": "بھینچنا",
  "بھچاؤ": "بھینچنا",
  "بھچاؤں": "بھینچنا",
  "بھچائے": "بھینچنا",
  "بھچائی": "بھینچنا",
  "بھچائیے": "بھینچنا",
  "بھچائیں": "بھینچنا",
  "بھچایا": "بھینچنا",
  "بھگ": "بھگنا",
  "بھگْوا": "بھاگْنا",
  "بھگْوانے": "بھاگْنا",
  "بھگْوانا": "بھاگْنا",
  "بھگْواتے": "بھاگْنا",
  "بھگْواتا": "بھاگْنا",
  "بھگْواتی": "بھاگْنا",
  "بھگْواتیں": "بھاگْنا",
  "بھگْواؤ": "بھاگْنا",
  "بھگْواؤں": "بھاگْنا",
  "بھگْوائے": "بھاگْنا",
  "بھگْوائی": "بھاگْنا",
  "بھگْوائیے": "بھاگْنا",
  "بھگْوائیں": "بھاگْنا",
  "بھگْوایا": "بھاگْنا",
  "بھگے": "بھگنا",
  "بھگں": "بھگنا",
  "بھگا": "بھاگْنا",
  "بھگانے": "بھاگْنا",
  "بھگانا": "بھاگْنا",
  "بھگاتے": "بھاگْنا",
  "بھگاتا": "بھاگْنا",
  "بھگاتی": "بھاگْنا",
  "بھگاتیں": "بھاگْنا",
  "بھگاؤ": "بھاگْنا",
  "بھگاؤں": "بھاگْنا",
  "بھگائے": "بھاگْنا",
  "بھگائی": "بھاگْنا",
  "بھگائیے": "بھاگْنا",
  "بھگائیں": "بھاگْنا",
  "بھگایا": "بھاگْنا",
  "بھگنے": "بھگنا",
  "بھگنا": "بھگنا",
  "بھگنی": "بھگنا",
  "بھگت": "بھگت",
  "بھگتے": "بھگتنا",
  "بھگتں": "بھگتنا",
  "بھگتا": "بھگتنا",
  "بھگتانے": "بھگتنا",
  "بھگتانا": "بھگتنا",
  "بھگتاتے": "بھگتنا",
  "بھگتاتا": "بھگتنا",
  "بھگتاتی": "بھگتنا",
  "بھگتاتیں": "بھگتنا",
  "بھگتاؤ": "بھگتنا",
  "بھگتاؤں": "بھگتنا",
  "بھگتائے": "بھگتنا",
  "بھگتائی": "بھگتنا",
  "بھگتائیے": "بھگتنا",
  "بھگتائیں": "بھگتنا",
  "بھگتایا": "بھگتنا",
  "بھگتنے": "بھگتنا",
  "بھگتنا": "بھگتنا",
  "بھگتنی": "بھگتنا",
  "بھگتتے": "بھگتنا",
  "بھگتتا": "بھگتنا",
  "بھگتتی": "بھگتنا",
  "بھگتتیں": "بھگتنا",
  "بھگتو": "بھگت",
  "بھگتوں": "بھگت",
  "بھگتوا": "بھگتنا",
  "بھگتوانے": "بھگتنا",
  "بھگتوانا": "بھگتنا",
  "بھگتواتے": "بھگتنا",
  "بھگتواتا": "بھگتنا",
  "بھگتواتی": "بھگتنا",
  "بھگتواتیں": "بھگتنا",
  "بھگتواؤ": "بھگتنا",
  "بھگتواؤں": "بھگتنا",
  "بھگتوائے": "بھگتنا",
  "بھگتوائی": "بھگتنا",
  "بھگتوائیے": "بھگتنا",
  "بھگتوائیں": "بھگتنا",
  "بھگتوایا": "بھگتنا",
  "بھگتی": "بھگتنا",
  "بھگتیے": "بھگتنا",
  "بھگتیں": "بھگت",
  "بھگو": "بِھیگْنا",
  "بھگوں": "بھگنا",
  "بھگوا": "بھگنا",
  "بھگوانے": "بھگنا",
  "بھگوانا": "بھگنا",
  "بھگواتے": "بھگنا",
  "بھگواتا": "بھگنا",
  "بھگواتی": "بھگنا",
  "بھگواتیں": "بھگنا",
  "بھگواؤ": "بھگنا",
  "بھگواؤں": "بھگنا",
  "بھگوائے": "بھگنا",
  "بھگوائی": "بھگنا",
  "بھگوائیے": "بھگنا",
  "بھگوائیں": "بھگنا",
  "بھگوایا": "بھگنا",
  "بھگونے": "بِھیگْنا",
  "بھگونا": "بِھیگْنا",
  "بھگوتے": "بِھیگْنا",
  "بھگوتا": "بِھیگْنا",
  "بھگوتی": "بِھیگْنا",
  "بھگوتیں": "بِھیگْنا",
  "بھگوؤ": "بِھیگْنا",
  "بھگوؤں": "بِھیگْنا",
  "بھگوئے": "بِھیگْنا",
  "بھگوئی": "بِھیگْنا",
  "بھگوئیے": "بِھیگْنا",
  "بھگوئیں": "بِھیگْنا",
  "بھگویا": "بِھیگْنا",
  "بھگی": "بھگنا",
  "بھگیے": "بھگنا",
  "بھگیں": "بھگنا",
  "بھج": "بھجنا",
  "بھجے": "بھجنا",
  "بھجں": "بھجنا",
  "بھجا": "بھجنا",
  "بھجانے": "بھجنا",
  "بھجانا": "بھجنا",
  "بھجاتے": "بھجنا",
  "بھجاتا": "بھجنا",
  "بھجاتی": "بھجنا",
  "بھجاتیں": "بھجنا",
  "بھجاؤ": "بھجنا",
  "بھجاؤں": "بھجنا",
  "بھجائے": "بھجنا",
  "بھجائی": "بھجنا",
  "بھجائیے": "بھجنا",
  "بھجائیں": "بھجنا",
  "بھجایا": "بھجنا",
  "بھجنے": "بھجنا",
  "بھجنا": "بھجنا",
  "بھجنی": "بھجنا",
  "بھجتے": "بھجنا",
  "بھجتا": "بھجنا",
  "بھجتی": "بھجنا",
  "بھجتیں": "بھجنا",
  "بھجو": "بھجنا",
  "بھجوں": "بھجنا",
  "بھجوا": "بھجنا",
  "بھجوانے": "بھجنا",
  "بھجوانا": "بھجنا",
  "بھجواتے": "بھجنا",
  "بھجواتا": "بھجنا",
  "بھجواتی": "بھجنا",
  "بھجواتیں": "بھجنا",
  "بھجواؤ": "بھجنا",
  "بھجواؤں": "بھجنا",
  "بھجوائے": "بھجنا",
  "بھجوائی": "بھجنا",
  "بھجوائیے": "بھجنا",
  "بھجوائیں": "بھجنا",
  "بھجوایا": "بھجنا",
  "بھجی": "بھجنا",
  "بھجیے": "بھجنا",
  "بھجیں": "بھجنا",
  "بھل": "بھل",
  "بھلے": "بھلا",
  "بھلا": "بھلا",
  "بھلانے": "بھولنا",
  "بھلانا": "بھولنا",
  "بھلاتے": "بھولنا",
  "بھلاتا": "بھولنا",
  "بھلاتی": "بھولنا",
  "بھلاتیں": "بھولنا",
  "بھلاؤ": "بھولنا",
  "بھلاؤں": "بھولنا",
  "بھلائے": "بھولنا",
  "بھلائی": "بھلائی",
  "بھلائیے": "بھولنا",
  "بھلائیں": "بھولنا",
  "بھلائیاں": "بھلائی",
  "بھلائیو": "بھلائی",
  "بھلائیوں": "بھلائی",
  "بھلایا": "بھولنا",
  "بھلو": "بھلا",
  "بھلوں": "بھلا",
  "بھلوا": "بھولنا",
  "بھلوانے": "بھولنا",
  "بھلوانا": "بھولنا",
  "بھلواتے": "بھولنا",
  "بھلواتا": "بھولنا",
  "بھلواتی": "بھولنا",
  "بھلواتیں": "بھولنا",
  "بھلواؤ": "بھولنا",
  "بھلواؤں": "بھولنا",
  "بھلوائے": "بھولنا",
  "بھلوائی": "بھولنا",
  "بھلوائیے": "بھولنا",
  "بھلوائیں": "بھولنا",
  "بھلوایا": "بھولنا",
  "بھلی": "بھلی",
  "بھلیاں": "بھلی",
  "بھلیو": "بھلی",
  "بھلیوں": "بھلی",
  "بھن": "بھننا",
  "بھنے": "بھننا",
  "بھنں": "بھننا",
  "بھنا": "بھننا",
  "بھنانے": "بھننا",
  "بھنانا": "بھننا",
  "بھناتے": "بھننا",
  "بھناتا": "بھننا",
  "بھناتی": "بھننا",
  "بھناتیں": "بھننا",
  "بھناؤ": "بھننا",
  "بھناؤں": "بھننا",
  "بھنائے": "بھننا",
  "بھنائی": "بھننا",
  "بھنائیے": "بھننا",
  "بھنائیں": "بھننا",
  "بھنایا": "بھننا",
  "بھنچوا": "بھینچنا",
  "بھنچوانے": "بھینچنا",
  "بھنچوانا": "بھینچنا",
  "بھنچواتے": "بھینچنا",
  "بھنچواتا": "بھینچنا",
  "بھنچواتی": "بھینچنا",
  "بھنچواتیں": "بھینچنا",
  "بھنچواؤ": "بھینچنا",
  "بھنچواؤں": "بھینچنا",
  "بھنچوائے": "بھینچنا",
  "بھنچوائی": "بھینچنا",
  "بھنچوائیے": "بھینچنا",
  "بھنچوائیں": "بھینچنا",
  "بھنچوایا": "بھینچنا",
  "بھنگ": "بھنگ",
  "بھنگو": "بھنگ",
  "بھنگوں": "بھنگ",
  "بھننے": "بھننا",
  "بھننا": "بھننا",
  "بھننی": "بھننا",
  "بھنتے": "بھننا",
  "بھنتا": "بھننا",
  "بھنتی": "بھننا",
  "بھنتیں": "بھننا",
  "بھنو": "بھننا",
  "بھنوں": "بھننا",
  "بھنوا": "بھننا",
  "بھنوانے": "بھننا",
  "بھنوانا": "بھننا",
  "بھنواتے": "بھننا",
  "بھنواتا": "بھننا",
  "بھنواتی": "بھننا",
  "بھنواتیں": "بھننا",
  "بھنواؤ": "بھننا",
  "بھنواؤں": "بھننا",
  "بھنوائے": "بھننا",
  "بھنوائی": "بھننا",
  "بھنوائیے": "بھننا",
  "بھنوائیں": "بھننا",
  "بھنوایا": "بھننا",
  "بھنی": "بھننا",
  "بھنیے": "بھننا",
  "بھنیں": "بھننا",
  "بھرے": "بھرا",
  "بھرا": "بھرا",
  "بھرو": "بھرا",
  "بھروں": "بھرا",
  "بھروسے": "بھروسہ",
  "بھروسہ": "بھروسہ",
  "بھروسو": "بھروسہ",
  "بھروسوں": "بھروسہ",
  "بھتیجے": "بھتیجا",
  "بھتیجا": "بھتیجا",
  "بھتیجہ": "بھتیجہ",
  "بھتیجو": "بھتیجا",
  "بھتیجوں": "بھتیجا",
  "بھتیجی": "بھتیجی",
  "بھتیجیاں": "بھتیجی",
  "بھتیجیو": "بھتیجی",
  "بھتیجیوں": "بھتیجی",
  "بھوک": "بھوک",
  "بھوکے": "بھوکا",
  "بھوکا": "بھوکا",
  "بھوکو": "بھوکا",
  "بھوکوں": "بھوکا",
  "بھول": "بھولنا",
  "بھولے": "بھولا",
  "بھولں": "بھولنا",
  "بھولا": "بھولا",
  "بھولنے": "بھولنا",
  "بھولنا": "بھولنا",
  "بھولنی": "بھولنا",
  "بھولتے": "بھولنا",
  "بھولتا": "بھولنا",
  "بھولتی": "بھولنا",
  "بھولتیں": "بھولنا",
  "بھولو": "بھولا",
  "بھولوں": "بھولا",
  "بھولی": "بھولنا",
  "بھولیے": "بھولنا",
  "بھولیں": "بھولنا",
  "بھون": "بھوننا",
  "بھونے": "بھوننا",
  "بھونں": "بھوننا",
  "بھونا": "بھوننا",
  "بھوننے": "بھوننا",
  "بھوننا": "بھوننا",
  "بھوننی": "بھوننا",
  "بھونتے": "بھوننا",
  "بھونتا": "بھوننا",
  "بھونتی": "بھوننا",
  "بھونتیں": "بھوننا",
  "بھونو": "بھوننا",
  "بھونوں": "بھوننا",
  "بھونی": "بھوننا",
  "بھونیے": "بھوننا",
  "بھونیں": "بھوننا",
  "بھوسے": "بھوسہ",
  "بھوسہ": "بھوسہ",
  "بھوسو": "بھوسہ",
  "بھوسوں": "بھوسہ",
  "بھوت": "بھوت",
  "بھوتو": "بھوت",
  "بھوتوں": "بھوت",
  "بھوتیں": "بھوت",
  "بھی": "بھی",
  "بھیڑ": "بھیڑ",
  "بھیڑے": "بھیڑہ",
  "بھیڑہ": "بھیڑہ",
  "بھیڑو": "بھیڑہ",
  "بھیڑوں": "بھیڑہ",
  "بھیڑیں": "بھیڑ",
  "بھئی": "بھئی",
  "بھید": "بھید",
  "بھیدو": "بھید",
  "بھیدوں": "بھید",
  "بھیدیں": "بھید",
  "بھیگ": "بھیگنا",
  "بھیگے": "بھیگنا",
  "بھیگں": "بھیگنا",
  "بھیگا": "بھیگنا",
  "بھیگنے": "بھیگنا",
  "بھیگنا": "بھیگنا",
  "بھیگنی": "بھیگنا",
  "بھیگتے": "بھیگنا",
  "بھیگتا": "بھیگنا",
  "بھیگتی": "بھیگنا",
  "بھیگتیں": "بھیگنا",
  "بھیگو": "بھیگنا",
  "بھیگوں": "بھیگنا",
  "بھیگی": "بھیگنا",
  "بھیگیے": "بھیگنا",
  "بھیگیں": "بھیگنا",
  "بھیج": "بھیجنا",
  "بھیجے": "بھیجا",
  "بھیجں": "بھیجنا",
  "بھیجا": "بھیجا",
  "بھیجنے": "بھیجنا",
  "بھیجنا": "بھیجنا",
  "بھیجنی": "بھیجنا",
  "بھیجتے": "بھیجنا",
  "بھیجتا": "بھیجنا",
  "بھیجتی": "بھیجنا",
  "بھیجتیں": "بھیجنا",
  "بھیجو": "بھیجا",
  "بھیجوں": "بھیجا",
  "بھیجی": "بھیجنا",
  "بھیجیے": "بھیجنا",
  "بھیجیں": "بھیجنا",
  "بھیک": "بھیک",
  "بھیکو": "بھیک",
  "بھیکوں": "بھیک",
  "بھیکیں": "بھیک",
  "بھینچ": "بھینچنا",
  "بھینچے": "بھینچنا",
  "بھینچں": "بھینچنا",
  "بھینچا": "بھینچنا",
  "بھینچنے": "بھینچنا",
  "بھینچنا": "بھینچنا",
  "بھینچنی": "بھینچنا",
  "بھینچتے": "بھینچنا",
  "بھینچتا": "بھینچنا",
  "بھینچتی": "بھینچنا",
  "بھینچتیں": "بھینچنا",
  "بھینچو": "بھینچنا",
  "بھینچوں": "بھینچنا",
  "بھینچی": "بھینچنا",
  "بھینچیے": "بھینچنا",
  "بھینچیں": "بھینچنا",
  "بھینس": "بھینس",
  "بھینسو": "بھینس",
  "بھینسوں": "بھینس",
  "بھینسیں": "بھینس",
  "بھیت": "بھیت",
  "بھیتو": "بھیت",
  "بھیتوں": "بھیت",
  "بطخ": "بطخ",
  "بطخو": "بطخ",
  "بطخوں": "بطخ",
  "بطخیں": "بطخ",
  "چَل": "چَلنا",
  "چَلے": "چَلنا",
  "چَلں": "چَلنا",
  "چَلا": "چَلنا",
  "چَلانے": "چَلنا",
  "چَلانا": "چَلنا",
  "چَلاتے": "چَلنا",
  "چَلاتا": "چَلنا",
  "چَلاتی": "چَلنا",
  "چَلاتیں": "چَلنا",
  "چَلاؤ": "چَلنا",
  "چَلاؤں": "چَلنا",
  "چَلائے": "چَلنا",
  "چَلائی": "چَلنا",
  "چَلائیے": "چَلنا",
  "چَلائیں": "چَلنا",
  "چَلایا": "چَلنا",
  "چَلنے": "چَلنا",
  "چَلنا": "چَلنا",
  "چَلنی": "چَلنا",
  "چَلتے": "چَلنا",
  "چَلتا": "چَلنا",
  "چَلتی": "چَلنا",
  "چَلتیں": "چَلنا",
  "چَلو": "چَلنا",
  "چَلوں": "چَلنا",
  "چَلوا": "چَلنا",
  "چَلوانے": "چَلنا",
  "چَلوانا": "چَلنا",
  "چَلواتے": "چَلنا",
  "چَلواتا": "چَلنا",
  "چَلواتی": "چَلنا",
  "چَلواتیں": "چَلنا",
  "چَلواؤ": "چَلنا",
  "چَلواؤں": "چَلنا",
  "چَلوائے": "چَلنا",
  "چَلوائی": "چَلنا",
  "چَلوائیے": "چَلنا",
  "چَلوائیں": "چَلنا",
  "چَلوایا": "چَلنا",
  "چَلی": "چَلنا",
  "چَلیے": "چَلنا",
  "چَلیں": "چَلنا",
  "چَند": "چَند",
  "چَر": "چَرنا",
  "چَرے": "چَرنا",
  "چَرں": "چَرنا",
  "چَرا": "چَرنا",
  "چَرانے": "چَرنا",
  "چَرانا": "چَرنا",
  "چَراتے": "چَرنا",
  "چَراتا": "چَرنا",
  "چَراتی": "چَرنا",
  "چَراتیں": "چَرنا",
  "چَراؤ": "چَرنا",
  "چَراؤں": "چَرنا",
  "چَرائے": "چَرنا",
  "چَرائی": "چَرنا",
  "چَرائیے": "چَرنا",
  "چَرائیں": "چَرنا",
  "چَرایا": "چَرنا",
  "چَرنے": "چَرنا",
  "چَرنا": "چَرنا",
  "چَرنی": "چَرنا",
  "چَرتے": "چَرنا",
  "چَرتا": "چَرنا",
  "چَرتی": "چَرنا",
  "چَرتیں": "چَرنا",
  "چَرو": "چَرنا",
  "چَروں": "چَرنا",
  "چَروا": "چَرنا",
  "چَروانے": "چَرنا",
  "چَروانا": "چَرنا",
  "چَرواتے": "چَرنا",
  "چَرواتا": "چَرنا",
  "چَرواتی": "چَرنا",
  "چَرواتیں": "چَرنا",
  "چَرواؤ": "چَرنا",
  "چَرواؤں": "چَرنا",
  "چَروائے": "چَرنا",
  "چَروائی": "چَرنا",
  "چَروائیے": "چَرنا",
  "چَروائیں": "چَرنا",
  "چَروایا": "چَرنا",
  "چَری": "چَرنا",
  "چَریے": "چَرنا",
  "چَریں": "چَرنا",
  "چِڑ": "چِڑنا",
  "چِڑْیا": "چِڑْیا",
  "چِڑْیاں": "چِڑْیا",
  "چِڑْیو": "چِڑْیا",
  "چِڑْیوں": "چِڑْیا",
  "چِڑے": "چِڑنا",
  "چِڑں": "چِڑنا",
  "چِڑا": "چِڑنا",
  "چِڑانے": "چِڑنا",
  "چِڑانا": "چِڑنا",
  "چِڑاتے": "چِڑنا",
  "چِڑاتا": "چِڑنا",
  "چِڑاتی": "چِڑنا",
  "چِڑاتیں": "چِڑنا",
  "چِڑاؤ": "چِڑنا",
  "چِڑاؤں": "چِڑنا",
  "چِڑائے": "چِڑنا",
  "چِڑائی": "چِڑنا",
  "چِڑائیے": "چِڑنا",
  "چِڑائیں": "چِڑنا",
  "چِڑایا": "چِڑنا",
  "چِڑنے": "چِڑنا",
  "چِڑنا": "چِڑنا",
  "چِڑنی": "چِڑنا",
  "چِڑتے": "چِڑنا",
  "چِڑتا": "چِڑنا",
  "چِڑتی": "چِڑنا",
  "چِڑتیں": "چِڑنا",
  "چِڑو": "چِڑنا",
  "چِڑوں": "چِڑنا",
  "چِڑوا": "چِڑنا",
  "چِڑوانے": "چِڑنا",
  "چِڑوانا": "چِڑنا",
  "چِڑواتے": "چِڑنا",
  "چِڑواتا": "چِڑنا",
  "چِڑواتی": "چِڑنا",
  "چِڑواتیں": "چِڑنا",
  "چِڑواؤ": "چِڑنا",
  "چِڑواؤں": "چِڑنا",
  "چِڑوائے": "چِڑنا",
  "چِڑوائی": "چِڑنا",
  "چِڑوائیے": "چِڑنا",
  "چِڑوائیں": "چِڑنا",
  "چِڑوایا": "چِڑنا",
  "چِڑی": "چِڑنا",
  "چِڑیے": "چِڑنا",
  "چِڑیں": "چِڑنا",
  "چِر": "چِرْنا",
  "چِرْں": "چِرْنا",
  "چِرْنے": "چِرْنا",
  "چِرْنا": "چِرْنا",
  "چِرْنی": "چِرْنا",
  "چِرْتے": "چِرْنا",
  "چِرْتا": "چِرْنا",
  "چِرْتی": "چِرْنا",
  "چِرْتیں": "چِرْنا",
  "چِرْوا": "چِرْنا",
  "چِرْوانے": "چِرْنا",
  "چِرْوانا": "چِرْنا",
  "چِرْواتے": "چِرْنا",
  "چِرْواتا": "چِرْنا",
  "چِرْواتی": "چِرْنا",
  "چِرْواتیں": "چِرْنا",
  "چِرْواؤ": "چِرْنا",
  "چِرْواؤں": "چِرْنا",
  "چِرْوائے": "چِرْنا",
  "چِرْوائی": "چِرْنا",
  "چِرْوائیے": "چِرْنا",
  "چِرْوائیں": "چِرْنا",
  "چِرْوایا": "چِرْنا",
  "چِرے": "چِرْنا",
  "چِرا": "چِرْنا",
  "چِرو": "چِرْنا",
  "چِروں": "چِرْنا",
  "چِری": "چِرْنا",
  "چِریے": "چِرْنا",
  "چِریں": "چِرْنا",
  "چِیر": "چِرْنا",
  "چِیرْں": "چِرْنا",
  "چِیرْنے": "چِرْنا",
  "چِیرْنا": "چِرْنا",
  "چِیرْتے": "چِرْنا",
  "چِیرْتا": "چِرْنا",
  "چِیرْتی": "چِرْنا",
  "چِیرْتیں": "چِرْنا",
  "چِیرے": "چِرْنا",
  "چِیرا": "چِرْنا",
  "چِیرو": "چِرْنا",
  "چِیروں": "چِرْنا",
  "چِیری": "چِرْنا",
  "چِیریے": "چِرْنا",
  "چِیریں": "چِرْنا",
  "چُک": "چُکنا",
  "چُکے": "چُکنا",
  "چُکں": "چُکنا",
  "چُکا": "چُکنا",
  "چُکانے": "چُکنا",
  "چُکانا": "چُکنا",
  "چُکاتے": "چُکنا",
  "چُکاتا": "چُکنا",
  "چُکاتی": "چُکنا",
  "چُکاتیں": "چُکنا",
  "چُکاؤ": "چُکنا",
  "چُکاؤں": "چُکنا",
  "چُکائے": "چُکنا",
  "چُکائی": "چُکنا",
  "چُکائیے": "چُکنا",
  "چُکائیں": "چُکنا",
  "چُکایا": "چُکنا",
  "چُکنے": "چُکنا",
  "چُکنا": "چُکنا",
  "چُکنی": "چُکنا",
  "چُکتے": "چُکنا",
  "چُکتا": "چُکنا",
  "چُکتی": "چُکنا",
  "چُکتیں": "چُکنا",
  "چُکو": "چُکنا",
  "چُکوں": "چُکنا",
  "چُکوا": "چُکنا",
  "چُکوانے": "چُکنا",
  "چُکوانا": "چُکنا",
  "چُکواتے": "چُکنا",
  "چُکواتا": "چُکنا",
  "چُکواتی": "چُکنا",
  "چُکواتیں": "چُکنا",
  "چُکواؤ": "چُکنا",
  "چُکواؤں": "چُکنا",
  "چُکوائے": "چُکنا",
  "چُکوائی": "چُکنا",
  "چُکوائیے": "چُکنا",
  "چُکوائیں": "چُکنا",
  "چُکوایا": "چُکنا",
  "چُکی": "چُکنا",
  "چُکیے": "چُکنا",
  "چُکیں": "چُکنا",
  "چُن": "چُننا",
  "چُنے": "چُننا",
  "چُنں": "چُننا",
  "چُنا": "چُننا",
  "چُنانے": "چُننا",
  "چُنانا": "چُننا",
  "چُناتے": "چُننا",
  "چُناتا": "چُننا",
  "چُناتی": "چُننا",
  "چُناتیں": "چُننا",
  "چُناؤ": "چُننا",
  "چُناؤں": "چُننا",
  "چُنائے": "چُننا",
  "چُنائی": "چُننا",
  "چُنائیے": "چُننا",
  "چُنائیں": "چُننا",
  "چُنایا": "چُننا",
  "چُننے": "چُننا",
  "چُننا": "چُننا",
  "چُننی": "چُننا",
  "چُنتے": "چُننا",
  "چُنتا": "چُننا",
  "چُنتی": "چُننا",
  "چُنتیں": "چُننا",
  "چُنو": "چُننا",
  "چُنوں": "چُننا",
  "چُنوا": "چُننا",
  "چُنوانے": "چُننا",
  "چُنوانا": "چُننا",
  "چُنواتے": "چُننا",
  "چُنواتا": "چُننا",
  "چُنواتی": "چُننا",
  "چُنواتیں": "چُننا",
  "چُنواؤ": "چُننا",
  "چُنواؤں": "چُننا",
  "چُنوائے": "چُننا",
  "چُنوائی": "چُننا",
  "چُنوائیے": "چُننا",
  "چُنوائیں": "چُننا",
  "چُنوایا": "چُننا",
  "چُنی": "چُننا",
  "چُنیے": "چُننا",
  "چُنیں": "چُننا",
  "چُر": "چُرْنا",
  "چُرْں": "چُرْنا",
  "چُرْنے": "چُرْنا",
  "چُرْنا": "چُرْنا",
  "چُرْنی": "چُرْنا",
  "چُرْتے": "چُرْنا",
  "چُرْتا": "چُرْنا",
  "چُرْتی": "چُرْنا",
  "چُرْتیں": "چُرْنا",
  "چُرْوا": "چُرْنا",
  "چُرْوانے": "چُرْنا",
  "چُرْوانا": "چُرْنا",
  "چُرْواتے": "چُرْنا",
  "چُرْواتا": "چُرْنا",
  "چُرْواتی": "چُرْنا",
  "چُرْواتیں": "چُرْنا",
  "چُرْواؤ": "چُرْنا",
  "چُرْواؤں": "چُرْنا",
  "چُرْوائے": "چُرْنا",
  "چُرْوائی": "چُرْنا",
  "چُرْوائیے": "چُرْنا",
  "چُرْوائیں": "چُرْنا",
  "چُرْوایا": "چُرْنا",
  "چُرے": "چُرْنا",
  "چُرں": "چُرنا",
  "چُرا": "چُرْنا",
  "چُرانے": "چُرْنا",
  "چُرانا": "چُرْنا",
  "چُراتے": "چُرْنا",
  "چُراتا": "چُرْنا",
  "چُراتی": "چُرْنا",
  "چُراتیں": "چُرْنا",
  "چُراؤ": "چُرْنا",
  "چُراؤں": "چُرْنا",
  "چُرائے": "چُرْنا",
  "چُرائی": "چُرْنا",
  "چُرائیے": "چُرْنا",
  "چُرائیں": "چُرْنا",
  "چُرایا": "چُرْنا",
  "چُرنے": "چُرنا",
  "چُرنا": "چُرنا",
  "چُرنی": "چُرنا",
  "چُرتے": "چُرنا",
  "چُرتا": "چُرنا",
  "چُرتی": "چُرنا",
  "چُرتیں": "چُرنا",
  "چُرو": "چُرْنا",
  "چُروں": "چُرْنا",
  "چُروا": "چُرنا",
  "چُروانے": "چُرنا",
  "چُروانا": "چُرنا",
  "چُرواتے": "چُرنا",
  "چُرواتا": "چُرنا",
  "چُرواتی": "چُرنا",
  "چُرواتیں": "چُرنا",
  "چُرواؤ": "چُرنا",
  "چُرواؤں": "چُرنا",
  "چُروائے": "چُرنا",
  "چُروائی": "چُرنا",
  "چُروائیے": "چُرنا",
  "چُروائیں": "چُرنا",
  "چُروایا": "چُرنا",
  "چُری": "چُرْنا",
  "چُریے": "چُرْنا",
  "چُریں": "چُرْنا",
  "چُھٹ": "چُھٹنا",
  "چُھٹے": "چُھٹنا",
  "چُھٹں": "چُھٹنا",
  "چُھٹا": "چُھٹنا",
  "چُھٹانے": "چُھٹنا",
  "چُھٹانا": "چُھٹنا",
  "چُھٹاتے": "چُھٹنا",
  "چُھٹاتا": "چُھٹنا",
  "چُھٹاتی": "چُھٹنا",
  "چُھٹاتیں": "چُھٹنا",
  "چُھٹاؤ": "چُھٹنا",
  "چُھٹاؤں": "چُھٹنا",
  "چُھٹائے": "چُھٹنا",
  "چُھٹائی": "چُھٹنا",
  "چُھٹائیے": "چُھٹنا",
  "چُھٹائیں": "چُھٹنا",
  "چُھٹایا": "چُھٹنا",
  "چُھٹنے": "چُھٹنا",
  "چُھٹنا": "چُھٹنا",
  "چُھٹنی": "چُھٹنا",
  "چُھٹتے": "چُھٹنا",
  "چُھٹتا": "چُھٹنا",
  "چُھٹتی": "چُھٹنا",
  "چُھٹتیں": "چُھٹنا",
  "چُھٹو": "چُھٹنا",
  "چُھٹوں": "چُھٹنا",
  "چُھٹوا": "چُھٹنا",
  "چُھٹوانے": "چُھٹنا",
  "چُھٹوانا": "چُھٹنا",
  "چُھٹواتے": "چُھٹنا",
  "چُھٹواتا": "چُھٹنا",
  "چُھٹواتی": "چُھٹنا",
  "چُھٹواتیں": "چُھٹنا",
  "چُھٹواؤ": "چُھٹنا",
  "چُھٹواؤں": "چُھٹنا",
  "چُھٹوائے": "چُھٹنا",
  "چُھٹوائی": "چُھٹنا",
  "چُھٹوائیے": "چُھٹنا",
  "چُھٹوائیں": "چُھٹنا",
  "چُھٹوایا": "چُھٹنا",
  "چُھٹی": "چُھٹنا",
  "چُھٹیے": "چُھٹنا",
  "چُھٹیں": "چُھٹنا",
  "چُھپ": "چُھپنا",
  "چُھپے": "چُھپنا",
  "چُھپں": "چُھپنا",
  "چُھپا": "چُھپنا",
  "چُھپانے": "چُھپنا",
  "چُھپانا": "چُھپنا",
  "چُھپاتے": "چُھپنا",
  "چُھپاتا": "چُھپنا",
  "چُھپاتی": "چُھپنا",
  "چُھپاتیں": "چُھپنا",
  "چُھپاؤ": "چُھپنا",
  "چُھپاؤں": "چُھپنا",
  "چُھپائے": "چُھپنا",
  "چُھپائی": "چُھپنا",
  "چُھپائیے": "چُھپنا",
  "چُھپائیں": "چُھپنا",
  "چُھپایا": "چُھپنا",
  "چُھپنے": "چُھپنا",
  "چُھپنا": "چُھپنا",
  "چُھپنی": "چُھپنا",
  "چُھپتے": "چُھپنا",
  "چُھپتا": "چُھپنا",
  "چُھپتی": "چُھپنا",
  "چُھپتیں": "چُھپنا",
  "چُھپو": "چُھپنا",
  "چُھپوں": "چُھپنا",
  "چُھپوا": "چُھپنا",
  "چُھپوانے": "چُھپنا",
  "چُھپوانا": "چُھپنا",
  "چُھپواتے": "چُھپنا",
  "چُھپواتا": "چُھپنا",
  "چُھپواتی": "چُھپنا",
  "چُھپواتیں": "چُھپنا",
  "چُھپواؤ": "چُھپنا",
  "چُھپواؤں": "چُھپنا",
  "چُھپوائے": "چُھپنا",
  "چُھپوائی": "چُھپنا",
  "چُھپوائیے": "چُھپنا",
  "چُھپوائیں": "چُھپنا",
  "چُھپوایا": "چُھپنا",
  "چُھپی": "چُھپنا",
  "چُھپیے": "چُھپنا",
  "چُھپیں": "چُھپنا",
  "چغے": "چغہ",
  "چغہ": "چغہ",
  "چغلی": "چغلی",
  "چغلیاں": "چغلی",
  "چغلیو": "چغلی",
  "چغلیوں": "چغلی",
  "چغو": "چغہ",
  "چغوں": "چغہ",
  "چخا": "چیخنا",
  "چخانے": "چیخنا",
  "چخانا": "چیخنا",
  "چخاتے": "چیخنا",
  "چخاتا": "چیخنا",
  "چخاتی": "چیخنا",
  "چخاتیں": "چیخنا",
  "چخاؤ": "چیخنا",
  "چخاؤں": "چیخنا",
  "چخائے": "چیخنا",
  "چخائی": "چیخنا",
  "چخائیے": "چیخنا",
  "چخائیں": "چیخنا",
  "چخایا": "چیخنا",
  "چخوا": "چیخنا",
  "چخوانے": "چیخنا",
  "چخوانا": "چیخنا",
  "چخواتے": "چیخنا",
  "چخواتا": "چیخنا",
  "چخواتی": "چیخنا",
  "چخواتیں": "چیخنا",
  "چخواؤ": "چیخنا",
  "چخواؤں": "چیخنا",
  "چخوائے": "چیخنا",
  "چخوائی": "چیخنا",
  "چخوائیے": "چیخنا",
  "چخوائیں": "چیخنا",
  "چخوایا": "چیخنا",
  "چڑ": "چڑنا",
  "چڑے": "چڑا",
  "چڑں": "چڑنا",
  "چڑا": "چڑا",
  "چڑانے": "چڑنا",
  "چڑانا": "چڑنا",
  "چڑاتے": "چڑنا",
  "چڑاتا": "چڑنا",
  "چڑاتی": "چڑنا",
  "چڑاتیں": "چڑنا",
  "چڑاؤ": "چڑنا",
  "چڑاؤں": "چڑنا",
  "چڑائے": "چڑنا",
  "چڑائی": "چڑنا",
  "چڑائیے": "چڑنا",
  "چڑائیں": "چڑنا",
  "چڑایا": "چڑنا",
  "چڑنے": "چڑنا",
  "چڑنا": "چڑنا",
  "چڑنی": "چڑنا",
  "چڑتے": "چڑنا",
  "چڑتا": "چڑنا",
  "چڑتی": "چڑنا",
  "چڑتیں": "چڑنا",
  "چڑو": "چڑا",
  "چڑوں": "چڑا",
  "چڑوا": "چڑنا",
  "چڑوانے": "چڑنا",
  "چڑوانا": "چڑنا",
  "چڑواتے": "چڑنا",
  "چڑواتا": "چڑنا",
  "چڑواتی": "چڑنا",
  "چڑواتیں": "چڑنا",
  "چڑواؤ": "چڑنا",
  "چڑواؤں": "چڑنا",
  "چڑوائے": "چڑنا",
  "چڑوائی": "چڑنا",
  "چڑوائیے": "چڑنا",
  "چڑوائیں": "چڑنا",
  "چڑوایا": "چڑنا",
  "چڑی": "چڑی",
  "چڑیے": "چڑنا",
  "چڑیں": "چڑنا",
  "چڑیا": "چڑیا",
  "چڑیاں": "چڑی",
  "چڑیل": "چڑیل",
  "چڑیلو": "چڑیل",
  "چڑیلوں": "چڑیل",
  "چڑیلیں": "چڑیل",
  "چڑیو": "چڑی",
  "چڑیوں": "چڑی",
  "چڑھ": "چڑھنا",
  "چڑھے": "چڑھنا",
  "چڑھں": "چڑھنا",
  "چڑھا": "چڑھنا",
  "چڑھانے": "چڑھنا",
  "چڑھانا": "چڑھنا",
  "چڑھاتے": "چڑھنا",
  "چڑھاتا": "چڑھنا",
  "چڑھاتی": "چڑھنا",
  "چڑھاتیں": "چڑھنا",
  "چڑھاؤ": "چڑھنا",
  "چڑھاؤں": "چڑھنا",
  "چڑھائے": "چڑھنا",
  "چڑھائی": "چڑھائی",
  "چڑھائیے": "چڑھنا",
  "چڑھائیں": "چڑھنا",
  "چڑھائیاں": "چڑھائی",
  "چڑھائیو": "چڑھائی",
  "چڑھائیوں": "چڑھائی",
  "چڑھایا": "چڑھنا",
  "چڑھنے": "چڑھنا",
  "چڑھنا": "چڑھنا",
  "چڑھنی": "چڑھنا",
  "چڑھتے": "چڑھنا",
  "چڑھتا": "چڑھنا",
  "چڑھتی": "چڑھنا",
  "چڑھتیں": "چڑھنا",
  "چڑھو": "چڑھنا",
  "چڑھوں": "چڑھنا",
  "چڑھوا": "چڑھنا",
  "چڑھوانے": "چڑھنا",
  "چڑھوانا": "چڑھنا",
  "چڑھواتے": "چڑھنا",
  "چڑھواتا": "چڑھنا",
  "چڑھواتی": "چڑھنا",
  "چڑھواتیں": "چڑھنا",
  "چڑھواؤ": "چڑھنا",
  "چڑھواؤں": "چڑھنا",
  "چڑھوائے": "چڑھنا",
  "چڑھوائی": "چڑھنا",
  "چڑھوائیے": "چڑھنا",
  "چڑھوائیں": "چڑھنا",
  "چڑھوایا": "چڑھنا",
  "چڑھی": "چڑھنا",
  "چڑھیے": "چڑھنا",
  "چڑھیں": "چڑھنا",
  "چٹخ": "چٹخنا",
  "چٹخے": "چٹخنا",
  "چٹخں": "چٹخنا",
  "چٹخا": "چٹخنا",
  "چٹخانے": "چٹخنا",
  "چٹخانا": "چٹخنا",
  "چٹخاتے": "چٹخنا",
  "چٹخاتا": "چٹخنا",
  "چٹخاتی": "چٹخنا",
  "چٹخاتیں": "چٹخنا",
  "چٹخاؤ": "چٹخنا",
  "چٹخاؤں": "چٹخنا",
  "چٹخائے": "چٹخنا",
  "چٹخائی": "چٹخنا",
  "چٹخائیے": "چٹخنا",
  "چٹخائیں": "چٹخنا",
  "چٹخایا": "چٹخنا",
  "چٹخنے": "چٹخنا",
  "چٹخنا": "چٹخنا",
  "چٹخنی": "چٹخنا",
  "چٹختے": "چٹخنا",
  "چٹختا": "چٹخنا",
  "چٹختی": "چٹخنا",
  "چٹختیں": "چٹخنا",
  "چٹخو": "چٹخنا",
  "چٹخوں": "چٹخنا",
  "چٹخوا": "چٹخنا",
  "چٹخوانے": "چٹخنا",
  "چٹخوانا": "چٹخنا",
  "چٹخواتے": "چٹخنا",
  "چٹخواتا": "چٹخنا",
  "چٹخواتی": "چٹخنا",
  "چٹخواتیں": "چٹخنا",
  "چٹخواؤ": "چٹخنا",
  "چٹخواؤں": "چٹخنا",
  "چٹخوائے": "چٹخنا",
  "چٹخوائی": "چٹخنا",
  "چٹخوائیے": "چٹخنا",
  "چٹخوائیں": "چٹخنا",
  "چٹخوایا": "چٹخنا",
  "چٹخی": "چٹخنا",
  "چٹخیے": "چٹخنا",
  "چٹخیں": "چٹخنا",
  "چٹا": "چاٹنا",
  "چٹان": "چٹان",
  "چٹانے": "چاٹنا",
  "چٹانا": "چاٹنا",
  "چٹانو": "چٹان",
  "چٹانوں": "چٹان",
  "چٹانیں": "چٹان",
  "چٹاتے": "چاٹنا",
  "چٹاتا": "چاٹنا",
  "چٹاتی": "چاٹنا",
  "چٹاتیں": "چاٹنا",
  "چٹاؤ": "چاٹنا",
  "چٹاؤں": "چاٹنا",
  "چٹائے": "چاٹنا",
  "چٹائی": "چٹائی",
  "چٹائیے": "چاٹنا",
  "چٹائیں": "چاٹنا",
  "چٹائیاں": "چٹائی",
  "چٹائیو": "چٹائی",
  "چٹائیوں": "چٹائی",
  "چٹایا": "چاٹنا",
  "چٹک": "چٹکنا",
  "چٹکے": "چٹکنا",
  "چٹکں": "چٹکنا",
  "چٹکا": "چٹکنا",
  "چٹکانے": "چٹکنا",
  "چٹکانا": "چٹکنا",
  "چٹکاتے": "چٹکنا",
  "چٹکاتا": "چٹکنا",
  "چٹکاتی": "چٹکنا",
  "چٹکاتیں": "چٹکنا",
  "چٹکاؤ": "چٹکنا",
  "چٹکاؤں": "چٹکنا",
  "چٹکائے": "چٹکنا",
  "چٹکائی": "چٹکنا",
  "چٹکائیے": "چٹکنا",
  "چٹکائیں": "چٹکنا",
  "چٹکایا": "چٹکنا",
  "چٹکنے": "چٹکنا",
  "چٹکنا": "چٹکنا",
  "چٹکنی": "چٹکنا",
  "چٹکتے": "چٹکنا",
  "چٹکتا": "چٹکنا",
  "چٹکتی": "چٹکنا",
  "چٹکتیں": "چٹکنا",
  "چٹکو": "چٹکنا",
  "چٹکوں": "چٹکنا",
  "چٹکوا": "چٹکنا",
  "چٹکوانے": "چٹکنا",
  "چٹکوانا": "چٹکنا",
  "چٹکواتے": "چٹکنا",
  "چٹکواتا": "چٹکنا",
  "چٹکواتی": "چٹکنا",
  "چٹکواتیں": "چٹکنا",
  "چٹکواؤ": "چٹکنا",
  "چٹکواؤں": "چٹکنا",
  "چٹکوائے": "چٹکنا",
  "چٹکوائی": "چٹکنا",
  "چٹکوائیے": "چٹکنا",
  "چٹکوائیں": "چٹکنا",
  "چٹکوایا": "چٹکنا",
  "چٹکی": "چٹکی",
  "چٹکیے": "چٹکنا",
  "چٹکیں": "چٹکنا",
  "چٹکیاں": "چٹکی",
  "چٹکیو": "چٹکی",
  "چٹکیوں": "چٹکی",
  "چٹنی": "چٹنی",
  "چٹنیاں": "چٹنی",
  "چٹنیو": "چٹنی",
  "چٹنیوں": "چٹنی",
  "چٹوا": "چاٹنا",
  "چٹوانے": "چاٹنا",
  "چٹوانا": "چاٹنا",
  "چٹواتے": "چاٹنا",
  "چٹواتا": "چاٹنا",
  "چٹواتی": "چاٹنا",
  "چٹواتیں": "چاٹنا",
  "چٹواؤ": "چاٹنا",
  "چٹواؤں": "چاٹنا",
  "چٹوائے": "چاٹنا",
  "چٹوائی": "چاٹنا",
  "چٹوائیے": "چاٹنا",
  "چٹوائیں": "چاٹنا",
  "چٹوایا": "چاٹنا",
  "چٹھے": "چٹھہ",
  "چٹھہ": "چٹھہ",
  "چٹھو": "چٹھہ",
  "چٹھوں": "چٹھہ",
  "چٹھی": "چٹھی",
  "چٹھیاں": "چٹھی",
  "چٹھیو": "چٹھی",
  "چٹھیوں": "چٹھی",
  "چشم": "چشم",
  "چشمے": "چشمہ",
  "چشمہ": "چشمہ",
  "چشمو": "چشمہ",
  "چشموں": "چشمہ",
  "چاٹ": "چاٹنا",
  "چاٹے": "چاٹنا",
  "چاٹں": "چاٹنا",
  "چاٹا": "چاٹنا",
  "چاٹنے": "چاٹنا",
  "چاٹنا": "چاٹنا",
  "چاٹنی": "چاٹنا",
  "چاٹتے": "چاٹنا",
  "چاٹتا": "چاٹنا",
  "چاٹتی": "چاٹنا",
  "چاٹتیں": "چاٹنا",
  "چاٹو": "چاٹنا",
  "چاٹوں": "چاٹنا",
  "چاٹی": "چاٹی",
  "چاٹیے": "چاٹنا",
  "چاٹیں": "چاٹنا",
  "چاٹیاں": "چاٹی",
  "چاٹیو": "چاٹی",
  "چاٹیوں": "چاٹی",
  "چابی": "چابی",
  "چابیاں": "چابی",
  "چابیو": "چابی",
  "چابیوں": "چابی",
  "چادر": "چادر",
  "چادرو": "چادر",
  "چادروں": "چادر",
  "چادریں": "چادر",
  "چاہ": "چاہنا",
  "چاہَت": "چاہَت",
  "چاہَتو": "چاہَت",
  "چاہَتوں": "چاہَت",
  "چاہَتیں": "چاہَت",
  "چاہے": "چاہنا",
  "چاہں": "چاہنا",
  "چاہا": "چاہنا",
  "چاہنے": "چاہنا",
  "چاہنا": "چاہنا",
  "چاہنی": "چاہنا",
  "چاہت": "چاہت",
  "چاہتے": "چاہنا",
  "چاہتا": "چاہنا",
  "چاہتو": "چاہت",
  "چاہتوں": "چاہت",
  "چاہتی": "چاہنا",
  "چاہتیں": "چاہت",
  "چاہو": "چاہنا",
  "چاہوں": "چاہنا",
  "چاہی": "چاہنا",
  "چاہیے": "چاہنا",
  "چاہیں": "چاہنا",
  "چاک": "چاک",
  "چاکلیٹ": "چاکلیٹ",
  "چاکلیٹو": "چاکلیٹ",
  "چاکلیٹوں": "چاکلیٹ",
  "چاکلیٹیں": "چاکلیٹ",
  "چاکو": "چاک",
  "چاکوں": "چاک",
  "چال": "چال",
  "چالاکی": "چالاکی",
  "چالاکیاں": "چالاکی",
  "چالاکیو": "چالاکی",
  "چالاکیوں": "چالاکی",
  "چالان": "چالان",
  "چالانو": "چالان",
  "چالانوں": "چالان",
  "چالو": "چال",
  "چالوں": "چال",
  "چالیں": "چال",
  "چالیسواں": "چالیسواں",
  "چالیسووںں": "چالیسواں",
  "چالیسویں": "چالیسواں",
  "چاند": "چاند",
  "چاندنی": "چاندنی",
  "چاندنیاں": "چاندنی",
  "چاندنیو": "چاندنی",
  "چاندنیوں": "چاندنی",
  "چاندو": "چاند",
  "چاندوں": "چاند",
  "چاق": "چاق",
  "چاقو": "چاق",
  "چاقوں": "چاق",
  "چاقوو": "چاقو",
  "چاقووں": "چاقو",
  "چار": "چار",
  "چارے": "چارا",
  "چارا": "چارا",
  "چارہ": "چارہ",
  "چارپائی": "چارپائی",
  "چارپائیاں": "چارپائی",
  "چارپائیو": "چارپائی",
  "چارپائیوں": "چارپائی",
  "چارو": "چارا",
  "چاروں": "چارا",
  "چاریں": "چار",
  "چاؤ": "چاؤ",
  "چاول": "چاول",
  "چاولو": "چاول",
  "چاولوں": "چاول",
  "چب": "چبنا",
  "چبے": "چبنا",
  "چبں": "چبنا",
  "چبا": "چبنا",
  "چبانے": "چبنا",
  "چبانا": "چبنا",
  "چباتے": "چبنا",
  "چباتا": "چبنا",
  "چباتی": "چبنا",
  "چباتیں": "چبنا",
  "چباؤ": "چبنا",
  "چباؤں": "چبنا",
  "چبائے": "چبنا",
  "چبائی": "چبنا",
  "چبائیے": "چبنا",
  "چبائیں": "چبنا",
  "چبایا": "چبنا",
  "چبنے": "چبنا",
  "چبنا": "چبنا",
  "چبنی": "چبنا",
  "چبتے": "چبنا",
  "چبتا": "چبنا",
  "چبتی": "چبنا",
  "چبتیں": "چبنا",
  "چبو": "چبنا",
  "چبوں": "چبنا",
  "چبوا": "چبنا",
  "چبوانے": "چبنا",
  "چبوانا": "چبنا",
  "چبواتے": "چبنا",
  "چبواتا": "چبنا",
  "چبواتی": "چبنا",
  "چبواتیں": "چبنا",
  "چبواؤ": "چبنا",
  "چبواؤں": "چبنا",
  "چبوائے": "چبنا",
  "چبوائی": "چبنا",
  "چبوائیے": "چبنا",
  "چبوائیں": "چبنا",
  "چبوایا": "چبنا",
  "چبوترے": "چبوترہ",
  "چبوترہ": "چبوترہ",
  "چبوترو": "چبوترہ",
  "چبوتروں": "چبوترہ",
  "چبی": "چبنا",
  "چبیے": "چبنا",
  "چبیں": "چبنا",
  "چچا": "چچا",
  "چچاؤ": "چچا",
  "چچاؤں": "چچا",
  "چچائیں": "چچا",
  "چگ": "چگنا",
  "چگے": "چگنا",
  "چگں": "چگنا",
  "چگا": "چگنا",
  "چگانے": "چگنا",
  "چگانا": "چگنا",
  "چگاتے": "چگنا",
  "چگاتا": "چگنا",
  "چگاتی": "چگنا",
  "چگاتیں": "چگنا",
  "چگاؤ": "چگنا",
  "چگاؤں": "چگنا",
  "چگائے": "چگنا",
  "چگائی": "چگنا",
  "چگائیے": "چگنا",
  "چگائیں": "چگنا",
  "چگایا": "چگنا",
  "چگنے": "چگنا",
  "چگنا": "چگنا",
  "چگنی": "چگنا",
  "چگتے": "چگنا",
  "چگتا": "چگنا",
  "چگتی": "چگنا",
  "چگتیں": "چگنا",
  "چگو": "چگنا",
  "چگوں": "چگنا",
  "چگوا": "چگنا",
  "چگوانے": "چگنا",
  "چگوانا": "چگنا",
  "چگواتے": "چگنا",
  "چگواتا": "چگنا",
  "چگواتی": "چگنا",
  "چگواتیں": "چگنا",
  "چگواؤ": "چگنا",
  "چگواؤں": "چگنا",
  "چگوائے": "چگنا",
  "چگوائی": "چگنا",
  "چگوائیے": "چگنا",
  "چگوائیں": "چگنا",
  "چگوایا": "چگنا",
  "چگی": "چگنا",
  "چگیے": "چگنا",
  "چگیں": "چگنا",
  "چہچہا": "چہچہانا",
  "چہچہانے": "چہچہانا",
  "چہچہانا": "چہچہانا",
  "چہچہانی": "چہچہانا",
  "چہچہاتے": "چہچہانا",
  "چہچہاتا": "چہچہانا",
  "چہچہاتی": "چہچہانا",
  "چہچہاتیں": "چہچہانا",
  "چہچہاؤ": "چہچہانا",
  "چہچہاؤں": "چہچہانا",
  "چہچہائے": "چہچہانا",
  "چہچہائی": "چہچہانا",
  "چہچہائیے": "چہچہانا",
  "چہچہائیں": "چہچہانا",
  "چہچہایا": "چہچہانا",
  "چہرے": "چہرا",
  "چہرا": "چہرا",
  "چہرہ": "چہرہ",
  "چہرو": "چہرا",
  "چہروں": "چہرا",
  "چک": "چکنا",
  "چکے": "چکنا",
  "چکں": "چکنا",
  "چکا": "چکنا",
  "چکانے": "چکنا",
  "چکانا": "چکنا",
  "چکاتے": "چکنا",
  "چکاتا": "چکنا",
  "چکاتی": "چکنا",
  "چکاتیں": "چکنا",
  "چکاؤ": "چکنا",
  "چکاؤں": "چکنا",
  "چکائے": "چکنا",
  "چکائی": "چکنا",
  "چکائیے": "چکنا",
  "چکائیں": "چکنا",
  "چکایا": "چکنا",
  "چکلے": "چکلہ",
  "چکلہ": "چکلہ",
  "چکلو": "چکلہ",
  "چکلوں": "چکلہ",
  "چکنے": "چکنا",
  "چکنا": "چکنا",
  "چکنی": "چکنا",
  "چکر": "چکر",
  "چکرا": "چکرانا",
  "چکرانے": "چکرانا",
  "چکرانا": "چکرانا",
  "چکرانی": "چکرانا",
  "چکراتے": "چکرانا",
  "چکراتا": "چکرانا",
  "چکراتی": "چکرانا",
  "چکراتیں": "چکرانا",
  "چکراؤ": "چکرانا",
  "چکراؤں": "چکرانا",
  "چکرائے": "چکرانا",
  "چکرائی": "چکرانا",
  "چکرائیے": "چکرانا",
  "چکرائیں": "چکرانا",
  "چکرایا": "چکرانا",
  "چکرو": "چکر",
  "چکروں": "چکر",
  "چکتے": "چکنا",
  "چکتا": "چکنا",
  "چکتی": "چکنا",
  "چکتیں": "چکنا",
  "چکو": "چکنا",
  "چکوں": "چکنا",
  "چکوا": "چکنا",
  "چکوانے": "چکنا",
  "چکوانا": "چکنا",
  "چکواتے": "چکنا",
  "چکواتا": "چکنا",
  "چکواتی": "چکنا",
  "چکواتیں": "چکنا",
  "چکواؤ": "چکنا",
  "چکواؤں": "چکنا",
  "چکوائے": "چکنا",
  "چکوائی": "چکنا",
  "چکوائیے": "چکنا",
  "چکوائیں": "چکنا",
  "چکوایا": "چکنا",
  "چکی": "چکنا",
  "چکیے": "چکنا",
  "چکیں": "چکنا",
  "چکھ": "چکھنا",
  "چکھے": "چکھنا",
  "چکھں": "چکھنا",
  "چکھا": "چکھنا",
  "چکھانے": "چکھنا",
  "چکھانا": "چکھنا",
  "چکھاتے": "چکھنا",
  "چکھاتا": "چکھنا",
  "چکھاتی": "چکھنا",
  "چکھاتیں": "چکھنا",
  "چکھاؤ": "چکھنا",
  "چکھاؤں": "چکھنا",
  "چکھائے": "چکھنا",
  "چکھائی": "چکھنا",
  "چکھائیے": "چکھنا",
  "چکھائیں": "چکھنا",
  "چکھایا": "چکھنا",
  "چکھنے": "چکھنا",
  "چکھنا": "چکھنا",
  "چکھنی": "چکھنا",
  "چکھتے": "چکھنا",
  "چکھتا": "چکھنا",
  "چکھتی": "چکھنا",
  "چکھتیں": "چکھنا",
  "چکھو": "چکھنا",
  "چکھوں": "چکھنا",
  "چکھوا": "چکھنا",
  "چکھوانے": "چکھنا",
  "چکھوانا": "چکھنا",
  "چکھواتے": "چکھنا",
  "چکھواتا": "چکھنا",
  "چکھواتی": "چکھنا",
  "چکھواتیں": "چکھنا",
  "چکھواؤ": "چکھنا",
  "چکھواؤں": "چکھنا",
  "چکھوائے": "چکھنا",
  "چکھوائی": "چکھنا",
  "چکھوائیے": "چکھنا",
  "چکھوائیں": "چکھنا",
  "چکھوایا": "چکھنا",
  "چکھی": "چکھنا",
  "چکھیے": "چکھنا",
  "چکھیں": "چکھنا",
  "چل": "چلنا",
  "چلّ": "چلّنا",
  "چلّے": "چلّنا",
  "چلّں": "چلّنا",
  "چلّا": "چلّنا",
  "چلّنے": "چلّنا",
  "چلّنا": "چلّنا",
  "چلّنی": "چلّنا",
  "چلّتے": "چلّنا",
  "چلّتا": "چلّنا",
  "چلّتی": "چلّنا",
  "چلّتیں": "چلّنا",
  "چلّو": "چلّنا",
  "چلّوں": "چلّنا",
  "چلّوا": "چلّنا",
  "چلّوانے": "چلّنا",
  "چلّوانا": "چلّنا",
  "چلّواتے": "چلّنا",
  "چلّواتا": "چلّنا",
  "چلّواتی": "چلّنا",
  "چلّواتیں": "چلّنا",
  "چلّواؤ": "چلّنا",
  "چلّواؤں": "چلّنا",
  "چلّوائے": "چلّنا",
  "چلّوائی": "چلّنا",
  "چلّوائیے": "چلّنا",
  "چلّوائیں": "چلّنا",
  "چلّوایا": "چلّنا",
  "چلّی": "چلّنا",
  "چلّیے": "چلّنا",
  "چلّیں": "چلّنا",
  "چلے": "چلہ",
  "چلں": "چلنا",
  "چلا": "چلنا",
  "چلاک": "چلاک",
  "چلاکو": "چلاک",
  "چلاکوں": "چلاک",
  "چلانے": "چلنا",
  "چلانا": "چلنا",
  "چلاتے": "چلنا",
  "چلاتا": "چلنا",
  "چلاتی": "چلنا",
  "چلاتیں": "چلنا",
  "چلاؤ": "چلنا",
  "چلاؤں": "چلنا",
  "چلائے": "چلنا",
  "چلائی": "چلنا",
  "چلائیے": "چلنا",
  "چلائیں": "چلنا",
  "چلایا": "چلنا",
  "چلہ": "چلہ",
  "چلمن": "چلمن",
  "چلمنو": "چلمن",
  "چلمنوں": "چلمن",
  "چلمنیں": "چلمن",
  "چلنے": "چلنا",
  "چلنا": "چلنا",
  "چلنی": "چلنا",
  "چلت": "چلت",
  "چلتے": "چلتا",
  "چلتا": "چلتا",
  "چلتو": "چلتا",
  "چلتوں": "چلتا",
  "چلتی": "چلنا",
  "چلتیں": "چلت",
  "چلو": "چلہ",
  "چلوں": "چلہ",
  "چلوا": "چلنا",
  "چلوانے": "چلنا",
  "چلوانا": "چلنا",
  "چلواتے": "چلنا",
  "چلواتا": "چلنا",
  "چلواتی": "چلنا",
  "چلواتیں": "چلنا",
  "چلواؤ": "چلنا",
  "چلواؤں": "چلنا",
  "چلوائے": "چلنا",
  "چلوائی": "چلنا",
  "چلوائیے": "چلنا",
  "چلوائیں": "چلنا",
  "چلوایا": "چلنا",
  "چلی": "چلنا",
  "چلیے": "چلنا",
  "چلیں": "چلنا",
  "چمٹ": "چمٹنا",
  "چمٹے": "چمٹنا",
  "چمٹں": "چمٹنا",
  "چمٹا": "چمٹنا",
  "چمٹانے": "چمٹنا",
  "چمٹانا": "چمٹنا",
  "چمٹاتے": "چمٹنا",
  "چمٹاتا": "چمٹنا",
  "چمٹاتی": "چمٹنا",
  "چمٹاتیں": "چمٹنا",
  "چمٹاؤ": "چمٹنا",
  "چمٹاؤں": "چمٹنا",
  "چمٹائے": "چمٹنا",
  "چمٹائی": "چمٹنا",
  "چمٹائیے": "چمٹنا",
  "چمٹائیں": "چمٹنا",
  "چمٹایا": "چمٹنا",
  "چمٹنے": "چمٹنا",
  "چمٹنا": "چمٹنا",
  "چمٹنی": "چمٹنا",
  "چمٹتے": "چمٹنا",
  "چمٹتا": "چمٹنا",
  "چمٹتی": "چمٹنا",
  "چمٹتیں": "چمٹنا",
  "چمٹو": "چمٹنا",
  "چمٹوں": "چمٹنا",
  "چمٹوا": "چمٹنا",
  "چمٹوانے": "چمٹنا",
  "چمٹوانا": "چمٹنا",
  "چمٹواتے": "چمٹنا",
  "چمٹواتا": "چمٹنا",
  "چمٹواتی": "چمٹنا",
  "چمٹواتیں": "چمٹنا",
  "چمٹواؤ": "چمٹنا",
  "چمٹواؤں": "چمٹنا",
  "چمٹوائے": "چمٹنا",
  "چمٹوائی": "چمٹنا",
  "چمٹوائیے": "چمٹنا",
  "چمٹوائیں": "چمٹنا",
  "چمٹوایا": "چمٹنا",
  "چمٹی": "چمٹنا",
  "چمٹیے": "چمٹنا",
  "چمٹیں": "چمٹنا",
  "چمار": "چمار",
  "چمارو": "چمار",
  "چماروں": "چمار",
  "چمچے": "چمچہ",
  "چمچہ": "چمچہ",
  "چمچو": "چمچہ",
  "چمچوں": "چمچہ",
  "چمگادڑ": "چمگادڑ",
  "چمگادڑو": "چمگادڑ",
  "چمگادڑوں": "چمگادڑ",
  "چمگادڑیں": "چمگادڑ",
  "چمک": "چمکنا",
  "چمکے": "چمکنا",
  "چمکں": "چمکنا",
  "چمکا": "چمکنا",
  "چمکانے": "چمکنا",
  "چمکانا": "چمکنا",
  "چمکاتے": "چمکنا",
  "چمکاتا": "چمکنا",
  "چمکاتی": "چمکنا",
  "چمکاتیں": "چمکنا",
  "چمکاؤ": "چمکنا",
  "چمکاؤں": "چمکنا",
  "چمکائے": "چمکنا",
  "چمکائی": "چمکنا",
  "چمکائیے": "چمکنا",
  "چمکائیں": "چمکنا",
  "چمکایا": "چمکنا",
  "چمکنے": "چمکنا",
  "چمکنا": "چمکنا",
  "چمکنی": "چمکنا",
  "چمکتے": "چمکنا",
  "چمکتا": "چمکنا",
  "چمکتی": "چمکنا",
  "چمکتیں": "چمکنا",
  "چمکو": "چمکنا",
  "چمکوں": "چمکنا",
  "چمکوا": "چمکنا",
  "چمکوانے": "چمکنا",
  "چمکوانا": "چمکنا",
  "چمکواتے": "چمکنا",
  "چمکواتا": "چمکنا",
  "چمکواتی": "چمکنا",
  "چمکواتیں": "چمکنا",
  "چمکواؤ": "چمکنا",
  "چمکواؤں": "چمکنا",
  "چمکوائے": "چمکنا",
  "چمکوائی": "چمکنا",
  "چمکوائیے": "چمکنا",
  "چمکوائیں": "چمکنا",
  "چمکوایا": "چمکنا",
  "چمکی": "چمکنا",
  "چمکیے": "چمکنا",
  "چمکیں": "چمکنا",
  "چمن": "چمن",
  "چمنو": "چمن",
  "چمنوں": "چمن",
  "چن": "چننا",
  "چنے": "چنا",
  "چنں": "چننا",
  "چنا": "چنا",
  "چنانے": "چننا",
  "چنانا": "چننا",
  "چنانچہ": "چنانچہ",
  "چناتے": "چننا",
  "چناتا": "چننا",
  "چناتی": "چننا",
  "چناتیں": "چننا",
  "چناؤ": "چننا",
  "چناؤں": "چننا",
  "چنائے": "چننا",
  "چنائی": "چنائی",
  "چنائیے": "چننا",
  "چنائیں": "چننا",
  "چنائیاں": "چنائی",
  "چنائیو": "چنائی",
  "چنائیوں": "چنائی",
  "چنایا": "چننا",
  "چند": "چند",
  "چندے": "چندا",
  "چندا": "چندا",
  "چندہ": "چندہ",
  "چندو": "چندا",
  "چندوں": "چندا",
  "چنگاری": "چنگاری",
  "چنگاریاں": "چنگاری",
  "چنگاریو": "چنگاری",
  "چنگاریوں": "چنگاری",
  "چنگھاڑ": "چنگھاڑنا",
  "چنگھاڑے": "چنگھاڑنا",
  "چنگھاڑں": "چنگھاڑنا",
  "چنگھاڑا": "چنگھاڑنا",
  "چنگھاڑنے": "چنگھاڑنا",
  "چنگھاڑنا": "چنگھاڑنا",
  "چنگھاڑنی": "چنگھاڑنا",
  "چنگھاڑتے": "چنگھاڑنا",
  "چنگھاڑتا": "چنگھاڑنا",
  "چنگھاڑتی": "چنگھاڑنا",
  "چنگھاڑتیں": "چنگھاڑنا",
  "چنگھاڑو": "چنگھاڑنا",
  "چنگھاڑوں": "چنگھاڑنا",
  "چنگھاڑی": "چنگھاڑنا",
  "چنگھاڑیے": "چنگھاڑنا",
  "چنگھاڑیں": "چنگھاڑنا",
  "چننے": "چننا",
  "چننا": "چننا",
  "چننی": "چننا",
  "چنتے": "چنتا",
  "چنتا": "چنتا",
  "چنتو": "چنتا",
  "چنتوں": "چنتا",
  "چنتی": "چننا",
  "چنتیں": "چننا",
  "چنو": "چنا",
  "چنوں": "چنا",
  "چنوا": "چننا",
  "چنوانے": "چننا",
  "چنوانا": "چننا",
  "چنواتے": "چننا",
  "چنواتا": "چننا",
  "چنواتی": "چننا",
  "چنواتیں": "چننا",
  "چنواؤ": "چننا",
  "چنواؤں": "چننا",
  "چنوائے": "چننا",
  "چنوائی": "چننا",
  "چنوائیے": "چننا",
  "چنوائیں": "چننا",
  "چنوایا": "چننا",
  "چنی": "چننا",
  "چنیے": "چننا",
  "چنیں": "چننا",
  "چنیا": "چنیا",
  "چنیاں": "چنیا",
  "چنیو": "چنیا",
  "چنیوں": "چنیا",
  "چپے": "چپہ",
  "چپڑاسی": "چپڑاسی",
  "چپڑاسیاں": "چپڑاسی",
  "چپڑاسیو": "چپڑاسی",
  "چپڑاسیوں": "چپڑاسی",
  "چپاتی": "چپاتی",
  "چپاتیاں": "چپاتی",
  "چپاتیو": "چپاتی",
  "چپاتیوں": "چپاتی",
  "چپہ": "چپہ",
  "چپک": "چپکنا",
  "چپکے": "چپکا",
  "چپکں": "چپکنا",
  "چپکا": "چپکا",
  "چپکانے": "چپکنا",
  "چپکانا": "چپکنا",
  "چپکاتے": "چپکنا",
  "چپکاتا": "چپکنا",
  "چپکاتی": "چپکنا",
  "چپکاتیں": "چپکنا",
  "چپکاؤ": "چپکنا",
  "چپکاؤں": "چپکنا",
  "چپکائے": "چپکنا",
  "چپکائی": "چپکنا",
  "چپکائیے": "چپکنا",
  "چپکائیں": "چپکنا",
  "چپکایا": "چپکنا",
  "چپکنے": "چپکنا",
  "چپکنا": "چپکنا",
  "چپکنی": "چپکنا",
  "چپکتے": "چپکنا",
  "چپکتا": "چپکنا",
  "چپکتی": "چپکنا",
  "چپکتیں": "چپکنا",
  "چپکو": "چپکا",
  "چپکوں": "چپکا",
  "چپکوا": "چپکنا",
  "چپکوانے": "چپکنا",
  "چپکوانا": "چپکنا",
  "چپکواتے": "چپکنا",
  "چپکواتا": "چپکنا",
  "چپکواتی": "چپکنا",
  "چپکواتیں": "چپکنا",
  "چپکواؤ": "چپکنا",
  "چپکواؤں": "چپکنا",
  "چپکوائے": "چپکنا",
  "چپکوائی": "چپکنا",
  "چپکوائیے": "چپکنا",
  "چپکوائیں": "چپکنا",
  "چپکوایا": "چپکنا",
  "چپکی": "چپکنا",
  "چپکیے": "چپکنا",
  "چپکیں": "چپکنا",
  "چپل": "چپل",
  "چپلو": "چپل",
  "چپلوں": "چپل",
  "چپلیں": "چپل",
  "چپراسی": "چپراسی",
  "چپراسیاں": "چپراسی",
  "چپراسیو": "چپراسی",
  "چپراسیوں": "چپراسی",
  "چپو": "چپہ",
  "چپوں": "چپہ",
  "چپوترے": "چپوترہ",
  "چپوترہ": "چپوترہ",
  "چپوترو": "چپوترہ",
  "چپوتروں": "چپوترہ",
  "چر": "چرنا",
  "چرے": "چرنا",
  "چرخی": "چرخی",
  "چرخیاں": "چرخی",
  "چرخیو": "چرخی",
  "چرخیوں": "چرخی",
  "چرں": "چرنا",
  "چرا": "چرانا",
  "چراغ": "چراغ",
  "چراغو": "چراغ",
  "چراغوں": "چراغ",
  "چراگاہ": "چراگاہ",
  "چراگاہو": "چراگاہ",
  "چراگاہوں": "چراگاہ",
  "چراگاہیں": "چراگاہ",
  "چرانے": "چرانا",
  "چرانا": "چرانا",
  "چرانی": "چرانا",
  "چراتے": "چرانا",
  "چراتا": "چرانا",
  "چراتی": "چرانا",
  "چراتیں": "چرانا",
  "چراؤ": "چرانا",
  "چراؤں": "چرانا",
  "چرائے": "چرانا",
  "چرائی": "چرانا",
  "چرائیے": "چرانا",
  "چرائیں": "چرانا",
  "چرایا": "چرانا",
  "چربے": "چربہ",
  "چربہ": "چربہ",
  "چربو": "چربہ",
  "چربوں": "چربہ",
  "چرچے": "چرچہ",
  "چرچہ": "چرچہ",
  "چرچو": "چرچہ",
  "چرچوں": "چرچہ",
  "چرن": "چرن",
  "چرنے": "چرنا",
  "چرنا": "چرنا",
  "چرنو": "چرن",
  "چرنوں": "چرن",
  "چرنی": "چرنا",
  "چرتے": "چرنا",
  "چرتا": "چرنا",
  "چرتی": "چرنا",
  "چرتیں": "چرنا",
  "چرو": "چرنا",
  "چروں": "چرنا",
  "چروا": "چرنا",
  "چرواہے": "چرواہا",
  "چرواہا": "چرواہا",
  "چرواہو": "چرواہا",
  "چرواہوں": "چرواہا",
  "چروانے": "چرنا",
  "چروانا": "چرنا",
  "چرواتے": "چرنا",
  "چرواتا": "چرنا",
  "چرواتی": "چرنا",
  "چرواتیں": "چرنا",
  "چرواؤ": "چرنا",
  "چرواؤں": "چرنا",
  "چروائے": "چرنا",
  "چروائی": "چرنا",
  "چروائیے": "چرنا",
  "چروائیں": "چرنا",
  "چروایا": "چرنا",
  "چری": "چرنا",
  "چریے": "چرنا",
  "چریں": "چرنا",
  "چسکی": "چسکی",
  "چسکیاں": "چسکی",
  "چسکیو": "چسکی",
  "چسکیوں": "چسکی",
  "چوغے": "چوغہ",
  "چوغہ": "چوغہ",
  "چوغو": "چوغہ",
  "چوغوں": "چوغہ",
  "چوڑ": "چوڑ",
  "چوڑے": "چوڑا",
  "چوڑا": "چوڑا",
  "چوڑو": "چوڑا",
  "چوڑوں": "چوڑا",
  "چوڑی": "چوڑی",
  "چوڑیاں": "چوڑی",
  "چوڑیو": "چوڑی",
  "چوڑیوں": "چوڑی",
  "چوٹ": "چوٹ",
  "چوٹو": "چوٹ",
  "چوٹوں": "چوٹ",
  "چوٹی": "چوٹی",
  "چوٹیں": "چوٹ",
  "چوٹیاں": "چوٹی",
  "چوٹیو": "چوٹی",
  "چوٹیوں": "چوٹی",
  "چوبارے": "چوبارہ",
  "چوبارہ": "چوبارہ",
  "چوبارو": "چوبارہ",
  "چوباروں": "چوبارہ",
  "چوبیس": "چوبیس",
  "چودہ": "چودہ",
  "چودھری": "چودھری",
  "چودھریو": "چودھری",
  "چودھریوں": "چودھری",
  "چودھواں": "چودھواں",
  "چودھووںں": "چودھواں",
  "چودھویں": "چودھواں",
  "چوہے": "چوہا",
  "چوہا": "چوہا",
  "چوہدری": "چوہدری",
  "چوہدریو": "چوہدری",
  "چوہدریوں": "چوہدری",
  "چوہو": "چوہا",
  "چوہوں": "چوہا",
  "چوک": "چوک",
  "چوکے": "چوکا",
  "چوکں": "چوکنا",
  "چوکا": "چوکا",
  "چوکنے": "چوکنا",
  "چوکنا": "چوکنا",
  "چوکنی": "چوکنا",
  "چوکتے": "چوکنا",
  "چوکتا": "چوکنا",
  "چوکتی": "چوکنا",
  "چوکتیں": "چوکنا",
  "چوکو": "چوکا",
  "چوکوں": "چوکا",
  "چوکی": "چوکی",
  "چوکیے": "چوکنا",
  "چوکیں": "چوکنا",
  "چوکیاں": "چوکی",
  "چوکیدار": "چوکیدار",
  "چوکیدارو": "چوکیدار",
  "چوکیداروں": "چوکیدار",
  "چوکیو": "چوکی",
  "چوکیوں": "چوکی",
  "چوکھٹ": "چوکھٹ",
  "چوکھٹے": "چوکھٹا",
  "چوکھٹا": "چوکھٹا",
  "چوکھٹو": "چوکھٹا",
  "چوکھٹوں": "چوکھٹا",
  "چوکھٹیں": "چوکھٹ",
  "چولی": "چولی",
  "چولیاں": "چولی",
  "چولیو": "چولی",
  "چولیوں": "چولی",
  "چولھے": "چولھا",
  "چولھا": "چولھا",
  "چولھو": "چولھا",
  "چولھوں": "چولھا",
  "چونچ": "چونچ",
  "چونچو": "چونچ",
  "چونچوں": "چونچ",
  "چونچیں": "چونچ",
  "چونکہ": "چونکہ",
  "چوپال": "چوپال",
  "چوپالو": "چوپال",
  "چوپالوں": "چوپال",
  "چوپالیں": "چوپال",
  "چوپایے": "چوپایہ",
  "چوپایہ": "چوپایہ",
  "چوپایو": "چوپایہ",
  "چوپایوں": "چوپایہ",
  "چور": "چور",
  "چوراہے": "چوراہہ",
  "چوراہہ": "چوراہہ",
  "چوراہو": "چوراہہ",
  "چوراہوں": "چوراہہ",
  "چورو": "چور",
  "چوروں": "چور",
  "چوری": "چوری",
  "چوریاں": "چوری",
  "چوریو": "چوری",
  "چوریوں": "چوری",
  "چوس": "چوسنا",
  "چوسے": "چوسنا",
  "چوسں": "چوسنا",
  "چوسا": "چوسنا",
  "چوسانے": "چوسنا",
  "چوسانا": "چوسنا",
  "چوساتے": "چوسنا",
  "چوساتا": "چوسنا",
  "چوساتی": "چوسنا",
  "چوساتیں": "چوسنا",
  "چوساؤ": "چوسنا",
  "چوساؤں": "چوسنا",
  "چوسائے": "چوسنا",
  "چوسائی": "چوسنا",
  "چوسائیے": "چوسنا",
  "چوسائیں": "چوسنا",
  "چوسایا": "چوسنا",
  "چوسنے": "چوسنا",
  "چوسنا": "چوسنا",
  "چوسنی": "چوسنا",
  "چوستے": "چوسنا",
  "چوستا": "چوسنا",
  "چوستی": "چوسنا",
  "چوستیں": "چوسنا",
  "چوسو": "چوسنا",
  "چوسوں": "چوسنا",
  "چوسوا": "چوسنا",
  "چوسوانے": "چوسنا",
  "چوسوانا": "چوسنا",
  "چوسواتے": "چوسنا",
  "چوسواتا": "چوسنا",
  "چوسواتی": "چوسنا",
  "چوسواتیں": "چوسنا",
  "چوسواؤ": "چوسنا",
  "چوسواؤں": "چوسنا",
  "چوسوائے": "چوسنا",
  "چوسوائی": "چوسنا",
  "چوسوائیے": "چوسنا",
  "چوسوائیں": "چوسنا",
  "چوسوایا": "چوسنا",
  "چوسی": "چوسنا",
  "چوسیے": "چوسنا",
  "چوسیں": "چوسنا",
  "چوزے": "چوزا",
  "چوزا": "چوزا",
  "چوزہ": "چوزہ",
  "چوزو": "چوزا",
  "چوزوں": "چوزا",
  "چیخ": "چیخ",
  "چیخے": "چیخا",
  "چیخں": "چیخنا",
  "چیخا": "چیخا",
  "چیخانے": "چیخنا",
  "چیخانا": "چیخنا",
  "چیخاتے": "چیخنا",
  "چیخاتا": "چیخنا",
  "چیخاتی": "چیخنا",
  "چیخاتیں": "چیخنا",
  "چیخاؤ": "چیخنا",
  "چیخاؤں": "چیخنا",
  "چیخائے": "چیخنا",
  "چیخائی": "چیخنا",
  "چیخائیے": "چیخنا",
  "چیخائیں": "چیخنا",
  "چیخایا": "چیخنا",
  "چیخنے": "چیخنا",
  "چیخنا": "چیخنا",
  "چیخنی": "چیخنا",
  "چیختے": "چیخنا",
  "چیختا": "چیخنا",
  "چیختی": "چیخنا",
  "چیختیں": "چیخنا",
  "چیخو": "چیخا",
  "چیخوں": "چیخا",
  "چیخوا": "چیخنا",
  "چیخوانے": "چیخنا",
  "چیخوانا": "چیخنا",
  "چیخواتے": "چیخنا",
  "چیخواتا": "چیخنا",
  "چیخواتی": "چیخنا",
  "چیخواتیں": "چیخنا",
  "چیخواؤ": "چیخنا",
  "چیخواؤں": "چیخنا",
  "چیخوائے": "چیخنا",
  "چیخوائی": "چیخنا",
  "چیخوائیے": "چیخنا",
  "چیخوائیں": "چیخنا",
  "چیخوایا": "چیخنا",
  "چیخی": "چیخنا",
  "چیخیے": "چیخنا",
  "چیخیں": "چیخ",
  "چیل": "چیل",
  "چیلو": "چیل",
  "چیلوں": "چیل",
  "چیلیں": "چیل",
  "چینل": "چینل",
  "چینلو": "چینل",
  "چینلوں": "چینل",
  "چینی": "چینی",
  "چینیاں": "چینی",
  "چینیو": "چینی",
  "چینیوں": "چینی",
  "چیر": "چیر",
  "چیرے": "چیرنا",
  "چیرں": "چیرنا",
  "چیرا": "چیرنا",
  "چیرانے": "چیرنا",
  "چیرانا": "چیرنا",
  "چیراتے": "چیرنا",
  "چیراتا": "چیرنا",
  "چیراتی": "چیرنا",
  "چیراتیں": "چیرنا",
  "چیراؤ": "چیرنا",
  "چیراؤں": "چیرنا",
  "چیرائے": "چیرنا",
  "چیرائی": "چیرنا",
  "چیرائیے": "چیرنا",
  "چیرائیں": "چیرنا",
  "چیرایا": "چیرنا",
  "چیرنے": "چیرنا",
  "چیرنا": "چیرنا",
  "چیرنی": "چیرنا",
  "چیرتے": "چیرنا",
  "چیرتا": "چیرنا",
  "چیرتی": "چیرنا",
  "چیرتیں": "چیرنا",
  "چیرو": "چیر",
  "چیروں": "چیر",
  "چیروا": "چیرنا",
  "چیروانے": "چیرنا",
  "چیروانا": "چیرنا",
  "چیرواتے": "چیرنا",
  "چیرواتا": "چیرنا",
  "چیرواتی": "چیرنا",
  "چیرواتیں": "چیرنا",
  "چیرواؤ": "چیرنا",
  "چیرواؤں": "چیرنا",
  "چیروائے": "چیرنا",
  "چیروائی": "چیرنا",
  "چیروائیے": "چیرنا",
  "چیروائیں": "چیرنا",
  "چیروایا": "چیرنا",
  "چیری": "چیرنا",
  "چیریے": "چیرنا",
  "چیریں": "چیرنا",
  "چیتھڑ": "چیتھڑ",
  "چیتھڑے": "چیتھڑا",
  "چیتھڑا": "چیتھڑا",
  "چیتھڑو": "چیتھڑا",
  "چیتھڑوں": "چیتھڑا",
  "چیونٹی": "چیونٹی",
  "چیونٹیاں": "چیونٹی",
  "چیونٹیو": "چیونٹی",
  "چیونٹیوں": "چیونٹی",
  "چیز": "چیز",
  "چیزو": "چیز",
  "چیزوں": "چیز",
  "چیزیں": "چیز",
  "چھے": "چھے",
  "چھڑ": "چھڑنا",
  "چھڑے": "چھڑنا",
  "چھڑں": "چھڑنا",
  "چھڑا": "چھڑنا",
  "چھڑانے": "چھڑنا",
  "چھڑانا": "چھڑنا",
  "چھڑاتے": "چھڑنا",
  "چھڑاتا": "چھڑنا",
  "چھڑاتی": "چھڑنا",
  "چھڑاتیں": "چھڑنا",
  "چھڑاؤ": "چھڑنا",
  "چھڑاؤں": "چھڑنا",
  "چھڑائے": "چھڑنا",
  "چھڑائی": "چھڑنا",
  "چھڑائیے": "چھڑنا",
  "چھڑائیں": "چھڑنا",
  "چھڑایا": "چھڑنا",
  "چھڑک": "چھڑکنا",
  "چھڑکے": "چھڑکنا",
  "چھڑکں": "چھڑکنا",
  "چھڑکا": "چھڑکنا",
  "چھڑکانے": "چھڑکنا",
  "چھڑکانا": "چھڑکنا",
  "چھڑکاتے": "چھڑکنا",
  "چھڑکاتا": "چھڑکنا",
  "چھڑکاتی": "چھڑکنا",
  "چھڑکاتیں": "چھڑکنا",
  "چھڑکاؤ": "چھڑکنا",
  "چھڑکاؤں": "چھڑکنا",
  "چھڑکائے": "چھڑکنا",
  "چھڑکائی": "چھڑکنا",
  "چھڑکائیے": "چھڑکنا",
  "چھڑکائیں": "چھڑکنا",
  "چھڑکایا": "چھڑکنا",
  "چھڑکنے": "چھڑکنا",
  "چھڑکنا": "چھڑکنا",
  "چھڑکنی": "چھڑکنا",
  "چھڑکتے": "چھڑکنا",
  "چھڑکتا": "چھڑکنا",
  "چھڑکتی": "چھڑکنا",
  "چھڑکتیں": "چھڑکنا",
  "چھڑکو": "چھڑکنا",
  "چھڑکوں": "چھڑکنا",
  "چھڑکوا": "چھڑکنا",
  "چھڑکوانے": "چھڑکنا",
  "چھڑکوانا": "چھڑکنا",
  "چھڑکواتے": "چھڑکنا",
  "چھڑکواتا": "چھڑکنا",
  "چھڑکواتی": "چھڑکنا",
  "چھڑکواتیں": "چھڑکنا",
  "چھڑکواؤ": "چھڑکنا",
  "چھڑکواؤں": "چھڑکنا",
  "چھڑکوائے": "چھڑکنا",
  "چھڑکوائی": "چھڑکنا",
  "چھڑکوائیے": "چھڑکنا",
  "چھڑکوائیں": "چھڑکنا",
  "چھڑکوایا": "چھڑکنا",
  "چھڑکی": "چھڑکنا",
  "چھڑکیے": "چھڑکنا",
  "چھڑکیں": "چھڑکنا",
  "چھڑنے": "چھڑنا",
  "چھڑنا": "چھڑنا",
  "چھڑنی": "چھڑنا",
  "چھڑتے": "چھڑنا",
  "چھڑتا": "چھڑنا",
  "چھڑتی": "چھڑنا",
  "چھڑتیں": "چھڑنا",
  "چھڑو": "چھڑنا",
  "چھڑوں": "چھڑنا",
  "چھڑوا": "چھڑنا",
  "چھڑوانے": "چھڑنا",
  "چھڑوانا": "چھڑنا",
  "چھڑواتے": "چھڑنا",
  "چھڑواتا": "چھڑنا",
  "چھڑواتی": "چھڑنا",
  "چھڑواتیں": "چھڑنا",
  "چھڑواؤ": "چھڑنا",
  "چھڑواؤں": "چھڑنا",
  "چھڑوائے": "چھڑنا",
  "چھڑوائی": "چھڑنا",
  "چھڑوائیے": "چھڑنا",
  "چھڑوائیں": "چھڑنا",
  "چھڑوایا": "چھڑنا",
  "چھڑی": "چھڑی",
  "چھڑیے": "چھڑنا",
  "چھڑیں": "چھڑنا",
  "چھڑیاں": "چھڑی",
  "چھڑیو": "چھڑی",
  "چھڑیوں": "چھڑی",
  "چھٹا": "چھوٹنا",
  "چھٹانے": "چھوٹنا",
  "چھٹانا": "چھوٹنا",
  "چھٹاتے": "چھوٹنا",
  "چھٹاتا": "چھوٹنا",
  "چھٹاتی": "چھوٹنا",
  "چھٹاتیں": "چھوٹنا",
  "چھٹاؤ": "چھوٹنا",
  "چھٹاؤں": "چھوٹنا",
  "چھٹائے": "چھوٹنا",
  "چھٹائی": "چھوٹنا",
  "چھٹائیے": "چھوٹنا",
  "چھٹائیں": "چھوٹنا",
  "چھٹایا": "چھوٹنا",
  "چھٹکارے": "چھٹکارہ",
  "چھٹکارہ": "چھٹکارہ",
  "چھٹکارو": "چھٹکارہ",
  "چھٹکاروں": "چھٹکارہ",
  "چھٹوا": "چھوٹنا",
  "چھٹوانے": "چھوٹنا",
  "چھٹوانا": "چھوٹنا",
  "چھٹواتے": "چھوٹنا",
  "چھٹواتا": "چھوٹنا",
  "چھٹواتی": "چھوٹنا",
  "چھٹواتیں": "چھوٹنا",
  "چھٹواؤ": "چھوٹنا",
  "چھٹواؤں": "چھوٹنا",
  "چھٹوائے": "چھوٹنا",
  "چھٹوائی": "چھوٹنا",
  "چھٹوائیے": "چھوٹنا",
  "چھٹوائیں": "چھوٹنا",
  "چھٹوایا": "چھوٹنا",
  "چھٹی": "چھٹی",
  "چھٹیاں": "چھٹی",
  "چھٹیو": "چھٹی",
  "چھٹیوں": "چھٹی",
  "چھا": "چھانا",
  "چھاڑ": "چھاڑ",
  "چھاڑو": "چھاڑ",
  "چھاڑوں": "چھاڑ",
  "چھابے": "چھابہ",
  "چھابہ": "چھابہ",
  "چھابو": "چھابہ",
  "چھابوں": "چھابہ",
  "چھاج": "چھاج",
  "چھاجو": "چھاج",
  "چھاجوں": "چھاج",
  "چھان": "چھاننا",
  "چھانے": "چھانا",
  "چھانں": "چھاننا",
  "چھانٹ": "چھانٹنا",
  "چھانٹے": "چھانٹنا",
  "چھانٹں": "چھانٹنا",
  "چھانٹا": "چھانٹنا",
  "چھانٹنے": "چھانٹنا",
  "چھانٹنا": "چھانٹنا",
  "چھانٹنی": "چھانٹنا",
  "چھانٹتے": "چھانٹنا",
  "چھانٹتا": "چھانٹنا",
  "چھانٹتی": "چھانٹنا",
  "چھانٹتیں": "چھانٹنا",
  "چھانٹو": "چھانٹنا",
  "چھانٹوں": "چھانٹنا",
  "چھانٹی": "چھانٹنا",
  "چھانٹیے": "چھانٹنا",
  "چھانٹیں": "چھانٹنا",
  "چھانا": "چھانا",
  "چھاننے": "چھاننا",
  "چھاننا": "چھاننا",
  "چھاننی": "چھاننا",
  "چھانتے": "چھاننا",
  "چھانتا": "چھاننا",
  "چھانتی": "چھاننا",
  "چھانتیں": "چھاننا",
  "چھانو": "چھاننا",
  "چھانوں": "چھاننا",
  "چھانی": "چھانا",
  "چھانیے": "چھاننا",
  "چھانیں": "چھاننا",
  "چھاپ": "چھاپ",
  "چھاپے": "چھاپا",
  "چھاپں": "چھاپنا",
  "چھاپا": "چھاپا",
  "چھاپہ": "چھاپہ",
  "چھاپنے": "چھاپنا",
  "چھاپنا": "چھاپنا",
  "چھاپنی": "چھاپنا",
  "چھاپتے": "چھاپنا",
  "چھاپتا": "چھاپنا",
  "چھاپتی": "چھاپنا",
  "چھاپتیں": "چھاپنا",
  "چھاپو": "چھاپا",
  "چھاپوں": "چھاپا",
  "چھاپی": "چھاپنا",
  "چھاپیے": "چھاپنا",
  "چھاپیں": "چھاپنا",
  "چھات": "چھات",
  "چھاتے": "چھانا",
  "چھاتا": "چھانا",
  "چھاتو": "چھات",
  "چھاتوں": "چھات",
  "چھاتی": "چھاتی",
  "چھاتیں": "چھانا",
  "چھاتیاں": "چھاتی",
  "چھاتیو": "چھاتی",
  "چھاتیوں": "چھاتی",
  "چھاؤ": "چھانا",
  "چھاؤں": "چھانا",
  "چھائے": "چھانا",
  "چھائی": "چھانا",
  "چھائیے": "چھانا",
  "چھائیں": "چھانا",
  "چھایا": "چھانا",
  "چھبس": "چھبس",
  "چھکڑ": "چھکڑ",
  "چھکڑے": "چھکڑا",
  "چھکڑا": "چھکڑا",
  "چھکڑو": "چھکڑا",
  "چھکڑوں": "چھکڑا",
  "چھل": "چھل",
  "چھلے": "چھلا",
  "چھلں": "چھلنا",
  "چھلا": "چھلا",
  "چھلانے": "چھلنا",
  "چھلانا": "چھلنا",
  "چھلاتے": "چھلنا",
  "چھلاتا": "چھلنا",
  "چھلاتی": "چھلنا",
  "چھلاتیں": "چھلنا",
  "چھلاؤ": "چھلنا",
  "چھلاؤں": "چھلنا",
  "چھلائے": "چھلنا",
  "چھلائی": "چھلنا",
  "چھلائیے": "چھلنا",
  "چھلائیں": "چھلنا",
  "چھلایا": "چھلنا",
  "چھلہ": "چھلہ",
  "چھلک": "چھلکنا",
  "چھلکے": "چھلکا",
  "چھلکں": "چھلکنا",
  "چھلکا": "چھلکا",
  "چھلکانے": "چھلکنا",
  "چھلکانا": "چھلکنا",
  "چھلکاتے": "چھلکنا",
  "چھلکاتا": "چھلکنا",
  "چھلکاتی": "چھلکنا",
  "چھلکاتیں": "چھلکنا",
  "چھلکاؤ": "چھلکنا",
  "چھلکاؤں": "چھلکنا",
  "چھلکائے": "چھلکنا",
  "چھلکائی": "چھلکنا",
  "چھلکائیے": "چھلکنا",
  "چھلکائیں": "چھلکنا",
  "چھلکایا": "چھلکنا",
  "چھلکنے": "چھلکنا",
  "چھلکنا": "چھلکنا",
  "چھلکنی": "چھلکنا",
  "چھلکتے": "چھلکنا",
  "چھلکتا": "چھلکنا",
  "چھلکتی": "چھلکنا",
  "چھلکتیں": "چھلکنا",
  "چھلکو": "چھلکا",
  "چھلکوں": "چھلکا",
  "چھلکوا": "چھلکنا",
  "چھلکوانے": "چھلکنا",
  "چھلکوانا": "چھلکنا",
  "چھلکواتے": "چھلکنا",
  "چھلکواتا": "چھلکنا",
  "چھلکواتی": "چھلکنا",
  "چھلکواتیں": "چھلکنا",
  "چھلکواؤ": "چھلکنا",
  "چھلکواؤں": "چھلکنا",
  "چھلکوائے": "چھلکنا",
  "چھلکوائی": "چھلکنا",
  "چھلکوائیے": "چھلکنا",
  "چھلکوائیں": "چھلکنا",
  "چھلکوایا": "چھلکنا",
  "چھلکی": "چھلکنا",
  "چھلکیے": "چھلکنا",
  "چھلکیں": "چھلکنا",
  "چھلنے": "چھلنا",
  "چھلنا": "چھلنا",
  "چھلنی": "چھلنا",
  "چھلتے": "چھلنا",
  "چھلتا": "چھلنا",
  "چھلتی": "چھلنا",
  "چھلتیں": "چھلنا",
  "چھلو": "چھلا",
  "چھلوں": "چھلا",
  "چھلوا": "چھلنا",
  "چھلوانے": "چھلنا",
  "چھلوانا": "چھلنا",
  "چھلواتے": "چھلنا",
  "چھلواتا": "چھلنا",
  "چھلواتی": "چھلنا",
  "چھلواتیں": "چھلنا",
  "چھلواؤ": "چھلنا",
  "چھلواؤں": "چھلنا",
  "چھلوائے": "چھلنا",
  "چھلوائی": "چھلنا",
  "چھلوائیے": "چھلنا",
  "چھلوائیں": "چھلنا",
  "چھلوایا": "چھلنا",
  "چھلی": "چھلنا",
  "چھلیے": "چھلنا",
  "چھلیں": "چھل",
  "چھنٹا": "چھانٹنا",
  "چھنٹانے": "چھانٹنا",
  "چھنٹانا": "چھانٹنا",
  "چھنٹاتے": "چھانٹنا",
  "چھنٹاتا": "چھانٹنا",
  "چھنٹاتی": "چھانٹنا",
  "چھنٹاتیں": "چھانٹنا",
  "چھنٹاؤ": "چھانٹنا",
  "چھنٹاؤں": "چھانٹنا",
  "چھنٹائے": "چھانٹنا",
  "چھنٹائی": "چھانٹنا",
  "چھنٹائیے": "چھانٹنا",
  "چھنٹائیں": "چھانٹنا",
  "چھنٹایا": "چھانٹنا",
  "چھنٹوا": "چھانٹنا",
  "چھنٹوانے": "چھانٹنا",
  "چھنٹوانا": "چھانٹنا",
  "چھنٹواتے": "چھانٹنا",
  "چھنٹواتا": "چھانٹنا",
  "چھنٹواتی": "چھانٹنا",
  "چھنٹواتیں": "چھانٹنا",
  "چھنٹواؤ": "چھانٹنا",
  "چھنٹواؤں": "چھانٹنا",
  "چھنٹوائے": "چھانٹنا",
  "چھنٹوائی": "چھانٹنا",
  "چھنٹوائیے": "چھانٹنا",
  "چھنٹوائیں": "چھانٹنا",
  "چھنٹوایا": "چھانٹنا",
  "چھنا": "چھیننا",
  "چھنانے": "چھیننا",
  "چھنانا": "چھیننا",
  "چھناتے": "چھیننا",
  "چھناتا": "چھیننا",
  "چھناتی": "چھیننا",
  "چھناتیں": "چھیننا",
  "چھناؤ": "چھیننا",
  "چھناؤں": "چھیننا",
  "چھنائے": "چھیننا",
  "چھنائی": "چھیننا",
  "چھنائیے": "چھیننا",
  "چھنائیں": "چھیننا",
  "چھنایا": "چھیننا",
  "چھنچھنا": "چھنچھنانا",
  "چھنچھنانے": "چھنچھنانا",
  "چھنچھنانا": "چھنچھنانا",
  "چھنچھنانی": "چھنچھنانا",
  "چھنچھناتے": "چھنچھنانا",
  "چھنچھناتا": "چھنچھنانا",
  "چھنچھناتی": "چھنچھنانا",
  "چھنچھناتیں": "چھنچھنانا",
  "چھنچھناؤ": "چھنچھنانا",
  "چھنچھناؤں": "چھنچھنانا",
  "چھنچھنائے": "چھنچھنانا",
  "چھنچھنائی": "چھنچھنانا",
  "چھنچھنائیے": "چھنچھنانا",
  "چھنچھنائیں": "چھنچھنانا",
  "چھنچھنایا": "چھنچھنانا",
  "چھنک": "چھنکنا",
  "چھنکے": "چھنکنا",
  "چھنکں": "چھنکنا",
  "چھنکا": "چھنکنا",
  "چھنکانے": "چھنکنا",
  "چھنکانا": "چھنکنا",
  "چھنکاتے": "چھنکنا",
  "چھنکاتا": "چھنکنا",
  "چھنکاتی": "چھنکنا",
  "چھنکاتیں": "چھنکنا",
  "چھنکاؤ": "چھنکنا",
  "چھنکاؤں": "چھنکنا",
  "چھنکائے": "چھنکنا",
  "چھنکائی": "چھنکنا",
  "چھنکائیے": "چھنکنا",
  "چھنکائیں": "چھنکنا",
  "چھنکایا": "چھنکنا",
  "چھنکنے": "چھنکنا",
  "چھنکنا": "چھنکنا",
  "چھنکنی": "چھنکنا",
  "چھنکتے": "چھنکنا",
  "چھنکتا": "چھنکنا",
  "چھنکتی": "چھنکنا",
  "چھنکتیں": "چھنکنا",
  "چھنکو": "چھنکنا",
  "چھنکوں": "چھنکنا",
  "چھنکوا": "چھنکنا",
  "چھنکوانے": "چھنکنا",
  "چھنکوانا": "چھنکنا",
  "چھنکواتے": "چھنکنا",
  "چھنکواتا": "چھنکنا",
  "چھنکواتی": "چھنکنا",
  "چھنکواتیں": "چھنکنا",
  "چھنکواؤ": "چھنکنا",
  "چھنکواؤں": "چھنکنا",
  "چھنکوائے": "چھنکنا",
  "چھنکوائی": "چھنکنا",
  "چھنکوائیے": "چھنکنا",
  "چھنکوائیں": "چھنکنا",
  "چھنکوایا": "چھنکنا",
  "چھنکی": "چھنکنا",
  "چھنکیے": "چھنکنا",
  "چھنکیں": "چھنکنا",
  "چھنوا": "چھیننا",
  "چھنوانے": "چھیننا",
  "چھنوانا": "چھیننا",
  "چھنواتے": "چھیننا",
  "چھنواتا": "چھیننا",
  "چھنواتی": "چھیننا",
  "چھنواتیں": "چھیننا",
  "چھنواؤ": "چھیننا",
  "چھنواؤں": "چھیننا",
  "چھنوائے": "چھیننا",
  "چھنوائی": "چھیننا",
  "چھنوائیے": "چھیننا",
  "چھنوائیں": "چھیننا",
  "چھنوایا": "چھیننا",
  "چھپ": "چھپنا",
  "چھپے": "چھپنا",
  "چھپں": "چھپنا",
  "چھپا": "چھپنا",
  "چھپانے": "چھپنا",
  "چھپانا": "چھپنا",
  "چھپاتے": "چھپنا",
  "چھپاتا": "چھپنا",
  "چھپاتی": "چھپنا",
  "چھپاتیں": "چھپنا",
  "چھپاؤ": "چھپنا",
  "چھپاؤں": "چھپنا",
  "چھپائے": "چھپنا",
  "چھپائی": "چھپنا",
  "چھپائیے": "چھپنا",
  "چھپائیں": "چھپنا",
  "چھپایا": "چھپنا",
  "چھپکلی": "چھپکلی",
  "چھپکلیاں": "چھپکلی",
  "چھپکلیو": "چھپکلی",
  "چھپکلیوں": "چھپکلی",
  "چھپنے": "چھپنا",
  "چھپنا": "چھپنا",
  "چھپنی": "چھپنا",
  "چھپر": "چھپر",
  "چھپرو": "چھپر",
  "چھپروں": "چھپر",
  "چھپتے": "چھپنا",
  "چھپتا": "چھپنا",
  "چھپتی": "چھپنا",
  "چھپتیں": "چھپنا",
  "چھپو": "چھپنا",
  "چھپوں": "چھپنا",
  "چھپوا": "چھپنا",
  "چھپوانے": "چھپنا",
  "چھپوانا": "چھپنا",
  "چھپواتے": "چھپنا",
  "چھپواتا": "چھپنا",
  "چھپواتی": "چھپنا",
  "چھپواتیں": "چھپنا",
  "چھپواؤ": "چھپنا",
  "چھپواؤں": "چھپنا",
  "چھپوائے": "چھپنا",
  "چھپوائی": "چھپنا",
  "چھپوائیے": "چھپنا",
  "چھپوائیں": "چھپنا",
  "چھپوایا": "چھپنا",
  "چھپی": "چھپنا",
  "چھپیے": "چھپنا",
  "چھپیں": "چھپنا",
  "چھرے": "چھرا",
  "چھرا": "چھرا",
  "چھرو": "چھرا",
  "چھروں": "چھرا",
  "چھری": "چھری",
  "چھریاں": "چھری",
  "چھریو": "چھری",
  "چھریوں": "چھری",
  "چھت": "چھت",
  "چھتے": "چھتہ",
  "چھتں": "چھتنا",
  "چھتا": "چھتنا",
  "چھتانے": "چھتنا",
  "چھتانا": "چھتنا",
  "چھتاتے": "چھتنا",
  "چھتاتا": "چھتنا",
  "چھتاتی": "چھتنا",
  "چھتاتیں": "چھتنا",
  "چھتاؤ": "چھتنا",
  "چھتاؤں": "چھتنا",
  "چھتائے": "چھتنا",
  "چھتائی": "چھتنا",
  "چھتائیے": "چھتنا",
  "چھتائیں": "چھتنا",
  "چھتایا": "چھتنا",
  "چھتہ": "چھتہ",
  "چھتنے": "چھتنا",
  "چھتنا": "چھتنا",
  "چھتنی": "چھتنا",
  "چھتتے": "چھتنا",
  "چھتتا": "چھتنا",
  "چھتتی": "چھتنا",
  "چھتتیں": "چھتنا",
  "چھتو": "چھتہ",
  "چھتوں": "چھتہ",
  "چھتوا": "چھتنا",
  "چھتوانے": "چھتنا",
  "چھتوانا": "چھتنا",
  "چھتواتے": "چھتنا",
  "چھتواتا": "چھتنا",
  "چھتواتی": "چھتنا",
  "چھتواتیں": "چھتنا",
  "چھتواؤ": "چھتنا",
  "چھتواؤں": "چھتنا",
  "چھتوائے": "چھتنا",
  "چھتوائی": "چھتنا",
  "چھتوائیے": "چھتنا",
  "چھتوائیں": "چھتنا",
  "چھتوایا": "چھتنا",
  "چھتی": "چھتنا",
  "چھتیے": "چھتنا",
  "چھتیں": "چھت",
  "چھو": "چھونا",
  "چھوڑ": "چھوڑنا",
  "چھوڑے": "چھوڑا",
  "چھوڑں": "چھوڑنا",
  "چھوڑا": "چھوڑا",
  "چھوڑنے": "چھوڑنا",
  "چھوڑنا": "چھوڑنا",
  "چھوڑنی": "چھوڑنا",
  "چھوڑتے": "چھوڑنا",
  "چھوڑتا": "چھوڑنا",
  "چھوڑتی": "چھوڑنا",
  "چھوڑتیں": "چھوڑنا",
  "چھوڑو": "چھوڑا",
  "چھوڑوں": "چھوڑا",
  "چھوڑی": "چھوڑنا",
  "چھوڑیے": "چھوڑنا",
  "چھوڑیں": "چھوڑنا",
  "چھوٹ": "چھوٹ",
  "چھوٹے": "چھوٹا",
  "چھوٹں": "چھوٹنا",
  "چھوٹا": "چھوٹا",
  "چھوٹنے": "چھوٹنا",
  "چھوٹنا": "چھوٹنا",
  "چھوٹنی": "چھوٹنا",
  "چھوٹتے": "چھوٹنا",
  "چھوٹتا": "چھوٹنا",
  "چھوٹتی": "چھوٹنا",
  "چھوٹتیں": "چھوٹنا",
  "چھوٹو": "چھوٹا",
  "چھوٹوں": "چھوٹا",
  "چھوٹی": "چھوٹنا",
  "چھوٹیے": "چھوٹنا",
  "چھوٹیں": "چھوٹ",
  "چھوہارے": "چھوہارا",
  "چھوہارا": "چھوہارا",
  "چھوہارو": "چھوہارا",
  "چھوہاروں": "چھوہارا",
  "چھوکری": "چھوکری",
  "چھوکریاں": "چھوکری",
  "چھوکریو": "چھوکری",
  "چھوکریوں": "چھوکری",
  "چھونے": "چھونا",
  "چھونا": "چھونا",
  "چھونی": "چھونا",
  "چھوت": "چھوت",
  "چھوتے": "چھونا",
  "چھوتا": "چھونا",
  "چھوتو": "چھوت",
  "چھوتوں": "چھوت",
  "چھوتی": "چھونا",
  "چھوتیں": "چھوت",
  "چھوؤ": "چھونا",
  "چھوؤں": "چھونا",
  "چھوئے": "چھونا",
  "چھوئی": "چھونا",
  "چھوئیے": "چھونا",
  "چھوئیں": "چھونا",
  "چھویا": "چھونا",
  "چھیڑ": "چھیڑنا",
  "چھیڑے": "چھیڑنا",
  "چھیڑں": "چھیڑنا",
  "چھیڑا": "چھیڑنا",
  "چھیڑنے": "چھیڑنا",
  "چھیڑنا": "چھیڑنا",
  "چھیڑنی": "چھیڑنا",
  "چھیڑتے": "چھیڑنا",
  "چھیڑتا": "چھیڑنا",
  "چھیڑتی": "چھیڑنا",
  "چھیڑتیں": "چھیڑنا",
  "چھیڑو": "چھیڑنا",
  "چھیڑوں": "چھیڑنا",
  "چھیڑی": "چھیڑنا",
  "چھیڑیے": "چھیڑنا",
  "چھیڑیں": "چھیڑنا",
  "چھید": "چھیدنا",
  "چھیدے": "چھیدنا",
  "چھیدں": "چھیدنا",
  "چھیدا": "چھیدنا",
  "چھیدنے": "چھیدنا",
  "چھیدنا": "چھیدنا",
  "چھیدنی": "چھیدنا",
  "چھیدتے": "چھیدنا",
  "چھیدتا": "چھیدنا",
  "چھیدتی": "چھیدنا",
  "چھیدتیں": "چھیدنا",
  "چھیدو": "چھیدنا",
  "چھیدوں": "چھیدنا",
  "چھیدی": "چھیدنا",
  "چھیدیے": "چھیدنا",
  "چھیدیں": "چھیدنا",
  "چھیل": "چھیلنا",
  "چھیلے": "چھیلنا",
  "چھیلں": "چھیلنا",
  "چھیلا": "چھیلنا",
  "چھیلنے": "چھیلنا",
  "چھیلنا": "چھیلنا",
  "چھیلنی": "چھیلنا",
  "چھیلتے": "چھیلنا",
  "چھیلتا": "چھیلنا",
  "چھیلتی": "چھیلنا",
  "چھیلتیں": "چھیلنا",
  "چھیلو": "چھیلنا",
  "چھیلوں": "چھیلنا",
  "چھیلی": "چھیلنا",
  "چھیلیے": "چھیلنا",
  "چھیلیں": "چھیلنا",
  "چھین": "چھیننا",
  "چھینے": "چھیننا",
  "چھینں": "چھیننا",
  "چھینٹے": "چھینٹا",
  "چھینٹا": "چھینٹا",
  "چھینٹو": "چھینٹا",
  "چھینٹوں": "چھینٹا",
  "چھینا": "چھیننا",
  "چھیننے": "چھیننا",
  "چھیننا": "چھیننا",
  "چھیننی": "چھیننا",
  "چھینتے": "چھیننا",
  "چھینتا": "چھیننا",
  "چھینتی": "چھیننا",
  "چھینتیں": "چھیننا",
  "چھینو": "چھیننا",
  "چھینوں": "چھیننا",
  "چھینی": "چھیننا",
  "چھینیے": "چھیننا",
  "چھینیں": "چھیننا",
  "دَور": "دَور",
  "دَورے": "دَورہ",
  "دَورہ": "دَورہ",
  "دَورو": "دَورہ",
  "دَوروں": "دَورہ",
  "دِل": "دِل",
  "دِلْچَسْپ": "دِلْچَسْپ",
  "دِلو": "دِل",
  "دِلوں": "دِل",
  "دِن": "دِن",
  "دِنو": "دِن",
  "دِنوں": "دِن",
  "دُشمن": "دُشمن",
  "دُشمنو": "دُشمن",
  "دُشمنوں": "دُشمن",
  "دُبا": "دُوبنا",
  "دُبانے": "دُوبنا",
  "دُبانا": "دُوبنا",
  "دُباتے": "دُوبنا",
  "دُباتا": "دُوبنا",
  "دُباتی": "دُوبنا",
  "دُباتیں": "دُوبنا",
  "دُباؤ": "دُوبنا",
  "دُباؤں": "دُوبنا",
  "دُبائے": "دُوبنا",
  "دُبائی": "دُوبنا",
  "دُبائیے": "دُوبنا",
  "دُبائیں": "دُوبنا",
  "دُبایا": "دُوبنا",
  "دُبوا": "دُوبنا",
  "دُبوانے": "دُوبنا",
  "دُبوانا": "دُوبنا",
  "دُبواتے": "دُوبنا",
  "دُبواتا": "دُوبنا",
  "دُبواتی": "دُوبنا",
  "دُبواتیں": "دُوبنا",
  "دُبواؤ": "دُوبنا",
  "دُبواؤں": "دُوبنا",
  "دُبوائے": "دُوبنا",
  "دُبوائی": "دُوبنا",
  "دُبوائیے": "دُوبنا",
  "دُبوائیں": "دُوبنا",
  "دُبوایا": "دُوبنا",
  "دُعا": "دُعا",
  "دُعاؤ": "دُعا",
  "دُعاؤں": "دُعا",
  "دُعائیں": "دُعا",
  "دُکان": "دُکان",
  "دُکانو": "دُکان",
  "دُکانوں": "دُکان",
  "دُکانیں": "دُکان",
  "دُنبی": "دُنبی",
  "دُنبیاں": "دُنبی",
  "دُنبیو": "دُنبی",
  "دُنبیوں": "دُنبی",
  "دُوب": "دُوبنا",
  "دُوبے": "دُوبنا",
  "دُوبں": "دُوبنا",
  "دُوبا": "دُوبنا",
  "دُوبنے": "دُوبنا",
  "دُوبنا": "دُوبنا",
  "دُوبنی": "دُوبنا",
  "دُوبتے": "دُوبنا",
  "دُوبتا": "دُوبنا",
  "دُوبتی": "دُوبنا",
  "دُوبتیں": "دُوبنا",
  "دُوبو": "دُوبنا",
  "دُوبوں": "دُوبنا",
  "دُوبی": "دُوبنا",
  "دُوبیے": "دُوبنا",
  "دُوبیں": "دُوبنا",
  "دُوسْرے": "دُوسْرا",
  "دُوسْرا": "دُوسْرا",
  "دُوسْری": "دُوسْرا",
  "دُھن": "دُھننا",
  "دُھنے": "دُھننا",
  "دُھنں": "دُھننا",
  "دُھنا": "دُھننا",
  "دُھنانے": "دُھننا",
  "دُھنانا": "دُھننا",
  "دُھناتے": "دُھننا",
  "دُھناتا": "دُھننا",
  "دُھناتی": "دُھننا",
  "دُھناتیں": "دُھننا",
  "دُھناؤ": "دُھننا",
  "دُھناؤں": "دُھننا",
  "دُھنائے": "دُھننا",
  "دُھنائی": "دُھننا",
  "دُھنائیے": "دُھننا",
  "دُھنائیں": "دُھننا",
  "دُھنایا": "دُھننا",
  "دُھنن": "دُھنننا",
  "دُھننے": "دُھننا",
  "دُھننں": "دُھنننا",
  "دُھننا": "دُھننا",
  "دُھنننے": "دُھنننا",
  "دُھنننا": "دُھنننا",
  "دُھنننی": "دُھنننا",
  "دُھننتے": "دُھنننا",
  "دُھننتا": "دُھنننا",
  "دُھننتی": "دُھنننا",
  "دُھننتیں": "دُھنننا",
  "دُھننو": "دُھنننا",
  "دُھننوں": "دُھنننا",
  "دُھننوا": "دُھننا",
  "دُھننوانے": "دُھننا",
  "دُھننوانا": "دُھننا",
  "دُھننواتے": "دُھننا",
  "دُھننواتا": "دُھننا",
  "دُھننواتی": "دُھننا",
  "دُھننواتیں": "دُھننا",
  "دُھننواؤ": "دُھننا",
  "دُھننواؤں": "دُھننا",
  "دُھننوائے": "دُھننا",
  "دُھننوائی": "دُھننا",
  "دُھننوائیے": "دُھننا",
  "دُھننوائیں": "دُھننا",
  "دُھننوایا": "دُھننا",
  "دُھننی": "دُھننا",
  "دُھننیے": "دُھنننا",
  "دُھننیں": "دُھنننا",
  "دُھنتے": "دُھننا",
  "دُھنتا": "دُھننا",
  "دُھنتی": "دُھننا",
  "دُھنتیں": "دُھننا",
  "دُھنو": "دُھننا",
  "دُھنوں": "دُھننا",
  "دُھنوا": "دُھننا",
  "دُھنوانے": "دُھننا",
  "دُھنوانا": "دُھننا",
  "دُھنواتے": "دُھننا",
  "دُھنواتا": "دُھننا",
  "دُھنواتی": "دُھننا",
  "دُھنواتیں": "دُھننا",
  "دُھنواؤ": "دُھننا",
  "دُھنواؤں": "دُھننا",
  "دُھنوائے": "دُھننا",
  "دُھنوائی": "دُھننا",
  "دُھنوائیے": "دُھننا",
  "دُھنوائیں": "دُھننا",
  "دُھنوایا": "دُھننا",
  "دُھنی": "دُھننا",
  "دُھنیے": "دُھننا",
  "دُھنیں": "دُھننا",
  "دُھواں": "دُھواں",
  "دُھووںں": "دُھواں",
  "دُھویں": "دُھواں",
  "دے": "دینا",
  "دغاباز": "دغاباز",
  "دغابازو": "دغاباز",
  "دغابازوں": "دغاباز",
  "دشمن": "دشمن",
  "دشمنو": "دشمن",
  "دشمنوں": "دشمن",
  "دشواری": "دشواری",
  "دشواریاں": "دشواری",
  "دشواریو": "دشواری",
  "دشواریوں": "دشواری",
  "داغ": "داغ",
  "داغو": "داغ",
  "داغوں": "داغ",
  "داخلے": "داخلہ",
  "داخلہ": "داخلہ",
  "داخلو": "داخلہ",
  "داخلوں": "داخلہ",
  "داڑھی": "داڑھی",
  "داڑھیاں": "داڑھی",
  "داڑھیو": "داڑھی",
  "داڑھیوں": "داڑھی",
  "داب": "دبنا",
  "دابے": "دبنا",
  "دابں": "دبنا",
  "دابا": "دبنا",
  "دابنے": "دبنا",
  "دابنا": "دبنا",
  "دابنی": "دابنا",
  "دابتے": "دبنا",
  "دابتا": "دبنا",
  "دابتی": "دبنا",
  "دابتیں": "دبنا",
  "دابو": "دبنا",
  "دابوں": "دبنا",
  "دابی": "دبنا",
  "دابیے": "دبنا",
  "دابیں": "دبنا",
  "داد": "داد",
  "دادے": "دادہ",
  "دادا": "دادا",
  "داداؤ": "دادا",
  "داداؤں": "دادا",
  "دادائیں": "دادا",
  "دادہ": "دادہ",
  "دادو": "دادہ",
  "دادوں": "دادہ",
  "دادی": "دادی",
  "دادیاں": "دادی",
  "دادیو": "دادی",
  "دادیوں": "دادی",
  "دال": "دال",
  "دالے": "دالنا",
  "دالں": "دالنا",
  "دالا": "دالنا",
  "دالان": "دالان",
  "دالانو": "دالان",
  "دالانوں": "دالان",
  "دالانیں": "دالان",
  "دالنے": "دالنا",
  "دالنا": "دالنا",
  "دالنی": "دالنا",
  "دالتے": "دالنا",
  "دالتا": "دالنا",
  "دالتی": "دالنا",
  "دالتیں": "دالنا",
  "دالو": "دال",
  "دالوں": "دال",
  "دالی": "دالنا",
  "دالیے": "دالنا",
  "دالیں": "دال",
  "دام": "دام",
  "داماد": "داماد",
  "دامادو": "داماد",
  "دامادوں": "داماد",
  "دامو": "دام",
  "داموں": "دام",
  "دان": "دان",
  "دانے": "دانا",
  "دانشمند": "دانشمند",
  "دانشمندو": "دانشمند",
  "دانشمندوں": "دانشمند",
  "دانشور": "دانشور",
  "دانشورو": "دانشور",
  "دانشوروں": "دانشور",
  "دانا": "دانا",
  "داناؤ": "دانا",
  "داناؤں": "دانا",
  "دانائیں": "دانا",
  "دانہ": "دانہ",
  "دانت": "دانت",
  "دانتو": "دانت",
  "دانتوں": "دانت",
  "دانتیں": "دانت",
  "دانو": "دانا",
  "دانوں": "دانا",
  "دار": "دار",
  "دارالخلافے": "دارالخلافہ",
  "دارالخلافہ": "دارالخلافہ",
  "دارالخلافو": "دارالخلافہ",
  "دارالخلافوں": "دارالخلافہ",
  "دارو": "دار",
  "داروغے": "داروغہ",
  "داروغہ": "داروغہ",
  "داروغو": "داروغہ",
  "داروغوں": "داروغہ",
  "داروں": "دار",
  "داری": "داری",
  "داریاں": "داری",
  "داریو": "داری",
  "داریوں": "داری",
  "داستان": "داستان",
  "داستانو": "داستان",
  "داستانوں": "داستان",
  "داستانیں": "داستان",
  "داو": "داو",
  "داوؤ": "داو",
  "داوؤں": "داو",
  "دائرے": "دائرا",
  "دائرا": "دائرا",
  "دائرہ": "دائرہ",
  "دائرو": "دائرا",
  "دائروں": "دائرا",
  "دائی": "دائی",
  "دائیں": "بایاں",
  "دائیاں": "دائی",
  "دائیو": "دائی",
  "دائیوں": "دائی",
  "دایاں": "دایاں",
  "دب": "دبنا",
  "دبے": "دبا",
  "دبں": "دبنا",
  "دبا": "دبا",
  "دبانے": "دابنا",
  "دبانا": "دابنا",
  "دباتے": "دابنا",
  "دباتا": "دابنا",
  "دباتی": "دابنا",
  "دباتیں": "دابنا",
  "دباؤ": "دباؤ",
  "دباؤں": "دابنا",
  "دبائے": "دابنا",
  "دبائی": "دابنا",
  "دبائیے": "دابنا",
  "دبائیں": "دابنا",
  "دبایا": "دابنا",
  "دبدبے": "دبدبہ",
  "دبدبہ": "دبدبہ",
  "دبدبو": "دبدبہ",
  "دبدبوں": "دبدبہ",
  "دبنے": "دبنا",
  "دبنا": "دبنا",
  "دبنی": "دبنا",
  "دبستان": "دبستان",
  "دبستانو": "دبستان",
  "دبستانوں": "دبستان",
  "دبستانیں": "دبستان",
  "دبتے": "دبنا",
  "دبتا": "دبنا",
  "دبتی": "دبنا",
  "دبتیں": "دبنا",
  "دبو": "دبا",
  "دبوں": "دبا",
  "دبوا": "دبنا",
  "دبوانے": "دبنا",
  "دبوانا": "دبنا",
  "دبواتے": "دبنا",
  "دبواتا": "دبنا",
  "دبواتی": "دبنا",
  "دبواتیں": "دبنا",
  "دبواؤ": "دبنا",
  "دبواؤں": "دبنا",
  "دبوائے": "دبنا",
  "دبوائی": "دبنا",
  "دبوائیے": "دبنا",
  "دبوائیں": "دبنا",
  "دبوایا": "دبنا",
  "دبی": "دبنا",
  "دبیے": "دبنا",
  "دبیں": "دبنا",
  "دعا": "دعا",
  "دعاؤ": "دعا",
  "دعاؤں": "دعا",
  "دعائیں": "دعا",
  "دعوے": "دعوہ",
  "دعوہ": "دعوہ",
  "دعوت": "دعوت",
  "دعوتو": "دعوت",
  "دعوتوں": "دعوت",
  "دعوتیں": "دعوت",
  "دعوو": "دعوہ",
  "دعووں": "دعوہ",
  "دفنا": "دفنانا",
  "دفنانے": "دفنانا",
  "دفنانا": "دفنانا",
  "دفنانی": "دفنانا",
  "دفناتے": "دفنانا",
  "دفناتا": "دفنانا",
  "دفناتی": "دفنانا",
  "دفناتیں": "دفنانا",
  "دفناؤ": "دفنانا",
  "دفناؤں": "دفنانا",
  "دفنائے": "دفنانا",
  "دفنائی": "دفنانا",
  "دفنائیے": "دفنانا",
  "دفنائیں": "دفنانا",
  "دفنایا": "دفنانا",
  "دفتر": "دفتر",
  "دفترو": "دفتر",
  "دفتروں": "دفتر",
  "دفتری": "دفتری",
  "دہشتگرد": "دہشتگرد",
  "دہشتگردو": "دہشتگرد",
  "دہشتگردوں": "دہشتگرد",
  "دہانی": "دہانی",
  "دہانیاں": "دہانی",
  "دہانیو": "دہانی",
  "دہانیوں": "دہانی",
  "دہات": "دہات",
  "دہاتو": "دہات",
  "دہاتوں": "دہات",
  "دہاتیں": "دہات",
  "دہقان": "دہقان",
  "دہقانو": "دہقان",
  "دہقانوں": "دہقان",
  "دہرا": "دہرانا",
  "دہرانے": "دہرانا",
  "دہرانا": "دہرانا",
  "دہرانی": "دہرانا",
  "دہراتے": "دہرانا",
  "دہراتا": "دہرانا",
  "دہراتی": "دہرانا",
  "دہراتیں": "دہرانا",
  "دہراؤ": "دہرانا",
  "دہراؤں": "دہرانا",
  "دہرائے": "دہرانا",
  "دہرائی": "دہرانا",
  "دہرائیے": "دہرانا",
  "دہرائیں": "دہرانا",
  "دہرایا": "دہرانا",
  "دہی": "دہی",
  "دہیو": "دہی",
  "دہیوں": "دہی",
  "دکان": "دکان",
  "دکاندار": "دکاندار",
  "دکاندارو": "دکاندار",
  "دکانداروں": "دکاندار",
  "دکانو": "دکان",
  "دکانوں": "دکان",
  "دکانیں": "دکان",
  "دکھ": "دکھنا",
  "دکھْلا": "دیکھْنا",
  "دکھْلانے": "دیکھْنا",
  "دکھْلانا": "دیکھْنا",
  "دکھْلاتے": "دیکھْنا",
  "دکھْلاتا": "دیکھْنا",
  "دکھْلاتی": "دیکھْنا",
  "دکھْلاتیں": "دیکھْنا",
  "دکھْلاؤ": "دیکھْنا",
  "دکھْلاؤں": "دیکھْنا",
  "دکھْلائے": "دیکھْنا",
  "دکھْلائی": "دیکھْنا",
  "دکھْلائیے": "دیکھْنا",
  "دکھْلائیں": "دیکھْنا",
  "دکھْلایا": "دیکھْنا",
  "دکھْوا": "دیکھْنا",
  "دکھْوانے": "دیکھْنا",
  "دکھْوانا": "دیکھْنا",
  "دکھْواتے": "دیکھْنا",
  "دکھْواتا": "دیکھْنا",
  "دکھْواتی": "دیکھْنا",
  "دکھْواتیں": "دیکھْنا",
  "دکھْواؤ": "دیکھْنا",
  "دکھْواؤں": "دیکھْنا",
  "دکھْوائے": "دیکھْنا",
  "دکھْوائی": "دیکھْنا",
  "دکھْوائیے": "دیکھْنا",
  "دکھْوائیں": "دیکھْنا",
  "دکھْوایا": "دیکھْنا",
  "دکھے": "دکھنا",
  "دکھں": "دکھنا",
  "دکھا": "دکھنا",
  "دکھانے": "دکھنا",
  "دکھانا": "دکھنا",
  "دکھاتے": "دکھنا",
  "دکھاتا": "دکھنا",
  "دکھاتی": "دکھنا",
  "دکھاتیں": "دکھنا",
  "دکھاؤ": "دکھنا",
  "دکھاؤں": "دکھنا",
  "دکھائے": "دکھنا",
  "دکھائی": "دکھنا",
  "دکھائیے": "دکھنا",
  "دکھائیں": "دکھنا",
  "دکھایا": "دکھنا",
  "دکھنے": "دکھنا",
  "دکھنا": "دکھنا",
  "دکھنی": "دکھنا",
  "دکھتے": "دکھنا",
  "دکھتا": "دکھنا",
  "دکھتی": "دکھنا",
  "دکھتیں": "دکھنا",
  "دکھو": "دکھنا",
  "دکھوں": "دکھنا",
  "دکھوا": "دکھنا",
  "دکھوانے": "دکھنا",
  "دکھوانا": "دکھنا",
  "دکھواتے": "دکھنا",
  "دکھواتا": "دکھنا",
  "دکھواتی": "دکھنا",
  "دکھواتیں": "دکھنا",
  "دکھواؤ": "دکھنا",
  "دکھواؤں": "دکھنا",
  "دکھوائے": "دکھنا",
  "دکھوائی": "دکھنا",
  "دکھوائیے": "دکھنا",
  "دکھوائیں": "دکھنا",
  "دکھوایا": "دکھنا",
  "دکھی": "دکھنا",
  "دکھیے": "دکھنا",
  "دکھیں": "دکھنا",
  "دل": "دل",
  "دلا": "دالنا",
  "دلانے": "دالنا",
  "دلانا": "دالنا",
  "دلانی": "دلانا",
  "دلاتے": "دالنا",
  "دلاتا": "دالنا",
  "دلاتی": "دالنا",
  "دلاتیں": "دالنا",
  "دلاؤ": "دالنا",
  "دلاؤں": "دالنا",
  "دلائے": "دالنا",
  "دلائی": "دالنا",
  "دلائیے": "دالنا",
  "دلائیں": "دالنا",
  "دلایا": "دالنا",
  "دلچسپ": "دلچسپ",
  "دلچسپی": "دلچسپی",
  "دلچسپیاں": "دلچسپی",
  "دلچسپیو": "دلچسپی",
  "دلچسپیوں": "دلچسپی",
  "دلدل": "دلدل",
  "دلدلو": "دلدل",
  "دلدلوں": "دلدل",
  "دلدلیں": "دلدل",
  "دلہن": "دلہن",
  "دلہنو": "دلہن",
  "دلہنوں": "دلہن",
  "دلہنیں": "دلہن",
  "دلو": "دل",
  "دلوں": "دل",
  "دلوا": "دالنا",
  "دلوانے": "دالنا",
  "دلوانا": "دالنا",
  "دلواتے": "دالنا",
  "دلواتا": "دالنا",
  "دلواتی": "دالنا",
  "دلواتیں": "دالنا",
  "دلواؤ": "دالنا",
  "دلواؤں": "دالنا",
  "دلوائے": "دالنا",
  "دلوائی": "دالنا",
  "دلوائیے": "دالنا",
  "دلوائیں": "دالنا",
  "دلوایا": "دالنا",
  "دلیل": "دلیل",
  "دلیلو": "دلیل",
  "دلیلوں": "دلیل",
  "دلیلیں": "دلیل",
  "دمے": "دمہ",
  "دماغ": "دماغ",
  "دماغو": "دماغ",
  "دماغوں": "دماغ",
  "دمہ": "دمہ",
  "دمک": "دمکنا",
  "دمکے": "دمکنا",
  "دمکں": "دمکنا",
  "دمکا": "دمکنا",
  "دمکنے": "دمکنا",
  "دمکنا": "دمکنا",
  "دمکنی": "دمکنا",
  "دمکتے": "دمکنا",
  "دمکتا": "دمکنا",
  "دمکتی": "دمکنا",
  "دمکتیں": "دمکنا",
  "دمکو": "دمکنا",
  "دمکوں": "دمکنا",
  "دمکی": "دمکنا",
  "دمکیے": "دمکنا",
  "دمکیں": "دمکنا",
  "دمو": "دمہ",
  "دموں": "دمہ",
  "دن": "دن",
  "دنو": "دن",
  "دنوں": "دن",
  "دنیا": "دنیا",
  "دنیاؤ": "دنیا",
  "دنیاؤں": "دنیا",
  "دنیائیں": "دنیا",
  "در": "در",
  "درے": "درہ",
  "درخت": "درخت",
  "درختو": "درخت",
  "درختوں": "درخت",
  "درختیں": "درخت",
  "درخواست": "درخواست",
  "درخواستو": "درخواست",
  "درخواستوں": "درخواست",
  "درخواستیں": "درخواست",
  "درں": "درنا",
  "درا": "درنا",
  "دراڑ": "دراڑ",
  "دراڑو": "دراڑ",
  "دراڑوں": "دراڑ",
  "دراڑیں": "دراڑ",
  "درانے": "درنا",
  "درانا": "درنا",
  "دراتے": "درنا",
  "دراتا": "درنا",
  "دراتی": "درنا",
  "دراتیں": "درنا",
  "دراؤ": "درنا",
  "دراؤں": "درنا",
  "درائے": "درنا",
  "درائی": "درنا",
  "درائیے": "درنا",
  "درائیں": "درنا",
  "درایا": "درنا",
  "دراز": "دراز",
  "درازو": "دراز",
  "درازوں": "دراز",
  "درازیں": "دراز",
  "دربار": "دربار",
  "دربارو": "دربار",
  "درباروں": "دربار",
  "درباری": "درباری",
  "درباریں": "دربار",
  "درباریاں": "درباری",
  "درباریو": "درباری",
  "درباریوں": "درباری",
  "درگاہ": "درگاہ",
  "درگاہو": "درگاہ",
  "درگاہوں": "درگاہ",
  "درگاہیں": "درگاہ",
  "درہ": "درہ",
  "درہم": "درہم",
  "درہمو": "درہم",
  "درہموں": "درہم",
  "درجے": "درجہ",
  "درجہ": "درجہ",
  "درجن": "درجن",
  "درجنو": "درجن",
  "درجنوں": "درجن",
  "درجو": "درجہ",
  "درجوں": "درجہ",
  "درمیانے": "درمیانہ",
  "درمیانہ": "درمیانہ",
  "درمیانو": "درمیانہ",
  "درمیانوں": "درمیانہ",
  "درنے": "درنا",
  "درنا": "درنا",
  "درندے": "درندہ",
  "درندہ": "درندہ",
  "درندو": "درندہ",
  "درندوں": "درندہ",
  "درنی": "درنا",
  "درسگاہ": "درسگاہ",
  "درسگاہو": "درسگاہ",
  "درسگاہوں": "درسگاہ",
  "درسگاہیں": "درسگاہ",
  "درتے": "درنا",
  "درتا": "درنا",
  "درتی": "درنا",
  "درتیں": "درنا",
  "درو": "درہ",
  "دروں": "درہ",
  "دروا": "درنا",
  "دروانے": "درنا",
  "دروانا": "درنا",
  "درواتے": "درنا",
  "درواتا": "درنا",
  "درواتی": "درنا",
  "درواتیں": "درنا",
  "درواؤ": "درنا",
  "درواؤں": "درنا",
  "دروائے": "درنا",
  "دروائی": "درنا",
  "دروائیے": "درنا",
  "دروائیں": "درنا",
  "دروایا": "درنا",
  "دروازے": "دروازہ",
  "دروازہ": "دروازہ",
  "دروازو": "دروازہ",
  "دروازوں": "دروازہ",
  "درویش": "درویش",
  "درویشو": "درویش",
  "درویشوں": "درویش",
  "دری": "دری",
  "دریے": "درنا",
  "دریں": "درنا",
  "دریا": "دریا",
  "دریاں": "دری",
  "دریاو": "دریاو",
  "دریاؤ": "دریا",
  "دریاؤں": "دریا",
  "دریاوؤ": "دریاو",
  "دریاوؤں": "دریاو",
  "دریائیں": "دریا",
  "دریچے": "دریچہ",
  "دریچہ": "دریچہ",
  "دریچو": "دریچہ",
  "دریچوں": "دریچہ",
  "دریو": "دری",
  "دریوں": "دری",
  "درزے": "درزہ",
  "درزہ": "درزہ",
  "درزو": "درزہ",
  "درزوں": "درزہ",
  "درزی": "درزی",
  "درزیاں": "درزی",
  "درزیو": "درزی",
  "درزیوں": "درزی",
  "دس": "دس",
  "دسہرے": "دسہرہ",
  "دسہرہ": "دسہرہ",
  "دسہرو": "دسہرہ",
  "دسہروں": "دسہرہ",
  "دست": "دست",
  "دستے": "دستا",
  "دستا": "دستا",
  "دستہ": "دستہ",
  "دستکار": "دستکار",
  "دستکارو": "دستکار",
  "دستکاروں": "دستکار",
  "دستو": "دستا",
  "دستوں": "دستا",
  "دستیں": "دست",
  "دسواں": "دسواں",
  "دسووںں": "دسواں",
  "دسویں": "دسواں",
  "دتے": "دتا",
  "دتا": "دتا",
  "دتو": "دتا",
  "دتوں": "دتا",
  "دو": "دو",
  "دوں": "دینا",
  "دوڑ": "دوڑ",
  "دوڑے": "دوڑنا",
  "دوڑں": "دوڑنا",
  "دوڑا": "دوڑنا",
  "دوڑانے": "دوڑنا",
  "دوڑانا": "دوڑنا",
  "دوڑاتے": "دوڑنا",
  "دوڑاتا": "دوڑنا",
  "دوڑاتی": "دوڑنا",
  "دوڑاتیں": "دوڑنا",
  "دوڑاؤ": "دوڑنا",
  "دوڑاؤں": "دوڑنا",
  "دوڑائے": "دوڑنا",
  "دوڑائی": "دوڑنا",
  "دوڑائیے": "دوڑنا",
  "دوڑائیں": "دوڑنا",
  "دوڑایا": "دوڑنا",
  "دوڑنے": "دوڑنا",
  "دوڑنا": "دوڑنا",
  "دوڑنی": "دوڑنا",
  "دوڑتے": "دوڑنا",
  "دوڑتا": "دوڑنا",
  "دوڑتی": "دوڑنا",
  "دوڑتیں": "دوڑنا",
  "دوڑو": "دوڑ",
  "دوڑوں": "دوڑ",
  "دوڑوا": "دوڑنا",
  "دوڑوانے": "دوڑنا",
  "دوڑوانا": "دوڑنا",
  "دوڑواتے": "دوڑنا",
  "دوڑواتا": "دوڑنا",
  "دوڑواتی": "دوڑنا",
  "دوڑواتیں": "دوڑنا",
  "دوڑواؤ": "دوڑنا",
  "دوڑواؤں": "دوڑنا",
  "دوڑوائے": "دوڑنا",
  "دوڑوائی": "دوڑنا",
  "دوڑوائیے": "دوڑنا",
  "دوڑوائیں": "دوڑنا",
  "دوڑوایا": "دوڑنا",
  "دوڑی": "دوڑنا",
  "دوڑیے": "دوڑنا",
  "دوڑیں": "دوڑ",
  "دوا": "دوا",
  "دوالے": "دوالہ",
  "دوالہ": "دوالہ",
  "دوالو": "دوالہ",
  "دوالوں": "دوالہ",
  "دوات": "دوات",
  "دواتو": "دوات",
  "دواتوں": "دوات",
  "دواتیں": "دوات",
  "دواؤ": "دوا",
  "دواؤں": "دوا",
  "دوائی": "دوائی",
  "دوائیں": "دوا",
  "دوائیاں": "دوائی",
  "دوائیو": "دوائی",
  "دوائیوں": "دوائی",
  "دوہ": "دوہنا",
  "دوہے": "دوہنا",
  "دوہں": "دوہنا",
  "دوہا": "دوہنا",
  "دوہنے": "دوہنا",
  "دوہنا": "دوہنا",
  "دوہنی": "دوہنا",
  "دوہتے": "دوہنا",
  "دوہتا": "دوہنا",
  "دوہتی": "دوہنا",
  "دوہتیں": "دوہنا",
  "دوہو": "دوہنا",
  "دوہوں": "دوہنا",
  "دوہی": "دوہنا",
  "دوہیے": "دوہنا",
  "دوہیں": "دوہنا",
  "دوجے": "دوجہ",
  "دوجہ": "دوجہ",
  "دوجو": "دوجہ",
  "دوجوں": "دوجہ",
  "دوکان": "دوکان",
  "دوکاندار": "دوکاندار",
  "دوکاندارو": "دوکاندار",
  "دوکانداروں": "دوکاندار",
  "دوکانو": "دوکان",
  "دوکانوں": "دوکان",
  "دوکانیں": "دوکان",
  "دولت": "دولت",
  "دولتو": "دولت",
  "دولتوں": "دولت",
  "دولتی": "دولتی",
  "دولتیں": "دولت",
  "دولتیاں": "دولتی",
  "دولتیو": "دولتی",
  "دولتیوں": "دولتی",
  "دونے": "دونا",
  "دونا": "دونا",
  "دونو": "دونا",
  "دونوں": "دونا",
  "دونی": "دونی",
  "دونیاں": "دونی",
  "دونیو": "دونی",
  "دونیوں": "دونی",
  "دوپٹے": "دوپٹا",
  "دوپٹا": "دوپٹا",
  "دوپٹہ": "دوپٹہ",
  "دوپٹو": "دوپٹا",
  "دوپٹوں": "دوپٹا",
  "دوپہر": "دوپہر",
  "دوپہرو": "دوپہر",
  "دوپہروں": "دوپہر",
  "دوپہریں": "دوپہر",
  "دور": "دور",
  "دورے": "دورا",
  "دورا": "دورا",
  "دورانیے": "دورانیہ",
  "دورانیہ": "دورانیہ",
  "دورانیو": "دورانیہ",
  "دورانیوں": "دورانیہ",
  "دورہ": "دورہ",
  "دورو": "دورا",
  "دوروں": "دورا",
  "دوری": "دوری",
  "دوریاں": "دوری",
  "دوریو": "دوری",
  "دوریوں": "دوری",
  "دوسرے": "دوسرا",
  "دوسرا": "دوسرا",
  "دوسرہ": "دوسرہ",
  "دوسرو": "دوسرا",
  "دوسروں": "دوسرا",
  "دوسری": "دُوسْرا",
  "دوست": "دوست",
  "دوستو": "دوست",
  "دوستوں": "دوست",
  "دوستی": "دوستی",
  "دوستیں": "دوست",
  "دوستیاں": "دوستی",
  "دوستیو": "دوستی",
  "دوستیوں": "دوستی",
  "دوزخی": "دوزخی",
  "دوزخیو": "دوزخی",
  "دوزخیوں": "دوزخی",
  "دی": "دینا",
  "دیے": "دیا",
  "دیں": "دینا",
  "دیشی": "دیشی",
  "دیشیاں": "دیشی",
  "دیشیو": "دیشی",
  "دیشیوں": "دیشی",
  "دیا": "دیا",
  "دیباچے": "دیباچہ",
  "دیباچہ": "دیباچہ",
  "دیباچو": "دیباچہ",
  "دیباچوں": "دیباچہ",
  "دید": "دید",
  "دیدے": "دیدہ",
  "دیدہ": "دیدہ",
  "دیدو": "دیدہ",
  "دیدوں": "دیدہ",
  "دیدیں": "دید",
  "دیگ": "دیگ",
  "دیگچی": "دیگچی",
  "دیگچیاں": "دیگچی",
  "دیگچیو": "دیگچی",
  "دیگچیوں": "دیگچی",
  "دیگو": "دیگ",
  "دیگوں": "دیگ",
  "دیگیں": "دیگ",
  "دیہاڑی": "دیہاڑی",
  "دیہاڑیاں": "دیہاڑی",
  "دیہاڑیو": "دیہاڑی",
  "دیہاڑیوں": "دیہاڑی",
  "دیہات": "دیہات",
  "دیہاتو": "دیہات",
  "دیہاتوں": "دیہات",
  "دیہاتی": "دیہاتی",
  "دیہاتیں": "دیہات",
  "دیہاتیو": "دیہاتی",
  "دیہاتیوں": "دیہاتی",
  "دیجی": "دیجی",
  "دیجیاں": "دیجی",
  "دیجیو": "دیجی",
  "دیجیوں": "دیجی",
  "دیکھ": "دیکھ",
  "دیکھْں": "دیکھْنا",
  "دیکھْنے": "دیکھْنا",
  "دیکھْنا": "دیکھْنا",
  "دیکھْنی": "دیکھْنا",
  "دیکھْتے": "دیکھْنا",
  "دیکھْتا": "دیکھْنا",
  "دیکھْتی": "دیکھْنا",
  "دیکھْتیں": "دیکھْنا",
  "دیکھے": "دیکھْنا",
  "دیکھں": "دیکھنا",
  "دیکھا": "دیکھْنا",
  "دیکھنے": "دیکھنا",
  "دیکھنا": "دیکھنا",
  "دیکھنی": "دیکھنا",
  "دیکھتے": "دیکھنا",
  "دیکھتا": "دیکھنا",
  "دیکھتی": "دیکھنا",
  "دیکھتیں": "دیکھنا",
  "دیکھو": "دیکھ",
  "دیکھوں": "دیکھ",
  "دیکھی": "دیکھْنا",
  "دیکھیے": "دیکھْنا",
  "دیکھیں": "دیکھ",
  "دینے": "دینا",
  "دینا": "دینا",
  "دینی": "دینا",
  "دیس": "دیس",
  "دیسو": "دیس",
  "دیسوں": "دیس",
  "دیسی": "دیسی",
  "دیسیں": "دیس",
  "دیسیو": "دیسی",
  "دیسیوں": "دیسی",
  "دیت": "دیت",
  "دیتے": "دینا",
  "دیتا": "دینا",
  "دیتو": "دیت",
  "دیتوں": "دیت",
  "دیتی": "دینا",
  "دیتیں": "دینا",
  "دیو": "دیا",
  "دیوے": "دیوا",
  "دیوں": "دیا",
  "دیوا": "دیوا",
  "دیوان": "دیوان",
  "دیوانے": "دیوانہ",
  "دیوانہ": "دیوانہ",
  "دیوانو": "دیوانہ",
  "دیوانوں": "دیوانہ",
  "دیوار": "دیوار",
  "دیوارو": "دیوار",
  "دیواروں": "دیوار",
  "دیواریں": "دیوار",
  "دیوداسی": "دیوداسی",
  "دیوداسیاں": "دیوداسی",
  "دیوداسیو": "دیوداسی",
  "دیوداسیوں": "دیوداسی",
  "دیوہ": "دیوہ",
  "دیوتا": "دیوتا",
  "دیوتاؤ": "دیوتا",
  "دیوتاؤں": "دیوتا",
  "دیوو": "دیوا",
  "دیووں": "دیوا",
  "دیوی": "دیوی",
  "دیویاں": "دیوی",
  "دیویو": "دیوی",
  "دیویوں": "دیوی",
  "دھڑک": "دھڑکنا",
  "دھڑکے": "دھڑکہ",
  "دھڑکں": "دھڑکنا",
  "دھڑکا": "دھڑکنا",
  "دھڑکانے": "دھڑکنا",
  "دھڑکانا": "دھڑکنا",
  "دھڑکاتے": "دھڑکنا",
  "دھڑکاتا": "دھڑکنا",
  "دھڑکاتی": "دھڑکنا",
  "دھڑکاتیں": "دھڑکنا",
  "دھڑکاؤ": "دھڑکنا",
  "دھڑکاؤں": "دھڑکنا",
  "دھڑکائے": "دھڑکنا",
  "دھڑکائی": "دھڑکنا",
  "دھڑکائیے": "دھڑکنا",
  "دھڑکائیں": "دھڑکنا",
  "دھڑکایا": "دھڑکنا",
  "دھڑکہ": "دھڑکہ",
  "دھڑکن": "دھڑکن",
  "دھڑکنے": "دھڑکنا",
  "دھڑکنا": "دھڑکنا",
  "دھڑکنو": "دھڑکن",
  "دھڑکنوں": "دھڑکن",
  "دھڑکنی": "دھڑکنا",
  "دھڑکنیں": "دھڑکن",
  "دھڑکتے": "دھڑکنا",
  "دھڑکتا": "دھڑکنا",
  "دھڑکتی": "دھڑکنا",
  "دھڑکتیں": "دھڑکنا",
  "دھڑکو": "دھڑکہ",
  "دھڑکوں": "دھڑکہ",
  "دھڑکوا": "دھڑکنا",
  "دھڑکوانے": "دھڑکنا",
  "دھڑکوانا": "دھڑکنا",
  "دھڑکواتے": "دھڑکنا",
  "دھڑکواتا": "دھڑکنا",
  "دھڑکواتی": "دھڑکنا",
  "دھڑکواتیں": "دھڑکنا",
  "دھڑکواؤ": "دھڑکنا",
  "دھڑکواؤں": "دھڑکنا",
  "دھڑکوائے": "دھڑکنا",
  "دھڑکوائی": "دھڑکنا",
  "دھڑکوائیے": "دھڑکنا",
  "دھڑکوائیں": "دھڑکنا",
  "دھڑکوایا": "دھڑکنا",
  "دھڑکی": "دھڑکنا",
  "دھڑکیے": "دھڑکنا",
  "دھڑکیں": "دھڑکنا",
  "دھاڑ": "دھاڑ",
  "دھاڑے": "دھاڑنا",
  "دھاڑں": "دھاڑنا",
  "دھاڑا": "دھاڑنا",
  "دھاڑنے": "دھاڑنا",
  "دھاڑنا": "دھاڑنا",
  "دھاڑنی": "دھاڑنا",
  "دھاڑتے": "دھاڑنا",
  "دھاڑتا": "دھاڑنا",
  "دھاڑتی": "دھاڑنا",
  "دھاڑتیں": "دھاڑنا",
  "دھاڑو": "دھاڑ",
  "دھاڑوں": "دھاڑ",
  "دھاڑی": "دھاڑنا",
  "دھاڑیے": "دھاڑنا",
  "دھاڑیں": "دھاڑ",
  "دھاگے": "دھاگا",
  "دھاگا": "دھاگا",
  "دھاگہ": "دھاگہ",
  "دھاگو": "دھاگا",
  "دھاگوں": "دھاگا",
  "دھانے": "دھانہ",
  "دھانہ": "دھانہ",
  "دھانو": "دھانہ",
  "دھانوں": "دھانہ",
  "دھانی": "دھانی",
  "دھانیاں": "دھانی",
  "دھانیو": "دھانی",
  "دھانیوں": "دھانی",
  "دھار": "دھار",
  "دھارے": "دھارا",
  "دھارں": "دھارنا",
  "دھارا": "دھارا",
  "دھارنے": "دھارنا",
  "دھارنا": "دھارنا",
  "دھارنی": "دھارنا",
  "دھارتے": "دھارنا",
  "دھارتا": "دھارنا",
  "دھارتی": "دھارنا",
  "دھارتیں": "دھارنا",
  "دھارو": "دھارا",
  "دھاروں": "دھارا",
  "دھاری": "دھاری",
  "دھاریے": "دھارنا",
  "دھاریں": "دھار",
  "دھاریاں": "دھاری",
  "دھاریو": "دھاری",
  "دھاریوں": "دھاری",
  "دھات": "دھات",
  "دھاتو": "دھات",
  "دھاتوں": "دھات",
  "دھاتیں": "دھات",
  "دھبے": "دھبہ",
  "دھبہ": "دھبہ",
  "دھبو": "دھبہ",
  "دھبوں": "دھبہ",
  "دھک": "دھک",
  "دھکے": "دھکا",
  "دھکں": "دھکنا",
  "دھکا": "دھکا",
  "دھکنے": "دھکنا",
  "دھکنا": "دھکنا",
  "دھکنی": "دھکنا",
  "دھکتے": "دھکنا",
  "دھکتا": "دھکنا",
  "دھکتی": "دھکنا",
  "دھکتیں": "دھکنا",
  "دھکو": "دھکا",
  "دھکوں": "دھکا",
  "دھکی": "دھکنا",
  "دھکیے": "دھکنا",
  "دھکیں": "دھک",
  "دھکیل": "دھکیلنا",
  "دھکیلے": "دھکیلنا",
  "دھکیلں": "دھکیلنا",
  "دھکیلا": "دھکیلنا",
  "دھکیلنے": "دھکیلنا",
  "دھکیلنا": "دھکیلنا",
  "دھکیلنی": "دھکیلنا",
  "دھکیلتے": "دھکیلنا",
  "دھکیلتا": "دھکیلنا",
  "دھکیلتی": "دھکیلنا",
  "دھکیلتیں": "دھکیلنا",
  "دھکیلو": "دھکیلنا",
  "دھکیلوں": "دھکیلنا",
  "دھکیلی": "دھکیلنا",
  "دھکیلیے": "دھکیلنا",
  "دھکیلیں": "دھکیلنا",
  "دھماکے": "دھماکا",
  "دھماکا": "دھماکا",
  "دھماکہ": "دھماکہ",
  "دھماکو": "دھماکا",
  "دھماکوں": "دھماکا",
  "دھمک": "دھمکنا",
  "دھمکے": "دھمکنا",
  "دھمکں": "دھمکنا",
  "دھمکا": "دھمکنا",
  "دھمکانے": "دھمکنا",
  "دھمکانا": "دھمکنا",
  "دھمکاتے": "دھمکنا",
  "دھمکاتا": "دھمکنا",
  "دھمکاتی": "دھمکنا",
  "دھمکاتیں": "دھمکنا",
  "دھمکاؤ": "دھمکنا",
  "دھمکاؤں": "دھمکنا",
  "دھمکائے": "دھمکنا",
  "دھمکائی": "دھمکنا",
  "دھمکائیے": "دھمکنا",
  "دھمکائیں": "دھمکنا",
  "دھمکایا": "دھمکنا",
  "دھمکنے": "دھمکنا",
  "دھمکنا": "دھمکنا",
  "دھمکنی": "دھمکنا",
  "دھمکتے": "دھمکنا",
  "دھمکتا": "دھمکنا",
  "دھمکتی": "دھمکنا",
  "دھمکتیں": "دھمکنا",
  "دھمکو": "دھمکنا",
  "دھمکوں": "دھمکنا",
  "دھمکوا": "دھمکنا",
  "دھمکوانے": "دھمکنا",
  "دھمکوانا": "دھمکنا",
  "دھمکواتے": "دھمکنا",
  "دھمکواتا": "دھمکنا",
  "دھمکواتی": "دھمکنا",
  "دھمکواتیں": "دھمکنا",
  "دھمکواؤ": "دھمکنا",
  "دھمکواؤں": "دھمکنا",
  "دھمکوائے": "دھمکنا",
  "دھمکوائی": "دھمکنا",
  "دھمکوائیے": "دھمکنا",
  "دھمکوائیں": "دھمکنا",
  "دھمکوایا": "دھمکنا",
  "دھمکی": "دھمکی",
  "دھمکیے": "دھمکنا",
  "دھمکیں": "دھمکنا",
  "دھمکیاں": "دھمکی",
  "دھمکیو": "دھمکی",
  "دھمکیوں": "دھمکی",
  "دھن": "دھن",
  "دھنے": "دھننا",
  "دھنں": "دھننا",
  "دھنا": "دھننا",
  "دھنانے": "دھننا",
  "دھنانا": "دھننا",
  "دھناتے": "دھننا",
  "دھناتا": "دھننا",
  "دھناتی": "دھننا",
  "دھناتیں": "دھننا",
  "دھناؤ": "دھننا",
  "دھناؤں": "دھننا",
  "دھنائے": "دھننا",
  "دھنائی": "دھننا",
  "دھنائیے": "دھننا",
  "دھنائیں": "دھننا",
  "دھنایا": "دھننا",
  "دھند": "دھند",
  "دھندے": "دھندا",
  "دھندا": "دھندا",
  "دھندہ": "دھندہ",
  "دھندو": "دھندا",
  "دھندوں": "دھندا",
  "دھننے": "دھننا",
  "دھننا": "دھننا",
  "دھننی": "دھننا",
  "دھنس": "دھنسنا",
  "دھنسے": "دھنسنا",
  "دھنسں": "دھنسنا",
  "دھنسا": "دھنسنا",
  "دھنسانے": "دھنسنا",
  "دھنسانا": "دھنسنا",
  "دھنساتے": "دھنسنا",
  "دھنساتا": "دھنسنا",
  "دھنساتی": "دھنسنا",
  "دھنساتیں": "دھنسنا",
  "دھنساؤ": "دھنسنا",
  "دھنساؤں": "دھنسنا",
  "دھنسائے": "دھنسنا",
  "دھنسائی": "دھنسنا",
  "دھنسائیے": "دھنسنا",
  "دھنسائیں": "دھنسنا",
  "دھنسایا": "دھنسنا",
  "دھنسنے": "دھنسنا",
  "دھنسنا": "دھنسنا",
  "دھنسنی": "دھنسنا",
  "دھنستے": "دھنسنا",
  "دھنستا": "دھنسنا",
  "دھنستی": "دھنسنا",
  "دھنستیں": "دھنسنا",
  "دھنسو": "دھنسنا",
  "دھنسوں": "دھنسنا",
  "دھنسوا": "دھنسنا",
  "دھنسوانے": "دھنسنا",
  "دھنسوانا": "دھنسنا",
  "دھنسواتے": "دھنسنا",
  "دھنسواتا": "دھنسنا",
  "دھنسواتی": "دھنسنا",
  "دھنسواتیں": "دھنسنا",
  "دھنسواؤ": "دھنسنا",
  "دھنسواؤں": "دھنسنا",
  "دھنسوائے": "دھنسنا",
  "دھنسوائی": "دھنسنا",
  "دھنسوائیے": "دھنسنا",
  "دھنسوائیں": "دھنسنا",
  "دھنسوایا": "دھنسنا",
  "دھنسی": "دھنسنا",
  "دھنسیے": "دھنسنا",
  "دھنسیں": "دھنسنا",
  "دھنتے": "دھننا",
  "دھنتا": "دھننا",
  "دھنتی": "دھننا",
  "دھنتیں": "دھننا",
  "دھنو": "دھن",
  "دھنوں": "دھن",
  "دھنوا": "دھننا",
  "دھنوانے": "دھننا",
  "دھنوانا": "دھننا",
  "دھنواتے": "دھننا",
  "دھنواتا": "دھننا",
  "دھنواتی": "دھننا",
  "دھنواتیں": "دھننا",
  "دھنواؤ": "دھننا",
  "دھنواؤں": "دھننا",
  "دھنوائے": "دھننا",
  "دھنوائی": "دھننا",
  "دھنوائیے": "دھننا",
  "دھنوائیں": "دھننا",
  "دھنوایا": "دھننا",
  "دھنی": "دھننا",
  "دھنیے": "دھنیہ",
  "دھنیں": "دھننا",
  "دھنیہ": "دھنیہ",
  "دھنیو": "دھنیہ",
  "دھنیوں": "دھنیہ",
  "دھر": "دھرنا",
  "دھرے": "دھرنا",
  "دھرں": "دھرنا",
  "دھرا": "دھرنا",
  "دھرانے": "دھرنا",
  "دھرانا": "دھرنا",
  "دھراتے": "دھرنا",
  "دھراتا": "دھرنا",
  "دھراتی": "دھرنا",
  "دھراتیں": "دھرنا",
  "دھراؤ": "دھرنا",
  "دھراؤں": "دھرنا",
  "دھرائے": "دھرنا",
  "دھرائی": "دھرنا",
  "دھرائیے": "دھرنا",
  "دھرائیں": "دھرنا",
  "دھرایا": "دھرنا",
  "دھرنے": "دھرنا",
  "دھرنا": "دھرنا",
  "دھرنی": "دھرنا",
  "دھرتے": "دھرنا",
  "دھرتا": "دھرنا",
  "دھرتی": "دھرنا",
  "دھرتیں": "دھرنا",
  "دھرو": "دھرنا",
  "دھروں": "دھرنا",
  "دھروا": "دھرنا",
  "دھروانے": "دھرنا",
  "دھروانا": "دھرنا",
  "دھرواتے": "دھرنا",
  "دھرواتا": "دھرنا",
  "دھرواتی": "دھرنا",
  "دھرواتیں": "دھرنا",
  "دھرواؤ": "دھرنا",
  "دھرواؤں": "دھرنا",
  "دھروائے": "دھرنا",
  "دھروائی": "دھرنا",
  "دھروائیے": "دھرنا",
  "دھروائیں": "دھرنا",
  "دھروایا": "دھرنا",
  "دھری": "دھرنا",
  "دھریے": "دھرنا",
  "دھریں": "دھرنا",
  "دھتکار": "دھتکارنا",
  "دھتکارے": "دھتکارنا",
  "دھتکارں": "دھتکارنا",
  "دھتکارا": "دھتکارنا",
  "دھتکارنے": "دھتکارنا",
  "دھتکارنا": "دھتکارنا",
  "دھتکارنی": "دھتکارنا",
  "دھتکارتے": "دھتکارنا",
  "دھتکارتا": "دھتکارنا",
  "دھتکارتی": "دھتکارنا",
  "دھتکارتیں": "دھتکارنا",
  "دھتکارو": "دھتکارنا",
  "دھتکاروں": "دھتکارنا",
  "دھتکاری": "دھتکارنا",
  "دھتکاریے": "دھتکارنا",
  "دھتکاریں": "دھتکارنا",
  "دھو": "دھونا",
  "دھواں": "دھواں",
  "دھوکے": "دھوکہ",
  "دھوکہ": "دھوکہ",
  "دھوکو": "دھوکہ",
  "دھوکوں": "دھوکہ",
  "دھونے": "دھونا",
  "دھونا": "دھونا",
  "دھونی": "دھونا",
  "دھوتے": "دھونا",
  "دھوتا": "دھونا",
  "دھوتی": "دھوتی",
  "دھوتیں": "دھونا",
  "دھوتیاں": "دھوتی",
  "دھوتیو": "دھوتی",
  "دھوتیوں": "دھوتی",
  "دھووںں": "دھواں",
  "دھوؤ": "دھونا",
  "دھوؤں": "دھونا",
  "دھویں": "دھواں",
  "دھوئے": "دھونا",
  "دھوئی": "دھونا",
  "دھوئیے": "دھونا",
  "دھوئیں": "دھونا",
  "دھویا": "دھونا",
  "عِنایَت": "عِنایَت",
  "عِنایَتو": "عِنایَت",
  "عِنایَتوں": "عِنایَت",
  "عِنایَتیں": "عِنایَت",
  "عِید": "عِید",
  "عِیدو": "عِید",
  "عِیدوں": "عِید",
  "عِیدیں": "عِید",
  "عُمر": "عُمر",
  "عُمرو": "عُمر",
  "عُمروں": "عُمر",
  "عُمریں": "عُمر",
  "عصمت": "عصمت",
  "عصمتو": "عصمت",
  "عصمتوں": "عصمت",
  "عصمتیں": "عصمت",
  "عصر": "عصر",
  "عصرو": "عصر",
  "عصروں": "عصر",
  "عشر": "عشر",
  "عشرے": "عشرہ",
  "عشرہ": "عشرہ",
  "عشرو": "عشرہ",
  "عشروں": "عشرہ",
  "عذاب": "عذاب",
  "عذابو": "عذاب",
  "عذابوں": "عذاب",
  "عاصی": "عاصی",
  "عاصیو": "عاصی",
  "عاصیوں": "عاصی",
  "عاشق": "عاشق",
  "عاشقو": "عاشق",
  "عاشقوں": "عاشق",
  "عاشورے": "عاشورہ",
  "عاشورہ": "عاشورہ",
  "عاشورو": "عاشورہ",
  "عاشوروں": "عاشورہ",
  "عادت": "عادت",
  "عادتو": "عادت",
  "عادتوں": "عادت",
  "عادتیں": "عادت",
  "عاجز": "عاجز",
  "عاجزو": "عاجز",
  "عاجزوں": "عاجز",
  "عالم": "عالم",
  "عالمو": "عالم",
  "عالموں": "عالم",
  "عارف": "عارف",
  "عارفہ": "عارفہ",
  "عارفو": "عارف",
  "عارفوں": "عارف",
  "عارض": "عارض",
  "عارضے": "عارضہ",
  "عارضہ": "عارضہ",
  "عارضو": "عارضہ",
  "عارضوں": "عارضہ",
  "عبادت": "عبادت",
  "عبادتو": "عبادت",
  "عبادتوں": "عبادت",
  "عبادتیں": "عبادت",
  "عدالت": "عدالت",
  "عدالتو": "عدالت",
  "عدالتوں": "عدالت",
  "عدالتیں": "عدالت",
  "عداوت": "عداوت",
  "عداوتو": "عداوت",
  "عداوتوں": "عداوت",
  "عداوتیں": "عداوت",
  "عہد": "عہد",
  "عہدے": "عہدہ",
  "عہدہ": "عہدہ",
  "عہدو": "عہدہ",
  "عہدوں": "عہدہ",
  "عہدیدار": "عہدیدار",
  "عہدیدارو": "عہدیدار",
  "عہدیداروں": "عہدیدار",
  "عجمی": "عجمی",
  "عجمیو": "عجمی",
  "عجمیوں": "عجمی",
  "عجز": "عجز",
  "عجزو": "عجز",
  "عجزوں": "عجز",
  "علامت": "علامت",
  "علامتو": "علامت",
  "علامتوں": "علامت",
  "علامتیں": "علامت",
  "علاقے": "علاقہ",
  "علاقائی": "علاقائی",
  "علاقائیو": "علاقائی",
  "علاقائیوں": "علاقائی",
  "علاقہ": "علاقہ",
  "علاقو": "علاقہ",
  "علاقوں": "علاقہ",
  "علاوہ": "علاوہ",
  "علم": "علم",
  "علمبردار": "علمبردار",
  "علمبردارو": "علمبردار",
  "علمبرداروں": "علمبردار",
  "علمو": "علم",
  "علموں": "علم",
  "علت": "علت",
  "علتو": "علت",
  "علتوں": "علت",
  "علتیں": "علت",
  "عمامے": "عمامہ",
  "عمامہ": "عمامہ",
  "عمامو": "عمامہ",
  "عماموں": "عمامہ",
  "عمارت": "عمارت",
  "عمارتو": "عمارت",
  "عمارتوں": "عمارت",
  "عمارتیں": "عمارت",
  "عمل": "عمل",
  "عملے": "عملہ",
  "عملہ": "عملہ",
  "عملو": "عملہ",
  "عملوں": "عملہ",
  "عمر": "عمر",
  "عمرے": "عمرا",
  "عمرا": "عمرا",
  "عمرہ": "عمرہ",
  "عمرو": "عمرا",
  "عمروں": "عمرا",
  "عمریں": "عمر",
  "عنوان": "عنوان",
  "عنوانات": "عنوان",
  "عنوانو": "عنوان",
  "عنوانوں": "عنوان",
  "عقاب": "عقاب",
  "عقابو": "عقاب",
  "عقابوں": "عقاب",
  "عقل": "عقل",
  "عقلمند": "عقلمند",
  "عقلمندو": "عقلمند",
  "عقلمندوں": "عقلمند",
  "عقلو": "عقل",
  "عقلوں": "عقل",
  "عقلیں": "عقل",
  "عقیدے": "عقیدہ",
  "عقیدہ": "عقیدہ",
  "عقیدت": "عقیدت",
  "عقیدتو": "عقیدت",
  "عقیدتوں": "عقیدت",
  "عقیدتیں": "عقیدت",
  "عقیدو": "عقیدہ",
  "عقیدوں": "عقیدہ",
  "عرصے": "عرصہ",
  "عرصہ": "عرصہ",
  "عرصو": "عرصہ",
  "عرصوں": "عرصہ",
  "عرشی": "عرشی",
  "عرشیو": "عرشی",
  "عرشیوں": "عرشی",
  "عراقی": "عراقی",
  "عراقیو": "عراقی",
  "عراقیوں": "عراقی",
  "عرب": "عرب",
  "عربو": "عرب",
  "عربوں": "عرب",
  "عرضی": "عرضی",
  "عرضیاں": "عرضی",
  "عرضیو": "عرضی",
  "عرضیوں": "عرضی",
  "عسائی": "عسائی",
  "عسائیو": "عسائی",
  "عسائیوں": "عسائی",
  "عورت": "عورت",
  "عورتو": "عورت",
  "عورتوں": "عورت",
  "عورتیں": "عورت",
  "عیاشی": "عیاشی",
  "عیاشیاں": "عیاشی",
  "عیاشیو": "عیاشی",
  "عیاشیوں": "عیاشی",
  "عیب": "عیب",
  "عیبو": "عیب",
  "عیبوں": "عیب",
  "عید": "عید",
  "عیدو": "عید",
  "عیدوں": "عید",
  "عیدیں": "عید",
  "عینک": "عینک",
  "عینکو": "عینک",
  "عینکوں": "عینک",
  "عینکیں": "عینک",
  "عیسائی": "عیسائی",
  "عیسائیو": "عیسائی",
  "عیسائیوں": "عیسائی",
  "عزت": "عزت",
  "عزتو": "عزت",
  "عزتوں": "عزت",
  "عزتیں": "عزت",
  "عزیز": "عزیز",
  "عزیزے": "عزیزہ",
  "عزیزہ": "عزیزہ",
  "عزیزو": "عزیزہ",
  "عزیزوں": "عزیزہ",
  "عطا": "عطا",
  "عطاؤ": "عطا",
  "عطاؤں": "عطا",
  "عطائیں": "عطا",
  "عظمت": "عظمت",
  "عظمتو": "عظمت",
  "عظمتوں": "عظمت",
  "عظمتیں": "عظمت",
  "فُلاں": "فُلاں",
  "فُلانی": "فُلاں",
  "فخر": "فخر",
  "فخرو": "فخر",
  "فخروں": "فخر",
  "فصل": "فصل",
  "فصلے": "فصلہ",
  "فصلہ": "فصلہ",
  "فصلو": "فصلہ",
  "فصلوں": "فصلہ",
  "فصلیں": "فصل",
  "فصیل": "فصیل",
  "فصیلو": "فصیل",
  "فصیلوں": "فصیل",
  "فصیلیں": "فصیل",
  "فاصل": "فاصل",
  "فاصلے": "فاصلہ",
  "فاصلہ": "فاصلہ",
  "فاصلو": "فاصلہ",
  "فاصلوں": "فاصلہ",
  "فالسے": "فالسہ",
  "فالسہ": "فالسہ",
  "فالسو": "فالسہ",
  "فالسوں": "فالسہ",
  "فالودے": "فالودہ",
  "فالودہ": "فالودہ",
  "فالودو": "فالودہ",
  "فالودوں": "فالودہ",
  "فاقے": "فاقہ",
  "فاقہ": "فاقہ",
  "فاقو": "فاقہ",
  "فاقوں": "فاقہ",
  "فارمولے": "فارمولا",
  "فارمولا": "فارمولا",
  "فارمولو": "فارمولا",
  "فارمولوں": "فارمولا",
  "فاسق": "فاسق",
  "فاسقو": "فاسق",
  "فاسقوں": "فاسق",
  "فائدے": "فائدہ",
  "فائدہ": "فائدہ",
  "فائدو": "فائدہ",
  "فائدوں": "فائدہ",
  "فائل": "فائل",
  "فائلو": "فائل",
  "فائلوں": "فائل",
  "فائلیں": "فائل",
  "فہمی": "فہمی",
  "فہمیاں": "فہمی",
  "فہمیو": "فہمی",
  "فہمیوں": "فہمی",
  "فہرست": "فہرست",
  "فہرستو": "فہرست",
  "فہرستوں": "فہرست",
  "فہرستیں": "فہرست",
  "فکر": "فکر",
  "فکرو": "فکر",
  "فکروں": "فکر",
  "فکریں": "فکر",
  "فلاں": "فُلاں",
  "فلانی": "فُلاں",
  "فلم": "فلم",
  "فلمو": "فلم",
  "فلموں": "فلم",
  "فلمیں": "فلم",
  "فلسفے": "فلسفہ",
  "فلسفہ": "فلسفہ",
  "فلسفو": "فلسفہ",
  "فلسفوں": "فلسفہ",
  "فلسفی": "فلسفی",
  "فلسفیو": "فلسفی",
  "فلسفیوں": "فلسفی",
  "فلیٹ": "فلیٹ",
  "فلیٹو": "فلیٹ",
  "فلیٹوں": "فلیٹ",
  "فلیٹیں": "فلیٹ",
  "فنکار": "فنکار",
  "فنکارو": "فنکار",
  "فنکاروں": "فنکار",
  "فقر": "فقر",
  "فقرے": "فقرہ",
  "فقرہ": "فقرہ",
  "فقرو": "فقرہ",
  "فقروں": "فقرہ",
  "فقریں": "فقر",
  "فقیر": "فقیر",
  "فقیرنی": "فقیرنی",
  "فقیرنیاں": "فقیرنی",
  "فقیرنیو": "فقیرنی",
  "فقیرنیوں": "فقیرنی",
  "فقیرو": "فقیر",
  "فقیروں": "فقیر",
  "فقیریں": "فقیر",
  "فرصت": "فرصت",
  "فرصتو": "فرصت",
  "فرصتوں": "فرصت",
  "فرصتیں": "فرصت",
  "فرش": "فرش",
  "فرشت": "فرشت",
  "فرشتے": "فرشتہ",
  "فرشتہ": "فرشتہ",
  "فرشتو": "فرشتہ",
  "فرشتوں": "فرشتہ",
  "فرشتیں": "فرشت",
  "فرشو": "فرش",
  "فرشوں": "فرش",
  "فراک": "فراک",
  "فراکو": "فراک",
  "فراکوں": "فراک",
  "فراکیں": "فراک",
  "فرد": "فرد",
  "فردے": "فردہ",
  "فردہ": "فردہ",
  "فردو": "فردہ",
  "فردوں": "فردہ",
  "فرعونی": "فرعونی",
  "فرعونیو": "فرعونی",
  "فرعونیوں": "فرعونی",
  "فرما": "فرمانا",
  "فرمانے": "فرمانا",
  "فرمانا": "فرمانا",
  "فرمانبردار": "فرمانبردار",
  "فرمانبردارو": "فرمانبردار",
  "فرمانبرداروں": "فرمانبردار",
  "فرمانی": "فرمانا",
  "فرماتے": "فرمانا",
  "فرماتا": "فرمانا",
  "فرماتی": "فرمانا",
  "فرماتیں": "فرمانا",
  "فرماؤ": "فرمانا",
  "فرماؤں": "فرمانا",
  "فرمائے": "فرمانا",
  "فرمائش": "فرمائش",
  "فرمائشو": "فرمائش",
  "فرمائشوں": "فرمائش",
  "فرمائشیں": "فرمائش",
  "فرمائی": "فرمانا",
  "فرمائیے": "فرمانا",
  "فرمائیں": "فرمانا",
  "فرمایا": "فرمانا",
  "فرنگ": "فرنگ",
  "فرنگو": "فرنگ",
  "فرنگوں": "فرنگ",
  "فرقے": "فرقہ",
  "فرقہ": "فرقہ",
  "فرقو": "فرقہ",
  "فرقوں": "فرقہ",
  "فروش": "فروش",
  "فروشو": "فروش",
  "فروشوں": "فروش",
  "فریب": "فریب",
  "فریبو": "فریب",
  "فریبوں": "فریب",
  "فریق": "فریق",
  "فریقو": "فریق",
  "فریقوں": "فریق",
  "فریضے": "فریضہ",
  "فریضہ": "فریضہ",
  "فریضو": "فریضہ",
  "فریضوں": "فریضہ",
  "فرزانے": "فرزانہ",
  "فرزانہ": "فرزانہ",
  "فرزانو": "فرزانہ",
  "فرزانوں": "فرزانہ",
  "فرزند": "فرزند",
  "فرزندو": "فرزند",
  "فرزندوں": "فرزند",
  "فرض": "فرض",
  "فرضے": "فرضہ",
  "فرضہ": "فرضہ",
  "فرضو": "فرضہ",
  "فرضوں": "فرضہ",
  "فسانے": "فسانہ",
  "فسانہ": "فسانہ",
  "فسانو": "فسانہ",
  "فسانوں": "فسانہ",
  "فتنے": "فتنہ",
  "فتنہ": "فتنہ",
  "فتنو": "فتنہ",
  "فتنوں": "فتنہ",
  "فتوے": "فتوہ",
  "فتوہ": "فتوہ",
  "فتوو": "فتوہ",
  "فتووں": "فتوہ",
  "فوارے": "فوارہ",
  "فوارہ": "فوارہ",
  "فوارو": "فوارہ",
  "فواروں": "فوارہ",
  "فوج": "فوج",
  "فوجو": "فوج",
  "فوجوں": "فوج",
  "فوجی": "فوجی",
  "فوجیں": "فوج",
  "فوجیو": "فوجی",
  "فوجیوں": "فوجی",
  "فون": "فون",
  "فونو": "فون",
  "فونوں": "فون",
  "فیصل": "فیصل",
  "فیصلے": "فیصلہ",
  "فیصلہ": "فیصلہ",
  "فیصلو": "فیصلہ",
  "فیصلوں": "فیصلہ",
  "فیچر": "فیچر",
  "فیچرو": "فیچر",
  "فیچروں": "فیچر",
  "فیکٹری": "فیکٹری",
  "فیکٹریاں": "فیکٹری",
  "فیکٹریو": "فیکٹری",
  "فیکٹریوں": "فیکٹری",
  "فیروزے": "فیروزہ",
  "فیروزہ": "فیروزہ",
  "فیروزو": "فیروزہ",
  "فیروزوں": "فیروزہ",
  "فیتے": "فیتہ",
  "فیتہ": "فیتہ",
  "فیتو": "فیتہ",
  "فیتوں": "فیتہ",
  "فیض": "فیض",
  "فیضو": "فیض",
  "فیضوں": "فیض",
  "فضا": "فضا",
  "فضاؤ": "فضا",
  "فضاؤں": "فضا",
  "فضائیں": "فضا",
  "فضلے": "فضلہ",
  "فضلہ": "فضلہ",
  "فضلو": "فضلہ",
  "فضلوں": "فضلہ",
  "فضیحت": "فضیحت",
  "فضیحتو": "فضیحت",
  "فضیحتوں": "فضیحت",
  "فضیحتیں": "فضیحت",
  "گَھٹا": "گَھٹا",
  "گَھٹاؤ": "گَھٹا",
  "گَھٹاؤں": "گَھٹا",
  "گَھٹائیں": "گَھٹا",
  "گَھبْرا": "گَھبْرانا",
  "گَھبْرانے": "گَھبْرانا",
  "گَھبْرانا": "گَھبْرانا",
  "گَھبْرانی": "گَھبْرانا",
  "گَھبْراتے": "گَھبْرانا",
  "گَھبْراتا": "گَھبْرانا",
  "گَھبْراتی": "گَھبْرانا",
  "گَھبْراتیں": "گَھبْرانا",
  "گَھبْراؤ": "گَھبْرانا",
  "گَھبْراؤں": "گَھبْرانا",
  "گَھبْرائے": "گَھبْرانا",
  "گَھبْرائی": "گَھبْرانا",
  "گَھبْرائیے": "گَھبْرانا",
  "گَھبْرائیں": "گَھبْرانا",
  "گَھبْرایا": "گَھبْرانا",
  "گَھر": "گَھر",
  "گَھرو": "گَھر",
  "گَھروں": "گَھر",
  "گ(اo)زر": "گُزرنا",
  "گ(اo)زرے": "گُزرنا",
  "گ(اo)زرں": "گُزرنا",
  "گ(اo)زرا": "گُزرنا",
  "گ(اo)زرنے": "گُزرنا",
  "گ(اo)زرنا": "گُزرنا",
  "گ(اo)زرتے": "گُزرنا",
  "گ(اo)زرتا": "گُزرنا",
  "گ(اo)زرتی": "گُزرنا",
  "گ(اo)زرتیں": "گُزرنا",
  "گ(اo)زرو": "گُزرنا",
  "گ(اo)زروں": "گُزرنا",
  "گ(اo)زری": "گُزرنا",
  "گ(اo)زریے": "گُزرنا",
  "گ(اo)زریں": "گُزرنا",
  "گِڑگڑا": "گِڑگڑانا",
  "گِڑگڑانے": "گِڑگڑانا",
  "گِڑگڑانا": "گِڑگڑانا",
  "گِڑگڑانی": "گِڑگڑانا",
  "گِڑگڑاتے": "گِڑگڑانا",
  "گِڑگڑاتا": "گِڑگڑانا",
  "گِڑگڑاتی": "گِڑگڑانا",
  "گِڑگڑاتیں": "گِڑگڑانا",
  "گِڑگڑاؤ": "گِڑگڑانا",
  "گِڑگڑاؤں": "گِڑگڑانا",
  "گِڑگڑائے": "گِڑگڑانا",
  "گِڑگڑائی": "گِڑگڑانا",
  "گِڑگڑائیے": "گِڑگڑانا",
  "گِڑگڑائیں": "گِڑگڑانا",
  "گِڑگڑایا": "گِڑگڑانا",
  "گِر": "گِرنا",
  "گِرے": "گِرہ",
  "گِرں": "گِرنا",
  "گِرا": "گِرنا",
  "گِرانے": "گِرنا",
  "گِرانا": "گِرنا",
  "گِراتے": "گِرنا",
  "گِراتا": "گِرنا",
  "گِراتی": "گِرنا",
  "گِراتیں": "گِرنا",
  "گِراؤ": "گِرنا",
  "گِراؤں": "گِرنا",
  "گِرائے": "گِرنا",
  "گِرائی": "گِرنا",
  "گِرائیے": "گِرنا",
  "گِرائیں": "گِرنا",
  "گِرایا": "گِرنا",
  "گِرہ": "گِرہ",
  "گِرنے": "گِرنا",
  "گِرنا": "گِرنا",
  "گِرنی": "گِرنا",
  "گِرتے": "گِرنا",
  "گِرتا": "گِرنا",
  "گِرتی": "گِرنا",
  "گِرتیں": "گِرنا",
  "گِرو": "گِرہ",
  "گِروں": "گِرہ",
  "گِروا": "گِرنا",
  "گِروانے": "گِرنا",
  "گِروانا": "گِرنا",
  "گِرواتے": "گِرنا",
  "گِرواتا": "گِرنا",
  "گِرواتی": "گِرنا",
  "گِرواتیں": "گِرنا",
  "گِرواؤ": "گِرنا",
  "گِرواؤں": "گِرنا",
  "گِروائے": "گِرنا",
  "گِروائی": "گِرنا",
  "گِروائیے": "گِرنا",
  "گِروائیں": "گِرنا",
  "گِروایا": "گِرنا",
  "گِری": "گِرنا",
  "گِریے": "گِرنا",
  "گِریں": "گِرنا",
  "گِھر": "گِھرْنا",
  "گِھرْں": "گِھرْنا",
  "گِھرْنے": "گِھرْنا",
  "گِھرْنا": "گِھرْنا",
  "گِھرْنی": "گِھرْنا",
  "گِھرْتے": "گِھرْنا",
  "گِھرْتا": "گِھرْنا",
  "گِھرْتی": "گِھرْنا",
  "گِھرْتیں": "گِھرْنا",
  "گِھرْوا": "گِھرْنا",
  "گِھرْوانے": "گِھرْنا",
  "گِھرْوانا": "گِھرْنا",
  "گِھرْواتے": "گِھرْنا",
  "گِھرْواتا": "گِھرْنا",
  "گِھرْواتی": "گِھرْنا",
  "گِھرْواتیں": "گِھرْنا",
  "گِھرْواؤ": "گِھرْنا",
  "گِھرْواؤں": "گِھرْنا",
  "گِھرْوائے": "گِھرْنا",
  "گِھرْوائی": "گِھرْنا",
  "گِھرْوائیے": "گِھرْنا",
  "گِھرْوائیں": "گِھرْنا",
  "گِھرْوایا": "گِھرْنا",
  "گِھرے": "گِھرْنا",
  "گِھرا": "گِھرْنا",
  "گِھرو": "گِھرْنا",
  "گِھروں": "گِھرْنا",
  "گِھری": "گِھرْنا",
  "گِھریے": "گِھرْنا",
  "گِھریں": "گِھرْنا",
  "گِھس": "گِھسْنا",
  "گِھسْں": "گِھسْنا",
  "گِھسْنے": "گِھسْنا",
  "گِھسْنا": "گِھسْنا",
  "گِھسْنی": "گِھسْنا",
  "گِھسْتے": "گِھسْنا",
  "گِھسْتا": "گِھسْنا",
  "گِھسْتی": "گِھسْنا",
  "گِھسْتیں": "گِھسْنا",
  "گِھسْوا": "گِھسْنا",
  "گِھسْوانے": "گِھسْنا",
  "گِھسْوانا": "گِھسْنا",
  "گِھسْواتے": "گِھسْنا",
  "گِھسْواتا": "گِھسْنا",
  "گِھسْواتی": "گِھسْنا",
  "گِھسْواتیں": "گِھسْنا",
  "گِھسْواؤ": "گِھسْنا",
  "گِھسْواؤں": "گِھسْنا",
  "گِھسْوائے": "گِھسْنا",
  "گِھسْوائی": "گِھسْنا",
  "گِھسْوائیے": "گِھسْنا",
  "گِھسْوائیں": "گِھسْنا",
  "گِھسْوایا": "گِھسْنا",
  "گِھسے": "گِھسْنا",
  "گِھسں": "گِھسنا",
  "گِھسا": "گِھسْنا",
  "گِھسانے": "گِھسْنا",
  "گِھسانا": "گِھسْنا",
  "گِھساتے": "گِھسْنا",
  "گِھساتا": "گِھسْنا",
  "گِھساتی": "گِھسْنا",
  "گِھساتیں": "گِھسْنا",
  "گِھساؤ": "گِھسْنا",
  "گِھساؤں": "گِھسْنا",
  "گِھسائے": "گِھسْنا",
  "گِھسائی": "گِھسْنا",
  "گِھسائیے": "گِھسْنا",
  "گِھسائیں": "گِھسْنا",
  "گِھسایا": "گِھسْنا",
  "گِھسنے": "گِھسنا",
  "گِھسنا": "گِھسنا",
  "گِھسنی": "گِھسنا",
  "گِھستے": "گِھسنا",
  "گِھستا": "گِھسنا",
  "گِھستی": "گِھسنا",
  "گِھستیں": "گِھسنا",
  "گِھسو": "گِھسْنا",
  "گِھسوں": "گِھسْنا",
  "گِھسوا": "گِھسنا",
  "گِھسوانے": "گِھسنا",
  "گِھسوانا": "گِھسنا",
  "گِھسواتے": "گِھسنا",
  "گِھسواتا": "گِھسنا",
  "گِھسواتی": "گِھسنا",
  "گِھسواتیں": "گِھسنا",
  "گِھسواؤ": "گِھسنا",
  "گِھسواؤں": "گِھسنا",
  "گِھسوائے": "گِھسنا",
  "گِھسوائی": "گِھسنا",
  "گِھسوائیے": "گِھسنا",
  "گِھسوائیں": "گِھسنا",
  "گِھسوایا": "گِھسنا",
  "گِھسی": "گِھسْنا",
  "گِھسیے": "گِھسْنا",
  "گِھسیں": "گِھسْنا",
  "گِھسیٹ": "گِھسیٹنا",
  "گِھسیٹے": "گِھسیٹنا",
  "گِھسیٹں": "گِھسیٹنا",
  "گِھسیٹا": "گِھسیٹنا",
  "گِھسیٹنے": "گِھسیٹنا",
  "گِھسیٹنا": "گِھسیٹنا",
  "گِھسیٹنی": "گِھسیٹنا",
  "گِھسیٹتے": "گِھسیٹنا",
  "گِھسیٹتا": "گِھسیٹنا",
  "گِھسیٹتی": "گِھسیٹنا",
  "گِھسیٹتیں": "گِھسیٹنا",
  "گِھسیٹو": "گِھسیٹنا",
  "گِھسیٹوں": "گِھسیٹنا",
  "گِھسیٹی": "گِھسیٹنا",
  "گِھسیٹیے": "گِھسیٹنا",
  "گِھسیٹیں": "گِھسیٹنا",
  "گُڑْیا": "گُڑْیا",
  "گُڑْیاں": "گُڑْیا",
  "گُڑْیو": "گُڑْیا",
  "گُڑْیوں": "گُڑْیا",
  "گُڑگُڑا": "گُڑگُڑانا",
  "گُڑگُڑانے": "گُڑگُڑانا",
  "گُڑگُڑانا": "گُڑگُڑانا",
  "گُڑگُڑانی": "گُڑگُڑانا",
  "گُڑگُڑاتے": "گُڑگُڑانا",
  "گُڑگُڑاتا": "گُڑگُڑانا",
  "گُڑگُڑاتی": "گُڑگُڑانا",
  "گُڑگُڑاتیں": "گُڑگُڑانا",
  "گُڑگُڑاؤ": "گُڑگُڑانا",
  "گُڑگُڑاؤں": "گُڑگُڑانا",
  "گُڑگُڑائے": "گُڑگُڑانا",
  "گُڑگُڑائی": "گُڑگُڑانا",
  "گُڑگُڑائیے": "گُڑگُڑانا",
  "گُڑگُڑائیں": "گُڑگُڑانا",
  "گُڑگُڑایا": "گُڑگُڑانا",
  "گُل": "گُل",
  "گُلو": "گُل",
  "گُلوں": "گُل",
  "گُردے": "گُردہ",
  "گُردہ": "گُردہ",
  "گُردو": "گُردہ",
  "گُردوں": "گُردہ",
  "گُزر": "گُزرنا",
  "گُزرے": "گُزرنا",
  "گُزرں": "گُزرنا",
  "گُزرا": "گُزرنا",
  "گُزرنے": "گُزرنا",
  "گُزرنا": "گُزرنا",
  "گُزرنی": "گُزرنا",
  "گُزرتے": "گُزرنا",
  "گُزرتا": "گُزرنا",
  "گُزرتی": "گُزرنا",
  "گُزرتیں": "گُزرنا",
  "گُزرو": "گُزرنا",
  "گُزروں": "گُزرنا",
  "گُزروا": "گُزرنا",
  "گُزروانے": "گُزرنا",
  "گُزروانا": "گُزرنا",
  "گُزرواتے": "گُزرنا",
  "گُزرواتا": "گُزرنا",
  "گُزرواتی": "گُزرنا",
  "گُزرواتیں": "گُزرنا",
  "گُزرواؤ": "گُزرنا",
  "گُزرواؤں": "گُزرنا",
  "گُزروائے": "گُزرنا",
  "گُزروائی": "گُزرنا",
  "گُزروائیے": "گُزرنا",
  "گُزروائیں": "گُزرنا",
  "گُزروایا": "گُزرنا",
  "گُزری": "گُزرنا",
  "گُزریے": "گُزرنا",
  "گُزریں": "گُزرنا",
  "گُھرکی": "گُھرکی",
  "گُھرکیاں": "گُھرکی",
  "گُھرکیو": "گُھرکی",
  "گُھرکیوں": "گُھرکی",
  "گُھس": "گُھسْنا",
  "گُھسْں": "گُھسْنا",
  "گُھسْنے": "گُھسْنا",
  "گُھسْنا": "گُھسْنا",
  "گُھسْنی": "گُھسْنا",
  "گُھسْتے": "گُھسْنا",
  "گُھسْتا": "گُھسْنا",
  "گُھسْتی": "گُھسْنا",
  "گُھسْتیں": "گُھسْنا",
  "گُھسْوا": "گُھسْنا",
  "گُھسْوانے": "گُھسْنا",
  "گُھسْوانا": "گُھسْنا",
  "گُھسْواتے": "گُھسْنا",
  "گُھسْواتا": "گُھسْنا",
  "گُھسْواتی": "گُھسْنا",
  "گُھسْواتیں": "گُھسْنا",
  "گُھسْواؤ": "گُھسْنا",
  "گُھسْواؤں": "گُھسْنا",
  "گُھسْوائے": "گُھسْنا",
  "گُھسْوائی": "گُھسْنا",
  "گُھسْوائیے": "گُھسْنا",
  "گُھسْوائیں": "گُھسْنا",
  "گُھسْوایا": "گُھسْنا",
  "گُھسے": "گُھسْنا",
  "گُھسا": "گُھسْنا",
  "گُھسانے": "گُھسْنا",
  "گُھسانا": "گُھسْنا",
  "گُھساتے": "گُھسْنا",
  "گُھساتا": "گُھسْنا",
  "گُھساتی": "گُھسْنا",
  "گُھساتیں": "گُھسْنا",
  "گُھساؤ": "گُھسْنا",
  "گُھساؤں": "گُھسْنا",
  "گُھسائے": "گُھسْنا",
  "گُھسائی": "گُھسْنا",
  "گُھسائیے": "گُھسْنا",
  "گُھسائیں": "گُھسْنا",
  "گُھسایا": "گُھسْنا",
  "گُھسو": "گُھسْنا",
  "گُھسوں": "گُھسْنا",
  "گُھسی": "گُھسْنا",
  "گُھسیے": "گُھسْنا",
  "گُھسیں": "گُھسْنا",
  "گڈ": "گڈ",
  "گڈریے": "گڈریا",
  "گڈریا": "گڈریا",
  "گڈریو": "گڈریا",
  "گڈریوں": "گڈریا",
  "گڈو": "گڈ",
  "گڈوں": "گڈ",
  "گڑ": "گڑنا",
  "گڑے": "گڑا",
  "گڑں": "گڑنا",
  "گڑا": "گڑا",
  "گڑگڑا": "گڑگڑانا",
  "گڑگڑانے": "گڑگڑانا",
  "گڑگڑانا": "گڑگڑانا",
  "گڑگڑانی": "گڑگڑانا",
  "گڑگڑاتے": "گڑگڑانا",
  "گڑگڑاتا": "گڑگڑانا",
  "گڑگڑاتی": "گڑگڑانا",
  "گڑگڑاتیں": "گڑگڑانا",
  "گڑگڑاؤ": "گڑگڑانا",
  "گڑگڑاؤں": "گڑگڑانا",
  "گڑگڑائے": "گڑگڑانا",
  "گڑگڑائی": "گڑگڑانا",
  "گڑگڑائیے": "گڑگڑانا",
  "گڑگڑائیں": "گڑگڑانا",
  "گڑگڑایا": "گڑگڑانا",
  "گڑنے": "گڑنا",
  "گڑنا": "گڑنا",
  "گڑنی": "گڑنا",
  "گڑتے": "گڑنا",
  "گڑتا": "گڑنا",
  "گڑتی": "گڑنا",
  "گڑتیں": "گڑنا",
  "گڑو": "گڑا",
  "گڑوں": "گڑا",
  "گڑوا": "گڑنا",
  "گڑوانے": "گڑنا",
  "گڑوانا": "گڑنا",
  "گڑواتے": "گڑنا",
  "گڑواتا": "گڑنا",
  "گڑواتی": "گڑنا",
  "گڑواتیں": "گڑنا",
  "گڑواؤ": "گڑنا",
  "گڑواؤں": "گڑنا",
  "گڑوائے": "گڑنا",
  "گڑوائی": "گڑنا",
  "گڑوائیے": "گڑنا",
  "گڑوائیں": "گڑنا",
  "گڑوایا": "گڑنا",
  "گڑی": "گڑنا",
  "گڑیے": "گڑنا",
  "گڑیں": "گڑنا",
  "گڑیا": "گڑیا",
  "گڑیاں": "گڑیا",
  "گڑیو": "گڑیا",
  "گڑیوں": "گڑیا",
  "گڑھے": "گڑھا",
  "گڑھا": "گڑھا",
  "گڑھو": "گڑھا",
  "گڑھوں": "گڑھا",
  "گٹر": "گٹر",
  "گٹرو": "گٹر",
  "گٹروں": "گٹر",
  "گٹھے": "گٹھا",
  "گٹھڑی": "گٹھڑی",
  "گٹھڑیاں": "گٹھڑی",
  "گٹھڑیو": "گٹھڑی",
  "گٹھڑیوں": "گٹھڑی",
  "گٹھا": "گٹھا",
  "گٹھلی": "گٹھلی",
  "گٹھلیاں": "گٹھلی",
  "گٹھلیو": "گٹھلی",
  "گٹھلیوں": "گٹھلی",
  "گٹھو": "گٹھا",
  "گٹھوں": "گٹھا",
  "گذار": "گذرنا",
  "گذارے": "گذارا",
  "گذارں": "گذرنا",
  "گذارا": "گذارا",
  "گذارانے": "گذارنا",
  "گذارانا": "گذارنا",
  "گذاراتے": "گذارنا",
  "گذاراتا": "گذارنا",
  "گذاراتی": "گذارنا",
  "گذاراتیں": "گذارنا",
  "گذاراؤ": "گذارنا",
  "گذاراؤں": "گذارنا",
  "گذارائے": "گذارنا",
  "گذارائی": "گذارنا",
  "گذارائیے": "گذارنا",
  "گذارائیں": "گذارنا",
  "گذارایا": "گذارنا",
  "گذارنے": "گذرنا",
  "گذارنا": "گذرنا",
  "گذارنی": "گذارنا",
  "گذارتے": "گذرنا",
  "گذارتا": "گذرنا",
  "گذارتی": "گذرنا",
  "گذارتیں": "گذرنا",
  "گذارو": "گذارا",
  "گذاروں": "گذارا",
  "گذاری": "گذرنا",
  "گذاریے": "گذرنا",
  "گذاریں": "گذرنا",
  "گذر": "گذرنا",
  "گذرے": "گذرنا",
  "گذرں": "گذرنا",
  "گذرا": "گذرنا",
  "گذرنے": "گذرنا",
  "گذرنا": "گذرنا",
  "گذرنی": "گذرنا",
  "گذرتے": "گذرنا",
  "گذرتا": "گذرنا",
  "گذرتی": "گذرنا",
  "گذرتیں": "گذرنا",
  "گذرو": "گذرنا",
  "گذروں": "گذرنا",
  "گذروا": "گذرنا",
  "گذروانے": "گذرنا",
  "گذروانا": "گذرنا",
  "گذرواتے": "گذرنا",
  "گذرواتا": "گذرنا",
  "گذرواتی": "گذرنا",
  "گذرواتیں": "گذرنا",
  "گذرواؤ": "گذرنا",
  "گذرواؤں": "گذرنا",
  "گذروائے": "گذرنا",
  "گذروائی": "گذرنا",
  "گذروائیے": "گذرنا",
  "گذروائیں": "گذرنا",
  "گذروایا": "گذرنا",
  "گذری": "گذرنا",
  "گذریے": "گذرنا",
  "گذریں": "گذرنا",
  "گا": "گانا",
  "گاڑ": "گڑنا",
  "گاڑے": "گڑنا",
  "گاڑں": "گڑنا",
  "گاڑا": "گڑنا",
  "گاڑنے": "گڑنا",
  "گاڑنا": "گڑنا",
  "گاڑتے": "گڑنا",
  "گاڑتا": "گڑنا",
  "گاڑتی": "گڑنا",
  "گاڑتیں": "گڑنا",
  "گاڑو": "گڑنا",
  "گاڑوں": "گڑنا",
  "گاڑی": "گاڑی",
  "گاڑیے": "گڑنا",
  "گاڑیں": "گڑنا",
  "گاڑیاں": "گاڑی",
  "گاڑیو": "گاڑی",
  "گاڑیوں": "گاڑی",
  "گاہک": "گاہک",
  "گاہکو": "گاہک",
  "گاہکوں": "گاہک",
  "گاجَر": "گاجَر",
  "گاجَرو": "گاجَر",
  "گاجَروں": "گاجَر",
  "گاجَریں": "گاجَر",
  "گاجر": "گاجر",
  "گاجرو": "گاجر",
  "گاجروں": "گاجر",
  "گاجریں": "گاجر",
  "گال": "گال",
  "گالے": "گلنا",
  "گالں": "گلنا",
  "گالا": "گلنا",
  "گالنے": "گلنا",
  "گالنا": "گلنا",
  "گالتے": "گلنا",
  "گالتا": "گلنا",
  "گالتی": "گلنا",
  "گالتیں": "گلنا",
  "گالو": "گال",
  "گالوں": "گال",
  "گالی": "گالی",
  "گالیے": "گلنا",
  "گالیں": "گال",
  "گالیاں": "گالی",
  "گالیو": "گالی",
  "گالیوں": "گالی",
  "گامے": "گاما",
  "گاما": "گاما",
  "گامو": "گاما",
  "گاموں": "گاما",
  "گانے": "گانا",
  "گانٹھ": "گانٹھ",
  "گانٹھے": "گانٹھہ",
  "گانٹھں": "گانٹھنا",
  "گانٹھا": "گانٹھنا",
  "گانٹھہ": "گانٹھہ",
  "گانٹھنے": "گانٹھنا",
  "گانٹھنا": "گانٹھنا",
  "گانٹھنی": "گانٹھنا",
  "گانٹھتے": "گانٹھنا",
  "گانٹھتا": "گانٹھنا",
  "گانٹھتی": "گانٹھنا",
  "گانٹھتیں": "گانٹھنا",
  "گانٹھو": "گانٹھہ",
  "گانٹھوں": "گانٹھہ",
  "گانٹھی": "گانٹھنا",
  "گانٹھیے": "گانٹھنا",
  "گانٹھیں": "گانٹھ",
  "گانا": "گانا",
  "گانہ": "گانہ",
  "گانو": "گانا",
  "گانوں": "گانا",
  "گانی": "گانا",
  "گار": "گار",
  "گارے": "گارا",
  "گارا": "گارا",
  "گارہ": "گارہ",
  "گارو": "گارا",
  "گاروں": "گارا",
  "گاتے": "گانا",
  "گاتا": "گانا",
  "گاتی": "گانا",
  "گاتیں": "گانا",
  "گاؤ": "گانا",
  "گاؤں": "گانا",
  "گائے": "گانا",
  "گائی": "گانا",
  "گائیے": "گانا",
  "گائیں": "گانا",
  "گایا": "گانا",
  "گدے": "گدا",
  "گدا": "گدا",
  "گداگر": "گداگر",
  "گداگرو": "گداگر",
  "گداگروں": "گداگر",
  "گدگدی": "گدگدی",
  "گدگدیاں": "گدگدی",
  "گدگدیو": "گدگدی",
  "گدگدیوں": "گدگدی",
  "گدہ": "گدہ",
  "گدو": "گدا",
  "گدوں": "گدا",
  "گدی": "گدی",
  "گدیاں": "گدی",
  "گدیو": "گدی",
  "گدیوں": "گدی",
  "گدھے": "گدھا",
  "گدھا": "گدھا",
  "گدھو": "گدھا",
  "گدھوں": "گدھا",
  "گہرائی": "گہرائی",
  "گہرائیاں": "گہرائی",
  "گہرائیو": "گہرائی",
  "گہرائیوں": "گہرائی",
  "گہوارے": "گہوارہ",
  "گہوارہ": "گہوارہ",
  "گہوارو": "گہوارہ",
  "گہواروں": "گہوارہ",
  "گجر": "گجر",
  "گجرے": "گجرا",
  "گجرا": "گجرا",
  "گجرات": "گجرات",
  "گجراتو": "گجرات",
  "گجراتوں": "گجرات",
  "گجراتیں": "گجرات",
  "گجرو": "گجرا",
  "گجروں": "گجرا",
  "گل": "گل",
  "گلے": "گلا",
  "گلں": "گلنا",
  "گلا": "گلا",
  "گلاب": "گلاب",
  "گلابو": "گلاب",
  "گلابوں": "گلاب",
  "گلاس": "گلاس",
  "گلاسو": "گلاس",
  "گلاسوں": "گلاس",
  "گلدان": "گلدان",
  "گلدانو": "گلدان",
  "گلدانوں": "گلدان",
  "گلدستے": "گلدستہ",
  "گلدستہ": "گلدستہ",
  "گلدستو": "گلدستہ",
  "گلدستوں": "گلدستہ",
  "گلہ": "گلہ",
  "گلنے": "گلنا",
  "گلنا": "گلنا",
  "گلنی": "گلنا",
  "گلستان": "گلستان",
  "گلستانو": "گلستان",
  "گلستانوں": "گلستان",
  "گلتے": "گلنا",
  "گلتا": "گلنا",
  "گلتی": "گلنا",
  "گلتیں": "گلنا",
  "گلو": "گلا",
  "گلوں": "گلا",
  "گلوا": "گلنا",
  "گلوانے": "گلنا",
  "گلوانا": "گلنا",
  "گلواتے": "گلنا",
  "گلواتا": "گلنا",
  "گلواتی": "گلنا",
  "گلواتیں": "گلنا",
  "گلواؤ": "گلنا",
  "گلواؤں": "گلنا",
  "گلوائے": "گلنا",
  "گلوائی": "گلنا",
  "گلوائیے": "گلنا",
  "گلوائیں": "گلنا",
  "گلوایا": "گلنا",
  "گلوری": "گلوری",
  "گلوریاں": "گلوری",
  "گلوریو": "گلوری",
  "گلوریوں": "گلوری",
  "گلی": "گلی",
  "گلیے": "گلنا",
  "گلیں": "گلنا",
  "گلیاں": "گلی",
  "گلیو": "گلی",
  "گلیوں": "گلی",
  "گلزار": "گلزار",
  "گلزارو": "گلزار",
  "گلزاروں": "گلزار",
  "گمان": "گمان",
  "گمانو": "گمان",
  "گمانوں": "گمان",
  "گمانی": "گمانی",
  "گمانیں": "گمان",
  "گمانیاں": "گمانی",
  "گمانیو": "گمانی",
  "گمانیوں": "گمانی",
  "گملے": "گملا",
  "گملا": "گملا",
  "گملو": "گملا",
  "گملوں": "گملا",
  "گمراہی": "گمراہی",
  "گمراہیاں": "گمراہی",
  "گمراہیو": "گمراہی",
  "گمراہیوں": "گمراہی",
  "گن": "گننا",
  "گنڈے": "گنڈا",
  "گنڈا": "گنڈا",
  "گنڈہ": "گنڈہ",
  "گنڈو": "گنڈا",
  "گنڈوں": "گنڈا",
  "گنڈیری": "گنڈیری",
  "گنڈیریاں": "گنڈیری",
  "گنڈیریو": "گنڈیری",
  "گنڈیریوں": "گنڈیری",
  "گنے": "گنا",
  "گنں": "گننا",
  "گنا": "گنا",
  "گناہگار": "گناہگار",
  "گناہگارو": "گناہگار",
  "گناہگاروں": "گناہگار",
  "گنانے": "گننا",
  "گنانا": "گننا",
  "گناتے": "گننا",
  "گناتا": "گننا",
  "گناتی": "گننا",
  "گناتیں": "گننا",
  "گناؤ": "گننا",
  "گناؤں": "گننا",
  "گنائے": "گننا",
  "گنائی": "گننا",
  "گنائیے": "گننا",
  "گنائیں": "گننا",
  "گنایا": "گننا",
  "گنبد": "گنبد",
  "گنبدو": "گنبد",
  "گنبدوں": "گنبد",
  "گندے": "گندہ",
  "گندہ": "گندہ",
  "گندو": "گندہ",
  "گندوں": "گندہ",
  "گندھوا": "گوندھنا",
  "گندھوانے": "گوندھنا",
  "گندھوانا": "گوندھنا",
  "گندھواتے": "گوندھنا",
  "گندھواتا": "گوندھنا",
  "گندھواتی": "گوندھنا",
  "گندھواتیں": "گوندھنا",
  "گندھواؤ": "گوندھنا",
  "گندھواؤں": "گوندھنا",
  "گندھوائے": "گوندھنا",
  "گندھوائی": "گوندھنا",
  "گندھوائیے": "گوندھنا",
  "گندھوائیں": "گوندھنا",
  "گندھوایا": "گوندھنا",
  "گنگنا": "گنگنانا",
  "گنگنانے": "گنگنانا",
  "گنگنانا": "گنگنانا",
  "گنگنانی": "گنگنانا",
  "گنگناتے": "گنگنانا",
  "گنگناتا": "گنگنانا",
  "گنگناتی": "گنگنانا",
  "گنگناتیں": "گنگنانا",
  "گنگناؤ": "گنگنانا",
  "گنگناؤں": "گنگنانا",
  "گنگنائے": "گنگنانا",
  "گنگنائی": "گنگنانا",
  "گنگنائیے": "گنگنانا",
  "گنگنائیں": "گنگنانا",
  "گنگنایا": "گنگنانا",
  "گنہگار": "گنہگار",
  "گنہگارو": "گنہگار",
  "گنہگاروں": "گنہگار",
  "گنجینے": "گنجینہ",
  "گنجینہ": "گنجینہ",
  "گنجینو": "گنجینہ",
  "گنجینوں": "گنجینہ",
  "گننے": "گننا",
  "گننا": "گننا",
  "گننی": "گننا",
  "گنتے": "گننا",
  "گنتا": "گننا",
  "گنتی": "گننا",
  "گنتیں": "گننا",
  "گنو": "گنا",
  "گنوں": "گنا",
  "گنوا": "گنوانا",
  "گنوانے": "گنوانا",
  "گنوانا": "گنوانا",
  "گنوانی": "گنوانا",
  "گنوار": "گنوار",
  "گنوارو": "گنوار",
  "گنواروں": "گنوار",
  "گنواتے": "گنوانا",
  "گنواتا": "گنوانا",
  "گنواتی": "گنوانا",
  "گنواتیں": "گنوانا",
  "گنواؤ": "گنوانا",
  "گنواؤں": "گنوانا",
  "گنوائے": "گنوانا",
  "گنوائی": "گنوانا",
  "گنوائیے": "گنوانا",
  "گنوائیں": "گنوانا",
  "گنوایا": "گنوانا",
  "گنی": "گننا",
  "گنیے": "گننا",
  "گنیں": "گننا",
  "گپ": "گپ",
  "گپو": "گپ",
  "گپوں": "گپ",
  "گپی": "گپی",
  "گپیں": "گپ",
  "گپیو": "گپی",
  "گپیوں": "گپی",
  "گر": "گرنا",
  "گرے": "گرنا",
  "گرں": "گرنا",
  "گرا": "گرنا",
  "گرانے": "گرنا",
  "گرانا": "گرنا",
  "گراری": "گراری",
  "گراریاں": "گراری",
  "گراریو": "گراری",
  "گراریوں": "گراری",
  "گراتے": "گرنا",
  "گراتا": "گرنا",
  "گراتی": "گرنا",
  "گراتیں": "گرنا",
  "گراؤ": "گرنا",
  "گراؤں": "گرنا",
  "گرائے": "گرنا",
  "گرائی": "گرنا",
  "گرائیے": "گرنا",
  "گرائیں": "گرنا",
  "گرایا": "گرنا",
  "گرد": "گرد",
  "گردے": "گردا",
  "گردش": "گردش",
  "گردشو": "گردش",
  "گردشوں": "گردش",
  "گردشیں": "گردش",
  "گردا": "گردا",
  "گردہ": "گردہ",
  "گردن": "گردن",
  "گردنو": "گردن",
  "گردنوں": "گردن",
  "گردنیں": "گردن",
  "گردو": "گردا",
  "گردوں": "گردا",
  "گردیں": "گرد",
  "گرفتاری": "گرفتاری",
  "گرفتاریاں": "گرفتاری",
  "گرفتاریو": "گرفتاری",
  "گرفتاریوں": "گرفتاری",
  "گرفتگی": "گرفتگی",
  "گرفتگیاں": "گرفتگی",
  "گرفتگیو": "گرفتگی",
  "گرفتگیوں": "گرفتگی",
  "گرہ": "گرہ",
  "گرہو": "گرہ",
  "گرہوں": "گرہ",
  "گرہیں": "گرہ",
  "گرج": "گرجنا",
  "گرجے": "گرجنا",
  "گرجں": "گرجنا",
  "گرجا": "گرجنا",
  "گرجانے": "گرجنا",
  "گرجانا": "گرجنا",
  "گرجاتے": "گرجنا",
  "گرجاتا": "گرجنا",
  "گرجاتی": "گرجنا",
  "گرجاتیں": "گرجنا",
  "گرجاؤ": "گرجنا",
  "گرجاؤں": "گرجنا",
  "گرجائے": "گرجنا",
  "گرجائی": "گرجنا",
  "گرجائیے": "گرجنا",
  "گرجائیں": "گرجنا",
  "گرجایا": "گرجنا",
  "گرجنے": "گرجنا",
  "گرجنا": "گرجنا",
  "گرجنی": "گرجنا",
  "گرجتے": "گرجنا",
  "گرجتا": "گرجنا",
  "گرجتی": "گرجنا",
  "گرجتیں": "گرجنا",
  "گرجو": "گرجنا",
  "گرجوں": "گرجنا",
  "گرجوا": "گرجنا",
  "گرجوانے": "گرجنا",
  "گرجوانا": "گرجنا",
  "گرجواتے": "گرجنا",
  "گرجواتا": "گرجنا",
  "گرجواتی": "گرجنا",
  "گرجواتیں": "گرجنا",
  "گرجواؤ": "گرجنا",
  "گرجواؤں": "گرجنا",
  "گرجوائے": "گرجنا",
  "گرجوائی": "گرجنا",
  "گرجوائیے": "گرجنا",
  "گرجوائیں": "گرجنا",
  "گرجوایا": "گرجنا",
  "گرجی": "گرجنا",
  "گرجیے": "گرجنا",
  "گرجیں": "گرجنا",
  "گرمی": "گرمی",
  "گرمیاں": "گرمی",
  "گرمیو": "گرمی",
  "گرمیوں": "گرمی",
  "گرنے": "گرنا",
  "گرنا": "گرنا",
  "گرنی": "گرنا",
  "گرتے": "گرنا",
  "گرتا": "گرنا",
  "گرتی": "گرنا",
  "گرتیں": "گرنا",
  "گرو": "گرو",
  "گروں": "گرنا",
  "گروا": "گرنا",
  "گروانے": "گرنا",
  "گروانا": "گرنا",
  "گرواتے": "گرنا",
  "گرواتا": "گرنا",
  "گرواتی": "گرنا",
  "گرواتیں": "گرنا",
  "گرواؤ": "گرنا",
  "گرواؤں": "گرنا",
  "گروائے": "گرنا",
  "گروائی": "گرنا",
  "گروائیے": "گرنا",
  "گروائیں": "گرنا",
  "گروایا": "گرنا",
  "گروہ": "گروہ",
  "گروہؤ": "گروہ",
  "گروہؤں": "گروہ",
  "گروہئیں": "گروہ",
  "گروپ": "گروپ",
  "گروپو": "گروپ",
  "گروپوں": "گروپ",
  "گروو": "گرو",
  "گرووں": "گرو",
  "گروؤ": "گرو",
  "گروؤں": "گرو",
  "گری": "گری",
  "گریے": "گریہ",
  "گریں": "گرنا",
  "گریاں": "گری",
  "گریبان": "گریبان",
  "گریبانو": "گریبان",
  "گریبانوں": "گریبان",
  "گریہ": "گریہ",
  "گریو": "گریہ",
  "گریوں": "گریہ",
  "گتے": "گتہ",
  "گتہ": "گتہ",
  "گتو": "گتہ",
  "گتوں": "گتہ",
  "گوٹے": "گوٹہ",
  "گوٹہ": "گوٹہ",
  "گوٹو": "گوٹہ",
  "گوٹوں": "گوٹہ",
  "گوش": "گوش",
  "گوشے": "گوشہ",
  "گوشہ": "گوشہ",
  "گوشو": "گوشہ",
  "گوشوں": "گوشہ",
  "گوشوارے": "گوشوارہ",
  "گوشوارہ": "گوشوارہ",
  "گوشوارو": "گوشوارہ",
  "گوشواروں": "گوشوارہ",
  "گواہی": "گواہی",
  "گواہیاں": "گواہی",
  "گواہیو": "گواہی",
  "گواہیوں": "گواہی",
  "گودام": "گودام",
  "گودامو": "گودام",
  "گوداموں": "گودام",
  "گول": "گول",
  "گولے": "گولا",
  "گولا": "گولا",
  "گولائی": "گولائی",
  "گولائیاں": "گولائی",
  "گولائیو": "گولائی",
  "گولائیوں": "گولائی",
  "گولہ": "گولہ",
  "گولو": "گولا",
  "گولوں": "گولا",
  "گولی": "گولی",
  "گولیاں": "گولی",
  "گولیو": "گولی",
  "گولیوں": "گولی",
  "گوندھ": "گوندھنا",
  "گوندھے": "گوندھنا",
  "گوندھں": "گوندھنا",
  "گوندھا": "گوندھنا",
  "گوندھانے": "گوندھنا",
  "گوندھانا": "گوندھنا",
  "گوندھاتے": "گوندھنا",
  "گوندھاتا": "گوندھنا",
  "گوندھاتی": "گوندھنا",
  "گوندھاتیں": "گوندھنا",
  "گوندھاؤ": "گوندھنا",
  "گوندھاؤں": "گوندھنا",
  "گوندھائے": "گوندھنا",
  "گوندھائی": "گوندھنا",
  "گوندھائیے": "گوندھنا",
  "گوندھائیں": "گوندھنا",
  "گوندھایا": "گوندھنا",
  "گوندھنے": "گوندھنا",
  "گوندھنا": "گوندھنا",
  "گوندھنی": "گوندھنا",
  "گوندھتے": "گوندھنا",
  "گوندھتا": "گوندھنا",
  "گوندھتی": "گوندھنا",
  "گوندھتیں": "گوندھنا",
  "گوندھو": "گوندھنا",
  "گوندھوں": "گوندھنا",
  "گوندھی": "گوندھنا",
  "گوندھیے": "گوندھنا",
  "گوندھیں": "گوندھنا",
  "گونگے": "گونگا",
  "گونگا": "گونگا",
  "گونگو": "گونگا",
  "گونگوں": "گونگا",
  "گونج": "گونج",
  "گونجے": "گونجنا",
  "گونجں": "گونجنا",
  "گونجا": "گونجنا",
  "گونجنے": "گونجنا",
  "گونجنا": "گونجنا",
  "گونجنی": "گونجنا",
  "گونجتے": "گونجنا",
  "گونجتا": "گونجنا",
  "گونجتی": "گونجنا",
  "گونجتیں": "گونجنا",
  "گونجو": "گونج",
  "گونجوں": "گونج",
  "گونجی": "گونجنا",
  "گونجیے": "گونجنا",
  "گونجیں": "گونج",
  "گورے": "گورا",
  "گورا": "گورا",
  "گورکن": "گورکن",
  "گورکنو": "گورکن",
  "گورکنوں": "گورکن",
  "گورو": "گورا",
  "گوروں": "گورا",
  "گیڈر": "گیڈر",
  "گیڈرو": "گیڈر",
  "گیڈروں": "گیڈر",
  "گئے": "جانا",
  "گئی": "جانا",
  "گئیں": "جانا",
  "گیا": "جانا",
  "گیانی": "گیانی",
  "گیانیو": "گیانی",
  "گیانیوں": "گیانی",
  "گیارا": "گیارا",
  "گیند": "گیند",
  "گیندے": "گیندا",
  "گیندا": "گیندا",
  "گیندو": "گیندا",
  "گیندوں": "گیندا",
  "گیندیں": "گیند",
  "گیر": "گیر",
  "گیرے": "گیرہ",
  "گیرہ": "گیرہ",
  "گیرو": "گیرہ",
  "گیروں": "گیرہ",
  "گیس": "گیس",
  "گیسو": "گیس",
  "گیسوں": "گیس",
  "گیسیں": "گیس",
  "گیت": "گیت",
  "گیتو": "گیت",
  "گیتوں": "گیت",
  "گیتیں": "گیت",
  "گزار": "گزرنا",
  "گزارے": "گزارا",
  "گزارں": "گزرنا",
  "گزارا": "گزارا",
  "گزارہ": "گزارہ",
  "گزارنے": "گزرنا",
  "گزارنا": "گزرنا",
  "گزارتے": "گزرنا",
  "گزارتا": "گزرنا",
  "گزارتی": "گزرنا",
  "گزارتیں": "گزرنا",
  "گزارو": "گزارا",
  "گزاروں": "گزارا",
  "گزاری": "گزرنا",
  "گزاریے": "گزرنا",
  "گزاریں": "گزرنا",
  "گزر": "گزرنا",
  "گزرے": "گزرنا",
  "گزرں": "گزرنا",
  "گزرا": "گزرنا",
  "گزرنے": "گزرنا",
  "گزرنا": "گزرنا",
  "گزرنی": "گزرنا",
  "گزرتے": "گزرنا",
  "گزرتا": "گزرنا",
  "گزرتی": "گزرنا",
  "گزرتیں": "گزرنا",
  "گزرو": "گزرنا",
  "گزروں": "گزرنا",
  "گزروا": "گزرنا",
  "گزروانے": "گزرنا",
  "گزروانا": "گزرنا",
  "گزرواتے": "گزرنا",
  "گزرواتا": "گزرنا",
  "گزرواتی": "گزرنا",
  "گزرواتیں": "گزرنا",
  "گزرواؤ": "گزرنا",
  "گزرواؤں": "گزرنا",
  "گزروائے": "گزرنا",
  "گزروائی": "گزرنا",
  "گزروائیے": "گزرنا",
  "گزروائیں": "گزرنا",
  "گزروایا": "گزرنا",
  "گزری": "گزرنا",
  "گزریے": "گزرنا",
  "گزریں": "گزرنا",
  "گھُٹ": "گھُٹنا",
  "گھُٹے": "گھُٹنا",
  "گھُٹں": "گھُٹنا",
  "گھُٹا": "گھُٹنا",
  "گھُٹنے": "گھُٹنا",
  "گھُٹنا": "گھُٹنا",
  "گھُٹنو": "گھُٹنا",
  "گھُٹنوں": "گھُٹنا",
  "گھُٹنی": "گھُٹنا",
  "گھُٹتے": "گھُٹنا",
  "گھُٹتا": "گھُٹنا",
  "گھُٹتی": "گھُٹنا",
  "گھُٹتیں": "گھُٹنا",
  "گھُٹو": "گھُٹنا",
  "گھُٹوں": "گھُٹنا",
  "گھُٹی": "گھُٹنا",
  "گھُٹیے": "گھُٹنا",
  "گھُٹیں": "گھُٹنا",
  "گھڑ": "گھڑ",
  "گھڑے": "گھڑا",
  "گھڑں": "گھڑنا",
  "گھڑا": "گھڑا",
  "گھڑانے": "گھڑنا",
  "گھڑانا": "گھڑنا",
  "گھڑاتے": "گھڑنا",
  "گھڑاتا": "گھڑنا",
  "گھڑاتی": "گھڑنا",
  "گھڑاتیں": "گھڑنا",
  "گھڑاؤ": "گھڑنا",
  "گھڑاؤں": "گھڑنا",
  "گھڑائے": "گھڑنا",
  "گھڑائی": "گھڑنا",
  "گھڑائیے": "گھڑنا",
  "گھڑائیں": "گھڑنا",
  "گھڑایا": "گھڑنا",
  "گھڑنے": "گھڑنا",
  "گھڑنا": "گھڑنا",
  "گھڑنی": "گھڑنا",
  "گھڑتے": "گھڑنا",
  "گھڑتا": "گھڑنا",
  "گھڑتی": "گھڑنا",
  "گھڑتیں": "گھڑنا",
  "گھڑو": "گھڑا",
  "گھڑوں": "گھڑا",
  "گھڑوا": "گھڑنا",
  "گھڑوانے": "گھڑنا",
  "گھڑوانا": "گھڑنا",
  "گھڑواتے": "گھڑنا",
  "گھڑواتا": "گھڑنا",
  "گھڑواتی": "گھڑنا",
  "گھڑواتیں": "گھڑنا",
  "گھڑواؤ": "گھڑنا",
  "گھڑواؤں": "گھڑنا",
  "گھڑوائے": "گھڑنا",
  "گھڑوائی": "گھڑنا",
  "گھڑوائیے": "گھڑنا",
  "گھڑوائیں": "گھڑنا",
  "گھڑوایا": "گھڑنا",
  "گھڑی": "گھڑی",
  "گھڑیے": "گھڑنا",
  "گھڑیں": "گھڑنا",
  "گھڑیاں": "گھڑی",
  "گھڑیو": "گھڑی",
  "گھڑیوں": "گھڑی",
  "گھٹ": "گھٹنا",
  "گھٹے": "گھٹا",
  "گھٹں": "گھٹنا",
  "گھٹا": "گھٹا",
  "گھٹانے": "گھٹنا",
  "گھٹانا": "گھٹنا",
  "گھٹاتے": "گھٹنا",
  "گھٹاتا": "گھٹنا",
  "گھٹاتی": "گھٹنا",
  "گھٹاتیں": "گھٹنا",
  "گھٹاؤ": "گھٹا",
  "گھٹاؤں": "گھٹا",
  "گھٹائے": "گھٹنا",
  "گھٹائی": "گھٹنا",
  "گھٹائیے": "گھٹنا",
  "گھٹائیں": "گھٹا",
  "گھٹایا": "گھٹنا",
  "گھٹن": "گھٹن",
  "گھٹنے": "گھٹنا",
  "گھٹنا": "گھٹنا",
  "گھٹنو": "گھٹنا",
  "گھٹنوں": "گھٹنا",
  "گھٹنی": "گھٹنا",
  "گھٹتے": "گھٹنا",
  "گھٹتا": "گھٹنا",
  "گھٹتی": "گھٹنا",
  "گھٹتیں": "گھٹنا",
  "گھٹو": "گھٹا",
  "گھٹوں": "گھٹا",
  "گھٹوا": "گھٹنا",
  "گھٹوانے": "گھٹنا",
  "گھٹوانا": "گھٹنا",
  "گھٹواتے": "گھٹنا",
  "گھٹواتا": "گھٹنا",
  "گھٹواتی": "گھٹنا",
  "گھٹواتیں": "گھٹنا",
  "گھٹواؤ": "گھٹنا",
  "گھٹواؤں": "گھٹنا",
  "گھٹوائے": "گھٹنا",
  "گھٹوائی": "گھٹنا",
  "گھٹوائیے": "گھٹنا",
  "گھٹوائیں": "گھٹنا",
  "گھٹوایا": "گھٹنا",
  "گھٹی": "گھٹنا",
  "گھٹیے": "گھٹنا",
  "گھٹیں": "گھٹنا",
  "گھاٹی": "گھاٹی",
  "گھاٹیاں": "گھاٹی",
  "گھاٹیو": "گھاٹی",
  "گھاٹیوں": "گھاٹی",
  "گھامڑ": "گھامڑ",
  "گھامڑو": "گھامڑ",
  "گھامڑوں": "گھامڑ",
  "گھاؤ": "گھاؤ",
  "گھبرا": "گھبرانا",
  "گھبرانے": "گھبرانا",
  "گھبرانا": "گھبرانا",
  "گھبرانی": "گھبرانا",
  "گھبراتے": "گھبرانا",
  "گھبراتا": "گھبرانا",
  "گھبراتی": "گھبرانا",
  "گھبراتیں": "گھبرانا",
  "گھبراؤ": "گھبرانا",
  "گھبراؤں": "گھبرانا",
  "گھبرائے": "گھبرانا",
  "گھبرائی": "گھبرانا",
  "گھبرائیے": "گھبرانا",
  "گھبرائیں": "گھبرانا",
  "گھبرایا": "گھبرانا",
  "گھگھیا": "گھگھیانا",
  "گھگھیانے": "گھگھیانا",
  "گھگھیانا": "گھگھیانا",
  "گھگھیانی": "گھگھیانا",
  "گھگھیاتے": "گھگھیانا",
  "گھگھیاتا": "گھگھیانا",
  "گھگھیاتی": "گھگھیانا",
  "گھگھیاتیں": "گھگھیانا",
  "گھگھیاؤ": "گھگھیانا",
  "گھگھیاؤں": "گھگھیانا",
  "گھگھیائے": "گھگھیانا",
  "گھگھیائی": "گھگھیانا",
  "گھگھیائیے": "گھگھیانا",
  "گھگھیائیں": "گھگھیانا",
  "گھگھیایا": "گھگھیانا",
  "گھل": "گھلنا",
  "گھلے": "گھلنا",
  "گھلں": "گھلنا",
  "گھلا": "گھلنا",
  "گھلانے": "گھلنا",
  "گھلانا": "گھلنا",
  "گھلاتے": "گھلنا",
  "گھلاتا": "گھلنا",
  "گھلاتی": "گھلنا",
  "گھلاتیں": "گھلنا",
  "گھلاؤ": "گھلنا",
  "گھلاؤں": "گھلنا",
  "گھلائے": "گھلنا",
  "گھلائی": "گھلنا",
  "گھلائیے": "گھلنا",
  "گھلائیں": "گھلنا",
  "گھلایا": "گھلنا",
  "گھلنے": "گھلنا",
  "گھلنا": "گھلنا",
  "گھلنی": "گھلنا",
  "گھلتے": "گھلنا",
  "گھلتا": "گھلنا",
  "گھلتی": "گھلنا",
  "گھلتیں": "گھلنا",
  "گھلو": "گھلنا",
  "گھلوں": "گھلنا",
  "گھلوا": "گھلنا",
  "گھلوانے": "گھلنا",
  "گھلوانا": "گھلنا",
  "گھلواتے": "گھلنا",
  "گھلواتا": "گھلنا",
  "گھلواتی": "گھلنا",
  "گھلواتیں": "گھلنا",
  "گھلواؤ": "گھلنا",
  "گھلواؤں": "گھلنا",
  "گھلوائے": "گھلنا",
  "گھلوائی": "گھلنا",
  "گھلوائیے": "گھلنا",
  "گھلوائیں": "گھلنا",
  "گھلوایا": "گھلنا",
  "گھلی": "گھلنا",
  "گھلیے": "گھلنا",
  "گھلیں": "گھلنا",
  "گھم": "گھمنا",
  "گھمے": "گھمنا",
  "گھمں": "گھمنا",
  "گھما": "گھمنا",
  "گھمانے": "گھمنا",
  "گھمانا": "گھمنا",
  "گھماتے": "گھمنا",
  "گھماتا": "گھمنا",
  "گھماتی": "گھمنا",
  "گھماتیں": "گھمنا",
  "گھماؤ": "گھمنا",
  "گھماؤں": "گھمنا",
  "گھمائے": "گھمنا",
  "گھمائی": "گھمنا",
  "گھمائیے": "گھمنا",
  "گھمائیں": "گھمنا",
  "گھمایا": "گھمنا",
  "گھمنے": "گھمنا",
  "گھمنا": "گھمنا",
  "گھمنی": "گھمنا",
  "گھمتے": "گھمنا",
  "گھمتا": "گھمنا",
  "گھمتی": "گھمنا",
  "گھمتیں": "گھمنا",
  "گھمو": "گھمنا",
  "گھموں": "گھمنا",
  "گھموا": "گھمنا",
  "گھموانے": "گھمنا",
  "گھموانا": "گھمنا",
  "گھمواتے": "گھمنا",
  "گھمواتا": "گھمنا",
  "گھمواتی": "گھمنا",
  "گھمواتیں": "گھمنا",
  "گھمواؤ": "گھمنا",
  "گھمواؤں": "گھمنا",
  "گھموائے": "گھمنا",
  "گھموائی": "گھمنا",
  "گھموائیے": "گھمنا",
  "گھموائیں": "گھمنا",
  "گھموایا": "گھمنا",
  "گھمی": "گھمنا",
  "گھمیے": "گھمنا",
  "گھمیں": "گھمنا",
  "گھنٹے": "گھنٹا",
  "گھنٹا": "گھنٹا",
  "گھنٹہ": "گھنٹہ",
  "گھنٹو": "گھنٹا",
  "گھنٹوں": "گھنٹا",
  "گھنٹی": "گھنٹی",
  "گھنٹیاں": "گھنٹی",
  "گھنٹیو": "گھنٹی",
  "گھنٹیوں": "گھنٹی",
  "گھنا": "گھنا",
  "گھناؤ": "گھناؤ",
  "گھناؤں": "گھنا",
  "گھنائیں": "گھنا",
  "گھنگھرو": "گھنگھرو",
  "گھنگھروؤ": "گھنگھرو",
  "گھنگھروؤں": "گھنگھرو",
  "گھر": "گھر",
  "گھرے": "گھرنا",
  "گھرں": "گھرنا",
  "گھرا": "گھرنا",
  "گھرانے": "گھرانا",
  "گھرانا": "گھرانا",
  "گھرانہ": "گھرانہ",
  "گھرانو": "گھرانا",
  "گھرانوں": "گھرانا",
  "گھرکی": "گھرکی",
  "گھرکیاں": "گھرکی",
  "گھرکیو": "گھرکی",
  "گھرکیوں": "گھرکی",
  "گھرنے": "گھرنا",
  "گھرنا": "گھرنا",
  "گھرنی": "گھرنا",
  "گھرتے": "گھرنا",
  "گھرتا": "گھرنا",
  "گھرتی": "گھرنا",
  "گھرتیں": "گھرنا",
  "گھرو": "گھر",
  "گھروں": "گھر",
  "گھروندے": "گھروندا",
  "گھروندا": "گھروندا",
  "گھروندہ": "گھروندہ",
  "گھروندو": "گھروندا",
  "گھروندوں": "گھروندا",
  "گھری": "گھرنا",
  "گھریے": "گھرنا",
  "گھریں": "گھرنا",
  "گھس": "گھسنا",
  "گھسے": "گھسنا",
  "گھسں": "گھسنا",
  "گھسٹ": "گھسٹنا",
  "گھسٹے": "گھسٹنا",
  "گھسٹں": "گھسٹنا",
  "گھسٹا": "گھسٹنا",
  "گھسٹنے": "گھسٹنا",
  "گھسٹنا": "گھسٹنا",
  "گھسٹنی": "گھسٹنا",
  "گھسٹتے": "گھسٹنا",
  "گھسٹتا": "گھسٹنا",
  "گھسٹتی": "گھسٹنا",
  "گھسٹتیں": "گھسٹنا",
  "گھسٹو": "گھسٹنا",
  "گھسٹوں": "گھسٹنا",
  "گھسٹی": "گھسٹنا",
  "گھسٹیے": "گھسٹنا",
  "گھسٹیں": "گھسٹنا",
  "گھسا": "گھسنا",
  "گھسانے": "گھسنا",
  "گھسانا": "گھسنا",
  "گھساتے": "گھسنا",
  "گھساتا": "گھسنا",
  "گھساتی": "گھسنا",
  "گھساتیں": "گھسنا",
  "گھساؤ": "گھسنا",
  "گھساؤں": "گھسنا",
  "گھسائے": "گھسنا",
  "گھسائی": "گھسنا",
  "گھسائیے": "گھسنا",
  "گھسائیں": "گھسنا",
  "گھسایا": "گھسنا",
  "گھسنے": "گھسنا",
  "گھسنا": "گھسنا",
  "گھسنی": "گھسنا",
  "گھستے": "گھسنا",
  "گھستا": "گھسنا",
  "گھستی": "گھسنا",
  "گھستیں": "گھسنا",
  "گھسو": "گھسنا",
  "گھسوں": "گھسنا",
  "گھسوا": "گھسنا",
  "گھسوانے": "گھسنا",
  "گھسوانا": "گھسنا",
  "گھسواتے": "گھسنا",
  "گھسواتا": "گھسنا",
  "گھسواتی": "گھسنا",
  "گھسواتیں": "گھسنا",
  "گھسواؤ": "گھسنا",
  "گھسواؤں": "گھسنا",
  "گھسوائے": "گھسنا",
  "گھسوائی": "گھسنا",
  "گھسوائیے": "گھسنا",
  "گھسوائیں": "گھسنا",
  "گھسوایا": "گھسنا",
  "گھسی": "گھسنا",
  "گھسیے": "گھسنا",
  "گھسیں": "گھسنا",
  "گھسیٹ": "گھسٹنا",
  "گھسیٹے": "گھسیٹا",
  "گھسیٹں": "گھسٹنا",
  "گھسیٹا": "گھسیٹا",
  "گھسیٹنے": "گھسٹنا",
  "گھسیٹنا": "گھسٹنا",
  "گھسیٹتے": "گھسٹنا",
  "گھسیٹتا": "گھسٹنا",
  "گھسیٹتی": "گھسٹنا",
  "گھسیٹتیں": "گھسٹنا",
  "گھسیٹو": "گھسیٹا",
  "گھسیٹوں": "گھسیٹا",
  "گھسیٹوا": "گھسٹنا",
  "گھسیٹوانے": "گھسٹنا",
  "گھسیٹوانا": "گھسٹنا",
  "گھسیٹواتے": "گھسٹنا",
  "گھسیٹواتا": "گھسٹنا",
  "گھسیٹواتی": "گھسٹنا",
  "گھسیٹواتیں": "گھسٹنا",
  "گھسیٹواؤ": "گھسٹنا",
  "گھسیٹواؤں": "گھسٹنا",
  "گھسیٹوائے": "گھسٹنا",
  "گھسیٹوائی": "گھسٹنا",
  "گھسیٹوائیے": "گھسٹنا",
  "گھسیٹوائیں": "گھسٹنا",
  "گھسیٹوایا": "گھسٹنا",
  "گھسیٹی": "گھسٹنا",
  "گھسیٹیے": "گھسٹنا",
  "گھسیٹیں": "گھسٹنا",
  "گھوڑے": "گھوڑا",
  "گھوڑا": "گھوڑا",
  "گھوڑو": "گھوڑا",
  "گھوڑوں": "گھوڑا",
  "گھوڑی": "گھوڑی",
  "گھوڑیاں": "گھوڑی",
  "گھوڑیو": "گھوڑی",
  "گھوڑیوں": "گھوڑی",
  "گھوٹ": "گھوٹنا",
  "گھوٹے": "گھوٹنا",
  "گھوٹں": "گھوٹنا",
  "گھوٹا": "گھوٹنا",
  "گھوٹنے": "گھوٹنا",
  "گھوٹنا": "گھوٹنا",
  "گھوٹنی": "گھوٹنا",
  "گھوٹتے": "گھوٹنا",
  "گھوٹتا": "گھوٹنا",
  "گھوٹتی": "گھوٹنا",
  "گھوٹتیں": "گھوٹنا",
  "گھوٹو": "گھوٹنا",
  "گھوٹوں": "گھوٹنا",
  "گھوٹی": "گھوٹنا",
  "گھوٹیے": "گھوٹنا",
  "گھوٹیں": "گھوٹنا",
  "گھوم": "گھومنا",
  "گھومے": "گھومنا",
  "گھومں": "گھومنا",
  "گھوما": "گھومنا",
  "گھومانے": "گھومنا",
  "گھومانا": "گھومنا",
  "گھوماتے": "گھومنا",
  "گھوماتا": "گھومنا",
  "گھوماتی": "گھومنا",
  "گھوماتیں": "گھومنا",
  "گھوماؤ": "گھومنا",
  "گھوماؤں": "گھومنا",
  "گھومائے": "گھومنا",
  "گھومائی": "گھومنا",
  "گھومائیے": "گھومنا",
  "گھومائیں": "گھومنا",
  "گھومایا": "گھومنا",
  "گھومنے": "گھومنا",
  "گھومنا": "گھومنا",
  "گھومنی": "گھومنا",
  "گھومتے": "گھومنا",
  "گھومتا": "گھومنا",
  "گھومتی": "گھومنا",
  "گھومتیں": "گھومنا",
  "گھومو": "گھومنا",
  "گھوموں": "گھومنا",
  "گھوموا": "گھومنا",
  "گھوموانے": "گھومنا",
  "گھوموانا": "گھومنا",
  "گھومواتے": "گھومنا",
  "گھومواتا": "گھومنا",
  "گھومواتی": "گھومنا",
  "گھومواتیں": "گھومنا",
  "گھومواؤ": "گھومنا",
  "گھومواؤں": "گھومنا",
  "گھوموائے": "گھومنا",
  "گھوموائی": "گھومنا",
  "گھوموائیے": "گھومنا",
  "گھوموائیں": "گھومنا",
  "گھوموایا": "گھومنا",
  "گھومی": "گھومنا",
  "گھومیے": "گھومنا",
  "گھومیں": "گھومنا",
  "گھونگھے": "گھونگھا",
  "گھونگھا": "گھونگھا",
  "گھونگھو": "گھونگھا",
  "گھونگھوں": "گھونگھا",
  "گھونسے": "گھونسہ",
  "گھونسہ": "گھونسہ",
  "گھونسو": "گھونسہ",
  "گھونسوں": "گھونسہ",
  "گھور": "گھورنا",
  "گھورے": "گھورنا",
  "گھورں": "گھورنا",
  "گھورا": "گھورنا",
  "گھورنے": "گھورنا",
  "گھورنا": "گھورنا",
  "گھورنی": "گھورنا",
  "گھورتے": "گھورنا",
  "گھورتا": "گھورنا",
  "گھورتی": "گھورنا",
  "گھورتیں": "گھورنا",
  "گھورو": "گھورنا",
  "گھوروں": "گھورنا",
  "گھوری": "گھورنا",
  "گھوریے": "گھورنا",
  "گھوریں": "گھورنا",
  "گھیر": "گِھرْنا",
  "گھیرْں": "گِھرْنا",
  "گھیرْنے": "گِھرْنا",
  "گھیرْنا": "گِھرْنا",
  "گھیرْتے": "گِھرْنا",
  "گھیرْتا": "گِھرْنا",
  "گھیرْتی": "گِھرْنا",
  "گھیرْتیں": "گِھرْنا",
  "گھیرے": "گِھرْنا",
  "گھیرں": "گھیرنا",
  "گھیرا": "گِھرْنا",
  "گھیرانے": "گھیرنا",
  "گھیرانا": "گھیرنا",
  "گھیراتے": "گھیرنا",
  "گھیراتا": "گھیرنا",
  "گھیراتی": "گھیرنا",
  "گھیراتیں": "گھیرنا",
  "گھیراؤ": "گھیراؤ",
  "گھیراؤں": "گھیرنا",
  "گھیرائے": "گھیرنا",
  "گھیرائی": "گھیرنا",
  "گھیرائیے": "گھیرنا",
  "گھیرائیں": "گھیرنا",
  "گھیرایا": "گھیرنا",
  "گھیرنے": "گھیرنا",
  "گھیرنا": "گھیرنا",
  "گھیرنی": "گھیرنا",
  "گھیرتے": "گھیرنا",
  "گھیرتا": "گھیرنا",
  "گھیرتی": "گھیرنا",
  "گھیرتیں": "گھیرنا",
  "گھیرو": "گِھرْنا",
  "گھیروں": "گِھرْنا",
  "گھیروا": "گھیرنا",
  "گھیروانے": "گھیرنا",
  "گھیروانا": "گھیرنا",
  "گھیرواتے": "گھیرنا",
  "گھیرواتا": "گھیرنا",
  "گھیرواتی": "گھیرنا",
  "گھیرواتیں": "گھیرنا",
  "گھیرواؤ": "گھیرنا",
  "گھیرواؤں": "گھیرنا",
  "گھیروائے": "گھیرنا",
  "گھیروائی": "گھیرنا",
  "گھیروائیے": "گھیرنا",
  "گھیروائیں": "گھیرنا",
  "گھیروایا": "گھیرنا",
  "گھیری": "گِھرْنا",
  "گھیریے": "گِھرْنا",
  "گھیریں": "گِھرْنا",
  "ہَم": "میں",
  "ہَمیشَہ": "ہَمیشَہ",
  "ہَر": "ہَر",
  "ہَرے": "ہَرا",
  "ہَرا": "ہَرا",
  "ہَری": "ہَرا",
  "ہُمایُوں": "ہُمایُوں",
  "ہُوا": "ہونا",
  "ہُوئے": "ہونا",
  "ہُوئی": "ہونا",
  "ہُوئیں": "ہونا",
  "ہڈی": "ہڈی",
  "ہڈیاں": "ہڈی",
  "ہڈیو": "ہڈی",
  "ہڈیوں": "ہڈی",
  "ہے": "ہونا",
  "ہڑتال": "ہڑتال",
  "ہڑتالو": "ہڑتال",
  "ہڑتالوں": "ہڑتال",
  "ہڑتالیں": "ہڑتال",
  "ہٹ": "ہٹنا",
  "ہٹے": "ہٹنا",
  "ہٹں": "ہٹنا",
  "ہٹا": "ہٹنا",
  "ہٹانے": "ہٹنا",
  "ہٹانا": "ہٹنا",
  "ہٹاتے": "ہٹنا",
  "ہٹاتا": "ہٹنا",
  "ہٹاتی": "ہٹنا",
  "ہٹاتیں": "ہٹنا",
  "ہٹاؤ": "ہٹنا",
  "ہٹاؤں": "ہٹنا",
  "ہٹائے": "ہٹنا",
  "ہٹائی": "ہٹنا",
  "ہٹائیے": "ہٹنا",
  "ہٹائیں": "ہٹنا",
  "ہٹایا": "ہٹنا",
  "ہٹنے": "ہٹنا",
  "ہٹنا": "ہٹنا",
  "ہٹنی": "ہٹنا",
  "ہٹتے": "ہٹنا",
  "ہٹتا": "ہٹنا",
  "ہٹتی": "ہٹنا",
  "ہٹتیں": "ہٹنا",
  "ہٹو": "ہٹنا",
  "ہٹوں": "ہٹنا",
  "ہٹوا": "ہٹنا",
  "ہٹوانے": "ہٹنا",
  "ہٹوانا": "ہٹنا",
  "ہٹواتے": "ہٹنا",
  "ہٹواتا": "ہٹنا",
  "ہٹواتی": "ہٹنا",
  "ہٹواتیں": "ہٹنا",
  "ہٹواؤ": "ہٹنا",
  "ہٹواؤں": "ہٹنا",
  "ہٹوائے": "ہٹنا",
  "ہٹوائی": "ہٹنا",
  "ہٹوائیے": "ہٹنا",
  "ہٹوائیں": "ہٹنا",
  "ہٹوایا": "ہٹنا",
  "ہٹی": "ہٹی",
  "ہٹیے": "ہٹنا",
  "ہٹیں": "ہٹنا",
  "ہٹیاں": "ہٹی",
  "ہٹیو": "ہٹی",
  "ہٹیوں": "ہٹی",
  "ہشکار": "ہشکارنا",
  "ہشکارے": "ہشکارنا",
  "ہشکارں": "ہشکارنا",
  "ہشکارا": "ہشکارنا",
  "ہشکارنے": "ہشکارنا",
  "ہشکارنا": "ہشکارنا",
  "ہشکارنی": "ہشکارنا",
  "ہشکارتے": "ہشکارنا",
  "ہشکارتا": "ہشکارنا",
  "ہشکارتی": "ہشکارنا",
  "ہشکارتیں": "ہشکارنا",
  "ہشکارو": "ہشکارنا",
  "ہشکاروں": "ہشکارنا",
  "ہشکاری": "ہشکارنا",
  "ہشکاریے": "ہشکارنا",
  "ہشکاریں": "ہشکارنا",
  "ہالے": "ہالہ",
  "ہالہ": "ہالہ",
  "ہالو": "ہالہ",
  "ہالوں": "ہالہ",
  "ہانپ": "ہانپنا",
  "ہانپے": "ہانپنا",
  "ہانپں": "ہانپنا",
  "ہانپا": "ہانپنا",
  "ہانپنے": "ہانپنا",
  "ہانپنا": "ہانپنا",
  "ہانپنی": "ہانپنا",
  "ہانپتے": "ہانپنا",
  "ہانپتا": "ہانپنا",
  "ہانپتی": "ہانپنا",
  "ہانپتیں": "ہانپنا",
  "ہانپو": "ہانپنا",
  "ہانپوں": "ہانپنا",
  "ہانپی": "ہانپنا",
  "ہانپیے": "ہانپنا",
  "ہانپیں": "ہانپنا",
  "ہار": "ہارنا",
  "ہارے": "ہارنا",
  "ہارں": "ہارنا",
  "ہارا": "ہارنا",
  "ہارنے": "ہارنا",
  "ہارنا": "ہارنا",
  "ہارنی": "ہارنا",
  "ہارتے": "ہارنا",
  "ہارتا": "ہارنا",
  "ہارتی": "ہارنا",
  "ہارتیں": "ہارنا",
  "ہارو": "ہارنا",
  "ہاروں": "ہارنا",
  "ہاری": "ہارنا",
  "ہاریے": "ہارنا",
  "ہاریں": "ہارنا",
  "ہاتھی": "ہاتھی",
  "ہاتھیو": "ہاتھی",
  "ہاتھیوں": "ہاتھی",
  "ہائے": "ہائے",
  "ہچکچا": "ہچکچانا",
  "ہچکچانے": "ہچکچانا",
  "ہچکچانا": "ہچکچانا",
  "ہچکچانی": "ہچکچانا",
  "ہچکچاتے": "ہچکچانا",
  "ہچکچاتا": "ہچکچانا",
  "ہچکچاتی": "ہچکچانا",
  "ہچکچاتیں": "ہچکچانا",
  "ہچکچاؤ": "ہچکچانا",
  "ہچکچاؤں": "ہچکچانا",
  "ہچکچائے": "ہچکچانا",
  "ہچکچائی": "ہچکچانا",
  "ہچکچائیے": "ہچکچانا",
  "ہچکچائیں": "ہچکچانا",
  "ہچکچایا": "ہچکچانا",
  "ہچکی": "ہچکی",
  "ہچکیاں": "ہچکی",
  "ہچکیو": "ہچکی",
  "ہچکیوں": "ہچکی",
  "ہدایت": "ہدایت",
  "ہدایتو": "ہدایت",
  "ہدایتوں": "ہدایت",
  "ہدایتیں": "ہدایت",
  "ہفت": "ہفت",
  "ہفتے": "ہفتہ",
  "ہفتہ": "ہفتہ",
  "ہفتو": "ہفتہ",
  "ہفتوں": "ہفتہ",
  "ہفتیں": "ہفت",
  "ہجرت": "ہجرت",
  "ہجرتو": "ہجرت",
  "ہجرتوں": "ہجرت",
  "ہجرتیں": "ہجرت",
  "ہجوم": "ہجوم",
  "ہجومو": "ہجوم",
  "ہجوموں": "ہجوم",
  "ہک": "ہک",
  "ہکو": "ہک",
  "ہکوں": "ہک",
  "ہل": "ہل",
  "ہلے": "ہلہ",
  "ہلں": "ہلنا",
  "ہلا": "ہلنا",
  "ہلاکت": "ہلاکت",
  "ہلاکتو": "ہلاکت",
  "ہلاکتوں": "ہلاکت",
  "ہلاکتیں": "ہلاکت",
  "ہلانے": "ہلنا",
  "ہلانا": "ہلنا",
  "ہلاتے": "ہلنا",
  "ہلاتا": "ہلنا",
  "ہلاتی": "ہلنا",
  "ہلاتیں": "ہلنا",
  "ہلاؤ": "ہلنا",
  "ہلاؤں": "ہلنا",
  "ہلائے": "ہلنا",
  "ہلائی": "ہلنا",
  "ہلائیے": "ہلنا",
  "ہلائیں": "ہلنا",
  "ہلایا": "ہلنا",
  "ہلہ": "ہلہ",
  "ہلنے": "ہلنا",
  "ہلنا": "ہلنا",
  "ہلنی": "ہلنا",
  "ہلتے": "ہلنا",
  "ہلتا": "ہلنا",
  "ہلتی": "ہلنا",
  "ہلتیں": "ہلنا",
  "ہلو": "ہلہ",
  "ہلوں": "ہلہ",
  "ہلوا": "ہلنا",
  "ہلوانے": "ہلنا",
  "ہلوانا": "ہلنا",
  "ہلواتے": "ہلنا",
  "ہلواتا": "ہلنا",
  "ہلواتی": "ہلنا",
  "ہلواتیں": "ہلنا",
  "ہلواؤ": "ہلنا",
  "ہلواؤں": "ہلنا",
  "ہلوائے": "ہلنا",
  "ہلوائی": "ہلنا",
  "ہلوائیے": "ہلنا",
  "ہلوائیں": "ہلنا",
  "ہلوایا": "ہلنا",
  "ہلی": "ہلنا",
  "ہلیے": "ہلنا",
  "ہلیں": "ہلنا",
  "ہم": "میں",
  "ہمارے": "ہمارہ",
  "ہمارہ": "ہمارہ",
  "ہمارو": "ہمارہ",
  "ہماروں": "ہمارہ",
  "ہمدرد": "ہمدرد",
  "ہمدردو": "ہمدرد",
  "ہمدردوں": "ہمدرد",
  "ہمدردی": "ہمدردی",
  "ہمدردیاں": "ہمدردی",
  "ہمدردیو": "ہمدردی",
  "ہمدردیوں": "ہمدردی",
  "ہمسایے": "ہمسایہ",
  "ہمسائیے": "ہمسائیہ",
  "ہمسائیہ": "ہمسائیہ",
  "ہمسائیو": "ہمسائیہ",
  "ہمسائیوں": "ہمسائیہ",
  "ہمسایہ": "ہمسایہ",
  "ہمسایو": "ہمسایہ",
  "ہمسایوں": "ہمسایہ",
  "ہمسفر": "ہمسفر",
  "ہمسفرو": "ہمسفر",
  "ہمسفروں": "ہمسفر",
  "ہمسر": "ہمسر",
  "ہمسرو": "ہمسر",
  "ہمسروں": "ہمسر",
  "ہمت": "ہمت",
  "ہمتو": "ہمت",
  "ہمتوں": "ہمت",
  "ہمتیں": "ہمت",
  "ہنڈے": "ہنڈا",
  "ہنڈا": "ہنڈا",
  "ہنڈو": "ہنڈا",
  "ہنڈوں": "ہنڈا",
  "ہنڈی": "ہنڈی",
  "ہنڈیا": "ہنڈیا",
  "ہنڈیاں": "ہنڈی",
  "ہنڈیو": "ہنڈی",
  "ہنڈیوں": "ہنڈی",
  "ہندسے": "ہندسہ",
  "ہندسہ": "ہندسہ",
  "ہندسو": "ہندسہ",
  "ہندسوں": "ہندسہ",
  "ہندو": "ہندو",
  "ہندوستانی": "ہندوستانی",
  "ہندوستانیو": "ہندوستانی",
  "ہندوستانیوں": "ہندوستانی",
  "ہندوؤ": "ہندو",
  "ہندوؤں": "ہندو",
  "ہنگامے": "ہنگاما",
  "ہنگاما": "ہنگاما",
  "ہنگامہ": "ہنگامہ",
  "ہنگامو": "ہنگاما",
  "ہنگاموں": "ہنگاما",
  "ہنہنا": "ہنہنانا",
  "ہنہنانے": "ہنہنانا",
  "ہنہنانا": "ہنہنانا",
  "ہنہنانی": "ہنہنانا",
  "ہنہناتے": "ہنہنانا",
  "ہنہناتا": "ہنہنانا",
  "ہنہناتی": "ہنہنانا",
  "ہنہناتیں": "ہنہنانا",
  "ہنہناؤ": "ہنہنانا",
  "ہنہناؤں": "ہنہنانا",
  "ہنہنائے": "ہنہنانا",
  "ہنہنائی": "ہنہنانا",
  "ہنہنائیے": "ہنہنانا",
  "ہنہنائیں": "ہنہنانا",
  "ہنہنایا": "ہنہنانا",
  "ہنکار": "ہنکارنا",
  "ہنکارے": "ہنکارنا",
  "ہنکارں": "ہنکارنا",
  "ہنکارا": "ہنکارنا",
  "ہنکارنے": "ہنکارنا",
  "ہنکارنا": "ہنکارنا",
  "ہنکارنی": "ہنکارنا",
  "ہنکارتے": "ہنکارنا",
  "ہنکارتا": "ہنکارنا",
  "ہنکارتی": "ہنکارنا",
  "ہنکارتیں": "ہنکارنا",
  "ہنکارو": "ہنکارنا",
  "ہنکاروں": "ہنکارنا",
  "ہنکاری": "ہنکارنا",
  "ہنکاریے": "ہنکارنا",
  "ہنکاریں": "ہنکارنا",
  "ہنرمند": "ہنرمند",
  "ہنرمندو": "ہنرمند",
  "ہنرمندوں": "ہنرمند",
  "ہنس": "ہنس",
  "ہنسے": "ہنسنا",
  "ہنسں": "ہنسنا",
  "ہنسا": "ہنسنا",
  "ہنسانے": "ہنسنا",
  "ہنسانا": "ہنسنا",
  "ہنساتے": "ہنسنا",
  "ہنساتا": "ہنسنا",
  "ہنساتی": "ہنسنا",
  "ہنساتیں": "ہنسنا",
  "ہنساؤ": "ہنسنا",
  "ہنساؤں": "ہنسنا",
  "ہنسائے": "ہنسنا",
  "ہنسائی": "ہنسنا",
  "ہنسائیے": "ہنسنا",
  "ہنسائیں": "ہنسنا",
  "ہنسایا": "ہنسنا",
  "ہنسنے": "ہنسنا",
  "ہنسنا": "ہنسنا",
  "ہنسنی": "ہنسنا",
  "ہنستے": "ہنسنا",
  "ہنستا": "ہنسنا",
  "ہنستی": "ہنسنا",
  "ہنستیں": "ہنسنا",
  "ہنسو": "ہنس",
  "ہنسوں": "ہنس",
  "ہنسوا": "ہنسنا",
  "ہنسوانے": "ہنسنا",
  "ہنسوانا": "ہنسنا",
  "ہنسواتے": "ہنسنا",
  "ہنسواتا": "ہنسنا",
  "ہنسواتی": "ہنسنا",
  "ہنسواتیں": "ہنسنا",
  "ہنسواؤ": "ہنسنا",
  "ہنسواؤں": "ہنسنا",
  "ہنسوائے": "ہنسنا",
  "ہنسوائی": "ہنسنا",
  "ہنسوائیے": "ہنسنا",
  "ہنسوائیں": "ہنسنا",
  "ہنسوایا": "ہنسنا",
  "ہنسی": "ہنسنا",
  "ہنسیے": "ہنسنا",
  "ہنسیں": "ہنسنا",
  "ہپی": "ہپی",
  "ہپیو": "ہپی",
  "ہپیوں": "ہپی",
  "ہر": "ہرنا",
  "ہرے": "ہرا",
  "ہرں": "ہرنا",
  "ہرا": "ہرا",
  "ہرانے": "ہارنا",
  "ہرانا": "ہارنا",
  "ہراتے": "ہارنا",
  "ہراتا": "ہارنا",
  "ہراتی": "ہارنا",
  "ہراتیں": "ہارنا",
  "ہراؤ": "ہارنا",
  "ہراؤں": "ہارنا",
  "ہرائے": "ہارنا",
  "ہرائی": "ہارنا",
  "ہرائیے": "ہارنا",
  "ہرائیں": "ہارنا",
  "ہرایا": "ہارنا",
  "ہرکارے": "ہرکارہ",
  "ہرکارہ": "ہرکارہ",
  "ہرکارو": "ہرکارہ",
  "ہرکاروں": "ہرکارہ",
  "ہرن": "ہرن",
  "ہرنے": "ہرنا",
  "ہرنا": "ہرنا",
  "ہرنو": "ہرن",
  "ہرنوں": "ہرن",
  "ہرنی": "ہرنی",
  "ہرنیں": "ہرن",
  "ہرنیاں": "ہرنی",
  "ہرنیو": "ہرنی",
  "ہرنیوں": "ہرنی",
  "ہرتے": "ہرنا",
  "ہرتا": "ہرنا",
  "ہرتی": "ہرنا",
  "ہرتیں": "ہرنا",
  "ہرو": "ہرا",
  "ہروں": "ہرا",
  "ہروا": "ہارنا",
  "ہروانے": "ہارنا",
  "ہروانا": "ہارنا",
  "ہرواتے": "ہارنا",
  "ہرواتا": "ہارنا",
  "ہرواتی": "ہارنا",
  "ہرواتیں": "ہارنا",
  "ہرواؤ": "ہارنا",
  "ہرواؤں": "ہارنا",
  "ہروائے": "ہارنا",
  "ہروائی": "ہارنا",
  "ہروائیے": "ہارنا",
  "ہروائیں": "ہارنا",
  "ہروایا": "ہارنا",
  "ہری": "ہرنا",
  "ہریے": "ہرنا",
  "ہریں": "ہرنا",
  "ہس": "ہسنا",
  "ہسے": "ہسنا",
  "ہسں": "ہسنا",
  "ہسا": "ہسنا",
  "ہسانے": "ہسنا",
  "ہسانا": "ہسنا",
  "ہساتے": "ہسنا",
  "ہساتا": "ہسنا",
  "ہساتی": "ہسنا",
  "ہساتیں": "ہسنا",
  "ہساؤ": "ہسنا",
  "ہساؤں": "ہسنا",
  "ہسائے": "ہسنا",
  "ہسائی": "ہسنا",
  "ہسائیے": "ہسنا",
  "ہسائیں": "ہسنا",
  "ہسایا": "ہسنا",
  "ہسنے": "ہسنا",
  "ہسنا": "ہسنا",
  "ہسنی": "ہسنا",
  "ہسپتال": "ہسپتال",
  "ہسپتالو": "ہسپتال",
  "ہسپتالوں": "ہسپتال",
  "ہستے": "ہسنا",
  "ہستا": "ہسنا",
  "ہستی": "ہستی",
  "ہستیں": "ہسنا",
  "ہستیاں": "ہستی",
  "ہستیو": "ہستی",
  "ہستیوں": "ہستی",
  "ہسو": "ہسنا",
  "ہسوں": "ہسنا",
  "ہسوا": "ہسنا",
  "ہسوانے": "ہسنا",
  "ہسوانا": "ہسنا",
  "ہسواتے": "ہسنا",
  "ہسواتا": "ہسنا",
  "ہسواتی": "ہسنا",
  "ہسواتیں": "ہسنا",
  "ہسواؤ": "ہسنا",
  "ہسواؤں": "ہسنا",
  "ہسوائے": "ہسنا",
  "ہسوائی": "ہسنا",
  "ہسوائیے": "ہسنا",
  "ہسوائیں": "ہسنا",
  "ہسوایا": "ہسنا",
  "ہسی": "ہسنا",
  "ہسیے": "ہسنا",
  "ہسیں": "ہسنا",
  "ہتھکڑی": "ہتھکڑی",
  "ہتھکڑیاں": "ہتھکڑی",
  "ہتھکڑیو": "ہتھکڑی",
  "ہتھکڑیوں": "ہتھکڑی",
  "ہتھیا": "ہتھیانا",
  "ہتھیانے": "ہتھیانا",
  "ہتھیانا": "ہتھیانا",
  "ہتھیانی": "ہتھیانا",
  "ہتھیار": "ہتھیار",
  "ہتھیارو": "ہتھیار",
  "ہتھیاروں": "ہتھیار",
  "ہتھیاتے": "ہتھیانا",
  "ہتھیاتا": "ہتھیانا",
  "ہتھیاتی": "ہتھیانا",
  "ہتھیاتیں": "ہتھیانا",
  "ہتھیاؤ": "ہتھیانا",
  "ہتھیاؤں": "ہتھیانا",
  "ہتھیائے": "ہتھیانا",
  "ہتھیائی": "ہتھیانا",
  "ہتھیائیے": "ہتھیانا",
  "ہتھیائیں": "ہتھیانا",
  "ہتھیایا": "ہتھیانا",
  "ہتھیلی": "ہتھیلی",
  "ہتھیلیاں": "ہتھیلی",
  "ہتھیلیو": "ہتھیلی",
  "ہتھیلیوں": "ہتھیلی",
  "ہو": "ہونا",
  "ہوں": "ہونا",
  "ہوں گے": "ہونا",
  "ہوں گا": "ہونا",
  "ہوں گی": "ہونا",
  "ہوٹل": "ہوٹل",
  "ہوٹلو": "ہوٹل",
  "ہوٹلوں": "ہوٹل",
  "ہوا": "ہوا",
  "ہواں": "ہواں",
  "ہوادار": "ہوادار",
  "ہوادارو": "ہوادار",
  "ہواداروں": "ہوادار",
  "ہواؤ": "ہوا",
  "ہواؤں": "ہوا",
  "ہوائی": "ہوائی",
  "ہوائیں": "ہوا",
  "ہوائیاں": "ہوائی",
  "ہوائیو": "ہوائی",
  "ہوائیوں": "ہوائی",
  "ہودے": "ہودہ",
  "ہودہ": "ہودہ",
  "ہودو": "ہودہ",
  "ہودوں": "ہودہ",
  "ہوگے": "ہونا",
  "ہوگا": "ہونا",
  "ہوگی": "ہونا",
  "ہوجا": "ہوجانا",
  "ہوجانے": "ہوجانا",
  "ہوجانا": "ہوجانا",
  "ہوجانی": "ہوجانا",
  "ہوجاتے": "ہوجانا",
  "ہوجاتا": "ہوجانا",
  "ہوجاتی": "ہوجانا",
  "ہوجاتیں": "ہوجانا",
  "ہوجاؤ": "ہوجانا",
  "ہوجاؤں": "ہوجانا",
  "ہوجائے": "ہوجانا",
  "ہوجائی": "ہوجانا",
  "ہوجائیے": "ہوجانا",
  "ہوجائیں": "ہوجانا",
  "ہوجایا": "ہوجانا",
  "ہولاؤ": "ہولاؤ",
  "ہولناکی": "ہولناکی",
  "ہولناکیاں": "ہولناکی",
  "ہولناکیو": "ہولناکی",
  "ہولناکیوں": "ہولناکی",
  "ہونے": "ہونا",
  "ہونٹ": "ہونٹ",
  "ہونٹو": "ہونٹ",
  "ہونٹوں": "ہونٹ",
  "ہونا": "ہونا",
  "ہونی": "ہونا",
  "ہوس": "ہوس",
  "ہوسو": "ہوس",
  "ہوسوں": "ہوس",
  "ہوتے": "ہونا",
  "ہوتا": "ہونا",
  "ہوتی": "ہونا",
  "ہوتیں": "ہونا",
  "ہووںں": "ہواں",
  "ہوؤں": "ہونا",
  "ہویں": "ہواں",
  "ہوئے": "ہونا",
  "ہوئی": "ہونا",
  "ہوئیے": "ہونا",
  "ہوئیں": "ہونا",
  "ہی": "ہی",
  "ہیں": "ہونا",
  "ہیجڑے": "ہیجڑا",
  "ہیجڑا": "ہیجڑا",
  "ہیجڑو": "ہیجڑا",
  "ہیجڑوں": "ہیجڑا",
  "ہیکر": "ہیکر",
  "ہیکرو": "ہیکر",
  "ہیکروں": "ہیکر",
  "ہیرے": "ہیرا",
  "ہیرا": "ہیرا",
  "ہیرو": "ہیرا",
  "ہیروں": "ہیرا",
  "ہیئت": "ہیئت",
  "ہیئتو": "ہیئت",
  "ہیئتوں": "ہیئت",
  "ہیئتیں": "ہیئت",
  "ہیضے": "ہیضہ",
  "ہیضہ": "ہیضہ",
  "ہیضو": "ہیضہ",
  "ہیضوں": "ہیضہ",
  "ہزار": "ہزار",
  "ہزارے": "ہزارہ",
  "ہزارہ": "ہزارہ",
  "ہزارو": "ہزارہ",
  "ہزاروں": "ہزارہ",
  "جَب": "جَب",
  "جَہاں": "جَہاں",
  "جَونسے": "جَونسا",
  "جَونسا": "جَونسا",
  "جَونسی": "جَونسا",
  "جَیسے": "جَیسا",
  "جَیسا": "جَیسا",
  "جَیسی": "جَیسا",
  "جِدَھر": "جِدَھر",
  "جِن": "جِن",
  "جِنو": "جِن",
  "جِنوں": "جِن",
  "جِس": "جو",
  "جِھری": "جِھری",
  "جِھریاں": "جِھری",
  "جِھریو": "جِھری",
  "جِھریوں": "جِھری",
  "جُوں": "جُوں",
  "جُوتی": "جُوتی",
  "جُوتیاں": "جُوتی",
  "جُوتیو": "جُوتی",
  "جُوتیوں": "جُوتی",
  "جُوؤں": "جُوں",
  "جُوئیں": "جُوں",
  "جُھک": "جُھکنا",
  "جُھکے": "جُھکنا",
  "جُھکں": "جُھکنا",
  "جُھکا": "جُھکنا",
  "جُھکانے": "جُھکنا",
  "جُھکانا": "جُھکنا",
  "جُھکاتے": "جُھکنا",
  "جُھکاتا": "جُھکنا",
  "جُھکاتی": "جُھکنا",
  "جُھکاتیں": "جُھکنا",
  "جُھکاؤ": "جُھکنا",
  "جُھکاؤں": "جُھکنا",
  "جُھکائے": "جُھکنا",
  "جُھکائی": "جُھکنا",
  "جُھکائیے": "جُھکنا",
  "جُھکائیں": "جُھکنا",
  "جُھکایا": "جُھکنا",
  "جُھکنے": "جُھکنا",
  "جُھکنا": "جُھکنا",
  "جُھکنی": "جُھکنا",
  "جُھکتے": "جُھکنا",
  "جُھکتا": "جُھکنا",
  "جُھکتی": "جُھکنا",
  "جُھکتیں": "جُھکنا",
  "جُھکو": "جُھکنا",
  "جُھکوں": "جُھکنا",
  "جُھکوا": "جُھکنا",
  "جُھکوانے": "جُھکنا",
  "جُھکوانا": "جُھکنا",
  "جُھکواتے": "جُھکنا",
  "جُھکواتا": "جُھکنا",
  "جُھکواتی": "جُھکنا",
  "جُھکواتیں": "جُھکنا",
  "جُھکواؤ": "جُھکنا",
  "جُھکواؤں": "جُھکنا",
  "جُھکوائے": "جُھکنا",
  "جُھکوائی": "جُھکنا",
  "جُھکوائیے": "جُھکنا",
  "جُھکوائیں": "جُھکنا",
  "جُھکوایا": "جُھکنا",
  "جُھکی": "جُھکنا",
  "جُھکیے": "جُھکنا",
  "جُھکیں": "جُھکنا",
  "جغرافیے": "جغرافیہ",
  "جغرافیہ": "جغرافیہ",
  "جغرافیو": "جغرافیہ",
  "جغرافیوں": "جغرافیہ",
  "جڑ": "جڑ",
  "جڑے": "جڑنا",
  "جڑں": "جڑنا",
  "جڑا": "جڑنا",
  "جڑانے": "جڑنا",
  "جڑانا": "جڑنا",
  "جڑاتے": "جڑنا",
  "جڑاتا": "جڑنا",
  "جڑاتی": "جڑنا",
  "جڑاتیں": "جڑنا",
  "جڑاؤ": "جڑنا",
  "جڑاؤں": "جڑنا",
  "جڑائے": "جڑنا",
  "جڑائی": "جڑنا",
  "جڑائیے": "جڑنا",
  "جڑائیں": "جڑنا",
  "جڑایا": "جڑنا",
  "جڑنے": "جڑنا",
  "جڑنا": "جڑنا",
  "جڑنی": "جڑنا",
  "جڑتے": "جڑنا",
  "جڑتا": "جڑنا",
  "جڑتی": "جڑنا",
  "جڑتیں": "جڑنا",
  "جڑو": "جڑ",
  "جڑوں": "جڑ",
  "جڑوا": "جڑنا",
  "جڑوانے": "جڑنا",
  "جڑوانا": "جڑنا",
  "جڑواتے": "جڑنا",
  "جڑواتا": "جڑنا",
  "جڑواتی": "جڑنا",
  "جڑواتیں": "جڑنا",
  "جڑواؤ": "جڑنا",
  "جڑواؤں": "جڑنا",
  "جڑوائے": "جڑنا",
  "جڑوائی": "جڑنا",
  "جڑوائیے": "جڑنا",
  "جڑوائیں": "جڑنا",
  "جڑوایا": "جڑنا",
  "جڑی": "جڑنا",
  "جڑیے": "جڑنا",
  "جڑیں": "جڑ",
  "جٹ": "جٹ",
  "جٹے": "جٹا",
  "جٹا": "جٹا",
  "جٹو": "جٹا",
  "جٹوں": "جٹا",
  "جذب": "جذب",
  "جذبے": "جذبہ",
  "جذبہ": "جذبہ",
  "جذبو": "جذبہ",
  "جذبوں": "جذبہ",
  "جا": "جانا",
  "جاڑ": "جاڑ",
  "جاڑے": "جاڑا",
  "جاڑا": "جاڑا",
  "جاڑو": "جاڑا",
  "جاڑوں": "جاڑا",
  "جاٹ": "جاٹ",
  "جاٹو": "جاٹ",
  "جاٹوں": "جاٹ",
  "جاٹیں": "جاٹ",
  "جابر": "جابر",
  "جابرو": "جابر",
  "جابروں": "جابر",
  "جادوگر": "جادوگر",
  "جادوگرو": "جادوگر",
  "جادوگروں": "جادوگر",
  "جاگ": "جاگ",
  "جاگْں": "جاگْنا",
  "جاگْنے": "جاگْنا",
  "جاگْنا": "جاگْنا",
  "جاگْنی": "جاگْنا",
  "جاگْتے": "جاگْنا",
  "جاگْتا": "جاگْنا",
  "جاگْتی": "جاگْنا",
  "جاگْتیں": "جاگْنا",
  "جاگے": "جاگْنا",
  "جاگں": "جاگنا",
  "جاگا": "جاگْنا",
  "جاگانے": "جاگنا",
  "جاگانا": "جاگنا",
  "جاگاتے": "جاگنا",
  "جاگاتا": "جاگنا",
  "جاگاتی": "جاگنا",
  "جاگاتیں": "جاگنا",
  "جاگاؤ": "جاگنا",
  "جاگاؤں": "جاگنا",
  "جاگائے": "جاگنا",
  "جاگائی": "جاگنا",
  "جاگائیے": "جاگنا",
  "جاگائیں": "جاگنا",
  "جاگایا": "جاگنا",
  "جاگنے": "جاگنا",
  "جاگنا": "جاگنا",
  "جاگنی": "جاگنا",
  "جاگتے": "جاگنا",
  "جاگتا": "جاگنا",
  "جاگتی": "جاگنا",
  "جاگتیں": "جاگنا",
  "جاگو": "جاگ",
  "جاگوں": "جاگ",
  "جاگی": "جاگْنا",
  "جاگیے": "جاگْنا",
  "جاگیں": "جاگ",
  "جاگیر": "جاگیر",
  "جاگیردار": "جاگیردار",
  "جاگیردارو": "جاگیردار",
  "جاگیرداروں": "جاگیردار",
  "جاگیرو": "جاگیر",
  "جاگیروں": "جاگیر",
  "جاگیریں": "جاگیر",
  "جاہل": "جاہل",
  "جاہلو": "جاہل",
  "جاہلوں": "جاہل",
  "جال": "جال",
  "جالے": "جالا",
  "جالا": "جالا",
  "جالو": "جالا",
  "جالوں": "جالا",
  "جامے": "جامہ",
  "جامہ": "جامہ",
  "جامن": "جامن",
  "جامنو": "جامن",
  "جامنوں": "جامن",
  "جامو": "جامہ",
  "جاموں": "جامہ",
  "جان": "جان",
  "جانے": "جاننا",
  "جانں": "جاننا",
  "جانشین": "جانشین",
  "جانشینو": "جانشین",
  "جانشینوں": "جانشین",
  "جانا": "جاننا",
  "جانچ": "جانچ",
  "جانچے": "جانچنا",
  "جانچں": "جانچنا",
  "جانچا": "جانچنا",
  "جانچنے": "جانچنا",
  "جانچنا": "جانچنا",
  "جانچنی": "جانچنا",
  "جانچتے": "جانچنا",
  "جانچتا": "جانچنا",
  "جانچتی": "جانچنا",
  "جانچتیں": "جانچنا",
  "جانچو": "جانچ",
  "جانچوں": "جانچ",
  "جانچوا": "جانچنا",
  "جانچوانے": "جانچنا",
  "جانچوانا": "جانچنا",
  "جانچواتے": "جانچنا",
  "جانچواتا": "جانچنا",
  "جانچواتی": "جانچنا",
  "جانچواتیں": "جانچنا",
  "جانچواؤ": "جانچنا",
  "جانچواؤں": "جانچنا",
  "جانچوائے": "جانچنا",
  "جانچوائی": "جانچنا",
  "جانچوائیے": "جانچنا",
  "جانچوائیں": "جانچنا",
  "جانچوایا": "جانچنا",
  "جانچی": "جانچنا",
  "جانچیے": "جانچنا",
  "جانچیں": "جانچنا",
  "جاندار": "جاندار",
  "جاندارو": "جاندار",
  "جانداروں": "جاندار",
  "جاننے": "جاننا",
  "جاننا": "جاننا",
  "جاننی": "جاننا",
  "جانتے": "جاننا",
  "جانتا": "جاننا",
  "جانتی": "جاننا",
  "جانتیں": "جاننا",
  "جانو": "جان",
  "جانوں": "جان",
  "جانور": "جانور",
  "جانورو": "جانور",
  "جانوروں": "جانور",
  "جانی": "جاننا",
  "جانیے": "جاننا",
  "جانیں": "جاننا",
  "جاپانی": "جاپانی",
  "جاپانیو": "جاپانی",
  "جاپانیوں": "جاپانی",
  "جاسکت": "جاسکت",
  "جاسکتو": "جاسکت",
  "جاسکتوں": "جاسکت",
  "جاسکتیں": "جاسکت",
  "جاسوس": "جاسوس",
  "جاسوسے": "جاسوسہ",
  "جاسوسہ": "جاسوسہ",
  "جاسوسو": "جاسوسہ",
  "جاسوسوں": "جاسوسہ",
  "جات": "جات",
  "جاتے": "جانا",
  "جاتا": "جانا",
  "جاتو": "جات",
  "جاتوں": "جات",
  "جاتی": "جانا",
  "جاتیں": "جات",
  "جاو": "جانا",
  "جاوں": "جانا",
  "جاواں": "جاواں",
  "جاووںں": "جاواں",
  "جاویں": "جاواں",
  "جائی": "جائی",
  "جائیاں": "جائی",
  "جائیداد": "جائیداد",
  "جائیدادو": "جائیداد",
  "جائیدادوں": "جائیداد",
  "جائیدادیں": "جائیداد",
  "جائیو": "جائی",
  "جائیوں": "جائی",
  "جائزے": "جائزہ",
  "جائزہ": "جائزہ",
  "جائزو": "جائزہ",
  "جائزوں": "جائزہ",
  "جب": "جَب",
  "جبے": "جبہ",
  "جبہ": "جبہ",
  "جبکہ": "جبکہ",
  "جبلت": "جبلت",
  "جبلتو": "جبلت",
  "جبلتوں": "جبلت",
  "جبلتیں": "جبلت",
  "جبر": "جبر",
  "جبرو": "جبر",
  "جبروں": "جبر",
  "جبتک": "جبتک",
  "جبو": "جبہ",
  "جبوں": "جبہ",
  "جچ": "جچنا",
  "جچے": "جچنا",
  "جچں": "جچنا",
  "جچا": "جچنا",
  "جچانے": "جچنا",
  "جچانا": "جچنا",
  "جچاتے": "جچنا",
  "جچاتا": "جچنا",
  "جچاتی": "جچنا",
  "جچاتیں": "جچنا",
  "جچاؤ": "جچنا",
  "جچاؤں": "جچنا",
  "جچائے": "جچنا",
  "جچائی": "جچنا",
  "جچائیے": "جچنا",
  "جچائیں": "جچنا",
  "جچایا": "جچنا",
  "جچنے": "جچنا",
  "جچنا": "جچنا",
  "جچنی": "جچنا",
  "جچتے": "جچنا",
  "جچتا": "جچنا",
  "جچتی": "جچنا",
  "جچتیں": "جچنا",
  "جچو": "جچنا",
  "جچوں": "جچنا",
  "جچوا": "جچنا",
  "جچوانے": "جچنا",
  "جچوانا": "جچنا",
  "جچواتے": "جچنا",
  "جچواتا": "جچنا",
  "جچواتی": "جچنا",
  "جچواتیں": "جچنا",
  "جچواؤ": "جچنا",
  "جچواؤں": "جچنا",
  "جچوائے": "جچنا",
  "جچوائی": "جچنا",
  "جچوائیے": "جچنا",
  "جچوائیں": "جچنا",
  "جچوایا": "جچنا",
  "جچی": "جچنا",
  "جچیے": "جچنا",
  "جچیں": "جچنا",
  "جدا": "جدا",
  "جدائی": "جدائی",
  "جدائیاں": "جدائی",
  "جدائیو": "جدائی",
  "جدائیوں": "جدائی",
  "جدید": "جدید",
  "جدھر": "جِدَھر",
  "جفا": "جفا",
  "جفاؤ": "جفا",
  "جفاؤں": "جفا",
  "جفائیں": "جفا",
  "جگ": "جگنا",
  "جگْوا": "جاگْنا",
  "جگْوانے": "جاگْنا",
  "جگْوانا": "جاگْنا",
  "جگْواتے": "جاگْنا",
  "جگْواتا": "جاگْنا",
  "جگْواتی": "جاگْنا",
  "جگْواتیں": "جاگْنا",
  "جگْواؤ": "جاگْنا",
  "جگْواؤں": "جاگْنا",
  "جگْوائے": "جاگْنا",
  "جگْوائی": "جاگْنا",
  "جگْوائیے": "جاگْنا",
  "جگْوائیں": "جاگْنا",
  "جگْوایا": "جاگْنا",
  "جگے": "جگنا",
  "جگں": "جگنا",
  "جگا": "جاگْنا",
  "جگانے": "جاگْنا",
  "جگانا": "جاگْنا",
  "جگاتے": "جاگْنا",
  "جگاتا": "جاگْنا",
  "جگاتی": "جاگْنا",
  "جگاتیں": "جاگْنا",
  "جگاؤ": "جاگْنا",
  "جگاؤں": "جاگْنا",
  "جگائے": "جاگْنا",
  "جگائی": "جاگْنا",
  "جگائیے": "جاگْنا",
  "جگائیں": "جاگْنا",
  "جگایا": "جاگْنا",
  "جگہ": "جگہ",
  "جگہو": "جگہ",
  "جگہوں": "جگہ",
  "جگہیں": "جگہ",
  "جگمگا": "جگمگانا",
  "جگمگانے": "جگمگانا",
  "جگمگانا": "جگمگانا",
  "جگمگانی": "جگمگانا",
  "جگمگاتے": "جگمگانا",
  "جگمگاتا": "جگمگانا",
  "جگمگاتی": "جگمگانا",
  "جگمگاتیں": "جگمگانا",
  "جگمگاؤ": "جگمگانا",
  "جگمگاؤں": "جگمگانا",
  "جگمگائے": "جگمگانا",
  "جگمگائی": "جگمگانا",
  "جگمگائیے": "جگمگانا",
  "جگمگائیں": "جگمگانا",
  "جگمگایا": "جگمگانا",
  "جگنے": "جگنا",
  "جگنا": "جگنا",
  "جگنو": "جگنو",
  "جگنوؤ": "جگنو",
  "جگنوؤں": "جگنو",
  "جگنی": "جگنا",
  "جگتے": "جگنا",
  "جگتا": "جگنا",
  "جگتی": "جگنا",
  "جگتیں": "جگنا",
  "جگو": "جگنا",
  "جگوں": "جگنا",
  "جگوا": "جاگنا",
  "جگوانے": "جاگنا",
  "جگوانا": "جاگنا",
  "جگواتے": "جاگنا",
  "جگواتا": "جاگنا",
  "جگواتی": "جاگنا",
  "جگواتیں": "جاگنا",
  "جگواؤ": "جاگنا",
  "جگواؤں": "جاگنا",
  "جگوائے": "جاگنا",
  "جگوائی": "جاگنا",
  "جگوائیے": "جاگنا",
  "جگوائیں": "جاگنا",
  "جگوایا": "جاگنا",
  "جگی": "جگنا",
  "جگیے": "جگنا",
  "جگیں": "جگنا",
  "جہاں": "جَہاں",
  "جہان": "جہان",
  "جہانو": "جہان",
  "جہانوں": "جہان",
  "جہاز": "جہاز",
  "جہازو": "جہاز",
  "جہازوں": "جہاز",
  "جہنمی": "جہنمی",
  "جہنمیو": "جہنمی",
  "جہنمیوں": "جہنمی",
  "جہت": "جہت",
  "جہتو": "جہت",
  "جہتوں": "جہت",
  "جہتیں": "جہت",
  "جج": "جج",
  "ججو": "جج",
  "ججوں": "جج",
  "جکڑ": "جکڑنا",
  "جکڑے": "جکڑنا",
  "جکڑں": "جکڑنا",
  "جکڑا": "جکڑنا",
  "جکڑانے": "جکڑنا",
  "جکڑانا": "جکڑنا",
  "جکڑاتے": "جکڑنا",
  "جکڑاتا": "جکڑنا",
  "جکڑاتی": "جکڑنا",
  "جکڑاتیں": "جکڑنا",
  "جکڑاؤ": "جکڑنا",
  "جکڑاؤں": "جکڑنا",
  "جکڑائے": "جکڑنا",
  "جکڑائی": "جکڑنا",
  "جکڑائیے": "جکڑنا",
  "جکڑائیں": "جکڑنا",
  "جکڑایا": "جکڑنا",
  "جکڑنے": "جکڑنا",
  "جکڑنا": "جکڑنا",
  "جکڑنی": "جکڑنا",
  "جکڑتے": "جکڑنا",
  "جکڑتا": "جکڑنا",
  "جکڑتی": "جکڑنا",
  "جکڑتیں": "جکڑنا",
  "جکڑو": "جکڑنا",
  "جکڑوں": "جکڑنا",
  "جکڑوا": "جکڑنا",
  "جکڑوانے": "جکڑنا",
  "جکڑوانا": "جکڑنا",
  "جکڑواتے": "جکڑنا",
  "جکڑواتا": "جکڑنا",
  "جکڑواتی": "جکڑنا",
  "جکڑواتیں": "جکڑنا",
  "جکڑواؤ": "جکڑنا",
  "جکڑواؤں": "جکڑنا",
  "جکڑوائے": "جکڑنا",
  "جکڑوائی": "جکڑنا",
  "جکڑوائیے": "جکڑنا",
  "جکڑوائیں": "جکڑنا",
  "جکڑوایا": "جکڑنا",
  "جکڑی": "جکڑنا",
  "جکڑیے": "جکڑنا",
  "جکڑیں": "جکڑنا",
  "جل": "جلنا",
  "جلے": "جلنا",
  "جلں": "جلنا",
  "جلا": "جلنا",
  "جلاد": "جلاد",
  "جلادو": "جلاد",
  "جلادوں": "جلاد",
  "جلانے": "جلنا",
  "جلانا": "جلنا",
  "جلاتے": "جلنا",
  "جلاتا": "جلنا",
  "جلاتی": "جلنا",
  "جلاتیں": "جلنا",
  "جلاؤ": "جلنا",
  "جلاؤں": "جلنا",
  "جلائے": "جلنا",
  "جلائی": "جلنا",
  "جلائیے": "جلنا",
  "جلائیں": "جلنا",
  "جلایا": "جلنا",
  "جلد": "جلد",
  "جلدو": "جلد",
  "جلدوں": "جلد",
  "جلدیں": "جلد",
  "جلنے": "جلنا",
  "جلنا": "جلنا",
  "جلنی": "جلنا",
  "جلسے": "جلسہ",
  "جلسہ": "جلسہ",
  "جلسو": "جلسہ",
  "جلسوں": "جلسہ",
  "جلتے": "جلنا",
  "جلتا": "جلنا",
  "جلتی": "جلنا",
  "جلتیں": "جلنا",
  "جلو": "جلنا",
  "جلوے": "جلوا",
  "جلوں": "جلنا",
  "جلوا": "جلوا",
  "جلوانے": "جلنا",
  "جلوانا": "جلنا",
  "جلواتے": "جلنا",
  "جلواتا": "جلنا",
  "جلواتی": "جلنا",
  "جلواتیں": "جلنا",
  "جلواؤ": "جلنا",
  "جلواؤں": "جلنا",
  "جلوائے": "جلنا",
  "جلوائی": "جلنا",
  "جلوائیے": "جلنا",
  "جلوائیں": "جلنا",
  "جلوایا": "جلنا",
  "جلوہ": "جلوہ",
  "جلوس": "جلوس",
  "جلوسو": "جلوس",
  "جلوسوں": "جلوس",
  "جلوو": "جلوا",
  "جلووں": "جلوا",
  "جلی": "جلنا",
  "جلیے": "جلنا",
  "جلیں": "جلنا",
  "جلیبی": "جلیبی",
  "جلیبیاں": "جلیبی",
  "جلیبیو": "جلیبی",
  "جلیبیوں": "جلیبی",
  "جم": "جمنا",
  "جمے": "جمنا",
  "جمں": "جمنا",
  "جما": "جمنا",
  "جماعت": "جماعت",
  "جماعتو": "جماعت",
  "جماعتوں": "جماعت",
  "جماعتیں": "جماعت",
  "جمانے": "جمنا",
  "جمانا": "جمنا",
  "جماتے": "جمنا",
  "جماتا": "جمنا",
  "جماتی": "جمنا",
  "جماتیں": "جمنا",
  "جماؤ": "جمنا",
  "جماؤں": "جمنا",
  "جمائے": "جمنا",
  "جمائی": "جمائی",
  "جمائیے": "جمنا",
  "جمائیں": "جمنا",
  "جمائیاں": "جمائی",
  "جمائیو": "جمائی",
  "جمائیوں": "جمائی",
  "جمایا": "جمنا",
  "جمعے": "جمعہ",
  "جمعہ": "جمعہ",
  "جمعرات": "جمعرات",
  "جمعراتو": "جمعرات",
  "جمعراتوں": "جمعرات",
  "جمعراتیں": "جمعرات",
  "جمعو": "جمعہ",
  "جمعوں": "جمعہ",
  "جملے": "جملہ",
  "جملہ": "جملہ",
  "جملو": "جملہ",
  "جملوں": "جملہ",
  "جمنے": "جمنا",
  "جمنا": "جمنا",
  "جمنی": "جمنا",
  "جمتے": "جمنا",
  "جمتا": "جمنا",
  "جمتی": "جمنا",
  "جمتیں": "جمنا",
  "جمو": "جمنا",
  "جموں": "جمنا",
  "جموا": "جمنا",
  "جموانے": "جمنا",
  "جموانا": "جمنا",
  "جمواتے": "جمنا",
  "جمواتا": "جمنا",
  "جمواتی": "جمنا",
  "جمواتیں": "جمنا",
  "جمواؤ": "جمنا",
  "جمواؤں": "جمنا",
  "جموائے": "جمنا",
  "جموائی": "جمنا",
  "جموائیے": "جمنا",
  "جموائیں": "جمنا",
  "جموایا": "جمنا",
  "جمی": "جمنا",
  "جمیے": "جمنا",
  "جمیں": "جمنا",
  "جن": "جن",
  "جنّ": "جنّ",
  "جنّت": "جنّت",
  "جنّتو": "جنّت",
  "جنّتوں": "جنّت",
  "جنّتیں": "جنّت",
  "جنّو": "جنّ",
  "جنّوں": "جنّ",
  "جنے": "جننا",
  "جنں": "جننا",
  "جنا": "جننا",
  "جنات": "جن",
  "جناتو": "جنات",
  "جناتوں": "جنات",
  "جناتیں": "جنات",
  "جنازے": "جنازہ",
  "جنازہ": "جنازہ",
  "جنازو": "جنازہ",
  "جنازوں": "جنازہ",
  "جنگ": "جنگ",
  "جنگجو": "جنگجو",
  "جنگجوؤ": "جنگجو",
  "جنگجوؤں": "جنگجو",
  "جنگل": "جنگل",
  "جنگلے": "جنگلا",
  "جنگلا": "جنگلا",
  "جنگلہ": "جنگلہ",
  "جنگلو": "جنگلا",
  "جنگلوں": "جنگلا",
  "جنگلی": "جنگلی",
  "جنگلیو": "جنگلی",
  "جنگلیوں": "جنگلی",
  "جنگو": "جنگ",
  "جنگوں": "جنگ",
  "جنگی": "جنگی",
  "جنگیں": "جنگ",
  "جنگیو": "جنگی",
  "جنگیوں": "جنگی",
  "جننے": "جننا",
  "جننا": "جننا",
  "جننی": "جننا",
  "جنس": "جنس",
  "جنسو": "جنس",
  "جنسوں": "جنس",
  "جنسیں": "جنس",
  "جنت": "جنت",
  "جنتے": "جننا",
  "جنتا": "جننا",
  "جنتو": "جنت",
  "جنتوں": "جنت",
  "جنتی": "جنتی",
  "جنتیں": "جنت",
  "جنتیو": "جنتی",
  "جنتیوں": "جنتی",
  "جنو": "جن",
  "جنوں": "جن",
  "جنی": "جننا",
  "جنیے": "جننا",
  "جنیں": "جننا",
  "جپھی": "جپھی",
  "جپھیاں": "جپھی",
  "جپھیو": "جپھی",
  "جپھیوں": "جپھی",
  "جراب": "جراب",
  "جرابو": "جراب",
  "جرابوں": "جراب",
  "جرابیں": "جراب",
  "جرگے": "جرگہ",
  "جرگہ": "جرگہ",
  "جرگو": "جرگہ",
  "جرگوں": "جرگہ",
  "جرم": "جرم",
  "جرمانے": "جرمانہ",
  "جرمانہ": "جرمانہ",
  "جرمانو": "جرمانہ",
  "جرمانوں": "جرمانہ",
  "جرمو": "جرم",
  "جرموں": "جرم",
  "جرنلسٹ": "جرنلسٹ",
  "جرنلسٹو": "جرنلسٹ",
  "جرنلسٹوں": "جرنلسٹ",
  "جریدے": "جریدہ",
  "جریدہ": "جریدہ",
  "جریدو": "جریدہ",
  "جریدوں": "جریدہ",
  "جس": "جو",
  "جسم": "جسم",
  "جسمو": "جسم",
  "جسموں": "جسم",
  "جت": "جتنا",
  "جتے": "جتنا",
  "جتں": "جتنا",
  "جتا": "جتنا",
  "جتانے": "جتنا",
  "جتانا": "جتنا",
  "جتانی": "جتانا",
  "جتاتے": "جتنا",
  "جتاتا": "جتنا",
  "جتاتی": "جتنا",
  "جتاتیں": "جتنا",
  "جتاؤ": "جتنا",
  "جتاؤں": "جتنا",
  "جتائے": "جتنا",
  "جتائی": "جتنا",
  "جتائیے": "جتنا",
  "جتائیں": "جتنا",
  "جتایا": "جتنا",
  "جتلاؤ": "جتلاؤ",
  "جتن": "جتن",
  "جتنے": "جتنا",
  "جتنا": "جتنا",
  "جتنو": "جتنا",
  "جتنوں": "جتنا",
  "جتنی": "جتنا",
  "جتتے": "جتنا",
  "جتتا": "جتنا",
  "جتتی": "جتنا",
  "جتتیں": "جتنا",
  "جتو": "جتنا",
  "جتوں": "جتنا",
  "جتوا": "جتنا",
  "جتوانے": "جتنا",
  "جتوانا": "جتنا",
  "جتواتے": "جتنا",
  "جتواتا": "جتنا",
  "جتواتی": "جتنا",
  "جتواتیں": "جتنا",
  "جتواؤ": "جتنا",
  "جتواؤں": "جتنا",
  "جتوائے": "جتنا",
  "جتوائی": "جتنا",
  "جتوائیے": "جتنا",
  "جتوائیں": "جتنا",
  "جتوایا": "جتنا",
  "جتی": "جتنا",
  "جتیے": "جتنا",
  "جتیں": "جتنا",
  "جو": "جو",
  "جوں": "جوں",
  "جوڑ": "جوڑ",
  "جوڑے": "جوڑا",
  "جوڑں": "جوڑنا",
  "جوڑا": "جوڑا",
  "جوڑنے": "جوڑنا",
  "جوڑنا": "جوڑنا",
  "جوڑنی": "جوڑنا",
  "جوڑتے": "جوڑنا",
  "جوڑتا": "جوڑنا",
  "جوڑتی": "جوڑنا",
  "جوڑتیں": "جوڑنا",
  "جوڑو": "جوڑا",
  "جوڑوں": "جوڑا",
  "جوڑی": "جوڑی",
  "جوڑیے": "جوڑنا",
  "جوڑیں": "جوڑنا",
  "جوڑیاں": "جوڑی",
  "جوڑیو": "جوڑی",
  "جوڑیوں": "جوڑی",
  "جوشاندے": "جوشاندہ",
  "جوشاندہ": "جوشاندہ",
  "جوشاندو": "جوشاندہ",
  "جوشاندوں": "جوشاندہ",
  "جوشی": "جوشی",
  "جوشیو": "جوشی",
  "جوشیوں": "جوشی",
  "جوان": "جوان",
  "جوانو": "جوان",
  "جوانوں": "جوان",
  "جوانی": "جوانی",
  "جوانیاں": "جوانی",
  "جوانیو": "جوانی",
  "جوانیوں": "جوانی",
  "جواری": "جواری",
  "جواریاں": "جواری",
  "جواریو": "جواری",
  "جواریوں": "جواری",
  "جوگی": "جوگی",
  "جوگیو": "جوگی",
  "جوگیوں": "جوگی",
  "جولانی": "جولانی",
  "جولانیاں": "جولانی",
  "جولانیو": "جولانی",
  "جولانیوں": "جولانی",
  "جونک": "جونک",
  "جونکو": "جونک",
  "جونکوں": "جونک",
  "جونکیں": "جونک",
  "جونسے": "جَونسا",
  "جونسا": "جَونسا",
  "جونسی": "جَونسا",
  "جورُو": "جورُو",
  "جورُوؤ": "جورُو",
  "جورُوؤں": "جورُو",
  "جورُوئیں": "جورُو",
  "جوت": "جتنا",
  "جوتے": "جوتا",
  "جوتں": "جتنا",
  "جوتشی": "جوتشی",
  "جوتشیو": "جوتشی",
  "جوتشیوں": "جوتشی",
  "جوتا": "جوتا",
  "جوتنے": "جتنا",
  "جوتنا": "جتنا",
  "جوتنی": "جوتنا",
  "جوتتے": "جتنا",
  "جوتتا": "جتنا",
  "جوتتی": "جتنا",
  "جوتتیں": "جتنا",
  "جوتو": "جوتا",
  "جوتوں": "جوتا",
  "جوتوا": "جوتنا",
  "جوتوانے": "جوتنا",
  "جوتوانا": "جوتنا",
  "جوتواتے": "جوتنا",
  "جوتواتا": "جوتنا",
  "جوتواتی": "جوتنا",
  "جوتواتیں": "جوتنا",
  "جوتواؤ": "جوتنا",
  "جوتواؤں": "جوتنا",
  "جوتوائے": "جوتنا",
  "جوتوائی": "جوتنا",
  "جوتوائیے": "جوتنا",
  "جوتوائیں": "جوتنا",
  "جوتوایا": "جوتنا",
  "جوتی": "جوتی",
  "جوتیے": "جتنا",
  "جوتیں": "جتنا",
  "جوتیاں": "جوتی",
  "جوتیو": "جوتی",
  "جوتیوں": "جوتی",
  "جوؤں": "جوں",
  "جوئیں": "جوں",
  "جی": "جینا",
  "جیے": "جینا",
  "جیں": "جینا",
  "جیا": "جینا",
  "جیب": "جیب",
  "جیبو": "جیب",
  "جیبوں": "جیب",
  "جیبیں": "جیب",
  "جیل": "جیل",
  "جیلو": "جیل",
  "جیلوں": "جیل",
  "جیلیں": "جیل",
  "جینے": "جینا",
  "جینا": "جینا",
  "جینی": "جینا",
  "جیسے": "جیسا",
  "جیسا": "جیسا",
  "جیسو": "جیسا",
  "جیسوں": "جیسا",
  "جیسی": "جَیسا",
  "جیت": "جیت",
  "جیتے": "جینا",
  "جیتں": "جیتنا",
  "جیتا": "جینا",
  "جیتنے": "جیتنا",
  "جیتنا": "جیتنا",
  "جیتنی": "جیتنا",
  "جیتتے": "جیتنا",
  "جیتتا": "جیتنا",
  "جیتتی": "جیتنا",
  "جیتتیں": "جیتنا",
  "جیتو": "جیت",
  "جیتوں": "جیت",
  "جیتی": "جینا",
  "جیتیے": "جیتنا",
  "جیتیں": "جیت",
  "جیو": "جینا",
  "جیوں": "جینا",
  "جیی": "جینا",
  "جییے": "جینا",
  "جییں": "جینا",
  "جز": "جز",
  "جزب": "جزب",
  "جزبے": "جزبہ",
  "جزبہ": "جزبہ",
  "جزبو": "جزبہ",
  "جزبوں": "جزبہ",
  "جزو": "جز",
  "جزوں": "جز",
  "جزیرے": "جزیرہ",
  "جزیرہ": "جزیرہ",
  "جزیرو": "جزیرہ",
  "جزیروں": "جزیرہ",
  "جھڑا": "جھاڑنا",
  "جھڑانے": "جھاڑنا",
  "جھڑانا": "جھاڑنا",
  "جھڑاتے": "جھاڑنا",
  "جھڑاتا": "جھاڑنا",
  "جھڑاتی": "جھاڑنا",
  "جھڑاتیں": "جھاڑنا",
  "جھڑاؤ": "جھاڑنا",
  "جھڑاؤں": "جھاڑنا",
  "جھڑائے": "جھاڑنا",
  "جھڑائی": "جھاڑنا",
  "جھڑائیے": "جھاڑنا",
  "جھڑائیں": "جھاڑنا",
  "جھڑایا": "جھاڑنا",
  "جھڑک": "جھڑکنا",
  "جھڑکے": "جھڑکنا",
  "جھڑکں": "جھڑکنا",
  "جھڑکا": "جھڑکنا",
  "جھڑکانے": "جھڑکنا",
  "جھڑکانا": "جھڑکنا",
  "جھڑکاتے": "جھڑکنا",
  "جھڑکاتا": "جھڑکنا",
  "جھڑکاتی": "جھڑکنا",
  "جھڑکاتیں": "جھڑکنا",
  "جھڑکاؤ": "جھڑکنا",
  "جھڑکاؤں": "جھڑکنا",
  "جھڑکائے": "جھڑکنا",
  "جھڑکائی": "جھڑکنا",
  "جھڑکائیے": "جھڑکنا",
  "جھڑکائیں": "جھڑکنا",
  "جھڑکایا": "جھڑکنا",
  "جھڑکنے": "جھڑکنا",
  "جھڑکنا": "جھڑکنا",
  "جھڑکنی": "جھڑکنا",
  "جھڑکتے": "جھڑکنا",
  "جھڑکتا": "جھڑکنا",
  "جھڑکتی": "جھڑکنا",
  "جھڑکتیں": "جھڑکنا",
  "جھڑکو": "جھڑکنا",
  "جھڑکوں": "جھڑکنا",
  "جھڑکوا": "جھڑکنا",
  "جھڑکوانے": "جھڑکنا",
  "جھڑکوانا": "جھڑکنا",
  "جھڑکواتے": "جھڑکنا",
  "جھڑکواتا": "جھڑکنا",
  "جھڑکواتی": "جھڑکنا",
  "جھڑکواتیں": "جھڑکنا",
  "جھڑکواؤ": "جھڑکنا",
  "جھڑکواؤں": "جھڑکنا",
  "جھڑکوائے": "جھڑکنا",
  "جھڑکوائی": "جھڑکنا",
  "جھڑکوائیے": "جھڑکنا",
  "جھڑکوائیں": "جھڑکنا",
  "جھڑکوایا": "جھڑکنا",
  "جھڑکی": "جھڑکی",
  "جھڑکیے": "جھڑکنا",
  "جھڑکیں": "جھڑکنا",
  "جھڑکیاں": "جھڑکی",
  "جھڑکیو": "جھڑکی",
  "جھڑکیوں": "جھڑکی",
  "جھڑپ": "جھڑپ",
  "جھڑپو": "جھڑپ",
  "جھڑپوں": "جھڑپ",
  "جھڑپیں": "جھڑپ",
  "جھڑوا": "جھاڑنا",
  "جھڑوانے": "جھاڑنا",
  "جھڑوانا": "جھاڑنا",
  "جھڑواتے": "جھاڑنا",
  "جھڑواتا": "جھاڑنا",
  "جھڑواتی": "جھاڑنا",
  "جھڑواتیں": "جھاڑنا",
  "جھڑواؤ": "جھاڑنا",
  "جھڑواؤں": "جھاڑنا",
  "جھڑوائے": "جھاڑنا",
  "جھڑوائی": "جھاڑنا",
  "جھڑوائیے": "جھاڑنا",
  "جھڑوائیں": "جھاڑنا",
  "جھڑوایا": "جھاڑنا",
  "جھڑی": "جھڑی",
  "جھڑیاں": "جھڑی",
  "جھڑیو": "جھڑی",
  "جھڑیوں": "جھڑی",
  "جھٹک": "جھٹک",
  "جھٹکے": "جھٹکا",
  "جھٹکں": "جھٹکنا",
  "جھٹکا": "جھٹکا",
  "جھٹکانے": "جھٹکنا",
  "جھٹکانا": "جھٹکنا",
  "جھٹکاتے": "جھٹکنا",
  "جھٹکاتا": "جھٹکنا",
  "جھٹکاتی": "جھٹکنا",
  "جھٹکاتیں": "جھٹکنا",
  "جھٹکاؤ": "جھٹکنا",
  "جھٹکاؤں": "جھٹکنا",
  "جھٹکائے": "جھٹکنا",
  "جھٹکائی": "جھٹکنا",
  "جھٹکائیے": "جھٹکنا",
  "جھٹکائیں": "جھٹکنا",
  "جھٹکایا": "جھٹکنا",
  "جھٹکنے": "جھٹکنا",
  "جھٹکنا": "جھٹکنا",
  "جھٹکنی": "جھٹکنا",
  "جھٹکتے": "جھٹکنا",
  "جھٹکتا": "جھٹکنا",
  "جھٹکتی": "جھٹکنا",
  "جھٹکتیں": "جھٹکنا",
  "جھٹکو": "جھٹکا",
  "جھٹکوں": "جھٹکا",
  "جھٹکوا": "جھٹکنا",
  "جھٹکوانے": "جھٹکنا",
  "جھٹکوانا": "جھٹکنا",
  "جھٹکواتے": "جھٹکنا",
  "جھٹکواتا": "جھٹکنا",
  "جھٹکواتی": "جھٹکنا",
  "جھٹکواتیں": "جھٹکنا",
  "جھٹکواؤ": "جھٹکنا",
  "جھٹکواؤں": "جھٹکنا",
  "جھٹکوائے": "جھٹکنا",
  "جھٹکوائی": "جھٹکنا",
  "جھٹکوائیے": "جھٹکنا",
  "جھٹکوائیں": "جھٹکنا",
  "جھٹکوایا": "جھٹکنا",
  "جھٹکی": "جھٹکنا",
  "جھٹکیے": "جھٹکنا",
  "جھٹکیں": "جھٹک",
  "جھٹلا": "جھٹلانا",
  "جھٹلانے": "جھٹلانا",
  "جھٹلانا": "جھٹلانا",
  "جھٹلانی": "جھٹلانا",
  "جھٹلاتے": "جھٹلانا",
  "جھٹلاتا": "جھٹلانا",
  "جھٹلاتی": "جھٹلانا",
  "جھٹلاتیں": "جھٹلانا",
  "جھٹلاؤ": "جھٹلانا",
  "جھٹلاؤں": "جھٹلانا",
  "جھٹلائے": "جھٹلانا",
  "جھٹلائی": "جھٹلانا",
  "جھٹلائیے": "جھٹلانا",
  "جھٹلائیں": "جھٹلانا",
  "جھٹلایا": "جھٹلانا",
  "جھاڑ": "جھاڑ",
  "جھاڑے": "جھاڑنا",
  "جھاڑں": "جھاڑنا",
  "جھاڑا": "جھاڑنا",
  "جھاڑنے": "جھاڑنا",
  "جھاڑنا": "جھاڑنا",
  "جھاڑنی": "جھاڑنا",
  "جھاڑتے": "جھاڑنا",
  "جھاڑتا": "جھاڑنا",
  "جھاڑتی": "جھاڑنا",
  "جھاڑتیں": "جھاڑنا",
  "جھاڑو": "جھاڑ",
  "جھاڑوں": "جھاڑ",
  "جھاڑی": "جھاڑی",
  "جھاڑیے": "جھاڑنا",
  "جھاڑیں": "جھاڑ",
  "جھاڑیاں": "جھاڑی",
  "جھاڑیو": "جھاڑی",
  "جھاڑیوں": "جھاڑی",
  "جھابے": "جھابہ",
  "جھابہ": "جھابہ",
  "جھابو": "جھابہ",
  "جھابوں": "جھابہ",
  "جھانک": "جھانکنا",
  "جھانکے": "جھانکنا",
  "جھانکں": "جھانکنا",
  "جھانکا": "جھانکنا",
  "جھانکنے": "جھانکنا",
  "جھانکنا": "جھانکنا",
  "جھانکنی": "جھانکنا",
  "جھانکتے": "جھانکنا",
  "جھانکتا": "جھانکنا",
  "جھانکتی": "جھانکنا",
  "جھانکتیں": "جھانکنا",
  "جھانکو": "جھانکنا",
  "جھانکوں": "جھانکنا",
  "جھانکی": "جھانکنا",
  "جھانکیے": "جھانکنا",
  "جھانکیں": "جھانکنا",
  "جھگّی": "جھگّی",
  "جھگّیاں": "جھگّی",
  "جھگّیو": "جھگّی",
  "جھگّیوں": "جھگّی",
  "جھگڑ": "جھگڑنا",
  "جھگڑے": "جھگڑا",
  "جھگڑں": "جھگڑنا",
  "جھگڑا": "جھگڑا",
  "جھگڑہ": "جھگڑہ",
  "جھگڑنے": "جھگڑنا",
  "جھگڑنا": "جھگڑنا",
  "جھگڑنی": "جھگڑنا",
  "جھگڑتے": "جھگڑنا",
  "جھگڑتا": "جھگڑنا",
  "جھگڑتی": "جھگڑنا",
  "جھگڑتیں": "جھگڑنا",
  "جھگڑو": "جھگڑا",
  "جھگڑوں": "جھگڑا",
  "جھگڑی": "جھگڑنا",
  "جھگڑیے": "جھگڑنا",
  "جھگڑیں": "جھگڑنا",
  "جھگی": "جھگی",
  "جھگیاں": "جھگی",
  "جھگیو": "جھگی",
  "جھگیوں": "جھگی",
  "جھک": "جھکنا",
  "جھکے": "جھکنا",
  "جھکں": "جھکنا",
  "جھکا": "جھکنا",
  "جھکانے": "جھکنا",
  "جھکانا": "جھکنا",
  "جھکاتے": "جھکنا",
  "جھکاتا": "جھکنا",
  "جھکاتی": "جھکنا",
  "جھکاتیں": "جھکنا",
  "جھکاؤ": "جھکنا",
  "جھکاؤں": "جھکنا",
  "جھکائے": "جھکنا",
  "جھکائی": "جھکنا",
  "جھکائیے": "جھکنا",
  "جھکائیں": "جھکنا",
  "جھکایا": "جھکنا",
  "جھکجھ": "جھکجھنا",
  "جھکجھے": "جھکجھنا",
  "جھکجھں": "جھکجھنا",
  "جھکجھا": "جھکجھنا",
  "جھکجھنے": "جھکجھنا",
  "جھکجھنا": "جھکجھنا",
  "جھکجھنی": "جھکجھنا",
  "جھکجھتے": "جھکجھنا",
  "جھکجھتا": "جھکجھنا",
  "جھکجھتی": "جھکجھنا",
  "جھکجھتیں": "جھکجھنا",
  "جھکجھو": "جھکجھنا",
  "جھکجھوں": "جھکجھنا",
  "جھکجھی": "جھکجھنا",
  "جھکجھیے": "جھکجھنا",
  "جھکجھیں": "جھکجھنا",
  "جھکنے": "جھکنا",
  "جھکنا": "جھکنا",
  "جھکنی": "جھکنا",
  "جھکتے": "جھکنا",
  "جھکتا": "جھکنا",
  "جھکتی": "جھکنا",
  "جھکتیں": "جھکنا",
  "جھکو": "جھکنا",
  "جھکوں": "جھکنا",
  "جھکوا": "جھکنا",
  "جھکوانے": "جھکنا",
  "جھکوانا": "جھکنا",
  "جھکواتے": "جھکنا",
  "جھکواتا": "جھکنا",
  "جھکواتی": "جھکنا",
  "جھکواتیں": "جھکنا",
  "جھکواؤ": "جھکنا",
  "جھکواؤں": "جھکنا",
  "جھکوائے": "جھکنا",
  "جھکوائی": "جھکنا",
  "جھکوائیے": "جھکنا",
  "جھکوائیں": "جھکنا",
  "جھکوایا": "جھکنا",
  "جھکی": "جھکنا",
  "جھکیے": "جھکنا",
  "جھکیں": "جھکنا",
  "جھلک": "جھلکنا",
  "جھلکے": "جھلکنا",
  "جھلکں": "جھلکنا",
  "جھلکا": "جھلکنا",
  "جھلکانے": "جھلکنا",
  "جھلکانا": "جھلکنا",
  "جھلکاتے": "جھلکنا",
  "جھلکاتا": "جھلکنا",
  "جھلکاتی": "جھلکنا",
  "جھلکاتیں": "جھلکنا",
  "جھلکاؤ": "جھلکنا",
  "جھلکاؤں": "جھلکنا",
  "جھلکائے": "جھلکنا",
  "جھلکائی": "جھلکنا",
  "جھلکائیے": "جھلکنا",
  "جھلکائیں": "جھلکنا",
  "جھلکایا": "جھلکنا",
  "جھلکنے": "جھلکنا",
  "جھلکنا": "جھلکنا",
  "جھلکنی": "جھلکنا",
  "جھلکتے": "جھلکنا",
  "جھلکتا": "جھلکنا",
  "جھلکتی": "جھلکنا",
  "جھلکتیں": "جھلکنا",
  "جھلکو": "جھلکنا",
  "جھلکوں": "جھلکنا",
  "جھلکوا": "جھلکنا",
  "جھلکوانے": "جھلکنا",
  "جھلکوانا": "جھلکنا",
  "جھلکواتے": "جھلکنا",
  "جھلکواتا": "جھلکنا",
  "جھلکواتی": "جھلکنا",
  "جھلکواتیں": "جھلکنا",
  "جھلکواؤ": "جھلکنا",
  "جھلکواؤں": "جھلکنا",
  "جھلکوائے": "جھلکنا",
  "جھلکوائی": "جھلکنا",
  "جھلکوائیے": "جھلکنا",
  "جھلکوائیں": "جھلکنا",
  "جھلکوایا": "جھلکنا",
  "جھلکی": "جھلکی",
  "جھلکیے": "جھلکنا",
  "جھلکیں": "جھلکنا",
  "جھلکیاں": "جھلکی",
  "جھلکیو": "جھلکی",
  "جھلکیوں": "جھلکی",
  "جھلی": "جھلی",
  "جھلیاں": "جھلی",
  "جھلیو": "جھلی",
  "جھلیوں": "جھلی",
  "جھنڈی": "جھنڈی",
  "جھنڈیاں": "جھنڈی",
  "جھنڈیو": "جھنڈی",
  "جھنڈیوں": "جھنڈی",
  "جھنجھنا": "جھنجھنانا",
  "جھنجھنانے": "جھنجھنانا",
  "جھنجھنانا": "جھنجھنانا",
  "جھنجھنانی": "جھنجھنانا",
  "جھنجھناتے": "جھنجھنانا",
  "جھنجھناتا": "جھنجھنانا",
  "جھنجھناتی": "جھنجھنانا",
  "جھنجھناتیں": "جھنجھنانا",
  "جھنجھناؤ": "جھنجھنانا",
  "جھنجھناؤں": "جھنجھنانا",
  "جھنجھنائے": "جھنجھنانا",
  "جھنجھنائی": "جھنجھنانا",
  "جھنجھنائیے": "جھنجھنانا",
  "جھنجھنائیں": "جھنجھنانا",
  "جھنجھنایا": "جھنجھنانا",
  "جھپک": "جھپک",
  "جھپکے": "جھپکنا",
  "جھپکں": "جھپکنا",
  "جھپکا": "جھپکنا",
  "جھپکانے": "جھپکنا",
  "جھپکانا": "جھپکنا",
  "جھپکاتے": "جھپکنا",
  "جھپکاتا": "جھپکنا",
  "جھپکاتی": "جھپکنا",
  "جھپکاتیں": "جھپکنا",
  "جھپکاؤ": "جھپکنا",
  "جھپکاؤں": "جھپکنا",
  "جھپکائے": "جھپکنا",
  "جھپکائی": "جھپکنا",
  "جھپکائیے": "جھپکنا",
  "جھپکائیں": "جھپکنا",
  "جھپکایا": "جھپکنا",
  "جھپکنے": "جھپکنا",
  "جھپکنا": "جھپکنا",
  "جھپکنی": "جھپکنا",
  "جھپکتے": "جھپکنا",
  "جھپکتا": "جھپکنا",
  "جھپکتی": "جھپکنا",
  "جھپکتیں": "جھپکنا",
  "جھپکو": "جھپک",
  "جھپکوں": "جھپک",
  "جھپکوا": "جھپکنا",
  "جھپکوانے": "جھپکنا",
  "جھپکوانا": "جھپکنا",
  "جھپکواتے": "جھپکنا",
  "جھپکواتا": "جھپکنا",
  "جھپکواتی": "جھپکنا",
  "جھپکواتیں": "جھپکنا",
  "جھپکواؤ": "جھپکنا",
  "جھپکواؤں": "جھپکنا",
  "جھپکوائے": "جھپکنا",
  "جھپکوائی": "جھپکنا",
  "جھپکوائیے": "جھپکنا",
  "جھپکوائیں": "جھپکنا",
  "جھپکوایا": "جھپکنا",
  "جھپکی": "جھپکنا",
  "جھپکیے": "جھپکنا",
  "جھپکیں": "جھپکنا",
  "جھپی": "جھپی",
  "جھپیاں": "جھپی",
  "جھپیو": "جھپی",
  "جھپیوں": "جھپی",
  "جھری": "جھری",
  "جھریاں": "جھری",
  "جھریو": "جھری",
  "جھریوں": "جھری",
  "جھوٹ": "جھوٹ",
  "جھوٹے": "جھوٹا",
  "جھوٹا": "جھوٹا",
  "جھوٹو": "جھوٹا",
  "جھوٹوں": "جھوٹا",
  "جھول": "جھول",
  "جھولے": "جھولا",
  "جھولں": "جھولنا",
  "جھولا": "جھولا",
  "جھولنے": "جھولنا",
  "جھولنا": "جھولنا",
  "جھولنی": "جھولنا",
  "جھولت": "جھولت",
  "جھولتے": "جھولنا",
  "جھولتا": "جھولنا",
  "جھولتو": "جھولت",
  "جھولتوں": "جھولت",
  "جھولتی": "جھولنا",
  "جھولتیں": "جھولت",
  "جھولو": "جھولا",
  "جھولوں": "جھولا",
  "جھولی": "جھولی",
  "جھولیے": "جھولنا",
  "جھولیں": "جھولنا",
  "جھولیاں": "جھولی",
  "جھولیو": "جھولی",
  "جھولیوں": "جھولی",
  "جھوم": "جھومنا",
  "جھومے": "جھومنا",
  "جھومں": "جھومنا",
  "جھوما": "جھومنا",
  "جھومنے": "جھومنا",
  "جھومنا": "جھومنا",
  "جھومنی": "جھومنا",
  "جھومت": "جھومت",
  "جھومتے": "جھومنا",
  "جھومتا": "جھومنا",
  "جھومتو": "جھومت",
  "جھومتوں": "جھومت",
  "جھومتی": "جھومنا",
  "جھومتیں": "جھومت",
  "جھومو": "جھومنا",
  "جھوموں": "جھومنا",
  "جھومی": "جھومنا",
  "جھومیے": "جھومنا",
  "جھومیں": "جھومنا",
  "جھونک": "جھونک",
  "جھونکے": "جھونکا",
  "جھونکں": "جھونکنا",
  "جھونکا": "جھونکا",
  "جھونکنے": "جھونکنا",
  "جھونکنا": "جھونکنا",
  "جھونکنی": "جھونکنا",
  "جھونکتے": "جھونکنا",
  "جھونکتا": "جھونکنا",
  "جھونکتی": "جھونکنا",
  "جھونکتیں": "جھونکنا",
  "جھونکو": "جھونکا",
  "جھونکوں": "جھونکا",
  "جھونکی": "جھونکنا",
  "جھونکیے": "جھونکنا",
  "جھونکیں": "جھونکنا",
  "جھونپڑی": "جھونپڑی",
  "جھونپڑیاں": "جھونپڑی",
  "جھونپڑیو": "جھونپڑی",
  "جھونپڑیوں": "جھونپڑی",
  "جھیل": "جھیل",
  "جھیلے": "جھیلنا",
  "جھیلں": "جھیلنا",
  "جھیلا": "جھیلنا",
  "جھیلنے": "جھیلنا",
  "جھیلنا": "جھیلنا",
  "جھیلنی": "جھیلنا",
  "جھیلتے": "جھیلنا",
  "جھیلتا": "جھیلنا",
  "جھیلتی": "جھیلنا",
  "جھیلتیں": "جھیلنا",
  "جھیلو": "جھیل",
  "جھیلوں": "جھیل",
  "جھیلوا": "جھیلنا",
  "جھیلوانے": "جھیلنا",
  "جھیلوانا": "جھیلنا",
  "جھیلواتے": "جھیلنا",
  "جھیلواتا": "جھیلنا",
  "جھیلواتی": "جھیلنا",
  "جھیلواتیں": "جھیلنا",
  "جھیلواؤ": "جھیلنا",
  "جھیلواؤں": "جھیلنا",
  "جھیلوائے": "جھیلنا",
  "جھیلوائی": "جھیلنا",
  "جھیلوائیے": "جھیلنا",
  "جھیلوائیں": "جھیلنا",
  "جھیلوایا": "جھیلنا",
  "جھیلی": "جھیلنا",
  "جھیلیے": "جھیلنا",
  "جھیلیں": "جھیل",
  "کَٹ": "کَٹْنا",
  "کَٹْں": "کَٹْنا",
  "کَٹْنے": "کَٹْنا",
  "کَٹْنا": "کَٹْنا",
  "کَٹْنی": "کَٹْنا",
  "کَٹْتے": "کَٹْنا",
  "کَٹْتا": "کَٹْنا",
  "کَٹْتی": "کَٹْنا",
  "کَٹْتیں": "کَٹْنا",
  "کَٹْوا": "کَٹْنا",
  "کَٹْوانے": "کَٹْنا",
  "کَٹْوانا": "کَٹْنا",
  "کَٹْواتے": "کَٹْنا",
  "کَٹْواتا": "کَٹْنا",
  "کَٹْواتی": "کَٹْنا",
  "کَٹْواتیں": "کَٹْنا",
  "کَٹْواؤ": "کَٹْنا",
  "کَٹْواؤں": "کَٹْنا",
  "کَٹْوائے": "کَٹْنا",
  "کَٹْوائی": "کَٹْنا",
  "کَٹْوائیے": "کَٹْنا",
  "کَٹْوائیں": "کَٹْنا",
  "کَٹْوایا": "کَٹْنا",
  "کَٹے": "کَٹْنا",
  "کَٹا": "کَٹْنا",
  "کَٹو": "کَٹْنا",
  "کَٹوں": "کَٹْنا",
  "کَٹی": "کَٹْنا",
  "کَٹیے": "کَٹْنا",
  "کَٹیں": "کَٹْنا",
  "کَب": "کَب",
  "کَہاں": "کَہاں",
  "کَم": "کَم",
  "کَمتَر": "کَم",
  "کَمتَرین": "کَم",
  "کَمتر": "کَم",
  "کَمترین": "کَم",
  "کَون": "کَیا",
  "کَونسے": "کَونسا",
  "کَونسا": "کَونسا",
  "کَونسی": "کَونسا",
  "کَئے": "کَئے",
  "کَئی": "کَئی",
  "کَیا": "کَیا",
  "کَیسے": "کَیسا",
  "کَیسا": "کَیسا",
  "کَیسی": "کَیسا",
  "کِدَھر": "کِدَھر",
  "کِن": "کَیا",
  "کِس": "کَیا",
  "کِسی": "کِسی",
  "کِتاب": "کِتاب",
  "کِتابو": "کِتاب",
  "کِتابوں": "کِتاب",
  "کِتابیں": "کِتاب",
  "کِتنے": "کِتنا",
  "کِتنا": "کِتنا",
  "کِتنی": "کِتنا",
  "کِیُونْکَر": "کِیُونْکَر",
  "کِیوُں": "کِیوُں",
  "کِھنچ": "کِھنچنا",
  "کِھنچے": "کِھنچنا",
  "کِھنچں": "کِھنچنا",
  "کِھنچا": "کِھنچنا",
  "کِھنچانے": "کِھنچنا",
  "کِھنچانا": "کِھنچنا",
  "کِھنچاتے": "کِھنچنا",
  "کِھنچاتا": "کِھنچنا",
  "کِھنچاتی": "کِھنچنا",
  "کِھنچاتیں": "کِھنچنا",
  "کِھنچاؤ": "کِھنچنا",
  "کِھنچاؤں": "کِھنچنا",
  "کِھنچائے": "کِھنچنا",
  "کِھنچائی": "کِھنچنا",
  "کِھنچائیے": "کِھنچنا",
  "کِھنچائیں": "کِھنچنا",
  "کِھنچایا": "کِھنچنا",
  "کِھنچنے": "کِھنچنا",
  "کِھنچنا": "کِھنچنا",
  "کِھنچنی": "کِھنچنا",
  "کِھنچتے": "کِھنچنا",
  "کِھنچتا": "کِھنچنا",
  "کِھنچتی": "کِھنچنا",
  "کِھنچتیں": "کِھنچنا",
  "کِھنچو": "کِھنچنا",
  "کِھنچوں": "کِھنچنا",
  "کِھنچوا": "کِھنچنا",
  "کِھنچوانے": "کِھنچنا",
  "کِھنچوانا": "کِھنچنا",
  "کِھنچواتے": "کِھنچنا",
  "کِھنچواتا": "کِھنچنا",
  "کِھنچواتی": "کِھنچنا",
  "کِھنچواتیں": "کِھنچنا",
  "کِھنچواؤ": "کِھنچنا",
  "کِھنچواؤں": "کِھنچنا",
  "کِھنچوائے": "کِھنچنا",
  "کِھنچوائی": "کِھنچنا",
  "کِھنچوائیے": "کِھنچنا",
  "کِھنچوائیں": "کِھنچنا",
  "کِھنچوایا": "کِھنچنا",
  "کِھنچی": "کِھنچنا",
  "کِھنچیے": "کِھنچنا",
  "کِھنچیں": "کِھنچنا",
  "کُڑی": "کُڑی",
  "کُڑیاں": "کُڑی",
  "کُڑیو": "کُڑی",
  "کُڑیوں": "کُڑی",
  "کُڑھ": "کُڑھنا",
  "کُڑھے": "کُڑھنا",
  "کُڑھں": "کُڑھنا",
  "کُڑھا": "کُڑھنا",
  "کُڑھنے": "کُڑھنا",
  "کُڑھنا": "کُڑھنا",
  "کُڑھنی": "کُڑھنا",
  "کُڑھتے": "کُڑھنا",
  "کُڑھتا": "کُڑھنا",
  "کُڑھتی": "کُڑھنا",
  "کُڑھتیں": "کُڑھنا",
  "کُڑھو": "کُڑھنا",
  "کُڑھوں": "کُڑھنا",
  "کُڑھی": "کُڑھنا",
  "کُڑھیے": "کُڑھنا",
  "کُڑھیں": "کُڑھنا",
  "کُٹ": "کُٹنا",
  "کُٹے": "کُٹنا",
  "کُٹں": "کُٹنا",
  "کُٹا": "کُٹنا",
  "کُٹانے": "کُٹنا",
  "کُٹانا": "کُٹنا",
  "کُٹاتے": "کُٹنا",
  "کُٹاتا": "کُٹنا",
  "کُٹاتی": "کُٹنا",
  "کُٹاتیں": "کُٹنا",
  "کُٹاؤ": "کُٹنا",
  "کُٹاؤں": "کُٹنا",
  "کُٹائے": "کُٹنا",
  "کُٹائی": "کُٹنا",
  "کُٹائیے": "کُٹنا",
  "کُٹائیں": "کُٹنا",
  "کُٹایا": "کُٹنا",
  "کُٹنے": "کُٹنا",
  "کُٹنا": "کُٹنا",
  "کُٹنی": "کُٹنا",
  "کُٹتے": "کُٹنا",
  "کُٹتا": "کُٹنا",
  "کُٹتی": "کُٹنا",
  "کُٹتیں": "کُٹنا",
  "کُٹو": "کُٹنا",
  "کُٹوں": "کُٹنا",
  "کُٹوا": "کُٹنا",
  "کُٹوانے": "کُٹنا",
  "کُٹوانا": "کُٹنا",
  "کُٹواتے": "کُٹنا",
  "کُٹواتا": "کُٹنا",
  "کُٹواتی": "کُٹنا",
  "کُٹواتیں": "کُٹنا",
  "کُٹواؤ": "کُٹنا",
  "کُٹواؤں": "کُٹنا",
  "کُٹوائے": "کُٹنا",
  "کُٹوائی": "کُٹنا",
  "کُٹوائیے": "کُٹنا",
  "کُٹوائیں": "کُٹنا",
  "کُٹوایا": "کُٹنا",
  "کُٹی": "کُٹنا",
  "کُٹیے": "کُٹنا",
  "کُٹیں": "کُٹنا",
  "کُشتے": "کُشتہ",
  "کُشتہ": "کُشتہ",
  "کُشتو": "کُشتہ",
  "کُشتوں": "کُشتہ",
  "کُچھ": "کُچھ",
  "کُل": "کُل",
  "کُنْواں": "کُنْواں",
  "کُنْووںں": "کُنْواں",
  "کُنْویں": "کُنْواں",
  "کُرْسی": "کُرْسی",
  "کُرْسیاں": "کُرْسی",
  "کُرْسیو": "کُرْسی",
  "کُرْسیوں": "کُرْسی",
  "کُرسی": "کُرسی",
  "کُرسیاں": "کُرسی",
  "کُرسیو": "کُرسی",
  "کُرسیوں": "کُرسی",
  "کُرتے": "کُرتہ",
  "کُرتہ": "کُرتہ",
  "کُرتو": "کُرتہ",
  "کُرتوں": "کُرتہ",
  "کُتّے": "کُتّا",
  "کُتّا": "کُتّا",
  "کُتّو": "کُتّا",
  "کُتّوں": "کُتّا",
  "کُھل": "کُھلنا",
  "کُھلے": "کُھلنا",
  "کُھلں": "کُھلنا",
  "کُھلا": "کُھلنا",
  "کُھلانے": "کُھلنا",
  "کُھلانا": "کُھلنا",
  "کُھلاتے": "کُھلنا",
  "کُھلاتا": "کُھلنا",
  "کُھلاتی": "کُھلنا",
  "کُھلاتیں": "کُھلنا",
  "کُھلاؤ": "کُھلنا",
  "کُھلاؤں": "کُھلنا",
  "کُھلائے": "کُھلنا",
  "کُھلائی": "کُھلنا",
  "کُھلائیے": "کُھلنا",
  "کُھلائیں": "کُھلنا",
  "کُھلایا": "کُھلنا",
  "کُھلنے": "کُھلنا",
  "کُھلنا": "کُھلنا",
  "کُھلنی": "کُھلنا",
  "کُھلتے": "کُھلنا",
  "کُھلتا": "کُھلنا",
  "کُھلتی": "کُھلنا",
  "کُھلتیں": "کُھلنا",
  "کُھلو": "کُھلنا",
  "کُھلوں": "کُھلنا",
  "کُھلوا": "کُھلنا",
  "کُھلوانے": "کُھلنا",
  "کُھلوانا": "کُھلنا",
  "کُھلواتے": "کُھلنا",
  "کُھلواتا": "کُھلنا",
  "کُھلواتی": "کُھلنا",
  "کُھلواتیں": "کُھلنا",
  "کُھلواؤ": "کُھلنا",
  "کُھلواؤں": "کُھلنا",
  "کُھلوائے": "کُھلنا",
  "کُھلوائی": "کُھلنا",
  "کُھلوائیے": "کُھلنا",
  "کُھلوائیں": "کُھلنا",
  "کُھلوایا": "کُھلنا",
  "کُھلی": "کُھلنا",
  "کُھلیے": "کُھلنا",
  "کُھلیں": "کُھلنا",
  "کے": "کم",
  "کڑ": "کڑنا",
  "کڑے": "کڑا",
  "کڑں": "کڑنا",
  "کڑا": "کڑا",
  "کڑہ": "کڑہ",
  "کڑنے": "کڑنا",
  "کڑنا": "کڑنا",
  "کڑنی": "کڑنا",
  "کڑتے": "کڑنا",
  "کڑتا": "کڑنا",
  "کڑتی": "کڑنا",
  "کڑتیں": "کڑنا",
  "کڑو": "کڑا",
  "کڑوں": "کڑا",
  "کڑوا": "کڑنا",
  "کڑواہٹ": "کڑواہٹ",
  "کڑواہٹو": "کڑواہٹ",
  "کڑواہٹوں": "کڑواہٹ",
  "کڑواہٹیں": "کڑواہٹ",
  "کڑوانے": "کڑنا",
  "کڑوانا": "کڑنا",
  "کڑواتے": "کڑنا",
  "کڑواتا": "کڑنا",
  "کڑواتی": "کڑنا",
  "کڑواتیں": "کڑنا",
  "کڑواؤ": "کڑنا",
  "کڑواؤں": "کڑنا",
  "کڑوائے": "کڑنا",
  "کڑوائی": "کڑنا",
  "کڑوائیے": "کڑنا",
  "کڑوائیں": "کڑنا",
  "کڑوایا": "کڑنا",
  "کڑی": "کڑی",
  "کڑیے": "کڑنا",
  "کڑیں": "کڑنا",
  "کڑیاں": "کڑی",
  "کڑیو": "کڑی",
  "کڑیوں": "کڑی",
  "کڑھ": "کڑھنا",
  "کڑھے": "کڑھنا",
  "کڑھں": "کڑھنا",
  "کڑھا": "کڑھنا",
  "کڑھانے": "کڑھنا",
  "کڑھانا": "کڑھنا",
  "کڑھاتے": "کڑھنا",
  "کڑھاتا": "کڑھنا",
  "کڑھاتی": "کڑھنا",
  "کڑھاتیں": "کڑھنا",
  "کڑھاؤ": "کڑھنا",
  "کڑھاؤں": "کڑھنا",
  "کڑھائے": "کڑھنا",
  "کڑھائی": "کڑھنا",
  "کڑھائیے": "کڑھنا",
  "کڑھائیں": "کڑھنا",
  "کڑھایا": "کڑھنا",
  "کڑھنے": "کڑھنا",
  "کڑھنا": "کڑھنا",
  "کڑھنی": "کڑھنا",
  "کڑھتے": "کڑھنا",
  "کڑھتا": "کڑھنا",
  "کڑھتی": "کڑھنا",
  "کڑھتیں": "کڑھنا",
  "کڑھو": "کڑھنا",
  "کڑھوں": "کڑھنا",
  "کڑھوا": "کڑھنا",
  "کڑھوانے": "کڑھنا",
  "کڑھوانا": "کڑھنا",
  "کڑھواتے": "کڑھنا",
  "کڑھواتا": "کڑھنا",
  "کڑھواتی": "کڑھنا",
  "کڑھواتیں": "کڑھنا",
  "کڑھواؤ": "کڑھنا",
  "کڑھواؤں": "کڑھنا",
  "کڑھوائے": "کڑھنا",
  "کڑھوائی": "کڑھنا",
  "کڑھوائیے": "کڑھنا",
  "کڑھوائیں": "کڑھنا",
  "کڑھوایا": "کڑھنا",
  "کڑھی": "کڑھنا",
  "کڑھیے": "کڑھنا",
  "کڑھیں": "کڑھنا",
  "کٹ": "کٹنا",
  "کٹے": "کٹا",
  "کٹں": "کٹنا",
  "کٹا": "کٹا",
  "کٹانے": "کٹنا",
  "کٹانا": "کٹنا",
  "کٹاتے": "کٹنا",
  "کٹاتا": "کٹنا",
  "کٹاتی": "کٹنا",
  "کٹاتیں": "کٹنا",
  "کٹاؤ": "کٹاؤ",
  "کٹاؤں": "کٹنا",
  "کٹائے": "کٹنا",
  "کٹائی": "کٹنا",
  "کٹائیے": "کٹنا",
  "کٹائیں": "کٹنا",
  "کٹایا": "کٹنا",
  "کٹنے": "کٹنا",
  "کٹنا": "کٹنا",
  "کٹنی": "کٹنا",
  "کٹتے": "کٹنا",
  "کٹتا": "کٹنا",
  "کٹتی": "کٹنا",
  "کٹتیں": "کٹنا",
  "کٹو": "کٹا",
  "کٹوں": "کٹا",
  "کٹوا": "کٹنا",
  "کٹوانے": "کٹنا",
  "کٹوانا": "کٹنا",
  "کٹواتے": "کٹنا",
  "کٹواتا": "کٹنا",
  "کٹواتی": "کٹنا",
  "کٹواتیں": "کٹنا",
  "کٹواؤ": "کٹنا",
  "کٹواؤں": "کٹنا",
  "کٹوائے": "کٹنا",
  "کٹوائی": "کٹنا",
  "کٹوائیے": "کٹنا",
  "کٹوائیں": "کٹنا",
  "کٹوایا": "کٹنا",
  "کٹورے": "کٹورہ",
  "کٹورہ": "کٹورہ",
  "کٹورو": "کٹورہ",
  "کٹوروں": "کٹورہ",
  "کٹی": "کٹنا",
  "کٹیے": "کٹنا",
  "کٹیں": "کٹنا",
  "کش": "کش",
  "کشمیری": "کشمیری",
  "کشمیریو": "کشمیری",
  "کشمیریوں": "کشمیری",
  "کشت": "کشت",
  "کشتے": "کشتہ",
  "کشتہ": "کشتہ",
  "کشتو": "کشتہ",
  "کشتوں": "کشتہ",
  "کشتی": "کشتی",
  "کشتیں": "کشت",
  "کشتیاں": "کشتی",
  "کشتیو": "کشتی",
  "کشتیوں": "کشتی",
  "کشو": "کش",
  "کشوں": "کش",
  "کا": "کا",
  "کاغذ": "کاغذ",
  "کاغذو": "کاغذ",
  "کاغذوں": "کاغذ",
  "کاڑ": "کڑنا",
  "کاڑے": "کڑنا",
  "کاڑں": "کڑنا",
  "کاڑا": "کڑنا",
  "کاڑنے": "کڑنا",
  "کاڑنا": "کڑنا",
  "کاڑتے": "کڑنا",
  "کاڑتا": "کڑنا",
  "کاڑتی": "کڑنا",
  "کاڑتیں": "کڑنا",
  "کاڑو": "کڑنا",
  "کاڑوں": "کڑنا",
  "کاڑی": "کڑنا",
  "کاڑیے": "کڑنا",
  "کاڑیں": "کڑنا",
  "کاڑھ": "کاڑھنا",
  "کاڑھے": "کاڑھنا",
  "کاڑھں": "کاڑھنا",
  "کاڑھا": "کاڑھنا",
  "کاڑھنے": "کاڑھنا",
  "کاڑھنا": "کاڑھنا",
  "کاڑھنی": "کاڑھنا",
  "کاڑھتے": "کاڑھنا",
  "کاڑھتا": "کاڑھنا",
  "کاڑھتی": "کاڑھنا",
  "کاڑھتیں": "کاڑھنا",
  "کاڑھو": "کاڑھنا",
  "کاڑھوں": "کاڑھنا",
  "کاڑھوا": "کاڑھنا",
  "کاڑھوانے": "کاڑھنا",
  "کاڑھوانا": "کاڑھنا",
  "کاڑھواتے": "کاڑھنا",
  "کاڑھواتا": "کاڑھنا",
  "کاڑھواتی": "کاڑھنا",
  "کاڑھواتیں": "کاڑھنا",
  "کاڑھواؤ": "کاڑھنا",
  "کاڑھواؤں": "کاڑھنا",
  "کاڑھوائے": "کاڑھنا",
  "کاڑھوائی": "کاڑھنا",
  "کاڑھوائیے": "کاڑھنا",
  "کاڑھوائیں": "کاڑھنا",
  "کاڑھوایا": "کاڑھنا",
  "کاڑھی": "کاڑھنا",
  "کاڑھیے": "کاڑھنا",
  "کاڑھیں": "کاڑھنا",
  "کاٹ": "کَٹْنا",
  "کاٹے": "کاٹا",
  "کاٹں": "کَٹْنا",
  "کاٹا": "کاٹا",
  "کاٹن": "کاٹن",
  "کاٹنے": "کاٹنا",
  "کاٹنا": "کاٹنا",
  "کاٹنو": "کاٹنا",
  "کاٹنوں": "کاٹنا",
  "کاٹنی": "کاٹنا",
  "کاٹنیں": "کاٹن",
  "کاٹتے": "کَٹْنا",
  "کاٹتا": "کَٹْنا",
  "کاٹتی": "کَٹْنا",
  "کاٹتیں": "کَٹْنا",
  "کاٹو": "کاٹا",
  "کاٹوں": "کاٹا",
  "کاٹی": "کَٹْنا",
  "کاٹیے": "کَٹْنا",
  "کاٹیں": "کَٹْنا",
  "کاشانے": "کاشانہ",
  "کاشانہ": "کاشانہ",
  "کاشانو": "کاشانہ",
  "کاشانوں": "کاشانہ",
  "کاشتکار": "کاشتکار",
  "کاشتکارو": "کاشتکار",
  "کاشتکاروں": "کاشتکار",
  "کافر": "کافر",
  "کافرو": "کافر",
  "کافروں": "کافر",
  "کافی": "کافی",
  "کافیاں": "کافی",
  "کافیو": "کافی",
  "کافیوں": "کافی",
  "کاہن": "کاہن",
  "کاہنے": "کاہنہ",
  "کاہنہ": "کاہنہ",
  "کاہنو": "کاہنہ",
  "کاہنوں": "کاہنہ",
  "کاج": "کاج",
  "کاجو": "کاج",
  "کاجوں": "کاج",
  "کال": "کال",
  "کالے": "کالا",
  "کالا": "کالا",
  "کالج": "کالج",
  "کالجو": "کالج",
  "کالجوں": "کالج",
  "کالجیں": "کالج",
  "کالم": "کالم",
  "کالمو": "کالم",
  "کالموں": "کالم",
  "کالو": "کالا",
  "کالوں": "کالا",
  "کالوؤ": "کالو",
  "کالوؤں": "کالو",
  "کالی": "کالی",
  "کالیاں": "کالی",
  "کالیو": "کالی",
  "کالیوں": "کالی",
  "کام": "کام",
  "کامرانی": "کامرانی",
  "کامرانیاں": "کامرانی",
  "کامرانیو": "کامرانی",
  "کامرانیوں": "کامرانی",
  "کامو": "کام",
  "کاموں": "کام",
  "کامیابی": "کامیابی",
  "کامیابیاں": "کامیابی",
  "کامیابیو": "کامیابی",
  "کامیابیوں": "کامیابی",
  "کان": "کان",
  "کانے": "کانا",
  "کانٹے": "کانٹا",
  "کانٹا": "کانٹا",
  "کانٹو": "کانٹا",
  "کانٹوں": "کانٹا",
  "کانا": "کانا",
  "کاندھے": "کاندھا",
  "کاندھا": "کاندھا",
  "کاندھو": "کاندھا",
  "کاندھوں": "کاندھا",
  "کانفرنس": "کانفرنس",
  "کانفرنسو": "کانفرنس",
  "کانفرنسوں": "کانفرنس",
  "کانفرنسیں": "کانفرنس",
  "کانہ": "کانہ",
  "کانپ": "کانپنا",
  "کانپے": "کانپنا",
  "کانپں": "کانپنا",
  "کانپا": "کانپنا",
  "کانپنے": "کانپنا",
  "کانپنا": "کانپنا",
  "کانپنی": "کانپنا",
  "کانپتے": "کانپنا",
  "کانپتا": "کانپنا",
  "کانپتی": "کانپنا",
  "کانپتیں": "کانپنا",
  "کانپو": "کانپنا",
  "کانپوں": "کانپنا",
  "کانپی": "کانپنا",
  "کانپیے": "کانپنا",
  "کانپیں": "کانپنا",
  "کانو": "کانا",
  "کانوں": "کانا",
  "کاپٹر": "کاپٹر",
  "کاپٹرو": "کاپٹر",
  "کاپٹروں": "کاپٹر",
  "کاپی": "کاپی",
  "کاپیاں": "کاپی",
  "کاپیو": "کاپی",
  "کاپیوں": "کاپی",
  "کار": "کار",
  "کارڈ": "کارڈ",
  "کارڈو": "کارڈ",
  "کارڈوں": "کارڈ",
  "کارخانے": "کارخانہ",
  "کارخانہ": "کارخانہ",
  "کارخانو": "کارخانہ",
  "کارخانوں": "کارخانہ",
  "کارفرمائی": "کارفرمائی",
  "کارفرمائیاں": "کارفرمائی",
  "کارفرمائیو": "کارفرمائی",
  "کارفرمائیوں": "کارفرمائی",
  "کارکن": "کارکن",
  "کارکنو": "کارکن",
  "کارکنوں": "کارکن",
  "کارنامے": "کارنامہ",
  "کارنامہ": "کارنامہ",
  "کارنامو": "کارنامہ",
  "کارناموں": "کارنامہ",
  "کارندے": "کارندہ",
  "کارندہ": "کارندہ",
  "کارندو": "کارندہ",
  "کارندوں": "کارندہ",
  "کارروائی": "کارروائی",
  "کارروائیاں": "کارروائی",
  "کارروائیو": "کارروائی",
  "کارروائیوں": "کارروائی",
  "کارستانی": "کارستانی",
  "کارستانیاں": "کارستانی",
  "کارستانیو": "کارستانی",
  "کارستانیوں": "کارستانی",
  "کارتوس": "کارتوس",
  "کارتوسو": "کارتوس",
  "کارتوسوں": "کارتوس",
  "کارو": "کار",
  "کاروں": "کار",
  "کاروائی": "کاروائی",
  "کاروائیاں": "کاروائی",
  "کاروائیو": "کاروائی",
  "کاروائیوں": "کاروائی",
  "کاری": "کاری",
  "کاریں": "کار",
  "کاریاں": "کاری",
  "کاریو": "کاری",
  "کاریوں": "کاری",
  "کاسے": "کاسہ",
  "کاسہ": "کاسہ",
  "کاسو": "کاسہ",
  "کاسوں": "کاسہ",
  "کات": "کات",
  "کاتے": "کاتنا",
  "کاتں": "کاتنا",
  "کاتا": "کاتنا",
  "کاتب": "کاتب",
  "کاتبو": "کاتب",
  "کاتبوں": "کاتب",
  "کاتبیں": "کاتب",
  "کاتنے": "کاتنا",
  "کاتنا": "کاتنا",
  "کاتنی": "کاتنا",
  "کاتتے": "کاتنا",
  "کاتتا": "کاتنا",
  "کاتتی": "کاتنا",
  "کاتتیں": "کاتنا",
  "کاتو": "کات",
  "کاتوں": "کات",
  "کاتی": "کاتنا",
  "کاتیے": "کاتنا",
  "کاتیں": "کات",
  "کاوش": "کاوش",
  "کاوشو": "کاوش",
  "کاوشوں": "کاوش",
  "کائنات": "کائنات",
  "کائناتو": "کائنات",
  "کائناتوں": "کائنات",
  "کائناتیں": "کائنات",
  "کائی": "کائی",
  "کائیاں": "کائی",
  "کائیو": "کائی",
  "کائیوں": "کائی",
  "کب": "کَب",
  "کبڈی": "کبڈی",
  "کبڈیاں": "کبڈی",
  "کبڈیو": "کبڈی",
  "کبڈیوں": "کبڈی",
  "کباب": "کباب",
  "کبابو": "کباب",
  "کبابوں": "کباب",
  "کبابی": "کبابی",
  "کبابیو": "کبابی",
  "کبابیوں": "کبابی",
  "کبوتر": "کبوتر",
  "کبوترو": "کبوتر",
  "کبوتروں": "کبوتر",
  "کبوتری": "کبوتری",
  "کبوتریاں": "کبوتری",
  "کبوتریو": "کبوتری",
  "کبوتریوں": "کبوتری",
  "کچے": "کچہ",
  "کچہ": "کچہ",
  "کچہری": "کچہری",
  "کچہریاں": "کچہری",
  "کچہریو": "کچہری",
  "کچہریوں": "کچہری",
  "کچل": "کچلنا",
  "کچلے": "کچلنا",
  "کچلں": "کچلنا",
  "کچلا": "کچلنا",
  "کچلانے": "کچلنا",
  "کچلانا": "کچلنا",
  "کچلاتے": "کچلنا",
  "کچلاتا": "کچلنا",
  "کچلاتی": "کچلنا",
  "کچلاتیں": "کچلنا",
  "کچلاؤ": "کچلنا",
  "کچلاؤں": "کچلنا",
  "کچلائے": "کچلنا",
  "کچلائی": "کچلنا",
  "کچلائیے": "کچلنا",
  "کچلائیں": "کچلنا",
  "کچلایا": "کچلنا",
  "کچلنے": "کچلنا",
  "کچلنا": "کچلنا",
  "کچلنی": "کچلنا",
  "کچلتے": "کچلنا",
  "کچلتا": "کچلنا",
  "کچلتی": "کچلنا",
  "کچلتیں": "کچلنا",
  "کچلو": "کچلنا",
  "کچلوں": "کچلنا",
  "کچلوا": "کچلنا",
  "کچلوانے": "کچلنا",
  "کچلوانا": "کچلنا",
  "کچلواتے": "کچلنا",
  "کچلواتا": "کچلنا",
  "کچلواتی": "کچلنا",
  "کچلواتیں": "کچلنا",
  "کچلواؤ": "کچلنا",
  "کچلواؤں": "کچلنا",
  "کچلوائے": "کچلنا",
  "کچلوائی": "کچلنا",
  "کچلوائیے": "کچلنا",
  "کچلوائیں": "کچلنا",
  "کچلوایا": "کچلنا",
  "کچلی": "کچلنا",
  "کچلیے": "کچلنا",
  "کچلیں": "کچلنا",
  "کچو": "کچہ",
  "کچوں": "کچہ",
  "کچھ": "کچھنا",
  "کچھے": "کچھنا",
  "کچھں": "کچھنا",
  "کچھا": "کچھنا",
  "کچھانے": "کچھنا",
  "کچھانا": "کچھنا",
  "کچھاتے": "کچھنا",
  "کچھاتا": "کچھنا",
  "کچھاتی": "کچھنا",
  "کچھاتیں": "کچھنا",
  "کچھاؤ": "کچھنا",
  "کچھاؤں": "کچھنا",
  "کچھائے": "کچھنا",
  "کچھائی": "کچھنا",
  "کچھائیے": "کچھنا",
  "کچھائیں": "کچھنا",
  "کچھایا": "کچھنا",
  "کچھنے": "کچھنا",
  "کچھنا": "کچھنا",
  "کچھنی": "کچھنا",
  "کچھتے": "کچھنا",
  "کچھتا": "کچھنا",
  "کچھتی": "کچھنا",
  "کچھتیں": "کچھنا",
  "کچھو": "کچھنا",
  "کچھوں": "کچھنا",
  "کچھوا": "کچھنا",
  "کچھوانے": "کچھنا",
  "کچھوانا": "کچھنا",
  "کچھواتے": "کچھنا",
  "کچھواتا": "کچھنا",
  "کچھواتی": "کچھنا",
  "کچھواتیں": "کچھنا",
  "کچھواؤ": "کچھنا",
  "کچھواؤں": "کچھنا",
  "کچھوائے": "کچھنا",
  "کچھوائی": "کچھنا",
  "کچھوائیے": "کچھنا",
  "کچھوائیں": "کچھنا",
  "کچھوایا": "کچھنا",
  "کچھی": "کچھنا",
  "کچھیے": "کچھنا",
  "کچھیں": "کچھنا",
  "کدے": "کدہ",
  "کدال": "کدال",
  "کدالو": "کدال",
  "کدالوں": "کدال",
  "کدالیں": "کدال",
  "کدہ": "کدہ",
  "کدو": "کدہ",
  "کدوں": "کدہ",
  "کدورت": "کدورت",
  "کدورتو": "کدورت",
  "کدورتوں": "کدورت",
  "کدورتیں": "کدورت",
  "کدھر": "کِدَھر",
  "کعبے": "کعبہ",
  "کعبہ": "کعبہ",
  "کعبو": "کعبہ",
  "کعبوں": "کعبہ",
  "کہ": "کہنا",
  "کہے": "کہنا",
  "کہں": "کہنا",
  "کہا": "کہنا",
  "کہاں": "کَہاں",
  "کہانی": "کہانی",
  "کہانیاں": "کہانی",
  "کہانیو": "کہانی",
  "کہانیوں": "کہانی",
  "کہار": "کہار",
  "کہارو": "کہار",
  "کہاروں": "کہار",
  "کہکشاں": "کہکشاں",
  "کہکشاؤ": "کہکشاں",
  "کہکشاؤں": "کہکشاں",
  "کہکشائیں": "کہکشاں",
  "کہلا": "کہنا",
  "کہلانے": "کہنا",
  "کہلانا": "کہنا",
  "کہلانی": "کہلانا",
  "کہلاتے": "کہنا",
  "کہلاتا": "کہنا",
  "کہلاتی": "کہنا",
  "کہلاتیں": "کہنا",
  "کہلاؤ": "کہنا",
  "کہلاؤں": "کہنا",
  "کہلائے": "کہنا",
  "کہلائی": "کہنا",
  "کہلائیے": "کہنا",
  "کہلائیں": "کہنا",
  "کہلایا": "کہنا",
  "کہلوا": "کہنا",
  "کہلوانے": "کہنا",
  "کہلوانا": "کہنا",
  "کہلواتے": "کہنا",
  "کہلواتا": "کہنا",
  "کہلواتی": "کہنا",
  "کہلواتیں": "کہنا",
  "کہلواؤ": "کہنا",
  "کہلواؤں": "کہنا",
  "کہلوائے": "کہنا",
  "کہلوائی": "کہنا",
  "کہلوائیے": "کہنا",
  "کہلوائیں": "کہنا",
  "کہلوایا": "کہنا",
  "کہنے": "کہنا",
  "کہنا": "کہنا",
  "کہنی": "کہنی",
  "کہنیاں": "کہنی",
  "کہنیو": "کہنی",
  "کہنیوں": "کہنی",
  "کہتے": "کہنا",
  "کہتا": "کہنا",
  "کہتی": "کہنا",
  "کہتیں": "کہنا",
  "کہو": "کہنا",
  "کہوے": "کہوہ",
  "کہوں": "کہنا",
  "کہوہ": "کہوہ",
  "کہوو": "کہوہ",
  "کہووں": "کہوہ",
  "کہی": "کہنا",
  "کہیے": "کہنا",
  "کہیں": "کہنا",
  "کجاوے": "کجاوہ",
  "کجاوہ": "کجاوہ",
  "کجاوو": "کجاوہ",
  "کجاووں": "کجاوہ",
  "ککڑی": "ککڑی",
  "ککڑیاں": "ککڑی",
  "ککڑیو": "ککڑی",
  "ککڑیوں": "ککڑی",
  "کل": "کُل",
  "کلّے": "کلّا",
  "کلّا": "کلّا",
  "کلّو": "کلّا",
  "کلّوں": "کلّا",
  "کلے": "کلا",
  "کلا": "کلا",
  "کلاشنکوف": "کلاشنکوف",
  "کلاشنکوفو": "کلاشنکوف",
  "کلاشنکوفوں": "کلاشنکوف",
  "کلاشنکوفیں": "کلاشنکوف",
  "کلام": "کلام",
  "کلامو": "کلام",
  "کلاموں": "کلام",
  "کلامی": "کلامی",
  "کلامیاں": "کلامی",
  "کلامیو": "کلامی",
  "کلامیوں": "کلامی",
  "کلاس": "کلاس",
  "کلاسو": "کلاس",
  "کلاسوں": "کلاس",
  "کلاسیں": "کلاس",
  "کلاؤ": "کلا",
  "کلاؤں": "کلا",
  "کلائی": "کلائی",
  "کلائیں": "کلا",
  "کلائیاں": "کلائی",
  "کلائیو": "کلائی",
  "کلائیوں": "کلائی",
  "کلب": "کلب",
  "کلبو": "کلب",
  "کلبوں": "کلب",
  "کلکتہ": "کلکتہ",
  "کلمے": "کلمہ",
  "کلمہ": "کلمہ",
  "کلمو": "کلمہ",
  "کلموں": "کلمہ",
  "کلو": "کلا",
  "کلوں": "کلا",
  "کلی": "کلی",
  "کلیے": "کلیہ",
  "کلیاں": "کلی",
  "کلیہ": "کلیہ",
  "کلیجے": "کلیجہ",
  "کلیجہ": "کلیجہ",
  "کلیجو": "کلیجہ",
  "کلیجوں": "کلیجہ",
  "کلیجی": "کلیجی",
  "کلیجیاں": "کلیجی",
  "کلیجیو": "کلیجی",
  "کلیجیوں": "کلیجی",
  "کلیم": "کلیم",
  "کلیمو": "کلیم",
  "کلیموں": "کلیم",
  "کلیو": "کلیہ",
  "کلیوں": "کلیہ",
  "کم": "کم",
  "کما": "کمانا",
  "کمال": "کمال",
  "کمالے": "کمالہ",
  "کمالہ": "کمالہ",
  "کمالو": "کمالہ",
  "کمالوں": "کمالہ",
  "کمان": "کمان",
  "کمانڈ": "کمانڈ",
  "کمانڈر": "کمانڈر",
  "کمانڈرو": "کمانڈر",
  "کمانڈروں": "کمانڈر",
  "کمانڈو": "کمانڈ",
  "کمانڈوں": "کمانڈ",
  "کمانڈیں": "کمانڈ",
  "کمانے": "کمانا",
  "کمانا": "کمانا",
  "کمانو": "کمان",
  "کمانوں": "کمان",
  "کمانی": "کمانا",
  "کمانیں": "کمان",
  "کماتے": "کمانا",
  "کماتا": "کمانا",
  "کماتی": "کمانا",
  "کماتیں": "کمانا",
  "کماؤ": "کمانا",
  "کماؤں": "کمانا",
  "کمائے": "کمانا",
  "کمائی": "کمائی",
  "کمائیے": "کمانا",
  "کمائیں": "کمانا",
  "کمائیاں": "کمائی",
  "کمائیو": "کمائی",
  "کمائیوں": "کمائی",
  "کمایا": "کمانا",
  "کمبل": "کمبل",
  "کمبلو": "کمبل",
  "کمبلوں": "کمبل",
  "کمبلیں": "کمبل",
  "کمہار": "کمہار",
  "کمہارو": "کمہار",
  "کمہاروں": "کمہار",
  "کمہاریں": "کمہار",
  "کمپنی": "کمپنی",
  "کمپنیاں": "کمپنی",
  "کمپنیو": "کمپنی",
  "کمپنیوں": "کمپنی",
  "کمر": "کمر",
  "کمرے": "کمرا",
  "کمرا": "کمرا",
  "کمرہ": "کمرہ",
  "کمرو": "کمرا",
  "کمروں": "کمرا",
  "کمریں": "کمر",
  "کمی": "کمی",
  "کمیٹی": "کمیٹی",
  "کمیٹیاں": "کمیٹی",
  "کمیٹیو": "کمیٹی",
  "کمیٹیوں": "کمیٹی",
  "کمینے": "کمینہ",
  "کمینگی": "کمینگی",
  "کمینگیاں": "کمینگی",
  "کمینگیو": "کمینگی",
  "کمینگیوں": "کمینگی",
  "کمینہ": "کمینہ",
  "کمینو": "کمینہ",
  "کمینوں": "کمینہ",
  "کمیو": "کمی",
  "کمیوں": "کمی",
  "کمیونسٹ": "کمیونسٹ",
  "کمیونسٹو": "کمیونسٹ",
  "کمیونسٹوں": "کمیونسٹ",
  "کمزور": "کمزور",
  "کمزورو": "کمزور",
  "کمزوروں": "کمزور",
  "کمزوری": "کمزوری",
  "کمزوریاں": "کمزوری",
  "کمزوریو": "کمزوری",
  "کمزوریوں": "کمزوری",
  "کن": "کَیا",
  "کنڈلی": "کنڈلی",
  "کنڈلیاں": "کنڈلی",
  "کنڈلیو": "کنڈلی",
  "کنڈلیوں": "کنڈلی",
  "کنارے": "کنارا",
  "کنارا": "کنارا",
  "کنارہ": "کنارہ",
  "کنارو": "کنارا",
  "کناروں": "کنارا",
  "کنایے": "کنایہ",
  "کنایہ": "کنایہ",
  "کنایو": "کنایہ",
  "کنایوں": "کنایہ",
  "کنبے": "کنبہ",
  "کنبہ": "کنبہ",
  "کنبو": "کنبہ",
  "کنبوں": "کنبہ",
  "کنچے": "کنچا",
  "کنچا": "کنچا",
  "کنچو": "کنچا",
  "کنچوں": "کنچا",
  "کندھے": "کندھا",
  "کندھا": "کندھا",
  "کندھو": "کندھا",
  "کندھوں": "کندھا",
  "کنگن": "کنگن",
  "کنگنو": "کنگن",
  "کنگنوں": "کنگن",
  "کنگنی": "کنگنی",
  "کنگنیاں": "کنگنی",
  "کنگنیو": "کنگنی",
  "کنگنیوں": "کنگنی",
  "کنگھی": "کنگھی",
  "کنگھیاں": "کنگھی",
  "کنگھیو": "کنگھی",
  "کنگھیوں": "کنگھی",
  "کنجڑے": "کنجڑا",
  "کنجڑا": "کنجڑا",
  "کنجڑہ": "کنجڑہ",
  "کنجڑو": "کنجڑا",
  "کنجڑوں": "کنجڑا",
  "کنجر": "کنجر",
  "کنجرو": "کنجر",
  "کنجروں": "کنجر",
  "کنجی": "کنجی",
  "کنجیاں": "کنجی",
  "کنجیو": "کنجی",
  "کنجیوں": "کنجی",
  "کنکشن": "کنکشن",
  "کنکشنو": "کنکشن",
  "کنکشنوں": "کنکشن",
  "کنکر": "کنکر",
  "کنکرو": "کنکر",
  "کنکروں": "کنکر",
  "کنکری": "کنکری",
  "کنکریں": "کنکر",
  "کنکریاں": "کنکری",
  "کنکریو": "کنکری",
  "کنکریوں": "کنکری",
  "کنپٹی": "کنپٹی",
  "کنپٹیاں": "کنپٹی",
  "کنپٹیو": "کنپٹی",
  "کنپٹیوں": "کنپٹی",
  "کنواں": "کنواں",
  "کنوار": "کنوار",
  "کنوارے": "کنوارا",
  "کنوارا": "کنوارا",
  "کنوارو": "کنوارا",
  "کنواروں": "کنوارا",
  "کنواری": "کنواری",
  "کنواریاں": "کنواری",
  "کنواریو": "کنواری",
  "کنواریوں": "کنواری",
  "کنول": "کنول",
  "کنولو": "کنول",
  "کنولوں": "کنول",
  "کنووںں": "کنواں",
  "کنویں": "کنواں",
  "کنی": "کنی",
  "کنیا": "کنیا",
  "کنیاں": "کنی",
  "کنیو": "کنی",
  "کنیوں": "کنی",
  "کنیز": "کنیز",
  "کنیزو": "کنیز",
  "کنیزوں": "کنیز",
  "کنیزیں": "کنیز",
  "کپڑے": "کپڑا",
  "کپڑا": "کپڑا",
  "کپڑو": "کپڑا",
  "کپڑوں": "کپڑا",
  "کر": "کرنا",
  "کرّے": "کرّہ",
  "کرّہ": "کرّہ",
  "کرّو": "کرّہ",
  "کرّوں": "کرّہ",
  "کرے": "کرہ",
  "کرں": "کرنا",
  "کرشمے": "کرشمہ",
  "کرشمہ": "کرشمہ",
  "کرشمو": "کرشمہ",
  "کرشموں": "کرشمہ",
  "کرا": "کرنا",
  "کراے": "کراہ",
  "کراہ": "کراہ",
  "کرامات": "کرامات",
  "کراماتو": "کرامات",
  "کراماتوں": "کرامات",
  "کراماتیں": "کرامات",
  "کرانے": "کرنا",
  "کرانا": "کرنا",
  "کرانی": "کرانا",
  "کراتے": "کرنا",
  "کراتا": "کرنا",
  "کراتی": "کرنا",
  "کراتیں": "کرنا",
  "کراو": "کراہ",
  "کراوں": "کراہ",
  "کراؤ": "کرنا",
  "کراؤں": "کرنا",
  "کرایے": "کرایہ",
  "کرائے": "کرنا",
  "کرائی": "کرنا",
  "کرائیے": "کرنا",
  "کرائیں": "کرنا",
  "کرایا": "کرایا",
  "کرایاں": "کرایا",
  "کرایہ": "کرایہ",
  "کرایو": "کرایہ",
  "کرایوں": "کرایہ",
  "کرد": "کرد",
  "کردار": "کردار",
  "کردارو": "کردار",
  "کرداروں": "کردار",
  "کردو": "کرد",
  "کردوں": "کرد",
  "کردی": "کردینا",
  "کردیے": "کردینا",
  "کردیں": "کردینا",
  "کردیا": "کردینا",
  "کردینے": "کردینا",
  "کردینا": "کردینا",
  "کردینی": "کردینا",
  "کردیتے": "کردینا",
  "کردیتا": "کردینا",
  "کردیتی": "کردینا",
  "کردیتیں": "کردینا",
  "کردیو": "کردینا",
  "کردیوں": "کردینا",
  "کردیی": "کردینا",
  "کردییے": "کردینا",
  "کردییں": "کردینا",
  "کرہ": "کرہ",
  "کرہے": "کرہہ",
  "کرہہ": "کرہہ",
  "کرہو": "کرہہ",
  "کرہوں": "کرہہ",
  "کرکے": "کرکہ",
  "کرکہ": "کرکہ",
  "کرکو": "کرکہ",
  "کرکوں": "کرکہ",
  "کرلی": "کرلینا",
  "کرلیے": "کرلینا",
  "کرلیں": "کرلینا",
  "کرلیا": "کرلینا",
  "کرلینے": "کرلینا",
  "کرلینا": "کرلینا",
  "کرلینی": "کرلینا",
  "کرلیتے": "کرلینا",
  "کرلیتا": "کرلینا",
  "کرلیتی": "کرلینا",
  "کرلیتیں": "کرلینا",
  "کرلیو": "کرلینا",
  "کرلیوں": "کرلینا",
  "کرلیی": "کرلینا",
  "کرلییے": "کرلینا",
  "کرلییں": "کرلینا",
  "کرم": "کرم",
  "کرمو": "کرم",
  "کرموں": "کرم",
  "کرنے": "کرنا",
  "کرنا": "کرنا",
  "کرنی": "کرنا",
  "کرسی": "کرسی",
  "کرسیاں": "کرسی",
  "کرسیو": "کرسی",
  "کرسیوں": "کرسی",
  "کرتے": "کرتہ",
  "کرتا": "کرنا",
  "کرتہ": "کرتہ",
  "کرتو": "کرتہ",
  "کرتوں": "کرتہ",
  "کرتوت": "کرتوت",
  "کرتوتو": "کرتوت",
  "کرتوتوں": "کرتوت",
  "کرتوتیں": "کرتوت",
  "کرتی": "کرنا",
  "کرتیں": "کرنا",
  "کرو": "کرہ",
  "کروں": "کرہ",
  "کروڑ": "کروڑ",
  "کروڑو": "کروڑ",
  "کروڑوں": "کروڑ",
  "کروٹ": "کروٹ",
  "کروٹو": "کروٹ",
  "کروٹوں": "کروٹ",
  "کروٹیں": "کروٹ",
  "کروا": "کرنا",
  "کروانے": "کرنا",
  "کروانا": "کرنا",
  "کرواتے": "کرنا",
  "کرواتا": "کرنا",
  "کرواتی": "کرنا",
  "کرواتیں": "کرنا",
  "کرواؤ": "کرنا",
  "کرواؤں": "کرنا",
  "کروائے": "کرنا",
  "کروائی": "کرنا",
  "کروائیے": "کرنا",
  "کروائیں": "کرنا",
  "کروایا": "کرنا",
  "کری": "کری",
  "کریے": "کرنا",
  "کریں": "کرنا",
  "کریاں": "کری",
  "کرید": "کریدنا",
  "کریدے": "کریدنا",
  "کریدں": "کریدنا",
  "کریدا": "کریدنا",
  "کریدنے": "کریدنا",
  "کریدنا": "کریدنا",
  "کریدنی": "کریدنا",
  "کریدتے": "کریدنا",
  "کریدتا": "کریدنا",
  "کریدتی": "کریدنا",
  "کریدتیں": "کریدنا",
  "کریدو": "کریدنا",
  "کریدوں": "کریدنا",
  "کریدی": "کریدنا",
  "کریدیے": "کریدنا",
  "کریدیں": "کریدنا",
  "کریو": "کری",
  "کریوں": "کری",
  "کس": "کسنا",
  "کسے": "کسنا",
  "کسں": "کسنا",
  "کسا": "کسنا",
  "کسان": "کسان",
  "کسانے": "کسنا",
  "کسانا": "کسنا",
  "کسانو": "کسان",
  "کسانوں": "کسان",
  "کساتے": "کسنا",
  "کساتا": "کسنا",
  "کساتی": "کسنا",
  "کساتیں": "کسنا",
  "کساؤ": "کسنا",
  "کساؤں": "کسنا",
  "کسائے": "کسنا",
  "کسائی": "کسنا",
  "کسائیے": "کسنا",
  "کسائیں": "کسنا",
  "کسایا": "کسنا",
  "کسبی": "کسبی",
  "کسبیو": "کسبی",
  "کسبیوں": "کسبی",
  "کسمسا": "کسمسانا",
  "کسمسانے": "کسمسانا",
  "کسمسانا": "کسمسانا",
  "کسمسانی": "کسمسانا",
  "کسمساتے": "کسمسانا",
  "کسمساتا": "کسمسانا",
  "کسمساتی": "کسمسانا",
  "کسمساتیں": "کسمسانا",
  "کسمساؤ": "کسمسانا",
  "کسمساؤں": "کسمسانا",
  "کسمسائے": "کسمسانا",
  "کسمسائی": "کسمسانا",
  "کسمسائیے": "کسمسانا",
  "کسمسائیں": "کسمسانا",
  "کسمسایا": "کسمسانا",
  "کسنے": "کسنا",
  "کسنا": "کسنا",
  "کسنی": "کسنا",
  "کستے": "کسنا",
  "کستا": "کسنا",
  "کستی": "کسنا",
  "کستیں": "کسنا",
  "کسو": "کسنا",
  "کسوں": "کسنا",
  "کسوٹی": "کسوٹی",
  "کسوٹیاں": "کسوٹی",
  "کسوٹیو": "کسوٹی",
  "کسوٹیوں": "کسوٹی",
  "کسوا": "کسنا",
  "کسوانے": "کسنا",
  "کسوانا": "کسنا",
  "کسواتے": "کسنا",
  "کسواتا": "کسنا",
  "کسواتی": "کسنا",
  "کسواتیں": "کسنا",
  "کسواؤ": "کسنا",
  "کسواؤں": "کسنا",
  "کسوائے": "کسنا",
  "کسوائی": "کسنا",
  "کسوائیے": "کسنا",
  "کسوائیں": "کسنا",
  "کسوایا": "کسنا",
  "کسی": "کسنا",
  "کسیے": "کسنا",
  "کسیں": "کسنا",
  "کتّے": "کتّا",
  "کتّا": "کتّا",
  "کتّو": "کتّا",
  "کتّوں": "کتّا",
  "کتے": "کتا",
  "کتا": "کتا",
  "کتاب": "کتاب",
  "کتابچے": "کتابچہ",
  "کتابچہ": "کتابچہ",
  "کتابچو": "کتابچہ",
  "کتابچوں": "کتابچہ",
  "کتابو": "کتاب",
  "کتابوں": "کتاب",
  "کتابی": "کتابی",
  "کتابیں": "کتاب",
  "کتابیو": "کتابی",
  "کتابیوں": "کتابی",
  "کتب": "کتب",
  "کتبے": "کتبہ",
  "کتبخانے": "کتبخانہ",
  "کتبخانہ": "کتبخانہ",
  "کتبخانو": "کتبخانہ",
  "کتبخانوں": "کتبخانہ",
  "کتبہ": "کتبہ",
  "کتبو": "کتبہ",
  "کتبوں": "کتبہ",
  "کتنے": "کتنا",
  "کتنا": "کتنا",
  "کتنو": "کتنا",
  "کتنوں": "کتنا",
  "کتنی": "کِتنا",
  "کتر": "کتر",
  "کترے": "کترنا",
  "کترں": "کترنا",
  "کترا": "کترانا",
  "کترانے": "کترانا",
  "کترانا": "کترانا",
  "کترانی": "کترانا",
  "کتراتے": "کترانا",
  "کتراتا": "کترانا",
  "کتراتی": "کترانا",
  "کتراتیں": "کترانا",
  "کتراؤ": "کترانا",
  "کتراؤں": "کترانا",
  "کترائے": "کترانا",
  "کترائی": "کترانا",
  "کترائیے": "کترانا",
  "کترائیں": "کترانا",
  "کترایا": "کترانا",
  "کترن": "کترن",
  "کترنے": "کترنا",
  "کترنا": "کترنا",
  "کترنو": "کترن",
  "کترنوں": "کترن",
  "کترنی": "کترنا",
  "کترنیں": "کترن",
  "کترتے": "کترنا",
  "کترتا": "کترنا",
  "کترتی": "کترنا",
  "کترتیں": "کترنا",
  "کترو": "کتر",
  "کتروں": "کتر",
  "کتروا": "کترنا",
  "کتروانے": "کترنا",
  "کتروانا": "کترنا",
  "کترواتے": "کترنا",
  "کترواتا": "کترنا",
  "کترواتی": "کترنا",
  "کترواتیں": "کترنا",
  "کترواؤ": "کترنا",
  "کترواؤں": "کترنا",
  "کتروائے": "کترنا",
  "کتروائی": "کترنا",
  "کتروائیے": "کترنا",
  "کتروائیں": "کترنا",
  "کتروایا": "کترنا",
  "کتری": "کترنا",
  "کتریے": "کترنا",
  "کتریں": "کتر",
  "کتو": "کتا",
  "کتوں": "کتا",
  "کو": "کو",
  "کوے": "کوا",
  "کوڑے": "کوڑا",
  "کوڑا": "کوڑا",
  "کوڑہ": "کوڑہ",
  "کوڑو": "کوڑا",
  "کوڑوں": "کوڑا",
  "کوڑھی": "کوڑھی",
  "کوڑھیو": "کوڑھی",
  "کوڑھیوں": "کوڑھی",
  "کوٹے": "کوٹہ",
  "کوٹہ": "کوٹہ",
  "کوٹو": "کوٹہ",
  "کوٹوں": "کوٹہ",
  "کوٹھے": "کوٹھا",
  "کوٹھڑی": "کوٹھڑی",
  "کوٹھڑیاں": "کوٹھڑی",
  "کوٹھڑیو": "کوٹھڑی",
  "کوٹھڑیوں": "کوٹھڑی",
  "کوٹھا": "کوٹھا",
  "کوٹھری": "کوٹھری",
  "کوٹھریاں": "کوٹھری",
  "کوٹھریو": "کوٹھری",
  "کوٹھریوں": "کوٹھری",
  "کوٹھو": "کوٹھا",
  "کوٹھوں": "کوٹھا",
  "کوٹھی": "کوٹھی",
  "کوٹھیاں": "کوٹھی",
  "کوٹھیو": "کوٹھی",
  "کوٹھیوں": "کوٹھی",
  "کوشش": "کوشش",
  "کوششو": "کوشش",
  "کوششوں": "کوشش",
  "کوششیں": "کوشش",
  "کوا": "کوا",
  "کواڑ": "کواڑ",
  "کواڑو": "کواڑ",
  "کواڑوں": "کواڑ",
  "کوچ": "کوچ",
  "کوچے": "کوچہ",
  "کوچہ": "کوچہ",
  "کوچو": "کوچہ",
  "کوچوں": "کوچہ",
  "کود": "کودنا",
  "کودے": "کودنا",
  "کودں": "کودنا",
  "کودا": "کودنا",
  "کودنے": "کودنا",
  "کودنا": "کودنا",
  "کودنی": "کودنا",
  "کودتے": "کودنا",
  "کودتا": "کودنا",
  "کودتی": "کودنا",
  "کودتیں": "کودنا",
  "کودو": "کودنا",
  "کودوں": "کودنا",
  "کودی": "کودنا",
  "کودیے": "کودنا",
  "کودیں": "کودنا",
  "کوک": "کوک",
  "کوکے": "کوکہ",
  "کوکہ": "کوکہ",
  "کوکو": "کوکہ",
  "کوکوں": "کوکہ",
  "کوکیں": "کوک",
  "کوکھ": "کوکھ",
  "کوکھو": "کوکھ",
  "کوکھوں": "کوکھ",
  "کوکھیں": "کوکھ",
  "کولھے": "کولھا",
  "کولھا": "کولھا",
  "کولھو": "کولھا",
  "کولھوں": "کولھا",
  "کون": "کَیا",
  "کونے": "کونا",
  "کونا": "کونا",
  "کونہ": "کونہ",
  "کونج": "کونج",
  "کونجو": "کونج",
  "کونجوں": "کونج",
  "کونجیں": "کونج",
  "کونپل": "کونپل",
  "کونپلو": "کونپل",
  "کونپلوں": "کونپل",
  "کونپلیں": "کونپل",
  "کونسے": "کَونسا",
  "کونسا": "کَونسا",
  "کونسی": "کَونسا",
  "کونو": "کونا",
  "کونوں": "کونا",
  "کورے": "کورہ",
  "کورہ": "کورہ",
  "کورو": "کورہ",
  "کوروں": "کورہ",
  "کوس": "کوس",
  "کوسے": "کوسنا",
  "کوسں": "کوسنا",
  "کوسا": "کوسنا",
  "کوسنے": "کوسنا",
  "کوسنا": "کوسنا",
  "کوسنی": "کوسنا",
  "کوستے": "کوسنا",
  "کوستا": "کوسنا",
  "کوستی": "کوسنا",
  "کوستیں": "کوسنا",
  "کوسو": "کوس",
  "کوسوں": "کوس",
  "کوسی": "کوسنا",
  "کوسیے": "کوسنا",
  "کوسیں": "کوسنا",
  "کوتاہی": "کوتاہی",
  "کوتاہیاں": "کوتاہی",
  "کوتاہیو": "کوتاہی",
  "کوتاہیوں": "کوتاہی",
  "کوو": "کوا",
  "کووں": "کوا",
  "کوئل": "کوئل",
  "کوئلے": "کوئلہ",
  "کوئلہ": "کوئلہ",
  "کوئلو": "کوئلہ",
  "کوئلوں": "کوئلہ",
  "کوئی": "کوئی",
  "کوزے": "کوزہ",
  "کوزہ": "کوزہ",
  "کوزو": "کوزہ",
  "کوزوں": "کوزہ",
  "کی": "کم",
  "کیے": "کرنا",
  "کیں": "کرنا",
  "کیڑے": "کیڑا",
  "کیڑا": "کیڑا",
  "کیڑو": "کیڑا",
  "کیڑوں": "کیڑا",
  "کئے": "کَئے",
  "کئی": "کئی",
  "کئیو": "کئی",
  "کئیوں": "کئی",
  "کیا": "کَیا",
  "کیاری": "کیاری",
  "کیاریاں": "کیاری",
  "کیاریو": "کیاری",
  "کیاریوں": "کیاری",
  "کیبن": "کیبن",
  "کیبنو": "کیبن",
  "کیبنوں": "کیبن",
  "کیبنیں": "کیبن",
  "کیفیت": "کیفیت",
  "کیفیتو": "کیفیت",
  "کیفیتوں": "کیفیت",
  "کیفیتیں": "کیفیت",
  "کیکر": "کیکر",
  "کیکرو": "کیکر",
  "کیکروں": "کیکر",
  "کیل": "کیل",
  "کیلے": "کیلا",
  "کیلا": "کیلا",
  "کیلو": "کیلا",
  "کیلوں": "کیلا",
  "کیلیں": "کیل",
  "کیمپ": "کیمپ",
  "کیمپو": "کیمپ",
  "کیمپوں": "کیمپ",
  "کیمرے": "کیمرہ",
  "کیمرہ": "کیمرہ",
  "کیمرو": "کیمرہ",
  "کیمروں": "کیمرہ",
  "کین": "کین",
  "کینے": "کینہ",
  "کینچلی": "کینچلی",
  "کینچلیاں": "کینچلی",
  "کینچلیو": "کینچلی",
  "کینچلیوں": "کینچلی",
  "کینہ": "کینہ",
  "کینو": "کینہ",
  "کینوں": "کینہ",
  "کیس": "کیس",
  "کیسے": "کیسا",
  "کیسا": "کیسا",
  "کیسو": "کیسا",
  "کیسوں": "کیسا",
  "کیسی": "کَیسا",
  "کیتلی": "کیتلی",
  "کیتلیاں": "کیتلی",
  "کیتلیو": "کیتلی",
  "کیتلیوں": "کیتلی",
  "کیوں": "کِیوُں",
  "کیونکہ": "کیونکہ",
  "کیونکر": "کِیُونْکَر",
  "کھُل": "کھُلْنا",
  "کھُلْں": "کھُلْنا",
  "کھُلْنے": "کھُلْنا",
  "کھُلْنا": "کھُلْنا",
  "کھُلْنی": "کھُلْنا",
  "کھُلْتے": "کھُلْنا",
  "کھُلْتا": "کھُلْنا",
  "کھُلْتی": "کھُلْنا",
  "کھُلْتیں": "کھُلْنا",
  "کھُلْوا": "کھُلْنا",
  "کھُلْوانے": "کھُلْنا",
  "کھُلْوانا": "کھُلْنا",
  "کھُلْواتے": "کھُلْنا",
  "کھُلْواتا": "کھُلْنا",
  "کھُلْواتی": "کھُلْنا",
  "کھُلْواتیں": "کھُلْنا",
  "کھُلْواؤ": "کھُلْنا",
  "کھُلْواؤں": "کھُلْنا",
  "کھُلْوائے": "کھُلْنا",
  "کھُلْوائی": "کھُلْنا",
  "کھُلْوائیے": "کھُلْنا",
  "کھُلْوائیں": "کھُلْنا",
  "کھُلْوایا": "کھُلْنا",
  "کھُلے": "کھُلْنا",
  "کھُلں": "کھُلنا",
  "کھُلا": "کھُلْنا",
  "کھُلنے": "کھُلنا",
  "کھُلنا": "کھُلنا",
  "کھُلنی": "کھُلنا",
  "کھُلتے": "کھُلنا",
  "کھُلتا": "کھُلنا",
  "کھُلتی": "کھُلنا",
  "کھُلتیں": "کھُلنا",
  "کھُلو": "کھُلْنا",
  "کھُلوں": "کھُلْنا",
  "کھُلوا": "کھُلنا",
  "کھُلوانے": "کھُلنا",
  "کھُلوانا": "کھُلنا",
  "کھُلواتے": "کھُلنا",
  "کھُلواتا": "کھُلنا",
  "کھُلواتی": "کھُلنا",
  "کھُلواتیں": "کھُلنا",
  "کھُلواؤ": "کھُلنا",
  "کھُلواؤں": "کھُلنا",
  "کھُلوائے": "کھُلنا",
  "کھُلوائی": "کھُلنا",
  "کھُلوائیے": "کھُلنا",
  "کھُلوائیں": "کھُلنا",
  "کھُلوایا": "کھُلنا",
  "کھُلی": "کھُلْنا",
  "کھُلیے": "کھُلْنا",
  "کھُلیں": "کھُلْنا",
  "کھڑاواں": "کھڑاواں",
  "کھڑاووںں": "کھڑاواں",
  "کھڑاویں": "کھڑاواں",
  "کھڑکی": "کھڑکی",
  "کھڑکیاں": "کھڑکی",
  "کھڑکیو": "کھڑکی",
  "کھڑکیوں": "کھڑکی",
  "کھٹک": "کھٹکنا",
  "کھٹکے": "کھٹکنا",
  "کھٹکں": "کھٹکنا",
  "کھٹکا": "کھٹکنا",
  "کھٹکانے": "کھٹکنا",
  "کھٹکانا": "کھٹکنا",
  "کھٹکاتے": "کھٹکنا",
  "کھٹکاتا": "کھٹکنا",
  "کھٹکاتی": "کھٹکنا",
  "کھٹکاتیں": "کھٹکنا",
  "کھٹکاؤ": "کھٹکنا",
  "کھٹکاؤں": "کھٹکنا",
  "کھٹکائے": "کھٹکنا",
  "کھٹکائی": "کھٹکنا",
  "کھٹکائیے": "کھٹکنا",
  "کھٹکائیں": "کھٹکنا",
  "کھٹکایا": "کھٹکنا",
  "کھٹکنے": "کھٹکنا",
  "کھٹکنا": "کھٹکنا",
  "کھٹکنی": "کھٹکنا",
  "کھٹکتے": "کھٹکنا",
  "کھٹکتا": "کھٹکنا",
  "کھٹکتی": "کھٹکنا",
  "کھٹکتیں": "کھٹکنا",
  "کھٹکو": "کھٹکنا",
  "کھٹکوں": "کھٹکنا",
  "کھٹکوا": "کھٹکنا",
  "کھٹکوانے": "کھٹکنا",
  "کھٹکوانا": "کھٹکنا",
  "کھٹکواتے": "کھٹکنا",
  "کھٹکواتا": "کھٹکنا",
  "کھٹکواتی": "کھٹکنا",
  "کھٹکواتیں": "کھٹکنا",
  "کھٹکواؤ": "کھٹکنا",
  "کھٹکواؤں": "کھٹکنا",
  "کھٹکوائے": "کھٹکنا",
  "کھٹکوائی": "کھٹکنا",
  "کھٹکوائیے": "کھٹکنا",
  "کھٹکوائیں": "کھٹکنا",
  "کھٹکوایا": "کھٹکنا",
  "کھٹکی": "کھٹکنا",
  "کھٹکیے": "کھٹکنا",
  "کھٹکیں": "کھٹکنا",
  "کھٹکھ": "کھٹکھٹا",
  "کھٹکھے": "کھٹکھٹا",
  "کھٹکھں": "کھٹکھٹا",
  "کھٹکھٹے": "کھٹکھٹا",
  "کھٹکھٹا": "کھٹکھٹا",
  "کھٹکھٹی": "کھٹکھٹا",
  "کھٹکھا": "کھٹکھٹا",
  "کھٹکھتے": "کھٹکھٹا",
  "کھٹکھتا": "کھٹکھٹا",
  "کھٹکھتی": "کھٹکھٹا",
  "کھٹکھتیں": "کھٹکھٹا",
  "کھٹکھو": "کھٹکھٹا",
  "کھٹکھوں": "کھٹکھٹا",
  "کھٹکھی": "کھٹکھٹا",
  "کھٹکھیے": "کھٹکھٹا",
  "کھٹکھیں": "کھٹکھٹا",
  "کھٹمل": "کھٹمل",
  "کھٹملو": "کھٹمل",
  "کھٹملوں": "کھٹمل",
  "کھٹولے": "کھٹولہ",
  "کھٹولہ": "کھٹولہ",
  "کھٹولو": "کھٹولہ",
  "کھٹولوں": "کھٹولہ",
  "کھا": "کھانا",
  "کھاٹ": "کھاٹ",
  "کھاٹو": "کھاٹ",
  "کھاٹوں": "کھاٹ",
  "کھال": "کھال",
  "کھالو": "کھال",
  "کھالوں": "کھال",
  "کھالیں": "کھال",
  "کھانے": "کھانا",
  "کھانا": "کھانا",
  "کھانہ": "کھانہ",
  "کھانو": "کھانا",
  "کھانوں": "کھانا",
  "کھانی": "کھانا",
  "کھاتے": "کھاتہ",
  "کھاتا": "کھانا",
  "کھاتہ": "کھاتہ",
  "کھاتو": "کھاتہ",
  "کھاتوں": "کھاتہ",
  "کھاتی": "کھانا",
  "کھاتیں": "کھانا",
  "کھاؤ": "کھانا",
  "کھاؤں": "کھانا",
  "کھائے": "کھانا",
  "کھائی": "کھائی",
  "کھائیے": "کھانا",
  "کھائیں": "کھانا",
  "کھائیاں": "کھائی",
  "کھائیو": "کھائی",
  "کھائیوں": "کھائی",
  "کھایا": "کھانا",
  "کھچ": "کھچنا",
  "کھچے": "کھچنا",
  "کھچں": "کھچنا",
  "کھچا": "کھچنا",
  "کھچانے": "کھچنا",
  "کھچانا": "کھچنا",
  "کھچاتے": "کھچنا",
  "کھچاتا": "کھچنا",
  "کھچاتی": "کھچنا",
  "کھچاتیں": "کھچنا",
  "کھچاؤ": "کھچنا",
  "کھچاؤں": "کھچنا",
  "کھچائے": "کھچنا",
  "کھچائی": "کھچنا",
  "کھچائیے": "کھچنا",
  "کھچائیں": "کھچنا",
  "کھچایا": "کھچنا",
  "کھچنے": "کھچنا",
  "کھچنا": "کھچنا",
  "کھچنی": "کھچنا",
  "کھچتے": "کھچنا",
  "کھچتا": "کھچنا",
  "کھچتی": "کھچنا",
  "کھچتیں": "کھچنا",
  "کھچو": "کھچنا",
  "کھچوں": "کھچنا",
  "کھچوا": "کھچنا",
  "کھچوانے": "کھچنا",
  "کھچوانا": "کھچنا",
  "کھچواتے": "کھچنا",
  "کھچواتا": "کھچنا",
  "کھچواتی": "کھچنا",
  "کھچواتیں": "کھچنا",
  "کھچواؤ": "کھچنا",
  "کھچواؤں": "کھچنا",
  "کھچوائے": "کھچنا",
  "کھچوائی": "کھچنا",
  "کھچوائیے": "کھچنا",
  "کھچوائیں": "کھچنا",
  "کھچوایا": "کھچنا",
  "کھچی": "کھچنا",
  "کھچیے": "کھچنا",
  "کھچیں": "کھچنا",
  "کھدر": "کھدر",
  "کھدرے": "کھدرا",
  "کھدرا": "کھدرا",
  "کھدرو": "کھدرا",
  "کھدروں": "کھدرا",
  "کھدریں": "کھدر",
  "کھدیڑ": "کھدیڑنا",
  "کھدیڑے": "کھدیڑنا",
  "کھدیڑں": "کھدیڑنا",
  "کھدیڑا": "کھدیڑنا",
  "کھدیڑنے": "کھدیڑنا",
  "کھدیڑنا": "کھدیڑنا",
  "کھدیڑنی": "کھدیڑنا",
  "کھدیڑتے": "کھدیڑنا",
  "کھدیڑتا": "کھدیڑنا",
  "کھدیڑتی": "کھدیڑنا",
  "کھدیڑتیں": "کھدیڑنا",
  "کھدیڑو": "کھدیڑنا",
  "کھدیڑوں": "کھدیڑنا",
  "کھدیڑی": "کھدیڑنا",
  "کھدیڑیے": "کھدیڑنا",
  "کھدیڑیں": "کھدیڑنا",
  "کھج": "کھجنا",
  "کھجے": "کھجنا",
  "کھجں": "کھجنا",
  "کھجا": "کھجنا",
  "کھجانے": "کھجنا",
  "کھجانا": "کھجنا",
  "کھجانی": "کھجانا",
  "کھجاتے": "کھجنا",
  "کھجاتا": "کھجنا",
  "کھجاتی": "کھجنا",
  "کھجاتیں": "کھجنا",
  "کھجاؤ": "کھجنا",
  "کھجاؤں": "کھجنا",
  "کھجائے": "کھجنا",
  "کھجائی": "کھجنا",
  "کھجائیے": "کھجنا",
  "کھجائیں": "کھجنا",
  "کھجایا": "کھجنا",
  "کھجنے": "کھجنا",
  "کھجنا": "کھجنا",
  "کھجنی": "کھجنا",
  "کھجتے": "کھجنا",
  "کھجتا": "کھجنا",
  "کھجتی": "کھجنا",
  "کھجتیں": "کھجنا",
  "کھجو": "کھجنا",
  "کھجوں": "کھجنا",
  "کھجوا": "کھجنا",
  "کھجوانے": "کھجنا",
  "کھجوانا": "کھجنا",
  "کھجواتے": "کھجنا",
  "کھجواتا": "کھجنا",
  "کھجواتی": "کھجنا",
  "کھجواتیں": "کھجنا",
  "کھجواؤ": "کھجنا",
  "کھجواؤں": "کھجنا",
  "کھجوائے": "کھجنا",
  "کھجوائی": "کھجنا",
  "کھجوائیے": "کھجنا",
  "کھجوائیں": "کھجنا",
  "کھجوایا": "کھجنا",
  "کھجور": "کھجور",
  "کھجورو": "کھجور",
  "کھجوروں": "کھجور",
  "کھجوریں": "کھجور",
  "کھجی": "کھجنا",
  "کھجیے": "کھجنا",
  "کھجیں": "کھجنا",
  "کھل": "کھلنا",
  "کھلے": "کھلنا",
  "کھلں": "کھلنا",
  "کھلا": "کھانا",
  "کھلاڑی": "کھلاڑی",
  "کھلاڑیو": "کھلاڑی",
  "کھلاڑیوں": "کھلاڑی",
  "کھلانے": "کھانا",
  "کھلانا": "کھانا",
  "کھلاتے": "کھانا",
  "کھلاتا": "کھانا",
  "کھلاتی": "کھانا",
  "کھلاتیں": "کھانا",
  "کھلاؤ": "کھانا",
  "کھلاؤں": "کھانا",
  "کھلائے": "کھانا",
  "کھلائی": "کھانا",
  "کھلائیے": "کھانا",
  "کھلائیں": "کھانا",
  "کھلایا": "کھانا",
  "کھلنے": "کھلنا",
  "کھلنا": "کھلنا",
  "کھلنی": "کھلنا",
  "کھلتے": "کھلنا",
  "کھلتا": "کھلنا",
  "کھلتی": "کھلنا",
  "کھلتیں": "کھلنا",
  "کھلو": "کھلنا",
  "کھلوں": "کھلنا",
  "کھلوا": "کھانا",
  "کھلوانے": "کھانا",
  "کھلوانا": "کھانا",
  "کھلواتے": "کھانا",
  "کھلواتا": "کھانا",
  "کھلواتی": "کھانا",
  "کھلواتیں": "کھانا",
  "کھلواؤ": "کھانا",
  "کھلواؤں": "کھانا",
  "کھلوائے": "کھانا",
  "کھلوائی": "کھانا",
  "کھلوائیے": "کھانا",
  "کھلوائیں": "کھانا",
  "کھلوایا": "کھانا",
  "کھلونے": "کھلونا",
  "کھلونا": "کھلونا",
  "کھلونو": "کھلونا",
  "کھلونوں": "کھلونا",
  "کھلی": "کھلنا",
  "کھلیے": "کھلنا",
  "کھلیں": "کھلنا",
  "کھلیا": "کھلینا",
  "کھلینے": "کھلینا",
  "کھلینا": "کھلینا",
  "کھلینی": "کھلینا",
  "کھلیتے": "کھلینا",
  "کھلیتا": "کھلینا",
  "کھلیتی": "کھلینا",
  "کھلیتیں": "کھلینا",
  "کھلیو": "کھلینا",
  "کھلیوں": "کھلینا",
  "کھلیی": "کھلینا",
  "کھلییے": "کھلینا",
  "کھلییں": "کھلینا",
  "کھنڈر": "کھنڈر",
  "کھنڈرو": "کھنڈر",
  "کھنڈروں": "کھنڈر",
  "کھنے": "کھنہ",
  "کھنچا": "کھینچنا",
  "کھنچانے": "کھینچنا",
  "کھنچانا": "کھینچنا",
  "کھنچاتے": "کھینچنا",
  "کھنچاتا": "کھینچنا",
  "کھنچاتی": "کھینچنا",
  "کھنچاتیں": "کھینچنا",
  "کھنچاؤ": "کھینچنا",
  "کھنچاؤں": "کھینچنا",
  "کھنچائے": "کھینچنا",
  "کھنچائی": "کھینچنا",
  "کھنچائیے": "کھینچنا",
  "کھنچائیں": "کھینچنا",
  "کھنچایا": "کھینچنا",
  "کھنچوا": "کھینچنا",
  "کھنچوانے": "کھینچنا",
  "کھنچوانا": "کھینچنا",
  "کھنچواتے": "کھینچنا",
  "کھنچواتا": "کھینچنا",
  "کھنچواتی": "کھینچنا",
  "کھنچواتیں": "کھینچنا",
  "کھنچواؤ": "کھینچنا",
  "کھنچواؤں": "کھینچنا",
  "کھنچوائے": "کھینچنا",
  "کھنچوائی": "کھینچنا",
  "کھنچوائیے": "کھینچنا",
  "کھنچوائیں": "کھینچنا",
  "کھنچوایا": "کھینچنا",
  "کھنہ": "کھنہ",
  "کھنکار": "کھنکارنا",
  "کھنکارے": "کھنکارنا",
  "کھنکارں": "کھنکارنا",
  "کھنکارا": "کھنکارنا",
  "کھنکارنے": "کھنکارنا",
  "کھنکارنا": "کھنکارنا",
  "کھنکارنی": "کھنکارنا",
  "کھنکارتے": "کھنکارنا",
  "کھنکارتا": "کھنکارنا",
  "کھنکارتی": "کھنکارنا",
  "کھنکارتیں": "کھنکارنا",
  "کھنکارو": "کھنکارنا",
  "کھنکاروں": "کھنکارنا",
  "کھنکاری": "کھنکارنا",
  "کھنکاریے": "کھنکارنا",
  "کھنکاریں": "کھنکارنا",
  "کھنکھار": "کھنکھار",
  "کھنکھارو": "کھنکھار",
  "کھنکھاروں": "کھنکھار",
  "کھنکھاریں": "کھنکھار",
  "کھنو": "کھنہ",
  "کھنوں": "کھنہ",
  "کھنیچ": "کھنیچنا",
  "کھنیچے": "کھنیچنا",
  "کھنیچں": "کھنیچنا",
  "کھنیچا": "کھنیچنا",
  "کھنیچانے": "کھنیچنا",
  "کھنیچانا": "کھنیچنا",
  "کھنیچاتے": "کھنیچنا",
  "کھنیچاتا": "کھنیچنا",
  "کھنیچاتی": "کھنیچنا",
  "کھنیچاتیں": "کھنیچنا",
  "کھنیچاؤ": "کھنیچنا",
  "کھنیچاؤں": "کھنیچنا",
  "کھنیچائے": "کھنیچنا",
  "کھنیچائی": "کھنیچنا",
  "کھنیچائیے": "کھنیچنا",
  "کھنیچائیں": "کھنیچنا",
  "کھنیچایا": "کھنیچنا",
  "کھنیچنے": "کھنیچنا",
  "کھنیچنا": "کھنیچنا",
  "کھنیچنی": "کھنیچنا",
  "کھنیچتے": "کھنیچنا",
  "کھنیچتا": "کھنیچنا",
  "کھنیچتی": "کھنیچنا",
  "کھنیچتیں": "کھنیچنا",
  "کھنیچو": "کھنیچنا",
  "کھنیچوں": "کھنیچنا",
  "کھنیچوا": "کھنیچنا",
  "کھنیچوانے": "کھنیچنا",
  "کھنیچوانا": "کھنیچنا",
  "کھنیچواتے": "کھنیچنا",
  "کھنیچواتا": "کھنیچنا",
  "کھنیچواتی": "کھنیچنا",
  "کھنیچواتیں": "کھنیچنا",
  "کھنیچواؤ": "کھنیچنا",
  "کھنیچواؤں": "کھنیچنا",
  "کھنیچوائے": "کھنیچنا",
  "کھنیچوائی": "کھنیچنا",
  "کھنیچوائیے": "کھنیچنا",
  "کھنیچوائیں": "کھنیچنا",
  "کھنیچوایا": "کھنیچنا",
  "کھنیچی": "کھنیچنا",
  "کھنیچیے": "کھنیچنا",
  "کھنیچیں": "کھنیچنا",
  "کھپ": "کھپنا",
  "کھپے": "کھپنا",
  "کھپں": "کھپنا",
  "کھپا": "کھپنا",
  "کھپانے": "کھپنا",
  "کھپانا": "کھپنا",
  "کھپاتے": "کھپنا",
  "کھپاتا": "کھپنا",
  "کھپاتی": "کھپنا",
  "کھپاتیں": "کھپنا",
  "کھپاؤ": "کھپنا",
  "کھپاؤں": "کھپنا",
  "کھپائے": "کھپنا",
  "کھپائی": "کھپنا",
  "کھپائیے": "کھپنا",
  "کھپائیں": "کھپنا",
  "کھپایا": "کھپنا",
  "کھپنے": "کھپنا",
  "کھپنا": "کھپنا",
  "کھپنی": "کھپنا",
  "کھپتے": "کھپنا",
  "کھپتا": "کھپنا",
  "کھپتی": "کھپنا",
  "کھپتیں": "کھپنا",
  "کھپو": "کھپنا",
  "کھپوں": "کھپنا",
  "کھپوا": "کھپنا",
  "کھپوانے": "کھپنا",
  "کھپوانا": "کھپنا",
  "کھپواتے": "کھپنا",
  "کھپواتا": "کھپنا",
  "کھپواتی": "کھپنا",
  "کھپواتیں": "کھپنا",
  "کھپواؤ": "کھپنا",
  "کھپواؤں": "کھپنا",
  "کھپوائے": "کھپنا",
  "کھپوائی": "کھپنا",
  "کھپوائیے": "کھپنا",
  "کھپوائیں": "کھپنا",
  "کھپوایا": "کھپنا",
  "کھپی": "کھپنا",
  "کھپیے": "کھپنا",
  "کھپیں": "کھپنا",
  "کھرے": "کھرا",
  "کھرا": "کھرا",
  "کھرچ": "کھرچنا",
  "کھرچے": "کھرچنا",
  "کھرچں": "کھرچنا",
  "کھرچا": "کھرچنا",
  "کھرچانے": "کھرچنا",
  "کھرچانا": "کھرچنا",
  "کھرچاتے": "کھرچنا",
  "کھرچاتا": "کھرچنا",
  "کھرچاتی": "کھرچنا",
  "کھرچاتیں": "کھرچنا",
  "کھرچاؤ": "کھرچنا",
  "کھرچاؤں": "کھرچنا",
  "کھرچائے": "کھرچنا",
  "کھرچائی": "کھرچنا",
  "کھرچائیے": "کھرچنا",
  "کھرچائیں": "کھرچنا",
  "کھرچایا": "کھرچنا",
  "کھرچنے": "کھرچنا",
  "کھرچنا": "کھرچنا",
  "کھرچنی": "کھرچنا",
  "کھرچتے": "کھرچنا",
  "کھرچتا": "کھرچنا",
  "کھرچتی": "کھرچنا",
  "کھرچتیں": "کھرچنا",
  "کھرچو": "کھرچنا",
  "کھرچوں": "کھرچنا",
  "کھرچوا": "کھرچنا",
  "کھرچوانے": "کھرچنا",
  "کھرچوانا": "کھرچنا",
  "کھرچواتے": "کھرچنا",
  "کھرچواتا": "کھرچنا",
  "کھرچواتی": "کھرچنا",
  "کھرچواتیں": "کھرچنا",
  "کھرچواؤ": "کھرچنا",
  "کھرچواؤں": "کھرچنا",
  "کھرچوائے": "کھرچنا",
  "کھرچوائی": "کھرچنا",
  "کھرچوائیے": "کھرچنا",
  "کھرچوائیں": "کھرچنا",
  "کھرچوایا": "کھرچنا",
  "کھرچی": "کھرچنا",
  "کھرچیے": "کھرچنا",
  "کھرچیں": "کھرچنا",
  "کھرو": "کھرا",
  "کھروں": "کھرا",
  "کھسک": "کھسکنا",
  "کھسکے": "کھسکنا",
  "کھسکں": "کھسکنا",
  "کھسکا": "کھسکنا",
  "کھسکانے": "کھسکنا",
  "کھسکانا": "کھسکنا",
  "کھسکاتے": "کھسکنا",
  "کھسکاتا": "کھسکنا",
  "کھسکاتی": "کھسکنا",
  "کھسکاتیں": "کھسکنا",
  "کھسکاؤ": "کھسکنا",
  "کھسکاؤں": "کھسکنا",
  "کھسکائے": "کھسکنا",
  "کھسکائی": "کھسکنا",
  "کھسکائیے": "کھسکنا",
  "کھسکائیں": "کھسکنا",
  "کھسکایا": "کھسکنا",
  "کھسکنے": "کھسکنا",
  "کھسکنا": "کھسکنا",
  "کھسکنی": "کھسکنا",
  "کھسکتے": "کھسکنا",
  "کھسکتا": "کھسکنا",
  "کھسکتی": "کھسکنا",
  "کھسکتیں": "کھسکنا",
  "کھسکو": "کھسکنا",
  "کھسکوں": "کھسکنا",
  "کھسکوا": "کھسکنا",
  "کھسکوانے": "کھسکنا",
  "کھسکوانا": "کھسکنا",
  "کھسکواتے": "کھسکنا",
  "کھسکواتا": "کھسکنا",
  "کھسکواتی": "کھسکنا",
  "کھسکواتیں": "کھسکنا",
  "کھسکواؤ": "کھسکنا",
  "کھسکواؤں": "کھسکنا",
  "کھسکوائے": "کھسکنا",
  "کھسکوائی": "کھسکنا",
  "کھسکوائیے": "کھسکنا",
  "کھسکوائیں": "کھسکنا",
  "کھسکوایا": "کھسکنا",
  "کھسکی": "کھسکنا",
  "کھسکیے": "کھسکنا",
  "کھسکیں": "کھسکنا",
  "کھسیا": "کھسیانا",
  "کھسیانے": "کھسیانہ",
  "کھسیانا": "کھسیانا",
  "کھسیانہ": "کھسیانہ",
  "کھسیانو": "کھسیانہ",
  "کھسیانوں": "کھسیانہ",
  "کھسیانی": "کھسیانا",
  "کھسیاتے": "کھسیانا",
  "کھسیاتا": "کھسیانا",
  "کھسیاتی": "کھسیانا",
  "کھسیاتیں": "کھسیانا",
  "کھسیاؤ": "کھسیانا",
  "کھسیاؤں": "کھسیانا",
  "کھسیائے": "کھسیانا",
  "کھسیائی": "کھسیانا",
  "کھسیائیے": "کھسیانا",
  "کھسیائیں": "کھسیانا",
  "کھسیایا": "کھسیانا",
  "کھو": "کھونا",
  "کھوٹے": "کھوٹا",
  "کھوٹا": "کھوٹا",
  "کھوٹو": "کھوٹا",
  "کھوٹوں": "کھوٹا",
  "کھود": "کھودنا",
  "کھودے": "کھودنا",
  "کھودں": "کھودنا",
  "کھودا": "کھودنا",
  "کھودنے": "کھودنا",
  "کھودنا": "کھودنا",
  "کھودنی": "کھودنا",
  "کھودتے": "کھودنا",
  "کھودتا": "کھودنا",
  "کھودتی": "کھودنا",
  "کھودتیں": "کھودنا",
  "کھودو": "کھودنا",
  "کھودوں": "کھودنا",
  "کھودی": "کھودنا",
  "کھودیے": "کھودنا",
  "کھودیں": "کھودنا",
  "کھوجی": "کھوجی",
  "کھوجیو": "کھوجی",
  "کھوجیوں": "کھوجی",
  "کھول": "کھُلْنا",
  "کھولْں": "کھُلْنا",
  "کھولْنے": "کھُلْنا",
  "کھولْنا": "کھُلْنا",
  "کھولْتے": "کھُلْنا",
  "کھولْتا": "کھُلْنا",
  "کھولْتی": "کھُلْنا",
  "کھولْتیں": "کھُلْنا",
  "کھولے": "کھُلْنا",
  "کھولں": "کھُلنا",
  "کھولا": "کھُلْنا",
  "کھولانے": "کھولنا",
  "کھولانا": "کھولنا",
  "کھولاتے": "کھولنا",
  "کھولاتا": "کھولنا",
  "کھولاتی": "کھولنا",
  "کھولاتیں": "کھولنا",
  "کھولاؤ": "کھولنا",
  "کھولاؤں": "کھولنا",
  "کھولائے": "کھولنا",
  "کھولائی": "کھولنا",
  "کھولائیے": "کھولنا",
  "کھولائیں": "کھولنا",
  "کھولایا": "کھولنا",
  "کھولنے": "کھُلنا",
  "کھولنا": "کھُلنا",
  "کھولنی": "کھولنا",
  "کھولتے": "کھُلنا",
  "کھولتا": "کھُلنا",
  "کھولتی": "کھُلنا",
  "کھولتیں": "کھُلنا",
  "کھولو": "کھُلْنا",
  "کھولوں": "کھُلْنا",
  "کھولوا": "کھولنا",
  "کھولوانے": "کھولنا",
  "کھولوانا": "کھولنا",
  "کھولواتے": "کھولنا",
  "کھولواتا": "کھولنا",
  "کھولواتی": "کھولنا",
  "کھولواتیں": "کھولنا",
  "کھولواؤ": "کھولنا",
  "کھولواؤں": "کھولنا",
  "کھولوائے": "کھولنا",
  "کھولوائی": "کھولنا",
  "کھولوائیے": "کھولنا",
  "کھولوائیں": "کھولنا",
  "کھولوایا": "کھولنا",
  "کھولی": "کھُلْنا",
  "کھولیے": "کھُلْنا",
  "کھولیں": "کھُلْنا",
  "کھونے": "کھونا",
  "کھونٹی": "کھونٹی",
  "کھونٹیا": "کھونٹیا",
  "کھونٹیاں": "کھونٹی",
  "کھونٹیو": "کھونٹی",
  "کھونٹیوں": "کھونٹی",
  "کھونا": "کھونا",
  "کھونی": "کھونا",
  "کھوپڑی": "کھوپڑی",
  "کھوپڑیاں": "کھوپڑی",
  "کھوپڑیو": "کھوپڑی",
  "کھوپڑیوں": "کھوپڑی",
  "کھوتے": "کھونا",
  "کھوتا": "کھونا",
  "کھوتی": "کھونا",
  "کھوتیں": "کھونا",
  "کھوؤ": "کھونا",
  "کھوؤں": "کھونا",
  "کھوئے": "کھونا",
  "کھوئی": "کھونا",
  "کھوئیے": "کھونا",
  "کھوئیں": "کھونا",
  "کھویا": "کھونا",
  "کھیل": "کھیل",
  "کھیلے": "کھیلنا",
  "کھیلں": "کھیلنا",
  "کھیلا": "کھیلنا",
  "کھیلنے": "کھیلنا",
  "کھیلنا": "کھیلنا",
  "کھیلنی": "کھیلنا",
  "کھیلتے": "کھیلنا",
  "کھیلتا": "کھیلنا",
  "کھیلتی": "کھیلنا",
  "کھیلتیں": "کھیلنا",
  "کھیلو": "کھیل",
  "کھیلوں": "کھیل",
  "کھیلی": "کھیلنا",
  "کھیلیے": "کھیلنا",
  "کھیلیں": "کھیلنا",
  "کھینچ": "کھینچنا",
  "کھینچے": "کھینچنا",
  "کھینچں": "کھینچنا",
  "کھینچا": "کھینچنا",
  "کھینچنے": "کھینچنا",
  "کھینچنا": "کھینچنا",
  "کھینچنی": "کھینچنا",
  "کھینچتے": "کھینچنا",
  "کھینچتا": "کھینچنا",
  "کھینچتی": "کھینچنا",
  "کھینچتیں": "کھینچنا",
  "کھینچو": "کھینچنا",
  "کھینچوں": "کھینچنا",
  "کھینچی": "کھینچنا",
  "کھینچیے": "کھینچنا",
  "کھینچیں": "کھینچنا",
  "کھیرے": "کھیرا",
  "کھیرا": "کھیرا",
  "کھیرو": "کھیرا",
  "کھیروں": "کھیرا",
  "کھیت": "کھیت",
  "کھیتو": "کھیت",
  "کھیتوں": "کھیت",
  "کھیتی": "کھیتی",
  "کھیتی`": "کھیتی`",
  "کھیتی`اں": "کھیتی`",
  "کھیتی`و": "کھیتی`",
  "کھیتی`وں": "کھیتی`",
  "کھیتیاں": "کھیتی",
  "کھیتیو": "کھیتی",
  "کھیتیوں": "کھیتی",
  "لَڑْکے": "لَڑْکا",
  "لَڑْکا": "لَڑْکا",
  "لَڑْکو": "لَڑْکا",
  "لَڑْکوں": "لَڑْکا",
  "لَڑْکی": "لَڑْکی",
  "لَڑْکیاں": "لَڑْکی",
  "لَڑْکیو": "لَڑْکی",
  "لَڑْکیوں": "لَڑْکی",
  "لَٹَک": "لَٹَکْنا",
  "لَٹَکْں": "لَٹَکْنا",
  "لَٹَکْنے": "لَٹَکْنا",
  "لَٹَکْنا": "لَٹَکْنا",
  "لَٹَکْنی": "لَٹَکْنا",
  "لَٹَکْتے": "لَٹَکْنا",
  "لَٹَکْتا": "لَٹَکْنا",
  "لَٹَکْتی": "لَٹَکْنا",
  "لَٹَکْتیں": "لَٹَکْنا",
  "لَٹَکْوا": "لَٹَکْنا",
  "لَٹَکْوانے": "لَٹَکْنا",
  "لَٹَکْوانا": "لَٹَکْنا",
  "لَٹَکْواتے": "لَٹَکْنا",
  "لَٹَکْواتا": "لَٹَکْنا",
  "لَٹَکْواتی": "لَٹَکْنا",
  "لَٹَکْواتیں": "لَٹَکْنا",
  "لَٹَکْواؤ": "لَٹَکْنا",
  "لَٹَکْواؤں": "لَٹَکْنا",
  "لَٹَکْوائے": "لَٹَکْنا",
  "لَٹَکْوائی": "لَٹَکْنا",
  "لَٹَکْوائیے": "لَٹَکْنا",
  "لَٹَکْوائیں": "لَٹَکْنا",
  "لَٹَکْوایا": "لَٹَکْنا",
  "لَٹَکے": "لَٹَکْنا",
  "لَٹَکا": "لَٹَکْنا",
  "لَٹَکانے": "لَٹَکْنا",
  "لَٹَکانا": "لَٹَکْنا",
  "لَٹَکاتے": "لَٹَکْنا",
  "لَٹَکاتا": "لَٹَکْنا",
  "لَٹَکاتی": "لَٹَکْنا",
  "لَٹَکاتیں": "لَٹَکْنا",
  "لَٹَکاؤ": "لَٹَکْنا",
  "لَٹَکاؤں": "لَٹَکْنا",
  "لَٹَکائے": "لَٹَکْنا",
  "لَٹَکائی": "لَٹَکْنا",
  "لَٹَکائیے": "لَٹَکْنا",
  "لَٹَکائیں": "لَٹَکْنا",
  "لَٹَکایا": "لَٹَکْنا",
  "لَٹَکو": "لَٹَکْنا",
  "لَٹَکوں": "لَٹَکْنا",
  "لَٹَکی": "لَٹَکْنا",
  "لَٹَکیے": "لَٹَکْنا",
  "لَٹَکیں": "لَٹَکْنا",
  "لِکْھ": "لِکْھنا",
  "لِکْھے": "لِکْھنا",
  "لِکْھں": "لِکْھنا",
  "لِکْھا": "لِکْھنا",
  "لِکْھانے": "لِکْھنا",
  "لِکْھانا": "لِکْھنا",
  "لِکْھاتے": "لِکْھنا",
  "لِکْھاتا": "لِکْھنا",
  "لِکْھاتی": "لِکْھنا",
  "لِکْھاتیں": "لِکْھنا",
  "لِکْھاؤ": "لِکْھنا",
  "لِکْھاؤں": "لِکْھنا",
  "لِکْھائے": "لِکْھنا",
  "لِکْھائی": "لِکْھنا",
  "لِکْھائیے": "لِکْھنا",
  "لِکْھائیں": "لِکْھنا",
  "لِکْھایا": "لِکْھنا",
  "لِکْھنے": "لِکْھنا",
  "لِکْھنا": "لِکْھنا",
  "لِکْھنی": "لِکْھنا",
  "لِکْھتے": "لِکْھنا",
  "لِکْھتا": "لِکْھنا",
  "لِکْھتی": "لِکْھنا",
  "لِکْھتیں": "لِکْھنا",
  "لِکْھو": "لِکْھنا",
  "لِکْھوں": "لِکْھنا",
  "لِکْھوا": "لِکْھنا",
  "لِکْھوانے": "لِکْھنا",
  "لِکْھوانا": "لِکْھنا",
  "لِکْھواتے": "لِکْھنا",
  "لِکْھواتا": "لِکْھنا",
  "لِکْھواتی": "لِکْھنا",
  "لِکْھواتیں": "لِکْھنا",
  "لِکْھواؤ": "لِکْھنا",
  "لِکْھواؤں": "لِکْھنا",
  "لِکْھوائے": "لِکْھنا",
  "لِکْھوائی": "لِکْھنا",
  "لِکْھوائیے": "لِکْھنا",
  "لِکْھوائیں": "لِکْھنا",
  "لِکْھوایا": "لِکْھنا",
  "لِکْھی": "لِکْھنا",
  "لِکْھیے": "لِکْھنا",
  "لِکْھیں": "لِکْھنا",
  "لُٹ": "لُٹنا",
  "لُٹے": "لُٹنا",
  "لُٹں": "لُٹنا",
  "لُٹا": "لُٹنا",
  "لُٹانے": "لُٹنا",
  "لُٹانا": "لُٹنا",
  "لُٹاتے": "لُٹنا",
  "لُٹاتا": "لُٹنا",
  "لُٹاتی": "لُٹنا",
  "لُٹاتیں": "لُٹنا",
  "لُٹاؤ": "لُٹنا",
  "لُٹاؤں": "لُٹنا",
  "لُٹائے": "لُٹنا",
  "لُٹائی": "لُٹنا",
  "لُٹائیے": "لُٹنا",
  "لُٹائیں": "لُٹنا",
  "لُٹایا": "لُٹنا",
  "لُٹنے": "لُٹنا",
  "لُٹنا": "لُٹنا",
  "لُٹنی": "لُٹنا",
  "لُٹتے": "لُٹنا",
  "لُٹتا": "لُٹنا",
  "لُٹتی": "لُٹنا",
  "لُٹتیں": "لُٹنا",
  "لُٹو": "لُٹنا",
  "لُٹوں": "لُٹنا",
  "لُٹوا": "لُٹنا",
  "لُٹوانے": "لُٹنا",
  "لُٹوانا": "لُٹنا",
  "لُٹواتے": "لُٹنا",
  "لُٹواتا": "لُٹنا",
  "لُٹواتی": "لُٹنا",
  "لُٹواتیں": "لُٹنا",
  "لُٹواؤ": "لُٹنا",
  "لُٹواؤں": "لُٹنا",
  "لُٹوائے": "لُٹنا",
  "لُٹوائی": "لُٹنا",
  "لُٹوائیے": "لُٹنا",
  "لُٹوائیں": "لُٹنا",
  "لُٹوایا": "لُٹنا",
  "لُٹی": "لُٹنا",
  "لُٹیے": "لُٹنا",
  "لُٹیں": "لُٹنا",
  "لڈو": "لڈو",
  "لڈوؤ": "لڈو",
  "لڈوؤں": "لڈو",
  "لے": "لینا",
  "لغزش": "لغزش",
  "لغزشو": "لغزش",
  "لغزشوں": "لغزش",
  "لغزشیں": "لغزش",
  "لحاف": "لحاف",
  "لحافو": "لحاف",
  "لحافوں": "لحاف",
  "لحافیں": "لحاف",
  "لحظے": "لحظہ",
  "لحظہ": "لحظہ",
  "لحظو": "لحظہ",
  "لحظوں": "لحظہ",
  "لڑ": "لڑنا",
  "لڑے": "لڑنا",
  "لڑں": "لڑنا",
  "لڑا": "لڑنا",
  "لڑانے": "لڑنا",
  "لڑانا": "لڑنا",
  "لڑاتے": "لڑنا",
  "لڑاتا": "لڑنا",
  "لڑاتی": "لڑنا",
  "لڑاتیں": "لڑنا",
  "لڑاؤ": "لڑنا",
  "لڑاؤں": "لڑنا",
  "لڑائے": "لڑنا",
  "لڑائی": "لڑائی",
  "لڑائیے": "لڑنا",
  "لڑائیں": "لڑنا",
  "لڑائیاں": "لڑائی",
  "لڑائیو": "لڑائی",
  "لڑائیوں": "لڑائی",
  "لڑایا": "لڑنا",
  "لڑکے": "لڑکا",
  "لڑکا": "لڑکا",
  "لڑکو": "لڑکا",
  "لڑکوں": "لڑکا",
  "لڑکی": "لڑکی",
  "لڑکیاں": "لڑکی",
  "لڑکیو": "لڑکی",
  "لڑکیوں": "لڑکی",
  "لڑکھڑا": "لڑکھڑانا",
  "لڑکھڑانے": "لڑکھڑانا",
  "لڑکھڑانا": "لڑکھڑانا",
  "لڑکھڑانی": "لڑکھڑانا",
  "لڑکھڑاتے": "لڑکھڑانا",
  "لڑکھڑاتا": "لڑکھڑانا",
  "لڑکھڑاتی": "لڑکھڑانا",
  "لڑکھڑاتیں": "لڑکھڑانا",
  "لڑکھڑاؤ": "لڑکھڑانا",
  "لڑکھڑاؤں": "لڑکھڑانا",
  "لڑکھڑائے": "لڑکھڑانا",
  "لڑکھڑائی": "لڑکھڑانا",
  "لڑکھڑائیے": "لڑکھڑانا",
  "لڑکھڑائیں": "لڑکھڑانا",
  "لڑکھڑایا": "لڑکھڑانا",
  "لڑنے": "لڑنا",
  "لڑنا": "لڑنا",
  "لڑنی": "لڑنا",
  "لڑتے": "لڑنا",
  "لڑتا": "لڑنا",
  "لڑتی": "لڑنا",
  "لڑتیں": "لڑنا",
  "لڑو": "لڑنا",
  "لڑوں": "لڑنا",
  "لڑوا": "لڑنا",
  "لڑوانے": "لڑنا",
  "لڑوانا": "لڑنا",
  "لڑواتے": "لڑنا",
  "لڑواتا": "لڑنا",
  "لڑواتی": "لڑنا",
  "لڑواتیں": "لڑنا",
  "لڑواؤ": "لڑنا",
  "لڑواؤں": "لڑنا",
  "لڑوائے": "لڑنا",
  "لڑوائی": "لڑنا",
  "لڑوائیے": "لڑنا",
  "لڑوائیں": "لڑنا",
  "لڑوایا": "لڑنا",
  "لڑی": "لڑی",
  "لڑیے": "لڑنا",
  "لڑیں": "لڑنا",
  "لڑیاں": "لڑی",
  "لڑیو": "لڑی",
  "لڑیوں": "لڑی",
  "لڑھک": "لڑھکنا",
  "لڑھکے": "لڑھکنا",
  "لڑھکں": "لڑھکنا",
  "لڑھکا": "لڑھکنا",
  "لڑھکانے": "لڑھکنا",
  "لڑھکانا": "لڑھکنا",
  "لڑھکاتے": "لڑھکنا",
  "لڑھکاتا": "لڑھکنا",
  "لڑھکاتی": "لڑھکنا",
  "لڑھکاتیں": "لڑھکنا",
  "لڑھکاؤ": "لڑھکنا",
  "لڑھکاؤں": "لڑھکنا",
  "لڑھکائے": "لڑھکنا",
  "لڑھکائی": "لڑھکنا",
  "لڑھکائیے": "لڑھکنا",
  "لڑھکائیں": "لڑھکنا",
  "لڑھکایا": "لڑھکنا",
  "لڑھکنے": "لڑھکنا",
  "لڑھکنا": "لڑھکنا",
  "لڑھکنی": "لڑھکنا",
  "لڑھکتے": "لڑھکنا",
  "لڑھکتا": "لڑھکنا",
  "لڑھکتی": "لڑھکنا",
  "لڑھکتیں": "لڑھکنا",
  "لڑھکو": "لڑھکنا",
  "لڑھکوں": "لڑھکنا",
  "لڑھکوا": "لڑھکنا",
  "لڑھکوانے": "لڑھکنا",
  "لڑھکوانا": "لڑھکنا",
  "لڑھکواتے": "لڑھکنا",
  "لڑھکواتا": "لڑھکنا",
  "لڑھکواتی": "لڑھکنا",
  "لڑھکواتیں": "لڑھکنا",
  "لڑھکواؤ": "لڑھکنا",
  "لڑھکواؤں": "لڑھکنا",
  "لڑھکوائے": "لڑھکنا",
  "لڑھکوائی": "لڑھکنا",
  "لڑھکوائیے": "لڑھکنا",
  "لڑھکوائیں": "لڑھکنا",
  "لڑھکوایا": "لڑھکنا",
  "لڑھکی": "لڑھکنا",
  "لڑھکیے": "لڑھکنا",
  "لڑھکیں": "لڑھکنا",
  "لٹ": "لٹ",
  "لٹے": "لٹنا",
  "لٹں": "لٹنا",
  "لٹا": "لٹنا",
  "لٹانے": "لٹنا",
  "لٹانا": "لٹنا",
  "لٹاتے": "لٹنا",
  "لٹاتا": "لٹنا",
  "لٹاتی": "لٹنا",
  "لٹاتیں": "لٹنا",
  "لٹاؤ": "لٹنا",
  "لٹاؤں": "لٹنا",
  "لٹائے": "لٹنا",
  "لٹائی": "لٹنا",
  "لٹائیے": "لٹنا",
  "لٹائیں": "لٹنا",
  "لٹایا": "لٹنا",
  "لٹک": "لٹکنا",
  "لٹکے": "لٹکنا",
  "لٹکں": "لٹکنا",
  "لٹکا": "لٹکنا",
  "لٹکانے": "لٹکنا",
  "لٹکانا": "لٹکنا",
  "لٹکاتے": "لٹکنا",
  "لٹکاتا": "لٹکنا",
  "لٹکاتی": "لٹکنا",
  "لٹکاتیں": "لٹکنا",
  "لٹکاؤ": "لٹکنا",
  "لٹکاؤں": "لٹکنا",
  "لٹکائے": "لٹکنا",
  "لٹکائی": "لٹکنا",
  "لٹکائیے": "لٹکنا",
  "لٹکائیں": "لٹکنا",
  "لٹکایا": "لٹکنا",
  "لٹکنے": "لٹکنا",
  "لٹکنا": "لٹکنا",
  "لٹکنی": "لٹکنا",
  "لٹکتے": "لٹکنا",
  "لٹکتا": "لٹکنا",
  "لٹکتی": "لٹکنا",
  "لٹکتیں": "لٹکنا",
  "لٹکو": "لٹکنا",
  "لٹکوں": "لٹکنا",
  "لٹکوا": "لٹکنا",
  "لٹکوانے": "لٹکنا",
  "لٹکوانا": "لٹکنا",
  "لٹکواتے": "لٹکنا",
  "لٹکواتا": "لٹکنا",
  "لٹکواتی": "لٹکنا",
  "لٹکواتیں": "لٹکنا",
  "لٹکواؤ": "لٹکنا",
  "لٹکواؤں": "لٹکنا",
  "لٹکوائے": "لٹکنا",
  "لٹکوائی": "لٹکنا",
  "لٹکوائیے": "لٹکنا",
  "لٹکوائیں": "لٹکنا",
  "لٹکوایا": "لٹکنا",
  "لٹکی": "لٹکنا",
  "لٹکیے": "لٹکنا",
  "لٹکیں": "لٹکنا",
  "لٹنے": "لٹنا",
  "لٹنا": "لٹنا",
  "لٹنی": "لٹنا",
  "لٹتے": "لٹنا",
  "لٹتا": "لٹنا",
  "لٹتی": "لٹنا",
  "لٹتیں": "لٹنا",
  "لٹو": "لٹ",
  "لٹوں": "لٹ",
  "لٹوا": "لٹنا",
  "لٹوانے": "لٹنا",
  "لٹوانا": "لٹنا",
  "لٹواتے": "لٹنا",
  "لٹواتا": "لٹنا",
  "لٹواتی": "لٹنا",
  "لٹواتیں": "لٹنا",
  "لٹواؤ": "لٹنا",
  "لٹواؤں": "لٹنا",
  "لٹوائے": "لٹنا",
  "لٹوائی": "لٹنا",
  "لٹوائیے": "لٹنا",
  "لٹوائیں": "لٹنا",
  "لٹوایا": "لٹنا",
  "لٹی": "لٹنا",
  "لٹیے": "لٹنا",
  "لٹیں": "لٹ",
  "لشکر": "لشکر",
  "لشکرو": "لشکر",
  "لشکروں": "لشکر",
  "لشکری": "لشکری",
  "لشکریو": "لشکری",
  "لشکریوں": "لشکری",
  "لذّت": "لذّت",
  "لذّتو": "لذّت",
  "لذّتوں": "لذّت",
  "لذّتیں": "لذّت",
  "لذت": "لذت",
  "لذتو": "لذت",
  "لذتوں": "لذت",
  "لذتیں": "لذت",
  "لذیذ": "لذیذ",
  "لذیذو": "لذیذ",
  "لذیذوں": "لذیذ",
  "لا": "لانا",
  "لاڈلی": "لاڈلی",
  "لاڈلیاں": "لاڈلی",
  "لاڈلیو": "لاڈلی",
  "لاڈلیوں": "لاڈلی",
  "لاٹھی": "لاٹھی",
  "لاٹھیاں": "لاٹھی",
  "لاٹھیو": "لاٹھی",
  "لاٹھیوں": "لاٹھی",
  "لاش": "لاش",
  "لاشے": "لاشہ",
  "لاشہ": "لاشہ",
  "لاشو": "لاشہ",
  "لاشوں": "لاشہ",
  "لاشیں": "لاش",
  "لال": "لال",
  "لالے": "لالا",
  "لالٹین": "لالٹین",
  "لالٹینو": "لالٹین",
  "لالٹینوں": "لالٹین",
  "لالٹینیں": "لالٹین",
  "لالا": "لالا",
  "لالہ": "لالہ",
  "لالو": "لالا",
  "لالوں": "لالا",
  "لانے": "لانا",
  "لانا": "لانا",
  "لانی": "لانا",
  "لاری": "لاری",
  "لاریاں": "لاری",
  "لاریو": "لاری",
  "لاریوں": "لاری",
  "لات": "لات",
  "لاتے": "لانا",
  "لاتا": "لانا",
  "لاتو": "لات",
  "لاتوں": "لات",
  "لاتی": "لانا",
  "لاتیں": "لات",
  "لاؤ": "لانا",
  "لاؤں": "لانا",
  "لائے": "لانا",
  "لائق": "لائق",
  "لائقو": "لائق",
  "لائقوں": "لائق",
  "لائی": "لانا",
  "لائیے": "لانا",
  "لائیں": "لانا",
  "لائین": "لائین",
  "لائینو": "لائین",
  "لائینوں": "لائین",
  "لائینیں": "لائین",
  "لایا": "لانا",
  "لازِمی": "لازِمی",
  "لب": "لب",
  "لبادے": "لبادہ",
  "لبادہ": "لبادہ",
  "لبادو": "لبادہ",
  "لبادوں": "لبادہ",
  "لباس": "لباس",
  "لباسو": "لباس",
  "لباسوں": "لباس",
  "لبو": "لب",
  "لبوں": "لب",
  "لفافے": "لفافہ",
  "لفافہ": "لفافہ",
  "لفافو": "لفافہ",
  "لفافوں": "لفافہ",
  "لفنگے": "لفنگا",
  "لفنگا": "لفنگا",
  "لفنگو": "لفنگا",
  "لفنگوں": "لفنگا",
  "لفظ": "لفظ",
  "لفظو": "لفظ",
  "لفظوں": "لفظ",
  "لگ": "لگنا",
  "لگے": "لگنا",
  "لگں": "لگنا",
  "لگا": "لگنا",
  "لگانے": "لگنا",
  "لگانا": "لگنا",
  "لگاتے": "لگنا",
  "لگاتا": "لگنا",
  "لگاتی": "لگنا",
  "لگاتیں": "لگنا",
  "لگاؤ": "لگنا",
  "لگاؤں": "لگنا",
  "لگائے": "لگنا",
  "لگائی": "لگنا",
  "لگائیے": "لگنا",
  "لگائیں": "لگنا",
  "لگایا": "لگنا",
  "لگنے": "لگنا",
  "لگنا": "لگنا",
  "لگنی": "لگنا",
  "لگتے": "لگنا",
  "لگتا": "لگنا",
  "لگتی": "لگنا",
  "لگتیں": "لگنا",
  "لگو": "لگنا",
  "لگوں": "لگنا",
  "لگوا": "لگنا",
  "لگوانے": "لگنا",
  "لگوانا": "لگنا",
  "لگواتے": "لگنا",
  "لگواتا": "لگنا",
  "لگواتی": "لگنا",
  "لگواتیں": "لگنا",
  "لگواؤ": "لگنا",
  "لگواؤں": "لگنا",
  "لگوائے": "لگنا",
  "لگوائی": "لگنا",
  "لگوائیے": "لگنا",
  "لگوائیں": "لگنا",
  "لگوایا": "لگنا",
  "لگی": "لگنا",
  "لگیے": "لگنا",
  "لگیں": "لگنا",
  "لہجے": "لہجہ",
  "لہجہ": "لہجہ",
  "لہجو": "لہجہ",
  "لہجوں": "لہجہ",
  "لہلہا": "لہلہانا",
  "لہلہانے": "لہلہانا",
  "لہلہانا": "لہلہانا",
  "لہلہانی": "لہلہانا",
  "لہلہاتے": "لہلہانا",
  "لہلہاتا": "لہلہانا",
  "لہلہاتی": "لہلہانا",
  "لہلہاتیں": "لہلہانا",
  "لہلہاؤ": "لہلہانا",
  "لہلہاؤں": "لہلہانا",
  "لہلہائے": "لہلہانا",
  "لہلہائی": "لہلہانا",
  "لہلہائیے": "لہلہانا",
  "لہلہائیں": "لہلہانا",
  "لہلہایا": "لہلہانا",
  "لہر": "لہر",
  "لہرا": "لہرانا",
  "لہرانے": "لہرانا",
  "لہرانا": "لہرانا",
  "لہرانی": "لہرانا",
  "لہراتے": "لہرانا",
  "لہراتا": "لہرانا",
  "لہراتی": "لہرانا",
  "لہراتیں": "لہرانا",
  "لہراؤ": "لہرانا",
  "لہراؤں": "لہرانا",
  "لہرائے": "لہرانا",
  "لہرائی": "لہرانا",
  "لہرائیے": "لہرانا",
  "لہرائیں": "لہرانا",
  "لہرایا": "لہرانا",
  "لہرو": "لہر",
  "لہروں": "لہر",
  "لہروا": "لہرانا",
  "لہروانے": "لہرانا",
  "لہروانا": "لہرانا",
  "لہرواتے": "لہرانا",
  "لہرواتا": "لہرانا",
  "لہرواتی": "لہرانا",
  "لہرواتیں": "لہرانا",
  "لہرواؤ": "لہرانا",
  "لہرواؤں": "لہرانا",
  "لہروائے": "لہرانا",
  "لہروائی": "لہرانا",
  "لہروائیے": "لہرانا",
  "لہروائیں": "لہرانا",
  "لہروایا": "لہرانا",
  "لہریں": "لہر",
  "لکڑی": "لکڑی",
  "لکڑیاں": "لکڑی",
  "لکڑیو": "لکڑی",
  "لکڑیوں": "لکڑی",
  "لکچر": "لکچر",
  "لکچرو": "لکچر",
  "لکچروں": "لکچر",
  "لکیر": "لکیر",
  "لکیرو": "لکیر",
  "لکیروں": "لکیر",
  "لکیریں": "لکیر",
  "لکھ": "لکھنا",
  "لکھے": "لکھنا",
  "لکھں": "لکھنا",
  "لکھا": "لکھنا",
  "لکھانے": "لکھنا",
  "لکھانا": "لکھنا",
  "لکھاری": "لکھاری",
  "لکھاریو": "لکھاری",
  "لکھاریوں": "لکھاری",
  "لکھاتے": "لکھنا",
  "لکھاتا": "لکھنا",
  "لکھاتی": "لکھنا",
  "لکھاتیں": "لکھنا",
  "لکھاؤ": "لکھنا",
  "لکھاؤں": "لکھنا",
  "لکھائے": "لکھنا",
  "لکھائی": "لکھنا",
  "لکھائیے": "لکھنا",
  "لکھائیں": "لکھنا",
  "لکھایا": "لکھنا",
  "لکھنے": "لکھنا",
  "لکھنا": "لکھنا",
  "لکھنو": "لکھنو",
  "لکھنؤ": "لکھنؤ",
  "لکھنوؤ": "لکھنو",
  "لکھنوؤں": "لکھنو",
  "لکھنی": "لکھنا",
  "لکھتے": "لکھنا",
  "لکھتا": "لکھنا",
  "لکھتی": "لکھنا",
  "لکھتیں": "لکھنا",
  "لکھو": "لکھنا",
  "لکھوں": "لکھنا",
  "لکھوا": "لکھنا",
  "لکھوانے": "لکھنا",
  "لکھوانا": "لکھنا",
  "لکھواتے": "لکھنا",
  "لکھواتا": "لکھنا",
  "لکھواتی": "لکھنا",
  "لکھواتیں": "لکھنا",
  "لکھواؤ": "لکھنا",
  "لکھواؤں": "لکھنا",
  "لکھوائے": "لکھنا",
  "لکھوائی": "لکھنا",
  "لکھوائیے": "لکھنا",
  "لکھوائیں": "لکھنا",
  "لکھوایا": "لکھنا",
  "لکھی": "لکھنا",
  "لکھیے": "لکھنا",
  "لکھیں": "لکھنا",
  "لمحے": "لمحہ",
  "لمحہ": "لمحہ",
  "لمحو": "لمحہ",
  "لمحوں": "لمحہ",
  "لنگڑ": "لنگڑنا",
  "لنگڑے": "لنگڑنا",
  "لنگڑں": "لنگڑنا",
  "لنگڑا": "لنگڑنا",
  "لنگڑانے": "لنگڑنا",
  "لنگڑانا": "لنگڑنا",
  "لنگڑاتے": "لنگڑنا",
  "لنگڑاتا": "لنگڑنا",
  "لنگڑاتی": "لنگڑنا",
  "لنگڑاتیں": "لنگڑنا",
  "لنگڑاؤ": "لنگڑنا",
  "لنگڑاؤں": "لنگڑنا",
  "لنگڑائے": "لنگڑنا",
  "لنگڑائی": "لنگڑنا",
  "لنگڑائیے": "لنگڑنا",
  "لنگڑائیں": "لنگڑنا",
  "لنگڑایا": "لنگڑنا",
  "لنگڑنے": "لنگڑنا",
  "لنگڑنا": "لنگڑنا",
  "لنگڑنی": "لنگڑنا",
  "لنگڑتے": "لنگڑنا",
  "لنگڑتا": "لنگڑنا",
  "لنگڑتی": "لنگڑنا",
  "لنگڑتیں": "لنگڑنا",
  "لنگڑو": "لنگڑنا",
  "لنگڑوں": "لنگڑنا",
  "لنگڑوا": "لنگڑنا",
  "لنگڑوانے": "لنگڑنا",
  "لنگڑوانا": "لنگڑنا",
  "لنگڑواتے": "لنگڑنا",
  "لنگڑواتا": "لنگڑنا",
  "لنگڑواتی": "لنگڑنا",
  "لنگڑواتیں": "لنگڑنا",
  "لنگڑواؤ": "لنگڑنا",
  "لنگڑواؤں": "لنگڑنا",
  "لنگڑوائے": "لنگڑنا",
  "لنگڑوائی": "لنگڑنا",
  "لنگڑوائیے": "لنگڑنا",
  "لنگڑوائیں": "لنگڑنا",
  "لنگڑوایا": "لنگڑنا",
  "لنگڑی": "لنگڑنا",
  "لنگڑیے": "لنگڑنا",
  "لنگڑیں": "لنگڑنا",
  "لنگی": "لنگی",
  "لنگیاں": "لنگی",
  "لنگیو": "لنگی",
  "لنگیوں": "لنگی",
  "لپٹ": "لپٹ",
  "لپٹے": "لپٹنا",
  "لپٹں": "لپٹنا",
  "لپٹا": "لپٹنا",
  "لپٹانے": "لپٹنا",
  "لپٹانا": "لپٹنا",
  "لپٹاتے": "لپٹنا",
  "لپٹاتا": "لپٹنا",
  "لپٹاتی": "لپٹنا",
  "لپٹاتیں": "لپٹنا",
  "لپٹاؤ": "لپٹنا",
  "لپٹاؤں": "لپٹنا",
  "لپٹائے": "لپٹنا",
  "لپٹائی": "لپٹنا",
  "لپٹائیے": "لپٹنا",
  "لپٹائیں": "لپٹنا",
  "لپٹایا": "لپٹنا",
  "لپٹنے": "لپٹنا",
  "لپٹنا": "لپٹنا",
  "لپٹنی": "لپٹنا",
  "لپٹتے": "لپٹنا",
  "لپٹتا": "لپٹنا",
  "لپٹتی": "لپٹنا",
  "لپٹتیں": "لپٹنا",
  "لپٹو": "لپٹ",
  "لپٹوں": "لپٹ",
  "لپٹوا": "لپٹنا",
  "لپٹوانے": "لپٹنا",
  "لپٹوانا": "لپٹنا",
  "لپٹواتے": "لپٹنا",
  "لپٹواتا": "لپٹنا",
  "لپٹواتی": "لپٹنا",
  "لپٹواتیں": "لپٹنا",
  "لپٹواؤ": "لپٹنا",
  "لپٹواؤں": "لپٹنا",
  "لپٹوائے": "لپٹنا",
  "لپٹوائی": "لپٹنا",
  "لپٹوائیے": "لپٹنا",
  "لپٹوائیں": "لپٹنا",
  "لپٹوایا": "لپٹنا",
  "لپٹی": "لپٹنا",
  "لپٹیے": "لپٹنا",
  "لپٹیں": "لپٹ",
  "لپک": "لپکنا",
  "لپکے": "لپکا",
  "لپکں": "لپکنا",
  "لپکا": "لپکا",
  "لپکانے": "لپکنا",
  "لپکانا": "لپکنا",
  "لپکاتے": "لپکنا",
  "لپکاتا": "لپکنا",
  "لپکاتی": "لپکنا",
  "لپکاتیں": "لپکنا",
  "لپکاؤ": "لپکنا",
  "لپکاؤں": "لپکنا",
  "لپکائے": "لپکنا",
  "لپکائی": "لپکنا",
  "لپکائیے": "لپکنا",
  "لپکائیں": "لپکنا",
  "لپکایا": "لپکنا",
  "لپکنے": "لپکنا",
  "لپکنا": "لپکنا",
  "لپکنی": "لپکنا",
  "لپکتے": "لپکنا",
  "لپکتا": "لپکنا",
  "لپکتی": "لپکنا",
  "لپکتیں": "لپکنا",
  "لپکو": "لپکا",
  "لپکوں": "لپکا",
  "لپکوا": "لپکنا",
  "لپکوانے": "لپکنا",
  "لپکوانا": "لپکنا",
  "لپکواتے": "لپکنا",
  "لپکواتا": "لپکنا",
  "لپکواتی": "لپکنا",
  "لپکواتیں": "لپکنا",
  "لپکواؤ": "لپکنا",
  "لپکواؤں": "لپکنا",
  "لپکوائے": "لپکنا",
  "لپکوائی": "لپکنا",
  "لپکوائیے": "لپکنا",
  "لپکوائیں": "لپکنا",
  "لپکوایا": "لپکنا",
  "لپکی": "لپکنا",
  "لپکیے": "لپکنا",
  "لپکیں": "لپکنا",
  "لپیٹ": "لپیٹنا",
  "لپیٹے": "لپیٹنا",
  "لپیٹں": "لپیٹنا",
  "لپیٹا": "لپیٹنا",
  "لپیٹنے": "لپیٹنا",
  "لپیٹنا": "لپیٹنا",
  "لپیٹنی": "لپیٹنا",
  "لپیٹتے": "لپیٹنا",
  "لپیٹتا": "لپیٹنا",
  "لپیٹتی": "لپیٹنا",
  "لپیٹتیں": "لپیٹنا",
  "لپیٹو": "لپیٹنا",
  "لپیٹوں": "لپیٹنا",
  "لپیٹی": "لپیٹنا",
  "لپیٹیے": "لپیٹنا",
  "لپیٹیں": "لپیٹنا",
  "لقمے": "لقمہ",
  "لقمہ": "لقمہ",
  "لقمو": "لقمہ",
  "لقموں": "لقمہ",
  "لرز": "لرزنا",
  "لرزے": "لرزہ",
  "لرزں": "لرزنا",
  "لرزا": "لرزنا",
  "لرزانے": "لرزنا",
  "لرزانا": "لرزنا",
  "لرزاتے": "لرزنا",
  "لرزاتا": "لرزنا",
  "لرزاتی": "لرزنا",
  "لرزاتیں": "لرزنا",
  "لرزاؤ": "لرزنا",
  "لرزاؤں": "لرزنا",
  "لرزائے": "لرزنا",
  "لرزائی": "لرزنا",
  "لرزائیے": "لرزنا",
  "لرزائیں": "لرزنا",
  "لرزایا": "لرزنا",
  "لرزہ": "لرزہ",
  "لرزنے": "لرزنا",
  "لرزنا": "لرزنا",
  "لرزنی": "لرزنا",
  "لرزتے": "لرزنا",
  "لرزتا": "لرزنا",
  "لرزتی": "لرزنا",
  "لرزتیں": "لرزنا",
  "لرزو": "لرزہ",
  "لرزوں": "لرزہ",
  "لرزوا": "لرزنا",
  "لرزوانے": "لرزنا",
  "لرزوانا": "لرزنا",
  "لرزواتے": "لرزنا",
  "لرزواتا": "لرزنا",
  "لرزواتی": "لرزنا",
  "لرزواتیں": "لرزنا",
  "لرزواؤ": "لرزنا",
  "لرزواؤں": "لرزنا",
  "لرزوائے": "لرزنا",
  "لرزوائی": "لرزنا",
  "لرزوائیے": "لرزنا",
  "لرزوائیں": "لرزنا",
  "لرزوایا": "لرزنا",
  "لرزی": "لرزنا",
  "لرزیے": "لرزنا",
  "لرزیں": "لرزنا",
  "لو": "لینا",
  "لوں": "لینا",
  "لوٹ": "لوٹنا",
  "لوٹے": "لوٹنا",
  "لوٹں": "لوٹنا",
  "لوٹا": "لوٹانا",
  "لوٹانے": "لوٹانا",
  "لوٹانا": "لوٹانا",
  "لوٹانی": "لوٹانا",
  "لوٹاتے": "لوٹانا",
  "لوٹاتا": "لوٹانا",
  "لوٹاتی": "لوٹانا",
  "لوٹاتیں": "لوٹانا",
  "لوٹاؤ": "لوٹانا",
  "لوٹاؤں": "لوٹانا",
  "لوٹائے": "لوٹانا",
  "لوٹائی": "لوٹانا",
  "لوٹائیے": "لوٹانا",
  "لوٹائیں": "لوٹانا",
  "لوٹایا": "لوٹانا",
  "لوٹنے": "لوٹنا",
  "لوٹنا": "لوٹنا",
  "لوٹنی": "لوٹنا",
  "لوٹتے": "لوٹنا",
  "لوٹتا": "لوٹنا",
  "لوٹتی": "لوٹنا",
  "لوٹتیں": "لوٹنا",
  "لوٹو": "لوٹنا",
  "لوٹوں": "لوٹنا",
  "لوٹوا": "لوٹانا",
  "لوٹوانے": "لوٹانا",
  "لوٹوانا": "لوٹانا",
  "لوٹواتے": "لوٹانا",
  "لوٹواتا": "لوٹانا",
  "لوٹواتی": "لوٹانا",
  "لوٹواتیں": "لوٹانا",
  "لوٹواؤ": "لوٹانا",
  "لوٹواؤں": "لوٹانا",
  "لوٹوائے": "لوٹانا",
  "لوٹوائی": "لوٹانا",
  "لوٹوائیے": "لوٹانا",
  "لوٹوائیں": "لوٹانا",
  "لوٹوایا": "لوٹانا",
  "لوٹی": "لوٹنا",
  "لوٹیے": "لوٹنا",
  "لوٹیں": "لوٹنا",
  "لوگ": "لوگ",
  "لوگو": "لوگ",
  "لوگوں": "لوگ",
  "لوہار": "لوہار",
  "لوہارو": "لوہار",
  "لوہاروں": "لوہار",
  "لولے": "لولا",
  "لولا": "لولا",
  "لولو": "لولا",
  "لولوں": "لولا",
  "لونڈے": "لونڈا",
  "لونڈا": "لونڈا",
  "لونڈو": "لونڈا",
  "لونڈوں": "لونڈا",
  "لونڈی": "لونڈی",
  "لونڈیا": "لونڈیا",
  "لونڈیاں": "لونڈی",
  "لونڈیو": "لونڈی",
  "لونڈیوں": "لونڈی",
  "لونگ": "لونگ",
  "لونگو": "لونگ",
  "لونگوں": "لونگ",
  "لوری": "لوری",
  "لوریاں": "لوری",
  "لوریو": "لوری",
  "لوریوں": "لوری",
  "لوئی": "لوئی",
  "لوئیو": "لوئی",
  "لوئیوں": "لوئی",
  "لی": "لینا",
  "لیڈر": "لیڈر",
  "لیڈرو": "لیڈر",
  "لیڈروں": "لیڈر",
  "لیے": "لینا",
  "لیں": "لینا",
  "لیٹ": "لیٹنا",
  "لیٹے": "لیٹنا",
  "لیٹں": "لیٹنا",
  "لیٹا": "لیٹنا",
  "لیٹانے": "لیٹنا",
  "لیٹانا": "لیٹنا",
  "لیٹاتے": "لیٹنا",
  "لیٹاتا": "لیٹنا",
  "لیٹاتی": "لیٹنا",
  "لیٹاتیں": "لیٹنا",
  "لیٹاؤ": "لیٹنا",
  "لیٹاؤں": "لیٹنا",
  "لیٹائے": "لیٹنا",
  "لیٹائی": "لیٹنا",
  "لیٹائیے": "لیٹنا",
  "لیٹائیں": "لیٹنا",
  "لیٹایا": "لیٹنا",
  "لیٹنے": "لیٹنا",
  "لیٹنا": "لیٹنا",
  "لیٹنی": "لیٹنا",
  "لیٹتے": "لیٹنا",
  "لیٹتا": "لیٹنا",
  "لیٹتی": "لیٹنا",
  "لیٹتیں": "لیٹنا",
  "لیٹو": "لیٹنا",
  "لیٹوں": "لیٹنا",
  "لیٹوا": "لیٹنا",
  "لیٹوانے": "لیٹنا",
  "لیٹوانا": "لیٹنا",
  "لیٹواتے": "لیٹنا",
  "لیٹواتا": "لیٹنا",
  "لیٹواتی": "لیٹنا",
  "لیٹواتیں": "لیٹنا",
  "لیٹواؤ": "لیٹنا",
  "لیٹواؤں": "لیٹنا",
  "لیٹوائے": "لیٹنا",
  "لیٹوائی": "لیٹنا",
  "لیٹوائیے": "لیٹنا",
  "لیٹوائیں": "لیٹنا",
  "لیٹوایا": "لیٹنا",
  "لیٹی": "لیٹنا",
  "لیٹیے": "لیٹنا",
  "لیٹیں": "لیٹنا",
  "لیا": "لینا",
  "لیبارٹری": "لیبارٹری",
  "لیبارٹریاں": "لیبارٹری",
  "لیبارٹریو": "لیبارٹری",
  "لیبارٹریوں": "لیبارٹری",
  "لیبل": "لیبل",
  "لیبلو": "لیبل",
  "لیبلوں": "لیبل",
  "لیکچر": "لیکچر",
  "لیکچرو": "لیکچر",
  "لیکچروں": "لیکچر",
  "لیکن": "لیکن",
  "لیلے": "لیلہ",
  "لیلہ": "لیلہ",
  "لیلو": "لیلہ",
  "لیلوں": "لیلہ",
  "لیمپ": "لیمپ",
  "لیمپو": "لیمپ",
  "لیمپوں": "لیمپ",
  "لینے": "لینا",
  "لینا": "لینا",
  "لینی": "لینا",
  "لیتے": "لینا",
  "لیتا": "لینا",
  "لیتی": "لینا",
  "لیتیں": "لینا",
  "لطافت": "لطافت",
  "لطافتو": "لطافت",
  "لطافتوں": "لطافت",
  "لطافتیں": "لطافت",
  "لطیف": "لطیف",
  "لطیفے": "لطیفہ",
  "لطیفہ": "لطیفہ",
  "لطیفو": "لطیفہ",
  "لطیفوں": "لطیفہ",
  "مَحَبَّت": "مَحَبَّت",
  "مَحَبَّتو": "مَحَبَّت",
  "مَحَبَّتوں": "مَحَبَّت",
  "مَحَبَّتیں": "مَحَبَّت",
  "مَہْنْگے": "مَہْنْگا",
  "مَہْنْگا": "مَہْنْگا",
  "مَہْنْگی": "مَہْنْگا",
  "مَر": "مَرْنا",
  "مَرْں": "مَرْنا",
  "مَرْد": "مَرْد",
  "مَرْدو": "مَرْد",
  "مَرْدوں": "مَرْد",
  "مَرْنے": "مَرْنا",
  "مَرْنا": "مَرْنا",
  "مَرْنی": "مَرْنا",
  "مَرْتے": "مَرْنا",
  "مَرْتا": "مَرْنا",
  "مَرْتی": "مَرْنا",
  "مَرْتیں": "مَرْنا",
  "مَرْوا": "مَرْنا",
  "مَرْوانے": "مَرْنا",
  "مَرْوانا": "مَرْنا",
  "مَرْواتے": "مَرْنا",
  "مَرْواتا": "مَرْنا",
  "مَرْواتی": "مَرْنا",
  "مَرْواتیں": "مَرْنا",
  "مَرْواؤ": "مَرْنا",
  "مَرْواؤں": "مَرْنا",
  "مَرْوائے": "مَرْنا",
  "مَرْوائی": "مَرْنا",
  "مَرْوائیے": "مَرْنا",
  "مَرْوائیں": "مَرْنا",
  "مَرْوایا": "مَرْنا",
  "مَرے": "مَرْنا",
  "مَرا": "مَرْنا",
  "مَرد": "مَرد",
  "مَردو": "مَرد",
  "مَردوں": "مَرد",
  "مَرو": "مَرْنا",
  "مَروں": "مَرْنا",
  "مَری": "مَرْنا",
  "مَریے": "مَرْنا",
  "مَریں": "مَرْنا",
  "میں": "میں",
  "مِٹ": "مِٹنا",
  "مِٹے": "مِٹنا",
  "مِٹں": "مِٹنا",
  "مِٹا": "مِٹنا",
  "مِٹانے": "مِٹنا",
  "مِٹانا": "مِٹنا",
  "مِٹاتے": "مِٹنا",
  "مِٹاتا": "مِٹنا",
  "مِٹاتی": "مِٹنا",
  "مِٹاتیں": "مِٹنا",
  "مِٹاؤ": "مِٹنا",
  "مِٹاؤں": "مِٹنا",
  "مِٹائے": "مِٹنا",
  "مِٹائی": "مِٹنا",
  "مِٹائیے": "مِٹنا",
  "مِٹائیں": "مِٹنا",
  "مِٹایا": "مِٹنا",
  "مِٹنے": "مِٹنا",
  "مِٹنا": "مِٹنا",
  "مِٹنی": "مِٹنا",
  "مِٹتے": "مِٹنا",
  "مِٹتا": "مِٹنا",
  "مِٹتی": "مِٹنا",
  "مِٹتیں": "مِٹنا",
  "مِٹو": "مِٹنا",
  "مِٹوں": "مِٹنا",
  "مِٹوا": "مِٹنا",
  "مِٹوانے": "مِٹنا",
  "مِٹوانا": "مِٹنا",
  "مِٹواتے": "مِٹنا",
  "مِٹواتا": "مِٹنا",
  "مِٹواتی": "مِٹنا",
  "مِٹواتیں": "مِٹنا",
  "مِٹواؤ": "مِٹنا",
  "مِٹواؤں": "مِٹنا",
  "مِٹوائے": "مِٹنا",
  "مِٹوائی": "مِٹنا",
  "مِٹوائیے": "مِٹنا",
  "مِٹوائیں": "مِٹنا",
  "مِٹوایا": "مِٹنا",
  "مِٹی": "مِٹنا",
  "مِٹیے": "مِٹنا",
  "مِٹیں": "مِٹنا",
  "مِل": "مِلنا",
  "مِلْں": "مِلْنا",
  "مِلْنے": "مِلْنا",
  "مِلْنا": "مِلْنا",
  "مِلْنی": "مِلْنا",
  "مِلْتے": "مِلْنا",
  "مِلْتا": "مِلْنا",
  "مِلْتی": "مِلْنا",
  "مِلْتیں": "مِلْنا",
  "مِلْوا": "مِلْنا",
  "مِلْوانے": "مِلْنا",
  "مِلْوانا": "مِلْنا",
  "مِلْواتے": "مِلْنا",
  "مِلْواتا": "مِلْنا",
  "مِلْواتی": "مِلْنا",
  "مِلْواتیں": "مِلْنا",
  "مِلْواؤ": "مِلْنا",
  "مِلْواؤں": "مِلْنا",
  "مِلْوائے": "مِلْنا",
  "مِلْوائی": "مِلْنا",
  "مِلْوائیے": "مِلْنا",
  "مِلْوائیں": "مِلْنا",
  "مِلْوایا": "مِلْنا",
  "مِلے": "مِلنا",
  "مِلں": "مِلنا",
  "مِلا": "مِلنا",
  "مِلانے": "مِلنا",
  "مِلانا": "مِلنا",
  "مِلاتے": "مِلنا",
  "مِلاتا": "مِلنا",
  "مِلاتی": "مِلنا",
  "مِلاتیں": "مِلنا",
  "مِلاؤ": "مِلنا",
  "مِلاؤں": "مِلنا",
  "مِلائے": "مِلنا",
  "مِلائی": "مِلنا",
  "مِلائیے": "مِلنا",
  "مِلائیں": "مِلنا",
  "مِلایا": "مِلنا",
  "مِلنے": "مِلنا",
  "مِلنا": "مِلنا",
  "مِلنی": "مِلنا",
  "مِلتے": "مِلنا",
  "مِلتا": "مِلنا",
  "مِلتی": "مِلنا",
  "مِلتیں": "مِلنا",
  "مِلو": "مِلنا",
  "مِلوں": "مِلنا",
  "مِلوا": "مِلنا",
  "مِلوانے": "مِلنا",
  "مِلوانا": "مِلنا",
  "مِلواتے": "مِلنا",
  "مِلواتا": "مِلنا",
  "مِلواتی": "مِلنا",
  "مِلواتیں": "مِلنا",
  "مِلواؤ": "مِلنا",
  "مِلواؤں": "مِلنا",
  "مِلوائے": "مِلنا",
  "مِلوائی": "مِلنا",
  "مِلوائیے": "مِلنا",
  "مِلوائیں": "مِلنا",
  "مِلوایا": "مِلنا",
  "مِلی": "مِلنا",
  "مِلیے": "مِلنا",
  "مِلیں": "مِلنا",
  "مُجْھ": "میں",
  "مُجرم": "مُجرم",
  "مُجرمو": "مُجرم",
  "مُجرموں": "مُجرم",
  "مُلک": "مُلک",
  "مُلکو": "مُلک",
  "مُلکوں": "مُلک",
  "مُنے": "مُنہ",
  "مُنہ": "مُنہ",
  "مُنو": "مُنہ",
  "مُنوں": "مُنہ",
  "مُرغی": "مُرغی",
  "مُرغیاں": "مُرغی",
  "مُرغیو": "مُرغی",
  "مُرغیوں": "مُرغی",
  "مُردے": "مُردہ",
  "مُردہ": "مُردہ",
  "مُردو": "مُردہ",
  "مُردوں": "مُردہ",
  "مُسلمان": "مُسلمان",
  "مُسلمانو": "مُسلمان",
  "مُسلمانوں": "مُسلمان",
  "مُونا": "مُونا",
  "مثال": "مثال",
  "مثالو": "مثال",
  "مثالوں": "مثال",
  "مثالیں": "مثال",
  "مثنوی": "مثنوی",
  "مثنویاں": "مثنوی",
  "مثنویو": "مثنوی",
  "مثنویوں": "مثنوی",
  "مغالطے": "مغالطہ",
  "مغالطہ": "مغالطہ",
  "مغالطو": "مغالطہ",
  "مغالطوں": "مغالطہ",
  "مغرب": "مغرب",
  "مغربو": "مغرب",
  "مغربوں": "مغرب",
  "محاذ": "محاذ",
  "محاذو": "محاذ",
  "محاذوں": "محاذ",
  "محالے": "محالہ",
  "محالہ": "محالہ",
  "محالو": "محالہ",
  "محالوں": "محالہ",
  "محاورے": "محاورا",
  "محاورا": "محاورا",
  "محاورہ": "محاورہ",
  "محاورو": "محاورا",
  "محاوروں": "محاورا",
  "محب": "محب",
  "محبت": "محبت",
  "محبتو": "محبت",
  "محبتوں": "محبت",
  "محبتیں": "محبت",
  "محبو": "محب",
  "محبوں": "محب",
  "محفل": "محفل",
  "محفلو": "محفل",
  "محفلوں": "محفل",
  "محفلیں": "محفل",
  "محکمے": "محکمہ",
  "محکمہ": "محکمہ",
  "محکمو": "محکمہ",
  "محکموں": "محکمہ",
  "محکوم": "محکوم",
  "محکومو": "محکوم",
  "محکوموں": "محکوم",
  "محل": "محل",
  "محلّے": "محلّہ",
  "محلّہ": "محلّہ",
  "محلّو": "محلّہ",
  "محلّوں": "محلّہ",
  "محلے": "محلہ",
  "محلہ": "محلہ",
  "محلو": "محلہ",
  "محلوں": "محلہ",
  "محمود": "محمود",
  "محمودو": "محمود",
  "محمودوں": "محمود",
  "محراب": "محراب",
  "محرابو": "محراب",
  "محرابوں": "محراب",
  "محرابیں": "محراب",
  "محرومی": "محرومی",
  "محرومیاں": "محرومی",
  "محرومیو": "محرومی",
  "محرومیوں": "محرومی",
  "محسن": "محسن",
  "محسنو": "محسن",
  "محسنوں": "محسن",
  "محتاج": "محتاج",
  "محتاجو": "محتاج",
  "محتاجوں": "محتاج",
  "مخالف": "مخالف",
  "مخالفو": "مخالف",
  "مخالفوں": "مخالف",
  "مڑ": "مڑنا",
  "مڑے": "مڑنا",
  "مڑں": "مڑنا",
  "مڑا": "مڑنا",
  "مڑانے": "مڑنا",
  "مڑانا": "مڑنا",
  "مڑاتے": "مڑنا",
  "مڑاتا": "مڑنا",
  "مڑاتی": "مڑنا",
  "مڑاتیں": "مڑنا",
  "مڑاؤ": "مڑنا",
  "مڑاؤں": "مڑنا",
  "مڑائے": "مڑنا",
  "مڑائی": "مڑنا",
  "مڑائیے": "مڑنا",
  "مڑائیں": "مڑنا",
  "مڑایا": "مڑنا",
  "مڑنے": "مڑنا",
  "مڑنا": "مڑنا",
  "مڑنی": "مڑنا",
  "مڑتے": "مڑنا",
  "مڑتا": "مڑنا",
  "مڑتی": "مڑنا",
  "مڑتیں": "مڑنا",
  "مڑو": "مڑنا",
  "مڑوں": "مڑنا",
  "مڑوا": "مڑنا",
  "مڑوانے": "مڑنا",
  "مڑوانا": "مڑنا",
  "مڑواتے": "مڑنا",
  "مڑواتا": "مڑنا",
  "مڑواتی": "مڑنا",
  "مڑواتیں": "مڑنا",
  "مڑواؤ": "مڑنا",
  "مڑواؤں": "مڑنا",
  "مڑوائے": "مڑنا",
  "مڑوائی": "مڑنا",
  "مڑوائیے": "مڑنا",
  "مڑوائیں": "مڑنا",
  "مڑوایا": "مڑنا",
  "مڑی": "مڑنا",
  "مڑیے": "مڑنا",
  "مڑیں": "مڑنا",
  "مصاحب": "مصاحب",
  "مصاحبے": "مصاحبہ",
  "مصاحبہ": "مصاحبہ",
  "مصاحبو": "مصاحبہ",
  "مصاحبوں": "مصاحبہ",
  "مصافحے": "مصافحہ",
  "مصافحہ": "مصافحہ",
  "مصافحو": "مصافحہ",
  "مصافحوں": "مصافحہ",
  "مصالحے": "مصالحہ",
  "مصالحہ": "مصالحہ",
  "مصالحو": "مصالحہ",
  "مصالحوں": "مصالحہ",
  "مصبت": "مصبت",
  "مصبتو": "مصبت",
  "مصبتوں": "مصبت",
  "مصبتیں": "مصبت",
  "مصلحت": "مصلحت",
  "مصلحتو": "مصلحت",
  "مصلحتوں": "مصلحت",
  "مصلحتیں": "مصلحت",
  "مصرع": "مصرع",
  "مصرعے": "مصرع",
  "مصرعہ": "مصرعہ",
  "مصرعو": "مصرع",
  "مصرعوں": "مصرع",
  "مصروفیت": "مصروفیت",
  "مصروفیتو": "مصروفیت",
  "مصروفیتوں": "مصروفیت",
  "مصروفیتیں": "مصروفیت",
  "مصور": "مصور",
  "مصورو": "مصور",
  "مصوروں": "مصور",
  "مصیبت": "مصیبت",
  "مصیبتو": "مصیبت",
  "مصیبتوں": "مصیبت",
  "مصیبتیں": "مصیبت",
  "مٹ": "مٹنا",
  "مٹے": "مٹنا",
  "مٹں": "مٹنا",
  "مٹا": "مٹنا",
  "مٹانے": "مٹنا",
  "مٹانا": "مٹنا",
  "مٹاتے": "مٹنا",
  "مٹاتا": "مٹنا",
  "مٹاتی": "مٹنا",
  "مٹاتیں": "مٹنا",
  "مٹاؤ": "مٹنا",
  "مٹاؤں": "مٹنا",
  "مٹائے": "مٹنا",
  "مٹائی": "مٹنا",
  "مٹائیے": "مٹنا",
  "مٹائیں": "مٹنا",
  "مٹایا": "مٹنا",
  "مٹک": "مٹکنا",
  "مٹکے": "مٹکنا",
  "مٹکں": "مٹکنا",
  "مٹکا": "مٹکنا",
  "مٹکانے": "مٹکنا",
  "مٹکانا": "مٹکنا",
  "مٹکاتے": "مٹکنا",
  "مٹکاتا": "مٹکنا",
  "مٹکاتی": "مٹکنا",
  "مٹکاتیں": "مٹکنا",
  "مٹکاؤ": "مٹکنا",
  "مٹکاؤں": "مٹکنا",
  "مٹکائے": "مٹکنا",
  "مٹکائی": "مٹکنا",
  "مٹکائیے": "مٹکنا",
  "مٹکائیں": "مٹکنا",
  "مٹکایا": "مٹکنا",
  "مٹکنے": "مٹکنا",
  "مٹکنا": "مٹکنا",
  "مٹکنی": "مٹکنا",
  "مٹکتے": "مٹکنا",
  "مٹکتا": "مٹکنا",
  "مٹکتی": "مٹکنا",
  "مٹکتیں": "مٹکنا",
  "مٹکو": "مٹکنا",
  "مٹکوں": "مٹکنا",
  "مٹکوا": "مٹکنا",
  "مٹکوانے": "مٹکنا",
  "مٹکوانا": "مٹکنا",
  "مٹکواتے": "مٹکنا",
  "مٹکواتا": "مٹکنا",
  "مٹکواتی": "مٹکنا",
  "مٹکواتیں": "مٹکنا",
  "مٹکواؤ": "مٹکنا",
  "مٹکواؤں": "مٹکنا",
  "مٹکوائے": "مٹکنا",
  "مٹکوائی": "مٹکنا",
  "مٹکوائیے": "مٹکنا",
  "مٹکوائیں": "مٹکنا",
  "مٹکوایا": "مٹکنا",
  "مٹکی": "مٹکی",
  "مٹکیے": "مٹکنا",
  "مٹکیں": "مٹکنا",
  "مٹکیاں": "مٹکی",
  "مٹکیو": "مٹکی",
  "مٹکیوں": "مٹکی",
  "مٹنے": "مٹنا",
  "مٹنا": "مٹنا",
  "مٹنی": "مٹنا",
  "مٹر": "مٹر",
  "مٹرو": "مٹر",
  "مٹروں": "مٹر",
  "مٹتے": "مٹنا",
  "مٹتا": "مٹنا",
  "مٹتی": "مٹنا",
  "مٹتیں": "مٹنا",
  "مٹو": "مٹنا",
  "مٹوں": "مٹنا",
  "مٹوا": "مٹنا",
  "مٹوانے": "مٹنا",
  "مٹوانا": "مٹنا",
  "مٹواتے": "مٹنا",
  "مٹواتا": "مٹنا",
  "مٹواتی": "مٹنا",
  "مٹواتیں": "مٹنا",
  "مٹواؤ": "مٹنا",
  "مٹواؤں": "مٹنا",
  "مٹوائے": "مٹنا",
  "مٹوائی": "مٹنا",
  "مٹوائیے": "مٹنا",
  "مٹوائیں": "مٹنا",
  "مٹوایا": "مٹنا",
  "مٹی": "مٹنا",
  "مٹیے": "مٹنا",
  "مٹیں": "مٹنا",
  "مٹھے": "مٹھا",
  "مٹھا": "مٹھا",
  "مٹھائی": "مٹھائی",
  "مٹھائیاں": "مٹھائی",
  "مٹھائیو": "مٹھائی",
  "مٹھائیوں": "مٹھائی",
  "مٹھو": "مٹھا",
  "مٹھوں": "مٹھا",
  "مٹھی": "مٹھی",
  "مٹھیاں": "مٹھی",
  "مٹھیو": "مٹھی",
  "مٹھیوں": "مٹھی",
  "مشغلے": "مشغلہ",
  "مشغلہ": "مشغلہ",
  "مشغلو": "مشغلہ",
  "مشغلوں": "مشغلہ",
  "مشابہت": "مشابہت",
  "مشابہتو": "مشابہت",
  "مشابہتوں": "مشابہت",
  "مشابہتیں": "مشابہت",
  "مشاعرے": "مشاعرہ",
  "مشاعرہ": "مشاعرہ",
  "مشاعرو": "مشاعرہ",
  "مشاعروں": "مشاعرہ",
  "مشاہدے": "مشاہدہ",
  "مشاہدہ": "مشاہدہ",
  "مشاہدو": "مشاہدہ",
  "مشاہدوں": "مشاہدہ",
  "مشاہرے": "مشاہرہ",
  "مشاہرہ": "مشاہرہ",
  "مشاہرو": "مشاہرہ",
  "مشاہروں": "مشاہرہ",
  "مشک": "مشک",
  "مشکل": "مشکل",
  "مشکلو": "مشکل",
  "مشکلوں": "مشکل",
  "مشکلیں": "مشکل",
  "مشکو": "مشک",
  "مشکوں": "مشک",
  "مشکیں": "مشک",
  "مشق": "مشق",
  "مشقت": "مشقت",
  "مشقتو": "مشقت",
  "مشقتوں": "مشقت",
  "مشقتیں": "مشقت",
  "مشقو": "مشق",
  "مشقوں": "مشق",
  "مشقیں": "مشق",
  "مشرک": "مشرک",
  "مشرکے": "مشرکہ",
  "مشرکہ": "مشرکہ",
  "مشرکو": "مشرکہ",
  "مشرکوں": "مشرکہ",
  "مشرق": "مشرق",
  "مشرقو": "مشرق",
  "مشرقوں": "مشرق",
  "مشور": "مشور",
  "مشورے": "مشورہ",
  "مشورہ": "مشورہ",
  "مشورو": "مشورہ",
  "مشوروں": "مشورہ",
  "مشین": "مشین",
  "مشینو": "مشین",
  "مشینوں": "مشین",
  "مشینیں": "مشین",
  "مشیر": "مشیر",
  "مشیرے": "مشیرہ",
  "مشیرہ": "مشیرہ",
  "مشیرو": "مشیرہ",
  "مشیروں": "مشیرہ",
  "مذہب": "مذہب",
  "مذہبو": "مذہب",
  "مذہبوں": "مذہب",
  "ماڈل": "ماڈل",
  "ماڈلو": "ماڈل",
  "ماڈلوں": "ماڈل",
  "ماڈلیں": "ماڈل",
  "ماخذ": "ماخذ",
  "ماخذو": "ماخذ",
  "ماخذوں": "ماخذ",
  "ماں": "ماں",
  "ماشے": "ماشہ",
  "ماشہ": "ماشہ",
  "ماشو": "ماشہ",
  "ماشوں": "ماشہ",
  "مادّے": "مادّہ",
  "مادّہ": "مادّہ",
  "مادّو": "مادّہ",
  "مادّوں": "مادّہ",
  "مادے": "مادہ",
  "مادہ": "مادہ",
  "مادو": "مادہ",
  "مادوں": "مادہ",
  "ماہنامے": "ماہنامہ",
  "ماہنامہ": "ماہنامہ",
  "ماہنامو": "ماہنامہ",
  "ماہناموں": "ماہنامہ",
  "مال": "مال",
  "مالَن": "مالَن",
  "مالَنو": "مالَن",
  "مالَنوں": "مالَن",
  "مالَنیں": "مالَن",
  "مالِن": "مالِن",
  "مالِنو": "مالِن",
  "مالِنوں": "مالِن",
  "مالِنیں": "مالِن",
  "مالا": "مالا",
  "مالاؤ": "مالا",
  "مالاؤں": "مالا",
  "مالائیں": "مالا",
  "مالدار": "مالدار",
  "مالدارو": "مالدار",
  "مالداروں": "مالدار",
  "مالک": "مالک",
  "مالکو": "مالک",
  "مالکوں": "مالک",
  "مالو": "مال",
  "مالوں": "مال",
  "ماما": "ماما",
  "ماماؤ": "ماما",
  "ماماؤں": "ماما",
  "مامائیں": "ماما",
  "مان": "ماننا",
  "مانے": "ماننا",
  "مانں": "ماننا",
  "مانا": "ماننا",
  "ماندے": "ماندہ",
  "ماندہ": "ماندہ",
  "ماندو": "ماندہ",
  "ماندوں": "ماندہ",
  "مانگ": "مانگ",
  "مانگے": "مانگنا",
  "مانگں": "مانگنا",
  "مانگا": "مانگنا",
  "مانگانے": "مانگنا",
  "مانگانا": "مانگنا",
  "مانگاتے": "مانگنا",
  "مانگاتا": "مانگنا",
  "مانگاتی": "مانگنا",
  "مانگاتیں": "مانگنا",
  "مانگاؤ": "مانگنا",
  "مانگاؤں": "مانگنا",
  "مانگائے": "مانگنا",
  "مانگائی": "مانگنا",
  "مانگائیے": "مانگنا",
  "مانگائیں": "مانگنا",
  "مانگایا": "مانگنا",
  "مانگنے": "مانگنا",
  "مانگنا": "مانگنا",
  "مانگنی": "مانگنا",
  "مانگتے": "مانگنا",
  "مانگتا": "مانگنا",
  "مانگتی": "مانگنا",
  "مانگتیں": "مانگنا",
  "مانگو": "مانگ",
  "مانگوں": "مانگ",
  "مانگوا": "مانگنا",
  "مانگوانے": "مانگنا",
  "مانگوانا": "مانگنا",
  "مانگواتے": "مانگنا",
  "مانگواتا": "مانگنا",
  "مانگواتی": "مانگنا",
  "مانگواتیں": "مانگنا",
  "مانگواؤ": "مانگنا",
  "مانگواؤں": "مانگنا",
  "مانگوائے": "مانگنا",
  "مانگوائی": "مانگنا",
  "مانگوائیے": "مانگنا",
  "مانگوائیں": "مانگنا",
  "مانگوایا": "مانگنا",
  "مانگی": "مانگنا",
  "مانگیے": "مانگنا",
  "مانگیں": "مانگ",
  "مانجھ": "مانجھنا",
  "مانجھے": "مانجھنا",
  "مانجھں": "مانجھنا",
  "مانجھا": "مانجھنا",
  "مانجھنے": "مانجھنا",
  "مانجھنا": "مانجھنا",
  "مانجھنی": "مانجھنا",
  "مانجھتے": "مانجھنا",
  "مانجھتا": "مانجھنا",
  "مانجھتی": "مانجھنا",
  "مانجھتیں": "مانجھنا",
  "مانجھو": "مانجھنا",
  "مانجھوں": "مانجھنا",
  "مانجھی": "مانجھنا",
  "مانجھیے": "مانجھنا",
  "مانجھیں": "مانجھنا",
  "ماننے": "ماننا",
  "ماننا": "ماننا",
  "ماننی": "ماننا",
  "مانتے": "ماننا",
  "مانتا": "ماننا",
  "مانتی": "ماننا",
  "مانتیں": "ماننا",
  "مانو": "ماننا",
  "مانوں": "ماننا",
  "مانی": "ماننا",
  "مانیے": "ماننا",
  "مانیں": "ماننا",
  "مار": "مار",
  "مارے": "مَرْنا",
  "مارں": "مَرْنا",
  "مارا": "مَرْنا",
  "مارکیٹ": "مارکیٹ",
  "مارکیٹو": "مارکیٹ",
  "مارکیٹوں": "مارکیٹ",
  "مارکیٹیں": "مارکیٹ",
  "مارنے": "مَرْنا",
  "مارنا": "مَرْنا",
  "مارتے": "مَرْنا",
  "مارتا": "مَرْنا",
  "مارتی": "مَرْنا",
  "مارتیں": "مَرْنا",
  "مارو": "مار",
  "ماروں": "مار",
  "ماری": "مَرْنا",
  "ماریے": "مَرْنا",
  "ماریں": "مار",
  "ماریا": "ماریا",
  "ماریہ": "ماریہ",
  "ماسٹر": "ماسٹر",
  "ماسٹرو": "ماسٹر",
  "ماسٹروں": "ماسٹر",
  "ماسک": "ماسک",
  "ماسکو": "ماسک",
  "ماسکوں": "ماسک",
  "ماسی": "ماسی",
  "ماسیاں": "ماسی",
  "ماسیو": "ماسی",
  "ماسیوں": "ماسی",
  "ماتمی": "ماتمی",
  "ماتمیو": "ماتمی",
  "ماتمیوں": "ماتمی",
  "ماؤ": "ماں",
  "ماؤں": "ماں",
  "مائی": "مائی",
  "مائیں": "ماں",
  "مائیاں": "مائی",
  "مائیو": "مائی",
  "مائیوں": "مائی",
  "مایوسی": "مایوسی",
  "مایوسیاں": "مایوسی",
  "مایوسیو": "مایوسی",
  "مایوسیوں": "مایوسی",
  "ماضی": "ماضی",
  "ماضیو": "ماضی",
  "ماضیوں": "ماضی",
  "مباحث": "مباحث",
  "مباحثے": "مباحثہ",
  "مباحثہ": "مباحثہ",
  "مباحثو": "مباحثہ",
  "مباحثوں": "مباحثہ",
  "مبالغے": "مبالغہ",
  "مبالغہ": "مبالغہ",
  "مبالغو": "مبالغہ",
  "مبالغوں": "مبالغہ",
  "مچ": "مچنا",
  "مچے": "مچنا",
  "مچں": "مچنا",
  "مچا": "مچانا",
  "مچانے": "مچانا",
  "مچانا": "مچانا",
  "مچانی": "مچانا",
  "مچاتے": "مچانا",
  "مچاتا": "مچانا",
  "مچاتی": "مچانا",
  "مچاتیں": "مچانا",
  "مچاؤ": "مچانا",
  "مچاؤں": "مچانا",
  "مچائے": "مچانا",
  "مچائی": "مچانا",
  "مچائیے": "مچانا",
  "مچائیں": "مچانا",
  "مچایا": "مچانا",
  "مچل": "مچلنا",
  "مچلے": "مچلنا",
  "مچلں": "مچلنا",
  "مچلا": "مچلنا",
  "مچلانے": "مچلنا",
  "مچلانا": "مچلنا",
  "مچلاتے": "مچلنا",
  "مچلاتا": "مچلنا",
  "مچلاتی": "مچلنا",
  "مچلاتیں": "مچلنا",
  "مچلاؤ": "مچلنا",
  "مچلاؤں": "مچلنا",
  "مچلائے": "مچلنا",
  "مچلائی": "مچلنا",
  "مچلائیے": "مچلنا",
  "مچلائیں": "مچلنا",
  "مچلایا": "مچلنا",
  "مچلنے": "مچلنا",
  "مچلنا": "مچلنا",
  "مچلنی": "مچلنا",
  "مچلتے": "مچلنا",
  "مچلتا": "مچلنا",
  "مچلتی": "مچلنا",
  "مچلتیں": "مچلنا",
  "مچلو": "مچلنا",
  "مچلوں": "مچلنا",
  "مچلوا": "مچلنا",
  "مچلوانے": "مچلنا",
  "مچلوانا": "مچلنا",
  "مچلواتے": "مچلنا",
  "مچلواتا": "مچلنا",
  "مچلواتی": "مچلنا",
  "مچلواتیں": "مچلنا",
  "مچلواؤ": "مچلنا",
  "مچلواؤں": "مچلنا",
  "مچلوائے": "مچلنا",
  "مچلوائی": "مچلنا",
  "مچلوائیے": "مچلنا",
  "مچلوائیں": "مچلنا",
  "مچلوایا": "مچلنا",
  "مچلی": "مچلنا",
  "مچلیے": "مچلنا",
  "مچلیں": "مچلنا",
  "مچنے": "مچنا",
  "مچنا": "مچنا",
  "مچنی": "مچنا",
  "مچتے": "مچنا",
  "مچتا": "مچنا",
  "مچتی": "مچنا",
  "مچتیں": "مچنا",
  "مچو": "مچنا",
  "مچوں": "مچنا",
  "مچوا": "مچنا",
  "مچوانے": "مچنا",
  "مچوانا": "مچنا",
  "مچواتے": "مچنا",
  "مچواتا": "مچنا",
  "مچواتی": "مچنا",
  "مچواتیں": "مچنا",
  "مچواؤ": "مچنا",
  "مچواؤں": "مچنا",
  "مچوائے": "مچنا",
  "مچوائی": "مچنا",
  "مچوائیے": "مچنا",
  "مچوائیں": "مچنا",
  "مچوایا": "مچنا",
  "مچولی": "مچولی",
  "مچولیاں": "مچولی",
  "مچولیو": "مچولی",
  "مچولیوں": "مچولی",
  "مچی": "مچنا",
  "مچیے": "مچنا",
  "مچیں": "مچنا",
  "مچھلی": "مچھلی",
  "مچھلیاں": "مچھلی",
  "مچھلیو": "مچھلی",
  "مچھلیوں": "مچھلی",
  "مچھر": "مچھر",
  "مچھرو": "مچھر",
  "مچھروں": "مچھر",
  "مدّت": "مدّت",
  "مدّتو": "مدّت",
  "مدّتوں": "مدّت",
  "مدّتیں": "مدّت",
  "مدار": "مدار",
  "مدارات": "مدار",
  "مدارو": "مدار",
  "مداروں": "مدار",
  "مددگار": "مددگار",
  "مددگارو": "مددگار",
  "مددگاروں": "مددگار",
  "مدرس": "مدرس",
  "مدرسے": "مدرسہ",
  "مدرسہ": "مدرسہ",
  "مدرسو": "مدرسہ",
  "مدرسوں": "مدرسہ",
  "مدت": "مدت",
  "مدتو": "مدت",
  "مدتوں": "مدت",
  "مدتیں": "مدت",
  "مدینے": "مدینہ",
  "مدینہ": "مدینہ",
  "مدینو": "مدینہ",
  "مدینوں": "مدینہ",
  "معصوم": "معصوم",
  "معصومو": "معصوم",
  "معصوموں": "معصوم",
  "معذور": "معذور",
  "معذورو": "معذور",
  "معذوروں": "معذور",
  "معاشقے": "معاشقہ",
  "معاشقہ": "معاشقہ",
  "معاشقو": "معاشقہ",
  "معاشقوں": "معاشقہ",
  "معاشرے": "معاشرہ",
  "معاشرہ": "معاشرہ",
  "معاشرو": "معاشرہ",
  "معاشروں": "معاشرہ",
  "معافی": "معافی",
  "معافیاں": "معافی",
  "معافیو": "معافی",
  "معافیوں": "معافی",
  "معاہدے": "معاہدہ",
  "معاہدہ": "معاہدہ",
  "معاہدو": "معاہدہ",
  "معاہدوں": "معاہدہ",
  "معالجے": "معالجہ",
  "معالجہ": "معالجہ",
  "معالجو": "معالجہ",
  "معالجوں": "معالجہ",
  "معاملے": "معاملہ",
  "معاملہ": "معاملہ",
  "معاملو": "معاملہ",
  "معاملوں": "معاملہ",
  "معاوضے": "معاوضہ",
  "معاوضہ": "معاوضہ",
  "معاوضو": "معاوضہ",
  "معاوضوں": "معاوضہ",
  "معائنے": "معائنہ",
  "معائنہ": "معائنہ",
  "معائنو": "معائنہ",
  "معائنوں": "معائنہ",
  "معبود": "معبود",
  "معبودو": "معبود",
  "معبودوں": "معبود",
  "معدے": "معدہ",
  "معدہ": "معدہ",
  "معدو": "معدہ",
  "معدوں": "معدہ",
  "معجزے": "معجزہ",
  "معجزہ": "معجزہ",
  "معجزو": "معجزہ",
  "معجزوں": "معجزہ",
  "معمے": "معما",
  "معما": "معما",
  "معمار": "معمار",
  "معمارو": "معمار",
  "معماروں": "معمار",
  "معمہ": "معمہ",
  "معمو": "معما",
  "معموں": "معما",
  "معرکے": "معرکہ",
  "معرکہ": "معرکہ",
  "معرکو": "معرکہ",
  "معرکوں": "معرکہ",
  "معتقد": "معتقد",
  "معتقدو": "معتقد",
  "معتقدوں": "معتقد",
  "معیار": "معیار",
  "معیارات": "معیار",
  "معیارو": "معیار",
  "معیاروں": "معیار",
  "مفتوح": "مفتوح",
  "مفتوحے": "مفتوحہ",
  "مفتوحہ": "مفتوحہ",
  "مفتوحو": "مفتوحہ",
  "مفتوحوں": "مفتوحہ",
  "مگر": "مگر",
  "مہاجن": "مہاجن",
  "مہاجنو": "مہاجن",
  "مہاجنوں": "مہاجن",
  "مہاجر": "مہاجر",
  "مہاجرو": "مہاجر",
  "مہاجروں": "مہاجر",
  "مہاراج": "مہاراج",
  "مہاراجے": "مہاراجہ",
  "مہاراجہ": "مہاراجہ",
  "مہاراجو": "مہاراجہ",
  "مہاراجوں": "مہاراجہ",
  "مہاران": "مہاران",
  "مہارانو": "مہاران",
  "مہارانوں": "مہاران",
  "مہارت": "مہارت",
  "مہارتو": "مہارت",
  "مہارتوں": "مہارت",
  "مہارتیں": "مہارت",
  "مہم": "مہم",
  "مہمان": "مہمان",
  "مہمانو": "مہمان",
  "مہمانوں": "مہمان",
  "مہمو": "مہم",
  "مہموں": "مہم",
  "مہمیں": "مہم",
  "مہنے": "مہنہ",
  "مہنہ": "مہنہ",
  "مہنو": "مہنہ",
  "مہنوں": "مہنہ",
  "مہر": "مہر",
  "مہربان": "مہربان",
  "مہربانو": "مہربان",
  "مہربانوں": "مہربان",
  "مہربانی": "مہربانی",
  "مہربانیاں": "مہربانی",
  "مہربانیو": "مہربانی",
  "مہربانیوں": "مہربانی",
  "مہرو": "مہر",
  "مہروں": "مہر",
  "مہریں": "مہر",
  "مہینے": "مہینا",
  "مہینا": "مہینا",
  "مہینہ": "مہینہ",
  "مہینو": "مہینا",
  "مہینوں": "مہینا",
  "مجاہد": "مجاہد",
  "مجاہدو": "مجاہد",
  "مجاہدوں": "مجاہد",
  "مجاور": "مجاور",
  "مجاورو": "مجاور",
  "مجاوروں": "مجاور",
  "مجبوری": "مجبوری",
  "مجبوریاں": "مجبوری",
  "مجبوریو": "مجبوری",
  "مجبوریوں": "مجبوری",
  "مجلس": "مجلس",
  "مجلسو": "مجلس",
  "مجلسوں": "مجلس",
  "مجلسیں": "مجلس",
  "مجمع": "مجمع",
  "مجمعے": "مجمع",
  "مجمعو": "مجمع",
  "مجمعوں": "مجمع",
  "مجموع": "مجموع",
  "مجموعے": "مجموع",
  "مجموعہ": "مجموعہ",
  "مجموعو": "مجموع",
  "مجموعوں": "مجموع",
  "مجرے": "مجرا",
  "مجرا": "مجرا",
  "مجرم": "مجرم",
  "مجرمو": "مجرم",
  "مجرموں": "مجرم",
  "مجرو": "مجرا",
  "مجروں": "مجرا",
  "مجسمے": "مجسمہ",
  "مجسمہ": "مجسمہ",
  "مجسمو": "مجسمہ",
  "مجسموں": "مجسمہ",
  "مجھ": "میں",
  "مک": "مکنا",
  "مکّے": "مکّہ",
  "مکّہ": "مکّہ",
  "مکّو": "مکّہ",
  "مکّوں": "مکّہ",
  "مکے": "مکہ",
  "مکں": "مکنا",
  "مکا": "مکنا",
  "مکالمے": "مکالمہ",
  "مکالمہ": "مکالمہ",
  "مکالمو": "مکالمہ",
  "مکالموں": "مکالمہ",
  "مکان": "مکان",
  "مکانے": "مکنا",
  "مکانا": "مکنا",
  "مکانات": "مکان",
  "مکانو": "مکان",
  "مکانوں": "مکان",
  "مکاری": "مکاری",
  "مکاریاں": "مکاری",
  "مکاریو": "مکاری",
  "مکاریوں": "مکاری",
  "مکاتے": "مکنا",
  "مکاتا": "مکنا",
  "مکاتی": "مکنا",
  "مکاتیں": "مکنا",
  "مکاؤ": "مکنا",
  "مکاؤں": "مکنا",
  "مکائے": "مکنا",
  "مکائی": "مکنا",
  "مکائیے": "مکنا",
  "مکائیں": "مکنا",
  "مکایا": "مکنا",
  "مکہ": "مکہ",
  "مکنے": "مکنا",
  "مکنا": "مکنا",
  "مکنی": "مکنا",
  "مکر": "مکر",
  "مکرو": "مکر",
  "مکروں": "مکر",
  "مکتے": "مکنا",
  "مکتا": "مکنا",
  "مکتب": "مکتب",
  "مکتبے": "مکتبہ",
  "مکتبہ": "مکتبہ",
  "مکتبو": "مکتبہ",
  "مکتبوں": "مکتبہ",
  "مکتی": "مکنا",
  "مکتیں": "مکنا",
  "مکو": "مکہ",
  "مکوں": "مکہ",
  "مکوا": "مکنا",
  "مکوانے": "مکنا",
  "مکوانا": "مکنا",
  "مکواتے": "مکنا",
  "مکواتا": "مکنا",
  "مکواتی": "مکنا",
  "مکواتیں": "مکنا",
  "مکواؤ": "مکنا",
  "مکواؤں": "مکنا",
  "مکوائے": "مکنا",
  "مکوائی": "مکنا",
  "مکوائیے": "مکنا",
  "مکوائیں": "مکنا",
  "مکوایا": "مکنا",
  "مکی": "مکنا",
  "مکیے": "مکنا",
  "مکیں": "مکنا",
  "مکین": "مکین",
  "مکینو": "مکین",
  "مکینوں": "مکین",
  "مکھی": "مکھی",
  "مکھیاں": "مکھی",
  "مکھیو": "مکھی",
  "مکھیوں": "مکھی",
  "مل": "مل",
  "ملّت": "ملّت",
  "ملّتو": "ملّت",
  "ملّتوں": "ملّت",
  "ملّتیں": "ملّت",
  "ملے": "ملنا",
  "ملں": "ملنا",
  "ملا": "ملنا",
  "ملامت": "ملامت",
  "ملامتو": "ملامت",
  "ملامتوں": "ملامت",
  "ملامتیں": "ملامت",
  "ملانے": "ملنا",
  "ملانا": "ملنا",
  "ملاقات": "ملاقات",
  "ملاقاتو": "ملاقات",
  "ملاقاتوں": "ملاقات",
  "ملاقاتی": "ملاقاتی",
  "ملاقاتیں": "ملاقات",
  "ملاقاتیو": "ملاقاتی",
  "ملاقاتیوں": "ملاقاتی",
  "ملاتے": "ملاتا",
  "ملاتا": "ملاتا",
  "ملاتو": "ملاتا",
  "ملاتوں": "ملاتا",
  "ملاتی": "ملنا",
  "ملاتیں": "ملنا",
  "ملاؤ": "ملنا",
  "ملاؤں": "ملنا",
  "ملائے": "ملنا",
  "ملائی": "ملنا",
  "ملائیے": "ملنا",
  "ملائیں": "ملنا",
  "ملایا": "ملنا",
  "ملازم": "ملازم",
  "ملازمے": "ملازمہ",
  "ملازمہ": "ملازمہ",
  "ملازمت": "ملازمت",
  "ملازمتو": "ملازمت",
  "ملازمتوں": "ملازمت",
  "ملازمتیں": "ملازمت",
  "ملازمو": "ملازمہ",
  "ملازموں": "ملازمہ",
  "ملبے": "ملبہ",
  "ملبہ": "ملبہ",
  "ملبو": "ملبہ",
  "ملبوں": "ملبہ",
  "ملک": "ملک",
  "ملکے": "ملکہ",
  "ملکہ": "ملکہ",
  "ملکو": "ملکہ",
  "ملکوں": "ملکہ",
  "ملکی": "ملکی",
  "ملکیو": "ملکی",
  "ملکیوں": "ملکی",
  "ملنے": "ملنا",
  "ملنا": "ملنا",
  "ملنی": "ملنا",
  "ملت": "ملت",
  "ملتے": "ملنا",
  "ملتا": "ملنا",
  "ملتو": "ملت",
  "ملتوں": "ملت",
  "ملتی": "ملنا",
  "ملتیں": "ملت",
  "ملو": "مل",
  "ملوں": "مل",
  "ملوا": "ملنا",
  "ملوانے": "ملنا",
  "ملوانا": "ملنا",
  "ملواتے": "ملنا",
  "ملواتا": "ملنا",
  "ملواتی": "ملنا",
  "ملواتیں": "ملنا",
  "ملواؤ": "ملنا",
  "ملواؤں": "ملنا",
  "ملوائے": "ملنا",
  "ملوائی": "ملنا",
  "ملوائیے": "ملنا",
  "ملوائیں": "ملنا",
  "ملوایا": "ملنا",
  "ملی": "ملنا",
  "ملیے": "ملنا",
  "ملیں": "ملنا",
  "ملیدے": "ملیدہ",
  "ملیدہ": "ملیدہ",
  "ملیدو": "ملیدہ",
  "ملیدوں": "ملیدہ",
  "ملزم": "ملزم",
  "ملزمو": "ملزم",
  "ملزموں": "ملزم",
  "مماثلت": "مماثلت",
  "مماثلتو": "مماثلت",
  "مماثلتوں": "مماثلت",
  "مماثلتیں": "مماثلت",
  "ممبر": "ممبر",
  "ممبرو": "ممبر",
  "ممبروں": "ممبر",
  "مملکت": "مملکت",
  "مملکتو": "مملکت",
  "مملکتوں": "مملکت",
  "مملکتیں": "مملکت",
  "ممتحن": "ممتحن",
  "ممتحنو": "ممتحن",
  "ممتحنوں": "ممتحن",
  "من": "مننا",
  "منّت": "منّت",
  "منّتو": "منّت",
  "منّتوں": "منّت",
  "منّتیں": "منّت",
  "منڈ": "منڈنا",
  "منڈے": "منڈا",
  "منڈں": "منڈنا",
  "منڈا": "منڈا",
  "منڈانے": "منڈنا",
  "منڈانا": "منڈنا",
  "منڈاتے": "منڈنا",
  "منڈاتا": "منڈنا",
  "منڈاتی": "منڈنا",
  "منڈاتیں": "منڈنا",
  "منڈاؤ": "منڈنا",
  "منڈاؤں": "منڈنا",
  "منڈائے": "منڈنا",
  "منڈائی": "منڈنا",
  "منڈائیے": "منڈنا",
  "منڈائیں": "منڈنا",
  "منڈایا": "منڈنا",
  "منڈلا": "منڈلانا",
  "منڈلانے": "منڈلانا",
  "منڈلانا": "منڈلانا",
  "منڈلانی": "منڈلانا",
  "منڈلاتے": "منڈلانا",
  "منڈلاتا": "منڈلانا",
  "منڈلاتی": "منڈلانا",
  "منڈلاتیں": "منڈلانا",
  "منڈلاؤ": "منڈلانا",
  "منڈلاؤں": "منڈلانا",
  "منڈلائے": "منڈلانا",
  "منڈلائی": "منڈلانا",
  "منڈلائیے": "منڈلانا",
  "منڈلائیں": "منڈلانا",
  "منڈلایا": "منڈلانا",
  "منڈنے": "منڈنا",
  "منڈنا": "منڈنا",
  "منڈنی": "منڈنا",
  "منڈتے": "منڈنا",
  "منڈتا": "منڈنا",
  "منڈتی": "منڈنا",
  "منڈتیں": "منڈنا",
  "منڈو": "منڈا",
  "منڈوں": "منڈا",
  "منڈوا": "منڈنا",
  "منڈوانے": "منڈنا",
  "منڈوانا": "منڈنا",
  "منڈواتے": "منڈنا",
  "منڈواتا": "منڈنا",
  "منڈواتی": "منڈنا",
  "منڈواتیں": "منڈنا",
  "منڈواؤ": "منڈنا",
  "منڈواؤں": "منڈنا",
  "منڈوائے": "منڈنا",
  "منڈوائی": "منڈنا",
  "منڈوائیے": "منڈنا",
  "منڈوائیں": "منڈنا",
  "منڈوایا": "منڈنا",
  "منڈی": "منڈی",
  "منڈیے": "منڈنا",
  "منڈیں": "منڈنا",
  "منڈیاں": "منڈی",
  "منڈیو": "منڈی",
  "منڈیوں": "منڈی",
  "منڈھا": "مونڈھنا",
  "منڈھانے": "مونڈھنا",
  "منڈھانا": "مونڈھنا",
  "منڈھاتے": "مونڈھنا",
  "منڈھاتا": "مونڈھنا",
  "منڈھاتی": "مونڈھنا",
  "منڈھاتیں": "مونڈھنا",
  "منڈھاؤ": "مونڈھنا",
  "منڈھاؤں": "مونڈھنا",
  "منڈھائے": "مونڈھنا",
  "منڈھائی": "مونڈھنا",
  "منڈھائیے": "مونڈھنا",
  "منڈھائیں": "مونڈھنا",
  "منڈھایا": "مونڈھنا",
  "منڈھوا": "مونڈھنا",
  "منڈھوانے": "مونڈھنا",
  "منڈھوانا": "مونڈھنا",
  "منڈھواتے": "مونڈھنا",
  "منڈھواتا": "مونڈھنا",
  "منڈھواتی": "مونڈھنا",
  "منڈھواتیں": "مونڈھنا",
  "منڈھواؤ": "مونڈھنا",
  "منڈھواؤں": "مونڈھنا",
  "منڈھوائے": "مونڈھنا",
  "منڈھوائی": "مونڈھنا",
  "منڈھوائیے": "مونڈھنا",
  "منڈھوائیں": "مونڈھنا",
  "منڈھوایا": "مونڈھنا",
  "منے": "منا",
  "منحوس": "منحوس",
  "منحوسو": "منحوس",
  "منحوسوں": "منحوس",
  "منں": "مننا",
  "منصف": "منصف",
  "منصفو": "منصف",
  "منصفوں": "منصف",
  "منصوبے": "منصوبہ",
  "منصوبہ": "منصوبہ",
  "منصوبو": "منصوبہ",
  "منصوبوں": "منصوبہ",
  "منٹ": "منٹ",
  "منٹو": "منٹ",
  "منٹوں": "منٹ",
  "منشی": "منشی",
  "منشیو": "منشی",
  "منشیوں": "منشی",
  "منا": "منا",
  "منافع": "منافع",
  "منافعے": "منافع",
  "منافعو": "منافع",
  "منافعوں": "منافع",
  "منافق": "منافق",
  "منافقت": "منافقت",
  "منافقتو": "منافقت",
  "منافقتوں": "منافقت",
  "منافقتیں": "منافقت",
  "منافقو": "منافق",
  "منافقوں": "منافق",
  "منانے": "ماننا",
  "منانا": "ماننا",
  "مناسبت": "مناسبت",
  "مناسبتو": "مناسبت",
  "مناسبتوں": "مناسبت",
  "مناسبتیں": "مناسبت",
  "مناتے": "ماننا",
  "مناتا": "ماننا",
  "مناتی": "ماننا",
  "مناتیں": "ماننا",
  "مناؤ": "ماننا",
  "مناؤں": "ماننا",
  "منائے": "ماننا",
  "منائی": "ماننا",
  "منائیے": "ماننا",
  "منائیں": "ماننا",
  "منایا": "ماننا",
  "مناظرے": "مناظرہ",
  "مناظرہ": "مناظرہ",
  "مناظرو": "مناظرہ",
  "مناظروں": "مناظرہ",
  "منبع": "منبع",
  "منبعے": "منبع",
  "منبعو": "منبع",
  "منبعوں": "منبع",
  "منبر": "منبر",
  "منبرو": "منبر",
  "منبروں": "منبر",
  "مندے": "مندا",
  "مندا": "مندا",
  "مندر": "مندر",
  "مندرو": "مندر",
  "مندروں": "مندر",
  "مندو": "مندا",
  "مندوں": "مندا",
  "منفعت": "منفعت",
  "منفعتو": "منفعت",
  "منفعتوں": "منفعت",
  "منفعتیں": "منفعت",
  "منگا": "مانگنا",
  "منگانے": "مانگنا",
  "منگانا": "مانگنا",
  "منگاتے": "مانگنا",
  "منگاتا": "مانگنا",
  "منگاتی": "مانگنا",
  "منگاتیں": "مانگنا",
  "منگاؤ": "مانگنا",
  "منگاؤں": "مانگنا",
  "منگائے": "مانگنا",
  "منگائی": "مانگنا",
  "منگائیے": "مانگنا",
  "منگائیں": "مانگنا",
  "منگایا": "مانگنا",
  "منگوا": "مانگنا",
  "منگوانے": "مانگنا",
  "منگوانا": "مانگنا",
  "منگواتے": "مانگنا",
  "منگواتا": "مانگنا",
  "منگواتی": "مانگنا",
  "منگواتیں": "مانگنا",
  "منگواؤ": "مانگنا",
  "منگواؤں": "مانگنا",
  "منگوائے": "مانگنا",
  "منگوائی": "مانگنا",
  "منگوائیے": "مانگنا",
  "منگوائیں": "مانگنا",
  "منگوایا": "مانگنا",
  "منج": "منج",
  "منجو": "منج",
  "منجوں": "منج",
  "منجھا": "مانجھنا",
  "منجھانے": "مانجھنا",
  "منجھانا": "مانجھنا",
  "منجھاتے": "مانجھنا",
  "منجھاتا": "مانجھنا",
  "منجھاتی": "مانجھنا",
  "منجھاتیں": "مانجھنا",
  "منجھاؤ": "مانجھنا",
  "منجھاؤں": "مانجھنا",
  "منجھائے": "مانجھنا",
  "منجھائی": "مانجھنا",
  "منجھائیے": "مانجھنا",
  "منجھائیں": "مانجھنا",
  "منجھایا": "مانجھنا",
  "منجھوا": "مانجھنا",
  "منجھوانے": "مانجھنا",
  "منجھوانا": "مانجھنا",
  "منجھواتے": "مانجھنا",
  "منجھواتا": "مانجھنا",
  "منجھواتی": "مانجھنا",
  "منجھواتیں": "مانجھنا",
  "منجھواؤ": "مانجھنا",
  "منجھواؤں": "مانجھنا",
  "منجھوائے": "مانجھنا",
  "منجھوائی": "مانجھنا",
  "منجھوائیے": "مانجھنا",
  "منجھوائیں": "مانجھنا",
  "منجھوایا": "مانجھنا",
  "منکر": "منکر",
  "منکرو": "منکر",
  "منکروں": "منکر",
  "منمنا": "منمنانا",
  "منمنانے": "منمنانا",
  "منمنانا": "منمنانا",
  "منمنانی": "منمنانا",
  "منمناتے": "منمنانا",
  "منمناتا": "منمنانا",
  "منمناتی": "منمنانا",
  "منمناتیں": "منمنانا",
  "منمناؤ": "منمنانا",
  "منمناؤں": "منمنانا",
  "منمنائے": "منمنانا",
  "منمنائی": "منمنانا",
  "منمنائیے": "منمنانا",
  "منمنائیں": "منمنانا",
  "منمنایا": "منمنانا",
  "مننے": "مننا",
  "مننا": "مننا",
  "مننی": "مننا",
  "منت": "منت",
  "منتے": "مننا",
  "منتا": "مننا",
  "منتر": "منتر",
  "منترو": "منتر",
  "منتروں": "منتر",
  "منتو": "منت",
  "منتوں": "منت",
  "منتی": "مننا",
  "منتیں": "منت",
  "منو": "منا",
  "منوں": "منا",
  "منوڑے": "منوڑہ",
  "منوڑہ": "منوڑہ",
  "منوڑو": "منوڑہ",
  "منوڑوں": "منوڑہ",
  "منوا": "ماننا",
  "منوانے": "ماننا",
  "منوانا": "ماننا",
  "منواتے": "ماننا",
  "منواتا": "ماننا",
  "منواتی": "ماننا",
  "منواتیں": "ماننا",
  "منواؤ": "ماننا",
  "منواؤں": "ماننا",
  "منوائے": "ماننا",
  "منوائی": "ماننا",
  "منوائیے": "ماننا",
  "منوائیں": "ماننا",
  "منوایا": "ماننا",
  "منی": "مننا",
  "منیے": "مننا",
  "منیں": "مننا",
  "منزل": "منزل",
  "منزلو": "منزل",
  "منزلوں": "منزل",
  "منزلیں": "منزل",
  "منطق": "منطق",
  "منطقے": "منطقہ",
  "منطقہ": "منطقہ",
  "منطقو": "منطقہ",
  "منطقوں": "منطقہ",
  "منطقیں": "منطق",
  "منظر": "منظر",
  "منظرو": "منظر",
  "منظروں": "منظر",
  "مقابل": "مقابل",
  "مقابلے": "مقابلہ",
  "مقابلہ": "مقابلہ",
  "مقابلو": "مقابلہ",
  "مقابلوں": "مقابلہ",
  "مقالے": "مقالہ",
  "مقالہ": "مقالہ",
  "مقالو": "مقالہ",
  "مقالوں": "مقالہ",
  "مقام": "مقام",
  "مقامے": "مقامہ",
  "مقامہ": "مقامہ",
  "مقامو": "مقامہ",
  "مقاموں": "مقامہ",
  "مقبرے": "مقبرہ",
  "مقبرہ": "مقبرہ",
  "مقبرو": "مقبرہ",
  "مقبروں": "مقبرہ",
  "مقدمے": "مقدمہ",
  "مقدمہ": "مقدمہ",
  "مقدمو": "مقدمہ",
  "مقدموں": "مقدمہ",
  "مقروض": "مقروض",
  "مقروضو": "مقروض",
  "مقروضوں": "مقروض",
  "مقتول": "مقتول",
  "مقتولو": "مقتول",
  "مقتولوں": "مقتول",
  "مقولے": "مقولہ",
  "مقولہ": "مقولہ",
  "مقولو": "مقولہ",
  "مقولوں": "مقولہ",
  "مقطع": "مقطع",
  "مقطعے": "مقطع",
  "مقطعو": "مقطع",
  "مقطعوں": "مقطع",
  "مر": "مرنا",
  "مرثیے": "مرثیہ",
  "مرثیہ": "مرثیہ",
  "مرثیو": "مرثیہ",
  "مرثیوں": "مرثیہ",
  "مرے": "مرہ",
  "مرغ": "مرغ",
  "مرغے": "مرغا",
  "مرغا": "مرغا",
  "مرغابی": "مرغابی",
  "مرغابیاں": "مرغابی",
  "مرغابیو": "مرغابی",
  "مرغابیوں": "مرغابی",
  "مرغو": "مرغا",
  "مرغوں": "مرغا",
  "مرغی": "مرغی",
  "مرغیاں": "مرغی",
  "مرغیو": "مرغی",
  "مرغیوں": "مرغی",
  "مرغزار": "مرغزار",
  "مرغزارو": "مرغزار",
  "مرغزاروں": "مرغزار",
  "مرحلے": "مرحلہ",
  "مرحلہ": "مرحلہ",
  "مرحلو": "مرحلہ",
  "مرحلوں": "مرحلہ",
  "مرں": "مرنا",
  "مرشد": "مرشد",
  "مرشدو": "مرشد",
  "مرشدوں": "مرشد",
  "مرا": "مرنا",
  "مراد": "مراد",
  "مرادو": "مراد",
  "مرادوں": "مراد",
  "مرادیں": "مراد",
  "مرانے": "مرنا",
  "مرانا": "مرنا",
  "مراقبے": "مراقبہ",
  "مراقبہ": "مراقبہ",
  "مراقبو": "مراقبہ",
  "مراقبوں": "مراقبہ",
  "مراتے": "مرنا",
  "مراتا": "مرنا",
  "مراتی": "مرنا",
  "مراتیں": "مرنا",
  "مراؤ": "مرنا",
  "مراؤں": "مرنا",
  "مرائے": "مرنا",
  "مرائی": "مرنا",
  "مرائیے": "مرنا",
  "مرائیں": "مرنا",
  "مرایا": "مرنا",
  "مربے": "مربہ",
  "مربع": "مربع",
  "مربعے": "مربع",
  "مربعو": "مربع",
  "مربعوں": "مربع",
  "مربہ": "مربہ",
  "مربو": "مربہ",
  "مربوں": "مربہ",
  "مرچ": "مرچ",
  "مرچو": "مرچ",
  "مرچوں": "مرچ",
  "مرچیں": "مرچ",
  "مرد": "مرد",
  "مردے": "مردا",
  "مردا": "مردا",
  "مردہ": "مردہ",
  "مردو": "مردا",
  "مردوں": "مردا",
  "مرہ": "مرہ",
  "مرجاں": "مرجاں",
  "مرجاؤ": "مرجاں",
  "مرجاؤں": "مرجاں",
  "مرجائیں": "مرجاں",
  "مرنے": "مرنا",
  "مرنا": "مرنا",
  "مرنی": "مرنا",
  "مرقع": "مرقع",
  "مرقعے": "مرقع",
  "مرقعو": "مرقع",
  "مرقعوں": "مرقع",
  "مرتے": "مرنا",
  "مرتا": "مرنا",
  "مرتبے": "مرتبہ",
  "مرتبان": "مرتبان",
  "مرتبانو": "مرتبان",
  "مرتبانوں": "مرتبان",
  "مرتبہ": "مرتبہ",
  "مرتبو": "مرتبہ",
  "مرتبوں": "مرتبہ",
  "مرتی": "مرنا",
  "مرتیں": "مرنا",
  "مرو": "مرہ",
  "مروں": "مرہ",
  "مروڑ": "مروڑنا",
  "مروڑے": "مروڑنا",
  "مروڑں": "مروڑنا",
  "مروڑا": "مروڑنا",
  "مروڑنے": "مروڑنا",
  "مروڑنا": "مروڑنا",
  "مروڑنی": "مروڑنا",
  "مروڑتے": "مروڑنا",
  "مروڑتا": "مروڑنا",
  "مروڑتی": "مروڑنا",
  "مروڑتیں": "مروڑنا",
  "مروڑو": "مروڑنا",
  "مروڑوں": "مروڑنا",
  "مروڑی": "مروڑنا",
  "مروڑیے": "مروڑنا",
  "مروڑیں": "مروڑنا",
  "مروا": "مرنا",
  "مروانے": "مرنا",
  "مروانا": "مرنا",
  "مرواتے": "مرنا",
  "مرواتا": "مرنا",
  "مرواتی": "مرنا",
  "مرواتیں": "مرنا",
  "مرواؤ": "مرنا",
  "مرواؤں": "مرنا",
  "مروائے": "مرنا",
  "مروائی": "مرنا",
  "مروائیے": "مرنا",
  "مروائیں": "مرنا",
  "مروایا": "مرنا",
  "مری": "مرنا",
  "مریے": "مرنا",
  "مریں": "مرنا",
  "مرید": "مرید",
  "مریدو": "مرید",
  "مریدوں": "مرید",
  "مریض": "مریض",
  "مریضے": "مریضہ",
  "مریضہ": "مریضہ",
  "مریضو": "مریضہ",
  "مریضوں": "مریضہ",
  "مرض": "مرض",
  "مرضو": "مرض",
  "مرضوں": "مرض",
  "مسخرے": "مسخرہ",
  "مسخرہ": "مسخرہ",
  "مسخرو": "مسخرہ",
  "مسخروں": "مسخرہ",
  "مسافر": "مسافر",
  "مسافرو": "مسافر",
  "مسافروں": "مسافر",
  "مسافت": "مسافت",
  "مسافتو": "مسافت",
  "مسافتوں": "مسافت",
  "مسافتیں": "مسافت",
  "مسالے": "مسالہ",
  "مسالہ": "مسالہ",
  "مسالو": "مسالہ",
  "مسالوں": "مسالہ",
  "مسام": "مسام",
  "مسامو": "مسام",
  "مساموں": "مسام",
  "مسجد": "مسجد",
  "مسجدو": "مسجد",
  "مسجدوں": "مسجد",
  "مسجدیں": "مسجد",
  "مسکرا": "مسکرانا",
  "مسکراہٹ": "مسکراہٹ",
  "مسکراہٹو": "مسکراہٹ",
  "مسکراہٹوں": "مسکراہٹ",
  "مسکراہٹیں": "مسکراہٹ",
  "مسکرانے": "مسکرانہ",
  "مسکرانا": "مسکرانا",
  "مسکرانہ": "مسکرانہ",
  "مسکرانو": "مسکرانہ",
  "مسکرانوں": "مسکرانہ",
  "مسکرانی": "مسکرانا",
  "مسکراتے": "مسکرانا",
  "مسکراتا": "مسکرانا",
  "مسکراتی": "مسکرانا",
  "مسکراتیں": "مسکرانا",
  "مسکراؤ": "مسکرانا",
  "مسکراؤں": "مسکرانا",
  "مسکرائے": "مسکرانا",
  "مسکرائی": "مسکرانا",
  "مسکرائیے": "مسکرانا",
  "مسکرائیں": "مسکرانا",
  "مسکرایا": "مسکرانا",
  "مسکین": "مسکین",
  "مسکینو": "مسکین",
  "مسکینوں": "مسکین",
  "مسکینیں": "مسکین",
  "مسل": "مسلنا",
  "مسلے": "مسلنا",
  "مسلں": "مسلنا",
  "مسلا": "مسلنا",
  "مسلانے": "مسلنا",
  "مسلانا": "مسلنا",
  "مسلاتے": "مسلنا",
  "مسلاتا": "مسلنا",
  "مسلاتی": "مسلنا",
  "مسلاتیں": "مسلنا",
  "مسلاؤ": "مسلنا",
  "مسلاؤں": "مسلنا",
  "مسلائے": "مسلنا",
  "مسلائی": "مسلنا",
  "مسلائیے": "مسلنا",
  "مسلائیں": "مسلنا",
  "مسلایا": "مسلنا",
  "مسلم": "مسلم",
  "مسلمان": "مسلمان",
  "مسلمانو": "مسلمان",
  "مسلمانوں": "مسلمان",
  "مسلمانی": "مسلمانی",
  "مسلمانیاں": "مسلمانی",
  "مسلمانیو": "مسلمانی",
  "مسلمانیوں": "مسلمانی",
  "مسلمو": "مسلم",
  "مسلموں": "مسلم",
  "مسلنے": "مسلنا",
  "مسلنا": "مسلنا",
  "مسلنی": "مسلنا",
  "مسلتے": "مسلنا",
  "مسلتا": "مسلنا",
  "مسلتی": "مسلنا",
  "مسلتیں": "مسلنا",
  "مسلو": "مسلنا",
  "مسلوں": "مسلنا",
  "مسلوا": "مسلنا",
  "مسلوانے": "مسلنا",
  "مسلوانا": "مسلنا",
  "مسلواتے": "مسلنا",
  "مسلواتا": "مسلنا",
  "مسلواتی": "مسلنا",
  "مسلواتیں": "مسلنا",
  "مسلواؤ": "مسلنا",
  "مسلواؤں": "مسلنا",
  "مسلوائے": "مسلنا",
  "مسلوائی": "مسلنا",
  "مسلوائیے": "مسلنا",
  "مسلوائیں": "مسلنا",
  "مسلوایا": "مسلنا",
  "مسلی": "مسلنا",
  "مسلیے": "مسلنا",
  "مسلیں": "مسلنا",
  "مسرت": "مسرت",
  "مسرتو": "مسرت",
  "مسرتوں": "مسرت",
  "مسرتیں": "مسرت",
  "مستری": "مستری",
  "مستریو": "مستری",
  "مستریوں": "مستری",
  "مستی": "مستی",
  "مستیاں": "مستی",
  "مستیو": "مستی",
  "مستیوں": "مستی",
  "مسواک": "مسواک",
  "مسواکو": "مسواک",
  "مسواکوں": "مسواک",
  "مسواکیں": "مسواک",
  "مسودے": "مسودہ",
  "مسودہ": "مسودہ",
  "مسودو": "مسودہ",
  "مسودوں": "مسودہ",
  "مسئلے": "مسئلہ",
  "مسئلہ": "مسئلہ",
  "مسئلو": "مسئلہ",
  "مسئلوں": "مسئلہ",
  "مت": "مت",
  "متکبّر": "متکبّر",
  "متکبّرو": "متکبّر",
  "متکبّروں": "متکبّر",
  "متکبر": "متکبر",
  "متکبرّ": "متکبرّ",
  "متکبرّو": "متکبرّ",
  "متکبرّوں": "متکبرّ",
  "متکبرو": "متکبر",
  "متکبروں": "متکبر",
  "متلاشی": "متلاشی",
  "متلاشیو": "متلاشی",
  "متلاشیوں": "متلاشی",
  "متقی": "متقی",
  "متقیو": "متقی",
  "متقیوں": "متقی",
  "موڑ": "موڑ",
  "موڑے": "موڑا",
  "موڑا": "موڑا",
  "موڑو": "موڑا",
  "موڑوں": "موڑا",
  "موٹے": "موٹا",
  "موٹا": "موٹا",
  "موٹر": "موٹر",
  "موٹرو": "موٹر",
  "موٹروں": "موٹر",
  "موٹریں": "موٹر",
  "موٹو": "موٹا",
  "موٹوں": "موٹا",
  "موشگافی": "موشگافی",
  "موشگافیاں": "موشگافی",
  "موشگافیو": "موشگافی",
  "موشگافیوں": "موشگافی",
  "مؤذن": "مؤذن",
  "مؤذنو": "مؤذن",
  "مؤذنوں": "مؤذن",
  "مؤمن": "مؤمن",
  "مؤمنو": "مؤمن",
  "مؤمنوں": "مؤمن",
  "مواقع": "مواقع",
  "مواقعے": "مواقع",
  "مواقعو": "مواقع",
  "مواقعوں": "مواقع",
  "موازنے": "موازنہ",
  "موازنہ": "موازنہ",
  "موازنو": "موازنہ",
  "موازنوں": "موازنہ",
  "موج": "موج",
  "موجو": "موج",
  "موجوں": "موج",
  "موجودے": "موجودہ",
  "موجودہ": "موجودہ",
  "موجودو": "موجودہ",
  "موجودوں": "موجودہ",
  "موجیں": "موج",
  "مولی": "مولی",
  "مولیاں": "مولی",
  "مولیو": "مولی",
  "مولیوں": "مولی",
  "مومن": "مومن",
  "مومنو": "مومن",
  "مومنوں": "مومن",
  "مونڈھ": "مونڈھنا",
  "مونڈھے": "مونڈھنا",
  "مونڈھں": "مونڈھنا",
  "مونڈھا": "مونڈھنا",
  "مونڈھنے": "مونڈھنا",
  "مونڈھنا": "مونڈھنا",
  "مونڈھنی": "مونڈھنا",
  "مونڈھتے": "مونڈھنا",
  "مونڈھتا": "مونڈھنا",
  "مونڈھتی": "مونڈھنا",
  "مونڈھتیں": "مونڈھنا",
  "مونڈھو": "مونڈھنا",
  "مونڈھوں": "مونڈھنا",
  "مونڈھی": "مونڈھنا",
  "مونڈھیے": "مونڈھنا",
  "مونڈھیں": "مونڈھنا",
  "مونچھ": "مونچھ",
  "مونچھو": "مونچھ",
  "مونچھوں": "مونچھ",
  "مونچھیں": "مونچھ",
  "موند": "موندنا",
  "موندے": "موندنا",
  "موندں": "موندنا",
  "موندا": "موندنا",
  "موندنے": "موندنا",
  "موندنا": "موندنا",
  "موندنی": "موندنا",
  "موندتے": "موندنا",
  "موندتا": "موندنا",
  "موندتی": "موندنا",
  "موندتیں": "موندنا",
  "موندو": "موندنا",
  "موندوں": "موندنا",
  "موندی": "موندنا",
  "موندیے": "موندنا",
  "موندیں": "موندنا",
  "موقع": "موقع",
  "موقعے": "موقع",
  "موقعہ": "موقعہ",
  "موقعو": "موقع",
  "موقعوں": "موقع",
  "مورتی": "مورتی",
  "مورتیاں": "مورتی",
  "مورتیو": "مورتی",
  "مورتیوں": "مورتی",
  "موسم": "موسم",
  "موسمو": "موسم",
  "موسموں": "موسم",
  "موت": "موت",
  "موتو": "موت",
  "موتوں": "موت",
  "موتی": "موتی",
  "موتیں": "موت",
  "موتیو": "موتی",
  "موتیوں": "موتی",
  "مویشی": "مویشی",
  "مویشیو": "مویشی",
  "مویشیوں": "مویشی",
  "موزے": "موزہ",
  "موزہ": "موزہ",
  "موزو": "موزہ",
  "موزوں": "موزہ",
  "میخ": "میخ",
  "میخانے": "میخانہ",
  "میخانہ": "میخانہ",
  "میخانو": "میخانہ",
  "میخانوں": "میخانہ",
  "میخو": "میخ",
  "میخوں": "میخ",
  "میخیں": "میخ",
  "میٹ": "میٹنا",
  "میٹے": "میٹنا",
  "میٹں": "میٹنا",
  "میٹا": "میٹنا",
  "میٹنے": "میٹنا",
  "میٹنا": "میٹنا",
  "میٹنی": "میٹنا",
  "میٹر": "میٹر",
  "میٹرو": "میٹر",
  "میٹروں": "میٹر",
  "میٹتے": "میٹنا",
  "میٹتا": "میٹنا",
  "میٹتی": "میٹنا",
  "میٹتیں": "میٹنا",
  "میٹو": "میٹنا",
  "میٹوں": "میٹنا",
  "میٹی": "میٹنا",
  "میٹیے": "میٹنا",
  "میٹیں": "میٹنا",
  "میچ": "میچ",
  "میچو": "میچ",
  "میچوں": "میچ",
  "میدے": "میدہ",
  "میدان": "میدان",
  "میدانو": "میدان",
  "میدانوں": "میدان",
  "میدہ": "میدہ",
  "میدو": "میدہ",
  "میدوں": "میدہ",
  "میکے": "میکہ",
  "میکدے": "میکدہ",
  "میکدہ": "میکدہ",
  "میکدو": "میکدہ",
  "میکدوں": "میکدہ",
  "میکہ": "میکہ",
  "میکو": "میکہ",
  "میکوں": "میکہ",
  "میل": "میل",
  "میلے": "میلا",
  "میلا": "میلا",
  "میلان": "میلان",
  "میلانات": "میلان",
  "میلانو": "میلان",
  "میلانوں": "میلان",
  "میلہ": "میلہ",
  "میلو": "میلا",
  "میلوں": "میلا",
  "میلیں": "میل",
  "میم": "میم",
  "میمو": "میم",
  "میموں": "میم",
  "میمیں": "میم",
  "مینڈک": "مینڈک",
  "مینڈکو": "مینڈک",
  "مینڈکوں": "مینڈک",
  "مینڈکی": "مینڈکی",
  "مینڈکیاں": "مینڈکی",
  "مینڈکیو": "مینڈکی",
  "مینڈکیوں": "مینڈکی",
  "مینے": "مینہ",
  "مینا": "مینا",
  "مینار": "مینار",
  "مینارو": "مینار",
  "میناروں": "مینار",
  "میناؤ": "مینا",
  "میناؤں": "مینا",
  "مینائیں": "مینا",
  "مینہ": "مینہ",
  "مینو": "مینہ",
  "مینوں": "مینہ",
  "میقات": "میقات",
  "میقاتو": "میقات",
  "میقاتوں": "میقات",
  "میقاتیں": "میقات",
  "میرے": "میرا",
  "میرا": "میرا",
  "میراثی": "میراثی",
  "میراثیو": "میراثی",
  "میراثیوں": "میراثی",
  "میری": "میرا",
  "میت": "میت",
  "میتو": "میت",
  "میتوں": "میت",
  "میتیں": "میت",
  "میتھی": "میتھی",
  "میتھیاں": "میتھی",
  "میتھیو": "میتھی",
  "میتھیوں": "میتھی",
  "میوے": "میوہ",
  "میوہ": "میوہ",
  "میوو": "میوہ",
  "میووں": "میوہ",
  "میز": "میز",
  "میزائل": "میزائل",
  "میزائلو": "میزائل",
  "میزائلوں": "میزائل",
  "میزائیل": "میزائیل",
  "میزائیلو": "میزائیل",
  "میزائیلوں": "میزائیل",
  "میزبان": "میزبان",
  "میزبانو": "میزبان",
  "میزبانوں": "میزبان",
  "میزو": "میز",
  "میزوں": "میز",
  "میزیں": "میز",
  "مزے": "مزا",
  "مزا": "مزا",
  "مزاج": "مزاج",
  "مزاجو": "مزاج",
  "مزاجوں": "مزاج",
  "مزار": "مزار",
  "مزارو": "مزار",
  "مزاروں": "مزار",
  "مزدور": "مزدور",
  "مزدورو": "مزدور",
  "مزدوروں": "مزدور",
  "مزہ": "مزہ",
  "مزو": "مزا",
  "مزوں": "مزا",
  "مطالبے": "مطالبہ",
  "مطالبہ": "مطالبہ",
  "مطالبو": "مطالبہ",
  "مطالبوں": "مطالبہ",
  "مطالع": "مطالع",
  "مطالعے": "مطالع",
  "مطالعہ": "مطالعہ",
  "مطالعو": "مطالع",
  "مطالعوں": "مطالع",
  "مطلع": "مطلع",
  "مطلعے": "مطلع",
  "مطلعو": "مطلع",
  "مطلعوں": "مطلع",
  "مظاہرے": "مظاہرہ",
  "مظاہرہ": "مظاہرہ",
  "مظاہرو": "مظاہرہ",
  "مظاہروں": "مظاہرہ",
  "مظلوم": "مظلوم",
  "مظلومو": "مظلوم",
  "مظلوموں": "مظلوم",
  "نَدامَت": "نَدامَت",
  "نَدامَتو": "نَدامَت",
  "نَدامَتوں": "نَدامَت",
  "نَدامَتیں": "نَدامَت",
  "نَہِیں": "نَہِیں",
  "نَہِیںتو": "نَہِیںتو",
  "نَماز": "نَماز",
  "نَمازو": "نَماز",
  "نَمازوں": "نَماز",
  "نَمازیں": "نَماز",
  "نِکَل": "نِکَلْنا",
  "نِکَلْں": "نِکَلْنا",
  "نِکَلْنے": "نِکَلْنا",
  "نِکَلْنا": "نِکَلْنا",
  "نِکَلْنی": "نِکَلْنا",
  "نِکَلْتے": "نِکَلْنا",
  "نِکَلْتا": "نِکَلْنا",
  "نِکَلْتی": "نِکَلْنا",
  "نِکَلْتیں": "نِکَلْنا",
  "نِکَلْوا": "نِکَلْنا",
  "نِکَلْوانے": "نِکَلْنا",
  "نِکَلْوانا": "نِکَلْنا",
  "نِکَلْواتے": "نِکَلْنا",
  "نِکَلْواتا": "نِکَلْنا",
  "نِکَلْواتی": "نِکَلْنا",
  "نِکَلْواتیں": "نِکَلْنا",
  "نِکَلْواؤ": "نِکَلْنا",
  "نِکَلْواؤں": "نِکَلْنا",
  "نِکَلْوائے": "نِکَلْنا",
  "نِکَلْوائی": "نِکَلْنا",
  "نِکَلْوائیے": "نِکَلْنا",
  "نِکَلْوائیں": "نِکَلْنا",
  "نِکَلْوایا": "نِکَلْنا",
  "نِکَلے": "نِکَلْنا",
  "نِکَلا": "نِکَلْنا",
  "نِکَلو": "نِکَلْنا",
  "نِکَلوں": "نِکَلْنا",
  "نِکَلی": "نِکَلْنا",
  "نِکَلیے": "نِکَلْنا",
  "نِکَلیں": "نِکَلْنا",
  "نِکال": "نِکَلْنا",
  "نِکالے": "نِکَلْنا",
  "نِکالں": "نِکَلْنا",
  "نِکالا": "نِکَلْنا",
  "نِکالنے": "نِکَلْنا",
  "نِکالنا": "نِکَلْنا",
  "نِکالتے": "نِکَلْنا",
  "نِکالتا": "نِکَلْنا",
  "نِکالتی": "نِکَلْنا",
  "نِکالتیں": "نِکَلْنا",
  "نِکالو": "نِکَلْنا",
  "نِکالوں": "نِکَلْنا",
  "نِکالی": "نِکَلْنا",
  "نِکالیے": "نِکَلْنا",
  "نِکالیں": "نِکَلْنا",
  "نِیلے": "نِیلا",
  "نِیلا": "نِیلا",
  "نِیلی": "نِیلا",
  "نثار": "نثار",
  "نثارو": "نثار",
  "نثاروں": "نثار",
  "نے": "نے",
  "نغمے": "نغما",
  "نغما": "نغما",
  "نغمہ": "نغمہ",
  "نغمو": "نغما",
  "نغموں": "نغما",
  "نحوست": "نحوست",
  "نحوستو": "نحوست",
  "نحوستوں": "نحوست",
  "نحوستیں": "نحوست",
  "نخرے": "نخرہ",
  "نخرہ": "نخرہ",
  "نخرو": "نخرہ",
  "نخروں": "نخرہ",
  "نصرانی": "نصرانی",
  "نصرانیو": "نصرانی",
  "نصرانیوں": "نصرانی",
  "نصیحت": "نصیحت",
  "نصیحتو": "نصیحت",
  "نصیحتوں": "نصیحت",
  "نصیحتیں": "نصیحت",
  "نصیب": "نصیب",
  "نصیبو": "نصیب",
  "نصیبوں": "نصیب",
  "نشّے": "نشّہ",
  "نشّہ": "نشّہ",
  "نشّو": "نشّہ",
  "نشّوں": "نشّہ",
  "نشے": "نشا",
  "نشا": "نشا",
  "نشان": "نشان",
  "نشانے": "نشانہ",
  "نشانات": "نشان",
  "نشانہ": "نشانہ",
  "نشانو": "نشانہ",
  "نشانوں": "نشانہ",
  "نشانی": "نشانی",
  "نشانیاں": "نشانی",
  "نشانیو": "نشانی",
  "نشانیوں": "نشانی",
  "نشہ": "نشہ",
  "نشست": "نشست",
  "نشستے": "نشستہ",
  "نشستہ": "نشستہ",
  "نشستو": "نشستہ",
  "نشستوں": "نشستہ",
  "نشستیں": "نشست",
  "نشتر": "نشتر",
  "نشترو": "نشتر",
  "نشتروں": "نشتر",
  "نشو": "نشا",
  "نشوں": "نشا",
  "نشین": "نشین",
  "نشینو": "نشین",
  "نشینوں": "نشین",
  "نذرانے": "نذرانہ",
  "نذرانہ": "نذرانہ",
  "نذرانو": "نذرانہ",
  "نذرانوں": "نذرانہ",
  "نا": "نا",
  "ناخن": "ناخن",
  "ناخنو": "ناخن",
  "ناخنوں": "ناخن",
  "ناٹ": "ناٹ",
  "ناٹو": "ناٹ",
  "ناٹوں": "ناٹ",
  "ناشتے": "ناشتہ",
  "ناشتہ": "ناشتہ",
  "ناشتو": "ناشتہ",
  "ناشتوں": "ناشتہ",
  "ناانصافی": "ناانصافی",
  "ناانصافیاں": "ناانصافی",
  "ناانصافیو": "ناانصافی",
  "ناانصافیوں": "ناانصافی",
  "نابالغ": "نابالغ",
  "نابالغو": "نابالغ",
  "نابالغوں": "نابالغ",
  "نابینا": "نابینا",
  "نابیناؤ": "نابینا",
  "نابیناؤں": "نابینا",
  "ناچ": "ناچنا",
  "ناچے": "ناچنا",
  "ناچں": "ناچنا",
  "ناچا": "ناچنا",
  "ناچنے": "ناچنا",
  "ناچنا": "ناچنا",
  "ناچنی": "ناچنا",
  "ناچتے": "ناچنا",
  "ناچتا": "ناچنا",
  "ناچتی": "ناچنا",
  "ناچتیں": "ناچنا",
  "ناچو": "ناچنا",
  "ناچوں": "ناچنا",
  "ناچی": "ناچنا",
  "ناچیے": "ناچنا",
  "ناچیں": "ناچنا",
  "نادِیَہ": "نادِیَہ",
  "نادان": "نادان",
  "نادانو": "نادان",
  "نادانوں": "نادان",
  "نافے": "نافہ",
  "نافہ": "نافہ",
  "نافرمان": "نافرمان",
  "نافرمانو": "نافرمان",
  "نافرمانوں": "نافرمان",
  "نافرمانی": "نافرمانی",
  "نافرمانیاں": "نافرمانی",
  "نافرمانیو": "نافرمانی",
  "نافرمانیوں": "نافرمانی",
  "نافو": "نافہ",
  "نافوں": "نافہ",
  "ناگ": "ناگ",
  "ناگو": "ناگ",
  "ناگوں": "ناگ",
  "ناک": "ناک",
  "ناکے": "ناکہ",
  "ناکام": "ناکام",
  "ناکامو": "ناکام",
  "ناکاموں": "ناکام",
  "ناکامی": "ناکامی",
  "ناکامیاں": "ناکامی",
  "ناکامیو": "ناکامی",
  "ناکامیوں": "ناکامی",
  "ناکہ": "ناکہ",
  "ناکو": "ناکہ",
  "ناکوں": "ناکہ",
  "ناکیں": "ناک",
  "نال": "نال",
  "نالے": "نالا",
  "نالا": "نالا",
  "نالائق": "نالائق",
  "نالائقو": "نالائق",
  "نالائقوں": "نالائق",
  "نالائقی": "نالائقی",
  "نالائقیاں": "نالائقی",
  "نالائقیو": "نالائقی",
  "نالائقیوں": "نالائقی",
  "نالہ": "نالہ",
  "نالو": "نالا",
  "نالوں": "نالا",
  "نالی": "نالی",
  "نالیں": "نال",
  "نالیاں": "نالی",
  "نالیو": "نالی",
  "نالیوں": "نالی",
  "نام": "نام",
  "نامے": "نامہ",
  "نامہ": "نامہ",
  "نامراد": "نامراد",
  "نامرادو": "نامراد",
  "نامرادوں": "نامراد",
  "نامرادی": "نامرادی",
  "نامرادیاں": "نامرادی",
  "نامرادیو": "نامرادی",
  "نامرادیوں": "نامرادی",
  "نامرد": "نامرد",
  "نامردو": "نامرد",
  "نامردوں": "نامرد",
  "نامو": "نامہ",
  "ناموں": "نامہ",
  "نامی": "نامی",
  "نامیے": "نامیہ",
  "نامیہ": "نامیہ",
  "نامیو": "نامیہ",
  "نامیوں": "نامیہ",
  "نانی": "نانی",
  "نانیاں": "نانی",
  "نانیو": "نانی",
  "نانیوں": "نانی",
  "ناپ": "ناپ",
  "ناپے": "ناپنا",
  "ناپں": "ناپنا",
  "ناپا": "ناپنا",
  "ناپنے": "ناپنا",
  "ناپنا": "ناپنا",
  "ناپنی": "ناپنا",
  "ناپتے": "ناپنا",
  "ناپتا": "ناپنا",
  "ناپتی": "ناپنا",
  "ناپتیں": "ناپنا",
  "ناپو": "ناپ",
  "ناپوں": "ناپ",
  "ناپی": "ناپنا",
  "ناپیے": "ناپنا",
  "ناپیں": "ناپنا",
  "نارنجی": "نارنجی",
  "ناری": "ناری",
  "ناریاں": "ناری",
  "ناریو": "ناری",
  "ناریوں": "ناری",
  "ناسور": "ناسور",
  "ناسورو": "ناسور",
  "ناسوروں": "ناسور",
  "ناتے": "ناتا",
  "ناتا": "ناتا",
  "ناتو": "ناتا",
  "ناتوں": "ناتا",
  "ناول": "ناول",
  "ناولو": "ناول",
  "ناولوں": "ناول",
  "نائب": "نائب",
  "نائبو": "نائب",
  "نائبوں": "نائب",
  "نائی": "نائی",
  "نائیو": "نائی",
  "نائیوں": "نائی",
  "ناز": "ناز",
  "نازو": "ناز",
  "نازوں": "ناز",
  "ناطے": "ناطہ",
  "ناطہ": "ناطہ",
  "ناطو": "ناطہ",
  "ناطوں": "ناطہ",
  "نبی": "نبی",
  "نبیو": "نبی",
  "نبیوں": "نبی",
  "نبھ": "نبھنا",
  "نبھے": "نبھنا",
  "نبھں": "نبھنا",
  "نبھا": "نبھنا",
  "نبھانے": "نبھنا",
  "نبھانا": "نبھنا",
  "نبھاتے": "نبھنا",
  "نبھاتا": "نبھنا",
  "نبھاتی": "نبھنا",
  "نبھاتیں": "نبھنا",
  "نبھاؤ": "نبھنا",
  "نبھاؤں": "نبھنا",
  "نبھائے": "نبھنا",
  "نبھائی": "نبھنا",
  "نبھائیے": "نبھنا",
  "نبھائیں": "نبھنا",
  "نبھایا": "نبھنا",
  "نبھنے": "نبھنا",
  "نبھنا": "نبھنا",
  "نبھنی": "نبھنا",
  "نبھتے": "نبھنا",
  "نبھتا": "نبھنا",
  "نبھتی": "نبھنا",
  "نبھتیں": "نبھنا",
  "نبھو": "نبھنا",
  "نبھوں": "نبھنا",
  "نبھوا": "نبھنا",
  "نبھوانے": "نبھنا",
  "نبھوانا": "نبھنا",
  "نبھواتے": "نبھنا",
  "نبھواتا": "نبھنا",
  "نبھواتی": "نبھنا",
  "نبھواتیں": "نبھنا",
  "نبھواؤ": "نبھنا",
  "نبھواؤں": "نبھنا",
  "نبھوائے": "نبھنا",
  "نبھوائی": "نبھنا",
  "نبھوائیے": "نبھنا",
  "نبھوائیں": "نبھنا",
  "نبھوایا": "نبھنا",
  "نبھی": "نبھنا",
  "نبھیے": "نبھنا",
  "نبھیں": "نبھنا",
  "نچ": "نچنا",
  "نچے": "نچنا",
  "نچں": "نچنا",
  "نچا": "ناچنا",
  "نچانے": "ناچنا",
  "نچانا": "ناچنا",
  "نچاتے": "ناچنا",
  "نچاتا": "ناچنا",
  "نچاتی": "ناچنا",
  "نچاتیں": "ناچنا",
  "نچاؤ": "ناچنا",
  "نچاؤں": "ناچنا",
  "نچائے": "ناچنا",
  "نچائی": "ناچنا",
  "نچائیے": "ناچنا",
  "نچائیں": "ناچنا",
  "نچایا": "ناچنا",
  "نچنے": "نچنا",
  "نچنا": "نچنا",
  "نچنی": "نچنا",
  "نچتے": "نچنا",
  "نچتا": "نچنا",
  "نچتی": "نچنا",
  "نچتیں": "نچنا",
  "نچو": "نچنا",
  "نچوں": "نچنا",
  "نچوڑ": "نچوڑنا",
  "نچوڑے": "نچوڑنا",
  "نچوڑں": "نچوڑنا",
  "نچوڑا": "نچوڑنا",
  "نچوڑانے": "نچوڑنا",
  "نچوڑانا": "نچوڑنا",
  "نچوڑاتے": "نچوڑنا",
  "نچوڑاتا": "نچوڑنا",
  "نچوڑاتی": "نچوڑنا",
  "نچوڑاتیں": "نچوڑنا",
  "نچوڑاؤ": "نچوڑنا",
  "نچوڑاؤں": "نچوڑنا",
  "نچوڑائے": "نچوڑنا",
  "نچوڑائی": "نچوڑنا",
  "نچوڑائیے": "نچوڑنا",
  "نچوڑائیں": "نچوڑنا",
  "نچوڑایا": "نچوڑنا",
  "نچوڑنے": "نچوڑنا",
  "نچوڑنا": "نچوڑنا",
  "نچوڑنی": "نچوڑنا",
  "نچوڑتے": "نچوڑنا",
  "نچوڑتا": "نچوڑنا",
  "نچوڑتی": "نچوڑنا",
  "نچوڑتیں": "نچوڑنا",
  "نچوڑو": "نچوڑنا",
  "نچوڑوں": "نچوڑنا",
  "نچوڑوا": "نچوڑنا",
  "نچوڑوانے": "نچوڑنا",
  "نچوڑوانا": "نچوڑنا",
  "نچوڑواتے": "نچوڑنا",
  "نچوڑواتا": "نچوڑنا",
  "نچوڑواتی": "نچوڑنا",
  "نچوڑواتیں": "نچوڑنا",
  "نچوڑواؤ": "نچوڑنا",
  "نچوڑواؤں": "نچوڑنا",
  "نچوڑوائے": "نچوڑنا",
  "نچوڑوائی": "نچوڑنا",
  "نچوڑوائیے": "نچوڑنا",
  "نچوڑوائیں": "نچوڑنا",
  "نچوڑوایا": "نچوڑنا",
  "نچوڑی": "نچوڑنا",
  "نچوڑیے": "نچوڑنا",
  "نچوڑیں": "نچوڑنا",
  "نچوا": "ناچنا",
  "نچوانے": "ناچنا",
  "نچوانا": "ناچنا",
  "نچواتے": "ناچنا",
  "نچواتا": "ناچنا",
  "نچواتی": "ناچنا",
  "نچواتیں": "ناچنا",
  "نچواؤ": "ناچنا",
  "نچواؤں": "ناچنا",
  "نچوائے": "ناچنا",
  "نچوائی": "ناچنا",
  "نچوائیے": "ناچنا",
  "نچوائیں": "ناچنا",
  "نچوایا": "ناچنا",
  "نچی": "نچنا",
  "نچیے": "نچنا",
  "نچیں": "نچنا",
  "ندی": "ندی",
  "ندیا": "ندیا",
  "ندیاں": "ندی",
  "ندیو": "ندی",
  "ندیوں": "ندی",
  "نعمت": "نعمت",
  "نعمتو": "نعمت",
  "نعمتوں": "نعمت",
  "نعمتیں": "نعمت",
  "نعرے": "نعرا",
  "نعرا": "نعرا",
  "نعرہ": "نعرہ",
  "نعرو": "نعرا",
  "نعروں": "نعرا",
  "نعت": "نعت",
  "نعتو": "نعت",
  "نعتوں": "نعت",
  "نعتیں": "نعت",
  "نفل": "نفل",
  "نفلو": "نفل",
  "نفلوں": "نفل",
  "نفرت": "نفرت",
  "نفرتو": "نفرت",
  "نفرتوں": "نفرت",
  "نفرتیں": "نفرت",
  "نفس": "نفس",
  "نفسے": "نفسہ",
  "نفسہ": "نفسہ",
  "نفسو": "نفسہ",
  "نفسوں": "نفسہ",
  "نگ": "نگ",
  "نگاہ": "نگاہ",
  "نگاہو": "نگاہ",
  "نگاہوں": "نگاہ",
  "نگاہیں": "نگاہ",
  "نگار": "نگار",
  "نگارو": "نگار",
  "نگاروں": "نگار",
  "نگل": "نگلنا",
  "نگلے": "نگلنا",
  "نگلں": "نگلنا",
  "نگلا": "نگلنا",
  "نگلنے": "نگلنا",
  "نگلنا": "نگلنا",
  "نگلنی": "نگلنا",
  "نگلتے": "نگلنا",
  "نگلتا": "نگلنا",
  "نگلتی": "نگلنا",
  "نگلتیں": "نگلنا",
  "نگلو": "نگلنا",
  "نگلوں": "نگلنا",
  "نگلوا": "نگلنا",
  "نگلوانے": "نگلنا",
  "نگلوانا": "نگلنا",
  "نگلواتے": "نگلنا",
  "نگلواتا": "نگلنا",
  "نگلواتی": "نگلنا",
  "نگلواتیں": "نگلنا",
  "نگلواؤ": "نگلنا",
  "نگلواؤں": "نگلنا",
  "نگلوائے": "نگلنا",
  "نگلوائی": "نگلنا",
  "نگلوائیے": "نگلنا",
  "نگلوائیں": "نگلنا",
  "نگلوایا": "نگلنا",
  "نگلی": "نگلنا",
  "نگلیے": "نگلنا",
  "نگلیں": "نگلنا",
  "نگو": "نگ",
  "نگوں": "نگ",
  "نگینے": "نگینہ",
  "نگینہ": "نگینہ",
  "نگینو": "نگینہ",
  "نگینوں": "نگینہ",
  "نہ": "نہ",
  "نہا": "نہانا",
  "نہانے": "نہانا",
  "نہانا": "نہانا",
  "نہانی": "نہانا",
  "نہات": "نہات",
  "نہاتے": "نہانا",
  "نہاتا": "نہانا",
  "نہاتو": "نہات",
  "نہاتوں": "نہات",
  "نہاتی": "نہانا",
  "نہاتیں": "نہات",
  "نہاؤ": "نہانا",
  "نہاؤں": "نہانا",
  "نہائے": "نہانا",
  "نہائی": "نہانا",
  "نہائیے": "نہانا",
  "نہائیں": "نہانا",
  "نہایا": "نہانا",
  "نہلا": "نہانا",
  "نہلانے": "نہانا",
  "نہلانا": "نہانا",
  "نہلاتے": "نہانا",
  "نہلاتا": "نہانا",
  "نہلاتی": "نہانا",
  "نہلاتیں": "نہانا",
  "نہلاؤ": "نہانا",
  "نہلاؤں": "نہانا",
  "نہلائے": "نہانا",
  "نہلائی": "نہانا",
  "نہلائیے": "نہانا",
  "نہلائیں": "نہانا",
  "نہلایا": "نہانا",
  "نہلوا": "نہانا",
  "نہلوانے": "نہانا",
  "نہلوانا": "نہانا",
  "نہلواتے": "نہانا",
  "نہلواتا": "نہانا",
  "نہلواتی": "نہانا",
  "نہلواتیں": "نہانا",
  "نہلواؤ": "نہانا",
  "نہلواؤں": "نہانا",
  "نہلوائے": "نہانا",
  "نہلوائی": "نہانا",
  "نہلوائیے": "نہانا",
  "نہلوائیں": "نہانا",
  "نہلوایا": "نہانا",
  "نہر": "نہر",
  "نہرو": "نہر",
  "نہروں": "نہر",
  "نہریں": "نہر",
  "نہیں": "نہیں",
  "نجومی": "نجومی",
  "نجومیو": "نجومی",
  "نجومیوں": "نجومی",
  "نکڑ": "نکڑ",
  "نکڑو": "نکڑ",
  "نکڑوں": "نکڑ",
  "نکال": "نکلنا",
  "نکالے": "نکلنا",
  "نکالں": "نکلنا",
  "نکالا": "نکلنا",
  "نکالنے": "نکلنا",
  "نکالنا": "نکلنا",
  "نکالتے": "نکلنا",
  "نکالتا": "نکلنا",
  "نکالتی": "نکلنا",
  "نکالتیں": "نکلنا",
  "نکالو": "نکلنا",
  "نکالوں": "نکلنا",
  "نکالی": "نکلنا",
  "نکالیے": "نکلنا",
  "نکالیں": "نکلنا",
  "نکل": "نکلنا",
  "نکلے": "نکلنا",
  "نکلں": "نکلنا",
  "نکلا": "نکلنا",
  "نکلانے": "نکلنا",
  "نکلانا": "نکلنا",
  "نکلاتے": "نکلنا",
  "نکلاتا": "نکلنا",
  "نکلاتی": "نکلنا",
  "نکلاتیں": "نکلنا",
  "نکلاؤ": "نکلنا",
  "نکلاؤں": "نکلنا",
  "نکلائے": "نکلنا",
  "نکلائی": "نکلنا",
  "نکلائیے": "نکلنا",
  "نکلائیں": "نکلنا",
  "نکلایا": "نکلنا",
  "نکلنے": "نکلنا",
  "نکلنا": "نکلنا",
  "نکلنی": "نکلنا",
  "نکلتے": "نکلنا",
  "نکلتا": "نکلنا",
  "نکلتی": "نکلنا",
  "نکلتیں": "نکلنا",
  "نکلو": "نکلنا",
  "نکلوں": "نکلنا",
  "نکلوا": "نکلنا",
  "نکلوانے": "نکلنا",
  "نکلوانا": "نکلنا",
  "نکلواتے": "نکلنا",
  "نکلواتا": "نکلنا",
  "نکلواتی": "نکلنا",
  "نکلواتیں": "نکلنا",
  "نکلواؤ": "نکلنا",
  "نکلواؤں": "نکلنا",
  "نکلوائے": "نکلنا",
  "نکلوائی": "نکلنا",
  "نکلوائیے": "نکلنا",
  "نکلوائیں": "نکلنا",
  "نکلوایا": "نکلنا",
  "نکلی": "نکلنا",
  "نکلیے": "نکلنا",
  "نکلیں": "نکلنا",
  "نکر": "نکر",
  "نکرو": "نکر",
  "نکروں": "نکر",
  "نکریں": "نکر",
  "نکتے": "نکتہ",
  "نکتہ": "نکتہ",
  "نکتو": "نکتہ",
  "نکتوں": "نکتہ",
  "نل": "نل",
  "نلکے": "نلکا",
  "نلکا": "نلکا",
  "نلکہ": "نلکہ",
  "نلکو": "نلکا",
  "نلکوں": "نلکا",
  "نلو": "نل",
  "نلوں": "نل",
  "نمٹ": "نمٹنا",
  "نمٹے": "نمٹنا",
  "نمٹں": "نمٹنا",
  "نمٹا": "نمٹنا",
  "نمٹانے": "نمٹنا",
  "نمٹانا": "نمٹنا",
  "نمٹاتے": "نمٹنا",
  "نمٹاتا": "نمٹنا",
  "نمٹاتی": "نمٹنا",
  "نمٹاتیں": "نمٹنا",
  "نمٹاؤ": "نمٹنا",
  "نمٹاؤں": "نمٹنا",
  "نمٹائے": "نمٹنا",
  "نمٹائی": "نمٹنا",
  "نمٹائیے": "نمٹنا",
  "نمٹائیں": "نمٹنا",
  "نمٹایا": "نمٹنا",
  "نمٹنے": "نمٹنا",
  "نمٹنا": "نمٹنا",
  "نمٹنی": "نمٹنا",
  "نمٹتے": "نمٹنا",
  "نمٹتا": "نمٹنا",
  "نمٹتی": "نمٹنا",
  "نمٹتیں": "نمٹنا",
  "نمٹو": "نمٹنا",
  "نمٹوں": "نمٹنا",
  "نمٹوا": "نمٹنا",
  "نمٹوانے": "نمٹنا",
  "نمٹوانا": "نمٹنا",
  "نمٹواتے": "نمٹنا",
  "نمٹواتا": "نمٹنا",
  "نمٹواتی": "نمٹنا",
  "نمٹواتیں": "نمٹنا",
  "نمٹواؤ": "نمٹنا",
  "نمٹواؤں": "نمٹنا",
  "نمٹوائے": "نمٹنا",
  "نمٹوائی": "نمٹنا",
  "نمٹوائیے": "نمٹنا",
  "نمٹوائیں": "نمٹنا",
  "نمٹوایا": "نمٹنا",
  "نمٹی": "نمٹنا",
  "نمٹیے": "نمٹنا",
  "نمٹیں": "نمٹنا",
  "نمائندے": "نمائندہ",
  "نمائندہ": "نمائندہ",
  "نمائندو": "نمائندہ",
  "نمائندوں": "نمائندہ",
  "نماز": "نماز",
  "نمازو": "نماز",
  "نمازوں": "نماز",
  "نمازی": "نمازی",
  "نمازیں": "نماز",
  "نمازیو": "نمازی",
  "نمازیوں": "نمازی",
  "نمبر": "نمبر",
  "نمبرو": "نمبر",
  "نمبروں": "نمبر",
  "نمدے": "نمدہ",
  "نمدہ": "نمدہ",
  "نمدو": "نمدہ",
  "نمدوں": "نمدہ",
  "نمرود": "نمرود",
  "نمرودو": "نمرود",
  "نمرودوں": "نمرود",
  "نمونے": "نمونا",
  "نمونا": "نمونا",
  "نمونہ": "نمونہ",
  "نمونو": "نمونا",
  "نمونوں": "نمونا",
  "نمونیے": "نمونیہ",
  "نمونیہ": "نمونیہ",
  "نمونیو": "نمونیہ",
  "نمونیوں": "نمونیہ",
  "نند": "نند",
  "نندو": "نند",
  "نندوں": "نند",
  "نندیں": "نند",
  "ننگے": "ننگا",
  "ننگا": "ننگا",
  "ننگو": "ننگا",
  "ننگوں": "ننگا",
  "نقصان": "نقصان",
  "نقصانات": "نقصان",
  "نقصانو": "نقصان",
  "نقصانوں": "نقصان",
  "نقشے": "نقشہ",
  "نقشہ": "نقشہ",
  "نقشو": "نقشہ",
  "نقشوں": "نقشہ",
  "نقاب": "نقاب",
  "نقابو": "نقاب",
  "نقابوں": "نقاب",
  "نقاد": "نقاد",
  "نقادو": "نقاد",
  "نقادوں": "نقاد",
  "نقارے": "نقارہ",
  "نقارہ": "نقارہ",
  "نقارو": "نقارہ",
  "نقاروں": "نقارہ",
  "نقد": "نقد",
  "نقدو": "نقد",
  "نقدوں": "نقد",
  "نقل": "نقل",
  "نقلو": "نقل",
  "نقلوں": "نقل",
  "نقلیں": "نقل",
  "نقیب": "نقیب",
  "نقیبو": "نقیب",
  "نقیبوں": "نقیب",
  "نقیبیں": "نقیب",
  "نقط": "نقط",
  "نقطے": "نقطہ",
  "نقطہ": "نقطہ",
  "نقطو": "نقطہ",
  "نقطوں": "نقطہ",
  "نقطیں": "نقط",
  "نرس": "نرس",
  "نرسو": "نرس",
  "نرسوں": "نرس",
  "نرسیں": "نرس",
  "نس": "نس",
  "نسخے": "نسخہ",
  "نسخہ": "نسخہ",
  "نسخو": "نسخہ",
  "نسخوں": "نسخہ",
  "نسبت": "نسبت",
  "نسبتو": "نسبت",
  "نسبتوں": "نسبت",
  "نسبتیں": "نسبت",
  "نسل": "نسل",
  "نسلو": "نسل",
  "نسلوں": "نسل",
  "نسلیں": "نسل",
  "نسو": "نس",
  "نسوں": "نس",
  "نسیں": "نس",
  "نتیجے": "نتیجہ",
  "نتیجہ": "نتیجہ",
  "نتیجو": "نتیجہ",
  "نتیجوں": "نتیجہ",
  "نتھ": "نتھ",
  "نتھو": "نتھ",
  "نتھوں": "نتھ",
  "نتھیں": "نتھ",
  "نو": "نو",
  "نوٹ": "نوٹ",
  "نوٹو": "نوٹ",
  "نوٹوں": "نوٹ",
  "نوشت": "نوشت",
  "نوشتے": "نوشتہ",
  "نوشتہ": "نوشتہ",
  "نوشتو": "نوشتہ",
  "نوشتوں": "نوشتہ",
  "نوشتیں": "نوشت",
  "نواب": "نواب",
  "نوابو": "نواب",
  "نوابوں": "نواب",
  "نواسے": "نواسہ",
  "نواسہ": "نواسہ",
  "نواسو": "نواسہ",
  "نواسوں": "نواسہ",
  "نواسی": "نواسی",
  "نواسیاں": "نواسی",
  "نواسیو": "نواسی",
  "نواسیوں": "نواسی",
  "نواز": "نواز",
  "نوازے": "نوازنا",
  "نوازں": "نوازنا",
  "نوازش": "نوازش",
  "نوازشو": "نوازش",
  "نوازشوں": "نوازش",
  "نوازشیں": "نوازش",
  "نوازا": "نوازنا",
  "نوازنے": "نوازنا",
  "نوازنا": "نوازنا",
  "نوازنی": "نوازنا",
  "نوازتے": "نوازنا",
  "نوازتا": "نوازنا",
  "نوازتی": "نوازنا",
  "نوازتیں": "نوازنا",
  "نوازو": "نواز",
  "نوازوں": "نواز",
  "نوازی": "نوازی",
  "نوازیے": "نوازنا",
  "نوازیں": "نوازنا",
  "نوازیاں": "نوازی",
  "نوازیو": "نوازی",
  "نوازیوں": "نوازی",
  "نوجوان": "نوجوان",
  "نوجوانو": "نوجوان",
  "نوجوانوں": "نوجوان",
  "نوکر": "نوکر",
  "نوکرانی": "نوکرانی",
  "نوکرانیاں": "نوکرانی",
  "نوکرانیو": "نوکرانی",
  "نوکرانیوں": "نوکرانی",
  "نوکرو": "نوکر",
  "نوکروں": "نوکر",
  "نوکری": "نوکری",
  "نوکریاں": "نوکری",
  "نوکریو": "نوکری",
  "نوکریوں": "نوکری",
  "نویس": "نویس",
  "نویسو": "نویس",
  "نویسوں": "نویس",
  "نیچے": "نیچہ",
  "نیچہ": "نیچہ",
  "نیچو": "نیچہ",
  "نیچوں": "نیچہ",
  "نیک": "نیک",
  "نیکر": "نیکر",
  "نیکرو": "نیکر",
  "نیکروں": "نیکر",
  "نیکریں": "نیکر",
  "نیکو": "نیک",
  "نیکوں": "نیک",
  "نیکوکار": "نیکوکار",
  "نیکوکارو": "نیکوکار",
  "نیکوکاروں": "نیکوکار",
  "نیکی": "نیکی",
  "نیکیاں": "نیکی",
  "نیکیو": "نیکی",
  "نیکیوں": "نیکی",
  "نیل": "نیل",
  "نیلے": "نیلا",
  "نیلا": "نیلا",
  "نیلو": "نیلا",
  "نیلوں": "نیلا",
  "نیند": "نیند",
  "نیندو": "نیند",
  "نیندوں": "نیند",
  "نیندیں": "نیند",
  "نیرنگی": "نیرنگی",
  "نیرنگیاں": "نیرنگی",
  "نیرنگیو": "نیرنگی",
  "نیرنگیوں": "نیرنگی",
  "نیزے": "نیزہ",
  "نیزہ": "نیزہ",
  "نیزو": "نیزہ",
  "نیزوں": "نیزہ",
  "نزاکت": "نزاکت",
  "نزاکتو": "نزاکت",
  "نزاکتوں": "نزاکت",
  "نزاکتیں": "نزاکت",
  "نزلے": "نزلہ",
  "نزلہ": "نزلہ",
  "نزلو": "نزلہ",
  "نزلوں": "نزلہ",
  "نظّارے": "نظّارہ",
  "نظّارہ": "نظّارہ",
  "نظّارو": "نظّارہ",
  "نظّاروں": "نظّارہ",
  "نظارے": "نظارہ",
  "نظارہ": "نظارہ",
  "نظارو": "نظارہ",
  "نظاروں": "نظارہ",
  "نظم": "نظم",
  "نظمو": "نظم",
  "نظموں": "نظم",
  "نظمیں": "نظم",
  "نظر": "نظر",
  "نظرو": "نظر",
  "نظروں": "نظر",
  "نظریے": "نظریہ",
  "نظریں": "نظر",
  "نظریہ": "نظریہ",
  "نظریو": "نظریہ",
  "نظریوں": "نظریہ",
  "پَڑْھ": "پَڑْھنا",
  "پَڑْھے": "پَڑْھنا",
  "پَڑْھں": "پَڑْھنا",
  "پَڑْھا": "پَڑْھنا",
  "پَڑْھانے": "پَڑْھنا",
  "پَڑْھانا": "پَڑْھنا",
  "پَڑْھاتے": "پَڑْھنا",
  "پَڑْھاتا": "پَڑْھنا",
  "پَڑْھاتی": "پَڑْھنا",
  "پَڑْھاتیں": "پَڑْھنا",
  "پَڑْھاؤ": "پَڑْھنا",
  "پَڑْھاؤں": "پَڑْھنا",
  "پَڑْھائے": "پَڑْھنا",
  "پَڑْھائی": "پَڑْھنا",
  "پَڑْھائیے": "پَڑْھنا",
  "پَڑْھائیں": "پَڑْھنا",
  "پَڑْھایا": "پَڑْھنا",
  "پَڑْھنے": "پَڑْھنا",
  "پَڑْھنا": "پَڑْھنا",
  "پَڑْھنی": "پَڑْھنا",
  "پَڑْھتے": "پَڑْھنا",
  "پَڑْھتا": "پَڑْھنا",
  "پَڑْھتی": "پَڑْھنا",
  "پَڑْھتیں": "پَڑْھنا",
  "پَڑْھو": "پَڑْھنا",
  "پَڑْھوں": "پَڑْھنا",
  "پَڑْھوا": "پَڑْھنا",
  "پَڑْھوانے": "پَڑْھنا",
  "پَڑْھوانا": "پَڑْھنا",
  "پَڑْھواتے": "پَڑْھنا",
  "پَڑْھواتا": "پَڑْھنا",
  "پَڑْھواتی": "پَڑْھنا",
  "پَڑْھواتیں": "پَڑْھنا",
  "پَڑْھواؤ": "پَڑْھنا",
  "پَڑْھواؤں": "پَڑْھنا",
  "پَڑْھوائے": "پَڑْھنا",
  "پَڑْھوائی": "پَڑْھنا",
  "پَڑْھوائیے": "پَڑْھنا",
  "پَڑْھوائیں": "پَڑْھنا",
  "پَڑْھوایا": "پَڑْھنا",
  "پَڑْھی": "پَڑْھنا",
  "پَڑْھیے": "پَڑْھنا",
  "پَڑْھیں": "پَڑْھنا",
  "پَل": "پَلْنا",
  "پَلْں": "پَلْنا",
  "پَلْنے": "پَلْنا",
  "پَلْنا": "پَلْنا",
  "پَلْنی": "پَلْنا",
  "پَلْتے": "پَلْنا",
  "پَلْتا": "پَلْنا",
  "پَلْتی": "پَلْنا",
  "پَلْتیں": "پَلْنا",
  "پَلْوا": "پَلْنا",
  "پَلْوانے": "پَلْنا",
  "پَلْوانا": "پَلْنا",
  "پَلْواتے": "پَلْنا",
  "پَلْواتا": "پَلْنا",
  "پَلْواتی": "پَلْنا",
  "پَلْواتیں": "پَلْنا",
  "پَلْواؤ": "پَلْنا",
  "پَلْواؤں": "پَلْنا",
  "پَلْوائے": "پَلْنا",
  "پَلْوائی": "پَلْنا",
  "پَلْوائیے": "پَلْنا",
  "پَلْوائیں": "پَلْنا",
  "پَلْوایا": "پَلْنا",
  "پَلے": "پَلْنا",
  "پَلا": "پَلْنا",
  "پَلو": "پَلْنا",
  "پَلوں": "پَلْنا",
  "پَلی": "پَلْنا",
  "پَلیے": "پَلْنا",
  "پَلیں": "پَلْنا",
  "پَر": "پَر",
  "پَرْدَے": "پَرْدَہ",
  "پَرْدَہ": "پَرْدَہ",
  "پَرْدَو": "پَرْدَہ",
  "پَرْدَوں": "پَرْدَہ",
  "پَرو": "پَر",
  "پَروں": "پَر",
  "پَتَّھر": "پَتَّھر",
  "پَتَّھرو": "پَتَّھر",
  "پَتَّھروں": "پَتَّھر",
  "پِٹ": "پِٹنا",
  "پِٹے": "پِٹنا",
  "پِٹں": "پِٹنا",
  "پِٹا": "پِٹنا",
  "پِٹنے": "پِٹنا",
  "پِٹنا": "پِٹنا",
  "پِٹنی": "پِٹنا",
  "پِٹتے": "پِٹنا",
  "پِٹتا": "پِٹنا",
  "پِٹتی": "پِٹنا",
  "پِٹتیں": "پِٹنا",
  "پِٹو": "پِٹنا",
  "پِٹوں": "پِٹنا",
  "پِٹوا": "پِٹنا",
  "پِٹوانے": "پِٹنا",
  "پِٹوانا": "پِٹنا",
  "پِٹواتے": "پِٹنا",
  "پِٹواتا": "پِٹنا",
  "پِٹواتی": "پِٹنا",
  "پِٹواتیں": "پِٹنا",
  "پِٹواؤ": "پِٹنا",
  "پِٹواؤں": "پِٹنا",
  "پِٹوائے": "پِٹنا",
  "پِٹوائی": "پِٹنا",
  "پِٹوائیے": "پِٹنا",
  "پِٹوائیں": "پِٹنا",
  "پِٹوایا": "پِٹنا",
  "پِٹی": "پِٹنا",
  "پِٹیے": "پِٹنا",
  "پِٹیں": "پِٹنا",
  "پِلا": "پِینا",
  "پِلانے": "پِینا",
  "پِلانا": "پِینا",
  "پِلاتے": "پِینا",
  "پِلاتا": "پِینا",
  "پِلاتی": "پِینا",
  "پِلاتیں": "پِینا",
  "پِلاؤ": "پِینا",
  "پِلاؤں": "پِینا",
  "پِلائے": "پِینا",
  "پِلائی": "پِینا",
  "پِلائیے": "پِینا",
  "پِلائیں": "پِینا",
  "پِلایا": "پِینا",
  "پِلوا": "پِینا",
  "پِلوانے": "پِینا",
  "پِلوانا": "پِینا",
  "پِلواتے": "پِینا",
  "پِلواتا": "پِینا",
  "پِلواتی": "پِینا",
  "پِلواتیں": "پِینا",
  "پِلواؤ": "پِینا",
  "پِلواؤں": "پِینا",
  "پِلوائے": "پِینا",
  "پِلوائی": "پِینا",
  "پِلوائیے": "پِینا",
  "پِلوائیں": "پِینا",
  "پِلوایا": "پِینا",
  "پِس": "پِسْنا",
  "پِسْں": "پِسْنا",
  "پِسْنے": "پِسْنا",
  "پِسْنا": "پِسْنا",
  "پِسْنی": "پِسْنا",
  "پِسْتے": "پِسْنا",
  "پِسْتا": "پِسْنا",
  "پِسْتی": "پِسْنا",
  "پِسْتیں": "پِسْنا",
  "پِسْوا": "پِسْنا",
  "پِسْوانے": "پِسْنا",
  "پِسْوانا": "پِسْنا",
  "پِسْواتے": "پِسْنا",
  "پِسْواتا": "پِسْنا",
  "پِسْواتی": "پِسْنا",
  "پِسْواتیں": "پِسْنا",
  "پِسْواؤ": "پِسْنا",
  "پِسْواؤں": "پِسْنا",
  "پِسْوائے": "پِسْنا",
  "پِسْوائی": "پِسْنا",
  "پِسْوائیے": "پِسْنا",
  "پِسْوائیں": "پِسْنا",
  "پِسْوایا": "پِسْنا",
  "پِسے": "پِسْنا",
  "پِسا": "پِسْنا",
  "پِسو": "پِسْنا",
  "پِسوں": "پِسْنا",
  "پِسی": "پِسْنا",
  "پِسیے": "پِسْنا",
  "پِسیں": "پِسْنا",
  "پِی": "پِینا",
  "پِیے": "پِینا",
  "پِیں": "پِینا",
  "پِیا": "پِینا",
  "پِیلے": "پِیلا",
  "پِیلا": "پِیلا",
  "پِیلی": "پِیلا",
  "پِینے": "پِینا",
  "پِینا": "پِینا",
  "پِینی": "پِینا",
  "پِیس": "پِسْنا",
  "پِیسْں": "پِسْنا",
  "پِیسْنے": "پِسْنا",
  "پِیسْنا": "پِسْنا",
  "پِیسْتے": "پِسْنا",
  "پِیسْتا": "پِسْنا",
  "پِیسْتی": "پِسْنا",
  "پِیسْتیں": "پِسْنا",
  "پِیسے": "پِسْنا",
  "پِیسا": "پِسْنا",
  "پِیسو": "پِسْنا",
  "پِیسوں": "پِسْنا",
  "پِیسی": "پِسْنا",
  "پِیسیے": "پِسْنا",
  "پِیسیں": "پِسْنا",
  "پِیتے": "پِینا",
  "پِیتا": "پِینا",
  "پِیتی": "پِینا",
  "پِیتیں": "پِینا",
  "پِیو": "پِینا",
  "پِیوں": "پِینا",
  "پِیی": "پِینا",
  "پِییے": "پِینا",
  "پِییں": "پِینا",
  "پِھر": "پِھرنا",
  "پِھرے": "پِھرنا",
  "پِھرں": "پِھرنا",
  "پِھرا": "پِھرنا",
  "پِھرانے": "پِھرنا",
  "پِھرانا": "پِھرنا",
  "پِھراتے": "پِھرنا",
  "پِھراتا": "پِھرنا",
  "پِھراتی": "پِھرنا",
  "پِھراتیں": "پِھرنا",
  "پِھراؤ": "پِھرنا",
  "پِھراؤں": "پِھرنا",
  "پِھرائے": "پِھرنا",
  "پِھرائی": "پِھرنا",
  "پِھرائیے": "پِھرنا",
  "پِھرائیں": "پِھرنا",
  "پِھرایا": "پِھرنا",
  "پِھرنے": "پِھرنا",
  "پِھرنا": "پِھرنا",
  "پِھرنی": "پِھرنا",
  "پِھرتے": "پِھرنا",
  "پِھرتا": "پِھرنا",
  "پِھرتی": "پِھرنا",
  "پِھرتیں": "پِھرنا",
  "پِھرو": "پِھرنا",
  "پِھروں": "پِھرنا",
  "پِھروا": "پِھرنا",
  "پِھروانے": "پِھرنا",
  "پِھروانا": "پِھرنا",
  "پِھرواتے": "پِھرنا",
  "پِھرواتا": "پِھرنا",
  "پِھرواتی": "پِھرنا",
  "پِھرواتیں": "پِھرنا",
  "پِھرواؤ": "پِھرنا",
  "پِھرواؤں": "پِھرنا",
  "پِھروائے": "پِھرنا",
  "پِھروائی": "پِھرنا",
  "پِھروائیے": "پِھرنا",
  "پِھروائیں": "پِھرنا",
  "پِھروایا": "پِھرنا",
  "پِھری": "پِھرنا",
  "پِھریے": "پِھرنا",
  "پِھریں": "پِھرنا",
  "پُلاؤ": "پُلاؤ",
  "پُرے": "پُرا",
  "پُرا": "پُرا",
  "پُرکھ": "پُرکھ",
  "پُرکھو": "پُرکھ",
  "پُرکھوں": "پُرکھ",
  "پُرکھیں": "پُرکھ",
  "پُرو": "پُرا",
  "پُروں": "پُرا",
  "پُرزے": "پُرزہ",
  "پُرزہ": "پُرزہ",
  "پُرزو": "پُرزہ",
  "پُرزوں": "پُرزہ",
  "پُتلی": "پُتلی",
  "پُتلیاں": "پُتلی",
  "پُتلیو": "پُتلی",
  "پُتلیوں": "پُتلی",
  "پُوچھ": "پُوچھنا",
  "پُوچھے": "پُوچھنا",
  "پُوچھں": "پُوچھنا",
  "پُوچھا": "پُوچھنا",
  "پُوچھانے": "پُوچھنا",
  "پُوچھانا": "پُوچھنا",
  "پُوچھاتے": "پُوچھنا",
  "پُوچھاتا": "پُوچھنا",
  "پُوچھاتی": "پُوچھنا",
  "پُوچھاتیں": "پُوچھنا",
  "پُوچھاؤ": "پُوچھنا",
  "پُوچھاؤں": "پُوچھنا",
  "پُوچھائے": "پُوچھنا",
  "پُوچھائی": "پُوچھنا",
  "پُوچھائیے": "پُوچھنا",
  "پُوچھائیں": "پُوچھنا",
  "پُوچھایا": "پُوچھنا",
  "پُوچھنے": "پُوچھنا",
  "پُوچھنا": "پُوچھنا",
  "پُوچھنی": "پُوچھنا",
  "پُوچھتے": "پُوچھنا",
  "پُوچھتا": "پُوچھنا",
  "پُوچھتی": "پُوچھنا",
  "پُوچھتیں": "پُوچھنا",
  "پُوچھو": "پُوچھنا",
  "پُوچھوں": "پُوچھنا",
  "پُوچھوا": "پُوچھنا",
  "پُوچھوانے": "پُوچھنا",
  "پُوچھوانا": "پُوچھنا",
  "پُوچھواتے": "پُوچھنا",
  "پُوچھواتا": "پُوچھنا",
  "پُوچھواتی": "پُوچھنا",
  "پُوچھواتیں": "پُوچھنا",
  "پُوچھواؤ": "پُوچھنا",
  "پُوچھواؤں": "پُوچھنا",
  "پُوچھوائے": "پُوچھنا",
  "پُوچھوائی": "پُوچھنا",
  "پُوچھوائیے": "پُوچھنا",
  "پُوچھوائیں": "پُوچھنا",
  "پُوچھوایا": "پُوچھنا",
  "پُوچھی": "پُوچھنا",
  "پُوچھیے": "پُوچھنا",
  "پُوچھیں": "پُوچھنا",
  "پُوج": "پُوجنا",
  "پُوجے": "پُوجنا",
  "پُوجں": "پُوجنا",
  "پُوجا": "پُوجنا",
  "پُوجانے": "پُوجنا",
  "پُوجانا": "پُوجنا",
  "پُوجاتے": "پُوجنا",
  "پُوجاتا": "پُوجنا",
  "پُوجاتی": "پُوجنا",
  "پُوجاتیں": "پُوجنا",
  "پُوجاؤ": "پُوجنا",
  "پُوجاؤں": "پُوجنا",
  "پُوجائے": "پُوجنا",
  "پُوجائی": "پُوجنا",
  "پُوجائیے": "پُوجنا",
  "پُوجائیں": "پُوجنا",
  "پُوجایا": "پُوجنا",
  "پُوجنے": "پُوجنا",
  "پُوجنا": "پُوجنا",
  "پُوجنی": "پُوجنا",
  "پُوجتے": "پُوجنا",
  "پُوجتا": "پُوجنا",
  "پُوجتی": "پُوجنا",
  "پُوجتیں": "پُوجنا",
  "پُوجو": "پُوجنا",
  "پُوجوں": "پُوجنا",
  "پُوجوا": "پُوجنا",
  "پُوجوانے": "پُوجنا",
  "پُوجوانا": "پُوجنا",
  "پُوجواتے": "پُوجنا",
  "پُوجواتا": "پُوجنا",
  "پُوجواتی": "پُوجنا",
  "پُوجواتیں": "پُوجنا",
  "پُوجواؤ": "پُوجنا",
  "پُوجواؤں": "پُوجنا",
  "پُوجوائے": "پُوجنا",
  "پُوجوائی": "پُوجنا",
  "پُوجوائیے": "پُوجنا",
  "پُوجوائیں": "پُوجنا",
  "پُوجوایا": "پُوجنا",
  "پُوجی": "پُوجنا",
  "پُوجیے": "پُوجنا",
  "پُوجیں": "پُوجنا",
  "پُھلا": "پُھولنا",
  "پُھلانے": "پُھولنا",
  "پُھلانا": "پُھولنا",
  "پُھلاتے": "پُھولنا",
  "پُھلاتا": "پُھولنا",
  "پُھلاتی": "پُھولنا",
  "پُھلاتیں": "پُھولنا",
  "پُھلاؤ": "پُھولنا",
  "پُھلاؤں": "پُھولنا",
  "پُھلائے": "پُھولنا",
  "پُھلائی": "پُھولنا",
  "پُھلائیے": "پُھولنا",
  "پُھلائیں": "پُھولنا",
  "پُھلایا": "پُھولنا",
  "پُھلوا": "پُھولنا",
  "پُھلوانے": "پُھولنا",
  "پُھلوانا": "پُھولنا",
  "پُھلواتے": "پُھولنا",
  "پُھلواتا": "پُھولنا",
  "پُھلواتی": "پُھولنا",
  "پُھلواتیں": "پُھولنا",
  "پُھلواؤ": "پُھولنا",
  "پُھلواؤں": "پُھولنا",
  "پُھلوائے": "پُھولنا",
  "پُھلوائی": "پُھولنا",
  "پُھلوائیے": "پُھولنا",
  "پُھلوائیں": "پُھولنا",
  "پُھلوایا": "پُھولنا",
  "پُھسلا": "پُھسلانا",
  "پُھسلانے": "پُھسلانا",
  "پُھسلانا": "پُھسلانا",
  "پُھسلانی": "پُھسلانا",
  "پُھسلاتے": "پُھسلانا",
  "پُھسلاتا": "پُھسلانا",
  "پُھسلاتی": "پُھسلانا",
  "پُھسلاتیں": "پُھسلانا",
  "پُھسلاؤ": "پُھسلانا",
  "پُھسلاؤں": "پُھسلانا",
  "پُھسلائے": "پُھسلانا",
  "پُھسلائی": "پُھسلانا",
  "پُھسلائیے": "پُھسلانا",
  "پُھسلائیں": "پُھسلانا",
  "پُھسلایا": "پُھسلانا",
  "پُھسلوا": "پُھسلانا",
  "پُھسلوانے": "پُھسلانا",
  "پُھسلوانا": "پُھسلانا",
  "پُھسلواتے": "پُھسلانا",
  "پُھسلواتا": "پُھسلانا",
  "پُھسلواتی": "پُھسلانا",
  "پُھسلواتیں": "پُھسلانا",
  "پُھسلواؤ": "پُھسلانا",
  "پُھسلواؤں": "پُھسلانا",
  "پُھسلوائے": "پُھسلانا",
  "پُھسلوائی": "پُھسلانا",
  "پُھسلوائیے": "پُھسلانا",
  "پُھسلوائیں": "پُھسلانا",
  "پُھسلوایا": "پُھسلانا",
  "پُھوٹ": "پُھوٹنا",
  "پُھوٹے": "پُھوٹنا",
  "پُھوٹں": "پُھوٹنا",
  "پُھوٹا": "پُھوٹنا",
  "پُھوٹنے": "پُھوٹنا",
  "پُھوٹنا": "پُھوٹنا",
  "پُھوٹنی": "پُھوٹنا",
  "پُھوٹتے": "پُھوٹنا",
  "پُھوٹتا": "پُھوٹنا",
  "پُھوٹتی": "پُھوٹنا",
  "پُھوٹتیں": "پُھوٹنا",
  "پُھوٹو": "پُھوٹنا",
  "پُھوٹوں": "پُھوٹنا",
  "پُھوٹوا": "پُھوٹنا",
  "پُھوٹوانے": "پُھوٹنا",
  "پُھوٹوانا": "پُھوٹنا",
  "پُھوٹواتے": "پُھوٹنا",
  "پُھوٹواتا": "پُھوٹنا",
  "پُھوٹواتی": "پُھوٹنا",
  "پُھوٹواتیں": "پُھوٹنا",
  "پُھوٹواؤ": "پُھوٹنا",
  "پُھوٹواؤں": "پُھوٹنا",
  "پُھوٹوائے": "پُھوٹنا",
  "پُھوٹوائی": "پُھوٹنا",
  "پُھوٹوائیے": "پُھوٹنا",
  "پُھوٹوائیں": "پُھوٹنا",
  "پُھوٹوایا": "پُھوٹنا",
  "پُھوٹی": "پُھوٹنا",
  "پُھوٹیے": "پُھوٹنا",
  "پُھوٹیں": "پُھوٹنا",
  "پُھول": "پُھول",
  "پُھولے": "پُھولنا",
  "پُھولں": "پُھولنا",
  "پُھولا": "پُھولنا",
  "پُھولانے": "پُھولنا",
  "پُھولانا": "پُھولنا",
  "پُھولاتے": "پُھولنا",
  "پُھولاتا": "پُھولنا",
  "پُھولاتی": "پُھولنا",
  "پُھولاتیں": "پُھولنا",
  "پُھولاؤ": "پُھولنا",
  "پُھولاؤں": "پُھولنا",
  "پُھولائے": "پُھولنا",
  "پُھولائی": "پُھولنا",
  "پُھولائیے": "پُھولنا",
  "پُھولائیں": "پُھولنا",
  "پُھولایا": "پُھولنا",
  "پُھولنے": "پُھولنا",
  "پُھولنا": "پُھولنا",
  "پُھولنی": "پُھولنا",
  "پُھولتے": "پُھولنا",
  "پُھولتا": "پُھولنا",
  "پُھولتی": "پُھولنا",
  "پُھولتیں": "پُھولنا",
  "پُھولو": "پُھول",
  "پُھولوں": "پُھول",
  "پُھولوا": "پُھولنا",
  "پُھولوانے": "پُھولنا",
  "پُھولوانا": "پُھولنا",
  "پُھولواتے": "پُھولنا",
  "پُھولواتا": "پُھولنا",
  "پُھولواتی": "پُھولنا",
  "پُھولواتیں": "پُھولنا",
  "پُھولواؤ": "پُھولنا",
  "پُھولواؤں": "پُھولنا",
  "پُھولوائے": "پُھولنا",
  "پُھولوائی": "پُھولنا",
  "پُھولوائیے": "پُھولنا",
  "پُھولوائیں": "پُھولنا",
  "پُھولوایا": "پُھولنا",
  "پُھولی": "پُھولنا",
  "پُھولیے": "پُھولنا",
  "پُھولیں": "پُھولنا",
  "پخت": "پخت",
  "پختے": "پختہ",
  "پختہ": "پختہ",
  "پختو": "پختہ",
  "پختوں": "پختہ",
  "پختون": "پختون",
  "پختونو": "پختون",
  "پختونوں": "پختون",
  "پختیں": "پخت",
  "پڑ": "پڑنا",
  "پڑے": "پڑنا",
  "پڑں": "پڑنا",
  "پڑا": "پڑنا",
  "پڑاؤ": "پڑاؤ",
  "پڑنے": "پڑنا",
  "پڑنا": "پڑنا",
  "پڑنی": "پڑنا",
  "پڑت": "پڑت",
  "پڑتے": "پڑنا",
  "پڑتا": "پڑنا",
  "پڑتو": "پڑت",
  "پڑتوں": "پڑت",
  "پڑتی": "پڑنا",
  "پڑتیں": "پڑت",
  "پڑو": "پڑنا",
  "پڑوں": "پڑنا",
  "پڑوا": "پڑنا",
  "پڑوانے": "پڑنا",
  "پڑوانا": "پڑنا",
  "پڑواتے": "پڑنا",
  "پڑواتا": "پڑنا",
  "پڑواتی": "پڑنا",
  "پڑواتیں": "پڑنا",
  "پڑواؤ": "پڑنا",
  "پڑواؤں": "پڑنا",
  "پڑوائے": "پڑنا",
  "پڑوائی": "پڑنا",
  "پڑوائیے": "پڑنا",
  "پڑوائیں": "پڑنا",
  "پڑوایا": "پڑنا",
  "پڑوسن": "پڑوسن",
  "پڑوسنو": "پڑوسن",
  "پڑوسنوں": "پڑوسن",
  "پڑوسنیں": "پڑوسن",
  "پڑوسی": "پڑوسی",
  "پڑوسیو": "پڑوسی",
  "پڑوسیوں": "پڑوسی",
  "پڑی": "پڑی",
  "پڑیے": "پڑنا",
  "پڑیں": "پڑنا",
  "پڑیا": "پڑیا",
  "پڑیاں": "پڑی",
  "پڑیو": "پڑی",
  "پڑیوں": "پڑی",
  "پڑھ": "پڑھنا",
  "پڑھے": "پڑھنا",
  "پڑھں": "پڑھنا",
  "پڑھا": "پڑھنا",
  "پڑھانے": "پڑھنا",
  "پڑھانا": "پڑھنا",
  "پڑھاتے": "پڑھنا",
  "پڑھاتا": "پڑھنا",
  "پڑھاتی": "پڑھنا",
  "پڑھاتیں": "پڑھنا",
  "پڑھاؤ": "پڑھنا",
  "پڑھاؤں": "پڑھنا",
  "پڑھائے": "پڑھنا",
  "پڑھائی": "پڑھنا",
  "پڑھائیے": "پڑھنا",
  "پڑھائیں": "پڑھنا",
  "پڑھایا": "پڑھنا",
  "پڑھنے": "پڑھنا",
  "پڑھنا": "پڑھنا",
  "پڑھنی": "پڑھنا",
  "پڑھتے": "پڑھنا",
  "پڑھتا": "پڑھنا",
  "پڑھتی": "پڑھنا",
  "پڑھتیں": "پڑھنا",
  "پڑھو": "پڑھنا",
  "پڑھوں": "پڑھنا",
  "پڑھوا": "پڑھنا",
  "پڑھوانے": "پڑھنا",
  "پڑھوانا": "پڑھنا",
  "پڑھواتے": "پڑھنا",
  "پڑھواتا": "پڑھنا",
  "پڑھواتی": "پڑھنا",
  "پڑھواتیں": "پڑھنا",
  "پڑھواؤ": "پڑھنا",
  "پڑھواؤں": "پڑھنا",
  "پڑھوائے": "پڑھنا",
  "پڑھوائی": "پڑھنا",
  "پڑھوائیے": "پڑھنا",
  "پڑھوائیں": "پڑھنا",
  "پڑھوایا": "پڑھنا",
  "پڑھی": "پڑھنا",
  "پڑھیے": "پڑھیا",
  "پڑھیں": "پڑھنا",
  "پڑھیا": "پڑھیا",
  "پڑھیو": "پڑھیا",
  "پڑھیوں": "پڑھیا",
  "پٹ": "پٹنا",
  "پٹے": "پٹا",
  "پٹخ": "پٹخنا",
  "پٹخے": "پٹخنا",
  "پٹخں": "پٹخنا",
  "پٹخا": "پٹخنا",
  "پٹخانے": "پٹخنا",
  "پٹخانا": "پٹخنا",
  "پٹخاتے": "پٹخنا",
  "پٹخاتا": "پٹخنا",
  "پٹخاتی": "پٹخنا",
  "پٹخاتیں": "پٹخنا",
  "پٹخاؤ": "پٹخنا",
  "پٹخاؤں": "پٹخنا",
  "پٹخائے": "پٹخنا",
  "پٹخائی": "پٹخنا",
  "پٹخائیے": "پٹخنا",
  "پٹخائیں": "پٹخنا",
  "پٹخایا": "پٹخنا",
  "پٹخنے": "پٹخنا",
  "پٹخنا": "پٹخنا",
  "پٹخنی": "پٹخنا",
  "پٹختے": "پٹخنا",
  "پٹختا": "پٹخنا",
  "پٹختی": "پٹخنا",
  "پٹختیں": "پٹخنا",
  "پٹخو": "پٹخنا",
  "پٹخوں": "پٹخنا",
  "پٹخوا": "پٹخنا",
  "پٹخوانے": "پٹخنا",
  "پٹخوانا": "پٹخنا",
  "پٹخواتے": "پٹخنا",
  "پٹخواتا": "پٹخنا",
  "پٹخواتی": "پٹخنا",
  "پٹخواتیں": "پٹخنا",
  "پٹخواؤ": "پٹخنا",
  "پٹخواؤں": "پٹخنا",
  "پٹخوائے": "پٹخنا",
  "پٹخوائی": "پٹخنا",
  "پٹخوائیے": "پٹخنا",
  "پٹخوائیں": "پٹخنا",
  "پٹخوایا": "پٹخنا",
  "پٹخی": "پٹخنا",
  "پٹخیے": "پٹخنا",
  "پٹخیں": "پٹخنا",
  "پٹں": "پٹنا",
  "پٹڑی": "پٹڑی",
  "پٹڑیاں": "پٹڑی",
  "پٹڑیو": "پٹڑی",
  "پٹڑیوں": "پٹڑی",
  "پٹا": "پٹا",
  "پٹاخے": "پٹاخہ",
  "پٹاخہ": "پٹاخہ",
  "پٹاخو": "پٹاخہ",
  "پٹاخوں": "پٹاخہ",
  "پٹانے": "پٹنا",
  "پٹانا": "پٹنا",
  "پٹاتے": "پٹنا",
  "پٹاتا": "پٹنا",
  "پٹاتی": "پٹنا",
  "پٹاتیں": "پٹنا",
  "پٹاؤ": "پٹنا",
  "پٹاؤں": "پٹنا",
  "پٹائے": "پٹنا",
  "پٹائی": "پٹنا",
  "پٹائیے": "پٹنا",
  "پٹائیں": "پٹنا",
  "پٹایا": "پٹنا",
  "پٹک": "پٹکنا",
  "پٹکے": "پٹکنا",
  "پٹکں": "پٹکنا",
  "پٹکا": "پٹکنا",
  "پٹکانے": "پٹکنا",
  "پٹکانا": "پٹکنا",
  "پٹکاتے": "پٹکنا",
  "پٹکاتا": "پٹکنا",
  "پٹکاتی": "پٹکنا",
  "پٹکاتیں": "پٹکنا",
  "پٹکاؤ": "پٹکنا",
  "پٹکاؤں": "پٹکنا",
  "پٹکائے": "پٹکنا",
  "پٹکائی": "پٹکنا",
  "پٹکائیے": "پٹکنا",
  "پٹکائیں": "پٹکنا",
  "پٹکایا": "پٹکنا",
  "پٹکنے": "پٹکنا",
  "پٹکنا": "پٹکنا",
  "پٹکنی": "پٹکنا",
  "پٹکتے": "پٹکنا",
  "پٹکتا": "پٹکنا",
  "پٹکتی": "پٹکنا",
  "پٹکتیں": "پٹکنا",
  "پٹکو": "پٹکنا",
  "پٹکوں": "پٹکنا",
  "پٹکوا": "پٹکنا",
  "پٹکوانے": "پٹکنا",
  "پٹکوانا": "پٹکنا",
  "پٹکواتے": "پٹکنا",
  "پٹکواتا": "پٹکنا",
  "پٹکواتی": "پٹکنا",
  "پٹکواتیں": "پٹکنا",
  "پٹکواؤ": "پٹکنا",
  "پٹکواؤں": "پٹکنا",
  "پٹکوائے": "پٹکنا",
  "پٹکوائی": "پٹکنا",
  "پٹکوائیے": "پٹکنا",
  "پٹکوائیں": "پٹکنا",
  "پٹکوایا": "پٹکنا",
  "پٹکی": "پٹکنا",
  "پٹکیے": "پٹکنا",
  "پٹکیں": "پٹکنا",
  "پٹنے": "پٹنہ",
  "پٹنا": "پٹنا",
  "پٹنہ": "پٹنہ",
  "پٹنو": "پٹنہ",
  "پٹنوں": "پٹنہ",
  "پٹنی": "پٹنا",
  "پٹری": "پٹری",
  "پٹریاں": "پٹری",
  "پٹریو": "پٹری",
  "پٹریوں": "پٹری",
  "پٹتے": "پٹنا",
  "پٹتا": "پٹنا",
  "پٹتی": "پٹنا",
  "پٹتیں": "پٹنا",
  "پٹو": "پٹا",
  "پٹوں": "پٹا",
  "پٹوا": "پٹنا",
  "پٹوانے": "پٹنا",
  "پٹوانا": "پٹنا",
  "پٹواتے": "پٹنا",
  "پٹواتا": "پٹنا",
  "پٹواتی": "پٹنا",
  "پٹواتیں": "پٹنا",
  "پٹواؤ": "پٹنا",
  "پٹواؤں": "پٹنا",
  "پٹوائے": "پٹنا",
  "پٹوائی": "پٹنا",
  "پٹوائیے": "پٹنا",
  "پٹوائیں": "پٹنا",
  "پٹوایا": "پٹنا",
  "پٹی": "پٹی",
  "پٹیے": "پٹنا",
  "پٹیں": "پٹنا",
  "پٹیاں": "پٹی",
  "پٹیو": "پٹی",
  "پٹیوں": "پٹی",
  "پٹھے": "پٹھا",
  "پٹھا": "پٹھا",
  "پٹھان": "پٹھان",
  "پٹھانو": "پٹھان",
  "پٹھانوں": "پٹھان",
  "پٹھو": "پٹھا",
  "پٹھوں": "پٹھا",
  "پشت": "پشت",
  "پشتے": "پشتہ",
  "پشتہ": "پشتہ",
  "پشتو": "پشتہ",
  "پشتوں": "پشتہ",
  "پشتون": "پشتون",
  "پشتونو": "پشتون",
  "پشتونوں": "پشتون",
  "پشتیں": "پشت",
  "پا": "پانا",
  "پاخانے": "پاخانہ",
  "پاخانہ": "پاخانہ",
  "پاخانو": "پاخانہ",
  "پاخانوں": "پاخانہ",
  "پاشی": "پاشی",
  "پاشیاں": "پاشی",
  "پاشیو": "پاشی",
  "پاشیوں": "پاشی",
  "پابندی": "پابندی",
  "پابندیاں": "پابندی",
  "پابندیو": "پابندی",
  "پابندیوں": "پابندی",
  "پادری": "پادری",
  "پادریو": "پادری",
  "پادریوں": "پادری",
  "پاگل": "پاگل",
  "پاگلو": "پاگل",
  "پاگلوں": "پاگل",
  "پاجامے": "پاجامہ",
  "پاجامہ": "پاجامہ",
  "پاجامو": "پاجامہ",
  "پاجاموں": "پاجامہ",
  "پاکِسْتان": "پاکِسْتان",
  "پاکستانی": "پاکستانی",
  "پاکستانیو": "پاکستانی",
  "پاکستانیوں": "پاکستانی",
  "پال": "پَلْنا",
  "پالے": "پَلْنا",
  "پالں": "پَلْنا",
  "پالا": "پَلْنا",
  "پالنے": "پَلْنا",
  "پالنا": "پَلْنا",
  "پالت": "پالت",
  "پالتے": "پَلْنا",
  "پالتا": "پَلْنا",
  "پالتو": "پالت",
  "پالتوں": "پالت",
  "پالتی": "پَلْنا",
  "پالتیں": "پالت",
  "پالو": "پَلْنا",
  "پالوں": "پَلْنا",
  "پالی": "پَلْنا",
  "پالیے": "پَلْنا",
  "پالیں": "پَلْنا",
  "پالیسی": "پالیسی",
  "پالیسیاں": "پالیسی",
  "پالیسیو": "پالیسی",
  "پالیسیوں": "پالیسی",
  "پان": "پان",
  "پانے": "پانا",
  "پانا": "پانا",
  "پانچ": "پانچ",
  "پانچو": "پانچ",
  "پانچوں": "پانچ",
  "پانچواں": "پانچواں",
  "پانچووںں": "پانچواں",
  "پانچویں": "پانچواں",
  "پانسے": "پانسہ",
  "پانسہ": "پانسہ",
  "پانسو": "پانسہ",
  "پانسوں": "پانسہ",
  "پانو": "پان",
  "پانوں": "پان",
  "پانی": "پانی",
  "پانیو": "پانی",
  "پانیوں": "پانی",
  "پارے": "پارا",
  "پارٹی": "پارٹی",
  "پارٹیاں": "پارٹی",
  "پارٹیو": "پارٹی",
  "پارٹیوں": "پارٹی",
  "پارا": "پارا",
  "پارہ": "پارہ",
  "پارک": "پارک",
  "پارکو": "پارک",
  "پارکوں": "پارک",
  "پارکیں": "پارک",
  "پارسی": "پارسی",
  "پارسیو": "پارسی",
  "پارسیوں": "پارسی",
  "پارو": "پارا",
  "پاروں": "پارا",
  "پاسے": "پاسہ",
  "پاسہ": "پاسہ",
  "پاسو": "پاسہ",
  "پاسوں": "پاسہ",
  "پات": "پات",
  "پاتے": "پانا",
  "پاتا": "پانا",
  "پاتو": "پات",
  "پاتوں": "پات",
  "پاتی": "پانا",
  "پاتیں": "پات",
  "پاؤ": "پانا",
  "پاؤں": "پانا",
  "پایے": "پایہ",
  "پائے": "پانا",
  "پائی": "پانا",
  "پائیے": "پانا",
  "پائیں": "پانا",
  "پائینچے": "پائینچہ",
  "پائینچہ": "پائینچہ",
  "پائینچو": "پائینچہ",
  "پائینچوں": "پائینچہ",
  "پایا": "پانا",
  "پایہ": "پایہ",
  "پایو": "پایہ",
  "پایوں": "پایہ",
  "پچکاری": "پچکاری",
  "پچکاریاں": "پچکاری",
  "پچکاریو": "پچکاری",
  "پچکاریوں": "پچکاری",
  "پچس": "پچس",
  "پچھا": "پوچھنا",
  "پچھانے": "پوچھنا",
  "پچھانا": "پوچھنا",
  "پچھاتے": "پوچھنا",
  "پچھاتا": "پوچھنا",
  "پچھاتی": "پوچھنا",
  "پچھاتیں": "پوچھنا",
  "پچھاؤ": "پوچھنا",
  "پچھاؤں": "پوچھنا",
  "پچھائے": "پوچھنا",
  "پچھائی": "پوچھنا",
  "پچھائیے": "پوچھنا",
  "پچھائیں": "پوچھنا",
  "پچھایا": "پوچھنا",
  "پچھل": "پچھل",
  "پچھلے": "پچھلا",
  "پچھلا": "پچھلا",
  "پچھلو": "پچھلا",
  "پچھلوں": "پچھلا",
  "پچھوا": "پوچھنا",
  "پچھوانے": "پوچھنا",
  "پچھوانا": "پوچھنا",
  "پچھواتے": "پوچھنا",
  "پچھواتا": "پوچھنا",
  "پچھواتی": "پوچھنا",
  "پچھواتیں": "پوچھنا",
  "پچھواؤ": "پوچھنا",
  "پچھواؤں": "پوچھنا",
  "پچھوائے": "پوچھنا",
  "پچھوائی": "پوچھنا",
  "پچھوائیے": "پوچھنا",
  "پچھوائیں": "پوچھنا",
  "پچھوایا": "پوچھنا",
  "پدے": "پدہ",
  "پدہ": "پدہ",
  "پدو": "پدہ",
  "پدوں": "پدہ",
  "پگڈنڈی": "پگڈنڈی",
  "پگڈنڈیاں": "پگڈنڈی",
  "پگڈنڈیو": "پگڈنڈی",
  "پگڈنڈیوں": "پگڈنڈی",
  "پگڑی": "پگڑی",
  "پگڑیاں": "پگڑی",
  "پگڑیو": "پگڑی",
  "پگڑیوں": "پگڑی",
  "پہاڑ": "پہاڑ",
  "پہاڑے": "پہاڑا",
  "پہاڑا": "پہاڑا",
  "پہاڑہ": "پہاڑہ",
  "پہاڑو": "پہاڑا",
  "پہاڑوں": "پہاڑا",
  "پہاڑی": "پہاڑی",
  "پہاڑیاں": "پہاڑی",
  "پہاڑیو": "پہاڑی",
  "پہاڑیوں": "پہاڑی",
  "پہچ": "پہچنا",
  "پہچے": "پہچنا",
  "پہچں": "پہچنا",
  "پہچا": "پہچنا",
  "پہچان": "پہچان",
  "پہچانے": "پہچاننا",
  "پہچانں": "پہچاننا",
  "پہچانا": "پہچاننا",
  "پہچاننے": "پہچاننا",
  "پہچاننا": "پہچاننا",
  "پہچاننی": "پہچاننا",
  "پہچانتے": "پہچاننا",
  "پہچانتا": "پہچاننا",
  "پہچانتی": "پہچاننا",
  "پہچانتیں": "پہچاننا",
  "پہچانو": "پہچان",
  "پہچانوں": "پہچان",
  "پہچانی": "پہچاننا",
  "پہچانیے": "پہچاننا",
  "پہچانیں": "پہچان",
  "پہچاتے": "پہچنا",
  "پہچاتا": "پہچنا",
  "پہچاتی": "پہچنا",
  "پہچاتیں": "پہچنا",
  "پہچاؤ": "پہچنا",
  "پہچاؤں": "پہچنا",
  "پہچائے": "پہچنا",
  "پہچائی": "پہچنا",
  "پہچائیے": "پہچنا",
  "پہچائیں": "پہچنا",
  "پہچایا": "پہچنا",
  "پہچنے": "پہچنا",
  "پہچنا": "پہچنا",
  "پہچنی": "پہچنا",
  "پہچتے": "پہچنا",
  "پہچتا": "پہچنا",
  "پہچتی": "پہچنا",
  "پہچتیں": "پہچنا",
  "پہچو": "پہچنا",
  "پہچوں": "پہچنا",
  "پہچوا": "پہچنا",
  "پہچوانے": "پہچنا",
  "پہچوانا": "پہچنا",
  "پہچواتے": "پہچنا",
  "پہچواتا": "پہچنا",
  "پہچواتی": "پہچنا",
  "پہچواتیں": "پہچنا",
  "پہچواؤ": "پہچنا",
  "پہچواؤں": "پہچنا",
  "پہچوائے": "پہچنا",
  "پہچوائی": "پہچنا",
  "پہچوائیے": "پہچنا",
  "پہچوائیں": "پہچنا",
  "پہچوایا": "پہچنا",
  "پہچی": "پہچنا",
  "پہچیے": "پہچنا",
  "پہچیں": "پہچنا",
  "پہل": "پہل",
  "پہلے": "پہلا",
  "پہلا": "پہلا",
  "پہلہ": "پہلہ",
  "پہلو": "پہلا",
  "پہلوں": "پہلا",
  "پہلواں": "پہلواں",
  "پہلوان": "پہلوان",
  "پہلوانو": "پہلوان",
  "پہلوانوں": "پہلوان",
  "پہلووںں": "پہلواں",
  "پہلوؤ": "پہلو",
  "پہلوؤں": "پہلو",
  "پہلویں": "پہلواں",
  "پہن": "پہننا",
  "پہنے": "پہننا",
  "پہنں": "پہننا",
  "پہنا": "پہننا",
  "پہنانے": "پہننا",
  "پہنانا": "پہننا",
  "پہناتے": "پہننا",
  "پہناتا": "پہننا",
  "پہناتی": "پہننا",
  "پہناتیں": "پہننا",
  "پہناؤ": "پہننا",
  "پہناؤں": "پہننا",
  "پہنائے": "پہننا",
  "پہنائی": "پہنائی",
  "پہنائیے": "پہننا",
  "پہنائیں": "پہننا",
  "پہنائیاں": "پہنائی",
  "پہنائیو": "پہنائی",
  "پہنائیوں": "پہنائی",
  "پہنایا": "پہننا",
  "پہنچ": "پہنچنا",
  "پہنچے": "پہنچنا",
  "پہنچں": "پہنچنا",
  "پہنچا": "پہنچنا",
  "پہنچان": "پہنچنا",
  "پہنچانے": "پہنچنا",
  "پہنچانں": "پہنچنا",
  "پہنچانا": "پہنچنا",
  "پہنچاننے": "پہنچنا",
  "پہنچاننا": "پہنچنا",
  "پہنچانتے": "پہنچنا",
  "پہنچانتا": "پہنچنا",
  "پہنچانتی": "پہنچنا",
  "پہنچانتیں": "پہنچنا",
  "پہنچانو": "پہنچنا",
  "پہنچانوں": "پہنچنا",
  "پہنچانی": "پہنچنا",
  "پہنچانیے": "پہنچنا",
  "پہنچانیں": "پہنچنا",
  "پہنچاتے": "پہنچنا",
  "پہنچاتا": "پہنچنا",
  "پہنچاتی": "پہنچنا",
  "پہنچاتیں": "پہنچنا",
  "پہنچاؤ": "پہنچنا",
  "پہنچاؤں": "پہنچنا",
  "پہنچائے": "پہنچنا",
  "پہنچائی": "پہنچنا",
  "پہنچائیے": "پہنچنا",
  "پہنچائیں": "پہنچنا",
  "پہنچایا": "پہنچنا",
  "پہنچنے": "پہنچنا",
  "پہنچنا": "پہنچنا",
  "پہنچنی": "پہنچنا",
  "پہنچت": "پہنچت",
  "پہنچتے": "پہنچنا",
  "پہنچتا": "پہنچنا",
  "پہنچتو": "پہنچت",
  "پہنچتوں": "پہنچت",
  "پہنچتی": "پہنچنا",
  "پہنچتیں": "پہنچت",
  "پہنچو": "پہنچنا",
  "پہنچوں": "پہنچنا",
  "پہنچوا": "پہنچنا",
  "پہنچوان": "پہنچنا",
  "پہنچوانے": "پہنچنا",
  "پہنچوانں": "پہنچنا",
  "پہنچوانا": "پہنچنا",
  "پہنچواننے": "پہنچنا",
  "پہنچواننا": "پہنچنا",
  "پہنچوانتے": "پہنچنا",
  "پہنچوانتا": "پہنچنا",
  "پہنچوانتی": "پہنچنا",
  "پہنچوانتیں": "پہنچنا",
  "پہنچوانو": "پہنچنا",
  "پہنچوانوں": "پہنچنا",
  "پہنچوانی": "پہنچنا",
  "پہنچوانیے": "پہنچنا",
  "پہنچوانیں": "پہنچنا",
  "پہنچواتے": "پہنچنا",
  "پہنچواتا": "پہنچنا",
  "پہنچواتی": "پہنچنا",
  "پہنچواتیں": "پہنچنا",
  "پہنچواؤ": "پہنچنا",
  "پہنچواؤں": "پہنچنا",
  "پہنچوائے": "پہنچنا",
  "پہنچوائی": "پہنچنا",
  "پہنچوائیے": "پہنچنا",
  "پہنچوائیں": "پہنچنا",
  "پہنچوایا": "پہنچنا",
  "پہنچی": "پہنچنا",
  "پہنچیے": "پہنچنا",
  "پہنچیں": "پہنچنا",
  "پہننے": "پہننا",
  "پہننا": "پہننا",
  "پہننی": "پہننا",
  "پہنت": "پہنت",
  "پہنتے": "پہننا",
  "پہنتا": "پہننا",
  "پہنتو": "پہنت",
  "پہنتوں": "پہنت",
  "پہنتی": "پہننا",
  "پہنتیں": "پہنت",
  "پہنو": "پہننا",
  "پہنوں": "پہننا",
  "پہنوا": "پہننا",
  "پہنوانے": "پہننا",
  "پہنوانا": "پہننا",
  "پہنواتے": "پہننا",
  "پہنواتا": "پہننا",
  "پہنواتی": "پہننا",
  "پہنواتیں": "پہننا",
  "پہنواؤ": "پہننا",
  "پہنواؤں": "پہننا",
  "پہنوائے": "پہننا",
  "پہنوائی": "پہننا",
  "پہنوائیے": "پہننا",
  "پہنوائیں": "پہننا",
  "پہنوایا": "پہننا",
  "پہنی": "پہننا",
  "پہنیے": "پہننا",
  "پہنیں": "پہننا",
  "پہر": "پہر",
  "پہرے": "پہرا",
  "پہرا": "پہرا",
  "پہرہ": "پہرہ",
  "پہرو": "پہرا",
  "پہروں": "پہرا",
  "پہریں": "پہر",
  "پہیے": "پہیہ",
  "پہیہ": "پہیہ",
  "پہیو": "پہیہ",
  "پہیوں": "پہیہ",
  "پجا": "پوجنا",
  "پجانے": "پوجنا",
  "پجانا": "پوجنا",
  "پجاری": "پجاری",
  "پجاریو": "پجاری",
  "پجاریوں": "پجاری",
  "پجاتے": "پوجنا",
  "پجاتا": "پوجنا",
  "پجاتی": "پوجنا",
  "پجاتیں": "پوجنا",
  "پجاؤ": "پوجنا",
  "پجاؤں": "پوجنا",
  "پجائے": "پوجنا",
  "پجائی": "پوجنا",
  "پجائیے": "پوجنا",
  "پجائیں": "پوجنا",
  "پجایا": "پوجنا",
  "پجوا": "پوجنا",
  "پجوانے": "پوجنا",
  "پجوانا": "پوجنا",
  "پجواتے": "پوجنا",
  "پجواتا": "پوجنا",
  "پجواتی": "پوجنا",
  "پجواتیں": "پوجنا",
  "پجواؤ": "پوجنا",
  "پجواؤں": "پوجنا",
  "پجوائے": "پوجنا",
  "پجوائی": "پوجنا",
  "پجوائیے": "پوجنا",
  "پجوائیں": "پوجنا",
  "پجوایا": "پوجنا",
  "پک": "پکنا",
  "پکے": "پکنا",
  "پکں": "پکنا",
  "پکڑ": "پکڑنا",
  "پکڑے": "پکڑنا",
  "پکڑں": "پکڑنا",
  "پکڑا": "پکڑنا",
  "پکڑانے": "پکڑنا",
  "پکڑانا": "پکڑنا",
  "پکڑاتے": "پکڑنا",
  "پکڑاتا": "پکڑنا",
  "پکڑاتی": "پکڑنا",
  "پکڑاتیں": "پکڑنا",
  "پکڑاؤ": "پکڑنا",
  "پکڑاؤں": "پکڑنا",
  "پکڑائے": "پکڑنا",
  "پکڑائی": "پکڑنا",
  "پکڑائیے": "پکڑنا",
  "پکڑائیں": "پکڑنا",
  "پکڑایا": "پکڑنا",
  "پکڑنے": "پکڑنا",
  "پکڑنا": "پکڑنا",
  "پکڑنی": "پکڑنا",
  "پکڑتے": "پکڑنا",
  "پکڑتا": "پکڑنا",
  "پکڑتی": "پکڑنا",
  "پکڑتیں": "پکڑنا",
  "پکڑو": "پکڑنا",
  "پکڑوں": "پکڑنا",
  "پکڑوا": "پکڑنا",
  "پکڑوانے": "پکڑنا",
  "پکڑوانا": "پکڑنا",
  "پکڑواتے": "پکڑنا",
  "پکڑواتا": "پکڑنا",
  "پکڑواتی": "پکڑنا",
  "پکڑواتیں": "پکڑنا",
  "پکڑواؤ": "پکڑنا",
  "پکڑواؤں": "پکڑنا",
  "پکڑوائے": "پکڑنا",
  "پکڑوائی": "پکڑنا",
  "پکڑوائیے": "پکڑنا",
  "پکڑوائیں": "پکڑنا",
  "پکڑوایا": "پکڑنا",
  "پکڑی": "پکڑنا",
  "پکڑیے": "پکڑنا",
  "پکڑیں": "پکڑنا",
  "پکا": "پکنا",
  "پکانے": "پکنا",
  "پکانا": "پکنا",
  "پکار": "پکار",
  "پکارے": "پکارنا",
  "پکارں": "پکارنا",
  "پکارا": "پکارنا",
  "پکارنے": "پکارنا",
  "پکارنا": "پکارنا",
  "پکارنی": "پکارنا",
  "پکارتے": "پکارنا",
  "پکارتا": "پکارنا",
  "پکارتی": "پکارنا",
  "پکارتیں": "پکارنا",
  "پکارو": "پکار",
  "پکاروں": "پکار",
  "پکاری": "پکارنا",
  "پکاریے": "پکارنا",
  "پکاریں": "پکار",
  "پکاتے": "پکنا",
  "پکاتا": "پکنا",
  "پکاتی": "پکنا",
  "پکاتیں": "پکنا",
  "پکاؤ": "پکنا",
  "پکاؤں": "پکنا",
  "پکائے": "پکنا",
  "پکائی": "پکنا",
  "پکائیے": "پکنا",
  "پکائیں": "پکنا",
  "پکایا": "پکنا",
  "پکنے": "پکنا",
  "پکنا": "پکنا",
  "پکنی": "پکنا",
  "پکتے": "پکنا",
  "پکتا": "پکنا",
  "پکتی": "پکنا",
  "پکتیں": "پکنا",
  "پکو": "پکنا",
  "پکوں": "پکنا",
  "پکوڑے": "پکوڑہ",
  "پکوڑہ": "پکوڑہ",
  "پکوڑو": "پکوڑہ",
  "پکوڑوں": "پکوڑہ",
  "پکوا": "پکنا",
  "پکوانے": "پکنا",
  "پکوانا": "پکنا",
  "پکواتے": "پکنا",
  "پکواتا": "پکنا",
  "پکواتی": "پکنا",
  "پکواتیں": "پکنا",
  "پکواؤ": "پکنا",
  "پکواؤں": "پکنا",
  "پکوائے": "پکنا",
  "پکوائی": "پکنا",
  "پکوائیے": "پکنا",
  "پکوائیں": "پکنا",
  "پکوایا": "پکنا",
  "پکی": "پکنا",
  "پکیے": "پکنا",
  "پکیں": "پکنا",
  "پل": "پل",
  "پلّے": "پلّہ",
  "پلّہ": "پلّہ",
  "پلّو": "پلّہ",
  "پلّوں": "پلّہ",
  "پلے": "پلہ",
  "پلں": "پلنا",
  "پلڑے": "پلڑا",
  "پلڑا": "پلڑا",
  "پلڑہ": "پلڑہ",
  "پلڑو": "پلڑا",
  "پلڑوں": "پلڑا",
  "پلٹ": "پلٹنا",
  "پلٹے": "پلٹنا",
  "پلٹں": "پلٹنا",
  "پلٹا": "پلٹنا",
  "پلٹانے": "پلٹنا",
  "پلٹانا": "پلٹنا",
  "پلٹاتے": "پلٹنا",
  "پلٹاتا": "پلٹنا",
  "پلٹاتی": "پلٹنا",
  "پلٹاتیں": "پلٹنا",
  "پلٹاؤ": "پلٹنا",
  "پلٹاؤں": "پلٹنا",
  "پلٹائے": "پلٹنا",
  "پلٹائی": "پلٹنا",
  "پلٹائیے": "پلٹنا",
  "پلٹائیں": "پلٹنا",
  "پلٹایا": "پلٹنا",
  "پلٹنے": "پلٹنا",
  "پلٹنا": "پلٹنا",
  "پلٹنی": "پلٹنا",
  "پلٹتے": "پلٹنا",
  "پلٹتا": "پلٹنا",
  "پلٹتی": "پلٹنا",
  "پلٹتیں": "پلٹنا",
  "پلٹو": "پلٹنا",
  "پلٹوں": "پلٹنا",
  "پلٹوا": "پلٹنا",
  "پلٹوانے": "پلٹنا",
  "پلٹوانا": "پلٹنا",
  "پلٹواتے": "پلٹنا",
  "پلٹواتا": "پلٹنا",
  "پلٹواتی": "پلٹنا",
  "پلٹواتیں": "پلٹنا",
  "پلٹواؤ": "پلٹنا",
  "پلٹواؤں": "پلٹنا",
  "پلٹوائے": "پلٹنا",
  "پلٹوائی": "پلٹنا",
  "پلٹوائیے": "پلٹنا",
  "پلٹوائیں": "پلٹنا",
  "پلٹوایا": "پلٹنا",
  "پلٹی": "پلٹنا",
  "پلٹیے": "پلٹنا",
  "پلٹیں": "پلٹنا",
  "پلا": "پلنا",
  "پلانے": "پلنا",
  "پلانا": "پلنا",
  "پلاتے": "پلنا",
  "پلاتا": "پلنا",
  "پلاتی": "پلنا",
  "پلاتیں": "پلنا",
  "پلاؤ": "پلنا",
  "پلاؤں": "پلنا",
  "پلائے": "پلنا",
  "پلائی": "پلائی",
  "پلائیے": "پلنا",
  "پلائیں": "پلنا",
  "پلائیو": "پلائی",
  "پلائیوں": "پلائی",
  "پلایا": "پلنا",
  "پلازے": "پلازہ",
  "پلازہ": "پلازہ",
  "پلازو": "پلازہ",
  "پلازوں": "پلازہ",
  "پلہ": "پلہ",
  "پلک": "پلک",
  "پلکو": "پلک",
  "پلکوں": "پلک",
  "پلکیں": "پلک",
  "پلنے": "پلنا",
  "پلنا": "پلنا",
  "پلندے": "پلندہ",
  "پلندہ": "پلندہ",
  "پلندو": "پلندہ",
  "پلندوں": "پلندہ",
  "پلنگ": "پلنگ",
  "پلنگو": "پلنگ",
  "پلنگوں": "پلنگ",
  "پلنی": "پلنا",
  "پلتے": "پلنا",
  "پلتا": "پلنا",
  "پلتی": "پلنا",
  "پلتیں": "پلنا",
  "پلو": "پلہ",
  "پلوں": "پلہ",
  "پلوا": "پلنا",
  "پلوانے": "پلنا",
  "پلوانا": "پلنا",
  "پلواتے": "پلنا",
  "پلواتا": "پلنا",
  "پلواتی": "پلنا",
  "پلواتیں": "پلنا",
  "پلواؤ": "پلنا",
  "پلواؤں": "پلنا",
  "پلوائے": "پلنا",
  "پلوائی": "پلنا",
  "پلوائیے": "پلنا",
  "پلوائیں": "پلنا",
  "پلوایا": "پلنا",
  "پلی": "پلی",
  "پلیے": "پلنا",
  "پلیں": "پلنا",
  "پلیٹ": "پلیٹ",
  "پلیٹو": "پلیٹ",
  "پلیٹوں": "پلیٹ",
  "پلیٹیں": "پلیٹ",
  "پلیاں": "پلی",
  "پلیو": "پلی",
  "پلیوں": "پلی",
  "پمپ": "پمپ",
  "پمپو": "پمپ",
  "پمپوں": "پمپ",
  "پن": "پن",
  "پنڈلی": "پنڈلی",
  "پنڈلیاں": "پنڈلی",
  "پنڈلیو": "پنڈلی",
  "پنڈلیوں": "پنڈلی",
  "پنڈت": "پنڈت",
  "پنڈتو": "پنڈت",
  "پنڈتوں": "پنڈت",
  "پنڈتیں": "پنڈت",
  "پندرہ": "پندرہ",
  "پنگھوڑے": "پنگھوڑا",
  "پنگھوڑا": "پنگھوڑا",
  "پنگھوڑو": "پنگھوڑا",
  "پنگھوڑوں": "پنگھوڑا",
  "پنج": "پنج",
  "پنجے": "پنجا",
  "پنجا": "پنجا",
  "پنجاب": "پنجاب",
  "پنجابو": "پنجاب",
  "پنجابوں": "پنجاب",
  "پنجہ": "پنجہ",
  "پنجرے": "پنجرہ",
  "پنجرہ": "پنجرہ",
  "پنجرو": "پنجرہ",
  "پنجروں": "پنجرہ",
  "پنجو": "پنجا",
  "پنجوں": "پنجا",
  "پنکھے": "پنکھا",
  "پنکھا": "پنکھا",
  "پنکھو": "پنکھا",
  "پنکھوں": "پنکھا",
  "پنکھی": "پنکھی",
  "پنکھیا": "پنکھیا",
  "پنکھیاں": "پنکھی",
  "پنکھیو": "پنکھی",
  "پنکھیوں": "پنکھی",
  "پنپ": "پنپنا",
  "پنپے": "پنپنا",
  "پنپں": "پنپنا",
  "پنپا": "پنپنا",
  "پنپنے": "پنپنا",
  "پنپنا": "پنپنا",
  "پنپنی": "پنپنا",
  "پنپتے": "پنپنا",
  "پنپتا": "پنپنا",
  "پنپتی": "پنپنا",
  "پنپتیں": "پنپنا",
  "پنپو": "پنپنا",
  "پنپوں": "پنپنا",
  "پنپی": "پنپنا",
  "پنپیے": "پنپنا",
  "پنپیں": "پنپنا",
  "پنساری": "پنساری",
  "پنساریو": "پنساری",
  "پنساریوں": "پنساری",
  "پنسل": "پنسل",
  "پنسلو": "پنسل",
  "پنسلوں": "پنسل",
  "پنسلیں": "پنسل",
  "پنو": "پن",
  "پنوں": "پن",
  "پنیں": "پن",
  "پپوٹے": "پپوٹا",
  "پپوٹا": "پپوٹا",
  "پپوٹو": "پپوٹا",
  "پپوٹوں": "پپوٹا",
  "پر": "پرنا",
  "پرے": "پرنا",
  "پرں": "پرنا",
  "پرا": "پرنا",
  "پراٹھے": "پراٹھا",
  "پراٹھا": "پراٹھا",
  "پراٹھو": "پراٹھا",
  "پراٹھوں": "پراٹھا",
  "پرانے": "پرانا",
  "پرانا": "پرانا",
  "پرانو": "پرانا",
  "پرانوں": "پرانا",
  "پراپوزیشن": "پراپوزیشن",
  "پراپوزیشنو": "پراپوزیشن",
  "پراپوزیشنوں": "پراپوزیشن",
  "پراپوزیشنیں": "پراپوزیشن",
  "پرچ": "پرچ",
  "پرچے": "پرچہ",
  "پرچہ": "پرچہ",
  "پرچم": "پرچم",
  "پرچمو": "پرچم",
  "پرچموں": "پرچم",
  "پرچو": "پرچہ",
  "پرچوں": "پرچہ",
  "پرچیں": "پرچ",
  "پردے": "پردہ",
  "پرداز": "پرداز",
  "پردازو": "پرداز",
  "پردازوں": "پرداز",
  "پردہ": "پردہ",
  "پردو": "پردہ",
  "پردوں": "پردہ",
  "پرگرام": "پرگرام",
  "پرگرامو": "پرگرام",
  "پرگراموں": "پرگرام",
  "پرہیزگار": "پرہیزگار",
  "پرہیزگارو": "پرہیزگار",
  "پرہیزگاروں": "پرہیزگار",
  "پرکھ": "پرکھنا",
  "پرکھے": "پرکھنا",
  "پرکھں": "پرکھنا",
  "پرکھا": "پرکھنا",
  "پرکھانے": "پرکھنا",
  "پرکھانا": "پرکھنا",
  "پرکھاتے": "پرکھنا",
  "پرکھاتا": "پرکھنا",
  "پرکھاتی": "پرکھنا",
  "پرکھاتیں": "پرکھنا",
  "پرکھاؤ": "پرکھنا",
  "پرکھاؤں": "پرکھنا",
  "پرکھائے": "پرکھنا",
  "پرکھائی": "پرکھنا",
  "پرکھائیے": "پرکھنا",
  "پرکھائیں": "پرکھنا",
  "پرکھایا": "پرکھنا",
  "پرکھنے": "پرکھنا",
  "پرکھنا": "پرکھنا",
  "پرکھنی": "پرکھنا",
  "پرکھتے": "پرکھنا",
  "پرکھتا": "پرکھنا",
  "پرکھتی": "پرکھنا",
  "پرکھتیں": "پرکھنا",
  "پرکھو": "پرکھنا",
  "پرکھوں": "پرکھنا",
  "پرکھوا": "پرکھنا",
  "پرکھوانے": "پرکھنا",
  "پرکھوانا": "پرکھنا",
  "پرکھواتے": "پرکھنا",
  "پرکھواتا": "پرکھنا",
  "پرکھواتی": "پرکھنا",
  "پرکھواتیں": "پرکھنا",
  "پرکھواؤ": "پرکھنا",
  "پرکھواؤں": "پرکھنا",
  "پرکھوائے": "پرکھنا",
  "پرکھوائی": "پرکھنا",
  "پرکھوائیے": "پرکھنا",
  "پرکھوائیں": "پرکھنا",
  "پرکھوایا": "پرکھنا",
  "پرکھی": "پرکھنا",
  "پرکھیے": "پرکھنا",
  "پرکھیں": "پرکھنا",
  "پرلوگ": "پرلوگ",
  "پرلوگو": "پرلوگ",
  "پرلوگوں": "پرلوگ",
  "پرنے": "پرنہ",
  "پرنا": "پرنا",
  "پرنالے": "پرنالہ",
  "پرنالہ": "پرنالہ",
  "پرنالو": "پرنالہ",
  "پرنالوں": "پرنالہ",
  "پرند": "پرند",
  "پرندے": "پرندہ",
  "پرندہ": "پرندہ",
  "پرندو": "پرندہ",
  "پرندوں": "پرندہ",
  "پرنہ": "پرنہ",
  "پرنو": "پرنہ",
  "پرنوں": "پرنہ",
  "پرنی": "پرنا",
  "پرس": "پرس",
  "پرسے": "پرسا",
  "پرسا": "پرسا",
  "پرست": "پرست",
  "پرستار": "پرستار",
  "پرستارو": "پرستار",
  "پرستاروں": "پرستار",
  "پرستو": "پرست",
  "پرستوں": "پرست",
  "پرستیں": "پرست",
  "پرسو": "پرسا",
  "پرسوں": "پرسا",
  "پرت": "پرت",
  "پرتے": "پرنا",
  "پرتا": "پرنا",
  "پرتو": "پرت",
  "پرتوں": "پرت",
  "پرتی": "پرنا",
  "پرتیں": "پرت",
  "پرو": "پرنا",
  "پروں": "پرنا",
  "پروان": "پروان",
  "پروانے": "پروانہ",
  "پروانہ": "پروانہ",
  "پروانو": "پروانہ",
  "پروانوں": "پروانہ",
  "پرواز": "پرواز",
  "پروازو": "پرواز",
  "پروازوں": "پرواز",
  "پروازیں": "پرواز",
  "پروفسر": "پروفسر",
  "پروفسرو": "پروفسر",
  "پروفسروں": "پروفسر",
  "پروفسریں": "پروفسر",
  "پروفیسر": "پروفیسر",
  "پروفیسرو": "پروفیسر",
  "پروفیسروں": "پروفیسر",
  "پروگرام": "پروگرام",
  "پروگرامو": "پروگرام",
  "پروگراموں": "پروگرام",
  "پرونے": "پرونا",
  "پرونا": "پرونا",
  "پرونی": "پرونا",
  "پروپیگنڈے": "پروپیگنڈہ",
  "پروپیگنڈہ": "پروپیگنڈہ",
  "پروپیگنڈو": "پروپیگنڈہ",
  "پروپیگنڈوں": "پروپیگنڈہ",
  "پروتے": "پرونا",
  "پروتا": "پرونا",
  "پروتی": "پرونا",
  "پروتیں": "پرونا",
  "پروؤ": "پرونا",
  "پروؤں": "پرونا",
  "پروئے": "پرونا",
  "پروئی": "پرونا",
  "پروئیے": "پرونا",
  "پروئیں": "پرونا",
  "پرویا": "پرونا",
  "پری": "پری",
  "پریے": "پرنا",
  "پریں": "پرنا",
  "پریشانی": "پریشانی",
  "پریشانیاں": "پریشانی",
  "پریشانیو": "پریشانی",
  "پریشانیوں": "پریشانی",
  "پریاں": "پری",
  "پریمی": "پریمی",
  "پریمیو": "پریمی",
  "پریمیوں": "پریمی",
  "پریو": "پری",
  "پریوں": "پری",
  "پرزے": "پرزہ",
  "پرزہ": "پرزہ",
  "پرزو": "پرزہ",
  "پرزوں": "پرزہ",
  "پسا": "پیسنا",
  "پسانے": "پیسنا",
  "پسانا": "پیسنا",
  "پسار": "پسارنا",
  "پسارے": "پسارنا",
  "پسارں": "پسارنا",
  "پسارا": "پسارنا",
  "پسارنے": "پسارنا",
  "پسارنا": "پسارنا",
  "پسارنی": "پسارنا",
  "پسارتے": "پسارنا",
  "پسارتا": "پسارنا",
  "پسارتی": "پسارنا",
  "پسارتیں": "پسارنا",
  "پسارو": "پسارنا",
  "پساروں": "پسارنا",
  "پساری": "پسارنا",
  "پساریے": "پسارنا",
  "پساریں": "پسارنا",
  "پساتے": "پیسنا",
  "پساتا": "پیسنا",
  "پساتی": "پیسنا",
  "پساتیں": "پیسنا",
  "پساؤ": "پیسنا",
  "پساؤں": "پیسنا",
  "پسائے": "پیسنا",
  "پسائی": "پیسنا",
  "پسائیے": "پیسنا",
  "پسائیں": "پیسنا",
  "پسایا": "پیسنا",
  "پسلی": "پسلی",
  "پسلیاں": "پسلی",
  "پسلیو": "پسلی",
  "پسلیوں": "پسلی",
  "پسنے": "پسنہ",
  "پسنہ": "پسنہ",
  "پسنو": "پسنہ",
  "پسنوں": "پسنہ",
  "پستے": "پستہ",
  "پستان": "پستان",
  "پستانو": "پستان",
  "پستانوں": "پستان",
  "پستہ": "پستہ",
  "پستو": "پستہ",
  "پستوں": "پستہ",
  "پسوا": "پیسنا",
  "پسوانے": "پیسنا",
  "پسوانا": "پیسنا",
  "پسواتے": "پیسنا",
  "پسواتا": "پیسنا",
  "پسواتی": "پیسنا",
  "پسواتیں": "پیسنا",
  "پسواؤ": "پیسنا",
  "پسواؤں": "پیسنا",
  "پسوائے": "پیسنا",
  "پسوائی": "پیسنا",
  "پسوائیے": "پیسنا",
  "پسوائیں": "پیسنا",
  "پسوایا": "پیسنا",
  "پسینے": "پسینہ",
  "پسینہ": "پسینہ",
  "پسینو": "پسینہ",
  "پسینوں": "پسینہ",
  "پت": "پت",
  "پتّے": "پتّا",
  "پتّا": "پتّا",
  "پتّل": "پتّل",
  "پتّلو": "پتّل",
  "پتّلوں": "پتّل",
  "پتّو": "پتّا",
  "پتّوں": "پتّا",
  "پتّی": "پتّی",
  "پتّیاں": "پتّی",
  "پتّیو": "پتّی",
  "پتّیوں": "پتّی",
  "پتے": "پتا",
  "پتا": "پتا",
  "پتہ": "پتہ",
  "پتل": "پتل",
  "پتلے": "پتلا",
  "پتلا": "پتلا",
  "پتلو": "پتلا",
  "پتلوں": "پتلا",
  "پتلی": "پتلی",
  "پتلیاں": "پتلی",
  "پتلیو": "پتلی",
  "پتلیوں": "پتلی",
  "پتنگ": "پتنگ",
  "پتنگو": "پتنگ",
  "پتنگوں": "پتنگ",
  "پتنگیں": "پتنگ",
  "پتر": "پتر",
  "پترو": "پتر",
  "پتروں": "پتر",
  "پتو": "پتا",
  "پتوں": "پتا",
  "پتی": "پتی",
  "پتیں": "پت",
  "پتیاں": "پتی",
  "پتیلی": "پتیلی",
  "پتیلیاں": "پتیلی",
  "پتیلیو": "پتیلی",
  "پتیلیوں": "پتیلی",
  "پتیو": "پتی",
  "پتیوں": "پتی",
  "پتھّر": "پتھّر",
  "پتھّرو": "پتھّر",
  "پتھّروں": "پتھّر",
  "پتھر": "پتھر",
  "پتھراؤ": "پتھراؤ",
  "پتھرو": "پتھر",
  "پتھروں": "پتھر",
  "پتھری": "پتھری",
  "پتھریاں": "پتھری",
  "پتھریو": "پتھری",
  "پتھریوں": "پتھری",
  "پوٹلی": "پوٹلی",
  "پوٹلیاں": "پوٹلی",
  "پوٹلیو": "پوٹلی",
  "پوٹلیوں": "پوٹلی",
  "پوچھ": "پوچھنا",
  "پوچھے": "پوچھنا",
  "پوچھں": "پوچھنا",
  "پوچھا": "پوچھنا",
  "پوچھنے": "پوچھنا",
  "پوچھنا": "پوچھنا",
  "پوچھنی": "پوچھنا",
  "پوچھتے": "پوچھنا",
  "پوچھتا": "پوچھنا",
  "پوچھتی": "پوچھنا",
  "پوچھتیں": "پوچھنا",
  "پوچھو": "پوچھنا",
  "پوچھوں": "پوچھنا",
  "پوچھی": "پوچھنا",
  "پوچھیے": "پوچھنا",
  "پوچھیں": "پوچھنا",
  "پود": "پود",
  "پودے": "پودا",
  "پودا": "پودا",
  "پودو": "پودا",
  "پودوں": "پودا",
  "پودیں": "پود",
  "پوج": "پوجنا",
  "پوجے": "پوجا",
  "پوجں": "پوجنا",
  "پوجا": "پوجا",
  "پوجنے": "پوجنا",
  "پوجنا": "پوجنا",
  "پوجنی": "پوجنا",
  "پوجتے": "پوجنا",
  "پوجتا": "پوجنا",
  "پوجتی": "پوجنا",
  "پوجتیں": "پوجنا",
  "پوجو": "پوجا",
  "پوجوں": "پوجا",
  "پوجی": "پوجنا",
  "پوجیے": "پوجنا",
  "پوجیں": "پوجنا",
  "پول": "پول",
  "پولے": "پولا",
  "پولا": "پولا",
  "پولو": "پولا",
  "پولوں": "پولا",
  "پولین": "پولین",
  "پولینو": "پولین",
  "پولینوں": "پولین",
  "پور": "پور",
  "پورے": "پورا",
  "پورا": "پورا",
  "پورہ": "پورہ",
  "پورو": "پورا",
  "پوروں": "پورا",
  "پوری": "پوری",
  "پوریں": "پور",
  "پوریاں": "پوری",
  "پوریو": "پوری",
  "پوریوں": "پوری",
  "پوسٹ": "پوسٹ",
  "پوسٹو": "پوسٹ",
  "پوسٹوں": "پوسٹ",
  "پوسٹیں": "پوسٹ",
  "پوست": "پوست",
  "پوستو": "پوست",
  "پوستوں": "پوست",
  "پوستیں": "پوست",
  "پوت": "پوت",
  "پوتے": "پوتا",
  "پوتا": "پوتا",
  "پوتو": "پوتا",
  "پوتوں": "پوتا",
  "پوتی": "پوتی",
  "پوتیں": "پوت",
  "پوتیاں": "پوتی",
  "پوتیو": "پوتی",
  "پوتیوں": "پوتی",
  "پی": "پینا",
  "پیے": "پیش",
  "پیغمبر": "پیغمبر",
  "پیغمبرو": "پیغمبر",
  "پیغمبروں": "پیغمبر",
  "پیں": "پینا",
  "پیڑ": "پیڑ",
  "پیڑے": "پیڑا",
  "پیڑا": "پیڑا",
  "پیڑو": "پیڑا",
  "پیڑوں": "پیڑا",
  "پیڑھی": "پیڑھی",
  "پیڑھیاں": "پیڑھی",
  "پیڑھیو": "پیڑھی",
  "پیڑھیوں": "پیڑھی",
  "پیٹ": "پیٹ",
  "پیٹے": "پِٹنا",
  "پیٹں": "پِٹنا",
  "پیٹا": "پِٹنا",
  "پیٹن": "پیٹننا",
  "پیٹنے": "پِٹنا",
  "پیٹنں": "پیٹننا",
  "پیٹنا": "پِٹنا",
  "پیٹنانے": "پیٹننا",
  "پیٹنانا": "پیٹننا",
  "پیٹناتے": "پیٹننا",
  "پیٹناتا": "پیٹننا",
  "پیٹناتی": "پیٹننا",
  "پیٹناتیں": "پیٹننا",
  "پیٹناؤ": "پیٹننا",
  "پیٹناؤں": "پیٹننا",
  "پیٹنائے": "پیٹننا",
  "پیٹنائی": "پیٹننا",
  "پیٹنائیے": "پیٹننا",
  "پیٹنائیں": "پیٹننا",
  "پیٹنایا": "پیٹننا",
  "پیٹننے": "پیٹننا",
  "پیٹننا": "پیٹننا",
  "پیٹننی": "پیٹننا",
  "پیٹنتے": "پیٹننا",
  "پیٹنتا": "پیٹننا",
  "پیٹنتی": "پیٹننا",
  "پیٹنتیں": "پیٹننا",
  "پیٹنو": "پیٹننا",
  "پیٹنوں": "پیٹننا",
  "پیٹنی": "پیٹنا",
  "پیٹنیے": "پیٹننا",
  "پیٹنیں": "پیٹننا",
  "پیٹتے": "پِٹنا",
  "پیٹتا": "پِٹنا",
  "پیٹتی": "پِٹنا",
  "پیٹتیں": "پِٹنا",
  "پیٹو": "پیٹ",
  "پیٹوں": "پیٹ",
  "پیٹی": "پِٹنا",
  "پیٹیے": "پِٹنا",
  "پیٹیں": "پِٹنا",
  "پیٹھ": "پیٹھ",
  "پیٹھو": "پیٹھ",
  "پیٹھوں": "پیٹھ",
  "پیٹھیں": "پیٹھ",
  "پیش": "پیش",
  "پیشے": "پیشہ",
  "پیشانی": "پیشانی",
  "پیشانیاں": "پیشانی",
  "پیشانیو": "پیشانی",
  "پیشانیوں": "پیشانی",
  "پیشہ": "پیشہ",
  "پیشو": "پیشہ",
  "پیشوں": "پیشہ",
  "پیشوا": "پیشوا",
  "پیشواؤ": "پیشوا",
  "پیشواؤں": "پیشوا",
  "پیشی": "پیشی",
  "پیشیاں": "پیشی",
  "پیشیو": "پیشی",
  "پیشیوں": "پیشی",
  "پیا": "پینا",
  "پیالے": "پیالا",
  "پیالا": "پیالا",
  "پیالہ": "پیالہ",
  "پیالو": "پیالا",
  "پیالوں": "پیالا",
  "پیالی": "پیالی",
  "پیالیاں": "پیالی",
  "پیالیو": "پیالی",
  "پیالیوں": "پیالی",
  "پیار": "پیار",
  "پیارے": "پیارا",
  "پیارا": "پیارا",
  "پیارو": "پیارا",
  "پیاروں": "پیارا",
  "پیاری": "پیاری",
  "پیاریو": "پیاری",
  "پیاریوں": "پیاری",
  "پیاس": "پیاس",
  "پیاسے": "پیاسا",
  "پیاسا": "پیاسا",
  "پیاسہ": "پیاسہ",
  "پیاسو": "پیاسا",
  "پیاسوں": "پیاسا",
  "پیچیدگی": "پیچیدگی",
  "پیچیدگیاں": "پیچیدگی",
  "پیچیدگیو": "پیچیدگی",
  "پیچیدگیوں": "پیچیدگی",
  "پیکٹ": "پیکٹ",
  "پیکٹو": "پیکٹ",
  "پیکٹوں": "پیکٹ",
  "پیل": "پیلنا",
  "پیلے": "پیلا",
  "پیلں": "پیلنا",
  "پیلا": "پیلا",
  "پیلنے": "پیلنا",
  "پیلنا": "پیلنا",
  "پیلنی": "پیلنا",
  "پیلتے": "پیلنا",
  "پیلتا": "پیلنا",
  "پیلتی": "پیلنا",
  "پیلتیں": "پیلنا",
  "پیلو": "پیلا",
  "پیلوں": "پیلا",
  "پیلوا": "پیلنا",
  "پیلوانے": "پیلنا",
  "پیلوانا": "پیلنا",
  "پیلواتے": "پیلنا",
  "پیلواتا": "پیلنا",
  "پیلواتی": "پیلنا",
  "پیلواتیں": "پیلنا",
  "پیلواؤ": "پیلنا",
  "پیلواؤں": "پیلنا",
  "پیلوائے": "پیلنا",
  "پیلوائی": "پیلنا",
  "پیلوائیے": "پیلنا",
  "پیلوائیں": "پیلنا",
  "پیلوایا": "پیلنا",
  "پیلی": "پیلنا",
  "پیلیے": "پیلنا",
  "پیلیں": "پیلنا",
  "پیمان": "پیمان",
  "پیمانے": "پیمانہ",
  "پیمانہ": "پیمانہ",
  "پیمانو": "پیمانہ",
  "پیمانوں": "پیمانہ",
  "پینے": "پینا",
  "پینا": "پینا",
  "پینی": "پینا",
  "پیر": "پیر",
  "پیرایے": "پیرایہ",
  "پیرایہ": "پیرایہ",
  "پیرایو": "پیرایہ",
  "پیرایوں": "پیرایہ",
  "پیرو": "پیر",
  "پیروں": "پیر",
  "پیروکار": "پیروکار",
  "پیروکارو": "پیروکار",
  "پیروکاروں": "پیروکار",
  "پیس": "پیسنا",
  "پیسے": "پیسا",
  "پیسں": "پیسنا",
  "پیسا": "پیسا",
  "پیسہ": "پیسہ",
  "پیسنے": "پیسنا",
  "پیسنا": "پیسنا",
  "پیسنی": "پیسنا",
  "پیستے": "پیسنا",
  "پیستا": "پیسنا",
  "پیستی": "پیسنا",
  "پیستیں": "پیسنا",
  "پیسو": "پیسا",
  "پیسوں": "پیسا",
  "پیسی": "پیسنا",
  "پیسیے": "پیسنا",
  "پیسیں": "پیسنا",
  "پیتے": "پینا",
  "پیتا": "پینا",
  "پیتی": "پینا",
  "پیتیں": "پینا",
  "پیو": "پینا",
  "پیوں": "پینا",
  "پیی": "پیش",
  "پییے": "پینا",
  "پییں": "پینا",
  "پھڑک": "پھڑکنا",
  "پھڑکے": "پھڑکنا",
  "پھڑکں": "پھڑکنا",
  "پھڑکا": "پھڑکنا",
  "پھڑکانے": "پھڑکنا",
  "پھڑکانا": "پھڑکنا",
  "پھڑکاتے": "پھڑکنا",
  "پھڑکاتا": "پھڑکنا",
  "پھڑکاتی": "پھڑکنا",
  "پھڑکاتیں": "پھڑکنا",
  "پھڑکاؤ": "پھڑکنا",
  "پھڑکاؤں": "پھڑکنا",
  "پھڑکائے": "پھڑکنا",
  "پھڑکائی": "پھڑکنا",
  "پھڑکائیے": "پھڑکنا",
  "پھڑکائیں": "پھڑکنا",
  "پھڑکایا": "پھڑکنا",
  "پھڑکنے": "پھڑکنا",
  "پھڑکنا": "پھڑکنا",
  "پھڑکنی": "پھڑکنا",
  "پھڑکتے": "پھڑکنا",
  "پھڑکتا": "پھڑکنا",
  "پھڑکتی": "پھڑکنا",
  "پھڑکتیں": "پھڑکنا",
  "پھڑکو": "پھڑکنا",
  "پھڑکوں": "پھڑکنا",
  "پھڑکوا": "پھڑکنا",
  "پھڑکوانے": "پھڑکنا",
  "پھڑکوانا": "پھڑکنا",
  "پھڑکواتے": "پھڑکنا",
  "پھڑکواتا": "پھڑکنا",
  "پھڑکواتی": "پھڑکنا",
  "پھڑکواتیں": "پھڑکنا",
  "پھڑکواؤ": "پھڑکنا",
  "پھڑکواؤں": "پھڑکنا",
  "پھڑکوائے": "پھڑکنا",
  "پھڑکوائی": "پھڑکنا",
  "پھڑکوائیے": "پھڑکنا",
  "پھڑکوائیں": "پھڑکنا",
  "پھڑکوایا": "پھڑکنا",
  "پھڑکی": "پھڑکنا",
  "پھڑکیے": "پھڑکنا",
  "پھڑکیں": "پھڑکنا",
  "پھڑپھڑا": "پھڑپھڑانا",
  "پھڑپھڑانے": "پھڑپھڑانا",
  "پھڑپھڑانا": "پھڑپھڑانا",
  "پھڑپھڑانی": "پھڑپھڑانا",
  "پھڑپھڑاتے": "پھڑپھڑانا",
  "پھڑپھڑاتا": "پھڑپھڑانا",
  "پھڑپھڑاتی": "پھڑپھڑانا",
  "پھڑپھڑاتیں": "پھڑپھڑانا",
  "پھڑپھڑاؤ": "پھڑپھڑانا",
  "پھڑپھڑاؤں": "پھڑپھڑانا",
  "پھڑپھڑائے": "پھڑپھڑانا",
  "پھڑپھڑائی": "پھڑپھڑانا",
  "پھڑپھڑائیے": "پھڑپھڑانا",
  "پھڑپھڑائیں": "پھڑپھڑانا",
  "پھڑپھڑایا": "پھڑپھڑانا",
  "پھڑوا": "پھاڑنا",
  "پھڑوانے": "پھاڑنا",
  "پھڑوانا": "پھاڑنا",
  "پھڑواتے": "پھاڑنا",
  "پھڑواتا": "پھاڑنا",
  "پھڑواتی": "پھاڑنا",
  "پھڑواتیں": "پھاڑنا",
  "پھڑواؤ": "پھاڑنا",
  "پھڑواؤں": "پھاڑنا",
  "پھڑوائے": "پھاڑنا",
  "پھڑوائی": "پھاڑنا",
  "پھڑوائیے": "پھاڑنا",
  "پھڑوائیں": "پھاڑنا",
  "پھڑوایا": "پھاڑنا",
  "پھٹ": "پھٹنا",
  "پھٹے": "پھٹا",
  "پھٹں": "پھٹنا",
  "پھٹا": "پھٹا",
  "پھٹانے": "پھٹنا",
  "پھٹانا": "پھٹنا",
  "پھٹاتے": "پھٹنا",
  "پھٹاتا": "پھٹنا",
  "پھٹاتی": "پھٹنا",
  "پھٹاتیں": "پھٹنا",
  "پھٹاؤ": "پھٹنا",
  "پھٹاؤں": "پھٹنا",
  "پھٹائے": "پھٹنا",
  "پھٹائی": "پھٹنا",
  "پھٹائیے": "پھٹنا",
  "پھٹائیں": "پھٹنا",
  "پھٹایا": "پھٹنا",
  "پھٹک": "پھٹکنا",
  "پھٹکے": "پھٹکنا",
  "پھٹکں": "پھٹکنا",
  "پھٹکا": "پھٹکنا",
  "پھٹکنے": "پھٹکنا",
  "پھٹکنا": "پھٹکنا",
  "پھٹکنی": "پھٹکنا",
  "پھٹکتے": "پھٹکنا",
  "پھٹکتا": "پھٹکنا",
  "پھٹکتی": "پھٹکنا",
  "پھٹکتیں": "پھٹکنا",
  "پھٹکو": "پھٹکنا",
  "پھٹکوں": "پھٹکنا",
  "پھٹکی": "پھٹکنا",
  "پھٹکیے": "پھٹکنا",
  "پھٹکیں": "پھٹکنا",
  "پھٹنے": "پھٹنا",
  "پھٹنا": "پھٹنا",
  "پھٹنی": "پھٹنا",
  "پھٹتے": "پھٹنا",
  "پھٹتا": "پھٹنا",
  "پھٹتی": "پھٹنا",
  "پھٹتیں": "پھٹنا",
  "پھٹو": "پھٹا",
  "پھٹوں": "پھٹا",
  "پھٹوا": "پھٹنا",
  "پھٹوانے": "پھٹنا",
  "پھٹوانا": "پھٹنا",
  "پھٹواتے": "پھٹنا",
  "پھٹواتا": "پھٹنا",
  "پھٹواتی": "پھٹنا",
  "پھٹواتیں": "پھٹنا",
  "پھٹواؤ": "پھٹنا",
  "پھٹواؤں": "پھٹنا",
  "پھٹوائے": "پھٹنا",
  "پھٹوائی": "پھٹنا",
  "پھٹوائیے": "پھٹنا",
  "پھٹوائیں": "پھٹنا",
  "پھٹوایا": "پھٹنا",
  "پھٹی": "پھٹنا",
  "پھٹیے": "پھٹنا",
  "پھٹیں": "پھٹنا",
  "پھاڑ": "پھاڑنا",
  "پھاڑے": "پھاڑنا",
  "پھاڑں": "پھاڑنا",
  "پھاڑا": "پھاڑنا",
  "پھاڑنے": "پھاڑنا",
  "پھاڑنا": "پھاڑنا",
  "پھاڑنی": "پھاڑنا",
  "پھاڑتے": "پھاڑنا",
  "پھاڑتا": "پھاڑنا",
  "پھاڑتی": "پھاڑنا",
  "پھاڑتیں": "پھاڑنا",
  "پھاڑو": "پھاڑنا",
  "پھاڑوں": "پھاڑنا",
  "پھاڑی": "پھاڑنا",
  "پھاڑیے": "پھاڑنا",
  "پھاڑیں": "پھاڑنا",
  "پھانس": "پھانسنا",
  "پھانسے": "پھانسنا",
  "پھانسں": "پھانسنا",
  "پھانسا": "پھانسنا",
  "پھانسانے": "پھانسنا",
  "پھانسانا": "پھانسنا",
  "پھانساتے": "پھانسنا",
  "پھانساتا": "پھانسنا",
  "پھانساتی": "پھانسنا",
  "پھانساتیں": "پھانسنا",
  "پھانساؤ": "پھانسنا",
  "پھانساؤں": "پھانسنا",
  "پھانسائے": "پھانسنا",
  "پھانسائی": "پھانسنا",
  "پھانسائیے": "پھانسنا",
  "پھانسائیں": "پھانسنا",
  "پھانسایا": "پھانسنا",
  "پھانسنے": "پھانسنا",
  "پھانسنا": "پھانسنا",
  "پھانسنی": "پھانسنا",
  "پھانستے": "پھانسنا",
  "پھانستا": "پھانسنا",
  "پھانستی": "پھانسنا",
  "پھانستیں": "پھانسنا",
  "پھانسو": "پھانسنا",
  "پھانسوں": "پھانسنا",
  "پھانسوا": "پھانسنا",
  "پھانسوانے": "پھانسنا",
  "پھانسوانا": "پھانسنا",
  "پھانسواتے": "پھانسنا",
  "پھانسواتا": "پھانسنا",
  "پھانسواتی": "پھانسنا",
  "پھانسواتیں": "پھانسنا",
  "پھانسواؤ": "پھانسنا",
  "پھانسواؤں": "پھانسنا",
  "پھانسوائے": "پھانسنا",
  "پھانسوائی": "پھانسنا",
  "پھانسوائیے": "پھانسنا",
  "پھانسوائیں": "پھانسنا",
  "پھانسوایا": "پھانسنا",
  "پھانسی": "پھانسنا",
  "پھانسیے": "پھانسنا",
  "پھانسیں": "پھانسنا",
  "پھبتی": "پھبتی",
  "پھبتیاں": "پھبتی",
  "پھبتیو": "پھبتی",
  "پھبتیوں": "پھبتی",
  "پھل": "پھل",
  "پھلے": "پھلنا",
  "پھلں": "پھلنا",
  "پھلا": "پھلنا",
  "پھلانے": "پھلنا",
  "پھلانا": "پھلنا",
  "پھلانگ": "پھلانگنا",
  "پھلانگے": "پھلانگنا",
  "پھلانگں": "پھلانگنا",
  "پھلانگا": "پھلانگنا",
  "پھلانگنے": "پھلانگنا",
  "پھلانگنا": "پھلانگنا",
  "پھلانگنی": "پھلانگنا",
  "پھلانگتے": "پھلانگنا",
  "پھلانگتا": "پھلانگنا",
  "پھلانگتی": "پھلانگنا",
  "پھلانگتیں": "پھلانگنا",
  "پھلانگو": "پھلانگنا",
  "پھلانگوں": "پھلانگنا",
  "پھلانگی": "پھلانگنا",
  "پھلانگیے": "پھلانگنا",
  "پھلانگیں": "پھلانگنا",
  "پھلاتے": "پھلنا",
  "پھلاتا": "پھلنا",
  "پھلاتی": "پھلنا",
  "پھلاتیں": "پھلنا",
  "پھلاؤ": "پھلنا",
  "پھلاؤں": "پھلنا",
  "پھلائے": "پھلنا",
  "پھلائی": "پھلنا",
  "پھلائیے": "پھلنا",
  "پھلائیں": "پھلنا",
  "پھلایا": "پھلنا",
  "پھلجڑی": "پھلجڑی",
  "پھلجڑیاں": "پھلجڑی",
  "پھلجڑیو": "پھلجڑی",
  "پھلجڑیوں": "پھلجڑی",
  "پھلکی": "پھلکی",
  "پھلکیاں": "پھلکی",
  "پھلکیو": "پھلکی",
  "پھلکیوں": "پھلکی",
  "پھلنے": "پھلنا",
  "پھلنا": "پھلنا",
  "پھلنی": "پھلنا",
  "پھلتے": "پھلنا",
  "پھلتا": "پھلنا",
  "پھلتی": "پھلنا",
  "پھلتیں": "پھلنا",
  "پھلو": "پھل",
  "پھلوں": "پھل",
  "پھلوا": "پھلنا",
  "پھلوانے": "پھلنا",
  "پھلوانا": "پھلنا",
  "پھلواری": "پھلواری",
  "پھلواریاں": "پھلواری",
  "پھلواریو": "پھلواری",
  "پھلواریوں": "پھلواری",
  "پھلواتے": "پھلنا",
  "پھلواتا": "پھلنا",
  "پھلواتی": "پھلنا",
  "پھلواتیں": "پھلنا",
  "پھلواؤ": "پھلنا",
  "پھلواؤں": "پھلنا",
  "پھلوائے": "پھلنا",
  "پھلوائی": "پھلنا",
  "پھلوائیے": "پھلنا",
  "پھلوائیں": "پھلنا",
  "پھلوایا": "پھلنا",
  "پھلی": "پھلی",
  "پھلیے": "پھلنا",
  "پھلیں": "پھلنا",
  "پھلیاں": "پھلی",
  "پھلیو": "پھلی",
  "پھلیوں": "پھلی",
  "پھند": "پھندنا",
  "پھندے": "پھندہ",
  "پھندں": "پھندنا",
  "پھندا": "پھندنا",
  "پھندہ": "پھندہ",
  "پھندنے": "پھندنا",
  "پھندنا": "پھندنا",
  "پھندنو": "پھندنا",
  "پھندنوں": "پھندنا",
  "پھندنی": "پھندنا",
  "پھندتے": "پھندنا",
  "پھندتا": "پھندنا",
  "پھندتی": "پھندنا",
  "پھندتیں": "پھندنا",
  "پھندو": "پھندہ",
  "پھندوں": "پھندہ",
  "پھندوا": "پھندنا",
  "پھندوانے": "پھندنا",
  "پھندوانا": "پھندنا",
  "پھندواتے": "پھندنا",
  "پھندواتا": "پھندنا",
  "پھندواتی": "پھندنا",
  "پھندواتیں": "پھندنا",
  "پھندواؤ": "پھندنا",
  "پھندواؤں": "پھندنا",
  "پھندوائے": "پھندنا",
  "پھندوائی": "پھندنا",
  "پھندوائیے": "پھندنا",
  "پھندوائیں": "پھندنا",
  "پھندوایا": "پھندنا",
  "پھندی": "پھندنا",
  "پھندیے": "پھندنا",
  "پھندیں": "پھندنا",
  "پھنکا": "پھینکنا",
  "پھنکانے": "پھینکنا",
  "پھنکانا": "پھینکنا",
  "پھنکار": "پھنکار",
  "پھنکارو": "پھنکار",
  "پھنکاروں": "پھنکار",
  "پھنکاریں": "پھنکار",
  "پھنکاتے": "پھینکنا",
  "پھنکاتا": "پھینکنا",
  "پھنکاتی": "پھینکنا",
  "پھنکاتیں": "پھینکنا",
  "پھنکاؤ": "پھینکنا",
  "پھنکاؤں": "پھینکنا",
  "پھنکائے": "پھینکنا",
  "پھنکائی": "پھینکنا",
  "پھنکائیے": "پھینکنا",
  "پھنکائیں": "پھینکنا",
  "پھنکایا": "پھینکنا",
  "پھنکوا": "پھینکنا",
  "پھنکوانے": "پھینکنا",
  "پھنکوانا": "پھینکنا",
  "پھنکواتے": "پھینکنا",
  "پھنکواتا": "پھینکنا",
  "پھنکواتی": "پھینکنا",
  "پھنکواتیں": "پھینکنا",
  "پھنکواؤ": "پھینکنا",
  "پھنکواؤں": "پھینکنا",
  "پھنکوائے": "پھینکنا",
  "پھنکوائی": "پھینکنا",
  "پھنکوائیے": "پھینکنا",
  "پھنکوائیں": "پھینکنا",
  "پھنکوایا": "پھینکنا",
  "پھنس": "پھنسنا",
  "پھنسے": "پھنسنا",
  "پھنسں": "پھنسنا",
  "پھنسا": "پھنسنا",
  "پھنسانے": "پھنسنا",
  "پھنسانا": "پھنسنا",
  "پھنساتے": "پھنسنا",
  "پھنساتا": "پھنسنا",
  "پھنساتی": "پھنسنا",
  "پھنساتیں": "پھنسنا",
  "پھنساؤ": "پھنسنا",
  "پھنساؤں": "پھنسنا",
  "پھنسائے": "پھنسنا",
  "پھنسائی": "پھنسنا",
  "پھنسائیے": "پھنسنا",
  "پھنسائیں": "پھنسنا",
  "پھنسایا": "پھنسنا",
  "پھنسنے": "پھنسنا",
  "پھنسنا": "پھنسنا",
  "پھنسنی": "پھنسنا",
  "پھنستے": "پھنسنا",
  "پھنستا": "پھنسنا",
  "پھنستی": "پھنسنا",
  "پھنستیں": "پھنسنا",
  "پھنسو": "پھنسنا",
  "پھنسوں": "پھنسنا",
  "پھنسوا": "پھنسنا",
  "پھنسوانے": "پھنسنا",
  "پھنسوانا": "پھنسنا",
  "پھنسواتے": "پھنسنا",
  "پھنسواتا": "پھنسنا",
  "پھنسواتی": "پھنسنا",
  "پھنسواتیں": "پھنسنا",
  "پھنسواؤ": "پھنسنا",
  "پھنسواؤں": "پھنسنا",
  "پھنسوائے": "پھنسنا",
  "پھنسوائی": "پھنسنا",
  "پھنسوائیے": "پھنسنا",
  "پھنسوائیں": "پھنسنا",
  "پھنسوایا": "پھنسنا",
  "پھنسی": "پھنسی",
  "پھنسیے": "پھنسنا",
  "پھنسیں": "پھنسنا",
  "پھنسیاں": "پھنسی",
  "پھنسیو": "پھنسی",
  "پھنسیوں": "پھنسی",
  "پھر": "پھرنا",
  "پھرے": "پھرا",
  "پھرں": "پھرنا",
  "پھرا": "پھرا",
  "پھرانے": "پھرنا",
  "پھرانا": "پھرنا",
  "پھراتے": "پھرنا",
  "پھراتا": "پھرنا",
  "پھراتی": "پھرنا",
  "پھراتیں": "پھرنا",
  "پھراؤ": "پھرنا",
  "پھراؤں": "پھرنا",
  "پھرائے": "پھرنا",
  "پھرائی": "پھرنا",
  "پھرائیے": "پھرنا",
  "پھرائیں": "پھرنا",
  "پھرایا": "پھرنا",
  "پھرکی": "پھرکی",
  "پھرکیاں": "پھرکی",
  "پھرکیو": "پھرکی",
  "پھرکیوں": "پھرکی",
  "پھرنے": "پھرنا",
  "پھرنا": "پھرنا",
  "پھرنی": "پھرنا",
  "پھرتے": "پھرنا",
  "پھرتا": "پھرنا",
  "پھرتی": "پھرنا",
  "پھرتیں": "پھرنا",
  "پھرو": "پھرا",
  "پھروں": "پھرا",
  "پھروا": "پھرنا",
  "پھروانے": "پھرنا",
  "پھروانا": "پھرنا",
  "پھرواتے": "پھرنا",
  "پھرواتا": "پھرنا",
  "پھرواتی": "پھرنا",
  "پھرواتیں": "پھرنا",
  "پھرواؤ": "پھرنا",
  "پھرواؤں": "پھرنا",
  "پھروائے": "پھرنا",
  "پھروائی": "پھرنا",
  "پھروائیے": "پھرنا",
  "پھروائیں": "پھرنا",
  "پھروایا": "پھرنا",
  "پھری": "پھری",
  "پھریے": "پھرنا",
  "پھریں": "پھرنا",
  "پھریاں": "پھری",
  "پھریو": "پھری",
  "پھریوں": "پھری",
  "پھس": "پھسنا",
  "پھسے": "پھسنا",
  "پھسں": "پھسنا",
  "پھسا": "پھسنا",
  "پھسانے": "پھسنا",
  "پھسانا": "پھسنا",
  "پھساتے": "پھسنا",
  "پھساتا": "پھسنا",
  "پھساتی": "پھسنا",
  "پھساتیں": "پھسنا",
  "پھساؤ": "پھسنا",
  "پھساؤں": "پھسنا",
  "پھسائے": "پھسنا",
  "پھسائی": "پھسنا",
  "پھسائیے": "پھسنا",
  "پھسائیں": "پھسنا",
  "پھسایا": "پھسنا",
  "پھسل": "پھسلنا",
  "پھسلے": "پھسلنا",
  "پھسلں": "پھسلنا",
  "پھسلا": "پھسلنا",
  "پھسلانے": "پھسلنا",
  "پھسلانا": "پھسلنا",
  "پھسلاتے": "پھسلنا",
  "پھسلاتا": "پھسلنا",
  "پھسلاتی": "پھسلنا",
  "پھسلاتیں": "پھسلنا",
  "پھسلاؤ": "پھسلنا",
  "پھسلاؤں": "پھسلنا",
  "پھسلائے": "پھسلنا",
  "پھسلائی": "پھسلنا",
  "پھسلائیے": "پھسلنا",
  "پھسلائیں": "پھسلنا",
  "پھسلایا": "پھسلنا",
  "پھسلنے": "پھسلنا",
  "پھسلنا": "پھسلنا",
  "پھسلنی": "پھسلنا",
  "پھسلتے": "پھسلنا",
  "پھسلتا": "پھسلنا",
  "پھسلتی": "پھسلنا",
  "پھسلتیں": "پھسلنا",
  "پھسلو": "پھسلنا",
  "پھسلوں": "پھسلنا",
  "پھسلوا": "پھسلنا",
  "پھسلوانے": "پھسلنا",
  "پھسلوانا": "پھسلنا",
  "پھسلواتے": "پھسلنا",
  "پھسلواتا": "پھسلنا",
  "پھسلواتی": "پھسلنا",
  "پھسلواتیں": "پھسلنا",
  "پھسلواؤ": "پھسلنا",
  "پھسلواؤں": "پھسلنا",
  "پھسلوائے": "پھسلنا",
  "پھسلوائی": "پھسلنا",
  "پھسلوائیے": "پھسلنا",
  "پھسلوائیں": "پھسلنا",
  "پھسلوایا": "پھسلنا",
  "پھسلی": "پھسلنا",
  "پھسلیے": "پھسلنا",
  "پھسلیں": "پھسلنا",
  "پھسنے": "پھسنا",
  "پھسنا": "پھسنا",
  "پھسنی": "پھسنا",
  "پھستے": "پھسنا",
  "پھستا": "پھسنا",
  "پھستی": "پھسنا",
  "پھستیں": "پھسنا",
  "پھسو": "پھسنا",
  "پھسوں": "پھسنا",
  "پھسوا": "پھسنا",
  "پھسوانے": "پھسنا",
  "پھسوانا": "پھسنا",
  "پھسواتے": "پھسنا",
  "پھسواتا": "پھسنا",
  "پھسواتی": "پھسنا",
  "پھسواتیں": "پھسنا",
  "پھسواؤ": "پھسنا",
  "پھسواؤں": "پھسنا",
  "پھسوائے": "پھسنا",
  "پھسوائی": "پھسنا",
  "پھسوائیے": "پھسنا",
  "پھسوائیں": "پھسنا",
  "پھسوایا": "پھسنا",
  "پھسی": "پھسنا",
  "پھسیے": "پھسنا",
  "پھسیں": "پھسنا",
  "پھوڑ": "پُھوٹنا",
  "پھوڑْں": "پُھوٹنا",
  "پھوڑْنے": "پُھوٹنا",
  "پھوڑْنا": "پُھوٹنا",
  "پھوڑْتے": "پُھوٹنا",
  "پھوڑْتا": "پُھوٹنا",
  "پھوڑْتی": "پُھوٹنا",
  "پھوڑْتیں": "پُھوٹنا",
  "پھوڑے": "پھوڑا",
  "پھوڑں": "پھوڑنا",
  "پھوڑا": "پھوڑا",
  "پھوڑنے": "پھوڑنا",
  "پھوڑنا": "پھوڑنا",
  "پھوڑنی": "پھوڑنا",
  "پھوڑتے": "پھوڑنا",
  "پھوڑتا": "پھوڑنا",
  "پھوڑتی": "پھوڑنا",
  "پھوڑتیں": "پھوڑنا",
  "پھوڑو": "پھوڑا",
  "پھوڑوں": "پھوڑا",
  "پھوڑوا": "پھوڑنا",
  "پھوڑوانے": "پھوڑنا",
  "پھوڑوانا": "پھوڑنا",
  "پھوڑواتے": "پھوڑنا",
  "پھوڑواتا": "پھوڑنا",
  "پھوڑواتی": "پھوڑنا",
  "پھوڑواتیں": "پھوڑنا",
  "پھوڑواؤ": "پھوڑنا",
  "پھوڑواؤں": "پھوڑنا",
  "پھوڑوائے": "پھوڑنا",
  "پھوڑوائی": "پھوڑنا",
  "پھوڑوائیے": "پھوڑنا",
  "پھوڑوائیں": "پھوڑنا",
  "پھوڑوایا": "پھوڑنا",
  "پھوڑی": "پُھوٹنا",
  "پھوڑیے": "پُھوٹنا",
  "پھوڑیں": "پُھوٹنا",
  "پھوٹ": "پھوٹنا",
  "پھوٹے": "پھوٹنا",
  "پھوٹں": "پھوٹنا",
  "پھوٹا": "پھوٹنا",
  "پھوٹنے": "پھوٹنا",
  "پھوٹنا": "پھوٹنا",
  "پھوٹنی": "پھوٹنا",
  "پھوٹتے": "پھوٹنا",
  "پھوٹتا": "پھوٹنا",
  "پھوٹتی": "پھوٹنا",
  "پھوٹتیں": "پھوٹنا",
  "پھوٹو": "پھوٹنا",
  "پھوٹوں": "پھوٹنا",
  "پھوٹی": "پھوٹنا",
  "پھوٹیے": "پھوٹنا",
  "پھوٹیں": "پھوٹنا",
  "پھول": "پھول",
  "پھولے": "پھولنا",
  "پھولں": "پھولنا",
  "پھولا": "پھولنا",
  "پھولنے": "پھولنا",
  "پھولنا": "پھولنا",
  "پھولنی": "پھولنا",
  "پھولتے": "پھولنا",
  "پھولتا": "پھولنا",
  "پھولتی": "پھولنا",
  "پھولتیں": "پھولنا",
  "پھولو": "پھول",
  "پھولوں": "پھول",
  "پھولی": "پھولنا",
  "پھولیے": "پھولنا",
  "پھولیں": "پھولنا",
  "پھونک": "پھونک",
  "پھونکے": "پھونکنا",
  "پھونکں": "پھونکنا",
  "پھونکا": "پھونکنا",
  "پھونکانے": "پھونکنا",
  "پھونکانا": "پھونکنا",
  "پھونکاتے": "پھونکنا",
  "پھونکاتا": "پھونکنا",
  "پھونکاتی": "پھونکنا",
  "پھونکاتیں": "پھونکنا",
  "پھونکاؤ": "پھونکنا",
  "پھونکاؤں": "پھونکنا",
  "پھونکائے": "پھونکنا",
  "پھونکائی": "پھونکنا",
  "پھونکائیے": "پھونکنا",
  "پھونکائیں": "پھونکنا",
  "پھونکایا": "پھونکنا",
  "پھونکنے": "پھونکنا",
  "پھونکنا": "پھونکنا",
  "پھونکنی": "پھونکنا",
  "پھونکتے": "پھونکنا",
  "پھونکتا": "پھونکنا",
  "پھونکتی": "پھونکنا",
  "پھونکتیں": "پھونکنا",
  "پھونکو": "پھونک",
  "پھونکوں": "پھونک",
  "پھونکوا": "پھونکنا",
  "پھونکوانے": "پھونکنا",
  "پھونکوانا": "پھونکنا",
  "پھونکواتے": "پھونکنا",
  "پھونکواتا": "پھونکنا",
  "پھونکواتی": "پھونکنا",
  "پھونکواتیں": "پھونکنا",
  "پھونکواؤ": "پھونکنا",
  "پھونکواؤں": "پھونکنا",
  "پھونکوائے": "پھونکنا",
  "پھونکوائی": "پھونکنا",
  "پھونکوائیے": "پھونکنا",
  "پھونکوائیں": "پھونکنا",
  "پھونکوایا": "پھونکنا",
  "پھونکی": "پھونکنا",
  "پھونکیے": "پھونکنا",
  "پھونکیں": "پھونک",
  "پھوپھی": "پھوپھی",
  "پھوپھیاں": "پھوپھی",
  "پھوپھیو": "پھوپھی",
  "پھوپھیوں": "پھوپھی",
  "پھیل": "پھیلنا",
  "پھیلے": "پھیلنا",
  "پھیلں": "پھیلنا",
  "پھیلا": "پھیلنا",
  "پھیلانے": "پھیلنا",
  "پھیلانا": "پھیلنا",
  "پھیلاتے": "پھیلنا",
  "پھیلاتا": "پھیلنا",
  "پھیلاتی": "پھیلنا",
  "پھیلاتیں": "پھیلنا",
  "پھیلاؤ": "پھیلنا",
  "پھیلاؤں": "پھیلنا",
  "پھیلائے": "پھیلنا",
  "پھیلائی": "پھیلنا",
  "پھیلائیے": "پھیلنا",
  "پھیلائیں": "پھیلنا",
  "پھیلایا": "پھیلنا",
  "پھیلنے": "پھیلنا",
  "پھیلنا": "پھیلنا",
  "پھیلنی": "پھیلنا",
  "پھیلتے": "پھیلنا",
  "پھیلتا": "پھیلنا",
  "پھیلتی": "پھیلنا",
  "پھیلتیں": "پھیلنا",
  "پھیلو": "پھیلنا",
  "پھیلوں": "پھیلنا",
  "پھیلوا": "پھیلنا",
  "پھیلوانے": "پھیلنا",
  "پھیلوانا": "پھیلنا",
  "پھیلواتے": "پھیلنا",
  "پھیلواتا": "پھیلنا",
  "پھیلواتی": "پھیلنا",
  "پھیلواتیں": "پھیلنا",
  "پھیلواؤ": "پھیلنا",
  "پھیلواؤں": "پھیلنا",
  "پھیلوائے": "پھیلنا",
  "پھیلوائی": "پھیلنا",
  "پھیلوائیے": "پھیلنا",
  "پھیلوائیں": "پھیلنا",
  "پھیلوایا": "پھیلنا",
  "پھیلی": "پھیلنا",
  "پھیلیے": "پھیلنا",
  "پھیلیں": "پھیلنا",
  "پھینٹ": "پھینٹنا",
  "پھینٹے": "پھینٹنا",
  "پھینٹں": "پھینٹنا",
  "پھینٹا": "پھینٹنا",
  "پھینٹانے": "پھینٹنا",
  "پھینٹانا": "پھینٹنا",
  "پھینٹاتے": "پھینٹنا",
  "پھینٹاتا": "پھینٹنا",
  "پھینٹاتی": "پھینٹنا",
  "پھینٹاتیں": "پھینٹنا",
  "پھینٹاؤ": "پھینٹنا",
  "پھینٹاؤں": "پھینٹنا",
  "پھینٹائے": "پھینٹنا",
  "پھینٹائی": "پھینٹنا",
  "پھینٹائیے": "پھینٹنا",
  "پھینٹائیں": "پھینٹنا",
  "پھینٹایا": "پھینٹنا",
  "پھینٹنے": "پھینٹنا",
  "پھینٹنا": "پھینٹنا",
  "پھینٹنی": "پھینٹنا",
  "پھینٹتے": "پھینٹنا",
  "پھینٹتا": "پھینٹنا",
  "پھینٹتی": "پھینٹنا",
  "پھینٹتیں": "پھینٹنا",
  "پھینٹو": "پھینٹنا",
  "پھینٹوں": "پھینٹنا",
  "پھینٹوا": "پھینٹنا",
  "پھینٹوانے": "پھینٹنا",
  "پھینٹوانا": "پھینٹنا",
  "پھینٹواتے": "پھینٹنا",
  "پھینٹواتا": "پھینٹنا",
  "پھینٹواتی": "پھینٹنا",
  "پھینٹواتیں": "پھینٹنا",
  "پھینٹواؤ": "پھینٹنا",
  "پھینٹواؤں": "پھینٹنا",
  "پھینٹوائے": "پھینٹنا",
  "پھینٹوائی": "پھینٹنا",
  "پھینٹوائیے": "پھینٹنا",
  "پھینٹوائیں": "پھینٹنا",
  "پھینٹوایا": "پھینٹنا",
  "پھینٹی": "پھینٹنا",
  "پھینٹیے": "پھینٹنا",
  "پھینٹیں": "پھینٹنا",
  "پھینک": "پھینکنا",
  "پھینکے": "پھینکنا",
  "پھینکں": "پھینکنا",
  "پھینکا": "پھینکنا",
  "پھینکانے": "پھینکنا",
  "پھینکانا": "پھینکنا",
  "پھینکاتے": "پھینکنا",
  "پھینکاتا": "پھینکنا",
  "پھینکاتی": "پھینکنا",
  "پھینکاتیں": "پھینکنا",
  "پھینکاؤ": "پھینکنا",
  "پھینکاؤں": "پھینکنا",
  "پھینکائے": "پھینکنا",
  "پھینکائی": "پھینکنا",
  "پھینکائیے": "پھینکنا",
  "پھینکائیں": "پھینکنا",
  "پھینکایا": "پھینکنا",
  "پھینکنے": "پھینکنا",
  "پھینکنا": "پھینکنا",
  "پھینکنی": "پھینکنا",
  "پھینکتے": "پھینکنا",
  "پھینکتا": "پھینکنا",
  "پھینکتی": "پھینکنا",
  "پھینکتیں": "پھینکنا",
  "پھینکو": "پھینکنا",
  "پھینکوں": "پھینکنا",
  "پھینکوا": "پھینکنا",
  "پھینکوانے": "پھینکنا",
  "پھینکوانا": "پھینکنا",
  "پھینکواتے": "پھینکنا",
  "پھینکواتا": "پھینکنا",
  "پھینکواتی": "پھینکنا",
  "پھینکواتیں": "پھینکنا",
  "پھینکواؤ": "پھینکنا",
  "پھینکواؤں": "پھینکنا",
  "پھینکوائے": "پھینکنا",
  "پھینکوائی": "پھینکنا",
  "پھینکوائیے": "پھینکنا",
  "پھینکوائیں": "پھینکنا",
  "پھینکوایا": "پھینکنا",
  "پھینکی": "پھینکنا",
  "پھینکیے": "پھینکنا",
  "پھینکیں": "پھینکنا",
  "پھیر": "پھیرنا",
  "پھیرے": "پھیرا",
  "پھیرں": "پھیرنا",
  "پھیرا": "پھیرا",
  "پھیرنے": "پھیرنا",
  "پھیرنا": "پھیرنا",
  "پھیرنی": "پھیرنا",
  "پھیرتے": "پھیرنا",
  "پھیرتا": "پھیرنا",
  "پھیرتی": "پھیرنا",
  "پھیرتیں": "پھیرنا",
  "پھیرو": "پھیرا",
  "پھیروں": "پھیرا",
  "پھیروا": "پھیرنا",
  "پھیروانے": "پھیرنا",
  "پھیروانا": "پھیرنا",
  "پھیرواتے": "پھیرنا",
  "پھیرواتا": "پھیرنا",
  "پھیرواتی": "پھیرنا",
  "پھیرواتیں": "پھیرنا",
  "پھیرواؤ": "پھیرنا",
  "پھیرواؤں": "پھیرنا",
  "پھیروائے": "پھیرنا",
  "پھیروائی": "پھیرنا",
  "پھیروائیے": "پھیرنا",
  "پھیروائیں": "پھیرنا",
  "پھیروایا": "پھیرنا",
  "پھیری": "پھیرنا",
  "پھیریے": "پھیرنا",
  "پھیریں": "پھیرنا",
  "قَسم": "قَسم",
  "قَسمو": "قَسم",
  "قَسموں": "قَسم",
  "قَسمیں": "قَسم",
  "قِسم": "قِسم",
  "قِسمو": "قِسم",
  "قِسموں": "قِسم",
  "قِسمیں": "قِسم",
  "قصّے": "قصّہ",
  "قصّہ": "قصّہ",
  "قصّو": "قصّہ",
  "قصّوں": "قصّہ",
  "قصے": "قصہ",
  "قصاب": "قصاب",
  "قصابو": "قصاب",
  "قصابوں": "قصاب",
  "قصائی": "قصائی",
  "قصائیو": "قصائی",
  "قصائیوں": "قصائی",
  "قصبے": "قصبہ",
  "قصبہ": "قصبہ",
  "قصبو": "قصبہ",
  "قصبوں": "قصبہ",
  "قصہ": "قصہ",
  "قصو": "قصہ",
  "قصوں": "قصہ",
  "قصور": "قصور",
  "قصورو": "قصور",
  "قصوروں": "قصور",
  "قصیدے": "قصیدہ",
  "قصیدہ": "قصیدہ",
  "قصیدو": "قصیدہ",
  "قصیدوں": "قصیدہ",
  "قاعدے": "قاعدہ",
  "قاعدہ": "قاعدہ",
  "قاعدو": "قاعدہ",
  "قاعدوں": "قاعدہ",
  "قافلے": "قافلہ",
  "قافلہ": "قافلہ",
  "قافلو": "قافلہ",
  "قافلوں": "قافلہ",
  "قافیے": "قافیہ",
  "قافیہ": "قافیہ",
  "قافیو": "قافیہ",
  "قافیوں": "قافیہ",
  "قالین": "قالین",
  "قالینو": "قالین",
  "قالینوں": "قالین",
  "قانون": "قانون",
  "قانونو": "قانون",
  "قانونوں": "قانون",
  "قاری": "قاری",
  "قاریو": "قاری",
  "قاریوں": "قاری",
  "قاتل": "قاتل",
  "قاتلو": "قاتل",
  "قاتلوں": "قاتل",
  "قباحت": "قباحت",
  "قباحتو": "قباحت",
  "قباحتوں": "قباحت",
  "قباحتیں": "قباحت",
  "قبائلی": "قبائلی",
  "قبائلیو": "قبائلی",
  "قبائلیوں": "قبائلی",
  "قبلے": "قبلہ",
  "قبلہ": "قبلہ",
  "قبلو": "قبلہ",
  "قبلوں": "قبلہ",
  "قبر": "قبر",
  "قبرو": "قبر",
  "قبروں": "قبر",
  "قبریں": "قبر",
  "قبیلے": "قبیلہ",
  "قبیلہ": "قبیلہ",
  "قبیلو": "قبیلہ",
  "قبیلوں": "قبیلہ",
  "قبضے": "قبضہ",
  "قبضہ": "قبضہ",
  "قبضو": "قبضہ",
  "قبضوں": "قبضہ",
  "قد": "قد",
  "قدم": "قدم",
  "قدمو": "قدم",
  "قدموں": "قدم",
  "قدر": "قدر",
  "قدرت": "قدرت",
  "قدرتو": "قدرت",
  "قدرتوں": "قدرت",
  "قدرتیں": "قدرت",
  "قدرو": "قدر",
  "قدروں": "قدر",
  "قدریں": "قدر",
  "قدو": "قد",
  "قدوں": "قد",
  "قہقہے": "قہقہہ",
  "قہقہہ": "قہقہہ",
  "قہقہو": "قہقہہ",
  "قہقہوں": "قہقہہ",
  "قہوے": "قہوہ",
  "قہوہ": "قہوہ",
  "قہوو": "قہوہ",
  "قہووں": "قہوہ",
  "قلے": "قلہ",
  "قلابازی": "قلابازی",
  "قلابازیاں": "قلابازی",
  "قلابازیو": "قلابازی",
  "قلابازیوں": "قلابازی",
  "قلع": "قلع",
  "قلعے": "قلع",
  "قلعہ": "قلعہ",
  "قلعو": "قلع",
  "قلعوں": "قلع",
  "قلہ": "قلہ",
  "قلمکار": "قلمکار",
  "قلمکارو": "قلمکار",
  "قلمکاروں": "قلمکار",
  "قلو": "قلہ",
  "قلوں": "قلہ",
  "قلی": "قلی",
  "قلیو": "قلی",
  "قلیوں": "قلی",
  "قمری": "قمری",
  "قمریو": "قمری",
  "قمریوں": "قمری",
  "قمیض": "قمیض",
  "قمیضو": "قمیض",
  "قمیضوں": "قمیض",
  "قمیضیں": "قمیض",
  "قنات": "قنات",
  "قناتو": "قنات",
  "قناتوں": "قنات",
  "قناتیں": "قنات",
  "قندیل": "قندیل",
  "قندیلو": "قندیل",
  "قندیلوں": "قندیل",
  "قندیلیں": "قندیل",
  "قرابت": "قرابت",
  "قرابتو": "قرابت",
  "قرابتوں": "قرابت",
  "قرابتیں": "قرابت",
  "قرارداد": "قرارداد",
  "قراردادو": "قرارداد",
  "قراردادوں": "قرارداد",
  "قراردادیں": "قرارداد",
  "قربانی": "قربانی",
  "قربانیاں": "قربانی",
  "قربانیو": "قربانی",
  "قربانیوں": "قربانی",
  "قریے": "قریہ",
  "قریہ": "قریہ",
  "قریو": "قریہ",
  "قریوں": "قریہ",
  "قرض": "قرض",
  "قرضے": "قرضہ",
  "قرضہ": "قرضہ",
  "قرضو": "قرضہ",
  "قرضوں": "قرضہ",
  "قسم": "قسم",
  "قسمو": "قسم",
  "قسموں": "قسم",
  "قسمیں": "قسم",
  "قسط": "قسط",
  "قسطو": "قسط",
  "قسطوں": "قسط",
  "قسطیں": "قسط",
  "قتل": "قتل",
  "قتلے": "قتلہ",
  "قتلہ": "قتلہ",
  "قتلو": "قتلہ",
  "قتلوں": "قتلہ",
  "قوّت": "قوّت",
  "قوّتو": "قوّت",
  "قوّتوں": "قوّت",
  "قوّتیں": "قوّت",
  "قوال": "قوال",
  "قوالو": "قوال",
  "قوالوں": "قوال",
  "قوم": "قوم",
  "قومے": "قومہ",
  "قومہ": "قومہ",
  "قومو": "قومہ",
  "قوموں": "قومہ",
  "قومیں": "قوم",
  "قومیت": "قومیت",
  "قومیتو": "قومیت",
  "قومیتوں": "قومیت",
  "قومیتیں": "قومیت",
  "قورمے": "قورمہ",
  "قورمہ": "قورمہ",
  "قورمو": "قورمہ",
  "قورموں": "قورمہ",
  "قوس": "قوس",
  "قوسو": "قوس",
  "قوسوں": "قوس",
  "قوسیں": "قوس",
  "قوت": "قوت",
  "قوتو": "قوت",
  "قوتوں": "قوت",
  "قوتیں": "قوت",
  "قید": "قید",
  "قیدو": "قید",
  "قیدوں": "قید",
  "قیدی": "قیدی",
  "قیدیں": "قید",
  "قیدیو": "قیدی",
  "قیدیوں": "قیدی",
  "قیمت": "قیمت",
  "قیمتو": "قیمت",
  "قیمتوں": "قیمت",
  "قیمتیں": "قیمت",
  "قزاق": "قزاق",
  "قزاقو": "قزاق",
  "قزاقوں": "قزاق",
  "قضیے": "قضیہ",
  "قضیہ": "قضیہ",
  "قضیو": "قضیہ",
  "قضیوں": "قضیہ",
  "قطار": "قطار",
  "قطارو": "قطار",
  "قطاروں": "قطار",
  "قطاریں": "قطار",
  "قطع": "قطع",
  "قطعے": "قطع",
  "قطعہ": "قطعہ",
  "قطعو": "قطع",
  "قطعوں": "قطع",
  "قطر": "قطر",
  "قطرے": "قطرہ",
  "قطرہ": "قطرہ",
  "قطرو": "قطرہ",
  "قطروں": "قطرہ",
  "قطریں": "قطر",
  "رَو": "رَونا",
  "رَونے": "رَونا",
  "رَونا": "رَونا",
  "رَونی": "رَونا",
  "رَوتے": "رَونا",
  "رَوتا": "رَونا",
  "رَوتی": "رَونا",
  "رَوتیں": "رَونا",
  "رَوؤ": "رَونا",
  "رَوؤں": "رَونا",
  "رَوئے": "رَونا",
  "رَوئی": "رَونا",
  "رَوئیے": "رَونا",
  "رَوئیں": "رَونا",
  "رَویا": "رَونا",
  "رِس": "رِسنا",
  "رِسے": "رِسنا",
  "رِسں": "رِسنا",
  "رِسا": "رِسنا",
  "رِسنے": "رِسنا",
  "رِسنا": "رِسنا",
  "رِسنی": "رِسنا",
  "رِستے": "رِسنا",
  "رِستا": "رِسنا",
  "رِستی": "رِسنا",
  "رِستیں": "رِسنا",
  "رِسو": "رِسنا",
  "رِسوں": "رِسنا",
  "رِسوا": "رِسنا",
  "رِسوانے": "رِسنا",
  "رِسوانا": "رِسنا",
  "رِسواتے": "رِسنا",
  "رِسواتا": "رِسنا",
  "رِسواتی": "رِسنا",
  "رِسواتیں": "رِسنا",
  "رِسواؤ": "رِسنا",
  "رِسواؤں": "رِسنا",
  "رِسوائے": "رِسنا",
  "رِسوائی": "رِسنا",
  "رِسوائیے": "رِسنا",
  "رِسوائیں": "رِسنا",
  "رِسوایا": "رِسنا",
  "رِسی": "رِسنا",
  "رِسیے": "رِسنا",
  "رِسیں": "رِسنا",
  "رِیا": "رِیا",
  "رِیاؤں": "رِیا",
  "رِیائیں": "رِیا",
  "رُک": "رُکنا",
  "رُکے": "رُکنا",
  "رُکں": "رُکنا",
  "رُکا": "رُکنا",
  "رُکانے": "رُکنا",
  "رُکانا": "رُکنا",
  "رُکاتے": "رُکنا",
  "رُکاتا": "رُکنا",
  "رُکاتی": "رُکنا",
  "رُکاتیں": "رُکنا",
  "رُکاؤ": "رُکنا",
  "رُکاؤں": "رُکنا",
  "رُکائے": "رُکنا",
  "رُکائی": "رُکنا",
  "رُکائیے": "رُکنا",
  "رُکائیں": "رُکنا",
  "رُکایا": "رُکنا",
  "رُکنے": "رُکنا",
  "رُکنا": "رُکنا",
  "رُکنی": "رُکنا",
  "رُکتے": "رُکنا",
  "رُکتا": "رُکنا",
  "رُکتی": "رُکنا",
  "رُکتیں": "رُکنا",
  "رُکو": "رُکنا",
  "رُکوں": "رُکنا",
  "رُکوا": "رُکنا",
  "رُکوانے": "رُکنا",
  "رُکوانا": "رُکنا",
  "رُکواتے": "رُکنا",
  "رُکواتا": "رُکنا",
  "رُکواتی": "رُکنا",
  "رُکواتیں": "رُکنا",
  "رُکواؤ": "رُکنا",
  "رُکواؤں": "رُکنا",
  "رُکوائے": "رُکنا",
  "رُکوائی": "رُکنا",
  "رُکوائیے": "رُکنا",
  "رُکوائیں": "رُکنا",
  "رُکوایا": "رُکنا",
  "رُکی": "رُکنا",
  "رُکیے": "رُکنا",
  "رُکیں": "رُکنا",
  "رُلْوا": "رَونا",
  "رُلْوانے": "رَونا",
  "رُلْوانا": "رَونا",
  "رُلْواتے": "رَونا",
  "رُلْواتا": "رَونا",
  "رُلْواتی": "رَونا",
  "رُلْواتیں": "رَونا",
  "رُلْواؤ": "رَونا",
  "رُلْواؤں": "رَونا",
  "رُلْوائے": "رَونا",
  "رُلْوائی": "رَونا",
  "رُلْوائیے": "رَونا",
  "رُلْوائیں": "رَونا",
  "رُلْوایا": "رَونا",
  "رُلا": "رَونا",
  "رُلانے": "رَونا",
  "رُلانا": "رَونا",
  "رُلانی": "رُلانا",
  "رُلاتے": "رَونا",
  "رُلاتا": "رَونا",
  "رُلاتی": "رَونا",
  "رُلاتیں": "رَونا",
  "رُلاؤ": "رَونا",
  "رُلاؤں": "رَونا",
  "رُلائے": "رَونا",
  "رُلائی": "رَونا",
  "رُلائیے": "رَونا",
  "رُلائیں": "رَونا",
  "رُلایا": "رَونا",
  "رُلوا": "رُلانا",
  "رُلوانے": "رُلانا",
  "رُلوانا": "رُلانا",
  "رُلواتے": "رُلانا",
  "رُلواتا": "رُلانا",
  "رُلواتی": "رُلانا",
  "رُلواتیں": "رُلانا",
  "رُلواؤ": "رُلانا",
  "رُلواؤں": "رُلانا",
  "رُلوائے": "رُلانا",
  "رُلوائی": "رُلانا",
  "رُلوائیے": "رُلانا",
  "رُلوائیں": "رُلانا",
  "رُلوایا": "رُلانا",
  "رُس": "رُسنا",
  "رُسے": "رُسنا",
  "رُسں": "رُسنا",
  "رُسا": "رُسنا",
  "رُسانے": "رُسنا",
  "رُسانا": "رُسنا",
  "رُساتے": "رُسنا",
  "رُساتا": "رُسنا",
  "رُساتی": "رُسنا",
  "رُساتیں": "رُسنا",
  "رُساؤ": "رُسنا",
  "رُساؤں": "رُسنا",
  "رُسائے": "رُسنا",
  "رُسائی": "رُسنا",
  "رُسائیے": "رُسنا",
  "رُسائیں": "رُسنا",
  "رُسایا": "رُسنا",
  "رُسنے": "رُسنا",
  "رُسنا": "رُسنا",
  "رُسنی": "رُسنا",
  "رُستے": "رُسنا",
  "رُستا": "رُسنا",
  "رُستی": "رُسنا",
  "رُستیں": "رُسنا",
  "رُسو": "رُسنا",
  "رُسوں": "رُسنا",
  "رُسوا": "رُسنا",
  "رُسوانے": "رُسنا",
  "رُسوانا": "رُسنا",
  "رُسواتے": "رُسنا",
  "رُسواتا": "رُسنا",
  "رُسواتی": "رُسنا",
  "رُسواتیں": "رُسنا",
  "رُسواؤ": "رُسنا",
  "رُسواؤں": "رُسنا",
  "رُسوائے": "رُسنا",
  "رُسوائی": "رُسنا",
  "رُسوائیے": "رُسنا",
  "رُسوائیں": "رُسنا",
  "رُسوایا": "رُسنا",
  "رُسی": "رُسنا",
  "رُسیے": "رُسنا",
  "رُسیں": "رُسنا",
  "رُوح": "رُوح",
  "رُوحو": "رُوح",
  "رُوحوں": "رُوح",
  "رُوحیں": "رُوح",
  "رحم": "رحم",
  "رحمت": "رحمت",
  "رحمتو": "رحمت",
  "رحمتوں": "رحمت",
  "رحمتیں": "رحمت",
  "رحمو": "رحم",
  "رحموں": "رحم",
  "رخنے": "رخنہ",
  "رخنہ": "رخنہ",
  "رخنو": "رخنہ",
  "رخنوں": "رخنہ",
  "رخسار": "رخسار",
  "رخسارو": "رخسار",
  "رخساروں": "رخسار",
  "رش": "رش",
  "رشت": "رشت",
  "رشتے": "رشتہ",
  "رشتےدار": "رشتےدار",
  "رشتےدارو": "رشتےدار",
  "رشتےداروں": "رشتےدار",
  "رشتہ": "رشتہ",
  "رشتو": "رشتہ",
  "رشتوں": "رشتہ",
  "رشتیں": "رشت",
  "رشو": "رش",
  "رشوں": "رش",
  "راحت": "راحت",
  "راحتو": "راحت",
  "راحتوں": "راحت",
  "راحتیں": "راحت",
  "رابط": "رابط",
  "رابطے": "رابطہ",
  "رابطہ": "رابطہ",
  "رابطو": "رابطہ",
  "رابطوں": "رابطہ",
  "رابطیں": "رابط",
  "راگنی": "راگنی",
  "راگنیاں": "راگنی",
  "راگنیو": "راگنی",
  "راگنیوں": "راگنی",
  "راہ": "راہ",
  "راہب": "راہب",
  "راہبو": "راہب",
  "راہبوں": "راہب",
  "راہدارؤں": "راہداری",
  "راہداری": "راہداری",
  "راہدارئیں": "راہداری",
  "راہداریاں": "راہداری",
  "راہداریو": "راہداری",
  "راہداریوں": "راہداری",
  "راہو": "راہ",
  "راہوں": "راہ",
  "راہی": "راہی",
  "راہیں": "راہ",
  "راہیو": "راہی",
  "راہیوں": "راہی",
  "راج": "راج",
  "راجے": "راجہ",
  "راجا": "راجا",
  "راجاؤ": "راجا",
  "راجاؤں": "راجا",
  "راجائیں": "راجا",
  "راجہ": "راجہ",
  "راجپوت": "راجپوت",
  "راجپوتو": "راجپوت",
  "راجپوتوں": "راجپوت",
  "راجپوتیں": "راجپوت",
  "راجو": "راجہ",
  "راجوں": "راجہ",
  "ران": "ران",
  "رانو": "ران",
  "رانوں": "ران",
  "رانی": "رانی",
  "رانیں": "ران",
  "رانیاں": "رانی",
  "رانیو": "رانی",
  "رانیوں": "رانی",
  "راست": "راست",
  "راستے": "راستہ",
  "راستہ": "راستہ",
  "راستو": "راستہ",
  "راستوں": "راستہ",
  "راستیں": "راست",
  "رات": "رات",
  "راتو": "رات",
  "راتوں": "رات",
  "راتیں": "رات",
  "راؤ": "راؤ",
  "راوی": "راوی",
  "راویو": "راوی",
  "راویوں": "راوی",
  "رائٹر": "رائٹر",
  "رائٹرو": "رائٹر",
  "رائٹروں": "رائٹر",
  "رائفل": "رائفل",
  "رائفلو": "رائفل",
  "رائفلوں": "رائفل",
  "رائفلیں": "رائفل",
  "رائتے": "رائتہ",
  "رائتہ": "رائتہ",
  "رائتو": "رائتہ",
  "رائتوں": "رائتہ",
  "راز": "راز",
  "رازو": "راز",
  "رازوں": "راز",
  "رب": "رب",
  "ربر": "ربر",
  "ربرو": "ربر",
  "ربروں": "ربر",
  "ربریں": "ربر",
  "ربو": "رب",
  "ربوں": "رب",
  "رچ": "رچنا",
  "رچے": "رچنا",
  "رچں": "رچنا",
  "رچا": "رچنا",
  "رچانے": "رچنا",
  "رچانا": "رچنا",
  "رچاتے": "رچنا",
  "رچاتا": "رچنا",
  "رچاتی": "رچنا",
  "رچاتیں": "رچنا",
  "رچاؤ": "رچنا",
  "رچاؤں": "رچنا",
  "رچائے": "رچنا",
  "رچائی": "رچنا",
  "رچائیے": "رچنا",
  "رچائیں": "رچنا",
  "رچایا": "رچنا",
  "رچنے": "رچنا",
  "رچنا": "رچنا",
  "رچنی": "رچنا",
  "رچتے": "رچنا",
  "رچتا": "رچنا",
  "رچتی": "رچنا",
  "رچتیں": "رچنا",
  "رچو": "رچنا",
  "رچوں": "رچنا",
  "رچوا": "رچنا",
  "رچوانے": "رچنا",
  "رچوانا": "رچنا",
  "رچواتے": "رچنا",
  "رچواتا": "رچنا",
  "رچواتی": "رچنا",
  "رچواتیں": "رچنا",
  "رچواؤ": "رچنا",
  "رچواؤں": "رچنا",
  "رچوائے": "رچنا",
  "رچوائی": "رچنا",
  "رچوائیے": "رچنا",
  "رچوائیں": "رچنا",
  "رچوایا": "رچنا",
  "رچی": "رچنا",
  "رچیے": "رچنا",
  "رچیں": "رچنا",
  "ردیف": "ردیف",
  "ردیفو": "ردیف",
  "ردیفوں": "ردیف",
  "ردیفیں": "ردیف",
  "رعایت": "رعایت",
  "رعایتو": "رعایت",
  "رعایتوں": "رعایت",
  "رعایتیں": "رعایت",
  "رعنائی": "رعنائی",
  "رعنائیاں": "رعنائی",
  "رعنائیو": "رعنائی",
  "رعنائیوں": "رعنائی",
  "رعنائییں": "رعنائی",
  "رفاقت": "رفاقت",
  "رفاقتو": "رفاقت",
  "رفاقتوں": "رفاقت",
  "رفاقتیں": "رفاقت",
  "رفتگی": "رفتگی",
  "رفتگیاں": "رفتگی",
  "رفتگیو": "رفتگی",
  "رفتگیوں": "رفتگی",
  "رفیق": "رفیق",
  "رفیقو": "رفیق",
  "رفیقوں": "رفیق",
  "رگ": "رگ",
  "رگڑ": "رگڑنا",
  "رگڑے": "رگڑنا",
  "رگڑں": "رگڑنا",
  "رگڑا": "رگڑنا",
  "رگڑانے": "رگڑنا",
  "رگڑانا": "رگڑنا",
  "رگڑاتے": "رگڑنا",
  "رگڑاتا": "رگڑنا",
  "رگڑاتی": "رگڑنا",
  "رگڑاتیں": "رگڑنا",
  "رگڑاؤ": "رگڑنا",
  "رگڑاؤں": "رگڑنا",
  "رگڑائے": "رگڑنا",
  "رگڑائی": "رگڑنا",
  "رگڑائیے": "رگڑنا",
  "رگڑائیں": "رگڑنا",
  "رگڑایا": "رگڑنا",
  "رگڑنے": "رگڑنا",
  "رگڑنا": "رگڑنا",
  "رگڑنی": "رگڑنا",
  "رگڑتے": "رگڑنا",
  "رگڑتا": "رگڑنا",
  "رگڑتی": "رگڑنا",
  "رگڑتیں": "رگڑنا",
  "رگڑو": "رگڑنا",
  "رگڑوں": "رگڑنا",
  "رگڑوا": "رگڑنا",
  "رگڑوانے": "رگڑنا",
  "رگڑوانا": "رگڑنا",
  "رگڑواتے": "رگڑنا",
  "رگڑواتا": "رگڑنا",
  "رگڑواتی": "رگڑنا",
  "رگڑواتیں": "رگڑنا",
  "رگڑواؤ": "رگڑنا",
  "رگڑواؤں": "رگڑنا",
  "رگڑوائے": "رگڑنا",
  "رگڑوائی": "رگڑنا",
  "رگڑوائیے": "رگڑنا",
  "رگڑوائیں": "رگڑنا",
  "رگڑوایا": "رگڑنا",
  "رگڑی": "رگڑنا",
  "رگڑیے": "رگڑنا",
  "رگڑیں": "رگڑنا",
  "رگو": "رگ",
  "رگوں": "رگ",
  "رگیں": "رگ",
  "رگید": "رگیدنا",
  "رگیدے": "رگیدنا",
  "رگیدں": "رگیدنا",
  "رگیدا": "رگیدنا",
  "رگیدنے": "رگیدنا",
  "رگیدنا": "رگیدنا",
  "رگیدنی": "رگیدنا",
  "رگیدتے": "رگیدنا",
  "رگیدتا": "رگیدنا",
  "رگیدتی": "رگیدنا",
  "رگیدتیں": "رگیدنا",
  "رگیدو": "رگیدنا",
  "رگیدوں": "رگیدنا",
  "رگیدوا": "رگیدنا",
  "رگیدوانے": "رگیدنا",
  "رگیدوانا": "رگیدنا",
  "رگیدواتے": "رگیدنا",
  "رگیدواتا": "رگیدنا",
  "رگیدواتی": "رگیدنا",
  "رگیدواتیں": "رگیدنا",
  "رگیدواؤ": "رگیدنا",
  "رگیدواؤں": "رگیدنا",
  "رگیدوائے": "رگیدنا",
  "رگیدوائی": "رگیدنا",
  "رگیدوائیے": "رگیدنا",
  "رگیدوائیں": "رگیدنا",
  "رگیدوایا": "رگیدنا",
  "رگیدی": "رگیدنا",
  "رگیدیے": "رگیدنا",
  "رگیدیں": "رگیدنا",
  "رہ": "رہنا",
  "رہے": "رہنا",
  "رہں": "رہنا",
  "رہا": "رہنا",
  "رہائش": "رہائش",
  "رہائشو": "رہائش",
  "رہائشوں": "رہائش",
  "رہائشی": "رہائشی",
  "رہائشیں": "رہائش",
  "رہائشیاں": "رہائشی",
  "رہائشیو": "رہائشی",
  "رہائشیوں": "رہائشی",
  "رہنے": "رہنا",
  "رہنا": "رہنا",
  "رہنما": "رہنما",
  "رہنماؤ": "رہنما",
  "رہنماؤں": "رہنما",
  "رہنی": "رہنا",
  "رہرو": "رہرو",
  "رہروؤ": "رہرو",
  "رہروؤں": "رہرو",
  "رہت": "رہت",
  "رہتے": "رہنا",
  "رہتا": "رہنا",
  "رہتو": "رہت",
  "رہتوں": "رہت",
  "رہتی": "رہنا",
  "رہتیں": "رہت",
  "رہو": "رہنا",
  "رہوں": "رہنا",
  "رہی": "رہنا",
  "رہیے": "رہنا",
  "رہیں": "رہنا",
  "رجحان": "رجحان",
  "رجحانات": "رجحان",
  "رجحانو": "رجحان",
  "رجحانوں": "رجحان",
  "رجسٹر": "رجسٹر",
  "رجسٹرو": "رجسٹر",
  "رجسٹروں": "رجسٹر",
  "رک": "رکنا",
  "رکے": "رکنا",
  "رکں": "رکنا",
  "رکشا": "رکشا",
  "رکشاؤ": "رکشا",
  "رکشاؤں": "رکشا",
  "رکشائیں": "رکشا",
  "رکا": "رکنا",
  "رکاب": "رکاب",
  "رکابو": "رکاب",
  "رکابوں": "رکاب",
  "رکابیں": "رکاب",
  "رکانے": "رکنا",
  "رکانا": "رکنا",
  "رکاتے": "رکنا",
  "رکاتا": "رکنا",
  "رکاتی": "رکنا",
  "رکاتیں": "رکنا",
  "رکاوٹ": "رکاوٹ",
  "رکاوٹو": "رکاوٹ",
  "رکاوٹوں": "رکاوٹ",
  "رکاوٹیں": "رکاوٹ",
  "رکاؤ": "رکنا",
  "رکاؤں": "رکنا",
  "رکائے": "رکنا",
  "رکائی": "رکنا",
  "رکائیے": "رکنا",
  "رکائیں": "رکنا",
  "رکایا": "رکنا",
  "رکعت": "رکعت",
  "رکعتو": "رکعت",
  "رکعتوں": "رکعت",
  "رکعتیں": "رکعت",
  "رکنے": "رکنا",
  "رکنا": "رکنا",
  "رکنی": "رکنا",
  "رکتے": "رکنا",
  "رکتا": "رکنا",
  "رکتی": "رکنا",
  "رکتیں": "رکنا",
  "رکو": "رکنا",
  "رکوں": "رکنا",
  "رکوا": "رکنا",
  "رکوانے": "رکنا",
  "رکوانا": "رکنا",
  "رکواتے": "رکنا",
  "رکواتا": "رکنا",
  "رکواتی": "رکنا",
  "رکواتیں": "رکنا",
  "رکواؤ": "رکنا",
  "رکواؤں": "رکنا",
  "رکوائے": "رکنا",
  "رکوائی": "رکنا",
  "رکوائیے": "رکنا",
  "رکوائیں": "رکنا",
  "رکوایا": "رکنا",
  "رکی": "رکنا",
  "رکیے": "رکنا",
  "رکیں": "رکنا",
  "رکھ": "رکھنا",
  "رکھے": "رکھنا",
  "رکھں": "رکھنا",
  "رکھا": "رکھا",
  "رکھانے": "رکھنا",
  "رکھانا": "رکھنا",
  "رکھاتے": "رکھنا",
  "رکھاتا": "رکھنا",
  "رکھاتی": "رکھنا",
  "رکھاتیں": "رکھنا",
  "رکھاؤ": "رکھا",
  "رکھاؤں": "رکھا",
  "رکھائے": "رکھنا",
  "رکھائی": "رکھنا",
  "رکھائیے": "رکھنا",
  "رکھائیں": "رکھا",
  "رکھایا": "رکھنا",
  "رکھنے": "رکھنا",
  "رکھنا": "رکھنا",
  "رکھنی": "رکھنا",
  "رکھت": "رکھت",
  "رکھتے": "رکھنا",
  "رکھتا": "رکھنا",
  "رکھتو": "رکھت",
  "رکھتوں": "رکھت",
  "رکھتی": "رکھنا",
  "رکھتیں": "رکھت",
  "رکھو": "رکھنا",
  "رکھوں": "رکھنا",
  "رکھوا": "رکھنا",
  "رکھوانے": "رکھنا",
  "رکھوانا": "رکھنا",
  "رکھواتے": "رکھنا",
  "رکھواتا": "رکھنا",
  "رکھواتی": "رکھنا",
  "رکھواتیں": "رکھنا",
  "رکھواؤ": "رکھنا",
  "رکھواؤں": "رکھنا",
  "رکھوائے": "رکھنا",
  "رکھوائی": "رکھنا",
  "رکھوائیے": "رکھنا",
  "رکھوائیں": "رکھنا",
  "رکھوایا": "رکھنا",
  "رکھی": "رکھنا",
  "رکھیے": "رکھنا",
  "رکھیں": "رکھنا",
  "رل": "رلنا",
  "رلے": "رلنا",
  "رلں": "رلنا",
  "رلا": "رلنا",
  "رلانے": "رلنا",
  "رلانا": "رلنا",
  "رلاتے": "رلنا",
  "رلاتا": "رلنا",
  "رلاتی": "رلنا",
  "رلاتیں": "رلنا",
  "رلاؤ": "رلنا",
  "رلاؤں": "رلنا",
  "رلائے": "رلنا",
  "رلائی": "رلنا",
  "رلائیے": "رلنا",
  "رلائیں": "رلنا",
  "رلایا": "رلنا",
  "رلنے": "رلنا",
  "رلنا": "رلنا",
  "رلنی": "رلنا",
  "رلتے": "رلنا",
  "رلتا": "رلنا",
  "رلتی": "رلنا",
  "رلتیں": "رلنا",
  "رلو": "رلنا",
  "رلوں": "رلنا",
  "رلوا": "رلنا",
  "رلوانے": "رلنا",
  "رلوانا": "رلنا",
  "رلواتے": "رلنا",
  "رلواتا": "رلنا",
  "رلواتی": "رلنا",
  "رلواتیں": "رلنا",
  "رلواؤ": "رلنا",
  "رلواؤں": "رلنا",
  "رلوائے": "رلنا",
  "رلوائی": "رلنا",
  "رلوائیے": "رلنا",
  "رلوائیں": "رلنا",
  "رلوایا": "رلنا",
  "رلی": "رلنا",
  "رلیے": "رلنا",
  "رلیں": "رلنا",
  "رنڈی": "رنڈی",
  "رنڈیاں": "رنڈی",
  "رنڈیو": "رنڈی",
  "رنڈیوں": "رنڈی",
  "رندے": "رندا",
  "رندا": "رندا",
  "رندہ": "رندہ",
  "رندو": "رندا",
  "رندوں": "رندا",
  "رنگ": "رنگ",
  "رنگے": "رنگنا",
  "رنگں": "رنگنا",
  "رنگا": "رنگنا",
  "رنگانے": "رنگنا",
  "رنگانا": "رنگنا",
  "رنگاتے": "رنگنا",
  "رنگاتا": "رنگنا",
  "رنگاتی": "رنگنا",
  "رنگاتیں": "رنگنا",
  "رنگاؤ": "رنگنا",
  "رنگاؤں": "رنگنا",
  "رنگائے": "رنگنا",
  "رنگائی": "رنگنا",
  "رنگائیے": "رنگنا",
  "رنگائیں": "رنگنا",
  "رنگایا": "رنگنا",
  "رنگنے": "رنگنا",
  "رنگنا": "رنگنا",
  "رنگنی": "رنگنا",
  "رنگتے": "رنگنا",
  "رنگتا": "رنگنا",
  "رنگتی": "رنگنا",
  "رنگتیں": "رنگنا",
  "رنگو": "رنگ",
  "رنگوں": "رنگ",
  "رنگوا": "رنگنا",
  "رنگوانے": "رنگنا",
  "رنگوانا": "رنگنا",
  "رنگواتے": "رنگنا",
  "رنگواتا": "رنگنا",
  "رنگواتی": "رنگنا",
  "رنگواتیں": "رنگنا",
  "رنگواؤ": "رنگنا",
  "رنگواؤں": "رنگنا",
  "رنگوائے": "رنگنا",
  "رنگوائی": "رنگنا",
  "رنگوائیے": "رنگنا",
  "رنگوائیں": "رنگنا",
  "رنگوایا": "رنگنا",
  "رنگی": "رنگنا",
  "رنگیے": "رنگنا",
  "رنگیں": "رنگنا",
  "رنگینی": "رنگینی",
  "رنگینیاں": "رنگینی",
  "رنگینیو": "رنگینی",
  "رنگینیوں": "رنگینی",
  "رنجش": "رنجش",
  "رنجشو": "رنجش",
  "رنجشوں": "رنجش",
  "رنجشیں": "رنجش",
  "رپورٹ": "رپورٹ",
  "رپورٹو": "رپورٹ",
  "رپورٹوں": "رپورٹ",
  "رپورٹیں": "رپورٹ",
  "رقعے": "رقعہ",
  "رقعہ": "رقعہ",
  "رقعو": "رقعہ",
  "رقعوں": "رقعہ",
  "رقیب": "رقیب",
  "رقیبو": "رقیب",
  "رقیبوں": "رقیب",
  "رس": "رسنا",
  "رسّی": "رسّی",
  "رسّیاں": "رسّی",
  "رسّیو": "رسّی",
  "رسّیوں": "رسّی",
  "رسے": "رسا",
  "رسں": "رسنا",
  "رسا": "رسا",
  "رسالے": "رسالہ",
  "رسالہ": "رسالہ",
  "رسالو": "رسالہ",
  "رسالوں": "رسالہ",
  "رسانے": "رسنا",
  "رسانا": "رسنا",
  "رسانی": "رسانی",
  "رسانیاں": "رسانی",
  "رسانیو": "رسانی",
  "رسانیوں": "رسانی",
  "رساتے": "رسنا",
  "رساتا": "رسنا",
  "رساتی": "رسنا",
  "رساتیں": "رسنا",
  "رساؤ": "رسنا",
  "رساؤں": "رسنا",
  "رسائے": "رسنا",
  "رسائی": "رسنا",
  "رسائیے": "رسنا",
  "رسائیں": "رسنا",
  "رسایا": "رسنا",
  "رسہ": "رسہ",
  "رسم": "رسم",
  "رسمو": "رسم",
  "رسموں": "رسم",
  "رسمیں": "رسم",
  "رسنے": "رسنا",
  "رسنا": "رسنا",
  "رسنی": "رسنا",
  "رست": "رست",
  "رستے": "رستا",
  "رستا": "رستا",
  "رستہ": "رستہ",
  "رستو": "رستا",
  "رستوں": "رستا",
  "رستی": "رسنا",
  "رستیں": "رست",
  "رسو": "رسا",
  "رسوں": "رسا",
  "رسوا": "رسنا",
  "رسوانے": "رسنا",
  "رسوانا": "رسنا",
  "رسواتے": "رسنا",
  "رسواتا": "رسنا",
  "رسواتی": "رسنا",
  "رسواتیں": "رسنا",
  "رسواؤ": "رسنا",
  "رسواؤں": "رسنا",
  "رسوائے": "رسنا",
  "رسوائی": "رسنا",
  "رسوائیے": "رسنا",
  "رسوائیں": "رسنا",
  "رسوایا": "رسنا",
  "رسول": "رسول",
  "رسولو": "رسول",
  "رسولوں": "رسول",
  "رسی": "رسی",
  "رسیے": "رسنا",
  "رسیں": "رسنا",
  "رسیا": "رسیا",
  "رسیاں": "رسی",
  "رسید": "رسید",
  "رسیدے": "رسیدہ",
  "رسیدہ": "رسیدہ",
  "رسیدو": "رسیدہ",
  "رسیدوں": "رسیدہ",
  "رسیدیں": "رسید",
  "رسیو": "رسی",
  "رسیوں": "رسی",
  "رت": "رت",
  "رتبے": "رتبہ",
  "رتبہ": "رتبہ",
  "رتبو": "رتبہ",
  "رتبوں": "رتبہ",
  "رتو": "رت",
  "رتوں": "رت",
  "رتیں": "رت",
  "رو": "رونا",
  "روّیے": "روّیہ",
  "روّیہ": "روّیہ",
  "روّیو": "روّیہ",
  "روّیوں": "روّیہ",
  "روح": "روح",
  "روحو": "روح",
  "روحوں": "روح",
  "روحیں": "روح",
  "روڑ": "روڑ",
  "روڑے": "روڑا",
  "روڑا": "روڑا",
  "روڑو": "روڑا",
  "روڑوں": "روڑا",
  "روڑیں": "روڑ",
  "روٹی": "روٹی",
  "روٹیاں": "روٹی",
  "روٹیو": "روٹی",
  "روٹیوں": "روٹی",
  "روشن": "روشن",
  "روشنو": "روشن",
  "روشنوں": "روشن",
  "روشنی": "روشنی",
  "روشنیاں": "روشنی",
  "روشنیو": "روشنی",
  "روشنیوں": "روشنی",
  "رواں": "رواں",
  "رواج": "رواج",
  "رواجو": "رواج",
  "رواجوں": "رواج",
  "روایت": "روایت",
  "روایتو": "روایت",
  "روایتوں": "روایت",
  "روایتیں": "روایت",
  "روہیل": "روہیل",
  "روہیلہ": "روہیلہ",
  "روہیلو": "روہیل",
  "روہیلوں": "روہیل",
  "روک": "روکنا",
  "روکے": "روکنا",
  "روکں": "روکنا",
  "روکا": "روکنا",
  "روکنے": "روکنا",
  "روکنا": "روکنا",
  "روکنی": "روکنا",
  "روکتے": "روکنا",
  "روکتا": "روکنا",
  "روکتی": "روکنا",
  "روکتیں": "روکنا",
  "روکو": "روکنا",
  "روکوں": "روکنا",
  "روکوا": "روکنا",
  "روکوانے": "روکنا",
  "روکوانا": "روکنا",
  "روکواتے": "روکنا",
  "روکواتا": "روکنا",
  "روکواتی": "روکنا",
  "روکواتیں": "روکنا",
  "روکواؤ": "روکنا",
  "روکواؤں": "روکنا",
  "روکوائے": "روکنا",
  "روکوائی": "روکنا",
  "روکوائیے": "روکنا",
  "روکوائیں": "روکنا",
  "روکوایا": "روکنا",
  "روکی": "روکنا",
  "روکیے": "روکنا",
  "روکیں": "روکنا",
  "رومال": "رومال",
  "رومالو": "رومال",
  "رومالوں": "رومال",
  "رومالیں": "رومال",
  "رونے": "رونا",
  "رونا": "رونا",
  "رونق": "رونق",
  "رونقو": "رونق",
  "رونقوں": "رونق",
  "رونقیں": "رونق",
  "رونی": "رونا",
  "روپ": "روپ",
  "روپہ": "روپہ",
  "روپو": "روپ",
  "روپوں": "روپ",
  "روپیے": "روپیہ",
  "روپیا": "روپیا",
  "روپیاں": "روپیا",
  "روپیہ": "روپیہ",
  "روپیو": "روپیہ",
  "روپیوں": "روپیہ",
  "روسی": "روسی",
  "روسیو": "روسی",
  "روسیوں": "روسی",
  "روتے": "رونا",
  "روتا": "رونا",
  "روتی": "رونا",
  "روتیں": "رونا",
  "رووںں": "رواں",
  "روؤ": "رونا",
  "روؤں": "رونا",
  "روی": "روی",
  "رویے": "رویہ",
  "رویں": "رواں",
  "روئے": "رونا",
  "روئی": "رونا",
  "روئیے": "رونا",
  "روئیں": "رونا",
  "رویا": "رونا",
  "رویہ": "رویہ",
  "رویو": "رویہ",
  "رویوں": "رویہ",
  "روزے": "روزا",
  "روزا": "روزا",
  "روزہ": "روزہ",
  "روزنامے": "روزنامہ",
  "روزنامچے": "روزنامچہ",
  "روزنامچہ": "روزنامچہ",
  "روزنامچو": "روزنامچہ",
  "روزنامچوں": "روزنامچہ",
  "روزنامہ": "روزنامہ",
  "روزنامو": "روزنامہ",
  "روزناموں": "روزنامہ",
  "روزو": "روزا",
  "روزوں": "روزا",
  "ریختے": "ریختہ",
  "ریختہ": "ریختہ",
  "ریختو": "ریختہ",
  "ریختوں": "ریختہ",
  "ریشے": "ریشہ",
  "ریشہ": "ریشہ",
  "ریشو": "ریشہ",
  "ریشوں": "ریشہ",
  "رئیس": "رئیس",
  "رئیسو": "رئیس",
  "رئیسوں": "رئیس",
  "ریاکار": "ریاکار",
  "ریاکارو": "ریاکار",
  "ریاکاروں": "ریاکار",
  "ریاست": "ریاست",
  "ریاستو": "ریاست",
  "ریاستوں": "ریاست",
  "ریاستیں": "ریاست",
  "ریگستان": "ریگستان",
  "ریگستانو": "ریگستان",
  "ریگستانوں": "ریگستان",
  "ریل": "ریل",
  "ریلے": "ریلا",
  "ریلا": "ریلا",
  "ریلو": "ریلا",
  "ریلوں": "ریلا",
  "ریلی": "ریلی",
  "ریلیں": "ریل",
  "ریلیاں": "ریلی",
  "ریلیو": "ریلی",
  "ریلیوں": "ریلی",
  "ریس": "ریس",
  "ریستوران": "ریستوران",
  "ریستورانو": "ریستوران",
  "ریستورانوں": "ریستوران",
  "ریسو": "ریس",
  "ریسوں": "ریس",
  "ریسیں": "ریس",
  "ریوڑ": "ریوڑ",
  "ریوڑو": "ریوڑ",
  "ریوڑوں": "ریوڑ",
  "ریوڑی": "ریوڑی",
  "ریوڑیاں": "ریوڑی",
  "ریوڑیو": "ریوڑی",
  "ریوڑیوں": "ریوڑی",
  "ریزے": "ریزہ",
  "ریزہ": "ریزہ",
  "ریزر": "ریزر",
  "ریزرو": "ریزر",
  "ریزروں": "ریزر",
  "ریزو": "ریزہ",
  "ریزوں": "ریزہ",
  "رضاکار": "رضاکار",
  "رضاکارو": "رضاکار",
  "رضاکاروں": "رضاکار",
  "رضائی": "رضائی",
  "رضائیاں": "رضائی",
  "رضائیو": "رضائی",
  "رضائیوں": "رضائی",
  "سَب": "سَب",
  "سَبھا": "سَبھا",
  "سَبھاؤ": "سَبھا",
  "سَبھاؤں": "سَبھا",
  "سَبھائیں": "سَبھا",
  "سَنْبھَل": "سَنْبھَلْنا",
  "سَنْبھَلْں": "سَنْبھَلْنا",
  "سَنْبھَلْنے": "سَنْبھَلْنا",
  "سَنْبھَلْنا": "سَنْبھَلْنا",
  "سَنْبھَلْنی": "سَنْبھَلْنا",
  "سَنْبھَلْتے": "سَنْبھَلْنا",
  "سَنْبھَلْتا": "سَنْبھَلْنا",
  "سَنْبھَلْتی": "سَنْبھَلْنا",
  "سَنْبھَلْتیں": "سَنْبھَلْنا",
  "سَنْبھَلْوا": "سَنْبھَلْنا",
  "سَنْبھَلْوانے": "سَنْبھَلْنا",
  "سَنْبھَلْوانا": "سَنْبھَلْنا",
  "سَنْبھَلْواتے": "سَنْبھَلْنا",
  "سَنْبھَلْواتا": "سَنْبھَلْنا",
  "سَنْبھَلْواتی": "سَنْبھَلْنا",
  "سَنْبھَلْواتیں": "سَنْبھَلْنا",
  "سَنْبھَلْواؤ": "سَنْبھَلْنا",
  "سَنْبھَلْواؤں": "سَنْبھَلْنا",
  "سَنْبھَلْوائے": "سَنْبھَلْنا",
  "سَنْبھَلْوائی": "سَنْبھَلْنا",
  "سَنْبھَلْوائیے": "سَنْبھَلْنا",
  "سَنْبھَلْوائیں": "سَنْبھَلْنا",
  "سَنْبھَلْوایا": "سَنْبھَلْنا",
  "سَنْبھَلے": "سَنْبھَلْنا",
  "سَنْبھَلا": "سَنْبھَلْنا",
  "سَنْبھَلو": "سَنْبھَلْنا",
  "سَنْبھَلوں": "سَنْبھَلْنا",
  "سَنْبھَلی": "سَنْبھَلْنا",
  "سَنْبھَلیے": "سَنْبھَلْنا",
  "سَنْبھَلیں": "سَنْبھَلْنا",
  "سَنْبھال": "سَنْبھَلْنا",
  "سَنْبھالے": "سَنْبھَلْنا",
  "سَنْبھالں": "سَنْبھَلْنا",
  "سَنْبھالا": "سَنْبھَلْنا",
  "سَنْبھالنے": "سَنْبھَلْنا",
  "سَنْبھالنا": "سَنْبھَلْنا",
  "سَنْبھالتے": "سَنْبھَلْنا",
  "سَنْبھالتا": "سَنْبھَلْنا",
  "سَنْبھالتی": "سَنْبھَلْنا",
  "سَنْبھالتیں": "سَنْبھَلْنا",
  "سَنْبھالو": "سَنْبھَلْنا",
  "سَنْبھالوں": "سَنْبھَلْنا",
  "سَنْبھالی": "سَنْبھَلْنا",
  "سَنْبھالیے": "سَنْبھَلْنا",
  "سَنْبھالیں": "سَنْبھَلْنا",
  "سَر": "سَر",
  "سَرو": "سَر",
  "سَروں": "سَر",
  "سَسْتے": "سَسْتا",
  "سَسْتا": "سَسْتا",
  "سَسْتی": "سَسْتا",
  "سَو": "سَونا",
  "سَونے": "سَونا",
  "سَونا": "سَونا",
  "سَونی": "سَونا",
  "سَوتے": "سَونا",
  "سَوتا": "سَونا",
  "سَوتی": "سَونا",
  "سَوتیں": "سَونا",
  "سَوؤ": "سَونا",
  "سَوؤں": "سَونا",
  "سَوئے": "سَونا",
  "سَوئی": "سَونا",
  "سَوئیے": "سَونا",
  "سَوئیں": "سَونا",
  "سَویا": "سَونا",
  "سِنان": "سِنان",
  "سِنانو": "سِنان",
  "سِنانوں": "سِنان",
  "سِنانیں": "سِنان",
  "سِرے": "سِرا",
  "سِرا": "سِرا",
  "سِرو": "سِرا",
  "سِروں": "سِرا",
  "سُلْوا": "سَونا",
  "سُلْوانے": "سَونا",
  "سُلْوانا": "سَونا",
  "سُلْواتے": "سَونا",
  "سُلْواتا": "سَونا",
  "سُلْواتی": "سَونا",
  "سُلْواتیں": "سَونا",
  "سُلْواؤ": "سَونا",
  "سُلْواؤں": "سَونا",
  "سُلْوائے": "سَونا",
  "سُلْوائی": "سَونا",
  "سُلْوائیے": "سَونا",
  "سُلْوائیں": "سَونا",
  "سُلْوایا": "سَونا",
  "سُلا": "سَونا",
  "سُلانے": "سَونا",
  "سُلانا": "سَونا",
  "سُلاتے": "سَونا",
  "سُلاتا": "سَونا",
  "سُلاتی": "سَونا",
  "سُلاتیں": "سَونا",
  "سُلاؤ": "سَونا",
  "سُلاؤں": "سَونا",
  "سُلائے": "سَونا",
  "سُلائی": "سَونا",
  "سُلائیے": "سَونا",
  "سُلائیں": "سَونا",
  "سُلایا": "سَونا",
  "سُم": "سُم",
  "سُمو": "سُم",
  "سُموں": "سُم",
  "سُن": "سُنْنا",
  "سُنْں": "سُنْنا",
  "سُنْنے": "سُنْنا",
  "سُنْنا": "سُنْنا",
  "سُنْنی": "سُنْنا",
  "سُنْتے": "سُنْنا",
  "سُنْتا": "سُنْنا",
  "سُنْتی": "سُنْنا",
  "سُنْتیں": "سُنْنا",
  "سُنْوا": "سُنْنا",
  "سُنْوانے": "سُنْنا",
  "سُنْوانا": "سُنْنا",
  "سُنْواتے": "سُنْنا",
  "سُنْواتا": "سُنْنا",
  "سُنْواتی": "سُنْنا",
  "سُنْواتیں": "سُنْنا",
  "سُنْواؤ": "سُنْنا",
  "سُنْواؤں": "سُنْنا",
  "سُنْوائے": "سُنْنا",
  "سُنْوائی": "سُنْنا",
  "سُنْوائیے": "سُنْنا",
  "سُنْوائیں": "سُنْنا",
  "سُنْوایا": "سُنْنا",
  "سُنے": "سُنْنا",
  "سُنں": "سُننا",
  "سُنا": "سُنْنا",
  "سُنانے": "سُنْنا",
  "سُنانا": "سُنْنا",
  "سُناتے": "سُنْنا",
  "سُناتا": "سُنْنا",
  "سُناتی": "سُنْنا",
  "سُناتیں": "سُنْنا",
  "سُناؤ": "سُنْنا",
  "سُناؤں": "سُنْنا",
  "سُنائے": "سُنْنا",
  "سُنائی": "سُنْنا",
  "سُنائیے": "سُنْنا",
  "سُنائیں": "سُنْنا",
  "سُنایا": "سُنْنا",
  "سُننے": "سُننا",
  "سُننا": "سُننا",
  "سُننی": "سُننا",
  "سُنتے": "سُننا",
  "سُنتا": "سُننا",
  "سُنتی": "سُننا",
  "سُنتیں": "سُننا",
  "سُنو": "سُنْنا",
  "سُنوں": "سُنْنا",
  "سُنوا": "سُننا",
  "سُنوانے": "سُننا",
  "سُنوانا": "سُننا",
  "سُنواتے": "سُننا",
  "سُنواتا": "سُننا",
  "سُنواتی": "سُننا",
  "سُنواتیں": "سُننا",
  "سُنواؤ": "سُننا",
  "سُنواؤں": "سُننا",
  "سُنوائے": "سُننا",
  "سُنوائی": "سُننا",
  "سُنوائیے": "سُننا",
  "سُنوائیں": "سُننا",
  "سُنوایا": "سُننا",
  "سُنی": "سُنی",
  "سُنیے": "سُنْنا",
  "سُنیں": "سُنْنا",
  "سُنیو": "سُنی",
  "سُنیوں": "سُنی",
  "سُر": "سُر",
  "سُرْخ": "سُرْخ",
  "سُرمے": "سُرمہ",
  "سُرمہ": "سُرمہ",
  "سُرمو": "سُرمہ",
  "سُرموں": "سُرمہ",
  "سُرنگ": "سُرنگ",
  "سُرنگو": "سُرنگ",
  "سُرنگوں": "سُرنگ",
  "سُرنگیں": "سُرنگ",
  "سُرو": "سُر",
  "سُروں": "سُر",
  "سُو": "سُو",
  "سُوؤ": "سُو",
  "سُوؤں": "سُو",
  "سے": "سے",
  "سےبات": "سےبات",
  "سےباتو": "سےبات",
  "سےباتوں": "سےبات",
  "سےباتیں": "سےبات",
  "سخن": "سخن",
  "سخنو": "سخن",
  "سخنوں": "سخن",
  "سختی": "سختی",
  "سختیاں": "سختی",
  "سختیو": "سختی",
  "سختیوں": "سختی",
  "سڑ": "سڑنا",
  "سڑے": "سڑنا",
  "سڑں": "سڑنا",
  "سڑا": "سڑنا",
  "سڑانے": "سڑنا",
  "سڑانا": "سڑنا",
  "سڑاتے": "سڑنا",
  "سڑاتا": "سڑنا",
  "سڑاتی": "سڑنا",
  "سڑاتیں": "سڑنا",
  "سڑاؤ": "سڑنا",
  "سڑاؤں": "سڑنا",
  "سڑائے": "سڑنا",
  "سڑائی": "سڑنا",
  "سڑائیے": "سڑنا",
  "سڑائیں": "سڑنا",
  "سڑایا": "سڑنا",
  "سڑک": "سڑک",
  "سڑکو": "سڑک",
  "سڑکوں": "سڑک",
  "سڑکیں": "سڑک",
  "سڑنے": "سڑنا",
  "سڑنا": "سڑنا",
  "سڑنی": "سڑنا",
  "سڑتے": "سڑنا",
  "سڑتا": "سڑنا",
  "سڑتی": "سڑنا",
  "سڑتیں": "سڑنا",
  "سڑو": "سڑنا",
  "سڑوں": "سڑنا",
  "سڑوا": "سڑنا",
  "سڑوانے": "سڑنا",
  "سڑوانا": "سڑنا",
  "سڑواتے": "سڑنا",
  "سڑواتا": "سڑنا",
  "سڑواتی": "سڑنا",
  "سڑواتیں": "سڑنا",
  "سڑواؤ": "سڑنا",
  "سڑواؤں": "سڑنا",
  "سڑوائے": "سڑنا",
  "سڑوائی": "سڑنا",
  "سڑوائیے": "سڑنا",
  "سڑوائیں": "سڑنا",
  "سڑوایا": "سڑنا",
  "سڑی": "سڑنا",
  "سڑیے": "سڑنا",
  "سڑیں": "سڑنا",
  "سٹے": "سٹہ",
  "سٹال": "سٹال",
  "سٹالو": "سٹال",
  "سٹالوں": "سٹال",
  "سٹہ": "سٹہ",
  "سٹو": "سٹہ",
  "سٹوں": "سٹہ",
  "سٹول": "سٹول",
  "سٹولو": "سٹول",
  "سٹولوں": "سٹول",
  "سٹور": "سٹور",
  "سٹورو": "سٹور",
  "سٹوروں": "سٹور",
  "سٹیشن": "سٹیشن",
  "سٹیشنو": "سٹیشن",
  "سٹیشنوں": "سٹیشن",
  "سا": "سا",
  "ساحل": "ساحل",
  "ساحلو": "ساحل",
  "ساحلوں": "ساحل",
  "ساڑی": "ساڑی",
  "ساڑیاں": "ساڑی",
  "ساڑیو": "ساڑی",
  "ساڑیوں": "ساڑی",
  "ساڑھی": "ساڑھی",
  "ساڑھیاں": "ساڑھی",
  "ساڑھیو": "ساڑھی",
  "ساڑھیوں": "ساڑھی",
  "سادے": "سادہ",
  "سادہ": "سادہ",
  "سادو": "سادہ",
  "سادوں": "سادہ",
  "سادھو": "سادھو",
  "سادھوؤ": "سادھو",
  "سادھوؤں": "سادھو",
  "ساعت": "ساعت",
  "ساعتو": "ساعت",
  "ساعتوں": "ساعت",
  "ساعتیں": "ساعت",
  "ساگودانے": "ساگودانہ",
  "ساگودانہ": "ساگودانہ",
  "ساگودانو": "ساگودانہ",
  "ساگودانوں": "ساگودانہ",
  "ساہوکار": "ساہوکار",
  "ساہوکارو": "ساہوکار",
  "ساہوکاروں": "ساہوکار",
  "ساہوکاریں": "ساہوکار",
  "سال": "سال",
  "سالے": "سالا",
  "سالا": "سالا",
  "سالو": "سالا",
  "سالوں": "سالا",
  "سامان": "سامان",
  "سامانو": "سامان",
  "سامانوں": "سامان",
  "سامنے": "سامنہ",
  "سامنہ": "سامنہ",
  "سامنو": "سامنہ",
  "سامنوں": "سامنہ",
  "سان": "سان",
  "سانحے": "سانحہ",
  "سانحہ": "سانحہ",
  "سانحو": "سانحہ",
  "سانحوں": "سانحہ",
  "سانچے": "سانچہ",
  "سانچہ": "سانچہ",
  "سانچو": "سانچہ",
  "سانچوں": "سانچہ",
  "سانپ": "سانپ",
  "سانپو": "سانپ",
  "سانپوں": "سانپ",
  "سانس": "سانس",
  "سانسو": "سانس",
  "سانسوں": "سانس",
  "سانسیں": "سانس",
  "سانو": "سان",
  "سانوں": "سان",
  "سانول": "سانول",
  "سانولے": "سانولا",
  "سانولا": "سانولا",
  "سانولو": "سانولا",
  "سانولوں": "سانولا",
  "سارے": "سارا",
  "سارا": "سارا",
  "سارہ": "سارہ",
  "سارنگی": "سارنگی",
  "سارنگیا": "سارنگیا",
  "سارنگیاں": "سارنگی",
  "سارنگیو": "سارنگی",
  "سارنگیوں": "سارنگی",
  "سارو": "سارا",
  "ساروں": "سارا",
  "ساری": "ساری",
  "ساریاں": "ساری",
  "ساریو": "ساری",
  "ساریوں": "ساری",
  "ساس": "ساس",
  "ساسو": "ساس",
  "ساسوں": "ساس",
  "ساسیں": "ساس",
  "سات": "سات",
  "ساتے": "ساتہ",
  "ساتہ": "ساتہ",
  "ساتو": "ساتہ",
  "ساتوں": "ساتہ",
  "ساتواں": "ساتواں",
  "ساتووںں": "ساتواں",
  "ساتویں": "ساتواں",
  "ساتیں": "سات",
  "ساتھے": "ساتھہ",
  "ساتھہ": "ساتھہ",
  "ساتھو": "ساتھہ",
  "ساتھوں": "ساتھہ",
  "ساتھی": "ساتھی",
  "ساتھیو": "ساتھی",
  "ساتھیوں": "ساتھی",
  "سایے": "سایا",
  "سائٹ": "سائٹ",
  "سائٹو": "سائٹ",
  "سائٹوں": "سائٹ",
  "سائبان": "سائبان",
  "سائبانو": "سائبان",
  "سائبانوں": "سائبان",
  "سائل": "سائل",
  "سائلو": "سائل",
  "سائلوں": "سائل",
  "سائنسدان": "سائنسدان",
  "سائنسدانو": "سائنسدان",
  "سائنسدانوں": "سائنسدان",
  "سائیکل": "سائیکل",
  "سائیکلو": "سائیکل",
  "سائیکلوں": "سائیکل",
  "سائیکلیں": "سائیکل",
  "سایا": "سایا",
  "سایہ": "سایہ",
  "سایو": "سایا",
  "سایوں": "سایا",
  "ساز": "ساز",
  "سازش": "سازش",
  "سازشو": "سازش",
  "سازشوں": "سازش",
  "سازشیں": "سازش",
  "سازو": "ساز",
  "سازوں": "ساز",
  "سازی": "سازی",
  "سازیو": "سازی",
  "سازیوں": "سازی",
  "سب": "سَب",
  "سبکی": "سبکی",
  "سبکیو": "سبکی",
  "سبکیوں": "سبکی",
  "سبز": "سبز",
  "سبزے": "سبزہ",
  "سبزہ": "سبزہ",
  "سبزو": "سبزہ",
  "سبزوں": "سبزہ",
  "سبزی": "سبزی",
  "سبزیاں": "سبزی",
  "سبزیو": "سبزی",
  "سبزیوں": "سبزی",
  "سبھا": "سبھا",
  "سبھاؤ": "سبھاؤ",
  "سبھاؤں": "سبھا",
  "سبھائیں": "سبھا",
  "سچ": "سچ",
  "سچے": "سچا",
  "سچا": "سچا",
  "سچائی": "سچائی",
  "سچائیاں": "سچائی",
  "سچائیو": "سچائی",
  "سچائیوں": "سچائی",
  "سچو": "سچا",
  "سچوں": "سچا",
  "سدھا": "سدھانا",
  "سدھانے": "سدھانا",
  "سدھانا": "سدھانا",
  "سدھانی": "سدھانا",
  "سدھار": "سدھار",
  "سدھارے": "سدھرنا",
  "سدھارں": "سدھرنا",
  "سدھارا": "سدھرنا",
  "سدھارنے": "سدھرنا",
  "سدھارنا": "سدھرنا",
  "سدھارتے": "سدھرنا",
  "سدھارتا": "سدھرنا",
  "سدھارتی": "سدھرنا",
  "سدھارتیں": "سدھرنا",
  "سدھارو": "سدھار",
  "سدھاروں": "سدھار",
  "سدھاری": "سدھرنا",
  "سدھاریے": "سدھرنا",
  "سدھاریں": "سدھرنا",
  "سدھاتے": "سدھانا",
  "سدھاتا": "سدھانا",
  "سدھاتی": "سدھانا",
  "سدھاتیں": "سدھانا",
  "سدھاؤ": "سدھانا",
  "سدھاؤں": "سدھانا",
  "سدھائے": "سدھانا",
  "سدھائی": "سدھانا",
  "سدھائیے": "سدھانا",
  "سدھائیں": "سدھانا",
  "سدھایا": "سدھانا",
  "سدھر": "سدھرنا",
  "سدھرے": "سدھرنا",
  "سدھرں": "سدھرنا",
  "سدھرا": "سدھرنا",
  "سدھرنے": "سدھرنا",
  "سدھرنا": "سدھرنا",
  "سدھرنی": "سدھرنا",
  "سدھرتے": "سدھرنا",
  "سدھرتا": "سدھرنا",
  "سدھرتی": "سدھرنا",
  "سدھرتیں": "سدھرنا",
  "سدھرو": "سدھرنا",
  "سدھروں": "سدھرنا",
  "سدھروا": "سدھرنا",
  "سدھروانے": "سدھرنا",
  "سدھروانا": "سدھرنا",
  "سدھرواتے": "سدھرنا",
  "سدھرواتا": "سدھرنا",
  "سدھرواتی": "سدھرنا",
  "سدھرواتیں": "سدھرنا",
  "سدھرواؤ": "سدھرنا",
  "سدھرواؤں": "سدھرنا",
  "سدھروائے": "سدھرنا",
  "سدھروائی": "سدھرنا",
  "سدھروائیے": "سدھرنا",
  "سدھروائیں": "سدھرنا",
  "سدھروایا": "سدھرنا",
  "سدھری": "سدھرنا",
  "سدھریے": "سدھرنا",
  "سدھریں": "سدھرنا",
  "سدھوا": "سدھانا",
  "سدھوانے": "سدھانا",
  "سدھوانا": "سدھانا",
  "سدھواتے": "سدھانا",
  "سدھواتا": "سدھانا",
  "سدھواتی": "سدھانا",
  "سدھواتیں": "سدھانا",
  "سدھواؤ": "سدھانا",
  "سدھواؤں": "سدھانا",
  "سدھوائے": "سدھانا",
  "سدھوائی": "سدھانا",
  "سدھوائیے": "سدھانا",
  "سدھوائیں": "سدھانا",
  "سدھوایا": "سدھانا",
  "سعادت": "سعادت",
  "سعادتو": "سعادت",
  "سعادتوں": "سعادت",
  "سعادتیں": "سعادت",
  "سفارشی": "سفارشی",
  "سفارشیو": "سفارشی",
  "سفارشیوں": "سفارشی",
  "سفر": "سفر",
  "سفرنامے": "سفرنامہ",
  "سفرنامہ": "سفرنامہ",
  "سفرنامو": "سفرنامہ",
  "سفرناموں": "سفرنامہ",
  "سفرو": "سفر",
  "سفروں": "سفر",
  "سفیدی": "سفیدی",
  "سفیدیاں": "سفیدی",
  "سفیدیو": "سفیدی",
  "سفیدیوں": "سفیدی",
  "سفینے": "سفینہ",
  "سفینہ": "سفینہ",
  "سفینو": "سفینہ",
  "سفینوں": "سفینہ",
  "سفیر": "سفیر",
  "سفیرو": "سفیر",
  "سفیروں": "سفیر",
  "سگرٹ": "سگرٹ",
  "سگرٹو": "سگرٹ",
  "سگرٹوں": "سگرٹ",
  "سگرٹیں": "سگرٹ",
  "سگریٹ": "سگریٹ",
  "سگریٹو": "سگریٹ",
  "سگریٹوں": "سگریٹ",
  "سگریٹیں": "سگریٹ",
  "سہ": "سہنا",
  "سہے": "سہنا",
  "سہں": "سہنا",
  "سہا": "سہنا",
  "سہاگے": "سہاگہ",
  "سہاگہ": "سہاگہ",
  "سہاگو": "سہاگہ",
  "سہاگوں": "سہاگہ",
  "سہار": "سہنا",
  "سہارے": "سہنا",
  "سہارں": "سہنا",
  "سہارا": "سہنا",
  "سہارنے": "سہنا",
  "سہارنا": "سہنا",
  "سہارتے": "سہنا",
  "سہارتا": "سہنا",
  "سہارتی": "سہنا",
  "سہارتیں": "سہنا",
  "سہارو": "سہنا",
  "سہاروں": "سہنا",
  "سہاری": "سہنا",
  "سہاریے": "سہنا",
  "سہاریں": "سہنا",
  "سہنے": "سہنا",
  "سہنا": "سہنا",
  "سہنی": "سہنا",
  "سہتے": "سہنا",
  "سہتا": "سہنا",
  "سہتی": "سہنا",
  "سہتیں": "سہنا",
  "سہو": "سہنا",
  "سہوں": "سہنا",
  "سہولت": "سہولت",
  "سہولتو": "سہولت",
  "سہولتوں": "سہولت",
  "سہولتیں": "سہولت",
  "سہی": "سہنا",
  "سہیے": "سہنا",
  "سہیں": "سہنا",
  "سہیلی": "سہیلی",
  "سہیلیاں": "سہیلی",
  "سہیلیو": "سہیلی",
  "سہیلیوں": "سہیلی",
  "سج": "سجنا",
  "سجے": "سجنا",
  "سجں": "سجنا",
  "سجا": "سجنا",
  "سجانے": "سجنا",
  "سجانا": "سجنا",
  "سجاتے": "سجنا",
  "سجاتا": "سجنا",
  "سجاتی": "سجنا",
  "سجاتیں": "سجنا",
  "سجاؤ": "سجنا",
  "سجاؤں": "سجنا",
  "سجائے": "سجنا",
  "سجائی": "سجنا",
  "سجائیے": "سجنا",
  "سجائیں": "سجنا",
  "سجایا": "سجنا",
  "سجدے": "سجدہ",
  "سجدہ": "سجدہ",
  "سجدو": "سجدہ",
  "سجدوں": "سجدہ",
  "سجنے": "سجنا",
  "سجنا": "سجنا",
  "سجنی": "سجنا",
  "سجتے": "سجنا",
  "سجتا": "سجنا",
  "سجتی": "سجنا",
  "سجتیں": "سجنا",
  "سجو": "سجنا",
  "سجوں": "سجنا",
  "سجوا": "سجنا",
  "سجوانے": "سجنا",
  "سجوانا": "سجنا",
  "سجواتے": "سجنا",
  "سجواتا": "سجنا",
  "سجواتی": "سجنا",
  "سجواتیں": "سجنا",
  "سجواؤ": "سجنا",
  "سجواؤں": "سجنا",
  "سجوائے": "سجنا",
  "سجوائی": "سجنا",
  "سجوائیے": "سجنا",
  "سجوائیں": "سجنا",
  "سجوایا": "سجنا",
  "سجی": "سجنا",
  "سجیے": "سجنا",
  "سجیں": "سجنا",
  "سجھ": "سجھنا",
  "سجھے": "سجھنا",
  "سجھں": "سجھنا",
  "سجھا": "سجھنا",
  "سجھانے": "سوجھنا",
  "سجھانا": "سوجھنا",
  "سجھاتے": "سوجھنا",
  "سجھاتا": "سوجھنا",
  "سجھاتی": "سوجھنا",
  "سجھاتیں": "سوجھنا",
  "سجھاؤ": "سوجھنا",
  "سجھاؤں": "سوجھنا",
  "سجھائے": "سوجھنا",
  "سجھائی": "سوجھنا",
  "سجھائیے": "سوجھنا",
  "سجھائیں": "سوجھنا",
  "سجھایا": "سوجھنا",
  "سجھنے": "سجھنا",
  "سجھنا": "سجھنا",
  "سجھنی": "سجھنا",
  "سجھتے": "سجھنا",
  "سجھتا": "سجھنا",
  "سجھتی": "سجھنا",
  "سجھتیں": "سجھنا",
  "سجھو": "سجھنا",
  "سجھوں": "سجھنا",
  "سجھوا": "سوجھنا",
  "سجھوانے": "سوجھنا",
  "سجھوانا": "سوجھنا",
  "سجھواتے": "سوجھنا",
  "سجھواتا": "سوجھنا",
  "سجھواتی": "سوجھنا",
  "سجھواتیں": "سوجھنا",
  "سجھواؤ": "سوجھنا",
  "سجھواؤں": "سوجھنا",
  "سجھوائے": "سوجھنا",
  "سجھوائی": "سوجھنا",
  "سجھوائیے": "سوجھنا",
  "سجھوائیں": "سوجھنا",
  "سجھوایا": "سوجھنا",
  "سجھی": "سجھنا",
  "سجھیے": "سجھنا",
  "سجھیں": "سجھنا",
  "سک": "سکنا",
  "سکے": "سکنا",
  "سکں": "سکنا",
  "سکڑ": "سکڑنا",
  "سکڑے": "سکڑنا",
  "سکڑں": "سکڑنا",
  "سکڑا": "سکڑنا",
  "سکڑانے": "سکڑنا",
  "سکڑانا": "سکڑنا",
  "سکڑاتے": "سکڑنا",
  "سکڑاتا": "سکڑنا",
  "سکڑاتی": "سکڑنا",
  "سکڑاتیں": "سکڑنا",
  "سکڑاؤ": "سکڑنا",
  "سکڑاؤں": "سکڑنا",
  "سکڑائے": "سکڑنا",
  "سکڑائی": "سکڑنا",
  "سکڑائیے": "سکڑنا",
  "سکڑائیں": "سکڑنا",
  "سکڑایا": "سکڑنا",
  "سکڑنے": "سکڑنا",
  "سکڑنا": "سکڑنا",
  "سکڑنی": "سکڑنا",
  "سکڑتے": "سکڑنا",
  "سکڑتا": "سکڑنا",
  "سکڑتی": "سکڑنا",
  "سکڑتیں": "سکڑنا",
  "سکڑو": "سکڑنا",
  "سکڑوں": "سکڑنا",
  "سکڑوا": "سکڑنا",
  "سکڑوانے": "سکڑنا",
  "سکڑوانا": "سکڑنا",
  "سکڑواتے": "سکڑنا",
  "سکڑواتا": "سکڑنا",
  "سکڑواتی": "سکڑنا",
  "سکڑواتیں": "سکڑنا",
  "سکڑواؤ": "سکڑنا",
  "سکڑواؤں": "سکڑنا",
  "سکڑوائے": "سکڑنا",
  "سکڑوائی": "سکڑنا",
  "سکڑوائیے": "سکڑنا",
  "سکڑوائیں": "سکڑنا",
  "سکڑوایا": "سکڑنا",
  "سکڑی": "سکڑنا",
  "سکڑیے": "سکڑنا",
  "سکڑیں": "سکڑنا",
  "سکا": "سکنا",
  "سکانے": "سکنا",
  "سکانا": "سکنا",
  "سکاتے": "سکنا",
  "سکاتا": "سکنا",
  "سکاتی": "سکنا",
  "سکاتیں": "سکنا",
  "سکاؤ": "سکنا",
  "سکاؤں": "سکنا",
  "سکائے": "سکنا",
  "سکائی": "سکنا",
  "سکائیے": "سکنا",
  "سکائیں": "سکنا",
  "سکایا": "سکنا",
  "سکنے": "سکنا",
  "سکنا": "سکنا",
  "سکندر": "سکندر",
  "سکندرو": "سکندر",
  "سکندروں": "سکندر",
  "سکنی": "سکنا",
  "سکرپٹ": "سکرپٹ",
  "سکرپٹو": "سکرپٹ",
  "سکرپٹوں": "سکرپٹ",
  "سکت": "سکت",
  "سکتے": "سکتہ",
  "سکتا": "سکنا",
  "سکتہ": "سکتہ",
  "سکتو": "سکتہ",
  "سکتوں": "سکتہ",
  "سکتی": "سکنا",
  "سکتیں": "سکت",
  "سکو": "سکنا",
  "سکوں": "سکنا",
  "سکوا": "سکنا",
  "سکوانے": "سکنا",
  "سکوانا": "سکنا",
  "سکواتے": "سکنا",
  "سکواتا": "سکنا",
  "سکواتی": "سکنا",
  "سکواتیں": "سکنا",
  "سکواؤ": "سکنا",
  "سکواؤں": "سکنا",
  "سکوائے": "سکنا",
  "سکوائی": "سکنا",
  "سکوائیے": "سکنا",
  "سکوائیں": "سکنا",
  "سکوایا": "سکنا",
  "سکول": "سکول",
  "سکولو": "سکول",
  "سکولوں": "سکول",
  "سکی": "سکنا",
  "سکیے": "سکنا",
  "سکیں": "سکنا",
  "سکیم": "سکیم",
  "سکیمو": "سکیم",
  "سکیموں": "سکیم",
  "سکیمیں": "سکیم",
  "سکھ": "سکھنا",
  "سکھے": "سکھنا",
  "سکھں": "سکھنا",
  "سکھا": "سکھنا",
  "سکھانے": "سکھنا",
  "سکھانا": "سکھنا",
  "سکھاتے": "سکھنا",
  "سکھاتا": "سکھنا",
  "سکھاتی": "سکھنا",
  "سکھاتیں": "سکھنا",
  "سکھاؤ": "سکھنا",
  "سکھاؤں": "سکھنا",
  "سکھائے": "سکھنا",
  "سکھائی": "سکھنا",
  "سکھائیے": "سکھنا",
  "سکھائیں": "سکھنا",
  "سکھایا": "سکھنا",
  "سکھنے": "سکھنا",
  "سکھنا": "سکھنا",
  "سکھنی": "سکھنا",
  "سکھتے": "سکھنا",
  "سکھتا": "سکھنا",
  "سکھتی": "سکھنا",
  "سکھتیں": "سکھنا",
  "سکھو": "سکھنا",
  "سکھوں": "سکھنا",
  "سکھوا": "سکھنا",
  "سکھوانے": "سکھنا",
  "سکھوانا": "سکھنا",
  "سکھواتے": "سکھنا",
  "سکھواتا": "سکھنا",
  "سکھواتی": "سکھنا",
  "سکھواتیں": "سکھنا",
  "سکھواؤ": "سکھنا",
  "سکھواؤں": "سکھنا",
  "سکھوائے": "سکھنا",
  "سکھوائی": "سکھنا",
  "سکھوائیے": "سکھنا",
  "سکھوائیں": "سکھنا",
  "سکھوایا": "سکھنا",
  "سکھی": "سکھی",
  "سکھیے": "سکھنا",
  "سکھیں": "سکھنا",
  "سکھیاں": "سکھی",
  "سکھیو": "سکھی",
  "سکھیوں": "سکھی",
  "سل": "سل",
  "سلا": "سونا",
  "سلاخ": "سلاخ",
  "سلاخو": "سلاخ",
  "سلاخوں": "سلاخ",
  "سلاخیں": "سلاخ",
  "سلاد": "سلاد",
  "سلادو": "سلاد",
  "سلادوں": "سلاد",
  "سلادیں": "سلاد",
  "سلامی": "سلامی",
  "سلامیاں": "سلامی",
  "سلامیو": "سلامی",
  "سلامیوں": "سلامی",
  "سلانے": "سونا",
  "سلانا": "سونا",
  "سلاتے": "سونا",
  "سلاتا": "سونا",
  "سلاتی": "سونا",
  "سلاتیں": "سونا",
  "سلاؤ": "سونا",
  "سلاؤں": "سونا",
  "سلائے": "سونا",
  "سلائی": "سونا",
  "سلائیے": "سونا",
  "سلائیں": "سونا",
  "سلایا": "سونا",
  "سلفے": "سلفہ",
  "سلفچی": "سلفچی",
  "سلفچیاں": "سلفچی",
  "سلفچیو": "سلفچی",
  "سلفچیوں": "سلفچی",
  "سلفہ": "سلفہ",
  "سلفو": "سلفہ",
  "سلفوں": "سلفہ",
  "سلگ": "سلگنا",
  "سلگے": "سلگنا",
  "سلگں": "سلگنا",
  "سلگا": "سلگنا",
  "سلگانے": "سلگنا",
  "سلگانا": "سلگنا",
  "سلگاتے": "سلگنا",
  "سلگاتا": "سلگنا",
  "سلگاتی": "سلگنا",
  "سلگاتیں": "سلگنا",
  "سلگاؤ": "سلگنا",
  "سلگاؤں": "سلگنا",
  "سلگائے": "سلگنا",
  "سلگائی": "سلگنا",
  "سلگائیے": "سلگنا",
  "سلگائیں": "سلگنا",
  "سلگایا": "سلگنا",
  "سلگنے": "سلگنا",
  "سلگنا": "سلگنا",
  "سلگنی": "سلگنا",
  "سلگت": "سلگت",
  "سلگتے": "سلگنا",
  "سلگتا": "سلگنا",
  "سلگتو": "سلگت",
  "سلگتوں": "سلگت",
  "سلگتی": "سلگنا",
  "سلگتیں": "سلگت",
  "سلگو": "سلگنا",
  "سلگوں": "سلگنا",
  "سلگوا": "سلگنا",
  "سلگوانے": "سلگنا",
  "سلگوانا": "سلگنا",
  "سلگواتے": "سلگنا",
  "سلگواتا": "سلگنا",
  "سلگواتی": "سلگنا",
  "سلگواتیں": "سلگنا",
  "سلگواؤ": "سلگنا",
  "سلگواؤں": "سلگنا",
  "سلگوائے": "سلگنا",
  "سلگوائی": "سلگنا",
  "سلگوائیے": "سلگنا",
  "سلگوائیں": "سلگنا",
  "سلگوایا": "سلگنا",
  "سلگی": "سلگنا",
  "سلگیے": "سلگنا",
  "سلگیں": "سلگنا",
  "سلجھ": "سلجھنا",
  "سلجھے": "سلجھنا",
  "سلجھں": "سلجھنا",
  "سلجھا": "سلجھنا",
  "سلجھانے": "سلجھنا",
  "سلجھانا": "سلجھنا",
  "سلجھاتے": "سلجھنا",
  "سلجھاتا": "سلجھنا",
  "سلجھاتی": "سلجھنا",
  "سلجھاتیں": "سلجھنا",
  "سلجھاؤ": "سلجھنا",
  "سلجھاؤں": "سلجھنا",
  "سلجھائے": "سلجھنا",
  "سلجھائی": "سلجھنا",
  "سلجھائیے": "سلجھنا",
  "سلجھائیں": "سلجھنا",
  "سلجھایا": "سلجھنا",
  "سلجھنے": "سلجھنا",
  "سلجھنا": "سلجھنا",
  "سلجھنی": "سلجھنا",
  "سلجھتے": "سلجھنا",
  "سلجھتا": "سلجھنا",
  "سلجھتی": "سلجھنا",
  "سلجھتیں": "سلجھنا",
  "سلجھو": "سلجھنا",
  "سلجھوں": "سلجھنا",
  "سلجھوا": "سلجھنا",
  "سلجھوانے": "سلجھنا",
  "سلجھوانا": "سلجھنا",
  "سلجھواتے": "سلجھنا",
  "سلجھواتا": "سلجھنا",
  "سلجھواتی": "سلجھنا",
  "سلجھواتیں": "سلجھنا",
  "سلجھواؤ": "سلجھنا",
  "سلجھواؤں": "سلجھنا",
  "سلجھوائے": "سلجھنا",
  "سلجھوائی": "سلجھنا",
  "سلجھوائیے": "سلجھنا",
  "سلجھوائیں": "سلجھنا",
  "سلجھوایا": "سلجھنا",
  "سلجھی": "سلجھنا",
  "سلجھیے": "سلجھنا",
  "سلجھیں": "سلجھنا",
  "سلقے": "سلقہ",
  "سلقہ": "سلقہ",
  "سلقو": "سلقہ",
  "سلقوں": "سلقہ",
  "سلسے": "سلسہ",
  "سلسہ": "سلسہ",
  "سلسلے": "سلسلہ",
  "سلسلہ": "سلسلہ",
  "سلسلو": "سلسلہ",
  "سلسلوں": "سلسلہ",
  "سلسو": "سلسہ",
  "سلسوں": "سلسہ",
  "سلو": "سل",
  "سلوں": "سل",
  "سلوٹ": "سلوٹ",
  "سلوٹو": "سلوٹ",
  "سلوٹوں": "سلوٹ",
  "سلوٹیں": "سلوٹ",
  "سلوا": "سونا",
  "سلوانے": "سونا",
  "سلوانا": "سونا",
  "سلواتے": "سونا",
  "سلواتا": "سونا",
  "سلواتی": "سونا",
  "سلواتیں": "سونا",
  "سلواؤ": "سونا",
  "سلواؤں": "سونا",
  "سلوائے": "سونا",
  "سلوائی": "سونا",
  "سلوائیے": "سونا",
  "سلوائیں": "سونا",
  "سلوایا": "سونا",
  "سلیں": "سل",
  "سلیپر": "سلیپر",
  "سلیپرو": "سلیپر",
  "سلیپروں": "سلیپر",
  "سلیپریں": "سلیپر",
  "سلیقے": "سلیقہ",
  "سلیقہ": "سلیقہ",
  "سلیقو": "سلیقہ",
  "سلیقوں": "سلیقہ",
  "سلطان": "سلطان",
  "سلطانہ": "سلطانہ",
  "سلطانو": "سلطان",
  "سلطانوں": "سلطان",
  "سلطنت": "سلطنت",
  "سلطنتو": "سلطنت",
  "سلطنتوں": "سلطنت",
  "سلطنتیں": "سلطنت",
  "سم": "سم",
  "سمے": "سما",
  "سمں": "سمنا",
  "سما": "سما",
  "سمادھی": "سمادھی",
  "سمادھیو": "سمادھی",
  "سمادھیوں": "سمادھی",
  "سماج": "سماج",
  "سماجو": "سماج",
  "سماجوں": "سماج",
  "سمانے": "سمنا",
  "سمانا": "سمنا",
  "سماتے": "سمنا",
  "سماتا": "سمنا",
  "سماتی": "سمنا",
  "سماتیں": "سمنا",
  "سماؤ": "سمنا",
  "سماؤں": "سمنا",
  "سمائے": "سمنا",
  "سمائی": "سمنا",
  "سمائیے": "سمنا",
  "سمائیں": "سمنا",
  "سمایا": "سمنا",
  "سمجھ": "سمجھنا",
  "سمجھے": "سمجھنا",
  "سمجھں": "سمجھنا",
  "سمجھا": "سمجھنا",
  "سمجھانے": "سمجھنا",
  "سمجھانا": "سمجھنا",
  "سمجھات": "سمجھات",
  "سمجھاتے": "سمجھنا",
  "سمجھاتا": "سمجھنا",
  "سمجھاتو": "سمجھات",
  "سمجھاتوں": "سمجھات",
  "سمجھاتی": "سمجھنا",
  "سمجھاتیں": "سمجھات",
  "سمجھاؤ": "سمجھنا",
  "سمجھاؤں": "سمجھنا",
  "سمجھائے": "سمجھنا",
  "سمجھائی": "سمجھنا",
  "سمجھائیے": "سمجھنا",
  "سمجھائیں": "سمجھنا",
  "سمجھایا": "سمجھنا",
  "سمجھنے": "سمجھنا",
  "سمجھنا": "سمجھنا",
  "سمجھنی": "سمجھنا",
  "سمجھتے": "سمجھنا",
  "سمجھتا": "سمجھنا",
  "سمجھتی": "سمجھنا",
  "سمجھتیں": "سمجھنا",
  "سمجھو": "سمجھنا",
  "سمجھوں": "سمجھنا",
  "سمجھوا": "سمجھنا",
  "سمجھوانے": "سمجھنا",
  "سمجھوانا": "سمجھنا",
  "سمجھواتے": "سمجھنا",
  "سمجھواتا": "سمجھنا",
  "سمجھواتی": "سمجھنا",
  "سمجھواتیں": "سمجھنا",
  "سمجھواؤ": "سمجھنا",
  "سمجھواؤں": "سمجھنا",
  "سمجھوائے": "سمجھنا",
  "سمجھوائی": "سمجھنا",
  "سمجھوائیے": "سمجھنا",
  "سمجھوائیں": "سمجھنا",
  "سمجھوایا": "سمجھنا",
  "سمجھوتے": "سمجھوتہ",
  "سمجھوتہ": "سمجھوتہ",
  "سمجھوتو": "سمجھوتہ",
  "سمجھوتوں": "سمجھوتہ",
  "سمجھی": "سمجھنا",
  "سمجھیے": "سمجھنا",
  "سمجھیں": "سمجھنا",
  "سمنے": "سمنا",
  "سمنا": "سمنا",
  "سمندر": "سمندر",
  "سمندرو": "سمندر",
  "سمندروں": "سمندر",
  "سمنی": "سمنا",
  "سمت": "سمت",
  "سمتے": "سمنا",
  "سمتا": "سمنا",
  "سمتو": "سمت",
  "سمتوں": "سمت",
  "سمتی": "سمنا",
  "سمتیں": "سمت",
  "سمو": "سما",
  "سموں": "سما",
  "سموا": "سمنا",
  "سموانے": "سمنا",
  "سموانا": "سمنا",
  "سمواتے": "سمنا",
  "سمواتا": "سمنا",
  "سمواتی": "سمنا",
  "سمواتیں": "سمنا",
  "سمواؤ": "سمنا",
  "سمواؤں": "سمنا",
  "سموائے": "سمنا",
  "سموائی": "سمنا",
  "سموائیے": "سمنا",
  "سموائیں": "سمنا",
  "سموایا": "سمنا",
  "سموسے": "سموسہ",
  "سموسہ": "سموسہ",
  "سموسو": "سموسہ",
  "سموسوں": "سموسہ",
  "سمی": "سمنا",
  "سمیے": "سمنا",
  "سمیں": "سمنا",
  "سمیسٹر": "سمیسٹر",
  "سمیسٹرو": "سمیسٹر",
  "سمیسٹروں": "سمیسٹر",
  "سن": "سننا",
  "سنے": "سننا",
  "سنں": "سننا",
  "سنا": "سننا",
  "سنانے": "سننا",
  "سنانا": "سننا",
  "سناتے": "سننا",
  "سناتا": "سننا",
  "سناتی": "سننا",
  "سناتیں": "سننا",
  "سناؤ": "سننا",
  "سناؤں": "سننا",
  "سنائے": "سننا",
  "سنائی": "سننا",
  "سنائیے": "سننا",
  "سنائیں": "سننا",
  "سنایا": "سننا",
  "سنبھال": "سنبھلنا",
  "سنبھالے": "سنبھلنا",
  "سنبھالں": "سنبھلنا",
  "سنبھالا": "سنبھلنا",
  "سنبھالنے": "سنبھلنا",
  "سنبھالنا": "سنبھلنا",
  "سنبھالتے": "سنبھلنا",
  "سنبھالتا": "سنبھلنا",
  "سنبھالتی": "سنبھلنا",
  "سنبھالتیں": "سنبھلنا",
  "سنبھالو": "سنبھلنا",
  "سنبھالوں": "سنبھلنا",
  "سنبھالی": "سنبھلنا",
  "سنبھالیے": "سنبھلنا",
  "سنبھالیں": "سنبھلنا",
  "سنبھل": "سنبھلنا",
  "سنبھلے": "سنبھلنا",
  "سنبھلں": "سنبھلنا",
  "سنبھلا": "سنبھلنا",
  "سنبھلنے": "سنبھلنا",
  "سنبھلنا": "سنبھلنا",
  "سنبھلنی": "سنبھلنا",
  "سنبھلتے": "سنبھلنا",
  "سنبھلتا": "سنبھلنا",
  "سنبھلتی": "سنبھلنا",
  "سنبھلتیں": "سنبھلنا",
  "سنبھلو": "سنبھلنا",
  "سنبھلوں": "سنبھلنا",
  "سنبھلوا": "سنبھلنا",
  "سنبھلوانے": "سنبھلنا",
  "سنبھلوانا": "سنبھلنا",
  "سنبھلواتے": "سنبھلنا",
  "سنبھلواتا": "سنبھلنا",
  "سنبھلواتی": "سنبھلنا",
  "سنبھلواتیں": "سنبھلنا",
  "سنبھلواؤ": "سنبھلنا",
  "سنبھلواؤں": "سنبھلنا",
  "سنبھلوائے": "سنبھلنا",
  "سنبھلوائی": "سنبھلنا",
  "سنبھلوائیے": "سنبھلنا",
  "سنبھلوائیں": "سنبھلنا",
  "سنبھلوایا": "سنبھلنا",
  "سنبھلی": "سنبھلنا",
  "سنبھلیے": "سنبھلنا",
  "سنبھلیں": "سنبھلنا",
  "سند": "سند",
  "سندو": "سند",
  "سندوں": "سند",
  "سندیں": "سند",
  "سندیلے": "سندیلہ",
  "سندیلہ": "سندیلہ",
  "سندیلو": "سندیلہ",
  "سندیلوں": "سندیلہ",
  "سندھی": "سندھی",
  "سندھیو": "سندھی",
  "سندھیوں": "سندھی",
  "سنگین": "سنگین",
  "سنگینو": "سنگین",
  "سنگینوں": "سنگین",
  "سنگینیں": "سنگین",
  "سنگھے": "سنگھہ",
  "سنگھا": "سونگھنا",
  "سنگھاڑے": "سنگھاڑا",
  "سنگھاڑا": "سنگھاڑا",
  "سنگھاڑو": "سنگھاڑا",
  "سنگھاڑوں": "سنگھاڑا",
  "سنگھانے": "سونگھنا",
  "سنگھانا": "سونگھنا",
  "سنگھاتے": "سونگھنا",
  "سنگھاتا": "سونگھنا",
  "سنگھاتی": "سونگھنا",
  "سنگھاتیں": "سونگھنا",
  "سنگھاؤ": "سونگھنا",
  "سنگھاؤں": "سونگھنا",
  "سنگھائے": "سونگھنا",
  "سنگھائی": "سونگھنا",
  "سنگھائیے": "سونگھنا",
  "سنگھائیں": "سونگھنا",
  "سنگھایا": "سونگھنا",
  "سنگھہ": "سنگھہ",
  "سنگھو": "سنگھہ",
  "سنگھوں": "سنگھہ",
  "سنگھوا": "سونگھنا",
  "سنگھوانے": "سونگھنا",
  "سنگھوانا": "سونگھنا",
  "سنگھواتے": "سونگھنا",
  "سنگھواتا": "سونگھنا",
  "سنگھواتی": "سونگھنا",
  "سنگھواتیں": "سونگھنا",
  "سنگھواؤ": "سونگھنا",
  "سنگھواؤں": "سونگھنا",
  "سنگھوائے": "سونگھنا",
  "سنگھوائی": "سونگھنا",
  "سنگھوائیے": "سونگھنا",
  "سنگھوائیں": "سونگھنا",
  "سنگھوایا": "سونگھنا",
  "سننے": "سننا",
  "سننا": "سننا",
  "سننی": "سننا",
  "سنس": "سنسنا",
  "سنسے": "سنسنا",
  "سنسں": "سنسنا",
  "سنسا": "سنسنا",
  "سنسانے": "سنسنا",
  "سنسانا": "سنسنا",
  "سنساتے": "سنسنا",
  "سنساتا": "سنسنا",
  "سنساتی": "سنسنا",
  "سنساتیں": "سنسنا",
  "سنساؤ": "سنسنا",
  "سنساؤں": "سنسنا",
  "سنسائے": "سنسنا",
  "سنسائی": "سنسنا",
  "سنسائیے": "سنسنا",
  "سنسائیں": "سنسنا",
  "سنسایا": "سنسنا",
  "سنسنے": "سنسنا",
  "سنسنا": "سنسنا",
  "سنسنی": "سنسنا",
  "سنستے": "سنسنا",
  "سنستا": "سنسنا",
  "سنستی": "سنسنا",
  "سنستیں": "سنسنا",
  "سنسو": "سنسنا",
  "سنسوں": "سنسنا",
  "سنسوا": "سنسنا",
  "سنسوانے": "سنسنا",
  "سنسوانا": "سنسنا",
  "سنسواتے": "سنسنا",
  "سنسواتا": "سنسنا",
  "سنسواتی": "سنسنا",
  "سنسواتیں": "سنسنا",
  "سنسواؤ": "سنسنا",
  "سنسواؤں": "سنسنا",
  "سنسوائے": "سنسنا",
  "سنسوائی": "سنسنا",
  "سنسوائیے": "سنسنا",
  "سنسوائیں": "سنسنا",
  "سنسوایا": "سنسنا",
  "سنسی": "سنسنا",
  "سنسیے": "سنسنا",
  "سنسیں": "سنسنا",
  "سنت": "سنت",
  "سنتے": "سننا",
  "سنتا": "سننا",
  "سنتو": "سنت",
  "سنتوں": "سنت",
  "سنتی": "سننا",
  "سنتیں": "سنت",
  "سنو": "سننا",
  "سنوں": "سننا",
  "سنوا": "سننا",
  "سنوانے": "سننا",
  "سنوانا": "سننا",
  "سنوار": "سنوارنا",
  "سنوارے": "سنوارنا",
  "سنوارں": "سنوارنا",
  "سنوارا": "سنوارنا",
  "سنوارنے": "سنوارنا",
  "سنوارنا": "سنوارنا",
  "سنوارنی": "سنوارنا",
  "سنوارتے": "سنوارنا",
  "سنوارتا": "سنوارنا",
  "سنوارتی": "سنوارنا",
  "سنوارتیں": "سنوارنا",
  "سنوارو": "سنوارنا",
  "سنواروں": "سنوارنا",
  "سنواری": "سنوارنا",
  "سنواریے": "سنوارنا",
  "سنواریں": "سنوارنا",
  "سنواتے": "سننا",
  "سنواتا": "سننا",
  "سنواتی": "سننا",
  "سنواتیں": "سننا",
  "سنواؤ": "سننا",
  "سنواؤں": "سننا",
  "سنوائے": "سننا",
  "سنوائی": "سننا",
  "سنوائیے": "سننا",
  "سنوائیں": "سننا",
  "سنوایا": "سننا",
  "سنور": "سنورنا",
  "سنورے": "سنورنا",
  "سنورں": "سنورنا",
  "سنورا": "سنورنا",
  "سنورنے": "سنورنا",
  "سنورنا": "سنورنا",
  "سنورنی": "سنورنا",
  "سنورتے": "سنورنا",
  "سنورتا": "سنورنا",
  "سنورتی": "سنورنا",
  "سنورتیں": "سنورنا",
  "سنورو": "سنورنا",
  "سنوروں": "سنورنا",
  "سنوری": "سنورنا",
  "سنوریے": "سنورنا",
  "سنوریں": "سنورنا",
  "سنی": "سنی",
  "سنیے": "سننا",
  "سنیں": "سننا",
  "سنیو": "سنی",
  "سنیوں": "سنی",
  "سنھبال": "سنھبلنا",
  "سنھبالے": "سنھبلنا",
  "سنھبالں": "سنھبلنا",
  "سنھبالا": "سنھبلنا",
  "سنھبالنے": "سنھبلنا",
  "سنھبالنا": "سنھبلنا",
  "سنھبالتے": "سنھبلنا",
  "سنھبالتا": "سنھبلنا",
  "سنھبالتی": "سنھبلنا",
  "سنھبالتیں": "سنھبلنا",
  "سنھبالو": "سنھبلنا",
  "سنھبالوں": "سنھبلنا",
  "سنھبالی": "سنھبلنا",
  "سنھبالیے": "سنھبلنا",
  "سنھبالیں": "سنھبلنا",
  "سنھبل": "سنھبلنا",
  "سنھبلے": "سنھبلنا",
  "سنھبلں": "سنھبلنا",
  "سنھبلا": "سنھبلنا",
  "سنھبلنے": "سنھبلنا",
  "سنھبلنا": "سنھبلنا",
  "سنھبلنی": "سنھبلنا",
  "سنھبلتے": "سنھبلنا",
  "سنھبلتا": "سنھبلنا",
  "سنھبلتی": "سنھبلنا",
  "سنھبلتیں": "سنھبلنا",
  "سنھبلو": "سنھبلنا",
  "سنھبلوں": "سنھبلنا",
  "سنھبلوا": "سنھبلنا",
  "سنھبلوانے": "سنھبلنا",
  "سنھبلوانا": "سنھبلنا",
  "سنھبلواتے": "سنھبلنا",
  "سنھبلواتا": "سنھبلنا",
  "سنھبلواتی": "سنھبلنا",
  "سنھبلواتیں": "سنھبلنا",
  "سنھبلواؤ": "سنھبلنا",
  "سنھبلواؤں": "سنھبلنا",
  "سنھبلوائے": "سنھبلنا",
  "سنھبلوائی": "سنھبلنا",
  "سنھبلوائیے": "سنھبلنا",
  "سنھبلوائیں": "سنھبلنا",
  "سنھبلوایا": "سنھبلنا",
  "سنھبلی": "سنھبلنا",
  "سنھبلیے": "سنھبلنا",
  "سنھبلیں": "سنھبلنا",
  "سپاہی": "سپاہی",
  "سپاہیو": "سپاہی",
  "سپاہیوں": "سپاہی",
  "سپنے": "سپنا",
  "سپنا": "سپنا",
  "سپنو": "سپنا",
  "سپنوں": "سپنا",
  "سپی": "سپی",
  "سپیاں": "سپی",
  "سپیو": "سپی",
  "سپیوں": "سپی",
  "سقے": "سقہ",
  "سقہ": "سقہ",
  "سقو": "سقہ",
  "سقوں": "سقہ",
  "سر": "سر",
  "سرے": "سرا",
  "سرغنے": "سرغنہ",
  "سرغنہ": "سرغنہ",
  "سرغنو": "سرغنہ",
  "سرغنوں": "سرغنہ",
  "سرحد": "سرحد",
  "سرحدو": "سرحد",
  "سرحدوں": "سرحد",
  "سرحدیں": "سرحد",
  "سرخی": "سرخی",
  "سرخیاں": "سرخی",
  "سرخیو": "سرخی",
  "سرخیوں": "سرخی",
  "سرا": "سرا",
  "سراب": "سراب",
  "سرابو": "سراب",
  "سرابوں": "سراب",
  "سرابیں": "سراب",
  "سراہ": "سراہنا",
  "سراہے": "سراہنا",
  "سراہں": "سراہنا",
  "سراہا": "سراہنا",
  "سراہنے": "سراہنا",
  "سراہنا": "سراہنا",
  "سراہنی": "سراہنا",
  "سراہتے": "سراہنا",
  "سراہتا": "سراہنا",
  "سراہتی": "سراہنا",
  "سراہتیں": "سراہنا",
  "سراہو": "سراہنا",
  "سراہوں": "سراہنا",
  "سراہی": "سراہنا",
  "سراہیے": "سراہنا",
  "سراہیں": "سراہنا",
  "سرائکی": "سرائکی",
  "سرائکیو": "سرائکی",
  "سرائکیوں": "سرائکی",
  "سرچشمے": "سرچشمہ",
  "سرچشمہ": "سرچشمہ",
  "سرچشمو": "سرچشمہ",
  "سرچشموں": "سرچشمہ",
  "سرد": "سرد",
  "سردار": "سردار",
  "سردارو": "سردار",
  "سرداروں": "سردار",
  "سردو": "سرد",
  "سردوں": "سرد",
  "سردی": "سردی",
  "سردیاں": "سردی",
  "سردیو": "سردی",
  "سردیوں": "سردی",
  "سرگم": "سرگم",
  "سرگمو": "سرگم",
  "سرگموں": "سرگم",
  "سرگرمی": "سرگرمی",
  "سرگرمیاں": "سرگرمی",
  "سرگرمیو": "سرگرمی",
  "سرگرمیوں": "سرگرمی",
  "سرگوشی": "سرگوشی",
  "سرگوشیاں": "سرگوشی",
  "سرگوشیو": "سرگوشی",
  "سرگوشیوں": "سرگوشی",
  "سرجن": "سرجن",
  "سرجنو": "سرجن",
  "سرجنوں": "سرجن",
  "سرک": "سرکنا",
  "سرکے": "سرکنا",
  "سرکں": "سرکنا",
  "سرکش": "سرکش",
  "سرکشو": "سرکش",
  "سرکشوں": "سرکش",
  "سرکا": "سرکنا",
  "سرکانے": "سرکنا",
  "سرکانا": "سرکنا",
  "سرکاتے": "سرکنا",
  "سرکاتا": "سرکنا",
  "سرکاتی": "سرکنا",
  "سرکاتیں": "سرکنا",
  "سرکاؤ": "سرکنا",
  "سرکاؤں": "سرکنا",
  "سرکائے": "سرکنا",
  "سرکائی": "سرکنا",
  "سرکائیے": "سرکنا",
  "سرکائیں": "سرکنا",
  "سرکایا": "سرکنا",
  "سرکنڈے": "سرکنڈہ",
  "سرکنڈہ": "سرکنڈہ",
  "سرکنڈو": "سرکنڈہ",
  "سرکنڈوں": "سرکنڈہ",
  "سرکنے": "سرکنا",
  "سرکنا": "سرکنا",
  "سرکنی": "سرکنا",
  "سرکتے": "سرکنا",
  "سرکتا": "سرکنا",
  "سرکتی": "سرکنا",
  "سرکتیں": "سرکنا",
  "سرکو": "سرکنا",
  "سرکوں": "سرکنا",
  "سرکوا": "سرکنا",
  "سرکوانے": "سرکنا",
  "سرکوانا": "سرکنا",
  "سرکواتے": "سرکنا",
  "سرکواتا": "سرکنا",
  "سرکواتی": "سرکنا",
  "سرکواتیں": "سرکنا",
  "سرکواؤ": "سرکنا",
  "سرکواؤں": "سرکنا",
  "سرکوائے": "سرکنا",
  "سرکوائی": "سرکنا",
  "سرکوائیے": "سرکنا",
  "سرکوائیں": "سرکنا",
  "سرکوایا": "سرکنا",
  "سرکی": "سرکنا",
  "سرکیے": "سرکنا",
  "سرکیں": "سرکنا",
  "سرمے": "سرمہ",
  "سرمہ": "سرمہ",
  "سرمستی": "سرمستی",
  "سرمستیاں": "سرمستی",
  "سرمستیو": "سرمستی",
  "سرمستیوں": "سرمستی",
  "سرمو": "سرمہ",
  "سرموں": "سرمہ",
  "سرنگ": "سرنگ",
  "سرنگو": "سرنگ",
  "سرنگوں": "سرنگ",
  "سرنگیں": "سرنگ",
  "سرقے": "سرقہ",
  "سرقہ": "سرقہ",
  "سرقو": "سرقہ",
  "سرقوں": "سرقہ",
  "سرسبز": "سرسبز",
  "سرسبزو": "سرسبز",
  "سرسبزوں": "سرسبز",
  "سرسرا": "سرسرانا",
  "سرسرانے": "سرسرانا",
  "سرسرانا": "سرسرانا",
  "سرسرانی": "سرسرانا",
  "سرسراتے": "سرسرانا",
  "سرسراتا": "سرسرانا",
  "سرسراتی": "سرسرانا",
  "سرسراتیں": "سرسرانا",
  "سرسراؤ": "سرسرانا",
  "سرسراؤں": "سرسرانا",
  "سرسرائے": "سرسرانا",
  "سرسرائی": "سرسرانا",
  "سرسرائیے": "سرسرانا",
  "سرسرائیں": "سرسرانا",
  "سرسرایا": "سرسرانا",
  "سرتاج": "سرتاج",
  "سرتاجو": "سرتاج",
  "سرتاجوں": "سرتاج",
  "سرو": "سرا",
  "سروں": "سرا",
  "سریے": "سریہ",
  "سریہ": "سریہ",
  "سریو": "سریہ",
  "سریوں": "سریہ",
  "سسکی": "سسکی",
  "سسکیاں": "سسکی",
  "سسکیو": "سسکی",
  "سسکیوں": "سسکی",
  "ست": "ست",
  "ستے": "ستنا",
  "ستں": "ستنا",
  "ستا": "ستنا",
  "ستانے": "ستنا",
  "ستانا": "ستنا",
  "ستار": "ستار",
  "ستارے": "ستارہ",
  "ستارہ": "ستارہ",
  "ستارو": "ستارہ",
  "ستاروں": "ستارہ",
  "ستاریں": "ستار",
  "ستاتے": "ستنا",
  "ستاتا": "ستنا",
  "ستاتی": "ستنا",
  "ستاتیں": "ستنا",
  "ستاؤ": "ستنا",
  "ستاؤں": "ستنا",
  "ستائے": "ستنا",
  "ستائش": "ستائش",
  "ستائشو": "ستائش",
  "ستائشوں": "ستائش",
  "ستائشیں": "ستائش",
  "ستائس": "ستائس",
  "ستائی": "ستنا",
  "ستائیے": "ستنا",
  "ستائیں": "ستنا",
  "ستایا": "ستنا",
  "ستمگر": "ستمگر",
  "ستمگرو": "ستمگر",
  "ستمگروں": "ستمگر",
  "ستنے": "ستنا",
  "ستنا": "ستنا",
  "ستنی": "ستنا",
  "سترے": "سترہ",
  "سترہ": "سترہ",
  "سترو": "سترہ",
  "ستروں": "سترہ",
  "ستتے": "ستنا",
  "ستتا": "ستنا",
  "ستتی": "ستنا",
  "ستتیں": "ستنا",
  "ستو": "ست",
  "ستوں": "ست",
  "ستوا": "ستنا",
  "ستوانے": "ستنا",
  "ستوانا": "ستنا",
  "ستواتے": "ستنا",
  "ستواتا": "ستنا",
  "ستواتی": "ستنا",
  "ستواتیں": "ستنا",
  "ستواؤ": "ستنا",
  "ستواؤں": "ستنا",
  "ستوائے": "ستنا",
  "ستوائی": "ستنا",
  "ستوائیے": "ستنا",
  "ستوائیں": "ستنا",
  "ستوایا": "ستنا",
  "ستون": "ستون",
  "ستونو": "ستون",
  "ستونوں": "ستون",
  "ستی": "ستنا",
  "ستیے": "ستنا",
  "ستیں": "ست",
  "سو": "سونا",
  "سوِیڈن": "سوِیڈن",
  "سوغات": "سوغات",
  "سوغاتو": "سوغات",
  "سوغاتوں": "سوغات",
  "سوغاتیں": "سوغات",
  "سواں": "سواں",
  "سوال": "سوال",
  "سوالو": "سوال",
  "سوالوں": "سوال",
  "سوار": "سوار",
  "سوارو": "سوار",
  "سواروں": "سوار",
  "سواری": "سواری",
  "سواریں": "سوار",
  "سواریاں": "سواری",
  "سواریو": "سواری",
  "سواریوں": "سواری",
  "سوچ": "سوچ",
  "سوچے": "سوچنا",
  "سوچں": "سوچنا",
  "سوچا": "سوچنا",
  "سوچنے": "سوچنا",
  "سوچنا": "سوچنا",
  "سوچنی": "سوچنا",
  "سوچت": "سوچت",
  "سوچتے": "سوچنا",
  "سوچتا": "سوچنا",
  "سوچتو": "سوچت",
  "سوچتوں": "سوچت",
  "سوچتی": "سوچنا",
  "سوچتیں": "سوچت",
  "سوچو": "سوچ",
  "سوچوں": "سوچ",
  "سوچوا": "سوچنا",
  "سوچوانے": "سوچنا",
  "سوچوانا": "سوچنا",
  "سوچواتے": "سوچنا",
  "سوچواتا": "سوچنا",
  "سوچواتی": "سوچنا",
  "سوچواتیں": "سوچنا",
  "سوچواؤ": "سوچنا",
  "سوچواؤں": "سوچنا",
  "سوچوائے": "سوچنا",
  "سوچوائی": "سوچنا",
  "سوچوائیے": "سوچنا",
  "سوچوائیں": "سوچنا",
  "سوچوایا": "سوچنا",
  "سوچی": "سوچنا",
  "سوچیے": "سوچنا",
  "سوچیں": "سوچ",
  "سود": "سود",
  "سودے": "سودا",
  "سودا": "سودا",
  "سوداگر": "سوداگر",
  "سوداگرو": "سوداگر",
  "سوداگروں": "سوداگر",
  "سودہ": "سودہ",
  "سودو": "سودا",
  "سودوں": "سودا",
  "سوگند": "سوگند",
  "سوگندو": "سوگند",
  "سوگندوں": "سوگند",
  "سوگندیں": "سوگند",
  "سوجھ": "سوجھنا",
  "سوجھے": "سوجھنا",
  "سوجھں": "سوجھنا",
  "سوجھا": "سوجھنا",
  "سوجھنے": "سوجھنا",
  "سوجھنا": "سوجھنا",
  "سوجھنی": "سوجھنا",
  "سوجھتے": "سوجھنا",
  "سوجھتا": "سوجھنا",
  "سوجھتی": "سوجھنا",
  "سوجھتیں": "سوجھنا",
  "سوجھو": "سوجھنا",
  "سوجھوں": "سوجھنا",
  "سوجھی": "سوجھنا",
  "سوجھیے": "سوجھنا",
  "سوجھیں": "سوجھنا",
  "سوکن": "سوکن",
  "سوکنو": "سوکن",
  "سوکنوں": "سوکن",
  "سوکنیں": "سوکن",
  "سوکھ": "سوکھنا",
  "سوکھے": "سوکھنا",
  "سوکھں": "سوکھنا",
  "سوکھا": "سوکھنا",
  "سوکھانے": "سوکھنا",
  "سوکھانا": "سوکھنا",
  "سوکھاتے": "سوکھنا",
  "سوکھاتا": "سوکھنا",
  "سوکھاتی": "سوکھنا",
  "سوکھاتیں": "سوکھنا",
  "سوکھاؤ": "سوکھنا",
  "سوکھاؤں": "سوکھنا",
  "سوکھائے": "سوکھنا",
  "سوکھائی": "سوکھنا",
  "سوکھائیے": "سوکھنا",
  "سوکھائیں": "سوکھنا",
  "سوکھایا": "سوکھنا",
  "سوکھنے": "سوکھنا",
  "سوکھنا": "سوکھنا",
  "سوکھنی": "سوکھنا",
  "سوکھتے": "سوکھنا",
  "سوکھتا": "سوکھنا",
  "سوکھتی": "سوکھنا",
  "سوکھتیں": "سوکھنا",
  "سوکھو": "سوکھنا",
  "سوکھوں": "سوکھنا",
  "سوکھوا": "سوکھنا",
  "سوکھوانے": "سوکھنا",
  "سوکھوانا": "سوکھنا",
  "سوکھواتے": "سوکھنا",
  "سوکھواتا": "سوکھنا",
  "سوکھواتی": "سوکھنا",
  "سوکھواتیں": "سوکھنا",
  "سوکھواؤ": "سوکھنا",
  "سوکھواؤں": "سوکھنا",
  "سوکھوائے": "سوکھنا",
  "سوکھوائی": "سوکھنا",
  "سوکھوائیے": "سوکھنا",
  "سوکھوائیں": "سوکھنا",
  "سوکھوایا": "سوکھنا",
  "سوکھی": "سوکھنا",
  "سوکھیے": "سوکھنا",
  "سوکھیں": "سوکھنا",
  "سولہ": "سولہ",
  "سولہواں": "سولہواں",
  "سولہووںں": "سولہواں",
  "سولہویں": "سولہواں",
  "سونے": "سونا",
  "سونا": "سونا",
  "سونگھ": "سونگھنا",
  "سونگھے": "سونگھنا",
  "سونگھں": "سونگھنا",
  "سونگھا": "سونگھنا",
  "سونگھنے": "سونگھنا",
  "سونگھنا": "سونگھنا",
  "سونگھنی": "سونگھنا",
  "سونگھتے": "سونگھنا",
  "سونگھتا": "سونگھنا",
  "سونگھتی": "سونگھنا",
  "سونگھتیں": "سونگھنا",
  "سونگھو": "سونگھنا",
  "سونگھوں": "سونگھنا",
  "سونگھی": "سونگھنا",
  "سونگھیے": "سونگھنا",
  "سونگھیں": "سونگھنا",
  "سونو": "سونا",
  "سونوں": "سونا",
  "سونی": "سونا",
  "سور": "سور",
  "سورے": "سورہ",
  "سورہ": "سورہ",
  "سورج": "سورج",
  "سورجو": "سورج",
  "سورجوں": "سورج",
  "سورت": "سورت",
  "سورتو": "سورت",
  "سورتوں": "سورت",
  "سورتیں": "سورت",
  "سورو": "سورہ",
  "سوروں": "سورہ",
  "سوسائٹی": "سوسائٹی",
  "سوسائٹیاں": "سوسائٹی",
  "سوسائٹیو": "سوسائٹی",
  "سوسائٹیوں": "سوسائٹی",
  "سوت": "سوت",
  "سوتے": "سونا",
  "سوتا": "سونا",
  "سوتو": "سوت",
  "سوتوں": "سوت",
  "سوتی": "سونا",
  "سوتیں": "سوت",
  "سووںں": "سواں",
  "سوؤ": "سونا",
  "سوؤں": "سونا",
  "سویں": "سواں",
  "سوئے": "سونا",
  "سوئی": "سوئی",
  "سوئیے": "سونا",
  "سوئیں": "سونا",
  "سوئیو": "سوئی",
  "سوئیوں": "سوئی",
  "سویا": "سونا",
  "سوز": "سوز",
  "سوزو": "سوز",
  "سوزوں": "سوز",
  "سوزی": "سوزی",
  "سوزیاں": "سوزی",
  "سوزیو": "سوزی",
  "سوزیوں": "سوزی",
  "سی": "سینا",
  "سیّارے": "سیّارہ",
  "سیّارہ": "سیّارہ",
  "سیّارو": "سیّارہ",
  "سیّاروں": "سیّارہ",
  "سیے": "سینا",
  "سیخ": "سیخ",
  "سیخو": "سیخ",
  "سیخوں": "سیخ",
  "سیخیں": "سیخ",
  "سیں": "سینا",
  "سیڑھی": "سیڑھی",
  "سیڑھیاں": "سیڑھی",
  "سیڑھیو": "سیڑھی",
  "سیڑھیوں": "سیڑھی",
  "سیٹ": "سیٹ",
  "سیٹو": "سیٹ",
  "سیٹوں": "سیٹ",
  "سیٹی": "سیٹی",
  "سیٹیں": "سیٹ",
  "سیٹیاں": "سیٹی",
  "سیٹیو": "سیٹی",
  "سیٹیوں": "سیٹی",
  "سیا": "سینا",
  "سیاح": "سیاح",
  "سیاحو": "سیاح",
  "سیاحوں": "سیاح",
  "سیانے": "سیانا",
  "سیانا": "سیانا",
  "سیانو": "سیانا",
  "سیانوں": "سیانا",
  "سیارے": "سیارہ",
  "سیارہ": "سیارہ",
  "سیارو": "سیارہ",
  "سیاروں": "سیارہ",
  "سیاستدان": "سیاستدان",
  "سیاستدانو": "سیاستدان",
  "سیاستدانوں": "سیاستدان",
  "سیب": "سیب",
  "سیبو": "سیب",
  "سیبوں": "سیب",
  "سید": "سید",
  "سیدو": "سید",
  "سیدوں": "سید",
  "سیک": "سکنا",
  "سیکے": "سکنا",
  "سیکں": "سکنا",
  "سیکا": "سکنا",
  "سیکنے": "سکنا",
  "سیکنا": "سکنا",
  "سیکرٹری": "سیکرٹری",
  "سیکرٹریاں": "سیکرٹری",
  "سیکرٹریو": "سیکرٹری",
  "سیکرٹریوں": "سیکرٹری",
  "سیکریٹری": "سیکریٹری",
  "سیکریٹریاں": "سیکریٹری",
  "سیکریٹریو": "سیکریٹری",
  "سیکریٹریوں": "سیکریٹری",
  "سیکتے": "سکنا",
  "سیکتا": "سکنا",
  "سیکتی": "سکنا",
  "سیکتیں": "سکنا",
  "سیکو": "سکنا",
  "سیکوں": "سکنا",
  "سیکوا": "سکنا",
  "سیکوانے": "سکنا",
  "سیکوانا": "سکنا",
  "سیکواتے": "سکنا",
  "سیکواتا": "سکنا",
  "سیکواتی": "سکنا",
  "سیکواتیں": "سکنا",
  "سیکواؤ": "سکنا",
  "سیکواؤں": "سکنا",
  "سیکوائے": "سکنا",
  "سیکوائی": "سکنا",
  "سیکوائیے": "سکنا",
  "سیکوائیں": "سکنا",
  "سیکوایا": "سکنا",
  "سیکی": "سکنا",
  "سیکیے": "سکنا",
  "سیکیں": "سکنا",
  "سیکھ": "سیکھنا",
  "سیکھے": "سیکھنا",
  "سیکھں": "سیکھنا",
  "سیکھا": "سیکھنا",
  "سیکھنے": "سیکھنا",
  "سیکھنا": "سیکھنا",
  "سیکھنی": "سیکھنا",
  "سیکھتے": "سیکھنا",
  "سیکھتا": "سیکھنا",
  "سیکھتی": "سیکھنا",
  "سیکھتیں": "سیکھنا",
  "سیکھو": "سیکھنا",
  "سیکھوں": "سیکھنا",
  "سیکھی": "سیکھنا",
  "سیکھیے": "سیکھنا",
  "سیکھیں": "سیکھنا",
  "سیلزمین": "سیلزمین",
  "سیلزمینو": "سیلزمین",
  "سیلزمینوں": "سیلزمین",
  "سین": "سین",
  "سینے": "سینہ",
  "سینا": "سینا",
  "سینچ": "سینچنا",
  "سینچے": "سینچنا",
  "سینچں": "سینچنا",
  "سینچا": "سینچنا",
  "سینچانے": "سینچنا",
  "سینچانا": "سینچنا",
  "سینچاتے": "سینچنا",
  "سینچاتا": "سینچنا",
  "سینچاتی": "سینچنا",
  "سینچاتیں": "سینچنا",
  "سینچاؤ": "سینچنا",
  "سینچاؤں": "سینچنا",
  "سینچائے": "سینچنا",
  "سینچائی": "سینچنا",
  "سینچائیے": "سینچنا",
  "سینچائیں": "سینچنا",
  "سینچایا": "سینچنا",
  "سینچنے": "سینچنا",
  "سینچنا": "سینچنا",
  "سینچنی": "سینچنا",
  "سینچتے": "سینچنا",
  "سینچتا": "سینچنا",
  "سینچتی": "سینچنا",
  "سینچتیں": "سینچنا",
  "سینچو": "سینچنا",
  "سینچوں": "سینچنا",
  "سینچوا": "سینچنا",
  "سینچوانے": "سینچنا",
  "سینچوانا": "سینچنا",
  "سینچواتے": "سینچنا",
  "سینچواتا": "سینچنا",
  "سینچواتی": "سینچنا",
  "سینچواتیں": "سینچنا",
  "سینچواؤ": "سینچنا",
  "سینچواؤں": "سینچنا",
  "سینچوائے": "سینچنا",
  "سینچوائی": "سینچنا",
  "سینچوائیے": "سینچنا",
  "سینچوائیں": "سینچنا",
  "سینچوایا": "سینچنا",
  "سینچی": "سینچنا",
  "سینچیے": "سینچنا",
  "سینچیں": "سینچنا",
  "سینگ": "سینگ",
  "سینگو": "سینگ",
  "سینگوں": "سینگ",
  "سینگیں": "سینگ",
  "سینہ": "سینہ",
  "سینو": "سینہ",
  "سینوں": "سینہ",
  "سینوری": "سینوری",
  "سینوریاں": "سینوری",
  "سینوریو": "سینوری",
  "سینوریوں": "سینوری",
  "سینی": "سینا",
  "سیپارے": "سیپارہ",
  "سیپارہ": "سیپارہ",
  "سیپارو": "سیپارہ",
  "سیپاروں": "سیپارہ",
  "سیر": "سیر",
  "سیرو": "سیر",
  "سیروں": "سیر",
  "سیریں": "سیر",
  "سیتے": "سینا",
  "سیتا": "سینا",
  "سیتی": "سینا",
  "سیتیں": "سینا",
  "سیو": "سینا",
  "سیوں": "سینا",
  "سیوک": "سیوک",
  "سیوکو": "سیوک",
  "سیوکوں": "سیوک",
  "سیی": "سینا",
  "سییے": "سینا",
  "سییں": "سینا",
  "سزا": "سزا",
  "سزاؤ": "سزا",
  "سزاؤں": "سزا",
  "سزاوار": "سزاوار",
  "سزاوارو": "سزاوار",
  "سزاواروں": "سزاوار",
  "سزائیں": "سزا",
  "سطر": "سطر",
  "سطرو": "سطر",
  "سطروں": "سطر",
  "سطریں": "سطر",
  "ت": "ت",
  "تَصْوِیر": "تَصْوِیر",
  "تَصْوِیرو": "تَصْوِیر",
  "تَصْوِیروں": "تَصْوِیر",
  "تَصْوِیریں": "تَصْوِیر",
  "تَب": "تَب",
  "تَک": "تَک",
  "تَلْوار": "تَلْوار",
  "تَلْوارو": "تَلْوار",
  "تَلْواروں": "تَلْوار",
  "تَلْواریں": "تَلْوار",
  "تَلَک": "تَلَک",
  "تَلے": "تَلے",
  "تَمَنّا": "تَمَنّا",
  "تَمَنّاؤ": "تَمَنّا",
  "تَمَنّاؤں": "تَمَنّا",
  "تَمَنّائیں": "تَمَنّا",
  "تِین": "تِین",
  "تُڑْوا": "ٹُوٹْنا",
  "تُڑْوانے": "ٹُوٹْنا",
  "تُڑْوانا": "ٹُوٹْنا",
  "تُڑْواتے": "ٹُوٹْنا",
  "تُڑْواتا": "ٹُوٹْنا",
  "تُڑْواتی": "ٹُوٹْنا",
  "تُڑْواتیں": "ٹُوٹْنا",
  "تُڑْواؤ": "ٹُوٹْنا",
  "تُڑْواؤں": "ٹُوٹْنا",
  "تُڑْوائے": "ٹُوٹْنا",
  "تُڑْوائی": "ٹُوٹْنا",
  "تُڑْوائیے": "ٹُوٹْنا",
  "تُڑْوائیں": "ٹُوٹْنا",
  "تُڑْوایا": "ٹُوٹْنا",
  "تُڑا": "توڑْنا",
  "تُڑانے": "توڑْنا",
  "تُڑانا": "توڑْنا",
  "تُڑاتے": "توڑْنا",
  "تُڑاتا": "توڑْنا",
  "تُڑاتی": "توڑْنا",
  "تُڑاتیں": "توڑْنا",
  "تُڑاؤ": "توڑْنا",
  "تُڑاؤں": "توڑْنا",
  "تُڑائے": "توڑْنا",
  "تُڑائی": "توڑْنا",
  "تُڑائیے": "توڑْنا",
  "تُڑائیں": "توڑْنا",
  "تُڑایا": "توڑْنا",
  "تُجھ": "میں",
  "تُم": "میں",
  "تُمْھارے": "میرا",
  "تُمْھارا": "میرا",
  "تُمْھاری": "میرا",
  "تُو": "میں",
  "تحصیلدار": "تحصیلدار",
  "تحصیلدارو": "تحصیلدار",
  "تحصیلداروں": "تحصیلدار",
  "تحفے": "تحفہ",
  "تحفہ": "تحفہ",
  "تحفو": "تحفہ",
  "تحفوں": "تحفہ",
  "تحریک": "تحریک",
  "تحریکو": "تحریک",
  "تحریکوں": "تحریک",
  "تحریکیں": "تحریک",
  "تحریر": "تحریر",
  "تحریرو": "تحریر",
  "تحریروں": "تحریر",
  "تحریریں": "تحریر",
  "تخلیے": "تخلیہ",
  "تخلیہ": "تخلیہ",
  "تخلیو": "تخلیہ",
  "تخلیوں": "تخلیہ",
  "تخت": "تخت",
  "تختے": "تختہ",
  "تختہ": "تختہ",
  "تختو": "تختہ",
  "تختوں": "تختہ",
  "تختی": "تختی",
  "تختیں": "تخت",
  "تختیاں": "تختی",
  "تختیو": "تختی",
  "تختیوں": "تختی",
  "تڑا": "توڑنا",
  "تڑانے": "توڑنا",
  "تڑانا": "توڑنا",
  "تڑاتے": "توڑنا",
  "تڑاتا": "توڑنا",
  "تڑاتی": "توڑنا",
  "تڑاتیں": "توڑنا",
  "تڑاؤ": "توڑنا",
  "تڑاؤں": "توڑنا",
  "تڑائے": "توڑنا",
  "تڑائی": "توڑنا",
  "تڑائیے": "توڑنا",
  "تڑائیں": "توڑنا",
  "تڑایا": "توڑنا",
  "تڑپ": "تڑپنا",
  "تڑپے": "تڑپنا",
  "تڑپں": "تڑپنا",
  "تڑپا": "تڑپنا",
  "تڑپانے": "تڑپنا",
  "تڑپانا": "تڑپنا",
  "تڑپاتے": "تڑپنا",
  "تڑپاتا": "تڑپنا",
  "تڑپاتی": "تڑپنا",
  "تڑپاتیں": "تڑپنا",
  "تڑپاؤ": "تڑپنا",
  "تڑپاؤں": "تڑپنا",
  "تڑپائے": "تڑپنا",
  "تڑپائی": "تڑپنا",
  "تڑپائیے": "تڑپنا",
  "تڑپائیں": "تڑپنا",
  "تڑپایا": "تڑپنا",
  "تڑپنے": "تڑپنا",
  "تڑپنا": "تڑپنا",
  "تڑپنی": "تڑپنا",
  "تڑپتے": "تڑپنا",
  "تڑپتا": "تڑپنا",
  "تڑپتی": "تڑپنا",
  "تڑپتیں": "تڑپنا",
  "تڑپو": "تڑپنا",
  "تڑپوں": "تڑپنا",
  "تڑپوا": "تڑپنا",
  "تڑپوانے": "تڑپنا",
  "تڑپوانا": "تڑپنا",
  "تڑپواتے": "تڑپنا",
  "تڑپواتا": "تڑپنا",
  "تڑپواتی": "تڑپنا",
  "تڑپواتیں": "تڑپنا",
  "تڑپواؤ": "تڑپنا",
  "تڑپواؤں": "تڑپنا",
  "تڑپوائے": "تڑپنا",
  "تڑپوائی": "تڑپنا",
  "تڑپوائیے": "تڑپنا",
  "تڑپوائیں": "تڑپنا",
  "تڑپوایا": "تڑپنا",
  "تڑپی": "تڑپنا",
  "تڑپیے": "تڑپنا",
  "تڑپیں": "تڑپنا",
  "تڑوا": "توڑنا",
  "تڑوانے": "توڑنا",
  "تڑوانا": "توڑنا",
  "تڑواتے": "توڑنا",
  "تڑواتا": "توڑنا",
  "تڑواتی": "توڑنا",
  "تڑواتیں": "توڑنا",
  "تڑواؤ": "توڑنا",
  "تڑواؤں": "توڑنا",
  "تڑوائے": "توڑنا",
  "تڑوائی": "توڑنا",
  "تڑوائیے": "توڑنا",
  "تڑوائیں": "توڑنا",
  "تڑوایا": "توڑنا",
  "تصور": "تصور",
  "تصورو": "تصور",
  "تصوروں": "تصور",
  "تصویر": "تصویر",
  "تصویرو": "تصویر",
  "تصویروں": "تصویر",
  "تصویریں": "تصویر",
  "تشبیہ": "تشبیہ",
  "تشبیہو": "تشبیہ",
  "تشبیہوں": "تشبیہ",
  "تشبیہیں": "تشبیہ",
  "تذکر": "تذکر",
  "تذکرے": "تذکرہ",
  "تذکرہ": "تذکرہ",
  "تذکرو": "تذکرہ",
  "تذکروں": "تذکرہ",
  "تذکیے": "تذکیہ",
  "تذکیہ": "تذکیہ",
  "تذکیو": "تذکیہ",
  "تذکیوں": "تذکیہ",
  "تاج": "تاج",
  "تاجر": "تاجر",
  "تاجرو": "تاجر",
  "تاجروں": "تاجر",
  "تاجو": "تاج",
  "تاجوں": "تاج",
  "تاک": "تکنا",
  "تاکے": "تکنا",
  "تاکں": "تکنا",
  "تاکا": "تکنا",
  "تاکہ": "تاکہ",
  "تاکنے": "تکنا",
  "تاکنا": "تکنا",
  "تاکتے": "تکنا",
  "تاکتا": "تکنا",
  "تاکتی": "تکنا",
  "تاکتیں": "تکنا",
  "تاکو": "تکنا",
  "تاکوں": "تکنا",
  "تاکی": "تکنا",
  "تاکیے": "تکنا",
  "تاکیں": "تکنا",
  "تاکید": "تاکید",
  "تاکیدو": "تاکید",
  "تاکیدوں": "تاکید",
  "تاکیدیں": "تاکید",
  "تال": "تال",
  "تالے": "تالا",
  "تالا": "تالا",
  "تالاب": "تالاب",
  "تالابو": "تالاب",
  "تالابوں": "تالاب",
  "تالابیں": "تالاب",
  "تالہ": "تالہ",
  "تالو": "تالا",
  "تالوں": "تالا",
  "تالی": "تالی",
  "تالیاں": "تالی",
  "تالیو": "تالی",
  "تالیوں": "تالی",
  "تان": "تننا",
  "تانے": "تانہ",
  "تانں": "تننا",
  "تانا": "تننا",
  "تانبے": "تانبہ",
  "تانبہ": "تانبہ",
  "تانبو": "تانبہ",
  "تانبوں": "تانبہ",
  "تانگے": "تانگا",
  "تانگا": "تانگا",
  "تانگہ": "تانگہ",
  "تانگو": "تانگا",
  "تانگوں": "تانگا",
  "تانہ": "تانہ",
  "تاننے": "تننا",
  "تاننا": "تننا",
  "تانتے": "تننا",
  "تانتا": "تننا",
  "تانتی": "تننا",
  "تانتیں": "تننا",
  "تانو": "تانہ",
  "تانوں": "تانہ",
  "تانی": "تننا",
  "تانیے": "تننا",
  "تانیں": "تننا",
  "تاپ": "تپنا",
  "تاپے": "تپنا",
  "تاپں": "تپنا",
  "تاپا": "تپنا",
  "تاپنے": "تپنا",
  "تاپنا": "تپنا",
  "تاپتے": "تپنا",
  "تاپتا": "تپنا",
  "تاپتی": "تپنا",
  "تاپتیں": "تپنا",
  "تاپو": "تپنا",
  "تاپوں": "تپنا",
  "تاپی": "تپنا",
  "تاپیے": "تپنا",
  "تاپیں": "تپنا",
  "تار": "تار",
  "تارے": "تارا",
  "تارں": "ترنا",
  "تارا": "تارا",
  "تارہ": "تارہ",
  "تارنے": "ترنا",
  "تارنا": "ترنا",
  "تارتے": "ترنا",
  "تارتا": "ترنا",
  "تارتی": "ترنا",
  "تارتیں": "ترنا",
  "تارو": "تارا",
  "تاروں": "تارا",
  "تاری": "ترنا",
  "تاریے": "ترنا",
  "تاریخ": "تاریخ",
  "تاریخو": "تاریخ",
  "تاریخوں": "تاریخ",
  "تاریخیں": "تاریخ",
  "تاریں": "تار",
  "تاریکی": "تاریکی",
  "تاریکیاں": "تاریکی",
  "تاریکیو": "تاریکی",
  "تاریکیوں": "تاریکی",
  "تاؤ": "تاؤ",
  "تازے": "تازہ",
  "تازہ": "تازہ",
  "تازو": "تازہ",
  "تازوں": "تازہ",
  "تازی": "تازہ",
  "تازیانے": "تازیانہ",
  "تازیانہ": "تازیانہ",
  "تازیانو": "تازیانہ",
  "تازیانوں": "تازیانہ",
  "تب": "تَب",
  "تبصرے": "تبصرہ",
  "تبصرہ": "تبصرہ",
  "تبصرو": "تبصرہ",
  "تبصروں": "تبصرہ",
  "تبادلے": "تبادلہ",
  "تبادلہ": "تبادلہ",
  "تبادلو": "تبادلہ",
  "تبادلوں": "تبادلہ",
  "تبدیلی": "تبدیلی",
  "تبدیلیاں": "تبدیلی",
  "تبدیلیو": "تبدیلی",
  "تبدیلیوں": "تبدیلی",
  "تدبیر": "تدبیر",
  "تدبیرو": "تدبیر",
  "تدبیروں": "تدبیر",
  "تدبیریں": "تدبیر",
  "تعبیر": "تعبیر",
  "تعبیرو": "تعبیر",
  "تعبیروں": "تعبیر",
  "تعبیریں": "تعبیر",
  "تعرف": "تعرف",
  "تعرفو": "تعرف",
  "تعرفوں": "تعرف",
  "تعریف": "تعریف",
  "تعریفو": "تعریف",
  "تعریفوں": "تعریف",
  "تعریفیں": "تعریف",
  "تعویذ": "تعویذ",
  "تعویذو": "تعویذ",
  "تعویذوں": "تعویذ",
  "تعویذیں": "تعویذ",
  "تعطیل": "تعطیل",
  "تعطیلو": "تعطیل",
  "تعطیلوں": "تعطیل",
  "تعطیلیں": "تعطیل",
  "تفصیل": "تفصیل",
  "تفصیلو": "تفصیل",
  "تفصیلوں": "تفصیل",
  "تفصیلیں": "تفصیل",
  "تفرقے": "تفرقہ",
  "تفرقہ": "تفرقہ",
  "تفرقو": "تفرقہ",
  "تفرقوں": "تفرقہ",
  "تہذیب": "تہذیب",
  "تہذیبو": "تہذیب",
  "تہذیبوں": "تہذیب",
  "تہذیبیں": "تہذیب",
  "تہمت": "تہمت",
  "تہمتو": "تہمت",
  "تہمتوں": "تہمت",
  "تہمتیں": "تہمت",
  "تہوار": "تہوار",
  "تہوارو": "تہوار",
  "تہواروں": "تہوار",
  "تہواریں": "تہوار",
  "تجربے": "تجربہ",
  "تجربہ": "تجربہ",
  "تجربو": "تجربہ",
  "تجربوں": "تجربہ",
  "تجوری": "تجوری",
  "تجوریاں": "تجوری",
  "تجوریو": "تجوری",
  "تجوریوں": "تجوری",
  "تجویز": "تجویز",
  "تجویزو": "تجویز",
  "تجویزوں": "تجویز",
  "تجویزیں": "تجویز",
  "تجزیے": "تجزیہ",
  "تجزیہ": "تجزیہ",
  "تجزیو": "تجزیہ",
  "تجزیوں": "تجزیہ",
  "تجھ": "میں",
  "تک": "تکنا",
  "تکے": "تکا",
  "تکں": "تکنا",
  "تکا": "تکا",
  "تکانے": "تکنا",
  "تکانا": "تکنا",
  "تکاتے": "تکنا",
  "تکاتا": "تکنا",
  "تکاتی": "تکنا",
  "تکاتیں": "تکنا",
  "تکاؤ": "تکنا",
  "تکاؤں": "تکنا",
  "تکائے": "تکنا",
  "تکائی": "تکنا",
  "تکائیے": "تکنا",
  "تکائیں": "تکنا",
  "تکایا": "تکنا",
  "تکبیر": "تکبیر",
  "تکبیرو": "تکبیر",
  "تکبیروں": "تکبیر",
  "تکبیریں": "تکبیر",
  "تکہ": "تکہ",
  "تکلیف": "تکلیف",
  "تکلیفو": "تکلیف",
  "تکلیفوں": "تکلیف",
  "تکلیفیں": "تکلیف",
  "تکنے": "تکنا",
  "تکنا": "تکنا",
  "تکنی": "تکنا",
  "تکنیک": "تکنیک",
  "تکنیکو": "تکنیک",
  "تکنیکوں": "تکنیک",
  "تکنیکیں": "تکنیک",
  "تکرا": "تکرانا",
  "تکرانے": "تکرانا",
  "تکرانا": "تکرانا",
  "تکرانی": "تکرانا",
  "تکراتے": "تکرانا",
  "تکراتا": "تکرانا",
  "تکراتی": "تکرانا",
  "تکراتیں": "تکرانا",
  "تکراؤ": "تکرانا",
  "تکراؤں": "تکرانا",
  "تکرائے": "تکرانا",
  "تکرائی": "تکرانا",
  "تکرائیے": "تکرانا",
  "تکرائیں": "تکرانا",
  "تکرایا": "تکرانا",
  "تکتے": "تکنا",
  "تکتا": "تکنا",
  "تکتی": "تکنا",
  "تکتیں": "تکنا",
  "تکو": "تکا",
  "تکوں": "تکا",
  "تکوا": "تکنا",
  "تکوانے": "تکنا",
  "تکوانا": "تکنا",
  "تکواتے": "تکنا",
  "تکواتا": "تکنا",
  "تکواتی": "تکنا",
  "تکواتیں": "تکنا",
  "تکواؤ": "تکنا",
  "تکواؤں": "تکنا",
  "تکوائے": "تکنا",
  "تکوائی": "تکنا",
  "تکوائیے": "تکنا",
  "تکوائیں": "تکنا",
  "تکوایا": "تکنا",
  "تکی": "تکی",
  "تکیے": "تکیہ",
  "تکیں": "تکنا",
  "تکیاں": "تکی",
  "تکیہ": "تکیہ",
  "تکیو": "تکیہ",
  "تکیوں": "تکیہ",
  "تل": "تل",
  "تلے": "تلا",
  "تلخی": "تلخی",
  "تلخیاں": "تلخی",
  "تلخیو": "تلخی",
  "تلخیوں": "تلخی",
  "تلں": "تلنا",
  "تلا": "تلا",
  "تلاشی": "تلاشی",
  "تلاشیاں": "تلاشی",
  "تلاشیو": "تلاشی",
  "تلاشیوں": "تلاشی",
  "تلانے": "تلنا",
  "تلانا": "تلنا",
  "تلاتے": "تلنا",
  "تلاتا": "تلنا",
  "تلاتی": "تلنا",
  "تلاتیں": "تلنا",
  "تلاؤ": "تلنا",
  "تلاؤں": "تلنا",
  "تلائے": "تلنا",
  "تلائی": "تلنا",
  "تلائیے": "تلنا",
  "تلائیں": "تلنا",
  "تلایا": "تلنا",
  "تلازمے": "تلازمہ",
  "تلازمہ": "تلازمہ",
  "تلازمو": "تلازمہ",
  "تلازموں": "تلازمہ",
  "تلہ": "تلہ",
  "تلک": "تلک",
  "تلنے": "تلنا",
  "تلنا": "تلنا",
  "تلنی": "تلنا",
  "تلتے": "تلنا",
  "تلتا": "تلنا",
  "تلتی": "تلنا",
  "تلتیں": "تلنا",
  "تلو": "تلا",
  "تلوے": "تلوا",
  "تلوں": "تلا",
  "تلوا": "تلوا",
  "تلوانے": "تلنا",
  "تلوانا": "تلنا",
  "تلوار": "تلوار",
  "تلوارو": "تلوار",
  "تلواروں": "تلوار",
  "تلواریں": "تلوار",
  "تلواتے": "تلنا",
  "تلواتا": "تلنا",
  "تلواتی": "تلنا",
  "تلواتیں": "تلنا",
  "تلواؤ": "تلنا",
  "تلواؤں": "تلنا",
  "تلوائے": "تلنا",
  "تلوائی": "تلنا",
  "تلوائیے": "تلنا",
  "تلوائیں": "تلنا",
  "تلوایا": "تلنا",
  "تلوو": "تلوا",
  "تلووں": "تلوا",
  "تلی": "تلنا",
  "تلیے": "تلنا",
  "تلیں": "تلنا",
  "تم": "میں",
  "تمغے": "تمغہ",
  "تمغہ": "تمغہ",
  "تمغو": "تمغہ",
  "تمغوں": "تمغہ",
  "تماے": "تمام",
  "تماشے": "تماشا",
  "تماشا": "تماشا",
  "تماشائی": "تماشائی",
  "تماشائیاں": "تماشائی",
  "تماشائیو": "تماشائی",
  "تماشائیوں": "تماشائی",
  "تماشہ": "تماشہ",
  "تماشو": "تماشا",
  "تماشوں": "تماشا",
  "تمام": "تمام",
  "تمای": "تمام",
  "تمنّا": "تمنّا",
  "تمنّاؤ": "تمنّا",
  "تمنّاؤں": "تمنّا",
  "تمنّائیں": "تمنّا",
  "تمنا": "تمنا",
  "تمناؤ": "تمنا",
  "تمناؤں": "تمنا",
  "تمنائیں": "تمنا",
  "تمھارے": "میرا",
  "تمھارا": "میرا",
  "تمھاری": "میرا",
  "تن": "تن",
  "تنے": "تنا",
  "تنخواہ": "تنخواہ",
  "تنخواہو": "تنخواہ",
  "تنخواہوں": "تنخواہ",
  "تنخواہیں": "تنخواہ",
  "تنں": "تننا",
  "تنا": "تنا",
  "تناؤ": "تناؤ",
  "تنازع": "تنازع",
  "تنازعے": "تنازع",
  "تنازعہ": "تنازعہ",
  "تنازعو": "تنازع",
  "تنازعوں": "تنازع",
  "تنبی": "تنبی",
  "تنبیاں": "تنبی",
  "تنبیو": "تنبی",
  "تنبیوں": "تنبی",
  "تنگی": "تنگی",
  "تنگیاں": "تنگی",
  "تنگیو": "تنگی",
  "تنگیوں": "تنگی",
  "تنہائی": "تنہائی",
  "تنہائیاں": "تنہائی",
  "تنہائیو": "تنہائی",
  "تنہائیوں": "تنہائی",
  "تنکے": "تنکا",
  "تنکا": "تنکا",
  "تنکہ": "تنکہ",
  "تنکو": "تنکا",
  "تنکوں": "تنکا",
  "تننے": "تننا",
  "تننا": "تننا",
  "تننی": "تننا",
  "تنتے": "تننا",
  "تنتا": "تننا",
  "تنتی": "تننا",
  "تنتیں": "تننا",
  "تنو": "تنا",
  "تنوں": "تنا",
  "تنوا": "تننا",
  "تنوانے": "تننا",
  "تنوانا": "تننا",
  "تنواتے": "تننا",
  "تنواتا": "تننا",
  "تنواتی": "تننا",
  "تنواتیں": "تننا",
  "تنواؤ": "تننا",
  "تنواؤں": "تننا",
  "تنوائے": "تننا",
  "تنوائی": "تننا",
  "تنوائیے": "تننا",
  "تنوائیں": "تننا",
  "تنوایا": "تننا",
  "تنور": "تنور",
  "تنورو": "تنور",
  "تنوروں": "تنور",
  "تنی": "تننا",
  "تنیے": "تننا",
  "تنیں": "تننا",
  "تنظیم": "تنظیم",
  "تنظیمو": "تنظیم",
  "تنظیموں": "تنظیم",
  "تنظیمیں": "تنظیم",
  "تپ": "تپنا",
  "تپے": "تپنا",
  "تپں": "تپنا",
  "تپا": "تپنا",
  "تپنے": "تپنا",
  "تپنا": "تپنا",
  "تپنی": "تپنا",
  "تپتے": "تپنا",
  "تپتا": "تپنا",
  "تپتی": "تپنا",
  "تپتیں": "تپنا",
  "تپو": "تپنا",
  "تپوں": "تپنا",
  "تپوا": "تپنا",
  "تپوانے": "تپنا",
  "تپوانا": "تپنا",
  "تپواتے": "تپنا",
  "تپواتا": "تپنا",
  "تپواتی": "تپنا",
  "تپواتیں": "تپنا",
  "تپواؤ": "تپنا",
  "تپواؤں": "تپنا",
  "تپوائے": "تپنا",
  "تپوائی": "تپنا",
  "تپوائیے": "تپنا",
  "تپوائیں": "تپنا",
  "تپوایا": "تپنا",
  "تپی": "تپنا",
  "تپیے": "تپنا",
  "تپیں": "تپنا",
  "تقاضے": "تقاضا",
  "تقاضا": "تقاضا",
  "تقاضہ": "تقاضہ",
  "تقاضو": "تقاضا",
  "تقاضوں": "تقاضا",
  "تقدیر": "تقدیر",
  "تقدیرو": "تقدیر",
  "تقدیروں": "تقدیر",
  "تقدیریں": "تقدیر",
  "تقرب": "تقرب",
  "تقربو": "تقرب",
  "تقربوں": "تقرب",
  "تقریب": "تقریب",
  "تقریبو": "تقریب",
  "تقریبوں": "تقریب",
  "تقریبیں": "تقریب",
  "تقریر": "تقریر",
  "تقریرو": "تقریر",
  "تقریروں": "تقریر",
  "تقریریں": "تقریر",
  "تر": "تر",
  "ترے": "ترنا",
  "ترں": "ترنا",
  "ترا": "ترنا",
  "تراش": "تراشنا",
  "تراشے": "تراشا",
  "تراشں": "تراشنا",
  "تراشا": "تراشا",
  "تراشنے": "تراشنا",
  "تراشنا": "تراشنا",
  "تراشنی": "تراشنا",
  "تراشتے": "تراشنا",
  "تراشتا": "تراشنا",
  "تراشتی": "تراشنا",
  "تراشتیں": "تراشنا",
  "تراشو": "تراشا",
  "تراشوں": "تراشا",
  "تراشی": "تراشی",
  "تراشیے": "تراشنا",
  "تراشیں": "تراشنا",
  "تراشیاں": "تراشی",
  "تراشیو": "تراشی",
  "تراشیوں": "تراشی",
  "تراکیب": "تراکیب",
  "تراکیبو": "تراکیب",
  "تراکیبوں": "تراکیب",
  "تراکیبیں": "تراکیب",
  "ترانے": "ترانا",
  "ترانا": "ترانا",
  "ترانہ": "ترانہ",
  "ترانو": "ترانا",
  "ترانوں": "ترانا",
  "ترجمے": "ترجمہ",
  "ترجمان": "ترجمان",
  "ترجمانو": "ترجمان",
  "ترجمانوں": "ترجمان",
  "ترجمہ": "ترجمہ",
  "ترجمو": "ترجمہ",
  "ترجموں": "ترجمہ",
  "ترک": "ترک",
  "ترکے": "ترکہ",
  "ترکاری": "ترکاری",
  "ترکاریاں": "ترکاری",
  "ترکاریو": "ترکاری",
  "ترکاریوں": "ترکاری",
  "ترکہ": "ترکہ",
  "ترکو": "ترکہ",
  "ترکوں": "ترکہ",
  "ترکیب": "ترکیب",
  "ترکیبو": "ترکیب",
  "ترکیبوں": "ترکیب",
  "ترکیبیں": "ترکیب",
  "ترکھان": "ترکھان",
  "ترکھانو": "ترکھان",
  "ترکھانوں": "ترکھان",
  "ترنے": "ترنا",
  "ترنا": "ترنا",
  "ترنی": "ترنا",
  "ترقی": "ترقی",
  "ترقیاں": "ترقی",
  "ترقیو": "ترقی",
  "ترقیوں": "ترقی",
  "ترس": "ترسنا",
  "ترسے": "ترسنا",
  "ترسں": "ترسنا",
  "ترسا": "ترسنا",
  "ترسانے": "ترسنا",
  "ترسانا": "ترسنا",
  "ترساتے": "ترسنا",
  "ترساتا": "ترسنا",
  "ترساتی": "ترسنا",
  "ترساتیں": "ترسنا",
  "ترساؤ": "ترسنا",
  "ترساؤں": "ترسنا",
  "ترسائے": "ترسنا",
  "ترسائی": "ترسنا",
  "ترسائیے": "ترسنا",
  "ترسائیں": "ترسنا",
  "ترسایا": "ترسنا",
  "ترسنے": "ترسنا",
  "ترسنا": "ترسنا",
  "ترسنی": "ترسنا",
  "ترستے": "ترسنا",
  "ترستا": "ترسنا",
  "ترستی": "ترسنا",
  "ترستیں": "ترسنا",
  "ترسو": "ترسنا",
  "ترسوں": "ترسنا",
  "ترسوا": "ترسنا",
  "ترسوانے": "ترسنا",
  "ترسوانا": "ترسنا",
  "ترسواتے": "ترسنا",
  "ترسواتا": "ترسنا",
  "ترسواتی": "ترسنا",
  "ترسواتیں": "ترسنا",
  "ترسواؤ": "ترسنا",
  "ترسواؤں": "ترسنا",
  "ترسوائے": "ترسنا",
  "ترسوائی": "ترسنا",
  "ترسوائیے": "ترسنا",
  "ترسوائیں": "ترسنا",
  "ترسوایا": "ترسنا",
  "ترسی": "ترسنا",
  "ترسیے": "ترسنا",
  "ترسیں": "ترسنا",
  "ترتے": "ترنا",
  "ترتا": "ترنا",
  "ترتی": "ترنا",
  "ترتیں": "ترنا",
  "ترو": "تر",
  "تروں": "تر",
  "تروا": "ترنا",
  "تروانے": "ترنا",
  "تروانا": "ترنا",
  "ترواتے": "ترنا",
  "ترواتا": "ترنا",
  "ترواتی": "ترنا",
  "ترواتیں": "ترنا",
  "ترواؤ": "ترنا",
  "ترواؤں": "ترنا",
  "تروائے": "ترنا",
  "تروائی": "ترنا",
  "تروائیے": "ترنا",
  "تروائیں": "ترنا",
  "تروایا": "ترنا",
  "تری": "ترنا",
  "تریے": "ترنا",
  "تریں": "ترنا",
  "تسبیح": "تسبیح",
  "تسبیحو": "تسبیح",
  "تسبیحوں": "تسبیح",
  "تسبیحیں": "تسبیح",
  "تسمے": "تسما",
  "تسما": "تسما",
  "تسمہ": "تسمہ",
  "تسمو": "تسما",
  "تسموں": "تسما",
  "تتلی": "تتلی",
  "تتلیاں": "تتلی",
  "تتلیو": "تتلی",
  "تتلیوں": "تتلی",
  "تتر": "تتر",
  "تترو": "تتر",
  "تتروں": "تتر",
  "تو": "ت",
  "توں": "ت",
  "توڑ": "ٹُوٹْنا",
  "توڑْں": "ٹُوٹْنا",
  "توڑْنے": "ٹُوٹْنا",
  "توڑْنا": "ٹُوٹْنا",
  "توڑْنی": "توڑْنا",
  "توڑْتے": "ٹُوٹْنا",
  "توڑْتا": "ٹُوٹْنا",
  "توڑْتی": "ٹُوٹْنا",
  "توڑْتیں": "ٹُوٹْنا",
  "توڑے": "توڑا",
  "توڑں": "توڑنا",
  "توڑا": "توڑا",
  "توڑنے": "توڑنا",
  "توڑنا": "توڑنا",
  "توڑنی": "توڑنا",
  "توڑتے": "توڑنا",
  "توڑتا": "توڑنا",
  "توڑتی": "توڑنا",
  "توڑتیں": "توڑنا",
  "توڑو": "توڑا",
  "توڑوں": "توڑا",
  "توڑوا": "توڑنا",
  "توڑوانے": "توڑنا",
  "توڑوانا": "توڑنا",
  "توڑواتے": "توڑنا",
  "توڑواتا": "توڑنا",
  "توڑواتی": "توڑنا",
  "توڑواتیں": "توڑنا",
  "توڑواؤ": "توڑنا",
  "توڑواؤں": "توڑنا",
  "توڑوائے": "توڑنا",
  "توڑوائی": "توڑنا",
  "توڑوائیے": "توڑنا",
  "توڑوائیں": "توڑنا",
  "توڑوایا": "توڑنا",
  "توڑی": "ٹُوٹْنا",
  "توڑیے": "ٹُوٹْنا",
  "توڑیں": "ٹُوٹْنا",
  "توٹ": "توٹنا",
  "توٹے": "توٹنا",
  "توٹں": "توٹنا",
  "توٹا": "توٹنا",
  "توٹنے": "توٹنا",
  "توٹنا": "توٹنا",
  "توٹنی": "توٹنا",
  "توٹتے": "توٹنا",
  "توٹتا": "توٹنا",
  "توٹتی": "توٹنا",
  "توٹتیں": "توٹنا",
  "توٹو": "توٹنا",
  "توٹوں": "توٹنا",
  "توٹی": "توٹنا",
  "توٹیے": "توٹنا",
  "توٹیں": "توٹنا",
  "توانائی": "توانائی",
  "توانائیاں": "توانائی",
  "توانائیو": "توانائی",
  "توانائیوں": "توانائی",
  "توبے": "توبہ",
  "توبہ": "توبہ",
  "توبو": "توبہ",
  "توبوں": "توبہ",
  "تودے": "تودہ",
  "تودہ": "تودہ",
  "تودو": "تودہ",
  "تودوں": "تودہ",
  "توجے": "توجہ",
  "توجہ": "توجہ",
  "توجو": "توجہ",
  "توجوں": "توجہ",
  "تول": "تولنا",
  "تولے": "تولا",
  "تولں": "تولنا",
  "تولا": "تولا",
  "تولانے": "تولنا",
  "تولانا": "تولنا",
  "تولاتے": "تولنا",
  "تولاتا": "تولنا",
  "تولاتی": "تولنا",
  "تولاتیں": "تولنا",
  "تولاؤ": "تولنا",
  "تولاؤں": "تولنا",
  "تولائے": "تولنا",
  "تولائی": "تولنا",
  "تولائیے": "تولنا",
  "تولائیں": "تولنا",
  "تولایا": "تولنا",
  "تولہ": "تولہ",
  "تولنے": "تولنا",
  "تولنا": "تولنا",
  "تولنی": "تولنا",
  "تولتے": "تولنا",
  "تولتا": "تولنا",
  "تولتی": "تولنا",
  "تولتیں": "تولنا",
  "تولو": "تولا",
  "تولوں": "تولا",
  "تولوا": "تولنا",
  "تولوانے": "تولنا",
  "تولوانا": "تولنا",
  "تولواتے": "تولنا",
  "تولواتا": "تولنا",
  "تولواتی": "تولنا",
  "تولواتیں": "تولنا",
  "تولواؤ": "تولنا",
  "تولواؤں": "تولنا",
  "تولوائے": "تولنا",
  "تولوائی": "تولنا",
  "تولوائیے": "تولنا",
  "تولوائیں": "تولنا",
  "تولوایا": "تولنا",
  "تولی": "تولنا",
  "تولیے": "تولیہ",
  "تولیں": "تولنا",
  "تولیہ": "تولیہ",
  "تولیو": "تولیہ",
  "تولیوں": "تولیہ",
  "توپ": "توپ",
  "توپو": "توپ",
  "توپوں": "توپ",
  "توپیں": "توپ",
  "توت": "توت",
  "توتے": "توتا",
  "توتا": "توتا",
  "توتو": "توتا",
  "توتوں": "توتا",
  "تیغ": "تیغ",
  "تیغو": "تیغ",
  "تیغوں": "تیغ",
  "تیغیں": "تیغ",
  "تیں": "ت",
  "تیشے": "تیشہ",
  "تیشہ": "تیشہ",
  "تیشو": "تیشہ",
  "تیشوں": "تیشہ",
  "تیاری": "تیاری",
  "تیاریاں": "تیاری",
  "تیاریو": "تیاری",
  "تیاریوں": "تیاری",
  "تیلی": "تیلی",
  "تیلیا": "تیلیا",
  "تیلیاں": "تیلی",
  "تیلیو": "تیلی",
  "تیلیوں": "تیلی",
  "تیماردار": "تیماردار",
  "تیماردارو": "تیماردار",
  "تیمارداروں": "تیماردار",
  "تین": "تین",
  "تینو": "تین",
  "تینوں": "تین",
  "تیر": "تیر",
  "تیرے": "تیرا",
  "تیرں": "تیرنا",
  "تیرا": "تیرا",
  "تیراک": "تیراک",
  "تیراکو": "تیراک",
  "تیراکوں": "تیراک",
  "تیرانے": "تیرنا",
  "تیرانا": "تیرنا",
  "تیراتے": "تیرنا",
  "تیراتا": "تیرنا",
  "تیراتی": "تیرنا",
  "تیراتیں": "تیرنا",
  "تیراؤ": "تیرنا",
  "تیراؤں": "تیرنا",
  "تیرائے": "تیرنا",
  "تیرائی": "تیرنا",
  "تیرائیے": "تیرنا",
  "تیرائیں": "تیرنا",
  "تیرایا": "تیرنا",
  "تیرہ": "تیرہ",
  "تیرنے": "تیرنا",
  "تیرنا": "تیرنا",
  "تیرنی": "تیرنا",
  "تیرتے": "تیرنا",
  "تیرتا": "تیرنا",
  "تیرتی": "تیرنا",
  "تیرتیں": "تیرنا",
  "تیرو": "تیرا",
  "تیروں": "تیرا",
  "تیروا": "تیرنا",
  "تیروانے": "تیرنا",
  "تیروانا": "تیرنا",
  "تیرواتے": "تیرنا",
  "تیرواتا": "تیرنا",
  "تیرواتی": "تیرنا",
  "تیرواتیں": "تیرنا",
  "تیرواؤ": "تیرنا",
  "تیرواؤں": "تیرنا",
  "تیروائے": "تیرنا",
  "تیروائی": "تیرنا",
  "تیروائیے": "تیرنا",
  "تیروائیں": "تیرنا",
  "تیروایا": "تیرنا",
  "تیری": "تیرنا",
  "تیریے": "تیرنا",
  "تیریں": "تیرنا",
  "تیس": "تیس",
  "تیتر": "تیتر",
  "تیترو": "تیتر",
  "تیتروں": "تیتر",
  "تیئس": "تیئس",
  "تیز": "تیز",
  "تیزو": "تیز",
  "تیزوں": "تیز",
  "تیزی": "تیزی",
  "تیزیاں": "تیزی",
  "تیزیو": "تیزی",
  "تیزیوں": "تیزی",
  "تھے": "تھا",
  "تھا": "تھا",
  "تھالی": "تھالی",
  "تھالیاں": "تھالی",
  "تھالیو": "تھالی",
  "تھالیوں": "تھالی",
  "تھام": "تھامنا",
  "تھامے": "تھامنا",
  "تھامں": "تھامنا",
  "تھاما": "تھامنا",
  "تھامنے": "تھامنا",
  "تھامنا": "تھامنا",
  "تھامنی": "تھامنا",
  "تھامتے": "تھامنا",
  "تھامتا": "تھامنا",
  "تھامتی": "تھامنا",
  "تھامتیں": "تھامنا",
  "تھامو": "تھامنا",
  "تھاموں": "تھامنا",
  "تھاموا": "تھامنا",
  "تھاموانے": "تھامنا",
  "تھاموانا": "تھامنا",
  "تھامواتے": "تھامنا",
  "تھامواتا": "تھامنا",
  "تھامواتی": "تھامنا",
  "تھامواتیں": "تھامنا",
  "تھامواؤ": "تھامنا",
  "تھامواؤں": "تھامنا",
  "تھاموائے": "تھامنا",
  "تھاموائی": "تھامنا",
  "تھاموائیے": "تھامنا",
  "تھاموائیں": "تھامنا",
  "تھاموایا": "تھامنا",
  "تھامی": "تھامنا",
  "تھامیے": "تھامنا",
  "تھامیں": "تھامنا",
  "تھان": "تھان",
  "تھانے": "تھانہ",
  "تھانہ": "تھانہ",
  "تھانو": "تھانہ",
  "تھانوں": "تھانہ",
  "تھہر": "تھہرنا",
  "تھہرے": "تھہرنا",
  "تھہرں": "تھہرنا",
  "تھہرا": "تھہرنا",
  "تھہرانے": "تھہرنا",
  "تھہرانا": "تھہرنا",
  "تھہراتے": "تھہرنا",
  "تھہراتا": "تھہرنا",
  "تھہراتی": "تھہرنا",
  "تھہراتیں": "تھہرنا",
  "تھہراؤ": "تھہرنا",
  "تھہراؤں": "تھہرنا",
  "تھہرائے": "تھہرنا",
  "تھہرائی": "تھہرنا",
  "تھہرائیے": "تھہرنا",
  "تھہرائیں": "تھہرنا",
  "تھہرایا": "تھہرنا",
  "تھہرنے": "تھہرنا",
  "تھہرنا": "تھہرنا",
  "تھہرنی": "تھہرنا",
  "تھہرتے": "تھہرنا",
  "تھہرتا": "تھہرنا",
  "تھہرتی": "تھہرنا",
  "تھہرتیں": "تھہرنا",
  "تھہرو": "تھہرنا",
  "تھہروں": "تھہرنا",
  "تھہروا": "تھہرنا",
  "تھہروانے": "تھہرنا",
  "تھہروانا": "تھہرنا",
  "تھہرواتے": "تھہرنا",
  "تھہرواتا": "تھہرنا",
  "تھہرواتی": "تھہرنا",
  "تھہرواتیں": "تھہرنا",
  "تھہرواؤ": "تھہرنا",
  "تھہرواؤں": "تھہرنا",
  "تھہروائے": "تھہرنا",
  "تھہروائی": "تھہرنا",
  "تھہروائیے": "تھہرنا",
  "تھہروائیں": "تھہرنا",
  "تھہروایا": "تھہرنا",
  "تھہری": "تھہرنا",
  "تھہریے": "تھہرنا",
  "تھہریں": "تھہرنا",
  "تھک": "تھکنا",
  "تھکے": "تھکنا",
  "تھکں": "تھکنا",
  "تھکا": "تھکنا",
  "تھکانے": "تھکنا",
  "تھکانا": "تھکنا",
  "تھکاتے": "تھکنا",
  "تھکاتا": "تھکنا",
  "تھکاتی": "تھکنا",
  "تھکاتیں": "تھکنا",
  "تھکاؤ": "تھکنا",
  "تھکاؤں": "تھکنا",
  "تھکائے": "تھکنا",
  "تھکائی": "تھکنا",
  "تھکائیے": "تھکنا",
  "تھکائیں": "تھکنا",
  "تھکایا": "تھکنا",
  "تھکنے": "تھکنا",
  "تھکنا": "تھکنا",
  "تھکنی": "تھکنا",
  "تھکتے": "تھکنا",
  "تھکتا": "تھکنا",
  "تھکتی": "تھکنا",
  "تھکتیں": "تھکنا",
  "تھکو": "تھکنا",
  "تھکوں": "تھکنا",
  "تھکوا": "تھکنا",
  "تھکوانے": "تھکنا",
  "تھکوانا": "تھکنا",
  "تھکواتے": "تھکنا",
  "تھکواتا": "تھکنا",
  "تھکواتی": "تھکنا",
  "تھکواتیں": "تھکنا",
  "تھکواؤ": "تھکنا",
  "تھکواؤں": "تھکنا",
  "تھکوائے": "تھکنا",
  "تھکوائی": "تھکنا",
  "تھکوائیے": "تھکنا",
  "تھکوائیں": "تھکنا",
  "تھکوایا": "تھکنا",
  "تھکی": "تھکنا",
  "تھکیے": "تھکنا",
  "تھکیں": "تھکنا",
  "تھلے": "تھلا",
  "تھلا": "تھلا",
  "تھلو": "تھلا",
  "تھلوں": "تھلا",
  "تھم": "تھمنا",
  "تھمے": "تھمنا",
  "تھمں": "تھمنا",
  "تھما": "تھامنا",
  "تھمانے": "تھامنا",
  "تھمانا": "تھامنا",
  "تھماتے": "تھامنا",
  "تھماتا": "تھامنا",
  "تھماتی": "تھامنا",
  "تھماتیں": "تھامنا",
  "تھماؤ": "تھامنا",
  "تھماؤں": "تھامنا",
  "تھمائے": "تھامنا",
  "تھمائی": "تھامنا",
  "تھمائیے": "تھامنا",
  "تھمائیں": "تھامنا",
  "تھمایا": "تھامنا",
  "تھمنے": "تھمنا",
  "تھمنا": "تھمنا",
  "تھمنی": "تھمنا",
  "تھمتے": "تھمنا",
  "تھمتا": "تھمنا",
  "تھمتی": "تھمنا",
  "تھمتیں": "تھمنا",
  "تھمو": "تھمنا",
  "تھموں": "تھمنا",
  "تھموا": "تھامنا",
  "تھموانے": "تھامنا",
  "تھموانا": "تھامنا",
  "تھمواتے": "تھامنا",
  "تھمواتا": "تھامنا",
  "تھمواتی": "تھامنا",
  "تھمواتیں": "تھامنا",
  "تھمواؤ": "تھامنا",
  "تھمواؤں": "تھامنا",
  "تھموائے": "تھامنا",
  "تھموائی": "تھامنا",
  "تھموائیے": "تھامنا",
  "تھموائیں": "تھامنا",
  "تھموایا": "تھامنا",
  "تھمی": "تھمنا",
  "تھمیے": "تھمنا",
  "تھمیں": "تھمنا",
  "تھن": "تھن",
  "تھنو": "تھن",
  "تھنوں": "تھن",
  "تھپڑ": "تھپڑ",
  "تھپڑو": "تھپڑ",
  "تھپڑوں": "تھپڑ",
  "تھرا": "تھرانا",
  "تھرانے": "تھرانا",
  "تھرانا": "تھرانا",
  "تھرانی": "تھرانا",
  "تھراتے": "تھرانا",
  "تھراتا": "تھرانا",
  "تھراتی": "تھرانا",
  "تھراتیں": "تھرانا",
  "تھراؤ": "تھرانا",
  "تھراؤں": "تھرانا",
  "تھرائے": "تھرانا",
  "تھرائی": "تھرانا",
  "تھرائیے": "تھرانا",
  "تھرائیں": "تھرانا",
  "تھرایا": "تھرانا",
  "تھرک": "تھرکنا",
  "تھرکے": "تھرکنا",
  "تھرکں": "تھرکنا",
  "تھرکا": "تھرکنا",
  "تھرکانے": "تھرکنا",
  "تھرکانا": "تھرکنا",
  "تھرکاتے": "تھرکنا",
  "تھرکاتا": "تھرکنا",
  "تھرکاتی": "تھرکنا",
  "تھرکاتیں": "تھرکنا",
  "تھرکاؤ": "تھرکنا",
  "تھرکاؤں": "تھرکنا",
  "تھرکائے": "تھرکنا",
  "تھرکائی": "تھرکنا",
  "تھرکائیے": "تھرکنا",
  "تھرکائیں": "تھرکنا",
  "تھرکایا": "تھرکنا",
  "تھرکنے": "تھرکنا",
  "تھرکنا": "تھرکنا",
  "تھرکنی": "تھرکنا",
  "تھرکتے": "تھرکنا",
  "تھرکتا": "تھرکنا",
  "تھرکتی": "تھرکنا",
  "تھرکتیں": "تھرکنا",
  "تھرکو": "تھرکنا",
  "تھرکوں": "تھرکنا",
  "تھرکوا": "تھرکنا",
  "تھرکوانے": "تھرکنا",
  "تھرکوانا": "تھرکنا",
  "تھرکواتے": "تھرکنا",
  "تھرکواتا": "تھرکنا",
  "تھرکواتی": "تھرکنا",
  "تھرکواتیں": "تھرکنا",
  "تھرکواؤ": "تھرکنا",
  "تھرکواؤں": "تھرکنا",
  "تھرکوائے": "تھرکنا",
  "تھرکوائی": "تھرکنا",
  "تھرکوائیے": "تھرکنا",
  "تھرکوائیں": "تھرکنا",
  "تھرکوایا": "تھرکنا",
  "تھرکی": "تھرکنا",
  "تھرکیے": "تھرکنا",
  "تھرکیں": "تھرکنا",
  "تھرتھرا": "تھرتھرانا",
  "تھرتھرانے": "تھرتھرانا",
  "تھرتھرانا": "تھرتھرانا",
  "تھرتھرانی": "تھرتھرانا",
  "تھرتھراتے": "تھرتھرانا",
  "تھرتھراتا": "تھرتھرانا",
  "تھرتھراتی": "تھرتھرانا",
  "تھرتھراتیں": "تھرتھرانا",
  "تھرتھراؤ": "تھرتھرانا",
  "تھرتھراؤں": "تھرتھرانا",
  "تھرتھرائے": "تھرتھرانا",
  "تھرتھرائی": "تھرتھرانا",
  "تھرتھرائیے": "تھرتھرانا",
  "تھرتھرائیں": "تھرتھرانا",
  "تھرتھرایا": "تھرتھرانا",
  "تھو": "تھا",
  "تھوں": "تھا",
  "تھوک": "تھوکنا",
  "تھوکے": "تھوکنا",
  "تھوکں": "تھوکنا",
  "تھوکا": "تھوکنا",
  "تھوکانے": "تھوکنا",
  "تھوکانا": "تھوکنا",
  "تھوکاتے": "تھوکنا",
  "تھوکاتا": "تھوکنا",
  "تھوکاتی": "تھوکنا",
  "تھوکاتیں": "تھوکنا",
  "تھوکاؤ": "تھوکنا",
  "تھوکاؤں": "تھوکنا",
  "تھوکائے": "تھوکنا",
  "تھوکائی": "تھوکنا",
  "تھوکائیے": "تھوکنا",
  "تھوکائیں": "تھوکنا",
  "تھوکایا": "تھوکنا",
  "تھوکنے": "تھوکنا",
  "تھوکنا": "تھوکنا",
  "تھوکنی": "تھوکنا",
  "تھوکتے": "تھوکنا",
  "تھوکتا": "تھوکنا",
  "تھوکتی": "تھوکنا",
  "تھوکتیں": "تھوکنا",
  "تھوکو": "تھوکنا",
  "تھوکوں": "تھوکنا",
  "تھوکوا": "تھوکنا",
  "تھوکوانے": "تھوکنا",
  "تھوکوانا": "تھوکنا",
  "تھوکواتے": "تھوکنا",
  "تھوکواتا": "تھوکنا",
  "تھوکواتی": "تھوکنا",
  "تھوکواتیں": "تھوکنا",
  "تھوکواؤ": "تھوکنا",
  "تھوکواؤں": "تھوکنا",
  "تھوکوائے": "تھوکنا",
  "تھوکوائی": "تھوکنا",
  "تھوکوائیے": "تھوکنا",
  "تھوکوائیں": "تھوکنا",
  "تھوکوایا": "تھوکنا",
  "تھوکی": "تھوکنا",
  "تھوکیے": "تھوکنا",
  "تھوکیں": "تھوکنا",
  "تھی": "ہونا",
  "تھیں": "ہونا",
  "تھیٹر": "تھیٹر",
  "تھیٹرو": "تھیٹر",
  "تھیٹروں": "تھیٹر",
  "تھیلی": "تھیلی",
  "تھیلیاں": "تھیلی",
  "تھیلیو": "تھیلی",
  "تھیلیوں": "تھیلی",
  "وَہاں": "وَہاں",
  "وَیسے": "وَیسا",
  "وَیسا": "وَیسا",
  "وَیسی": "وَیسا",
  "وُہ": "میں",
  "وحشت": "وحشت",
  "وحشتو": "وحشت",
  "وحشتوں": "وحشت",
  "وحشتیں": "وحشت",
  "وحشی": "وحشی",
  "وحشیو": "وحشی",
  "وحشیوں": "وحشی",
  "وحدت": "وحدت",
  "وحدتو": "وحدت",
  "وحدتوں": "وحدت",
  "وحدتیں": "وحدت",
  "وخت": "وخت",
  "وختو": "وخت",
  "وختوں": "وخت",
  "وختیں": "وخت",
  "واڑے": "واڑہ",
  "واڑہ": "واڑہ",
  "واڑو": "واڑہ",
  "واڑوں": "واڑہ",
  "وادی": "وادی",
  "وادیاں": "وادی",
  "وادیو": "وادی",
  "وادیوں": "وادی",
  "واہ": "واہ",
  "والے": "والا",
  "والا": "والا",
  "والد": "والد",
  "والدے": "والدہ",
  "والدہ": "والدہ",
  "والدو": "والدہ",
  "والدوں": "والدہ",
  "والہ": "والہ",
  "والو": "والا",
  "والوں": "والا",
  "والی": "والی",
  "والیو": "والی",
  "والیوں": "والی",
  "واقع": "واقع",
  "واقعے": "واقع",
  "واقعہ": "واقعہ",
  "واقعو": "واقع",
  "واقعوں": "واقع",
  "وارث": "وارث",
  "وارثو": "وارث",
  "وارثوں": "وارث",
  "واردات": "واردات",
  "وارداتو": "واردات",
  "وارداتوں": "واردات",
  "وارداتیں": "واردات",
  "واسوخت": "واسوخت",
  "واسوختو": "واسوخت",
  "واسوختوں": "واسوخت",
  "واسوختیں": "واسوخت",
  "واسطے": "واسطہ",
  "واسطہ": "واسطہ",
  "واسطو": "واسطہ",
  "واسطوں": "واسطہ",
  "وبا": "وبا",
  "وباؤ": "وبا",
  "وباؤں": "وبا",
  "وبائیں": "وبا",
  "وعدے": "وعدہ",
  "وعدہ": "وعدہ",
  "وعدو": "وعدہ",
  "وعدوں": "وعدہ",
  "وعید": "وعید",
  "وعیدو": "وعید",
  "وعیدوں": "وعید",
  "وعیدیں": "وعید",
  "وعظ": "وعظ",
  "وعظو": "وعظ",
  "وعظوں": "وعظ",
  "وعظیں": "وعظ",
  "وفاداری": "وفاداری",
  "وفاداریاں": "وفاداری",
  "وفاداریو": "وفاداری",
  "وفاداریوں": "وفاداری",
  "وہ": "میں",
  "وہاں": "وَہاں",
  "وجے": "وجہ",
  "وجہ": "وجہ",
  "وجہے": "وجہہ",
  "وجہہ": "وجہہ",
  "وجہو": "وجہہ",
  "وجہوں": "وجہہ",
  "وجہیں": "وجہ",
  "وجو": "وجہ",
  "وجوں": "وجہ",
  "وکٹ": "وکٹ",
  "وکٹو": "وکٹ",
  "وکٹوں": "وکٹ",
  "وکٹوریا": "وکٹوریا",
  "وکٹوریاؤ": "وکٹوریا",
  "وکٹوریاؤں": "وکٹوریا",
  "وکٹوریائیں": "وکٹوریا",
  "وکٹیں": "وکٹ",
  "ولائیت": "ولائیت",
  "ولائیتو": "ولائیت",
  "ولائیتوں": "ولائیت",
  "ولائیتیں": "ولائیت",
  "ولایت": "ولایت",
  "ولایتو": "ولایت",
  "ولایتوں": "ولایت",
  "ولایتیں": "ولایت",
  "ولولے": "ولولہ",
  "ولولہ": "ولولہ",
  "ولولو": "ولولہ",
  "ولولوں": "ولولہ",
  "ولی": "ولی",
  "ولیمے": "ولیمہ",
  "ولیمہ": "ولیمہ",
  "ولیمو": "ولیمہ",
  "ولیموں": "ولیمہ",
  "ولیو": "ولی",
  "ولیوں": "ولی",
  "وقف": "وقف",
  "وقفے": "وقفہ",
  "وقفہ": "وقفہ",
  "وقفو": "وقفہ",
  "وقفوں": "وقفہ",
  "وقت": "وقت",
  "وقتے": "وقتہ",
  "وقتہ": "وقتہ",
  "وقتو": "وقتہ",
  "وقتوں": "وقتہ",
  "وقتیں": "وقت",
  "ورثے": "ورثا",
  "ورثا": "ورثا",
  "ورثہ": "ورثہ",
  "ورثو": "ورثا",
  "ورثوں": "ورثا",
  "ورانے": "ورانہ",
  "ورانہ": "ورانہ",
  "ورانو": "ورانہ",
  "ورانوں": "ورانہ",
  "وردی": "وردی",
  "وردیاں": "وردی",
  "وردیو": "وردی",
  "وردیوں": "وردی",
  "ورک": "ورک",
  "ورکو": "ورک",
  "ورکوں": "ورک",
  "ورزی": "ورزی",
  "ورزیاں": "ورزی",
  "ورزیو": "ورزی",
  "ورزیوں": "ورزی",
  "وسعت": "وسعت",
  "وسعتو": "وسعت",
  "وسعتوں": "وسعت",
  "وسعتیں": "وسعت",
  "وست": "وست",
  "وستو": "وست",
  "وستوں": "وست",
  "وستیں": "وست",
  "وسوسے": "وسوسہ",
  "وسوسہ": "وسوسہ",
  "وسوسو": "وسوسہ",
  "وسوسوں": "وسوسہ",
  "وسیلے": "وسیلہ",
  "وسیلہ": "وسیلہ",
  "وسیلو": "وسیلہ",
  "وسیلوں": "وسیلہ",
  "وتر": "وتر",
  "وترے": "وترہ",
  "وترہ": "وترہ",
  "وترو": "وترہ",
  "وتروں": "وترہ",
  "وتریں": "وتر",
  "ویران": "ویران",
  "ویرانے": "ویرانہ",
  "ویرانہ": "ویرانہ",
  "ویرانو": "ویرانہ",
  "ویرانوں": "ویرانہ",
  "ویرانیں": "ویران",
  "ویسے": "وَیسا",
  "ویسا": "وَیسا",
  "ویسی": "وَیسا",
  "ویزے": "ویزہ",
  "ویزہ": "ویزہ",
  "ویزو": "ویزہ",
  "ویزوں": "ویزہ",
  "وزیر": "وزیر",
  "وزیرو": "وزیر",
  "وزیروں": "وزیر",
  "وضاحت": "وضاحت",
  "وضاحتو": "وضاحت",
  "وضاحتوں": "وضاحت",
  "وضاحتیں": "وضاحت",
  "وضعداری": "وضعداری",
  "وضعداریاں": "وضعداری",
  "وضعداریو": "وضعداری",
  "وضعداریوں": "وضعداری",
  "وضو": "وضو",
  "وضوؤ": "وضو",
  "وضوؤں": "وضو",
  "وطن": "وطن",
  "وطنو": "وطن",
  "وطنوں": "وطن",
  "وطیرے": "وطیرہ",
  "وطیرہ": "وطیرہ",
  "وطیرو": "وطیرہ",
  "وطیروں": "وطیرہ",
  "وظیفے": "وظیفہ",
  "وظیفہ": "وظیفہ",
  "وظیفو": "وظیفہ",
  "وظیفوں": "وظیفہ",
  "یَہاں": "یَہاں",
  "یِہ": "میں",
  "یا": "یا",
  "یاد": "یاد",
  "یاداشت": "یاداشت",
  "یاداشتو": "یاداشت",
  "یاداشتوں": "یاداشت",
  "یاداشتیں": "یاداشت",
  "یاددہانی": "یاددہانی",
  "یاددہانیاں": "یاددہانی",
  "یاددہانیو": "یاددہانی",
  "یاددہانیوں": "یاددہانی",
  "یادگار": "یادگار",
  "یادگارو": "یادگار",
  "یادگاروں": "یادگار",
  "یادگاریں": "یادگار",
  "یادو": "یاد",
  "یادوں": "یاد",
  "یادیں": "یاد",
  "یار": "یار",
  "یارو": "یار",
  "یاروں": "یار",
  "یاتری": "یاتری",
  "یاتریو": "یاتری",
  "یاتریوں": "یاتری",
  "یہ": "میں",
  "یہاں": "یَہاں",
  "یہودی": "یہودی",
  "یہودیو": "یہودی",
  "یہودیوں": "یہودی",
  "یک": "یک",
  "یکے": "یکہ",
  "یکہ": "یکہ",
  "یکو": "یکہ",
  "یکوں": "یکہ",
  "یت": "یت",
  "یتو": "یت",
  "یتوں": "یت",
  "یتیں": "یت",
  "یتیم": "یتیم",
  "یتیمو": "یتیم",
  "یتیموں": "یتیم",
  "یونانی": "یونانی",
  "یونانیو": "یونانی",
  "یونانیوں": "یونانی",
  "یونیورسٹی": "یونیورسٹی",
  "یونیورسٹیاں": "یونیورسٹی",
  "یونیورسٹیو": "یونیورسٹی",
  "یونیورسٹیوں": "یونیورسٹی",
  "زِنْدَہ": "زِنْدَہ",
  "زخم": "زخم",
  "زخمو": "زخم",
  "زخموں": "زخم",
  "زخمی": "زخمی",
  "زخمیو": "زخمی",
  "زخمیوں": "زخمی",
  "زاد": "زاد",
  "زادے": "زادہ",
  "زادہ": "زادہ",
  "زادت": "زادت",
  "زادتو": "زادت",
  "زادتوں": "زادت",
  "زادتیں": "زادت",
  "زادو": "زادہ",
  "زادوں": "زادہ",
  "زادی": "زادی",
  "زادیاں": "زادی",
  "زادیو": "زادی",
  "زادیوں": "زادی",
  "زاہد": "زاہد",
  "زاہدے": "زاہدہ",
  "زاہدہ": "زاہدہ",
  "زاہدو": "زاہدہ",
  "زاہدوں": "زاہدہ",
  "زار": "زار",
  "زارو": "زار",
  "زاروں": "زار",
  "زاری": "زاری",
  "زاریاں": "زاری",
  "زاریو": "زاری",
  "زاریوں": "زاری",
  "زاویے": "زاویہ",
  "زاویہ": "زاویہ",
  "زاویو": "زاویہ",
  "زاویوں": "زاویہ",
  "زبان": "زبان",
  "زبانو": "زبان",
  "زبانوں": "زبان",
  "زبانیں": "زبان",
  "زچگی": "زچگی",
  "زچگیاں": "زچگی",
  "زچگیو": "زچگی",
  "زچگیوں": "زچگی",
  "زدے": "زدہ",
  "زدہ": "زدہ",
  "زدو": "زدہ",
  "زدوں": "زدہ",
  "زلف": "زلف",
  "زلفو": "زلف",
  "زلفوں": "زلف",
  "زلفیں": "زلف",
  "زلزلے": "زلزلہ",
  "زلزلہ": "زلزلہ",
  "زلزلو": "زلزلہ",
  "زلزلوں": "زلزلہ",
  "زمانے": "زمانہ",
  "زمانہ": "زمانہ",
  "زمانو": "زمانہ",
  "زمانوں": "زمانہ",
  "زمرے": "زمرہ",
  "زمرہ": "زمرہ",
  "زمرو": "زمرہ",
  "زمروں": "زمرہ",
  "زمین": "زمین",
  "زمیندار": "زمیندار",
  "زمیندارو": "زمیندار",
  "زمینداروں": "زمیندار",
  "زمینو": "زمین",
  "زمینوں": "زمین",
  "زمینیں": "زمین",
  "زنے": "زنا",
  "زنا": "زنا",
  "زنانے": "زنانہ",
  "زنانہ": "زنانہ",
  "زنانو": "زنانہ",
  "زنانوں": "زنانہ",
  "زندے": "زندہ",
  "زندگی": "زندگی",
  "زندگیاں": "زندگی",
  "زندگیو": "زندگی",
  "زندگیوں": "زندگی",
  "زندہ": "زندہ",
  "زندو": "زندہ",
  "زندوں": "زندہ",
  "زنجیر": "زنجیر",
  "زنجیرو": "زنجیر",
  "زنجیروں": "زنجیر",
  "زنجیریں": "زنجیر",
  "زنو": "زنا",
  "زنوں": "زنا",
  "زر": "زر",
  "زرے": "زرہ",
  "زراعت": "زراعت",
  "زراعتو": "زراعت",
  "زراعتوں": "زراعت",
  "زراعتیں": "زراعت",
  "زردے": "زردہ",
  "زردار": "زردار",
  "زردارو": "زردار",
  "زرداروں": "زردار",
  "زردہ": "زردہ",
  "زردو": "زردہ",
  "زردوں": "زردہ",
  "زردی": "زردی",
  "زردیاں": "زردی",
  "زردیو": "زردی",
  "زردیوں": "زردی",
  "زرہ": "زرہ",
  "زرو": "زرہ",
  "زروں": "زرہ",
  "زور": "زور",
  "زورو": "زور",
  "زوروں": "زور",
  "زیادہ": "زیادہ",
  "زیادتی": "زیادتی",
  "زیادتیاں": "زیادتی",
  "زیادتیو": "زیادتی",
  "زیادتیوں": "زیادتی",
  "زیارت": "زیارت",
  "زیارتو": "زیارت",
  "زیارتوں": "زیارت",
  "زیارتیں": "زیارت",
  "زین": "زین",
  "زینے": "زینہ",
  "زینہ": "زینہ",
  "زینو": "زینہ",
  "زینوں": "زینہ",
  "زینیں": "زین",
  "زیر": "زیر",
  "زیرو": "زیر",
  "زیروں": "زیر",
  "زیریں": "زیر",
  "زیور": "زیور",
  "زیورو": "زیور",
  "زیوروں": "زیور",
  "ضابط": "ضابط",
  "ضابطے": "ضابطہ",
  "ضابطگی": "ضابطگی",
  "ضابطگیاں": "ضابطگی",
  "ضابطگیو": "ضابطگی",
  "ضابطگیوں": "ضابطگی",
  "ضابطہ": "ضابطہ",
  "ضابطو": "ضابطہ",
  "ضابطوں": "ضابطہ",
  "ضابطیں": "ضابط",
  "ضعیف": "ضعیف",
  "ضعیفے": "ضعیفہ",
  "ضعیفہ": "ضعیفہ",
  "ضعیفو": "ضعیفہ",
  "ضعیفوں": "ضعیفہ",
  "ضلع": "ضلع",
  "ضلعے": "ضلع",
  "ضلعو": "ضلع",
  "ضلعوں": "ضلع",
  "ضمنی": "ضمنی",
  "ضمنیو": "ضمنی",
  "ضمنیوں": "ضمنی",
  "ضمیمے": "ضمیمہ",
  "ضمیمہ": "ضمیمہ",
  "ضمیمو": "ضمیمہ",
  "ضمیموں": "ضمیمہ",
  "ضرورت": "ضرورت",
  "ضرورتاں": "ضرورت",
  "ضرورتو": "ضرورت",
  "ضرورتوں": "ضرورت",
  "ضرورتیں": "ضرورت",
  "ضیافت": "ضیافت",
  "ضیافتاں": "ضیافت",
  "ضیافتو": "ضیافت",
  "ضیافتوں": "ضیافت",
  "ضیافتیں": "ضیافت",
  "طاعت": "طاعت",
  "طاعتو": "طاعت",
  "طاعتوں": "طاعت",
  "طاعتیں": "طاعت",
  "طالب": "طالب",
  "طالبے": "طالبہ",
  "طالبعلم": "طالبعلم",
  "طالبعلمو": "طالبعلم",
  "طالبعلموں": "طالبعلم",
  "طالبہ": "طالبہ",
  "طالبو": "طالبہ",
  "طالبوں": "طالبہ",
  "طاق": "طاق",
  "طاقچے": "طاقچہ",
  "طاقچہ": "طاقچہ",
  "طاقچو": "طاقچہ",
  "طاقچوں": "طاقچہ",
  "طاقت": "طاقت",
  "طاقتاں": "طاقت",
  "طاقتو": "طاقت",
  "طاقتوے": "طاقتور",
  "طاقتوں": "طاقت",
  "طاقتور": "طاقتور",
  "طاقتوی": "طاقتور",
  "طاقتیں": "طاقت",
  "طاقو": "طاق",
  "طاقوں": "طاق",
  "طائر": "طائر",
  "طائرو": "طائر",
  "طائروں": "طائر",
  "طبلے": "طبلہ",
  "طبلہ": "طبلہ",
  "طبلو": "طبلہ",
  "طبلوں": "طبلہ",
  "طبق": "طبق",
  "طبقے": "طبقہ",
  "طبقہ": "طبقہ",
  "طبقو": "طبقہ",
  "طبقوں": "طبقہ",
  "طبیعت": "طبیعت",
  "طبیعتاں": "طبیعت",
  "طبیعتو": "طبیعت",
  "طبیعتوں": "طبیعت",
  "طبیعتیں": "طبیعت",
  "طعنے": "طعنہ",
  "طعنہ": "طعنہ",
  "طعنو": "طعنہ",
  "طعنوں": "طعنہ",
  "طلاق": "طلاق",
  "طلاقو": "طلاق",
  "طلاقوں": "طلاق",
  "طلاقیں": "طلاق",
  "طلب": "طلب",
  "طلبو": "طلب",
  "طلبوں": "طلب",
  "طلبی": "طلبی",
  "طلبیں": "طلب",
  "طلبیاں": "طلبی",
  "طلبیو": "طلبی",
  "طلبیوں": "طلبی",
  "طلعت": "طلعت",
  "طلعتو": "طلعت",
  "طلعتوں": "طلعت",
  "طلعتیں": "طلعت",
  "طمانچے": "طمانچہ",
  "طمانچہ": "طمانچہ",
  "طمانچو": "طمانچہ",
  "طمانچوں": "طمانچہ",
  "طنطنے": "طنطنہ",
  "طنطنہ": "طنطنہ",
  "طنطنو": "طنطنہ",
  "طنطنوں": "طنطنہ",
  "طرے": "طرہ",
  "طرازی": "طرازی",
  "طرازیاں": "طرازی",
  "طرازیو": "طرازی",
  "طرازیوں": "طرازی",
  "طرہ": "طرہ",
  "طرقے": "طرقہ",
  "طرقہ": "طرقہ",
  "طرقو": "طرقہ",
  "طرقوں": "طرقہ",
  "طرو": "طرہ",
  "طروں": "طرہ",
  "طریقے": "طریقہ",
  "طریقہ": "طریقہ",
  "طریقو": "طریقہ",
  "طریقوں": "طریقہ",
  "طرز": "طرز",
  "طرزو": "طرز",
  "طرزوں": "طرز",
  "طرزیں": "طرز",
  "طوائف": "طوائف",
  "طوائفو": "طوائف",
  "طوائفوں": "طوائف",
  "طوائفیں": "طوائف",
  "طویلے": "طویلہ",
  "طویلہ": "طویلہ",
  "طویلو": "طویلہ",
  "طویلوں": "طویلہ",
  "طوطے": "طوطا",
  "طوطا": "طوطا",
  "طوطو": "طوطا",
  "طوطوں": "طوطا",
  "طیارے": "طیارہ",
  "طیارہ": "طیارہ",
  "طیارو": "طیارہ",
  "طیاروں": "طیارہ",
  "ظالم": "ظالم",
  "ظالمو": "ظالم",
  "ظالموں": "ظالم",
  "ظلم": "ظلم",
  "ظلمو": "ظلم",
  "ظلموں": "ظلم"
}