# coding: utf8
"""
All wordforms are extracted from Norsk Ordbank in Norwegian Bokmål 2005, updated 20180627
(CLARINO NB - Språkbanken), Nasjonalbiblioteket, Norway:
https://www.nb.no/sprakbanken/show?serial=oai%3Anb.no%3Asbr-5&lang=en
License:
Creative_Commons-BY (CC-BY) (https://creativecommons.org/licenses/by/4.0/)
"""

from __future__ import unicode_literals

NOUNS_WORDFORMS = {
'à la carte-servering': ('à la carte-servering',),
'à la carte-serveringen': ('à la carte-servering',),
'à la carte-serveringa': ('à la carte-servering',),
'à la carte-serveringer': ('à la carte-servering',),
'à la carte-serveringene': ('à la carte-servering',),
'14C-datering': ('14C-datering',),
'14C-dateringen': ('14C-datering',),
'14C-dateringa': ('14C-datering',),
'14C-dateringer': ('14C-datering',),
'14C-dateringene': ('14C-datering',),
'A': ('A',),
'A-en': ('A',),
'A-er': ('A',),
'A-ene': ('A',),
'A-dur': ('A-dur',),
'A-duren': ('A-dur',),
'A-durer': ('A-dur',),
'A-durene': ('A-dur',),
'A-egg': ('A-egg',),
'A-egget': ('A-egg',),
'A-egg': ('A-egg',),
'A-egga': ('A-egg',),
'A-eggene': ('A-egg',),
'A-lag': ('A-lag',),
'A-laget': ('A-lag',),
'A-lag': ('A-lag',),
'A-laga': ('A-lag',),
'A-lagene': ('A-lag',),
'A-menneske': ('A-menneske',),
'A-mennesket': ('A-menneske',),
'A-mennesker': ('A-menneske',),
'A-menneska': ('A-menneske',),
'A-menneskene': ('A-menneske',),
'A-moment': ('A-moment',),
'A-momentet': ('A-moment',),
'A-moment': ('A-moment',),
'A-momenter': ('A-moment',),
'A-moment': ('A-moment',),
'A-momenter': ('A-moment',),
'A-momenta': ('A-moment',),
'A-momentene': ('A-moment',),
'A-språk': ('A-språk',),
'A-språket': ('A-språk',),
'A-språk': ('A-språk',),
'A-språka': ('A-språk',),
'A-språkene': ('A-språk',),
'A-vitamin': ('A-vitamin',),
'A-vitaminet': ('A-vitamin',),
'A-vitamin': ('A-vitamin',),
'A-vitaminer': ('A-vitamin',),
'A-vitamin': ('A-vitamin',),
'A-vitaminer': ('A-vitamin',),
'A-vitamina': ('A-vitamin',),
'A-vitaminene': ('A-vitamin',),
'A4-format': ('A4-format',),
'A4-formatet': ('A4-format',),
'A4-format': ('A4-format',),
'A4-formater': ('A4-format',),
'A4-format': ('A4-format',),
'A4-formater': ('A4-format',),
'A4-formata': ('A4-format',),
'A4-formatene': ('A4-format',),
'A5-format': ('A5-format',),
'A5-formatet': ('A5-format',),
'A5-format': ('A5-format',),
'A5-formater': ('A5-format',),
'A5-format': ('A5-format',),
'A5-formater': ('A5-format',),
'A5-formata': ('A5-format',),
'A5-formatene': ('A5-format',),
'ADB-operatør': ('ADB-operatør',),
'ADB-operatøren': ('ADB-operatør',),
'ADB-operatører': ('ADB-operatør',),
'ADB-operatørene': ('ADB-operatør',),
'AV-middel': ('AV-middel',),
'AV-middelet': ('AV-middel',),
'AV-midlet': ('AV-middel',),
'AV-middel': ('AV-middel',),
'AV-midler': ('AV-middel',),
'AV-midla': ('AV-middel',),
'AV-midlene': ('AV-middel',),
'AV-midla': ('AV-middel',),
'AV-midlene': ('AV-middel',),
'Algol': ('Algol',),
'Ass': ('Ass',),
'Assen': ('Ass',),
'Asser': ('Ass',),
'Assene': ('Ass',),
'Ass-dur': ('Ass-dur',),
'Ass-duren': ('Ass-dur',),
'Ass-durer': ('Ass-dur',),
'Ass-durene': ('Ass-dur',),
'B': ('B',),
'B-en': ('B',),
'B-er': ('B',),
'B-ene': ('B',),
'B-dur': ('B-dur',),
'B-duren': ('B-dur',),
'B-durer': ('B-dur',),
'B-durene': ('B-dur',),
'B-film': ('B-film',),
'B-filmen': ('B-film',),
'B-filmer': ('B-film',),
'B-filmene': ('B-film',),
'B-kvalitet': ('B-kvalitet',),
'B-kvaliteten': ('B-kvalitet',),
'B-kvaliteter': ('B-kvalitet',),
'B-kvalitetene': ('B-kvalitet',),
'B-lag': ('B-lag',),
'B-laget': ('B-lag',),
'B-lag': ('B-lag',),
'B-laga': ('B-lag',),
'B-lagene': ('B-lag',),
'B-menneske': ('B-menneske',),
'B-mennesket': ('B-menneske',),
'B-mennesker': ('B-menneske',),
'B-menneska': ('B-menneske',),
'B-menneskene': ('B-menneske',),
'B-moment': ('B-moment',),
'B-momentet': ('B-moment',),
'B-moment': ('B-moment',),
'B-momenter': ('B-moment',),
'B-moment': ('B-moment',),
'B-momenter': ('B-moment',),
'B-momenta': ('B-moment',),
'B-momentene': ('B-moment',),
'B-språk': ('B-språk',),
'B-språket': ('B-språk',),
'B-språk': ('B-språk',),
'B-språka': ('B-språk',),
'B-språkene': ('B-språk',),
'B-vitamin': ('B-vitamin',),
'B-vitaminet': ('B-vitamin',),
'B-vitamin': ('B-vitamin',),
'B-vitaminer': ('B-vitamin',),
'B-vitamin': ('B-vitamin',),
'B-vitaminer': ('B-vitamin',),
'B-vitamina': ('B-vitamin',),
'B-vitaminene': ('B-vitamin',),
'BCG-vaksine': ('BCG-vaksine',),
'BCG-vaksinen': ('BCG-vaksine',),
'BCG-vaksiner': ('BCG-vaksine',),
'BCG-vaksinene': ('BCG-vaksine',),
'BH': ('BH',),
'BH-en': ('BH',),
'BH-er': ('BH',),
'BH-ene': ('BH',),
'Basedows sjukdom': ('Basedows sjukdom',),
'Basedows sykdom': ('Basedows sykdom',),
'Beaufort-skala': ('Beaufort-skala',),
'Beaufort-skalaen': ('Beaufort-skala',),
'Beaufort-skalaer': ('Beaufort-skala',),
'Beaufort-skalaene': ('Beaufort-skala',),
'Blakka': ('Blakka',),
'Blakken': ('Blakken',),
'Borka': ('Borka',),
'Borken': ('Borken',),
'Bruna': ('Bruna',),
'Brunen': ('Brunen',),
'C': ('C',),
'C-en': ('C',),
'C-er': ('C',),
'C-ene': ('C',),
'C-dur': ('C-dur',),
'C-duren': ('C-dur',),
'C-durer': ('C-dur',),
'C-durene': ('C-dur',),
'C-moment': ('C-moment',),
'C-momentet': ('C-moment',),
'C-moment': ('C-moment',),
'C-momenter': ('C-moment',),
'C-moment': ('C-moment',),
'C-momenter': ('C-moment',),
'C-momenta': ('C-moment',),
'C-momentene': ('C-moment',),
'C-språk': ('C-språk',),
'C-språket': ('C-språk',),
'C-språk': ('C-språk',),
'C-språka': ('C-språk',),
'C-språkene': ('C-språk',),
'C-vitamin': ('C-vitamin',),
'C-vitaminet': ('C-vitamin',),
'C-vitamin': ('C-vitamin',),
'C-vitaminer': ('C-vitamin',),
'C-vitamin': ('C-vitamin',),
'C-vitaminer': ('C-vitamin',),
'C-vitamina': ('C-vitamin',),
'C-vitaminene': ('C-vitamin',),
'CD': ('CD',),
'CD-en': ('CD',),
'CD-er': ('CD',),
'CD-ene': ('CD',),
'CD-plate': ('CD-plate',),
'CD-platen': ('CD-plate',),
'CD-plata': ('CD-plate',),
'CD-plater': ('CD-plate',),
'CD-platene': ('CD-plate',),
'CD-speller': ('CD-speller',),
'CD-spelleren': ('CD-speller',),
'CD-spellere': ('CD-speller',),
'CD-spellerne': ('CD-speller',),
'CD-spiller': ('CD-spiller',),
'CD-spilleren': ('CD-spiller',),
'CD-spillere': ('CD-spiller',),
'CD-spillerne': ('CD-spiller',),
'Cess': ('Cess',),
'Cessen': ('Cess',),
'Cesser': ('Cess',),
'Cessene': ('Cess',),
'Ciss': ('Ciss',),
'Cissen': ('Ciss',),
'Cisser': ('Ciss',),
'Cissene': ('Ciss',),
'Ciss-dur': ('Ciss-dur',),
'Ciss-duren': ('Ciss-dur',),
'Ciss-durer': ('Ciss-dur',),
'Ciss-durene': ('Ciss-dur',),
'Cobol': ('Cobol',),
'D': ('D',),
'D-en': ('D',),
'D-er': ('D',),
'D-ene': ('D',),
'D-dag': ('D-dag',),
'D-dagen': ('D-dag',),
'D-dager': ('D-dag',),
'D-dagene': ('D-dag',),
'D-dur': ('D-dur',),
'D-duren': ('D-dur',),
'D-durer': ('D-dur',),
'D-durene': ('D-dur',),
'D-vitamin': ('D-vitamin',),
'D-vitaminet': ('D-vitamin',),
'D-vitamin': ('D-vitamin',),
'D-vitaminer': ('D-vitamin',),
'D-vitamin': ('D-vitamin',),
'D-vitaminer': ('D-vitamin',),
'D-vitamina': ('D-vitamin',),
'D-vitaminene': ('D-vitamin',),
'DDT': ('DDT',),
'DDT-en': ('DDT',),
'DDT-er': ('DDT',),
'DDT-ene': ('DDT',),
'DNA': ('DNA',),
'DNA-et': ('DNA',),
'DNA': ('DNA',),
'DNA-a': ('DNA',),
'DNA-ene': ('DNA',),
'DNA-molekyl': ('DNA-molekyl',),
'DNA-molekylet': ('DNA-molekyl',),
'DNA-molekyl': ('DNA-molekyl',),
'DNA-molekyler': ('DNA-molekyl',),
'DNA-molekyl': ('DNA-molekyl',),
'DNA-molekyler': ('DNA-molekyl',),
'DNA-molekyla': ('DNA-molekyl',),
'DNA-molekylene': ('DNA-molekyl',),
'Dess': ('Dess',),
'Dessen': ('Dess',),
'Desser': ('Dess',),
'Dessene': ('Dess',),
'Dess-dur': ('Dess-dur',),
'Dess-duren': ('Dess-dur',),
'Dess-durer': ('Dess-dur',),
'Dess-durene': ('Dess-dur',),
'Diss': ('Diss',),
'Dissen': ('Diss',),
'Disser': ('Diss',),
'Dissene': ('Diss',),
'Downs syndrom': ('Downs syndrom',),
'Downs syndromet': ('Downs syndrom',),
'Downs syndrom': ('Downs syndrom',),
'Downs syndromer': ('Downs syndrom',),
'Downs syndrom': ('Downs syndrom',),
'Downs syndromer': ('Downs syndrom',),
'Downs syndroma': ('Downs syndrom',),
'Downs syndromene': ('Downs syndrom',),
'E': ('E',),
'E-en': ('E',),
'E-er': ('E',),
'E-ene': ('E',),
'E-dur': ('E-dur',),
'E-duren': ('E-dur',),
'E-durer': ('E-dur',),
'E-durene': ('E-dur',),
'EDB-anlegg': ('EDB-anlegg',),
'EDB-anlegget': ('EDB-anlegg',),
'EDB-anlegg': ('EDB-anlegg',),
'EDB-anlegga': ('EDB-anlegg',),
'EDB-anleggene': ('EDB-anlegg',),
'EDB-operatør': ('EDB-operatør',),
'EDB-operatøren': ('EDB-operatør',),
'EDB-operatører': ('EDB-operatør',),
'EDB-operatørene': ('EDB-operatør',),
'EDB-senter': ('EDB-senter',),
'EDB-senteret': ('EDB-senter',),
'EDB-sentret': ('EDB-senter',),
'EDB-senter': ('EDB-senter',),
'EDB-sentre': ('EDB-senter',),
'EDB-sentra': ('EDB-senter',),
'EDB-sentrene': ('EDB-senter',),
'EDB-sentra': ('EDB-senter',),
'EDB-sentrene': ('EDB-senter',),
'EDB-sentral': ('EDB-sentral',),
'EDB-sentralen': ('EDB-sentral',),
'EDB-sentraler': ('EDB-sentral',),
'EDB-sentralene': ('EDB-sentral',),
'EDB-terminal': ('EDB-terminal',),
'EDB-terminalen': ('EDB-terminal',),
'EDB-terminaler': ('EDB-terminal',),
'EDB-terminalene': ('EDB-terminal',),
'EDB-utstyr': ('EDB-utstyr',),
'EDB-utstyret': ('EDB-utstyr',),
'EDB-utstyr': ('EDB-utstyr',),
'EDB-utstyra': ('EDB-utstyr',),
'EDB-utstyrene': ('EDB-utstyr',),
'EF-land': ('EF-land',),
'EF-landet': ('EF-land',),
'EF-land': ('EF-land',),
'EF-landa': ('EF-land',),
'EF-landene': ('EF-land',),
'EF-medlemskap': ('EF-medlemskap',),
'EF-medlemskapet': ('EF-medlemskap',),
'EF-medlemskap': ('EF-medlemskap',),
'EF-medlemskapa': ('EF-medlemskap',),
'EF-medlemskapene': ('EF-medlemskap',),
'EM': ('EM',),
'EM-et': ('EM',),
'EM': ('EM',),
'EM-a': ('EM',),
'EM-ene': ('EM',),
'EP': ('EP',),
'EP-en': ('EP',),
'EP-er': ('EP',),
'EP-ene': ('EP',),
'EP-plate': ('EP-plate',),
'EP-platen': ('EP-plate',),
'EP-plata': ('EP-plate',),
'EP-plater': ('EP-plate',),
'EP-platene': ('EP-plate',),
'Ess': ('Ess',),
'Essen': ('Ess',),
'Esser': ('Ess',),
'Essene': ('Ess',),
'Ess-dur': ('Ess-dur',),
'Ess-duren': ('Ess-dur',),
'Ess-durer': ('Ess-dur',),
'Ess-durene': ('Ess-dur',),
'EØS-avtale': ('EØS-avtale',),
'EØS-avtalen': ('EØS-avtale',),
'EØS-avtaler': ('EØS-avtale',),
'EØS-avtalene': ('EØS-avtale',),
'F': ('F',),
'F-en': ('F',),
'F-er': ('F',),
'F-ene': ('F',),
'F-dur': ('F-dur',),
'F-duren': ('F-dur',),
'F-durer': ('F-dur',),
'F-durene': ('F-dur',),
'FM': ('FM',),
'FM-en': ('FM',),
'FM-er': ('FM',),
'FM-ene': ('FM',),
'FM-band': ('FM-band',),
'FM-bandet': ('FM-band',),
'FM-band': ('FM-band',),
'FM-banda': ('FM-band',),
'FM-bandene': ('FM-band',),
'FM-bånd': ('FM-bånd',),
'FM-båndet': ('FM-bånd',),
'FM-bånd': ('FM-bånd',),
'FM-bånda': ('FM-bånd',),
'FM-båndene': ('FM-bånd',),
'FM-kringkasting': ('FM-kringkasting',),
'FM-kringkastingen': ('FM-kringkasting',),
'FM-kringkastinga': ('FM-kringkasting',),
'FM-kringkastinger': ('FM-kringkasting',),
'FM-kringkastingene': ('FM-kringkasting',),
'FM-sender': ('FM-sender',),
'FM-senderen': ('FM-sender',),
'FM-sendere': ('FM-sender',),
'FM-senderne': ('FM-sender',),
'Fess': ('Fess',),
'Fessen': ('Fess',),
'Fesser': ('Fess',),
'Fessene': ('Fess',),
'Fiss': ('Fiss',),
'Fissen': ('Fiss',),
'Fisser': ('Fiss',),
'Fissene': ('Fiss',),
'Fiss-dur': ('Fiss-dur',),
'Fiss-duren': ('Fiss-dur',),
'Fiss-durer': ('Fiss-dur',),
'Fiss-durene': ('Fiss-dur',),
'Fortran': ('Fortran',),
'G': ('G',),
'G-en': ('G',),
'G-er': ('G',),
'G-ene': ('G',),
'G-dur': ('G-dur',),
'G-duren': ('G-dur',),
'G-durer': ('G-dur',),
'G-durene': ('G-dur',),
'Gauss-kurve': ('Gauss-kurve',),
'Gauss-kurven': ('Gauss-kurve',),
'Gauss-kurver': ('Gauss-kurve',),
'Gauss-kurvene': ('Gauss-kurve',),
'Gess': ('Gess',),
'Gessen': ('Gess',),
'Gesser': ('Gess',),
'Gessene': ('Gess',),
'Gess-dur': ('Gess-dur',),
'Gess-duren': ('Gess-dur',),
'Gess-durer': ('Gess-dur',),
'Gess-durene': ('Gess-dur',),
'Giss': ('Giss',),
'Gissen': ('Giss',),
'Gisser': ('Giss',),
'Gissene': ('Giss',),
'Giss-dur': ('Giss-dur',),
'Giss-duren': ('Giss-dur',),
'Giss-durer': ('Giss-dur',),
'Giss-durene': ('Giss-dur',),
'H': ('H',),
'H-en': ('H',),
'H-er': ('H',),
'H-ene': ('H',),
'H-bjelke': ('H-bjelke',),
'H-bjelken': ('H-bjelke',),
'H-bjelker': ('H-bjelke',),
'H-bjelkene': ('H-bjelke',),
'H-dur': ('H-dur',),
'H-duren': ('H-dur',),
'H-durer': ('H-dur',),
'H-durene': ('H-dur',),
'H-melk': ('H-melk',),
'H-melken': ('H-melk',),
'H-melka': ('H-melk',),
'H-melker': ('H-melk',),
'H-melkene': ('H-melk',),
'H-melkkartong': ('H-melkkartong',),
'H-melkkartongen': ('H-melkkartong',),
'H-melkkartonger': ('H-melkkartong',),
'H-melkkartongene': ('H-melkkartong',),
'H-mjølk': ('H-mjølk',),
'H-mjølken': ('H-mjølk',),
'H-mjølka': ('H-mjølk',),
'H-mjølker': ('H-mjølk',),
'H-mjølkene': ('H-mjølk',),
'H-mjølkkartong': ('H-mjølkkartong',),
'H-mjølkkartongen': ('H-mjølkkartong',),
'H-mjølkkartonger': ('H-mjølkkartong',),
'H-mjølkkartongene': ('H-mjølkkartong',),
'HB-apparat': ('HB-apparat',),
'HB-apparatet': ('HB-apparat',),
'HB-apparat': ('HB-apparat',),
'HB-apparater': ('HB-apparat',),
'HB-apparat': ('HB-apparat',),
'HB-apparater': ('HB-apparat',),
'HB-apparata': ('HB-apparat',),
'HB-apparatene': ('HB-apparat',),
'Hi-Fi': ('Hi-Fi',),
'Hi-Fien': ('Hi-Fi',),
'Hi-Fier': ('Hi-Fi',),
'Hi-Fiene': ('Hi-Fi',),
'I': ('I',),
'I-en': ('I',),
'I-er': ('I',),
'I-ene': ('I',),
'J': ('J',),
'J-en': ('J',),
'J-er': ('J',),
'J-ene': ('J',),
'Jesusbilde': ('Jesusbilde',),
'Jesusbildet': ('Jesusbilde',),
'Jesusbilder': ('Jesusbilde',),
'Jesusbilda': ('Jesusbilde',),
'Jesusbildene': ('Jesusbilde',),
'K': ('K',),
'K-en': ('K',),
'K-er': ('K',),
'K-ene': ('K',),
'KM': ('KM',),
'KM-et': ('KM',),
'KM': ('KM',),
'KM-a': ('KM',),
'KM-ene': ('KM',),
'L': ('L',),
'L-en': ('L',),
'L-er': ('L',),
'L-ene': ('L',),
'LP': ('LP',),
'LP-en': ('LP',),
'LP-er': ('LP',),
'LP-ene': ('LP',),
'LP-plate': ('LP-plate',),
'LP-platen': ('LP-plate',),
'LP-plata': ('LP-plate',),
'LP-plater': ('LP-plate',),
'LP-platene': ('LP-plate',),
'LSD': ('LSD',),
'LSD-en': ('LSD',),
'LSD-er': ('LSD',),
'LSD-ene': ('LSD',),
'LSD-rus': ('LSD-rus',),
'LSD-rusen': ('LSD-rus',),
'LSD-ruser': ('LSD-rus',),
'LSD-rusene': ('LSD-rus',),
'M': ('M',),
'M-en': ('M',),
'M-er': ('M',),
'M-ene': ('M',),
'MS-pasient': ('MS-pasient',),
'MS-pasienten': ('MS-pasient',),
'MS-pasienter': ('MS-pasient',),
'MS-pasientene': ('MS-pasient',),
'MTB': ('MTB',),
'MTBen': ('MTB',),
'MTBer': ('MTB',),
'MTBene': ('MTB',),
'N': ('N',),
'N-en': ('N',),
'N-er': ('N',),
'N-ene': ('N',),
'NATO-land': ('NATO-land',),
'NATO-landet': ('NATO-land',),
'NATO-land': ('NATO-land',),
'NATO-landa': ('NATO-land',),
'NATO-landene': ('NATO-land',),
'NM': ('NM',),
'NM-et': ('NM',),
'NM': ('NM',),
'NM-a': ('NM',),
'NM-ene': ('NM',),
'NN-fange': ('NN-fange',),
'NN-fangen': ('NN-fange',),
'NN-fanger': ('NN-fange',),
'NN-fangene': ('NN-fange',),
'NS-medlem': ('NS-medlem',),
'NS-medlemmet': ('NS-medlem',),
'NS-medlemmer': ('NS-medlem',),
'NS-medlemma': ('NS-medlem',),
'NS-medlemmene': ('NS-medlem',),
'Nato-land': ('Nato-land',),
'Nato-landet': ('Nato-land',),
'Nato-land': ('Nato-land',),
'Nato-landa': ('Nato-land',),
'Nato-landene': ('Nato-land',),
'Norden': ('Norden',),
'O': ('O',),
'O-en': ('O',),
'O-er': ('O',),
'O-ene': ('O',),
'OL': ('OL',),
'OL-et': ('OL',),
'OL': ('OL',),
'OL-a': ('OL',),
'OL-ene': ('OL',),
'OL-pins': ('OL-pins',),
'OL-pinsen': ('OL-pins',),
'OL-pinser': ('OL-pins',),
'OL-pins': ('OL-pins',),
'OL-pinsene': ('OL-pins',),
'Oksidenten': ('Oksidenten',),
'Ola': ('Ola',),
'P': ('P',),
'P-en': ('P',),
'P-er': ('P',),
'P-ene': ('P',),
'PC': ('PC',),
'PC-en': ('PC',),
'PC-er': ('PC',),
'PC-ene': ('PC',),
'PD': ('PD',),
'PD-en': ('PD',),
'PD-er': ('PD',),
'PD-ene': ('PD',),
'PD-setting': ('PD-setting',),
'PD-settingen': ('PD-setting',),
'PD-settinga': ('PD-setting',),
'PD-settinger': ('PD-setting',),
'PD-settingene': ('PD-setting',),
'PM': ('PM',),
'PM-et': ('PM',),
'PM': ('PM',),
'PM-er': ('PM',),
'PM': ('PM',),
'PM-a': ('PM',),
'PM-ene': ('PM',),
'PM-a': ('PM',),
'PM-ene': ('PM',),
'PR': ('PR',),
'PR-en': ('PR',),
'PR-er': ('PR',),
'PR-ene': ('PR',),
'PR-mann': ('PR-mann',),
'PR-mannen': ('PR-mann',),
'PR-menn': ('PR-mann',),
'PR-mennene': ('PR-mann',),
'PS': ('PS',),
'PS-et': ('PS',),
'PS': ('PS',),
'PS-er': ('PS',),
'PS': ('PS',),
'PS-a': ('PS',),
'PS-ene': ('PS',),
'PS-a': ('PS',),
'PS-ene': ('PS',),
'Parkinsons sjukdom': ('Parkinsons sjukdom',),
'Parkinsons sykdom': ('Parkinsons sykdom',),
'Pascal': ('Pascal',),
'Per': ('Per',),
'Peren': ('Per',),
'Perer': ('Per',),
'Perene': ('Per',),
'Pfg': ('Pfg',),
'Q': ('Q',),
'Q-en': ('Q',),
'Q-er': ('Q',),
'Q-ene': ('Q',),
'Q-verdi': ('Q-verdi',),
'Q-verdien': ('Q-verdi',),
'Q-verdier': ('Q-verdi',),
'Q-verdiene': ('Q-verdi',),
'R': ('R',),
'R-en': ('R',),
'R-er': ('R',),
'R-ene': ('R',),
'Rh-faktor': ('Rh-faktor',),
'Rh-faktoren': ('Rh-faktor',),
'Rh-faktorer': ('Rh-faktor',),
'Rh-faktorene': ('Rh-faktor',),
'S': ('S',),
'S-en': ('S',),
'S-er': ('S',),
'S-ene': ('S',),
'SI-system': ('SI-system',),
'SI-systemet': ('SI-system',),
'SI-system': ('SI-system',),
'SI-systemer': ('SI-system',),
'SI-system': ('SI-system',),
'SI-systemer': ('SI-system',),
'SI-systema': ('SI-system',),
'SI-systemene': ('SI-system',),
'SOS': ('SOS',),
'SOS-et': ('SOS',),
'SOS': ('SOS',),
'SOS-a': ('SOS',),
'SOS-ene': ('SOS',),
'Sankt Elms ild': ('Sankt Elms ild',),
'Simula': ('Simula',),
'Syden': ('Syden',),
'T': ('T',),
'T-en': ('T',),
'T-er': ('T',),
'T-ene': ('T',),
'T-bane': ('T-bane',),
'T-banen': ('T-bane',),
'T-baner': ('T-bane',),
'T-banene': ('T-bane',),
'T-beinsteik': ('T-beinsteik',),
'T-beinsteiken': ('T-beinsteik',),
'T-beinsteika': ('T-beinsteik',),
'T-beinsteiker': ('T-beinsteik',),
'T-beinsteikene': ('T-beinsteik',),
'T-beinstek': ('T-beinstek',),
'T-beinsteken': ('T-beinstek',),
'T-beinsteka': ('T-beinstek',),
'T-beinsteker': ('T-beinstek',),
'T-beinstekene': ('T-beinstek',),
'T-bensteik': ('T-bensteik',),
'T-bensteiken': ('T-bensteik',),
'T-bensteika': ('T-bensteik',),
'T-bensteiker': ('T-bensteik',),
'T-bensteikene': ('T-bensteik',),
'T-benstek': ('T-benstek',),
'T-bensteken': ('T-benstek',),
'T-bensteka': ('T-benstek',),
'T-bensteker': ('T-benstek',),
'T-benstekene': ('T-benstek',),
'T-bjelke': ('T-bjelke',),
'T-bjelken': ('T-bjelke',),
'T-bjelker': ('T-bjelke',),
'T-bjelkene': ('T-bjelke',),
'T-jern': ('T-jern',),
'T-jernet': ('T-jern',),
'T-jern': ('T-jern',),
'T-jerna': ('T-jern',),
'T-jernene': ('T-jern',),
'T-kryss': ('T-kryss',),
'T-krysset': ('T-kryss',),
'T-kryss': ('T-kryss',),
'T-kryssa': ('T-kryss',),
'T-kryssene': ('T-kryss',),
'T-skjorte': ('T-skjorte',),
'T-skjorten': ('T-skjorte',),
'T-skjorta': ('T-skjorte',),
'T-skjorter': ('T-skjorte',),
'T-skjortene': ('T-skjorte',),
'T-stål': ('T-stål',),
'T-stålet': ('T-stål',),
'T-stål': ('T-stål',),
'T-ståla': ('T-stål',),
'T-stålene': ('T-stål',),
'TG-grammatikk': ('TG-grammatikk',),
'TG-grammatikken': ('TG-grammatikk',),
'TG-grammatikker': ('TG-grammatikk',),
'TG-grammatikkene': ('TG-grammatikk',),
'TV': ('TV',),
'TV-en': ('TV',),
'TV-er': ('TV',),
'TV-ene': ('TV',),
'TV-antenne': ('TV-antenne',),
'TV-antennen': ('TV-antenne',),
'TV-antenna': ('TV-antenne',),
'TV-antenner': ('TV-antenne',),
'TV-antennene': ('TV-antenne',),
'TV-apparat': ('TV-apparat',),
'TV-apparatet': ('TV-apparat',),
'TV-apparat': ('TV-apparat',),
'TV-apparater': ('TV-apparat',),
'TV-apparat': ('TV-apparat',),
'TV-apparater': ('TV-apparat',),
'TV-apparata': ('TV-apparat',),
'TV-apparatene': ('TV-apparat',),
'TV-film': ('TV-film',),
'TV-filmen': ('TV-film',),
'TV-filmer': ('TV-film',),
'TV-filmene': ('TV-film',),
'TV-kanne': ('TV-kanne',),
'TV-kannen': ('TV-kanne',),
'TV-kanna': ('TV-kanne',),
'TV-kanner': ('TV-kanne',),
'TV-kannene': ('TV-kanne',),
'TV-kjendis': ('TV-kjendis',),
'TV-kjendisen': ('TV-kjendis',),
'TV-kjendiser': ('TV-kjendis',),
'TV-kjendisene': ('TV-kjendis',),
'TV-overføring': ('TV-overføring',),
'TV-overføringen': ('TV-overføring',),
'TV-overføringa': ('TV-overføring',),
'TV-overføringer': ('TV-overføring',),
'TV-overføringene': ('TV-overføring',),
'TV-overvåking': ('TV-overvåking',),
'TV-overvåkingen': ('TV-overvåking',),
'TV-overvåkinga': ('TV-overvåking',),
'TV-overvåkinger': ('TV-overvåking',),
'TV-overvåkingene': ('TV-overvåking',),
'TV-overvåkning': ('TV-overvåkning',),
'TV-overvåkningen': ('TV-overvåkning',),
'TV-overvåkninga': ('TV-overvåkning',),
'TV-overvåkninger': ('TV-overvåkning',),
'TV-overvåkningene': ('TV-overvåkning',),
'TV-program': ('TV-program',),
'TV-programmet': ('TV-program',),
'TV-program': ('TV-program',),
'TV-programmer': ('TV-program',),
'TV-programma': ('TV-program',),
'TV-programmene': ('TV-program',),
'TV-programma': ('TV-program',),
'TV-programmene': ('TV-program',),
'TV-skjerm': ('TV-skjerm',),
'TV-skjermen': ('TV-skjerm',),
'TV-skjermer': ('TV-skjerm',),
'TV-skjermene': ('TV-skjerm',),
'TV-vert': ('TV-vert',),
'TV-verten': ('TV-vert',),
'TV-verter': ('TV-vert',),
'TV-vertene': ('TV-vert',),
'TV-vertinne': ('TV-vertinne',),
'TV-vertinnen': ('TV-vertinne',),
'TV-vertinna': ('TV-vertinne',),
'TV-vertinner': ('TV-vertinne',),
'TV-vertinnene': ('TV-vertinne',),
'Tellus': ('Tellus',),
'Thalia': ('Thalia',),
'U': ('U',),
'U-en': ('U',),
'U-er': ('U',),
'U-ene': ('U',),
'U-dal': ('U-dal',),
'U-dalen': ('U-dal',),
'U-daler': ('U-dal',),
'U-dalene': ('U-dal',),
'U-jern': ('U-jern',),
'U-jernet': ('U-jern',),
'U-jern': ('U-jern',),
'U-jerna': ('U-jern',),
'U-jernene': ('U-jern',),
'U-stål': ('U-stål',),
'U-stålet': ('U-stål',),
'U-stål': ('U-stål',),
'U-ståla': ('U-stål',),
'U-stålene': ('U-stål',),
'V': ('V',),
'V-en': ('V',),
'V-er': ('V',),
'V-ene': ('V',),
'V-bombe': ('V-bombe',),
'V-bomben': ('V-bombe',),
'V-bomba': ('V-bombe',),
'V-bomber': ('V-bombe',),
'V-bombene': ('V-bombe',),
'V-dag': ('V-dag',),
'V-dagen': ('V-dag',),
'V-dager': ('V-dag',),
'V-dagene': ('V-dag',),
'V-dal': ('V-dal',),
'V-dalen': ('V-dal',),
'V-daler': ('V-dal',),
'V-dalene': ('V-dal',),
'V-genser': ('V-genser',),
'V-genseren': ('V-genser',),
'V-gensere': ('V-genser',),
'V-genserne': ('V-genser',),
'V-utringning': ('V-utringning',),
'V-utringningen': ('V-utringning',),
'V-utringninga': ('V-utringning',),
'V-utringninger': ('V-utringning',),
'V-utringningene': ('V-utringning',),
'V6-kupong': ('V6-kupong',),
'V6-kupongen': ('V6-kupong',),
'V6-kuponger': ('V6-kupong',),
'V6-kupongene': ('V6-kupong',),
'V6-løp': ('V6-løp',),
'V6-løpet': ('V6-løp',),
'V6-løp': ('V6-løp',),
'V6-løpa': ('V6-løp',),
'V6-løpene': ('V6-løp',),
'V6-rekke': ('V6-rekke',),
'V6-rekken': ('V6-rekke',),
'V6-rekka': ('V6-rekke',),
'V6-rekker': ('V6-rekke',),
'V6-rekkene': ('V6-rekke',),
'VIP': ('VIP',),
'VIP-en': ('VIP',),
'VIP-er': ('VIP',),
'VIP-ene': ('VIP',),
'VM': ('VM',),
'VM-et': ('VM',),
'VM': ('VM',),
'VM-a': ('VM',),
'VM-ene': ('VM',),
'VVS-ingeniør': ('VVS-ingeniør',),
'VVS-ingeniøren': ('VVS-ingeniør',),
'VVS-ingeniører': ('VVS-ingeniør',),
'VVS-ingeniørene': ('VVS-ingeniør',),
'Vesten': ('Vesten',),
'Vårherre': ('Vårherre',),
'W': ('W',),
'W-en': ('W',),
'W-er': ('W',),
'W-ene': ('W',),
'WC': ('WC',),
'WC-et': ('WC',),
'WC': ('WC',),
'WC-er': ('WC',),
'WC': ('WC',),
'WC-a': ('WC',),
'WC-ene': ('WC',),
'WC-a': ('WC',),
'WC-ene': ('WC',),
'X': ('X',),
'X-en': ('X',),
'X-er': ('X',),
'X-ene': ('X',),
'Y': ('Y',),
'Y-en': ('Y',),
'Y-er': ('Y',),
'Y-ene': ('Y',),
'Z': ('Z',),
'Z-en': ('Z',),
'Z-er': ('Z',),
'Z-ene': ('Z',),
'Zodiak': ('Zodiak',),
'Zodiaken': ('Zodiak',),
'Zodiaker': ('Zodiak',),
'Zodiakene': ('Zodiak',),
'Zodiakus': ('Zodiakus',),
'Zodiakusen': ('Zodiakus',),
'Zodiakuser': ('Zodiakus',),
'Zodiakusene': ('Zodiakus',),
'a': ('a',),
'a-en': ('a',),
'a-er': ('a',),
'a-ene': ('a',),
'a-bombe': ('a-bombe',),
'a-bomben': ('a-bombe',),
'a-bomba': ('a-bombe',),
'a-bomber': ('a-bombe',),
'a-bombene': ('a-bombe',),
'a-egg': ('a-egg',),
'a-egget': ('a-egg',),
'a-egg': ('a-egg',),
'a-egga': ('a-egg',),
'a-eggene': ('a-egg',),
'a-endelse': ('a-endelse',),
'a-endelsen': ('a-endelse',),
'a-endelser': ('a-endelse',),
'a-endelsene': ('a-endelse',),
'a-ending': ('a-ending',),
'a-endingen': ('a-ending',),
'a-endinga': ('a-ending',),
'a-endinger': ('a-ending',),
'a-endingene': ('a-ending',),
'a-form': ('a-form',),
'a-formen': ('a-form',),
'a-forma': ('a-form',),
'a-former': ('a-form',),
'a-formene': ('a-form',),
'a-lag': ('a-lag',),
'a-laget': ('a-lag',),
'a-lag': ('a-lag',),
'a-laga': ('a-lag',),
'a-lagene': ('a-lag',),
'a-menneske': ('a-menneske',),
'a-mennesket': ('a-menneske',),
'a-mennesker': ('a-menneske',),
'a-menneska': ('a-menneske',),
'a-menneskene': ('a-menneske',),
'a-moll': ('a-moll',),
'a-mollen': ('a-moll',),
'a-moller': ('a-moll',),
'a-mollene': ('a-moll',),
'a-mollkonsert': ('a-mollkonsert',),
'a-mollkonserten': ('a-mollkonsert',),
'a-mollkonserter': ('a-mollkonsert',),
'a-mollkonsertene': ('a-mollkonsert',),
'a-mål': ('a-mål',),
'a-målet': ('a-mål',),
'a-mål': ('a-mål',),
'a-måla': ('a-mål',),
'a-målene': ('a-mål',),
'a-våpen': ('a-våpen',),
'a-våpenet': ('a-våpen',),
'a-våpen': ('a-våpen',),
'a-våpna': ('a-våpen',),
'a-våpnene': ('a-våpen',),
'ab-kjøp': ('ab-kjøp',),
'ab-kjøpet': ('ab-kjøp',),
'ab-kjøp': ('ab-kjøp',),
'ab-kjøpa': ('ab-kjøp',),
'ab-kjøpene': ('ab-kjøp',),
'ab-kontrakt': ('ab-kontrakt',),
'ab-kontrakten': ('ab-kontrakt',),
'ab-kontrakter': ('ab-kontrakt',),
'ab-kontraktene': ('ab-kontrakt',),
'abbed': ('abbed',),
'abbeden': ('abbed',),
'abbeder': ('abbed',),
'abbedene': ('abbed',),
'abbedi': ('abbedi',),
'abbediet': ('abbedi',),
'abbedi': ('abbedi',),
'abbedier': ('abbedi',),
'abbedi': ('abbedi',),
'abbedier': ('abbedi',),
'abbedia': ('abbedi',),
'abbediene': ('abbedi',),
'abbedisse': ('abbedisse',),
'abbedissen': ('abbedisse',),
'abbedissa': ('abbedisse',),
'abbedisser': ('abbedisse',),
'abbedissene': ('abbedisse',),
'abbor': ('abbor',),
'abboren': ('abbor',),
'abborer': ('abbor',),
'abborene': ('abbor',),
'abbreviasjon': ('abbreviasjon',),
'abbreviasjonen': ('abbreviasjon',),
'abbreviasjoner': ('abbreviasjon',),
'abbreviasjonene': ('abbreviasjon',),
'abbreviatur': ('abbreviatur',),
'abbreviaturen': ('abbreviatur',),
'abbreviaturer': ('abbreviatur',),
'abbreviaturene': ('abbreviatur',),
'abc': ('abc',),
'abc-en': ('abc',),
'abc-a': ('abc',),
'abc-er': ('abc',),
'abc-ene': ('abc',),
'abc-bok': ('abc-bok',),
'abc-boken': ('abc-bok',),
'abc-boka': ('abc-bok',),
'abc-bøker': ('abc-bok',),
'abc-bøkene': ('abc-bok',),
'abc-krigføring': ('abc-krigføring',),
'abc-krigføringen': ('abc-krigføring',),
'abc-krigføringa': ('abc-krigføring',),
'abc-krigføringer': ('abc-krigføring',),
'abc-krigføringene': ('abc-krigføring',),
'abc-våpen': ('abc-våpen',),
'abc-våpenet': ('abc-våpen',),
'abc-våpen': ('abc-våpen',),
'abc-våpna': ('abc-våpen',),
'abc-våpnene': ('abc-våpen',),
'abdikasjon': ('abdikasjon',),
'abdikasjonen': ('abdikasjon',),
'abdikasjoner': ('abdikasjon',),
'abdikasjonene': ('abdikasjon',),
'abdomen': ('abdomen',),
'abdomenet': ('abdomen',),
'abdomen': ('abdomen',),
'abdomina': ('abdomen',),
'abdomena': ('abdomen',),
'abdomenene': ('abdomen',),
'abdominaene': ('abdomen',),
'aber': ('aber',),
'aberet': ('aber',),
'aber': ('aber',),
'abere': ('aber',),
'abera': ('aber',),
'aberne': ('aber',),
'abera': ('aber',),
'aberne': ('aber',),
'aberrasjon': ('aberrasjon',),
'aberrasjonen': ('aberrasjon',),
'aberrasjoner': ('aberrasjon',),
'aberrasjonene': ('aberrasjon',),
'abessinier': ('abessinier',),
'abessinieren': ('abessinier',),
'abessiniere': ('abessinier',),
'abessinierne': ('abessinier',),
'abkhaser': ('abkhaser',),
'abkhaseren': ('abkhaser',),
'abkhasere': ('abkhaser',),
'abkhaserne': ('abkhaser',),
'ablativ': ('ablativ',),
'ablativen': ('ablativ',),
'ablativer': ('ablativ',),
'ablativene': ('ablativ',),
'abnormitet': ('abnormitet',),
'abnormiteten': ('abnormitet',),
'abnormiteter': ('abnormitet',),
'abnormitetene': ('abnormitet',),
'abolisjon': ('abolisjon',),
'abolisjonen': ('abolisjon',),
'abolisjoner': ('abolisjon',),
'abolisjonene': ('abolisjon',),
'abolisjonist': ('abolisjonist',),
'abolisjonisten': ('abolisjonist',),
'abolisjonister': ('abolisjonist',),
'abolisjonistene': ('abolisjonist',),
'abonnement': ('abonnement',),
'abonnementet': ('abonnement',),
'abonnement': ('abonnement',),
'abonnementer': ('abonnement',),
'abonnement': ('abonnement',),
'abonnementer': ('abonnement',),
'abonnementa': ('abonnement',),
'abonnementene': ('abonnement',),
'abonnementsavgift': ('abonnementsavgift',),
'abonnementsavgiften': ('abonnementsavgift',),
'abonnementsavgifta': ('abonnementsavgift',),
'abonnementsavgifter': ('abonnementsavgift',),
'abonnementsavgiftene': ('abonnementsavgift',),
'abonnementskonsert': ('abonnementskonsert',),
'abonnementskonserten': ('abonnementskonsert',),
'abonnementskonserter': ('abonnementskonsert',),
'abonnementskonsertene': ('abonnementskonsert',),
'abonnementspris': ('abonnementspris',),
'abonnementsprisen': ('abonnementspris',),
'abonnementspriser': ('abonnementspris',),
'abonnementsprisene': ('abonnementspris',),
'abonnementssalg': ('abonnementssalg',),
'abonnementssalget': ('abonnementssalg',),
'abonnementssalg': ('abonnementssalg',),
'abonnementssalga': ('abonnementssalg',),
'abonnementssalgene': ('abonnementssalg',),
'abonnent': ('abonnent',),
'abonnenten': ('abonnent',),
'abonnenter': ('abonnent',),
'abonnentene': ('abonnent',),
'aborigin': ('aborigin',),
'aboriginen': ('aborigin',),
'aboriginer': ('aborigin',),
'aboriginene': ('aborigin',),
'abort': ('abort',),
'aborten': ('abort',),
'aborter': ('abort',),
'abortene': ('abort',),
'abortiv': ('abortiv',),
'abortivet': ('abortiv',),
'abortiv': ('abortiv',),
'abortiver': ('abortiv',),
'abortiv': ('abortiv',),
'abortiver': ('abortiv',),
'abortiva': ('abortiv',),
'abortivene': ('abortiv',),
'abortivkur': ('abortivkur',),
'abortivkuren': ('abortivkur',),
'abortivkurer': ('abortivkur',),
'abortivkurene': ('abortivkur',),
'abortivmiddel': ('abortivmiddel',),
'abortivmiddelet': ('abortivmiddel',),
'abortivmidlet': ('abortivmiddel',),
'abortivmiddel': ('abortivmiddel',),
'abortivmidler': ('abortivmiddel',),
'abortivmidla': ('abortivmiddel',),
'abortivmidlene': ('abortivmiddel',),
'abortivmidla': ('abortivmiddel',),
'abortivmidlene': ('abortivmiddel',),
'abortlov': ('abortlov',),
'abortloven': ('abortlov',),
'abortlover': ('abortlov',),
'abortlovene': ('abortlov',),
'abortsøker': ('abortsøker',),
'abortsøkeren': ('abortsøker',),
'abortsøkere': ('abortsøker',),
'abortsøkerne': ('abortsøker',),
'abortus provocatus': ('abortus provocatus',),
'abrakadabra': ('abrakadabra',),
'abrakadabraet': ('abrakadabra',),
'abrakadabra': ('abrakadabra',),
'abrakadabraa': ('abrakadabra',),
'abrakadabraene': ('abrakadabra',),
'abrodd': ('abrodd',),
'abrodden': ('abrodd',),
'abrodder': ('abrodd',),
'abroddene': ('abrodd',),
'abrot': ('abrot',),
'abroten': ('abrot',),
'abroter': ('abrot',),
'abrotene': ('abrot',),
'abscess': ('abscess',),
'abscessen': ('abscess',),
'abscesser': ('abscess',),
'abscessene': ('abscess',),
'abscisse': ('abscisse',),
'abscissen': ('abscisse',),
'abscisser': ('abscisse',),
'abscissene': ('abscisse',),
'abscisseakse': ('abscisseakse',),
'abscisseaksen': ('abscisseakse',),
'abscisseakser': ('abscisseakse',),
'abscisseaksene': ('abscisseakse',),
'absentia': ('absentia',),
'absint': ('absint',),
'absinten': ('absint',),
'absinter': ('absint',),
'absintene': ('absint',),
'absolusjon': ('absolusjon',),
'absolusjonen': ('absolusjon',),
'absolusjoner': ('absolusjon',),
'absolusjonene': ('absolusjon',),
'absolutisme': ('absolutisme',),
'absolutismen': ('absolutisme',),
'absolutismer': ('absolutisme',),
'absolutismene': ('absolutisme',),
'absolutist': ('absolutist',),
'absolutisten': ('absolutist',),
'absolutister': ('absolutist',),
'absolutistene': ('absolutist',),
'absolutt': ('absolutt',),
'absoluttet': ('absolutt',),
'absolutt': ('absolutt',),
'absolutter': ('absolutt',),
'absolutt': ('absolutt',),
'absolutter': ('absolutt',),
'absolutta': ('absolutt',),
'absoluttene': ('absolutt',),
'absorbent': ('absorbent',),
'absorbenten': ('absorbent',),
'absorbenter': ('absorbent',),
'absorbentene': ('absorbent',),
'absorbering': ('absorbering',),
'absorberingen': ('absorbering',),
'absorberinga': ('absorbering',),
'absorberinger': ('absorbering',),
'absorberingene': ('absorbering',),
'absorberingsevne': ('absorberingsevne',),
'absorberingsevnen': ('absorberingsevne',),
'absorberingsevna': ('absorberingsevne',),
'absorberingsevner': ('absorberingsevne',),
'absorberingsevnene': ('absorberingsevne',),
'absorberingskoeffisient': ('absorberingskoeffisient',),
'absorberingskoeffisienten': ('absorberingskoeffisient',),
'absorberingskoeffisienter': ('absorberingskoeffisient',),
'absorberingskoeffisientene': ('absorberingskoeffisient',),
'absorpsjon': ('absorpsjon',),
'absorpsjonen': ('absorpsjon',),
'absorpsjoner': ('absorpsjon',),
'absorpsjonene': ('absorpsjon',),
'absorpsjonsevne': ('absorpsjonsevne',),
'absorpsjonsevnen': ('absorpsjonsevne',),
'absorpsjonsevna': ('absorpsjonsevne',),
'absorpsjonsevner': ('absorpsjonsevne',),
'absorpsjonsevnene': ('absorpsjonsevne',),
'absorpsjonskoeffisient': ('absorpsjonskoeffisient',),
'absorpsjonskoeffisienten': ('absorpsjonskoeffisient',),
'absorpsjonskoeffisienter': ('absorpsjonskoeffisient',),
'absorpsjonskoeffisientene': ('absorpsjonskoeffisient',),
'abstinens': ('abstinens',),
'abstinensen': ('abstinens',),
'abstinenser': ('abstinens',),
'abstinensene': ('abstinens',),
'abstinenssymptom': ('abstinenssymptom',),
'abstinenssymptomet': ('abstinenssymptom',),
'abstinenssymptom': ('abstinenssymptom',),
'abstinenssymptomer': ('abstinenssymptom',),
'abstinenssymptom': ('abstinenssymptom',),
'abstinenssymptomer': ('abstinenssymptom',),
'abstinenssymptoma': ('abstinenssymptom',),
'abstinenssymptomene': ('abstinenssymptom',),
'abstinensvanske': ('abstinensvanske',),
'abstinensvansken': ('abstinensvanske',),
'abstinensvansker': ('abstinensvanske',),
'abstinensvanskene': ('abstinensvanske',),
'abstrahering': ('abstrahering',),
'abstraheringen': ('abstrahering',),
'abstraheringa': ('abstrahering',),
'abstraheringer': ('abstrahering',),
'abstraheringene': ('abstrahering',),
'abstraksjon': ('abstraksjon',),
'abstraksjonen': ('abstraksjon',),
'abstraksjoner': ('abstraksjon',),
'abstraksjonene': ('abstraksjon',),
'abstraksjonsevne': ('abstraksjonsevne',),
'abstraksjonsevnen': ('abstraksjonsevne',),
'abstraksjonsevna': ('abstraksjonsevne',),
'abstraksjonsevner': ('abstraksjonsevne',),
'abstraksjonsevnene': ('abstraksjonsevne',),
'abstraksjonsnivå': ('abstraksjonsnivå',),
'abstraksjonsnivået': ('abstraksjonsnivå',),
'abstraksjonsnivå': ('abstraksjonsnivå',),
'abstraksjonsnivåer': ('abstraksjonsnivå',),
'abstraksjonsnivå': ('abstraksjonsnivå',),
'abstraksjonsnivåer': ('abstraksjonsnivå',),
'abstraksjonsnivåa': ('abstraksjonsnivå',),
'abstraksjonsnivåene': ('abstraksjonsnivå',),
'abstrakt': ('abstrakt',),
'abstraktet': ('abstrakt',),
'abstrakt': ('abstrakt',),
'abstrakter': ('abstrakt',),
'abstrakt': ('abstrakt',),
'abstrakter': ('abstrakt',),
'abstrakta': ('abstrakt',),
'abstraktene': ('abstrakt',),
'absurdisme': ('absurdisme',),
'absurdismen': ('absurdisme',),
'absurdismer': ('absurdisme',),
'absurdismene': ('absurdisme',),
'absurditet': ('absurditet',),
'absurditeten': ('absurditet',),
'absurditeter': ('absurditet',),
'absurditetene': ('absurditet',),
'accent aigu': ('accent aigu',),
'accent aiguen': ('accent aigu',),
'accent aiguer': ('accent aigu',),
'accent aiguene': ('accent aigu',),
'accent circonflexe': ('accent circonflexe',),
'accent circonflexen': ('accent circonflexe',),
'accent circonflexer': ('accent circonflexe',),
'accent circonflexene': ('accent circonflexe',),
'accent grave': ('accent grave',),
'accent graven': ('accent grave',),
'accent graver': ('accent grave',),
'accent gravene': ('accent grave',),
'accessoirer': ('accessoirer',),
'accessoirene': ('accessoirer',),
'acetat': ('acetat',),
'acetatet': ('acetat',),
'acetat': ('acetat',),
'acetater': ('acetat',),
'acetat': ('acetat',),
'acetater': ('acetat',),
'acetata': ('acetat',),
'acetatene': ('acetat',),
'aceton': ('aceton',),
'acetonet': ('aceton',),
'aceton': ('aceton',),
'acetona': ('aceton',),
'acetonene': ('aceton',),
'acetyl': ('acetyl',),
'acetylet': ('acetyl',),
'acetyl': ('acetyl',),
'acetyla': ('acetyl',),
'acetylene': ('acetyl',),
'acetylen': ('acetylen',),
'acetylenet': ('acetylen',),
'acetylen': ('acetylen',),
'acetylena': ('acetylen',),
'acetylenene': ('acetylen',),
'acetylsalisylsyre': ('acetylsalisylsyre',),
'acetylsalisylsyren': ('acetylsalisylsyre',),
'acetylsalisylsyra': ('acetylsalisylsyre',),
'acetylsalisylsyrer': ('acetylsalisylsyre',),
'acetylsalisylsyrene': ('acetylsalisylsyre',),
'acre': ('acre',),
'acren': ('acre',),
'acre': ('acre',),
'acres': ('acre',),
'acrene': ('acre',),
'actinium': ('actinium',),
'actiniumet': ('actinium',),
'actinium': ('actinium',),
'actiniuma': ('actinium',),
'actiniumene': ('actinium',),
'acyl': ('acyl',),
'acylet': ('acyl',),
'acyl': ('acyl',),
'acyla': ('acyl',),
'acylene': ('acyl',),
'adagio': ('adagio',),
'adagioen': ('adagio',),
'adagioer': ('adagio',),
'adagioene': ('adagio',),
'adagio': ('adagio',),
'adagioet': ('adagio',),
'adagio': ('adagio',),
'adagioer': ('adagio',),
'adagio': ('adagio',),
'adagioer': ('adagio',),
'adagioa': ('adagio',),
'adagioene': ('adagio',),
'adam': ('adam',),
'adamen': ('adam',),
'adamer': ('adam',),
'adamene': ('adam',),
'adamsdrakt': ('adamsdrakt',),
'adamsdrakten': ('adamsdrakt',),
'adamsdrakta': ('adamsdrakt',),
'adamsdrakter': ('adamsdrakt',),
'adamsdraktene': ('adamsdrakt',),
'adamseple': ('adamseple',),
'adamseplet': ('adamseple',),
'adamsepler': ('adamseple',),
'adamsepla': ('adamseple',),
'adamseplene': ('adamseple',),
'adamsnatur': ('adamsnatur',),
'adamsnaturen': ('adamsnatur',),
'adamsnaturer': ('adamsnatur',),
'adamsnaturene': ('adamsnatur',),
'adamsslekt': ('adamsslekt',),
'adamsslekten': ('adamsslekt',),
'adamsslekta': ('adamsslekt',),
'adamsslekter': ('adamsslekt',),
'adamsslektene': ('adamsslekt',),
'adapsjon': ('adapsjon',),
'adapsjonen': ('adapsjon',),
'adapsjoner': ('adapsjon',),
'adapsjonene': ('adapsjon',),
'adapsjonsevne': ('adapsjonsevne',),
'adapsjonsevnen': ('adapsjonsevne',),
'adapsjonsevna': ('adapsjonsevne',),
'adapsjonsevner': ('adapsjonsevne',),
'adapsjonsevnene': ('adapsjonsevne',),
'adaptasjon': ('adaptasjon',),
'adaptasjonen': ('adaptasjon',),
'adaptasjoner': ('adaptasjon',),
'adaptasjonene': ('adaptasjon',),
'adapter': ('adapter',),
'adapteren': ('adapter',),
'adaptere': ('adapter',),
'adapterne': ('adapter',),
'adb-operatør': ('adb-operatør',),
'adb-operatøren': ('adb-operatør',),
'adb-operatører': ('adb-operatør',),
'adb-operatørene': ('adb-operatør',),
'addend': ('addend',),
'addenden': ('addend',),
'addender': ('addend',),
'addendene': ('addend',),
'addering': ('addering',),
'adderingen': ('addering',),
'adderinga': ('addering',),
'adderinger': ('addering',),
'adderingene': ('addering',),
'addisjon': ('addisjon',),
'addisjonen': ('addisjon',),
'addisjoner': ('addisjon',),
'addisjonene': ('addisjon',),
'addisjonsfeil': ('addisjonsfeil',),
'addisjonsfeilen': ('addisjonsfeil',),
'addisjonsfeil': ('addisjonsfeil',),
'addisjonsfeila': ('addisjonsfeil',),
'addisjonsfeilene': ('addisjonsfeil',),
'addisjonsoppgave': ('addisjonsoppgave',),
'addisjonsoppgaven': ('addisjonsoppgave',),
'addisjonsoppgava': ('addisjonsoppgave',),
'addisjonsoppgaver': ('addisjonsoppgave',),
'addisjonsoppgavene': ('addisjonsoppgave',),
'addisjonsreaksjon': ('addisjonsreaksjon',),
'addisjonsreaksjonen': ('addisjonsreaksjon',),
'addisjonsreaksjoner': ('addisjonsreaksjon',),
'addisjonsreaksjonene': ('addisjonsreaksjon',),
'addisjonsstykke': ('addisjonsstykke',),
'addisjonsstykket': ('addisjonsstykke',),
'addisjonsstykker': ('addisjonsstykke',),
'addisjonsstykka': ('addisjonsstykke',),
'addisjonsstykkene': ('addisjonsstykke',),
'addisjonstegn': ('addisjonstegn',),
'addisjonstegnet': ('addisjonstegn',),
'addisjonstegn': ('addisjonstegn',),
'addisjonstegna': ('addisjonstegn',),
'addisjonstegnene': ('addisjonstegn',),
'additiv': ('additiv',),
'additivet': ('additiv',),
'additiv': ('additiv',),
'additiver': ('additiv',),
'additiv': ('additiv',),
'additiver': ('additiv',),
'additiva': ('additiv',),
'additivene': ('additiv',),
'adel': ('adel',),
'adelen': ('adel',),
'adler': ('adel',),
'adlene': ('adel',),
'adelsbrev': ('adelsbrev',),
'adelsbrevet': ('adelsbrev',),
'adelsbrev': ('adelsbrev',),
'adelsbrever': ('adelsbrev',),
'adelsbrev': ('adelsbrev',),
'adelsbrever': ('adelsbrev',),
'adelsbreva': ('adelsbrev',),
'adelsbrevene': ('adelsbrev',),
'adelsdiplom': ('adelsdiplom',),
'adelsdiplomet': ('adelsdiplom',),
'adelsdiplom': ('adelsdiplom',),
'adelsdiplomer': ('adelsdiplom',),
'adelsdiplom': ('adelsdiplom',),
'adelsdiplomer': ('adelsdiplom',),
'adelsdiploma': ('adelsdiplom',),
'adelsdiplomene': ('adelsdiplom',),
'adelskalender': ('adelskalender',),
'adelskalenderen': ('adelskalender',),
'adelskalendere': ('adelskalender',),
'adelskalendrer': ('adelskalender',),
'adelskalendre': ('adelskalender',),
'adelskalenderne': ('adelskalender',),
'adelskalendrene': ('adelskalender',),
'adelskap': ('adelskap',),
'adelskapen': ('adelskap',),
'adelskapet': ('adelskap',),
'adelskaper': ('adelskap',),
'adelskap': ('adelskap',),
'adelskapene': ('adelskap',),
'adelskapa': ('adelskap',),
'adelskapene': ('adelskap',),
'adelsmann': ('adelsmann',),
'adelsmannen': ('adelsmann',),
'adelsmenn': ('adelsmann',),
'adelsmennene': ('adelsmann',),
'adelsmerke': ('adelsmerke',),
'adelsmerket': ('adelsmerke',),
'adelsmerker': ('adelsmerke',),
'adelsmerka': ('adelsmerke',),
'adelsmerkene': ('adelsmerke',),
'adelsprivilegium': ('adelsprivilegium',),
'adelsprivilegiet': ('adelsprivilegium',),
'adelsprivilegier': ('adelsprivilegium',),
'adelsprivilegia': ('adelsprivilegium',),
'adelsprivilegiene': ('adelsprivilegium',),
'adelsskjold': ('adelsskjold',),
'adelsskjoldet': ('adelsskjold',),
'adelsskjold': ('adelsskjold',),
'adelsskjolda': ('adelsskjold',),
'adelsskjoldene': ('adelsskjold',),
'adelsslekt': ('adelsslekt',),
'adelsslekten': ('adelsslekt',),
'adelsslekta': ('adelsslekt',),
'adelsslekter': ('adelsslekt',),
'adelsslektene': ('adelsslekt',),
'adelsstand': ('adelsstand',),
'adelsstanden': ('adelsstand',),
'adelsstander': ('adelsstand',),
'adelsstandene': ('adelsstand',),
'adelstittel': ('adelstittel',),
'adelstittelen': ('adelstittel',),
'adelstitler': ('adelstittel',),
'adelstitlene': ('adelstittel',),
'adelsætt': ('adelsætt',),
'adelsætten': ('adelsætt',),
'adelsætta': ('adelsætt',),
'adelsætter': ('adelsætt',),
'adelsættene': ('adelsætt',),
'adenitt': ('adenitt',),
'adenitten': ('adenitt',),
'adenitter': ('adenitt',),
'adenittene': ('adenitt',),
'adept': ('adept',),
'adepten': ('adept',),
'adepter': ('adept',),
'adeptene': ('adept',),
'adgang': ('adgang',),
'adgangen': ('adgang',),
'adganger': ('adgang',),
'adgangene': ('adgang',),
'adgangsbillett': ('adgangsbillett',),
'adgangsbilletten': ('adgangsbillett',),
'adgangsbilletter': ('adgangsbillett',),
'adgangsbillettene': ('adgangsbillett',),
'adgangskort': ('adgangskort',),
'adgangskortet': ('adgangskort',),
'adgangskort': ('adgangskort',),
'adgangskorta': ('adgangskort',),
'adgangskortene': ('adgangskort',),
'adgangstegn': ('adgangstegn',),
'adgangstegnet': ('adgangstegn',),
'adgangstegn': ('adgangstegn',),
'adgangstegna': ('adgangstegn',),
'adgangstegnene': ('adgangstegn',),
'adherens': ('adherens',),
'adherensen': ('adherens',),
'adherenser': ('adherens',),
'adherensene': ('adherens',),
'adhesjon': ('adhesjon',),
'adhesjonen': ('adhesjon',),
'adhesjoner': ('adhesjon',),
'adhesjonene': ('adhesjon',),
'adiaforon': ('adiaforon',),
'adiaforonet': ('adiaforon',),
'adiafora': ('adiaforon',),
'adiaforaene': ('adiaforon',),
'adjektiv': ('adjektiv',),
'adjektivet': ('adjektiv',),
'adjektiv': ('adjektiv',),
'adjektiver': ('adjektiv',),
'adjektiv': ('adjektiv',),
'adjektiver': ('adjektiv',),
'adjektiva': ('adjektiv',),
'adjektivene': ('adjektiv',),
'adjunkt': ('adjunkt',),
'adjunkten': ('adjunkt',),
'adjunkter': ('adjunkt',),
'adjunktene': ('adjunkt',),
'adjunkteksamen': ('adjunkteksamen',),
'adjunkteksamenen': ('adjunkteksamen',),
'adjunkteksamener': ('adjunkteksamen',),
'adjunkteksamenene': ('adjunkteksamen',),
'adjunktkompetanse': ('adjunktkompetanse',),
'adjunktkompetansen': ('adjunktkompetanse',),
'adjunktkompetanser': ('adjunktkompetanse',),
'adjunktkompetansene': ('adjunktkompetanse',),
'adjutant': ('adjutant',),
'adjutanten': ('adjutant',),
'adjutanter': ('adjutant',),
'adjutantene': ('adjutant',),
'adjutantstab': ('adjutantstab',),
'adjutantstaben': ('adjutantstab',),
'adjutantstaber': ('adjutantstab',),
'adjutantstabene': ('adjutantstab',),
'adjutantur': ('adjutantur',),
'adjutanturen': ('adjutantur',),
'adjutanturer': ('adjutantur',),
'adjutanturene': ('adjutantur',),
'adjø': ('adjø',),
'adjøet': ('adjø',),
'adjø': ('adjø',),
'adjøer': ('adjø',),
'adjø': ('adjø',),
'adjøer': ('adjø',),
'adjøa': ('adjø',),
'adjøene': ('adjø',),
'administrasjon': ('administrasjon',),
'administrasjonen': ('administrasjon',),
'administrasjoner': ('administrasjon',),
'administrasjonene': ('administrasjon',),
'administrasjonsbygning': ('administrasjonsbygning',),
'administrasjonsbygningen': ('administrasjonsbygning',),
'administrasjonsbygninga': ('administrasjonsbygning',),
'administrasjonsbygninger': ('administrasjonsbygning',),
'administrasjonsbygningene': ('administrasjonsbygning',),
'administrasjonssekretær': ('administrasjonssekretær',),
'administrasjonssekretæren': ('administrasjonssekretær',),
'administrasjonssekretærer': ('administrasjonssekretær',),
'administrasjonssekretærene': ('administrasjonssekretær',),
'administrasjonsstyre': ('administrasjonsstyre',),
'administrasjonsstyret': ('administrasjonsstyre',),
'administrasjonsstyrer': ('administrasjonsstyre',),
'administrasjonsstyra': ('administrasjonsstyre',),
'administrasjonsstyrene': ('administrasjonsstyre',),
'administrasjonstalent': ('administrasjonstalent',),
'administrasjonstalentet': ('administrasjonstalent',),
'administrasjonstalent': ('administrasjonstalent',),
'administrasjonstalenta': ('administrasjonstalent',),
'administrasjonstalentene': ('administrasjonstalent',),
'administrasjonsutgift': ('administrasjonsutgift',),
'administrasjonsutgiften': ('administrasjonsutgift',),
'administrasjonsutgifta': ('administrasjonsutgift',),
'administrasjonsutgifter': ('administrasjonsutgift',),
'administrasjonsutgiftene': ('administrasjonsutgift',),
'administrator': ('administrator',),
'administratoren': ('administrator',),
'administratorer': ('administrator',),
'administratorene': ('administrator',),
'admiral': ('admiral',),
'admiralen': ('admiral',),
'admiraler': ('admiral',),
'admiralene': ('admiral',),
'admiralflagg': ('admiralflagg',),
'admiralflagget': ('admiralflagg',),
'admiralflagg': ('admiralflagg',),
'admiralflagga': ('admiralflagg',),
'admiralflaggene': ('admiralflagg',),
'admiralitet': ('admiralitet',),
'admiralitetet': ('admiralitet',),
'admiralitet': ('admiralitet',),
'admiraliteta': ('admiralitet',),
'admiralitetene': ('admiralitet',),
'admiralsflagg': ('admiralsflagg',),
'admiralsflagget': ('admiralsflagg',),
'admiralsflagg': ('admiralsflagg',),
'admiralsflagga': ('admiralsflagg',),
'admiralsflaggene': ('admiralsflagg',),
'admiralskip': ('admiralskip',),
'admiralskipet': ('admiralskip',),
'admiralskip': ('admiralskip',),
'admiralskipa': ('admiralskip',),
'admiralskipene': ('admiralskip',),
'admiralsskip': ('admiralsskip',),
'admiralsskipet': ('admiralsskip',),
'admiralsskip': ('admiralsskip',),
'admiralsskipa': ('admiralsskip',),
'admiralsskipene': ('admiralsskip',),
'admiralsstab': ('admiralsstab',),
'admiralsstaben': ('admiralsstab',),
'admiralsstaber': ('admiralsstab',),
'admiralsstabene': ('admiralsstab',),
'admiralstab': ('admiralstab',),
'admiralstaben': ('admiralstab',),
'admiralstaber': ('admiralstab',),
'admiralstabene': ('admiralstab',),
'adonis': ('adonis',),
'adonisen': ('adonis',),
'adoniser': ('adonis',),
'adonisene': ('adonis',),
'adopsjon': ('adopsjon',),
'adopsjonen': ('adopsjon',),
'adopsjoner': ('adopsjon',),
'adopsjonene': ('adopsjon',),
'adopsjonskontor': ('adopsjonskontor',),
'adopsjonskontoret': ('adopsjonskontor',),
'adopsjonskontor': ('adopsjonskontor',),
'adopsjonskontorer': ('adopsjonskontor',),
'adopsjonskontor': ('adopsjonskontor',),
'adopsjonskontorer': ('adopsjonskontor',),
'adopsjonskontora': ('adopsjonskontor',),
'adopsjonskontorene': ('adopsjonskontor',),
'adopsjonstillatelse': ('adopsjonstillatelse',),
'adopsjonstillatelsen': ('adopsjonstillatelse',),
'adopsjonstillatelser': ('adopsjonstillatelse',),
'adopsjonstillatelsene': ('adopsjonstillatelse',),
'adoptant': ('adoptant',),
'adoptanten': ('adoptant',),
'adoptanter': ('adoptant',),
'adoptantene': ('adoptant',),
'adoptivbarn': ('adoptivbarn',),
'adoptivbarnet': ('adoptivbarn',),
'adoptivbarn': ('adoptivbarn',),
'adoptivbarna': ('adoptivbarn',),
'adoptivbarnene': ('adoptivbarn',),
'adrenalin': ('adrenalin',),
'adrenalinet': ('adrenalin',),
'adrenalin': ('adrenalin',),
'adrenalina': ('adrenalin',),
'adrenalinene': ('adrenalin',),
'adressant': ('adressant',),
'adressanten': ('adressant',),
'adressanter': ('adressant',),
'adressantene': ('adressant',),
'adressat': ('adressat',),
'adressaten': ('adressat',),
'adressater': ('adressat',),
'adressatene': ('adressat',),
'adresse': ('adresse',),
'adressen': ('adresse',),
'adressa': ('adresse',),
'adresser': ('adresse',),
'adressene': ('adresse',),
'adresseavis': ('adresseavis',),
'adresseavisen': ('adresseavis',),
'adresseavisa': ('adresseavis',),
'adresseaviser': ('adresseavis',),
'adresseavisene': ('adresseavis',),
'adresseforandring': ('adresseforandring',),
'adresseforandringen': ('adresseforandring',),
'adresseforandringa': ('adresseforandring',),
'adresseforandringer': ('adresseforandring',),
'adresseforandringene': ('adresseforandring',),
'adressekalender': ('adressekalender',),
'adressekalenderen': ('adressekalender',),
'adressekalendere': ('adressekalender',),
'adressekalendrer': ('adressekalender',),
'adressekalendre': ('adressekalender',),
'adressekalenderne': ('adressekalender',),
'adressekalendrene': ('adressekalender',),
'adressekort': ('adressekort',),
'adressekortet': ('adressekort',),
'adressekort': ('adressekort',),
'adressekorta': ('adressekort',),
'adressekortene': ('adressekort',),
'adressemegler': ('adressemegler',),
'adressemegleren': ('adressemegler',),
'adressemeglere': ('adressemegler',),
'adressemeglerne': ('adressemegler',),
'adressemegling': ('adressemegling',),
'adressemeglingen': ('adressemegling',),
'adressemeglinga': ('adressemegling',),
'adressemeglinger': ('adressemegling',),
'adressemeglingene': ('adressemegling',),
'adressemekler': ('adressemekler',),
'adressemekleren': ('adressemekler',),
'adressemeklere': ('adressemekler',),
'adressemeklerne': ('adressemekler',),
'adressemekling': ('adressemekling',),
'adressemeklingen': ('adressemekling',),
'adressemeklinga': ('adressemekling',),
'adressemeklinger': ('adressemekling',),
'adressemeklingene': ('adressemekling',),
'adresseringsmaskin': ('adresseringsmaskin',),
'adresseringsmaskinen': ('adresseringsmaskin',),
'adresseringsmaskiner': ('adresseringsmaskin',),
'adresseringsmaskinene': ('adresseringsmaskin',),
'adsorpsjon': ('adsorpsjon',),
'adsorpsjonen': ('adsorpsjon',),
'adsorpsjoner': ('adsorpsjon',),
'adsorpsjonene': ('adsorpsjon',),
'advarsel': ('advarsel',),
'advarselen': ('advarsel',),
'advarsler': ('advarsel',),
'advarslene': ('advarsel',),
'advent': ('advent',),
'adventen': ('advent',),
'adventer': ('advent',),
'adventene': ('advent',),
'adventist': ('adventist',),
'adventisten': ('adventist',),
'adventister': ('adventist',),
'adventistene': ('adventist',),
'adventskalender': ('adventskalender',),
'adventskalenderen': ('adventskalender',),
'adventskalendere': ('adventskalender',),
'adventskalendrer': ('adventskalender',),
'adventskalendre': ('adventskalender',),
'adventskalenderne': ('adventskalender',),
'adventskalendrene': ('adventskalender',),
'adventsstake': ('adventsstake',),
'adventsstaken': ('adventsstake',),
'adventsstaker': ('adventsstake',),
'adventsstakene': ('adventsstake',),
'adventssøndag': ('adventssøndag',),
'adventssøndagen': ('adventssøndag',),
'adventssøndager': ('adventssøndag',),
'adventssøndagene': ('adventssøndag',),
'adventstid': ('adventstid',),
'adventstiden': ('adventstid',),
'adventstida': ('adventstid',),
'adventstider': ('adventstid',),
'adventstidene': ('adventstid',),
'adverb': ('adverb',),
'adverbet': ('adverb',),
'adverb': ('adverb',),
'adverber': ('adverb',),
'adverb': ('adverb',),
'adverber': ('adverb',),
'adverba': ('adverb',),
'adverbene': ('adverb',),
'adverbial': ('adverbial',),
'adverbialet': ('adverbial',),
'adverbial': ('adverbial',),
'adverbialer': ('adverbial',),
'adverbial': ('adverbial',),
'adverbialer': ('adverbial',),
'adverbiala': ('adverbial',),
'adverbialene': ('adverbial',),
'adverbium': ('adverbium',),
'adverbiet': ('adverbium',),
'adverbier': ('adverbium',),
'adverbia': ('adverbium',),
'adverbiene': ('adverbium',),
'advis': ('advis',),
'advisen': ('advis',),
'advis': ('advis',),
'advisene': ('advis',),
'advokat': ('advokat',),
'advokaten': ('advokat',),
'advokater': ('advokat',),
'advokatene': ('advokat',),
'advokatbevilling': ('advokatbevilling',),
'advokatbevillingen': ('advokatbevilling',),
'advokatbevillinger': ('advokatbevilling',),
'advokatbevillingene': ('advokatbevilling',),
'advokatfirma': ('advokatfirma',),
'advokatfirmaet': ('advokatfirma',),
'advokatfirma': ('advokatfirma',),
'advokatfirmaer': ('advokatfirma',),
'advokatfirmaene': ('advokatfirma',),
'advokatur': ('advokatur',),
'advokaturen': ('advokatur',),
'advokaturer': ('advokatur',),
'advokaturene': ('advokatur',),
'aerobic': ('aerobic',),
'aerobicen': ('aerobic',),
'aerobicer': ('aerobic',),
'aerobicene': ('aerobic',),
'aerodrom': ('aerodrom',),
'aerodromen': ('aerodrom',),
'aerodromer': ('aerodrom',),
'aerodromene': ('aerodrom',),
'aerodynamikk': ('aerodynamikk',),
'aerodynamikken': ('aerodynamikk',),
'aerodynamikker': ('aerodynamikk',),
'aerodynamikkene': ('aerodynamikk',),
'aerogram': ('aerogram',),
'aerogrammet': ('aerogram',),
'aerogram': ('aerogram',),
'aerogrammer': ('aerogram',),
'aerogramma': ('aerogram',),
'aerogrammene': ('aerogram',),
'aerogramma': ('aerogram',),
'aerogrammene': ('aerogram',),
'aeroklubb': ('aeroklubb',),
'aeroklubben': ('aeroklubb',),
'aeroklubber': ('aeroklubb',),
'aeroklubbene': ('aeroklubb',),
'aerolitt': ('aerolitt',),
'aerolitten': ('aerolitt',),
'aerolitter': ('aerolitt',),
'aerolittene': ('aerolitt',),
'aerologi': ('aerologi',),
'aerologien': ('aerologi',),
'aerologier': ('aerologi',),
'aerologiene': ('aerologi',),
'aeronaut': ('aeronaut',),
'aeronauten': ('aeronaut',),
'aeronauter': ('aeronaut',),
'aeronautene': ('aeronaut',),
'aeroplan': ('aeroplan',),
'aeroplanet': ('aeroplan',),
'aeroplan': ('aeroplan',),
'aeroplaner': ('aeroplan',),
'aeroplan': ('aeroplan',),
'aeroplaner': ('aeroplan',),
'aeroplana': ('aeroplan',),
'aeroplanene': ('aeroplan',),
'aerosol': ('aerosol',),
'aerosolen': ('aerosol',),
'aerosoler': ('aerosol',),
'aerosolene': ('aerosol',),
'aerosolboks': ('aerosolboks',),
'aerosolboksen': ('aerosolboks',),
'aerosolbokser': ('aerosolboks',),
'aerosolboksene': ('aerosolboks',),
'afasi': ('afasi',),
'afasien': ('afasi',),
'afasier': ('afasi',),
'afasiene': ('afasi',),
'afatiker': ('afatiker',),
'afatikeren': ('afatiker',),
'afatikere': ('afatiker',),
'afatikerne': ('afatiker',),
'affeksjon': ('affeksjon',),
'affeksjonen': ('affeksjon',),
'affeksjoner': ('affeksjon',),
'affeksjonene': ('affeksjon',),
'affeksjonsverdi': ('affeksjonsverdi',),
'affeksjonsverdien': ('affeksjonsverdi',),
'affeksjonsverdier': ('affeksjonsverdi',),
'affeksjonsverdiene': ('affeksjonsverdi',),
'affekt': ('affekt',),
'affekten': ('affekt',),
'affekter': ('affekt',),
'affektene': ('affekt',),
'affektasjon': ('affektasjon',),
'affektasjonen': ('affektasjon',),
'affektasjoner': ('affektasjon',),
'affektasjonene': ('affektasjon',),
'affiks': ('affiks',),
'affikset': ('affiks',),
'affiks': ('affiks',),
'affikser': ('affiks',),
'affiks': ('affiks',),
'affikser': ('affiks',),
'affiksa': ('affiks',),
'affiksene': ('affiks',),
'affinitet': ('affinitet',),
'affiniteten': ('affinitet',),
'affiniteter': ('affinitet',),
'affinitetene': ('affinitet',),
'affrikat': ('affrikat',),
'affrikaten': ('affrikat',),
'affrikater': ('affrikat',),
'affrikatene': ('affrikat',),
'affutasje': ('affutasje',),
'affutasjen': ('affutasje',),
'affutasjer': ('affutasje',),
'affutasjene': ('affutasje',),
'affære': ('affære',),
'affæren': ('affære',),
'affærer': ('affære',),
'affærene': ('affære',),
'afghaner': ('afghaner',),
'afghaneren': ('afghaner',),
'afghanere': ('afghaner',),
'afghanerne': ('afghaner',),
'afghani': ('afghani',),
'afghanien': ('afghani',),
'afghani': ('afghani',),
'afghaniene': ('afghani',),
'aforisme': ('aforisme',),
'aforismen': ('aforisme',),
'aforismer': ('aforisme',),
'aforismene': ('aforisme',),
'afrikaans': ('afrikaans',),
'afrikaansen': ('afrikaans',),
'afrikaanser': ('afrikaans',),
'afrikaansene': ('afrikaans',),
'afrikander': ('afrikander',),
'afrikanderen': ('afrikander',),
'afrikandere': ('afrikander',),
'afrikanderne': ('afrikander',),
'afrikaner': ('afrikaner',),
'afrikaneren': ('afrikaner',),
'afrikanere': ('afrikaner',),
'afrikanerne': ('afrikaner',),
'afroamerikaner': ('afroamerikaner',),
'afroamerikaneren': ('afroamerikaner',),
'afroamerikanere': ('afroamerikaner',),
'afroamerikanerne': ('afroamerikaner',),
'afrodisi': ('afrodisi',),
'afrodisien': ('afrodisi',),
'afrodisier': ('afrodisi',),
'afrodisiene': ('afrodisi',),
'afroditt': ('afroditt',),
'afroditten': ('afroditt',),
'afroditter': ('afroditt',),
'afrodittene': ('afroditt',),
'afrofrisyre': ('afrofrisyre',),
'afrofrisyren': ('afrofrisyre',),
'afrofrisyrer': ('afrofrisyre',),
'afrofrisyrene': ('afrofrisyre',),
'aften': ('aften',),
'aftenen': ('aften',),
'aftener': ('aften',),
'aftenene': ('aften',),
'aftenantrekk': ('aftenantrekk',),
'aftenantrekket': ('aftenantrekk',),
'aftenantrekk': ('aftenantrekk',),
'aftenantrekka': ('aftenantrekk',),
'aftenantrekkene': ('aftenantrekk',),
'aftenavis': ('aftenavis',),
'aftenavisen': ('aftenavis',),
'aftenavisa': ('aftenavis',),
'aftenaviser': ('aftenavis',),
'aftenavisene': ('aftenavis',),
'aftenbruk': ('aftenbruk',),
'aftenbruken': ('aftenbruk',),
'aftenbruket': ('aftenbruk',),
'aftenbruker': ('aftenbruk',),
'aftenbruk': ('aftenbruk',),
'aftenbrukene': ('aftenbruk',),
'aftenbruka': ('aftenbruk',),
'aftenbrukene': ('aftenbruk',),
'aftenbønn': ('aftenbønn',),
'aftenbønnen': ('aftenbønn',),
'aftenbønna': ('aftenbønn',),
'aftenbønner': ('aftenbønn',),
'aftenbønnene': ('aftenbønn',),
'aftennummer': ('aftennummer',),
'aftennummeret': ('aftennummer',),
'aftennummer': ('aftennummer',),
'aftennumre': ('aftennummer',),
'aftennumra': ('aftennummer',),
'aftennumrene': ('aftennummer',),
'aftennumra': ('aftennummer',),
'aftennumrene': ('aftennummer',),
'aftenrøde': ('aftenrøde',),
'aftenrøden': ('aftenrøde',),
'aftenrøder': ('aftenrøde',),
'aftenrødene': ('aftenrøde',),
'aftens': ('aftens',),
'aftensang': ('aftensang',),
'aftensangen': ('aftensang',),
'aftensanger': ('aftensang',),
'aftensangene': ('aftensang',),
'aftensbord': ('aftensbord',),
'aftensbordet': ('aftensbord',),
'aftensbord': ('aftensbord',),
'aftensborder': ('aftensbord',),
'aftensbord': ('aftensbord',),
'aftensborder': ('aftensbord',),
'aftensborda': ('aftensbord',),
'aftensbordene': ('aftensbord',),
'aftenskumring': ('aftenskumring',),
'aftenskumringen': ('aftenskumring',),
'aftenskumringa': ('aftenskumring',),
'aftenskumringer': ('aftenskumring',),
'aftenskumringene': ('aftenskumring',),
'aftensmat': ('aftensmat',),
'aftensmaten': ('aftensmat',),
'aftensmater': ('aftensmat',),
'aftensmatene': ('aftensmat',),
'aftenstemning': ('aftenstemning',),
'aftenstemningen': ('aftenstemning',),
'aftenstemninga': ('aftenstemning',),
'aftenstemninger': ('aftenstemning',),
'aftenstemningene': ('aftenstemning',),
'aftenstjerne': ('aftenstjerne',),
'aftenstjernen': ('aftenstjerne',),
'aftenstjerna': ('aftenstjerne',),
'aftenstjerner': ('aftenstjerne',),
'aftenstjernene': ('aftenstjerne',),
'aftentrekning': ('aftentrekning',),
'aftentrekningen': ('aftentrekning',),
'aftentrekninga': ('aftentrekning',),
'aftentrekninger': ('aftentrekning',),
'aftentrekningene': ('aftentrekning',),
'aftentur': ('aftentur',),
'aftenturen': ('aftentur',),
'aftenturer': ('aftentur',),
'aftenturene': ('aftentur',),
'agape': ('agape',),
'agapen': ('agape',),
'agaper': ('agape',),
'agapene': ('agape',),
'agat': ('agat',),
'agaten': ('agat',),
'agater': ('agat',),
'agatene': ('agat',),
'agatring': ('agatring',),
'agatringen': ('agatring',),
'agatringer': ('agatring',),
'agatringene': ('agatring',),
'agatstein': ('agatstein',),
'agatsteinen': ('agatstein',),
'agatsteiner': ('agatstein',),
'agatsteinene': ('agatstein',),
'age': ('age',),
'agen': ('age',),
'ager': ('age',),
'agene': ('age',),
'agenda': ('agenda',),
'agendaen': ('agenda',),
'agendaer': ('agenda',),
'agendaene': ('agenda',),
'agende': ('agende',),
'agenden': ('agende',),
'agender': ('agende',),
'agendene': ('agende',),
'agens': ('agens',),
'agensen': ('agens',),
'agenset': ('agens',),
'agenser': ('agens',),
'agens': ('agens',),
'agenser': ('agens',),
'agens': ('agens',),
'agenser': ('agens',),
'agensene': ('agens',),
'agensa': ('agens',),
'agensene': ('agens',),
'agensledd': ('agensledd',),
'agensleddet': ('agensledd',),
'agensledd': ('agensledd',),
'agensledda': ('agensledd',),
'agensleddene': ('agensledd',),
'agent': ('agent',),
'agenten': ('agent',),
'agenter': ('agent',),
'agentene': ('agent',),
'agentfilm': ('agentfilm',),
'agentfilmen': ('agentfilm',),
'agentfilmer': ('agentfilm',),
'agentfilmene': ('agentfilm',),
'agentprovisjon': ('agentprovisjon',),
'agentprovisjonen': ('agentprovisjon',),
'agentprovisjoner': ('agentprovisjon',),
'agentprovisjonene': ('agentprovisjon',),
'agentroman': ('agentroman',),
'agentromanen': ('agentroman',),
'agentromaner': ('agentroman',),
'agentromanene': ('agentroman',),
'agentur': ('agentur',),
'agenturet': ('agentur',),
'agentur': ('agentur',),
'agenturer': ('agentur',),
'agentur': ('agentur',),
'agenturer': ('agentur',),
'agentura': ('agentur',),
'agenturene': ('agentur',),
'agenturfirma': ('agenturfirma',),
'agenturfirmaet': ('agenturfirma',),
'agenturfirma': ('agenturfirma',),
'agenturfirmaer': ('agenturfirma',),
'agenturfirmaene': ('agenturfirma',),
'agenturforretning': ('agenturforretning',),
'agenturforretningen': ('agenturforretning',),
'agenturforretninga': ('agenturforretning',),
'agenturforretninger': ('agenturforretning',),
'agenturforretningene': ('agenturforretning',),
'agg': ('agg',),
'agget': ('agg',),
'agg': ('agg',),
'agga': ('agg',),
'aggene': ('agg',),
'agglutinasjon': ('agglutinasjon',),
'agglutinasjonen': ('agglutinasjon',),
'agglutinasjoner': ('agglutinasjon',),
'agglutinasjonene': ('agglutinasjon',),
'agglutinering': ('agglutinering',),
'agglutineringen': ('agglutinering',),
'agglutineringa': ('agglutinering',),
'agglutineringer': ('agglutinering',),
'agglutineringene': ('agglutinering',),
'aggregat': ('aggregat',),
'aggregatet': ('aggregat',),
'aggregat': ('aggregat',),
'aggregater': ('aggregat',),
'aggregat': ('aggregat',),
'aggregater': ('aggregat',),
'aggregata': ('aggregat',),
'aggregatene': ('aggregat',),
'aggregatform': ('aggregatform',),
'aggregatformen': ('aggregatform',),
'aggregatforma': ('aggregatform',),
'aggregatformer': ('aggregatform',),
'aggregatformene': ('aggregatform',),
'aggregattilstand': ('aggregattilstand',),
'aggregattilstanden': ('aggregattilstand',),
'aggregattilstander': ('aggregattilstand',),
'aggregattilstandene': ('aggregattilstand',),
'aggresjon': ('aggresjon',),
'aggresjonen': ('aggresjon',),
'aggresjoner': ('aggresjon',),
'aggresjonene': ('aggresjon',),
'aggressivitet': ('aggressivitet',),
'aggressiviteten': ('aggressivitet',),
'aggressiviteter': ('aggressivitet',),
'aggressivitetene': ('aggressivitet',),
'agio': ('agio',),
'agioen': ('agio',),
'agioer': ('agio',),
'agioene': ('agio',),
'agiotap': ('agiotap',),
'agiotapet': ('agiotap',),
'agiotap': ('agiotap',),
'agiotapa': ('agiotap',),
'agiotapene': ('agiotap',),
'agiovinning': ('agiovinning',),
'agiovinningen': ('agiovinning',),
'agiovinninga': ('agiovinning',),
'agiovinninger': ('agiovinning',),
'agiovinningene': ('agiovinning',),
'agitasjon': ('agitasjon',),
'agitasjonen': ('agitasjon',),
'agitasjoner': ('agitasjon',),
'agitasjonene': ('agitasjon',),
'agitator': ('agitator',),
'agitatoren': ('agitator',),
'agitatorer': ('agitator',),
'agitatorene': ('agitator',),
'agn': ('agn',),
'agnet': ('agn',),
'agn': ('agn',),
'agna': ('agn',),
'agnene': ('agn',),
'agn': ('agn',),
'agnen': ('agn',),
'agna': ('agn',),
'agner': ('agn',),
'agnene': ('agn',),
'agnat': ('agnat',),
'agnaten': ('agnat',),
'agnater': ('agnat',),
'agnatene': ('agnat',),
'agnfisk': ('agnfisk',),
'agnfisken': ('agnfisk',),
'agnfisker': ('agnfisk',),
'agnfiskene': ('agnfisk',),
'agnmakk': ('agnmakk',),
'agnmakken': ('agnmakk',),
'agnmakker': ('agnmakk',),
'agnmakkene': ('agnmakk',),
'agnmark': ('agnmark',),
'agnmarken': ('agnmark',),
'agnmarker': ('agnmark',),
'agnmarkene': ('agnmark',),
'agnor': ('agnor',),
'agnoren': ('agnor',),
'agnora': ('agnor',),
'agnorer': ('agnor',),
'agnorene': ('agnor',),
'agnostiker': ('agnostiker',),
'agnostikeren': ('agnostiker',),
'agnostikere': ('agnostiker',),
'agnostikerne': ('agnostiker',),
'agnostisisme': ('agnostisisme',),
'agnostisismen': ('agnostisisme',),
'agnostisismer': ('agnostisisme',),
'agnostisismene': ('agnostisisme',),
'agnsild': ('agnsild',),
'agnsilden': ('agnsild',),
'agnsilda': ('agnsild',),
'agnsilder': ('agnsild',),
'agnsild': ('agnsild',),
'agnsilder': ('agnsild',),
'agnsild': ('agnsild',),
'agnsildene': ('agnsild',),
'agnus Dei': ('agnus Dei',),
'agoni': ('agoni',),
'agonien': ('agoni',),
'agonier': ('agoni',),
'agoniene': ('agoni',),
'agorafobi': ('agorafobi',),
'agorafobien': ('agorafobi',),
'agorafobier': ('agorafobi',),
'agorafobiene': ('agorafobi',),
'agraff': ('agraff',),
'agraffen': ('agraff',),
'agraffer': ('agraff',),
'agraffene': ('agraff',),
'agrafi': ('agrafi',),
'agrafien': ('agrafi',),
'agrafier': ('agrafi',),
'agrafiene': ('agrafi',),
'agrar': ('agrar',),
'agraren': ('agrar',),
'agrarer': ('agrar',),
'agrarene': ('agrar',),
'agrarparti': ('agrarparti',),
'agrarpartiet': ('agrarparti',),
'agrarparti': ('agrarparti',),
'agrarpartier': ('agrarparti',),
'agrarparti': ('agrarparti',),
'agrarpartier': ('agrarparti',),
'agrarpartia': ('agrarparti',),
'agrarpartiene': ('agrarparti',),
'agrarpolitikk': ('agrarpolitikk',),
'agrarpolitikken': ('agrarpolitikk',),
'agrarpolitikker': ('agrarpolitikk',),
'agrarpolitikkene': ('agrarpolitikk',),
'agreement': ('agreement',),
'agrement': ('agrement',),
'agrementet': ('agrement',),
'agrement': ('agrement',),
'agrementer': ('agrement',),
'agrement': ('agrement',),
'agrementer': ('agrement',),
'agrementa': ('agrement',),
'agrementene': ('agrement',),
'agrikultur': ('agrikultur',),
'agrikulturen': ('agrikultur',),
'agrikulturer': ('agrikultur',),
'agrikulturene': ('agrikultur',),
'agronom': ('agronom',),
'agronomen': ('agronom',),
'agronomer': ('agronom',),
'agronomene': ('agronom',),
'agronomi': ('agronomi',),
'agronomien': ('agronomi',),
'agronomier': ('agronomi',),
'agronomiene': ('agronomi',),
'agrotekniker': ('agrotekniker',),
'agroteknikeren': ('agrotekniker',),
'agroteknikere': ('agrotekniker',),
'agroteknikerne': ('agrotekniker',),
'agurk': ('agurk',),
'agurken': ('agurk',),
'agurker': ('agurk',),
'agurkene': ('agurk',),
'agurksalat': ('agurksalat',),
'agurksalaten': ('agurksalat',),
'agurksalater': ('agurksalat',),
'agurksalatene': ('agurksalat',),
'agurktid': ('agurktid',),
'agurktiden': ('agurktid',),
'agurktida': ('agurktid',),
'agurktider': ('agurktid',),
'agurktidene': ('agurktid',),
'aha-opplevelse': ('aha-opplevelse',),
'aha-opplevelsen': ('aha-opplevelse',),
'aha-opplevelser': ('aha-opplevelse',),
'aha-opplevelsene': ('aha-opplevelse',),
'aids': ('aids',),
'aidsen': ('aids',),
'aidser': ('aids',),
'aidsene': ('aids',),
'aidssmitte': ('aidssmitte',),
'aidssmitten': ('aidssmitte',),
'aidssmitter': ('aidssmitte',),
'aidssmittene': ('aidssmitte',),
'aigu': ('aigu',),
'aiguen': ('aigu',),
'aiguer': ('aigu',),
'aiguene': ('aigu',),
'aino': ('aino',),
'ainoen': ('aino',),
'ainoer': ('aino',),
'ainoene': ('aino',),
'aino': ('aino',),
'air': ('air',),
'airen': ('air',),
'airer': ('air',),
'airene': ('air',),
'airbag': ('airbag',),
'airbagen': ('airbag',),
'airbager': ('airbag',),
'airbagene': ('airbag',),
'aiss': ('aiss',),
'aissen': ('aiss',),
'aisser': ('aiss',),
'aissene': ('aiss',),
'akademi': ('akademi',),
'akademiet': ('akademi',),
'akademi': ('akademi',),
'akademier': ('akademi',),
'akademi': ('akademi',),
'akademier': ('akademi',),
'akademia': ('akademi',),
'akademiene': ('akademi',),
'akademiker': ('akademiker',),
'akademikeren': ('akademiker',),
'akademikere': ('akademiker',),
'akademikerne': ('akademiker',),
'akademisme': ('akademisme',),
'akademismen': ('akademisme',),
'akademismer': ('akademisme',),
'akademismene': ('akademisme',),
'akantus': ('akantus',),
'akantusen': ('akantus',),
'akantuser': ('akantus',),
'akantusene': ('akantus',),
'akantusblad': ('akantusblad',),
'akantusbladet': ('akantusblad',),
'akantusblad': ('akantusblad',),
'akantusblader': ('akantusblad',),
'akantusblad': ('akantusblad',),
'akantusblader': ('akantusblad',),
'akantusblada': ('akantusblad',),
'akantusbladene': ('akantusblad',),
'akantusornament': ('akantusornament',),
'akantusornamentet': ('akantusornament',),
'akantusornament': ('akantusornament',),
'akantusornamenter': ('akantusornament',),
'akantusornament': ('akantusornament',),
'akantusornamenter': ('akantusornament',),
'akantusornamenta': ('akantusornament',),
'akantusornamentene': ('akantusornament',),
'akantusplante': ('akantusplante',),
'akantusplanten': ('akantusplante',),
'akantusplanta': ('akantusplante',),
'akantusplanter': ('akantusplante',),
'akantusplantene': ('akantusplante',),
'akantusranke': ('akantusranke',),
'akantusranken': ('akantusranke',),
'akantusranker': ('akantusranke',),
'akantusrankene': ('akantusranke',),
'akasie': ('akasie',),
'akasien': ('akasie',),
'akasier': ('akasie',),
'akasiene': ('akasie',),
'akebakke': ('akebakke',),
'akebakken': ('akebakke',),
'akebakker': ('akebakke',),
'akebakkene': ('akebakke',),
'akebrett': ('akebrett',),
'akebrettet': ('akebrett',),
'akebrett': ('akebrett',),
'akebretter': ('akebrett',),
'akebrett': ('akebrett',),
'akebretter': ('akebrett',),
'akebretta': ('akebrett',),
'akebrettene': ('akebrett',),
'akeføre': ('akeføre',),
'akeføret': ('akeføre',),
'akefører': ('akeføre',),
'akeføra': ('akeføre',),
'akeførene': ('akeføre',),
'akekonkurranse': ('akekonkurranse',),
'akekonkurransen': ('akekonkurranse',),
'akekonkurranser': ('akekonkurranse',),
'akekonkurransene': ('akekonkurranse',),
'akeleie': ('akeleie',),
'akeleien': ('akeleie',),
'akeleia': ('akeleie',),
'akeleier': ('akeleie',),
'akeleiene': ('akeleie',),
'aketur': ('aketur',),
'aketuren': ('aketur',),
'aketurer': ('aketur',),
'aketurene': ('aketur',),
'akevitt': ('akevitt',),
'akevitten': ('akevitt',),
'akevitter': ('akevitt',),
'akevittene': ('akevitt',),
'akevitter': ('akevitter',),
'akevitteren': ('akevitter',),
'akevittere': ('akevitter',),
'akevitterne': ('akevitter',),
'akilleshæl': ('akilleshæl',),
'akilleshælen': ('akilleshæl',),
'akilleshæler': ('akilleshæl',),
'akilleshælene': ('akilleshæl',),
'akillessene': ('akillessene',),
'akillessenen': ('akillessene',),
'akillessena': ('akillessene',),
'akillessener': ('akillessene',),
'akillessenene': ('akillessene',),
'akk': ('akk',),
'akket': ('akk',),
'akk': ('akk',),
'akka': ('akk',),
'akkene': ('akk',),
'akkar': ('akkar',),
'akkaren': ('akkar',),
'akkarer': ('akkar',),
'akkarene': ('akkar',),
'akkedas': ('akkedas',),
'akkedasen': ('akkedas',),
'akkedaser': ('akkedas',),
'akkedasene': ('akkedas',),
'akkedering': ('akkedering',),
'akkederingen': ('akkedering',),
'akkederinga': ('akkedering',),
'akkederinger': ('akkedering',),
'akkederingene': ('akkedering',),
'akklamasjon': ('akklamasjon',),
'akklamasjonen': ('akklamasjon',),
'akklamasjoner': ('akklamasjon',),
'akklamasjonene': ('akklamasjon',),
'akkommodasjon': ('akkommodasjon',),
'akkommodasjonen': ('akkommodasjon',),
'akkommodasjoner': ('akkommodasjon',),
'akkommodasjonene': ('akkommodasjon',),
'akkompagnatør': ('akkompagnatør',),
'akkompagnatøren': ('akkompagnatør',),
'akkompagnatører': ('akkompagnatør',),
'akkompagnatørene': ('akkompagnatør',),
'akkompagnement': ('akkompagnement',),
'akkompagnementet': ('akkompagnement',),
'akkompagnement': ('akkompagnement',),
'akkompagnementer': ('akkompagnement',),
'akkompagnement': ('akkompagnement',),
'akkompagnementer': ('akkompagnement',),
'akkompagnementa': ('akkompagnement',),
'akkompagnementene': ('akkompagnement',),
'akkord': ('akkord',),
'akkorden': ('akkord',),
'akkorder': ('akkord',),
'akkordene': ('akkord',),
'akkordant': ('akkordant',),
'akkordanten': ('akkordant',),
'akkordanter': ('akkordant',),
'akkordantene': ('akkordant',),
'akkordarbeid': ('akkordarbeid',),
'akkordarbeidet': ('akkordarbeid',),
'akkordarbeid': ('akkordarbeid',),
'akkordarbeider': ('akkordarbeid',),
'akkordarbeid': ('akkordarbeid',),
'akkordarbeider': ('akkordarbeid',),
'akkordarbeida': ('akkordarbeid',),
'akkordarbeidene': ('akkordarbeid',),
'akkordbetaling': ('akkordbetaling',),
'akkordbetalingen': ('akkordbetaling',),
'akkordbetalinga': ('akkordbetaling',),
'akkordbetalinger': ('akkordbetaling',),
'akkordbetalingene': ('akkordbetaling',),
'akkordbo': ('akkordbo',),
'akkordboet': ('akkordbo',),
'akkordbo': ('akkordbo',),
'akkordboa': ('akkordbo',),
'akkordboene': ('akkordbo',),
'akkordbu': ('akkordbu',),
'akkordbuet': ('akkordbu',),
'akkordbu': ('akkordbu',),
'akkordbua': ('akkordbu',),
'akkordbuene': ('akkordbu',),
'akkordforhandling': ('akkordforhandling',),
'akkordforhandlingen': ('akkordforhandling',),
'akkordforhandlinga': ('akkordforhandling',),
'akkordforhandlinger': ('akkordforhandling',),
'akkordforhandlingene': ('akkordforhandling',),
'akkordlønn': ('akkordlønn',),
'akkordlønnen': ('akkordlønn',),
'akkordlønna': ('akkordlønn',),
'akkordlønner': ('akkordlønn',),
'akkordlønnene': ('akkordlønn',),
'akkordstyre': ('akkordstyre',),
'akkordstyret': ('akkordstyre',),
'akkordstyrer': ('akkordstyre',),
'akkordstyra': ('akkordstyre',),
'akkordstyrene': ('akkordstyre',),
'akkordstyrer': ('akkordstyrer',),
'akkordstyreren': ('akkordstyrer',),
'akkordstyrere': ('akkordstyrer',),
'akkordstyrerne': ('akkordstyrer',),
'akkordtariff': ('akkordtariff',),
'akkordtariffen': ('akkordtariff',),
'akkordtariffer': ('akkordtariff',),
'akkordtariffene': ('akkordtariff',),
'akkrediteringsbrev': ('akkrediteringsbrev',),
'akkrediteringsbrevet': ('akkrediteringsbrev',),
'akkrediteringsbrev': ('akkrediteringsbrev',),
'akkrediteringsbrever': ('akkrediteringsbrev',),
'akkrediteringsbrev': ('akkrediteringsbrev',),
'akkrediteringsbrever': ('akkrediteringsbrev',),
'akkrediteringsbreva': ('akkrediteringsbrev',),
'akkrediteringsbrevene': ('akkrediteringsbrev',),
'akkreditiv': ('akkreditiv',),
'akkreditivet': ('akkreditiv',),
'akkreditiv': ('akkreditiv',),
'akkreditiver': ('akkreditiv',),
'akkreditiv': ('akkreditiv',),
'akkreditiver': ('akkreditiv',),
'akkreditiva': ('akkreditiv',),
'akkreditivene': ('akkreditiv',),
'akkumulasjon': ('akkumulasjon',),
'akkumulasjonen': ('akkumulasjon',),
'akkumulasjoner': ('akkumulasjon',),
'akkumulasjonene': ('akkumulasjon',),
'akkumulator': ('akkumulator',),
'akkumulatoren': ('akkumulator',),
'akkumulatorer': ('akkumulator',),
'akkumulatorene': ('akkumulator',),
'akkumulatorbatteri': ('akkumulatorbatteri',),
'akkumulatorbatteriet': ('akkumulatorbatteri',),
'akkumulatorbatteri': ('akkumulatorbatteri',),
'akkumulatorbatterier': ('akkumulatorbatteri',),
'akkumulatorbatteri': ('akkumulatorbatteri',),
'akkumulatorbatterier': ('akkumulatorbatteri',),
'akkumulatorbatteria': ('akkumulatorbatteri',),
'akkumulatorbatteriene': ('akkumulatorbatteri',),
'akkumulatorcelle': ('akkumulatorcelle',),
'akkumulatorcellen': ('akkumulatorcelle',),
'akkumulatorcella': ('akkumulatorcelle',),
'akkumulatorceller': ('akkumulatorcelle',),
'akkumulatorcellene': ('akkumulatorcelle',),
'akkuratesse': ('akkuratesse',),
'akkuratessen': ('akkuratesse',),
'akkuratesser': ('akkuratesse',),
'akkuratessene': ('akkuratesse',),
'akkusativ': ('akkusativ',),
'akkusativen': ('akkusativ',),
'akkusativer': ('akkusativ',),
'akkusativene': ('akkusativ',),
'akkvisisjon': ('akkvisisjon',),
'akkvisisjonen': ('akkvisisjon',),
'akkvisisjoner': ('akkvisisjon',),
'akkvisisjonene': ('akkvisisjon',),
'akkvisitør': ('akkvisitør',),
'akkvisitøren': ('akkvisitør',),
'akkvisitører': ('akkvisitør',),
'akkvisitørene': ('akkvisitør',),
'akne': ('akne',),
'aknen': ('akne',),
'akner': ('akne',),
'aknene': ('akne',),
'akrobat': ('akrobat',),
'akrobaten': ('akrobat',),
'akrobater': ('akrobat',),
'akrobatene': ('akrobat',),
'akrobatikk': ('akrobatikk',),
'akrobatikken': ('akrobatikk',),
'akrobatikker': ('akrobatikk',),
'akrobatikkene': ('akrobatikk',),
'akrobatkunst': ('akrobatkunst',),
'akrobatkunsten': ('akrobatkunst',),
'akrobatkunster': ('akrobatkunst',),
'akrobatkunstene': ('akrobatkunst',),
'akrofobi': ('akrofobi',),
'akrofobien': ('akrofobi',),
'akrofobier': ('akrofobi',),
'akrofobiene': ('akrofobi',),
'akromegali': ('akromegali',),
'akromegalien': ('akromegali',),
'akromegalier': ('akromegali',),
'akromegaliene': ('akromegali',),
'akronym': ('akronym',),
'akronymet': ('akronym',),
'akronym': ('akronym',),
'akronymer': ('akronym',),
'akronym': ('akronym',),
'akronymer': ('akronym',),
'akronyma': ('akronym',),
'akronymene': ('akronym',),
'akrostikon': ('akrostikon',),
'akrostikonet': ('akrostikon',),
'akrostika': ('akrostikon',),
'akrostikaene': ('akrostikon',),
'akryl': ('akryl',),
'akrylen': ('akryl',),
'akrylet': ('akryl',),
'akryler': ('akryl',),
'akryl': ('akryl',),
'akrylene': ('akryl',),
'akryla': ('akryl',),
'akrylene': ('akryl',),
'akrylfiber': ('akrylfiber',),
'akrylfiberen': ('akrylfiber',),
'akrylfibere': ('akrylfiber',),
'akrylfibrer': ('akrylfiber',),
'akrylfibre': ('akrylfiber',),
'akrylfiberne': ('akrylfiber',),
'akrylfibrene': ('akrylfiber',),
'akrylsyre': ('akrylsyre',),
'akrylsyren': ('akrylsyre',),
'akrylsyra': ('akrylsyre',),
'akrylsyrer': ('akrylsyre',),
'akrylsyrene': ('akrylsyre',),
'aks': ('aks',),
'akset': ('aks',),
'aks': ('aks',),
'aksa': ('aks',),
'aksene': ('aks',),
'aksdannelse': ('aksdannelse',),
'aksdannelsen': ('aksdannelse',),
'aksdannelser': ('aksdannelse',),
'aksdannelsene': ('aksdannelse',),
'aksdanning': ('aksdanning',),
'aksdanningen': ('aksdanning',),
'aksdanninga': ('aksdanning',),
'aksdanninger': ('aksdanning',),
'aksdanningene': ('aksdanning',),
'akse': ('akse',),
'aksen': ('akse',),
'akser': ('akse',),
'aksene': ('akse',),
'aksel': ('aksel',),
'akselen': ('aksel',),
'aksler': ('aksel',),
'akslene': ('aksel',),
'aksel': ('aksel',),
'akselen': ('aksel',),
'aksla': ('aksel',),
'aksler': ('aksel',),
'akslene': ('aksel',),
'akselbein': ('akselbein',),
'akselbeinet': ('akselbein',),
'akselbein': ('akselbein',),
'akselbeina': ('akselbein',),
'akselbeinene': ('akselbein',),
'akselben': ('akselben',),
'akselbenet': ('akselben',),
'akselben': ('akselben',),
'akselbena': ('akselben',),
'akselbenene': ('akselben',),
'akselblad': ('akselblad',),
'akselbladet': ('akselblad',),
'akselblad': ('akselblad',),
'akselblader': ('akselblad',),
'akselblad': ('akselblad',),
'akselblader': ('akselblad',),
'akselblada': ('akselblad',),
'akselbladene': ('akselblad',),
'akselerasjon': ('akselerasjon',),
'akselerasjonen': ('akselerasjon',),
'akselerasjoner': ('akselerasjon',),
'akselerasjonene': ('akselerasjon',),
'akselerasjonsevne': ('akselerasjonsevne',),
'akselerasjonsevnen': ('akselerasjonsevne',),
'akselerasjonsevna': ('akselerasjonsevne',),
'akselerasjonsevner': ('akselerasjonsevne',),
'akselerasjonsevnene': ('akselerasjonsevne',),
'akselerasjonsfelt': ('akselerasjonsfelt',),
'akselerasjonsfeltet': ('akselerasjonsfelt',),
'akselerasjonsfelt': ('akselerasjonsfelt',),
'akselerasjonsfelter': ('akselerasjonsfelt',),
'akselerasjonsfelt': ('akselerasjonsfelt',),
'akselerasjonsfelter': ('akselerasjonsfelt',),
'akselerasjonsfelta': ('akselerasjonsfelt',),
'akselerasjonsfeltene': ('akselerasjonsfelt',),
'akselerator': ('akselerator',),
'akseleratoren': ('akselerator',),
'akseleratorer': ('akselerator',),
'akseleratorene': ('akselerator',),
'akselknopp': ('akselknopp',),
'akselknoppen': ('akselknopp',),
'akselknopper': ('akselknopp',),
'akselknoppene': ('akselknopp',),
'akselknupp': ('akselknupp',),
'akselknuppen': ('akselknupp',),
'akselknupper': ('akselknupp',),
'akselknuppene': ('akselknupp',),
'akselkobling': ('akselkobling',),
'akselkoblingen': ('akselkobling',),
'akselkoblinga': ('akselkobling',),
'akselkoblinger': ('akselkobling',),
'akselkoblingene': ('akselkobling',),
'akselkopling': ('akselkopling',),
'akselkoplingen': ('akselkopling',),
'akselkoplinga': ('akselkopling',),
'akselkoplinger': ('akselkopling',),
'akselkoplingene': ('akselkopling',),
'akselledning': ('akselledning',),
'akselledningen': ('akselledning',),
'akselledninga': ('akselledning',),
'akselledninger': ('akselledning',),
'akselledningene': ('akselledning',),
'akseltrykk': ('akseltrykk',),
'akseltrykket': ('akseltrykk',),
'akseltrykk': ('akseltrykk',),
'akseltrykka': ('akseltrykk',),
'akseltrykkene': ('akseltrykk',),
'aksemakt': ('aksemakt',),
'aksemakten': ('aksemakt',),
'aksemakta': ('aksemakt',),
'aksemakter': ('aksemakt',),
'aksemaktene': ('aksemakt',),
'aksent': ('aksent',),
'aksenten': ('aksent',),
'aksenter': ('aksent',),
'aksentene': ('aksent',),
'aksenttegn': ('aksenttegn',),
'aksenttegnet': ('aksenttegn',),
'aksenttegn': ('aksenttegn',),
'aksenttegna': ('aksenttegn',),
'aksenttegnene': ('aksenttegn',),
'aksentuasjon': ('aksentuasjon',),
'aksentuasjonen': ('aksentuasjon',),
'aksentuasjoner': ('aksentuasjon',),
'aksentuasjonene': ('aksentuasjon',),
'aksentuering': ('aksentuering',),
'aksentueringen': ('aksentuering',),
'aksentueringa': ('aksentuering',),
'aksentueringer': ('aksentuering',),
'aksentueringene': ('aksentuering',),
'aksept': ('aksept',),
'aksepten': ('aksept',),
'aksepter': ('aksept',),
'akseptene': ('aksept',),
'akseptant': ('akseptant',),
'akseptanten': ('akseptant',),
'akseptanter': ('akseptant',),
'akseptantene': ('akseptant',),
'aksesjon': ('aksesjon',),
'aksesjonen': ('aksesjon',),
'aksesjoner': ('aksesjon',),
'aksesjonene': ('aksesjon',),
'aksesjonskatalog': ('aksesjonskatalog',),
'aksesjonskatalogen': ('aksesjonskatalog',),
'aksesjonskataloger': ('aksesjonskatalog',),
'aksesjonskatalogene': ('aksesjonskatalog',),
'aksess': ('aksess',),
'aksessen': ('aksess',),
'aksesser': ('aksess',),
'aksessene': ('aksess',),
'aksessorium': ('aksessorium',),
'aksessoriet': ('aksessorium',),
'aksessorier': ('aksessorium',),
'aksessoria': ('aksessorium',),
'aksessoriene': ('aksessorium',),
'aksesstid': ('aksesstid',),
'aksesstiden': ('aksesstid',),
'aksesstida': ('aksesstid',),
'aksesstider': ('aksesstid',),
'aksesstidene': ('aksesstid',),
'aksialfjær': ('aksialfjær',),
'aksialfjæren': ('aksialfjær',),
'aksialfjæra': ('aksialfjær',),
'aksialfjærer': ('aksialfjær',),
'aksialfjær': ('aksialfjær',),
'aksialfjærer': ('aksialfjær',),
'aksialfjær': ('aksialfjær',),
'aksialfjærene': ('aksialfjær',),
'aksialfjør': ('aksialfjør',),
'aksialfjøren': ('aksialfjør',),
'aksialfjøra': ('aksialfjør',),
'aksialfjører': ('aksialfjør',),
'aksialfjør': ('aksialfjør',),
'aksialfjører': ('aksialfjør',),
'aksialfjør': ('aksialfjør',),
'aksialfjørene': ('aksialfjør',),
'aksialkraft': ('aksialkraft',),
'aksialkraften': ('aksialkraft',),
'aksialkrafta': ('aksialkraft',),
'aksialkrefter': ('aksialkraft',),
'aksialkreftene': ('aksialkraft',),
'aksiallager': ('aksiallager',),
'aksiallageret': ('aksiallager',),
'aksiallager': ('aksiallager',),
'aksiallagre': ('aksiallager',),
'aksiallagra': ('aksiallager',),
'aksiallagrene': ('aksiallager',),
'aksiallagra': ('aksiallager',),
'aksiallagrene': ('aksiallager',),
'aksidens': ('aksidens',),
'aksidensen': ('aksidens',),
'aksidenser': ('aksidens',),
'aksidensene': ('aksidens',),
'aksidensarbeid': ('aksidensarbeid',),
'aksidensarbeidet': ('aksidensarbeid',),
'aksidensarbeid': ('aksidensarbeid',),
'aksidensarbeider': ('aksidensarbeid',),
'aksidensarbeid': ('aksidensarbeid',),
'aksidensarbeider': ('aksidensarbeid',),
'aksidensarbeida': ('aksidensarbeid',),
'aksidensarbeidene': ('aksidensarbeid',),
'aksidenstrykkeri': ('aksidenstrykkeri',),
'aksidenstrykkeriet': ('aksidenstrykkeri',),
'aksidenstrykkeri': ('aksidenstrykkeri',),
'aksidenstrykkerier': ('aksidenstrykkeri',),
'aksidenstrykkeri': ('aksidenstrykkeri',),
'aksidenstrykkerier': ('aksidenstrykkeri',),
'aksidenstrykkeria': ('aksidenstrykkeri',),
'aksidenstrykkeriene': ('aksidenstrykkeri',),
'aksiom': ('aksiom',),
'aksiomet': ('aksiom',),
'aksiom': ('aksiom',),
'aksiomer': ('aksiom',),
'aksiom': ('aksiom',),
'aksiomer': ('aksiom',),
'aksioma': ('aksiom',),
'aksiomene': ('aksiom',),
'aksje': ('aksje',),
'aksjen': ('aksje',),
'aksjer': ('aksje',),
'aksjene': ('aksje',),
'aksjeandel': ('aksjeandel',),
'aksjeandelen': ('aksjeandel',),
'aksjeandeler': ('aksjeandel',),
'aksjeandelene': ('aksjeandel',),
'aksjebrev': ('aksjebrev',),
'aksjebrevet': ('aksjebrev',),
'aksjebrev': ('aksjebrev',),
'aksjebrever': ('aksjebrev',),
'aksjebrev': ('aksjebrev',),
'aksjebrever': ('aksjebrev',),
'aksjebreva': ('aksjebrev',),
'aksjebrevene': ('aksjebrev',),
'aksjeeier': ('aksjeeier',),
'aksjeeieren': ('aksjeeier',),
'aksjeeiere': ('aksjeeier',),
'aksjeeierne': ('aksjeeier',),
'aksjefond': ('aksjefond',),
'aksjefondet': ('aksjefond',),
'aksjefond': ('aksjefond',),
'aksjefonda': ('aksjefond',),
'aksjefondene': ('aksjefond',),
'aksjekapital': ('aksjekapital',),
'aksjekapitalen': ('aksjekapital',),
'aksjekapitaler': ('aksjekapital',),
'aksjekapitalene': ('aksjekapital',),
'aksjeleilighet': ('aksjeleilighet',),
'aksjeleiligheten': ('aksjeleilighet',),
'aksjeleiligheta': ('aksjeleilighet',),
'aksjeleiligheter': ('aksjeleilighet',),
'aksjeleilighetene': ('aksjeleilighet',),
'aksjemajoritet': ('aksjemajoritet',),
'aksjemajoriteten': ('aksjemajoritet',),
'aksjemajoriteter': ('aksjemajoritet',),
'aksjemajoritetene': ('aksjemajoritet',),
'aksjemarked': ('aksjemarked',),
'aksjemarkedet': ('aksjemarked',),
'aksjemarked': ('aksjemarked',),
'aksjemarkeder': ('aksjemarked',),
'aksjemarked': ('aksjemarked',),
'aksjemarkeder': ('aksjemarked',),
'aksjemarkeda': ('aksjemarked',),
'aksjemarkedene': ('aksjemarked',),
'aksjemegler': ('aksjemegler',),
'aksjemegleren': ('aksjemegler',),
'aksjemeglere': ('aksjemegler',),
'aksjemeglerne': ('aksjemegler',),
'aksjemekler': ('aksjemekler',),
'aksjemekleren': ('aksjemekler',),
'aksjemeklere': ('aksjemekler',),
'aksjemeklerne': ('aksjemekler',),
'aksjenotering': ('aksjenotering',),
'aksjenoteringen': ('aksjenotering',),
'aksjenoteringa': ('aksjenotering',),
'aksjenoteringer': ('aksjenotering',),
'aksjenoteringene': ('aksjenotering',),
'aksjeselskap': ('aksjeselskap',),
'aksjeselskapet': ('aksjeselskap',),
'aksjeselskap': ('aksjeselskap',),
'aksjeselskaper': ('aksjeselskap',),
'aksjeselskap': ('aksjeselskap',),
'aksjeselskaper': ('aksjeselskap',),
'aksjeselskapa': ('aksjeselskap',),
'aksjeselskapene': ('aksjeselskap',),
'aksjesum': ('aksjesum',),
'aksjesummen': ('aksjesum',),
'aksjesummer': ('aksjesum',),
'aksjesummene': ('aksjesum',),
'aksjeutbytte': ('aksjeutbytte',),
'aksjeutbyttet': ('aksjeutbytte',),
'aksjeutbytter': ('aksjeutbytte',),
'aksjeutbytta': ('aksjeutbytte',),
'aksjeutbyttene': ('aksjeutbytte',),
'aksjon': ('aksjon',),
'aksjonen': ('aksjon',),
'aksjoner': ('aksjon',),
'aksjonene': ('aksjon',),
'aksjonist': ('aksjonist',),
'aksjonisten': ('aksjonist',),
'aksjonister': ('aksjonist',),
'aksjonistene': ('aksjonist',),
'aksjonsart': ('aksjonsart',),
'aksjonsarten': ('aksjonsart',),
'aksjonsarta': ('aksjonsart',),
'aksjonsarter': ('aksjonsart',),
'aksjonsartene': ('aksjonsart',),
'aksjonsradius': ('aksjonsradius',),
'aksjonsradien': ('aksjonsradius',),
'aksjonsradiusen': ('aksjonsradius',),
'aksjonsradier': ('aksjonsradius',),
'aksjonsradiene': ('aksjonsradius',),
'aksjonstid': ('aksjonstid',),
'aksjonstiden': ('aksjonstid',),
'aksjonstida': ('aksjonstid',),
'aksjonstider': ('aksjonstid',),
'aksjonstidene': ('aksjonstid',),
'aksjonsutvalg': ('aksjonsutvalg',),
'aksjonsutvalget': ('aksjonsutvalg',),
'aksjonsutvalg': ('aksjonsutvalg',),
'aksjonsutvalga': ('aksjonsutvalg',),
'aksjonsutvalgene': ('aksjonsutvalg',),
'aksjonær': ('aksjonær',),
'aksjonæren': ('aksjonær',),
'aksjonærer': ('aksjonær',),
'aksjonærene': ('aksjonær',),
'aksjonærmøte': ('aksjonærmøte',),
'aksjonærmøtet': ('aksjonærmøte',),
'aksjonærmøter': ('aksjonærmøte',),
'aksjonærmøta': ('aksjonærmøte',),
'aksjonærmøtene': ('aksjonærmøte',),
'aksling': ('aksling',),
'akslingen': ('aksling',),
'akslinger': ('aksling',),
'akslingene': ('aksling',),
'akt': ('akt',),
'akten': ('akt',),
'akta': ('akt',),
'akter': ('akt',),
'aktene': ('akt',),
'aktelse': ('aktelse',),
'aktelsen': ('aktelse',),
'aktelser': ('aktelse',),
'aktelsene': ('aktelse',),
'akterdekk': ('akterdekk',),
'akterdekket': ('akterdekk',),
'akterdekk': ('akterdekk',),
'akterdekka': ('akterdekk',),
'akterdekkene': ('akterdekk',),
'akterende': ('akterende',),
'akterenden': ('akterende',),
'akterender': ('akterende',),
'akterendene': ('akterende',),
'akterkant': ('akterkant',),
'akterkanten': ('akterkant',),
'akterkanter': ('akterkant',),
'akterkantene': ('akterkant',),
'akterlanterne': ('akterlanterne',),
'akterlanternen': ('akterlanterne',),
'akterlanterna': ('akterlanterne',),
'akterlanterner': ('akterlanterne',),
'akterlanternene': ('akterlanterne',),
'akterrom': ('akterrom',),
'akterrommet': ('akterrom',),
'akterrom': ('akterrom',),
'akterromma': ('akterrom',),
'akterrommene': ('akterrom',),
'akterskott': ('akterskott',),
'akterskotten': ('akterskott',),
'akterskotter': ('akterskott',),
'akterskottene': ('akterskott',),
'akterskott': ('akterskott',),
'akterskottet': ('akterskott',),
'akterskott': ('akterskott',),
'akterskotta': ('akterskott',),
'akterskottene': ('akterskott',),
'akterskut': ('akterskut',),
'akterskuten': ('akterskut',),
'akterskuter': ('akterskut',),
'akterskutene': ('akterskut',),
'akterspeil': ('akterspeil',),
'akterspeilet': ('akterspeil',),
'akterspeil': ('akterspeil',),
'akterspeila': ('akterspeil',),
'akterspeilene': ('akterspeil',),
'akterstavn': ('akterstavn',),
'akterstavnen': ('akterstavn',),
'akterstavner': ('akterstavn',),
'akterstavnene': ('akterstavn',),
'aktivaside': ('aktivaside',),
'aktivasiden': ('aktivaside',),
'aktivasida': ('aktivaside',),
'aktivasider': ('aktivaside',),
'aktivasidene': ('aktivaside',),
'aktivator': ('aktivator',),
'aktivatoren': ('aktivator',),
'aktivatorer': ('aktivator',),
'aktivatorene': ('aktivator',),
'aktivering': ('aktivering',),
'aktiveringen': ('aktivering',),
'aktiveringa': ('aktivering',),
'aktiveringer': ('aktivering',),
'aktiveringene': ('aktivering',),
'aktiveringsenergi': ('aktiveringsenergi',),
'aktiveringsenergien': ('aktiveringsenergi',),
'aktiveringsenergier': ('aktiveringsenergi',),
'aktiveringsenergiene': ('aktiveringsenergi',),
'aktivisme': ('aktivisme',),
'aktivismen': ('aktivisme',),
'aktivismer': ('aktivisme',),
'aktivismene': ('aktivisme',),
'aktivist': ('aktivist',),
'aktivisten': ('aktivist',),
'aktivister': ('aktivist',),
'aktivistene': ('aktivist',),
'aktivistgruppe': ('aktivistgruppe',),
'aktivistgruppen': ('aktivistgruppe',),
'aktivistgruppa': ('aktivistgruppe',),
'aktivistgrupper': ('aktivistgruppe',),
'aktivistgruppene': ('aktivistgruppe',),
'aktivitet': ('aktivitet',),
'aktiviteten': ('aktivitet',),
'aktiviteter': ('aktivitet',),
'aktivitetene': ('aktivitet',),
'aktivitetsleder': ('aktivitetsleder',),
'aktivitetslederen': ('aktivitetsleder',),
'aktivitetsledere': ('aktivitetsleder',),
'aktivitetslederne': ('aktivitetsleder',),
'aktivitetsnivå': ('aktivitetsnivå',),
'aktivitetsnivået': ('aktivitetsnivå',),
'aktivitetsnivå': ('aktivitetsnivå',),
'aktivitetsnivåer': ('aktivitetsnivå',),
'aktivitetsnivå': ('aktivitetsnivå',),
'aktivitetsnivåer': ('aktivitetsnivå',),
'aktivitetsnivåa': ('aktivitetsnivå',),
'aktivitetsnivåene': ('aktivitetsnivå',),
'aktivitetsrom': ('aktivitetsrom',),
'aktivitetsrommet': ('aktivitetsrom',),
'aktivitetsrom': ('aktivitetsrom',),
'aktivitetsromma': ('aktivitetsrom',),
'aktivitetsrommene': ('aktivitetsrom',),
'aktivitør': ('aktivitør',),
'aktivitøren': ('aktivitør',),
'aktivitører': ('aktivitør',),
'aktivitørene': ('aktivitør',),
'aktivum': ('aktivum',),
'aktivumet': ('aktivum',),
'aktivet': ('aktivum',),
'aktivumer': ('aktivum',),
'aktiva': ('aktivum',),
'aktiver': ('aktivum',),
'aktivuma': ('aktivum',),
'aktivumene': ('aktivum',),
'aktivaene': ('aktivum',),
'aktiva': ('aktivum',),
'aktmaling': ('aktmaling',),
'aktmalingen': ('aktmaling',),
'aktmalinga': ('aktmaling',),
'aktmalinger': ('aktmaling',),
'aktmalingene': ('aktmaling',),
'aktmodell': ('aktmodell',),
'aktmodellen': ('aktmodell',),
'aktmodeller': ('aktmodell',),
'aktmodellene': ('aktmodell',),
'aktor': ('aktor',),
'aktoren': ('aktor',),
'aktorer': ('aktor',),
'aktorene': ('aktor',),
'aktorat': ('aktorat',),
'aktoratet': ('aktorat',),
'aktorat': ('aktorat',),
'aktorater': ('aktorat',),
'aktorat': ('aktorat',),
'aktorater': ('aktorat',),
'aktorata': ('aktorat',),
'aktoratene': ('aktorat',),
'aktpågivenhet': ('aktpågivenhet',),
'aktpågivenheten': ('aktpågivenhet',),
'aktpågivenheta': ('aktpågivenhet',),
'aktpågivenheter': ('aktpågivenhet',),
'aktpågivenhetene': ('aktpågivenhet',),
'aktrise': ('aktrise',),
'aktrisen': ('aktrise',),
'aktrisa': ('aktrise',),
'aktriser': ('aktrise',),
'aktrisene': ('aktrise',),
'aktsomhet': ('aktsomhet',),
'aktsomheten': ('aktsomhet',),
'aktsomheta': ('aktsomhet',),
'aktsomheter': ('aktsomhet',),
'aktsomhetene': ('aktsomhet',),
'aktstykke': ('aktstykke',),
'aktstykket': ('aktstykke',),
'aktstykker': ('aktstykke',),
'aktstykka': ('aktstykke',),
'aktstykkene': ('aktstykke',),
'akttegning': ('akttegning',),
'akttegningen': ('akttegning',),
'akttegninga': ('akttegning',),
'akttegninger': ('akttegning',),
'akttegningene': ('akttegning',),
'aktualitet': ('aktualitet',),
'aktualiteten': ('aktualitet',),
'aktualiteter': ('aktualitet',),
'aktualitetene': ('aktualitet',),
'aktuar': ('aktuar',),
'aktuaren': ('aktuar',),
'aktuarer': ('aktuar',),
'aktuarene': ('aktuar',),
'aktuareksamen': ('aktuareksamen',),
'aktuareksamenen': ('aktuareksamen',),
'aktuareksamener': ('aktuareksamen',),
'aktuareksamenene': ('aktuareksamen',),
'aktuarembetseksamen': ('aktuarembetseksamen',),
'aktuarembetseksamenen': ('aktuarembetseksamen',),
'aktuarembetseksamener': ('aktuarembetseksamen',),
'aktuarembetseksamenene': ('aktuarembetseksamen',),
'aktør': ('aktør',),
'aktøren': ('aktør',),
'aktører': ('aktør',),
'aktørene': ('aktør',),
'akupunktur': ('akupunktur',),
'akupunkturen': ('akupunktur',),
'akupunkturer': ('akupunktur',),
'akupunkturene': ('akupunktur',),
'akupunktør': ('akupunktør',),
'akupunktøren': ('akupunktør',),
'akupunktører': ('akupunktør',),
'akupunktørene': ('akupunktør',),
'akustiker': ('akustiker',),
'akustikeren': ('akustiker',),
'akustikere': ('akustiker',),
'akustikerne': ('akustiker',),
'akustikk': ('akustikk',),
'akustikken': ('akustikk',),
'akustikker': ('akustikk',),
'akustikkene': ('akustikk',),
'akutt': ('akutt',),
'akutten': ('akutt',),
'akutter': ('akutt',),
'akuttene': ('akutt',),
'akutt-tegn': ('akutt-tegn',),
'akutt-tegnet': ('akutt-tegn',),
'akutt-tegn': ('akutt-tegn',),
'akutt-tegna': ('akutt-tegn',),
'akutt-tegnene': ('akutt-tegn',),
'akuttavdeling': ('akuttavdeling',),
'akuttavdelingen': ('akuttavdeling',),
'akuttavdelinga': ('akuttavdeling',),
'akuttavdelinger': ('akuttavdeling',),
'akuttavdelingene': ('akuttavdeling',),
'akuttegn': ('akuttegn',),
'akuttegnet': ('akuttegn',),
'akuttegn': ('akuttegn',),
'akuttegna': ('akuttegn',),
'akuttegnene': ('akuttegn',),
'akvakultur': ('akvakultur',),
'akvakulturen': ('akvakultur',),
'akvakulturer': ('akvakultur',),
'akvakulturene': ('akvakultur',),
'akvamarin': ('akvamarin',),
'akvamarinen': ('akvamarin',),
'akvamariner': ('akvamarin',),
'akvamarinene': ('akvamarin',),
'akvanaut': ('akvanaut',),
'akvanauten': ('akvanaut',),
'akvanauter': ('akvanaut',),
'akvanautene': ('akvanaut',),
'akvarell': ('akvarell',),
'akvarellen': ('akvarell',),
'akvareller': ('akvarell',),
'akvarellene': ('akvarell',),
'akvarellfarge': ('akvarellfarge',),
'akvarellfargen': ('akvarellfarge',),
'akvarellfarger': ('akvarellfarge',),
'akvarellfargene': ('akvarellfarge',),
'akvarellkunst': ('akvarellkunst',),
'akvarellkunsten': ('akvarellkunst',),
'akvarellkunster': ('akvarellkunst',),
'akvarellkunstene': ('akvarellkunst',),
'akvarellmaler': ('akvarellmaler',),
'akvarellmaleren': ('akvarellmaler',),
'akvarellmalere': ('akvarellmaler',),
'akvarellmalerne': ('akvarellmaler',),
'akvariebygning': ('akvariebygning',),
'akvariebygningen': ('akvariebygning',),
'akvariebygninga': ('akvariebygning',),
'akvariebygninger': ('akvariebygning',),
'akvariebygningene': ('akvariebygning',),
'akvariefisk': ('akvariefisk',),
'akvariefisken': ('akvariefisk',),
'akvariefisker': ('akvariefisk',),
'akvariefiskene': ('akvariefisk',),
'akvarium': ('akvarium',),
'akvariet': ('akvarium',),
'akvarier': ('akvarium',),
'akvaria': ('akvarium',),
'akvariene': ('akvarium',),
'akvedukt': ('akvedukt',),
'akvedukten': ('akvedukt',),
'akvedukter': ('akvedukt',),
'akveduktene': ('akvedukt',),
'al': ('al',),
'alen': ('al',),
'aler': ('al',),
'alene': ('al',),
'al': ('al',),
'alet': ('al',),
'al': ('al',),
'ala': ('al',),
'alene': ('al',),
'alabast': ('alabast',),
'alabasten': ('alabast',),
'alabaster': ('alabast',),
'alabastene': ('alabast',),
'alabastkrukke': ('alabastkrukke',),
'alabastkrukken': ('alabastkrukke',),
'alabastkrukka': ('alabastkrukke',),
'alabastkrukker': ('alabastkrukke',),
'alabastkrukkene': ('alabastkrukke',),
'alali': ('alali',),
'alalien': ('alali',),
'alalier': ('alali',),
'alaliene': ('alali',),
'alant': ('alant',),
'alanten': ('alant',),
'alanter': ('alant',),
'alantene': ('alant',),
'alantrot': ('alantrot',),
'alantroten': ('alantrot',),
'alantrota': ('alantrot',),
'alantrøtter': ('alantrot',),
'alantrøttene': ('alantrot',),
'alarm': ('alarm',),
'alarmen': ('alarm',),
'alarmer': ('alarm',),
'alarmene': ('alarm',),
'alarmapparat': ('alarmapparat',),
'alarmapparatet': ('alarmapparat',),
'alarmapparat': ('alarmapparat',),
'alarmapparater': ('alarmapparat',),
'alarmapparat': ('alarmapparat',),
'alarmapparater': ('alarmapparat',),
'alarmapparata': ('alarmapparat',),
'alarmapparatene': ('alarmapparat',),
'alarmberedskap': ('alarmberedskap',),
'alarmberedskapen': ('alarmberedskap',),
'alarmberedskapet': ('alarmberedskap',),
'alarmberedskaper': ('alarmberedskap',),
'alarmberedskap': ('alarmberedskap',),
'alarmberedskapene': ('alarmberedskap',),
'alarmberedskapa': ('alarmberedskap',),
'alarmberedskapene': ('alarmberedskap',),
'alarmklokke': ('alarmklokke',),
'alarmklokken': ('alarmklokke',),
'alarmklokka': ('alarmklokke',),
'alarmklokker': ('alarmklokke',),
'alarmklokkene': ('alarmklokke',),
'alarmsignal': ('alarmsignal',),
'alarmsignalet': ('alarmsignal',),
'alarmsignal': ('alarmsignal',),
'alarmsignaler': ('alarmsignal',),
'alarmsignal': ('alarmsignal',),
'alarmsignaler': ('alarmsignal',),
'alarmsignala': ('alarmsignal',),
'alarmsignalene': ('alarmsignal',),
'alarmsystem': ('alarmsystem',),
'alarmsystemet': ('alarmsystem',),
'alarmsystem': ('alarmsystem',),
'alarmsystemer': ('alarmsystem',),
'alarmsystem': ('alarmsystem',),
'alarmsystemer': ('alarmsystem',),
'alarmsystema': ('alarmsystem',),
'alarmsystemene': ('alarmsystem',),
'alarmtilstand': ('alarmtilstand',),
'alarmtilstanden': ('alarmtilstand',),
'alarmtilstander': ('alarmtilstand',),
'alarmtilstandene': ('alarmtilstand',),
'alaskabjørn': ('alaskabjørn',),
'alaskabjørnen': ('alaskabjørn',),
'alaskabjørner': ('alaskabjørn',),
'alaskabjørnene': ('alaskabjørn',),
'alaskasnipe': ('alaskasnipe',),
'alaskasnipen': ('alaskasnipe',),
'alaskasnipa': ('alaskasnipe',),
'alaskasniper': ('alaskasnipe',),
'alaskasnipene': ('alaskasnipe',),
'alasker': ('alasker',),
'alaskeren': ('alasker',),
'alaskere': ('alasker',),
'alaskerne': ('alasker',),
'alba': ('alba',),
'albaen': ('alba',),
'albaer': ('alba',),
'albaene': ('alba',),
'albaner': ('albaner',),
'albaneren': ('albaner',),
'albanere': ('albaner',),
'albanerne': ('albaner',),
'albansk': ('albansk',),
'albansken': ('albansk',),
'albansker': ('albansk',),
'albanskene': ('albansk',),
'albatross': ('albatross',),
'albatrossen': ('albatross',),
'albatrosser': ('albatross',),
'albatrossene': ('albatross',),
'albinisme': ('albinisme',),
'albinismen': ('albinisme',),
'albinismer': ('albinisme',),
'albinismene': ('albinisme',),
'albino': ('albino',),
'albinoen': ('albino',),
'albinoer': ('albino',),
'albinoene': ('albino',),
'albue': ('albue',),
'albuen': ('albue',),
'albuer': ('albue',),
'albuene': ('albue',),
'albueledd': ('albueledd',),
'albueleddet': ('albueledd',),
'albueledd': ('albueledd',),
'albueledda': ('albueledd',),
'albueleddene': ('albueledd',),
'albuerom': ('albuerom',),
'albuerommet': ('albuerom',),
'albuerom': ('albuerom',),
'albueromma': ('albuerom',),
'albuerommene': ('albuerom',),
'albuesnegl': ('albuesnegl',),
'albuesneglen': ('albuesnegl',),
'albuesnegler': ('albuesnegl',),
'albuesneglene': ('albuesnegl',),
'albuesnile': ('albuesnile',),
'albuesnilen': ('albuesnile',),
'albuesniler': ('albuesnile',),
'albuesnilene': ('albuesnile',),
'albuestøt': ('albuestøt',),
'albuestøtet': ('albuestøt',),
'albuestøt': ('albuestøt',),
'albuestøta': ('albuestøt',),
'albuestøtene': ('albuestøt',),
'albuestøtte': ('albuestøtte',),
'albuestøtten': ('albuestøtte',),
'albuestøtta': ('albuestøtte',),
'albuestøtter': ('albuestøtte',),
'albuestøttene': ('albuestøtte',),
'albuestøyt': ('albuestøyt',),
'albuestøyten': ('albuestøyt',),
'albuestøyter': ('albuestøyt',),
'albuestøytene': ('albuestøyt',),
'albuledd': ('albuledd',),
'albuleddet': ('albuledd',),
'albuledd': ('albuledd',),
'albuledda': ('albuledd',),
'albuleddene': ('albuledd',),
'album': ('album',),
'albumet': ('album',),
'album': ('album',),
'albumer': ('album',),
'album': ('album',),
'albumer': ('album',),
'albuma': ('album',),
'albumene': ('album',),
'albumin': ('albumin',),
'albuminet': ('albumin',),
'albumin': ('albumin',),
'albuminer': ('albumin',),
'albumin': ('albumin',),
'albuminer': ('albumin',),
'albumina': ('albumin',),
'albuminene': ('albumin',),
'alburom': ('alburom',),
'alburommet': ('alburom',),
'alburom': ('alburom',),
'alburomma': ('alburom',),
'alburommene': ('alburom',),
'albusnegl': ('albusnegl',),
'albusneglen': ('albusnegl',),
'albusnegler': ('albusnegl',),
'albusneglene': ('albusnegl',),
'albusnile': ('albusnile',),
'albusnilen': ('albusnile',),
'albusniler': ('albusnile',),
'albusnilene': ('albusnile',),
'albustøt': ('albustøt',),
'albustøtet': ('albustøt',),
'albustøt': ('albustøt',),
'albustøta': ('albustøt',),
'albustøtene': ('albustøt',),
'albustøtte': ('albustøtte',),
'albustøtten': ('albustøtte',),
'albustøtta': ('albustøtte',),
'albustøtter': ('albustøtte',),
'albustøttene': ('albustøtte',),
'albustøyt': ('albustøyt',),
'albustøyten': ('albustøyt',),
'albustøyter': ('albustøyt',),
'albustøytene': ('albustøyt',),
'aldehyd': ('aldehyd',),
'aldehydet': ('aldehyd',),
'aldehyd': ('aldehyd',),
'aldehyder': ('aldehyd',),
'aldehyd': ('aldehyd',),
'aldehyder': ('aldehyd',),
'aldehyda': ('aldehyd',),
'aldehydene': ('aldehyd',),
'alder': ('alder',),
'alderen': ('alder',),
'aldere': ('alder',),
'aldrer': ('alder',),
'aldre': ('alder',),
'alderne': ('alder',),
'aldrene': ('alder',),
'alderdom': ('alderdom',),
'alderdommen': ('alderdom',),
'alderdommer': ('alderdom',),
'alderdommene': ('alderdom',),
'alderdomssjukdom': ('alderdomssjukdom',),
'alderdomssjukdommen': ('alderdomssjukdom',),
'alderdomssjukdommer': ('alderdomssjukdom',),
'alderdomssjukdommene': ('alderdomssjukdom',),
'alderdomssløvsinn': ('alderdomssløvsinn',),
'alderdomssløvsinnet': ('alderdomssløvsinn',),
'alderdomssløvsinn': ('alderdomssløvsinn',),
'alderdomssløvsinna': ('alderdomssløvsinn',),
'alderdomssløvsinnene': ('alderdomssløvsinn',),
'alderdomssykdom': ('alderdomssykdom',),
'alderdomssykdommen': ('alderdomssykdom',),
'alderdomssykdommer': ('alderdomssykdom',),
'alderdomssykdommene': ('alderdomssykdom',),
'alderdomstegn': ('alderdomstegn',),
'alderdomstegnet': ('alderdomstegn',),
'alderdomstegn': ('alderdomstegn',),
'alderdomstegna': ('alderdomstegn',),
'alderdomstegnene': ('alderdomstegn',),
'aldersattest': ('aldersattest',),
'aldersattesten': ('aldersattest',),
'aldersattester': ('aldersattest',),
'aldersattestene': ('aldersattest',),
'aldersbolig': ('aldersbolig',),
'aldersboligen': ('aldersbolig',),
'aldersboliger': ('aldersbolig',),
'aldersboligene': ('aldersbolig',),
'aldersforskjell': ('aldersforskjell',),
'aldersforskjellen': ('aldersforskjell',),
'aldersforskjeller': ('aldersforskjell',),
'aldersforskjellene': ('aldersforskjell',),
'aldersgrense': ('aldersgrense',),
'aldersgrensen': ('aldersgrense',),
'aldersgrensa': ('aldersgrense',),
'aldersgrenser': ('aldersgrense',),
'aldersgrensene': ('aldersgrense',),
'aldersgruppe': ('aldersgruppe',),
'aldersgruppen': ('aldersgruppe',),
'aldersgruppa': ('aldersgruppe',),
'aldersgrupper': ('aldersgruppe',),
'aldersgruppene': ('aldersgruppe',),
'aldersheim': ('aldersheim',),
'aldersheimen': ('aldersheim',),
'aldersheimer': ('aldersheim',),
'aldersheimene': ('aldersheim',),
'aldershjem': ('aldershjem',),
'aldershjemmet': ('aldershjem',),
'aldershjem': ('aldershjem',),
'aldershjemma': ('aldershjem',),
'aldershjemmene': ('aldershjem',),
'alderspensjon': ('alderspensjon',),
'alderspensjonen': ('alderspensjon',),
'alderspensjoner': ('alderspensjon',),
'alderspensjonene': ('alderspensjon',),
'alderspensjonist': ('alderspensjonist',),
'alderspensjonisten': ('alderspensjonist',),
'alderspensjonister': ('alderspensjonist',),
'alderspensjonistene': ('alderspensjonist',),
'alderstillegg': ('alderstillegg',),
'alderstillegget': ('alderstillegg',),
'alderstillegg': ('alderstillegg',),
'alderstillegga': ('alderstillegg',),
'alderstilleggene': ('alderstillegg',),
'alderstrinn': ('alderstrinn',),
'alderstrinnet': ('alderstrinn',),
'alderstrinn': ('alderstrinn',),
'alderstrinna': ('alderstrinn',),
'alderstrinnene': ('alderstrinn',),
'alderstrygd': ('alderstrygd',),
'alderstrygden': ('alderstrygd',),
'alderstrygda': ('alderstrygd',),
'alderstrygder': ('alderstrygd',),
'alderstrygdene': ('alderstrygd',),
'aldring': ('aldring',),
'aldringen': ('aldring',),
'aldringa': ('aldring',),
'aldringer': ('aldring',),
'aldringene': ('aldring',),
'aleineforelder': ('aleineforelder',),
'aleineforelderen': ('aleineforelder',),
'aleineforeldre': ('aleineforelder',),
'aleineforeldra': ('aleineforelder',),
'aleineforeldrene': ('aleineforelder',),
'aleksandriner': ('aleksandriner',),
'aleksandrineren': ('aleksandriner',),
'aleksandrinere': ('aleksandriner',),
'aleksandrinerne': ('aleksandriner',),
'aleksi': ('aleksi',),
'aleksien': ('aleksi',),
'aleksier': ('aleksi',),
'aleksiene': ('aleksi',),
'alemanner': ('alemanner',),
'alemanneren': ('alemanner',),
'alemannere': ('alemanner',),
'alemannerne': ('alemanner',),
'alemannisk': ('alemannisk',),
'alemannisken': ('alemannisk',),
'alemannisker': ('alemannisk',),
'alemanniskene': ('alemannisk',),
'alen': ('alen',),
'alenen': ('alen',),
'alna': ('alen',),
'alner': ('alen',),
'alen': ('alen',),
'alner': ('alen',),
'alen': ('alen',),
'alnene': ('alen',),
'aleneforelder': ('aleneforelder',),
'aleneforelderen': ('aleneforelder',),
'aleneforeldre': ('aleneforelder',),
'aleneforeldra': ('aleneforelder',),
'aleneforeldrene': ('aleneforelder',),
'aleut': ('aleut',),
'aleuten': ('aleut',),
'aleuter': ('aleut',),
'aleutene': ('aleut',),
'aleutisk': ('aleutisk',),
'aleutisken': ('aleutisk',),
'aleutisker': ('aleutisk',),
'aleutiskene': ('aleutisk',),
'alfa': ('alfa',),
'alfaen': ('alfa',),
'alfaer': ('alfa',),
'alfaene': ('alfa',),
'alfabet': ('alfabet',),
'alfabetet': ('alfabet',),
'alfabet': ('alfabet',),
'alfabeter': ('alfabet',),
'alfabet': ('alfabet',),
'alfabeter': ('alfabet',),
'alfabeta': ('alfabet',),
'alfabetene': ('alfabet',),
'alfabrikk': ('alfabrikk',),
'alfabrikken': ('alfabrikk',),
'alfabrikker': ('alfabrikk',),
'alfabrikkene': ('alfabrikk',),
'alfagras': ('alfagras',),
'alfagraset': ('alfagras',),
'alfagras': ('alfagras',),
'alfagrasa': ('alfagras',),
'alfagrasene': ('alfagras',),
'alfagress': ('alfagress',),
'alfagresset': ('alfagress',),
'alfagress': ('alfagress',),
'alfagressa': ('alfagress',),
'alfagressene': ('alfagress',),
'alfapartikkel': ('alfapartikkel',),
'alfapartikkelen': ('alfapartikkel',),
'alfapartikler': ('alfapartikkel',),
'alfapartiklene': ('alfapartikkel',),
'alfastråle': ('alfastråle',),
'alfastrålen': ('alfastråle',),
'alfastråler': ('alfastråle',),
'alfastrålene': ('alfastråle',),
'alfons': ('alfons',),
'alfonsen': ('alfons',),
'alfonser': ('alfons',),
'alfonsene': ('alfons',),
'alfonseri': ('alfonseri',),
'alfonseriet': ('alfonseri',),
'alfonseri': ('alfonseri',),
'alfonserier': ('alfonseri',),
'alfonseri': ('alfonseri',),
'alfonserier': ('alfonseri',),
'alfonseria': ('alfonseri',),
'alfonseriene': ('alfonseri',),
'alfuru': ('alfuru',),
'alfuruen': ('alfuru',),
'alfurua': ('alfuru',),
'alfuruer': ('alfuru',),
'alfuruene': ('alfuru',),
'alge': ('alge',),
'algen': ('alge',),
'alger': ('alge',),
'algene': ('alge',),
'algebra': ('algebra',),
'algebraen': ('algebra',),
'algebraer': ('algebra',),
'algebraene': ('algebra',),
'algemiddel': ('algemiddel',),
'algemiddelet': ('algemiddel',),
'algemidlet': ('algemiddel',),
'algemiddel': ('algemiddel',),
'algemidler': ('algemiddel',),
'algemidla': ('algemiddel',),
'algemidlene': ('algemiddel',),
'algemidla': ('algemiddel',),
'algemidlene': ('algemiddel',),
'algerier': ('algerier',),
'algerieren': ('algerier',),
'algeriere': ('algerier',),
'algerierne': ('algerier',),
'algesopp': ('algesopp',),
'algesoppen': ('algesopp',),
'algesopper': ('algesopp',),
'algesoppene': ('algesopp',),
'algevekst': ('algevekst',),
'algeveksten': ('algevekst',),
'algevekster': ('algevekst',),
'algevekstene': ('algevekst',),
'algonkin': ('algonkin',),
'algonkiner': ('algonkiner',),
'algonkineren': ('algonkiner',),
'algonkinere': ('algonkiner',),
'algonkinerne': ('algonkiner',),
'algoritme': ('algoritme',),
'algoritmen': ('algoritme',),
'algoritmer': ('algoritme',),
'algoritmene': ('algoritme',),
'alibi': ('alibi',),
'alibiet': ('alibi',),
'alibi': ('alibi',),
'alibier': ('alibi',),
'alibi': ('alibi',),
'alibier': ('alibi',),
'alibia': ('alibi',),
'alibiene': ('alibi',),
'alienasjon': ('alienasjon',),
'alienasjonen': ('alienasjon',),
'alienasjoner': ('alienasjon',),
'alienasjonene': ('alienasjon',),
'alindustri': ('alindustri',),
'alindustrien': ('alindustri',),
'alindustrier': ('alindustri',),
'alindustriene': ('alindustri',),
'alkali': ('alkali',),
'alkaliet': ('alkali',),
'alkali': ('alkali',),
'alkalier': ('alkali',),
'alkali': ('alkali',),
'alkalier': ('alkali',),
'alkalia': ('alkali',),
'alkaliene': ('alkali',),
'alkalimetall': ('alkalimetall',),
'alkalimetallet': ('alkalimetall',),
'alkalimetall': ('alkalimetall',),
'alkalimetaller': ('alkalimetall',),
'alkalimetall': ('alkalimetall',),
'alkalimetaller': ('alkalimetall',),
'alkalimetalla': ('alkalimetall',),
'alkalimetallene': ('alkalimetall',),
'alkalimeter': ('alkalimeter',),
'alkalimeteret': ('alkalimeter',),
'alkalimetret': ('alkalimeter',),
'alkalimeter': ('alkalimeter',),
'alkalimetre': ('alkalimeter',),
'alkalimetra': ('alkalimeter',),
'alkalimetrene': ('alkalimeter',),
'alkalimetra': ('alkalimeter',),
'alkalimetrene': ('alkalimeter',),
'alkaloid': ('alkaloid',),
'alkaloidet': ('alkaloid',),
'alkaloid': ('alkaloid',),
'alkaloider': ('alkaloid',),
'alkaloid': ('alkaloid',),
'alkaloider': ('alkaloid',),
'alkaloida': ('alkaloid',),
'alkaloidene': ('alkaloid',),
'alkan': ('alkan',),
'alkanet': ('alkan',),
'alkan': ('alkan',),
'alkaner': ('alkan',),
'alkan': ('alkan',),
'alkaner': ('alkan',),
'alkana': ('alkan',),
'alkanene': ('alkan',),
'alke': ('alke',),
'alken': ('alke',),
'alka': ('alke',),
'alker': ('alke',),
'alkene': ('alke',),
'alkefamilie': ('alkefamilie',),
'alkefamilien': ('alkefamilie',),
'alkefamilier': ('alkefamilie',),
'alkefamiliene': ('alkefamilie',),
'alkefugl': ('alkefugl',),
'alkefuglen': ('alkefugl',),
'alkefugler': ('alkefugl',),
'alkefuglene': ('alkefugl',),
'alkekonge': ('alkekonge',),
'alkekongen': ('alkekonge',),
'alkekonger': ('alkekonge',),
'alkekongene': ('alkekonge',),
'alken': ('alken',),
'alkenet': ('alken',),
'alken': ('alken',),
'alkener': ('alken',),
'alken': ('alken',),
'alkener': ('alken',),
'alkena': ('alken',),
'alkenene': ('alken',),
'alkis': ('alkis',),
'alkisen': ('alkis',),
'alkiser': ('alkis',),
'alkisene': ('alkis',),
'alkohol': ('alkohol',),
'alkoholen': ('alkohol',),
'alkoholer': ('alkohol',),
'alkoholene': ('alkohol',),
'alkoholbruk': ('alkoholbruk',),
'alkoholbruken': ('alkoholbruk',),
'alkoholbruket': ('alkoholbruk',),
'alkoholbruker': ('alkoholbruk',),
'alkoholbruk': ('alkoholbruk',),
'alkoholbrukene': ('alkoholbruk',),
'alkoholbruka': ('alkoholbruk',),
'alkoholbrukene': ('alkoholbruk',),
'alkoholdrikk': ('alkoholdrikk',),
'alkoholdrikken': ('alkoholdrikk',),
'alkoholdrikker': ('alkoholdrikk',),
'alkoholdrikkene': ('alkoholdrikk',),
'alkoholforbruk': ('alkoholforbruk',),
'alkoholforbruket': ('alkoholforbruk',),
'alkoholforbruk': ('alkoholforbruk',),
'alkoholforbruka': ('alkoholforbruk',),
'alkoholforbrukene': ('alkoholforbruk',),
'alkoholforbud': ('alkoholforbud',),
'alkoholforbudet': ('alkoholforbud',),
'alkoholforbud': ('alkoholforbud',),
'alkoholforbuda': ('alkoholforbud',),
'alkoholforbudene': ('alkoholforbud',),
'alkoholforgiftning': ('alkoholforgiftning',),
'alkoholforgiftningen': ('alkoholforgiftning',),
'alkoholforgiftninga': ('alkoholforgiftning',),
'alkoholforgiftninger': ('alkoholforgiftning',),
'alkoholforgiftningene': ('alkoholforgiftning',),
'alkoholgjæring': ('alkoholgjæring',),
'alkoholgjæringen': ('alkoholgjæring',),
'alkoholgjæringa': ('alkoholgjæring',),
'alkoholgjæringer': ('alkoholgjæring',),
'alkoholgjæringene': ('alkoholgjæring',),
'alkoholiker': ('alkoholiker',),
'alkoholikeren': ('alkoholiker',),
'alkoholikere': ('alkoholiker',),
'alkoholikerne': ('alkoholiker',),
'alkoholinnhold': ('alkoholinnhold',),
'alkoholinnholdet': ('alkoholinnhold',),
'alkoholinnhold': ('alkoholinnhold',),
'alkoholinnholda': ('alkoholinnhold',),
'alkoholinnholdene': ('alkoholinnhold',),
'alkoholisme': ('alkoholisme',),
'alkoholismen': ('alkoholisme',),
'alkoholismer': ('alkoholisme',),
'alkoholismene': ('alkoholisme',),
'alkoholist': ('alkoholist',),
'alkoholisten': ('alkoholist',),
'alkoholister': ('alkoholist',),
'alkoholistene': ('alkoholist',),
'alkoholistheim': ('alkoholistheim',),
'alkoholistheimen': ('alkoholistheim',),
'alkoholistheimer': ('alkoholistheim',),
'alkoholistheimene': ('alkoholistheim',),
'alkoholisthjem': ('alkoholisthjem',),
'alkoholisthjemmet': ('alkoholisthjem',),
'alkoholisthjem': ('alkoholisthjem',),
'alkoholisthjemma': ('alkoholisthjem',),
'alkoholisthjemmene': ('alkoholisthjem',),
'alkoholistomsorg': ('alkoholistomsorg',),
'alkoholistomsorgen': ('alkoholistomsorg',),
'alkoholistomsorga': ('alkoholistomsorg',),
'alkoholistomsorger': ('alkoholistomsorg',),
'alkoholistomsorgene': ('alkoholistomsorg',),
'alkoholkonsentrasjon': ('alkoholkonsentrasjon',),
'alkoholkonsentrasjonen': ('alkoholkonsentrasjon',),
'alkoholkonsentrasjoner': ('alkoholkonsentrasjon',),
'alkoholkonsentrasjonene': ('alkoholkonsentrasjon',),
'alkohollovgiing': ('alkohollovgiing',),
'alkohollovgiingen': ('alkohollovgiing',),
'alkohollovgiinga': ('alkohollovgiing',),
'alkohollovgiinger': ('alkohollovgiing',),
'alkohollovgiingene': ('alkohollovgiing',),
'alkohollovgiving': ('alkohollovgiving',),
'alkohollovgivingen': ('alkohollovgiving',),
'alkohollovgivinga': ('alkohollovgiving',),
'alkohollovgivinger': ('alkohollovgiving',),
'alkohollovgivingene': ('alkohollovgiving',),
'alkohollovgivning': ('alkohollovgivning',),
'alkohollovgivningen': ('alkohollovgivning',),
'alkohollovgivninga': ('alkohollovgivning',),
'alkohollovgivninger': ('alkohollovgivning',),
'alkohollovgivningene': ('alkohollovgivning',),
'alkoholmisbruk': ('alkoholmisbruk',),
'alkoholmisbruken': ('alkoholmisbruk',),
'alkoholmisbruket': ('alkoholmisbruk',),
'alkoholmisbruker': ('alkoholmisbruk',),
'alkoholmisbruk': ('alkoholmisbruk',),
'alkoholmisbrukene': ('alkoholmisbruk',),
'alkoholmisbruka': ('alkoholmisbruk',),
'alkoholmisbrukene': ('alkoholmisbruk',),
'alkoholnytelse': ('alkoholnytelse',),
'alkoholnytelsen': ('alkoholnytelse',),
'alkoholnytelser': ('alkoholnytelse',),
'alkoholnytelsene': ('alkoholnytelse',),
'alkoholnyting': ('alkoholnyting',),
'alkoholnytingen': ('alkoholnyting',),
'alkoholnytinga': ('alkoholnyting',),
'alkoholnytinger': ('alkoholnyting',),
'alkoholnytingene': ('alkoholnyting',),
'alkoholprosent': ('alkoholprosent',),
'alkoholprosenten': ('alkoholprosent',),
'alkoholprosenter': ('alkoholprosent',),
'alkoholprosent': ('alkoholprosent',),
'alkoholprosentene': ('alkoholprosent',),
'alkoholprøve': ('alkoholprøve',),
'alkoholprøven': ('alkoholprøve',),
'alkoholprøva': ('alkoholprøve',),
'alkoholprøver': ('alkoholprøve',),
'alkoholprøvene': ('alkoholprøve',),
'alkoholskatt': ('alkoholskatt',),
'alkoholskatten': ('alkoholskatt',),
'alkoholskatter': ('alkoholskatt',),
'alkoholskattene': ('alkoholskatt',),
'alkoholtrang': ('alkoholtrang',),
'alkoholtrangen': ('alkoholtrang',),
'alkoholtranger': ('alkoholtrang',),
'alkoholtrangene': ('alkoholtrang',),
'alkotest': ('alkotest',),
'alkotesten': ('alkotest',),
'alkotester': ('alkotest',),
'alkotestene': ('alkotest',),
'alkove': ('alkove',),
'alkoven': ('alkove',),
'alkover': ('alkove',),
'alkovene': ('alkove',),
'alkyd': ('alkyd',),
'alkydet': ('alkyd',),
'alkyd': ('alkyd',),
'alkyder': ('alkyd',),
'alkyd': ('alkyd',),
'alkyder': ('alkyd',),
'alkyda': ('alkyd',),
'alkydene': ('alkyd',),
'alkydharpiks': ('alkydharpiks',),
'alkydharpiksen': ('alkydharpiks',),
'alkydharpikser': ('alkydharpiks',),
'alkydharpiksene': ('alkydharpiks',),
'alkydlakk': ('alkydlakk',),
'alkydlakken': ('alkydlakk',),
'alkydlakker': ('alkydlakk',),
'alkydlakkene': ('alkydlakk',),
'alkydmaling': ('alkydmaling',),
'alkydmalingen': ('alkydmaling',),
'alkydmalinga': ('alkydmaling',),
'alkydmalinger': ('alkydmaling',),
'alkydmalingene': ('alkydmaling',),
'alkyl': ('alkyl',),
'alkylet': ('alkyl',),
'alkyl': ('alkyl',),
'alkyler': ('alkyl',),
'alkyl': ('alkyl',),
'alkyler': ('alkyl',),
'alkyla': ('alkyl',),
'alkylene': ('alkyl',),
'alkymi': ('alkymi',),
'alkymien': ('alkymi',),
'alkymier': ('alkymi',),
'alkymiene': ('alkymi',),
'alkymist': ('alkymist',),
'alkymisten': ('alkymist',),
'alkymister': ('alkymist',),
'alkymistene': ('alkymist',),
'alkyn': ('alkyn',),
'alkynet': ('alkyn',),
'alkyn': ('alkyn',),
'alkyner': ('alkyn',),
'alkyn': ('alkyn',),
'alkyner': ('alkyn',),
'alkyna': ('alkyn',),
'alkynene': ('alkyn',),
'all ting': ('all ting',),
'all verden': ('all verden',),
'allé': ('allé',),
'alléen': ('allé',),
'alleen': ('allé',),
'alléer': ('allé',),
'alleer': ('allé',),
'alléene': ('allé',),
'alleene': ('allé',),
'alle sjelers dag': ('alle sjelers dag',),
'allegori': ('allegori',),
'allegorien': ('allegori',),
'allegorier': ('allegori',),
'allegoriene': ('allegori',),
'allegretto': ('allegretto',),
'allegrettoen': ('allegretto',),
'allegrettoer': ('allegretto',),
'allegrettoene': ('allegretto',),
'allegretto': ('allegretto',),
'allegrettoen': ('allegretto',),
'allegrettoet': ('allegretto',),
'allegrettoer': ('allegretto',),
'allegretto': ('allegretto',),
'allegrettoer': ('allegretto',),
'allegrettoene': ('allegretto',),
'allegrettosats': ('allegrettosats',),
'allegrettosatsen': ('allegrettosats',),
'allegrettosatser': ('allegrettosats',),
'allegrettosatsene': ('allegrettosats',),
'allegrettotempo': ('allegrettotempo',),
'allegrettotempoet': ('allegrettotempo',),
'allegrettotempo': ('allegrettotempo',),
'allegrettotempoer': ('allegrettotempo',),
'allegrettotempo': ('allegrettotempo',),
'allegrettotempoer': ('allegrettotempo',),
'allegrettotempi': ('allegrettotempo',),
'allegrettotempoa': ('allegrettotempo',),
'allegrettotempoene': ('allegrettotempo',),
'allegrettotempiene': ('allegrettotempo',),
'allegro': ('allegro',),
'allegroen': ('allegro',),
'allegroer': ('allegro',),
'allegroene': ('allegro',),
'allegro': ('allegro',),
'allegroen': ('allegro',),
'allegroet': ('allegro',),
'allegroer': ('allegro',),
'allegro': ('allegro',),
'allegroer': ('allegro',),
'allegroene': ('allegro',),
'allegrosats': ('allegrosats',),
'allegrosatsen': ('allegrosats',),
'allegrosatser': ('allegrosats',),
'allegrosatsene': ('allegrosats',),
'allegrotempo': ('allegrotempo',),
'allegrotempoet': ('allegrotempo',),
'allegrotempo': ('allegrotempo',),
'allegrotempoer': ('allegrotempo',),
'allegrotempo': ('allegrotempo',),
'allegrotempoer': ('allegrotempo',),
'allegrotempi': ('allegrotempo',),
'allegrotempoa': ('allegrotempo',),
'allegrotempoene': ('allegrotempo',),
'allegrotempiene': ('allegrotempo',),
'allehelgensdag': ('allehelgensdag',),
'allehelgensdagen': ('allehelgensdag',),
'allehelgensdager': ('allehelgensdag',),
'allehelgensdagene': ('allehelgensdag',),
'allehånde': ('allehånde',),
'allehånden': ('allehånde',),
'allehånder': ('allehånde',),
'allehåndene': ('allehånde',),
'allel': ('allel',),
'allelet': ('allel',),
'allel': ('allel',),
'alleler': ('allel',),
'allel': ('allel',),
'alleler': ('allel',),
'allela': ('allel',),
'allelene': ('allel',),
'allemannseie': ('allemannseie',),
'allemannseiet': ('allemannseie',),
'allemannseier': ('allemannseie',),
'allemannseia': ('allemannseie',),
'allemannseiene': ('allemannseie',),
'allemannsvenn': ('allemannsvenn',),
'allemannsvennen': ('allemannsvenn',),
'allemannsvenner': ('allemannsvenn',),
'allemannsvennene': ('allemannsvenn',),
'allergi': ('allergi',),
'allergien': ('allergi',),
'allergier': ('allergi',),
'allergiene': ('allergi',),
'allergiker': ('allergiker',),
'allergikeren': ('allergiker',),
'allergikere': ('allergiker',),
'allergikerne': ('allergiker',),
'allfarveg': ('allfarveg',),
'allfarvegen': ('allfarveg',),
'allfarveger': ('allfarveg',),
'allfarvegene': ('allfarveg',),
'allfarvei': ('allfarvei',),
'allfarveien': ('allfarvei',),
'allfarveier': ('allfarvei',),
'allfarveiene': ('allfarvei',),
'allhær': ('allhær',),
'allhæren': ('allhær',),
'allhærer': ('allhær',),
'allhærene': ('allhær',),
'allianse': ('allianse',),
'alliansen': ('allianse',),
'allianser': ('allianse',),
'alliansene': ('allianse',),
'alligator': ('alligator',),
'alligatoren': ('alligator',),
'alligatorer': ('alligator',),
'alligatorene': ('alligator',),
'alligatorskinn': ('alligatorskinn',),
'alligatorskinnet': ('alligatorskinn',),
'alligatorskinn': ('alligatorskinn',),
'alligatorskinna': ('alligatorskinn',),
'alligatorskinnene': ('alligatorskinn',),
'allitterasjon': ('allitterasjon',),
'allitterasjonen': ('allitterasjon',),
'allitterasjoner': ('allitterasjon',),
'allitterasjonene': ('allitterasjon',),
'allmakt': ('allmakt',),
'allmakten': ('allmakt',),
'allmakta': ('allmakt',),
'allmakter': ('allmakt',),
'allmaktene': ('allmakt',),
'allmaktsbud': ('allmaktsbud',),
'allmaktsbudet': ('allmaktsbud',),
'allmaktsbud': ('allmaktsbud',),
'allmaktsbuda': ('allmaktsbud',),
'allmaktsbudene': ('allmaktsbud',),
'allmannamøte': ('allmannamøte',),
'allmannamøtet': ('allmannamøte',),
'allmannamøter': ('allmannamøte',),
'allmannamøta': ('allmannamøte',),
'allmannamøtene': ('allmannamøte',),
'allmenndannelse': ('allmenndannelse',),
'allmenndannelsen': ('allmenndannelse',),
'allmenndannelser': ('allmenndannelse',),
'allmenndannelsene': ('allmenndannelse',),
'allmenndanning': ('allmenndanning',),
'allmenndanningen': ('allmenndanning',),
'allmenndanninga': ('allmenndanning',),
'allmenndanninger': ('allmenndanning',),
'allmenndanningene': ('allmenndanning',),
'allmennfag': ('allmennfag',),
'allmennfaget': ('allmennfag',),
'allmennfag': ('allmennfag',),
'allmennfaga': ('allmennfag',),
'allmennfagene': ('allmennfag',),
'allmennhet': ('allmennhet',),
'allmennheten': ('allmennhet',),
'allmennheta': ('allmennhet',),
'allmennheter': ('allmennhet',),
'allmennhetene': ('allmennhet',),
'allmenning': ('allmenning',),
'allmenningen': ('allmenning',),
'allmenninger': ('allmenning',),
'allmenningene': ('allmenning',),
'allmenningsrett': ('allmenningsrett',),
'allmenningsretten': ('allmenningsrett',),
'allmenningsretter': ('allmenningsrett',),
'allmenningsrettene': ('allmenningsrett',),
'allmenningsskog': ('allmenningsskog',),
'allmenningsskogen': ('allmenningsskog',),
'allmenningsskoger': ('allmenningsskog',),
'allmenningsskogene': ('allmenningsskog',),
'allmennmedisin': ('allmennmedisin',),
'allmennmedisinen': ('allmennmedisin',),
'allmennmedisiner': ('allmennmedisin',),
'allmennmedisinene': ('allmennmedisin',),
'allmennpraktiker': ('allmennpraktiker',),
'allmennpraktikeren': ('allmennpraktiker',),
'allmennpraktikere': ('allmennpraktiker',),
'allmennpraktikerne': ('allmennpraktiker',),
'allmenntilstand': ('allmenntilstand',),
'allmenntilstanden': ('allmenntilstand',),
'allmenntilstander': ('allmenntilstand',),
'allmenntilstandene': ('allmenntilstand',),
'allmennutdannelse': ('allmennutdannelse',),
'allmennutdannelsen': ('allmennutdannelse',),
'allmennutdannelser': ('allmennutdannelse',),
'allmennutdannelsene': ('allmennutdannelse',),
'allmennutdanning': ('allmennutdanning',),
'allmennutdanningen': ('allmennutdanning',),
'allmennutdanninga': ('allmennutdanning',),
'allmennutdanninger': ('allmennutdanning',),
'allmennutdanningene': ('allmennutdanning',),
'allmue': ('allmue',),
'allmuen': ('allmue',),
'allmuer': ('allmue',),
'allmuene': ('allmue',),
'allmuebibliotek': ('allmuebibliotek',),
'allmuebiblioteket': ('allmuebibliotek',),
'allmuebibliotek': ('allmuebibliotek',),
'allmuebiblioteker': ('allmuebibliotek',),
'allmuebibliotek': ('allmuebibliotek',),
'allmuebiblioteker': ('allmuebibliotek',),
'allmuebiblioteka': ('allmuebibliotek',),
'allmuebibliotekene': ('allmuebibliotek',),
'allmueboksamling': ('allmueboksamling',),
'allmueboksamlingen': ('allmueboksamling',),
'allmueboksamlinga': ('allmueboksamling',),
'allmueboksamlinger': ('allmueboksamling',),
'allmueboksamlingene': ('allmueboksamling',),
'allmuemål': ('allmuemål',),
'allmuemålet': ('allmuemål',),
'allmuemål': ('allmuemål',),
'allmuemåla': ('allmuemål',),
'allmuemålene': ('allmuemål',),
'allmueskole': ('allmueskole',),
'allmueskolen': ('allmueskole',),
'allmueskoler': ('allmueskole',),
'allmueskolene': ('allmueskole',),
'allmøte': ('allmøte',),
'allmøtet': ('allmøte',),
'allmøter': ('allmøte',),
'allmøta': ('allmøte',),
'allmøtene': ('allmøte',),
'allnatur': ('allnatur',),
'allnaturen': ('allnatur',),
'allnaturer': ('allnatur',),
'allnaturene': ('allnatur',),
'allofon': ('allofon',),
'allofonen': ('allofon',),
'allofoner': ('allofon',),
'allofonene': ('allofon',),
'allomorf': ('allomorf',),
'allomorfen': ('allomorf',),
'allomorfer': ('allomorf',),
'allomorfene': ('allomorf',),
'allonge': ('allonge',),
'allongen': ('allonge',),
'allonger': ('allonge',),
'allongene': ('allonge',),
'allongeparykk': ('allongeparykk',),
'allongeparykken': ('allongeparykk',),
'allongeparykker': ('allongeparykk',),
'allongeparykkene': ('allongeparykk',),
'allrom': ('allrom',),
'allrommet': ('allrom',),
'allrom': ('allrom',),
'allromma': ('allrom',),
'allrommene': ('allrom',),
'allrounder': ('allrounder',),
'allrounderen': ('allrounder',),
'allroundere': ('allrounder',),
'allrounderne': ('allrounder',),
'allsang': ('allsang',),
'allsangen': ('allsang',),
'allsanger': ('allsang',),
'allsangene': ('allsang',),
'allting': ('allting',),
'alltinget': ('allting',),
'allting': ('allting',),
'alltinga': ('allting',),
'alltingene': ('allting',),
'allusjon': ('allusjon',),
'allusjonen': ('allusjon',),
'allusjoner': ('allusjon',),
'allusjonene': ('allusjon',),
'alluvialdannelse': ('alluvialdannelse',),
'alluvialdannelsen': ('alluvialdannelse',),
'alluvialdannelser': ('alluvialdannelse',),
'alluvialdannelsene': ('alluvialdannelse',),
'alluvialdanning': ('alluvialdanning',),
'alluvialdanningen': ('alluvialdanning',),
'alluvialdanninga': ('alluvialdanning',),
'alluvialdanninger': ('alluvialdanning',),
'alluvialdanningene': ('alluvialdanning',),
'alluvialtid': ('alluvialtid',),
'alluvialtiden': ('alluvialtid',),
'alluvialtida': ('alluvialtid',),
'alluvialtider': ('alluvialtid',),
'alluvialtidene': ('alluvialtid',),
'allvitenhet': ('allvitenhet',),
'allvitenheten': ('allvitenhet',),
'allvitenheta': ('allvitenhet',),
'allvitenheter': ('allvitenhet',),
'allvitenhetene': ('allvitenhet',),
'allviter': ('allviter',),
'allviteren': ('allviter',),
'allvitere': ('allviter',),
'allviterne': ('allviter',),
'allværsjager': ('allværsjager',),
'allværsjageren': ('allværsjager',),
'allværsjagere': ('allværsjager',),
'allværsjagerne': ('allværsjager',),
'allylplast': ('allylplast',),
'allylplasten': ('allylplast',),
'allylplaster': ('allylplast',),
'allylplastene': ('allylplast',),
'alm': ('alm',),
'almen': ('alm',),
'almer': ('alm',),
'almene': ('alm',),
'alma mater': ('alma mater',),
'almanakk': ('almanakk',),
'almanakken': ('almanakk',),
'almanakker': ('almanakk',),
'almanakkene': ('almanakk',),
'alminnelighet': ('alminnelighet',),
'alminneligheten': ('alminnelighet',),
'alminneligheta': ('alminnelighet',),
'alminneligheter': ('alminnelighet',),
'alminnelighetene': ('alminnelighet',),
'almisse': ('almisse',),
'almissen': ('almisse',),
'almissa': ('almisse',),
'almisser': ('almisse',),
'almissene': ('almisse',),
'aloe': ('aloe',),
'aloen': ('aloe',),
'aloer': ('aloe',),
'aloene': ('aloe',),
'alpakka': ('alpakka',),
'alpakkaen': ('alpakka',),
'alpakkaer': ('alpakka',),
'alpakkaene': ('alpakka',),
'alpedal': ('alpedal',),
'alpedalen': ('alpedal',),
'alpedaler': ('alpedal',),
'alpedalene': ('alpedal',),
'alpefiol': ('alpefiol',),
'alpefiolen': ('alpefiol',),
'alpefioler': ('alpefiol',),
'alpefiolene': ('alpefiol',),
'alpehorn': ('alpehorn',),
'alpehornet': ('alpehorn',),
'alpehorn': ('alpehorn',),
'alpehorna': ('alpehorn',),
'alpehornene': ('alpehorn',),
'alpejeger': ('alpejeger',),
'alpejegeren': ('alpejeger',),
'alpejegere': ('alpejeger',),
'alpejegerne': ('alpejeger',),
'alpelandskap': ('alpelandskap',),
'alpelandskapet': ('alpelandskap',),
'alpelandskap': ('alpelandskap',),
'alpelandskaper': ('alpelandskap',),
'alpelandskap': ('alpelandskap',),
'alpelandskaper': ('alpelandskap',),
'alpelandskapa': ('alpelandskap',),
'alpelandskapene': ('alpelandskap',),
'alpelue': ('alpelue',),
'alpeluen': ('alpelue',),
'alpelua': ('alpelue',),
'alpeluer': ('alpelue',),
'alpeluene': ('alpelue',),
'alperose': ('alperose',),
'alperosen': ('alperose',),
'alperosa': ('alperose',),
'alperoser': ('alperose',),
'alperosene': ('alperose',),
'alpeterreng': ('alpeterreng',),
'alpeterrenget': ('alpeterreng',),
'alpeterreng': ('alpeterreng',),
'alpeterrenga': ('alpeterreng',),
'alpeterrengene': ('alpeterreng',),
'alpetropp': ('alpetropp',),
'alpetroppen': ('alpetropp',),
'alpetropper': ('alpetropp',),
'alpetroppene': ('alpetropp',),
'alpinanlegg': ('alpinanlegg',),
'alpinanlegget': ('alpinanlegg',),
'alpinanlegg': ('alpinanlegg',),
'alpinanlegga': ('alpinanlegg',),
'alpinanleggene': ('alpinanlegg',),
'alpinbakke': ('alpinbakke',),
'alpinbakken': ('alpinbakke',),
'alpinbakker': ('alpinbakke',),
'alpinbakkene': ('alpinbakke',),
'alpinisme': ('alpinisme',),
'alpinismen': ('alpinisme',),
'alpinismer': ('alpinisme',),
'alpinismene': ('alpinisme',),
'alpinist': ('alpinist',),
'alpinisten': ('alpinist',),
'alpinister': ('alpinist',),
'alpinistene': ('alpinist',),
'alpinsenter': ('alpinsenter',),
'alpinsenteret': ('alpinsenter',),
'alpinsentret': ('alpinsenter',),
'alpinsenter': ('alpinsenter',),
'alpinsentre': ('alpinsenter',),
'alpinsentra': ('alpinsenter',),
'alpinsentrene': ('alpinsenter',),
'alpinsentra': ('alpinsenter',),
'alpinsentrene': ('alpinsenter',),
'alrune': ('alrune',),
'alrunen': ('alrune',),
'alruner': ('alrune',),
'alrunene': ('alrune',),
'alrunerot': ('alrunerot',),
'alruneroten': ('alrunerot',),
'alrunerota': ('alrunerot',),
'alrunerøtter': ('alrunerot',),
'alrunerøttene': ('alrunerot',),
'alsike': ('alsike',),
'alsiken': ('alsike',),
'alsiker': ('alsike',),
'alsikene': ('alsike',),
'alsikekløver': ('alsikekløver',),
'alsikekløveren': ('alsikekløver',),
'alsikekløvere': ('alsikekløver',),
'alsikekløver': ('alsikekløver',),
'alsikekløverne': ('alsikekløver',),
'alt': ('alt',),
'alten': ('alt',),
'alter': ('alt',),
'altene': ('alt',),
'alt': ('alt',),
'altet': ('alt',),
'alt': ('alt',),
'alta': ('alt',),
'altene': ('alt',),
'altan': ('altan',),
'altanen': ('altan',),
'altaner': ('altan',),
'altanene': ('altan',),
'altanbord': ('altanbord',),
'altanbordet': ('altanbord',),
'altanbord': ('altanbord',),
'altanborder': ('altanbord',),
'altanbord': ('altanbord',),
'altanborder': ('altanbord',),
'altanborda': ('altanbord',),
'altanbordene': ('altanbord',),
'altandør': ('altandør',),
'altandøren': ('altandør',),
'altandøra': ('altandør',),
'altandører': ('altandør',),
'altandørene': ('altandør',),
'alter': ('alter',),
'alteret': ('alter',),
'altret': ('alter',),
'alter': ('alter',),
'altere': ('alter',),
'altre': ('alter',),
'altera': ('alter',),
'altra': ('alter',),
'altrene': ('alter',),
'alter ego': ('alter ego',),
'alterasjon': ('alterasjon',),
'alterasjonen': ('alterasjon',),
'alterasjoner': ('alterasjon',),
'alterasjonene': ('alterasjon',),
'alterbilde': ('alterbilde',),
'alterbildet': ('alterbilde',),
'alterbilder': ('alterbilde',),
'alterbilda': ('alterbilde',),
'alterbildene': ('alterbilde',),
'alterbrød': ('alterbrød',),
'alterbrødet': ('alterbrød',),
'alterbrød': ('alterbrød',),
'alterbrøda': ('alterbrød',),
'alterbrødene': ('alterbrød',),
'alterduk': ('alterduk',),
'alterduken': ('alterduk',),
'alterduker': ('alterduk',),
'alterdukene': ('alterduk',),
'altergang': ('altergang',),
'altergangen': ('altergang',),
'alterganger': ('altergang',),
'altergangene': ('altergang',),
'altergjest': ('altergjest',),
'altergjesten': ('altergjest',),
'altergjester': ('altergjest',),
'altergjestene': ('altergjest',),
'alterkalk': ('alterkalk',),
'alterkalken': ('alterkalk',),
'alterkalker': ('alterkalk',),
'alterkalkene': ('alterkalk',),
'alterkar': ('alterkar',),
'alterkaret': ('alterkar',),
'alterkar': ('alterkar',),
'alterkara': ('alterkar',),
'alterkarene': ('alterkar',),
'alternasjon': ('alternasjon',),
'alternasjonen': ('alternasjon',),
'alternasjoner': ('alternasjon',),
'alternasjonene': ('alternasjon',),
'alternativ': ('alternativ',),
'alternativet': ('alternativ',),
'alternativ': ('alternativ',),
'alternativer': ('alternativ',),
'alternativ': ('alternativ',),
'alternativer': ('alternativ',),
'alternativa': ('alternativ',),
'alternativene': ('alternativ',),
'alternering': ('alternering',),
'alterneringen': ('alternering',),
'alterneringa': ('alternering',),
'alterneringer': ('alternering',),
'alterneringene': ('alternering',),
'alterring': ('alterring',),
'alterringen': ('alterring',),
'alterringer': ('alterring',),
'alterringene': ('alterring',),
'altersølv': ('altersølv',),
'altersølvet': ('altersølv',),
'altersølv': ('altersølv',),
'altersølva': ('altersølv',),
'altersølvene': ('altersølv',),
'altertavle': ('altertavle',),
'altertavlen': ('altertavle',),
'altertavla': ('altertavle',),
'altertavler': ('altertavle',),
'altertavlene': ('altertavle',),
'altertjeneste': ('altertjeneste',),
'altertjenesten': ('altertjeneste',),
'altertjenester': ('altertjeneste',),
'altertjenestene': ('altertjeneste',),
'altervin': ('altervin',),
'altervinen': ('altervin',),
'alterviner': ('altervin',),
'altervinene': ('altervin',),
'alteter': ('alteter',),
'alteteren': ('alteter',),
'altetere': ('alteter',),
'alteterne': ('alteter',),
'althorn': ('althorn',),
'althornet': ('althorn',),
'althorn': ('althorn',),
'althorna': ('althorn',),
'althornene': ('althorn',),
'altklarinett': ('altklarinett',),
'altklarinetten': ('altklarinett',),
'altklarinetter': ('altklarinett',),
'altklarinettene': ('altklarinett',),
'altmuligmann': ('altmuligmann',),
'altmuligmannen': ('altmuligmann',),
'altmuligmenn': ('altmuligmann',),
'altmuligmennene': ('altmuligmann',),
'altnøkkel': ('altnøkkel',),
'altnøkkelen': ('altnøkkel',),
'altnøkler': ('altnøkkel',),
'altnøklene': ('altnøkkel',),
'altruisme': ('altruisme',),
'altruismen': ('altruisme',),
'altruismer': ('altruisme',),
'altruismene': ('altruisme',),
'altruist': ('altruist',),
'altruisten': ('altruist',),
'altruister': ('altruist',),
'altruistene': ('altruist',),
'altsaksofon': ('altsaksofon',),
'altsaksofonen': ('altsaksofon',),
'altsaksofoner': ('altsaksofon',),
'altsaksofonene': ('altsaksofon',),
'altsanger': ('altsanger',),
'altsangeren': ('altsanger',),
'altsangere': ('altsanger',),
'altsangerne': ('altsanger',),
'altsangerinne': ('altsangerinne',),
'altsangerinnen': ('altsangerinne',),
'altsangerinna': ('altsangerinne',),
'altsangerinner': ('altsangerinne',),
'altsangerinnene': ('altsangerinne',),
'altstemme': ('altstemme',),
'altstemmen': ('altstemme',),
'altstemmer': ('altstemme',),
'altstemmene': ('altstemme',),
'alumina': ('alumina',),
'aluminaen': ('alumina',),
'aluminaer': ('alumina',),
'aluminaene': ('alumina',),
'aluminium': ('aluminium',),
'aluminiumen': ('aluminium',),
'aluminiumet': ('aluminium',),
'aluminiumer': ('aluminium',),
'aluminium': ('aluminium',),
'aluminiumene': ('aluminium',),
'aluminiuma': ('aluminium',),
'aluminiumene': ('aluminium',),
'aluminiumfabrikk': ('aluminiumfabrikk',),
'aluminiumfabrikken': ('aluminiumfabrikk',),
'aluminiumfabrikker': ('aluminiumfabrikk',),
'aluminiumfabrikkene': ('aluminiumfabrikk',),
'aluminiumfolie': ('aluminiumfolie',),
'aluminiumfolien': ('aluminiumfolie',),
'aluminiumfolier': ('aluminiumfolie',),
'aluminiumfoliene': ('aluminiumfolie',),
'aluminiumklorid': ('aluminiumklorid',),
'aluminiumkloridet': ('aluminiumklorid',),
'aluminiumklorid': ('aluminiumklorid',),
'aluminiumklorider': ('aluminiumklorid',),
'aluminiumklorid': ('aluminiumklorid',),
'aluminiumklorider': ('aluminiumklorid',),
'aluminiumklorida': ('aluminiumklorid',),
'aluminiumkloridene': ('aluminiumklorid',),
'aluminiumlegering': ('aluminiumlegering',),
'aluminiumlegeringen': ('aluminiumlegering',),
'aluminiumlegeringa': ('aluminiumlegering',),
'aluminiumlegeringer': ('aluminiumlegering',),
'aluminiumlegeringene': ('aluminiumlegering',),
'aluminiumoksid': ('aluminiumoksid',),
'aluminiumoksidet': ('aluminiumoksid',),
'aluminiumoksid': ('aluminiumoksid',),
'aluminiumoksider': ('aluminiumoksid',),
'aluminiumoksid': ('aluminiumoksid',),
'aluminiumoksider': ('aluminiumoksid',),
'aluminiumoksida': ('aluminiumoksid',),
'aluminiumoksidene': ('aluminiumoksid',),
'aluminiumsfabrikk': ('aluminiumsfabrikk',),
'aluminiumsfabrikken': ('aluminiumsfabrikk',),
'aluminiumsfabrikker': ('aluminiumsfabrikk',),
'aluminiumsfabrikkene': ('aluminiumsfabrikk',),
'aluminiumsfolie': ('aluminiumsfolie',),
'aluminiumsfolien': ('aluminiumsfolie',),
'aluminiumsfolier': ('aluminiumsfolie',),
'aluminiumsfoliene': ('aluminiumsfolie',),
'aluminiumsklorid': ('aluminiumsklorid',),
'aluminiumskloridet': ('aluminiumsklorid',),
'aluminiumsklorid': ('aluminiumsklorid',),
'aluminiumsklorider': ('aluminiumsklorid',),
'aluminiumsklorid': ('aluminiumsklorid',),
'aluminiumsklorider': ('aluminiumsklorid',),
'aluminiumsklorida': ('aluminiumsklorid',),
'aluminiumskloridene': ('aluminiumsklorid',),
'aluminiumslegering': ('aluminiumslegering',),
'aluminiumslegeringen': ('aluminiumslegering',),
'aluminiumslegeringa': ('aluminiumslegering',),
'aluminiumslegeringer': ('aluminiumslegering',),
'aluminiumslegeringene': ('aluminiumslegering',),
'aluminiumsoksid': ('aluminiumsoksid',),
'aluminiumsoksidet': ('aluminiumsoksid',),
'aluminiumsoksid': ('aluminiumsoksid',),
'aluminiumsoksider': ('aluminiumsoksid',),
'aluminiumsoksid': ('aluminiumsoksid',),
'aluminiumsoksider': ('aluminiumsoksid',),
'aluminiumsoksida': ('aluminiumsoksid',),
'aluminiumsoksidene': ('aluminiumsoksid',),
'aluminiumsverk': ('aluminiumsverk',),
'aluminiumsverket': ('aluminiumsverk',),
'aluminiumsverk': ('aluminiumsverk',),
'aluminiumsverker': ('aluminiumsverk',),
'aluminiumsverk': ('aluminiumsverk',),
'aluminiumsverker': ('aluminiumsverk',),
'aluminiumsverka': ('aluminiumsverk',),
'aluminiumsverkene': ('aluminiumsverk',),
'aluminiumverk': ('aluminiumverk',),
'aluminiumverket': ('aluminiumverk',),
'aluminiumverk': ('aluminiumverk',),
'aluminiumverker': ('aluminiumverk',),
'aluminiumverk': ('aluminiumverk',),
'aluminiumverker': ('aluminiumverk',),
'aluminiumverka': ('aluminiumverk',),
'aluminiumverkene': ('aluminiumverk',),
'alun': ('alun',),
'alunet': ('alun',),
'alun': ('alun',),
'aluner': ('alun',),
'alun': ('alun',),
'aluner': ('alun',),
'aluna': ('alun',),
'alunene': ('alun',),
'alunskifer': ('alunskifer',),
'alunskiferen': ('alunskifer',),
'alunskifere': ('alunskifer',),
'alunskifrer': ('alunskifer',),
'alunskifre': ('alunskifer',),
'alunskiferne': ('alunskifer',),
'alunskifrene': ('alunskifer',),
'alunstein': ('alunstein',),
'alunsteinen': ('alunstein',),
'alunsteiner': ('alunstein',),
'alunsteinene': ('alunstein',),
'alv': ('alv',),
'alven': ('alv',),
'alver': ('alv',),
'alvene': ('alv',),
'alvblåst': ('alvblåst',),
'alvblåsten': ('alvblåst',),
'alvblåster': ('alvblåst',),
'alvblåstene': ('alvblåst',),
'alvblåster': ('alvblåster',),
'alvblåsteren': ('alvblåster',),
'alvblåstere': ('alvblåster',),
'alvblåstrer': ('alvblåster',),
'alvblåstre': ('alvblåster',),
'alvblåsterne': ('alvblåster',),
'alvblåstrene': ('alvblåster',),
'alvedans': ('alvedans',),
'alvedansen': ('alvedans',),
'alvedanser': ('alvedans',),
'alvedansene': ('alvedans',),
'alvedronning': ('alvedronning',),
'alvedronningen': ('alvedronning',),
'alvedronninga': ('alvedronning',),
'alvedronninger': ('alvedronning',),
'alvedronningene': ('alvedronning',),
'alvekonge': ('alvekonge',),
'alvekongen': ('alvekonge',),
'alvekonger': ('alvekonge',),
'alvekongene': ('alvekonge',),
'alveland': ('alveland',),
'alvelandet': ('alveland',),
'alveland': ('alveland',),
'alvelanda': ('alveland',),
'alvelandene': ('alveland',),
'alveol': ('alveol',),
'alveolen': ('alveol',),
'alveoler': ('alveol',),
'alveolene': ('alveol',),
'alveolar': ('alveolar',),
'alveolaren': ('alveolar',),
'alveolarer': ('alveolar',),
'alveolarene': ('alveolar',),
'alvnever': ('alvnever',),
'alvneveren': ('alvnever',),
'alvnevra': ('alvnever',),
'alvnevrer': ('alvnever',),
'alvnevre': ('alvnever',),
'alvnevrer': ('alvnever',),
'alvnevre': ('alvnever',),
'alvnevrene': ('alvnever',),
'alvor': ('alvor',),
'alvoret': ('alvor',),
'alvor': ('alvor',),
'alvora': ('alvor',),
'alvorene': ('alvor',),
'alvorsord': ('alvorsord',),
'alvorsordet': ('alvorsord',),
'alvorsord': ('alvorsord',),
'alvorsorda': ('alvorsord',),
'alvorsordene': ('alvorsord',),
'alvorsstund': ('alvorsstund',),
'alvorsstunden': ('alvorsstund',),
'alvorsstunda': ('alvorsstund',),
'alvorsstunder': ('alvorsstund',),
'alvorsstundene': ('alvorsstund',),
'alvorstid': ('alvorstid',),
'alvorstiden': ('alvorstid',),
'alvorstida': ('alvorstid',),
'alvorstider': ('alvorstid',),
'alvorstidene': ('alvorstid',),
'amalgam': ('amalgam',),
'amalgamet': ('amalgam',),
'amalgam': ('amalgam',),
'amalgamer': ('amalgam',),
'amalgam': ('amalgam',),
'amalgamer': ('amalgam',),
'amalgama': ('amalgam',),
'amalgamene': ('amalgam',),
'amanuens': ('amanuens',),
'amanuensen': ('amanuens',),
'amanuenser': ('amanuens',),
'amanuensene': ('amanuens',),
'amanuensis': ('amanuensis',),
'amanuensen': ('amanuensis',),
'amanuenser': ('amanuensis',),
'amanuensene': ('amanuensis',),
'amaryll': ('amaryll',),
'amaryllen': ('amaryll',),
'amaryller': ('amaryll',),
'amaryllene': ('amaryll',),
'amaryllis': ('amaryllis',),
'amaryllisen': ('amaryllis',),
'amarylliser': ('amaryllis',),
'amaryllisene': ('amaryllis',),
'amasone': ('amasone',),
'amasonen': ('amasone',),
'amasona': ('amasone',),
'amasoner': ('amasone',),
'amasonene': ('amasone',),
'amatør': ('amatør',),
'amatøren': ('amatør',),
'amatører': ('amatør',),
'amatørene': ('amatør',),
'amatørbasis': ('amatørbasis',),
'amatørbasisen': ('amatørbasis',),
'amatørbasiser': ('amatørbasis',),
'amatørbasisene': ('amatørbasis',),
'amatørbilde': ('amatørbilde',),
'amatørbildet': ('amatørbilde',),
'amatørbilder': ('amatørbilde',),
'amatørbilda': ('amatørbilde',),
'amatørbildene': ('amatørbilde',),
'amatørbokser': ('amatørbokser',),
'amatørbokseren': ('amatørbokser',),
'amatørboksere': ('amatørbokser',),
'amatørbokserne': ('amatørbokser',),
'amatørfotball': ('amatørfotball',),
'amatørfotballen': ('amatørfotball',),
'amatørfotballer': ('amatørfotball',),
'amatørfotballene': ('amatørfotball',),
'amatørfotograf': ('amatørfotograf',),
'amatørfotografen': ('amatørfotograf',),
'amatørfotografer': ('amatørfotograf',),
'amatørfotografene': ('amatørfotograf',),
'amatøridrett': ('amatøridrett',),
'amatøridretten': ('amatøridrett',),
'amatøridretter': ('amatøridrett',),
'amatøridrettene': ('amatøridrett',),
'amatørisme': ('amatørisme',),
'amatørismen': ('amatørisme',),
'amatørismer': ('amatørisme',),
'amatørismene': ('amatørisme',),
'amatørskuespiller': ('amatørskuespiller',),
'amatørskuespilleren': ('amatørskuespiller',),
'amatørskuespillere': ('amatørskuespiller',),
'amatørskuespillerne': ('amatørskuespiller',),
'amatørstatus': ('amatørstatus',),
'amatørstatusen': ('amatørstatus',),
'amatørstatuser': ('amatørstatus',),
'amatørstatusene': ('amatørstatus',),
'amatørteater': ('amatørteater',),
'amatørteateret': ('amatørteater',),
'amatørteatret': ('amatørteater',),
'amatørteater': ('amatørteater',),
'amatørteatre': ('amatørteater',),
'amatørteatra': ('amatørteater',),
'amatørteatrene': ('amatørteater',),
'amatørteatra': ('amatørteater',),
'amatørteatrene': ('amatørteater',),
'ambar': ('ambar',),
'ambaren': ('ambar',),
'ambarer': ('ambar',),
'ambrer': ('ambar',),
'ambarene': ('ambar',),
'ambrene': ('ambar',),
'ambassade': ('ambassade',),
'ambassaden': ('ambassade',),
'ambassader': ('ambassade',),
'ambassadene': ('ambassade',),
'ambassaderåd': ('ambassaderåd',),
'ambassaderåden': ('ambassaderåd',),
'ambassaderåder': ('ambassaderåd',),
'ambassaderådene': ('ambassaderåd',),
'ambassadør': ('ambassadør',),
'ambassadøren': ('ambassadør',),
'ambassadører': ('ambassadør',),
'ambassadørene': ('ambassadør',),
'ambiguitet': ('ambiguitet',),
'ambiguiteten': ('ambiguitet',),
'ambiguiteter': ('ambiguitet',),
'ambiguitetene': ('ambiguitet',),
'ambisjon': ('ambisjon',),
'ambisjonen': ('ambisjon',),
'ambisjoner': ('ambisjon',),
'ambisjonene': ('ambisjon',),
'ambivalens': ('ambivalens',),
'ambivalensen': ('ambivalens',),
'ambivalenser': ('ambivalens',),
'ambivalensene': ('ambivalens',),
'ambolt': ('ambolt',),
'ambolten': ('ambolt',),
'ambolter': ('ambolt',),
'amboltene': ('ambolt',),
'ambra': ('ambra',),
'ambraen': ('ambra',),
'ambraer': ('ambra',),
'ambraene': ('ambra',),
'ambrosia': ('ambrosia',),
'ambrosiaen': ('ambrosia',),
'ambrosiaer': ('ambrosia',),
'ambrosiaene': ('ambrosia',),
'ambulanse': ('ambulanse',),
'ambulansen': ('ambulanse',),
'ambulanser': ('ambulanse',),
'ambulansene': ('ambulanse',),
'ambulansebil': ('ambulansebil',),
'ambulansebilen': ('ambulansebil',),
'ambulansebiler': ('ambulansebil',),
'ambulansebilene': ('ambulansebil',),
'ambulansefly': ('ambulansefly',),
'ambulanseflyet': ('ambulansefly',),
'ambulansefly': ('ambulansefly',),
'ambulanseflya': ('ambulansefly',),
'ambulanseflyene': ('ambulansefly',),
'amen': ('amen',),
'amenet': ('amen',),
'amen': ('amen',),
'amener': ('amen',),
'amen': ('amen',),
'amener': ('amen',),
'amena': ('amen',),
'amenene': ('amen',),
'amenoré': ('amenoré',),
'amenoréen': ('amenoré',),
'amenoreen': ('amenoré',),
'amenoréer': ('amenoré',),
'amenoreer': ('amenoré',),
'amenoréene': ('amenoré',),
'amenoreene': ('amenoré',),
'americium': ('americium',),
'americiumet': ('americium',),
'americium': ('americium',),
'americiuma': ('americium',),
'americiumene': ('americium',),
'amerikabrev': ('amerikabrev',),
'amerikabrevet': ('amerikabrev',),
'amerikabrev': ('amerikabrev',),
'amerikabrever': ('amerikabrev',),
'amerikabrev': ('amerikabrev',),
'amerikabrever': ('amerikabrev',),
'amerikabreva': ('amerikabrev',),
'amerikabrevene': ('amerikabrev',),
'amerikabåt': ('amerikabåt',),
'amerikabåten': ('amerikabåt',),
'amerikabåter': ('amerikabåt',),
'amerikabåtene': ('amerikabåt',),
'amerikafarer': ('amerikafarer',),
'amerikafareren': ('amerikafarer',),
'amerikafarere': ('amerikafarer',),
'amerikafarerne': ('amerikafarer',),
'amerikafeber': ('amerikafeber',),
'amerikafeberen': ('amerikafeber',),
'amerikafebere': ('amerikafeber',),
'amerikafebrer': ('amerikafeber',),
'amerikafebre': ('amerikafeber',),
'amerikafeberne': ('amerikafeber',),
'amerikafebrene': ('amerikafeber',),
'amerikaner': ('amerikaner',),
'amerikaneren': ('amerikaner',),
'amerikanere': ('amerikaner',),
'amerikanerne': ('amerikaner',),
'amerikanisme': ('amerikanisme',),
'amerikanismen': ('amerikanisme',),
'amerikanismer': ('amerikanisme',),
'amerikanismene': ('amerikanisme',),
'amerikanist': ('amerikanist',),
'amerikanisten': ('amerikanist',),
'amerikanister': ('amerikanist',),
'amerikanistene': ('amerikanist',),
'amerikansk': ('amerikansk',),
'amerikansken': ('amerikansk',),
'amerikansker': ('amerikansk',),
'amerikanskene': ('amerikansk',),
'amerikansk-engelsk': ('amerikansk-engelsk',),
'amerikansk-engelsken': ('amerikansk-engelsk',),
'amerikansk-engelsker': ('amerikansk-engelsk',),
'amerikansk-engelskene': ('amerikansk-engelsk',),
'ametyst': ('ametyst',),
'ametysten': ('ametyst',),
'ametyster': ('ametyst',),
'ametystene': ('ametyst',),
'amfetamin': ('amfetamin',),
'amfetaminet': ('amfetamin',),
'amfetamin': ('amfetamin',),
'amfetaminer': ('amfetamin',),
'amfetamin': ('amfetamin',),
'amfetaminer': ('amfetamin',),
'amfetamina': ('amfetamin',),
'amfetaminene': ('amfetamin',),
'amfi': ('amfi',),
'amfiet': ('amfi',),
'amfi': ('amfi',),
'amfier': ('amfi',),
'amfi': ('amfi',),
'amfier': ('amfi',),
'amfia': ('amfi',),
'amfiene': ('amfi',),
'amfibiebil': ('amfibiebil',),
'amfibiebilen': ('amfibiebil',),
'amfibiebiler': ('amfibiebil',),
'amfibiebilene': ('amfibiebil',),
'amfibiefly': ('amfibiefly',),
'amfibieflyet': ('amfibiefly',),
'amfibiefly': ('amfibiefly',),
'amfibieflya': ('amfibiefly',),
'amfibieflyene': ('amfibiefly',),
'amfibietank': ('amfibietank',),
'amfibietanken': ('amfibietank',),
'amfibietanker': ('amfibietank',),
'amfibietankene': ('amfibietank',),
'amfibietanks': ('amfibietanks',),
'amfibietanksen': ('amfibietanks',),
'amfibietankser': ('amfibietanks',),
'amfibietanks': ('amfibietanks',),
'amfibietanksene': ('amfibietanks',),
'amfibium': ('amfibium',),
'amfibiet': ('amfibium',),
'amfibier': ('amfibium',),
'amfibia': ('amfibium',),
'amfibiene': ('amfibium',),
'amfiteater': ('amfiteater',),
'amfiteateret': ('amfiteater',),
'amfiteatret': ('amfiteater',),
'amfiteater': ('amfiteater',),
'amfiteatre': ('amfiteater',),
'amfiteatra': ('amfiteater',),
'amfiteatrene': ('amfiteater',),
'amfiteatra': ('amfiteater',),
'amfiteatrene': ('amfiteater',),
'amfolytt': ('amfolytt',),
'amfolytten': ('amfolytt',),
'amfolytter': ('amfolytt',),
'amfolyttene': ('amfolytt',),
'amfora': ('amfora',),
'amforaen': ('amfora',),
'amforaer': ('amfora',),
'amforaene': ('amfora',),
'amid': ('amid',),
'amidet': ('amid',),
'amid': ('amid',),
'amider': ('amid',),
'amid': ('amid',),
'amider': ('amid',),
'amida': ('amid',),
'amidene': ('amid',),
'amin': ('amin',),
'aminet': ('amin',),
'amin': ('amin',),
'aminer': ('amin',),
'amin': ('amin',),
'aminer': ('amin',),
'amina': ('amin',),
'aminene': ('amin',),
'aminogruppe': ('aminogruppe',),
'aminogruppen': ('aminogruppe',),
'aminogruppa': ('aminogruppe',),
'aminogrupper': ('aminogruppe',),
'aminogruppene': ('aminogruppe',),
'aminosyre': ('aminosyre',),
'aminosyren': ('aminosyre',),
'aminosyra': ('aminosyre',),
'aminosyrer': ('aminosyre',),
'aminosyrene': ('aminosyre',),
'amme': ('amme',),
'ammen': ('amme',),
'amma': ('amme',),
'ammer': ('amme',),
'ammene': ('amme',),
'ammestuesnakk': ('ammestuesnakk',),
'ammestuesnakken': ('ammestuesnakk',),
'ammestuesnakket': ('ammestuesnakk',),
'ammestuesnakker': ('ammestuesnakk',),
'ammestuesnakk': ('ammestuesnakk',),
'ammestuesnakkene': ('ammestuesnakk',),
'ammestuesnakka': ('ammestuesnakk',),
'ammestuesnakkene': ('ammestuesnakk',),
'ammoniakk': ('ammoniakk',),
'ammoniakken': ('ammoniakk',),
'ammoniakker': ('ammoniakk',),
'ammoniakkene': ('ammoniakk',),
'ammoniakkgass': ('ammoniakkgass',),
'ammoniakkgassen': ('ammoniakkgass',),
'ammoniakkgasser': ('ammoniakkgass',),
'ammoniakkgassene': ('ammoniakkgass',),
'ammonium': ('ammonium',),
'ammoniumet': ('ammonium',),
'ammonium': ('ammonium',),
'ammoniuma': ('ammonium',),
'ammoniumene': ('ammonium',),
'ammoniumgjødsel': ('ammoniumgjødsel',),
'ammoniumgjødselen': ('ammoniumgjødsel',),
'ammoniumgjødsla': ('ammoniumgjødsel',),
'ammoniumgjødsler': ('ammoniumgjødsel',),
'ammoniumgjødslene': ('ammoniumgjødsel',),
'ammunisjon': ('ammunisjon',),
'ammunisjonen': ('ammunisjon',),
'ammunisjoner': ('ammunisjon',),
'ammunisjonene': ('ammunisjon',),
'ammunisjonsfabrikk': ('ammunisjonsfabrikk',),
'ammunisjonsfabrikken': ('ammunisjonsfabrikk',),
'ammunisjonsfabrikker': ('ammunisjonsfabrikk',),
'ammunisjonsfabrikkene': ('ammunisjonsfabrikk',),
'ammunisjonskasse': ('ammunisjonskasse',),
'ammunisjonskassen': ('ammunisjonskasse',),
'ammunisjonskassa': ('ammunisjonskasse',),
'ammunisjonskasser': ('ammunisjonskasse',),
'ammunisjonskassene': ('ammunisjonskasse',),
'ammunisjonskiste': ('ammunisjonskiste',),
'ammunisjonskisten': ('ammunisjonskiste',),
'ammunisjonskista': ('ammunisjonskiste',),
'ammunisjonskister': ('ammunisjonskiste',),
'ammunisjonskistene': ('ammunisjonskiste',),
'ammunisjonslager': ('ammunisjonslager',),
'ammunisjonslageret': ('ammunisjonslager',),
'ammunisjonslager': ('ammunisjonslager',),
'ammunisjonslagre': ('ammunisjonslager',),
'ammunisjonslagra': ('ammunisjonslager',),
'ammunisjonslagrene': ('ammunisjonslager',),
'ammunisjonslagra': ('ammunisjonslager',),
'ammunisjonslagrene': ('ammunisjonslager',),
'ammunisjonstilførsel': ('ammunisjonstilførsel',),
'ammunisjonstilførselen': ('ammunisjonstilførsel',),
'ammunisjonstilførsler': ('ammunisjonstilførsel',),
'ammunisjonstilførslene': ('ammunisjonstilførsel',),
'amnesi': ('amnesi',),
'amnesien': ('amnesi',),
'amnesier': ('amnesi',),
'amnesiene': ('amnesi',),
'amnesti': ('amnesti',),
'amnestiet': ('amnesti',),
'amnesti': ('amnesti',),
'amnestier': ('amnesti',),
'amnesti': ('amnesti',),
'amnestier': ('amnesti',),
'amnestia': ('amnesti',),
'amnestiene': ('amnesti',),
'amor': ('amor',),
'amoren': ('amor',),
'amorer': ('amor',),
'amorene': ('amor',),
'amoralitet': ('amoralitet',),
'amoraliteten': ('amoralitet',),
'amoraliteter': ('amoralitet',),
'amoralitetene': ('amoralitet',),
'amorboge': ('amorboge',),
'amorbogen': ('amorboge',),
'amorboger': ('amorboge',),
'amorbogene': ('amorboge',),
'amorbue': ('amorbue',),
'amorbuen': ('amorbue',),
'amorbuer': ('amorbue',),
'amorbuene': ('amorbue',),
'amorin': ('amorin',),
'amorinen': ('amorin',),
'amoriner': ('amorin',),
'amorinene': ('amorin',),
'amortisasjon': ('amortisasjon',),
'amortisasjonen': ('amortisasjon',),
'amortisasjoner': ('amortisasjon',),
'amortisasjonene': ('amortisasjon',),
'amortisering': ('amortisering',),
'amortiseringen': ('amortisering',),
'amortiseringa': ('amortisering',),
'amortiseringer': ('amortisering',),
'amortiseringene': ('amortisering',),
'amortiseringsfond': ('amortiseringsfond',),
'amortiseringsfondet': ('amortiseringsfond',),
'amortiseringsfond': ('amortiseringsfond',),
'amortiseringsfonda': ('amortiseringsfond',),
'amortiseringsfondene': ('amortiseringsfond',),
'amortiseringsplan': ('amortiseringsplan',),
'amortiseringsplanen': ('amortiseringsplan',),
'amortiseringsplaner': ('amortiseringsplan',),
'amortiseringsplanene': ('amortiseringsplan',),
'ampel': ('ampel',),
'ampelen': ('ampel',),
'ampler': ('ampel',),
'amplene': ('ampel',),
'ampelplante': ('ampelplante',),
'ampelplanten': ('ampelplante',),
'ampelplanta': ('ampelplante',),
'ampelplanter': ('ampelplante',),
'ampelplantene': ('ampelplante',),
'ampere': ('ampere',),
'amperen': ('ampere',),
'ampere': ('ampere',),
'amperene': ('ampere',),
'amperemeter': ('amperemeter',),
'amperemeteret': ('amperemeter',),
'amperemetret': ('amperemeter',),
'amperemeter': ('amperemeter',),
'amperemetre': ('amperemeter',),
'amperemetra': ('amperemeter',),
'amperemetrene': ('amperemeter',),
'amperemetra': ('amperemeter',),
'amperemetrene': ('amperemeter',),
'amplitude': ('amplitude',),
'amplituden': ('amplitude',),
'amplituder': ('amplitude',),
'amplitudene': ('amplitude',),
'amplitudemodulasjon': ('amplitudemodulasjon',),
'amplitudemodulasjonen': ('amplitudemodulasjon',),
'amplitudemodulasjoner': ('amplitudemodulasjon',),
'amplitudemodulasjonene': ('amplitudemodulasjon',),
'amplitudemodulering': ('amplitudemodulering',),
'amplitudemoduleringen': ('amplitudemodulering',),
'amplitudemoduleringa': ('amplitudemodulering',),
'amplitudemoduleringer': ('amplitudemodulering',),
'amplitudemoduleringene': ('amplitudemodulering',),
'ampulle': ('ampulle',),
'ampullen': ('ampulle',),
'ampuller': ('ampulle',),
'ampullene': ('ampulle',),
'amputasjon': ('amputasjon',),
'amputasjonen': ('amputasjon',),
'amputasjoner': ('amputasjon',),
'amputasjonene': ('amputasjon',),
'amputering': ('amputering',),
'amputeringen': ('amputering',),
'amputeringa': ('amputering',),
'amputeringer': ('amputering',),
'amputeringene': ('amputering',),
'amt': ('amt',),
'amtet': ('amt',),
'amt': ('amt',),
'amter': ('amt',),
'amt': ('amt',),
'amter': ('amt',),
'amta': ('amt',),
'amtene': ('amt',),
'amtmann': ('amtmann',),
'amtmannen': ('amtmann',),
'amtmenn': ('amtmann',),
'amtmennene': ('amtmann',),
'amtmanninne': ('amtmanninne',),
'amtmanninnen': ('amtmanninne',),
'amtmanninna': ('amtmanninne',),
'amtmanninner': ('amtmanninne',),
'amtmanninnene': ('amtmanninne',),
'amtskasserer': ('amtskasserer',),
'amtskassereren': ('amtskasserer',),
'amtskasserere': ('amtskasserer',),
'amtskassererne': ('amtskasserer',),
'amtsskole': ('amtsskole',),
'amtsskolen': ('amtsskole',),
'amtsskoler': ('amtsskole',),
'amtsskolene': ('amtsskole',),
'amulett': ('amulett',),
'amuletten': ('amulett',),
'amuletter': ('amulett',),
'amulettene': ('amulett',),
'amylase': ('amylase',),
'amylasen': ('amylase',),
'amylaser': ('amylase',),
'amylasene': ('amylase',),
'amylum': ('amylum',),
'amylumet': ('amylum',),
'amylum': ('amylum',),
'amyluma': ('amylum',),
'amylumene': ('amylum',),
'amøbe': ('amøbe',),
'amøben': ('amøbe',),
'amøber': ('amøbe',),
'amøbene': ('amøbe',),
'amøbedysenteri': ('amøbedysenteri',),
'amøbedysenterien': ('amøbedysenteri',),
'amøbedysenterier': ('amøbedysenteri',),
'amøbedysenteriene': ('amøbedysenteri',),
'anabaptist': ('anabaptist',),
'anabaptisten': ('anabaptist',),
'anabaptister': ('anabaptist',),
'anabaptistene': ('anabaptist',),
'anabolisme': ('anabolisme',),
'anabolismen': ('anabolisme',),
'anabolismer': ('anabolisme',),
'anabolismene': ('anabolisme',),
'anafor': ('anafor',),
'anaforen': ('anafor',),
'anaforer': ('anafor',),
'anaforene': ('anafor',),
'anagram': ('anagram',),
'anagrammet': ('anagram',),
'anagram': ('anagram',),
'anagrammer': ('anagram',),
'anagramma': ('anagram',),
'anagrammene': ('anagram',),
'anagramma': ('anagram',),
'anagrammene': ('anagram',),
'anakoluti': ('anakoluti',),
'anakolutien': ('anakoluti',),
'anakolutier': ('anakoluti',),
'anakolutiene': ('anakoluti',),
'anakolutt': ('anakolutt',),
'anakolutten': ('anakolutt',),
'anakolutter': ('anakolutt',),
'anakoluttene': ('anakolutt',),
'anakonda': ('anakonda',),
'anakondaen': ('anakonda',),
'anakondaer': ('anakonda',),
'anakondaene': ('anakonda',),
'anakoret': ('anakoret',),
'anakoreten': ('anakoret',),
'anakoreter': ('anakoret',),
'anakoretene': ('anakoret',),
'anakronisme': ('anakronisme',),
'anakronismen': ('anakronisme',),
'anakronismer': ('anakronisme',),
'anakronismene': ('anakronisme',),
'analfabet': ('analfabet',),
'analfabeten': ('analfabet',),
'analfabeter': ('analfabet',),
'analfabetene': ('analfabet',),
'analfabetisme': ('analfabetisme',),
'analfabetismen': ('analfabetisme',),
'analfabetismer': ('analfabetisme',),
'analfabetismene': ('analfabetisme',),
'analogi': ('analogi',),
'analogien': ('analogi',),
'analogier': ('analogi',),
'analogiene': ('analogi',),
'analogidannelse': ('analogidannelse',),
'analogidannelsen': ('analogidannelse',),
'analogidannelser': ('analogidannelse',),
'analogidannelsene': ('analogidannelse',),
'analogidanning': ('analogidanning',),
'analogidanningen': ('analogidanning',),
'analogidanninga': ('analogidanning',),
'analogidanninger': ('analogidanning',),
'analogidanningene': ('analogidanning',),
'analogislutning': ('analogislutning',),
'analogislutningen': ('analogislutning',),
'analogislutninga': ('analogislutning',),
'analogislutninger': ('analogislutning',),
'analogislutningene': ('analogislutning',),
'analogur': ('analogur',),
'analoguret': ('analogur',),
'analogur': ('analogur',),
'analogura': ('analogur',),
'analogurene': ('analogur',),
'analysand': ('analysand',),
'analysanden': ('analysand',),
'analysander': ('analysand',),
'analysandene': ('analysand',),
'analysator': ('analysator',),
'analysatoren': ('analysator',),
'analysatorer': ('analysator',),
'analysatorene': ('analysator',),
'analyse': ('analyse',),
'analysen': ('analyse',),
'analyser': ('analyse',),
'analysene': ('analyse',),
'analytiker': ('analytiker',),
'analytikeren': ('analytiker',),
'analytikere': ('analytiker',),
'analytikerne': ('analytiker',),
'analåpning': ('analåpning',),
'analåpningen': ('analåpning',),
'analåpninga': ('analåpning',),
'analåpninger': ('analåpning',),
'analåpningene': ('analåpning',),
'ananas': ('ananas',),
'ananasen': ('ananas',),
'ananaser': ('ananas',),
'ananasene': ('ananas',),
'ananasfamilie': ('ananasfamilie',),
'ananasfamilien': ('ananasfamilie',),
'ananasfamilier': ('ananasfamilie',),
'ananasfamiliene': ('ananasfamilie',),
'ananasjordbær': ('ananasjordbær',),
'ananasjordbæret': ('ananasjordbær',),
'ananasjordbær': ('ananasjordbær',),
'ananasjordbæra': ('ananasjordbær',),
'ananasjordbærene': ('ananasjordbær',),
'ananassaft': ('ananassaft',),
'ananassaften': ('ananassaft',),
'ananassafta': ('ananassaft',),
'ananassafter': ('ananassaft',),
'ananassaftene': ('ananassaft',),
'anapest': ('anapest',),
'anapesten': ('anapest',),
'anapester': ('anapest',),
'anapestene': ('anapest',),
'anarki': ('anarki',),
'anarkiet': ('anarki',),
'anarki': ('anarki',),
'anarkier': ('anarki',),
'anarki': ('anarki',),
'anarkier': ('anarki',),
'anarkia': ('anarki',),
'anarkiene': ('anarki',),
'anarkisme': ('anarkisme',),
'anarkismen': ('anarkisme',),
'anarkismer': ('anarkisme',),
'anarkismene': ('anarkisme',),
'anarkist': ('anarkist',),
'anarkisten': ('anarkist',),
'anarkister': ('anarkist',),
'anarkistene': ('anarkist',),
'anarkosyndikalisme': ('anarkosyndikalisme',),
'anarkosyndikalismen': ('anarkosyndikalisme',),
'anarkosyndikalismer': ('anarkosyndikalisme',),
'anarkosyndikalismene': ('anarkosyndikalisme',),
'anastrofe': ('anastrofe',),
'anastrofen': ('anastrofe',),
'anastrofer': ('anastrofe',),
'anastrofene': ('anastrofe',),
'anatem': ('anatem',),
'anatemet': ('anatem',),
'anatem': ('anatem',),
'anatemer': ('anatem',),
'anatem': ('anatem',),
'anatemer': ('anatem',),
'anatema': ('anatem',),
'anatemene': ('anatem',),
'anatema': ('anatema',),
'anatemaet': ('anatema',),
'anatema': ('anatema',),
'anatemaer': ('anatema',),
'anatemaene': ('anatema',),
'anatom': ('anatom',),
'anatomen': ('anatom',),
'anatomer': ('anatom',),
'anatomene': ('anatom',),
'anatomi': ('anatomi',),
'anatomien': ('anatomi',),
'anatomier': ('anatomi',),
'anatomiene': ('anatomi',),
'anbefaling': ('anbefaling',),
'anbefalingen': ('anbefaling',),
'anbefalinga': ('anbefaling',),
'anbefalinger': ('anbefaling',),
'anbefalingene': ('anbefaling',),
'anbefalingsbrev': ('anbefalingsbrev',),
'anbefalingsbrevet': ('anbefalingsbrev',),
'anbefalingsbrev': ('anbefalingsbrev',),
'anbefalingsbrever': ('anbefalingsbrev',),
'anbefalingsbrev': ('anbefalingsbrev',),
'anbefalingsbrever': ('anbefalingsbrev',),
'anbefalingsbreva': ('anbefalingsbrev',),
'anbefalingsbrevene': ('anbefalingsbrev',),
'anbefalingsskriv': ('anbefalingsskriv',),
'anbefalingsskrivet': ('anbefalingsskriv',),
'anbefalingsskriv': ('anbefalingsskriv',),
'anbefalingsskriva': ('anbefalingsskriv',),
'anbefalingsskrivene': ('anbefalingsskriv',),
'anbringelse': ('anbringelse',),
'anbringelsen': ('anbringelse',),
'anbringelser': ('anbringelse',),
'anbringelsene': ('anbringelse',),
'anbud': ('anbud',),
'anbudet': ('anbud',),
'anbud': ('anbud',),
'anbuda': ('anbud',),
'anbudene': ('anbud',),
'anbudsbetingelse': ('anbudsbetingelse',),
'anbudsbetingelsen': ('anbudsbetingelse',),
'anbudsbetingelser': ('anbudsbetingelse',),
'anbudsbetingelsene': ('anbudsbetingelse',),
'anbudsfrist': ('anbudsfrist',),
'anbudsfristen': ('anbudsfrist',),
'anbudsfrister': ('anbudsfrist',),
'anbudsfristene': ('anbudsfrist',),
'anbudsgiver': ('anbudsgiver',),
'anbudsgiveren': ('anbudsgiver',),
'anbudsgivere': ('anbudsgiver',),
'anbudsgiverne': ('anbudsgiver',),
'anbudsinnbydelse': ('anbudsinnbydelse',),
'anbudsinnbydelsen': ('anbudsinnbydelse',),
'anbudsinnbydelser': ('anbudsinnbydelse',),
'anbudsinnbydelsene': ('anbudsinnbydelse',),
'anbudspris': ('anbudspris',),
'anbudsprisen': ('anbudspris',),
'anbudspriser': ('anbudspris',),
'anbudsprisene': ('anbudspris',),
'anbyder': ('anbyder',),
'anbyderen': ('anbyder',),
'anbydere': ('anbyder',),
'anbyderne': ('anbyder',),
'and': ('and',),
'anden': ('and',),
'anda': ('and',),
'ender': ('and',),
'endene': ('and',),
'andakt': ('andakt',),
'andakten': ('andakt',),
'andakta': ('andakt',),
'andakter': ('andakt',),
'andaktene': ('andakt',),
'andaktsbok': ('andaktsbok',),
'andaktsboken': ('andaktsbok',),
'andaktsboka': ('andaktsbok',),
'andaktsbøker': ('andaktsbok',),
'andaktsbøkene': ('andaktsbok',),
'andaktsstund': ('andaktsstund',),
'andaktsstunden': ('andaktsstund',),
'andaktsstunda': ('andaktsstund',),
'andaktsstunder': ('andaktsstund',),
'andaktsstundene': ('andaktsstund',),
'andalusier': ('andalusier',),
'andalusieren': ('andalusier',),
'andalusiere': ('andalusier',),
'andalusierne': ('andalusier',),
'andante': ('andante',),
'andanten': ('andante',),
'andanter': ('andante',),
'andantene': ('andante',),
'andante': ('andante',),
'andantet': ('andante',),
'andanter': ('andante',),
'andante': ('andante',),
'andanter': ('andante',),
'andante': ('andante',),
'andanta': ('andante',),
'andantene': ('andante',),
'andantesats': ('andantesats',),
'andantesatsen': ('andantesats',),
'andantesatser': ('andantesats',),
'andantesatsene': ('andantesats',),
'andantetempo': ('andantetempo',),
'andantetempoet': ('andantetempo',),
'andantetempo': ('andantetempo',),
'andantetempoer': ('andantetempo',),
'andantetempo': ('andantetempo',),
'andantetempoer': ('andantetempo',),
'andantetempi': ('andantetempo',),
'andantetempoa': ('andantetempo',),
'andantetempoene': ('andantetempo',),
'andantetempiene': ('andantetempo',),
'andantino': ('andantino',),
'andantinoen': ('andantino',),
'andantinoer': ('andantino',),
'andantinoene': ('andantino',),
'andantino': ('andantino',),
'andantinoet': ('andantino',),
'andantino': ('andantino',),
'andantinoer': ('andantino',),
'andantino': ('andantino',),
'andantinoer': ('andantino',),
'andantinoa': ('andantino',),
'andantinoene': ('andantino',),
'ande': ('ande',),
'anden': ('ande',),
'ander': ('ande',),
'andene': ('ande',),
'andebryst': ('andebryst',),
'andebrystet': ('andebryst',),
'andebryst': ('andebryst',),
'andebrysta': ('andebryst',),
'andebrystene': ('andebryst',),
'andedam': ('andedam',),
'andedammen': ('andedam',),
'andedammer': ('andedam',),
'andedammene': ('andedam',),
'andedrag': ('andedrag',),
'andedraget': ('andedrag',),
'andedrag': ('andedrag',),
'andedraga': ('andedrag',),
'andedragene': ('andedrag',),
'andedrått': ('andedrått',),
'andedråtten': ('andedrått',),
'andedråtter': ('andedrått',),
'andedråttene': ('andedrått',),
'andefamilie': ('andefamilie',),
'andefamilien': ('andefamilie',),
'andefamilier': ('andefamilie',),
'andefamiliene': ('andefamilie',),
'andefugl': ('andefugl',),
'andefuglen': ('andefugl',),
'andefugler': ('andefugl',),
'andefuglene': ('andefugl',),
'andektighet': ('andektighet',),
'andektigheten': ('andektighet',),
'andektigheta': ('andektighet',),
'andektigheter': ('andektighet',),
'andektighetene': ('andektighet',),
'andel': ('andel',),
'andelen': ('andel',),
'andeler': ('andel',),
'andelene': ('andel',),
'andelsdrift': ('andelsdrift',),
'andelsdriften': ('andelsdrift',),
'andelsdrifta': ('andelsdrift',),
'andelsdrifter': ('andelsdrift',),
'andelsdriftene': ('andelsdrift',),
'andelseie': ('andelseie',),
'andelseiet': ('andelseie',),
'andelseier': ('andelseie',),
'andelseia': ('andelseie',),
'andelseiene': ('andelseie',),
'andelsforetak': ('andelsforetak',),
'andelsforetaket': ('andelsforetak',),
'andelsforetak': ('andelsforetak',),
'andelsforetaka': ('andelsforetak',),
'andelsforetakene': ('andelsforetak',),
'andelshaver': ('andelshaver',),
'andelshaveren': ('andelshaver',),
'andelshavere': ('andelshaver',),
'andelshaverne': ('andelshaver',),
'andelshytte': ('andelshytte',),
'andelshytten': ('andelshytte',),
'andelshytta': ('andelshytte',),
'andelshytter': ('andelshytte',),
'andelshyttene': ('andelshytte',),
'andelslag': ('andelslag',),
'andelslaget': ('andelslag',),
'andelslag': ('andelslag',),
'andelslaga': ('andelslag',),
'andelslagene': ('andelslag',),
'andelsmeieri': ('andelsmeieri',),
'andelsmeieriet': ('andelsmeieri',),
'andelsmeieri': ('andelsmeieri',),
'andelsmeierier': ('andelsmeieri',),
'andelsmeieri': ('andelsmeieri',),
'andelsmeierier': ('andelsmeieri',),
'andelsmeieria': ('andelsmeieri',),
'andelsmeieriene': ('andelsmeieri',),
'andelsslakteri': ('andelsslakteri',),
'andelsslakteriet': ('andelsslakteri',),
'andelsslakteri': ('andelsslakteri',),
'andelsslakterier': ('andelsslakteri',),
'andelsslakteri': ('andelsslakteri',),
'andelsslakterier': ('andelsslakteri',),
'andelsslakteria': ('andelsslakteri',),
'andelsslakteriene': ('andelsslakteri',),
'andelssystem': ('andelssystem',),
'andelssystemet': ('andelssystem',),
'andelssystem': ('andelssystem',),
'andelssystemer': ('andelssystem',),
'andelssystem': ('andelssystem',),
'andelssystemer': ('andelssystem',),
'andelssystema': ('andelssystem',),
'andelssystemene': ('andelssystem',),
'andemat': ('andemat',),
'andematen': ('andemat',),
'andemater': ('andemat',),
'andematene': ('andemat',),
'andematfamilie': ('andematfamilie',),
'andematfamilien': ('andematfamilie',),
'andematfamilier': ('andematfamilie',),
'andematfamiliene': ('andematfamilie',),
'andestegg': ('andestegg',),
'andesteggen': ('andestegg',),
'andestegger': ('andestegg',),
'andesteggene': ('andestegg',),
'andesteik': ('andesteik',),
'andesteiken': ('andesteik',),
'andesteika': ('andesteik',),
'andesteiker': ('andesteik',),
'andesteikene': ('andesteik',),
'andestek': ('andestek',),
'andesteken': ('andestek',),
'andesteka': ('andestek',),
'andesteker': ('andestek',),
'andestekene': ('andestek',),
'andføtting': ('andføtting',),
'andføttingen': ('andføtting',),
'andføttinger': ('andføtting',),
'andføttingene': ('andføtting',),
'andlet': ('andlet',),
'andletet': ('andlet',),
'andlet': ('andlet',),
'andleta': ('andlet',),
'andletene': ('andlet',),
'andmat': ('andmat',),
'andmaten': ('andmat',),
'andmater': ('andmat',),
'andmatene': ('andmat',),
'andmatfamilie': ('andmatfamilie',),
'andmatfamilien': ('andmatfamilie',),
'andmatfamilier': ('andmatfamilie',),
'andmatfamiliene': ('andmatfamilie',),
'andorraner': ('andorraner',),
'andorraneren': ('andorraner',),
'andorranere': ('andorraner',),
'andorranerne': ('andorraner',),
'andragende': ('andragende',),
'andragendet': ('andragende',),
'andragender': ('andragende',),
'andragendene': ('andragende',),
'andreaskors': ('andreaskors',),
'andreaskorset': ('andreaskors',),
'andreaskors': ('andreaskors',),
'andreaskorsa': ('andreaskors',),
'andreaskorsene': ('andreaskors',),
'andreasmess': ('andreasmess',),
'andreasmessen': ('andreasmess',),
'andreasmessa': ('andreasmess',),
'andreasmesser': ('andreasmess',),
'andreasmessene': ('andreasmess',),
'andreasmesse': ('andreasmesse',),
'andreasmessen': ('andreasmesse',),
'andreasmessa': ('andreasmesse',),
'andreasmesser': ('andreasmesse',),
'andreasmessene': ('andreasmesse',),
'andrefiolin': ('andrefiolin',),
'andrefiolinen': ('andrefiolin',),
'andrefioliner': ('andrefiolin',),
'andrefiolinene': ('andrefiolin',),
'andregir': ('andregir',),
'andregiret': ('andregir',),
'andregir': ('andregir',),
'andregira': ('andregir',),
'andregirene': ('andregir',),
'andregradsligning': ('andregradsligning',),
'andregradsligningen': ('andregradsligning',),
'andregradsligninga': ('andregradsligning',),
'andregradsligninger': ('andregradsligning',),
'andregradsligningene': ('andregradsligning',),
'andregradslikning': ('andregradslikning',),
'andregradslikningen': ('andregradslikning',),
'andregradslikninga': ('andregradslikning',),
'andregradslikninger': ('andregradslikning',),
'andregradslikningene': ('andregradslikning',),
'andremann': ('andremann',),
'andremannen': ('andremann',),
'andremenn': ('andremann',),
'andremennene': ('andremann',),
'andremaskinist': ('andremaskinist',),
'andremaskinisten': ('andremaskinist',),
'andremaskinister': ('andremaskinist',),
'andremaskinistene': ('andremaskinist',),
'andreplass': ('andreplass',),
'andreplassen': ('andreplass',),
'andreplasser': ('andreplass',),
'andreplassene': ('andreplass',),
'andreprioritet': ('andreprioritet',),
'andreprioriteten': ('andreprioritet',),
'andreprioriteter': ('andreprioritet',),
'andreprioritetene': ('andreprioritet',),
'andresortering': ('andresortering',),
'andresorteringen': ('andresortering',),
'andresorteringa': ('andresortering',),
'andresorteringer': ('andresortering',),
'andresorteringene': ('andresortering',),
'andrestemme': ('andrestemme',),
'andrestemmen': ('andrestemme',),
'andrestemmer': ('andrestemme',),
'andrestemmene': ('andrestemme',),
'andrestyrmann': ('andrestyrmann',),
'andrestyrmannen': ('andrestyrmann',),
'andrestyrmenn': ('andrestyrmann',),
'andrestyrmennene': ('andrestyrmann',),
'andrik': ('andrik',),
'andriken': ('andrik',),
'andriker': ('andrik',),
'andrikene': ('andrik',),
'androgen': ('androgen',),
'androgenen': ('androgen',),
'androgenet': ('androgen',),
'androgener': ('androgen',),
'androgen': ('androgen',),
'androgener': ('androgen',),
'androgen': ('androgen',),
'androgener': ('androgen',),
'androgenene': ('androgen',),
'androgena': ('androgen',),
'androgenene': ('androgen',),
'androgyni': ('androgyni',),
'androgynien': ('androgyni',),
'androgynier': ('androgyni',),
'androgyniene': ('androgyni',),
'andror': ('andror',),
'androren': ('andror',),
'androrer': ('andror',),
'androrene': ('andror',),
'anduvingsmerke': ('anduvingsmerke',),
'anduvingsmerket': ('anduvingsmerke',),
'anduvingsmerker': ('anduvingsmerke',),
'anduvingsmerka': ('anduvingsmerke',),
'anduvingsmerkene': ('anduvingsmerke',),
'ane': ('ane',),
'anen': ('ane',),
'aner': ('ane',),
'anene': ('ane',),
'anebilde': ('anebilde',),
'anebildet': ('anebilde',),
'anebilder': ('anebilde',),
'anebilda': ('anebilde',),
'anebildene': ('anebilde',),
'anegalleri': ('anegalleri',),
'anegalleriet': ('anegalleri',),
'anegalleri': ('anegalleri',),
'anegallerier': ('anegalleri',),
'anegalleri': ('anegalleri',),
'anegallerier': ('anegalleri',),
'anegalleria': ('anegalleri',),
'anegalleriene': ('anegalleri',),
'anekdote': ('anekdote',),
'anekdoten': ('anekdote',),
'anekdoter': ('anekdote',),
'anekdotene': ('anekdote',),
'anelse': ('anelse',),
'anelsen': ('anelse',),
'anelser': ('anelse',),
'anelsene': ('anelse',),
'anemi': ('anemi',),
'anemien': ('anemi',),
'anemier': ('anemi',),
'anemiene': ('anemi',),
'anemofili': ('anemofili',),
'anemofilien': ('anemofili',),
'anemofilier': ('anemofili',),
'anemofiliene': ('anemofili',),
'anemologi': ('anemologi',),
'anemologien': ('anemologi',),
'anemologier': ('anemologi',),
'anemologiene': ('anemologi',),
'anemometer': ('anemometer',),
'anemometeret': ('anemometer',),
'anemometret': ('anemometer',),
'anemometer': ('anemometer',),
'anemometre': ('anemometer',),
'anemometra': ('anemometer',),
'anemometrene': ('anemometer',),
'anemometra': ('anemometer',),
'anemometrene': ('anemometer',),
'anemone': ('anemone',),
'anemonen': ('anemone',),
'anemoner': ('anemone',),
'anemonene': ('anemone',),
'anerkjennelse': ('anerkjennelse',),
'anerkjennelsen': ('anerkjennelse',),
'anerkjennelser': ('anerkjennelse',),
'anerkjennelsene': ('anerkjennelse',),
'aneroidbarometer': ('aneroidbarometer',),
'aneroidbarometeret': ('aneroidbarometer',),
'aneroidbarometret': ('aneroidbarometer',),
'aneroidbarometer': ('aneroidbarometer',),
'aneroidbarometre': ('aneroidbarometer',),
'aneroidbarometra': ('aneroidbarometer',),
'aneroidbarometrene': ('aneroidbarometer',),
'aneroidbarometra': ('aneroidbarometer',),
'aneroidbarometrene': ('aneroidbarometer',),
'anestesi': ('anestesi',),
'anestesien': ('anestesi',),
'anestesier': ('anestesi',),
'anestesiene': ('anestesi',),
'anestesilege': ('anestesilege',),
'anestesilegen': ('anestesilege',),
'anestesileger': ('anestesilege',),
'anestesilegene': ('anestesilege',),
'anestesisøster': ('anestesisøster',),
'anestesisøsteren': ('anestesisøster',),
'anestesisøstera': ('anestesisøster',),
'anestesisøstrer': ('anestesisøster',),
'anestesisøstre': ('anestesisøster',),
'anestesisøstrer': ('anestesisøster',),
'anestesisøstrene': ('anestesisøster',),
'anetavle': ('anetavle',),
'anetavlen': ('anetavle',),
'anetavla': ('anetavle',),
'anetavler': ('anetavle',),
'anetavlene': ('anetavle',),
'anfall': ('anfall',),
'anfallet': ('anfall',),
'anfall': ('anfall',),
'anfalla': ('anfall',),
'anfallene': ('anfall',),
'anfektelse': ('anfektelse',),
'anfektelsen': ('anfektelse',),
'anfektelser': ('anfektelse',),
'anfektelsene': ('anfektelse',),
'anfordring': ('anfordring',),
'anfordringen': ('anfordring',),
'anfordringa': ('anfordring',),
'anfordringer': ('anfordring',),
'anfordringene': ('anfordring',),
'anfører': ('anfører',),
'anføreren': ('anfører',),
'anførere': ('anfører',),
'anførerne': ('anfører',),
'anførsel': ('anførsel',),
'anførselen': ('anførsel',),
'anførsler': ('anførsel',),
'anførslene': ('anførsel',),
'anførselstegn': ('anførselstegn',),
'anførselstegnet': ('anførselstegn',),
'anførselstegn': ('anførselstegn',),
'anførselstegna': ('anførselstegn',),
'anførselstegnene': ('anførselstegn',),
'angakok': ('angakok',),
'angakoken': ('angakok',),
'angakoker': ('angakok',),
'angakokene': ('angakok',),
'ange': ('ange',),
'angen': ('ange',),
'anger': ('ange',),
'angene': ('ange',),
'angel': ('angel',),
'angelen': ('angel',),
'angler': ('angel',),
'anglene': ('angel',),
'angelsakser': ('angelsakser',),
'angelsakseren': ('angelsakser',),
'angelsaksere': ('angelsakser',),
'angelsakserne': ('angelsakser',),
'angelsaksisk': ('angelsaksisk',),
'angelsaksisken': ('angelsaksisk',),
'angelsaksisker': ('angelsaksisk',),
'angelsaksiskene': ('angelsaksisk',),
'anger': ('anger',),
'angeren': ('anger',),
'angere': ('anger',),
'angrer': ('anger',),
'angerne': ('anger',),
'angrene': ('anger',),
'angina': ('angina',),
'anginaen': ('angina',),
'anginaer': ('angina',),
'anginaene': ('angina',),
'angina pectoris': ('angina pectoris',),
'angiologi': ('angiologi',),
'angiologien': ('angiologi',),
'angiologier': ('angiologi',),
'angiologiene': ('angiologi',),
'angiosperm': ('angiosperm',),
'angiospermen': ('angiosperm',),
'angiospermer': ('angiosperm',),
'angiospermene': ('angiosperm',),
'angivelse': ('angivelse',),
'angivelsen': ('angivelse',),
'angivelser': ('angivelse',),
'angivelsene': ('angivelse',),
'angiver': ('angiver',),
'angiveren': ('angiver',),
'angivere': ('angiver',),
'angiverne': ('angiver',),
'angiveri': ('angiveri',),
'angiveriet': ('angiveri',),
'angiveri': ('angiveri',),
'angiverier': ('angiveri',),
'angiveri': ('angiveri',),
'angiverier': ('angiveri',),
'angiveria': ('angiveri',),
'angiveriene': ('angiveri',),
'anglemakk': ('anglemakk',),
'anglemakken': ('anglemakk',),
'anglemakker': ('anglemakk',),
'anglemakkene': ('anglemakk',),
'anglemark': ('anglemark',),
'anglemarken': ('anglemark',),
'anglemarker': ('anglemark',),
'anglemarkene': ('anglemark',),
'angler': ('angler',),
'angleren': ('angler',),
'anglere': ('angler',),
'anglerne': ('angler',),
'anglikaner': ('anglikaner',),
'anglikaneren': ('anglikaner',),
'anglikanere': ('anglikaner',),
'anglikanerne': ('anglikaner',),
'anglisisme': ('anglisisme',),
'anglisismen': ('anglisisme',),
'anglisismer': ('anglisisme',),
'anglisismene': ('anglisisme',),
'anglist': ('anglist',),
'anglisten': ('anglist',),
'anglister': ('anglist',),
'anglistene': ('anglist',),
'angloaraber': ('angloaraber',),
'angloaraberen': ('angloaraber',),
'angloarabere': ('angloaraber',),
'angloaraberne': ('angloaraber',),
'anglofob': ('anglofob',),
'anglofoben': ('anglofob',),
'anglofober': ('anglofob',),
'anglofobene': ('anglofob',),
'anglofobi': ('anglofobi',),
'anglofobien': ('anglofobi',),
'anglofobier': ('anglofobi',),
'anglofobiene': ('anglofobi',),
'angloman': ('angloman',),
'anglomanen': ('angloman',),
'anglomaner': ('angloman',),
'anglomanene': ('angloman',),
'anglomani': ('anglomani',),
'anglomanien': ('anglomani',),
'anglomanier': ('anglomani',),
'anglomaniene': ('anglomani',),
'angolaner': ('angolaner',),
'angolaneren': ('angolaner',),
'angolanere': ('angolaner',),
'angolanerne': ('angolaner',),
'angora': ('angora',),
'angoraen': ('angora',),
'angoraer': ('angora',),
'angoraene': ('angora',),
'angoragarn': ('angoragarn',),
'angoragarnet': ('angoragarn',),
'angoragarn': ('angoragarn',),
'angoragarna': ('angoragarn',),
'angoragarnene': ('angoragarn',),
'angorageit': ('angorageit',),
'angorageiten': ('angorageit',),
'angorageita': ('angorageit',),
'angorageiter': ('angorageit',),
'angorageitene': ('angorageit',),
'angoragenser': ('angoragenser',),
'angoragenseren': ('angoragenser',),
'angoragensere': ('angoragenser',),
'angoragenserne': ('angoragenser',),
'angorakanin': ('angorakanin',),
'angorakaninen': ('angorakanin',),
'angorakaniner': ('angorakanin',),
'angorakaninene': ('angorakanin',),
'angorakatt': ('angorakatt',),
'angorakatten': ('angorakatt',),
'angorakatter': ('angorakatt',),
'angorakattene': ('angorakatt',),
'angoraull': ('angoraull',),
'angoraullen': ('angoraull',),
'angoraulla': ('angoraull',),
'angorauller': ('angoraull',),
'angoraullene': ('angoraull',),
'angrefrist': ('angrefrist',),
'angrefristen': ('angrefrist',),
'angrefrister': ('angrefrist',),
'angrefristene': ('angrefrist',),
'angrep': ('angrep',),
'angrepet': ('angrep',),
'angrep': ('angrep',),
'angrepa': ('angrep',),
'angrepene': ('angrep',),
'angrepsfront': ('angrepsfront',),
'angrepsfronten': ('angrepsfront',),
'angrepsfronter': ('angrepsfront',),
'angrepsfrontene': ('angrepsfront',),
'angrepshandling': ('angrepshandling',),
'angrepshandlingen': ('angrepshandling',),
'angrepshandlinga': ('angrepshandling',),
'angrepshandlinger': ('angrepshandling',),
'angrepshandlingene': ('angrepshandling',),
'angrepskrig': ('angrepskrig',),
'angrepskrigen': ('angrepskrig',),
'angrepskriger': ('angrepskrig',),
'angrepskrigene': ('angrepskrig',),
'angrepsmål': ('angrepsmål',),
'angrepsmålet': ('angrepsmål',),
'angrepsmål': ('angrepsmål',),
'angrepsmåla': ('angrepsmål',),
'angrepsmålene': ('angrepsmål',),
'angrepsmåte': ('angrepsmåte',),
'angrepsmåten': ('angrepsmåte',),
'angrepsmåter': ('angrepsmåte',),
'angrepsmåtene': ('angrepsmåte',),
'angrepsplan': ('angrepsplan',),
'angrepsplanen': ('angrepsplan',),
'angrepsplaner': ('angrepsplan',),
'angrepsplanene': ('angrepsplan',),
'angrepspolitikk': ('angrepspolitikk',),
'angrepspolitikken': ('angrepspolitikk',),
'angrepspolitikker': ('angrepspolitikk',),
'angrepspolitikkene': ('angrepspolitikk',),
'angrepsposisjon': ('angrepsposisjon',),
'angrepsposisjonen': ('angrepsposisjon',),
'angrepsposisjoner': ('angrepsposisjon',),
'angrepsposisjonene': ('angrepsposisjon',),
'angrepspunkt': ('angrepspunkt',),
'angrepspunktet': ('angrepspunkt',),
'angrepspunkt': ('angrepspunkt',),
'angrepspunkter': ('angrepspunkt',),
'angrepspunkt': ('angrepspunkt',),
'angrepspunkter': ('angrepspunkt',),
'angrepspunkta': ('angrepspunkt',),
'angrepspunktene': ('angrepspunkt',),
'angrepsspeller': ('angrepsspeller',),
'angrepsspelleren': ('angrepsspeller',),
'angrepsspellere': ('angrepsspeller',),
'angrepsspellerne': ('angrepsspeller',),
'angrepsspiller': ('angrepsspiller',),
'angrepsspilleren': ('angrepsspiller',),
'angrepsspillere': ('angrepsspiller',),
'angrepsspillerne': ('angrepsspiller',),
'angrepsspiss': ('angrepsspiss',),
'angrepsspissen': ('angrepsspiss',),
'angrepsspisser': ('angrepsspiss',),
'angrepsspissene': ('angrepsspiss',),
'angriper': ('angriper',),
'angriperen': ('angriper',),
'angripere': ('angriper',),
'angriperne': ('angriper',),
'angriperstat': ('angriperstat',),
'angriperstaten': ('angriperstat',),
'angriperstater': ('angriperstat',),
'angriperstatene': ('angriperstat',),
'angst': ('angst',),
'angsten': ('angst',),
'angster': ('angst',),
'angstene': ('angst',),
'angstbiter': ('angstbiter',),
'angstbiteren': ('angstbiter',),
'angstbitere': ('angstbiter',),
'angstbiterne': ('angstbiter',),
'angstfordriver': ('angstfordriver',),
'angstfordriveren': ('angstfordriver',),
'angstfordrivere': ('angstfordriver',),
'angstfordriverne': ('angstfordriver',),
'angstneurose': ('angstneurose',),
'angstneurosen': ('angstneurose',),
'angstneuroser': ('angstneurose',),
'angstneurosene': ('angstneurose',),
'angstnevrose': ('angstnevrose',),
'angstnevrosen': ('angstnevrose',),
'angstnevroser': ('angstnevrose',),
'angstnevrosene': ('angstnevrose',),
'angstrop': ('angstrop',),
'angstropet': ('angstrop',),
'angstrop': ('angstrop',),
'angstropa': ('angstrop',),
'angstropene': ('angstrop',),
'angstskrik': ('angstskrik',),
'angstskriket': ('angstskrik',),
'angstskrik': ('angstskrik',),
'angstskrika': ('angstskrik',),
'angstskrikene': ('angstskrik',),
'angstsvette': ('angstsvette',),
'angstsvetten': ('angstsvette',),
'angstsvetter': ('angstsvette',),
'angstsvettene': ('angstsvette',),
'angsttilstand': ('angsttilstand',),
'angsttilstanden': ('angsttilstand',),
'angsttilstander': ('angsttilstand',),
'angsttilstandene': ('angsttilstand',),
'anhang': ('anhang',),
'anhanget': ('anhang',),
'anhang': ('anhang',),
'anhanga': ('anhang',),
'anhangene': ('anhang',),
'anheng': ('anheng',),
'anhenget': ('anheng',),
'anheng': ('anheng',),
'anhenga': ('anheng',),
'anhengene': ('anheng',),
'anholdelse': ('anholdelse',),
'anholdelsen': ('anholdelse',),
'anholdelser': ('anholdelse',),
'anholdelsene': ('anholdelse',),
'anhydrid': ('anhydrid',),
'anhydridet': ('anhydrid',),
'anhydrid': ('anhydrid',),
'anhydrider': ('anhydrid',),
'anhydrid': ('anhydrid',),
'anhydrider': ('anhydrid',),
'anhydrida': ('anhydrid',),
'anhydridene': ('anhydrid',),
'anhydritt': ('anhydritt',),
'anhydritten': ('anhydritt',),
'anhydritter': ('anhydritt',),
'anhydrittene': ('anhydritt',),
'anilin': ('anilin',),
'anilinet': ('anilin',),
'anilin': ('anilin',),
'anilina': ('anilin',),
'anilinene': ('anilin',),
'anilinblått': ('anilinblått',),
'anilinfarge': ('anilinfarge',),
'anilinfargen': ('anilinfarge',),
'anilinfarger': ('anilinfarge',),
'anilinfargene': ('anilinfarge',),
'anilinsvart': ('anilinsvart',),
'anilintrykk': ('anilintrykk',),
'anilintrykket': ('anilintrykk',),
'anilintrykk': ('anilintrykk',),
'anilintrykka': ('anilintrykk',),
'anilintrykkene': ('anilintrykk',),
'animalisme': ('animalisme',),
'animalismen': ('animalisme',),
'animalismer': ('animalisme',),
'animalismene': ('animalisme',),
'animasjon': ('animasjon',),
'animasjonen': ('animasjon',),
'animasjoner': ('animasjon',),
'animasjonene': ('animasjon',),
'animasjonsfilm': ('animasjonsfilm',),
'animasjonsfilmen': ('animasjonsfilm',),
'animasjonsfilmer': ('animasjonsfilm',),
'animasjonsfilmene': ('animasjonsfilm',),
'animatisme': ('animatisme',),
'animatismen': ('animatisme',),
'animatismer': ('animatisme',),
'animatismene': ('animatisme',),
'animatør': ('animatør',),
'animatøren': ('animatør',),
'animatører': ('animatør',),
'animatørene': ('animatør',),
'animisme': ('animisme',),
'animismen': ('animisme',),
'animismer': ('animisme',),
'animismene': ('animisme',),
'animositet': ('animositet',),
'animositeten': ('animositet',),
'animositeter': ('animositet',),
'animositetene': ('animositet',),
'aning': ('aning',),
'aningen': ('aning',),
'aninga': ('aning',),
'aninger': ('aning',),
'aningene': ('aning',),
'anion': ('anion',),
'anionet': ('anion',),
'anioner': ('anion',),
'aniona': ('anion',),
'anionene': ('anion',),
'anis': ('anis',),
'anisen': ('anis',),
'aniser': ('anis',),
'anisene': ('anis',),
'anisbrød': ('anisbrød',),
'anisbrødet': ('anisbrød',),
'anisbrød': ('anisbrød',),
'anisbrøda': ('anisbrød',),
'anisbrødene': ('anisbrød',),
'anisette': ('anisette',),
'anisetten': ('anisette',),
'anisetter': ('anisette',),
'anisettene': ('anisette',),
'anisfrø': ('anisfrø',),
'anisfrøet': ('anisfrø',),
'anisfrø': ('anisfrø',),
'anisfrøa': ('anisfrø',),
'anisfrøene': ('anisfrø',),
'aniskringle': ('aniskringle',),
'aniskringlen': ('aniskringle',),
'aniskringla': ('aniskringle',),
'aniskringler': ('aniskringle',),
'aniskringlene': ('aniskringle',),
'anislakris': ('anislakris',),
'anislakrisen': ('anislakris',),
'anislakriser': ('anislakris',),
'anislakrisene': ('anislakris',),
'anislikør': ('anislikør',),
'anislikøren': ('anislikør',),
'anislikører': ('anislikør',),
'anislikørene': ('anislikør',),
'ank': ('ank',),
'anken': ('ank',),
'anker': ('ank',),
'ankene': ('ank',),
'anke': ('anke',),
'anken': ('anke',),
'anker': ('anke',),
'ankene': ('anke',),
'ankedomstol': ('ankedomstol',),
'ankedomstolen': ('ankedomstol',),
'ankedomstoler': ('ankedomstol',),
'ankedomstolene': ('ankedomstol',),
'ankefrist': ('ankefrist',),
'ankefristen': ('ankefrist',),
'ankefrister': ('ankefrist',),
'ankefristene': ('ankefrist',),
'ankeinstans': ('ankeinstans',),
'ankeinstansen': ('ankeinstans',),
'ankeinstanser': ('ankeinstans',),
'ankeinstansene': ('ankeinstans',),
'ankel': ('ankel',),
'ankelen': ('ankel',),
'ankler': ('ankel',),
'anklene': ('ankel',),
'ankelknoke': ('ankelknoke',),
'ankelknoken': ('ankelknoke',),
'ankelknoker': ('ankelknoke',),
'ankelknokene': ('ankelknoke',),
'ankelknute': ('ankelknute',),
'ankelknuten': ('ankelknute',),
'ankelknuter': ('ankelknute',),
'ankelknutene': ('ankelknute',),
'ankelledd': ('ankelledd',),
'ankelleddet': ('ankelledd',),
'ankelledd': ('ankelledd',),
'ankelledda': ('ankelledd',),
'ankelleddene': ('ankelledd',),
'ankemål': ('ankemål',),
'ankemålet': ('ankemål',),
'ankemål': ('ankemål',),
'ankemåla': ('ankemål',),
'ankemålene': ('ankemål',),
'ankenemnd': ('ankenemnd',),
'ankenemnden': ('ankenemnd',),
'ankenemnda': ('ankenemnd',),
'ankenemnder': ('ankenemnd',),
'ankenemndene': ('ankenemnd',),
'ankepunkt': ('ankepunkt',),
'ankepunktet': ('ankepunkt',),
'ankepunkt': ('ankepunkt',),
'ankepunkter': ('ankepunkt',),
'ankepunkt': ('ankepunkt',),
'ankepunkter': ('ankepunkt',),
'ankepunkta': ('ankepunkt',),
'ankepunktene': ('ankepunkt',),
'anker': ('anker',),
'ankeret': ('anker',),
'ankret': ('anker',),
'ankeret': ('anker',),
'anker': ('anker',),
'ankere': ('anker',),
'ankre': ('anker',),
'ankera': ('anker',),
'ankra': ('anker',),
'ankrene': ('anker',),
'ankra': ('anker',),
'ankrene': ('anker',),
'ankerbøye': ('ankerbøye',),
'ankerbøyen': ('ankerbøye',),
'ankerbøyer': ('ankerbøye',),
'ankerbøyene': ('ankerbøye',),
'ankerfeste': ('ankerfeste',),
'ankerfestet': ('ankerfeste',),
'ankerfester': ('ankerfeste',),
'ankerfesta': ('ankerfeste',),
'ankerfestene': ('ankerfeste',),
'ankerfligg': ('ankerfligg',),
'ankerfliggen': ('ankerfligg',),
'ankerfligger': ('ankerfligg',),
'ankerfliggene': ('ankerfligg',),
'ankerkjetting': ('ankerkjetting',),
'ankerkjettingen': ('ankerkjetting',),
'ankerkjettinger': ('ankerkjetting',),
'ankerkjettingene': ('ankerkjetting',),
'ankerklo': ('ankerklo',),
'ankerkloen': ('ankerklo',),
'ankerkloa': ('ankerklo',),
'ankerklør': ('ankerklo',),
'ankerklørne': ('ankerklo',),
'ankerkvinne': ('ankerkvinne',),
'ankerkvinnen': ('ankerkvinne',),
'ankerkvinna': ('ankerkvinne',),
'ankerkvinner': ('ankerkvinne',),
'ankerkvinnene': ('ankerkvinne',),
'ankerlanterne': ('ankerlanterne',),
'ankerlanternen': ('ankerlanterne',),
'ankerlanterna': ('ankerlanterne',),
'ankerlanterner': ('ankerlanterne',),
'ankerlanternene': ('ankerlanterne',),
'ankermann': ('ankermann',),
'ankermannen': ('ankermann',),
'ankermenn': ('ankermann',),
'ankermennene': ('ankermann',),
'ankerplass': ('ankerplass',),
'ankerplassen': ('ankerplass',),
'ankerplasser': ('ankerplass',),
'ankerplassene': ('ankerplass',),
'ankerspill': ('ankerspill',),
'ankerspillet': ('ankerspill',),
'ankerspill': ('ankerspill',),
'ankerspilla': ('ankerspill',),
'ankerspillene': ('ankerspill',),
'ankesak': ('ankesak',),
'ankesaken': ('ankesak',),
'ankesaka': ('ankesak',),
'ankesaker': ('ankesak',),
'ankesakene': ('ankesak',),
'ankesum': ('ankesum',),
'ankesummen': ('ankesum',),
'ankesummer': ('ankesum',),
'ankesummene': ('ankesum',),
'anklage': ('anklage',),
'anklagen': ('anklage',),
'anklaga': ('anklage',),
'anklager': ('anklage',),
'anklagene': ('anklage',),
'anklagebenk': ('anklagebenk',),
'anklagebenken': ('anklagebenk',),
'anklagebenker': ('anklagebenk',),
'anklagebenkene': ('anklagebenk',),
'anklageprinsipp': ('anklageprinsipp',),
'anklageprinsippet': ('anklageprinsipp',),
'anklageprinsipp': ('anklageprinsipp',),
'anklageprinsipper': ('anklageprinsipp',),
'anklageprinsipp': ('anklageprinsipp',),
'anklageprinsipper': ('anklageprinsipp',),
'anklageprinsippa': ('anklageprinsipp',),
'anklageprinsippene': ('anklageprinsipp',),
'anklagepunkt': ('anklagepunkt',),
'anklagepunktet': ('anklagepunkt',),
'anklagepunkt': ('anklagepunkt',),
'anklagepunkter': ('anklagepunkt',),
'anklagepunkt': ('anklagepunkt',),
'anklagepunkter': ('anklagepunkt',),
'anklagepunkta': ('anklagepunkt',),
'anklagepunktene': ('anklagepunkt',),
'anklager': ('anklager',),
'anklageren': ('anklager',),
'anklagere': ('anklager',),
'anklagerne': ('anklager',),
'anklang': ('anklang',),
'anklangen': ('anklang',),
'anklanger': ('anklang',),
'anklangene': ('anklang',),
'ankomst': ('ankomst',),
'ankomsten': ('ankomst',),
'ankomster': ('ankomst',),
'ankomstene': ('ankomst',),
'ankomstdag': ('ankomstdag',),
'ankomstdagen': ('ankomstdag',),
'ankomstdager': ('ankomstdag',),
'ankomstdagene': ('ankomstdag',),
'ankomsthall': ('ankomsthall',),
'ankomsthallen': ('ankomsthall',),
'ankomsthaller': ('ankomsthall',),
'ankomsthallene': ('ankomsthall',),
'ankomsthavn': ('ankomsthavn',),
'ankomsthavnen': ('ankomsthavn',),
'ankomsthavna': ('ankomsthavn',),
'ankomsthavner': ('ankomsthavn',),
'ankomsthavnene': ('ankomsthavn',),
'ankomststed': ('ankomststed',),
'ankomststedet': ('ankomststed',),
'ankomststeder': ('ankomststed',),
'ankomststedene': ('ankomststed',),
'ankomsttavle': ('ankomsttavle',),
'ankomsttavlen': ('ankomsttavle',),
'ankomsttavla': ('ankomsttavle',),
'ankomsttavler': ('ankomsttavle',),
'ankomsttavlene': ('ankomsttavle',),
'ankomsttid': ('ankomsttid',),
'ankomsttiden': ('ankomsttid',),
'ankomsttida': ('ankomsttid',),
'ankomsttider': ('ankomsttid',),
'ankomsttidene': ('ankomsttid',),
'ankring': ('ankring',),
'ankringen': ('ankring',),
'ankringa': ('ankring',),
'ankringer': ('ankring',),
'ankringene': ('ankring',),
'ankringsplass': ('ankringsplass',),
'ankringsplassen': ('ankringsplass',),
'ankringsplasser': ('ankringsplass',),
'ankringsplassene': ('ankringsplass',),
'anledning': ('anledning',),
'anledningen': ('anledning',),
'anledninga': ('anledning',),
'anledninger': ('anledning',),
'anledningene': ('anledning',),
'anlegg': ('anlegg',),
'anlegget': ('anlegg',),
'anlegg': ('anlegg',),
'anlegga': ('anlegg',),
'anleggene': ('anlegg',),
'anleggsaktivum': ('anleggsaktivum',),
'anleggsaktivumet': ('anleggsaktivum',),
'anleggsaktiva': ('anleggsaktivum',),
'anleggsaktiver': ('anleggsaktivum',),
'anleggsaktivaene': ('anleggsaktivum',),
'anleggsaktiva': ('anleggsaktivum',),
'anleggsaktivene': ('anleggsaktivum',),
'anleggsarbeid': ('anleggsarbeid',),
'anleggsarbeidet': ('anleggsarbeid',),
'anleggsarbeid': ('anleggsarbeid',),
'anleggsarbeider': ('anleggsarbeid',),
'anleggsarbeid': ('anleggsarbeid',),
'anleggsarbeider': ('anleggsarbeid',),
'anleggsarbeida': ('anleggsarbeid',),
'anleggsarbeidene': ('anleggsarbeid',),
'anleggsarbeider': ('anleggsarbeider',),
'anleggsarbeideren': ('anleggsarbeider',),
'anleggsarbeidere': ('anleggsarbeider',),
'anleggsarbeiderne': ('anleggsarbeider',),
'anleggsgartner': ('anleggsgartner',),
'anleggsgartneren': ('anleggsgartner',),
'anleggsgartnere': ('anleggsgartner',),
'anleggsgartnerne': ('anleggsgartner',),
'anleggskapital': ('anleggskapital',),
'anleggskapitalen': ('anleggskapital',),
'anleggskapitaler': ('anleggskapital',),
'anleggskapitalene': ('anleggskapital',),
'anleggskostnad': ('anleggskostnad',),
'anleggskostnaden': ('anleggskostnad',),
'anleggskostnader': ('anleggskostnad',),
'anleggskostnadene': ('anleggskostnad',),
'anleggsmaskin': ('anleggsmaskin',),
'anleggsmaskinen': ('anleggsmaskin',),
'anleggsmaskiner': ('anleggsmaskin',),
'anleggsmaskinene': ('anleggsmaskin',),
'anleggsmiddel': ('anleggsmiddel',),
'anleggsmiddelet': ('anleggsmiddel',),
'anleggsmidlet': ('anleggsmiddel',),
'anleggsmiddel': ('anleggsmiddel',),
'anleggsmidler': ('anleggsmiddel',),
'anleggsmidla': ('anleggsmiddel',),
'anleggsmidlene': ('anleggsmiddel',),
'anleggsmidla': ('anleggsmiddel',),
'anleggsmidlene': ('anleggsmiddel',),
'anleggspreg': ('anleggspreg',),
'anleggspreget': ('anleggspreg',),
'anleggspreg': ('anleggspreg',),
'anleggsprega': ('anleggspreg',),
'anleggspregene': ('anleggspreg',),
'anleggsslusk': ('anleggsslusk',),
'anleggsslusken': ('anleggsslusk',),
'anleggsslusker': ('anleggsslusk',),
'anleggssluskene': ('anleggsslusk',),
'anleggsvirksomhet': ('anleggsvirksomhet',),
'anleggsvirksomheten': ('anleggsvirksomhet',),
'anleggsvirksomheta': ('anleggsvirksomhet',),
'anleggsvirksomheter': ('anleggsvirksomhet',),
'anleggsvirksomhetene': ('anleggsvirksomhet',),
'anliggende': ('anliggende',),
'anliggendet': ('anliggende',),
'anliggender': ('anliggende',),
'anliggendene': ('anliggende',),
'anløp': ('anløp',),
'anløpet': ('anløp',),
'anløp': ('anløp',),
'anløpa': ('anløp',),
'anløpene': ('anløp',),
'anløpshavn': ('anløpshavn',),
'anløpshavnen': ('anløpshavn',),
'anløpshavna': ('anløpshavn',),
'anløpshavner': ('anløpshavn',),
'anløpshavnene': ('anløpshavn',),
'anløpssted': ('anløpssted',),
'anløpsstedet': ('anløpssted',),
'anløpssteder': ('anløpssted',),
'anløpsstedene': ('anløpssted',),
'anløpstid': ('anløpstid',),
'anløpstiden': ('anløpstid',),
'anløpstida': ('anløpstid',),
'anløpstider': ('anløpstid',),
'anløpstidene': ('anløpstid',),
'anmarsj': ('anmarsj',),
'anmarsjen': ('anmarsj',),
'anmarsjer': ('anmarsj',),
'anmarsjene': ('anmarsj',),
'anmasselse': ('anmasselse',),
'anmasselsen': ('anmasselse',),
'anmasselser': ('anmasselse',),
'anmasselsene': ('anmasselse',),
'anmeldelse': ('anmeldelse',),
'anmeldelsen': ('anmeldelse',),
'anmeldelser': ('anmeldelse',),
'anmeldelsene': ('anmeldelse',),
'anmeldelsesfrist': ('anmeldelsesfrist',),
'anmeldelsesfristen': ('anmeldelsesfrist',),
'anmeldelsesfrister': ('anmeldelsesfrist',),
'anmeldelsesfristene': ('anmeldelsesfrist',),
'anmelder': ('anmelder',),
'anmelderen': ('anmelder',),
'anmeldere': ('anmelder',),
'anmelderne': ('anmelder',),
'anmeldereksemplar': ('anmeldereksemplar',),
'anmeldereksemplaret': ('anmeldereksemplar',),
'anmeldereksemplar': ('anmeldereksemplar',),
'anmeldereksemplarer': ('anmeldereksemplar',),
'anmeldereksemplar': ('anmeldereksemplar',),
'anmeldereksemplarer': ('anmeldereksemplar',),
'anmeldereksemplara': ('anmeldereksemplar',),
'anmeldereksemplarene': ('anmeldereksemplar',),
'anmeldervirksomhet': ('anmeldervirksomhet',),
'anmeldervirksomheten': ('anmeldervirksomhet',),
'anmeldervirksomheta': ('anmeldervirksomhet',),
'anmeldervirksomheter': ('anmeldervirksomhet',),
'anmeldervirksomhetene': ('anmeldervirksomhet',),
'anmerkning': ('anmerkning',),
'anmerkningen': ('anmerkning',),
'anmerkninga': ('anmerkning',),
'anmerkninger': ('anmerkning',),
'anmerkningene': ('anmerkning',),
'anmodning': ('anmodning',),
'anmodningen': ('anmodning',),
'anmodninga': ('anmodning',),
'anmodninger': ('anmodning',),
'anmodningene': ('anmodning',),
'annal': ('annal',),
'annalen': ('annal',),
'annaler': ('annal',),
'annalene': ('annal',),
'annalist': ('annalist',),
'annalisten': ('annalist',),
'annalister': ('annalist',),
'annalistene': ('annalist',),
'anneks': ('anneks',),
'annekset': ('anneks',),
'anneks': ('anneks',),
'annekser': ('anneks',),
'anneks': ('anneks',),
'annekser': ('anneks',),
'anneksa': ('anneks',),
'anneksene': ('anneks',),
'anneksbygning': ('anneksbygning',),
'anneksbygningen': ('anneksbygning',),
'anneksbygninga': ('anneksbygning',),
'anneksbygninger': ('anneksbygning',),
'anneksbygningene': ('anneksbygning',),
'anneksjon': ('anneksjon',),
'anneksjonen': ('anneksjon',),
'anneksjoner': ('anneksjon',),
'anneksjonene': ('anneksjon',),
'annekskirke': ('annekskirke',),
'annekskirken': ('annekskirke',),
'annekskirka': ('annekskirke',),
'annekskirker': ('annekskirke',),
'annekskirkene': ('annekskirke',),
'annekssogn': ('annekssogn',),
'annekssognet': ('annekssogn',),
'annekssogn': ('annekssogn',),
'annekssogna': ('annekssogn',),
'annekssognene': ('annekssogn',),
'annekssokn': ('annekssokn',),
'annekssoknen': ('annekssokn',),
'annekssoknet': ('annekssokn',),
'annekssokna': ('annekssokn',),
'annekssokner': ('annekssokn',),
'annekssokn': ('annekssokn',),
'annekssokner': ('annekssokn',),
'annekssoknene': ('annekssokn',),
'annekssokna': ('annekssokn',),
'annekssoknene': ('annekssokn',),
'annektering': ('annektering',),
'annekteringen': ('annektering',),
'annekteringa': ('annektering',),
'annekteringer': ('annektering',),
'annekteringene': ('annektering',),
'annendag': ('annendag',),
'annendagen': ('annendag',),
'annendager': ('annendag',),
'annendagene': ('annendag',),
'annenfiolin': ('annenfiolin',),
'annenfiolinen': ('annenfiolin',),
'annenfioliner': ('annenfiolin',),
'annenfiolinene': ('annenfiolin',),
'annengradsligning': ('annengradsligning',),
'annengradsligningen': ('annengradsligning',),
'annengradsligninga': ('annengradsligning',),
'annengradsligninger': ('annengradsligning',),
'annengradsligningene': ('annengradsligning',),
'annengradslikning': ('annengradslikning',),
'annengradslikningen': ('annengradslikning',),
'annengradslikninga': ('annengradslikning',),
'annengradslikninger': ('annengradslikning',),
'annengradslikningene': ('annengradslikning',),
'annenmann': ('annenmann',),
'annenmannen': ('annenmann',),
'annenmenn': ('annenmann',),
'annenmennene': ('annenmann',),
'annenmaskinist': ('annenmaskinist',),
'annenmaskinisten': ('annenmaskinist',),
'annenmaskinister': ('annenmaskinist',),
'annenmaskinistene': ('annenmaskinist',),
'annenplass': ('annenplass',),
'annenplassen': ('annenplass',),
'annenplasser': ('annenplass',),
'annenplassene': ('annenplass',),
'annenprioritet': ('annenprioritet',),
'annenprioriteten': ('annenprioritet',),
'annenprioriteter': ('annenprioritet',),
'annenprioritetene': ('annenprioritet',),
'annensortering': ('annensortering',),
'annensorteringen': ('annensortering',),
'annensorteringa': ('annensortering',),
'annensorteringer': ('annensortering',),
'annensorteringene': ('annensortering',),
'annenstemme': ('annenstemme',),
'annenstemmen': ('annenstemme',),
'annenstemmer': ('annenstemme',),
'annenstemmene': ('annenstemme',),
'annenstyrmann': ('annenstyrmann',),
'annenstyrmannen': ('annenstyrmann',),
'annenstyrmenn': ('annenstyrmann',),
'annenstyrmennene': ('annenstyrmann',),
'annerledestroende': ('annerledestroende',),
'annetgir': ('annetgir',),
'annetgiret': ('annetgir',),
'annetgir': ('annetgir',),
'annetgira': ('annetgir',),
'annetgirene': ('annetgir',),
'annleistroende': ('annleistroende',),
'annonse': ('annonse',),
'annonsen': ('annonse',),
'annonser': ('annonse',),
'annonsene': ('annonse',),
'annonseakkvisitør': ('annonseakkvisitør',),
'annonseakkvisitøren': ('annonseakkvisitør',),
'annonseakkvisitører': ('annonseakkvisitør',),
'annonseakkvisitørene': ('annonseakkvisitør',),
'annonsebyrå': ('annonsebyrå',),
'annonsebyrået': ('annonsebyrå',),
'annonsebyrå': ('annonsebyrå',),
'annonsebyråer': ('annonsebyrå',),
'annonsebyrå': ('annonsebyrå',),
'annonsebyråer': ('annonsebyrå',),
'annonsebyråa': ('annonsebyrå',),
'annonsebyråene': ('annonsebyrå',),
'annonsekampanje': ('annonsekampanje',),
'annonsekampanjen': ('annonsekampanje',),
'annonsekampanjer': ('annonsekampanje',),
'annonsekampanjene': ('annonsekampanje',),
'annonseside': ('annonseside',),
'annonsesiden': ('annonseside',),
'annonsesida': ('annonseside',),
'annonsesider': ('annonseside',),
'annonsesidene': ('annonseside',),
'annonsespalte': ('annonsespalte',),
'annonsespalten': ('annonsespalte',),
'annonsespalta': ('annonsespalte',),
'annonsespalter': ('annonsespalte',),
'annonsespaltene': ('annonsespalte',),
'annonsør': ('annonsør',),
'annonsøren': ('annonsør',),
'annonsører': ('annonsør',),
'annonsørene': ('annonsør',),
'annuitet': ('annuitet',),
'annuiteten': ('annuitet',),
'annuiteter': ('annuitet',),
'annuitetene': ('annuitet',),
'annuitetslån': ('annuitetslån',),
'annuitetslånet': ('annuitetslån',),
'annuitetslån': ('annuitetslån',),
'annuitetslåna': ('annuitetslån',),
'annuitetslånene': ('annuitetslån',),
'annuitetsregning': ('annuitetsregning',),
'annuitetsregningen': ('annuitetsregning',),
'annuitetsregninga': ('annuitetsregning',),
'annuitetsregninger': ('annuitetsregning',),
'annuitetsregningene': ('annuitetsregning',),
'annuitetstabell': ('annuitetstabell',),
'annuitetstabellen': ('annuitetstabell',),
'annuitetstabeller': ('annuitetstabell',),
'annuitetstabellene': ('annuitetstabell',),
'annuum': ('annuum',),
'annuumet': ('annuum',),
'annua': ('annuum',),
'annuaene': ('annuum',),
'anode': ('anode',),
'anoden': ('anode',),
'anoder': ('anode',),
'anodene': ('anode',),
'anodebatteri': ('anodebatteri',),
'anodebatteriet': ('anodebatteri',),
'anodebatteri': ('anodebatteri',),
'anodebatterier': ('anodebatteri',),
'anodebatteri': ('anodebatteri',),
'anodebatterier': ('anodebatteri',),
'anodebatteria': ('anodebatteri',),
'anodebatteriene': ('anodebatteri',),
'anodespenning': ('anodespenning',),
'anodespenningen': ('anodespenning',),
'anodespenninga': ('anodespenning',),
'anodespenninger': ('anodespenning',),
'anodespenningene': ('anodespenning',),
'anodestrøm': ('anodestrøm',),
'anodestrømmen': ('anodestrøm',),
'anodestrømmer': ('anodestrøm',),
'anodestrømmene': ('anodestrøm',),
'anomali': ('anomali',),
'anomalien': ('anomali',),
'anomalier': ('anomali',),
'anomaliene': ('anomali',),
'anonym': ('anonym',),
'anonymet': ('anonym',),
'anonym': ('anonym',),
'anonymer': ('anonym',),
'anonym': ('anonym',),
'anonymer': ('anonym',),
'anonyma': ('anonym',),
'anonymene': ('anonym',),
'anonymitet': ('anonymitet',),
'anonymiteten': ('anonymitet',),
'anonymiteter': ('anonymitet',),
'anonymitetene': ('anonymitet',),
'anorakk': ('anorakk',),
'anorakken': ('anorakk',),
'anorakker': ('anorakk',),
'anorakkene': ('anorakk',),
'anorakkhette': ('anorakkhette',),
'anorakkhetten': ('anorakkhette',),
'anorakkhetta': ('anorakkhette',),
'anorakkhetter': ('anorakkhette',),
'anorakkhettene': ('anorakkhette',),
'anordning': ('anordning',),
'anordningen': ('anordning',),
'anordninga': ('anordning',),
'anordninger': ('anordning',),
'anordningene': ('anordning',),
'anoreksi': ('anoreksi',),
'anoreksien': ('anoreksi',),
'anoreksier': ('anoreksi',),
'anoreksiene': ('anoreksi',),
'anorektiker': ('anorektiker',),
'anorektikeren': ('anorektiker',),
'anorektikere': ('anorektiker',),
'anorektikerne': ('anorektiker',),
'anorexia nervosa': ('anorexia nervosa',),
'anretning': ('anretning',),
'anretningen': ('anretning',),
'anretninga': ('anretning',),
'anretninger': ('anretning',),
'anretningene': ('anretning',),
'anretningsbord': ('anretningsbord',),
'anretningsbordet': ('anretningsbord',),
'anretningsbord': ('anretningsbord',),
'anretningsborder': ('anretningsbord',),
'anretningsbord': ('anretningsbord',),
'anretningsborder': ('anretningsbord',),
'anretningsborda': ('anretningsbord',),
'anretningsbordene': ('anretningsbord',),
'anretningsfat': ('anretningsfat',),
'anretningsfatet': ('anretningsfat',),
'anretningsfat': ('anretningsfat',),
'anretningsfater': ('anretningsfat',),
'anretningsfat': ('anretningsfat',),
'anretningsfater': ('anretningsfat',),
'anretningsfata': ('anretningsfat',),
'anretningsfatene': ('anretningsfat',),
'anretningsrom': ('anretningsrom',),
'anretningsrommet': ('anretningsrom',),
'anretningsrom': ('anretningsrom',),
'anretningsromma': ('anretningsrom',),
'anretningsrommene': ('anretningsrom',),
'anrettelse': ('anrettelse',),
'anrettelsen': ('anrettelse',),
'anrettelser': ('anrettelse',),
'anrettelsene': ('anrettelse',),
'anriking': ('anriking',),
'anrikingen': ('anriking',),
'anrikinga': ('anriking',),
'anrikinger': ('anriking',),
'anrikingene': ('anriking',),
'anrikning': ('anrikning',),
'anrikningen': ('anrikning',),
'anrikninga': ('anrikning',),
'anrikninger': ('anrikning',),
'anrikningene': ('anrikning',),
'anrop': ('anrop',),
'anropet': ('anrop',),
'anrop': ('anrop',),
'anropa': ('anrop',),
'anropene': ('anrop',),
'ans': ('ans',),
'ansen': ('ans',),
'anser': ('ans',),
'ansene': ('ans',),
'ansamling': ('ansamling',),
'ansamlingen': ('ansamling',),
'ansamlinga': ('ansamling',),
'ansamlinger': ('ansamling',),
'ansamlingene': ('ansamling',),
'ansats': ('ansats',),
'ansatsen': ('ansats',),
'ansatser': ('ansats',),
'ansatsene': ('ansats',),
'anseelse': ('anseelse',),
'anseelsen': ('anseelse',),
'anseelser': ('anseelse',),
'anseelsene': ('anseelse',),
'ansettelse': ('ansettelse',),
'ansettelsen': ('ansettelse',),
'ansettelser': ('ansettelse',),
'ansettelsene': ('ansettelse',),
'ansettelsesmyndighet': ('ansettelsesmyndighet',),
'ansettelsesmyndigheten': ('ansettelsesmyndighet',),
'ansettelsesmyndigheta': ('ansettelsesmyndighet',),
'ansettelsesmyndigheter': ('ansettelsesmyndighet',),
'ansettelsesmyndighetene': ('ansettelsesmyndighet',),
'ansettelsesrett': ('ansettelsesrett',),
'ansettelsesretten': ('ansettelsesrett',),
'ansettelsesretter': ('ansettelsesrett',),
'ansettelsesrettene': ('ansettelsesrett',),
'ansettelsesråd': ('ansettelsesråd',),
'ansettelsesrådet': ('ansettelsesråd',),
'ansettelsesråd': ('ansettelsesråd',),
'ansettelsesråda': ('ansettelsesråd',),
'ansettelsesrådene': ('ansettelsesråd',),
'ansettelsesstopp': ('ansettelsesstopp',),
'ansettelsesstoppen': ('ansettelsesstopp',),
'ansettelsesstoppet': ('ansettelsesstopp',),
'ansettelsesstopp': ('ansettelsesstopp',),
'ansettelsesstoppene': ('ansettelsesstopp',),
'ansettelsesstoppa': ('ansettelsesstopp',),
'ansettelsesstoppene': ('ansettelsesstopp',),
'ansettelsesvilkår': ('ansettelsesvilkår',),
'ansettelsesvilkåret': ('ansettelsesvilkår',),
'ansettelsesvilkår': ('ansettelsesvilkår',),
'ansettelsesvilkåra': ('ansettelsesvilkår',),
'ansettelsesvilkårene': ('ansettelsesvilkår',),
'ansiennitet': ('ansiennitet',),
'ansienniteten': ('ansiennitet',),
'ansienniteter': ('ansiennitet',),
'ansiennitetene': ('ansiennitet',),
'ansikt': ('ansikt',),
'ansiktet': ('ansikt',),
'ansikt': ('ansikt',),
'ansikter': ('ansikt',),
'ansikt': ('ansikt',),
'ansikter': ('ansikt',),
'ansikta': ('ansikt',),
'ansiktene': ('ansikt',),
'ansiktsbehandling': ('ansiktsbehandling',),
'ansiktsbehandlingen': ('ansiktsbehandling',),
'ansiktsbehandlinga': ('ansiktsbehandling',),
'ansiktsbehandlinger': ('ansiktsbehandling',),
'ansiktsbehandlingene': ('ansiktsbehandling',),
'ansiktsdrag': ('ansiktsdrag',),
'ansiktsdraget': ('ansiktsdrag',),
'ansiktsdrag': ('ansiktsdrag',),
'ansiktsdraga': ('ansiktsdrag',),
'ansiktsdragene': ('ansiktsdrag',),
'ansiktsfarge': ('ansiktsfarge',),
'ansiktsfargen': ('ansiktsfarge',),
'ansiktsfarger': ('ansiktsfarge',),
'ansiktsfargene': ('ansiktsfarge',),
'ansiktsform': ('ansiktsform',),
'ansiktsformen': ('ansiktsform',),
'ansiktsforma': ('ansiktsform',),
'ansiktsformer': ('ansiktsform',),
'ansiktsformene': ('ansiktsform',),
'ansiktsløftning': ('ansiktsløftning',),
'ansiktsløftningen': ('ansiktsløftning',),
'ansiktsløftninga': ('ansiktsløftning',),
'ansiktsløftninger': ('ansiktsløftning',),
'ansiktsløftningene': ('ansiktsløftning',),
'ansiktsmaske': ('ansiktsmaske',),
'ansiktsmasken': ('ansiktsmaske',),
'ansiktsmaska': ('ansiktsmaske',),
'ansiktsmasker': ('ansiktsmaske',),
'ansiktsmaskene': ('ansiktsmaske',),
'ansiktsmassasje': ('ansiktsmassasje',),
'ansiktsmassasjen': ('ansiktsmassasje',),
'ansiktsmassasjer': ('ansiktsmassasje',),
'ansiktsmassasjene': ('ansiktsmassasje',),
'ansiktspleie': ('ansiktspleie',),
'ansiktspleien': ('ansiktspleie',),
'ansiktspleia': ('ansiktspleie',),
'ansiktspleier': ('ansiktspleie',),
'ansiktspleiene': ('ansiktspleie',),
'ansiktsprofil': ('ansiktsprofil',),
'ansiktsprofilen': ('ansiktsprofil',),
'ansiktsprofiler': ('ansiktsprofil',),
'ansiktsprofilene': ('ansiktsprofil',),
'ansiktstrekk': ('ansiktstrekk',),
'ansiktstrekket': ('ansiktstrekk',),
'ansiktstrekk': ('ansiktstrekk',),
'ansiktstrekka': ('ansiktstrekk',),
'ansiktstrekkene': ('ansiktstrekk',),
'ansiktsuttrykk': ('ansiktsuttrykk',),
'ansiktsuttrykket': ('ansiktsuttrykk',),
'ansiktsuttrykk': ('ansiktsuttrykk',),
'ansiktsuttrykka': ('ansiktsuttrykk',),
'ansiktsuttrykkene': ('ansiktsuttrykk',),
'ansjos': ('ansjos',),
'ansjosen': ('ansjos',),
'ansjoser': ('ansjos',),
'ansjosene': ('ansjos',),
'ansjosboks': ('ansjosboks',),
'ansjosboksen': ('ansjosboks',),
'ansjosbokser': ('ansjosboks',),
'ansjosboksene': ('ansjosboks',),
'ansjosbrisling': ('ansjosbrisling',),
'ansjosbrislingen': ('ansjosbrisling',),
'ansjosbrislinger': ('ansjosbrisling',),
'ansjosbrislingene': ('ansjosbrisling',),
'ansjosfilet': ('ansjosfilet',),
'ansjosfileten': ('ansjosfilet',),
'ansjosfileter': ('ansjosfilet',),
'ansjosfiletene': ('ansjosfilet',),
'anskaffelse': ('anskaffelse',),
'anskaffelsen': ('anskaffelse',),
'anskaffelser': ('anskaffelse',),
'anskaffelsene': ('anskaffelse',),
'anskaffelsesomkostning': ('anskaffelsesomkostning',),
'anskaffelsesomkostningen': ('anskaffelsesomkostning',),
'anskaffelsesomkostninga': ('anskaffelsesomkostning',),
'anskaffelsesomkostninger': ('anskaffelsesomkostning',),
'anskaffelsesomkostningene': ('anskaffelsesomkostning',),
'anskaffelsespris': ('anskaffelsespris',),
'anskaffelsesprisen': ('anskaffelsespris',),
'anskaffelsespriser': ('anskaffelsespris',),
'anskaffelsesprisene': ('anskaffelsespris',),
'anskaffelsesverdi': ('anskaffelsesverdi',),
'anskaffelsesverdien': ('anskaffelsesverdi',),
'anskaffelsesverdier': ('anskaffelsesverdi',),
'anskaffelsesverdiene': ('anskaffelsesverdi',),
'anskott': ('anskott',),
'anskottet': ('anskott',),
'anskott': ('anskott',),
'anskotta': ('anskott',),
'anskottene': ('anskott',),
'anskrik': ('anskrik',),
'anskriket': ('anskrik',),
'anskrik': ('anskrik',),
'anskrika': ('anskrik',),
'anskrikene': ('anskrik',),
'anskudd': ('anskudd',),
'anskuddet': ('anskudd',),
'anskudd': ('anskudd',),
'anskudda': ('anskudd',),
'anskuddene': ('anskudd',),
'anskuelse': ('anskuelse',),
'anskuelsen': ('anskuelse',),
'anskuelser': ('anskuelse',),
'anskuelsene': ('anskuelse',),
'anskuelsesevne': ('anskuelsesevne',),
'anskuelsesevnen': ('anskuelsesevne',),
'anskuelsesevna': ('anskuelsesevne',),
'anskuelsesevner': ('anskuelsesevne',),
'anskuelsesevnene': ('anskuelsesevne',),
'anskuelsesform': ('anskuelsesform',),
'anskuelsesformen': ('anskuelsesform',),
'anskuelsesforma': ('anskuelsesform',),
'anskuelsesformer': ('anskuelsesform',),
'anskuelsesformene': ('anskuelsesform',),
'anskuelsesmåte': ('anskuelsesmåte',),
'anskuelsesmåten': ('anskuelsesmåte',),
'anskuelsesmåter': ('anskuelsesmåte',),
'anskuelsesmåtene': ('anskuelsesmåte',),
'anskuelsesundervisning': ('anskuelsesundervisning',),
'anskuelsesundervisningen': ('anskuelsesundervisning',),
'anskuelsesundervisninga': ('anskuelsesundervisning',),
'anskuelsesundervisninger': ('anskuelsesundervisning',),
'anskuelsesundervisningene': ('anskuelsesundervisning',),
'anslag': ('anslag',),
'anslaget': ('anslag',),
'anslag': ('anslag',),
'anslaga': ('anslag',),
'anslagene': ('anslag',),
'anslagshastighet': ('anslagshastighet',),
'anslagshastigheten': ('anslagshastighet',),
'anslagshastigheta': ('anslagshastighet',),
'anslagshastigheter': ('anslagshastighet',),
'anslagshastighetene': ('anslagshastighet',),
'anslagskraft': ('anslagskraft',),
'anslagskraften': ('anslagskraft',),
'anslagskrafta': ('anslagskraft',),
'anslagskrefter': ('anslagskraft',),
'anslagskreftene': ('anslagskraft',),
'anspennelse': ('anspennelse',),
'anspennelsen': ('anspennelse',),
'anspennelser': ('anspennelse',),
'anspennelsene': ('anspennelse',),
'anspenthet': ('anspenthet',),
'anspentheten': ('anspenthet',),
'anspentheta': ('anspenthet',),
'anspentheter': ('anspenthet',),
'anspenthetene': ('anspenthet',),
'anstalt': ('anstalt',),
'anstalten': ('anstalt',),
'anstalter': ('anstalt',),
'anstaltene': ('anstalt',),
'anstalthusholdning': ('anstalthusholdning',),
'anstalthusholdningen': ('anstalthusholdning',),
'anstalthusholdninga': ('anstalthusholdning',),
'anstalthusholdninger': ('anstalthusholdning',),
'anstalthusholdningene': ('anstalthusholdning',),
'anstaltmaker': ('anstaltmaker',),
'anstaltmakeren': ('anstaltmaker',),
'anstaltmakere': ('anstaltmaker',),
'anstaltmakerne': ('anstaltmaker',),
'anstaltmakeri': ('anstaltmakeri',),
'anstaltmakeriet': ('anstaltmakeri',),
'anstaltmakeri': ('anstaltmakeri',),
'anstaltmakerier': ('anstaltmakeri',),
'anstaltmakeri': ('anstaltmakeri',),
'anstaltmakerier': ('anstaltmakeri',),
'anstaltmakeria': ('anstaltmakeri',),
'anstaltmakeriene': ('anstaltmakeri',),
'anstand': ('anstand',),
'anstanden': ('anstand',),
'anstander': ('anstand',),
'anstandene': ('anstand',),
'anstendighet': ('anstendighet',),
'anstendigheten': ('anstendighet',),
'anstendigheta': ('anstendighet',),
'anstendigheter': ('anstendighet',),
'anstendighetene': ('anstendighet',),
'anstendighetsfølelse': ('anstendighetsfølelse',),
'anstendighetsfølelsen': ('anstendighetsfølelse',),
'anstendighetsfølelser': ('anstendighetsfølelse',),
'anstendighetsfølelsene': ('anstendighetsfølelse',),
'anstendighetskjensle': ('anstendighetskjensle',),
'anstendighetskjenslen': ('anstendighetskjensle',),
'anstendighetskjensla': ('anstendighetskjensle',),
'anstendighetskjensler': ('anstendighetskjensle',),
'anstendighetskjenslene': ('anstendighetskjensle',),
'anstrengelse': ('anstrengelse',),
'anstrengelsen': ('anstrengelse',),
'anstrengelser': ('anstrengelse',),
'anstrengelsene': ('anstrengelse',),
'anstrøk': ('anstrøk',),
'anstrøket': ('anstrøk',),
'anstrøk': ('anstrøk',),
'anstrøka': ('anstrøk',),
'anstrøkene': ('anstrøk',),
'anstøt': ('anstøt',),
'anstøtet': ('anstøt',),
'anstøt': ('anstøt',),
'anstøta': ('anstøt',),
'anstøtene': ('anstøt',),
'anstøtsstein': ('anstøtsstein',),
'anstøtssteinen': ('anstøtsstein',),
'anstøtssteiner': ('anstøtsstein',),
'anstøtssteinene': ('anstøtsstein',),
'ansvar': ('ansvar',),
'ansvaret': ('ansvar',),
'ansvar': ('ansvar',),
'ansvara': ('ansvar',),
'ansvarene': ('ansvar',),
'ansvarsforhold': ('ansvarsforhold',),
'ansvarsforholdet': ('ansvarsforhold',),
'ansvarsforhold': ('ansvarsforhold',),
'ansvarsforholda': ('ansvarsforhold',),
'ansvarsforholdene': ('ansvarsforhold',),
'ansvarsforsikring': ('ansvarsforsikring',),
'ansvarsforsikringen': ('ansvarsforsikring',),
'ansvarsforsikringa': ('ansvarsforsikring',),
'ansvarsforsikringer': ('ansvarsforsikring',),
'ansvarsforsikringene': ('ansvarsforsikring',),
'ansvarsfølelse': ('ansvarsfølelse',),
'ansvarsfølelsen': ('ansvarsfølelse',),
'ansvarsfølelser': ('ansvarsfølelse',),
'ansvarsfølelsene': ('ansvarsfølelse',),
'ansvarsområde': ('ansvarsområde',),
'ansvarsområdet': ('ansvarsområde',),
'ansvarsområder': ('ansvarsområde',),
'ansvarsområda': ('ansvarsområde',),
'ansvarsområdene': ('ansvarsområde',),
'ansøker': ('ansøker',),
'ansøkeren': ('ansøker',),
'ansøkere': ('ansøker',),
'ansøkerne': ('ansøker',),
'ansøkning': ('ansøkning',),
'ansøkningen': ('ansøkning',),
'ansøkninga': ('ansøkning',),
'ansøkninger': ('ansøkning',),
'ansøkningene': ('ansøkning',),
'ansøkningsskjema': ('ansøkningsskjema',),
'ansøkningsskjemaet': ('ansøkningsskjema',),
'ansøkningsskjema': ('ansøkningsskjema',),
'ansøkningsskjemaer': ('ansøkningsskjema',),
'ansøkningsskjemaene': ('ansøkningsskjema',),
'antabus': ('antabus',),
'antabusen': ('antabus',),
'antabuser': ('antabus',),
'antabusene': ('antabus',),
'antabuskur': ('antabuskur',),
'antabuskuren': ('antabuskur',),
'antabuskurer': ('antabuskur',),
'antabuskurene': ('antabuskur',),
'antabuspille': ('antabuspille',),
'antabuspillen': ('antabuspille',),
'antabuspilla': ('antabuspille',),
'antabuspiller': ('antabuspille',),
'antabuspillene': ('antabuspille',),
'antabustablett': ('antabustablett',),
'antabustabletten': ('antabustablett',),
'antabustabletter': ('antabustablett',),
'antabustablettene': ('antabustablett',),
'antagonisme': ('antagonisme',),
'antagonismen': ('antagonisme',),
'antagonismer': ('antagonisme',),
'antagonismene': ('antagonisme',),
'antagonist': ('antagonist',),
'antagonisten': ('antagonist',),
'antagonister': ('antagonist',),
'antagonistene': ('antagonist',),
'antakelse': ('antakelse',),
'antakelsen': ('antakelse',),
'antakelser': ('antakelse',),
'antakelsene': ('antakelse',),
'antall': ('antall',),
'antallet': ('antall',),
'antall': ('antall',),
'antalla': ('antall',),
'antallene': ('antall',),
'antegnelse': ('antegnelse',),
'antegnelsen': ('antegnelse',),
'antegnelser': ('antegnelse',),
'antegnelsene': ('antegnelse',),
'antegning': ('antegning',),
'antegningen': ('antegning',),
'antegninga': ('antegning',),
'antegninger': ('antegning',),
'antegningene': ('antegning',),
'antemensale': ('antemensale',),
'antemensalet': ('antemensale',),
'antemensaler': ('antemensale',),
'antemensala': ('antemensale',),
'antemensalene': ('antemensale',),
'antenne': ('antenne',),
'antennen': ('antenne',),
'antenna': ('antenne',),
'antenner': ('antenne',),
'antennene': ('antenne',),
'antennekobling': ('antennekobling',),
'antennekoblingen': ('antennekobling',),
'antennekoblinga': ('antennekobling',),
'antennekoblinger': ('antennekobling',),
'antennekoblingene': ('antennekobling',),
'antennekopling': ('antennekopling',),
'antennekoplingen': ('antennekopling',),
'antennekoplinga': ('antennekopling',),
'antennekoplinger': ('antennekopling',),
'antennekoplingene': ('antennekopling',),
'antennekrets': ('antennekrets',),
'antennekretsen': ('antennekrets',),
'antennekretser': ('antennekrets',),
'antennekretsene': ('antennekrets',),
'antenneledning': ('antenneledning',),
'antenneledningen': ('antenneledning',),
'antenneledninga': ('antenneledning',),
'antenneledninger': ('antenneledning',),
'antenneledningene': ('antenneledning',),
'antennelse': ('antennelse',),
'antennelsen': ('antennelse',),
'antennelser': ('antennelse',),
'antennelsene': ('antennelse',),
'antennelsestemperatur': ('antennelsestemperatur',),
'antennelsestemperaturen': ('antennelsestemperatur',),
'antennelsestemperaturer': ('antennelsestemperatur',),
'antennelsestemperaturene': ('antennelsestemperatur',),
'antennestøy': ('antennestøy',),
'antennestøyen': ('antennestøy',),
'antennestøyer': ('antennestøy',),
'antennestøyene': ('antennestøy',),
'antenneuttak': ('antenneuttak',),
'antenneuttaket': ('antenneuttak',),
'antenneuttak': ('antenneuttak',),
'antenneuttaka': ('antenneuttak',),
'antenneuttakene': ('antenneuttak',),
'antependium': ('antependium',),
'antependiet': ('antependium',),
'antependier': ('antependium',),
'antependia': ('antependium',),
'antependiene': ('antependium',),
'antesipasjon': ('antesipasjon',),
'antesipasjonen': ('antesipasjon',),
'antesipasjoner': ('antesipasjon',),
'antesipasjonene': ('antesipasjon',),
'antibiotikum': ('antibiotikum',),
'antibiotikumet': ('antibiotikum',),
'antibiotika': ('antibiotikum',),
'antibiotikaene': ('antibiotikum',),
'antifebrin': ('antifebrin',),
'antifebrinet': ('antifebrin',),
'antifebrin': ('antifebrin',),
'antifebrina': ('antifebrin',),
'antifebrinene': ('antifebrin',),
'antigen': ('antigen',),
'antigenet': ('antigen',),
'antigen': ('antigen',),
'antigener': ('antigen',),
'antigen': ('antigen',),
'antigener': ('antigen',),
'antigena': ('antigen',),
'antigenene': ('antigen',),
'antiguaner': ('antiguaner',),
'antiguaneren': ('antiguaner',),
'antiguanere': ('antiguaner',),
'antiguanerne': ('antiguaner',),
'antihelt': ('antihelt',),
'antihelten': ('antihelt',),
'antihelter': ('antihelt',),
'antiheltene': ('antihelt',),
'antiimperialisme': ('antiimperialisme',),
'antiimperialismen': ('antiimperialisme',),
'antiimperialismer': ('antiimperialisme',),
'antiimperialismene': ('antiimperialisme',),
'antikk': ('antikk',),
'antikken': ('antikk',),
'antikker': ('antikk',),
'antikkene': ('antikk',),
'antikksamling': ('antikksamling',),
'antikksamlingen': ('antikksamling',),
'antikksamlinga': ('antikksamling',),
'antikksamlinger': ('antikksamling',),
'antikksamlingene': ('antikksamling',),
'antiklimaks': ('antiklimaks',),
'antiklimaksen': ('antiklimaks',),
'antiklimakset': ('antiklimaks',),
'antiklimakser': ('antiklimaks',),
'antiklimaks': ('antiklimaks',),
'antiklimakser': ('antiklimaks',),
'antiklimaks': ('antiklimaks',),
'antiklimakser': ('antiklimaks',),
'antiklimaksene': ('antiklimaks',),
'antiklimaksa': ('antiklimaks',),
'antiklimaksene': ('antiklimaks',),
'antikommunisme': ('antikommunisme',),
'antikommunismen': ('antikommunisme',),
'antikommunismer': ('antikommunisme',),
'antikommunismene': ('antikommunisme',),
'antikommunist': ('antikommunist',),
'antikommunisten': ('antikommunist',),
'antikommunister': ('antikommunist',),
'antikommunistene': ('antikommunist',),
'antikonsepsjon': ('antikonsepsjon',),
'antikonsepsjonen': ('antikonsepsjon',),
'antikonsepsjoner': ('antikonsepsjon',),
'antikonsepsjonene': ('antikonsepsjon',),
'antikrist': ('antikrist',),
'antikristen': ('antikrist',),
'antikrister': ('antikrist',),
'antikristene': ('antikrist',),
'antikva': ('antikva',),
'antikvaen': ('antikva',),
'antikvaer': ('antikva',),
'antikvaene': ('antikva',),
'antikvar': ('antikvar',),
'antikvaren': ('antikvar',),
'antikvarer': ('antikvar',),
'antikvarene': ('antikvar',),
'antikvarbokhandel': ('antikvarbokhandel',),
'antikvarbokhandelen': ('antikvarbokhandel',),
'antikvarbokhandler': ('antikvarbokhandel',),
'antikvarbokhandlene': ('antikvarbokhandel',),
'antikvarbokhandler': ('antikvarbokhandler',),
'antikvarbokhandleren': ('antikvarbokhandler',),
'antikvarbokhandlere': ('antikvarbokhandler',),
'antikvarbokhandlerne': ('antikvarbokhandler',),
'antikvariat': ('antikvariat',),
'antikvariatet': ('antikvariat',),
'antikvariat': ('antikvariat',),
'antikvariater': ('antikvariat',),
'antikvariat': ('antikvariat',),
'antikvariater': ('antikvariat',),
'antikvariata': ('antikvariat',),
'antikvariatene': ('antikvariat',),
'antikvitet': ('antikvitet',),
'antikviteten': ('antikvitet',),
'antikviteter': ('antikvitet',),
'antikvitetene': ('antikvitet',),
'antikvitetshandel': ('antikvitetshandel',),
'antikvitetshandelen': ('antikvitetshandel',),
'antikvitetshandler': ('antikvitetshandel',),
'antikvitetshandlene': ('antikvitetshandel',),
'antikvitetshandler': ('antikvitetshandler',),
'antikvitetshandleren': ('antikvitetshandler',),
'antikvitetshandlere': ('antikvitetshandler',),
'antikvitetshandlerne': ('antikvitetshandler',),
'antikvitetssamler': ('antikvitetssamler',),
'antikvitetssamleren': ('antikvitetssamler',),
'antikvitetssamlere': ('antikvitetssamler',),
'antikvitetssamlerne': ('antikvitetssamler',),
'antikvitetssamling': ('antikvitetssamling',),
'antikvitetssamlingen': ('antikvitetssamling',),
'antikvitetssamlinga': ('antikvitetssamling',),
'antikvitetssamlinger': ('antikvitetssamling',),
'antikvitetssamlingene': ('antikvitetssamling',),
'antilogaritme': ('antilogaritme',),
'antilogaritmen': ('antilogaritme',),
'antilogaritmer': ('antilogaritme',),
'antilogaritmene': ('antilogaritme',),
'antilope': ('antilope',),
'antilopen': ('antilope',),
'antiloper': ('antilope',),
'antilopene': ('antilope',),
'antiluftskyts': ('antiluftskyts',),
'antiluftskytset': ('antiluftskyts',),
'antiluftskyts': ('antiluftskyts',),
'antiluftskytsa': ('antiluftskyts',),
'antiluftskytsene': ('antiluftskyts',),
'antimakassar': ('antimakassar',),
'antimakassaren': ('antimakassar',),
'antimakassarer': ('antimakassar',),
'antimakassarene': ('antimakassar',),
'antimilitarisme': ('antimilitarisme',),
'antimilitarismen': ('antimilitarisme',),
'antimilitarismer': ('antimilitarisme',),
'antimilitarismene': ('antimilitarisme',),
'antimilitarist': ('antimilitarist',),
'antimilitaristen': ('antimilitarist',),
'antimilitarister': ('antimilitarist',),
'antimilitaristene': ('antimilitarist',),
'antimon': ('antimon',),
'antimonet': ('antimon',),
'antimon': ('antimon',),
'antimona': ('antimon',),
'antimonene': ('antimon',),
'antimonblende': ('antimonblende',),
'antimonblenden': ('antimonblende',),
'antimonblender': ('antimonblende',),
'antimonblendene': ('antimonblende',),
'antimonglans': ('antimonglans',),
'antimonglansen': ('antimonglans',),
'antimonglanser': ('antimonglans',),
'antimonglansene': ('antimonglans',),
'antinomi': ('antinomi',),
'antinomien': ('antinomi',),
'antinomier': ('antinomi',),
'antinomiene': ('antinomi',),
'antipartikkel': ('antipartikkel',),
'antipartikkelen': ('antipartikkel',),
'antipartikler': ('antipartikkel',),
'antipartiklene': ('antipartikkel',),
'antipassat': ('antipassat',),
'antipassaten': ('antipassat',),
'antipassater': ('antipassat',),
'antipassatene': ('antipassat',),
'antipati': ('antipati',),
'antipatien': ('antipati',),
'antipatier': ('antipati',),
'antipatiene': ('antipati',),
'antiperspirant': ('antiperspirant',),
'antiperspiranten': ('antiperspirant',),
'antiperspiranter': ('antiperspirant',),
'antiperspirantene': ('antiperspirant',),
'antipode': ('antipode',),
'antipoden': ('antipode',),
'antipoder': ('antipode',),
'antipodene': ('antipode',),
'antipyrin': ('antipyrin',),
'antipyrinen': ('antipyrin',),
'antipyrinet': ('antipyrin',),
'antipyriner': ('antipyrin',),
'antipyrin': ('antipyrin',),
'antipyrinene': ('antipyrin',),
'antipyrina': ('antipyrin',),
'antipyrinene': ('antipyrin',),
'antirakettvåpen': ('antirakettvåpen',),
'antirakettvåpenet': ('antirakettvåpen',),
'antirakettvåpen': ('antirakettvåpen',),
'antirakettvåpna': ('antirakettvåpen',),
'antirakettvåpnene': ('antirakettvåpen',),
'antisemitt': ('antisemitt',),
'antisemitten': ('antisemitt',),
'antisemitter': ('antisemitt',),
'antisemittene': ('antisemitt',),
'antisemittisme': ('antisemittisme',),
'antisemittismen': ('antisemittisme',),
'antisemittismer': ('antisemittisme',),
'antisemittismene': ('antisemittisme',),
'antiseptikk': ('antiseptikk',),
'antiseptikken': ('antiseptikk',),
'antiseptikker': ('antiseptikk',),
'antiseptikkene': ('antiseptikk',),
'antiseptikum': ('antiseptikum',),
'antiseptikumet': ('antiseptikum',),
'antiseptika': ('antiseptikum',),
'antiseptikaene': ('antiseptikum',),
'antiserum': ('antiserum',),
'antiserumet': ('antiserum',),
'antiserumer': ('antiserum',),
'antisera': ('antiserum',),
'antiseruma': ('antiserum',),
'antiserumene': ('antiserum',),
'antiseraene': ('antiserum',),
'antisionisme': ('antisionisme',),
'antisionismen': ('antisionisme',),
'antisionismer': ('antisionisme',),
'antisionismene': ('antisionisme',),
'antisionist': ('antisionist',),
'antisionisten': ('antisionist',),
'antisionister': ('antisionist',),
'antisionistene': ('antisionist',),
'antistoff': ('antistoff',),
'antistoffet': ('antistoff',),
'antistoff': ('antistoff',),
'antistoffer': ('antistoff',),
'antistoff': ('antistoff',),
'antistoffer': ('antistoff',),
'antistoffa': ('antistoff',),
'antistoffene': ('antistoff',),
'antitankvåpen': ('antitankvåpen',),
'antitankvåpenet': ('antitankvåpen',),
'antitankvåpen': ('antitankvåpen',),
'antitankvåpna': ('antitankvåpen',),
'antitankvåpnene': ('antitankvåpen',),
'antitese': ('antitese',),
'antitesen': ('antitese',),
'antiteser': ('antitese',),
'antitesene': ('antitese',),
'antitoksin': ('antitoksin',),
'antitoksinet': ('antitoksin',),
'antitoksin': ('antitoksin',),
'antitoksiner': ('antitoksin',),
'antitoksin': ('antitoksin',),
'antitoksiner': ('antitoksin',),
'antitoksina': ('antitoksin',),
'antitoksinene': ('antitoksin',),
'antiubåtkrig': ('antiubåtkrig',),
'antiubåtkrigen': ('antiubåtkrig',),
'antiubåtkriger': ('antiubåtkrig',),
'antiubåtkrigene': ('antiubåtkrig',),
'antiubåtvåpen': ('antiubåtvåpen',),
'antiubåtvåpenet': ('antiubåtvåpen',),
'antiubåtvåpen': ('antiubåtvåpen',),
'antiubåtvåpna': ('antiubåtvåpen',),
'antiubåtvåpnene': ('antiubåtvåpen',),
'antiviviseksjonist': ('antiviviseksjonist',),
'antiviviseksjonisten': ('antiviviseksjonist',),
'antiviviseksjonister': ('antiviviseksjonist',),
'antiviviseksjonistene': ('antiviviseksjonist',),
'antocyan': ('antocyan',),
'antocyanet': ('antocyan',),
'antocyan': ('antocyan',),
'antocyaner': ('antocyan',),
'antocyan': ('antocyan',),
'antocyaner': ('antocyan',),
'antocyana': ('antocyan',),
'antocyanene': ('antocyan',),
'antologi': ('antologi',),
'antologien': ('antologi',),
'antologier': ('antologi',),
'antologiene': ('antologi',),
'antoniusild': ('antoniusild',),
'antoniusilden': ('antoniusild',),
'antoniusilder': ('antoniusild',),
'antoniusildene': ('antoniusild',),
'antoniuskors': ('antoniuskors',),
'antoniuskorset': ('antoniuskors',),
'antoniuskors': ('antoniuskors',),
'antoniuskorsa': ('antoniuskors',),
'antoniuskorsene': ('antoniuskors',),
'antonsmess': ('antonsmess',),
'antonsmessen': ('antonsmess',),
'antonsmessa': ('antonsmess',),
'antonsmesser': ('antonsmess',),
'antonsmessene': ('antonsmess',),
'antonsmesse': ('antonsmesse',),
'antonsmessen': ('antonsmesse',),
'antonsmessa': ('antonsmesse',),
'antonsmesser': ('antonsmesse',),
'antonsmessene': ('antonsmesse',),
'antonym': ('antonym',),
'antonymet': ('antonym',),
'antonym': ('antonym',),
'antonymer': ('antonym',),
'antonym': ('antonym',),
'antonymer': ('antonym',),
'antonyma': ('antonym',),
'antonymene': ('antonym',),
'antonymi': ('antonymi',),
'antonymien': ('antonymi',),
'antonymier': ('antonymi',),
'antonymiene': ('antonymi',),
'antrasitt': ('antrasitt',),
'antrasitten': ('antrasitt',),
'antrasitter': ('antrasitt',),
'antrasittene': ('antrasitt',),
'antrasittkol': ('antrasittkol',),
'antrasittkolet': ('antrasittkol',),
'antrasittkol': ('antrasittkol',),
'antrasittkola': ('antrasittkol',),
'antrasittkolene': ('antrasittkol',),
'antrasittkull': ('antrasittkull',),
'antrasittkullet': ('antrasittkull',),
'antrasittkull': ('antrasittkull',),
'antrasittkulla': ('antrasittkull',),
'antrasittkullene': ('antrasittkull',),
'antrekk': ('antrekk',),
'antrekket': ('antrekk',),
'antrekk': ('antrekk',),
'antrekka': ('antrekk',),
'antrekkene': ('antrekk',),
'antropofag': ('antropofag',),
'antropofagen': ('antropofag',),
'antropofager': ('antropofag',),
'antropofagene': ('antropofag',),
'antropofobi': ('antropofobi',),
'antropofobien': ('antropofobi',),
'antropofobier': ('antropofobi',),
'antropofobiene': ('antropofobi',),
'antropolog': ('antropolog',),
'antropologen': ('antropolog',),
'antropologer': ('antropolog',),
'antropologene': ('antropolog',),
'antropologi': ('antropologi',),
'antropologien': ('antropologi',),
'antropologier': ('antropologi',),
'antropologiene': ('antropologi',),
'antropomorfisme': ('antropomorfisme',),
'antropomorfismen': ('antropomorfisme',),
'antropomorfismer': ('antropomorfisme',),
'antropomorfismene': ('antropomorfisme',),
'antroposof': ('antroposof',),
'antroposofen': ('antroposof',),
'antroposofer': ('antroposof',),
'antroposofene': ('antroposof',),
'antroposofi': ('antroposofi',),
'antroposofien': ('antroposofi',),
'antroposofier': ('antroposofi',),
'antroposofiene': ('antroposofi',),
'antydning': ('antydning',),
'antydningen': ('antydning',),
'antydninga': ('antydning',),
'antydninger': ('antydning',),
'antydningene': ('antydning',),
'anus': ('anus',),
'anusen': ('anus',),
'anuser': ('anus',),
'anusene': ('anus',),
'anuskop': ('anuskop',),
'anuskopet': ('anuskop',),
'anuskop': ('anuskop',),
'anuskoper': ('anuskop',),
'anuskop': ('anuskop',),
'anuskoper': ('anuskop',),
'anuskopa': ('anuskop',),
'anuskopene': ('anuskop',),
'anvendelse': ('anvendelse',),
'anvendelsen': ('anvendelse',),
'anvendelser': ('anvendelse',),
'anvendelsene': ('anvendelse',),
'anvendelsesmulighet': ('anvendelsesmulighet',),
'anvendelsesmuligheten': ('anvendelsesmulighet',),
'anvendelsesmuligheta': ('anvendelsesmulighet',),
'anvendelsesmuligheter': ('anvendelsesmulighet',),
'anvendelsesmulighetene': ('anvendelsesmulighet',),
'anvendelsesområde': ('anvendelsesområde',),
'anvendelsesområdet': ('anvendelsesområde',),
'anvendelsesområder': ('anvendelsesområde',),
'anvendelsesområda': ('anvendelsesområde',),
'anvendelsesområdene': ('anvendelsesområde',),
'anviser': ('anviser',),
'anviseren': ('anviser',),
'anvisere': ('anviser',),
'anviserne': ('anviser',),
'anvisning': ('anvisning',),
'anvisningen': ('anvisning',),
'anvisninga': ('anvisning',),
'anvisninger': ('anvisning',),
'anvisningene': ('anvisning',),
'aorta': ('aorta',),
'aortaen': ('aorta',),
'aortaer': ('aorta',),
'aortaene': ('aorta',),
'ap': ('ap',),
'apen': ('ap',),
'aper': ('ap',),
'apene': ('ap',),
'ap': ('ap',),
'apet': ('ap',),
'ap': ('ap',),
'apa': ('ap',),
'apene': ('ap',),
'apal': ('apal',),
'apalen': ('apal',),
'apaler': ('apal',),
'apalene': ('apal',),
'apanasje': ('apanasje',),
'apanasjen': ('apanasje',),
'apanasjer': ('apanasje',),
'apanasjene': ('apanasje',),
'apartheid': ('apartheid',),
'apartheiden': ('apartheid',),
'apartheider': ('apartheid',),
'apartheidene': ('apartheid',),
'apartheidlov': ('apartheidlov',),
'apartheidloven': ('apartheidlov',),
'apartheidlover': ('apartheidlov',),
'apartheidlovene': ('apartheidlov',),
'apartheidpolitikk': ('apartheidpolitikk',),
'apartheidpolitikken': ('apartheidpolitikk',),
'apartheidpolitikker': ('apartheidpolitikk',),
'apartheidpolitikkene': ('apartheidpolitikk',),
'apartheidstyre': ('apartheidstyre',),
'apartheidstyret': ('apartheidstyre',),
'apartheidstyrer': ('apartheidstyre',),
'apartheidstyra': ('apartheidstyre',),
'apartheidstyrene': ('apartheidstyre',),
'apasje': ('apasje',),
'apasjen': ('apasje',),
'apasjer': ('apasje',),
'apasjene': ('apasje',),
'apasjeindianer': ('apasjeindianer',),
'apasjeindianeren': ('apasjeindianer',),
'apasjeindianere': ('apasjeindianer',),
'apasjeindianerne': ('apasjeindianer',),
'apati': ('apati',),
'apatien': ('apati',),
'apatier': ('apati',),
'apatiene': ('apati',),
'apatitt': ('apatitt',),
'apatitten': ('apatitt',),
'apatitter': ('apatitt',),
'apatittene': ('apatitt',),
'apatittgruve': ('apatittgruve',),
'apatittgruven': ('apatittgruve',),
'apatittgruva': ('apatittgruve',),
'apatittgruver': ('apatittgruve',),
'apatittgruvene': ('apatittgruve',),
'ape': ('ape',),
'apen': ('ape',),
'apa': ('ape',),
'aper': ('ape',),
'apene': ('ape',),
'apebrød': ('apebrød',),
'apebrødet': ('apebrød',),
'apebrød': ('apebrød',),
'apebrøda': ('apebrød',),
'apebrødene': ('apebrød',),
'apebrødtre': ('apebrødtre',),
'apebrødtreet': ('apebrødtre',),
'apebrødtre': ('apebrødtre',),
'apebrødtrær': ('apebrødtre',),
'apebrødtrea': ('apebrødtre',),
'apebrødtrærne': ('apebrødtre',),
'apekatt': ('apekatt',),
'apekatten': ('apekatt',),
'apekatter': ('apekatt',),
'apekattene': ('apekatt',),
'apemenneske': ('apemenneske',),
'apemennesket': ('apemenneske',),
'apemennesker': ('apemenneske',),
'apemenneska': ('apemenneske',),
'apemenneskene': ('apemenneske',),
'aperi': ('aperi',),
'aperiet': ('aperi',),
'aperi': ('aperi',),
'aperier': ('aperi',),
'aperi': ('aperi',),
'aperier': ('aperi',),
'aperia': ('aperi',),
'aperiene': ('aperi',),
'aperitiff': ('aperitiff',),
'aperitiffen': ('aperitiff',),
'aperitiffer': ('aperitiff',),
'aperitiffene': ('aperitiff',),
'apestrek': ('apestrek',),
'apestreken': ('apestrek',),
'apestreker': ('apestrek',),
'apestrekene': ('apestrek',),
'apikal': ('apikal',),
'apikalen': ('apikal',),
'apikaler': ('apikal',),
'apikalene': ('apikal',),
'aplomb': ('aplomb',),
'aplomben': ('aplomb',),
'aplomber': ('aplomb',),
'aplombene': ('aplomb',),
'apoge': ('apoge',),
'apogeet': ('apoge',),
'apoge': ('apoge',),
'apogea': ('apoge',),
'apogeene': ('apoge',),
'apogeum': ('apogeum',),
'apogeet': ('apogeum',),
'apogeer': ('apogeum',),
'apogea': ('apogeum',),
'apogeene': ('apogeum',),
'apokalypse': ('apokalypse',),
'apokalypsen': ('apokalypse',),
'apokalypser': ('apokalypse',),
'apokalypsene': ('apokalypse',),
'apokope': ('apokope',),
'apokopen': ('apokope',),
'apokoper': ('apokope',),
'apokopene': ('apokope',),
'apokryf': ('apokryf',),
'apokryfen': ('apokryf',),
'apokryfer': ('apokryf',),
'apokryfene': ('apokryf',),
'apollo': ('apollo',),
'apolloen': ('apollo',),
'apolloer': ('apollo',),
'apolloene': ('apollo',),
'apollosommerfugl': ('apollosommerfugl',),
'apollosommerfuglen': ('apollosommerfugl',),
'apollosommerfugler': ('apollosommerfugl',),
'apollosommerfuglene': ('apollosommerfugl',),
'apologet': ('apologet',),
'apologeten': ('apologet',),
'apologeter': ('apologet',),
'apologetene': ('apologet',),
'apologi': ('apologi',),
'apologien': ('apologi',),
'apologier': ('apologi',),
'apologiene': ('apologi',),
'apopleksi': ('apopleksi',),
'apopleksien': ('apopleksi',),
'apopleksier': ('apopleksi',),
'apopleksiene': ('apopleksi',),
'apoplektiker': ('apoplektiker',),
'apoplektikeren': ('apoplektiker',),
'apoplektikere': ('apoplektiker',),
'apoplektikerne': ('apoplektiker',),
'aposiopese': ('aposiopese',),
'aposiopesen': ('aposiopese',),
'aposiopeser': ('aposiopese',),
'aposiopesene': ('aposiopese',),
'apostasi': ('apostasi',),
'apostasien': ('apostasi',),
'apostasier': ('apostasi',),
'apostasiene': ('apostasi',),
'apostat': ('apostat',),
'apostaten': ('apostat',),
'apostater': ('apostat',),
'apostatene': ('apostat',),
'apostel': ('apostel',),
'apostelen': ('apostel',),
'apostler': ('apostel',),
'apostlene': ('apostel',),
'apostelbrev': ('apostelbrev',),
'apostelbrevet': ('apostelbrev',),
'apostelbrev': ('apostelbrev',),
'apostelbrever': ('apostelbrev',),
'apostelbrev': ('apostelbrev',),
'apostelbrever': ('apostelbrev',),
'apostelbreva': ('apostelbrev',),
'apostelbrevene': ('apostelbrev',),
'aposteljern': ('aposteljern',),
'aposteljernet': ('aposteljern',),
'aposteljern': ('aposteljern',),
'aposteljerna': ('aposteljern',),
'aposteljernene': ('aposteljern',),
'apostrof': ('apostrof',),
'apostrofen': ('apostrof',),
'apostrofer': ('apostrof',),
'apostrofene': ('apostrof',),
'apostrofe': ('apostrofe',),
'apostrofen': ('apostrofe',),
'apostrofer': ('apostrofe',),
'apostrofene': ('apostrofe',),
'apostroftegn': ('apostroftegn',),
'apostroftegnet': ('apostroftegn',),
'apostroftegn': ('apostroftegn',),
'apostroftegna': ('apostroftegn',),
'apostroftegnene': ('apostroftegn',),
'apotek': ('apotek',),
'apoteket': ('apotek',),
'apotek': ('apotek',),
'apoteker': ('apotek',),
'apotek': ('apotek',),
'apoteker': ('apotek',),
'apoteka': ('apotek',),
'apotekene': ('apotek',),
'apoteker': ('apoteker',),
'apotekeren': ('apoteker',),
'apotekere': ('apoteker',),
'apotekerne': ('apoteker',),
'apotekerlatin': ('apotekerlatin',),
'apotekerlatinen': ('apotekerlatin',),
'apotekerlatiner': ('apotekerlatin',),
'apotekerlatinene': ('apotekerlatin',),
'apotekervekt': ('apotekervekt',),
'apotekervekten': ('apotekervekt',),
'apotekervekta': ('apotekervekt',),
'apotekervekter': ('apotekervekt',),
'apotekervektene': ('apotekervekt',),
'apoteose': ('apoteose',),
'apoteosen': ('apoteose',),
'apoteoser': ('apoteose',),
'apoteosene': ('apoteose',),
'apparat': ('apparat',),
'apparatet': ('apparat',),
'apparat': ('apparat',),
'apparater': ('apparat',),
'apparat': ('apparat',),
'apparater': ('apparat',),
'apparata': ('apparat',),
'apparatene': ('apparat',),
'apparatbord': ('apparatbord',),
'apparatbordet': ('apparatbord',),
'apparatbord': ('apparatbord',),
'apparatborder': ('apparatbord',),
'apparatbord': ('apparatbord',),
'apparatborder': ('apparatbord',),
'apparatborda': ('apparatbord',),
'apparatbordene': ('apparatbord',),
'apparatsamling': ('apparatsamling',),
'apparatsamlingen': ('apparatsamling',),
'apparatsamlinga': ('apparatsamling',),
'apparatsamlinger': ('apparatsamling',),
'apparatsamlingene': ('apparatsamling',),
'apparatsjik': ('apparatsjik',),
'apparatsjiken': ('apparatsjik',),
'apparatsjiker': ('apparatsjik',),
'apparatsjikene': ('apparatsjik',),
'apparattavle': ('apparattavle',),
'apparattavlen': ('apparattavle',),
'apparattavla': ('apparattavle',),
'apparattavler': ('apparattavle',),
'apparattavlene': ('apparattavle',),
'apparatur': ('apparatur',),
'apparaturen': ('apparatur',),
'apparaturer': ('apparatur',),
'apparaturene': ('apparatur',),
'apparisjon': ('apparisjon',),
'apparisjonen': ('apparisjon',),
'apparisjoner': ('apparisjon',),
'apparisjonene': ('apparisjon',),
'appartement': ('appartement',),
'appartementet': ('appartement',),
'appartement': ('appartement',),
'appartementer': ('appartement',),
'appartement': ('appartement',),
'appartementer': ('appartement',),
'appartementa': ('appartement',),
'appartementene': ('appartement',),
'appartementshotell': ('appartementshotell',),
'appartementshotellet': ('appartementshotell',),
'appartementshotell': ('appartementshotell',),
'appartementshoteller': ('appartementshotell',),
'appartementshotell': ('appartementshotell',),
'appartementshoteller': ('appartementshotell',),
'appartementshotella': ('appartementshotell',),
'appartementshotellene': ('appartementshotell',),
'appartementshus': ('appartementshus',),
'appartementshuset': ('appartementshus',),
'appartementshus': ('appartementshus',),
'appartementshusa': ('appartementshus',),
'appartementshusene': ('appartementshus',),
'appell': ('appell',),
'appellen': ('appell',),
'appeller': ('appell',),
'appellene': ('appell',),
'appellant': ('appellant',),
'appellanten': ('appellant',),
'appellanter': ('appellant',),
'appellantene': ('appellant',),
'appellativ': ('appellativ',),
'appellativet': ('appellativ',),
'appellativ': ('appellativ',),
'appellativer': ('appellativ',),
'appellativ': ('appellativ',),
'appellativer': ('appellativ',),
'appellativa': ('appellativ',),
'appellativene': ('appellativ',),
'appelldomstol': ('appelldomstol',),
'appelldomstolen': ('appelldomstol',),
'appelldomstoler': ('appelldomstol',),
'appelldomstolene': ('appelldomstol',),
'appellfrist': ('appellfrist',),
'appellfristen': ('appellfrist',),
'appellfrister': ('appellfrist',),
'appellfristene': ('appellfrist',),
'appellinstans': ('appellinstans',),
'appellinstansen': ('appellinstans',),
'appellinstanser': ('appellinstans',),
'appellinstansene': ('appellinstans',),
'appellrett': ('appellrett',),
'appellretten': ('appellrett',),
'appellretter': ('appellrett',),
'appellrettene': ('appellrett',),
'appelsin': ('appelsin',),
'appelsinen': ('appelsin',),
'appelsiner': ('appelsin',),
'appelsinene': ('appelsin',),
'appelsinbåt': ('appelsinbåt',),
'appelsinbåten': ('appelsinbåt',),
'appelsinbåter': ('appelsinbåt',),
'appelsinbåtene': ('appelsinbåt',),
'appelsinfromasj': ('appelsinfromasj',),
'appelsinfromasjen': ('appelsinfromasj',),
'appelsinfromasjer': ('appelsinfromasj',),
'appelsinfromasjene': ('appelsinfromasj',),
'appelsinjuice': ('appelsinjuice',),
'appelsinjuicen': ('appelsinjuice',),
'appelsinjuicer': ('appelsinjuice',),
'appelsinjuicene': ('appelsinjuice',),
'appelsinjus': ('appelsinjus',),
'appelsinjusen': ('appelsinjus',),
'appelsinjuser': ('appelsinjus',),
'appelsinjusene': ('appelsinjus',),
'appelsinmarmelade': ('appelsinmarmelade',),
'appelsinmarmeladen': ('appelsinmarmelade',),
'appelsinmarmelader': ('appelsinmarmelade',),
'appelsinmarmeladene': ('appelsinmarmelade',),
'appelsinsaft': ('appelsinsaft',),
'appelsinsaften': ('appelsinsaft',),
'appelsinsafta': ('appelsinsaft',),
'appelsinsafter': ('appelsinsaft',),
'appelsinsaftene': ('appelsinsaft',),
'appelsinskall': ('appelsinskall',),
'appelsinskallet': ('appelsinskall',),
'appelsinskall': ('appelsinskall',),
'appelsinskalla': ('appelsinskall',),
'appelsinskallene': ('appelsinskall',),
'appendiks': ('appendiks',),
'appendiksen': ('appendiks',),
'appendikser': ('appendiks',),
'appendiksene': ('appendiks',),
'appendiks': ('appendiks',),
'appendikset': ('appendiks',),
'appendiks': ('appendiks',),
'appendikser': ('appendiks',),
'appendiks': ('appendiks',),
'appendikser': ('appendiks',),
'appendiksa': ('appendiks',),
'appendiksene': ('appendiks',),
'appetitt': ('appetitt',),
'appetitten': ('appetitt',),
'appetitter': ('appetitt',),
'appetittene': ('appetitt',),
'appetittvekker': ('appetittvekker',),
'appetittvekkeren': ('appetittvekker',),
'appetittvekkere': ('appetittvekker',),
'appetittvekkerne': ('appetittvekker',),
'applaus': ('applaus',),
'applausen': ('applaus',),
'applauser': ('applaus',),
'applausene': ('applaus',),
'applikasjon': ('applikasjon',),
'applikasjonen': ('applikasjon',),
'applikasjoner': ('applikasjon',),
'applikasjonene': ('applikasjon',),
'applikasjonsarbeid': ('applikasjonsarbeid',),
'applikasjonsarbeidet': ('applikasjonsarbeid',),
'applikasjonsarbeid': ('applikasjonsarbeid',),
'applikasjonsarbeider': ('applikasjonsarbeid',),
'applikasjonsarbeid': ('applikasjonsarbeid',),
'applikasjonsarbeider': ('applikasjonsarbeid',),
'applikasjonsarbeida': ('applikasjonsarbeid',),
'applikasjonsarbeidene': ('applikasjonsarbeid',),
'applikasjonsområde': ('applikasjonsområde',),
'applikasjonsområdet': ('applikasjonsområde',),
'applikasjonsområder': ('applikasjonsområde',),
'applikasjonsområda': ('applikasjonsområde',),
'applikasjonsområdene': ('applikasjonsområde',),
'applikasjonssøm': ('applikasjonssøm',),
'applikasjonssømmen': ('applikasjonssøm',),
'applikasjonssømmer': ('applikasjonssøm',),
'applikasjonssømmene': ('applikasjonssøm',),
'applikatur': ('applikatur',),
'applikaturen': ('applikatur',),
'applikaturer': ('applikatur',),
'applikaturene': ('applikatur',),
'apport': ('apport',),
'apporten': ('apport',),
'apporter': ('apport',),
'apportene': ('apport',),
'apposisjon': ('apposisjon',),
'apposisjonen': ('apposisjon',),
'apposisjoner': ('apposisjon',),
'apposisjonene': ('apposisjon',),
'appretur': ('appretur',),
'appreturen': ('appretur',),
'appreturer': ('appretur',),
'appreturene': ('appretur',),
'appreturmaskin': ('appreturmaskin',),
'appreturmaskinen': ('appreturmaskin',),
'appreturmaskiner': ('appreturmaskin',),
'appreturmaskinene': ('appreturmaskin',),
'approbasjon': ('approbasjon',),
'approbasjonen': ('approbasjon',),
'approbasjoner': ('approbasjon',),
'approbasjonene': ('approbasjon',),
'approbering': ('approbering',),
'approberingen': ('approbering',),
'approberinga': ('approbering',),
'approberinger': ('approbering',),
'approberingene': ('approbering',),
'approksimasjon': ('approksimasjon',),
'approksimasjonen': ('approksimasjon',),
'approksimasjoner': ('approksimasjon',),
'approksimasjonene': ('approksimasjon',),
'appropriasjon': ('appropriasjon',),
'appropriasjonen': ('appropriasjon',),
'appropriasjoner': ('appropriasjon',),
'appropriasjonene': ('appropriasjon',),
'aprikos': ('aprikos',),
'aprikosen': ('aprikos',),
'aprikoser': ('aprikos',),
'aprikosene': ('aprikos',),
'aprikosgraut': ('aprikosgraut',),
'aprikosgrauten': ('aprikosgraut',),
'aprikosgrauter': ('aprikosgraut',),
'aprikosgrautene': ('aprikosgraut',),
'aprikosgrøt': ('aprikosgrøt',),
'aprikosgrøten': ('aprikosgrøt',),
'aprikosgrøter': ('aprikosgrøt',),
'aprikosgrøtene': ('aprikosgrøt',),
'aprikoskompott': ('aprikoskompott',),
'aprikoskompotten': ('aprikoskompott',),
'aprikoskompotter': ('aprikoskompott',),
'aprikoskompottene': ('aprikoskompott',),
'aprikosmarmelade': ('aprikosmarmelade',),
'aprikosmarmeladen': ('aprikosmarmelade',),
'aprikosmarmelader': ('aprikosmarmelade',),
'aprikosmarmeladene': ('aprikosmarmelade',),
'aprikossyltetøy': ('aprikossyltetøy',),
'aprikossyltetøyet': ('aprikossyltetøy',),
'aprikossyltetøy': ('aprikossyltetøy',),
'aprikossyltetøya': ('aprikossyltetøy',),
'aprikossyltetøyene': ('aprikossyltetøy',),
'aprikostre': ('aprikostre',),
'aprikostreet': ('aprikostre',),
'aprikostre': ('aprikostre',),
'aprikostrær': ('aprikostre',),
'aprikostrea': ('aprikostre',),
'aprikostrærne': ('aprikostre',),
'april': ('april',),
'aprilsnarr': ('aprilsnarr',),
'aprilsnarren': ('aprilsnarr',),
'aprilsnarrer': ('aprilsnarr',),
'aprilsnarrene': ('aprilsnarr',),
'aprilspøk': ('aprilspøk',),
'aprilspøken': ('aprilspøk',),
'aprilspøker': ('aprilspøk',),
'aprilspøkene': ('aprilspøk',),
'aprilvær': ('aprilvær',),
'aprilværet': ('aprilvær',),
'aprilvær': ('aprilvær',),
'aprilværa': ('aprilvær',),
'aprilværene': ('aprilvær',),
'apropos': ('apropos',),
'aproposet': ('apropos',),
'apropos': ('apropos',),
'aproposer': ('apropos',),
'apropos': ('apropos',),
'aproposer': ('apropos',),
'aproposa': ('apropos',),
'aproposene': ('apropos',),
'apsis': ('apsis',),
'apsisen': ('apsis',),
'apsiser': ('apsis',),
'apsider': ('apsis',),
'apsisene': ('apsis',),
'apsidene': ('apsis',),
'ar': ('ar',),
'aret': ('ar',),
'ar': ('ar',),
'ara': ('ar',),
'arene': ('ar',),
'ara': ('ara',),
'araen': ('ara',),
'araer': ('ara',),
'araene': ('ara',),
'araber': ('araber',),
'araberen': ('araber',),
'arabere': ('araber',),
'araberne': ('araber',),
'araberhest': ('araberhest',),
'araberhesten': ('araberhest',),
'araberhester': ('araberhest',),
'araberhestene': ('araberhest',),
'araberstat': ('araberstat',),
'araberstaten': ('araberstat',),
'araberstater': ('araberstat',),
'araberstatene': ('araberstat',),
'arabertall': ('arabertall',),
'arabertallet': ('arabertall',),
'arabertall': ('arabertall',),
'arabertalla': ('arabertall',),
'arabertallene': ('arabertall',),
'arabesk': ('arabesk',),
'arabesken': ('arabesk',),
'arabesker': ('arabesk',),
'arabeskene': ('arabesk',),
'arabisk': ('arabisk',),
'arabisken': ('arabisk',),
'arabisker': ('arabisk',),
'arabiskene': ('arabisk',),
'arabist': ('arabist',),
'arabisten': ('arabist',),
'arabister': ('arabist',),
'arabistene': ('arabist',),
'arak': ('arak',),
'araken': ('arak',),
'araker': ('arak',),
'arakene': ('arak',),
'arakpunsj': ('arakpunsj',),
'arakpunsjen': ('arakpunsj',),
'arakpunsjer': ('arakpunsj',),
'arakpunsjene': ('arakpunsj',),
'arameer': ('arameer',),
'arameeren': ('arameer',),
'arameere': ('arameer',),
'arameerne': ('arameer',),
'arameisk': ('arameisk',),
'arameisken': ('arameisk',),
'arameisker': ('arameisk',),
'arameiskene': ('arameisk',),
'arbeid': ('arbeid',),
'arbeidet': ('arbeid',),
'arbeid': ('arbeid',),
'arbeider': ('arbeid',),
'arbeid': ('arbeid',),
'arbeider': ('arbeid',),
'arbeida': ('arbeid',),
'arbeidene': ('arbeid',),
'arbeider': ('arbeider',),
'arbeideren': ('arbeider',),
'arbeidere': ('arbeider',),
'arbeiderne': ('arbeider',),
'arbeiderbevegelse': ('arbeiderbevegelse',),
'arbeiderbevegelsen': ('arbeiderbevegelse',),
'arbeiderbevegelser': ('arbeiderbevegelse',),
'arbeiderbevegelsene': ('arbeiderbevegelse',),
'arbeiderbie': ('arbeiderbie',),
'arbeiderbien': ('arbeiderbie',),
'arbeiderbia': ('arbeiderbie',),
'arbeiderbier': ('arbeiderbie',),
'arbeiderbiene': ('arbeiderbie',),
'arbeiderbolig': ('arbeiderbolig',),
'arbeiderboligen': ('arbeiderbolig',),
'arbeiderboliger': ('arbeiderbolig',),
'arbeiderboligene': ('arbeiderbolig',),
'arbeiderdikter': ('arbeiderdikter',),
'arbeiderdikteren': ('arbeiderdikter',),
'arbeiderdiktere': ('arbeiderdikter',),
'arbeiderdikterne': ('arbeiderdikter',),
'arbeiderdiktning': ('arbeiderdiktning',),
'arbeiderdiktningen': ('arbeiderdiktning',),
'arbeiderdiktninga': ('arbeiderdiktning',),
'arbeiderdiktninger': ('arbeiderdiktning',),
'arbeiderdiktningene': ('arbeiderdiktning',),
'arbeiderforening': ('arbeiderforening',),
'arbeiderforeningen': ('arbeiderforening',),
'arbeiderforeninga': ('arbeiderforening',),
'arbeiderforeninger': ('arbeiderforening',),
'arbeiderforeningene': ('arbeiderforening',),
'arbeiderfører': ('arbeiderfører',),
'arbeiderføreren': ('arbeiderfører',),
'arbeiderførere': ('arbeiderfører',),
'arbeiderførerne': ('arbeiderfører',),
'arbeiderklasse': ('arbeiderklasse',),
'arbeiderklassen': ('arbeiderklasse',),
'arbeiderklassa': ('arbeiderklasse',),
'arbeiderklasser': ('arbeiderklasse',),
'arbeiderklassene': ('arbeiderklasse',),
'arbeiderkvarter': ('arbeiderkvarter',),
'arbeiderkvarteret': ('arbeiderkvarter',),
'arbeiderkvarter': ('arbeiderkvarter',),
'arbeiderkvarterer': ('arbeiderkvarter',),
'arbeiderkvarter': ('arbeiderkvarter',),
'arbeiderkvarterer': ('arbeiderkvarter',),
'arbeiderkvartera': ('arbeiderkvarter',),
'arbeiderkvarterene': ('arbeiderkvarter',),
'arbeiderleder': ('arbeiderleder',),
'arbeiderlederen': ('arbeiderleder',),
'arbeiderledere': ('arbeiderleder',),
'arbeiderlederne': ('arbeiderleder',),
'arbeidermiljø': ('arbeidermiljø',),
'arbeidermiljøet': ('arbeidermiljø',),
'arbeidermiljø': ('arbeidermiljø',),
'arbeidermiljøer': ('arbeidermiljø',),
'arbeidermiljø': ('arbeidermiljø',),
'arbeidermiljøer': ('arbeidermiljø',),
'arbeidermiljøa': ('arbeidermiljø',),
'arbeidermiljøene': ('arbeidermiljø',),
'arbeideroppstand': ('arbeideroppstand',),
'arbeideroppstanden': ('arbeideroppstand',),
'arbeideroppstander': ('arbeideroppstand',),
'arbeideroppstandene': ('arbeideroppstand',),
'arbeiderparti': ('arbeiderparti',),
'arbeiderpartiet': ('arbeiderparti',),
'arbeiderparti': ('arbeiderparti',),
'arbeiderpartier': ('arbeiderparti',),
'arbeiderparti': ('arbeiderparti',),
'arbeiderpartier': ('arbeiderparti',),
'arbeiderpartia': ('arbeiderparti',),
'arbeiderpartiene': ('arbeiderparti',),
'arbeiderpartifolk': ('arbeiderpartifolk',),
'arbeiderpartifolket': ('arbeiderpartifolk',),
'arbeiderpartifolk': ('arbeiderpartifolk',),
'arbeiderpartifolka': ('arbeiderpartifolk',),
'arbeiderpartifolkene': ('arbeiderpartifolk',),
'arbeiderpresse': ('arbeiderpresse',),
'arbeiderpressen': ('arbeiderpresse',),
'arbeiderpressa': ('arbeiderpresse',),
'arbeiderpresser': ('arbeiderpresse',),
'arbeiderpressene': ('arbeiderpresse',),
'arbeiderregjering': ('arbeiderregjering',),
'arbeiderregjeringen': ('arbeiderregjering',),
'arbeiderregjeringa': ('arbeiderregjering',),
'arbeiderregjeringer': ('arbeiderregjering',),
'arbeiderregjeringene': ('arbeiderregjering',),
'arbeiderrevolusjon': ('arbeiderrevolusjon',),
'arbeiderrevolusjonen': ('arbeiderrevolusjon',),
'arbeiderrevolusjoner': ('arbeiderrevolusjon',),
'arbeiderrevolusjonene': ('arbeiderrevolusjon',),
'arbeiderråd': ('arbeiderråd',),
'arbeiderrådet': ('arbeiderråd',),
'arbeiderråd': ('arbeiderråd',),
'arbeiderråda': ('arbeiderråd',),
'arbeiderrådene': ('arbeiderråd',),
'arbeiderrørsle': ('arbeiderrørsle',),
'arbeiderrørslen': ('arbeiderrørsle',),
'arbeiderrørsla': ('arbeiderrørsle',),
'arbeiderrørsler': ('arbeiderrørsle',),
'arbeiderrørslene': ('arbeiderrørsle',),
'arbeidersamfunn': ('arbeidersamfunn',),
'arbeidersamfunnet': ('arbeidersamfunn',),
'arbeidersamfunn': ('arbeidersamfunn',),
'arbeidersamfunna': ('arbeidersamfunn',),
'arbeidersamfunnene': ('arbeidersamfunn',),
'arbeidersamskipnad': ('arbeidersamskipnad',),
'arbeidersamskipnaden': ('arbeidersamskipnad',),
'arbeidersamskipnader': ('arbeidersamskipnad',),
'arbeidersamskipnadene': ('arbeidersamskipnad',),
'arbeiderstrøk': ('arbeiderstrøk',),
'arbeiderstrøket': ('arbeiderstrøk',),
'arbeiderstrøk': ('arbeiderstrøk',),
'arbeiderstrøka': ('arbeiderstrøk',),
'arbeiderstrøkene': ('arbeiderstrøk',),
'arbeiderstyre': ('arbeiderstyre',),
'arbeiderstyret': ('arbeiderstyre',),
'arbeiderstyrer': ('arbeiderstyre',),
'arbeiderstyra': ('arbeiderstyre',),
'arbeiderstyrene': ('arbeiderstyre',),
'arbeidervern': ('arbeidervern',),
'arbeidervernet': ('arbeidervern',),
'arbeidervern': ('arbeidervern',),
'arbeiderverna': ('arbeidervern',),
'arbeidervernene': ('arbeidervern',),
'arbeidervernlov': ('arbeidervernlov',),
'arbeidervernloven': ('arbeidervernlov',),
'arbeidervernlover': ('arbeidervernlov',),
'arbeidervernlovene': ('arbeidervernlov',),
'arbeidsanstalt': ('arbeidsanstalt',),
'arbeidsanstalten': ('arbeidsanstalt',),
'arbeidsanstalter': ('arbeidsanstalt',),
'arbeidsanstaltene': ('arbeidsanstalt',),
'arbeidsbenk': ('arbeidsbenk',),
'arbeidsbenken': ('arbeidsbenk',),
'arbeidsbenker': ('arbeidsbenk',),
'arbeidsbenkene': ('arbeidsbenk',),
'arbeidsbeskrivelse': ('arbeidsbeskrivelse',),
'arbeidsbeskrivelsen': ('arbeidsbeskrivelse',),
'arbeidsbeskrivelser': ('arbeidsbeskrivelse',),
'arbeidsbeskrivelsene': ('arbeidsbeskrivelse',),
'arbeidsbie': ('arbeidsbie',),
'arbeidsbien': ('arbeidsbie',),
'arbeidsbia': ('arbeidsbie',),
'arbeidsbier': ('arbeidsbie',),
'arbeidsbiene': ('arbeidsbie',),
'arbeidsbord': ('arbeidsbord',),
'arbeidsbordet': ('arbeidsbord',),
'arbeidsbord': ('arbeidsbord',),
'arbeidsborder': ('arbeidsbord',),
'arbeidsbord': ('arbeidsbord',),
'arbeidsborder': ('arbeidsbord',),
'arbeidsborda': ('arbeidsbord',),
'arbeidsbordene': ('arbeidsbord',),
'arbeidsbyrde': ('arbeidsbyrde',),
'arbeidsbyrden': ('arbeidsbyrde',),
'arbeidsbyrder': ('arbeidsbyrde',),
'arbeidsbyrdene': ('arbeidsbyrde',),
'arbeidsdag': ('arbeidsdag',),
'arbeidsdagen': ('arbeidsdag',),
'arbeidsdager': ('arbeidsdag',),
'arbeidsdagene': ('arbeidsdag',),
'arbeidsdeling': ('arbeidsdeling',),
'arbeidsdelingen': ('arbeidsdeling',),
'arbeidsdelinga': ('arbeidsdeling',),
'arbeidsdelinger': ('arbeidsdeling',),
'arbeidsdelingene': ('arbeidsdeling',),
'arbeidsdokument': ('arbeidsdokument',),
'arbeidsdokumentet': ('arbeidsdokument',),
'arbeidsdokument': ('arbeidsdokument',),
'arbeidsdokumenter': ('arbeidsdokument',),
'arbeidsdokument': ('arbeidsdokument',),
'arbeidsdokumenter': ('arbeidsdokument',),
'arbeidsdokumenta': ('arbeidsdokument',),
'arbeidsdokumentene': ('arbeidsdokument',),
'arbeidsdyr': ('arbeidsdyr',),
'arbeidsdyret': ('arbeidsdyr',),
'arbeidsdyr': ('arbeidsdyr',),
'arbeidsdyra': ('arbeidsdyr',),
'arbeidsdyrene': ('arbeidsdyr',),
'arbeidsevne': ('arbeidsevne',),
'arbeidsevnen': ('arbeidsevne',),
'arbeidsevna': ('arbeidsevne',),
'arbeidsevner': ('arbeidsevne',),
'arbeidsevnene': ('arbeidsevne',),
'arbeidsfelt': ('arbeidsfelt',),
'arbeidsfeltet': ('arbeidsfelt',),
'arbeidsfelt': ('arbeidsfelt',),
'arbeidsfelter': ('arbeidsfelt',),
'arbeidsfelt': ('arbeidsfelt',),
'arbeidsfelter': ('arbeidsfelt',),
'arbeidsfelta': ('arbeidsfelt',),
'arbeidsfeltene': ('arbeidsfelt',),
'arbeidsfolk': ('arbeidsfolk',),
'arbeidsfolket': ('arbeidsfolk',),
'arbeidsfolk': ('arbeidsfolk',),
'arbeidsfolka': ('arbeidsfolk',),
'arbeidsfolkene': ('arbeidsfolk',),
'arbeidsforhold': ('arbeidsforhold',),
'arbeidsforholdet': ('arbeidsforhold',),
'arbeidsforhold': ('arbeidsforhold',),
'arbeidsforholda': ('arbeidsforhold',),
'arbeidsforholdene': ('arbeidsforhold',),
'arbeidsformidling': ('arbeidsformidling',),
'arbeidsformidlingen': ('arbeidsformidling',),
'arbeidsformidlinga': ('arbeidsformidling',),
'arbeidsformidlinger': ('arbeidsformidling',),
'arbeidsformidlingene': ('arbeidsformidling',),
'arbeidsfortjeneste': ('arbeidsfortjeneste',),
'arbeidsfortjenesten': ('arbeidsfortjeneste',),
'arbeidsfortjenesta': ('arbeidsfortjeneste',),
'arbeidsfortjenester': ('arbeidsfortjeneste',),
'arbeidsfortjenestene': ('arbeidsfortjeneste',),
'arbeidsfred': ('arbeidsfred',),
'arbeidsfreden': ('arbeidsfred',),
'arbeidsfreder': ('arbeidsfred',),
'arbeidsfredene': ('arbeidsfred',),
'arbeidsfysiologi': ('arbeidsfysiologi',),
'arbeidsfysiologien': ('arbeidsfysiologi',),
'arbeidsfysiologier': ('arbeidsfysiologi',),
'arbeidsfysiologiene': ('arbeidsfysiologi',),
'arbeidsgamp': ('arbeidsgamp',),
'arbeidsgampen': ('arbeidsgamp',),
'arbeidsgamper': ('arbeidsgamp',),
'arbeidsgampene': ('arbeidsgamp',),
'arbeidsgang': ('arbeidsgang',),
'arbeidsgangen': ('arbeidsgang',),
'arbeidsganger': ('arbeidsgang',),
'arbeidsgangene': ('arbeidsgang',),
'arbeidsgiver': ('arbeidsgiver',),
'arbeidsgiveren': ('arbeidsgiver',),
'arbeidsgivere': ('arbeidsgiver',),
'arbeidsgiverne': ('arbeidsgiver',),
'arbeidsgiveransvar': ('arbeidsgiveransvar',),
'arbeidsgiveransvaret': ('arbeidsgiveransvar',),
'arbeidsgiveransvar': ('arbeidsgiveransvar',),
'arbeidsgiveransvara': ('arbeidsgiveransvar',),
'arbeidsgiveransvarene': ('arbeidsgiveransvar',),
'arbeidsgiveravgift': ('arbeidsgiveravgift',),
'arbeidsgiveravgiften': ('arbeidsgiveravgift',),
'arbeidsgiveravgifta': ('arbeidsgiveravgift',),
'arbeidsgiveravgifter': ('arbeidsgiveravgift',),
'arbeidsgiveravgiftene': ('arbeidsgiveravgift',),
'arbeidsgjeng': ('arbeidsgjeng',),
'arbeidsgjengen': ('arbeidsgjeng',),
'arbeidsgjenger': ('arbeidsgjeng',),
'arbeidsgjengene': ('arbeidsgjeng',),
'arbeidsglede': ('arbeidsglede',),
'arbeidsgleden': ('arbeidsglede',),
'arbeidsgleda': ('arbeidsglede',),
'arbeidsgleder': ('arbeidsglede',),
'arbeidsgledene': ('arbeidsglede',),
'arbeidsgrunnlag': ('arbeidsgrunnlag',),
'arbeidsgrunnlaget': ('arbeidsgrunnlag',),
'arbeidsgrunnlag': ('arbeidsgrunnlag',),
'arbeidsgrunnlaga': ('arbeidsgrunnlag',),
'arbeidsgrunnlagene': ('arbeidsgrunnlag',),
'arbeidsgruppe': ('arbeidsgruppe',),
'arbeidsgruppen': ('arbeidsgruppe',),
'arbeidsgruppa': ('arbeidsgruppe',),
'arbeidsgrupper': ('arbeidsgruppe',),
'arbeidsgruppene': ('arbeidsgruppe',),
'arbeidshastighet': ('arbeidshastighet',),
'arbeidshastigheten': ('arbeidshastighet',),
'arbeidshastigheta': ('arbeidshastighet',),
'arbeidshastigheter': ('arbeidshastighet',),
'arbeidshastighetene': ('arbeidshastighet',),
'arbeidshest': ('arbeidshest',),
'arbeidshesten': ('arbeidshest',),
'arbeidshester': ('arbeidshest',),
'arbeidshestene': ('arbeidshest',),
'arbeidshjelp': ('arbeidshjelp',),
'arbeidshjelpen': ('arbeidshjelp',),
'arbeidshjelpa': ('arbeidshjelp',),
'arbeidshjelper': ('arbeidshjelp',),
'arbeidshjelpene': ('arbeidshjelp',),
'arbeidshypotese': ('arbeidshypotese',),
'arbeidshypotesen': ('arbeidshypotese',),
'arbeidshypoteser': ('arbeidshypotese',),
'arbeidshypotesene': ('arbeidshypotese',),
'arbeidsinnsats': ('arbeidsinnsats',),
'arbeidsinnsatsen': ('arbeidsinnsats',),
'arbeidsinnsatser': ('arbeidsinnsats',),
'arbeidsinnsatsene': ('arbeidsinnsats',),
'arbeidsjern': ('arbeidsjern',),
'arbeidsjernet': ('arbeidsjern',),
'arbeidsjern': ('arbeidsjern',),
'arbeidsjerna': ('arbeidsjern',),
'arbeidsjernene': ('arbeidsjern',),
'arbeidskamerat': ('arbeidskamerat',),
'arbeidskameraten': ('arbeidskamerat',),
'arbeidskamerater': ('arbeidskamerat',),
'arbeidskameratene': ('arbeidskamerat',),
'arbeidskar': ('arbeidskar',),
'arbeidskaren': ('arbeidskar',),
'arbeidskarer': ('arbeidskar',),
'arbeidskarene': ('arbeidskar',),
'arbeidskirke': ('arbeidskirke',),
'arbeidskirken': ('arbeidskirke',),
'arbeidskirka': ('arbeidskirke',),
'arbeidskirker': ('arbeidskirke',),
'arbeidskirkene': ('arbeidskirke',),
'arbeidskollektiv': ('arbeidskollektiv',),
'arbeidskollektivet': ('arbeidskollektiv',),
'arbeidskollektiv': ('arbeidskollektiv',),
'arbeidskollektiver': ('arbeidskollektiv',),
'arbeidskollektiv': ('arbeidskollektiv',),
'arbeidskollektiver': ('arbeidskollektiv',),
'arbeidskollektiva': ('arbeidskollektiv',),
'arbeidskollektivene': ('arbeidskollektiv',),
'arbeidskonflikt': ('arbeidskonflikt',),
'arbeidskonflikten': ('arbeidskonflikt',),
'arbeidskonflikter': ('arbeidskonflikt',),
'arbeidskonfliktene': ('arbeidskonflikt',),
'arbeidskontor': ('arbeidskontor',),
'arbeidskontoret': ('arbeidskontor',),
'arbeidskontor': ('arbeidskontor',),
'arbeidskontorer': ('arbeidskontor',),
'arbeidskontor': ('arbeidskontor',),
'arbeidskontorer': ('arbeidskontor',),
'arbeidskontora': ('arbeidskontor',),
'arbeidskontorene': ('arbeidskontor',),
'arbeidskostnad': ('arbeidskostnad',),
'arbeidskostnaden': ('arbeidskostnad',),
'arbeidskostnader': ('arbeidskostnad',),
'arbeidskostnadene': ('arbeidskostnad',),
'arbeidskraft': ('arbeidskraft',),
'arbeidskraften': ('arbeidskraft',),
'arbeidskrafta': ('arbeidskraft',),
'arbeidskrefter': ('arbeidskraft',),
'arbeidskreftene': ('arbeidskraft',),
'arbeidskraftreserve': ('arbeidskraftreserve',),
'arbeidskraftreserven': ('arbeidskraftreserve',),
'arbeidskraftreserver': ('arbeidskraftreserve',),
'arbeidskraftreservene': ('arbeidskraftreserve',),
'arbeidslag': ('arbeidslag',),
'arbeidslaget': ('arbeidslag',),
'arbeidslag': ('arbeidslag',),
'arbeidslaga': ('arbeidslag',),
'arbeidslagene': ('arbeidslag',),
'arbeidslampe': ('arbeidslampe',),
'arbeidslampen': ('arbeidslampe',),
'arbeidslampa': ('arbeidslampe',),
'arbeidslamper': ('arbeidslampe',),
'arbeidslampene': ('arbeidslampe',),
'arbeidsleder': ('arbeidsleder',),
'arbeidslederen': ('arbeidsleder',),
'arbeidsledere': ('arbeidsleder',),
'arbeidslederne': ('arbeidsleder',),
'arbeidsledighet': ('arbeidsledighet',),
'arbeidsledigheten': ('arbeidsledighet',),
'arbeidsledigheta': ('arbeidsledighet',),
'arbeidsledigheter': ('arbeidsledighet',),
'arbeidsledighetene': ('arbeidsledighet',),
'arbeidsleir': ('arbeidsleir',),
'arbeidsleiren': ('arbeidsleir',),
'arbeidsleirer': ('arbeidsleir',),
'arbeidsleirene': ('arbeidsleir',),
'arbeidsliv': ('arbeidsliv',),
'arbeidslivet': ('arbeidsliv',),
'arbeidsliv': ('arbeidsliv',),
'arbeidsliva': ('arbeidsliv',),
'arbeidslivene': ('arbeidsliv',),
'arbeidslyst': ('arbeidslyst',),
'arbeidslysten': ('arbeidslyst',),
'arbeidslysta': ('arbeidslyst',),
'arbeidslyster': ('arbeidslyst',),
'arbeidslystene': ('arbeidslyst',),
'arbeidslønn': ('arbeidslønn',),
'arbeidslønnen': ('arbeidslønn',),
'arbeidslønna': ('arbeidslønn',),
'arbeidslønner': ('arbeidslønn',),
'arbeidslønnene': ('arbeidslønn',),
'arbeidsløshet': ('arbeidsløshet',),
'arbeidsløsheten': ('arbeidsløshet',),
'arbeidsløsheta': ('arbeidsløshet',),
'arbeidsløsheter': ('arbeidsløshet',),
'arbeidsløshetene': ('arbeidsløshet',),
'arbeidsløshetstrygd': ('arbeidsløshetstrygd',),
'arbeidsløshetstrygden': ('arbeidsløshetstrygd',),
'arbeidsløshetstrygda': ('arbeidsløshetstrygd',),
'arbeidsløshetstrygder': ('arbeidsløshetstrygd',),
'arbeidsløshetstrygdene': ('arbeidsløshetstrygd',),
'arbeidsløyse': ('arbeidsløyse',),
'arbeidsløysen': ('arbeidsløyse',),
'arbeidsløysa': ('arbeidsløyse',),
'arbeidsløyser': ('arbeidsløyse',),
'arbeidsløysene': ('arbeidsløyse',),
'arbeidsløysetrygd': ('arbeidsløysetrygd',),
'arbeidsløysetrygden': ('arbeidsløysetrygd',),
'arbeidsløysetrygda': ('arbeidsløysetrygd',),
'arbeidsløysetrygder': ('arbeidsløysetrygd',),
'arbeidsløysetrygdene': ('arbeidsløysetrygd',),
'arbeidsløyve': ('arbeidsløyve',),
'arbeidsløyvet': ('arbeidsløyve',),
'arbeidsløyver': ('arbeidsløyve',),
'arbeidsløyve': ('arbeidsløyve',),
'arbeidsløyver': ('arbeidsløyve',),
'arbeidsløyve': ('arbeidsløyve',),
'arbeidsløyva': ('arbeidsløyve',),
'arbeidsløyvene': ('arbeidsløyve',),
'arbeidsmarked': ('arbeidsmarked',),
'arbeidsmarkedet': ('arbeidsmarked',),
'arbeidsmarked': ('arbeidsmarked',),
'arbeidsmarkeder': ('arbeidsmarked',),
'arbeidsmarked': ('arbeidsmarked',),
'arbeidsmarkeder': ('arbeidsmarked',),
'arbeidsmarkeda': ('arbeidsmarked',),
'arbeidsmarkedene': ('arbeidsmarked',),
'arbeidsmaur': ('arbeidsmaur',),
'arbeidsmauren': ('arbeidsmaur',),
'arbeidsmaur': ('arbeidsmaur',),
'arbeidsmaurene': ('arbeidsmaur',),
'arbeidsmengde': ('arbeidsmengde',),
'arbeidsmengden': ('arbeidsmengde',),
'arbeidsmengder': ('arbeidsmengde',),
'arbeidsmengdene': ('arbeidsmengde',),
'arbeidsmenneske': ('arbeidsmenneske',),
'arbeidsmennesket': ('arbeidsmenneske',),
'arbeidsmennesker': ('arbeidsmenneske',),
'arbeidsmenneska': ('arbeidsmenneske',),
'arbeidsmenneskene': ('arbeidsmenneske',),
'arbeidsmiljø': ('arbeidsmiljø',),
'arbeidsmiljøet': ('arbeidsmiljø',),
'arbeidsmiljø': ('arbeidsmiljø',),
'arbeidsmiljøer': ('arbeidsmiljø',),
'arbeidsmiljø': ('arbeidsmiljø',),
'arbeidsmiljøer': ('arbeidsmiljø',),
'arbeidsmiljøa': ('arbeidsmiljø',),
'arbeidsmiljøene': ('arbeidsmiljø',),
'arbeidsmiljølov': ('arbeidsmiljølov',),
'arbeidsmiljøloven': ('arbeidsmiljølov',),
'arbeidsmiljølover': ('arbeidsmiljølov',),
'arbeidsmiljølovene': ('arbeidsmiljølov',),
'arbeidsnedleggelse': ('arbeidsnedleggelse',),
'arbeidsnedleggelsen': ('arbeidsnedleggelse',),
'arbeidsnedleggelser': ('arbeidsnedleggelse',),
'arbeidsnedleggelsene': ('arbeidsnedleggelse',),
'arbeidsnedlegging': ('arbeidsnedlegging',),
'arbeidsnedleggingen': ('arbeidsnedlegging',),
'arbeidsnedlegginga': ('arbeidsnedlegging',),
'arbeidsnedlegginger': ('arbeidsnedlegging',),
'arbeidsnedleggingene': ('arbeidsnedlegging',),
'arbeidsneve': ('arbeidsneve',),
'arbeidsneven': ('arbeidsneve',),
'arbeidsnever': ('arbeidsneve',),
'arbeidsnevene': ('arbeidsneve',),
'arbeidsområde': ('arbeidsområde',),
'arbeidsområdet': ('arbeidsområde',),
'arbeidsområder': ('arbeidsområde',),
'arbeidsområda': ('arbeidsområde',),
'arbeidsområdene': ('arbeidsområde',),
'arbeidsoperasjon': ('arbeidsoperasjon',),
'arbeidsoperasjonen': ('arbeidsoperasjon',),
'arbeidsoperasjoner': ('arbeidsoperasjon',),
'arbeidsoperasjonene': ('arbeidsoperasjon',),
'arbeidspress': ('arbeidspress',),
'arbeidspresset': ('arbeidspress',),
'arbeidspress': ('arbeidspress',),
'arbeidspressa': ('arbeidspress',),
'arbeidspressene': ('arbeidspress',),
'arbeidsprogram': ('arbeidsprogram',),
'arbeidsprogrammet': ('arbeidsprogram',),
'arbeidsprogram': ('arbeidsprogram',),
'arbeidsprogrammer': ('arbeidsprogram',),
'arbeidsprogramma': ('arbeidsprogram',),
'arbeidsprogrammene': ('arbeidsprogram',),
'arbeidsprogramma': ('arbeidsprogram',),
'arbeidsprogrammene': ('arbeidsprogram',),
'arbeidsredskap': ('arbeidsredskap',),
'arbeidsredskapen': ('arbeidsredskap',),
'arbeidsredskapet': ('arbeidsredskap',),
'arbeidsredskaper': ('arbeidsredskap',),
'arbeidsredskap': ('arbeidsredskap',),
'arbeidsredskaper': ('arbeidsredskap',),
'arbeidsredskap': ('arbeidsredskap',),
'arbeidsredskaper': ('arbeidsredskap',),
'arbeidsredskapene': ('arbeidsredskap',),
'arbeidsredskapa': ('arbeidsredskap',),
'arbeidsredskapene': ('arbeidsredskap',),
'arbeidsrett': ('arbeidsrett',),
'arbeidsretten': ('arbeidsrett',),
'arbeidsretter': ('arbeidsrett',),
'arbeidsrettene': ('arbeidsrett',),
'arbeidsskole': ('arbeidsskole',),
'arbeidsskolen': ('arbeidsskole',),
'arbeidsskoler': ('arbeidsskole',),
'arbeidsskolene': ('arbeidsskole',),
'arbeidsstans': ('arbeidsstans',),
'arbeidsstansen': ('arbeidsstans',),
'arbeidsstanser': ('arbeidsstans',),
'arbeidsstansene': ('arbeidsstans',),
'arbeidsstilling': ('arbeidsstilling',),
'arbeidsstillingen': ('arbeidsstilling',),
'arbeidsstillinga': ('arbeidsstilling',),
'arbeidsstillinger': ('arbeidsstilling',),
'arbeidsstillingene': ('arbeidsstilling',),
'arbeidsstokk': ('arbeidsstokk',),
'arbeidsstokken': ('arbeidsstokk',),
'arbeidsstokker': ('arbeidsstokk',),
'arbeidsstokkene': ('arbeidsstokk',),
'arbeidsstudie': ('arbeidsstudie',),
'arbeidsstudien': ('arbeidsstudie',),
'arbeidsstudier': ('arbeidsstudie',),
'arbeidsstudiene': ('arbeidsstudie',),
'arbeidsstudietekniker': ('arbeidsstudietekniker',),
'arbeidsstudieteknikeren': ('arbeidsstudietekniker',),
'arbeidsstudieteknikere': ('arbeidsstudietekniker',),
'arbeidsstudieteknikerne': ('arbeidsstudietekniker',),
'arbeidsstyrke': ('arbeidsstyrke',),
'arbeidsstyrken': ('arbeidsstyrke',),
'arbeidsstyrker': ('arbeidsstyrke',),
'arbeidsstyrkene': ('arbeidsstyrke',),
'arbeidssøker': ('arbeidssøker',),
'arbeidssøkeren': ('arbeidssøker',),
'arbeidssøkere': ('arbeidssøker',),
'arbeidssøkerne': ('arbeidssøker',),
'arbeidstaker': ('arbeidstaker',),
'arbeidstakeren': ('arbeidstaker',),
'arbeidstakere': ('arbeidstaker',),
'arbeidstakerne': ('arbeidstaker',),
'arbeidstegning': ('arbeidstegning',),
'arbeidstegningen': ('arbeidstegning',),
'arbeidstegninga': ('arbeidstegning',),
'arbeidstegninger': ('arbeidstegning',),
'arbeidstegningene': ('arbeidstegning',),
'arbeidsteknikk': ('arbeidsteknikk',),
'arbeidsteknikken': ('arbeidsteknikk',),
'arbeidsteknikker': ('arbeidsteknikk',),
'arbeidsteknikkene': ('arbeidsteknikk',),
'arbeidstempo': ('arbeidstempo',),
'arbeidstempoet': ('arbeidstempo',),
'arbeidstempo': ('arbeidstempo',),
'arbeidstempoer': ('arbeidstempo',),
'arbeidstempo': ('arbeidstempo',),
'arbeidstempoer': ('arbeidstempo',),
'arbeidstempi': ('arbeidstempo',),
'arbeidstempoa': ('arbeidstempo',),
'arbeidstempoene': ('arbeidstempo',),
'arbeidstempiene': ('arbeidstempo',),
'arbeidsterapeut': ('arbeidsterapeut',),
'arbeidsterapeuten': ('arbeidsterapeut',),
'arbeidsterapeuter': ('arbeidsterapeut',),
'arbeidsterapeutene': ('arbeidsterapeut',),
'arbeidsterapi': ('arbeidsterapi',),
'arbeidsterapien': ('arbeidsterapi',),
'arbeidsterapier': ('arbeidsterapi',),
'arbeidsterapiene': ('arbeidsterapi',),
'arbeidstid': ('arbeidstid',),
'arbeidstiden': ('arbeidstid',),
'arbeidstida': ('arbeidstid',),
'arbeidstider': ('arbeidstid',),
'arbeidstidene': ('arbeidstid',),
'arbeidstillatelse': ('arbeidstillatelse',),
'arbeidstillatelsen': ('arbeidstillatelse',),
'arbeidstillatelser': ('arbeidstillatelse',),
'arbeidstillatelsene': ('arbeidstillatelse',),
'arbeidstilsyn': ('arbeidstilsyn',),
'arbeidstilsynet': ('arbeidstilsyn',),
'arbeidstilsyn': ('arbeidstilsyn',),
'arbeidstilsyna': ('arbeidstilsyn',),
'arbeidstilsynene': ('arbeidstilsyn',),
'arbeidstittel': ('arbeidstittel',),
'arbeidstittelen': ('arbeidstittel',),
'arbeidstitler': ('arbeidstittel',),
'arbeidstitlene': ('arbeidstittel',),
'arbeidstrell': ('arbeidstrell',),
'arbeidstrellen': ('arbeidstrell',),
'arbeidstreller': ('arbeidstrell',),
'arbeidstrellene': ('arbeidstrell',),
'arbeidstvist': ('arbeidstvist',),
'arbeidstvisten': ('arbeidstvist',),
'arbeidstvister': ('arbeidstvist',),
'arbeidstvistene': ('arbeidstvist',),
'arbeidsuke': ('arbeidsuke',),
'arbeidsuken': ('arbeidsuke',),
'arbeidsuka': ('arbeidsuke',),
'arbeidsuker': ('arbeidsuke',),
'arbeidsukene': ('arbeidsuke',),
'arbeidsulykke': ('arbeidsulykke',),
'arbeidsulykken': ('arbeidsulykke',),
'arbeidsulykka': ('arbeidsulykke',),
'arbeidsulykker': ('arbeidsulykke',),
'arbeidsulykkene': ('arbeidsulykke',),
'arbeidsutvalg': ('arbeidsutvalg',),
'arbeidsutvalget': ('arbeidsutvalg',),
'arbeidsutvalg': ('arbeidsutvalg',),
'arbeidsutvalga': ('arbeidsutvalg',),
'arbeidsutvalgene': ('arbeidsutvalg',),
'arbeidsvilkår': ('arbeidsvilkår',),
'arbeidsvilkåret': ('arbeidsvilkår',),
'arbeidsvilkår': ('arbeidsvilkår',),
'arbeidsvilkåra': ('arbeidsvilkår',),
'arbeidsvilkårene': ('arbeidsvilkår',),
'arbeidsår': ('arbeidsår',),
'arbeidsåret': ('arbeidsår',),
'arbeidsår': ('arbeidsår',),
'arbeidsåra': ('arbeidsår',),
'arbeidsårene': ('arbeidsår',),
'arbeidsøkt': ('arbeidsøkt',),
'arbeidsøkten': ('arbeidsøkt',),
'arbeidsøkta': ('arbeidsøkt',),
'arbeidsøkter': ('arbeidsøkt',),
'arbeidsøktene': ('arbeidsøkt',),
'arbitrasje': ('arbitrasje',),
'arbitrasjen': ('arbitrasje',),
'arbitrasjer': ('arbitrasje',),
'arbitrasjene': ('arbitrasje',),
'arboret': ('arboret',),
'arboretet': ('arboret',),
'arboret': ('arboret',),
'arboreter': ('arboret',),
'arboret': ('arboret',),
'arboreter': ('arboret',),
'arboreta': ('arboret',),
'arboretene': ('arboret',),
'arboretum': ('arboretum',),
'arboretumet': ('arboretum',),
'arboretum': ('arboretum',),
'arboretumer': ('arboretum',),
'arboretum': ('arboretum',),
'arboretumer': ('arboretum',),
'arboretuma': ('arboretum',),
'arboretumene': ('arboretum',),
'ard': ('ard',),
'arden': ('ard',),
'arder': ('ard',),
'ardene': ('ard',),
'areal': ('areal',),
'arealet': ('areal',),
'areal': ('areal',),
'arealer': ('areal',),
'areal': ('areal',),
'arealer': ('areal',),
'areala': ('areal',),
'arealene': ('areal',),
'arealbruk': ('arealbruk',),
'arealbruken': ('arealbruk',),
'arealbruket': ('arealbruk',),
'arealbruker': ('arealbruk',),
'arealbruk': ('arealbruk',),
'arealbrukene': ('arealbruk',),
'arealbruka': ('arealbruk',),
'arealbrukene': ('arealbruk',),
'arealdisponering': ('arealdisponering',),
'arealdisponeringen': ('arealdisponering',),
'arealdisponeringa': ('arealdisponering',),
'arealdisponeringer': ('arealdisponering',),
'arealdisponeringene': ('arealdisponering',),
'arealplan': ('arealplan',),
'arealplanen': ('arealplan',),
'arealplaner': ('arealplan',),
'arealplanene': ('arealplan',),
'arena': ('arena',),
'arenaen': ('arena',),
'arenaer': ('arena',),
'arenaene': ('arena',),
'areometer': ('areometer',),
'areometeret': ('areometer',),
'areometret': ('areometer',),
'areometer': ('areometer',),
'areometre': ('areometer',),
'areometra': ('areometer',),
'areometrene': ('areometer',),
'areometra': ('areometer',),
'areometrene': ('areometer',),
'argentiner': ('argentiner',),
'argentineren': ('argentiner',),
'argentinere': ('argentiner',),
'argentinerne': ('argentiner',),
'argon': ('argon',),
'argonet': ('argon',),
'argon': ('argon',),
'argona': ('argon',),
'argonene': ('argon',),
'argot': ('argot',),
'argoten': ('argot',),
'argoter': ('argot',),
'argotene': ('argot',),
'argument': ('argument',),
'argumentet': ('argument',),
'argument': ('argument',),
'argumenter': ('argument',),
'argument': ('argument',),
'argumenter': ('argument',),
'argumenta': ('argument',),
'argumentene': ('argument',),
'argumentasjon': ('argumentasjon',),
'argumentasjonen': ('argumentasjon',),
'argumentasjoner': ('argumentasjon',),
'argumentasjonene': ('argumentasjon',),
'argumentering': ('argumentering',),
'argumenteringen': ('argumentering',),
'argumenteringa': ('argumentering',),
'argumenteringer': ('argumentering',),
'argumenteringene': ('argumentering',),
'argusblikk': ('argusblikk',),
'argusblikket': ('argusblikk',),
'argusblikk': ('argusblikk',),
'argusblikka': ('argusblikk',),
'argusblikkene': ('argusblikk',),
'argusøye': ('argusøye',),
'argusøyet': ('argusøye',),
'argusøyer': ('argusøye',),
'argusøyne': ('argusøye',),
'argusøyer': ('argusøye',),
'argusøya': ('argusøye',),
'argusøynene': ('argusøye',),
'argusøyene': ('argusøye',),
'ariadnetråd': ('ariadnetråd',),
'ariadnetråden': ('ariadnetråd',),
'ariadnetråder': ('ariadnetråd',),
'ariadnetrådene': ('ariadnetråd',),
'ariditet': ('ariditet',),
'ariditeten': ('ariditet',),
'ariditeter': ('ariditet',),
'ariditetene': ('ariditet',),
'arie': ('arie',),
'arien': ('arie',),
'arier': ('arie',),
'ariene': ('arie',),
'arier': ('arier',),
'arieren': ('arier',),
'ariere': ('arier',),
'arierne': ('arier',),
'arietta': ('arietta',),
'ariettaen': ('arietta',),
'ariettaer': ('arietta',),
'ariettaene': ('arietta',),
'arild': ('arild',),
'aristokrat': ('aristokrat',),
'aristokraten': ('aristokrat',),
'aristokrater': ('aristokrat',),
'aristokratene': ('aristokrat',),
'aristokrati': ('aristokrati',),
'aristokratiet': ('aristokrati',),
'aristokrati': ('aristokrati',),
'aristokratier': ('aristokrati',),
'aristokrati': ('aristokrati',),
'aristokratier': ('aristokrati',),
'aristokratia': ('aristokrati',),
'aristokratiene': ('aristokrati',),
'aritmetiker': ('aritmetiker',),
'aritmetikeren': ('aritmetiker',),
'aritmetikere': ('aritmetiker',),
'aritmetikerne': ('aritmetiker',),
'aritmetikk': ('aritmetikk',),
'aritmetikken': ('aritmetikk',),
'aritmetikker': ('aritmetikk',),
'aritmetikkene': ('aritmetikk',),
'ark': ('ark',),
'arken': ('ark',),
'arker': ('ark',),
'arkene': ('ark',),
'ark': ('ark',),
'arket': ('ark',),
'ark': ('ark',),
'arka': ('ark',),
'arkene': ('ark',),
'arkade': ('arkade',),
'arkaden': ('arkade',),
'arkader': ('arkade',),
'arkadene': ('arkade',),
'arkaisme': ('arkaisme',),
'arkaismen': ('arkaisme',),
'arkaismer': ('arkaisme',),
'arkaismene': ('arkaisme',),
'arkebuse': ('arkebuse',),
'arkebusen': ('arkebuse',),
'arkebuser': ('arkebuse',),
'arkebusene': ('arkebuse',),
'arkeolog': ('arkeolog',),
'arkeologen': ('arkeolog',),
'arkeologer': ('arkeolog',),
'arkeologene': ('arkeolog',),
'arkeologi': ('arkeologi',),
'arkeologien': ('arkeologi',),
'arkeologier': ('arkeologi',),
'arkeologiene': ('arkeologi',),
'arketyp': ('arketyp',),
'arketypen': ('arketyp',),
'arketyper': ('arketyp',),
'arketypene': ('arketyp',),
'arkipel': ('arkipel',),
'arkipelet': ('arkipel',),
'arkipel': ('arkipel',),
'arkipeler': ('arkipel',),
'arkipel': ('arkipel',),
'arkipeler': ('arkipel',),
'arkipela': ('arkipel',),
'arkipelene': ('arkipel',),
'arkitekt': ('arkitekt',),
'arkitekten': ('arkitekt',),
'arkitekter': ('arkitekt',),
'arkitektene': ('arkitekt',),
'arkitekthøgskole': ('arkitekthøgskole',),
'arkitekthøgskolen': ('arkitekthøgskole',),
'arkitekthøgskoler': ('arkitekthøgskole',),
'arkitekthøgskolene': ('arkitekthøgskole',),
'arkitekthøyskole': ('arkitekthøyskole',),
'arkitekthøyskolen': ('arkitekthøyskole',),
'arkitekthøyskoler': ('arkitekthøyskole',),
'arkitekthøyskolene': ('arkitekthøyskole',),
'arkitektkontor': ('arkitektkontor',),
'arkitektkontoret': ('arkitektkontor',),
'arkitektkontor': ('arkitektkontor',),
'arkitektkontorer': ('arkitektkontor',),
'arkitektkontor': ('arkitektkontor',),
'arkitektkontorer': ('arkitektkontor',),
'arkitektkontora': ('arkitektkontor',),
'arkitektkontorene': ('arkitektkontor',),
'arkitektur': ('arkitektur',),
'arkitekturen': ('arkitektur',),
'arkitekturer': ('arkitektur',),
'arkitekturene': ('arkitektur',),
'arkiv': ('arkiv',),
'arkivet': ('arkiv',),
'arkiv': ('arkiv',),
'arkiver': ('arkiv',),
'arkiv': ('arkiv',),
'arkiver': ('arkiv',),
'arkiva': ('arkiv',),
'arkivene': ('arkiv',),
'arkivalie': ('arkivalie',),
'arkivalien': ('arkivalie',),
'arkivalier': ('arkivalie',),
'arkivaliene': ('arkivalie',),
'arkivar': ('arkivar',),
'arkivaren': ('arkivar',),
'arkivarer': ('arkivar',),
'arkivarene': ('arkivar',),
'arkivnøkkel': ('arkivnøkkel',),
'arkivnøkkelen': ('arkivnøkkel',),
'arkivnøkler': ('arkivnøkkel',),
'arkivnøklene': ('arkivnøkkel',),
'arkivsak': ('arkivsak',),
'arkivsaken': ('arkivsak',),
'arkivsaka': ('arkivsak',),
'arkivsaker': ('arkivsak',),
'arkivsakene': ('arkivsak',),
'arkivsjef': ('arkivsjef',),
'arkivsjefen': ('arkivsjef',),
'arkivsjefer': ('arkivsjef',),
'arkivsjefene': ('arkivsjef',),
'arkivstyrer': ('arkivstyrer',),
'arkivstyreren': ('arkivstyrer',),
'arkivstyrere': ('arkivstyrer',),
'arkivstyrerne': ('arkivstyrer',),
'arkivsystem': ('arkivsystem',),
'arkivsystemet': ('arkivsystem',),
'arkivsystem': ('arkivsystem',),
'arkivsystemer': ('arkivsystem',),
'arkivsystem': ('arkivsystem',),
'arkivsystemer': ('arkivsystem',),
'arkivsystema': ('arkivsystem',),
'arkivsystemene': ('arkivsystem',),
'arkont': ('arkont',),
'arkonten': ('arkont',),
'arkonter': ('arkont',),
'arkontene': ('arkont',),
'arktikfront': ('arktikfront',),
'arktikfronten': ('arktikfront',),
'arktikfronter': ('arktikfront',),
'arktikfrontene': ('arktikfront',),
'arktikluft': ('arktikluft',),
'arktikluften': ('arktikluft',),
'arktiklufta': ('arktikluft',),
'arktiklufter': ('arktikluft',),
'arktikluftene': ('arktikluft',),
'arm': ('arm',),
'armen': ('arm',),
'armer': ('arm',),
'armene': ('arm',),
'armé': ('armé',),
'arméen': ('armé',),
'armeen': ('armé',),
'arméer': ('armé',),
'armeer': ('armé',),
'arméene': ('armé',),
'armeene': ('armé',),
'armégevær': ('armégevær',),
'armégeværet': ('armégevær',),
'armégevær': ('armégevær',),
'armégeværer': ('armégevær',),
'armégevær': ('armégevær',),
'armégeværer': ('armégevær',),
'armégeværa': ('armégevær',),
'armégeværene': ('armégevær',),
'armégruppe': ('armégruppe',),
'armégruppen': ('armégruppe',),
'armégruppa': ('armégruppe',),
'armégrupper': ('armégruppe',),
'armégruppene': ('armégruppe',),
'armada': ('armada',),
'armadaen': ('armada',),
'armadaer': ('armada',),
'armadaene': ('armada',),
'armatur': ('armatur',),
'armaturen': ('armatur',),
'armaturer': ('armatur',),
'armaturene': ('armatur',),
'armaturdel': ('armaturdel',),
'armaturdelen': ('armaturdel',),
'armaturdeler': ('armaturdel',),
'armaturdelene': ('armaturdel',),
'armaturfabrikk': ('armaturfabrikk',),
'armaturfabrikken': ('armaturfabrikk',),
'armaturfabrikker': ('armaturfabrikk',),
'armaturfabrikkene': ('armaturfabrikk',),
'armband': ('armband',),
'armbandet': ('armband',),
'armband': ('armband',),
'armbanda': ('armband',),
'armbandene': ('armband',),
'armbandsur': ('armbandsur',),
'armbandsuret': ('armbandsur',),
'armbandsur': ('armbandsur',),
'armbandsura': ('armbandsur',),
'armbandsurene': ('armbandsur',),
'armbind': ('armbind',),
'armbindet': ('armbind',),
'armbind': ('armbind',),
'armbinda': ('armbind',),
'armbindene': ('armbind',),
'armbrott': ('armbrott',),
'armbrottet': ('armbrott',),
'armbrott': ('armbrott',),
'armbrotta': ('armbrott',),
'armbrottene': ('armbrott',),
'armbrudd': ('armbrudd',),
'armbruddet': ('armbrudd',),
'armbrudd': ('armbrudd',),
'armbrudda': ('armbrudd',),
'armbruddene': ('armbrudd',),
'armbrøst': ('armbrøst',),
'armbrøsten': ('armbrøst',),
'armbrøster': ('armbrøst',),
'armbrøstene': ('armbrøst',),
'armbånd': ('armbånd',),
'armbåndet': ('armbånd',),
'armbånd': ('armbånd',),
'armbånda': ('armbånd',),
'armbåndene': ('armbånd',),
'armbåndsur': ('armbåndsur',),
'armbåndsuret': ('armbåndsur',),
'armbåndsur': ('armbåndsur',),
'armbåndsura': ('armbåndsur',),
'armbåndsurene': ('armbåndsur',),
'armener': ('armener',),
'armeneren': ('armener',),
'armenere': ('armener',),
'armenerne': ('armener',),
'armenier': ('armenier',),
'armenieren': ('armenier',),
'armeniere': ('armenier',),
'armenierne': ('armenier',),
'armensk': ('armensk',),
'armensken': ('armensk',),
'armensker': ('armensk',),
'armenskene': ('armensk',),
'armering': ('armering',),
'armeringen': ('armering',),
'armeringa': ('armering',),
'armeringer': ('armering',),
'armeringene': ('armering',),
'armeringsjern': ('armeringsjern',),
'armeringsjernet': ('armeringsjern',),
'armeringsjern': ('armeringsjern',),
'armeringsjerna': ('armeringsjern',),
'armeringsjernene': ('armeringsjern',),
'armeringsstål': ('armeringsstål',),
'armeringsstålet': ('armeringsstål',),
'armeringsstål': ('armeringsstål',),
'armeringsståla': ('armeringsstål',),
'armeringsstålene': ('armeringsstål',),
'armfoting': ('armfoting',),
'armfotingen': ('armfoting',),
'armfotinger': ('armfoting',),
'armfotingene': ('armfoting',),
'armføtting': ('armføtting',),
'armføttingen': ('armføtting',),
'armføttinger': ('armføtting',),
'armføttingene': ('armføtting',),
'armgang': ('armgang',),
'armgangen': ('armgang',),
'armganger': ('armgang',),
'armgangene': ('armgang',),
'armheving': ('armheving',),
'armhevingen': ('armheving',),
'armhevinga': ('armheving',),
'armhevinger': ('armheving',),
'armhevingene': ('armheving',),
'armhevning': ('armhevning',),
'armhevningen': ('armhevning',),
'armhevninga': ('armhevning',),
'armhevninger': ('armhevning',),
'armhevningene': ('armhevning',),
'armhole': ('armhole',),
'armholen': ('armhole',),
'armhola': ('armhole',),
'armholer': ('armhole',),
'armholene': ('armhole',),
'armhule': ('armhule',),
'armhulen': ('armhule',),
'armhula': ('armhule',),
'armhuler': ('armhule',),
'armhulene': ('armhule',),
'arming': ('arming',),
'armingen': ('arming',),
'arminger': ('arming',),
'armingene': ('arming',),
'armkrok': ('armkrok',),
'armkroken': ('armkrok',),
'armkroker': ('armkrok',),
'armkrokene': ('armkrok',),
'armlene': ('armlene',),
'armlenet': ('armlene',),
'armlener': ('armlene',),
'armlena': ('armlene',),
'armlenene': ('armlene',),
'armod': ('armod',),
'armoden': ('armod',),
'armoda': ('armod',),
'armoder': ('armod',),
'armodene': ('armod',),
'armodsdom': ('armodsdom',),
'armodsdommen': ('armodsdom',),
'armodsdommer': ('armodsdom',),
'armodsdommene': ('armodsdom',),
'armodsfolk': ('armodsfolk',),
'armodsfolket': ('armodsfolk',),
'armodsfolk': ('armodsfolk',),
'armodsfolka': ('armodsfolk',),
'armodsfolkene': ('armodsfolk',),
'armodskrek': ('armodskrek',),
'armodskreket': ('armodskrek',),
'armodskrek': ('armodskrek',),
'armodskreka': ('armodskrek',),
'armodskrekene': ('armodskrek',),
'armodskrok': ('armodskrok',),
'armodskroken': ('armodskrok',),
'armodskroker': ('armodskrok',),
'armodskrokene': ('armodskrok',),
'armodskryp': ('armodskryp',),
'armodskrypen': ('armodskryp',),
'armodskrypet': ('armodskryp',),
'armodskryp': ('armodskryp',),
'armodskrypene': ('armodskryp',),
'armodskrypa': ('armodskryp',),
'armodskrypene': ('armodskryp',),
'armodskår': ('armodskår',),
'armodskåret': ('armodskår',),
'armodskår': ('armodskår',),
'armodskåra': ('armodskår',),
'armodskårene': ('armodskår',),
'armring': ('armring',),
'armringen': ('armring',),
'armringer': ('armring',),
'armringene': ('armring',),
'armrom': ('armrom',),
'armrommet': ('armrom',),
'armrom': ('armrom',),
'armromma': ('armrom',),
'armrommene': ('armrom',),
'armslag': ('armslag',),
'armslaget': ('armslag',),
'armslag': ('armslag',),
'armslaga': ('armslag',),
'armslagene': ('armslag',),
'armsving': ('armsving',),
'armsvingen': ('armsving',),
'armsvinger': ('armsving',),
'armsvingene': ('armsving',),
'armtak': ('armtak',),
'armtaket': ('armtak',),
'armtak': ('armtak',),
'armtaka': ('armtak',),
'armtakene': ('armtak',),
'arne': ('arne',),
'arnen': ('arne',),
'arner': ('arne',),
'arnene': ('arne',),
'arnested': ('arnested',),
'arnestedet': ('arnested',),
'arnesteder': ('arnested',),
'arnestedene': ('arnested',),
'aroma': ('aroma',),
'aromaen': ('aroma',),
'aromaer': ('aroma',),
'aromaene': ('aroma',),
'arr': ('arr',),
'arret': ('arr',),
'arr': ('arr',),
'arra': ('arr',),
'arrene': ('arr',),
'arrangement': ('arrangement',),
'arrangementet': ('arrangement',),
'arrangement': ('arrangement',),
'arrangementer': ('arrangement',),
'arrangement': ('arrangement',),
'arrangementer': ('arrangement',),
'arrangementa': ('arrangement',),
'arrangementene': ('arrangement',),
'arrangør': ('arrangør',),
'arrangøren': ('arrangør',),
'arrangører': ('arrangør',),
'arrangørene': ('arrangør',),
'arrangørklubb': ('arrangørklubb',),
'arrangørklubben': ('arrangørklubb',),
'arrangørklubber': ('arrangørklubb',),
'arrangørklubbene': ('arrangørklubb',),
'arrest': ('arrest',),
'arresten': ('arrest',),
'arrester': ('arrest',),
'arrestene': ('arrest',),
'arrestant': ('arrestant',),
'arrestanten': ('arrestant',),
'arrestanter': ('arrestant',),
'arrestantene': ('arrestant',),
'arrestasjon': ('arrestasjon',),
'arrestasjonen': ('arrestasjon',),
'arrestasjoner': ('arrestasjon',),
'arrestasjonene': ('arrestasjon',),
'arrestering': ('arrestering',),
'arresteringen': ('arrestering',),
'arresteringa': ('arrestering',),
'arresteringer': ('arrestering',),
'arresteringene': ('arrestering',),
'arrestkrav': ('arrestkrav',),
'arrestkravet': ('arrestkrav',),
'arrestkrav': ('arrestkrav',),
'arrestkrava': ('arrestkrav',),
'arrestkravene': ('arrestkrav',),
'arrestlokale': ('arrestlokale',),
'arrestlokalet': ('arrestlokale',),
'arrestlokaler': ('arrestlokale',),
'arrestlokala': ('arrestlokale',),
'arrestlokalene': ('arrestlokale',),
'arrestordre': ('arrestordre',),
'arrestordren': ('arrestordre',),
'arrestordrer': ('arrestordre',),
'arrestordrene': ('arrestordre',),
'arresttillatelse': ('arresttillatelse',),
'arresttillatelsen': ('arresttillatelse',),
'arresttillatelser': ('arresttillatelse',),
'arresttillatelsene': ('arresttillatelse',),
'arrighet': ('arrighet',),
'arrigheten': ('arrighet',),
'arrigheta': ('arrighet',),
'arrigheter': ('arrighet',),
'arrighetene': ('arrighet',),
'arrigskap': ('arrigskap',),
'arrigskapen': ('arrigskap',),
'arrigskaper': ('arrigskap',),
'arrigskapene': ('arrigskap',),
'arroganse': ('arroganse',),
'arrogansen': ('arroganse',),
'arroganser': ('arroganse',),
'arrogansene': ('arroganse',),
'arrondering': ('arrondering',),
'arronderingen': ('arrondering',),
'arronderinga': ('arrondering',),
'arronderinger': ('arrondering',),
'arronderingene': ('arrondering',),
'arrondissement': ('arrondissement',),
'arrondissementet': ('arrondissement',),
'arrondissement': ('arrondissement',),
'arrondissementer': ('arrondissement',),
'arrondissement': ('arrondissement',),
'arrondissementer': ('arrondissement',),
'arrondissementa': ('arrondissement',),
'arrondissementene': ('arrondissement',),
'ars': ('ars',),
'artes': ('ars',),
'arsen': ('arsen',),
'arsenet': ('arsen',),
'arsen': ('arsen',),
'arsena': ('arsen',),
'arsenene': ('arsen',),
'arsenal': ('arsenal',),
'arsenalet': ('arsenal',),
'arsenal': ('arsenal',),
'arsenaler': ('arsenal',),
'arsenal': ('arsenal',),
'arsenaler': ('arsenal',),
'arsenala': ('arsenal',),
'arsenalene': ('arsenal',),
'arsenalforvalter': ('arsenalforvalter',),
'arsenalforvalteren': ('arsenalforvalter',),
'arsenalforvaltere': ('arsenalforvalter',),
'arsenalforvalterne': ('arsenalforvalter',),
'arsenikk': ('arsenikk',),
'arsenikken': ('arsenikk',),
'arsenikker': ('arsenikk',),
'arsenikkene': ('arsenikk',),
'arsenikkforgiftning': ('arsenikkforgiftning',),
'arsenikkforgiftningen': ('arsenikkforgiftning',),
'arsenikkforgiftninga': ('arsenikkforgiftning',),
'arsenikkforgiftninger': ('arsenikkforgiftning',),
'arsenikkforgiftningene': ('arsenikkforgiftning',),
'art': ('art',),
'arten': ('art',),
'arta': ('art',),
'arter': ('art',),
'artene': ('art',),
'arterie': ('arterie',),
'arterien': ('arterie',),
'arterier': ('arterie',),
'arteriene': ('arterie',),
'arterieblod': ('arterieblod',),
'arterieblodet': ('arterieblod',),
'arterieblod': ('arterieblod',),
'arteriebloda': ('arterieblod',),
'arterieblodene': ('arterieblod',),
'arterieklemme': ('arterieklemme',),
'arterieklemmen': ('arterieklemme',),
'arterieklemma': ('arterieklemme',),
'arterieklemmer': ('arterieklemme',),
'arterieklemmene': ('arterieklemme',),
'arteriosklerose': ('arteriosklerose',),
'arteriosklerosen': ('arteriosklerose',),
'arterioskleroser': ('arteriosklerose',),
'arteriosklerosene': ('arteriosklerose',),
'artianer': ('artianer',),
'artianeren': ('artianer',),
'artianere': ('artianer',),
'artianerne': ('artianer',),
'artighet': ('artighet',),
'artigheten': ('artighet',),
'artigheta': ('artighet',),
'artigheter': ('artighet',),
'artighetene': ('artighet',),
'artikkel': ('artikkel',),
'artikkelen': ('artikkel',),
'artikler': ('artikkel',),
'artiklene': ('artikkel',),
'artikkelforfatter': ('artikkelforfatter',),
'artikkelforfatteren': ('artikkelforfatter',),
'artikkelforfattere': ('artikkelforfatter',),
'artikkelforfatterne': ('artikkelforfatter',),
'artikkelskribent': ('artikkelskribent',),
'artikkelskribenten': ('artikkelskribent',),
'artikkelskribenter': ('artikkelskribent',),
'artikkelskribentene': ('artikkelskribent',),
'artikkelskriver': ('artikkelskriver',),
'artikkelskriveren': ('artikkelskriver',),
'artikkelskrivere': ('artikkelskriver',),
'artikkelskriverne': ('artikkelskriver',),
'artikulasjon': ('artikulasjon',),
'artikulasjonen': ('artikulasjon',),
'artikulasjoner': ('artikulasjon',),
'artikulasjonene': ('artikulasjon',),
'artikulasjonsorgan': ('artikulasjonsorgan',),
'artikulasjonsorganet': ('artikulasjonsorgan',),
'artikulasjonsorgan': ('artikulasjonsorgan',),
'artikulasjonsorganer': ('artikulasjonsorgan',),
'artikulasjonsorgan': ('artikulasjonsorgan',),
'artikulasjonsorganer': ('artikulasjonsorgan',),
'artikulasjonsorgana': ('artikulasjonsorgan',),
'artikulasjonsorganene': ('artikulasjonsorgan',),
'artikulasjonssted': ('artikulasjonssted',),
'artikulasjonsstedet': ('artikulasjonssted',),
'artikulasjonssteder': ('artikulasjonssted',),
'artikulasjonsstedene': ('artikulasjonssted',),
'artilleri': ('artilleri',),
'artilleriet': ('artilleri',),
'artilleri': ('artilleri',),
'artillerier': ('artilleri',),
'artilleri': ('artilleri',),
'artillerier': ('artilleri',),
'artilleria': ('artilleri',),
'artilleriene': ('artilleri',),
'artilleriangrep': ('artilleriangrep',),
'artilleriangrepet': ('artilleriangrep',),
'artilleriangrep': ('artilleriangrep',),
'artilleriangrepa': ('artilleriangrep',),
'artilleriangrepene': ('artilleriangrep',),
'artilleriild': ('artilleriild',),
'artilleriilden': ('artilleriild',),
'artilleriilder': ('artilleriild',),
'artilleriildene': ('artilleriild',),
'artillerioffiser': ('artillerioffiser',),
'artillerioffiseren': ('artillerioffiser',),
'artillerioffiserer': ('artillerioffiser',),
'artillerioffiserene': ('artillerioffiser',),
'artilleriregiment': ('artilleriregiment',),
'artilleriregimentet': ('artilleriregiment',),
'artilleriregiment': ('artilleriregiment',),
'artilleriregimenter': ('artilleriregiment',),
'artilleriregiment': ('artilleriregiment',),
'artilleriregimenter': ('artilleriregiment',),
'artilleriregimenta': ('artilleriregiment',),
'artilleriregimentene': ('artilleriregiment',),
'artillerist': ('artillerist',),
'artilleristen': ('artillerist',),
'artillerister': ('artillerist',),
'artilleristene': ('artillerist',),
'artisjokk': ('artisjokk',),
'artisjokken': ('artisjokk',),
'artisjokker': ('artisjokk',),
'artisjokkene': ('artisjokk',),
'artiskokk': ('artiskokk',),
'artiskokken': ('artiskokk',),
'artiskokker': ('artiskokk',),
'artiskokkene': ('artiskokk',),
'artist': ('artist',),
'artisten': ('artist',),
'artister': ('artist',),
'artistene': ('artist',),
'artisteri': ('artisteri',),
'artisteriet': ('artisteri',),
'artisteri': ('artisteri',),
'artisterier': ('artisteri',),
'artisteri': ('artisteri',),
'artisterier': ('artisteri',),
'artisteria': ('artisteri',),
'artisteriene': ('artisteri',),
'artistopptreden': ('artistopptreden',),
'artistopptredenen': ('artistopptreden',),
'artistopptredener': ('artistopptreden',),
'artistopptredenene': ('artistopptreden',),
'artium': ('artium',),
'artiumen': ('artium',),
'artiumer': ('artium',),
'artiumene': ('artium',),
'artiumsfag': ('artiumsfag',),
'artiumsfaget': ('artiumsfag',),
'artiumsfag': ('artiumsfag',),
'artiumsfaga': ('artiumsfag',),
'artiumsfagene': ('artiumsfag',),
'artiumskarakter': ('artiumskarakter',),
'artiumskarakteren': ('artiumskarakter',),
'artiumskarakterer': ('artiumskarakter',),
'artiumskarakterene': ('artiumskarakter',),
'artiumskull': ('artiumskull',),
'artiumskullet': ('artiumskull',),
'artiumskull': ('artiumskull',),
'artiumskulla': ('artiumskull',),
'artiumskullene': ('artiumskull',),
'artiumslinje': ('artiumslinje',),
'artiumslinjen': ('artiumslinje',),
'artiumslinja': ('artiumslinje',),
'artiumslinjer': ('artiumslinje',),
'artiumslinjene': ('artiumslinje',),
'artiumsresultat': ('artiumsresultat',),
'artiumsresultatet': ('artiumsresultat',),
'artiumsresultat': ('artiumsresultat',),
'artiumsresultater': ('artiumsresultat',),
'artiumsresultat': ('artiumsresultat',),
'artiumsresultater': ('artiumsresultat',),
'artiumsresultata': ('artiumsresultat',),
'artiumsresultatene': ('artiumsresultat',),
'artiumsvitnesbyrd': ('artiumsvitnesbyrd',),
'artiumsvitnesbyrdet': ('artiumsvitnesbyrd',),
'artiumsvitnesbyrd': ('artiumsvitnesbyrd',),
'artiumsvitnesbyrda': ('artiumsvitnesbyrd',),
'artiumsvitnesbyrdene': ('artiumsvitnesbyrd',),
'artiumsår': ('artiumsår',),
'artiumsåret': ('artiumsår',),
'artiumsår': ('artiumsår',),
'artiumsåra': ('artiumsår',),
'artiumsårene': ('artiumsår',),
'artotek': ('artotek',),
'artoteket': ('artotek',),
'artotek': ('artotek',),
'artoteker': ('artotek',),
'artotek': ('artotek',),
'artoteker': ('artotek',),
'artoteka': ('artotek',),
'artotekene': ('artotek',),
'artritt': ('artritt',),
'artritten': ('artritt',),
'artritter': ('artritt',),
'artrittene': ('artritt',),
'artsbetegnelse': ('artsbetegnelse',),
'artsbetegnelsen': ('artsbetegnelse',),
'artsbetegnelser': ('artsbetegnelse',),
'artsbetegnelsene': ('artsbetegnelse',),
'artsforskjell': ('artsforskjell',),
'artsforskjellen': ('artsforskjell',),
'artsforskjeller': ('artsforskjell',),
'artsforskjellene': ('artsforskjell',),
'artsforsøk': ('artsforsøk',),
'artsforsøket': ('artsforsøk',),
'artsforsøk': ('artsforsøk',),
'artsforsøka': ('artsforsøk',),
'artsforsøkene': ('artsforsøk',),
'artsfredning': ('artsfredning',),
'artsfredningen': ('artsfredning',),
'artsfredninga': ('artsfredning',),
'artsfredninger': ('artsfredning',),
'artsfredningene': ('artsfredning',),
'artskarakter': ('artskarakter',),
'artskarakteren': ('artskarakter',),
'artskarakterer': ('artskarakter',),
'artskarakterene': ('artskarakter',),
'artskrysning': ('artskrysning',),
'artskrysningen': ('artskrysning',),
'artskrysninga': ('artskrysning',),
'artskrysninger': ('artskrysning',),
'artskrysningene': ('artskrysning',),
'artskryssing': ('artskryssing',),
'artskryssingen': ('artskryssing',),
'artskryssinga': ('artskryssing',),
'artskryssinger': ('artskryssing',),
'artskryssingene': ('artskryssing',),
'artsnavn': ('artsnavn',),
'artsnavnet': ('artsnavn',),
'artsnavn': ('artsnavn',),
'artsnavna': ('artsnavn',),
'artsnavnene': ('artsnavn',),
'arv': ('arv',),
'arven': ('arv',),
'arver': ('arv',),
'arvene': ('arv',),
'arve': ('arve',),
'arven': ('arve',),
'arver': ('arve',),
'arvene': ('arve',),
'arveanlegg': ('arveanlegg',),
'arveanlegget': ('arveanlegg',),
'arveanlegg': ('arveanlegg',),
'arveanlegga': ('arveanlegg',),
'arveanleggene': ('arveanlegg',),
'arveavgift': ('arveavgift',),
'arveavgiften': ('arveavgift',),
'arveavgifta': ('arveavgift',),
'arveavgifter': ('arveavgift',),
'arveavgiftene': ('arveavgift',),
'arvefall': ('arvefall',),
'arvefallet': ('arvefall',),
'arvefall': ('arvefall',),
'arvefalla': ('arvefall',),
'arvefallene': ('arvefall',),
'arvefeste': ('arvefeste',),
'arvefestet': ('arvefeste',),
'arvefester': ('arvefeste',),
'arvefesta': ('arvefeste',),
'arvefestene': ('arvefeste',),
'arvefiende': ('arvefiende',),
'arvefienden': ('arvefiende',),
'arvefiender': ('arvefiende',),
'arvefiendene': ('arvefiende',),
'arvefyrste': ('arvefyrste',),
'arvefyrsten': ('arvefyrste',),
'arvefyrster': ('arvefyrste',),
'arvefyrstene': ('arvefyrste',),
'arvefølge': ('arvefølge',),
'arvefølgen': ('arvefølge',),
'arvefølger': ('arvefølge',),
'arvefølgene': ('arvefølge',),
'arvefølgelov': ('arvefølgelov',),
'arvefølgeloven': ('arvefølgelov',),
'arvefølgelover': ('arvefølgelov',),
'arvefølgelovene': ('arvefølgelov',),
'arvegods': ('arvegods',),
'arvegodset': ('arvegods',),
'arvegods': ('arvegods',),
'arvegodsa': ('arvegods',),
'arvegodsene': ('arvegods',),
'arvehygiene': ('arvehygiene',),
'arvehygienen': ('arvehygiene',),
'arvehygiener': ('arvehygiene',),
'arvehygienene': ('arvehygiene',),
'arvekonge': ('arvekonge',),
'arvekongen': ('arvekonge',),
'arvekonger': ('arvekonge',),
'arvekongene': ('arvekonge',),
'arvekrav': ('arvekrav',),
'arvekravet': ('arvekrav',),
'arvekrav': ('arvekrav',),
'arvekrava': ('arvekrav',),
'arvekravene': ('arvekrav',),
'arvelater': ('arvelater',),
'arvelateren': ('arvelater',),
'arvelatere': ('arvelater',),
'arvelaterne': ('arvelater',),
'arvelighetsforsking': ('arvelighetsforsking',),
'arvelighetsforskingen': ('arvelighetsforsking',),
'arvelighetsforskinga': ('arvelighetsforsking',),
'arvelighetsforskinger': ('arvelighetsforsking',),
'arvelighetsforskingene': ('arvelighetsforsking',),
'arvelighetsforskning': ('arvelighetsforskning',),
'arvelighetsforskningen': ('arvelighetsforskning',),
'arvelighetsforskninga': ('arvelighetsforskning',),
'arvelighetsforskninger': ('arvelighetsforskning',),
'arvelighetsforskningene': ('arvelighetsforskning',),
'arvelodd': ('arvelodd',),
'arvelodden': ('arvelodd',),
'arvelodder': ('arvelodd',),
'arveloddene': ('arvelodd',),
'arvelott': ('arvelott',),
'arvelotten': ('arvelott',),
'arvelotter': ('arvelott',),
'arvelottene': ('arvelott',),
'arvelov': ('arvelov',),
'arveloven': ('arvelov',),
'arvelover': ('arvelov',),
'arvelovene': ('arvelov',),
'arvelære': ('arvelære',),
'arvelæren': ('arvelære',),
'arvelæra': ('arvelære',),
'arvelærer': ('arvelære',),
'arvelærene': ('arvelære',),
'arveonkel': ('arveonkel',),
'arveonkelen': ('arveonkel',),
'arveonkler': ('arveonkel',),
'arveonklene': ('arveonkel',),
'arveord': ('arveord',),
'arveordet': ('arveord',),
'arveord': ('arveord',),
'arveorda': ('arveord',),
'arveordene': ('arveord',),
'arvepakt': ('arvepakt',),
'arvepakten': ('arvepakt',),
'arvepakta': ('arvepakt',),
'arvepakter': ('arvepakt',),
'arvepaktene': ('arvepakt',),
'arveprins': ('arveprins',),
'arveprinsen': ('arveprins',),
'arveprinser': ('arveprins',),
'arveprinsene': ('arveprins',),
'arverett': ('arverett',),
'arveretten': ('arverett',),
'arveretter': ('arverett',),
'arverettene': ('arverett',),
'arvesmykke': ('arvesmykke',),
'arvesmykket': ('arvesmykke',),
'arvesmykker': ('arvesmykke',),
'arvesmykka': ('arvesmykke',),
'arvesmykkene': ('arvesmykke',),
'arvestykke': ('arvestykke',),
'arvestykket': ('arvestykke',),
'arvestykker': ('arvestykke',),
'arvestykka': ('arvestykke',),
'arvestykkene': ('arvestykke',),
'arvesynd': ('arvesynd',),
'arvesynden': ('arvesynd',),
'arvesynda': ('arvesynd',),
'arvesynder': ('arvesynd',),
'arvesyndene': ('arvesynd',),
'arvesølv': ('arvesølv',),
'arvesølvet': ('arvesølv',),
'arvesølv': ('arvesølv',),
'arvesølva': ('arvesølv',),
'arvesølvene': ('arvesølv',),
'arvetante': ('arvetante',),
'arvetanten': ('arvetante',),
'arvetanta': ('arvetante',),
'arvetanter': ('arvetante',),
'arvetantene': ('arvetante',),
'arvetvist': ('arvetvist',),
'arvetvisten': ('arvetvist',),
'arvetvister': ('arvetvist',),
'arvetvistene': ('arvetvist',),
'arveøl': ('arveøl',),
'arveølet': ('arveøl',),
'arveøl': ('arveøl',),
'arveøla': ('arveøl',),
'arveølene': ('arveøl',),
'arving': ('arving',),
'arvingen': ('arving',),
'arvinger': ('arving',),
'arvingene': ('arving',),
'arvtaker': ('arvtaker',),
'arvtakeren': ('arvtaker',),
'arvtakere': ('arvtaker',),
'arvtakerne': ('arvtaker',),
'as': ('as',),
'aset': ('as',),
'as': ('as',),
'asa': ('as',),
'asene': ('as',),
'asal': ('asal',),
'asalen': ('asal',),
'asaler': ('asal',),
'asalene': ('asal',),
'asalbær': ('asalbær',),
'asalbæret': ('asalbær',),
'asalbær': ('asalbær',),
'asalbæra': ('asalbær',),
'asalbærene': ('asalbær',),
'asalea': ('asalea',),
'asaleaen': ('asalea',),
'asaleaer': ('asalea',),
'asaleaene': ('asalea',),
'asbest': ('asbest',),
'asbesten': ('asbest',),
'asbester': ('asbest',),
'asbestene': ('asbest',),
'asbestduk': ('asbestduk',),
'asbestduken': ('asbestduk',),
'asbestduker': ('asbestduk',),
'asbestdukene': ('asbestduk',),
'asbestose': ('asbestose',),
'asbestosen': ('asbestose',),
'asbestoser': ('asbestose',),
'asbestosene': ('asbestose',),
'asbestpapp': ('asbestpapp',),
'asbestpappen': ('asbestpapp',),
'asbestpapper': ('asbestpapp',),
'asbestpappene': ('asbestpapp',),
'asbestplate': ('asbestplate',),
'asbestplaten': ('asbestplate',),
'asbestplata': ('asbestplate',),
'asbestplater': ('asbestplate',),
'asbestplatene': ('asbestplate',),
'ascendens': ('ascendens',),
'ascendensen': ('ascendens',),
'ascendenser': ('ascendens',),
'ascendensene': ('ascendens',),
'ascendent': ('ascendent',),
'ascendenten': ('ascendent',),
'ascendenter': ('ascendent',),
'ascendentene': ('ascendent',),
'asdic': ('asdic',),
'asdicen': ('asdic',),
'asdicer': ('asdic',),
'asdicene': ('asdic',),
'asen': ('asen',),
'asenet': ('asen',),
'asen': ('asen',),
'asener': ('asen',),
'asen': ('asen',),
'asener': ('asen',),
'asena': ('asen',),
'asenene': ('asen',),
'aseptikk': ('aseptikk',),
'aseptikken': ('aseptikk',),
'aseptikker': ('aseptikk',),
'aseptikkene': ('aseptikk',),
'aserbajdsjaner': ('aserbajdsjaner',),
'aserbajdsjaneren': ('aserbajdsjaner',),
'aserbajdsjanere': ('aserbajdsjaner',),
'aserbajdsjanerne': ('aserbajdsjaner',),
'asfalt': ('asfalt',),
'asfalten': ('asfalt',),
'asfalter': ('asfalt',),
'asfaltene': ('asfalt',),
'asfaltdekke': ('asfaltdekke',),
'asfaltdekket': ('asfaltdekke',),
'asfaltdekker': ('asfaltdekke',),
'asfaltdekka': ('asfaltdekke',),
'asfaltdekkene': ('asfaltdekke',),
'asfaltjungel': ('asfaltjungel',),
'asfaltjungelen': ('asfaltjungel',),
'asfaltjungler': ('asfaltjungel',),
'asfaltjunglene': ('asfaltjungel',),
'asfaltpapp': ('asfaltpapp',),
'asfaltpappen': ('asfaltpapp',),
'asfaltpapper': ('asfaltpapp',),
'asfaltpappene': ('asfaltpapp',),
'asfaltsliter': ('asfaltsliter',),
'asfaltsliteren': ('asfaltsliter',),
'asfaltslitere': ('asfaltsliter',),
'asfaltsliterne': ('asfaltsliter',),
'asfalttraver': ('asfalttraver',),
'asfalttraveren': ('asfalttraver',),
'asfalttravere': ('asfalttraver',),
'asfalttraverne': ('asfalttraver',),
'asiasjuke': ('asiasjuke',),
'asiasjuken': ('asiasjuke',),
'asiasjuker': ('asiasjuke',),
'asiasjukene': ('asiasjuke',),
'asiasyke': ('asiasyke',),
'asiasyken': ('asiasyke',),
'asiasyker': ('asiasyke',),
'asiasykene': ('asiasyke',),
'asiat': ('asiat',),
'asiaten': ('asiat',),
'asiater': ('asiat',),
'asiatene': ('asiat',),
'asimut': ('asimut',),
'asimuten': ('asimut',),
'asimuter': ('asimut',),
'asimutene': ('asimut',),
'asimutspeil': ('asimutspeil',),
'asimutspeilet': ('asimutspeil',),
'asimutspeil': ('asimutspeil',),
'asimutspeila': ('asimutspeil',),
'asimutspeilene': ('asimutspeil',),
'asjett': ('asjett',),
'asjetten': ('asjett',),
'asjetter': ('asjett',),
'asjettene': ('asjett',),
'ask': ('ask',),
'asken': ('ask',),
'asker': ('ask',),
'askene': ('ask',),
'aske': ('aske',),
'asken': ('aske',),
'aska': ('aske',),
'asker': ('aske',),
'askene': ('aske',),
'askebeger': ('askebeger',),
'askebegeret': ('askebeger',),
'askebeger': ('askebeger',),
'askebegre': ('askebeger',),
'askebegra': ('askebeger',),
'askebegrene': ('askebeger',),
'askebegra': ('askebeger',),
'askebegrene': ('askebeger',),
'askeladd': ('askeladd',),
'askeladden': ('askeladd',),
'askeladder': ('askeladd',),
'askeladdene': ('askeladd',),
'askenas': ('askenas',),
'askenasen': ('askenas',),
'askenaser': ('askenas',),
'askenasene': ('askenas',),
'askeonsdag': ('askeonsdag',),
'askeonsdagen': ('askeonsdag',),
'askeonsdager': ('askeonsdag',),
'askeonsdagene': ('askeonsdag',),
'askepott': ('askepott',),
'askepotten': ('askepott',),
'askepotter': ('askepott',),
'askepottene': ('askepott',),
'askese': ('askese',),
'askesen': ('askese',),
'askeser': ('askese',),
'askesene': ('askese',),
'asket': ('asket',),
'asketen': ('asket',),
'asketer': ('asket',),
'asketene': ('asket',),
'asketre': ('asketre',),
'asketreet': ('asketre',),
'asketre': ('asketre',),
'asketrær': ('asketre',),
'asketrea': ('asketre',),
'asketrærne': ('asketre',),
'askeved': ('askeved',),
'askeveden': ('askeved',),
'askeveder': ('askeved',),
'askevedene': ('askeved',),
'askorbinsyre': ('askorbinsyre',),
'askorbinsyren': ('askorbinsyre',),
'askorbinsyra': ('askorbinsyre',),
'askorbinsyrer': ('askorbinsyre',),
'askorbinsyrene': ('askorbinsyre',),
'asp': ('asp',),
'aspen': ('asp',),
'aspa': ('asp',),
'asper': ('asp',),
'aspene': ('asp',),
'asparges': ('asparges',),
'aspargesen': ('asparges',),
'aspargeser': ('asparges',),
'aspargesene': ('asparges',),
'aspargesbønne': ('aspargesbønne',),
'aspargesbønnen': ('aspargesbønne',),
'aspargesbønna': ('aspargesbønne',),
'aspargesbønner': ('aspargesbønne',),
'aspargesbønnene': ('aspargesbønne',),
'aspargesplante': ('aspargesplante',),
'aspargesplanten': ('aspargesplante',),
'aspargesplanta': ('aspargesplante',),
'aspargesplanter': ('aspargesplante',),
'aspargesplantene': ('aspargesplante',),
'aspargessuppe': ('aspargessuppe',),
'aspargessuppen': ('aspargessuppe',),
'aspargessuppa': ('aspargessuppe',),
'aspargessupper': ('aspargessuppe',),
'aspargessuppene': ('aspargessuppe',),
'aspekt': ('aspekt',),
'aspekten': ('aspekt',),
'aspektet': ('aspekt',),
'aspekter': ('aspekt',),
'aspekt': ('aspekt',),
'aspekter': ('aspekt',),
'aspekt': ('aspekt',),
'aspekter': ('aspekt',),
'aspektene': ('aspekt',),
'aspekta': ('aspekt',),
'aspektene': ('aspekt',),
'aspelauv': ('aspelauv',),
'aspelauvet': ('aspelauv',),
'aspelauv': ('aspelauv',),
'aspelauva': ('aspelauv',),
'aspelauvene': ('aspelauv',),
'aspeløv': ('aspeløv',),
'aspeløvet': ('aspeløv',),
'aspeløv': ('aspeløv',),
'aspeløva': ('aspeløv',),
'aspeløvene': ('aspeløv',),
'aspidistra': ('aspidistra',),
'aspidistraen': ('aspidistra',),
'aspidistraer': ('aspidistra',),
'aspidistraene': ('aspidistra',),
'aspik': ('aspik',),
'aspiken': ('aspik',),
'aspiker': ('aspik',),
'aspikene': ('aspik',),
'aspirant': ('aspirant',),
'aspiranten': ('aspirant',),
'aspiranter': ('aspirant',),
'aspirantene': ('aspirant',),
'aspirasjon': ('aspirasjon',),
'aspirasjonen': ('aspirasjon',),
'aspirasjoner': ('aspirasjon',),
'aspirasjonene': ('aspirasjon',),
'aspirasjonsnivå': ('aspirasjonsnivå',),
'aspirasjonsnivået': ('aspirasjonsnivå',),
'aspirasjonsnivå': ('aspirasjonsnivå',),
'aspirasjonsnivåer': ('aspirasjonsnivå',),
'aspirasjonsnivå': ('aspirasjonsnivå',),
'aspirasjonsnivåer': ('aspirasjonsnivå',),
'aspirasjonsnivåa': ('aspirasjonsnivå',),
'aspirasjonsnivåene': ('aspirasjonsnivå',),
'ass': ('ass',),
'assen': ('ass',),
'asser': ('ass',),
'assene': ('ass',),
'ass-moll': ('ass-moll',),
'ass-mollen': ('ass-moll',),
'ass-moller': ('ass-moll',),
'ass-mollene': ('ass-moll',),
'assessor': ('assessor',),
'assessoren': ('assessor',),
'assessorer': ('assessor',),
'assessorene': ('assessor',),
'assimilasjon': ('assimilasjon',),
'assimilasjonen': ('assimilasjon',),
'assimilasjoner': ('assimilasjon',),
'assimilasjonene': ('assimilasjon',),
'assimilasjonsevne': ('assimilasjonsevne',),
'assimilasjonsevnen': ('assimilasjonsevne',),
'assimilasjonsevna': ('assimilasjonsevne',),
'assimilasjonsevner': ('assimilasjonsevne',),
'assimilasjonsevnene': ('assimilasjonsevne',),
'assimilasjonsorgan': ('assimilasjonsorgan',),
'assimilasjonsorganet': ('assimilasjonsorgan',),
'assimilasjonsorgan': ('assimilasjonsorgan',),
'assimilasjonsorganer': ('assimilasjonsorgan',),
'assimilasjonsorgan': ('assimilasjonsorgan',),
'assimilasjonsorganer': ('assimilasjonsorgan',),
'assimilasjonsorgana': ('assimilasjonsorgan',),
'assimilasjonsorganene': ('assimilasjonsorgan',),
'assimilering': ('assimilering',),
'assimileringen': ('assimilering',),
'assimileringa': ('assimilering',),
'assimileringer': ('assimilering',),
'assimileringene': ('assimilering',),
'assistanse': ('assistanse',),
'assistansen': ('assistanse',),
'assistanser': ('assistanse',),
'assistansene': ('assistanse',),
'assistent': ('assistent',),
'assistenten': ('assistent',),
'assistenter': ('assistent',),
'assistentene': ('assistent',),
'assistentlege': ('assistentlege',),
'assistentlegen': ('assistentlege',),
'assistentleger': ('assistentlege',),
'assistentlegene': ('assistentlege',),
'assistentstilling': ('assistentstilling',),
'assistentstillingen': ('assistentstilling',),
'assistentstillinga': ('assistentstilling',),
'assistentstillinger': ('assistentstilling',),
'assistentstillingene': ('assistentstilling',),
'assonans': ('assonans',),
'assonansen': ('assonans',),
'assonanser': ('assonans',),
'assonansene': ('assonans',),
'assortiment': ('assortiment',),
'assortimentet': ('assortiment',),
'assortiment': ('assortiment',),
'assortimenter': ('assortiment',),
'assortiment': ('assortiment',),
'assortimenter': ('assortiment',),
'assortimenta': ('assortiment',),
'assortimentene': ('assortiment',),
'assosiasjon': ('assosiasjon',),
'assosiasjonen': ('assosiasjon',),
'assosiasjoner': ('assosiasjon',),
'assosiasjonene': ('assosiasjon',),
'assosiasjonspsykologi': ('assosiasjonspsykologi',),
'assosiasjonspsykologien': ('assosiasjonspsykologi',),
'assosiasjonspsykologier': ('assosiasjonspsykologi',),
'assosiasjonspsykologiene': ('assosiasjonspsykologi',),
'assurandør': ('assurandør',),
'assurandøren': ('assurandør',),
'assurandører': ('assurandør',),
'assurandørene': ('assurandør',),
'assuranse': ('assuranse',),
'assuransen': ('assuranse',),
'assuranser': ('assuranse',),
'assuransene': ('assuranse',),
'assuransepremie': ('assuransepremie',),
'assuransepremien': ('assuransepremie',),
'assuransepremier': ('assuransepremie',),
'assuransepremiene': ('assuransepremie',),
'assuranseselskap': ('assuranseselskap',),
'assuranseselskapet': ('assuranseselskap',),
'assuranseselskap': ('assuranseselskap',),
'assuranseselskaper': ('assuranseselskap',),
'assuranseselskap': ('assuranseselskap',),
'assuranseselskaper': ('assuranseselskap',),
'assuranseselskapa': ('assuranseselskap',),
'assuranseselskapene': ('assuranseselskap',),
'assuransesvik': ('assuransesvik',),
'assuransesviket': ('assuransesvik',),
'assuransesvik': ('assuransesvik',),
'assuransesvika': ('assuransesvik',),
'assuransesvikene': ('assuransesvik',),
'assyrer': ('assyrer',),
'assyreren': ('assyrer',),
'assyrere': ('assyrer',),
'assyrerne': ('assyrer',),
'assyriolog': ('assyriolog',),
'assyriologen': ('assyriolog',),
'assyriologer': ('assyriolog',),
'assyriologene': ('assyriolog',),
'assyriologi': ('assyriologi',),
'assyriologien': ('assyriologi',),
'assyriologier': ('assyriologi',),
'assyriologiene': ('assyriologi',),
'astat': ('astat',),
'astatet': ('astat',),
'astat': ('astat',),
'astata': ('astat',),
'astatene': ('astat',),
'asteni': ('asteni',),
'astenien': ('asteni',),
'astenier': ('asteni',),
'asteniene': ('asteni',),
'asteniker': ('asteniker',),
'astenikeren': ('asteniker',),
'astenikere': ('asteniker',),
'astenikerne': ('asteniker',),
'asterisk': ('asterisk',),
'asterisken': ('asterisk',),
'asterisker': ('asterisk',),
'asteriskene': ('asterisk',),
'asteroide': ('asteroide',),
'asteroiden': ('asteroide',),
'asteroider': ('asteroide',),
'asteroidene': ('asteroide',),
'asters': ('asters',),
'astersen': ('asters',),
'asterser': ('asters',),
'astersene': ('asters',),
'astersbed': ('astersbed',),
'astersbedet': ('astersbed',),
'astersbed': ('astersbed',),
'astersbeda': ('astersbed',),
'astersbedene': ('astersbed',),
'astersbukett': ('astersbukett',),
'astersbuketten': ('astersbukett',),
'astersbuketter': ('astersbukett',),
'astersbukettene': ('astersbukett',),
'astigmatiker': ('astigmatiker',),
'astigmatikeren': ('astigmatiker',),
'astigmatikere': ('astigmatiker',),
'astigmatikerne': ('astigmatiker',),
'astigmatisme': ('astigmatisme',),
'astigmatismen': ('astigmatisme',),
'astigmatismer': ('astigmatisme',),
'astigmatismene': ('astigmatisme',),
'astma': ('astma',),
'astmaen': ('astma',),
'astmaer': ('astma',),
'astmaene': ('astma',),
'astmabarn': ('astmabarn',),
'astmabarnet': ('astmabarn',),
'astmabarn': ('astmabarn',),
'astmabarna': ('astmabarn',),
'astmabarnene': ('astmabarn',),
'astmatiker': ('astmatiker',),
'astmatikeren': ('astmatiker',),
'astmatikere': ('astmatiker',),
'astmatikerne': ('astmatiker',),
'astrakan': ('astrakan',),
'astrakanen': ('astrakan',),
'astrakanet': ('astrakan',),
'astrakaner': ('astrakan',),
'astrakan': ('astrakan',),
'astrakanene': ('astrakan',),
'astrakana': ('astrakan',),
'astrakanene': ('astrakan',),
'astrakaneple': ('astrakaneple',),
'astrakaneplet': ('astrakaneple',),
'astrakanepler': ('astrakaneple',),
'astrakanepla': ('astrakaneple',),
'astrakaneplene': ('astrakaneple',),
'astrakanhue': ('astrakanhue',),
'astrakanhuen': ('astrakanhue',),
'astrakanhua': ('astrakanhue',),
'astrakanhuer': ('astrakanhue',),
'astrakanhuene': ('astrakanhue',),
'astrakanlue': ('astrakanlue',),
'astrakanluen': ('astrakanlue',),
'astrakanlua': ('astrakanlue',),
'astrakanluer': ('astrakanlue',),
'astrakanluene': ('astrakanlue',),
'astrakanskinn': ('astrakanskinn',),
'astrakanskinnet': ('astrakanskinn',),
'astrakanskinn': ('astrakanskinn',),
'astrakanskinna': ('astrakanskinn',),
'astrakanskinnene': ('astrakanskinn',),
'astrallegeme': ('astrallegeme',),
'astrallegemet': ('astrallegeme',),
'astrallegemer': ('astrallegeme',),
'astrallegema': ('astrallegeme',),
'astrallegemene': ('astrallegeme',),
'astrofotometri': ('astrofotometri',),
'astrofotometrien': ('astrofotometri',),
'astrofotometrier': ('astrofotometri',),
'astrofotometriene': ('astrofotometri',),
'astrofysikk': ('astrofysikk',),
'astrofysikken': ('astrofysikk',),
'astrofysikker': ('astrofysikk',),
'astrofysikkene': ('astrofysikk',),
'astrolog': ('astrolog',),
'astrologen': ('astrolog',),
'astrologer': ('astrolog',),
'astrologene': ('astrolog',),
'astrologi': ('astrologi',),
'astrologien': ('astrologi',),
'astrologier': ('astrologi',),
'astrologiene': ('astrologi',),
'astrometri': ('astrometri',),
'astrometrien': ('astrometri',),
'astrometrier': ('astrometri',),
'astrometriene': ('astrometri',),
'astronaut': ('astronaut',),
'astronauten': ('astronaut',),
'astronauter': ('astronaut',),
'astronautene': ('astronaut',),
'astronautikk': ('astronautikk',),
'astronautikken': ('astronautikk',),
'astronautikker': ('astronautikk',),
'astronautikkene': ('astronautikk',),
'astronom': ('astronom',),
'astronomen': ('astronom',),
'astronomer': ('astronom',),
'astronomene': ('astronom',),
'astronomi': ('astronomi',),
'astronomien': ('astronomi',),
'astronomier': ('astronomi',),
'astronomiene': ('astronomi',),
'asur': ('asur',),
'asuren': ('asur',),
'asurer': ('asur',),
'asurene': ('asur',),
'asurblått': ('asurblått',),
'asyl': ('asyl',),
'asylet': ('asyl',),
'asyl': ('asyl',),
'asyler': ('asyl',),
'asyl': ('asyl',),
'asyler': ('asyl',),
'asyla': ('asyl',),
'asylene': ('asyl',),
'asylrett': ('asylrett',),
'asylretten': ('asylrett',),
'asylretter': ('asylrett',),
'asylrettene': ('asylrett',),
'asymmetri': ('asymmetri',),
'asymmetrien': ('asymmetri',),
'asymmetrier': ('asymmetri',),
'asymmetriene': ('asymmetri',),
'asymptote': ('asymptote',),
'asymptoten': ('asymptote',),
'asymptoter': ('asymptote',),
'asymptotene': ('asymptote',),
'asyndese': ('asyndese',),
'asyndesen': ('asyndese',),
'asyndeser': ('asyndese',),
'asyndesene': ('asyndese',),
'asynkronmotor': ('asynkronmotor',),
'asynkronmotoren': ('asynkronmotor',),
'asynkronmotorer': ('asynkronmotor',),
'asynkronmotorene': ('asynkronmotor',),
'at-setning': ('at-setning',),
'at-setningen': ('at-setning',),
'at-setninga': ('at-setning',),
'at-setninger': ('at-setning',),
'at-setningene': ('at-setning',),
'ataraksikum': ('ataraksikum',),
'ataraksikumet': ('ataraksikum',),
'ataraksika': ('ataraksikum',),
'ataraksikaene': ('ataraksikum',),
'atavisme': ('atavisme',),
'atavismen': ('atavisme',),
'atavismer': ('atavisme',),
'atavismene': ('atavisme',),
'ateisme': ('ateisme',),
'ateismen': ('ateisme',),
'ateismer': ('ateisme',),
'ateismene': ('ateisme',),
'ateist': ('ateist',),
'ateisten': ('ateist',),
'ateister': ('ateist',),
'ateistene': ('ateist',),
'atelier': ('atelier',),
'atelieret': ('atelier',),
'atelier': ('atelier',),
'atelierer': ('atelier',),
'atelier': ('atelier',),
'atelierer': ('atelier',),
'ateliera': ('atelier',),
'atelierene': ('atelier',),
'atener': ('atener',),
'ateneren': ('atener',),
'atenere': ('atener',),
'atenerne': ('atener',),
'ateneum': ('ateneum',),
'ateneumet': ('ateneum',),
'ateneum': ('ateneum',),
'ateneumer': ('ateneum',),
'ateneum': ('ateneum',),
'ateneumer': ('ateneum',),
'ateneuma': ('ateneum',),
'ateneumene': ('ateneum',),
'aterosklerose': ('aterosklerose',),
'aterosklerosen': ('aterosklerose',),
'ateroskleroser': ('aterosklerose',),
'aterosklerosene': ('aterosklerose',),
'atferd': ('atferd',),
'atferden': ('atferd',),
'atferda': ('atferd',),
'atferder': ('atferd',),
'atferdene': ('atferd',),
'atferdsforsking': ('atferdsforsking',),
'atferdsforskingen': ('atferdsforsking',),
'atferdsforskinga': ('atferdsforsking',),
'atferdsforskinger': ('atferdsforsking',),
'atferdsforskingene': ('atferdsforsking',),
'atferdsforskning': ('atferdsforskning',),
'atferdsforskningen': ('atferdsforskning',),
'atferdsforskninga': ('atferdsforskning',),
'atferdsforskninger': ('atferdsforskning',),
'atferdsforskningene': ('atferdsforskning',),
'atferdsforstyrrelse': ('atferdsforstyrrelse',),
'atferdsforstyrrelsen': ('atferdsforstyrrelse',),
'atferdsforstyrrelser': ('atferdsforstyrrelse',),
'atferdsforstyrrelsene': ('atferdsforstyrrelse',),
'atferdsmønster': ('atferdsmønster',),
'atferdsmønsteret': ('atferdsmønster',),
'atferdsmønstret': ('atferdsmønster',),
'atferdsmønster': ('atferdsmønster',),
'atferdsmønstre': ('atferdsmønster',),
'atferdsmønstra': ('atferdsmønster',),
'atferdsmønstrene': ('atferdsmønster',),
'atferdsmønstra': ('atferdsmønster',),
'atferdsmønstrene': ('atferdsmønster',),
'atferdsnorm': ('atferdsnorm',),
'atferdsnormen': ('atferdsnorm',),
'atferdsnormer': ('atferdsnorm',),
'atferdsnormene': ('atferdsnorm',),
'atferdspsykologi': ('atferdspsykologi',),
'atferdspsykologien': ('atferdspsykologi',),
'atferdspsykologier': ('atferdspsykologi',),
'atferdspsykologiene': ('atferdspsykologi',),
'atferdsterapi': ('atferdsterapi',),
'atferdsterapien': ('atferdsterapi',),
'atferdsterapier': ('atferdsterapi',),
'atferdsterapiene': ('atferdsterapi',),
'atferdsvanske': ('atferdsvanske',),
'atferdsvansken': ('atferdsvanske',),
'atferdsvansker': ('atferdsvanske',),
'atferdsvanskene': ('atferdsvanske',),
'atgeir': ('atgeir',),
'atgeiren': ('atgeir',),
'atgeirer': ('atgeir',),
'atgeirene': ('atgeir',),
'athener': ('athener',),
'atheneren': ('athener',),
'athenere': ('athener',),
'athenerne': ('athener',),
'atkomst': ('atkomst',),
'atkomsten': ('atkomst',),
'atkomster': ('atkomst',),
'atkomstene': ('atkomst',),
'atkomstdokument': ('atkomstdokument',),
'atkomstdokumentet': ('atkomstdokument',),
'atkomstdokument': ('atkomstdokument',),
'atkomstdokumenter': ('atkomstdokument',),
'atkomstdokument': ('atkomstdokument',),
'atkomstdokumenter': ('atkomstdokument',),
'atkomstdokumenta': ('atkomstdokument',),
'atkomstdokumentene': ('atkomstdokument',),
'atkomstmangel': ('atkomstmangel',),
'atkomstmangelen': ('atkomstmangel',),
'atkomstmangler': ('atkomstmangel',),
'atkomstmanglene': ('atkomstmangel',),
'atkomstveg': ('atkomstveg',),
'atkomstvegen': ('atkomstveg',),
'atkomstveger': ('atkomstveg',),
'atkomstvegene': ('atkomstveg',),
'atkomstvei': ('atkomstvei',),
'atkomstveien': ('atkomstvei',),
'atkomstveier': ('atkomstvei',),
'atkomstveiene': ('atkomstvei',),
'atlant': ('atlant',),
'atlanten': ('atlant',),
'atlanter': ('atlant',),
'atlantene': ('atlant',),
'atlas': ('atlas',),
'atlaset': ('atlas',),
'atlas': ('atlas',),
'atlaser': ('atlas',),
'atlas': ('atlas',),
'atlaser': ('atlas',),
'atlasa': ('atlas',),
'atlasene': ('atlas',),
'atlask': ('atlask',),
'atlasken': ('atlask',),
'atlasker': ('atlask',),
'atlaskene': ('atlask',),
'atlaskbrokade': ('atlaskbrokade',),
'atlaskbrokaden': ('atlaskbrokade',),
'atlaskbrokader': ('atlaskbrokade',),
'atlaskbrokadene': ('atlaskbrokade',),
'atlaskkjole': ('atlaskkjole',),
'atlaskkjolen': ('atlaskkjole',),
'atlaskkjoler': ('atlaskkjole',),
'atlaskkjolene': ('atlaskkjole',),
'atlet': ('atlet',),
'atleten': ('atlet',),
'atleter': ('atlet',),
'atletene': ('atlet',),
'atmosfære': ('atmosfære',),
'atmosfæren': ('atmosfære',),
'atmosfærer': ('atmosfære',),
'atmosfærene': ('atmosfære',),
'atoll': ('atoll',),
'atollen': ('atoll',),
'atoller': ('atoll',),
'atollene': ('atoll',),
'atom': ('atom',),
'atomet': ('atom',),
'atom': ('atom',),
'atomer': ('atom',),
'atom': ('atom',),
'atomer': ('atom',),
'atoma': ('atom',),
'atomene': ('atom',),
'atomalder': ('atomalder',),
'atomalderen': ('atomalder',),
'atomaldere': ('atomalder',),
'atomaldrer': ('atomalder',),
'atomaldre': ('atomalder',),
'atomalderne': ('atomalder',),
'atomaldrene': ('atomalder',),
'atombombe': ('atombombe',),
'atombomben': ('atombombe',),
'atombomba': ('atombombe',),
'atombomber': ('atombombe',),
'atombombene': ('atombombe',),
'atomenergi': ('atomenergi',),
'atomenergien': ('atomenergi',),
'atomenergier': ('atomenergi',),
'atomenergiene': ('atomenergi',),
'atomforsker': ('atomforsker',),
'atomforskeren': ('atomforsker',),
'atomforskere': ('atomforsker',),
'atomforskerne': ('atomforsker',),
'atomforsking': ('atomforsking',),
'atomforskingen': ('atomforsking',),
'atomforskinga': ('atomforsking',),
'atomforskinger': ('atomforsking',),
'atomforskingene': ('atomforsking',),
'atomforskning': ('atomforskning',),
'atomforskningen': ('atomforskning',),
'atomforskninga': ('atomforskning',),
'atomforskninger': ('atomforskning',),
'atomforskningene': ('atomforskning',),
'atomfysikk': ('atomfysikk',),
'atomfysikken': ('atomfysikk',),
'atomfysikker': ('atomfysikk',),
'atomfysikkene': ('atomfysikk',),
'atomisme': ('atomisme',),
'atomismen': ('atomisme',),
'atomismer': ('atomisme',),
'atomismene': ('atomisme',),
'atomkjerne': ('atomkjerne',),
'atomkjernen': ('atomkjerne',),
'atomkjerner': ('atomkjerne',),
'atomkjernene': ('atomkjerne',),
'atomkraft': ('atomkraft',),
'atomkraften': ('atomkraft',),
'atomkrafta': ('atomkraft',),
'atomkrefter': ('atomkraft',),
'atomkreftene': ('atomkraft',),
'atomkraftverk': ('atomkraftverk',),
'atomkraftverket': ('atomkraftverk',),
'atomkraftverk': ('atomkraftverk',),
'atomkraftverker': ('atomkraftverk',),
'atomkraftverk': ('atomkraftverk',),
'atomkraftverker': ('atomkraftverk',),
'atomkraftverka': ('atomkraftverk',),
'atomkraftverkene': ('atomkraftverk',),
'atomkrig': ('atomkrig',),
'atomkrigen': ('atomkrig',),
'atomkriger': ('atomkrig',),
'atomkrigene': ('atomkrig',),
'atomladning': ('atomladning',),
'atomladningen': ('atomladning',),
'atomladninga': ('atomladning',),
'atomladninger': ('atomladning',),
'atomladningene': ('atomladning',),
'atommasse': ('atommasse',),
'atommassen': ('atommasse',),
'atommasser': ('atommasse',),
'atommassene': ('atommasse',),
'atommile': ('atommile',),
'atommilen': ('atommile',),
'atommila': ('atommile',),
'atommiler': ('atommile',),
'atommilene': ('atommile',),
'atomnummer': ('atomnummer',),
'atomnummeret': ('atomnummer',),
'atomnummer': ('atomnummer',),
'atomnumre': ('atomnummer',),
'atomnumra': ('atomnummer',),
'atomnumrene': ('atomnummer',),
'atomnumra': ('atomnummer',),
'atomnumrene': ('atomnummer',),
'atomreaktor': ('atomreaktor',),
'atomreaktoren': ('atomreaktor',),
'atomreaktorer': ('atomreaktor',),
'atomreaktorene': ('atomreaktor',),
'atomspalting': ('atomspalting',),
'atomspaltingen': ('atomspalting',),
'atomspaltinga': ('atomspalting',),
'atomspaltinger': ('atomspalting',),
'atomspaltingene': ('atomspalting',),
'atomspaltning': ('atomspaltning',),
'atomspaltningen': ('atomspaltning',),
'atomspaltninga': ('atomspaltning',),
'atomspaltninger': ('atomspaltning',),
'atomspaltningene': ('atomspaltning',),
'atomteori': ('atomteori',),
'atomteorien': ('atomteori',),
'atomteorier': ('atomteori',),
'atomteoriene': ('atomteori',),
'atomur': ('atomur',),
'atomuret': ('atomur',),
'atomur': ('atomur',),
'atomura': ('atomur',),
'atomurene': ('atomur',),
'atomvekt': ('atomvekt',),
'atomvekten': ('atomvekt',),
'atomvekta': ('atomvekt',),
'atomvekter': ('atomvekt',),
'atomvektene': ('atomvekt',),
'atomvåpen': ('atomvåpen',),
'atomvåpenet': ('atomvåpen',),
'atomvåpen': ('atomvåpen',),
'atomvåpna': ('atomvåpen',),
'atomvåpnene': ('atomvåpen',),
'atonalitet': ('atonalitet',),
'atonaliteten': ('atonalitet',),
'atonaliteter': ('atonalitet',),
'atonalitetene': ('atonalitet',),
'atrium': ('atrium',),
'atriet': ('atrium',),
'atrier': ('atrium',),
'atria': ('atrium',),
'atriene': ('atrium',),
'atriumhage': ('atriumhage',),
'atriumhagen': ('atriumhage',),
'atriumhager': ('atriumhage',),
'atriumhagene': ('atriumhage',),
'atriumhus': ('atriumhus',),
'atriumhuset': ('atriumhus',),
'atriumhus': ('atriumhus',),
'atriumhusa': ('atriumhus',),
'atriumhusene': ('atriumhus',),
'atrofi': ('atrofi',),
'atrofien': ('atrofi',),
'atrofier': ('atrofi',),
'atrofiene': ('atrofi',),
'atropin': ('atropin',),
'atropinet': ('atropin',),
'atropin': ('atropin',),
'atropina': ('atropin',),
'atropinene': ('atropin',),
'atropininjeksjon': ('atropininjeksjon',),
'atropininjeksjonen': ('atropininjeksjon',),
'atropininjeksjoner': ('atropininjeksjon',),
'atropininjeksjonene': ('atropininjeksjon',),
'atropintablett': ('atropintablett',),
'atropintabletten': ('atropintablett',),
'atropintabletter': ('atropintablett',),
'atropintablettene': ('atropintablett',),
'atskillelse': ('atskillelse',),
'atskillelsen': ('atskillelse',),
'atskillelser': ('atskillelse',),
'atskillelsene': ('atskillelse',),
'atspredelse': ('atspredelse',),
'atspredelsen': ('atspredelse',),
'atspredelser': ('atspredelse',),
'atspredelsene': ('atspredelse',),
'attaché': ('attaché',),
'attachéen': ('attaché',),
'attacheen': ('attaché',),
'attachéer': ('attaché',),
'attacheer': ('attaché',),
'attachéene': ('attaché',),
'attacheene': ('attaché',),
'attakk': ('attakk',),
'attakket': ('attakk',),
'attakk': ('attakk',),
'attakker': ('attakk',),
'attakk': ('attakk',),
'attakker': ('attakk',),
'attakka': ('attakk',),
'attakkene': ('attakk',),
'attendel': ('attendel',),
'attendelen': ('attendel',),
'attendeler': ('attendel',),
'attendelene': ('attendel',),
'attenhundretall': ('attenhundretall',),
'attenhundretallet': ('attenhundretall',),
'attenhundretall': ('attenhundretall',),
'attenhundretalla': ('attenhundretall',),
'attenhundretallene': ('attenhundretall',),
'attentat': ('attentat',),
'attentatet': ('attentat',),
'attentat': ('attentat',),
'attentater': ('attentat',),
'attentat': ('attentat',),
'attentater': ('attentat',),
'attentata': ('attentat',),
'attentatene': ('attentat',),
'attentatforsøk': ('attentatforsøk',),
'attentatforsøket': ('attentatforsøk',),
'attentatforsøk': ('attentatforsøk',),
'attentatforsøka': ('attentatforsøk',),
'attentatforsøkene': ('attentatforsøk',),
'attentatmann': ('attentatmann',),
'attentatmannen': ('attentatmann',),
'attentatmenn': ('attentatmann',),
'attentatmennene': ('attentatmann',),
'attenåring': ('attenåring',),
'attenåringen': ('attenåring',),
'attenåringer': ('attenåring',),
'attenåringene': ('attenåring',),
'attenårsalder': ('attenårsalder',),
'attenårsalderen': ('attenårsalder',),
'attenårsaldere': ('attenårsalder',),
'attenårsaldrer': ('attenårsalder',),
'attenårsaldre': ('attenårsalder',),
'attenårsalderne': ('attenårsalder',),
'attenårsaldrene': ('attenårsalder',),
'attenårsgrense': ('attenårsgrense',),
'attenårsgrensen': ('attenårsgrense',),
'attenårsgrensa': ('attenårsgrense',),
'attenårsgrenser': ('attenårsgrense',),
'attenårsgrensene': ('attenårsgrense',),
'atterbud': ('atterbud',),
'atterbudet': ('atterbud',),
'atterbud': ('atterbud',),
'atterbuda': ('atterbud',),
'atterbudene': ('atterbud',),
'attergløyme': ('attergløyme',),
'attergløymen': ('attergløyme',),
'attergløyma': ('attergløyme',),
'attergløymer': ('attergløyme',),
'attergløymene': ('attergløyme',),
'attersting': ('attersting',),
'atterstinget': ('attersting',),
'attersting': ('attersting',),
'atterstinga': ('attersting',),
'atterstingene': ('attersting',),
'attest': ('attest',),
'attesten': ('attest',),
'attester': ('attest',),
'attestene': ('attest',),
'attestant': ('attestant',),
'attestanten': ('attestant',),
'attestanter': ('attestant',),
'attestantene': ('attestant',),
'attestasjon': ('attestasjon',),
'attestasjonen': ('attestasjon',),
'attestasjoner': ('attestasjon',),
'attestasjonene': ('attestasjon',),
'attestering': ('attestering',),
'attesteringen': ('attestering',),
'attesteringa': ('attestering',),
'attesteringer': ('attestering',),
'attesteringene': ('attestering',),
'attestkopi': ('attestkopi',),
'attestkopien': ('attestkopi',),
'attestkopier': ('attestkopi',),
'attestkopiene': ('attestkopi',),
'attføring': ('attføring',),
'attføringen': ('attføring',),
'attføringa': ('attføring',),
'attføringer': ('attføring',),
'attføringene': ('attføring',),
'attføringsinstitutt': ('attføringsinstitutt',),
'attføringsinstituttet': ('attføringsinstitutt',),
'attføringsinstitutt': ('attføringsinstitutt',),
'attføringsinstitutter': ('attføringsinstitutt',),
'attføringsinstitutt': ('attføringsinstitutt',),
'attføringsinstitutter': ('attføringsinstitutt',),
'attføringsinstitutta': ('attføringsinstitutt',),
'attføringsinstituttene': ('attføringsinstitutt',),
'attføringstrygd': ('attføringstrygd',),
'attføringstrygden': ('attføringstrygd',),
'attføringstrygda': ('attføringstrygd',),
'attføringstrygder': ('attføringstrygd',),
'attføringstrygdene': ('attføringstrygd',),
'attityde': ('attityde',),
'attityden': ('attityde',),
'attityder': ('attityde',),
'attitydene': ('attityde',),
'attpåklatt': ('attpåklatt',),
'attpåklatten': ('attpåklatt',),
'attpåklatter': ('attpåklatt',),
'attpåklattene': ('attpåklatt',),
'attpåsleng': ('attpåsleng',),
'attpåslenget': ('attpåsleng',),
'attpåsleng': ('attpåsleng',),
'attpåslenga': ('attpåsleng',),
'attpåslengene': ('attpåsleng',),
'attraksjon': ('attraksjon',),
'attraksjonen': ('attraksjon',),
'attraksjoner': ('attraksjon',),
'attraksjonene': ('attraksjon',),
'attrapp': ('attrapp',),
'attrappen': ('attrapp',),
'attrapper': ('attrapp',),
'attrappene': ('attrapp',),
'attributt': ('attributt',),
'attributtet': ('attributt',),
'attributt': ('attributt',),
'attributter': ('attributt',),
'attributt': ('attributt',),
'attributter': ('attributt',),
'attributta': ('attributt',),
'attributtene': ('attributt',),
'attrå': ('attrå',),
'attråen': ('attrå',),
'attråer': ('attrå',),
'attråene': ('attrå',),
'attåtarbeid': ('attåtarbeid',),
'attåtarbeidet': ('attåtarbeid',),
'attåtarbeid': ('attåtarbeid',),
'attåtarbeider': ('attåtarbeid',),
'attåtarbeid': ('attåtarbeid',),
'attåtarbeider': ('attåtarbeid',),
'attåtarbeida': ('attåtarbeid',),
'attåtarbeidene': ('attåtarbeid',),
'attåtnæring': ('attåtnæring',),
'attåtnæringen': ('attåtnæring',),
'attåtnæringa': ('attåtnæring',),
'attåtnæringer': ('attåtnæring',),
'attåtnæringene': ('attåtnæring',),
'atypi': ('atypi',),
'atypien': ('atypi',),
'atypier': ('atypi',),
'atypiene': ('atypi',),
'au': ('au',),
'auet': ('au',),
'au': ('au',),
'aua': ('au',),
'auene': ('au',),
'au pair': ('au pair',),
'aubergine': ('aubergine',),
'auberginen': ('aubergine',),
'auberginer': ('aubergine',),
'auberginene': ('aubergine',),
'audiens': ('audiens',),
'audiensen': ('audiens',),
'audienser': ('audiens',),
'audiensene': ('audiens',),
'audiensrom': ('audiensrom',),
'audiensrommet': ('audiensrom',),
'audiensrom': ('audiensrom',),
'audiensromma': ('audiensrom',),
'audiensrommene': ('audiensrom',),
'audienssal': ('audienssal',),
'audienssalen': ('audienssal',),
'audienssaler': ('audienssal',),
'audienssalene': ('audienssal',),
'audiolog': ('audiolog',),
'audiologen': ('audiolog',),
'audiologer': ('audiolog',),
'audiologene': ('audiolog',),
'audiologi': ('audiologi',),
'audiologien': ('audiologi',),
'audiologier': ('audiologi',),
'audiologiene': ('audiologi',),
'audiometer': ('audiometer',),
'audiometeret': ('audiometer',),
'audiometret': ('audiometer',),
'audiometer': ('audiometer',),
'audiometre': ('audiometer',),
'audiometra': ('audiometer',),
'audiometrene': ('audiometer',),
'audiometra': ('audiometer',),
'audiometrene': ('audiometer',),
'auditorium': ('auditorium',),
'auditoriet': ('auditorium',),
'auditorier': ('auditorium',),
'auditoria': ('auditorium',),
'auditoriene': ('auditorium',),
'augiasstall': ('augiasstall',),
'augiasstallen': ('augiasstall',),
'augiasstaller': ('augiasstall',),
'augiasstallene': ('augiasstall',),
'augur': ('augur',),
'auguren': ('augur',),
'augurer': ('augur',),
'augurene': ('augur',),
'augursmil': ('augursmil',),
'augursmilen': ('augursmil',),
'augursmilet': ('augursmil',),
'augursmil': ('augursmil',),
'augursmilene': ('augursmil',),
'augursmila': ('augursmil',),
'augursmilene': ('augursmil',),
'august': ('august',),
'augustiner': ('augustiner',),
'augustineren': ('augustiner',),
'augustinere': ('augustiner',),
'augustinerne': ('augustiner',),
'augustinerkloster': ('augustinerkloster',),
'augustinerklosteret': ('augustinerkloster',),
'augustinerklostret': ('augustinerkloster',),
'augustinerkloster': ('augustinerkloster',),
'augustinerklostre': ('augustinerkloster',),
'augustinerklostra': ('augustinerkloster',),
'augustinerklostrene': ('augustinerkloster',),
'augustinerklostra': ('augustinerkloster',),
'augustinerklostrene': ('augustinerkloster',),
'augustinermunk': ('augustinermunk',),
'augustinermunken': ('augustinermunk',),
'augustinermunker': ('augustinermunk',),
'augustinermunkene': ('augustinermunk',),
'augustinernonne': ('augustinernonne',),
'augustinernonnen': ('augustinernonne',),
'augustinernonna': ('augustinernonne',),
'augustinernonner': ('augustinernonne',),
'augustinernonnene': ('augustinernonne',),
'auke': ('auke',),
'auken': ('auke',),
'auker': ('auke',),
'aukene': ('auke',),
'auking': ('auking',),
'aukingen': ('auking',),
'aukinga': ('auking',),
'aukinger': ('auking',),
'aukingene': ('auking',),
'aukingsmonn': ('aukingsmonn',),
'aukingsmonnen': ('aukingsmonn',),
'aukingsmonnet': ('aukingsmonn',),
'aukingsmonner': ('aukingsmonn',),
'aukingsmonn': ('aukingsmonn',),
'aukingsmonnene': ('aukingsmonn',),
'aukingsmonna': ('aukingsmonn',),
'aukingsmonnene': ('aukingsmonn',),
'auksjon': ('auksjon',),
'auksjonen': ('auksjon',),
'auksjoner': ('auksjon',),
'auksjonene': ('auksjon',),
'auksjonarius': ('auksjonarius',),
'auksjonariusen': ('auksjonarius',),
'auksjonarier': ('auksjonarius',),
'auksjonariene': ('auksjonarius',),
'auksjonsbord': ('auksjonsbord',),
'auksjonsbordet': ('auksjonsbord',),
'auksjonsbord': ('auksjonsbord',),
'auksjonsborder': ('auksjonsbord',),
'auksjonsbord': ('auksjonsbord',),
'auksjonsborder': ('auksjonsbord',),
'auksjonsborda': ('auksjonsbord',),
'auksjonsbordene': ('auksjonsbord',),
'auksjonsforretning': ('auksjonsforretning',),
'auksjonsforretningen': ('auksjonsforretning',),
'auksjonsforretninga': ('auksjonsforretning',),
'auksjonsforretninger': ('auksjonsforretning',),
'auksjonsforretningene': ('auksjonsforretning',),
'auksjonsgrunnlag': ('auksjonsgrunnlag',),
'auksjonsgrunnlaget': ('auksjonsgrunnlag',),
'auksjonsgrunnlag': ('auksjonsgrunnlag',),
'auksjonsgrunnlaga': ('auksjonsgrunnlag',),
'auksjonsgrunnlagene': ('auksjonsgrunnlag',),
'auksjonshammar': ('auksjonshammar',),
'auksjonshammaren': ('auksjonshammar',),
'auksjonshamrer': ('auksjonshammar',),
'auksjonshamrene': ('auksjonshammar',),
'auksjonshammer': ('auksjonshammer',),
'auksjonshammeren': ('auksjonshammer',),
'auksjonshammere': ('auksjonshammer',),
'auksjonshamrer': ('auksjonshammer',),
'auksjonshamre': ('auksjonshammer',),
'auksjonshammerne': ('auksjonshammer',),
'auksjonshamrene': ('auksjonshammer',),
'auksjonskatalog': ('auksjonskatalog',),
'auksjonskatalogen': ('auksjonskatalog',),
'auksjonskataloger': ('auksjonskatalog',),
'auksjonskatalogene': ('auksjonskatalog',),
'auksjonslokale': ('auksjonslokale',),
'auksjonslokalet': ('auksjonslokale',),
'auksjonslokaler': ('auksjonslokale',),
'auksjonslokala': ('auksjonslokale',),
'auksjonslokalene': ('auksjonslokale',),
'aula': ('aula',),
'aulaen': ('aula',),
'aulaer': ('aula',),
'aulaene': ('aula',),
'aur': ('aur',),
'auren': ('aur',),
'aurer': ('aur',),
'aurene': ('aur',),
'aura': ('aura',),
'auraen': ('aura',),
'auraer': ('aura',),
'auraene': ('aura',),
'aurbakke': ('aurbakke',),
'aurbakken': ('aurbakke',),
'aurbakker': ('aurbakke',),
'aurbakkene': ('aurbakke',),
'aurbotn': ('aurbotn',),
'aurbotnen': ('aurbotn',),
'aurbotner': ('aurbotn',),
'aurbotnene': ('aurbotn',),
'aurbunn': ('aurbunn',),
'aurbunnen': ('aurbunn',),
'aurbunner': ('aurbunn',),
'aurbunnene': ('aurbunn',),
'aure': ('aure',),
'auren': ('aure',),
'aurer': ('aure',),
'aurene': ('aure',),
'aurikkel': ('aurikkel',),
'aurikkelen': ('aurikkel',),
'aurikler': ('aurikkel',),
'auriklene': ('aurikkel',),
'aurjord': ('aurjord',),
'aurjorden': ('aurjord',),
'aurjorda': ('aurjord',),
'aurjorder': ('aurjord',),
'aurjordene': ('aurjord',),
'aurora': ('aurora',),
'auroraen': ('aurora',),
'auroraer': ('aurora',),
'auroraene': ('aurora',),
'aurum': ('aurum',),
'ause': ('ause',),
'ausen': ('ause',),
'ausa': ('ause',),
'auser': ('ause',),
'ausene': ('ause',),
'ausefat': ('ausefat',),
'ausefatet': ('ausefat',),
'ausefat': ('ausefat',),
'ausefater': ('ausefat',),
'ausefat': ('ausefat',),
'ausefater': ('ausefat',),
'ausefata': ('ausefat',),
'ausefatene': ('ausefat',),
'ausekar': ('ausekar',),
'ausekaret': ('ausekar',),
'ausekar': ('ausekar',),
'ausekara': ('ausekar',),
'ausekarene': ('ausekar',),
'auspisier': ('auspisier',),
'auspisiene': ('auspisier',),
'aust': ('aust',),
'austasiat': ('austasiat',),
'austasiaten': ('austasiat',),
'austasiater': ('austasiat',),
'austasiatene': ('austasiat',),
'austavind': ('austavind',),
'austavinden': ('austavind',),
'austavinder': ('austavind',),
'austavindene': ('austavind',),
'austavær': ('austavær',),
'austaværet': ('austavær',),
'austavær': ('austavær',),
'austaværa': ('austavær',),
'austaværene': ('austavær',),
'austblokk': ('austblokk',),
'austblokken': ('austblokk',),
'austblokka': ('austblokk',),
'austblokker': ('austblokk',),
'austblokkene': ('austblokk',),
'austblokkland': ('austblokkland',),
'austblokklandet': ('austblokkland',),
'austblokkland': ('austblokkland',),
'austblokklanda': ('austblokkland',),
'austblokklandene': ('austblokkland',),
'austerveg': ('austerveg',),
'austeuropeer': ('austeuropeer',),
'austeuropeeren': ('austeuropeer',),
'austeuropeere': ('austeuropeer',),
'austeuropeerne': ('austeuropeer',),
'austfront': ('austfront',),
'austfronten': ('austfront',),
'austfronter': ('austfront',),
'austfrontene': ('austfront',),
'austgoter': ('austgoter',),
'austgoteren': ('austgoter',),
'austgotere': ('austgoter',),
'austgoterne': ('austgoter',),
'austhandel': ('austhandel',),
'austhandelen': ('austhandel',),
'austhandler': ('austhandel',),
'austhandlene': ('austhandel',),
'austhimmel': ('austhimmel',),
'austhimmelen': ('austhimmel',),
'austhimler': ('austhimmel',),
'austhimlene': ('austhimmel',),
'austkant': ('austkant',),
'austkanten': ('austkant',),
'austkanter': ('austkant',),
'austkantene': ('austkant',),
'austkyst': ('austkyst',),
'austkysten': ('austkyst',),
'austkyster': ('austkyst',),
'austkystene': ('austkyst',),
'austlandsk': ('austlandsk',),
'austlandsken': ('austlandsk',),
'austlandsker': ('austlandsk',),
'austlandskene': ('austlandsk',),
'austlandsmål': ('austlandsmål',),
'austlandsmålet': ('austlandsmål',),
'austlandsmål': ('austlandsmål',),
'austlandsmåla': ('austlandsmål',),
'austlandsmålene': ('austlandsmål',),
'austlending': ('austlending',),
'austlendingen': ('austlending',),
'austlendinger': ('austlending',),
'austlendingene': ('austlending',),
'austmark': ('austmark',),
'austmarken': ('austmark',),
'austmarka': ('austmark',),
'austmarker': ('austmark',),
'austmarkene': ('austmark',),
'austnorsk': ('austnorsk',),
'austnorsken': ('austnorsk',),
'austnorsker': ('austnorsk',),
'austnorskene': ('austnorsk',),
'australier': ('australier',),
'australieren': ('australier',),
'australiere': ('australier',),
'australierne': ('australier',),
'australneger': ('australneger',),
'australnegeren': ('australneger',),
'australnegere': ('australneger',),
'australnegrer': ('australneger',),
'australnegre': ('australneger',),
'australnegerne': ('australneger',),
'australnegrene': ('australneger',),
'austromarxisme': ('austromarxisme',),
'austromarxismen': ('austromarxisme',),
'austromarxismer': ('austromarxisme',),
'austromarxismene': ('austromarxisme',),
'austromarxist': ('austromarxist',),
'austromarxisten': ('austromarxist',),
'austromarxister': ('austromarxist',),
'austromarxistene': ('austromarxist',),
'austside': ('austside',),
'austsiden': ('austside',),
'austsida': ('austside',),
'austsider': ('austside',),
'austsidene': ('austside',),
'austtysker': ('austtysker',),
'austtyskeren': ('austtysker',),
'austtyskere': ('austtysker',),
'austtyskerne': ('austtysker',),
'autark': ('autark',),
'autarken': ('autark',),
'autarker': ('autark',),
'autarkene': ('autark',),
'autarki': ('autarki',),
'autarkiet': ('autarki',),
'autarki': ('autarki',),
'autarkier': ('autarki',),
'autarki': ('autarki',),
'autarkier': ('autarki',),
'autarkia': ('autarki',),
'autarkiene': ('autarki',),
'autentisitet': ('autentisitet',),
'autentisiteten': ('autentisitet',),
'autentisiteter': ('autentisitet',),
'autentisitetene': ('autentisitet',),
'autisme': ('autisme',),
'autismen': ('autisme',),
'autismer': ('autisme',),
'autismene': ('autisme',),
'autist': ('autist',),
'autisten': ('autist',),
'autister': ('autist',),
'autistene': ('autist',),
'autjunksjon': ('autjunksjon',),
'autjunksjonen': ('autjunksjon',),
'autjunksjoner': ('autjunksjon',),
'autjunksjonene': ('autjunksjon',),
'auto': ('auto',),
'autobiografi': ('autobiografi',),
'autobiografien': ('autobiografi',),
'autobiografier': ('autobiografi',),
'autobiografiene': ('autobiografi',),
'autodafé': ('autodafé',),
'autodaféen': ('autodafé',),
'autodafeen': ('autodafé',),
'autodaféer': ('autodafé',),
'autodafeer': ('autodafé',),
'autodaféene': ('autodafé',),
'autodafeene': ('autodafé',),
'autodidakt': ('autodidakt',),
'autodidakten': ('autodidakt',),
'autodidakter': ('autodidakt',),
'autodidaktene': ('autodidakt',),
'autodiesel': ('autodiesel',),
'autodieselen': ('autodiesel',),
'autodiesler': ('autodiesel',),
'autodieslene': ('autodiesel',),
'autogenapparat': ('autogenapparat',),
'autogenapparatet': ('autogenapparat',),
'autogenapparat': ('autogenapparat',),
'autogenapparater': ('autogenapparat',),
'autogenapparat': ('autogenapparat',),
'autogenapparater': ('autogenapparat',),
'autogenapparata': ('autogenapparat',),
'autogenapparatene': ('autogenapparat',),
'autogensveising': ('autogensveising',),
'autogensveisingen': ('autogensveising',),
'autogensveisinga': ('autogensveising',),
'autogensveisinger': ('autogensveising',),
'autogensveisingene': ('autogensveising',),
'autograf': ('autograf',),
'autografen': ('autograf',),
'autografer': ('autograf',),
'autografene': ('autograf',),
'autografjeger': ('autografjeger',),
'autografjegeren': ('autografjeger',),
'autografjegere': ('autografjeger',),
'autografjegerne': ('autografjeger',),
'autografsamler': ('autografsamler',),
'autografsamleren': ('autografsamler',),
'autografsamlere': ('autografsamler',),
'autografsamlerne': ('autografsamler',),
'autoklav': ('autoklav',),
'autoklaven': ('autoklav',),
'autoklaver': ('autoklav',),
'autoklavene': ('autoklav',),
'autokrat': ('autokrat',),
'autokraten': ('autokrat',),
'autokrater': ('autokrat',),
'autokratene': ('autokrat',),
'autokrati': ('autokrati',),
'autokratiet': ('autokrati',),
'autokrati': ('autokrati',),
'autokratier': ('autokrati',),
'autokrati': ('autokrati',),
'autokratier': ('autokrati',),
'autokratia': ('autokrati',),
'autokratiene': ('autokrati',),
'autolyse': ('autolyse',),
'autolysen': ('autolyse',),
'autolyser': ('autolyse',),
'autolysene': ('autolyse',),
'automasjon': ('automasjon',),
'automasjonen': ('automasjon',),
'automasjoner': ('automasjon',),
'automasjonene': ('automasjon',),
'automat': ('automat',),
'automaten': ('automat',),
'automater': ('automat',),
'automatene': ('automat',),
'automatgir': ('automatgir',),
'automatgiret': ('automatgir',),
'automatgir': ('automatgir',),
'automatgira': ('automatgir',),
'automatgirene': ('automatgir',),
'automatikk': ('automatikk',),
'automatikken': ('automatikk',),
'automatikker': ('automatikk',),
'automatikkene': ('automatikk',),
'automatisering': ('automatisering',),
'automatiseringen': ('automatisering',),
'automatiseringa': ('automatisering',),
'automatiseringer': ('automatisering',),
'automatiseringene': ('automatisering',),
'automatsentral': ('automatsentral',),
'automatsentralen': ('automatsentral',),
'automatsentraler': ('automatsentral',),
'automatsentralene': ('automatsentral',),
'automattelefon': ('automattelefon',),
'automattelefonen': ('automattelefon',),
'automattelefoner': ('automattelefon',),
'automattelefonene': ('automattelefon',),
'automatvåpen': ('automatvåpen',),
'automatvåpenet': ('automatvåpen',),
'automatvåpen': ('automatvåpen',),
'automatvåpna': ('automatvåpen',),
'automatvåpnene': ('automatvåpen',),
'automobil': ('automobil',),
'automobilen': ('automobil',),
'automobiler': ('automobil',),
'automobilene': ('automobil',),
'automobilklubb': ('automobilklubb',),
'automobilklubben': ('automobilklubb',),
'automobilklubber': ('automobilklubb',),
'automobilklubbene': ('automobilklubb',),
'autonomi': ('autonomi',),
'autonomien': ('autonomi',),
'autonomier': ('autonomi',),
'autonomiene': ('autonomi',),
'autopilot': ('autopilot',),
'autopiloten': ('autopilot',),
'autopiloter': ('autopilot',),
'autopilotene': ('autopilot',),
'autopsi': ('autopsi',),
'autopsien': ('autopsi',),
'autopsier': ('autopsi',),
'autopsiene': ('autopsi',),
'autor': ('autor',),
'autoren': ('autor',),
'autorer': ('autor',),
'autorene': ('autor',),
'autoreksemplar': ('autoreksemplar',),
'autoreksemplaret': ('autoreksemplar',),
'autoreksemplar': ('autoreksemplar',),
'autoreksemplarer': ('autoreksemplar',),
'autoreksemplar': ('autoreksemplar',),
'autoreksemplarer': ('autoreksemplar',),
'autoreksemplara': ('autoreksemplar',),
'autoreksemplarene': ('autoreksemplar',),
'autorhonorar': ('autorhonorar',),
'autorhonoraret': ('autorhonorar',),
'autorhonorar': ('autorhonorar',),
'autorhonorarer': ('autorhonorar',),
'autorhonorar': ('autorhonorar',),
'autorhonorarer': ('autorhonorar',),
'autorhonorara': ('autorhonorar',),
'autorhonorarene': ('autorhonorar',),
'autorisasjon': ('autorisasjon',),
'autorisasjonen': ('autorisasjon',),
'autorisasjoner': ('autorisasjon',),
'autorisasjonene': ('autorisasjon',),
'autorisasjonsprøve': ('autorisasjonsprøve',),
'autorisasjonsprøven': ('autorisasjonsprøve',),
'autorisasjonsprøva': ('autorisasjonsprøve',),
'autorisasjonsprøver': ('autorisasjonsprøve',),
'autorisasjonsprøvene': ('autorisasjonsprøve',),
'autoritet': ('autoritet',),
'autoriteten': ('autoritet',),
'autoriteter': ('autoritet',),
'autoritetene': ('autoritet',),
'autoritetsfrykt': ('autoritetsfrykt',),
'autoritetsfrykten': ('autoritetsfrykt',),
'autoritetsfrykter': ('autoritetsfrykt',),
'autoritetsfryktene': ('autoritetsfrykt',),
'autoritetstru': ('autoritetstru',),
'autoritetstruen': ('autoritetstru',),
'autoritetstrua': ('autoritetstru',),
'autoritetstruer': ('autoritetstru',),
'autoritetstruene': ('autoritetstru',),
'autostrada': ('autostrada',),
'autostradaen': ('autostrada',),
'autostradaer': ('autostrada',),
'autostradaene': ('autostrada',),
'autovern': ('autovern',),
'autovernet': ('autovern',),
'autovern': ('autovern',),
'autoverna': ('autovern',),
'autovernene': ('autovern',),
'av-middel': ('av-middel',),
'av-middelet': ('av-middel',),
'av-midlet': ('av-middel',),
'av-middel': ('av-middel',),
'av-midler': ('av-middel',),
'av-midla': ('av-middel',),
'av-midlene': ('av-middel',),
'av-midla': ('av-middel',),
'av-midlene': ('av-middel',),
'aval': ('aval',),
'avalen': ('aval',),
'avaler': ('aval',),
'avalene': ('aval',),
'avalveksel': ('avalveksel',),
'avalvekselen': ('avalveksel',),
'avalveksler': ('avalveksel',),
'avalvekslene': ('avalveksel',),
'avanse': ('avanse',),
'avansen': ('avanse',),
'avanser': ('avanse',),
'avansene': ('avanse',),
'avansement': ('avansement',),
'avansementet': ('avansement',),
'avansement': ('avansement',),
'avansementer': ('avansement',),
'avansement': ('avansement',),
'avansementer': ('avansement',),
'avansementa': ('avansement',),
'avansementene': ('avansement',),
'avansementsmulighet': ('avansementsmulighet',),
'avansementsmuligheten': ('avansementsmulighet',),
'avansementsmuligheta': ('avansementsmulighet',),
'avansementsmuligheter': ('avansementsmulighet',),
'avansementsmulighetene': ('avansementsmulighet',),
'avansementsregel': ('avansementsregel',),
'avansementsregelen': ('avansementsregel',),
'avansementsregler': ('avansementsregel',),
'avansementsreglene': ('avansementsregel',),
'avansementsstilling': ('avansementsstilling',),
'avansementsstillingen': ('avansementsstilling',),
'avansementsstillinga': ('avansementsstilling',),
'avansementsstillinger': ('avansementsstilling',),
'avansementsstillingene': ('avansementsstilling',),
'avansementsvilkår': ('avansementsvilkår',),
'avansementsvilkåret': ('avansementsvilkår',),
'avansementsvilkår': ('avansementsvilkår',),
'avansementsvilkåra': ('avansementsvilkår',),
'avansementsvilkårene': ('avansementsvilkår',),
'avansestopp': ('avansestopp',),
'avansestoppen': ('avansestopp',),
'avansestopper': ('avansestopp',),
'avansestoppene': ('avansestopp',),
'avansetap': ('avansetap',),
'avansetapet': ('avansetap',),
'avansetap': ('avansetap',),
'avansetapa': ('avansetap',),
'avansetapene': ('avansetap',),
'avantgarde': ('avantgarde',),
'avantgarden': ('avantgarde',),
'avantgarder': ('avantgarde',),
'avantgardene': ('avantgarde',),
'avantgardist': ('avantgardist',),
'avantgardisten': ('avantgardist',),
'avantgardister': ('avantgardist',),
'avantgardistene': ('avantgardist',),
'avart': ('avart',),
'avarten': ('avart',),
'avarta': ('avart',),
'avarter': ('avart',),
'avartene': ('avart',),
'avbenyttelse': ('avbenyttelse',),
'avbenyttelsen': ('avbenyttelse',),
'avbenyttelser': ('avbenyttelse',),
'avbenyttelsene': ('avbenyttelse',),
'avbestilling': ('avbestilling',),
'avbestillingen': ('avbestilling',),
'avbestillinga': ('avbestilling',),
'avbestillinger': ('avbestilling',),
'avbestillingene': ('avbestilling',),
'avbestillingsgebyr': ('avbestillingsgebyr',),
'avbestillingsgebyret': ('avbestillingsgebyr',),
'avbestillingsgebyr': ('avbestillingsgebyr',),
'avbestillingsgebyrer': ('avbestillingsgebyr',),
'avbestillingsgebyr': ('avbestillingsgebyr',),
'avbestillingsgebyrer': ('avbestillingsgebyr',),
'avbestillingsgebyra': ('avbestillingsgebyr',),
'avbestillingsgebyrene': ('avbestillingsgebyr',),
'avbetaling': ('avbetaling',),
'avbetalingen': ('avbetaling',),
'avbetalinga': ('avbetaling',),
'avbetalinger': ('avbetaling',),
'avbetalingene': ('avbetaling',),
'avbetalingshandel': ('avbetalingshandel',),
'avbetalingshandelen': ('avbetalingshandel',),
'avbetalingshandler': ('avbetalingshandel',),
'avbetalingshandlene': ('avbetalingshandel',),
'avbetalingskontrakt': ('avbetalingskontrakt',),
'avbetalingskontrakten': ('avbetalingskontrakt',),
'avbetalingskontrakter': ('avbetalingskontrakt',),
'avbetalingskontraktene': ('avbetalingskontrakt',),
'avbetalingssalg': ('avbetalingssalg',),
'avbetalingssalget': ('avbetalingssalg',),
'avbetalingssalg': ('avbetalingssalg',),
'avbetalingssalga': ('avbetalingssalg',),
'avbetalingssalgene': ('avbetalingssalg',),
'avbetalingssystem': ('avbetalingssystem',),
'avbetalingssystemet': ('avbetalingssystem',),
'avbetalingssystem': ('avbetalingssystem',),
'avbetalingssystemer': ('avbetalingssystem',),
'avbetalingssystem': ('avbetalingssystem',),
'avbetalingssystemer': ('avbetalingssystem',),
'avbetalingssystema': ('avbetalingssystem',),
'avbetalingssystemene': ('avbetalingssystem',),
'avbikt': ('avbikt',),
'avbikten': ('avbikt',),
'avbikter': ('avbikt',),
'avbiktene': ('avbikt',),
'avbilde': ('avbilde',),
'avbildet': ('avbilde',),
'avbilder': ('avbilde',),
'avbilda': ('avbilde',),
'avbildene': ('avbilde',),
'avbildning': ('avbildning',),
'avbildningen': ('avbildning',),
'avbildninga': ('avbildning',),
'avbildninger': ('avbildning',),
'avbildningene': ('avbildning',),
'avbiter': ('avbiter',),
'avbiteren': ('avbiter',),
'avbitere': ('avbiter',),
'avbiterne': ('avbiter',),
'avblåsning': ('avblåsning',),
'avblåsningen': ('avblåsning',),
'avblåsninga': ('avblåsning',),
'avblåsninger': ('avblåsning',),
'avblåsningene': ('avblåsning',),
'avbrekk': ('avbrekk',),
'avbrekket': ('avbrekk',),
'avbrekk': ('avbrekk',),
'avbrekka': ('avbrekk',),
'avbrekkene': ('avbrekk',),
'avbrott': ('avbrott',),
'avbrottet': ('avbrott',),
'avbrott': ('avbrott',),
'avbrotta': ('avbrott',),
'avbrottene': ('avbrott',),
'avbrottsforsikring': ('avbrottsforsikring',),
'avbrottsforsikringen': ('avbrottsforsikring',),
'avbrottsforsikringa': ('avbrottsforsikring',),
'avbrottsforsikringer': ('avbrottsforsikring',),
'avbrottsforsikringene': ('avbrottsforsikring',),
'avbrudd': ('avbrudd',),
'avbruddet': ('avbrudd',),
'avbrudd': ('avbrudd',),
'avbrudda': ('avbrudd',),
'avbruddene': ('avbrudd',),
'avbruddsforsikring': ('avbruddsforsikring',),
'avbruddsforsikringen': ('avbruddsforsikring',),
'avbruddsforsikringa': ('avbruddsforsikring',),
'avbruddsforsikringer': ('avbruddsforsikring',),
'avbruddsforsikringene': ('avbruddsforsikring',),
'avbrytelse': ('avbrytelse',),
'avbrytelsen': ('avbrytelse',),
'avbrytelser': ('avbrytelse',),
'avbrytelsene': ('avbrytelse',),
'avbud': ('avbud',),
'avbudet': ('avbud',),
'avbud': ('avbud',),
'avbuda': ('avbud',),
'avbudene': ('avbud',),
'avbygd': ('avbygd',),
'avbygden': ('avbygd',),
'avbygda': ('avbygd',),
'avbygder': ('avbygd',),
'avbygdene': ('avbygd',),
'avdal': ('avdal',),
'avdalen': ('avdal',),
'avdaler': ('avdal',),
'avdalene': ('avdal',),
'avdekking': ('avdekking',),
'avdekkingen': ('avdekking',),
'avdekkinga': ('avdekking',),
'avdekkinger': ('avdekking',),
'avdekkingene': ('avdekking',),
'avdekkingslag': ('avdekkingslag',),
'avdekkingslaget': ('avdekkingslag',),
'avdekkingslag': ('avdekkingslag',),
'avdekkingslaga': ('avdekkingslag',),
'avdekkingslagene': ('avdekkingslag',),
'avdekkingssjikt': ('avdekkingssjikt',),
'avdekkingssjiktet': ('avdekkingssjikt',),
'avdekkingssjikt': ('avdekkingssjikt',),
'avdekkingssjikta': ('avdekkingssjikt',),
'avdekkingssjiktene': ('avdekkingssjikt',),
'avdekning': ('avdekning',),
'avdekningen': ('avdekning',),
'avdekninga': ('avdekning',),
'avdekninger': ('avdekning',),
'avdekningene': ('avdekning',),
'avdekningslag': ('avdekningslag',),
'avdekningslaget': ('avdekningslag',),
'avdekningslag': ('avdekningslag',),
'avdekningslaga': ('avdekningslag',),
'avdekningslagene': ('avdekningslag',),
'avdekningssjikt': ('avdekningssjikt',),
'avdekningssjiktet': ('avdekningssjikt',),
'avdekningssjikt': ('avdekningssjikt',),
'avdekningssjikta': ('avdekningssjikt',),
'avdekningssjiktene': ('avdekningssjikt',),
'avdeling': ('avdeling',),
'avdelingen': ('avdeling',),
'avdelinga': ('avdeling',),
'avdelinger': ('avdeling',),
'avdelingene': ('avdeling',),
'avdelingskontor': ('avdelingskontor',),
'avdelingskontoret': ('avdelingskontor',),
'avdelingskontor': ('avdelingskontor',),
'avdelingskontorer': ('avdelingskontor',),
'avdelingskontor': ('avdelingskontor',),
'avdelingskontorer': ('avdelingskontor',),
'avdelingskontora': ('avdelingskontor',),
'avdelingskontorene': ('avdelingskontor',),
'avdelingsleder': ('avdelingsleder',),
'avdelingslederen': ('avdelingsleder',),
'avdelingsledere': ('avdelingsleder',),
'avdelingslederne': ('avdelingsleder',),
'avdelingslege': ('avdelingslege',),
'avdelingslegen': ('avdelingslege',),
'avdelingsleger': ('avdelingslege',),
'avdelingslegene': ('avdelingslege',),
'avdelingssjef': ('avdelingssjef',),
'avdelingssjefen': ('avdelingssjef',),
'avdelingssjefer': ('avdelingssjef',),
'avdelingssjefene': ('avdelingssjef',),
'avdelingssjukepleier': ('avdelingssjukepleier',),
'avdelingssjukepleieren': ('avdelingssjukepleier',),
'avdelingssjukepleiere': ('avdelingssjukepleier',),
'avdelingssjukepleierne': ('avdelingssjukepleier',),
'avdelingssykepleier': ('avdelingssykepleier',),
'avdelingssykepleieren': ('avdelingssykepleier',),
'avdelingssykepleiere': ('avdelingssykepleier',),
'avdelingssykepleierne': ('avdelingssykepleier',),
'avdrag': ('avdrag',),
'avdraget': ('avdrag',),
'avdrag': ('avdrag',),
'avdraga': ('avdrag',),
'avdragene': ('avdrag',),
'avdragsbeløp': ('avdragsbeløp',),
'avdragsbeløpet': ('avdragsbeløp',),
'avdragsbeløp': ('avdragsbeløp',),
'avdragsbeløpa': ('avdragsbeløp',),
'avdragsbeløpene': ('avdragsbeløp',),
'avdragsordning': ('avdragsordning',),
'avdragsordningen': ('avdragsordning',),
'avdragsordninga': ('avdragsordning',),
'avdragsordninger': ('avdragsordning',),
'avdragsordningene': ('avdragsordning',),
'avdragssum': ('avdragssum',),
'avdragssummen': ('avdragssum',),
'avdragssummer': ('avdragssum',),
'avdragssummene': ('avdragssum',),
'avdragssystem': ('avdragssystem',),
'avdragssystemet': ('avdragssystem',),
'avdragssystem': ('avdragssystem',),
'avdragssystemer': ('avdragssystem',),
'avdragssystem': ('avdragssystem',),
'avdragssystemer': ('avdragssystem',),
'avdragssystema': ('avdragssystem',),
'avdragssystemene': ('avdragssystem',),
'avdrift': ('avdrift',),
'avdriften': ('avdrift',),
'avdrifta': ('avdrift',),
'avdrifter': ('avdrift',),
'avdriftene': ('avdrift',),
'avdriftskompass': ('avdriftskompass',),
'avdriftskompassen': ('avdriftskompass',),
'avdriftskompasset': ('avdriftskompass',),
'avdriftskompasser': ('avdriftskompass',),
'avdriftskompass': ('avdriftskompass',),
'avdriftskompasser': ('avdriftskompass',),
'avdriftskompass': ('avdriftskompass',),
'avdriftskompasser': ('avdriftskompass',),
'avdriftskompassene': ('avdriftskompass',),
'avdriftskompassa': ('avdriftskompass',),
'avdriftskompassene': ('avdriftskompass',),
'avdrått': ('avdrått',),
'avdråtten': ('avdrått',),
'avdråtter': ('avdrått',),
'avdråttene': ('avdrått',),
'avdråttsevne': ('avdråttsevne',),
'avdråttsevnen': ('avdråttsevne',),
'avdråttsevna': ('avdråttsevne',),
'avdråttsevner': ('avdråttsevne',),
'avdråttsevnene': ('avdråttsevne',),
'avdråttskontroll': ('avdråttskontroll',),
'avdråttskontrollen': ('avdråttskontroll',),
'avdråttskontroller': ('avdråttskontroll',),
'avdråttskontrollene': ('avdråttskontroll',),
'avduking': ('avduking',),
'avdukingen': ('avduking',),
'avdukinga': ('avduking',),
'avdukinger': ('avduking',),
'avdukingene': ('avduking',),
'avdukingshøgtid': ('avdukingshøgtid',),
'avdukingshøgtiden': ('avdukingshøgtid',),
'avdukingshøgtida': ('avdukingshøgtid',),
'avdukingshøgtider': ('avdukingshøgtid',),
'avdukingshøgtidene': ('avdukingshøgtid',),
'avdukingshøytid': ('avdukingshøytid',),
'avdukingshøytiden': ('avdukingshøytid',),
'avdukingshøytida': ('avdukingshøytid',),
'avdukingshøytider': ('avdukingshøytid',),
'avdukingshøytidene': ('avdukingshøytid',),
'avdukingsseremoni': ('avdukingsseremoni',),
'avdukingsseremonien': ('avdukingsseremoni',),
'avdukingsseremonier': ('avdukingsseremoni',),
'avdukingsseremoniene': ('avdukingsseremoni',),
'ave': ('ave',),
'avet': ('ave',),
'aver': ('ave',),
'ava': ('ave',),
'avene': ('ave',),
'ave-maria': ('ave-maria',),
'ave-mariaet': ('ave-maria',),
'ave-maria': ('ave-maria',),
'ave-mariaer': ('ave-maria',),
'ave-mariaene': ('ave-maria',),
'avec': ('avec',),
'aveny': ('aveny',),
'avenyen': ('aveny',),
'avenyer': ('aveny',),
'avenyene': ('aveny',),
'avers': ('avers',),
'aversen': ('avers',),
'averser': ('avers',),
'aversene': ('avers',),
'aversan': ('aversan',),
'aversanet': ('aversan',),
'aversan': ('aversan',),
'aversana': ('aversan',),
'aversanene': ('aversan',),
'aversankur': ('aversankur',),
'aversankuren': ('aversankur',),
'aversankurer': ('aversankur',),
'aversankurene': ('aversankur',),
'aversjon': ('aversjon',),
'aversjonen': ('aversjon',),
'aversjoner': ('aversjon',),
'aversjonene': ('aversjon',),
'avertering': ('avertering',),
'averteringen': ('avertering',),
'averteringa': ('avertering',),
'averteringer': ('avertering',),
'averteringene': ('avertering',),
'avertissement': ('avertissement',),
'avertissementet': ('avertissement',),
'avertissement': ('avertissement',),
'avertissementer': ('avertissement',),
'avertissement': ('avertissement',),
'avertissementer': ('avertissement',),
'avertissementa': ('avertissement',),
'avertissementene': ('avertissement',),
'avfall': ('avfall',),
'avfallet': ('avfall',),
'avfall': ('avfall',),
'avfalla': ('avfall',),
'avfallene': ('avfall',),
'avfallsbøtte': ('avfallsbøtte',),
'avfallsbøtten': ('avfallsbøtte',),
'avfallsbøtta': ('avfallsbøtte',),
'avfallsbøtter': ('avfallsbøtte',),
'avfallsbøttene': ('avfallsbøtte',),
'avfallsdunk': ('avfallsdunk',),
'avfallsdunken': ('avfallsdunk',),
'avfallsdunker': ('avfallsdunk',),
'avfallsdunkene': ('avfallsdunk',),
'avfallskvern': ('avfallskvern',),
'avfallskvernen': ('avfallskvern',),
'avfallskverna': ('avfallskvern',),
'avfallskverner': ('avfallskvern',),
'avfallskvernene': ('avfallskvern',),
'avfallsplass': ('avfallsplass',),
'avfallsplassen': ('avfallsplass',),
'avfallsplasser': ('avfallsplass',),
'avfallsplassene': ('avfallsplass',),
'avfallsprodukt': ('avfallsprodukt',),
'avfallsproduktet': ('avfallsprodukt',),
'avfallsprodukt': ('avfallsprodukt',),
'avfallsprodukter': ('avfallsprodukt',),
'avfallsprodukt': ('avfallsprodukt',),
'avfallsprodukter': ('avfallsprodukt',),
'avfallsprodukta': ('avfallsprodukt',),
'avfallsproduktene': ('avfallsprodukt',),
'avfallssjakt': ('avfallssjakt',),
'avfallssjakten': ('avfallssjakt',),
'avfallssjakta': ('avfallssjakt',),
'avfallssjakter': ('avfallssjakt',),
'avfallssjaktene': ('avfallssjakt',),
'avfallsstoff': ('avfallsstoff',),
'avfallsstoffet': ('avfallsstoff',),
'avfallsstoff': ('avfallsstoff',),
'avfallsstoffer': ('avfallsstoff',),
'avfallsstoff': ('avfallsstoff',),
'avfallsstoffer': ('avfallsstoff',),
'avfallsstoffa': ('avfallsstoff',),
'avfallsstoffene': ('avfallsstoff',),
'avfolking': ('avfolking',),
'avfolkingen': ('avfolking',),
'avfolkinga': ('avfolking',),
'avfolkinger': ('avfolking',),
'avfolkingene': ('avfolking',),
'avfolkingstendens': ('avfolkingstendens',),
'avfolkingstendensen': ('avfolkingstendens',),
'avfolkingstendenser': ('avfolkingstendens',),
'avfolkingstendensene': ('avfolkingstendens',),
'avfolkning': ('avfolkning',),
'avfolkningen': ('avfolkning',),
'avfolkninga': ('avfolkning',),
'avfolkninger': ('avfolkning',),
'avfolkningene': ('avfolkning',),
'avfolkningstendens': ('avfolkningstendens',),
'avfolkningstendensen': ('avfolkningstendens',),
'avfolkningstendenser': ('avfolkningstendens',),
'avfolkningstendensene': ('avfolkningstendens',),
'avføring': ('avføring',),
'avføringen': ('avføring',),
'avføringa': ('avføring',),
'avføringer': ('avføring',),
'avføringene': ('avføring',),
'avføringsmiddel': ('avføringsmiddel',),
'avføringsmiddelet': ('avføringsmiddel',),
'avføringsmidlet': ('avføringsmiddel',),
'avføringsmiddel': ('avføringsmiddel',),
'avføringsmidler': ('avføringsmiddel',),
'avføringsmidla': ('avføringsmiddel',),
'avføringsmidlene': ('avføringsmiddel',),
'avføringsmidla': ('avføringsmiddel',),
'avføringsmidlene': ('avføringsmiddel',),
'avføringspille': ('avføringspille',),
'avføringspillen': ('avføringspille',),
'avføringspilla': ('avføringspille',),
'avføringspiller': ('avføringspille',),
'avføringspillene': ('avføringspille',),
'avføringsprøve': ('avføringsprøve',),
'avføringsprøven': ('avføringsprøve',),
'avføringsprøva': ('avføringsprøve',),
'avføringsprøver': ('avføringsprøve',),
'avføringsprøvene': ('avføringsprøve',),
'avgang': ('avgang',),
'avgangen': ('avgang',),
'avganger': ('avgang',),
'avgangene': ('avgang',),
'avgangseksamen': ('avgangseksamen',),
'avgangseksamenen': ('avgangseksamen',),
'avgangseksamener': ('avgangseksamen',),
'avgangseksamenene': ('avgangseksamen',),
'avgangsklasse': ('avgangsklasse',),
'avgangsklassen': ('avgangsklasse',),
'avgangsklassa': ('avgangsklasse',),
'avgangsklasser': ('avgangsklasse',),
'avgangsklassene': ('avgangsklasse',),
'avgangsprøve': ('avgangsprøve',),
'avgangsprøven': ('avgangsprøve',),
'avgangsprøva': ('avgangsprøve',),
'avgangsprøver': ('avgangsprøve',),
'avgangsprøvene': ('avgangsprøve',),
'avgangssignal': ('avgangssignal',),
'avgangssignalet': ('avgangssignal',),
'avgangssignal': ('avgangssignal',),
'avgangssignaler': ('avgangssignal',),
'avgangssignal': ('avgangssignal',),
'avgangssignaler': ('avgangssignal',),
'avgangssignala': ('avgangssignal',),
'avgangssignalene': ('avgangssignal',),
'avgangsstasjon': ('avgangsstasjon',),
'avgangsstasjonen': ('avgangsstasjon',),
'avgangsstasjoner': ('avgangsstasjon',),
'avgangsstasjonene': ('avgangsstasjon',),
'avgangstid': ('avgangstid',),
'avgangstiden': ('avgangstid',),
'avgangstida': ('avgangstid',),
'avgangstider': ('avgangstid',),
'avgangstidene': ('avgangstid',),
'avgangsvitnemål': ('avgangsvitnemål',),
'avgangsvitnemålet': ('avgangsvitnemål',),
'avgangsvitnemål': ('avgangsvitnemål',),
'avgangsvitnemåla': ('avgangsvitnemål',),
'avgangsvitnemålene': ('avgangsvitnemål',),
'avgangsvitnesbyrd': ('avgangsvitnesbyrd',),
'avgangsvitnesbyrdet': ('avgangsvitnesbyrd',),
'avgangsvitnesbyrd': ('avgangsvitnesbyrd',),
'avgangsvitnesbyrda': ('avgangsvitnesbyrd',),
'avgangsvitnesbyrdene': ('avgangsvitnesbyrd',),
'avgass': ('avgass',),
'avgassen': ('avgass',),
'avgasser': ('avgass',),
'avgassene': ('avgass',),
'avgift': ('avgift',),
'avgiften': ('avgift',),
'avgifta': ('avgift',),
'avgifter': ('avgift',),
'avgiftene': ('avgift',),
'avgifting': ('avgifting',),
'avgiftingen': ('avgifting',),
'avgiftinga': ('avgifting',),
'avgiftinger': ('avgifting',),
'avgiftingene': ('avgifting',),
'avgiftning': ('avgiftning',),
'avgiftningen': ('avgiftning',),
'avgiftninga': ('avgiftning',),
'avgiftninger': ('avgiftning',),
'avgiftningene': ('avgiftning',),
'avgiftsplikt': ('avgiftsplikt',),
'avgiftsplikten': ('avgiftsplikt',),
'avgiftsplikta': ('avgiftsplikt',),
'avgiftsplikter': ('avgiftsplikt',),
'avgiftspliktene': ('avgiftsplikt',),
'avgjerd': ('avgjerd',),
'avgjerden': ('avgjerd',),
'avgjerda': ('avgjerd',),
'avgjerder': ('avgjerd',),
'avgjerdene': ('avgjerd',),
'avgjersle': ('avgjersle',),
'avgjerslen': ('avgjersle',),
'avgjersla': ('avgjersle',),
'avgjersler': ('avgjersle',),
'avgjerslene': ('avgjersle',),
'avgjørelse': ('avgjørelse',),
'avgjørelsen': ('avgjørelse',),
'avgjørelser': ('avgjørelse',),
'avgjørelsene': ('avgjørelse',),
'avgjørelsesprosess': ('avgjørelsesprosess',),
'avgjørelsesprosessen': ('avgjørelsesprosess',),
'avgjørelsesprosesser': ('avgjørelsesprosess',),
'avgjørelsesprosessene': ('avgjørelsesprosess',),
'avglans': ('avglans',),
'avglansen': ('avglans',),
'avglanser': ('avglans',),
'avglansene': ('avglans',),
'avgrensing': ('avgrensing',),
'avgrensingen': ('avgrensing',),
'avgrensinga': ('avgrensing',),
'avgrensinger': ('avgrensing',),
'avgrensingene': ('avgrensing',),
'avgrensingsproblem': ('avgrensingsproblem',),
'avgrensingsproblemet': ('avgrensingsproblem',),
'avgrensingsproblem': ('avgrensingsproblem',),
'avgrensingsproblemer': ('avgrensingsproblem',),
'avgrensingsproblem': ('avgrensingsproblem',),
'avgrensingsproblemer': ('avgrensingsproblem',),
'avgrensingsproblema': ('avgrensingsproblem',),
'avgrensingsproblemene': ('avgrensingsproblem',),
'avgrensning': ('avgrensning',),
'avgrensningen': ('avgrensning',),
'avgrensninga': ('avgrensning',),
'avgrensninger': ('avgrensning',),
'avgrensningene': ('avgrensning',),
'avgrensningsproblem': ('avgrensningsproblem',),
'avgrensningsproblemet': ('avgrensningsproblem',),
'avgrensningsproblem': ('avgrensningsproblem',),
'avgrensningsproblemer': ('avgrensningsproblem',),
'avgrensningsproblem': ('avgrensningsproblem',),
'avgrensningsproblemer': ('avgrensningsproblem',),
'avgrensningsproblema': ('avgrensningsproblem',),
'avgrensningsproblemene': ('avgrensningsproblem',),
'avgrunn': ('avgrunn',),
'avgrunnen': ('avgrunn',),
'avgrunner': ('avgrunn',),
'avgrunnene': ('avgrunn',),
'avgud': ('avgud',),
'avguden': ('avgud',),
'avguder': ('avgud',),
'avgudene': ('avgud',),
'avguderi': ('avguderi',),
'avguderiet': ('avguderi',),
'avguderi': ('avguderi',),
'avguderier': ('avguderi',),
'avguderi': ('avguderi',),
'avguderier': ('avguderi',),
'avguderia': ('avguderi',),
'avguderiene': ('avguderi',),
'avgudsbilde': ('avgudsbilde',),
'avgudsbildet': ('avgudsbilde',),
'avgudsbilder': ('avgudsbilde',),
'avgudsbilda': ('avgudsbilde',),
'avgudsbildene': ('avgudsbilde',),
'avgudsdyrkelse': ('avgudsdyrkelse',),
'avgudsdyrkelsen': ('avgudsdyrkelse',),
'avgudsdyrkelser': ('avgudsdyrkelse',),
'avgudsdyrkelsene': ('avgudsdyrkelse',),
'avgudsdyrker': ('avgudsdyrker',),
'avgudsdyrkeren': ('avgudsdyrker',),
'avgudsdyrkere': ('avgudsdyrker',),
'avgudsdyrkerne': ('avgudsdyrker',),
'avgudsdyrking': ('avgudsdyrking',),
'avgudsdyrkingen': ('avgudsdyrking',),
'avgudsdyrkinga': ('avgudsdyrking',),
'avgudsdyrkinger': ('avgudsdyrking',),
'avgudsdyrkingene': ('avgudsdyrking',),
'avgudstempel': ('avgudstempel',),
'avgudstempelet': ('avgudstempel',),
'avgudstemplet': ('avgudstempel',),
'avgudstempel': ('avgudstempel',),
'avgudstempler': ('avgudstempel',),
'avgudstempla': ('avgudstempel',),
'avgudstemplene': ('avgudstempel',),
'avgudstempla': ('avgudstempel',),
'avgudstemplene': ('avgudstempel',),
'avhandling': ('avhandling',),
'avhandlingen': ('avhandling',),
'avhandlinga': ('avhandling',),
'avhandlinger': ('avhandling',),
'avhandlingene': ('avhandling',),
'avhandlingsstil': ('avhandlingsstil',),
'avhandlingsstilen': ('avhandlingsstil',),
'avhandlingsstiler': ('avhandlingsstil',),
'avhandlingsstilene': ('avhandlingsstil',),
'avhengighet': ('avhengighet',),
'avhengigheten': ('avhengighet',),
'avhengigheta': ('avhengighet',),
'avhengigheter': ('avhengighet',),
'avhengighetene': ('avhengighet',),
'avhengighetsforhold': ('avhengighetsforhold',),
'avhengighetsforholdet': ('avhengighetsforhold',),
'avhengighetsforhold': ('avhengighetsforhold',),
'avhengighetsforholda': ('avhengighetsforhold',),
'avhengighetsforholdene': ('avhengighetsforhold',),
'avhengighetsform': ('avhengighetsform',),
'avhengighetsformen': ('avhengighetsform',),
'avhengighetsforma': ('avhengighetsform',),
'avhengighetsformer': ('avhengighetsform',),
'avhengighetsformene': ('avhengighetsform',),
'avhengighetsfølelse': ('avhengighetsfølelse',),
'avhengighetsfølelsen': ('avhengighetsfølelse',),
'avhengighetsfølelser': ('avhengighetsfølelse',),
'avhengighetsfølelsene': ('avhengighetsfølelse',),
'avhol': ('avhol',),
'avholet': ('avhol',),
'avhol': ('avhol',),
'avhola': ('avhol',),
'avholene': ('avhol',),
'avhold': ('avhold',),
'avholdet': ('avhold',),
'avhold': ('avhold',),
'avholda': ('avhold',),
'avholdene': ('avhold',),
'avholdenhet': ('avholdenhet',),
'avholdenheten': ('avholdenhet',),
'avholdenheta': ('avholdenhet',),
'avholdenheter': ('avholdenhet',),
'avholdenhetene': ('avholdenhet',),
'avholdsarbeid': ('avholdsarbeid',),
'avholdsarbeidet': ('avholdsarbeid',),
'avholdsarbeid': ('avholdsarbeid',),
'avholdsarbeider': ('avholdsarbeid',),
'avholdsarbeid': ('avholdsarbeid',),
'avholdsarbeider': ('avholdsarbeid',),
'avholdsarbeida': ('avholdsarbeid',),
'avholdsarbeidene': ('avholdsarbeid',),
'avholdsbevegelse': ('avholdsbevegelse',),
'avholdsbevegelsen': ('avholdsbevegelse',),
'avholdsbevegelser': ('avholdsbevegelse',),
'avholdsbevegelsene': ('avholdsbevegelse',),
'avholdsfolk': ('avholdsfolk',),
'avholdsfolket': ('avholdsfolk',),
'avholdsfolk': ('avholdsfolk',),
'avholdsfolka': ('avholdsfolk',),
'avholdsfolkene': ('avholdsfolk',),
'avholdslosje': ('avholdslosje',),
'avholdslosjen': ('avholdslosje',),
'avholdslosjer': ('avholdslosje',),
'avholdslosjene': ('avholdslosje',),
'avholdssak': ('avholdssak',),
'avholdssaken': ('avholdssak',),
'avholdssaka': ('avholdssak',),
'avholdssaker': ('avholdssak',),
'avholdssakene': ('avholdssak',),
'avhopper': ('avhopper',),
'avhopperen': ('avhopper',),
'avhoppere': ('avhopper',),
'avhopperne': ('avhopper',),
'avhull': ('avhull',),
'avhullet': ('avhull',),
'avhull': ('avhull',),
'avhuller': ('avhull',),
'avhull': ('avhull',),
'avhuller': ('avhull',),
'avhulla': ('avhull',),
'avhullene': ('avhull',),
'avhør': ('avhør',),
'avhøret': ('avhør',),
'avhør': ('avhør',),
'avhøra': ('avhør',),
'avhørene': ('avhør',),
'aviarium': ('aviarium',),
'aviariet': ('aviarium',),
'aviarier': ('aviarium',),
'aviaria': ('aviarium',),
'aviariene': ('aviarium',),
'aviatiker': ('aviatiker',),
'aviatikeren': ('aviatiker',),
'aviatikere': ('aviatiker',),
'aviatikerne': ('aviatiker',),
'aviatikk': ('aviatikk',),
'aviatikken': ('aviatikk',),
'aviatikker': ('aviatikk',),
'aviatikkene': ('aviatikk',),
'avind': ('avind',),
'avinden': ('avind',),
'avinder': ('avind',),
'avindene': ('avind',),
'avis': ('avis',),
'avisen': ('avis',),
'avisa': ('avis',),
'aviser': ('avis',),
'avisene': ('avis',),
'avisand': ('avisand',),
'avisanden': ('avisand',),
'avisanda': ('avisand',),
'avisender': ('avisand',),
'avisendene': ('avisand',),
'avisartikkel': ('avisartikkel',),
'avisartikkelen': ('avisartikkel',),
'avisartikler': ('avisartikkel',),
'avisartiklene': ('avisartikkel',),
'avisbud': ('avisbud',),
'avisbudet': ('avisbud',),
'avisbud': ('avisbud',),
'avisbuda': ('avisbud',),
'avisbudene': ('avisbud',),
'avisdebatt': ('avisdebatt',),
'avisdebatten': ('avisdebatt',),
'avisdebatter': ('avisdebatt',),
'avisdebattene': ('avisdebatt',),
'avisdød': ('avisdød',),
'avisdøden': ('avisdød',),
'avisdøder': ('avisdød',),
'avisdødene': ('avisdød',),
'avisekspedisjon': ('avisekspedisjon',),
'avisekspedisjonen': ('avisekspedisjon',),
'avisekspedisjoner': ('avisekspedisjon',),
'avisekspedisjonene': ('avisekspedisjon',),
'avisfeide': ('avisfeide',),
'avisfeiden': ('avisfeide',),
'avisfeider': ('avisfeide',),
'avisfeidene': ('avisfeide',),
'avisingsanlegg': ('avisingsanlegg',),
'avisingsanlegget': ('avisingsanlegg',),
'avisingsanlegg': ('avisingsanlegg',),
'avisingsanlegga': ('avisingsanlegg',),
'avisingsanleggene': ('avisingsanlegg',),
'avisinnlegg': ('avisinnlegg',),
'avisinnlegget': ('avisinnlegg',),
'avisinnlegg': ('avisinnlegg',),
'avisinnlegga': ('avisinnlegg',),
'avisinnleggene': ('avisinnlegg',),
'aviskiosk': ('aviskiosk',),
'aviskiosken': ('aviskiosk',),
'aviskiosker': ('aviskiosk',),
'aviskioskene': ('aviskiosk',),
'avisklipp': ('avisklipp',),
'avisklippet': ('avisklipp',),
'avisklipp': ('avisklipp',),
'avisklippa': ('avisklipp',),
'avisklippene': ('avisklipp',),
'avisklipparkiv': ('avisklipparkiv',),
'avisklipparkivet': ('avisklipparkiv',),
'avisklipparkiv': ('avisklipparkiv',),
'avisklipparkiver': ('avisklipparkiv',),
'avisklipparkiv': ('avisklipparkiv',),
'avisklipparkiver': ('avisklipparkiv',),
'avisklipparkiva': ('avisklipparkiv',),
'avisklipparkivene': ('avisklipparkiv',),
'aviskritikk': ('aviskritikk',),
'aviskritikken': ('aviskritikk',),
'aviskritikker': ('aviskritikk',),
'aviskritikkene': ('aviskritikk',),
'avisoveksel': ('avisoveksel',),
'avisovekselen': ('avisoveksel',),
'avisoveksler': ('avisoveksel',),
'avisovekslene': ('avisoveksel',),
'avisoverskrift': ('avisoverskrift',),
'avisoverskriften': ('avisoverskrift',),
'avisoverskrifta': ('avisoverskrift',),
'avisoverskrifter': ('avisoverskrift',),
'avisoverskriftene': ('avisoverskrift',),
'avispolemikk': ('avispolemikk',),
'avispolemikken': ('avispolemikk',),
'avispolemikker': ('avispolemikk',),
'avispolemikkene': ('avispolemikk',),
'avisredaktør': ('avisredaktør',),
'avisredaktøren': ('avisredaktør',),
'avisredaktører': ('avisredaktør',),
'avisredaktørene': ('avisredaktør',),
'avisreferat': ('avisreferat',),
'avisreferatet': ('avisreferat',),
'avisreferat': ('avisreferat',),
'avisreferater': ('avisreferat',),
'avisreferat': ('avisreferat',),
'avisreferater': ('avisreferat',),
'avisreferata': ('avisreferat',),
'avisreferatene': ('avisreferat',),
'avisskribent': ('avisskribent',),
'avisskribenten': ('avisskribent',),
'avisskribenter': ('avisskribent',),
'avisskribentene': ('avisskribent',),
'avistaveksel': ('avistaveksel',),
'avistavekselen': ('avistaveksel',),
'avistaveksler': ('avistaveksel',),
'avistavekslene': ('avistaveksel',),
'avistegner': ('avistegner',),
'avistegneren': ('avistegner',),
'avistegnere': ('avistegner',),
'avistegnerne': ('avistegner',),
'avisutklipp': ('avisutklipp',),
'avisutklippet': ('avisutklipp',),
'avisutklipp': ('avisutklipp',),
'avisutklippa': ('avisutklipp',),
'avisutklippene': ('avisutklipp',),
'avkall': ('avkall',),
'avkallet': ('avkall',),
'avkall': ('avkall',),
'avkalla': ('avkall',),
'avkallene': ('avkall',),
'avkast': ('avkast',),
'avkastet': ('avkast',),
'avkast': ('avkast',),
'avkasta': ('avkast',),
'avkastene': ('avkast',),
'avkasting': ('avkasting',),
'avkastingen': ('avkasting',),
'avkastinga': ('avkasting',),
'avkastinger': ('avkasting',),
'avkastingene': ('avkasting',),
'avkastning': ('avkastning',),
'avkastningen': ('avkastning',),
'avkastninga': ('avkastning',),
'avkastninger': ('avkastning',),
'avkastningene': ('avkastning',),
'avkjøling': ('avkjøling',),
'avkjølingen': ('avkjøling',),
'avkjølinga': ('avkjøling',),
'avkjølinger': ('avkjøling',),
'avkjølingene': ('avkjøling',),
'avkjøring': ('avkjøring',),
'avkjøringen': ('avkjøring',),
'avkjøringa': ('avkjøring',),
'avkjøringer': ('avkjøring',),
'avkjøringene': ('avkjøring',),
'avkjøringsrampe': ('avkjøringsrampe',),
'avkjøringsrampen': ('avkjøringsrampe',),
'avkjøringsrampa': ('avkjøringsrampe',),
'avkjøringsramper': ('avkjøringsrampe',),
'avkjøringsrampene': ('avkjøringsrampe',),
'avkjøringsveg': ('avkjøringsveg',),
'avkjøringsvegen': ('avkjøringsveg',),
'avkjøringsveger': ('avkjøringsveg',),
'avkjøringsvegene': ('avkjøringsveg',),
'avkjøringsvei': ('avkjøringsvei',),
'avkjøringsveien': ('avkjøringsvei',),
'avkjøringsveier': ('avkjøringsvei',),
'avkjøringsveiene': ('avkjøringsvei',),
'avkjørsel': ('avkjørsel',),
'avkjørselen': ('avkjørsel',),
'avkjørsla': ('avkjørsel',),
'avkjørsler': ('avkjørsel',),
'avkjørslene': ('avkjørsel',),
'avklaring': ('avklaring',),
'avklaringen': ('avklaring',),
'avklaringa': ('avklaring',),
'avklaringer': ('avklaring',),
'avklaringene': ('avklaring',),
'avkledingsrom': ('avkledingsrom',),
'avkledingsrommet': ('avkledingsrom',),
'avkledingsrom': ('avkledingsrom',),
'avkledingsromma': ('avkledingsrom',),
'avkledingsrommene': ('avkledingsrom',),
'avkledingsscene': ('avkledingsscene',),
'avkledingsscenen': ('avkledingsscene',),
'avkledingsscener': ('avkledingsscene',),
'avkledingsscenene': ('avkledingsscene',),
'avkledningsrom': ('avkledningsrom',),
'avkledningsrommet': ('avkledningsrom',),
'avkledningsrom': ('avkledningsrom',),
'avkledningsromma': ('avkledningsrom',),
'avkledningsrommene': ('avkledningsrom',),
'avkledningsscene': ('avkledningsscene',),
'avkledningsscenen': ('avkledningsscene',),
'avkledningsscener': ('avkledningsscene',),
'avkledningsscenene': ('avkledningsscene',),
'avkleingsrom': ('avkleingsrom',),
'avkleingsrommet': ('avkleingsrom',),
'avkleingsrom': ('avkleingsrom',),
'avkleingsromma': ('avkleingsrom',),
'avkleingsrommene': ('avkleingsrom',),
'avkleingsscene': ('avkleingsscene',),
'avkleingsscenen': ('avkleingsscene',),
'avkleingsscener': ('avkleingsscene',),
'avkleingsscenene': ('avkleingsscene',),
'avkobling': ('avkobling',),
'avkoblingen': ('avkobling',),
'avkoblinga': ('avkobling',),
'avkoblinger': ('avkobling',),
'avkoblingene': ('avkobling',),
'avkok': ('avkok',),
'avkoket': ('avkok',),
'avkok': ('avkok',),
'avkoka': ('avkok',),
'avkokene': ('avkok',),
'avkom': ('avkom',),
'avkommet': ('avkom',),
'avkom': ('avkom',),
'avkomma': ('avkom',),
'avkommene': ('avkom',),
'avkomsgransking': ('avkomsgransking',),
'avkomsgranskingen': ('avkomsgransking',),
'avkomsgranskinga': ('avkomsgransking',),
'avkomsgranskinger': ('avkomsgransking',),
'avkomsgranskingene': ('avkomsgransking',),
'avkopling': ('avkopling',),
'avkoplingen': ('avkopling',),
'avkoplinga': ('avkopling',),
'avkoplinger': ('avkopling',),
'avkoplingene': ('avkopling',),
'avkorting': ('avkorting',),
'avkortingen': ('avkorting',),
'avkortinga': ('avkorting',),
'avkortinger': ('avkorting',),
'avkortingene': ('avkorting',),
'avkristning': ('avkristning',),
'avkristningen': ('avkristning',),
'avkristninga': ('avkristning',),
'avkristninger': ('avkristning',),
'avkristningene': ('avkristning',),
'avkrok': ('avkrok',),
'avkroken': ('avkrok',),
'avkroker': ('avkrok',),
'avkrokene': ('avkrok',),
'avlagring': ('avlagring',),
'avlagringen': ('avlagring',),
'avlagringa': ('avlagring',),
'avlagringer': ('avlagring',),
'avlagringene': ('avlagring',),
'avlasting': ('avlasting',),
'avlastingen': ('avlasting',),
'avlastinga': ('avlasting',),
'avlastinger': ('avlasting',),
'avlastingene': ('avlasting',),
'avlastning': ('avlastning',),
'avlastningen': ('avlastning',),
'avlastninga': ('avlastning',),
'avlastninger': ('avlastning',),
'avlastningene': ('avlastning',),
'avlat': ('avlat',),
'avlaten': ('avlat',),
'avlater': ('avlat',),
'avlatene': ('avlat',),
'avlatsbrev': ('avlatsbrev',),
'avlatsbrevet': ('avlatsbrev',),
'avlatsbrev': ('avlatsbrev',),
'avlatsbrever': ('avlatsbrev',),
'avlatsbrev': ('avlatsbrev',),
'avlatsbrever': ('avlatsbrev',),
'avlatsbreva': ('avlatsbrev',),
'avlatsbrevene': ('avlatsbrev',),
'avlatshandel': ('avlatshandel',),
'avlatshandelen': ('avlatshandel',),
'avlatshandler': ('avlatshandel',),
'avlatshandlene': ('avlatshandel',),
'avlatspenger': ('avlatspenger',),
'avlatspengene': ('avlatspenger',),
'avledning': ('avledning',),
'avledningen': ('avledning',),
'avledninga': ('avledning',),
'avledninger': ('avledning',),
'avledningene': ('avledning',),
'avledningsendelse': ('avledningsendelse',),
'avledningsendelsen': ('avledningsendelse',),
'avledningsendelser': ('avledningsendelse',),
'avledningsendelsene': ('avledningsendelse',),
'avledningsending': ('avledningsending',),
'avledningsendingen': ('avledningsending',),
'avledningsendinga': ('avledningsending',),
'avledningsendinger': ('avledningsending',),
'avledningsendingene': ('avledningsending',),
'avledningsgrøft': ('avledningsgrøft',),
'avledningsgrøften': ('avledningsgrøft',),
'avledningsgrøfta': ('avledningsgrøft',),
'avledningsgrøfter': ('avledningsgrøft',),
'avledningsgrøftene': ('avledningsgrøft',),
'avledningsmanøver': ('avledningsmanøver',),
'avledningsmanøveren': ('avledningsmanøver',),
'avledningsmanøvere': ('avledningsmanøver',),
'avledningsmanøvrer': ('avledningsmanøver',),
'avledningsmanøvre': ('avledningsmanøver',),
'avledningsmanøverne': ('avledningsmanøver',),
'avledningsmanøvrene': ('avledningsmanøver',),
'avledningsprefiks': ('avledningsprefiks',),
'avledningsprefikset': ('avledningsprefiks',),
'avledningsprefiks': ('avledningsprefiks',),
'avledningsprefikser': ('avledningsprefiks',),
'avledningsprefiks': ('avledningsprefiks',),
'avledningsprefikser': ('avledningsprefiks',),
'avledningsprefiksa': ('avledningsprefiks',),
'avledningsprefiksene': ('avledningsprefiks',),
'avledningssuffiks': ('avledningssuffiks',),
'avledningssuffikset': ('avledningssuffiks',),
'avledningssuffiks': ('avledningssuffiks',),
'avledningssuffikser': ('avledningssuffiks',),
'avledningssuffiks': ('avledningssuffiks',),
'avledningssuffikser': ('avledningssuffiks',),
'avledningssuffiksa': ('avledningssuffiks',),
'avledningssuffiksene': ('avledningssuffiks',),
'avleevne': ('avleevne',),
'avleevnen': ('avleevne',),
'avleevna': ('avleevne',),
'avleevner': ('avleevne',),
'avleevnene': ('avleevne',),
'avlegger': ('avlegger',),
'avleggeren': ('avlegger',),
'avleggere': ('avlegger',),
'avleggerne': ('avlegger',),
'avleiing': ('avleiing',),
'avleiingen': ('avleiing',),
'avleiinga': ('avleiing',),
'avleiinger': ('avleiing',),
'avleiingene': ('avleiing',),
'avleiingsendelse': ('avleiingsendelse',),
'avleiingsendelsen': ('avleiingsendelse',),
'avleiingsendelser': ('avleiingsendelse',),
'avleiingsendelsene': ('avleiingsendelse',),
'avleiingsending': ('avleiingsending',),
'avleiingsendingen': ('avleiingsending',),
'avleiingsendinga': ('avleiingsending',),
'avleiingsendinger': ('avleiingsending',),
'avleiingsendingene': ('avleiingsending',),
'avleiingsgrøft': ('avleiingsgrøft',),
'avleiingsgrøften': ('avleiingsgrøft',),
'avleiingsgrøfta': ('avleiingsgrøft',),
'avleiingsgrøfter': ('avleiingsgrøft',),
'avleiingsgrøftene': ('avleiingsgrøft',),
'avleiingsmanøver': ('avleiingsmanøver',),
'avleiingsmanøveren': ('avleiingsmanøver',),
'avleiingsmanøvere': ('avleiingsmanøver',),
'avleiingsmanøvrer': ('avleiingsmanøver',),
'avleiingsmanøvre': ('avleiingsmanøver',),
'avleiingsmanøverne': ('avleiingsmanøver',),
'avleiingsmanøvrene': ('avleiingsmanøver',),
'avleiingsprefiks': ('avleiingsprefiks',),
'avleiingsprefikset': ('avleiingsprefiks',),
'avleiingsprefiks': ('avleiingsprefiks',),
'avleiingsprefikser': ('avleiingsprefiks',),
'avleiingsprefiks': ('avleiingsprefiks',),
'avleiingsprefikser': ('avleiingsprefiks',),
'avleiingsprefiksa': ('avleiingsprefiks',),
'avleiingsprefiksene': ('avleiingsprefiks',),
'avleiingssuffiks': ('avleiingssuffiks',),
'avleiingssuffikset': ('avleiingssuffiks',),
'avleiingssuffiks': ('avleiingssuffiks',),
'avleiingssuffikser': ('avleiingssuffiks',),
'avleiingssuffiks': ('avleiingssuffiks',),
'avleiingssuffikser': ('avleiingssuffiks',),
'avleiingssuffiksa': ('avleiingssuffiks',),
'avleiingssuffiksene': ('avleiingssuffiks',),
'avleiring': ('avleiring',),
'avleiringen': ('avleiring',),
'avleiringa': ('avleiring',),
'avleiringer': ('avleiring',),
'avleiringene': ('avleiring',),
'avlelem': ('avlelem',),
'avlelemmet': ('avlelem',),
'avlelemmer': ('avlelem',),
'avlelemma': ('avlelem',),
'avlelemmene': ('avlelem',),
'avlesing': ('avlesing',),
'avlesingen': ('avlesing',),
'avlesinga': ('avlesing',),
'avlesinger': ('avlesing',),
'avlesingene': ('avlesing',),
'avlesingsfeil': ('avlesingsfeil',),
'avlesingsfeilen': ('avlesingsfeil',),
'avlesingsfeil': ('avlesingsfeil',),
'avlesingsfeila': ('avlesingsfeil',),
'avlesingsfeilene': ('avlesingsfeil',),
'avlesning': ('avlesning',),
'avlesningen': ('avlesning',),
'avlesninga': ('avlesning',),
'avlesninger': ('avlesning',),
'avlesningene': ('avlesning',),
'avlesningsfeil': ('avlesningsfeil',),
'avlesningsfeilen': ('avlesningsfeil',),
'avlesningsfeil': ('avlesningsfeil',),
'avlesningsfeila': ('avlesningsfeil',),
'avlesningsfeilene': ('avlesningsfeil',),
'avlevering': ('avlevering',),
'avleveringen': ('avlevering',),
'avleveringa': ('avlevering',),
'avleveringer': ('avlevering',),
'avleveringene': ('avlevering',),
'avling': ('avling',),
'avlingen': ('avling',),
'avlinga': ('avling',),
'avlinger': ('avling',),
'avlingene': ('avling',),
'avlingsmengde': ('avlingsmengde',),
'avlingsmengden': ('avlingsmengde',),
'avlingsmengder': ('avlingsmengde',),
'avlingsmengdene': ('avlingsmengde',),
'avlingsskade': ('avlingsskade',),
'avlingsskaden': ('avlingsskade',),
'avlingsskader': ('avlingsskade',),
'avlingsskadene': ('avlingsskade',),
'avlingssvikt': ('avlingssvikt',),
'avlingssvikten': ('avlingssvikt',),
'avlingssvikter': ('avlingssvikt',),
'avlingssviktene': ('avlingssvikt',),
'avlsbuskap': ('avlsbuskap',),
'avlsbuskapen': ('avlsbuskap',),
'avlsbuskaper': ('avlsbuskap',),
'avlsbuskapene': ('avlsbuskap',),
'avlsdyr': ('avlsdyr',),
'avlsdyret': ('avlsdyr',),
'avlsdyr': ('avlsdyr',),
'avlsdyra': ('avlsdyr',),
'avlsdyrene': ('avlsdyr',),
'avlsegg': ('avlsegg',),
'avlsegget': ('avlsegg',),
'avlsegg': ('avlsegg',),
'avlsegga': ('avlsegg',),
'avlseggene': ('avlsegg',),
'avlsgris': ('avlsgris',),
'avlsgrisen': ('avlsgris',),
'avlsgriser': ('avlsgris',),
'avlsgrisene': ('avlsgris',),
'avlshest': ('avlshest',),
'avlshesten': ('avlshest',),
'avlshester': ('avlshest',),
'avlshestene': ('avlshest',),
'avlssenter': ('avlssenter',),
'avlssenteret': ('avlssenter',),
'avlssentret': ('avlssenter',),
'avlssenter': ('avlssenter',),
'avlssentre': ('avlssenter',),
'avlssentra': ('avlssenter',),
'avlssentrene': ('avlssenter',),
'avlssentra': ('avlssenter',),
'avlssentrene': ('avlssenter',),
'avlsstamme': ('avlsstamme',),
'avlsstammen': ('avlsstamme',),
'avlsstammer': ('avlsstamme',),
'avlsstammene': ('avlsstamme',),
'avlsutvalg': ('avlsutvalg',),
'avlsutvalget': ('avlsutvalg',),
'avlsutvalg': ('avlsutvalg',),
'avlsutvalga': ('avlsutvalg',),
'avlsutvalgene': ('avlsutvalg',),
'avlsverdi': ('avlsverdi',),
'avlsverdien': ('avlsverdi',),
'avlsverdier': ('avlsverdi',),
'avlsverdiene': ('avlsverdi',),
'avlukke': ('avlukke',),
'avlukket': ('avlukke',),
'avlukker': ('avlukke',),
'avlukka': ('avlukke',),
'avlukkene': ('avlukke',),
'avlyd': ('avlyd',),
'avlyden': ('avlyd',),
'avlyder': ('avlyd',),
'avlydene': ('avlyd',),
'avlydstrinn': ('avlydstrinn',),
'avlydstrinnet': ('avlydstrinn',),
'avlydstrinn': ('avlydstrinn',),
'avlydstrinna': ('avlydstrinn',),
'avlydstrinnene': ('avlydstrinn',),
'avlysing': ('avlysing',),
'avlysingen': ('avlysing',),
'avlysinga': ('avlysing',),
'avlysinger': ('avlysing',),
'avlysingene': ('avlysing',),
'avlysning': ('avlysning',),
'avlysningen': ('avlysning',),
'avlysninga': ('avlysning',),
'avlysninger': ('avlysning',),
'avlysningene': ('avlysning',),
'avløp': ('avløp',),
'avløpet': ('avløp',),
'avløp': ('avløp',),
'avløpa': ('avløp',),
'avløpene': ('avløp',),
'avløpsgrøft': ('avløpsgrøft',),
'avløpsgrøften': ('avløpsgrøft',),
'avløpsgrøfta': ('avløpsgrøft',),
'avløpsgrøfter': ('avløpsgrøft',),
'avløpsgrøftene': ('avløpsgrøft',),
'avløpskanal': ('avløpskanal',),
'avløpskanalen': ('avløpskanal',),
'avløpskanaler': ('avløpskanal',),
'avløpskanalene': ('avløpskanal',),
'avløpsledning': ('avløpsledning',),
'avløpsledningen': ('avløpsledning',),
'avløpsledninga': ('avløpsledning',),
'avløpsledninger': ('avløpsledning',),
'avløpsledningene': ('avløpsledning',),
'avløpsrør': ('avløpsrør',),
'avløpsrøret': ('avløpsrør',),
'avløpsrør': ('avløpsrør',),
'avløpsrøra': ('avløpsrør',),
'avløpsrørene': ('avløpsrør',),
'avløpsventil': ('avløpsventil',),
'avløpsventilen': ('avløpsventil',),
'avløpsventiler': ('avløpsventil',),
'avløpsventilene': ('avløpsventil',),
'avløser': ('avløser',),
'avløseren': ('avløser',),
'avløsere': ('avløser',),
'avløserne': ('avløser',),
'avløserord': ('avløserord',),
'avløserordet': ('avløserord',),
'avløserord': ('avløserord',),
'avløserorda': ('avløserord',),
'avløserordene': ('avløserord',),
'avløsing': ('avløsing',),
'avløsingen': ('avløsing',),
'avløsinga': ('avløsing',),
'avløsinger': ('avløsing',),
'avløsingene': ('avløsing',),
'avløsingsfører': ('avløsingsfører',),
'avløsingsføreren': ('avløsingsfører',),
'avløsingsførere': ('avløsingsfører',),
'avløsingsførerne': ('avløsingsfører',),
'avløsingsmannskap': ('avløsingsmannskap',),
'avløsingsmannskapet': ('avløsingsmannskap',),
'avløsingsmannskap': ('avløsingsmannskap',),
'avløsingsmannskaper': ('avløsingsmannskap',),
'avløsingsmannskap': ('avløsingsmannskap',),
'avløsingsmannskaper': ('avløsingsmannskap',),
'avløsingsmannskapa': ('avløsingsmannskap',),
'avløsingsmannskapene': ('avløsingsmannskap',),
'avløsning': ('avløsning',),
'avløsningen': ('avløsning',),
'avløsninga': ('avløsning',),
'avløsninger': ('avløsning',),
'avløsningene': ('avløsning',),
'avløsningsfører': ('avløsningsfører',),
'avløsningsføreren': ('avløsningsfører',),
'avløsningsførere': ('avløsningsfører',),
'avløsningsførerne': ('avløsningsfører',),
'avløsningsmannskap': ('avløsningsmannskap',),
'avløsningsmannskapet': ('avløsningsmannskap',),
'avløsningsmannskap': ('avløsningsmannskap',),
'avløsningsmannskaper': ('avløsningsmannskap',),
'avløsningsmannskap': ('avløsningsmannskap',),
'avløsningsmannskaper': ('avløsningsmannskap',),
'avløsningsmannskapa': ('avløsningsmannskap',),
'avløsningsmannskapene': ('avløsningsmannskap',),
'avløyser': ('avløyser',),
'avløyseren': ('avløyser',),
'avløysere': ('avløyser',),
'avløyserne': ('avløyser',),
'avløyserord': ('avløyserord',),
'avløyserordet': ('avløyserord',),
'avløyserord': ('avløyserord',),
'avløyserorda': ('avløyserord',),
'avløyserordene': ('avløyserord',),
'avløysing': ('avløysing',),
'avløysingen': ('avløysing',),
'avløysinga': ('avløysing',),
'avløysinger': ('avløysing',),
'avløysingene': ('avløysing',),
'avløysingsfører': ('avløysingsfører',),
'avløysingsføreren': ('avløysingsfører',),
'avløysingsførere': ('avløysingsfører',),
'avløysingsførerne': ('avløysingsfører',),
'avløysingsmannskap': ('avløysingsmannskap',),
'avløysingsmannskapet': ('avløysingsmannskap',),
'avløysingsmannskap': ('avløysingsmannskap',),
'avløysingsmannskaper': ('avløysingsmannskap',),
'avløysingsmannskap': ('avløysingsmannskap',),
'avløysingsmannskaper': ('avløysingsmannskap',),
'avløysingsmannskapa': ('avløysingsmannskap',),
'avløysingsmannskapene': ('avløysingsmannskap',),
'avmagring': ('avmagring',),
'avmagringen': ('avmagring',),
'avmagringa': ('avmagring',),
'avmagringer': ('avmagring',),
'avmagringene': ('avmagring',),
'avmagringskur': ('avmagringskur',),
'avmagringskuren': ('avmagringskur',),
'avmagringskurer': ('avmagringskur',),
'avmagringskurene': ('avmagringskur',),
'avmagringsmiddel': ('avmagringsmiddel',),
'avmagringsmiddelet': ('avmagringsmiddel',),
'avmagringsmidlet': ('avmagringsmiddel',),
'avmagringsmiddel': ('avmagringsmiddel',),
'avmagringsmidler': ('avmagringsmiddel',),
'avmagringsmidla': ('avmagringsmiddel',),
'avmagringsmidlene': ('avmagringsmiddel',),
'avmagringsmidla': ('avmagringsmiddel',),
'avmagringsmidlene': ('avmagringsmiddel',),
'avmakt': ('avmakt',),
'avmakten': ('avmakt',),
'avmakta': ('avmakt',),
'avmakter': ('avmakt',),
'avmaktene': ('avmakt',),
'avmaktsfølelse': ('avmaktsfølelse',),
'avmaktsfølelsen': ('avmaktsfølelse',),
'avmaktsfølelser': ('avmaktsfølelse',),
'avmaktsfølelsene': ('avmaktsfølelse',),
'avmaktskjensle': ('avmaktskjensle',),
'avmaktskjenslen': ('avmaktskjensle',),
'avmaktskjensla': ('avmaktskjensle',),
'avmaktskjensler': ('avmaktskjensle',),
'avmaktskjenslene': ('avmaktskjensle',),
'avmarsj': ('avmarsj',),
'avmarsjen': ('avmarsj',),
'avmarsjer': ('avmarsj',),
'avmarsjene': ('avmarsj',),
'avmytologisering': ('avmytologisering',),
'avmytologiseringen': ('avmytologisering',),
'avmytologiseringa': ('avmytologisering',),
'avmytologiseringer': ('avmytologisering',),
'avmytologiseringene': ('avmytologisering',),
'avokado': ('avokado',),
'avokadoen': ('avokado',),
'avokadoer': ('avokado',),
'avokadoene': ('avokado',),
'avokadofrukt': ('avokadofrukt',),
'avokadofrukten': ('avokadofrukt',),
'avokadofrukta': ('avokadofrukt',),
'avokadofrukter': ('avokadofrukt',),
'avokadofruktene': ('avokadofrukt',),
'avokadopære': ('avokadopære',),
'avokadopæren': ('avokadopære',),
'avokadopæra': ('avokadopære',),
'avokadopærer': ('avokadopære',),
'avokadopærene': ('avokadopære',),
'avokadotre': ('avokadotre',),
'avokadotreet': ('avokadotre',),
'avokadotre': ('avokadotre',),
'avokadotrær': ('avokadotre',),
'avokadotrea': ('avokadotre',),
'avokadotrærne': ('avokadotre',),
'avregning': ('avregning',),
'avregningen': ('avregning',),
'avregninga': ('avregning',),
'avregninger': ('avregning',),
'avregningene': ('avregning',),
'avregningskontor': ('avregningskontor',),
'avregningskontoret': ('avregningskontor',),
'avregningskontor': ('avregningskontor',),
'avregningskontorer': ('avregningskontor',),
'avregningskontor': ('avregningskontor',),
'avregningskontorer': ('avregningskontor',),
'avregningskontora': ('avregningskontor',),
'avregningskontorene': ('avregningskontor',),
'avregningsordning': ('avregningsordning',),
'avregningsordningen': ('avregningsordning',),
'avregningsordninga': ('avregningsordning',),
'avregningsordninger': ('avregningsordning',),
'avregningsordningene': ('avregningsordning',),
'avreise': ('avreise',),
'avreisen': ('avreise',),
'avreisa': ('avreise',),
'avreiser': ('avreise',),
'avreisene': ('avreise',),
'avreisedato': ('avreisedato',),
'avreisedatoen': ('avreisedato',),
'avreisedatoer': ('avreisedato',),
'avreisedatoene': ('avreisedato',),
'avrettelse': ('avrettelse',),
'avrettelsen': ('avrettelse',),
'avrettelser': ('avrettelse',),
'avrettelsene': ('avrettelse',),
'avretterhøvel': ('avretterhøvel',),
'avretterhøvelen': ('avretterhøvel',),
'avretterhøvler': ('avretterhøvel',),
'avretterhøvlene': ('avretterhøvel',),
'avrettermasse': ('avrettermasse',),
'avrettermassen': ('avrettermasse',),
'avrettermasser': ('avrettermasse',),
'avrettermassene': ('avrettermasse',),
'avretting': ('avretting',),
'avrettingen': ('avretting',),
'avrettinga': ('avretting',),
'avrettinger': ('avretting',),
'avrettingene': ('avretting',),
'avriss': ('avriss',),
'avrisset': ('avriss',),
'avriss': ('avriss',),
'avrissa': ('avriss',),
'avrissene': ('avriss',),
'avriving': ('avriving',),
'avrivingen': ('avriving',),
'avrivinga': ('avriving',),
'avrivinger': ('avriving',),
'avrivingene': ('avriving',),
'avrivingsblokk': ('avrivingsblokk',),
'avrivingsblokken': ('avrivingsblokk',),
'avrivingsblokka': ('avrivingsblokk',),
'avrivingsblokker': ('avrivingsblokk',),
'avrivingsblokkene': ('avrivingsblokk',),
'avrivingskalender': ('avrivingskalender',),
'avrivingskalenderen': ('avrivingskalender',),
'avrivingskalendere': ('avrivingskalender',),
'avrivingskalendrer': ('avrivingskalender',),
'avrivingskalendre': ('avrivingskalender',),
'avrivingskalenderne': ('avrivingskalender',),
'avrivingskalendrene': ('avrivingskalender',),
'avrivning': ('avrivning',),
'avrivningen': ('avrivning',),
'avrivninga': ('avrivning',),
'avrivninger': ('avrivning',),
'avrivningene': ('avrivning',),
'avrivningsblokk': ('avrivningsblokk',),
'avrivningsblokken': ('avrivningsblokk',),
'avrivningsblokka': ('avrivningsblokk',),
'avrivningsblokker': ('avrivningsblokk',),
'avrivningsblokkene': ('avrivningsblokk',),
'avrivningskalender': ('avrivningskalender',),
'avrivningskalenderen': ('avrivningskalender',),
'avrivningskalendere': ('avrivningskalender',),
'avrivningskalendrer': ('avrivningskalender',),
'avrivningskalendre': ('avrivningskalender',),
'avrivningskalenderne': ('avrivningskalender',),
'avrivningskalendrene': ('avrivningskalender',),
'avrusing': ('avrusing',),
'avrusingen': ('avrusing',),
'avrusinga': ('avrusing',),
'avrusinger': ('avrusing',),
'avrusingene': ('avrusing',),
'avrusingsstasjon': ('avrusingsstasjon',),
'avrusingsstasjonen': ('avrusingsstasjon',),
'avrusingsstasjoner': ('avrusingsstasjon',),
'avrusingsstasjonene': ('avrusingsstasjon',),
'avrusning': ('avrusning',),
'avrusningen': ('avrusning',),
'avrusninga': ('avrusning',),
'avrusninger': ('avrusning',),
'avrusningene': ('avrusning',),
'avrusningsstasjon': ('avrusningsstasjon',),
'avrusningsstasjonen': ('avrusningsstasjon',),
'avrusningsstasjoner': ('avrusningsstasjon',),
'avrusningsstasjonene': ('avrusningsstasjon',),
'avrusting': ('avrusting',),
'avrustingen': ('avrusting',),
'avrustinga': ('avrusting',),
'avrustinger': ('avrusting',),
'avrustingene': ('avrusting',),
'avrustingsavtale': ('avrustingsavtale',),
'avrustingsavtalen': ('avrustingsavtale',),
'avrustingsavtaler': ('avrustingsavtale',),
'avrustingsavtalene': ('avrustingsavtale',),
'avrustingsforslag': ('avrustingsforslag',),
'avrustingsforslaget': ('avrustingsforslag',),
'avrustingsforslag': ('avrustingsforslag',),
'avrustingsforslaga': ('avrustingsforslag',),
'avrustingsforslagene': ('avrustingsforslag',),
'avrustingspolitikk': ('avrustingspolitikk',),
'avrustingspolitikken': ('avrustingspolitikk',),
'avrustingspolitikker': ('avrustingspolitikk',),
'avrustingspolitikkene': ('avrustingspolitikk',),
'avrustning': ('avrustning',),
'avrustningen': ('avrustning',),
'avrustninga': ('avrustning',),
'avrustninger': ('avrustning',),
'avrustningene': ('avrustning',),
'avrustningsavtale': ('avrustningsavtale',),
'avrustningsavtalen': ('avrustningsavtale',),
'avrustningsavtaler': ('avrustningsavtale',),
'avrustningsavtalene': ('avrustningsavtale',),
'avrustningsforslag': ('avrustningsforslag',),
'avrustningsforslaget': ('avrustningsforslag',),
'avrustningsforslag': ('avrustningsforslag',),
'avrustningsforslaga': ('avrustningsforslag',),
'avrustningsforslagene': ('avrustningsforslag',),
'avrustningspolitikk': ('avrustningspolitikk',),
'avrustningspolitikken': ('avrustningspolitikk',),
'avrustningspolitikker': ('avrustningspolitikk',),
'avrustningspolitikkene': ('avrustningspolitikk',),
'avrøysting': ('avrøysting',),
'avrøystingen': ('avrøysting',),
'avrøystinga': ('avrøysting',),
'avrøystinger': ('avrøysting',),
'avrøystingene': ('avrøysting',),
'avsats': ('avsats',),
'avsatsen': ('avsats',),
'avsatser': ('avsats',),
'avsatsene': ('avsats',),
'avsavn': ('avsavn',),
'avsavnet': ('avsavn',),
'avsavn': ('avsavn',),
'avsavna': ('avsavn',),
'avsavnene': ('avsavn',),
'avsavnsgodtgjørelse': ('avsavnsgodtgjørelse',),
'avsavnsgodtgjørelsen': ('avsavnsgodtgjørelse',),
'avsavnsgodtgjørelser': ('avsavnsgodtgjørelse',),
'avsavnsgodtgjørelsene': ('avsavnsgodtgjørelse',),
'avsavnsgodtgjøring': ('avsavnsgodtgjøring',),
'avsavnsgodtgjøringen': ('avsavnsgodtgjøring',),
'avsavnsgodtgjøringa': ('avsavnsgodtgjøring',),
'avsavnsgodtgjøringer': ('avsavnsgodtgjøring',),
'avsavnsgodtgjøringene': ('avsavnsgodtgjøring',),
'avsender': ('avsender',),
'avsenderen': ('avsender',),
'avsendere': ('avsender',),
'avsenderne': ('avsender',),
'avsenderadresse': ('avsenderadresse',),
'avsenderadressen': ('avsenderadresse',),
'avsenderadressa': ('avsenderadresse',),
'avsenderadresser': ('avsenderadresse',),
'avsenderadressene': ('avsenderadresse',),
'avsetning': ('avsetning',),
'avsetningen': ('avsetning',),
'avsetninga': ('avsetning',),
'avsetninger': ('avsetning',),
'avsetningene': ('avsetning',),
'avsetningskonto': ('avsetningskonto',),
'avsetningskontoen': ('avsetningskonto',),
'avsetningskontoer': ('avsetningskonto',),
'avsetningskonti': ('avsetningskonto',),
'avsetningskontoene': ('avsetningskonto',),
'avsetningskontiene': ('avsetningskonto',),
'avsetningsmarked': ('avsetningsmarked',),
'avsetningsmarkedet': ('avsetningsmarked',),
'avsetningsmarked': ('avsetningsmarked',),
'avsetningsmarkeder': ('avsetningsmarked',),
'avsetningsmarked': ('avsetningsmarked',),
'avsetningsmarkeder': ('avsetningsmarked',),
'avsetningsmarkeda': ('avsetningsmarked',),
'avsetningsmarkedene': ('avsetningsmarked',),
'avsetningsmulighet': ('avsetningsmulighet',),
'avsetningsmuligheten': ('avsetningsmulighet',),
'avsetningsmuligheta': ('avsetningsmulighet',),
'avsetningsmuligheter': ('avsetningsmulighet',),
'avsetningsmulighetene': ('avsetningsmulighet',),
'avsetningsområde': ('avsetningsområde',),
'avsetningsområdet': ('avsetningsområde',),
'avsetningsområder': ('avsetningsområde',),
'avsetningsområda': ('avsetningsområde',),
'avsetningsområdene': ('avsetningsområde',),
'avsetningsvanske': ('avsetningsvanske',),
'avsetningsvansken': ('avsetningsvanske',),
'avsetningsvansker': ('avsetningsvanske',),
'avsetningsvanskene': ('avsetningsvanske',),
'avsetningsvanskelighet': ('avsetningsvanskelighet',),
'avsetningsvanskeligheten': ('avsetningsvanskelighet',),
'avsetningsvanskeligheta': ('avsetningsvanskelighet',),
'avsetningsvanskeligheter': ('avsetningsvanskelighet',),
'avsetningsvanskelighetene': ('avsetningsvanskelighet',),
'avsettelse': ('avsettelse',),
'avsettelsen': ('avsettelse',),
'avsettelser': ('avsettelse',),
'avsettelsene': ('avsettelse',),
'avsig': ('avsig',),
'avsiget': ('avsig',),
'avsig': ('avsig',),
'avsiga': ('avsig',),
'avsigene': ('avsig',),
'avsinn': ('avsinn',),
'avsinnet': ('avsinn',),
'avsinn': ('avsinn',),
'avsinna': ('avsinn',),
'avsinnene': ('avsinn',),
'avskaffelse': ('avskaffelse',),
'avskaffelsen': ('avskaffelse',),
'avskaffelser': ('avskaffelse',),
'avskaffelsene': ('avskaffelse',),
'avskalling': ('avskalling',),
'avskallingen': ('avskalling',),
'avskallinga': ('avskalling',),
'avskallinger': ('avskalling',),
'avskallingene': ('avskalling',),
'avskiper': ('avskiper',),
'avskiperen': ('avskiper',),
'avskipere': ('avskiper',),
'avskiperne': ('avskiper',),
'avskiping': ('avskiping',),
'avskipingen': ('avskiping',),
'avskipinga': ('avskiping',),
'avskipinger': ('avskiping',),
'avskipingene': ('avskiping',),
'avskipingshavn': ('avskipingshavn',),
'avskipingshavnen': ('avskipingshavn',),
'avskipingshavna': ('avskipingshavn',),
'avskipingshavner': ('avskipingshavn',),
'avskipingshavnene': ('avskipingshavn',),
'avskipning': ('avskipning',),
'avskipningen': ('avskipning',),
'avskipninga': ('avskipning',),
'avskipninger': ('avskipning',),
'avskipningene': ('avskipning',),
'avskipningshavn': ('avskipningshavn',),
'avskipningshavnen': ('avskipningshavn',),
'avskipningshavna': ('avskipningshavn',),
'avskipningshavner': ('avskipningshavn',),
'avskipningshavnene': ('avskipningshavn',),
'avskjed': ('avskjed',),
'avskjeden': ('avskjed',),
'avskjeder': ('avskjed',),
'avskjedene': ('avskjed',),
'avskjedigelse': ('avskjedigelse',),
'avskjedigelsen': ('avskjedigelse',),
'avskjedigelser': ('avskjedigelse',),
'avskjedigelsene': ('avskjedigelse',),
'avskjedsfest': ('avskjedsfest',),
'avskjedsfesten': ('avskjedsfest',),
'avskjedsfester': ('avskjedsfest',),
'avskjedsfestene': ('avskjedsfest',),
'avskjedsstund': ('avskjedsstund',),
'avskjedsstunden': ('avskjedsstund',),
'avskjedsstunda': ('avskjedsstund',),
'avskjedsstunder': ('avskjedsstund',),
'avskjedsstundene': ('avskjedsstund',),
'avskjedssøknad': ('avskjedssøknad',),
'avskjedssøknaden': ('avskjedssøknad',),
'avskjedssøknader': ('avskjedssøknad',),
'avskjedssøknadene': ('avskjedssøknad',),
'avskjedsvisitt': ('avskjedsvisitt',),
'avskjedsvisitten': ('avskjedsvisitt',),
'avskjedsvisitter': ('avskjedsvisitt',),
'avskjedsvisittene': ('avskjedsvisitt',),
'avskjær': ('avskjær',),
'avskjæret': ('avskjær',),
'avskjær': ('avskjær',),
'avskjæra': ('avskjær',),
'avskjærene': ('avskjær',),
'avskjæring': ('avskjæring',),
'avskjæringen': ('avskjæring',),
'avskjæringer': ('avskjæring',),
'avskjæringene': ('avskjæring',),
'avskjæring': ('avskjæring',),
'avskjæringen': ('avskjæring',),
'avskjæringa': ('avskjæring',),
'avskjæringer': ('avskjæring',),
'avskjæringene': ('avskjæring',),
'avskjæringsjager': ('avskjæringsjager',),
'avskjæringsjageren': ('avskjæringsjager',),
'avskjæringsjagere': ('avskjæringsjager',),
'avskjæringsjagerne': ('avskjæringsjager',),
'avskoging': ('avskoging',),
'avskogingen': ('avskoging',),
'avskoginga': ('avskoging',),
'avskoginger': ('avskoging',),
'avskogingene': ('avskoging',),
'avskrekk': ('avskrekk',),
'avskrekken': ('avskrekk',),
'avskrekker': ('avskrekk',),
'avskrekkene': ('avskrekk',),
'avskrekkingsvåpen': ('avskrekkingsvåpen',),
'avskrekkingsvåpenet': ('avskrekkingsvåpen',),
'avskrekkingsvåpen': ('avskrekkingsvåpen',),
'avskrekkingsvåpna': ('avskrekkingsvåpen',),
'avskrekkingsvåpnene': ('avskrekkingsvåpen',),
'avskrift': ('avskrift',),
'avskriften': ('avskrift',),
'avskrifta': ('avskrift',),
'avskrifter': ('avskrift',),
'avskriftene': ('avskrift',),
'avskriver': ('avskriver',),
'avskriveren': ('avskriver',),
'avskrivere': ('avskriver',),
'avskriverne': ('avskriver',),
'avskriverarbeid': ('avskriverarbeid',),
'avskriverarbeidet': ('avskriverarbeid',),
'avskriverarbeid': ('avskriverarbeid',),
'avskriverarbeider': ('avskriverarbeid',),
'avskriverarbeid': ('avskriverarbeid',),
'avskriverarbeider': ('avskriverarbeid',),
'avskriverarbeida': ('avskriverarbeid',),
'avskriverarbeidene': ('avskriverarbeid',),
'avskriverfeil': ('avskriverfeil',),
'avskriverfeilen': ('avskriverfeil',),
'avskriverfeil': ('avskriverfeil',),
'avskriverfeila': ('avskriverfeil',),
'avskriverfeilene': ('avskriverfeil',),
'avskriving': ('avskriving',),
'avskrivingen': ('avskriving',),
'avskrivinga': ('avskriving',),
'avskrivinger': ('avskriving',),
'avskrivingene': ('avskriving',),
'avskrivingsbidrag': ('avskrivingsbidrag',),
'avskrivingsbidraget': ('avskrivingsbidrag',),
'avskrivingsbidrag': ('avskrivingsbidrag',),
'avskrivingsbidraga': ('avskrivingsbidrag',),
'avskrivingsbidragene': ('avskrivingsbidrag',),
'avskrivingsbyrå': ('avskrivingsbyrå',),
'avskrivingsbyrået': ('avskrivingsbyrå',),
'avskrivingsbyrå': ('avskrivingsbyrå',),
'avskrivingsbyråer': ('avskrivingsbyrå',),
'avskrivingsbyrå': ('avskrivingsbyrå',),
'avskrivingsbyråer': ('avskrivingsbyrå',),
'avskrivingsbyråa': ('avskrivingsbyrå',),
'avskrivingsbyråene': ('avskrivingsbyrå',),
'avskrivingskonto': ('avskrivingskonto',),
'avskrivingskontoen': ('avskrivingskonto',),
'avskrivingskontoer': ('avskrivingskonto',),
'avskrivingskonti': ('avskrivingskonto',),
'avskrivingskontoene': ('avskrivingskonto',),
'avskrivingskontiene': ('avskrivingskonto',),
'avskrivingskontor': ('avskrivingskontor',),
'avskrivingskontoret': ('avskrivingskontor',),
'avskrivingskontor': ('avskrivingskontor',),
'avskrivingskontorer': ('avskrivingskontor',),
'avskrivingskontor': ('avskrivingskontor',),
'avskrivingskontorer': ('avskrivingskontor',),
'avskrivingskontora': ('avskrivingskontor',),
'avskrivingskontorene': ('avskrivingskontor',),
'avskrivning': ('avskrivning',),
'avskrivningen': ('avskrivning',),
'avskrivninga': ('avskrivning',),
'avskrivninger': ('avskrivning',),
'avskrivningene': ('avskrivning',),
'avskrivningsbidrag': ('avskrivningsbidrag',),
'avskrivningsbidraget': ('avskrivningsbidrag',),
'avskrivningsbidrag': ('avskrivningsbidrag',),
'avskrivningsbidraga': ('avskrivningsbidrag',),
'avskrivningsbidragene': ('avskrivningsbidrag',),
'avskrivningsbyrå': ('avskrivningsbyrå',),
'avskrivningsbyrået': ('avskrivningsbyrå',),
'avskrivningsbyrå': ('avskrivningsbyrå',),
'avskrivningsbyråer': ('avskrivningsbyrå',),
'avskrivningsbyrå': ('avskrivningsbyrå',),
'avskrivningsbyråer': ('avskrivningsbyrå',),
'avskrivningsbyråa': ('avskrivningsbyrå',),
'avskrivningsbyråene': ('avskrivningsbyrå',),
'avskrivningskonto': ('avskrivningskonto',),
'avskrivningskontoen': ('avskrivningskonto',),
'avskrivningskontoer': ('avskrivningskonto',),
'avskrivningskonti': ('avskrivningskonto',),
'avskrivningskontoene': ('avskrivningskonto',),
'avskrivningskontiene': ('avskrivningskonto',),
'avskrivningskontor': ('avskrivningskontor',),
'avskrivningskontoret': ('avskrivningskontor',),
'avskrivningskontor': ('avskrivningskontor',),
'avskrivningskontorer': ('avskrivningskontor',),
'avskrivningskontor': ('avskrivningskontor',),
'avskrivningskontorer': ('avskrivningskontor',),
'avskrivningskontora': ('avskrivningskontor',),
'avskrivningskontorene': ('avskrivningskontor',),
'avskum': ('avskum',),
'avskummet': ('avskum',),
'avskum': ('avskum',),
'avskumma': ('avskum',),
'avskummene': ('avskum',),
'avsky': ('avsky',),
'avskyen': ('avsky',),
'avskyer': ('avsky',),
'avskyene': ('avsky',),
'avskygning': ('avskygning',),
'avskygningen': ('avskygning',),
'avskygninga': ('avskygning',),
'avskygninger': ('avskygning',),
'avskygningene': ('avskygning',),
'avskyresolusjon': ('avskyresolusjon',),
'avskyresolusjonen': ('avskyresolusjon',),
'avskyresolusjoner': ('avskyresolusjon',),
'avskyresolusjonene': ('avskyresolusjon',),
'avslag': ('avslag',),
'avslaget': ('avslag',),
'avslag': ('avslag',),
'avslaga': ('avslag',),
'avslagene': ('avslag',),
'avslapning': ('avslapning',),
'avslapningen': ('avslapning',),
'avslapninga': ('avslapning',),
'avslapninger': ('avslapning',),
'avslapningene': ('avslapning',),
'avslapningsgymnastikk': ('avslapningsgymnastikk',),
'avslapningsgymnastikken': ('avslapningsgymnastikk',),
'avslapningsgymnastikker': ('avslapningsgymnastikk',),
'avslapningsgymnastikkene': ('avslapningsgymnastikk',),
'avslapningsterapi': ('avslapningsterapi',),
'avslapningsterapien': ('avslapningsterapi',),
'avslapningsterapier': ('avslapningsterapi',),
'avslapningsterapiene': ('avslapningsterapi',),
'avslapningsøvelse': ('avslapningsøvelse',),
'avslapningsøvelsen': ('avslapningsøvelse',),
'avslapningsøvelser': ('avslapningsøvelse',),
'avslapningsøvelsene': ('avslapningsøvelse',),
'avslapningsøving': ('avslapningsøving',),
'avslapningsøvingen': ('avslapningsøving',),
'avslapningsøvinga': ('avslapningsøving',),
'avslapningsøvinger': ('avslapningsøving',),
'avslapningsøvingene': ('avslapningsøving',),
'avslapping': ('avslapping',),
'avslappingen': ('avslapping',),
'avslappinga': ('avslapping',),
'avslappinger': ('avslapping',),
'avslappingene': ('avslapping',),
'avslappingsgymnastikk': ('avslappingsgymnastikk',),
'avslappingsgymnastikken': ('avslappingsgymnastikk',),
'avslappingsgymnastikker': ('avslappingsgymnastikk',),
'avslappingsgymnastikkene': ('avslappingsgymnastikk',),
'avslappingsterapi': ('avslappingsterapi',),
'avslappingsterapien': ('avslappingsterapi',),
'avslappingsterapier': ('avslappingsterapi',),
'avslappingsterapiene': ('avslappingsterapi',),
'avslappingsøvelse': ('avslappingsøvelse',),
'avslappingsøvelsen': ('avslappingsøvelse',),
'avslappingsøvelser': ('avslappingsøvelse',),
'avslappingsøvelsene': ('avslappingsøvelse',),
'avslappingsøving': ('avslappingsøving',),
'avslappingsøvingen': ('avslappingsøving',),
'avslappingsøvinga': ('avslappingsøving',),
'avslappingsøvinger': ('avslappingsøving',),
'avslappingsøvingene': ('avslappingsøving',),
'avslutning': ('avslutning',),
'avslutningen': ('avslutning',),
'avslutninga': ('avslutning',),
'avslutninger': ('avslutning',),
'avslutningene': ('avslutning',),
'avslutningsfest': ('avslutningsfest',),
'avslutningsfesten': ('avslutningsfest',),
'avslutningsfester': ('avslutningsfest',),
'avslutningsfestene': ('avslutningsfest',),
'avslutningstale': ('avslutningstale',),
'avslutningstalen': ('avslutningstale',),
'avslutningstaler': ('avslutningstale',),
'avslutningstalene': ('avslutningstale',),
'avsløring': ('avsløring',),
'avsløringen': ('avsløring',),
'avsløringa': ('avsløring',),
'avsløringer': ('avsløring',),
'avsløringene': ('avsløring',),
'avsmak': ('avsmak',),
'avsmaken': ('avsmak',),
'avsmaker': ('avsmak',),
'avsmakene': ('avsmak',),
'avsnitt': ('avsnitt',),
'avsnittet': ('avsnitt',),
'avsnitt': ('avsnitt',),
'avsnitta': ('avsnitt',),
'avsnittene': ('avsnitt',),
'avsnittsmarkering': ('avsnittsmarkering',),
'avsnittsmarkeringen': ('avsnittsmarkering',),
'avsnittsmarkeringa': ('avsnittsmarkering',),
'avsnittsmarkeringer': ('avsnittsmarkering',),
'avsnittsmarkeringene': ('avsnittsmarkering',),
'avsnittssjef': ('avsnittssjef',),
'avsnittssjefen': ('avsnittssjef',),
'avsnittssjefer': ('avsnittssjef',),
'avsnittssjefene': ('avsnittssjef',),
'avspark': ('avspark',),
'avsparket': ('avspark',),
'avspark': ('avspark',),
'avsparka': ('avspark',),
'avsparkene': ('avspark',),
'avspelling': ('avspelling',),
'avspellingen': ('avspelling',),
'avspellinga': ('avspelling',),
'avspellinger': ('avspelling',),
'avspellingene': ('avspelling',),
'avspellingsrom': ('avspellingsrom',),
'avspellingsrommet': ('avspellingsrom',),
'avspellingsrom': ('avspellingsrom',),
'avspellingsromma': ('avspellingsrom',),
'avspellingsrommene': ('avspellingsrom',),
'avspenning': ('avspenning',),
'avspenningen': ('avspenning',),
'avspenninga': ('avspenning',),
'avspenninger': ('avspenning',),
'avspenningene': ('avspenning',),
'avspenningsframstøt': ('avspenningsframstøt',),
'avspenningsframstøtet': ('avspenningsframstøt',),
'avspenningsframstøt': ('avspenningsframstøt',),
'avspenningsframstøta': ('avspenningsframstøt',),
'avspenningsframstøtene': ('avspenningsframstøt',),
'avspenningsframstøyt': ('avspenningsframstøyt',),
'avspenningsframstøyten': ('avspenningsframstøyt',),
'avspenningsframstøyter': ('avspenningsframstøyt',),
'avspenningsframstøytene': ('avspenningsframstøyt',),
'avspenningsgymnastikk': ('avspenningsgymnastikk',),
'avspenningsgymnastikken': ('avspenningsgymnastikk',),
'avspenningsgymnastikker': ('avspenningsgymnastikk',),
'avspenningsgymnastikkene': ('avspenningsgymnastikk',),
'avspenningspolitikk': ('avspenningspolitikk',),
'avspenningspolitikken': ('avspenningspolitikk',),
'avspenningspolitikker': ('avspenningspolitikk',),
'avspenningspolitikkene': ('avspenningspolitikk',),
'avsperring': ('avsperring',),
'avsperringen': ('avsperring',),
'avsperringa': ('avsperring',),
'avsperringer': ('avsperring',),
'avsperringene': ('avsperring',),
'avspilling': ('avspilling',),
'avspillingen': ('avspilling',),
'avspillinga': ('avspilling',),
'avspillinger': ('avspilling',),
'avspillingene': ('avspilling',),
'avspillingsrom': ('avspillingsrom',),
'avspillingsrommet': ('avspillingsrom',),
'avspillingsrom': ('avspillingsrom',),
'avspillingsromma': ('avspillingsrom',),
'avspillingsrommene': ('avspillingsrom',),
'avsporing': ('avsporing',),
'avsporingen': ('avsporing',),
'avsporinga': ('avsporing',),
'avsporinger': ('avsporing',),
'avsporingene': ('avsporing',),
'avstamning': ('avstamning',),
'avstamningen': ('avstamning',),
'avstamninga': ('avstamning',),
'avstamninger': ('avstamning',),
'avstamningene': ('avstamning',),
'avstamningslære': ('avstamningslære',),
'avstamningslæren': ('avstamningslære',),
'avstamningslæra': ('avstamningslære',),
'avstamningslærer': ('avstamningslære',),
'avstamningslærene': ('avstamningslære',),
'avstand': ('avstand',),
'avstanden': ('avstand',),
'avstander': ('avstand',),
'avstandene': ('avstand',),
'avstandsbedømmelse': ('avstandsbedømmelse',),
'avstandsbedømmelsen': ('avstandsbedømmelse',),
'avstandsbedømmelser': ('avstandsbedømmelse',),
'avstandsbedømmelsene': ('avstandsbedømmelse',),
'avstandsinnstilling': ('avstandsinnstilling',),
'avstandsinnstillingen': ('avstandsinnstilling',),
'avstandsinnstillinga': ('avstandsinnstilling',),
'avstandsinnstillinger': ('avstandsinnstilling',),
'avstandsinnstillingene': ('avstandsinnstilling',),
'avstandsmåler': ('avstandsmåler',),
'avstandsmåleren': ('avstandsmåler',),
'avstandsmålere': ('avstandsmåler',),
'avstandsmålerne': ('avstandsmåler',),
'avstandtagen': ('avstandtagen',),
'avstandtaing': ('avstandtaing',),
'avstandtaingen': ('avstandtaing',),
'avstandtainga': ('avstandtaing',),
'avstandtainger': ('avstandtaing',),
'avstandtaingene': ('avstandtaing',),
'avstandtaken': ('avstandtaken',),
'avstandtaking': ('avstandtaking',),
'avstandtakingen': ('avstandtaking',),
'avstandtakinga': ('avstandtaking',),
'avstandtakinger': ('avstandtaking',),
'avstandtakingene': ('avstandtaking',),
'avstemning': ('avstemning',),
'avstemningen': ('avstemning',),
'avstemninga': ('avstemning',),
'avstemninger': ('avstemning',),
'avstemningene': ('avstemning',),
'avstemningsmåte': ('avstemningsmåte',),
'avstemningsmåten': ('avstemningsmåte',),
'avstemningsmåter': ('avstemningsmåte',),
'avstemningsmåtene': ('avstemningsmåte',),
'avstemningsresultat': ('avstemningsresultat',),
'avstemningsresultatet': ('avstemningsresultat',),
'avstemningsresultat': ('avstemningsresultat',),
'avstemningsresultater': ('avstemningsresultat',),
'avstemningsresultat': ('avstemningsresultat',),
'avstemningsresultater': ('avstemningsresultat',),
'avstemningsresultata': ('avstemningsresultat',),
'avstemningsresultatene': ('avstemningsresultat',),
'avstenging': ('avstenging',),
'avstengingen': ('avstenging',),
'avstenginga': ('avstenging',),
'avstenginger': ('avstenging',),
'avstengingene': ('avstenging',),
'avstengingskran': ('avstengingskran',),
'avstengingskranen': ('avstengingskran',),
'avstengingskrana': ('avstengingskran',),
'avstengingskraner': ('avstengingskran',),
'avstengingskranene': ('avstengingskran',),
'avstengingsventil': ('avstengingsventil',),
'avstengingsventilen': ('avstengingsventil',),
'avstengingsventiler': ('avstengingsventil',),
'avstengingsventilene': ('avstengingsventil',),
'avstengning': ('avstengning',),
'avstengningen': ('avstengning',),
'avstengninga': ('avstengning',),
'avstengninger': ('avstengning',),
'avstengningene': ('avstengning',),
'avstengningskran': ('avstengningskran',),
'avstengningskranen': ('avstengningskran',),
'avstengningskrana': ('avstengningskran',),
'avstengningskraner': ('avstengningskran',),
'avstengningskranene': ('avstengningskran',),
'avstengningsventil': ('avstengningsventil',),
'avstengningsventilen': ('avstengningsventil',),
'avstengningsventiler': ('avstengningsventil',),
'avstengningsventilene': ('avstengningsventil',),
'avstiging': ('avstiging',),
'avstigingen': ('avstiging',),
'avstiginga': ('avstiging',),
'avstiginger': ('avstiging',),
'avstigingene': ('avstiging',),
'avstigingsperrong': ('avstigingsperrong',),
'avstigingsperrongen': ('avstigingsperrong',),
'avstigingsperronger': ('avstigingsperrong',),
'avstigingsperrongene': ('avstigingsperrong',),
'avstigingstrapp': ('avstigingstrapp',),
'avstigingstrappen': ('avstigingstrapp',),
'avstigingstrappa': ('avstigingstrapp',),
'avstigingstrapper': ('avstigingstrapp',),
'avstigingstrappene': ('avstigingstrapp',),
'avstigning': ('avstigning',),
'avstigningen': ('avstigning',),
'avstigninga': ('avstigning',),
'avstigninger': ('avstigning',),
'avstigningene': ('avstigning',),
'avstigningsperrong': ('avstigningsperrong',),
'avstigningsperrongen': ('avstigningsperrong',),
'avstigningsperronger': ('avstigningsperrong',),
'avstigningsperrongene': ('avstigningsperrong',),
'avstigningstrapp': ('avstigningstrapp',),
'avstigningstrappen': ('avstigningstrapp',),
'avstigningstrappa': ('avstigningstrapp',),
'avstigningstrapper': ('avstigningstrapp',),
'avstigningstrappene': ('avstigningstrapp',),
'avstikker': ('avstikker',),
'avstikkeren': ('avstikker',),
'avstikkere': ('avstikker',),
'avstikkerne': ('avstikker',),
'avstiver': ('avstiver',),
'avstiveren': ('avstiver',),
'avstivere': ('avstiver',),
'avstiverne': ('avstiver',),
'avstiving': ('avstiving',),
'avstivingen': ('avstiving',),
'avstivinga': ('avstiving',),
'avstivinger': ('avstiving',),
'avstivingene': ('avstiving',),
'avstivingsbjelke': ('avstivingsbjelke',),
'avstivingsbjelken': ('avstivingsbjelke',),
'avstivingsbjelker': ('avstivingsbjelke',),
'avstivingsbjelkene': ('avstivingsbjelke',),
'avstivingsplate': ('avstivingsplate',),
'avstivingsplaten': ('avstivingsplate',),
'avstivingsplata': ('avstivingsplate',),
'avstivingsplater': ('avstivingsplate',),
'avstivingsplatene': ('avstivingsplate',),
'avstivning': ('avstivning',),
'avstivningen': ('avstivning',),
'avstivninga': ('avstivning',),
'avstivninger': ('avstivning',),
'avstivningene': ('avstivning',),
'avstivningsbjelke': ('avstivningsbjelke',),
'avstivningsbjelken': ('avstivningsbjelke',),
'avstivningsbjelker': ('avstivningsbjelke',),
'avstivningsbjelkene': ('avstivningsbjelke',),
'avstivningsplate': ('avstivningsplate',),
'avstivningsplaten': ('avstivningsplate',),
'avstivningsplata': ('avstivningsplate',),
'avstivningsplater': ('avstivningsplate',),
'avstivningsplatene': ('avstivningsplate',),
'avstraffelse': ('avstraffelse',),
'avstraffelsen': ('avstraffelse',),
'avstraffelser': ('avstraffelse',),
'avstraffelsene': ('avstraffelse',),
'avstøpning': ('avstøpning',),
'avstøpningen': ('avstøpning',),
'avstøpninga': ('avstøpning',),
'avstøpninger': ('avstøpning',),
'avstøpningene': ('avstøpning',),
'avsøker': ('avsøker',),
'avsøkeren': ('avsøker',),
'avsøkere': ('avsøker',),
'avsøkerne': ('avsøker',),
'avtak': ('avtak',),
'avtaket': ('avtak',),
'avtak': ('avtak',),
'avtaka': ('avtak',),
'avtakene': ('avtak',),
'avtaker': ('avtaker',),
'avtakeren': ('avtaker',),
'avtakere': ('avtaker',),
'avtakerne': ('avtaker',),
'avtakerland': ('avtakerland',),
'avtakerlandet': ('avtakerland',),
'avtakerland': ('avtakerland',),
'avtakerlanda': ('avtakerland',),
'avtakerlandene': ('avtakerland',),
'avtale': ('avtale',),
'avtalen': ('avtale',),
'avtaler': ('avtale',),
'avtalene': ('avtale',),
'avtalebrott': ('avtalebrott',),
'avtalebrottet': ('avtalebrott',),
'avtalebrott': ('avtalebrott',),
'avtalebrotta': ('avtalebrott',),
'avtalebrottene': ('avtalebrott',),
'avtalebrudd': ('avtalebrudd',),
'avtalebruddet': ('avtalebrudd',),
'avtalebrudd': ('avtalebrudd',),
'avtalebrudda': ('avtalebrudd',),
'avtalebruddene': ('avtalebrudd',),
'avtalelov': ('avtalelov',),
'avtaleloven': ('avtalelov',),
'avtalelover': ('avtalelov',),
'avtalelovene': ('avtalelov',),
'avtaleperiode': ('avtaleperiode',),
'avtaleperioden': ('avtaleperiode',),
'avtaleperioder': ('avtaleperiode',),
'avtaleperiodene': ('avtaleperiode',),
'avtaleverk': ('avtaleverk',),
'avtaleverket': ('avtaleverk',),
'avtaleverk': ('avtaleverk',),
'avtaleverker': ('avtaleverk',),
'avtaleverk': ('avtaleverk',),
'avtaleverker': ('avtaleverk',),
'avtaleverka': ('avtaleverk',),
'avtaleverkene': ('avtaleverk',),
'avtegn': ('avtegn',),
'avtegnet': ('avtegn',),
'avtegn': ('avtegn',),
'avtegna': ('avtegn',),
'avtegnene': ('avtegn',),
'avtrapning': ('avtrapning',),
'avtrapningen': ('avtrapning',),
'avtrapninga': ('avtrapning',),
'avtrapninger': ('avtrapning',),
'avtrapningene': ('avtrapning',),
'avtrapping': ('avtrapping',),
'avtrappingen': ('avtrapping',),
'avtrappinga': ('avtrapping',),
'avtrappinger': ('avtrapping',),
'avtrappingene': ('avtrapping',),
'avtrede': ('avtrede',),
'avtredet': ('avtrede',),
'avtreder': ('avtrede',),
'avtreda': ('avtrede',),
'avtredene': ('avtrede',),
'avtrekk': ('avtrekk',),
'avtrekket': ('avtrekk',),
'avtrekk': ('avtrekk',),
'avtrekka': ('avtrekk',),
'avtrekkene': ('avtrekk',),
'avtrekker': ('avtrekker',),
'avtrekkeren': ('avtrekker',),
'avtrekkere': ('avtrekker',),
'avtrekkerne': ('avtrekker',),
'avtrekkshastighet': ('avtrekkshastighet',),
'avtrekkshastigheten': ('avtrekkshastighet',),
'avtrekkshastigheta': ('avtrekkshastighet',),
'avtrekkshastigheter': ('avtrekkshastighet',),
'avtrekkshastighetene': ('avtrekkshastighet',),
'avtrekkshette': ('avtrekkshette',),
'avtrekkshetten': ('avtrekkshette',),
'avtrekkshetta': ('avtrekkshette',),
'avtrekkshetter': ('avtrekkshette',),
'avtrekkshettene': ('avtrekkshette',),
'avtrekkshylse': ('avtrekkshylse',),
'avtrekkshylsen': ('avtrekkshylse',),
'avtrekkshylsa': ('avtrekkshylse',),
'avtrekkshylser': ('avtrekkshylse',),
'avtrekkshylsene': ('avtrekkshylse',),
'avtrekkskanal': ('avtrekkskanal',),
'avtrekkskanalen': ('avtrekkskanal',),
'avtrekkskanaler': ('avtrekkskanal',),
'avtrekkskanalene': ('avtrekkskanal',),
'avtrekksrør': ('avtrekksrør',),
'avtrekksrøret': ('avtrekksrør',),
'avtrekksrør': ('avtrekksrør',),
'avtrekksrøra': ('avtrekksrør',),
'avtrekksrørene': ('avtrekksrør',),
'avtrekksvifte': ('avtrekksvifte',),
'avtrekksviften': ('avtrekksvifte',),
'avtrekksvifta': ('avtrekksvifte',),
'avtrekksvifter': ('avtrekksvifte',),
'avtrekksviftene': ('avtrekksvifte',),
'avtrykk': ('avtrykk',),
'avtrykket': ('avtrykk',),
'avtrykk': ('avtrykk',),
'avtrykka': ('avtrykk',),
'avtrykkene': ('avtrykk',),
'avund': ('avund',),
'avunden': ('avund',),
'avunder': ('avund',),
'avundene': ('avund',),
'avveg': ('avveg',),
'avvegen': ('avveg',),
'avveger': ('avveg',),
'avvegene': ('avveg',),
'avvei': ('avvei',),
'avveien': ('avvei',),
'avveier': ('avvei',),
'avveiene': ('avvei',),
'avveksling': ('avveksling',),
'avvekslingen': ('avveksling',),
'avvekslinga': ('avveksling',),
'avvekslinger': ('avveksling',),
'avvekslingene': ('avveksling',),
'avvenning': ('avvenning',),
'avvenningen': ('avvenning',),
'avvenninga': ('avvenning',),
'avvenninger': ('avvenning',),
'avvenningene': ('avvenning',),
'avvenningsalder': ('avvenningsalder',),
'avvenningsalderen': ('avvenningsalder',),
'avvenningsaldere': ('avvenningsalder',),
'avvenningsaldrer': ('avvenningsalder',),
'avvenningsaldre': ('avvenningsalder',),
'avvenningsalderne': ('avvenningsalder',),
'avvenningsaldrene': ('avvenningsalder',),
'avvenningskur': ('avvenningskur',),
'avvenningskuren': ('avvenningskur',),
'avvenningskurer': ('avvenningskur',),
'avvenningskurene': ('avvenningskur',),
'avverge': ('avverge',),
'avvergen': ('avverge',),
'avverger': ('avverge',),
'avvergene': ('avverge',),
'avverging': ('avverging',),
'avvergingen': ('avverging',),
'avverginga': ('avverging',),
'avverginger': ('avverging',),
'avvergingene': ('avverging',),
'avvergingsmekanisme': ('avvergingsmekanisme',),
'avvergingsmekanismen': ('avvergingsmekanisme',),
'avvergingsmekanismer': ('avvergingsmekanisme',),
'avvergingsmekanismene': ('avvergingsmekanisme',),
'avvergingsmiddel': ('avvergingsmiddel',),
'avvergingsmiddelet': ('avvergingsmiddel',),
'avvergingsmidlet': ('avvergingsmiddel',),
'avvergingsmiddel': ('avvergingsmiddel',),
'avvergingsmidler': ('avvergingsmiddel',),
'avvergingsmidla': ('avvergingsmiddel',),
'avvergingsmidlene': ('avvergingsmiddel',),
'avvergingsmidla': ('avvergingsmiddel',),
'avvergingsmidlene': ('avvergingsmiddel',),
'avvik': ('avvik',),
'avviket': ('avvik',),
'avvik': ('avvik',),
'avvika': ('avvik',),
'avvikene': ('avvik',),
'avvikelse': ('avvikelse',),
'avvikelsen': ('avvikelse',),
'avvikelser': ('avvikelse',),
'avvikelsene': ('avvikelse',),
'avviker': ('avviker',),
'avvikeren': ('avviker',),
'avvikere': ('avviker',),
'avvikerne': ('avviker',),
'avvikling': ('avvikling',),
'avviklingen': ('avvikling',),
'avviklinga': ('avvikling',),
'avviklinger': ('avvikling',),
'avviklingene': ('avvikling',),
'avviklingsstyre': ('avviklingsstyre',),
'avviklingsstyret': ('avviklingsstyre',),
'avviklingsstyrer': ('avviklingsstyre',),
'avviklingsstyra': ('avviklingsstyre',),
'avviklingsstyrene': ('avviklingsstyre',),
'avvirking': ('avvirking',),
'avvirkingen': ('avvirking',),
'avvirkinga': ('avvirking',),
'avvirkinger': ('avvirking',),
'avvirkingene': ('avvirking',),
'avvirkingskalkyle': ('avvirkingskalkyle',),
'avvirkingskalkylen': ('avvirkingskalkyle',),
'avvirkingskalkyler': ('avvirkingskalkyle',),
'avvirkingskalkylene': ('avvirkingskalkyle',),
'avvirkingsområde': ('avvirkingsområde',),
'avvirkingsområdet': ('avvirkingsområde',),
'avvirkingsområder': ('avvirkingsområde',),
'avvirkingsområda': ('avvirkingsområde',),
'avvirkingsområdene': ('avvirkingsområde',),
'avvirkingsprosent': ('avvirkingsprosent',),
'avvirkingsprosenten': ('avvirkingsprosent',),
'avvirkingsprosenter': ('avvirkingsprosent',),
'avvirkingsprosent': ('avvirkingsprosent',),
'avvirkingsprosentene': ('avvirkingsprosent',),
'avvirkning': ('avvirkning',),
'avvirkningen': ('avvirkning',),
'avvirkninga': ('avvirkning',),
'avvirkninger': ('avvirkning',),
'avvirkningene': ('avvirkning',),
'avvirkningskalkyle': ('avvirkningskalkyle',),
'avvirkningskalkylen': ('avvirkningskalkyle',),
'avvirkningskalkyler': ('avvirkningskalkyle',),
'avvirkningskalkylene': ('avvirkningskalkyle',),
'avvirkningsområde': ('avvirkningsområde',),
'avvirkningsområdet': ('avvirkningsområde',),
'avvirkningsområder': ('avvirkningsområde',),
'avvirkningsområda': ('avvirkningsområde',),
'avvirkningsområdene': ('avvirkningsområde',),
'avvirkningsprosent': ('avvirkningsprosent',),
'avvirkningsprosenten': ('avvirkningsprosent',),
'avvirkningsprosenter': ('avvirkningsprosent',),
'avvirkningsprosent': ('avvirkningsprosent',),
'avvirkningsprosentene': ('avvirkningsprosent',),
'avviser': ('avviser',),
'avviseren': ('avviser',),
'avvisere': ('avviser',),
'avviserne': ('avviser',),
'avviserstein': ('avviserstein',),
'avvisersteinen': ('avviserstein',),
'avvisersteiner': ('avviserstein',),
'avvisersteinene': ('avviserstein',),
'avviserstolpe': ('avviserstolpe',),
'avviserstolpen': ('avviserstolpe',),
'avviserstolper': ('avviserstolpe',),
'avviserstolpene': ('avviserstolpe',),
'avvising': ('avvising',),
'avvisingen': ('avvising',),
'avvisinga': ('avvising',),
'avvisinger': ('avvising',),
'avvisingene': ('avvising',),
'avvisingsreaksjon': ('avvisingsreaksjon',),
'avvisingsreaksjonen': ('avvisingsreaksjon',),
'avvisingsreaksjoner': ('avvisingsreaksjon',),
'avvisingsreaksjonene': ('avvisingsreaksjon',),
'avvisning': ('avvisning',),
'avvisningen': ('avvisning',),
'avvisninga': ('avvisning',),
'avvisninger': ('avvisning',),
'avvisningene': ('avvisning',),
'avvisningsreaksjon': ('avvisningsreaksjon',),
'avvisningsreaksjonen': ('avvisningsreaksjon',),
'avvisningsreaksjoner': ('avvisningsreaksjon',),
'avvisningsreaksjonene': ('avvisningsreaksjon',),
'ayatolla': ('ayatolla',),
'ayatollaen': ('ayatolla',),
'ayatollaer': ('ayatolla',),
'ayatollaene': ('ayatolla',),
'azteker': ('azteker',),
'aztekeren': ('azteker',),
'aztekere': ('azteker',),
'aztekerne': ('azteker',),
'b': ('b',),
'b-en': ('b',),
'b-er': ('b',),
'b-ene': ('b',),
'b-film': ('b-film',),
'b-filmen': ('b-film',),
'b-filmer': ('b-film',),
'b-filmene': ('b-film',),
'b-kvalitet': ('b-kvalitet',),
'b-kvaliteten': ('b-kvalitet',),
'b-kvaliteter': ('b-kvalitet',),
'b-kvalitetene': ('b-kvalitet',),
'b-lag': ('b-lag',),
'b-laget': ('b-lag',),
'b-lag': ('b-lag',),
'b-laga': ('b-lag',),
'b-lagene': ('b-lag',),
'b-menneske': ('b-menneske',),
'b-mennesket': ('b-menneske',),
'b-mennesker': ('b-menneske',),
'b-menneska': ('b-menneske',),
'b-menneskene': ('b-menneske',),
'b-moll': ('b-moll',),
'b-mollen': ('b-moll',),
'b-moller': ('b-moll',),
'b-mollene': ('b-moll',),
'babbel': ('babbel',),
'babbelet': ('babbel',),
'bablet': ('babbel',),
'babbel': ('babbel',),
'babler': ('babbel',),
'babla': ('babbel',),
'bablene': ('babbel',),
'babla': ('babbel',),
'bablene': ('babbel',),
'babel': ('babel',),
'babl': ('babl',),
'bablet': ('babl',),
'babl': ('babl',),
'babla': ('babl',),
'bablene': ('babl',),
'babord': ('babord',),
'baby': ('baby',),
'babyen': ('baby',),
'babyer': ('baby',),
'babyene': ('baby',),
'babyklær': ('babyklær',),
'babyklærne': ('babyklær',),
'babykorg': ('babykorg',),
'babykorgen': ('babykorg',),
'babykorga': ('babykorg',),
'babykorger': ('babykorg',),
'babykorgene': ('babykorg',),
'babykurv': ('babykurv',),
'babykurven': ('babykurv',),
'babykurva': ('babykurv',),
'babykurver': ('babykurv',),
'babykurvene': ('babykurv',),
'babyloner': ('babyloner',),
'babyloneren': ('babyloner',),
'babylonere': ('babyloner',),
'babylonerne': ('babyloner',),
'babylonier': ('babylonier',),
'babylonieren': ('babylonier',),
'babyloniere': ('babylonier',),
'babylonierne': ('babylonier',),
'babypose': ('babypose',),
'babyposen': ('babypose',),
'babyposer': ('babypose',),
'babyposene': ('babypose',),
'bacalao': ('bacalao',),
'bacalaoen': ('bacalao',),
'bacalaoer': ('bacalao',),
'bacalaoene': ('bacalao',),
'back': ('back',),
'backen': ('back',),
'backer': ('back',),
'backene': ('back',),
'backfisch': ('backfisch',),
'backfischen': ('backfisch',),
'backfischer': ('backfisch',),
'backfischene': ('backfisch',),
'backhand': ('backhand',),
'backhanden': ('backhand',),
'backhander': ('backhand',),
'backhandene': ('backhand',),
'backlash': ('backlash',),
'backlashen': ('backlash',),
'backlasher': ('backlash',),
'backlashene': ('backlash',),
'bacon': ('bacon',),
'baconet': ('bacon',),
'bacon': ('bacon',),
'bacona': ('bacon',),
'baconene': ('bacon',),
'bacongris': ('bacongris',),
'bacongrisen': ('bacongris',),
'bacongriser': ('bacongris',),
'bacongrisene': ('bacongris',),
'baconost': ('baconost',),
'baconosten': ('baconost',),
'baconoster': ('baconost',),
'baconostene': ('baconost',),
'bad': ('bad',),
'badet': ('bad',),
'bad': ('bad',),
'bada': ('bad',),
'badene': ('bad',),
'badeanstalt': ('badeanstalt',),
'badeanstalten': ('badeanstalt',),
'badeanstalter': ('badeanstalt',),
'badeanstaltene': ('badeanstalt',),
'badebalje': ('badebalje',),
'badebaljen': ('badebalje',),
'badebalja': ('badebalje',),
'badebaljer': ('badebalje',),
'badebaljene': ('badebalje',),
'badeball': ('badeball',),
'badeballen': ('badeball',),
'badeballer': ('badeball',),
'badeballene': ('badeball',),
'badebukse': ('badebukse',),
'badebuksen': ('badebukse',),
'badebuksa': ('badebukse',),
'badebukser': ('badebukse',),
'badebuksene': ('badebukse',),
'badeby': ('badeby',),
'badebyen': ('badeby',),
'badebyer': ('badeby',),
'badebyene': ('badeby',),
'badedrakt': ('badedrakt',),
'badedrakten': ('badedrakt',),
'badedrakta': ('badedrakt',),
'badedrakter': ('badedrakt',),
'badedraktene': ('badedrakt',),
'badegjest': ('badegjest',),
'badegjesten': ('badegjest',),
'badegjester': ('badegjest',),
'badegjestene': ('badegjest',),
'badehandkle': ('badehandkle',),
'badehandkleet': ('badehandkle',),
'badehandklær': ('badehandkle',),
'badehandklærne': ('badehandkle',),
'badehette': ('badehette',),
'badehetten': ('badehette',),
'badehetta': ('badehette',),
'badehetter': ('badehette',),
'badehettene': ('badehette',),
'badehåndkle': ('badehåndkle',),
'badehåndkleet': ('badehåndkle',),
'badehåndklær': ('badehåndkle',),
'badehåndklærne': ('badehåndkle',),
'badekar': ('badekar',),
'badekaret': ('badekar',),
'badekar': ('badekar',),
'badekara': ('badekar',),
'badekarene': ('badekar',),
'badenymfe': ('badenymfe',),
'badenymfen': ('badenymfe',),
'badenymfa': ('badenymfe',),
'badenymfer': ('badenymfe',),
'badenymfene': ('badenymfe',),
'badeovn': ('badeovn',),
'badeovnen': ('badeovn',),
'badeovner': ('badeovn',),
'badeovnene': ('badeovn',),
'bader': ('bader',),
'baderen': ('bader',),
'badere': ('bader',),
'baderne': ('bader',),
'baderom': ('baderom',),
'baderommet': ('baderom',),
'baderom': ('baderom',),
'baderomma': ('baderom',),
'baderommene': ('baderom',),
'badesalt': ('badesalt',),
'badesaltet': ('badesalt',),
'badesalter': ('badesalt',),
'badesalta': ('badesalt',),
'badesaltene': ('badesalt',),
'badesesong': ('badesesong',),
'badesesongen': ('badesesong',),
'badesesonger': ('badesesong',),
'badesesongene': ('badesesong',),
'badested': ('badested',),
'badestedet': ('badested',),
'badesteder': ('badested',),
'badestedene': ('badested',),
'badestrand': ('badestrand',),
'badestranden': ('badestrand',),
'badestranda': ('badestrand',),
'badestrender': ('badestrand',),
'badestrendene': ('badestrand',),
'badesvamp': ('badesvamp',),
'badesvampen': ('badesvamp',),
'badesvamper': ('badesvamp',),
'badesvampene': ('badesvamp',),
'badevann': ('badevann',),
'badevannet': ('badevann',),
'badevann': ('badevann',),
'badevanna': ('badevann',),
'badevannene': ('badevann',),
'badevatn': ('badevatn',),
'badevatnet': ('badevatn',),
'badevatn': ('badevatn',),
'badevatna': ('badevatn',),
'badevatnene': ('badevatn',),
'badminton': ('badminton',),
'badmintonen': ('badminton',),
'badmintoner': ('badminton',),
'badmintonene': ('badminton',),
'badmintonball': ('badmintonball',),
'badmintonballen': ('badmintonball',),
'badmintonballer': ('badmintonball',),
'badmintonballene': ('badmintonball',),
'badmintonbane': ('badmintonbane',),
'badmintonbanen': ('badmintonbane',),
'badmintonbaner': ('badmintonbane',),
'badmintonbanene': ('badmintonbane',),
'badmintonkamp': ('badmintonkamp',),
'badmintonkampen': ('badmintonkamp',),
'badmintonkamper': ('badmintonkamp',),
'badmintonkampene': ('badmintonkamp',),
'badstubad': ('badstubad',),
'badstubadet': ('badstubad',),
'badstubad': ('badstubad',),
'badstubada': ('badstubad',),
'badstubadene': ('badstubad',),
'badstue': ('badstue',),
'badstuen': ('badstue',),
'badstua': ('badstue',),
'badstuer': ('badstue',),
'badstuene': ('badstue',),
'badstuovn': ('badstuovn',),
'badstuovnen': ('badstuovn',),
'badstuovner': ('badstuovn',),
'badstuovnene': ('badstuovn',),
'bag': ('bag',),
'bagen': ('bag',),
'bager': ('bag',),
'bagene': ('bag',),
'bagasje': ('bagasje',),
'bagasjen': ('bagasje',),
'bagasjer': ('bagasje',),
'bagasjene': ('bagasje',),
'bagasjebrett': ('bagasjebrett',),
'bagasjebrettet': ('bagasjebrett',),
'bagasjebrett': ('bagasjebrett',),
'bagasjebretter': ('bagasjebrett',),
'bagasjebrett': ('bagasjebrett',),
'bagasjebretter': ('bagasjebrett',),
'bagasjebretta': ('bagasjebrett',),
'bagasjebrettene': ('bagasjebrett',),
'bagasjebærer': ('bagasjebærer',),
'bagasjebæreren': ('bagasjebærer',),
'bagasjebærere': ('bagasjebærer',),
'bagasjebærerne': ('bagasjebærer',),
'bagasjeforsikring': ('bagasjeforsikring',),
'bagasjeforsikringen': ('bagasjeforsikring',),
'bagasjeforsikringa': ('bagasjeforsikring',),
'bagasjeforsikringer': ('bagasjeforsikring',),
'bagasjeforsikringene': ('bagasjeforsikring',),
'bagasjegrind': ('bagasjegrind',),
'bagasjegrinden': ('bagasjegrind',),
'bagasjegrinda': ('bagasjegrind',),
'bagasjegrinder': ('bagasjegrind',),
'bagasjegrindene': ('bagasjegrind',),
'bagasjehylle': ('bagasjehylle',),
'bagasjehyllen': ('bagasjehylle',),
'bagasjehylla': ('bagasjehylle',),
'bagasjehyller': ('bagasjehylle',),
'bagasjehyllene': ('bagasjehylle',),
'bagasjenett': ('bagasjenett',),
'bagasjenettet': ('bagasjenett',),
'bagasjenett': ('bagasjenett',),
'bagasjenetta': ('bagasjenett',),
'bagasjenettene': ('bagasjenett',),
'bagasjerom': ('bagasjerom',),
'bagasjerommet': ('bagasjerom',),
'bagasjerom': ('bagasjerom',),
'bagasjeromma': ('bagasjerom',),
'bagasjerommene': ('bagasjerom',),
'bagatell': ('bagatell',),
'bagatellen': ('bagatell',),
'bagateller': ('bagatell',),
'bagatellene': ('bagatell',),
'bagett': ('bagett',),
'bagetten': ('bagett',),
'bagetter': ('bagett',),
'bagettene': ('bagett',),
'bagler': ('bagler',),
'bagleren': ('bagler',),
'baglere': ('bagler',),
'baglerne': ('bagler',),
'baglerbisp': ('baglerbisp',),
'baglerbispen': ('baglerbisp',),
'baglerbisper': ('baglerbisp',),
'baglerbispene': ('baglerbisp',),
'baglerflokk': ('baglerflokk',),
'baglerflokken': ('baglerflokk',),
'baglerflokker': ('baglerflokk',),
'baglerflokkene': ('baglerflokk',),
'baglerhær': ('baglerhær',),
'baglerhæren': ('baglerhær',),
'baglerhærer': ('baglerhær',),
'baglerhærene': ('baglerhær',),
'baglerkonge': ('baglerkonge',),
'baglerkongen': ('baglerkonge',),
'baglerkonger': ('baglerkonge',),
'baglerkongene': ('baglerkonge',),
'bagvogn': ('bagvogn',),
'bagvognen': ('bagvogn',),
'bagvogna': ('bagvogn',),
'bagvogner': ('bagvogn',),
'bagvognene': ('bagvogn',),
'bahaimedlem': ('bahaimedlem',),
'bahaimedlemmet': ('bahaimedlem',),
'bahaimedlemmer': ('bahaimedlem',),
'bahaimedlemma': ('bahaimedlem',),
'bahaimedlemmene': ('bahaimedlem',),
'bahaisamfunn': ('bahaisamfunn',),
'bahaisamfunnet': ('bahaisamfunn',),
'bahaisamfunn': ('bahaisamfunn',),
'bahaisamfunna': ('bahaisamfunn',),
'bahaisamfunnene': ('bahaisamfunn',),
'bahaitro': ('bahaitro',),
'bahaitroen': ('bahaitro',),
'bahaitroa': ('bahaitro',),
'bahaitroer': ('bahaitro',),
'bahaitroene': ('bahaitro',),
'bahamaner': ('bahamaner',),
'bahamaneren': ('bahamaner',),
'bahamanere': ('bahamaner',),
'bahamanerne': ('bahamaner',),
'bahrainer': ('bahrainer',),
'bahraineren': ('bahrainer',),
'bahrainere': ('bahrainer',),
'bahrainerne': ('bahrainer',),
'baisse': ('baisse',),
'baissen': ('baisse',),
'baisser': ('baisse',),
'baissene': ('baisse',),
'baissespekulant': ('baissespekulant',),
'baissespekulanten': ('baissespekulant',),
'baissespekulanter': ('baissespekulant',),
'baissespekulantene': ('baissespekulant',),
'bajas': ('bajas',),
'bajasen': ('bajas',),
'bajaser': ('bajas',),
'bajasene': ('bajas',),
'bajasfakte': ('bajasfakte',),
'bajasfakten': ('bajasfakte',),
'bajasfakta': ('bajasfakte',),
'bajasfakter': ('bajasfakte',),
'bajasfaktene': ('bajasfakte',),
'bajasfjes': ('bajasfjes',),
'bajasfjeset': ('bajasfjes',),
'bajasfjes': ('bajasfjes',),
'bajasfjesa': ('bajasfjes',),
'bajasfjesene': ('bajasfjes',),
'bajasstrek': ('bajasstrek',),
'bajasstreken': ('bajasstrek',),
'bajasstreker': ('bajasstrek',),
'bajasstrekene': ('bajasstrek',),
'bajazzo': ('bajazzo',),
'bajazzoen': ('bajazzo',),
'bajazzoer': ('bajazzo',),
'bajazzoene': ('bajazzo',),
'bajonett': ('bajonett',),
'bajonetten': ('bajonett',),
'bajonetter': ('bajonett',),
'bajonettene': ('bajonett',),
'bajonettkamp': ('bajonettkamp',),
'bajonettkampen': ('bajonettkamp',),
'bajonettkamper': ('bajonettkamp',),
'bajonettkampene': ('bajonettkamp',),
'bajonettlås': ('bajonettlås',),
'bajonettlåsen': ('bajonettlås',),
'bajonettlåset': ('bajonettlås',),
'bajonettlåser': ('bajonettlås',),
'bajonettlås': ('bajonettlås',),
'bajonettlåser': ('bajonettlås',),
'bajonettlås': ('bajonettlås',),
'bajonettlåser': ('bajonettlås',),
'bajonettlåsene': ('bajonettlås',),
'bajonettlåsa': ('bajonettlås',),
'bajonettlåsene': ('bajonettlås',),
'bak': ('bak',),
'baken': ('bak',),
'baker': ('bak',),
'bakene': ('bak',),
'bak': ('bak',),
'baket': ('bak',),
'bak': ('bak',),
'baka': ('bak',),
'bakene': ('bak',),
'bakaksel': ('bakaksel',),
'bakakselen': ('bakaksel',),
'bakaksler': ('bakaksel',),
'bakakslene': ('bakaksel',),
'bakbein': ('bakbein',),
'bakbeinet': ('bakbein',),
'bakbein': ('bakbein',),
'bakbeina': ('bakbein',),
'bakbeinene': ('bakbein',),
'bakben': ('bakben',),
'bakbenet': ('bakben',),
'bakben': ('bakben',),
'bakbena': ('bakben',),
'bakbenene': ('bakben',),
'bakdel': ('bakdel',),
'bakdelen': ('bakdel',),
'bakdeler': ('bakdel',),
'bakdelene': ('bakdel',),
'bakdør': ('bakdør',),
'bakdøren': ('bakdør',),
'bakdøra': ('bakdør',),
'bakdører': ('bakdør',),
'bakdørene': ('bakdør',),
'bakdørspolitikk': ('bakdørspolitikk',),
'bakdørspolitikken': ('bakdørspolitikk',),
'bakdørspolitikker': ('bakdørspolitikk',),
'bakdørspolitikkene': ('bakdørspolitikk',),
'bakelitt': ('bakelitt',),
'bakelitten': ('bakelitt',),
'bakelitter': ('bakelitt',),
'bakelittene': ('bakelitt',),
'bakende': ('bakende',),
'bakenden': ('bakende',),
'bakender': ('bakende',),
'bakendene': ('bakende',),
'bakepulver': ('bakepulver',),
'bakepulveret': ('bakepulver',),
'bakepulver': ('bakepulver',),
'bakepulvere': ('bakepulver',),
'bakepulvera': ('bakepulver',),
'bakepulverne': ('bakepulver',),
'bakepulvera': ('bakepulver',),
'bakepulverne': ('bakepulver',),
'baker': ('baker',),
'bakeren': ('baker',),
'bakere': ('baker',),
'bakerne': ('baker',),
'bakerbutikk': ('bakerbutikk',),
'bakerbutikken': ('bakerbutikk',),
'bakerbutikker': ('bakerbutikk',),
'bakerbutikkene': ('bakerbutikk',),
'bakeri': ('bakeri',),
'bakeriet': ('bakeri',),
'bakeri': ('bakeri',),
'bakerier': ('bakeri',),
'bakeri': ('bakeri',),
'bakerier': ('bakeri',),
'bakeria': ('bakeri',),
'bakeriene': ('bakeri',),
'bakerovn': ('bakerovn',),
'bakerovnen': ('bakerovn',),
'bakerovner': ('bakerovn',),
'bakerovnene': ('bakerovn',),
'bakervare': ('bakervare',),
'bakervaren': ('bakervare',),
'bakervara': ('bakervare',),
'bakervarer': ('bakervare',),
'bakervarene': ('bakervare',),
'bakevje': ('bakevje',),
'bakevjen': ('bakevje',),
'bakevja': ('bakevje',),
'bakevjer': ('bakevje',),
'bakevjene': ('bakevje',),
'bakfjel': ('bakfjel',),
'bakfjelen': ('bakfjel',),
'bakfjela': ('bakfjel',),
'bakfjeler': ('bakfjel',),
'bakfjelene': ('bakfjel',),
'bakfjøl': ('bakfjøl',),
'bakfjølen': ('bakfjøl',),
'bakfjøla': ('bakfjøl',),
'bakfjøler': ('bakfjøl',),
'bakfjølene': ('bakfjøl',),
'bakgate': ('bakgate',),
'bakgaten': ('bakgate',),
'bakgata': ('bakgate',),
'bakgater': ('bakgate',),
'bakgatene': ('bakgate',),
'bakgrunn': ('bakgrunn',),
'bakgrunnen': ('bakgrunn',),
'bakgrunner': ('bakgrunn',),
'bakgrunnene': ('bakgrunn',),
'bakgrunnsfigur': ('bakgrunnsfigur',),
'bakgrunnsfiguren': ('bakgrunnsfigur',),
'bakgrunnsfigurer': ('bakgrunnsfigur',),
'bakgrunnsfigurene': ('bakgrunnsfigur',),
'bakgrunnsmusikk': ('bakgrunnsmusikk',),
'bakgrunnsmusikken': ('bakgrunnsmusikk',),
'bakgrunnsmusikker': ('bakgrunnsmusikk',),
'bakgrunnsmusikkene': ('bakgrunnsmusikk',),
'bakgrunnsstoff': ('bakgrunnsstoff',),
'bakgrunnsstoffet': ('bakgrunnsstoff',),
'bakgrunnsstoff': ('bakgrunnsstoff',),
'bakgrunnsstoffa': ('bakgrunnsstoff',),
'bakgrunnsstoffene': ('bakgrunnsstoff',),
'bakgård': ('bakgård',),
'bakgården': ('bakgård',),
'bakgårder': ('bakgård',),
'bakgårdene': ('bakgård',),
'bakhandsslag': ('bakhandsslag',),
'bakhandsslaget': ('bakhandsslag',),
'bakhandsslag': ('bakhandsslag',),
'bakhandsslaga': ('bakhandsslag',),
'bakhandsslagene': ('bakhandsslag',),
'bakhjul': ('bakhjul',),
'bakhjulet': ('bakhjul',),
'bakhjul': ('bakhjul',),
'bakhjula': ('bakhjul',),
'bakhjulene': ('bakhjul',),
'bakhjulsdrift': ('bakhjulsdrift',),
'bakhjulsdriften': ('bakhjulsdrift',),
'bakhjulsdrifta': ('bakhjulsdrift',),
'bakhjulsdrifter': ('bakhjulsdrift',),
'bakhjulsdriftene': ('bakhjulsdrift',),
'bakhode': ('bakhode',),
'bakhodet': ('bakhode',),
'bakhoder': ('bakhode',),
'bakhoda': ('bakhode',),
'bakhodene': ('bakhode',),
'bakhold': ('bakhold',),
'bakholdet': ('bakhold',),
'bakhold': ('bakhold',),
'bakholda': ('bakhold',),
'bakholdene': ('bakhold',),
'bakholdsangrep': ('bakholdsangrep',),
'bakholdsangrepet': ('bakholdsangrep',),
'bakholdsangrep': ('bakholdsangrep',),
'bakholdsangrepa': ('bakholdsangrep',),
'bakholdsangrepene': ('bakholdsangrep',),
'bakhun': ('bakhun',),
'bakhunen': ('bakhun',),
'bakhuner': ('bakhun',),
'bakhunene': ('bakhun',),
'bakhunved': ('bakhunved',),
'bakhunveden': ('bakhunved',),
'bakhunveder': ('bakhunved',),
'bakhunvedene': ('bakhunved',),
'bakhånd': ('bakhånd',),
'bakhånden': ('bakhånd',),
'bakhånda': ('bakhånd',),
'bakhender': ('bakhånd',),
'bakhendene': ('bakhånd',),
'bakhåndsslag': ('bakhåndsslag',),
'bakhåndsslaget': ('bakhåndsslag',),
'bakhåndsslag': ('bakhåndsslag',),
'bakhåndsslaga': ('bakhåndsslag',),
'bakhåndsslagene': ('bakhåndsslag',),
'bakk': ('bakk',),
'bakken': ('bakk',),
'bakker': ('bakk',),
'bakkene': ('bakk',),
'bakkanal': ('bakkanal',),
'bakkanalet': ('bakkanal',),
'bakkanal': ('bakkanal',),
'bakkanaler': ('bakkanal',),
'bakkanal': ('bakkanal',),
'bakkanaler': ('bakkanal',),
'bakkanala': ('bakkanal',),
'bakkanalene': ('bakkanal',),
'bakkant': ('bakkant',),
'bakkanten': ('bakkant',),
'bakkanter': ('bakkant',),
'bakkantene': ('bakkant',),
'bakkantinne': ('bakkantinne',),
'bakkantinnen': ('bakkantinne',),
'bakkantinna': ('bakkantinne',),
'bakkantinner': ('bakkantinne',),
'bakkantinnene': ('bakkantinne',),
'bakke': ('bakke',),
'bakken': ('bakke',),
'bakker': ('bakke',),
'bakkene': ('bakke',),
'bakkekam': ('bakkekam',),
'bakkekammen': ('bakkekam',),
'bakkekammer': ('bakkekam',),
'bakkekammene': ('bakkekam',),
'bakkeklaring': ('bakkeklaring',),
'bakkeklaringen': ('bakkeklaring',),
'bakkeklaringa': ('bakkeklaring',),
'bakkeklaringer': ('bakkeklaring',),
'bakkeklaringene': ('bakkeklaring',),
'bakkekneik': ('bakkekneik',),
'bakkekneiken': ('bakkekneik',),
'bakkekneika': ('bakkekneik',),
'bakkekneiker': ('bakkekneik',),
'bakkekneikene': ('bakkekneik',),
'bakkekontakt': ('bakkekontakt',),
'bakkekontakten': ('bakkekontakt',),
'bakkekontakter': ('bakkekontakt',),
'bakkekontaktene': ('bakkekontakt',),
'bakkelandskap': ('bakkelandskap',),
'bakkelandskapet': ('bakkelandskap',),
'bakkelandskap': ('bakkelandskap',),
'bakkelandskaper': ('bakkelandskap',),
'bakkelandskap': ('bakkelandskap',),
'bakkelandskaper': ('bakkelandskap',),
'bakkelandskapa': ('bakkelandskap',),
'bakkelandskapene': ('bakkelandskap',),
'bakkels': ('bakkels',),
'bakkelsen': ('bakkels',),
'bakkelser': ('bakkels',),
'bakkelsene': ('bakkels',),
'bakkelse': ('bakkelse',),
'bakkelsen': ('bakkelse',),
'bakkelser': ('bakkelse',),
'bakkelsene': ('bakkelse',),
'bakkeløp': ('bakkeløp',),
'bakkeløpet': ('bakkeløp',),
'bakkeløp': ('bakkeløp',),
'bakkeløpa': ('bakkeløp',),
'bakkeløpene': ('bakkeløp',),
'bakkemannskap': ('bakkemannskap',),
'bakkemannskapet': ('bakkemannskap',),
'bakkemannskap': ('bakkemannskap',),
'bakkemannskaper': ('bakkemannskap',),
'bakkemannskap': ('bakkemannskap',),
'bakkemannskaper': ('bakkemannskap',),
'bakkemannskapa': ('bakkemannskap',),
'bakkemannskapene': ('bakkemannskap',),
'bakkenbart': ('bakkenbart',),
'bakkenbarten': ('bakkenbart',),
'bakkenbarter': ('bakkenbart',),
'bakkenbartene': ('bakkenbart',),
'bakkepersonell': ('bakkepersonell',),
'bakkepersonellet': ('bakkepersonell',),
'bakkepersonell': ('bakkepersonell',),
'bakkepersoneller': ('bakkepersonell',),
'bakkepersonell': ('bakkepersonell',),
'bakkepersoneller': ('bakkepersonell',),
'bakkepersonella': ('bakkepersonell',),
'bakkepersonellene': ('bakkepersonell',),
'bakkeplanering': ('bakkeplanering',),
'bakkeplaneringen': ('bakkeplanering',),
'bakkeplaneringa': ('bakkeplanering',),
'bakkeplaneringer': ('bakkeplanering',),
'bakkeplaneringene': ('bakkeplanering',),
'bakkerekord': ('bakkerekord',),
'bakkerekorden': ('bakkerekord',),
'bakkerekorder': ('bakkerekord',),
'bakkerekordene': ('bakkerekord',),
'bakkeskråning': ('bakkeskråning',),
'bakkeskråningen': ('bakkeskråning',),
'bakkeskråninga': ('bakkeskråning',),
'bakkeskråninger': ('bakkeskråning',),
'bakkeskråningene': ('bakkeskråning',),
'bakkestart': ('bakkestart',),
'bakkestarten': ('bakkestart',),
'bakkestarter': ('bakkestart',),
'bakkestartene': ('bakkestart',),
'bakketjeneste': ('bakketjeneste',),
'bakketjenesten': ('bakketjeneste',),
'bakketjenester': ('bakketjeneste',),
'bakketjenestene': ('bakketjeneste',),
'bakketopp': ('bakketopp',),
'bakketoppen': ('bakketopp',),
'bakketopper': ('bakketopp',),
'bakketoppene': ('bakketopp',),
'bakkropp': ('bakkropp',),
'bakkroppen': ('bakkropp',),
'bakkropper': ('bakkropp',),
'bakkroppene': ('bakkropp',),
'bakksag': ('bakksag',),
'bakksagen': ('bakksag',),
'bakksaga': ('bakksag',),
'bakksager': ('bakksag',),
'bakksagene': ('bakksag',),
'bakkusdyrker': ('bakkusdyrker',),
'bakkusdyrkeren': ('bakkusdyrker',),
'bakkusdyrkere': ('bakkusdyrker',),
'bakkusdyrkerne': ('bakkusdyrker',),
'bakkusfest': ('bakkusfest',),
'bakkusfesten': ('bakkusfest',),
'bakkusfester': ('bakkusfest',),
'bakkusfestene': ('bakkusfest',),
'baklader': ('baklader',),
'bakladeren': ('baklader',),
'bakladere': ('baklader',),
'bakladerne': ('baklader',),
'bakladning': ('bakladning',),
'bakladningen': ('bakladning',),
'bakladninga': ('bakladning',),
'bakladninger': ('bakladning',),
'bakladningene': ('bakladning',),
'bakladningsbørse': ('bakladningsbørse',),
'bakladningsbørsen': ('bakladningsbørse',),
'bakladningsbørsa': ('bakladningsbørse',),
'bakladningsbørser': ('bakladningsbørse',),
'bakladningsbørsene': ('bakladningsbørse',),
'bakladningsgevær': ('bakladningsgevær',),
'bakladningsgeværet': ('bakladningsgevær',),
'bakladningsgevær': ('bakladningsgevær',),
'bakladningsgeværer': ('bakladningsgevær',),
'bakladningsgevær': ('bakladningsgevær',),
'bakladningsgeværer': ('bakladningsgevær',),
'bakladningsgeværa': ('bakladningsgevær',),
'bakladningsgeværene': ('bakladningsgevær',),
'bakladningskanon': ('bakladningskanon',),
'bakladningskanonen': ('bakladningskanon',),
'bakladningskanoner': ('bakladningskanon',),
'bakladningskanonene': ('bakladningskanon',),
'bakladningsvåpen': ('bakladningsvåpen',),
'bakladningsvåpenet': ('bakladningsvåpen',),
'bakladningsvåpen': ('bakladningsvåpen',),
'bakladningsvåpna': ('bakladningsvåpen',),
'bakladningsvåpnene': ('bakladningsvåpen',),
'baklekse': ('baklekse',),
'bakleksen': ('baklekse',),
'bakleksa': ('baklekse',),
'baklekser': ('baklekse',),
'bakleksene': ('baklekse',),
'baklengsmål': ('baklengsmål',),
'baklengsmålet': ('baklengsmål',),
'baklengsmål': ('baklengsmål',),
'baklengsmåla': ('baklengsmål',),
'baklengsmålene': ('baklengsmål',),
'bakli': ('bakli',),
'baklien': ('bakli',),
'baklia': ('bakli',),
'baklier': ('bakli',),
'bakliene': ('bakli',),
'baklomme': ('baklomme',),
'baklommen': ('baklomme',),
'baklomma': ('baklomme',),
'baklommer': ('baklomme',),
'baklommene': ('baklomme',),
'baklys': ('baklys',),
'baklyset': ('baklys',),
'baklys': ('baklys',),
'baklysa': ('baklys',),
'baklysene': ('baklys',),
'baklås': ('baklås',),
'baklåsen': ('baklås',),
'baklåset': ('baklås',),
'baklåser': ('baklås',),
'baklås': ('baklås',),
'baklåser': ('baklås',),
'baklås': ('baklås',),
'baklåser': ('baklås',),
'baklåsene': ('baklås',),
'baklåsa': ('baklås',),
'baklåsene': ('baklås',),
'bakmann': ('bakmann',),
'bakmannen': ('bakmann',),
'bakmenn': ('bakmann',),
'bakmennene': ('bakmann',),
'bakmeis': ('bakmeis',),
'bakmeisen': ('bakmeis',),
'bakmeisa': ('bakmeis',),
'bakmeiser': ('bakmeis',),
'bakmeisene': ('bakmeis',),
'bakol': ('bakol',),
'bakolen': ('bakol',),
'bakoler': ('bakol',),
'bakolene': ('bakol',),
'bakole': ('bakole',),
'bakolen': ('bakole',),
'bakola': ('bakole',),
'bakoler': ('bakole',),
'bakolene': ('bakole',),
'bakpart': ('bakpart',),
'bakparten': ('bakpart',),
'bakparter': ('bakpart',),
'bakpartene': ('bakpart',),
'bakparti': ('bakparti',),
'bakpartiet': ('bakparti',),
'bakparti': ('bakparti',),
'bakpartier': ('bakparti',),
'bakparti': ('bakparti',),
'bakpartier': ('bakparti',),
'bakpartia': ('bakparti',),
'bakpartiene': ('bakparti',),
'bakrom': ('bakrom',),
'bakrommet': ('bakrom',),
'bakrom': ('bakrom',),
'bakromma': ('bakrom',),
'bakrommene': ('bakrom',),
'bakrus': ('bakrus',),
'bakrusen': ('bakrus',),
'bakruser': ('bakrus',),
'bakrusene': ('bakrus',),
'baks': ('baks',),
'baksen': ('baks',),
'bakser': ('baks',),
'baksene': ('baks',),
'baksete': ('baksete',),
'baksetet': ('baksete',),
'bakseter': ('baksete',),
'bakseta': ('baksete',),
'baksetene': ('baksete',),
'bakside': ('bakside',),
'baksiden': ('bakside',),
'baksida': ('bakside',),
'baksider': ('bakside',),
'baksidene': ('bakside',),
'bakskjerm': ('bakskjerm',),
'bakskjermen': ('bakskjerm',),
'bakskjermer': ('bakskjerm',),
'bakskjermene': ('bakskjerm',),
'bakskott': ('bakskott',),
'bakskotten': ('bakskott',),
'bakskotter': ('bakskott',),
'bakskottene': ('bakskott',),
'bakskott': ('bakskott',),
'bakskottet': ('bakskott',),
'bakskott': ('bakskott',),
'bakskotta': ('bakskott',),
'bakskottene': ('bakskott',),
'bakskut': ('bakskut',),
'bakskuten': ('bakskut',),
'bakskuter': ('bakskut',),
'bakskutene': ('bakskut',),
'bakslag': ('bakslag',),
'bakslaget': ('bakslag',),
'bakslag': ('bakslag',),
'bakslaga': ('bakslag',),
'bakslagene': ('bakslag',),
'baksmell': ('baksmell',),
'baksmellen': ('baksmell',),
'baksmeller': ('baksmell',),
'baksmellene': ('baksmell',),
'baksnakk': ('baksnakk',),
'baksnakken': ('baksnakk',),
'baksnakket': ('baksnakk',),
'baksnakker': ('baksnakk',),
'baksnakk': ('baksnakk',),
'baksnakkene': ('baksnakk',),
'baksnakka': ('baksnakk',),
'baksnakkene': ('baksnakk',),
'bakspark': ('bakspark',),
'baksparket': ('bakspark',),
'bakspark': ('bakspark',),
'baksparka': ('bakspark',),
'baksparkene': ('bakspark',),
'bakspeller': ('bakspeller',),
'bakspelleren': ('bakspeller',),
'bakspellere': ('bakspeller',),
'bakspellerne': ('bakspeller',),
'bakspiller': ('bakspiller',),
'bakspilleren': ('bakspiller',),
'bakspillere': ('bakspiller',),
'bakspillerne': ('bakspiller',),
'bakst': ('bakst',),
'baksten': ('bakst',),
'bakster': ('bakst',),
'bakstene': ('bakst',),
'bakstavn': ('bakstavn',),
'bakstavnen': ('bakstavn',),
'bakstavner': ('bakstavn',),
'bakstavnene': ('bakstavn',),
'bakstebord': ('bakstebord',),
'bakstebordet': ('bakstebord',),
'bakstebord': ('bakstebord',),
'baksteborder': ('bakstebord',),
'bakstebord': ('bakstebord',),
'baksteborder': ('bakstebord',),
'baksteborda': ('bakstebord',),
'bakstebordene': ('bakstebord',),
'bakstefjel': ('bakstefjel',),
'bakstefjelen': ('bakstefjel',),
'bakstefjela': ('bakstefjel',),
'bakstefjeler': ('bakstefjel',),
'bakstefjelene': ('bakstefjel',),
'bakstefjøl': ('bakstefjøl',),
'bakstefjølen': ('bakstefjøl',),
'bakstefjøla': ('bakstefjøl',),
'bakstefjøler': ('bakstefjøl',),
'bakstefjølene': ('bakstefjøl',),
'bakstehelle': ('bakstehelle',),
'bakstehellen': ('bakstehelle',),
'bakstehella': ('bakstehelle',),
'baksteheller': ('bakstehelle',),
'bakstehellene': ('bakstehelle',),
'bakstekone': ('bakstekone',),
'bakstekonen': ('bakstekone',),
'bakstekona': ('bakstekone',),
'bakstekoner': ('bakstekone',),
'bakstekonene': ('bakstekone',),
'bakstespade': ('bakstespade',),
'bakstespaden': ('bakstespade',),
'bakstespader': ('bakstespade',),
'bakstespadene': ('bakstespade',),
'bakstrev': ('bakstrev',),
'bakstrevet': ('bakstrev',),
'bakstrev': ('bakstrev',),
'bakstreva': ('bakstrev',),
'bakstrevene': ('bakstrev',),
'bakstrever': ('bakstrever',),
'bakstreveren': ('bakstrever',),
'bakstrevere': ('bakstrever',),
'bakstreverne': ('bakstrever',),
'bakstuss': ('bakstuss',),
'bakstussen': ('bakstuss',),
'bakstusser': ('bakstuss',),
'bakstussene': ('bakstuss',),
'bakstykke': ('bakstykke',),
'bakstykket': ('bakstykke',),
'bakstykker': ('bakstykke',),
'bakstykka': ('bakstykke',),
'bakstykkene': ('bakstykke',),
'baktalelse': ('baktalelse',),
'baktalelsen': ('baktalelse',),
'baktalelser': ('baktalelse',),
'baktalelsene': ('baktalelse',),
'baktanke': ('baktanke',),
'baktanken': ('baktanke',),
'baktanker': ('baktanke',),
'baktankene': ('baktanke',),
'baktericid': ('baktericid',),
'baktericidet': ('baktericid',),
'baktericid': ('baktericid',),
'baktericider': ('baktericid',),
'baktericid': ('baktericid',),
'baktericider': ('baktericid',),
'baktericida': ('baktericid',),
'baktericidene': ('baktericid',),
'bakterie': ('bakterie',),
'bakterien': ('bakterie',),
'bakterier': ('bakterie',),
'bakteriene': ('bakterie',),
'bakterieflora': ('bakterieflora',),
'bakteriefloraen': ('bakterieflora',),
'bakteriefloraer': ('bakterieflora',),
'bakteriefloraene': ('bakterieflora',),
'bakteriekoloni': ('bakteriekoloni',),
'bakteriekolonien': ('bakteriekoloni',),
'bakteriekolonier': ('bakteriekoloni',),
'bakteriekoloniene': ('bakteriekoloni',),
'bakteriekultur': ('bakteriekultur',),
'bakteriekulturen': ('bakteriekultur',),
'bakteriekulturer': ('bakteriekultur',),
'bakteriekulturene': ('bakteriekultur',),
'bakteriesjukdom': ('bakteriesjukdom',),
'bakteriesjukdommen': ('bakteriesjukdom',),
'bakteriesjukdommer': ('bakteriesjukdom',),
'bakteriesjukdommene': ('bakteriesjukdom',),
'bakteriesykdom': ('bakteriesykdom',),
'bakteriesykdommen': ('bakteriesykdom',),
'bakteriesykdommer': ('bakteriesykdom',),
'bakteriesykdommene': ('bakteriesykdom',),
'bakteriofag': ('bakteriofag',),
'bakteriofagen': ('bakteriofag',),
'bakteriofager': ('bakteriofag',),
'bakteriofagene': ('bakteriofag',),
'bakteriolog': ('bakteriolog',),
'bakteriologen': ('bakteriolog',),
'bakteriologer': ('bakteriolog',),
'bakteriologene': ('bakteriolog',),
'bakteriologi': ('bakteriologi',),
'bakteriologien': ('bakteriologi',),
'bakteriologier': ('bakteriologi',),
'bakteriologiene': ('bakteriologi',),
'baktofte': ('baktofte',),
'baktoften': ('baktofte',),
'baktofta': ('baktofte',),
'baktofter': ('baktofte',),
'baktoftene': ('baktofte',),
'baktrapp': ('baktrapp',),
'baktrappen': ('baktrapp',),
'baktrappa': ('baktrapp',),
'baktrapper': ('baktrapp',),
'baktrappene': ('baktrapp',),
'baktropp': ('baktropp',),
'baktroppen': ('baktropp',),
'baktropper': ('baktropp',),
'baktroppene': ('baktropp',),
'baktunge': ('baktunge',),
'baktungen': ('baktunge',),
'baktunga': ('baktunge',),
'baktunger': ('baktunge',),
'baktungene': ('baktunge',),
'baktungelyd': ('baktungelyd',),
'baktungelyden': ('baktungelyd',),
'baktungelyder': ('baktungelyd',),
'baktungelydene': ('baktungelyd',),
'bakvaskelse': ('bakvaskelse',),
'bakvaskelsen': ('bakvaskelse',),
'bakvaskelser': ('bakvaskelse',),
'bakvaskelsene': ('bakvaskelse',),
'bakvasking': ('bakvasking',),
'bakvaskingen': ('bakvasking',),
'bakvaskinga': ('bakvasking',),
'bakvaskinger': ('bakvasking',),
'bakvaskingene': ('bakvasking',),
'bakveg': ('bakveg',),
'bakvegen': ('bakveg',),
'bakveger': ('bakveg',),
'bakvegene': ('bakveg',),
'bakvei': ('bakvei',),
'bakveien': ('bakvei',),
'bakveier': ('bakvei',),
'bakveiene': ('bakvei',),
'bakverk': ('bakverk',),
'bakverket': ('bakverk',),
'bakverk': ('bakverk',),
'bakverka': ('bakverk',),
'bakverkene': ('bakverk',),
'bal': ('bal',),
'balet': ('bal',),
'bal': ('bal',),
'bala': ('bal',),
'balene': ('bal',),
'balalaika': ('balalaika',),
'balalaikaen': ('balalaika',),
'balalaikaer': ('balalaika',),
'balalaikaene': ('balalaika',),
'balalaikamusikk': ('balalaikamusikk',),
'balalaikamusikken': ('balalaikamusikk',),
'balalaikamusikker': ('balalaikamusikk',),
'balalaikamusikkene': ('balalaikamusikk',),
'balalaikaorkester': ('balalaikaorkester',),
'balalaikaorkesteret': ('balalaikaorkester',),
'balalaikaorkestret': ('balalaikaorkester',),
'balalaikaorkester': ('balalaikaorkester',),
'balalaikaorkestre': ('balalaikaorkester',),
'balalaikaorkestra': ('balalaikaorkester',),
'balalaikaorkestrene': ('balalaikaorkester',),
'balalaikaorkestra': ('balalaikaorkester',),
'balalaikaorkestrene': ('balalaikaorkester',),
'balanse': ('balanse',),
'balansen': ('balanse',),
'balanser': ('balanse',),
'balansene': ('balanse',),
'balansegang': ('balansegang',),
'balansegangen': ('balansegang',),
'balanseganger': ('balansegang',),
'balansegangene': ('balansegang',),
'balansehjul': ('balansehjul',),
'balansehjulet': ('balansehjul',),
'balansehjul': ('balansehjul',),
'balansehjula': ('balansehjul',),
'balansehjulene': ('balansehjul',),
'balansekonto': ('balansekonto',),
'balansekontoen': ('balansekonto',),
'balansekontoer': ('balansekonto',),
'balansekonti': ('balansekonto',),
'balansekontoene': ('balansekonto',),
'balansekontiene': ('balansekonto',),
'balansekunst': ('balansekunst',),
'balansekunsten': ('balansekunst',),
'balansekunster': ('balansekunst',),
'balansekunstene': ('balansekunst',),
'balansekunstner': ('balansekunstner',),
'balansekunstneren': ('balansekunstner',),
'balansekunstnere': ('balansekunstner',),
'balansekunstnerne': ('balansekunstner',),
'balansepunkt': ('balansepunkt',),
'balansepunktet': ('balansepunkt',),
'balansepunkt': ('balansepunkt',),
'balansepunkter': ('balansepunkt',),
'balansepunkt': ('balansepunkt',),
'balansepunkter': ('balansepunkt',),
'balansepunkta': ('balansepunkt',),
'balansepunktene': ('balansepunkt',),
'balanseror': ('balanseror',),
'balanseroret': ('balanseror',),
'balanseror': ('balanseror',),
'balanserora': ('balanseror',),
'balanserorene': ('balanseror',),
'balansestang': ('balansestang',),
'balansestangen': ('balansestang',),
'balansestanga': ('balansestang',),
'balansestenger': ('balansestang',),
'balansestengene': ('balansestang',),
'baldakin': ('baldakin',),
'baldakinen': ('baldakin',),
'baldakiner': ('baldakin',),
'baldakinene': ('baldakin',),
'balderbrå': ('balderbrå',),
'balderbråen': ('balderbrå',),
'balderbråa': ('balderbrå',),
'balderbråer': ('balderbrå',),
'balderbråene': ('balderbrå',),
'baldrian': ('baldrian',),
'baldrianen': ('baldrian',),
'baldrianer': ('baldrian',),
'baldrianene': ('baldrian',),
'balineser': ('balineser',),
'balineseren': ('balineser',),
'balinesere': ('balineser',),
'balineserne': ('balineser',),
'balje': ('balje',),
'baljen': ('balje',),
'balja': ('balje',),
'baljer': ('balje',),
'baljene': ('balje',),
'balkong': ('balkong',),
'balkongen': ('balkong',),
'balkonger': ('balkong',),
'balkongene': ('balkong',),
'balkongkasse': ('balkongkasse',),
'balkongkassen': ('balkongkasse',),
'balkongkassa': ('balkongkasse',),
'balkongkasser': ('balkongkasse',),
'balkongkassene': ('balkongkasse',),
'ball': ('ball',),
'ballen': ('ball',),
'baller': ('ball',),
'ballene': ('ball',),
'ball': ('ball',),
'ballet': ('ball',),
'ball': ('ball',),
'baller': ('ball',),
'ball': ('ball',),
'baller': ('ball',),
'balla': ('ball',),
'ballene': ('ball',),
'ballade': ('ballade',),
'balladen': ('ballade',),
'ballader': ('ballade',),
'balladene': ('ballade',),
'ballast': ('ballast',),
'ballasten': ('ballast',),
'ballaster': ('ballast',),
'ballastene': ('ballast',),
'ballastjern': ('ballastjern',),
'ballastjernet': ('ballastjern',),
'ballastjern': ('ballastjern',),
'ballastjerna': ('ballastjern',),
'ballastjernene': ('ballastjern',),
'ballasttank': ('ballasttank',),
'ballasttanken': ('ballasttank',),
'ballasttanker': ('ballasttank',),
'ballasttankene': ('ballasttank',),
'ballblom': ('ballblom',),
'ballblommen': ('ballblom',),
'ballblommer': ('ballblom',),
'ballblommene': ('ballblom',),
'balle': ('balle',),
'ballen': ('balle',),
'baller': ('balle',),
'ballene': ('balle',),
'ballerina': ('ballerina',),
'ballerinaen': ('ballerina',),
'ballerinaer': ('ballerina',),
'ballerinaene': ('ballerina',),
'ballett': ('ballett',),
'balletten': ('ballett',),
'balletter': ('ballett',),
'ballettene': ('ballett',),
'ballettmester': ('ballettmester',),
'ballettmesteren': ('ballettmester',),
'ballettmestere': ('ballettmester',),
'ballettmestrer': ('ballettmester',),
'ballettmestre': ('ballettmester',),
'ballettmesterne': ('ballettmester',),
'ballettmestrene': ('ballettmester',),
'ballettmusikk': ('ballettmusikk',),
'ballettmusikken': ('ballettmusikk',),
'ballettmusikker': ('ballettmusikk',),
'ballettmusikkene': ('ballettmusikk',),
'ballist': ('ballist',),
'ballisten': ('ballist',),
'ballister': ('ballist',),
'ballistene': ('ballist',),
'ballistikk': ('ballistikk',),
'ballistikken': ('ballistikk',),
'ballistikker': ('ballistikk',),
'ballistikkene': ('ballistikk',),
'ballkjole': ('ballkjole',),
'ballkjolen': ('ballkjole',),
'ballkjoler': ('ballkjole',),
'ballkjolene': ('ballkjole',),
'ballong': ('ballong',),
'ballongen': ('ballong',),
'ballonger': ('ballong',),
'ballongene': ('ballong',),
'ballongbukse': ('ballongbukse',),
'ballongbuksen': ('ballongbukse',),
'ballongbuksa': ('ballongbukse',),
'ballongbukser': ('ballongbukse',),
'ballongbuksene': ('ballongbukse',),
'ballongdekk': ('ballongdekk',),
'ballongdekket': ('ballongdekk',),
'ballongdekk': ('ballongdekk',),
'ballongdekka': ('ballongdekk',),
'ballongdekkene': ('ballongdekk',),
'ballongferd': ('ballongferd',),
'ballongferden': ('ballongferd',),
'ballongferda': ('ballongferd',),
'ballongferder': ('ballongferd',),
'ballongferdene': ('ballongferd',),
'ballongform': ('ballongform',),
'ballongformen': ('ballongform',),
'ballongforma': ('ballongform',),
'ballongformer': ('ballongform',),
'ballongformene': ('ballongform',),
'ballongkorg': ('ballongkorg',),
'ballongkorgen': ('ballongkorg',),
'ballongkorga': ('ballongkorg',),
'ballongkorger': ('ballongkorg',),
'ballongkorgene': ('ballongkorg',),
'ballongkurv': ('ballongkurv',),
'ballongkurven': ('ballongkurv',),
'ballongkurva': ('ballongkurv',),
'ballongkurver': ('ballongkurv',),
'ballongkurvene': ('ballongkurv',),
'balloptikon': ('balloptikon',),
'balloptikonet': ('balloptikon',),
'balloptikon': ('balloptikon',),
'balloptikoner': ('balloptikon',),
'balloptikon': ('balloptikon',),
'balloptikoner': ('balloptikon',),
'balloptikona': ('balloptikon',),
'balloptikonene': ('balloptikon',),
'ballsal': ('ballsal',),
'ballsalen': ('ballsal',),
'ballsaler': ('ballsal',),
'ballsalene': ('ballsal',),
'ballspell': ('ballspell',),
'ballspellet': ('ballspell',),
'ballspell': ('ballspell',),
'ballspella': ('ballspell',),
'ballspellene': ('ballspell',),
'ballspill': ('ballspill',),
'ballspillet': ('ballspill',),
'ballspill': ('ballspill',),
'ballspilla': ('ballspill',),
'ballspillene': ('ballspill',),
'balsa': ('balsa',),
'balsaen': ('balsa',),
'balsaer': ('balsa',),
'balsaene': ('balsa',),
'balsaflåte': ('balsaflåte',),
'balsaflåten': ('balsaflåte',),
'balsaflåter': ('balsaflåte',),
'balsaflåtene': ('balsaflåte',),
'balsam': ('balsam',),
'balsamen': ('balsam',),
'balsamer': ('balsam',),
'balsamene': ('balsam',),
'balsamduft': ('balsamduft',),
'balsamduften': ('balsamduft',),
'balsamdufter': ('balsamduft',),
'balsamduftene': ('balsamduft',),
'balsamgran': ('balsamgran',),
'balsamgranen': ('balsamgran',),
'balsamgrana': ('balsamgran',),
'balsamgraner': ('balsamgran',),
'balsamgranene': ('balsamgran',),
'balsampoppel': ('balsampoppel',),
'balsampoppelen': ('balsampoppel',),
'balsampopler': ('balsampoppel',),
'balsampoplene': ('balsampoppel',),
'balsamtre': ('balsamtre',),
'balsamtreet': ('balsamtre',),
'balsamtre': ('balsamtre',),
'balsamtrær': ('balsamtre',),
'balsamtrea': ('balsamtre',),
'balsamtrærne': ('balsamtre',),
'balsatre': ('balsatre',),
'balsatreet': ('balsatre',),
'balsatre': ('balsatre',),
'balsatrær': ('balsatre',),
'balsatrea': ('balsatre',),
'balsatrærne': ('balsatre',),
'balter': ('balter',),
'balteren': ('balter',),
'baltere': ('balter',),
'balterne': ('balter',),
'baluster': ('baluster',),
'balusteren': ('baluster',),
'balustere': ('baluster',),
'balustrer': ('baluster',),
'balustre': ('baluster',),
'balusterne': ('baluster',),
'balustrene': ('baluster',),
'balustrade': ('balustrade',),
'balustraden': ('balustrade',),
'balustrader': ('balustrade',),
'balustradene': ('balustrade',),
'bamblesjuke': ('bamblesjuke',),
'bamblesjuken': ('bamblesjuke',),
'bamblesjuker': ('bamblesjuke',),
'bamblesjukene': ('bamblesjuke',),
'bamblesyke': ('bamblesyke',),
'bamblesyken': ('bamblesyke',),
'bamblesyker': ('bamblesyke',),
'bamblesykene': ('bamblesyke',),
'bambus': ('bambus',),
'bambusen': ('bambus',),
'bambuser': ('bambus',),
'bambusene': ('bambus',),
'bambusbjørn': ('bambusbjørn',),
'bambusbjørnen': ('bambusbjørn',),
'bambusbjørner': ('bambusbjørn',),
'bambusbjørnene': ('bambusbjørn',),
'bambusrør': ('bambusrør',),
'bambusrøret': ('bambusrør',),
'bambusrør': ('bambusrør',),
'bambusrøra': ('bambusrør',),
'bambusrørene': ('bambusrør',),
'bambusskott': ('bambusskott',),
'bambusskottet': ('bambusskott',),
'bambusskott': ('bambusskott',),
'bambusskotta': ('bambusskott',),
'bambusskottene': ('bambusskott',),
'bambusskudd': ('bambusskudd',),
'bambusskuddet': ('bambusskudd',),
'bambusskudd': ('bambusskudd',),
'bambusskudda': ('bambusskudd',),
'bambusskuddene': ('bambusskudd',),
'bambusteppe': ('bambusteppe',),
'bambusteppet': ('bambusteppe',),
'bambustepper': ('bambusteppe',),
'bambusteppa': ('bambusteppe',),
'bambusteppene': ('bambusteppe',),
'bamse': ('bamse',),
'bamsen': ('bamse',),
'bamser': ('bamse',),
'bamsene': ('bamse',),
'banalitet': ('banalitet',),
'banaliteten': ('banalitet',),
'banaliteter': ('banalitet',),
'banalitetene': ('banalitet',),
'banan': ('banan',),
'bananen': ('banan',),
'bananer': ('banan',),
'bananene': ('banan',),
'bananflue': ('bananflue',),
'bananfluen': ('bananflue',),
'bananflua': ('bananflue',),
'bananfluer': ('bananflue',),
'bananfluene': ('bananflue',),
'bananmodneri': ('bananmodneri',),
'bananmodneriet': ('bananmodneri',),
'bananmodneri': ('bananmodneri',),
'bananmodnerier': ('bananmodneri',),
'bananmodneri': ('bananmodneri',),
'bananmodnerier': ('bananmodneri',),
'bananmodneria': ('bananmodneri',),
'bananmodneriene': ('bananmodneri',),
'bananplantasje': ('bananplantasje',),
'bananplantasjen': ('bananplantasje',),
'bananplantasjer': ('bananplantasje',),
'bananplantasjene': ('bananplantasje',),
'bananplante': ('bananplante',),
'bananplanten': ('bananplante',),
'bananplanta': ('bananplante',),
'bananplanter': ('bananplante',),
'bananplantene': ('bananplante',),
'bananplugg': ('bananplugg',),
'bananpluggen': ('bananplugg',),
'bananplugger': ('bananplugg',),
'bananpluggene': ('bananplugg',),
'bananrepublikk': ('bananrepublikk',),
'bananrepublikken': ('bananrepublikk',),
'bananrepublikker': ('bananrepublikk',),
'bananrepublikkene': ('bananrepublikk',),
'bananskall': ('bananskall',),
'bananskallet': ('bananskall',),
'bananskall': ('bananskall',),
'bananskalla': ('bananskall',),
'bananskallene': ('bananskall',),
'banansplitt': ('banansplitt',),
'banansplitten': ('banansplitt',),
'banansplitter': ('banansplitt',),
'banansplittene': ('banansplitt',),
'bananstikker': ('bananstikker',),
'bananstikkeren': ('bananstikker',),
'bananstikkere': ('bananstikker',),
'bananstikkerne': ('bananstikker',),
'band': ('band',),
'bandet': ('band',),
'band': ('band',),
'banda': ('band',),
'bandene': ('band',),
'bandasje': ('bandasje',),
'bandasjen': ('bandasje',),
'bandasjer': ('bandasje',),
'bandasjene': ('bandasje',),
'bandasjist': ('bandasjist',),
'bandasjisten': ('bandasjist',),
'bandasjister': ('bandasjist',),
'bandasjistene': ('bandasjist',),
'bandby': ('bandby',),
'bandbyen': ('bandby',),
'bandbyer': ('bandby',),
'bandbyene': ('bandby',),
'bande': ('bande',),
'banden': ('bande',),
'bander': ('bande',),
'bandene': ('bande',),
'bandefører': ('bandefører',),
'bandeføreren': ('bandefører',),
'bandeførere': ('bandefører',),
'bandeførerne': ('bandefører',),
'bandemedlem': ('bandemedlem',),
'bandemedlemmet': ('bandemedlem',),
'bandemedlemmer': ('bandemedlem',),
'bandemedlemma': ('bandemedlem',),
'bandemedlemmene': ('bandemedlem',),
'bandhund': ('bandhund',),
'bandhunden': ('bandhund',),
'bandhunder': ('bandhund',),
'bandhundene': ('bandhund',),
'banditt': ('banditt',),
'banditten': ('banditt',),
'banditter': ('banditt',),
'bandittene': ('banditt',),
'bandjern': ('bandjern',),
'bandjernet': ('bandjern',),
'bandjern': ('bandjern',),
'bandjerna': ('bandjern',),
'bandjernene': ('bandjern',),
'bandkniv': ('bandkniv',),
'bandkniven': ('bandkniv',),
'bandkniver': ('bandkniv',),
'bandknivene': ('bandkniv',),
'bandolær': ('bandolær',),
'bandolæret': ('bandolær',),
'bandolær': ('bandolær',),
'bandolærer': ('bandolær',),
'bandolær': ('bandolær',),
'bandolærer': ('bandolær',),
'bandolæra': ('bandolær',),
'bandolærene': ('bandolær',),
'bandopptaker': ('bandopptaker',),
'bandopptakeren': ('bandopptaker',),
'bandopptakere': ('bandopptaker',),
'bandopptakerne': ('bandopptaker',),
'bandsalat': ('bandsalat',),
'bandsalaten': ('bandsalat',),
'bandsalater': ('bandsalat',),
'bandsalatene': ('bandsalat',),
'bandspeller': ('bandspeller',),
'bandspelleren': ('bandspeller',),
'bandspellere': ('bandspeller',),
'bandspellerne': ('bandspeller',),
'bandspiller': ('bandspiller',),
'bandspilleren': ('bandspiller',),
'bandspillere': ('bandspiller',),
'bandspillerne': ('bandspiller',),
'bandstokk': ('bandstokk',),
'bandstokken': ('bandstokk',),
'bandstokker': ('bandstokk',),
'bandstokkene': ('bandstokk',),
'bandstål': ('bandstål',),
'bandstålet': ('bandstål',),
'bandstål': ('bandstål',),
'bandståla': ('bandstål',),
'bandstålene': ('bandstål',),
'bandtvang': ('bandtvang',),
'bandtvangen': ('bandtvang',),
'bandtvanger': ('bandtvang',),
'bandtvangene': ('bandtvang',),
'bandy': ('bandy',),
'bandyen': ('bandy',),
'bandyer': ('bandy',),
'bandyene': ('bandy',),
'bandyball': ('bandyball',),
'bandyballen': ('bandyball',),
'bandyballer': ('bandyball',),
'bandyballene': ('bandyball',),
'bandykølle': ('bandykølle',),
'bandykøllen': ('bandykølle',),
'bandykølla': ('bandykølle',),
'bandykøller': ('bandykølle',),
'bandykøllene': ('bandykølle',),
'bandylag': ('bandylag',),
'bandylaget': ('bandylag',),
'bandylag': ('bandylag',),
'bandylaga': ('bandylag',),
'bandylagene': ('bandylag',),
'banebryter': ('banebryter',),
'banebryteren': ('banebryter',),
'banebrytere': ('banebryter',),
'banebryterne': ('banebryter',),
'banefunksjonær': ('banefunksjonær',),
'banefunksjonæren': ('banefunksjonær',),
'banefunksjonærer': ('banefunksjonær',),
'banefunksjonærene': ('banefunksjonær',),
'banehalvdel': ('banehalvdel',),
'banehalvdelen': ('banehalvdel',),
'banehalvdeler': ('banehalvdel',),
'banehalvdelene': ('banehalvdel',),
'banehogg': ('banehogg',),
'banehogget': ('banehogg',),
'banehogg': ('banehogg',),
'banehogga': ('banehogg',),
'banehoggene': ('banehogg',),
'banehugg': ('banehugg',),
'banehugget': ('banehugg',),
'banehugg': ('banehugg',),
'banehugga': ('banehugg',),
'banehuggene': ('banehugg',),
'banelegeme': ('banelegeme',),
'banelegemet': ('banelegeme',),
'banelegemer': ('banelegeme',),
'banelegema': ('banelegeme',),
'banelegemene': ('banelegeme',),
'banemann': ('banemann',),
'banemannen': ('banemann',),
'banemenn': ('banemann',),
'banemennene': ('banemann',),
'banemannskap': ('banemannskap',),
'banemannskapet': ('banemannskap',),
'banemannskap': ('banemannskap',),
'banemannskaper': ('banemannskap',),
'banemannskap': ('banemannskap',),
'banemannskaper': ('banemannskap',),
'banemannskapa': ('banemannskap',),
'banemannskapene': ('banemannskap',),
'banemester': ('banemester',),
'banemesteren': ('banemester',),
'banemestere': ('banemester',),
'banemestrer': ('banemester',),
'banemestre': ('banemester',),
'banemesterne': ('banemester',),
'banemestrene': ('banemester',),
'banerekord': ('banerekord',),
'banerekorden': ('banerekord',),
'banerekorder': ('banerekord',),
'banerekordene': ('banerekord',),
'banesår': ('banesår',),
'banesåret': ('banesår',),
'banesår': ('banesår',),
'banesåra': ('banesår',),
'banesårene': ('banesår',),
'banevokter': ('banevokter',),
'banevokteren': ('banevokter',),
'banevoktere': ('banevokter',),
'banevokterne': ('banevokter',),
'bangladesher': ('bangladesher',),
'bangladesheren': ('bangladesher',),
'bangladeshere': ('bangladesher',),
'bangladesherne': ('bangladesher',),
'banjer': ('banjer',),
'banjeren': ('banjer',),
'banjere': ('banjer',),
'banjerne': ('banjer',),
'banjerdekk': ('banjerdekk',),
'banjerdekket': ('banjerdekk',),
'banjerdekk': ('banjerdekk',),
'banjerdekka': ('banjerdekk',),
'banjerdekkene': ('banjerdekk',),
'banjo': ('banjo',),
'banjoen': ('banjo',),
'banjoer': ('banjo',),
'banjoene': ('banjo',),
'banjospell': ('banjospell',),
'banjospellet': ('banjospell',),
'banjospell': ('banjospell',),
'banjospella': ('banjospell',),
'banjospellene': ('banjospell',),
'banjospeller': ('banjospeller',),
'banjospelleren': ('banjospeller',),
'banjospellere': ('banjospeller',),
'banjospellerne': ('banjospeller',),
'banjospill': ('banjospill',),
'banjospillet': ('banjospill',),
'banjospill': ('banjospill',),
'banjospilla': ('banjospill',),
'banjospillene': ('banjospill',),
'banjospiller': ('banjospiller',),
'banjospilleren': ('banjospiller',),
'banjospillere': ('banjospiller',),
'banjospillerne': ('banjospiller',),
'bank': ('bank',),
'banket': ('bank',),
'bank': ('bank',),
'banka': ('bank',),
'bankene': ('bank',),
'bankaksept': ('bankaksept',),
'bankaksepten': ('bankaksept',),
'bankaksepter': ('bankaksept',),
'bankakseptene': ('bankaksept',),
'bankautomat': ('bankautomat',),
'bankautomaten': ('bankautomat',),
'bankautomater': ('bankautomat',),
'bankautomatene': ('bankautomat',),
'bankboks': ('bankboks',),
'bankboksen': ('bankboks',),
'bankbokser': ('bankboks',),
'bankboksene': ('bankboks',),
'bankdireksjon': ('bankdireksjon',),
'bankdireksjonen': ('bankdireksjon',),
'bankdireksjoner': ('bankdireksjon',),
'bankdireksjonene': ('bankdireksjon',),
'bankdirektør': ('bankdirektør',),
'bankdirektøren': ('bankdirektør',),
'bankdirektører': ('bankdirektør',),
'bankdirektørene': ('bankdirektør',),
'banke': ('banke',),
'banken': ('banke',),
'banker': ('banke',),
'bankene': ('banke',),
'bankebiff': ('bankebiff',),
'bankebiffen': ('bankebiff',),
'bankebiffer': ('bankebiff',),
'bankebiffene': ('bankebiff',),
'bankefasthet': ('bankefasthet',),
'bankefastheten': ('bankefasthet',),
'bankefastheta': ('bankefasthet',),
'bankefastheter': ('bankefasthet',),
'bankefasthetene': ('bankefasthet',),
'bankefisk': ('bankefisk',),
'bankefisken': ('bankefisk',),
'bankefisker': ('bankefisk',),
'bankefiskene': ('bankefisk',),
'bankefiske': ('bankefiske',),
'bankefisket': ('bankefiske',),
'bankefisker': ('bankefiske',),
'bankefiska': ('bankefiske',),
'bankefiskene': ('bankefiske',),
'bankefisker': ('bankefisker',),
'bankefiskeren': ('bankefisker',),
'bankefiskere': ('bankefisker',),
'bankefiskerne': ('bankefisker',),
'bankekjøtt': ('bankekjøtt',),
'bankekjøttet': ('bankekjøtt',),
'bankekjøtt': ('bankekjøtt',),
'bankekjøtta': ('bankekjøtt',),
'bankekjøttene': ('bankekjøtt',),
'bankemat': ('bankemat',),
'bankematen': ('bankemat',),
'bankemater': ('bankemat',),
'bankematene': ('bankemat',),
'banker': ('banker',),
'bankeren': ('banker',),
'bankere': ('banker',),
'bankerne': ('banker',),
'bankerott': ('bankerott',),
'bankerotten': ('bankerott',),
'bankerotter': ('bankerott',),
'bankerottene': ('bankerott',),
'banketre': ('banketre',),
'banketreet': ('banketre',),
'banketre': ('banketre',),
'banketrær': ('banketre',),
'banketrea': ('banketre',),
'banketrærne': ('banketre',),
'bankett': ('bankett',),
'banketten': ('bankett',),
'banketter': ('bankett',),
'bankettene': ('bankett',),
'bankfilial': ('bankfilial',),
'bankfilialen': ('bankfilial',),
'bankfilialer': ('bankfilial',),
'bankfilialene': ('bankfilial',),
'bankfiske': ('bankfiske',),
'bankfisket': ('bankfiske',),
'bankfisker': ('bankfiske',),
'bankfiska': ('bankfiske',),
'bankfiskene': ('bankfiske',),
'bankfisker': ('bankfisker',),
'bankfiskeren': ('bankfisker',),
'bankfiskere': ('bankfisker',),
'bankfiskerne': ('bankfisker',),
'bankforbindelse': ('bankforbindelse',),
'bankforbindelsen': ('bankforbindelse',),
'bankforbindelser': ('bankforbindelse',),
'bankforbindelsene': ('bankforbindelse',),
'bankfunksjonær': ('bankfunksjonær',),
'bankfunksjonæren': ('bankfunksjonær',),
'bankfunksjonærer': ('bankfunksjonær',),
'bankfunksjonærene': ('bankfunksjonær',),
'bankgiro': ('bankgiro',),
'bankgiroen': ('bankgiro',),
'bankgiroer': ('bankgiro',),
'bankgiroene': ('bankgiro',),
'bankgirokonto': ('bankgirokonto',),
'bankgirokontoen': ('bankgirokonto',),
'bankgirokontoer': ('bankgirokonto',),
'bankgirokonti': ('bankgirokonto',),
'bankgirokontoene': ('bankgirokonto',),
'bankgirokontiene': ('bankgirokonto',),
'bankgjeld': ('bankgjeld',),
'bankgjelden': ('bankgjeld',),
'bankgjelda': ('bankgjeld',),
'bankgjelder': ('bankgjeld',),
'bankgjeldene': ('bankgjeld',),
'bankhvelv': ('bankhvelv',),
'bankhvelvet': ('bankhvelv',),
'bankhvelv': ('bankhvelv',),
'bankhvelva': ('bankhvelv',),
'bankhvelvene': ('bankhvelv',),
'bankier': ('bankier',),
'bankieren': ('bankier',),
'bankierer': ('bankier',),
'bankierene': ('bankier',),
'bankierfirma': ('bankierfirma',),
'bankierfirmaet': ('bankierfirma',),
'bankierfirma': ('bankierfirma',),
'bankierfirmaer': ('bankierfirma',),
'bankierfirmaene': ('bankierfirma',),
'bankierprovisjon': ('bankierprovisjon',),
'bankierprovisjonen': ('bankierprovisjon',),
'bankierprovisjoner': ('bankierprovisjon',),
'bankierprovisjonene': ('bankierprovisjon',),
'bankinnskott': ('bankinnskott',),
'bankinnskottet': ('bankinnskott',),
'bankinnskott': ('bankinnskott',),
'bankinnskotta': ('bankinnskott',),
'bankinnskottene': ('bankinnskott',),
'bankinnskudd': ('bankinnskudd',),
'bankinnskuddet': ('bankinnskudd',),
'bankinnskudd': ('bankinnskudd',),
'bankinnskudda': ('bankinnskudd',),
'bankinnskuddene': ('bankinnskudd',),
'bankinspeksjon': ('bankinspeksjon',),
'bankinspeksjonen': ('bankinspeksjon',),
'bankinspeksjoner': ('bankinspeksjon',),
'bankinspeksjonene': ('bankinspeksjon',),
'bankkasserer': ('bankkasserer',),
'bankkassereren': ('bankkasserer',),
'bankkasserere': ('bankkasserer',),
'bankkassererne': ('bankkasserer',),
'bankkonto': ('bankkonto',),
'bankkontoen': ('bankkonto',),
'bankkontoer': ('bankkonto',),
'bankkonti': ('bankkonto',),
'bankkontoene': ('bankkonto',),
'bankkontiene': ('bankkonto',),
'bankkreditt': ('bankkreditt',),
'bankkreditten': ('bankkreditt',),
'bankkreditter': ('bankkreditt',),
'bankkredittene': ('bankkreditt',),
'bankkunde': ('bankkunde',),
'bankkunden': ('bankkunde',),
'bankkunder': ('bankkunde',),
'bankkundene': ('bankkunde',),
'banklån': ('banklån',),
'banklånet': ('banklån',),
'banklån': ('banklån',),
'banklåna': ('banklån',),
'banklånene': ('banklån',),
'banko': ('banko',),
'bankoen': ('banko',),
'bankoer': ('banko',),
'bankoene': ('banko',),
'bankobrev': ('bankobrev',),
'bankobrevet': ('bankobrev',),
'bankobrev': ('bankobrev',),
'bankobrever': ('bankobrev',),
'bankobrev': ('bankobrev',),
'bankobrever': ('bankobrev',),
'bankobreva': ('bankobrev',),
'bankobrevene': ('bankobrev',),
'bankokonvolutt': ('bankokonvolutt',),
'bankokonvolutten': ('bankokonvolutt',),
'bankokonvolutter': ('bankokonvolutt',),
'bankokonvoluttene': ('bankokonvolutt',),
'bankopost': ('bankopost',),
'bankoposten': ('bankopost',),
'bankoposter': ('bankopost',),
'bankopostene': ('bankopost',),
'bankoverføring': ('bankoverføring',),
'bankoverføringen': ('bankoverføring',),
'bankoverføringa': ('bankoverføring',),
'bankoverføringer': ('bankoverføring',),
'bankoverføringene': ('bankoverføring',),
'bankpolitikk': ('bankpolitikk',),
'bankpolitikken': ('bankpolitikk',),
'bankpolitikker': ('bankpolitikk',),
'bankpolitikkene': ('bankpolitikk',),
'bankran': ('bankran',),
'bankranet': ('bankran',),
'bankran': ('bankran',),
'bankrana': ('bankran',),
'bankranene': ('bankran',),
'bankremisse': ('bankremisse',),
'bankremissen': ('bankremisse',),
'bankremisser': ('bankremisse',),
'bankremissene': ('bankremisse',),
'bankør': ('bankør',),
'bankøren': ('bankør',),
'bankører': ('bankør',),
'bankørene': ('bankør',),
'bann': ('bann',),
'bannet': ('bann',),
'bann': ('bann',),
'banna': ('bann',),
'bannene': ('bann',),
'bannbrev': ('bannbrev',),
'bannbrevet': ('bannbrev',),
'bannbrev': ('bannbrev',),
'bannbrever': ('bannbrev',),
'bannbrev': ('bannbrev',),
'bannbrever': ('bannbrev',),
'bannbreva': ('bannbrev',),
'bannbrevene': ('bannbrev',),
'bannbulle': ('bannbulle',),
'bannbullen': ('bannbulle',),
'bannbuller': ('bannbulle',),
'bannbullene': ('bannbulle',),
'banneord': ('banneord',),
'banneordet': ('banneord',),
'banneord': ('banneord',),
'banneorda': ('banneord',),
'banneordene': ('banneord',),
'banner': ('banner',),
'banneret': ('banner',),
'banner': ('banner',),
'bannere': ('banner',),
'bannera': ('banner',),
'bannerne': ('banner',),
'bannera': ('banner',),
'bannerne': ('banner',),
'bannerbærer': ('bannerbærer',),
'bannerbæreren': ('bannerbærer',),
'bannerbærere': ('bannerbærer',),
'bannerbærerne': ('bannerbærer',),
'bannerfører': ('bannerfører',),
'bannerføreren': ('bannerfører',),
'bannerførere': ('bannerfører',),
'bannerførerne': ('bannerfører',),
'banning': ('banning',),
'banningen': ('banning',),
'banninga': ('banning',),
'banninger': ('banning',),
'banningene': ('banning',),
'bannlysing': ('bannlysing',),
'bannlysingen': ('bannlysing',),
'bannlysinga': ('bannlysing',),
'bannlysinger': ('bannlysing',),
'bannlysingene': ('bannlysing',),
'bannskap': ('bannskap',),
'bannskapen': ('bannskap',),
'bannskaper': ('bannskap',),
'bannskapene': ('bannskap',),
'bannstråle': ('bannstråle',),
'bannstrålen': ('bannstråle',),
'bannstråler': ('bannstråle',),
'bannstrålene': ('bannstråle',),
'bantamer': ('bantamer',),
'bantameren': ('bantamer',),
'bantamere': ('bantamer',),
'bantamerne': ('bantamer',),
'bantamhøns': ('bantamhøns',),
'bantamhønsa': ('bantamhøns',),
'bantamhønsene': ('bantamhøns',),
'bantamklasse': ('bantamklasse',),
'bantamklassen': ('bantamklasse',),
'bantamklassa': ('bantamklasse',),
'bantamklasser': ('bantamklasse',),
'bantamklassene': ('bantamklasse',),
'bantamvekt': ('bantamvekt',),
'bantamvekten': ('bantamvekt',),
'bantamvekta': ('bantamvekt',),
'bantamvekter': ('bantamvekt',),
'bantamvektene': ('bantamvekt',),
'bantu': ('bantu',),
'bantuen': ('bantu',),
'bantuer': ('bantu',),
'bantuene': ('bantu',),
'bantu': ('bantu',),
'bantuneger': ('bantuneger',),
'bantunegeren': ('bantuneger',),
'bantunegere': ('bantuneger',),
'bantunegrer': ('bantuneger',),
'bantunegre': ('bantuneger',),
'bantunegerne': ('bantuneger',),
'bantunegrene': ('bantuneger',),
'bantuspråk': ('bantuspråk',),
'bantuspråket': ('bantuspråk',),
'bantuspråk': ('bantuspråk',),
'bantuspråka': ('bantuspråk',),
'bantuspråkene': ('bantuspråk',),
'bantustan': ('bantustan',),
'bantustanen': ('bantustan',),
'bantustaner': ('bantustan',),
'bantustanene': ('bantustan',),
'baptisme': ('baptisme',),
'baptismen': ('baptisme',),
'baptismer': ('baptisme',),
'baptismene': ('baptisme',),
'baptist': ('baptist',),
'baptisten': ('baptist',),
'baptister': ('baptist',),
'baptistene': ('baptist',),
'baptistkirke': ('baptistkirke',),
'baptistkirken': ('baptistkirke',),
'baptistkirka': ('baptistkirke',),
'baptistkirker': ('baptistkirke',),
'baptistkirkene': ('baptistkirke',),
'baptistmenighet': ('baptistmenighet',),
'baptistmenigheten': ('baptistmenighet',),
'baptistmenigheta': ('baptistmenighet',),
'baptistmenigheter': ('baptistmenighet',),
'baptistmenighetene': ('baptistmenighet',),
'baptistprest': ('baptistprest',),
'baptistpresten': ('baptistprest',),
'baptistprester': ('baptistprest',),
'baptistprestene': ('baptistprest',),
'baptistsamfunn': ('baptistsamfunn',),
'baptistsamfunnet': ('baptistsamfunn',),
'baptistsamfunn': ('baptistsamfunn',),
'baptistsamfunna': ('baptistsamfunn',),
'baptistsamfunnene': ('baptistsamfunn',),
'bar': ('bar',),
'baren': ('bar',),
'barer': ('bar',),
'barene': ('bar',),
'bar': ('bar',),
'baren': ('bar',),
'bar': ('bar',),
'barene': ('bar',),
'bar': ('bar',),
'baret': ('bar',),
'bar': ('bar',),
'bara': ('bar',),
'barene': ('bar',),
'barbader': ('barbader',),
'barbaderen': ('barbader',),
'barbadere': ('barbader',),
'barbaderne': ('barbader',),
'barbadier': ('barbadier',),
'barbadieren': ('barbadier',),
'barbadiere': ('barbadier',),
'barbadierne': ('barbadier',),
'barbar': ('barbar',),
'barbaren': ('barbar',),
'barbarer': ('barbar',),
'barbarene': ('barbar',),
'barbari': ('barbari',),
'barbariet': ('barbari',),
'barbari': ('barbari',),
'barbaria': ('barbari',),
'barbariene': ('barbari',),
'barbarisme': ('barbarisme',),
'barbarismen': ('barbarisme',),
'barbarismer': ('barbarisme',),
'barbarismene': ('barbarisme',),
'barbecue': ('barbecue',),
'barbecuen': ('barbecue',),
'barbecuer': ('barbecue',),
'barbecuene': ('barbecue',),
'barber': ('barber',),
'barberen': ('barber',),
'barberer': ('barber',),
'barberene': ('barber',),
'barberblad': ('barberblad',),
'barberbladet': ('barberblad',),
'barberblad': ('barberblad',),
'barberblader': ('barberblad',),
'barberblad': ('barberblad',),
'barberblader': ('barberblad',),
'barberblada': ('barberblad',),
'barberbladene': ('barberblad',),
'barberer': ('barberer',),
'barbereren': ('barberer',),
'barberere': ('barberer',),
'barbererne': ('barberer',),
'barberhøvel': ('barberhøvel',),
'barberhøvelen': ('barberhøvel',),
'barberhøvler': ('barberhøvel',),
'barberhøvlene': ('barberhøvel',),
'barberkniv': ('barberkniv',),
'barberkniven': ('barberkniv',),
'barberkniver': ('barberkniv',),
'barberknivene': ('barberkniv',),
'barberkost': ('barberkost',),
'barberkosten': ('barberkost',),
'barberkoster': ('barberkost',),
'barberkostene': ('barberkost',),
'barberkrem': ('barberkrem',),
'barberkremen': ('barberkrem',),
'barberkremer': ('barberkrem',),
'barberkremene': ('barberkrem',),
'barbermaskin': ('barbermaskin',),
'barbermaskinen': ('barbermaskin',),
'barbermaskiner': ('barbermaskin',),
'barbermaskinene': ('barbermaskin',),
'barbersalong': ('barbersalong',),
'barbersalongen': ('barbersalong',),
'barbersalonger': ('barbersalong',),
'barbersalongene': ('barbersalong',),
'barberskum': ('barberskum',),
'barberskummet': ('barberskum',),
'barberskum': ('barberskum',),
'barberskumma': ('barberskum',),
'barberskummene': ('barberskum',),
'barbersåpe': ('barbersåpe',),
'barbersåpen': ('barbersåpe',),
'barbersåpa': ('barbersåpe',),
'barbersåper': ('barbersåpe',),
'barbersåpene': ('barbersåpe',),
'barde': ('barde',),
'barden': ('barde',),
'barder': ('barde',),
'bardene': ('barde',),
'bardehval': ('bardehval',),
'bardehvalen': ('bardehval',),
'bardehvaler': ('bardehval',),
'bardehvalene': ('bardehval',),
'bardekval': ('bardekval',),
'bardekvalen': ('bardekval',),
'bardekvaler': ('bardekval',),
'bardekvalene': ('bardekval',),
'bardisk': ('bardisk',),
'bardisken': ('bardisk',),
'bardisker': ('bardisk',),
'bardiskene': ('bardisk',),
'bardun': ('bardun',),
'bardunen': ('bardun',),
'barduner': ('bardun',),
'bardunene': ('bardun',),
'bardunkrok': ('bardunkrok',),
'bardunkroken': ('bardunkrok',),
'bardunkroker': ('bardunkrok',),
'bardunkrokene': ('bardunkrok',),
'bardunstreng': ('bardunstreng',),
'bardunstrengen': ('bardunstreng',),
'bardunstrenger': ('bardunstreng',),
'bardunstrengene': ('bardunstreng',),
'barett': ('barett',),
'baretten': ('barett',),
'baretter': ('barett',),
'barettene': ('barett',),
'barfotdans': ('barfotdans',),
'barfotdansen': ('barfotdans',),
'barfotdanser': ('barfotdans',),
'barfotdansene': ('barfotdans',),
'barfotlege': ('barfotlege',),
'barfotlegen': ('barfotlege',),
'barfotleger': ('barfotlege',),
'barfotlegene': ('barfotlege',),
'barfotmunk': ('barfotmunk',),
'barfotmunken': ('barfotmunk',),
'barfotmunker': ('barfotmunk',),
'barfotmunkene': ('barfotmunk',),
'barfotnonne': ('barfotnonne',),
'barfotnonnen': ('barfotnonne',),
'barfotnonna': ('barfotnonne',),
'barfotnonner': ('barfotnonne',),
'barfotnonnene': ('barfotnonne',),
'barfrost': ('barfrost',),
'barfrosten': ('barfrost',),
'barfroster': ('barfrost',),
'barfrostene': ('barfrost',),
'barhytte': ('barhytte',),
'barhytten': ('barhytte',),
'barhytta': ('barhytte',),
'barhytter': ('barhytte',),
'barhyttene': ('barhytte',),
'barium': ('barium',),
'bariumet': ('barium',),
'barium': ('barium',),
'bariuma': ('barium',),
'bariumene': ('barium',),
'barkarole': ('barkarole',),
'barkarolen': ('barkarole',),
'barkaroler': ('barkarole',),
'barkarolene': ('barkarole',),
'barkasse': ('barkasse',),
'barkassen': ('barkasse',),
'barkasser': ('barkasse',),
'barkassene': ('barkasse',),
'barkbille': ('barkbille',),
'barkbillen': ('barkbille',),
'barkbiller': ('barkbille',),
'barkbillene': ('barkbille',),
'barkbåt': ('barkbåt',),
'barkbåten': ('barkbåt',),
'barkbåter': ('barkbåt',),
'barkbåtene': ('barkbåt',),
'barkebrød': ('barkebrød',),
'barkebrødet': ('barkebrød',),
'barkebrød': ('barkebrød',),
'barkebrøda': ('barkebrød',),
'barkebrødene': ('barkebrød',),
'barkebåt': ('barkebåt',),
'barkebåten': ('barkebåt',),
'barkebåter': ('barkebåt',),
'barkebåtene': ('barkebåt',),
'barkeeper': ('barkeeper',),
'barkeeperen': ('barkeeper',),
'barkeepere': ('barkeeper',),
'barkeeperne': ('barkeeper',),
'barkemaskin': ('barkemaskin',),
'barkemaskinen': ('barkemaskin',),
'barkemaskiner': ('barkemaskin',),
'barkemaskinene': ('barkemaskin',),
'barkespade': ('barkespade',),
'barkespaden': ('barkespade',),
'barkespader': ('barkespade',),
'barkespadene': ('barkespade',),
'barkett': ('barkett',),
'barketten': ('barkett',),
'barketter': ('barkett',),
'barkettene': ('barkett',),
'barkrakk': ('barkrakk',),
'barkrakken': ('barkrakk',),
'barkrakker': ('barkrakk',),
'barkrakkene': ('barkrakk',),
'barkvist': ('barkvist',),
'barkvisten': ('barkvist',),
'barkvister': ('barkvist',),
'barkvistene': ('barkvist',),
'barlind': ('barlind',),
'barlinden': ('barlind',),
'barlinda': ('barlind',),
'barlinder': ('barlind',),
'barlindene': ('barlind',),
'barlindfamilie': ('barlindfamilie',),
'barlindfamilien': ('barlindfamilie',),
'barlindfamilier': ('barlindfamilie',),
'barlindfamiliene': ('barlindfamilie',),
'barm': ('barm',),
'barmen': ('barm',),
'barmer': ('barm',),
'barmene': ('barm',),
'barmark': ('barmark',),
'barmarken': ('barmark',),
'barmarka': ('barmark',),
'barmarker': ('barmark',),
'barmarkene': ('barmark',),
'barmarksamling': ('barmarksamling',),
'barmarksamlingen': ('barmarksamling',),
'barmarksamlinga': ('barmarksamling',),
'barmarksamlinger': ('barmarksamling',),
'barmarksamlingene': ('barmarksamling',),
'barmhjertighet': ('barmhjertighet',),
'barmhjertigheten': ('barmhjertighet',),
'barmhjertigheta': ('barmhjertighet',),
'barmhjertigheter': ('barmhjertighet',),
'barmhjertighetene': ('barmhjertighet',),
'barmhjertighetsdrap': ('barmhjertighetsdrap',),
'barmhjertighetsdrapet': ('barmhjertighetsdrap',),
'barmhjertighetsdrap': ('barmhjertighetsdrap',),
'barmhjertighetsdrapa': ('barmhjertighetsdrap',),
'barmhjertighetsdrapene': ('barmhjertighetsdrap',),
'barmhjertighetsgjerning': ('barmhjertighetsgjerning',),
'barmhjertighetsgjerningen': ('barmhjertighetsgjerning',),
'barmhjertighetsgjerninga': ('barmhjertighetsgjerning',),
'barmhjertighetsgjerninger': ('barmhjertighetsgjerning',),
'barmhjertighetsgjerningene': ('barmhjertighetsgjerning',),
'barn': ('barn',),
'barnet': ('barn',),
'barn': ('barn',),
'barna': ('barn',),
'barnene': ('barn',),
'barndom': ('barndom',),
'barndommen': ('barndom',),
'barndommer': ('barndom',),
'barndommene': ('barndom',),
'barndomsdrøm': ('barndomsdrøm',),
'barndomsdrømmen': ('barndomsdrøm',),
'barndomsdrømmer': ('barndomsdrøm',),
'barndomsdrømmene': ('barndomsdrøm',),
'barndomsheim': ('barndomsheim',),
'barndomsheimen': ('barndomsheim',),
'barndomsheimer': ('barndomsheim',),
'barndomsheimene': ('barndomsheim',),
'barndomshjem': ('barndomshjem',),
'barndomshjemmet': ('barndomshjem',),
'barndomshjem': ('barndomshjem',),
'barndomshjemma': ('barndomshjem',),
'barndomshjemmene': ('barndomshjem',),
'barndomsminne': ('barndomsminne',),
'barndomsminnet': ('barndomsminne',),
'barndomsminner': ('barndomsminne',),
'barndomsminna': ('barndomsminne',),
'barndomsminnene': ('barndomsminne',),
'barndomstid': ('barndomstid',),
'barndomstiden': ('barndomstid',),
'barndomstida': ('barndomstid',),
'barndomstider': ('barndomstid',),
'barndomstidene': ('barndomstid',),
'barndomsvenn': ('barndomsvenn',),
'barndomsvennen': ('barndomsvenn',),
'barndomsvenner': ('barndomsvenn',),
'barndomsvennene': ('barndomsvenn',),
'barndomsvenninne': ('barndomsvenninne',),
'barndomsvenninnen': ('barndomsvenninne',),
'barndomsvenninna': ('barndomsvenninne',),
'barndomsvenninner': ('barndomsvenninne',),
'barndomsvenninnene': ('barndomsvenninne',),
'barnearbeid': ('barnearbeid',),
'barnearbeidet': ('barnearbeid',),
'barnearbeid': ('barnearbeid',),
'barnearbeider': ('barnearbeid',),
'barnearbeid': ('barnearbeid',),
'barnearbeider': ('barnearbeid',),
'barnearbeida': ('barnearbeid',),
'barnearbeidene': ('barnearbeid',),
'barnebarn': ('barnebarn',),
'barnebarnet': ('barnebarn',),
'barnebarn': ('barnebarn',),
'barnebarna': ('barnebarn',),
'barnebarnene': ('barnebarn',),
'barnebegrensning': ('barnebegrensning',),
'barnebegrensningen': ('barnebegrensning',),
'barnebegrensninga': ('barnebegrensning',),
'barnebegrensninger': ('barnebegrensning',),
'barnebegrensningene': ('barnebegrensning',),
'barnebidrag': ('barnebidrag',),
'barnebidraget': ('barnebidrag',),
'barnebidrag': ('barnebidrag',),
'barnebidraga': ('barnebidrag',),
'barnebidragene': ('barnebidrag',),
'barnebillett': ('barnebillett',),
'barnebilletten': ('barnebillett',),
'barnebilletter': ('barnebillett',),
'barnebillettene': ('barnebillett',),
'barneblad': ('barneblad',),
'barnebladet': ('barneblad',),
'barneblad': ('barneblad',),
'barneblader': ('barneblad',),
'barneblad': ('barneblad',),
'barneblader': ('barneblad',),
'barneblada': ('barneblad',),
'barnebladene': ('barneblad',),
'barnedåp': ('barnedåp',),
'barnedåpen': ('barnedåp',),
'barnedåper': ('barnedåp',),
'barnedåpene': ('barnedåp',),
'barnedødelighet': ('barnedødelighet',),
'barnedødeligheten': ('barnedødelighet',),
'barnedødeligheta': ('barnedødelighet',),
'barnedødeligheter': ('barnedødelighet',),
'barnedødelighetene': ('barnedødelighet',),
'barnefamilie': ('barnefamilie',),
'barnefamilien': ('barnefamilie',),
'barnefamilier': ('barnefamilie',),
'barnefamiliene': ('barnefamilie',),
'barnefarsak': ('barnefarsak',),
'barnefarsaken': ('barnefarsak',),
'barnefarsaka': ('barnefarsak',),
'barnefarsaker': ('barnefarsak',),
'barnefarsakene': ('barnefarsak',),
'barnefarssak': ('barnefarssak',),
'barnefarssaken': ('barnefarssak',),
'barnefarssaka': ('barnefarssak',),
'barnefarssaker': ('barnefarssak',),
'barnefarssakene': ('barnefarssak',),
'barneflokk': ('barneflokk',),
'barneflokken': ('barneflokk',),
'barneflokker': ('barneflokk',),
'barneflokkene': ('barneflokk',),
'barneforestilling': ('barneforestilling',),
'barneforestillingen': ('barneforestilling',),
'barneforestillinga': ('barneforestilling',),
'barneforestillinger': ('barneforestilling',),
'barneforestillingene': ('barneforestilling',),
'barnehage': ('barnehage',),
'barnehagen': ('barnehage',),
'barnehager': ('barnehage',),
'barnehagene': ('barnehage',),
'barnehagelærer': ('barnehagelærer',),
'barnehagelæreren': ('barnehagelærer',),
'barnehagelærere': ('barnehagelærer',),
'barnehagelærerne': ('barnehagelærer',),
'barneheim': ('barneheim',),
'barneheimen': ('barneheim',),
'barneheimer': ('barneheim',),
'barneheimene': ('barneheim',),
'barnehjem': ('barnehjem',),
'barnehjemmet': ('barnehjem',),
'barnehjem': ('barnehjem',),
'barnehjemma': ('barnehjem',),
'barnehjemmene': ('barnehjem',),
'barneklær': ('barneklær',),
'barneklærne': ('barneklær',),
'barnelammelse': ('barnelammelse',),
'barnelammelsen': ('barnelammelse',),
'barnelammelser': ('barnelammelse',),
'barnelammelsene': ('barnelammelse',),
'barnelege': ('barnelege',),
'barnelegen': ('barnelege',),
'barneleger': ('barnelege',),
'barnelegene': ('barnelege',),
'barnelærdom': ('barnelærdom',),
'barnelærdommen': ('barnelærdom',),
'barnelærdommer': ('barnelærdom',),
'barnelærdommene': ('barnelærdom',),
'barnemat': ('barnemat',),
'barnematen': ('barnemat',),
'barnemater': ('barnemat',),
'barnematene': ('barnemat',),
'barnemishandling': ('barnemishandling',),
'barnemishandlingen': ('barnemishandling',),
'barnemishandlinga': ('barnemishandling',),
'barnemishandlinger': ('barnemishandling',),
'barnemishandlingene': ('barnemishandling',),
'barneombud': ('barneombud',),
'barneombudet': ('barneombud',),
'barneombud': ('barneombud',),
'barneombuda': ('barneombud',),
'barneombudene': ('barneombud',),
'barneoppdragelse': ('barneoppdragelse',),
'barneoppdragelsen': ('barneoppdragelse',),
'barneoppdragelser': ('barneoppdragelse',),
'barneoppdragelsene': ('barneoppdragelse',),
'barnepark': ('barnepark',),
'barneparken': ('barnepark',),
'barneparker': ('barnepark',),
'barneparkene': ('barnepark',),
'barneparkering': ('barneparkering',),
'barneparkeringen': ('barneparkering',),
'barneparkeringa': ('barneparkering',),
'barneparkeringer': ('barneparkering',),
'barneparkeringene': ('barneparkering',),
'barnepike': ('barnepike',),
'barnepiken': ('barnepike',),
'barnepika': ('barnepike',),
'barnepiker': ('barnepike',),
'barnepikene': ('barnepike',),
'barnepleie': ('barnepleie',),
'barnepleien': ('barnepleie',),
'barnepleia': ('barnepleie',),
'barnepleier': ('barnepleie',),
'barnepleiene': ('barnepleie',),
'barnepleier': ('barnepleier',),
'barnepleieren': ('barnepleier',),
'barnepleiere': ('barnepleier',),
'barnepleierne': ('barnepleier',),
'barnepsykiatri': ('barnepsykiatri',),
'barnepsykiatrien': ('barnepsykiatri',),
'barnepsykiatrier': ('barnepsykiatri',),
'barnepsykiatriene': ('barnepsykiatri',),
'barnepsykologi': ('barnepsykologi',),
'barnepsykologien': ('barnepsykologi',),
'barnepsykologier': ('barnepsykologi',),
'barnepsykologiene': ('barnepsykologi',),
'barneregle': ('barneregle',),
'barnereglen': ('barneregle',),
'barneregla': ('barneregle',),
'barneregler': ('barneregle',),
'barnereglene': ('barneregle',),
'barnerov': ('barnerov',),
'barnerovet': ('barnerov',),
'barnerov': ('barnerov',),
'barnerova': ('barnerov',),
'barnerovene': ('barnerov',),
'barnerumpe': ('barnerumpe',),
'barnerumpen': ('barnerumpe',),
'barnerumpa': ('barnerumpe',),
'barnerumper': ('barnerumpe',),
'barnerumpene': ('barnerumpe',),
'barnesang': ('barnesang',),
'barnesangen': ('barnesang',),
'barnesanger': ('barnesang',),
'barnesangene': ('barnesang',),
'barneselskap': ('barneselskap',),
'barneselskapet': ('barneselskap',),
'barneselskap': ('barneselskap',),
'barneselskaper': ('barneselskap',),
'barneselskap': ('barneselskap',),
'barneselskaper': ('barneselskap',),
'barneselskapa': ('barneselskap',),
'barneselskapene': ('barneselskap',),
'barnesikring': ('barnesikring',),
'barnesikringen': ('barnesikring',),
'barnesikringa': ('barnesikring',),
'barnesikringer': ('barnesikring',),
'barnesikringene': ('barnesikring',),
'barnesjukdom': ('barnesjukdom',),
'barnesjukdommen': ('barnesjukdom',),
'barnesjukdommer': ('barnesjukdom',),
'barnesjukdommene': ('barnesjukdom',),
'barneskei': ('barneskei',),
'barneskeien': ('barneskei',),
'barneskeia': ('barneskei',),
'barneskeier': ('barneskei',),
'barneskeiene': ('barneskei',),
'barneskje': ('barneskje',),
'barneskjeen': ('barneskje',),
'barneskjea': ('barneskje',),
'barneskjeer': ('barneskje',),
'barneskjeene': ('barneskje',),
'barneskole': ('barneskole',),
'barneskolen': ('barneskole',),
'barneskoler': ('barneskole',),
'barneskolene': ('barneskole',),
'barnespråk': ('barnespråk',),
'barnespråket': ('barnespråk',),
'barnespråk': ('barnespråk',),
'barnespråka': ('barnespråk',),
'barnespråkene': ('barnespråk',),
'barnesull': ('barnesull',),
'barnesullen': ('barnesull',),
'barnesuller': ('barnesull',),
'barnesullene': ('barnesull',),
'barnesykdom': ('barnesykdom',),
'barnesykdommen': ('barnesykdom',),
'barnesykdommer': ('barnesykdom',),
'barnesykdommene': ('barnesykdom',),
'barnesåpe': ('barnesåpe',),
'barnesåpen': ('barnesåpe',),
'barnesåpa': ('barnesåpe',),
'barnesåper': ('barnesåpe',),
'barnesåpene': ('barnesåpe',),
'barnetall': ('barnetall',),
'barnetallet': ('barnetall',),
'barnetall': ('barnetall',),
'barnetalla': ('barnetall',),
'barnetallene': ('barnetall',),
'barnetekke': ('barnetekke',),
'barnetekket': ('barnetekke',),
'barnetekker': ('barnetekke',),
'barnetekka': ('barnetekke',),
'barnetekkene': ('barnetekke',),
'barnetime': ('barnetime',),
'barnetimen': ('barnetime',),
'barnetimer': ('barnetime',),
'barnetimene': ('barnetime',),
'barnetog': ('barnetog',),
'barnetoget': ('barnetog',),
'barnetog': ('barnetog',),
'barnetoga': ('barnetog',),
'barnetogene': ('barnetog',),
'barnetrinn': ('barnetrinn',),
'barnetrinnet': ('barnetrinn',),
'barnetrinn': ('barnetrinn',),
'barnetrinna': ('barnetrinn',),
'barnetrinnene': ('barnetrinn',),
'barnetro': ('barnetro',),
'barnetroen': ('barnetro',),
'barnetroa': ('barnetro',),
'barnetroer': ('barnetro',),
'barnetroene': ('barnetro',),
'barnetrygd': ('barnetrygd',),
'barnetrygden': ('barnetrygd',),
'barnetrygda': ('barnetrygd',),
'barnetrygder': ('barnetrygd',),
'barnetrygdene': ('barnetrygd',),
'barnevakt': ('barnevakt',),
'barnevakten': ('barnevakt',),
'barnevakta': ('barnevakt',),
'barnevakter': ('barnevakt',),
'barnevaktene': ('barnevakt',),
'barnevern': ('barnevern',),
'barnevernet': ('barnevern',),
'barnevern': ('barnevern',),
'barneverna': ('barnevern',),
'barnevernene': ('barnevern',),
'barnevernsnemnd': ('barnevernsnemnd',),
'barnevernsnemnden': ('barnevernsnemnd',),
'barnevernsnemnda': ('barnevernsnemnd',),
'barnevernsnemnder': ('barnevernsnemnd',),
'barnevernsnemndene': ('barnevernsnemnd',),
'barnevogn': ('barnevogn',),
'barnevognen': ('barnevogn',),
'barnevogna': ('barnevogn',),
'barnevogner': ('barnevogn',),
'barnevognene': ('barnevogn',),
'barneår': ('barneår',),
'barneåret': ('barneår',),
'barneår': ('barneår',),
'barneåra': ('barneår',),
'barneårene': ('barneår',),
'barnsbein': ('barnsbein',),
'barnsben': ('barnsben',),
'barnsnød': ('barnsnød',),
'barnsnøden': ('barnsnød',),
'barnsnøda': ('barnsnød',),
'barnsnøder': ('barnsnød',),
'barnsnødene': ('barnsnød',),
'barnål': ('barnål',),
'barnålen': ('barnål',),
'barnåla': ('barnål',),
'barnåler': ('barnål',),
'barnålene': ('barnål',),
'barokk': ('barokk',),
'barokken': ('barokk',),
'barokker': ('barokk',),
'barokkene': ('barokk',),
'barokkbygning': ('barokkbygning',),
'barokkbygningen': ('barokkbygning',),
'barokkbygninga': ('barokkbygning',),
'barokkbygninger': ('barokkbygning',),
'barokkbygningene': ('barokkbygning',),
'barokkmusikk': ('barokkmusikk',),
'barokkmusikken': ('barokkmusikk',),
'barokkmusikker': ('barokkmusikk',),
'barokkmusikkene': ('barokkmusikk',),
'barokkstil': ('barokkstil',),
'barokkstilen': ('barokkstil',),
'barokkstiler': ('barokkstil',),
'barokkstilene': ('barokkstil',),
'barometer': ('barometer',),
'barometeret': ('barometer',),
'barometret': ('barometer',),
'barometer': ('barometer',),
'barometre': ('barometer',),
'barometra': ('barometer',),
'barometrene': ('barometer',),
'barometra': ('barometer',),
'barometrene': ('barometer',),
'barometerfall': ('barometerfall',),
'barometerfallet': ('barometerfall',),
'barometerfall': ('barometerfall',),
'barometerfalla': ('barometerfall',),
'barometerfallene': ('barometerfall',),
'barometerstand': ('barometerstand',),
'barometerstanden': ('barometerstand',),
'barometerstander': ('barometerstand',),
'barometerstandene': ('barometerstand',),
'barometersøyle': ('barometersøyle',),
'barometersøylen': ('barometersøyle',),
'barometersøyla': ('barometersøyle',),
'barometersøyler': ('barometersøyle',),
'barometersøylene': ('barometersøyle',),
'baron': ('baron',),
'baronen': ('baron',),
'baroner': ('baron',),
'baronene': ('baron',),
'baronesse': ('baronesse',),
'baronessen': ('baronesse',),
'baronessa': ('baronesse',),
'baronesser': ('baronesse',),
'baronessene': ('baronesse',),
'baroni': ('baroni',),
'baroniet': ('baroni',),
'baroni': ('baroni',),
'baronier': ('baroni',),
'baroni': ('baroni',),
'baronier': ('baroni',),
'baronia': ('baroni',),
'baroniene': ('baroni',),
'barontittel': ('barontittel',),
'barontittelen': ('barontittel',),
'barontitler': ('barontittel',),
'barontitlene': ('barontittel',),
'baronverdighet': ('baronverdighet',),
'baronverdigheten': ('baronverdighet',),
'baronverdigheta': ('baronverdighet',),
'baronverdigheter': ('baronverdighet',),
'baronverdighetene': ('baronverdighet',),
'barrakuda': ('barrakuda',),
'barrakudaen': ('barrakuda',),
'barrakudaer': ('barrakuda',),
'barrakudaene': ('barrakuda',),
'barre': ('barre',),
'barren': ('barre',),
'barrer': ('barre',),
'barrene': ('barre',),
'barreform': ('barreform',),
'barreformen': ('barreform',),
'barreforma': ('barreform',),
'barreformer': ('barreform',),
'barreformene': ('barreform',),
'barregull': ('barregull',),
'barregullet': ('barregull',),
'barregull': ('barregull',),
'barregulla': ('barregull',),
'barregullene': ('barregull',),
'barrel': ('barrel',),
'barrelen': ('barrel',),
'barrel': ('barrel',),
'barrels': ('barrel',),
'barrelene': ('barrel',),
'barriere': ('barriere',),
'barrieren': ('barriere',),
'barrierer': ('barriere',),
'barrierene': ('barriere',),
'barriererev': ('barriererev',),
'barriererevet': ('barriererev',),
'barriererev': ('barriererev',),
'barrierereva': ('barriererev',),
'barriererevene': ('barriererev',),
'barrikade': ('barrikade',),
'barrikaden': ('barrikade',),
'barrikader': ('barrikade',),
'barrikadene': ('barrikade',),
'barrikadekjemper': ('barrikadekjemper',),
'barrikadekjemperen': ('barrikadekjemper',),
'barrikadekjempere': ('barrikadekjemper',),
'barrikadekjemperne': ('barrikadekjemper',),
'barsel': ('barsel',),
'barselet': ('barsel',),
'barslet': ('barsel',),
'barsel': ('barsel',),
'barsler': ('barsel',),
'barsla': ('barsel',),
'barslene': ('barsel',),
'barsla': ('barsel',),
'barslene': ('barsel',),
'barselavdeling': ('barselavdeling',),
'barselavdelingen': ('barselavdeling',),
'barselavdelinga': ('barselavdeling',),
'barselavdelinger': ('barselavdeling',),
'barselavdelingene': ('barselavdeling',),
'barselfeber': ('barselfeber',),
'barselfeberen': ('barselfeber',),
'barselfebere': ('barselfeber',),
'barselfebrer': ('barselfeber',),
'barselfebre': ('barselfeber',),
'barselfeberne': ('barselfeber',),
'barselfebrene': ('barselfeber',),
'barselgraut': ('barselgraut',),
'barselgrauten': ('barselgraut',),
'barselgrauter': ('barselgraut',),
'barselgrautene': ('barselgraut',),
'barselgrøt': ('barselgrøt',),
'barselgrøten': ('barselgrøt',),
'barselgrøter': ('barselgrøt',),
'barselgrøtene': ('barselgrøt',),
'barselkrampe': ('barselkrampe',),
'barselkrampen': ('barselkrampe',),
'barselkramper': ('barselkrampe',),
'barselkrampene': ('barselkrampe',),
'barselpenger': ('barselpenger',),
'barselpengene': ('barselpenger',),
'barselseng': ('barselseng',),
'barselsengen': ('barselseng',),
'barselsenga': ('barselseng',),
'barselsenger': ('barselseng',),
'barselsengene': ('barselseng',),
'barselstue': ('barselstue',),
'barselstuen': ('barselstue',),
'barselstua': ('barselstue',),
'barselstuer': ('barselstue',),
'barselstuene': ('barselstue',),
'barselvisitt': ('barselvisitt',),
'barselvisitten': ('barselvisitt',),
'barselvisitter': ('barselvisitt',),
'barselvisittene': ('barselvisitt',),
'barsking': ('barsking',),
'barskingen': ('barsking',),
'barskinger': ('barsking',),
'barskingene': ('barsking',),
'barskog': ('barskog',),
'barskogen': ('barskog',),
'barskoger': ('barskog',),
'barskogene': ('barskog',),
'barskogbelte': ('barskogbelte',),
'barskogbeltet': ('barskogbelte',),
'barskogbelter': ('barskogbelte',),
'barskogbelta': ('barskogbelte',),
'barskogbeltene': ('barskogbelte',),
'barsok': ('barsok',),
'bart': ('bart',),
'barten': ('bart',),
'barter': ('bart',),
'bartene': ('bart',),
'bartender': ('bartender',),
'bartenderen': ('bartender',),
'bartendere': ('bartender',),
'bartenderne': ('bartender',),
'bartolomeusdag': ('bartolomeusdag',),
'bartolomeusdagen': ('bartolomeusdag',),
'bartolomeusdager': ('bartolomeusdag',),
'bartolomeusdagene': ('bartolomeusdag',),
'bartolomeusmess': ('bartolomeusmess',),
'bartolomeusmessen': ('bartolomeusmess',),
'bartolomeusmessa': ('bartolomeusmess',),
'bartolomeusmesser': ('bartolomeusmess',),
'bartolomeusmessene': ('bartolomeusmess',),
'bartolomeusmesse': ('bartolomeusmesse',),
'bartolomeusmessen': ('bartolomeusmesse',),
'bartolomeusmessa': ('bartolomeusmesse',),
'bartolomeusmesser': ('bartolomeusmesse',),
'bartolomeusmessene': ('bartolomeusmesse',),
'bartolomeusnatt': ('bartolomeusnatt',),
'bartolomeusnatten': ('bartolomeusnatt',),
'bartolomeusnatta': ('bartolomeusnatt',),
'bartolomeusnetter': ('bartolomeusnatt',),
'bartolomeusnettene': ('bartolomeusnatt',),
'bartre': ('bartre',),
'bartreet': ('bartre',),
'bartre': ('bartre',),
'bartrær': ('bartre',),
'bartrea': ('bartre',),
'bartrærne': ('bartre',),
'bartrevirke': ('bartrevirke',),
'bartrevirket': ('bartrevirke',),
'bartrevirker': ('bartrevirke',),
'bartrevirka': ('bartrevirke',),
'bartrevirkene': ('bartrevirke',),
'bartskjær': ('bartskjær',),
'bartskjæren': ('bartskjær',),
'bartskjærer': ('bartskjær',),
'bartskjærene': ('bartskjær',),
'baryton': ('baryton',),
'barytonen': ('baryton',),
'barytoner': ('baryton',),
'barytonene': ('baryton',),
'barytonsaksofon': ('barytonsaksofon',),
'barytonsaksofonen': ('barytonsaksofon',),
'barytonsaksofoner': ('barytonsaksofon',),
'barytonsaksofonene': ('barytonsaksofon',),
'barytonsanger': ('barytonsanger',),
'barytonsangeren': ('barytonsanger',),
'barytonsangere': ('barytonsanger',),
'barytonsangerne': ('barytonsanger',),
'barytonstemme': ('barytonstemme',),
'barytonstemmen': ('barytonstemme',),
'barytonstemmer': ('barytonstemme',),
'barytonstemmene': ('barytonstemme',),
'bas': ('bas',),
'basen': ('bas',),
'baser': ('bas',),
'basene': ('bas',),
'basalforsking': ('basalforsking',),
'basalforskingen': ('basalforsking',),
'basalforskinga': ('basalforsking',),
'basalforskinger': ('basalforsking',),
'basalforskingene': ('basalforsking',),
'basalforskning': ('basalforskning',),
'basalforskningen': ('basalforskning',),
'basalforskninga': ('basalforskning',),
'basalforskninger': ('basalforskning',),
'basalforskningene': ('basalforskning',),
'basalt': ('basalt',),
'basalten': ('basalt',),
'basalter': ('basalt',),
'basaltene': ('basalt',),
'basaltskifer': ('basaltskifer',),
'basaltskiferen': ('basaltskifer',),
'basaltskifere': ('basaltskifer',),
'basaltskifrer': ('basaltskifer',),
'basaltskifre': ('basaltskifer',),
'basaltskiferne': ('basaltskifer',),
'basaltskifrene': ('basaltskifer',),
'basar': ('basar',),
'basaren': ('basar',),
'basarer': ('basar',),
'basarene': ('basar',),
'basbåt': ('basbåt',),
'basbåten': ('basbåt',),
'basbåter': ('basbåt',),
'basbåtene': ('basbåt',),
'base': ('base',),
'basen': ('base',),
'baser': ('base',),
'basene': ('base',),
'baseball': ('baseball',),
'baseballen': ('baseball',),
'baseballer': ('baseball',),
'baseballene': ('baseball',),
'basepolitikk': ('basepolitikk',),
'basepolitikken': ('basepolitikk',),
'basepolitikker': ('basepolitikk',),
'basepolitikkene': ('basepolitikk',),
'basilik': ('basilik',),
'basiliken': ('basilik',),
'basiliker': ('basilik',),
'basilikene': ('basilik',),
'basilika': ('basilika',),
'basilikaen': ('basilika',),
'basilikaer': ('basilika',),
'basilikaene': ('basilika',),
'basilikum': ('basilikum',),
'basilikumen': ('basilikum',),
'basilikumer': ('basilikum',),
'basilikumene': ('basilikum',),
'basilisk': ('basilisk',),
'basilisken': ('basilisk',),
'basilisker': ('basilisk',),
'basiliskene': ('basilisk',),
'basill': ('basill',),
'basillen': ('basill',),
'basiller': ('basill',),
'basillene': ('basill',),
'basillbærer': ('basillbærer',),
'basillbæreren': ('basillbærer',),
'basillbærere': ('basillbærer',),
'basillbærerne': ('basillbærer',),
'basillkultur': ('basillkultur',),
'basillkulturen': ('basillkultur',),
'basillkulturer': ('basillkultur',),
'basillkulturene': ('basillkultur',),
'basis': ('basis',),
'basisen': ('basis',),
'basiser': ('basis',),
'basisene': ('basis',),
'basisfraktur': ('basisfraktur',),
'basisfrakturen': ('basisfraktur',),
'basisfrakturer': ('basisfraktur',),
'basisfrakturene': ('basisfraktur',),
'basisgruppe': ('basisgruppe',),
'basisgruppen': ('basisgruppe',),
'basisgruppa': ('basisgruppe',),
'basisgrupper': ('basisgruppe',),
'basisgruppene': ('basisgruppe',),
'basislinje': ('basislinje',),
'basislinjen': ('basislinje',),
'basislinja': ('basislinje',),
'basislinjer': ('basislinje',),
'basislinjene': ('basislinje',),
'basispunkt': ('basispunkt',),
'basispunktet': ('basispunkt',),
'basispunkt': ('basispunkt',),
'basispunkter': ('basispunkt',),
'basispunkt': ('basispunkt',),
'basispunkter': ('basispunkt',),
'basispunkta': ('basispunkt',),
'basispunktene': ('basispunkt',),
'basisår': ('basisår',),
'basisåret': ('basisår',),
'basisår': ('basisår',),
'basisåra': ('basisår',),
'basisårene': ('basisår',),
'basker': ('basker',),
'baskeren': ('basker',),
'baskere': ('basker',),
'baskerne': ('basker',),
'baskerhue': ('baskerhue',),
'baskerhuen': ('baskerhue',),
'baskerhua': ('baskerhue',),
'baskerhuer': ('baskerhue',),
'baskerhuene': ('baskerhue',),
'baskerlue': ('baskerlue',),
'baskerluen': ('baskerlue',),
'baskerlua': ('baskerlue',),
'baskerluer': ('baskerlue',),
'baskerluene': ('baskerlue',),
'basketak': ('basketak',),
'basketaket': ('basketak',),
'basketak': ('basketak',),
'basketaka': ('basketak',),
'basketakene': ('basketak',),
'basketball': ('basketball',),
'basketballen': ('basketball',),
'basketballer': ('basketball',),
'basketballene': ('basketball',),
'baskisk': ('baskisk',),
'baskisken': ('baskisk',),
'baskisket': ('baskisk',),
'baskisker': ('baskisk',),
'baskisk': ('baskisk',),
'baskiskene': ('baskisk',),
'baskiska': ('baskisk',),
'basrelieff': ('basrelieff',),
'basrelieffet': ('basrelieff',),
'basrelieff': ('basrelieff',),
'basrelieffer': ('basrelieff',),
'basrelieff': ('basrelieff',),
'basrelieffer': ('basrelieff',),
'basrelieffa': ('basrelieff',),
'basrelieffene': ('basrelieff',),
'bass': ('bass',),
'bassen': ('bass',),
'basser': ('bass',),
'bassene': ('bass',),
'bass-sanger': ('bass-sanger',),
'bass-sangeren': ('bass-sanger',),
'bass-sangere': ('bass-sanger',),
'bass-sangerne': ('bass-sanger',),
'bass-streng': ('bass-streng',),
'bass-strengen': ('bass-streng',),
'bass-strenger': ('bass-streng',),
'bass-strengene': ('bass-streng',),
'bassanger': ('bassanger',),
'bassangeren': ('bassanger',),
'bassangere': ('bassanger',),
'bassangerne': ('bassanger',),
'bassbaryton': ('bassbaryton',),
'bassbarytonen': ('bassbaryton',),
'bassbarytoner': ('bassbaryton',),
'bassbarytonene': ('bassbaryton',),
'bassbasun': ('bassbasun',),
'bassbasunen': ('bassbasun',),
'bassbasuner': ('bassbasun',),
'bassbasunene': ('bassbasun',),
'basse': ('basse',),
'bassen': ('basse',),
'basser': ('basse',),
'bassene': ('basse',),
'basseng': ('basseng',),
'bassenget': ('basseng',),
'basseng': ('basseng',),
'bassenger': ('basseng',),
'basseng': ('basseng',),
'bassenger': ('basseng',),
'bassenga': ('basseng',),
'bassengene': ('basseng',),
'bassgitar': ('bassgitar',),
'bassgitaren': ('bassgitar',),
'bassgitarer': ('bassgitar',),
'bassgitarene': ('bassgitar',),
'bassist': ('bassist',),
'bassisten': ('bassist',),
'bassister': ('bassist',),
'bassistene': ('bassist',),
'bassnote': ('bassnote',),
'bassnoten': ('bassnote',),
'bassnoter': ('bassnote',),
'bassnotene': ('bassnote',),
'bassnøkkel': ('bassnøkkel',),
'bassnøkkelen': ('bassnøkkel',),
'bassnøkler': ('bassnøkkel',),
'bassnøklene': ('bassnøkkel',),
'basstreng': ('basstreng',),
'basstrengen': ('basstreng',),
'basstrenger': ('basstreng',),
'basstrengene': ('basstreng',),
'basstuba': ('basstuba',),
'basstubaen': ('basstuba',),
'basstubaer': ('basstuba',),
'basstubaene': ('basstuba',),
'bast': ('bast',),
'basten': ('bast',),
'baster': ('bast',),
'bastene': ('bast',),
'bastard': ('bastard',),
'bastarden': ('bastard',),
'bastarder': ('bastard',),
'bastardene': ('bastard',),
'bastardart': ('bastardart',),
'bastardarten': ('bastardart',),
'bastardarta': ('bastardart',),
'bastardarter': ('bastardart',),
'bastardartene': ('bastardart',),
'bastardisering': ('bastardisering',),
'bastardiseringen': ('bastardisering',),
'bastardiseringa': ('bastardisering',),
'bastardiseringer': ('bastardisering',),
'bastardiseringene': ('bastardisering',),
'bastardplante': ('bastardplante',),
'bastardplanten': ('bastardplante',),
'bastardplanta': ('bastardplante',),
'bastardplanter': ('bastardplante',),
'bastardplantene': ('bastardplante',),
'bastion': ('bastion',),
'bastionen': ('bastion',),
'bastioner': ('bastion',),
'bastionene': ('bastion',),
'bastmatte': ('bastmatte',),
'bastmatten': ('bastmatte',),
'bastmatta': ('bastmatte',),
'bastmatter': ('bastmatte',),
'bastmattene': ('bastmatte',),
'bastsilke': ('bastsilke',),
'bastsilken': ('bastsilke',),
'bastsilker': ('bastsilke',),
'bastsilkene': ('bastsilke',),
'bastskjørt': ('bastskjørt',),
'bastskjørtet': ('bastskjørt',),
'bastskjørt': ('bastskjørt',),
'bastskjørter': ('bastskjørt',),
'bastskjørt': ('bastskjørt',),
'bastskjørter': ('bastskjørt',),
'bastskjørta': ('bastskjørt',),
'bastskjørtene': ('bastskjørt',),
'basttau': ('basttau',),
'basttauet': ('basttau',),
'basttau': ('basttau',),
'basttaua': ('basttau',),
'basttauene': ('basttau',),
'basun': ('basun',),
'basunen': ('basun',),
'basuner': ('basun',),
'basunene': ('basun',),
'basunengel': ('basunengel',),
'basunengelen': ('basunengel',),
'basunengler': ('basunengel',),
'basunenglene': ('basunengel',),
'basunist': ('basunist',),
'basunisten': ('basunist',),
'basunister': ('basunist',),
'basunistene': ('basunist',),
'basunrøst': ('basunrøst',),
'basunrøsten': ('basunrøst',),
'basunrøsta': ('basunrøst',),
'basunrøster': ('basunrøst',),
'basunrøstene': ('basunrøst',),
'batalje': ('batalje',),
'bataljen': ('batalje',),
'bataljer': ('batalje',),
'bataljene': ('batalje',),
'bataljon': ('bataljon',),
'bataljonen': ('bataljon',),
'bataljoner': ('bataljon',),
'bataljonene': ('bataljon',),
'bataljonssjef': ('bataljonssjef',),
'bataljonssjefen': ('bataljonssjef',),
'bataljonssjefer': ('bataljonssjef',),
'bataljonssjefene': ('bataljonssjef',),
'batate': ('batate',),
'bataten': ('batate',),
'batater': ('batate',),
'batatene': ('batate',),
'batateplante': ('batateplante',),
'batateplanten': ('batateplante',),
'batateplanta': ('batateplante',),
'batateplanter': ('batateplante',),
'batateplantene': ('batateplante',),
'bate': ('bate',),
'baten': ('bate',),
'bater': ('bate',),
'batene': ('bate',),
'batikk': ('batikk',),
'batikken': ('batikk',),
'batikker': ('batikk',),
'batikkene': ('batikk',),
'batikktrykk': ('batikktrykk',),
'batikktrykket': ('batikktrykk',),
'batikktrykk': ('batikktrykk',),
'batikktrykka': ('batikktrykk',),
'batikktrykkene': ('batikktrykk',),
'batist': ('batist',),
'batisten': ('batist',),
'batister': ('batist',),
'batistene': ('batist',),
'batong': ('batong',),
'batongen': ('batong',),
'batonger': ('batong',),
'batongene': ('batong',),
'batteri': ('batteri',),
'batteriet': ('batteri',),
'batteri': ('batteri',),
'batterier': ('batteri',),
'batteri': ('batteri',),
'batterier': ('batteri',),
'batteria': ('batteri',),
'batteriene': ('batteri',),
'batteribefal': ('batteribefal',),
'batteribefalet': ('batteribefal',),
'batteribefal': ('batteribefal',),
'batteribefala': ('batteribefal',),
'batteribefalene': ('batteribefal',),
'batterieliminator': ('batterieliminator',),
'batterieliminatoren': ('batterieliminator',),
'batterieliminatorer': ('batterieliminator',),
'batterieliminatorene': ('batterieliminator',),
'batterilader': ('batterilader',),
'batteriladeren': ('batterilader',),
'batteriladere': ('batterilader',),
'batteriladerne': ('batterilader',),
'batteriradio': ('batteriradio',),
'batteriradioen': ('batteriradio',),
'batteriradioer': ('batteriradio',),
'batteriradioene': ('batteriradio',),
'batterist': ('batterist',),
'batteristen': ('batterist',),
'batterister': ('batterist',),
'batteristene': ('batterist',),
'battledress': ('battledress',),
'battledressen': ('battledress',),
'battledresser': ('battledress',),
'battledressene': ('battledress',),
'baufil': ('baufil',),
'baufilen': ('baufil',),
'baufila': ('baufil',),
'baufiler': ('baufil',),
'baufilene': ('baufil',),
'baug': ('baug',),
'baugen': ('baug',),
'bauger': ('baug',),
'baugene': ('baug',),
'bauganker': ('bauganker',),
'baugankeret': ('bauganker',),
'baugankret': ('bauganker',),
'baugankeret': ('bauganker',),
'bauganker': ('bauganker',),
'baugankere': ('bauganker',),
'baugankre': ('bauganker',),
'baugankera': ('bauganker',),
'baugankra': ('bauganker',),
'baugankrene': ('bauganker',),
'baugankra': ('bauganker',),
'baugankrene': ('bauganker',),
'baugspryd': ('baugspryd',),
'baugsprydet': ('baugspryd',),
'baugspryd': ('baugspryd',),
'baugspryda': ('baugspryd',),
'baugsprydene': ('baugspryd',),
'bauksitt': ('bauksitt',),
'bauksitten': ('bauksitt',),
'bauksitter': ('bauksitt',),
'bauksittene': ('bauksitt',),
'baumé': ('baumé',),
'baumégrad': ('baumégrad',),
'baumégraden': ('baumégrad',),
'baumégrader': ('baumégrad',),
'baumégradene': ('baumégrad',),
'bauméskala': ('bauméskala',),
'bauméskalaen': ('bauméskala',),
'bauméskalaer': ('bauméskala',),
'bauméskalaene': ('bauméskala',),
'baun': ('baun',),
'baunen': ('baun',),
'bauner': ('baun',),
'baunene': ('baun',),
'baunbluss': ('baunbluss',),
'baunblusset': ('baunbluss',),
'baunbluss': ('baunbluss',),
'baunblussa': ('baunbluss',),
'baunblussene': ('baunbluss',),
'baut': ('baut',),
'bauten': ('baut',),
'bauter': ('baut',),
'bautene': ('baut',),
'bauta': ('bauta',),
'bautaen': ('bauta',),
'bautaer': ('bauta',),
'bautaene': ('bauta',),
'bautastein': ('bautastein',),
'bautasteinen': ('bautastein',),
'bautasteiner': ('bautastein',),
'bautasteinene': ('bautastein',),
'bauxitt': ('bauxitt',),
'bauxitten': ('bauxitt',),
'bauxitter': ('bauxitt',),
'bauxittene': ('bauxitt',),
'bavian': ('bavian',),
'bavianen': ('bavian',),
'bavianer': ('bavian',),
'bavianene': ('bavian',),
'baviansvakt': ('baviansvakt',),
'baviansvakten': ('baviansvakt',),
'baviansvakta': ('baviansvakt',),
'baviansvakter': ('baviansvakt',),
'baviansvaktene': ('baviansvakt',),
'bayer': ('bayer',),
'bayeren': ('bayer',),
'bayere': ('bayer',),
'bayerne': ('bayer',),
'bayerøl': ('bayerøl',),
'bayerølet': ('bayerøl',),
'bayerøl': ('bayerøl',),
'bayerøla': ('bayerøl',),
'bayonneskinke': ('bayonneskinke',),
'bayonneskinken': ('bayonneskinke',),
'bayonneskinka': ('bayonneskinke',),
'bayonneskinker': ('bayonneskinke',),
'bayonneskinkene': ('bayonneskinke',),
'bayrer': ('bayrer',),
'bayreren': ('bayrer',),
'bayrere': ('bayrer',),
'bayrerne': ('bayrer',),
'bazooka': ('bazooka',),
'bazookaen': ('bazooka',),
'bazookaer': ('bazooka',),
'bazookaene': ('bazooka',),
'be-bop': ('be-bop',),
'be-bopen': ('be-bop',),
'be-boper': ('be-bop',),
'be-bopene': ('be-bop',),
'bearbeidelse': ('bearbeidelse',),
'bearbeidelsen': ('bearbeidelse',),
'bearbeidelser': ('bearbeidelse',),
'bearbeidelsene': ('bearbeidelse',),
'bearbeiding': ('bearbeiding',),
'bearbeidingen': ('bearbeiding',),
'bearbeidinga': ('bearbeiding',),
'bearbeidinger': ('bearbeiding',),
'bearbeidingene': ('bearbeiding',),
'bearnés': ('bearnés',),
'bearnésen': ('bearnés',),
'bearnéser': ('bearnés',),
'bearnésene': ('bearnés',),
'bearnéssaus': ('bearnéssaus',),
'bearnéssausen': ('bearnéssaus',),
'bearnéssauser': ('bearnéssaus',),
'bearnéssausene': ('bearnéssaus',),
'beat': ('beat',),
'beaten': ('beat',),
'beater': ('beat',),
'beatene': ('beat',),
'beatmusikk': ('beatmusikk',),
'beatmusikken': ('beatmusikk',),
'beatmusikker': ('beatmusikk',),
'beatmusikkene': ('beatmusikk',),
'beatnik': ('beatnik',),
'beatniken': ('beatnik',),
'beatniker': ('beatnik',),
'beatnikene': ('beatnik',),
'beaufortskala': ('beaufortskala',),
'beaufortskalaen': ('beaufortskala',),
'beaufortskalaer': ('beaufortskala',),
'beaufortskalaene': ('beaufortskala',),
'beboelseshus': ('beboelseshus',),
'beboelseshuset': ('beboelseshus',),
'beboelseshus': ('beboelseshus',),
'beboelseshusa': ('beboelseshus',),
'beboelseshusene': ('beboelseshus',),
'beboer': ('beboer',),
'beboeren': ('beboer',),
'beboere': ('beboer',),
'beboerne': ('beboer',),
'bebreidelse': ('bebreidelse',),
'bebreidelsen': ('bebreidelse',),
'bebreidelser': ('bebreidelse',),
'bebreidelsene': ('bebreidelse',),
'bebudelse': ('bebudelse',),
'bebudelsen': ('bebudelse',),
'bebudelser': ('bebudelse',),
'bebudelsene': ('bebudelse',),
'bebudelsesdag': ('bebudelsesdag',),
'bebudelsesdagen': ('bebudelsesdag',),
'bebudelsesdager': ('bebudelsesdag',),
'bebudelsesdagene': ('bebudelsesdag',),
'bebyggelse': ('bebyggelse',),
'bebyggelsen': ('bebyggelse',),
'bebyggelser': ('bebyggelse',),
'bebyggelsene': ('bebyggelse',),
'becquerel': ('becquerel',),
'becquerelen': ('becquerel',),
'becquerel': ('becquerel',),
'becquerelene': ('becquerel',),
'bed': ('bed',),
'bedet': ('bed',),
'bed': ('bed',),
'beda': ('bed',),
'bedene': ('bed',),
'bedding': ('bedding',),
'beddingen': ('bedding',),
'beddinger': ('bedding',),
'beddingene': ('bedding',),
'bededag': ('bededag',),
'bededagen': ('bededag',),
'bededager': ('bededag',),
'bededagene': ('bededag',),
'bedehus': ('bedehus',),
'bedehuset': ('bedehus',),
'bedehus': ('bedehus',),
'bedehusa': ('bedehus',),
'bedehusene': ('bedehus',),
'bedehuskristendom': ('bedehuskristendom',),
'bedehuskristendommen': ('bedehuskristendom',),
'bedehuskristendommer': ('bedehuskristendom',),
'bedehuskristendommene': ('bedehuskristendom',),
'bedekker': ('bedekker',),
'bedekkeren': ('bedekker',),
'bedekkere': ('bedekker',),
'bedekkerne': ('bedekker',),
'bedekking': ('bedekking',),
'bedekkingen': ('bedekking',),
'bedekkinga': ('bedekking',),
'bedekkinger': ('bedekking',),
'bedekkingene': ('bedekking',),
'bedekning': ('bedekning',),
'bedekningen': ('bedekning',),
'bedekninga': ('bedekning',),
'bedekninger': ('bedekning',),
'bedekningene': ('bedekning',),
'bedemann': ('bedemann',),
'bedemannen': ('bedemann',),
'bedemenn': ('bedemann',),
'bedemennene': ('bedemann',),
'bedeskammel': ('bedeskammel',),
'bedeskammelen': ('bedeskammel',),
'bedeskammler': ('bedeskammel',),
'bedeskammlene': ('bedeskammel',),
'bedeteppe': ('bedeteppe',),
'bedeteppet': ('bedeteppe',),
'bedetepper': ('bedeteppe',),
'bedeteppa': ('bedeteppe',),
'bedeteppene': ('bedeteppe',),
'bedrag': ('bedrag',),
'bedraget': ('bedrag',),
'bedrag': ('bedrag',),
'bedraga': ('bedrag',),
'bedragene': ('bedrag',),
'bedrager': ('bedrager',),
'bedrageren': ('bedrager',),
'bedragere': ('bedrager',),
'bedragerne': ('bedrager',),
'bedrageri': ('bedrageri',),
'bedrageriet': ('bedrageri',),
'bedrageri': ('bedrageri',),
'bedragerier': ('bedrageri',),
'bedrageri': ('bedrageri',),
'bedragerier': ('bedrageri',),
'bedrageria': ('bedrageri',),
'bedrageriene': ('bedrageri',),
'bedreviten': ('bedreviten',),
'bedrevitenen': ('bedreviten',),
'bedrevitener': ('bedreviten',),
'bedrevitenene': ('bedreviten',),
'bedreviter': ('bedreviter',),
'bedreviteren': ('bedreviter',),
'bedrevitere': ('bedreviter',),
'bedreviterne': ('bedreviter',),
'bedrift': ('bedrift',),
'bedriften': ('bedrift',),
'bedrifter': ('bedrift',),
'bedriftene': ('bedrift',),
'bedriftsdemokrati': ('bedriftsdemokrati',),
'bedriftsdemokratiet': ('bedriftsdemokrati',),
'bedriftsdemokrati': ('bedriftsdemokrati',),
'bedriftsdemokratier': ('bedriftsdemokrati',),
'bedriftsdemokrati': ('bedriftsdemokrati',),
'bedriftsdemokratier': ('bedriftsdemokrati',),
'bedriftsdemokratia': ('bedriftsdemokrati',),
'bedriftsdemokratiene': ('bedriftsdemokrati',),
'bedriftsforsamling': ('bedriftsforsamling',),
'bedriftsforsamlingen': ('bedriftsforsamling',),
'bedriftsforsamlinga': ('bedriftsforsamling',),
'bedriftsforsamlinger': ('bedriftsforsamling',),
'bedriftsforsamlingene': ('bedriftsforsamling',),
'bedriftsidrett': ('bedriftsidrett',),
'bedriftsidretten': ('bedriftsidrett',),
'bedriftsidretter': ('bedriftsidrett',),
'bedriftsidrettene': ('bedriftsidrett',),
'bedriftsklubb': ('bedriftsklubb',),
'bedriftsklubben': ('bedriftsklubb',),
'bedriftsklubber': ('bedriftsklubb',),
'bedriftsklubbene': ('bedriftsklubb',),
'bedriftsledelse': ('bedriftsledelse',),
'bedriftsledelsen': ('bedriftsledelse',),
'bedriftsledelser': ('bedriftsledelse',),
'bedriftsledelsene': ('bedriftsledelse',),
'bedriftslege': ('bedriftslege',),
'bedriftslegen': ('bedriftslege',),
'bedriftsleger': ('bedriftslege',),
'bedriftslegene': ('bedriftslege',),
'bedriftsutvalg': ('bedriftsutvalg',),
'bedriftsutvalget': ('bedriftsutvalg',),
'bedriftsutvalg': ('bedriftsutvalg',),
'bedriftsutvalga': ('bedriftsutvalg',),
'bedriftsutvalgene': ('bedriftsutvalg',),
'bedriftsøkonom': ('bedriftsøkonom',),
'bedriftsøkonomen': ('bedriftsøkonom',),
'bedriftsøkonomer': ('bedriftsøkonom',),
'bedriftsøkonomene': ('bedriftsøkonom',),
'bedriftsøkonomi': ('bedriftsøkonomi',),
'bedriftsøkonomien': ('bedriftsøkonomi',),
'bedriftsøkonomier': ('bedriftsøkonomi',),
'bedriftsøkonomiene': ('bedriftsøkonomi',),
'bedring': ('bedring',),
'bedringen': ('bedring',),
'bedringa': ('bedring',),
'bedringer': ('bedring',),
'bedringene': ('bedring',),
'bedrøvelse': ('bedrøvelse',),
'bedrøvelsen': ('bedrøvelse',),
'bedrøvelser': ('bedrøvelse',),
'bedrøvelsene': ('bedrøvelse',),
'beduin': ('beduin',),
'beduinen': ('beduin',),
'beduiner': ('beduin',),
'beduinene': ('beduin',),
'bedårer': ('bedårer',),
'bedåreren': ('bedårer',),
'bedårere': ('bedårer',),
'bedårerne': ('bedårer',),
'bedømmelse': ('bedømmelse',),
'bedømmelsen': ('bedømmelse',),
'bedømmelser': ('bedømmelse',),
'bedømmelsene': ('bedømmelse',),
'bedøvelse': ('bedøvelse',),
'bedøvelsen': ('bedøvelse',),
'bedøvelser': ('bedøvelse',),
'bedøvelsene': ('bedøvelse',),
'bedøvelsesmiddel': ('bedøvelsesmiddel',),
'bedøvelsesmiddelet': ('bedøvelsesmiddel',),
'bedøvelsesmidlet': ('bedøvelsesmiddel',),
'bedøvelsesmiddel': ('bedøvelsesmiddel',),
'bedøvelsesmidler': ('bedøvelsesmiddel',),
'bedøvelsesmidla': ('bedøvelsesmiddel',),
'bedøvelsesmidlene': ('bedøvelsesmiddel',),
'bedøvelsesmidla': ('bedøvelsesmiddel',),
'bedøvelsesmidlene': ('bedøvelsesmiddel',),
'bedøvelsestilstand': ('bedøvelsestilstand',),
'bedøvelsestilstanden': ('bedøvelsestilstand',),
'bedøvelsestilstander': ('bedøvelsestilstand',),
'bedøvelsestilstandene': ('bedøvelsestilstand',),
'befal': ('befal',),
'befalet': ('befal',),
'befal': ('befal',),
'befala': ('befal',),
'befalene': ('befal',),
'befalhavende': ('befalhavende',),
'befaling': ('befaling',),
'befalingen': ('befaling',),
'befalinga': ('befaling',),
'befalinger': ('befaling',),
'befalingene': ('befaling',),
'befalingsmann': ('befalingsmann',),
'befalingsmannen': ('befalingsmann',),
'befalingsmenn': ('befalingsmann',),
'befalingsmennene': ('befalingsmann',),
'befalselev': ('befalselev',),
'befalseleven': ('befalselev',),
'befalselever': ('befalselev',),
'befalselevene': ('befalselev',),
'befalsgrad': ('befalsgrad',),
'befalsgraden': ('befalsgrad',),
'befalsgrader': ('befalsgrad',),
'befalsgradene': ('befalsgrad',),
'befalsskole': ('befalsskole',),
'befalsskolen': ('befalsskole',),
'befalsskoler': ('befalsskole',),
'befalsskolene': ('befalsskole',),
'befaring': ('befaring',),
'befaringen': ('befaring',),
'befaringa': ('befaring',),
'befaringer': ('befaring',),
'befaringene': ('befaring',),
'befatning': ('befatning',),
'befatningen': ('befatning',),
'befatninga': ('befatning',),
'befatninger': ('befatning',),
'befatningene': ('befatning',),
'befestningskunst': ('befestningskunst',),
'befestningskunsten': ('befestningskunst',),
'befestningskunster': ('befestningskunst',),
'befestningskunstene': ('befestningskunst',),
'befinnende': ('befinnende',),
'befippelse': ('befippelse',),
'befippelsen': ('befippelse',),
'befippelser': ('befippelse',),
'befippelsene': ('befippelse',),
'befolkning': ('befolkning',),
'befolkningen': ('befolkning',),
'befolkninga': ('befolkning',),
'befolkninger': ('befolkning',),
'befolkningene': ('befolkning',),
'befolkningseksplosjon': ('befolkningseksplosjon',),
'befolkningseksplosjonen': ('befolkningseksplosjon',),
'befolkningseksplosjoner': ('befolkningseksplosjon',),
'befolkningseksplosjonene': ('befolkningseksplosjon',),
'befolkningsgruppe': ('befolkningsgruppe',),
'befolkningsgruppen': ('befolkningsgruppe',),
'befolkningsgruppa': ('befolkningsgruppe',),
'befolkningsgrupper': ('befolkningsgruppe',),
'befolkningsgruppene': ('befolkningsgruppe',),
'befolkningskontroll': ('befolkningskontroll',),
'befolkningskontrollen': ('befolkningskontroll',),
'befolkningskontroller': ('befolkningskontroll',),
'befolkningskontrollene': ('befolkningskontroll',),
'befolkningspolitikk': ('befolkningspolitikk',),
'befolkningspolitikken': ('befolkningspolitikk',),
'befolkningspolitikker': ('befolkningspolitikk',),
'befolkningspolitikkene': ('befolkningspolitikk',),
'befolkningstetthet': ('befolkningstetthet',),
'befolkningstettheten': ('befolkningstetthet',),
'befolkningstettheta': ('befolkningstetthet',),
'befolkningstettheter': ('befolkningstetthet',),
'befolkningstetthetene': ('befolkningstetthet',),
'befolkningstilvekst': ('befolkningstilvekst',),
'befolkningstilveksten': ('befolkningstilvekst',),
'befolkningstilvekster': ('befolkningstilvekst',),
'befolkningstilvekstene': ('befolkningstilvekst',),
'befordring': ('befordring',),
'befordringen': ('befordring',),
'befordringa': ('befordring',),
'befordringer': ('befordring',),
'befordringene': ('befordring',),
'befordringsmiddel': ('befordringsmiddel',),
'befordringsmiddelet': ('befordringsmiddel',),
'befordringsmidlet': ('befordringsmiddel',),
'befordringsmiddel': ('befordringsmiddel',),
'befordringsmidler': ('befordringsmiddel',),
'befordringsmidla': ('befordringsmiddel',),
'befordringsmidlene': ('befordringsmiddel',),
'befordringsmidla': ('befordringsmiddel',),
'befordringsmidlene': ('befordringsmiddel',),
'befordringsmåte': ('befordringsmåte',),
'befordringsmåten': ('befordringsmåte',),
'befordringsmåter': ('befordringsmåte',),
'befordringsmåtene': ('befordringsmåte',),
'befrakter': ('befrakter',),
'befrakteren': ('befrakter',),
'befraktere': ('befrakter',),
'befrakterne': ('befrakter',),
'befraktning': ('befraktning',),
'befraktningen': ('befraktning',),
'befraktninga': ('befraktning',),
'befraktninger': ('befraktning',),
'befraktningene': ('befraktning',),
'befrielse': ('befrielse',),
'befrielsen': ('befrielse',),
'befrielser': ('befrielse',),
'befrielsene': ('befrielse',),
'befrielseskamp': ('befrielseskamp',),
'befrielseskampen': ('befrielseskamp',),
'befrielseskamper': ('befrielseskamp',),
'befrielseskampene': ('befrielseskamp',),
'befrielseskrig': ('befrielseskrig',),
'befrielseskrigen': ('befrielseskrig',),
'befrielseskriger': ('befrielseskrig',),
'befrielseskrigene': ('befrielseskrig',),
'befrier': ('befrier',),
'befrieren': ('befrier',),
'befriere': ('befrier',),
'befrierne': ('befrier',),
'befruktning': ('befruktning',),
'befruktningen': ('befruktning',),
'befruktninga': ('befruktning',),
'befruktninger': ('befruktning',),
'befruktningene': ('befruktning',),
'befruktningsevne': ('befruktningsevne',),
'befruktningsevnen': ('befruktningsevne',),
'befruktningsevna': ('befruktningsevne',),
'befruktningsevner': ('befruktningsevne',),
'befruktningsevnene': ('befruktningsevne',),
'befruktningsorgan': ('befruktningsorgan',),
'befruktningsorganet': ('befruktningsorgan',),
'befruktningsorgan': ('befruktningsorgan',),
'befruktningsorganer': ('befruktningsorgan',),
'befruktningsorgan': ('befruktningsorgan',),
'befruktningsorganer': ('befruktningsorgan',),
'befruktningsorgana': ('befruktningsorgan',),
'befruktningsorganene': ('befruktningsorgan',),
'begavelse': ('begavelse',),
'begavelsen': ('begavelse',),
'begavelser': ('begavelse',),
'begavelsene': ('begavelse',),
'begeistring': ('begeistring',),
'begeistringen': ('begeistring',),
'begeistringa': ('begeistring',),
'begeistringer': ('begeistring',),
'begeistringene': ('begeistring',),
'begeistringsbølge': ('begeistringsbølge',),
'begeistringsbølgen': ('begeistringsbølge',),
'begeistringsbølga': ('begeistringsbølge',),
'begeistringsbølger': ('begeistringsbølge',),
'begeistringsbølgene': ('begeistringsbølge',),
'begeistringsrus': ('begeistringsrus',),
'begeistringsrusen': ('begeistringsrus',),
'begeistringsruser': ('begeistringsrus',),
'begeistringsrusene': ('begeistringsrus',),
'beger': ('beger',),
'begeret': ('beger',),
'beger': ('beger',),
'begre': ('beger',),
'begra': ('beger',),
'begrene': ('beger',),
'begra': ('beger',),
'begrene': ('beger',),
'begerblad': ('begerblad',),
'begerbladet': ('begerblad',),
'begerblad': ('begerblad',),
'begerblader': ('begerblad',),
'begerblad': ('begerblad',),
'begerblader': ('begerblad',),
'begerblada': ('begerblad',),
'begerbladene': ('begerblad',),
'begerglass': ('begerglass',),
'begerglasset': ('begerglass',),
'begerglass': ('begerglass',),
'begerglassa': ('begerglass',),
'begerglassene': ('begerglass',),
'begersvinger': ('begersvinger',),
'begersvingeren': ('begersvinger',),
'begersvingere': ('begersvinger',),
'begersvingerne': ('begersvinger',),
'begivenhet': ('begivenhet',),
'begivenheten': ('begivenhet',),
'begivenheta': ('begivenhet',),
'begivenheter': ('begivenhet',),
'begivenhetene': ('begivenhet',),
'begjær': ('begjær',),
'begjæret': ('begjær',),
'begjær': ('begjær',),
'begjæra': ('begjær',),
'begjærene': ('begjær',),
'begjæring': ('begjæring',),
'begjæringen': ('begjæring',),
'begjæringa': ('begjæring',),
'begjæringer': ('begjæring',),
'begjæringene': ('begjæring',),
'begonia': ('begonia',),
'begoniaen': ('begonia',),
'begoniaer': ('begonia',),
'begonier': ('begonia',),
'begoniaene': ('begonia',),
'begoniene': ('begonia',),
'begravelse': ('begravelse',),
'begravelsen': ('begravelse',),
'begravelser': ('begravelse',),
'begravelsene': ('begravelse',),
'begravelsesbyrå': ('begravelsesbyrå',),
'begravelsesbyrået': ('begravelsesbyrå',),
'begravelsesbyrå': ('begravelsesbyrå',),
'begravelsesbyråer': ('begravelsesbyrå',),
'begravelsesbyrå': ('begravelsesbyrå',),
'begravelsesbyråer': ('begravelsesbyrå',),
'begravelsesbyråa': ('begravelsesbyrå',),
'begravelsesbyråene': ('begravelsesbyrå',),
'begrensning': ('begrensning',),
'begrensningen': ('begrensning',),
'begrensninga': ('begrensning',),
'begrensninger': ('begrensning',),
'begrensningene': ('begrensning',),
'begrep': ('begrep',),
'begrepet': ('begrep',),
'begrep': ('begrep',),
'begreper': ('begrep',),
'begrep': ('begrep',),
'begreper': ('begrep',),
'begrepa': ('begrep',),
'begrepene': ('begrep',),
'begrepsapparat': ('begrepsapparat',),
'begrepsapparatet': ('begrepsapparat',),
'begrepsapparat': ('begrepsapparat',),
'begrepsapparater': ('begrepsapparat',),
'begrepsapparat': ('begrepsapparat',),
'begrepsapparater': ('begrepsapparat',),
'begrepsapparata': ('begrepsapparat',),
'begrepsapparatene': ('begrepsapparat',),
'begrepsforveksling': ('begrepsforveksling',),
'begrepsforvekslingen': ('begrepsforveksling',),
'begrepsforvekslinga': ('begrepsforveksling',),
'begrepsforvekslinger': ('begrepsforveksling',),
'begrepsforvekslingene': ('begrepsforveksling',),
'begrepsforvirring': ('begrepsforvirring',),
'begrepsforvirringen': ('begrepsforvirring',),
'begrepsforvirringa': ('begrepsforvirring',),
'begrepsforvirringer': ('begrepsforvirring',),
'begrepsforvirringene': ('begrepsforvirring',),
'begrepsinnhold': ('begrepsinnhold',),
'begrepsinnholdet': ('begrepsinnhold',),
'begrepsinnhold': ('begrepsinnhold',),
'begrepsinnholda': ('begrepsinnhold',),
'begrepsinnholdene': ('begrepsinnhold',),
'begrepsnyanse': ('begrepsnyanse',),
'begrepsnyansen': ('begrepsnyanse',),
'begrepsnyanser': ('begrepsnyanse',),
'begrepsnyansene': ('begrepsnyanse',),
'begrepsomfang': ('begrepsomfang',),
'begrepsomfanget': ('begrepsomfang',),
'begrepsomfang': ('begrepsomfang',),
'begrepsomfanga': ('begrepsomfang',),
'begrepsomfangene': ('begrepsomfang',),
'begroning': ('begroning',),
'begroningen': ('begroning',),
'begroninga': ('begroning',),
'begroninger': ('begroning',),
'begroningene': ('begroning',),
'begrunnelse': ('begrunnelse',),
'begrunnelsen': ('begrunnelse',),
'begrunnelser': ('begrunnelse',),
'begrunnelsene': ('begrunnelse',),
'beguine': ('beguine',),
'beguinen': ('beguine',),
'beguiner': ('beguine',),
'beguinene': ('beguine',),
'begynnelse': ('begynnelse',),
'begynnelsen': ('begynnelse',),
'begynnelser': ('begynnelse',),
'begynnelsene': ('begynnelse',),
'begynnelsesgrunner': ('begynnelsesgrunner',),
'begynnelsesgrunnene': ('begynnelsesgrunner',),
'begynnelseshastighet': ('begynnelseshastighet',),
'begynnelseshastigheten': ('begynnelseshastighet',),
'begynnelseshastigheta': ('begynnelseshastighet',),
'begynnelseshastigheter': ('begynnelseshastighet',),
'begynnelseshastighetene': ('begynnelseshastighet',),
'begynnelsesstadium': ('begynnelsesstadium',),
'begynnelsesstadiet': ('begynnelsesstadium',),
'begynnelsesstadier': ('begynnelsesstadium',),
'begynnelsesstadia': ('begynnelsesstadium',),
'begynnelsesstadiene': ('begynnelsesstadium',),
'begynner': ('begynner',),
'begynneren': ('begynner',),
'begynnere': ('begynner',),
'begynnerne': ('begynner',),
'begynnerfeil': ('begynnerfeil',),
'begynnerfeilen': ('begynnerfeil',),
'begynnerfeil': ('begynnerfeil',),
'begynnerfeila': ('begynnerfeil',),
'begynnerfeilene': ('begynnerfeil',),
'begynnergasje': ('begynnergasje',),
'begynnergasjen': ('begynnergasje',),
'begynnergasjer': ('begynnergasje',),
'begynnergasjene': ('begynnergasje',),
'begynnerklasse': ('begynnerklasse',),
'begynnerklassen': ('begynnerklasse',),
'begynnerklassa': ('begynnerklasse',),
'begynnerklasser': ('begynnerklasse',),
'begynnerklassene': ('begynnerklasse',),
'begynnerlønn': ('begynnerlønn',),
'begynnerlønnen': ('begynnerlønn',),
'begynnerlønna': ('begynnerlønn',),
'begynnerlønner': ('begynnerlønn',),
'begynnerlønnene': ('begynnerlønn',),
'begynnerstadium': ('begynnerstadium',),
'begynnerstadiet': ('begynnerstadium',),
'begynnerstadier': ('begynnerstadium',),
'begynnerstadia': ('begynnerstadium',),
'begynnerstadiene': ('begynnerstadium',),
'begynnervanske': ('begynnervanske',),
'begynnervansken': ('begynnervanske',),
'begynnervansker': ('begynnervanske',),
'begynnervanskene': ('begynnervanske',),
'begynnervanskelighet': ('begynnervanskelighet',),
'begynnervanskeligheten': ('begynnervanskelighet',),
'begynnervanskeligheta': ('begynnervanskelighet',),
'begynnervanskeligheter': ('begynnervanskelighet',),
'begynnervanskelighetene': ('begynnervanskelighet',),
'behag': ('behag',),
'behaget': ('behag',),
'behag': ('behag',),
'behaga': ('behag',),
'behagene': ('behag',),
'behandler': ('behandler',),
'behandleren': ('behandler',),
'behandlere': ('behandler',),
'behandlerne': ('behandler',),
'behandling': ('behandling',),
'behandlingen': ('behandling',),
'behandlinga': ('behandling',),
'behandlinger': ('behandling',),
'behandlingene': ('behandling',),
'behandlingsheim': ('behandlingsheim',),
'behandlingsheimen': ('behandlingsheim',),
'behandlingsheimer': ('behandlingsheim',),
'behandlingsheimene': ('behandlingsheim',),
'behandlingshjem': ('behandlingshjem',),
'behandlingshjemmet': ('behandlingshjem',),
'behandlingshjem': ('behandlingshjem',),
'behandlingshjemma': ('behandlingshjem',),
'behandlingshjemmene': ('behandlingshjem',),
'behandlingsmåte': ('behandlingsmåte',),
'behandlingsmåten': ('behandlingsmåte',),
'behandlingsmåter': ('behandlingsmåte',),
'behandlingsmåtene': ('behandlingsmåte',),
'behandlingstilbud': ('behandlingstilbud',),
'behandlingstilbudet': ('behandlingstilbud',),
'behandlingstilbud': ('behandlingstilbud',),
'behandlingstilbuda': ('behandlingstilbud',),
'behandlingstilbudene': ('behandlingstilbud',),
'behaviorisme': ('behaviorisme',),
'behaviorismen': ('behaviorisme',),
'behaviorismer': ('behaviorisme',),
'behaviorismene': ('behaviorisme',),
'behaviorist': ('behaviorist',),
'behavioristen': ('behaviorist',),
'behaviorister': ('behaviorist',),
'behavioristene': ('behaviorist',),
'beheng': ('beheng',),
'behenget': ('beheng',),
'beheng': ('beheng',),
'behenga': ('beheng',),
'behengene': ('beheng',),
'beherskelse': ('beherskelse',),
'beherskelsen': ('beherskelse',),
'beherskelser': ('beherskelse',),
'beherskelsene': ('beherskelse',),
'behold': ('behold',),
'beholder': ('beholder',),
'beholderen': ('beholder',),
'beholdere': ('beholder',),
'beholderne': ('beholder',),
'beholdning': ('beholdning',),
'beholdningen': ('beholdning',),
'beholdninga': ('beholdning',),
'beholdninger': ('beholdning',),
'beholdningene': ('beholdning',),
'behov': ('behov',),
'behovet': ('behov',),
'behov': ('behov',),
'behova': ('behov',),
'behovene': ('behov',),
'behovsanalyse': ('behovsanalyse',),
'behovsanalysen': ('behovsanalyse',),
'behovsanalyser': ('behovsanalyse',),
'behovsanalysene': ('behovsanalyse',),
'behovsprøving': ('behovsprøving',),
'behovsprøvingen': ('behovsprøving',),
'behovsprøvinga': ('behovsprøving',),
'behovsprøvinger': ('behovsprøving',),
'behovsprøvingene': ('behovsprøving',),
'behå': ('behå',),
'behåen': ('behå',),
'behåer': ('behå',),
'behåene': ('behå',),
'behåring': ('behåring',),
'behåringen': ('behåring',),
'behåringa': ('behåring',),
'behåringer': ('behåring',),
'behåringene': ('behåring',),
'beiler': ('beiler',),
'beileren': ('beiler',),
'beilere': ('beiler',),
'beilerne': ('beiler',),
'bein': ('bein',),
'beinet': ('bein',),
'bein': ('bein',),
'beina': ('bein',),
'beinene': ('bein',),
'beinarbeid': ('beinarbeid',),
'beinarbeidet': ('beinarbeid',),
'beinarbeid': ('beinarbeid',),
'beinarbeider': ('beinarbeid',),
'beinarbeid': ('beinarbeid',),
'beinarbeider': ('beinarbeid',),
'beinarbeida': ('beinarbeid',),
'beinarbeidene': ('beinarbeid',),
'beinbetennelse': ('beinbetennelse',),
'beinbetennelsen': ('beinbetennelse',),
'beinbetennelser': ('beinbetennelse',),
'beinbetennelsene': ('beinbetennelse',),
'beinbrudd': ('beinbrudd',),
'beinbruddet': ('beinbrudd',),
'beinbrudd': ('beinbrudd',),
'beinbrudda': ('beinbrudd',),
'beinbruddene': ('beinbrudd',),
'beinbygning': ('beinbygning',),
'beinbygningen': ('beinbygning',),
'beinbygninga': ('beinbygning',),
'beinbygninger': ('beinbygning',),
'beinbygningene': ('beinbygning',),
'beinfisk': ('beinfisk',),
'beinfisken': ('beinfisk',),
'beinfisker': ('beinfisk',),
'beinfiskene': ('beinfisk',),
'beingrind': ('beingrind',),
'beingrinden': ('beingrind',),
'beingrinda': ('beingrind',),
'beingrinder': ('beingrind',),
'beingrindene': ('beingrind',),
'beinklær': ('beinklær',),
'beinklærne': ('beinklær',),
'beinkrok': ('beinkrok',),
'beinkroken': ('beinkrok',),
'beinkroker': ('beinkrok',),
'beinkrokene': ('beinkrok',),
'beinlim': ('beinlim',),
'beinlimet': ('beinlim',),
'beinlim': ('beinlim',),
'beinlima': ('beinlim',),
'beinlimene': ('beinlim',),
'beinmarg': ('beinmarg',),
'beinmargen': ('beinmarg',),
'beinmarger': ('beinmarg',),
'beinmargene': ('beinmarg',),
'beinmel': ('beinmel',),
'beinmelet': ('beinmel',),
'beinmel': ('beinmel',),
'beinmela': ('beinmel',),
'beinmelene': ('beinmel',),
'beinmjøl': ('beinmjøl',),
'beinmjølet': ('beinmjøl',),
'beinmjøl': ('beinmjøl',),
'beinmjøla': ('beinmjøl',),
'beinmjølene': ('beinmjøl',),
'beinpipe': ('beinpipe',),
'beinpipen': ('beinpipe',),
'beinpipa': ('beinpipe',),
'beinpiper': ('beinpipe',),
'beinpipene': ('beinpipe',),
'beinrangel': ('beinrangel',),
'beinrangelet': ('beinrangel',),
'beinranglet': ('beinrangel',),
'beinrangel': ('beinrangel',),
'beinrangler': ('beinrangel',),
'beinrangla': ('beinrangel',),
'beinranglene': ('beinrangel',),
'beinrangla': ('beinrangel',),
'beinranglene': ('beinrangel',),
'beinskurd': ('beinskurd',),
'beinskurden': ('beinskurd',),
'beinskurder': ('beinskurd',),
'beinskurdene': ('beinskurd',),
'beinsplint': ('beinsplint',),
'beinsplinten': ('beinsplint',),
'beinsplinter': ('beinsplint',),
'beinsplintene': ('beinsplint',),
'beinsubstans': ('beinsubstans',),
'beinsubstansen': ('beinsubstans',),
'beinsubstanser': ('beinsubstans',),
'beinsubstansene': ('beinsubstans',),
'beinved': ('beinved',),
'beinveden': ('beinved',),
'beinveder': ('beinved',),
'beinvedene': ('beinved',),
'beinveg': ('beinveg',),
'beinvegen': ('beinveg',),
'beinveger': ('beinveg',),
'beinvegene': ('beinveg',),
'beinvei': ('beinvei',),
'beinveien': ('beinvei',),
'beinveier': ('beinvei',),
'beinveiene': ('beinvei',),
'beinvev': ('beinvev',),
'beinvevet': ('beinvev',),
'beinvev': ('beinvev',),
'beinveva': ('beinvev',),
'beinvevene': ('beinvev',),
'beis': ('beis',),
'beisen': ('beis',),
'beiser': ('beis',),
'beisene': ('beis',),
'beist': ('beist',),
'beistet': ('beist',),
'beist': ('beist',),
'beista': ('beist',),
'beistene': ('beist',),
'beit': ('beit',),
'beiten': ('beit',),
'beita': ('beit',),
'beiter': ('beit',),
'beitene': ('beit',),
'beite': ('beite',),
'beitet': ('beite',),
'beiter': ('beite',),
'beita': ('beite',),
'beitene': ('beite',),
'beite': ('beite',),
'beiten': ('beite',),
'beita': ('beite',),
'beiter': ('beite',),
'beitene': ('beite',),
'beitebruk': ('beitebruk',),
'beitebruket': ('beitebruk',),
'beitebruk': ('beitebruk',),
'beitebruka': ('beitebruk',),
'beitebrukene': ('beitebruk',),
'beitedrift': ('beitedrift',),
'beitedriften': ('beitedrift',),
'beitedrifta': ('beitedrift',),
'beitedrifter': ('beitedrift',),
'beitedriftene': ('beitedrift',),
'beitedyr': ('beitedyr',),
'beitedyret': ('beitedyr',),
'beitedyr': ('beitedyr',),
'beitedyra': ('beitedyr',),
'beitedyrene': ('beitedyr',),
'beitegras': ('beitegras',),
'beitegraset': ('beitegras',),
'beitegras': ('beitegras',),
'beitegrasa': ('beitegras',),
'beitegrasene': ('beitegras',),
'beitegress': ('beitegress',),
'beitegresset': ('beitegress',),
'beitegress': ('beitegress',),
'beitegressa': ('beitegress',),
'beitegressene': ('beitegress',),
'beitekonsulent': ('beitekonsulent',),
'beitekonsulenten': ('beitekonsulent',),
'beitekonsulenter': ('beitekonsulent',),
'beitekonsulentene': ('beitekonsulent',),
'beitel': ('beitel',),
'beitelen': ('beitel',),
'beitler': ('beitel',),
'beitlene': ('beitel',),
'beitemakk': ('beitemakk',),
'beitemakken': ('beitemakk',),
'beitemakker': ('beitemakk',),
'beitemakkene': ('beitemakk',),
'beitemark': ('beitemark',),
'beitemarken': ('beitemark',),
'beitemarka': ('beitemark',),
'beitemarker': ('beitemark',),
'beitemarkene': ('beitemark',),
'beiteområde': ('beiteområde',),
'beiteområdet': ('beiteområde',),
'beiteområder': ('beiteområde',),
'beiteområda': ('beiteområde',),
'beiteområdene': ('beiteområde',),
'beiterett': ('beiterett',),
'beiteretten': ('beiterett',),
'beiteretter': ('beiterett',),
'beiterettene': ('beiterett',),
'beiteslepp': ('beiteslepp',),
'beitesleppet': ('beiteslepp',),
'beiteslepp': ('beiteslepp',),
'beitesleppa': ('beiteslepp',),
'beitesleppene': ('beiteslepp',),
'beiteslipp': ('beiteslipp',),
'beiteslippet': ('beiteslipp',),
'beiteslipp': ('beiteslipp',),
'beiteslippa': ('beiteslipp',),
'beiteslippene': ('beiteslipp',),
'bek': ('bek',),
'beket': ('bek',),
'bek': ('bek',),
'beka': ('bek',),
'bekene': ('bek',),
'bekblende': ('bekblende',),
'bekblenden': ('bekblende',),
'bekblender': ('bekblende',),
'bekblendene': ('bekblende',),
'bekjempelse': ('bekjempelse',),
'bekjempelsen': ('bekjempelse',),
'bekjempelser': ('bekjempelse',),
'bekjempelsene': ('bekjempelse',),
'bekjemping': ('bekjemping',),
'bekjempingen': ('bekjemping',),
'bekjempinga': ('bekjemping',),
'bekjempinger': ('bekjemping',),
'bekjempingene': ('bekjemping',),
'bekjennelse': ('bekjennelse',),
'bekjennelsen': ('bekjennelse',),
'bekjennelser': ('bekjennelse',),
'bekjennelsene': ('bekjennelse',),
'bekjennelseskirke': ('bekjennelseskirke',),
'bekjennelseskirken': ('bekjennelseskirke',),
'bekjennelseskirka': ('bekjennelseskirke',),
'bekjennelseskirker': ('bekjennelseskirke',),
'bekjennelseskirkene': ('bekjennelseskirke',),
'bekjennelsesskrift': ('bekjennelsesskrift',),
'bekjennelsesskriftet': ('bekjennelsesskrift',),
'bekjennelsesskrift': ('bekjennelsesskrift',),
'bekjennelsesskrifter': ('bekjennelsesskrift',),
'bekjennelsesskrift': ('bekjennelsesskrift',),
'bekjennelsesskrifter': ('bekjennelsesskrift',),
'bekjennelsesskrifta': ('bekjennelsesskrift',),
'bekjennelsesskriftene': ('bekjennelsesskrift',),
'bekjentgjørelse': ('bekjentgjørelse',),
'bekjentgjørelsen': ('bekjentgjørelse',),
'bekjentgjørelser': ('bekjentgjørelse',),
'bekjentgjørelsene': ('bekjentgjørelse',),
'bekjentskap': ('bekjentskap',),
'bekjentskapet': ('bekjentskap',),
'bekjentskap': ('bekjentskap',),
'bekjentskaper': ('bekjentskap',),
'bekjentskap': ('bekjentskap',),
'bekjentskaper': ('bekjentskap',),
'bekjentskapa': ('bekjentskap',),
'bekjentskapene': ('bekjentskap',),
'bekjentskapskrets': ('bekjentskapskrets',),
'bekjentskapskretsen': ('bekjentskapskrets',),
'bekjentskapskretser': ('bekjentskapskrets',),
'bekjentskapskretsene': ('bekjentskapskrets',),
'bekk': ('bekk',),
'bekken': ('bekk',),
'bekker': ('bekk',),
'bekkene': ('bekk',),
'bekkasin': ('bekkasin',),
'bekkasinen': ('bekkasin',),
'bekkasiner': ('bekkasin',),
'bekkasinene': ('bekkasin',),
'bekkeblom': ('bekkeblom',),
'bekkeblommen': ('bekkeblom',),
'bekkeblommer': ('bekkeblom',),
'bekkeblommene': ('bekkeblom',),
'bekkefar': ('bekkefar',),
'bekkefaret': ('bekkefar',),
'bekkefar': ('bekkefar',),
'bekkefara': ('bekkefar',),
'bekkefarene': ('bekkefar',),
'bekkekvern': ('bekkekvern',),
'bekkekvernen': ('bekkekvern',),
'bekkekverna': ('bekkekvern',),
'bekkekverner': ('bekkekvern',),
'bekkekvernene': ('bekkekvern',),
'bekken': ('bekken',),
'bekkenet': ('bekken',),
'bekken': ('bekken',),
'bekkener': ('bekken',),
'bekken': ('bekken',),
'bekkener': ('bekken',),
'bekkena': ('bekken',),
'bekkenene': ('bekken',),
'bekkenbein': ('bekkenbein',),
'bekkenbeinet': ('bekkenbein',),
'bekkenbein': ('bekkenbein',),
'bekkenbeina': ('bekkenbein',),
'bekkenbeinene': ('bekkenbein',),
'bekkenben': ('bekkenben',),
'bekkenbenet': ('bekkenben',),
'bekkenben': ('bekkenben',),
'bekkenbena': ('bekkenben',),
'bekkenbenene': ('bekkenben',),
'bekkenhole': ('bekkenhole',),
'bekkenholen': ('bekkenhole',),
'bekkenhola': ('bekkenhole',),
'bekkenholer': ('bekkenhole',),
'bekkenholene': ('bekkenhole',),
'bekkenhule': ('bekkenhule',),
'bekkenhulen': ('bekkenhule',),
'bekkenhula': ('bekkenhule',),
'bekkenhuler': ('bekkenhule',),
'bekkenhulene': ('bekkenhule',),
'bekkenløsning': ('bekkenløsning',),
'bekkenløsningen': ('bekkenløsning',),
'bekkenløsninga': ('bekkenløsning',),
'bekkenløsninger': ('bekkenløsning',),
'bekkenløsningene': ('bekkenløsning',),
'bekkenløysing': ('bekkenløysing',),
'bekkenløysingen': ('bekkenløysing',),
'bekkenløysinga': ('bekkenløysing',),
'bekkenløysinger': ('bekkenløysing',),
'bekkenløysingene': ('bekkenløysing',),
'bekkeos': ('bekkeos',),
'bekkeosen': ('bekkeos',),
'bekkeoset': ('bekkeos',),
'bekkeoser': ('bekkeos',),
'bekkeos': ('bekkeos',),
'bekkeosene': ('bekkeos',),
'bekkeosa': ('bekkeos',),
'bekkeosene': ('bekkeos',),
'bekkesig': ('bekkesig',),
'bekkesiget': ('bekkesig',),
'bekkesig': ('bekkesig',),
'bekkesiga': ('bekkesig',),
'bekkesigene': ('bekkesig',),
'bekkesilder': ('bekkesilder',),
'bekkesilderet': ('bekkesilder',),
'bekkesildret': ('bekkesilder',),
'bekkesilder': ('bekkesilder',),
'bekkesildre': ('bekkesilder',),
'bekkesildra': ('bekkesilder',),
'bekkesildrene': ('bekkesilder',),
'bekkesildra': ('bekkesilder',),
'bekkesildrene': ('bekkesilder',),
'bekkesildre': ('bekkesildre',),
'bekkesildren': ('bekkesildre',),
'bekkesildra': ('bekkesildre',),
'bekkesildrer': ('bekkesildre',),
'bekkesildrene': ('bekkesildre',),
'beklagelse': ('beklagelse',),
'beklagelsen': ('beklagelse',),
'beklagelser': ('beklagelse',),
'beklagelsene': ('beklagelse',),
'bekledning': ('bekledning',),
'bekledningen': ('bekledning',),
'bekledninga': ('bekledning',),
'bekledninger': ('bekledning',),
'bekledningene': ('bekledning',),
'bekledningsgjenstand': ('bekledningsgjenstand',),
'bekledningsgjenstanden': ('bekledningsgjenstand',),
'bekledningsgjenstander': ('bekledningsgjenstand',),
'bekledningsgjenstandene': ('bekledningsgjenstand',),
'bekledningsindustri': ('bekledningsindustri',),
'bekledningsindustrien': ('bekledningsindustri',),
'bekledningsindustrier': ('bekledningsindustri',),
'bekledningsindustriene': ('bekledningsindustri',),
'beklemmelse': ('beklemmelse',),
'beklemmelsen': ('beklemmelse',),
'beklemmelser': ('beklemmelse',),
'beklemmelsene': ('beklemmelse',),
'bekmørke': ('bekmørke',),
'bekmørket': ('bekmørke',),
'bekmørker': ('bekmørke',),
'bekmørka': ('bekmørke',),
'bekmørkene': ('bekmørke',),
'beknip': ('beknip',),
'bekomst': ('bekomst',),
'bekomsten': ('bekomst',),
'bekomster': ('bekomst',),
'bekomstene': ('bekomst',),
'bekostning': ('bekostning',),
'bekostningen': ('bekostning',),
'bekostninga': ('bekostning',),
'bekostninger': ('bekostning',),
'bekostningene': ('bekostning',),
'bekransning': ('bekransning',),
'bekransningen': ('bekransning',),
'bekransninga': ('bekransning',),
'bekransninger': ('bekransning',),
'bekransningene': ('bekransning',),
'bekreftelse': ('bekreftelse',),
'bekreftelsen': ('bekreftelse',),
'bekreftelser': ('bekreftelse',),
'bekreftelsene': ('bekreftelse',),
'bekselring': ('bekselring',),
'bekselringen': ('bekselring',),
'bekselringer': ('bekselring',),
'bekselringene': ('bekselring',),
'bekstein': ('bekstein',),
'beksteinen': ('bekstein',),
'beksteiner': ('bekstein',),
'beksteinene': ('bekstein',),
'beksøm': ('beksøm',),
'beksømmen': ('beksøm',),
'beksømmer': ('beksøm',),
'beksømmene': ('beksøm',),
'beksømsko': ('beksømsko',),
'beksømskoen': ('beksømsko',),
'beksømsko': ('beksømsko',),
'beksømskoa': ('beksømsko',),
'beksømskoene': ('beksømsko',),
'beksømstøvel': ('beksømstøvel',),
'beksømstøvelen': ('beksømstøvel',),
'beksømstøvler': ('beksømstøvel',),
'beksømstøvlene': ('beksømstøvel',),
'bektråd': ('bektråd',),
'bektråden': ('bektråd',),
'bektråder': ('bektråd',),
'bektrådene': ('bektråd',),
'bekvemmelighet': ('bekvemmelighet',),
'bekvemmeligheten': ('bekvemmelighet',),
'bekvemmeligheta': ('bekvemmelighet',),
'bekvemmeligheter': ('bekvemmelighet',),
'bekvemmelighetene': ('bekvemmelighet',),
'bekvemmelighetsflagg': ('bekvemmelighetsflagg',),
'bekvemmelighetsflagget': ('bekvemmelighetsflagg',),
'bekvemmelighetsflagg': ('bekvemmelighetsflagg',),
'bekvemmelighetsflagga': ('bekvemmelighetsflagg',),
'bekvemmelighetsflaggene': ('bekvemmelighetsflagg',),
'bekvemmelighetshensyn': ('bekvemmelighetshensyn',),
'bekvemmelighetshensynet': ('bekvemmelighetshensyn',),
'bekvemmelighetshensyn': ('bekvemmelighetshensyn',),
'bekvemmelighetshensyna': ('bekvemmelighetshensyn',),
'bekvemmelighetshensynene': ('bekvemmelighetshensyn',),
'bekymring': ('bekymring',),
'bekymringen': ('bekymring',),
'bekymringa': ('bekymring',),
'bekymringer': ('bekymring',),
'bekymringene': ('bekymring',),
'bel': ('bel',),
'belen': ('bel',),
'bel': ('bel',),
'belene': ('bel',),
'bel canto': ('bel canto',),
'bel cantoen': ('bel canto',),
'bel cantoer': ('bel canto',),
'bel cantoene': ('bel canto',),
'belastning': ('belastning',),
'belastningen': ('belastning',),
'belastninga': ('belastning',),
'belastninger': ('belastning',),
'belastningene': ('belastning',),
'belastningsprøve': ('belastningsprøve',),
'belastningsprøven': ('belastningsprøve',),
'belastningsprøva': ('belastningsprøve',),
'belastningsprøver': ('belastningsprøve',),
'belastningsprøvene': ('belastningsprøve',),
'belastningssjukdom': ('belastningssjukdom',),
'belastningssjukdommen': ('belastningssjukdom',),
'belastningssjukdommer': ('belastningssjukdom',),
'belastningssjukdommene': ('belastningssjukdom',),
'belastningssykdom': ('belastningssykdom',),
'belastningssykdommen': ('belastningssykdom',),
'belastningssykdommer': ('belastningssykdom',),
'belastningssykdommene': ('belastningssykdom',),
'belegg': ('belegg',),
'belegget': ('belegg',),
'belegg': ('belegg',),
'belegga': ('belegg',),
'beleggene': ('belegg',),
'beleggdannelse': ('beleggdannelse',),
'beleggdannelsen': ('beleggdannelse',),
'beleggdannelser': ('beleggdannelse',),
'beleggdannelsene': ('beleggdannelse',),
'beleggdanning': ('beleggdanning',),
'beleggdanningen': ('beleggdanning',),
'beleggdanninga': ('beleggdanning',),
'beleggdanninger': ('beleggdanning',),
'beleggdanningene': ('beleggdanning',),
'beleiring': ('beleiring',),
'beleiringen': ('beleiring',),
'beleiringa': ('beleiring',),
'beleiringer': ('beleiring',),
'beleiringene': ('beleiring',),
'beleiringstilstand': ('beleiringstilstand',),
'beleiringstilstanden': ('beleiringstilstand',),
'beleiringstilstander': ('beleiringstilstand',),
'beleiringstilstandene': ('beleiringstilstand',),
'belg': ('belg',),
'belgen': ('belg',),
'belger': ('belg',),
'belgene': ('belg',),
'belgetreder': ('belgetreder',),
'belgetrederen': ('belgetreder',),
'belgetredere': ('belgetreder',),
'belgetrederne': ('belgetreder',),
'belgfrukt': ('belgfrukt',),
'belgfrukten': ('belgfrukt',),
'belgfrukta': ('belgfrukt',),
'belgfrukter': ('belgfrukt',),
'belgfruktene': ('belgfrukt',),
'belgier': ('belgier',),
'belgieren': ('belgier',),
'belgiere': ('belgier',),
'belgierne': ('belgier',),
'belgkapsel': ('belgkapsel',),
'belgkapselen': ('belgkapsel',),
'belgkapsler': ('belgkapsel',),
'belgkapslene': ('belgkapsel',),
'belgmørke': ('belgmørke',),
'belgmørket': ('belgmørke',),
'belgmørker': ('belgmørke',),
'belgmørka': ('belgmørke',),
'belgmørkene': ('belgmørke',),
'belgplante': ('belgplante',),
'belgplanten': ('belgplante',),
'belgplanta': ('belgplante',),
'belgplanter': ('belgplante',),
'belgplantene': ('belgplante',),
'belgtreder': ('belgtreder',),
'belgtrederen': ('belgtreder',),
'belgtredere': ('belgtreder',),
'belgtrederne': ('belgtreder',),
'beliggenhet': ('beliggenhet',),
'beliggenheten': ('beliggenhet',),
'beliggenheta': ('beliggenhet',),
'beliggenheter': ('beliggenhet',),
'beliggenhetene': ('beliggenhet',),
'belizer': ('belizer',),
'belizeren': ('belizer',),
'belizere': ('belizer',),
'belizerne': ('belizer',),
'belj': ('belj',),
'beljen': ('belj',),
'beljet': ('belj',),
'belj': ('belj',),
'beljene': ('belj',),
'belja': ('belj',),
'beljene': ('belj',),
'belladonna': ('belladonna',),
'belladonnaen': ('belladonna',),
'belladonnaer': ('belladonna',),
'belladonnaene': ('belladonna',),
'belladonnablad': ('belladonnablad',),
'belladonnabladet': ('belladonnablad',),
'belladonnablad': ('belladonnablad',),
'belladonnablader': ('belladonnablad',),
'belladonnablad': ('belladonnablad',),
'belladonnablader': ('belladonnablad',),
'belladonnablada': ('belladonnablad',),
'belladonnabladene': ('belladonnablad',),
'belling': ('belling',),
'bellingen': ('belling',),
'bellinger': ('belling',),
'bellingene': ('belling',),
'belt': ('belt',),
'beltet': ('belt',),
'belt': ('belt',),
'belter': ('belt',),
'belt': ('belt',),
'belter': ('belt',),
'belta': ('belt',),
'beltene': ('belt',),
'belte': ('belte',),
'beltet': ('belte',),
'belter': ('belte',),
'belta': ('belte',),
'beltene': ('belte',),
'beltealge': ('beltealge',),
'beltealgen': ('beltealge',),
'beltealger': ('beltealge',),
'beltealgene': ('beltealge',),
'beltebil': ('beltebil',),
'beltebilen': ('beltebil',),
'beltebiler': ('beltebil',),
'beltebilene': ('beltebil',),
'beltedyr': ('beltedyr',),
'beltedyret': ('beltedyr',),
'beltedyr': ('beltedyr',),
'beltedyra': ('beltedyr',),
'beltedyrene': ('beltedyr',),
'beltehogst': ('beltehogst',),
'beltehogsten': ('beltehogst',),
'beltehogster': ('beltehogst',),
'beltehogstene': ('beltehogst',),
'beltehugst': ('beltehugst',),
'beltehugsten': ('beltehugst',),
'beltehugster': ('beltehugst',),
'beltehugstene': ('beltehugst',),
'beltested': ('beltested',),
'beltestedet': ('beltested',),
'beltested': ('beltested',),
'beltesteda': ('beltested',),
'beltestedene': ('beltested',),
'beltetraktor': ('beltetraktor',),
'beltetraktoren': ('beltetraktor',),
'beltetraktorer': ('beltetraktor',),
'beltetraktorene': ('beltetraktor',),
'belysning': ('belysning',),
'belysningen': ('belysning',),
'belysninga': ('belysning',),
'belysninger': ('belysning',),
'belysningene': ('belysning',),
'belysningsstyrke': ('belysningsstyrke',),
'belysningsstyrken': ('belysningsstyrke',),
'belysningsstyrker': ('belysningsstyrke',),
'belysningsstyrkene': ('belysningsstyrke',),
'belønning': ('belønning',),
'belønningen': ('belønning',),
'belønninga': ('belønning',),
'belønninger': ('belønning',),
'belønningene': ('belønning',),
'beløp': ('beløp',),
'beløpet': ('beløp',),
'beløp': ('beløp',),
'beløpa': ('beløp',),
'beløpene': ('beløp',),
'bemanning': ('bemanning',),
'bemanningen': ('bemanning',),
'bemanninga': ('bemanning',),
'bemanninger': ('bemanning',),
'bemanningene': ('bemanning',),
'bemanningsforskrift': ('bemanningsforskrift',),
'bemanningsforskriftet': ('bemanningsforskrift',),
'bemanningsforskrift': ('bemanningsforskrift',),
'bemanningsforskrifter': ('bemanningsforskrift',),
'bemanningsforskrift': ('bemanningsforskrift',),
'bemanningsforskrifter': ('bemanningsforskrift',),
'bemanningsforskrifta': ('bemanningsforskrift',),
'bemanningsforskriftene': ('bemanningsforskrift',),
'bemanningskrise': ('bemanningskrise',),
'bemanningskrisen': ('bemanningskrise',),
'bemanningskrisa': ('bemanningskrise',),
'bemanningskriser': ('bemanningskrise',),
'bemanningskrisene': ('bemanningskrise',),
'bemanningsliste': ('bemanningsliste',),
'bemanningslisten': ('bemanningsliste',),
'bemanningslista': ('bemanningsliste',),
'bemanningslister': ('bemanningsliste',),
'bemanningslistene': ('bemanningsliste',),
'bemanningssituasjon': ('bemanningssituasjon',),
'bemanningssituasjonen': ('bemanningssituasjon',),
'bemanningssituasjoner': ('bemanningssituasjon',),
'bemanningssituasjonene': ('bemanningssituasjon',),
'bemerkning': ('bemerkning',),
'bemerkningen': ('bemerkning',),
'bemerkninga': ('bemerkning',),
'bemerkninger': ('bemerkning',),
'bemerkningene': ('bemerkning',),
'bemyndigelse': ('bemyndigelse',),
'bemyndigelsen': ('bemyndigelse',),
'bemyndigelser': ('bemyndigelse',),
'bemyndigelsene': ('bemyndigelse',),
'ben': ('ben',),
'benet': ('ben',),
'ben': ('ben',),
'bena': ('ben',),
'benene': ('ben',),
'benarbeid': ('benarbeid',),
'benarbeidet': ('benarbeid',),
'benarbeid': ('benarbeid',),
'benarbeider': ('benarbeid',),
'benarbeid': ('benarbeid',),
'benarbeider': ('benarbeid',),
'benarbeida': ('benarbeid',),
'benarbeidene': ('benarbeid',),
'benbetennelse': ('benbetennelse',),
'benbetennelsen': ('benbetennelse',),
'benbetennelser': ('benbetennelse',),
'benbetennelsene': ('benbetennelse',),
'benbrudd': ('benbrudd',),
'benbruddet': ('benbrudd',),
'benbrudd': ('benbrudd',),
'benbrudda': ('benbrudd',),
'benbruddene': ('benbrudd',),
'benbygning': ('benbygning',),
'benbygningen': ('benbygning',),
'benbygninga': ('benbygning',),
'benbygninger': ('benbygning',),
'benbygningene': ('benbygning',),
'bend': ('bend',),
'bendet': ('bend',),
'bend': ('bend',),
'benda': ('bend',),
'bendene': ('bend',),
'bendel': ('bendel',),
'bendelen': ('bendel',),
'bendler': ('bendel',),
'bendlene': ('bendel',),
'bendelband': ('bendelband',),
'bendelbandet': ('bendelband',),
'bendelband': ('bendelband',),
'bendelbanda': ('bendelband',),
'bendelbandene': ('bendelband',),
'bendelbånd': ('bendelbånd',),
'bendelbåndet': ('bendelbånd',),
'bendelbånd': ('bendelbånd',),
'bendelbånda': ('bendelbånd',),
'bendelbåndene': ('bendelbånd',),
'bendelorm': ('bendelorm',),
'bendelormen': ('bendelorm',),
'bendelormer': ('bendelorm',),
'bendelormene': ('bendelorm',),
'bendsel': ('bendsel',),
'bendselet': ('bendsel',),
'bendslet': ('bendsel',),
'bendsel': ('bendsel',),
'bendsler': ('bendsel',),
'bendsla': ('bendsel',),
'bendslene': ('bendsel',),
'bendsla': ('bendsel',),
'bendslene': ('bendsel',),
'benediksjon': ('benediksjon',),
'benediksjonen': ('benediksjon',),
'benediksjoner': ('benediksjon',),
'benediksjonene': ('benediksjon',),
'benediktiner': ('benediktiner',),
'benediktineren': ('benediktiner',),
'benediktinere': ('benediktiner',),
'benediktinerne': ('benediktiner',),
'benediktinerkloster': ('benediktinerkloster',),
'benediktinerklosteret': ('benediktinerkloster',),
'benediktinerklostret': ('benediktinerkloster',),
'benediktinerkloster': ('benediktinerkloster',),
'benediktinerklostre': ('benediktinerkloster',),
'benediktinerklostra': ('benediktinerkloster',),
'benediktinerklostrene': ('benediktinerkloster',),
'benediktinerklostra': ('benediktinerkloster',),
'benediktinerklostrene': ('benediktinerkloster',),
'benediktinerlikør': ('benediktinerlikør',),
'benediktinerlikøren': ('benediktinerlikør',),
'benediktinerlikører': ('benediktinerlikør',),
'benediktinerlikørene': ('benediktinerlikør',),
'benediktinermunk': ('benediktinermunk',),
'benediktinermunken': ('benediktinermunk',),
'benediktinermunker': ('benediktinermunk',),
'benediktinermunkene': ('benediktinermunk',),
'benediktinernonne': ('benediktinernonne',),
'benediktinernonnen': ('benediktinernonne',),
'benediktinernonna': ('benediktinernonne',),
'benediktinernonner': ('benediktinernonne',),
'benediktinernonnene': ('benediktinernonne',),
'benediktinerorden': ('benediktinerorden',),
'benediktinerordenen': ('benediktinerorden',),
'benediktinerordener': ('benediktinerorden',),
'benediktinerordenene': ('benediktinerorden',),
'benefice': ('benefice',),
'beneficen': ('benefice',),
'beneficer': ('benefice',),
'beneficene': ('benefice',),
'beneficeforestilling': ('beneficeforestilling',),
'beneficeforestillingen': ('beneficeforestilling',),
'beneficeforestillinga': ('beneficeforestilling',),
'beneficeforestillinger': ('beneficeforestilling',),
'beneficeforestillingene': ('beneficeforestilling',),
'benevnelse': ('benevnelse',),
'benevnelsen': ('benevnelse',),
'benevnelser': ('benevnelse',),
'benevnelsene': ('benevnelse',),
'benevning': ('benevning',),
'benevningen': ('benevning',),
'benevninga': ('benevning',),
'benevninger': ('benevning',),
'benevningene': ('benevning',),
'benfisk': ('benfisk',),
'benfisken': ('benfisk',),
'benfisker': ('benfisk',),
'benfiskene': ('benfisk',),
'bengaler': ('bengaler',),
'bengaleren': ('bengaler',),
'bengalere': ('bengaler',),
'bengalerne': ('bengaler',),
'bengali': ('bengali',),
'bengalien': ('bengali',),
'bengalier': ('bengali',),
'bengaliene': ('bengali',),
'bengel': ('bengel',),
'bengelen': ('bengel',),
'bengler': ('bengel',),
'benglene': ('bengel',),
'beniner': ('beniner',),
'benineren': ('beniner',),
'beninere': ('beniner',),
'beninerne': ('beniner',),
'benjamin': ('benjamin',),
'benjaminen': ('benjamin',),
'benjaminer': ('benjamin',),
'benjaminene': ('benjamin',),
'benk': ('benk',),
'benken': ('benk',),
'benker': ('benk',),
'benkene': ('benk',),
'benkboremaskin': ('benkboremaskin',),
'benkboremaskinen': ('benkboremaskin',),
'benkboremaskiner': ('benkboremaskin',),
'benkboremaskinene': ('benkboremaskin',),
'benkebiter': ('benkebiter',),
'benkebiteren': ('benkebiter',),
'benkebitere': ('benkebiter',),
'benkebiterne': ('benkebiter',),
'benkeforslag': ('benkeforslag',),
'benkeforslaget': ('benkeforslag',),
'benkeforslag': ('benkeforslag',),
'benkeforslaga': ('benkeforslag',),
'benkeforslagene': ('benkeforslag',),
'benkeframlegg': ('benkeframlegg',),
'benkeframlegget': ('benkeframlegg',),
'benkeframlegg': ('benkeframlegg',),
'benkeframlegga': ('benkeframlegg',),
'benkeframleggene': ('benkeframlegg',),
'benkerad': ('benkerad',),
'benkeraden': ('benkerad',),
'benkerada': ('benkerad',),
'benkerader': ('benkerad',),
'benkeradene': ('benkerad',),
'benkesliter': ('benkesliter',),
'benkesliteren': ('benkesliter',),
'benkeslitere': ('benkesliter',),
'benkesliterne': ('benkesliter',),
'benklær': ('benklær',),
'benklærne': ('benklær',),
'benkrok': ('benkrok',),
'benkroken': ('benkrok',),
'benkroker': ('benkrok',),
'benkrokene': ('benkrok',),
'benlim': ('benlim',),
'benlimet': ('benlim',),
'benlim': ('benlim',),
'benlima': ('benlim',),
'benlimene': ('benlim',),
'benmarg': ('benmarg',),
'benmargen': ('benmarg',),
'benmarger': ('benmarg',),
'benmargene': ('benmarg',),
'benmel': ('benmel',),
'benmelet': ('benmel',),
'benmel': ('benmel',),
'benmela': ('benmel',),
'benmelene': ('benmel',),
'benmjøl': ('benmjøl',),
'benmjølet': ('benmjøl',),
'benmjøl': ('benmjøl',),
'benmjøla': ('benmjøl',),
'benmjølene': ('benmjøl',),
'benpipe': ('benpipe',),
'benpipen': ('benpipe',),
'benpipa': ('benpipe',),
'benpiper': ('benpipe',),
'benpipene': ('benpipe',),
'benrangel': ('benrangel',),
'benrangelet': ('benrangel',),
'benranglet': ('benrangel',),
'benrangel': ('benrangel',),
'benrangler': ('benrangel',),
'benrangla': ('benrangel',),
'benranglene': ('benrangel',),
'benrangla': ('benrangel',),
'benranglene': ('benrangel',),
'bensin': ('bensin',),
'bensinen': ('bensin',),
'bensiner': ('bensin',),
'bensinene': ('bensin',),
'bensinavgift': ('bensinavgift',),
'bensinavgiften': ('bensinavgift',),
'bensinavgifta': ('bensinavgift',),
'bensinavgifter': ('bensinavgift',),
'bensinavgiftene': ('bensinavgift',),
'bensinfat': ('bensinfat',),
'bensinfatet': ('bensinfat',),
'bensinfat': ('bensinfat',),
'bensinfater': ('bensinfat',),
'bensinfat': ('bensinfat',),
'bensinfater': ('bensinfat',),
'bensinfata': ('bensinfat',),
'bensinfatene': ('bensinfat',),
'bensinforbruk': ('bensinforbruk',),
'bensinforbruket': ('bensinforbruk',),
'bensinforbruk': ('bensinforbruk',),
'bensinforbruka': ('bensinforbruk',),
'bensinforbrukene': ('bensinforbruk',),
'bensinmotor': ('bensinmotor',),
'bensinmotoren': ('bensinmotor',),
'bensinmotorer': ('bensinmotor',),
'bensinmotorene': ('bensinmotor',),
'bensinpumpe': ('bensinpumpe',),
'bensinpumpen': ('bensinpumpe',),
'bensinpumpa': ('bensinpumpe',),
'bensinpumper': ('bensinpumpe',),
'bensinpumpene': ('bensinpumpe',),
'bensinstasjon': ('bensinstasjon',),
'bensinstasjonen': ('bensinstasjon',),
'bensinstasjoner': ('bensinstasjon',),
'bensinstasjonene': ('bensinstasjon',),
'bensinstasjonskjede': ('bensinstasjonskjede',),
'bensinstasjonskjeden': ('bensinstasjonskjede',),
'bensinstasjonskjeder': ('bensinstasjonskjede',),
'bensinstasjonskjedene': ('bensinstasjonskjede',),
'bensintank': ('bensintank',),
'bensintanken': ('bensintank',),
'bensintanker': ('bensintank',),
'bensintankene': ('bensintank',),
'bensintilførsel': ('bensintilførsel',),
'bensintilførselen': ('bensintilførsel',),
'bensintilførsler': ('bensintilførsel',),
'bensintilførslene': ('bensintilførsel',),
'benskurd': ('benskurd',),
'benskurden': ('benskurd',),
'benskurder': ('benskurd',),
'benskurdene': ('benskurd',),
'bensplint': ('bensplint',),
'bensplinten': ('bensplint',),
'bensplinter': ('bensplint',),
'bensplintene': ('bensplint',),
'bensubstans': ('bensubstans',),
'bensubstansen': ('bensubstans',),
'bensubstanser': ('bensubstans',),
'bensubstansene': ('bensubstans',),
'benved': ('benved',),
'benveden': ('benved',),
'benveder': ('benved',),
'benvedene': ('benved',),
'benveg': ('benveg',),
'benvegen': ('benveg',),
'benveger': ('benveg',),
'benvegene': ('benveg',),
'benvei': ('benvei',),
'benveien': ('benvei',),
'benveier': ('benvei',),
'benveiene': ('benvei',),
'benvev': ('benvev',),
'benvevet': ('benvev',),
'benvev': ('benvev',),
'benveva': ('benvev',),
'benvevene': ('benvev',),
'benzen': ('benzen',),
'benzenet': ('benzen',),
'benzen': ('benzen',),
'benzena': ('benzen',),
'benzenene': ('benzen',),
'benzensprit': ('benzensprit',),
'benzenspriten': ('benzensprit',),
'benzenspriter': ('benzensprit',),
'benzenspritene': ('benzensprit',),
'benådning': ('benådning',),
'benådningen': ('benådning',),
'benådninga': ('benådning',),
'benådninger': ('benådning',),
'benådningene': ('benådning',),
'beplantning': ('beplantning',),
'beplantningen': ('beplantning',),
'beplantninga': ('beplantning',),
'beplantninger': ('beplantning',),
'beplantningene': ('beplantning',),
'berber': ('berber',),
'berberen': ('berber',),
'berbere': ('berber',),
'berberne': ('berber',),
'berberis': ('berberis',),
'berberisen': ('berberis',),
'berberiser': ('berberis',),
'berberisene': ('berberis',),
'berberisbusk': ('berberisbusk',),
'berberisbusken': ('berberisbusk',),
'berberisbusker': ('berberisbusk',),
'berberisbuskene': ('berberisbusk',),
'berberspråk': ('berberspråk',),
'berberspråket': ('berberspråk',),
'berberspråk': ('berberspråk',),
'berberspråka': ('berberspråk',),
'berberspråkene': ('berberspråk',),
'berbisk': ('berbisk',),
'berbisken': ('berbisk',),
'berbisker': ('berbisk',),
'berbiskene': ('berbisk',),
'berceuse': ('berceuse',),
'berceusen': ('berceuse',),
'berceuser': ('berceuse',),
'berceusene': ('berceuse',),
'bereder': ('bereder',),
'berederen': ('bereder',),
'beredere': ('bereder',),
'berederne': ('bereder',),
'beredskap': ('beredskap',),
'beredskapen': ('beredskap',),
'beredskapet': ('beredskap',),
'beredskaper': ('beredskap',),
'beredskap': ('beredskap',),
'beredskapene': ('beredskap',),
'beredskapa': ('beredskap',),
'beredskapene': ('beredskap',),
'beredskapslager': ('beredskapslager',),
'beredskapslageret': ('beredskapslager',),
'beredskapslager': ('beredskapslager',),
'beredskapslagre': ('beredskapslager',),
'beredskapslagra': ('beredskapslager',),
'beredskapslagrene': ('beredskapslager',),
'beredskapslagra': ('beredskapslager',),
'beredskapslagrene': ('beredskapslager',),
'beredskapslov': ('beredskapslov',),
'beredskapsloven': ('beredskapslov',),
'beredskapslover': ('beredskapslov',),
'beredskapslovene': ('beredskapslov',),
'beredskapstiltak': ('beredskapstiltak',),
'beredskapstiltaket': ('beredskapstiltak',),
'beredskapstiltak': ('beredskapstiltak',),
'beredskapstiltaka': ('beredskapstiltak',),
'beredskapstiltakene': ('beredskapstiltak',),
'beregner': ('beregner',),
'beregneren': ('beregner',),
'beregnere': ('beregner',),
'beregnerne': ('beregner',),
'beregning': ('beregning',),
'beregningen': ('beregning',),
'beregninga': ('beregning',),
'beregninger': ('beregning',),
'beregningene': ('beregning',),
'beregningsfeil': ('beregningsfeil',),
'beregningsfeilen': ('beregningsfeil',),
'beregningsfeil': ('beregningsfeil',),
'beregningsfeila': ('beregningsfeil',),
'beregningsfeilene': ('beregningsfeil',),
'beregningsgrunnlag': ('beregningsgrunnlag',),
'beregningsgrunnlaget': ('beregningsgrunnlag',),
'beregningsgrunnlag': ('beregningsgrunnlag',),
'beregningsgrunnlaga': ('beregningsgrunnlag',),
'beregningsgrunnlagene': ('beregningsgrunnlag',),
'beregningsmåte': ('beregningsmåte',),
'beregningsmåten': ('beregningsmåte',),
'beregningsmåter': ('beregningsmåte',),
'beregningsmåtene': ('beregningsmåte',),
'beregningssum': ('beregningssum',),
'beregningssummen': ('beregningssum',),
'beregningssummer': ('beregningssum',),
'beregningssummene': ('beregningssum',),
'beret': ('beret',),
'bereten': ('beret',),
'bereter': ('beret',),
'beretene': ('beret',),
'beretning': ('beretning',),
'beretningen': ('beretning',),
'beretninga': ('beretning',),
'beretninger': ('beretning',),
'beretningene': ('beretning',),
'beretter': ('beretter',),
'beretteren': ('beretter',),
'berettere': ('beretter',),
'beretterne': ('beretter',),
'berettigelse': ('berettigelse',),
'berettigelsen': ('berettigelse',),
'berettigelser': ('berettigelse',),
'berettigelsene': ('berettigelse',),
'berg': ('berg',),
'berget': ('berg',),
'berg': ('berg',),
'berga': ('berg',),
'bergene': ('berg',),
'berg-og-dal-bane': ('berg-og-dal-bane',),
'berg-og-dal-banen': ('berg-og-dal-bane',),
'berg-og-dal-baner': ('berg-og-dal-bane',),
'berg-og-dal-banene': ('berg-og-dal-bane',),
'bergamott': ('bergamott',),
'bergamotten': ('bergamott',),
'bergamotter': ('bergamott',),
'bergamottene': ('bergamott',),
'bergamottappelsin': ('bergamottappelsin',),
'bergamottappelsinen': ('bergamottappelsin',),
'bergamottappelsiner': ('bergamottappelsin',),
'bergamottappelsinene': ('bergamottappelsin',),
'bergamottolje': ('bergamottolje',),
'bergamottoljen': ('bergamottolje',),
'bergamottolja': ('bergamottolje',),
'bergamottoljer': ('bergamottolje',),
'bergamottoljene': ('bergamottolje',),
'bergamottpære': ('bergamottpære',),
'bergamottpæren': ('bergamottpære',),
'bergamottpæra': ('bergamottpære',),
'bergamottpærer': ('bergamottpære',),
'bergamottpærene': ('bergamottpære',),
'bergand': ('bergand',),
'berganden': ('bergand',),
'berganda': ('bergand',),
'bergender': ('bergand',),
'bergendene': ('bergand',),
'bergart': ('bergart',),
'bergarten': ('bergart',),
'bergarta': ('bergart',),
'bergarter': ('bergart',),
'bergartene': ('bergart',),
'bergartilleri': ('bergartilleri',),
'bergartilleriet': ('bergartilleri',),
'bergartilleri': ('bergartilleri',),
'bergartillerier': ('bergartilleri',),
'bergartilleri': ('bergartilleri',),
'bergartillerier': ('bergartilleri',),
'bergartilleria': ('bergartilleri',),
'bergartilleriene': ('bergartilleri',),
'bergelønn': ('bergelønn',),
'bergelønnen': ('bergelønn',),
'bergelønna': ('bergelønn',),
'bergelønner': ('bergelønn',),
'bergelønnene': ('bergelønn',),
'bergenser': ('bergenser',),
'bergenseren': ('bergenser',),
'bergensere': ('bergenser',),
'bergenserne': ('bergenser',),
'bergfag': ('bergfag',),
'bergfaget': ('bergfag',),
'bergfag': ('bergfag',),
'bergfaga': ('bergfag',),
'bergfagene': ('bergfag',),
'bergflette': ('bergflette',),
'bergfletten': ('bergflette',),
'bergfletta': ('bergflette',),
'bergfletter': ('bergflette',),
'bergflettene': ('bergflette',),
'bergflettefamilie': ('bergflettefamilie',),
'bergflettefamilien': ('bergflettefamilie',),
'bergflettefamilier': ('bergflettefamilie',),
'bergflettefamiliene': ('bergflettefamilie',),
'bergfrue': ('bergfrue',),
'bergfruen': ('bergfrue',),
'bergfrua': ('bergfrue',),
'bergfruer': ('bergfrue',),
'bergfruene': ('bergfrue',),
'berggylte': ('berggylte',),
'berggylten': ('berggylte',),
'berggylta': ('berggylte',),
'berggylter': ('berggylte',),
'berggyltene': ('berggylte',),
'berghammar': ('berghammar',),
'berghammaren': ('berghammar',),
'berghamrer': ('berghammar',),
'berghamrene': ('berghammar',),
'berghammer': ('berghammer',),
'berghammeren': ('berghammer',),
'berghammere': ('berghammer',),
'berghamrer': ('berghammer',),
'berghamre': ('berghammer',),
'berghammerne': ('berghammer',),
'berghamrene': ('berghammer',),
'berghole': ('berghole',),
'bergholen': ('berghole',),
'berghola': ('berghole',),
'bergholer': ('berghole',),
'bergholene': ('berghole',),
'berghule': ('berghule',),
'berghulen': ('berghule',),
'berghula': ('berghule',),
'berghuler': ('berghule',),
'berghulene': ('berghule',),
'berghylle': ('berghylle',),
'berghyllen': ('berghylle',),
'berghylla': ('berghylle',),
'berghyller': ('berghylle',),
'berghyllene': ('berghylle',),
'berging': ('berging',),
'bergingen': ('berging',),
'berginga': ('berging',),
'berginger': ('berging',),
'bergingene': ('berging',),
'bergingeniør': ('bergingeniør',),
'bergingeniøren': ('bergingeniør',),
'bergingeniører': ('bergingeniør',),
'bergingeniørene': ('bergingeniør',),
'bergingsarbeid': ('bergingsarbeid',),
'bergingsarbeidet': ('bergingsarbeid',),
'bergingsarbeid': ('bergingsarbeid',),
'bergingsarbeider': ('bergingsarbeid',),
'bergingsarbeid': ('bergingsarbeid',),
'bergingsarbeider': ('bergingsarbeid',),
'bergingsarbeida': ('bergingsarbeid',),
'bergingsarbeidene': ('bergingsarbeid',),
'bergingsbåt': ('bergingsbåt',),
'bergingsbåten': ('bergingsbåt',),
'bergingsbåter': ('bergingsbåt',),
'bergingsbåtene': ('bergingsbåt',),
'bergingsfartøy': ('bergingsfartøy',),
'bergingsfartøyet': ('bergingsfartøy',),
'bergingsfartøy': ('bergingsfartøy',),
'bergingsfartøyer': ('bergingsfartøy',),
'bergingsfartøy': ('bergingsfartøy',),
'bergingsfartøyer': ('bergingsfartøy',),
'bergingsfartøya': ('bergingsfartøy',),
'bergingsfartøyene': ('bergingsfartøy',),
'bergingsforsøk': ('bergingsforsøk',),
'bergingsforsøket': ('bergingsforsøk',),
'bergingsforsøk': ('bergingsforsøk',),
'bergingsforsøka': ('bergingsforsøk',),
'bergingsforsøkene': ('bergingsforsøk',),
'bergirisk': ('bergirisk',),
'bergirisken': ('bergirisk',),
'bergirisker': ('bergirisk',),
'bergiriskene': ('bergirisk',),
'bergknapp': ('bergknapp',),
'bergknappen': ('bergknapp',),
'bergknapper': ('bergknapp',),
'bergknappene': ('bergknapp',),
'bergknaus': ('bergknaus',),
'bergknausen': ('bergknaus',),
'bergknauser': ('bergknaus',),
'bergknausene': ('bergknaus',),
'bergkrystall': ('bergkrystall',),
'bergkrystallen': ('bergkrystall',),
'bergkrystallet': ('bergkrystall',),
'bergkrystaller': ('bergkrystall',),
'bergkrystall': ('bergkrystall',),
'bergkrystaller': ('bergkrystall',),
'bergkrystall': ('bergkrystall',),
'bergkrystaller': ('bergkrystall',),
'bergkrystallene': ('bergkrystall',),
'bergkrystalla': ('bergkrystall',),
'bergkrystallene': ('bergkrystall',),
'bergmann': ('bergmann',),
'bergmannen': ('bergmann',),
'bergmenn': ('bergmann',),
'bergmennene': ('bergmann',),
'bergmester': ('bergmester',),
'bergmesteren': ('bergmester',),
'bergmestere': ('bergmester',),
'bergmestrer': ('bergmester',),
'bergmestre': ('bergmester',),
'bergmesterne': ('bergmester',),
'bergmestrene': ('bergmester',),
'bergmynte': ('bergmynte',),
'bergmynten': ('bergmynte',),
'bergmynta': ('bergmynte',),
'bergmynter': ('bergmynte',),
'bergmyntene': ('bergmynte',),
'bergnabb': ('bergnabb',),
'bergnabben': ('bergnabb',),
'bergnabber': ('bergnabb',),
'bergnabbene': ('bergnabb',),
'bergnebb': ('bergnebb',),
'bergnebben': ('bergnebb',),
'bergnebber': ('bergnebb',),
'bergnebbene': ('bergnebb',),
'bergnebbe': ('bergnebbe',),
'bergnebben': ('bergnebbe',),
'bergnebba': ('bergnebbe',),
'bergnebber': ('bergnebbe',),
'bergnebbene': ('bergnebbe',),
'bergpreken': ('bergpreken',),
'bergprekenen': ('bergpreken',),
'bergprekener': ('bergpreken',),
'bergprekenene': ('bergpreken',),
'bergsildre': ('bergsildre',),
'bergsildren': ('bergsildre',),
'bergsildra': ('bergsildre',),
'bergsildrer': ('bergsildre',),
'bergsildrene': ('bergsildre',),
'bergugle': ('bergugle',),
'berguglen': ('bergugle',),
'bergugla': ('bergugle',),
'bergugler': ('bergugle',),
'berguglene': ('bergugle',),
'bergvegg': ('bergvegg',),
'bergveggen': ('bergvegg',),
'bergvegger': ('bergvegg',),
'bergveggene': ('bergvegg',),
'bergverk': ('bergverk',),
'bergverket': ('bergverk',),
'bergverk': ('bergverk',),
'bergverker': ('bergverk',),
'bergverk': ('bergverk',),
'bergverker': ('bergverk',),
'bergverka': ('bergverk',),
'bergverkene': ('bergverk',),
'bergverksdrift': ('bergverksdrift',),
'bergverksdriften': ('bergverksdrift',),
'bergverksdrifta': ('bergverksdrift',),
'bergverksdrifter': ('bergverksdrift',),
'bergverksdriftene': ('bergverksdrift',),
'bergveronika': ('bergveronika',),
'bergveronikaen': ('bergveronika',),
'bergveronikaer': ('bergveronika',),
'bergveronikaene': ('bergveronika',),
'bergvesen': ('bergvesen',),
'bergvesenet': ('bergvesen',),
'bergvesen': ('bergvesen',),
'bergvesener': ('bergvesen',),
'bergvesen': ('bergvesen',),
'bergvesener': ('bergvesen',),
'bergvesena': ('bergvesen',),
'bergvesenene': ('bergvesen',),
'beriberi': ('beriberi',),
'beriberien': ('beriberi',),
'beriberier': ('beriberi',),
'beriberiene': ('beriberi',),
'berider': ('berider',),
'berideren': ('berider',),
'beridere': ('berider',),
'beriderne': ('berider',),
'beriderske': ('beriderske',),
'beridersken': ('beriderske',),
'beriderska': ('beriderske',),
'beridersker': ('beriderske',),
'beriderskene': ('beriderske',),
'beriktigelse': ('beriktigelse',),
'beriktigelsen': ('beriktigelse',),
'beriktigelser': ('beriktigelse',),
'beriktigelsene': ('beriktigelse',),
'berkelium': ('berkelium',),
'berkeliumet': ('berkelium',),
'berkelium': ('berkelium',),
'berkeliuma': ('berkelium',),
'berkeliumene': ('berkelium',),
'berlinblått': ('berlinblått',),
'berliner': ('berliner',),
'berlineren': ('berliner',),
'berlinere': ('berliner',),
'berlinerne': ('berliner',),
'berlinerblått': ('berlinerblått',),
'berlinerbolle': ('berlinerbolle',),
'berlinerbollen': ('berlinerbolle',),
'berlinerboller': ('berlinerbolle',),
'berlinerbollene': ('berlinerbolle',),
'berlinerkrans': ('berlinerkrans',),
'berlinerkransen': ('berlinerkrans',),
'berlinerkranser': ('berlinerkrans',),
'berlinerkransene': ('berlinerkrans',),
'berme': ('berme',),
'bermen': ('berme',),
'bermer': ('berme',),
'bermene': ('berme',),
'bermudarigg': ('bermudarigg',),
'bermudariggen': ('bermudarigg',),
'bermudarigger': ('bermudarigg',),
'bermudariggene': ('bermudarigg',),
'bermudashorts': ('bermudashorts',),
'bermudashortsen': ('bermudashorts',),
'bermudashortser': ('bermudashorts',),
'bermudashorts': ('bermudashorts',),
'bermudashortsene': ('bermudashorts',),
'bernhardiner': ('bernhardiner',),
'bernhardineren': ('bernhardiner',),
'bernhardinere': ('bernhardiner',),
'bernhardinerne': ('bernhardiner',),
'bero': ('bero',),
'berserk': ('berserk',),
'berserken': ('berserk',),
'berserker': ('berserk',),
'berserkene': ('berserk',),
'berserkgang': ('berserkgang',),
'berserkgangen': ('berserkgang',),
'berserkganger': ('berserkgang',),
'berserkgangene': ('berserkgang',),
'berserksgang': ('berserksgang',),
'berserksgangen': ('berserksgang',),
'berserksganger': ('berserksgang',),
'berserksgangene': ('berserksgang',),
'beryll': ('beryll',),
'beryllen': ('beryll',),
'beryller': ('beryll',),
'beryllene': ('beryll',),
'beryllium': ('beryllium',),
'berylliumet': ('beryllium',),
'beryllium': ('beryllium',),
'berylliuma': ('beryllium',),
'berylliumene': ('beryllium',),
'berømmelse': ('berømmelse',),
'berømmelsen': ('berømmelse',),
'berømmelser': ('berømmelse',),
'berømmelsene': ('berømmelse',),
'berømthet': ('berømthet',),
'berømtheten': ('berømthet',),
'berømtheta': ('berømthet',),
'berømtheter': ('berømthet',),
'berømthetene': ('berømthet',),
'berøring': ('berøring',),
'berøringen': ('berøring',),
'berøringa': ('berøring',),
'berøringer': ('berøring',),
'berøringene': ('berøring',),
'berøringsflate': ('berøringsflate',),
'berøringsflaten': ('berøringsflate',),
'berøringsflata': ('berøringsflate',),
'berøringsflater': ('berøringsflate',),
'berøringsflatene': ('berøringsflate',),
'berøringspunkt': ('berøringspunkt',),
'berøringspunktet': ('berøringspunkt',),
'berøringspunkt': ('berøringspunkt',),
'berøringspunkter': ('berøringspunkt',),
'berøringspunkt': ('berøringspunkt',),
'berøringspunkter': ('berøringspunkt',),
'berøringspunkta': ('berøringspunkt',),
'berøringspunktene': ('berøringspunkt',),
'berøvelse': ('berøvelse',),
'berøvelsen': ('berøvelse',),
'berøvelser': ('berøvelse',),
'berøvelsene': ('berøvelse',),
'beseirer': ('beseirer',),
'beseireren': ('beseirer',),
'beseirere': ('beseirer',),
'beseirerne': ('beseirer',),
'besetning': ('besetning',),
'besetningen': ('besetning',),
'besetninga': ('besetning',),
'besetninger': ('besetning',),
'besetningene': ('besetning',),
'besetningsband': ('besetningsband',),
'besetningsbandet': ('besetningsband',),
'besetningsband': ('besetningsband',),
'besetningsbanda': ('besetningsband',),
'besetningsbandene': ('besetningsband',),
'besetningsbånd': ('besetningsbånd',),
'besetningsbåndet': ('besetningsbånd',),
'besetningsbånd': ('besetningsbånd',),
'besetningsbånda': ('besetningsbånd',),
'besetningsbåndene': ('besetningsbånd',),
'besettelse': ('besettelse',),
'besettelsen': ('besettelse',),
'besettelser': ('besettelse',),
'besettelsene': ('besettelse',),
'besiktelse': ('besiktelse',),
'besiktelsen': ('besiktelse',),
'besiktelser': ('besiktelse',),
'besiktelsene': ('besiktelse',),
'besiktelsesmann': ('besiktelsesmann',),
'besiktelsesmannen': ('besiktelsesmann',),
'besiktelsesmenn': ('besiktelsesmann',),
'besiktelsesmennene': ('besiktelsesmann',),
'besiktigelse': ('besiktigelse',),
'besiktigelsen': ('besiktigelse',),
'besiktigelser': ('besiktigelse',),
'besiktigelsene': ('besiktigelse',),
'besindighet': ('besindighet',),
'besindigheten': ('besindighet',),
'besindigheta': ('besindighet',),
'besindigheter': ('besindighet',),
'besindighetene': ('besindighet',),
'besinnelse': ('besinnelse',),
'besinnelsen': ('besinnelse',),
'besinnelser': ('besinnelse',),
'besinnelsene': ('besinnelse',),
'besittelse': ('besittelse',),
'besittelsen': ('besittelse',),
'besittelser': ('besittelse',),
'besittelsene': ('besittelse',),
'besjeling': ('besjeling',),
'besjelingen': ('besjeling',),
'besjelinga': ('besjeling',),
'besjelinger': ('besjeling',),
'besjelingene': ('besjeling',),
'beskaffenhet': ('beskaffenhet',),
'beskaffenheten': ('beskaffenhet',),
'beskaffenheta': ('beskaffenhet',),
'beskaffenheter': ('beskaffenhet',),
'beskaffenhetene': ('beskaffenhet',),
'beskatning': ('beskatning',),
'beskatningen': ('beskatning',),
'beskatninga': ('beskatning',),
'beskatninger': ('beskatning',),
'beskatningene': ('beskatning',),
'beskatningsregel': ('beskatningsregel',),
'beskatningsregelen': ('beskatningsregel',),
'beskatningsregler': ('beskatningsregel',),
'beskatningsreglene': ('beskatningsregel',),
'beskjed': ('beskjed',),
'beskjeden': ('beskjed',),
'beskjeder': ('beskjed',),
'beskjedene': ('beskjed',),
'beskjedenhet': ('beskjedenhet',),
'beskjedenheten': ('beskjedenhet',),
'beskjedenheta': ('beskjedenhet',),
'beskjedenheter': ('beskjedenhet',),
'beskjedenhetene': ('beskjedenhet',),
'beskjeftigelse': ('beskjeftigelse',),
'beskjeftigelsen': ('beskjeftigelse',),
'beskjeftigelser': ('beskjeftigelse',),
'beskjeftigelsene': ('beskjeftigelse',),
'beskrivelse': ('beskrivelse',),
'beskrivelsen': ('beskrivelse',),
'beskrivelser': ('beskrivelse',),
'beskrivelsene': ('beskrivelse',),
'beskuelse': ('beskuelse',),
'beskuelsen': ('beskuelse',),
'beskuelser': ('beskuelse',),
'beskuelsene': ('beskuelse',),
'beskyldning': ('beskyldning',),
'beskyldningen': ('beskyldning',),
'beskyldninga': ('beskyldning',),
'beskyldninger': ('beskyldning',),
'beskyldningene': ('beskyldning',),
'beskyttelse': ('beskyttelse',),
'beskyttelsen': ('beskyttelse',),
'beskyttelser': ('beskyttelse',),
'beskyttelsene': ('beskyttelse',),
'beskyttelsesfarge': ('beskyttelsesfarge',),
'beskyttelsesfargen': ('beskyttelsesfarge',),
'beskyttelsesfarger': ('beskyttelsesfarge',),
'beskyttelsesfargene': ('beskyttelsesfarge',),
'beskyttelseslikhet': ('beskyttelseslikhet',),
'beskyttelseslikheten': ('beskyttelseslikhet',),
'beskyttelseslikheta': ('beskyttelseslikhet',),
'beskyttelseslikheter': ('beskyttelseslikhet',),
'beskyttelseslikhetene': ('beskyttelseslikhet',),
'beskytter': ('beskytter',),
'beskytteren': ('beskytter',),
'beskyttere': ('beskytter',),
'beskytterne': ('beskytter',),
'beskøyt': ('beskøyt',),
'beskøyten': ('beskøyt',),
'beskøyter': ('beskøyt',),
'beskøytene': ('beskøyt',),
'beslag': ('beslag',),
'beslaget': ('beslag',),
'beslag': ('beslag',),
'beslaga': ('beslag',),
'beslagene': ('beslag',),
'beslutning': ('beslutning',),
'beslutningen': ('beslutning',),
'beslutninga': ('beslutning',),
'beslutninger': ('beslutning',),
'beslutningene': ('beslutning',),
'beslutningsprosess': ('beslutningsprosess',),
'beslutningsprosessen': ('beslutningsprosess',),
'beslutningsprosesser': ('beslutningsprosess',),
'beslutningsprosessene': ('beslutningsprosess',),
'besluttsomhet': ('besluttsomhet',),
'besluttsomheten': ('besluttsomhet',),
'besluttsomheta': ('besluttsomhet',),
'besluttsomheter': ('besluttsomhet',),
'besluttsomhetene': ('besluttsomhet',),
'besparelse': ('besparelse',),
'besparelsen': ('besparelse',),
'besparelser': ('besparelse',),
'besparelsene': ('besparelse',),
'bespisning': ('bespisning',),
'bespisningen': ('bespisning',),
'bespisninga': ('bespisning',),
'bespisninger': ('bespisning',),
'bespisningene': ('bespisning',),
'bessemerstål': ('bessemerstål',),
'bessemerstålet': ('bessemerstål',),
'bessemerstål': ('bessemerstål',),
'bessemerståla': ('bessemerstål',),
'bessemerstålene': ('bessemerstål',),
'besserwissen': ('besserwissen',),
'besserwisser': ('besserwisser',),
'besserwisseren': ('besserwisser',),
'besserwissere': ('besserwisser',),
'besserwisserne': ('besserwisser',),
'best': ('best',),
'bestet': ('best',),
'best': ('best',),
'besta': ('best',),
'bestene': ('best',),
'bestalling': ('bestalling',),
'bestallingen': ('bestalling',),
'bestallinger': ('bestalling',),
'bestallingene': ('bestalling',),
'bestand': ('bestand',),
'bestanden': ('bestand',),
'bestander': ('bestand',),
'bestandene': ('bestand',),
'bestand': ('bestand',),
'bestandet': ('bestand',),
'bestand': ('bestand',),
'bestanda': ('bestand',),
'bestandene': ('bestand',),
'bestanddel': ('bestanddel',),
'bestanddelen': ('bestanddel',),
'bestanddeler': ('bestanddel',),
'bestanddelene': ('bestanddel',),
'bestandighet': ('bestandighet',),
'bestandigheten': ('bestandighet',),
'bestandigheta': ('bestandighet',),
'bestandigheter': ('bestandighet',),
'bestandighetene': ('bestandighet',),
'besteborger': ('besteborger',),
'besteborgeren': ('besteborger',),
'besteborgere': ('besteborger',),
'besteborgerne': ('besteborger',),
'bestemann': ('bestemann',),
'bestemannen': ('bestemann',),
'bestemenn': ('bestemann',),
'bestemennene': ('bestemann',),
'bestemmelse': ('bestemmelse',),
'bestemmelsen': ('bestemmelse',),
'bestemmelser': ('bestemmelse',),
'bestemmelsene': ('bestemmelse',),
'bestemmelsessted': ('bestemmelsessted',),
'bestemmelsesstedet': ('bestemmelsessted',),
'bestemmelsessteder': ('bestemmelsessted',),
'bestemmelsesstedene': ('bestemmelsessted',),
'bestemor': ('bestemor',),
'bestemoren': ('bestemor',),
'bestemora': ('bestemor',),
'bestemødre': ('bestemor',),
'bestemødrer': ('bestemor',),
'bestemødre': ('bestemor',),
'bestemødrer': ('bestemor',),
'bestemødrene': ('bestemor',),
'bestemthet': ('bestemthet',),
'bestemtheten': ('bestemthet',),
'bestemtheta': ('bestemthet',),
'bestemtheter': ('bestemthet',),
'bestemthetene': ('bestemthet',),
'bestenotering': ('bestenotering',),
'bestenoteringen': ('bestenotering',),
'bestenoteringa': ('bestenotering',),
'bestenoteringer': ('bestenotering',),
'bestenoteringene': ('bestenotering',),
'bestevenn': ('bestevenn',),
'bestevennen': ('bestevenn',),
'bestevenner': ('bestevenn',),
'bestevennene': ('bestevenn',),
'bestevenninne': ('bestevenninne',),
'bestevenninnen': ('bestevenninne',),
'bestevenninna': ('bestevenninne',),
'bestevenninner': ('bestevenninne',),
'bestevenninnene': ('bestevenninne',),
'bestevilkår': ('bestevilkår',),
'bestevilkåret': ('bestevilkår',),
'bestevilkår': ('bestevilkår',),
'bestevilkåra': ('bestevilkår',),
'bestevilkårene': ('bestevilkår',),
'bestevilkårsavtale': ('bestevilkårsavtale',),
'bestevilkårsavtalen': ('bestevilkårsavtale',),
'bestevilkårsavtaler': ('bestevilkårsavtale',),
'bestevilkårsavtalene': ('bestevilkårsavtale',),
'bestialitet': ('bestialitet',),
'bestialiteten': ('bestialitet',),
'bestialiteter': ('bestialitet',),
'bestialitetene': ('bestialitet',),
'bestigelse': ('bestigelse',),
'bestigelsen': ('bestigelse',),
'bestigelser': ('bestigelse',),
'bestigelsene': ('bestigelse',),
'bestigning': ('bestigning',),
'bestigningen': ('bestigning',),
'bestigninga': ('bestigning',),
'bestigninger': ('bestigning',),
'bestigningene': ('bestigning',),
'bestikk': ('bestikk',),
'bestikken': ('bestikk',),
'bestikker': ('bestikk',),
'bestikkene': ('bestikk',),
'bestikkelse': ('bestikkelse',),
'bestikkelsen': ('bestikkelse',),
'bestikkelser': ('bestikkelse',),
'bestikkelsene': ('bestikkelse',),
'bestikklugar': ('bestikklugar',),
'bestikklugaren': ('bestikklugar',),
'bestikklugarer': ('bestikklugar',),
'bestikklugarene': ('bestikklugar',),
'bestikkoppgjør': ('bestikkoppgjør',),
'bestikkoppgjøret': ('bestikkoppgjør',),
'bestikkoppgjør': ('bestikkoppgjør',),
'bestikkoppgjøra': ('bestikkoppgjør',),
'bestikkoppgjørene': ('bestikkoppgjør',),
'bestikktabell': ('bestikktabell',),
'bestikktabellen': ('bestikktabell',),
'bestikktabeller': ('bestikktabell',),
'bestikktabellene': ('bestikktabell',),
'bestilling': ('bestilling',),
'bestillingen': ('bestilling',),
'bestillinger': ('bestilling',),
'bestillingene': ('bestilling',),
'bestilling': ('bestilling',),
'bestillingen': ('bestilling',),
'bestillinga': ('bestilling',),
'bestillinger': ('bestilling',),
'bestillingene': ('bestilling',),
'bestillingstjuveri': ('bestillingstjuveri',),
'bestillingstjuveriet': ('bestillingstjuveri',),
'bestillingstjuveri': ('bestillingstjuveri',),
'bestillingstjuverier': ('bestillingstjuveri',),
'bestillingstjuveri': ('bestillingstjuveri',),
'bestillingstjuverier': ('bestillingstjuveri',),
'bestillingstjuveria': ('bestillingstjuveri',),
'bestillingstjuveriene': ('bestillingstjuveri',),
'bestillingstyveri': ('bestillingstyveri',),
'bestillingstyveriet': ('bestillingstyveri',),
'bestillingstyveri': ('bestillingstyveri',),
'bestillingstyverier': ('bestillingstyveri',),
'bestillingstyveri': ('bestillingstyveri',),
'bestillingstyverier': ('bestillingstyveri',),
'bestillingstyveria': ('bestillingstyveri',),
'bestillingstyveriene': ('bestillingstyveri',),
'bestillingsverk': ('bestillingsverk',),
'bestillingsverket': ('bestillingsverk',),
'bestillingsverk': ('bestillingsverk',),
'bestillingsverker': ('bestillingsverk',),
'bestillingsverk': ('bestillingsverk',),
'bestillingsverker': ('bestillingsverk',),
'bestillingsverka': ('bestillingsverk',),
'bestillingsverkene': ('bestillingsverk',),
'bestrebelse': ('bestrebelse',),
'bestrebelsen': ('bestrebelse',),
'bestrebelser': ('bestrebelse',),
'bestrebelsene': ('bestrebelse',),
'bestselger': ('bestselger',),
'bestselgeren': ('bestselger',),
'bestselgere': ('bestselger',),
'bestselgerne': ('bestselger',),
'bestykning': ('bestykning',),
'bestykningen': ('bestykning',),
'bestykninga': ('bestykning',),
'bestykninger': ('bestykning',),
'bestykningene': ('bestykning',),
'bestyr': ('bestyr',),
'bestyret': ('bestyr',),
'bestyr': ('bestyr',),
'bestyra': ('bestyr',),
'bestyrene': ('bestyr',),
'bestyrer': ('bestyrer',),
'bestyreren': ('bestyrer',),
'bestyrere': ('bestyrer',),
'bestyrerne': ('bestyrer',),
'bestyrtelse': ('bestyrtelse',),
'bestyrtelsen': ('bestyrtelse',),
'bestyrtelser': ('bestyrtelse',),
'bestyrtelsene': ('bestyrtelse',),
'beståen': ('beståen',),
'bestøvning': ('bestøvning',),
'bestøvningen': ('bestøvning',),
'bestøvninga': ('bestøvning',),
'bestøvninger': ('bestøvning',),
'bestøvningene': ('bestøvning',),
'besvarelse': ('besvarelse',),
'besvarelsen': ('besvarelse',),
'besvarelser': ('besvarelse',),
'besvarelsene': ('besvarelse',),
'besvergelse': ('besvergelse',),
'besvergelsen': ('besvergelse',),
'besvergelser': ('besvergelse',),
'besvergelsene': ('besvergelse',),
'besvergelsesformular': ('besvergelsesformular',),
'besvergelsesformularen': ('besvergelsesformular',),
'besvergelsesformularet': ('besvergelsesformular',),
'besvergelsesformularer': ('besvergelsesformular',),
'besvergelsesformular': ('besvergelsesformular',),
'besvergelsesformularer': ('besvergelsesformular',),
'besvergelsesformular': ('besvergelsesformular',),
'besvergelsesformularer': ('besvergelsesformular',),
'besvergelsesformularene': ('besvergelsesformular',),
'besvergelsesformulara': ('besvergelsesformular',),
'besvergelsesformularene': ('besvergelsesformular',),
'besvergelseskunst': ('besvergelseskunst',),
'besvergelseskunsten': ('besvergelseskunst',),
'besvergelseskunster': ('besvergelseskunst',),
'besvergelseskunstene': ('besvergelseskunst',),
'besvimelse': ('besvimelse',),
'besvimelsen': ('besvimelse',),
'besvimelser': ('besvimelse',),
'besvimelsene': ('besvimelse',),
'besvimelsesanfall': ('besvimelsesanfall',),
'besvimelsesanfallet': ('besvimelsesanfall',),
'besvimelsesanfall': ('besvimelsesanfall',),
'besvimelsesanfalla': ('besvimelsesanfall',),
'besvimelsesanfallene': ('besvimelsesanfall',),
'besvær': ('besvær',),
'besværet': ('besvær',),
'besvær': ('besvær',),
'besværa': ('besvær',),
'besværene': ('besvær',),
'besynderlighet': ('besynderlighet',),
'besynderligheten': ('besynderlighet',),
'besynderligheta': ('besynderlighet',),
'besynderligheter': ('besynderlighet',),
'besynderlighetene': ('besynderlighet',),
'besyv': ('besyv',),
'besyvet': ('besyv',),
'besyv': ('besyv',),
'besyva': ('besyv',),
'besyvene': ('besyv',),
'besøk': ('besøk',),
'besøket': ('besøk',),
'besøk': ('besøk',),
'besøka': ('besøk',),
'besøkene': ('besøk',),
'besøkelsestid': ('besøkelsestid',),
'besøkelsestiden': ('besøkelsestid',),
'besøkelsestida': ('besøkelsestid',),
'besøkelsestider': ('besøkelsestid',),
'besøkelsestidene': ('besøkelsestid',),
'besøksforbud': ('besøksforbud',),
'besøksforbudet': ('besøksforbud',),
'besøksforbud': ('besøksforbud',),
'besøksforbuda': ('besøksforbud',),
'besøksforbudene': ('besøksforbud',),
'besøksrett': ('besøksrett',),
'besøksretten': ('besøksrett',),
'besøksretter': ('besøksrett',),
'besøksrettene': ('besøksrett',),
'beta': ('beta',),
'betaen': ('beta',),
'betaer': ('beta',),
'betaene': ('beta',),
'betaler': ('betaler',),
'betaleren': ('betaler',),
'betalere': ('betaler',),
'betalerne': ('betaler',),
'betaling': ('betaling',),
'betalingen': ('betaling',),
'betalinga': ('betaling',),
'betalinger': ('betaling',),
'betalingene': ('betaling',),
'betalingsbalanse': ('betalingsbalanse',),
'betalingsbalansen': ('betalingsbalanse',),
'betalingsbalanser': ('betalingsbalanse',),
'betalingsbalansene': ('betalingsbalanse',),
'betalingsfrist': ('betalingsfrist',),
'betalingsfristen': ('betalingsfrist',),
'betalingsfrister': ('betalingsfrist',),
'betalingsfristene': ('betalingsfrist',),
'betalingsmiddel': ('betalingsmiddel',),
'betalingsmiddelet': ('betalingsmiddel',),
'betalingsmidlet': ('betalingsmiddel',),
'betalingsmiddel': ('betalingsmiddel',),
'betalingsmidler': ('betalingsmiddel',),
'betalingsmidla': ('betalingsmiddel',),
'betalingsmidlene': ('betalingsmiddel',),
'betalingsmidla': ('betalingsmiddel',),
'betalingsmidlene': ('betalingsmiddel',),
'betalingsmåte': ('betalingsmåte',),
'betalingsmåten': ('betalingsmåte',),
'betalingsmåter': ('betalingsmåte',),
'betalingsmåtene': ('betalingsmåte',),
'betalingsvilkår': ('betalingsvilkår',),
'betalingsvilkåret': ('betalingsvilkår',),
'betalingsvilkår': ('betalingsvilkår',),
'betalingsvilkåra': ('betalingsvilkår',),
'betalingsvilkårene': ('betalingsvilkår',),
'betapartikkel': ('betapartikkel',),
'betapartikkelen': ('betapartikkel',),
'betapartikler': ('betapartikkel',),
'betapartiklene': ('betapartikkel',),
'betastråle': ('betastråle',),
'betastrålen': ('betastråle',),
'betastråler': ('betastråle',),
'betastrålene': ('betastråle',),
'betasuppe': ('betasuppe',),
'betasuppen': ('betasuppe',),
'betasuppa': ('betasuppe',),
'betasupper': ('betasuppe',),
'betasuppene': ('betasuppe',),
'bete': ('bete',),
'beten': ('bete',),
'beter': ('bete',),
'betene': ('bete',),
'bete': ('bete',),
'beten': ('bete',),
'beta': ('bete',),
'beter': ('bete',),
'betene': ('bete',),
'betegnelse': ('betegnelse',),
'betegnelsen': ('betegnelse',),
'betegnelser': ('betegnelse',),
'betegnelsene': ('betegnelse',),
'betel': ('betel',),
'betelen': ('betel',),
'betler': ('betel',),
'betlene': ('betel',),
'betelpalme': ('betelpalme',),
'betelpalmen': ('betelpalme',),
'betelpalmer': ('betelpalme',),
'betelpalmene': ('betelpalme',),
'betenkelighet': ('betenkelighet',),
'betenkeligheten': ('betenkelighet',),
'betenkeligheta': ('betenkelighet',),
'betenkeligheter': ('betenkelighet',),
'betenkelighetene': ('betenkelighet',),
'betenkning': ('betenkning',),
'betenkningen': ('betenkning',),
'betenkninga': ('betenkning',),
'betenkninger': ('betenkning',),
'betenkningene': ('betenkning',),
'betenkningstid': ('betenkningstid',),
'betenkningstiden': ('betenkningstid',),
'betenkningstida': ('betenkningstid',),
'betenkningstider': ('betenkningstid',),
'betenkningstidene': ('betenkningstid',),
'betennelse': ('betennelse',),
'betennelsen': ('betennelse',),
'betennelser': ('betennelse',),
'betennelsene': ('betennelse',),
'betesukker': ('betesukker',),
'betesukkeret': ('betesukker',),
'betesukker': ('betesukker',),
'betesukkere': ('betesukker',),
'betesukkera': ('betesukker',),
'betesukkerne': ('betesukker',),
'betesukkera': ('betesukker',),
'betesukkerne': ('betesukker',),
'betingelse': ('betingelse',),
'betingelsen': ('betingelse',),
'betingelser': ('betingelse',),
'betingelsene': ('betingelse',),
'betingelseskonjunksjon': ('betingelseskonjunksjon',),
'betingelseskonjunksjonen': ('betingelseskonjunksjon',),
'betingelseskonjunksjoner': ('betingelseskonjunksjon',),
'betingelseskonjunksjonene': ('betingelseskonjunksjon',),
'betingelsessetning': ('betingelsessetning',),
'betingelsessetningen': ('betingelsessetning',),
'betingelsessetninga': ('betingelsessetning',),
'betingelsessetninger': ('betingelsessetning',),
'betingelsessetningene': ('betingelsessetning',),
'betinging': ('betinging',),
'betingingen': ('betinging',),
'betinginga': ('betinging',),
'betinginger': ('betinging',),
'betingingene': ('betinging',),
'betjening': ('betjening',),
'betjeningen': ('betjening',),
'betjeninga': ('betjening',),
'betjeninger': ('betjening',),
'betjeningene': ('betjening',),
'betjent': ('betjent',),
'betjenten': ('betjent',),
'betjenter': ('betjent',),
'betjentene': ('betjent',),
'betler': ('betler',),
'betleren': ('betler',),
'betlere': ('betler',),
'betlerne': ('betler',),
'betleri': ('betleri',),
'betleriet': ('betleri',),
'betleri': ('betleri',),
'betlerier': ('betleri',),
'betleri': ('betleri',),
'betlerier': ('betleri',),
'betleria': ('betleri',),
'betleriene': ('betleri',),
'betlerstav': ('betlerstav',),
'betlerstaven': ('betlerstav',),
'betlerstaver': ('betlerstav',),
'betlerstavene': ('betlerstav',),
'betong': ('betong',),
'betongen': ('betong',),
'betonger': ('betong',),
'betongene': ('betong',),
'betongblander': ('betongblander',),
'betongblanderen': ('betongblander',),
'betongblandere': ('betongblander',),
'betongblanderne': ('betongblander',),
'betongbygning': ('betongbygning',),
'betongbygningen': ('betongbygning',),
'betongbygninga': ('betongbygning',),
'betongbygninger': ('betongbygning',),
'betongbygningene': ('betongbygning',),
'betongkonstruksjon': ('betongkonstruksjon',),
'betongkonstruksjonen': ('betongkonstruksjon',),
'betongkonstruksjoner': ('betongkonstruksjon',),
'betongkonstruksjonene': ('betongkonstruksjon',),
'betongrør': ('betongrør',),
'betongrøret': ('betongrør',),
'betongrør': ('betongrør',),
'betongrøra': ('betongrør',),
'betongrørene': ('betongrør',),
'betongstein': ('betongstein',),
'betongsteinen': ('betongstein',),
'betongsteiner': ('betongstein',),
'betongsteinene': ('betongstein',),
'betoning': ('betoning',),
'betoningen': ('betoning',),
'betoninga': ('betoning',),
'betoninger': ('betoning',),
'betoningene': ('betoning',),
'betrakter': ('betrakter',),
'betrakteren': ('betrakter',),
'betraktere': ('betrakter',),
'betrakterne': ('betrakter',),
'betraktning': ('betraktning',),
'betraktningen': ('betraktning',),
'betraktninga': ('betraktning',),
'betraktninger': ('betraktning',),
'betraktningene': ('betraktning',),
'betraktningsapparat': ('betraktningsapparat',),
'betraktningsapparatet': ('betraktningsapparat',),
'betraktningsapparat': ('betraktningsapparat',),
'betraktningsapparater': ('betraktningsapparat',),
'betraktningsapparat': ('betraktningsapparat',),
'betraktningsapparater': ('betraktningsapparat',),
'betraktningsapparata': ('betraktningsapparat',),
'betraktningsapparatene': ('betraktningsapparat',),
'betraktningsmåte': ('betraktningsmåte',),
'betraktningsmåten': ('betraktningsmåte',),
'betraktningsmåter': ('betraktningsmåte',),
'betraktningsmåtene': ('betraktningsmåte',),
'betroelse': ('betroelse',),
'betroelsen': ('betroelse',),
'betroelser': ('betroelse',),
'betroelsene': ('betroelse',),
'betryggelse': ('betryggelse',),
'betryggelsen': ('betryggelse',),
'betryggelser': ('betryggelse',),
'betryggelsene': ('betryggelse',),
'betydning': ('betydning',),
'betydningen': ('betydning',),
'betydninga': ('betydning',),
'betydninger': ('betydning',),
'betydningene': ('betydning',),
'betydningsendring': ('betydningsendring',),
'betydningsendringen': ('betydningsendring',),
'betydningsendringa': ('betydningsendring',),
'betydningsendringer': ('betydningsendring',),
'betydningsendringene': ('betydningsendring',),
'betydningsforskjell': ('betydningsforskjell',),
'betydningsforskjellen': ('betydningsforskjell',),
'betydningsforskjeller': ('betydningsforskjell',),
'betydningsforskjellene': ('betydningsforskjell',),
'betydningsinnhold': ('betydningsinnhold',),
'betydningsinnholdet': ('betydningsinnhold',),
'betydningsinnhold': ('betydningsinnhold',),
'betydningsinnholda': ('betydningsinnhold',),
'betydningsinnholdene': ('betydningsinnhold',),
'betydningsnyanse': ('betydningsnyanse',),
'betydningsnyansen': ('betydningsnyanse',),
'betydningsnyanser': ('betydningsnyanse',),
'betydningsnyansene': ('betydningsnyanse',),
'betydningsovergang': ('betydningsovergang',),
'betydningsovergangen': ('betydningsovergang',),
'betydningsoverganger': ('betydningsovergang',),
'betydningsovergangene': ('betydningsovergang',),
'beundrer': ('beundrer',),
'beundreren': ('beundrer',),
'beundrere': ('beundrer',),
'beundrerne': ('beundrer',),
'beundring': ('beundring',),
'beundringen': ('beundring',),
'beundringa': ('beundring',),
'beundringer': ('beundring',),
'beundringene': ('beundring',),
'bevegelighet': ('bevegelighet',),
'bevegeligheten': ('bevegelighet',),
'bevegeligheta': ('bevegelighet',),
'bevegeligheter': ('bevegelighet',),
'bevegelighetene': ('bevegelighet',),
'bevegelse': ('bevegelse',),
'bevegelsen': ('bevegelse',),
'bevegelser': ('bevegelse',),
'bevegelsene': ('bevegelse',),
'bevegelsesenergi': ('bevegelsesenergi',),
'bevegelsesenergien': ('bevegelsesenergi',),
'bevegelsesenergier': ('bevegelsesenergi',),
'bevegelsesenergiene': ('bevegelsesenergi',),
'bevegelsesfrihet': ('bevegelsesfrihet',),
'bevegelsesfriheten': ('bevegelsesfrihet',),
'bevegelsesfriheta': ('bevegelsesfrihet',),
'bevegelsesfriheter': ('bevegelsesfrihet',),
'bevegelsesfrihetene': ('bevegelsesfrihet',),
'bevegelseshemning': ('bevegelseshemning',),
'bevegelseshemningen': ('bevegelseshemning',),
'bevegelseshemninga': ('bevegelseshemning',),
'bevegelseshemninger': ('bevegelseshemning',),
'bevegelseshemningene': ('bevegelseshemning',),
'bevegelsesverb': ('bevegelsesverb',),
'bevegelsesverbet': ('bevegelsesverb',),
'bevegelsesverb': ('bevegelsesverb',),
'bevegelsesverber': ('bevegelsesverb',),
'bevegelsesverb': ('bevegelsesverb',),
'bevegelsesverber': ('bevegelsesverb',),
'bevegelsesverba': ('bevegelsesverb',),
'bevegelsesverbene': ('bevegelsesverb',),
'bevegelsesverbum': ('bevegelsesverbum',),
'bevegelsesverbet': ('bevegelsesverbum',),
'bevegelsesverbumet': ('bevegelsesverbum',),
'bevegelsesverber': ('bevegelsesverbum',),
'bevegelsesverba': ('bevegelsesverbum',),
'bevegelsesverbene': ('bevegelsesverbum',),
'bevegelsesverba': ('bevegelsesverbum',),
'bevegelsesverbene': ('bevegelsesverbum',),
'beveggrunn': ('beveggrunn',),
'beveggrunnen': ('beveggrunn',),
'beveggrunner': ('beveggrunn',),
'beveggrunnene': ('beveggrunn',),
'beven': ('beven',),
'bever': ('bever',),
'beveren': ('bever',),
'bevere': ('bever',),
'bevrer': ('bever',),
'bevre': ('bever',),
'beverne': ('bever',),
'bevrene': ('bever',),
'bevergjel': ('bevergjel',),
'bevergjelen': ('bevergjel',),
'bevergjelet': ('bevergjel',),
'bevergjeler': ('bevergjel',),
'bevergjel': ('bevergjel',),
'bevergjelene': ('bevergjel',),
'bevergjela': ('bevergjel',),
'bevergjelene': ('bevergjel',),
'beverhytte': ('beverhytte',),
'beverhytten': ('beverhytte',),
'beverhytta': ('beverhytte',),
'beverhytter': ('beverhytte',),
'beverhyttene': ('beverhytte',),
'beverpels': ('beverpels',),
'beverpelsen': ('beverpels',),
'beverpelser': ('beverpels',),
'beverpelsene': ('beverpels',),
'beverrotte': ('beverrotte',),
'beverrotten': ('beverrotte',),
'beverrotta': ('beverrotte',),
'beverrotter': ('beverrotte',),
'beverrottene': ('beverrotte',),
'bevertning': ('bevertning',),
'bevertningen': ('bevertning',),
'bevertninga': ('bevertning',),
'bevertninger': ('bevertning',),
'bevertningene': ('bevertning',),
'bevertningssted': ('bevertningssted',),
'bevertningsstedet': ('bevertningssted',),
'bevertningssteder': ('bevertningssted',),
'bevertningsstedene': ('bevertningssted',),
'bevilgning': ('bevilgning',),
'bevilgningen': ('bevilgning',),
'bevilgninga': ('bevilgning',),
'bevilgninger': ('bevilgning',),
'bevilgningene': ('bevilgning',),
'bevilgningsreglement': ('bevilgningsreglement',),
'bevilgningsreglementet': ('bevilgningsreglement',),
'bevilgningsreglement': ('bevilgningsreglement',),
'bevilgningsreglementer': ('bevilgningsreglement',),
'bevilgningsreglement': ('bevilgningsreglement',),
'bevilgningsreglementer': ('bevilgningsreglement',),
'bevilgningsreglementa': ('bevilgningsreglement',),
'bevilgningsreglementene': ('bevilgningsreglement',),
'bevilgningsspørsmål': ('bevilgningsspørsmål',),
'bevilgningsspørsmålet': ('bevilgningsspørsmål',),
'bevilgningsspørsmål': ('bevilgningsspørsmål',),
'bevilgningsspørsmåla': ('bevilgningsspørsmål',),
'bevilgningsspørsmålene': ('bevilgningsspørsmål',),
'bevilling': ('bevilling',),
'bevillingen': ('bevilling',),
'bevillinger': ('bevilling',),
'bevillingene': ('bevilling',),
'bevillingshaver': ('bevillingshaver',),
'bevillingshaveren': ('bevillingshaver',),
'bevillingshavere': ('bevillingshaver',),
'bevillingshaverne': ('bevillingshaver',),
'bevillingsutsteder': ('bevillingsutsteder',),
'bevillingsutstederen': ('bevillingsutsteder',),
'bevillingsutstedere': ('bevillingsutsteder',),
'bevillingsutstederne': ('bevillingsutsteder',),
'bevis': ('bevis',),
'beviset': ('bevis',),
'bevis': ('bevis',),
'beviser': ('bevis',),
'bevis': ('bevis',),
'beviser': ('bevis',),
'bevisa': ('bevis',),
'bevisene': ('bevis',),
'bevisbyrde': ('bevisbyrde',),
'bevisbyrden': ('bevisbyrde',),
'bevisbyrder': ('bevisbyrde',),
'bevisbyrdene': ('bevisbyrde',),
'bevisførsel': ('bevisførsel',),
'bevisførselen': ('bevisførsel',),
'bevisførsler': ('bevisførsel',),
'bevisførslene': ('bevisførsel',),
'bevisgrunn': ('bevisgrunn',),
'bevisgrunnen': ('bevisgrunn',),
'bevisgrunner': ('bevisgrunn',),
'bevisgrunnene': ('bevisgrunn',),
'bevismateriale': ('bevismateriale',),
'bevismaterialet': ('bevismateriale',),
'bevismaterialer': ('bevismateriale',),
'bevismateriala': ('bevismateriale',),
'bevismaterialene': ('bevismateriale',),
'bevissthet': ('bevissthet',),
'bevisstheten': ('bevissthet',),
'bevisstheta': ('bevissthet',),
'bevisstheter': ('bevissthet',),
'bevissthetene': ('bevissthet',),
'bevissthetsforstyrrelse': ('bevissthetsforstyrrelse',),
'bevissthetsforstyrrelsen': ('bevissthetsforstyrrelse',),
'bevissthetsforstyrrelser': ('bevissthetsforstyrrelse',),
'bevissthetsforstyrrelsene': ('bevissthetsforstyrrelse',),
'bevissthetsterskel': ('bevissthetsterskel',),
'bevissthetsterskelen': ('bevissthetsterskel',),
'bevissthetsterskler': ('bevissthetsterskel',),
'bevissthetstersklene': ('bevissthetsterskel',),
'bevoktning': ('bevoktning',),
'bevoktningen': ('bevoktning',),
'bevoktninga': ('bevoktning',),
'bevoktninger': ('bevoktning',),
'bevoktningene': ('bevoktning',),
'bevreasp': ('bevreasp',),
'bevreaspen': ('bevreasp',),
'bevreaspa': ('bevreasp',),
'bevreasper': ('bevreasp',),
'bevreaspene': ('bevreasp',),
'bevreosp': ('bevreosp',),
'bevreospen': ('bevreosp',),
'bevreospa': ('bevreosp',),
'bevreosper': ('bevreosp',),
'bevreospene': ('bevreosp',),
'bevågenhet': ('bevågenhet',),
'bevågenheten': ('bevågenhet',),
'bevågenheta': ('bevågenhet',),
'bevågenheter': ('bevågenhet',),
'bevågenhetene': ('bevågenhet',),
'bey': ('bey',),
'beyen': ('bey',),
'beyer': ('bey',),
'beyene': ('bey',),
'bh': ('bh',),
'bh-en': ('bh',),
'bh-er': ('bh',),
'bh-ene': ('bh',),
'bhutaner': ('bhutaner',),
'bhutaneren': ('bhutaner',),
'bhutanere': ('bhutaner',),
'bhutanerne': ('bhutaner',),
'biafraner': ('biafraner',),
'biafraneren': ('biafraner',),
'biafranere': ('biafraner',),
'biafranerne': ('biafraner',),
'bial': ('bial',),
'bialet': ('bial',),
'bial': ('bial',),
'biala': ('bial',),
'bialene': ('bial',),
'biapparat': ('biapparat',),
'biapparatet': ('biapparat',),
'biapparat': ('biapparat',),
'biapparater': ('biapparat',),
'biapparat': ('biapparat',),
'biapparater': ('biapparat',),
'biapparata': ('biapparat',),
'biapparatene': ('biapparat',),
'biarbeid': ('biarbeid',),
'biarbeidet': ('biarbeid',),
'biarbeid': ('biarbeid',),
'biarbeider': ('biarbeid',),
'biarbeid': ('biarbeid',),
'biarbeider': ('biarbeid',),
'biarbeida': ('biarbeid',),
'biarbeidene': ('biarbeid',),
'biavl': ('biavl',),
'biavlen': ('biavl',),
'biavler': ('biavl',),
'biavlene': ('biavl',),
'bibehold': ('bibehold',),
'bibel': ('bibel',),
'bibelen': ('bibel',),
'bibler': ('bibel',),
'biblene': ('bibel',),
'bibelcamp': ('bibelcamp',),
'bibelcampen': ('bibelcamp',),
'bibelcamper': ('bibelcamp',),
'bibelcampene': ('bibelcamp',),
'bibelfortolker': ('bibelfortolker',),
'bibelfortolkeren': ('bibelfortolker',),
'bibelfortolkere': ('bibelfortolker',),
'bibelfortolkerne': ('bibelfortolker',),
'bibelfortolking': ('bibelfortolking',),
'bibelfortolkingen': ('bibelfortolking',),
'bibelfortolkinga': ('bibelfortolking',),
'bibelfortolkinger': ('bibelfortolking',),
'bibelfortolkingene': ('bibelfortolking',),
'bibelfortolkning': ('bibelfortolkning',),
'bibelfortolkningen': ('bibelfortolkning',),
'bibelfortolkninga': ('bibelfortolkning',),
'bibelfortolkninger': ('bibelfortolkning',),
'bibelfortolkningene': ('bibelfortolkning',),
'bibelhandskrift': ('bibelhandskrift',),
'bibelhandskriftet': ('bibelhandskrift',),
'bibelhandskrift': ('bibelhandskrift',),
'bibelhandskrifter': ('bibelhandskrift',),
'bibelhandskrift': ('bibelhandskrift',),
'bibelhandskrifter': ('bibelhandskrift',),
'bibelhandskrifta': ('bibelhandskrift',),
'bibelhandskriftene': ('bibelhandskrift',),
'bibelhistorie': ('bibelhistorie',),
'bibelhistorien': ('bibelhistorie',),
'bibelhistoria': ('bibelhistorie',),
'bibelhistorier': ('bibelhistorie',),
'bibelhistoriene': ('bibelhistorie',),
'bibelhåndskrift': ('bibelhåndskrift',),
'bibelhåndskriftet': ('bibelhåndskrift',),
'bibelhåndskrift': ('bibelhåndskrift',),
'bibelhåndskrifter': ('bibelhåndskrift',),
'bibelhåndskrift': ('bibelhåndskrift',),
'bibelhåndskrifter': ('bibelhåndskrift',),
'bibelhåndskrifta': ('bibelhåndskrift',),
'bibelhåndskriftene': ('bibelhåndskrift',),
'bibelkonkordans': ('bibelkonkordans',),
'bibelkonkordansen': ('bibelkonkordans',),
'bibelkonkordanser': ('bibelkonkordans',),
'bibelkonkordansene': ('bibelkonkordans',),
'bibelkritikk': ('bibelkritikk',),
'bibelkritikken': ('bibelkritikk',),
'bibelkritikker': ('bibelkritikk',),
'bibelkritikkene': ('bibelkritikk',),
'bibelord': ('bibelord',),
'bibelordet': ('bibelord',),
'bibelord': ('bibelord',),
'bibelorda': ('bibelord',),
'bibelordene': ('bibelord',),
'bibelordbok': ('bibelordbok',),
'bibelordboken': ('bibelordbok',),
'bibelordboka': ('bibelordbok',),
'bibelordbøker': ('bibelordbok',),
'bibelordbøkene': ('bibelordbok',),
'bibeloversettelse': ('bibeloversettelse',),
'bibeloversettelsen': ('bibeloversettelse',),
'bibeloversettelser': ('bibeloversettelse',),
'bibeloversettelsene': ('bibeloversettelse',),
'bibelselskap': ('bibelselskap',),
'bibelselskapet': ('bibelselskap',),
'bibelselskap': ('bibelselskap',),
'bibelselskaper': ('bibelselskap',),
'bibelselskap': ('bibelselskap',),
'bibelselskaper': ('bibelselskap',),
'bibelselskapa': ('bibelselskap',),
'bibelselskapene': ('bibelselskap',),
'bibelsitat': ('bibelsitat',),
'bibelsitatet': ('bibelsitat',),
'bibelsitat': ('bibelsitat',),
'bibelsitater': ('bibelsitat',),
'bibelsitat': ('bibelsitat',),
'bibelsitater': ('bibelsitat',),
'bibelsitata': ('bibelsitat',),
'bibelsitatene': ('bibelsitat',),
'bibelskole': ('bibelskole',),
'bibelskolen': ('bibelskole',),
'bibelskoler': ('bibelskole',),
'bibelskolene': ('bibelskole',),
'bibelsmugler': ('bibelsmugler',),
'bibelsmugleren': ('bibelsmugler',),
'bibelsmuglere': ('bibelsmugler',),
'bibelsmuglerne': ('bibelsmugler',),
'bibelspråk': ('bibelspråk',),
'bibelspråket': ('bibelspråk',),
'bibelspråk': ('bibelspråk',),
'bibelspråka': ('bibelspråk',),
'bibelspråkene': ('bibelspråk',),
'bibelsted': ('bibelsted',),
'bibelstedet': ('bibelsted',),
'bibelsteder': ('bibelsted',),
'bibelstedene': ('bibelsted',),
'bibeltime': ('bibeltime',),
'bibeltimen': ('bibeltime',),
'bibeltimer': ('bibeltime',),
'bibeltimene': ('bibeltime',),
'bibelutgave': ('bibelutgave',),
'bibelutgaven': ('bibelutgave',),
'bibelutgava': ('bibelutgave',),
'bibelutgaver': ('bibelutgave',),
'bibelutgavene': ('bibelutgave',),
'bibelvitenskap': ('bibelvitenskap',),
'bibelvitenskapen': ('bibelvitenskap',),
'bibelvitenskaper': ('bibelvitenskap',),
'bibelvitenskapene': ('bibelvitenskap',),
'bibetydning': ('bibetydning',),
'bibetydningen': ('bibetydning',),
'bibetydninga': ('bibetydning',),
'bibetydninger': ('bibetydning',),
'bibetydningene': ('bibetydning',),
'biblad': ('biblad',),
'bibladet': ('biblad',),
'biblad': ('biblad',),
'biblader': ('biblad',),
'biblad': ('biblad',),
'biblader': ('biblad',),
'biblada': ('biblad',),
'bibladene': ('biblad',),
'bibliofil': ('bibliofil',),
'bibliofilen': ('bibliofil',),
'bibliofiler': ('bibliofil',),
'bibliofilene': ('bibliofil',),
'bibliofili': ('bibliofili',),
'bibliofilien': ('bibliofili',),
'bibliofilier': ('bibliofili',),
'bibliofiliene': ('bibliofili',),
'bibliofilutgave': ('bibliofilutgave',),
'bibliofilutgaven': ('bibliofilutgave',),
'bibliofilutgava': ('bibliofilutgave',),
'bibliofilutgaver': ('bibliofilutgave',),
'bibliofilutgavene': ('bibliofilutgave',),
'bibliograf': ('bibliograf',),
'bibliografen': ('bibliograf',),
'bibliografer': ('bibliograf',),
'bibliografene': ('bibliograf',),
'bibliografi': ('bibliografi',),
'bibliografien': ('bibliografi',),
'bibliografier': ('bibliografi',),
'bibliografiene': ('bibliografi',),
'bibliotek': ('bibliotek',),
'biblioteket': ('bibliotek',),
'bibliotek': ('bibliotek',),
'biblioteker': ('bibliotek',),
'bibliotek': ('bibliotek',),
'biblioteker': ('bibliotek',),
'biblioteka': ('bibliotek',),
'bibliotekene': ('bibliotek',),
'bibliotekar': ('bibliotekar',),
'bibliotekaren': ('bibliotekar',),
'bibliotekarer': ('bibliotekar',),
'bibliotekarene': ('bibliotekar',),
'bibringe': ('bibringe',),
'bibringen': ('bibringe',),
'bibringer': ('bibringe',),
'bibringene': ('bibringe',),
'biceps': ('biceps',),
'bicepsen': ('biceps',),
'bicepser': ('biceps',),
'bicepsene': ('biceps',),
'bidé': ('bidé',),
'bidéet': ('bidé',),
'bideet': ('bidé',),
'bidé': ('bidé',),
'bidéer': ('bidé',),
'bidé': ('bidé',),
'bidéer': ('bidé',),
'bideer': ('bidé',),
'bidé': ('bidé',),
'bidéa': ('bidé',),
'bidéene': ('bidé',),
'bidea': ('bidé',),
'bideene': ('bidé',),
'bidea': ('bidé',),
'bideene': ('bidé',),
'bidevindsegler': ('bidevindsegler',),
'bidevindsegleren': ('bidevindsegler',),
'bidevindseglere': ('bidevindsegler',),
'bidevindseglerne': ('bidevindsegler',),
'bidevindseiler': ('bidevindseiler',),
'bidevindseileren': ('bidevindseiler',),
'bidevindseilere': ('bidevindseiler',),
'bidevindseilerne': ('bidevindseiler',),
'bidevindssegler': ('bidevindssegler',),
'bidevindssegleren': ('bidevindssegler',),
'bidevindsseglere': ('bidevindssegler',),
'bidevindsseglerne': ('bidevindssegler',),
'bidevindsseiler': ('bidevindsseiler',),
'bidevindsseileren': ('bidevindsseiler',),
'bidevindsseilere': ('bidevindsseiler',),
'bidevindsseilerne': ('bidevindsseiler',),
'bidrag': ('bidrag',),
'bidraget': ('bidrag',),
'bidrag': ('bidrag',),
'bidraga': ('bidrag',),
'bidragene': ('bidrag',),
'bidragsfogd': ('bidragsfogd',),
'bidragsfogden': ('bidragsfogd',),
'bidragsfogder': ('bidragsfogd',),
'bidragsfogdene': ('bidragsfogd',),
'bidragsfut': ('bidragsfut',),
'bidragsfuten': ('bidragsfut',),
'bidragsfuter': ('bidragsfut',),
'bidragsfutene': ('bidragsfut',),
'bidragsplikt': ('bidragsplikt',),
'bidragsplikten': ('bidragsplikt',),
'bidragsplikta': ('bidragsplikt',),
'bidragsplikter': ('bidragsplikt',),
'bidragspliktene': ('bidragsplikt',),
'bidragsyter': ('bidragsyter',),
'bidragsyteren': ('bidragsyter',),
'bidragsytere': ('bidragsyter',),
'bidragsyterne': ('bidragsyter',),
'bidronning': ('bidronning',),
'bidronningen': ('bidronning',),
'bidronninga': ('bidronning',),
'bidronninger': ('bidronning',),
'bidronningene': ('bidronning',),
'bie': ('bie',),
'bien': ('bie',),
'bia': ('bie',),
'bier': ('bie',),
'biene': ('bie',),
'biedermeier': ('biedermeier',),
'biedermeieren': ('biedermeier',),
'biedermeierer': ('biedermeier',),
'biedermeierene': ('biedermeier',),
'biedermeierinteriør': ('biedermeierinteriør',),
'biedermeierinteriøret': ('biedermeierinteriør',),
'biedermeierinteriør': ('biedermeierinteriør',),
'biedermeierinteriører': ('biedermeierinteriør',),
'biedermeierinteriør': ('biedermeierinteriør',),
'biedermeierinteriører': ('biedermeierinteriør',),
'biedermeierinteriøra': ('biedermeierinteriør',),
'biedermeierinteriørene': ('biedermeierinteriør',),
'biedermeierstil': ('biedermeierstil',),
'biedermeierstilen': ('biedermeierstil',),
'biedermeierstiler': ('biedermeierstil',),
'biedermeierstilene': ('biedermeierstil',),
'bielv': ('bielv',),
'bielven': ('bielv',),
'bielva': ('bielv',),
'bielver': ('bielv',),
'bielvene': ('bielv',),
'biennale': ('biennale',),
'biennalen': ('biennale',),
'biennaler': ('biennale',),
'biennalene': ('biennale',),
'bierverv': ('bierverv',),
'biervervet': ('bierverv',),
'bierverv': ('bierverv',),
'bierverva': ('bierverv',),
'biervervene': ('bierverv',),
'bifag': ('bifag',),
'bifaget': ('bifag',),
'bifag': ('bifag',),
'bifaga': ('bifag',),
'bifagene': ('bifag',),
'bifall': ('bifall',),
'bifallet': ('bifall',),
'bifall': ('bifall',),
'bifalla': ('bifall',),
'bifallene': ('bifall',),
'bifallsklapp': ('bifallsklapp',),
'bifallsklappen': ('bifallsklapp',),
'bifallsklappet': ('bifallsklapp',),
'bifallsklapper': ('bifallsklapp',),
'bifallsklapp': ('bifallsklapp',),
'bifallsklappene': ('bifallsklapp',),
'bifallsklappa': ('bifallsklapp',),
'bifallsklappene': ('bifallsklapp',),
'bifallsrop': ('bifallsrop',),
'bifallsropet': ('bifallsrop',),
'bifallsrop': ('bifallsrop',),
'bifallsropa': ('bifallsrop',),
'bifallsropene': ('bifallsrop',),
'bifallsytring': ('bifallsytring',),
'bifallsytringen': ('bifallsytring',),
'bifallsytringa': ('bifallsytring',),
'bifallsytringer': ('bifallsytring',),
'bifallsytringene': ('bifallsytring',),
'biff': ('biff',),
'biffen': ('biff',),
'biffer': ('biff',),
'biffene': ('biff',),
'bifigur': ('bifigur',),
'bifiguren': ('bifigur',),
'bifigurer': ('bifigur',),
'bifigurene': ('bifigur',),
'bifili': ('bifili',),
'bifilien': ('bifili',),
'bifilier': ('bifili',),
'bifiliene': ('bifili',),
'bifolk': ('bifolk',),
'bifolket': ('bifolk',),
'bifolk': ('bifolk',),
'bifolka': ('bifolk',),
'bifolkene': ('bifolk',),
'bigami': ('bigami',),
'bigamiet': ('bigami',),
'bigami': ('bigami',),
'bigamia': ('bigami',),
'bigamiene': ('bigami',),
'bigamist': ('bigamist',),
'bigamisten': ('bigamist',),
'bigamister': ('bigamist',),
'bigamistene': ('bigamist',),
'bigift': ('bigift',),
'bigiften': ('bigift',),
'bigifta': ('bigift',),
'bigifter': ('bigift',),
'bigiftene': ('bigift',),
'bigotteri': ('bigotteri',),
'bigotteriet': ('bigotteri',),
'bigotteri': ('bigotteri',),
'bigotterier': ('bigotteri',),
'bigotteri': ('bigotteri',),
'bigotterier': ('bigotteri',),
'bigotteria': ('bigotteri',),
'bigotteriene': ('bigotteri',),
'bihandling': ('bihandling',),
'bihandlingen': ('bihandling',),
'bihandlinga': ('bihandling',),
'bihandlinger': ('bihandling',),
'bihandlingene': ('bihandling',),
'bihold': ('bihold',),
'biholdet': ('bihold',),
'bihold': ('bihold',),
'biholda': ('bihold',),
'biholdene': ('bihold',),
'bihole': ('bihole',),
'biholen': ('bihole',),
'bihola': ('bihole',),
'biholer': ('bihole',),
'biholene': ('bihole',),
'biholebetennelse': ('biholebetennelse',),
'biholebetennelsen': ('biholebetennelse',),
'biholebetennelser': ('biholebetennelse',),
'biholebetennelsene': ('biholebetennelse',),
'bihule': ('bihule',),
'bihulen': ('bihule',),
'bihula': ('bihule',),
'bihuler': ('bihule',),
'bihulene': ('bihule',),
'bihulebetennelse': ('bihulebetennelse',),
'bihulebetennelsen': ('bihulebetennelse',),
'bihulebetennelser': ('bihulebetennelse',),
'bihulebetennelsene': ('bihulebetennelse',),
'biinntekt': ('biinntekt',),
'biinntekten': ('biinntekt',),
'biinntekta': ('biinntekt',),
'biinntekter': ('biinntekt',),
'biinntektene': ('biinntekt',),
'bijouteri': ('bijouteri',),
'bijouteriet': ('bijouteri',),
'bijouteri': ('bijouteri',),
'bijouterier': ('bijouteri',),
'bijouteri': ('bijouteri',),
'bijouterier': ('bijouteri',),
'bijouteria': ('bijouteri',),
'bijouteriene': ('bijouteri',),
'bikini': ('bikini',),
'bikinien': ('bikini',),
'bikinier': ('bikini',),
'bikiniene': ('bikini',),
'bikk': ('bikk',),
'bikken': ('bikk',),
'bikker': ('bikk',),
'bikkene': ('bikk',),
'bikkje': ('bikkje',),
'bikkjen': ('bikkje',),
'bikkja': ('bikkje',),
'bikkjer': ('bikkje',),
'bikkjene': ('bikkje',),
'bikkjeleven': ('bikkjeleven',),
'bikkjelevenet': ('bikkjeleven',),
'bikkjeleven': ('bikkjeleven',),
'bikkjelevena': ('bikkjeleven',),
'bikkjelevenene': ('bikkjeleven',),
'bikkjeslagsmål': ('bikkjeslagsmål',),
'bikkjeslagsmålet': ('bikkjeslagsmål',),
'bikkjeslagsmål': ('bikkjeslagsmål',),
'bikkjeslagsmåla': ('bikkjeslagsmål',),
'bikkjeslagsmålene': ('bikkjeslagsmål',),
'biklang': ('biklang',),
'biklangen': ('biklang',),
'biklanger': ('biklang',),
'biklangene': ('biklang',),
'bikse': ('bikse',),
'biksen': ('bikse',),
'bikser': ('bikse',),
'biksene': ('bikse',),
'bikube': ('bikube',),
'bikuben': ('bikube',),
'bikuber': ('bikube',),
'bikubene': ('bikube',),
'bil': ('bil',),
'bilen': ('bil',),
'biler': ('bil',),
'bilene': ('bil',),
'bilabial': ('bilabial',),
'bilabialen': ('bilabial',),
'bilabialer': ('bilabial',),
'bilabialene': ('bilabial',),
'bilag': ('bilag',),
'bilaget': ('bilag',),
'bilag': ('bilag',),
'bilaga': ('bilag',),
'bilagene': ('bilag',),
'bilagsrevisjon': ('bilagsrevisjon',),
'bilagsrevisjonen': ('bilagsrevisjon',),
'bilagsrevisjoner': ('bilagsrevisjon',),
'bilagsrevisjonene': ('bilagsrevisjon',),
'bilbane': ('bilbane',),
'bilbanen': ('bilbane',),
'bilbaner': ('bilbane',),
'bilbanene': ('bilbane',),
'bilbelte': ('bilbelte',),
'bilbeltet': ('bilbelte',),
'bilbelter': ('bilbelte',),
'bilbelta': ('bilbelte',),
'bilbeltene': ('bilbelte',),
'bilbrev': ('bilbrev',),
'bilbrevet': ('bilbrev',),
'bilbrev': ('bilbrev',),
'bilbrever': ('bilbrev',),
'bilbrev': ('bilbrev',),
'bilbrever': ('bilbrev',),
'bilbreva': ('bilbrev',),
'bilbrevene': ('bilbrev',),
'bilbrukstjuveri': ('bilbrukstjuveri',),
'bilbrukstjuveriet': ('bilbrukstjuveri',),
'bilbrukstjuveri': ('bilbrukstjuveri',),
'bilbrukstjuverier': ('bilbrukstjuveri',),
'bilbrukstjuveri': ('bilbrukstjuveri',),
'bilbrukstjuverier': ('bilbrukstjuveri',),
'bilbrukstjuveria': ('bilbrukstjuveri',),
'bilbrukstjuveriene': ('bilbrukstjuveri',),
'bilbrukstyveri': ('bilbrukstyveri',),
'bilbrukstyveriet': ('bilbrukstyveri',),
'bilbrukstyveri': ('bilbrukstyveri',),
'bilbrukstyverier': ('bilbrukstyveri',),
'bilbrukstyveri': ('bilbrukstyveri',),
'bilbrukstyverier': ('bilbrukstyveri',),
'bilbrukstyveria': ('bilbrukstyveri',),
'bilbrukstyveriene': ('bilbrukstyveri',),
'bilbås': ('bilbås',),
'bilbåsen': ('bilbås',),
'bilbåser': ('bilbås',),
'bilbåsene': ('bilbås',),
'bilbølle': ('bilbølle',),
'bilbøllen': ('bilbølle',),
'bilbølla': ('bilbølle',),
'bilbøller': ('bilbølle',),
'bilbøllene': ('bilbølle',),
'bilde': ('bilde',),
'bildet': ('bilde',),
'bilder': ('bilde',),
'bilda': ('bilde',),
'bildene': ('bilde',),
'bildearkiv': ('bildearkiv',),
'bildearkivet': ('bildearkiv',),
'bildearkiv': ('bildearkiv',),
'bildearkiver': ('bildearkiv',),
'bildearkiv': ('bildearkiv',),
'bildearkiver': ('bildearkiv',),
'bildearkiva': ('bildearkiv',),
'bildearkivene': ('bildearkiv',),
'bildeband': ('bildeband',),
'bildebandet': ('bildeband',),
'bildeband': ('bildeband',),
'bildebanda': ('bildeband',),
'bildebandene': ('bildeband',),
'bildebibel': ('bildebibel',),
'bildebibelen': ('bildebibel',),
'bildebibler': ('bildebibel',),
'bildebiblene': ('bildebibel',),
'bildebånd': ('bildebånd',),
'bildebåndet': ('bildebånd',),
'bildebånd': ('bildebånd',),
'bildebånda': ('bildebånd',),
'bildebåndene': ('bildebånd',),
'bildegalleri': ('bildegalleri',),
'bildegalleriet': ('bildegalleri',),
'bildegalleri': ('bildegalleri',),
'bildegallerier': ('bildegalleri',),
'bildegalleri': ('bildegalleri',),
'bildegallerier': ('bildegalleri',),
'bildegalleria': ('bildegalleri',),
'bildegalleriene': ('bildegalleri',),
'bildegåte': ('bildegåte',),
'bildegåten': ('bildegåte',),
'bildegåta': ('bildegåte',),
'bildegåter': ('bildegåte',),
'bildegåtene': ('bildegåte',),
'bildehogger': ('bildehogger',),
'bildehoggeren': ('bildehogger',),
'bildehoggere': ('bildehogger',),
'bildehoggerne': ('bildehogger',),
'bildehoggerkunst': ('bildehoggerkunst',),
'bildehoggerkunsten': ('bildehoggerkunst',),
'bildehoggerkunster': ('bildehoggerkunst',),
'bildehoggerkunstene': ('bildehoggerkunst',),
'bildehugger': ('bildehugger',),
'bildehuggeren': ('bildehugger',),
'bildehuggere': ('bildehugger',),
'bildehuggerne': ('bildehugger',),
'bildehuggerkunst': ('bildehuggerkunst',),
'bildehuggerkunsten': ('bildehuggerkunst',),
'bildehuggerkunster': ('bildehuggerkunst',),
'bildehuggerkunstene': ('bildehuggerkunst',),
'bildekk': ('bildekk',),
'bildekket': ('bildekk',),
'bildekk': ('bildekk',),
'bildekka': ('bildekk',),
'bildekkene': ('bildekk',),
'bildekunst': ('bildekunst',),
'bildekunsten': ('bildekunst',),
'bildekunster': ('bildekunst',),
'bildekunstene': ('bildekunst',),
'bildekunstner': ('bildekunstner',),
'bildekunstneren': ('bildekunstner',),
'bildekunstnere': ('bildekunstner',),
'bildekunstnerne': ('bildekunstner',),
'bildereportasje': ('bildereportasje',),
'bildereportasjen': ('bildereportasje',),
'bildereportasjer': ('bildereportasje',),
'bildereportasjene': ('bildereportasje',),
'bilderør': ('bilderør',),
'bilderøret': ('bilderør',),
'bilderør': ('bilderør',),
'bilderøra': ('bilderør',),
'bilderørene': ('bilderør',),
'bildesamband': ('bildesamband',),
'bildesambandet': ('bildesamband',),
'bildesamband': ('bildesamband',),
'bildesambanda': ('bildesamband',),
'bildesambandene': ('bildesamband',),
'bildeskarphet': ('bildeskarphet',),
'bildeskarpheten': ('bildeskarphet',),
'bildeskarpheta': ('bildeskarphet',),
'bildeskarpheter': ('bildeskarphet',),
'bildeskarphetene': ('bildeskarphet',),
'bildeskjærer': ('bildeskjærer',),
'bildeskjæreren': ('bildeskjærer',),
'bildeskjærere': ('bildeskjærer',),
'bildeskjærerne': ('bildeskjærer',),
'bildeskjæring': ('bildeskjæring',),
'bildeskjæringen': ('bildeskjæring',),
'bildeskjæringa': ('bildeskjæring',),
'bildeskjæringer': ('bildeskjæring',),
'bildeskjæringene': ('bildeskjæring',),
'bildeskrift': ('bildeskrift',),
'bildeskriften': ('bildeskrift',),
'bildeskrifta': ('bildeskrift',),
'bildeskrifter': ('bildeskrift',),
'bildeskriftene': ('bildeskrift',),
'bildespråk': ('bildespråk',),
'bildespråket': ('bildespråk',),
'bildespråk': ('bildespråk',),
'bildespråka': ('bildespråk',),
'bildespråkene': ('bildespråk',),
'bildestorm': ('bildestorm',),
'bildestormen': ('bildestorm',),
'bildestormer': ('bildestorm',),
'bildestormene': ('bildestorm',),
'bildestormer': ('bildestormer',),
'bildestormeren': ('bildestormer',),
'bildestormere': ('bildestormer',),
'bildestormerne': ('bildestormer',),
'bildetekst': ('bildetekst',),
'bildeteksten': ('bildetekst',),
'bildeteksta': ('bildetekst',),
'bildetekster': ('bildetekst',),
'bildetekstene': ('bildetekst',),
'bildetelegrafi': ('bildetelegrafi',),
'bildetelegrafien': ('bildetelegrafi',),
'bildetelegrafier': ('bildetelegrafi',),
'bildetelegrafiene': ('bildetelegrafi',),
'bildevev': ('bildevev',),
'bildeveven': ('bildevev',),
'bildevever': ('bildevev',),
'bildevevene': ('bildevev',),
'bildeveving': ('bildeveving',),
'bildevevingen': ('bildeveving',),
'bildevevinga': ('bildeveving',),
'bildevevinger': ('bildeveving',),
'bildevevingene': ('bildeveving',),
'bildevevning': ('bildevevning',),
'bildevevningen': ('bildevevning',),
'bildevevninga': ('bildevevning',),
'bildevevninger': ('bildevevning',),
'bildevevningene': ('bildevevning',),
'bildille': ('bildille',),
'bildillen': ('bildille',),
'bildilla': ('bildille',),
'bildiller': ('bildille',),
'bildillene': ('bildille',),
'bile': ('bile',),
'bilen': ('bile',),
'bila': ('bile',),
'biler': ('bile',),
'bilene': ('bile',),
'bileggerovn': ('bileggerovn',),
'bileggerovnen': ('bileggerovn',),
'bileggerovner': ('bileggerovn',),
'bileggerovnene': ('bileggerovn',),
'bileier': ('bileier',),
'bileieren': ('bileier',),
'bileiere': ('bileier',),
'bileierne': ('bileier',),
'bilferge': ('bilferge',),
'bilfergen': ('bilferge',),
'bilferga': ('bilferge',),
'bilferger': ('bilferge',),
'bilfergene': ('bilferge',),
'bilferje': ('bilferje',),
'bilferjen': ('bilferje',),
'bilferja': ('bilferje',),
'bilferjer': ('bilferje',),
'bilferjene': ('bilferje',),
'bilfolk': ('bilfolk',),
'bilfolket': ('bilfolk',),
'bilfolk': ('bilfolk',),
'bilfolka': ('bilfolk',),
'bilfolkene': ('bilfolk',),
'bilforhandler': ('bilforhandler',),
'bilforhandleren': ('bilforhandler',),
'bilforhandlere': ('bilforhandler',),
'bilforhandlerne': ('bilforhandler',),
'bilfører': ('bilfører',),
'bilføreren': ('bilfører',),
'bilførere': ('bilfører',),
'bilførerne': ('bilfører',),
'bilgodtgjørelse': ('bilgodtgjørelse',),
'bilgodtgjørelsen': ('bilgodtgjørelse',),
'bilgodtgjørelser': ('bilgodtgjørelse',),
'bilgodtgjørelsene': ('bilgodtgjørelse',),
'bilgodtgjøring': ('bilgodtgjøring',),
'bilgodtgjøringen': ('bilgodtgjøring',),
'bilgodtgjøringa': ('bilgodtgjøring',),
'bilgodtgjøringer': ('bilgodtgjøring',),
'bilgodtgjøringene': ('bilgodtgjøring',),
'bilgummi': ('bilgummi',),
'bilgummien': ('bilgummi',),
'bilgummier': ('bilgummi',),
'bilgummiene': ('bilgummi',),
'bilhold': ('bilhold',),
'bilholdet': ('bilhold',),
'bilhold': ('bilhold',),
'bilholda': ('bilhold',),
'bilholdene': ('bilhold',),
'bilhorn': ('bilhorn',),
'bilhornet': ('bilhorn',),
'bilhorn': ('bilhorn',),
'bilhorna': ('bilhorn',),
'bilhornene': ('bilhorn',),
'bilingvalisme': ('bilingvalisme',),
'bilingvalismen': ('bilingvalisme',),
'bilingvalismer': ('bilingvalisme',),
'bilingvalismene': ('bilingvalisme',),
'bilingvalitet': ('bilingvalitet',),
'bilingvaliteten': ('bilingvalitet',),
'bilingvaliteter': ('bilingvalitet',),
'bilingvalitetene': ('bilingvalitet',),
'bilingvisme': ('bilingvisme',),
'bilingvismen': ('bilingvisme',),
'bilingvismer': ('bilingvisme',),
'bilingvismene': ('bilingvisme',),
'bilingvitet': ('bilingvitet',),
'bilingviteten': ('bilingvitet',),
'bilingviteter': ('bilingvitet',),
'bilingvitetene': ('bilingvitet',),
'bilisme': ('bilisme',),
'bilismen': ('bilisme',),
'bilismer': ('bilisme',),
'bilismene': ('bilisme',),
'bilist': ('bilist',),
'bilisten': ('bilist',),
'bilister': ('bilist',),
'bilistene': ('bilist',),
'biljard': ('biljard',),
'biljarden': ('biljard',),
'biljarder': ('biljard',),
'biljardene': ('biljard',),
'biljardbord': ('biljardbord',),
'biljardbordet': ('biljardbord',),
'biljardbord': ('biljardbord',),
'biljardborder': ('biljardbord',),
'biljardbord': ('biljardbord',),
'biljardborder': ('biljardbord',),
'biljardborda': ('biljardbord',),
'biljardbordene': ('biljardbord',),
'bilkart': ('bilkart',),
'bilkartet': ('bilkart',),
'bilkart': ('bilkart',),
'bilkarter': ('bilkart',),
'bilkart': ('bilkart',),
'bilkarter': ('bilkart',),
'bilkarta': ('bilkart',),
'bilkartene': ('bilkart',),
'bilkirkegård': ('bilkirkegård',),
'bilkirkegården': ('bilkirkegård',),
'bilkirkegårder': ('bilkirkegård',),
'bilkirkegårdene': ('bilkirkegård',),
'bilkjennemerke': ('bilkjennemerke',),
'bilkjennemerket': ('bilkjennemerke',),
'bilkjennemerker': ('bilkjennemerke',),
'bilkjennemerka': ('bilkjennemerke',),
'bilkjennemerkene': ('bilkjennemerke',),
'bilkolonne': ('bilkolonne',),
'bilkolonnen': ('bilkolonne',),
'bilkolonner': ('bilkolonne',),
'bilkolonnene': ('bilkolonne',),
'bilkonsern': ('bilkonsern',),
'bilkonsernet': ('bilkonsern',),
'bilkonsern': ('bilkonsern',),
'bilkonserner': ('bilkonsern',),
'bilkonsern': ('bilkonsern',),
'bilkonserner': ('bilkonsern',),
'bilkonserna': ('bilkonsern',),
'bilkonsernene': ('bilkonsern',),
'bilkontroll': ('bilkontroll',),
'bilkontrollen': ('bilkontroll',),
'bilkontroller': ('bilkontroll',),
'bilkontrollene': ('bilkontroll',),
'bilkø': ('bilkø',),
'bilkøen': ('bilkø',),
'bilkøer': ('bilkø',),
'bilkøene': ('bilkø',),
'billass': ('billass',),
'billasset': ('billass',),
'billass': ('billass',),
'billassa': ('billass',),
'billassene': ('billass',),
'bille': ('bille',),
'billen': ('bille',),
'biller': ('bille',),
'billene': ('bille',),
'billedarkiv': ('billedarkiv',),
'billedarkivet': ('billedarkiv',),
'billedarkiv': ('billedarkiv',),
'billedarkiver': ('billedarkiv',),
'billedarkiv': ('billedarkiv',),
'billedarkiver': ('billedarkiv',),
'billedarkiva': ('billedarkiv',),
'billedarkivene': ('billedarkiv',),
'billedband': ('billedband',),
'billedbandet': ('billedband',),
'billedband': ('billedband',),
'billedbanda': ('billedband',),
'billedbandene': ('billedband',),
'billedbibel': ('billedbibel',),
'billedbibelen': ('billedbibel',),
'billedbibler': ('billedbibel',),
'billedbiblene': ('billedbibel',),
'billedbånd': ('billedbånd',),
'billedbåndet': ('billedbånd',),
'billedbånd': ('billedbånd',),
'billedbånda': ('billedbånd',),
'billedbåndene': ('billedbånd',),
'billedgalleri': ('billedgalleri',),
'billedgalleriet': ('billedgalleri',),
'billedgalleri': ('billedgalleri',),
'billedgallerier': ('billedgalleri',),
'billedgalleri': ('billedgalleri',),
'billedgallerier': ('billedgalleri',),
'billedgalleria': ('billedgalleri',),
'billedgalleriene': ('billedgalleri',),
'billedgåte': ('billedgåte',),
'billedgåten': ('billedgåte',),
'billedgåta': ('billedgåte',),
'billedgåter': ('billedgåte',),
'billedgåtene': ('billedgåte',),
'billedhogger': ('billedhogger',),
'billedhoggeren': ('billedhogger',),
'billedhoggere': ('billedhogger',),
'billedhoggerne': ('billedhogger',),
'billedhoggerkunst': ('billedhoggerkunst',),
'billedhoggerkunsten': ('billedhoggerkunst',),
'billedhoggerkunster': ('billedhoggerkunst',),
'billedhoggerkunstene': ('billedhoggerkunst',),
'billedhugger': ('billedhugger',),
'billedhuggeren': ('billedhugger',),
'billedhuggere': ('billedhugger',),
'billedhuggerne': ('billedhugger',),
'billedhuggerkunst': ('billedhuggerkunst',),
'billedhuggerkunsten': ('billedhuggerkunst',),
'billedhuggerkunster': ('billedhuggerkunst',),
'billedhuggerkunstene': ('billedhuggerkunst',),
'billedkunst': ('billedkunst',),
'billedkunsten': ('billedkunst',),
'billedkunster': ('billedkunst',),
'billedkunstene': ('billedkunst',),
'billedkunstner': ('billedkunstner',),
'billedkunstneren': ('billedkunstner',),
'billedkunstnere': ('billedkunstner',),
'billedkunstnerne': ('billedkunstner',),
'billedreportasje': ('billedreportasje',),
'billedreportasjen': ('billedreportasje',),
'billedreportasjer': ('billedreportasje',),
'billedreportasjene': ('billedreportasje',),
'billedrør': ('billedrør',),
'billedrøret': ('billedrør',),
'billedrør': ('billedrør',),
'billedrøra': ('billedrør',),
'billedrørene': ('billedrør',),
'billedsamband': ('billedsamband',),
'billedsambandet': ('billedsamband',),
'billedsamband': ('billedsamband',),
'billedsambanda': ('billedsamband',),
'billedsambandene': ('billedsamband',),
'billedskarphet': ('billedskarphet',),
'billedskarpheten': ('billedskarphet',),
'billedskarpheta': ('billedskarphet',),
'billedskarpheter': ('billedskarphet',),
'billedskarphetene': ('billedskarphet',),
'billedskjærer': ('billedskjærer',),
'billedskjæreren': ('billedskjærer',),
'billedskjærere': ('billedskjærer',),
'billedskjærerne': ('billedskjærer',),
'billedskjæring': ('billedskjæring',),
'billedskjæringen': ('billedskjæring',),
'billedskjæringa': ('billedskjæring',),
'billedskjæringer': ('billedskjæring',),
'billedskjæringene': ('billedskjæring',),
'billedskrift': ('billedskrift',),
'billedskriften': ('billedskrift',),
'billedskrifta': ('billedskrift',),
'billedskrifter': ('billedskrift',),
'billedskriftene': ('billedskrift',),
'billedspråk': ('billedspråk',),
'billedspråket': ('billedspråk',),
'billedspråk': ('billedspråk',),
'billedspråka': ('billedspråk',),
'billedspråkene': ('billedspråk',),
'billedstorm': ('billedstorm',),
'billedstormen': ('billedstorm',),
'billedstormer': ('billedstorm',),
'billedstormene': ('billedstorm',),
'billedstormer': ('billedstormer',),
'billedstormeren': ('billedstormer',),
'billedstormere': ('billedstormer',),
'billedstormerne': ('billedstormer',),
'billedtekst': ('billedtekst',),
'billedteksten': ('billedtekst',),
'billedteksta': ('billedtekst',),
'billedtekster': ('billedtekst',),
'billedtekstene': ('billedtekst',),
'billedtelegrafi': ('billedtelegrafi',),
'billedtelegrafien': ('billedtelegrafi',),
'billedtelegrafier': ('billedtelegrafi',),
'billedtelegrafiene': ('billedtelegrafi',),
'billedvev': ('billedvev',),
'billedveven': ('billedvev',),
'billedvever': ('billedvev',),
'billedvevene': ('billedvev',),
'billedveving': ('billedveving',),
'billedvevingen': ('billedveving',),
'billedvevinga': ('billedveving',),
'billedvevinger': ('billedveving',),
'billedvevingene': ('billedveving',),
'billedvevning': ('billedvevning',),
'billedvevningen': ('billedvevning',),
'billedvevninga': ('billedvevning',),
'billedvevninger': ('billedvevning',),
'billedvevningene': ('billedvevning',),
'billett': ('billett',),
'billetten': ('billett',),
'billetter': ('billett',),
'billettene': ('billett',),
'billetthefte': ('billetthefte',),
'billettheftet': ('billetthefte',),
'billetthefter': ('billetthefte',),
'billetthefta': ('billetthefte',),
'billettheftene': ('billetthefte',),
'billettkontor': ('billettkontor',),
'billettkontoret': ('billettkontor',),
'billettkontor': ('billettkontor',),
'billettkontorer': ('billettkontor',),
'billettkontor': ('billettkontor',),
'billettkontorer': ('billettkontor',),
'billettkontora': ('billettkontor',),
'billettkontorene': ('billettkontor',),
'billettkontroll': ('billettkontroll',),
'billettkontrollen': ('billettkontroll',),
'billettkontroller': ('billettkontroll',),
'billettkontrollene': ('billettkontroll',),
'billettluke': ('billettluke',),
'billettluken': ('billettluke',),
'billettluka': ('billettluke',),
'billettluker': ('billettluke',),
'billettlukene': ('billettluke',),
'billettpris': ('billettpris',),
'billettprisen': ('billettpris',),
'billettpriser': ('billettpris',),
'billettprisene': ('billettpris',),
'billettør': ('billettør',),
'billettøren': ('billettør',),
'billettører': ('billettør',),
'billettørene': ('billettør',),
'billigbillett': ('billigbillett',),
'billigbilletten': ('billigbillett',),
'billigbilletter': ('billigbillett',),
'billigbillettene': ('billigbillett',),
'billighet': ('billighet',),
'billigheten': ('billighet',),
'billigheta': ('billighet',),
'billigheter': ('billighet',),
'billighetene': ('billighet',),
'billighetserstatning': ('billighetserstatning',),
'billighetserstatningen': ('billighetserstatning',),
'billighetserstatninga': ('billighetserstatning',),
'billighetserstatninger': ('billighetserstatning',),
'billighetserstatningene': ('billighetserstatning',),
'billigsalg': ('billigsalg',),
'billigsalget': ('billigsalg',),
'billigsalg': ('billigsalg',),
'billigsalga': ('billigsalg',),
'billigsalgene': ('billigsalg',),
'billigutgave': ('billigutgave',),
'billigutgaven': ('billigutgave',),
'billigutgava': ('billigutgave',),
'billigutgaver': ('billigutgave',),
'billigutgavene': ('billigutgave',),
'billion': ('billion',),
'billionen': ('billion',),
'billioner': ('billion',),
'billionene': ('billion',),
'billiondel': ('billiondel',),
'billiondelen': ('billiondel',),
'billiondeler': ('billiondel',),
'billiondelene': ('billiondel',),
'billøp': ('billøp',),
'billøpet': ('billøp',),
'billøp': ('billøp',),
'billøpa': ('billøp',),
'billøpene': ('billøp',),
'bilmekaniker': ('bilmekaniker',),
'bilmekanikeren': ('bilmekaniker',),
'bilmekanikere': ('bilmekaniker',),
'bilmekanikerne': ('bilmekaniker',),
'bilmerke': ('bilmerke',),
'bilmerket': ('bilmerke',),
'bilmerker': ('bilmerke',),
'bilmerka': ('bilmerke',),
'bilmerkene': ('bilmerke',),
'bilnummer': ('bilnummer',),
'bilnummeret': ('bilnummer',),
'bilnummer': ('bilnummer',),
'bilnumre': ('bilnummer',),
'bilnumra': ('bilnummer',),
'bilnumrene': ('bilnummer',),
'bilnumra': ('bilnummer',),
'bilnumrene': ('bilnummer',),
'biloppretter': ('biloppretter',),
'biloppretteren': ('biloppretter',),
'bilopprettere': ('biloppretter',),
'biloppretterne': ('biloppretter',),
'bilpark': ('bilpark',),
'bilparken': ('bilpark',),
'bilparker': ('bilpark',),
'bilparkene': ('bilpark',),
'bilradio': ('bilradio',),
'bilradioen': ('bilradio',),
'bilradioer': ('bilradio',),
'bilradioene': ('bilradio',),
'bilreparatør': ('bilreparatør',),
'bilreparatøren': ('bilreparatør',),
'bilreparatører': ('bilreparatør',),
'bilreparatørene': ('bilreparatør',),
'biltilsyn': ('biltilsyn',),
'biltilsynet': ('biltilsyn',),
'biltilsyn': ('biltilsyn',),
'biltilsyna': ('biltilsyn',),
'biltilsynene': ('biltilsyn',),
'biltog': ('biltog',),
'biltoget': ('biltog',),
'biltog': ('biltog',),
'biltoga': ('biltog',),
'biltogene': ('biltog',),
'biltrafikk': ('biltrafikk',),
'biltrafikken': ('biltrafikk',),
'biltrafikker': ('biltrafikk',),
'biltrafikkene': ('biltrafikk',),
'bimetall': ('bimetall',),
'bimetallet': ('bimetall',),
'bimetall': ('bimetall',),
'bimetaller': ('bimetall',),
'bimetall': ('bimetall',),
'bimetaller': ('bimetall',),
'bimetalla': ('bimetall',),
'bimetallene': ('bimetall',),
'bimetallisme': ('bimetallisme',),
'bimetallismen': ('bimetallisme',),
'bimetallismer': ('bimetallisme',),
'bimetallismene': ('bimetallisme',),
'bind': ('bind',),
'bindet': ('bind',),
'bind': ('bind',),
'binda': ('bind',),
'bindene': ('bind',),
'binde-s': ('binde-s',),
'binde-s-en': ('binde-s',),
'binde-s-er': ('binde-s',),
'binde-s-ene': ('binde-s',),
'bindeledd': ('bindeledd',),
'bindeleddet': ('bindeledd',),
'bindeledd': ('bindeledd',),
'bindeledda': ('bindeledd',),
'bindeleddene': ('bindeledd',),
'bindemiddel': ('bindemiddel',),
'bindemiddelet': ('bindemiddel',),
'bindemidlet': ('bindemiddel',),
'bindemiddel': ('bindemiddel',),
'bindemidler': ('bindemiddel',),
'bindemidla': ('bindemiddel',),
'bindemidlene': ('bindemiddel',),
'bindemidla': ('bindemiddel',),
'bindemidlene': ('bindemiddel',),
'bindeord': ('bindeord',),
'bindeordet': ('bindeord',),
'bindeord': ('bindeord',),
'bindeorda': ('bindeord',),
'bindeordene': ('bindeord',),
'binder': ('binder',),
'binderen': ('binder',),
'bindere': ('binder',),
'binderne': ('binder',),
'binderi': ('binderi',),
'binderiet': ('binderi',),
'binderi': ('binderi',),
'binderier': ('binderi',),
'binderi': ('binderi',),
'binderier': ('binderi',),
'binderia': ('binderi',),
'binderiene': ('binderi',),
'binders': ('binders',),
'bindersen': ('binders',),
'binderser': ('binders',),
'binders': ('binders',),
'bindersene': ('binders',),
'bindestrek': ('bindestrek',),
'bindestreken': ('bindestrek',),
'bindestreker': ('bindestrek',),
'bindestrekene': ('bindestrek',),
'bindevev': ('bindevev',),
'bindevevet': ('bindevev',),
'bindevev': ('bindevev',),
'bindeveva': ('bindevev',),
'bindevevene': ('bindevev',),
'bindevokal': ('bindevokal',),
'bindevokalen': ('bindevokal',),
'bindevokaler': ('bindevokal',),
'bindevokalene': ('bindevokal',),
'binding': ('binding',),
'bindingen': ('binding',),
'bindinga': ('binding',),
'bindinger': ('binding',),
'bindingene': ('binding',),
'bindingsverk': ('bindingsverk',),
'bindingsverket': ('bindingsverk',),
'bindingsverk': ('bindingsverk',),
'bindingsverker': ('bindingsverk',),
'bindingsverk': ('bindingsverk',),
'bindingsverker': ('bindingsverk',),
'bindingsverka': ('bindingsverk',),
'bindingsverkene': ('bindingsverk',),
'bindingsverkshus': ('bindingsverkshus',),
'bindingsverkshuset': ('bindingsverkshus',),
'bindingsverkshus': ('bindingsverkshus',),
'bindingsverkshusa': ('bindingsverkshus',),
'bindingsverkshusene': ('bindingsverkshus',),
'bindsel': ('bindsel',),
'bindselet': ('bindsel',),
'bindslet': ('bindsel',),
'bindsel': ('bindsel',),
'bindsler': ('bindsel',),
'bindsla': ('bindsel',),
'bindslene': ('bindsel',),
'bindsla': ('bindsel',),
'bindslene': ('bindsel',),
'binge': ('binge',),
'bingen': ('binge',),
'binger': ('binge',),
'bingene': ('binge',),
'bingefjøs': ('bingefjøs',),
'bingefjøsen': ('bingefjøs',),
'bingefjøset': ('bingefjøs',),
'bingefjøs': ('bingefjøs',),
'bingefjøsene': ('bingefjøs',),
'bingefjøsa': ('bingefjøs',),
'bingefjøsene': ('bingefjøs',),
'bingo': ('bingo',),
'bingoen': ('bingo',),
'bingoer': ('bingo',),
'bingoene': ('bingo',),
'bingolokale': ('bingolokale',),
'bingolokalet': ('bingolokale',),
'bingolokaler': ('bingolokale',),
'bingolokala': ('bingolokale',),
'bingolokalene': ('bingolokale',),
'binne': ('binne',),
'binnen': ('binne',),
'binna': ('binne',),
'binner': ('binne',),
'binnene': ('binne',),
'binnsåle': ('binnsåle',),
'binnsålen': ('binnsåle',),
'binnsåler': ('binnsåle',),
'binnsålene': ('binnsåle',),
'binokkel': ('binokkel',),
'binokkelen': ('binokkel',),
'binokler': ('binokkel',),
'binoklene': ('binokkel',),
'binom': ('binom',),
'binomet': ('binom',),
'binom': ('binom',),
'binomer': ('binom',),
'binom': ('binom',),
'binomer': ('binom',),
'binoma': ('binom',),
'binomene': ('binom',),
'binomialformel': ('binomialformel',),
'binomialformelen': ('binomialformel',),
'binomialformler': ('binomialformel',),
'binomialformlene': ('binomialformel',),
'binyre': ('binyre',),
'binyren': ('binyre',),
'binyret': ('binyre',),
'binyra': ('binyre',),
'binyrer': ('binyre',),
'binyrene': ('binyre',),
'binyra': ('binyre',),
'binyrene': ('binyre',),
'binæring': ('binæring',),
'binæringen': ('binæring',),
'binæringa': ('binæring',),
'binæringer': ('binæring',),
'binæringene': ('binæring',),
'biocid': ('biocid',),
'biocidet': ('biocid',),
'biocid': ('biocid',),
'biocider': ('biocid',),
'biocid': ('biocid',),
'biocider': ('biocid',),
'biocida': ('biocid',),
'biocidene': ('biocid',),
'biodynamikk': ('biodynamikk',),
'biodynamikken': ('biodynamikk',),
'biodynamikker': ('biodynamikk',),
'biodynamikkene': ('biodynamikk',),
'biofysikk': ('biofysikk',),
'biofysikken': ('biofysikk',),
'biofysikker': ('biofysikk',),
'biofysikkene': ('biofysikk',),
'biograf': ('biograf',),
'biografen': ('biograf',),
'biografer': ('biograf',),
'biografene': ('biograf',),
'biografi': ('biografi',),
'biografien': ('biografi',),
'biografier': ('biografi',),
'biografiene': ('biografi',),
'biokjemi': ('biokjemi',),
'biokjemien': ('biokjemi',),
'biokjemier': ('biokjemi',),
'biokjemiene': ('biokjemi',),
'biokjemiker': ('biokjemiker',),
'biokjemikeren': ('biokjemiker',),
'biokjemikere': ('biokjemiker',),
'biokjemikerne': ('biokjemiker',),
'biolitt': ('biolitt',),
'biolitten': ('biolitt',),
'biolitter': ('biolitt',),
'biolittene': ('biolitt',),
'biolog': ('biolog',),
'biologen': ('biolog',),
'biologer': ('biolog',),
'biologene': ('biolog',),
'biologi': ('biologi',),
'biologien': ('biologi',),
'biologier': ('biologi',),
'biologiene': ('biologi',),
'biomasse': ('biomasse',),
'biomassen': ('biomasse',),
'biomasser': ('biomasse',),
'biomassene': ('biomasse',),
'biopsi': ('biopsi',),
'biopsien': ('biopsi',),
'biopsier': ('biopsi',),
'biopsiene': ('biopsi',),
'biorytme': ('biorytme',),
'biorytmen': ('biorytme',),
'biorytmer': ('biorytme',),
'biorytmene': ('biorytme',),
'biosfære': ('biosfære',),
'biosfæren': ('biosfære',),
'biosfærer': ('biosfære',),
'biosfærene': ('biosfære',),
'bioteknikk': ('bioteknikk',),
'bioteknikken': ('bioteknikk',),
'bioteknikker': ('bioteknikk',),
'bioteknikkene': ('bioteknikk',),
'bioteknologi': ('bioteknologi',),
'bioteknologien': ('bioteknologi',),
'bioteknologier': ('bioteknologi',),
'bioteknologiene': ('bioteknologi',),
'biotop': ('biotop',),
'biotopen': ('biotop',),
'biotoper': ('biotop',),
'biotopene': ('biotop',),
'biotyp': ('biotyp',),
'biotypen': ('biotyp',),
'biotyper': ('biotyp',),
'biotypene': ('biotyp',),
'biperson': ('biperson',),
'bipersonen': ('biperson',),
'bipersoner': ('biperson',),
'bipersonene': ('biperson',),
'biprodukt': ('biprodukt',),
'biproduktet': ('biprodukt',),
'biprodukt': ('biprodukt',),
'biprodukter': ('biprodukt',),
'biprodukt': ('biprodukt',),
'biprodukter': ('biprodukt',),
'biprodukta': ('biprodukt',),
'biproduktene': ('biprodukt',),
'birgittiner': ('birgittiner',),
'birgittineren': ('birgittiner',),
'birgittinere': ('birgittiner',),
'birgittinerne': ('birgittiner',),
'birgittinerkloster': ('birgittinerkloster',),
'birgittinerklosteret': ('birgittinerkloster',),
'birgittinerklostret': ('birgittinerkloster',),
'birgittinerkloster': ('birgittinerkloster',),
'birgittinerklostre': ('birgittinerkloster',),
'birgittinerklostra': ('birgittinerkloster',),
'birgittinerklostrene': ('birgittinerkloster',),
'birgittinerklostra': ('birgittinerkloster',),
'birgittinerklostrene': ('birgittinerkloster',),
'birgittinermunk': ('birgittinermunk',),
'birgittinermunken': ('birgittinermunk',),
'birgittinermunker': ('birgittinermunk',),
'birgittinermunkene': ('birgittinermunk',),
'birgittinernonne': ('birgittinernonne',),
'birgittinernonnen': ('birgittinernonne',),
'birgittinernonna': ('birgittinernonne',),
'birgittinernonner': ('birgittinernonne',),
'birgittinernonnene': ('birgittinernonne',),
'birgittinerorden': ('birgittinerorden',),
'birgittinerordenen': ('birgittinerorden',),
'birgittinerordener': ('birgittinerorden',),
'birgittinerordenene': ('birgittinerorden',),
'birkebeiner': ('birkebeiner',),
'birkebeineren': ('birkebeiner',),
'birkebeinere': ('birkebeiner',),
'birkebeinerne': ('birkebeiner',),
'birolle': ('birolle',),
'birollen': ('birolle',),
'birolla': ('birolle',),
'biroller': ('birolle',),
'birollene': ('birolle',),
'birøkt': ('birøkt',),
'birøkten': ('birøkt',),
'birøkta': ('birøkt',),
'birøkter': ('birøkt',),
'birøktene': ('birøkt',),
'birøkter': ('birøkter',),
'birøkteren': ('birøkter',),
'birøktere': ('birøkter',),
'birøkterne': ('birøkter',),
'bisak': ('bisak',),
'bisaken': ('bisak',),
'bisaka': ('bisak',),
'bisaker': ('bisak',),
'bisakene': ('bisak',),
'bisam': ('bisam',),
'bisamen': ('bisam',),
'bisamer': ('bisam',),
'bisamene': ('bisam',),
'bisamfunn': ('bisamfunn',),
'bisamfunnet': ('bisamfunn',),
'bisamfunn': ('bisamfunn',),
'bisamfunna': ('bisamfunn',),
'bisamfunnene': ('bisamfunn',),
'bisamkåpe': ('bisamkåpe',),
'bisamkåpen': ('bisamkåpe',),
'bisamkåpa': ('bisamkåpe',),
'bisamkåper': ('bisamkåpe',),
'bisamkåpene': ('bisamkåpe',),
'bisamrotte': ('bisamrotte',),
'bisamrotten': ('bisamrotte',),
'bisamrotta': ('bisamrotte',),
'bisamrotter': ('bisamrotte',),
'bisamrottene': ('bisamrotte',),
'bisamskinn': ('bisamskinn',),
'bisamskinnet': ('bisamskinn',),
'bisamskinn': ('bisamskinn',),
'bisamskinna': ('bisamskinn',),
'bisamskinnene': ('bisamskinn',),
'bisarreri': ('bisarreri',),
'bisarreriet': ('bisarreri',),
'bisarreri': ('bisarreri',),
'bisarrerier': ('bisarreri',),
'bisarreri': ('bisarreri',),
'bisarrerier': ('bisarreri',),
'bisarreria': ('bisarreri',),
'bisarreriene': ('bisarreri',),
'biscene': ('biscene',),
'biscenen': ('biscene',),
'biscener': ('biscene',),
'biscenene': ('biscene',),
'bise': ('bise',),
'bisen': ('bise',),
'biser': ('bise',),
'bisene': ('bise',),
'biseksualitet': ('biseksualitet',),
'biseksualiteten': ('biseksualitet',),
'biseksualiteter': ('biseksualitet',),
'biseksualitetene': ('biseksualitet',),
'bisetning': ('bisetning',),
'bisetningen': ('bisetning',),
'bisetninga': ('bisetning',),
'bisetninger': ('bisetning',),
'bisetningene': ('bisetning',),
'bisettelse': ('bisettelse',),
'bisettelsen': ('bisettelse',),
'bisettelser': ('bisettelse',),
'bisettelsene': ('bisettelse',),
'bisitter': ('bisitter',),
'bisitteren': ('bisitter',),
'bisittere': ('bisitter',),
'bisitterne': ('bisitter',),
'bisk': ('bisk',),
'bisken': ('bisk',),
'bisker': ('bisk',),
'biskene': ('bisk',),
'biskop': ('biskop',),
'biskopen': ('biskop',),
'biskoper': ('biskop',),
'biskopene': ('biskop',),
'biskuit': ('biskuit',),
'biskuiten': ('biskuit',),
'biskuiter': ('biskuit',),
'biskuitene': ('biskuit',),
'bislag': ('bislag',),
'bislaget': ('bislag',),
'bislag': ('bislag',),
'bislaga': ('bislag',),
'bislagene': ('bislag',),
'bismak': ('bismak',),
'bismaken': ('bismak',),
'bismaker': ('bismak',),
'bismakene': ('bismak',),
'bismer': ('bismer',),
'bismeren': ('bismer',),
'bismere': ('bismer',),
'bismerne': ('bismer',),
'bismerkrok': ('bismerkrok',),
'bismerkroken': ('bismerkrok',),
'bismerkroker': ('bismerkrok',),
'bismerkrokene': ('bismerkrok',),
'bismerlodd': ('bismerlodd',),
'bismerloddet': ('bismerlodd',),
'bismerlodd': ('bismerlodd',),
'bismerlodder': ('bismerlodd',),
'bismerlodd': ('bismerlodd',),
'bismerlodder': ('bismerlodd',),
'bismerlodda': ('bismerlodd',),
'bismerloddene': ('bismerlodd',),
'bismerpund': ('bismerpund',),
'bismerpundet': ('bismerpund',),
'bismerpund': ('bismerpund',),
'bismerpunda': ('bismerpund',),
'bismerpundene': ('bismerpund',),
'bismerstang': ('bismerstang',),
'bismerstangen': ('bismerstang',),
'bismerstanga': ('bismerstang',),
'bismerstenger': ('bismerstang',),
'bismerstengene': ('bismerstang',),
'bismervekt': ('bismervekt',),
'bismervekten': ('bismervekt',),
'bismervekta': ('bismervekt',),
'bismervekter': ('bismervekt',),
'bismervektene': ('bismervekt',),
'bisol': ('bisol',),
'bisolen': ('bisol',),
'bisola': ('bisol',),
'bisoler': ('bisol',),
'bisolene': ('bisol',),
'bison': ('bison',),
'bisonen': ('bison',),
'bisoner': ('bison',),
'bisonene': ('bison',),
'bisonokse': ('bisonokse',),
'bisonoksen': ('bisonokse',),
'bisonokser': ('bisonokse',),
'bisonoksene': ('bisonokse',),
'bispedømme': ('bispedømme',),
'bispedømmet': ('bispedømme',),
'bispedømmer': ('bispedømme',),
'bispedømma': ('bispedømme',),
'bispedømmene': ('bispedømme',),
'bispedømmeråd': ('bispedømmeråd',),
'bispedømmerådet': ('bispedømmeråd',),
'bispedømmeråd': ('bispedømmeråd',),
'bispedømmeråda': ('bispedømmeråd',),
'bispedømmerådene': ('bispedømmeråd',),
'bispeembete': ('bispeembete',),
'bispeembetet': ('bispeembete',),
'bispeembeter': ('bispeembete',),
'bispeembeta': ('bispeembete',),
'bispeembetene': ('bispeembete',),
'bispegard': ('bispegard',),
'bispegarden': ('bispegard',),
'bispegarder': ('bispegard',),
'bispegardene': ('bispegard',),
'bispegård': ('bispegård',),
'bispegården': ('bispegård',),
'bispegårder': ('bispegård',),
'bispegårdene': ('bispegård',),
'bispehue': ('bispehue',),
'bispehuen': ('bispehue',),
'bispehua': ('bispehue',),
'bispehuer': ('bispehue',),
'bispehuene': ('bispehue',),
'bispelue': ('bispelue',),
'bispeluen': ('bispelue',),
'bispelua': ('bispelue',),
'bispeluer': ('bispelue',),
'bispeluene': ('bispelue',),
'bispeordinasjon': ('bispeordinasjon',),
'bispeordinasjonen': ('bispeordinasjon',),
'bispeordinasjoner': ('bispeordinasjon',),
'bispeordinasjonene': ('bispeordinasjon',),
'bispering': ('bispering',),
'bisperingen': ('bispering',),
'bisperinger': ('bispering',),
'bisperingene': ('bispering',),
'bispesete': ('bispesete',),
'bispesetet': ('bispesete',),
'bispeseter': ('bispesete',),
'bispeseta': ('bispesete',),
'bispesetene': ('bispesete',),
'bispestol': ('bispestol',),
'bispestolen': ('bispestol',),
'bispestoler': ('bispestol',),
'bispestolene': ('bispestol',),
'bispevisitas': ('bispevisitas',),
'bispevisitasen': ('bispevisitas',),
'bispevisitaser': ('bispevisitas',),
'bispevisitasene': ('bispevisitas',),
'bissevov': ('bissevov',),
'bissevoven': ('bissevov',),
'bissevover': ('bissevov',),
'bissevovene': ('bissevov',),
'bistand': ('bistand',),
'bistanden': ('bistand',),
'bistander': ('bistand',),
'bistandene': ('bistand',),
'bistandsminister': ('bistandsminister',),
'bistandsministeren': ('bistandsminister',),
'bistandsministere': ('bistandsminister',),
'bistandsministrer': ('bistandsminister',),
'bistandsministre': ('bistandsminister',),
'bistandsministerne': ('bistandsminister',),
'bistandsministrene': ('bistandsminister',),
'bistandsplikt': ('bistandsplikt',),
'bistandsplikten': ('bistandsplikt',),
'bistandsplikta': ('bistandsplikt',),
'bistandsplikter': ('bistandsplikt',),
'bistandspliktene': ('bistandsplikt',),
'bistikk': ('bistikk',),
'bistikket': ('bistikk',),
'bistikk': ('bistikk',),
'bistikka': ('bistikk',),
'bistikkene': ('bistikk',),
'bistilling': ('bistilling',),
'bistillingen': ('bistilling',),
'bistillinga': ('bistilling',),
'bistillinger': ('bistilling',),
'bistillingene': ('bistilling',),
'bistro': ('bistro',),
'bistroen': ('bistro',),
'bistroer': ('bistro',),
'bistroene': ('bistro',),
'bisverm': ('bisverm',),
'bisvermen': ('bisverm',),
'bisvermer': ('bisverm',),
'bisvermene': ('bisverm',),
'bit': ('bit',),
'biten': ('bit',),
'biter': ('bit',),
'bit': ('bit',),
'bitene': ('bit',),
'bit': ('bit',),
'biten': ('bit',),
'biter': ('bit',),
'bitene': ('bit',),
'bitemunn': ('bitemunn',),
'bitemunnen': ('bitemunn',),
'bitemunner': ('bitemunn',),
'bitemunnene': ('bitemunn',),
'bitestikkel': ('bitestikkel',),
'bitestikkelen': ('bitestikkel',),
'bitestikler': ('bitestikkel',),
'bitestiklene': ('bitestikkel',),
'biteti': ('biteti',),
'bitetiet': ('biteti',),
'biteti': ('biteti',),
'bitetia': ('biteti',),
'bitetiene': ('biteti',),
'biting': ('biting',),
'bitingen': ('biting',),
'biting': ('biting',),
'bitinga': ('biting',),
'bitingene': ('biting',),
'bitjern': ('bitjern',),
'bitjernet': ('bitjern',),
'bitjern': ('bitjern',),
'bitjerna': ('bitjern',),
'bitjernene': ('bitjern',),
'bitrykk': ('bitrykk',),
'bitrykket': ('bitrykk',),
'bitrykk': ('bitrykk',),
'bitrykka': ('bitrykk',),
'bitrykkene': ('bitrykk',),
'bitt': ('bitt',),
'bittet': ('bitt',),
'bitt': ('bitt',),
'bitta': ('bitt',),
'bittene': ('bitt',),
'bittekonvall': ('bittekonvall',),
'bittekonvallen': ('bittekonvall',),
'bittekonvaller': ('bittekonvall',),
'bittekonvallene': ('bittekonvall',),
'bitter': ('bitter',),
'bitteren': ('bitter',),
'bittere': ('bitter',),
'bitterne': ('bitter',),
'bitterhet': ('bitterhet',),
'bitterheten': ('bitterhet',),
'bitterheta': ('bitterhet',),
'bitterheter': ('bitterhet',),
'bitterhetene': ('bitterhet',),
'bitterstoff': ('bitterstoff',),
'bitterstoffet': ('bitterstoff',),
'bitterstoff': ('bitterstoff',),
'bitterstoffer': ('bitterstoff',),
'bitterstoff': ('bitterstoff',),
'bitterstoffer': ('bitterstoff',),
'bitterstoffa': ('bitterstoff',),
'bitterstoffene': ('bitterstoff',),
'bittervin': ('bittervin',),
'bittervinen': ('bittervin',),
'bitterviner': ('bittervin',),
'bittervinene': ('bittervin',),
'bitumen': ('bitumen',),
'bitumenet': ('bitumen',),
'bitumen': ('bitumen',),
'bitumena': ('bitumen',),
'bitumenene': ('bitumen',),
'bivirkning': ('bivirkning',),
'bivirkningen': ('bivirkning',),
'bivirkninga': ('bivirkning',),
'bivirkninger': ('bivirkning',),
'bivirkningene': ('bivirkning',),
'bivoks': ('bivoks',),
'bivoksen': ('bivoks',),
'bivokset': ('bivoks',),
'bivokser': ('bivoks',),
'bivoks': ('bivoks',),
'bivoksene': ('bivoks',),
'bivoksa': ('bivoks',),
'bivoksene': ('bivoks',),
'bivuakk': ('bivuakk',),
'bivuakken': ('bivuakk',),
'bivuakker': ('bivuakk',),
'bivuakkene': ('bivuakk',),
'bjeff': ('bjeff',),
'bjeffet': ('bjeff',),
'bjeff': ('bjeff',),
'bjeffa': ('bjeff',),
'bjeffene': ('bjeff',),
'bjekso': ('bjekso',),
'bjeksoen': ('bjekso',),
'bjeksoer': ('bjekso',),
'bjeksoene': ('bjekso',),
'bjelke': ('bjelke',),
'bjelken': ('bjelke',),
'bjelker': ('bjelke',),
'bjelkene': ('bjelke',),
'bjelkeloft': ('bjelkeloft',),
'bjelkeloftet': ('bjelkeloft',),
'bjelkeloft': ('bjelkeloft',),
'bjelkelofta': ('bjelkeloft',),
'bjelkeloftene': ('bjelkeloft',),
'bjelketak': ('bjelketak',),
'bjelketaket': ('bjelketak',),
'bjelketak': ('bjelketak',),
'bjelketaka': ('bjelketak',),
'bjelketakene': ('bjelketak',),
'bjelle': ('bjelle',),
'bjellen': ('bjelle',),
'bjella': ('bjelle',),
'bjeller': ('bjelle',),
'bjellene': ('bjelle',),
'bjelleblom': ('bjelleblom',),
'bjelleblommen': ('bjelleblom',),
'bjelleblommer': ('bjelleblom',),
'bjelleblommene': ('bjelleblom',),
'bjelleklang': ('bjelleklang',),
'bjelleklangen': ('bjelleklang',),
'bjelleklanger': ('bjelleklang',),
'bjelleklangene': ('bjelleklang',),
'bjelleklave': ('bjelleklave',),
'bjelleklaven': ('bjelleklave',),
'bjelleklaver': ('bjelleklave',),
'bjelleklavene': ('bjelleklave',),
'bjelleku': ('bjelleku',),
'bjellekuen': ('bjelleku',),
'bjellekua': ('bjelleku',),
'bjellekuer': ('bjelleku',),
'bjellekyr': ('bjelleku',),
'bjellekuer': ('bjelleku',),
'bjellekyr': ('bjelleku',),
'bjellekuene': ('bjelleku',),
'bjellekyrne': ('bjelleku',),
'bjellekuene': ('bjelleku',),
'bjellekyrne': ('bjelleku',),
'bjellesau': ('bjellesau',),
'bjellesauen': ('bjellesau',),
'bjellesauer': ('bjellesau',),
'bjellesauene': ('bjellesau',),
'bjerk': ('bjerk',),
'bjerken': ('bjerk',),
'bjerka': ('bjerk',),
'bjerker': ('bjerk',),
'bjerkene': ('bjerk',),
'bjerkebelte': ('bjerkebelte',),
'bjerkebeltet': ('bjerkebelte',),
'bjerkebelter': ('bjerkebelte',),
'bjerkebelta': ('bjerkebelte',),
'bjerkebeltene': ('bjerkebelte',),
'bjerkefamilie': ('bjerkefamilie',),
'bjerkefamilien': ('bjerkefamilie',),
'bjerkefamilier': ('bjerkefamilie',),
'bjerkefamiliene': ('bjerkefamilie',),
'bjerkefink': ('bjerkefink',),
'bjerkefinken': ('bjerkefink',),
'bjerkefinker': ('bjerkefink',),
'bjerkefinkene': ('bjerkefink',),
'bjerkeli': ('bjerkeli',),
'bjerkelien': ('bjerkeli',),
'bjerkelia': ('bjerkeli',),
'bjerkelier': ('bjerkeli',),
'bjerkeliene': ('bjerkeli',),
'bjerkeris': ('bjerkeris',),
'bjerkeriset': ('bjerkeris',),
'bjerkeris': ('bjerkeris',),
'bjerkerisa': ('bjerkeris',),
'bjerkerisene': ('bjerkeris',),
'bjerkestamme': ('bjerkestamme',),
'bjerkestammen': ('bjerkestamme',),
'bjerkestammer': ('bjerkestamme',),
'bjerkestammene': ('bjerkestamme',),
'bjerkeved': ('bjerkeved',),
'bjerkeveden': ('bjerkeved',),
'bjerkeveder': ('bjerkeved',),
'bjerkevedene': ('bjerkeved',),
'bjørk': ('bjørk',),
'bjørken': ('bjørk',),
'bjørka': ('bjørk',),
'bjørker': ('bjørk',),
'bjørkene': ('bjørk',),
'bjørkebelte': ('bjørkebelte',),
'bjørkebeltet': ('bjørkebelte',),
'bjørkebelter': ('bjørkebelte',),
'bjørkebelta': ('bjørkebelte',),
'bjørkebeltene': ('bjørkebelte',),
'bjørkefamilie': ('bjørkefamilie',),
'bjørkefamilien': ('bjørkefamilie',),
'bjørkefamilier': ('bjørkefamilie',),
'bjørkefamiliene': ('bjørkefamilie',),
'bjørkefink': ('bjørkefink',),
'bjørkefinken': ('bjørkefink',),
'bjørkefinker': ('bjørkefink',),
'bjørkefinkene': ('bjørkefink',),
'bjørkeli': ('bjørkeli',),
'bjørkelien': ('bjørkeli',),
'bjørkelia': ('bjørkeli',),
'bjørkelier': ('bjørkeli',),
'bjørkeliene': ('bjørkeli',),
'bjørkeris': ('bjørkeris',),
'bjørkeriset': ('bjørkeris',),
'bjørkeris': ('bjørkeris',),
'bjørkerisa': ('bjørkeris',),
'bjørkerisene': ('bjørkeris',),
'bjørkestamme': ('bjørkestamme',),
'bjørkestammen': ('bjørkestamme',),
'bjørkestammer': ('bjørkestamme',),
'bjørkestammene': ('bjørkestamme',),
'bjørkeved': ('bjørkeved',),
'bjørkeveden': ('bjørkeved',),
'bjørkeveder': ('bjørkeved',),
'bjørkevedene': ('bjørkeved',),
'bjørn': ('bjørn',),
'bjørnen': ('bjørn',),
'bjørner': ('bjørn',),
'bjørnene': ('bjørn',),
'bjørnebinne': ('bjørnebinne',),
'bjørnebinnen': ('bjørnebinne',),
'bjørnebinna': ('bjørnebinne',),
'bjørnebinner': ('bjørnebinne',),
'bjørnebinnene': ('bjørnebinne',),
'bjørnebær': ('bjørnebær',),
'bjørnebæret': ('bjørnebær',),
'bjørnebær': ('bjørnebær',),
'bjørnebæra': ('bjørnebær',),
'bjørnebærene': ('bjørnebær',),
'bjørnegrav': ('bjørnegrav',),
'bjørnegraven': ('bjørnegrav',),
'bjørnegrava': ('bjørnegrav',),
'bjørnegraver': ('bjørnegrav',),
'bjørnegravene': ('bjørnegrav',),
'bjørnehi': ('bjørnehi',),
'bjørnehiet': ('bjørnehi',),
'bjørnehi': ('bjørnehi',),
'bjørnehia': ('bjørnehi',),
'bjørnehiene': ('bjørnehi',),
'bjørnekam': ('bjørnekam',),
'bjørnekammen': ('bjørnekam',),
'bjørnekammer': ('bjørnekam',),
'bjørnekammene': ('bjørnekam',),
'bjørnekjeks': ('bjørnekjeks',),
'bjørnekjeksen': ('bjørnekjeks',),
'bjørnekjekser': ('bjørnekjeks',),
'bjørnekjeks': ('bjørnekjeks',),
'bjørnekjeksene': ('bjørnekjeks',),
'bjørneklo': ('bjørneklo',),
'bjørnekloen': ('bjørneklo',),
'bjørnekloa': ('bjørneklo',),
'bjørneklør': ('bjørneklo',),
'bjørneklørne': ('bjørneklo',),
'bjørnemose': ('bjørnemose',),
'bjørnemosen': ('bjørnemose',),
'bjørnemoser': ('bjørnemose',),
'bjørnemosene': ('bjørnemose',),
'bjørneskinn': ('bjørneskinn',),
'bjørneskinnet': ('bjørneskinn',),
'bjørneskinn': ('bjørneskinn',),
'bjørneskinna': ('bjørneskinn',),
'bjørneskinnene': ('bjørneskinn',),
'bjørneskinnslue': ('bjørneskinnslue',),
'bjørneskinnsluen': ('bjørneskinnslue',),
'bjørneskinnslua': ('bjørneskinnslue',),
'bjørneskinnsluer': ('bjørneskinnslue',),
'bjørneskinnsluene': ('bjørneskinnslue',),
'bjørnestamme': ('bjørnestamme',),
'bjørnestammen': ('bjørnestamme',),
'bjørnestammer': ('bjørnestamme',),
'bjørnestammene': ('bjørnestamme',),
'bjørnetjeneste': ('bjørnetjeneste',),
'bjørnetjenesten': ('bjørnetjeneste',),
'bjørnetjenester': ('bjørnetjeneste',),
'bjørnetjenestene': ('bjørnetjeneste',),
'bjørnunge': ('bjørnunge',),
'bjørnungen': ('bjørnunge',),
'bjørnunger': ('bjørnunge',),
'bjørnungene': ('bjørnunge',),
'bla-bla': ('bla-bla',),
'blackout': ('blackout',),
'blackouten': ('blackout',),
'blackouter': ('blackout',),
'blackoutene': ('blackout',),
'blad': ('blad',),
'bladet': ('blad',),
'blad': ('blad',),
'blader': ('blad',),
'blad': ('blad',),
'blader': ('blad',),
'blada': ('blad',),
'bladene': ('blad',),
'bladan': ('bladan',),
'bladanet': ('bladan',),
'bladan': ('bladan',),
'bladana': ('bladan',),
'bladanene': ('bladan',),
'bladbille': ('bladbille',),
'bladbillen': ('bladbille',),
'bladbiller': ('bladbille',),
'bladbillene': ('bladbille',),
'bladekspedisjon': ('bladekspedisjon',),
'bladekspedisjonen': ('bladekspedisjon',),
'bladekspedisjoner': ('bladekspedisjon',),
'bladekspedisjonene': ('bladekspedisjon',),
'bladfot': ('bladfot',),
'bladfoten': ('bladfot',),
'bladføtter': ('bladfot',),
'bladføttene': ('bladfot',),
'bladgrønt': ('bladgrønt',),
'bladgull': ('bladgull',),
'bladgullet': ('bladgull',),
'bladgull': ('bladgull',),
'bladgulla': ('bladgull',),
'bladgullene': ('bladgull',),
'bladkjeller': ('bladkjeller',),
'bladkjelleren': ('bladkjeller',),
'bladkjellere': ('bladkjeller',),
'bladkjellerne': ('bladkjeller',),
'bladkjøtt': ('bladkjøtt',),
'bladkjøttet': ('bladkjøtt',),
'bladkjøtt': ('bladkjøtt',),
'bladkjøtta': ('bladkjøtt',),
'bladkjøttene': ('bladkjøtt',),
'bladlus': ('bladlus',),
'bladlusen': ('bladlus',),
'bladlusa': ('bladlus',),
'bladlus': ('bladlus',),
'bladlusene': ('bladlus',),
'bladmage': ('bladmage',),
'bladmagen': ('bladmage',),
'bladmager': ('bladmage',),
'bladmagene': ('bladmage',),
'bladmave': ('bladmave',),
'bladmaven': ('bladmave',),
'bladmaver': ('bladmave',),
'bladmavene': ('bladmave',),
'bladmetall': ('bladmetall',),
'bladmetallet': ('bladmetall',),
'bladmetall': ('bladmetall',),
'bladmetaller': ('bladmetall',),
'bladmetall': ('bladmetall',),
'bladmetaller': ('bladmetall',),
'bladmetalla': ('bladmetall',),
'bladmetallene': ('bladmetall',),
'bladnerve': ('bladnerve',),
'bladnerven': ('bladnerve',),
'bladnerver': ('bladnerve',),
'bladnervene': ('bladnerve',),
'bladsalat': ('bladsalat',),
'bladsalaten': ('bladsalat',),
'bladsalater': ('bladsalat',),
'bladsalatene': ('bladsalat',),
'bladskjede': ('bladskjede',),
'bladskjeden': ('bladskjede',),
'bladskjeder': ('bladskjede',),
'bladskjedene': ('bladskjede',),
'bladslire': ('bladslire',),
'bladsliren': ('bladslire',),
'bladslira': ('bladslire',),
'bladslirer': ('bladslire',),
'bladslirene': ('bladslire',),
'bladstilk': ('bladstilk',),
'bladstilken': ('bladstilk',),
'bladstilker': ('bladstilk',),
'bladstilkene': ('bladstilk',),
'bladsølv': ('bladsølv',),
'bladsølvet': ('bladsølv',),
'bladsølv': ('bladsølv',),
'bladsølva': ('bladsølv',),
'bladsølvene': ('bladsølv',),
'bladtobakk': ('bladtobakk',),
'bladtobakken': ('bladtobakk',),
'bladtobakker': ('bladtobakk',),
'bladtobakkene': ('bladtobakk',),
'bladvott': ('bladvott',),
'bladvotten': ('bladvott',),
'bladvotter': ('bladvott',),
'bladvottene': ('bladvott',),
'blaff': ('blaff',),
'blaffen': ('blaff',),
'blaffer': ('blaff',),
'blaffene': ('blaff',),
'blaff': ('blaff',),
'blaffet': ('blaff',),
'blaff': ('blaff',),
'blaffa': ('blaff',),
'blaffene': ('blaff',),
'blakkert': ('blakkert',),
'blakkerten': ('blakkert',),
'blakkerter': ('blakkert',),
'blakkertene': ('blakkert',),
'blamasje': ('blamasje',),
'blamasjen': ('blamasje',),
'blamasjer': ('blamasje',),
'blamasjene': ('blamasje',),
'blande': ('blande',),
'blanden': ('blande',),
'blanda': ('blande',),
'blander': ('blande',),
'blandene': ('blande',),
'blandeapparat': ('blandeapparat',),
'blandeapparatet': ('blandeapparat',),
'blandeapparat': ('blandeapparat',),
'blandeapparater': ('blandeapparat',),
'blandeapparat': ('blandeapparat',),
'blandeapparater': ('blandeapparat',),
'blandeapparata': ('blandeapparat',),
'blandeapparatene': ('blandeapparat',),
'blandebatteri': ('blandebatteri',),
'blandebatteriet': ('blandebatteri',),
'blandebatteri': ('blandebatteri',),
'blandebatterier': ('blandebatteri',),
'blandebatteri': ('blandebatteri',),
'blandebatterier': ('blandebatteri',),
'blandebatteria': ('blandebatteri',),
'blandebatteriene': ('blandebatteri',),
'blandemaskin': ('blandemaskin',),
'blandemaskinen': ('blandemaskin',),
'blandemaskiner': ('blandemaskin',),
'blandemaskinene': ('blandemaskin',),
'blander': ('blander',),
'blanderen': ('blander',),
'blandere': ('blander',),
'blanderne': ('blander',),
'blandevann': ('blandevann',),
'blandevannet': ('blandevann',),
'blandevann': ('blandevann',),
'blandevanna': ('blandevann',),
'blandevannene': ('blandevann',),
'blandevatn': ('blandevatn',),
'blandevatnet': ('blandevatn',),
'blandevatn': ('blandevatn',),
'blandevatna': ('blandevatn',),
'blandevatnene': ('blandevatn',),
'blandfrø': ('blandfrø',),
'blandfrøet': ('blandfrø',),
'blandfrø': ('blandfrø',),
'blandfrøa': ('blandfrø',),
'blandfrøene': ('blandfrø',),
'blanding': ('blanding',),
'blandingen': ('blanding',),
'blandinga': ('blanding',),
'blandinger': ('blanding',),
'blandingene': ('blanding',),
'blandingsdrikk': ('blandingsdrikk',),
'blandingsdrikken': ('blandingsdrikk',),
'blandingsdrikker': ('blandingsdrikk',),
'blandingsdrikkene': ('blandingsdrikk',),
'blandingsfarge': ('blandingsfarge',),
'blandingsfargen': ('blandingsfarge',),
'blandingsfarger': ('blandingsfarge',),
'blandingsfargene': ('blandingsfarge',),
'blandingsfolk': ('blandingsfolk',),
'blandingsfolket': ('blandingsfolk',),
'blandingsfolk': ('blandingsfolk',),
'blandingsfolka': ('blandingsfolk',),
'blandingsfolkene': ('blandingsfolk',),
'blandingsforhold': ('blandingsforhold',),
'blandingsforholdet': ('blandingsforhold',),
'blandingsforhold': ('blandingsforhold',),
'blandingsforholda': ('blandingsforhold',),
'blandingsforholdene': ('blandingsforhold',),
'blandingsføre': ('blandingsføre',),
'blandingsføret': ('blandingsføre',),
'blandingsfører': ('blandingsføre',),
'blandingsføra': ('blandingsføre',),
'blandingsførene': ('blandingsføre',),
'blandingsrase': ('blandingsrase',),
'blandingsrasen': ('blandingsrase',),
'blandingsraser': ('blandingsrase',),
'blandingsrasene': ('blandingsrase',),
'blandingsskog': ('blandingsskog',),
'blandingsskogen': ('blandingsskog',),
'blandingsskoger': ('blandingsskog',),
'blandingsskogene': ('blandingsskog',),
'blandingsspråk': ('blandingsspråk',),
'blandingsspråket': ('blandingsspråk',),
'blandingsspråk': ('blandingsspråk',),
'blandingsspråka': ('blandingsspråk',),
'blandingsspråkene': ('blandingsspråk',),
'blandingsøkonomi': ('blandingsøkonomi',),
'blandingsøkonomien': ('blandingsøkonomi',),
'blandingsøkonomier': ('blandingsøkonomi',),
'blandingsøkonomiene': ('blandingsøkonomi',),
'blandkorn': ('blandkorn',),
'blandkornet': ('blandkorn',),
'blandkorn': ('blandkorn',),
'blandkorna': ('blandkorn',),
'blandkornene': ('blandkorn',),
'blankett': ('blankett',),
'blanketten': ('blankett',),
'blanketter': ('blankett',),
'blankettene': ('blankett',),
'blankis': ('blankis',),
'blankisen': ('blankis',),
'blankiser': ('blankis',),
'blankisene': ('blankis',),
'blanklaks': ('blanklaks',),
'blanklaksen': ('blanklaks',),
'blanklakser': ('blanklaks',),
'blanklaksene': ('blanklaks',),
'blankoaksept': ('blankoaksept',),
'blankoaksepten': ('blankoaksept',),
'blankoaksepter': ('blankoaksept',),
'blankoakseptene': ('blankoaksept',),
'blankofullmakt': ('blankofullmakt',),
'blankofullmakten': ('blankofullmakt',),
'blankofullmakta': ('blankofullmakt',),
'blankofullmakter': ('blankofullmakt',),
'blankofullmaktene': ('blankofullmakt',),
'blankokreditt': ('blankokreditt',),
'blankokreditten': ('blankokreditt',),
'blankokreditter': ('blankokreditt',),
'blankokredittene': ('blankokreditt',),
'blankolån': ('blankolån',),
'blankolånet': ('blankolån',),
'blankolån': ('blankolån',),
'blankolåna': ('blankolån',),
'blankolånene': ('blankolån',),
'blankoveksel': ('blankoveksel',),
'blankovekselen': ('blankoveksel',),
'blankoveksler': ('blankoveksel',),
'blankovekslene': ('blankoveksel',),
'blankvers': ('blankvers',),
'blankverset': ('blankvers',),
'blankvers': ('blankvers',),
'blankversa': ('blankvers',),
'blankversene': ('blankvers',),
'blankål': ('blankål',),
'blankålen': ('blankål',),
'blankåler': ('blankål',),
'blankålene': ('blankål',),
'blasfemi': ('blasfemi',),
'blasfemien': ('blasfemi',),
'blasfemier': ('blasfemi',),
'blasfemiene': ('blasfemi',),
'blason': ('blason',),
'blasonen': ('blason',),
'blasoner': ('blason',),
'blasonene': ('blason',),
'blastula': ('blastula',),
'blastulaen': ('blastula',),
'blastulaer': ('blastula',),
'blastulaene': ('blastula',),
'blastulastadium': ('blastulastadium',),
'blastulastadiet': ('blastulastadium',),
'blastulastadier': ('blastulastadium',),
'blastulastadia': ('blastulastadium',),
'blastulastadiene': ('blastulastadium',),
'blautdyr': ('blautdyr',),
'blautdyret': ('blautdyr',),
'blautdyr': ('blautdyr',),
'blautdyra': ('blautdyr',),
'blautdyrene': ('blautdyr',),
'blautfisk': ('blautfisk',),
'blautfisken': ('blautfisk',),
'blautfisker': ('blautfisk',),
'blautfiskene': ('blautfisk',),
'blautkake': ('blautkake',),
'blautkaken': ('blautkake',),
'blautkaka': ('blautkake',),
'blautkaker': ('blautkake',),
'blautkakene': ('blautkake',),
'blautmyr': ('blautmyr',),
'blautmyren': ('blautmyr',),
'blautmyra': ('blautmyr',),
'blautmyrer': ('blautmyr',),
'blautmyrene': ('blautmyr',),
'blautråte': ('blautråte',),
'blautråten': ('blautråte',),
'blautråter': ('blautråte',),
'blautråtene': ('blautråte',),
'blautskilpadde': ('blautskilpadde',),
'blautskilpadden': ('blautskilpadde',),
'blautskilpadda': ('blautskilpadde',),
'blautskilpadder': ('blautskilpadde',),
'blautskilpaddene': ('blautskilpadde',),
'blei': ('blei',),
'bleien': ('blei',),
'bleier': ('blei',),
'bleiene': ('blei',),
'bleie': ('bleie',),
'bleien': ('bleie',),
'bleia': ('bleie',),
'bleier': ('bleie',),
'bleiene': ('bleie',),
'bleiebarn': ('bleiebarn',),
'bleiebarnet': ('bleiebarn',),
'bleiebarn': ('bleiebarn',),
'bleiebarna': ('bleiebarn',),
'bleiebarnene': ('bleiebarn',),
'bleievask': ('bleievask',),
'bleievasken': ('bleievask',),
'bleievasker': ('bleievask',),
'bleievaskene': ('bleievask',),
'bleig': ('bleig',),
'bleigen': ('bleig',),
'bleiger': ('bleig',),
'bleigene': ('bleig',),
'bleik': ('bleik',),
'bleiken': ('bleik',),
'bleika': ('bleik',),
'bleiker': ('bleik',),
'bleikene': ('bleik',),
'bleikansikt': ('bleikansikt',),
'bleikansiktet': ('bleikansikt',),
'bleikansikt': ('bleikansikt',),
'bleikansikter': ('bleikansikt',),
'bleikansikt': ('bleikansikt',),
'bleikansikter': ('bleikansikt',),
'bleikansikta': ('bleikansikt',),
'bleikansiktene': ('bleikansikt',),
'bleike': ('bleike',),
'bleiken': ('bleike',),
'bleika': ('bleike',),
'bleiker': ('bleike',),
'bleikene': ('bleike',),
'bleikemiddel': ('bleikemiddel',),
'bleikemiddelet': ('bleikemiddel',),
'bleikemidlet': ('bleikemiddel',),
'bleikemiddel': ('bleikemiddel',),
'bleikemidler': ('bleikemiddel',),
'bleikemidla': ('bleikemiddel',),
'bleikemidlene': ('bleikemiddel',),
'bleikemidla': ('bleikemiddel',),
'bleikemidlene': ('bleikemiddel',),
'bleikevoll': ('bleikevoll',),
'bleikevollen': ('bleikevoll',),
'bleikevoller': ('bleikevoll',),
'bleikevollene': ('bleikevoll',),
'bleikfis': ('bleikfis',),
'bleikfisen': ('bleikfis',),
'bleikfiser': ('bleikfis',),
'bleikfisene': ('bleikfis',),
'bleikfjes': ('bleikfjes',),
'bleikfjeset': ('bleikfjes',),
'bleikfjes': ('bleikfjes',),
'bleikfjesa': ('bleikfjes',),
'bleikfjesene': ('bleikfjes',),
'bleikjord': ('bleikjord',),
'bleikjorden': ('bleikjord',),
'bleikjorda': ('bleikjord',),
'bleikjorder': ('bleikjord',),
'bleikjordene': ('bleikjord',),
'bleiknebb': ('bleiknebb',),
'bleiknebben': ('bleiknebb',),
'bleiknebbet': ('bleiknebb',),
'bleiknebb': ('bleiknebb',),
'bleiknebbene': ('bleiknebb',),
'bleiknebba': ('bleiknebb',),
'bleiknebbene': ('bleiknebb',),
'blekansikt': ('blekansikt',),
'blekansiktet': ('blekansikt',),
'blekansikt': ('blekansikt',),
'blekansikter': ('blekansikt',),
'blekansikt': ('blekansikt',),
'blekansikter': ('blekansikt',),
'blekansikta': ('blekansikt',),
'blekansiktene': ('blekansikt',),
'blekemiddel': ('blekemiddel',),
'blekemiddelet': ('blekemiddel',),
'blekemidlet': ('blekemiddel',),
'blekemiddel': ('blekemiddel',),
'blekemidler': ('blekemiddel',),
'blekemidla': ('blekemiddel',),
'blekemidlene': ('blekemiddel',),
'blekemidla': ('blekemiddel',),
'blekemidlene': ('blekemiddel',),
'blekevoll': ('blekevoll',),
'blekevollen': ('blekevoll',),
'blekevoller': ('blekevoll',),
'blekevollene': ('blekevoll',),
'blekk': ('blekk',),
'blekket': ('blekk',),
'blekk': ('blekk',),
'blekka': ('blekk',),
'blekkene': ('blekk',),
'blekk-kjertel': ('blekk-kjertel',),
'blekk-kjertelen': ('blekk-kjertel',),
'blekk-kjertler': ('blekk-kjertel',),
'blekk-kjertlene': ('blekk-kjertel',),
'blekk-klatt': ('blekk-klatt',),
'blekk-klatten': ('blekk-klatt',),
'blekk-klatter': ('blekk-klatt',),
'blekk-klattene': ('blekk-klatt',),
'blekke': ('blekke',),
'blekken': ('blekke',),
'blekka': ('blekke',),
'blekker': ('blekke',),
'blekkene': ('blekke',),
'blekkflekk': ('blekkflekk',),
'blekkflekken': ('blekkflekk',),
'blekkflekker': ('blekkflekk',),
'blekkflekkene': ('blekkflekk',),
'blekkhus': ('blekkhus',),
'blekkhuset': ('blekkhus',),
'blekkhus': ('blekkhus',),
'blekkhusa': ('blekkhus',),
'blekkhusene': ('blekkhus',),
'blekkjertel': ('blekkjertel',),
'blekkjertelen': ('blekkjertel',),
'blekkjertler': ('blekkjertel',),
'blekkjertlene': ('blekkjertel',),
'blekklatt': ('blekklatt',),
'blekklatten': ('blekklatt',),
'blekklatter': ('blekklatt',),
'blekklattene': ('blekklatt',),
'blekksprut': ('blekksprut',),
'blekkspruten': ('blekksprut',),
'blekkspruter': ('blekksprut',),
'blekksprutene': ('blekksprut',),
'blekkviskelær': ('blekkviskelær',),
'blekkviskelæret': ('blekkviskelær',),
'blekkviskelær': ('blekkviskelær',),
'blekkviskelæra': ('blekkviskelær',),
'blekkviskelærene': ('blekkviskelær',),
'bleknebb': ('bleknebb',),
'bleknebben': ('bleknebb',),
'bleknebbet': ('bleknebb',),
'bleknebb': ('bleknebb',),
'bleknebbene': ('bleknebb',),
'bleknebba': ('bleknebb',),
'bleknebbene': ('bleknebb',),
'blemme': ('blemme',),
'blemmen': ('blemme',),
'blemma': ('blemme',),
'blemmer': ('blemme',),
'blemmene': ('blemme',),
'blemmestål': ('blemmestål',),
'blemmestålet': ('blemmestål',),
'blemmestål': ('blemmestål',),
'blemmeståla': ('blemmestål',),
'blemmestålene': ('blemmestål',),
'blende': ('blende',),
'blenden': ('blende',),
'blender': ('blende',),
'blendene': ('blende',),
'blender': ('blender',),
'blenderen': ('blender',),
'blendere': ('blender',),
'blenderne': ('blender',),
'blendering': ('blendering',),
'blenderingen': ('blendering',),
'blenderinga': ('blendering',),
'blenderinger': ('blendering',),
'blenderingene': ('blendering',),
'blenderinnstilling': ('blenderinnstilling',),
'blenderinnstillingen': ('blenderinnstilling',),
'blenderinnstillinga': ('blenderinnstilling',),
'blenderinnstillinger': ('blenderinnstilling',),
'blenderinnstillingene': ('blenderinnstilling',),
'blenderåpning': ('blenderåpning',),
'blenderåpningen': ('blenderåpning',),
'blenderåpninga': ('blenderåpning',),
'blenderåpninger': ('blenderåpning',),
'blenderåpningene': ('blenderåpning',),
'blending': ('blending',),
'blendingen': ('blending',),
'blendinga': ('blending',),
'blendinger': ('blending',),
'blendingene': ('blending',),
'blendingsgardin': ('blendingsgardin',),
'blendingsgardinen': ('blendingsgardin',),
'blendingsgardinet': ('blendingsgardin',),
'blendingsgardina': ('blendingsgardin',),
'blendingsgardiner': ('blendingsgardin',),
'blendingsgardin': ('blendingsgardin',),
'blendingsgardiner': ('blendingsgardin',),
'blendingsgardin': ('blendingsgardin',),
'blendingsgardiner': ('blendingsgardin',),
'blendingsgardinene': ('blendingsgardin',),
'blendingsgardina': ('blendingsgardin',),
'blendingsgardinene': ('blendingsgardin',),
'blendverk': ('blendverk',),
'blendverket': ('blendverk',),
'blendverk': ('blendverk',),
'blendverka': ('blendverk',),
'blendverkene': ('blendverk',),
'bles': ('bles',),
'bleset': ('bles',),
'bles': ('bles',),
'blesa': ('bles',),
'blesene': ('bles',),
'blesand': ('blesand',),
'blesanden': ('blesand',),
'blesanda': ('blesand',),
'blesender': ('blesand',),
'blesendene': ('blesand',),
'blest': ('blest',),
'blesten': ('blest',),
'blester': ('blest',),
'blestene': ('blest',),
'blestsjef': ('blestsjef',),
'blestsjefen': ('blestsjef',),
'blestsjefer': ('blestsjef',),
'blestsjefene': ('blestsjef',),
'blikk-kopp': ('blikk-kopp',),
'blikk-koppen': ('blikk-kopp',),
'blikk-kopper': ('blikk-kopp',),
'blikk-koppene': ('blikk-kopp',),
'blikkboks': ('blikkboks',),
'blikkboksen': ('blikkboks',),
'blikkbokser': ('blikkboks',),
'blikkboksene': ('blikkboks',),
'blikkdåse': ('blikkdåse',),
'blikkdåsen': ('blikkdåse',),
'blikkdåser': ('blikkdåse',),
'blikkdåsene': ('blikkdåse',),
'blikkenslager': ('blikkenslager',),
'blikkenslageren': ('blikkenslager',),
'blikkenslagere': ('blikkenslager',),
'blikkenslagerne': ('blikkenslager',),
'blikkenslagerverksted': ('blikkenslagerverksted',),
'blikkenslagerverkstedet': ('blikkenslagerverksted',),
'blikkenslagerverksteder': ('blikkenslagerverksted',),
'blikkenslagerverkstedene': ('blikkenslagerverksted',),
'blikkfang': ('blikkfang',),
'blikkfanget': ('blikkfang',),
'blikkfang': ('blikkfang',),
'blikkfanga': ('blikkfang',),
'blikkfangene': ('blikkfang',),
'blikkopp': ('blikkopp',),
'blikkoppen': ('blikkopp',),
'blikkopper': ('blikkopp',),
'blikkoppene': ('blikkopp',),
'blikkplate': ('blikkplate',),
'blikkplaten': ('blikkplate',),
'blikkplata': ('blikkplate',),
'blikkplater': ('blikkplate',),
'blikkplatene': ('blikkplate',),
'blikkslager': ('blikkslager',),
'blikkslageren': ('blikkslager',),
'blikkslagere': ('blikkslager',),
'blikkslagerne': ('blikkslager',),
'blikkslagerverksted': ('blikkslagerverksted',),
'blikkslagerverkstedet': ('blikkslagerverksted',),
'blikkslagerverksteder': ('blikkslagerverksted',),
'blikkslagerverkstedene': ('blikkslagerverksted',),
'blikkspann': ('blikkspann',),
'blikkspannet': ('blikkspann',),
'blikkspann': ('blikkspann',),
'blikkspanna': ('blikkspann',),
'blikkspannene': ('blikkspann',),
'blikkvare': ('blikkvare',),
'blikkvaren': ('blikkvare',),
'blikkvara': ('blikkvare',),
'blikkvarer': ('blikkvare',),
'blikkvarene': ('blikkvare',),
'blinde': ('blinde',),
'blinden': ('blinde',),
'blinda': ('blinde',),
'blinder': ('blinde',),
'blindene': ('blinde',),
'blindealfabet': ('blindealfabet',),
'blindealfabetet': ('blindealfabet',),
'blindealfabet': ('blindealfabet',),
'blindealfabeter': ('blindealfabet',),
'blindealfabet': ('blindealfabet',),
'blindealfabeter': ('blindealfabet',),
'blindealfabeta': ('blindealfabet',),
'blindealfabetene': ('blindealfabet',),
'blindebukk': ('blindebukk',),
'blindebukken': ('blindebukk',),
'blindebukker': ('blindebukk',),
'blindebukkene': ('blindebukk',),
'blindeforbund': ('blindeforbund',),
'blindeforbundet': ('blindeforbund',),
'blindeforbund': ('blindeforbund',),
'blindeforbunda': ('blindeforbund',),
'blindeforbundene': ('blindeforbund',),
'blindeførerhund': ('blindeførerhund',),
'blindeførerhunden': ('blindeførerhund',),
'blindeførerhunder': ('blindeførerhund',),
'blindeførerhundene': ('blindeførerhund',),
'blindemann': ('blindemann',),
'blindemannen': ('blindemann',),
'blindemenn': ('blindemann',),
'blindemennene': ('blindemann',),
'blindesak': ('blindesak',),
'blindesaken': ('blindesak',),
'blindesaka': ('blindesak',),
'blindesaker': ('blindesak',),
'blindesakene': ('blindesak',),
'blindeskole': ('blindeskole',),
'blindeskolen': ('blindeskole',),
'blindeskoler': ('blindeskole',),
'blindeskolene': ('blindeskole',),
'blindeskrift': ('blindeskrift',),
'blindeskriften': ('blindeskrift',),
'blindeskrifta': ('blindeskrift',),
'blindeskrifter': ('blindeskrift',),
'blindeskriftene': ('blindeskrift',),
'blindflyging': ('blindflyging',),
'blindflygingen': ('blindflyging',),
'blindflyginga': ('blindflyging',),
'blindflyginger': ('blindflyging',),
'blindflygingene': ('blindflyging',),
'blindflying': ('blindflying',),
'blindflyingen': ('blindflying',),
'blindflyinga': ('blindflying',),
'blindflyinger': ('blindflying',),
'blindflyingene': ('blindflying',),
'blindgate': ('blindgate',),
'blindgaten': ('blindgate',),
'blindgata': ('blindgate',),
'blindgater': ('blindgate',),
'blindgatene': ('blindgate',),
'blindgjenger': ('blindgjenger',),
'blindgjengeren': ('blindgjenger',),
'blindgjengere': ('blindgjenger',),
'blindgjengerne': ('blindgjenger',),
'blindhet': ('blindhet',),
'blindheten': ('blindhet',),
'blindheta': ('blindhet',),
'blindheter': ('blindhet',),
'blindhetene': ('blindhet',),
'blinding': ('blinding',),
'blindingen': ('blinding',),
'blindinger': ('blinding',),
'blindingene': ('blinding',),
'blindklegg': ('blindklegg',),
'blindkleggen': ('blindklegg',),
'blindklegger': ('blindklegg',),
'blindkleggene': ('blindklegg',),
'blindlanding': ('blindlanding',),
'blindlandingen': ('blindlanding',),
'blindlandinga': ('blindlanding',),
'blindlandinger': ('blindlanding',),
'blindlandingene': ('blindlanding',),
'blindnagle': ('blindnagle',),
'blindnaglen': ('blindnagle',),
'blindnagler': ('blindnagle',),
'blindnaglene': ('blindnagle',),
'blindpassasjer': ('blindpassasjer',),
'blindpassasjeren': ('blindpassasjer',),
'blindpassasjerer': ('blindpassasjer',),
'blindpassasjerene': ('blindpassasjer',),
'blindramme': ('blindramme',),
'blindrammen': ('blindramme',),
'blindramma': ('blindramme',),
'blindrammer': ('blindramme',),
'blindrammene': ('blindramme',),
'blindskjær': ('blindskjær',),
'blindskjæret': ('blindskjær',),
'blindskjær': ('blindskjær',),
'blindskjæra': ('blindskjær',),
'blindskjærene': ('blindskjær',),
'blindspor': ('blindspor',),
'blindsporet': ('blindspor',),
'blindspor': ('blindspor',),
'blindspora': ('blindspor',),
'blindsporene': ('blindspor',),
'blindtarm': ('blindtarm',),
'blindtarmen': ('blindtarm',),
'blindtarmer': ('blindtarm',),
'blindtarmene': ('blindtarm',),
'blindtarmsbetennelse': ('blindtarmsbetennelse',),
'blindtarmsbetennelsen': ('blindtarmsbetennelse',),
'blindtarmsbetennelser': ('blindtarmsbetennelse',),
'blindtarmsbetennelsene': ('blindtarmsbetennelse',),
'blindtarmsvedheng': ('blindtarmsvedheng',),
'blindtarmsvedhenget': ('blindtarmsvedheng',),
'blindtarmsvedheng': ('blindtarmsvedheng',),
'blindtarmsvedhenga': ('blindtarmsvedheng',),
'blindtarmsvedhengene': ('blindtarmsvedheng',),
'blindveg': ('blindveg',),
'blindvegen': ('blindveg',),
'blindveger': ('blindveg',),
'blindvegene': ('blindveg',),
'blindvei': ('blindvei',),
'blindveien': ('blindvei',),
'blindveier': ('blindvei',),
'blindveiene': ('blindvei',),
'blings': ('blings',),
'blingsen': ('blings',),
'blingser': ('blings',),
'blingsene': ('blings',),
'blink': ('blink',),
'blinken': ('blink',),
'blinker': ('blink',),
'blinkene': ('blink',),
'blink': ('blink',),
'blinket': ('blink',),
'blink': ('blink',),
'blinka': ('blink',),
'blinkene': ('blink',),
'blinkemerke': ('blinkemerke',),
'blinkemerket': ('blinkemerke',),
'blinkemerker': ('blinkemerke',),
'blinkemerka': ('blinkemerke',),
'blinkemerkene': ('blinkemerke',),
'blinkeøks': ('blinkeøks',),
'blinkeøksen': ('blinkeøks',),
'blinkeøksa': ('blinkeøks',),
'blinkeøkser': ('blinkeøks',),
'blinkeøksene': ('blinkeøks',),
'blinkfyr': ('blinkfyr',),
'blinkfyret': ('blinkfyr',),
'blinkfyr': ('blinkfyr',),
'blinkfyra': ('blinkfyr',),
'blinkfyrene': ('blinkfyr',),
'blinklanterne': ('blinklanterne',),
'blinklanternen': ('blinklanterne',),
'blinklanterna': ('blinklanterne',),
'blinklanterner': ('blinklanterne',),
'blinklanternene': ('blinklanterne',),
'blinklys': ('blinklys',),
'blinklyset': ('blinklys',),
'blinklys': ('blinklys',),
'blinklysa': ('blinklys',),
'blinklysene': ('blinklys',),
'blinkmerke': ('blinkmerke',),
'blinkmerket': ('blinkmerke',),
'blinkmerker': ('blinkmerke',),
'blinkmerka': ('blinkmerke',),
'blinkmerkene': ('blinkmerke',),
'blinkskott': ('blinkskott',),
'blinkskottet': ('blinkskott',),
'blinkskott': ('blinkskott',),
'blinkskotta': ('blinkskott',),
'blinkskottene': ('blinkskott',),
'blinkskudd': ('blinkskudd',),
'blinkskuddet': ('blinkskudd',),
'blinkskudd': ('blinkskudd',),
'blinkskudda': ('blinkskudd',),
'blinkskuddene': ('blinkskudd',),
'blinkøks': ('blinkøks',),
'blinkøksen': ('blinkøks',),
'blinkøksa': ('blinkøks',),
'blinkøkser': ('blinkøks',),
'blinkøksene': ('blinkøks',),
'blits': ('blits',),
'blitsen': ('blits',),
'blitser': ('blits',),
'blitsene': ('blits',),
'blitskrig': ('blitskrig',),
'blitskrigen': ('blitskrig',),
'blitskriger': ('blitskrig',),
'blitskrigene': ('blitskrig',),
'blitslampe': ('blitslampe',),
'blitslampen': ('blitslampe',),
'blitslampa': ('blitslampe',),
'blitslamper': ('blitslampe',),
'blitslampene': ('blitslampe',),
'blitslys': ('blitslys',),
'blitslyset': ('blitslys',),
'blitslys': ('blitslys',),
'blitslysa': ('blitslys',),
'blitslysene': ('blitslys',),
'blod': ('blod',),
'blodet': ('blod',),
'blod': ('blod',),
'bloda': ('blod',),
'blodene': ('blod',),
'blodansamling': ('blodansamling',),
'blodansamlingen': ('blodansamling',),
'blodansamlinga': ('blodansamling',),
'blodansamlinger': ('blodansamling',),
'blodansamlingene': ('blodansamling',),
'blodappelsin': ('blodappelsin',),
'blodappelsinen': ('blodappelsin',),
'blodappelsiner': ('blodappelsin',),
'blodappelsinene': ('blodappelsin',),
'blodbad': ('blodbad',),
'blodbadet': ('blodbad',),
'blodbad': ('blodbad',),
'blodbada': ('blodbad',),
'blodbadene': ('blodbad',),
'blodbank': ('blodbank',),
'blodbanken': ('blodbank',),
'blodbanker': ('blodbank',),
'blodbankene': ('blodbank',),
'blodblemme': ('blodblemme',),
'blodblemmen': ('blodblemme',),
'blodblemma': ('blodblemme',),
'blodblemmer': ('blodblemme',),
'blodblemmene': ('blodblemme',),
'blodbok': ('blodbok',),
'blodboken': ('blodbok',),
'blodboka': ('blodbok',),
'blodboker': ('blodbok',),
'blodbokene': ('blodbok',),
'blodbøk': ('blodbøk',),
'blodbøken': ('blodbøk',),
'blodbøker': ('blodbøk',),
'blodbøkene': ('blodbøk',),
'blodcelle': ('blodcelle',),
'blodcellen': ('blodcelle',),
'blodcella': ('blodcelle',),
'blodceller': ('blodcelle',),
'blodcellene': ('blodcelle',),
'bloddoping': ('bloddoping',),
'bloddopingen': ('bloddoping',),
'bloddopinga': ('bloddoping',),
'bloddopinger': ('bloddoping',),
'bloddopingene': ('bloddoping',),
'bloddråpe': ('bloddråpe',),
'bloddråpen': ('bloddråpe',),
'bloddråper': ('bloddråpe',),
'bloddråpene': ('bloddråpe',),
'blodforgiftning': ('blodforgiftning',),
'blodforgiftningen': ('blodforgiftning',),
'blodforgiftninga': ('blodforgiftning',),
'blodforgiftninger': ('blodforgiftning',),
'blodforgiftningene': ('blodforgiftning',),
'blodgiver': ('blodgiver',),
'blodgiveren': ('blodgiver',),
'blodgivere': ('blodgiver',),
'blodgiverne': ('blodgiver',),
'blodgruppe': ('blodgruppe',),
'blodgruppen': ('blodgruppe',),
'blodgruppa': ('blodgruppe',),
'blodgrupper': ('blodgruppe',),
'blodgruppene': ('blodgruppe',),
'blodhevn': ('blodhevn',),
'blodhevnen': ('blodhevn',),
'blodhevner': ('blodhevn',),
'blodhevnene': ('blodhevn',),
'blodhund': ('blodhund',),
'blodhunden': ('blodhund',),
'blodhunder': ('blodhund',),
'blodhundene': ('blodhund',),
'blodigle': ('blodigle',),
'blodiglen': ('blodigle',),
'blodigla': ('blodigle',),
'blodigler': ('blodigle',),
'blodiglene': ('blodigle',),
'blodikte': ('blodikte',),
'blodikten': ('blodikte',),
'blodikter': ('blodikte',),
'blodiktene': ('blodikte',),
'blodkar': ('blodkar',),
'blodkaret': ('blodkar',),
'blodkar': ('blodkar',),
'blodkara': ('blodkar',),
'blodkarene': ('blodkar',),
'blodkreft': ('blodkreft',),
'blodkreften': ('blodkreft',),
'blodkrefter': ('blodkreft',),
'blodkreftene': ('blodkreft',),
'blodlegeme': ('blodlegeme',),
'blodlegemet': ('blodlegeme',),
'blodlegemer': ('blodlegeme',),
'blodlegema': ('blodlegeme',),
'blodlegemene': ('blodlegeme',),
'blodmangel': ('blodmangel',),
'blodmangelen': ('blodmangel',),
'blodmangler': ('blodmangel',),
'blodmanglene': ('blodmangel',),
'blodmat': ('blodmat',),
'blodmaten': ('blodmat',),
'blodmater': ('blodmat',),
'blodmatene': ('blodmat',),
'blodomløp': ('blodomløp',),
'blodomløpet': ('blodomløp',),
'blodomløp': ('blodomløp',),
'blodomløpa': ('blodomløp',),
'blodomløpene': ('blodomløp',),
'blodoverføring': ('blodoverføring',),
'blodoverføringen': ('blodoverføring',),
'blodoverføringa': ('blodoverføring',),
'blodoverføringer': ('blodoverføring',),
'blodoverføringene': ('blodoverføring',),
'blodpenger': ('blodpenger',),
'blodpengene': ('blodpenger',),
'blodpiss': ('blodpiss',),
'blodpisset': ('blodpiss',),
'blodpiss': ('blodpiss',),
'blodpissa': ('blodpiss',),
'blodpissene': ('blodpiss',),
'blodplasma': ('blodplasma',),
'blodplasmaet': ('blodplasma',),
'blodplasma': ('blodplasma',),
'blodplasmaa': ('blodplasma',),
'blodplasmaene': ('blodplasma',),
'blodplate': ('blodplate',),
'blodplaten': ('blodplate',),
'blodplata': ('blodplate',),
'blodplater': ('blodplate',),
'blodplatene': ('blodplate',),
'blodpris': ('blodpris',),
'blodprisen': ('blodpris',),
'blodpriser': ('blodpris',),
'blodprisene': ('blodpris',),
'blodpropp': ('blodpropp',),
'blodproppen': ('blodpropp',),
'blodpropper': ('blodpropp',),
'blodproppene': ('blodpropp',),
'blodprosent': ('blodprosent',),
'blodprosenten': ('blodprosent',),
'blodprosenter': ('blodprosent',),
'blodprosent': ('blodprosent',),
'blodprosentene': ('blodprosent',),
'blodprøve': ('blodprøve',),
'blodprøven': ('blodprøve',),
'blodprøva': ('blodprøve',),
'blodprøver': ('blodprøve',),
'blodprøvene': ('blodprøve',),
'blodpudding': ('blodpudding',),
'blodpuddingen': ('blodpudding',),
'blodpuddinger': ('blodpudding',),
'blodpuddingene': ('blodpudding',),
'blodpøl': ('blodpøl',),
'blodpølen': ('blodpøl',),
'blodpøler': ('blodpøl',),
'blodpølene': ('blodpøl',),
'blodsband': ('blodsband',),
'blodsbandet': ('blodsband',),
'blodsband': ('blodsband',),
'blodsbanda': ('blodsband',),
'blodsbandene': ('blodsband',),
'blodsbånd': ('blodsbånd',),
'blodsbåndet': ('blodsbånd',),
'blodsbånd': ('blodsbånd',),
'blodsbånda': ('blodsbånd',),
'blodsbåndene': ('blodsbånd',),
'blodsdråpe': ('blodsdråpe',),
'blodsdråpen': ('blodsdråpe',),
'blodsdråper': ('blodsdråpe',),
'blodsdråpene': ('blodsdråpe',),
'blodsenkning': ('blodsenkning',),
'blodsenkningen': ('blodsenkning',),
'blodsenkninga': ('blodsenkning',),
'blodsenkninger': ('blodsenkning',),
'blodsenkningene': ('blodsenkning',),
'blodserum': ('blodserum',),
'blodserumet': ('blodserum',),
'blodserumer': ('blodserum',),
'blodsera': ('blodserum',),
'blodseruma': ('blodserum',),
'blodserumene': ('blodserum',),
'blodseraene': ('blodserum',),
'blodskam': ('blodskam',),
'blodskammen': ('blodskam',),
'blodskamma': ('blodskam',),
'blodskammer': ('blodskam',),
'blodskammene': ('blodskam',),
'blodslit': ('blodslit',),
'blodslitet': ('blodslit',),
'blodslit': ('blodslit',),
'blodslita': ('blodslit',),
'blodslitene': ('blodslit',),
'blodsmak': ('blodsmak',),
'blodsmaken': ('blodsmak',),
'blodsmaker': ('blodsmak',),
'blodsmakene': ('blodsmak',),
'blodsprut': ('blodsprut',),
'blodspruten': ('blodsprut',),
'blodspruter': ('blodsprut',),
'blodsprutene': ('blodsprut',),
'blodstyrtning': ('blodstyrtning',),
'blodstyrtningen': ('blodstyrtning',),
'blodstyrtninga': ('blodstyrtning',),
'blodstyrtninger': ('blodstyrtning',),
'blodstyrtningene': ('blodstyrtning',),
'blodsuger': ('blodsuger',),
'blodsugeren': ('blodsuger',),
'blodsugere': ('blodsuger',),
'blodsugerne': ('blodsuger',),
'blodsutgytelse': ('blodsutgytelse',),
'blodsutgytelsen': ('blodsutgytelse',),
'blodsutgytelser': ('blodsutgytelse',),
'blodsutgytelsene': ('blodsutgytelse',),
'blodtap': ('blodtap',),
'blodtapet': ('blodtap',),
'blodtap': ('blodtap',),
'blodtapa': ('blodtap',),
'blodtapene': ('blodtap',),
'blodtilførsel': ('blodtilførsel',),
'blodtilførselen': ('blodtilførsel',),
'blodtilførsler': ('blodtilførsel',),
'blodtilførslene': ('blodtilførsel',),
'blodtransfusjon': ('blodtransfusjon',),
'blodtransfusjonen': ('blodtransfusjon',),
'blodtransfusjoner': ('blodtransfusjon',),
'blodtransfusjonene': ('blodtransfusjon',),
'blodtrykk': ('blodtrykk',),
'blodtrykket': ('blodtrykk',),
'blodtrykk': ('blodtrykk',),
'blodtrykka': ('blodtrykk',),
'blodtrykkene': ('blodtrykk',),
'blodtype': ('blodtype',),
'blodtypen': ('blodtype',),
'blodtyper': ('blodtype',),
'blodtypene': ('blodtype',),
'bloduttredelse': ('bloduttredelse',),
'bloduttredelsen': ('bloduttredelse',),
'bloduttredelser': ('bloduttredelse',),
'bloduttredelsene': ('bloduttredelse',),
'blodvitne': ('blodvitne',),
'blodvitnet': ('blodvitne',),
'blodvitner': ('blodvitne',),
'blodvitna': ('blodvitne',),
'blodvitnene': ('blodvitne',),
'blodvæske': ('blodvæske',),
'blodvæsken': ('blodvæske',),
'blodvæska': ('blodvæske',),
'blodvæsker': ('blodvæske',),
'blodvæskene': ('blodvæske',),
'blodåre': ('blodåre',),
'blodåren': ('blodåre',),
'blodåra': ('blodåre',),
'blodårer': ('blodåre',),
'blodårene': ('blodåre',),
'blokade': ('blokade',),
'blokaden': ('blokade',),
'blokader': ('blokade',),
'blokadene': ('blokade',),
'blokadebryter': ('blokadebryter',),
'blokadebryteren': ('blokadebryter',),
'blokadebrytere': ('blokadebryter',),
'blokadebryterne': ('blokadebryter',),
'blokadeskip': ('blokadeskip',),
'blokadeskipet': ('blokadeskip',),
'blokadeskip': ('blokadeskip',),
'blokadeskipa': ('blokadeskip',),
'blokadeskipene': ('blokadeskip',),
'blokk': ('blokk',),
'blokken': ('blokk',),
'blokka': ('blokk',),
'blokker': ('blokk',),
'blokkene': ('blokk',),
'blokkboer': ('blokkboer',),
'blokkboeren': ('blokkboer',),
'blokkboere': ('blokkboer',),
'blokkboerne': ('blokkboer',),
'blokkbokstav': ('blokkbokstav',),
'blokkbokstaven': ('blokkbokstav',),
'blokkbokstaver': ('blokkbokstav',),
'blokkbokstavene': ('blokkbokstav',),
'blokkbuer': ('blokkbuer',),
'blokkbueren': ('blokkbuer',),
'blokkbuere': ('blokkbuer',),
'blokkbuerne': ('blokkbuer',),
'blokkebær': ('blokkebær',),
'blokkebæret': ('blokkebær',),
'blokkebær': ('blokkebær',),
'blokkebæra': ('blokkebær',),
'blokkebærene': ('blokkebær',),
'blokkering': ('blokkering',),
'blokkeringen': ('blokkering',),
'blokkeringa': ('blokkering',),
'blokkeringer': ('blokkering',),
'blokkeringene': ('blokkering',),
'blokkfløyte': ('blokkfløyte',),
'blokkfløyten': ('blokkfløyte',),
'blokkfløyta': ('blokkfløyte',),
'blokkfløyter': ('blokkfløyte',),
'blokkfløytene': ('blokkfløyte',),
'blokkhus': ('blokkhus',),
'blokkhuset': ('blokkhus',),
'blokkhus': ('blokkhus',),
'blokkhusa': ('blokkhus',),
'blokkhusene': ('blokkhus',),
'blokkleilighet': ('blokkleilighet',),
'blokkleiligheten': ('blokkleilighet',),
'blokkleiligheta': ('blokkleilighet',),
'blokkleiligheter': ('blokkleilighet',),
'blokkleilighetene': ('blokkleilighet',),
'blokkpost': ('blokkpost',),
'blokkposten': ('blokkpost',),
'blokkposter': ('blokkpost',),
'blokkpostene': ('blokkpost',),
'blokkskive': ('blokkskive',),
'blokkskiven': ('blokkskive',),
'blokkskiva': ('blokkskive',),
'blokkskiver': ('blokkskive',),
'blokkskivene': ('blokkskive',),
'blokkskrift': ('blokkskrift',),
'blokkskriften': ('blokkskrift',),
'blokkskrifta': ('blokkskrift',),
'blokkskrifter': ('blokkskrift',),
'blokkskriftene': ('blokkskrift',),
'blomkarse': ('blomkarse',),
'blomkarsen': ('blomkarse',),
'blomkarser': ('blomkarse',),
'blomkarsene': ('blomkarse',),
'blomkål': ('blomkål',),
'blomkålen': ('blomkål',),
'blomkåler': ('blomkål',),
'blomkålene': ('blomkål',),
'blomkålhode': ('blomkålhode',),
'blomkålhodet': ('blomkålhode',),
'blomkålhoder': ('blomkålhode',),
'blomkålhoda': ('blomkålhode',),
'blomkålhodene': ('blomkålhode',),
'blomkålsopp': ('blomkålsopp',),
'blomkålsoppen': ('blomkålsopp',),
'blomkålsopper': ('blomkålsopp',),
'blomkålsoppene': ('blomkålsopp',),
'blomkålsuppe': ('blomkålsuppe',),
'blomkålsuppen': ('blomkålsuppe',),
'blomkålsuppa': ('blomkålsuppe',),
'blomkålsupper': ('blomkålsuppe',),
'blomkålsuppene': ('blomkålsuppe',),
'blomkåløre': ('blomkåløre',),
'blomkåløret': ('blomkåløre',),
'blomkålører': ('blomkåløre',),
'blomkåløra': ('blomkåløre',),
'blomkålørene': ('blomkåløre',),
'blomst': ('blomst',),
'blomsten': ('blomst',),
'blomster': ('blomst',),
'blomstene': ('blomst',),
'blomsterbarn': ('blomsterbarn',),
'blomsterbarnet': ('blomsterbarn',),
'blomsterbarn': ('blomsterbarn',),
'blomsterbarna': ('blomsterbarn',),
'blomsterbarnene': ('blomsterbarn',),
'blomsterbed': ('blomsterbed',),
'blomsterbedet': ('blomsterbed',),
'blomsterbed': ('blomsterbed',),
'blomsterbeda': ('blomsterbed',),
'blomsterbedene': ('blomsterbed',),
'blomsterbinder': ('blomsterbinder',),
'blomsterbinderen': ('blomsterbinder',),
'blomsterbindere': ('blomsterbinder',),
'blomsterbinderne': ('blomsterbinder',),
'blomsterbotn': ('blomsterbotn',),
'blomsterbotnen': ('blomsterbotn',),
'blomsterbotner': ('blomsterbotn',),
'blomsterbotnene': ('blomsterbotn',),
'blomsterbukett': ('blomsterbukett',),
'blomsterbuketten': ('blomsterbukett',),
'blomsterbuketter': ('blomsterbukett',),
'blomsterbukettene': ('blomsterbukett',),
'blomsterbunn': ('blomsterbunn',),
'blomsterbunnen': ('blomsterbunn',),
'blomsterbunner': ('blomsterbunn',),
'blomsterbunnene': ('blomsterbunn',),
'blomsterdekorasjon': ('blomsterdekorasjon',),
'blomsterdekorasjonen': ('blomsterdekorasjon',),
'blomsterdekorasjoner': ('blomsterdekorasjon',),
'blomsterdekorasjonene': ('blomsterdekorasjon',),
'blomsterhandel': ('blomsterhandel',),
'blomsterhandelen': ('blomsterhandel',),
'blomsterhandler': ('blomsterhandel',),
'blomsterhandlene': ('blomsterhandel',),
'blomsterhilsen': ('blomsterhilsen',),
'blomsterhilsenen': ('blomsterhilsen',),
'blomsterhilsener': ('blomsterhilsen',),
'blomsterhilsenene': ('blomsterhilsen',),
'blomsterkasse': ('blomsterkasse',),
'blomsterkassen': ('blomsterkasse',),
'blomsterkassa': ('blomsterkasse',),
'blomsterkasser': ('blomsterkasse',),
'blomsterkassene': ('blomsterkasse',),
'blomsterkrans': ('blomsterkrans',),
'blomsterkransen': ('blomsterkrans',),
'blomsterkranser': ('blomsterkrans',),
'blomsterkransene': ('blomsterkrans',),
'blomsterløk': ('blomsterløk',),
'blomsterløken': ('blomsterløk',),
'blomsterløker': ('blomsterløk',),
'blomsterløkene': ('blomsterløk',),
'blomsterpotte': ('blomsterpotte',),
'blomsterpotten': ('blomsterpotte',),
'blomsterpotta': ('blomsterpotte',),
'blomsterpotter': ('blomsterpotte',),
'blomsterpottene': ('blomsterpotte',),
'blomsterprakt': ('blomsterprakt',),
'blomsterprakten': ('blomsterprakt',),
'blomsterprakta': ('blomsterprakt',),
'blomsterprakter': ('blomsterprakt',),
'blomsterpraktene': ('blomsterprakt',),
'blomsterrabatt': ('blomsterrabatt',),
'blomsterrabatten': ('blomsterrabatt',),
'blomsterrabatter': ('blomsterrabatt',),
'blomsterrabattene': ('blomsterrabatt',),
'blomsterskjerm': ('blomsterskjerm',),
'blomsterskjermen': ('blomsterskjerm',),
'blomsterskjermer': ('blomsterskjerm',),
'blomsterskjermene': ('blomsterskjerm',),
'blomsterstand': ('blomsterstand',),
'blomsterstanden': ('blomsterstand',),
'blomsterstander': ('blomsterstand',),
'blomsterstandene': ('blomsterstand',),
'blomstertorg': ('blomstertorg',),
'blomstertorget': ('blomstertorg',),
'blomstertorg': ('blomstertorg',),
'blomstertorga': ('blomstertorg',),
'blomstertorgene': ('blomstertorg',),
'blomstervase': ('blomstervase',),
'blomstervasen': ('blomstervase',),
'blomstervaser': ('blomstervase',),
'blomstervasene': ('blomstervase',),
'blomstring': ('blomstring',),
'blomstringen': ('blomstring',),
'blomstringa': ('blomstring',),
'blomstringer': ('blomstring',),
'blomstringene': ('blomstring',),
'blomstringstid': ('blomstringstid',),
'blomstringstiden': ('blomstringstid',),
'blomstringstida': ('blomstringstid',),
'blomstringstider': ('blomstringstid',),
'blomstringstidene': ('blomstringstid',),
'blonde': ('blonde',),
'blonden': ('blonde',),
'blonder': ('blonde',),
'blondene': ('blonde',),
'blondebluse': ('blondebluse',),
'blondeblusen': ('blondebluse',),
'blondeblusa': ('blondebluse',),
'blondebluser': ('blondebluse',),
'blondeblusene': ('blondebluse',),
'blondekant': ('blondekant',),
'blondekanten': ('blondekant',),
'blondekanter': ('blondekant',),
'blondekantene': ('blondekant',),
'blondeslør': ('blondeslør',),
'blondesløret': ('blondeslør',),
'blondeslør': ('blondeslør',),
'blondesløra': ('blondeslør',),
'blondeslørene': ('blondeslør',),
'blondestoff': ('blondestoff',),
'blondestoffet': ('blondestoff',),
'blondestoff': ('blondestoff',),
'blondestoffer': ('blondestoff',),
'blondestoff': ('blondestoff',),
'blondestoffer': ('blondestoff',),
'blondestoffa': ('blondestoff',),
'blondestoffene': ('blondestoff',),
'blondine': ('blondine',),
'blondinen': ('blondine',),
'blondina': ('blondine',),
'blondiner': ('blondine',),
'blondinene': ('blondine',),
'blot': ('blot',),
'blotet': ('blot',),
'blot': ('blot',),
'blota': ('blot',),
'blotene': ('blot',),
'blotter': ('blotter',),
'blotteren': ('blotter',),
'blottere': ('blotter',),
'blotterne': ('blotter',),
'blueback': ('blueback',),
'bluebacken': ('blueback',),
'bluebacker': ('blueback',),
'bluebackene': ('blueback',),
'blueline': ('blueline',),
'blues': ('blues',),
'bluesen': ('blues',),
'blues': ('blues',),
'bluesene': ('blues',),
'bluessanger': ('bluessanger',),
'bluessangeren': ('bluessanger',),
'bluessangere': ('bluessanger',),
'bluessangerne': ('bluessanger',),
'bluferdighet': ('bluferdighet',),
'bluferdigheten': ('bluferdighet',),
'bluferdigheta': ('bluferdighet',),
'bluferdigheter': ('bluferdighet',),
'bluferdighetene': ('bluferdighet',),
'blund': ('blund',),
'blunden': ('blund',),
'blunder': ('blund',),
'blundene': ('blund',),
'blunder': ('blunder',),
'blunderen': ('blunder',),
'blundere': ('blunder',),
'blunderne': ('blunder',),
'blunk': ('blunk',),
'blunken': ('blunk',),
'blunket': ('blunk',),
'blunk': ('blunk',),
'blunkene': ('blunk',),
'blunka': ('blunk',),
'blunkene': ('blunk',),
'bluse': ('bluse',),
'blusen': ('bluse',),
'blusa': ('bluse',),
'bluser': ('bluse',),
'blusene': ('bluse',),
'bluseliv': ('bluseliv',),
'bluselivet': ('bluseliv',),
'bluseliv': ('bluseliv',),
'bluseliva': ('bluseliv',),
'bluselivene': ('bluseliv',),
'bluss': ('bluss',),
'blusset': ('bluss',),
'bluss': ('bluss',),
'blussa': ('bluss',),
'blussene': ('bluss',),
'blussel': ('blussel',),
'blusselen': ('blussel',),
'blusler': ('blussel',),
'bluslene': ('blussel',),
'bly': ('bly',),
'blyet': ('bly',),
'bly': ('bly',),
'blya': ('bly',),
'blyene': ('bly',),
'blyakkumulator': ('blyakkumulator',),
'blyakkumulatoren': ('blyakkumulator',),
'blyakkumulatorer': ('blyakkumulator',),
'blyakkumulatorene': ('blyakkumulator',),
'blyant': ('blyant',),
'blyanten': ('blyant',),
'blyanter': ('blyant',),
'blyantene': ('blyant',),
'blyantskisse': ('blyantskisse',),
'blyantskissen': ('blyantskisse',),
'blyantskissa': ('blyantskisse',),
'blyantskisser': ('blyantskisse',),
'blyantskissene': ('blyantskisse',),
'blyantspisser': ('blyantspisser',),
'blyantspisseren': ('blyantspisser',),
'blyantspissere': ('blyantspisser',),
'blyantspisserne': ('blyantspisser',),
'blyantstegning': ('blyantstegning',),
'blyantstegningen': ('blyantstegning',),
'blyantstegninga': ('blyantstegning',),
'blyantstegninger': ('blyantstegning',),
'blyantstegningene': ('blyantstegning',),
'blyantstift': ('blyantstift',),
'blyantstiften': ('blyantstift',),
'blyantstifter': ('blyantstift',),
'blyantstiftene': ('blyantstift',),
'blyanttegning': ('blyanttegning',),
'blyanttegningen': ('blyanttegning',),
'blyanttegninga': ('blyanttegning',),
'blyanttegninger': ('blyanttegning',),
'blyanttegningene': ('blyanttegning',),
'blybensin': ('blybensin',),
'blybensinen': ('blybensin',),
'blybensiner': ('blybensin',),
'blybensinene': ('blybensin',),
'blyerts': ('blyerts',),
'blyertsen': ('blyerts',),
'blyertser': ('blyerts',),
'blyertsene': ('blyerts',),
'blyfarge': ('blyfarge',),
'blyfargen': ('blyfarge',),
'blyfarger': ('blyfarge',),
'blyfargene': ('blyfarge',),
'blyforbindelse': ('blyforbindelse',),
'blyforbindelsen': ('blyforbindelse',),
'blyforbindelser': ('blyforbindelse',),
'blyforbindelsene': ('blyforbindelse',),
'blyforgiftning': ('blyforgiftning',),
'blyforgiftningen': ('blyforgiftning',),
'blyforgiftninga': ('blyforgiftning',),
'blyforgiftninger': ('blyforgiftning',),
'blyforgiftningene': ('blyforgiftning',),
'blyforkle': ('blyforkle',),
'blyforkleet': ('blyforkle',),
'blyforklær': ('blyforkle',),
'blyforklærne': ('blyforkle',),
'blyglans': ('blyglans',),
'blyglansen': ('blyglans',),
'blyglanser': ('blyglans',),
'blyglansene': ('blyglans',),
'blygsel': ('blygsel',),
'blygselen': ('blygsel',),
'blygsla': ('blygsel',),
'blygsler': ('blygsel',),
'blygslene': ('blygsel',),
'blyhagl': ('blyhagl',),
'blyhaglet': ('blyhagl',),
'blyhagl': ('blyhagl',),
'blyhagla': ('blyhagl',),
'blyhaglene': ('blyhagl',),
'blyinnfatning': ('blyinnfatning',),
'blyinnfatningen': ('blyinnfatning',),
'blyinnfatninga': ('blyinnfatning',),
'blyinnfatninger': ('blyinnfatning',),
'blyinnfatningene': ('blyinnfatning',),
'blymalm': ('blymalm',),
'blymalmen': ('blymalm',),
'blymalmer': ('blymalm',),
'blymalmene': ('blymalm',),
'blyoksid': ('blyoksid',),
'blyoksidet': ('blyoksid',),
'blyoksid': ('blyoksid',),
'blyoksider': ('blyoksid',),
'blyoksid': ('blyoksid',),
'blyoksider': ('blyoksid',),
'blyoksida': ('blyoksid',),
'blyoksidene': ('blyoksid',),
'blyregn': ('blyregn',),
'blyregnet': ('blyregn',),
'blyregn': ('blyregn',),
'blyregna': ('blyregn',),
'blyregnene': ('blyregn',),
'blysulfid': ('blysulfid',),
'blysulfidet': ('blysulfid',),
'blysulfid': ('blysulfid',),
'blysulfider': ('blysulfid',),
'blysulfid': ('blysulfid',),
'blysulfider': ('blysulfid',),
'blysulfida': ('blysulfid',),
'blysulfidene': ('blysulfid',),
'blyvindu': ('blyvindu',),
'blyvinduet': ('blyvindu',),
'blyvindu': ('blyvindu',),
'blyvinduer': ('blyvindu',),
'blyvindu': ('blyvindu',),
'blyvinduer': ('blyvindu',),
'blyvindua': ('blyvindu',),
'blyvinduene': ('blyvindu',),
'blåbok': ('blåbok',),
'blåboken': ('blåbok',),
'blåboka': ('blåbok',),
'blåbøker': ('blåbok',),
'blåbøkene': ('blåbok',),
'blåbær': ('blåbær',),
'blåbæret': ('blåbær',),
'blåbær': ('blåbær',),
'blåbæra': ('blåbær',),
'blåbærene': ('blåbær',),
'blåbærpai': ('blåbærpai',),
'blåbærpaien': ('blåbærpai',),
'blåbærpaier': ('blåbærpai',),
'blåbærpaiene': ('blåbærpai',),
'blåbærsaft': ('blåbærsaft',),
'blåbærsaften': ('blåbærsaft',),
'blåbærsafta': ('blåbærsaft',),
'blåbærsafter': ('blåbærsaft',),
'blåbærsaftene': ('blåbærsaft',),
'blåbærsuppe': ('blåbærsuppe',),
'blåbærsuppen': ('blåbærsuppe',),
'blåbærsuppa': ('blåbærsuppe',),
'blåbærsupper': ('blåbærsuppe',),
'blåbærsuppene': ('blåbærsuppe',),
'blåbærsyltetøy': ('blåbærsyltetøy',),
'blåbærsyltetøyet': ('blåbærsyltetøy',),
'blåbærsyltetøy': ('blåbærsyltetøy',),
'blåbærsyltetøyer': ('blåbærsyltetøy',),
'blåbærsyltetøy': ('blåbærsyltetøy',),
'blåbærsyltetøyer': ('blåbærsyltetøy',),
'blåbærsyltetøya': ('blåbærsyltetøy',),
'blåbærsyltetøyene': ('blåbærsyltetøy',),
'blådress': ('blådress',),
'blådressen': ('blådress',),
'blådresser': ('blådress',),
'blådressene': ('blådress',),
'blåhval': ('blåhval',),
'blåhvalen': ('blåhval',),
'blåhvaler': ('blåhval',),
'blåhvalene': ('blåhval',),
'blåklokke': ('blåklokke',),
'blåklokken': ('blåklokke',),
'blåklokka': ('blåklokke',),
'blåklokker': ('blåklokke',),
'blåklokkene': ('blåklokke',),
'blåknapp': ('blåknapp',),
'blåknappen': ('blåknapp',),
'blåknapper': ('blåknapp',),
'blåknappene': ('blåknapp',),
'blåknute': ('blåknute',),
'blåknuten': ('blåknute',),
'blåknuter': ('blåknute',),
'blåknutene': ('blåknute',),
'blåkoll': ('blåkoll',),
'blåkollen': ('blåkoll',),
'blåkoller': ('blåkoll',),
'blåkollene': ('blåkoll',),
'blåkval': ('blåkval',),
'blåkvalen': ('blåkval',),
'blåkvaler': ('blåkval',),
'blåkvalene': ('blåkval',),
'blåkveite': ('blåkveite',),
'blåkveiten': ('blåkveite',),
'blåkveita': ('blåkveite',),
'blåkveiter': ('blåkveite',),
'blåkveitene': ('blåkveite',),
'blåleire': ('blåleire',),
'blåleiren': ('blåleire',),
'blåleira': ('blåleire',),
'blåleirer': ('blåleire',),
'blåleirene': ('blåleire',),
'blålys': ('blålys',),
'blålyset': ('blålys',),
'blålys': ('blålys',),
'blålysa': ('blålys',),
'blålysene': ('blålys',),
'blåmandag': ('blåmandag',),
'blåmandagen': ('blåmandag',),
'blåmandager': ('blåmandag',),
'blåmandagene': ('blåmandag',),
'blåmeis': ('blåmeis',),
'blåmeisen': ('blåmeis',),
'blåmeisa': ('blåmeis',),
'blåmeiser': ('blåmeis',),
'blåmeisene': ('blåmeis',),
'blåmyr': ('blåmyr',),
'blåmyren': ('blåmyr',),
'blåmyra': ('blåmyr',),
'blåmyrer': ('blåmyr',),
'blåmyrene': ('blåmyr',),
'blåne': ('blåne',),
'blånen': ('blåne',),
'blåner': ('blåne',),
'blånene': ('blåne',),
'blåpapir': ('blåpapir',),
'blåpapiret': ('blåpapir',),
'blåpapir': ('blåpapir',),
'blåpapirer': ('blåpapir',),
'blåpapir': ('blåpapir',),
'blåpapirer': ('blåpapir',),
'blåpapira': ('blåpapir',),
'blåpapirene': ('blåpapir',),
'blår': ('blår',),
'blåregn': ('blåregn',),
'blåregnen': ('blåregn',),
'blåregner': ('blåregn',),
'blåregn': ('blåregn',),
'blåregnene': ('blåregn',),
'blårev': ('blårev',),
'blåreven': ('blårev',),
'blårever': ('blårev',),
'blårevene': ('blårev',),
'blåruss': ('blåruss',),
'blårussen': ('blåruss',),
'blåruss': ('blåruss',),
'blårussene': ('blåruss',),
'blås': ('blås',),
'blåsen': ('blås',),
'blåser': ('blås',),
'blåsene': ('blås',),
'blåse': ('blåse',),
'blåsen': ('blåse',),
'blåsa': ('blåse',),
'blåser': ('blåse',),
'blåsene': ('blåse',),
'blåsebelg': ('blåsebelg',),
'blåsebelgen': ('blåsebelg',),
'blåsebelger': ('blåsebelg',),
'blåsebelgene': ('blåsebelg',),
'blåseinstrument': ('blåseinstrument',),
'blåseinstrumentet': ('blåseinstrument',),
'blåseinstrument': ('blåseinstrument',),
'blåseinstrumenter': ('blåseinstrument',),
'blåseinstrument': ('blåseinstrument',),
'blåseinstrumenter': ('blåseinstrument',),
'blåseinstrumenta': ('blåseinstrument',),
'blåseinstrumentene': ('blåseinstrument',),
'blåser': ('blåser',),
'blåseren': ('blåser',),
'blåsere': ('blåser',),
'blåserne': ('blåser',),
'blåserør': ('blåserør',),
'blåserøret': ('blåserør',),
'blåserør': ('blåserør',),
'blåserøra': ('blåserør',),
'blåserørene': ('blåserør',),
'blåskjell': ('blåskjell',),
'blåskjellen': ('blåskjell',),
'blåskjellet': ('blåskjell',),
'blåskjella': ('blåskjell',),
'blåskjell': ('blåskjell',),
'blåskjellene': ('blåskjell',),
'blåskjella': ('blåskjell',),
'blåskjellene': ('blåskjell',),
'blåst': ('blåst',),
'blåsten': ('blåst',),
'blåster': ('blåst',),
'blåstene': ('blåst',),
'blåstrupe': ('blåstrupe',),
'blåstrupen': ('blåstrupe',),
'blåstruper': ('blåstrupe',),
'blåstrupene': ('blåstrupe',),
'blåstrømpe': ('blåstrømpe',),
'blåstrømpen': ('blåstrømpe',),
'blåstrømpa': ('blåstrømpe',),
'blåstrømper': ('blåstrømpe',),
'blåstrømpene': ('blåstrømpe',),
'blåsymre': ('blåsymre',),
'blåsymren': ('blåsymre',),
'blåsymra': ('blåsymre',),
'blåsymrer': ('blåsymre',),
'blåsymrene': ('blåsymre',),
'blåsyre': ('blåsyre',),
'blåsyren': ('blåsyre',),
'blåsyra': ('blåsyre',),
'blåsyrer': ('blåsyre',),
'blåsyrene': ('blåsyre',),
'blått': ('blått',),
'blåtøy': ('blåtøy',),
'blåtøyet': ('blåtøy',),
'blåtøyer': ('blåtøy',),
'blåtøya': ('blåtøy',),
'blåtøyene': ('blåtøy',),
'blåtøyskjole': ('blåtøyskjole',),
'blåtøyskjolen': ('blåtøyskjole',),
'blåtøyskjoler': ('blåtøyskjole',),
'blåtøyskjolene': ('blåtøyskjole',),
'blåved': ('blåved',),
'blåveden': ('blåved',),
'blåveder': ('blåved',),
'blåvedene': ('blåved',),
'blåveis': ('blåveis',),
'blåveisen': ('blåveis',),
'blåveiser': ('blåveis',),
'blåveisene': ('blåveis',),
'blære': ('blære',),
'blæren': ('blære',),
'blæra': ('blære',),
'blærer': ('blære',),
'blærene': ('blære',),
'blære': ('blære',),
'blæren': ('blære',),
'blæra': ('blære',),
'blærer': ('blære',),
'blærene': ('blære',),
'blærebetennelse': ('blærebetennelse',),
'blærebetennelsen': ('blærebetennelse',),
'blærebetennelser': ('blærebetennelse',),
'blærebetennelsene': ('blærebetennelse',),
'blærehals': ('blærehals',),
'blærehalsen': ('blærehals',),
'blærehalser': ('blærehals',),
'blærehalsene': ('blærehals',),
'blærehalskjertel': ('blærehalskjertel',),
'blærehalskjertelen': ('blærehalskjertel',),
'blærehalskjertler': ('blærehalskjertel',),
'blærehalskjertlene': ('blærehalskjertel',),
'blærekatarr': ('blærekatarr',),
'blærekatarren': ('blærekatarr',),
'blærekatarrer': ('blærekatarr',),
'blærekatarrene': ('blærekatarr',),
'blæretang': ('blæretang',),
'blæretangen': ('blæretang',),
'blæretanget': ('blæretang',),
'blæretanger': ('blæretang',),
'blæretang': ('blæretang',),
'blæretangene': ('blæretang',),
'blæretanga': ('blæretang',),
'blæretangene': ('blæretang',),
'bløder': ('bløder',),
'bløderen': ('bløder',),
'blødere': ('bløder',),
'bløderne': ('bløder',),
'bløderfamilie': ('bløderfamilie',),
'bløderfamilien': ('bløderfamilie',),
'bløderfamilier': ('bløderfamilie',),
'bløderfamiliene': ('bløderfamilie',),
'blødersjukdom': ('blødersjukdom',),
'blødersjukdommen': ('blødersjukdom',),
'blødersjukdommer': ('blødersjukdom',),
'blødersjukdommene': ('blødersjukdom',),
'blødersjuke': ('blødersjuke',),
'blødersjuken': ('blødersjuke',),
'blødersjuker': ('blødersjuke',),
'blødersjukene': ('blødersjuke',),
'blødersykdom': ('blødersykdom',),
'blødersykdommen': ('blødersykdom',),
'blødersykdommer': ('blødersykdom',),
'blødersykdommene': ('blødersykdom',),
'blødersyke': ('blødersyke',),
'blødersyken': ('blødersyke',),
'blødersyker': ('blødersyke',),
'blødersykene': ('blødersyke',),
'blødme': ('blødme',),
'blødmen': ('blødme',),
'blødmer': ('blødme',),
'blødmene': ('blødme',),
'blødning': ('blødning',),
'blødningen': ('blødning',),
'blødninga': ('blødning',),
'blødninger': ('blødning',),
'blødningene': ('blødning',),
'bløff': ('bløff',),
'bløffen': ('bløff',),
'bløffer': ('bløff',),
'bløffene': ('bløff',),
'bløffmaker': ('bløffmaker',),
'bløffmakeren': ('bløffmaker',),
'bløffmakere': ('bløffmaker',),
'bløffmakerne': ('bløffmaker',),
'bløt': ('bløt',),
'bløtdyr': ('bløtdyr',),
'bløtdyret': ('bløtdyr',),
'bløtdyr': ('bløtdyr',),
'bløtdyra': ('bløtdyr',),
'bløtdyrene': ('bløtdyr',),
'bløtjern': ('bløtjern',),
'bløtjernet': ('bløtjern',),
'bløtjern': ('bløtjern',),
'bløtjerna': ('bløtjern',),
'bløtjernene': ('bløtjern',),
'bløtkake': ('bløtkake',),
'bløtkaken': ('bløtkake',),
'bløtkaka': ('bløtkake',),
'bløtkaker': ('bløtkake',),
'bløtkakene': ('bløtkake',),
'bløtskilpadde': ('bløtskilpadde',),
'bløtskilpadden': ('bløtskilpadde',),
'bløtskilpadda': ('bløtskilpadde',),
'bløtskilpadder': ('bløtskilpadde',),
'bløtskilpaddene': ('bløtskilpadde',),
'bløtstål': ('bløtstål',),
'bløtstålet': ('bløtstål',),
'bløtstål': ('bløtstål',),
'bløtståla': ('bløtstål',),
'bløtstålene': ('bløtstål',),
'bløyt': ('bløyt',),
'bløyte': ('bløyte',),
'bløyten': ('bløyte',),
'bløyta': ('bløyte',),
'bløyter': ('bløyte',),
'bløytene': ('bløyte',),
'bo': ('bo',),
'boet': ('bo',),
'bo': ('bo',),
'boa': ('bo',),
'boene': ('bo',),
'bo': ('bo',),
'boa': ('boa',),
'boaen': ('boa',),
'boaer': ('boa',),
'boaene': ('boa',),
'boardingkort': ('boardingkort',),
'boardingkortet': ('boardingkort',),
'boardingkort': ('boardingkort',),
'boardingkorta': ('boardingkort',),
'boardingkortene': ('boardingkort',),
'bobby': ('bobby',),
'bobbyen': ('bobby',),
'bobbyer': ('bobby',),
'bobbyene': ('bobby',),
'bobestyrer': ('bobestyrer',),
'bobestyreren': ('bobestyrer',),
'bobestyrere': ('bobestyrer',),
'bobestyrerne': ('bobestyrer',),
'boble': ('boble',),
'boblen': ('boble',),
'bobla': ('boble',),
'bobler': ('boble',),
'boblene': ('boble',),
'boblejakke': ('boblejakke',),
'boblejakken': ('boblejakke',),
'boblejakka': ('boblejakke',),
'boblejakker': ('boblejakke',),
'boblejakkene': ('boblejakke',),
'boblestoff': ('boblestoff',),
'boblestoffet': ('boblestoff',),
'boblestoff': ('boblestoff',),
'boblestoffer': ('boblestoff',),
'boblestoff': ('boblestoff',),
'boblestoffer': ('boblestoff',),
'boblestoffa': ('boblestoff',),
'boblestoffene': ('boblestoff',),
'bobsleigh': ('bobsleigh',),
'bobsleighen': ('bobsleigh',),
'bobsleigher': ('bobsleigh',),
'bobsleighene': ('bobsleigh',),
'bobsleighbane': ('bobsleighbane',),
'bobsleighbanen': ('bobsleighbane',),
'bobsleighbaner': ('bobsleighbane',),
'bobsleighbanene': ('bobsleighbane',),
'boccia': ('boccia',),
'bocciaen': ('boccia',),
'bocciaer': ('boccia',),
'bocciaene': ('boccia',),
'bod': ('bod',),
'boden': ('bod',),
'boder': ('bod',),
'bodene': ('bod',),
'bodega': ('bodega',),
'bodegaen': ('bodega',),
'bodegaer': ('bodega',),
'bodegaene': ('bodega',),
'bodybuilding': ('bodybuilding',),
'bodybuildingen': ('bodybuilding',),
'bodybuildinga': ('bodybuilding',),
'bodybuildinger': ('bodybuilding',),
'bodybuildingene': ('bodybuilding',),
'boer': ('boer',),
'boeren': ('boer',),
'boere': ('boer',),
'boerne': ('boer',),
'bofellesskap': ('bofellesskap',),
'bofellesskapet': ('bofellesskap',),
'bofellesskap': ('bofellesskap',),
'bofellesskaper': ('bofellesskap',),
'bofellesskap': ('bofellesskap',),
'bofellesskaper': ('bofellesskap',),
'bofellesskapa': ('bofellesskap',),
'bofellesskapene': ('bofellesskap',),
'boflate': ('boflate',),
'boflaten': ('boflate',),
'boflata': ('boflate',),
'boflater': ('boflate',),
'boflatene': ('boflate',),
'boform': ('boform',),
'boformen': ('boform',),
'boforma': ('boform',),
'boformer': ('boform',),
'boformene': ('boform',),
'bog': ('bog',),
'bogen': ('bog',),
'boger': ('bog',),
'bogene': ('bog',),
'boge': ('boge',),
'bogen': ('boge',),
'boger': ('boge',),
'bogene': ('boge',),
'bogebro': ('bogebro',),
'bogebroen': ('bogebro',),
'bogebroa': ('bogebro',),
'bogebroer': ('bogebro',),
'bogebroene': ('bogebro',),
'bogebru': ('bogebru',),
'bogebruen': ('bogebru',),
'bogebrua': ('bogebru',),
'bogebruer': ('bogebru',),
'bogebruene': ('bogebru',),
'bogegang': ('bogegang',),
'bogegangen': ('bogegang',),
'bogeganger': ('bogegang',),
'bogegangene': ('bogegang',),
'bogegrad': ('bogegrad',),
'bogegraden': ('bogegrad',),
'bogegrader': ('bogegrad',),
'bogegradene': ('bogegrad',),
'bogeminutt': ('bogeminutt',),
'bogeminuttet': ('bogeminutt',),
'bogeminutt': ('bogeminutt',),
'bogeminutter': ('bogeminutt',),
'bogeminutt': ('bogeminutt',),
'bogeminutter': ('bogeminutt',),
'bogeminutta': ('bogeminutt',),
'bogeminuttene': ('bogeminutt',),
'bogeparentes': ('bogeparentes',),
'bogeparentesen': ('bogeparentes',),
'bogeparenteser': ('bogeparentes',),
'bogeparentesene': ('bogeparentes',),
'bogesag': ('bogesag',),
'bogesagen': ('bogesag',),
'bogesaga': ('bogesag',),
'bogesager': ('bogesag',),
'bogesagene': ('bogesag',),
'bogesekund': ('bogesekund',),
'bogesekundet': ('bogesekund',),
'bogesekund': ('bogesekund',),
'bogesekunder': ('bogesekund',),
'bogesekund': ('bogesekund',),
'bogesekunder': ('bogesekund',),
'bogesekunda': ('bogesekund',),
'bogesekundene': ('bogesekund',),
'bogestreng': ('bogestreng',),
'bogestrengen': ('bogestreng',),
'bogestrenger': ('bogestreng',),
'bogestrengene': ('bogestreng',),
'bogetak': ('bogetak',),
'bogetaket': ('bogetak',),
'bogetak': ('bogetak',),
'bogetaka': ('bogetak',),
'bogetakene': ('bogetak',),
'bogevindu': ('bogevindu',),
'bogevinduet': ('bogevindu',),
'bogevindu': ('bogevindu',),
'bogevinduer': ('bogevindu',),
'bogevindu': ('bogevindu',),
'bogevinduer': ('bogevindu',),
'bogevindua': ('bogevindu',),
'bogevinduene': ('bogevindu',),
'boggi': ('boggi',),
'boggien': ('boggi',),
'boggier': ('boggi',),
'boggiene': ('boggi',),
'boggivogn': ('boggivogn',),
'boggivognen': ('boggivogn',),
'boggivogna': ('boggivogn',),
'boggivogner': ('boggivogn',),
'boggivognene': ('boggivogn',),
'bogtre': ('bogtre',),
'bogtreet': ('bogtre',),
'bogtre': ('bogtre',),
'bogtrær': ('bogtre',),
'bogtrea': ('bogtre',),
'bogtrærne': ('bogtre',),
'bohave': ('bohave',),
'bohavet': ('bohave',),
'bohaver': ('bohave',),
'bohava': ('bohave',),
'bohavene': ('bohave',),
'bohem': ('bohem',),
'bohemen': ('bohem',),
'bohemer': ('bohem',),
'bohemene': ('bohem',),
'bohembevegelse': ('bohembevegelse',),
'bohembevegelsen': ('bohembevegelse',),
'bohembevegelser': ('bohembevegelse',),
'bohembevegelsene': ('bohembevegelse',),
'boi': ('boi',),
'boien': ('boi',),
'boier': ('boi',),
'boiene': ('boi',),
'boikott': ('boikott',),
'boikotten': ('boikott',),
'boikotter': ('boikott',),
'boikottene': ('boikott',),
'bojar': ('bojar',),
'bojaren': ('bojar',),
'bojarer': ('bojar',),
'bojarene': ('bojar',),
'bok': ('bok',),
'boken': ('bok',),
'boka': ('bok',),
'boker': ('bok',),
'bokene': ('bok',),
'bok': ('bok',),
'boken': ('bok',),
'boka': ('bok',),
'bøker': ('bok',),
'bøkene': ('bok',),
'bokanmeldelse': ('bokanmeldelse',),
'bokanmeldelsen': ('bokanmeldelse',),
'bokanmeldelser': ('bokanmeldelse',),
'bokanmeldelsene': ('bokanmeldelse',),
'bokanmelder': ('bokanmelder',),
'bokanmelderen': ('bokanmelder',),
'bokanmeldere': ('bokanmelder',),
'bokanmelderne': ('bokanmelder',),
'bokbind': ('bokbind',),
'bokbindet': ('bokbind',),
'bokbind': ('bokbind',),
'bokbinda': ('bokbind',),
'bokbindene': ('bokbind',),
'bokbinder': ('bokbinder',),
'bokbinderen': ('bokbinder',),
'bokbindere': ('bokbinder',),
'bokbinderne': ('bokbinder',),
'bokbrenning': ('bokbrenning',),
'bokbrenningen': ('bokbrenning',),
'bokbrenninga': ('bokbrenning',),
'bokbrenninger': ('bokbrenning',),
'bokbrenningene': ('bokbrenning',),
'bokbuss': ('bokbuss',),
'bokbussen': ('bokbuss',),
'bokbusser': ('bokbuss',),
'bokbussene': ('bokbuss',),
'bokbåt': ('bokbåt',),
'bokbåten': ('bokbåt',),
'bokbåter': ('bokbåt',),
'bokbåtene': ('bokbåt',),
'bokettersyn': ('bokettersyn',),
'bokettersynet': ('bokettersyn',),
'bokettersyn': ('bokettersyn',),
'bokettersyna': ('bokettersyn',),
'bokettersynene': ('bokettersyn',),
'bokfink': ('bokfink',),
'bokfinken': ('bokfink',),
'bokfinker': ('bokfink',),
'bokfinkene': ('bokfink',),
'bokflom': ('bokflom',),
'bokflommen': ('bokflom',),
'bokflommer': ('bokflom',),
'bokflommene': ('bokflom',),
'bokform': ('bokform',),
'bokformen': ('bokform',),
'bokforma': ('bokform',),
'bokformer': ('bokform',),
'bokformene': ('bokform',),
'bokføring': ('bokføring',),
'bokføringen': ('bokføring',),
'bokføringa': ('bokføring',),
'bokføringer': ('bokføring',),
'bokføringene': ('bokføring',),
'bokhandel': ('bokhandel',),
'bokhandelen': ('bokhandel',),
'bokhandler': ('bokhandel',),
'bokhandlene': ('bokhandel',),
'bokhandler': ('bokhandler',),
'bokhandleren': ('bokhandler',),
'bokhandlere': ('bokhandler',),
'bokhandlerne': ('bokhandler',),
'bokholder': ('bokholder',),
'bokholderen': ('bokholder',),
'bokholdere': ('bokholder',),
'bokholderne': ('bokholder',),
'bokholderi': ('bokholderi',),
'bokholderiet': ('bokholderi',),
'bokholderi': ('bokholderi',),
'bokholderier': ('bokholderi',),
'bokholderi': ('bokholderi',),
'bokholderier': ('bokholderi',),
'bokholderia': ('bokholderi',),
'bokholderiene': ('bokholderi',),
'bokhvete': ('bokhvete',),
'bokhveten': ('bokhvete',),
'bokhveter': ('bokhvete',),
'bokhvetene': ('bokhvete',),
'bokhylle': ('bokhylle',),
'bokhyllen': ('bokhylle',),
'bokhylla': ('bokhylle',),
'bokhyller': ('bokhylle',),
'bokhyllene': ('bokhylle',),
'bokhøst': ('bokhøst',),
'bokhøsten': ('bokhøst',),
'bokhøster': ('bokhøst',),
'bokhøstene': ('bokhøst',),
'bokk': ('bokk',),
'bokken': ('bokk',),
'bokker': ('bokk',),
'bokkene': ('bokk',),
'bokklubb': ('bokklubb',),
'bokklubben': ('bokklubb',),
'bokklubber': ('bokklubb',),
'bokklubbene': ('bokklubb',),
'bokkunst': ('bokkunst',),
'bokkunsten': ('bokkunst',),
'bokkunster': ('bokkunst',),
'bokkunstene': ('bokkunst',),
'bokkøl': ('bokkøl',),
'bokkølet': ('bokkøl',),
'bokkøl': ('bokkøl',),
'bokkøla': ('bokkøl',),
'boklade': ('boklade',),
'bokladen': ('boklade',),
'boklader': ('boklade',),
'bokladene': ('boklade',),
'bokladepris': ('bokladepris',),
'bokladeprisen': ('bokladepris',),
'bokladepriser': ('bokladepris',),
'bokladeprisene': ('bokladepris',),
'bokmelder': ('bokmelder',),
'bokmelderen': ('bokmelder',),
'bokmeldere': ('bokmelder',),
'bokmelderne': ('bokmelder',),
'bokmelding': ('bokmelding',),
'bokmeldingen': ('bokmelding',),
'bokmeldinga': ('bokmelding',),
'bokmeldinger': ('bokmelding',),
'bokmeldingene': ('bokmelding',),
'bokmerke': ('bokmerke',),
'bokmerket': ('bokmerke',),
'bokmerker': ('bokmerke',),
'bokmerka': ('bokmerke',),
'bokmerkene': ('bokmerke',),
'bokmål': ('bokmål',),
'bokmålet': ('bokmål',),
'bokmål': ('bokmål',),
'bokmåla': ('bokmål',),
'bokmålene': ('bokmål',),
'bokmålstekst': ('bokmålstekst',),
'bokmålsteksten': ('bokmålstekst',),
'bokmålsteksta': ('bokmålstekst',),
'bokmålstekster': ('bokmålstekst',),
'bokmålstekstene': ('bokmålstekst',),
'bokmålsutgave': ('bokmålsutgave',),
'bokmålsutgaven': ('bokmålsutgave',),
'bokmålsutgava': ('bokmålsutgave',),
'bokmålsutgaver': ('bokmålsutgave',),
'bokmålsutgavene': ('bokmålsutgave',),
'bokollektiv': ('bokollektiv',),
'bokollektivet': ('bokollektiv',),
'bokollektiv': ('bokollektiv',),
'bokollektiver': ('bokollektiv',),
'bokollektiv': ('bokollektiv',),
'bokollektiver': ('bokollektiv',),
'bokollektiva': ('bokollektiv',),
'bokollektivene': ('bokollektiv',),
'bokorm': ('bokorm',),
'bokormen': ('bokorm',),
'bokormer': ('bokorm',),
'bokormene': ('bokorm',),
'bokreditt': ('bokreditt',),
'bokreditten': ('bokreditt',),
'bokreditter': ('bokreditt',),
'bokredittene': ('bokreditt',),
'bokreol': ('bokreol',),
'bokreolen': ('bokreol',),
'bokreoler': ('bokreol',),
'bokreolene': ('bokreol',),
'boks': ('boks',),
'boksen': ('boks',),
'bokser': ('boks',),
'boksene': ('boks',),
'boksamler': ('boksamler',),
'boksamleren': ('boksamler',),
'boksamlere': ('boksamler',),
'boksamlerne': ('boksamler',),
'boksamling': ('boksamling',),
'boksamlingen': ('boksamling',),
'boksamlinga': ('boksamling',),
'boksamlinger': ('boksamling',),
'boksamlingene': ('boksamling',),
'boksehanske': ('boksehanske',),
'boksehansken': ('boksehanske',),
'boksehansker': ('boksehanske',),
'boksehanskene': ('boksehanske',),
'boksekamp': ('boksekamp',),
'boksekampen': ('boksekamp',),
'boksekamper': ('boksekamp',),
'boksekampene': ('boksekamp',),
'bokser': ('bokser',),
'bokseren': ('bokser',),
'boksere': ('bokser',),
'bokserne': ('bokser',),
'boksering': ('boksering',),
'bokseringen': ('boksering',),
'bokseringer': ('boksering',),
'bokseringene': ('boksering',),
'boksermotor': ('boksermotor',),
'boksermotoren': ('boksermotor',),
'boksermotorer': ('boksermotor',),
'boksermotorene': ('boksermotor',),
'bokskalv': ('bokskalv',),
'bokskalven': ('bokskalv',),
'bokskalver': ('bokskalv',),
'bokskalvene': ('bokskalv',),
'bokskalvsko': ('bokskalvsko',),
'bokskalvskoen': ('bokskalvsko',),
'bokskalvsko': ('bokskalvsko',),
'bokskalvskoa': ('bokskalvsko',),
'bokskalvskoene': ('bokskalvsko',),
'bokskred': ('bokskred',),
'bokskredet': ('bokskred',),
'bokskred': ('bokskred',),
'bokskreda': ('bokskred',),
'bokskredene': ('bokskred',),
'bokspråk': ('bokspråk',),
'bokspråket': ('bokspråk',),
'bokspråk': ('bokspråk',),
'bokspråka': ('bokspråk',),
'bokspråkene': ('bokspråk',),
'bokstav': ('bokstav',),
'bokstaven': ('bokstav',),
'bokstaver': ('bokstav',),
'bokstavene': ('bokstav',),
'bokstavord': ('bokstavord',),
'bokstavordet': ('bokstavord',),
'bokstavord': ('bokstavord',),
'bokstavorda': ('bokstavord',),
'bokstavordene': ('bokstavord',),
'bokstavregning': ('bokstavregning',),
'bokstavregningen': ('bokstavregning',),
'bokstavregninga': ('bokstavregning',),
'bokstavregninger': ('bokstavregning',),
'bokstavregningene': ('bokstavregning',),
'bokstavrim': ('bokstavrim',),
'bokstavrimet': ('bokstavrim',),
'bokstavrim': ('bokstavrim',),
'bokstavrima': ('bokstavrim',),
'bokstavrimene': ('bokstavrim',),
'bokstavtrelldom': ('bokstavtrelldom',),
'bokstavtrelldommen': ('bokstavtrelldom',),
'bokstavtrelldommer': ('bokstavtrelldom',),
'bokstavtrelldommene': ('bokstavtrelldom',),
'boksåpner': ('boksåpner',),
'boksåpneren': ('boksåpner',),
'boksåpnere': ('boksåpner',),
'boksåpnerne': ('boksåpner',),
'boksøl': ('boksøl',),
'boksølet': ('boksøl',),
'boksøl': ('boksøl',),
'boksøla': ('boksøl',),
'boktittel': ('boktittel',),
'boktittelen': ('boktittel',),
'boktitler': ('boktittel',),
'boktitlene': ('boktittel',),
'boktrykk': ('boktrykk',),
'boktrykket': ('boktrykk',),
'boktrykk': ('boktrykk',),
'boktrykka': ('boktrykk',),
'boktrykkene': ('boktrykk',),
'boktrykker': ('boktrykker',),
'boktrykkeren': ('boktrykker',),
'boktrykkere': ('boktrykker',),
'boktrykkerne': ('boktrykker',),
'boktrykkeri': ('boktrykkeri',),
'boktrykkeriet': ('boktrykkeri',),
'boktrykkeri': ('boktrykkeri',),
'boktrykkerier': ('boktrykkeri',),
'boktrykkeri': ('boktrykkeri',),
'boktrykkerier': ('boktrykkeri',),
'boktrykkeria': ('boktrykkeri',),
'boktrykkeriene': ('boktrykkeri',),
'boktrykkerkunst': ('boktrykkerkunst',),
'boktrykkerkunsten': ('boktrykkerkunst',),
'boktrykkerkunster': ('boktrykkerkunst',),
'boktrykkerkunstene': ('boktrykkerkunst',),
'bokverden': ('bokverden',),
'bokverdenen': ('bokverden',),
'bokverdener': ('bokverden',),
'bokverdenene': ('bokverden',),
'bol': ('bol',),
'bolen': ('bol',),
'boler': ('bol',),
'bolene': ('bol',),
'bol': ('bol',),
'bolet': ('bol',),
'bol': ('bol',),
'bola': ('bol',),
'bolene': ('bol',),
'bolero': ('bolero',),
'boleroen': ('bolero',),
'boleroer': ('bolero',),
'boleroene': ('bolero',),
'bolig': ('bolig',),
'boligen': ('bolig',),
'boliger': ('bolig',),
'boligene': ('bolig',),
'boligblokk': ('boligblokk',),
'boligblokken': ('boligblokk',),
'boligblokka': ('boligblokk',),
'boligblokker': ('boligblokk',),
'boligblokkene': ('boligblokk',),
'boligbyggelag': ('boligbyggelag',),
'boligbyggelaget': ('boligbyggelag',),
'boligbyggelag': ('boligbyggelag',),
'boligbyggelaga': ('boligbyggelag',),
'boligbyggelagene': ('boligbyggelag',),
'boligbygging': ('boligbygging',),
'boligbyggingen': ('boligbygging',),
'boligbygginga': ('boligbygging',),
'boligbygginger': ('boligbygging',),
'boligbyggingene': ('boligbygging',),
'boligdekk': ('boligdekk',),
'boligdekket': ('boligdekk',),
'boligdekk': ('boligdekk',),
'boligdekka': ('boligdekk',),
'boligdekkene': ('boligdekk',),
'boligfelt': ('boligfelt',),
'boligfeltet': ('boligfelt',),
'boligfelt': ('boligfelt',),
'boligfelter': ('boligfelt',),
'boligfelt': ('boligfelt',),
'boligfelter': ('boligfelt',),
'boligfelta': ('boligfelt',),
'boligfeltene': ('boligfelt',),
'boligfinansiering': ('boligfinansiering',),
'boligfinansieringen': ('boligfinansiering',),
'boligfinansieringa': ('boligfinansiering',),
'boligfinansieringer': ('boligfinansiering',),
'boligfinansieringene': ('boligfinansiering',),
'boligforhold': ('boligforhold',),
'boligforholdet': ('boligforhold',),
'boligforhold': ('boligforhold',),
'boligforholda': ('boligforhold',),
'boligforholdene': ('boligforhold',),
'boligformidling': ('boligformidling',),
'boligformidlingen': ('boligformidling',),
'boligformidlinga': ('boligformidling',),
'boligformidlinger': ('boligformidling',),
'boligformidlingene': ('boligformidling',),
'bolighai': ('bolighai',),
'bolighaien': ('bolighai',),
'bolighaier': ('bolighai',),
'bolighaiene': ('bolighai',),
'boliglån': ('boliglån',),
'boliglånet': ('boliglån',),
'boliglån': ('boliglån',),
'boliglåna': ('boliglån',),
'boliglånene': ('boliglån',),
'boligmarked': ('boligmarked',),
'boligmarkedet': ('boligmarked',),
'boligmarked': ('boligmarked',),
'boligmarkeder': ('boligmarked',),
'boligmarked': ('boligmarked',),
'boligmarkeder': ('boligmarked',),
'boligmarkeda': ('boligmarked',),
'boligmarkedene': ('boligmarked',),
'boligmasse': ('boligmasse',),
'boligmassen': ('boligmasse',),
'boligmasser': ('boligmasse',),
'boligmassene': ('boligmasse',),
'boligmiljø': ('boligmiljø',),
'boligmiljøet': ('boligmiljø',),
'boligmiljø': ('boligmiljø',),
'boligmiljøer': ('boligmiljø',),
'boligmiljø': ('boligmiljø',),
'boligmiljøer': ('boligmiljø',),
'boligmiljøa': ('boligmiljø',),
'boligmiljøene': ('boligmiljø',),
'boligområde': ('boligområde',),
'boligområdet': ('boligområde',),
'boligområder': ('boligområde',),
'boligområda': ('boligområde',),
'boligområdene': ('boligområde',),
'boligplattform': ('boligplattform',),
'boligplattformen': ('boligplattform',),
'boligplattforma': ('boligplattform',),
'boligplattformer': ('boligplattform',),
'boligplattformene': ('boligplattform',),
'boligreising': ('boligreising',),
'boligreisingen': ('boligreising',),
'boligreisinga': ('boligreising',),
'boligreisinger': ('boligreising',),
'boligreisingene': ('boligreising',),
'boligstandard': ('boligstandard',),
'boligstandarden': ('boligstandard',),
'boligstandarder': ('boligstandard',),
'boligstandardene': ('boligstandard',),
'boligtelefon': ('boligtelefon',),
'boligtelefonen': ('boligtelefon',),
'boligtelefoner': ('boligtelefon',),
'boligtelefonene': ('boligtelefon',),
'boligtomt': ('boligtomt',),
'boligtomten': ('boligtomt',),
'boligtomta': ('boligtomt',),
'boligtomter': ('boligtomt',),
'boligtomtene': ('boligtomt',),
'bolivianer': ('bolivianer',),
'bolivianeren': ('bolivianer',),
'bolivianere': ('bolivianer',),
'bolivianerne': ('bolivianer',),
'bolk': ('bolk',),
'bolken': ('bolk',),
'bolker': ('bolk',),
'bolkene': ('bolk',),
'bolle': ('bolle',),
'bollen': ('bolle',),
'boller': ('bolle',),
'bollene': ('bolle',),
'bolleansikt': ('bolleansikt',),
'bolleansiktet': ('bolleansikt',),
'bolleansikt': ('bolleansikt',),
'bolleansikter': ('bolleansikt',),
'bolleansikt': ('bolleansikt',),
'bolleansikter': ('bolleansikt',),
'bolleansikta': ('bolleansikt',),
'bolleansiktene': ('bolleansikt',),
'bolledeig': ('bolledeig',),
'bolledeigen': ('bolledeig',),
'bolledeiger': ('bolledeig',),
'bolledeigene': ('bolledeig',),
'bollekinn': ('bollekinn',),
'bollekinnet': ('bollekinn',),
'bollekinn': ('bollekinn',),
'bollekinner': ('bollekinn',),
'bollekinn': ('bollekinn',),
'bollekinner': ('bollekinn',),
'bollekinna': ('bollekinn',),
'bollekinnene': ('bollekinn',),
'bolsjevik': ('bolsjevik',),
'bolsjeviken': ('bolsjevik',),
'bolsjeviker': ('bolsjevik',),
'bolsjevikene': ('bolsjevik',),
'bolsok': ('bolsok',),
'bolt': ('bolt',),
'bolten': ('bolt',),
'bolter': ('bolt',),
'boltene': ('bolt',),
'bolverk': ('bolverk',),
'bolverket': ('bolverk',),
'bolverk': ('bolverk',),
'bolverker': ('bolverk',),
'bolverk': ('bolverk',),
'bolverker': ('bolverk',),
'bolverka': ('bolverk',),
'bolverkene': ('bolverk',),
'bomaskin': ('bomaskin',),
'bomaskinen': ('bomaskin',),
'bomaskiner': ('bomaskin',),
'bomaskinene': ('bomaskin',),
'bombardement': ('bombardement',),
'bombardementet': ('bombardement',),
'bombardement': ('bombardement',),
'bombardementer': ('bombardement',),
'bombardement': ('bombardement',),
'bombardementer': ('bombardement',),
'bombardementa': ('bombardement',),
'bombardementene': ('bombardement',),
'bombasin': ('bombasin',),
'bombasinen': ('bombasin',),
'bombasiner': ('bombasin',),
'bombasinene': ('bombasin',),
'bombast': ('bombast',),
'bombasten': ('bombast',),
'bombaster': ('bombast',),
'bombastene': ('bombast',),
'bombe': ('bombe',),
'bomben': ('bombe',),
'bomba': ('bombe',),
'bomber': ('bombe',),
'bombene': ('bombe',),
'bombeangrep': ('bombeangrep',),
'bombeangrepet': ('bombeangrep',),
'bombeangrep': ('bombeangrep',),
'bombeangrepa': ('bombeangrep',),
'bombeangrepene': ('bombeangrep',),
'bombeattentat': ('bombeattentat',),
'bombeattentatet': ('bombeattentat',),
'bombeattentat': ('bombeattentat',),
'bombeattentater': ('bombeattentat',),
'bombeattentat': ('bombeattentat',),
'bombeattentater': ('bombeattentat',),
'bombeattentata': ('bombeattentat',),
'bombeattentatene': ('bombeattentat',),
'bombefly': ('bombefly',),
'bombeflyet': ('bombefly',),
'bombefly': ('bombefly',),
'bombeflya': ('bombefly',),
'bombeflyene': ('bombefly',),
'bombekaster': ('bombekaster',),
'bombekasteren': ('bombekaster',),
'bombekastere': ('bombekaster',),
'bombekasterne': ('bombekaster',),
'bomber': ('bomber',),
'bomberen': ('bomber',),
'bombere': ('bomber',),
'bomberne': ('bomber',),
'bomberegn': ('bomberegn',),
'bomberegnet': ('bomberegn',),
'bomberegn': ('bomberegn',),
'bomberegna': ('bomberegn',),
'bomberegnene': ('bomberegn',),
'bomberom': ('bomberom',),
'bomberommet': ('bomberom',),
'bomberom': ('bomberom',),
'bomberomma': ('bomberom',),
'bomberommene': ('bomberom',),
'bomkast': ('bomkast',),
'bomkastet': ('bomkast',),
'bomkast': ('bomkast',),
'bomkasta': ('bomkast',),
'bomkastene': ('bomkast',),
'bomme': ('bomme',),
'bommen': ('bomme',),
'bomma': ('bomme',),
'bommer': ('bomme',),
'bommene': ('bomme',),
'bommer': ('bommer',),
'bommeren': ('bommer',),
'bommere': ('bommer',),
'bommerne': ('bommer',),
'bommert': ('bommert',),
'bommerten': ('bommert',),
'bommerter': ('bommert',),
'bommertene': ('bommert',),
'bommesi': ('bommesi',),
'bommesien': ('bommesi',),
'bommesier': ('bommesi',),
'bommesiene': ('bommesi',),
'bomolje': ('bomolje',),
'bomoljen': ('bomolje',),
'bomolja': ('bomolje',),
'bomoljer': ('bomolje',),
'bomoljene': ('bomolje',),
'bompenger': ('bompenger',),
'bompengene': ('bompenger',),
'boms': ('boms',),
'bomsen': ('boms',),
'bomser': ('boms',),
'bomsene': ('boms',),
'bomskott': ('bomskott',),
'bomskottet': ('bomskott',),
'bomskott': ('bomskott',),
'bomskotta': ('bomskott',),
'bomskottene': ('bomskott',),
'bomskudd': ('bomskudd',),
'bomskuddet': ('bomskudd',),
'bomskudd': ('bomskudd',),
'bomskudda': ('bomskudd',),
'bomskuddene': ('bomskudd',),
'bomtur': ('bomtur',),
'bomturen': ('bomtur',),
'bomturer': ('bomtur',),
'bomturene': ('bomtur',),
'bomull': ('bomull',),
'bomullen': ('bomull',),
'bomulla': ('bomull',),
'bomuller': ('bomull',),
'bomullene': ('bomull',),
'bomullsgarn': ('bomullsgarn',),
'bomullsgarnet': ('bomullsgarn',),
'bomullsgarn': ('bomullsgarn',),
'bomullsgarna': ('bomullsgarn',),
'bomullsgarnene': ('bomullsgarn',),
'bomullsgenser': ('bomullsgenser',),
'bomullsgenseren': ('bomullsgenser',),
'bomullsgensere': ('bomullsgenser',),
'bomullsgenserne': ('bomullsgenser',),
'bomullsplantasje': ('bomullsplantasje',),
'bomullsplantasjen': ('bomullsplantasje',),
'bomullsplantasjer': ('bomullsplantasje',),
'bomullsplantasjene': ('bomullsplantasje',),
'bomullsplante': ('bomullsplante',),
'bomullsplanten': ('bomullsplante',),
'bomullsplanta': ('bomullsplante',),
'bomullsplanter': ('bomullsplante',),
'bomullsplantene': ('bomullsplante',),
'bomullsstoff': ('bomullsstoff',),
'bomullsstoffet': ('bomullsstoff',),
'bomullsstoff': ('bomullsstoff',),
'bomullsstoffer': ('bomullsstoff',),
'bomullsstoff': ('bomullsstoff',),
'bomullsstoffer': ('bomullsstoff',),
'bomullsstoffa': ('bomullsstoff',),
'bomullsstoffene': ('bomullsstoff',),
'bomvakt': ('bomvakt',),
'bomvakten': ('bomvakt',),
'bomvakta': ('bomvakt',),
'bomvakter': ('bomvakt',),
'bomvaktene': ('bomvakt',),
'bomveg': ('bomveg',),
'bomvegen': ('bomveg',),
'bomveger': ('bomveg',),
'bomvegene': ('bomveg',),
'bomvei': ('bomvei',),
'bomveien': ('bomvei',),
'bomveier': ('bomvei',),
'bomveiene': ('bomvei',),
'bonde': ('bonde',),
'bonden': ('bonde',),
'bønder': ('bonde',),
'bøndene': ('bonde',),
'bondeanger': ('bondeanger',),
'bondeangeren': ('bondeanger',),
'bondeangere': ('bondeanger',),
'bondeangrer': ('bondeanger',),
'bondeangre': ('bondeanger',),
'bondeangerne': ('bondeanger',),
'bondeangrene': ('bondeanger',),
'bondefanger': ('bondefanger',),
'bondefangeren': ('bondefanger',),
'bondefangere': ('bondefanger',),
'bondefangerne': ('bondefanger',),
'bondefangeri': ('bondefangeri',),
'bondefangeriet': ('bondefangeri',),
'bondefangeri': ('bondefangeri',),
'bondefangerier': ('bondefangeri',),
'bondefangeri': ('bondefangeri',),
'bondefangerier': ('bondefangeri',),
'bondefangeria': ('bondefangeri',),
'bondefangeriene': ('bondefangeri',),
'bondefortelling': ('bondefortelling',),
'bondefortellingen': ('bondefortelling',),
'bondefortellinga': ('bondefortelling',),
'bondefortellinger': ('bondefortelling',),
'bondefortellingene': ('bondefortelling',),
'bondegard': ('bondegard',),
'bondegarden': ('bondegard',),
'bondegarder': ('bondegard',),
'bondegardene': ('bondegard',),
'bondegardsferie': ('bondegardsferie',),
'bondegardsferien': ('bondegardsferie',),
'bondegardsferier': ('bondegardsferie',),
'bondegardsferiene': ('bondegardsferie',),
'bondegård': ('bondegård',),
'bondegården': ('bondegård',),
'bondegårder': ('bondegård',),
'bondegårdene': ('bondegård',),
'bondegårdsferie': ('bondegårdsferie',),
'bondegårdsferien': ('bondegårdsferie',),
'bondegårdsferier': ('bondegårdsferie',),
'bondegårdsferiene': ('bondegårdsferie',),
'bondekultur': ('bondekultur',),
'bondekulturen': ('bondekultur',),
'bondekulturer': ('bondekultur',),
'bondekulturene': ('bondekultur',),
'bondelag': ('bondelag',),
'bondelaget': ('bondelag',),
'bondelag': ('bondelag',),
'bondelaga': ('bondelag',),
'bondelagene': ('bondelag',),
'bondepike': ('bondepike',),
'bondepiken': ('bondepike',),
'bondepika': ('bondepike',),
'bondepiker': ('bondepike',),
'bondepikene': ('bondepike',),
'bonderomantikk': ('bonderomantikk',),
'bonderomantikken': ('bonderomantikk',),
'bonderomantikker': ('bonderomantikk',),
'bonderomantikkene': ('bonderomantikk',),
'bondevett': ('bondevett',),
'bondevettet': ('bondevett',),
'bondevett': ('bondevett',),
'bondevetta': ('bondevett',),
'bondevettene': ('bondevett',),
'bonevoks': ('bonevoks',),
'bonevoksen': ('bonevoks',),
'bonevokset': ('bonevoks',),
'bonevokser': ('bonevoks',),
'bonevoks': ('bonevoks',),
'bonevoksene': ('bonevoks',),
'bonevoksa': ('bonevoks',),
'bonevoksene': ('bonevoks',),
'bong': ('bong',),
'bongen': ('bong',),
'bonger': ('bong',),
'bongene': ('bong',),
'bongbong': ('bongbong',),
'bongbongen': ('bongbong',),
'bongbonger': ('bongbong',),
'bongbongene': ('bongbong',),
'bongotromme': ('bongotromme',),
'bongotrommen': ('bongotromme',),
'bongotromma': ('bongotromme',),
'bongotrommer': ('bongotromme',),
'bongotrommene': ('bongotromme',),
'bonitet': ('bonitet',),
'boniteten': ('bonitet',),
'boniteter': ('bonitet',),
'bonitetene': ('bonitet',),
'bonjour': ('bonjour',),
'bonjouren': ('bonjour',),
'bonjourer': ('bonjour',),
'bonjourene': ('bonjour',),
'bonmot': ('bonmot',),
'bonmotet': ('bonmot',),
'bonmot': ('bonmot',),
'bonmoter': ('bonmot',),
'bonmot': ('bonmot',),
'bonmoter': ('bonmot',),
'bonmota': ('bonmot',),
'bonmotene': ('bonmot',),
'bonus': ('bonus',),
'bonusen': ('bonus',),
'bonuser': ('bonus',),
'bonusene': ('bonus',),
'bookmaker': ('bookmaker',),
'bookmakeren': ('bookmaker',),
'bookmakere': ('bookmaker',),
'bookmakerne': ('bookmaker',),
'boom': ('boom',),
'boomen': ('boom',),
'boomer': ('boom',),
'boomene': ('boom',),
'booster': ('booster',),
'boosteren': ('booster',),
'boostere': ('booster',),
'boosterne': ('booster',),
'bop': ('bop',),
'bopen': ('bop',),
'boper': ('bop',),
'bopene': ('bop',),
'bopel': ('bopel',),
'bopelen': ('bopel',),
'bopeler': ('bopel',),
'bopelene': ('bopel',),
'boplikt': ('boplikt',),
'boplikten': ('boplikt',),
'boplikta': ('boplikt',),
'boplikter': ('boplikt',),
'bopliktene': ('boplikt',),
'bor': ('bor',),
'boren': ('bor',),
'boret': ('bor',),
'bor': ('bor',),
'borene': ('bor',),
'bora': ('bor',),
'borene': ('bor',),
'boraks': ('boraks',),
'boraksen': ('boraks',),
'borakser': ('boraks',),
'boraksene': ('boraks',),
'borat': ('borat',),
'boratet': ('borat',),
'borat': ('borat',),
'borater': ('borat',),
'borat': ('borat',),
'borater': ('borat',),
'borata': ('borat',),
'boratene': ('borat',),
'bord': ('bord',),
'borden': ('bord',),
'border': ('bord',),
'bordene': ('bord',),
'bord': ('bord',),
'bordet': ('bord',),
'bord': ('bord',),
'border': ('bord',),
'bord': ('bord',),
'border': ('bord',),
'borda': ('bord',),
'bordene': ('bord',),
'bordbein': ('bordbein',),
'bordbeinet': ('bordbein',),
'bordbein': ('bordbein',),
'bordbeina': ('bordbein',),
'bordbeinene': ('bordbein',),
'bordben': ('bordben',),
'bordbenet': ('bordben',),
'bordben': ('bordben',),
'bordbena': ('bordben',),
'bordbenene': ('bordben',),
'bordbønn': ('bordbønn',),
'bordbønnen': ('bordbønn',),
'bordbønna': ('bordbønn',),
'bordbønner': ('bordbønn',),
'bordbønnene': ('bordbønn',),
'borddame': ('borddame',),
'borddamen': ('borddame',),
'borddama': ('borddame',),
'borddamer': ('borddame',),
'borddamene': ('borddame',),
'borddans': ('borddans',),
'borddansen': ('borddans',),
'borddanser': ('borddans',),
'borddansene': ('borddans',),
'bordeaux': ('bordeaux',),
'bordeauxen': ('bordeaux',),
'bordeauxer': ('bordeaux',),
'bordeauxene': ('bordeaux',),
'bordeauxvin': ('bordeauxvin',),
'bordeauxvinen': ('bordeauxvin',),
'bordeauxviner': ('bordeauxvin',),
'bordeauxvinene': ('bordeauxvin',),
'bordell': ('bordell',),
'bordellen': ('bordell',),
'bordellet': ('bordell',),
'bordeller': ('bordell',),
'bordell': ('bordell',),
'bordeller': ('bordell',),
'bordell': ('bordell',),
'bordeller': ('bordell',),
'bordellene': ('bordell',),
'bordella': ('bordell',),
'bordellene': ('bordell',),
'bordellkvarter': ('bordellkvarter',),
'bordellkvarteret': ('bordellkvarter',),
'bordellkvarter': ('bordellkvarter',),
'bordellkvarterer': ('bordellkvarter',),
'bordellkvarter': ('bordellkvarter',),
'bordellkvarterer': ('bordellkvarter',),
'bordellkvartera': ('bordellkvarter',),
'bordellkvarterene': ('bordellkvarter',),
'bordkalender': ('bordkalender',),
'bordkalenderen': ('bordkalender',),
'bordkalendere': ('bordkalender',),
'bordkalendrer': ('bordkalender',),
'bordkalendre': ('bordkalender',),
'bordkalenderne': ('bordkalender',),
'bordkalendrene': ('bordkalender',),
'bordkavaler': ('bordkavaler',),
'bordkavaleren': ('bordkavaler',),
'bordkavalerer': ('bordkavaler',),
'bordkavalerene': ('bordkavaler',),
'bordkledning': ('bordkledning',),
'bordkledningen': ('bordkledning',),
'bordkledninga': ('bordkledning',),
'bordkledninger': ('bordkledning',),
'bordkledningene': ('bordkledning',),
'bordkort': ('bordkort',),
'bordkortet': ('bordkort',),
'bordkort': ('bordkort',),
'bordkorta': ('bordkort',),
'bordkortene': ('bordkort',),
'bordpakning': ('bordpakning',),
'bordpakningen': ('bordpakning',),
'bordpakninga': ('bordpakning',),
'bordpakninger': ('bordpakning',),
'bordpakningene': ('bordpakning',),
'bordsetning': ('bordsetning',),
'bordsetningen': ('bordsetning',),
'bordsetninga': ('bordsetning',),
'bordsetninger': ('bordsetning',),
'bordsetningene': ('bordsetning',),
'bordskikk': ('bordskikk',),
'bordskikken': ('bordskikk',),
'bordskikker': ('bordskikk',),
'bordskikkene': ('bordskikk',),
'bordtale': ('bordtale',),
'bordtalen': ('bordtale',),
'bordtaler': ('bordtale',),
'bordtalene': ('bordtale',),
'bordtennis': ('bordtennis',),
'bordtennisen': ('bordtennis',),
'bordtenniser': ('bordtennis',),
'bordtennisene': ('bordtennis',),
'bordvers': ('bordvers',),
'bordverset': ('bordvers',),
'bordvers': ('bordvers',),
'bordversa': ('bordvers',),
'bordversene': ('bordvers',),
'borebille': ('borebille',),
'borebillen': ('borebille',),
'borebiller': ('borebille',),
'borebillene': ('borebille',),
'boredekk': ('boredekk',),
'boredekket': ('boredekk',),
'boredekk': ('boredekk',),
'boredekka': ('boredekk',),
'boredekkene': ('boredekk',),
'borefartøy': ('borefartøy',),
'borefartøyet': ('borefartøy',),
'borefartøy': ('borefartøy',),
'borefartøyer': ('borefartøy',),
'borefartøy': ('borefartøy',),
'borefartøyer': ('borefartøy',),
'borefartøya': ('borefartøy',),
'borefartøyene': ('borefartøy',),
'borehol': ('borehol',),
'boreholet': ('borehol',),
'borehol': ('borehol',),
'borehola': ('borehol',),
'boreholene': ('borehol',),
'borehull': ('borehull',),
'borehullet': ('borehull',),
'borehull': ('borehull',),
'borehuller': ('borehull',),
'borehull': ('borehull',),
'borehuller': ('borehull',),
'borehulla': ('borehull',),
'borehullene': ('borehull',),
'boremusling': ('boremusling',),
'boremuslingen': ('boremusling',),
'boremuslinger': ('boremusling',),
'boremuslingene': ('boremusling',),
'boreplass': ('boreplass',),
'boreplassen': ('boreplass',),
'boreplasser': ('boreplass',),
'boreplassene': ('boreplass',),
'boreplattform': ('boreplattform',),
'boreplattformen': ('boreplattform',),
'boreplattforma': ('boreplattform',),
'boreplattformer': ('boreplattform',),
'boreplattformene': ('boreplattform',),
'borerigg': ('borerigg',),
'boreriggen': ('borerigg',),
'borerigger': ('borerigg',),
'boreriggene': ('borerigg',),
'borerør': ('borerør',),
'borerøret': ('borerør',),
'borerør': ('borerør',),
'borerøra': ('borerør',),
'borerørene': ('borerør',),
'boresikringsventil': ('boresikringsventil',),
'boresikringsventilen': ('boresikringsventil',),
'boresikringsventiler': ('boresikringsventil',),
'boresikringsventilene': ('boresikringsventil',),
'boreskip': ('boreskip',),
'boreskipet': ('boreskip',),
'boreskip': ('boreskip',),
'boreskipa': ('boreskip',),
'boreskipene': ('boreskip',),
'boreslam': ('boreslam',),
'boreslammet': ('boreslam',),
'boreslam': ('boreslam',),
'boreslamma': ('boreslam',),
'boreslammene': ('boreslam',),
'borestart': ('borestart',),
'borestarten': ('borestart',),
'borestarter': ('borestart',),
'borestartene': ('borestart',),
'borestreng': ('borestreng',),
'borestrengen': ('borestreng',),
'borestrenger': ('borestreng',),
'borestrengene': ('borestreng',),
'borettslag': ('borettslag',),
'borettslaget': ('borettslag',),
'borettslag': ('borettslag',),
'borettslaga': ('borettslag',),
'borettslagene': ('borettslag',),
'boretårn': ('boretårn',),
'boretårnet': ('boretårn',),
'boretårn': ('boretårn',),
'boretårna': ('boretårn',),
'boretårnene': ('boretårn',),
'borg': ('borg',),
'borgen': ('borg',),
'borga': ('borg',),
'borger': ('borg',),
'borgene': ('borg',),
'borg': ('borg',),
'borger': ('borger',),
'borgeren': ('borger',),
'borgere': ('borger',),
'borgerne': ('borger',),
'borgerbrev': ('borgerbrev',),
'borgerbrevet': ('borgerbrev',),
'borgerbrev': ('borgerbrev',),
'borgerbrever': ('borgerbrev',),
'borgerbrev': ('borgerbrev',),
'borgerbrever': ('borgerbrev',),
'borgerbreva': ('borgerbrev',),
'borgerbrevene': ('borgerbrev',),
'borgerdåd': ('borgerdåd',),
'borgerdåden': ('borgerdåd',),
'borgerdåder': ('borgerdåd',),
'borgerdådene': ('borgerdåd',),
'borgerdådsmedalje': ('borgerdådsmedalje',),
'borgerdådsmedaljen': ('borgerdådsmedalje',),
'borgerdådsmedaljer': ('borgerdådsmedalje',),
'borgerdådsmedaljene': ('borgerdådsmedalje',),
'borgerkrig': ('borgerkrig',),
'borgerkrigen': ('borgerkrig',),
'borgerkriger': ('borgerkrig',),
'borgerkrigene': ('borgerkrig',),
'borgerkrigstilstand': ('borgerkrigstilstand',),
'borgerkrigstilstanden': ('borgerkrigstilstand',),
'borgerkrigstilstander': ('borgerkrigstilstand',),
'borgerkrigstilstandene': ('borgerkrigstilstand',),
'borgermester': ('borgermester',),
'borgermesteren': ('borgermester',),
'borgermestere': ('borgermester',),
'borgermestrer': ('borgermester',),
'borgermestre': ('borgermester',),
'borgermesterne': ('borgermester',),
'borgermestrene': ('borgermester',),
'borgerplikt': ('borgerplikt',),
'borgerplikten': ('borgerplikt',),
'borgerplikta': ('borgerplikt',),
'borgerplikter': ('borgerplikt',),
'borgerpliktene': ('borgerplikt',),
'borgerrett': ('borgerrett',),
'borgerretten': ('borgerrett',),
'borgerretter': ('borgerrett',),
'borgerrettene': ('borgerrett',),
'borgerrettsbevegelse': ('borgerrettsbevegelse',),
'borgerrettsbevegelsen': ('borgerrettsbevegelse',),
'borgerrettsbevegelser': ('borgerrettsbevegelse',),
'borgerrettsbevegelsene': ('borgerrettsbevegelse',),
'borgerskap': ('borgerskap',),
'borgerskapet': ('borgerskap',),
'borgerskap': ('borgerskap',),
'borgerskapa': ('borgerskap',),
'borgerskapene': ('borgerskap',),
'borgertog': ('borgertog',),
'borgertoget': ('borgertog',),
'borgertog': ('borgertog',),
'borgertoga': ('borgertog',),
'borgertogene': ('borgertog',),
'borgerånd': ('borgerånd',),
'borgerånden': ('borgerånd',),
'borgerånder': ('borgerånd',),
'borgeråndene': ('borgerånd',),
'borgfred': ('borgfred',),
'borgfreden': ('borgfred',),
'borgfreder': ('borgfred',),
'borgfredene': ('borgfred',),
'borgis': ('borgis',),
'borgisen': ('borgis',),
'borgiser': ('borgis',),
'borgisene': ('borgis',),
'borgruin': ('borgruin',),
'borgruinen': ('borgruin',),
'borgruiner': ('borgruin',),
'borgruinene': ('borgruin',),
'borgstue': ('borgstue',),
'borgstuen': ('borgstue',),
'borgstua': ('borgstue',),
'borgstuer': ('borgstue',),
'borgstuene': ('borgstue',),
'boring': ('boring',),
'boringen': ('boring',),
'boringa': ('boring',),
'boringer': ('boring',),
'boringene': ('boring',),
'bork': ('bork',),
'borken': ('bork',),
'borker': ('bork',),
'borkene': ('bork',),
'borkrone': ('borkrone',),
'borkronen': ('borkrone',),
'borkrona': ('borkrone',),
'borkroner': ('borkrone',),
'borkronene': ('borkrone',),
'borre': ('borre',),
'borren': ('borre',),
'borrer': ('borre',),
'borrene': ('borre',),
'borre': ('borre',),
'borren': ('borre',),
'borra': ('borre',),
'borrer': ('borre',),
'borrene': ('borre',),
'borrelås': ('borrelås',),
'borrelåsen': ('borrelås',),
'borrelåset': ('borrelås',),
'borrelåser': ('borrelås',),
'borrelås': ('borrelås',),
'borrelåser': ('borrelås',),
'borrelås': ('borrelås',),
'borrelåser': ('borrelås',),
'borrelåsene': ('borrelås',),
'borrelåsa': ('borrelås',),
'borrelåsene': ('borrelås',),
'borsj': ('borsj',),
'borsjen': ('borsj',),
'borsjer': ('borsj',),
'borsjene': ('borsj',),
'borsyre': ('borsyre',),
'borsyren': ('borsyre',),
'borsyra': ('borsyre',),
'borsyrer': ('borsyre',),
'borsyrene': ('borsyre',),
'bortebane': ('bortebane',),
'bortebanen': ('bortebane',),
'bortebaner': ('bortebane',),
'bortebanene': ('bortebane',),
'borteboer': ('borteboer',),
'borteboeren': ('borteboer',),
'borteboere': ('borteboer',),
'borteboerne': ('borteboer',),
'borteboerstipend': ('borteboerstipend',),
'borteboerstipendet': ('borteboerstipend',),
'borteboerstipend': ('borteboerstipend',),
'borteboerstipender': ('borteboerstipend',),
'borteboerstipend': ('borteboerstipend',),
'borteboerstipender': ('borteboerstipend',),
'borteboerstipenda': ('borteboerstipend',),
'borteboerstipendene': ('borteboerstipend',),
'borteboerstipendium': ('borteboerstipendium',),
'borteboerstipendiet': ('borteboerstipendium',),
'borteboerstipendier': ('borteboerstipendium',),
'borteboerstipendia': ('borteboerstipendium',),
'borteboerstipendiene': ('borteboerstipendium',),
'bortebuer': ('bortebuer',),
'bortebueren': ('bortebuer',),
'bortebuere': ('bortebuer',),
'bortebuerne': ('bortebuer',),
'bortebuerstipend': ('bortebuerstipend',),
'bortebuerstipendet': ('bortebuerstipend',),
'bortebuerstipend': ('bortebuerstipend',),
'bortebuerstipender': ('bortebuerstipend',),
'bortebuerstipend': ('bortebuerstipend',),
'bortebuerstipender': ('bortebuerstipend',),
'bortebuerstipenda': ('bortebuerstipend',),
'bortebuerstipendene': ('bortebuerstipend',),
'bortebuerstipendium': ('bortebuerstipendium',),
'bortebuerstipendiet': ('bortebuerstipendium',),
'bortebuerstipendier': ('bortebuerstipendium',),
'bortebuerstipendia': ('bortebuerstipendium',),
'bortebuerstipendiene': ('bortebuerstipendium',),
'bortekamp': ('bortekamp',),
'bortekampen': ('bortekamp',),
'bortekamper': ('bortekamp',),
'bortekampene': ('bortekamp',),
'bortfall': ('bortfall',),
'bortfallet': ('bortfall',),
'bortfall': ('bortfall',),
'bortfalla': ('bortfall',),
'bortfallene': ('bortfall',),
'bortgang': ('bortgang',),
'bortgangen': ('bortgang',),
'bortganger': ('bortgang',),
'bortgangene': ('bortgang',),
'bortleie': ('bortleie',),
'bortleien': ('bortleie',),
'bortleia': ('bortleie',),
'bortleier': ('bortleie',),
'bortleiene': ('bortleie',),
'borvann': ('borvann',),
'borvannet': ('borvann',),
'borvann': ('borvann',),
'borvanna': ('borvann',),
'borvannene': ('borvann',),
'borvaselin': ('borvaselin',),
'borvaselinen': ('borvaselin',),
'borvaseliner': ('borvaselin',),
'borvaselinene': ('borvaselin',),
'borvatn': ('borvatn',),
'borvatnet': ('borvatn',),
'borvatn': ('borvatn',),
'borvatna': ('borvatn',),
'borvatnene': ('borvatn',),
'borvinde': ('borvinde',),
'borvinden': ('borvinde',),
'borvinda': ('borvinde',),
'borvinder': ('borvinde',),
'borvindene': ('borvinde',),
'bosetning': ('bosetning',),
'bosetningen': ('bosetning',),
'bosetninga': ('bosetning',),
'bosetninger': ('bosetning',),
'bosetningene': ('bosetning',),
'bosetningskart': ('bosetningskart',),
'bosetningskartet': ('bosetningskart',),
'bosetningskart': ('bosetningskart',),
'bosetningskarter': ('bosetningskart',),
'bosetningskart': ('bosetningskart',),
'bosetningskarter': ('bosetningskart',),
'bosetningskarta': ('bosetningskart',),
'bosetningskartene': ('bosetningskart',),
'bosetningsmønster': ('bosetningsmønster',),
'bosetningsmønsteret': ('bosetningsmønster',),
'bosetningsmønstret': ('bosetningsmønster',),
'bosetningsmønster': ('bosetningsmønster',),
'bosetningsmønstre': ('bosetningsmønster',),
'bosetningsmønstra': ('bosetningsmønster',),
'bosetningsmønstrene': ('bosetningsmønster',),
'bosetningsmønstra': ('bosetningsmønster',),
'bosetningsmønstrene': ('bosetningsmønster',),
'bosetting': ('bosetting',),
'bosettingen': ('bosetting',),
'bosettinga': ('bosetting',),
'bosettinger': ('bosetting',),
'bosettingene': ('bosetting',),
'bosettingskart': ('bosettingskart',),
'bosettingskartet': ('bosettingskart',),
'bosettingskart': ('bosettingskart',),
'bosettingskarter': ('bosettingskart',),
'bosettingskart': ('bosettingskart',),
'bosettingskarter': ('bosettingskart',),
'bosettingskarta': ('bosettingskart',),
'bosettingskartene': ('bosettingskart',),
'bosettingsmønster': ('bosettingsmønster',),
'bosettingsmønsteret': ('bosettingsmønster',),
'bosettingsmønstret': ('bosettingsmønster',),
'bosettingsmønster': ('bosettingsmønster',),
'bosettingsmønstre': ('bosettingsmønster',),
'bosettingsmønstra': ('bosettingsmønster',),
'bosettingsmønstrene': ('bosettingsmønster',),
'bosettingsmønstra': ('bosettingsmønster',),
'bosettingsmønstrene': ('bosettingsmønster',),
'boslodd': ('boslodd',),
'boslodden': ('boslodd',),
'boslodder': ('boslodd',),
'bosloddene': ('boslodd',),
'bosnier': ('bosnier',),
'bosnieren': ('bosnier',),
'bosniere': ('bosnier',),
'bosnierne': ('bosnier',),
'boss': ('boss',),
'bossen': ('boss',),
'bosser': ('boss',),
'bossene': ('boss',),
'boss': ('boss',),
'bosset': ('boss',),
'boss': ('boss',),
'bossa': ('boss',),
'bossene': ('boss',),
'bosted': ('bosted',),
'bostedet': ('bosted',),
'bosteder': ('bosted',),
'bostedene': ('bosted',),
'bostedsadresse': ('bostedsadresse',),
'bostedsadressen': ('bostedsadresse',),
'bostedsadressa': ('bostedsadresse',),
'bostedsadresser': ('bostedsadresse',),
'bostedsadressene': ('bostedsadresse',),
'bostedskommune': ('bostedskommune',),
'bostedskommunen': ('bostedskommune',),
'bostedskommuner': ('bostedskommune',),
'bostedskommunene': ('bostedskommune',),
'boston': ('boston',),
'bostonen': ('boston',),
'bostoner': ('boston',),
'bostonene': ('boston',),
'bostyre': ('bostyre',),
'bostyret': ('bostyre',),
'bostyrer': ('bostyre',),
'bostyra': ('bostyre',),
'bostyrene': ('bostyre',),
'bostyrer': ('bostyrer',),
'bostyreren': ('bostyrer',),
'bostyrere': ('bostyrer',),
'bostyrerne': ('bostyrer',),
'bostøtte': ('bostøtte',),
'bostøtten': ('bostøtte',),
'bostøtta': ('bostøtte',),
'bostøtter': ('bostøtte',),
'bostøttene': ('bostøtte',),
'bot': ('bot',),
'boten': ('bot',),
'bota': ('bot',),
'bøter': ('bot',),
'bøtene': ('bot',),
'botaniker': ('botaniker',),
'botanikeren': ('botaniker',),
'botanikere': ('botaniker',),
'botanikerne': ('botaniker',),
'botanikk': ('botanikk',),
'botanikken': ('botanikk',),
'botanikker': ('botanikk',),
'botanikkene': ('botanikk',),
'botemiddel': ('botemiddel',),
'botemiddelet': ('botemiddel',),
'botemidlet': ('botemiddel',),
'botemiddel': ('botemiddel',),
'botemidler': ('botemiddel',),
'botemidla': ('botemiddel',),
'botemidlene': ('botemiddel',),
'botemidla': ('botemiddel',),
'botemidlene': ('botemiddel',),
'botevon': ('botevon',),
'botevonen': ('botevon',),
'botevona': ('botevon',),
'botevoner': ('botevon',),
'botevonene': ('botevon',),
'botfor': ('botfor',),
'botforen': ('botfor',),
'botforer': ('botfor',),
'botforene': ('botfor',),
'botid': ('botid',),
'botiden': ('botid',),
'botida': ('botid',),
'botider': ('botid',),
'botidene': ('botid',),
'botn': ('botn',),
'botnen': ('botn',),
'botner': ('botn',),
'botnene': ('botn',),
'botnband': ('botnband',),
'botnbandet': ('botnband',),
'botnband': ('botnband',),
'botnbanda': ('botnband',),
'botnbandene': ('botnband',),
'botnbord': ('botnbord',),
'botnbordet': ('botnbord',),
'botnbord': ('botnbord',),
'botnborder': ('botnbord',),
'botnbord': ('botnbord',),
'botnborder': ('botnbord',),
'botnborda': ('botnbord',),
'botnbordene': ('botnbord',),
'botnbånd': ('botnbånd',),
'botnbåndet': ('botnbånd',),
'botnbånd': ('botnbånd',),
'botnbånda': ('botnbånd',),
'botnbåndene': ('botnbånd',),
'botnfall': ('botnfall',),
'botnfallet': ('botnfall',),
'botnfall': ('botnfall',),
'botnfalla': ('botnfall',),
'botnfallene': ('botnfall',),
'botnfisk': ('botnfisk',),
'botnfisken': ('botnfisk',),
'botnfisker': ('botnfisk',),
'botnfiskene': ('botnfisk',),
'botnflate': ('botnflate',),
'botnflaten': ('botnflate',),
'botnflata': ('botnflate',),
'botnflater': ('botnflate',),
'botnflatene': ('botnflate',),
'botnlag': ('botnlag',),
'botnlaget': ('botnlag',),
'botnlag': ('botnlag',),
'botnlaga': ('botnlag',),
'botnlagene': ('botnlag',),
'botnløshet': ('botnløshet',),
'botnløsheten': ('botnløshet',),
'botnløsheta': ('botnløshet',),
'botnløsheter': ('botnløshet',),
'botnløshetene': ('botnløshet',),
'botnløyse': ('botnløyse',),
'botnløysen': ('botnløyse',),
'botnløysa': ('botnløyse',),
'botnløyser': ('botnløyse',),
'botnløysene': ('botnløyse',),
'botnmorene': ('botnmorene',),
'botnmorenen': ('botnmorene',),
'botnmorener': ('botnmorene',),
'botnmorenene': ('botnmorene',),
'botnnivå': ('botnnivå',),
'botnnivået': ('botnnivå',),
'botnnivå': ('botnnivå',),
'botnnivåer': ('botnnivå',),
'botnnivå': ('botnnivå',),
'botnnivåer': ('botnnivå',),
'botnnivåa': ('botnnivå',),
'botnnivåene': ('botnnivå',),
'botnpanne': ('botnpanne',),
'botnpannen': ('botnpanne',),
'botnpanna': ('botnpanne',),
'botnpanner': ('botnpanne',),
'botnpannene': ('botnpanne',),
'botnrekord': ('botnrekord',),
'botnrekorden': ('botnrekord',),
'botnrekorder': ('botnrekord',),
'botnrekordene': ('botnrekord',),
'botnstoff': ('botnstoff',),
'botnstoffet': ('botnstoff',),
'botnstoff': ('botnstoff',),
'botnstoffer': ('botnstoff',),
'botnstoff': ('botnstoff',),
'botnstoffer': ('botnstoff',),
'botnstoffa': ('botnstoff',),
'botnstoffene': ('botnstoff',),
'botnstrid': ('botnstrid',),
'botnstriden': ('botnstrid',),
'botnstrider': ('botnstrid',),
'botnstridene': ('botnstrid',),
'botolvsmess': ('botolvsmess',),
'botolvsmessen': ('botolvsmess',),
'botolvsmessa': ('botolvsmess',),
'botolvsmesser': ('botolvsmess',),
'botolvsmessene': ('botolvsmess',),
'botolvsmesse': ('botolvsmesse',),
'botolvsmessen': ('botolvsmesse',),
'botolvsmessa': ('botolvsmesse',),
'botolvsmesser': ('botolvsmesse',),
'botolvsmessene': ('botolvsmesse',),
'botsbenk': ('botsbenk',),
'botsbenken': ('botsbenk',),
'botsbenker': ('botsbenk',),
'botsbenkene': ('botsbenk',),
'botsdag': ('botsdag',),
'botsdagen': ('botsdag',),
'botsdager': ('botsdag',),
'botsdagene': ('botsdag',),
'botsfengsel': ('botsfengsel',),
'botsfengselet': ('botsfengsel',),
'botsfengslet': ('botsfengsel',),
'botsfengsel': ('botsfengsel',),
'botsfengsler': ('botsfengsel',),
'botsfengsla': ('botsfengsel',),
'botsfengslene': ('botsfengsel',),
'botsfengsla': ('botsfengsel',),
'botsfengslene': ('botsfengsel',),
'botsgang': ('botsgang',),
'botsgangen': ('botsgang',),
'botsganger': ('botsgang',),
'botsgangene': ('botsgang',),
'botssakrament': ('botssakrament',),
'botssakramentet': ('botssakrament',),
'botssakrament': ('botssakrament',),
'botssakramenter': ('botssakrament',),
'botssakrament': ('botssakrament',),
'botssakramenter': ('botssakrament',),
'botssakramenta': ('botssakrament',),
'botssakramentene': ('botssakrament',),
'botssalme': ('botssalme',),
'botssalmen': ('botssalme',),
'botssalmer': ('botssalme',),
'botssalmene': ('botssalme',),
'botswaner': ('botswaner',),
'botswaneren': ('botswaner',),
'botswanere': ('botswaner',),
'botswanerne': ('botswaner',),
'botsøvelse': ('botsøvelse',),
'botsøvelsen': ('botsøvelse',),
'botsøvelser': ('botsøvelse',),
'botsøvelsene': ('botsøvelse',),
'botsøving': ('botsøving',),
'botsøvingen': ('botsøving',),
'botsøvinga': ('botsøving',),
'botsøvinger': ('botsøving',),
'botsøvingene': ('botsøving',),
'bott': ('bott',),
'bottlenose': ('bottlenose',),
'bottlenosen': ('bottlenose',),
'bottlenoser': ('bottlenose',),
'bottlenosene': ('bottlenose',),
'botulisme': ('botulisme',),
'botulismen': ('botulisme',),
'botulismer': ('botulisme',),
'botulismene': ('botulisme',),
'bouclé': ('bouclé',),
'boucléen': ('bouclé',),
'boucleen': ('bouclé',),
'boucleet': ('bouclé',),
'boucléer': ('bouclé',),
'boucleer': ('bouclé',),
'bouclé': ('bouclé',),
'boucléene': ('bouclé',),
'boucleene': ('bouclé',),
'bouclea': ('bouclé',),
'boucleene': ('bouclé',),
'bouclégarn': ('bouclégarn',),
'bouclégarnet': ('bouclégarn',),
'bouclégarn': ('bouclégarn',),
'bouclégarna': ('bouclégarn',),
'bouclégarnene': ('bouclégarn',),
'boucléteppe': ('boucléteppe',),
'boucléteppet': ('boucléteppe',),
'bouclétepper': ('boucléteppe',),
'boucléteppa': ('boucléteppe',),
'boucléteppene': ('boucléteppe',),
'bouillabaisse': ('bouillabaisse',),
'bouillabaissen': ('bouillabaisse',),
'bouillabaisser': ('bouillabaisse',),
'bouillabaissene': ('bouillabaisse',),
'bouquet': ('bouquet',),
'bouqueten': ('bouquet',),
'bouqueter': ('bouquet',),
'bouquetene': ('bouquet',),
'bourgeois': ('bourgeois',),
'bourgeoisen': ('bourgeois',),
'bourgeoiser': ('bourgeois',),
'bourgeoisene': ('bourgeois',),
'bourgeoisi': ('bourgeoisi',),
'bourgeoisiet': ('bourgeoisi',),
'bourgeoisi': ('bourgeoisi',),
'bourgeoisier': ('bourgeoisi',),
'bourgeoisi': ('bourgeoisi',),
'bourgeoisier': ('bourgeoisi',),
'bourgeoisia': ('bourgeoisi',),
'bourgeoisiene': ('bourgeoisi',),
'bouzouki': ('bouzouki',),
'bouzoukien': ('bouzouki',),
'bouzoukier': ('bouzouki',),
'bouzoukiene': ('bouzouki',),
'bovenbramsegl': ('bovenbramsegl',),
'bovenbramseglet': ('bovenbramsegl',),
'bovenbramsegl': ('bovenbramsegl',),
'bovenbramsegla': ('bovenbramsegl',),
'bovenbramseglene': ('bovenbramsegl',),
'bovenbramseil': ('bovenbramseil',),
'bovenbramseilet': ('bovenbramseil',),
'bovenbramseil': ('bovenbramseil',),
'bovenbramseila': ('bovenbramseil',),
'bovenbramseilene': ('bovenbramseil',),
'bovenvekt': ('bovenvekt',),
'bovenvekten': ('bovenvekt',),
'bovenvekta': ('bovenvekt',),
'bovenvekter': ('bovenvekt',),
'bovenvektene': ('bovenvekt',),
'bow': ('bow',),
'bowen': ('bow',),
'bower': ('bow',),
'bowene': ('bow',),
'bowl': ('bowl',),
'bowlen': ('bowl',),
'bowler': ('bowl',),
'bowlene': ('bowl',),
'bowle': ('bowle',),
'bowlen': ('bowle',),
'bowler': ('bowle',),
'bowlene': ('bowle',),
'bowler': ('bowler',),
'bowleren': ('bowler',),
'bowlere': ('bowler',),
'bowlerne': ('bowler',),
'bowlerhatt': ('bowlerhatt',),
'bowlerhatten': ('bowlerhatt',),
'bowlerhatter': ('bowlerhatt',),
'bowlerhattene': ('bowlerhatt',),
'bowling': ('bowling',),
'bowlingen': ('bowling',),
'bowlinga': ('bowling',),
'bowlinger': ('bowling',),
'bowlingene': ('bowling',),
'bowlingbane': ('bowlingbane',),
'bowlingbanen': ('bowlingbane',),
'bowlingbaner': ('bowlingbane',),
'bowlingbanene': ('bowlingbane',),
'bowlinghall': ('bowlinghall',),
'bowlinghallen': ('bowlinghall',),
'bowlinghaller': ('bowlinghall',),
'bowlinghallene': ('bowlinghall',),
'bowlingkule': ('bowlingkule',),
'bowlingkulen': ('bowlingkule',),
'bowlingkula': ('bowlingkule',),
'bowlingkuler': ('bowlingkule',),
'bowlingkulene': ('bowlingkule',),
'bowlingspeller': ('bowlingspeller',),
'bowlingspelleren': ('bowlingspeller',),
'bowlingspellere': ('bowlingspeller',),
'bowlingspellerne': ('bowlingspeller',),
'bowlingspiller': ('bowlingspiller',),
'bowlingspilleren': ('bowlingspiller',),
'bowlingspillere': ('bowlingspiller',),
'bowlingspillerne': ('bowlingspiller',),
'boy': ('boy',),
'boyen': ('boy',),
'boyer': ('boy',),
'boyene': ('boy',),
'boysenbær': ('boysenbær',),
'boysenbæret': ('boysenbær',),
'boysenbær': ('boysenbær',),
'boysenbæra': ('boysenbær',),
'boysenbærene': ('boysenbær',),
'brachiopod': ('brachiopod',),
'brachiopoden': ('brachiopod',),
'brachiopoder': ('brachiopod',),
'brachiopodene': ('brachiopod',),
'bragd': ('bragd',),
'bragden': ('bragd',),
'bragda': ('bragd',),
'bragder': ('bragd',),
'bragdene': ('bragd',),
'brageløfte': ('brageløfte',),
'brageløftet': ('brageløfte',),
'brageløfter': ('brageløfte',),
'brageløfta': ('brageløfte',),
'brageløftene': ('brageløfte',),
'braille': ('braille',),
'braillen': ('braille',),
'brailler': ('braille',),
'braillene': ('braille',),
'brailleskrift': ('brailleskrift',),
'brailleskriften': ('brailleskrift',),
'brailleskrifta': ('brailleskrift',),
'brailleskrifter': ('brailleskrift',),
'brailleskriftene': ('brailleskrift',),
'brak': ('brak',),
'braket': ('brak',),
'brak': ('brak',),
'braka': ('brak',),
'brakene': ('brak',),
'brakar': ('brakar',),
'brakaren': ('brakar',),
'brakarer': ('brakar',),
'brakarene': ('brakar',),
'brakett': ('brakett',),
'braketten': ('brakett',),
'braketter': ('brakett',),
'brakettene': ('brakett',),
'brakk': ('brakk',),
'brakken': ('brakk',),
'brakker': ('brakk',),
'brakkene': ('brakk',),
'brakke': ('brakke',),
'brakken': ('brakke',),
'brakka': ('brakke',),
'brakker': ('brakke',),
'brakkene': ('brakke',),
'brakkebaron': ('brakkebaron',),
'brakkebaronen': ('brakkebaron',),
'brakkebaroner': ('brakkebaron',),
'brakkebaronene': ('brakkebaron',),
'brakkeboer': ('brakkeboer',),
'brakkeboeren': ('brakkeboer',),
'brakkeboere': ('brakkeboer',),
'brakkeboerne': ('brakkeboer',),
'brakkebuer': ('brakkebuer',),
'brakkebueren': ('brakkebuer',),
'brakkebuere': ('brakkebuer',),
'brakkebuerne': ('brakkebuer',),
'brakkeby': ('brakkeby',),
'brakkebyen': ('brakkeby',),
'brakkebyer': ('brakkeby',),
'brakkebyene': ('brakkeby',),
'brakkesjef': ('brakkesjef',),
'brakkesjefen': ('brakkesjef',),
'brakkesjefer': ('brakkesjef',),
'brakkesjefene': ('brakkesjef',),
'brakkjord': ('brakkjord',),
'brakkjorden': ('brakkjord',),
'brakkjorda': ('brakkjord',),
'brakkjorder': ('brakkjord',),
'brakkjordene': ('brakkjord',),
'brakkland': ('brakkland',),
'brakklandet': ('brakkland',),
'brakkland': ('brakkland',),
'brakklanda': ('brakkland',),
'brakklandene': ('brakkland',),
'brakkmark': ('brakkmark',),
'brakkmarken': ('brakkmark',),
'brakkmarka': ('brakkmark',),
'brakkmarker': ('brakkmark',),
'brakkmarkene': ('brakkmark',),
'brakknese': ('brakknese',),
'brakknesen': ('brakknese',),
'brakknesa': ('brakknese',),
'brakkneser': ('brakknese',),
'brakknesene': ('brakknese',),
'brakkvann': ('brakkvann',),
'brakkvannet': ('brakkvann',),
'brakkvann': ('brakkvann',),
'brakkvanna': ('brakkvann',),
'brakkvannene': ('brakkvann',),
'brakkvatn': ('brakkvatn',),
'brakkvatnet': ('brakkvatn',),
'brakkvatn': ('brakkvatn',),
'brakkvatna': ('brakkvatn',),
'brakkvatnene': ('brakkvatn',),
'braknederlag': ('braknederlag',),
'braknederlaget': ('braknederlag',),
'braknederlag': ('braknederlag',),
'braknederlaga': ('braknederlag',),
'braknederlagene': ('braknederlag',),
'brakseier': ('brakseier',),
'brakseieren': ('brakseier',),
'brakseiere': ('brakseier',),
'brakseirer': ('brakseier',),
'brakseire': ('brakseier',),
'brakseierne': ('brakseier',),
'brakseirene': ('brakseier',),
'braktap': ('braktap',),
'braktapet': ('braktap',),
'braktap': ('braktap',),
'braktapa': ('braktap',),
'braktapene': ('braktap',),
'brakteat': ('brakteat',),
'brakteaten': ('brakteat',),
'brakteater': ('brakteat',),
'brakteatene': ('brakteat',),
'bram': ('bram',),
'bramaisme': ('bramaisme',),
'bramaismen': ('bramaisme',),
'bramaismer': ('bramaisme',),
'bramaismene': ('bramaisme',),
'braman': ('braman',),
'bramanen': ('braman',),
'bramaner': ('braman',),
'bramanene': ('braman',),
'bramanisme': ('bramanisme',),
'bramanismen': ('bramanisme',),
'bramanismer': ('bramanisme',),
'bramanismene': ('bramanisme',),
'bramin': ('bramin',),
'braminen': ('bramin',),
'braminer': ('bramin',),
'braminene': ('bramin',),
'bramsegl': ('bramsegl',),
'bramseglet': ('bramsegl',),
'bramsegl': ('bramsegl',),
'bramsegla': ('bramsegl',),
'bramseglene': ('bramsegl',),
'bramseil': ('bramseil',),
'bramseilet': ('bramseil',),
'bramseil': ('bramseil',),
'bramseila': ('bramseil',),
'bramseilene': ('bramseil',),
'bramstang': ('bramstang',),
'bramstangen': ('bramstang',),
'bramstanga': ('bramstang',),
'bramstenger': ('bramstang',),
'bramstengene': ('bramstang',),
'brand': ('brand',),
'branden': ('brand',),
'brander': ('brand',),
'brandene': ('brand',),
'brande': ('brande',),
'branden': ('brande',),
'brander': ('brande',),
'brandene': ('brande',),
'brander': ('brander',),
'branderen': ('brander',),
'brandere': ('brander',),
'branderne': ('brander',),
'brandy': ('brandy',),
'brandyen': ('brandy',),
'brandyer': ('brandy',),
'brandyene': ('brandy',),
'brann': ('brann',),
'brannen': ('brann',),
'branner': ('brann',),
'brannene': ('brann',),
'brannalarm': ('brannalarm',),
'brannalarmen': ('brannalarm',),
'brannalarmer': ('brannalarm',),
'brannalarmene': ('brannalarm',),
'brannbil': ('brannbil',),
'brannbilen': ('brannbil',),
'brannbiler': ('brannbil',),
'brannbilene': ('brannbil',),
'brannbombe': ('brannbombe',),
'brannbomben': ('brannbombe',),
'brannbomba': ('brannbombe',),
'brannbomber': ('brannbombe',),
'brannbombene': ('brannbombe',),
'branndør': ('branndør',),
'branndøren': ('branndør',),
'branndøra': ('branndør',),
'branndører': ('branndør',),
'branndørene': ('branndør',),
'brannfakkel': ('brannfakkel',),
'brannfakkelen': ('brannfakkel',),
'brannfakler': ('brannfakkel',),
'brannfaklene': ('brannfakkel',),
'brannforsikring': ('brannforsikring',),
'brannforsikringen': ('brannforsikring',),
'brannforsikringa': ('brannforsikring',),
'brannforsikringer': ('brannforsikring',),
'brannforsikringene': ('brannforsikring',),
'branngate': ('branngate',),
'branngaten': ('branngate',),
'branngata': ('branngate',),
'branngater': ('branngate',),
'branngatene': ('branngate',),
'branngavl': ('branngavl',),
'branngavlen': ('branngavl',),
'branngavler': ('branngavl',),
'branngavlene': ('branngavl',),
'branngranat': ('branngranat',),
'branngranaten': ('branngranat',),
'branngranater': ('branngranat',),
'branngranatene': ('branngranat',),
'branninstruks': ('branninstruks',),
'branninstruksen': ('branninstruks',),
'branninstrukser': ('branninstruks',),
'branninstruksene': ('branninstruks',),
'brannkasse': ('brannkasse',),
'brannkassen': ('brannkasse',),
'brannkassa': ('brannkasse',),
'brannkasser': ('brannkasse',),
'brannkassene': ('brannkasse',),
'brannkorps': ('brannkorps',),
'brannkorpset': ('brannkorps',),
'brannkorps': ('brannkorps',),
'brannkorpsa': ('brannkorps',),
'brannkorpsene': ('brannkorps',),
'brannlilje': ('brannlilje',),
'brannliljen': ('brannlilje',),
'brannlilja': ('brannlilje',),
'brannliljer': ('brannlilje',),
'brannliljene': ('brannlilje',),
'brannmann': ('brannmann',),
'brannmannen': ('brannmann',),
'brannmenn': ('brannmann',),
'brannmennene': ('brannmann',),
'brannmannskap': ('brannmannskap',),
'brannmannskapet': ('brannmannskap',),
'brannmannskap': ('brannmannskap',),
'brannmannskaper': ('brannmannskap',),
'brannmannskap': ('brannmannskap',),
'brannmannskaper': ('brannmannskap',),
'brannmannskapa': ('brannmannskap',),
'brannmannskapene': ('brannmannskap',),
'brannmannsløft': ('brannmannsløft',),
'brannmannsløftet': ('brannmannsløft',),
'brannmannsløft': ('brannmannsløft',),
'brannmannsløfta': ('brannmannsløft',),
'brannmannsløftene': ('brannmannsløft',),
'brannmester': ('brannmester',),
'brannmesteren': ('brannmester',),
'brannmestere': ('brannmester',),
'brannmestrer': ('brannmester',),
'brannmestre': ('brannmester',),
'brannmesterne': ('brannmester',),
'brannmestrene': ('brannmester',),
'brannmur': ('brannmur',),
'brannmuren': ('brannmur',),
'brannmurer': ('brannmur',),
'brannmurene': ('brannmur',),
'brannrør': ('brannrør',),
'brannrøret': ('brannrør',),
'brannrør': ('brannrør',),
'brannrøra': ('brannrør',),
'brannrørene': ('brannrør',),
'brannsalve': ('brannsalve',),
'brannsalven': ('brannsalve',),
'brannsalva': ('brannsalve',),
'brannsalver': ('brannsalve',),
'brannsalvene': ('brannsalve',),
'brannsikring': ('brannsikring',),
'brannsikringen': ('brannsikring',),
'brannsikringa': ('brannsikring',),
'brannsikringer': ('brannsikring',),
'brannsikringene': ('brannsikring',),
'brannsirene': ('brannsirene',),
'brannsirenen': ('brannsirene',),
'brannsirena': ('brannsirene',),
'brannsirener': ('brannsirene',),
'brannsirenene': ('brannsirene',),
'brannskade': ('brannskade',),
'brannskaden': ('brannskade',),
'brannskader': ('brannskade',),
'brannskadene': ('brannskade',),
'brannskadetakst': ('brannskadetakst',),
'brannskadetaksten': ('brannskadetakst',),
'brannskadetakster': ('brannskadetakst',),
'brannskadetakstene': ('brannskadetakst',),
'brannslange': ('brannslange',),
'brannslangen': ('brannslange',),
'brannslanger': ('brannslange',),
'brannslangene': ('brannslange',),
'brannslokking': ('brannslokking',),
'brannslokkingen': ('brannslokking',),
'brannslokkinga': ('brannslokking',),
'brannslokkinger': ('brannslokking',),
'brannslokkingene': ('brannslokking',),
'brannslokkingsapparat': ('brannslokkingsapparat',),
'brannslokkingsapparatet': ('brannslokkingsapparat',),
'brannslokkingsapparat': ('brannslokkingsapparat',),
'brannslokkingsapparater': ('brannslokkingsapparat',),
'brannslokkingsapparat': ('brannslokkingsapparat',),
'brannslokkingsapparater': ('brannslokkingsapparat',),
'brannslokkingsapparata': ('brannslokkingsapparat',),
'brannslokkingsapparatene': ('brannslokkingsapparat',),
'brannslokning': ('brannslokning',),
'brannslokningen': ('brannslokning',),
'brannslokninga': ('brannslokning',),
'brannslokninger': ('brannslokning',),
'brannslokningene': ('brannslokning',),
'brannslokningsapparat': ('brannslokningsapparat',),
'brannslokningsapparatet': ('brannslokningsapparat',),
'brannslokningsapparat': ('brannslokningsapparat',),
'brannslokningsapparater': ('brannslokningsapparat',),
'brannslokningsapparat': ('brannslokningsapparat',),
'brannslokningsapparater': ('brannslokningsapparat',),
'brannslokningsapparata': ('brannslokningsapparat',),
'brannslokningsapparatene': ('brannslokningsapparat',),
'brannslukking': ('brannslukking',),
'brannslukkingen': ('brannslukking',),
'brannslukkinga': ('brannslukking',),
'brannslukkinger': ('brannslukking',),
'brannslukkingene': ('brannslukking',),
'brannslukkingsapparat': ('brannslukkingsapparat',),
'brannslukkingsapparatet': ('brannslukkingsapparat',),
'brannslukkingsapparat': ('brannslukkingsapparat',),
'brannslukkingsapparater': ('brannslukkingsapparat',),
'brannslukkingsapparat': ('brannslukkingsapparat',),
'brannslukkingsapparater': ('brannslukkingsapparat',),
'brannslukkingsapparata': ('brannslukkingsapparat',),
'brannslukkingsapparatene': ('brannslukkingsapparat',),
'brannslukning': ('brannslukning',),
'brannslukningen': ('brannslukning',),
'brannslukninga': ('brannslukning',),
'brannslukninger': ('brannslukning',),
'brannslukningene': ('brannslukning',),
'brannslukningsapparat': ('brannslukningsapparat',),
'brannslukningsapparatet': ('brannslukningsapparat',),
'brannslukningsapparat': ('brannslukningsapparat',),
'brannslukningsapparater': ('brannslukningsapparat',),
'brannslukningsapparat': ('brannslukningsapparat',),
'brannslukningsapparater': ('brannslukningsapparat',),
'brannslukningsapparata': ('brannslukningsapparat',),
'brannslukningsapparatene': ('brannslukningsapparat',),
'brannsperre': ('brannsperre',),
'brannsperren': ('brannsperre',),
'brannsperra': ('brannsperre',),
'brannsperrer': ('brannsperre',),
'brannsperrene': ('brannsperre',),
'brannsprøyte': ('brannsprøyte',),
'brannsprøyten': ('brannsprøyte',),
'brannsprøyta': ('brannsprøyte',),
'brannsprøyter': ('brannsprøyte',),
'brannsprøytene': ('brannsprøyte',),
'brannstasjon': ('brannstasjon',),
'brannstasjonen': ('brannstasjon',),
'brannstasjoner': ('brannstasjon',),
'brannstasjonene': ('brannstasjon',),
'brannsted': ('brannsted',),
'brannstedet': ('brannsted',),
'brannsteder': ('brannsted',),
'brannstedene': ('brannsted',),
'brannstifter': ('brannstifter',),
'brannstifteren': ('brannstifter',),
'brannstiftere': ('brannstifter',),
'brannstifterne': ('brannstifter',),
'brannstige': ('brannstige',),
'brannstigen': ('brannstige',),
'brannstiger': ('brannstige',),
'brannstigene': ('brannstige',),
'brannsår': ('brannsår',),
'brannsåret': ('brannsår',),
'brannsår': ('brannsår',),
'brannsåra': ('brannsår',),
'brannsårene': ('brannsår',),
'branntakst': ('branntakst',),
'branntaksten': ('branntakst',),
'branntakster': ('branntakst',),
'branntakstene': ('branntakst',),
'branntau': ('branntau',),
'branntauet': ('branntau',),
'branntau': ('branntau',),
'branntauer': ('branntau',),
'branntau': ('branntau',),
'branntauer': ('branntau',),
'branntaua': ('branntau',),
'branntauene': ('branntau',),
'branntomt': ('branntomt',),
'branntomten': ('branntomt',),
'branntomta': ('branntomt',),
'branntomter': ('branntomt',),
'branntomtene': ('branntomt',),
'brannutrykning': ('brannutrykning',),
'brannutrykningen': ('brannutrykning',),
'brannutrykninga': ('brannutrykning',),
'brannutrykninger': ('brannutrykning',),
'brannutrykningene': ('brannutrykning',),
'brannvegg': ('brannvegg',),
'brannveggen': ('brannvegg',),
'brannvegger': ('brannvegg',),
'brannveggene': ('brannvegg',),
'brannvern': ('brannvern',),
'brannvernet': ('brannvern',),
'brannvern': ('brannvern',),
'brannverna': ('brannvern',),
'brannvernene': ('brannvern',),
'brannvernforskrift': ('brannvernforskrift',),
'brannvernforskriften': ('brannvernforskrift',),
'brannvernforskrifta': ('brannvernforskrift',),
'brannvernforskrifter': ('brannvernforskrift',),
'brannvernforskriftene': ('brannvernforskrift',),
'brannvesen': ('brannvesen',),
'brannvesenet': ('brannvesen',),
'brannvesen': ('brannvesen',),
'brannvesener': ('brannvesen',),
'brannvesen': ('brannvesen',),
'brannvesener': ('brannvesen',),
'brannvesena': ('brannvesen',),
'brannvesenene': ('brannvesen',),
'brannårsak': ('brannårsak',),
'brannårsaken': ('brannårsak',),
'brannårsaka': ('brannårsak',),
'brannårsaker': ('brannårsak',),
'brannårsakene': ('brannårsak',),
'bransje': ('bransje',),
'bransjen': ('bransje',),
'bransjer': ('bransje',),
'bransjene': ('bransje',),
'bransjeavtale': ('bransjeavtale',),
'bransjeavtalen': ('bransjeavtale',),
'bransjeavtaler': ('bransjeavtale',),
'bransjeavtalene': ('bransjeavtale',),
'bransjeforretning': ('bransjeforretning',),
'bransjeforretningen': ('bransjeforretning',),
'bransjeforretninga': ('bransjeforretning',),
'bransjeforretninger': ('bransjeforretning',),
'bransjeforretningene': ('bransjeforretning',),
'bransjekunnskap': ('bransjekunnskap',),
'bransjekunnskapen': ('bransjekunnskap',),
'bransjekunnskaper': ('bransjekunnskap',),
'bransjekunnskapene': ('bransjekunnskap',),
'bransjeråd': ('bransjeråd',),
'bransjerådet': ('bransjeråd',),
'bransjeråd': ('bransjeråd',),
'bransjeråda': ('bransjeråd',),
'bransjerådene': ('bransjeråd',),
'bras': ('bras',),
'brasen': ('bras',),
'braser': ('bras',),
'brasene': ('bras',),
'bras': ('bras',),
'braset': ('bras',),
'bras': ('bras',),
'brasa': ('bras',),
'brasene': ('bras',),
'brasilianer': ('brasilianer',),
'brasilianeren': ('brasilianer',),
'brasilianere': ('brasilianer',),
'brasilianerne': ('brasilianer',),
'brask': ('brask',),
'brasme': ('brasme',),
'brasmen': ('brasme',),
'brasma': ('brasme',),
'brasmer': ('brasme',),
'brasmene': ('brasme',),
'brass': ('brass',),
'brassen': ('brass',),
'brasser': ('brass',),
'brassene': ('brass',),
'brassband': ('brassband',),
'brassbandet': ('brassband',),
'brassband': ('brassband',),
'brassbanda': ('brassband',),
'brassbandene': ('brassband',),
'brassespark': ('brassespark',),
'brassesparket': ('brassespark',),
'brassespark': ('brassespark',),
'brassesparka': ('brassespark',),
'brassesparkene': ('brassespark',),
'brast': ('brast',),
'bratning': ('bratning',),
'bratningen': ('bratning',),
'bratninga': ('bratning',),
'bratninger': ('bratning',),
'bratningene': ('bratning',),
'bratsj': ('bratsj',),
'bratsjen': ('bratsj',),
'bratsjer': ('bratsj',),
'bratsjene': ('bratsj',),
'bratsjist': ('bratsjist',),
'bratsjisten': ('bratsjist',),
'bratsjister': ('bratsjist',),
'bratsjistene': ('bratsjist',),
'bratte': ('bratte',),
'bratten': ('bratte',),
'bratta': ('bratte',),
'bratter': ('bratte',),
'brattene': ('bratte',),
'brattheng': ('brattheng',),
'bratthenget': ('brattheng',),
'brattheng': ('brattheng',),
'bratthenga': ('brattheng',),
'bratthengene': ('brattheng',),
'brattstup': ('brattstup',),
'brattstupet': ('brattstup',),
'brattstup': ('brattstup',),
'brattstupa': ('brattstup',),
'brattstupene': ('brattstup',),
'brauter': ('brauter',),
'brauteren': ('brauter',),
'brautere': ('brauter',),
'brauterne': ('brauter',),
'bravade': ('bravade',),
'bravaden': ('bravade',),
'bravader': ('bravade',),
'bravadene': ('bravade',),
'bravo': ('bravo',),
'bravoet': ('bravo',),
'bravo': ('bravo',),
'bravoer': ('bravo',),
'bravo': ('bravo',),
'bravoer': ('bravo',),
'bravoa': ('bravo',),
'bravoene': ('bravo',),
'bravorop': ('bravorop',),
'bravoropet': ('bravorop',),
'bravorop': ('bravorop',),
'bravoropa': ('bravorop',),
'bravoropene': ('bravorop',),
'bravur': ('bravur',),
'bravuren': ('bravur',),
'bravurer': ('bravur',),
'bravurene': ('bravur',),
'bravurnummer': ('bravurnummer',),
'bravurnummeret': ('bravurnummer',),
'bravurnummer': ('bravurnummer',),
'bravurnumre': ('bravurnummer',),
'bravurnumra': ('bravurnummer',),
'bravurnumrene': ('bravurnummer',),
'bravurnumra': ('bravurnummer',),
'bravurnumrene': ('bravurnummer',),
'bre': ('bre',),
'breen': ('bre',),
'breer': ('bre',),
'breene': ('bre',),
'bredd': ('bredd',),
'bredden': ('bredd',),
'bredda': ('bredd',),
'bredder': ('bredd',),
'breddene': ('bredd',),
'bredde': ('bredde',),
'bredden': ('bredde',),
'bredder': ('bredde',),
'breddene': ('bredde',),
'breddegrad': ('breddegrad',),
'breddegraden': ('breddegrad',),
'breddegrader': ('breddegrad',),
'breddegradene': ('breddegrad',),
'breddeminutt': ('breddeminutt',),
'breddeminuttet': ('breddeminutt',),
'breddeminutt': ('breddeminutt',),
'breddeminutter': ('breddeminutt',),
'breddeminutt': ('breddeminutt',),
'breddeminutter': ('breddeminutt',),
'breddeminutta': ('breddeminutt',),
'breddeminuttene': ('breddeminutt',),
'breddesekund': ('breddesekund',),
'breddesekundet': ('breddesekund',),
'breddesekund': ('breddesekund',),
'breddesekunder': ('breddesekund',),
'breddesekund': ('breddesekund',),
'breddesekunder': ('breddesekund',),
'breddesekunda': ('breddesekund',),
'breddesekundene': ('breddesekund',),
'breddesirkel': ('breddesirkel',),
'breddesirkelen': ('breddesirkel',),
'breddesirkler': ('breddesirkel',),
'breddesirklene': ('breddesirkel',),
'bredfilm': ('bredfilm',),
'bredfilmen': ('bredfilm',),
'bredfilmer': ('bredfilm',),
'bredfilmene': ('bredfilm',),
'bredside': ('bredside',),
'bredsiden': ('bredside',),
'bredsida': ('bredside',),
'bredsider': ('bredside',),
'bredsidene': ('bredside',),
'bregne': ('bregne',),
'bregnen': ('bregne',),
'bregna': ('bregne',),
'bregner': ('bregne',),
'bregnene': ('bregne',),
'bregnekratt': ('bregnekratt',),
'bregnekrattet': ('bregnekratt',),
'bregnekratt': ('bregnekratt',),
'bregnekratta': ('bregnekratt',),
'bregnekrattene': ('bregnekratt',),
'breibygd': ('breibygd',),
'breibygden': ('breibygd',),
'breibygda': ('breibygd',),
'breibygder': ('breibygd',),
'breibygdene': ('breibygd',),
'breierive': ('breierive',),
'breieriven': ('breierive',),
'breieriva': ('breierive',),
'breieriver': ('breierive',),
'breierivene': ('breierive',),
'breievoll': ('breievoll',),
'breievollen': ('breievoll',),
'breievoller': ('breievoll',),
'breievollene': ('breievoll',),
'breifilm': ('breifilm',),
'breifilmen': ('breifilm',),
'breifilmer': ('breifilm',),
'breifilmene': ('breifilm',),
'breiflabb': ('breiflabb',),
'breiflabben': ('breiflabb',),
'breiflabber': ('breiflabb',),
'breiflabbene': ('breiflabb',),
'breifokk': ('breifokk',),
'breifokken': ('breifokk',),
'breifokka': ('breifokk',),
'breifokker': ('breifokk',),
'breifokkene': ('breifokk',),
'breis': ('breis',),
'breisen': ('breis',),
'breiser': ('breis',),
'breis': ('breis',),
'breisene': ('breis',),
'breiside': ('breiside',),
'breisiden': ('breiside',),
'breisida': ('breiside',),
'breisider': ('breiside',),
'breisidene': ('breiside',),
'breislede': ('breislede',),
'breisleden': ('breislede',),
'breisleder': ('breislede',),
'breisledene': ('breislede',),
'breitschwans': ('breitschwans',),
'breitschwansen': ('breitschwans',),
'breitschwanser': ('breitschwans',),
'breitschwansene': ('breitschwans',),
'brejord': ('brejord',),
'brejorden': ('brejord',),
'brejorda': ('brejord',),
'brejorder': ('brejord',),
'brejordene': ('brejord',),
'brek': ('brek',),
'breket': ('brek',),
'brek': ('brek',),
'breka': ('brek',),
'brekene': ('brek',),
'brekalv': ('brekalv',),
'brekalven': ('brekalv',),
'brekalver': ('brekalv',),
'brekalvene': ('brekalv',),
'brekk': ('brekk',),
'brekket': ('brekk',),
'brekk': ('brekk',),
'brekka': ('brekk',),
'brekkene': ('brekk',),
'brekkasje': ('brekkasje',),
'brekkasjen': ('brekkasje',),
'brekkasjer': ('brekkasje',),
'brekkasjene': ('brekkasje',),
'brekkbønne': ('brekkbønne',),
'brekkbønnen': ('brekkbønne',),
'brekkbønna': ('brekkbønne',),
'brekkbønner': ('brekkbønne',),
'brekkbønnene': ('brekkbønne',),
'brekke': ('brekke',),
'brekken': ('brekke',),
'brekka': ('brekke',),
'brekker': ('brekke',),
'brekkene': ('brekke',),
'brekkfarge': ('brekkfarge',),
'brekkfargen': ('brekkfarge',),
'brekkfarger': ('brekkfarge',),
'brekkfargene': ('brekkfarge',),
'brekkjern': ('brekkjern',),
'brekkjernet': ('brekkjern',),
'brekkjern': ('brekkjern',),
'brekkjerna': ('brekkjern',),
'brekkjernene': ('brekkjern',),
'brekkmiddel': ('brekkmiddel',),
'brekkmiddelet': ('brekkmiddel',),
'brekkmidlet': ('brekkmiddel',),
'brekkmiddel': ('brekkmiddel',),
'brekkmidler': ('brekkmiddel',),
'brekkmidla': ('brekkmiddel',),
'brekkmidlene': ('brekkmiddel',),
'brekkmidla': ('brekkmiddel',),
'brekkmidlene': ('brekkmiddel',),
'brekkstang': ('brekkstang',),
'brekkstangen': ('brekkstang',),
'brekkstanga': ('brekkstang',),
'brekkstenger': ('brekkstang',),
'brekkstengene': ('brekkstang',),
'brekkvogn': ('brekkvogn',),
'brekkvognen': ('brekkvogn',),
'brekkvogna': ('brekkvogn',),
'brekkvogner': ('brekkvogn',),
'brekkvognene': ('brekkvogn',),
'brekning': ('brekning',),
'brekningen': ('brekning',),
'brekninga': ('brekning',),
'brekninger': ('brekning',),
'brekningene': ('brekning',),
'brekningsfornemmelse': ('brekningsfornemmelse',),
'brekningsfornemmelsen': ('brekningsfornemmelse',),
'brekningsfornemmelser': ('brekningsfornemmelse',),
'brekningsfornemmelsene': ('brekningsfornemmelse',),
'brem': ('brem',),
'bremmen': ('brem',),
'bremmer': ('brem',),
'bremmene': ('brem',),
'brems': ('brems',),
'bremsen': ('brems',),
'bremser': ('brems',),
'bremsene': ('brems',),
'bremse': ('bremse',),
'bremsen': ('bremse',),
'bremsa': ('bremse',),
'bremser': ('bremse',),
'bremsene': ('bremse',),
'bremseband': ('bremseband',),
'bremsebandet': ('bremseband',),
'bremseband': ('bremseband',),
'bremsebanda': ('bremseband',),
'bremsebandene': ('bremseband',),
'bremsebånd': ('bremsebånd',),
'bremsebåndet': ('bremsebånd',),
'bremsebånd': ('bremsebånd',),
'bremsebånda': ('bremsebånd',),
'bremsebåndene': ('bremsebånd',),
'bremseeffekt': ('bremseeffekt',),
'bremseeffekten': ('bremseeffekt',),
'bremseeffekter': ('bremseeffekt',),
'bremseeffektene': ('bremseeffekt',),
'bremseflate': ('bremseflate',),
'bremseflaten': ('bremseflate',),
'bremseflata': ('bremseflate',),
'bremseflater': ('bremseflate',),
'bremseflatene': ('bremseflate',),
'bremsehestekraft': ('bremsehestekraft',),
'bremsehestekraften': ('bremsehestekraft',),
'bremsehestekrafta': ('bremsehestekraft',),
'bremsehestekrefter': ('bremsehestekraft',),
'bremsehestekreftene': ('bremsehestekraft',),
'bremselengde': ('bremselengde',),
'bremselengden': ('bremselengde',),
'bremselengda': ('bremselengde',),
'bremselengder': ('bremselengde',),
'bremselengdene': ('bremselengde',),
'bremselys': ('bremselys',),
'bremselyset': ('bremselys',),
'bremselys': ('bremselys',),
'bremselysa': ('bremselys',),
'bremselysene': ('bremselys',),
'bremsevogn': ('bremsevogn',),
'bremsevognen': ('bremsevogn',),
'bremsevogna': ('bremsevogn',),
'bremsevogner': ('bremsevogn',),
'bremsevognene': ('bremsevogn',),
'bremsevæske': ('bremsevæske',),
'bremsevæsken': ('bremsevæske',),
'bremsevæska': ('bremsevæske',),
'bremsevæsker': ('bremsevæske',),
'bremsevæskene': ('bremsevæske',),
'brenn-nesle': ('brenn-nesle',),
'brenn-neslen': ('brenn-nesle',),
'brenn-nesla': ('brenn-nesle',),
'brenn-nesler': ('brenn-nesle',),
'brenn-neslene': ('brenn-nesle',),
'brenneglass': ('brenneglass',),
'brenneglasset': ('brenneglass',),
'brenneglass': ('brenneglass',),
'brenneglassa': ('brenneglass',),
'brenneglassene': ('brenneglass',),
'brennemerke': ('brennemerke',),
'brennemerket': ('brennemerke',),
'brennemerker': ('brennemerke',),
'brennemerka': ('brennemerke',),
'brennemerkene': ('brennemerke',),
'brennenesle': ('brennenesle',),
'brenneneslen': ('brennenesle',),
'brennenesla': ('brennenesle',),
'brennenesler': ('brennenesle',),
'brenneneslene': ('brennenesle',),
'brenner': ('brenner',),
'brenneren': ('brenner',),
'brennere': ('brenner',),
'brennerne': ('brenner',),
'brenneri': ('brenneri',),
'brenneriet': ('brenneri',),
'brenneri': ('brenneri',),
'brennerier': ('brenneri',),
'brenneri': ('brenneri',),
'brennerier': ('brenneri',),
'brenneria': ('brenneri',),
'brenneriene': ('brenneri',),
'brennesle': ('brennesle',),
'brenneslen': ('brennesle',),
'brennesla': ('brennesle',),
'brennesler': ('brennesle',),
'brenneslene': ('brennesle',),
'brennevin': ('brennevin',),
'brennevinet': ('brennevin',),
'brenneviner': ('brennevin',),
'brennevinene': ('brennevin',),
'brennevinsdjevel': ('brennevinsdjevel',),
'brennevinsdjevelen': ('brennevinsdjevel',),
'brennevinsdjevler': ('brennevinsdjevel',),
'brennevinsdjevlene': ('brennevinsdjevel',),
'brennevinsgauk': ('brennevinsgauk',),
'brennevinsgauken': ('brennevinsgauk',),
'brennevinsgauker': ('brennevinsgauk',),
'brennevinsgaukene': ('brennevinsgauk',),
'brennglass': ('brennglass',),
'brennglasset': ('brennglass',),
'brennglass': ('brennglass',),
'brennglassa': ('brennglass',),
'brennglassene': ('brennglass',),
'brennhast': ('brennhast',),
'brennhasten': ('brennhast',),
'brennhaster': ('brennhast',),
'brennhastene': ('brennhast',),
'brennhete': ('brennhete',),
'brennheten': ('brennhete',),
'brennheter': ('brennhete',),
'brennhetene': ('brennhete',),
'brennhår': ('brennhår',),
'brennhåret': ('brennhår',),
'brennhår': ('brennhår',),
'brennhåra': ('brennhår',),
'brennhårene': ('brennhår',),
'brenning': ('brenning',),
'brenningen': ('brenning',),
'brenninga': ('brenning',),
'brenninger': ('brenning',),
'brenningene': ('brenning',),
'brenning': ('brenning',),
'brenningen': ('brenning',),
'brenninga': ('brenning',),
'brenninger': ('brenning',),
'brenningene': ('brenning',),
'brennkopper': ('brennkopper',),
'brennkoppene': ('brennkopper',),
'brennkulde': ('brennkulde',),
'brennkulden': ('brennkulde',),
'brennkulda': ('brennkulde',),
'brennkulder': ('brennkulde',),
'brennkuldene': ('brennkulde',),
'brennmanet': ('brennmanet',),
'brennmaneten': ('brennmanet',),
'brennmaneta': ('brennmanet',),
'brennmaneter': ('brennmanet',),
'brennmanetene': ('brennmanet',),
'brennoffer': ('brennoffer',),
'brennofferet': ('brennoffer',),
'brennoffer': ('brennoffer',),
'brennofre': ('brennoffer',),
'brennofra': ('brennoffer',),
'brennofrene': ('brennoffer',),
'brennofra': ('brennoffer',),
'brennofrene': ('brennoffer',),
'brennpunkt': ('brennpunkt',),
'brennpunktet': ('brennpunkt',),
'brennpunkt': ('brennpunkt',),
'brennpunkter': ('brennpunkt',),
'brennpunkt': ('brennpunkt',),
'brennpunkter': ('brennpunkt',),
'brennpunkta': ('brennpunkt',),
'brennpunktene': ('brennpunkt',),
'brennstoff': ('brennstoff',),
'brennstoffet': ('brennstoff',),
'brennstoff': ('brennstoff',),
'brennstoffer': ('brennstoff',),
'brennstoff': ('brennstoff',),
'brennstoffer': ('brennstoff',),
'brennstoffa': ('brennstoff',),
'brennstoffene': ('brennstoff',),
'brennvidde': ('brennvidde',),
'brennvidden': ('brennvidde',),
'brennvidda': ('brennvidde',),
'brennvidder': ('brennvidde',),
'brennviddene': ('brennvidde',),
'brensel': ('brensel',),
'brenselet': ('brensel',),
'brenslet': ('brensel',),
'brensel': ('brensel',),
'brensler': ('brensel',),
'brensla': ('brensel',),
'brenslene': ('brensel',),
'brensla': ('brensel',),
'brenslene': ('brensel',),
'brenselcelle': ('brenselcelle',),
'brenselcellen': ('brenselcelle',),
'brenselcella': ('brenselcelle',),
'brenselceller': ('brenselcelle',),
'brenselcellene': ('brenselcelle',),
'brenselforbruk': ('brenselforbruk',),
'brenselforbruket': ('brenselforbruk',),
'brenselforbruk': ('brenselforbruk',),
'brenselforbruka': ('brenselforbruk',),
'brenselforbrukene': ('brenselforbruk',),
'brenselforsyning': ('brenselforsyning',),
'brenselforsyningen': ('brenselforsyning',),
'brenselforsyninga': ('brenselforsyning',),
'brenselforsyninger': ('brenselforsyning',),
'brenselforsyningene': ('brenselforsyning',),
'brenselscelle': ('brenselscelle',),
'brenselscellen': ('brenselscelle',),
'brenselscella': ('brenselscelle',),
'brenselsceller': ('brenselscelle',),
'brenselscellene': ('brenselscelle',),
'bresje': ('bresje',),
'bresjen': ('bresje',),
'bresjer': ('bresje',),
'bresjene': ('bresje',),
'bresprekk': ('bresprekk',),
'bresprekken': ('bresprekk',),
'bresprekker': ('bresprekk',),
'bresprekkene': ('bresprekk',),
'bretagner': ('bretagner',),
'bretagneren': ('bretagner',),
'bretagnere': ('bretagner',),
'bretagnerne': ('bretagner',),
'bretoner': ('bretoner',),
'bretoneren': ('bretoner',),
'bretonere': ('bretoner',),
'bretonerne': ('bretoner',),
'bretonner': ('bretonner',),
'bretonneren': ('bretonner',),
'bretonnere': ('bretonner',),
'bretonnerne': ('bretonner',),
'bretonsk': ('bretonsk',),
'bretonsken': ('bretonsk',),
'bretonsker': ('bretonsk',),
'bretonskene': ('bretonsk',),
'brett': ('brett',),
'bretten': ('brett',),
'bretter': ('brett',),
'brettene': ('brett',),
'brett': ('brett',),
'brettet': ('brett',),
'brett': ('brett',),
'bretter': ('brett',),
'brett': ('brett',),
'bretter': ('brett',),
'bretta': ('brett',),
'brettene': ('brett',),
'brettemerke': ('brettemerke',),
'brettemerket': ('brettemerke',),
'brettemerker': ('brettemerke',),
'brettemerka': ('brettemerke',),
'brettemerkene': ('brettemerke',),
'brettemess': ('brettemess',),
'brettemessen': ('brettemess',),
'brettemessa': ('brettemess',),
'brettemesser': ('brettemess',),
'brettemessene': ('brettemess',),
'brettemesse': ('brettemesse',),
'brettemessen': ('brettemesse',),
'brettemessa': ('brettemesse',),
'brettemesser': ('brettemesse',),
'brettemessene': ('brettemesse',),
'brettmess': ('brettmess',),
'brettmessen': ('brettmess',),
'brettmessa': ('brettmess',),
'brettmesser': ('brettmess',),
'brettmessene': ('brettmess',),
'brettmesse': ('brettmesse',),
'brettmessen': ('brettmesse',),
'brettmessa': ('brettmesse',),
'brettmesser': ('brettmesse',),
'brettmessene': ('brettmesse',),
'brettsegler': ('brettsegler',),
'brettsegleren': ('brettsegler',),
'brettseglere': ('brettsegler',),
'brettseglerne': ('brettsegler',),
'brettsegling': ('brettsegling',),
'brettseglingen': ('brettsegling',),
'brettseglinga': ('brettsegling',),
'brettseglinger': ('brettsegling',),
'brettseglingene': ('brettsegling',),
'brettseiler': ('brettseiler',),
'brettseileren': ('brettseiler',),
'brettseilere': ('brettseiler',),
'brettseilerne': ('brettseiler',),
'brettseiling': ('brettseiling',),
'brettseilingen': ('brettseiling',),
'brettseilinga': ('brettseiling',),
'brettseilinger': ('brettseiling',),
'brettseilingene': ('brettseiling',),
'brettspell': ('brettspell',),
'brettspellet': ('brettspell',),
'brettspell': ('brettspell',),
'brettspella': ('brettspell',),
'brettspellene': ('brettspell',),
'brettspill': ('brettspill',),
'brettspillet': ('brettspill',),
'brettspill': ('brettspill',),
'brettspilla': ('brettspill',),
'brettspillene': ('brettspill',),
'brev': ('brev',),
'brevet': ('brev',),
'brev': ('brev',),
'brever': ('brev',),
'brev': ('brev',),
'brever': ('brev',),
'breva': ('brev',),
'brevene': ('brev',),
'brevadel': ('brevadel',),
'brevadelen': ('brevadel',),
'brevadeler': ('brevadel',),
'brevadelene': ('brevadel',),
'brevandrer': ('brevandrer',),
'brevandreren': ('brevandrer',),
'brevandrere': ('brevandrer',),
'brevandrerne': ('brevandrer',),
'brevann': ('brevann',),
'brevannet': ('brevann',),
'brevann': ('brevann',),
'brevanna': ('brevann',),
'brevannene': ('brevann',),
'brevatn': ('brevatn',),
'brevatnet': ('brevatn',),
'brevatn': ('brevatn',),
'brevatna': ('brevatn',),
'brevatnene': ('brevatn',),
'brevbombe': ('brevbombe',),
'brevbomben': ('brevbombe',),
'brevbomba': ('brevbombe',),
'brevbomber': ('brevbombe',),
'brevbombene': ('brevbombe',),
'brevbrott': ('brevbrott',),
'brevbrottet': ('brevbrott',),
'brevbrott': ('brevbrott',),
'brevbrotta': ('brevbrott',),
'brevbrottene': ('brevbrott',),
'brevbrudd': ('brevbrudd',),
'brevbruddet': ('brevbrudd',),
'brevbrudd': ('brevbrudd',),
'brevbrudda': ('brevbrudd',),
'brevbruddene': ('brevbrudd',),
'brevdue': ('brevdue',),
'brevduen': ('brevdue',),
'brevdua': ('brevdue',),
'brevduer': ('brevdue',),
'brevduene': ('brevdue',),
'brevforbud': ('brevforbud',),
'brevforbudet': ('brevforbud',),
'brevforbud': ('brevforbud',),
'brevforbuda': ('brevforbud',),
'brevforbudene': ('brevforbud',),
'brevhode': ('brevhode',),
'brevhodet': ('brevhode',),
'brevhoder': ('brevhode',),
'brevhoda': ('brevhode',),
'brevhodene': ('brevhode',),
'breviar': ('breviar',),
'breviaret': ('breviar',),
'breviar': ('breviar',),
'breviarer': ('breviar',),
'breviar': ('breviar',),
'breviarer': ('breviar',),
'breviara': ('breviar',),
'breviarene': ('breviar',),
'breviarium': ('breviarium',),
'breviariet': ('breviarium',),
'breviarier': ('breviarium',),
'breviaria': ('breviarium',),
'breviariene': ('breviarium',),
'brevkasse': ('brevkasse',),
'brevkassen': ('brevkasse',),
'brevkassa': ('brevkasse',),
'brevkasser': ('brevkasse',),
'brevkassene': ('brevkasse',),
'brevkort': ('brevkort',),
'brevkortet': ('brevkort',),
'brevkort': ('brevkort',),
'brevkorta': ('brevkort',),
'brevkortene': ('brevkort',),
'brevkurs': ('brevkurs',),
'brevkurset': ('brevkurs',),
'brevkurs': ('brevkurs',),
'brevkurser': ('brevkurs',),
'brevkurs': ('brevkurs',),
'brevkurser': ('brevkurs',),
'brevkursa': ('brevkurs',),
'brevkursene': ('brevkurs',),
'brevporto': ('brevporto',),
'brevportoen': ('brevporto',),
'brevportoer': ('brevporto',),
'brevportoene': ('brevporto',),
'brevsending': ('brevsending',),
'brevsendingen': ('brevsending',),
'brevsendinga': ('brevsending',),
'brevsendinger': ('brevsending',),
'brevsendingene': ('brevsending',),
'brevskole': ('brevskole',),
'brevskolen': ('brevskole',),
'brevskoler': ('brevskole',),
'brevskolene': ('brevskole',),
'brevskriver': ('brevskriver',),
'brevskriveren': ('brevskriver',),
'brevskrivere': ('brevskriver',),
'brevskriverne': ('brevskriver',),
'brevundervisning': ('brevundervisning',),
'brevundervisningen': ('brevundervisning',),
'brevundervisninga': ('brevundervisning',),
'brevundervisninger': ('brevundervisning',),
'brevundervisningene': ('brevundervisning',),
'brevvekt': ('brevvekt',),
'brevvekten': ('brevvekt',),
'brevvekta': ('brevvekt',),
'brevvekter': ('brevvekt',),
'brevvektene': ('brevvekt',),
'brevvenn': ('brevvenn',),
'brevvennen': ('brevvenn',),
'brevvenner': ('brevvenn',),
'brevvennene': ('brevvenn',),
'bridge': ('bridge',),
'bridgen': ('bridge',),
'bridger': ('bridge',),
'bridgene': ('bridge',),
'brie': ('brie',),
'brien': ('brie',),
'brier': ('brie',),
'briene': ('brie',),
'brifing': ('brifing',),
'brifingen': ('brifing',),
'brifinga': ('brifing',),
'brifinger': ('brifing',),
'brifingene': ('brifing',),
'brigade': ('brigade',),
'brigaden': ('brigade',),
'brigader': ('brigade',),
'brigadene': ('brigade',),
'brigadegeneral': ('brigadegeneral',),
'brigadegeneralen': ('brigadegeneral',),
'brigadegeneraler': ('brigadegeneral',),
'brigadegeneralene': ('brigadegeneral',),
'brigadekommandør': ('brigadekommandør',),
'brigadekommandøren': ('brigadekommandør',),
'brigadekommandører': ('brigadekommandør',),
'brigadekommandørene': ('brigadekommandør',),
'brigadeoffiser': ('brigadeoffiser',),
'brigadeoffiseren': ('brigadeoffiser',),
'brigadeoffiserer': ('brigadeoffiser',),
'brigadeoffiserene': ('brigadeoffiser',),
'brigader': ('brigader',),
'brigaderen': ('brigader',),
'brigaderer': ('brigader',),
'brigaderene': ('brigader',),
'brikett': ('brikett',),
'briketten': ('brikett',),
'briketter': ('brikett',),
'brikettene': ('brikett',),
'brikke': ('brikke',),
'brikken': ('brikke',),
'brikka': ('brikke',),
'brikker': ('brikke',),
'brikkene': ('brikke',),
'brikkespell': ('brikkespell',),
'brikkespellet': ('brikkespell',),
'brikkespell': ('brikkespell',),
'brikkespella': ('brikkespell',),
'brikkespellene': ('brikkespell',),
'brikkespill': ('brikkespill',),
'brikkespillet': ('brikkespill',),
'brikkespill': ('brikkespill',),
'brikkespilla': ('brikkespill',),
'brikkespillene': ('brikkespill',),
'brikkevev': ('brikkevev',),
'brikkeveven': ('brikkevev',),
'brikkevever': ('brikkevev',),
'brikkevevene': ('brikkevev',),
'briks': ('briks',),
'briksen': ('briks',),
'brikser': ('briks',),
'briksene': ('briks',),
'briljans': ('briljans',),
'briljansen': ('briljans',),
'briljanser': ('briljans',),
'briljansene': ('briljans',),
'briljant': ('briljant',),
'briljanten': ('briljant',),
'briljanter': ('briljant',),
'briljantene': ('briljant',),
'briljantin': ('briljantin',),
'briljantinen': ('briljantin',),
'briljantiner': ('briljantin',),
'briljantinene': ('briljantin',),
'briljantine': ('briljantine',),
'briljantinen': ('briljantine',),
'briljantiner': ('briljantine',),
'briljantinene': ('briljantine',),
'briljantsmykke': ('briljantsmykke',),
'briljantsmykket': ('briljantsmykke',),
'briljantsmykker': ('briljantsmykke',),
'briljantsmykka': ('briljantsmykke',),
'briljantsmykkene': ('briljantsmykke',),
'brille': ('brille',),
'brillen': ('brille',),
'brilla': ('brille',),
'briller': ('brille',),
'brillene': ('brille',),
'brillefutteral': ('brillefutteral',),
'brillefutteralet': ('brillefutteral',),
'brillefutteral': ('brillefutteral',),
'brillefutteraler': ('brillefutteral',),
'brillefutteral': ('brillefutteral',),
'brillefutteraler': ('brillefutteral',),
'brillefutterala': ('brillefutteral',),
'brillefutteralene': ('brillefutteral',),
'brilleglass': ('brilleglass',),
'brilleglasset': ('brilleglass',),
'brilleglass': ('brilleglass',),
'brilleglassa': ('brilleglass',),
'brilleglassene': ('brilleglass',),
'brilleinnfatning': ('brilleinnfatning',),
'brilleinnfatningen': ('brilleinnfatning',),
'brilleinnfatninga': ('brilleinnfatning',),
'brilleinnfatninger': ('brilleinnfatning',),
'brilleinnfatningene': ('brilleinnfatning',),
'brilleslange': ('brilleslange',),
'brilleslangen': ('brilleslange',),
'brilleslanger': ('brilleslange',),
'brilleslangene': ('brilleslange',),
'brim': ('brim',),
'brimet': ('brim',),
'brim': ('brim',),
'brima': ('brim',),
'brimene': ('brim',),
'brimsjø': ('brimsjø',),
'brimsjøen': ('brimsjø',),
'brimsjøer': ('brimsjø',),
'brimsjøene': ('brimsjø',),
'bringe': ('bringe',),
'bringen': ('bringe',),
'bringer': ('bringe',),
'bringene': ('bringe',),
'bringe': ('bringe',),
'bringen': ('bringe',),
'bringa': ('bringe',),
'bringer': ('bringe',),
'bringene': ('bringe',),
'bringebær': ('bringebær',),
'bringebæret': ('bringebær',),
'bringebær': ('bringebær',),
'bringebæra': ('bringebær',),
'bringebærene': ('bringebær',),
'bringebærbille': ('bringebærbille',),
'bringebærbillen': ('bringebærbille',),
'bringebærbiller': ('bringebærbille',),
'bringebærbillene': ('bringebærbille',),
'bringebærbusk': ('bringebærbusk',),
'bringebærbusken': ('bringebærbusk',),
'bringebærbusker': ('bringebærbusk',),
'bringebærbuskene': ('bringebærbusk',),
'bringebærmakk': ('bringebærmakk',),
'bringebærmakken': ('bringebærmakk',),
'bringebærmakker': ('bringebærmakk',),
'bringebærmakkene': ('bringebærmakk',),
'bringebærmark': ('bringebærmark',),
'bringebærmarken': ('bringebærmark',),
'bringebærmarker': ('bringebærmark',),
'bringebærmarkene': ('bringebærmark',),
'bringebærsaft': ('bringebærsaft',),
'bringebærsaften': ('bringebærsaft',),
'bringebærsafta': ('bringebærsaft',),
'bringebærsafter': ('bringebærsaft',),
'bringebærsaftene': ('bringebærsaft',),
'bringebærsyltetøy': ('bringebærsyltetøy',),
'bringebærsyltetøyet': ('bringebærsyltetøy',),
'bringebærsyltetøy': ('bringebærsyltetøy',),
'bringebærsyltetøya': ('bringebærsyltetøy',),
'bringebærsyltetøyene': ('bringebærsyltetøy',),
'brink': ('brink',),
'brinken': ('brink',),
'brinker': ('brink',),
'brinkene': ('brink',),
'bris': ('bris',),
'brisen': ('bris',),
'briser': ('bris',),
'brisene': ('bris',),
'brisantammunisjon': ('brisantammunisjon',),
'brisantammunisjonen': ('brisantammunisjon',),
'brisantammunisjoner': ('brisantammunisjon',),
'brisantammunisjonene': ('brisantammunisjon',),
'brisk': ('brisk',),
'brisken': ('brisk',),
'brisker': ('brisk',),
'briskene': ('brisk',),
'briskelåg': ('briskelåg',),
'briskelågen': ('briskelåg',),
'briskelåger': ('briskelåg',),
'briskelågene': ('briskelåg',),
'brisling': ('brisling',),
'brislingen': ('brisling',),
'brislinger': ('brisling',),
'brislingene': ('brisling',),
'brislingfiske': ('brislingfiske',),
'brislingfisket': ('brislingfiske',),
'brislingfisker': ('brislingfiske',),
'brislingfiska': ('brislingfiske',),
'brislingfiskene': ('brislingfiske',),
'brislingsteng': ('brislingsteng',),
'brislingstenget': ('brislingsteng',),
'brislingsteng': ('brislingsteng',),
'brislingstenga': ('brislingsteng',),
'brislingstengene': ('brislingsteng',),
'brissel': ('brissel',),
'brisselen': ('brissel',),
'brisler': ('brissel',),
'brislene': ('brissel',),
'brist': ('brist',),
'bristen': ('brist',),
'brister': ('brist',),
'bristene': ('brist',),
'bristepunkt': ('bristepunkt',),
'bristepunktet': ('bristepunkt',),
'bristepunkt': ('bristepunkt',),
'bristepunkta': ('bristepunkt',),
'bristepunktene': ('bristepunkt',),
'brite': ('brite',),
'briten': ('brite',),
'briter': ('brite',),
'britene': ('brite',),
'britisk-engelsk': ('britisk-engelsk',),
'britisk-engelsken': ('britisk-engelsk',),
'britisk-engelsker': ('britisk-engelsk',),
'britisk-engelskene': ('britisk-engelsk',),
'bro': ('bro',),
'broen': ('bro',),
'broa': ('bro',),
'broer': ('bro',),
'broene': ('bro',),
'bro-bro-brille': ('bro-bro-brille',),
'brobygger': ('brobygger',),
'brobyggeren': ('brobygger',),
'brobyggere': ('brobygger',),
'brobyggerne': ('brobygger',),
'brodd': ('brodd',),
'brodden': ('brodd',),
'brodder': ('brodd',),
'broddene': ('brodd',),
'broder': ('broder',),
'broderen': ('broder',),
'brødre': ('broder',),
'brødrene': ('broder',),
'broderfolk': ('broderfolk',),
'broderfolket': ('broderfolk',),
'broderfolk': ('broderfolk',),
'broderfolka': ('broderfolk',),
'broderfolkene': ('broderfolk',),
'brodergarn': ('brodergarn',),
'brodergarnet': ('brodergarn',),
'brodergarn': ('brodergarn',),
'brodergarna': ('brodergarn',),
'brodergarnene': ('brodergarn',),
'broderhand': ('broderhand',),
'broderhanden': ('broderhand',),
'broderhanda': ('broderhand',),
'broderhender': ('broderhand',),
'broderhendene': ('broderhand',),
'broderhånd': ('broderhånd',),
'broderhånden': ('broderhånd',),
'broderhånda': ('broderhånd',),
'broderhender': ('broderhånd',),
'broderhendene': ('broderhånd',),
'broderi': ('broderi',),
'broderiet': ('broderi',),
'broderi': ('broderi',),
'broderier': ('broderi',),
'broderi': ('broderi',),
'broderier': ('broderi',),
'broderia': ('broderi',),
'broderiene': ('broderi',),
'broderiforretning': ('broderiforretning',),
'broderiforretningen': ('broderiforretning',),
'broderiforretninga': ('broderiforretning',),
'broderiforretninger': ('broderiforretning',),
'broderiforretningene': ('broderiforretning',),
'broderkjærlighet': ('broderkjærlighet',),
'broderkjærligheten': ('broderkjærlighet',),
'broderkjærligheta': ('broderkjærlighet',),
'broderkjærligheter': ('broderkjærlighet',),
'broderkjærlighetene': ('broderkjærlighet',),
'broderland': ('broderland',),
'broderlandet': ('broderland',),
'broderland': ('broderland',),
'broderlanda': ('broderland',),
'broderlandene': ('broderland',),
'brodermord': ('brodermord',),
'brodermordet': ('brodermord',),
'brodermord': ('brodermord',),
'brodermorda': ('brodermord',),
'brodermordene': ('brodermord',),
'broderring': ('broderring',),
'broderringen': ('broderring',),
'broderringer': ('broderring',),
'broderringene': ('broderring',),
'brodersaks': ('brodersaks',),
'brodersaksen': ('brodersaks',),
'brodersaksa': ('brodersaks',),
'brodersakser': ('brodersaks',),
'brodersaksene': ('brodersaks',),
'brodersamfunn': ('brodersamfunn',),
'brodersamfunnet': ('brodersamfunn',),
'brodersamfunn': ('brodersamfunn',),
'brodersamfunna': ('brodersamfunn',),
'brodersamfunnene': ('brodersamfunn',),
'broderånd': ('broderånd',),
'broderånden': ('broderånd',),
'broderånder': ('broderånd',),
'broderåndene': ('broderånd',),
'brohode': ('brohode',),
'brohodet': ('brohode',),
'brohoder': ('brohode',),
'brohoda': ('brohode',),
'brohodene': ('brohode',),
'broiler': ('broiler',),
'broileren': ('broiler',),
'broilere': ('broiler',),
'broilerne': ('broiler',),
'broilerproduksjon': ('broilerproduksjon',),
'broilerproduksjonen': ('broilerproduksjon',),
'broilerproduksjoner': ('broilerproduksjon',),
'broilerproduksjonene': ('broilerproduksjon',),
'brok': ('brok',),
'broken': ('brok',),
'broka': ('brok',),
'brøker': ('brok',),
'brøkene': ('brok',),
'brokade': ('brokade',),
'brokaden': ('brokade',),
'brokader': ('brokade',),
'brokadene': ('brokade',),
'brokadestoff': ('brokadestoff',),
'brokadestoffet': ('brokadestoff',),
'brokadestoff': ('brokadestoff',),
'brokadestoffer': ('brokadestoff',),
'brokadestoff': ('brokadestoff',),
'brokadestoffer': ('brokadestoff',),
'brokadestoffa': ('brokadestoff',),
'brokadestoffene': ('brokadestoff',),
'brokar': ('brokar',),
'brokaret': ('brokar',),
'brokar': ('brokar',),
'brokara': ('brokar',),
'brokarene': ('brokar',),
'brokk': ('brokk',),
'brokken': ('brokk',),
'brokket': ('brokk',),
'brokker': ('brokk',),
'brokk': ('brokk',),
'brokkene': ('brokk',),
'brokka': ('brokk',),
'brokkene': ('brokk',),
'brokkbind': ('brokkbind',),
'brokkbindet': ('brokkbind',),
'brokkbind': ('brokkbind',),
'brokkbinda': ('brokkbind',),
'brokkbindene': ('brokkbind',),
'brokke': ('brokke',),
'brokken': ('brokke',),
'brokker': ('brokke',),
'brokkene': ('brokke',),
'brokkoli': ('brokkoli',),
'brokkolien': ('brokkoli',),
'brokkolier': ('brokkoli',),
'brokkoliene': ('brokkoli',),
'brokkurt': ('brokkurt',),
'brokkurten': ('brokkurt',),
'brokkurta': ('brokkurt',),
'brokkurter': ('brokkurt',),
'brokkurtene': ('brokkurt',),
'brolegger': ('brolegger',),
'broleggeren': ('brolegger',),
'broleggere': ('brolegger',),
'broleggerne': ('brolegger',),
'brolegging': ('brolegging',),
'broleggingen': ('brolegging',),
'brolegginga': ('brolegging',),
'brolegginger': ('brolegging',),
'broleggingene': ('brolegging',),
'brolegning': ('brolegning',),
'brolegningen': ('brolegning',),
'brolegninga': ('brolegning',),
'brolegninger': ('brolegning',),
'brolegningene': ('brolegning',),
'brom': ('brom',),
'brommet': ('brom',),
'brom': ('brom',),
'bromma': ('brom',),
'brommene': ('brom',),
'bromid': ('bromid',),
'bromidet': ('bromid',),
'bromid': ('bromid',),
'bromider': ('bromid',),
'bromid': ('bromid',),
'bromider': ('bromid',),
'bromida': ('bromid',),
'bromidene': ('bromid',),
'bromidpapir': ('bromidpapir',),
'bromidpapiret': ('bromidpapir',),
'bromidpapir': ('bromidpapir',),
'bromidpapirer': ('bromidpapir',),
'bromidpapir': ('bromidpapir',),
'bromidpapirer': ('bromidpapir',),
'bromidpapira': ('bromidpapir',),
'bromidpapirene': ('bromidpapir',),
'bromisme': ('bromisme',),
'bromismen': ('bromisme',),
'bromismer': ('bromisme',),
'bromismene': ('bromisme',),
'bronkie': ('bronkie',),
'bronkien': ('bronkie',),
'bronkier': ('bronkie',),
'bronkiene': ('bronkie',),
'bronkiegrein': ('bronkiegrein',),
'bronkiegreinen': ('bronkiegrein',),
'bronkiegreina': ('bronkiegrein',),
'bronkiegreiner': ('bronkiegrein',),
'bronkiegreinene': ('bronkiegrein',),
'bronkiegren': ('bronkiegren',),
'bronkiegrenen': ('bronkiegren',),
'bronkiegrena': ('bronkiegren',),
'bronkiegrener': ('bronkiegren',),
'bronkiegrenene': ('bronkiegren',),
'bronkitt': ('bronkitt',),
'bronkitten': ('bronkitt',),
'bronkitter': ('bronkitt',),
'bronkittene': ('bronkitt',),
'bronkitthoste': ('bronkitthoste',),
'bronkitthosten': ('bronkitthoste',),
'bronkitthoster': ('bronkitthoste',),
'bronkitthostene': ('bronkitthoste',),
'bronse': ('bronse',),
'bronsen': ('bronse',),
'bronser': ('bronse',),
'bronsene': ('bronse',),
'bronsealder': ('bronsealder',),
'bronsealderen': ('bronsealder',),
'bronsealdere': ('bronsealder',),
'bronsealdrer': ('bronsealder',),
'bronsealdre': ('bronsealder',),
'bronsealderne': ('bronsealder',),
'bronsealdrene': ('bronsealder',),
'bronsefarge': ('bronsefarge',),
'bronsefargen': ('bronsefarge',),
'bronsefarger': ('bronsefarge',),
'bronsefargene': ('bronsefarge',),
'bronsemedalje': ('bronsemedalje',),
'bronsemedaljen': ('bronsemedalje',),
'bronsemedaljer': ('bronsemedalje',),
'bronsemedaljene': ('bronsemedalje',),
'bronsemedaljevinner': ('bronsemedaljevinner',),
'bronsemedaljevinneren': ('bronsemedaljevinner',),
'bronsemedaljevinnere': ('bronsemedaljevinner',),
'bronsemedaljevinnerne': ('bronsemedaljevinner',),
'bropilar': ('bropilar',),
'bropilaren': ('bropilar',),
'bropilarer': ('bropilar',),
'bropilarene': ('bropilar',),
'bror': ('bror',),
'broren': ('bror',),
'brødre': ('bror',),
'brødrene': ('bror',),
'brordatter': ('brordatter',),
'brordatteren': ('brordatter',),
'brordattera': ('brordatter',),
'brordøtre': ('brordatter',),
'brordøtrer': ('brordatter',),
'brordøtre': ('brordatter',),
'brordøtrer': ('brordatter',),
'brordøtrene': ('brordatter',),
'brorkone': ('brorkone',),
'brorkonen': ('brorkone',),
'brorkona': ('brorkone',),
'brorkoner': ('brorkone',),
'brorkonene': ('brorkone',),
'brorpart': ('brorpart',),
'brorparten': ('brorpart',),
'brorparter': ('brorpart',),
'brorpartene': ('brorpart',),
'brorskap': ('brorskap',),
'brorskapet': ('brorskap',),
'brorskap': ('brorskap',),
'brorskapa': ('brorskap',),
'brorskapene': ('brorskap',),
'brorsønn': ('brorsønn',),
'brorsønnen': ('brorsønn',),
'brorsønner': ('brorsønn',),
'brorsønnene': ('brorsønn',),
'brosje': ('brosje',),
'brosjen': ('brosje',),
'brosja': ('brosje',),
'brosjer': ('brosje',),
'brosjene': ('brosje',),
'brosjyre': ('brosjyre',),
'brosjyren': ('brosjyre',),
'brosjyrer': ('brosjyre',),
'brosjyrene': ('brosjyre',),
'brosme': ('brosme',),
'brosmen': ('brosme',),
'brosma': ('brosme',),
'brosmer': ('brosme',),
'brosmene': ('brosme',),
'brospenn': ('brospenn',),
'brospennet': ('brospenn',),
'brospenn': ('brospenn',),
'brospenna': ('brospenn',),
'brospennene': ('brospenn',),
'brostein': ('brostein',),
'brosteinen': ('brostein',),
'brosteiner': ('brostein',),
'brosteinene': ('brostein',),
'brotsj': ('brotsj',),
'brotsjen': ('brotsj',),
'brotsjer': ('brotsj',),
'brotsjene': ('brotsj',),
'brott': ('brott',),
'brottet': ('brott',),
'brott': ('brott',),
'brotta': ('brott',),
'brottene': ('brott',),
'brottbelastning': ('brottbelastning',),
'brottbelastningen': ('brottbelastning',),
'brottbelastninga': ('brottbelastning',),
'brottbelastninger': ('brottbelastning',),
'brottbelastningene': ('brottbelastning',),
'brottfasthet': ('brottfasthet',),
'brottfastheten': ('brottfasthet',),
'brottfastheta': ('brottfasthet',),
'brottfastheter': ('brottfasthet',),
'brottfasthetene': ('brottfasthet',),
'brottflate': ('brottflate',),
'brottflaten': ('brottflate',),
'brottflata': ('brottflate',),
'brottflater': ('brottflate',),
'brottflatene': ('brottflate',),
'brotthelle': ('brotthelle',),
'brotthellen': ('brotthelle',),
'brotthella': ('brotthelle',),
'brottheller': ('brotthelle',),
'brotthellene': ('brotthelle',),
'brottsjø': ('brottsjø',),
'brottsjøen': ('brottsjø',),
'brottsjøer': ('brottsjø',),
'brottsjøene': ('brottsjø',),
'brottsmann': ('brottsmann',),
'brottsmannen': ('brottsmann',),
'brottsmenn': ('brottsmann',),
'brottsmennene': ('brottsmann',),
'brottstein': ('brottstein',),
'brottsteinen': ('brottstein',),
'brottsteiner': ('brottstein',),
'brottsteinene': ('brottstein',),
'brottstykke': ('brottstykke',),
'brottstykket': ('brottstykke',),
'brottstykker': ('brottstykke',),
'brottstykka': ('brottstykke',),
'brottstykkene': ('brottstykke',),
'brottstyrke': ('brottstyrke',),
'brottstyrken': ('brottstyrke',),
'brottstyrker': ('brottstyrke',),
'brottstyrkene': ('brottstyrke',),
'brottsverk': ('brottsverk',),
'brottsverket': ('brottsverk',),
'brottsverk': ('brottsverk',),
'brottsverker': ('brottsverk',),
'brottsverk': ('brottsverk',),
'brottsverker': ('brottsverk',),
'brottsverka': ('brottsverk',),
'brottsverkene': ('brottsverk',),
'bru': ('bru',),
'bruen': ('bru',),
'brua': ('bru',),
'bruer': ('bru',),
'bruene': ('bru',),
'brubygger': ('brubygger',),
'brubyggeren': ('brubygger',),
'brubyggere': ('brubygger',),
'brubyggerne': ('brubygger',),
'brud': ('brud',),
'bruden': ('brud',),
'bruda': ('brud',),
'bruder': ('brud',),
'brudene': ('brud',),
'brudd': ('brudd',),
'bruddet': ('brudd',),
'brudd': ('brudd',),
'brudda': ('brudd',),
'bruddene': ('brudd',),
'bruddbelastning': ('bruddbelastning',),
'bruddbelastningen': ('bruddbelastning',),
'bruddbelastninga': ('bruddbelastning',),
'bruddbelastninger': ('bruddbelastning',),
'bruddbelastningene': ('bruddbelastning',),
'bruddfasthet': ('bruddfasthet',),
'bruddfastheten': ('bruddfasthet',),
'bruddfastheta': ('bruddfasthet',),
'bruddfastheter': ('bruddfasthet',),
'bruddfasthetene': ('bruddfasthet',),
'bruddflate': ('bruddflate',),
'bruddflaten': ('bruddflate',),
'bruddflata': ('bruddflate',),
'bruddflater': ('bruddflate',),
'bruddflatene': ('bruddflate',),
'bruddhelle': ('bruddhelle',),
'bruddhellen': ('bruddhelle',),
'bruddhella': ('bruddhelle',),
'bruddheller': ('bruddhelle',),
'bruddhellene': ('bruddhelle',),
'bruddstein': ('bruddstein',),
'bruddsteinen': ('bruddstein',),
'bruddsteiner': ('bruddstein',),
'bruddsteinene': ('bruddstein',),
'bruddstykke': ('bruddstykke',),
'bruddstykket': ('bruddstykke',),
'bruddstykker': ('bruddstykke',),
'bruddstykka': ('bruddstykke',),
'bruddstykkene': ('bruddstykke',),
'bruddstyrke': ('bruddstyrke',),
'bruddstyrken': ('bruddstyrke',),
'bruddstyrker': ('bruddstyrke',),
'bruddstyrkene': ('bruddstyrke',),
'brudebukett': ('brudebukett',),
'brudebuketten': ('brudebukett',),
'brudebuketter': ('brudebukett',),
'brudebukettene': ('brudebukett',),
'brudedans': ('brudedans',),
'brudedansen': ('brudedans',),
'brudedanser': ('brudedans',),
'brudedansene': ('brudedans',),
'brudeferd': ('brudeferd',),
'brudeferden': ('brudeferd',),
'brudeferda': ('brudeferd',),
'brudeferder': ('brudeferd',),
'brudeferdene': ('brudeferd',),
'brudefølge': ('brudefølge',),
'brudefølget': ('brudefølge',),
'brudefølger': ('brudefølge',),
'brudefølga': ('brudefølge',),
'brudefølgene': ('brudefølge',),
'brudelys': ('brudelys',),
'brudelysen': ('brudelys',),
'brudelyset': ('brudelys',),
'brudelyser': ('brudelys',),
'brudelys': ('brudelys',),
'brudelyser': ('brudelys',),
'brudelys': ('brudelys',),
'brudelyser': ('brudelys',),
'brudelysene': ('brudelys',),
'brudelysa': ('brudelys',),
'brudelysene': ('brudelys',),
'brudemarsj': ('brudemarsj',),
'brudemarsjen': ('brudemarsj',),
'brudemarsjer': ('brudemarsj',),
'brudemarsjene': ('brudemarsj',),
'brudepar': ('brudepar',),
'brudeparet': ('brudepar',),
'brudepar': ('brudepar',),
'brudepara': ('brudepar',),
'brudeparene': ('brudepar',),
'brudeseng': ('brudeseng',),
'brudesengen': ('brudeseng',),
'brudesenga': ('brudeseng',),
'brudesenger': ('brudeseng',),
'brudesengene': ('brudeseng',),
'brudeslør': ('brudeslør',),
'brudesløret': ('brudeslør',),
'brudeslør': ('brudeslør',),
'brudesløra': ('brudeslør',),
'brudeslørene': ('brudeslør',),
'brudespore': ('brudespore',),
'brudesporen': ('brudespore',),
'brudesporer': ('brudespore',),
'brudesporene': ('brudespore',),
'brudevielse': ('brudevielse',),
'brudevielsen': ('brudevielse',),
'brudevielser': ('brudevielse',),
'brudevielsene': ('brudevielse',),
'brudevigsel': ('brudevigsel',),
'brudevigselen': ('brudevigsel',),
'brudevigsler': ('brudevigsel',),
'brudevigslene': ('brudevigsel',),
'brudgom': ('brudgom',),
'brudgommen': ('brudgom',),
'brudgommer': ('brudgom',),
'brudgommene': ('brudgom',),
'brudgomstale': ('brudgomstale',),
'brudgomstalen': ('brudgomstale',),
'brudgomstaler': ('brudgomstale',),
'brudgomstalene': ('brudgomstale',),
'brudulje': ('brudulje',),
'bruduljen': ('brudulje',),
'bruduljer': ('brudulje',),
'bruduljene': ('brudulje',),
'brugde': ('brugde',),
'brugden': ('brugde',),
'brugda': ('brugde',),
'brugder': ('brugde',),
'brugdene': ('brugde',),
'bruhode': ('bruhode',),
'bruhodet': ('bruhode',),
'bruhoder': ('bruhode',),
'bruhoda': ('bruhode',),
'bruhodene': ('bruhode',),
'bruk': ('bruk',),
'bruket': ('bruk',),
'bruk': ('bruk',),
'bruka': ('bruk',),
'brukene': ('bruk',),
'bruk': ('bruk',),
'bruken': ('bruk',),
'bruket': ('bruk',),
'bruker': ('bruk',),
'bruk': ('bruk',),
'brukene': ('bruk',),
'bruka': ('bruk',),
'brukene': ('bruk',),
'brukar': ('brukar',),
'brukaret': ('brukar',),
'brukar': ('brukar',),
'brukara': ('brukar',),
'brukarene': ('brukar',),
'brukelighet': ('brukelighet',),
'brukeligheten': ('brukelighet',),
'brukeligheta': ('brukelighet',),
'brukeligheter': ('brukelighet',),
'brukelighetene': ('brukelighet',),
'bruker': ('bruker',),
'brukeren': ('bruker',),
'brukere': ('bruker',),
'brukerne': ('bruker',),
'bruksanvisning': ('bruksanvisning',),
'bruksanvisningen': ('bruksanvisning',),
'bruksanvisninga': ('bruksanvisning',),
'bruksanvisninger': ('bruksanvisning',),
'bruksanvisningene': ('bruksanvisning',),
'bruksegenskap': ('bruksegenskap',),
'bruksegenskapen': ('bruksegenskap',),
'bruksegenskaper': ('bruksegenskap',),
'bruksegenskapene': ('bruksegenskap',),
'brukseier': ('brukseier',),
'brukseieren': ('brukseier',),
'brukseiere': ('brukseier',),
'brukseierne': ('brukseier',),
'bruksendring': ('bruksendring',),
'bruksendringen': ('bruksendring',),
'bruksendringa': ('bruksendring',),
'bruksendringer': ('bruksendring',),
'bruksendringene': ('bruksendring',),
'bruksgjenstand': ('bruksgjenstand',),
'bruksgjenstanden': ('bruksgjenstand',),
'bruksgjenstander': ('bruksgjenstand',),
'bruksgjenstandene': ('bruksgjenstand',),
'brukshaver': ('brukshaver',),
'brukshaveren': ('brukshaver',),
'brukshavere': ('brukshaver',),
'brukshaverne': ('brukshaver',),
'brukskultur': ('brukskultur',),
'brukskulturen': ('brukskultur',),
'brukskulturer': ('brukskultur',),
'brukskulturene': ('brukskultur',),
'brukskunst': ('brukskunst',),
'brukskunsten': ('brukskunst',),
'brukskunster': ('brukskunst',),
'brukskunstene': ('brukskunst',),
'brukskunstner': ('brukskunstner',),
'brukskunstneren': ('brukskunstner',),
'brukskunstnere': ('brukskunstner',),
'brukskunstnerne': ('brukskunstner',),
'bruksmåte': ('bruksmåte',),
'bruksmåten': ('bruksmåte',),
'bruksmåter': ('bruksmåte',),
'bruksmåtene': ('bruksmåte',),
'bruksnummer': ('bruksnummer',),
'bruksnummeret': ('bruksnummer',),
'bruksnummer': ('bruksnummer',),
'bruksnumre': ('bruksnummer',),
'bruksnumra': ('bruksnummer',),
'bruksnumrene': ('bruksnummer',),
'bruksnumra': ('bruksnummer',),
'bruksnumrene': ('bruksnummer',),
'bruksområde': ('bruksområde',),
'bruksområdet': ('bruksområde',),
'bruksområder': ('bruksområde',),
'bruksområda': ('bruksområde',),
'bruksområdene': ('bruksområde',),
'bruksplen': ('bruksplen',),
'bruksplenen': ('bruksplen',),
'bruksplener': ('bruksplen',),
'bruksplenene': ('bruksplen',),
'bruksplikt': ('bruksplikt',),
'bruksplikten': ('bruksplikt',),
'bruksplikta': ('bruksplikt',),
'bruksplikter': ('bruksplikt',),
'brukspliktene': ('bruksplikt',),
'bruksrett': ('bruksrett',),
'bruksretten': ('bruksrett',),
'bruksretter': ('bruksrett',),
'bruksrettene': ('bruksrett',),
'bruksskog': ('bruksskog',),
'bruksskogen': ('bruksskog',),
'bruksskoger': ('bruksskog',),
'bruksskogene': ('bruksskog',),
'brukstid': ('brukstid',),
'brukstiden': ('brukstid',),
'brukstida': ('brukstid',),
'brukstider': ('brukstid',),
'brukstidene': ('brukstid',),
'brukstjuveri': ('brukstjuveri',),
'brukstjuveriet': ('brukstjuveri',),
'brukstjuveri': ('brukstjuveri',),
'brukstjuverier': ('brukstjuveri',),
'brukstjuveri': ('brukstjuveri',),
'brukstjuverier': ('brukstjuveri',),
'brukstjuveria': ('brukstjuveri',),
'brukstjuveriene': ('brukstjuveri',),
'brukstyveri': ('brukstyveri',),
'brukstyveriet': ('brukstyveri',),
'brukstyveri': ('brukstyveri',),
'brukstyverier': ('brukstyveri',),
'brukstyveri': ('brukstyveri',),
'brukstyverier': ('brukstyveri',),
'brukstyveria': ('brukstyveri',),
'brukstyveriene': ('brukstyveri',),
'bruksverdi': ('bruksverdi',),
'bruksverdien': ('bruksverdi',),
'bruksverdier': ('bruksverdi',),
'bruksverdiene': ('bruksverdi',),
'bruktbil': ('bruktbil',),
'bruktbilen': ('bruktbil',),
'bruktbiler': ('bruktbil',),
'bruktbilene': ('bruktbil',),
'bruktbilforhandler': ('bruktbilforhandler',),
'bruktbilforhandleren': ('bruktbilforhandler',),
'bruktbilforhandlere': ('bruktbilforhandler',),
'bruktbilforhandlerne': ('bruktbilforhandler',),
'bruktbilmarked': ('bruktbilmarked',),
'bruktbilmarkedet': ('bruktbilmarked',),
'bruktbilmarked': ('bruktbilmarked',),
'bruktbilmarkeder': ('bruktbilmarked',),
'bruktbilmarked': ('bruktbilmarked',),
'bruktbilmarkeder': ('bruktbilmarked',),
'bruktbilmarkeda': ('bruktbilmarked',),
'bruktbilmarkedene': ('bruktbilmarked',),
'brulegger': ('brulegger',),
'bruleggeren': ('brulegger',),
'bruleggere': ('brulegger',),
'bruleggerne': ('brulegger',),
'brulegging': ('brulegging',),
'bruleggingen': ('brulegging',),
'brulegginga': ('brulegging',),
'brulegginger': ('brulegging',),
'bruleggingene': ('brulegging',),
'brulegning': ('brulegning',),
'brulegningen': ('brulegning',),
'brulegninga': ('brulegning',),
'brulegninger': ('brulegning',),
'brulegningene': ('brulegning',),
'brum': ('brum',),
'brummet': ('brum',),
'brum': ('brum',),
'brumma': ('brum',),
'brummene': ('brum',),
'brumlebasse': ('brumlebasse',),
'brumlebassen': ('brumlebasse',),
'brumlebasser': ('brumlebasse',),
'brumlebassene': ('brumlebasse',),
'brunalge': ('brunalge',),
'brunalgen': ('brunalge',),
'brunalger': ('brunalge',),
'brunalgene': ('brunalge',),
'brunbjørn': ('brunbjørn',),
'brunbjørnen': ('brunbjørn',),
'brunbjørner': ('brunbjørn',),
'brunbjørnene': ('brunbjørn',),
'bruneier': ('bruneier',),
'bruneieren': ('bruneier',),
'bruneiere': ('bruneier',),
'bruneierne': ('bruneier',),
'brunette': ('brunette',),
'brunetten': ('brunette',),
'brunetta': ('brunette',),
'brunetter': ('brunette',),
'brunettene': ('brunette',),
'brunfe': ('brunfe',),
'brunfeet': ('brunfe',),
'brunfe': ('brunfe',),
'brunfea': ('brunfe',),
'brunfeene': ('brunfe',),
'brunjernstein': ('brunjernstein',),
'brunjernsteinen': ('brunjernstein',),
'brunjernsteiner': ('brunjernstein',),
'brunjernsteinene': ('brunjernstein',),
'brunkol': ('brunkol',),
'brunkolet': ('brunkol',),
'brunkol': ('brunkol',),
'brunkola': ('brunkol',),
'brunkolene': ('brunkol',),
'brunkol': ('brunkol',),
'brunkolet': ('brunkol',),
'brunkol': ('brunkol',),
'brunkola': ('brunkol',),
'brunkoltjære': ('brunkoltjære',),
'brunkoltjæren': ('brunkoltjære',),
'brunkoltjæra': ('brunkoltjære',),
'brunkoltjærer': ('brunkoltjære',),
'brunkoltjærene': ('brunkoltjære',),
'brunkull': ('brunkull',),
'brunkullet': ('brunkull',),
'brunkull': ('brunkull',),
'brunkulla': ('brunkull',),
'brunkullene': ('brunkull',),
'brunkulltjære': ('brunkulltjære',),
'brunkulltjæren': ('brunkulltjære',),
'brunkulltjæra': ('brunkulltjære',),
'brunkulltjærer': ('brunkulltjære',),
'brunkulltjærene': ('brunkulltjære',),
'brunnakke': ('brunnakke',),
'brunnakken': ('brunnakke',),
'brunnakker': ('brunnakke',),
'brunnakkene': ('brunnakke',),
'brunost': ('brunost',),
'brunosten': ('brunost',),
'brunoster': ('brunost',),
'brunostene': ('brunost',),
'brunrot': ('brunrot',),
'brunroten': ('brunrot',),
'brunrota': ('brunrot',),
'brunrøtter': ('brunrot',),
'brunrøttene': ('brunrot',),
'brunsj': ('brunsj',),
'brunsjen': ('brunsj',),
'brunsjer': ('brunsj',),
'brunsjene': ('brunsj',),
'brunskjorte': ('brunskjorte',),
'brunskjorten': ('brunskjorte',),
'brunskjorta': ('brunskjorte',),
'brunskjorter': ('brunskjorte',),
'brunskjortene': ('brunskjorte',),
'brunst': ('brunst',),
'brunsten': ('brunst',),
'brunster': ('brunst',),
'brunstene': ('brunst',),
'brunstein': ('brunstein',),
'brunsteinen': ('brunstein',),
'brunsteiner': ('brunstein',),
'brunsteinene': ('brunstein',),
'brunsttid': ('brunsttid',),
'brunsttiden': ('brunsttid',),
'brunsttida': ('brunsttid',),
'brunsttider': ('brunsttid',),
'brunsttidene': ('brunsttid',),
'brunsukker': ('brunsukker',),
'brunsukkeret': ('brunsukker',),
'brunsukker': ('brunsukker',),
'brunsukkere': ('brunsukker',),
'brunsukkera': ('brunsukker',),
'brunsukkerne': ('brunsukker',),
'brunsukkera': ('brunsukker',),
'brunsukkerne': ('brunsukker',),
'brunt': ('brunt',),
'brunvare': ('brunvare',),
'brunvaren': ('brunvare',),
'brunvara': ('brunvare',),
'brunvarer': ('brunvare',),
'brunvarene': ('brunvare',),
'brupilar': ('brupilar',),
'brupilaren': ('brupilar',),
'brupilarer': ('brupilar',),
'brupilarene': ('brupilar',),
'brus': ('brus',),
'brusen': ('brus',),
'brus': ('brus',),
'brusene': ('brus',),
'brus': ('brus',),
'bruset': ('brus',),
'brus': ('brus',),
'brusa': ('brus',),
'brusene': ('brus',),
'brushane': ('brushane',),
'brushanen': ('brushane',),
'brushaner': ('brushane',),
'brushanene': ('brushane',),
'brushode': ('brushode',),
'brushodet': ('brushode',),
'brushoder': ('brushode',),
'brushoda': ('brushode',),
'brushodene': ('brushode',),
'brusk': ('brusk',),
'brusken': ('brusk',),
'brusker': ('brusk',),
'bruskene': ('brusk',),
'bruskfisk': ('bruskfisk',),
'bruskfisken': ('bruskfisk',),
'bruskfisker': ('bruskfisk',),
'bruskfiskene': ('bruskfisk',),
'bruskplate': ('bruskplate',),
'bruskplaten': ('bruskplate',),
'bruskplata': ('bruskplate',),
'bruskplater': ('bruskplate',),
'bruskplatene': ('bruskplate',),
'bruskskive': ('bruskskive',),
'bruskskiven': ('bruskskive',),
'bruskskiva': ('bruskskive',),
'bruskskiver': ('bruskskive',),
'bruskskivene': ('bruskskive',),
'bruskskjelett': ('bruskskjelett',),
'bruskskjelettet': ('bruskskjelett',),
'bruskskjelett': ('bruskskjelett',),
'bruskskjeletter': ('bruskskjelett',),
'bruskskjelett': ('bruskskjelett',),
'bruskskjeletter': ('bruskskjelett',),
'bruskskjeletta': ('bruskskjelett',),
'bruskskjelettene': ('bruskskjelett',),
'bruskvev': ('bruskvev',),
'bruskvevet': ('bruskvev',),
'bruskvev': ('bruskvev',),
'bruskveva': ('bruskvev',),
'bruskvevene': ('bruskvev',),
'bruspenn': ('bruspenn',),
'bruspennet': ('bruspenn',),
'bruspenn': ('bruspenn',),
'bruspenna': ('bruspenn',),
'bruspennene': ('bruspenn',),
'bruspulver': ('bruspulver',),
'bruspulveret': ('bruspulver',),
'bruspulver': ('bruspulver',),
'bruspulvere': ('bruspulver',),
'bruspulvera': ('bruspulver',),
'bruspulverne': ('bruspulver',),
'bruspulvera': ('bruspulver',),
'bruspulverne': ('bruspulver',),
'brusselknipling': ('brusselknipling',),
'brusselkniplingen': ('brusselknipling',),
'brusselkniplinger': ('brusselknipling',),
'brusselkniplingene': ('brusselknipling',),
'brusselteppe': ('brusselteppe',),
'brusselteppet': ('brusselteppe',),
'brusseltepper': ('brusselteppe',),
'brusselteppa': ('brusselteppe',),
'brusselteppene': ('brusselteppe',),
'brustein': ('brustein',),
'brusteinen': ('brustein',),
'brusteiner': ('brustein',),
'brusteinene': ('brustein',),
'brutalitet': ('brutalitet',),
'brutaliteten': ('brutalitet',),
'brutaliteter': ('brutalitet',),
'brutalitetene': ('brutalitet',),
'brutto': ('brutto',),
'bruttoen': ('brutto',),
'bruttoer': ('brutto',),
'bruttoene': ('brutto',),
'bruttoavling': ('bruttoavling',),
'bruttoavlingen': ('bruttoavling',),
'bruttoavlinga': ('bruttoavling',),
'bruttoavlinger': ('bruttoavling',),
'bruttoavlingene': ('bruttoavling',),
'bruttobeløp': ('bruttobeløp',),
'bruttobeløpet': ('bruttobeløp',),
'bruttobeløp': ('bruttobeløp',),
'bruttobeløpa': ('bruttobeløp',),
'bruttobeløpene': ('bruttobeløp',),
'bruttobudsjett': ('bruttobudsjett',),
'bruttobudsjettet': ('bruttobudsjett',),
'bruttobudsjett': ('bruttobudsjett',),
'bruttobudsjetter': ('bruttobudsjett',),
'bruttobudsjett': ('bruttobudsjett',),
'bruttobudsjetter': ('bruttobudsjett',),
'bruttobudsjetta': ('bruttobudsjett',),
'bruttobudsjettene': ('bruttobudsjett',),
'bruttoformue': ('bruttoformue',),
'bruttoformuen': ('bruttoformue',),
'bruttoformuer': ('bruttoformue',),
'bruttoformuene': ('bruttoformue',),
'bruttofortjeneste': ('bruttofortjeneste',),
'bruttofortjenesten': ('bruttofortjeneste',),
'bruttofortjenesta': ('bruttofortjeneste',),
'bruttofortjenester': ('bruttofortjeneste',),
'bruttofortjenestene': ('bruttofortjeneste',),
'bruttoinntekt': ('bruttoinntekt',),
'bruttoinntekten': ('bruttoinntekt',),
'bruttoinntekta': ('bruttoinntekt',),
'bruttoinntekter': ('bruttoinntekt',),
'bruttoinntektene': ('bruttoinntekt',),
'bruttonasjonalprodukt': ('bruttonasjonalprodukt',),
'bruttonasjonalproduktet': ('bruttonasjonalprodukt',),
'bruttonasjonalprodukt': ('bruttonasjonalprodukt',),
'bruttonasjonalprodukter': ('bruttonasjonalprodukt',),
'bruttonasjonalprodukt': ('bruttonasjonalprodukt',),
'bruttonasjonalprodukter': ('bruttonasjonalprodukt',),
'bruttonasjonalprodukta': ('bruttonasjonalprodukt',),
'bruttonasjonalproduktene': ('bruttonasjonalprodukt',),
'bruttoregistertonn': ('bruttoregistertonn',),
'bruttoregistertonnet': ('bruttoregistertonn',),
'bruttoregistertonn': ('bruttoregistertonn',),
'bruttoregistertonna': ('bruttoregistertonn',),
'bruttoregistertonnene': ('bruttoregistertonn',),
'bruttotonnasje': ('bruttotonnasje',),
'bruttotonnasjen': ('bruttotonnasje',),
'bruttotonnasjer': ('bruttotonnasje',),
'bruttotonnasjene': ('bruttotonnasje',),
'bruttovekt': ('bruttovekt',),
'bruttovekten': ('bruttovekt',),
'bruttovekta': ('bruttovekt',),
'bruttovekter': ('bruttovekt',),
'bruttovektene': ('bruttovekt',),
'bry': ('bry',),
'bryet': ('bry',),
'bry': ('bry',),
'brya': ('bry',),
'bryene': ('bry',),
'bryderi': ('bryderi',),
'bryderiet': ('bryderi',),
'bryderi': ('bryderi',),
'bryderier': ('bryderi',),
'bryderi': ('bryderi',),
'bryderier': ('bryderi',),
'bryderia': ('bryderi',),
'bryderiene': ('bryderi',),
'brygg': ('brygg',),
'brygget': ('brygg',),
'brygg': ('brygg',),
'brygga': ('brygg',),
'bryggene': ('brygg',),
'brygge': ('brygge',),
'bryggen': ('brygge',),
'brygga': ('brygge',),
'brygger': ('brygge',),
'bryggene': ('brygge',),
'bryggearbeider': ('bryggearbeider',),
'bryggearbeideren': ('bryggearbeider',),
'bryggearbeidere': ('bryggearbeider',),
'bryggearbeiderne': ('bryggearbeider',),
'bryggeavgift': ('bryggeavgift',),
'bryggeavgiften': ('bryggeavgift',),
'bryggeavgifta': ('bryggeavgift',),
'bryggeavgifter': ('bryggeavgift',),
'bryggeavgiftene': ('bryggeavgift',),
'bryggedans': ('bryggedans',),
'bryggedansen': ('bryggedans',),
'bryggedanser': ('bryggedans',),
'bryggedansene': ('bryggedans',),
'bryggekjel': ('bryggekjel',),
'bryggekjelen': ('bryggekjel',),
'bryggekjeler': ('bryggekjel',),
'bryggekjelene': ('bryggekjel',),
'bryggekjele': ('bryggekjele',),
'bryggekjelen': ('bryggekjele',),
'bryggekjeler': ('bryggekjele',),
'bryggekjelene': ('bryggekjele',),
'bryggepanne': ('bryggepanne',),
'bryggepannen': ('bryggepanne',),
'bryggepanna': ('bryggepanne',),
'bryggepanner': ('bryggepanne',),
'bryggepannene': ('bryggepanne',),
'brygger': ('brygger',),
'bryggeren': ('brygger',),
'bryggere': ('brygger',),
'bryggerne': ('brygger',),
'bryggerhest': ('bryggerhest',),
'bryggerhesten': ('bryggerhest',),
'bryggerhester': ('bryggerhest',),
'bryggerhestene': ('bryggerhest',),
'bryggerhus': ('bryggerhus',),
'bryggerhuset': ('bryggerhus',),
'bryggerhus': ('bryggerhus',),
'bryggerhusa': ('bryggerhus',),
'bryggerhusene': ('bryggerhus',),
'bryggeri': ('bryggeri',),
'bryggeriet': ('bryggeri',),
'bryggeri': ('bryggeri',),
'bryggerier': ('bryggeri',),
'bryggeri': ('bryggeri',),
'bryggerier': ('bryggeri',),
'bryggeria': ('bryggeri',),
'bryggeriene': ('bryggeri',),
'bryggerihest': ('bryggerihest',),
'bryggerihesten': ('bryggerihest',),
'bryggerihester': ('bryggerihest',),
'bryggerihestene': ('bryggerihest',),
'bryggesjauer': ('bryggesjauer',),
'bryggesjaueren': ('bryggesjauer',),
'bryggesjauere': ('bryggesjauer',),
'bryggesjauerne': ('bryggesjauer',),
'bryllup': ('bryllup',),
'bryllupet': ('bryllup',),
'bryllup': ('bryllup',),
'brylluper': ('bryllup',),
'bryllup': ('bryllup',),
'brylluper': ('bryllup',),
'bryllupa': ('bryllup',),
'bryllupene': ('bryllup',),
'bryllupsdag': ('bryllupsdag',),
'bryllupsdagen': ('bryllupsdag',),
'bryllupsdager': ('bryllupsdag',),
'bryllupsdagene': ('bryllupsdag',),
'bryllupsgave': ('bryllupsgave',),
'bryllupsgaven': ('bryllupsgave',),
'bryllupsgava': ('bryllupsgave',),
'bryllupsgaver': ('bryllupsgave',),
'bryllupsgavene': ('bryllupsgave',),
'bryllupsklokke': ('bryllupsklokke',),
'bryllupsklokken': ('bryllupsklokke',),
'bryllupsklokka': ('bryllupsklokke',),
'bryllupsklokker': ('bryllupsklokke',),
'bryllupsklokkene': ('bryllupsklokke',),
'bryllupsmarsj': ('bryllupsmarsj',),
'bryllupsmarsjen': ('bryllupsmarsj',),
'bryllupsmarsjer': ('bryllupsmarsj',),
'bryllupsmarsjene': ('bryllupsmarsj',),
'bryllupsnatt': ('bryllupsnatt',),
'bryllupsnatten': ('bryllupsnatt',),
'bryllupsnatta': ('bryllupsnatt',),
'bryllupsnetter': ('bryllupsnatt',),
'bryllupsnettene': ('bryllupsnatt',),
'bryllupsreise': ('bryllupsreise',),
'bryllupsreisen': ('bryllupsreise',),
'bryllupsreisa': ('bryllupsreise',),
'bryllupsreiser': ('bryllupsreise',),
'bryllupsreisene': ('bryllupsreise',),
'bryn': ('bryn',),
'brynet': ('bryn',),
'bryn': ('bryn',),
'bryna': ('bryn',),
'brynene': ('bryn',),
'brynde': ('brynde',),
'brynden': ('brynde',),
'brynder': ('brynde',),
'bryndene': ('brynde',),
'bryne': ('bryne',),
'brynet': ('bryne',),
'bryner': ('bryne',),
'bryna': ('bryne',),
'brynene': ('bryne',),
'brynje': ('brynje',),
'brynjen': ('brynje',),
'brynja': ('brynje',),
'brynjer': ('brynje',),
'brynjene': ('brynje',),
'bryolog': ('bryolog',),
'bryologen': ('bryolog',),
'bryologer': ('bryolog',),
'bryologene': ('bryolog',),
'bryologi': ('bryologi',),
'bryologien': ('bryologi',),
'bryologier': ('bryologi',),
'bryologiene': ('bryologi',),
'brysselerknipling': ('brysselerknipling',),
'brysselerkniplingen': ('brysselerknipling',),
'brysselerkniplinger': ('brysselerknipling',),
'brysselerkniplingene': ('brysselerknipling',),
'brysselerteppe': ('brysselerteppe',),
'brysselerteppet': ('brysselerteppe',),
'brysselertepper': ('brysselerteppe',),
'brysselerteppa': ('brysselerteppe',),
'brysselerteppene': ('brysselerteppe',),
'bryst': ('bryst',),
'brystet': ('bryst',),
'bryst': ('bryst',),
'bryster': ('bryst',),
'bryst': ('bryst',),
'bryster': ('bryst',),
'brysta': ('bryst',),
'brystene': ('bryst',),
'brystbarn': ('brystbarn',),
'brystbarnet': ('brystbarn',),
'brystbarn': ('brystbarn',),
'brystbarna': ('brystbarn',),
'brystbarnene': ('brystbarn',),
'brystbilde': ('brystbilde',),
'brystbildet': ('brystbilde',),
'brystbilder': ('brystbilde',),
'brystbilda': ('brystbilde',),
'brystbildene': ('brystbilde',),
'brysthinne': ('brysthinne',),
'brysthinnen': ('brysthinne',),
'brysthinna': ('brysthinne',),
'brysthinner': ('brysthinne',),
'brysthinnene': ('brysthinne',),
'brysthinnebetennelse': ('brysthinnebetennelse',),
'brysthinnebetennelsen': ('brysthinnebetennelse',),
'brysthinnebetennelser': ('brysthinnebetennelse',),
'brysthinnebetennelsene': ('brysthinnebetennelse',),
'brystholder': ('brystholder',),
'brystholderen': ('brystholder',),
'brystholdere': ('brystholder',),
'brystholderne': ('brystholder',),
'brysthole': ('brysthole',),
'brystholen': ('brysthole',),
'brysthola': ('brysthole',),
'brystholer': ('brysthole',),
'brystholene': ('brysthole',),
'brysthule': ('brysthule',),
'brysthulen': ('brysthule',),
'brysthula': ('brysthule',),
'brysthuler': ('brysthule',),
'brysthulene': ('brysthule',),
'brysthøyde': ('brysthøyde',),
'brysthøyden': ('brysthøyde',),
'brysthøyder': ('brysthøyde',),
'brysthøydene': ('brysthøyde',),
'brystkasse': ('brystkasse',),
'brystkassen': ('brystkasse',),
'brystkassa': ('brystkasse',),
'brystkasser': ('brystkasse',),
'brystkassene': ('brystkasse',),
'brystkreft': ('brystkreft',),
'brystkreften': ('brystkreft',),
'brystkrefter': ('brystkreft',),
'brystkreftene': ('brystkreft',),
'brystlomme': ('brystlomme',),
'brystlommen': ('brystlomme',),
'brystlomma': ('brystlomme',),
'brystlommer': ('brystlomme',),
'brystlommene': ('brystlomme',),
'brystmål': ('brystmål',),
'brystmålet': ('brystmål',),
'brystmål': ('brystmål',),
'brystmåla': ('brystmål',),
'brystmålene': ('brystmål',),
'brystning': ('brystning',),
'brystningen': ('brystning',),
'brystninga': ('brystning',),
'brystninger': ('brystning',),
'brystningene': ('brystning',),
'brystnål': ('brystnål',),
'brystnålen': ('brystnål',),
'brystnåla': ('brystnål',),
'brystnåler': ('brystnål',),
'brystnålene': ('brystnål',),
'brystsvømming': ('brystsvømming',),
'brystsvømmingen': ('brystsvømming',),
'brystsvømminga': ('brystsvømming',),
'brystsvømminger': ('brystsvømming',),
'brystsvømmingene': ('brystsvømming',),
'brysttone': ('brysttone',),
'brysttonen': ('brysttone',),
'brysttoner': ('brysttone',),
'brysttonene': ('brysttone',),
'brystvern': ('brystvern',),
'brystvernet': ('brystvern',),
'brystvern': ('brystvern',),
'brystverna': ('brystvern',),
'brystvernene': ('brystvern',),
'brystvirvel': ('brystvirvel',),
'brystvirvelen': ('brystvirvel',),
'brystvirvler': ('brystvirvel',),
'brystvirvlene': ('brystvirvel',),
'brystvorte': ('brystvorte',),
'brystvorten': ('brystvorte',),
'brystvorta': ('brystvorte',),
'brystvorter': ('brystvorte',),
'brystvortene': ('brystvorte',),
'brytbønne': ('brytbønne',),
'brytbønnen': ('brytbønne',),
'brytbønna': ('brytbønne',),
'brytbønner': ('brytbønne',),
'brytbønnene': ('brytbønne',),
'brytekamp': ('brytekamp',),
'brytekampen': ('brytekamp',),
'brytekamper': ('brytekamp',),
'brytekampene': ('brytekamp',),
'bryter': ('bryter',),
'bryteren': ('bryter',),
'brytere': ('bryter',),
'bryterne': ('bryter',),
'bryterpanel': ('bryterpanel',),
'bryterpanelet': ('bryterpanel',),
'bryterpanel': ('bryterpanel',),
'bryterpaneler': ('bryterpanel',),
'bryterpanel': ('bryterpanel',),
'bryterpaneler': ('bryterpanel',),
'bryterpanela': ('bryterpanel',),
'bryterpanelene': ('bryterpanel',),
'bryterskap': ('bryterskap',),
'bryterskapet': ('bryterskap',),
'bryterskap': ('bryterskap',),
'bryterskapa': ('bryterskap',),
'bryterskapene': ('bryterskap',),
'brytertak': ('brytertak',),
'brytertaket': ('brytertak',),
'brytertak': ('brytertak',),
'brytertaka': ('brytertak',),
'brytertakene': ('brytertak',),
'bryting': ('bryting',),
'brytingen': ('bryting',),
'brytinga': ('bryting',),
'brytinger': ('bryting',),
'brytingene': ('bryting',),
'brytingstid': ('brytingstid',),
'brytingstiden': ('brytingstid',),
'brytingstida': ('brytingstid',),
'brytingstider': ('brytingstid',),
'brytingstidene': ('brytingstid',),
'brytingsår': ('brytingsår',),
'brytingsåret': ('brytingsår',),
'brytingsår': ('brytingsår',),
'brytingsåra': ('brytingsår',),
'brytingsårene': ('brytingsår',),
'brytning': ('brytning',),
'brytningen': ('brytning',),
'brytninga': ('brytning',),
'brytninger': ('brytning',),
'brytningene': ('brytning',),
'brytningstid': ('brytningstid',),
'brytningstiden': ('brytningstid',),
'brytningstida': ('brytningstid',),
'brytningstider': ('brytningstid',),
'brytningstidene': ('brytningstid',),
'brytningsår': ('brytningsår',),
'brytningsåret': ('brytningsår',),
'brytningsår': ('brytningsår',),
'brytningsåra': ('brytningsår',),
'brytningsårene': ('brytningsår',),
'brådjup': ('brådjup',),
'brådjupet': ('brådjup',),
'brådjup': ('brådjup',),
'brådjupa': ('brådjup',),
'brådjupene': ('brådjup',),
'brådyp': ('brådyp',),
'brådypet': ('brådyp',),
'brådyp': ('brådyp',),
'brådypa': ('brådyp',),
'brådypene': ('brådyp',),
'bråhast': ('bråhast',),
'bråhasten': ('bråhast',),
'bråhaster': ('bråhast',),
'bråhastene': ('bråhast',),
'bråk': ('bråk',),
'bråket': ('bråk',),
'bråk': ('bråk',),
'bråka': ('bråk',),
'bråkene': ('bråk',),
'bråk': ('bråk',),
'bråken': ('bråk',),
'bråka': ('bråk',),
'bræker': ('bråk',),
'brækene': ('bråk',),
'bråkast': ('bråkast',),
'bråkastet': ('bråkast',),
'bråkast': ('bråkast',),
'bråkasta': ('bråkast',),
'bråkastene': ('bråkast',),
'bråkebøtte': ('bråkebøtte',),
'bråkebøtten': ('bråkebøtte',),
'bråkebøtta': ('bråkebøtte',),
'bråkebøtter': ('bråkebøtte',),
'bråkebøttene': ('bråkebøtte',),
'bråkmaker': ('bråkmaker',),
'bråkmakeren': ('bråkmaker',),
'bråkmakere': ('bråkmaker',),
'bråkmakerne': ('bråkmaker',),
'bråkulde': ('bråkulde',),
'bråkulden': ('bråkulde',),
'bråkulda': ('bråkulde',),
'bråkulder': ('bråkulde',),
'bråkuldene': ('bråkulde',),
'bråsinne': ('bråsinne',),
'bråsinnet': ('bråsinne',),
'bråsinner': ('bråsinne',),
'bråsinna': ('bråsinne',),
'bråsinnene': ('bråsinne',),
'bråte': ('bråte',),
'bråten': ('bråte',),
'bråter': ('bråte',),
'bråtene': ('bråte',),
'bråtebrann': ('bråtebrann',),
'bråtebrannen': ('bråtebrann',),
'bråtebranner': ('bråtebrann',),
'bråtebrannene': ('bråtebrann',),
'bråtebrenning': ('bråtebrenning',),
'bråtebrenningen': ('bråtebrenning',),
'bråtebrenninga': ('bråtebrenning',),
'bråtebrenninger': ('bråtebrenning',),
'bråtebrenningene': ('bråtebrenning',),
'bråterøyk': ('bråterøyk',),
'bråterøyken': ('bråterøyk',),
'bråterøyker': ('bråterøyk',),
'bråterøykene': ('bråterøyk',),
'brød': ('brød',),
'brødet': ('brød',),
'brød': ('brød',),
'brøda': ('brød',),
'brødene': ('brød',),
'brødbaking': ('brødbaking',),
'brødbakingen': ('brødbaking',),
'brødbakinga': ('brødbaking',),
'brødbakinger': ('brødbaking',),
'brødbakingene': ('brødbaking',),
'brødbakning': ('brødbakning',),
'brødbakningen': ('brødbakning',),
'brødbakninga': ('brødbakning',),
'brødbakninger': ('brødbakning',),
'brødbakningene': ('brødbakning',),
'brødbille': ('brødbille',),
'brødbillen': ('brødbille',),
'brødbiller': ('brødbille',),
'brødbillene': ('brødbille',),
'brødbit': ('brødbit',),
'brødbiten': ('brødbit',),
'brødbiter': ('brødbit',),
'brødbitene': ('brødbit',),
'brødblings': ('brødblings',),
'brødblingsen': ('brødblings',),
'brødblingser': ('brødblings',),
'brødblingsene': ('brødblings',),
'brøddeig': ('brøddeig',),
'brøddeigen': ('brøddeig',),
'brøddeiger': ('brøddeig',),
'brøddeigene': ('brøddeig',),
'brøde': ('brøde',),
'brøden': ('brøde',),
'brøder': ('brøde',),
'brødene': ('brøde',),
'brødfrukt': ('brødfrukt',),
'brødfrukten': ('brødfrukt',),
'brødfrukta': ('brødfrukt',),
'brødfrukter': ('brødfrukt',),
'brødfruktene': ('brødfrukt',),
'brødfrukttre': ('brødfrukttre',),
'brødfrukttreet': ('brødfrukttre',),
'brødfrukttre': ('brødfrukttre',),
'brødfrukttrær': ('brødfrukttre',),
'brødfrukttrea': ('brødfrukttre',),
'brødfrukttrærne': ('brødfrukttre',),
'brødnid': ('brødnid',),
'brødnidet': ('brødnid',),
'brødnid': ('brødnid',),
'brødnida': ('brødnid',),
'brødnidene': ('brødnid',),
'brødremenighet': ('brødremenighet',),
'brødremenigheten': ('brødremenighet',),
'brødremenigheta': ('brødremenighet',),
'brødremenigheter': ('brødremenighet',),
'brødremenighetene': ('brødremenighet',),
'brødrister': ('brødrister',),
'brødristeren': ('brødrister',),
'brødristere': ('brødrister',),
'brødristerne': ('brødrister',),
'brødskrift': ('brødskrift',),
'brødskriften': ('brødskrift',),
'brødskrifta': ('brødskrift',),
'brødskrifter': ('brødskrift',),
'brødskriftene': ('brødskrift',),
'brøk': ('brøk',),
'brøken': ('brøk',),
'brøker': ('brøk',),
'brøkene': ('brøk',),
'brøkdel': ('brøkdel',),
'brøkdelen': ('brøkdel',),
'brøkdeler': ('brøkdel',),
'brøkdelene': ('brøkdel',),
'brøkregning': ('brøkregning',),
'brøkregningen': ('brøkregning',),
'brøkregninga': ('brøkregning',),
'brøkregninger': ('brøkregning',),
'brøkregningene': ('brøkregning',),
'brøkstrek': ('brøkstrek',),
'brøkstreken': ('brøkstrek',),
'brøkstreker': ('brøkstrek',),
'brøkstrekene': ('brøkstrek',),
'brøl': ('brøl',),
'brølet': ('brøl',),
'brøl': ('brøl',),
'brøla': ('brøl',),
'brølene': ('brøl',),
'brølape': ('brølape',),
'brølapen': ('brølape',),
'brølapa': ('brølape',),
'brølaper': ('brølape',),
'brølapene': ('brølape',),
'brøleape': ('brøleape',),
'brøleapen': ('brøleape',),
'brøleapa': ('brøleape',),
'brøleaper': ('brøleape',),
'brøleapene': ('brøleape',),
'brøler': ('brøler',),
'brøleren': ('brøler',),
'brølere': ('brøler',),
'brølerne': ('brøler',),
'brønn': ('brønn',),
'brønnen': ('brønn',),
'brønner': ('brønn',),
'brønnene': ('brønn',),
'brønnbor': ('brønnbor',),
'brønnboren': ('brønnbor',),
'brønnboret': ('brønnbor',),
'brønnbor': ('brønnbor',),
'brønnborene': ('brønnbor',),
'brønnbora': ('brønnbor',),
'brønnborene': ('brønnbor',),
'brønnboring': ('brønnboring',),
'brønnboringen': ('brønnboring',),
'brønnboringa': ('brønnboring',),
'brønnboringer': ('brønnboring',),
'brønnboringene': ('brønnboring',),
'brønnbåt': ('brønnbåt',),
'brønnbåten': ('brønnbåt',),
'brønnbåter': ('brønnbåt',),
'brønnbåtene': ('brønnbåt',),
'brønnhode': ('brønnhode',),
'brønnhodet': ('brønnhode',),
'brønnhoder': ('brønnhode',),
'brønnhoda': ('brønnhode',),
'brønnhodene': ('brønnhode',),
'brønnhus': ('brønnhus',),
'brønnhuset': ('brønnhus',),
'brønnhus': ('brønnhus',),
'brønnhusa': ('brønnhus',),
'brønnhusene': ('brønnhus',),
'brønnkapasitet': ('brønnkapasitet',),
'brønnkapasiteten': ('brønnkapasitet',),
'brønnkapasiteter': ('brønnkapasitet',),
'brønnkapasitetene': ('brønnkapasitet',),
'brønnpisser': ('brønnpisser',),
'brønnpisseren': ('brønnpisser',),
'brønnpissere': ('brønnpisser',),
'brønnpisserne': ('brønnpisser',),
'brøst': ('brøst',),
'brøsten': ('brøst',),
'brøstet': ('brøst',),
'brøst': ('brøst',),
'brøstene': ('brøst',),
'brøsta': ('brøst',),
'brøstene': ('brøst',),
'brøyt': ('brøyt',),
'brøyten': ('brøyt',),
'brøyter': ('brøyt',),
'brøytene': ('brøyt',),
'brøytebil': ('brøytebil',),
'brøytebilen': ('brøytebil',),
'brøytebiler': ('brøytebil',),
'brøytebilene': ('brøytebil',),
'brøytekant': ('brøytekant',),
'brøytekanten': ('brøytekant',),
'brøytekanter': ('brøytekant',),
'brøytekantene': ('brøytekant',),
'bu': ('bu',),
'buet': ('bu',),
'bu': ('bu',),
'bua': ('bu',),
'buene': ('bu',),
'bu': ('bu',),
'buen': ('bu',),
'bua': ('bu',),
'buer': ('bu',),
'buene': ('bu',),
'bubestyrer': ('bubestyrer',),
'bubestyreren': ('bubestyrer',),
'bubestyrere': ('bubestyrer',),
'bubestyrerne': ('bubestyrer',),
'bud': ('bud',),
'budet': ('bud',),
'bud': ('bud',),
'buda': ('bud',),
'budene': ('bud',),
'budbringer': ('budbringer',),
'budbringeren': ('budbringer',),
'budbringere': ('budbringer',),
'budbringerne': ('budbringer',),
'budbærer': ('budbærer',),
'budbæreren': ('budbærer',),
'budbærere': ('budbærer',),
'budbærerne': ('budbærer',),
'buddha': ('buddha',),
'buddhaen': ('buddha',),
'buddhaer': ('buddha',),
'buddhaene': ('buddha',),
'buddhafigur': ('buddhafigur',),
'buddhafiguren': ('buddhafigur',),
'buddhafigurer': ('buddhafigur',),
'buddhafigurene': ('buddhafigur',),
'buddhatempel': ('buddhatempel',),
'buddhatempelet': ('buddhatempel',),
'buddhatemplet': ('buddhatempel',),
'buddhatempel': ('buddhatempel',),
'buddhatempler': ('buddhatempel',),
'buddhatempla': ('buddhatempel',),
'buddhatemplene': ('buddhatempel',),
'buddhatempla': ('buddhatempel',),
'buddhatemplene': ('buddhatempel',),
'buddhisme': ('buddhisme',),
'buddhismen': ('buddhisme',),
'buddhismer': ('buddhisme',),
'buddhismene': ('buddhisme',),
'buddhist': ('buddhist',),
'buddhisten': ('buddhist',),
'buddhister': ('buddhist',),
'buddhistene': ('buddhist',),
'buddhistmunk': ('buddhistmunk',),
'buddhistmunken': ('buddhistmunk',),
'buddhistmunker': ('buddhistmunk',),
'buddhistmunkene': ('buddhistmunk',),
'budeie': ('budeie',),
'budeien': ('budeie',),
'budeia': ('budeie',),
'budeier': ('budeie',),
'budeiene': ('budeie',),
'budoar': ('budoar',),
'budoaret': ('budoar',),
'budoar': ('budoar',),
'budoarer': ('budoar',),
'budoar': ('budoar',),
'budoarer': ('budoar',),
'budoara': ('budoar',),
'budoarene': ('budoar',),
'budrått': ('budrått',),
'budråtten': ('budrått',),
'budråtter': ('budrått',),
'budråttene': ('budrått',),
'budsjett': ('budsjett',),
'budsjettet': ('budsjett',),
'budsjett': ('budsjett',),
'budsjetter': ('budsjett',),
'budsjett': ('budsjett',),
'budsjetter': ('budsjett',),
'budsjetta': ('budsjett',),
'budsjettene': ('budsjett',),
'budsjett-termin': ('budsjett-termin',),
'budsjett-terminen': ('budsjett-termin',),
'budsjett-terminer': ('budsjett-termin',),
'budsjett-terminene': ('budsjett-termin',),
'budsjettbehandling': ('budsjettbehandling',),
'budsjettbehandlingen': ('budsjettbehandling',),
'budsjettbehandlinga': ('budsjettbehandling',),
'budsjettbehandlinger': ('budsjettbehandling',),
'budsjettbehandlingene': ('budsjettbehandling',),
'budsjettermin': ('budsjettermin',),
'budsjetterminen': ('budsjettermin',),
'budsjetterminer': ('budsjettermin',),
'budsjetterminene': ('budsjettermin',),
'budsjettforslag': ('budsjettforslag',),
'budsjettforslaget': ('budsjettforslag',),
'budsjettforslag': ('budsjettforslag',),
'budsjettforslaga': ('budsjettforslag',),
'budsjettforslagene': ('budsjettforslag',),
'budskap': ('budskap',),
'budskapet': ('budskap',),
'budskap': ('budskap',),
'budskaper': ('budskap',),
'budskap': ('budskap',),
'budskaper': ('budskap',),
'budskapa': ('budskap',),
'budskapene': ('budskap',),
'budskapsdag': ('budskapsdag',),
'budskapsdagen': ('budskapsdag',),
'budskapsdager': ('budskapsdag',),
'budskapsdagene': ('budskapsdag',),
'budstikke': ('budstikke',),
'budstikken': ('budstikke',),
'budstikka': ('budstikke',),
'budstikker': ('budstikke',),
'budstikkene': ('budstikke',),
'bue': ('bue',),
'buen': ('bue',),
'buer': ('bue',),
'buene': ('bue',),
'buebro': ('buebro',),
'buebroen': ('buebro',),
'buebroa': ('buebro',),
'buebroer': ('buebro',),
'buebroene': ('buebro',),
'buebru': ('buebru',),
'buebruen': ('buebru',),
'buebrua': ('buebru',),
'buebruer': ('buebru',),
'buebruene': ('buebru',),
'buegang': ('buegang',),
'buegangen': ('buegang',),
'bueganger': ('buegang',),
'buegangene': ('buegang',),
'buegrad': ('buegrad',),
'buegraden': ('buegrad',),
'buegrader': ('buegrad',),
'buegradene': ('buegrad',),
'buekorps': ('buekorps',),
'buekorpset': ('buekorps',),
'buekorps': ('buekorps',),
'buekorpsa': ('buekorps',),
'buekorpsene': ('buekorps',),
'bueminutt': ('bueminutt',),
'bueminuttet': ('bueminutt',),
'bueminutt': ('bueminutt',),
'bueminutter': ('bueminutt',),
'bueminutt': ('bueminutt',),
'bueminutter': ('bueminutt',),
'bueminutta': ('bueminutt',),
'bueminuttene': ('bueminutt',),
'bueparentes': ('bueparentes',),
'bueparentesen': ('bueparentes',),
'bueparenteser': ('bueparentes',),
'bueparentesene': ('bueparentes',),
'buesag': ('buesag',),
'buesagen': ('buesag',),
'buesaga': ('buesag',),
'buesager': ('buesag',),
'buesagene': ('buesag',),
'buesekund': ('buesekund',),
'buesekundet': ('buesekund',),
'buesekund': ('buesekund',),
'buesekunder': ('buesekund',),
'buesekund': ('buesekund',),
'buesekunder': ('buesekund',),
'buesekunda': ('buesekund',),
'buesekundene': ('buesekund',),
'buestreng': ('buestreng',),
'buestrengen': ('buestreng',),
'buestrenger': ('buestreng',),
'buestrengene': ('buestreng',),
'buetak': ('buetak',),
'buetaket': ('buetak',),
'buetak': ('buetak',),
'buetaka': ('buetak',),
'buetakene': ('buetak',),
'buevindu': ('buevindu',),
'buevinduet': ('buevindu',),
'buevindu': ('buevindu',),
'buevinduer': ('buevindu',),
'buevindu': ('buevindu',),
'buevinduer': ('buevindu',),
'buevindua': ('buevindu',),
'buevinduene': ('buevindu',),
'bufar': ('bufar',),
'bufaren': ('bufar',),
'bufarer': ('bufar',),
'bufarene': ('bufar',),
'bufardag': ('bufardag',),
'bufardagen': ('bufardag',),
'bufardager': ('bufardag',),
'bufardagene': ('bufardag',),
'bufe': ('bufe',),
'bufeet': ('bufe',),
'bufe': ('bufe',),
'bufea': ('bufe',),
'bufeene': ('bufe',),
'bufellesskap': ('bufellesskap',),
'bufellesskapet': ('bufellesskap',),
'bufellesskap': ('bufellesskap',),
'bufellesskaper': ('bufellesskap',),
'bufellesskap': ('bufellesskap',),
'bufellesskaper': ('bufellesskap',),
'bufellesskapa': ('bufellesskap',),
'bufellesskapene': ('bufellesskap',),
'buffé': ('buffé',),
'bufféen': ('buffé',),
'buffeen': ('buffé',),
'bufféer': ('buffé',),
'buffeer': ('buffé',),
'bufféene': ('buffé',),
'buffeene': ('buffé',),
'buffer': ('buffer',),
'bufferen': ('buffer',),
'buffere': ('buffer',),
'bufferne': ('buffer',),
'buffersone': ('buffersone',),
'buffersonen': ('buffersone',),
'buffersona': ('buffersone',),
'buffersoner': ('buffersone',),
'buffersonene': ('buffersone',),
'bufferstat': ('bufferstat',),
'bufferstaten': ('bufferstat',),
'bufferstater': ('bufferstat',),
'bufferstatene': ('bufferstat',),
'buffo': ('buffo',),
'buffoen': ('buffo',),
'buffoer': ('buffo',),
'buffoene': ('buffo',),
'buffoopera': ('buffoopera',),
'buffooperaen': ('buffoopera',),
'buffooperaer': ('buffoopera',),
'buffooperaene': ('buffoopera',),
'buflate': ('buflate',),
'buflaten': ('buflate',),
'buflata': ('buflate',),
'buflater': ('buflate',),
'buflatene': ('buflate',),
'buform': ('buform',),
'buformen': ('buform',),
'buforma': ('buform',),
'buformer': ('buform',),
'buformene': ('buform',),
'buhund': ('buhund',),
'buhunden': ('buhund',),
'buhunder': ('buhund',),
'buhundene': ('buhund',),
'buk': ('buk',),
'buken': ('buk',),
'buker': ('buk',),
'bukene': ('buk',),
'buké': ('buké',),
'bukéen': ('buké',),
'bukeen': ('buké',),
'bukéer': ('buké',),
'bukeer': ('buké',),
'bukéene': ('buké',),
'bukeene': ('buké',),
'bukett': ('bukett',),
'buketten': ('bukett',),
'buketter': ('bukett',),
'bukettene': ('bukett',),
'bukgjord': ('bukgjord',),
'bukgjorden': ('bukgjord',),
'bukgjorda': ('bukgjord',),
'bukgjorder': ('bukgjord',),
'bukgjordene': ('bukgjord',),
'bukhinne': ('bukhinne',),
'bukhinnen': ('bukhinne',),
'bukhinna': ('bukhinne',),
'bukhinner': ('bukhinne',),
'bukhinnene': ('bukhinne',),
'bukhinnebetennelse': ('bukhinnebetennelse',),
'bukhinnebetennelsen': ('bukhinnebetennelse',),
'bukhinnebetennelser': ('bukhinnebetennelse',),
'bukhinnebetennelsene': ('bukhinnebetennelse',),
'bukhole': ('bukhole',),
'bukholen': ('bukhole',),
'bukhola': ('bukhole',),
'bukholer': ('bukhole',),
'bukholene': ('bukhole',),
'bukhule': ('bukhule',),
'bukhulen': ('bukhule',),
'bukhula': ('bukhule',),
'bukhuler': ('bukhule',),
'bukhulene': ('bukhule',),
'bukk': ('bukk',),
'bukken': ('bukk',),
'bukker': ('bukk',),
'bukkene': ('bukk',),
'bukk': ('bukk',),
'bukket': ('bukk',),
'bukk': ('bukk',),
'bukka': ('bukk',),
'bukkene': ('bukk',),
'bukkebein': ('bukkebein',),
'bukkebeinet': ('bukkebein',),
'bukkebein': ('bukkebein',),
'bukkebeina': ('bukkebein',),
'bukkebeinene': ('bukkebein',),
'bukkeben': ('bukkeben',),
'bukkebenet': ('bukkeben',),
'bukkeben': ('bukkeben',),
'bukkebena': ('bukkeben',),
'bukkebenene': ('bukkeben',),
'bukkeblad': ('bukkeblad',),
'bukkebladet': ('bukkeblad',),
'bukkeblad': ('bukkeblad',),
'bukkeblader': ('bukkeblad',),
'bukkeblad': ('bukkeblad',),
'bukkeblader': ('bukkeblad',),
'bukkeblada': ('bukkeblad',),
'bukkebladene': ('bukkeblad',),
'bukkehorn': ('bukkehorn',),
'bukkehornet': ('bukkehorn',),
'bukkehorn': ('bukkehorn',),
'bukkehorna': ('bukkehorn',),
'bukkehornene': ('bukkehorn',),
'bukkel': ('bukkel',),
'bukkelen': ('bukkel',),
'bukler': ('bukkel',),
'buklene': ('bukkel',),
'bukkeskjegg': ('bukkeskjegg',),
'bukkeskjegget': ('bukkeskjegg',),
'bukkeskjegg': ('bukkeskjegg',),
'bukkeskjegga': ('bukkeskjegg',),
'bukkeskjeggene': ('bukkeskjegg',),
'buklist': ('buklist',),
'buklisten': ('buklist',),
'buklista': ('buklist',),
'buklister': ('buklist',),
'buklistene': ('buklist',),
'bukollektiv': ('bukollektiv',),
'bukollektivet': ('bukollektiv',),
'bukollektiv': ('bukollektiv',),
'bukollektiver': ('bukollektiv',),
'bukollektiv': ('bukollektiv',),
'bukollektiver': ('bukollektiv',),
'bukollektiva': ('bukollektiv',),
'bukollektivene': ('bukollektiv',),
'bukreditt': ('bukreditt',),
'bukreditten': ('bukreditt',),
'bukreditter': ('bukreditt',),
'bukredittene': ('bukreditt',),
'buksbom': ('buksbom',),
'buksbommen': ('buksbom',),
'buksbommer': ('buksbom',),
'buksbommene': ('buksbom',),
'buksbomhekk': ('buksbomhekk',),
'buksbomhekken': ('buksbomhekk',),
'buksbomhekker': ('buksbomhekk',),
'buksbomhekkene': ('buksbomhekk',),
'bukse': ('bukse',),
'buksen': ('bukse',),
'buksa': ('bukse',),
'bukser': ('bukse',),
'buksene': ('bukse',),
'buksebak': ('buksebak',),
'buksebaken': ('buksebak',),
'buksebaker': ('buksebak',),
'buksebakene': ('buksebak',),
'buksebein': ('buksebein',),
'buksebeinet': ('buksebein',),
'buksebein': ('buksebein',),
'buksebeina': ('buksebein',),
'buksebeinene': ('buksebein',),
'bukseben': ('bukseben',),
'buksebenet': ('bukseben',),
'bukseben': ('bukseben',),
'buksebena': ('bukseben',),
'buksebenene': ('bukseben',),
'buksedrakt': ('buksedrakt',),
'buksedrakten': ('buksedrakt',),
'buksedrakta': ('buksedrakt',),
'buksedrakter': ('buksedrakt',),
'buksedraktene': ('buksedrakt',),
'buksedress': ('buksedress',),
'buksedressen': ('buksedress',),
'buksedresser': ('buksedress',),
'buksedressene': ('buksedress',),
'bukselomme': ('bukselomme',),
'bukselommen': ('bukselomme',),
'bukselomma': ('bukselomme',),
'bukselommer': ('bukselomme',),
'bukselommene': ('bukselomme',),
'bukserbåt': ('bukserbåt',),
'bukserbåten': ('bukserbåt',),
'bukserbåter': ('bukserbåt',),
'bukserbåtene': ('bukserbåt',),
'buksesele': ('buksesele',),
'bukseselen': ('buksesele',),
'bukseseler': ('buksesele',),
'bukseselene': ('buksesele',),
'bukseskjørt': ('bukseskjørt',),
'bukseskjørtet': ('bukseskjørt',),
'bukseskjørt': ('bukseskjørt',),
'bukseskjørter': ('bukseskjørt',),
'bukseskjørt': ('bukseskjørt',),
'bukseskjørter': ('bukseskjørt',),
'bukseskjørta': ('bukseskjørt',),
'bukseskjørtene': ('bukseskjørt',),
'buksesmekk': ('buksesmekk',),
'buksesmekken': ('buksesmekk',),
'buksesmekker': ('buksesmekk',),
'buksesmekkene': ('buksesmekk',),
'bukspytt': ('bukspytt',),
'bukspyttet': ('bukspytt',),
'bukspytt': ('bukspytt',),
'bukspytta': ('bukspytt',),
'bukspyttene': ('bukspytt',),
'bukspyttkjertel': ('bukspyttkjertel',),
'bukspyttkjertelen': ('bukspyttkjertel',),
'bukspyttkjertler': ('bukspyttkjertel',),
'bukspyttkjertlene': ('bukspyttkjertel',),
'bukt': ('bukt',),
'bukten': ('bukt',),
'bukta': ('bukt',),
'bukter': ('bukt',),
'buktene': ('bukt',),
'buktaler': ('buktaler',),
'buktaleren': ('buktaler',),
'buktalere': ('buktaler',),
'buktalerne': ('buktaler',),
'buktning': ('buktning',),
'buktningen': ('buktning',),
'buktninga': ('buktning',),
'buktninger': ('buktning',),
'buktningene': ('buktning',),
'bukvirvel': ('bukvirvel',),
'bukvirvelen': ('bukvirvel',),
'bukvirvler': ('bukvirvel',),
'bukvirvlene': ('bukvirvel',),
'bulb': ('bulb',),
'bulben': ('bulb',),
'bulber': ('bulb',),
'bulbene': ('bulb',),
'bulder': ('bulder',),
'bulderet': ('bulder',),
'buldret': ('bulder',),
'bulder': ('bulder',),
'buldre': ('bulder',),
'buldra': ('bulder',),
'buldrene': ('bulder',),
'buldra': ('bulder',),
'buldrene': ('bulder',),
'buldrebasse': ('buldrebasse',),
'buldrebassen': ('buldrebasse',),
'buldrebasser': ('buldrebasse',),
'buldrebassene': ('buldrebasse',),
'bule': ('bule',),
'bulen': ('bule',),
'buler': ('bule',),
'bulene': ('bule',),
'bule': ('bule',),
'bulen': ('bule',),
'bula': ('bule',),
'buler': ('bule',),
'bulene': ('bule',),
'bulevard': ('bulevard',),
'bulevarden': ('bulevard',),
'bulevarder': ('bulevard',),
'bulevardene': ('bulevard',),
'bulevardavis': ('bulevardavis',),
'bulevardavisen': ('bulevardavis',),
'bulevardavisa': ('bulevardavis',),
'bulevardaviser': ('bulevardavis',),
'bulevardavisene': ('bulevardavis',),
'bulgarer': ('bulgarer',),
'bulgareren': ('bulgarer',),
'bulgarere': ('bulgarer',),
'bulgarerne': ('bulgarer',),
'bulgarsk': ('bulgarsk',),
'bulgarsken': ('bulgarsk',),
'bulgarsker': ('bulgarsk',),
'bulgarskene': ('bulgarsk',),
'bulimi': ('bulimi',),
'bulimien': ('bulimi',),
'bulimier': ('bulimi',),
'bulimiene': ('bulimi',),
'bulimiker': ('bulimiker',),
'bulimikeren': ('bulimiker',),
'bulimikere': ('bulimiker',),
'bulimikerne': ('bulimiker',),
'buljong': ('buljong',),
'buljongen': ('buljong',),
'buljonger': ('buljong',),
'buljongene': ('buljong',),
'buljongpar': ('buljongpar',),
'buljongparet': ('buljongpar',),
'buljongpar': ('buljongpar',),
'buljongpara': ('buljongpar',),
'buljongparene': ('buljongpar',),
'buljongterning': ('buljongterning',),
'buljongterningen': ('buljongterning',),
'buljongterninger': ('buljongterning',),
'buljongterningene': ('buljongterning',),
'bulkbil': ('bulkbil',),
'bulkbilen': ('bulkbil',),
'bulkbiler': ('bulkbil',),
'bulkbilene': ('bulkbil',),
'bulkcarrier': ('bulkcarrier',),
'bulkcarrieren': ('bulkcarrier',),
'bulkcarriere': ('bulkcarrier',),
'bulkcarrierne': ('bulkcarrier',),
'bulklast': ('bulklast',),
'bulklasten': ('bulklast',),
'bulklasta': ('bulklast',),
'bulklaster': ('bulklast',),
'bulklastene': ('bulklast',),
'bulkskip': ('bulkskip',),
'bulkskipet': ('bulkskip',),
'bulkskip': ('bulkskip',),
'bulkskipa': ('bulkskip',),
'bulkskipene': ('bulkskip',),
'bulldogg': ('bulldogg',),
'bulldoggen': ('bulldogg',),
'bulldogger': ('bulldogg',),
'bulldoggene': ('bulldogg',),
'bulldoggansikt': ('bulldoggansikt',),
'bulldoggansiktet': ('bulldoggansikt',),
'bulldoggansikt': ('bulldoggansikt',),
'bulldoggansikter': ('bulldoggansikt',),
'bulldoggansikt': ('bulldoggansikt',),
'bulldoggansikter': ('bulldoggansikt',),
'bulldoggansikta': ('bulldoggansikt',),
'bulldoggansiktene': ('bulldoggansikt',),
'bulldoser': ('bulldoser',),
'bulldoseren': ('bulldoser',),
'bulldosere': ('bulldoser',),
'bulldoserne': ('bulldoser',),
'bulle': ('bulle',),
'bullen': ('bulle',),
'buller': ('bulle',),
'bullene': ('bulle',),
'bulletin': ('bulletin',),
'bulletinen': ('bulletin',),
'bulletiner': ('bulletin',),
'bulletinene': ('bulletin',),
'bulmeurt': ('bulmeurt',),
'bulmeurten': ('bulmeurt',),
'bulmeurta': ('bulmeurt',),
'bulmeurter': ('bulmeurt',),
'bulmeurtene': ('bulmeurt',),
'bulter': ('bulter',),
'bumaskin': ('bumaskin',),
'bumaskinen': ('bumaskin',),
'bumaskiner': ('bumaskin',),
'bumaskinene': ('bumaskin',),
'bumerang': ('bumerang',),
'bumerangen': ('bumerang',),
'bumeranger': ('bumerang',),
'bumerangene': ('bumerang',),
'bumerke': ('bumerke',),
'bumerket': ('bumerke',),
'bumerker': ('bumerke',),
'bumerka': ('bumerke',),
'bumerkene': ('bumerke',),
'bumse': ('bumse',),
'bumsen': ('bumse',),
'bumsa': ('bumse',),
'bumser': ('bumse',),
'bumsene': ('bumse',),
'bunad': ('bunad',),
'bunaden': ('bunad',),
'bunader': ('bunad',),
'bunadene': ('bunad',),
'bunadskjorte': ('bunadskjorte',),
'bunadskjorten': ('bunadskjorte',),
'bunadskjorta': ('bunadskjorte',),
'bunadskjorter': ('bunadskjorte',),
'bunadskjortene': ('bunadskjorte',),
'bunadsko': ('bunadsko',),
'bunadskoen': ('bunadsko',),
'bunadsko': ('bunadsko',),
'bunadskoa': ('bunadsko',),
'bunadskoene': ('bunadsko',),
'bunadsskjorte': ('bunadsskjorte',),
'bunadsskjorten': ('bunadsskjorte',),
'bunadsskjorta': ('bunadsskjorte',),
'bunadsskjorter': ('bunadsskjorte',),
'bunadsskjortene': ('bunadsskjorte',),
'bunadssko': ('bunadssko',),
'bunadsskoen': ('bunadssko',),
'bunadssko': ('bunadssko',),
'bunadsskoa': ('bunadssko',),
'bunadsskoene': ('bunadssko',),
'bunadssølv': ('bunadssølv',),
'bunadssølvet': ('bunadssølv',),
'bunadssølv': ('bunadssølv',),
'bunadssølva': ('bunadssølv',),
'bunadssølvene': ('bunadssølv',),
'bunadsølv': ('bunadsølv',),
'bunadsølvet': ('bunadsølv',),
'bunadsølv': ('bunadsølv',),
'bunadsølva': ('bunadsølv',),
'bunadsølvene': ('bunadsølv',),
'bunding': ('bunding',),
'bundingen': ('bunding',),
'bundinger': ('bunding',),
'bundingene': ('bunding',),
'bundsforvant': ('bundsforvant',),
'bundsforvanten': ('bundsforvant',),
'bundsforvante': ('bundsforvant',),
'bundsforvantene': ('bundsforvant',),
'bungalow': ('bungalow',),
'bungalowen': ('bungalow',),
'bungalower': ('bungalow',),
'bungalowene': ('bungalow',),
'bunke': ('bunke',),
'bunken': ('bunke',),
'bunker': ('bunke',),
'bunkene': ('bunke',),
'bunker': ('bunker',),
'bunkeren': ('bunker',),
'bunkere': ('bunker',),
'bunkerne': ('bunker',),
'bunkers': ('bunkers',),
'bunkersen': ('bunkers',),
'bunkers': ('bunkers',),
'bunkersene': ('bunkers',),
'bunn': ('bunn',),
'bunnen': ('bunn',),
'bunner': ('bunn',),
'bunnene': ('bunn',),
'bunn-nivå': ('bunn-nivå',),
'bunn-nivået': ('bunn-nivå',),
'bunn-nivå': ('bunn-nivå',),
'bunn-nivåer': ('bunn-nivå',),
'bunn-nivå': ('bunn-nivå',),
'bunn-nivåer': ('bunn-nivå',),
'bunn-nivåa': ('bunn-nivå',),
'bunn-nivåene': ('bunn-nivå',),
'bunnband': ('bunnband',),
'bunnbandet': ('bunnband',),
'bunnband': ('bunnband',),
'bunnbanda': ('bunnband',),
'bunnbandene': ('bunnband',),
'bunnbord': ('bunnbord',),
'bunnbordet': ('bunnbord',),
'bunnbord': ('bunnbord',),
'bunnborder': ('bunnbord',),
'bunnbord': ('bunnbord',),
'bunnborder': ('bunnbord',),
'bunnborda': ('bunnbord',),
'bunnbordene': ('bunnbord',),
'bunnbånd': ('bunnbånd',),
'bunnbåndet': ('bunnbånd',),
'bunnbånd': ('bunnbånd',),
'bunnbånda': ('bunnbånd',),
'bunnbåndene': ('bunnbånd',),
'bunnfall': ('bunnfall',),
'bunnfallet': ('bunnfall',),
'bunnfall': ('bunnfall',),
'bunnfalla': ('bunnfall',),
'bunnfallene': ('bunnfall',),
'bunnfisk': ('bunnfisk',),
'bunnfisken': ('bunnfisk',),
'bunnfisker': ('bunnfisk',),
'bunnfiskene': ('bunnfisk',),
'bunnflate': ('bunnflate',),
'bunnflaten': ('bunnflate',),
'bunnflata': ('bunnflate',),
'bunnflater': ('bunnflate',),
'bunnflatene': ('bunnflate',),
'bunnivå': ('bunnivå',),
'bunnivået': ('bunnivå',),
'bunnivå': ('bunnivå',),
'bunnivåer': ('bunnivå',),
'bunnivå': ('bunnivå',),
'bunnivåer': ('bunnivå',),
'bunnivåa': ('bunnivå',),
'bunnivåene': ('bunnivå',),
'bunnlag': ('bunnlag',),
'bunnlaget': ('bunnlag',),
'bunnlag': ('bunnlag',),
'bunnlaga': ('bunnlag',),
'bunnlagene': ('bunnlag',),
'bunnløshet': ('bunnløshet',),
'bunnløsheten': ('bunnløshet',),
'bunnløsheta': ('bunnløshet',),
'bunnløsheter': ('bunnløshet',),
'bunnløshetene': ('bunnløshet',),
'bunnløyse': ('bunnløyse',),
'bunnløysen': ('bunnløyse',),
'bunnløysa': ('bunnløyse',),
'bunnløyser': ('bunnløyse',),
'bunnløysene': ('bunnløyse',),
'bunnmorene': ('bunnmorene',),
'bunnmorenen': ('bunnmorene',),
'bunnmorener': ('bunnmorene',),
'bunnmorenene': ('bunnmorene',),
'bunnpanne': ('bunnpanne',),
'bunnpannen': ('bunnpanne',),
'bunnpanna': ('bunnpanne',),
'bunnpanner': ('bunnpanne',),
'bunnpannene': ('bunnpanne',),
'bunnrekord': ('bunnrekord',),
'bunnrekorden': ('bunnrekord',),
'bunnrekorder': ('bunnrekord',),
'bunnrekordene': ('bunnrekord',),
'bunnstoff': ('bunnstoff',),
'bunnstoffet': ('bunnstoff',),
'bunnstoff': ('bunnstoff',),
'bunnstoffer': ('bunnstoff',),
'bunnstoff': ('bunnstoff',),
'bunnstoffer': ('bunnstoff',),
'bunnstoffa': ('bunnstoff',),
'bunnstoffene': ('bunnstoff',),
'bunnstrid': ('bunnstrid',),
'bunnstriden': ('bunnstrid',),
'bunnstrider': ('bunnstrid',),
'bunnstridene': ('bunnstrid',),
'bunsenbrenner': ('bunsenbrenner',),
'bunsenbrenneren': ('bunsenbrenner',),
'bunsenbrennere': ('bunsenbrenner',),
'bunsenbrennerne': ('bunsenbrenner',),
'bunt': ('bunt',),
'bunten': ('bunt',),
'bunter': ('bunt',),
'buntene': ('bunt',),
'buntmaker': ('buntmaker',),
'buntmakeren': ('buntmaker',),
'buntmakere': ('buntmaker',),
'buntmakerne': ('buntmaker',),
'buorm': ('buorm',),
'buormen': ('buorm',),
'buormer': ('buorm',),
'buormene': ('buorm',),
'buplikt': ('buplikt',),
'buplikten': ('buplikt',),
'buplikta': ('buplikt',),
'buplikter': ('buplikt',),
'bupliktene': ('buplikt',),
'bur': ('bur',),
'buret': ('bur',),
'bur': ('bur',),
'bura': ('bur',),
'burene': ('bur',),
'bureiser': ('bureiser',),
'bureiseren': ('bureiser',),
'bureisere': ('bureiser',),
'bureiserne': ('bureiser',),
'bureising': ('bureising',),
'bureisingen': ('bureising',),
'bureisinga': ('bureising',),
'bureisinger': ('bureising',),
'bureisingene': ('bureising',),
'burettslag': ('burettslag',),
'burettslaget': ('burettslag',),
'burettslag': ('burettslag',),
'burettslaga': ('burettslag',),
'burettslagene': ('burettslag',),
'burfugl': ('burfugl',),
'burfuglen': ('burfugl',),
'burfugler': ('burfugl',),
'burfuglene': ('burfugl',),
'burger': ('burger',),
'burgeren': ('burger',),
'burgere': ('burger',),
'burgerne': ('burger',),
'burgunder': ('burgunder',),
'burgunderen': ('burgunder',),
'burgundere': ('burgunder',),
'burgunderne': ('burgunder',),
'burgundervin': ('burgundervin',),
'burgundervinen': ('burgundervin',),
'burgunderviner': ('burgundervin',),
'burgundervinene': ('burgundervin',),
'burhøne': ('burhøne',),
'burhønen': ('burhøne',),
'burhøna': ('burhøne',),
'burhøner': ('burhøne',),
'burhønene': ('burhøne',),
'burjat': ('burjat',),
'burjaten': ('burjat',),
'burjater': ('burjat',),
'burjatene': ('burjat',),
'burkiner': ('burkiner',),
'burkineren': ('burkiner',),
'burkinere': ('burkiner',),
'burkinerne': ('burkiner',),
'burkne': ('burkne',),
'burknen': ('burkne',),
'burkner': ('burkne',),
'burknene': ('burkne',),
'burloft': ('burloft',),
'burloftet': ('burloft',),
'burloft': ('burloft',),
'burlofta': ('burloft',),
'burloftene': ('burloft',),
'burnus': ('burnus',),
'burnusen': ('burnus',),
'burnuser': ('burnus',),
'burnusene': ('burnus',),
'burot': ('burot',),
'buroten': ('burot',),
'burota': ('burot',),
'burot': ('burot',),
'burotene': ('burot',),
'bursdag': ('bursdag',),
'bursdagen': ('bursdag',),
'bursdager': ('bursdag',),
'bursdagene': ('bursdag',),
'bursjoa': ('bursjoa',),
'bursjoaen': ('bursjoa',),
'bursjoaer': ('bursjoa',),
'bursjoaene': ('bursjoa',),
'bursjoasi': ('bursjoasi',),
'bursjoasiet': ('bursjoasi',),
'bursjoasi': ('bursjoasi',),
'bursjoasier': ('bursjoasi',),
'bursjoasi': ('bursjoasi',),
'bursjoasier': ('bursjoasi',),
'bursjoasia': ('bursjoasi',),
'bursjoasiene': ('bursjoasi',),
'burundier': ('burundier',),
'burundieren': ('burundier',),
'burundiere': ('burundier',),
'burundierne': ('burundier',),
'bus': ('bus',),
'busen': ('bus',),
'buser': ('bus',),
'busene': ('bus',),
'buse': ('buse',),
'busen': ('buse',),
'buser': ('buse',),
'busene': ('buse',),
'busemann': ('busemann',),
'busemannen': ('busemann',),
'busemenn': ('busemann',),
'busemennene': ('busemann',),
'busetning': ('busetning',),
'busetningen': ('busetning',),
'busetninga': ('busetning',),
'busetninger': ('busetning',),
'busetningene': ('busetning',),
'busetningskart': ('busetningskart',),
'busetningskartet': ('busetningskart',),
'busetningskart': ('busetningskart',),
'busetningskarter': ('busetningskart',),
'busetningskart': ('busetningskart',),
'busetningskarter': ('busetningskart',),
'busetningskarta': ('busetningskart',),
'busetningskartene': ('busetningskart',),
'busetningsmønster': ('busetningsmønster',),
'busetningsmønsteret': ('busetningsmønster',),
'busetningsmønstret': ('busetningsmønster',),
'busetningsmønster': ('busetningsmønster',),
'busetningsmønstre': ('busetningsmønster',),
'busetningsmønstra': ('busetningsmønster',),
'busetningsmønstrene': ('busetningsmønster',),
'busetningsmønstra': ('busetningsmønster',),
'busetningsmønstrene': ('busetningsmønster',),
'busettingskart': ('busettingskart',),
'busettingskartet': ('busettingskart',),
'busettingskart': ('busettingskart',),
'busettingskarter': ('busettingskart',),
'busettingskart': ('busettingskart',),
'busettingskarter': ('busettingskart',),
'busettingskarta': ('busettingskart',),
'busettingskartene': ('busettingskart',),
'busettingsmønster': ('busettingsmønster',),
'busettingsmønsteret': ('busettingsmønster',),
'busettingsmønstret': ('busettingsmønster',),
'busettingsmønster': ('busettingsmønster',),
'busettingsmønstre': ('busettingsmønster',),
'busettingsmønstra': ('busettingsmønster',),
'busettingsmønstrene': ('busettingsmønster',),
'busettingsmønstra': ('busettingsmønster',),
'busettingsmønstrene': ('busettingsmønster',),
'bush': ('bush',),
'bushen': ('bush',),
'busher': ('bush',),
'bushene': ('bush',),
'bushel': ('bushel',),
'bushelen': ('bushel',),
'bushels': ('bushel',),
'bushelene': ('bushel',),
'business': ('business',),
'businessen': ('business',),
'businesser': ('business',),
'businessene': ('business',),
'busk': ('busk',),
'busken': ('busk',),
'busker': ('busk',),
'buskene': ('busk',),
'buskagitasjon': ('buskagitasjon',),
'buskagitasjonen': ('buskagitasjon',),
'buskagitasjoner': ('buskagitasjon',),
'buskagitasjonene': ('buskagitasjon',),
'buskap': ('buskap',),
'buskapen': ('buskap',),
'buskaper': ('buskap',),
'buskapene': ('buskap',),
'buskas': ('buskas',),
'buskaset': ('buskas',),
'buskas': ('buskas',),
'buskaser': ('buskas',),
'buskas': ('buskas',),
'buskaser': ('buskas',),
'buskasa': ('buskas',),
'buskasene': ('buskas',),
'buske': ('buske',),
'busken': ('buske',),
'buska': ('buske',),
'busker': ('buske',),
'buskene': ('buske',),
'buskfuru': ('buskfuru',),
'buskfuruen': ('buskfuru',),
'buskfurua': ('buskfuru',),
'buskfuruer': ('buskfuru',),
'buskfuruene': ('buskfuru',),
'buskis': ('buskis',),
'buskisen': ('buskis',),
'buskiser': ('buskis',),
'buskisene': ('buskis',),
'buskmann': ('buskmann',),
'buskmannen': ('buskmann',),
'buskmenn': ('buskmann',),
'buskmennene': ('buskmann',),
'busknellik': ('busknellik',),
'busknelliken': ('busknellik',),
'busknelliker': ('busknellik',),
'busknellikene': ('busknellik',),
'buskskvett': ('buskskvett',),
'buskskvetten': ('buskskvett',),
'buskskvetter': ('buskskvett',),
'buskskvettene': ('buskskvett',),
'buskvekst': ('buskvekst',),
'buskveksten': ('buskvekst',),
'buskvekster': ('buskvekst',),
'buskvekstene': ('buskvekst',),
'buss': ('buss',),
'bussen': ('buss',),
'busser': ('buss',),
'bussene': ('buss',),
'buss-sjåfør': ('buss-sjåfør',),
'buss-sjåføren': ('buss-sjåfør',),
'buss-sjåfører': ('buss-sjåfør',),
'buss-sjåførene': ('buss-sjåfør',),
'buss-stopp': ('buss-stopp',),
'buss-stoppen': ('buss-stopp',),
'buss-stoppet': ('buss-stopp',),
'buss-stopp': ('buss-stopp',),
'buss-stoppene': ('buss-stopp',),
'buss-stoppa': ('buss-stopp',),
'buss-stoppene': ('buss-stopp',),
'busse': ('busse',),
'bussen': ('busse',),
'busser': ('busse',),
'bussene': ('busse',),
'busse': ('busse',),
'bussen': ('busse',),
'bussa': ('busse',),
'busser': ('busse',),
'bussene': ('busse',),
'busserull': ('busserull',),
'busserullen': ('busserull',),
'busseruller': ('busserull',),
'busserullene': ('busserull',),
'bussfelt': ('bussfelt',),
'bussfeltet': ('bussfelt',),
'bussfelt': ('bussfelt',),
'bussfelter': ('bussfelt',),
'bussfelt': ('bussfelt',),
'bussfelter': ('bussfelt',),
'bussfelta': ('bussfelt',),
'bussfeltene': ('bussfelt',),
'bussfil': ('bussfil',),
'bussfilen': ('bussfil',),
'bussfiler': ('bussfil',),
'bussfilene': ('bussfil',),
'bussforbindelse': ('bussforbindelse',),
'bussforbindelsen': ('bussforbindelse',),
'bussforbindelser': ('bussforbindelse',),
'bussforbindelsene': ('bussforbindelse',),
'bussholdeplass': ('bussholdeplass',),
'bussholdeplassen': ('bussholdeplass',),
'bussholdeplasser': ('bussholdeplass',),
'bussholdeplassene': ('bussholdeplass',),
'bussjåfør': ('bussjåfør',),
'bussjåføren': ('bussjåfør',),
'bussjåfører': ('bussjåfør',),
'bussjåførene': ('bussjåfør',),
'bussrute': ('bussrute',),
'bussruten': ('bussrute',),
'bussruta': ('bussrute',),
'bussruter': ('bussrute',),
'bussrutene': ('bussrute',),
'bussterminal': ('bussterminal',),
'bussterminalen': ('bussterminal',),
'bussterminaler': ('bussterminal',),
'bussterminalene': ('bussterminal',),
'busstopp': ('busstopp',),
'busstoppen': ('busstopp',),
'busstoppet': ('busstopp',),
'busstopp': ('busstopp',),
'busstoppene': ('busstopp',),
'busstoppa': ('busstopp',),
'busstoppene': ('busstopp',),
'bust': ('bust',),
'busten': ('bust',),
'busta': ('bust',),
'buster': ('bust',),
'bustene': ('bust',),
'bustad': ('bustad',),
'bustaden': ('bustad',),
'bustader': ('bustad',),
'bustadene': ('bustad',),
'bustadbank': ('bustadbank',),
'bustadbanken': ('bustadbank',),
'bustadbanker': ('bustadbank',),
'bustadbankene': ('bustadbank',),
'bustadlån': ('bustadlån',),
'bustadlånet': ('bustadlån',),
'bustadlån': ('bustadlån',),
'bustadlåna': ('bustadlån',),
'bustadlånene': ('bustadlån',),
'bustnellik': ('bustnellik',),
'bustnelliken': ('bustnellik',),
'bustnelliker': ('bustnellik',),
'bustnellikene': ('bustnellik',),
'bustyre': ('bustyre',),
'bustyret': ('bustyre',),
'bustyrer': ('bustyre',),
'bustyra': ('bustyre',),
'bustyrene': ('bustyre',),
'bustyrer': ('bustyrer',),
'bustyreren': ('bustyrer',),
'bustyrere': ('bustyrer',),
'bustyrerne': ('bustyrer',),
'bustøtte': ('bustøtte',),
'bustøtten': ('bustøtte',),
'bustøtta': ('bustøtte',),
'bustøtter': ('bustøtte',),
'bustøttene': ('bustøtte',),
'butan': ('butan',),
'butanen': ('butan',),
'butanet': ('butan',),
'butaner': ('butan',),
'butan': ('butan',),
'butanene': ('butan',),
'butana': ('butan',),
'butanene': ('butan',),
'butid': ('butid',),
'butiden': ('butid',),
'butida': ('butid',),
'butider': ('butid',),
'butidene': ('butid',),
'butikk': ('butikk',),
'butikken': ('butikk',),
'butikker': ('butikk',),
'butikkene': ('butikk',),
'butikk-kjede': ('butikk-kjede',),
'butikk-kjeden': ('butikk-kjede',),
'butikk-kjeder': ('butikk-kjede',),
'butikk-kjedene': ('butikk-kjede',),
'butikkdød': ('butikkdød',),
'butikkdøden': ('butikkdød',),
'butikkdøder': ('butikkdød',),
'butikkdødene': ('butikkdød',),
'butikkfagskole': ('butikkfagskole',),
'butikkfagskolen': ('butikkfagskole',),
'butikkfagskoler': ('butikkfagskole',),
'butikkfagskolene': ('butikkfagskole',),
'butikkfunksjonær': ('butikkfunksjonær',),
'butikkfunksjonæren': ('butikkfunksjonær',),
'butikkfunksjonærer': ('butikkfunksjonær',),
'butikkfunksjonærene': ('butikkfunksjonær',),
'butikkjede': ('butikkjede',),
'butikkjeden': ('butikkjede',),
'butikkjeder': ('butikkjede',),
'butikkjedene': ('butikkjede',),
'butikksenter': ('butikksenter',),
'butikksenteret': ('butikksenter',),
'butikksentret': ('butikksenter',),
'butikksenter': ('butikksenter',),
'butikksentre': ('butikksenter',),
'butikksentra': ('butikksenter',),
'butikksentrene': ('butikksenter',),
'butikksentra': ('butikksenter',),
'butikksentrene': ('butikksenter',),
'butikktjuv': ('butikktjuv',),
'butikktjuven': ('butikktjuv',),
'butikktjuver': ('butikktjuv',),
'butikktjuvene': ('butikktjuv',),
'butikktjuveri': ('butikktjuveri',),
'butikktjuveriet': ('butikktjuveri',),
'butikktjuveri': ('butikktjuveri',),
'butikktjuverier': ('butikktjuveri',),
'butikktjuveri': ('butikktjuveri',),
'butikktjuverier': ('butikktjuveri',),
'butikktjuveria': ('butikktjuveri',),
'butikktjuveriene': ('butikktjuveri',),
'butikktyv': ('butikktyv',),
'butikktyven': ('butikktyv',),
'butikktyver': ('butikktyv',),
'butikktyvene': ('butikktyv',),
'butikktyveri': ('butikktyveri',),
'butikktyveriet': ('butikktyveri',),
'butikktyveri': ('butikktyveri',),
'butikktyverier': ('butikktyveri',),
'butikktyveri': ('butikktyveri',),
'butikktyverier': ('butikktyveri',),
'butikktyveria': ('butikktyveri',),
'butikktyveriene': ('butikktyveri',),
'butikkvindu': ('butikkvindu',),
'butikkvinduet': ('butikkvindu',),
'butikkvindu': ('butikkvindu',),
'butikkvinduer': ('butikkvindu',),
'butikkvindu': ('butikkvindu',),
'butikkvinduer': ('butikkvindu',),
'butikkvindua': ('butikkvindu',),
'butikkvinduene': ('butikkvindu',),
'butt': ('butt',),
'butten': ('butt',),
'butter': ('butt',),
'buttene': ('butt',),
'butterdeig': ('butterdeig',),
'butterdeigen': ('butterdeig',),
'butterdeiger': ('butterdeig',),
'butterdeigene': ('butterdeig',),
'butterfly': ('butterfly',),
'butterflyen': ('butterfly',),
'butterflyer': ('butterfly',),
'butterflyene': ('butterfly',),
'buttskjøt': ('buttskjøt',),
'buttskjøten': ('buttskjøt',),
'buttskjøter': ('buttskjøt',),
'buttskjøtene': ('buttskjøt',),
'buttsveis': ('buttsveis',),
'buttsveisen': ('buttsveis',),
'buttsveiser': ('buttsveis',),
'buttsveisene': ('buttsveis',),
'by': ('by',),
'byen': ('by',),
'byer': ('by',),
'byene': ('by',),
'byantikvar': ('byantikvar',),
'byantikvaren': ('byantikvar',),
'byantikvarer': ('byantikvar',),
'byantikvarene': ('byantikvar',),
'bybefolkning': ('bybefolkning',),
'bybefolkningen': ('bybefolkning',),
'bybefolkninga': ('bybefolkning',),
'bybefolkninger': ('bybefolkning',),
'bybefolkningene': ('bybefolkning',),
'bybilde': ('bybilde',),
'bybildet': ('bybilde',),
'bybilder': ('bybilde',),
'bybilda': ('bybilde',),
'bybildene': ('bybilde',),
'bybud': ('bybud',),
'bybudet': ('bybud',),
'bybud': ('bybud',),
'bybuda': ('bybud',),
'bybudene': ('bybud',),
'bydeform': ('bydeform',),
'bydeformen': ('bydeform',),
'bydeforma': ('bydeform',),
'bydeformer': ('bydeform',),
'bydeformene': ('bydeform',),
'bydel': ('bydel',),
'bydelen': ('bydel',),
'bydeler': ('bydel',),
'bydelene': ('bydel',),
'bydelsutvalg': ('bydelsutvalg',),
'bydelsutvalget': ('bydelsutvalg',),
'bydelsutvalg': ('bydelsutvalg',),
'bydelsutvalga': ('bydelsutvalg',),
'bydelsutvalgene': ('bydelsutvalg',),
'byfogd': ('byfogd',),
'byfogden': ('byfogd',),
'byfogder': ('byfogd',),
'byfogdene': ('byfogd',),
'byfolk': ('byfolk',),
'byfolket': ('byfolk',),
'byfolk': ('byfolk',),
'byfolka': ('byfolk',),
'byfolkene': ('byfolk',),
'byfornyelse': ('byfornyelse',),
'byfornyelsen': ('byfornyelse',),
'byfornyelser': ('byfornyelse',),
'byfornyelsene': ('byfornyelse',),
'byfornying': ('byfornying',),
'byfornyingen': ('byfornying',),
'byfornyinga': ('byfornying',),
'byfornyinger': ('byfornying',),
'byfornyingene': ('byfornying',),
'bygd': ('bygd',),
'bygden': ('bygd',),
'bygda': ('bygd',),
'bygder': ('bygd',),
'bygdene': ('bygd',),
'bygdeallmenning': ('bygdeallmenning',),
'bygdeallmenningen': ('bygdeallmenning',),
'bygdeallmenninger': ('bygdeallmenning',),
'bygdeallmenningene': ('bygdeallmenning',),
'bygdeborg': ('bygdeborg',),
'bygdeborgen': ('bygdeborg',),
'bygdeborga': ('bygdeborg',),
'bygdeborger': ('bygdeborg',),
'bygdeborgene': ('bygdeborg',),
'bygdeby': ('bygdeby',),
'bygdebyen': ('bygdeby',),
'bygdebyer': ('bygdeby',),
'bygdebyene': ('bygdeby',),
'bygdedans': ('bygdedans',),
'bygdedansen': ('bygdedans',),
'bygdedanser': ('bygdedans',),
'bygdedansene': ('bygdedans',),
'bygdefolk': ('bygdefolk',),
'bygdefolket': ('bygdefolk',),
'bygdefolk': ('bygdefolk',),
'bygdefolka': ('bygdefolk',),
'bygdefolkene': ('bygdefolk',),
'bygdegeni': ('bygdegeni',),
'bygdegeniet': ('bygdegeni',),
'bygdegeni': ('bygdegeni',),
'bygdegenier': ('bygdegeni',),
'bygdegeni': ('bygdegeni',),
'bygdegenier': ('bygdegeni',),
'bygdegenia': ('bygdegeni',),
'bygdegeniene': ('bygdegeni',),
'bygdekultur': ('bygdekultur',),
'bygdekulturen': ('bygdekultur',),
'bygdekulturer': ('bygdekultur',),
'bygdekulturene': ('bygdekultur',),
'bygdelag': ('bygdelag',),
'bygdelaget': ('bygdelag',),
'bygdelag': ('bygdelag',),
'bygdelaga': ('bygdelag',),
'bygdelagene': ('bygdelag',),
'bygdemål': ('bygdemål',),
'bygdemålet': ('bygdemål',),
'bygdemål': ('bygdemål',),
'bygdemåla': ('bygdemål',),
'bygdemålene': ('bygdemål',),
'bygdemålsdikter': ('bygdemålsdikter',),
'bygdemålsdikteren': ('bygdemålsdikter',),
'bygdemålsdiktere': ('bygdemålsdikter',),
'bygdemålsdikterne': ('bygdemålsdikter',),
'bygdemålslitteratur': ('bygdemålslitteratur',),
'bygdemålslitteraturen': ('bygdemålslitteratur',),
'bygdemålslitteraturer': ('bygdemålslitteratur',),
'bygdemålslitteraturene': ('bygdemålslitteratur',),
'bygdemålsvise': ('bygdemålsvise',),
'bygdemålsvisen': ('bygdemålsvise',),
'bygdemålsvisa': ('bygdemålsvise',),
'bygdemålsviser': ('bygdemålsvise',),
'bygdemålsvisene': ('bygdemålsvise',),
'bygdetun': ('bygdetun',),
'bygdetunet': ('bygdetun',),
'bygdetun': ('bygdetun',),
'bygdetuna': ('bygdetun',),
'bygdetunene': ('bygdetun',),
'bygdeveg': ('bygdeveg',),
'bygdevegen': ('bygdeveg',),
'bygdeveger': ('bygdeveg',),
'bygdevegene': ('bygdeveg',),
'bygdevei': ('bygdevei',),
'bygdeveien': ('bygdevei',),
'bygdeveier': ('bygdevei',),
'bygdeveiene': ('bygdevei',),
'byge': ('byge',),
'bygen': ('byge',),
'byga': ('byge',),
'byger': ('byge',),
'bygene': ('byge',),
'bygerilja': ('bygerilja',),
'bygeriljaen': ('bygerilja',),
'bygeriljaer': ('bygerilja',),
'bygeriljaene': ('bygerilja',),
'bygg': ('bygg',),
'bygget': ('bygg',),
'bygg': ('bygg',),
'bygga': ('bygg',),
'byggene': ('bygg',),
'bygg': ('bygg',),
'byggen': ('bygg',),
'bygget': ('bygg',),
'bygger': ('bygg',),
'bygg': ('bygg',),
'byggene': ('bygg',),
'bygga': ('bygg',),
'byggene': ('bygg',),
'bygg-gryn': ('bygg-gryn',),
'bygg-grynet': ('bygg-gryn',),
'bygg-gryn': ('bygg-gryn',),
'bygg-gryna': ('bygg-gryn',),
'bygg-grynene': ('bygg-gryn',),
'byggearbeid': ('byggearbeid',),
'byggearbeidet': ('byggearbeid',),
'byggearbeid': ('byggearbeid',),
'byggearbeider': ('byggearbeid',),
'byggearbeid': ('byggearbeid',),
'byggearbeider': ('byggearbeid',),
'byggearbeida': ('byggearbeid',),
'byggearbeidene': ('byggearbeid',),
'byggeelement': ('byggeelement',),
'byggeelementet': ('byggeelement',),
'byggeelement': ('byggeelement',),
'byggeelementer': ('byggeelement',),
'byggeelement': ('byggeelement',),
'byggeelementer': ('byggeelement',),
'byggeelementa': ('byggeelement',),
'byggeelementene': ('byggeelement',),
'byggefelt': ('byggefelt',),
'byggefeltet': ('byggefelt',),
'byggefelt': ('byggefelt',),
'byggefelter': ('byggefelt',),
'byggefelt': ('byggefelt',),
'byggefelter': ('byggefelt',),
'byggefelta': ('byggefelt',),
'byggefeltene': ('byggefelt',),
'byggeforbud': ('byggeforbud',),
'byggeforbudet': ('byggeforbud',),
'byggeforbud': ('byggeforbud',),
'byggeforbuda': ('byggeforbud',),
'byggeforbudene': ('byggeforbud',),
'byggeforetak': ('byggeforetak',),
'byggeforetaket': ('byggeforetak',),
'byggeforetak': ('byggeforetak',),
'byggeforetaka': ('byggeforetak',),
'byggeforetakene': ('byggeforetak',),
'byggeforskrift': ('byggeforskrift',),
'byggeforskriften': ('byggeforskrift',),
'byggeforskrifta': ('byggeforskrift',),
'byggeforskrifter': ('byggeforskrift',),
'byggeforskriftene': ('byggeforskrift',),
'byggegrense': ('byggegrense',),
'byggegrensen': ('byggegrense',),
'byggegrensa': ('byggegrense',),
'byggegrenser': ('byggegrense',),
'byggegrensene': ('byggegrense',),
'byggekloss': ('byggekloss',),
'byggeklossen': ('byggekloss',),
'byggeklosser': ('byggekloss',),
'byggeklossene': ('byggekloss',),
'byggeklossprinsipp': ('byggeklossprinsipp',),
'byggeklossprinsippet': ('byggeklossprinsipp',),
'byggeklossprinsipp': ('byggeklossprinsipp',),
'byggeklossprinsipper': ('byggeklossprinsipp',),
'byggeklossprinsipp': ('byggeklossprinsipp',),
'byggeklossprinsipper': ('byggeklossprinsipp',),
'byggeklossprinsippa': ('byggeklossprinsipp',),
'byggeklossprinsippene': ('byggeklossprinsipp',),
'byggekunst': ('byggekunst',),
'byggekunsten': ('byggekunst',),
'byggekunster': ('byggekunst',),
'byggekunstene': ('byggekunst',),
'byggeleder': ('byggeleder',),
'byggelederen': ('byggeleder',),
'byggeledere': ('byggeleder',),
'byggelederne': ('byggeleder',),
'byggelån': ('byggelån',),
'byggelånet': ('byggelån',),
'byggelån': ('byggelån',),
'byggelåna': ('byggelån',),
'byggelånene': ('byggelån',),
'byggeløyve': ('byggeløyve',),
'byggeløyvet': ('byggeløyve',),
'byggeløyver': ('byggeløyve',),
'byggeløyve': ('byggeløyve',),
'byggeløyver': ('byggeløyve',),
'byggeløyve': ('byggeløyve',),
'byggeløyva': ('byggeløyve',),
'byggeløyvene': ('byggeløyve',),
'byggemelding': ('byggemelding',),
'byggemeldingen': ('byggemelding',),
'byggemeldinga': ('byggemelding',),
'byggemeldinger': ('byggemelding',),
'byggemeldingene': ('byggemelding',),
'byggemåte': ('byggemåte',),
'byggemåten': ('byggemåte',),
'byggemåter': ('byggemåte',),
'byggemåtene': ('byggemåte',),
'byggenemnd': ('byggenemnd',),
'byggenemnden': ('byggenemnd',),
'byggenemnda': ('byggenemnd',),
'byggenemnder': ('byggenemnd',),
'byggenemndene': ('byggenemnd',),
'byggenummer': ('byggenummer',),
'byggenummeret': ('byggenummer',),
'byggenummer': ('byggenummer',),
'byggenumre': ('byggenummer',),
'byggenumra': ('byggenummer',),
'byggenumrene': ('byggenummer',),
'byggenumra': ('byggenummer',),
'byggenumrene': ('byggenummer',),
'bygger': ('bygger',),
'byggeren': ('bygger',),
'byggere': ('bygger',),
'byggerne': ('bygger',),
'byggesamtykke': ('byggesamtykke',),
'byggesamtykket': ('byggesamtykke',),
'byggesamtykker': ('byggesamtykke',),
'byggesamtykka': ('byggesamtykke',),
'byggesamtykkene': ('byggesamtykke',),
'byggesett': ('byggesett',),
'byggesettet': ('byggesett',),
'byggesett': ('byggesett',),
'byggesetta': ('byggesett',),
'byggesettene': ('byggesett',),
'byggeskikk': ('byggeskikk',),
'byggeskikken': ('byggeskikk',),
'byggeskikker': ('byggeskikk',),
'byggeskikkene': ('byggeskikk',),
'byggesone': ('byggesone',),
'byggesonen': ('byggesone',),
'byggesona': ('byggesone',),
'byggesoner': ('byggesone',),
'byggesonene': ('byggesone',),
'byggestein': ('byggestein',),
'byggesteinen': ('byggestein',),
'byggesteiner': ('byggestein',),
'byggesteinene': ('byggestein',),
'byggetid': ('byggetid',),
'byggetiden': ('byggetid',),
'byggetida': ('byggetid',),
'byggetider': ('byggetid',),
'byggetidene': ('byggetid',),
'byggetillatelse': ('byggetillatelse',),
'byggetillatelsen': ('byggetillatelse',),
'byggetillatelser': ('byggetillatelse',),
'byggetillatelsene': ('byggetillatelse',),
'byggetomt': ('byggetomt',),
'byggetomten': ('byggetomt',),
'byggetomta': ('byggetomt',),
'byggetomter': ('byggetomt',),
'byggetomtene': ('byggetomt',),
'byggetrinn': ('byggetrinn',),
'byggetrinnet': ('byggetrinn',),
'byggetrinn': ('byggetrinn',),
'byggetrinna': ('byggetrinn',),
'byggetrinnene': ('byggetrinn',),
'byggevare': ('byggevare',),
'byggevaren': ('byggevare',),
'byggevara': ('byggevare',),
'byggevarer': ('byggevare',),
'byggevarene': ('byggevare',),
'byggevirksomhet': ('byggevirksomhet',),
'byggevirksomheten': ('byggevirksomhet',),
'byggevirksomheta': ('byggevirksomhet',),
'byggevirksomheter': ('byggevirksomhet',),
'byggevirksomhetene': ('byggevirksomhet',),
'byggherre': ('byggherre',),
'byggherren': ('byggherre',),
'byggherrer': ('byggherre',),
'byggherrene': ('byggherre',),
'bygging': ('bygging',),
'byggingen': ('bygging',),
'bygginga': ('bygging',),
'bygginger': ('bygging',),
'byggingene': ('bygging',),
'byggkorn': ('byggkorn',),
'byggkornet': ('byggkorn',),
'byggkorn': ('byggkorn',),
'byggkorna': ('byggkorn',),
'byggkornene': ('byggkorn',),
'byggmel': ('byggmel',),
'byggmelet': ('byggmel',),
'byggmel': ('byggmel',),
'byggmela': ('byggmel',),
'byggmelene': ('byggmel',),
'byggmester': ('byggmester',),
'byggmesteren': ('byggmester',),
'byggmestere': ('byggmester',),
'byggmestrer': ('byggmester',),
'byggmestre': ('byggmester',),
'byggmesterne': ('byggmester',),
'byggmestrene': ('byggmester',),
'byggmjøl': ('byggmjøl',),
'byggmjølet': ('byggmjøl',),
'byggmjøl': ('byggmjøl',),
'byggmjøla': ('byggmjøl',),
'byggmjølene': ('byggmjøl',),
'byggryn': ('byggryn',),
'byggrynet': ('byggryn',),
'byggryn': ('byggryn',),
'byggryna': ('byggryn',),
'byggrynene': ('byggryn',),
'byggsuppe': ('byggsuppe',),
'byggsuppen': ('byggsuppe',),
'byggsuppa': ('byggsuppe',),
'byggsupper': ('byggsuppe',),
'byggsuppene': ('byggsuppe',),
'byggverk': ('byggverk',),
'byggverket': ('byggverk',),
'byggverk': ('byggverk',),
'byggverker': ('byggverk',),
'byggverk': ('byggverk',),
'byggverker': ('byggverk',),
'byggverka': ('byggverk',),
'byggverkene': ('byggverk',),
'bygning': ('bygning',),
'bygningen': ('bygning',),
'bygninga': ('bygning',),
'bygninger': ('bygning',),
'bygningene': ('bygning',),
'bygningsarbeider': ('bygningsarbeider',),
'bygningsarbeideren': ('bygningsarbeider',),
'bygningsarbeidere': ('bygningsarbeider',),
'bygningsarbeiderne': ('bygningsarbeider',),
'bygningsartikkel': ('bygningsartikkel',),
'bygningsartikkelen': ('bygningsartikkel',),
'bygningsartikler': ('bygningsartikkel',),
'bygningsartiklene': ('bygningsartikkel',),
'bygningsattest': ('bygningsattest',),
'bygningsattesten': ('bygningsattest',),
'bygningsattester': ('bygningsattest',),
'bygningsattestene': ('bygningsattest',),
'bygningsdel': ('bygningsdel',),
'bygningsdelen': ('bygningsdel',),
'bygningsdeler': ('bygningsdel',),
'bygningsdelene': ('bygningsdel',),
'bygningsindustri': ('bygningsindustri',),
'bygningsindustrien': ('bygningsindustri',),
'bygningsindustrier': ('bygningsindustri',),
'bygningsindustriene': ('bygningsindustri',),
'bygningskontroll': ('bygningskontroll',),
'bygningskontrollen': ('bygningskontroll',),
'bygningskontroller': ('bygningskontroll',),
'bygningskontrollene': ('bygningskontroll',),
'bygningslov': ('bygningslov',),
'bygningsloven': ('bygningslov',),
'bygningslover': ('bygningslov',),
'bygningslovene': ('bygningslov',),
'bygningsnemnd': ('bygningsnemnd',),
'bygningsnemnden': ('bygningsnemnd',),
'bygningsnemnda': ('bygningsnemnd',),
'bygningsnemnder': ('bygningsnemnd',),
'bygningsnemndene': ('bygningsnemnd',),
'bygningspapp': ('bygningspapp',),
'bygningspappen': ('bygningspapp',),
'bygningspapper': ('bygningspapp',),
'bygningspappene': ('bygningspapp',),
'bygningsråd': ('bygningsråd',),
'bygningsrådet': ('bygningsråd',),
'bygningsråd': ('bygningsråd',),
'bygningsråda': ('bygningsråd',),
'bygningsrådene': ('bygningsråd',),
'bygningssjef': ('bygningssjef',),
'bygningssjefen': ('bygningssjef',),
'bygningssjefer': ('bygningssjef',),
'bygningssjefene': ('bygningssjef',),
'bygningssnekker': ('bygningssnekker',),
'bygningssnekkeren': ('bygningssnekker',),
'bygningssnekkere': ('bygningssnekker',),
'bygningssnekkerne': ('bygningssnekker',),
'bygningsvedtekt': ('bygningsvedtekt',),
'bygningsvedtekten': ('bygningsvedtekt',),
'bygningsvedtekta': ('bygningsvedtekt',),
'bygningsvedtekter': ('bygningsvedtekt',),
'bygningsvedtektene': ('bygningsvedtekt',),
'bygsel': ('bygsel',),
'bygselen': ('bygsel',),
'bygsla': ('bygsel',),
'bygsler': ('bygsel',),
'bygslene': ('bygsel',),
'bygselbrev': ('bygselbrev',),
'bygselbrevet': ('bygselbrev',),
'bygselbrev': ('bygselbrev',),
'bygselbrever': ('bygselbrev',),
'bygselbrev': ('bygselbrev',),
'bygselbrever': ('bygselbrev',),
'bygselbreva': ('bygselbrev',),
'bygselbrevene': ('bygselbrev',),
'bygselrett': ('bygselrett',),
'bygselretten': ('bygselrett',),
'bygselretter': ('bygselrett',),
'bygselrettene': ('bygselrett',),
'bygård': ('bygård',),
'bygården': ('bygård',),
'bygårder': ('bygård',),
'bygårdene': ('bygård',),
'bykjerne': ('bykjerne',),
'bykjernen': ('bykjerne',),
'bykjerner': ('bykjerne',),
'bykjernene': ('bykjerne',),
'bykommune': ('bykommune',),
'bykommunen': ('bykommune',),
'bykommuner': ('bykommune',),
'bykommunene': ('bykommune',),
'byks': ('byks',),
'bykset': ('byks',),
'byks': ('byks',),
'byksa': ('byks',),
'byksene': ('byks',),
'bykultur': ('bykultur',),
'bykulturen': ('bykultur',),
'bykulturer': ('bykultur',),
'bykulturene': ('bykultur',),
'byliv': ('byliv',),
'bylivet': ('byliv',),
'byliv': ('byliv',),
'byliva': ('byliv',),
'bylivene': ('byliv',),
'byll': ('byll',),
'byllen': ('byll',),
'byller': ('byll',),
'byllene': ('byll',),
'byllepest': ('byllepest',),
'byllepesten': ('byllepest',),
'byllepesta': ('byllepest',),
'byllepester': ('byllepest',),
'byllepestene': ('byllepest',),
'bylt': ('bylt',),
'bylten': ('bylt',),
'bylter': ('bylt',),
'byltene': ('bylt',),
'bymenneske': ('bymenneske',),
'bymennesket': ('bymenneske',),
'bymennesker': ('bymenneske',),
'bymenneska': ('bymenneske',),
'bymenneskene': ('bymenneske',),
'bymiljø': ('bymiljø',),
'bymiljøet': ('bymiljø',),
'bymiljø': ('bymiljø',),
'bymiljøer': ('bymiljø',),
'bymiljø': ('bymiljø',),
'bymiljøer': ('bymiljø',),
'bymiljøa': ('bymiljø',),
'bymiljøene': ('bymiljø',),
'bymur': ('bymur',),
'bymuren': ('bymur',),
'bymurer': ('bymur',),
'bymurene': ('bymur',),
'bymål': ('bymål',),
'bymålet': ('bymål',),
'bymål': ('bymål',),
'bymåla': ('bymål',),
'bymålene': ('bymål',),
'byoriginal': ('byoriginal',),
'byoriginalen': ('byoriginal',),
'byoriginaler': ('byoriginal',),
'byoriginalene': ('byoriginal',),
'byplan': ('byplan',),
'byplanen': ('byplan',),
'byplaner': ('byplan',),
'byplanene': ('byplan',),
'byplanlegging': ('byplanlegging',),
'byplanleggingen': ('byplanlegging',),
'byplanlegginga': ('byplanlegging',),
'byplanlegginger': ('byplanlegging',),
'byplanleggingene': ('byplanlegging',),
'byplanråd': ('byplanråd',),
'byplanrådet': ('byplanråd',),
'byplanråd': ('byplanråd',),
'byplanråda': ('byplanråd',),
'byplanrådene': ('byplanråd',),
'byport': ('byport',),
'byporten': ('byport',),
'byporter': ('byport',),
'byportene': ('byport',),
'byrd': ('byrd',),
'byrden': ('byrd',),
'byrder': ('byrd',),
'byrdene': ('byrd',),
'byrde': ('byrde',),
'byrden': ('byrde',),
'byrder': ('byrde',),
'byrdene': ('byrde',),
'byrett': ('byrett',),
'byretten': ('byrett',),
'byretter': ('byrett',),
'byrettene': ('byrett',),
'byrette': ('byrette',),
'byretten': ('byrette',),
'byretter': ('byrette',),
'byrettene': ('byrette',),
'byrettsdom': ('byrettsdom',),
'byrettsdommen': ('byrettsdom',),
'byrettsdommer': ('byrettsdom',),
'byrettsdommene': ('byrettsdom',),
'byrettsdommer': ('byrettsdommer',),
'byrettsdommeren': ('byrettsdommer',),
'byrettsdommere': ('byrettsdommer',),
'byrettsdommerne': ('byrettsdommer',),
'byrettsjustitiarius': ('byrettsjustitiarius',),
'byrettsjustitiarien': ('byrettsjustitiarius',),
'byrettsjustitiarier': ('byrettsjustitiarius',),
'byrettsjustitiariene': ('byrettsjustitiarius',),
'byrå': ('byrå',),
'byrået': ('byrå',),
'byrå': ('byrå',),
'byråer': ('byrå',),
'byrå': ('byrå',),
'byråer': ('byrå',),
'byråa': ('byrå',),
'byråene': ('byrå',),
'byråd': ('byråd',),
'byråden': ('byråd',),
'byråder': ('byråd',),
'byrådene': ('byråd',),
'byråd': ('byråd',),
'byrådet': ('byråd',),
'byråd': ('byråd',),
'byråda': ('byråd',),
'byrådene': ('byråd',),
'byrådsleder': ('byrådsleder',),
'byrådslederen': ('byrådsleder',),
'byrådsledere': ('byrådsleder',),
'byrådslederne': ('byrådsleder',),
'byråkrat': ('byråkrat',),
'byråkraten': ('byråkrat',),
'byråkrater': ('byråkrat',),
'byråkratene': ('byråkrat',),
'byråkrati': ('byråkrati',),
'byråkratiet': ('byråkrati',),
'byråkrati': ('byråkrati',),
'byråkratier': ('byråkrati',),
'byråkrati': ('byråkrati',),
'byråkratier': ('byråkrati',),
'byråkratia': ('byråkrati',),
'byråkratiene': ('byråkrati',),
'byråsjef': ('byråsjef',),
'byråsjefen': ('byråsjef',),
'byråsjefer': ('byråsjef',),
'byråsjefene': ('byråsjef',),
'byråsjefsstilling': ('byråsjefsstilling',),
'byråsjefsstillingen': ('byråsjefsstilling',),
'byråsjefsstillinga': ('byråsjefsstilling',),
'byråsjefsstillinger': ('byråsjefsstilling',),
'byråsjefsstillingene': ('byråsjefsstilling',),
'byråsjefstilling': ('byråsjefstilling',),
'byråsjefstillingen': ('byråsjefstilling',),
'byråsjefstillinga': ('byråsjefstilling',),
'byråsjefstillinger': ('byråsjefstilling',),
'byråsjefstillingene': ('byråsjefstilling',),
'bysantiner': ('bysantiner',),
'bysantineren': ('bysantiner',),
'bysantinere': ('bysantiner',),
'bysantinerne': ('bysantiner',),
'bysbarn': ('bysbarn',),
'bysbarnet': ('bysbarn',),
'bysbarn': ('bysbarn',),
'bysbarna': ('bysbarn',),
'bysbarnene': ('bysbarn',),
'byskriver': ('byskriver',),
'byskriveren': ('byskriver',),
'byskrivere': ('byskriver',),
'byskriverne': ('byskriver',),
'bysse': ('bysse',),
'byssen': ('bysse',),
'byssa': ('bysse',),
'bysser': ('bysse',),
'byssene': ('bysse',),
'byssegutt': ('byssegutt',),
'byssegutten': ('byssegutt',),
'byssegutter': ('byssegutt',),
'bysseguttene': ('byssegutt',),
'byssejente': ('byssejente',),
'byssejenten': ('byssejente',),
'byssejenta': ('byssejente',),
'byssejenter': ('byssejente',),
'byssejentene': ('byssejente',),
'byssetjeneste': ('byssetjeneste',),
'byssetjenesten': ('byssetjeneste',),
'byssetjenester': ('byssetjeneste',),
'byssetjenestene': ('byssetjeneste',),
'byste': ('byste',),
'bysten': ('byste',),
'bysta': ('byste',),
'byster': ('byste',),
'bystene': ('byste',),
'bysteholder': ('bysteholder',),
'bysteholderen': ('bysteholder',),
'bysteholdere': ('bysteholder',),
'bysteholderne': ('bysteholder',),
'bystyre': ('bystyre',),
'bystyret': ('bystyre',),
'bystyrer': ('bystyre',),
'bystyra': ('bystyre',),
'bystyrene': ('bystyre',),
'bystyremedlem': ('bystyremedlem',),
'bystyremedlemmet': ('bystyremedlem',),
'bystyremedlemmer': ('bystyremedlem',),
'bystyremedlemma': ('bystyremedlem',),
'bystyremedlemmene': ('bystyremedlem',),
'bystyrevalg': ('bystyrevalg',),
'bystyrevalget': ('bystyrevalg',),
'bystyrevalg': ('bystyrevalg',),
'bystyrevalga': ('bystyrevalg',),
'bystyrevalgene': ('bystyrevalg',),
'bystyrevedtak': ('bystyrevedtak',),
'bystyrevedtaket': ('bystyrevedtak',),
'bystyrevedtak': ('bystyrevedtak',),
'bystyrevedtaka': ('bystyrevedtak',),
'bystyrevedtakene': ('bystyrevedtak',),
'byte': ('byte',),
'byten': ('byte',),
'byte': ('byte',),
'bytene': ('byte',),
'bytte': ('bytte',),
'byttet': ('bytte',),
'bytter': ('bytte',),
'bytta': ('bytte',),
'byttene': ('bytte',),
'byttearbeid': ('byttearbeid',),
'byttearbeidet': ('byttearbeid',),
'byttearbeid': ('byttearbeid',),
'byttearbeider': ('byttearbeid',),
'byttearbeid': ('byttearbeid',),
'byttearbeider': ('byttearbeid',),
'byttearbeida': ('byttearbeid',),
'byttearbeidene': ('byttearbeid',),
'byttegjenstand': ('byttegjenstand',),
'byttegjenstanden': ('byttegjenstand',),
'byttegjenstander': ('byttegjenstand',),
'byttegjenstandene': ('byttegjenstand',),
'byttehandel': ('byttehandel',),
'byttehandelen': ('byttehandel',),
'byttehandler': ('byttehandel',),
'byttehandlene': ('byttehandel',),
'byttehusholdning': ('byttehusholdning',),
'byttehusholdningen': ('byttehusholdning',),
'byttehusholdninga': ('byttehusholdning',),
'byttehusholdninger': ('byttehusholdning',),
'byttehusholdningene': ('byttehusholdning',),
'byttemiddel': ('byttemiddel',),
'byttemiddelet': ('byttemiddel',),
'byttemidlet': ('byttemiddel',),
'byttemiddel': ('byttemiddel',),
'byttemidler': ('byttemiddel',),
'byttemidla': ('byttemiddel',),
'byttemidlene': ('byttemiddel',),
'byttemidla': ('byttemiddel',),
'byttemidlene': ('byttemiddel',),
'bytting': ('bytting',),
'byttingen': ('bytting',),
'byttinger': ('bytting',),
'byttingene': ('bytting',),
'byvekt': ('byvekt',),
'byvekten': ('byvekt',),
'byvekta': ('byvekt',),
'byvekter': ('byvekt',),
'byvektene': ('byvekt',),
'byvåpen': ('byvåpen',),
'byvåpenet': ('byvåpen',),
'byvåpen': ('byvåpen',),
'byvåpna': ('byvåpen',),
'byvåpnene': ('byvåpen',),
'båe': ('båe',),
'båen': ('båe',),
'båer': ('båe',),
'båene': ('båe',),
'båk': ('båk',),
'båken': ('båk',),
'båker': ('båk',),
'båkene': ('båk',),
'båke': ('båke',),
'båken': ('båke',),
'båker': ('båke',),
'båkene': ('båke',),
'bål': ('bål',),
'bålet': ('bål',),
'bål': ('bål',),
'båla': ('bål',),
'bålene': ('bål',),
'båle': ('båle',),
'bålen': ('båle',),
'båler': ('båle',),
'bålene': ('båle',),
'bålferd': ('bålferd',),
'bålferden': ('bålferd',),
'bålferda': ('bålferd',),
'bålferder': ('bålferd',),
'bålferdene': ('bålferd',),
'bånd': ('bånd',),
'båndet': ('bånd',),
'bånd': ('bånd',),
'bånda': ('bånd',),
'båndene': ('bånd',),
'båndby': ('båndby',),
'båndbyen': ('båndby',),
'båndbyer': ('båndby',),
'båndbyene': ('båndby',),
'båndjern': ('båndjern',),
'båndjernet': ('båndjern',),
'båndjern': ('båndjern',),
'båndjerna': ('båndjern',),
'båndjernene': ('båndjern',),
'båndkniv': ('båndkniv',),
'båndkniven': ('båndkniv',),
'båndkniver': ('båndkniv',),
'båndknivene': ('båndkniv',),
'båndopptaker': ('båndopptaker',),
'båndopptakeren': ('båndopptaker',),
'båndopptakere': ('båndopptaker',),
'båndopptakerne': ('båndopptaker',),
'båndsalat': ('båndsalat',),
'båndsalaten': ('båndsalat',),
'båndsalater': ('båndsalat',),
'båndsalatene': ('båndsalat',),
'båndspeller': ('båndspeller',),
'båndspelleren': ('båndspeller',),
'båndspellere': ('båndspeller',),
'båndspellerne': ('båndspeller',),
'båndspiller': ('båndspiller',),
'båndspilleren': ('båndspiller',),
'båndspillere': ('båndspiller',),
'båndspillerne': ('båndspiller',),
'båndstål': ('båndstål',),
'båndstålet': ('båndstål',),
'båndstål': ('båndstål',),
'båndståla': ('båndstål',),
'båndstålene': ('båndstål',),
'båndtvang': ('båndtvang',),
'båndtvangen': ('båndtvang',),
'båndtvanger': ('båndtvang',),
'båndtvangene': ('båndtvang',),
'bånsull': ('bånsull',),
'bånsullen': ('bånsull',),
'bånsuller': ('bånsull',),
'bånsullene': ('bånsull',),
'bår': ('bår',),
'båren': ('bår',),
'båra': ('bår',),
'bårer': ('bår',),
'bårene': ('bår',),
'båre': ('båre',),
'båren': ('båre',),
'båra': ('båre',),
'bårer': ('båre',),
'bårene': ('båre',),
'bårerom': ('bårerom',),
'bårerommet': ('bårerom',),
'bårerom': ('bårerom',),
'båreromma': ('bårerom',),
'bårerommene': ('bårerom',),
'bås': ('bås',),
'båsen': ('bås',),
'båser': ('bås',),
'båsene': ('bås',),
'båsfjøs': ('båsfjøs',),
'båsfjøsen': ('båsfjøs',),
'båsfjøset': ('båsfjøs',),
'båsfjøs': ('båsfjøs',),
'båsfjøsene': ('båsfjøs',),
'båsfjøsa': ('båsfjøs',),
'båsfjøsene': ('båsfjøs',),
'båt': ('båt',),
'båten': ('båt',),
'båter': ('båt',),
'båtene': ('båt',),
'båtbygger': ('båtbygger',),
'båtbyggeren': ('båtbygger',),
'båtbyggere': ('båtbygger',),
'båtbyggerne': ('båtbygger',),
'båtbyggeri': ('båtbyggeri',),
'båtbyggeriet': ('båtbyggeri',),
'båtbyggeri': ('båtbyggeri',),
'båtbyggerier': ('båtbyggeri',),
'båtbyggeri': ('båtbyggeri',),
'båtbyggerier': ('båtbyggeri',),
'båtbyggeria': ('båtbyggeri',),
'båtbyggeriene': ('båtbyggeri',),
'båtdekk': ('båtdekk',),
'båtdekket': ('båtdekk',),
'båtdekk': ('båtdekk',),
'båtdekka': ('båtdekk',),
'båtdekkene': ('båtdekk',),
'båtfører': ('båtfører',),
'båtføreren': ('båtfører',),
'båtførere': ('båtfører',),
'båtførerne': ('båtfører',),
'båtførerbevis': ('båtførerbevis',),
'båtførerbeviset': ('båtførerbevis',),
'båtførerbevis': ('båtførerbevis',),
'båtførerbeviser': ('båtførerbevis',),
'båtførerbevis': ('båtførerbevis',),
'båtførerbeviser': ('båtførerbevis',),
'båtførerbevisa': ('båtførerbevis',),
'båtførerbevisene': ('båtførerbevis',),
'båthue': ('båthue',),
'båthuen': ('båthue',),
'båthua': ('båthue',),
'båthuer': ('båthue',),
'båthuene': ('båthue',),
'båthvelv': ('båthvelv',),
'båthvelvet': ('båthvelv',),
'båthvelv': ('båthvelv',),
'båthvelva': ('båthvelv',),
'båthvelvene': ('båthvelv',),
'båtkvelv': ('båtkvelv',),
'båtkvelven': ('båtkvelv',),
'båtkvelvet': ('båtkvelv',),
'båtkvelver': ('båtkvelv',),
'båtkvelv': ('båtkvelv',),
'båtkvelvene': ('båtkvelv',),
'båtkvelva': ('båtkvelv',),
'båtkvelvene': ('båtkvelv',),
'båtlengde': ('båtlengde',),
'båtlengden': ('båtlengde',),
'båtlengda': ('båtlengde',),
'båtlengder': ('båtlengde',),
'båtlengdene': ('båtlengde',),
'båtlue': ('båtlue',),
'båtluen': ('båtlue',),
'båtlua': ('båtlue',),
'båtluer': ('båtlue',),
'båtluene': ('båtlue',),
'båtmannskap': ('båtmannskap',),
'båtmannskapet': ('båtmannskap',),
'båtmannskap': ('båtmannskap',),
'båtmannskaper': ('båtmannskap',),
'båtmannskap': ('båtmannskap',),
'båtmannskaper': ('båtmannskap',),
'båtmannskapa': ('båtmannskap',),
'båtmannskapene': ('båtmannskap',),
'båtmotor': ('båtmotor',),
'båtmotoren': ('båtmotor',),
'båtmotorer': ('båtmotor',),
'båtmotorene': ('båtmotor',),
'båtnaust': ('båtnaust',),
'båtnaustet': ('båtnaust',),
'båtnaust': ('båtnaust',),
'båtnausta': ('båtnaust',),
'båtnaustene': ('båtnaust',),
'båtrip': ('båtrip',),
'båtripen': ('båtrip',),
'båtripa': ('båtrip',),
'båtriper': ('båtrip',),
'båtripene': ('båtrip',),
'båtripe': ('båtripe',),
'båtripen': ('båtripe',),
'båtripa': ('båtripe',),
'båtriper': ('båtripe',),
'båtripene': ('båtripe',),
'båtrute': ('båtrute',),
'båtruten': ('båtrute',),
'båtruta': ('båtrute',),
'båtruter': ('båtrute',),
'båtrutene': ('båtrute',),
'båtshake': ('båtshake',),
'båtshaken': ('båtshake',),
'båtshaker': ('båtshake',),
'båtshakene': ('båtshake',),
'båtsmann': ('båtsmann',),
'båtsmannen': ('båtsmann',),
'båtsmenn': ('båtsmann',),
'båtsmennene': ('båtsmann',),
'båtsmannsknop': ('båtsmannsknop',),
'båtsmannsknopen': ('båtsmannsknop',),
'båtsmannsknoper': ('båtsmannsknop',),
'båtsmannsknopene': ('båtsmannsknop',),
'båtsmannsstol': ('båtsmannsstol',),
'båtsmannsstolen': ('båtsmannsstol',),
'båtsmannsstoler': ('båtsmannsstol',),
'båtsmannsstolene': ('båtsmannsstol',),
'båtstø': ('båtstø',),
'båtstøen': ('båtstø',),
'båtstøa': ('båtstø',),
'båtstøer': ('båtstø',),
'båtstøene': ('båtstø',),
'båttur': ('båttur',),
'båtturen': ('båttur',),
'båtturer': ('båttur',),
'båtturene': ('båttur',),
'båtvett': ('båtvett',),
'båtvettet': ('båtvett',),
'båtvett': ('båtvett',),
'båtvetta': ('båtvett',),
'båtvettene': ('båtvett',),
'bæ': ('bæ',),
'bæet': ('bæ',),
'bæ': ('bæ',),
'bæa': ('bæ',),
'bæene': ('bæ',),
'bær': ('bær',),
'bæret': ('bær',),
'bær': ('bær',),
'bæra': ('bær',),
'bærene': ('bær',),
'bærbusk': ('bærbusk',),
'bærbusken': ('bærbusk',),
'bærbusker': ('bærbusk',),
'bærbuskene': ('bærbusk',),
'bærdyrking': ('bærdyrking',),
'bærdyrkingen': ('bærdyrking',),
'bærdyrkinga': ('bærdyrking',),
'bærdyrkinger': ('bærdyrking',),
'bærdyrkingene': ('bærdyrking',),
'bærebjelke': ('bærebjelke',),
'bærebjelken': ('bærebjelke',),
'bærebjelker': ('bærebjelke',),
'bærebjelkene': ('bærebjelke',),
'bærebølge': ('bærebølge',),
'bærebølgen': ('bærebølge',),
'bærebølga': ('bærebølge',),
'bærebølger': ('bærebølge',),
'bærebølgene': ('bærebølge',),
'bæreevne': ('bæreevne',),
'bæreevnen': ('bæreevne',),
'bæreevna': ('bæreevne',),
'bæreevner': ('bæreevne',),
'bæreevnene': ('bæreevne',),
'bæreplanbåt': ('bæreplanbåt',),
'bæreplanbåten': ('bæreplanbåt',),
'bæreplanbåter': ('bæreplanbåt',),
'bæreplanbåtene': ('bæreplanbåt',),
'bærepose': ('bærepose',),
'bæreposen': ('bærepose',),
'bæreposer': ('bærepose',),
'bæreposene': ('bærepose',),
'bærer': ('bærer',),
'bæreren': ('bærer',),
'bærere': ('bærer',),
'bærerne': ('bærer',),
'bærerakett': ('bærerakett',),
'bæreraketten': ('bærerakett',),
'bæreraketter': ('bærerakett',),
'bærerakettene': ('bærerakett',),
'bærestol': ('bærestol',),
'bærestolen': ('bærestol',),
'bærestoler': ('bærestol',),
'bærestolene': ('bærestol',),
'bærestykke': ('bærestykke',),
'bærestykket': ('bærestykke',),
'bærestykker': ('bærestykke',),
'bærestykka': ('bærestykke',),
'bærestykkene': ('bærestykke',),
'bærevegg': ('bærevegg',),
'bæreveggen': ('bærevegg',),
'bærevegger': ('bærevegg',),
'bæreveggene': ('bærevegg',),
'bærhøst': ('bærhøst',),
'bærhøsten': ('bærhøst',),
'bærhøster': ('bærhøst',),
'bærhøstene': ('bærhøst',),
'bærlyng': ('bærlyng',),
'bærlyngen': ('bærlyng',),
'bærlynget': ('bærlyng',),
'bærlynger': ('bærlyng',),
'bærlyng': ('bærlyng',),
'bærlyngene': ('bærlyng',),
'bærlynga': ('bærlyng',),
'bærlyngene': ('bærlyng',),
'bærplukker': ('bærplukker',),
'bærplukkeren': ('bærplukker',),
'bærplukkere': ('bærplukker',),
'bærplukkerne': ('bærplukker',),
'bærtue': ('bærtue',),
'bærtuen': ('bærtue',),
'bærtua': ('bærtue',),
'bærtuer': ('bærtue',),
'bærtuene': ('bærtue',),
'bærtur': ('bærtur',),
'bærturen': ('bærtur',),
'bærturer': ('bærtur',),
'bærturene': ('bærtur',),
'bæsj': ('bæsj',),
'bæsjen': ('bæsj',),
'bæsjer': ('bæsj',),
'bæsjene': ('bæsj',),
'bø': ('bø',),
'bøen': ('bø',),
'bøer': ('bø',),
'bøene': ('bø',),
'bø': ('bø',),
'bøet': ('bø',),
'bø': ('bø',),
'bøa': ('bø',),
'bøene': ('bø',),
'bøddel': ('bøddel',),
'bøddelen': ('bøddel',),
'bødler': ('bøddel',),
'bødlene': ('bøddel',),
'bøddelgjerning': ('bøddelgjerning',),
'bøddelgjerningen': ('bøddelgjerning',),
'bøddelgjerninga': ('bøddelgjerning',),
'bøddelgjerninger': ('bøddelgjerning',),
'bøddelgjerningene': ('bøddelgjerning',),
'bøddeløks': ('bøddeløks',),
'bøddeløksen': ('bøddeløks',),
'bøddeløksa': ('bøddeløks',),
'bøddeløkser': ('bøddeløks',),
'bøddeløksene': ('bøddeløks',),
'bøffel': ('bøffel',),
'bøffelen': ('bøffel',),
'bøfler': ('bøffel',),
'bøflene': ('bøffel',),
'bøffelgras': ('bøffelgras',),
'bøffelgraset': ('bøffelgras',),
'bøffelgras': ('bøffelgras',),
'bøffelgrasa': ('bøffelgras',),
'bøffelgrasene': ('bøffelgras',),
'bøffelgress': ('bøffelgress',),
'bøffelgresset': ('bøffelgress',),
'bøffelgress': ('bøffelgress',),
'bøffelgressa': ('bøffelgress',),
'bøffelgressene': ('bøffelgress',),
'bøffelku': ('bøffelku',),
'bøffelkuen': ('bøffelku',),
'bøffelkua': ('bøffelku',),
'bøffelkuer': ('bøffelku',),
'bøffelkyr': ('bøffelku',),
'bøffelkuer': ('bøffelku',),
'bøffelkyr': ('bøffelku',),
'bøffelkuene': ('bøffelku',),
'bøffelkyrne': ('bøffelku',),
'bøffelkuene': ('bøffelku',),
'bøffelkyrne': ('bøffelku',),
'bøffellær': ('bøffellær',),
'bøffellæret': ('bøffellær',),
'bøffellær': ('bøffellær',),
'bøffellæra': ('bøffellær',),
'bøffellærene': ('bøffellær',),
'bøffelokse': ('bøffelokse',),
'bøffeloksen': ('bøffelokse',),
'bøffelokser': ('bøffelokse',),
'bøffeloksene': ('bøffelokse',),
'bøhmer': ('bøhmer',),
'bøhmeren': ('bøhmer',),
'bøhmere': ('bøhmer',),
'bøhmerne': ('bøhmer',),
'bøk': ('bøk',),
'bøken': ('bøk',),
'bøker': ('bøk',),
'bøkene': ('bøk',),
'bøkelauv': ('bøkelauv',),
'bøkelauvet': ('bøkelauv',),
'bøkelauv': ('bøkelauv',),
'bøkelauva': ('bøkelauv',),
'bøkelauvene': ('bøkelauv',),
'bøkeløv': ('bøkeløv',),
'bøkeløvet': ('bøkeløv',),
'bøkeløv': ('bøkeløv',),
'bøkeløva': ('bøkeløv',),
'bøkeløvene': ('bøkeløv',),
'bøkenøtt': ('bøkenøtt',),
'bøkenøtten': ('bøkenøtt',),
'bøkenøtta': ('bøkenøtt',),
'bøkenøtter': ('bøkenøtt',),
'bøkenøttene': ('bøkenøtt',),
'bøkeskog': ('bøkeskog',),
'bøkeskogen': ('bøkeskog',),
'bøkeskoger': ('bøkeskog',),
'bøkeskogene': ('bøkeskog',),
'bøkker': ('bøkker',),
'bøkkeren': ('bøkker',),
'bøkkere': ('bøkker',),
'bøkkerne': ('bøkker',),
'bøkkerhandverk': ('bøkkerhandverk',),
'bøkkerhandverket': ('bøkkerhandverk',),
'bøkkerhandverk': ('bøkkerhandverk',),
'bøkkerhandverka': ('bøkkerhandverk',),
'bøkkerhandverkene': ('bøkkerhandverk',),
'bøkkerhåndverk': ('bøkkerhåndverk',),
'bøkkerhåndverket': ('bøkkerhåndverk',),
'bøkkerhåndverk': ('bøkkerhåndverk',),
'bøkkerhåndverka': ('bøkkerhåndverk',),
'bøkkerhåndverkene': ('bøkkerhåndverk',),
'bøkling': ('bøkling',),
'bøklingen': ('bøkling',),
'bøklinger': ('bøkling',),
'bøklingene': ('bøkling',),
'bøle': ('bøle',),
'bølet': ('bøle',),
'bøler': ('bøle',),
'bøla': ('bøle',),
'bølene': ('bøle',),
'bøle': ('bøle',),
'bølen': ('bøle',),
'bøla': ('bøle',),
'bøler': ('bøle',),
'bølene': ('bøle',),
'bølge': ('bølge',),
'bølgen': ('bølge',),
'bølga': ('bølge',),
'bølger': ('bølge',),
'bølgene': ('bølge',),
'bølgebevegelse': ('bølgebevegelse',),
'bølgebevegelsen': ('bølgebevegelse',),
'bølgebevegelser': ('bølgebevegelse',),
'bølgebevegelsene': ('bølgebevegelse',),
'bølgeblikk': ('bølgeblikk',),
'bølgeblikket': ('bølgeblikk',),
'bølgeblikk': ('bølgeblikk',),
'bølgeblikka': ('bølgeblikk',),
'bølgeblikkene': ('bølgeblikk',),
'bølgeblikkplate': ('bølgeblikkplate',),
'bølgeblikkplaten': ('bølgeblikkplate',),
'bølgeblikkplata': ('bølgeblikkplate',),
'bølgeblikkplater': ('bølgeblikkplate',),
'bølgeblikkplatene': ('bølgeblikkplate',),
'bølgebryter': ('bølgebryter',),
'bølgebryteren': ('bølgebryter',),
'bølgebrytere': ('bølgebryter',),
'bølgebryterne': ('bølgebryter',),
'bølgedal': ('bølgedal',),
'bølgedalen': ('bølgedal',),
'bølgedaler': ('bølgedal',),
'bølgedalene': ('bølgedal',),
'bølgedemper': ('bølgedemper',),
'bølgedemperen': ('bølgedemper',),
'bølgedempere': ('bølgedemper',),
'bølgedemperne': ('bølgedemper',),
'bølgeenergi': ('bølgeenergi',),
'bølgeenergien': ('bølgeenergi',),
'bølgeenergier': ('bølgeenergi',),
'bølgeenergiene': ('bølgeenergi',),
'bølgefront': ('bølgefront',),
'bølgefronten': ('bølgefront',),
'bølgefronter': ('bølgefront',),
'bølgefrontene': ('bølgefront',),
'bølgegang': ('bølgegang',),
'bølgegangen': ('bølgegang',),
'bølgeganger': ('bølgegang',),
'bølgegangene': ('bølgegang',),
'bølgekam': ('bølgekam',),
'bølgekammen': ('bølgekam',),
'bølgekammer': ('bølgekam',),
'bølgekammene': ('bølgekam',),
'bølgekraftverk': ('bølgekraftverk',),
'bølgekraftverket': ('bølgekraftverk',),
'bølgekraftverk': ('bølgekraftverk',),
'bølgekraftverker': ('bølgekraftverk',),
'bølgekraftverk': ('bølgekraftverk',),
'bølgekraftverker': ('bølgekraftverk',),
'bølgekraftverka': ('bølgekraftverk',),
'bølgekraftverkene': ('bølgekraftverk',),
'bølgelengde': ('bølgelengde',),
'bølgelengden': ('bølgelengde',),
'bølgelengda': ('bølgelengde',),
'bølgelengder': ('bølgelengde',),
'bølgelengdene': ('bølgelengde',),
'bølgelære': ('bølgelære',),
'bølgelæren': ('bølgelære',),
'bølgelæra': ('bølgelære',),
'bølgelærer': ('bølgelære',),
'bølgelærene': ('bølgelære',),
'bølgepapp': ('bølgepapp',),
'bølgepappen': ('bølgepapp',),
'bølgepapper': ('bølgepapp',),
'bølgepappene': ('bølgepapp',),
'bølgeplate': ('bølgeplate',),
'bølgeplaten': ('bølgeplate',),
'bølgeplata': ('bølgeplate',),
'bølgeplater': ('bølgeplate',),
'bølgeplatene': ('bølgeplate',),
'bølgerygg': ('bølgerygg',),
'bølgeryggen': ('bølgerygg',),
'bølgerygger': ('bølgerygg',),
'bølgeryggene': ('bølgerygg',),
'bølgetopp': ('bølgetopp',),
'bølgetoppen': ('bølgetopp',),
'bølgetopper': ('bølgetopp',),
'bølgetoppene': ('bølgetopp',),
'bølging': ('bølging',),
'bølgingen': ('bølging',),
'bølginga': ('bølging',),
'bølginger': ('bølging',),
'bølgingene': ('bølging',),
'bøling': ('bøling',),
'bølingen': ('bøling',),
'bølinger': ('bøling',),
'bølingene': ('bøling',),
'bølle': ('bølle',),
'bøllen': ('bølle',),
'bølla': ('bølle',),
'bøller': ('bølle',),
'bøllene': ('bølle',),
'bøllefrø': ('bøllefrø',),
'bøllefrøet': ('bøllefrø',),
'bøllefrø': ('bøllefrø',),
'bøllefrøa': ('bøllefrø',),
'bøllefrøene': ('bøllefrø',),
'bønn': ('bønn',),
'bønnen': ('bønn',),
'bønna': ('bønn',),
'bønner': ('bønn',),
'bønnene': ('bønn',),
'bønne': ('bønne',),
'bønnen': ('bønne',),
'bønna': ('bønne',),
'bønner': ('bønne',),
'bønnene': ('bønne',),
'bønnebok': ('bønnebok',),
'bønneboken': ('bønnebok',),
'bønneboka': ('bønnebok',),
'bønnebøker': ('bønnebok',),
'bønnebøkene': ('bønnebok',),
'bønneformular': ('bønneformular',),
'bønneformularen': ('bønneformular',),
'bønneformularet': ('bønneformular',),
'bønneformularer': ('bønneformular',),
'bønneformular': ('bønneformular',),
'bønneformularer': ('bønneformular',),
'bønneformular': ('bønneformular',),
'bønneformularer': ('bønneformular',),
'bønneformularene': ('bønneformular',),
'bønneformulara': ('bønneformular',),
'bønneformularene': ('bønneformular',),
'bønnematte': ('bønnematte',),
'bønnematten': ('bønnematte',),
'bønnematta': ('bønnematte',),
'bønnematter': ('bønnematte',),
'bønnemattene': ('bønnematte',),
'bønnemøte': ('bønnemøte',),
'bønnemøtet': ('bønnemøte',),
'bønnemøter': ('bønnemøte',),
'bønnemøta': ('bønnemøte',),
'bønnemøtene': ('bønnemøte',),
'bønnesamling': ('bønnesamling',),
'bønnesamlingen': ('bønnesamling',),
'bønnesamlinga': ('bønnesamling',),
'bønnesamlinger': ('bønnesamling',),
'bønnesamlingene': ('bønnesamling',),
'bønnestengel': ('bønnestengel',),
'bønnestengelen': ('bønnestengel',),
'bønnestengler': ('bønnestengel',),
'bønnestenglene': ('bønnestengel',),
'bønnesuppe': ('bønnesuppe',),
'bønnesuppen': ('bønnesuppe',),
'bønnesuppa': ('bønnesuppe',),
'bønnesupper': ('bønnesuppe',),
'bønnesuppene': ('bønnesuppe',),
'bønnevikke': ('bønnevikke',),
'bønnevikken': ('bønnevikke',),
'bønnevikka': ('bønnevikke',),
'bønnevikker': ('bønnevikke',),
'bønnevikkene': ('bønnevikke',),
'bønnskrift': ('bønnskrift',),
'bønnskriftet': ('bønnskrift',),
'bønnskrift': ('bønnskrift',),
'bønnskrifter': ('bønnskrift',),
'bønnskrift': ('bønnskrift',),
'bønnskrifter': ('bønnskrift',),
'bønnskrifta': ('bønnskrift',),
'bønnskriftene': ('bønnskrift',),
'bør': ('bør',),
'børen': ('bør',),
'børa': ('bør',),
'bører': ('bør',),
'børene': ('bør',),
'børe': ('børe',),
'børen': ('børe',),
'børa': ('børe',),
'bører': ('børe',),
'børene': ('børe',),
'børnskap': ('børnskap',),
'børnskapen': ('børnskap',),
'børnskaper': ('børnskap',),
'børnskapene': ('børnskap',),
'børs': ('børs',),
'børsen': ('børs',),
'børser': ('børs',),
'børsene': ('børs',),
'børse': ('børse',),
'børsen': ('børse',),
'børsa': ('børse',),
'børser': ('børse',),
'børsene': ('børse',),
'børsemaker': ('børsemaker',),
'børsemakeren': ('børsemaker',),
'børsemakere': ('børsemaker',),
'børsemakerne': ('børsemaker',),
'børsemunning': ('børsemunning',),
'børsemunningen': ('børsemunning',),
'børsemunninga': ('børsemunning',),
'børsemunninger': ('børsemunning',),
'børsemunningene': ('børsemunning',),
'børshai': ('børshai',),
'børshaien': ('børshai',),
'børshaier': ('børshai',),
'børshaiene': ('børshai',),
'børskommissær': ('børskommissær',),
'børskommissæren': ('børskommissær',),
'børskommissærer': ('børskommissær',),
'børskommissærene': ('børskommissær',),
'børskrakk': ('børskrakk',),
'børskrakket': ('børskrakk',),
'børskrakk': ('børskrakk',),
'børskrakka': ('børskrakk',),
'børskrakkene': ('børskrakk',),
'børsmegler': ('børsmegler',),
'børsmegleren': ('børsmegler',),
'børsmeglere': ('børsmegler',),
'børsmeglerne': ('børsmegler',),
'børsmekler': ('børsmekler',),
'børsmekleren': ('børsmekler',),
'børsmeklere': ('børsmekler',),
'børsmeklerne': ('børsmekler',),
'børsnotering': ('børsnotering',),
'børsnoteringen': ('børsnotering',),
'børsnoteringa': ('børsnotering',),
'børsnoteringer': ('børsnotering',),
'børsnoteringene': ('børsnotering',),
'børspapir': ('børspapir',),
'børspapiret': ('børspapir',),
'børspapir': ('børspapir',),
'børspapirer': ('børspapir',),
'børspapir': ('børspapir',),
'børspapirer': ('børspapir',),
'børspapira': ('børspapir',),
'børspapirene': ('børspapir',),
'børsspekulasjon': ('børsspekulasjon',),
'børsspekulasjonen': ('børsspekulasjon',),
'børsspekulasjoner': ('børsspekulasjon',),
'børsspekulasjonene': ('børsspekulasjon',),
'børst': ('børst',),
'børsten': ('børst',),
'børster': ('børst',),
'børstene': ('børst',),
'børste': ('børste',),
'børsten': ('børste',),
'børster': ('børste',),
'børstene': ('børste',),
'børstebinder': ('børstebinder',),
'børstebinderen': ('børstebinder',),
'børstebindere': ('børstebinder',),
'børstebinderne': ('børstebinder',),
'børstemakk': ('børstemakk',),
'børstemakken': ('børstemakk',),
'børstemakker': ('børstemakk',),
'børstemakkene': ('børstemakk',),
'børstemark': ('børstemark',),
'børstemarken': ('børstemark',),
'børstemarker': ('børstemark',),
'børstemarkene': ('børstemark',),
'børsteorm': ('børsteorm',),
'børsteormen': ('børsteorm',),
'børsteormer': ('børsteorm',),
'børsteormene': ('børsteorm',),
'bøss': ('bøss',),
'bøsset': ('bøss',),
'bøss': ('bøss',),
'bøssa': ('bøss',),
'bøssene': ('bøss',),
'bøsse': ('bøsse',),
'bøssen': ('bøsse',),
'bøssa': ('bøsse',),
'bøsser': ('bøsse',),
'bøssene': ('bøsse',),
'bøssing': ('bøssing',),
'bøssingen': ('bøssing',),
'bøssinger': ('bøssing',),
'bøssingene': ('bøssing',),
'bøteri': ('bøteri',),
'bøteriet': ('bøteri',),
'bøteri': ('bøteri',),
'bøterier': ('bøteri',),
'bøteri': ('bøteri',),
'bøterier': ('bøteri',),
'bøteria': ('bøteri',),
'bøteriene': ('bøteri',),
'bøtingsvon': ('bøtingsvon',),
'bøtingsvonen': ('bøtingsvon',),
'bøtingsvona': ('bøtingsvon',),
'bøtingsvoner': ('bøtingsvon',),
'bøtingsvonene': ('bøtingsvon',),
'bøtte': ('bøtte',),
'bøtten': ('bøtte',),
'bøtta': ('bøtte',),
'bøtter': ('bøtte',),
'bøttene': ('bøtte',),
'bøtteballett': ('bøtteballett',),
'bøtteballetten': ('bøtteballett',),
'bøtteballetter': ('bøtteballett',),
'bøtteballettene': ('bøtteballett',),
'bøttekott': ('bøttekott',),
'bøttekottet': ('bøttekott',),
'bøttekott': ('bøttekott',),
'bøttekotta': ('bøttekott',),
'bøttekottene': ('bøttekott',),
'bøttepapir': ('bøttepapir',),
'bøttepapiret': ('bøttepapir',),
'bøttepapir': ('bøttepapir',),
'bøttepapirer': ('bøttepapir',),
'bøttepapir': ('bøttepapir',),
'bøttepapirer': ('bøttepapir',),
'bøttepapira': ('bøttepapir',),
'bøttepapirene': ('bøttepapir',),
'bøy': ('bøy',),
'bøyen': ('bøy',),
'bøyer': ('bøy',),
'bøyene': ('bøy',),
'bøye': ('bøye',),
'bøyen': ('bøye',),
'bøyer': ('bøye',),
'bøyene': ('bøye',),
'bøye': ('bøye',),
'bøyen': ('bøye',),
'bøya': ('bøye',),
'bøyer': ('bøye',),
'bøyene': ('bøye',),
'bøyemuskel': ('bøyemuskel',),
'bøyemuskelen': ('bøyemuskel',),
'bøyemuskler': ('bøyemuskel',),
'bøyemusklene': ('bøyemuskel',),
'bøyeprøve': ('bøyeprøve',),
'bøyeprøven': ('bøyeprøve',),
'bøyeprøva': ('bøyeprøve',),
'bøyeprøver': ('bøyeprøve',),
'bøyeprøvene': ('bøyeprøve',),
'bøyg': ('bøyg',),
'bøygen': ('bøyg',),
'bøyger': ('bøyg',),
'bøygene': ('bøyg',),
'bøying': ('bøying',),
'bøyingen': ('bøying',),
'bøyinga': ('bøying',),
'bøyinger': ('bøying',),
'bøyingene': ('bøying',),
'bøyingsendelse': ('bøyingsendelse',),
'bøyingsendelsen': ('bøyingsendelse',),
'bøyingsendelser': ('bøyingsendelse',),
'bøyingsendelsene': ('bøyingsendelse',),
'bøyingsending': ('bøyingsending',),
'bøyingsendingen': ('bøyingsending',),
'bøyingsendinga': ('bøyingsending',),
'bøyingsendinger': ('bøyingsending',),
'bøyingsendingene': ('bøyingsending',),
'bøyingsform': ('bøyingsform',),
'bøyingsformen': ('bøyingsform',),
'bøyingsforma': ('bøyingsform',),
'bøyingsformer': ('bøyingsform',),
'bøyingsformene': ('bøyingsform',),
'bøyingsmønster': ('bøyingsmønster',),
'bøyingsmønsteret': ('bøyingsmønster',),
'bøyingsmønstret': ('bøyingsmønster',),
'bøyingsmønster': ('bøyingsmønster',),
'bøyingsmønstre': ('bøyingsmønster',),
'bøyingsmønstra': ('bøyingsmønster',),
'bøyingsmønstrene': ('bøyingsmønster',),
'bøyingsmønstra': ('bøyingsmønster',),
'bøyingsmønstrene': ('bøyingsmønster',),
'bøyingsspråk': ('bøyingsspråk',),
'bøyingsspråket': ('bøyingsspråk',),
'bøyingsspråk': ('bøyingsspråk',),
'bøyingsspråka': ('bøyingsspråk',),
'bøyingsspråkene': ('bøyingsspråk',),
'bøyingsverk': ('bøyingsverk',),
'bøyingsverket': ('bøyingsverk',),
'bøyingsverk': ('bøyingsverk',),
'bøyingsverker': ('bøyingsverk',),
'bøyingsverk': ('bøyingsverk',),
'bøyingsverker': ('bøyingsverk',),
'bøyingsverka': ('bøyingsverk',),
'bøyingsverkene': ('bøyingsverk',),
'bøyle': ('bøyle',),
'bøylen': ('bøyle',),
'bøyler': ('bøyle',),
'bøylene': ('bøyle',),
'bøylehest': ('bøylehest',),
'bøylehesten': ('bøylehest',),
'bøylehester': ('bøylehest',),
'bøylehestene': ('bøylehest',),
'bøyning': ('bøyning',),
'bøyningen': ('bøyning',),
'bøyninga': ('bøyning',),
'bøyninger': ('bøyning',),
'bøyningene': ('bøyning',),
'bøyningsendelse': ('bøyningsendelse',),
'bøyningsendelsen': ('bøyningsendelse',),
'bøyningsendelser': ('bøyningsendelse',),
'bøyningsendelsene': ('bøyningsendelse',),
'bøyningsending': ('bøyningsending',),
'bøyningsendingen': ('bøyningsending',),
'bøyningsendinga': ('bøyningsending',),
'bøyningsendinger': ('bøyningsending',),
'bøyningsendingene': ('bøyningsending',),
'bøyningsform': ('bøyningsform',),
'bøyningsformen': ('bøyningsform',),
'bøyningsforma': ('bøyningsform',),
'bøyningsformer': ('bøyningsform',),
'bøyningsformene': ('bøyningsform',),
'bøyningsmønster': ('bøyningsmønster',),
'bøyningsmønsteret': ('bøyningsmønster',),
'bøyningsmønstret': ('bøyningsmønster',),
'bøyningsmønster': ('bøyningsmønster',),
'bøyningsmønstre': ('bøyningsmønster',),
'bøyningsmønstra': ('bøyningsmønster',),
'bøyningsmønstrene': ('bøyningsmønster',),
'bøyningsmønstra': ('bøyningsmønster',),
'bøyningsmønstrene': ('bøyningsmønster',),
'bøyningsspråk': ('bøyningsspråk',),
'bøyningsspråket': ('bøyningsspråk',),
'bøyningsspråk': ('bøyningsspråk',),
'bøyningsspråka': ('bøyningsspråk',),
'bøyningsspråkene': ('bøyningsspråk',),
'bøyningsverk': ('bøyningsverk',),
'bøyningsverket': ('bøyningsverk',),
'bøyningsverk': ('bøyningsverk',),
'bøyningsverker': ('bøyningsverk',),
'bøyningsverk': ('bøyningsverk',),
'bøyningsverker': ('bøyningsverk',),
'bøyningsverka': ('bøyningsverk',),
'bøyningsverkene': ('bøyningsverk',),
'c': ('c',),
'c-en': ('c',),
'c-er': ('c',),
'c-ene': ('c',),
'cédille': ('cédille',),
'cédillen': ('cédille',),
'cédiller': ('cédille',),
'cédillene': ('cédille',),
'c-moll': ('c-moll',),
'c-mollen': ('c-moll',),
'c-moller': ('c-moll',),
'c-mollene': ('c-moll',),
'c-nøkkel': ('c-nøkkel',),
'c-nøkkelen': ('c-nøkkel',),
'c-nøkler': ('c-nøkkel',),
'c-nøklene': ('c-nøkkel',),
'cabincruiser': ('cabincruiser',),
'cabincruiseren': ('cabincruiser',),
'cabincruisere': ('cabincruiser',),
'cabincruiserne': ('cabincruiser',),
'caddie': ('caddie',),
'caddien': ('caddie',),
'caddier': ('caddie',),
'caddiene': ('caddie',),
'californier': ('californier',),
'californieren': ('californier',),
'californiere': ('californier',),
'californierne': ('californier',),
'californium': ('californium',),
'californiumet': ('californium',),
'californium': ('californium',),
'californiuma': ('californium',),
'californiumene': ('californium',),
'calling': ('calling',),
'callingen': ('calling',),
'callinger': ('calling',),
'callingene': ('calling',),
'calvados': ('calvados',),
'calvadosen': ('calvados',),
'calvadoser': ('calvados',),
'calvadosene': ('calvados',),
'calypso': ('calypso',),
'calypsoen': ('calypso',),
'calypsoer': ('calypso',),
'calypsoene': ('calypso',),
'calypsoorkester': ('calypsoorkester',),
'calypsoorkesteret': ('calypsoorkester',),
'calypsoorkestret': ('calypsoorkester',),
'calypsoorkester': ('calypsoorkester',),
'calypsoorkestre': ('calypsoorkester',),
'calypsoorkestra': ('calypsoorkester',),
'calypsoorkestrene': ('calypsoorkester',),
'calypsoorkestra': ('calypsoorkester',),
'calypsoorkestrene': ('calypsoorkester',),
'calypsotakt': ('calypsotakt',),
'calypsotakten': ('calypsotakt',),
'calypsotakta': ('calypsotakt',),
'calypsotakter': ('calypsotakt',),
'calypsotaktene': ('calypsotakt',),
'cambric': ('cambric',),
'cambricen': ('cambric',),
'cambricer': ('cambric',),
'cambricene': ('cambric',),
'camembert': ('camembert',),
'camemberten': ('camembert',),
'camemberter': ('camembert',),
'camembertene': ('camembert',),
'camorra': ('camorra',),
'camorraen': ('camorra',),
'camorraer': ('camorra',),
'camorraene': ('camorra',),
'camp': ('camp',),
'campen': ('camp',),
'camper': ('camp',),
'campene': ('camp',),
'camper': ('camper',),
'camperen': ('camper',),
'campere': ('camper',),
'camperne': ('camper',),
'camping': ('camping',),
'campingen': ('camping',),
'campinger': ('camping',),
'campingene': ('camping',),
'campinghytte': ('campinghytte',),
'campinghytten': ('campinghytte',),
'campinghytta': ('campinghytte',),
'campinghytter': ('campinghytte',),
'campinghyttene': ('campinghytte',),
'campingplass': ('campingplass',),
'campingplassen': ('campingplass',),
'campingplasser': ('campingplass',),
'campingplassene': ('campingplass',),
'campingutstyr': ('campingutstyr',),
'campingutstyret': ('campingutstyr',),
'campingutstyr': ('campingutstyr',),
'campingutstyra': ('campingutstyr',),
'campingutstyrene': ('campingutstyr',),
'campingvogn': ('campingvogn',),
'campingvognen': ('campingvogn',),
'campingvogna': ('campingvogn',),
'campingvogner': ('campingvogn',),
'campingvognene': ('campingvogn',),
'campus': ('campus',),
'campusen': ('campus',),
'campuser': ('campus',),
'campusene': ('campus',),
'canadier': ('canadier',),
'canadieren': ('canadier',),
'canadiere': ('canadier',),
'canadierne': ('canadier',),
'canasta': ('canasta',),
'canastaen': ('canasta',),
'canastaer': ('canasta',),
'canastaene': ('canasta',),
'cancan': ('cancan',),
'cancanen': ('cancan',),
'cancaner': ('cancan',),
'cancanene': ('cancan',),
'cancer': ('cancer',),
'canceren': ('cancer',),
'cancerer': ('cancer',),
'cancerene': ('cancer',),
'cand.mag.-eksamen': ('cand.mag.-eksamen',),
'cand.mag.-eksamenen': ('cand.mag.-eksamen',),
'cand.mag.-eksamener': ('cand.mag.-eksamen',),
'cand.mag.-eksamenene': ('cand.mag.-eksamen',),
'candela': ('candela',),
'candelaen': ('candela',),
'candela': ('candela',),
'candelaene': ('candela',),
'cannabis': ('cannabis',),
'cannabisen': ('cannabis',),
'cannabiser': ('cannabis',),
'cannabisene': ('cannabis',),
'cannabisplante': ('cannabisplante',),
'cannabisplanten': ('cannabisplante',),
'cannabisplanta': ('cannabisplante',),
'cannabisplanter': ('cannabisplante',),
'cannabisplantene': ('cannabisplante',),
'cannabisstoff': ('cannabisstoff',),
'cannabisstoffet': ('cannabisstoff',),
'cannabisstoff': ('cannabisstoff',),
'cannabisstoffer': ('cannabisstoff',),
'cannabisstoff': ('cannabisstoff',),
'cannabisstoffer': ('cannabisstoff',),
'cannabisstoffa': ('cannabisstoff',),
'cannabisstoffene': ('cannabisstoff',),
'canvassing': ('canvassing',),
'canvassingen': ('canvassing',),
'canvassinger': ('canvassing',),
'canvassingene': ('canvassing',),
'canyon': ('canyon',),
'canyonen': ('canyon',),
'canyoner': ('canyon',),
'canyonene': ('canyon',),
'cape': ('cape',),
'capen': ('cape',),
'caper': ('cape',),
'capene': ('cape',),
'cappuccino': ('cappuccino',),
'cappuccinoen': ('cappuccino',),
'cappuccinoer': ('cappuccino',),
'cappuccinoene': ('cappuccino',),
'capriccio': ('capriccio',),
'capriccioen': ('capriccio',),
'capriccioer': ('capriccio',),
'capriccioene': ('capriccio',),
'caravan': ('caravan',),
'caravanen': ('caravan',),
'caravaner': ('caravan',),
'caravanene': ('caravan',),
'cargo': ('cargo',),
'cargoen': ('cargo',),
'cargoer': ('cargo',),
'cargoene': ('cargo',),
'cargoliner': ('cargoliner',),
'cargolineren': ('cargoliner',),
'cargolinere': ('cargoliner',),
'cargolinerne': ('cargoliner',),
'carnet': ('carnet',),
'carneten': ('carnet',),
'carnetet': ('carnet',),
'carneter': ('carnet',),
'carnet': ('carnet',),
'carneter': ('carnet',),
'carnet': ('carnet',),
'carneter': ('carnet',),
'carnetene': ('carnet',),
'carneta': ('carnet',),
'carnetene': ('carnet',),
'carport': ('carport',),
'carporten': ('carport',),
'carporter': ('carport',),
'carportene': ('carport',),
'carrier': ('carrier',),
'carrieren': ('carrier',),
'carriere': ('carrier',),
'carrierne': ('carrier',),
'carte blanche': ('carte blanche',),
'casanova': ('casanova',),
'casanovaen': ('casanova',),
'casanovaer': ('casanova',),
'casanovaene': ('casanova',),
'case': ('case',),
'casen': ('case',),
'caser': ('case',),
'casene': ('case',),
'case study': ('case study',),
'casting': ('casting',),
'castingen': ('casting',),
'castinger': ('casting',),
'castingene': ('casting',),
'catering': ('catering',),
'cateringen': ('catering',),
'cateringer': ('catering',),
'cateringene': ('catering',),
'caterpillar': ('caterpillar',),
'caterpillaren': ('caterpillar',),
'caterpillarer': ('caterpillar',),
'caterpillarene': ('caterpillar',),
'catgut': ('catgut',),
'catguten': ('catgut',),
'catguter': ('catgut',),
'catgutene': ('catgut',),
'celebritet': ('celebritet',),
'celebriteten': ('celebritet',),
'celebriteter': ('celebritet',),
'celebritetene': ('celebritet',),
'celesta': ('celesta',),
'celestaen': ('celesta',),
'celestaer': ('celesta',),
'celestaene': ('celesta',),
'celle': ('celle',),
'cellen': ('celle',),
'cella': ('celle',),
'celler': ('celle',),
'cellene': ('celle',),
'cellebiologi': ('cellebiologi',),
'cellebiologien': ('cellebiologi',),
'cellebiologier': ('cellebiologi',),
'cellebiologiene': ('cellebiologi',),
'cellebro': ('cellebro',),
'cellebroen': ('cellebro',),
'cellebroa': ('cellebro',),
'cellebroer': ('cellebro',),
'cellebroene': ('cellebro',),
'cellebru': ('cellebru',),
'cellebruen': ('cellebru',),
'cellebrua': ('cellebru',),
'cellebruer': ('cellebru',),
'cellebruene': ('cellebru',),
'celledeling': ('celledeling',),
'celledelingen': ('celledeling',),
'celledelinga': ('celledeling',),
'celledelinger': ('celledeling',),
'celledelingene': ('celledeling',),
'cellegift': ('cellegift',),
'cellegiften': ('cellegift',),
'cellegifta': ('cellegift',),
'cellegifter': ('cellegift',),
'cellegiftene': ('cellegift',),
'cellekjerne': ('cellekjerne',),
'cellekjernen': ('cellekjerne',),
'cellekjerner': ('cellekjerne',),
'cellekjernene': ('cellekjerne',),
'cellekultur': ('cellekultur',),
'cellekulturen': ('cellekultur',),
'cellekulturer': ('cellekultur',),
'cellekulturene': ('cellekultur',),
'cellelære': ('cellelære',),
'cellelæren': ('cellelære',),
'cellelæra': ('cellelære',),
'cellelærer': ('cellelære',),
'cellelærene': ('cellelære',),
'cellemembran': ('cellemembran',),
'cellemembranen': ('cellemembran',),
'cellemembraner': ('cellemembran',),
'cellemembranene': ('cellemembran',),
'cellestoff': ('cellestoff',),
'cellestoffet': ('cellestoff',),
'cellestoff': ('cellestoff',),
'cellestoffer': ('cellestoff',),
'cellestoff': ('cellestoff',),
'cellestoffer': ('cellestoff',),
'cellestoffa': ('cellestoff',),
'cellestoffene': ('cellestoff',),
'cellevev': ('cellevev',),
'cellevevet': ('cellevev',),
'cellevev': ('cellevev',),
'celleveva': ('cellevev',),
'cellevevene': ('cellevev',),
'cellist': ('cellist',),
'cellisten': ('cellist',),
'cellister': ('cellist',),
'cellistene': ('cellist',),
'cello': ('cello',),
'celloen': ('cello',),
'celloer': ('cello',),
'celloene': ('cello',),
'cellofan': ('cellofan',),
'cellofanen': ('cellofan',),
'cellofaner': ('cellofan',),
'cellofanene': ('cellofan',),
'cellularpatologi': ('cellularpatologi',),
'cellularpatologien': ('cellularpatologi',),
'cellularpatologier': ('cellularpatologi',),
'cellularpatologiene': ('cellularpatologi',),
'cellull': ('cellull',),
'cellullen': ('cellull',),
'cellulla': ('cellull',),
'celluller': ('cellull',),
'cellullene': ('cellull',),
'celluloid': ('celluloid',),
'celluloiden': ('celluloid',),
'celluloider': ('celluloid',),
'celluloidene': ('celluloid',),
'cellulose': ('cellulose',),
'cellulosen': ('cellulose',),
'celluloser': ('cellulose',),
'cellulosene': ('cellulose',),
'cellulosefabrikk': ('cellulosefabrikk',),
'cellulosefabrikken': ('cellulosefabrikk',),
'cellulosefabrikker': ('cellulosefabrikk',),
'cellulosefabrikkene': ('cellulosefabrikk',),
'cellulosefilm': ('cellulosefilm',),
'cellulosefilmen': ('cellulosefilm',),
'cellulosefilmer': ('cellulosefilm',),
'cellulosefilmene': ('cellulosefilm',),
'celluloselakk': ('celluloselakk',),
'celluloselakken': ('celluloselakk',),
'celluloselakker': ('celluloselakk',),
'celluloselakkene': ('celluloselakk',),
'celluloselim': ('celluloselim',),
'celluloselimet': ('celluloselim',),
'celluloselim': ('celluloselim',),
'celluloselima': ('celluloselim',),
'celluloselimene': ('celluloselim',),
'cellulosemasse': ('cellulosemasse',),
'cellulosemassen': ('cellulosemasse',),
'cellulosemasser': ('cellulosemasse',),
'cellulosemassene': ('cellulosemasse',),
'cellulosenitrat': ('cellulosenitrat',),
'cellulosenitratet': ('cellulosenitrat',),
'cellulosenitrat': ('cellulosenitrat',),
'cellulosenitrater': ('cellulosenitrat',),
'cellulosenitrat': ('cellulosenitrat',),
'cellulosenitrater': ('cellulosenitrat',),
'cellulosenitrata': ('cellulosenitrat',),
'cellulosenitratene': ('cellulosenitrat',),
'cellulosepapp': ('cellulosepapp',),
'cellulosepappen': ('cellulosepapp',),
'cellulosepapper': ('cellulosepapp',),
'cellulosepappene': ('cellulosepapp',),
'cellulosevatt': ('cellulosevatt',),
'cellulosevatten': ('cellulosevatt',),
'cellulosevattet': ('cellulosevatt',),
'cellulosevatter': ('cellulosevatt',),
'cellulosevatt': ('cellulosevatt',),
'cellulosevattene': ('cellulosevatt',),
'cellulosevatta': ('cellulosevatt',),
'cellulosevattene': ('cellulosevatt',),
'celsius': ('celsius',),
'celsiusgrad': ('celsiusgrad',),
'celsiusgraden': ('celsiusgrad',),
'celsiusgrader': ('celsiusgrad',),
'celsiusgradene': ('celsiusgrad',),
'celsiusskala': ('celsiusskala',),
'celsiusskalaen': ('celsiusskala',),
'celsiusskalaer': ('celsiusskala',),
'celsiusskalaene': ('celsiusskala',),
'celsiustermometer': ('celsiustermometer',),
'celsiustermometeret': ('celsiustermometer',),
'celsiustermometret': ('celsiustermometer',),
'celsiustermometer': ('celsiustermometer',),
'celsiustermometre': ('celsiustermometer',),
'celsiustermometra': ('celsiustermometer',),
'celsiustermometrene': ('celsiustermometer',),
'celsiustermometra': ('celsiustermometer',),
'celsiustermometrene': ('celsiustermometer',),
'cembalist': ('cembalist',),
'cembalisten': ('cembalist',),
'cembalister': ('cembalist',),
'cembalistene': ('cembalist',),
'cembalo': ('cembalo',),
'cembaloen': ('cembalo',),
'cembaloer': ('cembalo',),
'cembaloene': ('cembalo',),
'cent': ('cent',),
'centen': ('cent',),
'cent': ('cent',),
'centene': ('cent',),
'centavo': ('centavo',),
'centavoen': ('centavo',),
'centavo': ('centavo',),
'centavos': ('centavo',),
'centavoene': ('centavo',),
'centesimo': ('centesimo',),
'centesimoen': ('centesimo',),
'centesimi': ('centesimo',),
'centesimiene': ('centesimo',),
'centigram': ('centigram',),
'centigrammet': ('centigram',),
'centigram': ('centigram',),
'centigramma': ('centigram',),
'centigrammene': ('centigram',),
'centime': ('centime',),
'centimen': ('centime',),
'centime': ('centime',),
'centimes': ('centime',),
'centimene': ('centime',),
'centimeter': ('centimeter',),
'centimeteren': ('centimeter',),
'centimeter': ('centimeter',),
'centimeterne': ('centimeter',),
'centimo': ('centimo',),
'centimoen': ('centimo',),
'centimo': ('centimo',),
'centimos': ('centimo',),
'centimoene': ('centimo',),
'cereal': ('cereal',),
'cerealet': ('cereal',),
'cereal': ('cereal',),
'cerealer': ('cereal',),
'cereal': ('cereal',),
'cerealer': ('cereal',),
'cereala': ('cereal',),
'cerealene': ('cereal',),
'cerebral parese': ('cerebral parese',),
'cerebral paresen': ('cerebral parese',),
'cerebral pareser': ('cerebral parese',),
'cerebral paresene': ('cerebral parese',),
'cerebral parese-pasient': ('cerebral parese-pasient',),
'cerebral parese-pasienten': ('cerebral parese-pasient',),
'cerebral parese-pasienter': ('cerebral parese-pasient',),
'cerebral parese-pasientene': ('cerebral parese-pasient',),
'cerebralparetiker': ('cerebralparetiker',),
'cerebralparetikeren': ('cerebralparetiker',),
'cerebralparetikere': ('cerebralparetiker',),
'cerebralparetikerne': ('cerebralparetiker',),
'cerise': ('cerise',),
'cerisen': ('cerise',),
'ceriser': ('cerise',),
'cerisene': ('cerise',),
'cerium': ('cerium',),
'ceriumet': ('cerium',),
'cerium': ('cerium',),
'ceriuma': ('cerium',),
'ceriumene': ('cerium',),
'certeparti': ('certeparti',),
'certepartiet': ('certeparti',),
'certeparti': ('certeparti',),
'certepartier': ('certeparti',),
'certeparti': ('certeparti',),
'certepartier': ('certeparti',),
'certepartia': ('certeparti',),
'certepartiene': ('certeparti',),
'cesium': ('cesium',),
'cesiumet': ('cesium',),
'cesium': ('cesium',),
'cesiuma': ('cesium',),
'cesiumene': ('cesium',),
'cess': ('cess',),
'cessen': ('cess',),
'cesser': ('cess',),
'cessene': ('cess',),
'cesur': ('cesur',),
'cesuren': ('cesur',),
'cesurer': ('cesur',),
'cesurene': ('cesur',),
'ceyloner': ('ceyloner',),
'ceyloneren': ('ceyloner',),
'ceylonere': ('ceyloner',),
'ceylonerne': ('ceyloner',),
'cha-cha-cha': ('cha-cha-cha',),
'cha-cha-chaen': ('cha-cha-cha',),
'cha-cha-chaer': ('cha-cha-cha',),
'cha-cha-chaene': ('cha-cha-cha',),
'chablis': ('chablis',),
'chablisen': ('chablis',),
'chabliser': ('chablis',),
'chablisene': ('chablis',),
'chaconne': ('chaconne',),
'chaconnen': ('chaconne',),
'chaconner': ('chaconne',),
'chaconnene': ('chaconne',),
'chamotte': ('chamotte',),
'chamotten': ('chamotte',),
'chamotter': ('chamotte',),
'chamottene': ('chamotte',),
'chamottestein': ('chamottestein',),
'chamottesteinen': ('chamottestein',),
'chamottesteiner': ('chamottestein',),
'chamottesteinene': ('chamottestein',),
'champagne': ('champagne',),
'champagnen': ('champagne',),
'champagner': ('champagne',),
'champagnene': ('champagne',),
'champagneglass': ('champagneglass',),
'champagneglasset': ('champagneglass',),
'champagneglass': ('champagneglass',),
'champagneglassa': ('champagneglass',),
'champagneglassene': ('champagneglass',),
'champion': ('champion',),
'championen': ('champion',),
'championer': ('champion',),
'championene': ('champion',),
'championat': ('championat',),
'championatet': ('championat',),
'championat': ('championat',),
'championata': ('championat',),
'championatene': ('championat',),
'chargé d\'affaires': ('chargé d\'affaires',),
'chargé d\'affairesen': ('chargé d\'affaires',),
'chargés d\'affaires': ('chargé d\'affaires',),
'chargé d\'affaires': ('chargé d\'affaires',),
'chargé d\'affairesen': ('chargé d\'affaires',),
'chargés d\'affaires': ('chargé d\'affaires',),
'chargés d\'affairesene': ('chargé d\'affaires',),
'charleston': ('charleston',),
'charlestonen': ('charleston',),
'charlestoner': ('charleston',),
'charlestonene': ('charleston',),
'charmeuse': ('charmeuse',),
'charmeusen': ('charmeuse',),
'charmeuser': ('charmeuse',),
'charmeusene': ('charmeuse',),
'charter': ('charter',),
'charteret': ('charter',),
'chartret': ('charter',),
'charter': ('charter',),
'chartre': ('charter',),
'chartra': ('charter',),
'chartrene': ('charter',),
'chartra': ('charter',),
'chartrene': ('charter',),
'charterfly': ('charterfly',),
'charterflyet': ('charterfly',),
'charterfly': ('charterfly',),
'charterflya': ('charterfly',),
'charterflyene': ('charterfly',),
'charterreise': ('charterreise',),
'charterreisen': ('charterreise',),
'charterreisa': ('charterreise',),
'charterreiser': ('charterreise',),
'charterreisene': ('charterreise',),
'chartertur': ('chartertur',),
'charterturen': ('chartertur',),
'charterturer': ('chartertur',),
'charterturene': ('chartertur',),
'chartreuse': ('chartreuse',),
'chartreusen': ('chartreuse',),
'chartreuser': ('chartreuse',),
'chartreusene': ('chartreuse',),
'chassis': ('chassis',),
'chassiset': ('chassis',),
'chassis': ('chassis',),
'chassiser': ('chassis',),
'chassis': ('chassis',),
'chassiser': ('chassis',),
'chassisa': ('chassis',),
'chassisene': ('chassis',),
'chassisnummer': ('chassisnummer',),
'chassisnummeret': ('chassisnummer',),
'chassisnummer': ('chassisnummer',),
'chassisnumre': ('chassisnummer',),
'chassisnumra': ('chassisnummer',),
'chassisnumrene': ('chassisnummer',),
'chassisnumra': ('chassisnummer',),
'chassisnumrene': ('chassisnummer',),
'chateau': ('chateau',),
'chateauet': ('chateau',),
'chateau': ('chateau',),
'chateauer': ('chateau',),
'chateau': ('chateau',),
'chateauer': ('chateau',),
'chateaua': ('chateau',),
'chateauene': ('chateau',),
'chateaubriand': ('chateaubriand',),
'chateaubrianden': ('chateaubriand',),
'chateaubriander': ('chateaubriand',),
'chateaubriandene': ('chateaubriand',),
'chateauvin': ('chateauvin',),
'chateauvinen': ('chateauvin',),
'chateauviner': ('chateauvin',),
'chateauvinene': ('chateauvin',),
'chaussé': ('chaussé',),
'chausséen': ('chaussé',),
'chausseen': ('chaussé',),
'chausséer': ('chaussé',),
'chausseer': ('chaussé',),
'chausséene': ('chaussé',),
'chausseene': ('chaussé',),
'cheddar': ('cheddar',),
'cheddaren': ('cheddar',),
'cheddarer': ('cheddar',),
'cheddarene': ('cheddar',),
'cheddarost': ('cheddarost',),
'cheddarosten': ('cheddarost',),
'cheddaroster': ('cheddarost',),
'cheddarostene': ('cheddarost',),
'chemise': ('chemise',),
'chemisen': ('chemise',),
'chemiser': ('chemise',),
'chemisene': ('chemise',),
'chenille': ('chenille',),
'chenillen': ('chenille',),
'cheniller': ('chenille',),
'chenillene': ('chenille',),
'chenillefrynse': ('chenillefrynse',),
'chenillefrynsen': ('chenillefrynse',),
'chenillefrynsa': ('chenillefrynse',),
'chenillefrynser': ('chenillefrynse',),
'chenillefrynsene': ('chenillefrynse',),
'chenillegarn': ('chenillegarn',),
'chenillegarnet': ('chenillegarn',),
'chenillegarn': ('chenillegarn',),
'chenillegarna': ('chenillegarn',),
'chenillegarnene': ('chenillegarn',),
'chenillegenser': ('chenillegenser',),
'chenillegenseren': ('chenillegenser',),
'chenillegensere': ('chenillegenser',),
'chenillegenserne': ('chenillegenser',),
'chianti': ('chianti',),
'chiantien': ('chianti',),
'chiantier': ('chianti',),
'chiantiene': ('chianti',),
'chief': ('chief',),
'chiefen': ('chief',),
'chiefer': ('chief',),
'chiefene': ('chief',),
'chiffer': ('chiffer',),
'chifferet': ('chiffer',),
'chiffer': ('chiffer',),
'chifre': ('chiffer',),
'chifra': ('chiffer',),
'chifrene': ('chiffer',),
'chifra': ('chiffer',),
'chifrene': ('chiffer',),
'chifferskrift': ('chifferskrift',),
'chifferskriften': ('chifferskrift',),
'chifferskrifta': ('chifferskrift',),
'chifferskrifter': ('chifferskrift',),
'chifferskriftene': ('chifferskrift',),
'chiffersystem': ('chiffersystem',),
'chiffersystemet': ('chiffersystem',),
'chiffersystem': ('chiffersystem',),
'chiffersystemer': ('chiffersystem',),
'chiffersystem': ('chiffersystem',),
'chiffersystemer': ('chiffersystem',),
'chiffersystema': ('chiffersystem',),
'chiffersystemene': ('chiffersystem',),
'chiffertekst': ('chiffertekst',),
'chifferteksten': ('chiffertekst',),
'chifferteksta': ('chiffertekst',),
'chiffertekster': ('chiffertekst',),
'chiffertekstene': ('chiffertekst',),
'chiffertelegram': ('chiffertelegram',),
'chiffertelegrammet': ('chiffertelegram',),
'chiffertelegram': ('chiffertelegram',),
'chiffertelegrammer': ('chiffertelegram',),
'chiffertelegramma': ('chiffertelegram',),
'chiffertelegrammene': ('chiffertelegram',),
'chiffertelegramma': ('chiffertelegram',),
'chiffertelegrammene': ('chiffertelegram',),
'chiffon': ('chiffon',),
'chiffonen': ('chiffon',),
'chiffoner': ('chiffon',),
'chiffonene': ('chiffon',),
'chiffonskjerf': ('chiffonskjerf',),
'chiffonskjerfet': ('chiffonskjerf',),
'chiffonskjerf': ('chiffonskjerf',),
'chiffonskjerfa': ('chiffonskjerf',),
'chiffonskjerfene': ('chiffonskjerf',),
'chihuahua': ('chihuahua',),
'chihuahuaen': ('chihuahua',),
'chihuahuaer': ('chihuahua',),
'chihuahuaene': ('chihuahua',),
'chilener': ('chilener',),
'chileneren': ('chilener',),
'chilenere': ('chilener',),
'chilenerne': ('chilener',),
'chilesalpeter': ('chilesalpeter',),
'chilesalpeteren': ('chilesalpeter',),
'chilesalpetere': ('chilesalpeter',),
'chilesalpetrer': ('chilesalpeter',),
'chilesalpeterne': ('chilesalpeter',),
'chilesalpetrene': ('chilesalpeter',),
'chilipepper': ('chilipepper',),
'chilipepperen': ('chilipepper',),
'chilipeppere': ('chilipepper',),
'chilipeprer': ('chilipepper',),
'chilipepperne': ('chilipepper',),
'chilipeprene': ('chilipepper',),
'chinchilla': ('chinchilla',),
'chinchillaen': ('chinchilla',),
'chinchillaer': ('chinchilla',),
'chinchillaene': ('chinchilla',),
'chinchillakanin': ('chinchillakanin',),
'chinchillakaninen': ('chinchillakanin',),
'chinchillakaniner': ('chinchillakanin',),
'chinchillakaninene': ('chinchillakanin',),
'chippendale': ('chippendale',),
'chips': ('chips',),
'chipsen': ('chips',),
'chips': ('chips',),
'chipsene': ('chips',),
'choke': ('choke',),
'choken': ('choke',),
'choker': ('choke',),
'chokene': ('choke',),
'chomageforsikring': ('chomageforsikring',),
'chomageforsikringen': ('chomageforsikring',),
'chomageforsikringa': ('chomageforsikring',),
'chomageforsikringer': ('chomageforsikring',),
'chomageforsikringene': ('chomageforsikring',),
'chow-chow': ('chow-chow',),
'chow-chowen': ('chow-chow',),
'chow-chower': ('chow-chow',),
'chow-chowene': ('chow-chow',),
'chuck': ('chuck',),
'chucken': ('chuck',),
'chucker': ('chuck',),
'chuckene': ('chuck',),
'chutney': ('chutney',),
'chutneyen': ('chutney',),
'chutneyer': ('chutney',),
'chutneyene': ('chutney',),
'cicero': ('cicero',),
'ciceroen': ('cicero',),
'cicero': ('cicero',),
'ciceroene': ('cicero',),
'cicerone': ('cicerone',),
'ciceronen': ('cicerone',),
'ciceroner': ('cicerone',),
'ciceronene': ('cicerone',),
'cinemascope': ('cinemascope',),
'cinemascopet': ('cinemascope',),
'cinemascoper': ('cinemascope',),
'cinemascopa': ('cinemascope',),
'cinemascopene': ('cinemascope',),
'cinematek': ('cinematek',),
'cinemateket': ('cinematek',),
'cinematek': ('cinematek',),
'cinemateker': ('cinematek',),
'cinematek': ('cinematek',),
'cinemateker': ('cinematek',),
'cinemateka': ('cinematek',),
'cinematekene': ('cinematek',),
'cirkapris': ('cirkapris',),
'cirkaprisen': ('cirkapris',),
'cirkapriser': ('cirkapris',),
'cirkaprisene': ('cirkapris',),
'cirkatall': ('cirkatall',),
'cirkatallet': ('cirkatall',),
'cirkatall': ('cirkatall',),
'cirkatalla': ('cirkatall',),
'cirkatallene': ('cirkatall',),
'cirkumfleks': ('cirkumfleks',),
'cirkumfleksen': ('cirkumfleks',),
'cirkumflekser': ('cirkumfleks',),
'cirkumfleksene': ('cirkumfleks',),
'cirrussky': ('cirrussky',),
'cirrusskyen': ('cirrussky',),
'cirrusskya': ('cirrussky',),
'cirrusskyer': ('cirrussky',),
'cirrusskyene': ('cirrussky',),
'ciss': ('ciss',),
'cissen': ('ciss',),
'cisser': ('ciss',),
'cissene': ('ciss',),
'ciss-moll': ('ciss-moll',),
'ciss-mollen': ('ciss-moll',),
'ciss-moller': ('ciss-moll',),
'ciss-mollene': ('ciss-moll',),
'cistercienser': ('cistercienser',),
'cistercienseren': ('cistercienser',),
'cisterciensere': ('cistercienser',),
'cistercienserne': ('cistercienser',),
'cisterciensermunk': ('cisterciensermunk',),
'cisterciensermunken': ('cisterciensermunk',),
'cisterciensermunker': ('cisterciensermunk',),
'cisterciensermunkene': ('cisterciensermunk',),
'cisterciensernonne': ('cisterciensernonne',),
'cisterciensernonnen': ('cisterciensernonne',),
'cisterciensernonna': ('cisterciensernonne',),
'cisterciensernonner': ('cisterciensernonne',),
'cisterciensernonnene': ('cisterciensernonne',),
'cistercienserorden': ('cistercienserorden',),
'cistercienserordenen': ('cistercienserorden',),
'cistercienserordener': ('cistercienserorden',),
'cistercienserordenene': ('cistercienserorden',),
'cisterne': ('cisterne',),
'cisternen': ('cisterne',),
'cisterna': ('cisterne',),
'cisterner': ('cisterne',),
'cisternene': ('cisterne',),
'citadell': ('citadell',),
'citadellet': ('citadell',),
'citadell': ('citadell',),
'citadeller': ('citadell',),
'citadell': ('citadell',),
'citadeller': ('citadell',),
'citadella': ('citadell',),
'citadellene': ('citadell',),
'citer': ('citer',),
'citeren': ('citer',),
'citere': ('citer',),
'citerne': ('citer',),
'city': ('city',),
'cityen': ('city',),
'cityer': ('city',),
'cityene': ('city',),
'clairobscur': ('clairobscur',),
'clairobscuret': ('clairobscur',),
'clairobscur': ('clairobscur',),
'clairobscura': ('clairobscur',),
'clairobscurene': ('clairobscur',),
'clairvoyance': ('clairvoyance',),
'clairvoyancen': ('clairvoyance',),
'clairvoyancer': ('clairvoyance',),
'clairvoyancene': ('clairvoyance',),
'clearing': ('clearing',),
'clearingen': ('clearing',),
'clearinger': ('clearing',),
'clearingene': ('clearing',),
'clearingkonto': ('clearingkonto',),
'clearingkontoen': ('clearingkonto',),
'clearingkontoer': ('clearingkonto',),
'clearingkonti': ('clearingkonto',),
'clearingkontoene': ('clearingkonto',),
'clearingkontiene': ('clearingkonto',),
'clinch': ('clinch',),
'clinchen': ('clinch',),
'clincher': ('clinch',),
'clinchene': ('clinch',),
'close race': ('close race',),
'clou': ('clou',),
'clouen': ('clou',),
'clouet': ('clou',),
'clou': ('clou',),
'clouene': ('clou',),
'cloua': ('clou',),
'clouene': ('clou',),
'clutch': ('clutch',),
'clutchen': ('clutch',),
'clutcher': ('clutch',),
'clutchene': ('clutch',),
'clutchpedal': ('clutchpedal',),
'clutchpedalen': ('clutchpedal',),
'clutchpedaler': ('clutchpedal',),
'clutchpedalene': ('clutchpedal',),
'cocker spaniel': ('cocker spaniel',),
'cocker spanielen': ('cocker spaniel',),
'cocker spanieler': ('cocker spaniel',),
'cocker spanielene': ('cocker spaniel',),
'cockney': ('cockney',),
'cockneyen': ('cockney',),
'cockneyer': ('cockney',),
'cockneyene': ('cockney',),
'cockpit': ('cockpit',),
'cockpiten': ('cockpit',),
'cockpiter': ('cockpit',),
'cockpitene': ('cockpit',),
'cocktail': ('cocktail',),
'cocktailen': ('cocktail',),
'cocktailer': ('cocktail',),
'cocktailene': ('cocktail',),
'cocktailbær': ('cocktailbær',),
'cocktailbæret': ('cocktailbær',),
'cocktailbær': ('cocktailbær',),
'cocktailbæra': ('cocktailbær',),
'cocktailbærene': ('cocktailbær',),
'cocktailkjole': ('cocktailkjole',),
'cocktailkjolen': ('cocktailkjole',),
'cocktailkjoler': ('cocktailkjole',),
'cocktailkjolene': ('cocktailkjole',),
'cocktailselskap': ('cocktailselskap',),
'cocktailselskapet': ('cocktailselskap',),
'cocktailselskap': ('cocktailselskap',),
'cocktailselskaper': ('cocktailselskap',),
'cocktailselskap': ('cocktailselskap',),
'cocktailselskaper': ('cocktailselskap',),
'cocktailselskapa': ('cocktailselskap',),
'cocktailselskapene': ('cocktailselskap',),
'coil': ('coil',),
'coilen': ('coil',),
'coiler': ('coil',),
'coilene': ('coil',),
'coitus interruptus': ('coitus interruptus',),
'collage': ('collage',),
'collagen': ('collage',),
'collager': ('collage',),
'collagene': ('collage',),
'college': ('college',),
'colleget': ('college',),
'colleger': ('college',),
'college': ('college',),
'colleger': ('college',),
'college': ('college',),
'collega': ('college',),
'collegene': ('college',),
'collegegenser': ('collegegenser',),
'collegegenseren': ('collegegenser',),
'collegegensere': ('collegegenser',),
'collegegenserne': ('collegegenser',),
'collie': ('collie',),
'collien': ('collie',),
'collier': ('collie',),
'colliene': ('collie',),
'collier': ('collier',),
'collieret': ('collier',),
'collier': ('collier',),
'collierer': ('collier',),
'collier': ('collier',),
'collierer': ('collier',),
'colliera': ('collier',),
'collierene': ('collier',),
'colombianer': ('colombianer',),
'colombianeren': ('colombianer',),
'colombianere': ('colombianer',),
'colombianerne': ('colombianer',),
'coltpistol': ('coltpistol',),
'coltpistolen': ('coltpistol',),
'coltpistoler': ('coltpistol',),
'coltpistolene': ('coltpistol',),
'columbi egg': ('columbi egg',),
'columbi egget': ('columbi egg',),
'columbi egg': ('columbi egg',),
'columbi egga': ('columbi egg',),
'columbi eggene': ('columbi egg',),
'comeback': ('comeback',),
'comebacken': ('comeback',),
'comebacket': ('comeback',),
'comeback': ('comeback',),
'comebackene': ('comeback',),
'comebacka': ('comeback',),
'comebackene': ('comeback',),
'commedia dell\'arte': ('commedia dell\'arte',),
'computertomografi': ('computertomografi',),
'computertomografien': ('computertomografi',),
'computertomografier': ('computertomografi',),
'computertomografiene': ('computertomografi',),
'conga': ('conga',),
'congaen': ('conga',),
'congaer': ('conga',),
'congaene': ('conga',),
'congatromme': ('congatromme',),
'congatrommen': ('congatromme',),
'congatromma': ('congatromme',),
'congatrommer': ('congatromme',),
'congatrommene': ('congatromme',),
'consommé': ('consommé',),
'consomméen': ('consommé',),
'consommeen': ('consommé',),
'consomméer': ('consommé',),
'consommeer': ('consommé',),
'consomméene': ('consommé',),
'consommeene': ('consommé',),
'container': ('container',),
'containeren': ('container',),
'containere': ('container',),
'containerne': ('container',),
'containerhavn': ('containerhavn',),
'containerhavnen': ('containerhavn',),
'containerhavna': ('containerhavn',),
'containerhavner': ('containerhavn',),
'containerhavnene': ('containerhavn',),
'containerskip': ('containerskip',),
'containerskipet': ('containerskip',),
'containerskip': ('containerskip',),
'containerskipa': ('containerskip',),
'containerskipene': ('containerskip',),
'copyright': ('copyright',),
'copyrighten': ('copyright',),
'copyrighter': ('copyright',),
'copyrightene': ('copyright',),
'copyrightmerke': ('copyrightmerke',),
'copyrightmerket': ('copyrightmerke',),
'copyrightmerker': ('copyrightmerke',),
'copyrightmerka': ('copyrightmerke',),
'copyrightmerkene': ('copyrightmerke',),
'copyrightside': ('copyrightside',),
'copyrightsiden': ('copyrightside',),
'copyrightsida': ('copyrightside',),
'copyrightsider': ('copyrightside',),
'copyrightsidene': ('copyrightside',),
'corner': ('corner',),
'corneren': ('corner',),
'cornere': ('corner',),
'cornerne': ('corner',),
'cornflakes': ('cornflakes',),
'cornflakesen': ('cornflakes',),
'cornflakeser': ('cornflakes',),
'cornflakesene': ('cornflakes',),
'corps de ballet': ('corps de ballet',),
'corps diplomatique': ('corps diplomatique',),
'cosinus': ('cosinus',),
'cosinusen': ('cosinus',),
'cosinuser': ('cosinus',),
'cosinusene': ('cosinus',),
'costaricaner': ('costaricaner',),
'costaricaneren': ('costaricaner',),
'costaricanere': ('costaricaner',),
'costaricanerne': ('costaricaner',),
'cotangens': ('cotangens',),
'cotangensen': ('cotangens',),
'cotangenser': ('cotangens',),
'cotangensene': ('cotangens',),
'cottage cheese': ('cottage cheese',),
'cottage cheese-en': ('cottage cheese',),
'cottage cheese-er': ('cottage cheese',),
'cottage cheese-ene': ('cottage cheese',),
'coulomb': ('coulomb',),
'coulomben': ('coulomb',),
'coulomb': ('coulomb',),
'coulombene': ('coulomb',),
'coulombmeter': ('coulombmeter',),
'coulombmeteret': ('coulombmeter',),
'coulombmetret': ('coulombmeter',),
'coulombmeter': ('coulombmeter',),
'coulombmetre': ('coulombmeter',),
'coulombmetra': ('coulombmeter',),
'coulombmetrene': ('coulombmeter',),
'coulombmetra': ('coulombmeter',),
'coulombmetrene': ('coulombmeter',),
'country and western': ('country and western',),
'countrymusikk': ('countrymusikk',),
'countrymusikken': ('countrymusikk',),
'countrymusikker': ('countrymusikk',),
'countrymusikkene': ('countrymusikk',),
'couronne': ('couronne',),
'couronnen': ('couronne',),
'couronner': ('couronne',),
'couronnene': ('couronne',),
'couscous': ('couscous',),
'couscousen': ('couscous',),
'couscouser': ('couscous',),
'couscousene': ('couscous',),
'cover': ('cover',),
'coveret': ('cover',),
'cover': ('cover',),
'covera': ('cover',),
'coverne': ('cover',),
'cover charge': ('cover charge',),
'cover chargen': ('cover charge',),
'cover charger': ('cover charge',),
'cover chargene': ('cover charge',),
'coverversjon': ('coverversjon',),
'coverversjonen': ('coverversjon',),
'coverversjoner': ('coverversjon',),
'coverversjonene': ('coverversjon',),
'cowboy': ('cowboy',),
'cowboyen': ('cowboy',),
'cowboyer': ('cowboy',),
'cowboyene': ('cowboy',),
'cowboyfilm': ('cowboyfilm',),
'cowboyfilmen': ('cowboyfilm',),
'cowboyfilmer': ('cowboyfilm',),
'cowboyfilmene': ('cowboyfilm',),
'cowboyhatt': ('cowboyhatt',),
'cowboyhatten': ('cowboyhatt',),
'cowboyhatter': ('cowboyhatt',),
'cowboyhattene': ('cowboyhatt',),
'cox': ('cox',),
'coxen': ('cox',),
'coxer': ('cox',),
'coxene': ('cox',),
'coyote': ('coyote',),
'coyoten': ('coyote',),
'coyoter': ('coyote',),
'coyotene': ('coyote',),
'crêpe': ('crêpe',),
'crêpen': ('crêpe',),
'crêper': ('crêpe',),
'crêpene': ('crêpe',),
'crêpe de chine': ('crêpe de chine',),
'crêpe georgette': ('crêpe georgette',),
'crêpe georgetten': ('crêpe georgette',),
'crêpe georgetter': ('crêpe georgette',),
'crêpe georgettene': ('crêpe georgette',),
'crazyfilm': ('crazyfilm',),
'crazyfilmen': ('crazyfilm',),
'crazyfilmer': ('crazyfilm',),
'crazyfilmene': ('crazyfilm',),
'crazyhumor': ('crazyhumor',),
'crazyhumoren': ('crazyhumor',),
'crazyhumorer': ('crazyhumor',),
'crazyhumorene': ('crazyhumor',),
'crazykomedie': ('crazykomedie',),
'crazykomedien': ('crazykomedie',),
'crazykomedier': ('crazykomedie',),
'crazykomediene': ('crazykomedie',),
'credo': ('credo',),
'credoet': ('credo',),
'credo': ('credo',),
'credoa': ('credo',),
'credoene': ('credo',),
'crescendo': ('crescendo',),
'crescendoen': ('crescendo',),
'crescendoet': ('crescendo',),
'crescendoer': ('crescendo',),
'crescendo': ('crescendo',),
'crescendoer': ('crescendo',),
'crescendo': ('crescendo',),
'crescendoer': ('crescendo',),
'crescendoene': ('crescendo',),
'crescendoa': ('crescendo',),
'crescendoene': ('crescendo',),
'cricket': ('cricket',),
'cricketen': ('cricket',),
'cricketer': ('cricket',),
'cricketene': ('cricket',),
'crimplene': ('crimplene',),
'crimplenet': ('crimplene',),
'crimplener': ('crimplene',),
'crimplena': ('crimplene',),
'crimplenene': ('crimplene',),
'cross': ('cross',),
'crosset': ('cross',),
'cross': ('cross',),
'crosser': ('cross',),
'cross': ('cross',),
'crosser': ('cross',),
'crossa': ('cross',),
'crossene': ('cross',),
'crossball': ('crossball',),
'crossballen': ('crossball',),
'crossballer': ('crossball',),
'crossballene': ('crossball',),
'croupier': ('croupier',),
'croupieren': ('croupier',),
'croupierer': ('croupier',),
'croupierene': ('croupier',),
'cruise': ('cruise',),
'cruiset': ('cruise',),
'cruise': ('cruise',),
'cruisa': ('cruise',),
'cruisene': ('cruise',),
'cruisefart': ('cruisefart',),
'cruisefarten': ('cruisefart',),
'cruisefarter': ('cruisefart',),
'cruisefartene': ('cruisefart',),
'cruiser': ('cruiser',),
'cruiseren': ('cruiser',),
'cruisere': ('cruiser',),
'cruiserne': ('cruiser',),
'cruiservekt': ('cruiservekt',),
'cruiservekten': ('cruiservekt',),
'cruiservekta': ('cruiservekt',),
'cruiservekter': ('cruiservekt',),
'cruiservektene': ('cruiservekt',),
'cruiseskip': ('cruiseskip',),
'cruiseskipet': ('cruiseskip',),
'cruiseskip': ('cruiseskip',),
'cruiseskipa': ('cruiseskip',),
'cruiseskipene': ('cruiseskip',),
'cruzeiro': ('cruzeiro',),
'cruzeiroen': ('cruzeiro',),
'cruzeiro': ('cruzeiro',),
'cruzeiros': ('cruzeiro',),
'cruzeiroene': ('cruzeiro',),
'csardas': ('csardas',),
'csardasen': ('csardas',),
'csardaser': ('csardas',),
'csardasene': ('csardas',),
'cubaner': ('cubaner',),
'cubaneren': ('cubaner',),
'cubanere': ('cubaner',),
'cubanerne': ('cubaner',),
'cup': ('cup',),
'cupen': ('cup',),
'cuper': ('cup',),
'cupene': ('cup',),
'cupfinale': ('cupfinale',),
'cupfinalen': ('cupfinale',),
'cupfinaler': ('cupfinale',),
'cupfinalene': ('cupfinale',),
'cupkamp': ('cupkamp',),
'cupkampen': ('cupkamp',),
'cupkamper': ('cupkamp',),
'cupkampene': ('cupkamp',),
'cupmester': ('cupmester',),
'cupmesteren': ('cupmester',),
'cupmestere': ('cupmester',),
'cupmestrer': ('cupmester',),
'cupmestre': ('cupmester',),
'cupmesterne': ('cupmester',),
'cupmestrene': ('cupmester',),
'cupmesterskap': ('cupmesterskap',),
'cupmesterskapet': ('cupmesterskap',),
'cupmesterskap': ('cupmesterskap',),
'cupmesterskaper': ('cupmesterskap',),
'cupmesterskap': ('cupmesterskap',),
'cupmesterskaper': ('cupmesterskap',),
'cupmesterskapa': ('cupmesterskap',),
'cupmesterskapene': ('cupmesterskap',),
'curaçao': ('curaçao',),
'curaçaoen': ('curaçao',),
'curaçaoer': ('curaçao',),
'curaçaoene': ('curaçao',),
'curare': ('curare',),
'curaren': ('curare',),
'curarer': ('curare',),
'curarene': ('curare',),
'curie': ('curie',),
'curieen': ('curie',),
'curie': ('curie',),
'curieene': ('curie',),
'curium': ('curium',),
'curiumet': ('curium',),
'curium': ('curium',),
'curiuma': ('curium',),
'curiumene': ('curium',),
'curler': ('curler',),
'curleren': ('curler',),
'curlere': ('curler',),
'curlerne': ('curler',),
'curling': ('curling',),
'curlingen': ('curling',),
'curlinger': ('curling',),
'curlingene': ('curling',),
'cyan': ('cyan',),
'cyanet': ('cyan',),
'cyan': ('cyan',),
'cyana': ('cyan',),
'cyanene': ('cyan',),
'cyanamid': ('cyanamid',),
'cyanamidet': ('cyanamid',),
'cyanamid': ('cyanamid',),
'cyanamider': ('cyanamid',),
'cyanamid': ('cyanamid',),
'cyanamider': ('cyanamid',),
'cyanamida': ('cyanamid',),
'cyanamidene': ('cyanamid',),
'cyanid': ('cyanid',),
'cyanidet': ('cyanid',),
'cyanid': ('cyanid',),
'cyanider': ('cyanid',),
'cyanid': ('cyanid',),
'cyanider': ('cyanid',),
'cyanida': ('