# coding: utf8
"""
All wordforms are extracted from Norsk Ordbank in Norwegian Bokmål 2005,  updated 20180627
(CLARINO NB - Språkbanken), Nasjonalbiblioteket, Norway:
https://www.nb.no/sprakbanken/show?serial=oai%3Anb.no%3Asbr-5&lang=en
License:
Creative_Commons-BY (CC-BY) (https://creativecommons.org/licenses/by/4.0/)
"""

from __future__ import unicode_literals

VERBS_WORDFORMS = {
'abandonere': ('abandonere',),
'abandonerer': ('abandonere',),
'abandoneres': ('abandonere',),
'abandonerte': ('abandonere',),
'abandonert': ('abandonere',),
'abandoner': ('abandonere',),
'abbreviere': ('abbreviere',),
'abbrevierer': ('abbreviere',),
'abbrevieres': ('abbreviere',),
'abbrevierte': ('abbreviere',),
'abbreviert': ('abbreviere',),
'abbrevier': ('abbreviere',),
'abdisere': ('abdisere',),
'abdiserer': ('abdisere',),
'abdiseres': ('abdisere',),
'abdiserte': ('abdisere',),
'abdisert': ('abdisere',),
'abdiser': ('abdisere',),
'abonnere': ('abonnere',),
'abonnerer': ('abonnere',),
'abonneres': ('abonnere',),
'abonnerte': ('abonnere',),
'abonnert': ('abonnere',),
'abonner': ('abonnere',),
'abortere': ('abortere',),
'aborterer': ('abortere',),
'aborteres': ('abortere',),
'aborterte': ('abortere',),
'abortert': ('abortere',),
'aborter': ('abortere',),
'absentere': ('absentere',),
'absenterer': ('absentere',),
'absenteres': ('absentere',),
'absenterte': ('absentere',),
'absentert': ('absentere',),
'absenter': ('absentere',),
'absolvere': ('absolvere',),
'absolverer': ('absolvere',),
'absolveres': ('absolvere',),
'absolverte': ('absolvere',),
'absolvert': ('absolvere',),
'absolver': ('absolvere',),
'absorbere': ('absorbere',),
'absorberer': ('absorbere',),
'absorberes': ('absorbere',),
'absorberte': ('absorbere',),
'absorbert': ('absorbere',),
'absorber': ('absorbere',),
'abstrahere': ('abstrahere',),
'abstraherer': ('abstrahere',),
'abstraheres': ('abstrahere',),
'abstraherte': ('abstrahere',),
'abstrahert': ('abstrahere',),
'abstraher': ('abstrahere',),
'adaptere': ('adaptere',),
'adapterer': ('adaptere',),
'adapteres': ('adaptere',),
'adapterte': ('adaptere',),
'adaptert': ('adaptere',),
'adapter': ('adaptere',),
'addere': ('addere',),
'adderer': ('addere',),
'adderes': ('addere',),
'adderte': ('addere',),
'addert': ('addere',),
'adder': ('addere',),
'adherere': ('adherere',),
'adhererer': ('adherere',),
'adhereres': ('adherere',),
'adhererte': ('adherere',),
'adherert': ('adherere',),
'adherer': ('adherere',),
'adjektivere': ('adjektivere',),
'adjektiverer': ('adjektivere',),
'adjektiveres': ('adjektivere',),
'adjektiverte': ('adjektivere',),
'adjektivert': ('adjektivere',),
'adjektiver': ('adjektivere',),
'adle': ('adle',),
'adler': ('adle',),
'adles': ('adle',),
'adla': ('adle',),
'adlet': ('adle',),
'adla': ('adle',),
'adlet': ('adle',),
'adl': ('adle',),
'adle': ('adle',),
'adl': ('adle',),
'adle': ('adle',),
'adlyde': ('adlyde',),
'adlyder': ('adlyde',),
'adlydes': ('adlyde',),
'adlød': ('adlyde',),
'adlydt': ('adlyde',),
'adlyd': ('adlyde',),
'administrere': ('administrere',),
'administrerer': ('administrere',),
'administreres': ('administrere',),
'administrerte': ('administrere',),
'administrert': ('administrere',),
'administrer': ('administrere',),
'adoptere': ('adoptere',),
'adopterer': ('adoptere',),
'adopteres': ('adoptere',),
'adopterte': ('adoptere',),
'adoptert': ('adoptere',),
'adopter': ('adoptere',),
'adressere': ('adressere',),
'adresserer': ('adressere',),
'adresseres': ('adressere',),
'adresserte': ('adressere',),
'adressert': ('adressere',),
'adresser': ('adressere',),
'adsorbere': ('adsorbere',),
'adsorberer': ('adsorbere',),
'adsorberes': ('adsorbere',),
'adsorberte': ('adsorbere',),
'adsorbert': ('adsorbere',),
'adsorber': ('adsorbere',),
'adstringere': ('adstringere',),
'adstringerer': ('adstringere',),
'adstringeres': ('adstringere',),
'adstringerte': ('adstringere',),
'adstringert': ('adstringere',),
'adstringer': ('adstringere',),
'advare': ('advare',),
'advarer': ('advare',),
'advares': ('advare',),
'advarte': ('advare',),
'advart': ('advare',),
'advar': ('advare',),
'advisere': ('advisere',),
'adviserer': ('advisere',),
'adviseres': ('advisere',),
'adviserte': ('advisere',),
'advisert': ('advisere',),
'adviser': ('advisere',),
'affektere': ('affektere',),
'affekterer': ('affektere',),
'affekteres': ('affektere',),
'affekterte': ('affektere',),
'affektert': ('affektere',),
'affekter': ('affektere',),
'affisere': ('affisere',),
'affiserer': ('affisere',),
'affiseres': ('affisere',),
'affiserte': ('affisere',),
'affisert': ('affisere',),
'affiser': ('affisere',),
'afrikanisere': ('afrikanisere',),
'afrikaniserer': ('afrikanisere',),
'afrikaniseres': ('afrikanisere',),
'afrikaniserte': ('afrikanisere',),
'afrikanisert': ('afrikanisere',),
'afrikaniser': ('afrikanisere',),
'age': ('age',),
'ager': ('age',),
'ages': ('age',),
'aga': ('age',),
'aget': ('age',),
'aga': ('age',),
'aget': ('age',),
'ag': ('age',),
'agere': ('agere',),
'agerer': ('agere',),
'ageres': ('agere',),
'agerte': ('agere',),
'agert': ('agere',),
'ager': ('agere',),
'agglutinere': ('agglutinere',),
'agglutinerer': ('agglutinere',),
'agglutineres': ('agglutinere',),
'agglutinerte': ('agglutinere',),
'agglutinert': ('agglutinere',),
'agglutiner': ('agglutinere',),
'agitere': ('agitere',),
'agiterer': ('agitere',),
'agiteres': ('agitere',),
'agiterte': ('agitere',),
'agitert': ('agitere',),
'agiter': ('agitere',),
'agne': ('agne',),
'agner': ('agne',),
'agnes': ('agne',),
'agna': ('agne',),
'agnet': ('agne',),
'agna': ('agne',),
'agnet': ('agne',),
'agn': ('agne',),
'ajourføre': ('ajourføre',),
'ajourfører': ('ajourføre',),
'ajourføres': ('ajourføre',),
'ajourførte': ('ajourføre',),
'ajourført': ('ajourføre',),
'ajourfør': ('ajourføre',),
'ake': ('ake',),
'aker': ('ake',),
'akes': ('ake',),
'akte': ('ake',),
'akt': ('ake',),
'ak': ('ake',),
'akke': ('akke',),
'akker': ('akke',),
'akkes': ('akke',),
'akka': ('akke',),
'akket': ('akke',),
'akka': ('akke',),
'akket': ('akke',),
'akk': ('akke',),
'akkedere': ('akkedere',),
'akkederer': ('akkedere',),
'akkederes': ('akkedere',),
'akkederte': ('akkedere',),
'akkedert': ('akkedere',),
'akkeder': ('akkedere',),
'akklimatisere': ('akklimatisere',),
'akklimatiserer': ('akklimatisere',),
'akklimatiseres': ('akklimatisere',),
'akklimatiserte': ('akklimatisere',),
'akklimatisert': ('akklimatisere',),
'akklimatiser': ('akklimatisere',),
'akkommodere': ('akkommodere',),
'akkommoderer': ('akkommodere',),
'akkommoderes': ('akkommodere',),
'akkommoderte': ('akkommodere',),
'akkommodert': ('akkommodere',),
'akkommoder': ('akkommodere',),
'akkompagnere': ('akkompagnere',),
'akkompagnerer': ('akkompagnere',),
'akkompagneres': ('akkompagnere',),
'akkompagnerte': ('akkompagnere',),
'akkompagnert': ('akkompagnere',),
'akkompagner': ('akkompagnere',),
'akkordere': ('akkordere',),
'akkorderer': ('akkordere',),
'akkorderes': ('akkordere',),
'akkorderte': ('akkordere',),
'akkordert': ('akkordere',),
'akkorder': ('akkordere',),
'akkreditere': ('akkreditere',),
'akkrediterer': ('akkreditere',),
'akkrediteres': ('akkreditere',),
'akkrediterte': ('akkreditere',),
'akkreditert': ('akkreditere',),
'akkrediter': ('akkreditere',),
'akkumulere': ('akkumulere',),
'akkumulerer': ('akkumulere',),
'akkumuleres': ('akkumulere',),
'akkumulerte': ('akkumulere',),
'akkumulert': ('akkumulere',),
'akkumuler': ('akkumulere',),
'akkvirere': ('akkvirere',),
'akkvirerer': ('akkvirere',),
'akkvireres': ('akkvirere',),
'akkvirerte': ('akkvirere',),
'akkvirert': ('akkvirere',),
'akkvirer': ('akkvirere',),
'akselerere': ('akselerere',),
'akselererer': ('akselerere',),
'akselereres': ('akselerere',),
'akselererte': ('akselerere',),
'akselerert': ('akselerere',),
'akselerer': ('akselerere',),
'aksentuere': ('aksentuere',),
'aksentuerer': ('aksentuere',),
'aksentueres': ('aksentuere',),
'aksentuerte': ('aksentuere',),
'aksentuert': ('aksentuere',),
'aksentuer': ('aksentuere',),
'akseptere': ('akseptere',),
'aksepterer': ('akseptere',),
'aksepteres': ('akseptere',),
'aksepterte': ('akseptere',),
'akseptert': ('akseptere',),
'aksepter': ('akseptere',),
'aksjonere': ('aksjonere',),
'aksjonerer': ('aksjonere',),
'aksjoneres': ('aksjonere',),
'aksjonerte': ('aksjonere',),
'aksjonert': ('aksjonere',),
'aksjoner': ('aksjonere',),
'aksle': ('aksle',),
'aksler': ('aksle',),
'aksles': ('aksle',),
'aksla': ('aksle',),
'akslet': ('aksle',),
'aksla': ('aksle',),
'akslet': ('aksle',),
'aksl': ('aksle',),
'aksle': ('aksle',),
'aksl': ('aksle',),
'aksle': ('aksle',),
'akte': ('akte',),
'akter': ('akte',),
'aktes': ('akte',),
'akta': ('akte',),
'aktet': ('akte',),
'akta': ('akte',),
'aktet': ('akte',),
'akt': ('akte',),
'akterutsegle': ('akterutsegle',),
'akterutsegler': ('akterutsegle',),
'akterutsegles': ('akterutsegle',),
'akterutsegla': ('akterutsegle',),
'akterutseglet': ('akterutsegle',),
'akterutsegla': ('akterutsegle',),
'akterutseglet': ('akterutsegle',),
'akterutsegl': ('akterutsegle',),
'akterutsegle': ('akterutsegle',),
'akterutsegl': ('akterutsegle',),
'akterutsegle': ('akterutsegle',),
'akterutseile': ('akterutseile',),
'akterutseiler': ('akterutseile',),
'akterutseiles': ('akterutseile',),
'akterutseilte': ('akterutseile',),
'akterutseilt': ('akterutseile',),
'akterutseil': ('akterutseile',),
'aktivere': ('aktivere',),
'aktiverer': ('aktivere',),
'aktiveres': ('aktivere',),
'aktiverte': ('aktivere',),
'aktivert': ('aktivere',),
'aktiver': ('aktivere',),
'aktivisere': ('aktivisere',),
'aktiviserer': ('aktivisere',),
'aktiviseres': ('aktivisere',),
'aktiviserte': ('aktivisere',),
'aktivisert': ('aktivisere',),
'aktiviser': ('aktivisere',),
'aktualisere': ('aktualisere',),
'aktualiserer': ('aktualisere',),
'aktualiseres': ('aktualisere',),
'aktualiserte': ('aktualisere',),
'aktualisert': ('aktualisere',),
'aktualiser': ('aktualisere',),
'alarmere': ('alarmere',),
'alarmerer': ('alarmere',),
'alarmeres': ('alarmere',),
'alarmerte': ('alarmere',),
'alarmert': ('alarmere',),
'alarmer': ('alarmere',),
'albue': ('albue',),
'albuer': ('albue',),
'albues': ('albue',),
'albua': ('albue',),
'albuet': ('albue',),
'albua': ('albue',),
'albuet': ('albue',),
'albu': ('albue',),
'aldersbestemme': ('aldersbestemme',),
'aldersbestemmer': ('aldersbestemme',),
'aldersbestemmes': ('aldersbestemme',),
'aldersbestemte': ('aldersbestemme',),
'aldersbestemt': ('aldersbestemme',),
'aldersbestem': ('aldersbestemme',),
'aldre': ('aldre',),
'aldrer': ('aldre',),
'aldres': ('aldre',),
'aldra': ('aldre',),
'aldret': ('aldre',),
'aldra': ('aldre',),
'aldret': ('aldre',),
'aldr': ('aldre',),
'aldre': ('aldre',),
'aldr': ('aldre',),
'aldre': ('aldre',),
'aldres': ('aldres',),
'aldredes': ('aldres',),
'aldres': ('aldres',),
'ale': ('ale',),
'aler': ('ale',),
'ales': ('ale',),
'alet': ('ale',),
'alte': ('ale',),
'alet': ('ale',),
'alt': ('ale',),
'al': ('ale',),
'alfabetisere': ('alfabetisere',),
'alfabetiserer': ('alfabetisere',),
'alfabetiseres': ('alfabetisere',),
'alfabetiserte': ('alfabetisere',),
'alfabetisert': ('alfabetisere',),
'alfabetiser': ('alfabetisere',),
'alienere': ('alienere',),
'alienerer': ('alienere',),
'alieneres': ('alienere',),
'alienerte': ('alienere',),
'alienert': ('alienere',),
'aliener': ('alienere',),
'alkoholisere': ('alkoholisere',),
'alkoholiserer': ('alkoholisere',),
'alkoholiseres': ('alkoholisere',),
'alkoholiserte': ('alkoholisere',),
'alkoholisert': ('alkoholisere',),
'alkoholiser': ('alkoholisere',),
'alliere': ('alliere',),
'allierer': ('alliere',),
'allieres': ('alliere',),
'allierte': ('alliere',),
'alliert': ('alliere',),
'allier': ('alliere',),
'allitterere': ('allitterere',),
'allittererer': ('allitterere',),
'allittereres': ('allitterere',),
'allittererte': ('allitterere',),
'allitterert': ('allitterere',),
'allitterer': ('allitterere',),
'allokere': ('allokere',),
'allokerer': ('allokere',),
'allokeres': ('allokere',),
'allokerte': ('allokere',),
'allokert': ('allokere',),
'alloker': ('allokere',),
'alludere': ('alludere',),
'alluderer': ('alludere',),
'alluderes': ('alludere',),
'alluderte': ('alludere',),
'alludert': ('alludere',),
'alluder': ('alludere',),
'alterere': ('alterere',),
'altererer': ('alterere',),
'altereres': ('alterere',),
'altererte': ('alterere',),
'alterert': ('alterere',),
'alterer': ('alterere',),
'alternere': ('alternere',),
'alternerer': ('alternere',),
'alterneres': ('alternere',),
'alternerte': ('alternere',),
'alternert': ('alternere',),
'alterner': ('alternere',),
'aluminere': ('aluminere',),
'aluminerer': ('aluminere',),
'alumineres': ('aluminere',),
'aluminerte': ('aluminere',),
'aluminert': ('aluminere',),
'aluminer': ('aluminere',),
'amalgamere': ('amalgamere',),
'amalgamerer': ('amalgamere',),
'amalgameres': ('amalgamere',),
'amalgamerte': ('amalgamere',),
'amalgamert': ('amalgamere',),
'amalgamer': ('amalgamere',),
'ambulere': ('ambulere',),
'ambulerer': ('ambulere',),
'ambuleres': ('ambulere',),
'ambulerte': ('ambulere',),
'ambulert': ('ambulere',),
'ambuler': ('ambulere',),
'amerikanisere': ('amerikanisere',),
'amerikaniserer': ('amerikanisere',),
'amerikaniseres': ('amerikanisere',),
'amerikaniserte': ('amerikanisere',),
'amerikanisert': ('amerikanisere',),
'amerikaniser': ('amerikanisere',),
'amme': ('amme',),
'ammer': ('amme',),
'ammes': ('amme',),
'amma': ('amme',),
'ammet': ('amme',),
'amma': ('amme',),
'ammet': ('amme',),
'am': ('amme',),
'amortisere': ('amortisere',),
'amortiserer': ('amortisere',),
'amortiseres': ('amortisere',),
'amortiserte': ('amortisere',),
'amortisert': ('amortisere',),
'amortiser': ('amortisere',),
'amputere': ('amputere',),
'amputerer': ('amputere',),
'amputeres': ('amputere',),
'amputerte': ('amputere',),
'amputert': ('amputere',),
'amputer': ('amputere',),
'analysere': ('analysere',),
'analyserer': ('analysere',),
'analyseres': ('analysere',),
'analyserte': ('analysere',),
'analysert': ('analysere',),
'analyser': ('analysere',),
'anbefale': ('anbefale',),
'anbefaler': ('anbefale',),
'anbefales': ('anbefale',),
'anbefalte': ('anbefale',),
'anbefalt': ('anbefale',),
'anbefal': ('anbefale',),
'anbringe': ('anbringe',),
'anbringer': ('anbringe',),
'anbringes': ('anbringe',),
'anbrakte': ('anbringe',),
'anbrakt': ('anbringe',),
'anbring': ('anbringe',),
'ande': ('ande',),
'ander': ('ande',),
'andes': ('ande',),
'anda': ('ande',),
'andet': ('ande',),
'anda': ('ande',),
'andet': ('ande',),
'and': ('ande',),
'andra': ('andra',),
'andrar': ('andra',),
'andras': ('andra',),
'androg': ('andra',),
'andro': ('andra',),
'andradd': ('andra',),
'andratt': ('andra',),
'andradd': ('andra',),
'andratt': ('andra',),
'andra': ('andra',),
'anduve': ('anduve',),
'anduver': ('anduve',),
'anduves': ('anduve',),
'anduva': ('anduve',),
'anduvet': ('anduve',),
'anduva': ('anduve',),
'anduvet': ('anduve',),
'anduv': ('anduve',),
'andøve': ('andøve',),
'andøver': ('andøve',),
'andøves': ('andøve',),
'andøvet': ('andøve',),
'andøvde': ('andøve',),
'andøvet': ('andøve',),
'andøvd': ('andøve',),
'andøv': ('andøve',),
'ane': ('ane',),
'aner': ('ane',),
'anes': ('ane',),
'ante': ('ane',),
'ant': ('ane',),
'an': ('ane',),
'anerkjenne': ('anerkjenne',),
'anerkjenner': ('anerkjenne',),
'anerkjennes': ('anerkjenne',),
'anerkjente': ('anerkjenne',),
'anerkjent': ('anerkjenne',),
'anerkjenn': ('anerkjenne',),
'anestesere': ('anestesere',),
'anesteserer': ('anestesere',),
'anesteseres': ('anestesere',),
'anesteserte': ('anestesere',),
'anestesert': ('anestesere',),
'anesteser': ('anestesere',),
'anfalle': ('anfalle',),
'anfaller': ('anfalle',),
'anfalles': ('anfalle',),
'anfalt': ('anfalle',),
'anfall': ('anfalle',),
'anfekte': ('anfekte',),
'anfekter': ('anfekte',),
'anfektes': ('anfekte',),
'anfekta': ('anfekte',),
'anfektet': ('anfekte',),
'anfekta': ('anfekte',),
'anfektet': ('anfekte',),
'anfekt': ('anfekte',),
'anføre': ('anføre',),
'anfører': ('anføre',),
'anføres': ('anføre',),
'anførte': ('anføre',),
'anført': ('anføre',),
'anfør': ('anføre',),
'ange': ('ange',),
'anger': ('ange',),
'anges': ('ange',),
'anga': ('ange',),
'anget': ('ange',),
'anga': ('ange',),
'anget': ('ange',),
'ang': ('ange',),
'angi': ('angi',),
'angir': ('angi',),
'angis': ('angi',),
'angav': ('angi',),
'anga': ('angi',),
'angitt': ('angi',),
'angi': ('angi',),
'angle': ('angle',),
'angler': ('angle',),
'angles': ('angle',),
'angla': ('angle',),
'anglet': ('angle',),
'angla': ('angle',),
'anglet': ('angle',),
'angl': ('angle',),
'angle': ('angle',),
'angl': ('angle',),
'angle': ('angle',),
'anglifisere': ('anglifisere',),
'anglifiserer': ('anglifisere',),
'anglifiseres': ('anglifisere',),
'anglifiserte': ('anglifisere',),
'anglifisert': ('anglifisere',),
'anglifiser': ('anglifisere',),
'anglisere': ('anglisere',),
'angliserer': ('anglisere',),
'angliseres': ('anglisere',),
'angliserte': ('anglisere',),
'anglisert': ('anglisere',),
'angliser': ('anglisere',),
'angre': ('angre',),
'angrer': ('angre',),
'angres': ('angre',),
'angra': ('angre',),
'angret': ('angre',),
'angra': ('angre',),
'angret': ('angre',),
'angr': ('angre',),
'angre': ('angre',),
'angr': ('angre',),
'angre': ('angre',),
'angripe': ('angripe',),
'angriper': ('angripe',),
'angripes': ('angripe',),
'angrep': ('angripe',),
'angreip': ('angripe',),
'angrep': ('angripe',),
'angreip': ('angripe',),
'angrepet': ('angripe',),
'angrip': ('angripe',),
'angå': ('angå',),
'angår': ('angå',),
'angås': ('angå',),
'angikk': ('angå',),
'angått': ('angå',),
'angå': ('angå',),
'anholde': ('anholde',),
'anholder': ('anholde',),
'anholdes': ('anholde',),
'anholdt': ('anholde',),
'anhold': ('anholde',),
'animalisere': ('animalisere',),
'animaliserer': ('animalisere',),
'animaliseres': ('animalisere',),
'animaliserte': ('animalisere',),
'animalisert': ('animalisere',),
'animaliser': ('animalisere',),
'animere': ('animere',),
'animerer': ('animere',),
'animeres': ('animere',),
'animerte': ('animere',),
'animert': ('animere',),
'animer': ('animere',),
'anke': ('anke',),
'anker': ('anke',),
'ankes': ('anke',),
'anka': ('anke',),
'anket': ('anke',),
'anka': ('anke',),
'anket': ('anke',),
'ank': ('anke',),
'anklage': ('anklage',),
'anklager': ('anklage',),
'anklages': ('anklage',),
'anklaga': ('anklage',),
'anklaget': ('anklage',),
'anklagde': ('anklage',),
'anklaga': ('anklage',),
'anklaget': ('anklage',),
'anklagd': ('anklage',),
'anklag': ('anklage',),
'ankomme': ('ankomme',),
'ankommer': ('ankomme',),
'ankommes': ('ankomme',),
'ankom': ('ankomme',),
'ankommet': ('ankomme',),
'ankom': ('ankomme',),
'ankre': ('ankre',),
'ankrer': ('ankre',),
'ankres': ('ankre',),
'ankra': ('ankre',),
'ankret': ('ankre',),
'ankra': ('ankre',),
'ankret': ('ankre',),
'ankr': ('ankre',),
'ankre': ('ankre',),
'ankr': ('ankre',),
'ankre': ('ankre',),
'anlegge': ('anlegge',),
'anlegger': ('anlegge',),
'anlegges': ('anlegge',),
'anla': ('anlegge',),
'anlagt': ('anlegge',),
'anlegg': ('anlegge',),
'anløpe': ('anløpe',),
'anløper': ('anløpe',),
'anløpes': ('anløpe',),
'anløp': ('anløpe',),
'anløpt': ('anløpe',),
'anløpet': ('anløpe',),
'anløp': ('anløpe',),
'anmasse': ('anmasse',),
'anmasser': ('anmasse',),
'anmasses': ('anmasse',),
'anmassa': ('anmasse',),
'anmasset': ('anmasse',),
'anmassa': ('anmasse',),
'anmasset': ('anmasse',),
'anmass': ('anmasse',),
'anmelde': ('anmelde',),
'anmelder': ('anmelde',),
'anmeldes': ('anmelde',),
'anmeldte': ('anmelde',),
'anmeldt': ('anmelde',),
'anmeld': ('anmelde',),
'anmerke': ('anmerke',),
'anmerker': ('anmerke',),
'anmerkes': ('anmerke',),
'anmerka': ('anmerke',),
'anmerket': ('anmerke',),
'anmerka': ('anmerke',),
'anmerket': ('anmerke',),
'anmerk': ('anmerke',),
'anmode': ('anmode',),
'anmoder': ('anmode',),
'anmodes': ('anmode',),
'anmoda': ('anmode',),
'anmodet': ('anmode',),
'anmoda': ('anmode',),
'anmodet': ('anmode',),
'anmod': ('anmode',),
'annamme': ('annamme',),
'annammer': ('annamme',),
'annammes': ('annamme',),
'annamma': ('annamme',),
'annammet': ('annamme',),
'annamma': ('annamme',),
'annammet': ('annamme',),
'annam': ('annamme',),
'annektere': ('annektere',),
'annekterer': ('annektere',),
'annekteres': ('annektere',),
'annekterte': ('annektere',),
'annektert': ('annektere',),
'annekter': ('annektere',),
'annonsere': ('annonsere',),
'annonserer': ('annonsere',),
'annonseres': ('annonsere',),
'annonserte': ('annonsere',),
'annonsert': ('annonsere',),
'annonser': ('annonsere',),
'annullere': ('annullere',),
'annullerer': ('annullere',),
'annulleres': ('annullere',),
'annullerte': ('annullere',),
'annullert': ('annullere',),
'annuller': ('annullere',),
'anodisere': ('anodisere',),
'anodiserer': ('anodisere',),
'anodiseres': ('anodisere',),
'anodiserte': ('anodisere',),
'anodisert': ('anodisere',),
'anodiser': ('anodisere',),
'anordne': ('anordne',),
'anordner': ('anordne',),
'anordnes': ('anordne',),
'anordna': ('anordne',),
'anordnet': ('anordne',),
'anordna': ('anordne',),
'anordnet': ('anordne',),
'anordn': ('anordne',),
'anordne': ('anordne',),
'anordn': ('anordne',),
'anordne': ('anordne',),
'anrette': ('anrette',),
'anretter': ('anrette',),
'anrettes': ('anrette',),
'anretta': ('anrette',),
'anrettet': ('anrette',),
'anretta': ('anrette',),
'anrettet': ('anrette',),
'anrett': ('anrette',),
'anrike': ('anrike',),
'anriker': ('anrike',),
'anrikes': ('anrike',),
'anrika': ('anrike',),
'anriket': ('anrike',),
'anrika': ('anrike',),
'anriket': ('anrike',),
'anrik': ('anrike',),
'anrope': ('anrope',),
'anroper': ('anrope',),
'anropes': ('anrope',),
'anropte': ('anrope',),
'anropt': ('anrope',),
'anrop': ('anrope',),
'anse': ('anse',),
'anser': ('anse',),
'anses': ('anse',),
'ansa': ('anse',),
'anset': ('anse',),
'anste': ('anse',),
'ansa': ('anse',),
'anset': ('anse',),
'anst': ('anse',),
'ans': ('anse',),
'anse': ('anse',),
'anser': ('anse',),
'anses': ('anse',),
'ansees': ('anse',),
'anså': ('anse',),
'ansett': ('anse',),
'anse': ('anse',),
'ansette': ('ansette',),
'ansetter': ('ansette',),
'ansettes': ('ansette',),
'ansatte': ('ansette',),
'ansatt': ('ansette',),
'ansett': ('ansette',),
'anskaffe': ('anskaffe',),
'anskaffer': ('anskaffe',),
'anskaffes': ('anskaffe',),
'anskaffa': ('anskaffe',),
'anskaffet': ('anskaffe',),
'anskaffa': ('anskaffe',),
'anskaffet': ('anskaffe',),
'anskaff': ('anskaffe',),
'anskue': ('anskue',),
'anskuer': ('anskue',),
'anskues': ('anskue',),
'anskua': ('anskue',),
'anskuet': ('anskue',),
'anskua': ('anskue',),
'anskuet': ('anskue',),
'ansku': ('anskue',),
'anskueliggjøre': ('anskueliggjøre',),
'anskueliggjør': ('anskueliggjøre',),
'anskueliggjøres': ('anskueliggjøre',),
'anskueliggjorde': ('anskueliggjøre',),
'anskueliggjort': ('anskueliggjøre',),
'anskueliggjør': ('anskueliggjøre',),
'anslå': ('anslå',),
'anslår': ('anslå',),
'anslås': ('anslå',),
'anslåes': ('anslå',),
'anslo': ('anslå',),
'anslått': ('anslå',),
'anslå': ('anslå',),
'anspenne': ('anspenne',),
'anspenner': ('anspenne',),
'anspennes': ('anspenne',),
'anspente': ('anspenne',),
'anspent': ('anspenne',),
'anspenn': ('anspenne',),
'anspore': ('anspore',),
'ansporer': ('anspore',),
'anspores': ('anspore',),
'anspora': ('anspore',),
'ansporet': ('anspore',),
'ansporte': ('anspore',),
'anspora': ('anspore',),
'ansporet': ('anspore',),
'ansport': ('anspore',),
'anspor': ('anspore',),
'anstifte': ('anstifte',),
'anstifter': ('anstifte',),
'anstiftes': ('anstifte',),
'anstifta': ('anstifte',),
'anstiftet': ('anstifte',),
'anstifta': ('anstifte',),
'anstiftet': ('anstifte',),
'anstift': ('anstifte',),
'anstille': ('anstille',),
'anstiller': ('anstille',),
'anstilles': ('anstille',),
'anstilte': ('anstille',),
'anstilt': ('anstille',),
'anstill': ('anstille',),
'anstrenge': ('anstrenge',),
'anstrenger': ('anstrenge',),
'anstrenges': ('anstrenge',),
'anstrengte': ('anstrenge',),
'anstrengt': ('anstrenge',),
'anstreng': ('anstrenge',),
'anstå': ('anstå',),
'anstår': ('anstå',),
'anstås': ('anstå',),
'ansto': ('anstå',),
'anstod': ('anstå',),
'anstått': ('anstå',),
'anstå': ('anstå',),
'ansøke': ('ansøke',),
'ansøker': ('ansøke',),
'ansøkes': ('ansøke',),
'ansøkte': ('ansøke',),
'ansøkt': ('ansøke',),
'ansøk': ('ansøke',),
'anta': ('anta',),
'antar': ('anta',),
'antas': ('anta',),
'antok': ('anta',),
'antatt': ('anta',),
'anta': ('anta',),
'antaste': ('antaste',),
'antaster': ('antaste',),
'antastes': ('antaste',),
'antasta': ('antaste',),
'antastet': ('antaste',),
'antasta': ('antaste',),
'antastet': ('antaste',),
'antast': ('antaste',),
'antedatere': ('antedatere',),
'antedaterer': ('antedatere',),
'antedateres': ('antedatere',),
'antedaterte': ('antedatere',),
'antedatert': ('antedatere',),
'antedater': ('antedatere',),
'antegne': ('antegne',),
'antegner': ('antegne',),
'antegnes': ('antegne',),
'antegna': ('antegne',),
'antegnet': ('antegne',),
'antegna': ('antegne',),
'antegnet': ('antegne',),
'antegn': ('antegne',),
'antenne': ('antenne',),
'antenner': ('antenne',),
'antennes': ('antenne',),
'antente': ('antenne',),
'antent': ('antenne',),
'antenn': ('antenne',),
'antesipere': ('antesipere',),
'antesiperer': ('antesipere',),
'antesiperes': ('antesipere',),
'antesiperte': ('antesipere',),
'antesipert': ('antesipere',),
'antesiper': ('antesipere',),
'antikisere': ('antikisere',),
'antikiserer': ('antikisere',),
'antikiseres': ('antikisere',),
'antikiserte': ('antikisere',),
'antikisert': ('antikisere',),
'antikiser': ('antikisere',),
'antikrympbehandle': ('antikrympbehandle',),
'antikrympbehandler': ('antikrympbehandle',),
'antikrympbehandles': ('antikrympbehandle',),
'antikrympbehandla': ('antikrympbehandle',),
'antikrympbehandlet': ('antikrympbehandle',),
'antikrympbehandla': ('antikrympbehandle',),
'antikrympbehandlet': ('antikrympbehandle',),
'antikrympbehandl': ('antikrympbehandle',),
'antikrympbehandle': ('antikrympbehandle',),
'antikrympbehandl': ('antikrympbehandle',),
'antikrympbehandle': ('antikrympbehandle',),
'antikrøllbehandle': ('antikrøllbehandle',),
'antikrøllbehandler': ('antikrøllbehandle',),
'antikrøllbehandles': ('antikrøllbehandle',),
'antikrøllbehandla': ('antikrøllbehandle',),
'antikrøllbehandlet': ('antikrøllbehandle',),
'antikrøllbehandla': ('antikrøllbehandle',),
'antikrøllbehandlet': ('antikrøllbehandle',),
'antikrøllbehandl': ('antikrøllbehandle',),
'antikrøllbehandle': ('antikrøllbehandle',),
'antikrøllbehandl': ('antikrøllbehandle',),
'antikrøllbehandle': ('antikrøllbehandle',),
'antirefleksbehandle': ('antirefleksbehandle',),
'antirefleksbehandler': ('antirefleksbehandle',),
'antirefleksbehandles': ('antirefleksbehandle',),
'antirefleksbehandla': ('antirefleksbehandle',),
'antirefleksbehandlet': ('antirefleksbehandle',),
'antirefleksbehandla': ('antirefleksbehandle',),
'antirefleksbehandlet': ('antirefleksbehandle',),
'antirefleksbehandl': ('antirefleksbehandle',),
'antirefleksbehandle': ('antirefleksbehandle',),
'antirefleksbehandl': ('antirefleksbehandle',),
'antirefleksbehandle': ('antirefleksbehandle',),
'antirustbehandle': ('antirustbehandle',),
'antirustbehandler': ('antirustbehandle',),
'antirustbehandles': ('antirustbehandle',),
'antirustbehandla': ('antirustbehandle',),
'antirustbehandlet': ('antirustbehandle',),
'antirustbehandla': ('antirustbehandle',),
'antirustbehandlet': ('antirustbehandle',),
'antirustbehandl': ('antirustbehandle',),
'antirustbehandle': ('antirustbehandle',),
'antirustbehandl': ('antirustbehandle',),
'antirustbehandle': ('antirustbehandle',),
'antistatbehandle': ('antistatbehandle',),
'antistatbehandler': ('antistatbehandle',),
'antistatbehandles': ('antistatbehandle',),
'antistatbehandla': ('antistatbehandle',),
'antistatbehandlet': ('antistatbehandle',),
'antistatbehandla': ('antistatbehandle',),
'antistatbehandlet': ('antistatbehandle',),
'antistatbehandl': ('antistatbehandle',),
'antistatbehandle': ('antistatbehandle',),
'antistatbehandl': ('antistatbehandle',),
'antistatbehandle': ('antistatbehandle',),
'antyde': ('antyde',),
'antyder': ('antyde',),
'antydes': ('antyde',),
'antyda': ('antyde',),
'antydet': ('antyde',),
'antyda': ('antyde',),
'antydet': ('antyde',),
'antyd': ('antyde',),
'anvende': ('anvende',),
'anvender': ('anvende',),
'anvendes': ('anvende',),
'anvendte': ('anvende',),
'anvendt': ('anvende',),
'anvend': ('anvende',),
'anvise': ('anvise',),
'anviser': ('anvise',),
'anvises': ('anvise',),
'anviste': ('anvise',),
'anvist': ('anvise',),
'anvis': ('anvise',),
'ape': ('ape',),
'aper': ('ape',),
'apes': ('ape',),
'apa': ('ape',),
'apet': ('ape',),
'apte': ('ape',),
'apa': ('ape',),
'apet': ('ape',),
'apt': ('ape',),
'ap': ('ape',),
'apokopere': ('apokopere',),
'apokoperer': ('apokopere',),
'apokoperes': ('apokopere',),
'apokoperte': ('apokopere',),
'apokopert': ('apokopere',),
'apokoper': ('apokopere',),
'apostrofere': ('apostrofere',),
'apostroferer': ('apostrofere',),
'apostroferes': ('apostrofere',),
'apostroferte': ('apostrofere',),
'apostrofert': ('apostrofere',),
'apostrofer': ('apostrofere',),
'appellere': ('appellere',),
'appellerer': ('appellere',),
'appelleres': ('appellere',),
'appellerte': ('appellere',),
'appellert': ('appellere',),
'appeller': ('appellere',),
'applaudere': ('applaudere',),
'applauderer': ('applaudere',),
'applauderes': ('applaudere',),
'applauderte': ('applaudere',),
'applaudert': ('applaudere',),
'applauder': ('applaudere',),
'applikere': ('applikere',),
'applikerer': ('applikere',),
'applikeres': ('applikere',),
'applikerte': ('applikere',),
'applikert': ('applikere',),
'appliker': ('applikere',),
'applisere': ('applisere',),
'appliserer': ('applisere',),
'appliseres': ('applisere',),
'appliserte': ('applisere',),
'applisert': ('applisere',),
'appliser': ('applisere',),
'apportere': ('apportere',),
'apporterer': ('apportere',),
'apporteres': ('apportere',),
'apporterte': ('apportere',),
'apportert': ('apportere',),
'apporter': ('apportere',),
'appretere': ('appretere',),
'appreterer': ('appretere',),
'appreteres': ('appretere',),
'appreterte': ('appretere',),
'appretert': ('appretere',),
'appreter': ('appretere',),
'approbere': ('approbere',),
'approberer': ('approbere',),
'approberes': ('approbere',),
'approberte': ('approbere',),
'approbert': ('approbere',),
'approber': ('approbere',),
'appropriere': ('appropriere',),
'approprierer': ('appropriere',),
'approprieres': ('appropriere',),
'approprierte': ('appropriere',),
'appropriert': ('appropriere',),
'approprier': ('appropriere',),
'aptere': ('aptere',),
'apterer': ('aptere',),
'apteres': ('aptere',),
'apterte': ('aptere',),
'aptert': ('aptere',),
'apter': ('aptere',),
'arbeide': ('arbeide',),
'arbeider': ('arbeide',),
'arbeides': ('arbeide',),
'arbeida': ('arbeide',),
'arbeidet': ('arbeide',),
'arbeidde': ('arbeide',),
'arbeida': ('arbeide',),
'arbeidet': ('arbeide',),
'arbeidd': ('arbeide',),
'arbeid': ('arbeide',),
'arde': ('arde',),
'arder': ('arde',),
'ardes': ('arde',),
'arda': ('arde',),
'ardet': ('arde',),
'arda': ('arde',),
'ardet': ('arde',),
'ard': ('arde',),
'arge': ('arge',),
'arger': ('arge',),
'arges': ('arge',),
'arga': ('arge',),
'arget': ('arge',),
'arga': ('arge',),
'arget': ('arge',),
'arg': ('arge',),
'argumentere': ('argumentere',),
'argumenterer': ('argumentere',),
'argumenteres': ('argumentere',),
'argumenterte': ('argumentere',),
'argumentert': ('argumentere',),
'argumenter': ('argumentere',),
'arkaisere': ('arkaisere',),
'arkaiserer': ('arkaisere',),
'arkaiseres': ('arkaisere',),
'arkaiserte': ('arkaisere',),
'arkaisert': ('arkaisere',),
'arkaiser': ('arkaisere',),
'arkebusere': ('arkebusere',),
'arkebuserer': ('arkebusere',),
'arkebuseres': ('arkebusere',),
'arkebuserte': ('arkebusere',),
'arkebusert': ('arkebusere',),
'arkebuser': ('arkebusere',),
'arkivere': ('arkivere',),
'arkiverer': ('arkivere',),
'arkiveres': ('arkivere',),
'arkiverte': ('arkivere',),
'arkivert': ('arkivere',),
'arkiver': ('arkivere',),
'arme': ('arme',),
'armer': ('arme',),
'armes': ('arme',),
'arma': ('arme',),
'armet': ('arme',),
'arma': ('arme',),
'armet': ('arme',),
'arm': ('arme',),
'armere': ('armere',),
'armerer': ('armere',),
'armeres': ('armere',),
'armerte': ('armere',),
'armert': ('armere',),
'armer': ('armere',),
'aromatisere': ('aromatisere',),
'aromatiserer': ('aromatisere',),
'aromatiseres': ('aromatisere',),
'aromatiserte': ('aromatisere',),
'aromatisert': ('aromatisere',),
'aromatiser': ('aromatisere',),
'arrangere': ('arrangere',),
'arrangerer': ('arrangere',),
'arrangeres': ('arrangere',),
'arrangerte': ('arrangere',),
'arrangert': ('arrangere',),
'arranger': ('arrangere',),
'arrestere': ('arrestere',),
'arresterer': ('arrestere',),
'arresteres': ('arrestere',),
'arresterte': ('arrestere',),
'arrestert': ('arrestere',),
'arrester': ('arrestere',),
'arretere': ('arretere',),
'arreterer': ('arretere',),
'arreteres': ('arretere',),
'arreterte': ('arretere',),
'arretert': ('arretere',),
'arreter': ('arretere',),
'arrivere': ('arrivere',),
'arriverer': ('arrivere',),
'arriveres': ('arrivere',),
'arriverte': ('arrivere',),
'arrivert': ('arrivere',),
'arriver': ('arrivere',),
'arrondere': ('arrondere',),
'arronderer': ('arrondere',),
'arronderes': ('arrondere',),
'arronderte': ('arrondere',),
'arrondert': ('arrondere',),
'arronder': ('arrondere',),
'arte': ('arte',),
'arter': ('arte',),
'artes': ('arte',),
'arta': ('arte',),
'artet': ('arte',),
'arta': ('arte',),
'artet': ('arte',),
'art': ('arte',),
'artikulere': ('artikulere',),
'artikulerer': ('artikulere',),
'artikuleres': ('artikulere',),
'artikulerte': ('artikulere',),
'artikulert': ('artikulere',),
'artikuler': ('artikulere',),
'artsbestemme': ('artsbestemme',),
'artsbestemmer': ('artsbestemme',),
'artsbestemmes': ('artsbestemme',),
'artsbestemte': ('artsbestemme',),
'artsbestemt': ('artsbestemme',),
'artsbestem': ('artsbestemme',),
'arve': ('arve',),
'arver': ('arve',),
'arves': ('arve',),
'arva': ('arve',),
'arvet': ('arve',),
'arva': ('arve',),
'arvet': ('arve',),
'arv': ('arve',),
'ase': ('ase',),
'aser': ('ase',),
'ases': ('ase',),
'aste': ('ase',),
'ast': ('ase',),
'as': ('ase',),
'asfaltere': ('asfaltere',),
'asfalterer': ('asfaltere',),
'asfalteres': ('asfaltere',),
'asfalterte': ('asfaltere',),
'asfaltert': ('asfaltere',),
'asfalter': ('asfaltere',),
'aspirere': ('aspirere',),
'aspirerer': ('aspirere',),
'aspireres': ('aspirere',),
'aspirerte': ('aspirere',),
'aspirert': ('aspirere',),
'aspirer': ('aspirere',),
'assimilere': ('assimilere',),
'assimilerer': ('assimilere',),
'assimileres': ('assimilere',),
'assimilerte': ('assimilere',),
'assimilert': ('assimilere',),
'assimiler': ('assimilere',),
'assistere': ('assistere',),
'assisterer': ('assistere',),
'assisteres': ('assistere',),
'assisterte': ('assistere',),
'assistert': ('assistere',),
'assister': ('assistere',),
'assortere': ('assortere',),
'assorterer': ('assortere',),
'assorteres': ('assortere',),
'assorterte': ('assortere',),
'assortert': ('assortere',),
'assorter': ('assortere',),
'assosiere': ('assosiere',),
'assosierer': ('assosiere',),
'assosieres': ('assosiere',),
'assosierte': ('assosiere',),
'assosiert': ('assosiere',),
'assosier': ('assosiere',),
'assurere': ('assurere',),
'assurerer': ('assurere',),
'assureres': ('assurere',),
'assurerte': ('assurere',),
'assurert': ('assurere',),
'assurer': ('assurere',),
'astringere': ('astringere',),
'astringerer': ('astringere',),
'astringeres': ('astringere',),
'astringerte': ('astringere',),
'astringert': ('astringere',),
'astringer': ('astringere',),
'atomisere': ('atomisere',),
'atomiserer': ('atomisere',),
'atomiseres': ('atomisere',),
'atomiserte': ('atomisere',),
'atomisert': ('atomisere',),
'atomiser': ('atomisere',),
'atrofiere': ('atrofiere',),
'atrofierer': ('atrofiere',),
'atrofieres': ('atrofiere',),
'atrofierte': ('atrofiere',),
'atrofiert': ('atrofiere',),
'atrofier': ('atrofiere',),
'atskille': ('atskille',),
'atskiller': ('atskille',),
'atskilles': ('atskille',),
'atskilte': ('atskille',),
'atskilt': ('atskille',),
'atskill': ('atskille',),
'atspre': ('atspre',),
'atsprer': ('atspre',),
'atspres': ('atspre',),
'atspredde': ('atspre',),
'atspredte': ('atspre',),
'atspredd': ('atspre',),
'atspredt': ('atspre',),
'atspre': ('atspre',),
'atsprede': ('atsprede',),
'atspreder': ('atsprede',),
'atspredes': ('atsprede',),
'atspredte': ('atsprede',),
'atspredde': ('atsprede',),
'atspredt': ('atsprede',),
'atspredd': ('atsprede',),
'atspred': ('atsprede',),
'attachere': ('attachere',),
'attacherer': ('attachere',),
'attacheres': ('attachere',),
'attacherte': ('attachere',),
'attachert': ('attachere',),
'attacher': ('attachere',),
'attakkere': ('attakkere',),
'attakkerer': ('attakkere',),
'attakkeres': ('attakkere',),
'attakkerte': ('attakkere',),
'attakkert': ('attakkere',),
'attakker': ('attakkere',),
'attestere': ('attestere',),
'attesterer': ('attestere',),
'attesteres': ('attestere',),
'attesterte': ('attestere',),
'attestert': ('attestere',),
'attester': ('attestere',),
'attrahere': ('attrahere',),
'attraherer': ('attrahere',),
'attraheres': ('attrahere',),
'attraherte': ('attrahere',),
'attrahert': ('attrahere',),
'attraher': ('attrahere',),
'attrå': ('attrå',),
'attrår': ('attrå',),
'attrås': ('attrå',),
'attrådde': ('attrå',),
'attrådd': ('attrå',),
'attrå': ('attrå',),
'auke': ('auke',),
'auker': ('auke',),
'aukes': ('auke',),
'auka': ('auke',),
'auket': ('auke',),
'aukte': ('auke',),
'auka': ('auke',),
'auket': ('auke',),
'aukt': ('auke',),
'auk': ('auke',),
'auksjonere': ('auksjonere',),
'auksjonerer': ('auksjonere',),
'auksjoneres': ('auksjonere',),
'auksjonerte': ('auksjonere',),
'auksjonert': ('auksjonere',),
'auksjoner': ('auksjonere',),
'aure': ('aure',),
'aurer': ('aure',),
'aures': ('aure',),
'aura': ('aure',),
'auret': ('aure',),
'aura': ('aure',),
'auret': ('aure',),
'aur': ('aure',),
'ause': ('ause',),
'auser': ('ause',),
'auses': ('ause',),
'auste': ('ause',),
'aust': ('ause',),
'aus': ('ause',),
'autoklavere': ('autoklavere',),
'autoklaverer': ('autoklavere',),
'autoklaveres': ('autoklavere',),
'autoklaverte': ('autoklavere',),
'autoklavert': ('autoklavere',),
'autoklaver': ('autoklavere',),
'automatisere': ('automatisere',),
'automatiserer': ('automatisere',),
'automatiseres': ('automatisere',),
'automatiserte': ('automatisere',),
'automatisert': ('automatisere',),
'automatiser': ('automatisere',),
'autorisere': ('autorisere',),
'autoriserer': ('autorisere',),
'autoriseres': ('autorisere',),
'autoriserte': ('autorisere',),
'autorisert': ('autorisere',),
'autoriser': ('autorisere',),
'avalere': ('avalere',),
'avalerer': ('avalere',),
'avaleres': ('avalere',),
'avalerte': ('avalere',),
'avalert': ('avalere',),
'avaler': ('avalere',),
'avansere': ('avansere',),
'avanserer': ('avansere',),
'avanseres': ('avansere',),
'avanserte': ('avansere',),
'avansert': ('avansere',),
'avanser': ('avansere',),
'avbalansere': ('avbalansere',),
'avbalanserer': ('avbalansere',),
'avbalanseres': ('avbalansere',),
'avbalanserte': ('avbalansere',),
'avbalansert': ('avbalansere',),
'avbalanser': ('avbalansere',),
'avbestille': ('avbestille',),
'avbestiller': ('avbestille',),
'avbestilles': ('avbestille',),
'avbestilte': ('avbestille',),
'avbestilt': ('avbestille',),
'avbestill': ('avbestille',),
'avbetale': ('avbetale',),
'avbetaler': ('avbetale',),
'avbetales': ('avbetale',),
'avbetalte': ('avbetale',),
'avbetalt': ('avbetale',),
'avbetal': ('avbetale',),
'avbilde': ('avbilde',),
'avbilder': ('avbilde',),
'avbildes': ('avbilde',),
'avbilda': ('avbilde',),
'avbildet': ('avbilde',),
'avbilda': ('avbilde',),
'avbildet': ('avbilde',),
'avbild': ('avbilde',),
'avbinde': ('avbinde',),
'avbinder': ('avbinde',),
'avbindes': ('avbinde',),
'avbandt': ('avbinde',),
'avbundet': ('avbinde',),
'avbind': ('avbinde',),
'avblåse': ('avblåse',),
'avblåser': ('avblåse',),
'avblåses': ('avblåse',),
'avblåste': ('avblåse',),
'avblåst': ('avblåse',),
'avblås': ('avblåse',),
'avbryte': ('avbryte',),
'avbryter': ('avbryte',),
'avbrytes': ('avbryte',),
'avbrøt': ('avbryte',),
'avbrøyt': ('avbryte',),
'avbrutt': ('avbryte',),
'avbryt': ('avbryte',),
'avbøte': ('avbøte',),
'avbøter': ('avbøte',),
'avbøtes': ('avbøte',),
'avbøtte': ('avbøte',),
'avbøtt': ('avbøte',),
'avbøt': ('avbøte',),
'avbøye': ('avbøye',),
'avbøyer': ('avbøye',),
'avbøyes': ('avbøye',),
'avbøyet': ('avbøye',),
'avbøyde': ('avbøye',),
'avbøyet': ('avbøye',),
'avbøyd': ('avbøye',),
'avbøy': ('avbøye',),
'avdampe': ('avdampe',),
'avdamper': ('avdampe',),
'avdampes': ('avdampe',),
'avdampa': ('avdampe',),
'avdampet': ('avdampe',),
'avdampa': ('avdampe',),
'avdampet': ('avdampe',),
'avdamp': ('avdampe',),
'avdekke': ('avdekke',),
'avdekker': ('avdekke',),
'avdekkes': ('avdekke',),
'avdekka': ('avdekke',),
'avdekket': ('avdekke',),
'avdekte': ('avdekke',),
'avdekka': ('avdekke',),
'avdekket': ('avdekke',),
'avdekt': ('avdekke',),
'avdekk': ('avdekke',),
'avdele': ('avdele',),
'avdeler': ('avdele',),
'avdeles': ('avdele',),
'avdelte': ('avdele',),
'avdelt': ('avdele',),
'avdel': ('avdele',),
'avdempe': ('avdempe',),
'avdemper': ('avdempe',),
'avdempes': ('avdempe',),
'avdempa': ('avdempe',),
'avdempet': ('avdempe',),
'avdempa': ('avdempe',),
'avdempet': ('avdempe',),
'avdemp': ('avdempe',),
'avdra': ('avdra',),
'avdrar': ('avdra',),
'avdras': ('avdra',),
'avdrog': ('avdra',),
'avdro': ('avdra',),
'avdradd': ('avdra',),
'avdratt': ('avdra',),
'avdradd': ('avdra',),
'avdratt': ('avdra',),
'avdra': ('avdra',),
'avdramatisere': ('avdramatisere',),
'avdramatiserer': ('avdramatisere',),
'avdramatiseres': ('avdramatisere',),
'avdramatiserte': ('avdramatisere',),
'avdramatisert': ('avdramatisere',),
'avdramatiser': ('avdramatisere',),
'avduke': ('avduke',),
'avduker': ('avduke',),
'avdukes': ('avduke',),
'avduka': ('avduke',),
'avduket': ('avduke',),
'avduka': ('avduke',),
'avduket': ('avduke',),
'avduk': ('avduke',),
'avertere': ('avertere',),
'averterer': ('avertere',),
'averteres': ('avertere',),
'averterte': ('avertere',),
'avertert': ('avertere',),
'averter': ('avertere',),
'avfase': ('avfase',),
'avfaser': ('avfase',),
'avfases': ('avfase',),
'avfasa': ('avfase',),
'avfaset': ('avfase',),
'avfasa': ('avfase',),
'avfaset': ('avfase',),
'avfas': ('avfase',),
'avfatte': ('avfatte',),
'avfatter': ('avfatte',),
'avfattes': ('avfatte',),
'avfatta': ('avfatte',),
'avfattet': ('avfatte',),
'avfatta': ('avfatte',),
'avfattet': ('avfatte',),
'avfatt': ('avfatte',),
'avfeie': ('avfeie',),
'avfeier': ('avfeie',),
'avfeies': ('avfeie',),
'avfeiet': ('avfeie',),
'avfeide': ('avfeie',),
'avfeiet': ('avfeie',),
'avfeid': ('avfeie',),
'avfei': ('avfeie',),
'avferdige': ('avferdige',),
'avferdiger': ('avferdige',),
'avferdiges': ('avferdige',),
'avferdiga': ('avferdige',),
'avferdiget': ('avferdige',),
'avferdiga': ('avferdige',),
'avferdiget': ('avferdige',),
'avferdig': ('avferdige',),
'avfette': ('avfette',),
'avfetter': ('avfette',),
'avfettes': ('avfette',),
'avfetta': ('avfette',),
'avfettet': ('avfette',),
'avfetta': ('avfette',),
'avfettet': ('avfette',),
'avfett': ('avfette',),
'avfinne': ('avfinne',),
'avfinner': ('avfinne',),
'avfinnes': ('avfinne',),
'avfant': ('avfinne',),
'avfunnet': ('avfinne',),
'avfinn': ('avfinne',),
'avfolke': ('avfolke',),
'avfolker': ('avfolke',),
'avfolkes': ('avfolke',),
'avfolka': ('avfolke',),
'avfolket': ('avfolke',),
'avfolka': ('avfolke',),
'avfolket': ('avfolke',),
'avfolk': ('avfolke',),
'avfyre': ('avfyre',),
'avfyrer': ('avfyre',),
'avfyres': ('avfyre',),
'avfyrte': ('avfyre',),
'avfyrt': ('avfyre',),
'avfyr': ('avfyre',),
'avføde': ('avføde',),
'avføder': ('avføde',),
'avfødes': ('avføde',),
'avfødte': ('avføde',),
'avfødt': ('avføde',),
'avfød': ('avføde',),
'avføre': ('avføre',),
'avfører': ('avføre',),
'avføres': ('avføre',),
'avførte': ('avføre',),
'avført': ('avføre',),
'avfør': ('avføre',),
'avgi': ('avgi',),
'avgir': ('avgi',),
'avgis': ('avgi',),
'avgav': ('avgi',),
'avga': ('avgi',),
'avgitt': ('avgi',),
'avgi': ('avgi',),
'avgjøre': ('avgjøre',),
'avgjør': ('avgjøre',),
'avgjøres': ('avgjøre',),
'avgjorde': ('avgjøre',),
'avgjort': ('avgjøre',),
'avgjør': ('avgjøre',),
'avgrense': ('avgrense',),
'avgrenser': ('avgrense',),
'avgrenses': ('avgrense',),
'avgrensa': ('avgrense',),
'avgrenset': ('avgrense',),
'avgrensa': ('avgrense',),
'avgrenset': ('avgrense',),
'avgrens': ('avgrense',),
'avgå': ('avgå',),
'avgår': ('avgå',),
'avgås': ('avgå',),
'avgikk': ('avgå',),
'avgått': ('avgå',),
'avgå': ('avgå',),
'avheimle': ('avheimle',),
'avheimler': ('avheimle',),
'avheimles': ('avheimle',),
'avheimla': ('avheimle',),
'avheimlet': ('avheimle',),
'avheimla': ('avheimle',),
'avheimlet': ('avheimle',),
'avheiml': ('avheimle',),
'avheimle': ('avheimle',),
'avheiml': ('avheimle',),
'avheimle': ('avheimle',),
'avhende': ('avhende',),
'avhender': ('avhende',),
'avhendes': ('avhende',),
'avhenda': ('avhende',),
'avhendet': ('avhende',),
'avhenda': ('avhende',),
'avhendet': ('avhende',),
'avhend': ('avhende',),
'avhenge': ('avhenge',),
'avhenger': ('avhenge',),
'avhenges': ('avhenge',),
'avhang': ('avhenge',),
'avhengt': ('avhenge',),
'avheng': ('avhenge',),
'avhente': ('avhente',),
'avhenter': ('avhente',),
'avhentes': ('avhente',),
'avhenta': ('avhente',),
'avhentet': ('avhente',),
'avhenta': ('avhente',),
'avhentet': ('avhente',),
'avhent': ('avhente',),
'avherde': ('avherde',),
'avherder': ('avherde',),
'avherdes': ('avherde',),
'avherda': ('avherde',),
'avherdet': ('avherde',),
'avherda': ('avherde',),
'avherdet': ('avherde',),
'avherd': ('avherde',),
'avhjelpe': ('avhjelpe',),
'avhjelper': ('avhjelpe',),
'avhjelpes': ('avhjelpe',),
'avhjalp': ('avhjelpe',),
'avhjulpet': ('avhjelpe',),
'avhjelp': ('avhjelpe',),
'avhjemle': ('avhjemle',),
'avhjemler': ('avhjemle',),
'avhjemles': ('avhjemle',),
'avhjemla': ('avhjemle',),
'avhjemlet': ('avhjemle',),
'avhjemla': ('avhjemle',),
'avhjemlet': ('avhjemle',),
'avhjeml': ('avhjemle',),
'avhjemle': ('avhjemle',),
'avhjeml': ('avhjemle',),
'avhjemle': ('avhjemle',),
'avholde': ('avholde',),
'avholder': ('avholde',),
'avholdes': ('avholde',),
'avholdt': ('avholde',),
'avhold': ('avholde',),
'avhøre': ('avhøre',),
'avhører': ('avhøre',),
'avhøres': ('avhøre',),
'avhørte': ('avhøre',),
'avhørt': ('avhøre',),
'avhør': ('avhøre',),
'avise': ('avise',),
'aviser': ('avise',),
'avises': ('avise',),
'aviste': ('avise',),
'avist': ('avise',),
'avis': ('avise',),
'avkante': ('avkante',),
'avkanter': ('avkante',),
'avkantes': ('avkante',),
'avkanta': ('avkante',),
'avkantet': ('avkante',),
'avkanta': ('avkante',),
'avkantet': ('avkante',),
'avkant': ('avkante',),
'avkjøle': ('avkjøle',),
'avkjøler': ('avkjøle',),
'avkjøles': ('avkjøle',),
'avkjølte': ('avkjøle',),
'avkjølt': ('avkjøle',),
'avkjøl': ('avkjøle',),
'avkjønne': ('avkjønne',),
'avkjønner': ('avkjønne',),
'avkjønnes': ('avkjønne',),
'avkjønna': ('avkjønne',),
'avkjønnet': ('avkjønne',),
'avkjønna': ('avkjønne',),
'avkjønnet': ('avkjønne',),
'avkjønn': ('avkjønne',),
'avklare': ('avklare',),
'avklarer': ('avklare',),
'avklares': ('avklare',),
'avklarte': ('avklare',),
'avklart': ('avklare',),
'avklar': ('avklare',),
'avkle': ('avkle',),
'avkler': ('avkle',),
'avkles': ('avkle',),
'avkledde': ('avkle',),
'avkledd': ('avkle',),
'avkle': ('avkle',),
'avkode': ('avkode',),
'avkoder': ('avkode',),
'avkodes': ('avkode',),
'avkoda': ('avkode',),
'avkodet': ('avkode',),
'avkoda': ('avkode',),
'avkodet': ('avkode',),
'avkod': ('avkode',),
'avkoke': ('avkoke',),
'avkoker': ('avkoke',),
'avkokes': ('avkoke',),
'avkokte': ('avkoke',),
'avkokt': ('avkoke',),
'avkok': ('avkoke',),
'avkolonisere': ('avkolonisere',),
'avkoloniserer': ('avkolonisere',),
'avkoloniseres': ('avkolonisere',),
'avkoloniserte': ('avkolonisere',),
'avkolonisert': ('avkolonisere',),
'avkoloniser': ('avkolonisere',),
'avkorte': ('avkorte',),
'avkorter': ('avkorte',),
'avkortes': ('avkorte',),
'avkorta': ('avkorte',),
'avkortet': ('avkorte',),
'avkorta': ('avkorte',),
'avkortet': ('avkorte',),
'avkort': ('avkorte',),
'avkrefte': ('avkrefte',),
'avkrefter': ('avkrefte',),
'avkreftes': ('avkrefte',),
'avkrefta': ('avkrefte',),
'avkreftet': ('avkrefte',),
'avkrefta': ('avkrefte',),
'avkreftet': ('avkrefte',),
'avkreft': ('avkrefte',),
'avkreve': ('avkreve',),
'avkrever': ('avkreve',),
'avkreves': ('avkreve',),
'avkrevet': ('avkreve',),
'avkrevde': ('avkreve',),
'avkrevet': ('avkreve',),
'avkrevd': ('avkreve',),
'avkrev': ('avkreve',),
'avkriminalisere': ('avkriminalisere',),
'avkriminaliserer': ('avkriminalisere',),
'avkriminaliseres': ('avkriminalisere',),
'avkriminaliserte': ('avkriminalisere',),
'avkriminalisert': ('avkriminalisere',),
'avkriminaliser': ('avkriminalisere',),
'avkristne': ('avkristne',),
'avkristner': ('avkristne',),
'avkristnes': ('avkristne',),
'avkristna': ('avkristne',),
'avkristnet': ('avkristne',),
'avkristna': ('avkristne',),
'avkristnet': ('avkristne',),
'avkristn': ('avkristne',),
'avkristne': ('avkristne',),
'avkristn': ('avkristne',),
'avkristne': ('avkristne',),
'avlaste': ('avlaste',),
'avlaster': ('avlaste',),
'avlastes': ('avlaste',),
'avlasta': ('avlaste',),
'avlastet': ('avlaste',),
'avlasta': ('avlaste',),
'avlastet': ('avlaste',),
'avlast': ('avlaste',),
'avle': ('avle',),
'avler': ('avle',),
'avles': ('avle',),
'avla': ('avle',),
'avlet': ('avle',),
'avla': ('avle',),
'avlet': ('avle',),
'avl': ('avle',),
'avle': ('avle',),
'avl': ('avle',),
'avle': ('avle',),
'avlede': ('avlede',),
'avleder': ('avlede',),
'avledes': ('avlede',),
'avleda': ('avlede',),
'avledet': ('avlede',),
'avleda': ('avlede',),
'avledet': ('avlede',),
'avled': ('avlede',),
'avlegge': ('avlegge',),
'avlegger': ('avlegge',),
'avlegges': ('avlegge',),
'avla': ('avlegge',),
'avlagt': ('avlegge',),
'avlegg': ('avlegge',),
'avleie': ('avleie',),
'avleier': ('avleie',),
'avleies': ('avleie',),
'avleide': ('avleie',),
'avleid': ('avleie',),
'avlei': ('avleie',),
'avleire': ('avleire',),
'avleirer': ('avleire',),
'avleires': ('avleire',),
'avleira': ('avleire',),
'avleiret': ('avleire',),
'avleira': ('avleire',),
'avleiret': ('avleire',),
'avleir': ('avleire',),
'avlese': ('avlese',),
'avleser': ('avlese',),
'avleses': ('avlese',),
'avleste': ('avlese',),
'avlest': ('avlese',),
'avles': ('avlese',),
'avlevere': ('avlevere',),
'avleverer': ('avlevere',),
'avleveres': ('avlevere',),
'avleverte': ('avlevere',),
'avlevert': ('avlevere',),
'avlever': ('avlevere',),
'avlive': ('avlive',),
'avliver': ('avlive',),
'avlives': ('avlive',),
'avliva': ('avlive',),
'avlivet': ('avlive',),
'avliva': ('avlive',),
'avlivet': ('avlive',),
'avliv': ('avlive',),
'avlokke': ('avlokke',),
'avlokker': ('avlokke',),
'avlokkes': ('avlokke',),
'avlokka': ('avlokke',),
'avlokket': ('avlokke',),
'avlokka': ('avlokke',),
'avlokket': ('avlokke',),
'avlokk': ('avlokke',),
'avlure': ('avlure',),
'avlurer': ('avlure',),
'avlures': ('avlure',),
'avlurte': ('avlure',),
'avlurt': ('avlure',),
'avlur': ('avlure',),
'avluse': ('avluse',),
'avluser': ('avluse',),
'avluses': ('avluse',),
'avlusa': ('avluse',),
'avluset': ('avluse',),
'avluste': ('avluse',),
'avlusa': ('avluse',),
'avluset': ('avluse',),
'avlust': ('avluse',),
'avlus': ('avluse',),
'avlyse': ('avlyse',),
'avlyser': ('avlyse',),
'avlyses': ('avlyse',),
'avlyste': ('avlyse',),
'avlyst': ('avlyse',),
'avlys': ('avlyse',),
'avlytte': ('avlytte',),
'avlytter': ('avlytte',),
'avlyttes': ('avlytte',),
'avlytta': ('avlytte',),
'avlyttet': ('avlytte',),
'avlytta': ('avlytte',),
'avlyttet': ('avlytte',),
'avlytt': ('avlytte',),
'avlåse': ('avlåse',),
'avlåser': ('avlåse',),
'avlåses': ('avlåse',),
'avlåste': ('avlåse',),
'avlåst': ('avlåse',),
'avlås': ('avlåse',),
'avlønne': ('avlønne',),
'avlønner': ('avlønne',),
'avlønnes': ('avlønne',),
'avlønna': ('avlønne',),
'avlønnet': ('avlønne',),
'avlønte': ('avlønne',),
'avlønna': ('avlønne',),
'avlønnet': ('avlønne',),
'avlønt': ('avlønne',),
'avlønn': ('avlønne',),
'avløse': ('avløse',),
'avløser': ('avløse',),
'avløses': ('avløse',),
'avløste': ('avløse',),
'avløst': ('avløse',),
'avløs': ('avløse',),
'avløyse': ('avløyse',),
'avløyser': ('avløyse',),
'avløyses': ('avløyse',),
'avløyste': ('avløyse',),
'avløyst': ('avløyse',),
'avløys': ('avløyse',),
'avmagnetisere': ('avmagnetisere',),
'avmagnetiserer': ('avmagnetisere',),
'avmagnetiseres': ('avmagnetisere',),
'avmagnetiserte': ('avmagnetisere',),
'avmagnetisert': ('avmagnetisere',),
'avmagnetiser': ('avmagnetisere',),
'avmagre': ('avmagre',),
'avmagrer': ('avmagre',),
'avmagres': ('avmagre',),
'avmagra': ('avmagre',),
'avmagret': ('avmagre',),
'avmagra': ('avmagre',),
'avmagret': ('avmagre',),
'avmagr': ('avmagre',),
'avmagre': ('avmagre',),
'avmagr': ('avmagre',),
'avmagre': ('avmagre',),
'avmarsjere': ('avmarsjere',),
'avmarsjerer': ('avmarsjere',),
'avmarsjeres': ('avmarsjere',),
'avmarsjerte': ('avmarsjere',),
'avmarsjert': ('avmarsjere',),
'avmarsjer': ('avmarsjere',),
'avmerke': ('avmerke',),
'avmerker': ('avmerke',),
'avmerkes': ('avmerke',),
'avmerka': ('avmerke',),
'avmerket': ('avmerke',),
'avmerka': ('avmerke',),
'avmerket': ('avmerke',),
'avmerk': ('avmerke',),
'avmilitarisere': ('avmilitarisere',),
'avmilitariserer': ('avmilitarisere',),
'avmilitariseres': ('avmilitarisere',),
'avmilitariserte': ('avmilitarisere',),
'avmilitarisert': ('avmilitarisere',),
'avmilitariser': ('avmilitarisere',),
'avmytologisere': ('avmytologisere',),
'avmytologiserer': ('avmytologisere',),
'avmytologiseres': ('avmytologisere',),
'avmytologiserte': ('avmytologisere',),
'avmytologisert': ('avmytologisere',),
'avmytologiser': ('avmytologisere',),
'avmåle': ('avmåle',),
'avmåler': ('avmåle',),
'avmåles': ('avmåle',),
'avmålte': ('avmåle',),
'avmålt': ('avmåle',),
'avmål': ('avmåle',),
'avmønstre': ('avmønstre',),
'avmønstrer': ('avmønstre',),
'avmønstres': ('avmønstre',),
'avmønstra': ('avmønstre',),
'avmønstret': ('avmønstre',),
'avmønstra': ('avmønstre',),
'avmønstret': ('avmønstre',),
'avmønstr': ('avmønstre',),
'avmønstre': ('avmønstre',),
'avmønstr': ('avmønstre',),
'avmønstre': ('avmønstre',),
'avnasjonalisere': ('avnasjonalisere',),
'avnasjonaliserer': ('avnasjonalisere',),
'avnasjonaliseres': ('avnasjonalisere',),
'avnasjonaliserte': ('avnasjonalisere',),
'avnasjonalisert': ('avnasjonalisere',),
'avnasjonaliser': ('avnasjonalisere',),
'avnorske': ('avnorske',),
'avnorsker': ('avnorske',),
'avnorskes': ('avnorske',),
'avnorska': ('avnorske',),
'avnorsket': ('avnorske',),
'avnorska': ('avnorske',),
'avnorsket': ('avnorske',),
'avnorsk': ('avnorske',),
'avpasse': ('avpasse',),
'avpasser': ('avpasse',),
'avpasses': ('avpasse',),
'avpassa': ('avpasse',),
'avpasset': ('avpasse',),
'avpassa': ('avpasse',),
'avpasset': ('avpasse',),
'avpass': ('avpasse',),
'avpatruljere': ('avpatruljere',),
'avpatruljerer': ('avpatruljere',),
'avpatruljeres': ('avpatruljere',),
'avpatruljerte': ('avpatruljere',),
'avpatruljert': ('avpatruljere',),
'avpatruljer': ('avpatruljere',),
'avpolitisere': ('avpolitisere',),
'avpolitiserer': ('avpolitisere',),
'avpolitiseres': ('avpolitisere',),
'avpolitiserte': ('avpolitisere',),
'avpolitisert': ('avpolitisere',),
'avpolitiser': ('avpolitisere',),
'avreagere': ('avreagere',),
'avreagerer': ('avreagere',),
'avreageres': ('avreagere',),
'avreagerte': ('avreagere',),
'avreagert': ('avreagere',),
'avreager': ('avreagere',),
'avrette': ('avrette',),
'avretter': ('avrette',),
'avrettes': ('avrette',),
'avretta': ('avrette',),
'avrettet': ('avrette',),
'avretta': ('avrette',),
'avrettet': ('avrette',),
'avrett': ('avrette',),
'avrime': ('avrime',),
'avrimer': ('avrime',),
'avrimes': ('avrime',),
'avrima': ('avrime',),
'avrimet': ('avrime',),
'avrima': ('avrime',),
'avrimet': ('avrime',),
'avrim': ('avrime',),
'avrunde': ('avrunde',),
'avrunder': ('avrunde',),
'avrundes': ('avrunde',),
'avrunda': ('avrunde',),
'avrundet': ('avrunde',),
'avrunda': ('avrunde',),
'avrundet': ('avrunde',),
'avrund': ('avrunde',),
'avruse': ('avruse',),
'avruser': ('avruse',),
'avruses': ('avruse',),
'avrusa': ('avruse',),
'avruset': ('avruse',),
'avrusa': ('avruse',),
'avruset': ('avruse',),
'avrus': ('avruse',),
'avruste': ('avruste',),
'avruster': ('avruste',),
'avrustes': ('avruste',),
'avrusta': ('avruste',),
'avrustet': ('avruste',),
'avrusta': ('avruste',),
'avrustet': ('avruste',),
'avrust': ('avruste',),
'avsanne': ('avsanne',),
'avsanner': ('avsanne',),
'avsannes': ('avsanne',),
'avsanna': ('avsanne',),
'avsannet': ('avsanne',),
'avsanna': ('avsanne',),
'avsannet': ('avsanne',),
'avsann': ('avsanne',),
'avse': ('avse',),
'avser': ('avse',),
'avses': ('avse',),
'avsees': ('avse',),
'avså': ('avse',),
'avsett': ('avse',),
'avse': ('avse',),
'avsende': ('avsende',),
'avsender': ('avsende',),
'avsendes': ('avsende',),
'avsendte': ('avsende',),
'avsendt': ('avsende',),
'avsend': ('avsende',),
'avsette': ('avsette',),
'avsetter': ('avsette',),
'avsettes': ('avsette',),
'avsatte': ('avsette',),
'avsatt': ('avsette',),
'avsett': ('avsette',),
'avsi': ('avsi',),
'avsier': ('avsi',),
'avsies': ('avsi',),
'avsa': ('avsi',),
'avsagt': ('avsi',),
'avsi': ('avsi',),
'avsile': ('avsile',),
'avsiler': ('avsile',),
'avsiles': ('avsile',),
'avsilte': ('avsile',),
'avsilt': ('avsile',),
'avsil': ('avsile',),
'avskaffe': ('avskaffe',),
'avskaffer': ('avskaffe',),
'avskaffes': ('avskaffe',),
'avskaffa': ('avskaffe',),
'avskaffet': ('avskaffe',),
'avskaffa': ('avskaffe',),
'avskaffet': ('avskaffe',),
'avskaff': ('avskaffe',),
'avskalle': ('avskalle',),
'avskaller': ('avskalle',),
'avskalles': ('avskalle',),
'avskalla': ('avskalle',),
'avskallet': ('avskalle',),
'avskalla': ('avskalle',),
'avskallet': ('avskalle',),
'avskall': ('avskalle',),
'avskilte': ('avskilte',),
'avskilter': ('avskilte',),
'avskiltes': ('avskilte',),
'avskilta': ('avskilte',),
'avskiltet': ('avskilte',),
'avskilta': ('avskilte',),
'avskiltet': ('avskilte',),
'avskilt': ('avskilte',),
'avskipe': ('avskipe',),
'avskiper': ('avskipe',),
'avskipes': ('avskipe',),
'avskipa': ('avskipe',),
'avskipet': ('avskipe',),
'avskipa': ('avskipe',),
'avskipet': ('avskipe',),
'avskip': ('avskipe',),
'avskjedige': ('avskjedige',),
'avskjediger': ('avskjedige',),
'avskjediges': ('avskjedige',),
'avskjediga': ('avskjedige',),
'avskjediget': ('avskjedige',),
'avskjediga': ('avskjedige',),
'avskjediget': ('avskjedige',),
'avskjedig': ('avskjedige',),
'avskjerme': ('avskjerme',),
'avskjermer': ('avskjerme',),
'avskjermes': ('avskjerme',),
'avskjerma': ('avskjerme',),
'avskjermet': ('avskjerme',),
'avskjerma': ('avskjerme',),
'avskjermet': ('avskjerme',),
'avskjerm': ('avskjerme',),
'avskjære': ('avskjære',),
'avskjærer': ('avskjære',),
'avskjæres': ('avskjære',),
'avskar': ('avskjære',),
'avskåret': ('avskjære',),
'avskjær': ('avskjære',),
'avskoge': ('avskoge',),
'avskoger': ('avskoge',),
'avskoges': ('avskoge',),
'avskoga': ('avskoge',),
'avskoget': ('avskoge',),
'avskoga': ('avskoge',),
'avskoget': ('avskoge',),
'avskog': ('avskoge',),
'avskrape': ('avskrape',),
'avskraper': ('avskrape',),
'avskrapes': ('avskrape',),
'avskrapa': ('avskrape',),
'avskrapet': ('avskrape',),
'avskrapte': ('avskrape',),
'avskrapa': ('avskrape',),
'avskrapet': ('avskrape',),
'avskrapt': ('avskrape',),
'avskrap': ('avskrape',),
'avskrekke': ('avskrekke',),
'avskrekker': ('avskrekke',),
'avskrekkes': ('avskrekke',),
'avskrekka': ('avskrekke',),
'avskrekket': ('avskrekke',),
'avskrekka': ('avskrekke',),
'avskrekket': ('avskrekke',),
'avskrekk': ('avskrekke',),
'avskrive': ('avskrive',),
'avskriver': ('avskrive',),
'avskrives': ('avskrive',),
'avskrev': ('avskrive',),
'avskreiv': ('avskrive',),
'avskrev': ('avskrive',),
'avskreiv': ('avskrive',),
'avskrevet': ('avskrive',),
'avskriv': ('avskrive',),
'avsky': ('avsky',),
'avskyr': ('avsky',),
'avskys': ('avsky',),
'avskydde': ('avsky',),
'avskydd': ('avsky',),
'avsky': ('avsky',),
'avslutte': ('avslutte',),
'avslutter': ('avslutte',),
'avsluttes': ('avslutte',),
'avslutta': ('avslutte',),
'avsluttet': ('avslutte',),
'avslutta': ('avslutte',),
'avsluttet': ('avslutte',),
'avslutt': ('avslutte',),
'avslå': ('avslå',),
'avslår': ('avslå',),
'avslås': ('avslå',),
'avslåes': ('avslå',),
'avslo': ('avslå',),
'avslått': ('avslå',),
'avslå': ('avslå',),
'avsløre': ('avsløre',),
'avslører': ('avsløre',),
'avsløres': ('avsløre',),
'avsløra': ('avsløre',),
'avsløret': ('avsløre',),
'avslørte': ('avsløre',),
'avsløra': ('avsløre',),
'avsløret': ('avsløre',),
'avslørt': ('avsløre',),
'avslør': ('avsløre',),
'avsondre': ('avsondre',),
'avsondrer': ('avsondre',),
'avsondres': ('avsondre',),
'avsondra': ('avsondre',),
'avsondret': ('avsondre',),
'avsondra': ('avsondre',),
'avsondret': ('avsondre',),
'avsondr': ('avsondre',),
'avsondre': ('avsondre',),
'avsondr': ('avsondre',),
'avsondre': ('avsondre',),
'avsone': ('avsone',),
'avsoner': ('avsone',),
'avsones': ('avsone',),
'avsona': ('avsone',),
'avsonet': ('avsone',),
'avsonte': ('avsone',),
'avsona': ('avsone',),
'avsonet': ('avsone',),
'avsont': ('avsone',),
'avson': ('avsone',),
'avspalte': ('avspalte',),
'avspalter': ('avspalte',),
'avspaltes': ('avspalte',),
'avspalta': ('avspalte',),
'avspaltet': ('avspalte',),
'avspalta': ('avspalte',),
'avspaltet': ('avspalte',),
'avspalt': ('avspalte',),
'avspasere': ('avspasere',),
'avspaserer': ('avspasere',),
'avspaseres': ('avspasere',),
'avspaserte': ('avspasere',),
'avspasert': ('avspasere',),
'avspaser': ('avspasere',),
'avspeile': ('avspeile',),
'avspeiler': ('avspeile',),
'avspeiles': ('avspeile',),
'avspeila': ('avspeile',),
'avspeilet': ('avspeile',),
'avspeilte': ('avspeile',),
'avspeila': ('avspeile',),
'avspeilet': ('avspeile',),
'avspeilt': ('avspeile',),
'avspeil': ('avspeile',),
'avsperre': ('avsperre',),
'avsperrer': ('avsperre',),
'avsperres': ('avsperre',),
'avsperra': ('avsperre',),
'avsperret': ('avsperre',),
'avsperra': ('avsperre',),
'avsperret': ('avsperre',),
'avsperr': ('avsperre',),
'avspise': ('avspise',),
'avspiser': ('avspise',),
'avspises': ('avspise',),
'avspiste': ('avspise',),
'avspist': ('avspise',),
'avspis': ('avspise',),
'avspore': ('avspore',),
'avsporer': ('avspore',),
'avspores': ('avspore',),
'avspora': ('avspore',),
'avsporet': ('avspore',),
'avsporte': ('avspore',),
'avspora': ('avspore',),
'avsporet': ('avspore',),
'avsport': ('avspore',),
'avspor': ('avspore',),
'avstedkomme': ('avstedkomme',),
'avstedkommer': ('avstedkomme',),
'avstedkommes': ('avstedkomme',),
'avstedkom': ('avstedkomme',),
'avstedkommet': ('avstedkomme',),
'avstedkom': ('avstedkomme',),
'avstemme': ('avstemme',),
'avstemmer': ('avstemme',),
'avstemmes': ('avstemme',),
'avstemte': ('avstemme',),
'avstemt': ('avstemme',),
'avstem': ('avstemme',),
'avstive': ('avstive',),
'avstiver': ('avstive',),
'avstives': ('avstive',),
'avstiva': ('avstive',),
'avstivet': ('avstive',),
'avstiva': ('avstive',),
'avstivet': ('avstive',),
'avstiv': ('avstive',),
'avstraffe': ('avstraffe',),
'avstraffer': ('avstraffe',),
'avstraffes': ('avstraffe',),
'avstraffa': ('avstraffe',),
'avstraffet': ('avstraffe',),
'avstraffa': ('avstraffe',),
'avstraffet': ('avstraffe',),
'avstraff': ('avstraffe',),
'avstresse': ('avstresse',),
'avstresser': ('avstresse',),
'avstresses': ('avstresse',),
'avstressa': ('avstresse',),
'avstresset': ('avstresse',),
'avstressa': ('avstresse',),
'avstresset': ('avstresse',),
'avstress': ('avstresse',),
'avstå': ('avstå',),
'avstår': ('avstå',),
'avstås': ('avstå',),
'avsto': ('avstå',),
'avstod': ('avstå',),
'avstått': ('avstå',),
'avstå': ('avstå',),
'avstøpe': ('avstøpe',),
'avstøper': ('avstøpe',),
'avstøpes': ('avstøpe',),
'avstøpte': ('avstøpe',),
'avstøpt': ('avstøpe',),
'avstøp': ('avstøpe',),
'avsvekke': ('avsvekke',),
'avsvekker': ('avsvekke',),
'avsvekkes': ('avsvekke',),
'avsvekka': ('avsvekke',),
'avsvekket': ('avsvekke',),
'avsvekte': ('avsvekke',),
'avsvekka': ('avsvekke',),
'avsvekket': ('avsvekke',),
'avsvekt': ('avsvekke',),
'avsvekk': ('avsvekke',),
'avsverge': ('avsverge',),
'avsverger': ('avsverge',),
'avsverges': ('avsverge',),
'avsverga': ('avsverge',),
'avsverget': ('avsverge',),
'avsvor': ('avsverge',),
'avsverga': ('avsverge',),
'avsverget': ('avsverge',),
'avsvoret': ('avsverge',),
'avsverg': ('avsverge',),
'avsvi': ('avsvi',),
'avsvir': ('avsvi',),
'avsvis': ('avsvi',),
'avsvidde': ('avsvi',),
'avsvei': ('avsvi',),
'avsved': ('avsvi',),
'avsvidd': ('avsvi',),
'avsvi': ('avsvi',),
'avsynge': ('avsynge',),
'avsynger': ('avsynge',),
'avsynges': ('avsynge',),
'avsang': ('avsynge',),
'avsunget': ('avsynge',),
'avsyng': ('avsynge',),
'avta': ('avta',),
'avtar': ('avta',),
'avtas': ('avta',),
'avtok': ('avta',),
'avtatt': ('avta',),
'avta': ('avta',),
'avtale': ('avtale',),
'avtaler': ('avtale',),
'avtales': ('avtale',),
'avtalte': ('avtale',),
'avtalt': ('avtale',),
'avtal': ('avtale',),
'avtalefeste': ('avtalefeste',),
'avtalefester': ('avtalefeste',),
'avtalefestes': ('avtalefeste',),
'avtalefesta': ('avtalefeste',),
'avtalefestet': ('avtalefeste',),
'avtalefesta': ('avtalefeste',),
'avtalefestet': ('avtalefeste',),
'avtalefest': ('avtalefeste',),
'avtegne': ('avtegne',),
'avtegner': ('avtegne',),
'avtegnes': ('avtegne',),
'avtegna': ('avtegne',),
'avtegnet': ('avtegne',),
'avtegna': ('avtegne',),
'avtegnet': ('avtegne',),
'avtegn': ('avtegne',),
'avtjene': ('avtjene',),
'avtjener': ('avtjene',),
'avtjenes': ('avtjene',),
'avtjente': ('avtjene',),
'avtjent': ('avtjene',),
'avtjen': ('avtjene',),
'avtrappe': ('avtrappe',),
'avtrapper': ('avtrappe',),
'avtrappes': ('avtrappe',),
'avtrappa': ('avtrappe',),
'avtrappet': ('avtrappe',),
'avtrappa': ('avtrappe',),
'avtrappet': ('avtrappe',),
'avtrapp': ('avtrappe',),
'avtvinge': ('avtvinge',),
'avtvinger': ('avtvinge',),
'avtvinges': ('avtvinge',),
'avtvang': ('avtvinge',),
'avtvunget': ('avtvinge',),
'avtving': ('avtvinge',),
'avveie': ('avveie',),
'avveier': ('avveie',),
'avveies': ('avveie',),
'avveide': ('avveie',),
'avveid': ('avveie',),
'avvei': ('avveie',),
'avvende': ('avvende',),
'avvender': ('avvende',),
'avvendes': ('avvende',),
'avvendte': ('avvende',),
'avvendt': ('avvende',),
'avvend': ('avvende',),
'avvenne': ('avvenne',),
'avvenner': ('avvenne',),
'avvennes': ('avvenne',),
'avvennet': ('avvenne',),
'avvente': ('avvenne',),
'avvennet': ('avvenne',),
'avvent': ('avvenne',),
'avvenn': ('avvenne',),
'avvente': ('avvente',),
'avventer': ('avvente',),
'avventes': ('avvente',),
'avventa': ('avvente',),
'avventet': ('avvente',),
'avventa': ('avvente',),
'avventet': ('avvente',),
'avvent': ('avvente',),
'avverge': ('avverge',),
'avverger': ('avverge',),
'avverges': ('avverge',),
'avverga': ('avverge',),
'avverget': ('avverge',),
'avverga': ('avverge',),
'avverget': ('avverge',),
'avverg': ('avverge',),
'avvike': ('avvike',),
'avviker': ('avvike',),
'avvikes': ('avvike',),
'avvek': ('avvike',),
'avveik': ('avvike',),
'avvek': ('avvike',),
'avveik': ('avvike',),
'avveket': ('avvike',),
'avvik': ('avvike',),
'avvikle': ('avvikle',),
'avvikler': ('avvikle',),
'avvikles': ('avvikle',),
'avvikla': ('avvikle',),
'avviklet': ('avvikle',),
'avvikla': ('avvikle',),
'avviklet': ('avvikle',),
'avvikl': ('avvikle',),
'avvikle': ('avvikle',),
'avvikl': ('avvikle',),
'avvikle': ('avvikle',),
'avvirke': ('avvirke',),
'avvirker': ('avvirke',),
'avvirkes': ('avvirke',),
'avvirka': ('avvirke',),
'avvirket': ('avvirke',),
'avvirka': ('avvirke',),
'avvirket': ('avvirke',),
'avvirk': ('avvirke',),
'avvise': ('avvise',),
'avviser': ('avvise',),
'avvises': ('avvise',),
'avviste': ('avvise',),
'avvist': ('avvise',),
'avvis': ('avvise',),
'avvæpne': ('avvæpne',),
'avvæpner': ('avvæpne',),
'avvæpnes': ('avvæpne',),
'avvæpna': ('avvæpne',),
'avvæpnet': ('avvæpne',),
'avvæpna': ('avvæpne',),
'avvæpnet': ('avvæpne',),
'avvæpn': ('avvæpne',),
'avvæpne': ('avvæpne',),
'avvæpn': ('avvæpne',),
'avvæpne': ('avvæpne',),
'bable': ('bable',),
'babler': ('bable',),
'bables': ('bable',),
'babla': ('bable',),
'bablet': ('bable',),
'babla': ('bable',),
'bablet': ('bable',),
'babl': ('bable',),
'bable': ('bable',),
'babl': ('bable',),
'bable': ('bable',),
'bade': ('bade',),
'bader': ('bade',),
'bades': ('bade',),
'bada': ('bade',),
'badet': ('bade',),
'bada': ('bade',),
'badet': ('bade',),
'bad': ('bade',),
'bagatellisere': ('bagatellisere',),
'bagatelliserer': ('bagatellisere',),
'bagatelliseres': ('bagatellisere',),
'bagatelliserte': ('bagatellisere',),
'bagatellisert': ('bagatellisere',),
'bagatelliser': ('bagatellisere',),
'baisse': ('baisse',),
'baisser': ('baisse',),
'baisses': ('baisse',),
'baissa': ('baisse',),
'baisset': ('baisse',),
'baissa': ('baisse',),
'baisset': ('baisse',),
'baiss': ('baisse',),
'bakbinde': ('bakbinde',),
'bakbinder': ('bakbinde',),
'bakbindes': ('bakbinde',),
'bakbandt': ('bakbinde',),
'bakbundet': ('bakbinde',),
'bakbind': ('bakbinde',),
'bake': ('bake',),
'baker': ('bake',),
'bakes': ('bake',),
'bakte': ('bake',),
'bakt': ('bake',),
'bak': ('bake',),
'bakke': ('bakke',),
'bakker': ('bakke',),
'bakkes': ('bakke',),
'bakka': ('bakke',),
'bakket': ('bakke',),
'bakka': ('bakke',),
'bakket': ('bakke',),
'bakk': ('bakke',),
'bakse': ('bakse',),
'bakser': ('bakse',),
'bakses': ('bakse',),
'baksa': ('bakse',),
'bakset': ('bakse',),
'baksa': ('bakse',),
'bakset': ('bakse',),
'baks': ('bakse',),
'baksnakke': ('baksnakke',),
'baksnakker': ('baksnakke',),
'baksnakkes': ('baksnakke',),
'baksnakka': ('baksnakke',),
'baksnakket': ('baksnakke',),
'baksnakka': ('baksnakke',),
'baksnakket': ('baksnakke',),
'baksnakk': ('baksnakke',),
'baktale': ('baktale',),
'baktaler': ('baktale',),
'baktales': ('baktale',),
'baktalte': ('baktale',),
'baktalt': ('baktale',),
'baktal': ('baktale',),
'bakvaske': ('bakvaske',),
'bakvasker': ('bakvaske',),
'bakvaskes': ('bakvaske',),
'bakvaska': ('bakvaske',),
'bakvasket': ('bakvaske',),
'bakvaska': ('bakvaske',),
'bakvasket': ('bakvaske',),
'bakvask': ('bakvaske',),
'balansere': ('balansere',),
'balanserer': ('balansere',),
'balanseres': ('balansere',),
'balanserte': ('balansere',),
'balansert': ('balansere',),
'balanser': ('balansere',),
'bale': ('bale',),
'baler': ('bale',),
'bales': ('bale',),
'bala': ('bale',),
'balet': ('bale',),
'balte': ('bale',),
'bala': ('bale',),
'balet': ('bale',),
'balt': ('bale',),
'bal': ('bale',),
'balkanisere': ('balkanisere',),
'balkaniserer': ('balkanisere',),
'balkaniseres': ('balkanisere',),
'balkaniserte': ('balkanisere',),
'balkanisert': ('balkanisere',),
'balkaniser': ('balkanisere',),
'ballaste': ('ballaste',),
'ballaster': ('ballaste',),
'ballastes': ('ballaste',),
'ballasta': ('ballaste',),
'ballastet': ('ballaste',),
'ballasta': ('ballaste',),
'ballastet': ('ballaste',),
'ballast': ('ballaste',),
'balle': ('balle',),
'baller': ('balle',),
'balles': ('balle',),
'balla': ('balle',),
'ballet': ('balle',),
'balla': ('balle',),
'ballet': ('balle',),
'ball': ('balle',),
'ballottere': ('ballottere',),
'ballotterer': ('ballottere',),
'ballotteres': ('ballottere',),
'ballotterte': ('ballottere',),
'ballottert': ('ballottere',),
'ballotter': ('ballottere',),
'balsamere': ('balsamere',),
'balsamerer': ('balsamere',),
'balsameres': ('balsamere',),
'balsamerte': ('balsamere',),
'balsamert': ('balsamere',),
'balsamer': ('balsamere',),
'banalisere': ('banalisere',),
'banaliserer': ('banalisere',),
'banaliseres': ('banalisere',),
'banaliserte': ('banalisere',),
'banalisert': ('banalisere',),
'banaliser': ('banalisere',),
'bandasjere': ('bandasjere',),
'bandasjerer': ('bandasjere',),
'bandasjeres': ('bandasjere',),
'bandasjerte': ('bandasjere',),
'bandasjert': ('bandasjere',),
'bandasjer': ('bandasjere',),
'bande': ('bande',),
'bander': ('bande',),
'bandes': ('bande',),
'banda': ('bande',),
'bandet': ('bande',),
'banda': ('bande',),
'bandet': ('bande',),
'band': ('bande',),
'bandlegge': ('bandlegge',),
'bandlegger': ('bandlegge',),
'bandlegges': ('bandlegge',),
'bandla': ('bandlegge',),
'bandlagt': ('bandlegge',),
'bandlegg': ('bandlegge',),
'bane': ('bane',),
'baner': ('bane',),
'banes': ('bane',),
'bana': ('bane',),
'banet': ('bane',),
'bante': ('bane',),
'bana': ('bane',),
'banet': ('bane',),
'bant': ('bane',),
'ban': ('bane',),
'banke': ('banke',),
'banker': ('banke',),
'bankes': ('banke',),
'banka': ('banke',),
'banket': ('banke',),
'banka': ('banke',),
'banket': ('banke',),
'bank': ('banke',),
'banne': ('banne',),
'banner': ('banne',),
'bannes': ('banne',),
'banna': ('banne',),
'bannet': ('banne',),
'bante': ('banne',),
'banna': ('banne',),
'bannet': ('banne',),
'bant': ('banne',),
'bann': ('banne',),
'bannlyse': ('bannlyse',),
'bannlyser': ('bannlyse',),
'bannlyses': ('bannlyse',),
'bannlyste': ('bannlyse',),
'bannlyst': ('bannlyse',),
'bannlys': ('bannlyse',),
'bannsette': ('bannsette',),
'bannsetter': ('bannsette',),
'bannsettes': ('bannsette',),
'bannsatte': ('bannsette',),
'bannsatt': ('bannsette',),
'bannsett': ('bannsette',),
'barbere': ('barbere',),
'barberer': ('barbere',),
'barberes': ('barbere',),
'barberte': ('barbere',),
'barbert': ('barbere',),
'barber': ('barbere',),
'bardunere': ('bardunere',),
'bardunerer': ('bardunere',),
'barduneres': ('bardunere',),
'bardunerte': ('bardunere',),
'bardunert': ('bardunere',),
'barduner': ('bardunere',),
'bare': ('bare',),
'barer': ('bare',),
'bares': ('bare',),
'bara': ('bare',),
'baret': ('bare',),
'bara': ('bare',),
'baret': ('bare',),
'bar': ('bare',),
'barke': ('barke',),
'barker': ('barke',),
'barkes': ('barke',),
'barka': ('barke',),
'barket': ('barke',),
'barka': ('barke',),
'barket': ('barke',),
'bark': ('barke',),
'barrikadere': ('barrikadere',),
'barrikaderer': ('barrikadere',),
'barrikaderes': ('barrikadere',),
'barrikaderte': ('barrikadere',),
'barrikadert': ('barrikadere',),
'barrikader': ('barrikadere',),
'barske': ('barske',),
'barsker': ('barske',),
'barskes': ('barske',),
'barska': ('barske',),
'barsket': ('barske',),
'barska': ('barske',),
'barsket': ('barske',),
'barsk': ('barske',),
'base': ('base',),
'baser': ('base',),
'bases': ('base',),
'baste': ('base',),
'bast': ('base',),
'bas': ('base',),
'basere': ('basere',),
'baserer': ('basere',),
'baseres': ('basere',),
'baserte': ('basere',),
'basert': ('basere',),
'baser': ('basere',),
'baske': ('baske',),
'basker': ('baske',),
'baskes': ('baske',),
'baska': ('baske',),
'basket': ('baske',),
'baska': ('baske',),
'basket': ('baske',),
'bask': ('baske',),
'baste': ('baste',),
'baster': ('baste',),
'bastes': ('baste',),
'basta': ('baste',),
'bastet': ('baste',),
'basta': ('baste',),
'bastet': ('baste',),
'bast': ('baste',),
'basunere': ('basunere',),
'basunerer': ('basunere',),
'basuneres': ('basunere',),
'basunerte': ('basunere',),
'basunert': ('basunere',),
'basuner': ('basunere',),
'baute': ('baute',),
'bauter': ('baute',),
'bautes': ('baute',),
'bauta': ('baute',),
'bautet': ('baute',),
'bauta': ('baute',),
'bautet': ('baute',),
'baut': ('baute',),
'be': ('be',),
'ber': ('be',),
'bes': ('be',),
'bad': ('be',),
'ba': ('be',),
'bedt': ('be',),
'be': ('be',),
'bearbeide': ('bearbeide',),
'bearbeider': ('bearbeide',),
'bearbeides': ('bearbeide',),
'bearbeida': ('bearbeide',),
'bearbeidet': ('bearbeide',),
'bearbeidde': ('bearbeide',),
'bearbeida': ('bearbeide',),
'bearbeidet': ('bearbeide',),
'bearbeidd': ('bearbeide',),
'bearbeid': ('bearbeide',),
'bebo': ('bebo',),
'bebor': ('bebo',),
'bebos': ('bebo',),
'bebodde': ('bebo',),
'bebodd': ('bebo',),
'bebo': ('bebo',),
'bebreide': ('bebreide',),
'bebreider': ('bebreide',),
'bebreides': ('bebreide',),
'bebreida': ('bebreide',),
'bebreidet': ('bebreide',),
'bebreida': ('bebreide',),
'bebreidet': ('bebreide',),
'bebreid': ('bebreide',),
'bebude': ('bebude',),
'bebuder': ('bebude',),
'bebudes': ('bebude',),
'bebuda': ('bebude',),
'bebudet': ('bebude',),
'bebuda': ('bebude',),
'bebudet': ('bebude',),
'bebud': ('bebude',),
'bebygge': ('bebygge',),
'bebygger': ('bebygge',),
'bebygges': ('bebygge',),
'bebygget': ('bebygge',),
'bebygde': ('bebygge',),
'bebygget': ('bebygge',),
'bebygd': ('bebygge',),
'bebygg': ('bebygge',),
'bebyrde': ('bebyrde',),
'bebyrder': ('bebyrde',),
'bebyrdes': ('bebyrde',),
'bebyrda': ('bebyrde',),
'bebyrdet': ('bebyrde',),
'bebyrda': ('bebyrde',),
'bebyrdet': ('bebyrde',),
'bebyrd': ('bebyrde',),
'bedage': ('bedage',),
'bedager': ('bedage',),
'bedages': ('bedage',),
'bedaga': ('bedage',),
'bedaget': ('bedage',),
'bedaga': ('bedage',),
'bedaget': ('bedage',),
'bedag': ('bedage',),
'bede': ('bede',),
'beder': ('bede',),
'bedes': ('bede',),
'bad': ('bede',),
'bedt': ('bede',),
'bed': ('bede',),
'bedekke': ('bedekke',),
'bedekker': ('bedekke',),
'bedekkes': ('bedekke',),
'bedekka': ('bedekke',),
'bedekket': ('bedekke',),
'bedekte': ('bedekke',),
'bedekka': ('bedekke',),
'bedekket': ('bedekke',),
'bedekt': ('bedekke',),
'bedekk': ('bedekke',),
'bedra': ('bedra',),
'bedrar': ('bedra',),
'bedras': ('bedra',),
'bedrog': ('bedra',),
'bedro': ('bedra',),
'bedradd': ('bedra',),
'bedratt': ('bedra',),
'bedradd': ('bedra',),
'bedratt': ('bedra',),
'bedra': ('bedra',),
'bedre': ('bedre',),
'bedrer': ('bedre',),
'bedres': ('bedre',),
'bedra': ('bedre',),
'bedret': ('bedre',),
'bedra': ('bedre',),
'bedret': ('bedre',),
'bedr': ('bedre',),
'bedre': ('bedre',),
'bedr': ('bedre',),
'bedre': ('bedre',),
'bedrive': ('bedrive',),
'bedriver': ('bedrive',),
'bedrives': ('bedrive',),
'bedrev': ('bedrive',),
'bedreiv': ('bedrive',),
'bedrev': ('bedrive',),
'bedreiv': ('bedrive',),
'bedrevet': ('bedrive',),
'bedriv': ('bedrive',),
'bedrøve': ('bedrøve',),
'bedrøver': ('bedrøve',),
'bedrøves': ('bedrøve',),
'bedrøva': ('bedrøve',),
'bedrøvet': ('bedrøve',),
'bedrøva': ('bedrøve',),
'bedrøvet': ('bedrøve',),
'bedrøv': ('bedrøve',),
'bedyre': ('bedyre',),
'bedyrer': ('bedyre',),
'bedyres': ('bedyre',),
'bedyra': ('bedyre',),
'bedyret': ('bedyre',),
'bedyrte': ('bedyre',),
'bedyra': ('bedyre',),
'bedyret': ('bedyre',),
'bedyrt': ('bedyre',),
'bedyr': ('bedyre',),
'bedåre': ('bedåre',),
'bedårer': ('bedåre',),
'bedåres': ('bedåre',),
'bedåra': ('bedåre',),
'bedåret': ('bedåre',),
'bedåra': ('bedåre',),
'bedåret': ('bedåre',),
'bedår': ('bedåre',),
'bedømme': ('bedømme',),
'bedømmer': ('bedømme',),
'bedømmes': ('bedømme',),
'bedømte': ('bedømme',),
'bedømt': ('bedømme',),
'bedøm': ('bedømme',),
'bedøve': ('bedøve',),
'bedøver': ('bedøve',),
'bedøves': ('bedøve',),
'bedøva': ('bedøve',),
'bedøvet': ('bedøve',),
'bedøvde': ('bedøve',),
'bedøva': ('bedøve',),
'bedøvet': ('bedøve',),
'bedøvd': ('bedøve',),
'bedøv': ('bedøve',),
'beedige': ('beedige',),
'beediger': ('beedige',),
'beediges': ('beedige',),
'beediga': ('beedige',),
'beediget': ('beedige',),
'beediga': ('beedige',),
'beediget': ('beedige',),
'beedig': ('beedige',),
'befale': ('befale',),
'befaler': ('befale',),
'befales': ('befale',),
'befalte': ('befale',),
'befalt': ('befale',),
'befal': ('befale',),
'befare': ('befare',),
'befarer': ('befare',),
'befares': ('befare',),
'befarte': ('befare',),
'befart': ('befare',),
'befar': ('befare',),
'befatte': ('befatte',),
'befatter': ('befatte',),
'befattes': ('befatte',),
'befatta': ('befatte',),
'befattet': ('befatte',),
'befatta': ('befatte',),
'befattet': ('befatte',),
'befatt': ('befatte',),
'befeste': ('befeste',),
'befester': ('befeste',),
'befestes': ('befeste',),
'befesta': ('befeste',),
'befestet': ('befeste',),
'befesta': ('befeste',),
'befestet': ('befeste',),
'befest': ('befeste',),
'befinne': ('befinne',),
'befinner': ('befinne',),
'befinnes': ('befinne',),
'befant': ('befinne',),
'befunnet': ('befinne',),
'befinn': ('befinne',),
'beflitte': ('beflitte',),
'beflitter': ('beflitte',),
'beflittes': ('beflitte',),
'beflitta': ('beflitte',),
'beflittet': ('beflitte',),
'beflitta': ('beflitte',),
'beflittet': ('beflitte',),
'beflitt': ('beflitte',),
'befolke': ('befolke',),
'befolker': ('befolke',),
'befolkes': ('befolke',),
'befolka': ('befolke',),
'befolket': ('befolke',),
'befolka': ('befolke',),
'befolket': ('befolke',),
'befolk': ('befolke',),
'befordre': ('befordre',),
'befordrer': ('befordre',),
'befordres': ('befordre',),
'befordra': ('befordre',),
'befordret': ('befordre',),
'befordra': ('befordre',),
'befordret': ('befordre',),
'befordr': ('befordre',),
'befordre': ('befordre',),
'befordr': ('befordre',),
'befordre': ('befordre',),
'befrakte': ('befrakte',),
'befrakter': ('befrakte',),
'befraktes': ('befrakte',),
'befrakta': ('befrakte',),
'befraktet': ('befrakte',),
'befrakta': ('befrakte',),
'befraktet': ('befrakte',),
'befrakt': ('befrakte',),
'befri': ('befri',),
'befrir': ('befri',),
'befris': ('befri',),
'befridde': ('befri',),
'befridd': ('befri',),
'befri': ('befri',),
'befrukte': ('befrukte',),
'befrukter': ('befrukte',),
'befruktes': ('befrukte',),
'befrukta': ('befrukte',),
'befruktet': ('befrukte',),
'befrukta': ('befrukte',),
'befruktet': ('befrukte',),
'befrukt': ('befrukte',),
'beføle': ('beføle',),
'beføler': ('beføle',),
'beføles': ('beføle',),
'befølte': ('beføle',),
'befølt': ('beføle',),
'beføl': ('beføle',),
'begeistre': ('begeistre',),
'begeistrer': ('begeistre',),
'begeistres': ('begeistre',),
'begeistra': ('begeistre',),
'begeistret': ('begeistre',),
'begeistra': ('begeistre',),
'begeistret': ('begeistre',),
'begeistr': ('begeistre',),
'begeistre': ('begeistre',),
'begeistr': ('begeistre',),
'begeistre': ('begeistre',),
'begi': ('begi',),
'begir': ('begi',),
'begis': ('begi',),
'begav': ('begi',),
'bega': ('begi',),
'begitt': ('begi',),
'begi': ('begi',),
'begjære': ('begjære',),
'begjærer': ('begjære',),
'begjæres': ('begjære',),
'begjærte': ('begjære',),
'begjært': ('begjære',),
'begjær': ('begjære',),
'beglo': ('beglo',),
'beglor': ('beglo',),
'beglos': ('beglo',),
'beglodde': ('beglo',),
'beglodd': ('beglo',),
'beglo': ('beglo',),
'begrave': ('begrave',),
'begraver': ('begrave',),
'begraves': ('begrave',),
'begravet': ('begrave',),
'begravde': ('begrave',),
'begrov': ('begrave',),
'begravet': ('begrave',),
'begravd': ('begrave',),
'begrav': ('begrave',),
'begrense': ('begrense',),
'begrenser': ('begrense',),
'begrenses': ('begrense',),
'begrensa': ('begrense',),
'begrenset': ('begrense',),
'begrensa': ('begrense',),
'begrenset': ('begrense',),
'begrens': ('begrense',),
'begrepsbestemme': ('begrepsbestemme',),
'begrepsbestemmer': ('begrepsbestemme',),
'begrepsbestemmes': ('begrepsbestemme',),
'begrepsbestemte': ('begrepsbestemme',),
'begrepsbestemt': ('begrepsbestemme',),
'begrepsbestem': ('begrepsbestemme',),
'begripe': ('begripe',),
'begriper': ('begripe',),
'begripes': ('begripe',),
'begrep': ('begripe',),
'begreip': ('begripe',),
'begrep': ('begripe',),
'begreip': ('begripe',),
'begrepet': ('begripe',),
'begrip': ('begripe',),
'begrunne': ('begrunne',),
'begrunner': ('begrunne',),
'begrunnes': ('begrunne',),
'begrunna': ('begrunne',),
'begrunnet': ('begrunne',),
'begrunna': ('begrunne',),
'begrunnet': ('begrunne',),
'begrunn': ('begrunne',),
'begunstige': ('begunstige',),
'begunstiger': ('begunstige',),
'begunstiges': ('begunstige',),
'begunstiga': ('begunstige',),
'begunstiget': ('begunstige',),
'begunstiga': ('begunstige',),
'begunstiget': ('begunstige',),
'begunstig': ('begunstige',),
'begynne': ('begynne',),
'begynner': ('begynne',),
'begynnes': ('begynne',),
'begynte': ('begynne',),
'begynt': ('begynne',),
'begynn': ('begynne',),
'begå': ('begå',),
'begår': ('begå',),
'begås': ('begå',),
'begikk': ('begå',),
'begått': ('begå',),
'begå': ('begå',),
'behage': ('behage',),
'behager': ('behage',),
'behages': ('behage',),
'behaga': ('behage',),
'behaget': ('behage',),
'behaga': ('behage',),
'behaget': ('behage',),
'behag': ('behage',),
'behandle': ('behandle',),
'behandler': ('behandle',),
'behandles': ('behandle',),
'behandla': ('behandle',),
'behandlet': ('behandle',),
'behandla': ('behandle',),
'behandlet': ('behandle',),
'behandl': ('behandle',),
'behandle': ('behandle',),
'behandl': ('behandle',),
'behandle': ('behandle',),
'behefte': ('behefte',),
'behefter': ('behefte',),
'beheftes': ('behefte',),
'behefta': ('behefte',),
'beheftet': ('behefte',),
'behefta': ('behefte',),
'beheftet': ('behefte',),
'beheft': ('behefte',),
'beherske': ('beherske',),
'behersker': ('beherske',),
'beherskes': ('beherske',),
'beherska': ('beherske',),
'behersket': ('beherske',),
'beherska': ('beherske',),
'behersket': ('beherske',),
'behersk': ('beherske',),
'beholde': ('beholde',),
'beholder': ('beholde',),
'beholdes': ('beholde',),
'beholdt': ('beholde',),
'behold': ('beholde',),
'behøve': ('behøve',),
'behøver': ('behøve',),
'behøves': ('behøve',),
'behøvde': ('behøve',),
'behøvd': ('behøve',),
'behøv': ('behøve',),
'beile': ('beile',),
'beiler': ('beile',),
'beiles': ('beile',),
'beila': ('beile',),
'beilet': ('beile',),
'beilte': ('beile',),
'beila': ('beile',),
'beilet': ('beile',),
'beilt': ('beile',),
'beil': ('beile',),
'beine': ('beine',),
'beiner': ('beine',),
'beines': ('beine',),
'beina': ('beine',),
'beinet': ('beine',),
'beina': ('beine',),
'beinet': ('beine',),
'bein': ('beine',),
'beinflyge': ('beinflyge',),
'beinflyger': ('beinflyge',),
'beinflyges': ('beinflyge',),
'beinfløy': ('beinflyge',),
'beinfløyet': ('beinflyge',),
'beinflyg': ('beinflyge',),
'beinke': ('beinke',),
'beinker': ('beinke',),
'beinkes': ('beinke',),
'beinka': ('beinke',),
'beinket': ('beinke',),
'beinka': ('beinke',),
'beinket': ('beinke',),
'beink': ('beinke',),
'beise': ('beise',),
'beiser': ('beise',),
'beises': ('beise',),
'beisa': ('beise',),
'beiset': ('beise',),
'beiste': ('beise',),
'beisa': ('beise',),
'beiset': ('beise',),
'beist': ('beise',),
'beis': ('beise',),
'beiskne': ('beiskne',),
'beiskner': ('beiskne',),
'beisknes': ('beiskne',),
'beiskna': ('beiskne',),
'beisknet': ('beiskne',),
'beiskna': ('beiskne',),
'beisknet': ('beiskne',),
'beiskn': ('beiskne',),
'beiskne': ('beiskne',),
'beiskn': ('beiskne',),
'beiskne': ('beiskne',),
'beite': ('beite',),
'beiter': ('beite',),
'beites': ('beite',),
'beita': ('beite',),
'beitet': ('beite',),
'beita': ('beite',),
'beitet': ('beite',),
'beit': ('beite',),
'bejae': ('bejae',),
'bejaer': ('bejae',),
'bejaes': ('bejae',),
'bejaa': ('bejae',),
'bejaet': ('bejae',),
'bejaa': ('bejae',),
'bejaet': ('bejae',),
'beja': ('bejae',),
'beke': ('beke',),
'beker': ('beke',),
'bekes': ('beke',),
'beka': ('beke',),
'beket': ('beke',),
'bekte': ('beke',),
'beka': ('beke',),
'beket': ('beke',),
'bekt': ('beke',),
'bek': ('beke',),
'bekjempe': ('bekjempe',),
'bekjemper': ('bekjempe',),
'bekjempes': ('bekjempe',),
'bekjempa': ('bekjempe',),
'bekjempet': ('bekjempe',),
'bekjempa': ('bekjempe',),
'bekjempet': ('bekjempe',),
'bekjemp': ('bekjempe',),
'bekjenne': ('bekjenne',),
'bekjenner': ('bekjenne',),
'bekjennes': ('bekjenne',),
'bekjente': ('bekjenne',),
'bekjent': ('bekjenne',),
'bekjenn': ('bekjenne',),
'bekjentgjøre': ('bekjentgjøre',),
'bekjentgjør': ('bekjentgjøre',),
'bekjentgjøres': ('bekjentgjøre',),
'bekjentgjorde': ('bekjentgjøre',),
'bekjentgjort': ('bekjentgjøre',),
'bekjentgjør': ('bekjentgjøre',),
'beklage': ('beklage',),
'beklager': ('beklage',),
'beklages': ('beklage',),
'beklaga': ('beklage',),
'beklaget': ('beklage',),
'beklagde': ('beklage',),
'beklaga': ('beklage',),
'beklaget': ('beklage',),
'beklagd': ('beklage',),
'beklag': ('beklage',),
'bekle': ('bekle',),
'bekler': ('bekle',),
'bekles': ('bekle',),
'bekledde': ('bekle',),
'bekledd': ('bekle',),
'bekle': ('bekle',),
'beklippe': ('beklippe',),
'beklipper': ('beklippe',),
'beklippes': ('beklippe',),
'beklippa': ('beklippe',),
'beklippet': ('beklippe',),
'beklipte': ('beklippe',),
'beklippa': ('beklippe',),
'beklippet': ('beklippe',),
'beklipt': ('beklippe',),
'beklipp': ('beklippe',),
'bekomme': ('bekomme',),
'bekommer': ('bekomme',),
'bekommes': ('bekomme',),
'bekom': ('bekomme',),
'bekommet': ('bekomme',),
'bekom': ('bekomme',),
'bekoste': ('bekoste',),
'bekoster': ('bekoste',),
'bekostes': ('bekoste',),
'bekosta': ('bekoste',),
'bekostet': ('bekoste',),
'bekosta': ('bekoste',),
'bekostet': ('bekoste',),
'bekost': ('bekoste',),
'bekranse': ('bekranse',),
'bekranser': ('bekranse',),
'bekranses': ('bekranse',),
'bekransa': ('bekranse',),
'bekranset': ('bekranse',),
'bekransa': ('bekranse',),
'bekranset': ('bekranse',),
'bekrans': ('bekranse',),
'bekrefte': ('bekrefte',),
'bekrefter': ('bekrefte',),
'bekreftes': ('bekrefte',),
'bekrefta': ('bekrefte',),
'bekreftet': ('bekrefte',),
'bekrefta': ('bekrefte',),
'bekreftet': ('bekrefte',),
'bekreft': ('bekrefte',),
'bekvemme': ('bekvemme',),
'bekvemmer': ('bekvemme',),
'bekvemmes': ('bekvemme',),
'bekvemma': ('bekvemme',),
'bekvemmet': ('bekvemme',),
'bekvemma': ('bekvemme',),
'bekvemmet': ('bekvemme',),
'bekvem': ('bekvemme',),
'bekymre': ('bekymre',),
'bekymrer': ('bekymre',),
'bekymres': ('bekymre',),
'bekymra': ('bekymre',),
'bekymret': ('bekymre',),
'bekymra': ('bekymre',),
'bekymret': ('bekymre',),
'bekymr': ('bekymre',),
'bekymre': ('bekymre',),
'bekymr': ('bekymre',),
'bekymre': ('bekymre',),
'belage': ('belage',),
'belager': ('belage',),
'belages': ('belage',),
'belaga': ('belage',),
'belaget': ('belage',),
'belagde': ('belage',),
'belaga': ('belage',),
'belaget': ('belage',),
'belagd': ('belage',),
'belag': ('belage',),
'belaste': ('belaste',),
'belaster': ('belaste',),
'belastes': ('belaste',),
'belasta': ('belaste',),
'belastet': ('belaste',),
'belasta': ('belaste',),
'belastet': ('belaste',),
'belast': ('belaste',),
'belegge': ('belegge',),
'belegger': ('belegge',),
'belegges': ('belegge',),
'bela': ('belegge',),
'belagt': ('belegge',),
'belegg': ('belegge',),
'beleire': ('beleire',),
'beleirer': ('beleire',),
'beleires': ('beleire',),
'beleira': ('beleire',),
'beleiret': ('beleire',),
'beleira': ('beleire',),
'beleiret': ('beleire',),
'beleir': ('beleire',),
'belemre': ('belemre',),
'belemrer': ('belemre',),
'belemres': ('belemre',),
'belemra': ('belemre',),
'belemret': ('belemre',),
'belemra': ('belemre',),
'belemret': ('belemre',),
'belemr': ('belemre',),
'belemre': ('belemre',),
'belemr': ('belemre',),
'belemre': ('belemre',),
'belesse': ('belesse',),
'belesser': ('belesse',),
'belesses': ('belesse',),
'belessa': ('belesse',),
'belesset': ('belesse',),
'beleste': ('belesse',),
'belessa': ('belesse',),
'belesset': ('belesse',),
'belest': ('belesse',),
'beless': ('belesse',),
'belje': ('belje',),
'beljer': ('belje',),
'beljes': ('belje',),
'belja': ('belje',),
'beljet': ('belje',),
'belja': ('belje',),
'beljet': ('belje',),
'belj': ('belje',),
'belme': ('belme',),
'belmer': ('belme',),
'belmes': ('belme',),
'belma': ('belme',),
'belmet': ('belme',),
'belma': ('belme',),
'belmet': ('belme',),
'belm': ('belme',),
'belyse': ('belyse',),
'belyser': ('belyse',),
'belyses': ('belyse',),
'belyste': ('belyse',),
'belyst': ('belyse',),
'belys': ('belyse',),
'belåne': ('belåne',),
'belåner': ('belåne',),
'belånes': ('belåne',),
'belånte': ('belåne',),
'belånt': ('belåne',),
'belån': ('belåne',),
'belære': ('belære',),
'belærer': ('belære',),
'belæres': ('belære',),
'belærte': ('belære',),
'belært': ('belære',),
'belær': ('belære',),
'belønne': ('belønne',),
'belønner': ('belønne',),
'belønnes': ('belønne',),
'belønna': ('belønne',),
'belønnet': ('belønne',),
'belønte': ('belønne',),
'belønna': ('belønne',),
'belønnet': ('belønne',),
'belønt': ('belønne',),
'belønn': ('belønne',),
'beløpe': ('beløpe',),
'beløper': ('beløpe',),
'beløpes': ('beløpe',),
'beløp': ('beløpe',),
'beløpt': ('beløpe',),
'beløpet': ('beløpe',),
'beløp': ('beløpe',),
'bemanne': ('bemanne',),
'bemanner': ('bemanne',),
'bemannes': ('bemanne',),
'bemanna': ('bemanne',),
'bemannet': ('bemanne',),
'bemanna': ('bemanne',),
'bemannet': ('bemanne',),
'bemann': ('bemanne',),
'bemektige': ('bemektige',),
'bemektiger': ('bemektige',),
'bemektiges': ('bemektige',),
'bemektiga': ('bemektige',),
'bemektiget': ('bemektige',),
'bemektiga': ('bemektige',),
'bemektiget': ('bemektige',),
'bemektig': ('bemektige',),
'bemerke': ('bemerke',),
'bemerker': ('bemerke',),
'bemerkes': ('bemerke',),
'bemerka': ('bemerke',),
'bemerket': ('bemerke',),
'bemerka': ('bemerke',),
'bemerket': ('bemerke',),
'bemerk': ('bemerke',),
'bemyndige': ('bemyndige',),
'bemyndiger': ('bemyndige',),
'bemyndiges': ('bemyndige',),
'bemyndiga': ('bemyndige',),
'bemyndiget': ('bemyndige',),
'bemyndiga': ('bemyndige',),
'bemyndiget': ('bemyndige',),
'bemyndig': ('bemyndige',),
'bemøye': ('bemøye',),
'bemøyer': ('bemøye',),
'bemøyes': ('bemøye',),
'bemøya': ('bemøye',),
'bemøyet': ('bemøye',),
'bemøyde': ('bemøye',),
'bemøya': ('bemøye',),
'bemøyet': ('bemøye',),
'bemøyd': ('bemøye',),
'bemøy': ('bemøye',),
'bende': ('bende',),
'bender': ('bende',),
'bendes': ('bende',),
'bendte': ('bende',),
'bendt': ('bende',),
'bend': ('bende',),
'bene': ('bene',),
'bener': ('bene',),
'benes': ('bene',),
'bena': ('bene',),
'benet': ('bene',),
'bena': ('bene',),
'benet': ('bene',),
'ben': ('bene',),
'benekte': ('benekte',),
'benekter': ('benekte',),
'benektes': ('benekte',),
'benekta': ('benekte',),
'benektet': ('benekte',),
'benekta': ('benekte',),
'benektet': ('benekte',),
'benekt': ('benekte',),
'benevne': ('benevne',),
'benevner': ('benevne',),
'benevnes': ('benevne',),
'benevnte': ('benevne',),
'benevnt': ('benevne',),
'benevn': ('benevne',),
'benke': ('benke',),
'benker': ('benke',),
'benkes': ('benke',),
'benka': ('benke',),
'benket': ('benke',),
'benka': ('benke',),
'benket': ('benke',),
'benk': ('benke',),
'benytte': ('benytte',),
'benytter': ('benytte',),
'benyttes': ('benytte',),
'benytta': ('benytte',),
'benyttet': ('benytte',),
'benytta': ('benytte',),
'benyttet': ('benytte',),
'benytt': ('benytte',),
'benåde': ('benåde',),
'benåder': ('benåde',),
'benådes': ('benåde',),
'benåda': ('benåde',),
'benådet': ('benåde',),
'benåda': ('benåde',),
'benådet': ('benåde',),
'benåd': ('benåde',),
'beordre': ('beordre',),
'beordrer': ('beordre',),
'beordres': ('beordre',),
'beordra': ('beordre',),
'beordret': ('beordre',),
'beordra': ('beordre',),
'beordret': ('beordre',),
'beordr': ('beordre',),
'beordre': ('beordre',),
'beordr': ('beordre',),
'beordre': ('beordre',),
'beplante': ('beplante',),
'beplanter': ('beplante',),
'beplantes': ('beplante',),
'beplanta': ('beplante',),
'beplantet': ('beplante',),
'beplanta': ('beplante',),
'beplantet': ('beplante',),
'beplant': ('beplante',),
'beramme': ('beramme',),
'berammer': ('beramme',),
'berammes': ('beramme',),
'beramma': ('beramme',),
'berammet': ('beramme',),
'beramma': ('beramme',),
'berammet': ('beramme',),
'beram': ('beramme',),
'berede': ('berede',),
'bereder': ('berede',),
'beredes': ('berede',),
'beredte': ('berede',),
'beredt': ('berede',),
'bered': ('berede',),
'beregne': ('beregne',),
'beregner': ('beregne',),
'beregnes': ('beregne',),
'beregna': ('beregne',),
'beregnet': ('beregne',),
'beregna': ('beregne',),
'beregnet': ('beregne',),
'beregn': ('beregne',),
'berette': ('berette',),
'beretter': ('berette',),
'berettes': ('berette',),
'beretta': ('berette',),
'berettet': ('berette',),
'beretta': ('berette',),
'berettet': ('berette',),
'berett': ('berette',),
'berettige': ('berettige',),
'berettiger': ('berettige',),
'berettiges': ('berettige',),
'berettiga': ('berettige',),
'berettiget': ('berettige',),
'berettiga': ('berettige',),
'berettiget': ('berettige',),
'berettig': ('berettige',),
'berge': ('berge',),
'berger': ('berge',),
'berges': ('berge',),
'berga': ('berge',),
'berget': ('berge',),
'berga': ('berge',),
'berget': ('berge',),
'berg': ('berge',),
'bergta': ('bergta',),
'bergtar': ('bergta',),
'bergtas': ('bergta',),
'bergtok': ('bergta',),
'bergtatt': ('bergta',),
'bergta': ('bergta',),
'berike': ('berike',),
'beriker': ('berike',),
'berikes': ('berike',),
'berika': ('berike',),
'beriket': ('berike',),
'berika': ('berike',),
'beriket': ('berike',),
'berik': ('berike',),
'beriktige': ('beriktige',),
'beriktiger': ('beriktige',),
'beriktiges': ('beriktige',),
'beriktiga': ('beriktige',),
'beriktiget': ('beriktige',),
'beriktiga': ('beriktige',),
'beriktiget': ('beriktige',),
'beriktig': ('beriktige',),
'bero': ('bero',),
'beror': ('bero',),
'beros': ('bero',),
'berodde': ('bero',),
'berodd': ('bero',),
'bero': ('bero',),
'berolige': ('berolige',),
'beroliger': ('berolige',),
'beroliges': ('berolige',),
'beroliga': ('berolige',),
'beroliget': ('berolige',),
'beroliga': ('berolige',),
'beroliget': ('berolige',),
'berolig': ('berolige',),
'berte': ('berte',),
'berter': ('berte',),
'bertes': ('berte',),
'berta': ('berte',),
'bertet': ('berte',),
'berta': ('berte',),
'bertet': ('berte',),
'bert': ('berte',),
'beruse': ('beruse',),
'beruser': ('beruse',),
'beruses': ('beruse',),
'berusa': ('beruse',),
'beruset': ('beruse',),
'beruste': ('beruse',),
'berusa': ('beruse',),
'beruset': ('beruse',),
'berust': ('beruse',),
'berus': ('beruse',),
'berømme': ('berømme',),
'berømmer': ('berømme',),
'berømmes': ('berømme',),
'berømma': ('berømme',),
'berømmet': ('berømme',),
'berømte': ('berømme',),
'berømma': ('berømme',),
'berømmet': ('berømme',),
'berømt': ('berømme',),
'berøm': ('berømme',),
'berøre': ('berøre',),
'berører': ('berøre',),
'berøres': ('berøre',),
'berørte': ('berøre',),
'berørt': ('berøre',),
'berør': ('berøre',),
'berøve': ('berøve',),
'berøver': ('berøve',),
'berøves': ('berøve',),
'berøva': ('berøve',),
'berøvet': ('berøve',),
'berøvde': ('berøve',),
'berøva': ('berøve',),
'berøvet': ('berøve',),
'berøvd': ('berøve',),
'berøv': ('berøve',),
'bese': ('bese',),
'beser': ('bese',),
'beses': ('bese',),
'besees': ('bese',),
'beså': ('bese',),
'besett': ('bese',),
'bese': ('bese',),
'besegle': ('besegle',),
'besegler': ('besegle',),
'besegles': ('besegle',),
'besegla': ('besegle',),
'beseglet': ('besegle',),
'besegla': ('besegle',),
'beseglet': ('besegle',),
'besegl': ('besegle',),
'besegle': ('besegle',),
'besegl': ('besegle',),
'besegle': ('besegle',),
'beseire': ('beseire',),
'beseirer': ('beseire',),
'beseires': ('beseire',),
'beseira': ('beseire',),
'beseiret': ('beseire',),
'beseira': ('beseire',),
'beseiret': ('beseire',),
'beseir': ('beseire',),
'besette': ('besette',),
'besetter': ('besette',),
'besettes': ('besette',),
'besatte': ('besette',),
'besatt': ('besette',),
'besett': ('besette',),
'besifre': ('besifre',),
'besifrer': ('besifre',),
'besifres': ('besifre',),
'besifra': ('besifre',),
'besifret': ('besifre',),
'besifra': ('besifre',),
'besifret': ('besifre',),
'besifr': ('besifre',),
'besifre': ('besifre',),
'besifr': ('besifre',),
'besifre': ('besifre',),
'besikte': ('besikte',),
'besikter': ('besikte',),
'besiktes': ('besikte',),
'besikta': ('besikte',),
'besiktet': ('besikte',),
'besikta': ('besikte',),
'besiktet': ('besikte',),
'besikt': ('besikte',),
'besiktige': ('besiktige',),
'besiktiger': ('besiktige',),
'besiktiges': ('besiktige',),
'besiktiga': ('besiktige',),
'besiktiget': ('besiktige',),
'besiktiga': ('besiktige',),
'besiktiget': ('besiktige',),
'besiktig': ('besiktige',),
'besinne': ('besinne',),
'besinner': ('besinne',),
'besinnes': ('besinne',),
'besinna': ('besinne',),
'besinnet': ('besinne',),
'besinna': ('besinne',),
'besinnet': ('besinne',),
'besinn': ('besinne',),
'besitte': ('besitte',),
'besitter': ('besitte',),
'besittes': ('besitte',),
'besatt': ('besitte',),
'besittet': ('besitte',),
'besitt': ('besitte',),
'besjele': ('besjele',),
'besjeler': ('besjele',),
'besjeles': ('besjele',),
'besjelte': ('besjele',),
'besjelt': ('besjele',),
'besjel': ('besjele',),
'beskadige': ('beskadige',),
'beskadiger': ('beskadige',),
'beskadiges': ('beskadige',),
'beskadiga': ('beskadige',),
'beskadiget': ('beskadige',),
'beskadiga': ('beskadige',),
'beskadiget': ('beskadige',),
'beskadig': ('beskadige',),
'beskatte': ('beskatte',),
'beskatter': ('beskatte',),
'beskattes': ('beskatte',),
'beskatta': ('beskatte',),
'beskattet': ('beskatte',),
'beskatta': ('beskatte',),
'beskattet': ('beskatte',),
'beskatt': ('beskatte',),
'beskikke': ('beskikke',),
'beskikker': ('beskikke',),
'beskikkes': ('beskikke',),
'beskikka': ('beskikke',),
'beskikket': ('beskikke',),
'beskikka': ('beskikke',),
'beskikket': ('beskikke',),
'beskikk': ('beskikke',),
'beskjeftige': ('beskjeftige',),
'beskjeftiger': ('beskjeftige',),
'beskjeftiges': ('beskjeftige',),
'beskjeftiga': ('beskjeftige',),
'beskjeftiget': ('beskjeftige',),
'beskjeftiga': ('beskjeftige',),
'beskjeftiget': ('beskjeftige',),
'beskjeftig': ('beskjeftige',),
'beskjære': ('beskjære',),
'beskjærer': ('beskjære',),
'beskjæres': ('beskjære',),
'beskar': ('beskjære',),
'beskåret': ('beskjære',),
'beskjær': ('beskjære',),
'beskne': ('beskne',),
'beskner': ('beskne',),
'besknes': ('beskne',),
'beskna': ('beskne',),
'besknet': ('beskne',),
'beskna': ('beskne',),
'besknet': ('beskne',),
'beskn': ('beskne',),
'beskne': ('beskne',),
'beskn': ('beskne',),
'beskne': ('beskne',),
'beskrive': ('beskrive',),
'beskriver': ('beskrive',),
'beskrives': ('beskrive',),
'beskrev': ('beskrive',),
'beskreiv': ('beskrive',),
'beskrev': ('beskrive',),
'beskreiv': ('beskrive',),
'beskrevet': ('beskrive',),
'beskriv': ('beskrive',),
'beskue': ('beskue',),
'beskuer': ('beskue',),
'beskues': ('beskue',),
'beskua': ('beskue',),
'beskuet': ('beskue',),
'beskua': ('beskue',),
'beskuet': ('beskue',),
'besku': ('beskue',),
'beskylde': ('beskylde',),
'beskylder': ('beskylde',),
'beskyldes': ('beskylde',),
'beskyldte': ('beskylde',),
'beskyldt': ('beskylde',),
'beskyld': ('beskylde',),
'beskyte': ('beskyte',),
'beskyter': ('beskyte',),
'beskytes': ('beskyte',),
'beskjøt': ('beskyte',),
'beskøyt': ('beskyte',),
'beskutt': ('beskyte',),
'beskyt': ('beskyte',),
'beskytte': ('beskytte',),
'beskytter': ('beskytte',),
'beskyttes': ('beskytte',),
'beskytta': ('beskytte',),
'beskyttet': ('beskytte',),
'beskytta': ('beskytte',),
'beskyttet': ('beskytte',),
'beskytt': ('beskytte',),
'beslaglegge': ('beslaglegge',),
'beslaglegger': ('beslaglegge',),
'beslaglegges': ('beslaglegge',),
'beslagla': ('beslaglegge',),
'beslaglagt': ('beslaglegge',),
'beslaglegg': ('beslaglegge',),
'beslutte': ('beslutte',),
'beslutter': ('beslutte',),
'besluttes': ('beslutte',),
'beslutta': ('beslutte',),
'besluttet': ('beslutte',),
'beslutta': ('beslutte',),
'besluttet': ('beslutte',),
'beslutt': ('beslutte',),
'beslå': ('beslå',),
'beslår': ('beslå',),
'beslås': ('beslå',),
'beslåes': ('beslå',),
'beslo': ('beslå',),
'beslått': ('beslå',),
'beslå': ('beslå',),
'besmitte': ('besmitte',),
'besmitter': ('besmitte',),
'besmittes': ('besmitte',),
'besmitta': ('besmitte',),
'besmittet': ('besmitte',),
'besmitta': ('besmitte',),
'besmittet': ('besmitte',),
'besmitt': ('besmitte',),
'besnakke': ('besnakke',),
'besnakker': ('besnakke',),
'besnakkes': ('besnakke',),
'besnakka': ('besnakke',),
'besnakket': ('besnakke',),
'besnakka': ('besnakke',),
'besnakket': ('besnakke',),
'besnakk': ('besnakke',),
'besnære': ('besnære',),
'besnærer': ('besnære',),
'besnæres': ('besnære',),
'besnæra': ('besnære',),
'besnæret': ('besnære',),
'besnærte': ('besnære',),
'besnæra': ('besnære',),
'besnæret': ('besnære',),
'besnært': ('besnære',),
'besnær': ('besnære',),
'bespise': ('bespise',),
'bespiser': ('bespise',),
'bespises': ('bespise',),
'bespiste': ('bespise',),
'bespist': ('bespise',),
'bespis': ('bespise',),
'bespotte': ('bespotte',),
'bespotter': ('bespotte',),
'bespottes': ('bespotte',),
'bespotta': ('bespotte',),
'bespottet': ('bespotte',),
'bespotta': ('bespotte',),
'bespottet': ('bespotte',),
'bespott': ('bespotte',),
'bestemme': ('bestemme',),
'bestemmer': ('bestemme',),
'bestemmes': ('bestemme',),
'bestemte': ('bestemme',),
'bestemt': ('bestemme',),
'bestem': ('bestemme',),
'bestige': ('bestige',),
'bestiger': ('bestige',),
'bestiges': ('bestige',),
'besteg': ('bestige',),
'besteig': ('bestige',),
'besteg': ('bestige',),
'besteig': ('bestige',),
'besteget': ('bestige',),
'bestig': ('bestige',),
'bestikke': ('bestikke',),
'bestikker': ('bestikke',),
'bestikkes': ('bestikke',),
'bestakk': ('bestikke',),
'bestukket': ('bestikke',),
'bestikk': ('bestikke',),
'bestille': ('bestille',),
'bestiller': ('bestille',),
'bestilles': ('bestille',),
'bestilte': ('bestille',),
'bestilt': ('bestille',),
'bestill': ('bestille',),
'bestjele': ('bestjele',),
'bestjeler': ('bestjele',),
'bestjeles': ('bestjele',),
'bestjal': ('bestjele',),
'bestjålet': ('bestjele',),
'bestjel': ('bestjele',),
'bestorme': ('bestorme',),
'bestormer': ('bestorme',),
'bestormes': ('bestorme',),
'bestorma': ('bestorme',),
'bestormet': ('bestorme',),
'bestorma': ('bestorme',),
'bestormet': ('bestorme',),
'bestorm': ('bestorme',),
'bestrebe': ('bestrebe',),
'bestreber': ('bestrebe',),
'bestrebes': ('bestrebe',),
'bestreba': ('bestrebe',),
'bestrebet': ('bestrebe',),
'bestreba': ('bestrebe',),
'bestrebet': ('bestrebe',),
'bestreb': ('bestrebe',),
'bestri': ('bestri',),
'bestrir': ('bestri',),
'bestris': ('bestri',),
'bestridde': ('bestri',),
'bestred': ('bestri',),
'bestrei': ('bestri',),
'bestridd': ('bestri',),
'bestridt': ('bestri',),
'bestri': ('bestri',),
'bestride': ('bestride',),
'bestrider': ('bestride',),
'bestrides': ('bestride',),
'bestridde': ('bestride',),
'bestred': ('bestride',),
'bestrei': ('bestride',),
'bestridd': ('bestride',),
'bestridt': ('bestride',),
'bestrid': ('bestride',),
'bestryke': ('bestryke',),
'bestryker': ('bestryke',),
'bestrykes': ('bestryke',),
'bestrøyk': ('bestryke',),
'bestrøk': ('bestryke',),
'bestrøket': ('bestryke',),
'bestryk': ('bestryke',),
'bestråle': ('bestråle',),
'bestråler': ('bestråle',),
'bestråles': ('bestråle',),
'bestrålte': ('bestråle',),
'bestrålt': ('bestråle',),
'bestrål': ('bestråle',),
'bestykke': ('bestykke',),
'bestykker': ('bestykke',),
'bestykkes': ('bestykke',),
'bestykka': ('bestykke',),
'bestykket': ('bestykke',),
'bestykka': ('bestykke',),
'bestykket': ('bestykke',),
'bestykk': ('bestykke',),
'bestyre': ('bestyre',),
'bestyrer': ('bestyre',),
'bestyres': ('bestyre',),
'bestyrte': ('bestyre',),
'bestyrt': ('bestyre',),
'bestyr': ('bestyre',),
'bestyrke': ('bestyrke',),
'bestyrker': ('bestyrke',),
'bestyrkes': ('bestyrke',),
'bestyrka': ('bestyrke',),
'bestyrket': ('bestyrke',),
'bestyrka': ('bestyrke',),
'bestyrket': ('bestyrke',),
'bestyrk': ('bestyrke',),
'bestå': ('bestå',),
'består': ('bestå',),
'bestås': ('bestå',),
'besto': ('bestå',),
'bestod': ('bestå',),
'bestått': ('bestå',),
'bestå': ('bestå',),
'bestøve': ('bestøve',),
'bestøver': ('bestøve',),
'bestøves': ('bestøve',),
'bestøva': ('bestøve',),
'bestøvet': ('bestøve',),
'bestøva': ('bestøve',),
'bestøvet': ('bestøve',),
'bestøv': ('bestøve',),
'besudle': ('besudle',),
'besudler': ('besudle',),
'besudles': ('besudle',),
'besudla': ('besudle',),
'besudlet': ('besudle',),
'besudla': ('besudle',),
'besudlet': ('besudle',),
'besudl': ('besudle',),
'besudle': ('besudle',),
'besudl': ('besudle',),
'besudle': ('besudle',),
'besvangre': ('besvangre',),
'besvangrer': ('besvangre',),
'besvangres': ('besvangre',),
'besvangra': ('besvangre',),
'besvangret': ('besvangre',),
'besvangra': ('besvangre',),
'besvangret': ('besvangre',),
'besvangr': ('besvangre',),
'besvangre': ('besvangre',),
'besvangr': ('besvangre',),
'besvangre': ('besvangre',),
'besvare': ('besvare',),
'besvarer': ('besvare',),
'besvares': ('besvare',),
'besvarte': ('besvare',),
'besvart': ('besvare',),
'besvar': ('besvare',),
'besverge': ('besverge',),
'besverger': ('besverge',),
'besverges': ('besverge',),
'besverga': ('besverge',),
'besverget': ('besverge',),
'besvor': ('besverge',),
'besverga': ('besverge',),
'besverget': ('besverge',),
'besvoret': ('besverge',),
'besverg': ('besverge',),
'besvime': ('besvime',),
'besvimer': ('besvime',),
'besvimes': ('besvime',),
'besvimte': ('besvime',),
'besvimt': ('besvime',),
'besvim': ('besvime',),
'besvære': ('besvære',),
'besværer': ('besvære',),
'besværes': ('besvære',),
'besværa': ('besvære',),
'besværet': ('besvære',),
'besværte': ('besvære',),
'besværa': ('besvære',),
'besværet': ('besvære',),
'besvært': ('besvære',),
'besvær': ('besvære',),
'besynge': ('besynge',),
'besynger': ('besynge',),
'besynges': ('besynge',),
'besang': ('besynge',),
'besunget': ('besynge',),
'besyng': ('besynge',),
'besøke': ('besøke',),
'besøker': ('besøke',),
'besøkes': ('besøke',),
'besøkte': ('besøke',),
'besøkt': ('besøke',),
'besøk': ('besøke',),
'besørge': ('besørge',),
'besørger': ('besørge',),
'besørges': ('besørge',),
'besørga': ('besørge',),
'besørget': ('besørge',),
'besørga': ('besørge',),
'besørget': ('besørge',),
'besørg': ('besørge',),
'beta': ('beta',),
'betar': ('beta',),
'betas': ('beta',),
'betok': ('beta',),
'betatt': ('beta',),
'beta': ('beta',),
'betakke': ('betakke',),
'betakker': ('betakke',),
'betakkes': ('betakke',),
'betakka': ('betakke',),
'betakket': ('betakke',),
'betakka': ('betakke',),
'betakket': ('betakke',),
'betakk': ('betakke',),
'betale': ('betale',),
'betaler': ('betale',),
'betales': ('betale',),
'betalte': ('betale',),
'betalt': ('betale',),
'betal': ('betale',),
'bete': ('bete',),
'beter': ('bete',),
'betes': ('bete',),
'betedde': ('bete',),
'betedd': ('bete',),
'bete': ('bete',),
'betegne': ('betegne',),
'betegner': ('betegne',),
'betegnes': ('betegne',),
'betegna': ('betegne',),
'betegnet': ('betegne',),
'betegna': ('betegne',),
'betegnet': ('betegne',),
'betegn': ('betegne',),
'betenke': ('betenke',),
'betenker': ('betenke',),
'betenkes': ('betenke',),
'betenkte': ('betenke',),
'betenkt': ('betenke',),
'betenk': ('betenke',),
'betinge': ('betinge',),
'betinger': ('betinge',),
'betinges': ('betinge',),
'betinga': ('betinge',),
'betinget': ('betinge',),
'betinga': ('betinge',),
'betinget': ('betinge',),
'beting': ('betinge',),
'betjene': ('betjene',),
'betjener': ('betjene',),
'betjenes': ('betjene',),
'betjente': ('betjene',),
'betjent': ('betjene',),
'betjen': ('betjene',),
'betle': ('betle',),
'betler': ('betle',),
'betles': ('betle',),
'betla': ('betle',),
'betlet': ('betle',),
'betla': ('betle',),
'betlet': ('betle',),
'betl': ('betle',),
'betle': ('betle',),
'betl': ('betle',),
'betle': ('betle',),
'betone': ('betone',),
'betoner': ('betone',),
'betones': ('betone',),
'betona': ('betone',),
'betonet': ('betone',),
'betonte': ('betone',),
'betona': ('betone',),
'betonet': ('betone',),
'betont': ('betone',),
'beton': ('betone',),
'betrakte': ('betrakte',),
'betrakter': ('betrakte',),
'betraktes': ('betrakte',),
'betrakta': ('betrakte',),
'betraktet': ('betrakte',),
'betrakta': ('betrakte',),
'betraktet': ('betrakte',),
'betrakt': ('betrakte',),
'betre': ('betre',),
'betrer': ('betre',),
'betres': ('betre',),
'betrådte': ('betre',),
'betrådt': ('betre',),
'betre': ('betre',),
'betrede': ('betrede',),
'betreder': ('betrede',),
'betredes': ('betrede',),
'betrådte': ('betrede',),
'betrådt': ('betrede',),
'betred': ('betrede',),
'betro': ('betro',),
'betror': ('betro',),
'betros': ('betro',),
'betrodde': ('betro',),
'betrodd': ('betro',),
'betro': ('betro',),
'betvile': ('betvile',),
'betviler': ('betvile',),
'betviles': ('betvile',),
'betvilte': ('betvile',),
'betvilt': ('betvile',),
'betvil': ('betvile',),
'betvinge': ('betvinge',),
'betvinger': ('betvinge',),
'betvinges': ('betvinge',),
'betvang': ('betvinge',),
'betvunget': ('betvinge',),
'betving': ('betvinge',),
'betød': ('bety',),
'bety': ('bety',),
'betyr': ('bety',),
'betys': ('bety',),
'betydde': ('bety',),
'betød': ('bety',),
'betydd': ('bety',),
'bety': ('bety',),
'beundre': ('beundre',),
'beundrer': ('beundre',),
'beundres': ('beundre',),
'beundra': ('beundre',),
'beundret': ('beundre',),
'beundra': ('beundre',),
'beundret': ('beundre',),
'beundr': ('beundre',),
'beundre': ('beundre',),
'beundr': ('beundre',),
'beundre': ('beundre',),
'bevare': ('bevare',),
'bevarer': ('bevare',),
'bevares': ('bevare',),
'bevarte': ('bevare',),
'bevart': ('bevare',),
'bevar': ('bevare',),
'beve': ('beve',),
'bever': ('beve',),
'beves': ('beve',),
'beva': ('beve',),
'bevet': ('beve',),
'bevde': ('beve',),
'beva': ('beve',),
'bevet': ('beve',),
'bevd': ('beve',),
'bev': ('beve',),
'bevege': ('bevege',),
'beveger': ('bevege',),
'beveges': ('bevege',),
'bevega': ('bevege',),
'beveget': ('bevege',),
'bevegde': ('bevege',),
'bevega': ('bevege',),
'beveget': ('bevege',),
'bevegd': ('bevege',),
'beveg': ('bevege',),
'beverte': ('beverte',),
'beverter': ('beverte',),
'bevertes': ('beverte',),
'beverta': ('beverte',),
'bevertet': ('beverte',),
'beverta': ('beverte',),
'bevertet': ('beverte',),
'bevert': ('beverte',),
'bevilge': ('bevilge',),
'bevilger': ('bevilge',),
'bevilges': ('bevilge',),
'bevilga': ('bevilge',),
'bevilget': ('bevilge',),
'bevilga': ('bevilge',),
'bevilget': ('bevilge',),
'bevilg': ('bevilge',),
'bevirke': ('bevirke',),
'bevirker': ('bevirke',),
'bevirkes': ('bevirke',),
'bevirka': ('bevirke',),
'bevirket': ('bevirke',),
'bevirka': ('bevirke',),
'bevirket': ('bevirke',),
'bevirk': ('bevirke',),
'bevise': ('bevise',),
'beviser': ('bevise',),
'bevises': ('bevise',),
'beviste': ('bevise',),
'bevist': ('bevise',),
'bevis': ('bevise',),
'bevisstgjøre': ('bevisstgjøre',),
'bevisstgjør': ('bevisstgjøre',),
'bevisstgjøres': ('bevisstgjøre',),
'bevisstgjorde': ('bevisstgjøre',),
'bevisstgjort': ('bevisstgjøre',),
'bevisstgjør': ('bevisstgjøre',),
'bevitne': ('bevitne',),
'bevitner': ('bevitne',),
'bevitnes': ('bevitne',),
'bevitna': ('bevitne',),
'bevitnet': ('bevitne',),
'bevitna': ('bevitne',),
'bevitnet': ('bevitne',),
'bevitn': ('bevitne',),
'bevitne': ('bevitne',),
'bevitn': ('bevitne',),
'bevitne': ('bevitne',),
'bevokte': ('bevokte',),
'bevokter': ('bevokte',),
'bevoktes': ('bevokte',),
'bevokta': ('bevokte',),
'bevoktet': ('bevokte',),
'bevokta': ('bevokte',),
'bevoktet': ('bevokte',),
'bevokt': ('bevokte',),
'bevre': ('bevre',),
'bevrer': ('bevre',),
'bevres': ('bevre',),
'bevra': ('bevre',),
'bevret': ('bevre',),
'bevra': ('bevre',),
'bevret': ('bevre',),
'bevr': ('bevre',),
'bevre': ('bevre',),
'bevr': ('bevre',),
'bevre': ('bevre',),
'bevæpne': ('bevæpne',),
'bevæpner': ('bevæpne',),
'bevæpnes': ('bevæpne',),
'bevæpna': ('bevæpne',),
'bevæpnet': ('bevæpne',),
'bevæpna': ('bevæpne',),
'bevæpnet': ('bevæpne',),
'bevæpn': ('bevæpne',),
'bevæpne': ('bevæpne',),
'bevæpn': ('bevæpne',),
'bevæpne': ('bevæpne',),
'beånde': ('beånde',),
'beånder': ('beånde',),
'beåndes': ('beånde',),
'beånda': ('beånde',),
'beåndet': ('beånde',),
'beånda': ('beånde',),
'beåndet': ('beånde',),
'beånd': ('beånde',),
'beære': ('beære',),
'beærer': ('beære',),
'beæres': ('beære',),
'beæra': ('beære',),
'beæret': ('beære',),
'beæra': ('beære',),
'beæret': ('beære',),
'beær': ('beære',),
'bibeholde': ('bibeholde',),
'bibeholder': ('bibeholde',),
'bibeholdes': ('bibeholde',),
'bibeholdt': ('bibeholde',),
'bibehold': ('bibeholde',),
'bibringe': ('bibringe',),
'bibringer': ('bibringe',),
'bibringes': ('bibringe',),
'bibrakte': ('bibringe',),
'bibrakt': ('bibringe',),
'bibring': ('bibringe',),
'bidra': ('bidra',),
'bidrar': ('bidra',),
'bidras': ('bidra',),
'bidrog': ('bidra',),
'bidro': ('bidra',),
'bidradd': ('bidra',),
'bidratt': ('bidra',),
'bidradd': ('bidra',),
'bidratt': ('bidra',),
'bidra': ('bidra',),
'bie': ('bie',),
'bier': ('bie',),
'bies': ('bie',),
'bia': ('bie',),
'biet': ('bie',),
'bidde': ('bie',),
'bia': ('bie',),
'biet': ('bie',),
'bidd': ('bie',),
'bi': ('bie',),
'bifalle': ('bifalle',),
'bifaller': ('bifalle',),
'bifalles': ('bifalle',),
'bifalt': ('bifalle',),
'bifall': ('bifalle',),
'bikke': ('bikke',),
'bikker': ('bikke',),
'bikkes': ('bikke',),
'bikka': ('bikke',),
'bikket': ('bikke',),
'bikka': ('bikke',),
'bikket': ('bikke',),
'bikk': ('bikke',),
'bikte': ('bikte',),
'bikter': ('bikte',),
'biktes': ('bikte',),
'bikta': ('bikte',),
'biktet': ('bikte',),
'bikta': ('bikte',),
'biktet': ('bikte',),
'bikt': ('bikte',),
'bile': ('bile',),
'biler': ('bile',),
'biles': ('bile',),
'bilte': ('bile',),
'bilt': ('bile',),
'bil': ('bile',),
'bilegge': ('bilegge',),
'bilegger': ('bilegge',),
'bilegges': ('bilegge',),
'bila': ('bilegge',),
'bilagt': ('bilegge',),
'bilegg': ('bilegge',),
'billettere': ('billettere',),
'billetterer': ('billettere',),
'billetteres': ('billettere',),
'billetterte': ('billettere',),
'billettert': ('billettere',),
'billetter': ('billettere',),
'billige': ('billige',),
'billiger': ('billige',),
'billiges': ('billige',),
'billiga': ('billige',),
'billiget': ('billige',),
'billiga': ('billige',),
'billiget': ('billige',),
'billig': ('billige',),
'binde': ('binde',),
'binder': ('binde',),
'bindes': ('binde',),
'bandt': ('binde',),
'bundet': ('binde',),
'bind': ('binde',),
'bisette': ('bisette',),
'bisetter': ('bisette',),
'bisettes': ('bisette',),
'bisatte': ('bisette',),
'bisatt': ('bisette',),
'bisett': ('bisette',),
'bistå': ('bistå',),
'bistår': ('bistå',),
'bistås': ('bistå',),
'bisto': ('bistå',),
'bistod': ('bistå',),
'bistått': ('bistå',),
'bistå': ('bistå',),
'bite': ('bite',),
'biter': ('bite',),
'bites': ('bite',),
'beit': ('bite',),
'bet': ('bite',),
'bitt': ('bite',),
'bit': ('bite',),
'bivuakkere': ('bivuakkere',),
'bivuakkerer': ('bivuakkere',),
'bivuakkeres': ('bivuakkere',),
'bivuakkerte': ('bivuakkere',),
'bivuakkert': ('bivuakkere',),
'bivuakker': ('bivuakkere',),
'bivåne': ('bivåne',),
'bivåner': ('bivåne',),
'bivånes': ('bivåne',),
'bivåna': ('bivåne',),
'bivånet': ('bivåne',),
'bivånte': ('bivåne',),
'bivåna': ('bivåne',),
'bivånet': ('bivåne',),
'bivånt': ('bivåne',),
'bivån': ('bivåne',),
'bjeffe': ('bjeffe',),
'bjeffer': ('bjeffe',),
'bjeffes': ('bjeffe',),
'bjeffa': ('bjeffe',),
'bjeffet': ('bjeffe',),
'bjeffa': ('bjeffe',),
'bjeffet': ('bjeffe',),
'bjeff': ('bjeffe',),
'bla': ('bla',),
'blar': ('bla',),
'blas': ('bla',),
'bladde': ('bla',),
'bladd': ('bla',),
'bla': ('bla',),
'blaffe': ('blaffe',),
'blaffer': ('blaffe',),
'blaffes': ('blaffe',),
'blaffa': ('blaffe',),
'blaffet': ('blaffe',),
'blaffa': ('blaffe',),
'blaffet': ('blaffe',),
'blaff': ('blaffe',),
'blafre': ('blafre',),
'blafrer': ('blafre',),
'blafres': ('blafre',),
'blafra': ('blafre',),
'blafret': ('blafre',),
'blafra': ('blafre',),
'blafret': ('blafre',),
'blafr': ('blafre',),
'blafre': ('blafre',),
'blafr': ('blafre',),
'blafre': ('blafre',),
'blakke': ('blakke',),
'blakker': ('blakke',),
'blakkes': ('blakke',),
'blakka': ('blakke',),
'blakket': ('blakke',),
'blakka': ('blakke',),
'blakket': ('blakke',),
'blakk': ('blakke',),
'blakne': ('blakne',),
'blakner': ('blakne',),
'blaknes': ('blakne',),
'blakna': ('blakne',),
'blaknet': ('blakne',),
'blakna': ('blakne',),
'blaknet': ('blakne',),
'blakn': ('blakne',),
'blakne': ('blakne',),
'blakn': ('blakne',),
'blakne': ('blakne',),
'blakre': ('blakre',),
'blakrer': ('blakre',),
'blakres': ('blakre',),
'blakra': ('blakre',),
'blakret': ('blakre',),
'blakra': ('blakre',),
'blakret': ('blakre',),
'blakr': ('blakre',),
'blakre': ('blakre',),
'blakr': ('blakre',),
'blakre': ('blakre',),
'blamere': ('blamere',),
'blamerer': ('blamere',),
'blameres': ('blamere',),
'blamerte': ('blamere',),
'blamert': ('blamere',),
'blamer': ('blamere',),
'blande': ('blande',),
'blander': ('blande',),
'blandes': ('blande',),
'blanda': ('blande',),
'blandet': ('blande',),
'blanda': ('blande',),
'blandet': ('blande',),
'bland': ('blande',),
'blanke': ('blanke',),
'blanker': ('blanke',),
'blankes': ('blanke',),
'blanka': ('blanke',),
'blanket': ('blanke',),
'blanka': ('blanke',),
'blanket': ('blanke',),
'blank': ('blanke',),
'blankpusse': ('blankpusse',),
'blankpusser': ('blankpusse',),
'blankpusses': ('blankpusse',),
'blankpussa': ('blankpusse',),
'blankpusset': ('blankpusse',),
'blankpussa': ('blankpusse',),
'blankpusset': ('blankpusse',),
'blankpuss': ('blankpusse',),
'blankslite': ('blankslite',),
'blanksliter': ('blankslite',),
'blankslites': ('blankslite',),
'blanksleit': ('blankslite',),
'blankslet': ('blankslite',),
'blankslitt': ('blankslite',),
'blankslit': ('blankslite',),
'blasonere': ('blasonere',),
'blasonerer': ('blasonere',),
'blasoneres': ('blasonere',),
'blasonerte': ('blasonere',),
'blasonert': ('blasonere',),
'blasoner': ('blasonere',),
'blautgjøre': ('blautgjøre',),
'blautgjør': ('blautgjøre',),
'blautgjøres': ('blautgjøre',),
'blautgjorde': ('blautgjøre',),
'blautgjort': ('blautgjøre',),
'blautgjør': ('blautgjøre',),
'blautkoke': ('blautkoke',),
'blautkoker': ('blautkoke',),
'blautkokes': ('blautkoke',),
'blautkokte': ('blautkoke',),
'blautkokt': ('blautkoke',),
'blautkok': ('blautkoke',),
'bleige': ('bleige',),
'bleiger': ('bleige',),
'bleiges': ('bleige',),
'bleigde': ('bleige',),
'bleigd': ('bleige',),
'bleig': ('bleige',),
'bleike': ('bleike',),
'bleiker': ('bleike',),
'bleikes': ('bleike',),
'bleika': ('bleike',),
'bleiket': ('bleike',),
'bleikte': ('bleike',),
'bleika': ('bleike',),
'bleiket': ('bleike',),
'bleikt': ('bleike',),
'bleik': ('bleike',),
'bleikne': ('bleikne',),
'bleikner': ('bleikne',),
'bleiknes': ('bleikne',),
'bleikna': ('bleikne',),
'bleiknet': ('bleikne',),
'bleikna': ('bleikne',),
'bleiknet': ('bleikne',),
'bleikn': ('bleikne',),
'bleikne': ('bleikne',),
'bleikn': ('bleikne',),
'bleikne': ('bleikne',),
'bleke': ('bleke',),
'bleker': ('bleke',),
'blekes': ('bleke',),
'bleka': ('bleke',),
'bleket': ('bleke',),
'blekte': ('bleke',),
'bleka': ('bleke',),
'bleket': ('bleke',),
'blekt': ('bleke',),
'blek': ('bleke',),
'blekke': ('blekke',),
'blekker': ('blekke',),
'blekkes': ('blekke',),
'blekka': ('blekke',),
'blekket': ('blekke',),
'blekka': ('blekke',),
'blekket': ('blekke',),
'blek': ('blekke',),
'blekke': ('blekke',),
'blekker': ('blekke',),
'blekkes': ('blekke',),
'blekte': ('blekke',),
'blekt': ('blekke',),
'blekk': ('blekke',),
'blekne': ('blekne',),
'blekner': ('blekne',),
'bleknes': ('blekne',),
'blekna': ('blekne',),
'bleknet': ('blekne',),
'blekna': ('blekne',),
'bleknet': ('blekne',),
'blekn': ('blekne',),
'blekne': ('blekne',),
'blekn': ('blekne',),
'blekne': ('blekne',),
'blende': ('blende',),
'blender': ('blende',),
'blendes': ('blende',),
'blenda': ('blende',),
'blendet': ('blende',),
'blenda': ('blende',),
'blendet': ('blende',),
'blend': ('blende',),
'bli': ('bli',),
'blir': ('bli',),
'blis': ('bli',),
'ble': ('bli',),
'blei': ('bli',),
'blitt': ('bli',),
'bli': ('bli',),
'bli': ('bli',),
'blir': ('bli',),
'blis': ('bli',),
'blev': ('bli',),
'bleiv': ('bli',),
'blitt': ('bli',),
'bli': ('bli',),
'blidgjøre': ('blidgjøre',),
'blidgjør': ('blidgjøre',),
'blidgjøres': ('blidgjøre',),
'blidgjorde': ('blidgjøre',),
'blidgjort': ('blidgjøre',),
'blidgjør': ('blidgjøre',),
'blinde': ('blinde',),
'blinder': ('blinde',),
'blindes': ('blinde',),
'blinda': ('blinde',),
'blindet': ('blinde',),
'blinda': ('blinde',),
'blindet': ('blinde',),
'blind': ('blinde',),
'blingse': ('blingse',),
'blingser': ('blingse',),
'blingses': ('blingse',),
'blingsa': ('blingse',),
'blingset': ('blingse',),
'blingsa': ('blingse',),
'blingset': ('blingse',),
'blings': ('blingse',),
'blinke': ('blinke',),
'blinker': ('blinke',),
'blinkes': ('blinke',),
'blinka': ('blinke',),
'blinket': ('blinke',),
'blinka': ('blinke',),
'blinket': ('blinke',),
'blink': ('blinke',),
'blitse': ('blitse',),
'blitser': ('blitse',),
'blitses': ('blitse',),
'blitsa': ('blitse',),
'blitset': ('blitse',),
'blitsa': ('blitse',),
'blitset': ('blitse',),
'blits': ('blitse',),
'blive': ('blive',),
'bliver': ('blive',),
'blives': ('blive',),
'blev': ('blive',),
'bleiv': ('blive',),
'blitt': ('blive',),
'bliv': ('blive',),
'blogge': ('blogge',),
'blogger': ('blogge',),
'blogges': ('blogge',),
'blogga': ('blogge',),
'blogget': ('blogge',),
'blogga': ('blogge',),
'blogget': ('blogge',),
'blogg': ('blogge',),
'blokke': ('blokke',),
'blokker': ('blokke',),
'blokkes': ('blokke',),
'blokka': ('blokke',),
'blokket': ('blokke',),
'blokka': ('blokke',),
'blokket': ('blokke',),
'blokk': ('blokke',),
'blokkere': ('blokkere',),
'blokkerer': ('blokkere',),
'blokkeres': ('blokkere',),
'blokkerte': ('blokkere',),
'blokkert': ('blokkere',),
'blokker': ('blokkere',),
'blomstre': ('blomstre',),
'blomstrer': ('blomstre',),
'blomstres': ('blomstre',),
'blomstra': ('blomstre',),
'blomstret': ('blomstre',),
'blomstra': ('blomstre',),
'blomstret': ('blomstre',),
'blomstr': ('blomstre',),
'blomstre': ('blomstre',),
'blomstr': ('blomstre',),
'blomstre': ('blomstre',),
'blote': ('blote',),
'bloter': ('blote',),
'blotes': ('blote',),
'blota': ('blote',),
'blotet': ('blote',),
'blota': ('blote',),
'blotet': ('blote',),
'blot': ('blote',),
'blotte': ('blotte',),
'blotter': ('blotte',),
'blottes': ('blotte',),
'blotta': ('blotte',),
'blottet': ('blotte',),
'blotta': ('blotte',),
'blottet': ('blotte',),
'blott': ('blotte',),
'blottlegge': ('blottlegge',),
'blottlegger': ('blottlegge',),
'blottlegges': ('blottlegge',),
'blottla': ('blottlegge',),
'blottlagt': ('blottlegge',),
'blottlegg': ('blottlegge',),
'blottstille': ('blottstille',),
'blottstiller': ('blottstille',),
'blottstilles': ('blottstille',),
'blottstilte': ('blottstille',),
'blottstilt': ('blottstille',),
'blottstill': ('blottstille',),
'blues': ('blues',),
'bluedes': ('blues',),
'blues': ('blues',),
'blunde': ('blunde',),
'blunder': ('blunde',),
'blundes': ('blunde',),
'blunda': ('blunde',),
'blundet': ('blunde',),
'blunda': ('blunde',),
'blundet': ('blunde',),
'blund': ('blunde',),
'blunke': ('blunke',),
'blunker': ('blunke',),
'blunkes': ('blunke',),
'blunka': ('blunke',),
'blunket': ('blunke',),
'blunka': ('blunke',),
'blunket': ('blunke',),
'blunk': ('blunke',),
'blusse': ('blusse',),
'blusser': ('blusse',),
'blusses': ('blusse',),
'blussa': ('blusse',),
'blusset': ('blusse',),
'blussa': ('blusse',),
'blusset': ('blusse',),
'bluss': ('blusse',),
'blyges': ('blyges',),
'blygdes': ('blyges',),
'blyges': ('blyges',),
'blåholde': ('blåholde',),
'blåholder': ('blåholde',),
'blåholdes': ('blåholde',),
'blåholdt': ('blåholde',),
'blåhold': ('blåholde',),
'blåne': ('blåne',),
'blåner': ('blåne',),
'blånes': ('blåne',),
'blåna': ('blåne',),
'blånet': ('blåne',),
'blåna': ('blåne',),
'blånet': ('blåne',),
'blån': ('blåne',),
'blånekte': ('blånekte',),
'blånekter': ('blånekte',),
'blånektes': ('blånekte',),
'blånekta': ('blånekte',),
'blånektet': ('blånekte',),
'blånekta': ('blånekte',),
'blånektet': ('blånekte',),
'blånekt': ('blånekte',),
'blåse': ('blåse',),
'blåser': ('blåse',),
'blåses': ('blåse',),
'blåste': ('blåse',),
'blåst': ('blåse',),
'blås': ('blåse',),
'blære': ('blære',),
'blærer': ('blære',),
'blæres': ('blære',),
'blæra': ('blære',),
'blæret': ('blære',),
'blæra': ('blære',),
'blæret': ('blære',),
'blær': ('blære',),
'blø': ('blø',),
'blør': ('blø',),
'bløs': ('blø',),
'blødde': ('blø',),
'blødd': ('blø',),
'blø': ('blø',),
'bløffe': ('bløffe',),
'bløffer': ('bløffe',),
'bløffes': ('bløffe',),
'bløffa': ('bløffe',),
'bløffet': ('bløffe',),
'bløffa': ('bløffe',),
'bløffet': ('bløffe',),
'bløff': ('bløffe',),
'bløgge': ('bløgge',),
'bløgger': ('bløgge',),
'bløgges': ('bløgge',),
'bløgga': ('bløgge',),
'bløgget': ('bløgge',),
'bløgga': ('bløgge',),
'bløgget': ('bløgge',),
'bløgg': ('bløgge',),
'bløte': ('bløte',),
'bløter': ('bløte',),
'bløtes': ('bløte',),
'bløtte': ('bløte',),
'bløtt': ('bløte',),
'bløt': ('bløte',),
'bløtgjøre': ('bløtgjøre',),
'bløtgjør': ('bløtgjøre',),
'bløtgjøres': ('bløtgjøre',),
'bløtgjorde': ('bløtgjøre',),
'bløtgjort': ('bløtgjøre',),
'bløtgjør': ('bløtgjøre',),
'bløtkoke': ('bløtkoke',),
'bløtkoker': ('bløtkoke',),
'bløtkokes': ('bløtkoke',),
'bløtkokte': ('bløtkoke',),
'bløtkokt': ('bløtkoke',),
'bløtkok': ('bløtkoke',),
'bløtlegge': ('bløtlegge',),
'bløtlegger': ('bløtlegge',),
'bløtlegges': ('bløtlegge',),
'bløtla': ('bløtlegge',),
'bløtlagt': ('bløtlegge',),
'bløtlegg': ('bløtlegge',),
'bløyte': ('bløyte',),
'bløyter': ('bløyte',),
'bløytes': ('bløyte',),
'bløytte': ('bløyte',),
'bløtte': ('bløyte',),
'bløytt': ('bløyte',),
'bløtt': ('bløyte',),
'bløyt': ('bløyte',),
'bløytlegge': ('bløytlegge',),
'bløytlegger': ('bløytlegge',),
'bløytlegges': ('bløytlegge',),
'bløytla': ('bløytlegge',),
'bløytlagt': ('bløytlegge',),
'bløytlegg': ('bløytlegge',),
'bo': ('bo',),
'bor': ('bo',),
'bos': ('bo',),
'bodde': ('bo',),
'bodd': ('bo',),
'bo': ('bo',),
'boble': ('boble',),
'bobler': ('boble',),
'bobles': ('boble',),
'bobla': ('boble',),
'boblet': ('boble',),
'bobla': ('boble',),
'boblet': ('boble',),
'bobl': ('boble',),
'boble': ('boble',),
'bobl': ('boble',),
'boble': ('boble',),
'boge': ('boge',),
'boger': ('boge',),
'boges': ('boge',),
'boga': ('boge',),
'boget': ('boge',),
'boga': ('boge',),
'boget': ('boge',),
'bog': ('boge',),
'bogne': ('bogne',),
'bogner': ('bogne',),
'bognes': ('bogne',),
'bogna': ('bogne',),
'bognet': ('bogne',),
'bogna': ('bogne',),
'bognet': ('bogne',),
'bogn': ('bogne',),
'boikotte': ('boikotte',),
'boikotter': ('boikotte',),
'boikottes': ('boikotte',),
'boikotta': ('boikotte',),
'boikottet': ('boikotte',),
'boikotta': ('boikotte',),
'boikottet': ('boikotte',),
'boikott': ('boikotte',),
'bokføre': ('bokføre',),
'bokfører': ('bokføre',),
'bokføres': ('bokføre',),
'bokførte': ('bokføre',),
'bokført': ('bokføre',),
'bokfør': ('bokføre',),
'bokne': ('bokne',),
'bokner': ('bokne',),
'boknes': ('bokne',),
'bokna': ('bokne',),
'boknet': ('bokne',),
'bokna': ('bokne',),
'boknet': ('bokne',),
'bokn': ('bokne',),
'bokne': ('bokne',),
'bokn': ('bokne',),
'bokne': ('bokne',),
'bokse': ('bokse',),
'bokser': ('bokse',),
'bokses': ('bokse',),
'boksa': ('bokse',),
'bokset': ('bokse',),
'boksa': ('bokse',),
'bokset': ('bokse',),
'boks': ('bokse',),
'bokstavere': ('bokstavere',),
'bokstaverer': ('bokstavere',),
'bokstaveres': ('bokstavere',),
'bokstaverte': ('bokstavere',),
'bokstavert': ('bokstavere',),
'bokstaver': ('bokstavere',),
'bole': ('bole',),
'boler': ('bole',),
'boles': ('bole',),
'bola': ('bole',),
'bolet': ('bole',),
'bolte': ('bole',),
'bola': ('bole',),
'bolet': ('bole',),
'bolt': ('bole',),
'bol': ('bole',),
'bolne': ('bolne',),
'bolner': ('bolne',),
'bolnes': ('bolne',),
'bolna': ('bolne',),
'bolnet': ('bolne',),
'bolna': ('bolne',),
'bolnet': ('bolne',),
'boln': ('bolne',),
'bolne': ('bolne',),
'boln': ('bolne',),
'bolne': ('bolne',),
'bolte': ('bolte',),
'bolter': ('bolte',),
'boltes': ('bolte',),
'bolta': ('bolte',),
'boltet': ('bolte',),
'bolta': ('bolte',),
'boltet': ('bolte',),
'bolt': ('bolte',),
'boltre': ('boltre',),
'boltrer': ('boltre',),
'boltres': ('boltre',),
'boltra': ('boltre',),
'boltret': ('boltre',),
'boltra': ('boltre',),
'boltret': ('boltre',),
'boltr': ('boltre',),
'boltre': ('boltre',),
'boltr': ('boltre',),
'boltre': ('boltre',),
'bombardere': ('bombardere',),
'bombarderer': ('bombardere',),
'bombarderes': ('bombardere',),
'bombarderte': ('bombardere',),
'bombardert': ('bombardere',),
'bombarder': ('bombardere',),
'bombe': ('bombe',),
'bomber': ('bombe',),
'bombes': ('bombe',),
'bomba': ('bombe',),
'bombet': ('bombe',),
'bomba': ('bombe',),
'bombet': ('bombe',),
'bomb': ('bombe',),
'bomme': ('bomme',),
'bommer': ('bomme',),
'bommes': ('bomme',),
'bomma': ('bomme',),
'bommet': ('bomme',),
'bomma': ('bomme',),
'bommet': ('bomme',),
'bom': ('bomme',),
'bone': ('bone',),
'boner': ('bone',),
'bones': ('bone',),
'bona': ('bone',),
'bonet': ('bone',),
'bonte': ('bone',),
'bona': ('bone',),
'bonet': ('bone',),
'bont': ('bone',),
'bon': ('bone',),
'bonge': ('bonge',),
'bonger': ('bonge',),
'bonges': ('bonge',),
'bonga': ('bonge',),
'bonget': ('bonge',),
'bonga': ('bonge',),
'bonget': ('bonge',),
'bong': ('bonge',),
'bonitere': ('bonitere',),
'boniterer': ('bonitere',),
'boniteres': ('bonitere',),
'boniterte': ('bonitere',),
'bonitert': ('bonitere',),
'boniter': ('bonitere',),
'booke': ('booke',),
'booker': ('booke',),
'bookes': ('booke',),
'booka': ('booke',),
'booket': ('booke',),
'booka': ('booke',),
'booket': ('booke',),
'book': ('booke',),
'borde': ('borde',),
'border': ('borde',),
'bordes': ('borde',),
'borda': ('borde',),
'bordet': ('borde',),
'borda': ('borde',),
'bordet': ('borde',),
'bord': ('borde',),
'bordkle': ('bordkle',),
'bordkler': ('bordkle',),
'bordkles': ('bordkle',),
'bordkledde': ('bordkle',),
'bordkledd': ('bordkle',),
'bordkle': ('bordkle',),
'bore': ('bore',),
'borer': ('bore',),
'bores': ('bore',),
'bora': ('bore',),
'boret': ('bore',),
'bora': ('bore',),
'boret': ('bore',),
'bor': ('bore',),
'borge': ('borge',),
'borger': ('borge',),
'borges': ('borge',),
'borga': ('borge',),
'borget': ('borge',),
'borga': ('borge',),
'borget': ('borge',),
'borg': ('borge',),
'bortbygsle': ('bortbygsle',),
'bortbygsler': ('bortbygsle',),
'bortbygsles': ('bortbygsle',),
'bortbygsla': ('bortbygsle',),
'bortbygslet': ('bortbygsle',),
'bortbygsla': ('bortbygsle',),
'bortbygslet': ('bortbygsle',),
'bortbygsl': ('bortbygsle',),
'bortbygsle': ('bortbygsle',),
'bortbygsl': ('bortbygsle',),
'bortbygsle': ('bortbygsle',),
'bortfeste': ('bortfeste',),
'bortfester': ('bortfeste',),
'bortfestes': ('bortfeste',),
'bortfesta': ('bortfeste',),
'bortfestet': ('bortfeste',),
'bortfesta': ('bortfeste',),
'bortfestet': ('bortfeste',),
'bortfest': ('bortfeste',),
'bortforklare': ('bortforklare',),
'bortforklarer': ('bortforklare',),
'bortforklares': ('bortforklare',),
'bortforklarte': ('bortforklare',),
'bortforklart': ('bortforklare',),
'bortforklar': ('bortforklare',),
'bortfrakte': ('bortfrakte',),
'bortfrakter': ('bortfrakte',),
'bortfraktes': ('bortfrakte',),
'bortfrakta': ('bortfrakte',),
'bortfraktet': ('bortfrakte',),
'bortfrakta': ('bortfrakte',),
'bortfraktet': ('bortfrakte',),
'bortfrakt': ('bortfrakte',),
'bortføre': ('bortføre',),
'bortfører': ('bortføre',),
'bortføres': ('bortføre',),
'bortførte': ('bortføre',),
'bortført': ('bortføre',),
'bortfør': ('bortføre',),
'bortlede': ('bortlede',),
'bortleder': ('bortlede',),
'bortledes': ('bortlede',),
'bortleda': ('bortlede',),
'bortledet': ('bortlede',),
'bortleda': ('bortlede',),
'bortledet': ('bortlede',),
'bortled': ('bortlede',),
'bortse': ('bortse',),
'bortser': ('bortse',),
'bortses': ('bortse',),
'bortsees': ('bortse',),
'bortså': ('bortse',),
'bortsett': ('bortse',),
'bortse': ('bortse',),
'bortsette': ('bortsette',),
'bortsetter': ('bortsette',),
'bortsettes': ('bortsette',),
'bortsatte': ('bortsette',),
'bortsatt': ('bortsette',),
'bortsett': ('bortsette',),
'bortødsle': ('bortødsle',),
'bortødsler': ('bortødsle',),
'bortødsles': ('bortødsle',),
'bortødsla': ('bortødsle',),
'bortødslet': ('bortødsle',),
'bortødsla': ('bortødsle',),
'bortødslet': ('bortødsle',),
'bortødsl': ('bortødsle',),
'bosette': ('bosette',),
'bosetter': ('bosette',),
'bosettes': ('bosette',),
'bosatte': ('bosette',),
'bosatt': ('bosette',),
'bosett': ('bosette',),
'botanisere': ('botanisere',),
'botaniserer': ('botanisere',),
'botaniseres': ('botanisere',),
'botaniserte': ('botanisere',),
'botanisert': ('botanisere',),
'botaniser': ('botanisere',),
'botlegge': ('botlegge',),
'botlegger': ('botlegge',),
'botlegges': ('botlegge',),
'botla': ('botlegge',),
'botlagt': ('botlegge',),
'botlegg': ('botlegge',),
'botne': ('botne',),
'botner': ('botne',),
'botnes': ('botne',),
'botna': ('botne',),
'botnet': ('botne',),
'botna': ('botne',),
'botnet': ('botne',),
'botn': ('botne',),
'botne': ('botne',),
'botn': ('botne',),
'botne': ('botne',),
'botnfelle': ('botnfelle',),
'botnfeller': ('botnfelle',),
'botnfelles': ('botnfelle',),
'botnfelte': ('botnfelle',),
'botnfelt': ('botnfelle',),
'botnfell': ('botnfelle',),
'botnskrape': ('botnskrape',),
'botnskraper': ('botnskrape',),
'botnskrapes': ('botnskrape',),
'botnskrapa': ('botnskrape',),
'botnskrapet': ('botnskrape',),
'botnskrapte': ('botnskrape',),
'botnskrapa': ('botnskrape',),
'botnskrapet': ('botnskrape',),
'botnskrapt': ('botnskrape',),
'botnskrap': ('botnskrape',),
'bowle': ('bowle',),
'bowler': ('bowle',),
'bowles': ('bowle',),
'bowla': ('bowle',),
'bowlet': ('bowle',),
'bowla': ('bowle',),
'bowlet': ('bowle',),
'bowl': ('bowle',),
'brake': ('brake',),
'braker': ('brake',),
'brakes': ('brake',),
'braka': ('brake',),
'braket': ('brake',),
'brakte': ('brake',),
'braka': ('brake',),
'braket': ('brake',),
'brakt': ('brake',),
'brak': ('brake',),
'brakke': ('brakke',),
'brakker': ('brakke',),
'brakkes': ('brakke',),
'brakka': ('brakke',),
'brakket': ('brakke',),
'brakka': ('brakke',),
'brakket': ('brakke',),
'brakk': ('brakke',),
'bramme': ('bramme',),
'brammer': ('bramme',),
'brammes': ('bramme',),
'bramma': ('bramme',),
'brammet': ('bramme',),
'bramma': ('bramme',),
'brammet': ('bramme',),
'bram': ('bramme',),
'braske': ('braske',),
'brasker': ('braske',),
'braskes': ('braske',),
'braska': ('braske',),
'brasket': ('braske',),
'braska': ('braske',),
'brasket': ('braske',),
'brask': ('braske',),
'bratne': ('bratne',),
'bratner': ('bratne',),
'bratnes': ('bratne',),
'bratna': ('bratne',),
'bratnet': ('bratne',),
'bratna': ('bratne',),
'bratnet': ('bratne',),
'bratn': ('bratne',),
'bratne': ('bratne',),
'bratn': ('bratne',),
'bratne': ('bratne',),
'braute': ('braute',),
'brauter': ('braute',),
'brautes': ('braute',),
'brauta': ('braute',),
'brautet': ('braute',),
'brauta': ('braute',),
'brautet': ('braute',),
'braut': ('braute',),
'bravere': ('bravere',),
'braverer': ('bravere',),
'braveres': ('bravere',),
'braverte': ('bravere',),
'bravert': ('bravere',),
'braver': ('bravere',),
'breie': ('breie',),
'breier': ('breie',),
'breies': ('breie',),
'breia': ('breie',),
'breiet': ('breie',),
'breide': ('breie',),
'breia': ('breie',),
'breiet': ('breie',),
'breid': ('breie',),
'brei': ('breie',),
'breke': ('breke',),
'breker': ('breke',),
'brekes': ('breke',),
'breka': ('breke',),
'breket': ('breke',),
'brekte': ('breke',),
'breka': ('breke',),
'breket': ('breke',),
'brekt': ('breke',),
'brek': ('breke',),
'brekke': ('brekke',),
'brekker': ('brekke',),
'brekkes': ('brekke',),
'brekka': ('brekke',),
'brekket': ('brekke',),
'brekte': ('brekke',),
'brekka': ('brekke',),
'brekket': ('brekke',),
'brekt': ('brekke',),
'brekk': ('brekke',),
'brekke': ('brekke',),
'brekker': ('brekke',),
'brekkes': ('brekke',),
'brakk': ('brekke',),
'brukket': ('brekke',),
'brekk': ('brekke',),
'bremme': ('bremme',),
'bremmer': ('bremme',),
'bremmes': ('bremme',),
'bremma': ('bremme',),
'bremmet': ('bremme',),
'bremma': ('bremme',),
'bremmet': ('bremme',),
'brem': ('bremme',),
'bremse': ('bremse',),
'bremser': ('bremse',),
'bremses': ('bremse',),
'bremsa': ('bremse',),
'bremset': ('bremse',),
'bremsa': ('bremse',),
'bremset': ('bremse',),
'brems': ('bremse',),
'brennemerke': ('brennemerke',),
'brennemerker': ('brennemerke',),
'brennemerkes': ('brennemerke',),
'brennemerka': ('brennemerke',),
'brennemerket': ('brennemerke',),
'brennemerka': ('brennemerke',),
'brennemerket': ('brennemerke',),
'brennemerk': ('brennemerke',),
'bresere': ('bresere',),
'breserer': ('bresere',),
'breseres': ('bresere',),
'breserte': ('bresere',),
'bresert': ('bresere',),
'breser': ('bresere',),
'breste': ('breste',),
'brester': ('breste',),
'brestes': ('breste',),
'bresta': ('breste',),
'brestet': ('breste',),
'bresta': ('breste',),
'brestet': ('breste',),
'brest': ('breste',),
'brette': ('brette',),
'bretter': ('brette',),
'brettes': ('brette',),
'bretta': ('brette',),
'brettet': ('brette',),
'bretta': ('brette',),
'brettet': ('brette',),
'brett': ('brette',),
'brettsegle': ('brettsegle',),
'brettsegler': ('brettsegle',),
'brettsegles': ('brettsegle',),
'brettsegla': ('brettsegle',),
'brettseglet': ('brettsegle',),
'brettsegla': ('brettsegle',),
'brettseglet': ('brettsegle',),
'brettsegl': ('brettsegle',),
'brettsegle': ('brettsegle',),
'brettsegl': ('brettsegle',),
'brettsegle': ('brettsegle',),
'brettseile': ('brettseile',),
'brettseiler': ('brettseile',),
'brettseiles': ('brettseile',),
'brettseilte': ('brettseile',),
'brettseilt': ('brettseile',),
'brettseil': ('brettseile',),
'brevveksle': ('brevveksle',),
'brevveksler': ('brevveksle',),
'brevveksles': ('brevveksle',),
'brevveksla': ('brevveksle',),
'brevvekslet': ('brevveksle',),
'brevveksla': ('brevveksle',),
'brevvekslet': ('brevveksle',),
'brevveksl': ('brevveksle',),
'brevveksle': ('brevveksle',),
'brevveksl': ('brevveksle',),
'brevveksle': ('brevveksle',),
'brife': ('brife',),
'brifer': ('brife',),
'brifes': ('brife',),
'brifa': ('brife',),
'brifet': ('brife',),
'brifa': ('brife',),
'brifet': ('brife',),
'brif': ('brife',),
'brikettere': ('brikettere',),
'briketterer': ('brikettere',),
'briketteres': ('brikettere',),
'briketterte': ('brikettere',),
'brikettert': ('brikettere',),
'briketter': ('brikettere',),
'briljere': ('briljere',),
'briljerer': ('briljere',),
'briljeres': ('briljere',),
'briljerte': ('briljere',),
'briljert': ('briljere',),
'briljer': ('briljere',),
'bringe': ('bringe',),
'bringer': ('bringe',),
'bringes': ('bringe',),
'brakte': ('bringe',),
'brakt': ('bringe',),
'bring': ('bringe',),
'brise': ('brise',),
'briser': ('brise',),
'brises': ('brise',),
'briste': ('brise',),
'brist': ('brise',),
'bris': ('brise',),
'briske': ('briske',),
'brisker': ('briske',),
'briskes': ('briske',),
'briska': ('briske',),
'brisket': ('briske',),
'briska': ('briske',),
'brisket': ('briske',),
'brisk': ('briske',),
'briste': ('briste',),
'brister': ('briste',),
'bristes': ('briste',),
'brast': ('briste',),
'bristet': ('briste',),
'brist': ('briste',),
'brodde': ('brodde',),
'brodder': ('brodde',),
'broddes': ('brodde',),
'brodda': ('brodde',),
'broddet': ('brodde',),
'brodda': ('brodde',),
'broddet': ('brodde',),
'brodd': ('brodde',),
'brodere': ('brodere',),
'broderer': ('brodere',),
'broderes': ('brodere',),
'broderte': ('brodere',),
'brodert': ('brodere',),
'broder': ('brodere',),
'brolegge': ('brolegge',),
'brolegger': ('brolegge',),
'brolegges': ('brolegge',),
'brola': ('brolegge',),
'brolagt': ('brolegge',),
'brolegg': ('brolegge',),
'bronse': ('bronse',),
'bronser': ('bronse',),
'bronses': ('bronse',),
'bronsa': ('bronse',),
'bronset': ('bronse',),
'bronsa': ('bronse',),
'bronset': ('bronse',),
'brons': ('bronse',),
'bronsere': ('bronsere',),
'bronserer': ('bronsere',),
'bronseres': ('bronsere',),
'bronserte': ('bronsere',),
'bronsert': ('bronsere',),
'bronser': ('bronsere',),
'brosjere': ('brosjere',),
'brosjerer': ('brosjere',),
'brosjeres': ('brosjere',),
'brosjerte': ('brosjere',),
'brosjert': ('brosjere',),
'brosjer': ('brosjere',),
'brotne': ('brotne',),
'brotner': ('brotne',),
'brotnes': ('brotne',),
'brotna': ('brotne',),
'brotnet': ('brotne',),
'brotna': ('brotne',),
'brotnet': ('brotne',),
'brotn': ('brotne',),
'brotne': ('brotne',),
'brotn': ('brotne',),
'brotne': ('brotne',),
'brotsje': ('brotsje',),
'brotsjer': ('brotsje',),
'brotsjes': ('brotsje',),
'brotsja': ('brotsje',),
'brotsjet': ('brotsje',),
'brotsja': ('brotsje',),
'brotsjet': ('brotsje',),
'brotsj': ('brotsje',),
'bruke': ('bruke',),
'bruker': ('bruke',),
'brukes': ('bruke',),
'brukte': ('bruke',),
'brukt': ('bruke',),
'bruk': ('bruke',),
'brulegge': ('brulegge',),
'brulegger': ('brulegge',),
'brulegges': ('brulegge',),
'brula': ('brulegge',),
'brulagt': ('brulegge',),
'brulegg': ('brulegge',),
'brumle': ('brumle',),
'brumler': ('brumle',),
'brumles': ('brumle',),
'brumla': ('brumle',),
'brumlet': ('brumle',),
'brumla': ('brumle',),
'brumlet': ('brumle',),
'bruml': ('brumle',),
'brumle': ('brumle',),
'bruml': ('brumle',),
'brumle': ('brumle',),
'brumme': ('brumme',),
'brummer': ('brumme',),
'brummes': ('brumme',),
'brumma': ('brumme',),
'brummet': ('brumme',),
'brumma': ('brumme',),
'brummet': ('brumme',),
'brum': ('brumme',),
'brune': ('brune',),
'bruner': ('brune',),
'brunes': ('brune',),
'bruna': ('brune',),
'brunet': ('brune',),
'bruna': ('brune',),
'brunet': ('brune',),
'brun': ('brune',),
'brunsteike': ('brunsteike',),
'brunsteiker': ('brunsteike',),
'brunsteikes': ('brunsteike',),
'brunsteikte': ('brunsteike',),
'brunsteikt': ('brunsteike',),
'brunsteik': ('brunsteike',),
'brunsteke': ('brunsteke',),
'brunsteker': ('brunsteke',),
'brunstekes': ('brunsteke',),
'brunstekte': ('brunsteke',),
'brunstekt': ('brunsteke',),
'brunstek': ('brunsteke',),
'bruse': ('bruse',),
'bruser': ('bruse',),
'bruses': ('bruse',),
'bruste': ('bruse',),
'brust': ('bruse',),
'brus': ('bruse',),
'brutalisere': ('brutalisere',),
'brutaliserer': ('brutalisere',),
'brutaliseres': ('brutalisere',),
'brutaliserte': ('brutalisere',),
'brutalisert': ('brutalisere',),
'brutaliser': ('brutalisere',),
'bry': ('bry',),
'bryr': ('bry',),
'brys': ('bry',),
'brydde': ('bry',),
'brød': ('bry',),
'brydd': ('bry',),
'bry': ('bry',),
'brydde': ('brydde',),
'brydder': ('brydde',),
'bryddes': ('brydde',),
'brydda': ('brydde',),
'bryddet': ('brydde',),
'brydda': ('brydde',),
'bryddet': ('brydde',),
'brydd': ('brydde',),
'brygge': ('brygge',),
'brygger': ('brygge',),
'brygges': ('brygge',),
'brygga': ('brygge',),
'brygget': ('brygge',),
'brygga': ('brygge',),
'brygget': ('brygge',),
'brygg': ('brygge',),
'bryne': ('bryne',),
'bryner': ('bryne',),
'brynes': ('bryne',),
'brynte': ('bryne',),
'brynt': ('bryne',),
'bryn': ('bryne',),
'bryske': ('bryske',),
'brysker': ('bryske',),
'bryskes': ('bryske',),
'bryska': ('bryske',),
'brysket': ('bryske',),
'bryska': ('bryske',),
'brysket': ('bryske',),
'brysk': ('bryske',),
'bryste': ('bryste',),
'bryster': ('bryste',),
'brystes': ('bryste',),
'brysta': ('bryste',),
'brystet': ('bryste',),
'brysta': ('bryste',),
'brystet': ('bryste',),
'bryst': ('bryste',),
'bryte': ('bryte',),
'bryter': ('bryte',),
'brytes': ('bryte',),
'brøt': ('bryte',),
'brøyt': ('bryte',),
'brutt': ('bryte',),
'bryt': ('bryte',),
'bråbremse': ('bråbremse',),
'bråbremser': ('bråbremse',),
'bråbremses': ('bråbremse',),
'bråbremsa': ('bråbremse',),
'bråbremset': ('bråbremse',),
'bråbremsa': ('bråbremse',),
'bråbremset': ('bråbremse',),
'bråbrems': ('bråbremse',),
'bråke': ('bråke',),
'bråker': ('bråke',),
'bråkes': ('bråke',),
'bråka': ('bråke',),
'bråket': ('bråke',),
'bråkte': ('bråke',),
'bråka': ('bråke',),
'bråket': ('bråke',),
'bråkt': ('bråke',),
'bråk': ('bråke',),
'bråne': ('bråne',),
'bråner': ('bråne',),
'brånes': ('bråne',),
'bråna': ('bråne',),
'brånet': ('bråne',),
'brånte': ('bråne',),
'bråna': ('bråne',),
'brånet': ('bråne',),
'brånt': ('bråne',),
'brån': ('bråne',),
'brødfø': ('brødfø',),
'brødfør': ('brødfø',),
'brødføs': ('brødfø',),
'brødfødde': ('brødfø',),
'brødfødd': ('brødfø',),
'brødfø': ('brødfø',),
'brøle': ('brøle',),
'brøler': ('brøle',),
'brøles': ('brøle',),
'brølte': ('brøle',),
'brølt': ('brøle',),
'brøl': ('brøle',),
'brøyte': ('brøyte',),
'brøyter': ('brøyte',),
'brøytes': ('brøyte',),
'brøyta': ('brøyte',),
'brøytet': ('brøyte',),
'brøyta': ('brøyte',),
'brøytet': ('brøyte',),
'brøyt': ('brøyte',),
'bu': ('bu',),
'bur': ('bu',),
'bus': ('bu',),
'budde': ('bu',),
'budd': ('bu',),
'bu': ('bu',),
'budsende': ('budsende',),
'budsender': ('budsende',),
'budsendes': ('budsende',),
'budsendte': ('budsende',),
'budsendt': ('budsende',),
'budsend': ('budsende',),
'budsjettere': ('budsjettere',),
'budsjetterer': ('budsjettere',),
'budsjetteres': ('budsjettere',),
'budsjetterte': ('budsjettere',),
'budsjettert': ('budsjettere',),
'budsjetter': ('budsjettere',),
'bue': ('bue',),
'buer': ('bue',),
'bues': ('bue',),
'bua': ('bue',),
'buet': ('bue',),
'bua': ('bue',),
'buet': ('bue',),
'bu': ('bue',),
'bugne': ('bugne',),
'bugner': ('bugne',),
'bugnes': ('bugne',),
'bugna': ('bugne',),
'bugnet': ('bugne',),
'bugna': ('bugne',),
'bugnet': ('bugne',),
'bugn': ('bugne',),
'bukke': ('bukke',),
'bukker': ('bukke',),
'bukkes': ('bukke',),
'bukka': ('bukke',),
'bukket': ('bukke',),
'bukka': ('bukke',),
'bukket': ('bukke',),
'bukk': ('bukke',),
'buklande': ('buklande',),
'buklander': ('buklande',),
'buklandes': ('buklande',),
'buklanda': ('buklande',),
'buklandet': ('buklande',),
'buklanda': ('buklande',),
'buklandet': ('buklande',),
'bukland': ('buklande',),
'buksere': ('buksere',),
'bukserer': ('buksere',),
'bukseres': ('buksere',),
'bukserte': ('buksere',),
'buksert': ('buksere',),
'bukser': ('buksere',),
'bukte': ('bukte',),
'bukter': ('bukte',),
'buktes': ('bukte',),
'bukta': ('bukte',),
'buktet': ('bukte',),
'bukta': ('bukte',),
'buktet': ('bukte',),
'bukt': ('bukte',),
'buldre': ('buldre',),
'buldrer': ('buldre',),
'buldres': ('buldre',),
'buldra': ('buldre',),
'buldret': ('buldre',),
'buldra': ('buldre',),
'buldret': ('buldre',),
'buldr': ('buldre',),
'buldre': ('buldre',),
'buldr': ('buldre',),
'buldre': ('buldre',),
'bule': ('bule',),
'buler': ('bule',),
'bules': ('bule',),
'bula': ('bule',),
'bulet': ('bule',),
'bulte': ('bule',),
'bula': ('bule',),
'bulet': ('bule',),
'bult': ('bule',),
'bul': ('bule',),
'bulke': ('bulke',),
'bulker': ('bulke',),
'bulkes': ('bulke',),
'bulka': ('bulke',),
'bulket': ('bulke',),
'bulka': ('bulke',),
'bulket': ('bulke',),
'bulk': ('bulke',),
'bulne': ('bulne',),
'bulner': ('bulne',),
'bulnes': ('bulne',),
'bulna': ('bulne',),
'bulnet': ('bulne',),
'bulna': ('bulne',),
'bulnet': ('bulne',),
'buln': ('bulne',),
'bulne': ('bulne',),
'buln': ('bulne',),
'bulne': ('bulne',),
'bumse': ('bumse',),
'bumser': ('bumse',),
'bumses': ('bumse',),
'bumsa': ('bumse',),
'bumset': ('bumse',),
'bumsa': ('bumse',),
'bumset': ('bumse',),
'bums': ('bumse',),
'bunke': ('bunke',),
'bunker': ('bunke',),
'bunkes': ('bunke',),
'bunka': ('bunke',),
'bunket': ('bunke',),
'bunka': ('bunke',),
'bunket': ('bunke',),
'bunk': ('bunke',),
'bunkre': ('bunkre',),
'bunkrer': ('bunkre',),
'bunkres': ('bunkre',),
'bunkra': ('bunkre',),
'bunkret': ('bunkre',),
'bunkra': ('bunkre',),
'bunkret': ('bunkre',),
'bunkr': ('bunkre',),
'bunkre': ('bunkre',),
'bunkr': ('bunkre',),
'bunkre': ('bunkre',),
'bunnfelle': ('bunnfelle',),
'bunnfeller': ('bunnfelle',),
'bunnfelles': ('bunnfelle',),
'bunnfelte': ('bunnfelle',),
'bunnfelt': ('bunnfelle',),
'bunnfell': ('bunnfelle',),
'bunnskrape': ('bunnskrape',),
'bunnskraper': ('bunnskrape',),
'bunnskrapes': ('bunnskrape',),
'bunnskrapa': ('bunnskrape',),
'bunnskrapet': ('bunnskrape',),
'bunnskrapte': ('bunnskrape',),
'bunnskrapa': ('bunnskrape',),
'bunnskrapet': ('bunnskrape',),
'bunnskrapt': ('bunnskrape',),
'bunnskrap': ('bunnskrape',),
'bunte': ('bunte',),
'bunter': ('bunte',),
'buntes': ('bunte',),
'bunta': ('bunte',),
'buntet': ('bunte',),
'bunta': ('bunte',),
'buntet': ('bunte',),
'bunt': ('bunte',),
'burde': ('burde',),
'bør': ('burde',),
'burde': ('burde',),
'burdet': ('burde',),
'bure': ('bure',),
'burer': ('bure',),
'bures': ('bure',),
'bura': ('bure',),
'buret': ('bure',),
'burte': ('bure',),
'bura': ('bure',),
'buret': ('bure',),
'burt': ('bure',),
'bur': ('bure',),
'buse': ('buse',),
'buser': ('buse',),
'buses': ('buse',),
'busa': ('buse',),
'buset': ('buse',),
'buste': ('buse',),
'busa': ('buse',),
'buset': ('buse',),
'bust': ('buse',),
'bus': ('buse',),
'busette': ('busette',),
'busetter': ('busette',),
'busettes': ('busette',),
'busatte': ('busette',),
'busatt': ('busette',),
'busett': ('busette',),
'buske': ('buske',),
'busker': ('buske',),
'buskes': ('buske',),
'buska': ('buske',),
'busket': ('buske',),
'buska': ('buske',),
'busket': ('buske',),
'busk': ('buske',),
'busse': ('busse',),
'busser': ('busse',),
'busses': ('busse',),
'bussa': ('busse',),
'busset': ('busse',),
'bussa': ('busse',),
'busset': ('busse',),
'buss': ('busse',),
'buste': ('buste',),
'buster': ('buste',),
'bustes': ('buste',),
'busta': ('buste',),
'bustet': ('buste',),
'busta': ('buste',),
'bustet': ('buste',),
'bust': ('buste',),
'butte': ('butte',),
'butter': ('butte',),
'buttes': ('butte',),
'butta': ('butte',),
'buttet': ('butte',),
'butta': ('butte',),
'buttet': ('butte',),
'butt': ('butte',),
'by': ('by',),
'byr': ('by',),
'bys': ('by',),
'bydde': ('by',),
'bød': ('by',),
'bøy': ('by',),
'bydd': ('by',),
'budt': ('by',),
'bydd': ('by',),
'by': ('by',),
'byde': ('byde',),
'byder': ('byde',),
'bydes': ('byde',),
'bydde': ('byde',),
'bød': ('byde',),
'bøy': ('byde',),
'bydd': ('byde',),
'budt': ('byde',),
'bydd': ('byde',),
'byd': ('byde',),
'by': ('byde',),
'bygge': ('bygge',),
'bygger': ('bygge',),
'bygges': ('bygge',),
'bygget': ('bygge',),
'bygde': ('bygge',),
'bygget': ('bygge',),
'bygd': ('bygge',),
'bygg': ('bygge',),
'bygsle': ('bygsle',),
'bygsler': ('bygsle',),
'bygsles': ('bygsle',),
'bygsla': ('bygsle',),
'bygslet': ('bygsle',),
'bygsla': ('bygsle',),
'bygslet': ('bygsle',),
'bygsl': ('bygsle',),
'bygsle': ('bygsle',),
'bygsl': ('bygsle',),
'bygsle': ('bygsle',),
'bykse': ('bykse',),
'bykser': ('bykse',),
'bykses': ('bykse',),
'bykste': ('bykse',),
'bykst': ('bykse',),
'byks': ('bykse',),
'bylte': ('bylte',),
'bylter': ('bylte',),
'byltes': ('bylte',),
'bylta': ('bylte',),
'byltet': ('bylte',),
'bylta': ('bylte',),
'byltet': ('bylte',),
'bylt': ('bylte',),
'byråkratisere': ('byråkratisere',),
'byråkratiserer': ('byråkratisere',),
'byråkratiseres': ('byråkratisere',),
'byråkratiserte': ('byråkratisere',),
'byråkratisert': ('byråkratisere',),
'byråkratiser': ('byråkratisere',),
'bysse': ('bysse',),
'bysser': ('bysse',),
'bysses': ('bysse',),
'byssa': ('bysse',),
'bysset': ('bysse',),
'byssa': ('bysse',),
'bysset': ('bysse',),
'byss': ('bysse',),
'bytte': ('bytte',),
'bytter': ('bytte',),
'byttes': ('bytte',),
'bytta': ('bytte',),
'byttet': ('bytte',),
'bytta': ('bytte',),
'byttet': ('bytte',),
'bytt': ('bytte',),
'byttelåne': ('byttelåne',),
'byttelåner': ('byttelåne',),
'byttelånes': ('byttelåne',),
'byttelånte': ('byttelåne',),
'byttelånt': ('byttelåne',),
'byttelån': ('byttelåne',),
'båndlegge': ('båndlegge',),
'båndlegger': ('båndlegge',),
'båndlegges': ('båndlegge',),
'båndla': ('båndlegge',),
'båndlagt': ('båndlegge',),
'båndlegg': ('båndlegge',),
'båre': ('båre',),
'bårer': ('båre',),
'båres': ('båre',),
'båra': ('båre',),
'båret': ('båre',),
'båra': ('båre',),
'båret': ('båre',),
'bår': ('båre',),
'bæsje': ('bæsje',),
'bæsjer': ('bæsje',),
'bæsjes': ('bæsje',),
'bæsja': ('bæsje',),
'bæsjet': ('bæsje',),
'bæsja': ('bæsje',),
'bæsjet': ('bæsje',),
'bæsj': ('bæsje',),
'bølge': ('bølge',),
'bølger': ('bølge',),
'bølges': ('bølge',),
'bølga': ('bølge',),
'bølget': ('bølge',),
'bølga': ('bølge',),
'bølget': ('bølge',),
'bølg': ('bølge',),
'bønnfalle': ('bønnfalle',),
'bønnfaller': ('bønnfalle',),
'bønnfalles': ('bønnfalle',),
'bønnfalt': ('bønnfalle',),
'bønnfall': ('bønnfalle',),
'bønnhøre': ('bønnhøre',),
'bønnhører': ('bønnhøre',),
'bønnhøres': ('bønnhøre',),
'bønnhørte': ('bønnhøre',),
'bønnhørt': ('bønnhøre',),
'bønnhør': ('bønnhøre',),
'børse': ('børse',),
'børser': ('børse',),
'børses': ('børse',),
'børsa': ('børse',),
'børset': ('børse',),
'børsa': ('børse',),
'børset': ('børse',),
'børs': ('børse',),
'børsnotere': ('børsnotere',),
'børsnoterer': ('børsnotere',),
'børsnoteres': ('børsnotere',),
'børsnoterte': ('børsnotere',),
'børsnotert': ('børsnotere',),
'børsnoter': ('børsnotere',),
'børste': ('børste',),
'børster': ('børste',),
'børstes': ('børste',),
'børsta': ('børste',),
'børstet': ('børste',),
'børsta': ('børste',),
'børstet': ('børste',),
'børst': ('børste',),
'bøte': ('bøte',),
'bøter': ('bøte',),
'bøtes': ('bøte',),
'bøtte': ('bøte',),
'bøtt': ('bøte',),
'bøt': ('bøte',),
'bøtelegge': ('bøtelegge',),
'bøtelegger': ('bøtelegge',),
'bøtelegges': ('bøtelegge',),
'bøtela': ('bøtelegge',),
'bøtelagt': ('bøtelegge',),
'bøtelegg': ('bøtelegge',),
'bøye': ('bøye',),
'bøyer': ('bøye',),
'bøyes': ('bøye',),
'bøyet': ('bøye',),
'bøyde': ('bøye',),
'bøyet': ('bøye',),
'bøyd': ('bøye',),
'bøy': ('bøye',),
'campe': ('campe',),
'camper': ('campe',),
'campes': ('campe',),
'campa': ('campe',),
'campet': ('campe',),
'campa': ('campe',),
'campet': ('campe',),
'camp': ('campe',),
'cashe': ('cashe',),
'casher': ('cashe',),
'cashes': ('cashe',),
'casha': ('cashe',),
'cashet': ('cashe',),
'casha': ('cashe',),
'cashet': ('cashe',),
'cash': ('cashe',),
'celebrere': ('celebrere',),
'celebrerer': ('celebrere',),
'celebreres': ('celebrere',),
'celebrerte': ('celebrere',),
'celebrert': ('celebrere',),
'celebrer': ('celebrere',),
'changere': ('changere',),
'changerer': ('changere',),
'changeres': ('changere',),
'changerte': ('changere',),
'changert': ('changere',),
'changer': ('changere',),
'chartre': ('chartre',),
'chartrer': ('chartre',),
'chartres': ('chartre',),
'chartra': ('chartre',),
'chartret': ('chartre',),
'chartra': ('chartre',),
'chartret': ('chartre',),
'chartr': ('chartre',),
'chartre': ('chartre',),
'chartr': ('chartre',),
'chartre': ('chartre',),
'chevrotere': ('chevrotere',),
'chevroterer': ('chevrotere',),
'chevroteres': ('chevrotere',),
'chevroterte': ('chevrotere',),
'chevrotert': ('chevrotere',),
'chevroter': ('chevrotere',),
'chiffrere': ('chiffrere',),
'chiffrerer': ('chiffrere',),
'chiffreres': ('chiffrere',),
'chiffrerte': ('chiffrere',),
'chiffrert': ('chiffrere',),
'chiffrer': ('chiffrere',),
'choke': ('choke',),
'choker': ('choke',),
'chokes': ('choke',),
'choka': ('choke',),
'choket': ('choke',),
'choka': ('choke',),
'choket': ('choke',),
'chok': ('choke',),
'clinche': ('clinche',),
'clincher': ('clinche',),
'clinches': ('clinche',),
'clincha': ('clinche',),
'clinchet': ('clinche',),
'clincha': ('clinche',),
'clinchet': ('clinche',),
'clinch': ('clinche',),
'clutche': ('clutche',),
'clutcher': ('clutche',),
'clutches': ('clutche',),
'clutcha': ('clutche',),
'clutchet': ('clutche',),
'clutcha': ('clutche',),
'clutchet': ('clutche',),
'clutch': ('clutche',),
'cruise': ('cruise',),
'cruiser': ('cruise',),
'cruises': ('cruise',),
'cruisa': ('cruise',),
'cruiset': ('cruise',),
'cruisa': ('cruise',),
'cruiset': ('cruise',),
'cruis': ('cruise',),
'cyanidisere': ('cyanidisere',),
'cyanidiserer': ('cyanidisere',),
'cyanidiseres': ('cyanidisere',),
'cyanidiserte': ('cyanidisere',),
'cyanidisert': ('cyanidisere',),
'cyanidiser': ('cyanidisere',),
'dabbe': ('dabbe',),
'dabber': ('dabbe',),
'dabbes': ('dabbe',),
'dabba': ('dabbe',),
'dabbet': ('dabbe',),
'dabba': ('dabbe',),
'dabbet': ('dabbe',),
'dabb': ('dabbe',),
'dadle': ('dadle',),
'dadler': ('dadle',),
'dadles': ('dadle',),
'dadla': ('dadle',),
'dadlet': ('dadle',),
'dadla': ('dadle',),
'dadlet': ('dadle',),
'dadl': ('dadle',),
'dadle': ('dadle',),
'dadl': ('dadle',),
'dadle': ('dadle',),
'daffe': ('daffe',),
'daffer': ('daffe',),
'daffes': ('daffe',),
'daffa': ('daffe',),
'daffet': ('daffe',),
'daffa': ('daffe',),
'daffet': ('daffe',),
'daff': ('daffe',),
'dagdrømme': ('dagdrømme',),
'dagdrømmer': ('dagdrømme',),
'dagdrømmes': ('dagdrømme',),
'dagdrømte': ('dagdrømme',),
'dagdrømt': ('dagdrømme',),
'dagdrøm': ('dagdrømme',),
'dage': ('dage',),
'dager': ('dage',),
'dages': ('dage',),
'daga': ('dage',),
'daget': ('dage',),
'daga': ('dage',),
'daget': ('dage',),
'dag': ('dage',),
'dages': ('dages',),
'dagedes': ('dages',),
'dages': ('dages',),
'dale': ('dale',),
'daler': ('dale',),
'dales': ('dale',),
'dalte': ('dale',),
'dalt': ('dale',),
'dal': ('dale',),
'dalke': ('dalke',),
'dalker': ('dalke',),
'dalkes': ('dalke',),
'dalka': ('dalke',),
'dalket': ('dalke',),
'dalka': ('dalke',),
'dalket': ('dalke',),
'dalk': ('dalke',),
'dalte': ('dalte',),
'dalter': ('dalte',),
'daltes': ('dalte',),
'dalta': ('dalte',),
'daltet': ('dalte',),
'dalta': ('dalte',),
'daltet': ('dalte',),
'dalt': ('dalte',),
'damascere': ('damascere',),
'damascerer': ('damascere',),
'damasceres': ('damascere',),
'damascerte': ('damascere',),
'damascert': ('damascere',),
'damascer': ('damascere',),
'dampe': ('dampe',),
'damper': ('dampe',),
'dampes': ('dampe',),
'dampa': ('dampe',),
'dampet': ('dampe',),
'dampa': ('dampe',),
'dampet': ('dampe',),
'damp': ('dampe',),
'dampkoke': ('dampkoke',),
'dampkoker': ('dampkoke',),
'dampkokes': ('dampkoke',),
'dampkokte': ('dampkoke',),
'dampkokt': ('dampkoke',),
'dampkok': ('dampkoke',),
'dandere': ('dandere',),
'danderer': ('dandere',),
'danderes': ('dandere',),
'danderte': ('dandere',),
'dandert': ('dandere',),
'dander': ('dandere',),
'dangle': ('dangle',),
'dangler': ('dangle',),
'dangles': ('dangle',),
'dangla': ('dangle',),
'danglet': ('dangle',),
'dangla': ('dangle',),
'danglet': ('dangle',),
'dangl': ('dangle',),
'dangle': ('dangle',),
'dangl': ('dangle',),
'dangle': ('dangle',),
'danke': ('danke',),
'danker': ('danke',),
'dankes': ('danke',),
'danka': ('danke',),
'danket': ('danke',),
'danka': ('danke',),
'danket': ('danke',),
'dank': ('danke',),
'danne': ('danne',),
'danner': ('danne',),
'dannes': ('danne',),
'danna': ('danne',),
'dannet': ('danne',),
'danna': ('danne',),
'dannet': ('danne',),
'dann': ('danne',),
'danse': ('danse',),
'danser': ('danse',),
'danses': ('danse',),
'dansa': ('danse',),
'danset': ('danse',),
'dansa': ('danse',),
'danset': ('danse',),
'dans': ('danse',),
'danske': ('danske',),
'dansker': ('danske',),
'danskes': ('danske',),
'danska': ('danske',),
'dansket': ('danske',),
'danska': ('danske',),
'dansket': ('danske',),
'dansk': ('danske',),
'darre': ('darre',),
'darrer': ('darre',),
'darres': ('darre',),
'darra': ('darre',),
'darret': ('darre',),
'darra': ('darre',),
'darret': ('darre',),
'darr': ('darre',),
'daske': ('daske',),
'dasker': ('daske',),
'daskes': ('daske',),
'daska': ('daske',),
'dasket': ('daske',),
'daska': ('daske',),
'dasket': ('daske',),
'dask': ('daske',),
'databehandle': ('databehandle',),
'databehandler': ('databehandle',),
'databehandles': ('databehandle',),
'databehandla': ('databehandle',),
'databehandlet': ('databehandle',),
'databehandla': ('databehandle',),
'databehandlet': ('databehandle',),
'databehandl': ('databehandle',),
'databehandle': ('databehandle',),
'databehandl': ('databehandle',),
'databehandle': ('databehandle',),
'dataføre': ('dataføre',),
'datafører': ('dataføre',),
'dataføres': ('dataføre',),
'dataførte': ('dataføre',),
'dataført': ('dataføre',),
'datafør': ('dataføre',),
'datastyre': ('datastyre',),
'datastyrer': ('datastyre',),
'datastyres': ('datastyre',),
'datastyrte': ('datastyre',),
'datastyrt': ('datastyre',),
'datastyr': ('datastyre',),
'datere': ('datere',),
'daterer': ('datere',),
'dateres': ('datere',),
'daterte': ('datere',),
'datert': ('datere',),
'dater': ('datere',),
'datostemple': ('datostemple',),
'datostempler': ('datostemple',),
'datostemples': ('datostemple',),
'datostempla': ('datostemple',),
'datostemplet': ('datostemple',),
'datostempla': ('datostemple',),
'datostemplet': ('datostemple',),
'datostempl': ('datostemple',),
'datostemple': ('datostemple',),
'datostempl': ('datostemple',),
'datostemple': ('datostemple',),
'daugjødsle': ('daugjødsle',),
'daugjødsler': ('daugjødsle',),
'daugjødsles': ('daugjødsle',),
'daugjødsla': ('daugjødsle',),
'daugjødslet': ('daugjødsle',),
'daugjødsla': ('daugjødsle',),
'daugjødslet': ('daugjødsle',),
'daugjødsl': ('daugjødsle',),
'daugjødsle': ('daugjødsle',),
'daugjødsl': ('daugjødsle',),
'daugjødsle': ('daugjødsle',),
'dauhogge': ('dauhogge',),
'dauhogger': ('dauhogge',),
'dauhogges': ('dauhogge',),
'dauhogde': ('dauhogge',),
'dauhogg': ('dauhogge',),
'dauhogd': ('dauhogge',),
'dauhogg': ('dauhogge',),
'dauhugge': ('dauhugge',),
'dauhugger': ('dauhugge',),
'dauhugges': ('dauhugge',),
'dauhugget': ('dauhugge',),
'dauhugde': ('dauhugge',),
'dauhugg': ('dauhugge',),
'dauhugget': ('dauhugge',),
'dauhugd': ('dauhugge',),
'dauhugg': ('dauhugge',),
'daukjøre': ('daukjøre',),
'daukjører': ('daukjøre',),
'daukjøres': ('daukjøre',),
'daukjørte': ('daukjøre',),
'daukjørt': ('daukjøre',),
'daukjør': ('daukjøre',),
'debattere': ('debattere',),
'debatterer': ('debattere',),
'debatteres': ('debattere',),
'debatterte': ('debattere',),
'debattert': ('debattere',),
'debatter': ('debattere',),
'debitere': ('debitere',),
'debiterer': ('debitere',),
'debiteres': ('debitere',),
'debiterte': ('debitere',),
'debitert': ('debitere',),
'debiter': ('debitere',),
'debutere': ('debutere',),
'debuterer': ('debutere',),
'debuteres': ('debutere',),
'debuterte': ('debutere',),
'debutert': ('debutere',),
'debuter': ('debutere',),
'dechiffrere': ('dechiffrere',),
'dechiffrerer': ('dechiffrere',),
'dechiffreres': ('dechiffrere',),
'dechiffrerte': ('dechiffrere',),
'dechiffrert': ('dechiffrere',),
'dechiffrer': ('dechiffrere',),
'dedisere': ('dedisere',),
'dediserer': ('dedisere',),
'dediseres': ('dedisere',),
'dediserte': ('dedisere',),
'dedisert': ('dedisere',),
'dediser': ('dedisere',),
'dedusere': ('dedusere',),
'deduserer': ('dedusere',),
'deduseres': ('dedusere',),
'deduserte': ('dedusere',),
'dedusert': ('dedusere',),
'deduser': ('dedusere',),
'defilere': ('defilere',),
'defilerer': ('defilere',),
'defileres': ('defilere',),
'defilerte': ('defilere',),
'defilert': ('defilere',),
'defiler': ('defilere',),
'definere': ('definere',),
'definerer': ('definere',),
'defineres': ('definere',),
'definerte': ('definere',),
'definert': ('definere',),
'definer': ('definere',),
'deflatere': ('deflatere',),
'deflaterer': ('deflatere',),
'deflateres': ('deflatere',),
'deflaterte': ('deflatere',),
'deflatert': ('deflatere',),
'deflater': ('deflatere',),
'deflorere': ('deflorere',),
'deflorerer': ('deflorere',),
'defloreres': ('deflorere',),
'deflorerte': ('deflorere',),
'deflorert': ('deflorere',),
'deflorer': ('deflorere',),
'deformere': ('deformere',),
'deformerer': ('deformere',),
'deformeres': ('deformere',),
'deformerte': ('deformere',),
'deformert': ('deformere',),
'deformer': ('deformere',),
'degenerere': ('degenerere',),
'degenererer': ('degenerere',),
'degenereres': ('degenerere',),
'degenererte': ('degenerere',),
'degenerert': ('degenerere',),
'degenerer': ('degenerere',),
'degge': ('degge',),
'degger': ('degge',),
'degges': ('degge',),
'degga': ('degge',),
'degget': ('degge',),
'degga': ('degge',),
'degget': ('degge',),
'degg': ('degge',),
'degradere': ('degradere',),
'degraderer': ('degradere',),
'degraderes': ('degradere',),
'degraderte': ('degradere',),
'degradert': ('degradere',),
'degrader': ('degradere',),
'dehydrere': ('dehydrere',),
'dehydrerer': ('dehydrere',),
'dehydreres': ('dehydrere',),
'dehydrerte': ('dehydrere',),
'dehydrert': ('dehydrere',),
'dehydrer': ('dehydrere',),
'deise': ('deise',),
'deiser': ('deise',),
'deises': ('deise',),
'deisa': ('deise',),
'deiset': ('deise',),
'deiste': ('deise',),
'deisa': ('deise',),
'deiset': ('deise',),
'deist': ('deise',),
'deis': ('deise',),
'dekantere': ('dekantere',),
'dekanterer': ('dekantere',),
'dekanteres': ('dekantere',),
'dekanterte': ('dekantere',),
'dekantert': ('dekantere',),
'dekanter': ('dekantere',),
'dekatere': ('dekatere',),
'dekaterer': ('dekatere',),
'dekateres': ('dekatere',),
'dekaterte': ('dekatere',),
'dekatert': ('dekatere',),
'dekater': ('dekatere',),
'dekke': ('dekke',),
'dekker': ('dekke',),
'dekkes': ('dekke',),
'dekka': ('dekke',),
'dekket': ('dekke',),
'dekte': ('dekke',),
'dekka': ('dekke',),
'dekket': ('dekke',),
'dekt': ('dekke',),
'dekk': ('dekke',),
'deklamere': ('deklamere',),
'deklamerer': ('deklamere',),
'deklameres': ('deklamere',),
'deklamerte': ('deklamere',),
'deklamert': ('deklamere',),
'deklamer': ('deklamere',),
'deklarere': ('deklarere',),
'deklarerer': ('deklarere',),
'deklareres': ('deklarere',),
'deklarerte': ('deklarere',),
'deklarert': ('deklarere',),
'deklarer': ('deklarere',),
'deklassere': ('deklassere',),
'deklasserer': ('deklassere',),
'deklasseres': ('deklassere',),
'deklasserte': ('deklassere',),
'deklassert': ('deklassere',),
'deklasser': ('deklassere',),
'deklinere': ('deklinere',),
'deklinerer': ('deklinere',),
'deklineres': ('deklinere',),
'deklinerte': ('deklinere',),
'deklinert': ('deklinere',),
'dekliner': ('deklinere',),
'dekode': ('dekode',),
'dekoder': ('dekode',),
'dekodes': ('dekode',),
'dekoda': ('dekode',),
'dekodet': ('dekode',),
'dekoda': ('dekode',),
'dekodet': ('dekode',),
'dekod': ('dekode',),
'dekomponere': ('dekomponere',),
'dekomponerer': ('dekomponere',),
'dekomponeres': ('dekomponere',),
'dekomponerte': ('dekomponere',),
'dekomponert': ('dekomponere',),
'dekomponer': ('dekomponere',),
'dekorere': ('dekorere',),
'dekorerer': ('dekorere',),
'dekoreres': ('dekorere',),
'dekorerte': ('dekorere',),
'dekorert': ('dekorere',),
'dekorer': ('dekorere',),
'dekortere': ('dekortere',),
'dekorterer': ('dekortere',),
'dekorteres': ('dekortere',),
'dekorterte': ('dekortere',),
'dekortert': ('dekortere',),
'dekorter': ('dekortere',),
'dekretere': ('dekretere',),
'dekreterer': ('dekretere',),
'dekreteres': ('dekretere',),
'dekreterte': ('dekretere',),
'dekretert': ('dekretere',),
'dekreter': ('dekretere',),
'dekupere': ('dekupere',),
'dekuperer': ('dekupere',),
'dekuperes': ('dekupere',),
'dekuperte': ('dekupere',),
'dekupert': ('dekupere',),
'dekuper': ('dekupere',),
'delabialisere': ('delabialisere',),
'delabialiserer': ('delabialisere',),
'delabialiseres': ('delabialisere',),
'delabialiserte': ('delabialisere',),
'delabialisert': ('delabialisere',),
'delabialiser': ('delabialisere',),
'dele': ('dele',),
'deler': ('dele',),
'deles': ('dele',),
'delte': ('dele',),
'delt': ('dele',),
'del': ('dele',),
'delegere': ('delegere',),
'delegerer': ('delegere',),
'delegeres': ('delegere',),
'delegerte': ('delegere',),
'delegert': ('delegere',),
'deleger': ('delegere',),
'delere': ('delere',),
'delerer': ('delere',),
'deleres': ('delere',),
'delerte': ('delere',),
'delert': ('delere',),
'deler': ('delere',),
'delikatere': ('delikatere',),
'delikaterer': ('delikatere',),
'delikateres': ('delikatere',),
'delikaterte': ('delikatere',),
'delikatert': ('delikatere',),
'delikater': ('delikatere',),
'delirere': ('delirere',),
'delirerer': ('delirere',),
'delireres': ('delirere',),
'delirerte': ('delirere',),
'delirert': ('delirere',),
'delirer': ('delirere',),
'delje': ('delje',),
'deljer': ('delje',),
'deljes': ('delje',),
'delja': ('delje',),
'deljet': ('delje',),
'delja': ('delje',),
'deljet': ('delje',),
'delj': ('delje',),
'delta': ('delta',),
'deltar': ('delta',),
'deltas': ('delta',),
'deltok': ('delta',),
'deltatt': ('delta',),
'delta': ('delta',),
'demaskere': ('demaskere',),
'demaskerer': ('demaskere',),
'demaskeres': ('demaskere',),
'demaskerte': ('demaskere',),
'demaskert': ('demaskere',),
'demasker': ('demaskere',),
'dementere': ('dementere',),
'dementerer': ('dementere',),
'dementeres': ('dementere',),
'dementerte': ('dementere',),
'dementert': ('dementere',),
'dementer': ('dementere',),
'demilitarisere': ('demilitarisere',),
'demilitariserer': ('demilitarisere',),
'demilitariseres': ('demilitarisere',),
'demilitariserte': ('demilitarisere',),
'demilitarisert': ('demilitarisere',),
'demilitariser': ('demilitarisere',),
'demisjonere': ('demisjonere',),
'demisjonerer': ('demisjonere',),
'demisjoneres': ('demisjonere',),
'demisjonerte': ('demisjonere',),
'demisjonert': ('demisjonere',),
'demisjoner': ('demisjonere',),
'demme': ('demme',),
'demmer': ('demme',),
'demmes': ('demme',),
'demmet': ('demme',),
'demte': ('demme',),
'demmet': ('demme',),
'demt': ('demme',),
'dem': ('demme',),
'demobilisere': ('demobilisere',),
'demobiliserer': ('demobilisere',),
'demobiliseres': ('demobilisere',),
'demobiliserte': ('demobilisere',),
'demobilisert': ('demobilisere',),
'demobiliser': ('demobilisere',),
'demokratisere': ('demokratisere',),
'demokratiserer': ('demokratisere',),
'demokratiseres': ('demokratisere',),
'demokratiserte': ('demokratisere',),
'demokratisert': ('demokratisere',),
'demokratiser': ('demokratisere',),
'demolere': ('demolere',),
'demolerer': ('demolere',),
'demoleres': ('demolere',),
'demolerte': ('demolere',),
'demolert': ('demolere',),
'demoler': ('demolere',),
'demonstrere': ('demonstrere',),
'demonstrerer': ('demonstrere',),
'demonstreres': ('demonstrere',),
'demonstrerte': ('demonstrere',),
'demonstrert': ('demonstrere',),
'demonstrer': ('demonstrere',),
'demontere': ('demontere',),
'demonterer': ('demontere',),
'demonteres': ('demontere',),
'demonterte': ('demontere',),
'demontert': ('demontere',),
'demonter': ('demontere',),
'demoralisere': ('demoralisere',),
'demoraliserer': ('demoralisere',),
'demoraliseres': ('demoralisere',),
'demoraliserte': ('demoralisere',),
'demoralisert': ('demoralisere',),
'demoraliser': ('demoralisere',),
'dempe': ('dempe',),
'demper': ('dempe',),
'dempes': ('dempe',),
'dempa': ('dempe',),
'dempet': ('dempe',),
'dempa': ('dempe',),
'dempet': ('dempe',),
'demp': ('dempe',),
'demre': ('demre',),
'demrer': ('demre',),
'demres': ('demre',),
'demra': ('demre',),
'demret': ('demre',),
'demra': ('demre',),
'demret': ('demre',),
'demr': ('demre',),
'demre': ('demre',),
'demr': ('demre',),
'demre': ('demre',),
'denasjonalisere': ('denasjonalisere',),
'denasjonaliserer': ('denasjonalisere',),
'denasjonaliseres': ('denasjonalisere',),
'denasjonaliserte': ('denasjonalisere',),
'denasjonalisert': ('denasjonalisere',),
'denasjonaliser': ('denasjonalisere',),
'denaturalisere': ('denaturalisere',),
'denaturaliserer': ('denaturalisere',),
'denaturaliseres': ('denaturalisere',),
'denaturaliserte': ('denaturalisere',),
'denaturalisert': ('denaturalisere',),
'denaturaliser': ('denaturalisere',),
'denaturere': ('denaturere',),
'denaturerer': ('denaturere',),
'denatureres': ('denaturere',),
'denaturerte': ('denaturere',),
'denaturert': ('denaturere',),
'denaturer': ('denaturere',),
'denge': ('denge',),
'denger': ('denge',),
'denges': ('denge',),
'dengte': ('denge',),
'dengt': ('denge',),
'deng': ('denge',),
'denotere': ('denotere',),
'denoterer': ('denotere',),
'denoteres': ('denotere',),
'denoterte': ('denotere',),
'denotert': ('denotere',),
'denoter': ('denotere',),
'denudere': ('denudere',),
'denuderer': ('denudere',),
'denuderes': ('denudere',),
'denuderte': ('denudere',),
'denudert': ('denudere',),
'denuder': ('denudere',),
'deoksidere': ('deoksidere',),
'deoksiderer': ('deoksidere',),
'deoksideres': ('deoksidere',),
'deoksiderte': ('deoksidere',),
'deoksidert': ('deoksidere',),
'deoksider': ('deoksidere',),
'deponere': ('deponere',),
'deponerer': ('deponere',),
'deponeres': ('deponere',),
'deponerte': ('deponere',),
'deponert': ('deponere',),
'deponer': ('deponere',),
'deportere': ('deportere',),
'deporterer': ('deportere',),
'deporteres': ('deportere',),
'deporterte': ('deportere',),
'deportert': ('deportere',),
'deporter': ('deportere',),
'deppe': ('deppe',),
'depper': ('deppe',),
'deppes': ('deppe',),
'deppa': ('deppe',),
'deppet': ('deppe',),
'deppa': ('deppe',),
'deppet': ('deppe',),
'depp': ('deppe',),
'depravere': ('depravere',),
'depraverer': ('depravere',),
'depraveres': ('depravere',),
'depraverte': ('depravere',),
'depravert': ('depravere',),
'depraver': ('depravere',),
'deprimere': ('deprimere',),
'deprimerer': ('deprimere',),
'deprimeres': ('deprimere',),
'deprimerte': ('deprimere',),
'deprimert': ('deprimere',),
'deprimer': ('deprimere',),
'deprivatisere': ('deprivatisere',),
'deprivatiserer': ('deprivatisere',),
'deprivatiseres': ('deprivatisere',),
'deprivatiserte': ('deprivatisere',),
'deprivatisert': ('deprivatisere',),
'deprivatiser': ('deprivatisere',),
'derangere': ('derangere',),
'derangerer': ('derangere',),
'derangeres': ('derangere',),
'derangerte': ('derangere',),
'derangert': ('derangere',),
'deranger': ('derangere',),
'derelinkvere': ('derelinkvere',),
'derelinkverer': ('derelinkvere',),
'derelinkveres': ('derelinkvere',),
'derelinkverte': ('derelinkvere',),
'derelinkvert': ('derelinkvere',),
'derelinkver': ('derelinkvere',),
'derivere': ('derivere',),
'deriverer': ('derivere',),
'deriveres': ('derivere',),
'deriverte': ('derivere',),
'derivert': ('derivere',),
'deriver': ('derivere',),
'desarmere': ('desarmere',),
'desarmerer': ('desarmere',),
'desarmeres': ('desarmere',),
'desarmerte': ('desarmere',),
'desarmert': ('desarmere',),
'desarmer': ('desarmere',),
'desavuere': ('desavuere',),
'desavuerer': ('desavuere',),
'desavueres': ('desavuere',),
'desavuerte': ('desavuere',),
'desavuert': ('desavuere',),
'desavuer': ('desavuere',),
'desentralisere': ('desentralisere',),
'desentraliserer': ('desentralisere',),
'desentraliseres': ('desentralisere',),
'desentraliserte': ('desentralisere',),
'desentralisert': ('desentralisere',),
'desentraliser': ('desentralisere',),
'desertere': ('desertere',),
'deserterer': ('desertere',),
'deserteres': ('desertere',),
'deserterte': ('desertere',),
'desertert': ('desertere',),
'deserter': ('desertere',),
'desidere': ('desidere',),
'desiderer': ('desidere',),
'desideres': ('desidere',),
'desiderte': ('desidere',),
'desidert': ('desidere',),
'desider': ('desidere',),
'designe': ('designe',),
'designer': ('designe',),
'designes': ('designe',),
'designa': ('designe',),
'designet': ('designe',),
'designa': ('designe',),
'designet': ('designe',),
'design': ('designe',),
'desillusjonere': ('desillusjonere',),
'desillusjonerer': ('desillusjonere',),
'desillusjoneres': ('desillusjonere',),
'desillusjonerte': ('desillusjonere',),
'desillusjonert': ('desillusjonere',),
'desillusjoner': ('desillusjonere',),
'desimere': ('desimere',),
'desimerer': ('desimere',),
'desimeres': ('desimere',),
'desimerte': ('desimere',),
'desimert': ('desimere',),
'desimer': ('desimere',),
'desinfisere': ('desinfisere',),
'desinfiserer': ('desinfisere',),
'desinfiseres': ('desinfisere',),
'desinfiserte': ('desinfisere',),
'desinfisert': ('desinfisere',),
'desinfiser': ('desinfisere',),
'desinformere': ('desinformere',),
'desinformerer': ('desinformere',),
'desinformeres': ('desinformere',),
'desinformerte': ('desinformere',),
'desinformert': ('desinformere',),
'desinformer': ('desinformere',),
'desintegrere': ('desintegrere',),
'desintegrerer': ('desintegrere',),
'desintegreres': ('desintegrere',),
'desintegrerte': ('desintegrere',),
'desintegrert': ('desintegrere',),
'desintegrer': ('desintegrere',),
'desoksidere': ('desoksidere',),
'desoksiderer': ('desoksidere',),
'desoksideres': ('desoksidere',),
'desoksiderte': ('desoksidere',),
'desoksidert': ('desoksidere',),
'desoksider': ('desoksidere',),
'desorganisere': ('desorganisere',),
'desorganiserer': ('desorganisere',),
'desorganiseres': ('desorganisere',),
'desorganiserte': ('desorganisere',),
'desorganisert': ('desorganisere',),
'desorganiser': ('desorganisere',),
'desorientere': ('desorientere',),
'desorienterer': ('desorientere',),
'desorienteres': ('desorientere',),
'desorienterte': ('desorientere',),
'desorientert': ('desorientere',),
'desorienter': ('desorientere',),
'destillere': ('destillere',),
'destillerer': ('destillere',),
'destilleres': ('destillere',),
'destillerte': ('destillere',),
'destillert': ('destillere',),
'destiller': ('destillere',),
'destruere': ('destruere',),
'destruerer': ('destruere',),
'destrueres': ('destruere',),
'destruerte': ('destruere',),
'destruert': ('destruere',),
'destruer': ('destruere',),
'detaljbehandle': ('detaljbehandle',),
'detaljbehandler': ('detaljbehandle',),
'detaljbehandles': ('detaljbehandle',),
'detaljbehandla': ('detaljbehandle',),
'detaljbehandlet': ('detaljbehandle',),
'detaljbehandla': ('detaljbehandle',),
'detaljbehandlet': ('detaljbehandle',),
'detaljbehandl': ('detaljbehandle',),
'detaljbehandle': ('detaljbehandle',),
'detaljbehandl': ('detaljbehandle',),
'detaljbehandle': ('detaljbehandle',),
'detaljere': ('detaljere',),
'detaljerer': ('detaljere',),
'detaljeres': ('detaljere',),
'detaljerte': ('detaljere',),
'detaljert': ('detaljere',),
'detaljer': ('detaljere',),
'detasjere': ('detasjere',),
'detasjerer': ('detasjere',),
'detasjeres': ('detasjere',),
'detasjerte': ('detasjere',),
'detasjert': ('detasjere',),
'detasjer': ('detasjere',),
'determinere': ('determinere',),
'determinerer': ('determinere',),
'determineres': ('determinere',),
'determinerte': ('determinere',),
'determinert': ('determinere',),
'determiner': ('determinere',),
'detonere': ('detonere',),
'detonerer': ('detonere',),
'detoneres': ('detonere',),
'detonerte': ('detonere',),
'detonert': ('detonere',),
'detoner': ('detonere',),
'detronisere': ('detronisere',),
'detroniserer': ('detronisere',),
'detroniseres': ('detronisere',),
'detroniserte': ('detronisere',),
'detronisert': ('detronisere',),
'detroniser': ('detronisere',),
'dette': ('dette',),
'detter': ('dette',),
'dettes': ('dette',),
'datt': ('dette',),
'dettet': ('dette',),
'dett': ('dette',),
'devaluere': ('devaluere',),
'devaluerer': ('devaluere',),
'devalueres': ('devaluere',),
'devaluerte': ('devaluere',),
'devaluert': ('devaluere',),
'devaluer': ('devaluere',),
'deviere': ('deviere',),
'devierer': ('deviere',),
'devieres': ('deviere',),
'devierte': ('deviere',),
'deviert': ('deviere',),
'devier': ('deviere',),
'diagnostisere': ('diagnostisere',),
'diagnostiserer': ('diagnostisere',),
'diagnostiseres': ('diagnostisere',),
'diagnostiserte': ('diagnostisere',),
'diagnostisert': ('diagnostisere',),
'diagnostiser': ('diagnostisere',),
'dialysere': ('dialysere',),
'dialyserer': ('dialysere',),
'dialyseres': ('dialysere',),
'dialyserte': ('dialysere',),
'dialysert': ('dialysere',),
'dialyser': ('dialysere',),
'die': ('die',),
'dier': ('die',),
'dies': ('die',),
'dia': ('die',),
'diet': ('die',),
'dia': ('die',),
'diet': ('die',),
'di': ('die',),
'differensiere': ('differensiere',),
'differensierer': ('differensiere',),
'differensieres': ('differensiere',),
'differensierte': ('differensiere',),
'differensiert': ('differensiere',),
'differensier': ('differensiere',),
'differere': ('differere',),
'differerer': ('differere',),
'differeres': ('differere',),
'differerte': ('differere',),
'differert': ('differere',),
'differer': ('differere',),
'diffundere': ('diffundere',),
'diffunderer': ('diffundere',),
'diffunderes': ('diffundere',),
'diffunderte': ('diffundere',),
'diffundert': ('diffundere',),
'diffunder': ('diffundere',),
'diftongere': ('diftongere',),
'diftongerer': ('diftongere',),
'diftongeres': ('diftongere',),
'diftongerte': ('diftongere',),
'diftongert': ('diftongere',),
'diftonger': ('diftongere',),
'digge': ('digge',),
'digger': ('digge',),
'digges': ('digge',),
'digga': ('digge',),
'digget': ('digge',),
'digga': ('digge',),
'digget': ('digge',),
'digg': ('digge',),
'digitalisere': ('digitalisere',),
'digitaliserer': ('digitalisere',),
'digitaliseres': ('digitalisere',),
'digitaliserte': ('digitalisere',),
'digitalisert': ('digitalisere',),
'digitaliser': ('digitalisere',),
'dikke': ('dikke',),
'dikker': ('dikke',),
'dikkes': ('dikke',),
'dikka': ('dikke',),
'dikket': ('dikke',),
'dikka': ('dikke',),
'dikket': ('dikke',),
'dikk': ('dikke',),
'dikte': ('dikte',),
'dikter': ('dikte',),
'diktes': ('dikte',),
'dikta': ('dikte',),
'diktet': ('dikte',),
'dikta': ('dikte',),
'diktet': ('dikte',),
'dikt': ('dikte',),
'diktere': ('diktere',),
'dikterer': ('diktere',),
'dikteres': ('diktere',),
'dikterte': ('diktere',),
'diktert': ('diktere',),
'dikter': ('diktere',),
'dille': ('dille',),
'diller': ('dille',),
'dilles': ('dille',),
'dilla': ('dille',),
'dillet': ('dille',),
'dilla': ('dille',),
'dillet': ('dille',),
'dill': ('dille',),
'dilte': ('dilte',),
'dilter': ('dilte',),
'diltes': ('dilte',),
'dilta': ('dilte',),
'diltet': ('dilte',),
'dilta': ('dilte',),
'diltet': ('dilte',),
'dilt': ('dilte',),
'dimensjonere': ('dimensjonere',),
'dimensjonerer': ('dimensjonere',),
'dimensjoneres': ('dimensjonere',),
'dimensjonerte': ('dimensjonere',),
'dimensjonert': ('dimensjonere',),
'dimensjoner': ('dimensjonere',),
'dimittere': ('dimittere',),
'dimitterer': ('dimittere',),
'dimitteres': ('dimittere',),
'dimitterte': ('dimittere',),
'dimittert': ('dimittere',),
'dimitter': ('dimittere',),
'dimme': ('dimme',),
'dimmer': ('dimme',),
'dimmes': ('dimme',),
'dimma': ('dimme',),
'dimmet': ('dimme',),
'dimma': ('dimme',),
'dimmet': ('dimme',),
'dim': ('dimme',),
'dimme': ('dimme',),
'dimmer': ('dimme',),
'dimmes': ('dimme',),
'dimte': ('dimme',),
'dimt': ('dimme',),
'dim': ('dimme',),
'dinere': ('dinere',),
'dinerer': ('dinere',),
'dineres': ('dinere',),
'dinerte': ('dinere',),
'dinert': ('dinere',),
'diner': ('dinere',),
'dingle': ('dingle',),
'dingler': ('dingle',),
'dingles': ('dingle',),
'dingla': ('dingle',),
'dinglet': ('dingle',),
'dingla': ('dingle',),
'dinglet': ('dingle',),
'dingl': ('dingle',),
'dingle': ('dingle',),
'dingl': ('dingle',),
'dingle': ('dingle',),
'dirigere': ('dirigere',),
'dirigerer': ('dirigere',),
'dirigeres': ('dirigere',),
'dirigerte': ('dirigere',),
'dirigert': ('dirigere',),
'diriger': ('dirigere',),
'dirke': ('dirke',),
'dirker': ('dirke',),
'dirkes': ('dirke',),
'dirka': ('dirke',),
'dirket': ('dirke',),
'dirka': ('dirke',),
'dirket': ('dirke',),
'dirk': ('dirke',),
'dirre': ('dirre',),
'dirrer': ('dirre',),
'dirres': ('dirre',),
'dirra': ('dirre',),
'dirret': ('dirre',),
'dirra': ('dirre',),
'dirret': ('dirre',),
'dirr': ('dirre',),
'disiplinere': ('disiplinere',),
'disiplinerer': ('disiplinere',),
'disiplineres': ('disiplinere',),
'disiplinerte': ('disiplinere',),
'disiplinert': ('disiplinere',),
'disipliner': ('disiplinere',),
'diske': ('diske',),
'disker': ('diske',),
'diskes': ('diske',),
'diska': ('diske',),
'disket': ('diske',),
'diska': ('diske',),
'disket': ('diske',),
'disk': ('diske',),
'diskontere': ('diskontere',),
'diskonterer': ('diskontere',),
'diskonteres': ('diskontere',),
'diskonterte': ('diskontere',),
'diskontert': ('diskontere',),
'diskonter': ('diskontere',),
'diskreditere': ('diskreditere',),
'diskrediterer': ('diskreditere',),
'diskrediteres': ('diskreditere',),
'diskrediterte': ('diskreditere',),
'diskreditert': ('diskreditere',),
'diskrediter': ('diskreditere',),
'diskriminere': ('diskriminere',),
'diskriminerer': ('diskriminere',),
'diskrimineres': ('diskriminere',),
'diskriminerte': ('diskriminere',),
'diskriminert': ('diskriminere',),
'diskriminer': ('diskriminere',),
'diskutere': ('diskutere',),
'diskuterer': ('diskutere',),
'diskuteres': ('diskutere',),
'diskuterte': ('diskutere',),
'diskutert': ('diskutere',),
'diskuter': ('diskutere',),
'diskvalifisere': ('diskvalifisere',),
'diskvalifiserer': ('diskvalifisere',),
'diskvalifiseres': ('diskvalifisere',),
'diskvalifiserte': ('diskvalifisere',),
'diskvalifisert': ('diskvalifisere',),
'diskvalifiser': ('diskvalifisere',),
'dispasjere': ('dispasjere',),
'dispasjerer': ('dispasjere',),
'dispasjeres': ('dispasjere',),
'dispasjerte': ('dispasjere',),
'dispasjert': ('dispasjere',),
'dispasjer': ('dispasjere',),
'dispensere': ('dispensere',),
'dispenserer': ('dispensere',),
'dispenseres': ('dispensere',),
'dispenserte': ('dispensere',),
'dispensert': ('dispensere',),
'dispenser': ('dispensere',),
'disponere': ('disponere',),
'disponerer': ('disponere',),
'disponeres': ('disponere',),
'disponerte': ('disponere',),
'disponert': ('disponere',),
'disponer': ('disponere',),
'disputere': ('disputere',),
'disputerer': ('disputere',),
'disputeres': ('disputere',),
'disputerte': ('disputere',),
'disputert': ('disputere',),
'disputer': ('disputere',),
'disse': ('disse',),
'disser': ('disse',),
'disses': ('disse',),
'dissa': ('disse',),
'disset': ('disse',),
'dissa': ('disse',),
'disset': ('disse',),
'diss': ('disse',),
'dissekere': ('dissekere',),
'dissekerer': ('dissekere',),
'dissekeres': ('dissekere',),
'dissekerte': ('dissekere',),
'dissekert': ('dissekere',),
'disseker': ('dissekere',),
'dissentere': ('dissentere',),
'dissenterer': ('dissentere',),
'dissenteres': ('dissentere',),
'dissenterte': ('dissentere',),
'dissentert': ('dissentere',),
'dissenter': ('dissentere',),
'dissimilere': ('dissimilere',),
'dissimilerer': ('dissimilere',),
'dissimileres': ('dissimilere',),
'dissimilerte': ('dissimilere',),
'dissimilert': ('dissimilere',),
'dissimiler': ('dissimilere',),
'dissonere': ('dissonere',),
'dissonerer': ('dissonere',),
'dissoneres': ('dissonere',),
'dissonerte': ('dissonere',),
'dissonert': ('dissonere',),
'dissoner': ('dissonere',),
'dissosiere': ('dissosiere',),
'dissosierer': ('dissosiere',),
'dissosieres': ('dissosiere',),
'dissosierte': ('dissosiere',),
'dissosiert': ('dissosiere',),
'dissosier': ('dissosiere',),
'distansere': ('distansere',),
'distanserer': ('distansere',),
'distanseres': ('distansere',),
'distanserte': ('distansere',),
'distansert': ('distansere',),
'distanser': ('distansere',),
'distingvere': ('distingvere',),
'distingverer': ('distingvere',),
'distingveres': ('distingvere',),
'distingverte': ('distingvere',),
'distingvert': ('distingvere',),
'distingver': ('distingvere',),
'distrahere': ('distrahere',),
'distraherer': ('distrahere',),
'distraheres': ('distrahere',),
'distraherte': ('distrahere',),
'distrahert': ('distrahere',),
'distraher': ('distrahere',),
'distribuere': ('distribuere',),
'distribuerer': ('distribuere',),
'distribueres': ('distribuere',),
'distribuerte': ('distribuere',),
'distribuert': ('distribuere',),
'distribuer': ('distribuere',),
'divergere': ('divergere',),
'divergerer': ('divergere',),
'divergeres': ('divergere',),
'divergerte': ('divergere',),
'divergert': ('divergere',),
'diverger': ('divergere',),
'divertere': ('divertere',),
'diverterer': ('divertere',),
'diverteres': ('divertere',),
'diverterte': ('divertere',),
'divertert': ('divertere',),
'diverter': ('divertere',),
'dividere': ('dividere',),
'dividerer': ('dividere',),
'divideres': ('dividere',),
'dividerte': ('dividere',),
'dividert': ('dividere',),
'divider': ('dividere',),
'djupetse': ('djupetse',),
'djupetser': ('djupetse',),
'djupetses': ('djupetse',),
'djupetsa': ('djupetse',),
'djupetset': ('djupetse',),
'djupetsa': ('djupetse',),
'djupetset': ('djupetse',),
'djupets': ('djupetse',),
'djupfryse': ('djupfryse',),
'djupfryser': ('djupfryse',),
'djupfryses': ('djupfryse',),
'djupfryste': ('djupfryse',),
'djupfryst': ('djupfryse',),
'djupfrys': ('djupfryse',),
'djupne': ('djupne',),
'djupner': ('djupne',),
'djupnes': ('djupne',),
'djupna': ('djupne',),
'djupnet': ('djupne',),
'djupna': ('djupne',),
'djupnet': ('djupne',),
'djupn': ('djupne',),
'djupne': ('djupne',),
'djupn': ('djupne',),
'djupne': ('djupne',),
'doble': ('doble',),
'dobler': ('doble',),
'dobles': ('doble',),
'dobla': ('doble',),
'doblet': ('doble',),
'dobla': ('doble',),
'doblet': ('doble',),
'dobl': ('doble',),
'doble': ('doble',),
'dobl': ('doble',),
'doble': ('doble',),
'dogge': ('dogge',),
'dogger': ('dogge',),
'dogges': ('dogge',),
'dogga': ('dogge',),
'dogget': ('dogge',),
'dogga': ('dogge',),
'dogget': ('dogge',),
'dogg': ('dogge',),
'dokke': ('dokke',),
'dokker': ('dokke',),
'dokkes': ('dokke',),
'dokka': ('dokke',),
'dokket': ('dokke',),
'dokka': ('dokke',),
'dokket': ('dokke',),
'dokk': ('dokke',),
'dokksette': ('dokksette',),
'dokksetter': ('dokksette',),
'dokksettes': ('dokksette',),
'dokksatte': ('dokksette',),
'dokksatt': ('dokksette',),
'dokksett': ('dokksette',),
'doktorere': ('doktorere',),
'doktorerer': ('doktorere',),
'doktoreres': ('doktorere',),
'doktorerte': ('doktorere',),
'doktorert': ('doktorere',),
'doktorer': ('doktorere',),
'dokumentere': ('dokumentere',),
'dokumenterer': ('dokumentere',),
'dokumenteres': ('dokumentere',),
'dokumenterte': ('dokumentere',),
'dokumentert': ('dokumentere',),
'dokumenter': ('dokumentere',),
'dolke': ('dolke',),
'dolker': ('dolke',),
'dolkes': ('dolke',),
'dolka': ('dolke',),
'dolket': ('dolke',),
'dolka': ('dolke',),
'dolket': ('dolke',),
'dolk': ('dolke',),
'domfelle': ('domfelle',),
'domfeller': ('domfelle',),
'domfelles': ('domfelle',),
'domfelte': ('domfelle',),
'domfelt': ('domfelle',),
'domfell': ('domfelle',),
'dominere': ('dominere',),
'dominerer': ('dominere',),
'domineres': ('dominere',),
'dominerte': ('dominere',),
'dominert': ('dominere',),
'dominer': ('dominere',),
'domisiliere': ('domisiliere',),
'domisilierer': ('domisiliere',),
'domisilieres': ('domisiliere',),
'domisilierte': ('domisiliere',),
'domisiliert': ('domisiliere',),
'domisilier': ('domisiliere',),
'donere': ('donere',),
'donerer': ('donere',),
'doneres': ('donere',),
'donerte': ('donere',),
'donert': ('donere',),
'doner': ('donere',),
'dope': ('dope',),
'doper': ('dope',),
'dopes': ('dope',),
'dopa': ('dope',),
'dopet': ('dope',),
'dopa': ('dope',),
'dopet': ('dope',),
'dop': ('dope',),
'dore': ('dore',),
'dorer': ('dore',),
'dores': ('dore',),
'dora': ('dore',),
'doret': ('dore',),
'dorte': ('dore',),
'dora': ('dore',),
'doret': ('dore',),
'dort': ('dore',),
'dor': ('dore',),
'dorge': ('dorge',),
'dorger': ('dorge',),
'dorges': ('dorge',),
'dorga': ('dorge',),
'dorget': ('dorge',),
'dorga': ('dorge',),
'dorget': ('dorge',),
'dorg': ('dorge',),
'dorme': ('dorme',),
'dormer': ('dorme',),
'dormes': ('dorme',),
'dorma': ('dorme',),
'dormet': ('dorme',),
'dorma': ('dorme',),
'dormet': ('dorme',),
'dorm': ('dorme',),
'dosere': ('dosere',),
'doserer': ('dosere',),
'doseres': ('dosere',),
'doserte': ('dosere',),
'dosert': ('dosere',),
'doser': ('dosere',),
'dossere': ('dossere',),
'dosserer': ('dossere',),
'dosseres': ('dossere',),
'dosserte': ('dossere',),
'dossert': ('dossere',),
'dosser': ('dossere',),
'dotere': ('dotere',),
'doterer': ('dotere',),
'doteres': ('dotere',),
'doterte': ('dotere',),
'dotert': ('dotere',),
'doter': ('dotere',),
'dovne': ('dovne',),
'dovner': ('dovne',),
'dovnes': ('dovne',),
'dovna': ('dovne',),
'dovnet': ('dovne',),
'dovna': ('dovne',),
'dovnet': ('dovne',),
'dovn': ('dovne',),
'dovne': ('dovne',),
'dovn': ('dovne',),
'dovne': ('dovne',),
'drages': ('drages',),
'droges': ('drages',),
'drages': ('drages',),
'droges': ('drages',),
'dragse': ('dragse',),
'dragser': ('dragse',),
'dragses': ('dragse',),
'dragsa': ('dragse',),
'dragset': ('dragse',),
'dragsa': ('dragse',),
'dragset': ('dragse',),
'drags': ('dragse',),
'dramatisere': ('dramatisere',),
'dramatiserer': ('dramatisere',),
'dramatiseres': ('dramatisere',),
'dramatiserte': ('dramatisere',),
'dramatisert': ('dramatisere',),
'dramatiser': ('dramatisere',),
'drapere': ('drapere',),
'draperer': ('drapere',),
'draperes': ('drapere',),
'draperte': ('drapere',),
'drapert': ('drapere',),
'draper': ('drapere',),
'dras': ('dras',),
'drogs': ('dras',),
'dros': ('dras',),
'dras': ('dras',),
'dros': ('dras',),
'drogs': ('dras',),
'dras': ('dras',),
'drasjere': ('drasjere',),
'drasjerer': ('drasjere',),
'drasjeres': ('drasjere',),
'drasjerte': ('drasjere',),
'drasjert': ('drasjere',),
'drasjer': ('drasjere',),
'drasse': ('drasse',),
'drasser': ('drasse',),
'drasses': ('drasse',),
'drassa': ('drasse',),
'drasset': ('drasse',),
'drassa': ('drasse',),
'drasset': ('drasse',),
'drass': ('drasse',),
'dratte': ('dratte',),
'dratter': ('dratte',),
'drattes': ('dratte',),
'dratta': ('dratte',),
'drattet': ('dratte',),
'dratta': ('dratte',),
'drattet': ('dratte',),
'dratt': ('dratte',),
'dregge': ('dregge',),
'dregger': ('dregge',),
'dregges': ('dregge',),
'dregga': ('dregge',),
'dregget': ('dregge',),
'dregga': ('dregge',),
'dregget': ('dregge',),
'dregg': ('dregge',),
'dreie': ('dreie',),
'dreier': ('dreie',),
'dreies': ('dreie',),
'dreia': ('dreie',),
'dreiet': ('dreie',),
'dreide': ('dreie',),
'dreia': ('dreie',),
'dreiet': ('dreie',),
'dreid': ('dreie',),
'drei': ('dreie',),
'dreise': ('dreise',),
'dreiser': ('dreise',),
'dreises': ('dreise',),
'dreiste': ('dreise',),
'dreist': ('dreise',),
'dreis': ('dreise',),
'drene': ('drene',),
'drener': ('drene',),
'drenes': ('drene',),
'drente': ('drene',),
'drent': ('drene',),
'dren': ('drene',),
'drenere': ('drenere',),
'drenerer': ('drenere',),
'dreneres': ('drenere',),
'drenerte': ('drenere',),
'drenert': ('drenere',),
'drener': ('drenere',),
'drepe': ('drepe',),
'dreper': ('drepe',),
'drepes': ('drepe',),
'drepte': ('drepe',),
'drept': ('drepe',),
'drep': ('drepe',),
'dresse': ('dresse',),
'dresser': ('dresse',),
'dresses': ('dresse',),
'dressa': ('dresse',),
'dresset': ('dresse',),
'dressa': ('dresse',),
'dresset': ('dresse',),
'dress': ('dresse',),
'dressere': ('dressere',),
'dresserer': ('dressere',),
'dresseres': ('dressere',),
'dresserte': ('dressere',),
'dressert': ('dressere',),
'dresser': ('dressere',),
'drette': ('drette',),
'dretter': ('drette',),
'drettes': ('drette',),
'dretta': ('drette',),
'drettet': ('drette',),
'dretta': ('drette',),
'drettet': ('drette',),
'drett': ('drette',),
'drible': ('drible',),
'dribler': ('drible',),
'dribles': ('drible',),
'dribla': ('drible',),
'driblet': ('drible',),
'dribla': ('drible',),
'driblet': ('drible',),
'dribl': ('drible',),
'drible': ('drible',),
'dribl': ('drible',),
'drible': ('drible',),
'drifte': ('drifte',),
'drifter': ('drifte',),
'driftes': ('drifte',),
'drifta': ('drifte',),
'driftet': ('drifte',),
'drifta': ('drifte',),
'driftet': ('drifte',),
'drift': ('drifte',),
'drikke': ('drikke',),
'drikker': ('drikke',),
'drikkes': ('drikke',),
'drakk': ('drikke',),
'drukket': ('drikke',),
'drikk': ('drikke',),
'drille': ('drille',),
'driller': ('drille',),
'drilles': ('drille',),
'drilla': ('drille',),
'drillet': ('drille',),
'drilla': ('drille',),
'drillet': ('drille',),
'drill': ('drille',),
'drille': ('drille',),
'driller': ('drille',),
'drilles': ('drille',),
'drilla': ('drille',),
'drillet': ('drille',),
'drilte': ('drille',),
'drilla': ('drille',),
'drillet': ('drille',),
'drilt': ('drille',),
'drill': ('drille',),
'driste': ('driste',),
'drister': ('driste',),
'dristes': ('driste',),
'drista': ('driste',),
'dristet': ('driste',),
'drista': ('driste',),
'dristet': ('driste',),
'drist': ('driste',),
'drite': ('drite',),
'driter': ('drite',),
'drites': ('drite',),
'dreit': ('drite',),
'dret': ('drite',),
'dreit': ('drite',),
'dret': ('drite',),
'dreit': ('drite',),
'dritt': ('drite',),
'dritet': ('drite',),
'drit': ('drite',),
'drive': ('drive',),
'driver': ('drive',),
'drives': ('drive',),
'drev': ('drive',),
'dreiv': ('drive',),
'drev': ('drive',),
'dreiv': ('drive',),
'drevet': ('drive',),
'driv': ('drive',),
'drodle': ('drodle',),
'drodler': ('drodle',),
'drodles': ('drodle',),
'drodla': ('drodle',),
'drodlet': ('drodle',),
'drodla': ('drodle',),
'drodlet': ('drodle',),
'drodl': ('drodle',),
'drodle': ('drodle',),
'drodl': ('drodle',),
'drodle': ('drodle',),
'droppe': ('droppe',),
'dropper': ('droppe',),
'droppes': ('droppe',),
'droppa': ('droppe',),
'droppet': ('droppe',),
'droppa': ('droppe',),
'droppet': ('droppe',),
'dropp': ('droppe',),
'drukne': ('drukne',),
'drukner': ('drukne',),
'druknes': ('drukne',),
'drukna': ('drukne',),
'druknet': ('drukne',),
'drukna': ('drukne',),
'druknet': ('drukne',),
'drukn': ('drukne',),
'drukne': ('drukne',),
'drukn': ('drukne',),
'drukne': ('drukne',),
'dryge': ('dryge',),
'dryger': ('dryge',),
'dryges': ('dryge',),
'drygde': ('dryge',),
'drygd': ('dryge',),
'dryg': ('dryge',),
'dryppe': ('dryppe',),
'drypper': ('dryppe',),
'dryppes': ('dryppe',),
'dryppa': ('dryppe',),
'dryppet': ('dryppe',),
'drypte': ('dryppe',),
'dryppa': ('dryppe',),
'dryppet': ('dryppe',),
'drypt': ('dryppe',),
'drypp': ('dryppe',),
'drypptørke': ('drypptørke',),
'drypptørker': ('drypptørke',),
'drypptørkes': ('drypptørke',),
'drypptørka': ('drypptørke',),
'drypptørket': ('drypptørke',),
'drypptørka': ('drypptørke',),
'drypptørket': ('drypptørke',),
'drypptørk': ('drypptørke',),
'drypptørre': ('drypptørre',),
'drypptørrer': ('drypptørre',),
'drypptørres': ('drypptørre',),
'drypptørra': ('drypptørre',),
'drypptørret': ('drypptørre',),
'drypptørra': ('drypptørre',),
'drypptørret': ('drypptørre',),
'drypptørr': ('drypptørre',),
'drysse': ('drysse',),
'drysser': ('drysse',),
'drysses': ('drysse',),
'dryssa': ('drysse',),
'drysset': ('drysse',),
'dryste': ('drysse',),
'dryssa': ('drysse',),
'drysset': ('drysse',),
'dryst': ('drysse',),
'dryss': ('drysse',),
'drøfte': ('drøfte',),
'drøfter': ('drøfte',),
'drøftes': ('drøfte',),
'drøfta': ('drøfte',),
'drøftet': ('drøfte',),
'drøfta': ('drøfte',),
'drøftet': ('drøfte',),
'drøft': ('drøfte',),
'drømme': ('drømme',),
'drømmer': ('drømme',),
'drømmes': ('drømme',),
'drømte': ('drømme',),
'drømt': ('drømme',),
'drøm': ('drømme',),
'drønne': ('drønne',),
'drønner': ('drønne',),
'drønnes': ('drønne',),
'drønna': ('drønne',),
'drønnet': ('drønne',),
'drønte': ('drønne',),
'drønna': ('drønne',),
'drønnet': ('drønne',),
'drønt': ('drønne',),
'drønn': ('drønne',),
'drøse': ('drøse',),
'drøser': ('drøse',),
'drøses': ('drøse',),
'drøste': ('drøse',),
'drøst': ('drøse',),
'drøs': ('drøse',),
'drøvtygge': ('drøvtygge',),
'drøvtygger': ('drøvtygge',),
'drøvtygges': ('drøvtygge',),
'drøvtygget': ('drøvtygge',),
'drøvtygde': ('drøvtygge',),
'drøvtygget': ('drøvtygge',),
'drøvtygd': ('drøvtygge',),
'drøvtygg': ('drøvtygge',),
'drøye': ('drøye',),
'drøyer': ('drøye',),
'drøyes': ('drøye',),
'drøyde': ('drøye',),
'drøyd': ('drøye',),
'drøy': ('drøye',),
'dubbe': ('dubbe',),
'dubber': ('dubbe',),
'dubbes': ('dubbe',),
'dubba': ('dubbe',),
'dubbet': ('dubbe',),
'dubba': ('dubbe',),
'dubbet': ('dubbe',),
'dubb': ('dubbe',),
'dublere': ('dublere',),
'dublerer': ('dublere',),
'dubleres': ('dublere',),
'dublerte': ('dublere',),
'dublert': ('dublere',),
'dubler': ('dublere',),
'duellere': ('duellere',),
'duellerer': ('duellere',),
'duelleres': ('duellere',),
'duellerte': ('duellere',),
'duellert': ('duellere',),
'dueller': ('duellere',),
'dufte': ('dufte',),
'dufter': ('dufte',),
'duftes': ('dufte',),
'dufta': ('dufte',),
'duftet': ('dufte',),
'dufta': ('dufte',),
'duftet': ('dufte',),
'duft': ('dufte',),
'duge': ('duge',),
'duger': ('duge',),
'duges': ('duge',),
'dugde': ('duge',),
'dugd': ('duge',),
'dug': ('duge',),
'dugge': ('dugge',),
'dugger': ('dugge',),
'dugges': ('dugge',),
'dugga': ('dugge',),
'dugget': ('dugge',),
'dugga': ('dugge',),
'dugget': ('dugge',),
'dugg': ('dugge',),
'duke': ('duke',),
'duker': ('duke',),
'dukes': ('duke',),
'duka': ('duke',),
'duket': ('duke',),
'duka': ('duke',),
'duket': ('duke',),
'duk': ('duke',),
'dukke': ('dukke',),
'dukker': ('dukke',),
'dukkes': ('dukke',),
'dukka': ('dukke',),
'dukket': ('dukke',),
'dukka': ('dukke',),
'dukket': ('dukke',),
'dukk': ('dukke',),
'dulle': ('dulle',),
'duller': ('dulle',),
'dulles': ('dulle',),
'dulla': ('dulle',),
'dullet': ('dulle',),
'dulla': ('dulle',),
'dullet': ('dulle',),
'dull': ('dulle',),
'dulme': ('dulme',),
'dulmer': ('dulme',),
'dulmes': ('dulme',),
'dulma': ('dulme',),
'dulmet': ('dulme',),
'dulma': ('dulme',),
'dulmet': ('dulme',),
'dulm': ('dulme',),
'dulte': ('dulte',),
'dulter': ('dulte',),
'dultes': ('dulte',),
'dulta': ('dulte',),
'dultet': ('dulte',),
'dulta': ('dulte',),
'dultet': ('dulte',),
'dult': ('dulte',),
'dumme': ('dumme',),
'dummer': ('dumme',),
'dummes': ('dumme',),
'dumma': ('dumme',),
'dummet': ('dumme',),
'dumma': ('dumme',),
'dummet': ('dumme',),
'dum': ('dumme',),
'dumpe': ('dumpe',),
'dumper': ('dumpe',),
'dumpes': ('dumpe',),
'dumpa': ('dumpe',),
'dumpet': ('dumpe',),
'dumpa': ('dumpe',),
'dumpet': ('dumpe',),
'dump': ('dumpe',),
'dundre': ('dundre',),
'dundrer': ('dundre',),
'dundres': ('dundre',),
'dundra': ('dundre',),
'dundret': ('dundre',),
'dundra': ('dundre',),
'dundret': ('dundre',),
'dundr': ('dundre',),
'dundre': ('dundre',),
'dundr': ('dundre',),
'dundre': ('dundre',),
'dunge': ('dunge',),
'dunger': ('dunge',),
'dunges': ('dunge',),
'dunga': ('dunge',),
'dunget': ('dunge',),
'dunga': ('dunge',),
'dunget': ('dunge',),
'dung': ('dunge',),
'dunke': ('dunke',),
'dunker': ('dunke',),
'dunkes': ('dunke',),
'dunka': ('dunke',),
'dunket': ('dunke',),
'dunka': ('dunke',),
'dunket': ('dunke',),
'dunk': ('dunke',),
'dunste': ('dunste',),
'dunster': ('dunste',),
'dunstes': ('dunste',),
'dunsta': ('dunste',),
'dunstet': ('dunste',),
'dunsta': ('dunste',),
'dunstet': ('dunste',),
'dunst': ('dunste',),
'dupere': ('dupere',),
'duperer': ('dupere',),
'duperes': ('dupere',),
'duperte': ('dupere',),
'dupert': ('dupere',),
'duper': ('dupere',),
'duplisere': ('duplisere',),
'dupliserer': ('duplisere',),
'dupliseres': ('duplisere',),
'dupliserte': ('duplisere',),
'duplisert': ('duplisere',),
'dupliser': ('duplisere',),
'duppe': ('duppe',),
'dupper': ('duppe',),
'duppes': ('duppe',),
'duppa': ('duppe',),
'duppet': ('duppe',),
'duppa': ('duppe',),
'duppet': ('duppe',),
'dupp': ('duppe',),
'dure': ('dure',),
'durer': ('dure',),
'dures': ('dure',),
'dura': ('dure',),
'duret': ('dure',),
'durte': ('dure',),
'dura': ('dure',),
'duret': ('dure',),
'durt': ('dure',),
'dur': ('dure',),
'durksy': ('durksy',),
'durksyr': ('durksy',),
'durksys': ('durksy',),
'durksydde': ('durksy',),
'durksydd': ('durksy',),
'durksy': ('durksy',),
'duse': ('duse',),
'duser': ('duse',),
'duses': ('duse',),
'duste': ('duse',),
'dust': ('duse',),
'dus': ('duse',),
'dusje': ('dusje',),
'dusjer': ('dusje',),
'dusjes': ('dusje',),
'dusja': ('dusje',),
'dusjet': ('dusje',),
'dusja': ('dusje',),
'dusjet': ('dusje',),
'dusj': ('dusje',),
'duskregne': ('duskregne',),
'duskregner': ('duskregne',),
'duskregnes': ('duskregne',),
'duskregna': ('duskregne',),
'duskregnet': ('duskregne',),
'duskregnte': ('duskregne',),
'duskregna': ('duskregne',),
'duskregnet': ('duskregne',),
'duskregnt': ('duskregne',),
'duskregn': ('duskregne',),
'dutte': ('dutte',),
'dutter': ('dutte',),
'duttes': ('dutte',),
'dutta': ('dutte',),
'duttet': ('dutte',),
'dutta': ('dutte',),
'duttet': ('dutte',),
'dutt': ('dutte',),
'duve': ('duve',),
'duver': ('duve',),
'duves': ('duve',),
'duva': ('duve',),
'duvet': ('duve',),
'duvde': ('duve',),
'duva': ('duve',),
'duvet': ('duve',),
'duvd': ('duve',),
'duv': ('duve',),
'dvele': ('dvele',),
'dveler': ('dvele',),
'dveles': ('dvele',),
'dvelte': ('dvele',),
'dvelt': ('dvele',),
'dvel': ('dvele',),
'dy': ('dy',),
'dyr': ('dy',),
'dys': ('dy',),
'dydde': ('dy',),
'dydd': ('dy',),
'dy': ('dy',),
'dykke': ('dykke',),
'dykker': ('dykke',),
'dykkes': ('dykke',),
'dykka': ('dykke',),
'dykket': ('dykke',),
'dykka': ('dykke',),
'dykket': ('dykke',),
'dykk': ('dykke',),
'dyktiggjøre': ('dyktiggjøre',),
'dyktiggjør': ('dyktiggjøre',),
'dyktiggjøres': ('dyktiggjøre',),
'dyktiggjorde': ('dyktiggjøre',),
'dyktiggjort': ('dyktiggjøre',),
'dyktiggjør': ('dyktiggjøre',),
'dynge': ('dynge',),
'dynger': ('dynge',),
'dynges': ('dynge',),
'dynga': ('dynge',),
'dynget': ('dynge',),
'dynga': ('dynge',),
'dynget': ('dynge',),
'dyng': ('dynge',),
'dynke': ('dynke',),
'dynker': ('dynke',),
'dynkes': ('dynke',),
'dynka': ('dynke',),
'dynket': ('dynke',),
'dynka': ('dynke',),
'dynket': ('dynke',),
'dynk': ('dynke',),
'dypetse': ('dypetse',),
'dypetser': ('dypetse',),
'dypetses': ('dypetse',),
'dypetsa': ('dypetse',),
'dypetset': ('dypetse',),
'dypetsa': ('dypetse',),
'dypetset': ('dypetse',),
'dypets': ('dypetse',),
'dypfryse': ('dypfryse',),
'dypfryser': ('dypfryse',),
'dypfryses': ('dypfryse',),
'dypfryste': ('dypfryse',),
'dypfryst': ('dypfryse',),
'dypfrys': ('dypfryse',),
'dyppe': ('dyppe',),
'dypper': ('dyppe',),
'dyppes': ('dyppe',),
'dyppa': ('dyppe',),
'dyppet': ('dyppe',),
'dyppa': ('dyppe',),
'dyppet': ('dyppe',),
'dypp': ('dyppe',),
'dyrke': ('dyrke',),
'dyrker': ('dyrke',),
'dyrkes': ('dyrke',),
'dyrka': ('dyrke',),
'dyrket': ('dyrke',),
'dyrka': ('dyrke',),
'dyrket': ('dyrke',),
'dyrk': ('dyrke',),
'dysse': ('dysse',),
'dysser': ('dysse',),
'dysses': ('dysse',),
'dyssa': ('dysse',),
'dysset': ('dysse',),
'dyssa': ('dysse',),
'dysset': ('dysse',),
'dyss': ('dysse',),
'dytte': ('dytte',),
'dytter': ('dytte',),
'dyttes': ('dytte',),
'dytta': ('dytte',),
'dyttet': ('dytte',),
'dytta': ('dytte',),
'dyttet': ('dytte',),
'dytt': ('dytte',),
'dåne': ('dåne',),
'dåner': ('dåne',),
'dånes': ('dåne',),
'dåna': ('dåne',),
'dånet': ('dåne',),
'dånte': ('dåne',),
'dåna': ('dåne',),
'dånet': ('dåne',),
'dånt': ('dåne',),
'dån': ('dåne',),
'dåre': ('dåre',),
'dårer': ('dåre',),
'dåres': ('dåre',),
'dåra': ('dåre',),
'dåret': ('dåre',),
'dåra': ('dåre',),
'dåret': ('dåre',),
'dår': ('dåre',),
'dø': ('dø',),
'dør': ('dø',),
'døs': ('dø',),
'døde': ('dø',),
'dødd': ('dø',),
'dø': ('dø',),
'døde': ('døde',),
'døder': ('døde',),
'dødes': ('døde',),
'døda': ('døde',),
'dødet': ('døde',),
'døda': ('døde',),
'dødet': ('døde',),
'død': ('døde',),
'dølge': ('dølge',),
'dølger': ('dølge',),
'dølges': ('dølge',),
'dulgte': ('dølge',),
'dulgt': ('dølge',),
'dølg': ('dølge',),
'dømme': ('dømme',),
'dømmer': ('dømme',),
'dømmes': ('dømme',),
'dømte': ('dømme',),
'dømt': ('dømme',),
'døm': ('dømme',),
'dønne': ('dønne',),
'dønner': ('dønne',),
'dønnes': ('dønne',),
'dønna': ('dønne',),
'dønnet': ('dønne',),
'dønte': ('dønne',),
'dønna': ('dønne',),
'dønnet': ('dønne',),
'dønt': ('dønne',),
'dønn': ('dønne',),
'døpe': ('døpe',),
'døper': ('døpe',),
'døpes': ('døpe',),
'døpte': ('døpe',),
'døpt': ('døpe',),
'døp': ('døpe',),
'døse': ('døse',),
'døser': ('døse',),
'døses': ('døse',),
'døsa': ('døse',),
'døset': ('døse',),
'døste': ('døse',),
'døsa': ('døse',),
'døset': ('døse',),
'døst': ('døse',),
'døs': ('døse',),
'døye': ('døye',),
'døyer': ('døye',),
'døyes': ('døye',),
'døya': ('døye',),
'døyet': ('døye',),
'døyde': ('døye',),
'døya': ('døye',),
'døyet': ('døye',),
'døyd': ('døye',),
'døy': ('døye',),
'døyve': ('døyve',),
'døyver': ('døyve',),
'døyves': ('døyve',),
'døyva': ('døyve',),
'døyvet': ('døyve',),
'døyvde': ('døyve',),
'døyva': ('døyve',),
'døyvet': ('døyve',),
'døyvd': ('døyve',),
'døyv': ('døyve',),
'ebbe': ('ebbe',),
'ebber': ('ebbe',),
'ebbes': ('ebbe',),
'ebba': ('ebbe',),
'ebbet': ('ebbe',),
'ebba': ('ebbe',),
'ebbet': ('ebbe',),
'ebb': ('ebbe',),
'edfeste': ('edfeste',),
'edfester': ('edfeste',),
'edfestes': ('edfeste',),
'edfesta': ('edfeste',),
'edfestet': ('edfeste',),
'edfesta': ('edfeste',),
'edfestet': ('edfeste',),
'edfest': ('edfeste',),
'effektivisere': ('effektivisere',),
'effektiviserer': ('effektivisere',),
'effektiviseres': ('effektivisere',),
'effektiviserte': ('effektivisere',),
'effektivisert': ('effektivisere',),
'effektiviser': ('effektivisere',),
'effektuere': ('effektuere',),
'effektuerer': ('effektuere',),
'effektueres': ('effektuere',),
'effektuerte': ('effektuere',),
'effektuert': ('effektuere',),
'effektuer': ('effektuere',),
'egalisere': ('egalisere',),
'egaliserer': ('egalisere',),
'egaliseres': ('egalisere',),
'egaliserte': ('egalisere',),
'egalisert': ('egalisere',),
'egaliser': ('egalisere',),
'egge': ('egge',),
'egger': ('egge',),
'egges': ('egge',),
'egga': ('egge',),
'egget': ('egge',),
'egga': ('egge',),
'egget': ('egge',),
'egg': ('egge',),
'egle': ('egle',),
'egler': ('egle',),
'egles': ('egle',),
'egla': ('egle',),
'eglet': ('egle',),
'egla': ('egle',),
'eglet': ('egle',),
'egl': ('egle',),
'egle': ('egle',),
'egl': ('egle',),
'egle': ('egle',),
'egne': ('egne',),
'egner': ('egne',),
'egnes': ('egne',),
'egna': ('egne',),
'egnet': ('egne',),
'egna': ('egne',),
'egnet': ('egne',),
'egn': ('egne',),
'egne': ('egne',),
'egner': ('egne',),
'egnes': ('egne',),
'egna': ('egne',),
'egnet': ('egne',),
'egnte': ('egne',),
'egna': ('egne',),
'egnet': ('egne',),
'egnt': ('egne',),
'egn': ('egne',),
'eie': ('eie',),
'eier': ('eie',),
'eies': ('eie',),
'eiet': ('eie',),
'eide': ('eie',),
'åtte': ('eie',),
'eiet': ('eie',),
'eid': ('eie',),
'ått': ('eie',),
'ei': ('eie',),
'eime': ('eime',),
'eimer': ('eime',),
'eimes': ('eime',),
'eima': ('eime',),
'eimet': ('eime',),
'eima': ('eime',),
'eimet': ('eime',),
'eim': ('eime',),
'eire': ('eire',),
'eirer': ('eire',),
'eires': ('eire',),
'eira': ('eire',),
'eiret': ('eire',),
'eira': ('eire',),
'eiret': ('eire',),
'eir': ('eire',),
'ejakulere': ('ejakulere',),
'ejakulerer': ('ejakulere',),
'ejakuleres': ('ejakulere',),
'ejakulerte': ('ejakulere',),
'ejakulert': ('ejakulere',),
'ejakuler': ('ejakulere',),
'eksaminere': ('eksaminere',),
'eksaminerer': ('eksaminere',),
'eksamineres': ('eksaminere',),
'eksaminerte': ('eksaminere',),
'eksaminert': ('eksaminere',),
'eksaminer': ('eksaminere',),
'eksegere': ('eksegere',),
'eksegerer': ('eksegere',),
'eksegeres': ('eksegere',),
'eksegerte': ('eksegere',),
'eksegert': ('eksegere',),
'ekseger': ('eksegere',),
'eksekvere': ('eksekvere',),
'eksekverer': ('eksekvere',),
'eksekveres': ('eksekvere',),
'eksekverte': ('eksekvere',),
'eksekvert': ('eksekvere',),
'eksekver': ('eksekvere',),
'eksellere': ('eksellere',),
'eksellerer': ('eksellere',),
'ekselleres': ('eksellere',),
'eksellerte': ('eksellere',),
'eksellert': ('eksellere',),
'ekseller': ('eksellere',),
'eksemplifisere': ('eksemplifisere',),
'eksemplifiserer': ('eksemplifisere',),
'eksemplifiseres': ('eksemplifisere',),
'eksemplifiserte': ('eksemplifisere',),
'eksemplifisert': ('eksemplifisere',),
'eksemplifiser': ('eksemplifisere',),
'ekserpere': ('ekserpere',),
'ekserperer': ('ekserpere',),
'ekserperes': ('ekserpere',),
'ekserperte': ('ekserpere',),
'ekserpert': ('ekserpere',),
'ekserper': ('ekserpere',),
'eksersere': ('eksersere',),
'ekserserer': ('eksersere',),
'ekserseres': ('eksersere',),
'ekserserte': ('eksersere',),
'eksersert': ('eksersere',),
'ekserser': ('eksersere',),
'ekshalere': ('ekshalere',),
'ekshalerer': ('ekshalere',),
'ekshaleres': ('ekshalere',),
'ekshalerte': ('ekshalere',),
'ekshalert': ('ekshalere',),
'ekshaler': ('ekshalere',),
'eksistere': ('eksistere',),
'eksisterer': ('eksistere',),
'eksisteres': ('eksistere',),
'eksisterte': ('eksistere',),
'eksistert': ('eksistere',),
'eksister': ('eksistere',),
'eksklamere': ('eksklamere',),
'eksklamerer': ('eksklamere',),
'eksklameres': ('eksklamere',),
'eksklamerte': ('eksklamere',),
'eksklamert': ('eksklamere',),
'eksklamer': ('eksklamere',),
'ekskludere': ('ekskludere',),
'ekskluderer': ('ekskludere',),
'ekskluderes': ('ekskludere',),
'ekskluderte': ('ekskludere',),
'ekskludert': ('ekskludere',),
'ekskluder': ('ekskludere',),
'ekskommunisere': ('ekskommunisere',),
'ekskommuniserer': ('ekskommunisere',),
'ekskommuniseres': ('ekskommunisere',),
'ekskommuniserte': ('ekskommunisere',),
'ekskommunisert': ('ekskommunisere',),
'ekskommuniser': ('ekskommunisere',),
'ekspandere': ('ekspandere',),
'ekspanderer': ('ekspandere',),
'ekspanderes': ('ekspandere',),
'ekspanderte': ('ekspandere',),
'ekspandert': ('ekspandere',),
'ekspander': ('ekspandere',),
'ekspatriere': ('ekspatriere',),
'ekspatrierer': ('ekspatriere',),
'ekspatrieres': ('ekspatriere',),
'ekspatrierte': ('ekspatriere',),
'ekspatriert': ('ekspatriere',),
'ekspatrier': ('ekspatriere',),
'ekspedere': ('ekspedere',),
'ekspederer': ('ekspedere',),
'ekspederes': ('ekspedere',),
'ekspederte': ('ekspedere',),
'ekspedert': ('ekspedere',),
'ekspeder': ('ekspedere',),
'eksperimentere': ('eksperimentere',),
'eksperimenterer': ('eksperimentere',),
'eksperimenteres': ('eksperimentere',),
'eksperimenterte': ('eksperimentere',),
'eksperimentert': ('eksperimentere',),
'eksperimenter': ('eksperimentere',),
'ekspirere': ('ekspirere',),
'ekspirerer': ('ekspirere',),
'ekspireres': ('ekspirere',),
'ekspirerte': ('ekspirere',),
'ekspirert': ('ekspirere',),
'ekspirer': ('ekspirere',),
'eksplisittere': ('eksplisittere',),
'eksplisitterer': ('eksplisittere',),
'eksplisitteres': ('eksplisittere',),
'eksplisitterte': ('eksplisittere',),
'eksplisittert': ('eksplisittere',),
'eksplisitter': ('eksplisittere',),
'eksploatere': ('eksploatere',),
'eksploaterer': ('eksploatere',),
'eksploateres': ('eksploatere',),
'eksploaterte': ('eksploatere',),
'eksploatert': ('eksploatere',),
'eksploater': ('eksploatere',),
'eksplodere': ('eksplodere',),
'eksploderer': ('eksplodere',),
'eksploderes': ('eksplodere',),
'eksploderte': ('eksplodere',),
'eksplodert': ('eksplodere',),
'eksploder': ('eksplodere',),
'eksponere': ('eksponere',),
'eksponerer': ('eksponere',),
'eksponeres': ('eksponere',),
'eksponerte': ('eksponere',),
'eksponert': ('eksponere',),
'eksponer': ('eksponere',),
'eksportere': ('eksportere',),
'eksporterer': ('eksportere',),
'eksporteres': ('eksportere',),
'eksporterte': ('eksportere',),
'eksportert': ('eksportere',),
'eksporter': ('eksportere',),
'ekspropriere': ('ekspropriere',),
'eksproprierer': ('ekspropriere',),
'eksproprieres': ('ekspropriere',),
'eksproprierte': ('ekspropriere',),
'ekspropriert': ('ekspropriere',),
'eksproprier': ('ekspropriere',),
'ekstemporere': ('ekstemporere',),
'ekstemporerer': ('ekstemporere',),
'ekstemporeres': ('ekstemporere',),
'ekstemporerte': ('ekstemporere',),
'ekstemporert': ('ekstemporere',),
'ekstemporer': ('ekstemporere',),
'ekstensivere': ('ekstensivere',),
'ekstensiverer': ('ekstensivere',),
'ekstensiveres': ('ekstensivere',),
'ekstensiverte': ('ekstensivere',),
'ekstensivert': ('ekstensivere',),
'ekstensiver': ('ekstensivere',),
'ekstrahere': ('ekstrahere',),
'ekstraherer': ('ekstrahere',),
'ekstraheres': ('ekstrahere',),
'ekstraherte': ('ekstrahere',),
'ekstrahert': ('ekstrahere',),
'ekstraher': ('ekstrahere',),
'ekstrapolere': ('ekstrapolere',),
'ekstrapolerer': ('ekstrapolere',),
'ekstrapoleres': ('ekstrapolere',),
'ekstrapolerte': ('ekstrapolere',),
'ekstrapolert': ('ekstrapolere',),
'ekstrapoler': ('ekstrapolere',),
'ekte': ('ekte',),
'ekter': ('ekte',),
'ektes': ('ekte',),
'ekta': ('ekte',),
'ektet': ('ekte',),
'ekta': ('ekte',),
'ektet': ('ekte',),
'ekt': ('ekte',),
'ektevie': ('ektevie',),
'ektevier': ('ektevie',),
'ektevies': ('ektevie',),
'ektevia': ('ektevie',),
'ekteviet': ('ektevie',),
'ektevidde': ('ektevie',),
'ektevigde': ('ektevie',),
'ektevia': ('ektevie',),
'ekteviet': ('ektevie',),
'ektevidd': ('ektevie',),
'ektevigd': ('ektevie',),
'ektevi': ('ektevie',),
'ekvipere': ('ekvipere',),
'ekviperer': ('ekvipere',),
'ekviperes': ('ekvipere',),
'ekviperte': ('ekvipere',),
'ekvipert': ('ekvipere',),
'ekviper': ('ekvipere',),
'ekvivalere': ('ekvivalere',),
'ekvivalerer': ('ekvivalere',),
'ekvivaleres': ('ekvivalere',),
'ekvivalerte': ('ekvivalere',),
'ekvivalert': ('ekvivalere',),
'ekvivaler': ('ekvivalere',),
'elde': ('elde',),
'elder': ('elde',),
'eldes': ('elde',),
'elda': ('elde',),
'eldet': ('elde',),
'elda': ('elde',),
'eldet': ('elde',),
'eld': ('elde',),
'eldes': ('eldes',),
'eldedes': ('eldes',),
'eldes': ('eldes',),
'elektrifisere': ('elektrifisere',),
'elektrifiserer': ('elektrifisere',),
'elektrifiseres': ('elektrifisere',),
'elektrifiserte': ('elektrifisere',),
'elektrifisert': ('elektrifisere',),
'elektrifiser': ('elektrifisere',),
'elektrisere': ('elektrisere',),
'elektriserer': ('elektrisere',),
'elektriseres': ('elektrisere',),
'elektriserte': ('elektrisere',),
'elektrisert': ('elektrisere',),
'elektriser': ('elektrisere',),
'elevere': ('elevere',),
'eleverer': ('elevere',),
'eleveres': ('elevere',),
'eleverte': ('elevere',),
'elevert': ('elevere',),
'elever': ('elevere',),
'eligere': ('eligere',),
'eligerer': ('eligere',),
'eligeres': ('eligere',),
'eligerte': ('eligere',),
'eligert': ('eligere',),
'eliger': ('eligere',),
'eliminere': ('eliminere',),
'eliminerer': ('eliminere',),
'elimineres': ('eliminere',),
'eliminerte': ('eliminere',),
'eliminert': ('eliminere',),
'eliminer': ('eliminere',),
'elle': ('elle',),
'eller': ('elle',),
'elles': ('elle',),
'ella': ('elle',),
'ellet': ('elle',),
'ella': ('elle',),
'ellet': ('elle',),
'ell': ('elle',),
'eloksere': ('eloksere',),
'elokserer': ('eloksere',),
'elokseres': ('eloksere',),
'elokserte': ('eloksere',),
'eloksert': ('eloksere',),
'elokser': ('eloksere',),
'elske': ('elske',),
'elsker': ('elske',),
'elskes': ('elske',),
'elska': ('elske',),
'elsket': ('elske',),
'elska': ('elske',),
'elsket': ('elske',),
'elsk': ('elske',),
'elte': ('elte',),
'elter': ('elte',),
'eltes': ('elte',),
'elta': ('elte',),
'eltet': ('elte',),
'elta': ('elte',),
'eltet': ('elte',),
'elt': ('elte',),
'eludere': ('eludere',),
'eluderer': ('eludere',),
'eluderes': ('eludere',),
'eluderte': ('eludere',),
'eludert': ('eludere',),
'eluder': ('eludere',),
'emaljere': ('emaljere',),
'emaljerer': ('emaljere',),
'emaljeres': ('emaljere',),
'emaljerte': ('emaljere',),
'emaljert': ('emaljere',),
'emaljer': ('emaljere',),
'emansipere': ('emansipere',),
'emansiperer': ('emansipere',),
'emansiperes': ('emansipere',),
'emansiperte': ('emansipere',),
'emansipert': ('emansipere',),
'emansiper': ('emansipere',),
'emballere': ('emballere',),
'emballerer': ('emballere',),
'emballeres': ('emballere',),
'emballerte': ('emballere',),
'emballert': ('emballere',),
'emballer': ('emballere',),
'embarkere': ('embarkere',),
'embarkerer': ('embarkere',),
'embarkeres': ('embarkere',),
'embarkerte': ('embarkere',),
'embarkert': ('embarkere',),
'embarker': ('embarkere',),
'emigrere': ('emigrere',),
'emigrerer': ('emigrere',),
'emigreres': ('emigrere',),
'emigrerte': ('emigrere',),
'emigrert': ('emigrere',),
'emigrer': ('emigrere',),
'emittere': ('emittere',),
'emitterer': ('emittere',),
'emitteres': ('emittere',),
'emitterte': ('emittere',),
'emittert': ('emittere',),
'emitter': ('emittere',),
'emne': ('emne',),
'emner': ('emne',),
'emnes': ('emne',),
'emna': ('emne',),
'emnet': ('emne',),
'emna': ('emne',),
'emnet': ('emne',),
'emn': ('emne',),
'employere': ('employere',),
'employerer': ('employere',),
'employeres': ('employere',),
'employerte': ('employere',),
'employert': ('employere',),
'employer': ('employere',),
'emulgere': ('emulgere',),
'emulgerer': ('emulgere',),
'emulgeres': ('emulgere',),
'emulgerte': ('emulgere',),
'emulgert': ('emulgere',),
'emulger': ('emulgere',),
'ende': ('ende',),
'ender': ('ende',),
'endes': ('ende',),
'endte': ('ende',),
'endt': ('ende',),
'end': ('ende',),
'endevende': ('endevende',),
'endevender': ('endevende',),
'endevendes': ('endevende',),
'endevendte': ('endevende',),
'endevendt': ('endevende',),
'endevend': ('endevende',),
'endossere': ('endossere',),
'endosserer': ('endossere',),
'endosseres': ('endossere',),
'endosserte': ('endossere',),
'endossert': ('endossere',),
'endosser': ('endossere',),
'endre': ('endre',),
'endrer': ('endre',),
'endres': ('endre',),
'endra': ('endre',),
'endret': ('endre',),
'endra': ('endre',),
'endret': ('endre',),
'endr': ('endre',),
'endre': ('endre',),
'endr': ('endre',),
'endre': ('endre',),
'ene': ('ene',),
'ener': ('ene',),
'enes': ('ene',),
'ente': ('ene',),
'ent': ('ene',),
'en': ('ene',),
'enervere': ('enervere',),
'enerverer': ('enervere',),
'enerveres': ('enervere',),
'enerverte': ('enervere',),
'enervert': ('enervere',),
'enerver': ('enervere',),
'enes': ('enes',),
'entes': ('enes',),
'enes': ('enes',),
'engasjere': ('engasjere',),
'engasjerer': ('engasjere',),
'engasjeres': ('engasjere',),
'engasjerte': ('engasjere',),
'engasjert': ('engasjere',),
'engasjer': ('engasjere',),
'engste': ('engste',),
'engster': ('engste',),
'engstes': ('engste',),
'engsta': ('engste',),
'engstet': ('engste',),
'engsta': ('engste',),
'engstet': ('engste',),
'engst': ('engste',),
'ense': ('ense',),
'enser': ('ense',),
'enses': ('ense',),
'ensa': ('ense',),
'enset': ('ense',),
'enste': ('ense',),
'ensa': ('ense',),
'enset': ('ense',),
'enst': ('ense',),
'ens': ('ense',),
'ensilere': ('ensilere',),
'ensilerer': ('ensilere',),
'ensileres': ('ensilere',),
'ensilerte': ('ensilere',),
'ensilert': ('ensilere',),
'ensiler': ('ensilere',),
'ensrette': ('ensrette',),
'ensretter': ('ensrette',),
'ensrettes': ('ensrette',),
'ensretta': ('ensrette',),
'ensrettet': ('ensrette',),
'ensretta': ('ensrette',),
'ensrettet': ('ensrette',),
'ensrett': ('ensrette',),
'entre': ('entre',),
'entrer': ('entre',),
'entres': ('entre',),
'entra': ('entre',),
'entret': ('entre',),
'entra': ('entre',),
'entret': ('entre',),
'entr': ('entre',),
'entre': ('entre',),
'entr': ('entre',),
'entre': ('entre',),
'envegsregulere': ('envegsregulere',),
'envegsregulerer': ('envegsregulere',),
'envegsreguleres': ('envegsregulere',),
'envegsregulerte': ('envegsregulere',),
'envegsregulert': ('envegsregulere',),
'envegsreguler': ('envegsregulere',),
'enveisregulere': ('enveisregulere',),
'enveisregulerer': ('enveisregulere',),
'enveisreguleres': ('enveisregulere',),
'enveisregulerte': ('enveisregulere',),
'enveisregulert': ('enveisregulere',),
'enveisreguler': ('enveisregulere',),
'erfare': ('erfare',),
'erfarer': ('erfare',),
'erfares': ('erfare',),
'erfarte': ('erfare',),
'erfart': ('erfare',),
'erfar': ('erfare',),
'ergre': ('ergre',),
'ergrer': ('ergre',),
'ergres': ('ergre',),
'ergra': ('ergre',),
'ergret': ('ergre',),
'ergra': ('ergre',),
'ergret': ('ergre',),
'ergr': ('ergre',),
'ergre': ('ergre',),
'ergr': ('ergre',),
'ergre': ('ergre',),
'erholde': ('erholde',),
'erholder': ('erholde',),
'erholdes': ('erholde',),
'erholdt': ('erholde',),
'erhold': ('erholde',),
'erigere': ('erigere',),
'erigerer': ('erigere',),
'erigeres': ('erigere',),
'erigerte': ('erigere',),
'erigert': ('erigere',),
'eriger': ('erigere',),
'erindre': ('erindre',),
'erindrer': ('erindre',),
'erindres': ('erindre',),
'erindra': ('erindre',),
'erindret': ('erindre',),
'erindra': ('erindre',),
'erindret': ('erindre',),
'erindr': ('erindre',),
'erindre': ('erindre',),
'erindr': ('erindre',),
'erindre': ('erindre',),
'erkjenne': ('erkjenne',),
'erkjenner': ('erkjenne',),
'erkjennes': ('erkjenne',),
'erkjente': ('erkjenne',),
'erkjent': ('erkjenne',),
'erkjenn': ('erkjenne',),
'erklære': ('erklære',),
'erklærer': ('erklære',),
'erklæres': ('erklære',),
'erklærte': ('erklære',),
'erklært': ('erklære',),
'erklær': ('erklære',),
'erlegge': ('erlegge',),
'erlegger': ('erlegge',),
'erlegges': ('erlegge',),
'erla': ('erlegge',),
'erlagt': ('erlegge',),
'erlegg': ('erlegge',),
'ernære': ('ernære',),
'ernærer': ('ernære',),
'ernæres': ('ernære',),
'ernærte': ('ernære',),
'ernært': ('ernære',),
'ernær': ('ernære',),
'erobre': ('erobre',),
'erobrer': ('erobre',),
'erobres': ('erobre',),
'erobra': ('erobre',),
'erobret': ('erobre',),
'erobra': ('erobre',),
'erobret': ('erobre',),
'erobr': ('erobre',),
'erobre': ('erobre',),
'erobr': ('erobre',),
'erobre': ('erobre',),
'erodere': ('erodere',),
'eroderer': ('erodere',),
'eroderes': ('erodere',),
'eroderte': ('erodere',),
'erodert': ('erodere',),
'eroder': ('erodere',),
'erotisere': ('erotisere',),
'erotiserer': ('erotisere',),
'erotiseres': ('erotisere',),
'erotiserte': ('erotisere',),
'erotisert': ('erotisere',),
'erotiser': ('erotisere',),
'erstatte': ('erstatte',),
'erstatter': ('erstatte',),
'erstattes': ('erstatte',),
'erstatta': ('erstatte',),
'erstattet': ('erstatte',),
'erstatta': ('erstatte',),
'erstattet': ('erstatte',),
'erstatt': ('erstatte',),
'erte': ('erte',),
'erter': ('erte',),
'ertes': ('erte',),
'erta': ('erte',),
'ertet': ('erte',),
'erta': ('erte',),
'ertet': ('erte',),
'ert': ('erte',),
'erverve': ('erverve',),
'erverver': ('erverve',),
'erverves': ('erverve',),
'erverva': ('erverve',),
'ervervet': ('erverve',),
'erverva': ('erverve',),
'ervervet': ('erverve',),
'erverv': ('erverve',),
'ese': ('ese',),
'eser': ('ese',),
'eses': ('ese',),
'este': ('ese',),
'est': ('ese',),
'es': ('ese',),
'eskalere': ('eskalere',),
'eskalerer': ('eskalere',),
'eskaleres': ('eskalere',),
'eskalerte': ('eskalere',),
'eskalert': ('eskalere',),
'eskaler': ('eskalere',),
'eskamotere': ('eskamotere',),
'eskamoterer': ('eskamotere',),
'eskamoteres': ('eskamotere',),
'eskamoterte': ('eskamotere',),
'eskamotert': ('eskamotere',),
'eskamoter': ('eskamotere',),
'eskapere': ('eskapere',),
'eskaperer': ('eskapere',),
'eskaperes': ('eskapere',),
'eskaperte': ('eskapere',),
'eskapert': ('eskapere',),
'eskaper': ('eskapere',),
'eske': ('eske',),
'esker': ('eske',),
'eskes': ('eske',),
'eska': ('eske',),
'esket': ('eske',),
'eska': ('eske',),
'esket': ('eske',),
'esk': ('eske',),
'eskortere': ('eskortere',),
'eskorterer': ('eskortere',),
'eskorteres': ('eskortere',),
'eskorterte': ('eskortere',),
'eskortert': ('eskortere',),
'eskorter': ('eskortere',),
'esle': ('esle',),
'esler': ('esle',),
'esles': ('esle',),
'esla': ('esle',),
'eslet': ('esle',),
'esla': ('esle',),
'eslet': ('esle',),
'esl': ('esle',),
'estetisere': ('estetisere',),
'estetiserer': ('estetisere',),
'estetiseres': ('estetisere',),
'estetiserte': ('estetisere',),
'estetisert': ('estetisere',),
'estetiser': ('estetisere',),
'estimere': ('estimere',),
'estimerer': ('estimere',),
'estimeres': ('estimere',),
'estimerte': ('estimere',),
'estimert': ('estimere',),
'estimer': ('estimere',),
'etablere': ('etablere',),
'etablerer': ('etablere',),
'etableres': ('etablere',),
'etablerte': ('etablere',),
'etablert': ('etablere',),
'etabler': ('etablere',),
'ete': ('ete',),
'eter': ('ete',),
'etes': ('ete',),
'åt': ('ete',),
'ett': ('ete',),
'et': ('ete',),
'etikettere': ('etikettere',),
'etiketterer': ('etikettere',),
'etiketteres': ('etikettere',),
'etiketterte': ('etikettere',),
'etikettert': ('etikettere',),
'etiketter': ('etikettere',),
'etle': ('etle',),
'etler': ('etle',),
'etles': ('etle',),
'etla': ('etle',),
'etlet': ('etle',),
'etla': ('etle',),
'etlet': ('etle',),
'etl': ('etle',),
'etle': ('etle',),
'etl': ('etle',),
'etle': ('etle',),
'etse': ('etse',),
'etser': ('etse',),
'etses': ('etse',),
'etsa': ('etse',),
'etset': ('etse',),
'etsa': ('etse',),
'etset': ('etse',),
'ets': ('etse',),
'etteranmelde': ('etteranmelde',),
'etteranmelder': ('etteranmelde',),
'etteranmeldes': ('etteranmelde',),
'etteranmeldte': ('etteranmelde',),
'etteranmeldt': ('etteranmelde',),
'etteranmeld': ('etteranmelde',),
'etterape': ('etterape',),
'etteraper': ('etterape',),
'etterapes': ('etterape',),
'etterapa': ('etterape',),
'etterapet': ('etterape',),
'etterapte': ('etterape',),
'etterapa': ('etterape',),
'etterapet': ('etterape',),
'etterapt': ('etterape',),
'etterap': ('etterape',),
'etterbehandle': ('etterbehandle',),
'etterbehandler': ('etterbehandle',),
'etterbehandles': ('etterbehandle',),
'etterbehandla': ('etterbehandle',),
'etterbehandlet': ('etterbehandle',),
'etterbehandla': ('etterbehandle',),
'etterbehandlet': ('etterbehandle',),
'etterbehandl': ('etterbehandle',),
'etterbehandle': ('etterbehandle',),
'etterbehandl': ('etterbehandle',),
'etterbehandle': ('etterbehandle',),
'etterbetale': ('etterbetale',),
'etterbetaler': ('etterbetale',),
'etterbetales': ('etterbetale',),
'etterbetalte': ('etterbetale',),
'etterbetalt': ('etterbetale',),
'etterbetal': ('etterbetale',),
'etterforske': ('etterforske',),
'etterforsker': ('etterforske',),
'etterforskes': ('etterforske',),
'etterforska': ('etterforske',),
'etterforsket': ('etterforske',),
'etterforska': ('etterforske',),
'etterforsket': ('etterforske',),
'etterforsk': ('etterforske',),
'etterfylle': ('etterfylle',),
'etterfyller': ('etterfylle',),
'etterfylles': ('etterfylle',),
'etterfylte': ('etterfylle',),
'etterfylt': ('etterfylle',),
'etterfyll': ('etterfylle',),
'ettergi': ('ettergi',),
'ettergir': ('ettergi',),
'ettergis': ('ettergi',),
'ettergav': ('ettergi',),
'etterga': ('ettergi',),
'ettergitt': ('ettergi',),
'ettergi': ('ettergi',),
'ettergjøre': ('ettergjøre',),
'ettergjør': ('ettergjøre',),
'ettergjøres': ('ettergjøre',),
'ettergjorde': ('ettergjøre',),
'ettergjort': ('ettergjøre',),
'ettergjør': ('ettergjøre',),
'etterisolere': ('etterisolere',),
'etterisolerer': ('etterisolere',),
'etterisoleres': ('etterisolere',),
'etterisolerte': ('etterisolere',),
'etterisolert': ('etterisolere',),
'etterisoler': ('etterisolere',),
'etterlate': ('etterlate',),
'etterlater': ('etterlate',),
'etterlates': ('etterlate',),
'etterlot': ('etterlate',),
'etterlatt': ('etterlate',),
'etterlat': ('etterlate',),
'etterleve': ('etterleve',),
'etterlever': ('etterleve',),
'etterleves': ('etterleve',),
'etterlevde': ('etterleve',),
'etterlevd': ('etterleve',),
'etterlev': ('etterleve',),
'etterligne': ('etterligne',),
'etterligner': ('etterligne',),
'etterlignes': ('etterligne',),
'etterligna': ('etterligne',),
'etterlignet': ('etterligne',),
'etterligna': ('etterligne',),
'etterlignet': ('etterligne',),
'etterlign': ('etterligne',),
'etterlikne': ('etterlikne',),
'etterlikner': ('etterlikne',),
'etterliknes': ('etterlikne',),
'etterlikna': ('etterlikne',),
'etterliknet': ('etterlikne',),
'etterlikna': ('etterlikne',),
'etterliknet': ('etterlikne',),
'etterlikn': ('etterlikne',),
'etterlikne': ('etterlikne',),
'etterlikn': ('etterlikne',),
'etterlikne': ('etterlikne',),
'etterlyse': ('etterlyse',),
'etterlyser': ('etterlyse',),
'etterlyses': ('etterlyse',),
'etterlyste': ('etterlyse',),
'etterlyst': ('etterlyse',),
'etterlys': ('etterlyse',),
'etterplapre': ('etterplapre',),
'etterplaprer': ('etterplapre',),
'etterplapres': ('etterplapre',),
'etterplapra': ('etterplapre',),
'etterplapret': ('etterplapre',),
'etterplapra': ('etterplapre',),
'etterplapret': ('etterplapre',),
'etterplapr': ('etterplapre',),
'etterplapre': ('etterplapre',),
'etterplapr': ('etterplapre',),
'etterplapre': ('etterplapre',),
'etterprøve': ('etterprøve',),
'etterprøver': ('etterprøve',),
'etterprøves': ('etterprøve',),
'etterprøvde': ('etterprøve',),
'etterprøvd': ('etterprøve',),
'etterprøv': ('etterprøve',),
'etterse': ('etterse',),
'etterser': ('etterse',),
'etterses': ('etterse',),
'ettersees': ('etterse',),
'etterså': ('etterse',),
'ettersett': ('etterse',),
'etterse': ('etterse',),
'ettersende': ('ettersende',),
'ettersender': ('ettersende',),
'ettersendes': ('ettersende',),
'ettersendte': ('ettersende',),
'ettersendt': ('ettersende',),
'ettersend': ('ettersende',),
'etterslokke': ('etterslokke',),
'etterslokker': ('etterslokke',),
'etterslokkes': ('etterslokke',),
'etterslokka': ('etterslokke',),
'etterslokket': ('etterslokke',),
'etterslokte': ('etterslokke',),
'etterslokka': ('etterslokke',),
'etterslokket': ('etterslokke',),
'etterslokt': ('etterslokke',),
'etterslokk': ('etterslokke',),
'etterslukke': ('etterslukke',),
'etterslukker': ('etterslukke',),
'etterslukkes': ('etterslukke',),
'etterslukka': ('etterslukke',),
'etterslukket': ('etterslukke',),
'etterslukte': ('etterslukke',),
'etterslukka': ('etterslukke',),
'etterslukket': ('etterslukke',),
'etterslukt': ('etterslukke',),
'etterslukk': ('etterslukke',),
'etterspore': ('etterspore',),
'ettersporer': ('etterspore',),
'etterspores': ('etterspore',),
'etterspora': ('etterspore',),
'ettersporet': ('etterspore',),
'ettersporte': ('etterspore',),
'etterspora': ('etterspore',),
'ettersporet': ('etterspore',),
'ettersport': ('etterspore',),
'etterspor': ('etterspore',),
'etterstrebe': ('etterstrebe',),
'etterstreber': ('etterstrebe',),
'etterstrebes': ('etterstrebe',),
'etterstreba': ('etterstrebe',),
'etterstrebet': ('etterstrebe',),
'etterstreba': ('etterstrebe',),
'etterstrebet': ('etterstrebe',),
'etterstreb': ('etterstrebe',),
'ettersynkronisere': ('ettersynkronisere',),
'ettersynkroniserer': ('ettersynkronisere',),
'ettersynkroniseres': ('ettersynkronisere',),
'ettersynkroniserte': ('ettersynkronisere',),
'ettersynkronisert': ('ettersynkronisere',),
'ettersynkroniser': ('ettersynkronisere',),
'ettersøke': ('ettersøke',),
'ettersøker': ('ettersøke',),
'ettersøkes': ('ettersøke',),
'ettersøkte': ('ettersøke',),
'ettersøkt': ('ettersøke',),
'ettersøk': ('ettersøke',),
'ettertrakte': ('ettertrakte',),
'ettertrakter': ('ettertrakte',),
'ettertraktes': ('ettertrakte',),
'ettertrakta': ('ettertrakte',),
'ettertraktet': ('ettertrakte',),
'ettertrakta': ('ettertrakte',),
'ettertraktet': ('ettertrakte',),
'ettertrakt': ('ettertrakte',),
'europeisere': ('europeisere',),
'europeiserer': ('europeisere',),
'europeiseres': ('europeisere',),
'europeiserte': ('europeisere',),
'europeisert': ('europeisere',),
'europeiser': ('europeisere',),
'evakuere': ('evakuere',),
'evakuerer': ('evakuere',),
'evakueres': ('evakuere',),
'evakuerte': ('evakuere',),
'evakuert': ('evakuere',),
'evakuer': ('evakuere',),
'evaluere': ('evaluere',),
'evaluerer': ('evaluere',),
'evalueres': ('evaluere',),
'evaluerte': ('evaluere',),
'evaluert': ('evaluere',),
'evaluer': ('evaluere',),
'evangelisere': ('evangelisere',),
'evangeliserer': ('evangelisere',),
'evangeliseres': ('evangelisere',),
'evangeliserte': ('evangelisere',),
'evangelisert': ('evangelisere',),
'evangeliser': ('evangelisere',),
'evaporere': ('evaporere',),
'evaporerer': ('evaporere',),
'evaporeres': ('evaporere',),
'evaporerte': ('evaporere',),
'evaporert': ('evaporere',),
'evaporer': ('evaporere',),
'eve': ('eve',),
'ever': ('eve',),
'eves': ('eve',),
'eva': ('eve',),
'evet': ('eve',),
'eva': ('eve',),
'evet': ('eve',),
'ev': ('eve',),
'evne': ('evne',),
'evner': ('evne',),
'evnes': ('evne',),
'evna': ('evne',),
'evnet': ('evne',),
'evna': ('evne',),
'evnet': ('evne',),
'evn': ('evne',),
'exe': ('exe',),
'exer': ('exe',),
'exes': ('exe',),
'exa': ('exe',),
'exet': ('exe',),
'exa': ('exe',),
'exet': ('exe',),
'ex': ('exe',),
'exit': ('exit',),
'fôre': ('fôre',),
'fôrer': ('fôre',),
'fôres': ('fôre',),
'fôra': ('fôre',),
'fôret': ('fôre',),
'fôrte': ('fôre',),
'fôra': ('fôre',),
'fôret': ('fôre',),
'fôrt': ('fôre',),
'fôr': ('fôre',),
'fable': ('fable',),
'fabler': ('fable',),
'fables': ('fable',),
'fabla': ('fable',),
'fablet': ('fable',),
'fabla': ('fable',),
'fablet': ('fable',),
'fabl': ('fable',),
'fable': ('fable',),
'fabl': ('fable',),
'fable': ('fable',),
'fabrikkere': ('fabrikkere',),
'fabrikkerer': ('fabrikkere',),
'fabrikkeres': ('fabrikkere',),
'fabrikkerte': ('fabrikkere',),
'fabrikkert': ('fabrikkere',),
'fabrikker': ('fabrikkere',),
'fabulere': ('fabulere',),
'fabulerer': ('fabulere',),
'fabuleres': ('fabulere',),
'fabulerte': ('fabulere',),
'fabulert': ('fabulere',),
'fabuler': ('fabulere',),
'fade': ('fade',),
'fader': ('fade',),
'fades': ('fade',),
'fada': ('fade',),
'fadet': ('fade',),
'fada': ('fade',),
'fadet': ('fade',),
'fad': ('fade',),
'fagne': ('fagne',),
'fagner': ('fagne',),
'fagnes': ('fagne',),
'fagna': ('fagne',),
'fagnet': ('fagne',),
'fagna': ('fagne',),
'fagnet': ('fagne',),
'fagn': ('fagne',),
'fakke': ('fakke',),
'fakker': ('fakke',),
'fakkes': ('fakke',),
'fakka': ('fakke',),
'fakket': ('fakke',),
'fakka': ('fakke',),
'fakket': ('fakke',),
'fakk': ('fakke',),
'fakse': ('fakse',),
'fakser': ('fakse',),
'fakses': ('fakse',),
'faksa': ('fakse',),
'fakset': ('fakse',),
'faksa': ('fakse',),
'fakset': ('fakse',),
'faks': ('fakse',),
'faksimilere': ('faksimilere',),
'faksimilerer': ('faksimilere',),
'faksimileres': ('faksimilere',),
'faksimilerte': ('faksimilere',),
'faksimilert': ('faksimilere',),
'faksimiler': ('faksimilere',),
'faktorisere': ('faktorisere',),
'faktoriserer': ('faktorisere',),
'faktoriseres': ('faktorisere',),
'faktoriserte': ('faktorisere',),
'faktorisert': ('faktorisere',),
'faktoriser': ('faktorisere',),
'fakturere': ('fakturere',),
'fakturerer': ('fakturere',),
'faktureres': ('fakturere',),
'fakturerte': ('fakturere',),
'fakturert': ('fakturere',),
'fakturer': ('fakturere',),
'falby': ('falby',),
'falbyr': ('falby',),
'falbys': ('falby',),
'falbydde': ('falby',),
'falbød': ('falby',),
'falbøy': ('falby',),
'falbydd': ('falby',),
'falbudt': ('falby',),
'falbydd': ('falby',),
'falby': ('falby',),
'falde': ('falde',),
'falder': ('falde',),
'faldes': ('falde',),
'falda': ('falde',),
'faldet': ('falde',),
'falda': ('falde',),
'faldet': ('falde',),
'fald': ('falde',),
'falle': ('falle',),
'faller': ('falle',),
'falles': ('falle',),
'falt': ('falle',),
'fall': ('falle',),
'fallere': ('fallere',),
'fallerer': ('fallere',),
'falleres': ('fallere',),
'fallerte': ('fallere',),
'fallert': ('fallere',),
'faller': ('fallere',),
'falme': ('falme',),
'falmer': ('falme',),
'falmes': ('falme',),
'falma': ('falme',),
'falmet': ('falme',),
'falma': ('falme',),
'falmet': ('falme',),
'falm': ('falme',),
'false': ('false',),
'falser': ('false',),
'falses': ('false',),
'falsa': ('false',),
'falset': ('false',),
'falsa': ('false',),
'falset': ('false',),
'fals': ('false',),
'falsifisere': ('falsifisere',),
'falsifiserer': ('falsifisere',),
'falsifiseres': ('falsifisere',),
'falsifiserte': ('falsifisere',),
'falsifisert': ('falsifisere',),
'falsifiser': ('falsifisere',),
'famle': ('famle',),
'famler': ('famle',),
'famles': ('famle',),
'famla': ('famle',),
'famlet': ('famle',),
'famla': ('famle',),
'famlet': ('famle',),
'faml': ('famle',),
'famle': ('famle',),
'faml': ('famle',),
'famle': ('famle',),
'fange': ('fange',),
'fanger': ('fange',),
'fanges': ('fange',),
'fanga': ('fange',),
'fanget': ('fange',),
'fanga': ('fange',),
'fanget': ('fange',),
'fang': ('fange',),
'fangste': ('fangste',),
'fangster': ('fangste',),
'fangstes': ('fangste',),
'fangsta': ('fangste',),
'fangstet': ('fangste',),
'fangsta': ('fangste',),
'fangstet': ('fangste',),
'fangst': ('fangste',),
'fantasere': ('fantasere',),
'fantaserer': ('fantasere',),
'fantaseres': ('fantasere',),
'fantaserte': ('fantasere',),
'fantasert': ('fantasere',),
'fantaser': ('fantasere',),
'fantegå': ('fantegå',),
'fantegår': ('fantegå',),
'fantegås': ('fantegå',),
'fantegikk': ('fantegå',),
'fantegått': ('fantegå',),
'fantegå': ('fantegå',),
'fare': ('fare',),
'farer': ('fare',),
'fares': ('fare',),
'for': ('fare',),
'fart': ('fare',),
'far': ('fare',),
'farge': ('farge',),
'farger': ('farge',),
'farges': ('farge',),
'farga': ('farge',),
'farget': ('farge',),
'farga': ('farge',),
'farget': ('farge',),
'farg': ('farge',),
'farsere': ('farsere',),
'farserer': ('farsere',),
'farseres': ('farsere',),
'farserte': ('farsere',),
'farsert': ('farsere',),
'farser': ('farsere',),
'farte': ('farte',),
'farter': ('farte',),
'fartes': ('farte',),
'farta': ('farte',),
'fartet': ('farte',),
'farta': ('farte',),
'fartet': ('farte',),
'fart': ('farte',),
'fascinere': ('fascinere',),
'fascinerer': ('fascinere',),
'fascineres': ('fascinere',),
'fascinerte': ('fascinere',),
'fascinert': ('fascinere',),
'fasciner': ('fascinere',),
'fase': ('fase',),
'faser': ('fase',),
'fases': ('fase',),
'fasa': ('fase',),
'faset': ('fase',),
'fasa': ('fase',),
'faset': ('fase',),
'fas': ('fase',),
'fasettere': ('fasettere',),
'fasetterer': ('fasettere',),
'fasetteres': ('fasettere',),
'fasetterte': ('fasettere',),
'fasettert': ('fasettere',),
'fasetter': ('fasettere',),
'fasle': ('fasle',),
'fasler': ('fasle',),
'fasles': ('fasle',),
'fasla': ('fasle',),
'faslet': ('fasle',),
'fasla': ('fasle',),
'faslet': ('fasle',),
'fasl': ('fasle',),
'fasle': ('fasle',),
'fasl': ('fasle',),
'fasle': ('fasle',),
'fasongere': ('fasongere',),
'fasongerer': ('fasongere',),
'fasongeres': ('fasongere',),
'fasongerte': ('fasongere',),
'fasongert': ('fasongere',),
'fasonger': ('fasongere',),
'faste': ('faste',),
'faster': ('faste',),
'fastes': ('faste',),
'fasta': ('faste',),
'fastet': ('faste',),
'fasta': ('faste',),
'fastet': ('faste',),
'fast': ('faste',),
'fastholde': ('fastholde',),
'fastholder': ('fastholde',),
'fastholdes': ('fastholde',),
'fastholdt': ('fastholde',),
'fasthold': ('fastholde',),
'fastlegge': ('fastlegge',),
'fastlegger': ('fastlegge',),
'fastlegges': ('fastlegge',),
'fastla': ('fastlegge',),
'fastlagt': ('fastlegge',),
'fastlegg': ('fastlegge',),
'fastlåse': ('fastlåse',),
'fastlåser': ('fastlåse',),
'fastlåses': ('fastlåse',),
'fastlåste': ('fastlåse',),
'fastlåst': ('fastlåse',),
'fastlås': ('fastlåse',),
'fastne': ('fastne',),
'fastner': ('fastne',),
'fastnes': ('fastne',),
'fastna': ('fastne',),
'fastnet': ('fastne',),
'fastna': ('fastne',),
'fastnet': ('fastne',),
'fastn': ('fastne',),
'fastne': ('fastne',),
'fastn': ('fastne',),
'fastne': ('fastne',),
'fastsette': ('fastsette',),
'fastsetter': ('fastsette',),
'fastsettes': ('fastsette',),
'fastsatte': ('fastsette',),
'fastsatt': ('fastsette',),
'fastsett': ('fastsette',),
'fate': ('fate',),
'fater': ('fate',),
'fates': ('fate',),
'fata': ('fate',),
'fatet': ('fate',),
'fata': ('fate',),
'fatet': ('fate',),
'fat': ('fate',),
'fatle': ('fatle',),
'fatler': ('fatle',),
'fatles': ('fatle',),
'fatla': ('fatle',),
'fatlet': ('fatle',),
'fatla': ('fatle',),
'fatlet': ('fatle',),
'fatl': ('fatle',),
'fatle': ('fatle',),
'fatl': ('fatle',),
'fatle': ('fatle',),
'fatte': ('fatte',),
'fatter': ('fatte',),
'fattes': ('fatte',),
'fatta': ('fatte',),
'fattet': ('fatte',),
'fatta': ('fatte',),
'fattet': ('fatte',),
'fatt': ('fatte',),
'fattes': ('fattes',),
'fattedes': ('fattes',),
'fattes': ('fattes',),
'favne': ('favne',),
'favner': ('favne',),
'favnes': ('favne',),
'favna': ('favne',),
'favnet': ('favne',),
'favna': ('favne',),
'favnet': ('favne',),
'favn': ('favne',),
'favorisere': ('favorisere',),
'favoriserer': ('favorisere',),
'favoriseres': ('favorisere',),
'favoriserte': ('favorisere',),
'favorisert': ('favorisere',),
'favoriser': ('favorisere',),
'feide': ('feide',),
'feider': ('feide',),
'feides': ('feide',),
'feida': ('feide',),
'feidet': ('feide',),
'feida': ('feide',),
'feidet': ('feide',),
'feid': ('feide',),
'feie': ('feie',),
'feier': ('feie',),
'feies': ('feie',),
'feia': ('feie',),
'feiet': ('feie',),
'feide': ('feie',),
'feia': ('feie',),
'feiet': ('feie',),
'feid': ('feie',),
'fei': ('feie',),
'feilbedømme': ('feilbedømme',),
'feilbedømmer': ('feilbedømme',),
'feilbedømmes': ('feilbedømme',),
'feilbedømte': ('feilbedømme',),
'feilbedømt': ('feilbedømme',),
'feilbedøm': ('feilbedømme',),
'feile': ('feile',),
'feiler': ('feile',),
'feiles': ('feile',),
'feila': ('feile',),
'feilet': ('feile',),
'feilte': ('feile',),
'feila': ('feile',),
'feilet': ('feile',),
'feilt': ('feile',),
'feil': ('feile',),
'feilvurdere': ('feilvurdere',),
'feilvurderer': ('feilvurdere',),
'feilvurderes': ('feilvurdere',),
'feilvurderte': ('feilvurdere',),
'feilvurdert': ('feilvurdere',),
'feilvurder': ('feilvurdere',),
'feire': ('feire',),
'feirer': ('feire',),
'feires': ('feire',),
'feira': ('feire',),
'feiret': ('feire',),
'feira': ('feire',),
'feiret': ('feire',),
'feir': ('feire',),
'feite': ('feite',),
'feiter': ('feite',),
'feites': ('feite',),
'feita': ('feite',),
'feitet': ('feite',),
'feita': ('feite',),
'feitet': ('feite',),
'feit': ('feite',),
'feitne': ('feitne',),
'feitner': ('feitne',),
'feitnes': ('feitne',),
'feitna': ('feitne',),
'feitnet': ('feitne',),
'feitna': ('feitne',),
'feitnet': ('feitne',),
'feitn': ('feitne',),
'feitne': ('feitne',),
'feitn': ('feitne',),
'feitne': ('feitne',),
'fekte': ('fekte',),
'fekter': ('fekte',),
'fektes': ('fekte',),
'fekta': ('fekte',),
'fektet': ('fekte',),
'fekta': ('fekte',),
'fektet': ('fekte',),
'fekt': ('fekte',),
'felle': ('felle',),
'feller': ('felle',),
'felles': ('felle',),
'felte': ('felle',),
'felt': ('felle',),
'fell': ('felle',),
'femdoble': ('femdoble',),
'femdobler': ('femdoble',),
'femdobles': ('femdoble',),
'femdobla': ('femdoble',),
'femdoblet': ('femdoble',),
'femdobla': ('femdoble',),
'femdoblet': ('femdoble',),
'femdobl': ('femdoble',),
'femdoble': ('femdoble',),
'femdobl': ('femdoble',),
'femdoble': ('femdoble',),
'feminisere': ('feminisere',),
'feminiserer': ('feminisere',),
'feminiseres': ('feminisere',),
'feminiserte': ('feminisere',),
'feminisert': ('feminisere',),
'feminiser': ('feminisere',),
'fenge': ('fenge',),
'fenger': ('fenge',),
'fenges': ('fenge',),
'fenga': ('fenge',),
'fenget': ('fenge',),
'fengte': ('fenge',),
'fenga': ('fenge',),
'fenget': ('fenge',),
'fengt': ('fenge',),
'feng': ('fenge',),
'fengsle': ('fengsle',),
'fengsler': ('fengsle',),
'fengsles': ('fengsle',),
'fengsla': ('fengsle',),
'fengslet': ('fengsle',),
'fengsla': ('fengsle',),
'fengslet': ('fengsle',),
'fengsl': ('fengsle',),
'fengsle': ('fengsle',),
'fengsl': ('fengsle',),
'fengsle': ('fengsle',),
'ferde': ('ferde',),
'ferder': ('ferde',),
'ferdes': ('ferde',),
'ferda': ('ferde',),
'ferdet': ('ferde',),
'ferda': ('ferde',),
'ferdet': ('ferde',),
'ferd': ('ferde',),
'ferdes': ('ferdes',),
'ferdedes': ('ferdes',),
'ferdes': ('ferdes',),
'ferdigbehandle': ('ferdigbehandle',),
'ferdigbehandler': ('ferdigbehandle',),
'ferdigbehandles': ('ferdigbehandle',),
'ferdigbehandla': ('ferdigbehandle',),
'ferdigbehandlet': ('ferdigbehandle',),
'ferdigbehandla': ('ferdigbehandle',),
'ferdigbehandlet': ('ferdigbehandle',),
'ferdigbehandl': ('ferdigbehandle',),
'ferdigbehandle': ('ferdigbehandle',),
'ferdigbehandl': ('ferdigbehandle',),
'ferdigbehandle': ('ferdigbehandle',),
'ferge': ('ferge',),
'ferger': ('ferge',),
'ferges': ('ferge',),
'ferga': ('ferge',),
'ferget': ('ferge',),
'ferga': ('ferge',),
'ferget': ('ferge',),
'ferg': ('ferge',),
'feriere': ('feriere',),
'ferierer': ('feriere',),
'ferieres': ('feriere',),
'ferierte': ('feriere',),
'feriert': ('feriere',),
'ferier': ('feriere',),
'ferje': ('ferje',),
'ferjer': ('ferje',),
'ferjes': ('ferje',),
'ferja': ('ferje',),
'ferjet': ('ferje',),
'ferja': ('ferje',),
'ferjet': ('ferje',),
'ferj': ('ferje',),
'ferme': ('ferme',),
'fermer': ('ferme',),
'fermes': ('ferme',),
'ferma': ('ferme',),
'fermet': ('ferme',),
'ferma': ('ferme',),
'fermet': ('ferme',),
'ferm': ('ferme',),
'fermentere': ('fermentere',),
'fermenterer': ('fermentere',),
'fermenteres': ('fermentere',),
'fermenterte': ('fermentere',),
'fermentert': ('fermentere',),
'fermenter': ('fermentere',),
'fernissere': ('fernissere',),
'fernisserer': ('fernissere',),
'fernisseres': ('fernissere',),
'fernisserte': ('fernissere',),
'fernissert': ('fernissere',),
'fernisser': ('fernissere',),
'ferske': ('ferske',),
'fersker': ('ferske',),
'ferskes': ('ferske',),
'ferska': ('ferske',),
'fersket': ('ferske',),
'ferska': ('ferske',),
'fersket': ('ferske',),
'fersk': ('ferske',),
'feste': ('feste',),
'fester': ('feste',),
'festes': ('feste',),
'festa': ('feste',),
'festet': ('feste',),
'festa': ('feste',),
'festet': ('feste',),
'fest': ('feste',),
'festne': ('festne',),
'festner': ('festne',),
'festnes': ('festne',),
'festna': ('festne',),
'festnet': ('festne',),
'festna': ('festne',),
'festnet': ('festne',),
'festn': ('festne',),
'festne': ('festne',),
'festn': ('festne',),
'festne': ('festne',),
'fete': ('fete',),
'feter': ('fete',),
'fetes': ('fete',),
'feta': ('fete',),
'fetet': ('fete',),
'feta': ('fete',),
'fetet': ('fete',),
'fet': ('fete',),
'fetere': ('fetere',),
'feterer': ('fetere',),
'feteres': ('fetere',),
'feterte': ('fetere',),
'fetert': ('fetere',),
'feter': ('fetere',),
'fetne': ('fetne',),
'fetner': ('fetne',),
'fetnes': ('fetne',),
'fetna': ('fetne',),
'fetnet': ('fetne',),
'fetna': ('fetne',),
'fetnet': ('fetne',),
'fetn': ('fetne',),
'fetne': ('fetne',),
'fetn': ('fetne',),
'fetne': ('fetne',),
'fiffe': ('fiffe',),
'fiffer': ('fiffe',),
'fiffes': ('fiffe',),
'fiffa': ('fiffe',),
'fiffet': ('fiffe',),
'fiffa': ('fiffe',),
'fiffet': ('fiffe',),
'fiff': ('fiffe',),
'fighte': ('fighte',),
'fighter': ('fighte',),
'fightes': ('fighte',),
'fighta': ('fighte',),
'fightet': ('fighte',),
'fighta': ('fighte',),
'fightet': ('fighte',),
'fight': ('fighte',),
'figurere': ('figurere',),
'figurerer': ('figurere',),
'figureres': ('figurere',),
'figurerte': ('figurere',),
'figurert': ('figurere',),
'figurer': ('figurere',),
'fike': ('fike',),
'fiker': ('fike',),
'fikes': ('fike',),
'fika': ('fike',),
'fiket': ('fike',),
'fikte': ('fike',),
'fika': ('fike',),
'fiket': ('fike',),
'fikt': ('fike',),
'fik': ('fike',),
'fikle': ('fikle',),
'fikler': ('fikle',),
'fikles': ('fikle',),
'fikla': ('fikle',),
'fiklet': ('fikle',),
'fikla': ('fikle',),
'fiklet': ('fikle',),
'fikl': ('fikle',),
'fikle': ('fikle',),
'fikl': ('fikle',),
'fikle': ('fikle',),
'fikse': ('fikse',),
'fikser': ('fikse',),
'fikses': ('fikse',),
'fiksa': ('fikse',),
'fikset': ('fikse',),
'fiksa': ('fikse',),
'fikset': ('fikse',),
'fiks': ('fikse',),
'fiksere': ('fiksere',),
'fikserer': ('fiksere',),
'fikseres': ('fiksere',),
'fikserte': ('fiksere',),
'fiksert': ('fiksere',),
'fikser': ('fiksere',),
'file': ('file',),
'filer': ('file',),
'files': ('file',),
'fila': ('file',),
'filet': ('file',),
'filte': ('file',),
'fila': ('file',),
'filet': ('file',),
'filt': ('file',),
'fil': ('file',),
'filere': ('filere',),
'filerer': ('filere',),
'fileres': ('filere',),
'filerte': ('filere',),
'filert': ('filere',),
'filer': ('filere',),
'filetere': ('filetere',),
'fileterer': ('filetere',),
'fileteres': ('filetere',),
'fileterte': ('filetere',),
'filetert': ('filetere',),
'fileter': ('filetere',),
'filmatisere': ('filmatisere',),
'filmatiserer': ('filmatisere',),
'filmatiseres': ('filmatisere',),
'filmatiserte': ('filmatisere',),
'filmatisert': ('filmatisere',),
'filmatiser': ('filmatisere',),
'filme': ('filme',),
'filmer': ('filme',),
'filmes': ('filme',),
'filma': ('filme',),
'filmet': ('filme',),
'filma': ('filme',),
'filmet': ('filme',),
'film': ('filme',),
'filosofere': ('filosofere',),
'filosoferer': ('filosofere',),
'filosoferes': ('filosofere',),
'filosoferte': ('filosofere',),
'filosofert': ('filosofere',),
'filosofer': ('filosofere',),
'filtre': ('filtre',),
'filtrer': ('filtre',),
'filtres': ('filtre',),
'filtra': ('filtre',),
'filtret': ('filtre',),
'filtra': ('filtre',),
'filtret': ('filtre',),
'filtr': ('filtre',),
'filtre': ('filtre',),
'filtr': ('filtre',),
'filtre': ('filtre',),
'filtrere': ('filtrere',),
'filtrerer': ('filtrere',),
'filtreres': ('filtrere',),
'filtrerte': ('filtrere',),
'filtrert': ('filtrere',),
'filtrer': ('filtrere',),
'finansiere': ('finansiere',),
'finansierer': ('finansiere',),
'finansieres': ('finansiere',),
'finansierte': ('finansiere',),
'finansiert': ('finansiere',),
'finansier': ('finansiere',),
'finere': ('finere',),
'finerer': ('finere',),
'fineres': ('finere',),
'finerte': ('finere',),
'finert': ('finere',),
'finer': ('finere',),
'finfordele': ('finfordele',),
'finfordeler': ('finfordele',),
'finfordeles': ('finfordele',),
'finfordelte': ('finfordele',),
'finfordelt': ('finfordele',),
'finfordel': ('finfordele',),
'fingere': ('fingere',),
'fingerer': ('fingere',),
'fingeres': ('fingere',),
'fingerte': ('fingere',),
'fingert': ('fingere',),
'finger': ('fingere',),
'fingre': ('fingre',),
'fingrer': ('fingre',),
'fingres': ('fingre',),
'fingra': ('fingre',),
'fingret': ('fingre',),
'fingra': ('fingre',),
'fingret': ('fingre',),
'fingr': ('fingre',),
'fingre': ('fingre',),
'fingr': ('fingre',),
'fingre': ('fingre',),
'finhakke': ('finhakke',),
'finhakker': ('finhakke',),
'finhakkes': ('finhakke',),
'finhakka': ('finhakke',),
'finhakket': ('finhakke',),
'finhakka': ('finhakke',),
'finhakket': ('finhakke',),
'finhakk': ('finhakke',),
'finhøvle': ('finhøvle',),
'finhøvler': ('finhøvle',),
'finhøvles': ('finhøvle',),
'finhøvla': ('finhøvle',),
'finhøvlet': ('finhøvle',),
'finhøvla': ('finhøvle',),
'finhøvlet': ('finhøvle',),
'finhøvl': ('finhøvle',),
'finhøvle': ('finhøvle',),
'finhøvl': ('finhøvle',),
'finhøvle': ('finhøvle',),
'fininnstille': ('fininnstille',),
'fininnstiller': ('fininnstille',),
'fininnstilles': ('fininnstille',),
'fininnstilte': ('fininnstille',),
'fininnstilt': ('fininnstille',),
'fininnstill': ('fininnstille',),
'finkjemme': ('finkjemme',),
'finkjemmer': ('finkjemme',),
'finkjemmes': ('finkjemme',),
'finkjemma': ('finkjemme',),
'finkjemmet': ('finkjemme',),
'finkjemte': ('finkjemme',),
'finkjemma': ('finkjemme',),
'finkjemmet': ('finkjemme',),
'finkjemt': ('finkjemme',),
'finkjem': ('finkjemme',),
'finmale': ('finmale',),
'finmaler': ('finmale',),
'finmales': ('finmale',),
'finmalte': ('finmale',),
'finmalt': ('finmale',),
'finmal': ('finmale',),
'finne': ('finne',),
'finner': ('finne',),
'finnes': ('finne',),
'fant': ('finne',),
'funnet': ('finne',),
'finn': ('finne',),
'finnes': ('finnes',),
'fins': ('finnes',),
'fantes': ('finnes',),
'funnes': ('finnes',),
'finnes': ('finnes',),
'finpusse': ('finpusse',),
'finpusser': ('finpusse',),
'finpusses': ('finpusse',),
'finpussa': ('finpusse',),
'finpusset': ('finpusse',),
'finpussa': ('finpusse',),
'finpusset': ('finpusse',),
'finpuss': ('finpusse',),
'finsikte': ('finsikte',),
'finsikter': ('finsikte',),
'finsiktes': ('finsikte',),
'finsikta': ('finsikte',),
'finsiktet': ('finsikte',),
'finsikta': ('finsikte',),
'finsiktet': ('finsikte',),
'finsikt': ('finsikte',),
'finte': ('finte',),
'finter': ('finte',),
'fintes': ('finte',),
'finta': ('finte',),
'fintet': ('finte',),
'finta': ('finte',),
'fintet': ('finte',),
'fint': ('finte',),
'fintelle': ('fintelle',),
'finteller': ('fintelle',),
'fintelles': ('fintelle',),
'fintellet': ('fintelle',),
'fintelte': ('fintelle',),
'fintalte': ('fintelle',),
'fintellet': ('fintelle',),
'fintelt': ('fintelle',),
'fintalt': ('fintelle',),
'fintell': ('fintelle',),
'firdoble': ('firdoble',),
'firdobler': ('firdoble',),
'firdobles': ('firdoble',),
'firdobla': ('firdoble',),
'firdoblet': ('firdoble',),
'firdobla': ('firdoble',),
'firdoblet': ('firdoble',),
'firdobl': ('firdoble',),
'firdoble': ('firdoble',),
'firdobl': ('firdoble',),
'firdoble': ('firdoble',),
'fire': ('fire',),
'firer': ('fire',),
'fires': ('fire',),
'fira': ('fire',),
'firet': ('fire',),
'firte': ('fire',),
'fira': ('fire',),
'firet': ('fire',),
'firt': ('fire',),
'fir': ('fire',),
'firedoble': ('firedoble',),
'firedobler': ('firedoble',),
'firedobles': ('firedoble',),
'firedobla': ('firedoble',),
'firedoblet': ('firedoble',),
'firedobla': ('firedoble',),
'firedoblet': ('firedoble',),
'firedobl': ('firedoble',),
'firedoble': ('firedoble',),
'firedobl': ('firedoble',),
'firedoble': ('firedoble',),
'fise': ('fise',),
'fiser': ('fise',),
'fises': ('fise',),
'fiste': ('fise',),
'fes': ('fise',),
'feis': ('fise',),
'fes': ('fise',),
'feis': ('fise',),
'fist': ('fise',),
'feset': ('fise',),
'fis': ('fise',),
'fisjonere': ('fisjonere',),
'fisjonerer': ('fisjonere',),
'fisjoneres': ('fisjonere',),
'fisjonerte': ('fisjonere',),
'fisjonert': ('fisjonere',),
'fisjoner': ('fisjonere',),
'fiske': ('fiske',),
'fisker': ('fiske',),
'fiskes': ('fiske',),
'fiska': ('fiske',),
'fisket': ('fiske',),
'fiska': ('fiske',),
'fisket': ('fiske',),
'fisk': ('fiske',),
'fisle': ('fisle',),
'fisler': ('fisle',),
'fisles': ('fisle',),
'fisla': ('fisle',),
'fislet': ('fisle',),
'fisla': ('fisle',),
'fislet': ('fisle',),
'fisl': ('fisle',),
'fisle': ('fisle',),
'fisl': ('fisle',),
'fisle': ('fisle',),
'fjamse': ('fjamse',),
'fjamser': ('fjamse',),
'fjamses': ('fjamse',),
'fjamsa': ('fjamse',),
'fjamset': ('fjamse',),
'fjamsa': ('fjamse',),
'fjamset': ('fjamse',),
'fjams': ('fjamse',),
'fjase': ('fjase',),
'fjaser': ('fjase',),
'fjases': ('fjase',),
'fjasa': ('fjase',),
'fjaset': ('fjase',),
'fjaste': ('fjase',),
'fjasa': ('fjase',),
'fjaset': ('fjase',),
'fjast': ('fjase',),
'fjas': ('fjase',),
'fjelge': ('fjelge',),
'fjelger': ('fjelge',),
'fjelges': ('fjelge',),
'fjelga': ('fjelge',),
'fjelget': ('fjelge',),
'fjelga': ('fjelge',),
'fjelget': ('fjelge',),
'fjelg': ('fjelge',),
'fjerne': ('fjerne',),
'fjerner': ('fjerne',),
'fjernes': ('fjerne',),
'fjerna': ('fjerne',),
'fjernet': ('fjerne',),
'fjerna': ('fjerne',),
'fjernet': ('fjerne',),
'fjern': ('fjerne',),
'fjernstyre': ('fjernstyre',),
'fjernstyrer': ('fjernstyre',),
'fjernstyres': ('fjernstyre',),
'fjernstyrte': ('fjernstyre',),
'fjernstyrt': ('fjernstyre',),
'fjernstyr': ('fjernstyre',),
'fjerte': ('fjerte',),
'fjerter': ('fjerte',),
'fjertes': ('fjerte',),
'fjerta': ('fjerte',),
'fjertet': ('fjerte',),
'fjerta': ('fjerte',),
'fjertet': ('fjerte',),
'fjert': ('fjerte',),
'fjeske': ('fjeske',),
'fjesker': ('fjeske',),
'fjeskes': ('fjeske',),
'fjeska': ('fjeske',),
'fjesket': ('fjeske',),
'fjeska': ('fjeske',),
'fjesket': ('fjeske',),
'fjesk': ('fjeske',),
'fjetre': ('fjetre',),
'fjetrer': ('fjetre',),
'fjetres': ('fjetre',),
'fjetra': ('fjetre',),
'fjetret': ('fjetre',),
'fjetra': ('fjetre',),
'fjetret': ('fjetre',),
'fjetr': ('fjetre',),
'fjetre': ('fjetre',),
'fjetr': ('fjetre',),
'fjetre': ('fjetre',),
'fjolle': ('fjolle',),
'fjoller': ('fjolle',),
'fjolles': ('fjolle',),
'fjolla': ('fjolle',),
'fjollet': ('fjolle',),
'fjolla': ('fjolle',),
'fjollet': ('fjolle',),
'fjoll': ('fjolle',),
'fjuske': ('fjuske',),
'fjusker': ('fjuske',),
'fjuskes': ('fjuske',),
'fjuska': ('fjuske',),
'fjusket': ('fjuske',),
'fjuska': ('fjuske',),
'fjusket': ('fjuske',),
'fjusk': ('fjuske',),
'fjære': ('fjære',),
'fjærer': ('fjære',),
'fjæres': ('fjære',),
'fjæra': ('fjære',),
'fjæret': ('fjære',),
'fjæra': ('fjære',),
'fjæret': ('fjære',),
'fjær': ('fjære',),
'fjøre': ('fjøre',),
'fjører': ('fjøre',),
'fjøres': ('fjøre',),
'fjøra': ('fjøre',),
'fjøret': ('fjøre',),
'fjøra': ('fjøre',),
'fjøret': ('fjøre',),
'fjør': ('fjøre',),
'flagge': ('flagge',),
'flagger': ('flagge',),
'flagges': ('flagge',),
'flagga': ('flagge',),
'flagget': ('flagge',),
'flagga': ('flagge',),
'flagget': ('flagge',),
'flagg': ('flagge',),
'flagre': ('flagre',),
'flagrer': ('flagre',),
'flagres': ('flagre',),
'flagra': ('flagre',),
'flagret': ('flagre',),
'flagra': ('flagre',),
'flagret': ('flagre',),
'flagr': ('flagre',),
'flagre': ('flagre',),
'flagr': ('flagre',),
'flagre': ('flagre',),
'flake': ('flake',),
'flaker': ('flake',),
'flakes': ('flake',),
'flaka': ('flake',),
'flaket': ('flake',),
'flakte': ('flake',),
'flaka': ('flake',),
'flaket': ('flake',),
'flakt': ('flake',),
'flak': ('flake',),
'flakke': ('flakke',),
'flakker': ('flakke',),
'flakkes': ('flakke',),
'flakka': ('flakke',),
'flakket': ('flakke',),
'flakka': ('flakke',),
'flakket': ('flakke',),
'flakk': ('flakke',),
'flakne': ('flakne',),
'flakner': ('flakne',),
'flaknes': ('flakne',),
'flakna': ('flakne',),
'flaknet': ('flakne',),
'flakna': ('flakne',),
'flaknet': ('flakne',),
'flakn': ('flakne',),
'flakne': ('flakne',),
'flakn': ('flakne',),
'flakne': ('flakne',),
'flakse': ('flakse',),
'flakser': ('flakse',),
'flakses': ('flakse',),
'flaksa': ('flakse',),
'flakset': ('flakse',),
'flaksa': ('flakse',),
'flakset': ('flakse',),
'flaks': ('flakse',),
'flambere': ('flambere',),
'flamberer': ('flambere',),
'flamberes': ('flambere',),
'flamberte': ('flambere',),
'flambert': ('flambere',),
'flamber': ('flambere',),
'flamme': ('flamme',),
'flammer': ('flamme',),
'flammes': ('flamme',),
'flamma': ('flamme',),
'flammet': ('flamme',),
'flamma': ('flamme',),
'flammet': ('flamme',),
'flam': ('flamme',),
'flane': ('flane',),
'flaner': ('flane',),
'flanes': ('flane',),
'flana': ('flane',),
'flanet': ('flane',),
'flante': ('flane',),
'flana': ('flane',),
'flanet': ('flane',),
'flant': ('flane',),
'flan': ('flane',),
'flanere': ('flanere',),
'flanerer': ('flanere',),
'flaneres': ('flanere',),
'flanerte': ('flanere',),
'flanert': ('flanere',),
'flaner': ('flanere',),
'flankere': ('flankere',),
'flankerer': ('flankere',),
'flankeres': ('flankere',),
'flankerte': ('flankere',),
'flankert': ('flankere',),
'flanker': ('flankere',),
'flare': ('flare',),
'flarer': ('flare',),
'flares': ('flare',),
'flara': ('flare',),
'flaret': ('flare',),
'flarte': ('flare',),
'flara': ('flare',),
'flaret': ('flare',),
'flart': ('flare',),
'flar': ('flare',),
'flaske': ('flaske',),
'flasker': ('flaske',),
'flaskes': ('flaske',),
'flaska': ('flaske',),
'flasket': ('flaske',),
'flaska': ('flaske',),
'flasket': ('flaske',),
'flask': ('flaske',),
'flasse': ('flasse',),
'flasser': ('flasse',),
'flasses': ('flasse',),
'flassa': ('flasse',),
'flasset': ('flasse',),
'flassa': ('flasse',),
'flasset': ('flasse',),
'flass': ('flasse',),
'flate': ('flate',),
'flater': ('flate',),
'flates': ('flate',),
'flata': ('flate',),
'flatet': ('flate',),
'flata': ('flate',),
'flatet': ('flate',),
'flat': ('flate',),
'flatne': ('flatne',),
'flatner': ('flatne',),
'flatnes': ('flatne',),
'flatna': ('flatne',),
'flatnet': ('flatne',),
'flatna': ('flatne',),
'flatnet': ('flatne',),
'flatn': ('flatne',),
'flatne': ('flatne',),
'flatn': ('flatne',),
'flatne': ('flatne',),
'flattere': ('flattere',),
'flatterer': ('flattere',),
'flatteres': ('flattere',),
'flatterte': ('flattere',),
'flattert': ('flattere',),
'flatter': ('flattere',),
'flaue': ('flaue',),
'flauer': ('flaue',),
'flaues': ('flaue',),
'flaua': ('flaue',),
'flauet': ('flaue',),
'flaua': ('flaue',),
'flauet': ('flaue',),
'flau': ('flaue',),
'fleipe': ('fleipe',),
'fleiper': ('fleipe',),
'fleipes': ('fleipe',),
'fleipa': ('fleipe',),
'fleipet': ('fleipe',),
'fleipte': ('fleipe',),
'fleipa': ('fleipe',),
'fleipet': ('fleipe',),
'fleipt': ('fleipe',),
'fleip': ('fleipe',),
'flekke': ('flekke',),
'flekker': ('flekke',),
'flekkes': ('flekke',),
'flekka': ('flekke',),
'flekket': ('flekke',),
'flekka': ('flekke',),
'flekket': ('flekke',),
'flekk': ('flekke',),
'flekke': ('flekke',),
'flekker': ('flekke',),
'flekkes': ('flekke',),
'flekket': ('flekke',),
'flekte': ('flekke',),
'flekket': ('flekke',),
'flekt': ('flekke',),
'flekk': ('flekke',),
'flekse': ('flekse',),
'flekser': ('flekse',),
'flekses': ('flekse',),
'fleksa': ('flekse',),
'flekset': ('flekse',),
'fleksa': ('flekse',),
'flekset': ('flekse',),
'fleks': ('flekse',),
'flektere': ('flektere',),
'flekterer': ('flektere',),
'flekteres': ('flektere',),
'flekterte': ('flektere',),
'flektert': ('flektere',),
'flekter': ('flektere',),
'flenge': ('flenge',),
'flenger': ('flenge',),
'flenges': ('flenge',),
'flenga': ('flenge',),
'flenget': ('flenge',),
'flengte': ('flenge',),
'flenga': ('flenge',),
'flenget': ('flenge',),
'flengt': ('flenge',),
'fleng': ('flenge',),
'flense': ('flense',),
'flenser': ('flense',),
'flenses': ('flense',),
'flensa': ('flense',),
'flenset': ('flense',),
'flensa': ('flense',),
'flenset': ('flense',),
'flens': ('flense',),
'flerdoble': ('flerdoble',),
'flerdobler': ('flerdoble',),
'flerdobles': ('flerdoble',),
'flerdobla': ('flerdoble',),
'flerdoblet': ('flerdoble',),
'flerdobla': ('flerdoble',),
'flerdoblet': ('flerdoble',),
'flerdobl': ('flerdoble',),
'flerdoble': ('flerdoble',),
'flerdobl': ('flerdoble',),
'flerdoble': ('flerdoble',),
'flette': ('flette',),
'fletter': ('flette',),
'flettes': ('flette',),
'fletta': ('flette',),
'flettet': ('flette',),
'fletta': ('flette',),
'flettet': ('flette',),
'flett': ('flette',),
'fli': ('fli',),
'flir': ('fli',),
'flis': ('fli',),
'flidde': ('fli',),
'flidd': ('fli',),
'fli': ('fli',),
'flikke': ('flikke',),
'flikker': ('flikke',),
'flikkes': ('flikke',),
'flikka': ('flikke',),
'flikket': ('flikke',),
'flikka': ('flikke',),
'flikket': ('flikke',),
'flikk': ('flikke',),
'flimre': ('flimre',),
'flimrer': ('flimre',),
'flimres': ('flimre',),
'flimra': ('flimre',),
'flimret': ('flimre',),
'flimra': ('flimre',),
'flimret': ('flimre',),
'flimr': ('flimre',),
'flimre': ('flimre',),
'flimr': ('flimre',),
'flimre': ('flimre',),
'flippe': ('flippe',),
'flipper': ('flippe',),
'flippes': ('flippe',),
'flippa': ('flippe',),
'flippet': ('flippe',),
'flippa': ('flippe',),
'flippet': ('flippe',),
'flipp': ('flippe',),
'flire': ('flire',),
'flirer': ('flire',),
'flires': ('flire',),
'flirte': ('flire',),
'flirt': ('flire',),
'flir': ('flire',),
'flise': ('flise',),
'fliser': ('flise',),
'flises': ('flise',),
'flisa': ('flise',),
'fliset': ('flise',),
'fliste': ('flise',),
'flisa': ('flise',),
'fliset': ('flise',),
'flist': ('flise',),
'flis': ('flise',),
'fliselegge': ('fliselegge',),
'fliselegger': ('fliselegge',),
'fliselegges': ('fliselegge',),
'flisela': ('fliselegge',),
'fliselagt': ('fliselegge',),
'fliselegg': ('fliselegge',),
'flislegge': ('flislegge',),
'flislegger': ('flislegge',),
'flislegges': ('flislegge',),
'flisla': ('flislegge',),
'flislagt': ('flislegge',),
'flislegg': ('flislegge',),
'floke': ('floke',),
'floker': ('floke',),
'flokes': ('floke',),
'floka': ('floke',),
'floket': ('floke',),
'floka': ('floke',),
'floket': ('floke',),
'flok': ('floke',),
'flokke': ('flokke',),
'flokker': ('flokke',),
'flokkes': ('flokke',),
'flokka': ('flokke',),
'flokket': ('flokke',),
'flokka': ('flokke',),
'flokket': ('flokke',),
'flokk': ('flokke',),
'flokse': ('flokse',),
'flokser': ('flokse',),
'flokses': ('flokse',),
'floksa': ('flokse',),
'flokset': ('flokse',),
'floksa': ('flokse',),
'flokset': ('flokse',),
'floks': ('flokse',),
'flomme': ('flomme',),
'flommer': ('flomme',),
'flommes': ('flomme',),
'flomma': ('flomme',),
'flommet': ('flomme',),
'flomma': ('flomme',),
'flommet': ('flomme',),
'flom': ('flomme',),
'floppe': ('floppe',),
'flopper': ('floppe',),
'floppes': ('floppe',),
'floppa': ('floppe',),
'floppet': ('floppe',),
'floppa': ('floppe',),
'floppet': ('floppe',),
'flopp': ('floppe',),
'floragrafere': ('floragrafere',),
'floragraferer': ('floragrafere',),
'floragraferes': ('floragrafere',),
'floragraferte': ('floragrafere',),
'floragrafert': ('floragrafere',),
'floragrafer': ('floragrafere',),
'florere': ('florere',),
'florerer': ('florere',),
'floreres': ('florere',),
'florerte': ('florere',),
'florert': ('florere',),
'florer': ('florere',),
'flotte': ('flotte',),
'flotter': ('flotte',),
'flottes': ('flotte',),
'flotta': ('flotte',),
'flottet': ('flotte',),
'flotta': ('flotte',),
'flottet': ('flotte',),
'flott': ('flotte',),
'flukte': ('flukte',),
'flukter': ('flukte',),
'fluktes': ('flukte',),
'flukta': ('flukte',),
'fluktet': ('flukte',),
'flukta': ('flukte',),
'fluktet': ('flukte',),
'flukt': ('flukte',),
'fluktuere': ('fluktuere',),
'fluktuerer': ('fluktuere',),
'fluktueres': ('fluktuere',),
'fluktuerte': ('fluktuere',),
'fluktuert': ('fluktuere',),
'fluktuer': ('fluktuere',),
'fluorescere': ('fluorescere',),
'fluorescerer': ('fluorescere',),
'fluoresceres': ('fluorescere',),
'fluorescerte': ('fluorescere',),
'fluorescert': ('fluorescere',),
'fluorescer': ('fluorescere',),
'fluoridere': ('fluoridere',),
'fluoriderer': ('fluoridere',),
'fluorideres': ('fluoridere',),
'fluoriderte': ('fluoridere',),
'fluoridert': ('fluoridere',),
'fluorider': ('fluoridere',),
'fluorisere': ('fluorisere',),
'fluoriserer': ('fluorisere',),
'fluoriseres': ('fluorisere',),
'fluoriserte': ('fluorisere',),
'fluorisert': ('fluorisere',),
'fluoriser': ('fluorisere',),
'fly': ('fly',),
'flyr': ('fly',),
'flys': ('fly',),
'fløy': ('fly',),
'flydd': ('fly',),
'fløyet': ('fly',),
'fly': ('fly',),
'flyge': ('flyge',),
'flyger': ('flyge',),
'flyges': ('flyge',),
'fløy': ('flyge',),
'fløyet': ('flyge',),
'flyg': ('flyge',),
'flykte': ('flykte',),
'flykter': ('flykte',),
'flyktes': ('flykte',),
'flykta': ('flykte',),
'flyktet': ('flykte',),
'flykta': ('flykte',),
'flyktet': ('flykte',),
'flykt': ('flykte',),
'flyte': ('flyte',),
'flyter': ('flyte',),
'flytes': ('flyte',),
'fløyt': ('flyte',),
'fløt': ('flyte',),
'flytt': ('flyte',),
'flyt': ('flyte',),
'flytte': ('flytte',),
'flytter': ('flytte',),
'flyttes': ('flytte',),
'flytta': ('flytte',),
'flyttet': ('flytte',),
'flytta': ('flytte',),
'flyttet': ('flytte',),
'flytt': ('flytte',),
'flå': ('flå',),
'flår': ('flå',),
'flås': ('flå',),
'flådde': ('flå',),
'flådd': ('flå',),
'flå': ('flå',),
'flåse': ('flåse',),
'flåser': ('flåse',),
'flåses': ('flåse',),
'flåste': ('flåse',),
'flåst': ('flåse',),
'flås': ('flåse',),
'flæ': ('flæ',),
'flær': ('flæ',),
'flæs': ('flæ',),
'flædde': ('flæ',),
'flædd': ('flæ',),
'flæ': ('flæ',),
'flære': ('flære',),
'flærer': ('flære',),
'flæres': ('flære',),
'flæra': ('flære',),
'flæret': ('flære',),
'flæra': ('flære',),
'flæret': ('flære',),
'flær': ('flære',),
'flø': ('flø',),
'flør': ('flø',),
'fløs': ('flø',),
'flødde': ('flø',),
'flødd': ('flø',),
'flø': ('flø',),
'fløke': ('fløke',),
'fløker': ('fløke',),
'fløkes': ('fløke',),
'fløkte': ('fløke',),
'fløkt': ('fløke',),
'fløk': ('fløke',),
'flømme': ('flømme',),
'flømmer': ('flømme',),
'flømmes': ('flømme',),
'flømmet': ('flømme',),
'flømte': ('flømme',),
'flømmet': ('flømme',),
'flømt': ('flømme',),
'fløm': ('flømme',),
'flørte': ('flørte',),
'flørter': ('flørte',),
'flørtes': ('flørte',),
'flørta': ('flørte',),
'flørtet': ('flørte',),
'flørta': ('flørte',),
'flørtet': ('flørte',),
'flørt': ('flørte',),
'fløte': ('fløte',),
'fløter': ('fløte',),
'fløtes': ('fløte',),
'fløta': ('fløte',),
'fløtet': ('fløte',),
'fløtte': ('fløte',),
'fløta': ('fløte',),
'fløtet': ('fløte',),
'fløtt': ('fløte',),
'fløt': ('fløte',),
'fløyte': ('fløyte',),
'fløyter': ('fløyte',),
'fløytes': ('fløyte',),
'fløyta': ('fløyte',),
'fløytet': ('fløyte',),
'fløyta': ('fløyte',),
'fløytet': ('fløyte',),
'fløyt': ('fløyte',),
'fløyte': ('fløyte',),
'fløyter': ('fløyte',),
'fløytes': ('fløyte',),
'fløyta': ('fløyte',),
'fløytet': ('fløyte',),
'fløyta': ('fløyte',),
'fløytet': ('fløyte',),
'fløyt': ('fløyte',),
'fnise': ('fnise',),
'fniser': ('fnise',),
'fnises': ('fnise',),
'fniste': ('fnise',),
'fnist': ('fnise',),
'fnis': ('fnise',),
'fnyse': ('fnyse',),
'fnyser': ('fnyse',),
'fnyses': ('fnyse',),
'fnyste': ('fnyse',),
'fnøs': ('fnyse',),
'fnyst': ('fnyse',),
'fnys': ('fnyse',),
'fokusere': ('fokusere',),
'fokuserer': ('fokusere',),
'fokuseres': ('fokusere',),
'fokuserte': ('fokusere',),
'fokusert': ('fokusere',),
'fokuser': ('fokusere',),
'folde': ('folde',),
'folder': ('folde',),
'foldes': ('folde',),
'folda': ('folde',),
'foldet': ('folde',),
'folda': ('folde',),
'foldet': ('folde',),
'fold': ('folde',),
'fole': ('fole',),
'foler': ('fole',),
'foles': ('fole',),
'fola': ('fole',),
'folet': ('fole',),
'fola': ('fole',),
'folet': ('fole',),
'fol': ('fole',),
'foliere': ('foliere',),
'folierer': ('foliere',),
'folieres': ('foliere',),
'folierte': ('foliere',),
'foliert': ('foliere',),
'folier': ('foliere',),
'folke': ('folke',),
'folker': ('folke',),
'folkes': ('folke',),
'folka': ('folke',),
'folket': ('folke',),
'folka': ('folke',),
'folket': ('folke',),
'folk': ('folke',),
'folle': ('folle',),
'foller': ('folle',),
'folles': ('folle',),
'folla': ('folle',),
'follet': ('folle',),
'folla': ('folle',),
'follet': ('folle',),
'foll': ('folle',),
'folne': ('folne',),
'folner': ('folne',),
'folnes': ('folne',),
'folna': ('folne',),
'folnet': ('folne',),
'folna': ('folne',),
'folnet': ('folne',),
'foln': ('folne',),
'folne': ('folne',),
'foln': ('folne',),
'folne': ('folne',),
'fomle': ('fomle',),
'fomler': ('fomle',),
'fomles': ('fomle',),
'fomla': ('fomle',),
'fomlet': ('fomle',),
'fomla': ('fomle',),
'fomlet': ('fomle',),
'foml': ('fomle',),
'fomle': ('fomle',),
'foml': ('fomle',),
'fomle': ('fomle',),
'fonne': ('fonne',),
'fonner': ('fonne',),
'fonnes': ('fonne',),
'fonna': ('fonne',),
'fonnet': ('fonne',),
'fonna': ('fonne',),
'fonnet': ('fonne',),
'fonn': ('fonne',),
'forakte': ('forakte',),
'forakter': ('forakte',),
'foraktes': ('forakte',),
'forakta': ('forakte',),
'foraktet': ('forakte',),
'forakta': ('forakte',),
'foraktet': ('forakte',),
'forakt': ('forakte',),
'forandre': ('forandre',),
'forandrer': ('forandre',),
'forandres': ('forandre',),
'forandra': ('forandre',),
'forandret': ('forandre',),
'forandra': ('forandre',),
'forandret': ('forandre',),
'forandr': ('forandre',),
'forandre': ('forandre',),
'forandr': ('forandre',),
'forandre': ('forandre',),
'forankre': ('forankre',),
'forankrer': ('forankre',),
'forankres': ('forankre',),
'forankra': ('forankre',),
'forankret': ('forankre',),
'forankra': ('forankre',),
'forankret': ('forankre',),
'forankr': ('forankre',),
'forankre': ('forankre',),
'forankr': ('forankre',),
'forankre': ('forankre',),
'foranledige': ('foranledige',),
'foranlediger': ('foranledige',),
'foranlediges': ('foranledige',),
'foranlediga': ('foranledige',),
'foranlediget': ('foranledige',),
'foranlediga': ('foranledige',),
'foranlediget': ('foranledige',),
'foranledig': ('foranledige',),
'foranstalte': ('foranstalte',),
'foranstalter': ('foranstalte',),
'foranstaltes': ('foranstalte',),
'foranstalta': ('foranstalte',),
'foranstaltet': ('foranstalte',),
'foranstalta': ('foranstalte',),
'foranstaltet': ('foranstalte',),
'foranstalt': ('foranstalte',),
'forarbeide': ('forarbeide',),
'forarbeider': ('forarbeide',),
'forarbeides': ('forarbeide',),
'forarbeida': ('forarbeide',),
'forarbeidet': ('forarbeide',),
'forarbeidde': ('forarbeide',),
'forarbeida': ('forarbeide',),
'forarbeidet': ('forarbeide',),
'forarbeidd': ('forarbeide',),
'forarbeid': ('forarbeide',),
'forarge': ('forarge',),
'forarger': ('forarge',),
'forarges': ('forarge',),
'forarga': ('forarge',),
'forarget': ('forarge',),
'forarga': ('forarge',),
'forarget': ('forarge',),
'forarg': ('forarge',),
'forarme': ('forarme',),
'forarmer': ('forarme',),
'forarmes': ('forarme',),
'forarma': ('forarme',),
'forarmet': ('forarme',),
'forarma': ('forarme',),
'forarmet': ('forarme',),
'forarm': ('forarme',),
'forbanne': ('forbanne',),
'forbanner': ('forbanne',),
'forbannes': ('forbanne',),
'forbanna': ('forbanne',),
'forbannet': ('forbanne',),
'forbante': ('forbanne',),
'forbanna': ('forbanne',),
'forbannet': ('forbanne',),
'forbant': ('forbanne',),
'forbann': ('forbanne',),
'forbarme': ('forbarme',),
'forbarmer': ('forbarme',),
'forbarmes': ('forbarme',),
'forbarma': ('forbarme',),
'forbarmet': ('forbarme',),
'forbarma': ('forbarme',),
'forbarmet': ('forbarme',),
'forbarm': ('forbarme',),
'forbause': ('forbause',),
'forbauser': ('forbause',),
'forbauses': ('forbause',),
'forbausa': ('forbause',),
'forbauset': ('forbause',),
'forbausa': ('forbause',),
'forbauset': ('forbause',),
'forbaus': ('forbause',),
'forbedre': ('forbedre',),
'forbedrer': ('forbedre',),
'forbedres': ('forbedre',),
'forbedra': ('forbedre',),
'forbedret': ('forbedre',),
'forbedra': ('forbedre',),
'forbedret': ('forbedre',),
'forbedr': ('forbedre',),
'forbedre': ('forbedre',),
'forbedr': ('forbedre',),
'forbedre': ('forbedre',),
'forbeholde': ('forbeholde',),
'forbeholder': ('forbeholde',),
'forbeholdes': ('forbeholde',),
'forbeholdt': ('forbeholde',),
'forbehold': ('forbeholde',),
'forbeine': ('forbeine',),
'forbeiner': ('forbeine',),
'forbeines': ('forbeine',),
'forbeina': ('forbeine',),
'forbeinet': ('forbeine',),
'forbeina': ('forbeine',),
'forbeinet': ('forbeine',),
'forbein': ('forbeine',),
'forbene': ('forbene',),
'forbener': ('forbene',),
'forbenes': ('forbene',),
'forbena': ('forbene',),
'forbenet': ('forbene',),
'forbena': ('forbene',),
'forbenet': ('forbene',),
'forben': ('forbene',),
'forberede': ('forberede',),
'forbereder': ('forberede',),
'forberedes': ('forberede',),
'forberedte': ('forberede',),
'forberedt': ('forberede',),
'forbered': ('forberede',),
'forbigå': ('forbigå',),
'forbigår': ('forbigå',),
'forbigås': ('forbigå',),
'forbigikk': ('forbigå',),
'forbigått': ('forbigå',),
'forbigå': ('forbigå',),
'forbinde': ('forbinde',),
'forbinder': ('forbinde',),
'forbindes': ('forbinde',),
'forbandt': ('forbinde',),
'forbundet': ('forbinde',),
'forbind': ('forbinde',),
'forbitre': ('forbitre',),
'forbitrer': ('forbitre',),
'forbitres': ('forbitre',),
'forbitra': ('forbitre',),
'forbitret': ('forbitre',),
'forbitra': ('forbitre',),
'forbitret': ('forbitre',),
'forbitr': ('forbitre',),
'forbitre': ('forbitre',),
'forbitr': ('forbitre',),
'forbitre': ('forbitre',),
'forblende': ('forblende',),
'forblender': ('forblende',),
'forblendes': ('forblende',),
'forblenda': ('forblende',),
'forblendet': ('forblende',),
'forblenda': ('forblende',),
'forblendet': ('forblende',),
'forblend': ('forblende',),
'forbli': ('forbli',),
'forblir': ('forbli',),
'forblis': ('forbli',),
'forble': ('forbli',),
'forblei': ('forbli',),
'forblitt': ('forbli',),
'forbli': ('forbli',),
'forblinde': ('forblinde',),
'forblinder': ('forblinde',),
'forblindes': ('forblinde',),
'forblinda': ('forblinde',),
'forblindet': ('forblinde',),
'forblinda': ('forblinde',),
'forblindet': ('forblinde',),
'forblind': ('forblinde',),
'forblø': ('forblø',),
'forblør': ('forblø',),
'forbløs': ('forblø',),
'forblødde': ('forblø',),
'forblødd': ('forblø',),
'forblø': ('forblø',),
'forbløffe': ('forbløffe',),
'forbløffer': ('forbløffe',),
'forbløffes': ('forbløffe',),
'forbløffa': ('forbløffe',),
'forbløffet': ('forbløffe',),
'forbløffa': ('forbløffe',),
'forbløffet': ('forbløffe',),
'forbløff': ('forbløffe',),
'forbruke': ('forbruke',),
'forbruker': ('forbruke',),
'forbrukes': ('forbruke',),
'forbrukte': ('forbruke',),
'forbrukt': ('forbruke',),
'forbruk': ('forbruke',),
'forbryte': ('forbryte',),
'forbryter': ('forbryte',),
'forbrytes': ('forbryte',),
'forbrøt': ('forbryte',),
'forbrøyt': ('forbryte',),
'forbrutt': ('forbryte',),
'forbryt': ('forbryte',),
'forby': ('forby',),
'forbyr': ('forby',),
'forbys': ('forby',),
'forbydde': ('forby',),
'forbød': ('forby',),
'forbøy': ('forby',),
'forbydd': ('forby',),
'forbudt': ('forby',),
'forbydd': ('forby',),
'forby': ('forby',),
'forbytte': ('forbytte',),
'forbytter': ('forbytte',),
'forbyttes': ('forbytte',),
'forbytta': ('forbytte',),
'forbyttet': ('forbytte',),
'forbytta': ('forbytte',),
'forbyttet': ('forbytte',),
'forbytt': ('forbytte',),
'fordampe': ('fordampe',),
'fordamper': ('fordampe',),
'fordampes': ('fordampe',),
'fordampa': ('fordampe',),
'fordampet': ('fordampe',),
'fordampa': ('fordampe',),
'fordampet': ('fordampe',),
'fordamp': ('fordampe',),
'fordanske': ('fordanske',),
'fordansker': ('fordanske',),
'fordanskes': ('fordanske',),
'fordanska': ('fordanske',),
'fordansket': ('fordanske',),
'fordanska': ('fordanske',),
'fordansket': ('fordanske',),
'fordansk': ('fordanske',),
'fordele': ('fordele',),
'fordeler': ('fordele',),
'fordeles': ('fordele',),
'fordelte': ('fordele',),
'fordelt': ('fordele',),
'fordel': ('fordele',),
'forderve': ('forderve',),
'forderver': ('forderve',),
'forderves': ('forderve',),
'forderva': ('forderve',),
'fordervet': ('forderve',),
'forderva': ('forderve',),
'fordervet': ('forderve',),
'forderv': ('forderve',),
'fordjupe': ('fordjupe',),
'fordjuper': ('fordjupe',),
'fordjupes': ('fordjupe',),
'fordjupa': ('fordjupe',),
'fordjupet': ('fordjupe',),
'fordjupa': ('fordjupe',),
'fordjupet': ('fordjupe',),
'fordjup': ('fordjupe',),
'fordoble': ('fordoble',),
'fordobler': ('fordoble',),
'fordobles': ('fordoble',),
'fordobla': ('fordoble',),
'fordoblet': ('fordoble',),
'fordobla': ('fordoble',),
'fordoblet': ('fordoble',),
'fordobl': ('fordoble',),
'fordoble': ('fordoble',),
'fordobl': ('fordoble',),
'fordoble': ('fordoble',),
'fordra': ('fordra',),
'fordrar': ('fordra',),
'fordras': ('fordra',),
'fordrog': ('fordra',),
'fordro': ('fordra',),
'fordradd': ('fordra',),
'fordratt': ('fordra',),
'fordradd': ('fordra',),
'fordratt': ('fordra',),
'fordra': ('fordra',),
'fordre': ('fordre',),
'fordrer': ('fordre',),
'fordres': ('fordre',),
'fordra': ('fordre',),
'fordret': ('fordre',),
'fordra': ('fordre',),
'fordret': ('fordre',),
'fordr': ('fordre',),
'fordre': ('fordre',),
'fordr': ('fordre',),
'fordre': ('fordre',),
'fordreie': ('fordreie',),
'fordreier': ('fordreie',),
'fordreies': ('fordreie',),
'fordreia': ('fordreie',),
'fordreiet': ('fordreie',),
'fordreide': ('fordreie',),
'fordreia': ('fordreie',),
'fordreiet': ('fordreie',),
'fordreid': ('fordreie',),
'fordrei': ('fordreie',),
'fordriste': ('fordriste',),
'fordrister': ('fordriste',),
'fordristes': ('fordriste',),
'fordrista': ('fordriste',),
'fordristet': ('fordriste',),
'fordrista': ('fordriste',),
'fordristet': ('fordriste',),
'fordrist': ('fordriste',),
'fordrive': ('fordrive',),
'fordriver': ('fordrive',),
'fordrives': ('fordrive',),
'fordrev': ('fordrive',),
'fordreiv': ('fordrive',),
'fordrev': ('fordrive',),
'fordreiv': ('fordrive',),
'fordrevet': ('fordrive',),
'fordriv': ('fordrive',),
'fordufte': ('fordufte',),
'fordufter': ('fordufte',),
'forduftes': ('fordufte',),
'fordufta': ('fordufte',),
'forduftet': ('fordufte',),
'fordufta': ('fordufte',),
'forduftet': ('fordufte',),
'forduft': ('fordufte',),
'fordumme': ('fordumme',),
'fordummer': ('fordumme',),
'fordummes': ('fordumme',),
'fordumma': ('fordumme',),
'fordummet': ('fordumme',),
'fordumma': ('fordumme',),
'fordummet': ('fordumme',),
'fordum': ('fordumme',),
'fordundre': ('fordundre',),
'fordunkle': ('fordunkle',),
'fordunkler': ('fordunkle',),
'fordunkles': ('fordunkle',),
'fordunkla': ('fordunkle',),
'fordunklet': ('fordunkle',),
'fordunkla': ('fordunkle',),
'fordunklet': ('fordunkle',),
'fordunkl': ('fordunkle',),
'fordunkle': ('fordunkle',),
'fordunkl': ('fordunkle',),
'fordunkle': ('fordunkle',),
'fordunste': ('fordunste',),
'fordunster': ('fordunste',),
'fordunstes': ('fordunste',),
'fordunsta': ('fordunste',),
'fordunstet': ('fordunste',),
'fordunsta': ('fordunste',),
'fordunstet': ('fordunste',),
'fordunst': ('fordunste',),
'fordype': ('fordype',),
'fordyper': ('fordype',),
'fordypes': ('fordype',),
'fordypa': ('fordype',),
'fordypet': ('fordype',),
'fordypa': ('fordype',),
'fordypet': ('fordype',),
'fordyp': ('fordype',),
'fordyre': ('fordyre',),
'fordyrer': ('fordyre',),
'fordyres': ('fordyre',),
'fordyra': ('fordyre',),
'fordyret': ('fordyre',),
'fordyra': ('fordyre',),
'fordyret': ('fordyre',),
'fordyr': ('fordyre',),
'fordømme': ('fordømme',),
'fordømmer': ('fordømme',),
'fordømmes': ('fordømme',),
'fordømte': ('fordømme',),
'fordømt': ('fordømme',),
'fordøm': ('fordømme',),
'fordøye': ('fordøye',),
'fordøyer': ('fordøye',),
'fordøyes': ('fordøye',),
'fordøya': ('fordøye',),
'fordøyet': ('fordøye',),
'fordøyde': ('fordøye',),
'fordøya': ('fordøye',),
'fordøyet': ('fordøye',),
'fordøyd': ('fordøye',),
'fordøy': ('fordøye',),
'forebringe': ('forebringe',),
'forebringer': ('forebringe',),
'forebringes': ('forebringe',),
'forebrakte': ('forebringe',),
'forebrakt': ('forebringe',),
'forebring': ('forebringe',),
'forebygge': ('forebygge',),
'forebygger': ('forebygge',),
'forebygges': ('forebygge',),
'forebygget': ('forebygge',),
'forebygde': ('forebygge',),
'forebygget': ('forebygge',),
'forebygd': ('forebygge',),
'forebygg': ('forebygge',),
'foredle': ('foredle',),
'foredler': ('foredle',),
'foredles': ('foredle',),
'foredla': ('foredle',),
'foredlet': ('foredle',),
'foredla': ('foredle',),
'foredlet': ('foredle',),
'foredl': ('foredle',),
'foredle': ('foredle',),
'foredl': ('foredle',),
'foredle': ('foredle',),
'foredra': ('foredra',),
'foredrar': ('foredra',),
'foredras': ('foredra',),
'foredrog': ('foredra',),
'foredro': ('foredra',),
'foredradd': ('foredra',),
'foredratt': ('foredra',),
'foredradd': ('foredra',),
'foredratt': ('foredra',),
'foredra': ('foredra',),
'forefalle': ('forefalle',),
'forefaller': ('forefalle',),
'forefalles': ('forefalle',),
'forefalt': ('forefalle',),
'forefall': ('forefalle',),
'forefinnes': ('forefinnes',),
'forefantes': ('forefinnes',),
'forefunnes': ('forefinnes',),
'foregi': ('foregi',),
'foregir': ('foregi',),
'foregis': ('foregi',),
'foregav': ('foregi',),
'forega': ('foregi',),
'foregitt': ('foregi',),
'foregi': ('foregi',),
'foregripe': ('foregripe',),
'foregriper': ('foregripe',),
'foregripes': ('foregripe',),
'foregrep': ('foregripe',),
'foregreip': ('foregripe',),
'foregrep': ('foregripe',),
'foregreip': ('foregripe',),
'foregrepet': ('foregripe',),
'foregrip': ('foregripe',),
'foregå': ('foregå',),
'foregår': ('foregå',),
'foregås': ('foregå',),
'foregikk': ('foregå',),
'foregått': ('foregå',),
'foregå': ('foregå',),
'foreholde': ('foreholde',),
'foreholder': ('foreholde',),
'foreholdes': ('foreholde',),
'foreholdt': ('foreholde',),
'forehold': ('foreholde',),
'forekomme': ('forekomme',),
'forekommer': ('forekomme',),
'forekommes': ('forekomme',),
'forekom': ('forekomme',),
'forekommet': ('forekomme',),
'forekom': ('forekomme',),
'foreldes': ('foreldes',),
'foreldedes': ('foreldes',),
'foreldes': ('foreldes',),
'forelegge': ('forelegge',),
'forelegger': ('forelegge',),
'forelegges': ('forelegge',),
'forela': ('forelegge',),
'forelagt': ('forelegge',),
'forelegg': ('forelegge',),
'forelese': ('forelese',),
'foreleser': ('forelese',),
'foreleses': ('forelese',),
'foreleste': ('forelese',),
'forelest': ('forelese',),
'foreles': ('forelese',),
'foreligge': ('foreligge',),
'foreligger': ('foreligge',),
'foreligges': ('foreligge',),
'forelå': ('foreligge',),
'foreligget': ('foreligge',),
'foreligg': ('foreligge',),
'forelske': ('forelske',),
'forelsker': ('forelske',),
'forelskes': ('forelske',),
'forelska': ('forelske',),
'forelsket': ('forelske',),
'forelska': ('forelske',),
'forelsket': ('forelske',),
'forelsk': ('forelske',),
'forene': ('forene',),
'forener': ('forene',),
'forenes': ('forene',),
'forenet': ('forene',),
'forente': ('forene',),
'forenet': ('forene',),
'forent': ('forene',),
'foren': ('forene',),
'forenkle': ('forenkle',),
'forenkler': ('forenkle',),
'forenkles': ('forenkle',),
'forenkla': ('forenkle',),
'forenklet': ('forenkle',),
'forenkla': ('forenkle',),
'forenklet': ('forenkle',),
'forenkl': ('forenkle',),
'forenkle': ('forenkle',),
'forenkl': ('forenkle',),
'forenkle': ('forenkle',),
'foresette': ('foresette',),
'foresetter': ('foresette',),
'foresettes': ('foresette',),
'foresatte': ('foresette',),
'foresatt': ('foresette',),
'foresett': ('foresette',),
'foresi': ('foresi',),
'foresier': ('foresi',),
'foresies': ('foresi',),
'foresa': ('foresi',),
'foresagt': ('foresi',),
'foresi': ('foresi',),
'foreskrive': ('foreskrive',),
'foreskriver': ('foreskrive',),
'foreskrives': ('foreskrive',),
'foreskrev': ('foreskrive',),
'foreskreiv': ('foreskrive',),
'foreskrev': ('foreskrive',),
'foreskreiv': ('foreskrive',),
'foreskrevet': ('foreskrive',),
'foreskriv': ('foreskrive',),
'foreslå': ('foreslå',),
'foreslår': ('foreslå',),
'foreslås': ('foreslå',),
'foreslåes': ('foreslå',),
'foreslo': ('foreslå',),
'foreslått': ('foreslå',),
'foreslå': ('foreslå',),
'forespeile': ('forespeile',),
'forespeiler': ('forespeile',),
'forespeiles': ('forespeile',),
'forespeila': ('forespeile',),
'forespeilet': ('forespeile',),
'forespeilte': ('forespeile',),
'forespeila': ('forespeile',),
'forespeilet': ('forespeile',),
'forespeilt': ('forespeile',),
'forespeil': ('forespeile',),
'forespørre': ('forespørre',),
'forespør': ('forespørre',),
'forespørres': ('forespørre',),
'forespurte': ('forespørre',),
'forespurt': ('forespørre',),
'forespør': ('forespørre',),
'forestille': ('forestille',),
'forestiller': ('forestille',),
'forestilles': ('forestille',),
'forestilte': ('forestille',),
'forestilt': ('forestille',),
'forestill': ('forestille',),
'forestå': ('forestå',),
'forestår': ('forestå',),
'forestås': ('forestå',),
'foresto': ('forestå',),
'forestod': ('forestå',),
'forestått': ('forestå',),
'forestå': ('forestå',),
'foresveve': ('foresveve',),
'foresvever': ('foresveve',),
'foresveves': ('foresveve',),
'foresveva': ('foresveve',),
'foresvevet': ('foresveve',),
'foresvevde': ('foresveve',),
'foresveva': ('foresveve',),
'foresvevet': ('foresveve',),
'foresvevd': ('foresveve',),
'foresvev': ('foresveve',),
'foreta': ('foreta',),
'foretar': ('foreta',),
'foretas': ('foreta',),
'foretok': ('foreta',),
'foretatt': ('foreta',),
'foreta': ('foreta',),
'foretrekke': ('foretrekke',),
'foretrekker': ('foretrekke',),
'foretrekkes': ('foretrekke',),
'foretrakk': ('foretrekke',),
'foretrukket': ('foretrekke',),
'foretrekk': ('foretrekke',),
'forevige': ('forevige',),
'foreviger': ('forevige',),
'foreviges': ('forevige',),
'foreviga': ('forevige',),
'foreviget': ('forevige',),
'foreviga': ('forevige',),
'foreviget': ('forevige',),
'forevig': ('forevige',),
'forevise': ('forevise',),
'foreviser': ('forevise',),
'forevises': ('forevise',),
'foreviste': ('forevise',),
'forevist': ('forevise',),
'forevis': ('forevise',),
'forfalle': ('forfalle',),
'forfaller': ('forfalle',),
'forfalles': ('forfalle',),
'forfalt': ('forfalle',),
'forfall': ('forfalle',),
'forfalske': ('forfalske',),
'forfalsker': ('forfalske',),
'forfalskes': ('forfalske',),
'forfalska': ('forfalske',),
'forfalsket': ('forfalske',),
'forfalska': ('forfalske',),
'forfalsket': ('forfalske',),
'forfalsk': ('forfalske',),
'forfatte': ('forfatte',),
'forfatter': ('forfatte',),
'forfattes': ('forfatte',),
'forfatta': ('forfatte',),
'forfattet': ('forfatte',),
'forfatta': ('forfatte',),
'forfattet': ('forfatte',),
'forfatt': ('forfatte',),
'forfeile': ('forfeile',),
'forfeiler': ('forfeile',),
'forfeiles': ('forfeile',),
'forfeila': ('forfeile',),
'forfeilet': ('forfeile',),
'forfeilte': ('forfeile',),
'forfeila': ('forfeile',),
'forfeilet': ('forfeile',),
'forfeilt': ('forfeile',),
'forfeil': ('forfeile',),
'forfekte': ('forfekte',),
'forfekter': ('forfekte',),
'forfektes': ('forfekte',),
'forfekta': ('forfekte',),
'forfektet': ('forfekte',),
'forfekta': ('forfekte',),
'forfektet': ('forfekte',),
'forfekt': ('forfekte',),
'forferde': ('forferde',),
'forferder': ('forferde',),
'forferdes': ('forferde',),
'forferda': ('forferde',),
'forferdet': ('forferde',),
'forferda': ('forferde',),
'forferdet': ('forferde',),
'forferd': ('forferde',),
'forferdige': ('forferdige',),
'forferdiger': ('forferdige',),
'forferdiges': ('forferdige',),
'forferdiga': ('forferdige',),
'forferdiget': ('forferdige',),
'forferdiga': ('forferdige',),
'forferdiget': ('forferdige',),
'forferdig': ('forferdige',),
'forfine': ('forfine',),
'forfiner': ('forfine',),
'forfines': ('forfine',),
'forfina': ('forfine',),
'forfinet': ('forfine',),
'forfina': ('forfine',),
'forfinet': ('forfine',),
'forfin': ('forfine',),
'forfjamse': ('forfjamse',),
'forfjamser': ('forfjamse',),
'forfjamses': ('forfjamse',),
'forfjamsa': ('forfjamse',),
'forfjamset': ('forfjamse',),
'forfjamsa': ('forfjamse',),
'forfjamset': ('forfjamse',),
'forfjams': ('forfjamse',),
'forflate': ('forflate',),
'forflater': ('forflate',),
'forflates': ('forflate',),
'forflata': ('forflate',),
'forflatet': ('forflate',),
'forflata': ('forflate',),
'forflatet': ('forflate',),
'forflat': ('forflate',),
'forflere': ('forflere',),
'forflerer': ('forflere',),
'forfleres': ('forflere',),
'forflera': ('forflere',),
'forfleret': ('forflere',),
'forflerte': ('forflere',),
'forflera': ('forflere',),
'forfleret': ('forflere',),
'forflert': ('forflere',),
'forfler': ('forflere',),
'forflytte': ('forflytte',),
'forflytter': ('forflytte',),
'forflyttes': ('forflytte',),
'forflytta': ('forflytte',),
'forflyttet': ('forflytte',),
'forflytta': ('forflytte',),
'forflyttet': ('forflytte',),
'forflytt': ('forflytte',),
'forfordele': ('forfordele',),
'forfordeler': ('forfordele',),
'forfordeles': ('forfordele',),
'forfordelte': ('forfordele',),
'forfordelt': ('forfordele',),
'forfordel': ('forfordele',),
'forfremme': ('forfremme',),
'forfremmer': ('forfremme',),
'forfremmes': ('forfremme',),
'forfremma': ('forfremme',),
'forfremmet': ('forfremme',),
'forfremma': ('forfremme',),
'forfremmet': ('forfremme',),
'forfrem': ('forfremme',),
'forfriske': ('forfriske',),
'forfrisker': ('forfriske',),
'forfriskes': ('forfriske',),
'forfriska': ('forfriske',),
'forfrisket': ('forfriske',),
'forfriska': ('forfriske',),
'forfrisket': ('forfriske',),
'forfrisk': ('forfriske',),
'forfryse': ('forfryse',),
'forfryser': ('forfryse',),
'forfryses': ('forfryse',),
'forfrøs': ('forfryse',),
'forfrøys': ('forfryse',),
'forfrosset': ('forfryse',),
'forfrys': ('forfryse',),
'forfølge': ('forfølge',),
'forfølger': ('forfølge',),
'forfølges': ('forfølge',),
'forfulgte': ('forfølge',),
'forfulgt': ('forfølge',),
'forfølg': ('forfølge',),
'forføre': ('forføre',),
'forfører': ('forføre',),
'forføres': ('forføre',),
'forførte': ('forføre',),
'forført': ('forføre',),
'forfør': ('forføre',),
'forføye': ('forføye',),
'forføyer': ('forføye',),
'forføyes': ('forføye',),
'forføya': ('forføye',),
'forføyet': ('forføye',),
'forføyde': ('forføye',),
'forføya': ('forføye',),
'forføyet': ('forføye',),
'forføyd': ('forføye',),
'forføy': ('forføye',),
'forgape': ('forgape',),
'forgaper': ('forgape',),
'forgapes': ('forgape',),
'forgapa': ('forgape',),
'forgapte': ('forgape',),
'forgapa': ('forgape',),
'forgapt': ('forgape',),
'forgap': ('forgape',),
'forgasse': ('forgasse',),
'forgasser': ('forgasse',),
'forgasses': ('forgasse',),
'forgassa': ('forgasse',),
'forgasset': ('forgasse',),
'forgassa': ('forgasse',),
'forgasset': ('forgasse',),
'forgass': ('forgasse',),
'forgi': ('forgi',),
'forgir': ('forgi',),
'forgis': ('forgi',),
'forgav': ('forgi',),
'forga': ('forgi',),
'forgitt': ('forgi',),
'forgi': ('forgi',),
'forgifte': ('forgifte',),
'forgifter': ('forgifte',),
'forgiftes': ('forgifte',),
'forgifta': ('forgifte',),
'forgiftet': ('forgifte',),
'forgifta': ('forgifte',),
'forgiftet': ('forgifte',),
'forgift': ('forgifte',),
'forgjelde': ('forgjelde',),
'forgjelder': ('forgjelde',),
'forgjeldes': ('forgjelde',),
'forgjelda': ('forgjelde',),
'forgjeldet': ('forgjelde',),
'forgjelda': ('forgjelde',),
'forgjeldet': ('forgjelde',),
'forgjeld': ('forgjelde',),
'forgjøre': ('forgjøre',),
'forgjør': ('forgjøre',),
'forgjøres': ('forgjøre',),
'forgjorde': ('forgjøre',),
'forgjort': ('forgjøre',),
'forgjør': ('forgjøre',),
'forglemme': ('forglemme',),
'forglemmer': ('forglemme',),
'forglemmes': ('forglemme',),
'forglemte': ('forglemme',),
'forglemt': ('forglemme',),
'forglem': ('forglemme',),
'forglømme': ('forglømme',),
'forglømmer': ('forglømme',),
'forglømmes': ('forglømme',),
'forglømte': ('forglømme',),
'forglømt': ('forglømme',),
'forgløm': ('forglømme',),
'forgreine': ('forgreine',),
'forgreiner': ('forgreine',),
'forgreines': ('forgreine',),
'forgreina': ('forgreine',),
'forgreinet': ('forgreine',),
'forgreinte': ('forgreine',),
'forgreina': ('forgreine',),
'forgreinet': ('forgreine',),
'forgreint': ('forgreine',),
'forgrein': ('forgreine',),
'forgrene': ('forgrene',),
'forgrener': ('forgrene',),
'forgrenes': ('forgrene',),
'forgrena': ('forgrene',),
'forgrenet': ('forgrene',),
'forgrente': ('forgrene',),
'forgrena': ('forgrene',),
'forgrenet': ('forgrene',),
'forgrent': ('forgrene',),
'forgren': ('forgrene',),
'forgripe': ('forgripe',),
'forgriper': ('forgripe',),
'forgripes': ('forgripe',),
'forgrep': ('forgripe',),
'forgreip': ('forgripe',),
'forgrep': ('forgripe',),
'forgreip': ('forgripe',),
'forgrepet': ('forgripe',),
'forgrip': ('forgripe',),
'forgrove': ('forgrove',),
'forgrover': ('forgrove',),
'forgroves': ('forgrove',),
'forgrova': ('forgrove',),
'forgrovet': ('forgrove',),
'forgrova': ('forgrove',),
'forgrovet': ('forgrove',),
'forgrov': ('forgrove',),
'forgubbe': ('forgubbe',),
'forgubber': ('forgubbe',),
'forgubbes': ('forgubbe',),
'forgubba': ('forgubbe',),
'forgubbet': ('forgubbe',),
'forgubba': ('forgubbe',),
'forgubbet': ('forgubbe',),
'forgubb': ('forgubbe',),
'forgude': ('forgude',),
'forguder': ('forgude',),
'forgudes': ('forgude',),
'forguda': ('forgude',),
'forgudet': ('forgude',),
'forguda': ('forgude',),
'forgudet': ('forgude',),
'forgud': ('forgude',),
'forgylle': ('forgylle',),
'forgyller': ('forgylle',),
'forgylles': ('forgylle',),
'forgyllet': ('forgylle',),
'forgylte': ('forgylle',),
'forgyllet': ('forgylle',),
'forgylt': ('forgylle',),
'forgyll': ('forgylle',),
'forgå': ('forgå',),
'forgår': ('forgå',),
'forgås': ('forgå',),
'forgikk': ('forgå',),
'forgått': ('forgå',),
'forgå': ('forgå',),
'forhale': ('forhale',),
'forhaler': ('forhale',),
'forhales': ('forhale',),
'forhala': ('forhale',),
'forhalet': ('forhale',),
'forhalte': ('forhale',),
'forhala': ('forhale',),
'forhalet': ('forhale',),
'forhalt': ('forhale',),
'forhal': ('forhale',),
'forhandle': ('forhandle',),
'forhandler': ('forhandle',),
'forhandles': ('forhandle',),
'forhandla': ('forhandle',),
'forhandlet': ('forhandle',),
'forhandla': ('forhandle',),
'forhandlet': ('forhandle',),
'forhandl': ('forhandle',),
'forhandle': ('forhandle',),
'forhandl': ('forhandle',),
'forhandle': ('forhandle',),
'forhandsbestille': ('forhandsbestille',),
'forhandsbestiller': ('forhandsbestille',),
'forhandsbestilles': ('forhandsbestille',),
'forhandsbestilte': ('forhandsbestille',),
'forhandsbestilt': ('forhandsbestille',),
'forhandsbestill': ('forhandsbestille',),
'forhandsomtale': ('forhandsomtale',),
'forhandsomtaler': ('forhandsomtale',),
'forhandsomtales': ('forhandsomtale',),
'forhandsomtalte': ('forhandsomtale',),
'forhandsomtalt': ('forhandsomtale',),
'forhandsomtal': ('forhandsomtale',),
'forhandsstemme': ('forhandsstemme',),
'forhandsstemmer': ('forhandsstemme',),
'forhandsstemmes': ('forhandsstemme',),
'forhandsstemte': ('forhandsstemme',),
'forhandsstemt': ('forhandsstemme',),
'forhandsstem': ('forhandsstemme',),
'forhaste': ('forhaste',),
'forhaster': ('forhaste',),
'forhastes': ('forhaste',),
'forhasta': ('forhaste',),
'forhastet': ('forhaste',),
'forhasta': ('forhaste',),
'forhastet': ('forhaste',),
'forhast': ('forhaste',),
'forhekse': ('forhekse',),
'forhekser': ('forhekse',),
'forhekses': ('forhekse',),
'forheksa': ('forhekse',),
'forhekset': ('forhekse',),
'forheksa': ('forhekse',),
'forhekset': ('forhekse',),
'forheks': ('forhekse',),
'forherde': ('forherde',),
'forherder': ('forherde',),
'forherdes': ('forherde',),
'forherda': ('forherde',),
'forherdet': ('forherde',),
'forherda': ('forherde',),
'forherdet': ('forherde',),
'forherd': ('forherde',),
'forherlige': ('forherlige',),
'forherliger': ('forherlige',),
'forherliges': ('forherlige',),
'forherliga': ('forherlige',),
'forherliget': ('forherlige',),
'forherliga': ('forherlige',),
'forherliget': ('forherlige',),
'forherlig': ('forherlige',),
'forhindre': ('forhindre',),
'forhindrer': ('forhindre',),
'forhindres': ('forhindre',),
'forhindra': ('forhindre',),
'forhindret': ('forhindre',),
'forhindra': ('forhindre',),
'forhindret': ('forhindre',),
'forhindr': ('forhindre',),
'forhindre': ('forhindre',),
'forhindr': ('forhindre',),
'forhindre': ('forhindre',),
'forholde': ('forholde',),
'forholder': ('forholde',),
'forholdes': ('forholde',),
'forholdt': ('forholde',),
'forhold': ('forholde',),
'forhyre': ('forhyre',),
'forhyrer': ('forhyre',),
'forhyres': ('forhyre',),
'forhyra': ('forhyre',),
'forhyret': ('forhyre',),
'forhyrte': ('forhyre',),
'forhyra': ('forhyre',),
'forhyret': ('forhyre',),
'forhyrt': ('forhyre',),
'forhyr': ('forhyre',),
'forhåndsbestille': ('forhåndsbestille',),
'forhåndsbestiller': ('forhåndsbestille',),
'forhåndsbestilles': ('forhåndsbestille',),
'forhåndsbestilte': ('forhåndsbestille',),
'forhåndsbestilt': ('forhåndsbestille',),
'forhåndsbestill': ('forhåndsbestille',),
'forhåndsomtale': ('forhåndsomtale',),
'forhåndsomtaler': ('forhåndsomtale',),
'forhåndsomtales': ('forhåndsomtale',),
'forhåndsomtalte': ('forhåndsomtale',),
'forhåndsomtalt': ('forhåndsomtale',),
'forhåndsomtal': ('forhåndsomtale',),
'forhåndsstemme': ('forhåndsstemme',),
'forhåndsstemmer': ('forhåndsstemme',),
'forhåndsstemmes': ('forhåndsstemme',),
'forhåndsstemte': ('forhåndsstemme',),
'forhåndsstemt': ('forhåndsstemme',),
'forhåndsstem': ('forhåndsstemme',),
'forhåne': ('forhåne',),
'forhåner': ('forhåne',),
'forhånes': ('forhåne',),
'forhåna': ('forhåne',),
'forhånet': ('forhåne',),
'forhånte': ('forhåne',),
'forhåna': ('forhåne',),
'forhånet': ('forhåne',),
'forhånt': ('forhåne',),
'forhån': ('forhåne',),
'forhøre': ('forhøre',),
'forhører': ('forhøre',),
'forhøres': ('forhøre',),
'forhørte': ('forhøre',),
'forhørt': ('forhøre',),
'forhør': ('forhøre',),
'forhøye': ('forhøye',),
'forhøyer': ('forhøye',),
'forhøyes': ('forhøye',),
'forhøya': ('forhøye',),
'forhøyet': ('forhøye',),
'forhøyde': ('forhøye',),
'forhøya': ('forhøye',),
'forhøyet': ('forhøye',),
'forhøyd': ('forhøye',),
'forhøy': ('forhøye',),
'forivre': ('forivre',),
'forivrer': ('forivre',),
'forivres': ('forivre',),
'forivra': ('forivre',),
'forivret': ('forivre',),
'forivra': ('forivre',),
'forivret': ('forivre',),
'forivr': ('forivre',),
'forivre': ('forivre',),
'forivr': ('forivre',),
'forivre': ('forivre',),
'forjette': ('forjette',),
'forjetter': ('forjette',),
'forjettes': ('forjette',),
'forjetta': ('forjette',),
'forjettet': ('forjette',),
'forjetta': ('forjette',),
'forjettet': ('forjette',),
'forjett': ('forjette',),
'forkalke': ('forkalke',),
'forkalker': ('forkalke',),
'forkalkes': ('forkalke',),
'forkalka': ('forkalke',),
'forkalket': ('forkalke',),
'forkalka': ('forkalke',),
'forkalket': ('forkalke',),
'forkalk': ('forkalke',),
'forkaste': ('forkaste',),
'forkaster': ('forkaste',),
'forkastes': ('forkaste',),
'forkasta': ('forkaste',),
'forkastet': ('forkaste',),
'forkasta': ('forkaste',),
'forkastet': ('forkaste',),
'forkast': ('forkaste',),
'forkjetre': ('forkjetre',),
'forkjetrer': ('forkjetre',),
'forkjetres': ('forkjetre',),
'forkjetra': ('forkjetre',),
'forkjetret': ('forkjetre',),
'forkjetra': ('forkjetre',),
'forkjetret': ('forkjetre',),
'forkjetr': ('forkjetre',),
'forkjetre': ('forkjetre',),
'forkjetr': ('forkjetre',),
'forkjetre': ('forkjetre',),
'forkjæle': ('forkjæle',),
'forkjæler': ('forkjæle',),
'forkjæles': ('forkjæle',),
'forkjælte': ('forkjæle',),
'forkjælt': ('forkjæle',),
'forkjæl': ('forkjæle',),
'forkjøle': ('forkjøle',),
'forkjøler': ('forkjøle',),
'forkjøles': ('forkjøle',),
'forkjøla': ('forkjøle',),
'forkjølet': ('forkjøle',),
'forkjølte': ('forkjøle',),
'forkjøla': ('forkjøle',),
'forkjølet': ('forkjøle',),
'forkjølt': ('forkjøle',),
'forkjøl': ('forkjøle',),
'forkjøpe': ('forkjøpe',),
'forkjøper': ('forkjøpe',),
'forkjøpes': ('forkjøpe',),
'forkjøpte': ('forkjøpe',),
'forkjøpt': ('forkjøpe',),
'forkjøp': ('forkjøpe',),
'forklare': ('forklare',),
'forklarer': ('forklare',),
'forklares': ('forklare',),
'forklarte': ('forklare',),
'forklart': ('forklare',),
'forklar': ('forklare',),
'forkle': ('forkle',),
'forkler': ('forkle',),
'forkles': ('forkle',),
'forkledde': ('forkle',),
'forkledd': ('forkle',),
'forkle': ('forkle',),
'forkleine': ('forkleine',),
'forkleiner': ('forkleine',),
'forkleines': ('forkleine',),
'forkleina': ('forkleine',),
'forkleinet': ('forkleine',),
'forkleina': ('forkleine',),
'forkleinet': ('forkleine',),
'forklein': ('forkleine',),
'forkludre': ('forkludre',),
'forkludrer': ('forkludre',),
'forkludres': ('forkludre',),
'forkludra': ('forkludre',),
'forkludret': ('forkludre',),
'forkludra': ('forkludre',),
'forkludret': ('forkludre',),
'forkludr': ('forkludre',),
'forkludre': ('forkludre',),
'forkludr': ('forkludre',),
'forkludre': ('forkludre',),
'forkobre': ('forkobre',),
'forkobrer': ('forkobre',),
'forkobres': ('forkobre',),
'forkobra': ('forkobre',),
'forkobret': ('forkobre',),
'forkobra': ('forkobre',),
'forkobret': ('forkobre',),
'forkobr': ('forkobre',),
'forkobre': ('forkobre',),
'forkobr': ('forkobre',),
'forkobre': ('forkobre',),
'forkomme': ('forkomme',),
'forkommer': ('forkomme',),
'forkommes': ('forkomme',),
'forkom': ('forkomme',),
'forkommet': ('forkomme',),
'forkom': ('forkomme',),
'forkopre': ('forkopre',),
'forkoprer': ('forkopre',),
'forkopres': ('forkopre',),
'forkopra': ('forkopre',),
'forkopret': ('forkopre',),
'forkopra': ('forkopre',),
'forkopret': ('forkopre',),
'forkopr': ('forkopre',),
'forkopre': ('forkopre',),
'forkopr': ('forkopre',),
'forkopre': ('forkopre',),
'forkorte': ('forkorte',),
'forkorter': ('forkorte',),
'forkortes': ('forkorte',),
'forkorta': ('forkorte',),
'forkortet': ('forkorte',),
'forkorta': ('forkorte',),
'forkortet': ('forkorte',),
'forkort': ('forkorte',),
'forkromme': ('forkromme',),
'forkrommer': ('forkromme',),
'forkrommes': ('forkromme',),
'forkromma': ('forkromme',),
'forkrommet': ('forkromme',),
'forkromma': ('forkromme',),
'forkrommet': ('forkromme',),
'forkrom': ('forkromme',),
'forkue': ('forkue',),
'forkuer': ('forkue',),
'forkues': ('forkue',),
'forkua': ('forkue',),
'forkuet': ('forkue',),
'forkua': ('forkue',),
'forkuet': ('forkue',),
'forku': ('forkue',),
'forkulle': ('forkulle',),
'forkuller': ('forkulle',),
'forkulles': ('forkulle',),
'forkulla': ('forkulle',),
'forkullet': ('forkulle',),
'forkulla': ('forkulle',),
'forkullet': ('forkulle',),
'forkull': ('forkulle',),
'forkvakle': ('forkvakle',),
'forkvakler': ('forkvakle',),
'forkvakles': ('forkvakle',),
'forkvakla': ('forkvakle',),
'forkvaklet': ('forkvakle',),
'forkvakla': ('forkvakle',),
'forkvaklet': ('forkvakle',),
'forkvakl': ('forkvakle',),
'forkvakle': ('forkvakle',),
'forkvakl': ('forkvakle',),
'forkvakle': ('forkvakle',),
'forkynne': ('forkynne',),
'forkynner': ('forkynne',),
'forkynnes': ('forkynne',),
'forkynte': ('forkynne',),
'forkynt': ('forkynne',),
'forkynn': ('forkynne',),
'forlange': ('forlange',),
'forlanger': ('forlange',),
'forlanges': ('forlange',),
'forlangte': ('forlange',),
'forlangt': ('forlange',),
'forlang': ('forlange',),
'forlate': ('forlate',),
'forlater': ('forlate',),
'forlates': ('forlate',),
'forlot': ('forlate',),
'forlatt': ('forlate',),
'forlat': ('forlate',),
'forlede': ('forlede',),
'forleder': ('forlede',),
'forledes': ('forlede',),
'forleda': ('forlede',),
'forledet': ('forlede',),
'forleda': ('forlede',),
'forledet': ('forlede',),
'forled': ('forlede',),
'forlegge': ('forlegge',),
'forlegger': ('forlegge',),
'forlegges': ('forlegge',),
'forla': ('forlegge',),
'forlagt': ('forlegge',),
'forlegg': ('forlegge',),
'forlenge': ('forlenge',),
'forlenger': ('forlenge',),
'forlenges': ('forlenge',),
'forlenga': ('forlenge',),
'forlenget': ('forlenge',),
'forlenga': ('forlenge',),
'forlenget': ('forlenge',),
'forleng': ('forlenge',),
'forlese': ('forlese',),
'forleser': ('forlese',),
'forleses': ('forlese',),
'forleste': ('forlese',),
'forlest': ('forlese',),
'forles': ('forlese',),
'forlibe': ('forlibe',),
'forliber': ('forlibe',),
'forlibes': ('forlibe',),
'forlibte': ('forlibe',),
'forlibt': ('forlibe',),
'forlib': ('forlibe',),
'forlike': ('forlike',),
'forliker': ('forlike',),
'forlikes': ('forlike',),
'forlikte': ('forlike',),
'forlikt': ('forlike',),
'forlik': ('forlike',),
'forlise': ('forlise',),
'forliser': ('forlise',),
'forlises': ('forlise',),
'forliste': ('forlise',),
'forlist': ('forlise',),
'forlis': ('forlise',),
'forlokke': ('forlokke',),
'forlokker': ('forlokke',),
'forlokkes': ('forlokke',),
'forlokka': ('forlokke',),
'forlokket': ('forlokke',),
'forlokka': ('forlokke',),
'forlokket': ('forlokke',),
'forlokk': ('forlokke',),
'forlove': ('forlove',),
'forlover': ('forlove',),
'forloves': ('forlove',),
'forlova': ('forlove',),
'forlovet': ('forlove',),
'forlova': ('forlove',),
'forlovet': ('forlove',),
'forlov': ('forlove',),
'forlyde': ('forlyde',),
'forlyder': ('forlyde',),
'forlydes': ('forlyde',),
'forlød': ('forlyde',),
'forlydt': ('forlyde',),
'forlyd': ('forlyde',),
'forlyste': ('forlyste',),
'forlyster': ('forlyste',),
'forlystes': ('forlyste',),
'forlysta': ('forlyste',),
'forlystet': ('forlyste',),
'forlysta': ('forlyste',),
'forlystet': ('forlyste',),
'forlyst': ('forlyste',),
'forløfte': ('forløfte',),
'forløfter': ('forløfte',),
'forløftes': ('forløfte',),
'forløfta': ('forløfte',),
'forløftet': ('forløfte',),
'forløfta': ('forløfte',),
'forløftet': ('forløfte',),
'forløft': ('forløfte',),
'forløpe': ('forløpe',),
'forløper': ('forløpe',),
'forløpes': ('forløpe',),
'forløp': ('forløpe',),
'forløpt': ('forløpe',),
'forløpet': ('forløpe',),
'forløp': ('forløpe',),
'forløse': ('forløse',),
'forløser': ('forløse',),
'forløses': ('forløse',),
'forløste': ('forløse',),
'forløst': ('forløse',),
'forløs': ('forløse',),
'forløyse': ('forløyse',),
'forløyser': ('forløyse',),
'forløyses': ('forløyse',),
'forløyste': ('forløyse',),
'forløyst': ('forløyse',),
'forløys': ('forløyse',),
'formale': ('formale',),
'formaler': ('formale',),
'formales': ('formale',),
'formalte': ('formale',),
'formalt': ('formale',),
'formal': ('formale',),
'formalisere': ('formalisere',),
'formaliserer': ('formalisere',),
'formaliseres': ('formalisere',),
'formaliserte': ('formalisere',),
'formalisert': ('formalisere',),
'formaliser': ('formalisere',),
'formane': ('formane',),
'formaner': ('formane',),
'formanes': ('formane',),
'formana': ('formane',),
'formanet': ('formane',),
'formante': ('formane',),
'formana': ('formane',),
'formanet': ('formane',),
'formant': ('formane',),
'forman': ('formane',),
'formaste': ('formaste',),
'formaster': ('formaste',),
'formastes': ('formaste',),
'formasta': ('formaste',),
'formastet': ('formaste',),
'formasta': ('formaste',),
'formastet': ('formaste',),
'formast': ('formaste',),
'formatere': ('formatere',),
'formaterer': ('formatere',),
'formateres': ('formatere',),
'formaterte': ('formatere',),
'formatert': ('formatere',),
'formater': ('formatere',),
'forme': ('forme',),
'former': ('forme',),
'formes': ('forme',),
'forma': ('forme',),
'formet': ('forme',),
'forma': ('forme',),
'formet': ('forme',),
'form': ('forme',),
'formene': ('formene',),
'formener': ('formene',),
'formenes': ('formene',),
'formente': ('formene',),
'forment': ('formene',),
'formen': ('formene',),
'formere': ('formere',),
'formerer': ('formere',),
'formeres': ('formere',),
'formerte': ('formere',),
'formert': ('formere',),
'former': ('formere',),
'formgi': ('formgi',),
'formgir': ('formgi',),
'formgis': ('formgi',),
'formgav': ('formgi',),
'formga': ('formgi',),
'formgitt': ('formgi',),
'formgi': ('formgi',),
'formidle': ('formidle',),
'formidler': ('formidle',),
'formidles': ('formidle',),
'formidla': ('formidle',),
'formidlet': ('formidle',),
'formidla': ('formidle',),
'formidlet': ('formidle',),
'formidl': ('formidle',),
'formidle': ('formidle',),
'formidl': ('formidle',),
'formidle': ('formidle',),
'formilde': ('formilde',),
'formilder': ('formilde',),
'formildes': ('formilde',),
'formilda': ('formilde',),
'formildet': ('formilde',),
'formilda': ('formilde',),
'formildet': ('formilde',),
'formild': ('formilde',),
'forminske': ('forminske',),
'forminsker': ('forminske',),
'forminskes': ('forminske',),
'forminska': ('forminske',),
'forminsket': ('forminske',),
'forminska': ('forminske',),
'forminsket': ('forminske',),
'forminsk': ('forminske',),
'formode': ('formode',),
'formoder': ('formode',),
'formodes': ('formode',),
'formoda': ('formode',),
'formodet': ('formode',),
'formoda': ('formode',),
'formodet': ('formode',),
'formod': ('formode',),
'formolde': ('formolde',),
'formolder': ('formolde',),
'formoldes': ('formolde',),
'formolda': ('formolde',),
'formoldet': ('formolde',),
'formolda': ('formolde',),
'formoldet': ('formolde',),
'formold': ('formolde',),
'formulde': ('formulde',),
'formulder': ('formulde',),
'formuldes': ('formulde',),
'formulda': ('formulde',),
'formuldet': ('formulde',),
'formulda': ('formulde',),
'formuldet': ('formulde',),
'formuld': ('formulde',),
'formulere': ('formulere',),
'formulerer': ('formulere',),
'formuleres': ('formulere',),
'formulerte': ('formulere',),
'formulert': ('formulere',),
'formuler': ('formulere',),
'formumme': ('formumme',),
'formummer': ('formumme',),
'formummes': ('formumme',),
'formumma': ('formumme',),
'formummet': ('formumme',),
'formumma': ('formumme',),
'formummet': ('formumme',),
'formum': ('formumme',),
'formå': ('formå',),
'formår': ('formå',),
'formås': ('formå',),
'formådde': ('formå',),
'formådd': ('formå',),
'formå': ('formå',),
'formæle': ('formæle',),
'formæler': ('formæle',),
'formæles': ('formæle',),
'formælte': ('formæle',),
'formælt': ('formæle',),
'formæl': ('formæle',),
'formørke': ('formørke',),
'formørker': ('formørke',),
'formørkes': ('formørke',),
'formørka': ('formørke',),
'formørket': ('formørke',),
'formørka': ('formørke',),
'formørket': ('formørke',),
'formørk': ('formørke',),
'fornedre': ('fornedre',),
'fornedrer': ('fornedre',),
'fornedres': ('fornedre',),
'fornedra': ('fornedre',),
'fornedret': ('fornedre',),
'fornedra': ('fornedre',),
'fornedret': ('fornedre',),
'fornedr': ('fornedre',),
'fornedre': ('fornedre',),
'fornedr': ('fornedre',),
'fornedre': ('fornedre',),
'fornekte': ('fornekte',),
'fornekter': ('fornekte',),
'fornektes': ('fornekte',),
'fornekta': ('fornekte',),
'fornektet': ('fornekte',),
'fornekta': ('fornekte',),
'fornektet': ('fornekte',),
'fornekt': ('fornekte',),
'fornemme': ('fornemme',),
'fornemmer': ('fornemme',),
'fornemmes': ('fornemme',),
'fornemma': ('fornemme',),
'fornemmet': ('fornemme',),
'fornam': ('fornemme',),
'fornemma': ('fornemme',),
'fornemmet': ('fornemme',),
'fornem': ('fornemme',),
'fornikle': ('fornikle',),
'fornikler': ('fornikle',),
'fornikles': ('fornikle',),
'fornikla': ('fornikle',),
'forniklet': ('fornikle',),
'fornikla': ('fornikle',),
'forniklet': ('fornikle',),
'fornikl': ('fornikle',),
'fornikle': ('fornikle',),
'fornikl': ('fornikle',),
'fornikle': ('fornikle',),
'fornorske': ('fornorske',),
'fornorsker': ('fornorske',),
'fornorskes': ('fornorske',),
'fornorska': ('fornorske',),
'fornorsket': ('fornorske',),
'fornorska': ('fornorske',),
'fornorsket': ('fornorske',),
'fornorsk': ('fornorske',),
'fornye': ('fornye',),
'fornyer': ('fornye',),
'fornyes': ('fornye',),
'fornya': ('fornye',),
'fornyet': ('fornye',),
'fornya': ('fornye',),
'fornyet': ('fornye',),
'forny': ('fornye',),
'fornærme': ('fornærme',),
'fornærmer': ('fornærme',),
'fornærmes': ('fornærme',),
'fornærma': ('fornærme',),
'fornærmet': ('fornærme',),
'fornærma': ('fornærme',),
'fornærmet': ('fornærme',),
'fornærm': ('fornærme',),
'fornøye': ('fornøye',),
'fornøyer': ('fornøye',),
'fornøyes': ('fornøye',),
'fornøyet': ('fornøye',),
'fornøyde': ('fornøye',),
'fornøyet': ('fornøye',),
'fornøyd': ('fornøye',),
'fornøy': ('fornøye',),
'forordne': ('forordne',),
'forordner': ('forordne',),
'forordnes': ('forordne',),
'forordna': ('forordne',),
'forordnet': ('forordne',),
'forordna': ('forordne',),
'forordnet': ('forordne',),
'forordn': ('forordne',),
'forordne': ('forordne',),
'forordn': ('forordne',),
'forordne': ('forordne',),
'forpakte': ('forpakte',),
'forpakter': ('forpakte',),
'forpaktes': ('forpakte',),
'forpakta': ('forpakte',),
'forpaktet': ('forpakte',),
'forpakta': ('forpakte',),
'forpaktet': ('forpakte',),
'forpakt': ('forpakte',),
'forpeste': ('forpeste',),
'forpester': ('forpeste',),
'forpestes': ('forpeste',),
'forpesta': ('forpeste',),
'forpestet': ('forpeste',),
'forpesta': ('forpeste',),
'forpestet': ('forpeste',),
'forpest': ('forpeste',),
'forplante': ('forplante',),
'forplanter': ('forplante',),
'forplantes': ('forplante',),
'forplanta': ('forplante',),
'forplantet': ('forplante',),
'forplanta': ('forplante',),
'forplantet': ('forplante',),
'forplant': ('forplante',),
'forpleie': ('forpleie',),
'forpleier': ('forpleie',),
'forpleies': ('forpleie',),
'forpleia': ('forpleie',),
'forpleiet': ('forpleie',),
'forpleide': ('forpleie',),
'forpleia': ('forpleie',),
'forpleiet': ('forpleie',),
'forpleid': ('forpleie',),
'forplei': ('forpleie',),
'forplikte': ('forplikte',),
'forplikter': ('forplikte',),
'forpliktes': ('forplikte',),
'forplikta': ('forplikte',),
'forpliktet': ('forplikte',),
'forplikta': ('forplikte',),
'forpliktet': ('forplikte',),
'forplikt': ('forplikte',),
'forprosjektere': ('forprosjektere',),
'forprosjekterer': ('forprosjektere',),
'forprosjekteres': ('forprosjektere',),
'forprosjekterte': ('forprosjektere',),
'forprosjektert': ('forprosjektere',),
'forprosjekter': ('forprosjektere',),
'forpuppe': ('forpuppe',),
'forpupper': ('forpuppe',),
'forpuppes': ('forpuppe',),
'forpuppa': ('forpuppe',),
'forpuppet': ('forpuppe',),
'forpuppa': ('forpuppe',),
'forpuppet': ('forpuppe',),
'forpupp': ('forpuppe',),
'forpurre': ('forpurre',),
'forpurrer': ('forpurre',),
'forpurres': ('forpurre',),
'forpurra': ('forpurre',),
'forpurret': ('forpurre',),
'forpurra': ('forpurre',),
'forpurret': ('forpurre',),
'forpurr': ('forpurre',),
'forregne': ('forregne',),
'forregner': ('forregne',),
'forregnes': ('forregne',),
'forregna': ('forregne',),
'forregnet': ('forregne',),
'forregna': ('forregne',),
'forregnet': ('forregne',),
'forregn': ('forregne',),
'forrente': ('forrente',),
'forrenter': ('forrente',),
'forrentes': ('forrente',),
'forrenta': ('forrente',),
'forrentet': ('forrente',),
'forrenta': ('forrente',),
'forrentet': ('forrente',),
'forrent': ('forrente',),
'forrette': ('forrette',),
'forretter': ('forrette',),
'forrettes': ('forrette',),
'forretta': ('forrette',),
'forrettet': ('forrette',),
'forretta': ('forrette',),
'forrettet': ('forrette',),
'forrett': ('forrette',),
'forringe': ('forringe',),
'forringer': ('forringe',),
'forringes': ('forringe',),
'forringa': ('forringe',),
'forringet': ('forringe',),
'forringa': ('forringe',),
'forringet': ('forringe',),
'forring': ('forringe',),
'forrykke': ('forrykke',),
'forrykker': ('forrykke',),
'forrykkes': ('forrykke',),
'forrykka': ('forrykke',),
'forrykket': ('forrykke',),
'forrykte': ('forrykke',),
'forrykka': ('forrykke',),
'forrykket': ('forrykke',),
'forrykt': ('forrykke',),
'forrykk': ('forrykke',),
'forråde': ('forråde',),
'forråder': ('forråde',),
'forrådes': ('forråde',),
'forrådte': ('forråde',),
'forrådt': ('forråde',),
'forråd': ('forråde',),
'forråe': ('forråe',),
'forråer': ('forråe',),
'forråes': ('forråe',),
'forråa': ('forråe',),
'forrået': ('forråe',),
'forråa': ('forråe',),
'forrået': ('forråe',),
'forrå': ('forråe',),
'forsage': ('forsage',),
'forsager': ('forsage',),
'forsages': ('forsage',),
'forsaga': ('forsage',),
'forsaget': ('forsage',),
'forsaga': ('forsage',),
'forsaget': ('forsage',),
'forsag': ('forsage',),
'forsake': ('forsake',),
'forsaker': ('forsake',),
'forsakes': ('forsake',),
'forsaka': ('forsake',),
'forsaket': ('forsake',),
'forsaka': ('forsake',),
'forsaket': ('forsake',),
'forsak': ('forsake',),
'forse': ('forse',),
'forser': ('forse',),
'forses': ('forse',),
'forsees': ('forse',),
'forså': ('forse',),
'forsett': ('forse',),
'forse': ('forse',),
'forsegle': ('forsegle',),
'forsegler': ('forsegle',),
'forsegles': ('forsegle',),
'forsegla': ('forsegle',),
'forseglet': ('forsegle',),
'forsegla': ('forsegle',),
'forseglet': ('forsegle',),
'forsegl': ('forsegle',),
'forsegle': ('forsegle',),
'forsegl': ('forsegle',),
'forsegle': ('forsegle',),
'forsenke': ('forsenke',),
'forsenker': ('forsenke',),
'forsenkes': ('forsenke',),
'forsenka': ('forsenke',),
'forsenket': ('forsenke',),
'forsenka': ('forsenke',),
'forsenket': ('forsenke',),
'forsenk': ('forsenke',),
'forsere': ('forsere',),
'forserer': ('forsere',),
'forseres': ('forsere',),
'forserte': ('forsere',),
'forsert': ('forsere',),
'forser': ('forsere',),
'forsikre': ('forsikre',),
'forsikrer': ('forsikre',),
'forsikres': ('forsikre',),
'forsikra': ('forsikre',),
'forsikret': ('forsikre',),
'forsikra': ('forsikre',),
'forsikret': ('forsikre',),
'forsikr': ('forsikre',),
'forsikre': ('forsikre',),
'forsikr': ('forsikre',),
'forsikre': ('forsikre',),
'forsimple': ('forsimple',),
'forsimpler': ('forsimple',),
'forsimples': ('forsimple',),
'forsimpla': ('forsimple',),
'forsimplet': ('forsimple',),
'forsimpla': ('forsimple',),
'forsimplet': ('forsimple',),
'forsimpl': ('forsimple',),
'forsimple': ('forsimple',),
'forsimpl': ('forsimple',),
'forsimple': ('forsimple',),
'forsinke': ('forsinke',),
'forsinker': ('forsinke',),
'forsinkes': ('forsinke',),
'forsinka': ('forsinke',),
'forsinket': ('forsinke',),
'forsinka': ('forsinke',),
'forsinket': ('forsinke',),
'forsink': ('forsinke',),
'forsire': ('forsire',),
'forsirer': ('forsire',),
'forsires': ('forsire',),
'forsirte': ('forsire',),
'forsirt': ('forsire',),
'forsir': ('forsire',),
'forsjofle': ('forsjofle',),
'forsjofler': ('forsjofle',),
'forsjofles': ('forsjofle',),
'forsjofla': ('forsjofle',),
'forsjoflet': ('forsjofle',),
'forsjofla': ('forsjofle',),
'forsjoflet': ('forsjofle',),
'forsjofl': ('forsjofle',),
'forsjofle': ('forsjofle',),
'forsjofl': ('forsjofle',),
'forsjofle': ('forsjofle',),
'forskale': ('forskale',),
'forskaler': ('forskale',),
'forskales': ('forskale',),
'forskala': ('forskale',),
'forskalet': ('forskale',),
'forskalte': ('forskale',),
'forskala': ('forskale',),
'forskalet': ('forskale',),
'forskalt': ('forskale',),
'forskal': ('forskale',),
'forskanse': ('forskanse',),
'forskanser': ('forskanse',),
'forskanses': ('forskanse',),
'forskansa': ('forskanse',),
'forskanset': ('forskanse',),
'forskansa': ('forskanse',),
'forskanset': ('forskanse',),
'forskans': ('forskanse',),
'forske': ('forske',),
'forsker': ('forske',),
'forskes': ('forske',),
'forska': ('forske',),
'forsket': ('forske',),
'forska': ('forske',),
'forsket': ('forske',),
'forsk': ('forske',),
'forskjellsbehandle': ('forskjellsbehandle',),
'forskjellsbehandler': ('forskjellsbehandle',),
'forskjellsbehandles': ('forskjellsbehandle',),
'forskjellsbehandla': ('forskjellsbehandle',),
'forskjellsbehandlet': ('forskjellsbehandle',),
'forskjellsbehandla': ('forskjellsbehandle',),
'forskjellsbehandlet': ('forskjellsbehandle',),
'forskjellsbehandl': ('forskjellsbehandle',),
'forskjellsbehandle': ('forskjellsbehandle',),
'forskjellsbehandl': ('forskjellsbehandle',),
'forskjellsbehandle': ('forskjellsbehandle',),
'forskjønne': ('forskjønne',),
'forskjønner': ('forskjønne',),
'forskjønnes': ('forskjønne',),
'forskjønna': ('forskjønne',),
'forskjønnet': ('forskjønne',),
'forskjønna': ('forskjønne',),
'forskjønnet': ('forskjønne',),
'forskjønn': ('forskjønne',),
'forskottere': ('forskottere',),
'forskotterer': ('forskottere',),
'forskotteres': ('forskottere',),
'forskotterte': ('forskottere',),
'forskottert': ('forskottere',),
'forskotter': ('forskottere',),
'forskrekke': ('forskrekke',),
'forskrekker': ('forskrekke',),
'forskrekkes': ('forskrekke',),
'forskrekka': ('forskrekke',),
'forskrekket': ('forskrekke',),
'forskrekka': ('forskrekke',),
'forskrekket': ('forskrekke',),
'forskrekk': ('forskrekke',),
'forskreve': ('forskreve',),
'forskrever': ('forskreve',),
'forskreves': ('forskreve',),
'forskreva': ('forskreve',),
'forskrevet': ('forskreve',),
'forskrevde': ('forskreve',),
'forskreva': ('forskreve',),
'forskrevet': ('forskreve',),
'forskrevd': ('forskreve',),
'forskrev': ('forskreve',),
'forskrive': ('forskrive',),
'forskriver': ('forskrive',),
'forskrives': ('forskrive',),
'forskrev': ('forskrive',),
'forskreiv': ('forskrive',),
'forskrev': ('forskrive',),
'forskreiv': ('forskrive',),
'forskrevet': ('forskrive',),
'forskriv': ('forskrive',),
'forskusle': ('forskusle',),
'forskusler': ('forskusle',),
'forskusles': ('forskusle',),
'forskusla': ('forskusle',),
'forskuslet': ('forskusle',),
'forskusla': ('forskusle',),
'forskuslet': ('forskusle',),
'forskusl': ('forskusle',),
'forskuttere': ('forskuttere',),
'forskutterer': ('forskuttere',),
'forskutteres': ('forskuttere',),
'forskutterte': ('forskuttere',),
'forskuttert': ('forskuttere',),
'forskutter': ('forskuttere',),
'forskylde': ('forskylde',),
'forskylder': ('forskylde',),
'forskyldes': ('forskylde',),
'forskyldte': ('forskylde',),
'forskyldt': ('forskylde',),
'forskyld': ('forskylde',),
'forskyve': ('forskyve',),
'forskyver': ('forskyve',),
'forskyves': ('forskyve',),
'forskjøv': ('forskyve',),
'forskøyv': ('forskyve',),
'forskjøvet': ('forskyve',),
'forskyv': ('forskyve',),
'forskåne': ('forskåne',),
'forskåner': ('forskåne',),
'forskånes': ('forskåne',),
'forskåna': ('forskåne',),
'forskånet': ('forskåne',),
'forskånte': ('forskåne',),
'forskåna': ('forskåne',),
'forskånet': ('forskåne',),
'forskånt': ('forskåne',),
'forskån': ('forskåne',),
'forsluke': ('forsluke',),
'forsluker': ('forsluke',),
'forslukes': ('forsluke',),
'forslukte': ('forsluke',),
'forslukt': ('forsluke',),
'forsluk': ('forsluke',),
'forslumme': ('forslumme',),
'forslummer': ('forslumme',),
'forslummes': ('forslumme',),
'forslumma': ('forslumme',),
'forslummet': ('forslumme',),
'forslumma': ('forslumme',),
'forslummet': ('forslumme',),
'forslum': ('forslumme',),
'forslå': ('forslå',),
'forslår': ('forslå',),
'forslås': ('forslå',),
'forslåes': ('forslå',),
'forslo': ('forslå',),
'forslått': ('forslå',),
'forslå': ('forslå',),
'forsmå': ('forsmå',),
'forsmår': ('forsmå',),
'forsmås': ('forsmå',),
'forsmådde': ('forsmå',),
'forsmådd': ('forsmå',),
'forsmå': ('forsmå',),
'forsnakke': ('forsnakke',),
'forsnakker': ('forsnakke',),
'forsnakkes': ('forsnakke',),
'forsnakka': ('forsnakke',),
'forsnakket': ('forsnakke',),
'forsnakka': ('forsnakke',),
'forsnakket': ('forsnakke',),
'forsnakk': ('forsnakke',),
'forsnevre': ('forsnevre',),
'forsnevrer': ('forsnevre',),
'forsnevres': ('forsnevre',),
'forsnevra': ('forsnevre',),
'forsnevret': ('forsnevre',),
'forsnevra': ('forsnevre',),
'forsnevret': ('forsnevre',),
'forsnevr': ('forsnevre',),
'forsnevre': ('forsnevre',),
'forsnevr': ('forsnevre',),
'forsnevre': ('forsnevre',),
'forsone': ('forsone',),
'forsoner': ('forsone',),
'forsones': ('forsone',),
'forsona': ('forsone',),
'forsonet': ('forsone',),
'forsonte': ('forsone',),
'forsona': ('forsone',),
'forsonet': ('forsone',),
'forsont': ('forsone',),
'forson': ('forsone',),
'forsove': ('forsove',),
'forsover': ('forsove',),
'forsoves': ('forsove',),
'forsov': ('forsove',),
'forsovet': ('forsove',),
'forsov': ('forsove',),
'forspenne': ('forspenne',),
'forspenner': ('forspenne',),
'forspennes': ('forspenne',),
'forspente': ('forspenne',),
'forspent': ('forspenne',),
'forspenn': ('forspenne',),
'forspille': ('forspille',),
'forspiller': ('forspille',),
'forspilles': ('forspille',),
'forspilte': ('forspille',),
'forspilt': ('forspille',),
'forspill': ('forspille',),
'forspise': ('forspise',),
'forspiser': ('forspise',),
'forspises': ('forspise',),
'forspiste': ('forspise',),
'forspist': ('forspise',),
'forspis': ('forspise',),
'forspørre': ('forspørre',),
'forspør': ('forspørre',),
'forspørres': ('forspørre',),
'forspurte': ('forspørre',),
'forspurt': ('forspørre',),
'forspør': ('forspørre',),
'forsterke': ('forsterke',),
'forsterker': ('forsterke',),
'forsterkes': ('forsterke',),
'forsterka': ('forsterke',),
'forsterket': ('forsterke',),
'forsterka': ('forsterke',),
'forsterket': ('forsterke',),
'forsterk': ('forsterke',),
'forstikke': ('forstikke',),
'forstikker': ('forstikke',),
'forstikkes': ('forstikke',),
'forstakk': ('forstikke',),
'forstukket': ('forstikke',),
'forstikk': ('forstikke',),
'forstille': ('forstille',),
'forstiller': ('forstille',),
'forstilles': ('forstille',),
'forstilte': ('forstille',),
'forstilt': ('forstille',),
'forstill': ('forstille',),
'forstue': ('forstue',),
'forstuer': ('forstue',),
'forstues': ('forstue',),
'forstua': ('forstue',),
'forstuet': ('forstue',),
'forstua': ('forstue',),
'forstuet': ('forstue',),
'forstu': ('forstue',),
'forstumme': ('forstumme',),
'forstummer': ('forstumme',),
'forstummes': ('forstumme',),
'forstumma': ('forstumme',),
'forstummet': ('forstumme',),
'forstumma': ('forstumme',),
'forstummet': ('forstumme',),
'forstum': ('forstumme',),
'forstyrre': ('forstyrre',),
'forstyrrer': ('forstyrre',),
'forstyrres': ('forstyrre',),
'forstyrra': ('forstyrre',),
'forstyrret': ('forstyrre',),
'forstyrra': ('forstyrre',),
'forstyrret': ('forstyrre',),
'forstyrr': ('forstyrre',),
'forstå': ('forstå',),
'forstår': ('forstå',),
'forstås': ('forstå',),
'forsto': ('forstå',),
'forstod': ('forstå',),
'forstått': ('forstå',),
'forstå': ('forstå',),
'forstørre': ('forstørre',),
'forstørrer': ('forstørre',),
'forstørres': ('forstørre',),
'forstørra': ('forstørre',),
'forstørret': ('forstørre',),
'forstørra': ('forstørre',),
'forstørret': ('forstørre',),
'forstørr': ('forstørre',),
'forstøte': ('forstøte',),
'forstøter': ('forstøte',),
'forstøtes': ('forstøte',),
'forstøtte': ('forstøte',),
'forstøtt': ('forstøte',),
'forstøt': ('forstøte',),
'forstøtte': ('forstøtte',),
'forstøtter': ('forstøtte',),
'forstøttes': ('forstøtte',),
'forstøtta': ('forstøtte',),
'forstøttet': ('forstøtte',),
'forstøtta': ('forstøtte',),
'forstøttet': ('forstøtte',),
'forstøtt': ('forstøtte',),
'forstøve': ('forstøve',),
'forstøver': ('forstøve',),
'forstøves': ('forstøve',),
'forstøva': ('forstøve',),
'forstøvet': ('forstøve',),
'forstøva': ('forstøve',),
'forstøvet': ('forstøve',),
'forstøv': ('forstøve',),
'forsumpe': ('forsumpe',),
'forsumper': ('forsumpe',),
'forsumpes': ('forsumpe',),
'forsumpa': ('forsumpe',),
'forsumpet': ('forsumpe',),
'forsumpa': ('forsumpe',),
'forsumpet': ('forsumpe',),
'forsump': ('forsumpe',),
'forsure': ('forsure',),
'forsurer': ('forsure',),
'forsures': ('forsure',),
'forsura': ('forsure',),
'forsuret': ('forsure',),
'forsura': ('forsure',),
'forsuret': ('forsure',),
'forsur': ('forsure',),
'forsvare': ('forsvare',),
'forsvarer': ('forsvare',),
'forsvares': ('forsvare',),
'forsvarte': ('forsvare',),
'forsvart': ('forsvare',),
'forsvar': ('forsvare',),
'forsvenske': ('forsvenske',),
'forsvensker': ('forsvenske',),
'forsvenskes': ('forsvenske',),
'forsvenska': ('forsvenske',),
'forsvensket': ('forsvenske',),
'forsvenska': ('forsvenske',),
'forsvensket': ('forsvenske',),
'forsvensk': ('forsvenske',),
'forsverge': ('forsverge',),
'forsverger': ('forsverge',),
'forsverges': ('forsverge',),
'forsverga': ('forsverge',),
'forsverget': ('forsverge',),
'forsvor': ('forsverge',),
'forsverga': ('forsverge',),
'forsverget': ('forsverge',),
'forsvoret': ('forsverge',),
'forsverg': ('forsverge',),
'forsvinne': ('forsvinne',),
'forsvinner': ('forsvinne',),
'forsvinnes': ('forsvinne',),
'forsvant': ('forsvinne',),
'forsvunnet': ('forsvinne',),
'forsvinn': ('forsvinne',),
'forsynde': ('forsynde',),
'forsynder': ('forsynde',),
'forsyndes': ('forsynde',),
'forsynda': ('forsynde',),
'forsyndet': ('forsynde',),
'forsynda': ('forsynde',),
'forsyndet': ('forsynde',),
'forsynd': ('forsynde',),
'forsyne': ('forsyne',),
'forsyner': ('forsyne',),
'forsynes': ('forsyne',),
'forsynte': ('forsyne',),
'forsynt': ('forsyne',),
'forsyn': ('forsyne',),
'forsøke': ('forsøke',),
'forsøker': ('forsøke',),
'forsøkes': ('forsøke',),
'forsøkte': ('forsøke',),
'forsøkt': ('forsøke',),
'forsøk': ('forsøke',),
'forsølve': ('forsølve',),
'forsølver': ('forsølve',),
'forsølves': ('forsølve',),
'forsølva': ('forsølve',),
'forsølvet': ('forsølve',),
'forsølva': ('forsølve',),
'forsølvet': ('forsølve',),
'forsølv': ('forsølve',),
'forsømme': ('forsømme',),
'forsømmer': ('forsømme',),
'forsømmes': ('forsømme',),
'forsømte': ('forsømme',),
'forsømt': ('forsømme',),
'forsøm': ('forsømme',),
'forsøple': ('forsøple',),
'forsøpler': ('forsøple',),
'forsøples': ('forsøple',),
'forsøpla': ('forsøple',),
'forsøplet': ('forsøple',),
'forsøpla': ('forsøple',),
'forsøplet': ('forsøple',),
'forsøpl': ('forsøple',),
'forsøple': ('forsøple',),
'forsøpl': ('forsøple',),
'forsøple': ('forsøple',),
'forsørge': ('forsørge',),
'forsørger': ('forsørge',),
'forsørges': ('forsørge',),
'forsørga': ('forsørge',),
'forsørget': ('forsørge',),
'forsørgde': ('forsørge',),
'forsørga': ('forsørge',),
'forsørget': ('forsørge',),
'forsørgd': ('forsørge',),
'forsørg': ('forsørge',),
'forsøte': ('forsøte',),
'forsøter': ('forsøte',),
'forsøtes': ('forsøte',),
'forsøta': ('forsøte',),
'forsøtet': ('forsøte',),
'forsøta': ('forsøte',),
'forsøtet': ('forsøte',),
'forsøt': ('forsøte',),
'forta': ('forta',),
'fortar': ('forta',),
'fortas': ('forta',),
'fortok': ('forta',),
'fortatt': ('forta',),
'forta': ('forta',),
'fortape': ('fortape',),
'fortaper': ('fortape',),
'fortapes': ('fortape',),
'fortapte': ('fortape',),
'fortapt': ('fortape',),
'fortap': ('fortape',),
'forte': ('forte',),
'forter': ('forte',),
'fortes': ('forte',),
'forta': ('forte',),
'fortet': ('forte',),
'forta': ('forte',),
'fortet': ('forte',),
'fort': ('forte',),
'fortegne': ('fortegne',),
'fortegner': ('fortegne',),
'fortegnes': ('fortegne',),
'fortegna': ('fortegne',),
'fortegnet': ('fortegne',),
'fortegna': ('fortegne',),
'fortegnet': ('fortegne',),
'fortegn': ('fortegne',),
'fortelle': ('fortelle',),
'forteller': ('fortelle',),
'fortelles': ('fortelle',),
'fortalte': ('fortelle',),
'fortalt': ('fortelle',),
'fortell': ('fortelle',),
'fortenke': ('fortenke',),
'fortenker': ('fortenke',),
'fortenkes': ('fortenke',),
'fortenkte': ('fortenke',),
'fortenkt': ('fortenke',),
'fortenk': ('fortenke',),
'fortette': ('fortette',),
'fortetter': ('fortette',),
'fortettes': ('fortette',),
'fortetta': ('fortette',),
'fortettet': ('fortette',),
'fortetta': ('fortette',),
'fortettet': ('fortette',),
'fortett': ('fortette',),
'fortie': ('fortie',),
'fortier': ('fortie',),
'forties': ('fortie',),
'fortia': ('fortie',),
'fortiet': ('fortie',),
'fortidde': ('fortie',),
'fortia': ('fortie',),
'fortiet': ('fortie',),
'fortidd': ('fortie',),
'forti': ('fortie',),
'fortinne': ('fortinne',),
'fortinner': ('fortinne',),
'fortinnes': ('fortinne',),
'fortinna': ('fortinne',),
'fortinnet': ('fortinne',),
'fortinna': ('fortinne',),
'fortinnet': ('fortinne',),
'fortinn': ('fortinne',),
'fortjene': ('fortjene',),
'fortjener': ('fortjene',),
'fortjenes': ('fortjene',),
'fortjente': ('fortjene',),
'fortjent': ('fortjene',),
'fortjen': ('fortjene',),
'fortne': ('fortne',),
'fortner': ('fortne',),
'fortnes': ('fortne',),
'fortna': ('fortne',),
'fortnet': ('fortne',),
'fortna': ('fortne',),
'fortnet': ('fortne',),
'fortn': ('fortne',),
'fortne': ('fortne',),
'fortn': ('fortne',),
'fortne': ('fortne',),
'fortolke': ('fortolke',),
'fortolker': ('fortolke',),
'fortolkes': ('fortolke',),
'fortolka': ('fortolke',),
'fortolket': ('fortolke',),
'fortolka': ('fortolke',),
'fortolket': ('fortolke',),
'fortolk': ('fortolke',),
'fortolle': ('fortolle',),
'fortoller': ('fortolle',),
'fortolles': ('fortolle',),
'fortolla': ('fortolle',),
'fortollet': ('fortolle',),
'fortolla': ('fortolle',),
'fortollet': ('fortolle',),
'fortoll': ('fortolle',),
'fortone': ('fortone',),
'fortoner': ('fortone',),
'fortones': ('fortone',),
'fortona': ('fortone',),
'fortonet': ('fortone',),
'fortonte': ('fortone',),
'fortona': ('fortone',),
'fortonet': ('fortone',),
'fortont': ('fortone',),
'forton': ('fortone',),
'fortorve': ('fortorve',),
'fortorver': ('fortorve',),
'fortorves': ('fortorve',),
'fortorva': ('fortorve',),
'fortorvet': ('fortorve',),
'fortorva': ('fortorve',),
'fortorvet': ('fortorve',),
'fortorv': ('fortorve',),
'fortrekke': ('fortrekke',),
'fortrekker': ('fortrekke',),
'fortrekkes': ('fortrekke',),
'fortrakk': ('fortrekke',),
'fortrukket': ('fortrekke',),
'fortrekk': ('fortrekke',),
'fortrenge': ('fortrenge',),
'fortrenger': ('fortrenge',),
'fortrenges': ('fortrenge',),
'fortrengte': ('fortrenge',),
'fortrengt': ('fortrenge',),
'fortreng': ('fortrenge',),
'fortrolle': ('fortrolle',),
'fortroller': ('fortrolle',),
'fortrolles': ('fortrolle',),
'fortrolla': ('fortrolle',),
'fortrollet': ('fortrolle',),
'fortrolla': ('fortrolle',),
'fortrollet': ('fortrolle',),
'fortroll': ('fortrolle',),
'fortrylle': ('fortrylle',),
'fortryller': ('fortrylle',),
'fortrylles': ('fortrylle',),
'fortrylla': ('fortrylle',),
'fortryllet': ('fortrylle',),
'fortrylla': ('fortrylle',),
'fortryllet': ('fortrylle',),
'fortryll': ('fortrylle',),
'fortrøste': ('fortrøste',),
'fortrøster': ('fortrøste',),
'fortrøstes': ('fortrøste',),
'fortrøsta': ('fortrøste',),
'fortrøstet': ('fortrøste',),
'fortrøsta': ('fortrøste',),
'fortrøstet': ('fortrøste',),
'fortrøst': ('fortrøste',),
'fortsette': ('fortsette',),
'fortsetter': ('fortsette',),
'fortsettes': ('fortsette',),
'fortsatte': ('fortsette',),
'fortsatt': ('fortsette',),
'fortsett': ('fortsette',),
'fortvile': ('fortvile',),
'fortviler': ('fortvile',),
'fortviles': ('fortvile',),
'fortvilte': ('fortvile',),
'fortvilt': ('fortvile',),
'fortvil': ('fortvile',),
'fortykke': ('fortykke',),
'fortykker': ('fortykke',),
'fortykkes': ('fortykke',),
'fortykka': ('fortykke',),
'fortykket': ('fortykke',),
'fortykka': ('fortykke',),
'fortykket': ('fortykke',),
'fortykk': ('fortykke',),
'fortynne': ('fortynne',),
'fortynner': ('fortynne',),
'fortynnes': ('fortynne',),
'fortynna': ('fortynne',),
'fortynnet': ('fortynne',),
'fortynna': ('fortynne',),
'fortynnet': ('fortynne',),
'fortynn': ('fortynne',),
'fortære': ('fortære',),
'fortærer': ('fortære',),
'fortæres': ('fortære',),
'fortærte': ('fortære',),
'fortært': ('fortære',),
'fortær': ('fortære',),
'fortørne': ('fortørne',),
'fortørner': ('fortørne',),
'fortørnes': ('fortørne',),
'fortørna': ('fortørne',),
'fortørnet': ('fortørne',),
'fortørna': ('fortørne',),
'fortørnet': ('fortørne',),
'fortørn': ('fortørne',),
'fortøye': ('fortøye',),
'fortøyer': ('fortøye',),
'fortøyes': ('fortøye',),
'fortøyde': ('fortøye',),
'fortøyd': ('fortøye',),
'fortøy': ('fortøye',),
'foruleilige': ('foruleilige',),
'foruleiliger': ('foruleilige',),
'foruleiliges': ('foruleilige',),
'foruleiliga': ('foruleilige',),
'foruleiliget': ('foruleilige',),
'foruleiliga': ('foruleilige',),
'foruleiliget': ('foruleilige',),
'foruleilig': ('foruleilige',),
'forulempe': ('forulempe',),
'forulemper': ('forulempe',),
'forulempes': ('forulempe',),
'forulempa': ('forulempe',),
'forulempet': ('forulempe',),
'forulempa': ('forulempe',),
'forulempet': ('forulempe',),
'forulemp': ('forulempe',),
'forulykke': ('forulykke',),
'forulykker': ('forulykke',),
'forulykkes': ('forulykke',),
'forulykka': ('forulykke',),
'forulykket': ('forulykke',),
'forulykka': ('forulykke',),
'forulykket': ('forulykke',),
'forulykk': ('forulykke',),
'forundre': ('forundre',),
'forundrer': ('forundre',),
'forundres': ('forundre',),
'forundra': ('forundre',),
'forundret': ('forundre',),
'forundra': ('forundre',),
'forundret': ('forundre',),
'forundr': ('forundre',),
'forundre': ('forundre',),
'forundr': ('forundre',),
'forundre': ('forundre',),
'forunne': ('forunne',),
'forunner': ('forunne',),
'forunnes': ('forunne',),
'forunte': ('forunne',),
'forunt': ('forunne',),
'forunn': ('forunne',),
'forurense': ('forurense',),
'forurenser': ('forurense',),
'forurenses': ('forurense',),
'forurensa': ('forurense',),
'forurenset': ('forurense',),
'forurensa': ('forurense',),
'forurenset': ('forurense',),
'forurens': ('forurense',),
'forurette': ('forurette',),
'foruretter': ('forurette',),
'forurettes': ('forurette',),
'foruretta': ('forurette',),
'forurettet': ('forurette',),
'foruretta': ('forurette',),
'forurettet': ('forurette',),
'forurett': ('forurette',),
'forurolige': ('forurolige',),
'foruroliger': ('forurolige',),
'foruroliges': ('forurolige',),
'foruroliga': ('forurolige',),
'foruroliget': ('forurolige',),
'foruroliga': ('forurolige',),
'foruroliget': ('forurolige',),
'forurolig': ('forurolige',),
'forutberegne': ('forutberegne',),
'forutberegner': ('forutberegne',),
'forutberegnes': ('forutberegne',),
'forutberegna': ('forutberegne',),
'forutberegnet': ('forutberegne',),
'forutberegna': ('forutberegne',),
'forutberegnet': ('forutberegne',),
'forutberegn': ('forutberegne',),
'forutbestemme': ('forutbestemme',),
'forutbestemmer': ('forutbestemme',),
'forutbestemmes': ('forutbestemme',),
'forutbestemte': ('forutbestemme',),
'forutbestemt': ('forutbestemme',),
'forutbestem': ('forutbestemme',),
'forutse': ('forutse',),
'forutser': ('forutse',),
'forutses': ('forutse',),
'forutsees': ('forutse',),
'forutså': ('forutse',),
'forutsett': ('forutse',),
'forutse': ('forutse',),
'forutsette': ('forutsette',),
'forutsetter': ('forutsette',),
'forutsettes': ('forutsette',),
'forutsatte': ('forutsette',),
'forutsatt': ('forutsette',),
'forutsett': ('forutsette',),
'forutskikke': ('forutskikke',),
'forutskikker': ('forutskikke',),
'forutskikkes': ('forutskikke',),
'forutskikka': ('forutskikke',),
'forutskikket': ('forutskikke',),
'forutskikka': ('forutskikke',),
'forutskikket': ('forutskikke',),
'forutskikk': ('forutskikke',),
'forvalte': ('forvalte',),
'forvalter': ('forvalte',),
'forvaltes': ('forvalte',),
'forvalta': ('forvalte',),
'forvaltet': ('forvalte',),
'forvalta': ('forvalte',),
'forvaltet': ('forvalte',),
'forvalt': ('forvalte',),
'forvandle': ('forvandle',),
'forvandler': ('forvandle',),
'forvandles': ('forvandle',),
'forvandla': ('forvandle',),
'forvandlet': ('forvandle',),
'forvandla': ('forvandle',),
'forvandlet': ('forvandle',),
'forvandl': ('forvandle',),
'forvandle': ('forvandle',),
'forvandl': ('forvandle',),
'forvandle': ('forvandle',),
'forvanske': ('forvanske',),
'forvansker': ('forvanske',),
'forvanskes': ('forvanske',),
'forvanska': ('forvanske',),
'forvansket': ('forvanske',),
'forvanska': ('forvanske',),
'forvansket': ('forvanske',),
'forvansk': ('forvanske',),
'forvare': ('forvare',),
'forvarer': ('forvare',),
'forvares': ('forvare',),
'forvarte': ('forvare',),
'forvart': ('forvare',),
'forvar': ('forvare',),
'forvede': ('forvede',),
'forveder': ('forvede',),
'forvedes': ('forvede',),
'forveda': ('forvede',),
'forvedet': ('forvede',),
'forveda': ('forvede',),
'forvedet': ('forvede',),
'forved': ('forvede',),
'forveksle': ('forveksle',),
'forveksler': ('forveksle',),
'forveksles': ('forveksle',),
'forveksla': ('forveksle',),
'forvekslet': ('forveksle',),
'forveksla': ('forveksle',),
'forvekslet': ('forveksle',),
'forveksl': ('forveksle',),
'forveksle': ('forveksle',),
'forveksl': ('forveksle',),
'forveksle': ('forveksle',),
'forvelle': ('forvelle',),
'forveller': ('forvelle',),
'forvelles': ('forvelle',),
'forvella': ('forvelle',),
'forvellet': ('forvelle',),
'forvelte': ('forvelle',),
'forvella': ('forvelle',),
'forvellet': ('forvelle',),
'forvelt': ('forvelle',),
'forvell': ('forvelle',),
'forvenne': ('forvenne',),
'forvenner': ('forvenne',),
'forvennes': ('forvenne',),
'forvente': ('forvenne',),
'forvent': ('forvenne',),
'forvenn': ('forvenne',),
'forvente': ('forvente',),
'forventer': ('forvente',),
'forventes': ('forvente',),
'forventa': ('forvente',),
'forventet': ('forvente',),
'forventa': ('forvente',),
'forventet': ('forvente',),
'forvent': ('forvente',),
'forverre': ('forverre',),
'forverrer': ('forverre',),
'forverres': ('forverre',),
'forverra': ('forverre',),
'forverret': ('forverre',),
'forverra': ('forverre',),
'forverret': ('forverre',),
'forverr': ('forverre',),
'forville': ('forville',),
'forviller': ('forville',),
'forvilles': ('forville',),
'forvilla': ('forville',),
'forvillet': ('forville',),
'forvilla': ('forville',),
'forvillet': ('forville',),
'forvill': ('forville',),
'forvirre': ('forvirre',),
'forvirrer': ('forvirre',),
'forvirres': ('forvirre',),
'forvirra': ('forvirre',),
'forvirret': ('forvirre',),
'forvirra': ('forvirre',),
'forvirret': ('forvirre',),
'forvirr': ('forvirre',),
'forvise': ('forvise',),
'forviser': ('forvise',),
'forvises': ('forvise',),
'forviste': ('forvise',),
'forvist': ('forvise',),
'forvis': ('forvise',),
'forvisse': ('forvisse',),
'forvisser': ('forvisse',),
'forvisses': ('forvisse',),
'forvissa': ('forvisse',),
'forvisset': ('forvisse',),
'forvissa': ('forvisse',),
'forvisset': ('forvisse',),
'forviss': ('forvisse',),
'forvitre': ('forvitre',),
'forvitrer': ('forvitre',),
'forvitres': ('forvitre',),
'forvitra': ('forvitre',),
'forvitret': ('forvitre',),
'forvitra': ('forvitre',),
'forvitret': ('forvitre',),
'forvitr': ('forvitre',),
'forvitre': ('forvitre',),
'forvitr': ('forvitre',),
'forvitre': ('forvitre',),
'forvolde': ('forvolde',),
'forvolder': ('forvolde',),
'forvoldes': ('forvolde',),
'forvoldte': ('forvolde',),
'forvoldt': ('forvolde',),
'forvold': ('forvolde',),
'forvrenge': ('forvrenge',),
'forvrenger': ('forvrenge',),
'forvrenges': ('forvrenge',),
'forvrengte': ('forvrenge',),
'forvrengt': ('forvrenge',),
'forvreng': ('forvrenge',),
'forvri': ('forvri',),
'forvrir': ('forvri',),
'forvris': ('forvri',),
'forvridde': ('forvri',),
'forvrei': ('forvri',),
'forvred': ('forvri',),
'forvridd': ('forvri',),
'forvri': ('forvri',),
'forynge': ('forynge',),
'forynger': ('forynge',),
'forynges': ('forynge',),
'forynga': ('forynge',),
'forynget': ('forynge',),
'forynga': ('forynge',),
'forynget': ('forynge',),
'foryng': ('forynge',),
'forårsake': ('forårsake',),
'forårsaker': ('forårsake',),
'forårsakes': ('forårsake',),
'forårsaka': ('forårsake',),
'forårsaket': ('forårsake',),
'forårsaka': ('forårsake',),
'forårsaket': ('forårsake',),
'forårsak': ('forårsake',),
'forære': ('forære',),
'forærer': ('forære',),
'foræres': ('forære',),
'forærte': ('forære',),
'forært': ('forære',),
'forær': ('forære',),
'forøde': ('forøde',),
'forøder': ('forøde',),
'forødes': ('forøde',),
'forøda': ('forøde',),
'forødet': ('forøde',),
'forødte': ('forøde',),
'forøda': ('forøde',),
'forødet': ('forøde',),
'forødt': ('forøde',),
'forød': ('forøde',),
'forøke': ('forøke',),
'forøker': ('forøke',),
'forøkes': ('forøke',),
'forøka': ('forøke',),
'forøket': ('forøke',),
'forøkte': ('forøke',),
'forøka': ('forøke',),
'forøket': ('forøke',),
'forøkt': ('forøke',),
'forøk': ('forøke',),
'forøve': ('forøve',),
'forøver': ('forøve',),
'forøves': ('forøve',),
'forøva': ('forøve',),
'forøvet': ('forøve',),
'forøvde': ('forøve',),
'forøva': ('forøve',),
'forøvet': ('forøve',),
'forøvd': ('forøve',),
'forøv': ('forøve',),
'fosforescere': ('fosforescere',),
'fosforescerer': ('fosforescere',),
'fosforesceres': ('fosforescere',),
'fosforescerte': ('fosforescere',),
'fosforescert': ('fosforescere',),
'fosforescer': ('fosforescere',),
'fosse': ('fosse',),
'fosser': ('fosse',),
'fosses': ('fosse',),
'fossa': ('fosse',),
'fosset': ('fosse',),
'fossa': ('fosse',),
'fosset': ('fosse',),
'foss': ('fosse',),
'fosskoke': ('fosskoke',),
'fosskoker': ('fosskoke',),
'fosskokes': ('fosskoke',),
'fosskokte': ('fosskoke',),
'fosskokt': ('fosskoke',),
'fosskok': ('fosskoke',),
'fossregne': ('fossregne',),
'fossregner': ('fossregne',),
'fossregnes': ('fossregne',),
'fossregna': ('fossregne',),
'fossregnet': ('fossregne',),
'fossregnte': ('fossregne',),
'fossregna': ('fossregne',),
'fossregnet': ('fossregne',),
'fossregnt': ('fossregne',),
'fossregn': ('fossregne',),
'fossro': ('fossro',),
'fossror': ('fossro',),
'fossros': ('fossro',),
'fossrodde': ('fossro',),
'fossrodd': ('fossro',),
'fossro': ('fossro',),
'fostre': ('fostre',),
'fostrer': ('fostre',),
'fostres': ('fostre',),
'fostra': ('fostre',),
'fostret': ('fostre',),
'fostra': ('fostre',),
'fostret': ('fostre',),
'fostr': ('fostre',),
'fostre': ('fostre',),
'fostr': ('fostre',),
'fostre': ('fostre',),
'fote': ('fote',),
'foter': ('fote',),
'fotes': ('fote',),
'fota': ('fote',),
'fotet': ('fote',),
'fota': ('fote',),
'fotet': ('fote',),
'fot': ('fote',),
'fotografere': ('fotografere',),
'fotograferer': ('fotografere',),
'fotograferes': ('fotografere',),
'fotograferte': ('fotografere',),
'fotografert': ('fotografere',),
'fotografer': ('fotografere',),
'fotokopiere': ('fotokopiere',),
'fotokopierer': ('fotokopiere',),
'fotokopieres': ('fotokopiere',),
'fotokopierte': ('fotokopiere',),
'fotokopiert': ('fotokopiere',),
'fotokopier': ('fotokopiere',),
'frabe': ('frabe',),
'fraber': ('frabe',),
'frabes': ('frabe',),
'frabad': ('frabe',),
'fraba': ('frabe',),
'frabedt': ('frabe',),
'frabe': ('frabe',),
'frabeordre': ('frabeordre',),
'frabeordrer': ('frabeordre',),
'frabeordres': ('frabeordre',),
'frabeordra': ('frabeordre',),
'frabeordret': ('frabeordre',),
'frabeordra': ('frabeordre',),
'frabeordret': ('frabeordre',),
'frabeordr': ('frabeordre',),
'frabeordre': ('frabeordre',),
'frabeordr': ('frabeordre',),
'frabeordre': ('frabeordre',),
'fradømme': ('fradømme',),
'fradømmer': ('fradømme',),
'fradømmes': ('fradømme',),
'fradømte': ('fradømme',),
'fradømt': ('fradømme',),
'fradøm': ('fradømme',),
'fraflytte': ('fraflytte',),
'fraflytter': ('fraflytte',),
'fraflyttes': ('fraflytte',),
'fraflytta': ('fraflytte',),
'fraflyttet': ('fraflytte',),
'fraflytta': ('fraflytte',),
'fraflyttet': ('fraflytte',),
'fraflytt': ('fraflytte',),
'fragmentere': ('fragmentere',),
'fragmenterer': ('fragmentere',),
'fragmenteres': ('fragmentere',),
'fragmenterte': ('fragmentere',),
'fragmentert': ('fragmentere',),
'fragmenter': ('fragmentere',),
'fragå': ('fragå',),
'fragår': ('fragå',),
'fragås': ('fragå',),
'fragikk': ('fragå',),
'fragått': ('fragå',),
'fragå': ('fragå',),
'frakjenne': ('frakjenne',),
'frakjenner': ('frakjenne',),
'frakjennes': ('frakjenne',),
'frakjente': ('frakjenne',),
'frakjent': ('frakjenne',),
'frakjenn': ('frakjenne',),
'frakoble': ('frakoble',),
'frakobler': ('frakoble',),
'frakobles': ('frakoble',),
'frakobla': ('frakoble',),
'frakoblet': ('frakoble',),
'frakobla': ('frakoble',),
'frakoblet': ('frakoble',),
'frakobl': ('frakoble',),
'frakoble': ('frakoble',),
'frakobl': ('frakoble',),
'frakoble': ('frakoble',),
'frakople': ('frakople',),
'frakopler': ('frakople',),
'frakoples': ('frakople',),
'frakopla': ('frakople',),
'frakoplet': ('frakople',),
'frakopla': ('frakople',),
'frakoplet': ('frakople',),
'frakopl': ('frakople',),
'frakople': ('frakople',),
'frakopl': ('frakople',),
'frakople': ('frakople',),
'fraksjonere': ('fraksjonere',),
'fraksjonerer': ('fraksjonere',),
'fraksjoneres': ('fraksjonere',),
'fraksjonerte': ('fraksjonere',),
'fraksjonert': ('fraksjonere',),
'fraksjoner': ('fraksjonere',),
'frakte': ('frakte',),
'frakter': ('frakte',),
'fraktes': ('frakte',),
'frakta': ('frakte',),
'fraktet': ('frakte',),
'frakta': ('frakte',),
'fraktet': ('frakte',),
'frakt': ('frakte',),
'fralegge': ('fralegge',),
'fralegger': ('fralegge',),
'fralegges': ('fralegge',),
'frala': ('fralegge',),
'fralagt': ('fralegge',),
'fralegg': ('fralegge',),
'fralokke': ('fralokke',),
'fralokker': ('fralokke',),
'fralokkes': ('fralokke',),
'fralokka': ('fralokke',),
'fralokket': ('fralokke',),
'fralokka': ('fralokke',),
'fralokket': ('fralokke',),
'fralokk': ('fralokke',),
'framdatere': ('framdatere',),
'framdaterer': ('framdatere',),
'framdateres': ('framdatere',),
'framdaterte': ('framdatere',),
'framdatert': ('framdatere',),
'framdater': ('framdatere',),
'framelske': ('framelske',),
'framelsker': ('framelske',),
'framelskes': ('framelske',),
'framelska': ('framelske',),
'framelsket': ('framelske',),
'framelska': ('framelske',),
'framelsket': ('framelske',),
'framelsk': ('framelske',),
'framføre': ('framføre',),
'framfører': ('framføre',),
'framføres': ('framføre',),
'framførte': ('framføre',),
'framført': ('framføre',),
'framfør': ('framføre',),
'framgå': ('framgå',),
'framgår': ('framgå',),
'framgås': ('framgå',),
'framgikk': ('framgå',),
'framgått': ('framgå',),
'framgå': ('framgå',),
'framheve': ('framheve',),
'framhever': ('framheve',),
'framheves': ('framheve',),
'framheva': ('framheve',),
'framhevet': ('framheve',),
'framhevde': ('framheve',),
'framheva': ('framheve',),
'framhevet': ('framheve',),
'framhevd': ('framheve',),
'framhev': ('framheve',),
'framholde': ('framholde',),
'framholder': ('framholde',),
'framholdes': ('framholde',),
'framholdt': ('framholde',),
'framhold': ('framholde',),
'framkalle': ('framkalle',),
'framkaller': ('framkalle',),
'framkalles': ('framkalle',),
'framkalte': ('framkalle',),
'framkalt': ('framkalle',),
'framkall': ('framkalle',),
'framkaste': ('framkaste',),
'framkaster': ('framkaste',),
'framkastes': ('framkaste',),
'framkasta': ('framkaste',),
'framkastet': ('framkaste',),
'framkasta': ('framkaste',),
'framkastet': ('framkaste',),
'framkast': ('framkaste',),
'framlegge': ('framlegge',),
'framlegger': ('framlegge',),
'framlegges': ('framlegge',),
'framla': ('framlegge',),
'framlagt': ('framlegge',),
'framlegg': ('framlegge',),
'framleie': ('framleie',),
'framleier': ('framleie',),
'framleies': ('framleie',),
'framleide': ('framleie',),
'framleid': ('framleie',),
'framlei': ('framleie',),
'framsette': ('framsette',),
'framsetter': ('framsette',),
'framsettes': ('framsette',),
'framsatte': ('framsette',),
'framsatt': ('framsette',),
'framsett': ('framsette',),
'framsi': ('framsi',),
'framsier': ('framsi',),
'framsies': ('framsi',),
'framsa': ('framsi',),
'framsagt': ('framsi',),
'framsi': ('framsi',),
'framskaffe': ('framskaffe',),
'framskaffer': ('framskaffe',),
'framskaffes': ('framskaffe',),
'framskaffa': ('framskaffe',),
'framskaffet': ('framskaffe',),
'framskaffa': ('framskaffe',),
'framskaffet': ('framskaffe',),
'framskaff': ('framskaffe',),
'framskrive': ('framskrive',),
'framskriver': ('framskrive',),
'framskrives': ('framskrive',),
'framskrev': ('framskrive',),
'framskreiv': ('framskrive',),
'framskrev': ('framskrive',),
'framskreiv': ('framskrive',),
'framskrevet': ('framskrive',),
'framskriv': ('framskrive',),
'framskynde': ('framskynde',),
'framskynder': ('framskynde',),
'framskyndes': ('framskynde',),
'framskynda': ('framskynde',),
'framskyndet': ('framskynde',),
'framskyndte': ('framskynde',),
'framskynda': ('framskynde',),
'framskyndet': ('framskynde',),
'framskyndt': ('framskynde',),
'framskynd': ('framskynde',),
'framskyte': ('framskyte',),
'framskyter': ('framskyte',),
'framskytes': ('framskyte',),
'framskjøt': ('framskyte',),
'framskøyt': ('framskyte',),
'framskutt': ('framskyte',),
'framskyt': ('framskyte',),
'framstille': ('framstille',),
'framstiller': ('framstille',),
'framstilles': ('framstille',),
'framstilte': ('framstille',),
'framstilt': ('framstille',),
'framstill': ('framstille',),
'framstå': ('framstå',),
'framstår': ('framstå',),
'framstås': ('framstå',),
'framsto': ('framstå',),
'framstod': ('framstå',),
'framstått': ('framstå',),
'framstå': ('framstå',),
'framvise': ('framvise',),
'framviser': ('framvise',),
'framvises': ('framvise',),
'framviste': ('framvise',),
'framvist': ('framvise',),
'framvis': ('framvise',),
'franarre': ('franarre',),
'franarrer': ('franarre',),
'franarres': ('franarre',),
'franarra': ('franarre',),
'franarret': ('franarre',),
'franarra': ('franarre',),
'franarret': ('franarre',),
'franarr': ('franarre',),
'frankere': ('frankere',),
'frankerer': ('frankere',),
'frankeres': ('frankere',),
'frankerte': ('frankere',),
'frankert': ('frankere',),
'franker': ('frankere',),
'frappere': ('frappere',),
'frapperer': ('frappere',),
'frapperes': ('frappere',),
'frapperte': ('frappere',),
'frappert': ('frappere',),
'frapper': ('frappere',),
'frarane': ('frarane',),
'fraraner': ('frarane',),
'fraranes': ('frarane',),
'frarana': ('frarane',),
'fraranet': ('frarane',),
'frarante': ('frarane',),
'frarana': ('frarane',),
'fraranet': ('frarane',),
'frarant': ('frarane',),
'fraran': ('frarane',),
'frarå': ('frarå',),
'frarår': ('frarå',),
'frarås': ('frarå',),
'frarådde': ('frarå',),
'frarådd': ('frarå',),
'frarå': ('frarå',),
'fraråde': ('fraråde',),
'fraråder': ('fraråde',),
'frarådes': ('fraråde',),
'frarådet': ('fraråde',),
'frarådde': ('fraråde',),
'frarådet': ('fraråde',),
'frarådd': ('fraråde',),
'fraråd': ('fraråde',),
'fraselge': ('fraselge',),
'fraselger': ('fraselge',),
'fraselges': ('fraselge',),
'frasolgte': ('fraselge',),
'frasolgt': ('fraselge',),
'fraselg': ('fraselge',),
'frasere': ('frasere',),
'fraserer': ('frasere',),
'fraseres': ('frasere',),
'fraserte': ('frasere',),
'frasert': ('frasere',),
'fraser': ('frasere',),
'frasi': ('frasi',),
'frasier': ('frasi',),
'frasies': ('frasi',),
'frasa': ('frasi',),
'frasagt': ('frasi',),
'frasi': ('frasi',),
'fraskille': ('fraskille',),
'fraskiller': ('fraskille',),
'fraskilles': ('fraskille',),
'fraskilte': ('fraskille',),
'fraskilt': ('fraskille',),
'fraskill': ('fraskille',),
'fraskjøte': ('fraskjøte',),
'fraskjøter': ('fraskjøte',),
'fraskjøtes': ('fraskjøte',),
'fraskjøta': ('fraskjøte',),
'fraskjøtet': ('fraskjøte',),
'fraskjøtte': ('fraskjøte',),
'fraskjøta': ('fraskjøte',),
'fraskjøtet': ('fraskjøte',),
'fraskjøtt': ('fraskjøte',),
'fraskjøt': ('fraskjøte',),
'fraskrive': ('fraskrive',),
'fraskriver': ('fraskrive',),
'fraskrives': ('fraskrive',),
'fraskrev': ('fraskrive',),
'fraskreiv': ('fraskrive',),
'fraskrev': ('fraskrive',),
'fraskreiv': ('fraskrive',),
'fraskrevet': ('fraskrive',),
'fraskriv': ('fraskrive',),
'frastjele': ('frastjele',),
'frastjeler': ('frastjele',),
'frastjeles': ('frastjele',),
'frastjal': ('frastjele',),
'frastjålet': ('frastjele',),
'frastjel': ('frastjele',),
'frastøte': ('frastøte',),
'frastøter': ('frastøte',),
'frastøtes': ('frastøte',),
'frastøtte': ('frastøte',),
'frastøtt': ('frastøte',),
'frastøt': ('frastøte',),
'frata': ('frata',),
'fratar': ('frata',),
'fratas': ('frata',),
'fratok': ('frata',),
'fratatt': ('frata',),
'frata': ('frata',),
'fraternisere': ('fraternisere',),
'fraterniserer': ('fraternisere',),
'fraterniseres': ('fraternisere',),
'fraterniserte': ('fraternisere',),
'fraternisert': ('fraternisere',),
'fraterniser': ('fraternisere',),
'fratre': ('fratre',),
'fratrer': ('fratre',),
'fratres': ('fratre',),
'fratrådte': ('fratre',),
'fratrådt': ('fratre',),
'fratre': ('fratre',),
'fravike': ('fravike',),
'fraviker': ('fravike',),
'fravikes': ('fravike',),
'fravek': ('fravike',),
'fraveik': ('fravike',),
'fravek': ('fravike',),
'fraveik': ('fravike',),
'fraveket': ('fravike',),
'fravik': ('fravike',),
'fravriste': ('fravriste',),
'fravrister': ('fravriste',),
'fravristes': ('fravriste',),
'fravrista': ('fravriste',),
'fravristet': ('fravriste',),
'fravrista': ('fravriste',),
'fravristet': ('fravriste',),
'fravrist': ('fravriste',),
'frede': ('frede',),
'freder': ('frede',),
'fredes': ('frede',),
'freda': ('frede',),
'fredet': ('frede',),
'freda': ('frede',),
'fredet': ('frede',),
'fred': ('frede',),
'frege': ('frege',),
'freger': ('frege',),
'freges': ('frege',),
'frega': ('frege',),
'freget': ('frege',),
'frega': ('frege',),
'freget': ('frege',),
'freg': ('frege',),
'frekventere': ('frekventere',),
'frekventerer': ('frekventere',),
'frekventeres': ('frekventere',),
'frekventerte': ('frekventere',),
'frekventert': ('frekventere',),
'frekventer': ('frekventere',),
'frelse': ('frelse',),
'frelser': ('frelse',),
'frelses': ('frelse',),
'frelste': ('frelse',),
'frelst': ('frelse',),
'frels': ('frelse',),
'fremdatere': ('fremdatere',),
'fremdaterer': ('fremdatere',),
'fremdateres': ('fremdatere',),
'fremdaterte': ('fremdatere',),
'fremdatert': ('fremdatere',),
'fremdater': ('fremdatere',),
'fremelske': ('fremelske',),
'fremelsker': ('fremelske',),
'fremelskes': ('fremelske',),
'fremelska': ('fremelske',),
'fremelsket': ('fremelske',),
'fremelska': ('fremelske',),
'fremelsket': ('fremelske',),
'fremelsk': ('fremelske',),
'fremføre': ('fremføre',),
'fremfører': ('fremføre',),
'fremføres': ('fremføre',),
'fremførte': ('fremføre',),
'fremført': ('fremføre',),
'fremfør': ('fremføre',),
'fremgå': ('fremgå',),
'fremgår': ('fremgå',),
'fremgås': ('fremgå',),
'fremgikk': ('fremgå',),
'fremgått': ('fremgå',),
'fremgå': ('fremgå',),
'fremheve': ('fremheve',),
'fremhever': ('fremheve',),
'fremheves': ('fremheve',),
'fremheva': ('fremheve',),
'fremhevet': ('fremheve',),
'fremhevde': ('fremheve',),
'fremheva': ('fremheve',),
'fremhevet': ('fremheve',),
'fremhevd': ('fremheve',),
'fremhev': ('fremheve',),
'fremholde': ('fremholde',),
'fremholder': ('fremholde',),
'fremholdes': ('fremholde',),
'fremholdt': ('fremholde',),
'fremhold': ('fremholde',),
'fremkalle': ('fremkalle',),
'fremkaller': ('fremkalle',),
'fremkalles': ('fremkalle',),
'fremkalte': ('fremkalle',),
'fremkalt': ('fremkalle',),
'fremkall': ('fremkalle',),
'fremkaste': ('fremkaste',),
'fremkaster': ('fremkaste',),
'fremkastes': ('fremkaste',),
'fremkasta': ('fremkaste',),
'fremkastet': ('fremkaste',),
'fremkasta': ('fremkaste',),
'fremkastet': ('fremkaste',),
'fremkast': ('fremkaste',),
'fremlegge': ('fremlegge',),
'fremlegger': ('fremlegge',),
'fremlegges': ('fremlegge',),
'fremla': ('fremlegge',),
'fremlagt': ('fremlegge',),
'fremlegg': ('fremlegge',),
'fremleie': ('fremleie',),
'fremleier': ('fremleie',),
'fremleies': ('fremleie',),
'fremleide': ('fremleie',),
'fremleid': ('fremleie',),
'fremlei': ('fremleie',),
'fremme': ('fremme',),
'fremmer': ('fremme',),
'fremmes': ('fremme',),
'fremma': ('fremme',),
'fremmet': ('fremme',),
'fremma': ('fremme',),
'fremmet': ('fremme',),
'frem': ('fremme',),
'fremmedgjøre': ('fremmedgjøre',),
'fremmedgjør': ('fremmedgjøre',),
'fremmedgjøres': ('fremmedgjøre',),
'fremmedgjorde': ('fremmedgjøre',),
'fremmedgjort': ('fremmedgjøre',),
'fremmedgjør': ('fremmedgjøre',),
'fremsette': ('fremsette',),
'fremsetter': ('fremsette',),
'fremsettes': ('fremsette',),
'fremsatte': ('fremsette',),
'fremsatt': ('fremsette',),
'fremsett': ('fremsette',),
'fremsi': ('fremsi',),
'fremsier': ('fremsi',),
'fremsies': ('fremsi',),
'fremsa': ('fremsi',),
'fremsagt': ('fremsi',),
'fremsi': ('fremsi',),
'fremskaffe': ('fremskaffe',),
'fremskaffer': ('fremskaffe',),
'fremskaffes': ('fremskaffe',),
'fremskaffa': ('fremskaffe',),
'fremskaffet': ('fremskaffe',),
'fremskaffa': ('fremskaffe',),
'fremskaffet': ('fremskaffe',),
'fremskaff': ('fremskaffe',),
'fremskrive': ('fremskrive',),
'fremskriver': ('fremskrive',),
'fremskrives': ('fremskrive',),
'fremskrev': ('fremskrive',),
'fremskreiv': ('fremskrive',),
'fremskrev': ('fremskrive',),
'fremskreiv': ('fremskrive',),
'fremskrevet': ('fremskrive',),
'fremskriv': ('fremskrive',),
'fremskynde': ('fremskynde',),
'fremskynder': ('fremskynde',),
'fremskyndes': ('fremskynde',),
'fremskynda': ('fremskynde',),
'fremskyndet': ('fremskynde',),
'fremskyndte': ('fremskynde',),
'fremskynda': ('fremskynde',),
'fremskyndet': ('fremskynde',),
'fremskyndt': ('fremskynde',),
'fremskynd': ('fremskynde',),
'fremskyte': ('fremskyte',),
'fremskyter': ('fremskyte',),
'fremskytes': ('fremskyte',),
'fremskjøt': ('fremskyte',),
'fremskøyt': ('fremskyte',),
'fremskutt': ('fremskyte',),
'fremskyt': ('fremskyte',),
'fremstille': ('fremstille',),
'fremstiller': ('fremstille',),
'fremstilles': ('fremstille',),
'fremstilte': ('fremstille',),
'fremstilt': ('fremstille',),
'fremstill': ('fremstille',),
'fremstå': ('fremstå',),
'fremstår': ('fremstå',),
'fremstås': ('fremstå',),
'fremsto': ('fremstå',),
'fremstod': ('fremstå',),
'fremstått': ('fremstå',),
'fremstå': ('fremstå',),
'fremvise': ('fremvise',),
'fremviser': ('fremvise',),
'fremvises': ('fremvise',),
'fremviste': ('fremvise',),
'fremvist': ('fremvise',),
'fremvis': ('fremvise',),
'frese': ('frese',),
'freser': ('frese',),
'freses': ('frese',),
'freste': ('frese',),
'frest': ('frese',),
'fres': ('frese',),
'freste': ('freste',),
'frester': ('freste',),
'frestes': ('freste',),
'fresta': ('freste',),
'frestet': ('freste',),
'fresta': ('freste',),
'frestet': ('freste',),
'frest': ('freste',),
'frette': ('frette',),
'fretter': ('frette',),
'frettes': ('frette',),
'fretta': ('frette',),
'frettet': ('frette',),
'fretta': ('frette',),
'frettet': ('frette',),
'frett': ('frette',),
'fri': ('fri',),
'frir': ('fri',),
'fris': ('fri',),
'fridde': ('fri',),
'fridd': ('fri',),
'fri': ('fri',),
'frigi': ('frigi',),
'frigir': ('frigi',),
'frigis': ('frigi',),
'frigav': ('frigi',),
'friga': ('frigi',),
'frigitt': ('frigi',),
'frigi': ('frigi',),
'frigjøre': ('frigjøre',),
'frigjør': ('frigjøre',),
'frigjøres': ('frigjøre',),
'frigjorde': ('frigjøre',),
'frigjort': ('frigjøre',),
'frigjør': ('frigjøre',),
'frikjenne': ('frikjenne',),
'frikjenner': ('frikjenne',),
'frikjennes': ('frikjenne',),
'frikjente': ('frikjenne',),
'frikjent': ('frikjenne',),
'frikjenn': ('frikjenne',),
'frilanse': ('frilanse',),
'frilanser': ('frilanse',),
'frilanses': ('frilanse',),
'frilansa': ('frilanse',),
'frilanset': ('frilanse',),
'frilansa': ('frilanse',),
'frilanset': ('frilanse',),
'frilans': ('frilanse',),
'friliste': ('friliste',),
'frilister': ('friliste',),
'frilistes': ('friliste',),
'frilista': ('friliste',),
'frilistet': ('friliste',),
'frilista': ('friliste',),
'frilistet': ('friliste',),
'frilist': ('friliste',),
'frisere': ('frisere',),
'friserer': ('frisere',),
'friseres': ('frisere',),
'friserte': ('frisere',),
'frisert': ('frisere',),
'friser': ('frisere',),
'friske': ('friske',),
'frisker': ('friske',),
'friskes': ('friske',),
'friska': ('friske',),
'frisket': ('friske',),
'friska': ('friske',),
'frisket': ('friske',),
'frisk': ('friske',),
'friskmelde': ('friskmelde',),
'friskmelder': ('friskmelde',),
'friskmeldes': ('friskmelde',),
'friskmeldte': ('friskmelde',),
'friskmeldt': ('friskmelde',),
'friskmeld': ('friskmelde',),
'friskne': ('friskne',),
'friskner': ('friskne',),
'frisknes': ('friskne',),
'friskna': ('friskne',),
'frisknet': ('friskne',),
'friskna': ('friskne',),
'frisknet': ('friskne',),
'friskn': ('friskne',),
'friskne': ('friskne',),
'friskn': ('friskne',),
'friskne': ('friskne',),
'friste': ('friste',),
'frister': ('friste',),
'fristes': ('friste',),
'frista': ('friste',),
'fristet': ('friste',),
'frista': ('friste',),
'fristet': ('friste',),
'frist': ('friste',),
'frita': ('frita',),
'fritar': ('frita',),
'fritas': ('frita',),
'fritok': ('frita',),
'fritatt': ('frita',),
'frita': ('frita',),
'fritere': ('fritere',),
'friterer': ('fritere',),
'friteres': ('fritere',),
'friterte': ('fritere',),
'fritert': ('fritere',),
'friter': ('fritere',),
'fritte': ('fritte',),
'fritter': ('fritte',),
'frittes': ('fritte',),
'fritta': ('fritte',),
'frittet': ('fritte',),
'fritta': ('fritte',),
'frittet': ('fritte',),
'fritt': ('fritte',),
'frondere': ('frondere',),
'fronderer': ('frondere',),
'fronderes': ('frondere',),
'fronderte': ('frondere',),
'frondert': ('frondere',),
'fronder': ('frondere',),
'frottere': ('frottere',),
'frotterer': ('frottere',),
'frotteres': ('frottere',),
'frotterte': ('frottere',),
'frottert': ('frottere',),
'frotter': ('frottere',),
'frukte': ('frukte',),
'frukter': ('frukte',),
'fruktes': ('frukte',),
'frukta': ('frukte',),
'fruktet': ('frukte',),
'frukta': ('frukte',),
'fruktet': ('frukte',),
'frukt': ('frukte',),
'frustrere': ('frustrere',),
'frustrerer': ('frustrere',),
'frustreres': ('frustrere',),
'frustrerte': ('frustrere',),
'frustrert': ('frustrere',),
'frustrer': ('frustrere',),
'fryde': ('fryde',),
'fryder': ('fryde',),
'frydes': ('fryde',),
'fryda': ('fryde',),
'frydet': ('fryde',),
'fryda': ('fryde',),
'frydet': ('fryde',),
'fryd': ('fryde',),
'frykte': ('frykte',),
'frykter': ('frykte',),
'fryktes': ('frykte',),
'frykta': ('frykte',),
'fryktet': ('frykte',),
'frykta': ('frykte',),
'fryktet': ('frykte',),
'frykt': ('frykte',),
'frynse': ('frynse',),
'frynser': ('frynse',),
'frynses': ('frynse',),
'frynsa': ('frynse',),
'frynset': ('frynse',),
'frynsa': ('frynse',),
'frynset': ('frynse',),
'fryns': ('frynse',),
'fråde': ('fråde',),
'fråder': ('fråde',),
'frådes': ('fråde',),
'fråda': ('fråde',),
'frådet': ('fråde',),
'fråda': ('fråde',),
'frådet': ('fråde',),
'fråd': ('fråde',),
'fråsse': ('fråsse',),
'fråsser': ('fråsse',),
'fråsses': ('fråsse',),
'fråssa': ('fråsse',),
'fråsset': ('fråsse',),
'fråssa': ('fråsse',),
'fråsset': ('fråsse',),
'fråss': ('fråsse',),
'fråtse': ('fråtse',),
'fråtser': ('fråtse',),
'fråtses': ('fråtse',),
'fråtsa': ('fråtse',),
'fråtset': ('fråtse',),
'fråtsa': ('fråtse',),
'fråtset': ('fråtse',),
'fråts': ('fråtse',),
'frø': ('frø',),
'frør': ('frø',),
'frøs': ('frø',),
'frødde': ('frø',),
'frødd': ('frø',),
'frø': ('frø',),
'frøse': ('frøse',),
'frøser': ('frøse',),
'frøses': ('frøse',),
'frøste': ('frøse',),
'frøst': ('frøse',),
'frøs': ('frøse',),
'fuge': ('fuge',),
'fuger': ('fuge',),
'fuges': ('fuge',),
'fuga': ('fuge',),
'fuget': ('fuge',),
'fuga': ('fuge',),
'fuget': ('fuge',),
'fug': ('fuge',),
'fukte': ('fukte',),
'fukter': ('fukte',),
'fuktes': ('fukte',),
'fukta': ('fukte',),
'fuktet': ('fukte',),
'fukta': ('fukte',),
'fuktet': ('fukte',),
'fukt': ('fukte',),
'fullbringe': ('fullbringe',),
'fullbringer': ('fullbringe',),
'fullbringes': ('fullbringe',),
'fullbrakte': ('fullbringe',),
'fullbrakt': ('fullbringe',),
'fullbring': ('fullbringe',),
'fullbyrde': ('fullbyrde',),
'fullbyrder': ('fullbyrde',),
'fullbyrdes': ('fullbyrde',),
'fullbyrda': ('fullbyrde',),
'fullbyrdet': ('fullbyrde',),
'fullbyrda': ('fullbyrde',),
'fullbyrdet': ('fullbyrde',),
'fullbyrd': ('fullbyrde',),
'fullende': ('fullende',),
'fullender': ('fullende',),
'fullendes': ('fullende',),
'fullendte': ('fullende',),
'fullendt': ('fullende',),
'fullend': ('fullende',),
'fullføre': ('fullføre',),
'fullfører': ('fullføre',),
'fullføres': ('fullføre',),
'fullførte': ('fullføre',),
'fullført': ('fullføre',),
'fullfør': ('fullføre',),
'fullrose': ('fullrose',),
'fullroser': ('fullrose',),
'fullroses': ('fullrose',),
'fullroste': ('fullrose',),
'fullrost': ('fullrose',),
'fullros': ('fullrose',),
'fulltakke': ('fulltakke',),
'fulltakker': ('fulltakke',),
'fulltakkes': ('fulltakke',),
'fulltakka': ('fulltakke',),
'fulltakket': ('fulltakke',),
'fulltakka': ('fulltakke',),
'fulltakket': ('fulltakke',),
'fulltakk': ('fulltakke',),
'fundamentere': ('fundamentere',),
'fundamenterer': ('fundamentere',),
'fundamenteres': ('fundamentere',),
'fundamenterte': ('fundamentere',),
'fundamentert': ('fundamentere',),
'fundamenter': ('fundamentere',),
'fundere': ('fundere',),
'funderer': ('fundere',),
'funderes': ('fundere',),
'funderte': ('fundere',),
'fundert': ('fundere',),
'funder': ('fundere',),
'fungere': ('fungere',),
'fungerer': ('fungere',),
'fungeres': ('fungere',),
'fungerte': ('fungere',),
'fungert': ('fungere',),
'funger': ('fungere',),
'funkle': ('funkle',),
'funkler': ('funkle',),
'funkles': ('funkle',),
'funkla': ('funkle',),
'funklet': ('funkle',),
'funkla': ('funkle',),
'funklet': ('funkle',),
'funkl': ('funkle',),
'funkle': ('funkle',),
'funkl': ('funkle',),
'funkle': ('funkle',),
'funksjonere': ('funksjonere',),
'funksjonerer': ('funksjonere',),
'funksjoneres': ('funksjonere',),
'funksjonerte': ('funksjonere',),
'funksjonert': ('funksjonere',),
'funksjoner': ('funksjonere',),
'furasjere': ('furasjere',),
'furasjerer': ('furasjere',),
'furasjeres': ('furasjere',),
'furasjerte': ('furasjere',),
'furasjert': ('furasjere',),
'furasjer': ('furasjere',),
'fure': ('fure',),
'furer': ('fure',),
'fures': ('fure',),
'fura': ('fure',),
'furet': ('fure',),
'furte': ('fure',),
'fura': ('fure',),
'furet': ('fure',),
'furt': ('fure',),
'fur': ('fure',),
'furnere': ('furnere',),
'furnerer': ('furnere',),
'furneres': ('furnere',),
'furnerte': ('furnere',),
'furnert': ('furnere',),
'furner': ('furnere',),
'furte': ('furte',),
'furter': ('furte',),
'furtes': ('furte',),
'furta': ('furte',),
'furtet': ('furte',),
'furta': ('furte',),
'furtet': ('furte',),
'furt': ('furte',),
'fuse': ('fuse',),
'fuser': ('fuse',),
'fuses': ('fuse',),
'fuste': ('fuse',),
'fust': ('fuse',),
'fus': ('fuse',),
'fusjonere': ('fusjonere',),
'fusjonerer': ('fusjonere',),
'fusjoneres': ('fusjonere',),
'fusjonerte': ('fusjonere',),
'fusjonert': ('fusjonere',),
'fusjoner': ('fusjonere',),
'fuske': ('fuske',),
'fusker': ('fuske',),
'fuskes': ('fuske',),
'fuska': ('fuske',),
'fusket': ('fuske',),
'fuska': ('fuske',),
'fusket': ('fuske',),
'fusk': ('fuske',),
'futte': ('futte',),
'futter': ('futte',),
'futtes': ('futte',),
'futta': ('futte',),
'futtet': ('futte',),
'futta': ('futte',),
'futtet': ('futte',),
'futt': ('futte',),
'fyke': ('fyke',),
'fyker': ('fyke',),
'fykes': ('fyke',),
'føyk': ('fyke',),
'føk': ('fyke',),
'føket': ('fyke',),
'fyk': ('fyke',),
'fylke': ('fylke',),
'fylker': ('fylke',),
'fylkes': ('fylke',),
'fylka': ('fylke',),
'fylket': ('fylke',),
'fylkte': ('fylke',),
'fylka': ('fylke',),
'fylket': ('fylke',),
'fylkt': ('fylke',),
'fylk': ('fylke',),
'fylle': ('fylle',),
'fyller': ('fylle',),
'fylles': ('fylle',),
'fylla': ('fylle',),
'fyllet': ('fylle',),
'fylla': ('fylle',),
'fyllet': ('fylle',),
'fyll': ('fylle',),
'fylle': ('fylle',),
'fyller': ('fylle',),
'fylles': ('fylle',),
'fylte': ('fylle',),
'fylt': ('fylle',),
'fyll': ('fylle',),
'fyllekjøre': ('fyllekjøre',),
'fyllekjører': ('fyllekjøre',),
'fyllekjøres': ('fyllekjøre',),
'fyllekjørte': ('fyllekjøre',),
'fyllekjørt': ('fyllekjøre',),
'fyllekjør': ('fyllekjøre',),
'fyre': ('fyre',),
'fyrer': ('fyre',),
'fyres': ('fyre',),
'fyrte': ('fyre',),
'fyrt': ('fyre',),
'fyr': ('fyre',),
'fyse': ('fyse',),
'fyser': ('fyse',),
'fyses': ('fyse',),
'fyste': ('fyse',),
'fyst': ('fyse',),
'fys': ('fyse',),
'få': ('få',),
'får': ('få',),
'fås': ('få',),
'fikk': ('få',),
'fått': ('få',),
'få': ('få',),
'fæle': ('fæle',),
'fæler': ('fæle',),
'fæles': ('fæle',),
'fælte': ('fæle',),
'fælt': ('fæle',),
'fæl': ('fæle',),
'fø': ('fø',),
'før': ('fø',),
'føs': ('fø',),
'fødde': ('fø',),
'fødd': ('fø',),
'fø': ('fø',),
'føde': ('føde',),
'føder': ('føde',),
'fødes': ('føde',),
'fødte': ('føde',),
'født': ('føde',),
'fød': ('føde',),
'føle': ('føle',),
'føler': ('føle',),
'føles': ('føle',),
'følte': ('føle',),
'følt': ('føle',),
'føl': ('føle',),
'følle': ('følle',),
'føller': ('følle',),
'følles': ('følle',),
'følla': ('følle',),
'føllet': ('følle',),
'følla': ('følle',),
'føllet': ('følle',),
'føll': ('følle',),
'føne': ('føne',),
'føner': ('føne',),
'fønes': ('føne',),
'føna': ('føne',),
'fønet': ('føne',),
'fønte': ('føne',),
'føna': ('føne',),
'fønet': ('føne',),
'fønt': ('føne',),
'føn': ('føne',),
'føre': ('føre',),
'fører': ('føre',),
'føres': ('føre',),
'førte': ('føre',),
'ført': ('føre',),
'før': ('føre',),
'førebu': ('førebu',),
'førebur': ('førebu',),
'førebus': ('førebu',),
'førebudde': ('førebu',),
'førebudd': ('førebu',),
'førebu': ('førebu',),
'førtidspensjonere': ('førtidspensjonere',),
'førtidspensjonerer': ('førtidspensjonere',),
'førtidspensjoneres': ('førtidspensjonere',),
'førtidspensjonerte': ('førtidspensjonere',),
'førtidspensjonert': ('førtidspensjonere',),
'førtidspensjoner': ('førtidspensjonere',),
'føye': ('føye',),
'føyer': ('føye',),
'føyes': ('føye',),
'føyet': ('føye',),
'føyde': ('føye',),
'føyet': ('føye',),
'føyd': ('føye',),
'føy': ('føye',),
'føyke': ('føyke',),
'føyker': ('føyke',),
'føykes': ('føyke',),
'føyka': ('føyke',),
'føyket': ('føyke',),
'føykte': ('føyke',),
'føyka': ('føyke',),
'føyket': ('føyke',),
'føykt': ('føyke',),
'føyk': ('føyke',),
'føyse': ('føyse',),
'føyser': ('føyse',),
'føyses': ('føyse',),
'føyste': ('føyse',),
'føyst': ('føyse',),
'føys': ('føyse',),
'gafle': ('gafle',),
'gafler': ('gafle',),
'gafles': ('gafle',),
'gafla': ('gafle',),
'gaflet': ('gafle',),
'gafla': ('gafle',),
'gaflet': ('gafle',),
'gafl': ('gafle',),
'gafle': ('gafle',),
'gafl': ('gafle',),
'gafle': ('gafle',),
'gagne': ('gagne',),
'gagner': ('gagne',),
'gagnes': ('gagne',),
'gagna': ('gagne',),
'gagnet': ('gagne',),
'gagna': ('gagne',),
'gagnet': ('gagne',),
'gagn': ('gagne',),
'gakke': ('gakke',),
'gakker': ('gakke',),
'gakkes': ('gakke',),
'gakka': ('gakke',),
'gakket': ('gakke',),
'gakka': ('gakke',),
'gakket': ('gakke',),
'gakk': ('gakke',),
'galdre': ('galdre',),
'galdrer': ('galdre',),
'galdres': ('galdre',),
'galdra': ('galdre',),
'galdret': ('galdre',),
'galdra': ('galdre',),
'galdret': ('galdre',),
'galdr': ('galdre',),
'galdre': ('galdre',),
'galdr': ('galdre',),
'galdre': ('galdre',),
'gale': ('gale',),
'galer': ('gale',),
'gales': ('gale',),
'galte': ('gale',),
'gol': ('gale',),
'galt': ('gale',),
'gal': ('gale',),
'galoppere': ('galoppere',),
'galopperer': ('galoppere',),
'galopperes': ('galoppere',),
'galopperte': ('galoppere',),
'galoppert': ('galoppere',),
'galopper': ('galoppere',),
'galvanisere': ('galvanisere',),
'galvaniserer': ('galvanisere',),
'galvaniseres': ('galvanisere',),
'galvaniserte': ('galvanisere',),
'galvanisert': ('galvanisere',),
'galvaniser': ('galvanisere',),
'gamble': ('gamble',),
'gambler': ('gamble',),
'gambles': ('gamble',),
'gambla': ('gamble',),
'gamblet': ('gamble',),
'gambla': ('gamble',),
'gamblet': ('gamble',),
'gambl': ('gamble',),
'gamble': ('gamble',),
'gambl': ('gamble',),
'gamble': ('gamble',),
'gande': ('gande',),
'gander': ('gande',),
'gandes': ('gande',),
'ganda': ('gande',),
'gandet': ('gande',),
'ganda': ('gande',),
'gandet': ('gande',),
'gand': ('gande',),
'gane': ('gane',),
'ganer': ('gane',),
'ganes': ('gane',),
'gana': ('gane',),
'ganet': ('gane',),
'gante': ('gane',),
'gana': ('gane',),
'ganet': ('gane',),
'gant': ('gane',),
'gan': ('gane',),
'gange': ('gange',),
'ganger': ('gange',),
'ganges': ('gange',),
'ganga': ('gange',),
'ganget': ('gange',),
'ganga': ('gange',),
'ganget': ('gange',),
'gang': ('gange',),
'gante': ('gante',),
'ganter': ('gante',),
'gantes': ('gante',),
'ganta': ('gante',),
'gantet': ('gante',),
'ganta': ('gante',),
'gantet': ('gante',),
'gant': ('gante',),
'gantes': ('gantes',),
'gantedes': ('gantes',),
'gantes': ('gantes',),
'gape': ('gape',),
'gaper': ('gape',),
'gapes': ('gape',),
'gapa': ('gape',),
'gapte': ('gape',),
'gapa': ('gape',),
'gapt': ('gape',),
'gap': ('gape',),
'gapskratte': ('gapskratte',),
'gapskratter': ('gapskratte',),
'gapskrattes': ('gapskratte',),
'gapskratta': ('gapskratte',),
'gapskrattet': ('gapskratte',),
'gapskratta': ('gapskratte',),
'gapskrattet': ('gapskratte',),
'gapskratt': ('gapskratte',),
'garantere': ('garantere',),
'garanterer': ('garantere',),
'garanteres': ('garantere',),
'garanterte': ('garantere',),
'garantert': ('garantere',),
'garanter': ('garantere',),
'gardere': ('gardere',),
'garderer': ('gardere',),
'garderes': ('gardere',),
'garderte': ('gardere',),
'gardert': ('gardere',),
'garder': ('gardere',),
'garne': ('garne',),
'garner': ('garne',),
'garnes': ('garne',),
'garna': ('garne',),
'garnet': ('garne',),
'garna': ('garne',),
'garnet': ('garne',),
'garn': ('garne',),
'garnere': ('garnere',),
'garnerer': ('garnere',),
'garneres': ('garnere',),
'garnerte': ('garnere',),
'garnert': ('garnere',),
'garner': ('garnere',),
'garnisonere': ('garnisonere',),
'garnisonerer': ('garnisonere',),
'garnisoneres': ('garnisonere',),
'garnisonerte': ('garnisonere',),
'garnisonert': ('garnisonere',),
'garnisoner': ('garnisonere',),
'garpe': ('garpe',),
'garper': ('garpe',),
'garpes': ('garpe',),
'garpa': ('garpe',),
'garpet': ('garpe',),
'garpa': ('garpe',),
'garpet': ('garpe',),
'garp': ('garpe',),
'garve': ('garve',),
'garver': ('garve',),
'garves': ('garve',),
'garva': ('garve',),
'garvet': ('garve',),
'garva': ('garve',),
'garvet': ('garve',),
'garv': ('garve',),
'gasjere': ('gasjere',),
'gasjerer': ('gasjere',),
'gasjeres': ('gasjere',),
'gasjerte': ('gasjere',),
'gasjert': ('gasjere',),
'gasjer': ('gasjere',),
'gasse': ('gasse',),
'gasser': ('gasse',),
'gasses': ('gasse',),
'gassa': ('gasse',),
'gasset': ('gasse',),
'gassa': ('gasse',),
'gasset': ('gasse',),
'gass': ('gasse',),
'gauke': ('gauke',),
'gauker': ('gauke',),
'gaukes': ('gauke',),
'gauka': ('gauke',),
'gauket': ('gauke',),
'gauka': ('gauke',),
'gauket': ('gauke',),
'gauk': ('gauke',),
'gaule': ('gaule',),
'gauler': ('gaule',),
'gaules': ('gaule',),
'gaula': ('gaule',),
'gaulet': ('gaule',),
'gaulte': ('gaule',),
'gaula': ('gaule',),
'gaulet': ('gaule',),
'gault': ('gaule',),
'gaul': ('gaule',),
'gaume': ('gaume',),
'gaumer': ('gaume',),
'gaumes': ('gaume',),
'gauma': ('gaume',),
'gaumet': ('gaume',),
'gauma': ('gaume',),
'gaumet': ('gaume',),
'gaum': ('gaume',),
'geberde': ('geberde',),
'geberder': ('geberde',),
'geberdes': ('geberde',),
'geberda': ('geberde',),
'geberdet': ('geberde',),
'geberda': ('geberde',),
'geberdet': ('geberde',),
'geberd': ('geberde',),
'geipe': ('geipe',),
'geiper': ('geipe',),
'geipes': ('geipe',),
'geipa': ('geipe',),
'geipet': ('geipe',),
'geipte': ('geipe',),
'geipa': ('geipe',),
'geipet': ('geipe',),
'geipt': ('geipe',),
'geip': ('geipe',),
'geleide': ('geleide',),
'geleider': ('geleide',),
'geleides': ('geleide',),
'geleida': ('geleide',),
'geleidet': ('geleide',),
'geleida': ('geleide',),
'geleidet': ('geleide',),
'geleid': ('geleide',),
'geminere': ('geminere',),
'geminerer': ('geminere',),
'gemineres': ('geminere',),
'geminerte': ('geminere',),
'geminert': ('geminere',),
'geminer': ('geminere',),
'generalisere': ('generalisere',),
'generaliserer': ('generalisere',),
'generaliseres': ('generalisere',),
'generaliserte': ('generalisere',),
'generalisert': ('generalisere',),
'generaliser': ('generalisere',),
'generere': ('generere',),
'genererer': ('generere',),
'genereres': ('generere',),
'genererte': ('generere',),
'generert': ('generere',),
'generer': ('generere',),
'genierklære': ('genierklære',),
'genierklærer': ('genierklære',),
'genierklæres': ('genierklære',),
'genierklærte': ('genierklære',),
'genierklært': ('genierklære',),
'genierklær': ('genierklære',),
'gerere': ('gerere',),
'gererer': ('gerere',),
'gereres': ('gerere',),
'gererte': ('gerere',),
'gerert': ('gerere',),
'gerer': ('gerere',),
'germanisere': ('germanisere',),
'germaniserer': ('germanisere',),
'germaniseres': ('germanisere',),
'germaniserte': ('germanisere',),
'germanisert': ('germanisere',),
'germaniser': ('germanisere',),
'geråde': ('geråde',),
'geråder': ('geråde',),
'gerådes': ('geråde',),
'geråda': ('geråde',),
'gerådet': ('geråde',),
'geråda': ('geråde',),
'gerådet': ('geråde',),
'geråd': ('geråde',),
'gestalte': ('gestalte',),
'gestalter': ('gestalte',),
'gestaltes': ('gestalte',),
'gestalta': ('gestalte',),
'gestaltet': ('gestalte',),
'gestalta': ('gestalte',),
'gestaltet': ('gestalte',),
'gestalt': ('gestalte',),
'gestikulere': ('gestikulere',),
'gestikulerer': ('gestikulere',),
'gestikuleres': ('gestikulere',),
'gestikulerte': ('gestikulere',),
'gestikulert': ('gestikulere',),
'gestikuler': ('gestikulere',),
'gi': ('gi',),
'gir': ('gi',),
'gis': ('gi',),
'gav': ('gi',),
'ga': ('gi',),
'gitt': ('gi',),
'gi': ('gi',),
'gidde': ('gidde',),
'gidder': ('gidde',),
'giddes': ('gidde',),
'gadd': ('gidde',),
'giddet': ('gidde',),
'gidd': ('gidde',),
'gifte': ('gifte',),
'gifter': ('gifte',),
'giftes': ('gifte',),
'gifta': ('gifte',),
'giftet': ('gifte',),
'gifta': ('gifte',),
'giftet': ('gifte',),
'gift': ('gifte',),
'gigge': ('gigge',),
'gigger': ('gigge',),
'gigges': ('gigge',),
'gigga': ('gigge',),
'gigget': ('gigge',),
'gigga': ('gigge',),
'gigget': ('gigge',),
'gigg': ('gigge',),
'gildre': ('gildre',),
'gildrer': ('gildre',),
'gildres': ('gildre',),
'gildra': ('gildre',),
'gildret': ('gildre',),
'gildra': ('gildre',),
'gildret': ('gildre',),
'gildr': ('gildre',),
'gildre': ('gildre',),
'gildr': ('gildre',),
'gildre': ('gildre',),
'giljotinere': ('giljotinere',),
'giljotinerer': ('giljotinere',),
'giljotineres': ('giljotinere',),
'giljotinerte': ('giljotinere',),
'giljotinert': ('giljotinere',),
'giljotiner': ('giljotinere',),
'gimpe': ('gimpe',),
'gimper': ('gimpe',),
'gimpes': ('gimpe',),
'gimpa': ('gimpe',),
'gimpet': ('gimpe',),
'gimpa': ('gimpe',),
'gimpet': ('gimpe',),
'gimp': ('gimpe',),
'gipse': ('gipse',),
'gipser': ('gipse',),
'gipses': ('gipse',),
'gipsa': ('gipse',),
'gipset': ('gipse',),
'gipste': ('gipse',),
'gipsa': ('gipse',),
'gipset': ('gipse',),
'gipst': ('gipse',),
'gips': ('gipse',),
'girere': ('girere',),
'girerer': ('girere',),
'gireres': ('girere',),
'girerte': ('girere',),
'girert': ('girere',),
'girer': ('girere',),
'gisne': ('gisne',),
'gisner': ('gisne',),
'gisnes': ('gisne',),
'gisna': ('gisne',),
'gisnet': ('gisne',),
'gisna': ('gisne',),
'gisnet': ('gisne',),
'gisn': ('gisne',),
'gispe': ('gispe',),
'gisper': ('gispe',),
'gispes': ('gispe',),
'gispa': ('gispe',),
'gispet': ('gispe',),
'gispa': ('gispe',),
'gispet': ('gispe',),
'gisp': ('gispe',),
'gisse': ('gisse',),
'gisser': ('gisse',),
'gisses': ('gisse',),
'gissa': ('gisse',),
'gisset': ('gisse',),
'gissa': ('gisse',),
'gisset': ('gisse',),
'giss': ('gisse',),
'gitre': ('gitre',),
'gitrer': ('gitre',),
'gitres': ('gitre',),
'gitra': ('gitre',),
'gitret': ('gitre',),
'gitra': ('gitre',),
'gitret': ('gitre',),
'gitr': ('gitre',),
'gitre': ('gitre',),
'gitr': ('gitre',),
'gitre': ('gitre',),
'gjalle': ('gjalle',),
'gjaller': ('gjalle',),
'gjalles': ('gjalle',),
'gjalla': ('gjalle',),
'gjallet': ('gjalle',),
'gjalla': ('gjalle',),
'gjallet': ('gjalle',),
'gjall': ('gjalle',),
'gjekke': ('gjekke',),
'gjekker': ('gjekke',),
'gjekkes': ('gjekke',),
'gjekka': ('gjekke',),
'gjekket': ('gjekke',),
'gjekka': ('gjekke',),
'gjekket': ('gjekke',),
'gjekk': ('gjekke',),
'gjelde': ('gjelde',),
'gjelder': ('gjelde',),
'gjeldes': ('gjelde',),
'gjelda': ('gjelde',),
'gjeldet': ('gjelde',),
'gjeldte': ('gjelde',),
'gjelda': ('gjelde',),
'gjeldet': ('gjelde',),
'gjeldt': ('gjelde',),
'gjeld': ('gjelde',),
'gjelde': ('gjelde',),
'gjelder': ('gjelde',),
'gjelds': ('gjelde',),
'gjaldt': ('gjelde',),
'gjeldt': ('gjelde',),
'gjeld': ('gjelde',),
'gjelle': ('gjelle',),
'gjeller': ('gjelle',),
'gjelles': ('gjelle',),
'gjelte': ('gjelle',),
'gjelt': ('gjelle',),
'gjell': ('gjelle',),
'gjemme': ('gjemme',),
'gjemmer': ('gjemme',),
'gjemmes': ('gjemme',),
'gjemte': ('gjemme',),
'gjemt': ('gjemme',),
'gjem': ('gjemme',),
'gjenbruke': ('gjenbruke',),
'gjenbruker': ('gjenbruke',),
'gjenbrukes': ('gjenbruke',),
'gjenbrukte': ('gjenbruke',),
'gjenbrukt': ('gjenbruke',),
'gjenbruk': ('gjenbruke',),
'gjenerobre': ('gjenerobre',),
'gjenerobrer': ('gjenerobre',),
'gjenerobres': ('gjenerobre',),
'gjenerobra': ('gjenerobre',),
'gjenerobret': ('gjenerobre',),
'gjenerobra': ('gjenerobre',),
'gjenerobret': ('gjenerobre',),
'gjenerobr': ('gjenerobre',),
'gjenerobre': ('gjenerobre',),
'gjenerobr': ('gjenerobre',),
'gjenerobre': ('gjenerobre',),
'gjenforene': ('gjenforene',),
'gjenforener': ('gjenforene',),
'gjenforenes': ('gjenforene',),
'gjenforenet': ('gjenforene',),
'gjenforente': ('gjenforene',),
'gjenforenet': ('gjenforene',),
'gjenforent': ('gjenforene',),
'gjenforen': ('gjenforene',),
'gjenforsikre': ('gjenforsikre',),
'gjenforsikrer': ('gjenforsikre',),
'gjenforsikres': ('gjenforsikre',),
'gjenforsikra': ('gjenforsikre',),
'gjenforsikret': ('gjenforsikre',),
'gjenforsikra': ('gjenforsikre',),
'gjenforsikret': ('gjenforsikre',),
'gjenforsikr': ('gjenforsikre',),
'gjenforsikre': ('gjenforsikre',),
'gjenforsikr': ('gjenforsikre',),
'gjenforsikre': ('gjenforsikre',),
'gjenge': ('gjenge',),
'gjenger': ('gjenge',),
'gjenges': ('gjenge',),
'gjenga': ('gjenge',),
'gjenget': ('gjenge',),
'gjenga': ('gjenge',),
'gjenget': ('gjenge',),
'gjeng': ('gjenge',),
'gjengi': ('gjengi',),
'gjengir': ('gjengi',),
'gjengis': ('gjengi',),
'gjengav': ('gjengi',),
'gjenga': ('gjengi',),
'gjengitt': ('gjengi',),
'gjengi': ('gjengi',),
'gjengifte': ('gjengifte',),
'gjengifter': ('gjengifte',),
'gjengiftes': ('gjengifte',),
'gjengifta': ('gjengifte',),
'gjengiftet': ('gjengifte',),
'gjengifta': ('gjengifte',),
'gjengiftet': ('gjengifte',),
'gjengift': ('gjengifte',),
'gjengjelde': ('gjengjelde',),
'gjengjelder': ('gjengjelde',),
'gjengjeldes': ('gjengjelde',),
'gjengjeldte': ('gjengjelde',),
'gjengjeldt': ('gjengjelde',),
'gjengjeld': ('gjengjelde',),
'gjeninnføre': ('gjeninnføre',),
'gjeninnfører': ('gjeninnføre',),
'gjeninnføres': ('gjeninnføre',),
'gjeninnførte': ('gjeninnføre',),
'gjeninnført': ('gjeninnføre',),
'gjeninnfør': ('gjeninnføre',),
'gjeninnsette': ('gjeninnsette',),
'gjeninnsetter': ('gjeninnsette',),
'gjeninnsettes': ('gjeninnsette',),
'gjeninnsatte': ('gjeninnsette',),
'gjeninnsatt': ('gjeninnsette',),
'gjeninnsett': ('gjeninnsette',),
'gjeninnta': ('gjeninnta',),
'gjeninntar': ('gjeninnta',),
'gjeninntas': ('gjeninnta',),
'gjeninntok': ('gjeninnta',),
'gjeninntatt': ('gjeninnta',),
'gjeninnta': ('gjeninnta',),
'gjenkalle': ('gjenkalle',),
'gjenkaller': ('gjenkalle',),
'gjenkalles': ('gjenkalle',),
'gjenkalte': ('gjenkalle',),
'gjenkalt': ('gjenkalle',),
'gjenkall': ('gjenkalle',),
'gjenkjenne': ('gjenkjenne',),
'gjenkjenner': ('gjenkjenne',),
'gjenkjennes': ('gjenkjenne',),
'gjenkjente': ('gjenkjenne',),
'gjenkjent': ('gjenkjenne',),
'gjenkjenn': ('gjenkjenne',),
'gjenlegge': ('gjenlegge',),
'gjenlegger': ('gjenlegge',),
'gjenlegges': ('gjenlegge',),
'gjenla': ('gjenlegge',),
'gjenlagt': ('gjenlegge',),
'gjenlegg': ('gjenlegge',),
'gjenløse': ('gjenløse',),
'gjenløser': ('gjenløse',),
'gjenløses': ('gjenløse',),
'gjenløste': ('gjenløse',),
'gjenløst': ('gjenløse',),
'gjenløs': ('gjenløse',),
'gjennomarbeide': ('gjennomarbeide',),
'gjennomarbeider': ('gjennomarbeide',),
'gjennomarbeides': ('gjennomarbeide',),
'gjennomarbeida': ('gjennomarbeide',),
'gjennomarbeidet': ('gjennomarbeide',),
'gjennomarbeidde': ('gjennomarbeide',),
'gjennomarbeida': ('gjennomarbeide',),
'gjennomarbeidet': ('gjennomarbeide',),
'gjennomarbeidd': ('gjennomarbeide',),
'gjennomarbeid': ('gjennomarbeide',),
'gjennombore': ('gjennombore',),
'gjennomborer': ('gjennombore',),
'gjennombores': ('gjennombore',),
'gjennombora': ('gjennombore',),
'gjennomboret': ('gjennombore',),
'gjennombora': ('gjennombore',),
'gjennomboret': ('gjennombore',),
'gjennombor': ('gjennombore',),
'gjennomdrøfte': ('gjennomdrøfte',),
'gjennomdrøfter': ('gjennomdrøfte',),
'gjennomdrøftes': ('gjennomdrøfte',),
'gjennomdrøfta': ('gjennomdrøfte',),
'gjennomdrøftet': ('gjennomdrøfte',),
'gjennomdrøfta': ('gjennomdrøfte',),
'gjennomdrøftet': ('gjennomdrøfte',),
'gjennomdrøft': ('gjennomdrøfte',),
'gjennomføre': ('gjennomføre',),
'gjennomfører': ('gjennomføre',),
'gjennomføres': ('gjennomføre',),
'gjennomførte': ('gjennomføre',),
'gjennomført': ('gjennomføre',),
'gjennomfør': ('gjennomføre',),
'gjennomgå': ('gjennomgå',),
'gjennomgår': ('gjennomgå',),
'gjennomgås': ('gjennomgå',),
'gjennomgikk': ('gjennomgå',),
'gjennomgått': ('gjennomgå',),
'gjennomgå': ('gjennomgå',),
'gjennomhulle': ('gjennomhulle',),
'gjennomhuller': ('gjennomhulle',),
'gjennomhulles': ('gjennomhulle',),
'gjennomhulla': ('gjennomhulle',),
'gjennomhullet': ('gjennomhulle',),
'gjennomhulla': ('gjennomhulle',),
'gjennomhullet': ('gjennomhulle',),
'gjennomhull': ('gjennomhulle',),
'gjennomillustrere': ('gjennomillustrere',),
'gjennomillustrerer': ('gjennomillustrere',),
'gjennomillustreres': ('gjennomillustrere',),
'gjennomillustrerte': ('gjennomillustrere',),
'gjennomillustrert': ('gjennomillustrere',),
'gjennomillustrer': ('gjennomillustrere',),
'gjennomlese': ('gjennomlese',),
'gjennomleser': ('gjennomlese',),
'gjennomleses': ('gjennomlese',),
'gjennomleste': ('gjennomlese',),
'gjennomlest': ('gjennomlese',),
'gjennomles': ('gjennomlese',),
'gjennomleve': ('gjennomleve',),
'gjennomlever': ('gjennomleve',),
'gjennomleves': ('gjennomleve',),
'gjennomlevde': ('gjennomleve',),
'gjennomlevd': ('gjennomleve',),
'gjennomlev': ('gjennomleve',),
'gjennomlufte': ('gjennomlufte',),
'gjennomlufter': ('gjennomlufte',),
'gjennomluftes': ('gjennomlufte',),
'gjennomlufta': ('gjennomlufte',),
'gjennomluftet': ('gjennomlufte',),
'gjennomlufta': ('gjennomlufte',),
'gjennomluftet': ('gjennomlufte',),
'gjennomluft': ('gjennomlufte',),
'gjennomlyse': ('gjennomlyse',),
'gjennomlyser': ('gjennomlyse',),
'gjennomlyses': ('gjennomlyse',),
'gjennomlyste': ('gjennomlyse',),
'gjennomlyst': ('gjennomlyse',),
'gjennomlys': ('gjennomlyse',),
'gjennomprøve': ('gjennomprøve',),
'gjennomprøver': ('gjennomprøve',),
'gjennomprøves': ('gjennomprøve',),
'gjennomprøvde': ('gjennomprøve',),
'gjennomprøvd': ('gjennomprøve',),
'gjennomprøv': ('gjennomprøve',),
'gjennomse': ('gjennomse',),
'gjennomser': ('gjennomse',),
'gjennomses': ('gjennomse',),
'gjennomsees': ('gjennomse',),
'gjennomså': ('gjennomse',),
'gjennomsett': ('gjennomse',),
'gjennomse': ('gjennomse',),
'gjennomskue': ('gjennomskue',),
'gjennomskuer': ('gjennomskue',),
'gjennomskues': ('gjennomskue',),
'gjennomskua': ('gjennomskue',),
'gjennomskuet': ('gjennomskue',),
'gjennomskua': ('gjennomskue',),
'gjennomskuet': ('gjennomskue',),
'gjennomsku': ('gjennomskue',),
'gjennomsteike': ('gjennomsteike',),
'gjennomsteiker': ('gjennomsteike',),
'gjennomsteikes': ('gjennomsteike',),
'gjennomsteikte': ('gjennomsteike',),
'gjennomsteikt': ('gjennomsteike',),
'gjennomsteik': ('gjennomsteike',),
'gjennomsteke': ('gjennomsteke',),
'gjennomsteker': ('gjennomsteke',),
'gjennomstekes': ('gjennomsteke',),
'gjennomstekte': ('gjennomsteke',),
'gjennomstekt': ('gjennomsteke',),
'gjennomstek': ('gjennomsteke',),
'gjennomstrømme': ('gjennomstrømme',),
'gjennomstrømmer': ('gjennomstrømme',),
'gjennomstrømmes': ('gjennomstrømme',),
'gjennomstrømma': ('gjennomstrømme',),
'gjennomstrømmet': ('gjennomstrømme',),
'gjennomstrømte': ('gjennomstrømme',),
'gjennomstrømma': ('gjennomstrømme',),
'gjennomstrømmet': ('gjennomstrømme',),
'gjennomstrømt': ('gjennomstrømme',),
'gjennomstrøm': ('gjennomstrømme',),
'gjennomsyre': ('gjennomsyre',),
'gjennomsyrer': ('gjennomsyre',),
'gjennomsyres': ('gjennomsyre',),
'gjennomsyra': ('gjennomsyre',),
'gjennomsyret': ('gjennomsyre',),
'gjennomsyrte': ('gjennomsyre',),
'gjennomsyra': ('gjennomsyre',),
'gjennomsyret': ('gjennomsyre',),
'gjennomsyrt': ('gjennomsyre',),
'gjennomsyr': ('gjennomsyre',),
'gjennomtenke': ('gjennomtenke',),
'gjennomtenker': ('gjennomtenke',),
'gjennomtenkes': ('gjennomtenke',),
'gjennomtenkte': ('gjennomtenke',),
'gjennomtenkt': ('gjennomtenke',),
'gjennomtenk': ('gjennomtenke',),
'gjennomtrenge': ('gjennomtrenge',),
'gjennomtrenger': ('gjennomtrenge',),
'gjennomtrenges': ('gjennomtrenge',),
'gjennomtrengte': ('gjennomtrenge',),
'gjennomtrengt': ('gjennomtrenge',),
'gjennomtreng': ('gjennomtrenge',),
'gjennomtråle': ('gjennomtråle',),
'gjennomtråler': ('gjennomtråle',),
'gjennomtråles': ('gjennomtråle',),
'gjennomtråla': ('gjennomtråle',),
'gjennomtrålet': ('gjennomtråle',),
'gjennomtrålte': ('gjennomtråle',),
'gjennomtråla': ('gjennomtråle',),
'gjennomtrålet': ('gjennomtråle',),
'gjennomtrålt': ('gjennomtråle',),
'gjennomtrål': ('gjennomtråle',),
'gjenoppblusse': ('gjenoppblusse',),
'gjenoppblusser': ('gjenoppblusse',),
'gjenoppblusses': ('gjenoppblusse',),
'gjenoppblussa': ('gjenoppblusse',),
'gjenoppblusset': ('gjenoppblusse',),
'gjenoppblussa': ('gjenoppblusse',),
'gjenoppblusset': ('gjenoppblusse',),
'gjenoppbluss': ('gjenoppblusse',),
'gjenoppbygge': ('gjenoppbygge',),
'gjenoppbygger': ('gjenoppbygge',),
'gjenoppbygges': ('gjenoppbygge',),
'gjenoppbygget': ('gjenoppbygge',),
'gjenoppbygde': ('gjenoppbygge',),
'gjenoppbygget': ('gjenoppbygge',),
'gjenoppbygd': ('gjenoppbygge',),
'gjenoppbygg': ('gjenoppbygge',),
'gjenoppdage': ('gjenoppdage',),
'gjenoppdager': ('gjenoppdage',),
'gjenoppdages': ('gjenoppdage',),
'gjenoppdaga': ('gjenoppdage',),
'gjenoppdaget': ('gjenoppdage',),
'gjenoppdaga': ('gjenoppdage',),
'gjenoppdaget': ('gjenoppdage',),
'gjenoppdag': ('gjenoppdage',),
'gjenoppfriske': ('gjenoppfriske',),
'gjenoppfrisker': ('gjenoppfriske',),
'gjenoppfriskes': ('gjenoppfriske',),
'gjenoppfriska': ('gjenoppfriske',),
'gjenoppfrisket': ('gjenoppfriske',),
'gjenoppfriska': ('gjenoppfriske',),
'gjenoppfrisket': ('gjenoppfriske',),
'gjenoppfrisk': ('gjenoppfriske',),
'gjenoppleve': ('gjenoppleve',),
'gjenopplever': ('gjenoppleve',),
'gjenoppleves': ('gjenoppleve',),
'gjenopplevde': ('gjenoppleve',),
'gjenopplevd': ('gjenoppleve',),
'gjenopplev': ('gjenoppleve',),
'gjenopplive': ('gjenopplive',),
'gjenoppliver': ('gjenopplive',),
'gjenopplives': ('gjenopplive',),
'gjenoppliva': ('gjenopplive',),
'gjenopplivet': ('gjenopplive',),
'gjenoppliva': ('gjenopplive',),
'gjenopplivet': ('gjenopplive',),
'gjenoppliv': ('gjenopplive',),
'gjenopprette': ('gjenopprette',),
'gjenoppretter': ('gjenopprette',),
'gjenopprettes': ('gjenopprette',),
'gjenoppretta': ('gjenopprette',),
'gjenopprettet': ('gjenopprette',),
'gjenoppretta': ('gjenopprette',),
'gjenopprettet': ('gjenopprette',),
'gjenopprett': ('gjenopprette',),
'gjenoppta': ('gjenoppta',),
'gjenopptar': ('gjenoppta',),
'gjenopptas': ('gjenoppta',),
'gjenopptok': ('gjenoppta',),
'gjenopptatt': ('gjenoppta',),
'gjenoppta': ('gjenoppta',),
'gjenopptrykke': ('gjenopptrykke',),
'gjenopptrykker': ('gjenopptrykke',),
'gjenopptrykkes': ('gjenopptrykke',),
'gjenopptrykket': ('gjenopptrykke',),
'gjenopptrykte': ('gjenopptrykke',),
'gjenopptrykket': ('gjenopptrykke',),
'gjenopptrykt': ('gjenopptrykke',),
'gjenopptrykk': ('gjenopptrykke',),
'gjenoppvekke': ('gjenoppvekke',),
'gjenoppvekker': ('gjenoppvekke',),
'gjenoppvekkes': ('gjenoppvekke',),
'gjenoppvekka': ('gjenoppvekke',),
'gjenoppvekket': ('gjenoppvekke',),
'gjenoppvekte': ('gjenoppvekke',),
'gjenoppvekka': ('gjenoppvekke',),
'gjenoppvekket': ('gjenoppvekke',),
'gjenoppvekt': ('gjenoppvekke',),
'gjenoppvekk': ('gjenoppvekke',),
'gjenreise': ('gjenreise',),
'gjenreiser': ('gjenreise',),
'gjenreises': ('gjenreise',),
'gjenreiste': ('gjenreise',),
'gjenreist': ('gjenreise',),
'gjenreis': ('gjenreise',),
'gjenskape': ('gjenskape',),
'gjenskaper': ('gjenskape',),
'gjenskapes': ('gjenskape',),
'gjenskapte': ('gjenskape',),
'gjenskapt': ('gjenskape',),
'gjenskap': ('gjenskape',),
'gjenspeile': ('gjenspeile',),
'gjenspeiler': ('gjenspeile',),
'gjenspeiles': ('gjenspeile',),
'gjenspeila': ('gjenspeile',),
'gjenspeilet': ('gjenspeile',),
'gjenspeilte': ('gjenspeile',),
'gjenspeila': ('gjenspeile',),
'gjenspeilet': ('gjenspeile',),
'gjenspeilt': ('gjenspeile',),
'gjenspeil': ('gjenspeile',),
'gjenta': ('gjenta',),
'gjentar': ('gjenta',),
'gjentas': ('gjenta',),
'gjentok': ('gjenta',),
'gjentatt': ('gjenta',),
'gjenta': ('gjenta',),
'gjenvelge': ('gjenvelge',),
'gjenvelger': ('gjenvelge',),
'gjenvelges': ('gjenvelge',),
'gjenvalgte': ('gjenvelge',),
'gjenvalgt': ('gjenvelge',),
'gjenvelg': ('gjenvelge',),
'gjenåpne': ('gjenåpne',),
'gjenåpner': ('gjenåpne',),
'gjenåpnes': ('gjenåpne',),
'gjenåpna': ('gjenåpne',),
'gjenåpnet': ('gjenåpne',),
'gjenåpna': ('gjenåpne',),
'gjenåpnet': ('gjenåpne',),
'gjenåpn': ('gjenåpne',),
'gjenåpne': ('gjenåpne',),
'gjenåpn': ('gjenåpne',),
'gjenåpne': ('gjenåpne',),
'gjerde': ('gjerde',),
'gjerder': ('gjerde',),
'gjerdes': ('gjerde',),
'gjerda': ('gjerde',),
'gjerdet': ('gjerde',),
'gjerda': ('gjerde',),
'gjerdet': ('gjerde',),
'gjerd': ('gjerde',),
'gjespe': ('gjespe',),
'gjesper': ('gjespe',),
'gjespes': ('gjespe',),
'gjespa': ('gjespe',),
'gjespet': ('gjespe',),
'gjespa': ('gjespe',),
'gjespet': ('gjespe',),
'gjesp': ('gjespe',),
'gjeste': ('gjeste',),
'gjester': ('gjeste',),
'gjestes': ('gjeste',),
'gjesta': ('gjeste',),
'gjestet': ('gjeste',),
'gjesta': ('gjeste',),
'gjestet': ('gjeste',),
'gjest': ('gjeste',),
'gjete': ('gjete',),
'gjeter': ('gjete',),
'gjetes': ('gjete',),
'gjette': ('gjete',),
'gjett': ('gjete',),
'gjet': ('gjete',),
'gjette': ('gjette',),
'gjetter': ('gjette',),
'gjettes': ('gjette',),
'gjetta': ('gjette',),
'gjettet': ('gjette',),
'gjetta': ('gjette',),
'gjettet': ('gjette',),
'gjett': ('gjette',),
'gjorde': ('gjorde',),
'gjorder': ('gjorde',),
'gjordes': ('gjorde',),
'gjorda': ('gjorde',),
'gjordet': ('gjorde',),
'gjorda': ('gjorde',),
'gjordet': ('gjorde',),
'gjord': ('gjorde',),
'gjure': ('gjure',),
'gjurer': ('gjure',),
'gjures': ('gjure',),
'gjura': ('gjure',),
'gjuret': ('gjure',),
'gjurte': ('gjure',),
'gjura': ('gjure',),
'gjuret': ('gjure',),
'gjurt': ('gjure',),
'gjur': ('gjure',),
'gjære': ('gjære',),
'gjærer': ('gjære',),
'gjæres': ('gjære',),
'gjæra': ('gjære',),
'gjæret': ('gjære',),
'gjærte': ('gjære',),
'gjæra': ('gjære',),
'gjæret': ('gjære',),
'gjært': ('gjære',),
'gjær': ('gjære',),
'gjø': ('gjø',),
'gjør': ('gjø',),
'gjøs': ('gjø',),
'gjødde': ('gjø',),
'gjødd': ('gjø',),
'gjø': ('gjø',),
'gjøde': ('gjøde',),
'gjøder': ('gjøde',),
'gjødes': ('gjøde',),
'gjødde': ('gjøde',),
'gjødd': ('gjøde',),
'gjød': ('gjøde',),
'gjødsle': ('gjødsle',),
'gjødsler': ('gjødsle',),
'gjødsles': ('gjødsle',),
'gjødsla': ('gjødsle',),
'gjødslet': ('gjødsle',),
'gjødsla': ('gjødsle',),
'gjødslet': ('gjødsle',),
'gjødsl': ('gjødsle',),
'gjødsle': ('gjødsle',),
'gjødsl': ('gjødsle',),
'gjødsle': ('gjødsle',),
'gjøgle': ('gjøgle',),
'gjøgler': ('gjøgle',),
'gjøgles': ('gjøgle',),
'gjøgla': ('gjøgle',),
'gjøglet': ('gjøgle',),
'gjøgla': ('gjøgle',),
'gjøglet': ('gjøgle',),
'gjøgl': ('gjøgle',),
'gjøgle': ('gjøgle',),
'gjøgl': ('gjøgle',),
'gjøgle': ('gjøgle',),
'gjøle': ('gjøle',),
'gjøler': ('gjøle',),
'gjøles': ('gjøle',),
'gjølte': ('gjøle',),
'gjølt': ('gjøle',),
'gjøl': ('gjøle',),
'gjømme': ('gjømme',),
'gjømmer': ('gjømme',),
'gjømmes': ('gjømme',),
'gjømte': ('gjømme',),
'gjømt': ('gjømme',),
'gjøm': ('gjømme',),
'gjøne': ('gjøne',),
'gjøner': ('gjøne',),
'gjønes': ('gjøne',),
'gjønte': ('gjøne',),
'gjønt': ('gjøne',),
'gjøn': ('gjøne',),
'gjøre': ('gjøre',),
'gjør': ('gjøre',),
'gjøres': ('gjøre',),
'gjorde': ('gjøre',),
'gjort': ('gjøre',),
'gjør': ('gjøre',),
'gjørme': ('gjørme',),
'gjørmer': ('gjørme',),
'gjørmes': ('gjørme',),
'gjørma': ('gjørme',),
'gjørmet': ('gjørme',),
'gjørma': ('gjørme',),
'gjørmet': ('gjørme',),
'gjørm': ('gjørme',),
'gjørs': ('gjørs',),
'gjors': ('gjørs',),
'gjørs': ('gjørs',),
'gla': ('gla',),
'glar': ('gla',),
'glas': ('gla',),
'gladde': ('gla',),
'gladd': ('gla',),
'gla': ('gla',),
'glafse': ('glafse',),
'glafser': ('glafse',),
'glafses': ('glafse',),
'glafsa': ('glafse',),
'glafset': ('glafse',),
'glafsa': ('glafse',),
'glafset': ('glafse',),
'glafs': ('glafse',),
'glamme': ('glamme',),
'glammer': ('glamme',),
'glammes': ('glamme',),
'glamma': ('glamme',),
'glammet': ('glamme',),
'glamma': ('glamme',),
'glammet': ('glamme',),
'glam': ('glamme',),
'glamorisere': ('glamorisere',),
'glamoriserer': ('glamorisere',),
'glamoriseres': ('glamorisere',),
'glamoriserte': ('glamorisere',),
'glamorisert': ('glamorisere',),
'glamoriser': ('glamorisere',),
'glane': ('glane',),
'glaner': ('glane',),
'glanes': ('glane',),
'glante': ('glane',),
'glant': ('glane',),
'glan': ('glane',),
'glanse': ('glanse',),
'glanser': ('glanse',),
'glanses': ('glanse',),
'glansa': ('glanse',),
'glanset': ('glanse',),
'glansa': ('glanse',),
'glanset': ('glanse',),
'glans': ('glanse',),
'glasere': ('glasere',),
'glaserer': ('glasere',),
'glaseres': ('glasere',),
'glaserte': ('glasere',),
'glasert': ('glasere',),
'glaser': ('glasere',),
'glattbarbere': ('glattbarbere',),
'glattbarberer': ('glattbarbere',),
'glattbarberes': ('glattbarbere',),
'glattbarberte': ('glattbarbere',),
'glattbarbert': ('glattbarbere',),
'glattbarber': ('glattbarbere',),
'glatte': ('glatte',),
'glatter': ('glatte',),
'glattes': ('glatte',),
'glatta': ('glatte',),
'glattet': ('glatte',),
'glatta': ('glatte',),
'glattet': ('glatte',),
'glatt': ('glatte',),
'glattkjemme': ('glattkjemme',),
'glattkjemmer': ('glattkjemme',),
'glattkjemmes': ('glattkjemme',),
'glattkjemma': ('glattkjemme',),
'glattkjemmet': ('glattkjemme',),
'glattkjemte': ('glattkjemme',),
'glattkjemma': ('glattkjemme',),
'glattkjemmet': ('glattkjemme',),
'glattkjemt': ('glattkjemme',),
'glattkjem': ('glattkjemme',),
'glattstryke': ('glattstryke',),
'glattstryker': ('glattstryke',),
'glattstrykes': ('glattstryke',),
'glattstrøyk': ('glattstryke',),
'glattstrøk': ('glattstryke',),
'glattstrøket': ('glattstryke',),
'glattstryk': ('glattstryke',),
'glede': ('glede',),
'gleder': ('glede',),
'gledes': ('glede',),
'gleda': ('glede',),
'gledet': ('glede',),
'gledde': ('glede',),
'gleda': ('glede',),
'gledet': ('glede',),
'gledd': ('glede',),
'gled': ('glede',),
'glefse': ('glefse',),
'glefser': ('glefse',),
'glefses': ('glefse',),
'glefsa': ('glefse',),
'glefset': ('glefse',),
'glefste': ('glefse',),
'glefsa': ('glefse',),
'glefset': ('glefse',),
'glefst': ('glefse',),
'glefs': ('glefse',),
'glemme': ('glemme',),
'glemmer': ('glemme',),
'glemmes': ('glemme',),
'glemte': ('glemme',),
'glemt': ('glemme',),
'glem': ('glemme',),
'gleppe': ('gleppe',),
'glepper': ('gleppe',),
'gleppes': ('gleppe',),
'glapp': ('gleppe',),
'gleppet': ('gleppe',),
'glepp': ('gleppe',),
'gli': ('gli',),
'glir': ('gli',),
'glis': ('gli',),
'glei': ('gli',),
'gled': ('gli',),
'glidd': ('gli',),
'gli': ('gli',),
'glidefly': ('glidefly',),
'glideflyr': ('glidefly',),
'glideflys': ('glidefly',),
'glidefløy': ('glidefly',),
'glideflydd': ('glidefly',),
'glidefløyet': ('glidefly',),
'glidefly': ('glidefly',),
'glideflyge': ('glideflyge',),
'glideflyger': ('glideflyge',),
'glideflyges': ('glideflyge',),
'glidefløy': ('glideflyge',),
'glidefløyet': ('glideflyge',),
'glideflyg': ('glideflyge',),
'glime': ('glime',),
'glimer': ('glime',),
'glimes': ('glime',),
'glimte': ('glime',),
'glimt': ('glime',),
'glim': ('glime',),
'glimre': ('glimre',),
'glimrer': ('glimre',),
'glimres': ('glimre',),
'glimra': ('glimre',),
'glimret': ('glimre',),
'glimra': ('glimre',),
'glimret': ('glimre',),
'glimr': ('glimre',),
'glimre': ('glimre',),
'glimr': ('glimre',),
'glimre': ('glimre',),
'glimte': ('glimte',),
'glimter': ('glimte',),
'glimtes': ('glimte',),
'glimta': ('glimte',),
'glimtet': ('glimte',),
'glimta': ('glimte',),
'glimtet': ('glimte',),
'glimt': ('glimte',),
'glinse': ('glinse',),
'glinser': ('glinse',),
'glinses': ('glinse',),
'glinsa': ('glinse',),
'glinset': ('glinse',),
'glinsa': ('glinse',),
'glinset': ('glinse',),
'glins': ('glinse',),
'glipe': ('glipe',),
'gliper': ('glipe',),
'glipes': ('glipe',),
'glipte': ('glipe',),
'glipt': ('glipe',),
'glip': ('glipe',),
'glire': ('glire',),
'glirer': ('glire',),
'glires': ('glire',),
'glirte': ('glire',),
'glirt': ('glire',),
'glir': ('glire',),
'glise': ('glise',),
'gliser': ('glise',),
'glises': ('glise',),
'gliste': ('glise',),
'glist': ('glise',),
'glis': ('glise',),
'glitre': ('glitre',),
'glitrer': ('glitre',),
'glitres': ('glitre',),
'glitra': ('glitre',),
'glitret': ('glitre',),
'glitra': ('glitre',),
'glitret': ('glitre',),
'glitr': ('glitre',),
'glitre': ('glitre',),
'glitr': ('glitre',),
'glitre': ('glitre',),
'glitte': ('glitte',),
'glitter': ('glitte',),
'glittes': ('glitte',),
'glitta': ('glitte',),
'glittet': ('glitte',),
'glitta': ('glitte',),
'glittet': ('glitte',),
'glitt': ('glitte',),
'glo': ('glo',),
'glor': ('glo',),
'glos': ('glo',),
'glodde': ('glo',),
'glodd': ('glo',),
'glo': ('glo',),
'glore': ('glore',),
'glorer': ('glore',),
'glores': ('glore',),
'glora': ('glore',),
'gloret': ('glore',),
'glorte': ('glore',),
'glora': ('glore',),
'gloret': ('glore',),
'glort': ('glore',),
'glor': ('glore',),
'glorifisere': ('glorifisere',),
'glorifiserer': ('glorifisere',),
'glorifiseres': ('glorifisere',),
'glorifiserte': ('glorifisere',),
'glorifisert': ('glorifisere',),
'glorifiser': ('glorifisere',),
'gløde': ('gløde',),
'gløder': ('gløde',),
'glødes': ('gløde',),
'gløda': ('gløde',),
'glødet': ('gløde',),
'glødde': ('gløde',),
'gløda': ('gløde',),
'glødet': ('gløde',),
'glødd': ('gløde',),
'glød': ('gløde',),
'glømme': ('glømme',),
'glømmer': ('glømme',),
'glømmes': ('glømme',),
'glømte': ('glømme',),
'glømt': ('glømme',),
'gløm': ('glømme',),
'gløtte': ('gløtte',),
'gløtter': ('gløtte',),
'gløttes': ('gløtte',),
'gløtta': ('gløtte',),
'gløttet': ('gløtte',),
'gløtta': ('gløtte',),
'gløttet': ('gløtte',),
'gløtt': ('gløtte',),
'gnafse': ('gnafse',),
'gnafser': ('gnafse',),
'gnafses': ('gnafse',),
'gnafsa': ('gnafse',),
'gnafset': ('gnafse',),
'gnafste': ('gnafse',),
'gnafsa': ('gnafse',),
'gnafset': ('gnafse',),
'gnafst': ('gnafse',),
'gnafs': ('gnafse',),
'gnage': ('gnage',),
'gnager': ('gnage',),
'gnages': ('gnage',),
'gnaget': ('gnage',),
'gnagde': ('gnage',),
'gnog': ('gnage',),
'gnaget': ('gnage',),
'gnagd': ('gnage',),
'gnag': ('gnage',),
'gnaldre': ('gnaldre',),
'gnaldrer': ('gnaldre',),
'gnaldres': ('gnaldre',),
'gnaldra': ('gnaldre',),
'gnaldret': ('gnaldre',),
'gnaldra': ('gnaldre',),
'gnaldret': ('gnaldre',),
'gnaldr': ('gnaldre',),
'gnaldre': ('gnaldre',),
'gnaldr': ('gnaldre',),
'gnaldre': ('gnaldre',),
'gneldre': ('gneldre',),
'gneldrer': ('gneldre',),
'gneldres': ('gneldre',),
'gneldra': ('gneldre',),
'gneldret': ('gneldre',),
'gneldra': ('gneldre',),
'gneldret': ('gneldre',),
'gneldr': ('gneldre',),
'gneldre': ('gneldre',),
'gneldr': ('gneldre',),
'gneldre': ('gneldre',),
'gnelle': ('gnelle',),
'gneller': ('gnelle',),
'gnelles': ('gnelle',),
'gnelte': ('gnelle',),
'gnall': ('gnelle',),
'gnelt': ('gnelle',),
'gnell': ('gnelle',),
'gni': ('gni',),
'gnir': ('gni',),
'gnis': ('gni',),
'gnidde': ('gni',),
'gnei': ('gni',),
'gned': ('gni',),
'gnidd': ('gni',),
'gni': ('gni',),
'gnidre': ('gnidre',),
'gnidrer': ('gnidre',),
'gnidres': ('gnidre',),
'gnidra': ('gnidre',),
'gnidret': ('gnidre',),
'gnidra': ('gnidre',),
'gnidret': ('gnidre',),
'gnidr': ('gnidre',),
'gnidre': ('gnidre',),
'gnidr': ('gnidre',),
'gnidre': ('gnidre',),
'gnikke': ('gnikke',),
'gnikker': ('gnikke',),
'gnikkes': ('gnikke',),
'gnikka': ('gnikke',),
'gnikket': ('gnikke',),
'gnikka': ('gnikke',),
'gnikket': ('gnikke',),
'gnikk': ('gnikke',),
'gnikse': ('gnikse',),
'gnikser': ('gnikse',),
'gnikses': ('gnikse',),
'gniksa': ('gnikse',),
'gnikset': ('gnikse',),
'gniksa': ('gnikse',),
'gnikset': ('gnikse',),
'gniks': ('gnikse',),
'gnirke': ('gnirke',),
'gnirker': ('gnirke',),
'gnirkes': ('gnirke',),
'gnirka': ('gnirke',),
'gnirket': ('gnirke',),
'gnirka': ('gnirke',),
'gnirket': ('gnirke',),
'gnirk': ('gnirke',),
'gnisle': ('gnisle',),
'gnisler': ('gnisle',),
'gnisles': ('gnisle',),
'gnisla': ('gnisle',),
'gnislet': ('gnisle',),
'gnisla': ('gnisle',),
'gnislet': ('gnisle',),
'gnisl': ('gnisle',),
'gnisse': ('gnisse',),
'gnisser': ('gnisse',),
'gnisses': ('gnisse',),
'gnissa': ('gnisse',),
'gnisset': ('gnisse',),
'gnissa': ('gnisse',),
'gnisset': ('gnisse',),
'gniss': ('gnisse',),
'gniste': ('gniste',),
'gnister': ('gniste',),
'gnistes': ('gniste',),
'gnista': ('gniste',),
'gnistet': ('gniste',),
'gnista': ('gniste',),
'gnistet': ('gniste',),
'gnist': ('gniste',),
'gnistre': ('gnistre',),
'gnistrer': ('gnistre',),
'gnistres': ('gnistre',),
'gnistra': ('gnistre',),
'gnistret': ('gnistre',),
'gnistra': ('gnistre',),
'gnistret': ('gnistre',),
'gnistr': ('gnistre',),
'gnistre': ('gnistre',),
'gnistr': ('gnistre',),
'gnistre': ('gnistre',),
'gnu': ('gnu',),
'gnur': ('gnu',),
'gnus': ('gnu',),
'gnudde': ('gnu',),
'gnudd': ('gnu',),
'gnu': ('gnu',),
'gnubbe': ('gnubbe',),
'gnubber': ('gnubbe',),
'gnubbes': ('gnubbe',),
'gnubba': ('gnubbe',),
'gnubbet': ('gnubbe',),
'gnubba': ('gnubbe',),
'gnubbet': ('gnubbe',),
'gnubb': ('gnubbe',),
'gnugge': ('gnugge',),
'gnugger': ('gnugge',),
'gnugges': ('gnugge',),
'gnugga': ('gnugge',),
'gnugget': ('gnugge',),
'gnugga': ('gnugge',),
'gnugget': ('gnugge',),
'gnugg': ('gnugge',),
'gnukke': ('gnukke',),
'gnukker': ('gnukke',),
'gnukkes': ('gnukke',),
'gnukka': ('gnukke',),
'gnukket': ('gnukke',),
'gnukka': ('gnukke',),
'gnukket': ('gnukke',),
'gnukk': ('gnukke',),
'gnure': ('gnure',),
'gnurer': ('gnure',),
'gnures': ('gnure',),
'gnura': ('gnure',),
'gnuret': ('gnure',),
'gnurte': ('gnure',),
'gnura': ('gnure',),
'gnuret': ('gnure',),
'gnurt': ('gnure',),
'gnur': ('gnure',),
'gnusle': ('gnusle',),
'gnusler': ('gnusle',),
'gnusles': ('gnusle',),
'gnusla': ('gnusle',),
'gnuslet': ('gnusle',),
'gnusla': ('gnusle',),
'gnuslet': ('gnusle',),
'gnusl': ('gnusle',),
'gnusse': ('gnusse',),
'gnusser': ('gnusse',),
'gnusses': ('gnusse',),
'gnussa': ('gnusse',),
'gnusset': ('gnusse',),
'gnussa': ('gnusse',),
'gnusset': ('gnusse',),
'gnuss': ('gnusse',),
'gny': ('gny',),
'gnyr': ('gny',),
'gnys': ('gny',),
'gnydde': ('gny',),
'gnydd': ('gny',),
'gny': ('gny',),
'gnåle': ('gnåle',),
'gnåler': ('gnåle',),
'gnåles': ('gnåle',),
'gnålte': ('gnåle',),
'gnålt': ('gnåle',),
'gnål': ('gnåle',),
'godgjøre': ('godgjøre',),
'godgjør': ('godgjøre',),
'godgjøres': ('godgjøre',),
'godgjorde': ('godgjøre',),
'godgjort': ('godgjøre',),
'godgjør': ('godgjøre',),
'godkjenne': ('godkjenne',),
'godkjenner': ('godkjenne',),
'godkjennes': ('godkjenne',),
'godkjente': ('godkjenne',),
'godkjent': ('godkjenne',),
'godkjenn': ('godkjenne',),
'godskrive': ('godskrive',),
'godskriver': ('godskrive',),
'godskrives': ('godskrive',),
'godskrev': ('godskrive',),
'godskreiv': ('godskrive',),
'godskrev': ('godskrive',),
'godskreiv': ('godskrive',),
'godskrevet': ('godskrive',),
'godskriv': ('godskrive',),
'godsnakke': ('godsnakke',),
'godsnakker': ('godsnakke',),
'godsnakkes': ('godsnakke',),
'godsnakka': ('godsnakke',),
'godsnakket': ('godsnakke',),
'godsnakka': ('godsnakke',),
'godsnakket': ('godsnakke',),
'godsnakk': ('godsnakke',),
'godta': ('godta',),
'godtar': ('godta',),
'godtas': ('godta',),
'godtok': ('godta',),
'godtatt': ('godta',),
'godta': ('godta',),
'godte': ('godte',),
'godter': ('godte',),
'godtes': ('godte',),
'godta': ('godte',),
'godtet': ('godte',),
'godta': ('godte',),
'godtet': ('godte',),
'godt': ('godte',),
'godtgjøre': ('godtgjøre',),
'godtgjør': ('godtgjøre',),
'godtgjøres': ('godtgjøre',),
'godtgjorde': ('godtgjøre',),
'godtgjort': ('godtgjøre',),
'godtgjør': ('godtgjøre',),
'gomle': ('gomle',),
'gomler': ('gomle',),
'gomles': ('gomle',),
'gomla': ('gomle',),
'gomlet': ('gomle',),
'gomla': ('gomle',),
'gomlet': ('gomle',),
'goml': ('gomle',),
'gomle': ('gomle',),
'goml': ('gomle',),
'gomle': ('gomle',),
'gove': ('gove',),
'gover': ('gove',),
'goves': ('gove',),
'gova': ('gove',),
'govet': ('gove',),
'gova': ('gove',),
'govet': ('gove',),
'gov': ('gove',),
'grabbe': ('grabbe',),
'grabber': ('grabbe',),
'grabbes': ('grabbe',),
'grabba': ('grabbe',),
'grabbet': ('grabbe',),
'grabba': ('grabbe',),
'grabbet': ('grabbe',),
'grabb': ('grabbe',),
'gradbøye': ('gradbøye',),
'gradbøyer': ('gradbøye',),
'gradbøyes': ('gradbøye',),
'gradbøyet': ('gradbøye',),
'gradbøyde': ('gradbøye',),
'gradbøyet': ('gradbøye',),
'gradbøyd': ('gradbøye',),
'gradbøy': ('gradbøye',),
'grade': ('grade',),
'grader': ('grade',),
'grades': ('grade',),
'grada': ('grade',),
'gradet': ('grade',),
'grada': ('grade',),
'gradet': ('grade',),
'grad': ('grade',),
'gradere': ('gradere',),
'graderer': ('gradere',),
'graderes': ('gradere',),
'graderte': ('gradere',),
'gradert': ('gradere',),
'grader': ('gradere',),
'graduere': ('graduere',),
'graduerer': ('graduere',),
'gradueres': ('graduere',),
'graduerte': ('graduere',),
'graduert': ('graduere',),
'graduer': ('graduere',),
'grafse': ('grafse',),
'grafser': ('grafse',),
'grafses': ('grafse',),
'grafsa': ('grafse',),
'grafset': ('grafse',),
'grafsa': ('grafse',),
'grafset': ('grafse',),
'grafs': ('grafse',),
'gramse': ('gramse',),
'gramser': ('gramse',),
'gramses': ('gramse',),
'gramsa': ('gramse',),
'gramset': ('gramse',),
'gramsa': ('gramse',),
'gramset': ('gramse',),
'grams': ('gramse',),
'granske': ('granske',),
'gransker': ('granske',),
'granskes': ('granske',),
'granska': ('granske',),
'gransket': ('granske',),
'granska': ('granske',),
'gransket': ('granske',),
'gransk': ('granske',),
'granulere': ('granulere',),
'granulerer': ('granulere',),
'granuleres': ('granulere',),
'granulerte': ('granulere',),
'granulert': ('granulere',),
'granuler': ('granulere',),
'grase': ('grase',),
'graser': ('grase',),
'grases': ('grase',),
'grasa': ('grase',),
'graset': ('grase',),
'grasa': ('grase',),
'graset': ('grase',),
'gras': ('grase',),
'grassere': ('grassere',),
'grasserer': ('grassere',),
'grasseres': ('grassere',),
'grasserte': ('grassere',),
'grassert': ('grassere',),
'grasser': ('grassere',),
'gratinere': ('gratinere',),
'gratinerer': ('gratinere',),
'gratineres': ('gratinere',),
'gratinerte': ('gratinere',),
'gratinert': ('gratinere',),
'gratiner': ('gratinere',),
'gratulere': ('gratulere',),
'gratulerer': ('gratulere',),
'gratuleres': ('gratulere',),
'gratulerte': ('gratulere',),
'gratulert': ('gratulere',),
'gratuler': ('gratulere',),
'grave': ('grave',),
'graver': ('grave',),
'graves': ('grave',),
'grava': ('grave',),
'gravet': ('grave',),
'gravde': ('grave',),
'grava': ('grave',),
'gravet': ('grave',),
'gravd': ('grave',),
'grav': ('grave',),
'grave': ('grave',),
'graver': ('grave',),
'graves': ('grave',),
'gravde': ('grave',),
'grov': ('grave',),
'gravd': ('grave',),
'grav': ('grave',),
'gravere': ('gravere',),
'graverer': ('gravere',),
'graveres': ('gravere',),
'graverte': ('gravere',),
'gravert': ('gravere',),
'graver': ('gravere',),
'gravitere': ('gravitere',),
'graviterer': ('gravitere',),
'graviteres': ('gravitere',),
'graviterte': ('gravitere',),
'gravitert': ('gravitere',),
'graviter': ('gravitere',),
'gravlegge': ('gravlegge',),
'gravlegger': ('gravlegge',),
'gravlegges': ('gravlegge',),
'gravla': ('gravlegge',),
'gravlagt': ('gravlegge',),
'gravlegg': ('gravlegge',),
'gre': ('gre',),
'grer': ('gre',),
'gres': ('gre',),
'gredde': ('gre',),
'gredd': ('gre',),
'gre': ('gre',),
'greie': ('greie',),
'greier': ('greie',),
'greies': ('greie',),
'greide': ('greie',),
'greid': ('greie',),
'grei': ('greie',),
'greine': ('greine',),
'greiner': ('greine',),
'greines': ('greine',),
'greina': ('greine',),
'greinet': ('greine',),
'greinte': ('greine',),
'greina': ('greine',),
'greinet': ('greine',),
'greint': ('greine',),
'grein': ('greine',),
'gremme': ('gremme',),
'gremmer': ('gremme',),
'gremmes': ('gremme',),
'gremma': ('gremme',),
'gremmet': ('gremme',),
'gremte': ('gremme',),
'gremma': ('gremme',),
'gremmet': ('gremme',),
'gremt': ('gremme',),
'grem': ('gremme',),
'grene': ('grene',),
'grener': ('grene',),
'grenes': ('grene',),
'grena': ('grene',),
'grenet': ('grene',),
'grente': ('grene',),
'grena': ('grene',),
'grenet': ('grene',),
'grent': ('grene',),
'gren': ('grene',),
'grense': ('grense',),
'grenser': ('grense',),
'grenses': ('grense',),
'grensa': ('grense',),
'grenset': ('grense',),
'grensa': ('grense',),
'grenset': ('grense',),
'grens': ('grense',),
'gresse': ('gresse',),
'gresser': ('gresse',),
'gresses': ('gresse',),
'gressa': ('gresse',),
'gresset': ('gresse',),
'gressa': ('gresse',),
'gresset': ('gresse',),
'gress': ('gresse',),
'griljere': ('griljere',),
'griljerer': ('griljere',),
'griljeres': ('griljere',),
'griljerte': ('griljere',),
'griljert': ('griljere',),
'griljer': ('griljere',),
'grille': ('grille',),
'griller': ('grille',),
'grilles': ('grille',),
'grilla': ('grille',),
'grillet': ('grille',),
'grilla': ('grille',),
'grillet': ('grille',),
'grill': ('grille',),
'grime': ('grime',),
'grimer': ('grime',),
'grimes': ('grime',),
'grima': ('grime',),
'grimet': ('grime',),
'grima': ('grime',),
'grimet': ('grime',),
'grim': ('grime',),
'grine': ('grine',),
'griner': ('grine',),
'grines': ('grine',),
'grinte': ('grine',),
'gren': ('grine',),
'grein': ('grine',),
'grint': ('grine',),
'grin': ('grine',),
'gripe': ('gripe',),
'griper': ('gripe',),
'gripes': ('gripe',),
'grep': ('gripe',),
'greip': ('gripe',),
'grep': ('gripe',),
'greip': ('gripe',),
'grepet': ('gripe',),
'grip': ('gripe',),
'grise': ('grise',),
'griser': ('grise',),
'grises': ('grise',),
'grisa': ('grise',),
'griset': ('grise',),
'griste': ('grise',),
'grisa': ('grise',),
'griset': ('grise',),
'grist': ('grise',),
'gris': ('grise',),
'grisle': ('grisle',),
'grisler': ('grisle',),
'grisles': ('grisle',),
'grisla': ('grisle',),
'grislet': ('grisle',),
'grisla': ('grisle',),
'grislet': ('grisle',),
'grisl': ('grisle',),
'grisle': ('grisle',),
'grisl': ('grisle',),
'grisle': ('grisle',),
'grisne': ('grisne',),
'grisner': ('grisne',),
'grisnes': ('grisne',),
'grisna': ('grisne',),
'grisnet': ('grisne',),
'grisna': ('grisne',),
'grisnet': ('grisne',),
'grisn': ('grisne',),
'gro': ('gro',),
'gror': ('gro',),
'gros': ('gro',),
'grodde': ('gro',),
'grodd': ('gro',),
'gro': ('gro',),
'grope': ('grope',),
'groper': ('grope',),
'gropes': ('grope',),
'gropa': ('grope',),
'gropet': ('grope',),
'gropa': ('grope',),
'gropet': ('grope',),
'grop': ('grope',),
'grovhakke': ('grovhakke',),
'grovhakker': ('grovhakke',),
'grovhakkes': ('grovhakke',),
'grovhakka': ('grovhakke',),
'grovhakket': ('grovhakke',),
'grovhakka': ('grovhakke',),
'grovhakket': ('grovhakke',),
'grovhakk': ('grovhakke',),
'grovmale': ('grovmale',),
'grovmaler': ('grovmale',),
'grovmales': ('grovmale',),
'grovmalte': ('grovmale',),
'grovmol': ('grovmale',),
'grovmalt': ('grovmale',),
'grovmal': ('grovmale',),
'grovsikte': ('grovsikte',),
'grovsikter': ('grovsikte',),
'grovsiktes': ('grovsikte',),
'grovsikta': ('grovsikte',),
'grovsiktet': ('grovsikte',),
'grovsikta': ('grovsikte',),
'grovsiktet': ('grovsikte',),
'grovsikt': ('grovsikte',),
'grovsortere': ('grovsortere',),
'grovsorterer': ('grovsortere',),
'grovsorteres': ('grovsortere',),
'grovsorterte': ('grovsortere',),
'grovsortert': ('grovsortere',),
'grovsorter': ('grovsortere',),
'grovtelle': ('grovtelle',),
'grovteller': ('grovtelle',),
'grovtelles': ('grovtelle',),
'grovtellet': ('grovtelle',),
'grovtelte': ('grovtelle',),
'grovtalte': ('grovtelle',),
'grovtellet': ('grovtelle',),
'grovtelt': ('grovtelle',),
'grovtalt': ('grovtelle',),
'grovtell': ('grovtelle',),
'gruble': ('gruble',),
'grubler': ('gruble',),
'grubles': ('gruble',),
'grubla': ('gruble',),
'grublet': ('gruble',),
'grubla': ('gruble',),
'grublet': ('gruble',),
'grubl': ('gruble',),
'gruble': ('gruble',),
'grubl': ('gruble',),
'gruble': ('gruble',),
'grue': ('grue',),
'gruer': ('grue',),
'grues': ('grue',),
'grua': ('grue',),
'gruet': ('grue',),
'grudde': ('grue',),
'grua': ('grue',),
'gruet': ('grue',),
'grudd': ('grue',),
'gru': ('grue',),
'grumse': ('grumse',),
'grumser': ('grumse',),
'grumses': ('grumse',),
'grumsa': ('grumse',),
'grumset': ('grumse',),
'grumsa': ('grumse',),
'grumset': ('grumse',),
'grums': ('grumse',),
'grundere': ('grundere',),
'grunderer': ('grundere',),
'grunderes': ('grundere',),
'grunderte': ('grundere',),
'grundert': ('grundere',),
'grunder': ('grundere',),
'grunne': ('grunne',),
'grunner': ('grunne',),
'grunnes': ('grunne',),
'grunna': ('grunne',),
'grunnet': ('grunne',),
'grunna': ('grunne',),
'grunnet': ('grunne',),
'grunn': ('grunne',),
'grunnfeste': ('grunnfeste',),
'grunnfester': ('grunnfeste',),
'grunnfestes': ('grunnfeste',),
'grunnfesta': ('grunnfeste',),
'grunnfestet': ('grunnfeste',),
'grunnfesta': ('grunnfeste',),
'grunnfestet': ('grunnfeste',),
'grunnfest': ('grunnfeste',),
'grunngi': ('grunngi',),
'grunngir': ('grunngi',),
'grunngis': ('grunngi',),
'grunngav': ('grunngi',),
'grunnga': ('grunngi',),
'grunngitt': ('grunngi',),
'grunngi': ('grunngi',),
'grunnlegge': ('grunnlegge',),
'grunnlegger': ('grunnlegge',),
'grunnlegges': ('grunnlegge',),
'grunnla': ('grunnlegge',),
'grunnlagt': ('grunnlegge',),
'grunnlegg': ('grunnlegge',),
'grunnsette': ('grunnsette',),
'grunnsetter': ('grunnsette',),
'grunnsettes': ('grunnsette',),
'grunnsatte': ('grunnsette',),
'grunnsatt': ('grunnsette',),
'grunnsett': ('grunnsette',),
'grunnstøte': ('grunnstøte',),
'grunnstøter': ('grunnstøte',),
'grunnstøtes': ('grunnstøte',),
'grunnstøtte': ('grunnstøte',),
'grunnstøtt': ('grunnstøte',),
'grunnstøt': ('grunnstøte',),
'gruppere': ('gruppere',),
'grupperer': ('gruppere',),
'grupperes': ('gruppere',),
'grupperte': ('gruppere',),
'gruppert': ('gruppere',),
'grupper': ('gruppere',),
'gruse': ('gruse',),
'gruser': ('gruse',),
'gruses': ('gruse',),
'grusa': ('gruse',),
'gruset': ('gruse',),
'grusa': ('gruse',),
'gruset': ('gruse',),
'grus': ('gruse',),
'gruslegge': ('gruslegge',),
'gruslegger': ('gruslegge',),
'gruslegges': ('gruslegge',),
'grusla': ('gruslegge',),
'gruslagt': ('gruslegge',),
'gruslegg': ('gruslegge',),
'gry': ('gry',),
'gryr': ('gry',),
'grys': ('gry',),
'grydde': ('gry',),
'grydd': ('gry',),
'gry': ('gry',),
'gryne': ('gryne',),
'gryner': ('gryne',),
'grynes': ('gryne',),
'grynte': ('gryne',),
'grynt': ('gryne',),
'gryn': ('gryne',),
'grynte': ('grynte',),
'grynter': ('grynte',),
'gryntes': ('grynte',),
'grynta': ('grynte',),
'gryntet': ('grynte',),
'grynta': ('grynte',),
'gryntet': ('grynte',),
'grynt': ('grynte',),
'gråle': ('gråle',),
'gråler': ('gråle',),
'gråles': ('gråle',),
'grålte': ('gråle',),
'grålt': ('gråle',),
'grål': ('gråle',),
'gråne': ('gråne',),
'gråner': ('gråne',),
'grånes': ('gråne',),
'gråna': ('gråne',),
'grånet': ('gråne',),
'gråna': ('gråne',),
'grånet': ('gråne',),
'grån': ('gråne',),
'gråte': ('gråte',),
'gråter': ('gråte',),
'gråtes': ('gråte',),
'gråt': ('gråte',),
'grått': ('gråte',),
'gråt': ('gråte',),
'grø': ('grø',),
'grør': ('grø',),
'grøs': ('grø',),
'grødde': ('grø',),
'grødd': ('grø',),
'grø': ('grø',),
'grøfte': ('grøfte',),
'grøfter': ('grøfte',),
'grøftes': ('grøfte',),
'grøfta': ('grøfte',),
'grøftet': ('grøfte',),
'grøfta': ('grøfte',),
'grøftet': ('grøfte',),
'grøft': ('grøfte',),
'grønke': ('grønke',),
'grønker': ('grønke',),
'grønkes': ('grønke',),
'grønka': ('grønke',),
'grønket': ('grønke',),
'grønka': ('grønke',),
'grønket': ('grønke',),
'grønk': ('grønke',),
'grønkes': ('grønkes',),
'grønktes': ('grønkes',),
'grønkes': ('grønkes',),
'grønnes': ('grønnes',),
'grøntes': ('grønnes',),
'grønnes': ('grønnes',),
'grønske': ('grønske',),
'grønsker': ('grønske',),
'grønskes': ('grønske',),
'grønska': ('grønske',),
'grønsket': ('grønske',),
'grønska': ('grønske',),
'grønsket': ('grønske',),
'grønsk': ('grønske',),
'grønske': ('grønske',),
'grønsk': ('grønske',),
'grønske': ('grønske',),
'grøppe': ('grøppe',),
'grøpper': ('grøppe',),
'grøppes': ('grøppe',),
'grøppet': ('grøppe',),
'grøpte': ('grøppe',),
'grøppet': ('grøppe',),
'grøpt': ('grøppe',),
'grøpp': ('grøppe',),
'grøsse': ('grøsse',),
'grøsser': ('grøsse',),
'grøsses': ('grøsse',),
'grøssa': ('grøsse',),
'grøsset': ('grøsse',),
'grøste': ('grøsse',),
'grøssa': ('grøsse',),
'grøsset': ('grøsse',),
'grøst': ('grøsse',),
'grøss': ('grøsse',),
'gufse': ('gufse',),
'gufser': ('gufse',),
'gufses': ('gufse',),
'gufsa': ('gufse',),
'gufset': ('gufse',),
'gufsa': ('gufse',),
'gufset': ('gufse',),
'gufs': ('gufse',),
'guide': ('guide',),
'guider': ('guide',),
'guides': ('guide',),
'guida': ('guide',),
'guidet': ('guide',),
'guida': ('guide',),
'guidet': ('guide',),
'guid': ('guide',),
'gule': ('gule',),
'guler': ('gule',),
'gules': ('gule',),
'gula': ('gule',),
'gulet': ('gule',),
'gula': ('gule',),
'gulet': ('gule',),
'gul': ('gule',),
'gulke': ('gulke',),
'gulker': ('gulke',),
'gulkes': ('gulke',),
'gulka': ('gulke',),
'gulket': ('gulke',),
'gulka': ('gulke',),
'gulket': ('gulke',),
'gulk': ('gulke',),
'gulne': ('gulne',),
'gulner': ('gulne',),
'gulnes': ('gulne',),
'gulna': ('gulne',),
'gulnet': ('gulne',),
'gulna': ('gulne',),
'gulnet': ('gulne',),
'guln': ('gulne',),
'gulne': ('gulne',),
'guln': ('gulne',),
'gulne': ('gulne',),
'gulpe': ('gulpe',),
'gulper': ('gulpe',),
'gulpes': ('gulpe',),
'gulpa': ('gulpe',),
'gulpet': ('gulpe',),
'gulpa': ('gulpe',),
'gulpet': ('gulpe',),
'gulp': ('gulpe',),
'gummiere': ('gummiere',),
'gummierer': ('gummiere',),
'gummieres': ('gummiere',),
'gummierte': ('gummiere',),
'gummiert': ('gummiere',),
'gummier': ('gummiere',),
'gurgle': ('gurgle',),
'gurgler': ('gurgle',),
'gurgles': ('gurgle',),
'gurgla': ('gurgle',),
'gurglet': ('gurgle',),
'gurgla': ('gurgle',),
'gurglet': ('gurgle',),
'gurgl': ('gurgle',),
'gurgle': ('gurgle',),
'gurgl': ('gurgle',),
'gurgle': ('gurgle',),
'gurpe': ('gurpe',),
'gurper': ('gurpe',),
'gurpes': ('gurpe',),
'gurpa': ('gurpe',),
'gurpet': ('gurpe',),
'gurpa': ('gurpe',),
'gurpet': ('gurpe',),
'gurp': ('gurpe',),
'guste': ('guste',),
'guster': ('guste',),
'gustes': ('guste',),
'gusta': ('guste',),
'gustet': ('guste',),
'gusta': ('guste',),
'gustet': ('guste',),
'gust': ('guste',),
'gutere': ('gutere',),
'guterer': ('gutere',),
'guteres': ('gutere',),
'guterte': ('gutere',),
'gutert': ('gutere',),
'guter': ('gutere',),
'gylle': ('gylle',),
'gyller': ('gylle',),
'gylles': ('gylle',),
'gyllet': ('gylle',),
'gylte': ('gylle',),
'gyllet': ('gylle',),
'gylt': ('gylle',),
'gyll': ('gylle',),
'gymnastisere': ('gymnastisere',),
'gymnastiserer': ('gymnastisere',),
'gymnastiseres': ('gymnastisere',),
'gymnastiserte': ('gymnastisere',),
'gymnastisert': ('gymnastisere',),
'gymnastiser': ('gymnastisere',),
'gynge': ('gynge',),
'gynger': ('gynge',),
'gynges': ('gynge',),
'gynga': ('gynge',),
'gynget': ('gynge',),
'gynga': ('gynge',),
'gynget': ('gynge',),
'gyng': ('gynge',),
'gyse': ('gyse',),
'gyser': ('gyse',),
'gyses': ('gyse',),
'gyste': ('gyse',),
'gjøs': ('gyse',),
'gyst': ('gyse',),
'gys': ('gyse',),
'gyte': ('gyte',),
'gyter': ('gyte',),
'gytes': ('gyte',),
'gytte': ('gyte',),
'gjøt': ('gyte',),
'gytt': ('gyte',),
'gyt': ('gyte',),
'gyve': ('gyve',),
'gyver': ('gyve',),
'gyves': ('gyve',),
'gjøv': ('gyve',),
'gøyv': ('gyve',),
'gjøv': ('gyve',),
'gøyv': ('gyve',),
'gjøv': ('gyve',),
'gjøvet': ('gyve',),
'gyvd': ('gyve',),
'gjøvet': ('gyve',),
'gyvd': ('gyve',),
'gyv': ('gyve',),
'gå': ('gå',),
'går': ('gå',),
'gås': ('gå',),
'gikk': ('gå',),
'gått': ('gå',),
'gå': ('gå',),
'gåre': ('gåre',),
'gårer': ('gåre',),
'gåres': ('gåre',),
'gåra': ('gåre',),
'gåret': ('gåre',),
'gåra': ('gåre',),
'gåret': ('gåre',),
'går': ('gåre',),
'gøyse': ('gøyse',),
'gøyser': ('gøyse',),
'gøyses': ('gøyse',),
'gøyste': ('gøyse',),
'gøyst': ('gøyse',),
'gøys': ('gøyse',),
'ha': ('ha',),
'har': ('ha',),
'has': ('ha',),
'hadde': ('ha',),
'hatt': ('ha',),
'ha': ('ha',),
'habilitere': ('habilitere',),
'habiliterer': ('habilitere',),
'habiliteres': ('habilitere',),
'habiliterte': ('habilitere',),
'habilitert': ('habilitere',),
'habiliter': ('habilitere',),
'hagle': ('hagle',),
'hagler': ('hagle',),
'hagles': ('hagle',),
'hagla': ('hagle',),
'haglet': ('hagle',),
'hagla': ('hagle',),
'haglet': ('hagle',),
'hagl': ('hagle',),
'hagle': ('hagle',),
'hagl': ('hagle',),
'hagle': ('hagle',),
'haike': ('haike',),
'haiker': ('haike',),
'haikes': ('haike',),
'haika': ('haike',),
'haiket': ('haike',),
'haika': ('haike',),
'haiket': ('haike',),
'haik': ('haike',),
'hake': ('hake',),
'haker': ('hake',),
'hakes': ('hake',),
'haka': ('hake',),
'haket': ('hake',),
'hakte': ('hake',),
'haka': ('hake',),
'haket': ('hake',),
'hakt': ('hake',),
'hak': ('hake',),
'hakke': ('hakke',),
'hakker': ('hakke',),
'hakkes': ('hakke',),
'hakka': ('hakke',),
'hakket': ('hakke',),
'hakka': ('hakke',),
'hakket': ('hakke',),
'hakk': ('hakke',),
'hale': ('hale',),
'haler': ('hale',),
'hales': ('hale',),
'hala': ('hale',),
'halet': ('hale',),
'halte': ('hale',),
'hala': ('hale',),
'halet': ('hale',),
'halt': ('hale',),
'hal': ('hale',),
'halle': ('halle',),
'haller': ('halle',),
'halles': ('halle',),
'halla': ('halle',),
'hallet': ('halle',),
'halla': ('halle',),
'hallet': ('halle',),
'hall': ('halle',),
'hallusinere': ('hallusinere',),
'hallusinerer': ('hallusinere',),
'hallusineres': ('hallusinere',),
'hallusinerte': ('hallusinere',),
'hallusinert': ('hallusinere',),
'hallusiner': ('hallusinere',),
'halse': ('halse',),
'halser': ('halse',),
'halses': ('halse',),
'halsa': ('halse',),
'halset': ('halse',),
'halsa': ('halse',),
'halset': ('halse',),
'hals': ('halse',),
'halte': ('halte',),
'halter': ('halte',),
'haltes': ('halte',),
'halta': ('halte',),
'haltet': ('halte',),
'halta': ('halte',),
'haltet': ('halte',),
'halt': ('halte',),
'halve': ('halve',),
'halver': ('halve',),
'halves': ('halve',),
'halva': ('halve',),
'halvet': ('halve',),
'halva': ('halve',),
'halvet': ('halve',),
'halv': ('halve',),
'halvere': ('halvere',),
'halverer': ('halvere',),
'halveres': ('halvere',),
'halverte': ('halvere',),
'halvert': ('halvere',),
'halver': ('halvere',),
'halvgardere': ('halvgardere',),
'halvgarderer': ('halvgardere',),
'halvgarderes': ('halvgardere',),
'halvgarderte': ('halvgardere',),
'halvgardert': ('halvgardere',),
'halvgarder': ('halvgardere',),
'halvklare': ('halvklare',),
'halvklarer': ('halvklare',),
'halvklares': ('halvklare',),
'halvklarte': ('halvklare',),
'halvklart': ('halvklare',),
'halvklar': ('halvklare',),
'halvsove': ('halvsove',),
'halvsover': ('halvsove',),
'halvsoves': ('halvsove',),
'halvsov': ('halvsove',),
'halvsovet': ('halvsove',),
'halvsov': ('halvsove',),
'halvsåle': ('halvsåle',),
'halvsåler': ('halvsåle',),
'halvsåles': ('halvsåle',),
'halvsåla': ('halvsåle',),
'halvsålet': ('halvsåle',),
'halvsålte': ('halvsåle',),
'halvsåla': ('halvsåle',),
'halvsålet': ('halvsåle',),
'halvsålt': ('halvsåle',),
'halvsål': ('halvsåle',),
'hamle': ('hamle',),
'hamler': ('hamle',),
'hamles': ('hamle',),
'hamla': ('hamle',),
'hamlet': ('hamle',),
'hamla': ('hamle',),
'hamlet': ('hamle',),
'haml': ('hamle',),
'hamle': ('hamle',),
'haml': ('hamle',),
'hamle': ('hamle',),
'hamne': ('hamne',),
'hamner': ('hamne',),
'hamnes': ('hamne',),
'hamna': ('hamne',),
'hamnet': ('hamne',),
'hamna': ('hamne',),
'hamnet': ('hamne',),
'hamn': ('hamne',),
'hamne': ('hamne',),
'hamn': ('hamne',),
'hamne': ('hamne',),
'hamre': ('hamre',),
'hamrer': ('hamre',),
'hamres': ('hamre',),
'hamra': ('hamre',),
'hamret': ('hamre',),
'hamra': ('hamre',),
'hamret': ('hamre',),
'hamr': ('hamre',),
'hamre': ('hamre',),
'hamr': ('hamre',),
'hamre': ('hamre',),
'hamse': ('hamse',),
'hamser': ('hamse',),
'hamses': ('hamse',),
'hamsa': ('hamse',),
'hamset': ('hamse',),
'hamsa': ('hamse',),
'hamset': ('hamse',),
'hams': ('hamse',),
'hamstre': ('hamstre',),
'hamstrer': ('hamstre',),
'hamstres': ('hamstre',),
'hamstra': ('hamstre',),
'hamstret': ('hamstre',),
'hamstra': ('hamstre',),
'hamstret': ('hamstre',),
'hamstr': ('hamstre',),
'hamstre': ('hamstre',),
'hamstr': ('hamstre',),
'hamstre': ('hamstre',),
'handfare': ('handfare',),
'handfarer': ('handfare',),
'handfares': ('handfare',),
'handfor': ('handfare',),
'handfart': ('handfare',),
'handfar': ('handfare',),
'handgi': ('handgi',),
'handgir': ('handgi',),
'handgis': ('handgi',),
'handgav': ('handgi',),
'handga': ('handgi',),
'handgitt': ('handgi',),
'handgi': ('handgi',),
'handheve': ('handheve',),
'handhever': ('handheve',),
'handheves': ('handheve',),
'handheva': ('handheve',),
'handhevet': ('handheve',),
'handhevde': ('handheve',),
'handheva': ('handheve',),
'handhevet': ('handheve',),
'handhevd': ('handheve',),
'handhev': ('handheve',),
'handhilse': ('handhilse',),
'handhilser': ('handhilse',),
'handhilses': ('handhilse',),
'handhilste': ('handhilse',),
'handhilst': ('handhilse',),
'handhils': ('handhilse',),
'handikappe': ('handikappe',),
'handikapper': ('handikappe',),
'handikappes': ('handikappe',),
'handikappa': ('handikappe',),
'handikappet': ('handikappe',),
'handikappa': ('handikappe',),
'handikappet': ('handikappe',),
'handikapp': ('handikappe',),
'handle': ('handle',),
'handler': ('handle',),
'handles': ('handle',),
'handla': ('handle',),
'handlet': ('handle',),
'handla': ('handle',),
'handlet': ('handle',),
'handl': ('handle',),
'handle': ('handle',),
'handl': ('handle',),
'handle': ('handle',),
'handplukke': ('handplukke',),
'handplukker': ('handplukke',),
'handplukkes': ('handplukke',),
'handplukka': ('handplukke',),
'handplukket': ('handplukke',),
'handplukka': ('handplukke',),
'handplukket': ('handplukke',),
'handplukk': ('handplukke',),
'handsame': ('handsame',),
'handsamer': ('handsame',),
'handsames': ('handsame',),
'handsama': ('handsame',),
'handsamet': ('handsame',),
'handsama': ('handsame',),
'handsamet': ('handsame',),
'handsam': ('handsame',),
'handse': ('handse',),
'handser': ('handse',),
'handses': ('handse',),
'handsa': ('handse',),
'handset': ('handse',),
'handsa': ('handse',),
'handset': ('handse',),
'hands': ('handse',),
'handse': ('handse',),
'hands': ('handse',),
'handse': ('handse',),
'handtere': ('handtere',),
'handterer': ('handtere',),
'handteres': ('handtere',),
'handterte': ('handtere',),
'handtert': ('handtere',),
'handter': ('handtere',),
'hangle': ('hangle',),
'hangler': ('hangle',),
'hangles': ('hangle',),
'hangla': ('hangle',),
'hanglet': ('hangle',),
'hangla': ('hangle',),
'hanglet': ('hangle',),
'hangl': ('hangle',),
'hangle': ('hangle',),
'hangl': ('hangle',),
'hangle': ('hangle',),
'hanskes': ('hanskes',),
'hanskedes': ('hanskes',),
'hanskes': ('hanskes',),
'hardkoke': ('hardkoke',),
'hardkoker': ('hardkoke',),
'hardkokes': ('hardkoke',),
'hardkokte': ('hardkoke',),
'hardkokt': ('hardkoke',),
'hardkok': ('hardkoke',),
'hardne': ('hardne',),
'hardner': ('hardne',),
'hardnes': ('hardne',),
'hardna': ('hardne',),
'hardnet': ('hardne',),
'hardna': ('hardne',),
'hardnet': ('hardne',),
'hardn': ('hardne',),
'hardne': ('hardne',),
'hardn': ('hardne',),
'hardne': ('hardne',),
'hardtrampe': ('hardtrampe',),
'hardtramper': ('hardtrampe',),
'hardtrampes': ('hardtrampe',),
'hardtrampa': ('hardtrampe',),
'hardtrampet': ('hardtrampe',),
'hardtrampa': ('hardtrampe',),
'hardtrampet': ('hardtrampe',),
'hardtramp': ('hardtrampe',),
'hardtrene': ('hardtrene',),
'hardtrener': ('hardtrene',),
'hardtrenes': ('hardtrene',),
'hardtrena': ('hardtrene',),
'hardtrenet': ('hardtrene',),
'hardtrente': ('hardtrene',),
'hardtrena': ('hardtrene',),
'hardtrenet': ('hardtrene',),
'hardtrent': ('hardtrene',),
'hardtren': ('hardtrene',),
'harke': ('harke',),
'harker': ('harke',),
'harkes': ('harke',),
'harka': ('harke',),
'harket': ('harke',),
'harka': ('harke',),
'harket': ('harke',),
'hark': ('harke',),
'harme': ('harme',),
'harmer': ('harme',),
'harmes': ('harme',),
'harma': ('harme',),
'harmet': ('harme',),
'harma': ('harme',),
'harmet': ('harme',),
'harm': ('harme',),
'harmonere': ('harmonere',),
'harmonerer': ('harmonere',),
'harmoneres': ('harmonere',),
'harmonerte': ('harmonere',),
'harmonert': ('harmonere',),
'harmoner': ('harmonere',),
'harmonisere': ('harmonisere',),
'harmoniserer': ('harmonisere',),
'harmoniseres': ('harmonisere',),
'harmoniserte': ('harmonisere',),
'harmonisert': ('harmonisere',),
'harmoniser': ('harmonisere',),
'harpe': ('harpe',),
'harper': ('harpe',),
'harpes': ('harpe',),
'harpa': ('harpe',),
'harpet': ('harpe',),
'harpa': ('harpe',),
'harpet': ('harpe',),
'harp': ('harpe',),
'harpunere': ('harpunere',),
'harpunerer': ('harpunere',),
'harpuneres': ('harpunere',),
'harpunerte': ('harpunere',),
'harpunert': ('harpunere',),
'harpuner': ('harpunere',),
'harselere': ('harselere',),
'harselerer': ('harselere',),
'harseleres': ('harselere',),
'harselerte': ('harselere',),
'harselert': ('harselere',),
'harseler': ('harselere',),
'harske': ('harske',),
'harsker': ('harske',),
'harskes': ('harske',),
'harska': ('harske',),
'harsket': ('harske',),
'harska': ('harske',),
'harsket': ('harske',),
'harsk': ('harske',),
'harskne': ('harskne',),
'harskner': ('harskne',),
'harsknes': ('harskne',),
'harskna': ('harskne',),
'harsknet': ('harskne',),
'harskna': ('harskne',),
'harsknet': ('harskne',),
'harskn': ('harskne',),
'harskne': ('harskne',),
'harskn': ('harskne',),
'harskne': ('harskne',),
'harve': ('harve',),
'harver': ('harve',),
'harves': ('harve',),
'harva': ('harve',),
'harvet': ('harve',),
'harva': ('harve',),
'harvet': ('harve',),
'harv': ('harve',),
'haspe': ('haspe',),
'hasper': ('haspe',),
'haspes': ('haspe',),
'haspa': ('haspe',),
'haspet': ('haspe',),
'haspa': ('haspe',),
'haspet': ('haspe',),
'hasp': ('haspe',),
'hasple': ('hasple',),
'haspler': ('hasple',),
'hasples': ('hasple',),
'haspla': ('hasple',),
'hasplet': ('hasple',),
'haspla': ('hasple',),
'hasplet': ('hasple',),
'haspl': ('hasple',),
'hasple': ('hasple',),
'haspl': ('hasple',),
'hasple': ('hasple',),
'haste': ('haste',),
'haster': ('haste',),
'hastes': ('haste',),
'hasta': ('haste',),
'hastet': ('haste',),
'hasta': ('haste',),
'hastet': ('haste',),
'hast': ('haste',),
'hate': ('hate',),
'hater': ('hate',),
'hates': ('hate',),
'hata': ('hate',),
'hatet': ('hate',),
'hata': ('hate',),
'hatet': ('hate',),
'hat': ('hate',),
'hauge': ('hauge',),
'hauger': ('hauge',),
'hauges': ('hauge',),
'hauga': ('hauge',),
'hauget': ('hauge',),
'hauga': ('hauge',),
'hauget': ('hauge',),
'haug': ('hauge',),
'hauglegge': ('hauglegge',),
'hauglegger': ('hauglegge',),
'hauglegges': ('hauglegge',),
'haugla': ('hauglegge',),
'hauglagt': ('hauglegge',),
'hauglegg': ('hauglegge',),
'haugta': ('haugta',),
'haugtar': ('haugta',),
'haugtas': ('haugta',),
'haugtok': ('haugta',),
'haugtatt': ('haugta',),
'haugta': ('haugta',),
'hauke': ('hauke',),
'hauker': ('hauke',),
'haukes': ('hauke',),
'hauka': ('hauke',),
'hauket': ('hauke',),
'hauka': ('hauke',),
'hauket': ('hauke',),
'hauk': ('hauke',),
'hausse': ('hausse',),
'hausser': ('hausse',),
'hausses': ('hausse',),
'haussa': ('hausse',),
'hausset': ('hausse',),
'haussa': ('hausse',),
'hausset': ('hausse',),
'hauss': ('hausse',),
'havarere': ('havarere',),
'havarerer': ('havarere',),
'havareres': ('havarere',),
'havarerte': ('havarere',),
'havarert': ('havarere',),
'havarer': ('havarere',),
'havne': ('havne',),
'havner': ('havne',),
'havnes': ('havne',),
'havna': ('havne',),
'havnet': ('havne',),
'havna': ('havne',),
'havnet': ('havne',),
'havn': ('havne',),
'heade': ('heade',),
'header': ('heade',),
'heades': ('heade',),
'heada': ('heade',),
'headet': ('heade',),
'heada': ('heade',),
'headet': ('heade',),
'head': ('heade',),
'hedre': ('hedre',),
'hedrer': ('hedre',),
'hedres': ('hedre',),
'hedra': ('hedre',),
'hedret': ('hedre',),
'hedra': ('hedre',),
'hedret': ('hedre',),
'hedr': ('hedre',),
'hedre': ('hedre',),
'hedr': ('hedre',),
'hedre': ('hedre',),
'hefte': ('hefte',),
'hefter': ('hefte',),
'heftes': ('hefte',),
'hefta': ('hefte',),
'heftet': ('hefte',),
'hefta': ('hefte',),
'heftet': ('hefte',),
'heft': ('hefte',),
'hegde': ('hegde',),
'hegder': ('hegde',),
'hegdes': ('hegde',),
'hegda': ('hegde',),
'hegdet': ('hegde',),
'hegda': ('hegde',),
'hegdet': ('hegde',),
'hegd': ('hegde',),
'hegne': ('hegne',),
'hegner': ('hegne',),
'hegnes': ('hegne',),
'hegna': ('hegne',),
'hegnet': ('hegne',),
'hegna': ('hegne',),
'hegnet': ('hegne',),
'hegn': ('hegne',),
'heie': ('heie',),
'heier': ('heie',),
'heies': ('heie',),
'heia': ('heie',),
'heiet': ('heie',),
'heia': ('heie',),
'heiet': ('heie',),
'hei': ('heie',),
'heilgardere': ('heilgardere',),
'heilgarderer': ('heilgardere',),
'heilgarderes': ('heilgardere',),
'heilgarderte': ('heilgardere',),
'heilgardert': ('heilgardere',),
'heilgarder': ('heilgardere',),
'heilsteike': ('heilsteike',),
'heilsteiker': ('heilsteike',),
'heilsteikes': ('heilsteike',),
'heilsteikte': ('heilsteike',),
'heilsteikt': ('heilsteike',),
'heilsteik': ('heilsteike',),
'heilsteke': ('heilsteke',),
'heilsteker': ('heilsteke',),
'heilstekes': ('heilsteke',),
'heilstekte': ('heilsteke',),
'heilstekt': ('heilsteke',),
'heilstek': ('heilsteke',),
'heilstøpe': ('heilstøpe',),
'heilstøper': ('heilstøpe',),
'heilstøpes': ('heilstøpe',),
'heilstøpte': ('heilstøpe',),
'heilstøpt': ('heilstøpe',),
'heilstøp': ('heilstøpe',),
'heilstøype': ('heilstøype',),
'heilstøyper': ('heilstøype',),
'heilstøypes': ('heilstøype',),
'heilstøypte': ('heilstøype',),
'heilstøypt': ('heilstøype',),
'heilstøyp': ('heilstøype',),
'heilsynkronisere': ('heilsynkronisere',),
'heilsynkroniserer': ('heilsynkronisere',),
'heilsynkroniseres': ('heilsynkronisere',),
'heilsynkroniserte': ('heilsynkronisere',),
'heilsynkronisert': ('heilsynkronisere',),
'heilsynkroniser': ('heilsynkronisere',),
'heime': ('heime',),
'heimer': ('heime',),
'heimes': ('heime',),
'heima': ('heime',),
'heimet': ('heime',),
'heima': ('heime',),
'heimet': ('heime',),
'heim': ('heime',),
'heimfalle': ('heimfalle',),
'heimfaller': ('heimfalle',),
'heimfalles': ('heimfalle',),
'heimfalt': ('heimfalle',),
'heimfall': ('heimfalle',),
'heimfeste': ('heimfeste',),
'heimfester': ('heimfeste',),
'heimfestes': ('heimfeste',),
'heimfesta': ('heimfeste',),
'heimfestet': ('heimfeste',),
'heimfesta': ('heimfeste',),
'heimfestet': ('heimfeste',),
'heimfest': ('heimfeste',),
'heimføre': ('heimføre',),
'heimfører': ('heimføre',),
'heimføres': ('heimføre',),
'heimførte': ('heimføre',),
'heimført': ('heimføre',),
'heimfør': ('heimføre',),
'heimkalle': ('heimkalle',),
'heimkaller': ('heimkalle',),
'heimkalles': ('heimkalle',),
'heimkalte': ('heimkalle',),
'heimkalt': ('heimkalle',),
'heimkall': ('heimkalle',),
'heimle': ('heimle',),
'heimler': ('heimle',),
'heimles': ('heimle',),
'heimla': ('heimle',),
'heimlet': ('heimle',),
'heimla': ('heimle',),
'heimlet': ('heimle',),
'heiml': ('heimle',),
'heimle': ('heimle',),
'heiml': ('heimle',),
'heimle': ('heimle',),
'heimsende': ('heimsende',),
'heimsender': ('heimsende',),
'heimsendes': ('heimsende',),
'heimsendte': ('heimsende',),
'heimsendt': ('heimsende',),
'heimsend': ('heimsende',),
'heimsøke': ('heimsøke',),
'heimsøker': ('heimsøke',),
'heimsøkes': ('heimsøke',),
'heimsøkte': ('heimsøke',),
'heimsøkt': ('heimsøke',),
'heimsøk': ('heimsøke',),
'heine': ('heine',),
'heiner': ('heine',),
'heines': ('heine',),
'heinte': ('heine',),
'heint': ('heine',),
'hein': ('heine',),
'heise': ('heise',),
'heiser': ('heise',),
'heises': ('heise',),
'heiste': ('heise',),
'heist': ('heise',),
'heis': ('heise',),
'heitne': ('heitne',),
'heitner': ('heitne',),
'heitnes': ('heitne',),
'heitna': ('heitne',),
'heitnet': ('heitne',),
'heitna': ('heitne',),
'heitnet': ('heitne',),
'heitn': ('heitne',),
'heitne': ('heitne',),
'heitn': ('heitne',),
'heitne': ('heitne',),
'hekke': ('hekke',),
'hekker': ('hekke',),
'hekkes': ('hekke',),
'hekka': ('hekke',),
'hekket': ('hekke',),
'hekka': ('hekke',),
'hekket': ('hekke',),
'hekk': ('hekke',),
'hekle': ('hekle',),
'hekler': ('hekle',),
'hekles': ('hekle',),
'hekla': ('hekle',),
'heklet': ('hekle',),
'hekla': ('hekle',),
'heklet': ('hekle',),
'hekl': ('hekle',),
'hekle': ('hekle',),
'hekl': ('hekle',),
'hekle': ('hekle',),
'hekse': ('hekse',),
'hekser': ('hekse',),
'hekses': ('hekse',),
'heksa': ('hekse',),
'hekset': ('hekse',),
'heksa': ('hekse',),
'hekset': ('hekse',),
'heks': ('hekse',),
'hekte': ('hekte',),
'hekter': ('hekte',),
'hektes': ('hekte',),
'hekta': ('hekte',),
'hektet': ('hekte',),
'hekta': ('hekte',),
'hektet': ('hekte',),
'hekt': ('hekte',),
'hektografere': ('hektografere',),
'hektograferer': ('hektografere',),
'hektograferes': ('hektografere',),
'hektograferte': ('hektografere',),
'hektografert': ('hektografere',),
'hektografer': ('hektografere',),
'helbrede': ('helbrede',),
'helbreder': ('helbrede',),
'helbredes': ('helbrede',),
'helbreda': ('helbrede',),
'helbredet': ('helbrede',),
'helbreda': ('helbrede',),
'helbredet': ('helbrede',),
'helbred': ('helbrede',),
'helde': ('helde',),
'helder': ('helde',),
'heldes': ('helde',),
'helda': ('helde',),
'heldet': ('helde',),
'helda': ('helde',),
'heldet': ('helde',),
'held': ('helde',),
'helgardere': ('helgardere',),
'helgarderer': ('helgardere',),
'helgarderes': ('helgardere',),
'helgarderte': ('helgardere',),
'helgardert': ('helgardere',),
'helgarder': ('helgardere',),
'helle': ('helle',),
'heller': ('helle',),
'helles': ('helle',),
'hellet': ('helle',),
'helte': ('helle',),
'hellet': ('helle',),
'helt': ('helle',),
'hell': ('helle',),
'hellelegge': ('hellelegge',),
'hellelegger': ('hellelegge',),
'hellelegges': ('hellelegge',),
'hellela': ('hellelegge',),
'hellelagt': ('hellelegge',),
'hellelegg': ('hellelegge',),
'hellige': ('hellige',),
'helliger': ('hellige',),
'helliges': ('hellige',),
'helliga': ('hellige',),
'helliget': ('hellige',),
'helliga': ('hellige',),
'helliget': ('hellige',),
'hellig': ('hellige',),
'helligholde': ('helligholde',),
'helligholder': ('helligholde',),
'helligholdes': ('helligholde',),
'helligholdt': ('helligholde',),
'hellighold': ('helligholde',),
'helseslå': ('helseslå',),
'helseslår': ('helseslå',),
'helseslås': ('helseslå',),
'helseslåes': ('helseslå',),
'helseslo': ('helseslå',),
'helseslått': ('helseslå',),
'helseslå': ('helseslå',),
'helsteike': ('helsteike',),
'helsteiker': ('helsteike',),
'helsteikes': ('helsteike',),
'helsteikte': ('helsteike',),
'helsteikt': ('helsteike',),
'helsteik': ('helsteike',),
'helsteke': ('helsteke',),
'helsteker': ('helsteke',),
'helstekes': ('helsteke',),
'helstekte': ('helsteke',),
'helstekt': ('helsteke',),
'helstek': ('helsteke',),
'helstøpe': ('helstøpe',),
'helstøper': ('helstøpe',),
'helstøpes': ('helstøpe',),
'helstøpte': ('helstøpe',),
'helstøpt': ('helstøpe',),
'helstøp': ('helstøpe',),
'helstøype': ('helstøype',),
'helstøyper': ('helstøype',),
'helstøypes': ('helstøype',),
'helstøypte': ('helstøype',),
'helstøypt': ('helstøype',),
'helstøyp': ('helstøype',),
'helsynkronisere': ('helsynkronisere',),
'helsynkroniserer': ('helsynkronisere',),
'helsynkroniseres': ('helsynkronisere',),
'helsynkroniserte': ('helsynkronisere',),
'helsynkronisert': ('helsynkronisere',),
'helsynkroniser': ('helsynkronisere',),
'hemme': ('hemme',),
'hemmer': ('hemme',),
'hemmes': ('hemme',),
'hemma': ('hemme',),
'hemmet': ('hemme',),
'hemma': ('hemme',),
'hemmet': ('hemme',),
'hem': ('hemme',),
'hemmeligholde': ('hemmeligholde',),
'hemmeligholder': ('hemmeligholde',),
'hemmeligholdes': ('hemmeligholde',),
'hemmeligholdt': ('hemmeligholde',),
'hemmelighold': ('hemmeligholde',),
'hemmeligstemple': ('hemmeligstemple',),
'hemmeligstempler': ('hemmeligstemple',),
'hemmeligstemples': ('hemmeligstemple',),
'hemmeligstempla': ('hemmeligstemple',),
'hemmeligstemplet': ('hemmeligstemple',),
'hemmeligstempla': ('hemmeligstemple',),
'hemmeligstemplet': ('hemmeligstemple',),
'hemmeligstempl': ('hemmeligstemple',),
'hemmeligstemple': ('hemmeligstemple',),
'hemmeligstempl': ('hemmeligstemple',),
'hemmeligstemple': ('hemmeligstemple',),
'hende': ('hende',),
'hender': ('hende',),
'hendes': ('hende',),
'hendte': ('hende',),
'hendt': ('hende',),
'hend': ('hende',),
'henføre': ('henføre',),
'henfører': ('henføre',),
'henføres': ('henføre',),
'henførte': ('henføre',),
'henført': ('henføre',),
'henfør': ('henføre',),
'hengi': ('hengi',),
'hengir': ('hengi',),
'hengis': ('hengi',),
'hengav': ('hengi',),
'henga': ('hengi',),
'hengitt': ('hengi',),
'hengi': ('hengi',),
'hengsle': ('hengsle',),
'hengsler': ('hengsle',),
'hengsles': ('hengsle',),
'hengsla': ('hengsle',),
'hengslet': ('hengsle',),
'hengsla': ('hengsle',),
'hengslet': ('hengsle',),
'hengsl': ('hengsle',),
'hengsle': ('hengsle',),
'hengsl': ('hengsle',),
'hengsle': ('hengsle',),
'henholde': ('henholde',),
'henholder': ('henholde',),
'henholdes': ('henholde',),
'henholdt': ('henholde',),
'henhold': ('henholde',),
'henhøre': ('henhøre',),
'henhører': ('henhøre',),
'henhøres': ('henhøre',),
'henhørte': ('henhøre',),
'henhørt': ('henhøre',),
'henhør': ('henhøre',),
'henkaste': ('henkaste',),
'henkaster': ('henkaste',),
'henkastes': ('henkaste',),
'henkasta': ('henkaste',),
'henkastet': ('henkaste',),
'henkasta': ('henkaste',),
'henkastet': ('henkaste',),
'henkast': ('henkaste',),
'henlede': ('henlede',),
'henleder': ('henlede',),
'henledes': ('henlede',),
'henleda': ('henlede',),
'henledet': ('henlede',),
'henleda': ('henlede',),
'henledet': ('henlede',),
'henled': ('henlede',),
'henlegge': ('henlegge',),
'henlegger': ('henlegge',),
'henlegges': ('henlegge',),
'henla': ('henlegge',),
'henlagt': ('henlegge',),
'henlegg': ('henlegge',),
'henrette': ('henrette',),
'henretter': ('henrette',),
'henrettes': ('henrette',),
'henretta': ('henrette',),
'henrettet': ('henrette',),
'henretta': ('henrette',),
'henrettet': ('henrette',),
'henrett': ('henrette',),
'henrykke': ('henrykke',),
'henrykker': ('henrykke',),
'henrykkes': ('henrykke',),
'henrykka': ('henrykke',),
'henrykket': ('henrykke',),
'henrykte': ('henrykke',),
'henrykka': ('henrykke',),
'henrykket': ('henrykke',),
'henrykt': ('henrykke',),
'henrykk': ('henrykke',),
'hensette': ('hensette',),
'hensetter': ('hensette',),
'hensettes': ('hensette',),
'hensatte': ('hensette',),
'hensatt': ('hensette',),
'hensett': ('hensette',),
'henskyte': ('henskyte',),
'henskyter': ('henskyte',),
'henskytes': ('henskyte',),
'henskjøt': ('henskyte',),
'henskøyt': ('henskyte',),
'henskutt': ('henskyte',),
'henskyt': ('henskyte',),
'henslepe': ('henslepe',),
'hensleper': ('henslepe',),
'henslepes': ('henslepe',),
'henslepte': ('henslepe',),
'henslept': ('henslepe',),
'henslep': ('henslepe',),
'henspille': ('henspille',),
'henspiller': ('henspille',),
'henspilles': ('henspille',),
'henspilte': ('henspille',),
'henspilt': ('henspille',),
'henspill': ('henspille',),
'henstille': ('henstille',),
'henstiller': ('henstille',),
'henstilles': ('henstille',),
'henstilte': ('henstille',),
'henstilt': ('henstille',),
'henstill': ('henstille',),
'hente': ('hente',),
'henter': ('hente',),
'hentes': ('hente',),
'henta': ('hente',),
'hentet': ('hente',),
'henta': ('hente',),
'hentet': ('hente',),
'hent': ('hente',),
'hentyde': ('hentyde',),
'hentyder': ('hentyde',),
'hentydes': ('hentyde',),
'hentyda': ('hentyde',),
'hentydet': ('hentyde',),
'hentyda': ('hentyde',),
'hentydet': ('hentyde',),
'hentyd': ('hentyde',),
'henvende': ('henvende',),
'henvender': ('henvende',),
'henvendes': ('henvende',),
'henvendte': ('henvende',),
'henvendt': ('henvende',),
'henvend': ('henvende',),
'henvise': ('henvise',),
'henviser': ('henvise',),
'henvises': ('henvise',),
'henviste': ('henvise',),
'henvist': ('henvise',),
'henvis': ('henvise',),
'heppe': ('heppe',),
'hepper': ('heppe',),
'heppes': ('heppe',),
'heppa': ('heppe',),
'heppet': ('heppe',),
'heppa': ('heppe',),
'heppet': ('heppe',),
'hepp': ('heppe',),
'herde': ('herde',),
'herder': ('herde',),
'herdes': ('herde',),
'herda': ('herde',),
'herdet': ('herde',),
'herda': ('herde',),
'herdet': ('herde',),
'herd': ('herde',),
'herdne': ('herdne',),
'herdner': ('herdne',),
'herdnes': ('herdne',),
'herdna': ('herdne',),
'herdnet': ('herdne',),
'herdna': ('herdne',),
'herdnet': ('herdne',),
'herdn': ('herdne',),
'herdne': ('herdne',),
'herdn': ('herdne',),
'herdne': ('herdne',),
'herje': ('herje',),
'herjer': ('herje',),
'herjes': ('herje',),
'herja': ('herje',),
'herjet': ('herje',),
'herja': ('herje',),
'herjet': ('herje',),
'herj': ('herje',),
'herliggjøre': ('herliggjøre',),
'herliggjør': ('herliggjøre',),
'herliggjøres': ('herliggjøre',),
'herliggjorde': ('herliggjøre',),
'herliggjort': ('herliggjøre',),
'herliggjør': ('herliggjøre',),
'herme': ('herme',),
'hermer': ('herme',),
'hermes': ('herme',),
'herma': ('herme',),
'hermet': ('herme',),
'hermte': ('herme',),
'herma': ('herme',),
'hermet': ('herme',),
'hermt': ('herme',),
'herm': ('herme',),
'hermetisere': ('hermetisere',),
'hermetiserer': ('hermetisere',),
'hermetiseres': ('hermetisere',),
'hermetiserte': ('hermetisere',),
'hermetisert': ('hermetisere',),
'hermetiser': ('hermetisere',),
'heroisere': ('heroisere',),
'heroiserer': ('heroisere',),
'heroiseres': ('heroisere',),
'heroiserte': ('heroisere',),
'heroisert': ('heroisere',),
'heroiser': ('heroisere',),
'herse': ('herse',),
'herser': ('herse',),
'herses': ('herse',),
'hersa': ('herse',),
'herset': ('herse',),
'hersa': ('herse',),
'herset': ('herse',),
'hers': ('herse',),
'herske': ('herske',),
'hersker': ('herske',),
'herskes': ('herske',),
'herska': ('herske',),
'hersket': ('herske',),
'herska': ('herske',),
'hersket': ('herske',),
'hersk': ('herske',),
'hesje': ('hesje',),
'hesjer': ('hesje',),
'hesjes': ('hesje',),
'hesja': ('hesje',),
'hesjet': ('hesje',),
'hesja': ('hesje',),
'hesjet': ('hesje',),
'hesj': ('hesje',),
'hespe': ('hespe',),
'hesper': ('hespe',),
'hespes': ('hespe',),
'hespa': ('hespe',),
'hespet': ('hespe',),
'hespa': ('hespe',),
'hespet': ('hespe',),
'hesp': ('hespe',),
'hesple': ('hesple',),
'hespler': ('hesple',),
'hesples': ('hesple',),
'hespla': ('hesple',),
'hesplet': ('hesple',),
'hespla': ('hesple',),
'hesplet': ('hesple',),
'hespl': ('hesple',),
'hesple': ('hesple',),
'hespl': ('hesple',),
'hesple': ('hesple',),
'hestehandle': ('hestehandle',),
'hestehandler': ('hestehandle',),
'hestehandles': ('hestehandle',),
'hestehandla': ('hestehandle',),
'hestehandlet': ('hestehandle',),
'hestehandla': ('hestehandle',),
'hestehandlet': ('hestehandle',),
'hestehandl': ('hestehandle',),
'hestehandle': ('hestehandle',),
'hestehandl': ('hestehandle',),
'hestehandle': ('hestehandle',),
'hete': ('hete',),
'heter': ('hete',),
'hetes': ('hete',),
'heta': ('hete',),
'hetet': ('hete',),
'heta': ('hete',),
'hetet': ('hete',),
'het': ('hete',),
'hete': ('hete',),
'heter': ('hete',),
'hetes': ('hete',),
'hette': ('hete',),
'het': ('hete',),
'hett': ('hete',),
'het': ('hete',),
'hetne': ('hetne',),
'hetner': ('hetne',),
'hetnes': ('hetne',),
'hetna': ('hetne',),
'hetnet': ('hetne',),
'hetna': ('hetne',),
'hetnet': ('hetne',),
'hetn': ('hetne',),
'hetne': ('hetne',),
'hetn': ('hetne',),
'hetne': ('hetne',),
'hetse': ('hetse',),
'hetser': ('hetse',),
'hetses': ('hetse',),
'hetsa': ('hetse',),
'hetset': ('hetse',),
'hetsa': ('hetse',),
'hetset': ('hetse',),
'hets': ('hetse',),
'hevde': ('hevde',),
'hevder': ('hevde',),
'hevdes': ('hevde',),
'hevda': ('hevde',),
'hevdet': ('hevde',),
'hevda': ('hevde',),
'hevdet': ('hevde',),
'hevd': ('hevde',),
'heve': ('heve',),
'hever': ('heve',),
'heves': ('heve',),
'heva': ('heve',),
'hevet': ('heve',),
'hevde': ('heve',),
'heva': ('heve',),
'hevet': ('heve',),
'hevd': ('heve',),
'hev': ('heve',),
'hevle': ('hevle',),
'hevler': ('hevle',),
'hevles': ('hevle',),
'hevla': ('hevle',),
'hevlet': ('hevle',),
'hevla': ('hevle',),
'hevlet': ('hevle',),
'hevl': ('hevle',),
'hevle': ('hevle',),
'hevl': ('hevle',),
'hevle': ('hevle',),
'hevne': ('hevne',),
'hevner': ('hevne',),
'hevnes': ('hevne',),
'hevna': ('hevne',),
'hevnet': ('hevne',),
'hevna': ('hevne',),
'hevnet': ('hevne',),
'hevn': ('hevne',),
'hie': ('hie',),
'hier': ('hie',),
'hies': ('hie',),
'hia': ('hie',),
'hiet': ('hie',),
'hia': ('hie',),
'hiet': ('hie',),
'hi': ('hie',),
'hige': ('hige',),
'higer': ('hige',),
'higes': ('hige',),
'higa': ('hige',),
'higet': ('hige',),
'higa': ('hige',),
'higet': ('hige',),
'hig': ('hige',),
'hikke': ('hikke',),
'hikker': ('hikke',),
'hikkes': ('hikke',),
'hikka': ('hikke',),
'hikket': ('hikke',),
'hikka': ('hikke',),
'hikket': ('hikke',),
'hikk': ('hikke',),
'hikste': ('hikste',),
'hikster': ('hikste',),
'hikstes': ('hikste',),
'hiksta': ('hikste',),
'hikstet': ('hikste',),
'hiksta': ('hikste',),
'hikstet': ('hikste',),
'hikst': ('hikste',),
'hikstegråte': ('hikstegråte',),
'hikstegråter': ('hikstegråte',),
'hikstegråtes': ('hikstegråte',),
'hikstegråt': ('hikstegråte',),
'hikstegrått': ('hikstegråte',),
'hikstegråt': ('hikstegråte',),
'hilde': ('hilde',),
'hilder': ('hilde',),
'hildes': ('hilde',),
'hilda': ('hilde',),
'hildet': ('hilde',),
'hilda': ('hilde',),
'hildet': ('hilde',),
'hild': ('hilde',),
'hildre': ('hildre',),
'hildrer': ('hildre',),
'hildres': ('hildre',),
'hildra': ('hildre',),
'hildret': ('hildre',),
'hildra': ('hildre',),
'hildret': ('hildre',),
'hildr': ('hildre',),
'hildre': ('hildre',),
'hildr': ('hildre',),
'hildre': ('hildre',),
'hilse': ('hilse',),
'hilser': ('hilse',),
'hilses': ('hilse',),
'hilste': ('hilse',),
'hilst': ('hilse',),
'hils': ('hilse',),
'himle': ('himle',),
'himler': ('himle',),
'himles': ('himle',),
'himla': ('himle',),
'himlet': ('himle',),
'himla': ('himle',),
'himlet': ('himle',),
'himl': ('himle',),
'himle': ('himle',),
'himl': ('himle',),
'himle': ('himle',),
'hindre': ('hindre',),
'hindrer': ('hindre',),
'hindres': ('hindre',),
'hindra': ('hindre',),
'hindret': ('hindre',),
'hindra': ('hindre',),
'hindret': ('hindre',),
'hindr': ('hindre',),
'hindre': ('hindre',),
'hindr': ('hindre',),
'hindre': ('hindre',),
'hinke': ('hinke',),
'hinker': ('hinke',),
'hinkes': ('hinke',),
'hinka': ('hinke',),
'hinket': ('hinke',),
'hinka': ('hinke',),
'hinket': ('hinke',),
'hink': ('hinke',),
'hipe': ('hipe',),
'hiper': ('hipe',),
'hipes': ('hipe',),
'hipa': ('hipe',),
'hipet': ('hipe',),
'hipte': ('hipe',),
'hipa': ('hipe',),
'hipet': ('hipe',),
'hipt': ('hipe',),
'hip': ('hipe',),
'hire': ('hire',),
'hirer': ('hire',),
'hires': ('hire',),
'hirte': ('hire',),
'hirt': ('hire',),
'hir': ('hire',),
'hisse': ('hisse',),
'hisser': ('hisse',),
'hisses': ('hisse',),
'hissa': ('hisse',),
'hisset': ('hisse',),
'hissa': ('hisse',),
'hisset': ('hisse',),
'hiss': ('hisse',),
'hitsette': ('hitsette',),
'hitsetter': ('hitsette',),
'hitsettes': ('hitsette',),
'hitsatte': ('hitsette',),
'hitsatt': ('hitsette',),
'hitsett': ('hitsette',),
'hitte': ('hitte',),
'hitter': ('hitte',),
'hittes': ('hitte',),
'hitta': ('hitte',),
'hittet': ('hitte',),
'hitta': ('hitte',),
'hittet': ('hitte',),
'hitt': ('hitte',),
'hive': ('hive',),
'hiver': ('hive',),
'hives': ('hive',),
'hivde': ('hive',),
'heiv': ('hive',),
'hev': ('hive',),
'hivd': ('hive',),
'hiv': ('hive',),
'hjelpe': ('hjelpe',),
'hjelper': ('hjelpe',),
'hjelpes': ('hjelpe',),
'hjalp': ('hjelpe',),
'hjulpet': ('hjelpe',),
'hjelp': ('hjelpe',),
'hjemfalle': ('hjemfalle',),
'hjemfaller': ('hjemfalle',),
'hjemfalles': ('hjemfalle',),
'hjemfalt': ('hjemfalle',),
'hjemfall': ('hjemfalle',),
'hjemfeste': ('hjemfeste',),
'hjemfester': ('hjemfeste',),
'hjemfestes': ('hjemfeste',),
'hjemfesta': ('hjemfeste',),
'hjemfestet': ('hjemfeste',),
'hjemfesta': ('hjemfeste',),
'hjemfestet': ('hjemfeste',),
'hjemfest': ('hjemfeste',),
'hjemføre': ('hjemføre',),
'hjemfører': ('hjemføre',),
'hjemføres': ('hjemføre',),
'hjemførte': ('hjemføre',),
'hjemført': ('hjemføre',),
'hjemfør': ('hjemføre',),
'hjemkalle': ('hjemkalle',),
'hjemkaller': ('hjemkalle',),
'hjemkalles': ('hjemkalle',),
'hjemkalte': ('hjemkalle',),
'hjemkalt': ('hjemkalle',),
'hjemkall': ('hjemkalle',),
'hjemle': ('hjemle',),
'hjemler': ('hjemle',),
'hjemles': ('hjemle',),
'hjemla': ('hjemle',),
'hjemlet': ('hjemle',),
'hjemla': ('hjemle',),
'hjemlet': ('hjemle',),
'hjeml': ('hjemle',),
'hjemle': ('hjemle',),
'hjeml': ('hjemle',),
'hjemle': ('hjemle',),
'hjemsende': ('hjemsende',),
'hjemsender': ('hjemsende',),
'hjemsendes': ('hjemsende',),
'hjemsendte': ('hjemsende',),
'hjemsendt': ('hjemsende',),
'hjemsend': ('hjemsende',),
'hjemsøke': ('hjemsøke',),
'hjemsøker': ('hjemsøke',),
'hjemsøkes': ('hjemsøke',),
'hjemsøkte': ('hjemsøke',),
'hjemsøkt': ('hjemsøke',),
'hjemsøk': ('hjemsøke',),
'hjernevaske': ('hjernevaske',),
'hjernevasker': ('hjernevaske',),
'hjernevaskes': ('hjernevaske',),
'hjernevaska': ('hjernevaske',),
'hjernevasket': ('hjernevaske',),
'hjernevaska': ('hjernevaske',),
'hjernevasket': ('hjernevaske',),
'hjernevask': ('hjernevaske',),
'hofferde': ('hofferde',),
'hofferder': ('hofferde',),
'hofferdes': ('hofferde',),
'hofferda': ('hofferde',),
'hofferdet': ('hofferde',),
'hofferda': ('hofferde',),
'hofferdet': ('hofferde',),
'hofferd': ('hofferde',),
'hoie': ('hoie',),
'hoier': ('hoie',),
'hoies': ('hoie',),
'hoia': ('hoie',),
'hoiet': ('hoie',),
'hoia': ('hoie',),
'hoiet': ('hoie',),
'hoi': ('hoie',),
'holde': ('holde',),
'holder': ('holde',),
'holdes': ('holde',),
'holdt': ('holde',),
'hold': ('holde',),
'hole': ('hole',),
'holer': ('hole',),
'holes': ('hole',),
'holte': ('hole',),
'holt': ('hole',),
'hol': ('hole',),
'holke': ('holke',),
'holker': ('holke',),
'holkes': ('holke',),
'holka': ('holke',),
'holket': ('holke',),
'holka': ('holke',),
'holket': ('holke',),
'holk': ('holke',),
'holne': ('holne',),
'holner': ('holne',),
'holnes': ('holne',),
'holna': ('holne',),
'holnet': ('holne',),
'holna': ('holne',),
'holnet': ('holne',),
'holn': ('holne',),
'holne': ('holne',),
'holn': ('holne',),
'holne': ('holne',),
'homme': ('homme',),
'hommer': ('homme',),
'hommes': ('homme',),
'homma': ('homme',),
'hommet': ('homme',),
'homma': ('homme',),
'hommet': ('homme',),
'hom': ('homme',),
'homogenisere': ('homogenisere',),
'homogeniserer': ('homogenisere',),
'homogeniseres': ('homogenisere',),
'homogeniserte': ('homogenisere',),
'homogenisert': ('homogenisere',),
'homogeniser': ('homogenisere',),
'honorere': ('honorere',),
'honorerer': ('honorere',),
'honoreres': ('honorere',),
'honorerte': ('honorere',),
'honorert': ('honorere',),
'honorer': ('honorere',),
'hope': ('hope',),
'hoper': ('hope',),
'hopes': ('hope',),
'hopa': ('hope',),
'hopet': ('hope',),
'hopa': ('hope',),
'hopet': ('hope',),
'hop': ('hope',),
'hoppe': ('hoppe',),
'hopper': ('hoppe',),
'hoppes': ('hoppe',),
'hoppa': ('hoppe',),
'hoppet': ('hoppe',),
'hoppa': ('hoppe',),
'hoppet': ('hoppe',),
'hopp': ('hoppe',),
'hore': ('hore',),
'horer': ('hore',),
'hores': ('hore',),
'hora': ('hore',),
'horet': ('hore',),
'horte': ('hore',),
'hora': ('hore',),
'horet': ('hore',),
'hort': ('hore',),
'hor': ('hore',),
'horse': ('horse',),
'horser': ('horse',),
'horses': ('horse',),
'horsa': ('horse',),
'horset': ('horse',),
'horsa': ('horse',),
'horset': ('horse',),
'hors': ('horse',),
'hospitalisere': ('hospitalisere',),
'hospitaliserer': ('hospitalisere',),
'hospitaliseres': ('hospitalisere',),
'hospitaliserte': ('hospitalisere',),
'hospitalisert': ('hospitalisere',),
'hospitaliser': ('hospitalisere',),
'hospitere': ('hospitere',),
'hospiterer': ('hospitere',),
'hospiteres': ('hospitere',),
'hospiterte': ('hospitere',),
'hospitert': ('hospitere',),
'hospiter': ('hospitere',),
'hoste': ('hoste',),
'hoster': ('hoste',),
'hostes': ('hoste',),
'hosta': ('hoste',),
'hostet': ('hoste',),
'hosta': ('hoste',),
'hostet': ('hoste',),
'host': ('hoste',),
'hote': ('hote',),
'hoter': ('hote',),
'hotes': ('hote',),
'hota': ('hote',),
'hotet': ('hote',),
'hota': ('hote',),
'hotet': ('hote',),
'hot': ('hote',),
'hovere': ('hovere',),
'hoverer': ('hovere',),
'hoveres': ('hovere',),
'hoverte': ('hovere',),
'hovert': ('hovere',),
'hover': ('hovere',),
'hovmesterere': ('hovmesterere',),
'hovmestererer': ('hovmesterere',),
'hovmestereres': ('hovmesterere',),
'hovmestererte': ('hovmesterere',),
'hovmesterert': ('hovmesterere',),
'hovmesterer': ('hovmesterere',),
'hovmode': ('hovmode',),
'hovmoder': ('hovmode',),
'hovmodes': ('hovmode',),
'hovmoda': ('hovmode',),
'hovmodet': ('hovmode',),
'hovmoda': ('hovmode',),
'hovmodet': ('hovmode',),
'hovmod': ('hovmode',),
'hovne': ('hovne',),
'hovner': ('hovne',),
'hovnes': ('hovne',),
'hovna': ('hovne',),
'hovnet': ('hovne',),
'hovna': ('hovne',),
'hovnet': ('hovne',),
'hovn': ('hovne',),
'hovne': ('hovne',),
'hovn': ('hovne',),
'hovne': ('hovne',),
'hudflette': ('hudflette',),
'hudfletter': ('hudflette',),
'hudflettes': ('hudflette',),
'hudfletta': ('hudflette',),
'hudflettet': ('hudflette',),
'hudfletta': ('hudflette',),
'hudflettet': ('hudflette',),
'hudflett': ('hudflette',),
'hudstryke': ('hudstryke',),
'hudstryker': ('hudstryke',),
'hudstrykes': ('hudstryke',),
'hudstrøyk': ('hudstryke',),
'hudstrøk': ('hudstryke',),
'hudstrøket': ('hudstryke',),
'hudstryk': ('hudstryke',),
'hufse': ('hufse',),
'hufser': ('hufse',),
'hufses': ('hufse',),
'hufsa': ('hufse',),
'hufset': ('hufse',),
'hufsa': ('hufse',),
'hufset': ('hufse',),
'hufs': ('hufse',),
'huge': ('huge',),
'huger': ('huge',),
'huges': ('huge',),
'huga': ('huge',),
'huget': ('huge',),
'huga': ('huge',),
'huget': ('huge',),
'hug': ('huge',),
'hugsvale': ('hugsvale',),
'hugsvaler': ('hugsvale',),
'hugsvales': ('hugsvale',),
'hugsvala': ('hugsvale',),
'hugsvalet': ('hugsvale',),
'hugsvalte': ('hugsvale',),
'hugsvala': ('hugsvale',),
'hugsvalet': ('hugsvale',),
'hugsvalt': ('hugsvale',),
'hugsval': ('hugsvale',),
'hugta': ('hugta',),
'hugtar': ('hugta',),
'hugtas': ('hugta',),
'hugtok': ('hugta',),
'hugtatt': ('hugta',),
'hugta': ('hugta',),
'huie': ('huie',),
'huier': ('huie',),
'huies': ('huie',),
'huia': ('huie',),
'huiet': ('huie',),
'huia': ('huie',),
'huiet': ('huie',),
'hui': ('huie',),
'huke': ('huke',),
'huker': ('huke',),
'hukes': ('huke',),
'huka': ('huke',),
'huket': ('huke',),
'hukte': ('huke',),
'huka': ('huke',),
'huket': ('huke',),
'hukt': ('huke',),
'huk': ('huke',),
'huke': ('huke',),
'huker': ('huke',),
'hukes': ('huke',),
'huka': ('huke',),
'huket': ('huke',),
'hukte': ('huke',),
'huka': ('huke',),
'huket': ('huke',),
'hukt': ('huke',),
'huk': ('huke',),
'hukre': ('hukre',),
'hukrer': ('hukre',),
'hukres': ('hukre',),
'hukra': ('hukre',),
'hukret': ('hukre',),
'hukra': ('hukre',),
'hukret': ('hukre',),
'hukr': ('hukre',),
'hukre': ('hukre',),
'hukr': ('hukre',),
'hukre': ('hukre',),
'hule': ('hule',),
'huler': ('hule',),
'hules': ('hule',),
'hulet': ('hule',),
'hulte': ('hule',),
'hulet': ('hule',),
'hult': ('hule',),
'hul': ('hule',),
'hulke': ('hulke',),
'hulker': ('hulke',),
'hulkes': ('hulke',),
'hulka': ('hulke',),
'hulket': ('hulke',),
'hulka': ('hulke',),
'hulket': ('hulke',),
'hulk': ('hulke',),
'hulle': ('hulle',),
'huller': ('hulle',),
'hulles': ('hulle',),
'hulla': ('hulle',),
'hullet': ('hulle',),
'hulla': ('hulle',),
'hullet': ('hulle',),
'hull': ('hulle',),
'humanisere': ('humanisere',),
'humaniserer': ('humanisere',),
'humaniseres': ('humanisere',),
'humaniserte': ('humanisere',),
'humanisert': ('humanisere',),
'humaniser': ('humanisere',),
'humpe': ('humpe',),
'humper': ('humpe',),
'humpes': ('humpe',),
'humpa': ('humpe',),
'humpet': ('humpe',),
'humpa': ('humpe',),
'humpet': ('humpe',),
'hump': ('humpe',),
'humre': ('humre',),
'humrer': ('humre',),
'humres': ('humre',),
'humra': ('humre',),
'humret': ('humre',),
'humra': ('humre',),
'humret': ('humre',),
'humr': ('humre',),
'humre': ('humre',),
'humr': ('humre',),
'humre': ('humre',),
'hundjage': ('hundjage',),
'hundjager': ('hundjage',),
'hundjages': ('hundjage',),
'hundjaga': ('hundjage',),
'hundjaget': ('hundjage',),
'hundjagde': ('hundjage',),
'hundjaga': ('hundjage',),
'hundjaget': ('hundjage',),
'hundjagd': ('hundjage',),
'hundjag': ('hundjage',),
'hundse': ('hundse',),
'hundser': ('hundse',),
'hundses': ('hundse',),
'hundsa': ('hundse',),
'hundset': ('hundse',),
'hundsa': ('hundse',),
'hundset': ('hundse',),
'hunds': ('hundse',),
'hundse': ('hundse',),
'hunds': ('hundse',),
'hundse': ('hundse',),
'hungre': ('hungre',),
'hungrer': ('hungre',),
'hungres': ('hungre',),
'hungra': ('hungre',),
'hungret': ('hungre',),
'hungra': ('hungre',),
'hungret': ('hungre',),
'hungr': ('hungre',),
'hungre': ('hungre',),
'hungr': ('hungre',),
'hungre': ('hungre',),
'hurpe': ('hurpe',),
'hurper': ('hurpe',),
'hurpes': ('hurpe',),
'hurpa': ('hurpe',),
'hurpet': ('hurpe',),
'hurpa': ('hurpe',),
'hurpet': ('hurpe',),
'hurp': ('hurpe',),
'hurre': ('hurre',),
'hurrer': ('hurre',),
'hurres': ('hurre',),
'hurra': ('hurre',),
'hurret': ('hurre',),
'hurra': ('hurre',),
'hurret': ('hurre',),
'hurr': ('hurre',),
'husbankfinansiere': ('husbankfinansiere',),
'husbankfinansierer': ('husbankfinansiere',),
'husbankfinansieres': ('husbankfinansiere',),
'husbankfinansierte': ('husbankfinansiere',),
'husbankfinansiert': ('husbankfinansiere',),
'husbankfinansier': ('husbankfinansiere',),
'huse': ('huse',),
'huser': ('huse',),
'huses': ('huse',),
'husa': ('huse',),
'huset': ('huse',),
'huste': ('huse',),
'husa': ('huse',),
'huset': ('huse',),
'hust': ('huse',),
'hus': ('huse',),
'husere': ('husere',),
'huserer': ('husere',),
'huseres': ('husere',),
'huserte': ('husere',),
'husert': ('husere',),
'huser': ('husere',),
'husholde': ('husholde',),
'husholder': ('husholde',),
'husholdes': ('husholde',),
'husholdt': ('husholde',),
'hushold': ('husholde',),
'husholdere': ('husholdere',),
'husholderer': ('husholdere',),
'husholderes': ('husholdere',),
'husholderte': ('husholdere',),
'husholdert': ('husholdere',),
'husholder': ('husholdere',),
'husholderere': ('husholderere',),
'husholdererer': ('husholderere',),
'husholdereres': ('husholderere',),
'husholdererte': ('husholderere',),
'husholderert': ('husholderere',),
'husholderer': ('husholderere',),
'huske': ('huske',),
'husker': ('huske',),
'huskes': ('huske',),
'huska': ('huske',),
'husket': ('huske',),
'huska': ('huske',),
'husket': ('huske',),
'husk': ('huske',),
'hustre': ('hustre',),
'hustrer': ('hustre',),
'hustres': ('hustre',),
'hustra': ('hustre',),
'hustret': ('hustre',),
'hustra': ('hustre',),
'hustret': ('hustre',),
'hustr': ('hustre',),
'hustre': ('hustre',),
'hustr': ('hustre',),
'hustre': ('hustre',),
'husvale': ('husvale',),
'husvaler': ('husvale',),
'husvales': ('husvale',),
'husvalte': ('husvale',),
'husvalt': ('husvale',),
'husval': ('husvale',),
'hute': ('hute',),
'huter': ('hute',),
'hutes': ('hute',),
'huta': ('hute',),
'hutet': ('hute',),
'huta': ('hute',),
'hutet': ('hute',),
'hut': ('hute',),
'hutre': ('hutre',),
'hutrer': ('hutre',),
'hutres': ('hutre',),
'hutra': ('hutre',),
'hutret': ('hutre',),
'hutra': ('hutre',),
'hutret': ('hutre',),
'hutr': ('hutre',),
'hutre': ('hutre',),
'hutr': ('hutre',),
'hutre': ('hutre',),
'hvelve': ('hvelve',),
'hvelver': ('hvelve',),
'hvelves': ('hvelve',),
'hvelva': ('hvelve',),
'hvelvet': ('hvelve',),
'hvelva': ('hvelve',),
'hvelvet': ('hvelve',),
'hvelv': ('hvelve',),
'hvese': ('hvese',),
'hveser': ('hvese',),
'hveses': ('hvese',),
'hveste': ('hvese',),
'hvest': ('hvese',),
'hves': ('hvese',),
'hvesse': ('hvesse',),
'hvesser': ('hvesse',),
'hvesses': ('hvesse',),
'hvesset': ('hvesse',),
'hvesste': ('hvesse',),
'hvesset': ('hvesse',),
'hvesst': ('hvesse',),
'hvess': ('hvesse',),
'hvile': ('hvile',),
'hviler': ('hvile',),
'hviles': ('hvile',),
'hvilte': ('hvile',),
'hvilt': ('hvile',),
'hvil': ('hvile',),
'hvine': ('hvine',),
'hviner': ('hvine',),
'hvines': ('hvine',),
'hvinte': ('hvine',),
'hvint': ('hvine',),
'hvin': ('hvine',),
'hviske': ('hviske',),
'hvisker': ('hviske',),
'hviskes': ('hviske',),
'hviska': ('hviske',),
'hvisket': ('hviske',),
'hviska': ('hviske',),
'hvisket': ('hviske',),
'hvisk': ('hviske',),
'hvitkalke': ('hvitkalke',),
'hvitkalker': ('hvitkalke',),
'hvitkalkes': ('hvitkalke',),
'hvitkalka': ('hvitkalke',),
'hvitkalket': ('hvitkalke',),
'hvitkalka': ('hvitkalke',),
'hvitkalket': ('hvitkalke',),
'hvitkalk': ('hvitkalke',),
'hvitne': ('hvitne',),
'hvitner': ('hvitne',),
'hvitnes': ('hvitne',),
'hvitna': ('hvitne',),
'hvitnet': ('hvitne',),
'hvitna': ('hvitne',),
'hvitnet': ('hvitne',),
'hvitn': ('hvitne',),
'hvitne': ('hvitne',),
'hvitn': ('hvitne',),
'hvitne': ('hvitne',),
'hvitte': ('hvitte',),
'hvitter': ('hvitte',),
'hvittes': ('hvitte',),
'hvitta': ('hvitte',),
'hvittet': ('hvitte',),
'hvitta': ('hvitte',),
'hvittet': ('hvitte',),
'hvitt': ('hvitte',),
'hvitvaske': ('hvitvaske',),
'hvitvasker': ('hvitvaske',),
'hvitvaskes': ('hvitvaske',),
'hvitvaska': ('hvitvaske',),
'hvitvasket': ('hvitvaske',),
'hvitvaska': ('hvitvaske',),
'hvitvasket': ('hvitvaske',),
'hvitvask': ('hvitvaske',),
'hygge': ('hygge',),
'hygger': ('hygge',),
'hygges': ('hygge',),
'hygga': ('hygge',),
'hygget': ('hygge',),
'hygde': ('hygge',),
'hygga': ('hygge',),
'hygget': ('hygge',),
'hygd': ('hygge',),
'hygg': ('hygge',),
'hykle': ('hykle',),
'hykler': ('hykle',),
'hykles': ('hykle',),
'hykla': ('hykle',),
'hyklet': ('hykle',),
'hykla': ('hykle',),
'hyklet': ('hykle',),
'hykl': ('hykle',),
'hykle': ('hykle',),
'hykl': ('hykle',),
'hykle': ('hykle',),
'hyle': ('hyle',),
'hyler': ('hyle',),
'hyles': ('hyle',),
'hylte': ('hyle',),
'hylt': ('hyle',),
'hyl': ('hyle',),
'hylle': ('hylle',),
'hyller': ('hylle',),
'hylles': ('hylle',),
'hylla': ('hylle',),
'hyllet': ('hylle',),
'hylla': ('hylle',),
'hyllet': ('hylle',),
'hyll': ('hylle',),
'hypnotisere': ('hypnotisere',),
'hypnotiserer': ('hypnotisere',),
'hypnotiseres': ('hypnotisere',),
'hypnotiserte': ('hypnotisere',),
'hypnotisert': ('hypnotisere',),
'hypnotiser': ('hypnotisere',),
'hyppe': ('hyppe',),
'hypper': ('hyppe',),
'hyppes': ('hyppe',),
'hyppa': ('hyppe',),
'hyppet': ('hyppe',),
'hyppa': ('hyppe',),
'hyppet': ('hyppe',),
'hypp': ('hyppe',),
'hyre': ('hyre',),
'hyrer': ('hyre',),
'hyres': ('hyre',),
'hyra': ('hyre',),
'hyret': ('hyre',),
'hyrte': ('hyre',),
'hyra': ('hyre',),
'hyret': ('hyre',),
'hyrt': ('hyre',),
'hyr': ('hyre',),
'hysje': ('hysje',),
'hysjer': ('hysje',),
'hysjes': ('hysje',),
'hysja': ('hysje',),
'hysjet': ('hysje',),
'hysja': ('hysje',),
'hysjet': ('hysje',),
'hysj': ('hysje',),
'hysse': ('hysse',),
'hysser': ('hysse',),
'hysses': ('hysse',),
'hyssa': ('hysse',),
'hysset': ('hysse',),
'hyssa': ('hysse',),
'hysset': ('hysse',),
'hyss': ('hysse',),
'hytte': ('hytte',),
'hytter': ('hytte',),
'hyttes': ('hytte',),
'hytta': ('hytte',),
'hyttet': ('hytte',),
'hytta': ('hytte',),
'hyttet': ('hytte',),
'hytt': ('hytte',),
'håndgi': ('håndgi',),
'håndgir': ('håndgi',),
'håndgis': ('håndgi',),
'håndgav': ('håndgi',),
'håndga': ('håndgi',),
'håndgitt': ('håndgi',),
'håndgi': ('håndgi',),
'håndheve': ('håndheve',),
'håndhever': ('håndheve',),
'håndheves': ('håndheve',),
'håndheva': ('håndheve',),
'håndhevet': ('håndheve',),
'håndhevde': ('håndheve',),
'håndheva': ('håndheve',),
'håndhevet': ('håndheve',),
'håndhevd': ('håndheve',),
'håndhev': ('håndheve',),
'håndhilse': ('håndhilse',),
'håndhilser': ('håndhilse',),
'håndhilses': ('håndhilse',),
'håndhilste': ('håndhilse',),
'håndhilst': ('håndhilse',),
'håndhils': ('håndhilse',),
'håndplukke': ('håndplukke',),
'håndplukker': ('håndplukke',),
'håndplukkes': ('håndplukke',),
'håndplukka': ('håndplukke',),
'håndplukket': ('håndplukke',),
'håndplukka': ('håndplukke',),
'håndplukket': ('håndplukke',),
'håndplukk': ('håndplukke',),
'håndtere': ('håndtere',),
'håndterer': ('håndtere',),
'håndteres': ('håndtere',),
'håndterte': ('håndtere',),
'håndtert': ('håndtere',),
'håndter': ('håndtere',),
'håne': ('håne',),
'håner': ('håne',),
'hånes': ('håne',),
'håna': ('håne',),
'hånet': ('håne',),
'hånte': ('håne',),
'håna': ('håne',),
'hånet': ('håne',),
'hånt': ('håne',),
'hån': ('håne',),
'hånflire': ('hånflire',),
'hånflirer': ('hånflire',),
'hånflires': ('hånflire',),
'hånflirte': ('hånflire',),
'hånflirt': ('hånflire',),
'hånflir': ('hånflire',),
'hånle': ('hånle',),
'hånler': ('hånle',),
'hånles': ('hånle',),
'hånlo': ('hånle',),
'hånledd': ('hånle',),
'hånle': ('hånle',),
'håpe': ('håpe',),
'håper': ('håpe',),
'håpes': ('håpe',),
'håpa': ('håpe',),
'håpet': ('håpe',),
'håpte': ('håpe',),
'håpa': ('håpe',),
'håpet': ('håpe',),
'håpt': ('håpe',),
'håp': ('håpe',),
'håve': ('håve',),
'håver': ('håve',),
'håves': ('håve',),
'håva': ('håve',),
'håvet': ('håve',),
'håva': ('håve',),
'håvet': ('håve',),
'håv': ('håve',),
'hæle': ('hæle',),
'hæler': ('hæle',),
'hæles': ('hæle',),
'hæla': ('hæle',),
'hælet': ('hæle',),
'hælte': ('hæle',),
'hæla': ('hæle',),
'hælet': ('hæle',),
'hælt': ('hæle',),
'hæl': ('hæle',),
'hælsparke': ('hælsparke',),
'hælsparker': ('hælsparke',),
'hælsparkes': ('hælsparke',),
'hælsparka': ('hælsparke',),
'hælsparket': ('hælsparke',),
'hælsparka': ('hælsparke',),
'hælsparket': ('hælsparke',),
'hælspark': ('hælsparke',),
'hærta': ('hærta',),
'hærtar': ('hærta',),
'hærtas': ('hærta',),
'hærtok': ('hærta',),
'hærtatt': ('hærta',),
'hærta': ('hærta',),
'høkre': ('høkre',),
'høkrer': ('høkre',),
'høkres': ('høkre',),
'høkra': ('høkre',),
'høkret': ('høkre',),
'høkra': ('høkre',),
'høkret': ('høkre',),
'høkr': ('høkre',),
'høkre': ('høkre',),
'høkr': ('høkre',),
'høkre': ('høkre',),
'hølje': ('hølje',),
'høljer': ('hølje',),
'høljes': ('hølje',),
'hølja': ('hølje',),
'høljet': ('hølje',),
'hølja': ('hølje',),
'høljet': ('hølje',),
'hølj': ('hølje',),
'høljeregne': ('høljeregne',),
'høljeregner': ('høljeregne',),
'høljeregnes': ('høljeregne',),
'høljeregna': ('høljeregne',),
'høljeregnet': ('høljeregne',),
'høljeregnte': ('høljeregne',),
'høljeregna': ('høljeregne',),
'høljeregnet': ('høljeregne',),
'høljeregnt': ('høljeregne',),
'høljeregn': ('høljeregne',),
'høljregne': ('høljregne',),
'høljregner': ('høljregne',),
'høljregnes': ('høljregne',),
'høljregna': ('høljregne',),
'høljregnet': ('høljregne',),
'høljregnte': ('høljregne',),
'høljregna': ('høljregne',),
'høljregnet': ('høljregne',),
'høljregnt': ('høljregne',),
'høljregn': ('høljregne',),
'høre': ('høre',),
'hører': ('høre',),
'høres': ('høre',),
'hørte': ('høre',),
'hørt': ('høre',),
'hør': ('høre',),
'høres': ('høres',),
'hørtes': ('høres',),
'høres': ('høres',),
'høste': ('høste',),
'høster': ('høste',),
'høstes': ('høste',),
'høsta': ('høste',),
'høstet': ('høste',),
'høsta': ('høste',),
'høstet': ('høste',),
'høst': ('høste',),
'høve': ('høve',),
'høver': ('høve',),
'høves': ('høve',),
'høvde': ('høve',),
'høvd': ('høve',),
'høv': ('høve',),
'høvle': ('høvle',),
'høvler': ('høvle',),
'høvles': ('høvle',),
'høvla': ('høvle',),
'høvlet': ('høvle',),
'høvla': ('høvle',),
'høvlet': ('høvle',),
'høvl': ('høvle',),
'høvle': ('høvle',),
'høvl': ('høvle',),
'høvle': ('høvle',),
'høye': ('høye',),
'høyer': ('høye',),
'høyes': ('høye',),
'høya': ('høye',),
'høyet': ('høye',),
'høya': ('høye',),
'høyet': ('høye',),
'høy': ('høye',),
'høyne': ('høyne',),
'høyner': ('høyne',),
'høynes': ('høyne',),
'høyna': ('høyne',),
'høynet': ('høyne',),
'høyna': ('høyne',),
'høynet': ('høyne',),
'høyn': ('høyne',),
'iaktta': ('iaktta',),
'iakttar': ('iaktta',),
'iakttas': ('iaktta',),
'iakttok': ('iaktta',),
'iakttatt': ('iaktta',),
'iaktta': ('iaktta',),
'iberegne': ('iberegne',),
'iberegner': ('iberegne',),
'iberegnes': ('iberegne',),
'iberegna': ('iberegne',),
'iberegnet': ('iberegne',),
'iberegna': ('iberegne',),
'iberegnet': ('iberegne',),
'iberegn': ('iberegne',),
'iblande': ('iblande',),
'iblander': ('iblande',),
'iblandes': ('iblande',),
'iblanda': ('iblande',),
'iblandet': ('iblande',),
'iblanda': ('iblande',),
'iblandet': ('iblande',),
'ibland': ('iblande',),
'idealisere': ('idealisere',),
'idealiserer': ('idealisere',),
'idealiseres': ('idealisere',),
'idealiserte': ('idealisere',),
'idealisert': ('idealisere',),
'idealiser': ('idealisere',),
'identifisere': ('identifisere',),
'identifiserer': ('identifisere',),
'identifiseres': ('identifisere',),
'identifiserte': ('identifisere',),
'identifisert': ('identifisere',),
'identifiser': ('identifisere',),
'ideologisere': ('ideologisere',),
'ideologiserer': ('ideologisere',),
'ideologiseres': ('ideologisere',),
'ideologiserte': ('ideologisere',),
'ideologisert': ('ideologisere',),
'ideologiser': ('ideologisere',),
'iddest': ('idest',),
'idest': ('idest',),
'ist': ('idest',),
'idest': ('idest',),
'ist': ('idest',),
'iddest': ('idest',),
'idest': ('idest',),
'idke': ('idke',),
'idker': ('idke',),
'idkes': ('idke',),
'idka': ('idke',),
'idket': ('idke',),
'idka': ('idke',),
'idket': ('idke',),
'idk': ('idke',),
'idke': ('idke',),
'idk': ('idke',),
'idke': ('idke',),
'idyllisere': ('idyllisere',),
'idylliserer': ('idyllisere',),
'idylliseres': ('idyllisere',),
'idylliserte': ('idyllisere',),
'idyllisert': ('idyllisere',),
'idylliser': ('idyllisere',),
'idømme': ('idømme',),
'idømmer': ('idømme',),
'idømmes': ('idømme',),
'idømte': ('idømme',),
'idømt': ('idømme',),
'idøm': ('idømme',),
'iføre': ('iføre',),
'ifører': ('iføre',),
'iføres': ('iføre',),
'iførte': ('iføre',),
'iført': ('iføre',),
'ifør': ('iføre',),
'igangsette': ('igangsette',),
'igangsetter': ('igangsette',),
'igangsettes': ('igangsette',),
'igangsatte': ('igangsette',),
'igangsatt': ('igangsette',),
'igangsett': ('igangsette',),
'ignorere': ('ignorere',),
'ignorerer': ('ignorere',),
'ignoreres': ('ignorere',),
'ignorerte': ('ignorere',),
'ignorert': ('ignorere',),
'ignorer': ('ignorere',),
'ihukomme': ('ihukomme',),
'ihukommer': ('ihukomme',),
'ihukommes': ('ihukomme',),
'ihukom': ('ihukomme',),
'ihukommet': ('ihukomme',),
'ihukom': ('ihukomme',),
'ikle': ('ikle',),
'ikler': ('ikle',),
'ikles': ('ikle',),
'ikledde': ('ikle',),
'ikledd': ('ikle',),
'ikle': ('ikle',),
'ilandføre': ('ilandføre',),
'ilandfører': ('ilandføre',),
'ilandføres': ('ilandføre',),
'ilandførte': ('ilandføre',),
'ilandført': ('ilandføre',),
'ilandfør': ('ilandføre',),
'ilde': ('ilde',),
'ilder': ('ilde',),
'ildes': ('ilde',),
'ilda': ('ilde',),
'ildet': ('ilde',),
'ilda': ('ilde',),
'ildet': ('ilde',),
'ild': ('ilde',),
'ildne': ('ildne',),
'ildner': ('ildne',),
'ildnes': ('ildne',),
'ildna': ('ildne',),
'ildnet': ('ildne',),
'ildna': ('ildne',),
'ildnet': ('ildne',),
'ildn': ('ildne',),
'ildne': ('ildne',),
'ildn': ('ildne',),
'ildne': ('ildne',),
'ile': ('ile',),
'iler': ('ile',),
'iles': ('ile',),
'ilte': ('ile',),
'ilt': ('ile',),
'il': ('ile',),
'ilegge': ('ilegge',),
'ilegger': ('ilegge',),
'ilegges': ('ilegge',),
'ila': ('ilegge',),
'ilagt': ('ilegge',),
'ilegg': ('ilegge',),
'iligne': ('iligne',),
'iligner': ('iligne',),
'ilignes': ('iligne',),
'iligna': ('iligne',),
'ilignet': ('iligne',),
'iligna': ('iligne',),
'ilignet': ('iligne',),
'ilign': ('iligne',),
'ilikne': ('ilikne',),
'ilikner': ('ilikne',),
'iliknes': ('ilikne',),
'ilikna': ('ilikne',),
'iliknet': ('ilikne',),
'ilikna': ('ilikne',),
'iliknet': ('ilikne',),
'ilikn': ('ilikne',),
'ilikne': ('ilikne',),
'ilikn': ('ilikne',),
'ilikne': ('ilikne',),
'illgjø': ('illgjø',),
'illgjør': ('illgjø',),
'illgjøs': ('illgjø',),
'illgjødde': ('illgjø',),
'illgjødd': ('illgjø',),
'illgjø': ('illgjø',),
'illhuie': ('illhuie',),
'illhuier': ('illhuie',),
'illhuies': ('illhuie',),
'illhuia': ('illhuie',),
'illhuiet': ('illhuie',),
'illhuia': ('illhuie',),
'illhuiet': ('illhuie',),
'illhui': ('illhuie',),
'illskrike': ('illskrike',),
'illskriker': ('illskrike',),
'illskrikes': ('illskrike',),
'illskrek': ('illskrike',),
'illskreik': ('illskrike',),
'illskrek': ('illskrike',),
'illskreik': ('illskrike',),
'illskreket': ('illskrike',),
'illskrik': ('illskrike',),
'illudere': ('illudere',),
'illuderer': ('illudere',),
'illuderes': ('illudere',),
'illuderte': ('illudere',),
'illudert': ('illudere',),
'illuder': ('illudere',),
'illuminere': ('illuminere',),
'illuminerer': ('illuminere',),
'illumineres': ('illuminere',),
'illuminerte': ('illuminere',),
'illuminert': ('illuminere',),
'illuminer': ('illuminere',),
'illustrere': ('illustrere',),
'illustrerer': ('illustrere',),
'illustreres': ('illustrere',),
'illustrerte': ('illustrere',),
'illustrert': ('illustrere',),
'illustrer': ('illustrere',),
'ilske': ('ilske',),
'ilsker': ('ilske',),
'ilskes': ('ilske',),
'ilska': ('ilske',),
'ilsket': ('ilske',),
'ilska': ('ilske',),
'ilsket': ('ilske',),
'ilsk': ('ilske',),
'ilskne': ('ilskne',),
'ilskner': ('ilskne',),
'ilsknes': ('ilskne',),
'ilskna': ('ilskne',),
'ilsknet': ('ilskne',),
'ilskna': ('ilskne',),
'ilsknet': ('ilskne',),
'ilskn': ('ilskne',),
'imaginere': ('imaginere',),
'imaginerer': ('imaginere',),
'imagineres': ('imaginere',),
'imaginerte': ('imaginere',),
'imaginert': ('imaginere',),
'imaginer': ('imaginere',),
'imitere': ('imitere',),
'imiterer': ('imitere',),
'imiteres': ('imitere',),
'imiterte': ('imitere',),
'imitert': ('imitere',),
'imiter': ('imitere',),
'immatrikulere': ('immatrikulere',),
'immatrikulerer': ('immatrikulere',),
'immatrikuleres': ('immatrikulere',),
'immatrikulerte': ('immatrikulere',),
'immatrikulert': ('immatrikulere',),
'immatrikuler': ('immatrikulere',),
'immigrere': ('immigrere',),
'immigrerer': ('immigrere',),
'immigreres': ('immigrere',),
'immigrerte': ('immigrere',),
'immigrert': ('immigrere',),
'immigrer': ('immigrere',),
'immortalisere': ('immortalisere',),
'immortaliserer': ('immortalisere',),
'immortaliseres': ('immortalisere',),
'immortaliserte': ('immortalisere',),
'immortalisert': ('immortalisere',),
'immortaliser': ('immortalisere',),
'immunisere': ('immunisere',),
'immuniserer': ('immunisere',),
'immuniseres': ('immunisere',),
'immuniserte': ('immunisere',),
'immunisert': ('immunisere',),
'immuniser': ('immunisere',),
'implantere': ('implantere',),
'implanterer': ('implantere',),
'implanteres': ('implantere',),
'implanterte': ('implantere',),
'implantert': ('implantere',),
'implanter': ('implantere',),
'implementere': ('implementere',),
'implementerer': ('implementere',),
'implementeres': ('implementere',),
'implementerte': ('implementere',),
'implementert': ('implementere',),
'implementer': ('implementere',),
'implisere': ('implisere',),
'impliserer': ('implisere',),
'impliseres': ('implisere',),
'impliserte': ('implisere',),
'implisert': ('implisere',),
'impliser': ('implisere',),
'implodere': ('implodere',),
'imploderer': ('implodere',),
'imploderes': ('implodere',),
'imploderte': ('implodere',),
'implodert': ('implodere',),
'imploder': ('implodere',),
'imponere': ('imponere',),
'imponerer': ('imponere',),
'imponeres': ('imponere',),
'imponerte': ('imponere',),
'imponert': ('imponere',),
'imponer': ('imponere',),
'importere': ('importere',),
'importerer': ('importere',),
'importeres': ('importere',),
'importerte': ('importere',),
'importert': ('importere',),
'importer': ('importere',),
'impregnere': ('impregnere',),
'impregnerer': ('impregnere',),
'impregneres': ('impregnere',),
'impregnerte': ('impregnere',),
'impregnert': ('impregnere',),
'impregner': ('impregnere',),
'improvisere': ('improvisere',),
'improviserer': ('improvisere',),
'improviseres': ('improvisere',),
'improviserte': ('improvisere',),
'improvisert': ('improvisere',),
'improviser': ('improvisere',),
'imøtegå': ('imøtegå',),
'imøtegår': ('imøtegå',),
'imøtegås': ('imøtegå',),
'imøtegikk': ('imøtegå',),
'imøtegått': ('imøtegå',),
'imøtegå': ('imøtegå',),
'imøtese': ('imøtese',),
'imøteser': ('imøtese',),
'imøteses': ('imøtese',),
'imøtesees': ('imøtese',),
'imøteså': ('imøtese',),
'imøtesett': ('imøtese',),
'imøtese': ('imøtese',),
'inaktivere': ('inaktivere',),
'inaktiverer': ('inaktivere',),
'inaktiveres': ('inaktivere',),
'inaktiverte': ('inaktivere',),
'inaktivert': ('inaktivere',),
'inaktiver': ('inaktivere',),
'inaugurere': ('inaugurere',),
'inaugurerer': ('inaugurere',),
'inaugureres': ('inaugurere',),
'inaugurerte': ('inaugurere',),
'inaugurert': ('inaugurere',),
'inaugurer': ('inaugurere',),
'incitere': ('incitere',),
'inciterer': ('incitere',),
'inciteres': ('incitere',),
'inciterte': ('incitere',),
'incitert': ('incitere',),
'inciter': ('incitere',),
'indikere': ('indikere',),
'indikerer': ('indikere',),
'indikeres': ('indikere',),
'indikerte': ('indikere',),
'indikert': ('indikere',),
'indiker': ('indikere',),
'individualisere': ('individualisere',),
'individualiserer': ('individualisere',),
'individualiseres': ('individualisere',),
'individualiserte': ('individualisere',),
'individualisert': ('individualisere',),
'individualiser': ('individualisere',),
'indoktrinere': ('indoktrinere',),
'indoktrinerer': ('indoktrinere',),
'indoktrineres': ('indoktrinere',),
'indoktrinerte': ('indoktrinere',),
'indoktrinert': ('indoktrinere',),
'indoktriner': ('indoktrinere',),
'indusere': ('indusere',),
'induserer': ('indusere',),
'induseres': ('indusere',),
'induserte': ('indusere',),
'indusert': ('indusere',),
'induser': ('indusere',),
'industrialisere': ('industrialisere',),
'industrialiserer': ('industrialisere',),
'industrialiseres': ('industrialisere',),
'industrialiserte': ('industrialisere',),
'industrialisert': ('industrialisere',),
'industrialiser': ('industrialisere',),
'infamere': ('infamere',),
'infamerer': ('infamere',),
'infameres': ('infamere',),
'infamerte': ('infamere',),
'infamert': ('infamere',),
'infamer': ('infamere',),
'infantilisere': ('infantilisere',),
'infantiliserer': ('infantilisere',),
'infantiliseres': ('infantilisere',),
'infantiliserte': ('infantilisere',),
'infantilisert': ('infantilisere',),
'infantiliser': ('infantilisere',),
'infiltrere': ('infiltrere',),
'infiltrerer': ('infiltrere',),
'infiltreres': ('infiltrere',),
'infiltrerte': ('infiltrere',),
'infiltrert': ('infiltrere',),
'infiltrer': ('infiltrere',),
'infisere': ('infisere',),
'infiserer': ('infisere',),
'infiseres': ('infisere',),
'infiserte': ('infisere',),
'infisert': ('infisere',),
'infiser': ('infisere',),
'inflammere': ('inflammere',),
'inflammerer': ('inflammere',),
'inflammeres': ('inflammere',),
'inflammerte': ('inflammere',),
'inflammert': ('inflammere',),
'inflammer': ('inflammere',),
'inflatere': ('inflatere',),
'inflaterer': ('inflatere',),
'inflateres': ('inflatere',),
'inflaterte': ('inflatere',),
'inflatert': ('inflatere',),
'inflater': ('inflatere',),
'influere': ('influere',),
'influerer': ('influere',),
'influeres': ('influere',),
'influerte': ('influere',),
'influert': ('influere',),
'influer': ('influere',),
'informere': ('informere',),
'informerer': ('informere',),
'informeres': ('informere',),
'informerte': ('informere',),
'informert': ('informere',),
'informer': ('informere',),
'inhalere': ('inhalere',),
'inhalerer': ('inhalere',),
'inhaleres': ('inhalere',),
'inhalerte': ('inhalere',),
'inhalert': ('inhalere',),
'inhaler': ('inhalere',),
'inherere': ('inherere',),
'inhererer': ('inherere',),
'inhereres': ('inherere',),
'inhererte': ('inherere',),
'inherert': ('inherere',),
'inherer': ('inherere',),
'inhibere': ('inhibere',),
'inhiberer': ('inhibere',),
'inhiberes': ('inhibere',),
'inhiberte': ('inhibere',),
'inhibert': ('inhibere',),
'inhiber': ('inhibere',),
'initiere': ('initiere',),
'initierer': ('initiere',),
'initieres': ('initiere',),
'initierte': ('initiere',),
'initiert': ('initiere',),
'initier': ('initiere',),
'injisere': ('injisere',),
'injiserer': ('injisere',),
'injiseres': ('injisere',),
'injiserte': ('injisere',),
'injisert': ('injisere',),
'injiser': ('injisere',),
'injuriere': ('injuriere',),
'injurierer': ('injuriere',),
'injurieres': ('injuriere',),
'injurierte': ('injuriere',),
'injuriert': ('injuriere',),
'injurier': ('injuriere',),
'inkarnere': ('inkarnere',),
'inkarnerer': ('inkarnere',),
'inkarneres': ('inkarnere',),
'inkarnerte': ('inkarnere',),
'inkarnert': ('inkarnere',),
'inkarner': ('inkarnere',),
'inklinere': ('inklinere',),
'inklinerer': ('inklinere',),
'inklineres': ('inklinere',),
'inklinerte': ('inklinere',),
'inklinert': ('inklinere',),
'inkliner': ('inklinere',),
'inkludere': ('inkludere',),
'inkluderer': ('inkludere',),
'inkluderes': ('inkludere',),
'inkluderte': ('inkludere',),
'inkludert': ('inkludere',),
'inkluder': ('inkludere',),
'inkorporere': ('inkorporere',),
'inkorporerer': ('inkorporere',),
'inkorporeres': ('inkorporere',),
'inkorporerte': ('inkorporere',),
'inkorporert': ('inkorporere',),
'inkorporer': ('inkorporere',),
'innanke': ('innanke',),
'innanker': ('innanke',),
'innankes': ('innanke',),
'innanka': ('innanke',),
'innanket': ('innanke',),
'innanka': ('innanke',),
'innanket': ('innanke',),
'innank': ('innanke',),
'innarbeide': ('innarbeide',),
'innarbeider': ('innarbeide',),
'innarbeides': ('innarbeide',),
'innarbeida': ('innarbeide',),
'innarbeidet': ('innarbeide',),
'innarbeidde': ('innarbeide',),
'innarbeida': ('innarbeide',),
'innarbeidet': ('innarbeide',),
'innarbeidd': ('innarbeide',),
'innarbeid': ('innarbeide',),
'innbefatte': ('innbefatte',),
'innbefatter': ('innbefatte',),
'innbefattes': ('innbefatte',),
'innbefatta': ('innbefatte',),
'innbefattet': ('innbefatte',),
'innbefatta': ('innbefatte',),
'innbefattet': ('innbefatte',),
'innbefatt': ('innbefatte',),
'innberette': ('innberette',),
'innberetter': ('innberette',),
'innberettes': ('innberette',),
'innberetta': ('innberette',),
'innberettet': ('innberette',),
'innberetta': ('innberette',),
'innberettet': ('innberette',),
'innberett': ('innberette',),
'innbetale': ('innbetale',),
'innbetaler': ('innbetale',),
'innbetales': ('innbetale',),
'innbetalte': ('innbetale',),
'innbetalt': ('innbetale',),
'innbetal': ('innbetale',),
'innbille': ('innbille',),
'innbiller': ('innbille',),
'innbilles': ('innbille',),
'innbilte': ('innbille',),
'innbilt': ('innbille',),
'innbill': ('innbille',),
'innbinde': ('innbinde',),
'innbinder': ('innbinde',),
'innbindes': ('innbinde',),
'innbandt': ('innbinde',),
'innbundet': ('innbinde',),
'innbind': ('innbinde',),
'innblande': ('innblande',),
'innblander': ('innblande',),
'innblandes': ('innblande',),
'innblanda': ('innblande',),
'innblandet': ('innblande',),
'innblanda': ('innblande',),
'innblandet': ('innblande',),
'innbland': ('innblande',),
'innbringe': ('innbringe',),
'innbringer': ('innbringe',),
'innbringes': ('innbringe',),
'innbrakte': ('innbringe',),
'innbrakt': ('innbringe',),
'innbring': ('innbringe',),
'innby': ('innby',),
'innbyr': ('innby',),
'innbys': ('innby',),
'innbydde': ('innby',),
'innbød': ('innby',),
'innbøy': ('innby',),
'innbydd': ('innby',),
'innbudt': ('innby',),
'innbydd': ('innby',),
'innby': ('innby',),
'inndampe': ('inndampe',),
'inndamper': ('inndampe',),
'inndampes': ('inndampe',),
'inndampa': ('inndampe',),
'inndampet': ('inndampe',),
'inndampa': ('inndampe',),
'inndampet': ('inndampe',),
'inndamp': ('inndampe',),
'inndele': ('inndele',),
'inndeler': ('inndele',),
'inndeles': ('inndele',),
'inndelte': ('inndele',),
'inndelt': ('inndele',),
'inndel': ('inndele',),
'inndra': ('inndra',),
'inndrar': ('inndra',),
'inndras': ('inndra',),
'inndrog': ('inndra',),
'inndro': ('inndra',),
'inndradd': ('inndra',),
'inndratt': ('inndra',),
'inndradd': ('inndra',),
'inndratt': ('inndra',),
'inndra': ('inndra',),
'inndrive': ('inndrive',),
'inndriver': ('inndrive',),
'inndrives': ('inndrive',),
'inndrev': ('inndrive',),
'inndreiv': ('inndrive',),
'inndrev': ('inndrive',),
'inndreiv': ('inndrive',),
'inndrevet': ('inndrive',),
'inndriv': ('inndrive',),
'innebære': ('innebære',),
'innebærer': ('innebære',),
'innebæres': ('innebære',),
'innebar': ('innebære',),
'innebåret': ('innebære',),
'innebær': ('innebære',),
'inneha': ('inneha',),
'innehar': ('inneha',),
'innehas': ('inneha',),
'innehadde': ('inneha',),
'innehatt': ('inneha',),
'inneha': ('inneha',),
'inneholde': ('inneholde',),
'inneholder': ('inneholde',),
'inneholdes': ('inneholde',),
'inneholdt': ('inneholde',),
'innehold': ('inneholde',),
'inneksersere': ('inneksersere',),
'innekserserer': ('inneksersere',),
'innekserseres': ('inneksersere',),
'innekserserte': ('inneksersere',),
'inneksersert': ('inneksersere',),
'innekserser': ('inneksersere',),
'innfatte': ('innfatte',),
'innfatter': ('innfatte',),
'innfattes': ('innfatte',),
'innfatta': ('innfatte',),
'innfattet': ('innfatte',),
'innfatta': ('innfatte',),
'innfattet': ('innfatte',),
'innfatt': ('innfatte',),
'innfelle': ('innfelle',),
'innfeller': ('innfelle',),
'innfelles': ('innfelle',),
'innfelte': ('innfelle',),
'innfelt': ('innfelle',),
'innfell': ('innfelle',),
'innfiltre': ('innfiltre',),
'innfiltrer': ('innfiltre',),
'innfiltres': ('innfiltre',),
'innfiltra': ('innfiltre',),
'innfiltret': ('innfiltre',),
'innfiltra': ('innfiltre',),
'innfiltret': ('innfiltre',),
'innfiltr': ('innfiltre',),
'innfiltre': ('innfiltre',),
'innfiltr': ('innfiltre',),
'innfiltre': ('innfiltre',),
'innfinne': ('innfinne',),
'innfinner': ('innfinne',),
'innfinnes': ('innfinne',),
'innfant': ('innfinne',),
'innfunnet': ('innfinne',),
'innfinn': ('innfinne',),
'innforlive': ('innforlive',),
'innforliver': ('innforlive',),
'innforlives': ('innforlive',),
'innforliva': ('innforlive',),
'innforlivet': ('innforlive',),
'innforliva': ('innforlive',),
'innforlivet': ('innforlive',),
'innforliv': ('innforlive',),
'innfri': ('innfri',),
'innfrir': ('innfri',),
'innfris': ('innfri',),
'innfridde': ('innfri',),
'innfridd': ('innfri',),
'innfri': ('innfri',),
'innføre': ('innføre',),
'innfører': ('innføre',),
'innføres': ('innføre',),
'innførte': ('innføre',),
'innført': ('innføre',),
'innfør': ('innføre',),
'innføye': ('innføye',),
'innføyer': ('innføye',),
'innføyes': ('innføye',),
'innføyet': ('innføye',),
'innføyde': ('innføye',),
'innføyet': ('innføye',),
'innføyd': ('innføye',),
'innføy': ('innføye',),
'inngi': ('inngi',),
'inngir': ('inngi',),
'inngis': ('inngi',),
'inngav': ('inngi',),
'innga': ('inngi',),
'inngitt': ('inngi',),
'inngi': ('inngi',),
'inngifte': ('inngifte',),
'inngifter': ('inngifte',),
'inngiftes': ('inngifte',),
'inngifta': ('inngifte',),
'inngiftet': ('inngifte',),
'inngifta': ('inngifte',),
'inngiftet': ('inngifte',),
'inngift': ('inngifte',),
'inngjerde': ('inngjerde',),
'inngjerder': ('inngjerde',),
'inngjerdes': ('inngjerde',),
'inngjerda': ('inngjerde',),
'inngjerdet': ('inngjerde',),
'inngjerda': ('inngjerde',),
'inngjerdet': ('inngjerde',),
'inngjerd': ('inngjerde',),
'inngravere': ('inngravere',),
'inngraverer': ('inngravere',),
'inngraveres': ('inngravere',),
'inngraverte': ('inngravere',),
'inngravert': ('inngravere',),
'inngraver': ('inngravere',),
'inngyte': ('inngyte',),
'inngyter': ('inngyte',),
'inngytes': ('inngyte',),
'inngytte': ('inngyte',),
'inngjøt': ('inngyte',),
'inngytt': ('inngyte',),
'inngyt': ('inngyte',),
'inngå': ('inngå',),
'inngår': ('inngå',),
'inngås': ('inngå',),
'inngikk': ('inngå',),
'inngått': ('inngå',),
'inngå': ('inngå',),
'innhegne': ('innhegne',),
'innhegner': ('innhegne',),
'innhegnes': ('innhegne',),
'innhegna': ('innhegne',),
'innhegnet': ('innhegne',),
'innhegna': ('innhegne',),
'innhegnet': ('innhegne',),
'innhegn': ('innhegne',),
'innhente': ('innhente',),
'innhenter': ('innhente',),
'innhentes': ('innhente',),
'innhenta': ('innhente',),
'innhentet': ('innhente',),
'innhenta': ('innhente',),
'innhentet': ('innhente',),
'innhent': ('innhente',),
'innhylle': ('innhylle',),
'innhyller': ('innhylle',),
'innhylles': ('innhylle',),
'innhylla': ('innhylle',),
'innhyllet': ('innhylle',),
'innhylla': ('innhylle',),
'innhyllet': ('innhylle',),
'innhyll': ('innhylle',),
'innhøste': ('innhøste',),
'innhøster': ('innhøste',),
'innhøstes': ('innhøste',),
'innhøsta': ('innhøste',),
'innhøstet': ('innhøste',),
'innhøsta': ('innhøste',),
'innhøstet': ('innhøste',),
'innhøst': ('innhøste',),
'innkalkulere': ('innkalkulere',),
'innkalkulerer': ('innkalkulere',),
'innkalkuleres': ('innkalkulere',),
'innkalkulerte': ('innkalkulere',),
'innkalkulert': ('innkalkulere',),
'innkalkuler': ('innkalkulere',),
'innkalle': ('innkalle',),
'innkaller': ('innkalle',),
'innkalles': ('innkalle',),
'innkalte': ('innkalle',),
'innkalt': ('innkalle',),
'innkall': ('innkalle',),
'innkapsle': ('innkapsle',),
'innkapsler': ('innkapsle',),
'innkapsles': ('innkapsle',),
'innkapsla': ('innkapsle',),
'innkapslet': ('innkapsle',),
'innkapsla': ('innkapsle',),
'innkapslet': ('innkapsle',),
'innkapsl': ('innkapsle',),
'innkapsle': ('innkapsle',),
'innkapsl': ('innkapsle',),
'innkapsle': ('innkapsle',),
'innkassere': ('innkassere',),
'innkasserer': ('innkassere',),
'innkasseres': ('innkassere',),
'innkasserte': ('innkassere',),
'innkassert': ('innkassere',),
'innkasser': ('innkassere',),
'innkaste': ('innkaste',),
'innkaster': ('innkaste',),
'innkastes': ('innkaste',),
'innkasta': ('innkaste',),
'innkastet': ('innkaste',),
'innkasta': ('innkaste',),
'innkastet': ('innkaste',),
'innkast': ('innkaste',),
'innkjøre': ('innkjøre',),
'innkjører': ('innkjøre',),
'innkjøres': ('innkjøre',),
'innkjørte': ('innkjøre',),
'innkjørt': ('innkjøre',),
'innkjør': ('innkjøre',),
'innklage': ('innklage',),
'innklager': ('innklage',),
'innklages': ('innklage',),
'innklaga': ('innklage',),
'innklaget': ('innklage',),
'innklagde': ('innklage',),
'innklaga': ('innklage',),
'innklaget': ('innklage',),
'innklagd': ('innklage',),
'innklag': ('innklage',),
'innklarere': ('innklarere',),
'innklarerer': ('innklarere',),
'innklareres': ('innklarere',),
'innklarerte': ('innklarere',),
'innklarert': ('innklarere',),
'innklarer': ('innklarere',),
'innkoble': ('innkoble',),
'innkobler': ('innkoble',),
'innkobles': ('innkoble',),
'innkobla': ('innkoble',),
'innkoblet': ('innkoble',),
'innkobla': ('innkoble',),
'innkoblet': ('innkoble',),
'innkobl': ('innkoble',),
'innkoble': ('innkoble',),
'innkobl': ('innkoble',),
'innkoble': ('innkoble',),
'innkommandere': ('innkommandere',),
'innkommanderer': ('innkommandere',),
'innkommanderes': ('innkommandere',),
'innkommanderte': ('innkommandere',),
'innkommandert': ('innkommandere',),
'innkommander': ('innkommandere',),
'innkomme': ('innkomme',),
'innkommer': ('innkomme',),
'innkommes': ('innkomme',),
'innkom': ('innkomme',),
'innkommet': ('innkomme',),
'innkom': ('innkomme',),
'innkople': ('innkople',),
'innkopler': ('innkople',),
'innkoples': ('innkople',),
'innkopla': ('innkople',),
'innkoplet': ('innkople',),
'innkopla': ('innkople',),
'innkoplet': ('innkople',),
'innkopl': ('innkople',),
'innkople': ('innkople',),
'innkopl': ('innkople',),
'innkople': ('innkople',),
'innkorte': ('innkorte',),
'innkorter': ('innkorte',),
'innkortes': ('innkorte',),
'innkorta': ('innkorte',),
'innkortet': ('innkorte',),
'innkorta': ('innkorte',),
'innkortet': ('innkorte',),
'innkort': ('innkorte',),
'innkreve': ('innkreve',),
'innkrever': ('innkreve',),
'innkreves': ('innkreve',),
'innkrevet': ('innkreve',),
'innkrevde': ('innkreve',),
'innkrevet': ('innkreve',),
'innkrevd': ('innkreve',),
'innkrev': ('innkreve',),
'innkvartere': ('innkvartere',),
'innkvarterer': ('innkvartere',),
'innkvarteres': ('innkvartere',),
'innkvarterte': ('innkvartere',),
'innkvartert': ('innkvartere',),
'innkvarter': ('innkvartere',),
'innlate': ('innlate',),
'innlater': ('innlate',),
'innlates': ('innlate',),
'innlot': ('innlate',),
'innlatt': ('innlate',),
'innlat': ('innlate',),
'innlede': ('innlede',),
'innleder': ('innlede',),
'innledes': ('innlede',),
'innleda': ('innlede',),
'innledet': ('innlede',),
'innleda': ('innlede',),
'innledet': ('innlede',),
'innled': ('innlede',),
'innlegge': ('innlegge',),
'innlegger': ('innlegge',),
'innlegges': ('innlegge',),
'innla': ('innlegge',),
'innlagt': ('innlegge',),
'innlegg': ('innlegge',),
'innleie': ('innleie',),
'innleier': ('innleie',),
'innleies': ('innleie',),
'innleide': ('innleie',),
'innleid': ('innleie',),
'innlei': ('innleie',),
'innlemme': ('innlemme',),
'innlemmer': ('innlemme',),
'innlemmes': ('innlemme',),
'innlemma': ('innlemme',),
'innlemmet': ('innlemme',),
'innlemma': ('innlemme',),
'innlemmet': ('innlemme',),
'innlem': ('innlemme',),
'innlese': ('innlese',),
'innleser': ('innlese',),
'innleses': ('innlese',),
'innleste': ('innlese',),
'innlest': ('innlese',),
'innles': ('innlese',),
'innlevere': ('innlevere',),
'innleverer': ('innlevere',),
'innleveres': ('innlevere',),
'innleverte': ('innlevere',),
'innlevert': ('innlevere',),
'innlever': ('innlevere',),
'innlosjere': ('innlosjere',),
'innlosjerer': ('innlosjere',),
'innlosjeres': ('innlosjere',),
'innlosjerte': ('innlosjere',),
'innlosjert': ('innlosjere',),
'innlosjer': ('innlosjere',),
'innlåne': ('innlåne',),
'innlåner': ('innlåne',),
'innlånes': ('innlåne',),
'innlånte': ('innlåne',),
'innlånt': ('innlåne',),
'innlån': ('innlåne',),
'innløpe': ('innløpe',),
'innløper': ('innløpe',),
'innløpes': ('innløpe',),
'innløp': ('innløpe',),
'innløpt': ('innløpe',),
'innløpet': ('innløpe',),
'innløp': ('innløpe',),
'innløse': ('innløse',),
'innløser': ('innløse',),
'innløses': ('innløse',),
'innløste': ('innløse',),
'innløst': ('innløse',),
'innløs': ('innløse',),
'innløyse': ('innløyse',),
'innløyser': ('innløyse',),
'innløyses': ('innløyse',),
'innløyste': ('innløyse',),
'innløyst': ('innløyse',),
'innløys': ('innløyse',),
'innmure': ('innmure',),
'innmurer': ('innmure',),
'innmures': ('innmure',),
'innmura': ('innmure',),
'innmuret': ('innmure',),
'innmurte': ('innmure',),
'innmura': ('innmure',),
'innmuret': ('innmure',),
'innmurt': ('innmure',),
'innmur': ('innmure',),
'innordne': ('innordne',),
'innordner': ('innordne',),
'innordnes': ('innordne',),
'innordna': ('innordne',),
'innordnet': ('innordne',),
'innordna': ('innordne',),
'innordnet': ('innordne',),
'innordn': ('innordne',),
'innordne': ('innordne',),
'innordn': ('innordne',),
'innordne': ('innordne',),
'innovere': ('innovere',),
'innoverer': ('innovere',),
'innoveres': ('innovere',),
'innoverte': ('innovere',),
'innovert': ('innovere',),
'innover': ('innovere',),
'innpakke': ('innpakke',),
'innpakker': ('innpakke',),
'innpakkes': ('innpakke',),
'innpakka': ('innpakke',),
'innpakket': ('innpakke',),
'innpakka': ('innpakke',),
'innpakket': ('innpakke',),
'innpakk': ('innpakke',),
'innpasse': ('innpasse',),
'innpasser': ('innpasse',),
'innpasses': ('innpasse',),
'innpassa': ('innpasse',),
'innpasset': ('innpasse',),
'innpassa': ('innpasse',),
'innpasset': ('innpasse',),
'innpass': ('innpasse',),
'innpassere': ('innpassere',),
'innpasserer': ('innpassere',),
'innpasseres': ('innpassere',),
'innpasserte': ('innpassere',),
'innpassert': ('innpassere',),
'innpasser': ('innpassere',),
'innpiske': ('innpiske',),
'innpisker': ('innpiske',),
'innpiskes': ('innpiske',),
'innpiska': ('innpiske',),
'innpisket': ('innpiske',),
'innpiska': ('innpiske',),
'innpisket': ('innpiske',),
'innpisk': ('innpiske',),
'innplante': ('innplante',),
'innplanter': ('innplante',),
'innplantes': ('innplante',),
'innplanta': ('innplante',),
'innplantet': ('innplante',),
'innplanta': ('innplante',),
'innplantet': ('innplante',),
'innplant': ('innplante',),
'innpode': ('innpode',),
'innpoder': ('innpode',),
'innpodes': ('innpode',),
'innpoda': ('innpode',),
'innpodet': ('innpode',),
'innpoda': ('innpode',),
'innpodet': ('innpode',),
'innpod': ('innpode',),
'innprente': ('innprente',),
'innprenter': ('innprente',),
'innprentes': ('innprente',),
'innprenta': ('innprente',),
'innprentet': ('innprente',),
'innprenta': ('innprente',),
'innprentet': ('innprente',),
'innprent': ('innprente',),
'innramme': ('innramme',),
'innrammer': ('innramme',),
'innrammes': ('innramme',),
'innramma': ('innramme',),
'innrammet': ('innramme',),
'innramma': ('innramme',),
'innrammet': ('innramme',),
'innram': ('innramme',),
'innrapportere': ('innrapportere',),
'innrapporterer': ('innrapportere',),
'innrapporteres': ('innrapportere',),
'innrapporterte': ('innrapportere',),
'innrapportert': ('innrapportere',),
'innrapporter': ('innrapportere',),
'innrede': ('innrede',),
'innreder': ('innrede',),
'innredes': ('innrede',),
'innreda': ('innrede',),
'innredet': ('innrede',),
'innreda': ('innrede',),
'innredet': ('innrede',),
'innred': ('innrede',),
'innreie': ('innreie',),
'innreier': ('innreie',),
'innreies': ('innreie',),
'innreide': ('innreie',),
'innreid': ('innreie',),
'innrei': ('innreie',),
'innrette': ('innrette',),
'innretter': ('innrette',),
'innrettes': ('innrette',),
'innretta': ('innrette',),
'innrettet': ('innrette',),
'innretta': ('innrette',),
'innrettet': ('innrette',),
'innrett': ('innrette',),
'innringe': ('innringe',),
'innringer': ('innringe',),
'innringes': ('innringe',),
'innringa': ('innringe',),
'innringet': ('innringe',),
'innringa': ('innringe',),
'innringet': ('innringe',),
'innring': ('innringe',),
'innrullere': ('innrullere',),
'innrullerer': ('innrullere',),
'innrulleres': ('innrullere',),
'innrullerte': ('innrullere',),
'innrullert': ('innrullere',),
'innruller': ('innrullere',),
'innrykke': ('innrykke',),
'innrykker': ('innrykke',),
'innrykkes': ('innrykke',),
'innrykka': ('innrykke',),
'innrykket': ('innrykke',),
'innrykte': ('innrykke',),
'innrykka': ('innrykke',),
'innrykket': ('innrykke',),
'innrykt': ('innrykke',),
'innrykk': ('innrykke',),
'innrømme': ('innrømme',),
'innrømmer': ('innrømme',),
'innrømmes': ('innrømme',),
'innrømma': ('innrømme',),
'innrømmet': ('innrømme',),
'innrømte': ('innrømme',),
'innrømma': ('innrømme',),
'innrømmet': ('innrømme',),
'innrømt': ('innrømme',),
'innrøm': ('innrømme',),
'innsamle': ('innsamle',),
'innsamler': ('innsamle',),
'innsamles': ('innsamle',),
'innsamla': ('innsamle',),
'innsamlet': ('innsamle',),
'innsamla': ('innsamle',),
'innsamlet': ('innsamle',),
'innsaml': ('innsamle',),
'innsamle': ('innsamle',),
'innsaml': ('innsamle',),
'innsamle': ('innsamle',),
'innse': ('innse',),
'innser': ('innse',),
'innses': ('innse',),
'innsees': ('innse',),
'innså': ('innse',),
'innsett': ('innse',),
'innse': ('innse',),
'innsegle': ('innsegle',),
'innsegler': ('innsegle',),
'innsegles': ('innsegle',),
'innsegla': ('innsegle',),
'innseglet': ('innsegle',),
'innsegla': ('innsegle',),
'innseglet': ('innsegle',),
'innsegl': ('innsegle',),
'innsegle': ('innsegle',),
'innsegl': ('innsegle',),
'innsegle': ('innsegle',),
'innseile': ('innseile',),
'innseiler': ('innseile',),
'innseiles': ('innseile',),
'innseilte': ('innseile',),
'innseilt': ('innseile',),
'innseil': ('innseile',),
'innsende': ('innsende',),
'innsender': ('innsende',),
'innsendes': ('innsende',),
'innsendte': ('innsende',),
'innsendt': ('innsende',),
'innsend': ('innsende',),
'innsette': ('innsette',),
'innsetter': ('innsette',),
'innsettes': ('innsette',),
'innsatte': ('innsette',),
'innsatt': ('innsette',),
'innsett': ('innsette',),
'innsikte': ('innsikte',),
'innsikter': ('innsikte',),
'innsiktes': ('innsikte',),
'innsikta': ('innsikte',),
'innsiktet': ('innsikte',),
'innsikta': ('innsikte',),
'innsiktet': ('innsikte',),
'innsikt': ('innsikte',),
'innsirkle': ('innsirkle',),
'innsirkler': ('innsirkle',),
'innsirkles': ('innsirkle',),
'innsirkla': ('innsirkle',),
'innsirklet': ('innsirkle',),
'innsirkla': ('innsirkle',),
'innsirklet': ('innsirkle',),
'innsirkl': ('innsirkle',),
'innsirkle': ('innsirkle',),
'innsirkl': ('innsirkle',),
'innsirkle': ('innsirkle',),
'innskipe': ('innskipe',),
'innskiper': ('innskipe',),
'innskipes': ('innskipe',),
'innskipa': ('innskipe',),
'innskipet': ('innskipe',),
'innskipa': ('innskipe',),
'innskipet': ('innskipe',),
'innskip': ('innskipe',),
'innskjerpe': ('innskjerpe',),
'innskjerper': ('innskjerpe',),
'innskjerpes': ('innskjerpe',),
'innskjerpa': ('innskjerpe',),
'innskjerpet': ('innskjerpe',),
'innskjerpa': ('innskjerpe',),
'innskjerpet': ('innskjerpe',),
'innskjerp': ('innskjerpe',),
'innskjære': ('innskjære',),
'innskjærer': ('innskjære',),
'innskjæres': ('innskjære',),
'innskar': ('innskjære',),
'innskåret': ('innskjære',),
'innskjær': ('innskjære',),
'innskrenke': ('innskrenke',),
'innskrenker': ('innskrenke',),
'innskrenkes': ('innskrenke',),
'innskrenka': ('innskrenke',),
'innskrenket': ('innskrenke',),
'innskrenka': ('innskrenke',),
'innskrenket': ('innskrenke',),
'innskrenk': ('innskrenke',),
'innskrive': ('innskrive',),
'innskriver': ('innskrive',),
'innskrives': ('innskrive',),
'innskrev': ('innskrive',),
'innskreiv': ('innskrive',),
'innskrev': ('innskrive',),
'innskreiv': ('innskrive',),
'innskrevet': ('innskrive',),
'innskriv': ('innskrive',),
'innskyte': ('innskyte',),
'innskyter': ('innskyte',),
'innskytes': ('innskyte',),
'innskjøt': ('innskyte',),
'innskøyt': ('innskyte',),
'innskutt': ('innskyte',),
'innskyt': ('innskyte',),
'innsmigre': ('innsmigre',),
'innsmigrer': ('innsmigre',),
'innsmigres': ('innsmigre',),
'innsmigra': ('innsmigre',),
'innsmigret': ('innsmigre',),
'innsmigra': ('innsmigre',),
'innsmigret': ('innsmigre',),
'innsmigr': ('innsmigre',),
'innsmigre': ('innsmigre',),
'innsmigr': ('innsmigre',),
'innsmigre': ('innsmigre',),
'innsmugle': ('innsmugle',),
'innsmugler': ('innsmugle',),
'innsmugles': ('innsmugle',),
'innsmugla': ('innsmugle',),
'innsmuglet': ('innsmugle',),
'innsmugla': ('innsmugle',),
'innsmuglet': ('innsmugle',),
'innsmugl': ('innsmugle',),
'innsmugle': ('innsmugle',),
'innsmugl': ('innsmugle',),
'innsmugle': ('innsmugle',),
'innsmøre': ('innsmøre',),
'innsmører': ('innsmøre',),
'innsmøres': ('innsmøre',),
'innsmurte': ('innsmøre',),
'innsmurt': ('innsmøre',),
'innsmør': ('innsmøre',),
'innsnevre': ('innsnevre',),
'innsnevrer': ('innsnevre',),
'innsnevres': ('innsnevre',),
'innsnevra': ('innsnevre',),
'innsnevret': ('innsnevre',),
'innsnevra': ('innsnevre',),
'innsnevret': ('innsnevre',),
'innsnevr': ('innsnevre',),
'innsprøyte': ('innsprøyte',),
'innsprøyter': ('innsprøyte',),
'innsprøytes': ('innsprøyte',),
'innsprøyta': ('innsprøyte',),
'innsprøytet': ('innsprøyte',),
'innsprøyta': ('innsprøyte',),
'innsprøytet': ('innsprøyte',),
'innsprøyt': ('innsprøyte',),
'innstevne': ('innstevne',),
'innstevner': ('innstevne',),
'innstevnes': ('innstevne',),
'innstevna': ('innstevne',),
'innstevnet': ('innstevne',),
'innstevnte': ('innstevne',),
'innstevna': ('innstevne',),
'innstevnet': ('innstevne',),
'innstevnt': ('innstevne',),
'innstevn': ('innstevne',),
'innstifte': ('innstifte',),
'innstifter': ('innstifte',),
'innstiftes': ('innstifte',),
'innstifta': ('innstifte',),
'innstiftet': ('innstifte',),
'innstifta': ('innstifte',),
'innstiftet': ('innstifte',),
'innstift': ('innstifte',),
'innstille': ('innstille',),
'innstiller': ('innstille',),
'innstilles': ('innstille',),
'innstilte': ('innstille',),
'innstilt': ('innstille',),
'innstill': ('innstille',),
'innstramme': ('innstramme',),
'innstrammer': ('innstramme',),
'innstrammes': ('innstramme',),
'innstramma': ('innstramme',),
'innstrammet': ('innstramme',),
'innstramma': ('innstramme',),
'innstrammet': ('innstramme',),
'innstram': ('innstramme',),
'innstudere': ('innstudere',),
'innstuderer': ('innstudere',),
'innstuderes': ('innstudere',),
'innstuderte': ('innstudere',),
'innstudert': ('innstudere',),
'innstuder': ('innstudere',),
'innstøpe': ('innstøpe',),
'innstøper': ('innstøpe',),
'innstøpes': ('innstøpe',),
'innstøpte': ('innstøpe',),
'innstøpt': ('innstøpe',),
'innstøp': ('innstøpe',),
'innstøype': ('innstøype',),
'innstøyper': ('innstøype',),
'innstøypes': ('innstøype',),
'innstøypte': ('innstøype',),
'innstøypt': ('innstøype',),
'innstøyp': ('innstøype',),
'innsuge': ('innsuge',),
'innsuger': ('innsuge',),
'innsuges': ('innsuge',),
'innsuga': ('innsuge',),
'innsuget': ('innsuge',),
'innsugde': ('innsuge',),
'innsaug': ('innsuge',),
'innsuga': ('innsuge',),
'innsuget': ('innsuge',),
'innsugd': ('innsuge',),
'innsug': ('innsuge',),
'innsynge': ('innsynge',),
'innsynger': ('innsynge',),
'innsynges': ('innsynge',),
'innsang': ('innsynge',),
'innsunget': ('innsynge',),
'innsyng': ('innsynge',),
'innta': ('innta',),
'inntar': ('innta',),
'inntas': ('innta',),
'inntok': ('innta',),
'inntatt': ('innta',),
'innta': ('innta',),
'inntaste': ('inntaste',),
'inntaster': ('inntaste',),
'inntastes': ('inntaste',),
'inntasta': ('inntaste',),
'inntastet': ('inntaste',),
'inntasta': ('inntaste',),
'inntastet': ('inntaste',),
'inntast': ('inntaste',),
'inntegne': ('inntegne',),
'inntegner': ('inntegne',),
'inntegnes': ('inntegne',),
'inntegna': ('inntegne',),
'inntegnet': ('inntegne',),
'inntegna': ('inntegne',),
'inntegnet': ('inntegne',),
'inntegn': ('inntegne',),
'inntre': ('inntre',),
'inntrer': ('inntre',),
'inntres': ('inntre',),
'inntrådte': ('inntre',),
'inntrådt': ('inntre',),
'inntre': ('inntre',),
'inntreffe': ('inntreffe',),
'inntreffer': ('inntreffe',),
'inntreffes': ('inntreffe',),
'inntraff': ('inntreffe',),
'inntruffet': ('inntreffe',),
'inntreff': ('inntreffe',),
'innvandre': ('innvandre',),
'innvandrer': ('innvandre',),
'innvandres': ('innvandre',),
'innvandra': ('innvandre',),
'innvandret': ('innvandre',),
'innvandra': ('innvandre',),
'innvandret': ('innvandre',),
'innvandr': ('innvandre',),
'innvandre': ('innvandre',),
'innvandr': ('innvandre',),
'innvandre': ('innvandre',),
'innvarsle': ('innvarsle',),
'innvarsler': ('innvarsle',),
'innvarsles': ('innvarsle',),
'innvarsla': ('innvarsle',),
'innvarslet': ('innvarsle',),
'innvarsla': ('innvarsle',),
'innvarslet': ('innvarsle',),
'innvarsl': ('innvarsle',),
'innvarsle': ('innvarsle',),
'innvarsl': ('innvarsle',),
'innvarsle': ('innvarsle',),
'innveie': ('innveie',),
'innveier': ('innveie',),
'innveies': ('innveie',),
'innveide': ('innveie',),
'innveid': ('innveie',),
'innvei': ('innveie',),
'innvelge': ('innvelge',),
'innvelger': ('innvelge',),
'innvelges': ('innvelge',),
'innvalgte': ('innvelge',),
'innvalgt': ('innvelge',),
'innvelg': ('innvelge',),
'innvende': ('innvende',),
'innvender': ('innvende',),
'innvendes': ('innvende',),
'innvendte': ('innvende',),
'innvendt': ('innvende',),
'innvend': ('innvende',),
'innvie': ('innvie',),
'innvier': ('innvie',),
'innvies': ('innvie',),
'innvia': ('innvie',),
'innviet': ('innvie',),
'innvidde': ('innvie',),
'innvigde': ('innvie',),
'innvia': ('innvie',),
'innviet': ('innvie',),
'innvidd': ('innvie',),
'innvigd': ('innvie',),
'innvi': ('innvie',),
'innvikle': ('innvikle',),
'innvikler': ('innvikle',),
'innvikles': ('innvikle',),
'innvikla': ('innvikle',),
'innviklet': ('innvikle',),
'innvikla': ('innvikle',),
'innviklet': ('innvikle',),
'innvikl': ('innvikle',),
'innvikle': ('innvikle',),
'innvikl': ('innvikle',),
'innvikle': ('innvikle',),
'innvilge': ('innvilge',),
'innvilger': ('innvilge',),
'innvilges': ('innvilge',),
'innvilga': ('innvilge',),
'innvilget': ('innvilge',),
'innvilga': ('innvilge',),
'innvilget': ('innvilge',),
'innvilg': ('innvilge',),
'innvinne': ('innvinne',),
'innvinner': ('innvinne',),
'innvinnes': ('innvinne',),
'innvant': ('innvinne',),
'innvunnet': ('innvinne',),
'innvinn': ('innvinne',),
'innvirke': ('innvirke',),
'innvirker': ('innvirke',),
'innvirkes': ('innvirke',),
'innvirka': ('innvirke',),
'innvirket': ('innvirke',),
'innvirka': ('innvirke',),
'innvirket': ('innvirke',),
'innvirk': ('innvirke',),
'innvotere': ('innvotere',),
'innvoterer': ('innvotere',),
'innvoteres': ('innvotere',),
'innvoterte': ('innvotere',),
'innvotert': ('innvotere',),
'innvoter': ('innvotere',),
'innynde': ('innynde',),
'innynder': ('innynde',),
'innyndes': ('innynde',),
'innynda': ('innynde',),
'innyndet': ('innynde',),
'innynda': ('innynde',),
'innyndet': ('innynde',),
'innynd': ('innynde',),
'innånde': ('innånde',),
'innånder': ('innånde',),
'innåndes': ('innånde',),
'innånda': ('innånde',),
'innåndet': ('innånde',),
'innånda': ('innånde',),
'innåndet': ('innånde',),
'innånd': ('innånde',),
'innøve': ('innøve',),
'innøver': ('innøve',),
'innøves': ('innøve',),
'innøva': ('innøve',),
'innøvet': ('innøve',),
'innøvde': ('innøve',),
'innøva': ('innøve',),
'innøvet': ('innøve',),
'innøvd': ('innøve',),
'innøv': ('innøve',),
'inokulere': ('inokulere',),
'inokulerer': ('inokulere',),
'inokuleres': ('inokulere',),
'inokulerte': ('inokulere',),
'inokulert': ('inokulere',),
'inokuler': ('inokulere',),
'inseminere': ('inseminere',),
'inseminerer': ('inseminere',),
'insemineres': ('inseminere',),
'inseminerte': ('inseminere',),
'inseminert': ('inseminere',),
'inseminer': ('inseminere',),
'insinuere': ('insinuere',),
'insinuerer': ('insinuere',),
'insinueres': ('insinuere',),
'insinuerte': ('insinuere',),
'insinuert': ('insinuere',),
'insinuer': ('insinuere',),
'insistere': ('insistere',),
'insisterer': ('insistere',),
'insisteres': ('insistere',),
'insisterte': ('insistere',),
'insistert': ('insistere',),
'insister': ('insistere',),
'inspirere': ('inspirere',),
'inspirerer': ('inspirere',),
'inspireres': ('inspirere',),
'inspirerte': ('inspirere',),
'inspirert': ('inspirere',),
'inspirer': ('inspirere',),
'inspisere': ('inspisere',),
'inspiserer': ('inspisere',),
'inspiseres': ('inspisere',),
'inspiserte': ('inspisere',),
'inspisert': ('inspisere',),
'inspiser': ('inspisere',),
'installere': ('installere',),
'installerer': ('installere',),
'installeres': ('installere',),
'installerte': ('installere',),
'installert': ('installere',),
'installer': ('installere',),
'instituere': ('instituere',),
'instituerer': ('instituere',),
'institueres': ('instituere',),
'instituerte': ('instituere',),
'instituert': ('instituere',),
'instituer': ('instituere',),
'institusjonalisere': ('institusjonalisere',),
'institusjonaliserer': ('institusjonalisere',),
'institusjonaliseres': ('institusjonalisere',),
'institusjonaliserte': ('institusjonalisere',),
'institusjonalisert': ('institusjonalisere',),
'institusjonaliser': ('institusjonalisere',),
'instruere': ('instruere',),
'instruerer': ('instruere',),
'instrueres': ('instruere',),
'instruerte': ('instruere',),
'instruert': ('instruere',),
'instruer': ('instruere',),
'instrumentere': ('instrumentere',),
'instrumenterer': ('instrumentere',),
'instrumenteres': ('instrumentere',),
'instrumenterte': ('instrumentere',),
'instrumentert': ('instrumentere',),
'instrumenter': ('instrumentere',),
'integrere': ('integrere',),
'integrerer': ('integrere',),
'integreres': ('integrere',),
'integrerte': ('integrere',),
'integrert': ('integrere',),
'integrer': ('integrere',),
'intellektualisere': ('intellektualisere',),
'intellektualiserer': ('intellektualisere',),
'intellektualiseres': ('intellektualisere',),
'intellektualiserte': ('intellektualisere',),
'intellektualisert': ('intellektualisere',),
'intellektualiser': ('intellektualisere',),
'intendere': ('intendere',),
'intenderer': ('intendere',),
'intenderes': ('intendere',),
'intenderte': ('intendere',),
'intendert': ('intendere',),
'intender': ('intendere',),
'intensivere': ('intensivere',),
'intensiverer': ('intensivere',),
'intensiveres': ('intensivere',),
'intensiverte': ('intensivere',),
'intensivert': ('intensivere',),
'intensiver': ('intensivere',),
'interessere': ('interessere',),
'interesserer': ('interessere',),
'interesseres': ('interessere',),
'interesserte': ('interessere',),
'interessert': ('interessere',),
'interesser': ('interessere',),
'interferere': ('interferere',),
'interfererer': ('interferere',),
'interfereres': ('interferere',),
'interfererte': ('interferere',),
'interferert': ('interferere',),
'interferer': ('interferere',),
'interfoliere': ('interfoliere',),
'interfolierer': ('interfoliere',),
'interfolieres': ('interfoliere',),
'interfolierte': ('interfoliere',),
'interfoliert': ('interfoliere',),
'interfolier': ('interfoliere',),
'internasjonalisere': ('internasjonalisere',),
'internasjonaliserer': ('internasjonalisere',),
'internasjonaliseres': ('internasjonalisere',),
'internasjonaliserte': ('internasjonalisere',),
'internasjonalisert': ('internasjonalisere',),
'internasjonaliser': ('internasjonalisere',),
'internere': ('internere',),
'internerer': ('internere',),
'interneres': ('internere',),
'internerte': ('internere',),
'internert': ('internere',),
'interner': ('internere',),
'interpellere': ('interpellere',),
'interpellerer': ('interpellere',),
'interpelleres': ('interpellere',),
'interpellerte': ('interpellere',),
'interpellert': ('interpellere',),
'interpeller': ('interpellere',),
'interpolere': ('interpolere',),
'interpolerer': ('interpolere',),
'interpoleres': ('interpolere',),
'interpolerte': ('interpolere',),
'interpolert': ('interpolere',),
'interpoler': ('interpolere',),
'interpretere': ('interpretere',),
'interpreterer': ('interpretere',),
'interpreteres': ('interpretere',),
'interpreterte': ('interpretere',),
'interpretert': ('interpretere',),
'interpreter': ('interpretere',),
'intervenere': ('intervenere',),
'intervenerer': ('intervenere',),
'interveneres': ('intervenere',),
'intervenerte': ('intervenere',),
'intervenert': ('intervenere',),
'intervener': ('intervenere',),
'intervjue': ('intervjue',),
'intervjuer': ('intervjue',),
'intervjues': ('intervjue',),
'intervjua': ('intervjue',),
'intervjuet': ('intervjue',),
'intervjua': ('intervjue',),
'intervjuet': ('intervjue',),
'intervju': ('intervjue',),
'intimidere': ('intimidere',),
'intimiderer': ('intimidere',),
'intimideres': ('intimidere',),
'intimiderte': ('intimidere',),
'intimidert': ('intimidere',),
'intimider': ('intimidere',),
'intonere': ('intonere',),
'intonerer': ('intonere',),
'intoneres': ('intonere',),
'intonerte': ('intonere',),
'intonert': ('intonere',),
'intoner': ('intonere',),
'intrigere': ('intrigere',),
'intrigerer': ('intrigere',),
'intrigeres': ('intrigere',),
'intrigerte': ('intrigere',),
'intrigert': ('intrigere',),
'intriger': ('intrigere',),
'introdusere': ('introdusere',),
'introduserer': ('introdusere',),
'introduseres': ('introdusere',),
'introduserte': ('introdusere',),
'introdusert': ('introdusere',),
'introduser': ('introdusere',),
'invadere': ('invadere',),
'invaderer': ('invadere',),
'invaderes': ('invadere',),
'invaderte': ('invadere',),
'invadert': ('invadere',),
'invader': ('invadere',),
'invalidisere': ('invalidisere',),
'invalidiserer': ('invalidisere',),
'invalidiseres': ('invalidisere',),
'invalidiserte': ('invalidisere',),
'invalidisert': ('invalidisere',),
'invalidiser': ('invalidisere',),
'inventere': ('inventere',),
'inventerer': ('inventere',),
'inventeres': ('inventere',),
'inventerte': ('inventere',),
'inventert': ('inventere',),
'inventer': ('inventere',),
'invertere': ('invertere',),
'inverterer': ('invertere',),
'inverteres': ('invertere',),
'inverterte': ('invertere',),
'invertert': ('invertere',),
'inverter': ('invertere',),
'investere': ('investere',),
'investerer': ('investere',),
'investeres': ('investere',),
'investerte': ('investere',),
'investert': ('investere',),
'invester': ('investere',),
'invitere': ('invitere',),
'inviterer': ('invitere',),
'inviteres': ('invitere',),
'inviterte': ('invitere',),
'invitert': ('invitere',),
'inviter': ('invitere',),
'involvere': ('involvere',),
'involverer': ('involvere',),
'involveres': ('involvere',),
'involverte': ('involvere',),
'involvert': ('involvere',),
'involver': ('involvere',),
'ionisere': ('ionisere',),
'ioniserer': ('ionisere',),
'ioniseres': ('ionisere',),
'ioniserte': ('ionisere',),
'ionisert': ('ionisere',),
'ioniser': ('ionisere',),
'irettesette': ('irettesette',),
'irettesetter': ('irettesette',),
'irettesettes': ('irettesette',),
'irettesatte': ('irettesette',),
'irettesatt': ('irettesette',),
'irettesett': ('irettesette',),
'irisere': ('irisere',),
'iriserer': ('irisere',),
'iriseres': ('irisere',),
'iriserte': ('irisere',),
'irisert': ('irisere',),
'iriser': ('irisere',),
'ironisere': ('ironisere',),
'ironiserer': ('ironisere',),
'ironiseres': ('ironisere',),
'ironiserte': ('ironisere',),
'ironisert': ('ironisere',),
'ironiser': ('ironisere',),
'irre': ('irre',),
'irrer': ('irre',),
'irres': ('irre',),
'irra': ('irre',),
'irret': ('irre',),
'irra': ('irre',),
'irret': ('irre',),
'irr': ('irre',),
'irrigere': ('irrigere',),
'irrigerer': ('irrigere',),
'irrigeres': ('irrigere',),
'irrigerte': ('irrigere',),
'irrigert': ('irrigere',),
'irriger': ('irrigere',),
'irritere': ('irritere',),
'irriterer': ('irritere',),
'irriteres': ('irritere',),
'irriterte': ('irritere',),
'irritert': ('irritere',),
'irriter': ('irritere',),
'iscenesette': ('iscenesette',),
'iscenesetter': ('iscenesette',),
'iscenesettes': ('iscenesette',),
'iscenesatte': ('iscenesette',),
'iscenesatt': ('iscenesette',),
'iscenesett': ('iscenesette',),
'ise': ('ise',),
'iser': ('ise',),
'ises': ('ise',),
'isa': ('ise',),
'iset': ('ise',),
'iste': ('ise',),
'isa': ('ise',),
'iset': ('ise',),
'ist': ('ise',),
'is': ('ise',),
'islamisere': ('islamisere',),
'islamiserer': ('islamisere',),
'islamiseres': ('islamisere',),
'islamiserte': ('islamisere',),
'islamisert': ('islamisere',),
'islamiser': ('islamisere',),
'isne': ('isne',),
'isner': ('isne',),
'isnes': ('isne',),
'isna': ('isne',),
'isnet': ('isne',),
'isna': ('isne',),
'isnet': ('isne',),
'isn': ('isne',),
'isne': ('isne',),
'isn': ('isne',),
'isne': ('isne',),
'isolere': ('isolere',),
'isolerer': ('isolere',),
'isoleres': ('isolere',),
'isolerte': ('isolere',),
'isolert': ('isolere',),
'isoler': ('isolere',),
'ispe': ('ispe',),
'isper': ('ispe',),
'ispes': ('ispe',),
'ispedde': ('ispe',),
'ispedd': ('ispe',),
'ispe': ('ispe',),
'istemme': ('istemme',),
'istemmer': ('istemme',),
'istemmes': ('istemme',),
'istemte': ('istemme',),
'istemt': ('istemme',),
'istem': ('istemme',),
'iterere': ('iterere',),
'itererer': ('iterere',),
'itereres': ('iterere',),
'itererte': ('iterere',),
'iterert': ('iterere',),
'iterer': ('iterere',),
'ivareta': ('ivareta',),
'ivaretar': ('ivareta',),
'ivaretas': ('ivareta',),
'ivaretok': ('ivareta',),
'ivaretatt': ('ivareta',),
'ivareta': ('ivareta',),
'iverksette': ('iverksette',),
'iverksetter': ('iverksette',),
'iverksettes': ('iverksette',),
'iverksatte': ('iverksette',),
'iverksatt': ('iverksette',),
'iverksett': ('iverksette',),
'ivre': ('ivre',),
'ivrer': ('ivre',),
'ivres': ('ivre',),
'ivra': ('ivre',),
'ivret': ('ivre',),
'ivra': ('ivre',),
'ivret': ('ivre',),
'ivr': ('ivre',),
'ivre': ('ivre',),
'ivr': ('ivre',),
'ivre': ('ivre',),
'jabbe': ('jabbe',),
'jabber': ('jabbe',),
'jabbes': ('jabbe',),
'jabba': ('jabbe',),
'jabbet': ('jabbe',),
'jabba': ('jabbe',),
'jabbet': ('jabbe',),
'jabb': ('jabbe',),
'jafse': ('jafse',),
'jafser': ('jafse',),
'jafses': ('jafse',),
'jafsa': ('jafse',),
'jafset': ('jafse',),
'jafsa': ('jafse',),
'jafset': ('jafse',),
'jafs': ('jafse',),
'jage': ('jage',),
'jager': ('jage',),
'jages': ('jage',),
'jaga': ('jage',),
'jaget': ('jage',),
'jagde': ('jage',),
'jog': ('jage',),
'jaga': ('jage',),
'jaget': ('jage',),
'jagd': ('jage',),
'jag': ('jage',),
'jakte': ('jakte',),
'jakter': ('jakte',),
'jaktes': ('jakte',),
'jakta': ('jakte',),
'jaktet': ('jakte',),
'jakta': ('jakte',),
'jaktet': ('jakte',),
'jakt': ('jakte',),
'jalme': ('jalme',),
'jalmer': ('jalme',),
'jalmes': ('jalme',),
'jalma': ('jalme',),
'jalmet': ('jalme',),
'jalma': ('jalme',),
'jalmet': ('jalme',),
'jalm': ('jalme',),
'jamføre': ('jamføre',),
'jamfører': ('jamføre',),
'jamføres': ('jamføre',),
'jamførte': ('jamføre',),
'jamført': ('jamføre',),
'jamfør': ('jamføre',),
'jamme': ('jamme',),
'jammer': ('jamme',),
'jammes': ('jamme',),
'jamma': ('jamme',),
'jammet': ('jamme',),
'jamma': ('jamme',),
'jammet': ('jamme',),
'jam': ('jamme',),
'jamne': ('jamne',),
'jamner': ('jamne',),
'jamnes': ('jamne',),
'jamna': ('jamne',),
'jamnet': ('jamne',),
'jamna': ('jamne',),
'jamnet': ('jamne',),
'jamn': ('jamne',),
'jamre': ('jamre',),
'jamrer': ('jamre',),
'jamres': ('jamre',),
'jamra': ('jamre',),
'jamret': ('jamre',),
'jamra': ('jamre',),
'jamret': ('jamre',),
'jamr': ('jamre',),
'jamre': ('jamre',),
'jamr': ('jamre',),
'jamre': ('jamre',),
'jamstille': ('jamstille',),
'jamstiller': ('jamstille',),
'jamstilles': ('jamstille',),
'jamstilte': ('jamstille',),
'jamstilt': ('jamstille',),
'jamstill': ('jamstille',),
'jare': ('jare',),
'jarer': ('jare',),
'jares': ('jare',),
'jara': ('jare',),
'jaret': ('jare',),
'jara': ('jare',),
'jaret': ('jare',),
'jar': ('jare',),
'jaske': ('jaske',),
'jasker': ('jaske',),
'jaskes': ('jaske',),
'jaska': ('jaske',),
'jasket': ('jaske',),
'jaska': ('jaske',),
'jasket': ('jaske',),
'jask': ('jaske',),
'jasse': ('jasse',),
'jasser': ('jasse',),
'jasses': ('jasse',),
'jassa': ('jasse',),
'jasset': ('jasse',),
'jassa': ('jasse',),
'jasset': ('jasse',),
'jass': ('jasse',),
'jassifisere': ('jassifisere',),
'jassifiserer': ('jassifisere',),
'jassifiseres': ('jassifisere',),
'jassifiserte': ('jassifisere',),
'jassifisert': ('jassifisere',),
'jassifiser': ('jassifisere',),
'jatte': ('jatte',),
'jatter': ('jatte',),
'jattes': ('jatte',),
'jatta': ('jatte',),
'jattet': ('jatte',),
'jatta': ('jatte',),
'jattet': ('jatte',),
'jatt': ('jatte',),
'jazze': ('jazze',),
'jazzer': ('jazze',),
'jazzes': ('jazze',),
'jazza': ('jazze',),
'jazzet': ('jazze',),
'jazza': ('jazze',),
'jazzet': ('jazze',),
'jazz': ('jazze',),
'jazzifisere': ('jazzifisere',),
'jazzifiserer': ('jazzifisere',),
'jazzifiseres': ('jazzifisere',),
'jazzifiserte': ('jazzifisere',),
'jazzifisert': ('jazzifisere',),
'jazzifiser': ('jazzifisere',),
'jekke': ('jekke',),
'jekker': ('jekke',),
'jekkes': ('jekke',),
'jekka': ('jekke',),
'jekket': ('jekke',),
'jekka': ('jekke',),
'jekket': ('jekke',),
'jekk': ('jekke',),
'jelke': ('jelke',),
'jelker': ('jelke',),
'jelkes': ('jelke',),
'jelka': ('jelke',),
'jelket': ('jelke',),
'jelka': ('jelke',),
'jelket': ('jelke',),
'jelk': ('jelke',),
'jenke': ('jenke',),
'jenker': ('jenke',),
'jenkes': ('jenke',),
'jenka': ('jenke',),
'jenket': ('jenke',),
'jenka': ('jenke',),
'jenket': ('jenke',),
'jenk': ('jenke',),
'jevne': ('jevne',),
'jevner': ('jevne',),
'jevnes': ('jevne',),
'jevna': ('jevne',),
'jevnet': ('jevne',),
'jevna': ('jevne',),
'jevnet': ('jevne',),
'jevn': ('jevne',),
'jevnføre': ('jevnføre',),
'jevnfører': ('jevnføre',),
'jevnføres': ('jevnføre',),
'jevnførte': ('jevnføre',),
'jevnført': ('jevnføre',),
'jevnfør': ('jevnføre',),
'jibbe': ('jibbe',),
'jibber': ('jibbe',),
'jibbes': ('jibbe',),
'jibba': ('jibbe',),
'jibbet': ('jibbe',),
'jibba': ('jibbe',),
'jibbet': ('jibbe',),
'jibb': ('jibbe',),
'jobbe': ('jobbe',),
'jobber': ('jobbe',),
'jobbes': ('jobbe',),
'jobba': ('jobbe',),
'jobbet': ('jobbe',),
'jobba': ('jobbe',),
'jobbet': ('jobbe',),
'jobb': ('jobbe',),
'jodere': ('jodere',),
'joderer': ('jodere',),
'joderes': ('jodere',),
'joderte': ('jodere',),
'jodert': ('jodere',),
'joder': ('jodere',),
'jodisere': ('jodisere',),
'jodiserer': ('jodisere',),
'jodiseres': ('jodisere',),
'jodiserte': ('jodisere',),
'jodisert': ('jodisere',),
'jodiser': ('jodisere',),
'jodle': ('jodle',),
'jodler': ('jodle',),
'jodles': ('jodle',),
'jodla': ('jodle',),
'jodlet': ('jodle',),
'jodla': ('jodle',),
'jodlet': ('jodle',),
'jodl': ('jodle',),
'jodle': ('jodle',),
'jodl': ('jodle',),
'jodle': ('jodle',),
'jogge': ('jogge',),
'jogger': ('jogge',),
'jogges': ('jogge',),
'jogga': ('jogge',),
'jogget': ('jogge',),
'jogga': ('jogge',),
'jogget': ('jogge',),
'jogg': ('jogge',),
'joike': ('joike',),
'joiker': ('joike',),
'joikes': ('joike',),
'joika': ('joike',),
'joiket': ('joike',),
'joika': ('joike',),
'joiket': ('joike',),
'joik': ('joike',),
'jorde': ('jorde',),
'jorder': ('jorde',),
'jordes': ('jorde',),
'jorda': ('jorde',),
'jordet': ('jorde',),
'jorda': ('jorde',),
'jordet': ('jorde',),
'jord': ('jorde',),
'jordfeste': ('jordfeste',),
'jordfester': ('jordfeste',),
'jordfestes': ('jordfeste',),
'jordfesta': ('jordfeste',),
'jordfestet': ('jordfeste',),
'jordfesta': ('jordfeste',),
'jordfestet': ('jordfeste',),
'jordfest': ('jordfeste',),
'jordslå': ('jordslå',),
'jordslår': ('jordslå',),
'jordslås': ('jordslå',),
'jordslåes': ('jordslå',),
'jordslo': ('jordslå',),
'jordslått': ('jordslå',),
'jordslå': ('jordslå',),
'jorte': ('jorte',),
'jorter': ('jorte',),
'jortes': ('jorte',),
'jorta': ('jorte',),
'jortet': ('jorte',),
'jorta': ('jorte',),
'jortet': ('jorte',),
'jort': ('jorte',),
'journalføre': ('journalføre',),
'journalfører': ('journalføre',),
'journalføres': ('journalføre',),
'journalførte': ('journalføre',),
'journalført': ('journalføre',),
'journalfør': ('journalføre',),
'journalisere': ('journalisere',),
'journaliserer': ('journalisere',),
'journaliseres': ('journalisere',),
'journaliserte': ('journalisere',),
'journalisert': ('journalisere',),
'journaliser': ('journalisere',),
'jubilere': ('jubilere',),
'jubilerer': ('jubilere',),
'jubileres': ('jubilere',),
'jubilerte': ('jubilere',),
'jubilert': ('jubilere',),
'jubiler': ('jubilere',),
'juble': ('juble',),
'jubler': ('juble',),
'jubles': ('juble',),
'jubla': ('juble',),
'jublet': ('juble',),
'jubla': ('juble',),
'jublet': ('juble',),
'jubl': ('juble',),
'juble': ('juble',),
'jubl': ('juble',),
'juble': ('juble',),
'jugle': ('jugle',),
'jugler': ('jugle',),
'jugles': ('jugle',),
'jugla': ('jugle',),
'juglet': ('jugle',),
'jugla': ('jugle',),
'juglet': ('jugle',),
'jugl': ('jugle',),
'jugle': ('jugle',),
'jugl': ('jugle',),
'jugle': ('jugle',),
'jukse': ('jukse',),
'jukser': ('jukse',),
'jukses': ('jukse',),
'juksa': ('jukse',),
'jukset': ('jukse',),
'juksa': ('jukse',),
'jukset': ('jukse',),
'juks': ('jukse',),
'jule': ('jule',),
'juler': ('jule',),
'jules': ('jule',),
'julte': ('jule',),
'jult': ('jule',),
'jul': ('jule',),
'jumpe': ('jumpe',),
'jumper': ('jumpe',),
'jumpes': ('jumpe',),
'jumpa': ('jumpe',),
'jumpet': ('jumpe',),
'jumpa': ('jumpe',),
'jumpet': ('jumpe',),
'jump': ('jumpe',),
'junke': ('junke',),
'junker': ('junke',),
'junkes': ('junke',),
'junka': ('junke',),
'junket': ('junke',),
'junka': ('junke',),
'junket': ('junke',),
'junk': ('junke',),
'juryere': ('juryere',),
'juryerer': ('juryere',),
'juryeres': ('juryere',),
'juryerte': ('juryere',),
'juryert': ('juryere',),
'juryer': ('juryere',),
'justere': ('justere',),
'justerer': ('justere',),
'justeres': ('justere',),
'justerte': ('justere',),
'justert': ('justere',),
'juster': ('justere',),
'jåle': ('jåle',),
'jåler': ('jåle',),
'jåles': ('jåle',),
'jåla': ('jåle',),
'jålet': ('jåle',),
'jålte': ('jåle',),
'jåla': ('jåle',),
'jålet': ('jåle',),
'jålt': ('jåle',),
'jål': ('jåle',),
'jøye': ('jøye',),
'jøyer': ('jøye',),
'jøyes': ('jøye',),
'jøya': ('jøye',),
'jøyet': ('jøye',),
'jøya': ('jøye',),
'jøyet': ('jøye',),
'jøy': ('jøye',),
'kabbe': ('kabbe',),
'kabber': ('kabbe',),
'kabbes': ('kabbe',),
'kabba': ('kabbe',),
'kabbet': ('kabbe',),
'kabba': ('kabbe',),
'kabbet': ('kabbe',),
'kabb': ('kabbe',),
'kadmiere': ('kadmiere',),
'kadmierer': ('kadmiere',),
'kadmieres': ('kadmiere',),
'kadmierte': ('kadmiere',),
'kadmiert': ('kadmiere',),
'kadmier': ('kadmiere',),
'kadreie': ('kadreie',),
'kadreier': ('kadreie',),
'kadreies': ('kadreie',),
'kadreia': ('kadreie',),
'kadreiet': ('kadreie',),
'kadreide': ('kadreie',),
'kadreia': ('kadreie',),
'kadreiet': ('kadreie',),
'kadreid': ('kadreie',),
'kadrei': ('kadreie',),
'kake': ('kake',),
'kaker': ('kake',),
'kakes': ('kake',),
'kaka': ('kake',),
'kaket': ('kake',),
'kaka': ('kake',),
'kaket': ('kake',),
'kak': ('kake',),
'kakke': ('kakke',),
'kakker': ('kakke',),
'kakkes': ('kakke',),
'kakka': ('kakke',),
'kakket': ('kakke',),
'kakka': ('kakke',),
'kakket': ('kakke',),
'kakk': ('kakke',),
'kakle': ('kakle',),
'kakler': ('kakle',),
'kakles': ('kakle',),
'kakla': ('kakle',),
'kaklet': ('kakle',),
'kakla': ('kakle',),
'kaklet': ('kakle',),
'kakl': ('kakle',),
'kakle': ('kakle',),
'kakl': ('kakle',),
'kakle': ('kakle',),
'kakstryke': ('kakstryke',),
'kakstryker': ('kakstryke',),
'kakstrykes': ('kakstryke',),
'kakstrøyk': ('kakstryke',),
'kakstrøk': ('kakstryke',),
'kakstrøket': ('kakstryke',),
'kakstryk': ('kakstryke',),
'kakuminalisere': ('kakuminalisere',),
'kakuminaliserer': ('kakuminalisere',),
'kakuminaliseres': ('kakuminalisere',),
'kakuminaliserte': ('kakuminalisere',),
'kakuminalisert': ('kakuminalisere',),
'kakuminaliser': ('kakuminalisere',),
'kalandrere': ('kalandrere',),
'kalandrerer': ('kalandrere',),
'kalandreres': ('kalandrere',),
'kalandrerte': ('kalandrere',),
'kalandrert': ('kalandrere',),
'kalandrer': ('kalandrere',),
'kaldflire': ('kaldflire',),
'kaldflirer': ('kaldflire',),
'kaldflires': ('kaldflire',),
'kaldflirte': ('kaldflire',),
'kaldflirt': ('kaldflire',),
'kaldflir': ('kaldflire',),
'kaldrøyke': ('kaldrøyke',),
'kaldrøyker': ('kaldrøyke',),
'kaldrøykes': ('kaldrøyke',),
'kaldrøyka': ('kaldrøyke',),
'kaldrøykte': ('kaldrøyke',),
'kaldrøyka': ('kaldrøyke',),
'kaldrøykt': ('kaldrøyke',),
'kaldrøyk': ('kaldrøyke',),
'kaldskratte': ('kaldskratte',),
'kaldskratter': ('kaldskratte',),
'kaldskrattes': ('kaldskratte',),
'kaldskratta': ('kaldskratte',),
'kaldskrattet': ('kaldskratte',),
'kaldskratta': ('kaldskratte',),
'kaldskrattet': ('kaldskratte',),
'kaldskratt': ('kaldskratte',),
'kaldsmi': ('kaldsmi',),
'kaldsmir': ('kaldsmi',),
'kaldsmis': ('kaldsmi',),
'kaldsmidde': ('kaldsmi',),
'kaldsmidd': ('kaldsmi',),
'kaldsmi': ('kaldsmi',),
'kaldsvette': ('kaldsvette',),
'kaldsvetter': ('kaldsvette',),
'kaldsvettes': ('kaldsvette',),
'kaldsvetta': ('kaldsvette',),
'kaldsvettet': ('kaldsvette',),
'kaldsvetta': ('kaldsvette',),
'kaldsvettet': ('kaldsvette',),
'kaldsvett': ('kaldsvette',),
'kalfatre': ('kalfatre',),
'kalfatrer': ('kalfatre',),
'kalfatres': ('kalfatre',),
'kalfatra': ('kalfatre',),
'kalfatret': ('kalfatre',),
'kalfatra': ('kalfatre',),
'kalfatret': ('kalfatre',),
'kalfatr': ('kalfatre',),
'kalfatre': ('kalfatre',),
'kalfatr': ('kalfatre',),
'kalfatre': ('kalfatre',),
'kalibrere': ('kalibrere',),
'kalibrerer': ('kalibrere',),
'kalibreres': ('kalibrere',),
'kalibrerte': ('kalibrere',),
'kalibrert': ('kalibrere',),
'kalibrer': ('kalibrere',),
'kalke': ('kalke',),
'kalker': ('kalke',),
'kalkes': ('kalke',),
'kalka': ('kalke',),
'kalket': ('kalke',),
'kalka': ('kalke',),
'kalket': ('kalke',),
'kalk': ('kalke',),
'kalkere': ('kalkere',),
'kalkerer': ('kalkere',),
'kalkeres': ('kalkere',),
'kalkerte': ('kalkere',),
'kalkert': ('kalkere',),
'kalker': ('kalkere',),
'kalkulere': ('kalkulere',),
'kalkulerer': ('kalkulere',),
'kalkuleres': ('kalkulere',),
'kalkulerte': ('kalkulere',),
'kalkulert': ('kalkulere',),
'kalkuler': ('kalkulere',),
'kalle': ('kalle',),
'kaller': ('kalle',),
'kalles': ('kalle',),
'kalte': ('kalle',),
'kalt': ('kalle',),
'kall': ('kalle',),
'kalligrafere': ('kalligrafere',),
'kalligraferer': ('kalligrafere',),
'kalligraferes': ('kalligrafere',),
'kalligraferte': ('kalligrafere',),
'kalligrafert': ('kalligrafere',),
'kalligrafer': ('kalligrafere',),
'kalsinere': ('kalsinere',),
'kalsinerer': ('kalsinere',),
'kalsineres': ('kalsinere',),
'kalsinerte': ('kalsinere',),
'kalsinert': ('kalsinere',),
'kalsiner': ('kalsinere',),
'kalve': ('kalve',),
'kalver': ('kalve',),
'kalves': ('kalve',),
'kalva': ('kalve',),
'kalvet': ('kalve',),
'kalva': ('kalve',),
'kalvet': ('kalve',),
'kalv': ('kalve',),
'kamme': ('kamme',),
'kammer': ('kamme',),
'kammes': ('kamme',),
'kamma': ('kamme',),
'kammet': ('kamme',),
'kamma': ('kamme',),
'kammet': ('kamme',),
'kam': ('kamme',),
'kampere': ('kampere',),
'kamperer': ('kampere',),
'kamperes': ('kampere',),
'kamperte': ('kampere',),
'kampert': ('kampere',),
'kamper': ('kampere',),
'kamse': ('kamse',),
'kamser': ('kamse',),
'kamses': ('kamse',),
'kamsa': ('kamse',),
'kamset': ('kamse',),
'kamsa': ('kamse',),
'kamset': ('kamse',),
'kams': ('kamse',),
'kamuflere': ('kamuflere',),
'kamuflerer': ('kamuflere',),
'kamufleres': ('kamuflere',),
'kamuflerte': ('kamuflere',),
'kamuflert': ('kamuflere',),
'kamufler': ('kamuflere',),
'kanalisere': ('kanalisere',),
'kanaliserer': ('kanalisere',),
'kanaliseres': ('kanalisere',),
'kanaliserte': ('kanalisere',),
'kanalisert': ('kanalisere',),
'kanaliser': ('kanalisere',),
'kandidere': ('kandidere',),
'kandiderer': ('kandidere',),
'kandideres': ('kandidere',),
'kandiderte': ('kandidere',),
'kandidert': ('kandidere',),
'kandider': ('kandidere',),
'kandisere': ('kandisere',),
'kandiserer': ('kandisere',),
'kandiseres': ('kandisere',),
'kandiserte': ('kandisere',),
'kandisert': ('kandisere',),
'kandiser': ('kandisere',),
'kannelere': ('kannelere',),
'kannelerer': ('kannelere',),
'kanneleres': ('kannelere',),
'kannelerte': ('kannelere',),
'kannelert': ('kannelere',),
'kanneler': ('kannelere',),
'kanonisere': ('kanonisere',),
'kanoniserer': ('kanonisere',),
'kanoniseres': ('kanonisere',),
'kanoniserte': ('kanonisere',),
'kanonisert': ('kanonisere',),
'kanoniser': ('kanonisere',),
'kansellere': ('kansellere',),
'kansellerer': ('kansellere',),
'kanselleres': ('kansellere',),
'kansellerte': ('kansellere',),
'kansellert': ('kansellere',),
'kanseller': ('kansellere',),
'kante': ('kante',),
'kanter': ('kante',),
'kantes': ('kante',),
'kanta': ('kante',),
'kantet': ('kante',),
'kanta': ('kante',),
'kantet': ('kante',),
'kant': ('kante',),
'kantre': ('kantre',),
'kantrer': ('kantre',),
'kantres': ('kantre',),
'kantra': ('kantre',),
'kantret': ('kantre',),
'kantra': ('kantre',),
'kantret': ('kantre',),
'kantr': ('kantre',),
'kantre': ('kantre',),
'kantr': ('kantre',),
'kantre': ('kantre',),
'kapitalisere': ('kapitalisere',),
'kapitaliserer': ('kapitalisere',),
'kapitaliseres': ('kapitalisere',),
'kapitaliserte': ('kapitalisere',),
'kapitalisert': ('kapitalisere',),
'kapitaliser': ('kapitalisere',),
'kapitulere': ('kapitulere',),
'kapitulerer': ('kapitulere',),
'kapituleres': ('kapitulere',),
'kapitulerte': ('kapitulere',),
'kapitulert': ('kapitulere',),
'kapituler': ('kapitulere',),
'kappdrikke': ('kappdrikke',),
'kappdrikker': ('kappdrikke',),
'kappdrikkes': ('kappdrikke',),
'kappdrakk': ('kappdrikke',),
'kappdrukket': ('kappdrikke',),
'kappdrikk': ('kappdrikke',),
'kappe': ('kappe',),
'kapper': ('kappe',),
'kappes': ('kappe',),
'kappa': ('kappe',),
'kappet': ('kappe',),
'kappa': ('kappe',),
'kappet': ('kappe',),
'kapp': ('kappe',),
'kappes': ('kappes',),
'kaptes': ('kappes',),
'kappes': ('kappes',),
'kappkjøre': ('kappkjøre',),
'kappkjører': ('kappkjøre',),
'kappkjøres': ('kappkjøre',),
'kappkjørte': ('kappkjøre',),
'kappkjørt': ('kappkjøre',),
'kappkjør': ('kappkjøre',),
'kapre': ('kapre',),
'kaprer': ('kapre',),
'kapres': ('kapre',),
'kapra': ('kapre',),
'kapret': ('kapre',),
'kapra': ('kapre',),
'kapret': ('kapre',),
'kapr': ('kapre',),
'kapre': ('kapre',),
'kapr': ('kapre',),
'kapre': ('kapre',),
'kapseise': ('kapseise',),
'kapseiser': ('kapseise',),
'kapseises': ('kapseise',),
'kapseiste': ('kapseise',),
'kapseist': ('kapseise',),
'kapseis': ('kapseise',),
'kapsle': ('kapsle',),
'kapsler': ('kapsle',),
'kapsles': ('kapsle',),
'kapsla': ('kapsle',),
'kapslet': ('kapsle',),
'kapsla': ('kapsle',),
'kapslet': ('kapsle',),
'kapsl': ('kapsle',),
'kapsle': ('kapsle',),
'kapsl': ('kapsle',),
'kapsle': ('kapsle',),
'kapunere': ('kapunere',),
'kapunerer': ('kapunere',),
'kapuneres': ('kapunere',),
'kapunerte': ('kapunere',),
'kapunert': ('kapunere',),
'kapuner': ('kapunere',),
'karakterisere': ('karakterisere',),
'karakteriserer': ('karakterisere',),
'karakteriseres': ('karakterisere',),
'karakteriserte': ('karakterisere',),
'karakterisert': ('karakterisere',),
'karakteriser': ('karakterisere',),
'karde': ('karde',),
'karder': ('karde',),
'kardes': ('karde',),
'karda': ('karde',),
'kardet': ('karde',),
'karda': ('karde',),
'kardet': ('karde',),
'kard': ('karde',),
'kare': ('kare',),
'karer': ('kare',),
'kares': ('kare',),
'kara': ('kare',),
'karet': ('kare',),
'kara': ('kare',),
'karet': ('kare',),
'kar': ('kare',),
'karikere': ('karikere',),
'karikerer': ('karikere',),
'karikeres': ('karikere',),
'karikerte': ('karikere',),
'karikert': ('karikere',),
'kariker': ('karikere',),
'karnøfle': ('karnøfle',),
'karnøfler': ('karnøfle',),
'karnøfles': ('karnøfle',),
'karnøfla': ('karnøfle',),
'karnøflet': ('karnøfle',),
'karnøfla': ('karnøfle',),
'karnøflet': ('karnøfle',),
'karnøfl': ('karnøfle',),
'karnøfle': ('karnøfle',),
'karnøfl': ('karnøfle',),
'karnøfle': ('karnøfle',),
'karte': ('karte',),
'karter': ('karte',),
'kartes': ('karte',),
'karta': ('karte',),
'kartet': ('karte',),
'karta': ('karte',),
'kartet': ('karte',),
'kart': ('karte',),
'kartere': ('kartere',),
'karterer': ('kartere',),
'karteres': ('kartere',),
'karterte': ('kartere',),
'kartert': ('kartere',),
'karter': ('kartere',),
'kartlegge': ('kartlegge',),
'kartlegger': ('kartlegge',),
'kartlegges': ('kartlegge',),
'kartla': ('kartlegge',),
'kartlagt': ('kartlegge',),
'kartlegg': ('kartlegge',),
'kartonere': ('kartonere',),
'kartonerer': ('kartonere',),
'kartoneres': ('kartonere',),
'kartonerte': ('kartonere',),
'kartonert': ('kartonere',),
'kartoner': ('kartonere',),
'karve': ('karve',),
'karver': ('karve',),
'karves': ('karve',),
'karva': ('karve',),
'karvet': ('karve',),
'karva': ('karve',),
'karvet': ('karve',),
'karv': ('karve',),
'kase': ('kase',),
'kaser': ('kase',),
'kases': ('kase',),
'kasa': ('kase',),
'kaset': ('kase',),
'kasa': ('kase',),
'kaset': ('kase',),
'kas': ('kase',),
'kassere': ('kassere',),
'kasserer': ('kassere',),
'kasseres': ('kassere',),
'kasserte': ('kassere',),
'kassert': ('kassere',),
'kasser': ('kassere',),
'kaste': ('kaste',),
'kaster': ('kaste',),
'kastes': ('kaste',),
'kasta': ('kaste',),
'kastet': ('kaste',),
'kasta': ('kaste',),
'kastet': ('kaste',),
'kast': ('kaste',),
'kastebytte': ('kastebytte',),
'kastebytter': ('kastebytte',),
'kastebyttes': ('kastebytte',),
'kastebytta': ('kastebytte',),
'kastebyttet': ('kastebytte',),
'kastebytta': ('kastebytte',),
'kastebyttet': ('kastebytte',),
'kastebytt': ('kastebytte',),
'kastrere': ('kastrere',),
'kastrerer': ('kastrere',),
'kastreres': ('kastrere',),
'kastrerte': ('kastrere',),
'kastrert': ('kastrere',),
'kastrer': ('kastrere',),
'katalogisere': ('katalogisere',),
'katalogiserer': ('katalogisere',),
'katalogiseres': ('katalogisere',),
'katalogiserte': ('katalogisere',),
'katalogisert': ('katalogisere',),
'katalogiser': ('katalogisere',),
'katalysere': ('katalysere',),
'katalyserer': ('katalysere',),
'katalyseres': ('katalysere',),
'katalyserte': ('katalysere',),
'katalysert': ('katalysere',),
'katalyser': ('katalysere',),
'kategorisere': ('kategorisere',),
'kategoriserer': ('kategorisere',),
'kategoriseres': ('kategorisere',),
'kategoriserte': ('kategorisere',),
'kategorisert': ('kategorisere',),
'kategoriser': ('kategorisere',),
'katekisere': ('katekisere',),
'katekiserer': ('katekisere',),
'katekiseres': ('katekisere',),
'katekiserte': ('katekisere',),
'katekisert': ('katekisere',),
'katekiser': ('katekisere',),
'katolisere': ('katolisere',),
'katoliserer': ('katolisere',),
'katoliseres': ('katolisere',),
'katoliserte': ('katolisere',),
'katolisert': ('katolisere',),
'katoliser': ('katolisere',),
'katte': ('katte',),
'katter': ('katte',),
'kattes': ('katte',),
'katta': ('katte',),
'kattet': ('katte',),
'katta': ('katte',),
'kattet': ('katte',),
'katt': ('katte',),
'kaue': ('kaue',),
'kauer': ('kaue',),
'kaues': ('kaue',),
'kaua': ('kaue',),
'kauet': ('kaue',),
'kaua': ('kaue',),
'kauet': ('kaue',),
'kau': ('kaue',),
'kauke': ('kauke',),
'kauker': ('kauke',),
'kaukes': ('kauke',),
'kauka': ('kauke',),
'kauket': ('kauke',),
'kauka': ('kauke',),
'kauket': ('kauke',),
'kauk': ('kauke',),
'kausjonere': ('kausjonere',),
'kausjonerer': ('kausjonere',),
'kausjoneres': ('kausjonere',),
'kausjonerte': ('kausjonere',),
'kausjonert': ('kausjonere',),
'kausjoner': ('kausjonere',),
'kave': ('kave',),
'kaver': ('kave',),
'kaves': ('kave',),
'kava': ('kave',),
'kavet': ('kave',),
'kavde': ('kave',),
'kava': ('kave',),
'kavet': ('kave',),
'kavd': ('kave',),
'kav': ('kave',),
'kavere': ('kavere',),
'kaverer': ('kavere',),
'kaveres': ('kavere',),
'kaverte': ('kavere',),
'kavert': ('kavere',),
'kaver': ('kavere',),
'kavle': ('kavle',),
'kavler': ('kavle',),
'kavles': ('kavle',),
'kavla': ('kavle',),
'kavlet': ('kavle',),
'kavla': ('kavle',),
'kavlet': ('kavle',),
'kavl': ('kavle',),
'kavle': ('kavle',),
'kavl': ('kavle',),
'kavle': ('kavle',),
'keie': ('keie',),
'keier': ('keie',),
'keies': ('keie',),
'keia': ('keie',),
'keiet': ('keie',),
'keia': ('keie',),
'keiet': ('keie',),
'kei': ('keie',),
'keike': ('keike',),
'keiker': ('keike',),
'keikes': ('keike',),
'keika': ('keike',),
'keiket': ('keike',),
'keikte': ('keike',),
'keika': ('keike',),
'keiket': ('keike',),
'keikt': ('keike',),
'keik': ('keike',),
'keivle': ('keivle',),
'keivler': ('keivle',),
'keivles': ('keivle',),
'keivla': ('keivle',),
'keivlet': ('keivle',),
'keivla': ('keivle',),
'keivlet': ('keivle',),
'keivl': ('keivle',),
'keivle': ('keivle',),
'keivl': ('keivle',),
'keivle': ('keivle',),
'kibbe': ('kibbe',),
'kibber': ('kibbe',),
'kibbes': ('kibbe',),
'kibba': ('kibbe',),
'kibbet': ('kibbe',),
'kibba': ('kibbe',),
'kibbet': ('kibbe',),
'kibb': ('kibbe',),
'kidnappe': ('kidnappe',),
'kidnapper': ('kidnappe',),
'kidnappes': ('kidnappe',),
'kidnappa': ('kidnappe',),
'kidnappet': ('kidnappe',),
'kidnappa': ('kidnappe',),
'kidnappet': ('kidnappe',),
'kidnapp': ('kidnappe',),
'kike': ('kike',),
'kiker': ('kike',),
'kikes': ('kike',),
'kika': ('kike',),
'kiket': ('kike',),
'kika': ('kike',),
'kiket': ('kike',),
'kik': ('kike',),
'kike': ('kike',),
'kiker': ('kike',),
'kikes': ('kike',),
'kikte': ('kike',),
'kikt': ('kike',),
'kik': ('kike',),
'kikke': ('kikke',),
'kikker': ('kikke',),
'kikkes': ('kikke',),
'kikka': ('kikke',),
'kikket': ('kikke',),
'kikka': ('kikke',),
'kikket': ('kikke',),
'kikk': ('kikke',),
'kikne': ('kikne',),
'kikner': ('kikne',),
'kiknes': ('kikne',),
'kikna': ('kikne',),
'kiknet': ('kikne',),
'kikna': ('kikne',),
'kiknet': ('kikne',),
'kikn': ('kikne',),
'kikne': ('kikne',),
'kikn': ('kikne',),
'kikne': ('kikne',),
'kikre': ('kikre',),
'kikrer': ('kikre',),
'kikres': ('kikre',),
'kikra': ('kikre',),
'kikret': ('kikre',),
'kikra': ('kikre',),
'kikret': ('kikre',),
'kikr': ('kikre',),
'kikre': ('kikre',),
'kikr': ('kikre',),
'kikre': ('kikre',),
'kikse': ('kikse',),
'kikser': ('kikse',),
'kikses': ('kikse',),
'kiksa': ('kikse',),
'kikset': ('kikse',),
'kiksa': ('kikse',),
'kikset': ('kikse',),
'kiks': ('kikse',),
'kildre': ('kildre',),
'kildrer': ('kildre',),
'kildres': ('kildre',),
'kildra': ('kildre',),
'kildret': ('kildre',),
'kildra': ('kildre',),
'kildret': ('kildre',),
'kildr': ('kildre',),
'kildre': ('kildre',),
'kildr': ('kildre',),
'kildre': ('kildre',),
'kile': ('kile',),
'kiler': ('kile',),
'kiles': ('kile',),
'kilte': ('kile',),
'kilt': ('kile',),
'kil': ('kile',),
'kime': ('kime',),
'kimer': ('kime',),
'kimes': ('kime',),
'kima': ('kime',),
'kimet': ('kime',),
'kimte': ('kime',),
'kima': ('kime',),
'kimet': ('kime',),
'kimt': ('kime',),
'kim': ('kime',),
'kimse': ('kimse',),
'kimser': ('kimse',),
'kimses': ('kimse',),
'kimsa': ('kimse',),
'kimset': ('kimse',),
'kimsa': ('kimse',),
'kimset': ('kimse',),
'kims': ('kimse',),
'kingse': ('kingse',),
'kingser': ('kingse',),
'kingses': ('kingse',),
'kingsa': ('kingse',),
'kingset': ('kingse',),
'kingsa': ('kingse',),
'kingset': ('kingse',),
'kings': ('kingse',),
'kinke': ('kinke',),
'kinker': ('kinke',),
'kinkes': ('kinke',),
'kinka': ('kinke',),
'kinket': ('kinke',),
'kinka': ('kinke',),
'kinket': ('kinke',),
'kink': ('kinke',),
'kinkse': ('kinkse',),
'kinkser': ('kinkse',),
'kinkses': ('kinkse',),
'kinksa': ('kinkse',),
'kinkset': ('kinkse',),
'kinksa': ('kinkse',),
'kinkset': ('kinkse',),
'kinks': ('kinkse',),
'kinne': ('kinne',),
'kinner': ('kinne',),
'kinnes': ('kinne',),
'kinna': ('kinne',),
'kinnet': ('kinne',),
'kinna': ('kinne',),
'kinnet': ('kinne',),
'kinn': ('kinne',),
'kippe': ('kippe',),
'kipper': ('kippe',),
'kippes': ('kippe',),
'kippa': ('kippe',),
'kippet': ('kippe',),
'kipte': ('kippe',),
'kippa': ('kippe',),
'kippet': ('kippe',),
'kipt': ('kippe',),
'kipp': ('kippe',),
'kisle': ('kisle',),
'kisler': ('kisle',),
'kisles': ('kisle',),
'kisla': ('kisle',),
'kislet': ('kisle',),
'kisla': ('kisle',),
'kislet': ('kisle',),
'kisl': ('kisle',),
'kitle': ('kitle',),
'kitler': ('kitle',),
'kitles': ('kitle',),
'kitla': ('kitle',),
'kitlet': ('kitle',),
'kitla': ('kitle',),
'kitlet': ('kitle',),
'kitl': ('kitle',),
'kitle': ('kitle',),
'kitl': ('kitle',),
'kitle': ('kitle',),
'kitte': ('kitte',),
'kitter': ('kitte',),
'kittes': ('kitte',),
'kitta': ('kitte',),
'kittet': ('kitte',),
'kitta': ('kitte',),
'kittet': ('kitte',),
'kitt': ('kitte',),
'kive': ('kive',),
'kiver': ('kive',),
'kives': ('kive',),
'kiva': ('kive',),
'kivet': ('kive',),
'kivde': ('kive',),
'kiva': ('kive',),
'kivet': ('kive',),
'kivd': ('kive',),
'kiv': ('kive',),
'kives': ('kives',),
'kivdes': ('kives',),
'kives': ('kives',),
'kjakse': ('kjakse',),
'kjakser': ('kjakse',),
'kjakses': ('kjakse',),
'kjaksa': ('kjakse',),
'kjakset': ('kjakse',),
'kjaksa': ('kjakse',),
'kjakset': ('kjakse',),
'kjaks': ('kjakse',),
'kjangse': ('kjangse',),
'kjangser': ('kjangse',),
'kjangses': ('kjangse',),
'kjangsa': ('kjangse',),
'kjangset': ('kjangse',),
'kjangsa': ('kjangse',),
'kjangset': ('kjangse',),
'kjangs': ('kjangse',),
'kjappe': ('kjappe',),
'kjapper': ('kjappe',),
'kjappes': ('kjappe',),
'kjappa': ('kjappe',),
'kjappet': ('kjappe',),
'kjappa': ('kjappe',),
'kjappet': ('kjappe',),
'kjapp': ('kjappe',),
'kjase': ('kjase',),
'kjaser': ('kjase',),
'kjases': ('kjase',),
'kjaste': ('kjase',),
'kjast': ('kjase',),
'kjas': ('kjase',),
'kjave': ('kjave',),
'kjaver': ('kjave',),
'kjaves': ('kjave',),
'kjava': ('kjave',),
'kjavet': ('kjave',),
'kjavde': ('kjave',),
'kjava': ('kjave',),
'kjavet': ('kjave',),
'kjavd': ('kjave',),
'kjav': ('kjave',),
'kjede': ('kjede',),
'kjeder': ('kjede',),
'kjedes': ('kjede',),
'kjeda': ('kjede',),
'kjedet': ('kjede',),
'kjeda': ('kjede',),
'kjedet': ('kjede',),
'kjed': ('kjede',),
'kjederøyke': ('kjederøyke',),
'kjederøyker': ('kjederøyke',),
'kjederøykes': ('kjederøyke',),
'kjederøyka': ('kjederøyke',),
'kjederøykte': ('kjederøyke',),
'kjederøyka': ('kjederøyke',),
'kjederøykt': ('kjederøyke',),
'kjederøyk': ('kjederøyke',),
'kjee': ('kjee',),
'kjeer': ('kjee',),
'kjees': ('kjee',),
'kjea': ('kjee',),
'kjeet': ('kjee',),
'kjea': ('kjee',),
'kjeet': ('kjee',),
'kje': ('kjee',),
'kjefte': ('kjefte',),
'kjefter': ('kjefte',),
'kjeftes': ('kjefte',),
'kjefta': ('kjefte',),
'kjeftet': ('kjefte',),
'kjefta': ('kjefte',),
'kjeftet': ('kjefte',),
'kjeft': ('kjefte',),
'kjekke': ('kjekke',),
'kjekker': ('kjekke',),
'kjekkes': ('kjekke',),
'kjekka': ('kjekke',),
'kjekket': ('kjekke',),
'kjekka': ('kjekke',),
'kjekket': ('kjekke',),
'kjekk': ('kjekke',),
'kjekle': ('kjekle',),
'kjekler': ('kjekle',),
'kjekles': ('kjekle',),
'kjekla': ('kjekle',),
'kjeklet': ('kjekle',),
'kjekla': ('kjekle',),
'kjeklet': ('kjekle',),
'kjekl': ('kjekle',),
'kjekle': ('kjekle',),
'kjekl': ('kjekle',),
'kjekle': ('kjekle',),
'kjekse': ('kjekse',),
'kjekser': ('kjekse',),
'kjekses': ('kjekse',),
'kjeksa': ('kjekse',),
'kjekset': ('kjekse',),
'kjeksa': ('kjekse',),
'kjekset': ('kjekse',),
'kjeks': ('kjekse',),
'kjemme': ('kjemme',),
'kjemmer': ('kjemme',),
'kjemmes': ('kjemme',),
'kjemma': ('kjemme',),
'kjemmet': ('kjemme',),
'kjemte': ('kjemme',),
'kjemma': ('kjemme',),
'kjemmet': ('kjemme',),
'kjemt': ('kjemme',),
'kjem': ('kjemme',),
'kjempe': ('kjempe',),
'kjemper': ('kjempe',),
'kjempes': ('kjempe',),
'kjempa': ('kjempe',),
'kjempet': ('kjempe',),
'kjempa': ('kjempe',),
'kjempet': ('kjempe',),
'kjemp': ('kjempe',),
'kjenne': ('kjenne',),
'kjenner': ('kjenne',),
'kjennes': ('kjenne',),
'kjente': ('kjenne',),
'kjent': ('kjenne',),
'kjenn': ('kjenne',),
'kjennetegne': ('kjennetegne',),
'kjennetegner': ('kjennetegne',),
'kjennetegnes': ('kjennetegne',),
'kjennetegna': ('kjennetegne',),
'kjennetegnet': ('kjennetegne',),
'kjennetegna': ('kjennetegne',),
'kjennetegnet': ('kjennetegne',),
'kjennetegn': ('kjennetegne',),
'kjeppjage': ('kjeppjage',),
'kjeppjager': ('kjeppjage',),
'kjeppjages': ('kjeppjage',),
'kjeppjaga': ('kjeppjage',),
'kjeppjaget': ('kjeppjage',),
'kjeppjagde': ('kjeppjage',),
'kjeppjaga': ('kjeppjage',),
'kjeppjaget': ('kjeppjage',),
'kjeppjagd': ('kjeppjage',),
'kjeppjag': ('kjeppjage',),
'kjerne': ('kjerne',),
'kjerner': ('kjerne',),
'kjernes': ('kjerne',),
'kjerna': ('kjerne',),
'kjernet': ('kjerne',),
'kjerna': ('kjerne',),
'kjernet': ('kjerne',),
'kjern': ('kjerne',),
'kjerve': ('kjerve',),
'kjerver': ('kjerve',),
'kjerves': ('kjerve',),
'kjerva': ('kjerve',),
'kjervet': ('kjerve',),
'kjerva': ('kjerve',),
'kjervet': ('kjerve',),
'kjerv': ('kjerve',),
'kjese': ('kjese',),
'kjeser': ('kjese',),
'kjeses': ('kjese',),
'kjeste': ('kjese',),
'kjest': ('kjese',),
'kjes': ('kjese',),
'kjeske': ('kjeske',),
'kjesker': ('kjeske',),
'kjeskes': ('kjeske',),
'kjeska': ('kjeske',),
'kjesket': ('kjeske',),
'kjeska': ('kjeske',),
'kjesket': ('kjeske',),
'kjesk': ('kjeske',),
'kjevle': ('kjevle',),
'kjevler': ('kjevle',),
'kjevles': ('kjevle',),
'kjevla': ('kjevle',),
'kjevlet': ('kjevle',),
'kjevla': ('kjevle',),
'kjevlet': ('kjevle',),
'kjevl': ('kjevle',),
'kjevle': ('kjevle',),
'kjevl': ('kjevle',),
'kjevle': ('kjevle',),
'kjæle': ('kjæle',),
'kjæler': ('kjæle',),
'kjæles': ('kjæle',),
'kjælte': ('kjæle',),
'kjælt': ('kjæle',),
'kjæl': ('kjæle',),
'kjære': ('kjære',),
'kjærer': ('kjære',),
'kjæres': ('kjære',),
'kjærte': ('kjære',),
'kjært': ('kjære',),
'kjær': ('kjære',),
'kjærtegne': ('kjærtegne',),
'kjærtegner': ('kjærtegne',),
'kjærtegnes': ('kjærtegne',),
'kjærtegna': ('kjærtegne',),
'kjærtegnet': ('kjærtegne',),
'kjærtegna': ('kjærtegne',),
'kjærtegnet': ('kjærtegne',),
'kjærtegn': ('kjærtegne',),
'kjæte': ('kjæte',),
'kjæter': ('kjæte',),
'kjætes': ('kjæte',),
'kjætte': ('kjæte',),
'kjætt': ('kjæte',),
'kjæt': ('kjæte',),
'kjøle': ('kjøle',),
'kjøler': ('kjøle',),
'kjøles': ('kjøle',),
'kjølte': ('kjøle',),
'kjølt': ('kjøle',),
'kjøl': ('kjøle',),
'kjølhale': ('kjølhale',),
'kjølhaler': ('kjølhale',),
'kjølhales': ('kjølhale',),
'kjølhala': ('kjølhale',),
'kjølhalet': ('kjølhale',),
'kjølhalte': ('kjølhale',),
'kjølhala': ('kjølhale',),
'kjølhalet': ('kjølhale',),
'kjølhalt': ('kjølhale',),
'kjølhal': ('kjølhale',),
'kjølne': ('kjølne',),
'kjølner': ('kjølne',),
'kjølnes': ('kjølne',),
'kjølna': ('kjølne',),
'kjølnet': ('kjølne',),
'kjølna': ('kjølne',),
'kjølnet': ('kjølne',),
'kjøln': ('kjølne',),
'kjølne': ('kjølne',),
'kjøln': ('kjølne',),
'kjølne': ('kjølne',),
'kjøpe': ('kjøpe',),
'kjøper': ('kjøpe',),
'kjøpes': ('kjøpe',),
'kjøpte': ('kjøpe',),
'kjøpt': ('kjøpe',),
'kjøp': ('kjøpe',),
'kjøre': ('kjøre',),
'kjører': ('kjøre',),
'kjøres': ('kjøre',),
'kjørte': ('kjøre',),
'kjørt': ('kjøre',),
'kjør': ('kjøre',),
'kjørne': ('kjørne',),
'kjørner': ('kjørne',),
'kjørnes': ('kjørne',),
'kjørna': ('kjørne',),
'kjørnet': ('kjørne',),
'kjørna': ('kjørne',),
'kjørnet': ('kjørne',),
'kjørn': ('kjørne',),
'kjøve': ('kjøve',),
'kjøver': ('kjøve',),
'kjøves': ('kjøve',),
'kjøvde': ('kjøve',),
'kjøvd': ('kjøve',),
'kjøv': ('kjøve',),
'klabbe': ('klabbe',),
'klabber': ('klabbe',),
'klabbes': ('klabbe',),
'klabba': ('klabbe',),
'klabbet': ('klabbe',),
'klabba': ('klabbe',),
'klabbet': ('klabbe',),
'klabb': ('klabbe',),
'kladde': ('kladde',),
'kladder': ('kladde',),
'kladdes': ('kladde',),
'kladda': ('kladde',),
'kladdet': ('kladde',),
'kladda': ('kladde',),
'kladdet': ('kladde',),
'kladd': ('kladde',),
'klaffe': ('klaffe',),
'klaffer': ('klaffe',),
'klaffes': ('klaffe',),
'klaffa': ('klaffe',),
'klaffet': ('klaffe',),
'klaffa': ('klaffe',),
'klaffet': ('klaffe',),
'klaff': ('klaffe',),
'klage': ('klage',),
'klager': ('klage',),
'klages': ('klage',),
'klaga': ('klage',),
'klaget': ('klage',),
'klagde': ('klage',),
'klaga': ('klage',),
'klaget': ('klage',),
'klagd': ('klage',),
'klag': ('klage',),
'klake': ('klake',),
'klaker': ('klake',),
'klakes': ('klake',),
'klaka': ('klake',),
'klaket': ('klake',),
'klaka': ('klake',),
'klaket': ('klake',),
'klak': ('klake',),
'klakke': ('klakke',),
'klakker': ('klakke',),
'klakkes': ('klakke',),
'klakka': ('klakke',),
'klakket': ('klakke',),
'klakka': ('klakke',),
'klakket': ('klakke',),
'klakk': ('klakke',),
'klampe': ('klampe',),
'klamper': ('klampe',),
'klampes': ('klampe',),
'klampa': ('klampe',),
'klampet': ('klampe',),
'klampa': ('klampe',),
'klampet': ('klampe',),
'klamp': ('klampe',),
'klamre': ('klamre',),
'klamrer': ('klamre',),
'klamres': ('klamre',),
'klamra': ('klamre',),
'klamret': ('klamre',),
'klamra': ('klamre',),
'klamret': ('klamre',),
'klamr': ('klamre',),
'klamre': ('klamre',),
'klamr': ('klamre',),
'klamre': ('klamre',),
'klandre': ('klandre',),
'klandrer': ('klandre',),
'klandres': ('klandre',),
'klandra': ('klandre',),
'klandret': ('klandre',),
'klandra': ('klandre',),
'klandret': ('klandre',),
'klandr': ('klandre',),
'klandre': ('klandre',),
'klandr': ('klandre',),
'klandre': ('klandre',),
'klappe': ('klappe',),
'klapper': ('klappe',),
'klappes': ('klappe',),
'klappa': ('klappe',),
'klappet': ('klappe',),
'klappa': ('klappe',),
'klappet': ('klappe',),
'klapp': ('klappe',),
'klapre': ('klapre',),
'klaprer': ('klapre',),
'klapres': ('klapre',),
'klapra': ('klapre',),
'klapret': ('klapre',),
'klapra': ('klapre',),
'klapret': ('klapre',),
'klapr': ('klapre',),
'klapre': ('klapre',),
'klapr': ('klapre',),
'klapre': ('klapre',),
'klapse': ('klapse',),
'klapser': ('klapse',),
'klapses': ('klapse',),
'klapsa': ('klapse',),
'klapset': ('klapse',),
'klapsa': ('klapse',),
'klapset': ('klapse',),
'klaps': ('klapse',),
'klare': ('klare',),
'klarer': ('klare',),
'klares': ('klare',),
'klara': ('klare',),
'klaret': ('klare',),
'klarte': ('klare',),
'klara': ('klare',),
'klaret': ('klare',),
'klart': ('klare',),
'klar': ('klare',),
'klare': ('klare',),
'klarer': ('klare',),
'klares': ('klare',),
'klarte': ('klare',),
'klart': ('klare',),
'klar': ('klare',),
'klarere': ('klarere',),
'klarerer': ('klarere',),
'klareres': ('klarere',),
'klarerte': ('klarere',),
'klarert': ('klarere',),
'klarer': ('klarere',),
'klargjøre': ('klargjøre',),
'klargjør': ('klargjøre',),
'klargjøres': ('klargjøre',),
'klargjorde': ('klargjøre',),
'klargjort': ('klargjøre',),
'klargjør': ('klargjøre',),
'klarlegge': ('klarlegge',),
'klarlegger': ('klarlegge',),
'klarlegges': ('klarlegge',),
'klarla': ('klarlegge',),
'klarlagt': ('klarlegge',),
'klarlegg': ('klarlegge',),
'klarne': ('klarne',),
'klarner': ('klarne',),
'klarnes': ('klarne',),
'klarna': ('klarne',),
'klarnet': ('klarne',),
'klarna': ('klarne',),
'klarnet': ('klarne',),
'klarn': ('klarne',),
'klarne': ('klarne',),
'klarn': ('klarne',),
'klarne': ('klarne',),
'klase': ('klase',),
'klaser': ('klase',),
'klases': ('klase',),
'klasa': ('klase',),
'klaset': ('klase',),
'klaste': ('klase',),
'klasa': ('klase',),
'klaset': ('klase',),
'klast': ('klase',),
'klas': ('klase',),
'klaske': ('klaske',),
'klasker': ('klaske',),
'klaskes': ('klaske',),
'klaska': ('klaske',),
'klasket': ('klaske',),
'klaska': ('klaske',),
'klasket': ('klaske',),
'klask': ('klaske',),
'klasse': ('klasse',),
'klasser': ('klasse',),
'klasses': ('klasse',),
'klassa': ('klasse',),
'klasset': ('klasse',),
'klassa': ('klasse',),
'klasset': ('klasse',),
'klass': ('klasse',),
'klassifisere': ('klassifisere',),
'klassifiserer': ('klassifisere',),
'klassifiseres': ('klassifisere',),
'klassifiserte': ('klassifisere',),
'klassifisert': ('klassifisere',),
'klassifiser': ('klassifisere',),
'klatre': ('klatre',),
'klatrer': ('klatre',),
'klatres': ('klatre',),
'klatra': ('klatre',),
'klatret': ('klatre',),
'klatra': ('klatre',),
'klatret': ('klatre',),
'klatr': ('klatre',),
'klatre': ('klatre',),
'klatr': ('klatre',),
'klatre': ('klatre',),
'klatte': ('klatte',),
'klatter': ('klatte',),
'klattes': ('klatte',),
'klatta': ('klatte',),
'klattet': ('klatte',),
'klatta': ('klatte',),
'klattet': ('klatte',),
'klatt': ('klatte',),
'klattemale': ('klattemale',),
'klattemaler': ('klattemale',),
'klattemales': ('klattemale',),
'klattemalte': ('klattemale',),
'klattemalt': ('klattemale',),
'klattemal': ('klattemale',),
'klattmale': ('klattmale',),
'klattmaler': ('klattmale',),
'klattmales': ('klattmale',),
'klattmalte': ('klattmale',),
'klattmalt': ('klattmale',),
'klattmal': ('klattmale',),
'klausulere': ('klausulere',),
'klausulerer': ('klausulere',),
'klausuleres': ('klausulere',),
'klausulerte': ('klausulere',),
'klausulert': ('klausulere',),
'klausuler': ('klausulere',),
'klave': ('klave',),
'klaver': ('klave',),
'klaves': ('klave',),
'klava': ('klave',),
'klavet': ('klave',),
'klavde': ('klave',),
'klava': ('klave',),
'klavet': ('klave',),
'klavd': ('klave',),
'klav': ('klave',),
'klavebinde': ('klavebinde',),
'klavebinder': ('klavebinde',),
'klavebindes': ('klavebinde',),
'klavebandt': ('klavebinde',),
'klavebundet': ('klavebinde',),
'klavebind': ('klavebinde',),
'kle': ('kle',),
'kler': ('kle',),
'kles': ('kle',),
'kledde': ('kle',),
'kledd': ('kle',),
'kle': ('kle',),
'klebe': ('klebe',),
'kleber': ('klebe',),
'klebes': ('klebe',),
'kleba': ('klebe',),
'klebet': ('klebe',),
'klebte': ('klebe',),
'kleba': ('klebe',),
'klebet': ('klebe',),
'klebt': ('klebe',),
'kleb': ('klebe',),
'klede': ('klede',),
'kleder': ('klede',),
'kledes': ('klede',),
'kledde': ('klede',),
'kledd': ('klede',),
'kled': ('klede',),
'kleie': ('kleie',),
'kleier': ('kleie',),
'kleies': ('kleie',),
'kleia': ('kleie',),
'kleiet': ('kleie',),
'kleide': ('kleie',),
'kleia': ('kleie',),
'kleiet': ('kleie',),
'kleid': ('kleie',),
'klei': ('kleie',),
'kleime': ('kleime',),
'kleimer': ('kleime',),
'kleimes': ('kleime',),
'kleimte': ('kleime',),
'kleimt': ('kleime',),
'kleim': ('kleime',),
'kleise': ('kleise',),
'kleiser': ('kleise',),
'kleises': ('kleise',),
'kleisa': ('kleise',),
'kleiset': ('kleise',),
'kleiste': ('kleise',),
'kleisa': ('kleise',),
'kleiset': ('kleise',),
'kleist': ('kleise',),
'kleis': ('kleise',),
'klekke': ('klekke',),
'klekker': ('klekke',),
'klekkes': ('klekke',),
'klekka': ('klekke',),
'klekket': ('klekke',),
'klekte': ('klekke',),
'klekka': ('klekke',),
'klekket': ('klekke',),
'klekt': ('klekke',),
'klekk': ('klekke',),
'klemme': ('klemme',),
'klemmer': ('klemme',),
'klemmes': ('klemme',),
'klemte': ('klemme',),
'klemt': ('klemme',),
'klem': ('klemme',),
'klemte': ('klemte',),
'klemter': ('klemte',),
'klemtes': ('klemte',),
'klemta': ('klemte',),
'klemtet': ('klemte',),
'klemta': ('klemte',),
'klemtet': ('klemte',),
'klemt': ('klemte',),
'klenge': ('klenge',),
'klenger': ('klenge',),
'klenges': ('klenge',),
'klengte': ('klenge',),
'klengt': ('klenge',),
'kleng': ('klenge',),
'klenge': ('klenge',),
'klenger': ('klenge',),
'klenges': ('klenge',),
'klenget': ('klenge',),
'klengte': ('klenge',),
'klenget': ('klenge',),
'klengt': ('klenge',),
'kleng': ('klenge',),
'kleppe': ('kleppe',),
'klepper': ('kleppe',),
'kleppes': ('kleppe',),
'kleppa': ('kleppe',),
'kleppet': ('kleppe',),
'kleppa': ('kleppe',),
'kleppet': ('kleppe',),
'klepp': ('kleppe',),
'klikke': ('klikke',),
'klikker': ('klikke',),
'klikkes': ('klikke',),
'klikka': ('klikke',),
'klikket': ('klikke',),
'klikka': ('klikke',),
'klikket': ('klikke',),
'klikk': ('klikke',),
'klimatisere': ('klimatisere',),
'klimatiserer': ('klimatisere',),
'klimatiseres': ('klimatisere',),
'klimatiserte': ('klimatisere',),
'klimatisert': ('klimatisere',),
'klimatiser': ('klimatisere',),
'klimpre': ('klimpre',),
'klimprer': ('klimpre',),
'klimpres': ('klimpre',),
'klimpra': ('klimpre',),
'klimpret': ('klimpre',),
'klimpra': ('klimpre',),
'klimpret': ('klimpre',),
'klimpr': ('klimpre',),
'klimpre': ('klimpre',),
'klimpr': ('klimpre',),
'klimpre': ('klimpre',),
'kline': ('kline',),
'kliner': ('kline',),
'klines': ('kline',),
'klinte': ('kline',),
'klint': ('kline',),
'klin': ('kline',),
'klinge': ('klinge',),
'klinger': ('klinge',),
'klinges': ('klinge',),
'klang': ('klinge',),
'klinget': ('klinge',),
'klingt': ('klinge',),
'kling': ('klinge',),
'klingre': ('klingre',),
'klingrer': ('klingre',),
'klingres': ('klingre',),
'klingra': ('klingre',),
'klingret': ('klingre',),
'klingra': ('klingre',),
'klingret': ('klingre',),
'klingr': ('klingre',),
'klingre': ('klingre',),
'klingr': ('klingre',),
'klingre': ('klingre',),
'klinke': ('klinke',),
'klinker': ('klinke',),
'klinkes': ('klinke',),
'klinka': ('klinke',),
'klinket': ('klinke',),
'klinka': ('klinke',),
'klinket': ('klinke',),
'klink': ('klinke',),
'klipe': ('klipe',),
'kliper': ('klipe',),
'klipes': ('klipe',),
'kleip': ('klipe',),
'klipt': ('klipe',),
'klip': ('klipe',),
'klippe': ('klippe',),
'klipper': ('klippe',),
'klippes': ('klippe',),
'klippa': ('klippe',),
'klippet': ('klippe',),
'klipte': ('klippe',),
'klippa': ('klippe',),
'klippet': ('klippe',),
'klipt': ('klippe',),
'klipp': ('klippe',),
'klirre': ('klirre',),
'klirrer': ('klirre',),
'klirres': ('klirre',),
'klirra': ('klirre',),
'klirret': ('klirre',),
'klirra': ('klirre',),
'klirret': ('klirre',),
'klirr': ('klirre',),
'klisjere': ('klisjere',),
'klisjerer': ('klisjere',),
'klisjeres': ('klisjere',),
'klisjerte': ('klisjere',),
'klisjert': ('klisjere',),
'klisjer': ('klisjere',),
'klisse': ('klisse',),
'klisser': ('klisse',),
'klisses': ('klisse',),
'klissa': ('klisse',),
'klisset': ('klisse',),
'klissa': ('klisse',),
'klisset': ('klisse',),
'kliss': ('klisse',),
'klistre': ('klistre',),
'klistrer': ('klistre',),
'klistres': ('klistre',),
'klistra': ('klistre',),
'klistret': ('klistre',),
'klistra': ('klistre',),
'klistret': ('klistre',),
'klistr': ('klistre',),
'klistre': ('klistre',),
'klistr': ('klistre',),
'klistre': ('klistre',),
'klive': ('klive',),
'kliver': ('klive',),
'klives': ('klive',),
'kleiv': ('klive',),
'klevet': ('klive',),
'klivd': ('klive',),
'kliv': ('klive',),
'kloakkere': ('kloakkere',),
'kloakkerer': ('kloakkere',),
'kloakkeres': ('kloakkere',),
'kloakkerte': ('kloakkere',),
'kloakkert': ('kloakkere',),
'kloakker': ('kloakkere',),
'klokke': ('klokke',),
'klokker': ('klokke',),
'klokkes': ('klokke',),
'klokka': ('klokke',),
'klokket': ('klokke',),
'klokka': ('klokke',),
'klokket': ('klokke',),
'klokk': ('klokke',),
'klone': ('klone',),
'kloner': ('klone',),
'klones': ('klone',),
'klona': ('klone',),
'klonet': ('klone',),
'klona': ('klone',),
'klonet': ('klone',),
'klon': ('klone',),
'klore': ('klore',),
'klorer': ('klore',),
'klores': ('klore',),
'klorte': ('klore',),
'klort': ('klore',),
'klor': ('klore',),
'klorere': ('klorere',),
'klorerer': ('klorere',),
'kloreres': ('klorere',),
'klorerte': ('klorere',),
'klorert': ('klorere',),
'klorer': ('klorere',),
'kloroformere': ('kloroformere',),
'kloroformerer': ('kloroformere',),
'kloroformeres': ('kloroformere',),
'kloroformerte': ('kloroformere',),
'kloroformert': ('kloroformere',),
'kloroformer': ('kloroformere',),
'klovne': ('klovne',),
'klovner': ('klovne',),
'klovnes': ('klovne',),
'klovna': ('klovne',),
'klovnet': ('klovne',),
'klovna': ('klovne',),
'klovnet': ('klovne',),
'klovn': ('klovne',),
'klubbe': ('klubbe',),
'klubber': ('klubbe',),
'klubbes': ('klubbe',),
'klubba': ('klubbe',),
'klubbet': ('klubbe',),
'klubba': ('klubbe',),
'klubbet': ('klubbe',),
'klubb': ('klubbe',),
'kludre': ('kludre',),
'kludrer': ('kludre',),
'kludres': ('kludre',),
'kludra': ('kludre',),
'kludret': ('kludre',),
'kludra': ('kludre',),
'kludret': ('kludre',),
'kludr': ('kludre',),
'kludre': ('kludre',),
'kludr': ('kludre',),
'kludre': ('kludre',),
'klukke': ('klukke',),
'klukker': ('klukke',),
'klukkes': ('klukke',),
'klukka': ('klukke',),
'klukket': ('klukke',),
'klukka': ('klukke',),
'klukket': ('klukke',),
'klukk': ('klukke',),
'klumpe': ('klumpe',),
'klumper': ('klumpe',),
'klumpes': ('klumpe',),
'klumpa': ('klumpe',),
'klumpet': ('klumpe',),
'klumpa': ('klumpe',),
'klumpet': ('klumpe',),
'klump': ('klumpe',),
'klumse': ('klumse',),
'klumser': ('klumse',),
'klumses': ('klumse',),
'klumsa': ('klumse',),
'klumset': ('klumse',),
'klumsa': ('klumse',),
'klumset': ('klumse',),
'klums': ('klumse',),
'klundre': ('klundre',),
'klundrer': ('klundre',),
'klundres': ('klundre',),
'klundra': ('klundre',),
'klundret': ('klundre',),
'klundra': ('klundre',),
'klundret': ('klundre',),
'klundr': ('klundre',),
'klundre': ('klundre',),
'klundr': ('klundre',),
'klundre': ('klundre',),
'klunke': ('klunke',),
'klunker': ('klunke',),
'klunkes': ('klunke',),
'klunka': ('klunke',),
'klunket': ('klunke',),
'klunka': ('klunke',),
'klunket': ('klunke',),
'klunk': ('klunke',),
'klusse': ('klusse',),
'klusser': ('klusse',),
'klusses': ('klusse',),
'klussa': ('klusse',),
'klusset': ('klusse',),
'klussa': ('klusse',),
'klusset': ('klusse',),
'kluss': ('klusse',),
'klynge': ('klynge',),
'klynger': ('klynge',),
'klynges': ('klynge',),
'klynga': ('klynge',),
'klynget': ('klynge',),
'klynga': ('klynge',),
'klynget': ('klynge',),
'klyng': ('klynge',),
'klynke': ('klynke',),
'klynker': ('klynke',),
'klynkes': ('klynke',),
'klynka': ('klynke',),
'klynket': ('klynke',),
'klynka': ('klynke',),
'klynket': ('klynke',),
'klynk': ('klynke',),
'klype': ('klype',),
'klyper': ('klype',),
'klypes': ('klype',),
'klypte': ('klype',),
'kløp': ('klype',),
'klypt': ('klype',),
'kløpet': ('klype',),
'klyp': ('klype',),
'klyve': ('klyve',),
'klyver': ('klyve',),
'klyves': ('klyve',),
'klyvde': ('klyve',),
'kløyv': ('klyve',),
'kløv': ('klyve',),
'kløyv': ('klyve',),
'klyvd': ('klyve',),
'kløvet': ('klyve',),
'klyvd': ('klyve',),
'klyv': ('klyve',),
'klå': ('klå',),
'klår': ('klå',),
'klås': ('klå',),
'klådde': ('klå',),
'klådd': ('klå',),
'klå': ('klå',),
'klø': ('klø',),
'klør': ('klø',),
'kløs': ('klø',),
'klødde': ('klø',),
'klødd': ('klø',),
'klø': ('klø',),
'kløfte': ('kløfte',),
'kløfter': ('kløfte',),
'kløftes': ('kløfte',),
'kløfta': ('kløfte',),
'kløftet': ('kløfte',),
'kløfta': ('kløfte',),
'kløftet': ('kløfte',),
'kløft': ('kløfte',),
'kløkke': ('kløkke',),
'kløkker': ('kløkke',),
'kløkkes': ('kløkke',),
'kløkte': ('kløkke',),
'kløkt': ('kløkke',),
'kløkk': ('kløkke',),
'kløne': ('kløne',),
'kløner': ('kløne',),
'klønes': ('kløne',),
'klønte': ('kløne',),
'klønt': ('kløne',),
'kløn': ('kløne',),
'kløtsje': ('kløtsje',),
'kløtsjer': ('kløtsje',),
'kløtsjes': ('kløtsje',),
'kløtsja': ('kløtsje',),
'kløtsjet': ('kløtsje',),
'kløtsja': ('kløtsje',),
'kløtsjet': ('kløtsje',),
'kløtsj': ('kløtsje',),
'kløve': ('kløve',),
'kløver': ('kløve',),
'kløves': ('kløve',),
'kløvde': ('kløve',),
'kløvd': ('kløve',),
'kløv': ('kløve',),
'kløvje': ('kløvje',),
'kløvjer': ('kløvje',),
'kløvjes': ('kløvje',),
'kløvja': ('kløvje',),
'kløvjet': ('kløvje',),
'kløvja': ('kløvje',),
'kløvjet': ('kløvje',),
'kløvj': ('kløvje',),
'kløvne': ('kløvne',),
'kløvner': ('kløvne',),
'kløvnes': ('kløvne',),
'kløvna': ('kløvne',),
'kløvnet': ('kløvne',),
'kløvna': ('kløvne',),
'kløvnet': ('kløvne',),
'kløvn': ('kløvne',),
'kløyve': ('kløyve',),
'kløyver': ('kløyve',),
'kløyves': ('kløyve',),
'kløyvde': ('kløyve',),
'kløyvd': ('kløyve',),
'kløyv': ('kløyve',),
'kna': ('kna',),
'knar': ('kna',),
'knas': ('kna',),
'knadde': ('kna',),
'knadd': ('kna',),
'kna': ('kna',),
'knabbe': ('knabbe',),
'knabber': ('knabbe',),
'knabbes': ('knabbe',),
'knabba': ('knabbe',),
'knabbet': ('knabbe',),
'knabba': ('knabbe',),
'knabbet': ('knabbe',),
'knabb': ('knabbe',),
'knake': ('knake',),
'knaker': ('knake',),
'knakes': ('knake',),
'knaka': ('knake',),
'knaket': ('knake',),
'knakte': ('knake',),
'knaka': ('knake',),
'knaket': ('knake',),
'knakt': ('knake',),
'knak': ('knake',),
'knakke': ('knakke',),
'knakker': ('knakke',),
'knakkes': ('knakke',),
'knakka': ('knakke',),
'knakket': ('knakke',),
'knakka': ('knakke',),
'knakket': ('knakke',),
'knakk': ('knakke',),
'knalle': ('knalle',),
'knaller': ('knalle',),
'knalles': ('knalle',),
'knalla': ('knalle',),
'knallet': ('knalle',),
'knalla': ('knalle',),
'knallet': ('knalle',),
'knall': ('knalle',),
'knappe': ('knappe',),
'knapper': ('knappe',),
'knappes': ('knappe',),
'knappa': ('knappe',),
'knappet': ('knappe',),
'knappa': ('knappe',),
'knappet': ('knappe',),
'knapp': ('knappe',),
'knarke': ('knarke',),
'knarker': ('knarke',),
'knarkes': ('knarke',),
'knarka': ('knarke',),
'knarket': ('knarke',),
'knarka': ('knarke',),
'knarket': ('knarke',),
'knark': ('knarke',),
'knarte': ('knarte',),
'knarter': ('knarte',),
'knartes': ('knarte',),
'knarta': ('knarte',),
'knartet': ('knarte',),
'knarta': ('knarte',),
'knartet': ('knarte',),
'knart': ('knarte',),
'knase': ('knase',),
'knaser': ('knase',),
'knases': ('knase',),
'knasa': ('knase',),
'knaset': ('knase',),
'knaste': ('knase',),
'knasa': ('knase',),
'knaset': ('knase',),
'knast': ('knase',),
'knas': ('knase',),
'knaske': ('knaske',),
'knasker': ('knaske',),
'knaskes': ('knaske',),
'knaska': ('knaske',),
'knasket': ('knaske',),
'knaska': ('knaske',),
'knasket': ('knaske',),
'knask': ('knaske',),
'knatre': ('knatre',),
'knatrer': ('knatre',),
'knatres': ('knatre',),
'knatra': ('knatre',),
'knatret': ('knatre',),
'knatra': ('knatre',),
'knatret': ('knatre',),
'knatr': ('knatre',),
'knatre': ('knatre',),
'knatr': ('knatre',),
'knatre': ('knatre',),
'knatte': ('knatte',),
'knatter': ('knatte',),
'knattes': ('knatte',),
'knatta': ('knatte',),
'knattet': ('knatte',),
'knatta': ('knatte',),
'knattet': ('knatte',),
'knatt': ('knatte',),
'kneble': ('kneble',),
'knebler': ('kneble',),
'knebles': ('kneble',),
'knebla': ('kneble',),
'kneblet': ('kneble',),
'knebla': ('kneble',),
'kneblet': ('kneble',),
'knebl': ('kneble',),
'kneble': ('kneble',),
'knebl': ('kneble',),
'kneble': ('kneble',),
'knege': ('knege',),
'kneger': ('knege',),
'kneges': ('knege',),
'knega': ('knege',),
'kneget': ('knege',),
'knega': ('knege',),
'kneget': ('knege',),
'kneg': ('knege',),
'knegge': ('knegge',),
'knegger': ('knegge',),
'knegges': ('knegge',),
'knegga': ('knegge',),
'knegget': ('knegge',),
'knegde': ('knegge',),
'knegga': ('knegge',),
'knegget': ('knegge',),
'knegd': ('knegge',),
'knegg': ('knegge',),
'knegå': ('knegå',),
'knegår': ('knegå',),
'knegås': ('knegå',),
'knegikk': ('knegå',),
'knegått': ('knegå',),
'knegå': ('knegå',),
'kneise': ('kneise',),
'kneiser': ('kneise',),
'kneises': ('kneise',),
'kneiste': ('kneise',),
'kneist': ('kneise',),
'kneis': ('kneise',),
'knekke': ('knekke',),
'knekker': ('knekke',),
'knekkes': ('knekke',),
'knekka': ('knekke',),
'knekket': ('knekke',),
'knekte': ('knekke',),
'knekka': ('knekke',),
'knekket': ('knekke',),
'knekt': ('knekke',),
'knekk': ('knekke',),
'knekke': ('knekke',),
'knekker': ('knekke',),
'knekkes': ('knekke',),
'knakk': ('knekke',),
'knekt': ('knekke',),
'knekket': ('knekke',),
'knekk': ('knekke',),
'knekte': ('knekte',),
'knekter': ('knekte',),
'knektes': ('knekte',),
'knekta': ('knekte',),
'knektet': ('knekte',),
'knekta': ('knekte',),
'knektet': ('knekte',),
'knekt': ('knekte',),
'knele': ('knele',),
'kneler': ('knele',),
'kneles': ('knele',),
'knelte': ('knele',),
'knelt': ('knele',),
'knel': ('knele',),
'kneppe': ('kneppe',),
'knepper': ('kneppe',),
'kneppes': ('kneppe',),
'kneppet': ('kneppe',),
'knepte': ('kneppe',),
'kneppet': ('kneppe',),
'knept': ('kneppe',),
'knepp': ('kneppe',),
'kneppe': ('kneppe',),
'knepper': ('kneppe',),
'kneppes': ('kneppe',),
'kneppet': ('kneppe',),
'knepte': ('kneppe',),
'kneppet': ('kneppe',),
'knept': ('kneppe',),
'knepp': ('kneppe',),
'knepre': ('knepre',),
'kneprer': ('knepre',),
'knepres': ('knepre',),
'knepra': ('knepre',),
'knepret': ('knepre',),
'knepra': ('knepre',),
'knepret': ('knepre',),
'knepr': ('knepre',),
'knepre': ('knepre',),
'knepr': ('knepre',),
'knepre': ('knepre',),
'knerte': ('knerte',),
'knerter': ('knerte',),
'knertes': ('knerte',),
'knerta': ('knerte',),
'knertet': ('knerte',),
'knerta': ('knerte',),
'knertet': ('knerte',),
'knert': ('knerte',),
'knesette': ('knesette',),
'knesetter': ('knesette',),
'knesettes': ('knesette',),
'knesatte': ('knesette',),
'knesatt': ('knesette',),
'knesett': ('knesette',),
'kneste': ('kneste',),
'knester': ('kneste',),
'knestes': ('kneste',),
'knast': ('kneste',),
'knestet': ('kneste',),
'knest': ('kneste',),
'knette': ('knette',),
'knetter': ('knette',),
'knettes': ('knette',),
'knatt': ('knette',),
'knettet': ('knette',),
'knett': ('knette',),
'knikse': ('knikse',),
'knikser': ('knikse',),
'knikses': ('knikse',),
'kniksa': ('knikse',),
'knikset': ('knikse',),
'kniksa': ('knikse',),
'knikset': ('knikse',),
'kniks': ('knikse',),
'knipe': ('knipe',),
'kniper': ('knipe',),
'knipes': ('knipe',),
'knep': ('knipe',),
'kneip': ('knipe',),
'knep': ('knipe',),
'kneip': ('knipe',),
'knepet': ('knipe',),
'knip': ('knipe',),
'kniple': ('kniple',),
'knipler': ('kniple',),
'kniples': ('kniple',),
'knipla': ('kniple',),
'kniplet': ('kniple',),
'knipla': ('kniple',),
'kniplet': ('kniple',),
'knipl': ('kniple',),
'kniple': ('kniple',),
'knipl': ('kniple',),
'kniple': ('kniple',),
'knippe': ('knippe',),
'knipper': ('knippe',),
'knippes': ('knippe',),
'knippa': ('knippe',),
'knippet': ('knippe',),
'knippa': ('knippe',),
'knippet': ('knippe',),
'knipp': ('knippe',),
'knipse': ('knipse',),
'knipser': ('knipse',),
'knipses': ('knipse',),
'knipsa': ('knipse',),
'knipset': ('knipse',),
'knipsa': ('knipse',),
'knipset': ('knipse',),
'knips': ('knipse',),
'knirke': ('knirke',),
'knirker': ('knirke',),
'knirkes': ('knirke',),
'knirka': ('knirke',),
'knirket': ('knirke',),
'knirka': ('knirke',),
'knirket': ('knirke',),
'knirk': ('knirke',),
'knise': ('knise',),
'kniser': ('knise',),
'knises': ('knise',),
'kniste': ('knise',),
'knist': ('knise',),
'knis': ('knise',),
'knisle': ('knisle',),
'knisler': ('knisle',),
'knisles': ('knisle',),
'knisla': ('knisle',),
'knislet': ('knisle',),
'knisla': ('knisle',),
'knislet': ('knisle',),
'knisl': ('knisle',),
'knistre': ('knistre',),
'knistrer': ('knistre',),
'knistres': ('knistre',),
'knistra': ('knistre',),
'knistret': ('knistre',),
'knistra': ('knistre',),
'knistret': ('knistre',),
'knistr': ('knistre',),
'knistre': ('knistre',),
'knistr': ('knistre',),
'knistre': ('knistre',),
'knitre': ('knitre',),
'knitrer': ('knitre',),
'knitres': ('knitre',),
'knitra': ('knitre',),
'knitret': ('knitre',),
'knitra': ('knitre',),
'knitret': ('knitre',),
'knitr': ('knitre',),
'knitre': ('knitre',),
'knitr': ('knitre',),
'knitre': ('knitre',),
'knive': ('knive',),
'kniver': ('knive',),
'knives': ('knive',),
'kniva': ('knive',),
'knivet': ('knive',),
'kniva': ('knive',),
'knivet': ('knive',),
'kniv': ('knive',),
'knocke': ('knocke',),
'knocker': ('knocke',),
'knockes': ('knocke',),
'knocka': ('knocke',),
'knocket': ('knocke',),
'knocka': ('knocke',),
'knocket': ('knocke',),
'knock': ('knocke',),
'knockoute': ('knockoute',),
'knockouter': ('knockoute',),
'knockoutes': ('knockoute',),
'knockouta': ('knockoute',),
'knockoutet': ('knockoute',),
'knockouta': ('knockoute',),
'knockoutet': ('knockoute',),
'knockout': ('knockoute',),
'knoge': ('knoge',),
'knoger': ('knoge',),
'knoges': ('knoge',),
'knoga': ('knoge',),
'knoget': ('knoge',),
'knoga': ('knoge',),
'knoget': ('knoge',),
'knog': ('knoge',),
'knope': ('knope',),
'knoper': ('knope',),
'knopes': ('knope',),
'knopa': ('knope',),
'knopet': ('knope',),
'knopa': ('knope',),
'knopet': ('knope',),
'knop': ('knope',),
'knoppe': ('knoppe',),
'knopper': ('knoppe',),
'knoppes': ('knoppe',),
'knoppa': ('knoppe',),
'knoppet': ('knoppe',),
'knoppa': ('knoppe',),
'knoppet': ('knoppe',),
'knopp': ('knoppe',),
'knote': ('knote',),
'knoter': ('knote',),
'knotes': ('knote',),
'knota': ('knote',),
'knotet': ('knote',),
'knota': ('knote',),
'knotet': ('knote',),
'knot': ('knote',),
'knubbe': ('knubbe',),
'knubber': ('knubbe',),
'knubbes': ('knubbe',),
'knubba': ('knubbe',),
'knubbet': ('knubbe',),
'knubba': ('knubbe',),
'knubbet': ('knubbe',),
'knubb': ('knubbe',),
'knuffe': ('knuffe',),
'knuffer': ('knuffe',),
'knuffes': ('knuffe',),
'knuffa': ('knuffe',),
'knuffet': ('knuffe',),
'knuffa': ('knuffe',),
'knuffet': ('knuffe',),
'knuff': ('knuffe',),
'knuge': ('knuge',),
'knuger': ('knuge',),
'knuges': ('knuge',),
'knuga': ('knuge',),
'knuget': ('knuge',),
'knuga': ('knuge',),
'knuget': ('knuge',),
'knug': ('knuge',),
'knulle': ('knulle',),
'knuller': ('knulle',),
'knulles': ('knulle',),
'knulla': ('knulle',),
'knullet': ('knulle',),
'knulla': ('knulle',),
'knullet': ('knulle',),
'knull': ('knulle',),
'knupse': ('knupse',),
'knupser': ('knupse',),
'knupses': ('knupse',),
'knupsa': ('knupse',),
'knupset': ('knupse',),
'knupsa': ('knupse',),
'knupset': ('knupse',),
'knups': ('knupse',),
'knurke': ('knurke',),
'knurker': ('knurke',),
'knurkes': ('knurke',),
'knurka': ('knurke',),
'knurket': ('knurke',),
'knurka': ('knurke',),
'knurket': ('knurke',),
'knurk': ('knurke',),
'knurpe': ('knurpe',),
'knurper': ('knurpe',),
'knurpes': ('knurpe',),
'knurpa': ('knurpe',),
'knurpet': ('knurpe',),
'knurpa': ('knurpe',),
'knurpet': ('knurpe',),
'knurp': ('knurpe',),
'knurre': ('knurre',),
'knurrer': ('knurre',),
'knurres': ('knurre',),
'knurra': ('knurre',),
'knurret': ('knurre',),
'knurra': ('knurre',),
'knurret': ('knurre',),
'knurr': ('knurre',),
'knurve': ('knurve',),
'knurver': ('knurve',),
'knurves': ('knurve',),
'knurva': ('knurve',),
'knurvet': ('knurve',),
'knurva': ('knurve',),
'knurvet': ('knurve',),
'knurv': ('knurve',),
'knuse': ('knuse',),
'knuser': ('knuse',),
'knuses': ('knuse',),
'knuste': ('knuse',),
'knust': ('knuse',),
'knus': ('knuse',),
'knuselske': ('knuselske',),
'knuselsker': ('knuselske',),
'knuselskes': ('knuselske',),
'knuselska': ('knuselske',),
'knuselsket': ('knuselske',),
'knuselska': ('knuselske',),
'knuselsket': ('knuselske',),
'knuselsk': ('knuselske',),
'knusle': ('knusle',),
'knusler': ('knusle',),
'knusles': ('knusle',),
'knusla': ('knusle',),
'knuslet': ('knusle',),
'knusla': ('knusle',),
'knuslet': ('knusle',),
'knusl': ('knusle',),
'knuspe': ('knuspe',),
'knusper': ('knuspe',),
'knuspes': ('knuspe',),
'knuspa': ('knuspe',),
'knuspet': ('knuspe',),
'knuspa': ('knuspe',),
'knuspet': ('knuspe',),
'knusp': ('knuspe',),
'knuspre': ('knuspre',),
'knusprer': ('knuspre',),
'knuspres': ('knuspre',),
'knuspra': ('knuspre',),
'knuspret': ('knuspre',),
'knuspra': ('knuspre',),
'knuspret': ('knuspre',),
'knuspr': ('knuspre',),
'knuspre': ('knuspre',),
'knuspr': ('knuspre',),
'knuspre': ('knuspre',),
'knustre': ('knustre',),
'knustrer': ('knustre',),
'knustres': ('knustre',),
'knustra': ('knustre',),
'knustret': ('knustre',),
'knustra': ('knustre',),
'knustret': ('knustre',),
'knustr': ('knustre',),
'knustre': ('knustre',),
'knustr': ('knustre',),
'knustre': ('knustre',),
'knuvle': ('knuvle',),
'knuvler': ('knuvle',),
'knuvles': ('knuvle',),
'knuvla': ('knuvle',),
'knuvlet': ('knuvle',),
'knuvla': ('knuvle',),
'knuvlet': ('knuvle',),
'knuvl': ('knuvle',),
'knuvle': ('knuvle',),
'knuvl': ('knuvle',),
'knuvle': ('knuvle',),
'kny': ('kny',),
'knyr': ('kny',),
'knys': ('kny',),
'knydde': ('kny',),
'knydd': ('kny',),
'kny': ('kny',),
'knyste': ('knyste',),
'knyster': ('knyste',),
'knystes': ('knyste',),
'knysta': ('knyste',),
'knystet': ('knyste',),
'knysta': ('knyste',),
'knystet': ('knyste',),
'knyst': ('knyste',),
'knyte': ('knyte',),
'knyter': ('knyte',),
'knytes': ('knyte',),
'knytte': ('knyte',),
'knytt': ('knyte',),
'knyt': ('knyte',),
'knytte': ('knytte',),
'knytter': ('knytte',),
'knyttes': ('knytte',),
'knytta': ('knytte',),
'knyttet': ('knytte',),
'knytta': ('knytte',),
'knyttet': ('knytte',),
'knytt': ('knytte',),
'koagulere': ('koagulere',),
'koagulerer': ('koagulere',),
'koaguleres': ('koagulere',),
'koagulerte': ('koagulere',),
'koagulert': ('koagulere',),
'koaguler': ('koagulere',),
'koble': ('koble',),
'kobler': ('koble',),
'kobles': ('koble',),
'kobla': ('koble',),
'koblet': ('koble',),
'kobla': ('koble',),
'koblet': ('koble',),
'kobl': ('koble',),
'koble': ('koble',),
'kobl': ('koble',),
'koble': ('koble',),
'kode': ('kode',),
'koder': ('kode',),
'kodes': ('kode',),
'koda': ('kode',),
'kodet': ('kode',),
'koda': ('kode',),
'kodet': ('kode',),
'kod': ('kode',),
'kodifisere': ('kodifisere',),
'kodifiserer': ('kodifisere',),
'kodifiseres': ('kodifisere',),
'kodifiserte': ('kodifisere',),
'kodifisert': ('kodifisere',),
'kodifiser': ('kodifisere',),
'kogle': ('kogle',),
'kogler': ('kogle',),
'kogles': ('kogle',),
'kogla': ('kogle',),
'koglet': ('kogle',),
'kogla': ('kogle',),
'koglet': ('kogle',),
'kogl': ('kogle',),
'kogle': ('kogle',),
'kogl': ('kogle',),
'kogle': ('kogle',),
'koke': ('koke',),
'koker': ('koke',),
'kokes': ('koke',),
'kokte': ('koke',),
'kokt': ('koke',),
'kok': ('koke',),
'kokettere': ('kokettere',),
'koketterer': ('kokettere',),
'koketteres': ('kokettere',),
'koketterte': ('kokettere',),
'kokettert': ('kokettere',),
'koketter': ('kokettere',),
'kokkelere': ('kokkelere',),
'kokkelerer': ('kokkelere',),
'kokkeleres': ('kokkelere',),
'kokkelerte': ('kokkelere',),
'kokkelert': ('kokkelere',),
'kokkeler': ('kokkelere',),
'kokkerere': ('kokkerere',),
'kokkererer': ('kokkerere',),
'kokkereres': ('kokkerere',),
'kokkererte': ('kokkerere',),
'kokkerert': ('kokkerere',),
'kokkerer': ('kokkerere',),
'kokre': ('kokre',),
'kokrer': ('kokre',),
'kokres': ('kokre',),
'kokra': ('kokre',),
'kokret': ('kokre',),
'kokra': ('kokre',),
'kokret': ('kokre',),
'kokr': ('kokre',),
'kokre': ('kokre',),
'kokr': ('kokre',),
'kokre': ('kokre',),
'kole': ('kole',),
'koler': ('kole',),
'koles': ('kole',),
'kola': ('kole',),
'kolet': ('kole',),
'kola': ('kole',),
'kolet': ('kole',),
'kol': ('kole',),
'kollabere': ('kollabere',),
'kollaberer': ('kollabere',),
'kollaberes': ('kollabere',),
'kollabera': ('kollabere',),
'kollaberet': ('kollabere',),
'kollabera': ('kollabere',),
'kollaberet': ('kollabere',),
'kollaber': ('kollabere',),
'kollaborere': ('kollaborere',),
'kollaborerer': ('kollaborere',),
'kollaboreres': ('kollaborere',),
'kollaborerte': ('kollaborere',),
'kollaborert': ('kollaborere',),
'kollaborer': ('kollaborere',),
'kollapse': ('kollapse',),
'kollapser': ('kollapse',),
'kollapses': ('kollapse',),
'kollapsa': ('kollapse',),
'kollapset': ('kollapse',),
'kollapsa': ('kollapse',),
'kollapset': ('kollapse',),
'kollaps': ('kollapse',),
'kollasjonere': ('kollasjonere',),
'kollasjonerer': ('kollasjonere',),
'kollasjoneres': ('kollasjonere',),
'kollasjonerte': ('kollasjonere',),
'kollasjonert': ('kollasjonere',),
'kollasjoner': ('kollasjonere',),
'kolle': ('kolle',),
'koller': ('kolle',),
'kolles': ('kolle',),
'kolla': ('kolle',),
'kollet': ('kolle',),
'kolla': ('kolle',),
'kollet': ('kolle',),
'koll': ('kolle',),
'kollektivisere': ('kollektivisere',),
'kollektiviserer': ('kollektivisere',),
'kollektiviseres': ('kollektivisere',),
'kollektiviserte': ('kollektivisere',),
'kollektivisert': ('kollektivisere',),
'kollektiviser': ('kollektivisere',),
'kollidere': ('kollidere',),
'kolliderer': ('kollidere',),
'kollideres': ('kollidere',),
'kolliderte': ('kollidere',),
'kollidert': ('kollidere',),
'kollider': ('kollidere',),
'kollokvere': ('kollokvere',),
'kollokverer': ('kollokvere',),
'kollokveres': ('kollokvere',),
'kollokverte': ('kollokvere',),
'kollokvert': ('kollokvere',),
'kollokver': ('kollokvere',),
'kollsegle': ('kollsegle',),
'kollsegler': ('kollsegle',),
'kollsegles': ('kollsegle',),
'kollsegla': ('kollsegle',),
'kollseglet': ('kollsegle',),
'kollsegla': ('kollsegle',),
'kollseglet': ('kollsegle',),
'kollsegl': ('kollsegle',),
'kollsegle': ('kollsegle',),
'kollsegl': ('kollsegle',),
'kollsegle': ('kollsegle',),
'kollseile': ('kollseile',),
'kollseiler': ('kollseile',),
'kollseiles': ('kollseile',),
'kollseilte': ('kollseile',),
'kollseilt': ('kollseile',),
'kollseil': ('kollseile',),
'kolonisere': ('kolonisere',),
'koloniserer': ('kolonisere',),
'koloniseres': ('kolonisere',),
'koloniserte': ('kolonisere',),
'kolonisert': ('kolonisere',),
'koloniser': ('kolonisere',),
'kolorere': ('kolorere',),
'kolorerer': ('kolorere',),
'koloreres': ('kolorere',),
'kolorerte': ('kolorere',),
'kolorert': ('kolorere',),
'kolorer': ('kolorere',),
'kolportere': ('kolportere',),
'kolporterer': ('kolportere',),
'kolporteres': ('kolportere',),
'kolporterte': ('kolportere',),
'kolportert': ('kolportere',),
'kolporter': ('kolportere',),
'kombinere': ('kombinere',),
'kombinerer': ('kombinere',),
'kombineres': ('kombinere',),
'kombinerte': ('kombinere',),
'kombinert': ('kombinere',),
'kombiner': ('kombinere',),
'komitébehandle': ('komitébehandle',),
'komitébehandler': ('komitébehandle',),
'komitébehandles': ('komitébehandle',),
'komitébehandla': ('komitébehandle',),
'komitébehandlet': ('komitébehandle',),
'komitébehandla': ('komitébehandle',),
'komitébehandlet': ('komitébehandle',),
'komitébehandl': ('komitébehandle',),
'komitébehandle': ('komitébehandle',),
'komitébehandl': ('komitébehandle',),
'komitébehandle': ('komitébehandle',),
'kommandere': ('kommandere',),
'kommanderer': ('kommandere',),
'kommanderes': ('kommandere',),
'kommanderte': ('kommandere',),
'kommandert': ('kommandere',),
'kommander': ('kommandere',),
'komme': ('komme',),
'kommer': ('komme',),
'kommes': ('komme',),
'kom': ('komme',),
'kommet': ('komme',),
'kom': ('komme',),
'kommentere': ('kommentere',),
'kommenterer': ('kommentere',),
'kommenteres': ('kommentere',),
'kommenterte': ('kommentere',),
'kommentert': ('kommentere',),
'kommenter': ('kommentere',),
'kommersialisere': ('kommersialisere',),
'kommersialiserer': ('kommersialisere',),
'kommersialiseres': ('kommersialisere',),
'kommersialiserte': ('kommersialisere',),
'kommersialisert': ('kommersialisere',),
'kommersialiser': ('kommersialisere',),
'kommunalisere': ('kommunalisere',),
'kommunaliserer': ('kommunalisere',),
'kommunaliseres': ('kommunalisere',),
'kommunaliserte': ('kommunalisere',),
'kommunalisert': ('kommunalisere',),
'kommunaliser': ('kommunalisere',),
'kommunisere': ('kommunisere',),
'kommuniserer': ('kommunisere',),
'kommuniseres': ('kommunisere',),
'kommuniserte': ('kommunisere',),
'kommunisert': ('kommunisere',),
'kommuniser': ('kommunisere',),
'kommutere': ('kommutere',),
'kommuterer': ('kommutere',),
'kommuteres': ('kommutere',),
'kommuterte': ('kommutere',),
'kommutert': ('kommutere',),
'kommuter': ('kommutere',),
'komparere': ('komparere',),
'komparerer': ('komparere',),
'kompareres': ('komparere',),
'komparerte': ('komparere',),
'komparert': ('komparere',),
'komparer': ('komparere',),
'kompe': ('kompe',),
'komper': ('kompe',),
'kompes': ('kompe',),
'kompa': ('kompe',),
'kompet': ('kompe',),
'kompa': ('kompe',),
'kompet': ('kompe',),
'komp': ('kompe',),
'kompensere': ('kompensere',),
'kompenserer': ('kompensere',),
'kompenseres': ('kompensere',),
'kompenserte': ('kompensere',),
'kompensert': ('kompensere',),
'kompenser': ('kompensere',),
'kompilere': ('kompilere',),
'kompilerer': ('kompilere',),
'kompileres': ('kompilere',),
'kompilerte': ('kompilere',),
'kompilert': ('kompilere',),
'kompiler': ('kompilere',),
'komplettere': ('komplettere',),
'kompletterer': ('komplettere',),
'kompletteres': ('komplettere',),
'kompletterte': ('komplettere',),
'komplettert': ('komplettere',),
'kompletter': ('komplettere',),
'komplimentere': ('komplimentere',),
'komplimenterer': ('komplimentere',),
'komplimenteres': ('komplimentere',),
'komplimenterte': ('komplimentere',),
'komplimentert': ('komplimentere',),
'komplimenter': ('komplimentere',),
'komplisere': ('komplisere',),
'kompliserer': ('komplisere',),
'kompliseres': ('komplisere',),
'kompliserte': ('komplisere',),
'komplisert': ('komplisere',),
'kompliser': ('komplisere',),
'komponere': ('komponere',),
'komponerer': ('komponere',),
'komponeres': ('komponere',),
'komponerte': ('komponere',),
'komponert': ('komponere',),
'komponer': ('komponere',),
'kompostere': ('kompostere',),
'komposterer': ('kompostere',),
'komposteres': ('kompostere',),
'komposterte': ('kompostere',),
'kompostert': ('kompostere',),
'komposter': ('kompostere',),
'komprimere': ('komprimere',),
'komprimerer': ('komprimere',),
'komprimeres': ('komprimere',),
'komprimerte': ('komprimere',),
'komprimert': ('komprimere',),
'komprimer': ('komprimere',),
'kompromisse': ('kompromisse',),
'kompromisser': ('kompromisse',),
'kompromisses': ('kompromisse',),
'kompromissa': ('kompromisse',),
'kompromisset': ('kompromisse',),
'kompromissa': ('kompromisse',),
'kompromisset': ('kompromisse',),
'kompromiss': ('kompromisse',),
'kompromittere': ('kompromittere',),
'kompromitterer': ('kompromittere',),
'kompromitteres': ('kompromittere',),
'kompromitterte': ('kompromittere',),
'kompromittert': ('kompromittere',),
'kompromitter': ('kompromittere',),
'kondemnere': ('kondemnere',),
'kondemnerer': ('kondemnere',),
'kondemneres': ('kondemnere',),
'kondemnerte': ('kondemnere',),
'kondemnert': ('kondemnere',),
'kondemner': ('kondemnere',),
'kondensere': ('kondensere',),
'kondenserer': ('kondensere',),
'kondenseres': ('kondensere',),
'kondenserte': ('kondensere',),
'kondensert': ('kondensere',),
'kondenser': ('kondensere',),
'kondisjonere': ('kondisjonere',),
'kondisjonerer': ('kondisjonere',),
'kondisjoneres': ('kondisjonere',),
'kondisjonerte': ('kondisjonere',),
'kondisjonert': ('kondisjonere',),
'kondisjoner': ('kondisjonere',),
'kondolere': ('kondolere',),
'kondolerer': ('kondolere',),
'kondoleres': ('kondolere',),
'kondolerte': ('kondolere',),
'kondolert': ('kondolere',),
'kondoler': ('kondolere',),
'konferere': ('konferere',),
'konfererer': ('konferere',),
'konfereres': ('konferere',),
'konfererte': ('konferere',),
'konferert': ('konferere',),
'konferer': ('konferere',),
'konfirmere': ('konfirmere',),
'konfirmerer': ('konfirmere',),
'konfirmeres': ('konfirmere',),
'konfirmerte': ('konfirmere',),
'konfirmert': ('konfirmere',),
'konfirmer': ('konfirmere',),
'konfiskere': ('konfiskere',),
'konfiskerer': ('konfiskere',),
'konfiskeres': ('konfiskere',),
'konfiskerte': ('konfiskere',),
'konfiskert': ('konfiskere',),
'konfisker': ('konfiskere',),
'konfrontere': ('konfrontere',),
'konfronterer': ('konfrontere',),
'konfronteres': ('konfrontere',),
'konfronterte': ('konfrontere',),
'konfrontert': ('konfrontere',),
'konfronter': ('konfrontere',),
'kongruere': ('kongruere',),
'kongruerer': ('kongruere',),
'kongrueres': ('kongruere',),
'kongruerte': ('kongruere',),
'kongruert': ('kongruere',),
'kongruer': ('kongruere',),
'konjugere': ('konjugere',),
'konjugerer': ('konjugere',),
'konjugeres': ('konjugere',),
'konjugerte': ('konjugere',),
'konjugert': ('konjugere',),
'konjuger': ('konjugere',),
'konke': ('konke',),
'konker': ('konke',),
'konkes': ('konke',),
'konka': ('konke',),
'konket': ('konke',),
'konka': ('konke',),
'konket': ('konke',),
'konk': ('konke',),
'konkludere': ('konkludere',),
'konkluderer': ('konkludere',),
'konkluderes': ('konkludere',),
'konkluderte': ('konkludere',),
'konkludert': ('konkludere',),
'konkluder': ('konkludere',),
'konkretisere': ('konkretisere',),
'konkretiserer': ('konkretisere',),
'konkretiseres': ('konkretisere',),
'konkretiserte': ('konkretisere',),
'konkretisert': ('konkretisere',),
'konkretiser': ('konkretisere',),
'konkurrere': ('konkurrere',),
'konkurrerer': ('konkurrere',),
'konkurreres': ('konkurrere',),
'konkurrerte': ('konkurrere',),
'konkurrert': ('konkurrere',),
'konkurrer': ('konkurrere',),
'konnotere': ('konnotere',),
'konnoterer': ('konnotere',),
'konnoteres': ('konnotere',),
'konnoterte': ('konnotere',),
'konnotert': ('konnotere',),
'konnoter': ('konnotere',),
'konsentrere': ('konsentrere',),
'konsentrerer': ('konsentrere',),
'konsentreres': ('konsentrere',),
'konsentrerte': ('konsentrere',),
'konsentrert': ('konsentrere',),
'konsentrer': ('konsentrere',),
'konsertere': ('konsertere',),
'konserterer': ('konsertere',),
'konserteres': ('konsertere',),
'konserterte': ('konsertere',),
'konsertert': ('konsertere',),
'konserter': ('konsertere',),
'konservere': ('konservere',),
'konserverer': ('konservere',),
'konserveres': ('konservere',),
'konserverte': ('konservere',),
'konservert': ('konservere',),
'konserver': ('konservere',),
'konsignere': ('konsignere',),
'konsignerer': ('konsignere',),
'konsigneres': ('konsignere',),
'konsignerte': ('konsignere',),
'konsignert': ('konsignere',),
'konsigner': ('konsignere',),
'konsipere': ('konsipere',),
'konsiperer': ('konsipere',),
'konsiperes': ('konsipere',),
'konsiperte': ('konsipere',),
'konsipert': ('konsipere',),
'konsiper': ('konsipere',),
'konskribere': ('konskribere',),
'konskriberer': ('konskribere',),
'konskriberes': ('konskribere',),
'konskriberte': ('konskribere',),
'konskribert': ('konskribere',),
'konskriber': ('konskribere',),
'konsolidere': ('konsolidere',),
'konsoliderer': ('konsolidere',),
'konsolideres': ('konsolidere',),
'konsoliderte': ('konsolidere',),
'konsolidert': ('konsolidere',),
'konsolider': ('konsolidere',),
'konspirere': ('konspirere',),
'konspirerer': ('konspirere',),
'konspireres': ('konspirere',),
'konspirerte': ('konspirere',),
'konspirert': ('konspirere',),
'konspirer': ('konspirere',),
'konstatere': ('konstatere',),
'konstaterer': ('konstatere',),
'konstateres': ('konstatere',),
'konstaterte': ('konstatere',),
'konstatert': ('konstatere',),
'konstater': ('konstatere',),
'konstituere': ('konstituere',),
'konstituerer': ('konstituere',),
'konstitueres': ('konstituere',),
'konstituerte': ('konstituere',),
'konstituert': ('konstituere',),
'konstituer': ('konstituere',),
'konstruere': ('konstruere',),
'konstruerer': ('konstruere',),
'konstrueres': ('konstruere',),
'konstruerte': ('konstruere',),
'konstruert': ('konstruere',),
'konstruer': ('konstruere',),
'konsultere': ('konsultere',),
'konsulterer': ('konsultere',),
'konsulteres': ('konsultere',),
'konsulterte': ('konsultere',),
'konsultert': ('konsultere',),
'konsulter': ('konsultere',),
'konsumere': ('konsumere',),
'konsumerer': ('konsumere',),
'konsumeres': ('konsumere',),
'konsumerte': ('konsumere',),
'konsumert': ('konsumere',),
'konsumer': ('konsumere',),
'kontakte': ('kontakte',),
'kontakter': ('kontakte',),
'kontaktes': ('kontakte',),
'kontakta': ('kontakte',),
'kontaktet': ('kontakte',),
'kontakta': ('kontakte',),
'kontaktet': ('kontakte',),
'kontakt': ('kontakte',),
'kontere': ('kontere',),
'konterer': ('kontere',),
'konteres': ('kontere',),
'konterte': ('kontere',),
'kontert': ('kontere',),
'konter': ('kontere',),
'kontingentere': ('kontingentere',),
'kontingenterer': ('kontingentere',),
'kontingenteres': ('kontingentere',),
'kontingenterte': ('kontingentere',),
'kontingentert': ('kontingentere',),
'kontingenter': ('kontingentere',),
'kontinuere': ('kontinuere',),
'kontinuerer': ('kontinuere',),
'kontinueres': ('kontinuere',),
'kontinuerte': ('kontinuere',),
'kontinuert': ('kontinuere',),
'kontinuer': ('kontinuere',),
'kontorisere': ('kontorisere',),
'kontoriserer': ('kontorisere',),
'kontoriseres': ('kontorisere',),
'kontoriserte': ('kontorisere',),
'kontorisert': ('kontorisere',),
'kontoriser': ('kontorisere',),
'kontrahere': ('kontrahere',),
'kontraherer': ('kontrahere',),
'kontraheres': ('kontrahere',),
'kontraherte': ('kontrahere',),
'kontrahert': ('kontrahere',),
'kontraher': ('kontrahere',),
'kontrasignere': ('kontrasignere',),
'kontrasignerer': ('kontrasignere',),
'kontrasigneres': ('kontrasignere',),
'kontrasignerte': ('kontrasignere',),
'kontrasignert': ('kontrasignere',),
'kontrasigner': ('kontrasignere',),
'kontrastere': ('kontrastere',),
'kontrasterer': ('kontrastere',),
'kontrasteres': ('kontrastere',),
'kontrasterte': ('kontrastere',),
'kontrastert': ('kontrastere',),
'kontraster': ('kontrastere',),
'kontre': ('kontre',),
'kontrer': ('kontre',),
'kontres': ('kontre',),
'kontra': ('kontre',),
'kontret': ('kontre',),
'kontra': ('kontre',),
'kontret': ('kontre',),
'kontr': ('kontre',),
'kontre': ('kontre',),
'kontr': ('kontre',),
'kontre': ('kontre',),
'kontribuere': ('kontribuere',),
'kontribuerer': ('kontribuere',),
'kontribueres': ('kontribuere',),
'kontribuerte': ('kontribuere',),
'kontribuert': ('kontribuere',),
'kontribuer': ('kontribuere',),
'kontrollere': ('kontrollere',),
'kontrollerer': ('kontrollere',),
'kontrolleres': ('kontrollere',),
'kontrollerte': ('kontrollere',),
'kontrollert': ('kontrollere',),
'kontroller': ('kontrollere',),
'konvergere': ('konvergere',),
'konvergerer': ('konvergere',),
'konvergeres': ('konvergere',),
'konvergerte': ('konvergere',),
'konvergert': ('konvergere',),
'konverger': ('konvergere',),
'konversere': ('konversere',),
'konverserer': ('konversere',),
'konverseres': ('konversere',),
'konverserte': ('konversere',),
'konversert': ('konversere',),
'konverser': ('konversere',),
'konvertere': ('konvertere',),
'konverterer': ('konvertere',),
'konverteres': ('konvertere',),
'konverterte': ('konvertere',),
'konvertert': ('konvertere',),
'konverter': ('konvertere',),
'konvoiere': ('konvoiere',),
'konvoierer': ('konvoiere',),
'konvoieres': ('konvoiere',),
'konvoierte': ('konvoiere',),
'konvoiert': ('konvoiere',),
'konvoier': ('konvoiere',),
'konvoluttere': ('konvoluttere',),
'konvolutterer': ('konvoluttere',),
'konvolutteres': ('konvoluttere',),
'konvolutterte': ('konvoluttere',),
'konvoluttert': ('konvoluttere',),
'konvolutter': ('konvoluttere',),
'kooperere': ('kooperere',),
'koopererer': ('kooperere',),
'koopereres': ('kooperere',),
'koopererte': ('kooperere',),
'kooperert': ('kooperere',),
'kooperer': ('kooperere',),
'koordinere': ('koordinere',),
'koordinerer': ('koordinere',),
'koordineres': ('koordinere',),
'koordinerte': ('koordinere',),
'koordinert': ('koordinere',),
'koordiner': ('koordinere',),
'kope': ('kope',),
'koper': ('kope',),
'kopes': ('kope',),
'kopte': ('kope',),
'kopt': ('kope',),
'kop': ('kope',),
'kopiere': ('kopiere',),
'kopierer': ('kopiere',),
'kopieres': ('kopiere',),
'kopierte': ('kopiere',),
'kopiert': ('kopiere',),
'kopier': ('kopiere',),
'kople': ('kople',),
'kopler': ('kople',),
'koples': ('kople',),
'kopla': ('kople',),
'koplet': ('kople',),
'kopla': ('kople',),
'koplet': ('kople',),
'kopl': ('kople',),
'kople': ('kople',),
'kopl': ('kople',),
'kople': ('kople',),
'koppe': ('koppe',),
'kopper': ('koppe',),
'koppes': ('koppe',),
'koppa': ('koppe',),
'koppet': ('koppe',),
'koppa': ('koppe',),
'koppet': ('koppe',),
'kopp': ('koppe',),
'kopulere': ('kopulere',),
'kopulerer': ('kopulere',),
'kopuleres': ('kopulere',),
'kopulerte': ('kopulere',),
'kopulert': ('kopulere',),
'kopuler': ('kopulere',),
'kore': ('kore',),
'korer': ('kore',),
'kores': ('kore',),
'kora': ('kore',),
'koret': ('kore',),
'kora': ('kore',),
'koret': ('kore',),
'kor': ('kore',),
'koreografere': ('koreografere',),
'koreograferer': ('koreografere',),
'koreograferes': ('koreografere',),
'koreograferte': ('koreografere',),
'koreografert': ('koreografere',),
'koreografer': ('koreografere',),
'korke': ('korke',),
'korker': ('korke',),
'korkes': ('korke',),
'korka': ('korke',),
'korket': ('korke',),
'korka': ('korke',),
'korket': ('korke',),
'kork': ('korke',),
'korne': ('korne',),
'korner': ('korne',),
'kornes': ('korne',),
'korna': ('korne',),
'kornet': ('korne',),
'korna': ('korne',),
'kornet': ('korne',),
'korn': ('korne',),
'korporativisere': ('korporativisere',),
'korporativiserer': ('korporativisere',),
'korporativiseres': ('korporativisere',),
'korporativiserte': ('korporativisere',),
'korporativisert': ('korporativisere',),
'korporativiser': ('korporativisere',),
'korrespondere': ('korrespondere',),
'korresponderer': ('korrespondere',),
'korresponderes': ('korrespondere',),
'korresponderte': ('korrespondere',),
'korrespondert': ('korrespondere',),
'korresponder': ('korrespondere',),
'korrigere': ('korrigere',),
'korrigerer': ('korrigere',),
'korrigeres': ('korrigere',),
'korrigerte': ('korrigere',),
'korrigert': ('korrigere',),
'korriger': ('korrigere',),
'korrodere': ('korrodere',),
'korroderer': ('korrodere',),
'korroderes': ('korrodere',),
'korroderte': ('korrodere',),
'korrodert': ('korrodere',),
'korroder': ('korrodere',),
'korrugere': ('korrugere',),
'korrugerer': ('korrugere',),
'korrugeres': ('korrugere',),
'korrugerte': ('korrugere',),
'korrugert': ('korrugere',),
'korruger': ('korrugere',),
'korrumpere': ('korrumpere',),
'korrumperer': ('korrumpere',),
'korrumperes': ('korrumpere',),
'korrumperte': ('korrumpere',),
'korrumpert': ('korrumpere',),
'korrumper': ('korrumpere',),
'korse': ('korse',),
'korser': ('korse',),
'korses': ('korse',),
'korsa': ('korse',),
'korset': ('korse',),
'korsa': ('korse',),
'korset': ('korse',),
'kors': ('korse',),
'korsfeste': ('korsfeste',),
'korsfester': ('korsfeste',),
'korsfestes': ('korsfeste',),
'korsfesta': ('korsfeste',),
'korsfestet': ('korsfeste',),
'korsfesta': ('korsfeste',),
'korsfestet': ('korsfeste',),
'korsfest': ('korsfeste',),
'korslegge': ('korslegge',),
'korslegger': ('korslegge',),
'korslegges': ('korslegge',),
'korsla': ('korslegge',),
'korslagt': ('korslegge',),
'korslegg': ('korslegge',),
'korte': ('korte',),
'korter': ('korte',),
'kortes': ('korte',),
'korta': ('korte',),
'kortet': ('korte',),
'korta': ('korte',),
'kortet': ('korte',),
'kort': ('korte',),
'kortne': ('kortne',),
'kortner': ('kortne',),
'kortnes': ('kortne',),
'kortna': ('kortne',),
'kortnet': ('kortne',),
'kortna': ('kortne',),
'kortnet': ('kortne',),
'kortn': ('kortne',),
'kortne': ('kortne',),
'kortn': ('kortne',),
'kortne': ('kortne',),
'kortslutte': ('kortslutte',),
'kortslutter': ('kortslutte',),
'kortsluttes': ('kortslutte',),
'kortslutta': ('kortslutte',),
'kortsluttet': ('kortslutte',),
'kortslutta': ('kortslutte',),
'kortsluttet': ('kortslutte',),
'kortslutt': ('kortslutte',),
'kose': ('kose',),
'koser': ('kose',),
'koses': ('kose',),
'kosa': ('kose',),
'koset': ('kose',),
'koste': ('kose',),
'kosa': ('kose',),
'koset': ('kose',),
'kost': ('kose',),
'kos': ('kose',),
'koste': ('koste',),
'koster': ('koste',),
'kostes': ('koste',),
'kosta': ('koste',),
'kostet': ('koste',),
'kosta': ('koste',),
'kostet': ('koste',),
'kost': ('koste',),
'kostnadsberegne': ('kostnadsberegne',),
'kostnadsberegner': ('kostnadsberegne',),
'kostnadsberegnes': ('kostnadsberegne',),
'kostnadsberegna': ('kostnadsberegne',),
'kostnadsberegnet': ('kostnadsberegne',),
'kostnadsberegna': ('kostnadsberegne',),
'kostnadsberegnet': ('kostnadsberegne',),
'kostnadsberegn': ('kostnadsberegne',),
'kostymere': ('kostymere',),
'kostymerer': ('kostymere',),
'kostymeres': ('kostymere',),
'kostymerte': ('kostymere',),
'kostymert': ('kostymere',),
'kostymer': ('kostymere',),
'kovne': ('kovne',),
'kovner': ('kovne',),
'kovnes': ('kovne',),
'kovna': ('kovne',),
'kovnet': ('kovne',),
'kovna': ('kovne',),
'kovnet': ('kovne',),
'kovn': ('kovne',),
'kovne': ('kovne',),
'kovn': ('kovne',),
'kovne': ('kovne',),
'krabbe': ('krabbe',),
'krabber': ('krabbe',),
'krabbes': ('krabbe',),
'krabba': ('krabbe',),
'krabbet': ('krabbe',),
'krabba': ('krabbe',),
'krabbet': ('krabbe',),
'krabb': ('krabbe',),
'krafse': ('krafse',),
'krafser': ('krafse',),
'krafses': ('krafse',),
'krafsa': ('krafse',),
'krafset': ('krafse',),
'krafsa': ('krafse',),
'krafset': ('krafse',),
'krafs': ('krafse',),
'krage': ('krage',),
'krager': ('krage',),
'krages': ('krage',),
'kraga': ('krage',),
'kraget': ('krage',),
'kraga': ('krage',),
'kraget': ('krage',),
'krag': ('krage',),
'krake': ('krake',),
'kraker': ('krake',),
'krakes': ('krake',),
'kraka': ('krake',),
'kraket': ('krake',),
'kraka': ('krake',),
'kraket': ('krake',),
'krak': ('krake',),
'krakelere': ('krakelere',),
'krakelerer': ('krakelere',),
'krakeleres': ('krakelere',),
'krakelerte': ('krakelere',),
'krakelert': ('krakelere',),
'krakeler': ('krakelere',),
'krakke': ('krakke',),
'krakker': ('krakke',),
'krakkes': ('krakke',),
'krakka': ('krakke',),
'krakket': ('krakke',),
'krakka': ('krakke',),
'krakket': ('krakke',),
'krakk': ('krakke',),
'kramme': ('kramme',),
'krammer': ('kramme',),
'krammes': ('kramme',),
'kramma': ('kramme',),
'krammet': ('kramme',),
'kramma': ('kramme',),
'krammet': ('kramme',),
'kram': ('kramme',),
'kramse': ('kramse',),
'kramser': ('kramse',),
'kramses': ('kramse',),
'kramsa': ('kramse',),
'kramset': ('kramse',),
'kramsa': ('kramse',),
'kramset': ('kramse',),
'krams': ('kramse',),
'krangle': ('krangle',),
'krangler': ('krangle',),
'krangles': ('krangle',),
'krangla': ('krangle',),
'kranglet': ('krangle',),
'krangla': ('krangle',),
'kranglet': ('krangle',),
'krangl': ('krangle',),
'krangle': ('krangle',),
'krangl': ('krangle',),
'krangle': ('krangle',),
'kranse': ('kranse',),
'kranser': ('kranse',),
'kranses': ('kranse',),
'kransa': ('kranse',),
'kranset': ('kranse',),
'kransa': ('kranse',),
'kranset': ('kranse',),
'krans': ('kranse',),
'krase': ('krase',),
'kraser': ('krase',),
'krases': ('krase',),
'krasa': ('krase',),
'kraset': ('krase',),
'kraste': ('krase',),
'krasa': ('krase',),
'kraset': ('krase',),
'krast': ('krase',),
'kras': ('krase',),
'krasje': ('krasje',),
'krasjer': ('krasje',),
'krasjes': ('krasje',),
'krasja': ('krasje',),
'krasjet': ('krasje',),
'krasja': ('krasje',),
'krasjet': ('krasje',),
'krasj': ('krasje',),
'krasjlande': ('krasjlande',),
'krasjlander': ('krasjlande',),
'krasjlandes': ('krasjlande',),
'krasjlanda': ('krasjlande',),
'krasjlandet': ('krasjlande',),
'krasjlanda': ('krasjlande',),
'krasjlandet': ('krasjlande',),
'krasjland': ('krasjlande',),
'krasle': ('krasle',),
'krasler': ('krasle',),
'krasles': ('krasle',),
'krasla': ('krasle',),
'kraslet': ('krasle',),
'krasla': ('krasle',),
'kraslet': ('krasle',),
'krasl': ('krasle',),
'krasle': ('krasle',),
'krasl': ('krasle',),
'krasle': ('krasle',),
'krasse': ('krasse',),
'krasser': ('krasse',),
'krasses': ('krasse',),
'krassa': ('krasse',),
'krasset': ('krasse',),
'krassa': ('krasse',),
'krasset': ('krasse',),
'krass': ('krasse',),
'kraume': ('kraume',),
'kraumer': ('kraume',),
'kraumes': ('kraume',),
'krauma': ('kraume',),
'kraumet': ('kraume',),
'krauma': ('kraume',),
'kraumet': ('kraume',),
'kraum': ('kraume',),
'krave': ('krave',),
'kraver': ('krave',),
'kraves': ('krave',),
'krava': ('krave',),
'kravet': ('krave',),
'krava': ('krave',),
'kravet': ('krave',),
'krav': ('krave',),
'kravle': ('kravle',),
'kravler': ('kravle',),
'kravles': ('kravle',),
'kravla': ('kravle',),
'kravlet': ('kravle',),
'kravla': ('kravle',),
'kravlet': ('kravle',),
'kravl': ('kravle',),
'kravle': ('kravle',),
'kravl': ('kravle',),
'kravle': ('kravle',),
'kreditere': ('kreditere',),
'krediterer': ('kreditere',),
'krediteres': ('kreditere',),
'krediterte': ('kreditere',),
'kreditert': ('kreditere',),
'krediter': ('kreditere',),
'kreere': ('kreere',),
'kreerer': ('kreere',),
'kreeres': ('kreere',),
'kreerte': ('kreere',),
'kreert': ('kreere',),
'kreer': ('kreere',),
'kreiste': ('kreiste',),
'kreister': ('kreiste',),
'kreistes': ('kreiste',),
'kreista': ('kreiste',),
'kreistet': ('kreiste',),
'kreista': ('kreiste',),
'kreistet': ('kreiste',),
'kreist': ('kreiste',),
'kreke': ('kreke',),
'kreker': ('kreke',),
'krekes': ('kreke',),
'kreka': ('kreke',),
'kreket': ('kreke',),
'krekte': ('kreke',),
'kreka': ('kreke',),
'kreket': ('kreke',),
'krekt': ('kreke',),
'krek': ('kreke',),
'kremere': ('kremere',),
'kremerer': ('kremere',),
'kremeres': ('kremere',),
'kremerte': ('kremere',),
'kremert': ('kremere',),
'kremer': ('kremere',),
'kremte': ('kremte',),
'kremter': ('kremte',),
'kremtes': ('kremte',),
'kremta': ('kremte',),
'kremtet': ('kremte',),
'kremta': ('kremte',),
'kremtet': ('kremte',),
'kremt': ('kremte',),
'krenelere': ('krenelere',),
'krenelerer': ('krenelere',),
'kreneleres': ('krenelere',),
'krenelerte': ('krenelere',),
'krenelert': ('krenelere',),
'kreneler': ('krenelere',),
'krenge': ('krenge',),
'krenger': ('krenge',),
'krenges': ('krenge',),
'krenga': ('krenge',),
'krenget': ('krenge',),
'krengte': ('krenge',),
'krenga': ('krenge',),
'krenget': ('krenge',),
'krengt': ('krenge',),
'kreng': ('krenge',),
'krenke': ('krenke',),
'krenker': ('krenke',),
'krenkes': ('krenke',),
'krenka': ('krenke',),
'krenket': ('krenke',),
'krenkte': ('krenke',),
'krenka': ('krenke',),
'krenket': ('krenke',),
'krenkt': ('krenke',),
'krenk': ('krenke',),
'krepere': ('krepere',),
'kreperer': ('krepere',),
'kreperes': ('krepere',),
'kreperte': ('krepere',),
'krepert': ('krepere',),
'kreper': ('krepere',),
'kreppe': ('kreppe',),
'krepper': ('kreppe',),
'kreppes': ('kreppe',),
'kreppa': ('kreppe',),
'kreppet': ('kreppe',),
'kreppa': ('kreppe',),
'kreppet': ('kreppe',),
'krepp': ('kreppe',),
'krepse': ('krepse',),
'krepser': ('krepse',),
'krepses': ('krepse',),
'krepsa': ('krepse',),
'krepset': ('krepse',),
'krepsa': ('krepse',),
'krepset': ('krepse',),
'kreps': ('krepse',),
'kretse': ('kretse',),
'kretser': ('kretse',),
'kretses': ('kretse',),
'kretsa': ('kretse',),
'kretset': ('kretse',),
'kretsa': ('kretse',),
'kretset': ('kretse',),
'krets': ('kretse',),
'kreve': ('kreve',),
'krever': ('kreve',),
'kreves': ('kreve',),
'krevet': ('kreve',),
'krevde': ('kreve',),
'krevet': ('kreve',),
'krevd': ('kreve',),
'krev': ('kreve',),
'krible': ('krible',),
'kribler': ('krible',),
'kribles': ('krible',),
'kribla': ('krible',),
'kriblet': ('krible',),
'kribla': ('krible',),
'kriblet': ('krible',),
'kribl': ('krible',),
'krible': ('krible',),
'kribl': ('krible',),
'krible': ('krible',),
'krige': ('krige',),
'kriger': ('krige',),
'kriges': ('krige',),
'kriga': ('krige',),
'kriget': ('krige',),
'kriga': ('krige',),
'kriget': ('krige',),
'krig': ('krige',),
'krikle': ('krikle',),
'krikler': ('krikle',),
'krikles': ('krikle',),
'krikla': ('krikle',),
'kriklet': ('krikle',),
'krikla': ('krikle',),
'kriklet': ('krikle',),
'krikl': ('krikle',),
'krikle': ('krikle',),
'krikl': ('krikle',),
'krikle': ('krikle',),
'krille': ('krille',),
'kriller': ('krille',),
'krilles': ('krille',),
'krilla': ('krille',),
'krillet': ('krille',),
'krilla': ('krille',),
'krillet': ('krille',),
'krill': ('krille',),
'kriminalisere': ('kriminalisere',),
'kriminaliserer': ('kriminalisere',),
'kriminaliseres': ('kriminalisere',),
'kriminaliserte': ('kriminalisere',),
'kriminalisert': ('kriminalisere',),
'kriminaliser': ('kriminalisere',),
'kringgå': ('kringgå',),
'kringgår': ('kringgå',),
'kringgås': ('kringgå',),
'kringgikk': ('kringgå',),
'kringgått': ('kringgå',),
'kringgå': ('kringgå',),
'kringkaste': ('kringkaste',),
'kringkaster': ('kringkaste',),
'kringkastes': ('kringkaste',),
'kringkasta': ('kringkaste',),
'kringkastet': ('kringkaste',),
'kringkasta': ('kringkaste',),
'kringkastet': ('kringkaste',),
'kringkast': ('kringkaste',),
'kringsette': ('kringsette',),
'kringsetter': ('kringsette',),
'kringsettes': ('kringsette',),
'kringsatte': ('kringsette',),
'kringsatt': ('kringsette',),
'kringsett': ('kringsette',),
'krinse': ('krinse',),
'krinser': ('krinse',),
'krinses': ('krinse',),
'krinsa': ('krinse',),
'krinset': ('krinse',),
'krinste': ('krinse',),
'krinsa': ('krinse',),
'krinset': ('krinse',),
'krinst': ('krinse',),
'krins': ('krinse',),
'krisle': ('krisle',),
'krisler': ('krisle',),
'krisles': ('krisle',),
'krisla': ('krisle',),
'krislet': ('krisle',),
'krisla': ('krisle',),
'krislet': ('krisle',),
'krisl': ('krisle',),
'kristne': ('kristne',),
'kristner': ('kristne',),
'kristnes': ('kristne',),
'kristna': ('kristne',),
'kristnet': ('kristne',),
'kristna': ('kristne',),
'kristnet': ('kristne',),
'kristn': ('kristne',),
'kristne': ('kristne',),
'kristn': ('kristne',),
'kristne': ('kristne',),
'krite': ('krite',),
'kriter': ('krite',),
'krites': ('krite',),
'krita': ('krite',),
'kritet': ('krite',),
'krita': ('krite',),
'kritet': ('krite',),
'krit': ('krite',),
'kritisere': ('kritisere',),
'kritiserer': ('kritisere',),
'kritiseres': ('kritisere',),
'kritiserte': ('kritisere',),
'kritisert': ('kritisere',),
'kritiser': ('kritisere',),
'kritle': ('kritle',),
'kritler': ('kritle',),
'kritles': ('kritle',),
'kritla': ('kritle',),
'kritlet': ('kritle',),
'kritla': ('kritle',),
'kritlet': ('kritle',),
'kritl': ('kritle',),
'kritle': ('kritle',),
'kritl': ('kritle',),
'kritle': ('kritle',),
'kritte': ('kritte',),
'kritter': ('kritte',),
'krittes': ('kritte',),
'kritta': ('kritte',),
'krittet': ('kritte',),
'kritta': ('kritte',),
'krittet': ('kritte',),
'kritt': ('kritte',),
'kro': ('kro',),
'kror': ('kro',),
'kros': ('kro',),
'krodde': ('kro',),
'krodd': ('kro',),
'kro': ('kro',),
'kroke': ('kroke',),
'kroker': ('kroke',),
'krokes': ('kroke',),
'kroka': ('kroke',),
'kroket': ('kroke',),
'kroka': ('kroke',),
'kroket': ('kroke',),
'krok': ('kroke',),
'krokere': ('krokere',),
'krokerer': ('krokere',),
'krokeres': ('krokere',),
'krokerte': ('krokere',),
'krokert': ('krokere',),
'kroker': ('krokere',),
'krokkere': ('krokkere',),
'krokkerer': ('krokkere',),
'krokkeres': ('krokkere',),
'krokkerte': ('krokkere',),
'krokkert': ('krokkere',),
'krokker': ('krokkere',),
'krokne': ('krokne',),
'krokner': ('krokne',),
'kroknes': ('krokne',),
'krokna': ('krokne',),
'kroknet': ('krokne',),
'krokna': ('krokne',),
'kroknet': ('krokne',),
'krokn': ('krokne',),
'krokne': ('krokne',),
'krokn': ('krokne',),
'krokne': ('krokne',),
'kromgarve': ('kromgarve',),
'kromgarver': ('kromgarve',),
'kromgarves': ('kromgarve',),
'kromgarva': ('kromgarve',),
'kromgarvet': ('kromgarve',),
'kromgarva': ('kromgarve',),
'kromgarvet': ('kromgarve',),
'kromgarv': ('kromgarve',),
'krone': ('krone',),
'kroner': ('krone',),
'krones': ('krone',),
'krona': ('krone',),
'kronet': ('krone',),
'kronte': ('krone',),
'krona': ('krone',),
'kronet': ('krone',),
'kront': ('krone',),
'kron': ('krone',),
'kronikkere': ('kronikkere',),
'kronikkerer': ('kronikkere',),
'kronikkeres': ('kronikkere',),
'kronikkerte': ('kronikkere',),
'kronikkert': ('kronikkere',),
'kronikker': ('kronikkere',),
'kroppsvisitere': ('kroppsvisitere',),
'kroppsvisiterer': ('kroppsvisitere',),
'kroppsvisiteres': ('kroppsvisitere',),
'kroppsvisiterte': ('kroppsvisitere',),
'kroppsvisitert': ('kroppsvisitere',),
'kroppsvisiter': ('kroppsvisitere',),
'krote': ('krote',),
'kroter': ('krote',),
'krotes': ('krote',),
'krota': ('krote',),
'krotet': ('krote',),
'krota': ('krote',),
'krotet': ('krote',),
'krot': ('krote',),
'kruke': ('kruke',),
'kruker': ('kruke',),
'krukes': ('kruke',),
'krukte': ('kruke',),
'krukt': ('kruke',),
'kruk': ('kruke',),
'krukse': ('krukse',),
'krukser': ('krukse',),
'krukses': ('krukse',),
'kruksa': ('krukse',),
'krukset': ('krukse',),
'kruksa': ('krukse',),
'krukset': ('krukse',),
'kruks': ('krukse',),
'krulle': ('krulle',),
'kruller': ('krulle',),
'krulles': ('krulle',),
'krulla': ('krulle',),
'krullet': ('krulle',),
'krulla': ('krulle',),
'krullet': ('krulle',),
'krull': ('krulle',),
'krumme': ('krumme',),
'krummer': ('krumme',),
'krummes': ('krumme',),
'krumma': ('krumme',),
'krummet': ('krumme',),
'krumma': ('krumme',),
'krummet': ('krumme',),
'krum': ('krumme',),
'kruse': ('kruse',),
'kruser': ('kruse',),
'kruses': ('kruse',),
'krusa': ('kruse',),
'kruset': ('kruse',),
'kruste': ('kruse',),
'krusa': ('kruse',),
'kruset': ('kruse',),
'krust': ('kruse',),
'krus': ('kruse',),
'krusle': ('krusle',),
'krusler': ('krusle',),
'krusles': ('krusle',),
'krusla': ('krusle',),
'kruslet': ('krusle',),
'krusla': ('krusle',),
'kruslet': ('krusle',),
'krusl': ('krusle',),
'krusle': ('krusle',),
'krusl': ('krusle',),
'krusle': ('krusle',),
'kry': ('kry',),
'kryr': ('kry',),
'krys': ('kry',),
'krydde': ('kry',),
'krydd': ('kry',),
'kry': ('kry',),
'krydre': ('krydre',),
'krydrer': ('krydre',),
'krydres': ('krydre',),
'krydra': ('krydre',),
'krydret': ('krydre',),
'krydra': ('krydre',),
'krydret': ('krydre',),
'krydr': ('krydre',),
'krydre': ('krydre',),
'krydr': ('krydre',),
'krydre': ('krydre',),
'krympe': ('krympe',),
'krymper': ('krympe',),
'krympes': ('krympe',),
'krympa': ('krympe',),
'krympet': ('krympe',),
'krympa': ('krympe',),
'krympet': ('krympe',),
'krymp': ('krympe',),
'kryne': ('kryne',),
'kryner': ('kryne',),
'krynes': ('kryne',),
'krynte': ('kryne',),
'krynt': ('kryne',),
'kryn': ('kryne',),
'krype': ('krype',),
'kryper': ('krype',),
'krypes': ('krype',),
'krøyp': ('krype',),
'krøp': ('krype',),
'krøpet': ('krype',),
'kryp': ('krype',),
'kryptere': ('kryptere',),
'krypterer': ('kryptere',),
'krypteres': ('kryptere',),
'krypterte': ('kryptere',),
'kryptert': ('kryptere',),
'krypter': ('kryptere',),
'kryptifisere': ('kryptifisere',),
'kryptifiserer': ('kryptifisere',),
'kryptifiseres': ('kryptifisere',),
'kryptifiserte': ('kryptifisere',),
'kryptifisert': ('kryptifisere',),
'kryptifiser': ('kryptifisere',),
'krysse': ('krysse',),
'krysser': ('krysse',),
'krysses': ('krysse',),
'kryssa': ('krysse',),
'krysset': ('krysse',),
'kryssa': ('krysse',),
'krysset': ('krysse',),
'kryss': ('krysse',),
'kryssforhøre': ('kryssforhøre',),
'kryssforhører': ('kryssforhøre',),
'kryssforhøres': ('kryssforhøre',),
'kryssforhørte': ('kryssforhøre',),
'kryssforhørt': ('kryssforhøre',),
'kryssforhør': ('kryssforhøre',),
'kryssklippe': ('kryssklippe',),
'kryssklipper': ('kryssklippe',),
'kryssklippes': ('kryssklippe',),
'kryssklippa': ('kryssklippe',),
'kryssklippet': ('kryssklippe',),
'kryssklipte': ('kryssklippe',),
'kryssklippa': ('kryssklippe',),
'kryssklippet': ('kryssklippe',),
'kryssklipt': ('kryssklippe',),
'kryssklipp': ('kryssklippe',),
'krystallisere': ('krystallisere',),
'krystalliserer': ('krystallisere',),
'krystalliseres': ('krystallisere',),
'krystalliserte': ('krystallisere',),
'krystallisert': ('krystallisere',),
'krystalliser': ('krystallisere',),
'kryste': ('kryste',),
'kryster': ('kryste',),
'krystes': ('kryste',),
'krysta': ('kryste',),
'krystet': ('kryste',),
'krysta': ('kryste',),
'krystet': ('kryste',),
'kryst': ('kryste',),
'kråle': ('kråle',),
'kråler': ('kråle',),
'kråles': ('kråle',),
'kråla': ('kråle',),
'krålet': ('kråle',),
'krålte': ('kråle',),
'kråla': ('kråle',),
'krålet': ('kråle',),
'krålt': ('kråle',),
'krål': ('kråle',),
'krøke': ('krøke',),
'krøker': ('krøke',),
'krøkes': ('krøke',),
'krøka': ('krøke',),
'krøket': ('krøke',),
'krøkte': ('krøke',),
'krøka': ('krøke',),
'krøket': ('krøke',),
'krøkt': ('krøke',),
'krøk': ('krøke',),
'krøkne': ('krøkne',),
'krøkner': ('krøkne',),
'krøknes': ('krøkne',),
'krøkna': ('krøkne',),
'krøknet': ('krøkne',),
'krøkna': ('krøkne',),
'krøknet': ('krøkne',),
'krøkn': ('krøkne',),
'krøkne': ('krøkne',),
'krøkn': ('krøkne',),
'krøkne': ('krøkne',),
'krølle': ('krølle',),
'krøller': ('krølle',),
'krølles': ('krølle',),
'krølla': ('krølle',),
'krøllet': ('krølle',),
'krølla': ('krølle',),
'krøllet': ('krølle',),
'krøll': ('krølle',),
'krøple': ('krøple',),
'krøpler': ('krøple',),
'krøples': ('krøple',),
'krøpla': ('krøple',),
'krøplet': ('krøple',),
'krøpla': ('krøple',),
'krøplet': ('krøple',),
'krøpl': ('krøple',),
'krøple': ('krøple',),
'krøpl': ('krøple',),
'krøple': ('krøple',),
'krøsse': ('krøsse',),
'krøsser': ('krøsse',),
'krøsses': ('krøsse',),
'krøssa': ('krøsse',),
'krøsset': ('krøsse',),
'krøssa': ('krøsse',),
'krøsset': ('krøsse',),
'krøss': ('krøsse',),
'kubbe': ('kubbe',),
'kubber': ('kubbe',),
'kubbes': ('kubbe',),
'kubba': ('kubbe',),
'kubbet': ('kubbe',),
'kubba': ('kubbe',),
'kubbet': ('kubbe',),
'kubb': ('kubbe',),
'kube': ('kube',),
'kuber': ('kube',),
'kubes': ('kube',),
'kuba': ('kube',),
'kubet': ('kube',),
'kuba': ('kube',),
'kubet': ('kube',),
'kub': ('kube',),
'kubere': ('kubere',),
'kuberer': ('kubere',),
'kuberes': ('kubere',),
'kuberte': ('kubere',),
'kubert': ('kubere',),
'kuber': ('kubere',),
'kue': ('kue',),
'kuer': ('kue',),
'kues': ('kue',),
'kua': ('kue',),
'kuet': ('kue',),
'kua': ('kue',),
'kuet': ('kue',),
'ku': ('kue',),
'kujonere': ('kujonere',),
'kujonerer': ('kujonere',),
'kujoneres': ('kujonere',),
'kujonerte': ('kujonere',),
'kujonert': ('kujonere',),
'kujoner': ('kujonere',),
'kukelure': ('kukelure',),
'kukelurer': ('kukelure',),
'kukelures': ('kukelure',),
'kukelurte': ('kukelure',),
'kukelurt': ('kukelure',),
'kukelur': ('kukelure',),
'kuldslå': ('kuldslå',),
'kuldslår': ('kuldslå',),
'kuldslås': ('kuldslå',),
'kuldslåes': ('kuldslå',),
'kuldslo': ('kuldslå',),
'kuldslått': ('kuldslå',),
'kuldslå': ('kuldslå',),
'kule': ('kule',),
'kuler': ('kule',),
'kules': ('kule',),
'kula': ('kule',),
'kulet': ('kule',),
'kulte': ('kule',),
'kula': ('kule',),
'kulet': ('kule',),
'kult': ('kule',),
'kul': ('kule',),
'kull-lyse': ('kull-lyse',),
'kull-lyser': ('kull-lyse',),
'kull-lyses': ('kull-lyse',),
'kull-lyste': ('kull-lyse',),
'kull-lyst': ('kull-lyse',),
'kull-lys': ('kull-lyse',),
'kullkaste': ('kullkaste',),
'kullkaster': ('kullkaste',),
'kullkastes': ('kullkaste',),
'kullkasta': ('kullkaste',),
'kullkastet': ('kullkaste',),
'kullkasta': ('kullkaste',),
'kullkastet': ('kullkaste',),
'kullkast': ('kullkaste',),
'kullsegle': ('kullsegle',),
'kullsegler': ('kullsegle',),
'kullsegles': ('kullsegle',),
'kullsegla': ('kullsegle',),
'kullseglet': ('kullsegle',),
'kullsegla': ('kullsegle',),
'kullseglet': ('kullsegle',),
'kullsegl': ('kullsegle',),
'kullsegle': ('kullsegle',),
'kullsegl': ('kullsegle',),
'kullsegle': ('kullsegle',),
'kullseile': ('kullseile',),
'kullseiler': ('kullseile',),
'kullseiles': ('kullseile',),
'kullseilte': ('kullseile',),
'kullseilt': ('kullseile',),
'kullseil': ('kullseile',),
'kullyse': ('kullyse',),
'kullyser': ('kullyse',),
'kullyses': ('kullyse',),
'kullyste': ('kullyse',),
'kullyst': ('kullyse',),
'kullys': ('kullyse',),
'kulminere': ('kulminere',),
'kulminerer': ('kulminere',),
'kulmineres': ('kulminere',),
'kulminerte': ('kulminere',),
'kulminert': ('kulminere',),
'kulminer': ('kulminere',),
'kulse': ('kulse',),
'kulser': ('kulse',),
'kulses': ('kulse',),
'kulsa': ('kulse',),
'kulset': ('kulse',),
'kulsa': ('kulse',),
'kulset': ('kulse',),
'kuls': ('kulse',),
'kulske': ('kulske',),
'kulsker': ('kulske',),
'kulskes': ('kulske',),
'kulska': ('kulske',),
'kulsket': ('kulske',),
'kulska': ('kulske',),
'kulsket': ('kulske',),
'kulsk': ('kulske',),
'kulte': ('kulte',),
'kulter': ('kulte',),
'kultes': ('kulte',),
'kulta': ('kulte',),
'kultet': ('kulte',),
'kulta': ('kulte',),
'kultet': ('kulte',),
'kult': ('kulte',),
'kultivere': ('kultivere',),
'kultiverer': ('kultivere',),
'kultiveres': ('kultivere',),
'kultiverte': ('kultivere',),
'kultivert': ('kultivere',),
'kultiver': ('kultivere',),
'kumle': ('kumle',),
'kumler': ('kumle',),
'kumles': ('kumle',),
'kumla': ('kumle',),
'kumlet': ('kumle',),
'kumla': ('kumle',),
'kumlet': ('kumle',),
'kuml': ('kumle',),
'kumle': ('kumle',),
'kuml': ('kumle',),
'kumle': ('kumle',),
'kumulere': ('kumulere',),
'kumulerer': ('kumulere',),
'kumuleres': ('kumulere',),
'kumulerte': ('kumulere',),
'kumulert': ('kumulere',),
'kumuler': ('kumulere',),
'kunne': ('kunne',),
'kan': ('kunne',),
'kunnes': ('kunne',),
'kunne': ('kunne',),
'kunnet': ('kunne',),
'kunngjøre': ('kunngjøre',),
'kunngjør': ('kunngjøre',),
'kunngjøres': ('kunngjøre',),
'kunngjorde': ('kunngjøre',),
'kunngjort': ('kunngjøre',),
'kunngjør': ('kunngjøre',),
'kupere': ('kupere',),
'kuperer': ('kupere',),
'kuperes': ('kupere',),
'kuperte': ('kupere',),
'kupert': ('kupere',),
'kuper': ('kupere',),
'kuple': ('kuple',),
'kupler': ('kuple',),
'kuples': ('kuple',),
'kupla': ('kuple',),
'kuplet': ('kuple',),
'kupla': ('kuple',),
'kuplet': ('kuple',),
'kupl': ('kuple',),
'kuple': ('kuple',),
'kupl': ('kuple',),
'kuple': ('kuple',),
'kuppe': ('kuppe',),
'kupper': ('kuppe',),
'kuppes': ('kuppe',),
'kuppa': ('kuppe',),
'kuppet': ('kuppe',),
'kuppa': ('kuppe',),
'kuppet': ('kuppe',),
'kupp': ('kuppe',),
'kurere': ('kurere',),
'kurerer': ('kurere',),
'kureres': ('kurere',),
'kurerte': ('kurere',),
'kurert': ('kurere',),
'kurer': ('kurere',),
'kurre': ('kurre',),
'kurrer': ('kurre',),
'kurres': ('kurre',),
'kurra': ('kurre',),
'kurret': ('kurre',),
'kurra': ('kurre',),
'kurret': ('kurre',),
'kurr': ('kurre',),
'kurse': ('kurse',),
'kurser': ('kurse',),
'kurses': ('kurse',),
'kursa': ('kurse',),
'kurset': ('kurse',),
'kursa': ('kurse',),
'kurset': ('kurse',),
'kurs': ('kurse',),
'kursere': ('kursere',),
'kurserer': ('kursere',),
'kurseres': ('kursere',),
'kurserte': ('kursere',),
'kursert': ('kursere',),
'kurser': ('kursere',),
'kursivere': ('kursivere',),
'kursiverer': ('kursivere',),
'kursiveres': ('kursivere',),
'kursiverte': ('kursivere',),
'kursivert': ('kursivere',),
'kursiver': ('kursivere',),
'kurtisere': ('kurtisere',),
'kurtiserer': ('kurtisere',),
'kurtiseres': ('kurtisere',),
'kurtiserte': ('kurtisere',),
'kurtisert': ('kurtisere',),
'kurtiser': ('kurtisere',),
'kurve': ('kurve',),
'kurver': ('kurve',),
'kurves': ('kurve',),
'kurva': ('kurve',),
'kurvet': ('kurve',),
'kurva': ('kurve',),
'kurvet': ('kurve',),
'kurv': ('kurve',),
'kuske': ('kuske',),
'kusker': ('kuske',),
'kuskes': ('kuske',),
'kuska': ('kuske',),
'kusket': ('kuske',),
'kuska': ('kuske',),
'kusket': ('kuske',),
'kusk': ('kuske',),
'kuste': ('kuste',),
'kuster': ('kuste',),
'kustes': ('kuste',),
'kusta': ('kuste',),
'kustet': ('kuste',),
'kusta': ('kuste',),
'kustet': ('kuste',),
'kust': ('kuste',),
'kute': ('kute',),
'kuter': ('kute',),
'kutes': ('kute',),
'kuta': ('kute',),
'kutet': ('kute',),
'kutte': ('kute',),
'kuta': ('kute',),
'kutet': ('kute',),
'kutt': ('kute',),
'kut': ('kute',),
'kutte': ('kutte',),
'kutter': ('kutte',),
'kuttes': ('kutte',),
'kutta': ('kutte',),
'kuttet': ('kutte',),
'kutta': ('kutte',),
'kuttet': ('kutte',),
'kutt': ('kutte',),
'kuve': ('kuve',),
'kuver': ('kuve',),
'kuves': ('kuve',),
'kuva': ('kuve',),
'kuvet': ('kuve',),
'kuvde': ('kuve',),
'kuva': ('kuve',),
'kuvet': ('kuve',),
'kuvd': ('kuve',),
'kuv': ('kuve',),
'kuvende': ('kuvende',),
'kuvender': ('kuvende',),
'kuvendes': ('kuvende',),
'kuvendte': ('kuvende',),
'kuvendt': ('kuvende',),
'kuvend': ('kuvende',),
'kvadrere': ('kvadrere',),
'kvadrerer': ('kvadrere',),
'kvadreres': ('kvadrere',),
'kvadrerte': ('kvadrere',),
'kvadrert': ('kvadrere',),
'kvadrer': ('kvadrere',),
'kvakke': ('kvakke',),
'kvakker': ('kvakke',),
'kvakkes': ('kvakke',),
'kvakka': ('kvakke',),
'kvakket': ('kvakke',),
'kvakka': ('kvakke',),
'kvakket': ('kvakke',),
'kvakk': ('kvakke',),
'kvalifisere': ('kvalifisere',),
'kvalifiserer': ('kvalifisere',),
'kvalifiseres': ('kvalifisere',),
'kvalifiserte': ('kvalifisere',),
'kvalifisert': ('kvalifisere',),
'kvalifiser': ('kvalifisere',),
'kvamne': ('kvamne',),
'kvamner': ('kvamne',),
'kvamnes': ('kvamne',),
'kvamna': ('kvamne',),
'kvamnet': ('kvamne',),
'kvamna': ('kvamne',),
'kvamnet': ('kvamne',),
'kvamn': ('kvamne',),
'kvamne': ('kvamne',),
'kvamn': ('kvamne',),
'kvamne': ('kvamne',),
'kvantifisere': ('kvantifisere',),
'kvantifiserer': ('kvantifisere',),
'kvantifiseres': ('kvantifisere',),
'kvantifiserte': ('kvantifisere',),
'kvantifisert': ('kvantifisere',),
'kvantifiser': ('kvantifisere',),
'kvantitere': ('kvantitere',),
'kvantiterer': ('kvantitere',),
'kvantiteres': ('kvantitere',),
'kvantiterte': ('kvantitere',),
'kvantitert': ('kvantitere',),
'kvantiter': ('kvantitere',),
'kvare': ('kvare',),
'kvarer': ('kvare',),
'kvares': ('kvare',),
'kvara': ('kvare',),
'kvaret': ('kvare',),
'kvarte': ('kvare',),
'kvara': ('kvare',),
'kvaret': ('kvare',),
'kvart': ('kvare',),
'kvar': ('kvare',),
'kvarte': ('kvarte',),
'kvarter': ('kvarte',),
'kvartes': ('kvarte',),
'kvarta': ('kvarte',),
'kvartet': ('kvarte',),
'kvarta': ('kvarte',),
'kvartet': ('kvarte',),
'kvart': ('kvarte',),
'kvaste': ('kvaste',),
'kvaster': ('kvaste',),
'kvastes': ('kvaste',),
'kvasta': ('kvaste',),
'kvastet': ('kvaste',),
'kvasta': ('kvaste',),
'kvastet': ('kvaste',),
'kvast': ('kvaste',),
'kvede': ('kvede',),
'kveder': ('kvede',),
'kvedes': ('kvede',),
'kvad': ('kvede',),
'kvedet': ('kvede',),
'kved': ('kvede',),
'kvee': ('kvee',),
'kveer': ('kvee',),
'kvees': ('kvee',),
'kvea': ('kvee',),
'kveet': ('kvee',),
'kvea': ('kvee',),
'kveet': ('kvee',),
'kve': ('kvee',),
'kvege': ('kvege',),
'kveger': ('kvege',),
'kveges': ('kvege',),
'kvega': ('kvege',),
'kveget': ('kvege',),
'kvega': ('kvege',),
'kveget': ('kvege',),
'kveg': ('kvege',),
'kveike': ('kveike',),
'kveiker': ('kveike',),
'kveikes': ('kveike',),
'kveikte': ('kveike',),
'kveikt': ('kveike',),
'kveik': ('kveike',),
'kveile': ('kveile',),
'kveiler': ('kveile',),
'kveiles': ('kveile',),
'kveila': ('kveile',),
'kveilet': ('kveile',),
'kveilte': ('kveile',),
'kveila': ('kveile',),
'kveilet': ('kveile',),
'kveilt': ('kveile',),
'kveil': ('kveile',),
'kvekke': ('kvekke',),
'kvekker': ('kvekke',),
'kvekkes': ('kvekke',),
'kvakk': ('kvekke',),
'kvekket': ('kvekke',),
'kvekk': ('kvekke',),
'kvelde': ('kvelde',),
'kvelder': ('kvelde',),
'kveldes': ('kvelde',),
'kvelda': ('kvelde',),
'kveldet': ('kvelde',),
'kvelda': ('kvelde',),
'kveldet': ('kvelde',),
'kveld': ('kvelde',),
'kvele': ('kvele',),
'kveler': ('kvele',),
'kveles': ('kvele',),
'kvelte': ('kvele',),
'kvalte': ('kvele',),
'kvelt': ('kvele',),
'kvalt': ('kvele',),
'kvel': ('kvele',),
'kvelve': ('kvelve',),
'kvelver': ('kvelve',),
'kvelves': ('kvelve',),
'kvelva': ('kvelve',),
'kvelvet': ('kvelve',),
'kvelvde': ('kvelve',),
'kvelva': ('kvelve',),
'kvelvet': ('kvelve',),
'kvelvd': ('kvelve',),
'kvelv': ('kvelve',),
'kverke': ('kverke',),
'kverker': ('kverke',),
'kverkes': ('kverke',),
'kverka': ('kverke',),
'kverket': ('kverke',),
'kverka': ('kverke',),
'kverket': ('kverke',),
'kverk': ('kverke',),
'kverne': ('kverne',),
'kverner': ('kverne',),
'kvernes': ('kverne',),
'kverna': ('kverne',),
'kvernet': ('kverne',),
'kverna': ('kverne',),
'kvernet': ('kverne',),
'kvern': ('kverne',),
'kverrsette': ('kverrsette',),
'kverrsetter': ('kverrsette',),
'kverrsettes': ('kverrsette',),
'kverrsatte': ('kverrsette',),
'kverrsatt': ('kverrsette',),
'kverrsett': ('kverrsette',),
'kverulere': ('kverulere',),
'kverulerer': ('kverulere',),
'kveruleres': ('kverulere',),
'kverulerte': ('kverulere',),
'kverulert': ('kverulere',),
'kveruler': ('kverulere',),
'kverve': ('kverve',),
'kverver': ('kverve',),
'kverves': ('kverve',),
'kverva': ('kverve',),
'kvervet': ('kverve',),
'kvervde': ('kverve',),
'kverva': ('kverve',),
'kvervet': ('kverve',),
'kvervd': ('kverve',),
'kverv': ('kverve',),
'kverve': ('kverve',),
'kverver': ('kverve',),
'kverves': ('kverve',),
'kvarv': ('kverve',),
'kvervet': ('kverve',),
'kverv': ('kverve',),
'kvese': ('kvese',),
'kveser': ('kvese',),
'kveses': ('kvese',),
'kveste': ('kvese',),
'kvest': ('kvese',),
'kves': ('kvese',),
'kvesse': ('kvesse',),
'kvesser': ('kvesse',),
'kvesses': ('kvesse',),
'kvessa': ('kvesse',),
'kvesset': ('kvesse',),
'kvesste': ('kvesse',),
'kvessa': ('kvesse',),
'kvesset': ('kvesse',),
'kvesst': ('kvesse',),
'kvess': ('kvesse',),
'kveste': ('kveste',),
'kvester': ('kveste',),
'kvestes': ('kveste',),
'kvesta': ('kveste',),
'kvestet': ('kveste',),
'kvesta': ('kveste',),
'kvestet': ('kveste',),
'kvest': ('kveste',),
'kvi': ('kvi',),
'kvir': ('kvi',),
'kvis': ('kvi',),
'kvia': ('kvi',),
'kviet': ('kvi',),
'kvidde': ('kvi',),
'kvia': ('kvi',),
'kviet': ('kvi',),
'kvidd': ('kvi',),
'kvi': ('kvi',),
'kvie': ('kvie',),
'kvier': ('kvie',),
'kvies': ('kvie',),
'kvia': ('kvie',),
'kviet': ('kvie',),
'kvidde': ('kvie',),
'kvia': ('kvie',),
'kviet': ('kvie',),
'kvidd': ('kvie',),
'kvi': ('kvie',),
'kvikke': ('kvikke',),
'kvikker': ('kvikke',),
'kvikkes': ('kvikke',),
'kvikka': ('kvikke',),
'kvikket': ('kvikke',),
'kvikka': ('kvikke',),
'kvikket': ('kvikke',),
'kvikk': ('kvikke',),
'kvikne': ('kvikne',),
'kvikner': ('kvikne',),
'kviknes': ('kvikne',),
'kvikna': ('kvikne',),
'kviknet': ('kvikne',),
'kvikna': ('kvikne',),
'kviknet': ('kvikne',),
'kvikn': ('kvikne',),
'kvikne': ('kvikne',),
'kvikn': ('kvikne',),
'kvikne': ('kvikne',),
'kvile': ('kvile',),
'kviler': ('kvile',),
'kviles': ('kvile',),
'kvilte': ('kvile',),
'kvilt': ('kvile',),
'kvil': ('kvile',),
'kvine': ('kvine',),
'kviner': ('kvine',),
'kvines': ('kvine',),
'kvinte': ('kvine',),
'kvein': ('kvine',),
'kvint': ('kvine',),
'kvin': ('kvine',),
'kvinke': ('kvinke',),
'kvinker': ('kvinke',),
'kvinkes': ('kvinke',),
'kvinka': ('kvinke',),
'kvinket': ('kvinke',),
'kvinka': ('kvinke',),
'kvinket': ('kvinke',),
'kvink': ('kvinke',),
'kviskre': ('kviskre',),
'kviskrer': ('kviskre',),
'kviskres': ('kviskre',),
'kviskra': ('kviskre',),
'kviskret': ('kviskre',),
'kviskra': ('kviskre',),
'kviskret': ('kviskre',),
'kviskr': ('kviskre',),
'kviskre': ('kviskre',),
'kviskr': ('kviskre',),
'kviskre': ('kviskre',),
'kvisle': ('kvisle',),
'kvisler': ('kvisle',),
'kvisles': ('kvisle',),
'kvisla': ('kvisle',),
'kvislet': ('kvisle',),
'kvisla': ('kvisle',),
'kvislet': ('kvisle',),
'kvisl': ('kvisle',),
'kvisle': ('kvisle',),
'kvisl': ('kvisle',),
'kvisle': ('kvisle',),
'kviste': ('kviste',),
'kvister': ('kviste',),
'kvistes': ('kviste',),
'kvista': ('kviste',),
'kvistet': ('kviste',),
'kvista': ('kviste',),
'kvistet': ('kviste',),
'kvist': ('kviste',),
'kvite': ('kvite',),
'kviter': ('kvite',),
'kvites': ('kvite',),
'kvita': ('kvite',),
'kvitet': ('kvite',),
'kvita': ('kvite',),
'kvitet': ('kvite',),
'kvit': ('kvite',),
'kvitkalke': ('kvitkalke',),
'kvitkalker': ('kvitkalke',),
'kvitkalkes': ('kvitkalke',),
'kvitkalka': ('kvitkalke',),
'kvitkalket': ('kvitkalke',),
'kvitkalka': ('kvitkalke',),
'kvitkalket': ('kvitkalke',),
'kvitkalk': ('kvitkalke',),
'kvitne': ('kvitne',),
'kvitner': ('kvitne',),
'kvitnes': ('kvitne',),
'kvitna': ('kvitne',),
'kvitnet': ('kvitne',),
'kvitna': ('kvitne',),
'kvitnet': ('kvitne',),
'kvitn': ('kvitne',),
'kvitne': ('kvitne',),
'kvitn': ('kvitne',),
'kvitne': ('kvitne',),
'kvitre': ('kvitre',),
'kvitrer': ('kvitre',),
'kvitres': ('kvitre',),
'kvitra': ('kvitre',),
'kvitret': ('kvitre',),
'kvitra': ('kvitre',),
'kvitret': ('kvitre',),
'kvitr': ('kvitre',),
'kvitre': ('kvitre',),
'kvitr': ('kvitre',),
'kvitre': ('kvitre',),
'kvitte': ('kvitte',),
'kvitter': ('kvitte',),
'kvittes': ('kvitte',),
'kvitta': ('kvitte',),
'kvittet': ('kvitte',),
'kvitta': ('kvitte',),
'kvittet': ('kvitte',),
'kvitt': ('kvitte',),
'kvittere': ('kvittere',),
'kvitterer': ('kvittere',),
'kvitteres': ('kvittere',),
'kvitterte': ('kvittere',),
'kvittert': ('kvittere',),
'kvitter': ('kvittere',),
'kvitvaske': ('kvitvaske',),
'kvitvasker': ('kvitvaske',),
'kvitvaskes': ('kvitvaske',),
'kvitvaska': ('kvitvaske',),
'kvitvasket': ('kvitvaske',),
'kvitvaska': ('kvitvaske',),
'kvitvasket': ('kvitvaske',),
'kvitvask': ('kvitvaske',),
'kvotere': ('kvotere',),
'kvoterer': ('kvotere',),
'kvoteres': ('kvotere',),
'kvoterte': ('kvotere',),
'kvotert': ('kvotere',),
'kvoter': ('kvotere',),
'kvæve': ('kvæve',),
'kvæver': ('kvæve',),
'kvæves': ('kvæve',),
'kvævde': ('kvæve',),
'kvævd': ('kvæve',),
'kvæv': ('kvæve',),
'kyle': ('kyle',),
'kyler': ('kyle',),
'kyles': ('kyle',),
'kylte': ('kyle',),
'kylt': ('kyle',),
'kyl': ('kyle',),
'kylle': ('kylle',),
'kyller': ('kylle',),
'kylles': ('kylle',),
'kylte': ('kylle',),
'kylt': ('kylle',),
'kyll': ('kylle',),
'kysse': ('kysse',),
'kysser': ('kysse',),
'kysses': ('kysse',),
'kyssa': ('kysse',),
'kysset': ('kysse',),
'kyste': ('kysse',),
'kyssa': ('kysse',),
'kysset': ('kysse',),
'kyst': ('kysse',),
'kyss': ('kysse',),
'kyte': ('kyte',),
'kyter': ('kyte',),
'kytes': ('kyte',),
'kytte': ('kyte',),
'kytt': ('kyte',),
'kyt': ('kyte',),
'kå': ('kå',),
'kår': ('kå',),
'kås': ('kå',),
'kådde': ('kå',),
'kådd': ('kå',),
'kå': ('kå',),
'kåle': ('kåle',),
'kåler': ('kåle',),
'kåles': ('kåle',),
'kåla': ('kåle',),
'kålet': ('kåle',),
'kåla': ('kåle',),
'kålet': ('kåle',),
'kål': ('kåle',),
'kåre': ('kåre',),
'kårer': ('kåre',),
'kåres': ('kåre',),
'kåra': ('kåre',),
'kåret': ('kåre',),
'kåra': ('kåre',),
'kåret': ('kåre',),
'kår': ('kåre',),
'kåsere': ('kåsere',),
'kåserer': ('kåsere',),
'kåseres': ('kåsere',),
'kåserte': ('kåsere',),
'kåsert': ('kåsere',),
'kåser': ('kåsere',),
'kødde': ('kødde',),
'kødder': ('kødde',),
'køddes': ('kødde',),
'kødda': ('kødde',),
'køddet': ('kødde',),
'kødda': ('kødde',),
'køddet': ('kødde',),
'kødd': ('kødde',),
'køe': ('køe',),
'køer': ('køe',),
'køes': ('køe',),
'køa': ('køe',),
'køet': ('køe',),
'køa': ('køe',),
'køet': ('køe',),
'kø': ('køe',),
'køye': ('køye',),
'køyer': ('køye',),
'køyes': ('køye',),
'køya': ('køye',),
'køyet': ('køye',),
'køya': ('køye',),
'køyet': ('køye',),
'køy': ('køye',),
'labbe': ('labbe',),
'labber': ('labbe',),
'labbes': ('labbe',),
'labba': ('labbe',),
'labbet': ('labbe',),
'labba': ('labbe',),
'labbet': ('labbe',),
'labb': ('labbe',),
'labialisere': ('labialisere',),
'labialiserer': ('labialisere',),
'labialiseres': ('labialisere',),
'labialiserte': ('labialisere',),
'labialisert': ('labialisere',),
'labialiser': ('labialisere',),
'lade': ('lade',),
'lader': ('lade',),
'lades': ('lade',),
'lada': ('lade',),
'ladet': ('lade',),
'ladde': ('lade',),
'lada': ('lade',),
'ladet': ('lade',),
'ladd': ('lade',),
'lad': ('lade',),
'lafte': ('lafte',),
'lafter': ('lafte',),
'laftes': ('lafte',),
'lafta': ('lafte',),
'laftet': ('lafte',),
'lafta': ('lafte',),
'laftet': ('lafte',),
'laft': ('lafte',),
'lage': ('lage',),
'lager': ('lage',),
'lages': ('lage',),
'laga': ('lage',),
'laget': ('lage',),
'lagde': ('lage',),
'laga': ('lage',),
'laget': ('lage',),
'lagd': ('lage',),
'lag': ('lage',),
'lagerføre': ('lagerføre',),
'lagerfører': ('lagerføre',),
'lagerføres': ('lagerføre',),
'lagerførte': ('lagerføre',),
'lagerført': ('lagerføre',),
'lagerfør': ('lagerføre',),
'lagge': ('lagge',),
'lagger': ('lagge',),
'lagges': ('lagge',),
'lagga': ('lagge',),
'lagget': ('lagge',),
'lagga': ('lagge',),
'lagget': ('lagge',),
'lagg': ('lagge',),
'lagre': ('lagre',),
'lagrer': ('lagre',),
'lagres': ('lagre',),
'lagra': ('lagre',),
'lagret': ('lagre',),
'lagra': ('lagre',),
'lagret': ('lagre',),
'lagr': ('lagre',),
'lagre': ('lagre',),
'lagr': ('lagre',),
'lagre': ('lagre',),
'lake': ('lake',),
'laker': ('lake',),
'lakes': ('lake',),
'laka': ('lake',),
'laket': ('lake',),
'laka': ('lake',),
'laket': ('lake',),
'lak': ('lake',),
'lakke': ('lakke',),
'lakker': ('lakke',),
'lakkes': ('lakke',),
'lakka': ('lakke',),
'lakket': ('lakke',),
'lakka': ('lakke',),
'lakket': ('lakke',),
'lakk': ('lakke',),
'lakkere': ('lakkere',),
'lakkerer': ('lakkere',),
'lakkeres': ('lakkere',),
'lakkerte': ('lakkere',),
'lakkert': ('lakkere',),
'lakker': ('lakkere',),
'laksere': ('laksere',),
'lakserer': ('laksere',),
'lakseres': ('laksere',),
'lakserte': ('laksere',),
'laksert': ('laksere',),
'lakser': ('laksere',),
'lale': ('lale',),
'laler': ('lale',),
'lales': ('lale',),
'lala': ('lale',),
'lalet': ('lale',),
'lala': ('lale',),
'lalet': ('lale',),
'lal': ('lale',),
'lalle': ('lalle',),
'laller': ('lalle',),
'lalles': ('lalle',),
'lalla': ('lalle',),
'lallet': ('lalle',),
'lalla': ('lalle',),
'lallet': ('lalle',),
'lall': ('lalle',),
'laminere': ('laminere',),
'laminerer': ('laminere',),
'lamineres': ('laminere',),
'laminerte': ('laminere',),
'laminert': ('laminere',),
'laminer': ('laminere',),
'lamme': ('lamme',),
'lammer': ('lamme',),
'lammes': ('lamme',),
'lamma': ('lamme',),
'lammet': ('lamme',),
'lamma': ('lamme',),
'lammet': ('lamme',),
'lam': ('lamme',),
'lamslå': ('lamslå',),
'lamslår': ('lamslå',),
'lamslås': ('lamslå',),
'lamslåes': ('lamslå',),
'lamslo': ('lamslå',),
'lamslått': ('lamslå',),
'lamslå': ('lamslå',),
'lande': ('lande',),
'lander': ('lande',),
'landes': ('lande',),
'landa': ('lande',),
'landet': ('lande',),
'landa': ('lande',),
'landet': ('lande',),
'land': ('lande',),
'landsette': ('landsette',),
'landsetter': ('landsette',),
'landsettes': ('landsette',),
'landsatte': ('landsette',),
'landsatt': ('landsette',),
'landsett': ('landsette',),
'landsforvise': ('landsforvise',),
'landsforviser': ('landsforvise',),
'landsforvises': ('landsforvise',),
'landsforviste': ('landsforvise',),
'landsforvist': ('landsforvise',),
'landsforvis': ('landsforvise',),
'lange': ('lange',),
'langer': ('lange',),
'langes': ('lange',),
'langa': ('lange',),
'langet': ('lange',),
'langa': ('lange',),
'langet': ('lange',),
'lang': ('lange',),
'lansere': ('lansere',),
'lanserer': ('lansere',),
'lanseres': ('lansere',),
'lanserte': ('lansere',),
'lansert': ('lansere',),
'lanser': ('lansere',),
'lappe': ('lappe',),
'lapper': ('lappe',),
'lappes': ('lappe',),
'lappa': ('lappe',),
'lappet': ('lappe',),
'lappa': ('lappe',),
'lappet': ('lappe',),
'lapp': ('lappe',),
'larme': ('larme',),
'larmer': ('larme',),
'larmes': ('larme',),
'larma': ('larme',),
'larmet': ('larme',),
'larma': ('larme',),
'larmet': ('larme',),
'larm': ('larme',),
'lasere': ('lasere',),
'laserer': ('lasere',),
'laseres': ('lasere',),
'laserte': ('lasere',),
'lasert': ('lasere',),
'laser': ('lasere',),
'laske': ('laske',),
'lasker': ('laske',),
'laskes': ('laske',),
'laska': ('laske',),
'lasket': ('laske',),
'laska': ('laske',),
'lasket': ('laske',),
'lask': ('laske',),
'laste': ('laste',),
'laster': ('laste',),
'lastes': ('laste',),
'lasta': ('laste',),
'lastet': ('laste',),
'lasta': ('laste',),
'lastet': ('laste',),
'last': ('laste',),
'late': ('late',),
'later': ('late',),
'lates': ('late',),
'lata': ('late',),
'latet': ('late',),
'lata': ('late',),
'latet': ('late',),
'lat': ('late',),
'late': ('late',),
'later': ('late',),
'lates': ('late',),
'lot': ('late',),
'latt': ('late',),
'lat': ('late',),
'latinisere': ('latinisere',),
'latiniserer': ('latinisere',),
'latiniseres': ('latinisere',),
'latiniserte': ('latinisere',),
'latinisert': ('latinisere',),
'latiniser': ('latinisere',),
'latterliggjøre': ('latterliggjøre',),
'latterliggjør': ('latterliggjøre',),
'latterliggjøres': ('latterliggjøre',),
'latterliggjorde': ('latterliggjøre',),
'latterliggjort': ('latterliggjøre',),
'latterliggjør': ('latterliggjøre',),
'lauge': ('lauge',),
'lauger': ('lauge',),
'lauges': ('lauge',),
'lauga': ('lauge',),
'lauget': ('lauge',),
'lauga': ('lauge',),
'lauget': ('lauge',),
'laug': ('lauge',),
'lausgi': ('lausgi',),
'lausgir': ('lausgi',),
'lausgis': ('lausgi',),
'lausgav': ('lausgi',),
'lausga': ('lausgi',),
'lausgitt': ('lausgi',),
'lausgi': ('lausgi',),
'lausgjøre': ('lausgjøre',),
'lausgjør': ('lausgjøre',),
'lausgjøres': ('lausgjøre',),
'lausgjorde': ('lausgjøre',),
'lausgjort': ('lausgjøre',),
'lausgjør': ('lausgjøre',),
'lauve': ('lauve',),
'lauver': ('lauve',),
'lauves': ('lauve',),
'lauva': ('lauve',),
'lauvet': ('lauve',),
'lauva': ('lauve',),
'lauvet': ('lauve',),
'lauv': ('lauve',),
'lave': ('lave',),
'laver': ('lave',),
'laves': ('lave',),
'lava': ('lave',),
'lavet': ('lave',),
'lavde': ('lave',),
'lava': ('lave',),
'lavet': ('lave',),
'lavd': ('lave',),
'lav': ('lave',),
'layoute': ('layoute',),
'layouter': ('layoute',),
'layoutes': ('layoute',),
'layouta': ('layoute',),
'layoutet': ('layoute',),
'layouta': ('layoute',),
'layoutet': ('layoute',),
'layout': ('layoute',),
'le': ('le',),
'ler': ('le',),
'les': ('le',),
'lo': ('le',),
'ledd': ('le',),
'le': ('le',),
'lease': ('lease',),
'leaser': ('lease',),
'leases': ('lease',),
'leasa': ('lease',),
'leaset': ('lease',),
'leasa': ('lease',),
'leaset': ('lease',),
'leas': ('lease',),
'ledde': ('ledde',),
'ledder': ('ledde',),
'leddes': ('ledde',),
'ledda': ('ledde',),
'leddet': ('ledde',),
'ledda': ('ledde',),
'leddet': ('ledde',),
'ledd': ('ledde',),
'lede': ('lede',),
'leder': ('lede',),
'ledes': ('lede',),
'leda': ('lede',),
'ledet': ('lede',),
'leda': ('lede',),
'ledet': ('lede',),
'led': ('lede',),
'ledes': ('ledes',),
'lededes': ('ledes',),
'ledes': ('ledes',),
'ledsage': ('ledsage',),
'ledsager': ('ledsage',),
'ledsages': ('ledsage',),
'ledsaga': ('ledsage',),
'ledsaget': ('ledsage',),
'ledsaga': ('ledsage',),
'ledsaget': ('ledsage',),
'ledsag': ('ledsage',),
'lee': ('lee',),
'leer': ('lee',),
'lees': ('lee',),
'lea': ('lee',),
'leet': ('lee',),
'lea': ('lee',),
'leet': ('lee',),
'le': ('lee',),
'lefle': ('lefle',),
'lefler': ('lefle',),
'lefles': ('lefle',),
'lefla': ('lefle',),
'leflet': ('lefle',),
'lefla': ('lefle',),
'leflet': ('lefle',),
'lefl': ('lefle',),
'lefle': ('lefle',),
'lefl': ('lefle',),
'lefle': ('lefle',),
'legalisere': ('legalisere',),
'legaliserer': ('legalisere',),
'legaliseres': ('legalisere',),
'legaliserte': ('legalisere',),
'legalisert': ('legalisere',),
'legaliser': ('legalisere',),
'lege': ('lege',),
'leger': ('lege',),
'leges': ('lege',),
'lega': ('lege',),
'leget': ('lege',),
'legte': ('lege',),
'lega': ('lege',),
'leget': ('lege',),
'legt': ('lege',),
'leg': ('lege',),
'legemliggjøre': ('legemliggjøre',),
'legemliggjør': ('legemliggjøre',),
'legemliggjøres': ('legemliggjøre',),
'legemliggjorde': ('legemliggjøre',),
'legemliggjort': ('legemliggjøre',),
'legemliggjør': ('legemliggjøre',),
'legere': ('legere',),
'legerer': ('legere',),
'legeres': ('legere',),
'legerte': ('legere',),
'legert': ('legere',),
'leger': ('legere',),
'legge': ('legge',),
'legger': ('legge',),
'legges': ('legge',),
'la': ('legge',),
'lagt': ('legge',),
'legg': ('legge',),
'legitimere': ('legitimere',),
'legitimerer': ('legitimere',),
'legitimeres': ('legitimere',),
'legitimerte': ('legitimere',),
'legitimert': ('legitimere',),
'legitimer': ('legitimere',),
'leies': ('leies',),
'leides': ('leies',),
'leies': ('leies',),
'leire': ('leire',),
'leirer': ('leire',),
'leires': ('leire',),
'leira': ('leire',),
'leiret': ('leire',),
'leira': ('leire',),
'leiret': ('leire',),
'leir': ('leire',),
'leive': ('leive',),
'leiver': ('leive',),
'leives': ('leive',),
'leivde': ('leive',),
'leivd': ('leive',),
'leiv': ('leive',),
'leke': ('leke',),
'leker': ('leke',),
'lekes': ('leke',),
'lekte': ('leke',),
'lekt': ('leke',),
'lek': ('leke',),
'lekke': ('lekke',),
'lekker': ('lekke',),
'lekkes': ('lekke',),
'lekka': ('lekke',),
'lekket': ('lekke',),
'lakk': ('lekke',),
'lekka': ('lekke',),
'lekket': ('lekke',),
'lekk': ('lekke',),
'lekre': ('lekre',),
'lekrer': ('lekre',),
'lekres': ('lekre',),
'lekra': ('lekre',),
'lekret': ('lekre',),
'lekra': ('lekre',),
'lekret': ('lekre',),
'lekr': ('lekre',),
'lekre': ('lekre',),
'lekr': ('lekre',),
'lekre': ('lekre',),
'lekse': ('lekse',),
'lekser': ('lekse',),
'lekses': ('lekse',),
'leksa': ('lekse',),
'lekset': ('lekse',),
'leksa': ('lekse',),
'lekset': ('lekse',),
'leks': ('lekse',),
'lekte': ('lekte',),
'lekter': ('lekte',),
'lektes': ('lekte',),
'lekta': ('lekte',),
'lektet': ('lekte',),
'lekta': ('lekte',),
'lektet': ('lekte',),
'lekt': ('lekte',),
'lemleste': ('lemleste',),
'lemlester': ('lemleste',),
'lemlestes': ('lemleste',),
'lemlesta': ('lemleste',),
'lemlestet': ('lemleste',),
'lemlesta': ('lemleste',),
'lemlestet': ('lemleste',),
'lemlest': ('lemleste',),
'lemmatisere': ('lemmatisere',),
'lemmatiserer': ('lemmatisere',),
'lemmatiseres': ('lemmatisere',),
'lemmatiserte': ('lemmatisere',),
'lemmatisert': ('lemmatisere',),
'lemmatiser': ('lemmatisere',),
'lemme': ('lemme',),
'lemmer': ('lemme',),
'lemmes': ('lemme',),
'lemma': ('lemme',),
'lemmet': ('lemme',),
'lemma': ('lemme',),
'lemmet': ('lemme',),
'lem': ('lemme',),
'lempe': ('lempe',),
'lemper': ('lempe',),
'lempes': ('lempe',),
'lempa': ('lempe',),
'lempet': ('lempe',),
'lempa': ('lempe',),
'lempet': ('lempe',),
'lemp': ('lempe',),
'lemstre': ('lemstre',),
'lemstrer': ('lemstre',),
'lemstres': ('lemstre',),
'lemstra': ('lemstre',),
'lemstret': ('lemstre',),
'lemstra': ('lemstre',),
'lemstret': ('lemstre',),
'lemstr': ('lemstre',),
'lemstre': ('lemstre',),
'lemstr': ('lemstre',),
'lemstre': ('lemstre',),
'lene': ('lene',),
'lener': ('lene',),
'lenes': ('lene',),
'lenet': ('lene',),
'lente': ('lene',),
'lenet': ('lene',),
'lent': ('lene',),
'len': ('lene',),
'lenges': ('lenges',),
'lengtes': ('lenges',),
'lenges': ('lenges',),
'lengte': ('lengte',),
'lengter': ('lengte',),
'lengtes': ('lengte',),
'lengta': ('lengte',),
'lengtet': ('lengte',),
'lengta': ('lengte',),
'lengtet': ('lengte',),
'lengt': ('lengte',),
'lenke': ('lenke',),
'lenker': ('lenke',),
'lenkes': ('lenke',),
'lenka': ('lenke',),
'lenket': ('lenke',),
'lenka': ('lenke',),
'lenket': ('lenke',),
'lenk': ('lenke',),
'lense': ('lense',),
'lenser': ('lense',),
'lenses': ('lense',),
'lensa': ('lense',),
'lenset': ('lense',),
'lensa': ('lense',),
'lenset': ('lense',),
'lens': ('lense',),
'lepe': ('lepe',),
'leper': ('lepe',),
'lepes': ('lepe',),
'lepte': ('lepe',),
'lept': ('lepe',),
'lep': ('lepe',),
'lepje': ('lepje',),
'lepjer': ('lepje',),
'lepjes': ('lepje',),
'lepja': ('lepje',),
'lepjet': ('lepje',),
'lepja': ('lepje',),
'lepjet': ('lepje',),
'lepj': ('lepje',),
'lepje': ('lepje',),
'lepj': ('lepje',),
'lepje': ('lepje',),
'lese': ('lese',),
'leser': ('lese',),
'leses': ('lese',),
'leste': ('lese',),
'lest': ('lese',),
'les': ('lese',),
'leske': ('leske',),
'lesker': ('leske',),
'leskes': ('leske',),
'leska': ('leske',),
'lesket': ('leske',),
'leska': ('leske',),
'lesket': ('leske',),
'lesk': ('leske',),
'lespe': ('lespe',),
'lesper': ('lespe',),
'lespes': ('lespe',),
'lespa': ('lespe',),
'lespet': ('lespe',),
'lespa': ('lespe',),
'lespet': ('lespe',),
'lesp': ('lespe',),
'less': ('less',),
'lesse': ('lesse',),
'lesser': ('lesse',),
'lesses': ('lesse',),
'lessa': ('lesse',),
'lesset': ('lesse',),
'lesste': ('lesse',),
'lessa': ('lesse',),
'lesset': ('lesse',),
'lesst': ('lesse',),
'less': ('lesse',),
'lete': ('lete',),
'leter': ('lete',),
'letes': ('lete',),
'lette': ('lete',),
'lett': ('lete',),
'let': ('lete',),
'letne': ('letne',),
'letner': ('letne',),
'letnes': ('letne',),
'letna': ('letne',),
'letnet': ('letne',),
'letna': ('letne',),
'letnet': ('letne',),
'letn': ('letne',),
'letne': ('letne',),
'letn': ('letne',),
'letne': ('letne',),
'lette': ('lette',),
'letter': ('lette',),
'lettes': ('lette',),
'letta': ('lette',),
'lettet': ('lette',),
'letta': ('lette',),
'lettet': ('lette',),
'lett': ('lette',),
'leve': ('leve',),
'lever': ('leve',),
'leves': ('leve',),
'levde': ('leve',),
'levd': ('leve',),
'lev': ('leve',),
'levendegjøre': ('levendegjøre',),
'levendegjør': ('levendegjøre',),
'levendegjøres': ('levendegjøre',),
'levendegjorde': ('levendegjøre',),
'levendegjort': ('levendegjøre',),
'levendegjør': ('levendegjøre',),
'levere': ('levere',),
'leverer': ('levere',),
'leveres': ('levere',),
'leverte': ('levere',),
'levert': ('levere',),
'lever': ('levere',),
'levne': ('levne',),
'levner': ('levne',),
'levnes': ('levne',),
'levna': ('levne',),
'levnet': ('levne',),
'levna': ('levne',),
'levnet': ('levne',),
'levn': ('levne',),
'levre': ('levre',),
'levrer': ('levre',),
'levres': ('levre',),
'levra': ('levre',),
'levret': ('levre',),
'levra': ('levre',),
'levret': ('levre',),
'levr': ('levre',),
'levre': ('levre',),
'levr': ('levre',),
'levre': ('levre',),
'li': ('li',),
'lir': ('li',),
'lis': ('li',),
'lidde': ('li',),
'lei': ('li',),
'led': ('li',),
'lidd': ('li',),
'li': ('li',),
'liberalisere': ('liberalisere',),
'liberaliserer': ('liberalisere',),
'liberaliseres': ('liberalisere',),
'liberaliserte': ('liberalisere',),
'liberalisert': ('liberalisere',),
'liberaliser': ('liberalisere',),
'lide': ('lide',),
'lider': ('lide',),
'lides': ('lide',),
'led': ('lide',),
'lei': ('lide',),
'led': ('lide',),
'lidt': ('lide',),
'lidd': ('lide',),
'lid': ('lide',),
'ligge': ('ligge',),
'ligger': ('ligge',),
'ligges': ('ligge',),
'lå': ('ligge',),
'ligget': ('ligge',),
'ligg': ('ligge',),
'ligne': ('ligne',),
'ligner': ('ligne',),
'lignes': ('ligne',),
'ligna': ('ligne',),
'lignet': ('ligne',),
'ligna': ('ligne',),
'lignet': ('ligne',),
'lign': ('ligne',),
'lignifisere': ('lignifisere',),
'lignifiserer': ('lignifisere',),
'lignifiseres': ('lignifisere',),
'lignifiserte': ('lignifisere',),
'lignifisert': ('lignifisere',),
'lignifiser': ('lignifisere',),
'like': ('like',),
'liker': ('like',),
'likes': ('like',),
'likte': ('like',),
'likt': ('like',),
'lik': ('like',),
'like': ('like',),
'liker': ('like',),
'likes': ('like',),
'lika': ('like',),
'liket': ('like',),
'likte': ('like',),
'lika': ('like',),
'liket': ('like',),
'likt': ('like',),
'lik': ('like',),
'likerette': ('likerette',),
'likeretter': ('likerette',),
'likerettes': ('likerette',),
'likeretta': ('likerette',),
'likerettet': ('likerette',),
'likeretta': ('likerette',),
'likerettet': ('likerette',),
'likerett': ('likerette',),
'likestille': ('likestille',),
'likestiller': ('likestille',),
'likestilles': ('likestille',),
'likestilte': ('likestille',),
'likestilt': ('likestille',),
'likestill': ('likestille',),
'likne': ('likne',),
'likner': ('likne',),
'liknes': ('likne',),
'likna': ('likne',),
'liknet': ('likne',),
'likna': ('likne',),
'liknet': ('likne',),
'likn': ('likne',),
'likne': ('likne',),
'likn': ('likne',),
'likne': ('likne',),
'likvidere': ('likvidere',),
'likviderer': ('likvidere',),
'likvideres': ('likvidere',),
'likviderte': ('likvidere',),
'likvidert': ('likvidere',),
'likvider': ('likvidere',),
'lime': ('lime',),
'limer': ('lime',),
'limes': ('lime',),
'lima': ('lime',),
'limet': ('lime',),
'limte': ('lime',),
'lima': ('lime',),
'limet': ('lime',),
'limt': ('lime',),
'lim': ('lime',),
'linde': ('linde',),
'linder': ('linde',),
'lindes': ('linde',),
'linda': ('linde',),
'lindet': ('linde',),
'linda': ('linde',),
'lindet': ('linde',),
'lind': ('linde',),
'lindre': ('lindre',),
'lindrer': ('lindre',),
'lindres': ('lindre',),
'lindra': ('lindre',),
'lindret': ('lindre',),
'lindra': ('lindre',),
'lindret': ('lindre',),
'lindr': ('lindre',),
'lindre': ('lindre',),
'lindr': ('lindre',),
'lindre': ('lindre',),
'linjere': ('linjere',),
'linjerer': ('linjere',),
'linjeres': ('linjere',),
'linjerte': ('linjere',),
'linjert': ('linjere',),
'linjer': ('linjere',),
'linne': ('linne',),
'linner': ('linne',),
'linnes': ('linne',),
'linna': ('linne',),
'linnet': ('linne',),
'linna': ('linne',),
'linnet': ('linne',),
'linn': ('linne',),
'linnkoke': ('linnkoke',),
'linnkoker': ('linnkoke',),
'linnkokes': ('linnkoke',),
'linnkokte': ('linnkoke',),
'linnkokt': ('linnkoke',),
'linnkok': ('linnkoke',),
'linnsalte': ('linnsalte',),
'linnsalter': ('linnsalte',),
'linnsaltes': ('linnsalte',),
'linnsalta': ('linnsalte',),
'linnsaltet': ('linnsalte',),
'linnsalta': ('linnsalte',),
'linnsaltet': ('linnsalte',),
'linnsalt': ('linnsalte',),
'lire': ('lire',),
'lirer': ('lire',),
'lires': ('lire',),
'lira': ('lire',),
'liret': ('lire',),
'lirte': ('lire',),
'lira': ('lire',),
'liret': ('lire',),
'lirt': ('lire',),
'lir': ('lire',),
'lirke': ('lirke',),
'lirker': ('lirke',),
'lirkes': ('lirke',),
'lirka': ('lirke',),
'lirket': ('lirke',),
'lirka': ('lirke',),
'lirket': ('lirke',),
'lirk': ('lirke',),
'lisensiere': ('lisensiere',),
'lisensierer': ('lisensiere',),
'lisensieres': ('lisensiere',),
'lisensierte': ('lisensiere',),
'lisensiert': ('lisensiere',),
'lisensier': ('lisensiere',),
'lisitere': ('lisitere',),
'lisiterer': ('lisitere',),
'lisiteres': ('lisitere',),
'lisiterte': ('lisitere',),
'lisitert': ('lisitere',),
'lisiter': ('lisitere',),
'lisse': ('lisse',),
'lisser': ('lisse',),
'lisses': ('lisse',),
'lissa': ('lisse',),
'lisset': ('lisse',),
'lissa': ('lisse',),
'lisset': ('lisse',),
'liss': ('lisse',),
'liste': ('liste',),
'lister': ('liste',),
'listes': ('liste',),
'lista': ('liste',),
'listet': ('liste',),
'lista': ('liste',),
'listet': ('liste',),
'list': ('liste',),
'lite': ('lite',),
'liter': ('lite',),
'lites': ('lite',),
'leit': ('lite',),
'let': ('lite',),
'litt': ('lite',),
'lit': ('lite',),
'litografere': ('litografere',),
'litograferer': ('litografere',),
'litograferes': ('litografere',),
'litograferte': ('litografere',),
'litografert': ('litografere',),
'litografer': ('litografere',),
'livberge': ('livberge',),
'livberger': ('livberge',),
'livberges': ('livberge',),
'livberga': ('livberge',),
'livberget': ('livberge',),
'livberga': ('livberge',),
'livberget': ('livberge',),
'livberg': ('livberge',),
'live': ('live',),
'liver': ('live',),
'lives': ('live',),
'liva': ('live',),
'livet': ('live',),
'liva': ('live',),
'livet': ('live',),
'liv': ('live',),
'live': ('live',),
'liver': ('live',),
'lives': ('live',),
'livde': ('live',),
'livd': ('live',),
'liv': ('live',),
'livne': ('livne',),
'livner': ('livne',),
'livnes': ('livne',),
'livna': ('livne',),
'livnet': ('livne',),
'livna': ('livne',),
'livnet': ('livne',),
'livn': ('livne',),
'livne': ('livne',),
'livn': ('livne',),
'livne': ('livne',),
'livnære': ('livnære',),
'livnærer': ('livnære',),
'livnæres': ('livnære',),
'livnæret': ('livnære',),
'livnærte': ('livnære',),
'livnæret': ('livnære',),
'livnært': ('livnære',),
'livnær': ('livnære',),
'livsforsikre': ('livsforsikre',),
'livsforsikrer': ('livsforsikre',),
'livsforsikres': ('livsforsikre',),
'livsforsikra': ('livsforsikre',),
'livsforsikret': ('livsforsikre',),
'livsforsikra': ('livsforsikre',),
'livsforsikret': ('livsforsikre',),
'livsforsikr': ('livsforsikre',),
'livsforsikre': ('livsforsikre',),
'livsforsikr': ('livsforsikre',),
'livsforsikre': ('livsforsikre',),
'ljome': ('ljome',),
'ljomer': ('ljome',),
'ljomes': ('ljome',),
'ljoma': ('ljome',),
'ljomet': ('ljome',),
'ljoma': ('ljome',),
'ljomet': ('ljome',),
'ljom': ('ljome',),
'ljuge': ('ljuge',),
'ljuger': ('ljuge',),
'ljuges': ('ljuge',),
'løy': ('ljuge',),
'løyet': ('ljuge',),
'ljug': ('ljuge',),
'lobbe': ('lobbe',),
'lobber': ('lobbe',),
'lobbes': ('lobbe',),
'lobba': ('lobbe',),
'lobbet': ('lobbe',),
'lobba': ('lobbe',),
'lobbet': ('lobbe',),
'lobb': ('lobbe',),
'lodde': ('lodde',),
'lodder': ('lodde',),
'loddes': ('lodde',),
'lodda': ('lodde',),
'loddet': ('lodde',),
'lodda': ('lodde',),
'loddet': ('lodde',),
'lodd': ('lodde',),
'loe': ('loe',),
'loer': ('loe',),
'loes': ('loe',),
'loa': ('loe',),
'loet': ('loe',),
'loa': ('loe',),
'loet': ('loe',),
'lo': ('loe',),
'loffe': ('loffe',),
'loffer': ('loffe',),
'loffes': ('loffe',),
'loffa': ('loffe',),
'loffet': ('loffe',),
'loffa': ('loffe',),
'loffet': ('loffe',),
'loff': ('loffe',),
'loge': ('loge',),
'loger': ('loge',),
'loges': ('loge',),
'loga': ('loge',),
'loget': ('loge',),
'loga': ('loge',),
'loget': ('loge',),
'log': ('loge',),
'logge': ('logge',),
'logger': ('logge',),
'logges': ('logge',),
'logga': ('logge',),
'logget': ('logge',),
'logga': ('logge',),
'logget': ('logge',),
'logg': ('logge',),
'logre': ('logre',),
'logrer': ('logre',),
'logres': ('logre',),
'logra': ('logre',),
'logret': ('logre',),
'logra': ('logre',),
'logret': ('logre',),
'logr': ('logre',),
'logre': ('logre',),
'logr': ('logre',),
'logre': ('logre',),
'lokalbedøve': ('lokalbedøve',),
'lokalbedøver': ('lokalbedøve',),
'lokalbedøves': ('lokalbedøve',),
'lokalbedøva': ('lokalbedøve',),
'lokalbedøvet': ('lokalbedøve',),
'lokalbedøvde': ('lokalbedøve',),
'lokalbedøva': ('lokalbedøve',),
'lokalbedøvet': ('lokalbedøve',),
'lokalbedøvd': ('lokalbedøve',),
'lokalbedøv': ('lokalbedøve',),
'lokalisere': ('lokalisere',),
'lokaliserer': ('lokalisere',),
'lokaliseres': ('lokalisere',),
'lokaliserte': ('lokalisere',),
'lokalisert': ('lokalisere',),
'lokaliser': ('lokalisere',),
'lokke': ('lokke',),
'lokker': ('lokke',),
'lokkes': ('lokke',),
'lokka': ('lokke',),
'lokket': ('lokke',),
'lokka': ('lokke',),
'lokket': ('lokke',),
'lokk': ('lokke',),
'lombardere': ('lombardere',),
'lombarderer': ('lombardere',),
'lombarderes': ('lombardere',),
'lombarderte': ('lombardere',),
'lombardert': ('lombardere',),
'lombarder': ('lombardere',),
'longere': ('longere',),
'longerer': ('longere',),
'longeres': ('longere',),
'longerte': ('longere',),
'longert': ('longere',),
'longer': ('longere',),
'loope': ('loope',),
'looper': ('loope',),
'loopes': ('loope',),
'loopa': ('loope',),
'loopet': ('loope',),
'loopa': ('loope',),
'loopet': ('loope',),
'loop': ('loope',),
'loppe': ('loppe',),
'lopper': ('loppe',),
'loppes': ('loppe',),
'loppa': ('loppe',),
'loppet': ('loppe',),
'loppa': ('loppe',),
'loppet': ('loppe',),
'lopp': ('loppe',),
'lorgnettere': ('lorgnettere',),
'lorgnetterer': ('lorgnettere',),
'lorgnetteres': ('lorgnettere',),
'lorgnetterte': ('lorgnettere',),
'lorgnettert': ('lorgnettere',),
'lorgnetter': ('lorgnettere',),
'lose': ('lose',),
'loser': ('lose',),
'loses': ('lose',),
'losa': ('lose',),
'loset': ('lose',),
'loste': ('lose',),
'losa': ('lose',),
'loset': ('lose',),
'lost': ('lose',),
'los': ('lose',),
'losjere': ('losjere',),
'losjerer': ('losjere',),
'losjeres': ('losjere',),
'losjerte': ('losjere',),
'losjert': ('losjere',),
'losjer': ('losjere',),
'losse': ('losse',),
'losser': ('losse',),
'losses': ('losse',),
'lossa': ('losse',),
'losset': ('losse',),
'lossa': ('losse',),
'losset': ('losse',),
'loss': ('losse',),
'lovfeste': ('lovfeste',),
'lovfester': ('lovfeste',),
'lovfestes': ('lovfeste',),
'lovfesta': ('lovfeste',),
'lovfestet': ('lovfeste',),
'lovfesta': ('lovfeste',),
'lovfestet': ('lovfeste',),
'lovfest': ('lovfeste',),
'lovheimle': ('lovheimle',),
'lovheimler': ('lovheimle',),
'lovheimles': ('lovheimle',),
'lovheimla': ('lovheimle',),
'lovheimlet': ('lovheimle',),
'lovheimla': ('lovheimle',),
'lovheimlet': ('lovheimle',),
'lovheiml': ('lovheimle',),
'lovheimle': ('lovheimle',),
'lovheiml': ('lovheimle',),
'lovheimle': ('lovheimle',),
'lovhjemle': ('lovhjemle',),
'lovhjemler': ('lovhjemle',),
'lovhjemles': ('lovhjemle',),
'lovhjemla': ('lovhjemle',),
'lovhjemlet': ('lovhjemle',),
'lovhjemla': ('lovhjemle',),
'lovhjemlet': ('lovhjemle',),
'lovhjeml': ('lovhjemle',),
'lovhjemle': ('lovhjemle',),
'lovhjeml': ('lovhjemle',),
'lovhjemle': ('lovhjemle',),
'lovprise': ('lovprise',),
'lovpriser': ('lovprise',),
'lovprises': ('lovprise',),
'lovpriste': ('lovprise',),
'lovprist': ('lovprise',),
'lovpris': ('lovprise',),
'lovsynge': ('lovsynge',),
'lovsynger': ('lovsynge',),
'lovsynges': ('lovsynge',),
'lovsang': ('lovsynge',),
'lovsunget': ('lovsynge',),
'lovsyng': ('lovsynge',),
'lue': ('lue',),
'luer': ('lue',),
'lues': ('lue',),
'lua': ('lue',),
'luet': ('lue',),
'lua': ('lue',),
'luet': ('lue',),
'lu': ('lue',),
'lufte': ('lufte',),
'lufter': ('lufte',),
'luftes': ('lufte',),
'lufta': ('lufte',),
'luftet': ('lufte',),
'lufta': ('lufte',),
'luftet': ('lufte',),
'luft': ('lufte',),
'lufttørke': ('lufttørke',),
'lufttørker': ('lufttørke',),
'lufttørkes': ('lufttørke',),
'lufttørka': ('lufttørke',),
'lufttørket': ('lufttørke',),
'lufttørka': ('lufttørke',),
'lufttørket': ('lufttørke',),
'lufttørk': ('lufttørke',),
'lugge': ('lugge',),
'lugger': ('lugge',),
'lugges': ('lugge',),
'lugga': ('lugge',),
'lugget': ('lugge',),
'lugga': ('lugge',),
'lugget': ('lugge',),
'lugg': ('lugge',),
'lugne': ('lugne',),
'lugner': ('lugne',),
'lugnes': ('lugne',),
'lugna': ('lugne',),
'lugnet': ('lugne',),
'lugna': ('lugne',),
'lugnet': ('lugne',),
'lugn': ('lugne',),
'luke': ('luke',),
'luker': ('luke',),
'lukes': ('luke',),
'luka': ('luke',),
'luket': ('luke',),
'lukte': ('luke',),
'luka': ('luke',),
'luket': ('luke',),
'lukt': ('luke',),
'luk': ('luke',),
'lukke': ('lukke',),
'lukker': ('lukke',),
'lukkes': ('lukke',),
'lukka': ('lukke',),
'lukket': ('lukke',),
'lukka': ('lukke',),
'lukket': ('lukke',),
'lukk': ('lukke',),
'lukrere': ('lukrere',),
'lukrerer': ('lukrere',),
'lukreres': ('lukrere',),
'lukrerte': ('lukrere',),
'lukrert': ('lukrere',),
'lukrer': ('lukrere',),
'luksere': ('luksere',),
'lukserer': ('luksere',),
'lukseres': ('luksere',),
'lukserte': ('luksere',),
'luksert': ('luksere',),
'lukser': ('luksere',),
'lukte': ('lukte',),
'lukter': ('lukte',),
'luktes': ('lukte',),
'lukta': ('lukte',),
'luktet': ('lukte',),
'lukta': ('lukte',),
'luktet': ('lukte',),
'lukt': ('lukte',),
'lulle': ('lulle',),
'luller': ('lulle',),
'lulles': ('lulle',),
'lulla': ('lulle',),
'lullet': ('lulle',),
'lulla': ('lulle',),
'lullet': ('lulle',),
'lull': ('lulle',),
'lumpe': ('lumpe',),
'lumper': ('lumpe',),
'lumpes': ('lumpe',),
'lumpa': ('lumpe',),
'lumpet': ('lumpe',),
'lumpa': ('lumpe',),
'lumpet': ('lumpe',),
'lump': ('lumpe',),
'lune': ('lune',),
'luner': ('lune',),
'lunes': ('lune',),
'luna': ('lune',),
'lunet': ('lune',),
'lunte': ('lune',),
'luna': ('lune',),
'lunet': ('lune',),
'lunt': ('lune',),
'lun': ('lune',),
'lunke': ('lunke',),
'lunker': ('lunke',),
'lunkes': ('lunke',),
'lunka': ('lunke',),
'lunket': ('lunke',),
'lunka': ('lunke',),
'lunket': ('lunke',),
'lunk': ('lunke',),
'lunne': ('lunne',),
'lunner': ('lunne',),
'lunnes': ('lunne',),
'lunna': ('lunne',),
'lunnet': ('lunne',),
'lunna': ('lunne',),
'lunnet': ('lunne',),
'lunn': ('lunne',),
'lunsje': ('lunsje',),
'lunsjer': ('lunsje',),
'lunsjes': ('lunsje',),
'lunsja': ('lunsje',),
'lunsjet': ('lunsje',),
'lunsja': ('lunsje',),
'lunsjet': ('lunsje',),
'lunsj': ('lunsje',),
'lunte': ('lunte',),
'lunter': ('lunte',),
'luntes': ('lunte',),
'lunta': ('lunte',),
'luntet': ('lunte',),
'lunta': ('lunte',),
'luntet': ('lunte',),
'lunt': ('lunte',),
'lure': ('lure',),
'lurer': ('lure',),
'lures': ('lure',),
'lurte': ('lure',),
'lurt': ('lure',),
'lur': ('lure',),
'lure': ('lure',),
'lurer': ('lure',),
'lures': ('lure',),
'lura': ('lure',),
'luret': ('lure',),
'lurte': ('lure',),
'lura': ('lure',),
'luret': ('lure',),
'lurt': ('lure',),
'lur': ('lure',),
'lurve': ('lurve',),
'lurver': ('lurve',),
'lurves': ('lurve',),
'lurva': ('lurve',),
'lurvet': ('lurve',),
'lurva': ('lurve',),
'lurvet': ('lurve',),
'lurv': ('lurve',),
'luse': ('luse',),
'luser': ('luse',),
'luses': ('luse',),
'lusa': ('luse',),
'luset': ('luse',),
'luste': ('luse',),
'lusa': ('luse',),
'luset': ('luse',),
'lust': ('luse',),
'lus': ('luse',),
'luske': ('luske',),
'lusker': ('luske',),
'luskes': ('luske',),
'luska': ('luske',),
'lusket': ('luske',),
'luska': ('luske',),
'lusket': ('luske',),
'lusk': ('luske',),
'lute': ('lute',),
'luter': ('lute',),
'lutes': ('lute',),
'luta': ('lute',),
'lutet': ('lute',),
'luta': ('lute',),
'lutet': ('lute',),
'lut': ('lute',),
'lute': ('lute',),
'luter': ('lute',),
'lutes': ('lute',),
'luta': ('lute',),
'lutet': ('lute',),
'lutte': ('lute',),
'luta': ('lute',),
'lutet': ('lute',),
'lutt': ('lute',),
'lut': ('lute',),
'lutre': ('lutre',),
'lutrer': ('lutre',),
'lutres': ('lutre',),
'lutra': ('lutre',),
'lutret': ('lutre',),
'lutra': ('lutre',),
'lutret': ('lutre',),
'lutr': ('lutre',),
'lutre': ('lutre',),
'lutr': ('lutre',),
'lutre': ('lutre',),
'lyde': ('lyde',),
'lyder': ('lyde',),
'lydes': ('lyde',),
'lydde': ('lyde',),
'lød': ('lyde',),
'lydd': ('lyde',),
'lydt': ('lyde',),
'lyd': ('lyde',),
'lye': ('lye',),
'lyer': ('lye',),
'lyes': ('lye',),
'lydde': ('lye',),
'lydd': ('lye',),
'ly': ('lye',),
'lye': ('lye',),
'lyer': ('lye',),
'lyes': ('lye',),
'lya': ('lye',),
'lyet': ('lye',),
'lydde': ('lye',),
'lya': ('lye',),
'lyet': ('lye',),
'lydd': ('lye',),
'ly': ('lye',),
'lyge': ('lyge',),
'lyger': ('lyge',),
'lyges': ('lyge',),
'løy': ('lyge',),
'løyet': ('lyge',),
'lyg': ('lyge',),
'lykkes': ('lykkes',),
'lyktes': ('lykkes',),
'lykkes': ('lykkes',),
'lyktes': ('lykkes',),
'lykkes': ('lykkes',),
'lykkønske': ('lykkønske',),
'lykkønsker': ('lykkønske',),
'lykkønskes': ('lykkønske',),
'lykkønska': ('lykkønske',),
'lykkønsket': ('lykkønske',),
'lykkønskte': ('lykkønske',),
'lykkønska': ('lykkønske',),
'lykkønsket': ('lykkønske',),
'lykkønskt': ('lykkønske',),
'lykkønsk': ('lykkønske',),
'lyne': ('lyne',),
'lyner': ('lyne',),
'lynes': ('lyne',),
'lynte': ('lyne',),
'lynt': ('lyne',),
'lyn': ('lyne',),
'lynsje': ('lynsje',),
'lynsjer': ('lynsje',),
'lynsjes': ('lynsje',),
'lynsja': ('lynsje',),
'lynsjet': ('lynsje',),
'lynsja': ('lynsje',),
'lynsjet': ('lynsje',),
'lynsj': ('lynsje',),
'lyse': ('lyse',),
'lyser': ('lyse',),
'lyses': ('lyse',),
'lyste': ('lyse',),
'lyst': ('lyse',),
'lys': ('lyse',),
'lyske': ('lyske',),
'lysker': ('lyske',),
'lyskes': ('lyske',),
'lyska': ('lyske',),
'lysket': ('lyske',),
'lyska': ('lyske',),
'lysket': ('lyske',),
'lysk': ('lyske',),
'lysne': ('lysne',),
'lysner': ('lysne',),
'lysnes': ('lysne',),
'lysna': ('lysne',),
'lysnet': ('lysne',),
'lysna': ('lysne',),
'lysnet': ('lysne',),
'lysn': ('lysne',),
'lysne': ('lysne',),
'lysn': ('lysne',),
'lysne': ('lysne',),
'lyste': ('lyste',),
'lyster': ('lyste',),
'lystes': ('lyste',),
'lysta': ('lyste',),
'lystet': ('lyste',),
'lysta': ('lyste',),
'lystet': ('lyste',),
'lyst': ('lyste',),
'lystre': ('lystre',),
'lystrer': ('lystre',),
'lystres': ('lystre',),
'lystra': ('lystre',),
'lystret': ('lystre',),
'lystra': ('lystre',),
'lystret': ('lystre',),
'lystr': ('lystre',),
'lystre': ('lystre',),
'lystr': ('lystre',),
'lystre': ('lystre',),
'lytte': ('lytte',),
'lytter': ('lytte',),
'lyttes': ('lytte',),
'lytta': ('lytte',),
'lyttet': ('lytte',),
'lytta': ('lytte',),
'lyttet': ('lytte',),
'lytt': ('lytte',),
'lyve': ('lyve',),
'lyver': ('lyve',),
'lyves': ('lyve',),
'løy': ('lyve',),
'løyet': ('lyve',),
'lyv': ('lyve',),
'låne': ('låne',),
'låner': ('låne',),
'lånes': ('låne',),
'lånte': ('låne',),
'lånt': ('låne',),
'lån': ('låne',),
'lånta': ('lånta',),
'låntar': ('lånta',),
'låntas': ('lånta',),
'låntok': ('lånta',),
'låntatt': ('lånta',),
'lånta': ('lånta',),
'låre': ('låre',),
'lårer': ('låre',),
'låres': ('låre',),
'låra': ('låre',),
'låret': ('låre',),
'lårte': ('låre',),
'låra': ('låre',),
'låret': ('låre',),
'lårt': ('låre',),
'lår': ('låre',),
'låse': ('låse',),
'låser': ('låse',),
'låses': ('låse',),
'låste': ('låse',),
'låst': ('låse',),
'lås': ('låse',),
'låte': ('låte',),
'låter': ('låte',),
'låtes': ('låte',),
'låt': ('låte',),
'lått': ('låte',),
'låt': ('låte',),
'lægre': ('lægre',),
'lægrer': ('lægre',),
'lægres': ('lægre',),
'lægra': ('lægre',),
'lægret': ('lægre',),
'lægra': ('lægre',),
'lægret': ('lægre',),
'lægr': ('lægre',),
'lægre': ('lægre',),
'lægr': ('lægre',),
'lægre': ('lægre',),
'lære': ('lære',),
'lærer': ('lære',),
'læres': ('lære',),
'lærte': ('lære',),
'lært': ('lære',),
'lær': ('lære',),
'lø': ('lø',),
'lør': ('lø',),
'løs': ('lø',),
'lødde': ('lø',),
'lødd': ('lø',),
'lø': ('lø',),
'løfte': ('løfte',),
'løfter': ('løfte',),
'løftes': ('løfte',),
'løfta': ('løfte',),
'løftet': ('løfte',),
'løfta': ('løfte',),
'løftet': ('løfte',),
'løft': ('løfte',),
'lønne': ('lønne',),
'lønner': ('lønne',),
'lønnes': ('lønne',),
'lønna': ('lønne',),
'lønnet': ('lønne',),
'lønte': ('lønne',),
'lønna': ('lønne',),
'lønnet': ('lønne',),
'lønt': ('lønne',),
'lønn': ('lønne',),
'løpe': ('løpe',),
'løper': ('løpe',),
'løpes': ('løpe',),
'løp': ('løpe',),
'løpt': ('løpe',),
'løpet': ('løpe',),
'løp': ('løpe',),
'løse': ('løse',),
'løser': ('løse',),
'løses': ('løse',),
'løste': ('løse',),
'løst': ('løse',),
'løs': ('løse',),
'løsgi': ('løsgi',),
'løsgir': ('løsgi',),
'løsgis': ('løsgi',),
'løsgav': ('løsgi',),
'løsga': ('løsgi',),
'løsgitt': ('løsgi',),
'løsgi': ('løsgi',),
'løsgjøre': ('løsgjøre',),
'løsgjør': ('løsgjøre',),
'løsgjøres': ('løsgjøre',),
'løsgjorde': ('løsgjøre',),
'løsgjort': ('løsgjøre',),
'løsgjør': ('løsgjøre',),
'løsne': ('løsne',),
'løsner': ('løsne',),
'løsnes': ('løsne',),
'løsna': ('løsne',),
'løsnet': ('løsne',),
'løsna': ('løsne',),
'løsnet': ('løsne',),
'løsn': ('løsne',),
'løye': ('løye',),
'løyer': ('løye',),
'løyes': ('løye',),
'løya': ('løye',),
'løyet': ('løye',),
'løya': ('løye',),
'løyet': ('løye',),
'løy': ('løye',),
'løyne': ('løyne',),
'løyner': ('løyne',),
'løynes': ('løyne',),
'løynte': ('løyne',),
'løynt': ('løyne',),
'løyn': ('løyne',),
'løype': ('løype',),
'løyper': ('løype',),
'løypes': ('løype',),
'løypte': ('løype',),
'løypt': ('løype',),
'løyp': ('løype',),
'løyse': ('løyse',),
'løyser': ('løyse',),
'løyses': ('løyse',),
'løyste': ('løyse',),
'løyst': ('løyse',),
'løys': ('løyse',),
'løyve': ('løyve',),
'løyver': ('løyve',),
'løyves': ('løyve',),
'løyvde': ('løyve',),
'løyvd': ('løyve',),
'løyv': ('løyve',),
'magasinere': ('magasinere',),
'magasinerer': ('magasinere',),
'magasineres': ('magasinere',),
'magasinerte': ('magasinere',),
'magasinert': ('magasinere',),
'magasiner': ('magasinere',),
'mage': ('mage',),
'mager': ('mage',),
'mages': ('mage',),
'maga': ('mage',),
'maget': ('mage',),
'maga': ('mage',),
'maget': ('mage',),
'mag': ('mage',),
'magnetisere': ('magnetisere',),
'magnetiserer': ('magnetisere',),
'magnetiseres': ('magnetisere',),
'magnetiserte': ('magnetisere',),
'magnetisert': ('magnetisere',),
'magnetiser': ('magnetisere',),
'magre': ('magre',),
'magrer': ('magre',),
'magres': ('magre',),
'magra': ('magre',),
'magret': ('magre',),
'magra': ('magre',),
'magret': ('magre',),
'magr': ('magre',),
'magre': ('magre',),
'magr': ('magre',),
'magre': ('magre',),
'maie': ('maie',),
'maier': ('maie',),
'maies': ('maie',),
'maia': ('maie',),
'maiet': ('maie',),
'maia': ('maie',),
'maiet': ('maie',),
'mai': ('maie',),
'makadamisere': ('makadamisere',),
'makadamiserer': ('makadamisere',),
'makadamiseres': ('makadamisere',),
'makadamiserte': ('makadamisere',),
'makadamisert': ('makadamisere',),
'makadamiser': ('makadamisere',),
'make': ('make',),
'maker': ('make',),
'makes': ('make',),
'maka': ('make',),
'maket': ('make',),
'makte': ('make',),
'maka': ('make',),
'maket': ('make',),
'makt': ('make',),
'mak': ('make',),
'makeskifte': ('makeskifte',),
'makeskifter': ('makeskifte',),
'makeskiftes': ('makeskifte',),
'makeskifta': ('makeskifte',),
'makeskiftet': ('makeskifte',),
'makeskifta': ('makeskifte',),
'makeskiftet': ('makeskifte',),
'makeskift': ('makeskifte',),
'maksimalisere': ('maksimalisere',),
'maksimaliserer': ('maksimalisere',),
'maksimaliseres': ('maksimalisere',),
'maksimaliserte': ('maksimalisere',),
'maksimalisert': ('maksimalisere',),
'maksimaliser': ('maksimalisere',),
'maksimere': ('maksimere',),
'maksimerer': ('maksimere',),
'maksimeres': ('maksimere',),
'maksimerte': ('maksimere',),
'maksimert': ('maksimere',),
'maksimer': ('maksimere',),
'maksle': ('maksle',),
'maksler': ('maksle',),
'maksles': ('maksle',),
'maksla': ('maksle',),
'makslet': ('maksle',),
'maksla': ('maksle',),
'makslet': ('maksle',),
'maksl': ('maksle',),
'maksle': ('maksle',),
'maksl': ('maksle',),
'maksle': ('maksle',),
'makte': ('makte',),
'makter': ('makte',),
'maktes': ('makte',),
'makta': ('makte',),
'maktet': ('makte',),
'makta': ('makte',),
'maktet': ('makte',),
'makt': ('makte',),
'maktstjele': ('maktstjele',),
'maktstjeler': ('maktstjele',),
'maktstjeles': ('maktstjele',),
'maktstjal': ('maktstjele',),
'maktstjålet': ('maktstjele',),
'maktstjel': ('maktstjele',),
'makulere': ('makulere',),
'makulerer': ('makulere',),
'makuleres': ('makulere',),
'makulerte': ('makulere',),
'makulert': ('makulere',),
'makuler': ('makulere',),
'malte': ('malte',),
'malter': ('malte',),
'maltes': ('malte',),
'malta': ('malte',),
'maltet': ('malte',),
'malta': ('malte',),
'maltet': ('malte',),
'malt': ('malte',),
'maltraktere': ('maltraktere',),
'maltrakterer': ('maltraktere',),
'maltrakteres': ('maltraktere',),
'maltrakterte': ('maltraktere',),
'maltraktert': ('maltraktere',),
'maltrakter': ('maltraktere',),
'mane': ('mane',),
'maner': ('mane',),
'manes': ('mane',),
'mana': ('mane',),
'manet': ('mane',),
'mante': ('mane',),
'mana': ('mane',),
'manet': ('mane',),
'mant': ('mane',),
'man': ('mane',),
'mangedoble': ('mangedoble',),
'mangedobler': ('mangedoble',),
'mangedobles': ('mangedoble',),
'mangedobla': ('mangedoble',),
'mangedoblet': ('mangedoble',),
'mangedobla': ('mangedoble',),
'mangedoblet': ('mangedoble',),
'mangedobl': ('mangedoble',),
'mangedoble': ('mangedoble',),
'mangedobl': ('mangedoble',),
'mangedoble': ('mangedoble',),
'mangfoldiggjøre': ('mangfoldiggjøre',),
'mangfoldiggjør': ('mangfoldiggjøre',),
'mangfoldiggjøres': ('mangfoldiggjøre',),
'mangfoldiggjorde': ('mangfoldiggjøre',),
'mangfoldiggjort': ('mangfoldiggjøre',),
'mangfoldiggjør': ('mangfoldiggjøre',),
'mangle': ('mangle',),
'mangler': ('mangle',),
'mangles': ('mangle',),
'mangla': ('mangle',),
'manglet': ('mangle',),
'mangla': ('mangle',),
'manglet': ('mangle',),
'mangl': ('mangle',),
'mangle': ('mangle',),
'mangl': ('mangle',),
'mangle': ('mangle',),
'manifestere': ('manifestere',),
'manifesterer': ('manifestere',),
'manifesteres': ('manifestere',),
'manifesterte': ('manifestere',),
'manifestert': ('manifestere',),
'manifester': ('manifestere',),
'manikyrere': ('manikyrere',),
'manikyrerer': ('manikyrere',),
'manikyreres': ('manikyrere',),
'manikyrerte': ('manikyrere',),
'manikyrert': ('manikyrere',),
'manikyrer': ('manikyrere',),
'manipulere': ('manipulere',),
'manipulerer': ('manipulere',),
'manipuleres': ('manipulere',),
'manipulerte': ('manipulere',),
'manipulert': ('manipulere',),
'manipuler': ('manipulere',),
'mankere': ('mankere',),
'mankerer': ('mankere',),
'mankeres': ('mankere',),
'mankerte': ('mankere',),
'mankert': ('mankere',),
'manker': ('mankere',),
'manne': ('manne',),
'manner': ('manne',),
'mannes': ('manne',),
'manna': ('manne',),
'mannet': ('manne',),
'manna': ('manne',),
'mannet': ('manne',),
'mann': ('manne',),
'mannsoppdekke': ('mannsoppdekke',),
'mannsoppdekker': ('mannsoppdekke',),
'mannsoppdekkes': ('mannsoppdekke',),
'mannsoppdekka': ('mannsoppdekke',),
'mannsoppdekket': ('mannsoppdekke',),
'mannsoppdekte': ('mannsoppdekke',),
'mannsoppdekka': ('mannsoppdekke',),
'mannsoppdekket': ('mannsoppdekke',),
'mannsoppdekt': ('mannsoppdekke',),
'mannsoppdekk': ('mannsoppdekke',),
'manudusere': ('manudusere',),
'manuduserer': ('manudusere',),
'manuduseres': ('manudusere',),
'manuduserte': ('manudusere',),
'manudusert': ('manudusere',),
'manuduser': ('manudusere',),
'manøvrere': ('manøvrere',),
'manøvrerer': ('manøvrere',),
'manøvreres': ('manøvrere',),
'manøvrerte': ('manøvrere',),
'manøvrert': ('manøvrere',),
'manøvrer': ('manøvrere',),
'margstjele': ('margstjele',),
'margstjeler': ('margstjele',),
'margstjeles': ('margstjele',),
'margstjal': ('margstjele',),
'margstjålet': ('margstjele',),
'margstjel': ('margstjele',),
'marinere': ('marinere',),
'marinerer': ('marinere',),
'marineres': ('marinere',),
'marinerte': ('marinere',),
'marinert': ('marinere',),
'mariner': ('marinere',),
'markedsføre': ('markedsføre',),
'markedsfører': ('markedsføre',),
'markedsføres': ('markedsføre',),
'markedsførte': ('markedsføre',),
'markedsført': ('markedsføre',),
'markedsfør': ('markedsføre',),
'markere': ('markere',),
'markerer': ('markere',),
'markeres': ('markere',),
'markerte': ('markere',),
'markert': ('markere',),
'marker': ('markere',),
'marme': ('marme',),
'marmer': ('marme',),
'marmes': ('marme',),
'marma': ('marme',),
'marmet': ('marme',),
'marma': ('marme',),
'marmet': ('marme',),
'marm': ('marme',),
'marmorere': ('marmorere',),
'marmorerer': ('marmorere',),
'marmoreres': ('marmorere',),
'marmorerte': ('marmorere',),
'marmorert': ('marmorere',),
'marmorer': ('marmorere',),
'marsjere': ('marsjere',),
'marsjerer': ('marsjere',),
'marsjeres': ('marsjere',),
'marsjerte': ('marsjere',),
'marsjert': ('marsjere',),
'marsjer': ('marsjere',),
'martre': ('martre',),
'martrer': ('martre',),
'martres': ('martre',),
'martra': ('martre',),
'martret': ('martre',),
'martra': ('martre',),
'martret': ('martre',),
'martr': ('martre',),
'martre': ('martre',),
'martr': ('martre',),
'martre': ('martre',),
'maske': ('maske',),
'masker': ('maske',),
'maskes': ('maske',),
'maska': ('maske',),
'masket': ('maske',),
'maska': ('maske',),
'masket': ('maske',),
'mask': ('maske',),
'maskere': ('maskere',),
'maskerer': ('maskere',),
'maskeres': ('maskere',),
'maskerte': ('maskere',),
'maskert': ('maskere',),
'masker': ('maskere',),
'maskinere': ('maskinere',),
'maskinerer': ('maskinere',),
'maskineres': ('maskinere',),
'maskinerte': ('maskinere',),
'maskinert': ('maskinere',),
'maskiner': ('maskinere',),
'maskinklippe': ('maskinklippe',),
'maskinklipper': ('maskinklippe',),
'maskinklippes': ('maskinklippe',),
'maskinklippa': ('maskinklippe',),
'maskinklippet': ('maskinklippe',),
'maskinklipte': ('maskinklippe',),
'maskinklippa': ('maskinklippe',),
'maskinklippet': ('maskinklippe',),
'maskinklipt': ('maskinklippe',),
'maskinklipp': ('maskinklippe',),
'maskinskrive': ('maskinskrive',),
'maskinskriver': ('maskinskrive',),
'maskinskrives': ('maskinskrive',),
'maskinskrev': ('maskinskrive',),
'maskinskreiv': ('maskinskrive',),
'maskinskrev': ('maskinskrive',),
'maskinskreiv': ('maskinskrive',),
'maskinskrevet': ('maskinskrive',),
'maskinskriv': ('maskinskrive',),
'maskinstrikke': ('maskinstrikke',),
'maskinstrikker': ('maskinstrikke',),
'maskinstrikkes': ('maskinstrikke',),
'maskinstrikka': ('maskinstrikke',),
'maskinstrikket': ('maskinstrikke',),
'maskinstrikka': ('maskinstrikke',),
'maskinstrikket': ('maskinstrikke',),
'maskinstrikk': ('maskinstrikke',),
'maskulinisere': ('maskulinisere',),
'maskuliniserer': ('maskulinisere',),
'maskuliniseres': ('maskulinisere',),
'maskuliniserte': ('maskulinisere',),
'maskulinisert': ('maskulinisere',),
'maskuliniser': ('maskulinisere',),
'massakrere': ('massakrere',),
'massakrerer': ('massakrere',),
'massakreres': ('massakrere',),
'massakrerte': ('massakrere',),
'massakrert': ('massakrere',),
'massakrer': ('massakrere',),
'masseprodusere': ('masseprodusere',),
'masseproduserer': ('masseprodusere',),
'masseproduseres': ('masseprodusere',),
'masseproduserte': ('masseprodusere',),
'masseprodusert': ('masseprodusere',),
'masseproduser': ('masseprodusere',),
'massere': ('massere',),
'masserer': ('massere',),
'masseres': ('massere',),
'masserte': ('massere',),
'massert': ('massere',),
'masser': ('massere',),
'maste': ('maste',),
'master': ('maste',),
'mastes': ('maste',),
'masta': ('maste',),
'mastet': ('maste',),
'masta': ('maste',),
'mastet': ('maste',),
'mast': ('maste',),
'masturbere': ('masturbere',),
'masturberer': ('masturbere',),
'masturberes': ('masturbere',),
'masturberte': ('masturbere',),
'masturbert': ('masturbere',),
'masturber': ('masturbere',),
'matberge': ('matberge',),
'matberger': ('matberge',),
'matberges': ('matberge',),
'matberga': ('matberge',),
'matberget': ('matberge',),
'matberga': ('matberge',),
'matberget': ('matberge',),
'matberg': ('matberge',),
'matche': ('matche',),
'matcher': ('matche',),
'matches': ('matche',),
'matcha': ('matche',),
'matchet': ('matche',),
'matcha': ('matche',),
'matchet': ('matche',),
'match': ('matche',),
'mate': ('mate',),
'mater': ('mate',),
'mates': ('mate',),
'mata': ('mate',),
'matet': ('mate',),
'mata': ('mate',),
'matet': ('mate',),
'mat': ('mate',),
'materialisere': ('materialisere',),
'materialiserer': ('materialisere',),
'materialiseres': ('materialisere',),
'materialiserte': ('materialisere',),
'materialisert': ('materialisere',),
'materialiser': ('materialisere',),
'matrikulere': ('matrikulere',),
'matrikulerer': ('matrikulere',),
'matrikuleres': ('matrikulere',),
'matrikulerte': ('matrikulere',),
'matrikulert': ('matrikulere',),
'matrikuler': ('matrikulere',),
'matte': ('matte',),
'matter': ('matte',),
'mattes': ('matte',),
'matta': ('matte',),
'mattet': ('matte',),
'matta': ('matte',),
'mattet': ('matte',),
'matt': ('matte',),
'mattere': ('mattere',),
'matterer': ('mattere',),
'matteres': ('mattere',),
'matterte': ('mattere',),
'mattert': ('mattere',),
'matter': ('mattere',),
'maule': ('maule',),
'mauler': ('maule',),
'maules': ('maule',),
'maula': ('maule',),
'maulet': ('maule',),
'maula': ('maule',),
'maulet': ('maule',),
'maul': ('maule',),
'maure': ('maure',),
'maurer': ('maure',),
'maures': ('maure',),
'maura': ('maure',),
'mauret': ('maure',),
'maura': ('maure',),
'mauret': ('maure',),
'maur': ('maure',),
'meddele': ('meddele',),
'meddeler': ('meddele',),
'meddeles': ('meddele',),
'meddelte': ('meddele',),
'meddelt': ('meddele',),
'meddel': ('meddele',),
'medføre': ('medføre',),
'medfører': ('medføre',),
'medføres': ('medføre',),
'medførte': ('medføre',),
'medført': ('medføre',),
'medfør': ('medføre',),
'medgi': ('medgi',),
'medgir': ('medgi',),
'medgis': ('medgi',),
'medgav': ('medgi',),
'medga': ('medgi',),
'medgitt': ('medgi',),
'medgi': ('medgi',),
'medisinere': ('medisinere',),
'medisinerer': ('medisinere',),
'medisineres': ('medisinere',),
'medisinerte': ('medisinere',),
'medisinert': ('medisinere',),
'medisiner': ('medisinere',),
'meditere': ('meditere',),
'mediterer': ('meditere',),
'mediteres': ('meditere',),
'mediterte': ('meditere',),
'meditert': ('meditere',),
'mediter': ('meditere',),
'medunderskrive': ('medunderskrive',),
'medunderskriver': ('medunderskrive',),
'medunderskrives': ('medunderskrive',),
'medunderskrev': ('medunderskrive',),
'medunderskreiv': ('medunderskrive',),
'medunderskrev': ('medunderskrive',),
'medunderskreiv': ('medunderskrive',),
'medunderskrevet': ('medunderskrive',),
'medunderskriv': ('medunderskrive',),
'medvirke': ('medvirke',),
'medvirker': ('medvirke',),
'medvirkes': ('medvirke',),
'medvirka': ('medvirke',),
'medvirket': ('medvirke',),
'medvirka': ('medvirke',),
'medvirket': ('medvirke',),
'medvirk': ('medvirke',),
'megle': ('megle',),
'megler': ('megle',),
'megles': ('megle',),
'megla': ('megle',),
'meglet': ('megle',),
'megla': ('megle',),
'meglet': ('megle',),
'megl': ('megle',),
'megle': ('megle',),
'megl': ('megle',),
'megle': ('megle',),
'meie': ('meie',),
'meier': ('meie',),
'meies': ('meie',),
'meia': ('meie',),
'meiet': ('meie',),
'meide': ('meie',),
'meia': ('meie',),
'meiet': ('meie',),
'meid': ('meie',),
'mei': ('meie',),
'meine': ('meine',),
'meiner': ('meine',),
'meines': ('meine',),
'meinte': ('meine',),
'meint': ('meine',),
'mein': ('meine',),
'meisle': ('meisle',),
'meisler': ('meisle',),
'meisles': ('meisle',),
'meisla': ('meisle',),
'meislet': ('meisle',),
'meisla': ('meisle',),
'meislet': ('meisle',),
'meisl': ('meisle',),
'meite': ('meite',),
'meiter': ('meite',),
'meites': ('meite',),
'meita': ('meite',),
'meitet': ('meite',),
'meita': ('meite',),
'meitet': ('meite',),
'meit': ('meite',),
'mekanisere': ('mekanisere',),
'mekaniserer': ('mekanisere',),
'mekaniseres': ('mekanisere',),
'mekaniserte': ('mekanisere',),
'mekanisert': ('mekanisere',),
'mekaniser': ('mekanisere',),
'mekke': ('mekke',),
'mekker': ('mekke',),
'mekkes': ('mekke',),
'mekka': ('mekke',),
'mekket': ('mekke',),
'mekka': ('mekke',),
'mekket': ('mekke',),
'mekk': ('mekke',),
'mekle': ('mekle',),
'mekler': ('mekle',),
'mekles': ('mekle',),
'mekla': ('mekle',),
'meklet': ('mekle',),
'mekla': ('mekle',),
'meklet': ('mekle',),
'mekl': ('mekle',),
'mekle': ('mekle',),
'mekl': ('mekle',),
'mekle': ('mekle',),
'mekre': ('mekre',),
'mekrer': ('mekre',),
'mekres': ('mekre',),
'mekra': ('mekre',),
'mekret': ('mekre',),
'mekra': ('mekre',),
'mekret': ('mekre',),
'mekr': ('mekre',),
'mekre': ('mekre',),
'mekr': ('mekre',),
'mekre': ('mekre',),
'melde': ('melde',),
'melder': ('melde',),
'meldes': ('melde',),
'meldte': ('melde',),
'meldt': ('melde',),
'meld': ('melde',),
'mele': ('mele',),
'meler': ('mele',),
'meles': ('mele',),
'mela': ('mele',),
'melet': ('mele',),
'melte': ('mele',),
'mela': ('mele',),
'melet': ('mele',),
'melt': ('mele',),
'mel': ('mele',),
'melere': ('melere',),
'melerer': ('melere',),
'meleres': ('melere',),
'melerte': ('melere',),
'melert': ('melere',),
'meler': ('melere',),
'melke': ('melke',),
'melker': ('melke',),
'melkes': ('melke',),
'melka': ('melke',),
'melket': ('melke',),
'melka': ('melke',),
'melket': ('melke',),
'melk': ('melke',),
'mellomlande': ('mellomlande',),
'mellomlander': ('mellomlande',),
'mellomlandes': ('mellomlande',),
'mellomlanda': ('mellomlande',),
'mellomlandet': ('mellomlande',),
'mellomlanda': ('mellomlande',),
'mellomlandet': ('mellomlande',),
'mellomland': ('mellomlande',),
'melte': ('melte',),
'melter': ('melte',),
'meltes': ('melte',),
'melta': ('melte',),
'meltet': ('melte',),
'melta': ('melte',),
'meltet': ('melte',),
'melt': ('melte',),
'memorere': ('memorere',),
'memorerer': ('memorere',),
'memoreres': ('memorere',),
'memorerte': ('memorere',),
'memorert': ('memorere',),
'memorer': ('memorere',),
'mene': ('mene',),
'mener': ('mene',),
'menes': ('mene',),
'mente': ('mene',),
'ment': ('mene',),
'men': ('mene',),
'menge': ('menge',),
'menger': ('menge',),
'menges': ('menge',),
'menga': ('menge',),
'menget': ('menge',),
'mengte': ('menge',),
'menga': ('menge',),
'menget': ('menge',),
'mengt': ('menge',),
'meng': ('menge',),
'menstruere': ('menstruere',),
'menstruerer': ('menstruere',),
'menstrueres': ('menstruere',),
'menstruerte': ('menstruere',),
'menstruert': ('menstruere',),
'menstruer': ('menstruere',),
'mentalundersøke': ('mentalundersøke',),
'mentalundersøker': ('mentalundersøke',),
'mentalundersøkes': ('mentalundersøke',),
'mentalundersøkte': ('mentalundersøke',),
'mentalundersøkt': ('mentalundersøke',),
'mentalundersøk': ('mentalundersøke',),
'mergle': ('mergle',),
'mergler': ('mergle',),
'mergles': ('mergle',),
'mergla': ('mergle',),
'merglet': ('mergle',),
'mergla': ('mergle',),
'merglet': ('mergle',),
'mergl': ('mergle',),
'mergle': ('mergle',),
'mergl': ('mergle',),
'mergle': ('mergle',),
'merittere': ('merittere',),
'meritterer': ('merittere',),
'meritteres': ('merittere',),
'meritterte': ('merittere',),
'merittert': ('merittere',),
'meritter': ('merittere',),
'merke': ('merke',),
'merker': ('merke',),
'merkes': ('merke',),
'merka': ('merke',),
'merket': ('merke',),
'merka': ('merke',),
'merket': ('merke',),
'merk': ('merke',),
'merle': ('merle',),
'merler': ('merle',),
'merles': ('merle',),
'merla': ('merle',),
'merlet': ('merle',),
'merla': ('merle',),
'merlet': ('merle',),
'merl': ('merle',),
'meske': ('meske',),
'mesker': ('meske',),
'meskes': ('meske',),
'meska': ('meske',),
'mesket': ('meske',),
'meska': ('meske',),
'mesket': ('meske',),
'mesk': ('meske',),
'messe': ('messe',),
'messer': ('messe',),
'messes': ('messe',),
'messa': ('messe',),
'messet': ('messe',),
'messa': ('messe',),
'messet': ('messe',),
'mess': ('messe',),
'mestre': ('mestre',),
'mestrer': ('mestre',),
'mestres': ('mestre',),
'mestra': ('mestre',),
'mestret': ('mestre',),
'mestra': ('mestre',),
'mestret': ('mestre',),
'mestr': ('mestre',),
'mestre': ('mestre',),
'mestr': ('mestre',),
'mestre': ('mestre',),
'metallisere': ('metallisere',),
'metalliserer': ('metallisere',),
'metalliseres': ('metallisere',),
'metalliserte': ('metallisere',),
'metallisert': ('metallisere',),
'metalliser': ('metallisere',),
'mette': ('mette',),
'metter': ('mette',),
'mettes': ('mette',),
'metta': ('mette',),
'mettet': ('mette',),
'metta': ('mette',),
'mettet': ('mette',),
'mett': ('mette',),
'midle': ('midle',),
'midler': ('midle',),
'midles': ('midle',),
'midla': ('midle',),
'midlet': ('midle',),
'midla': ('midle',),
'midlet': ('midle',),
'midl': ('midle',),
'mige': ('mige',),
'miger': ('mige',),
'miges': ('mige',),
'meg': ('mige',),
'meig': ('mige',),
'meg': ('mige',),
'meig': ('mige',),
'meget': ('mige',),
'mig': ('mige',),
'migrere': ('migrere',),
'migrerer': ('migrere',),
'migreres': ('migrere',),
'migrerte': ('migrere',),
'migrert': ('migrere',),
'migrer': ('migrere',),
'mikroskopere': ('mikroskopere',),
'mikroskoperer': ('mikroskopere',),
'mikroskoperes': ('mikroskopere',),
'mikroskoperte': ('mikroskopere',),
'mikroskopert': ('mikroskopere',),
'mikroskoper': ('mikroskopere',),
'mikse': ('mikse',),
'mikser': ('mikse',),
'mikses': ('mikse',),
'miksa': ('mikse',),
'mikset': ('mikse',),
'miksa': ('mikse',),
'mikset': ('mikse',),
'miks': ('mikse',),
'mildne': ('mildne',),
'mildner': ('mildne',),
'mildnes': ('mildne',),
'mildna': ('mildne',),
'mildnet': ('mildne',),
'mildna': ('mildne',),
'mildnet': ('mildne',),
'mildn': ('mildne',),
'mildne': ('mildne',),
'mildn': ('mildne',),
'mildne': ('mildne',),
'militarisere': ('militarisere',),
'militariserer': ('militarisere',),
'militariseres': ('militarisere',),
'militariserte': ('militarisere',),
'militarisert': ('militarisere',),
'militariser': ('militarisere',),
'mime': ('mime',),
'mimer': ('mime',),
'mimes': ('mime',),
'mima': ('mime',),
'mimet': ('mime',),
'mima': ('mime',),
'mimet': ('mime',),
'mim': ('mime',),
'mimre': ('mimre',),
'mimrer': ('mimre',),
'mimres': ('mimre',),
'mimra': ('mimre',),
'mimret': ('mimre',),
'mimra': ('mimre',),
'mimret': ('mimre',),
'mimr': ('mimre',),
'mimre': ('mimre',),
'mimr': ('mimre',),
'mimre': ('mimre',),
'mine': ('mine',),
'miner': ('mine',),
'mines': ('mine',),
'mina': ('mine',),
'minet': ('mine',),
'minte': ('mine',),
'mina': ('mine',),
'minet': ('mine',),
'mint': ('mine',),
'min': ('mine',),
'minelegge': ('minelegge',),
'minelegger': ('minelegge',),
'minelegges': ('minelegge',),
'minela': ('minelegge',),
'minelagt': ('minelegge',),
'minelegg': ('minelegge',),
'minere': ('minere',),
'minerer': ('minere',),
'mineres': ('minere',),
'minerte': ('minere',),
'minert': ('minere',),
'miner': ('minere',),
'miniatyrisere': ('miniatyrisere',),
'miniatyriserer': ('miniatyrisere',),
'miniatyriseres': ('miniatyrisere',),
'miniatyriserte': ('miniatyrisere',),
'miniatyrisert': ('miniatyrisere',),
'miniatyriser': ('miniatyrisere',),
'minimalisere': ('minimalisere',),
'minimaliserer': ('minimalisere',),
'minimaliseres': ('minimalisere',),
'minimaliserte': ('minimalisere',),
'minimalisert': ('minimalisere',),
'minimaliser': ('minimalisere',),
'minimere': ('minimere',),
'minimerer': ('minimere',),
'minimeres': ('minimere',),
'minimerte': ('minimere',),
'minimert': ('minimere',),
'minimer': ('minimere',),
'minke': ('minke',),
'minker': ('minke',),
'minkes': ('minke',),
'minka': ('minke',),
'minket': ('minke',),
'minka': ('minke',),
'minket': ('minke',),
'mink': ('minke',),
'minne': ('minne',),
'minner': ('minne',),
'minnes': ('minne',),
'minna': ('minne',),
'minnet': ('minne',),
'minte': ('minne',),
'minna': ('minne',),
'minnet': ('minne',),
'mint': ('minne',),
'minn': ('minne',),
'minnes': ('minnes',),
'mins': ('minnes',),
'mintes': ('minnes',),
'minnes': ('minnes',),
'minske': ('minske',),
'minsker': ('minske',),
'minskes': ('minske',),
'minska': ('minske',),
'minsket': ('minske',),
'minska': ('minske',),
'minsket': ('minske',),
'minsk': ('minske',),
'misbillige': ('misbillige',),
'misbilliger': ('misbillige',),
'misbilliges': ('misbillige',),
'misbilliga': ('misbillige',),
'misbilliget': ('misbillige',),
'misbilliga': ('misbillige',),
'misbilliget': ('misbillige',),
'misbillig': ('misbillige',),
'misbruke': ('misbruke',),
'misbruker': ('misbruke',),
'misbrukes': ('misbruke',),
'misbrukte': ('misbruke',),
'misbrukt': ('misbruke',),
'misbruk': ('misbruke',),
'misfare': ('misfare',),
'misfarer': ('misfare',),
'misfares': ('misfare',),
'misfor': ('misfare',),
'misfart': ('misfare',),
'misfar': ('misfare',),
'misfarge': ('misfarge',),
'misfarger': ('misfarge',),
'misfarges': ('misfarge',),
'misfarga': ('misfarge',),
'misfarget': ('misfarge',),
'misfarga': ('misfarge',),
'misfarget': ('misfarge',),
'misfarg': ('misfarge',),
'misforstå': ('misforstå',),
'misforstår': ('misforstå',),
'misforstås': ('misforstå',),
'misforsto': ('misforstå',),
'misforstod': ('misforstå',),
'misforstått': ('misforstå',),
'misforstå': ('misforstå',),
'mishage': ('mishage',),
'mishager': ('mishage',),
'mishages': ('mishage',),
'mishaga': ('mishage',),
'mishaget': ('mishage',),
'mishaga': ('mishage',),
'mishaget': ('mishage',),
'mishag': ('mishage',),
'mishandle': ('mishandle',),
'mishandler': ('mishandle',),
'mishandles': ('mishandle',),
'mishandla': ('mishandle',),
'mishandlet': ('mishandle',),
'mishandla': ('mishandle',),
'mishandlet': ('mishandle',),
'mishandl': ('mishandle',),
'mishandle': ('mishandle',),
'mishandl': ('mishandle',),
'mishandle': ('mishandle',),
'mishøre': ('mishøre',),
'mishører': ('mishøre',),
'mishøres': ('mishøre',),
'mishørte': ('mishøre',),
'mishørt': ('mishøre',),
'mishør': ('mishøre',),
'misjonere': ('misjonere',),
'misjonerer': ('misjonere',),
'misjoneres': ('misjonere',),
'misjonerte': ('misjonere',),
'misjonert': ('misjonere',),
'misjoner': ('misjonere',),
'miskjenne': ('miskjenne',),
'miskjenner': ('miskjenne',),
'miskjennes': ('miskjenne',),
'miskjente': ('miskjenne',),
'miskjent': ('miskjenne',),
'miskjenn': ('miskjenne',),
'miskle': ('miskle',),
'miskler': ('miskle',),
'miskles': ('miskle',),
'miskledde': ('miskle',),
'miskledd': ('miskle',),
'miskle': ('miskle',),
'miskunne': ('miskunne',),
'miskunner': ('miskunne',),
'miskunnes': ('miskunne',),
'miskunte': ('miskunne',),
'miskunt': ('miskunne',),
'miskunn': ('miskunne',),
'misligholde': ('misligholde',),
'misligholder': ('misligholde',),
'misligholdes': ('misligholde',),
'misligholdt': ('misligholde',),
'mislighold': ('misligholde',),
'mislike': ('mislike',),
'misliker': ('mislike',),
'mislikes': ('mislike',),
'mislikte': ('mislike',),
'mislikt': ('mislike',),
'mislik': ('mislike',),
'mislykkes': ('mislykkes',),
'mislyktes': ('mislykkes',),
'mislykkes': ('mislykkes',),
'mislyktes': ('mislykkes',),
'mislykkes': ('mislykkes',),
'misoppfatte': ('misoppfatte',),
'misoppfatter': ('misoppfatte',),
'misoppfattes': ('misoppfatte',),
'misoppfatta': ('misoppfatte',),
'misoppfattet': ('misoppfatte',),
'misoppfatta': ('misoppfatte',),
'misoppfattet': ('misoppfatte',),
'misoppfatt': ('misoppfatte',),
'misregne': ('misregne',),
'misregner': ('misregne',),
'misregnes': ('misregne',),
'misregna': ('misregne',),
'misregnet': ('misregne',),
'misregna': ('misregne',),
'misregnet': ('misregne',),
'misregn': ('misregne',),
'missnakke': ('missnakke',),
'missnakker': ('missnakke',),
'missnakkes': ('missnakke',),
'missnakka': ('missnakke',),
'missnakket': ('missnakke',),
'missnakka': ('missnakke',),
'missnakket': ('missnakke',),
'missnakk': ('missnakke',),
'mista': ('mista',),
'mistar': ('mista',),
'mistas': ('mista',),
'mistok': ('mista',),
'mistatt': ('mista',),
'mista': ('mista',),
'miste': ('miste',),
'mister': ('miste',),
'mistes': ('miste',),
'mista': ('miste',),
'mistet': ('miste',),
'mista': ('miste',),
'mistet': ('miste',),
'mist': ('miste',),
'mistenke': ('mistenke',),
'mistenker': ('mistenke',),
'mistenkes': ('mistenke',),
'mistenkte': ('mistenke',),
'mistenkt': ('mistenke',),
'mistenk': ('mistenke',),
'mistenkeliggjøre': ('mistenkeliggjøre',),
'mistenkeliggjør': ('mistenkeliggjøre',),
'mistenkeliggjøres': ('mistenkeliggjøre',),
'mistenkeliggjorde': ('mistenkeliggjøre',),
'mistenkeliggjort': ('mistenkeliggjøre',),
'mistenkeliggjør': ('mistenkeliggjøre',),
'mistolke': ('mistolke',),
'mistolker': ('mistolke',),
'mistolkes': ('mistolke',),
'mistolka': ('mistolke',),
'mistolket': ('mistolke',),
'mistolka': ('mistolke',),
'mistolket': ('mistolke',),
'mistolk': ('mistolke',),
'mistrives': ('mistrives',),
'mistrivs': ('mistrives',),
'mistrives': ('mistrives',),
'mistrivdes': ('mistrives',),
'mistrives': ('mistrives',),
'mistro': ('mistro',),
'mistror': ('mistro',),
'mistros': ('mistro',),
'mistrodde': ('mistro',),
'mistrodd': ('mistro',),
'mistro': ('mistro',),
'mistru': ('mistru',),
'mistrur': ('mistru',),
'mistrus': ('mistru',),
'mistrudde': ('mistru',),
'mistrudd': ('mistru',),
'mistru': ('mistru',),
'misunne': ('misunne',),
'misunner': ('misunne',),
'misunnes': ('misunne',),
'misunte': ('misunne',),
'misunt': ('misunne',),
'misunn': ('misunne',),
'mjaue': ('mjaue',),
'mjauer': ('mjaue',),
'mjaues': ('mjaue',),
'mjaua': ('mjaue',),
'mjauet': ('mjaue',),
'mjaua': ('mjaue',),
'mjauet': ('mjaue',),
'mjau': ('mjaue',),
'mjuklande': ('mjuklande',),
'mjuklander': ('mjuklande',),
'mjuklandes': ('mjuklande',),
'mjuklanda': ('mjuklande',),
'mjuklandet': ('mjuklande',),
'mjuklanda': ('mjuklande',),
'mjuklandet': ('mjuklande',),
'mjukland': ('mjuklande',),
'mjukne': ('mjukne',),
'mjukner': ('mjukne',),
'mjuknes': ('mjukne',),
'mjukna': ('mjukne',),
'mjuknet': ('mjukne',),
'mjukna': ('mjukne',),
'mjuknet': ('mjukne',),
'mjukn': ('mjukne',),
'mjukne': ('mjukne',),
'mjukn': ('mjukne',),
'mjukne': ('mjukne',),
'mjøle': ('mjøle',),
'mjøler': ('mjøle',),
'mjøles': ('mjøle',),
'mjøla': ('mjøle',),
'mjølet': ('mjøle',),
'mjølte': ('mjøle',),
'mjøla': ('mjøle',),
'mjølet': ('mjøle',),
'mjølt': ('mjøle',),
'mjøl': ('mjøle',),
'mjølke': ('mjølke',),
'mjølker': ('mjølke',),
'mjølkes': ('mjølke',),
'mjølka': ('mjølke',),
'mjølket': ('mjølke',),
'mjølka': ('mjølke',),
'mjølket': ('mjølke',),
'mjølk': ('mjølke',),
'mobbe': ('mobbe',),
'mobber': ('mobbe',),
'mobbes': ('mobbe',),
'mobba': ('mobbe',),
'mobbet': ('mobbe',),
'mobba': ('mobbe',),
'mobbet': ('mobbe',),
'mobb': ('mobbe',),
'mobilisere': ('mobilisere',),
'mobiliserer': ('mobilisere',),
'mobiliseres': ('mobilisere',),
'mobiliserte': ('mobilisere',),
'mobilisert': ('mobilisere',),
'mobiliser': ('mobilisere',),
'modellere': ('modellere',),
'modellerer': ('modellere',),
'modelleres': ('modellere',),
'modellerte': ('modellere',),
'modellert': ('modellere',),
'modeller': ('modellere',),
'moderere': ('moderere',),
'modererer': ('moderere',),
'modereres': ('moderere',),
'modererte': ('moderere',),
'moderert': ('moderere',),
'moderer': ('moderere',),
'modernisere': ('modernisere',),
'moderniserer': ('modernisere',),
'moderniseres': ('modernisere',),
'moderniserte': ('modernisere',),
'modernisert': ('modernisere',),
'moderniser': ('modernisere',),
'modifisere': ('modifisere',),
'modifiserer': ('modifisere',),
'modifiseres': ('modifisere',),
'modifiserte': ('modifisere',),
'modifisert': ('modifisere',),
'modifiser': ('modifisere',),
'modne': ('modne',),
'modner': ('modne',),
'modnes': ('modne',),
'modna': ('modne',),
'modnet': ('modne',),
'modna': ('modne',),
'modnet': ('modne',),
'modn': ('modne',),
'modne': ('modne',),
'modn': ('modne',),
'modne': ('modne',),
'modnes': ('modnes',),
'modnedes': ('modnes',),
'modnes': ('modnes',),
'modulere': ('modulere',),
'modulerer': ('modulere',),
'moduleres': ('modulere',),
'modulerte': ('modulere',),
'modulert': ('modulere',),
'moduler': ('modulere',),
'molde': ('molde',),
'molder': ('molde',),
'moldes': ('molde',),
'molda': ('molde',),
'moldet': ('molde',),
'molda': ('molde',),
'moldet': ('molde',),
'mold': ('molde',),
'molestere': ('molestere',),
'molesterer': ('molestere',),
'molesteres': ('molestere',),
'molesterte': ('molestere',),
'molestert': ('molestere',),
'molester': ('molestere',),
'mompe': ('mompe',),
'momper': ('mompe',),
'mompes': ('mompe',),
'mompa': ('mompe',),
'mompet': ('mompe',),
'mompa': ('mompe',),
'mompet': ('mompe',),
'momp': ('mompe',),
'monne': ('monne',),
'monner': ('monne',),
'monnes': ('monne',),
'monna': ('monne',),
'monnet': ('monne',),
'monna': ('monne',),
'monnet': ('monne',),
'monn': ('monne',),
'monne': ('monne',),
'mon': ('monne',),
'monne': ('monne',),
'monoftongere': ('monoftongere',),
'monoftongerer': ('monoftongere',),
'monoftongeres': ('monoftongere',),
'monoftongerte': ('monoftongere',),
'monoftongert': ('monoftongere',),
'monoftonger': ('monoftongere',),
'monopolisere': ('monopolisere',),
'monopoliserer': ('monopolisere',),
'monopoliseres': ('monopolisere',),
'monopoliserte': ('monopolisere',),
'monopolisert': ('monopolisere',),
'monopoliser': ('monopolisere',),
'montere': ('montere',),
'monterer': ('montere',),
'monteres': ('montere',),
'monterte': ('montere',),
'montert': ('montere',),
'monter': ('montere',),
'moppe': ('moppe',),
'mopper': ('moppe',),
'moppes': ('moppe',),
'moppa': ('moppe',),
'moppet': ('moppe',),
'moppa': ('moppe',),
'moppet': ('moppe',),
'mopp': ('moppe',),
'moralisere': ('moralisere',),
'moraliserer': ('moralisere',),
'moraliseres': ('moralisere',),
'moraliserte': ('moralisere',),
'moralisert': ('moralisere',),
'moraliser': ('moralisere',),
'more': ('more',),
'morer': ('more',),
'mores': ('more',),
'mora': ('more',),
'moret': ('more',),
'mora': ('more',),
'moret': ('more',),
'mor': ('more',),
'more': ('more',),
'morer': ('more',),
'mores': ('more',),
'moret': ('more',),
'morte': ('more',),
'moret': ('more',),
'mort': ('more',),
'mor': ('more',),
'morgne': ('morgne',),
'morgner': ('morgne',),
'morgnes': ('morgne',),
'morgna': ('morgne',),
'morgnet': ('morgne',),
'morgna': ('morgne',),
'morgnet': ('morgne',),
'morgn': ('morgne',),
'morgne': ('morgne',),
'morgn': ('morgne',),
'morgne': ('morgne',),
'morkne': ('morkne',),
'morkner': ('morkne',),
'morknes': ('morkne',),
'morkna': ('morkne',),
'morknet': ('morkne',),
'morkna': ('morkne',),
'morknet': ('morkne',),
'morkn': ('morkne',),
'morkne': ('morkne',),
'morkn': ('morkne',),
'morkne': ('morkne',),
'morse': ('morse',),
'morser': ('morse',),
'morses': ('morse',),
'morsa': ('morse',),
'morset': ('morse',),
'morsa': ('morse',),
'morset': ('morse',),
'mors': ('morse',),
'morske': ('morske',),
'morsker': ('morske',),
'morskes': ('morske',),
'morska': ('morske',),
'morsket': ('morske',),
'morska': ('morske',),
'morsket': ('morske',),
'morsk': ('morske',),
'mortifisere': ('mortifisere',),
'mortifiserer': ('mortifisere',),
'mortifiseres': ('mortifisere',),
'mortifiserte': ('mortifisere',),
'mortifisert': ('mortifisere',),
'mortifiser': ('mortifisere',),
'mosjonere': ('mosjonere',),
'mosjonerer': ('mosjonere',),
'mosjoneres': ('mosjonere',),
'mosjonerte': ('mosjonere',),
'mosjonert': ('mosjonere',),
'mosjoner': ('mosjonere',),
'motarbeide': ('motarbeide',),
'motarbeider': ('motarbeide',),
'motarbeides': ('motarbeide',),
'motarbeida': ('motarbeide',),
'motarbeidet': ('motarbeide',),
'motarbeidde': ('motarbeide',),
'motarbeida': ('motarbeide',),
'motarbeidet': ('motarbeide',),
'motarbeidd': ('motarbeide',),
'motarbeid': ('motarbeide',),
'motbevise': ('motbevise',),
'motbeviser': ('motbevise',),
'motbevises': ('motbevise',),
'motbeviste': ('motbevise',),
'motbevist': ('motbevise',),
'motbevis': ('motbevise',),
'motivere': ('motivere',),
'motiverer': ('motivere',),
'motiveres': ('motivere',),
'motiverte': ('motivere',),
'motivert': ('motivere',),
'motiver': ('motivere',),
'motorisere': ('motorisere',),
'motoriserer': ('motorisere',),
'motoriseres': ('motorisere',),
'motoriserte': ('motorisere',),
'motorisert': ('motorisere',),
'motoriser': ('motorisere',),
'motsette': ('motsette',),
'motsetter': ('motsette',),
'motsettes': ('motsette',),
'motsatte': ('motsette',),
'motsatt': ('motsette',),
'motsett': ('motsette',),
'motsvare': ('motsvare',),
'motsvarer': ('motsvare',),
'motsvares': ('motsvare',),
'motsvarte': ('motsvare',),
'motsvart': ('motsvare',),
'motsvar': ('motsvare',),
'motta': ('motta',),
'mottar': ('motta',),
'mottas': ('motta',),
'mottok': ('motta',),
'mottatt': ('motta',),
'motta': ('motta',),
'motvirke': ('motvirke',),
'motvirker': ('motvirke',),
'motvirkes': ('motvirke',),
'motvirka': ('motvirke',),
'motvirket': ('motvirke',),
'motvirka': ('motvirke',),
'motvirket': ('motvirke',),
'motvirk': ('motvirke',),
'movere': ('movere',),
'moverer': ('movere',),
'moveres': ('movere',),
'moverte': ('movere',),
'movert': ('movere',),
'mover': ('movere',),
'mudre': ('mudre',),
'mudrer': ('mudre',),
'mudres': ('mudre',),
'mudra': ('mudre',),
'mudret': ('mudre',),
'mudra': ('mudre',),
'mudret': ('mudre',),
'mudr': ('mudre',),
'mudre': ('mudre',),
'mudr': ('mudre',),
'mudre': ('mudre',),
'muge': ('muge',),
'muger': ('muge',),
'muges': ('muge',),
'muga': ('muge',),
'muget': ('muge',),
'muga': ('muge',),
'muget': ('muge',),
'mug': ('muge',),
'mugge': ('mugge',),
'mugger': ('mugge',),
'mugges': ('mugge',),
'mugga': ('mugge',),
'mugget': ('mugge',),
'mugga': ('mugge',),
'mugget': ('mugge',),
'mugg': ('mugge',),
'mugne': ('mugne',),
'mugner': ('mugne',),
'mugnes': ('mugne',),
'mugna': ('mugne',),
'mugnet': ('mugne',),
'mugna': ('mugne',),
'mugnet': ('mugne',),
'mugn': ('mugne',),
'mukke': ('mukke',),
'mukker': ('mukke',),
'mukkes': ('mukke',),
'mukka': ('mukke',),
'mukket': ('mukke',),
'mukka': ('mukke',),
'mukket': ('mukke',),
'mukk': ('mukke',),
'mulde': ('mulde',),
'mulder': ('mulde',),
'muldes': ('mulde',),
'mulda': ('mulde',),
'muldet': ('mulde',),
'mulda': ('mulde',),
'muldet': ('mulde',),
'muld': ('mulde',),
'mule': ('mule',),
'muler': ('mule',),
'mules': ('mule',),
'multe': ('mule',),
'mult': ('mule',),
'mul': ('mule',),
'mulebinde': ('mulebinde',),
'mulebinder': ('mulebinde',),
'mulebindes': ('mulebinde',),
'mulebandt': ('mulebinde',),
'mulebundet': ('mulebinde',),
'mulebind': ('mulebinde',),
'muliggjøre': ('muliggjøre',),
'muliggjør': ('muliggjøre',),
'muliggjøres': ('muliggjøre',),
'muliggjorde': ('muliggjøre',),
'muliggjort': ('muliggjøre',),
'muliggjør': ('muliggjøre',),
'muljere': ('muljere',),
'muljerer': ('muljere',),
'muljeres': ('muljere',),
'muljerte': ('muljere',),
'muljert': ('muljere',),
'muljer': ('muljere',),
'mulkte': ('mulkte',),
'mulkter': ('mulkte',),
'mulktes': ('mulkte',),
'mulkta': ('mulkte',),
'mulktet': ('mulkte',),
'mulkta': ('mulkte',),
'mulktet': ('mulkte',),
'mulkt': ('mulkte',),
'mulktere': ('mulktere',),
'mulkterer': ('mulktere',),
'mulkteres': ('mulktere',),
'mulkterte': ('mulktere',),
'mulktert': ('mulktere',),
'mulkter': ('mulktere',),
'mulle': ('mulle',),
'muller': ('mulle',),
'mulles': ('mulle',),
'mulla': ('mulle',),
'mullet': ('mulle',),
'mulla': ('mulle',),
'mullet': ('mulle',),
'mull': ('mulle',),
'mulne': ('mulne',),
'mulner': ('mulne',),
'mulnes': ('mulne',),
'mulna': ('mulne',),
'mulnet': ('mulne',),
'mulna': ('mulne',),
'mulnet': ('mulne',),
'muln': ('mulne',),
'mulne': ('mulne',),
'muln': ('mulne',),
'mulne': ('mulne',),
'mulre': ('mulre',),
'mulrer': ('mulre',),
'mulres': ('mulre',),
'mulra': ('mulre',),
'mulret': ('mulre',),
'mulra': ('mulre',),
'mulret': ('mulre',),
'mulr': ('mulre',),
'mulre': ('mulre',),
'mulr': ('mulre',),
'mulre': ('mulre',),
'multiplisere': ('multiplisere',),
'multipliserer': ('multiplisere',),
'multipliseres': ('multiplisere',),
'multipliserte': ('multiplisere',),
'multiplisert': ('multiplisere',),
'multipliser': ('multiplisere',),
'mumifisere': ('mumifisere',),
'mumifiserer': ('mumifisere',),
'mumifiseres': ('mumifisere',),
'mumifiserte': ('mumifisere',),
'mumifisert': ('mumifisere',),
'mumifiser': ('mumifisere',),
'mumisere': ('mumisere',),
'mumiserer': ('mumisere',),
'mumiseres': ('mumisere',),
'mumiserte': ('mumisere',),
'mumisert': ('mumisere',),
'mumiser': ('mumisere',),
'mumle': ('mumle',),
'mumler': ('mumle',),
'mumles': ('mumle',),
'mumla': ('mumle',),
'mumlet': ('mumle',),
'mumla': ('mumle',),
'mumlet': ('mumle',),
'muml': ('mumle',),
'mumle': ('mumle',),
'muml': ('mumle',),
'mumle': ('mumle',),
'mumse': ('mumse',),
'mumser': ('mumse',),
'mumses': ('mumse',),
'mumsa': ('mumse',),
'mumset': ('mumse',),
'mumsa': ('mumse',),
'mumset': ('mumse',),
'mums': ('mumse',),
'munne': ('munne',),
'munner': ('munne',),
'munnes': ('munne',),
'munna': ('munne',),
'munnet': ('munne',),
'munna': ('munne',),
'munnet': ('munne',),
'munn': ('munne',),
'munnhogges': ('munnhogges',),
'munnhogdes': ('munnhogges',),
'munnhogges': ('munnhogges',),
'munnhugges': ('munnhugges',),
'munnhugdes': ('munnhugges',),
'munnhugges': ('munnhugges',),
'muntre': ('muntre',),
'muntrer': ('muntre',),
'muntres': ('muntre',),
'muntra': ('muntre',),
'muntret': ('muntre',),
'muntra': ('muntre',),
'muntret': ('muntre',),
'muntr': ('muntre',),
'muntre': ('muntre',),
'muntr': ('muntre',),
'muntre': ('muntre',),
'mure': ('mure',),
'murer': ('mure',),
'mures': ('mure',),
'mura': ('mure',),
'muret': ('mure',),
'murte': ('mure',),
'mura': ('mure',),
'muret': ('mure',),
'murt': ('mure',),
'mur': ('mure',),
'murre': ('murre',),
'murrer': ('murre',),
'murres': ('murre',),
'murra': ('murre',),
'murret': ('murre',),
'murra': ('murre',),
'murret': ('murre',),
'murr': ('murre',),
'musisere': ('musisere',),
'musiserer': ('musisere',),
'musiseres': ('musisere',),
'musiserte': ('musisere',),
'musisert': ('musisere',),
'musiser': ('musisere',),
'mussere': ('mussere',),
'musserer': ('mussere',),
'musseres': ('mussere',),
'musserte': ('mussere',),
'mussert': ('mussere',),
'musser': ('mussere',),
'mute': ('mute',),
'muter': ('mute',),
'mutes': ('mute',),
'muta': ('mute',),
'mutet': ('mute',),
'muta': ('mute',),
'mutet': ('mute',),
'mut': ('mute',),
'mutere': ('mutere',),
'muterer': ('mutere',),
'muteres': ('mutere',),
'muterte': ('mutere',),
'mutert': ('mutere',),
'muter': ('mutere',),
'mygle': ('mygle',),
'mygler': ('mygle',),
'mygles': ('mygle',),
'mygla': ('mygle',),
'myglet': ('mygle',),
'mygla': ('mygle',),
'myglet': ('mygle',),
'mygl': ('mygle',),
'mygle': ('mygle',),
'mygl': ('mygle',),
'mygle': ('mygle',),
'myke': ('myke',),
'myker': ('myke',),
'mykes': ('myke',),
'myka': ('myke',),
'myket': ('myke',),
'mykte': ('myke',),
'myka': ('myke',),
'myket': ('myke',),
'mykt': ('myke',),
'myk': ('myke',),
'myklande': ('myklande',),
'myklander': ('myklande',),
'myklandes': ('myklande',),
'myklanda': ('myklande',),
'myklandet': ('myklande',),
'myklanda': ('myklande',),
'myklandet': ('myklande',),
'mykland': ('myklande',),
'mykne': ('mykne',),
'mykner': ('mykne',),
'myknes': ('mykne',),
'mykna': ('mykne',),
'myknet': ('mykne',),
'mykna': ('mykne',),
'myknet': ('mykne',),
'mykn': ('mykne',),
'mykne': ('mykne',),
'mykn': ('mykne',),
'mykne': ('mykne',),
'myldre': ('myldre',),
'myldrer': ('myldre',),
'myldres': ('myldre',),
'myldra': ('myldre',),
'myldret': ('myldre',),
'myldra': ('myldre',),
'myldret': ('myldre',),
'myldr': ('myldre',),
'myldre': ('myldre',),
'myldr': ('myldre',),
'myldre': ('myldre',),
'mynte': ('mynte',),
'mynter': ('mynte',),
'myntes': ('mynte',),
'mynta': ('mynte',),
'myntet': ('mynte',),
'mynta': ('mynte',),
'myntet': ('mynte',),
'mynt': ('mynte',),
'myrde': ('myrde',),
'myrder': ('myrde',),
'myrdes': ('myrde',),
'myrda': ('myrde',),
'myrdet': ('myrde',),
'myrda': ('myrde',),
'myrdet': ('myrde',),
'myrd': ('myrde',),
'myse': ('myse',),
'myser': ('myse',),
'myses': ('myse',),
'myste': ('myse',),
'myst': ('myse',),
'mys': ('myse',),
'mystifisere': ('mystifisere',),
'mystifiserer': ('mystifisere',),
'mystifiseres': ('mystifisere',),
'mystifiserte': ('mystifisere',),
'mystifisert': ('mystifisere',),
'mystifiser': ('mystifisere',),
'myte': ('myte',),
'myter': ('myte',),
'mytes': ('myte',),
'mytet': ('myte',),
'mytte': ('myte',),
'mytet': ('myte',),
'mytt': ('myte',),
'myt': ('myte',),
'måke': ('måke',),
'måker': ('måke',),
'måkes': ('måke',),
'måka': ('måke',),
'måket': ('måke',),
'måkte': ('måke',),
'måka': ('måke',),
'måket': ('måke',),
'måkt': ('måke',),
'måk': ('måke',),
'målbinde': ('målbinde',),
'målbinder': ('målbinde',),
'målbindes': ('målbinde',),
'målbandt': ('målbinde',),
'målbundet': ('målbinde',),
'målbind': ('målbinde',),
'måle': ('måle',),
'måler': ('måle',),
'måles': ('måle',),
'målte': ('måle',),
'målt': ('måle',),
'mål': ('måle',),
'måpe': ('måpe',),
'måper': ('måpe',),
'måpes': ('måpe',),
'måpte': ('måpe',),
'måpt': ('måpe',),
'måp': ('måpe',),
'måte': ('måte',),
'måter': ('måte',),
'måtes': ('måte',),
'måta': ('måte',),
'måtet': ('måte',),
'måta': ('måte',),
'måtet': ('måte',),
'måt': ('måte',),
'måtte': ('måtte',),
'må': ('måtte',),
'måtte': ('måtte',),
'måttet': ('måtte',),
'mæle': ('mæle',),
'mæler': ('mæle',),
'mæles': ('mæle',),
'mælte': ('mæle',),
'mælt': ('mæle',),
'mæl': ('mæle',),
'mæte': ('mæte',),
'mæter': ('mæte',),
'mætes': ('mæte',),
'mætte': ('mæte',),
'mætt': ('mæte',),
'mæt': ('mæte',),
'møblere': ('møblere',),
'møblerer': ('møblere',),
'møbleres': ('møblere',),
'møblerte': ('møblere',),
'møblert': ('møblere',),
'møbler': ('møblere',),
'møkke': ('møkke',),
'møkker': ('møkke',),
'møkkes': ('møkke',),
'møkka': ('møkke',),
'møkket': ('møkke',),
'møkka': ('møkke',),
'møkket': ('møkke',),
'møkk': ('møkke',),
'mønje': ('mønje',),
'mønjer': ('mønje',),
'mønjes': ('mønje',),
'mønja': ('mønje',),
'mønjet': ('mønje',),
'mønja': ('mønje',),
'mønjet': ('mønje',),
'mønj': ('mønje',),
'mønstre': ('mønstre',),
'mønstrer': ('mønstre',),
'mønstres': ('mønstre',),
'mønstra': ('mønstre',),
'mønstret': ('mønstre',),
'mønstra': ('mønstre',),
'mønstret': ('mønstre',),
'mønstr': ('mønstre',),
'mønstre': ('mønstre',),
'mønstr': ('mønstre',),
'mønstre': ('mønstre',),
'mørbanke': ('mørbanke',),
'mørbanker': ('mørbanke',),
'mørbankes': ('mørbanke',),
'mørbanka': ('mørbanke',),
'mørbanket': ('mørbanke',),
'mørbanka': ('mørbanke',),
'mørbanket': ('mørbanke',),
'mørbank': ('mørbanke',),
'mørke': ('mørke',),
'mørker': ('mørke',),
'mørkes': ('mørke',),
'mørka': ('mørke',),
'mørket': ('mørke',),
'mørka': ('mørke',),
'mørket': ('mørke',),
'mørk': ('mørke',),
'mørklegge': ('mørklegge',),
'mørklegger': ('mørklegge',),
'mørklegges': ('mørklegge',),
'mørkla': ('mørklegge',),
'mørklagt': ('mørklegge',),
'mørklegg': ('mørklegge',),
'mørkne': ('mørkne',),
'mørkner': ('mørkne',),
'mørknes': ('mørkne',),
'mørkna': ('mørkne',),
'mørknet': ('mørkne',),
'mørkna': ('mørkne',),
'mørknet': ('mørkne',),
'mørkn': ('mørkne',),
'mørkne': ('mørkne',),
'mørkn': ('mørkne',),
'mørkne': ('mørkne',),
'mørne': ('mørne',),
'mørner': ('mørne',),
'mørnes': ('mørne',),
'mørna': ('mørne',),
'mørnet': ('mørne',),
'mørna': ('mørne',),
'mørnet': ('mørne',),
'mørn': ('mørne',),
'møte': ('møte',),
'møter': ('møte',),
'møtes': ('møte',),
'møtte': ('møte',),
'møtt': ('møte',),
'møt': ('møte',),
'møtes': ('møtes',),
'møttes': ('møtes',),
'møtes': ('møtes',),
'nage': ('nage',),
'nager': ('nage',),
'nages': ('nage',),
'naga': ('nage',),
'naget': ('nage',),
'nagde': ('nage',),
'naga': ('nage',),
'naget': ('nage',),
'nagd': ('nage',),
'nag': ('nage',),
'nagle': ('nagle',),
'nagler': ('nagle',),
'nagles': ('nagle',),
'nagla': ('nagle',),
'naglet': ('nagle',),
'nagla': ('nagle',),
'naglet': ('nagle',),
'nagl': ('nagle',),
'nagle': ('nagle',),
'nagl': ('nagle',),
'nagle': ('nagle',),
'nappe': ('nappe',),
'napper': ('nappe',),
'nappes': ('nappe',),
'nappa': ('nappe',),
'nappet': ('nappe',),
'nappa': ('nappe',),
'nappet': ('nappe',),
'napp': ('nappe',),
'narkotisere': ('narkotisere',),
'narkotiserer': ('narkotisere',),
'narkotiseres': ('narkotisere',),
'narkotiserte': ('narkotisere',),
'narkotisert': ('narkotisere',),
'narkotiser': ('narkotisere',),
'narre': ('narre',),
'narrer': ('narre',),
'narres': ('narre',),
'narra': ('narre',),
'narret': ('narre',),
'narra': ('narre',),
'narret': ('narre',),
'narr': ('narre',),
'nasalere': ('nasalere',),
'nasalerer': ('nasalere',),
'nasaleres': ('nasalere',),
'nasalerte': ('nasalere',),
'nasalert': ('nasalere',),
'nasaler': ('nasalere',),
'nasjonalisere': ('nasjonalisere',),
'nasjonaliserer': ('nasjonalisere',),
'nasjonaliseres': ('nasjonalisere',),
'nasjonaliserte': ('nasjonalisere',),
'nasjonalisert': ('nasjonalisere',),
'nasjonaliser': ('nasjonalisere',),
'naske': ('naske',),
'nasker': ('naske',),
'naskes': ('naske',),
'naska': ('naske',),
'nasket': ('naske',),
'naska': ('naske',),
'nasket': ('naske',),
'nask': ('naske',),
'nate': ('nate',),
'nater': ('nate',),
'nates': ('nate',),
'nata': ('nate',),
'natet': ('nate',),
'nata': ('nate',),
'natet': ('nate',),
'nat': ('nate',),
'natte': ('natte',),
'natter': ('natte',),
'nattes': ('natte',),
'natta': ('natte',),
'nattet': ('natte',),
'natta': ('natte',),
'nattet': ('natte',),
'natt': ('natte',),
'naturalisere': ('naturalisere',),
'naturaliserer': ('naturalisere',),
'naturaliseres': ('naturalisere',),
'naturaliserte': ('naturalisere',),
'naturalisert': ('naturalisere',),
'naturaliser': ('naturalisere',),
'naube': ('naube',),
'nauber': ('naube',),
'naubes': ('naube',),
'naubad': ('naube',),
'nauba': ('naube',),
'naubedt': ('naube',),
'naube': ('naube',),
'naue': ('naue',),
'nauer': ('naue',),
'naues': ('naue',),
'naua': ('naue',),
'nauet': ('naue',),
'naude': ('naue',),
'naua': ('naue',),
'nauet': ('naue',),
'naud': ('naue',),
'nau': ('naue',),
'navigere': ('navigere',),
'navigerer': ('navigere',),
'navigeres': ('navigere',),
'navigerte': ('navigere',),
'navigert': ('navigere',),
'naviger': ('navigere',),
'navle': ('navle',),
'navler': ('navle',),
'navles': ('navle',),
'navla': ('navle',),
'navlet': ('navle',),
'navla': ('navle',),
'navlet': ('navle',),
'navl': ('navle',),
'navle': ('navle',),
'navl': ('navle',),
'navle': ('navle',),
'navne': ('navne',),
'navner': ('navne',),
'navnes': ('navne',),
'navna': ('navne',),
'navnet': ('navne',),
'navna': ('navne',),
'navnet': ('navne',),
'navn': ('navne',),
'navngi': ('navngi',),
'navngir': ('navngi',),
'navngis': ('navngi',),
'navngav': ('navngi',),
'navnga': ('navngi',),
'navngitt': ('navngi',),
'navngi': ('navngi',),
'nazifisere': ('nazifisere',),
'nazifiserer': ('nazifisere',),
'nazifiseres': ('nazifisere',),
'nazifiserte': ('nazifisere',),
'nazifisert': ('nazifisere',),
'nazifiser': ('nazifisere',),
'nebbes': ('nebbes',),
'nebbedes': ('nebbes',),
'nebbes': ('nebbes',),
'nedarves': ('nedarves',),
'nedarvedes': ('nedarves',),
'nedarves': ('nedarves',),
'nedbryte': ('nedbryte',),
'nedbryter': ('nedbryte',),
'nedbrytes': ('nedbryte',),
'nedbrøt': ('nedbryte',),
'nedbrøyt': ('nedbryte',),
'nedbrutt': ('nedbryte',),
'nedbryt': ('nedbryte',),
'nedbygge': ('nedbygge',),
'nedbygger': ('nedbygge',),
'nedbygges': ('nedbygge',),
'nedbygget': ('nedbygge',),
'nedbygde': ('nedbygge',),
'nedbygget': ('nedbygge',),
'nedbygd': ('nedbygge',),
'nedbygg': ('nedbygge',),
'neddemme': ('neddemme',),
'neddemmer': ('neddemme',),
'neddemmes': ('neddemme',),
'neddemmet': ('neddemme',),
'neddemte': ('neddemme',),
'neddemmet': ('neddemme',),
'neddemt': ('neddemme',),
'neddem': ('neddemme',),
'nedfelle': ('nedfelle',),
'nedfeller': ('nedfelle',),
'nedfelles': ('nedfelle',),
'nedfelte': ('nedfelle',),
'nedfelt': ('nedfelle',),
'nedfell': ('nedfelle',),
'nedkalle': ('nedkalle',),
'nedkaller': ('nedkalle',),
'nedkalles': ('nedkalle',),
'nedkalte': ('nedkalle',),
'nedkalt': ('nedkalle',),
'nedkall': ('nedkalle',),
'nedkjempe': ('nedkjempe',),
'nedkjemper': ('nedkjempe',),
'nedkjempes': ('nedkjempe',),
'nedkjempa': ('nedkjempe',),
'nedkjempet': ('nedkjempe',),
'nedkjempa': ('nedkjempe',),
'nedkjempet': ('nedkjempe',),
'nedkjemp': ('nedkjempe',),
'nedkjøle': ('nedkjøle',),
'nedkjøler': ('nedkjøle',),
'nedkjøles': ('nedkjøle',),
'nedkjølte': ('nedkjøle',),
'nedkjølt': ('nedkjøle',),
'nedkjøl': ('nedkjøle',),
'nedkjøre': ('nedkjøre',),
'nedkjører': ('nedkjøre',),
'nedkjøres': ('nedkjøre',),
'nedkjørte': ('nedkjøre',),
'nedkjørt': ('nedkjøre',),
'nedkjør': ('nedkjøre',),
'nedkomme': ('nedkomme',),
'nedkommer': ('nedkomme',),
'nedkommes': ('nedkomme',),
'nedkom': ('nedkomme',),
'nedkommet': ('nedkomme',),
'nedkom': ('nedkomme',),
'nedlate': ('nedlate',),
'nedlater': ('nedlate',),
'nedlates': ('nedlate',),
'nedlot': ('nedlate',),
'nedlatt': ('nedlate',),
'nedlat': ('nedlate',),
'nedlegge': ('nedlegge',),
'nedlegger': ('nedlegge',),
'nedlegges': ('nedlegge',),
'nedla': ('nedlegge',),
'nedlagt': ('nedlegge',),
'nedlegg': ('nedlegge',),
'nedmolde': ('nedmolde',),
'nedmolder': ('nedmolde',),
'nedmoldes': ('nedmolde',),
'nedmolda': ('nedmolde',),
'nedmoldet': ('nedmolde',),
'nedmolda': ('nedmolde',),
'nedmoldet': ('nedmolde',),
'nedmold': ('nedmolde',),
'nedmulde': ('nedmulde',),
'nedmulder': ('nedmulde',),
'nedmuldes': ('nedmulde',),
'nedmulda': ('nedmulde',),
'nedmuldet': ('nedmulde',),
'nedmulda': ('nedmulde',),
'nedmuldet': ('nedmulde',),
'nedmuld': ('nedmulde',),
'nedprioritere': ('nedprioritere',),
'nedprioriterer': ('nedprioritere',),
'nedprioriteres': ('nedprioritere',),
'nedprioriterte': ('nedprioritere',),
'nedprioritert': ('nedprioritere',),
'nedprioriter': ('nedprioritere',),
'nedringe': ('nedringe',),
'nedringer': ('nedringe',),
'nedringes': ('nedringe',),
'nedringte': ('nedringe',),
'nedringt': ('nedringe',),
'nedring': ('nedringe',),
'nedsable': ('nedsable',),
'nedsabler': ('nedsable',),
'nedsables': ('nedsable',),
'nedsabla': ('nedsable',),
'nedsablet': ('nedsable',),
'nedsabla': ('nedsable',),
'nedsablet': ('nedsable',),
'nedsabl': ('nedsable',),
'nedsable': ('nedsable',),
'nedsabl': ('nedsable',),
'nedsable': ('nedsable',),
'nedsette': ('nedsette',),
'nedsetter': ('nedsette',),
'nedsettes': ('nedsette',),
'nedsatte': ('nedsette',),
'nedsatt': ('nedsette',),
'nedsett': ('nedsette',),
'nedskrive': ('nedskrive',),
'nedskriver': ('nedskrive',),
'nedskrives': ('nedskrive',),
'nedskrev': ('nedskrive',),
'nedskreiv': ('nedskrive',),
'nedskrev': ('nedskrive',),
'nedskreiv': ('nedskrive',),
'nedskrevet': ('nedskrive',),
'nedskriv': ('nedskrive',),
'nedstamme': ('nedstamme',),
'nedstammer': ('nedstamme',),
'nedstammes': ('nedstamme',),
'nedstamma': ('nedstamme',),
'nedstammet': ('nedstamme',),
'nedstamma': ('nedstamme',),
'nedstammet': ('nedstamme',),
'nedstam': ('nedstamme',),
'nedstemme': ('nedstemme',),
'nedstemmer': ('nedstemme',),
'nedstemmes': ('nedstemme',),
'nedstemte': ('nedstemme',),
'nedstemt': ('nedstemme',),
'nedstem': ('nedstemme',),
'nedtegne': ('nedtegne',),
'nedtegner': ('nedtegne',),
'nedtegnes': ('nedtegne',),
'nedtegna': ('nedtegne',),
'nedtegnet': ('nedtegne',),
'nedtegna': ('nedtegne',),
'nedtegnet': ('nedtegne',),
'nedtegn': ('nedtegne',),
'nedtrappe': ('nedtrappe',),
'nedtrapper': ('nedtrappe',),
'nedtrappes': ('nedtrappe',),
'nedtrappa': ('nedtrappe',),
'nedtrappet': ('nedtrappe',),
'nedtrappa': ('nedtrappe',),
'nedtrappet': ('nedtrappe',),
'nedtrapp': ('nedtrappe',),
'nedverdige': ('nedverdige',),
'nedverdiger': ('nedverdige',),
'nedverdiges': ('nedverdige',),
'nedverdiga': ('nedverdige',),
'nedverdiget': ('nedverdige',),
'nedverdiga': ('nedverdige',),
'nedverdiget': ('nedverdige',),
'nedverdig': ('nedverdige',),
'nedvurdere': ('nedvurdere',),
'nedvurderer': ('nedvurdere',),
'nedvurderes': ('nedvurdere',),
'nedvurderte': ('nedvurdere',),
'nedvurdert': ('nedvurdere',),
'nedvurder': ('nedvurdere',),
'negere': ('negere',),
'negerer': ('negere',),
'negeres': ('negere',),
'negerte': ('negere',),
'negert': ('negere',),
'neger': ('negere',),
'neglisjere': ('neglisjere',),
'neglisjerer': ('neglisjere',),
'neglisjeres': ('neglisjere',),
'neglisjerte': ('neglisjere',),
'neglisjert': ('neglisjere',),
'neglisjer': ('neglisjere',),
'neie': ('neie',),
'neier': ('neie',),
'neies': ('neie',),
'neia': ('neie',),
'neiet': ('neie',),
'neide': ('neie',),
'neia': ('neie',),
'neiet': ('neie',),
'neid': ('neie',),
'nei': ('neie',),
'neie': ('neie',),
'neier': ('neie',),
'neies': ('neie',),
'neide': ('neie',),
'neid': ('neie',),
'nei': ('neie',),
'nekte': ('nekte',),
'nekter': ('nekte',),
'nektes': ('nekte',),
'nekta': ('nekte',),
'nektet': ('nekte',),
'nekta': ('nekte',),
'nektet': ('nekte',),
'nekt': ('nekte',),
'nenne': ('nenne',),
'nenner': ('nenne',),
'nennes': ('nenne',),
'nenna': ('nenne',),
'nennet': ('nenne',),
'nente': ('nenne',),
'nenna': ('nenne',),
'nennet': ('nenne',),
'nent': ('nenne',),
'nenn': ('nenne',),
'neste': ('neste',),
'nester': ('neste',),
'nestes': ('neste',),
'nesta': ('neste',),
'nestet': ('neste',),
'nesta': ('neste',),
'nestet': ('neste',),
'nest': ('neste',),
'nette': ('nette',),
'netter': ('nette',),
'nettes': ('nette',),
'netta': ('nette',),
'nettet': ('nette',),
'netta': ('nette',),
'nettet': ('nette',),
'nett': ('nette',),
'nevehilse': ('nevehilse',),
'nevehilser': ('nevehilse',),
'nevehilses': ('nevehilse',),
'nevehilste': ('nevehilse',),
'nevehilst': ('nevehilse',),
'nevehils': ('nevehilse',),
'nevetakes': ('nevetakes',),
'nevetokes': ('nevetakes',),
'nevetakes': ('nevetakes',),
'nevne': ('nevne',),
'nevner': ('nevne',),
'nevnes': ('nevne',),
'nevnte': ('nevne',),
'nevnt': ('nevne',),
'nevn': ('nevne',),
'nidoble': ('nidoble',),
'nidobler': ('nidoble',),
'nidobles': ('nidoble',),
'nidobla': ('nidoble',),
'nidoblet': ('nidoble',),
'nidobla': ('nidoble',),
'nidoblet': ('nidoble',),
'nidobl': ('nidoble',),
'nidoble': ('nidoble',),
'nidobl': ('nidoble',),
'nidoble': ('nidoble',),
'niholde': ('niholde',),
'niholder': ('niholde',),
'niholdes': ('niholde',),
'niholdt': ('niholde',),
'nihold': ('niholde',),
'nikke': ('nikke',),
'nikker': ('nikke',),
'nikkes': ('nikke',),
'nikka': ('nikke',),
'nikket': ('nikke',),
'nikka': ('nikke',),
'nikket': ('nikke',),
'nikk': ('nikke',),
'nippe': ('nippe',),
'nipper': ('nippe',),
'nippes': ('nippe',),
'nippa': ('nippe',),
'nippet': ('nippe',),
'nippa': ('nippe',),
'nippet': ('nippe',),
'nipp': ('nippe',),
'nisse': ('nisse',),
'nisser': ('nisse',),
'nisses': ('nisse',),
'nissa': ('nisse',),
'nisset': ('nisse',),
'nissa': ('nisse',),
'nisset': ('nisse',),
'niss': ('nisse',),
'niste': ('niste',),
'nister': ('niste',),
'nistes': ('niste',),
'nista': ('niste',),
'nistet': ('niste',),
'nista': ('niste',),
'nistet': ('niste',),
'nist': ('niste',),
'nistirre': ('nistirre',),
'nistirrer': ('nistirre',),
'nistirres': ('nistirre',),
'nistirra': ('nistirre',),
'nistirret': ('nistirre',),
'nistirra': ('nistirre',),
'nistirret': ('nistirre',),
'nistirr': ('nistirre',),
'nitrere': ('nitrere',),
'nitrerer': ('nitrere',),
'nitreres': ('nitrere',),
'nitrerte': ('nitrere',),
'nitrert': ('nitrere',),
'nitrer': ('nitrere',),
'nitrifisere': ('nitrifisere',),
'nitrifiserer': ('nitrifisere',),
'nitrifiseres': ('nitrifisere',),
'nitrifiserte': ('nitrifisere',),
'nitrifisert': ('nitrifisere',),
'nitrifiser': ('nitrifisere',),
'nitte': ('nitte',),
'nitter': ('nitte',),
'nittes': ('nitte',),
'nitta': ('nitte',),
'nittet': ('nitte',),
'nitta': ('nitte',),
'nittet': ('nitte',),
'nitt': ('nitte',),
'nivellere': ('nivellere',),
'nivellerer': ('nivellere',),
'nivelleres': ('nivellere',),
'nivellerte': ('nivellere',),
'nivellert': ('nivellere',),
'niveller': ('nivellere',),
'nomadisere': ('nomadisere',),
'nomadiserer': ('nomadisere',),
'nomadiseres': ('nomadisere',),
'nomadiserte': ('nomadisere',),
'nomadisert': ('nomadisere',),
'nomadiser': ('nomadisere',),
'nominere': ('nominere',),
'nominerer': ('nominere',),
'nomineres': ('nominere',),
'nominerte': ('nominere',),
'nominert': ('nominere',),
'nominer': ('nominere',),
'nonchalere': ('nonchalere',),
'nonchalerer': ('nonchalere',),
'nonchaleres': ('nonchalere',),
'nonchalerte': ('nonchalere',),
'nonchalert': ('nonchalere',),
'nonchaler': ('nonchalere',),
'normalisere': ('normalisere',),
'normaliserer': ('normalisere',),
'normaliseres': ('normalisere',),
'normaliserte': ('normalisere',),
'normalisert': ('normalisere',),
'normaliser': ('normalisere',),
'normere': ('normere',),
'normerer': ('normere',),
'normeres': ('normere',),
'normerte': ('normere',),
'normert': ('normere',),
'normer': ('normere',),
'norske': ('norske',),
'norsker': ('norske',),
'norskes': ('norske',),
'norska': ('norske',),
'norsket': ('norske',),
'norska': ('norske',),
'norsket': ('norske',),
'norsk': ('norske',),
'notere': ('notere',),
'noterer': ('notere',),
'noteres': ('notere',),
'noterte': ('notere',),
'notert': ('notere',),
'noter': ('notere',),
'notifisere': ('notifisere',),
'notifiserer': ('notifisere',),
'notifiseres': ('notifisere',),
'notifiserte': ('notifisere',),
'notifisert': ('notifisere',),
'notifiser': ('notifisere',),
'nubbe': ('nubbe',),
'nubber': ('nubbe',),
'nubbes': ('nubbe',),
'nubba': ('nubbe',),
'nubbet': ('nubbe',),
'nubba': ('nubbe',),
'nubbet': ('nubbe',),
'nubb': ('nubbe',),
'nudde': ('nudde',),
'nudder': ('nudde',),
'nuddes': ('nudde',),
'nudda': ('nudde',),
'nuddet': ('nudde',),
'nudda': ('nudde',),
'nuddet': ('nudde',),
'nudd': ('nudde',),
'nufse': ('nufse',),
'nufser': ('nufse',),
'nufses': ('nufse',),
'nufsa': ('nufse',),
'nufset': ('nufse',),
'nufste': ('nufse',),
'nufsa': ('nufse',),
'nufset': ('nufse',),
'nufst': ('nufse',),
'nufs': ('nufse',),
'nugge': ('nugge',),
'nugger': ('nugge',),
'nugges': ('nugge',),
'nugga': ('nugge',),
'nugget': ('nugge',),
'nugde': ('nugge',),
'nugga': ('nugge',),
'nugget': ('nugge',),
'nugd': ('nugge',),
'nugg': ('nugge',),
'nulle': ('nulle',),
'nuller': ('nulle',),
'nulles': ('nulle',),
'nulla': ('nulle',),
'nullet': ('nulle',),
'nulla': ('nulle',),
'nullet': ('nulle',),
'null': ('nulle',),
'nummerere': ('nummerere',),
'nummererer': ('nummerere',),
'nummereres': ('nummerere',),
'nummererte': ('nummerere',),
'nummerert': ('nummerere',),
'nummerer': ('nummerere',),
'nuppe': ('nuppe',),
'nupper': ('nuppe',),
'nuppes': ('nuppe',),
'nuppa': ('nuppe',),
'nuppet': ('nuppe',),
'nuppa': ('nuppe',),
'nuppet': ('nuppe',),
'nupp': ('nuppe',),
'nupre': ('nupre',),
'nuprer': ('nupre',),
'nupres': ('nupre',),
'nupra': ('nupre',),
'nupret': ('nupre',),
'nupra': ('nupre',),
'nupret': ('nupre',),
'nupr': ('nupre',),
'nupre': ('nupre',),
'nupr': ('nupre',),
'nupre': ('nupre',),
'nuske': ('nuske',),
'nusker': ('nuske',),
'nuskes': ('nuske',),
'nuska': ('nuske',),
'nusket': ('nuske',),
'nuska': ('nuske',),
'nusket': ('nuske',),
'nusk': ('nuske',),
'nusle': ('nusle',),
'nusler': ('nusle',),
'nusles': ('nusle',),
'nusla': ('nusle',),
'nuslet': ('nusle',),
'nusla': ('nusle',),
'nuslet': ('nusle',),
'nusl': ('nusle',),
'nusle': ('nusle',),
'nusl': ('nusle',),
'nusle': ('nusle',),
'nusse': ('nusse',),
'nusser': ('nusse',),
'nusses': ('nusse',),
'nussa': ('nusse',),
'nusset': ('nusse',),
'nussa': ('nusse',),
'nusset': ('nusse',),
'nuss': ('nusse',),
'nyansere': ('nyansere',),
'nyanserer': ('nyansere',),
'nyanseres': ('nyansere',),
'nyanserte': ('nyansere',),
'nyansert': ('nyansere',),
'nyanser': ('nyansere',),
'nydanne': ('nydanne',),
'nydanner': ('nydanne',),
'nydannes': ('nydanne',),
'nydanna': ('nydanne',),
'nydannet': ('nydanne',),
'nydanna': ('nydanne',),
'nydannet': ('nydanne',),
'nydann': ('nydanne',),
'nydyrke': ('nydyrke',),
'nydyrker': ('nydyrke',),
'nydyrkes': ('nydyrke',),
'nydyrka': ('nydyrke',),
'nydyrket': ('nydyrke',),
'nydyrka': ('nydyrke',),
'nydyrket': ('nydyrke',),
'nydyrk': ('nydyrke',),
'nye': ('nye',),
'nyer': ('nye',),
'nyes': ('nye',),
'nya': ('nye',),
'nyet': ('nye',),
'nya': ('nye',),
'nyet': ('nye',),
'ny': ('nye',),
'nykke': ('nykke',),
'nykker': ('nykke',),
'nykkes': ('nykke',),
'nykka': ('nykke',),
'nykket': ('nykke',),
'nykte': ('nykke',),
'nykka': ('nykke',),
'nykket': ('nykke',),
'nykt': ('nykke',),
'nykk': ('nykke',),
'nynne': ('nynne',),
'nynner': ('nynne',),
'nynnes': ('nynne',),
'nynna': ('nynne',),
'nynnet': ('nynne',),
'nynna': ('nynne',),
'nynnet': ('nynne',),
'nynn': ('nynne',),
'nype': ('nype',),
'nyper': ('nype',),
'nypes': ('nype',),
'nypte': ('nype',),
'nypt': ('nype',),
'nyp': ('nype',),
'nyrydde': ('nyrydde',),
'nyrydder': ('nyrydde',),
'nyryddes': ('nyrydde',),
'nyrydda': ('nyrydde',),
'nyryddet': ('nyrydde',),
'nyrydda': ('nyrydde',),
'nyryddet': ('nyrydde',),
'nyrydd': ('nyrydde',),
'nyse': ('nyse',),
'nyser': ('nyse',),
'nyses': ('nyse',),
'nyste': ('nyse',),
'nøys': ('nyse',),
'nøs': ('nyse',),
'nyst': ('nyse',),
'nys': ('nyse',),
'nyskape': ('nyskape',),
'nyskaper': ('nyskape',),
'nyskapes': ('nyskape',),
'nyskapte': ('nyskape',),
'nyskapt': ('nyskape',),
'nyskap': ('nyskape',),
'nyte': ('nyte',),
'nyter': ('nyte',),
'nytes': ('nyte',),
'nøyt': ('nyte',),
'nøt': ('nyte',),
'nytt': ('nyte',),
'nyt': ('nyte',),
'nytte': ('nytte',),
'nytter': ('nytte',),
'nyttes': ('nytte',),
'nytta': ('nytte',),
'nyttet': ('nytte',),
'nytta': ('nytte',),
'nyttet': ('nytte',),
'nytt': ('nytte',),
'nyttiggjøre': ('nyttiggjøre',),
'nyttiggjør': ('nyttiggjøre',),
'nyttiggjøres': ('nyttiggjøre',),
'nyttiggjorde': ('nyttiggjøre',),
'nyttiggjort': ('nyttiggjøre',),
'nyttiggjør': ('nyttiggjøre',),
'nyve': ('nyve',),
'nyver': ('nyve',),
'nyves': ('nyve',),
'nyvde': ('nyve',),
'nyvd': ('nyve',),
'nyv': ('nyve',),
'nå': ('nå',),
'når': ('nå',),
'nås': ('nå',),
'nådde': ('nå',),
'nådd': ('nå',),
'nå': ('nå',),
'nåde': ('nåde',),
'nåtle': ('nåtle',),
'nåtler': ('nåtle',),
'nåtles': ('nåtle',),
'nåtla': ('nåtle',),
'nåtlet': ('nåtle',),
'nåtla': ('nåtle',),
'nåtlet': ('nåtle',),
'nåtl': ('nåtle',),
'nåtle': ('nåtle',),
'nåtl': ('nåtle',),
'nåtle': ('nåtle',),
'nære': ('nære',),
'nærer': ('nære',),
'næres': ('nære',),
'næret': ('nære',),
'nærte': ('nære',),
'næret': ('nære',),
'nært': ('nære',),
'nær': ('nære',),
'nærlese': ('nærlese',),
'nærleser': ('nærlese',),
'nærleses': ('nærlese',),
'nærleste': ('nærlese',),
'nærlest': ('nærlese',),
'nærles': ('nærlese',),
'nærme': ('nærme',),
'nærmer': ('nærme',),
'nærmes': ('nærme',),
'nærma': ('nærme',),
'nærmet': ('nærme',),
'nærma': ('nærme',),
'nærmet': ('nærme',),
'nærm': ('nærme',),
'nøde': ('nøde',),
'nøder': ('nøde',),
'nødes': ('nøde',),
'nøda': ('nøde',),
'nødet': ('nøde',),
'nødde': ('nøde',),
'nøda': ('nøde',),
'nødet': ('nøde',),
'nødd': ('nøde',),
'nød': ('nøde',),
'nødlande': ('nødlande',),
'nødlander': ('nødlande',),
'nødlandes': ('nødlande',),
'nødlanda': ('nødlande',),
'nødlandet': ('nødlande',),
'nødlanda': ('nødlande',),
'nødlandet': ('nødlande',),
'nødland': ('nødlande',),
'nødslakte': ('nødslakte',),
'nødslakter': ('nødslakte',),
'nødslaktes': ('nødslakte',),
'nødslakta': ('nødslakte',),
'nødslaktet': ('nødslakte',),
'nødslakta': ('nødslakte',),
'nødslaktet': ('nødslakte',),
'nødslakt': ('nødslakte',),
'nødvendiggjøre': ('nødvendiggjøre',),
'nødvendiggjør': ('nødvendiggjøre',),
'nødvendiggjøres': ('nødvendiggjøre',),
'nødvendiggjorde': ('nødvendiggjøre',),
'nødvendiggjort': ('nødvendiggjøre',),
'nødvendiggjør': ('nødvendiggjøre',),
'nøffe': ('nøffe',),
'nøffer': ('nøffe',),
'nøffes': ('nøffe',),
'nøffa': ('nøffe',),
'nøffet': ('nøffe',),
'nøffa': ('nøffe',),
'nøffet': ('nøffe',),
'nøff': ('nøffe',),
'nøle': ('nøle',),
'nøler': ('nøle',),
'nøles': ('nøle',),
'nølte': ('nøle',),
'nølt': ('nøle',),
'nøl': ('nøle',),
'nøre': ('nøre',),
'nører': ('nøre',),
'nøres': ('nøre',),
'nøret': ('nøre',),
'nørte': ('nøre',),
'nøret': ('nøre',),
'nørt': ('nøre',),
'nør': ('nøre',),
'nøste': ('nøste',),
'nøster': ('nøste',),
'nøstes': ('nøste',),
'nøsta': ('nøste',),
'nøstet': ('nøste',),
'nøsta': ('nøste',),
'nøstet': ('nøste',),
'nøst': ('nøste',),
'nøye': ('nøye',),
'nøyer': ('nøye',),
'nøyes': ('nøye',),
'nøyde': ('nøye',),
'nøyd': ('nøye',),
'nøy': ('nøye',),
'nøyte': ('nøyte',),
'nøyter': ('nøyte',),
'nøytes': ('nøyte',),
'nøytte': ('nøyte',),
'nøytt': ('nøyte',),
'nøyt': ('nøyte',),
'nøytralisere': ('nøytralisere',),
'nøytraliserer': ('nøytralisere',),
'nøytraliseres': ('nøytralisere',),
'nøytraliserte': ('nøytralisere',),
'nøytralisert': ('nøytralisere',),
'nøytraliser': ('nøytralisere',),
'obdusere': ('obdusere',),
'obduserer': ('obdusere',),
'obduseres': ('obdusere',),
'obduserte': ('obdusere',),
'obdusert': ('obdusere',),
'obduser': ('obdusere',),
'objektivere': ('objektivere',),
'objektiverer': ('objektivere',),
'objektiveres': ('objektivere',),
'objektiverte': ('objektivere',),
'objektivert': ('objektivere',),
'objektiver': ('objektivere',),
'observere': ('observere',),
'observerer': ('observere',),
'observeres': ('observere',),
'observerte': ('observere',),
'observert': ('observere',),
'observer': ('observere',),
'obstruere': ('obstruere',),
'obstruerer': ('obstruere',),
'obstrueres': ('obstruere',),
'obstruerte': ('obstruere',),
'obstruert': ('obstruere',),
'obstruer': ('obstruere',),
'odle': ('odle',),
'odler': ('odle',),
'odles': ('odle',),
'odla': ('odle',),
'odlet': ('odle',),
'odla': ('odle',),
'odlet': ('odle',),
'odl': ('odle',),
'odle': ('odle',),
'odl': ('odle',),
'odle': ('odle',),
'offerere': ('offerere',),
'offererer': ('offerere',),
'offereres': ('offerere',),
'offererte': ('offerere',),
'offerert': ('offerere',),
'offerer': ('offerere',),
'ofre': ('ofre',),
'ofrer': ('ofre',),
'ofres': ('ofre',),
'ofra': ('ofre',),
'ofret': ('ofre',),
'ofra': ('ofre',),
'ofret': ('ofre',),
'ofr': ('ofre',),
'ofre': ('ofre',),
'ofr': ('ofre',),
'ofre': ('ofre',),
'oie': ('oie',),
'oier': ('oie',),
'oies': ('oie',),
'oia': ('oie',),
'oiet': ('oie',),
'oia': ('oie',),
'oiet': ('oie',),
'oi': ('oie',),
'okke': ('okke',),
'okker': ('okke',),
'okkes': ('okke',),
'okka': ('okke',),
'okket': ('okke',),
'okka': ('okke',),
'okket': ('okke',),
'okk': ('okke',),
'okkultere': ('okkultere',),
'okkulterer': ('okkultere',),
'okkulteres': ('okkultere',),
'okkulterte': ('okkultere',),
'okkultert': ('okkultere',),
'okkulter': ('okkultere',),
'okkupere': ('okkupere',),
'okkuperer': ('okkupere',),
'okkuperes': ('okkupere',),
'okkuperte': ('okkupere',),
'okkupert': ('okkupere',),
'okkuper': ('okkupere',),
'oksidere': ('oksidere',),
'oksiderer': ('oksidere',),
'oksideres': ('oksidere',),
'oksiderte': ('oksidere',),
'oksidert': ('oksidere',),
'oksider': ('oksidere',),
'okulere': ('okulere',),
'okulerer': ('okulere',),
'okuleres': ('okulere',),
'okulerte': ('okulere',),
'okulert': ('okulere',),
'okuler': ('okulere',),
'olje': ('olje',),
'oljer': ('olje',),
'oljes': ('olje',),
'olja': ('olje',),
'oljet': ('olje',),
'olja': ('olje',),
'oljet': ('olje',),
'olj': ('olje',),
'olme': ('olme',),
'olmer': ('olme',),
'olmes': ('olme',),
'olma': ('olme',),
'olmet': ('olme',),
'olma': ('olme',),
'olmet': ('olme',),
'olm': ('olme',),
'omadressere': ('omadressere',),
'omadresserer': ('omadressere',),
'omadresseres': ('omadressere',),
'omadresserte': ('omadressere',),
'omadressert': ('omadressere',),
'omadresser': ('omadressere',),
'omarbeide': ('omarbeide',),
'omarbeider': ('omarbeide',),
'omarbeides': ('omarbeide',),
'omarbeida': ('omarbeide',),
'omarbeidet': ('omarbeide',),
'omarbeidde': ('omarbeide',),
'omarbeida': ('omarbeide',),
'omarbeidet': ('omarbeide',),
'omarbeidd': ('omarbeide',),
'omarbeid': ('omarbeide',),
'ombestemme': ('ombestemme',),
'ombestemmer': ('ombestemme',),
'ombestemmes': ('ombestemme',),
'ombestemte': ('ombestemme',),
'ombestemt': ('ombestemme',),
'ombestem': ('ombestemme',),
'ombrekke': ('ombrekke',),
'ombrekker': ('ombrekke',),
'ombrekkes': ('ombrekke',),
'ombrakk': ('ombrekke',),
'ombrukket': ('ombrekke',),
'ombrekk': ('ombrekke',),
'ombringe': ('ombringe',),
'ombringer': ('ombringe',),
'ombringes': ('ombringe',),
'ombrakte': ('ombringe',),
'ombrakt': ('ombringe',),
'ombring': ('ombringe',),
'ombære': ('ombære',),
'ombærer': ('ombære',),
'ombæres': ('ombære',),
'ombar': ('ombære',),
'ombåret': ('ombære',),
'ombær': ('ombære',),
'omdanne': ('omdanne',),
'omdanner': ('omdanne',),
'omdannes': ('omdanne',),
'omdanna': ('omdanne',),
'omdannet': ('omdanne',),
'omdanna': ('omdanne',),
'omdannet': ('omdanne',),
'omdann': ('omdanne',),
'omfatte': ('omfatte',),
'omfatter': ('omfatte',),
'omfattes': ('omfatte',),
'omfatta': ('omfatte',),
'omfattet': ('omfatte',),
'omfatta': ('omfatte',),
'omfattet': ('omfatte',),
'omfatt': ('omfatte',),
'omfavne': ('omfavne',),
'omfavner': ('omfavne',),
'omfavnes': ('omfavne',),
'omfavna': ('omfavne',),
'omfavnet': ('omfavne',),
'omfavna': ('omfavne',),
'omfavnet': ('omfavne',),
'omfavn': ('omfavne',),
'omforme': ('omforme',),
'omformer': ('omforme',),
'omformes': ('omforme',),
'omforma': ('omforme',),
'omformet': ('omforme',),
'omforma': ('omforme',),
'omformet': ('omforme',),
'omform': ('omforme',),
'omgi': ('omgi',),
'omgir': ('omgi',),
'omgis': ('omgi',),
'omgav': ('omgi',),
'omga': ('omgi',),
'omgitt': ('omgi',),
'omgi': ('omgi',),
'omgjøre': ('omgjøre',),
'omgjør': ('omgjøre',),
'omgjøres': ('omgjøre',),
'omgjorde': ('omgjøre',),
'omgjort': ('omgjøre',),
'omgjør': ('omgjøre',),
'omgå': ('omgå',),
'omgår': ('omgå',),
'omgås': ('omgå',),
'omgikk': ('omgå',),
'omgått': ('omgå',),
'omgå': ('omgå',),
'omgås': ('omgås',),
'omgikkes': ('omgås',),
'omgåttes': ('omgås',),
'omgås': ('omgås',),
'omhandle': ('omhandle',),
'omhandler': ('omhandle',),
'omhandles': ('omhandle',),
'omhandla': ('omhandle',),
'omhandlet': ('omhandle',),
'omhandla': ('omhandle',),
'omhandlet': ('omhandle',),
'omhandl': ('omhandle',),
'omhandle': ('omhandle',),
'omhandl': ('omhandle',),
'omhandle': ('omhandle',),
'ominnrede': ('ominnrede',),
'ominnreder': ('ominnrede',),
'ominnredes': ('ominnrede',),
'ominnreda': ('ominnrede',),
'ominnredet': ('ominnrede',),
'ominnreda': ('ominnrede',),
'ominnredet': ('ominnrede',),
'ominnred': ('ominnrede',),
'omkalfatre': ('omkalfatre',),
'omkalfatrer': ('omkalfatre',),
'omkalfatres': ('omkalfatre',),
'omkalfatra': ('omkalfatre',),
'omkalfatret': ('omkalfatre',),
'omkalfatra': ('omkalfatre',),
'omkalfatret': ('omkalfatre',),
'omkalfatr': ('omkalfatre',),
'omkalfatre': ('omkalfatre',),
'omkalfatr': ('omkalfatre',),
'omkalfatre': ('omkalfatre',),
'omkomme': ('omkomme',),
'omkommer': ('omkomme',),
'omkommes': ('omkomme',),
'omkom': ('omkomme',),
'omkommet': ('omkomme',),
'omkom': ('omkomme',),
'ommøblere': ('ommøblere',),
'ommøblerer': ('ommøblere',),
'ommøbleres': ('ommøblere',),
'ommøblerte': ('ommøblere',),
'ommøblert': ('ommøblere',),
'ommøbler': ('ommøblere',),
'omorganisere': ('omorganisere',),
'omorganiserer': ('omorganisere',),
'omorganiseres': ('omorganisere',),
'omorganiserte': ('omorganisere',),
'omorganisert': ('omorganisere',),
'omorganiser': ('omorganisere',),
'omplante': ('omplante',),
'omplanter': ('omplante',),
'omplantes': ('omplante',),
'omplanta': ('omplante',),
'omplantet': ('omplante',),
'omplanta': ('omplante',),
'omplantet': ('omplante',),
'omplant': ('omplante',),
'ompotte': ('ompotte',),
'ompotter': ('ompotte',),
'ompottes': ('ompotte',),
'ompotta': ('ompotte',),
'ompottet': ('ompotte',),
'ompotta': ('ompotte',),
'ompottet': ('ompotte',),
'ompott': ('ompotte',),
'omprikle': ('omprikle',),
'omprikler': ('omprikle',),
'omprikles': ('omprikle',),
'omprikla': ('omprikle',),
'ompriklet': ('omprikle',),
'omprikla': ('omprikle',),
'ompriklet': ('omprikle',),
'omprikl': ('omprikle',),
'omprikle': ('omprikle',),
'omprikl': ('omprikle',),
'omprikle': ('omprikle',),
'omprioritere': ('omprioritere',),
'omprioriterer': ('omprioritere',),
'omprioriteres': ('omprioritere',),
'omprioriterte': ('omprioritere',),
'omprioritert': ('omprioritere',),
'omprioriter': ('omprioritere',),
'omprøve': ('omprøve',),
'omprøver': ('omprøve',),
'omprøves': ('omprøve',),
'omprøvde': ('omprøve',),
'omprøvd': ('omprøve',),
'omprøv': ('omprøve',),
'omramme': ('omramme',),
'omrammer': ('omramme',),
'omrammes': ('omramme',),
'omramma': ('omramme',),
'omrammet': ('omramme',),
'omramma': ('omramme',),
'omrammet': ('omramme',),
'omram': ('omramme',),
'omredigere': ('omredigere',),
'omredigerer': ('omredigere',),
'omredigeres': ('omredigere',),
'omredigerte': ('omredigere',),
'omredigert': ('omredigere',),
'omrediger': ('omredigere',),
'omregne': ('omregne',),
'omregner': ('omregne',),
'omregnes': ('omregne',),
'omregna': ('omregne',),
'omregnet': ('omregne',),
'omregna': ('omregne',),
'omregnet': ('omregne',),
'omregn': ('omregne',),
'omringe': ('omringe',),
'omringer': ('omringe',),
'omringes': ('omringe',),
'omringa': ('omringe',),
'omringet': ('omringe',),
'omringa': ('omringe',),
'omringet': ('omringe',),
'omring': ('omringe',),
'områ': ('områ',),
'områr': ('områ',),
'områs': ('områ',),
'områdde': ('områ',),
'områdd': ('områ',),
'områ': ('områ',),
'omrømme': ('omrømme',),
'omrømmer': ('omrømme',),
'omrømmes': ('omrømme',),
'omrømma': ('omrømme',),
'omrømmet': ('omrømme',),
'omrømma': ('omrømme',),
'omrømmet': ('omrømme',),
'omrøm': ('omrømme',),
'omsette': ('omsette',),
'omsetter': ('omsette',),
'omsettes': ('omsette',),
'omsatte': ('omsette',),
'omsatt': ('omsette',),
'omsett': ('omsette',),
'omskape': ('omskape',),
'omskaper': ('omskape',),
'omskapes': ('omskape',),
'omskapte': ('omskape',),
'omskapt': ('omskape',),
'omskap': ('omskape',),
'omskjære': ('omskjære',),
'omskjærer': ('omskjære',),
'omskjæres': ('omskjære',),
'omskar': ('omskjære',),
'omskåret': ('omskjære',),
'omskjær': ('omskjære',),
'omskole': ('omskole',),
'omskoler': ('omskole',),
'omskoles': ('omskole',),
'omskolte': ('omskole',),
'omskolt': ('omskole',),
'omskol': ('omskole',),
'omskolere': ('omskolere',),
'omskolerer': ('omskolere',),
'omskoleres': ('omskolere',),
'omskolerte': ('omskolere',),
'omskolert': ('omskolere',),
'omskoler': ('omskolere',),
'omskrive': ('omskrive',),
'omskriver': ('omskrive',),
'omskrives': ('omskrive',),
'omskrev': ('omskrive',),
'omskreiv': ('omskrive',),
'omskrev': ('omskrive',),
'omskreiv': ('omskrive',),
'omskrevet': ('omskrive',),
'omskriv': ('omskrive',),
'omslutte': ('omslutte',),
'omslutter': ('omslutte',),
'omsluttes': ('omslutte',),
'omslutta': ('omslutte',),
'omsluttet': ('omslutte',),
'omslutta': ('omslutte',),
'omsluttet': ('omslutte',),
'omslutt': ('omslutte',),
'omslynge': ('omslynge',),
'omslynger': ('omslynge',),
'omslynges': ('omslynge',),
'omslynga': ('omslynge',),
'omslynget': ('omslynge',),
'omslyngte': ('omslynge',),
'omslynga': ('omslynge',),
'omslynget': ('omslynge',),
'omslyngt': ('omslynge',),
'omslyng': ('omslynge',),
'omstille': ('omstille',),
'omstiller': ('omstille',),
'omstilles': ('omstille',),
'omstilte': ('omstille',),
'omstilt': ('omstille',),
'omstill': ('omstille',),
'omstrukturere': ('omstrukturere',),
'omstrukturerer': ('omstrukturere',),
'omstruktureres': ('omstrukturere',),
'omstrukturerte': ('omstrukturere',),
'omstrukturert': ('omstrukturere',),
'omstrukturer': ('omstrukturere',),
'omstyrte': ('omstyrte',),
'omstyrter': ('omstyrte',),
'omstyrtes': ('omstyrte',),
'omstyrta': ('omstyrte',),
'omstyrtet': ('omstyrte',),
'omstyrta': ('omstyrte',),
'omstyrtet': ('omstyrte',),
'omstyrt': ('omstyrte',),
'omstøte': ('omstøte',),
'omstøter': ('omstøte',),
'omstøtes': ('omstøte',),
'omstøtte': ('omstøte',),
'omstøtt': ('omstøte',),
'omstøt': ('omstøte',),
'omtale': ('omtale',),
'omtaler': ('omtale',),
'omtales': ('omtale',),
'omtalte': ('omtale',),
'omtalt': ('omtale',),
'omtal': ('omtale',),
'omvandle': ('omvandle',),
'omvandler': ('omvandle',),
'omvandles': ('omvandle',),
'omvandla': ('omvandle',),
'omvandlet': ('omvandle',),
'omvandla': ('omvandle',),
'omvandlet': ('omvandle',),
'omvandl': ('omvandle',),
'omvandle': ('omvandle',),
'omvandl': ('omvandle',),
'omvandle': ('omvandle',),
'omvelte': ('omvelte',),
'omvelter': ('omvelte',),
'omveltes': ('omvelte',),
'omvelta': ('omvelte',),
'omveltet': ('omvelte',),
'omvelta': ('omvelte',),
'omveltet': ('omvelte',),
'omvelt': ('omvelte',),
'omvende': ('omvende',),
'omvender': ('omvende',),
'omvendes': ('omvende',),
'omvendte': ('omvende',),
'omvendt': ('omvende',),
'omvend': ('omvende',),
'omvurdere': ('omvurdere',),
'omvurderer': ('omvurdere',),
'omvurderes': ('omvurdere',),
'omvurderte': ('omvurdere',),
'omvurdert': ('omvurdere',),
'omvurder': ('omvurdere',),
'omvøle': ('omvøle',),
'omvøler': ('omvøle',),
'omvøles': ('omvøle',),
'omvølte': ('omvøle',),
'omvølt': ('omvøle',),
'omvøl': ('omvøle',),
'onanere': ('onanere',),
'onanerer': ('onanere',),
'onaneres': ('onanere',),
'onanerte': ('onanere',),
'onanert': ('onanere',),
'onaner': ('onanere',),
'ondulere': ('ondulere',),
'ondulerer': ('ondulere',),
'onduleres': ('ondulere',),
'ondulerte': ('ondulere',),
'ondulert': ('ondulere',),
'onduler': ('ondulere',),
'onne': ('onne',),
'onner': ('onne',),
'onnes': ('onne',),
'onna': ('onne',),
'onnet': ('onne',),
'onna': ('onne',),
'onnet': ('onne',),
'onn': ('onne',),
'opalescere': ('opalescere',),
'opalescerer': ('opalescere',),
'opalesceres': ('opalescere',),
'opalescerte': ('opalescere',),
'opalescert': ('opalescere',),
'opalescer': ('opalescere',),
'opalisere': ('opalisere',),
'opaliserer': ('opalisere',),
'opaliseres': ('opalisere',),
'opaliserte': ('opalisere',),
'opalisert': ('opalisere',),
'opaliser': ('opalisere',),
'operasjonalisere': ('operasjonalisere',),
'operasjonaliserer': ('operasjonalisere',),
'operasjonaliseres': ('operasjonalisere',),
'operasjonaliserte': ('operasjonalisere',),
'operasjonalisert': ('operasjonalisere',),
'operasjonaliser': ('operasjonalisere',),
'operere': ('operere',),
'opererer': ('operere',),
'opereres': ('operere',),
'opererte': ('operere',),
'operert': ('operere',),
'operer': ('operere',),
'opparbeide': ('opparbeide',),
'opparbeider': ('opparbeide',),
'opparbeides': ('opparbeide',),
'opparbeida': ('opparbeide',),
'opparbeidet': ('opparbeide',),
'opparbeidde': ('opparbeide',),
'opparbeida': ('opparbeide',),
'opparbeidet': ('opparbeide',),
'opparbeidd': ('opparbeide',),
'opparbeid': ('opparbeide',),
'oppbevare': ('oppbevare',),
'oppbevarer': ('oppbevare',),
'oppbevares': ('oppbevare',),
'oppbevarte': ('oppbevare',),
'oppbevart': ('oppbevare',),
'oppbevar': ('oppbevare',),
'oppbringe': ('oppbringe',),
'oppbringer': ('oppbringe',),
'oppbringes': ('oppbringe',),
'oppbrakte': ('oppbringe',),
'oppbrakt': ('oppbringe',),
'oppbring': ('oppbringe',),
'oppbygge': ('oppbygge',),
'oppbygger': ('oppbygge',),
'oppbygges': ('oppbygge',),
'oppbygget': ('oppbygge',),
'oppbygde': ('oppbygge',),
'oppbygget': ('oppbygge',),
'oppbygd': ('oppbygge',),
'oppbygg': ('oppbygge',),
'oppdage': ('oppdage',),
'oppdager': ('oppdage',),
'oppdages': ('oppdage',),
'oppdaga': ('oppdage',),
'oppdaget': ('oppdage',),
'oppdaga': ('oppdage',),
'oppdaget': ('oppdage',),
'oppdag': ('oppdage',),
'oppdatere': ('oppdatere',),
'oppdaterer': ('oppdatere',),
'oppdateres': ('oppdatere',),
'oppdaterte': ('oppdatere',),
'oppdatert': ('oppdatere',),
'oppdater': ('oppdatere',),
'oppdra': ('oppdra',),
'oppdrar': ('oppdra',),
'oppdras': ('oppdra',),
'oppdrog': ('oppdra',),
'oppdro': ('oppdra',),
'oppdradd': ('oppdra',),
'oppdratt': ('oppdra',),
'oppdradd': ('oppdra',),
'oppdratt': ('oppdra',),
'oppdra': ('oppdra',),
'oppdrette': ('oppdrette',),
'oppdretter': ('oppdrette',),
'oppdrettes': ('oppdrette',),
'oppdretta': ('oppdrette',),
'oppdrettet': ('oppdrette',),
'oppdretta': ('oppdrette',),
'oppdrettet': ('oppdrette',),
'oppdrett': ('oppdrette',),
'oppdyrke': ('oppdyrke',),
'oppdyrker': ('oppdyrke',),
'oppdyrkes': ('oppdyrke',),
'oppdyrka': ('oppdyrke',),
'oppdyrket': ('oppdyrke',),
'oppdyrka': ('oppdyrke',),
'oppdyrket': ('oppdyrke',),
'oppdyrk': ('oppdyrke',),
'oppe': ('oppe',),
'opper': ('oppe',),
'oppes': ('oppe',),
'oppa': ('oppe',),
'oppet': ('oppe',),
'oppa': ('oppe',),
'oppet': ('oppe',),
'opp': ('oppe',),
'oppebie': ('oppebie',),
'oppebier': ('oppebie',),
'oppebies': ('oppebie',),
'oppebia': ('oppebie',),
'oppebiet': ('oppebie',),
'oppebidde': ('oppebie',),
'oppebia': ('oppebie',),
'oppebiet': ('oppebie',),
'oppebidd': ('oppebie',),
'oppebi': ('oppebie',),
'oppelske': ('oppelske',),
'oppelsker': ('oppelske',),
'oppelskes': ('oppelske',),
'oppelska': ('oppelske',),
'oppelsket': ('oppelske',),
'oppelska': ('oppelske',),
'oppelsket': ('oppelske',),
'oppelsk': ('oppelske',),
'oppfange': ('oppfange',),
'oppfanger': ('oppfange',),
'oppfanges': ('oppfange',),
'oppfanga': ('oppfange',),
'oppfanget': ('oppfange',),
'oppfanga': ('oppfange',),
'oppfanget': ('oppfange',),
'oppfang': ('oppfange',),
'oppfatte': ('oppfatte',),
'oppfatter': ('oppfatte',),
'oppfattes': ('oppfatte',),
'oppfatta': ('oppfatte',),
'oppfattet': ('oppfatte',),
'oppfatta': ('oppfatte',),
'oppfattet': ('oppfatte',),
'oppfatt': ('oppfatte',),
'oppfinne': ('oppfinne',),
'oppfinner': ('oppfinne',),
'oppfinnes': ('oppfinne',),
'oppfant': ('oppfinne',),
'oppfunnet': ('oppfinne',),
'oppfinn': ('oppfinne',),
'oppflaske': ('oppflaske',),
'oppflasker': ('oppflaske',),
'oppflaskes': ('oppflaske',),
'oppflaska': ('oppflaske',),
'oppflasket': ('oppflaske',),
'oppflaska': ('oppflaske',),
'oppflasket': ('oppflaske',),
'oppflask': ('oppflaske',),
'oppfordre': ('oppfordre',),
'oppfordrer': ('oppfordre',),
'oppfordres': ('oppfordre',),
'oppfordra': ('oppfordre',),
'oppfordret': ('oppfordre',),
'oppfordra': ('oppfordre',),
'oppfordret': ('oppfordre',),
'oppfordr': ('oppfordre',),
'oppfordre': ('oppfordre',),
'oppfordr': ('oppfordre',),
'oppfordre': ('oppfordre',),
'oppfostre': ('oppfostre',),
'oppfostrer': ('oppfostre',),
'oppfostres': ('oppfostre',),
'oppfostra': ('oppfostre',),
'oppfostret': ('oppfostre',),
'oppfostra': ('oppfostre',),
'oppfostret': ('oppfostre',),
'oppfostr': ('oppfostre',),
'oppfostre': ('oppfostre',),
'oppfostr': ('oppfostre',),
'oppfostre': ('oppfostre',),
'oppfylle': ('oppfylle',),
'oppfyller': ('oppfylle',),
'oppfylles': ('oppfylle',),
'oppfylte': ('oppfylle',),
'oppfylt': ('oppfylle',),
'oppfyll': ('oppfylle',),
'oppføre': ('oppføre',),
'oppfører': ('oppføre',),
'oppføres': ('oppføre',),
'oppførte': ('oppføre',),
'oppført': ('oppføre',),
'oppfør': ('oppføre',),
'oppgi': ('oppgi',),
'oppgir': ('oppgi',),
'oppgis': ('oppgi',),
'oppgav': ('oppgi',),
'oppga': ('oppgi',),
'oppgitt': ('oppgi',),
'oppgi': ('oppgi',),
'oppheve': ('oppheve',),
'opphever': ('oppheve',),
'oppheves': ('oppheve',),
'oppheva': ('oppheve',),
'opphevet': ('oppheve',),
'opphevde': ('oppheve',),
'oppheva': ('oppheve',),
'opphevet': ('oppheve',),
'opphevd': ('oppheve',),
'opphev': ('oppheve',),
'opphisse': ('opphisse',),
'opphisser': ('opphisse',),
'opphisses': ('opphisse',),
'opphissa': ('opphisse',),
'opphisset': ('opphisse',),
'opphissa': ('opphisse',),
'opphisset': ('opphisse',),
'opphiss': ('opphisse',),
'oppholde': ('oppholde',),
'oppholder': ('oppholde',),
'oppholdes': ('oppholde',),
'oppholdt': ('oppholde',),
'opphold': ('oppholde',),
'opphøre': ('opphøre',),
'opphører': ('opphøre',),
'opphøres': ('opphøre',),
'opphørte': ('opphøre',),
'opphørt': ('opphøre',),
'opphør': ('opphøre',),
'opphøye': ('opphøye',),
'opphøyer': ('opphøye',),
'opphøyes': ('opphøye',),
'opphøya': ('opphøye',),
'opphøyet': ('opphøye',),
'opphøyde': ('opphøye',),
'opphøya': ('opphøye',),
'opphøyet': ('opphøye',),
'opphøyd': ('opphøye',),
'opphøy': ('opphøye',),
'oppildne': ('oppildne',),
'oppildner': ('oppildne',),
'oppildnes': ('oppildne',),
'oppildna': ('oppildne',),
'oppildnet': ('oppildne',),
'oppildna': ('oppildne',),
'oppildnet': ('oppildne',),
'oppildn': ('oppildne',),
'oppildne': ('oppildne',),
'oppildn': ('oppildne',),
'oppildne': ('oppildne',),
'oppirre': ('oppirre',),
'oppirrer': ('oppirre',),
'oppirres': ('oppirre',),
'oppirra': ('oppirre',),
'oppirret': ('oppirre',),
'oppirra': ('oppirre',),
'oppirret': ('oppirre',),
'oppirr': ('oppirre',),
'oppjustere': ('oppjustere',),
'oppjusterer': ('oppjustere',),
'oppjusteres': ('oppjustere',),
'oppjusterte': ('oppjustere',),
'oppjustert': ('oppjustere',),
'oppjuster': ('oppjustere',),
'oppkalle': ('oppkalle',),
'oppkaller': ('oppkalle',),
'oppkalles': ('oppkalle',),
'oppkalte': ('oppkalle',),
'oppkalt': ('oppkalle',),
'oppkall': ('oppkalle',),
'oppkaste': ('oppkaste',),
'oppkaster': ('oppkaste',),
'oppkastes': ('oppkaste',),
'oppkasta': ('oppkaste',),
'oppkastet': ('oppkaste',),
'oppkasta': ('oppkaste',),
'oppkastet': ('oppkaste',),
'oppkast': ('oppkaste',),
'oppklare': ('oppklare',),
'oppklarer': ('oppklare',),
'oppklares': ('oppklare',),
'oppklarte': ('oppklare',),
'oppklart': ('oppklare',),
'oppklar': ('oppklare',),
'oppkonstruere': ('oppkonstruere',),
'oppkonstruerer': ('oppkonstruere',),
'oppkonstrueres': ('oppkonstruere',),
'oppkonstruerte': ('oppkonstruere',),
'oppkonstruert': ('oppkonstruere',),
'oppkonstruer': ('oppkonstruere',),
'opplate': ('opplate',),
'opplater': ('opplate',),
'opplates': ('opplate',),
'opplot': ('opplate',),
'opplatt': ('opplate',),
'opplat': ('opplate',),
'oppleve': ('oppleve',),
'opplever': ('oppleve',),
'oppleves': ('oppleve',),
'opplevde': ('oppleve',),
'opplevd': ('oppleve',),
'opplev': ('oppleve',),
'opplive': ('opplive',),
'oppliver': ('opplive',),
'opplives': ('opplive',),
'oppliva': ('opplive',),
'opplivet': ('opplive',),
'oppliva': ('opplive',),
'opplivet': ('opplive',),
'oppliv': ('opplive',),
'opplyse': ('opplyse',),
'opplyser': ('opplyse',),
'opplyses': ('opplyse',),
'opplyste': ('opplyse',),
'opplyst': ('opplyse',),
'opplys': ('opplyse',),
'oppløfte': ('oppløfte',),
'oppløfter': ('oppløfte',),
'oppløftes': ('oppløfte',),
'oppløfta': ('oppløfte',),
'oppløftet': ('oppløfte',),
'oppløfta': ('oppløfte',),
'oppløftet': ('oppløfte',),
'oppløft': ('oppløfte',),
'oppløse': ('oppløse',),
'oppløser': ('oppløse',),
'oppløses': ('oppløse',),
'oppløste': ('oppløse',),
'oppløst': ('oppløse',),
'oppløs': ('oppløse',),
'oppløyse': ('oppløyse',),
'oppløyser': ('oppløyse',),
'oppløyses': ('oppløyse',),
'oppløyste': ('oppløyse',),
'oppløyst': ('oppløyse',),
'oppløys': ('oppløyse',),
'oppmagasinere': ('oppmagasinere',),
'oppmagasinerer': ('oppmagasinere',),
'oppmagasineres': ('oppmagasinere',),
'oppmagasinerte': ('oppmagasinere',),
'oppmagasinert': ('oppmagasinere',),
'oppmagasiner': ('oppmagasinere',),
'oppmuntre': ('oppmuntre',),
'oppmuntrer': ('oppmuntre',),
'oppmuntres': ('oppmuntre',),
'oppmuntra': ('oppmuntre',),
'oppmuntret': ('oppmuntre',),
'oppmuntra': ('oppmuntre',),
'oppmuntret': ('oppmuntre',),
'oppmuntr': ('oppmuntre',),
'oppmuntre': ('oppmuntre',),
'oppmuntr': ('oppmuntre',),
'oppmuntre': ('oppmuntre',),
'oppnevne': ('oppnevne',),
'oppnevner': ('oppnevne',),
'oppnevnes': ('oppnevne',),
'oppnevnte': ('oppnevne',),
'oppnevnt': ('oppnevne',),
'oppnevn': ('oppnevne',),
'oppnorske': ('oppnorske',),
'oppnorsker': ('oppnorske',),
'oppnorskes': ('oppnorske',),
'oppnorska': ('oppnorske',),
'oppnorsket': ('oppnorske',),
'oppnorska': ('oppnorske',),
'oppnorsket': ('oppnorske',),
'oppnorsk': ('oppnorske',),
'oppnå': ('oppnå',),
'oppnår': ('oppnå',),
'oppnås': ('oppnå',),
'oppnådde': ('oppnå',),
'oppnådd': ('oppnå',),
'oppnå': ('oppnå',),
'opponere': ('opponere',),
'opponerer': ('opponere',),
'opponeres': ('opponere',),
'opponerte': ('opponere',),
'opponert': ('opponere',),
'opponer': ('opponere',),
'opprede': ('opprede',),
'oppreder': ('opprede',),
'oppredes': ('opprede',),
'oppreda': ('opprede',),
'oppredet': ('opprede',),
'oppredte': ('opprede',),
'oppreda': ('opprede',),
'oppredet': ('opprede',),
'oppredt': ('opprede',),
'oppred': ('opprede',),
'oppreise': ('oppreise',),
'oppreiser': ('oppreise',),
'oppreises': ('oppreise',),
'oppreiste': ('oppreise',),
'oppreist': ('oppreise',),
'oppreis': ('oppreise',),
'oppreklamere': ('oppreklamere',),
'oppreklamerer': ('oppreklamere',),
'oppreklameres': ('oppreklamere',),
'oppreklamerte': ('oppreklamere',),
'oppreklamert': ('oppreklamere',),
'oppreklamer': ('oppreklamere',),
'opprette': ('opprette',),
'oppretter': ('opprette',),
'opprettes': ('opprette',),
'oppretta': ('opprette',),
'opprettet': ('opprette',),
'oppretta': ('opprette',),
'opprettet': ('opprette',),
'opprett': ('opprette',),
'opprettholde': ('opprettholde',),
'opprettholder': ('opprettholde',),
'opprettholdes': ('opprettholde',),
'opprettholdt': ('opprettholde',),
'oppretthold': ('opprettholde',),
'opprinne': ('opprinne',),
'opprinner': ('opprinne',),
'opprinnes': ('opprinne',),
'opprant': ('opprinne',),
'opprunnet': ('opprinne',),
'opprinn': ('opprinne',),
'oppruste': ('oppruste',),
'oppruster': ('oppruste',),
'opprustes': ('oppruste',),
'opprusta': ('oppruste',),
'opprustet': ('oppruste',),
'opprusta': ('oppruste',),
'opprustet': ('oppruste',),
'opprust': ('oppruste',),
'opprøre': ('opprøre',),
'opprører': ('opprøre',),
'opprøres': ('opprøre',),
'opprørte': ('opprøre',),
'opprørt': ('opprøre',),
'opprør': ('opprøre',),
'oppsette': ('oppsette',),
'oppsetter': ('oppsette',),
'oppsettes': ('oppsette',),
'oppsatte': ('oppsette',),
'oppsatt': ('oppsette',),
'oppsett': ('oppsette',),
'oppskrive': ('oppskrive',),
'oppskriver': ('oppskrive',),
'oppskrives': ('oppskrive',),
'oppskrev': ('oppskrive',),
'oppskreiv': ('oppskrive',),
'oppskrev': ('oppskrive',),
'oppskreiv': ('oppskrive',),
'oppskrevet': ('oppskrive',),
'oppskriv': ('oppskrive',),
'oppsluke': ('oppsluke',),
'oppsluker': ('oppsluke',),
'oppslukes': ('oppsluke',),
'oppslukte': ('oppsluke',),
'oppslukt': ('oppsluke',),
'oppsluk': ('oppsluke',),
'oppslutte': ('oppslutte',),
'oppslutter': ('oppslutte',),
'oppsluttes': ('oppslutte',),
'oppslutta': ('oppslutte',),
'oppsluttet': ('oppslutte',),
'oppslutta': ('oppslutte',),
'oppsluttet': ('oppslutte',),
'oppslutt': ('oppslutte',),
'oppspore': ('oppspore',),
'oppsporer': ('oppspore',),
'oppspores': ('oppspore',),
'oppspora': ('oppspore',),
'oppsporet': ('oppspore',),
'oppsporte': ('oppspore',),
'oppspora': ('oppspore',),
'oppsporet': ('oppspore',),
'oppsport': ('oppspore',),
'oppspor': ('oppspore',),
'oppstamme': ('oppstamme',),
'oppstammer': ('oppstamme',),
'oppstammes': ('oppstamme',),
'oppstamma': ('oppstamme',),
'oppstammet': ('oppstamme',),
'oppstamma': ('oppstamme',),
'oppstammet': ('oppstamme',),
'oppstam': ('oppstamme',),
'oppstykke': ('oppstykke',),
'oppstykker': ('oppstykke',),
'oppstykkes': ('oppstykke',),
'oppstykka': ('oppstykke',),
'oppstykket': ('oppstykke',),
'oppstykte': ('oppstykke',),
'oppstykka': ('oppstykke',),
'oppstykket': ('oppstykke',),
'oppstykt': ('oppstykke',),
'oppstykk': ('oppstykke',),
'oppstå': ('oppstå',),
'oppstår': ('oppstå',),
'oppstås': ('oppstå',),
'oppsto': ('oppstå',),
'oppstod': ('oppstå',),
'oppstått': ('oppstå',),
'oppstå': ('oppstå',),
'oppsummere': ('oppsummere',),
'oppsummerer': ('oppsummere',),
'oppsummeres': ('oppsummere',),
'oppsummerte': ('oppsummere',),
'oppsummert': ('oppsummere',),
'oppsummer': ('oppsummere',),
'oppsøke': ('oppsøke',),
'oppsøker': ('oppsøke',),
'oppsøkes': ('oppsøke',),
'oppsøkte': ('oppsøke',),
'oppsøkt': ('oppsøke',),
'oppsøk': ('oppsøke',),
'oppta': ('oppta',),
'opptar': ('oppta',),
'opptas': ('oppta',),
'opptok': ('oppta',),
'opptatt': ('oppta',),
'oppta': ('oppta',),
'opptegne': ('opptegne',),
'opptegner': ('opptegne',),
'opptegnes': ('opptegne',),
'opptegna': ('opptegne',),
'opptegnet': ('opptegne',),
'opptegna': ('opptegne',),
'opptegnet': ('opptegne',),
'opptegn': ('opptegne',),
'opptenne': ('opptenne',),
'opptenner': ('opptenne',),
'opptennes': ('opptenne',),
'opptente': ('opptenne',),
'opptent': ('opptenne',),
'opptenn': ('opptenne',),
'opptjene': ('opptjene',),
'opptjener': ('opptjene',),
'opptjenes': ('opptjene',),
'opptjente': ('opptjene',),
'opptjent': ('opptjene',),
'opptjen': ('opptjene',),
'opptrappe': ('opptrappe',),
'opptrapper': ('opptrappe',),
'opptrappes': ('opptrappe',),
'opptrappa': ('opptrappe',),
'opptrappet': ('opptrappe',),
'opptrappa': ('opptrappe',),
'opptrappet': ('opptrappe',),
'opptrapp': ('opptrappe',),
'opptre': ('opptre',),
'opptrer': ('opptre',),
'opptres': ('opptre',),
'opptrådte': ('opptre',),
'opptrådt': ('opptre',),
'opptre': ('opptre',),
'oppvarte': ('oppvarte',),
'oppvarter': ('oppvarte',),
'oppvartes': ('oppvarte',),
'oppvarta': ('oppvarte',),
'oppvartet': ('oppvarte',),
'oppvarta': ('oppvarte',),
'oppvartet': ('oppvarte',),
'oppvart': ('oppvarte',),
'oppveie': ('oppveie',),
'oppveier': ('oppveie',),
'oppveies': ('oppveie',),
'oppveide': ('oppveie',),
'oppveid': ('oppveie',),
'oppvei': ('oppveie',),
'oppvekke': ('oppvekke',),
'oppvekker': ('oppvekke',),
'oppvekkes': ('oppvekke',),
'oppvekka': ('oppvekke',),
'oppvekket': ('oppvekke',),
'oppvekte': ('oppvekke',),
'oppvekka': ('oppvekke',),
'oppvekket': ('oppvekke',),
'oppvekt': ('oppvekke',),
'oppvekk': ('oppvekke',),
'oppvigle': ('oppvigle',),
'oppvigler': ('oppvigle',),
'oppvigles': ('oppvigle',),
'oppvigla': ('oppvigle',),
'oppviglet': ('oppvigle',),
'oppvigla': ('oppvigle',),
'oppviglet': ('oppvigle',),
'oppvigl': ('oppvigle',),
'oppvigle': ('oppvigle',),
'oppvigl': ('oppvigle',),
'oppvigle': ('oppvigle',),
'oppvise': ('oppvise',),
'oppviser': ('oppvise',),
'oppvises': ('oppvise',),
'oppviste': ('oppvise',),
'oppvist': ('oppvise',),
'oppvis': ('oppvise',),
'oppvurdere': ('oppvurdere',),
'oppvurderer': ('oppvurdere',),
'oppvurderes': ('oppvurdere',),
'oppvurderte': ('oppvurdere',),
'oppvurdert': ('oppvurdere',),
'oppvurder': ('oppvurdere',),
'oppøve': ('oppøve',),
'oppøver': ('oppøve',),
'oppøves': ('oppøve',),
'oppøva': ('oppøve',),
'oppøvet': ('oppøve',),
'oppøvde': ('oppøve',),
'oppøva': ('oppøve',),
'oppøvet': ('oppøve',),
'oppøvd': ('oppøve',),
'oppøv': ('oppøve',),
'optere': ('optere',),
'opterer': ('optere',),
'opteres': ('optere',),
'opterte': ('optere',),
'optert': ('optere',),
'opter': ('optere',),
'optimalisere': ('optimalisere',),
'optimaliserer': ('optimalisere',),
'optimaliseres': ('optimalisere',),
'optimaliserte': ('optimalisere',),
'optimalisert': ('optimalisere',),
'optimaliser': ('optimalisere',),
'optimere': ('optimere',),
'optimerer': ('optimere',),
'optimeres': ('optimere',),
'optimerte': ('optimere',),
'optimert': ('optimere',),
'optimer': ('optimere',),
'orde': ('orde',),
'order': ('orde',),
'ordes': ('orde',),
'orda': ('orde',),
'ordet': ('orde',),
'orda': ('orde',),
'ordet': ('orde',),
'ord': ('orde',),
'ordinere': ('ordinere',),
'ordinerer': ('ordinere',),
'ordineres': ('ordinere',),
'ordinerte': ('ordinere',),
'ordinert': ('ordinere',),
'ordiner': ('ordinere',),
'ordlegge': ('ordlegge',),
'ordlegger': ('ordlegge',),
'ordlegges': ('ordlegge',),
'ordla': ('ordlegge',),
'ordlagt': ('ordlegge',),
'ordlegg': ('ordlegge',),
'ordne': ('ordne',),
'ordner': ('ordne',),
'ordnes': ('ordne',),
'ordna': ('ordne',),
'ordnet': ('ordne',),
'ordna': ('ordne',),
'ordnet': ('ordne',),
'ordn': ('ordne',),
'ordne': ('ordne',),
'ordn': ('ordne',),
'ordne': ('ordne',),
'oreigne': ('oreigne',),
'oreigner': ('oreigne',),
'oreignes': ('oreigne',),
'oreigna': ('oreigne',),
'oreignet': ('oreigne',),
'oreigna': ('oreigne',),
'oreignet': ('oreigne',),
'oreign': ('oreigne',),
'organisere': ('organisere',),
'organiserer': ('organisere',),
'organiseres': ('organisere',),
'organiserte': ('organisere',),
'organisert': ('organisere',),
'organiser': ('organisere',),
'orge': ('orge',),
'orger': ('orge',),
'orges': ('orge',),
'orga': ('orge',),
'orget': ('orge',),
'orga': ('orge',),
'orget': ('orge',),
'org': ('orge',),
'orientere': ('orientere',),
'orienterer': ('orientere',),
'orienteres': ('orientere',),
'orienterte': ('orientere',),
'orientert': ('orientere',),
'orienter': ('orientere',),
'orke': ('orke',),
'orker': ('orke',),
'orkes': ('orke',),
'orka': ('orke',),
'orket': ('orke',),
'orka': ('orke',),
'orket': ('orke',),
'ork': ('orke',),
'orkestrere': ('orkestrere',),
'orkestrerer': ('orkestrere',),
'orkestreres': ('orkestrere',),
'orkestrerte': ('orkestrere',),
'orkestrert': ('orkestrere',),
'orkestrer': ('orkestrere',),
'orme': ('orme',),
'ormer': ('orme',),
'ormes': ('orme',),
'orma': ('orme',),
'ormet': ('orme',),
'orma': ('orme',),
'ormet': ('orme',),
'orm': ('orme',),
'ornamentere': ('ornamentere',),
'ornamenterer': ('ornamentere',),
'ornamenteres': ('ornamentere',),
'ornamenterte': ('ornamentere',),
'ornamentert': ('ornamentere',),
'ornamenter': ('ornamentere',),
'oscillere': ('oscillere',),
'oscillerer': ('oscillere',),
'oscilleres': ('oscillere',),
'oscillerte': ('oscillere',),
'oscillert': ('oscillere',),
'osciller': ('oscillere',),
'ose': ('ose',),
'oser': ('ose',),
'oses': ('ose',),
'oste': ('ose',),
'ost': ('ose',),
'os': ('ose',),
'oste': ('oste',),
'oster': ('oste',),
'ostes': ('oste',),
'osta': ('oste',),
'ostet': ('oste',),
'osta': ('oste',),
'ostet': ('oste',),
'ost': ('oste',),
'otre': ('otre',),
'otrer': ('otre',),
'otres': ('otre',),
'otra': ('otre',),
'otret': ('otre',),
'otra': ('otre',),
'otret': ('otre',),
'otr': ('otre',),
'otre': ('otre',),
'otr': ('otre',),
'otre': ('otre',),
'overanstrenge': ('overanstrenge',),
'overanstrenger': ('overanstrenge',),
'overanstrenges': ('overanstrenge',),
'overanstrengte': ('overanstrenge',),
'overanstrengt': ('overanstrenge',),
'overanstreng': ('overanstrenge',),
'overbelaste': ('overbelaste',),
'overbelaster': ('overbelaste',),
'overbelastes': ('overbelaste',),
'overbelasta': ('overbelaste',),
'overbelastet': ('overbelaste',),
'overbelasta': ('overbelaste',),
'overbelastet': ('overbelaste',),
'overbelast': ('overbelaste',),
'overbeskatte': ('overbeskatte',),
'overbeskatter': ('overbeskatte',),
'overbeskattes': ('overbeskatte',),
'overbeskatta': ('overbeskatte',),
'overbeskattet': ('overbeskatte',),
'overbeskatta': ('overbeskatte',),
'overbeskattet': ('overbeskatte',),
'overbeskatt': ('overbeskatte',),
'overbeskytte': ('overbeskytte',),
'overbeskytter': ('overbeskytte',),
'overbeskyttes': ('overbeskytte',),
'overbeskytta': ('overbeskytte',),
'overbeskyttet': ('overbeskytte',),
'overbeskytta': ('overbeskytte',),
'overbeskyttet': ('overbeskytte',),
'overbeskytt': ('overbeskytte',),
'overbetone': ('overbetone',),
'overbetoner': ('overbetone',),
'overbetones': ('overbetone',),
'overbetona': ('overbetone',),
'overbetonet': ('overbetone',),
'overbetonte': ('overbetone',),
'overbetona': ('overbetone',),
'overbetonet': ('overbetone',),
'overbetont': ('overbetone',),
'overbeton': ('overbetone',),
'overbevise': ('overbevise',),
'overbeviser': ('overbevise',),
'overbevises': ('overbevise',),
'overbeviste': ('overbevise',),
'overbevist': ('overbevise',),
'overbevis': ('overbevise',),
'overbringe': ('overbringe',),
'overbringer': ('overbringe',),
'overbringes': ('overbringe',),
'overbrakte': ('overbringe',),
'overbrakt': ('overbringe',),
'overbring': ('overbringe',),
'overbrodere': ('overbrodere',),
'overbroderer': ('overbrodere',),
'overbroderes': ('overbrodere',),
'overbroderte': ('overbrodere',),
'overbrodert': ('overbrodere',),
'overbroder': ('overbrodere',),
'overdimensjonere': ('overdimensjonere',),
'overdimensjonerer': ('overdimensjonere',),
'overdimensjoneres': ('overdimensjonere',),
'overdimensjonerte': ('overdimensjonere',),
'overdimensjonert': ('overdimensjonere',),
'overdimensjoner': ('overdimensjonere',),
'overdra': ('overdra',),
'overdrar': ('overdra',),
'overdras': ('overdra',),
'overdrog': ('overdra',),
'overdro': ('overdra',),
'overdradd': ('overdra',),
'overdratt': ('overdra',),
'overdradd': ('overdra',),
'overdratt': ('overdra',),
'overdra': ('overdra',),
'overdynge': ('overdynge',),
'overdynger': ('overdynge',),
'overdynges': ('overdynge',),
'overdynga': ('overdynge',),
'overdynget': ('overdynge',),
'overdynga': ('overdynge',),
'overdynget': ('overdynge',),
'overdyng': ('overdynge',),
'overdøve': ('overdøve',),
'overdøver': ('overdøve',),
'overdøves': ('overdøve',),
'overdøva': ('overdøve',),
'overdøvet': ('overdøve',),
'overdøvde': ('overdøve',),
'overdøva': ('overdøve',),
'overdøvet': ('overdøve',),
'overdøvd': ('overdøve',),
'overdøv': ('overdøve',),
'overeksponere': ('overeksponere',),
'overeksponerer': ('overeksponere',),
'overeksponeres': ('overeksponere',),
'overeksponerte': ('overeksponere',),
'overeksponert': ('overeksponere',),
'overeksponer': ('overeksponere',),
'overflødiggjøre': ('overflødiggjøre',),
'overflødiggjør': ('overflødiggjøre',),
'overflødiggjøres': ('overflødiggjøre',),
'overflødiggjorde': ('overflødiggjøre',),
'overflødiggjort': ('overflødiggjøre',),
'overflødiggjør': ('overflødiggjøre',),
'overfløye': ('overfløye',),
'overfløyer': ('overfløye',),
'overfløyes': ('overfløye',),
'overfløyet': ('overfløye',),
'overfløyde': ('overfløye',),
'overfløyet': ('overfløye',),
'overfløyd': ('overfløye',),
'overfløy': ('overfløye',),
'overforsikre': ('overforsikre',),
'overforsikrer': ('overforsikre',),
'overforsikres': ('overforsikre',),
'overforsikra': ('overforsikre',),
'overforsikret': ('overforsikre',),
'overforsikra': ('overforsikre',),
'overforsikret': ('overforsikre',),
'overforsikr': ('overforsikre',),
'overforsikre': ('overforsikre',),
'overforsikr': ('overforsikre',),
'overforsikre': ('overforsikre',),
'overfuse': ('overfuse',),
'overfuser': ('overfuse',),
'overfuses': ('overfuse',),
'overfuste': ('overfuse',),
'overfust': ('overfuse',),
'overfus': ('overfuse',),
'overføre': ('overføre',),
'overfører': ('overføre',),
'overføres': ('overføre',),
'overførte': ('overføre',),
'overført': ('overføre',),
'overfør': ('overføre',),
'overgi': ('overgi',),
'overgir': ('overgi',),
'overgis': ('overgi',),
'overgav': ('overgi',),
'overga': ('overgi',),
'overgitt': ('overgi',),
'overgi': ('overgi',),
'overgå': ('overgå',),
'overgår': ('overgå',),
'overgås': ('overgå',),
'overgikk': ('overgå',),
'overgått': ('overgå',),
'overgå': ('overgå',),
'overhale': ('overhale',),
'overhaler': ('overhale',),
'overhales': ('overhale',),
'overhala': ('overhale',),
'overhalet': ('overhale',),
'overhalte': ('overhale',),
'overhala': ('overhale',),
'overhalet': ('overhale',),
'overhalt': ('overhale',),
'overhal': ('overhale',),
'overholde': ('overholde',),
'overholder': ('overholde',),
'overholdes': ('overholde',),
'overholdt': ('overholde',),
'overhold': ('overholde',),
'overhøre': ('overhøre',),
'overhører': ('overhøre',),
'overhøres': ('overhøre',),
'overhørte': ('overhøre',),
'overhørt': ('overhøre',),
'overhør': ('overhøre',),
'overhøvle': ('overhøvle',),
'overhøvler': ('overhøvle',),
'overhøvles': ('overhøvle',),
'overhøvla': ('overhøvle',),
'overhøvlet': ('overhøvle',),
'overhøvla': ('overhøvle',),
'overhøvlet': ('overhøvle',),
'overhøvl': ('overhøvle',),
'overhøvle': ('overhøvle',),
'overhøvl': ('overhøvle',),
'overhøvle': ('overhøvle',),
'overkjøre': ('overkjøre',),
'overkjører': ('overkjøre',),
'overkjøres': ('overkjøre',),
'overkjørte': ('overkjøre',),
'overkjørt': ('overkjøre',),
'overkjør': ('overkjøre',),
'overkomme': ('overkomme',),
'overkommer': ('overkomme',),
'overkommes': ('overkomme',),
'overkom': ('overkomme',),
'overkommet': ('overkomme',),
'overkom': ('overkomme',),
'overkompensere': ('overkompensere',),
'overkompenserer': ('overkompensere',),
'overkompenseres': ('overkompensere',),
'overkompenserte': ('overkompensere',),
'overkompensert': ('overkompensere',),
'overkompenser': ('overkompensere',),
'overlappe': ('overlappe',),
'overlapper': ('overlappe',),
'overlappes': ('overlappe',),
'overlappa': ('overlappe',),
'overlappet': ('overlappe',),
'overlappa': ('overlappe',),
'overlappet': ('overlappe',),
'overlapp': ('overlappe',),
'overlaste': ('overlaste',),
'overlaster': ('overlaste',),
'overlastes': ('overlaste',),
'overlasta': ('overlaste',),
'overlastet': ('overlaste',),
'overlasta': ('overlaste',),
'overlastet': ('overlaste',),
'overlast': ('overlaste',),
'overlate': ('overlate',),
'overlater': ('overlate',),
'overlates': ('overlate',),
'overlot': ('overlate',),
'overlatt': ('overlate',),
'overlat': ('overlate',),
'overlegge': ('overlegge',),
'overlegger': ('overlegge',),
'overlegges': ('overlegge',),
'overla': ('overlegge',),
'overlagt': ('overlegge',),
'overlegg': ('overlegge',),
'overlesse': ('overlesse',),
'overlesser': ('overlesse',),
'overlesses': ('overlesse',),
'overlessa': ('overlesse',),
'overlesset': ('overlesse',),
'overleste': ('overlesse',),
'overlessa': ('overlesse',),
'overlesset': ('overlesse',),
'overlest': ('overlesse',),
'overless': ('overlesse',),
'overleve': ('overleve',),
'overlever': ('overleve',),
'overleves': ('overleve',),
'overlevde': ('overleve',),
'overlevd': ('overleve',),
'overlev': ('overleve',),
'overlevere': ('overlevere',),
'overleverer': ('overlevere',),
'overleveres': ('overlevere',),
'overleverte': ('overlevere',),
'overlevert': ('overlevere',),
'overlever': ('overlevere',),
'overliste': ('overliste',),
'overlister': ('overliste',),
'overlistes': ('overliste',),
'overlista': ('overliste',),
'overlistet': ('overliste',),
'overlista': ('overliste',),
'overlistet': ('overliste',),
'overlist': ('overliste',),
'overmanne': ('overmanne',),
'overmanner': ('overmanne',),
'overmannes': ('overmanne',),
'overmanna': ('overmanne',),
'overmannet': ('overmanne',),
'overmanna': ('overmanne',),
'overmannet': ('overmanne',),
'overmann': ('overmanne',),
'overnatte': ('overnatte',),
'overnatter': ('overnatte',),
'overnattes': ('overnatte',),
'overnatta': ('overnatte',),
'overnattet': ('overnatte',),
'overnatta': ('overnatte',),
'overnattet': ('overnatte',),
'overnatt': ('overnatte',),
'overopphete': ('overopphete',),
'overoppheter': ('overopphete',),
'overopphetes': ('overopphete',),
'overoppheta': ('overopphete',),
'overopphetet': ('overopphete',),
'overoppheta': ('overopphete',),
'overopphetet': ('overopphete',),
'overopphet': ('overopphete',),
'overprøve': ('overprøve',),
'overprøver': ('overprøve',),
'overprøves': ('overprøve',),
'overprøvde': ('overprøve',),
'overprøvd': ('overprøve',),
'overprøv': ('overprøve',),
'overraske': ('overraske',),
'overrasker': ('overraske',),
'overraskes': ('overraske',),
'overraska': ('overraske',),
'overrasket': ('overraske',),
'overraska': ('overraske',),
'overrasket': ('overraske',),
'overrask': ('overraske',),
'overrekke': ('overrekke',),
'overrekker': ('overrekke',),
'overrekkes': ('overrekke',),
'overrakte': ('overrekke',),
'overrakt': ('overrekke',),
'overrekk': ('overrekke',),
'overrenne': ('overrenne',),
'overrenner': ('overrenne',),
'overrennes': ('overrenne',),
'overrente': ('overrenne',),
'overrent': ('overrenne',),
'overrenn': ('overrenne',),
'overrisle': ('overrisle',),
'overrisler': ('overrisle',),
'overrisles': ('overrisle',),
'overrisla': ('overrisle',),
'overrislet': ('overrisle',),
'overrisla': ('overrisle',),
'overrislet': ('overrisle',),
'overrisl': ('overrisle',),
'overrumple': ('overrumple',),
'overrumpler': ('overrumple',),
'overrumples': ('overrumple',),
'overrumpla': ('overrumple',),
'overrumplet': ('overrumple',),
'overrumpla': ('overrumple',),
'overrumplet': ('overrumple',),
'overrumpl': ('overrumple',),
'overrumple': ('overrumple',),
'overrumpl': ('overrumple',),
'overrumple': ('overrumple',),
'overse': ('overse',),
'overser': ('overse',),
'overses': ('overse',),
'oversees': ('overse',),
'overså': ('overse',),
'oversett': ('overse',),
'overse': ('overse',),
'oversende': ('oversende',),
'oversender': ('oversende',),
'oversendes': ('oversende',),
'oversendte': ('oversende',),
'oversendt': ('oversende',),
'oversend': ('oversende',),
'oversette': ('oversette',),
'oversetter': ('oversette',),
'oversettes': ('oversette',),
'oversatte': ('oversette',),
'oversatt': ('oversette',),
'oversett': ('oversette',),
'oversitte': ('oversitte',),
'oversitter': ('oversitte',),
'oversittes': ('oversitte',),
'oversatt': ('oversitte',),
'oversittet': ('oversitte',),
'oversitt': ('oversitte',),
'overskride': ('overskride',),
'overskrider': ('overskride',),
'overskrides': ('overskride',),
'overskred': ('overskride',),
'overskrei': ('overskride',),
'overskredet': ('overskride',),
'overskrid': ('overskride',),
'overskue': ('overskue',),
'overskuer': ('overskue',),
'overskues': ('overskue',),
'overskua': ('overskue',),
'overskuet': ('overskue',),
'overskua': ('overskue',),
'overskuet': ('overskue',),
'oversku': ('overskue',),
'overskygge': ('overskygge',),
'overskygger': ('overskygge',),
'overskygges': ('overskygge',),
'overskygga': ('overskygge',),
'overskygget': ('overskygge',),
'overskygde': ('overskygge',),
'overskygga': ('overskygge',),
'overskygget': ('overskygge',),
'overskygd': ('overskygge',),
'overskygg': ('overskygge',),
'overspille': ('overspille',),
'overspiller': ('overspille',),
'overspilles': ('overspille',),
'overspilte': ('overspille',),
'overspilt': ('overspille',),
'overspill': ('overspille',),
'overstemme': ('overstemme',),
'overstemmer': ('overstemme',),
'overstemmes': ('overstemme',),
'overstemte': ('overstemme',),
'overstemt': ('overstemme',),
'overstem': ('overstemme',),
'overstige': ('overstige',),
'overstiger': ('overstige',),
'overstiges': ('overstige',),
'oversteg': ('overstige',),
'oversteig': ('overstige',),
'oversteg': ('overstige',),
'oversteig': ('overstige',),
'oversteget': ('overstige',),
'overstig': ('overstige',),
'oversvømme': ('oversvømme',),
'oversvømmer': ('oversvømme',),
'oversvømmes': ('oversvømme',),
'oversvømte': ('oversvømme',),
'oversvømt': ('oversvømme',),
'oversvøm': ('oversvømme',),
'overta': ('overta',),
'overtar': ('overta',),
'overtas': ('overta',),
'overtok': ('overta',),
'overtatt': ('overta',),
'overta': ('overta',),
'overtale': ('overtale',),
'overtaler': ('overtale',),
'overtales': ('overtale',),
'overtalte': ('overtale',),
'overtalt': ('overtale',),
'overtal': ('overtale',),
'overtegne': ('overtegne',),
'overtegner': ('overtegne',),
'overtegnes': ('overtegne',),
'overtegna': ('overtegne',),
'overtegnet': ('overtegne',),
'overtegna': ('overtegne',),
'overtegnet': ('overtegne',),
'overtegn': ('overtegne',),
'overtre': ('overtre',),
'overtrer': ('overtre',),
'overtres': ('overtre',),
'overtrådte': ('overtre',),
'overtrådt': ('overtre',),
'overtre': ('overtre',),
'overtreffe': ('overtreffe',),
'overtreffer': ('overtreffe',),
'overtreffes': ('overtreffe',),
'overtraff': ('overtreffe',),
'overtruffet': ('overtreffe',),
'overtreff': ('overtreffe',),
'overtrekke': ('overtrekke',),
'overtrekker': ('overtrekke',),
'overtrekkes': ('overtrekke',),
'overtrakk': ('overtrekke',),
'overtrukket': ('overtrekke',),
'overtrekk': ('overtrekke',),
'overtyde': ('overtyde',),
'overtyder': ('overtyde',),
'overtydes': ('overtyde',),
'overtyda': ('overtyde',),
'overtydet': ('overtyde',),
'overtydde': ('overtyde',),
'overtyda': ('overtyde',),
'overtydet': ('overtyde',),
'overtydd': ('overtyde',),
'overtyd': ('overtyde',),
'overutvikle': ('overutvikle',),
'overutvikler': ('overutvikle',),
'overutvikles': ('overutvikle',),
'overutvikla': ('overutvikle',),
'overutviklet': ('overutvikle',),
'overutvikla': ('overutvikle',),
'overutviklet': ('overutvikle',),
'overutvikl': ('overutvikle',),
'overutvikle': ('overutvikle',),
'overutvikl': ('overutvikle',),
'overutvikle': ('overutvikle',),
'overveie': ('overveie',),
'overveier': ('overveie',),
'overveies': ('overveie',),
'overveide': ('overveie',),
'overveid': ('overveie',),
'overvei': ('overveie',),
'overvelde': ('overvelde',),
'overvelder': ('overvelde',),
'overveldes': ('overvelde',),
'overvelda': ('overvelde',),
'overveldet': ('overvelde',),
'overvelda': ('overvelde',),
'overveldet': ('overvelde',),
'overveld': ('overvelde',),
'overvinne': ('overvinne',),
'overvinner': ('overvinne',),
'overvinnes': ('overvinne',),
'overvant': ('overvinne',),
'overvunnet': ('overvinne',),
'overvinn': ('overvinne',),
'overvintre': ('overvintre',),
'overvintrer': ('overvintre',),
'overvintres': ('overvintre',),
'overvintra': ('overvintre',),
'overvintret': ('overvintre',),
'overvintra': ('overvintre',),
'overvintret': ('overvintre',),
'overvintr': ('overvintre',),
'overvintre': ('overvintre',),
'overvintr': ('overvintre',),
'overvintre': ('overvintre',),
'overvurdere': ('overvurdere',),
'overvurderer': ('overvurdere',),
'overvurderes': ('overvurdere',),
'overvurderte': ('overvurdere',),
'overvurdert': ('overvurdere',),
'overvurder': ('overvurdere',),
'overvåke': ('overvåke',),
'overvåker': ('overvåke',),
'overvåkes': ('overvåke',),
'overvåka': ('overvåke',),
'overvåket': ('overvåke',),
'overvåkte': ('overvåke',),
'overvåka': ('overvåke',),
'overvåket': ('overvåke',),
'overvåkt': ('overvåke',),
'overvåk': ('overvåke',),
'overvære': ('overvære',),
'overværer': ('overvære',),
'overværes': ('overvære',),
'overvar': ('overvære',),
'overvært': ('overvære',),
'overvær': ('overvære',),
'overøse': ('overøse',),
'overøser': ('overøse',),
'overøses': ('overøse',),
'overøste': ('overøse',),
'overøst': ('overøse',),
'overøs': ('overøse',),
'ovre': ('ovre',),
'ovrer': ('ovre',),
'ovres': ('ovre',),
'ovra': ('ovre',),
'ovret': ('ovre',),
'ovra': ('ovre',),
'ovret': ('ovre',),
'ovr': ('ovre',),
'ovre': ('ovre',),
'ovr': ('ovre',),
'ovre': ('ovre',),
'pace': ('pace',),
'pacer': ('pace',),
'paces': ('pace',),
'paca': ('pace',),
'pacet': ('pace',),
'pacte': ('pace',),
'paca': ('pace',),
'pacet': ('pace',),
'pact': ('pace',),
'pac': ('pace',),
'padle': ('padle',),
'padler': ('padle',),
'padles': ('padle',),
'padla': ('padle',),
'padlet': ('padle',),
'padla': ('padle',),
'padlet': ('padle',),
'padl': ('padle',),
'padle': ('padle',),
'padl': ('padle',),
'padle': ('padle',),
'paffe': ('paffe',),
'paffer': ('paffe',),
'paffes': ('paffe',),
'paffa': ('paffe',),
'paffet': ('paffe',),
'paffa': ('paffe',),
'paffet': ('paffe',),
'paff': ('paffe',),
'paginere': ('paginere',),
'paginerer': ('paginere',),
'pagineres': ('paginere',),
'paginerte': ('paginere',),
'paginert': ('paginere',),
'paginer': ('paginere',),
'pakke': ('pakke',),
'pakker': ('pakke',),
'pakkes': ('pakke',),
'pakka': ('pakke',),
'pakket': ('pakke',),
'pakka': ('pakke',),
'pakket': ('pakke',),
'pakk': ('pakke',),
'pakte': ('pakte',),
'pakter': ('pakte',),
'paktes': ('pakte',),
'pakta': ('pakte',),
'paktet': ('pakte',),
'pakta': ('pakte',),
'paktet': ('pakte',),
'pakt': ('pakte',),
'palatalisere': ('palatalisere',),
'palataliserer': ('palatalisere',),
'palataliseres': ('palatalisere',),
'palataliserte': ('palatalisere',),
'palatalisert': ('palatalisere',),
'palataliser': ('palatalisere',),
'pale': ('pale',),
'paler': ('pale',),
'pales': ('pale',),
'palte': ('pale',),
'palt': ('pale',),
'pal': ('pale',),
'palletere': ('palletere',),
'palleterer': ('palletere',),
'palleteres': ('palletere',),
'palleterte': ('palletere',),
'palletert': ('palletere',),
'palleter': ('palletere',),
'palme': ('palme',),
'palmer': ('palme',),
'palmes': ('palme',),
'palma': ('palme',),
'palmet': ('palme',),
'palma': ('palme',),
'palmet': ('palme',),
'palm': ('palme',),
'palpere': ('palpere',),
'palperer': ('palpere',),
'palperes': ('palpere',),
'palperte': ('palpere',),
'palpert': ('palpere',),
'palper': ('palpere',),
'panegyrere': ('panegyrere',),
'panegyrerer': ('panegyrere',),
'panegyreres': ('panegyrere',),
'panegyrerte': ('panegyrere',),
'panegyrert': ('panegyrere',),
'panegyrer': ('panegyrere',),
'panele': ('panele',),
'paneler': ('panele',),
'paneles': ('panele',),
'panelte': ('panele',),
'panelt': ('panele',),
'panel': ('panele',),
'panere': ('panere',),
'panerer': ('panere',),
'paneres': ('panere',),
'panerte': ('panere',),
'panert': ('panere',),
'paner': ('panere',),
'panorere': ('panorere',),
'panorerer': ('panorere',),
'panoreres': ('panorere',),
'panorerte': ('panorere',),
'panorert': ('panorere',),
'panorer': ('panorere',),
'pansre': ('pansre',),
'pansrer': ('pansre',),
'pansres': ('pansre',),
'pansra': ('pansre',),
'pansret': ('pansre',),
'pansra': ('pansre',),
'pansret': ('pansre',),
'pansr': ('pansre',),
'pansre': ('pansre',),
'pansr': ('pansre',),
'pansre': ('pansre',),
'pante': ('pante',),
'panter': ('pante',),
'pantes': ('pante',),
'panta': ('pante',),
'pantet': ('pante',),
'panta': ('pante',),
'pantet': ('pante',),
'pant': ('pante',),
'pantsette': ('pantsette',),
'pantsetter': ('pantsette',),
'pantsettes': ('pantsette',),
'pantsatte': ('pantsette',),
'pantsatt': ('pantsette',),
'pantsett': ('pantsette',),
'pantstille': ('pantstille',),
'pantstiller': ('pantstille',),
'pantstilles': ('pantstille',),
'pantstilte': ('pantstille',),
'pantstilt': ('pantstille',),
'pantstill': ('pantstille',),
'pappe': ('pappe',),
'papper': ('pappe',),
'pappes': ('pappe',),
'pappa': ('pappe',),
'pappet': ('pappe',),
'pappa': ('pappe',),
'pappet': ('pappe',),
'papp': ('pappe',),
'paradere': ('paradere',),
'paraderer': ('paradere',),
'paraderes': ('paradere',),
'paraderte': ('paradere',),
'paradert': ('paradere',),
'parader': ('paradere',),
'parafere': ('parafere',),
'paraferer': ('parafere',),
'paraferes': ('parafere',),
'paraferte': ('parafere',),
'parafert': ('parafere',),
'parafer': ('parafere',),
'parafinere': ('parafinere',),
'parafinerer': ('parafinere',),
'parafineres': ('parafinere',),
'parafinerte': ('parafinere',),
'parafinert': ('parafinere',),
'parafiner': ('parafinere',),
'parafrasere': ('parafrasere',),
'parafraserer': ('parafrasere',),
'parafraseres': ('parafrasere',),
'parafraserte': ('parafrasere',),
'parafrasert': ('parafrasere',),
'parafraser': ('parafrasere',),
'paragrafere': ('paragrafere',),
'paragraferer': ('paragrafere',),
'paragraferes': ('paragrafere',),
'paragraferte': ('paragrafere',),
'paragrafert': ('paragrafere',),
'paragrafer': ('paragrafere',),
'parallellforskyve': ('parallellforskyve',),
'parallellforskyver': ('parallellforskyve',),
'parallellforskyves': ('parallellforskyve',),
'parallellforskjøv': ('parallellforskyve',),
'parallellforskøyv': ('parallellforskyve',),
'parallellforskjøvet': ('parallellforskyve',),
'parallellforskyv': ('parallellforskyve',),
'parallellføre': ('parallellføre',),
'parallellfører': ('parallellføre',),
'parallellføres': ('parallellføre',),
'parallellførte': ('parallellføre',),
'parallellført': ('parallellføre',),
'parallellfør': ('parallellføre',),
'parallellisere': ('parallellisere',),
'parallelliserer': ('parallellisere',),
'parallelliseres': ('parallellisere',),
'parallelliserte': ('parallellisere',),
'parallellisert': ('parallellisere',),
'parallelliser': ('parallellisere',),
'paralysere': ('paralysere',),
'paralyserer': ('paralysere',),
'paralyseres': ('paralysere',),
'paralyserte': ('paralysere',),
'paralysert': ('paralysere',),
'paralyser': ('paralysere',),
'parasittere': ('parasittere',),
'parasitterer': ('parasittere',),
'parasitteres': ('parasittere',),
'parasitterte': ('parasittere',),
'parasittert': ('parasittere',),
'parasitter': ('parasittere',),
'pare': ('pare',),
'parer': ('pare',),
'pares': ('pare',),
'para': ('pare',),
'paret': ('pare',),
'para': ('pare',),
'paret': ('pare',),
'par': ('pare',),
'parere': ('parere',),
'parerer': ('parere',),
'pareres': ('parere',),
'parerte': ('parere',),
'parert': ('parere',),
'parer': ('parere',),
'parfymere': ('parfymere',),
'parfymerer': ('parfymere',),
'parfymeres': ('parfymere',),
'parfymerte': ('parfymere',),
'parfymert': ('parfymere',),
'parfymer': ('parfymere',),
'parkere': ('parkere',),
'parkerer': ('parkere',),
'parkeres': ('parkere',),
'parkerte': ('parkere',),
'parkert': ('parkere',),
'parker': ('parkere',),
'parlamentere': ('parlamentere',),
'parlamenterer': ('parlamentere',),
'parlamenteres': ('parlamentere',),
'parlamenterte': ('parlamentere',),
'parlamentert': ('parlamentere',),
'parlamenter': ('parlamentere',),
'parlere': ('parlere',),
'parlerer': ('parlere',),
'parleres': ('parlere',),
'parlerte': ('parlere',),
'parlert': ('parlere',),
'parler': ('parlere',),
'parodiere': ('parodiere',),
'parodierer': ('parodiere',),
'parodieres': ('parodiere',),
'parodierte': ('parodiere',),
'parodiert': ('parodiere',),
'parodier': ('parodiere',),
'parsellere': ('parsellere',),
'parsellerer': ('parsellere',),
'parselleres': ('parsellere',),
'parsellerte': ('parsellere',),
'parsellert': ('parsellere',),
'parseller': ('parsellere',),
'partere': ('partere',),
'parterer': ('partere',),
'parteres': ('partere',),
'parterte': ('partere',),
'partert': ('partere',),
'parter': ('partere',),
'partisipere': ('partisipere',),
'partisiperer': ('partisipere',),
'partisiperes': ('partisipere',),
'partisiperte': ('partisipere',),
'partisipert': ('partisipere',),
'partisiper': ('partisipere',),
'pasifisere': ('pasifisere',),
'pasifiserer': ('pasifisere',),
'pasifiseres': ('pasifisere',),
'pasifiserte': ('pasifisere',),
'pasifisert': ('pasifisere',),
'pasifiser': ('pasifisere',),
'passe': ('passe',),
'passer': ('passe',),
'passes': ('passe',),
'passa': ('passe',),
'passet': ('passe',),
'passa': ('passe',),
'passet': ('passe',),
'pass': ('passe',),
'passere': ('passere',),
'passerer': ('passere',),
'passeres': ('passere',),
'passerte': ('passere',),
'passert': ('passere',),
'passer': ('passere',),
'passiare': ('passiare',),
'passiarer': ('passiare',),
'passiares': ('passiare',),
'passiarte': ('passiare',),
'passiart': ('passiare',),
'passiar': ('passiare',),
'passivere': ('passivere',),
'passiverer': ('passivere',),
'passiveres': ('passivere',),
'passiverte': ('passivere',),
'passivert': ('passivere',),
'passiver': ('passivere',),
'passivisere': ('passivisere',),
'passiviserer': ('passivisere',),
'passiviseres': ('passivisere',),
'passiviserte': ('passivisere',),
'passivisert': ('passivisere',),
'passiviser': ('passivisere',),
'pasteurisere': ('pasteurisere',),
'pasteuriserer': ('pasteurisere',),
'pasteuriseres': ('pasteurisere',),
'pasteuriserte': ('pasteurisere',),
'pasteurisert': ('pasteurisere',),
'pasteuriser': ('pasteurisere',),
'patentere': ('patentere',),
'patenterer': ('patentere',),
'patenteres': ('patentere',),
'patenterte': ('patentere',),
'patentert': ('patentere',),
'patenter': ('patentere',),
'patentsøke': ('patentsøke',),
'patentsøker': ('patentsøke',),
'patentsøkes': ('patentsøke',),
'patentsøkte': ('patentsøke',),
'patentsøkt': ('patentsøke',),
'patentsøk': ('patentsøke',),
'patinere': ('patinere',),
'patinerer': ('patinere',),
'patineres': ('patinere',),
'patinerte': ('patinere',),
'patinert': ('patinere',),
'patiner': ('patinere',),
'patronisere': ('patronisere',),
'patroniserer': ('patronisere',),
'patroniseres': ('patronisere',),
'patroniserte': ('patronisere',),
'patronisert': ('patronisere',),
'patroniser': ('patronisere',),
'patruljere': ('patruljere',),
'patruljerer': ('patruljere',),
'patruljeres': ('patruljere',),
'patruljerte': ('patruljere',),
'patruljert': ('patruljere',),
'patruljer': ('patruljere',),
'patte': ('patte',),
'patter': ('patte',),
'pattes': ('patte',),
'patta': ('patte',),
'pattet': ('patte',),
'patta': ('patte',),
'pattet': ('patte',),
'patt': ('patte',),
'pausere': ('pausere',),
'pauserer': ('pausere',),
'pauseres': ('pausere',),
'pauserte': ('pausere',),
'pausert': ('pausere',),
'pauser': ('pausere',),
'peile': ('peile',),
'peiler': ('peile',),
'peiles': ('peile',),
'peila': ('peile',),
'peilet': ('peile',),
'peilte': ('peile',),
'peila': ('peile',),
'peilet': ('peile',),
'peilt': ('peile',),
'peil': ('peile',),
'peise': ('peise',),
'peiser': ('peise',),
'peises': ('peise',),
'peisa': ('peise',),
'peiset': ('peise',),
'peiste': ('peise',),
'peisa': ('peise',),
'peiset': ('peise',),
'peist': ('peise',),
'peis': ('peise',),
'peke': ('peke',),
'peker': ('peke',),
'pekes': ('peke',),
'pekte': ('peke',),
'pekt': ('peke',),
'pek': ('peke',),
'pelle': ('pelle',),
'peller': ('pelle',),
'pelles': ('pelle',),
'pella': ('pelle',),
'pellet': ('pelle',),
'pelte': ('pelle',),
'pella': ('pelle',),
'pellet': ('pelle',),
'pelt': ('pelle',),
'pell': ('pelle',),
'pelletere': ('pelletere',),
'pelleterer': ('pelletere',),
'pelleteres': ('pelletere',),
'pelleterte': ('pelletere',),
'pelletert': ('pelletere',),
'pelleter': ('pelletere',),
'pelse': ('pelse',),
'pelser': ('pelse',),
'pelses': ('pelse',),
'pelsa': ('pelse',),
'pelset': ('pelse',),
'pelsa': ('pelse',),
'pelset': ('pelse',),
'pels': ('pelse',),
'pendle': ('pendle',),
'pendler': ('pendle',),
'pendles': ('pendle',),
'pendla': ('pendle',),
'pendlet': ('pendle',),
'pendla': ('pendle',),
'pendlet': ('pendle',),
'pendl': ('pendle',),
'pendle': ('pendle',),
'pendl': ('pendle',),
'pendle': ('pendle',),
'penetrere': ('penetrere',),
'penetrerer': ('penetrere',),
'penetreres': ('penetrere',),
'penetrerte': ('penetrere',),
'penetrert': ('penetrere',),
'penetrer': ('penetrere',),
'penne': ('penne',),
'penner': ('penne',),
'pennes': ('penne',),
'penna': ('penne',),
'pennet': ('penne',),
'penna': ('penne',),
'pennet': ('penne',),
'penn': ('penne',),
'pense': ('pense',),
'penser': ('pense',),
'penses': ('pense',),
'pensa': ('pense',),
'penset': ('pense',),
'pensa': ('pense',),
'penset': ('pense',),
'pens': ('pense',),
'pensjonere': ('pensjonere',),
'pensjonerer': ('pensjonere',),
'pensjoneres': ('pensjonere',),
'pensjonerte': ('pensjonere',),
'pensjonert': ('pensjonere',),
'pensjoner': ('pensjonere',),
'pensle': ('pensle',),
'pensler': ('pensle',),
'pensles': ('pensle',),
'pensla': ('pensle',),
'penslet': ('pensle',),
'pensla': ('pensle',),
'penslet': ('pensle',),
'pensl': ('pensle',),
'pensle': ('pensle',),
'pensl': ('pensle',),
'pensle': ('pensle',),
'pepre': ('pepre',),
'peprer': ('pepre',),
'pepres': ('pepre',),
'pepra': ('pepre',),
'pepret': ('pepre',),
'pepra': ('pepre',),
'pepret': ('pepre',),
'pepr': ('pepre',),
'pepre': ('pepre',),
'pepr': ('pepre',),
'pepre': ('pepre',),
'perennere': ('perennere',),
'perennerer': ('perennere',),
'perenneres': ('perennere',),
'perennerte': ('perennere',),
'perennert': ('perennere',),
'perenner': ('perennere',),
'perfeksjonere': ('perfeksjonere',),
'perfeksjonerer': ('perfeksjonere',),
'perfeksjoneres': ('perfeksjonere',),
'perfeksjonerte': ('perfeksjonere',),
'perfeksjonert': ('perfeksjonere',),
'perfeksjoner': ('perfeksjonere',),
'perforere': ('perforere',),
'perforerer': ('perforere',),
'perforeres': ('perforere',),
'perforerte': ('perforere',),
'perforert': ('perforere',),
'perforer': ('perforere',),
'pergamentere': ('pergamentere',),
'pergamenterer': ('pergamentere',),
'pergamenteres': ('pergamentere',),
'pergamenterte': ('pergamentere',),
'pergamentert': ('pergamentere',),
'pergamenter': ('pergamentere',),
'perkolere': ('perkolere',),
'perkolerer': ('perkolere',),
'perkoleres': ('perkolere',),
'perkolerte': ('perkolere',),
'perkolert': ('perkolere',),
'perkoler': ('perkolere',),
'perkutere': ('perkutere',),
'perkuterer': ('perkutere',),
'perkuteres': ('perkutere',),
'perkuterte': ('perkutere',),
'perkutert': ('perkutere',),
'perkuter': ('perkutere',),
'perle': ('perle',),
'perler': ('perle',),
'perles': ('perle',),
'perla': ('perle',),
'perlet': ('perle',),
'perla': ('perle',),
'perlet': ('perle',),
'perl': ('perle',),
'permittere': ('permittere',),
'permitterer': ('permittere',),
'permitteres': ('permittere',),
'permitterte': ('permittere',),
'permittert': ('permittere',),
'permitter': ('permittere',),
'permutere': ('permutere',),
'permuterer': ('permutere',),
'permuteres': ('permutere',),
'permuterte': ('permutere',),
'permutert': ('permutere',),
'permuter': ('permutere',),
'perse': ('perse',),
'perser': ('perse',),
'perses': ('perse',),
'persa': ('perse',),
'perset': ('perse',),
'persa': ('perse',),
'perset': ('perse',),
'pers': ('perse',),
'persiflere': ('persiflere',),
'persiflerer': ('persiflere',),
'persifleres': ('persiflere',),
'persiflerte': ('persiflere',),
'persiflert': ('persiflere',),
'persifler': ('persiflere',),
'persipere': ('persipere',),
'persiperer': ('persipere',),
'persiperes': ('persipere',),
'persiperte': ('persipere',),
'persipert': ('persipere',),
'persiper': ('persipere',),
'persistere': ('persistere',),
'persisterer': ('persistere',),
'persisteres': ('persistere',),
'persisterte': ('persistere',),
'persistert': ('persistere',),
'persister': ('persistere',),
'personifisere': ('personifisere',),
'personifiserer': ('personifisere',),
'personifiseres': ('personifisere',),
'personifiserte': ('personifisere',),
'personifisert': ('personifisere',),
'personifiser': ('personifisere',),
'personliggjøre': ('personliggjøre',),
'personliggjør': ('personliggjøre',),
'personliggjøres': ('personliggjøre',),
'personliggjorde': ('personliggjøre',),
'personliggjort': ('personliggjøre',),
'personliggjør': ('personliggjøre',),
'perspirere': ('perspirere',),
'perspirerer': ('perspirere',),
'perspireres': ('perspirere',),
'perspirerte': ('perspirere',),
'perspirert': ('perspirere',),
'perspirer': ('perspirere',),
'perturbere': ('perturbere',),
'perturberer': ('perturbere',),
'perturberes': ('perturbere',),
'perturberte': ('perturbere',),
'perturbert': ('perturbere',),
'perturber': ('perturbere',),
'pervertere': ('pervertere',),
'perverterer': ('pervertere',),
'perverteres': ('pervertere',),
'perverterte': ('pervertere',),
'pervertert': ('pervertere',),
'perverter': ('pervertere',),
'pese': ('pese',),
'peser': ('pese',),
'peses': ('pese',),
'peste': ('pese',),
'pest': ('pese',),
'pes': ('pese',),
'piffe': ('piffe',),
'piffer': ('piffe',),
'piffes': ('piffe',),
'piffa': ('piffe',),
'piffet': ('piffe',),
'piffa': ('piffe',),
'piffet': ('piffe',),
'piff': ('piffe',),
'pigge': ('pigge',),
'pigger': ('pigge',),
'pigges': ('pigge',),
'pigga': ('pigge',),
'pigget': ('pigge',),
'pigga': ('pigge',),
'pigget': ('pigge',),
'pigg': ('pigge',),
'pigmentere': ('pigmentere',),
'pigmenterer': ('pigmentere',),
'pigmenteres': ('pigmentere',),
'pigmenterte': ('pigmentere',),
'pigmentert': ('pigmentere',),
'pigmenter': ('pigmentere',),
'pikere': ('pikere',),
'pikerer': ('pikere',),
'pikeres': ('pikere',),
'pikerte': ('pikere',),
'pikert': ('pikere',),
'piker': ('pikere',),
'pikke': ('pikke',),
'pikker': ('pikke',),
'pikkes': ('pikke',),
'pikka': ('pikke',),
'pikket': ('pikke',),
'pikka': ('pikke',),
'pikket': ('pikke',),
'pikk': ('pikke',),
'pile': ('pile',),
'piler': ('pile',),
'piles': ('pile',),
'pilte': ('pile',),
'pilt': ('pile',),
'pil': ('pile',),
'pilke': ('pilke',),
'pilker': ('pilke',),
'pilkes': ('pilke',),
'pilka': ('pilke',),
'pilket': ('pilke',),
'pilka': ('pilke',),
'pilket': ('pilke',),
'pilk': ('pilke',),
'pilte': ('pilte',),
'pilter': ('pilte',),
'piltes': ('pilte',),
'pilta': ('pilte',),
'piltet': ('pilte',),
'pilta': ('pilte',),
'piltet': ('pilte',),
'pilt': ('pilte',),
'pimpe': ('pimpe',),
'pimper': ('pimpe',),
'pimpes': ('pimpe',),
'pimpa': ('pimpe',),
'pimpet': ('pimpe',),
'pimpa': ('pimpe',),
'pimpet': ('pimpe',),
'pimp': ('pimpe',),
'pine': ('pine',),
'piner': ('pine',),
'pines': ('pine',),
'pinte': ('pine',),
'pint': ('pine',),
'pin': ('pine',),
'pinke': ('pinke',),
'pinker': ('pinke',),
'pinkes': ('pinke',),
'pinka': ('pinke',),
'pinket': ('pinke',),
'pinka': ('pinke',),
'pinket': ('pinke',),
'pink': ('pinke',),
'pinne': ('pinne',),
'pinner': ('pinne',),
'pinnes': ('pinne',),
'pinna': ('pinne',),
'pinnet': ('pinne',),
'pinna': ('pinne',),
'pinnet': ('pinne',),
'pinn': ('pinne',),
'pinse': ('pinse',),
'pinser': ('pinse',),
'pinses': ('pinse',),
'pinsa': ('pinse',),
'pinset': ('pinse',),
'pinsa': ('pinse',),
'pinset': ('pinse',),
'pins': ('pinse',),
'pipe': ('pipe',),
'piper': ('pipe',),
'pipes': ('pipe',),
'pep': ('pipe',),
'peip': ('pipe',),
'pep': ('pipe',),
'peip': ('pipe',),
'pepet': ('pipe',),
'pip': ('pipe',),
'piple': ('piple',),
'pipler': ('piple',),
'piples': ('piple',),
'pipla': ('piple',),
'piplet': ('piple',),
'pipla': ('piple',),
'piplet': ('piple',),
'pipl': ('piple',),
'piple': ('piple',),
'pipl': ('piple',),
'piple': ('piple',),
'pippe': ('pippe',),
'pipper': ('pippe',),
'pippes': ('pippe',),
'pippa': ('pippe',),
'pippet': ('pippe',),
'pippa': ('pippe',),
'pippet': ('pippe',),
'pipp': ('pippe',),
'pirke': ('pirke',),
'pirker': ('pirke',),
'pirkes': ('pirke',),
'pirka': ('pirke',),
'pirket': ('pirke',),
'pirka': ('pirke',),
'pirket': ('pirke',),
'pirk': ('pirke',),
'pirre': ('pirre',),
'pirrer': ('pirre',),
'pirres': ('pirre',),
'pirra': ('pirre',),
'pirret': ('pirre',),
'pirra': ('pirre',),
'pirret': ('pirre',),
'pirr': ('pirre',),
'piruettere': ('piruettere',),
'piruetterer': ('piruettere',),
'piruetteres': ('piruettere',),
'piruetterte': ('piruettere',),
'piruettert': ('piruettere',),
'piruetter': ('piruettere',),
'piske': ('piske',),
'pisker': ('piske',),
'piskes': ('piske',),
'piska': ('piske',),
'pisket': ('piske',),
'piska': ('piske',),
'pisket': ('piske',),
'pisk': ('piske',),
'pisse': ('pisse',),
'pisser': ('pisse',),
'pisses': ('pisse',),
'pissa': ('pisse',),
'pisset': ('pisse',),
'piste': ('pisse',),
'pissa': ('pisse',),
'pisset': ('pisse',),
'pist': ('pisse',),
'piss': ('pisse',),
'piste': ('piste',),
'pister': ('piste',),
'pistes': ('piste',),
'pista': ('piste',),
'pistet': ('piste',),
'pista': ('piste',),
'pistet': ('piste',),
'pist': ('piste',),
'pistre': ('pistre',),
'pistrer': ('pistre',),
'pistres': ('pistre',),
'pistra': ('pistre',),
'pistret': ('pistre',),
'pistra': ('pistre',),
'pistret': ('pistre',),
'pistr': ('pistre',),
'pistre': ('pistre',),
'pistr': ('pistre',),
'pistre': ('pistre',),
'pitle': ('pitle',),
'pitler': ('pitle',),
'pitles': ('pitle',),
'pitla': ('pitle',),
'pitlet': ('pitle',),
'pitla': ('pitle',),
'pitlet': ('pitle',),
'pitl': ('pitle',),
'pitle': ('pitle',),
'pitl': ('pitle',),
'pitle': ('pitle',),
'pjalle': ('pjalle',),
'pjaller': ('pjalle',),
'pjalles': ('pjalle',),
'pjalla': ('pjalle',),
'pjallet': ('pjalle',),
'pjalla': ('pjalle',),
'pjallet': ('pjalle',),
'pjall': ('pjalle',),
'pjatte': ('pjatte',),
'pjatter': ('pjatte',),
'pjattes': ('pjatte',),
'pjatta': ('pjatte',),
'pjattet': ('pjatte',),
'pjatta': ('pjatte',),
'pjattet': ('pjatte',),
'pjatt': ('pjatte',),
'pjoltre': ('pjoltre',),
'pjoltrer': ('pjoltre',),
'pjoltres': ('pjoltre',),
'pjoltra': ('pjoltre',),
'pjoltret': ('pjoltre',),
'pjoltra': ('pjoltre',),
'pjoltret': ('pjoltre',),
'pjoltr': ('pjoltre',),
'pjoltre': ('pjoltre',),
'pjoltr': ('pjoltre',),
'pjoltre': ('pjoltre',),
'pjuske': ('pjuske',),
'pjusker': ('pjuske',),
'pjuskes': ('pjuske',),
'pjuska': ('pjuske',),
'pjusket': ('pjuske',),
'pjuska': ('pjuske',),
'pjusket': ('pjuske',),
'pjusk': ('pjuske',),
'pjutre': ('pjutre',),
'pjutrer': ('pjutre',),
'pjutres': ('pjutre',),
'pjutra': ('pjutre',),
'pjutret': ('pjutre',),
'pjutra': ('pjutre',),
'pjutret': ('pjutre',),
'pjutr': ('pjutre',),
'pjutre': ('pjutre',),
'pjutr': ('pjutre',),
'pjutre': ('pjutre',),
'plaffe': ('plaffe',),
'plaffer': ('plaffe',),
'plaffes': ('plaffe',),
'plaffa': ('plaffe',),
'plaffet': ('plaffe',),
'plaffa': ('plaffe',),
'plaffet': ('plaffe',),
'plaff': ('plaffe',),
'plage': ('plage',),
'plager': ('plage',),
'plages': ('plage',),
'plaga': ('plage',),
'plaget': ('plage',),
'plagde': ('plage',),
'plaga': ('plage',),
'plaget': ('plage',),
'plagd': ('plage',),
'plag': ('plage',),
'plagiere': ('plagiere',),
'plagierer': ('plagiere',),
'plagieres': ('plagiere',),
'plagierte': ('plagiere',),
'plagiert': ('plagiere',),
'plagier': ('plagiere',),
'plane': ('plane',),
'planer': ('plane',),
'planes': ('plane',),
'plana': ('plane',),
'planet': ('plane',),
'plante': ('plane',),
'plana': ('plane',),
'planet': ('plane',),
'plant': ('plane',),
'plan': ('plane',),
'planere': ('planere',),
'planerer': ('planere',),
'planeres': ('planere',),
'planerte': ('planere',),
'planert': ('planere',),
'planer': ('planere',),
'planlegge': ('planlegge',),
'planlegger': ('planlegge',),
'planlegges': ('planlegge',),
'planla': ('planlegge',),
'planlagt': ('planlegge',),
'planlegg': ('planlegge',),
'plante': ('plante',),
'planter': ('plante',),
'plantes': ('plante',),
'planta': ('plante',),
'plantet': ('plante',),
'planta': ('plante',),
'plantet': ('plante',),
'plant': ('plante',),
'plapre': ('plapre',),
'plaprer': ('plapre',),
'plapres': ('plapre',),
'plapra': ('plapre',),
'plapret': ('plapre',),
'plapra': ('plapre',),
'plapret': ('plapre',),
'plapr': ('plapre',),
'plapre': ('plapre',),
'plapr': ('plapre',),
'plapre': ('plapre',),
'plaske': ('plaske',),
'plasker': ('plaske',),
'plaskes': ('plaske',),
'plaska': ('plaske',),
'plasket': ('plaske',),
'plaska': ('plaske',),
'plasket': ('plaske',),
'plask': ('plaske',),
'plassere': ('plassere',),
'plasserer': ('plassere',),
'plasseres': ('plassere',),
'plasserte': ('plassere',),
'plassert': ('plassere',),
'plasser': ('plassere',),
'plastre': ('plastre',),
'plastrer': ('plastre',),
'plastres': ('plastre',),
'plastra': ('plastre',),
'plastret': ('plastre',),
'plastra': ('plastre',),
'plastret': ('plastre',),
'plastr': ('plastre',),
'plastre': ('plastre',),
'plastr': ('plastre',),
'plastre': ('plastre',),
'platinere': ('platinere',),
'platinerer': ('platinere',),
'platineres': ('platinere',),
'platinerte': ('platinere',),
'platinert': ('platinere',),
'platiner': ('platinere',),
'pledere': ('pledere',),
'plederer': ('pledere',),
'plederes': ('pledere',),
'plederte': ('pledere',),
'pledert': ('pledere',),
'pleder': ('pledere',),
'pleie': ('pleie',),
'pleier': ('pleie',),
'pleies': ('pleie',),
'pleia': ('pleie',),
'pleiet': ('pleie',),
'pleide': ('pleie',),
'pleia': ('pleie',),
'pleiet': ('pleie',),
'pleid': ('pleie',),
'plei': ('pleie',),
'pleie': ('pleie',),
'pleier': ('pleie',),
'pleies': ('pleie',),
'pleide': ('pleie',),
'pleid': ('pleie',),
'plei': ('pleie',),
'plette': ('plette',),
'pletter': ('plette',),
'plettes': ('plette',),
'pletta': ('plette',),
'plettet': ('plette',),
'pletta': ('plette',),
'plettet': ('plette',),
'plett': ('plette',),
'plettere': ('plettere',),
'pletterer': ('plettere',),
'pletteres': ('plettere',),
'pletterte': ('plettere',),
'plettert': ('plettere',),
'pletter': ('plettere',),
'plikte': ('plikte',),
'plikter': ('plikte',),
'pliktes': ('plikte',),
'plikta': ('plikte',),
'pliktet': ('plikte',),
'plikta': ('plikte',),
'pliktet': ('plikte',),
'plikt': ('plikte',),
'plinge': ('plinge',),
'plinger': ('plinge',),
'plinges': ('plinge',),
'plinga': ('plinge',),
'plinget': ('plinge',),
'plinga': ('plinge',),
'plinget': ('plinge',),
'pling': ('plinge',),
'plire': ('plire',),
'plirer': ('plire',),
'plires': ('plire',),
'pliret': ('plire',),
'plirte': ('plire',),
'pliret': ('plire',),
'plirt': ('plire',),
'plir': ('plire',),
'plissere': ('plissere',),
'plisserer': ('plissere',),
'plisseres': ('plissere',),
'plisserte': ('plissere',),
'plissert': ('plissere',),
'plisser': ('plissere',),
'ploge': ('ploge',),
'ploger': ('ploge',),
'ploges': ('ploge',),
'ploga': ('ploge',),
'ploget': ('ploge',),
'ploga': ('ploge',),
'ploget': ('ploge',),
'plog': ('ploge',),
'plombere': ('plombere',),
'plomberer': ('plombere',),
'plomberes': ('plombere',),
'plomberte': ('plombere',),
'plombert': ('plombere',),
'plomber': ('plombere',),
'plotte': ('plotte',),
'plotter': ('plotte',),
'plottes': ('plotte',),
'plotta': ('plotte',),
'plottet': ('plotte',),
'plotta': ('plotte',),
'plottet': ('plotte',),
'plott': ('plotte',),
'pludre': ('pludre',),
'pludrer': ('pludre',),
'pludres': ('pludre',),
'pludra': ('pludre',),
'pludret': ('pludre',),
'pludra': ('pludre',),
'pludret': ('pludre',),
'pludr': ('pludre',),
'pludre': ('pludre',),
'pludr': ('pludre',),
'pludre': ('pludre',),
'plugge': ('plugge',),
'plugger': ('plugge',),
'plugges': ('plugge',),
'plugga': ('plugge',),
'plugget': ('plugge',),
'plugga': ('plugge',),
'plugget': ('plugge',),
'plugg': ('plugge',),
'plukke': ('plukke',),
'plukker': ('plukke',),
'plukkes': ('plukke',),
'plukka': ('plukke',),
'plukket': ('plukke',),
'plukka': ('plukke',),
'plukket': ('plukke',),
'plukk': ('plukke',),
'plumpe': ('plumpe',),
'plumper': ('plumpe',),
'plumpes': ('plumpe',),
'plumpa': ('plumpe',),
'plumpet': ('plumpe',),
'plumpa': ('plumpe',),
'plumpet': ('plumpe',),
'plump': ('plumpe',),
'plundre': ('plundre',),
'plundrer': ('plundre',),
'plundres': ('plundre',),
'plundra': ('plundre',),
'plundret': ('plundre',),
'plundra': ('plundre',),
'plundret': ('plundre',),
'plundr': ('plundre',),
'plundre': ('plundre',),
'plundr': ('plundre',),
'plundre': ('plundre',),
'plusse': ('plusse',),
'plusser': ('plusse',),
'plusses': ('plusse',),
'plussa': ('plusse',),
'plusset': ('plusse',),
'plussa': ('plusse',),
'plusset': ('plusse',),
'pluss': ('plusse',),
'plyndre': ('plyndre',),
'plyndrer': ('plyndre',),
'plyndres': ('plyndre',),
'plyndra': ('plyndre',),
'plyndret': ('plyndre',),
'plyndra': ('plyndre',),
'plyndret': ('plyndre',),
'plyndr': ('plyndre',),
'plyndre': ('plyndre',),
'plyndr': ('plyndre',),
'plyndre': ('plyndre',),
'plystre': ('plystre',),
'plystrer': ('plystre',),
'plystres': ('plystre',),
'plystra': ('plystre',),
'plystret': ('plystre',),
'plystra': ('plystre',),
'plystret': ('plystre',),
'plystr': ('plystre',),
'plystre': ('plystre',),
'plystr': ('plystre',),
'plystre': ('plystre',),
'pløse': ('pløse',),
'pløser': ('pløse',),
'pløses': ('pløse',),
'pløste': ('pløse',),
'pløst': ('pløse',),
'pløs': ('pløse',),
'pløye': ('pløye',),
'pløyer': ('pløye',),
'pløyes': ('pløye',),
'pløyde': ('pløye',),
'pløyd': ('pløye',),
'pløy': ('pløye',),
'pode': ('pode',),
'poder': ('pode',),
'podes': ('pode',),
'poda': ('pode',),
'podet': ('pode',),
'poda': ('pode',),
'podet': ('pode',),
'pod': ('pode',),
'poengtere': ('poengtere',),
'poengterer': ('poengtere',),
'poengteres': ('poengtere',),
'poengterte': ('poengtere',),
'poengtert': ('poengtere',),
'poengter': ('poengtere',),
'poetisere': ('poetisere',),
'poetiserer': ('poetisere',),
'poetiseres': ('poetisere',),
'poetiserte': ('poetisere',),
'poetisert': ('poetisere',),
'poetiser': ('poetisere',),
'pokre': ('pokre',),
'pokrer': ('pokre',),
'pokres': ('pokre',),
'pokra': ('pokre',),
'pokret': ('pokre',),
'pokra': ('pokre',),
'pokret': ('pokre',),
'pokr': ('pokre',),
'pokre': ('pokre',),
'pokr': ('pokre',),
'pokre': ('pokre',),
'pokulere': ('pokulere',),
'pokulerer': ('pokulere',),
'pokuleres': ('pokulere',),
'pokulerte': ('pokulere',),
'pokulert': ('pokulere',),
'pokuler': ('pokulere',),
'polarisere': ('polarisere',),
'polariserer': ('polarisere',),
'polariseres': ('polarisere',),
'polariserte': ('polarisere',),
'polarisert': ('polarisere',),
'polariser': ('polarisere',),
'pole': ('pole',),
'poler': ('pole',),
'poles': ('pole',),
'pola': ('pole',),
'polet': ('pole',),
'polte': ('pole',),
'pola': ('pole',),
'polet': ('pole',),
'polt': ('pole',),
'pol': ('pole',),
'polemisere': ('polemisere',),
'polemiserer': ('polemisere',),
'polemiseres': ('polemisere',),
'polemiserte': ('polemisere',),
'polemisert': ('polemisere',),
'polemiser': ('polemisere',),
'polere': ('polere',),
'polerer': ('polere',),
'poleres': ('polere',),
'polerte': ('polere',),
'polert': ('polere',),
'poler': ('polere',),
'politisere': ('politisere',),
'politiserer': ('politisere',),
'politiseres': ('politisere',),
'politiserte': ('politisere',),
'politisert': ('politisere',),
'politiser': ('politisere',),
'pollinere': ('pollinere',),
'pollinerer': ('pollinere',),
'pollineres': ('pollinere',),
'pollinerte': ('pollinere',),
'pollinert': ('pollinere',),
'polliner': ('pollinere',),
'polstre': ('polstre',),
'polstrer': ('polstre',),
'polstres': ('polstre',),
'polstra': ('polstre',),
'polstret': ('polstre',),
'polstra': ('polstre',),
'polstret': ('polstre',),
'polstr': ('polstre',),
'polstre': ('polstre',),
'polstr': ('polstre',),
'polstre': ('polstre',),
'polymerisere': ('polymerisere',),
'polymeriserer': ('polymerisere',),
'polymeriseres': ('polymerisere',),
'polymeriserte': ('polymerisere',),
'polymerisert': ('polymerisere',),
'polymeriser': ('polymerisere',),
'pomadisere': ('pomadisere',),
'pomadiserer': ('pomadisere',),
'pomadiseres': ('pomadisere',),
'pomadiserte': ('pomadisere',),
'pomadisert': ('pomadisere',),
'pomadiser': ('pomadisere',),
'poncere': ('poncere',),
'poncerer': ('poncere',),
'ponceres': ('poncere',),
'poncerte': ('poncere',),
'poncert': ('poncere',),
'poncer': ('poncere',),
'ponere': ('ponere',),
'ponerer': ('ponere',),
'poneres': ('ponere',),
'ponerte': ('ponere',),
'ponert': ('ponere',),
'poner': ('ponere',),
'poppe': ('poppe',),
'popper': ('poppe',),
'poppes': ('poppe',),
'poppa': ('poppe',),
'poppet': ('poppe',),
'poppa': ('poppe',),
'poppet': ('poppe',),
'popp': ('poppe',),
'popularisere': ('popularisere',),
'populariserer': ('popularisere',),
'populariseres': ('popularisere',),
'populariserte': ('popularisere',),
'popularisert': ('popularisere',),
'populariser': ('popularisere',),
'porsjonere': ('porsjonere',),
'porsjonerer': ('porsjonere',),
'porsjoneres': ('porsjonere',),
'porsjonerte': ('porsjonere',),
'porsjonert': ('porsjonere',),
'porsjoner': ('porsjonere',),
'portrettere': ('portrettere',),
'portretterer': ('portrettere',),
'portretteres': ('portrettere',),
'portretterte': ('portrettere',),
'portrettert': ('portrettere',),
'portretter': ('portrettere',),
'pose': ('pose',),
'poser': ('pose',),
'poses': ('pose',),
'posa': ('pose',),
'poset': ('pose',),
'posa': ('pose',),
'poset': ('pose',),
'pos': ('pose',),
'posere': ('posere',),
'poserer': ('posere',),
'poseres': ('posere',),
'poserte': ('posere',),
'posert': ('posere',),
'poser': ('posere',),
'posisjonere': ('posisjonere',),
'posisjonerer': ('posisjonere',),
'posisjoneres': ('posisjonere',),
'posisjonerte': ('posisjonere',),
'posisjonert': ('posisjonere',),
'posisjoner': ('posisjonere',),
'posjere': ('posjere',),
'posjerer': ('posjere',),
'posjeres': ('posjere',),
'posjerte': ('posjere',),
'posjert': ('posjere',),
'posjer': ('posjere',),
'postdatere': ('postdatere',),
'postdaterer': ('postdatere',),
'postdateres': ('postdatere',),
'postdaterte': ('postdatere',),
'postdatert': ('postdatere',),
'postdater': ('postdatere',),
'poste': ('poste',),
'poster': ('poste',),
'postes': ('poste',),
'posta': ('poste',),
'postet': ('poste',),
'posta': ('poste',),
'postet': ('poste',),
'post': ('poste',),
'postere': ('postere',),
'posterer': ('postere',),
'posteres': ('postere',),
'posterte': ('postere',),
'postert': ('postere',),
'poster': ('postere',),
'postlegge': ('postlegge',),
'postlegger': ('postlegge',),
'postlegges': ('postlegge',),
'postla': ('postlegge',),
'postlagt': ('postlegge',),
'postlegg': ('postlegge',),
'poststemple': ('poststemple',),
'poststempler': ('poststemple',),
'poststemples': ('poststemple',),
'poststempla': ('poststemple',),
'poststemplet': ('poststemple',),
'poststempla': ('poststemple',),
'poststemplet': ('poststemple',),
'poststempl': ('poststemple',),
'poststemple': ('poststemple',),
'poststempl': ('poststemple',),
'poststemple': ('poststemple',),
'postulere': ('postulere',),
'postulerer': ('postulere',),
'postuleres': ('postulere',),
'postulerte': ('postulere',),
'postulert': ('postulere',),
'postuler': ('postulere',),
'potensere': ('potensere',),
'potenserer': ('potensere',),
'potenseres': ('potensere',),
'potenserte': ('potensere',),
'potensert': ('potensere',),
'potenser': ('potensere',),
'potte': ('potte',),
'potter': ('potte',),
'pottes': ('potte',),
'potta': ('potte',),
'pottet': ('potte',),
'potta': ('potte',),
'pottet': ('potte',),
'pott': ('potte',),
'praie': ('praie',),
'praier': ('praie',),
'praies': ('praie',),
'praia': ('praie',),
'praiet': ('praie',),
'praia': ('praie',),
'praiet': ('praie',),
'prai': ('praie',),
'prakke': ('prakke',),
'prakker': ('prakke',),
'prakkes': ('prakke',),
'prakka': ('prakke',),
'prakket': ('prakke',),
'prakka': ('prakke',),
'prakket': ('prakke',),
'prakk': ('prakke',),
'praktisere': ('praktisere',),
'praktiserer': ('praktisere',),
'praktiseres': ('praktisere',),
'praktiserte': ('praktisere',),
'praktisert': ('praktisere',),
'praktiser': ('praktisere',),
'prale': ('prale',),
'praler': ('prale',),
'prales': ('prale',),
'pralet': ('prale',),
'pralte': ('prale',),
'pralet': ('prale',),
'pralt': ('prale',),
'pral': ('prale',),
'prange': ('prange',),
'pranger': ('prange',),
'pranges': ('prange',),
'pranga': ('prange',),
'pranget': ('prange',),
'pranga': ('prange',),
'pranget': ('prange',),
'prang': ('prange',),
'prasle': ('prasle',),
'prasler': ('prasle',),
'prasles': ('prasle',),
'prasla': ('prasle',),
'praslet': ('prasle',),
'prasla': ('prasle',),
'praslet': ('prasle',),
'prasl': ('prasle',),
'prasle': ('prasle',),
'prasl': ('prasle',),
'prasle': ('prasle',),
'prate': ('prate',),
'prater': ('prate',),
'prates': ('prate',),
'prata': ('prate',),
'pratet': ('prate',),
'prata': ('prate',),
'pratet': ('prate',),
'prat': ('prate',),
'predestinere': ('predestinere',),
'predestinerer': ('predestinere',),
'predestineres': ('predestinere',),
'predestinerte': ('predestinere',),
'predestinert': ('predestinere',),
'predestiner': ('predestinere',),
'predeterminere': ('predeterminere',),
'predeterminerer': ('predeterminere',),
'predetermineres': ('predeterminere',),
'predeterminerte': ('predeterminere',),
'predeterminert': ('predeterminere',),
'predeterminer': ('predeterminere',),
'predike': ('predike',),
'prediker': ('predike',),
'predikes': ('predike',),
'predika': ('predike',),
'prediket': ('predike',),
'predika': ('predike',),
'prediket': ('predike',),
'predik': ('predike',),
'predikere': ('predikere',),
'predikerer': ('predikere',),
'predikeres': ('predikere',),
'predikerte': ('predikere',),
'predikert': ('predikere',),
'prediker': ('predikere',),
'predisponere': ('predisponere',),
'predisponerer': ('predisponere',),
'predisponeres': ('predisponere',),
'predisponerte': ('predisponere',),
'predisponert': ('predisponere',),
'predisponer': ('predisponere',),
'prefabrikkere': ('prefabrikkere',),
'prefabrikkerer': ('prefabrikkere',),
'prefabrikkeres': ('prefabrikkere',),
'prefabrikkerte': ('prefabrikkere',),
'prefabrikkert': ('prefabrikkere',),
'prefabrikker': ('prefabrikkere',),
'preferere': ('preferere',),
'prefererer': ('preferere',),
'prefereres': ('preferere',),
'prefererte': ('preferere',),
'preferert': ('preferere',),
'preferer': ('preferere',),
'prege': ('prege',),
'preger': ('prege',),
'preges': ('prege',),
'prega': ('prege',),
'preget': ('prege',),
'prega': ('prege',),
'preget': ('prege',),
'preg': ('prege',),
'prekavere': ('prekavere',),
'prekaverer': ('prekavere',),
'prekaveres': ('prekavere',),
'prekaverte': ('prekavere',),
'prekavert': ('prekavere',),
'prekaver': ('prekavere',),
'preke': ('preke',),
'preker': ('preke',),
'prekes': ('preke',),
'prekte': ('preke',),
'prekt': ('preke',),
'prek': ('preke',),
'prelle': ('prelle',),
'preller': ('prelle',),
'prelles': ('prelle',),
'prella': ('prelle',),
'prellet': ('prelle',),
'prella': ('prelle',),
'prellet': ('prelle',),
'prell': ('prelle',),
'preludere': ('preludere',),
'preluderer': ('preludere',),
'preluderes': ('preludere',),
'preluderte': ('preludere',),
'preludert': ('preludere',),
'preluder': ('preludere',),
'premiere': ('premiere',),
'premierer': ('premiere',),
'premieres': ('premiere',),
'premierte': ('premiere',),
'premiert': ('premiere',),
'premier': ('premiere',),
'prente': ('prente',),
'prenter': ('prente',),
'prentes': ('prente',),
'prenta': ('prente',),
'prentet': ('prente',),
'prenta': ('prente',),
'prentet': ('prente',),
'prent': ('prente',),
'prenumerere': ('prenumerere',),
'prenumererer': ('prenumerere',),
'prenumereres': ('prenumerere',),
'prenumererte': ('prenumerere',),
'prenumerert': ('prenumerere',),
'prenumerer': ('prenumerere',),
'preparere': ('preparere',),
'preparerer': ('preparere',),
'prepareres': ('preparere',),
'preparerte': ('preparere',),
'preparert': ('preparere',),
'preparer': ('preparere',),
'preppe': ('preppe',),
'prepper': ('preppe',),
'preppes': ('preppe',),
'preppa': ('preppe',),
'preppet': ('preppe',),
'preppa': ('preppe',),
'preppet': ('preppe',),
'prepp': ('preppe',),
'presentere': ('presentere',),
'presenterer': ('presentere',),
'presenteres': ('presentere',),
'presenterte': ('presentere',),
'presentert': ('presentere',),
'presenter': ('presentere',),
'preservere': ('preservere',),
'preserverer': ('preservere',),
'preserveres': ('preservere',),
'preserverte': ('preservere',),
'preservert': ('preservere',),
'preserver': ('preservere',),
'presidere': ('presidere',),
'presiderer': ('presidere',),
'presideres': ('presidere',),
'presiderte': ('presidere',),
'presidert': ('presidere',),
'presider': ('presidere',),
'presisere': ('presisere',),
'presiserer': ('presisere',),
'presiseres': ('presisere',),
'presiserte': ('presisere',),
'presisert': ('presisere',),
'presiser': ('presisere',),
'preskribere': ('preskribere',),
'preskriberer': ('preskribere',),
'preskriberes': ('preskribere',),
'preskriberte': ('preskribere',),
'preskribert': ('preskribere',),
'preskriber': ('preskribere',),
'presse': ('presse',),
'presser': ('presse',),
'presses': ('presse',),
'pressa': ('presse',),
'presset': ('presse',),
'pressa': ('presse',),
'presset': ('presse',),
'press': ('presse',),
'prestere': ('prestere',),
'presterer': ('prestere',),
'presteres': ('prestere',),
'presterte': ('prestere',),
'prestert': ('prestere',),
'prester': ('prestere',),
'prestevie': ('prestevie',),
'prestevier': ('prestevie',),
'prestevies': ('prestevie',),
'prestevia': ('prestevie',),
'presteviet': ('prestevie',),
'prestevidde': ('prestevie',),
'prestevigde': ('prestevie',),
'prestevia': ('prestevie',),
'presteviet': ('prestevie',),
'prestevidd': ('prestevie',),
'prestevigd': ('prestevie',),
'prestevi': ('prestevie',),
'presumere': ('presumere',),
'presumerer': ('presumere',),
'presumeres': ('presumere',),
'presumerte': ('presumere',),
'presumert': ('presumere',),
'presumer': ('presumere',),
'presupponere': ('presupponere',),
'presupponerer': ('presupponere',),
'presupponeres': ('presupponere',),
'presupponerte': ('presupponere',),
'presupponert': ('presupponere',),
'presupponer': ('presupponere',),
'pretendere': ('pretendere',),
'pretenderer': ('pretendere',),
'pretenderes': ('pretendere',),
'pretenderte': ('pretendere',),
'pretendert': ('pretendere',),
'pretender': ('pretendere',),
'prette': ('prette',),
'pretter': ('prette',),
'prettes': ('prette',),
'pretta': ('prette',),
'prettet': ('prette',),
'pretta': ('prette',),
'prettet': ('prette',),
'prett': ('prette',),
'prikke': ('prikke',),
'prikker': ('prikke',),
'prikkes': ('prikke',),
'prikka': ('prikke',),
'prikket': ('prikke',),
'prikka': ('prikke',),
'prikket': ('prikke',),
'prikk': ('prikke',),
'prikle': ('prikle',),
'prikler': ('prikle',),
'prikles': ('prikle',),
'prikla': ('prikle',),
'priklet': ('prikle',),
'prikla': ('prikle',),
'priklet': ('prikle',),
'prikl': ('prikle',),
'prikle': ('prikle',),
'prikl': ('prikle',),
'prikle': ('prikle',),
'prille': ('prille',),
'priller': ('prille',),
'prilles': ('prille',),
'prilla': ('prille',),
'prillet': ('prille',),
'prilla': ('prille',),
'prillet': ('prille',),
'prill': ('prille',),
'prime': ('prime',),
'primer': ('prime',),
'primes': ('prime',),
'prima': ('prime',),
'primet': ('prime',),
'primte': ('prime',),
'prima': ('prime',),
'primet': ('prime',),
'primt': ('prime',),
'prim': ('prime',),
'primsigne': ('primsigne',),
'primsigner': ('primsigne',),
'primsignes': ('primsigne',),
'primsigna': ('primsigne',),
'primsignet': ('primsigne',),
'primsigna': ('primsigne',),
'primsignet': ('primsigne',),
'primsign': ('primsigne',),
'prioritere': ('prioritere',),
'prioriterer': ('prioritere',),
'prioriteres': ('prioritere',),
'prioriterte': ('prioritere',),
'prioritert': ('prioritere',),
'prioriter': ('prioritere',),
'prisbelønne': ('prisbelønne',),
'prisbelønner': ('prisbelønne',),
'prisbelønnes': ('prisbelønne',),
'prisbelønna': ('prisbelønne',),
'prisbelønnet': ('prisbelønne',),
'prisbelønte': ('prisbelønne',),
'prisbelønna': ('prisbelønne',),
'prisbelønnet': ('prisbelønne',),
'prisbelønt': ('prisbelønne',),
'prisbelønn': ('prisbelønne',),
'prise': ('prise',),
'priser': ('prise',),
'prises': ('prise',),
'prisa': ('prise',),
'priset': ('prise',),
'prisa': ('prise',),
'priset': ('prise',),
'pris': ('prise',),
'prise': ('prise',),
'priser': ('prise',),
'prises': ('prise',),
'priste': ('prise',),
'prist': ('prise',),
'pris': ('prise',),
'prisgi': ('prisgi',),
'prisgir': ('prisgi',),
'prisgis': ('prisgi',),
'prisgav': ('prisgi',),
'prisga': ('prisgi',),
'prisgitt': ('prisgi',),
'prisgi': ('prisgi',),
'privatisere': ('privatisere',),
'privatiserer': ('privatisere',),
'privatiseres': ('privatisere',),
'privatiserte': ('privatisere',),
'privatisert': ('privatisere',),
'privatiser': ('privatisere',),
'privilegere': ('privilegere',),
'privilegerer': ('privilegere',),
'privilegeres': ('privilegere',),
'privilegerte': ('privilegere',),
'privilegert': ('privilegere',),
'privileger': ('privilegere',),
'probere': ('probere',),
'proberer': ('probere',),
'proberes': ('probere',),
'proberte': ('probere',),
'probert': ('probere',),
'prober': ('probere',),
'problematisere': ('problematisere',),
'problematiserer': ('problematisere',),
'problematiseres': ('problematisere',),
'problematiserte': ('problematisere',),
'problematisert': ('problematisere',),
'problematiser': ('problematisere',),
'produsere': ('produsere',),
'produserer': ('produsere',),
'produseres': ('produsere',),
'produserte': ('produsere',),
'produsert': ('produsere',),
'produser': ('produsere',),
'proe': ('proe',),
'proer': ('proe',),
'proes': ('proe',),
'proa': ('proe',),
'proet': ('proe',),
'proa': ('proe',),
'proet': ('proe',),
'pro': ('proe',),
'profanere': ('profanere',),
'profanerer': ('profanere',),
'profaneres': ('profanere',),
'profanerte': ('profanere',),
'profanert': ('profanere',),
'profaner': ('profanere',),
'profesjonalisere': ('profesjonalisere',),
'profesjonaliserer': ('profesjonalisere',),
'profesjonaliseres': ('profesjonalisere',),
'profesjonaliserte': ('profesjonalisere',),
'profesjonalisert': ('profesjonalisere',),
'profesjonaliser': ('profesjonalisere',),
'profetere': ('profetere',),
'profeterer': ('profetere',),
'profeteres': ('profetere',),
'profeterte': ('profetere',),
'profetert': ('profetere',),
'profeter': ('profetere',),
'profilere': ('profilere',),
'profilerer': ('profilere',),
'profileres': ('profilere',),
'profilerte': ('profilere',),
'profilert': ('profilere',),
'profiler': ('profilere',),
'profittere': ('profittere',),
'profitterer': ('profittere',),
'profitteres': ('profittere',),
'profitterte': ('profittere',),
'profittert': ('profittere',),
'profitter': ('profittere',),
'prognosere': ('prognosere',),
'prognoserer': ('prognosere',),
'prognoseres': ('prognosere',),
'prognoserte': ('prognosere',),
'prognosert': ('prognosere',),
'prognoser': ('prognosere',),
'prognostisere': ('prognostisere',),
'prognostiserer': ('prognostisere',),
'prognostiseres': ('prognostisere',),
'prognostiserte': ('prognostisere',),
'prognostisert': ('prognostisere',),
'prognostiser': ('prognostisere',),
'programfeste': ('programfeste',),
'programfester': ('programfeste',),
'programfestes': ('programfeste',),
'programfesta': ('programfeste',),
'programfestet': ('programfeste',),
'programfesta': ('programfeste',),
'programfestet': ('programfeste',),
'programfest': ('programfeste',),
'programmere': ('programmere',),
'programmerer': ('programmere',),
'programmeres': ('programmere',),
'programmerte': ('programmere',),
'programmert': ('programmere',),
'programmer': ('programmere',),
'projisere': ('projisere',),
'projiserer': ('projisere',),
'projiseres': ('projisere',),
'projiserte': ('projisere',),
'projisert': ('projisere',),
'projiser': ('projisere',),
'proklamere': ('proklamere',),
'proklamerer': ('proklamere',),
'proklameres': ('proklamere',),
'proklamerte': ('proklamere',),
'proklamert': ('proklamere',),
'proklamer': ('proklamere',),
'proletarisere': ('proletarisere',),
'proletariserer': ('proletarisere',),
'proletariseres': ('proletarisere',),
'proletariserte': ('proletarisere',),
'proletarisert': ('proletarisere',),
'proletariser': ('proletarisere',),
'prolongere': ('prolongere',),
'prolongerer': ('prolongere',),
'prolongeres': ('prolongere',),
'prolongerte': ('prolongere',),
'prolongert': ('prolongere',),
'prolonger': ('prolongere',),
'promenere': ('promenere',),
'promenerer': ('promenere',),
'promeneres': ('promenere',),
'promenerte': ('promenere',),
'promenert': ('promenere',),
'promener': ('promenere',),
'promovere': ('promovere',),
'promoverer': ('promovere',),
'promoveres': ('promovere',),
'promoverte': ('promovere',),
'promovert': ('promovere',),
'promover': ('promovere',),
'prompe': ('prompe',),
'promper': ('prompe',),
'prompes': ('prompe',),
'prompa': ('prompe',),
'prompet': ('prompe',),
'prompa': ('prompe',),
'prompet': ('prompe',),
'promp': ('prompe',),
'promulgere': ('promulgere',),
'promulgerer': ('promulgere',),
'promulgeres': ('promulgere',),
'promulgerte': ('promulgere',),
'promulgert': ('promulgere',),
'promulger': ('promulgere',),
'pronere': ('pronere',),
'pronerer': ('pronere',),
'proneres': ('pronere',),
'pronerte': ('pronere',),
'pronert': ('pronere',),
'proner': ('pronere',),
'pronominalisere': ('pronominalisere',),
'pronominaliserer': ('pronominalisere',),
'pronominaliseres': ('pronominalisere',),
'pronominaliserte': ('pronominalisere',),
'pronominalisert': ('pronominalisere',),
'pronominaliser': ('pronominalisere',),
'propagandere': ('propagandere',),
'propaganderer': ('propagandere',),
'propaganderes': ('propagandere',),
'propaganderte': ('propagandere',),
'propagandert': ('propagandere',),
'propagander': ('propagandere',),
'propagere': ('propagere',),
'propagerer': ('propagere',),
'propageres': ('propagere',),
'propagerte': ('propagere',),
'propagert': ('propagere',),
'propager': ('propagere',),
'proponere': ('proponere',),
'proponerer': ('proponere',),
'proponeres': ('proponere',),
'proponerte': ('proponere',),
'proponert': ('proponere',),
'proponer': ('proponere',),
'proporsjonere': ('proporsjonere',),
'proporsjonerer': ('proporsjonere',),
'proporsjoneres': ('proporsjonere',),
'proporsjonerte': ('proporsjonere',),
'proporsjonert': ('proporsjonere',),
'proporsjoner': ('proporsjonere',),
'proppe': ('proppe',),
'propper': ('proppe',),
'proppes': ('proppe',),
'proppa': ('proppe',),
'proppet': ('proppe',),
'proppa': ('proppe',),
'proppet': ('proppe',),
'propp': ('proppe',),
'prosedere': ('prosedere',),
'prosederer': ('prosedere',),
'prosederes': ('prosedere',),
'prosederte': ('prosedere',),
'prosedert': ('prosedere',),
'proseder': ('prosedere',),
'prosentlønne': ('prosentlønne',),
'prosentlønner': ('prosentlønne',),
'prosentlønnes': ('prosentlønne',),
'prosentlønna': ('prosentlønne',),
'prosentlønnet': ('prosentlønne',),
'prosentlønte': ('prosentlønne',),
'prosentlønna': ('prosentlønne',),
'prosentlønnet': ('prosentlønne',),
'prosentlønt': ('prosentlønne',),
'prosentlønn': ('prosentlønne',),
'prosessere': ('prosessere',),
'prosesserer': ('prosessere',),
'prosesseres': ('prosessere',),
'prosesserte': ('prosessere',),
'prosessert': ('prosessere',),
'prosesser': ('prosessere',),
'prosjektere': ('prosjektere',),
'prosjekterer': ('prosjektere',),
'prosjekteres': ('prosjektere',),
'prosjekterte': ('prosjektere',),
'prosjektert': ('prosjektere',),
'prosjekter': ('prosjektere',),
'proskribere': ('proskribere',),
'proskriberer': ('proskribere',),
'proskriberes': ('proskribere',),
'proskriberte': ('proskribere',),
'proskribert': ('proskribere',),
'proskriber': ('proskribere',),
'prospektere': ('prospektere',),
'prospekterer': ('prospektere',),
'prospekteres': ('prospektere',),
'prospekterte': ('prospektere',),
'prospektert': ('prospektere',),
'prospekter': ('prospektere',),
'prostituere': ('prostituere',),
'prostituerer': ('prostituere',),
'prostitueres': ('prostituere',),
'prostituerte': ('prostituere',),
'prostituert': ('prostituere',),
'prostituer': ('prostituere',),
'protesjere': ('protesjere',),
'protesjerer': ('protesjere',),
'protesjeres': ('protesjere',),
'protesjerte': ('protesjere',),
'protesjert': ('protesjere',),
'protesjer': ('protesjere',),
'protestere': ('protestere',),
'protesterer': ('protestere',),
'protesteres': ('protestere',),
'protesterte': ('protestere',),
'protestert': ('protestere',),
'protester': ('protestere',),
'protokollere': ('protokollere',),
'protokollerer': ('protokollere',),
'protokolleres': ('protokollere',),
'protokollerte': ('protokollere',),
'protokollert': ('protokollere',),
'protokoller': ('protokollere',),
'protte': ('protte',),
'protter': ('protte',),
'prottes': ('protte',),
'protta': ('protte',),
'prottet': ('protte',),
'protta': ('protte',),
'prottet': ('protte',),
'prott': ('protte',),
'prove': ('prove',),
'prover': ('prove',),
'proves': ('prove',),
'prova': ('prove',),
'provet': ('prove',),
'prova': ('prove',),
'provet': ('prove',),
'prov': ('prove',),
'proviantere': ('proviantere',),
'provianterer': ('proviantere',),
'provianteres': ('proviantere',),
'provianterte': ('proviantere',),
'proviantert': ('proviantere',),
'provianter': ('proviantere',),
'providere': ('providere',),
'providerer': ('providere',),
'provideres': ('providere',),
'providerte': ('providere',),
'providert': ('providere',),
'provider': ('providere',),
'provosere': ('provosere',),
'provoserer': ('provosere',),
'provoseres': ('provosere',),
'provoserte': ('provosere',),
'provosert': ('provosere',),
'provoser': ('provosere',),
'prunke': ('prunke',),
'prunker': ('prunke',),
'prunkes': ('prunke',),
'prunka': ('prunke',),
'prunket': ('prunke',),
'prunka': ('prunke',),
'prunket': ('prunke',),
'prunk': ('prunke',),
'pruppe': ('pruppe',),
'prupper': ('pruppe',),
'pruppes': ('pruppe',),
'pruppa': ('pruppe',),
'pruppet': ('pruppe',),
'pruppa': ('pruppe',),
'pruppet': ('pruppe',),
'prupp': ('pruppe',),
'pruste': ('pruste',),
'pruster': ('pruste',),
'prustes': ('pruste',),
'prusta': ('pruste',),
'prustet': ('pruste',),
'prusta': ('pruste',),
'prustet': ('pruste',),
'prust': ('pruste',),
'prute': ('prute',),
'pruter': ('prute',),
'prutes': ('prute',),
'pruta': ('prute',),
'prutet': ('prute',),
'pruta': ('prute',),
'prutet': ('prute',),
'prut': ('prute',),
'pryde': ('pryde',),
'pryder': ('pryde',),
'prydes': ('pryde',),
'pryda': ('pryde',),
'prydet': ('pryde',),
'pryda': ('pryde',),
'prydet': ('pryde',),
'pryd': ('pryde',),
'pryle': ('pryle',),
'pryler': ('pryle',),
'pryles': ('pryle',),
'prylte': ('pryle',),
'prylt': ('pryle',),
'pryl': ('pryle',),
'prøve': ('prøve',),
'prøver': ('prøve',),
'prøves': ('prøve',),
'prøvde': ('prøve',),
'prøvd': ('prøve',),
'prøv': ('prøve',),
'prøvebore': ('prøvebore',),
'prøveborer': ('prøvebore',),
'prøvebores': ('prøvebore',),
'prøvebora': ('prøvebore',),
'prøveboret': ('prøvebore',),
'prøvebora': ('prøvebore',),
'prøveboret': ('prøvebore',),
'prøvebor': ('prøvebore',),
'prøvefilme': ('prøvefilme',),
'prøvefilmer': ('prøvefilme',),
'prøvefilmes': ('prøvefilme',),
'prøvefilma': ('prøvefilme',),
'prøvefilmet': ('prøvefilme',),
'prøvefilma': ('prøvefilme',),
'prøvefilmet': ('prøvefilme',),
'prøvefilm': ('prøvefilme',),
'prøvekjøre': ('prøvekjøre',),
'prøvekjører': ('prøvekjøre',),
'prøvekjøres': ('prøvekjøre',),
'prøvekjørte': ('prøvekjøre',),
'prøvekjørt': ('prøvekjøre',),
'prøvekjør': ('prøvekjøre',),
'prøveskyte': ('prøveskyte',),
'prøveskyter': ('prøveskyte',),
'prøveskytes': ('prøveskyte',),
'prøveskjøt': ('prøveskyte',),
'prøveskøyt': ('prøveskyte',),
'prøveskutt': ('prøveskyte',),
'prøveskyt': ('prøveskyte',),
'psyke': ('psyke',),
'psyker': ('psyke',),
'psykes': ('psyke',),
'psyka': ('psyke',),
'psyket': ('psyke',),
'psyka': ('psyke',),
'psyket': ('psyke',),
'psyk': ('psyke',),
'psykoanalysere': ('psykoanalysere',),
'psykoanalyserer': ('psykoanalysere',),
'psykoanalyseres': ('psykoanalysere',),
'psykoanalyserte': ('psykoanalysere',),
'psykoanalysert': ('psykoanalysere',),
'psykoanalyser': ('psykoanalysere',),
'ptroe': ('ptroe',),
'ptroer': ('ptroe',),
'ptroes': ('ptroe',),
'ptroa': ('ptroe',),
'ptroet': ('ptroe',),
'ptroa': ('ptroe',),
'ptroet': ('ptroe',),
'ptro': ('ptroe',),
'ptrotte': ('ptrotte',),
'ptrotter': ('ptrotte',),
'ptrottes': ('ptrotte',),
'ptrotta': ('ptrotte',),
'ptrottet': ('ptrotte',),
'ptrotta': ('ptrotte',),
'ptrottet': ('ptrotte',),
'ptrott': ('ptrotte',),
'publisere': ('publisere',),
'publiserer': ('publisere',),
'publiseres': ('publisere',),
'publiserte': ('publisere',),
'publisert': ('publisere',),
'publiser': ('publisere',),
'pudre': ('pudre',),
'pudrer': ('pudre',),
'pudres': ('pudre',),
'pudra': ('pudre',),
'pudret': ('pudre',),
'pudra': ('pudre',),
'pudret': ('pudre',),
'pudr': ('pudre',),
'pudre': ('pudre',),
'pudr': ('pudre',),
'pudre': ('pudre',),
'puffe': ('puffe',),
'puffer': ('puffe',),
'puffes': ('puffe',),
'puffa': ('puffe',),
'puffet': ('puffe',),
'puffa': ('puffe',),
'puffet': ('puffe',),
'puff': ('puffe',),
'puge': ('puge',),
'puger': ('puge',),
'puges': ('puge',),
'puga': ('puge',),
'puget': ('puge',),
'puga': ('puge',),
'puget': ('puge',),
'pug': ('puge',),
'pugge': ('pugge',),
'pugger': ('pugge',),
'pugges': ('pugge',),
'pugga': ('pugge',),
'pugget': ('pugge',),
'pugga': ('pugge',),
'pugget': ('pugge',),
'pugg': ('pugge',),
'pukke': ('pukke',),
'pukker': ('pukke',),
'pukkes': ('pukke',),
'pukka': ('pukke',),
'pukket': ('pukke',),
'pukka': ('pukke',),
'pukket': ('pukke',),
'pukk': ('pukke',),
'puldre': ('puldre',),
'puldrer': ('puldre',),
'puldres': ('puldre',),
'puldra': ('puldre',),
'puldret': ('puldre',),
'puldra': ('puldre',),
'puldret': ('puldre',),
'puldr': ('puldre',),
'puldre': ('puldre',),
'puldr': ('puldre',),
'puldre': ('puldre',),
'pule': ('pule',),
'puler': ('pule',),
'pules': ('pule',),
'pulte': ('pule',),
'pult': ('pule',),
'pul': ('pule',),
'pulse': ('pulse',),
'pulser': ('pulse',),
'pulses': ('pulse',),
'pulsa': ('pulse',),
'pulset': ('pulse',),
'pulsa': ('pulse',),
'pulset': ('pulse',),
'puls': ('pulse',),
'pulsere': ('pulsere',),
'pulserer': ('pulsere',),
'pulseres': ('pulsere',),
'pulserte': ('pulsere',),
'pulsert': ('pulsere',),
'pulser': ('pulsere',),
'pulverisere': ('pulverisere',),
'pulveriserer': ('pulverisere',),
'pulveriseres': ('pulverisere',),
'pulveriserte': ('pulverisere',),
'pulverisert': ('pulverisere',),
'pulveriser': ('pulverisere',),
'pumpe': ('pumpe',),
'pumper': ('pumpe',),
'pumpes': ('pumpe',),
'pumpa': ('pumpe',),
'pumpet': ('pumpe',),
'pumpa': ('pumpe',),
'pumpet': ('pumpe',),
'pump': ('pumpe',),
'pumpebremse': ('pumpebremse',),
'pumpebremser': ('pumpebremse',),
'pumpebremses': ('pumpebremse',),
'pumpebremsa': ('pumpebremse',),
'pumpebremset': ('pumpebremse',),
'pumpebremsa': ('pumpebremse',),
'pumpebremset': ('pumpebremse',),
'pumpebrems': ('pumpebremse',),
'punche': ('punche',),
'puncher': ('punche',),
'punches': ('punche',),
'puncha': ('punche',),
'punchet': ('punche',),
'puncha': ('punche',),
'punchet': ('punche',),
'punch': ('punche',),
'punge': ('punge',),
'punger': ('punge',),
'punges': ('punge',),
'punga': ('punge',),
'punget': ('punge',),
'punga': ('punge',),
'punget': ('punge',),
'pung': ('punge',),
'punktere': ('punktere',),
'punkterer': ('punktere',),
'punkteres': ('punktere',),
'punkterte': ('punktere',),
'punktert': ('punktere',),
'punkter': ('punktere',),
'purke': ('purke',),
'purker': ('purke',),
'purkes': ('purke',),
'purka': ('purke',),
'purket': ('purke',),
'purka': ('purke',),
'purket': ('purke',),
'purk': ('purke',),
'purle': ('purle',),
'purler': ('purle',),
'purles': ('purle',),
'purla': ('purle',),
'purlet': ('purle',),
'purla': ('purle',),
'purlet': ('purle',),
'purl': ('purle',),
'purre': ('purre',),
'purrer': ('purre',),
'purres': ('purre',),
'purra': ('purre',),
'purret': ('purre',),
'purra': ('purre',),
'purret': ('purre',),
'purr': ('purre',),
'pushe': ('pushe',),
'pusher': ('pushe',),
'pushes': ('pushe',),
'pusha': ('pushe',),
'pushet': ('pushe',),
'pusha': ('pushe',),
'pushet': ('pushe',),
'push': ('pushe',),
'pusle': ('pusle',),
'pusler': ('pusle',),
'pusles': ('pusle',),
'pusla': ('pusle',),
'puslet': ('pusle',),
'pusla': ('pusle',),
'puslet': ('pusle',),
'pusl': ('pusle',),
'pusse': ('pusse',),
'pusser': ('pusse',),
'pusses': ('pusse',),
'pussa': ('pusse',),
'pusset': ('pusse',),
'pussa': ('pusse',),
'pusset': ('pusse',),
'puss': ('pusse',),
'puste': ('puste',),
'puster': ('puste',),
'pustes': ('puste',),
'pusta': ('puste',),
'pustet': ('puste',),
'pusta': ('puste',),
'pustet': ('puste',),
'pust': ('puste',),
'putle': ('putle',),
'putler': ('putle',),
'putles': ('putle',),
'putla': ('putle',),
'putlet': ('putle',),
'putla': ('putle',),
'putlet': ('putle',),
'putl': ('putle',),
'putle': ('putle',),
'putl': ('putle',),
'putle': ('putle',),
'putre': ('putre',),
'putrer': ('putre',),
'putres': ('putre',),
'putra': ('putre',),
'putret': ('putre',),
'putra': ('putre',),
'putret': ('putre',),
'putr': ('putre',),
'putre': ('putre',),
'putr': ('putre',),
'putre': ('putre',),
'putte': ('putte',),
'putter': ('putte',),
'puttes': ('putte',),
'putta': ('putte',),
'puttet': ('putte',),
'putta': ('putte',),
'puttet': ('putte',),
'putt': ('putte',),
'pynte': ('pynte',),
'pynter': ('pynte',),
'pyntes': ('pynte',),
'pynta': ('pynte',),
'pyntet': ('pynte',),
'pynta': ('pynte',),
'pyntet': ('pynte',),
'pynt': ('pynte',),
'påakte': ('påakte',),
'påakter': ('påakte',),
'påaktes': ('påakte',),
'påakta': ('påakte',),
'påaktet': ('påakte',),
'påakta': ('påakte',),
'påaktet': ('påakte',),
'påakt': ('påakte',),
'påanke': ('påanke',),
'påanker': ('påanke',),
'påankes': ('påanke',),
'påanka': ('påanke',),
'påanket': ('påanke',),
'påanka': ('påanke',),
'påanket': ('påanke',),
'påank': ('påanke',),
'påberope': ('påberope',),
'påberoper': ('påberope',),
'påberopes': ('påberope',),
'påberopte': ('påberope',),
'påberopt': ('påberope',),
'påberop': ('påberope',),
'påby': ('påby',),
'påbyr': ('påby',),
'påbys': ('påby',),
'påbydde': ('påby',),
'påbød': ('påby',),
'påbøy': ('påby',),
'påbydd': ('påby',),
'påbudt': ('påby',),
'påbydd': ('påby',),
'påby': ('påby',),
'pådra': ('pådra',),
'pådrar': ('pådra',),
'pådras': ('pådra',),
'pådrog': ('pådra',),
'pådro': ('pådra',),
'pådradd': ('pådra',),
'pådratt': ('pådra',),
'pådradd': ('pådra',),
'pådratt': ('pådra',),
'pådra': ('pådra',),
'pådømme': ('pådømme',),
'pådømmer': ('pådømme',),
'pådømmes': ('pådømme',),
'pådømte': ('pådømme',),
'pådømt': ('pådømme',),
'pådøm': ('pådømme',),
'påføre': ('påføre',),
'påfører': ('påføre',),
'påføres': ('påføre',),
'påførte': ('påføre',),
'påført': ('påføre',),
'påfør': ('påføre',),
'pågripe': ('pågripe',),
'pågriper': ('pågripe',),
'pågripes': ('pågripe',),
'pågrep': ('pågripe',),
'pågreip': ('pågripe',),
'pågrep': ('pågripe',),
'pågreip': ('pågripe',),
'pågrepet': ('pågripe',),
'pågrip': ('pågripe',),
'pågå': ('pågå',),
'pågår': ('pågå',),
'pågås': ('pågå',),
'pågikk': ('pågå',),
'pågått': ('pågå',),
'pågå': ('pågå',),
'påhvile': ('påhvile',),
'påhviler': ('påhvile',),
'påhviles': ('påhvile',),
'påhvilte': ('påhvile',),
'påhvilt': ('påhvile',),
'påhvil': ('påhvile',),
'påkalle': ('påkalle',),
'påkaller': ('påkalle',),
'påkalles': ('påkalle',),
'påkalte': ('påkalle',),
'påkalt': ('påkalle',),
'påkall': ('påkalle',),
'påkjære': ('påkjære',),
'påkjærer': ('påkjære',),
'påkjæres': ('påkjære',),
'påkjærte': ('påkjære',),
'påkjært': ('påkjære',),
'påkjær': ('påkjære',),
'påkjøre': ('påkjøre',),
'påkjører': ('påkjøre',),
'påkjøres': ('påkjøre',),
'påkjørte': ('påkjøre',),
'påkjørt': ('påkjøre',),
'påkjør': ('påkjøre',),
'påklage': ('påklage',),
'påklager': ('påklage',),
'påklages': ('påklage',),
'påklaga': ('påklage',),
'påklaget': ('påklage',),
'påklagde': ('påklage',),
'påklaga': ('påklage',),
'påklaget': ('påklage',),
'påklagd': ('påklage',),
'påklag': ('påklage',),
'pålegge': ('pålegge',),
'pålegger': ('pålegge',),
'pålegges': ('pålegge',),
'påla': ('pålegge',),
'pålagt': ('pålegge',),
'pålegg': ('pålegge',),
'påligge': ('påligge',),
'påligger': ('påligge',),
'påligges': ('påligge',),
'pålå': ('påligge',),
'påligget': ('påligge',),
'påligg': ('påligge',),
'påløpe': ('påløpe',),
'påløper': ('påløpe',),
'påløpes': ('påløpe',),
'påløp': ('påløpe',),
'påløpt': ('påløpe',),
'påløpet': ('påløpe',),
'påløp': ('påløpe',),
'påpeke': ('påpeke',),
'påpeker': ('påpeke',),
'påpekes': ('påpeke',),
'påpekte': ('påpeke',),
'påpekt': ('påpeke',),
'påpek': ('påpeke',),
'påregne': ('påregne',),
'påregner': ('påregne',),
'påregnes': ('påregne',),
'påregna': ('påregne',),
'påregnet': ('påregne',),
'påregna': ('påregne',),
'påregnet': ('påregne',),
'påregn': ('påregne',),
'påse': ('påse',),
'påser': ('påse',),
'påses': ('påse',),
'påsees': ('påse',),
'påså': ('påse',),
'påsett': ('påse',),
'påse': ('påse',),
'påskjønne': ('påskjønne',),
'påskjønner': ('påskjønne',),
'påskjønnes': ('påskjønne',),
'påskjønnet': ('påskjønne',),
'påskjønte': ('påskjønne',),
'påskjønnet': ('påskjønne',),
'påskjønt': ('påskjønne',),
'påskjønn': ('påskjønne',),
'påskynde': ('påskynde',),
'påskynder': ('påskynde',),
'påskyndes': ('påskynde',),
'påskynda': ('påskynde',),
'påskyndet': ('påskynde',),
'påskyndte': ('påskynde',),
'påskynda': ('påskynde',),
'påskyndet': ('påskynde',),
'påskyndt': ('påskynde',),
'påskynd': ('påskynde',),
'påstå': ('påstå',),
'påstår': ('påstå',),
'påstås': ('påstå',),
'påsto': ('påstå',),
'påstod': ('påstå',),
'påstått': ('påstå',),
'påstå': ('påstå',),
'påta': ('påta',),
'påtar': ('påta',),
'påtas': ('påta',),
'påtok': ('påta',),
'påtatt': ('påta',),
'påta': ('påta',),
'påtale': ('påtale',),
'påtaler': ('påtale',),
'påtales': ('påtale',),
'påtalte': ('påtale',),
'påtalt': ('påtale',),
'påtal': ('påtale',),
'påtegne': ('påtegne',),
'påtegner': ('påtegne',),
'påtegnes': ('påtegne',),
'påtegna': ('påtegne',),
'påtegnet': ('påtegne',),
'påtegna': ('påtegne',),
'påtegnet': ('påtegne',),
'påtegn': ('påtegne',),
'påtenne': ('påtenne',),
'påtenner': ('påtenne',),
'påtennes': ('påtenne',),
'påtente': ('påtenne',),
'påtent': ('påtenne',),
'påtenn': ('påtenne',),
'påtreffe': ('påtreffe',),
'påtreffer': ('påtreffe',),
'påtreffes': ('påtreffe',),
'påtraff': ('påtreffe',),
'påtruffet': ('påtreffe',),
'påtreff': ('påtreffe',),
'påtvinge': ('påtvinge',),
'påtvinger': ('påtvinge',),
'påtvinges': ('påtvinge',),
'påtvang': ('påtvinge',),
'påtvunget': ('påtvinge',),
'påtving': ('påtvinge',),
'påvirke': ('påvirke',),
'påvirker': ('påvirke',),
'påvirkes': ('påvirke',),
'påvirka': ('påvirke',),
'påvirket': ('påvirke',),
'påvirka': ('påvirke',),
'påvirket': ('påvirke',),
'påvirk': ('påvirke',),
'påvise': ('påvise',),
'påviser': ('påvise',),
'påvises': ('påvise',),
'påviste': ('påvise',),
'påvist': ('påvise',),
'påvis': ('påvise',),
'pæle': ('pæle',),
'pæler': ('pæle',),
'pæles': ('pæle',),
'pæla': ('pæle',),
'pælet': ('pæle',),
'pælte': ('pæle',),
'pæla': ('pæle',),
'pælet': ('pæle',),
'pælt': ('pæle',),
'pæl': ('pæle',),
'pælme': ('pælme',),
'pælmer': ('pælme',),
'pælmes': ('pælme',),
'pælma': ('pælme',),
'pælmet': ('pælme',),
'pælma': ('pælme',),
'pælmet': ('pælme',),
'pælm': ('pælme',),
'pøble': ('pøble',),
'pøbler': ('pøble',),
'pøbles': ('pøble',),
'pøbla': ('pøble',),
'pøblet': ('pøble',),
'pøbla': ('pøble',),
'pøblet': ('pøble',),
'pøbl': ('pøble',),
'pøble': ('pøble',),
'pøbl': ('pøble',),
'pøble': ('pøble',),
'pønse': ('pønse',),
'pønser': ('pønse',),
'pønses': ('pønse',),
'pønsa': ('pønse',),
'pønset': ('pønse',),
'pønsa': ('pønse',),
'pønset': ('pønse',),
'pøns': ('pønse',),
'pønske': ('pønske',),
'pønsker': ('pønske',),
'pønskes': ('pønske',),
'pønska': ('pønske',),
'pønsket': ('pønske',),
'pønska': ('pønske',),
'pønsket': ('pønske',),
'pønsk': ('pønske',),
'pøse': ('pøse',),
'pøser': ('pøse',),
'pøses': ('pøse',),
'pøste': ('pøse',),
'pøst': ('pøse',),
'pøs': ('pøse',),
'rabattere': ('rabattere',),
'rabatterer': ('rabattere',),
'rabatteres': ('rabattere',),
'rabatterte': ('rabattere',),
'rabattert': ('rabattere',),
'rabatter': ('rabattere',),
'rable': ('rable',),
'rabler': ('rable',),
'rables': ('rable',),
'rabla': ('rable',),
'rablet': ('rable',),
'rabla': ('rable',),
'rablet': ('rable',),
'rabl': ('rable',),
'rable': ('rable',),
'rabl': ('rable',),
'rable': ('rable',),
'radbrekke': ('radbrekke',),
'radbrekker': ('radbrekke',),
'radbrekkes': ('radbrekke',),
'radbrekka': ('radbrekke',),
'radbrekket': ('radbrekke',),
'radbrekte': ('radbrekke',),
'radbrekka': ('radbrekke',),
'radbrekket': ('radbrekke',),
'radbrekt': ('radbrekke',),
'radbrekk': ('radbrekke',),
'rade': ('rade',),
'rader': ('rade',),
'rades': ('rade',),
'rada': ('rade',),
'radet': ('rade',),
'rada': ('rade',),
'radet': ('rade',),
'rad': ('rade',),
'radere': ('radere',),
'raderer': ('radere',),
'raderes': ('radere',),
'raderte': ('radere',),
'radert': ('radere',),
'rader': ('radere',),
'radiere': ('radiere',),
'radierer': ('radiere',),
'radieres': ('radiere',),
'radierte': ('radiere',),
'radiert': ('radiere',),
'radier': ('radiere',),
'radikalisere': ('radikalisere',),
'radikaliserer': ('radikalisere',),
'radikaliseres': ('radikalisere',),
'radikaliserte': ('radikalisere',),
'radikalisert': ('radikalisere',),
'radikaliser': ('radikalisere',),
'raffinere': ('raffinere',),
'raffinerer': ('raffinere',),
'raffineres': ('raffinere',),
'raffinerte': ('raffinere',),
'raffinert': ('raffinere',),
'raffiner': ('raffinere',),
'rafse': ('rafse',),
'rafser': ('rafse',),
'rafses': ('rafse',),
'rafsa': ('rafse',),
'rafset': ('rafse',),
'rafsa': ('rafse',),
'rafset': ('rafse',),
'rafs': ('rafse',),
'rafte': ('rafte',),
'rafter': ('rafte',),
'raftes': ('rafte',),
'rafta': ('rafte',),
'raftet': ('rafte',),
'rafta': ('rafte',),
'raftet': ('rafte',),
'raft': ('rafte',),
'rage': ('rage',),
'rager': ('rage',),
'rages': ('rage',),
'raga': ('rage',),
'raget': ('rage',),
'raga': ('rage',),
'raget': ('rage',),
'rag': ('rage',),
'rake': ('rake',),
'raker': ('rake',),
'rakes': ('rake',),
'raka': ('rake',),
'raket': ('rake',),
'raka': ('rake',),
'raket': ('rake',),
'rak': ('rake',),
'rake': ('rake',),
'raker': ('rake',),
'rakes': ('rake',),
'raka': ('rake',),
'raket': ('rake',),
'rakte': ('rake',),
'raka': ('rake',),
'raket': ('rake',),
'rakt': ('rake',),
'rak': ('rake',),
'rakke': ('rakke',),
'rakker': ('rakke',),
'rakkes': ('rakke',),
'rakka': ('rakke',),
'rakket': ('rakke',),
'rakka': ('rakke',),
'rakket': ('rakke',),
'rakk': ('rakke',),
'rakle': ('rakle',),
'rakler': ('rakle',),
'rakles': ('rakle',),
'rakla': ('rakle',),
'raklet': ('rakle',),
'rakla': ('rakle',),
'raklet': ('rakle',),
'rakl': ('rakle',),
'rakle': ('rakle',),
'rakl': ('rakle',),
'rakle': ('rakle',),
'rakne': ('rakne',),
'rakner': ('rakne',),
'raknes': ('rakne',),
'rakna': ('rakne',),
'raknet': ('rakne',),
'rakna': ('rakne',),
'raknet': ('rakne',),
'rakn': ('rakne',),
'rakne': ('rakne',),
'rakn': ('rakne',),
'rakne': ('rakne',),
'raljere': ('raljere',),
'raljerer': ('raljere',),
'raljeres': ('raljere',),
'raljerte': ('raljere',),
'raljert': ('raljere',),
'raljer': ('raljere',),
'ralle': ('ralle',),
'raller': ('ralle',),
'ralles': ('ralle',),
'ralla': ('ralle',),
'rallet': ('ralle',),
'ralla': ('ralle',),
'rallet': ('ralle',),
'rall': ('ralle',),
'ramle': ('ramle',),
'ramler': ('ramle',),
'ramles': ('ramle',),
'ramla': ('ramle',),
'ramlet': ('ramle',),
'ramla': ('ramle',),
'ramlet': ('ramle',),
'raml': ('ramle',),
'ramle': ('ramle',),
'raml': ('ramle',),
'ramle': ('ramle',),
'ramme': ('ramme',),
'rammer': ('ramme',),
'rammes': ('ramme',),
'ramma': ('ramme',),
'rammet': ('ramme',),
'ramma': ('ramme',),
'rammet': ('ramme',),
'ram': ('ramme',),
'ramponere': ('ramponere',),
'ramponerer': ('ramponere',),
'ramponeres': ('ramponere',),
'ramponerte': ('ramponere',),
'ramponert': ('ramponere',),
'ramponer': ('ramponere',),
'ramsalte': ('ramsalte',),
'ramsalter': ('ramsalte',),
'ramsaltes': ('ramsalte',),
'ramsalta': ('ramsalte',),
'ramsaltet': ('ramsalte',),
'ramsalta': ('ramsalte',),
'ramsaltet': ('ramsalte',),
'ramsalt': ('ramsalte',),
'ramse': ('ramse',),
'ramser': ('ramse',),
'ramses': ('ramse',),
'ramsa': ('ramse',),
'ramset': ('ramse',),
'ramsa': ('ramse',),
'ramset': ('ramse',),
'rams': ('ramse',),
'rande': ('rande',),
'rander': ('rande',),
'randes': ('rande',),
'randa': ('rande',),
'randet': ('rande',),
'randa': ('rande',),
'randet': ('rande',),
'rand': ('rande',),
'randsy': ('randsy',),
'randsyr': ('randsy',),
'randsys': ('randsy',),
'randsydde': ('randsy',),
'randsydd': ('randsy',),
'randsy': ('randsy',),
'rane': ('rane',),
'raner': ('rane',),
'ranes': ('rane',),
'rana': ('rane',),
'ranet': ('rane',),
'rante': ('rane',),
'rana': ('rane',),
'ranet': ('rane',),
'rant': ('rane',),
'ran': ('rane',),
'range': ('range',),
'ranger': ('range',),
'ranges': ('range',),
'ranga': ('range',),
'ranget': ('range',),
'ranga': ('range',),
'ranget': ('range',),
'rang': ('range',),
'rangere': ('rangere',),
'rangerer': ('rangere',),
'rangeres': ('rangere',),
'rangerte': ('rangere',),
'rangert': ('rangere',),
'ranger': ('rangere',),
'rangle': ('rangle',),
'rangler': ('rangle',),
'rangles': ('rangle',),
'rangla': ('rangle',),
'ranglet': ('rangle',),
'rangla': ('rangle',),
'ranglet': ('rangle',),
'rangl': ('rangle',),
'rangle': ('rangle',),
'rangl': ('rangle',),
'rangle': ('rangle',),
'ranke': ('ranke',),
'ranker': ('ranke',),
'rankes': ('ranke',),
'ranka': ('ranke',),
'ranket': ('ranke',),
'ranka': ('ranke',),
'ranket': ('ranke',),
'rank': ('ranke',),
'ransake': ('ransake',),
'ransaker': ('ransake',),
'ransakes': ('ransake',),
'ransaka': ('ransake',),
'ransaket': ('ransake',),
'ransakte': ('ransake',),
'ransaka': ('ransake',),
'ransaket': ('ransake',),
'ransakt': ('ransake',),
'ransak': ('ransake',),
'rape': ('rape',),
'raper': ('rape',),
'rapes': ('rape',),
'rapa': ('rape',),
'rapet': ('rape',),
'rapte': ('rape',),
'rapa': ('rape',),
'rapet': ('rape',),
'rapt': ('rape',),
'rap': ('rape',),
'rappe': ('rappe',),
'rapper': ('rappe',),
'rappes': ('rappe',),
'rappa': ('rappe',),
'rappet': ('rappe',),
'rappa': ('rappe',),
'rappet': ('rappe',),
'rapp': ('rappe',),
'rappellere': ('rappellere',),
'rappellerer': ('rappellere',),
'rappelleres': ('rappellere',),
'rappellerte': ('rappellere',),
'rappellert': ('rappellere',),
'rappeller': ('rappellere',),
'rapportere': ('rapportere',),
'rapporterer': ('rapportere',),
'rapporteres': ('rapportere',),
'rapporterte': ('rapportere',),
'rapportert': ('rapportere',),
'rapporter': ('rapportere',),
'rapse': ('rapse',),
'rapser': ('rapse',),
'rapses': ('rapse',),
'rapsa': ('rapse',),
'rapset': ('rapse',),
'rapsa': ('rapse',),
'rapset': ('rapse',),
'raps': ('rapse',),
'rase': ('rase',),
'raser': ('rase',),
'rases': ('rase',),
'raste': ('rase',),
'rast': ('rase',),
'ras': ('rase',),
'rasere': ('rasere',),
'raserer': ('rasere',),
'raseres': ('rasere',),
'raserte': ('rasere',),
'rasert': ('rasere',),
'raser': ('rasere',),
'rasjonalisere': ('rasjonalisere',),
'rasjonaliserer': ('rasjonalisere',),
'rasjonaliseres': ('rasjonalisere',),
'rasjonaliserte': ('rasjonalisere',),
'rasjonalisert': ('rasjonalisere',),
'rasjonaliser': ('rasjonalisere',),
'rasjonere': ('rasjonere',),
'rasjonerer': ('rasjonere',),
'rasjoneres': ('rasjonere',),
'rasjonerte': ('rasjonere',),
'rasjonert': ('rasjonere',),
'rasjoner': ('rasjonere',),
'raske': ('raske',),
'rasker': ('raske',),
'raskes': ('raske',),
'raska': ('raske',),
'rasket': ('raske',),
'raska': ('raske',),
'rasket': ('raske',),
'rask': ('raske',),
'rasle': ('rasle',),
'rasler': ('rasle',),
'rasles': ('rasle',),
'rasla': ('rasle',),
'raslet': ('rasle',),
'rasla': ('rasle',),
'raslet': ('rasle',),
'rasl': ('rasle',),
'raspe': ('raspe',),
'rasper': ('raspe',),
'raspes': ('raspe',),
'raspa': ('raspe',),
'raspet': ('raspe',),
'raspa': ('raspe',),
'raspet': ('raspe',),
'rasp': ('raspe',),
'raste': ('raste',),
'raster': ('raste',),
'rastes': ('raste',),
'rasta': ('raste',),
'rastet': ('raste',),
'rasta': ('raste',),
'rastet': ('raste',),
'rast': ('raste',),
'ratifisere': ('ratifisere',),
'ratifiserer': ('ratifisere',),
'ratifiseres': ('ratifisere',),
'ratifiserte': ('ratifisere',),
'ratifisert': ('ratifisere',),
'ratifiser': ('ratifisere',),
'ratle': ('ratle',),
'ratler': ('ratle',),
'ratles': ('ratle',),
'ratla': ('ratle',),
'ratlet': ('ratle',),
'ratla': ('ratle',),
'ratlet': ('ratle',),
'ratl': ('ratle',),
'ratle': ('ratle',),
'ratl': ('ratle',),
'ratle': ('ratle',),
'ratte': ('ratte',),
'ratter': ('ratte',),
'rattes': ('ratte',),
'ratta': ('ratte',),
'rattet': ('ratte',),
'ratta': ('ratte',),
'rattet': ('ratte',),
'ratt': ('ratte',),
'rauke': ('rauke',),
'rauker': ('rauke',),
'raukes': ('rauke',),
'rauka': ('rauke',),
'rauket': ('rauke',),
'rauka': ('rauke',),
'rauket': ('rauke',),
'rauk': ('rauke',),
'rause': ('rause',),
'rauser': ('rause',),
'rauses': ('rause',),
'rausa': ('rause',),
'rauset': ('rause',),
'rauste': ('rause',),
'rausa': ('rause',),
'rauset': ('rause',),
'raust': ('rause',),
'raus': ('rause',),
'raute': ('raute',),
'rauter': ('raute',),
'rautes': ('raute',),
'rauta': ('raute',),
'rautet': ('raute',),
'rauta': ('raute',),
'rautet': ('raute',),
'raut': ('raute',),
'rave': ('rave',),
'raver': ('rave',),
'raves': ('rave',),
'rava': ('rave',),
'ravet': ('rave',),
'rava': ('rave',),
'ravet': ('rave',),
'rav': ('rave',),
're': ('re',),
'rer': ('re',),
'res': ('re',),
'redde': ('re',),
'redd': ('re',),
're': ('re',),
'reagere': ('reagere',),
'reagerer': ('reagere',),
'reageres': ('reagere',),
'reagerte': ('reagere',),
'reagert': ('reagere',),
'reager': ('reagere',),
'reaktivere': ('reaktivere',),
'reaktiverer': ('reaktivere',),
'reaktiveres': ('reaktivere',),
'reaktiverte': ('reaktivere',),
'reaktivert': ('reaktivere',),
'reaktiver': ('reaktivere',),
'realisere': ('realisere',),
'realiserer': ('realisere',),
'realiseres': ('realisere',),
'realiserte': ('realisere',),
'realisert': ('realisere',),
'realiser': ('realisere',),
'realitetsbehandle': ('realitetsbehandle',),
'realitetsbehandler': ('realitetsbehandle',),
'realitetsbehandles': ('realitetsbehandle',),
'realitetsbehandla': ('realitetsbehandle',),
'realitetsbehandlet': ('realitetsbehandle',),
'realitetsbehandla': ('realitetsbehandle',),
'realitetsbehandlet': ('realitetsbehandle',),
'realitetsbehandl': ('realitetsbehandle',),
'realitetsbehandle': ('realitetsbehandle',),
'realitetsbehandl': ('realitetsbehandle',),
'realitetsbehandle': ('realitetsbehandle',),
'reassurere': ('reassurere',),
'reassurerer': ('reassurere',),
'reassureres': ('reassurere',),
'reassurerte': ('reassurere',),
'reassurert': ('reassurere',),
'reassurer': ('reassurere',),
'rebellere': ('rebellere',),
'rebellerer': ('rebellere',),
'rebelleres': ('rebellere',),
'rebellerte': ('rebellere',),
'rebellert': ('rebellere',),
'rebeller': ('rebellere',),
'recensere': ('recensere',),
'recenserer': ('recensere',),
'recenseres': ('recensere',),
'recenserte': ('recensere',),
'recensert': ('recensere',),
'recenser': ('recensere',),
'redde': ('redde',),
'redder': ('redde',),
'reddes': ('redde',),
'redda': ('redde',),
'reddet': ('redde',),
'redda': ('redde',),
'reddet': ('redde',),
'redd': ('redde',),
'rede': ('rede',),
'reder': ('rede',),
'redes': ('rede',),
'reda': ('rede',),
'redet': ('rede',),
'reda': ('rede',),
'redet': ('rede',),
'red': ('rede',),
'redegjøre': ('redegjøre',),
'redegjør': ('redegjøre',),
'redegjøres': ('redegjøre',),
'redegjorde': ('redegjøre',),
'redegjort': ('redegjøre',),
'redegjør': ('redegjøre',),
'redigere': ('redigere',),
'redigerer': ('redigere',),
'redigeres': ('redigere',),
'redigerte': ('redigere',),
'redigert': ('redigere',),
'rediger': ('redigere',),
'redoble': ('redoble',),
'redobler': ('redoble',),
'redobles': ('redoble',),
'redobla': ('redoble',),
'redoblet': ('redoble',),
'redobla': ('redoble',),
'redoblet': ('redoble',),
'redobl': ('redoble',),
'redoble': ('redoble',),
'redobl': ('redoble',),
'redoble': ('redoble',),
'reduplisere': ('reduplisere',),
'redupliserer': ('reduplisere',),
'redupliseres': ('reduplisere',),
'redupliserte': ('reduplisere',),
'reduplisert': ('reduplisere',),
'redupliser': ('reduplisere',),
'redusere': ('redusere',),
'reduserer': ('redusere',),
'reduseres': ('redusere',),
'reduserte': ('redusere',),
'redusert': ('redusere',),
'reduser': ('redusere',),
'referere': ('referere',),
'refererer': ('referere',),
'refereres': ('referere',),
'refererte': ('referere',),
'referert': ('referere',),
'referer': ('referere',),
'reflektere': ('reflektere',),
'reflekterer': ('reflektere',),
'reflekteres': ('reflektere',),
'reflekterte': ('reflektere',),
'reflektert': ('reflektere',),
'reflekter': ('reflektere',),
'reformere': ('reformere',),
'reformerer': ('reformere',),
'reformeres': ('reformere',),
'reformerte': ('reformere',),
'reformert': ('reformere',),
'reformer': ('reformere',),
'refse': ('refse',),
'refser': ('refse',),
'refses': ('refse',),
'refsa': ('refse',),
'refset': ('refse',),
'refste': ('refse',),
'refsa': ('refse',),
'refset': ('refse',),
'refst': ('refse',),
'refs': ('refse',),
'refundere': ('refundere',),
'refunderer': ('refundere',),
'refunderes': ('refundere',),
'refunderte': ('refundere',),
'refundert': ('refundere',),
'refunder': ('refundere',),
'refusere': ('refusere',),
'refuserer': ('refusere',),
'refuseres': ('refusere',),
'refuserte': ('refusere',),
'refusert': ('refusere',),
'refuser': ('refusere',),
'regalere': ('regalere',),
'regalerer': ('regalere',),
'regaleres': ('regalere',),
'regalerte': ('regalere',),
'regalert': ('regalere',),
'regaler': ('regalere',),
'regenerere': ('regenerere',),
'regenererer': ('regenerere',),
'regenereres': ('regenerere',),
'regenererte': ('regenerere',),
'regenerert': ('regenerere',),
'regenerer': ('regenerere',),
'regissere': ('regissere',),
'regisserer': ('regissere',),
'regisseres': ('regissere',),
'regisserte': ('regissere',),
'regissert': ('regissere',),
'regisser': ('regissere',),
'registrere': ('registrere',),
'registrerer': ('registrere',),
'registreres': ('registrere',),
'registrerte': ('registrere',),
'registrert': ('registrere',),
'registrer': ('registrere',),
'regjere': ('regjere',),
'regjerer': ('regjere',),
'regjeres': ('regjere',),
'regjerte': ('regjere',),
'regjert': ('regjere',),
'regjer': ('regjere',),
'reglementere': ('reglementere',),
'reglementerer': ('reglementere',),
'reglementeres': ('reglementere',),
'reglementerte': ('reglementere',),
'reglementert': ('reglementere',),
'reglementer': ('reglementere',),
'regne': ('regne',),
'regner': ('regne',),
'regnes': ('regne',),
'regna': ('regne',),
'regnet': ('regne',),
'regna': ('regne',),
'regnet': ('regne',),
'regn': ('regne',),
'regne': ('regne',),
'regner': ('regne',),
'regnes': ('regne',),
'regna': ('regne',),
'regnet': ('regne',),
'regnte': ('regne',),
'regna': ('regne',),
'regnet': ('regne',),
'regnt': ('regne',),
'regn': ('regne',),
'regularisere': ('regularisere',),
'regulariserer': ('regularisere',),
'regulariseres': ('regularisere',),
'regulariserte': ('regularisere',),
'regularisert': ('regularisere',),
'regulariser': ('regularisere',),
'regulere': ('regulere',),
'regulerer': ('regulere',),
'reguleres': ('regulere',),
'regulerte': ('regulere',),
'regulert': ('regulere',),
'reguler': ('regulere',),
'regummiere': ('regummiere',),
'regummierer': ('regummiere',),
'regummieres': ('regummiere',),
'regummierte': ('regummiere',),
'regummiert': ('regummiere',),
'regummier': ('regummiere',),
'rehabilitere': ('rehabilitere',),
'rehabiliterer': ('rehabilitere',),
'rehabiliteres': ('rehabilitere',),
'rehabiliterte': ('rehabilitere',),
'rehabilitert': ('rehabilitere',),
'rehabiliter': ('rehabilitere',),
'reie': ('reie',),
'reier': ('reie',),
'reies': ('reie',),
'reide': ('reie',),
'reid': ('reie',),
'rei': ('reie',),
'reike': ('reike',),
'reiker': ('reike',),
'reikes': ('reike',),
'reika': ('reike',),
'reiket': ('reike',),
'reikte': ('reike',),
'reika': ('reike',),
'reiket': ('reike',),
'reikt': ('reike',),
'reik': ('reike',),
'reindyrke': ('reindyrke',),
'reindyrker': ('reindyrke',),
'reindyrkes': ('reindyrke',),
'reindyrka': ('reindyrke',),
'reindyrket': ('reindyrke',),
'reindyrka': ('reindyrke',),
'reindyrket': ('reindyrke',),
'reindyrk': ('reindyrke',),
'reingjøre': ('reingjøre',),
'reingjør': ('reingjøre',),
'reingjøres': ('reingjøre',),
'reingjorde': ('reingjøre',),
'reingjort': ('reingjøre',),
'reingjør': ('reingjøre',),
'reinskrive': ('reinskrive',),
'reinskriver': ('reinskrive',),
'reinskrives': ('reinskrive',),
'reinskrev': ('reinskrive',),
'reinskreiv': ('reinskrive',),
'reinskrev': ('reinskrive',),
'reinskreiv': ('reinskrive',),
'reinskrevet': ('reinskrive',),
'reinskriv': ('reinskrive',),
'reinvaske': ('reinvaske',),
'reinvasker': ('reinvaske',),
'reinvaskes': ('reinvaske',),
'reinvaska': ('reinvaske',),
'reinvasket': ('reinvaske',),
'reinvaska': ('reinvaske',),
'reinvasket': ('reinvaske',),
'reinvask': ('reinvaske',),
'reinvestere': ('reinvestere',),
'reinvesterer': ('reinvestere',),
'reinvesteres': ('reinvestere',),
'reinvesterte': ('reinvestere',),
'reinvestert': ('reinvestere',),
'reinvester': ('reinvestere',),
'reipe': ('reipe',),
'reiper': ('reipe',),
'reipes': ('reipe',),
'reipa': ('reipe',),
'reipet': ('reipe',),
'reipa': ('reipe',),
'reipet': ('reipe',),
'reip': ('reipe',),
'reise': ('reise',),
'reiser': ('reise',),
'reises': ('reise',),
'reiste': ('reise',),
'reist': ('reise',),
'reis': ('reise',),
'reive': ('reive',),
'reiver': ('reive',),
'reives': ('reive',),
'reiva': ('reive',),
'reivet': ('reive',),
'reivde': ('reive',),
'reiva': ('reive',),
'reivet': ('reive',),
'reivd': ('reive',),
'reiv': ('reive',),
'rejisere': ('rejisere',),
'rejiserer': ('rejisere',),
'rejiseres': ('rejisere',),
'rejiserte': ('rejisere',),
'rejisert': ('rejisere',),
'rejiser': ('rejisere',),
'rekapitulere': ('rekapitulere',),
'rekapitulerer': ('rekapitulere',),
'rekapituleres': ('rekapitulere',),
'rekapitulerte': ('rekapitulere',),
'rekapitulert': ('rekapitulere',),
'rekapituler': ('rekapitulere',),
'reke': ('reke',),
'reker': ('reke',),
'rekes': ('reke',),
'rekte': ('reke',),
'rekt': ('reke',),
'rek': ('reke',),
'reklamere': ('reklamere',),
'reklamerer': ('reklamere',),
'reklameres': ('reklamere',),
'reklamerte': ('reklamere',),
'reklamert': ('reklamere',),
'reklamer': ('reklamere',),
'rekognosere': ('rekognosere',),
'rekognoserer': ('rekognosere',),
'rekognoseres': ('rekognosere',),
'rekognoserte': ('rekognosere',),
'rekognosert': ('rekognosere',),
'rekognoser': ('rekognosere',),
'rekommandere': ('rekommandere',),
'rekommanderer': ('rekommandere',),
'rekommanderes': ('rekommandere',),
'rekommanderte': ('rekommandere',),
'rekommandert': ('rekommandere',),
'rekommander': ('rekommandere',),
'rekonstruere': ('rekonstruere',),
'rekonstruerer': ('rekonstruere',),
'rekonstrueres': ('rekonstruere',),
'rekonstruerte': ('rekonstruere',),
'rekonstruert': ('rekonstruere',),
'rekonstruer': ('rekonstruere',),
'rekordforbedre': ('rekordforbedre',),
'rekordforbedrer': ('rekordforbedre',),
'rekordforbedres': ('rekordforbedre',),
'rekordforbedra': ('rekordforbedre',),
'rekordforbedret': ('rekordforbedre',),
'rekordforbedra': ('rekordforbedre',),
'rekordforbedret': ('rekordforbedre',),
'rekordforbedr': ('rekordforbedre',),
'rekordforbedre': ('rekordforbedre',),
'rekordforbedr': ('rekordforbedre',),
'rekordforbedre': ('rekordforbedre',),
'rekreere': ('rekreere',),
'rekreerer': ('rekreere',),
'rekreeres': ('rekreere',),
'rekreerte': ('rekreere',),
'rekreert': ('rekreere',),
'rekreer': ('rekreere',),
'rekruttere': ('rekruttere',),
'rekrutterer': ('rekruttere',),
'rekrutteres': ('rekruttere',),
'rekrutterte': ('rekruttere',),
'rekruttert': ('rekruttere',),
'rekrutter': ('rekruttere',),
'rektifisere': ('rektifisere',),
'rektifiserer': ('rektifisere',),
'rektifiseres': ('rektifisere',),
'rektifiserte': ('rektifisere',),
'rektifisert': ('rektifisere',),
'rektifiser': ('rektifisere',),
'rekvirere': ('rekvirere',),
'rekvirerer': ('rekvirere',),
'rekvireres': ('rekvirere',),
'rekvirerte': ('rekvirere',),
'rekvirert': ('rekvirere',),
'rekvirer': ('rekvirere',),
'relatere': ('relatere',),
'relaterer': ('relatere',),
'relateres': ('relatere',),
'relaterte': ('relatere',),
'relatert': ('relatere',),
'relater': ('relatere',),
'relativisere': ('relativisere',),
'relativiserer': ('relativisere',),
'relativiseres': ('relativisere',),
'relativiserte': ('relativisere',),
'relativisert': ('relativisere',),
'relativiser': ('relativisere',),
'relegere': ('relegere',),
'relegerer': ('relegere',),
'relegeres': ('relegere',),
'relegerte': ('relegere',),
'relegert': ('relegere',),
'releger': ('relegere',),
'relokere': ('relokere',),
'relokerer': ('relokere',),
'relokeres': ('relokere',),
'relokerte': ('relokere',),
'relokert': ('relokere',),
'reloker': ('relokere',),
'rembursere': ('rembursere',),
'remburserer': ('rembursere',),
'remburseres': ('rembursere',),
'remburserte': ('rembursere',),
'rembursert': ('rembursere',),
'remburser': ('rembursere',),
'reminisere': ('reminisere',),
'reminiserer': ('reminisere',),
'reminiseres': ('reminisere',),
'reminiserte': ('reminisere',),
'reminisert': ('reminisere',),
'reminiser': ('reminisere',),
'remisere': ('remisere',),
'remiserer': ('remisere',),
'remiseres': ('remisere',),
'remiserte': ('remisere',),
'remisert': ('remisere',),
'remiser': ('remisere',),
'remittere': ('remittere',),
'remitterer': ('remittere',),
'remitteres': ('remittere',),
'remitterte': ('remittere',),
'remittert': ('remittere',),
'remitter': ('remittere',),
'remje': ('remje',),
'remjer': ('remje',),
'remjes': ('remje',),
'remja': ('remje',),
'remjet': ('remje',),
'remja': ('remje',),
'remjet': ('remje',),
'remj': ('remje',),
'remontere': ('remontere',),
'remonterer': ('remontere',),
'remonteres': ('remontere',),
'remonterte': ('remontere',),
'remontert': ('remontere',),
'remonter': ('remontere',),
'remplassere': ('remplassere',),
'remplasserer': ('remplassere',),
'remplasseres': ('remplassere',),
'remplasserte': ('remplassere',),
'remplassert': ('remplassere',),
'remplasser': ('remplassere',),
'remse': ('remse',),
'remser': ('remse',),
'remses': ('remse',),
'remsa': ('remse',),
'remset': ('remse',),
'remsa': ('remse',),
'remset': ('remse',),
'rems': ('remse',),
'rendyrke': ('rendyrke',),
'rendyrker': ('rendyrke',),
'rendyrkes': ('rendyrke',),
'rendyrka': ('rendyrke',),
'rendyrket': ('rendyrke',),
'rendyrka': ('rendyrke',),
'rendyrket': ('rendyrke',),
'rendyrk': ('rendyrke',),
'rengjøre': ('rengjøre',),
'rengjør': ('rengjøre',),
'rengjøres': ('rengjøre',),
'rengjorde': ('rengjøre',),
'rengjort': ('rengjøre',),
'rengjør': ('rengjøre',),
'renonsere': ('renonsere',),
'renonserer': ('renonsere',),
'renonseres': ('renonsere',),
'renonserte': ('renonsere',),
'renonsert': ('renonsere',),
'renonser': ('renonsere',),
'renovere': ('renovere',),
'renoverer': ('renovere',),
'renoveres': ('renovere',),
'renoverte': ('renovere',),
'renovert': ('renovere',),
'renover': ('renovere',),
'rense': ('rense',),
'renser': ('rense',),
'renses': ('rense',),
'rensa': ('rense',),
'renset': ('rense',),
'rensa': ('rense',),
'renset': ('rense',),
'rens': ('rense',),
'renske': ('renske',),
'rensker': ('renske',),
'renskes': ('renske',),
'renska': ('renske',),
'rensket': ('renske',),
'renska': ('renske',),
'rensket': ('renske',),
'rensk': ('renske',),
'renskrive': ('renskrive',),
'renskriver': ('renskrive',),
'renskrives': ('renskrive',),
'renskrev': ('renskrive',),
'renskreiv': ('renskrive',),
'renskrev': ('renskrive',),
'renskreiv': ('renskrive',),
'renskrevet': ('renskrive',),
'renskriv': ('renskrive',),
'renvaske': ('renvaske',),
'renvasker': ('renvaske',),
'renvaskes': ('renvaske',),
'renvaska': ('renvaske',),
'renvasket': ('renvaske',),
'renvaska': ('renvaske',),
'renvasket': ('renvaske',),
'renvask': ('renvaske',),
'reorganisere': ('reorganisere',),
'reorganiserer': ('reorganisere',),
'reorganiseres': ('reorganisere',),
'reorganiserte': ('reorganisere',),
'reorganisert': ('reorganisere',),
'reorganiser': ('reorganisere',),
'reparere': ('reparere',),
'reparerer': ('reparere',),
'repareres': ('reparere',),
'reparerte': ('reparere',),
'reparert': ('reparere',),
'reparer': ('reparere',),
'repatriere': ('repatriere',),
'repatrierer': ('repatriere',),
'repatrieres': ('repatriere',),
'repatrierte': ('repatriere',),
'repatriert': ('repatriere',),
'repatrier': ('repatriere',),
'repetere': ('repetere',),
'repeterer': ('repetere',),
'repeteres': ('repetere',),
'repeterte': ('repetere',),
'repetert': ('repetere',),
'repeter': ('repetere',),
'replisere': ('replisere',),
'repliserer': ('replisere',),
'repliseres': ('replisere',),
'repliserte': ('replisere',),
'replisert': ('replisere',),
'repliser': ('replisere',),
'representere': ('representere',),
'representerer': ('representere',),
'representeres': ('representere',),
'representerte': ('representere',),
'representert': ('representere',),
'representer': ('representere',),
'reprodusere': ('reprodusere',),
'reproduserer': ('reprodusere',),
'reproduseres': ('reprodusere',),
'reproduserte': ('reprodusere',),
'reprodusert': ('reprodusere',),
'reproduser': ('reprodusere',),
'reservere': ('reservere',),
'reserverer': ('reservere',),
'reserveres': ('reservere',),
'reserverte': ('reservere',),
'reservert': ('reservere',),
'reserver': ('reservere',),
'residere': ('residere',),
'residerer': ('residere',),
'resideres': ('residere',),
'residerte': ('residere',),
'residert': ('residere',),
'resider': ('residere',),
'residivere': ('residivere',),
'residiverer': ('residivere',),
'residiveres': ('residivere',),
'residiverte': ('residivere',),
'residivert': ('residivere',),
'residiver': ('residivere',),
'resignere': ('resignere',),
'resignerer': ('resignere',),
'resigneres': ('resignere',),
'resignerte': ('resignere',),
'resignert': ('resignere',),
'resigner': ('resignere',),
'resipere': ('resipere',),
'resiperer': ('resipere',),
'resiperes': ('resipere',),
'resiperte': ('resipere',),
'resipert': ('resipere',),
'resiper': ('resipere',),
'resirkulere': ('resirkulere',),
'resirkulerer': ('resirkulere',),
'resirkuleres': ('resirkulere',),
'resirkulerte': ('resirkulere',),
'resirkulert': ('resirkulere',),
'resirkuler': ('resirkulere',),
'resistere': ('resistere',),
'resisterer': ('resistere',),
'resisteres': ('resistere',),
'resisterte': ('resistere',),
'resistert': ('resistere',),
'resister': ('resistere',),
'resitere': ('resitere',),
'resiterer': ('resitere',),
'resiteres': ('resitere',),
'resiterte': ('resitere',),
'resitert': ('resitere',),
'resiter': ('resitere',),
'resolvere': ('resolvere',),
'resolverer': ('resolvere',),
'resolveres': ('resolvere',),
'resolverte': ('resolvere',),
'resolvert': ('resolvere',),
'resolver': ('resolvere',),
'resonnere': ('resonnere',),
'resonnerer': ('resonnere',),
'resonneres': ('resonnere',),
'resonnerte': ('resonnere',),
'resonnert': ('resonnere',),
'resonner': ('resonnere',),
'resorbere': ('resorbere',),
'resorberer': ('resorbere',),
'resorberes': ('resorbere',),
'resorberte': ('resorbere',),
'resorbert': ('resorbere',),
'resorber': ('resorbere',),
'resosialisere': ('resosialisere',),
'resosialiserer': ('resosialisere',),
'resosialiseres': ('resosialisere',),
'resosialiserte': ('resosialisere',),
'resosialisert': ('resosialisere',),
'resosialiser': ('resosialisere',),
'respektere': ('respektere',),
'respekterer': ('respektere',),
'respekteres': ('respektere',),
'respekterte': ('respektere',),
'respektert': ('respektere',),
'respekter': ('respektere',),
'respirere': ('respirere',),
'respirerer': ('respirere',),
'respireres': ('respirere',),
'respirerte': ('respirere',),
'respirert': ('respirere',),
'respirer': ('respirere',),
'respondere': ('respondere',),
'responderer': ('respondere',),
'responderes': ('respondere',),
'responderte': ('respondere',),
'respondert': ('respondere',),
'responder': ('respondere',),
'restaurere': ('restaurere',),
'restaurerer': ('restaurere',),
'restaureres': ('restaurere',),
'restaurerte': ('restaurere',),
'restaurert': ('restaurere',),
'restaurer': ('restaurere',),
'restere': ('restere',),
'resterer': ('restere',),
'resteres': ('restere',),
'resterte': ('restere',),
'restert': ('restere',),
'rester': ('restere',),
'restituere': ('restituere',),
'restituerer': ('restituere',),
'restitueres': ('restituere',),
'restituerte': ('restituere',),
'restituert': ('restituere',),
'restituer': ('restituere',),
'resultere': ('resultere',),
'resulterer': ('resultere',),
'resulteres': ('resultere',),
'resulterte': ('resultere',),
'resultert': ('resultere',),
'resulter': ('resultere',),
'resymere': ('resymere',),
'resymerer': ('resymere',),
'resymeres': ('resymere',),
'resymerte': ('resymere',),
'resymert': ('resymere',),
'resymer': ('resymere',),
'retardere': ('retardere',),
'retarderer': ('retardere',),
'retarderes': ('retardere',),
'retarderte': ('retardere',),
'retardert': ('retardere',),
'retarder': ('retardere',),
'retinere': ('retinere',),
'retinerer': ('retinere',),
'retineres': ('retinere',),
'retinerte': ('retinere',),
'retinert': ('retinere',),
'retiner': ('retinere',),
'retirere': ('retirere',),
'retirerer': ('retirere',),
'retireres': ('retirere',),
'retirerte': ('retirere',),
'retirert': ('retirere',),
'retirer': ('retirere',),
'rette': ('rette',),
'retter': ('rette',),
'rettes': ('rette',),
'retta': ('rette',),
'rettet': ('rette',),
'retta': ('rette',),
'rettet': ('rette',),
'rett': ('rette',),
'rettferdiggjøre': ('rettferdiggjøre',),
'rettferdiggjør': ('rettferdiggjøre',),
'rettferdiggjøres': ('rettferdiggjøre',),
'rettferdiggjorde': ('rettferdiggjøre',),
'rettferdiggjort': ('rettferdiggjøre',),
'rettferdiggjør': ('rettferdiggjøre',),
'rettkjenne': ('rettkjenne',),
'rettkjenner': ('rettkjenne',),
'rettkjennes': ('rettkjenne',),
'rettkjente': ('rettkjenne',),
'rettkjent': ('rettkjenne',),
'rettkjenn': ('rettkjenne',),
'rettlede': ('rettlede',),
'rettleder': ('rettlede',),
'rettledes': ('rettlede',),
'rettleda': ('rettlede',),
'rettledet': ('rettlede',),
'rettleda': ('rettlede',),
'rettledet': ('rettlede',),
'rettled': ('rettlede',),
'rettleie': ('rettleie',),
'rettleier': ('rettleie',),
'rettleies': ('rettleie',),
'rettleide': ('rettleie',),
'rettleid': ('rettleie',),
'rettlei': ('rettleie',),
'returnere': ('returnere',),
'returnerer': ('returnere',),
'returneres': ('returnere',),
'returnerte': ('returnere',),
'returnert': ('returnere',),
'returner': ('returnere',),
'retusjere': ('retusjere',),
'retusjerer': ('retusjere',),
'retusjeres': ('retusjere',),
'retusjerte': ('retusjere',),
'retusjert': ('retusjere',),
'retusjer': ('retusjere',),
'revaluere': ('revaluere',),
'revaluerer': ('revaluere',),
'revalueres': ('revaluere',),
'revaluerte': ('revaluere',),
'revaluert': ('revaluere',),
'revaluer': ('revaluere',),
'revansjere': ('revansjere',),
'revansjerer': ('revansjere',),
'revansjeres': ('revansjere',),
'revansjerte': ('revansjere',),
'revansjert': ('revansjere',),
'revansjer': ('revansjere',),
'reve': ('reve',),
'rever': ('reve',),
'reves': ('reve',),
'reva': ('reve',),
'revet': ('reve',),
'revde': ('reve',),
'reva': ('reve',),
'revet': ('reve',),
'revd': ('reve',),
'rev': ('reve',),
'reversere': ('reversere',),
'reverserer': ('reversere',),
'reverseres': ('reversere',),
'reverserte': ('reversere',),
'reversert': ('reversere',),
'reverser': ('reversere',),
'revidere': ('revidere',),
'reviderer': ('revidere',),
'revideres': ('revidere',),
'reviderte': ('revidere',),
'revidert': ('revidere',),
'revider': ('revidere',),
'revne': ('revne',),
'revner': ('revne',),
'revnes': ('revne',),
'revna': ('revne',),
'revnet': ('revne',),
'revna': ('revne',),
'revnet': ('revne',),
'revn': ('revne',),
'revoltere': ('revoltere',),
'revolterer': ('revoltere',),
'revolteres': ('revoltere',),
'revolterte': ('revoltere',),
'revoltert': ('revoltere',),
'revolter': ('revoltere',),
'revolusjonere': ('revolusjonere',),
'revolusjonerer': ('revolusjonere',),
'revolusjoneres': ('revolusjonere',),
'revolusjonerte': ('revolusjonere',),
'revolusjonert': ('revolusjonere',),
'revolusjoner': ('revolusjonere',),
'ri': ('ri',),
'rir': ('ri',),
'ris': ('ri',),
'rei': ('ri',),
'red': ('ri',),
'ridd': ('ri',),
'ri': ('ri',),
'ribbe': ('ribbe',),
'ribber': ('ribbe',),
'ribbes': ('ribbe',),
'ribba': ('ribbe',),
'ribbet': ('ribbe',),
'ribba': ('ribbe',),
'ribbet': ('ribbe',),
'ribb': ('ribbe',),
'ride': ('ride',),
'rider': ('ride',),
'rides': ('ride',),
'rei': ('ride',),
'red': ('ride',),
'ridd': ('ride',),
'rid': ('ride',),
'rifle': ('rifle',),
'rifler': ('rifle',),
'rifles': ('rifle',),
'rifla': ('rifle',),
'riflet': ('rifle',),
'rifla': ('rifle',),
'riflet': ('rifle',),
'rifl': ('rifle',),
'rifle': ('rifle',),
'rifl': ('rifle',),
'rifle': ('rifle',),
'rigge': ('rigge',),
'rigger': ('rigge',),
'rigges': ('rigge',),
'rigga': ('rigge',),
'rigget': ('rigge',),
'rigga': ('rigge',),
'rigget': ('rigge',),
'rigg': ('rigge',),
'rikke': ('rikke',),
'rikker': ('rikke',),
'rikkes': ('rikke',),
'rikka': ('rikke',),
'rikket': ('rikke',),
'rikka': ('rikke',),
'rikket': ('rikke',),
'rikk': ('rikke',),
'rikle': ('rikle',),
'rikler': ('rikle',),
'rikles': ('rikle',),
'rikla': ('rikle',),
'riklet': ('rikle',),
'rikla': ('rikle',),
'riklet': ('rikle',),
'rikl': ('rikle',),
'rikle': ('rikle',),
'rikl': ('rikle',),
'rikle': ('rikle',),
'rikosjettere': ('rikosjettere',),
'rikosjetterer': ('rikosjettere',),
'rikosjetteres': ('rikosjettere',),
'rikosjetterte': ('rikosjettere',),
'rikosjettert': ('rikosjettere',),
'rikosjetter': ('rikosjettere',),
'rikse': ('rikse',),
'rikser': ('rikse',),
'rikses': ('rikse',),
'riksa': ('rikse',),
'rikset': ('rikse',),
'riksa': ('rikse',),
'rikset': ('rikse',),
'riks': ('rikse',),
'rikte': ('rikte',),
'rikter': ('rikte',),
'riktes': ('rikte',),
'rikta': ('rikte',),
'riktet': ('rikte',),
'rikta': ('rikte',),
'riktet': ('rikte',),
'rikt': ('rikte',),
'rime': ('rime',),
'rimer': ('rime',),
'rimes': ('rime',),
'rima': ('rime',),
'rimet': ('rime',),
'rima': ('rime',),
'rimet': ('rime',),
'rim': ('rime',),
'rime': ('rime',),
'rimer': ('rime',),
'rimes': ('rime',),
'rima': ('rime',),
'rimet': ('rime',),
'rimte': ('rime',),
'rima': ('rime',),
'rimet': ('rime',),
'rimt': ('rime',),
'rim': ('rime',),
'rine': ('rine',),
'riner': ('rine',),
'rines': ('rine',),
'rinte': ('rine',),
'rint': ('rine',),
'rin': ('rine',),
'ringe': ('ringe',),
'ringer': ('ringe',),
'ringes': ('ringe',),
'ringa': ('ringe',),
'ringet': ('ringe',),
'ringa': ('ringe',),
'ringet': ('ringe',),
'ring': ('ringe',),
'ringe': ('ringe',),
'ringer': ('ringe',),
'ringes': ('ringe',),
'ringte': ('ringe',),
'ringt': ('ringe',),
'ring': ('ringe',),
'ringeakte': ('ringeakte',),
'ringeakter': ('ringeakte',),
'ringeaktes': ('ringeakte',),
'ringeakta': ('ringeakte',),
'ringeaktet': ('ringeakte',),
'ringeakta': ('ringeakte',),
'ringeaktet': ('ringeakte',),
'ringeakt': ('ringeakte',),
'ringle': ('ringle',),
'ringler': ('ringle',),
'ringles': ('ringle',),
'ringla': ('ringle',),
'ringlet': ('ringle',),
'ringla': ('ringle',),
'ringlet': ('ringle',),
'ringl': ('ringle',),
'ringle': ('ringle',),
'ringl': ('ringle',),
'ringle': ('ringle',),
'ringmerke': ('ringmerke',),
'ringmerker': ('ringmerke',),
'ringmerkes': ('ringmerke',),
'ringmerka': ('ringmerke',),
'ringmerket': ('ringmerke',),
'ringmerka': ('ringmerke',),
'ringmerket': ('ringmerke',),
'ringmerk': ('ringmerke',),
'rinne': ('rinne',),
'rinner': ('rinne',),
'rinnes': ('rinne',),
'rant': ('rinne',),
'runnet': ('rinne',),
'rinn': ('rinne',),
'ripe': ('ripe',),
'riper': ('ripe',),
'ripes': ('ripe',),
'ripa': ('ripe',),
'ripet': ('ripe',),
'ripte': ('ripe',),
'ripa': ('ripe',),
'ripet': ('ripe',),
'ript': ('ripe',),
'rip': ('ripe',),
'ripostere': ('ripostere',),
'riposterer': ('ripostere',),
'riposteres': ('ripostere',),
'riposterte': ('ripostere',),
'ripostert': ('ripostere',),
'riposter': ('ripostere',),
'rippe': ('rippe',),
'ripper': ('rippe',),
'rippes': ('rippe',),
'rippa': ('rippe',),
'rippet': ('rippe',),
'rippa': ('rippe',),
'rippet': ('rippe',),
'ripp': ('rippe',),
'rise': ('rise',),
'riser': ('rise',),
'rises': ('rise',),
'riste': ('rise',),
'rist': ('rise',),
'ris': ('rise',),
'risikere': ('risikere',),
'risikerer': ('risikere',),
'risikeres': ('risikere',),
'risikerte': ('risikere',),
'risikert': ('risikere',),
'risiker': ('risikere',),
'risle': ('risle',),
'risler': ('risle',),
'risles': ('risle',),
'risla': ('risle',),
'rislet': ('risle',),
'risla': ('risle',),
'rislet': ('risle',),
'risl': ('risle',),
'risle': ('risle',),
'risl': ('risle',),
'risle': ('risle',),
'rispe': ('rispe',),
'risper': ('rispe',),
'rispes': ('rispe',),
'rispa': ('rispe',),
'rispet': ('rispe',),
'rispa': ('rispe',),
'rispet': ('rispe',),
'risp': ('rispe',),
'risse': ('risse',),
'risser': ('risse',),
'risses': ('risse',),
'rissa': ('risse',),
'risset': ('risse',),
'rissa': ('risse',),
'risset': ('risse',),
'riss': ('risse',),
'riste': ('riste',),
'rister': ('riste',),
'ristes': ('riste',),
'rista': ('riste',),
'ristet': ('riste',),
'rista': ('riste',),
'ristet': ('riste',),
'rist': ('riste',),
'ristornere': ('ristornere',),
'ristornerer': ('ristornere',),
'ristorneres': ('ristornere',),
'ristornerte': ('ristornere',),
'ristornert': ('ristornere',),
'ristorner': ('ristornere',),
'rite': ('rite',),
'riter': ('rite',),
'rites': ('rite',),
'rita': ('rite',),
'ritet': ('rite',),
'rita': ('rite',),
'ritet': ('rite',),
'rit': ('rite',),
'ritualisere': ('ritualisere',),
'ritualiserer': ('ritualisere',),
'ritualiseres': ('ritualisere',),
'ritualiserte': ('ritualisere',),
'ritualisert': ('ritualisere',),
'ritualiser': ('ritualisere',),
'rivalisere': ('rivalisere',),
'rivaliserer': ('rivalisere',),
'rivaliseres': ('rivalisere',),
'rivaliserte': ('rivalisere',),
'rivalisert': ('rivalisere',),
'rivaliser': ('rivalisere',),
'rive': ('rive',),
'river': ('rive',),
'rives': ('rive',),
'rev': ('rive',),
'reiv': ('rive',),
'rev': ('rive',),
'reiv': ('rive',),
'revet': ('rive',),
'riv': ('rive',),
'ro': ('ro',),
'ror': ('ro',),
'ros': ('ro',),
'rodde': ('ro',),
'rodd': ('ro',),
'ro': ('ro',),
'robbe': ('robbe',),
'robber': ('robbe',),
'robbes': ('robbe',),
'robba': ('robbe',),
'robbet': ('robbe',),
'robba': ('robbe',),
'robbet': ('robbe',),
'robb': ('robbe',),
'robotisere': ('robotisere',),
'robotiserer': ('robotisere',),
'robotiseres': ('robotisere',),
'robotiserte': ('robotisere',),
'robotisert': ('robotisere',),
'robotiser': ('robotisere',),
'rocke': ('rocke',),
'rocker': ('rocke',),
'rockes': ('rocke',),
'rocka': ('rocke',),
'rocket': ('rocke',),
'rocka': ('rocke',),
'rocket': ('rocke',),
'rock': ('rocke',),
'roe': ('roe',),
'roer': ('roe',),
'roes': ('roe',),
'roa': ('roe',),
'roet': ('roe',),
'roa': ('roe',),
'roet': ('roe',),
'ro': ('roe',),
'rokere': ('rokere',),
'rokerer': ('rokere',),
'rokeres': ('rokere',),
'rokerte': ('rokere',),
'rokert': ('rokere',),
'roker': ('rokere',),
'rokke': ('rokke',),
'rokker': ('rokke',),
'rokkes': ('rokke',),
'rokka': ('rokke',),
'rokket': ('rokke',),
'rokka': ('rokke',),
'rokket': ('rokke',),
'rokk': ('rokke',),
'rolle': ('rolle',),
'roller': ('rolle',),
'rolles': ('rolle',),
'rolla': ('rolle',),
'rollet': ('rolle',),
'rolla': ('rolle',),
'rollet': ('rolle',),
'roll': ('rolle',),
'romanisere': ('romanisere',),
'romaniserer': ('romanisere',),
'romaniseres': ('romanisere',),
'romaniserte': ('romanisere',),
'romanisert': ('romanisere',),
'romaniser': ('romanisere',),
'romantisere': ('romantisere',),
'romantiserer': ('romantisere',),
'romantiseres': ('romantisere',),
'romantiserte': ('romantisere',),
'romantisert': ('romantisere',),
'romantiser': ('romantisere',),
'romme': ('romme',),
'rommer': ('romme',),
'rommes': ('romme',),
'romma': ('romme',),
'rommet': ('romme',),
'romma': ('romme',),
'rommet': ('romme',),
'rom': ('romme',),
'romstere': ('romstere',),
'romsterer': ('romstere',),
'romsteres': ('romstere',),
'romsterte': ('romstere',),
'romstert': ('romstere',),
'romster': ('romstere',),
'rope': ('rope',),
'roper': ('rope',),
'ropes': ('rope',),
'ropte': ('rope',),
'ropt': ('rope',),
'rop': ('rope',),
'rose': ('rose',),
'roser': ('rose',),
'roses': ('rose',),
'roste': ('rose',),
'rost': ('rose',),
'ros': ('rose',),
'rosemale': ('rosemale',),
'rosemaler': ('rosemale',),
'rosemales': ('rosemale',),
'rosemalte': ('rosemale',),
'rosemalt': ('rosemale',),
'rosemal': ('rosemale',),
'roste': ('roste',),
'roster': ('roste',),
'rostes': ('roste',),
'rosta': ('roste',),
'rostet': ('roste',),
'rosta': ('roste',),
'rostet': ('roste',),
'rost': ('roste',),
'rote': ('rote',),
'roter': ('rote',),
'rotes': ('rote',),
'rota': ('rote',),
'rotet': ('rote',),
'rota': ('rote',),
'rotet': ('rote',),
'rot': ('rote',),
'rotere': ('rotere',),
'roterer': ('rotere',),
'roteres': ('rotere',),
'roterte': ('rotere',),
'rotert': ('rotere',),
'roter': ('rotere',),
'rotfeste': ('rotfeste',),
'rotfester': ('rotfeste',),
'rotfestes': ('rotfeste',),
'rotfesta': ('rotfeste',),
'rotfestet': ('rotfeste',),
'rotfesta': ('rotfeste',),
'rotfestet': ('rotfeste',),
'rotfest': ('rotfeste',),
'rotfylle': ('rotfylle',),
'rotfyller': ('rotfylle',),
'rotfylles': ('rotfylle',),
'rotfylte': ('rotfylle',),
'rotfylt': ('rotfylle',),
'rotfyll': ('rotfylle',),
'rotte': ('rotte',),
'rotter': ('rotte',),
'rottes': ('rotte',),
'rotta': ('rotte',),
'rottet': ('rotte',),
'rotta': ('rotte',),
'rottet': ('rotte',),
'rott': ('rotte',),
'rubbe': ('rubbe',),
'rubber': ('rubbe',),
'rubbes': ('rubbe',),
'rubba': ('rubbe',),
'rubbet': ('rubbe',),
'rubba': ('rubbe',),
'rubbet': ('rubbe',),
'rubb': ('rubbe',),
'rubrisere': ('rubrisere',),
'rubriserer': ('rubrisere',),
'rubriseres': ('rubrisere',),
'rubriserte': ('rubrisere',),
'rubrisert': ('rubrisere',),
'rubriser': ('rubrisere',),
'rufse': ('rufse',),
'rufser': ('rufse',),
'rufses': ('rufse',),
'rufsa': ('rufse',),
'rufset': ('rufse',),
'rufsa': ('rufse',),
'rufset': ('rufse',),
'rufs': ('rufse',),
'ruge': ('ruge',),
'ruger': ('ruge',),
'ruges': ('ruge',),
'ruga': ('ruge',),
'ruget': ('ruge',),
'ruga': ('ruge',),
'ruget': ('ruge',),
'rug': ('ruge',),
'rugge': ('rugge',),
'rugger': ('rugge',),
'rugges': ('rugge',),
'rugga': ('rugge',),
'rugget': ('rugge',),
'rugga': ('rugge',),
'rugget': ('rugge',),
'rugg': ('rugge',),
'rugle': ('rugle',),
'rugler': ('rugle',),
'rugles': ('rugle',),
'rugla': ('rugle',),
'ruglet': ('rugle',),
'rugla': ('rugle',),
'ruglet': ('rugle',),
'rugl': ('rugle',),
'rugle': ('rugle',),
'rugl': ('rugle',),
'rugle': ('rugle',),
'ruinere': ('ruinere',),
'ruinerer': ('ruinere',),
'ruineres': ('ruinere',),
'ruinerte': ('ruinere',),
'ruinert': ('ruinere',),
'ruiner': ('ruinere',),
'rukke': ('rukke',),
'rukker': ('rukke',),
'rukkes': ('rukke',),
'rukka': ('rukke',),
'rukket': ('rukke',),
'rukka': ('rukke',),
'rukket': ('rukke',),
'rukk': ('rukke',),
'rulle': ('rulle',),
'ruller': ('rulle',),
'rulles': ('rulle',),
'rulla': ('rulle',),
'rullet': ('rulle',),
'rulla': ('rulle',),
'rullet': ('rulle',),
'rull': ('rulle',),
'rulleføre': ('rulleføre',),
'rullefører': ('rulleføre',),
'rulleføres': ('rulleføre',),
'rulleførte': ('rulleføre',),
'rulleført': ('rulleføre',),
'rullefør': ('rulleføre',),
'rullere': ('rullere',),
'rullerer': ('rullere',),
'rulleres': ('rullere',),
'rullerte': ('rullere',),
'rullert': ('rullere',),
'ruller': ('rullere',),
'rulte': ('rulte',),
'rulter': ('rulte',),
'rultes': ('rulte',),
'rulta': ('rulte',),
'rultet': ('rulte',),
'rulta': ('rulte',),
'rultet': ('rulte',),
'rult': ('rulte',),
'rumle': ('rumle',),
'rumler': ('rumle',),
'rumles': ('rumle',),
'rumla': ('rumle',),
'rumlet': ('rumle',),
'rumla': ('rumle',),
'rumlet': ('rumle',),
'ruml': ('rumle',),
'rumle': ('rumle',),
'ruml': ('rumle',),
'rumle': ('rumle',),
'runde': ('runde',),
'runder': ('runde',),
'rundes': ('runde',),
'runda': ('runde',),
'rundet': ('runde',),
'runda': ('runde',),
'rundet': ('runde',),
'rund': ('runde',),
'rundjule': ('rundjule',),
'rundjuler': ('rundjule',),
'rundjules': ('rundjule',),
'rundjulte': ('rundjule',),
'rundjult': ('rundjule',),
'rundjul': ('rundjule',),
'rundstjele': ('rundstjele',),
'rundstjeler': ('rundstjele',),
'rundstjeles': ('rundstjele',),
'rundstjal': ('rundstjele',),
'rundstjålet': ('rundstjele',),
'rundstjel': ('rundstjele',),
'rundvaske': ('rundvaske',),
'rundvasker': ('rundvaske',),
'rundvaskes': ('rundvaske',),
'rundvaska': ('rundvaske',),
'rundvasket': ('rundvaske',),
'rundvaska': ('rundvaske',),
'rundvasket': ('rundvaske',),
'rundvask': ('rundvaske',),
'rune': ('rune',),
'runer': ('rune',),
'runes': ('rune',),
'runa': ('rune',),
'runet': ('rune',),
'runa': ('rune',),
'runet': ('rune',),
'run': ('rune',),
'runge': ('runge',),
'runger': ('runge',),
'runges': ('runge',),
'runga': ('runge',),
'runget': ('runge',),
'runga': ('runge',),
'runget': ('runge',),
'rung': ('runge',),
'runke': ('runke',),
'runker': ('runke',),
'runkes': ('runke',),
'runka': ('runke',),
'runket': ('runke',),
'runka': ('runke',),
'runket': ('runke',),
'runk': ('runke',),
'ruse': ('ruse',),
'ruser': ('ruse',),
'ruses': ('ruse',),
'rusa': ('ruse',),
'ruset': ('ruse',),
'rusa': ('ruse',),
'ruset': ('ruse',),
'rus': ('ruse',),
'ruse': ('ruse',),
'ruser': ('ruse',),
'ruses': ('ruse',),
'rusa': ('ruse',),
'ruset': ('ruse',),
'ruste': ('ruse',),
'rusa': ('ruse',),
'ruset': ('ruse',),
'rust': ('ruse',),
'rus': ('ruse',),
'rushe': ('rushe',),
'rusher': ('rushe',),
'rushes': ('rushe',),
'rusha': ('rushe',),
'rushet': ('rushe',),
'rusha': ('rushe',),
'rushet': ('rushe',),
'rush': ('rushe',),
'ruske': ('ruske',),
'rusker': ('ruske',),
'ruskes': ('ruske',),
'ruska': ('ruske',),
'rusket': ('ruske',),
'ruska': ('ruske',),
'rusket': ('ruske',),
'rusk': ('ruske',),
'rusle': ('rusle',),
'rusler': ('rusle',),
'rusles': ('rusle',),
'rusla': ('rusle',),
'ruslet': ('rusle',),
'rusla': ('rusle',),
'ruslet': ('rusle',),
'rusl': ('rusle',),
'rusle': ('rusle',),
'rusl': ('rusle',),
'rusle': ('rusle',),
'russifisere': ('russifisere',),
'russifiserer': ('russifisere',),
'russifiseres': ('russifisere',),
'russifiserte': ('russifisere',),
'russifisert': ('russifisere',),
'russifiser': ('russifisere',),
'rustbehandle': ('rustbehandle',),
'rustbehandler': ('rustbehandle',),
'rustbehandles': ('rustbehandle',),
'rustbehandla': ('rustbehandle',),
'rustbehandlet': ('rustbehandle',),
'rustbehandla': ('rustbehandle',),
'rustbehandlet': ('rustbehandle',),
'rustbehandl': ('rustbehandle',),
'rustbehandle': ('rustbehandle',),
'rustbehandl': ('rustbehandle',),
'rustbehandle': ('rustbehandle',),
'ruste': ('ruste',),
'ruster': ('ruste',),
'rustes': ('ruste',),
'rusta': ('ruste',),
'rustet': ('ruste',),
'rusta': ('ruste',),
'rustet': ('ruste',),
'rust': ('ruste',),
'rustifisere': ('rustifisere',),
'rustifiserer': ('rustifisere',),
'rustifiseres': ('rustifisere',),
'rustifiserte': ('rustifisere',),
'rustifisert': ('rustifisere',),
'rustifiser': ('rustifisere',),
'rustne': ('rustne',),
'rustner': ('rustne',),
'rustnes': ('rustne',),
'rustna': ('rustne',),
'rustnet': ('rustne',),
'rustna': ('rustne',),
'rustnet': ('rustne',),
'rustn': ('rustne',),
'rustne': ('rustne',),
'rustn': ('rustne',),
'rustne': ('rustne',),
'rute': ('rute',),
'ruter': ('rute',),
'rutes': ('rute',),
'ruta': ('rute',),
'rutet': ('rute',),
'ruta': ('rute',),
'rutet': ('rute',),
'rut': ('rute',),
'rutle': ('rutle',),
'rutler': ('rutle',),
'rutles': ('rutle',),
'rutla': ('rutle',),
'rutlet': ('rutle',),
'rutla': ('rutle',),
'rutlet': ('rutle',),
'rutl': ('rutle',),
'rutle': ('rutle',),
'rutl': ('rutle',),
'rutle': ('rutle',),
'rutsje': ('rutsje',),
'rutsjer': ('rutsje',),
'rutsjes': ('rutsje',),
'rutsja': ('rutsje',),
'rutsjet': ('rutsje',),
'rutsja': ('rutsje',),
'rutsjet': ('rutsje',),
'rutsj': ('rutsje',),
'rutsje': ('rutsje',),
'rutsj': ('rutsje',),
'rutsje': ('rutsje',),
'rutte': ('rutte',),
'rutter': ('rutte',),
'ruttes': ('rutte',),
'rutta': ('rutte',),
'ruttet': ('rutte',),
'rutta': ('rutte',),
'ruttet': ('rutte',),
'rutt': ('rutte',),
'ruve': ('ruve',),
'ruver': ('ruve',),
'ruves': ('ruve',),
'ruva': ('ruve',),
'ruvet': ('ruve',),
'ruvde': ('ruve',),
'ruva': ('ruve',),
'ruvet': ('ruve',),
'ruvd': ('ruve',),
'ruv': ('ruve',),
'ry': ('ry',),
'ryr': ('ry',),
'rys': ('ry',),
'rydde': ('ry',),
'rydd': ('ry',),
'ry': ('ry',),
'rydde': ('rydde',),
'rydder': ('rydde',),
'ryddes': ('rydde',),
'rydda': ('rydde',),
'ryddet': ('rydde',),
'rydda': ('rydde',),
'ryddet': ('rydde',),
'rydd': ('rydde',),
'rygge': ('rygge',),
'rygger': ('rygge',),
'rygges': ('rygge',),
'rygga': ('rygge',),
'rygget': ('rygge',),
'rygga': ('rygge',),
'rygget': ('rygge',),
'rygg': ('rygge',),
'ryke': ('ryke',),
'ryker': ('ryke',),
'rykes': ('ryke',),
'røyk': ('ryke',),
'røk': ('ryke',),
'røket': ('ryke',),
'ryk': ('ryke',),
'rykke': ('rykke',),
'rykker': ('rykke',),
'rykkes': ('rykke',),
'rykka': ('rykke',),
'rykket': ('rykke',),
'rykte': ('rykke',),
'rykka': ('rykke',),
'rykket': ('rykke',),
'rykt': ('rykke',),
'rykk': ('rykke',),
'ryktes': ('ryktes',),
'ryktedes': ('ryktes',),
'ryktes': ('ryktes',),
'rynke': ('rynke',),
'rynker': ('rynke',),
'rynkes': ('rynke',),
'rynka': ('rynke',),
'rynket': ('rynke',),
'rynka': ('rynke',),
'rynket': ('rynke',),
'rynk': ('rynke',),
'ryste': ('ryste',),
'ryster': ('ryste',),
'rystes': ('ryste',),
'rysta': ('ryste',),
'rystet': ('ryste',),
'rysta': ('ryste',),
'rystet': ('ryste',),
'ryst': ('ryste',),
'ryte': ('ryte',),
'ryter': ('ryte',),
'rytes': ('ryte',),
'røyt': ('ryte',),
'røt': ('ryte',),
'rytt': ('ryte',),
'ryt': ('ryte',),
'rå': ('rå',),
'rår': ('rå',),
'rås': ('rå',),
'rådde': ('rå',),
'rådd': ('rå',),
'rå': ('rå',),
'råde': ('råde',),
'råder': ('råde',),
'rådes': ('råde',),
'rådet': ('råde',),
'rådde': ('råde',),
'rådet': ('råde',),
'rådd': ('råde',),
'råd': ('råde',),
'rådføre': ('rådføre',),
'rådfører': ('rådføre',),
'rådføres': ('rådføre',),
'rådførte': ('rådføre',),
'rådført': ('rådføre',),
'rådfør': ('rådføre',),
'rådlegge': ('rådlegge',),
'rådlegger': ('rådlegge',),
'rådlegges': ('rådlegge',),
'rådla': ('rådlegge',),
'rådlagt': ('rådlegge',),
'rådlegg': ('rådlegge',),
'rådspørre': ('rådspørre',),
'rådspør': ('rådspørre',),
'rådspørres': ('rådspørre',),
'rådspurte': ('rådspørre',),
'rådspurt': ('rådspørre',),
'rådspør': ('rådspørre',),
'råke': ('råke',),
'råker': ('råke',),
'råkes': ('råke',),
'råka': ('råke',),
'råket': ('råke',),
'råkte': ('råke',),
'råka': ('råke',),
'råket': ('råke',),
'råkt': ('råke',),
'råk': ('råke',),
'råkjøre': ('råkjøre',),
'råkjører': ('råkjøre',),
'råkjøres': ('råkjøre',),
'råkjørte': ('råkjøre',),
'råkjørt': ('råkjøre',),
'råkjør': ('råkjøre',),
'råle': ('råle',),
'råler': ('råle',),
'råles': ('råle',),
'råla': ('råle',),
'rålet': ('råle',),
'rålte': ('råle',),
'råla': ('råle',),
'rålet': ('råle',),
'rålt': ('råle',),
'rål': ('råle',),
'råne': ('råne',),
'råner': ('råne',),
'rånes': ('råne',),
'råna': ('råne',),
'rånet': ('råne',),
'rånte': ('råne',),
'råna': ('råne',),
'rånet': ('råne',),
'rånt': ('råne',),
'rån': ('råne',),
'råtne': ('råtne',),
'råtner': ('råtne',),
'råtnes': ('råtne',),
'råtna': ('råtne',),
'råtnet': ('råtne',),
'råtna': ('råtne',),
'råtnet': ('råtne',),
'råtn': ('råtne',),
'råtne': ('råtne',),
'råtn': ('råtne',),
'råtne': ('råtne',),
'røde': ('røde',),
'røder': ('røde',),
'rødes': ('røde',),
'rødde': ('røde',),
'rødd': ('røde',),
'rød': ('røde',),
'rødme': ('rødme',),
'rødmer': ('rødme',),
'rødmes': ('rødme',),
'rødma': ('rødme',),
'rødmet': ('rødme',),
'rødma': ('rødme',),
'rødmet': ('rødme',),
'rødm': ('rødme',),
'rødme': ('rødme',),
'rødm': ('rødme',),
'rødme': ('rødme',),
'rødne': ('rødne',),
'rødner': ('rødne',),
'rødnes': ('rødne',),
'rødna': ('rødne',),
'rødnet': ('rødne',),
'rødna': ('rødne',),
'rødnet': ('rødne',),
'rødn': ('rødne',),
'rødne': ('rødne',),
'rødn': ('rødne',),
'rødne': ('rødne',),
'røfle': ('røfle',),
'røfler': ('røfle',),
'røfles': ('røfle',),
'røfla': ('røfle',),
'røflet': ('røfle',),
'røfla': ('røfle',),
'røflet': ('røfle',),
'røfl': ('røfle',),
'røfle': ('røfle',),
'røfl': ('røfle',),
'røfle': ('røfle',),
'røklegge': ('røklegge',),
'røklegger': ('røklegge',),
'røklegges': ('røklegge',),
'røkla': ('røklegge',),
'røklagt': ('røklegge',),
'røklegg': ('røklegge',),
'røkte': ('røkte',),
'røkter': ('røkte',),
'røktes': ('røkte',),
'røkta': ('røkte',),
'røktet': ('røkte',),
'røkta': ('røkte',),
'røktet': ('røkte',),
'røkt': ('røkte',),
'røle': ('røle',),
'røler': ('røle',),
'røles': ('røle',),
'rølte': ('røle',),
'rølt': ('røle',),
'røl': ('røle',),
'røntgenfotografere': ('røntgenfotografere',),
'røntgenfotograferer': ('røntgenfotografere',),
'røntgenfotograferes': ('røntgenfotografere',),
'røntgenfotograferte': ('røntgenfotografere',),
'røntgenfotografert': ('røntgenfotografere',),
'røntgenfotografer': ('røntgenfotografere',),
'røpe': ('røpe',),
'røper': ('røpe',),
'røpes': ('røpe',),
'røpa': ('røpe',),
'røpet': ('røpe',),
'røpte': ('røpe',),
'røpa': ('røpe',),
'røpet': ('røpe',),
'røpt': ('røpe',),
'røp': ('røpe',),
'røre': ('røre',),
'rører': ('røre',),
'røres': ('røre',),
'rørte': ('røre',),
'rørt': ('røre',),
'rør': ('røre',),
'røske': ('røske',),
'røsker': ('røske',),
'røskes': ('røske',),
'røska': ('røske',),
'røsket': ('røske',),
'røska': ('røske',),
'røsket': ('røske',),
'røsk': ('røske',),
'røste': ('røste',),
'røster': ('røste',),
'røstes': ('røste',),
'røsta': ('røste',),
'røstet': ('røste',),
'røsta': ('røste',),
'røstet': ('røste',),
'røst': ('røste',),
'røve': ('røve',),
'røver': ('røve',),
'røves': ('røve',),
'røva': ('røve',),
'røvet': ('røve',),
'røvde': ('røve',),
'røva': ('røve',),
'røvet': ('røve',),
'røvd': ('røve',),
'røv': ('røve',),
'røyke': ('røyke',),
'røyker': ('røyke',),
'røykes': ('røyke',),
'røyka': ('røyke',),
'røykte': ('røyke',),
'røyka': ('røyke',),
'røykt': ('røyke',),
'røyk': ('røyke',),
'røyklegge': ('røyklegge',),
'røyklegger': ('røyklegge',),
'røyklegges': ('røyklegge',),
'røykla': ('røyklegge',),
'røyklagt': ('røyklegge',),
'røyklegg': ('røyklegge',),
'røyne': ('røyne',),
'røyner': ('røyne',),
'røynes': ('røyne',),
'røyna': ('røyne',),
'røynet': ('røyne',),
'røynte': ('røyne',),
'røyna': ('røyne',),
'røynet': ('røyne',),
'røynt': ('røyne',),
'røyn': ('røyne',),
'røyse': ('røyse',),
'røyser': ('røyse',),
'røyses': ('røyse',),
'røyset': ('røyse',),
'røyste': ('røyse',),
'røyset': ('røyse',),
'røyst': ('røyse',),
'røys': ('røyse',),
'røyte': ('røyte',),
'røyter': ('røyte',),
'røytes': ('røyte',),
'røyta': ('røyte',),
'røytet': ('røyte',),
'røyta': ('røyte',),
'røytet': ('røyte',),
'røyt': ('røyte',),
'sabbe': ('sabbe',),
'sabber': ('sabbe',),
'sabbes': ('sabbe',),
'sabba': ('sabbe',),
'sabbet': ('sabbe',),
'sabba': ('sabbe',),
'sabbet': ('sabbe',),
'sabb': ('sabbe',),
'sable': ('sable',),
'sabler': ('sable',),
'sables': ('sable',),
'sabla': ('sable',),
'sablet': ('sable',),
'sabla': ('sable',),
'sablet': ('sable',),
'sabl': ('sable',),
'sable': ('sable',),
'sabl': ('sable',),
'sable': ('sable',),
'sabotere': ('sabotere',),
'saboterer': ('sabotere',),
'saboteres': ('sabotere',),
'saboterte': ('sabotere',),
'sabotert': ('sabotere',),
'saboter': ('sabotere',),
'sadle': ('sadle',),
'sadler': ('sadle',),
'sadles': ('sadle',),
'sadla': ('sadle',),
'sadlet': ('sadle',),
'sadla': ('sadle',),
'sadlet': ('sadle',),
'sadl': ('sadle',),
'sadle': ('sadle',),
'sadl': ('sadle',),
'sadle': ('sadle',),
'safe': ('safe',),
'safer': ('safe',),
'safes': ('safe',),
'safa': ('safe',),
'safet': ('safe',),
'safa': ('safe',),
'safet': ('safe',),
'saf': ('safe',),
'safte': ('safte',),
'safter': ('safte',),
'saftes': ('safte',),
'safta': ('safte',),
'saftet': ('safte',),
'safta': ('safte',),
'saftet': ('safte',),
'saft': ('safte',),
'sage': ('sage',),
'sager': ('sage',),
'sages': ('sage',),
'saga': ('sage',),
'saget': ('sage',),
'sagde': ('sage',),
'saga': ('sage',),
'saget': ('sage',),
'sagd': ('sage',),
'sag': ('sage',),
'sake': ('sake',),
'saker': ('sake',),
'sakes': ('sake',),
'saka': ('sake',),
'saket': ('sake',),
'saka': ('sake',),
'saket': ('sake',),
'sak': ('sake',),
'sakfelle': ('sakfelle',),
'sakfeller': ('sakfelle',),
'sakfelles': ('sakfelle',),
'sakfelte': ('sakfelle',),
'sakfelt': ('sakfelle',),
'sakfell': ('sakfelle',),
'sakke': ('sakke',),
'sakker': ('sakke',),
'sakkes': ('sakke',),
'sakka': ('sakke',),
'sakket': ('sakke',),
'sakka': ('sakke',),
'sakket': ('sakke',),
'sakk': ('sakke',),
'sakne': ('sakne',),
'sakner': ('sakne',),
'saknes': ('sakne',),
'sakna': ('sakne',),
'saknet': ('sakne',),
'sakna': ('sakne',),
'saknet': ('sakne',),
'sakn': ('sakne',),
'sakne': ('sakne',),
'sakn': ('sakne',),
'sakne': ('sakne',),
'sakse': ('sakse',),
'sakser': ('sakse',),
'sakses': ('sakse',),
'saksa': ('sakse',),
'sakset': ('sakse',),
'saksa': ('sakse',),
'sakset': ('sakse',),
'saks': ('sakse',),
'saksøke': ('saksøke',),
'saksøker': ('saksøke',),
'saksøkes': ('saksøke',),
'saksøkte': ('saksøke',),
'saksøkt': ('saksøke',),
'saksøk': ('saksøke',),
'sakte': ('sakte',),
'sakter': ('sakte',),
'saktes': ('sakte',),
'sakta': ('sakte',),
'saktet': ('sakte',),
'sakta': ('sakte',),
'saktet': ('sakte',),
'sakt': ('sakte',),
'saktne': ('saktne',),
'saktner': ('saktne',),
'saktnes': ('saktne',),
'saktna': ('saktne',),
'saktnet': ('saktne',),
'saktna': ('saktne',),
'saktnet': ('saktne',),
'saktn': ('saktne',),
'saktne': ('saktne',),
'saktn': ('saktne',),
'saktne': ('saktne',),
'saldere': ('saldere',),
'salderer': ('saldere',),
'salderes': ('saldere',),
'salderte': ('saldere',),
'saldert': ('saldere',),
'salder': ('saldere',),
'sale': ('sale',),
'saler': ('sale',),
'sales': ('sale',),
'salet': ('sale',),
'salte': ('sale',),
'salet': ('sale',),
'salt': ('sale',),
'sal': ('sale',),
'salte': ('salte',),
'salter': ('salte',),
'saltes': ('salte',),
'salta': ('salte',),
'saltet': ('salte',),
'salta': ('salte',),
'saltet': ('salte',),
'salt': ('salte',),
'saluttere': ('saluttere',),
'salutterer': ('saluttere',),
'salutteres': ('saluttere',),
'salutterte': ('saluttere',),
'saluttert': ('saluttere',),
'salutter': ('saluttere',),
'salve': ('salve',),
'salver': ('salve',),
'salves': ('salve',),
'salva': ('salve',),
'salvet': ('salve',),
'salva': ('salve',),
'salvet': ('salve',),
'salv': ('salve',),
'samarbeide': ('samarbeide',),
'samarbeider': ('samarbeide',),
'samarbeides': ('samarbeide',),
'samarbeida': ('samarbeide',),
'samarbeidet': ('samarbeide',),
'samarbeidde': ('samarbeide',),
'samarbeida': ('samarbeide',),
'samarbeidet': ('samarbeide',),
'samarbeidd': ('samarbeide',),
'samarbeid': ('samarbeide',),
'sameksistere': ('sameksistere',),
'sameksisterer': ('sameksistere',),
'sameksisteres': ('sameksistere',),
'sameksisterte': ('sameksistere',),
'sameksistert': ('sameksistere',),
'sameksister': ('sameksistere',),
'samkjøre': ('samkjøre',),
'samkjører': ('samkjøre',),
'samkjøres': ('samkjøre',),
'samkjørte': ('samkjøre',),
'samkjørt': ('samkjøre',),
'samkjør': ('samkjøre',),
'samle': ('samle',),
'samler': ('samle',),
'samles': ('samle',),
'samla': ('samle',),
'samlet': ('samle',),
'samla': ('samle',),
'samlet': ('samle',),
'saml': ('samle',),
'samle': ('samle',),
'saml': ('samle',),
'samle': ('samle',),
'sammenfatte': ('sammenfatte',),
'sammenfatter': ('sammenfatte',),
'sammenfattes': ('sammenfatte',),
'sammenfatta': ('sammenfatte',),
'sammenfattet': ('sammenfatte',),
'sammenfatta': ('sammenfatte',),
'sammenfattet': ('sammenfatte',),
'sammenfatt': ('sammenfatte',),
'sammenholde': ('sammenholde',),
'sammenholder': ('sammenholde',),
'sammenholdes': ('sammenholde',),
'sammenholdt': ('sammenholde',),
'sammenhold': ('sammenholde',),
'sammenkalle': ('sammenkalle',),
'sammenkaller': ('sammenkalle',),
'sammenkalles': ('sammenkalle',),
'sammenkalte': ('sammenkalle',),
'sammenkalt': ('sammenkalle',),
'sammenkall': ('sammenkalle',),
'sammenligne': ('sammenligne',),
'sammenligner': ('sammenligne',),
'sammenlignes': ('sammenligne',),
'sammenligna': ('sammenligne',),
'sammenlignet': ('sammenligne',),
'sammenligna': ('sammenligne',),
'sammenlignet': ('sammenligne',),
'sammenlign': ('sammenligne',),
'sammenlikne': ('sammenlikne',),
'sammenlikner': ('sammenlikne',),
'sammenliknes': ('sammenlikne',),
'sammenlikna': ('sammenlikne',),
'sammenliknet': ('sammenlikne',),
'sammenlikna': ('sammenlikne',),
'sammenliknet': ('sammenlikne',),
'sammenlikn': ('sammenlikne',),
'sammenlikne': ('sammenlikne',),
'sammenlikn': ('sammenlikne',),
'sammenlikne': ('sammenlikne',),
'sammenstille': ('sammenstille',),
'sammenstiller': ('sammenstille',),
'sammenstilles': ('sammenstille',),
'sammenstilte': ('sammenstille',),
'sammenstilt': ('sammenstille',),
'sammenstill': ('sammenstille',),
'sammensverge': ('sammensverge',),
'sammensverger': ('sammensverge',),
'sammensverges': ('sammensverge',),
'sammensverga': ('sammensverge',),
'sammensverget': ('sammensverge',),
'sammensvor': ('sammensverge',),
'sammensverga': ('sammensverge',),
'sammensverget': ('sammensverge',),
'sammensvoret': ('sammensverge',),
'sammensverg': ('sammensverge',),
'samordne': ('samordne',),
'samordner': ('samordne',),
'samordnes': ('samordne',),
'samordna': ('samordne',),
'samordnet': ('samordne',),
'samordna': ('samordne',),
'samordnet': ('samordne',),
'samordn': ('samordne',),
'samordne': ('samordne',),
'samordn': ('samordne',),
'samordne': ('samordne',),
'sample': ('sample',),
'sampler': ('sample',),
'samples': ('sample',),
'sampla': ('sample',),
'samplet': ('sample',),
'sampla': ('sample',),
'samplet': ('sample',),
'sampl': ('sample',),
'sample': ('sample',),
'sampl': ('sample',),
'sample': ('sample',),
'samrå': ('samrå',),
'samrår': ('samrå',),
'samrås': ('samrå',),
'samrådde': ('samrå',),
'samrådd': ('samrå',),
'samrå': ('samrå',),
'samse': ('samse',),
'samser': ('samse',),
'samses': ('samse',),
'samsa': ('samse',),
'samset': ('samse',),
'samsa': ('samse',),
'samset': ('samse',),
'sams': ('samse',),
'samstave': ('samstave',),
'samstaver': ('samstave',),
'samstaves': ('samstave',),
'samstava': ('samstave',),
'samstavet': ('samstave',),
'samstava': ('samstave',),
'samstavet': ('samstave',),
'samstav': ('samstave',),
'samstemme': ('samstemme',),
'samstemmer': ('samstemme',),
'samstemmes': ('samstemme',),
'samstemte': ('samstemme',),
'samstemt': ('samstemme',),
'samstem': ('samstemme',),
'samtale': ('samtale',),
'samtaler': ('samtale',),
'samtales': ('samtale',),
'samtalte': ('samtale',),
'samtalt': ('samtale',),
'samtal': ('samtale',),
'samtykke': ('samtykke',),
'samtykker': ('samtykke',),
'samtykkes': ('samtykke',),
'samtykket': ('samtykke',),
'samtykte': ('samtykke',),
'samtykket': ('samtykke',),
'samtykt': ('samtykke',),
'samtykk': ('samtykke',),
'samvirke': ('samvirke',),
'samvirker': ('samvirke',),
'samvirkes': ('samvirke',),
'samvirka': ('samvirke',),
'samvirket': ('samvirke',),
'samvirka': ('samvirke',),
'samvirket': ('samvirke',),
'samvirk': ('samvirke',),
'sandblåse': ('sandblåse',),
'sandblåser': ('sandblåse',),
'sandblåses': ('sandblåse',),
'sandblåste': ('sandblåse',),
'sandblåst': ('sandblåse',),
'sandblås': ('sandblåse',),
'sanere': ('sanere',),
'sanerer': ('sanere',),
'saneres': ('sanere',),
'sanerte': ('sanere',),
'sanert': ('sanere',),
'saner': ('sanere',),
'sanforisere': ('sanforisere',),
'sanforiserer': ('sanforisere',),
'sanforiseres': ('sanforisere',),
'sanforiserte': ('sanforisere',),
'sanforisert': ('sanforisere',),
'sanforiser': ('sanforisere',),
'sangre': ('sangre',),
'sangrer': ('sangre',),
'sangres': ('sangre',),
'sangra': ('sangre',),
'sangret': ('sangre',),
'sangra': ('sangre',),
'sangret': ('sangre',),
'sangr': ('sangre',),
'sangre': ('sangre',),
'sangr': ('sangre',),
'sangre': ('sangre',),
'sanke': ('sanke',),
'sanker': ('sanke',),
'sankes': ('sanke',),
'sanka': ('sanke',),
'sanket': ('sanke',),
'sanka': ('sanke',),
'sanket': ('sanke',),
'sank': ('sanke',),
'sanksjonere': ('sanksjonere',),
'sanksjonerer': ('sanksjonere',),
'sanksjoneres': ('sanksjonere',),
'sanksjonerte': ('sanksjonere',),
'sanksjonert': ('sanksjonere',),
'sanksjoner': ('sanksjonere',),
'sanne': ('sanne',),
'sanner': ('sanne',),
'sannes': ('sanne',),
'sanna': ('sanne',),
'sannet': ('sanne',),
'sanna': ('sanne',),
'sannet': ('sanne',),
'sann': ('sanne',),
'sannsynliggjøre': ('sannsynliggjøre',),
'sannsynliggjør': ('sannsynliggjøre',),
'sannsynliggjøres': ('sannsynliggjøre',),
'sannsynliggjorde': ('sannsynliggjøre',),
'sannsynliggjort': ('sannsynliggjøre',),
'sannsynliggjør': ('sannsynliggjøre',),
'sanse': ('sanse',),
'sanser': ('sanse',),
'sanses': ('sanse',),
'sansa': ('sanse',),
'sanset': ('sanse',),
'sansa': ('sanse',),
'sanset': ('sanse',),
'sans': ('sanse',),
'satinere': ('satinere',),
'satinerer': ('satinere',),
'satineres': ('satinere',),
'satinerte': ('satinere',),
'satinert': ('satinere',),
'satiner': ('satinere',),
'satirisere': ('satirisere',),
'satiriserer': ('satirisere',),
'satiriseres': ('satirisere',),
'satiriserte': ('satirisere',),
'satirisert': ('satirisere',),
'satiriser': ('satirisere',),
'satisfisere': ('satisfisere',),
'satisfiserer': ('satisfisere',),
'satisfiseres': ('satisfisere',),
'satisfiserte': ('satisfisere',),
'satisfisert': ('satisfisere',),
'satisfiser': ('satisfisere',),
'satse': ('satse',),
'satser': ('satse',),
'satses': ('satse',),
'satsa': ('satse',),
'satset': ('satse',),
'satsa': ('satse',),
'satset': ('satse',),
'sats': ('satse',),
'saumfare': ('saumfare',),
'saumfarer': ('saumfare',),
'saumfares': ('saumfare',),
'saumfor': ('saumfare',),
'saumfart': ('saumfare',),
'saumfar': ('saumfare',),
'sause': ('sause',),
'sauser': ('sause',),
'sauses': ('sause',),
'sausa': ('sause',),
'sauset': ('sause',),
'sausa': ('sause',),
'sauset': ('sause',),
'saus': ('sause',),
'savle': ('savle',),
'savler': ('savle',),
'savles': ('savle',),
'savla': ('savle',),
'savlet': ('savle',),
'savla': ('savle',),
'savlet': ('savle',),
'savl': ('savle',),
'savle': ('savle',),
'savl': ('savle',),
'savle': ('savle',),
'savne': ('savne',),
'savner': ('savne',),
'savnes': ('savne',),
'savna': ('savne',),
'savnet': ('savne',),
'savna': ('savne',),
'savnet': ('savne',),
'savn': ('savne',),
'score': ('score',),
'scorer': ('score',),
'scores': ('score',),
'scora': ('score',),
'scoret': ('score',),
'scora': ('score',),
'scoret': ('score',),
'scor': ('score',),
'scripte': ('scripte',),
'scripter': ('scripte',),
'scriptes': ('scripte',),
'scripta': ('scripte',),
'scriptet': ('scripte',),
'scripta': ('scripte',),
'scriptet': ('scripte',),
'script': ('scripte',),
'se': ('se',),
'ser': ('se',),
'ses': ('se',),
'sees': ('se',),
'så': ('se',),
'sett': ('se',),
'se': ('se',),
'sedimentere': ('sedimentere',),
'sedimenterer': ('sedimentere',),
'sedimenteres': ('sedimentere',),
'sedimenterte': ('sedimentere',),
'sedimentert': ('sedimentere',),
'sedimenter': ('sedimentere',),
'seede': ('seede',),
'seeder': ('seede',),
'seedes': ('seede',),
'seeda': ('seede',),
'seedet': ('seede',),
'seeda': ('seede',),
'seedet': ('seede',),
'seed': ('seede',),
'sees': ('sees',),
'såes': ('sees',),
'settes': ('sees',),
'sees': ('sees',),
'segle': ('segle',),
'segler': ('segle',),
'segles': ('segle',),
'segla': ('segle',),
'seglet': ('segle',),
'segla': ('segle',),
'seglet': ('segle',),
'segl': ('segle',),
'segle': ('segle',),
'segl': ('segle',),
'segle': ('segle',),
'segmentere': ('segmentere',),
'segmenterer': ('segmentere',),
'segmenteres': ('segmentere',),
'segmenterte': ('segmentere',),
'segmentert': ('segmentere',),
'segmenter': ('segmentere',),
'segne': ('segne',),
'segner': ('segne',),
'segnes': ('segne',),
'segna': ('segne',),
'segnet': ('segne',),
'segna': ('segne',),
'segnet': ('segne',),
'segn': ('segne',),
'segregere': ('segregere',),
'segregerer': ('segregere',),
'segregeres': ('segregere',),
'segregerte': ('segregere',),
'segregert': ('segregere',),
'segreger': ('segregere',),
'seide': ('seide',),
'seider': ('seide',),
'seides': ('seide',),
'seida': ('seide',),
'seidet': ('seide',),
'seida': ('seide',),
'seidet': ('seide',),
'seid': ('seide',),
'seigpine': ('seigpine',),
'seigpiner': ('seigpine',),
'seigpines': ('seigpine',),
'seigpinte': ('seigpine',),
'seigpint': ('seigpine',),
'seigpin': ('seigpine',),
'seipe': ('seipe',),
'seiper': ('seipe',),
'seipes': ('seipe',),
'seipa': ('seipe',),
'seipet': ('seipe',),
'seipa': ('seipe',),
'seipet': ('seipe',),
'seip': ('seipe',),
'seire': ('seire',),
'seirer': ('seire',),
'seires': ('seire',),
'seira': ('seire',),
'seiret': ('seire',),
'seira': ('seire',),
'seiret': ('seire',),
'seir': ('seire',),
'seise': ('seise',),
'seiser': ('seise',),
'seises': ('seise',),
'seisa': ('seise',),
'seiset': ('seise',),
'seiste': ('seise',),
'seisa': ('seise',),
'seiset': ('seise',),
'seist': ('seise',),
'seis': ('seise',),
'seksdoble': ('seksdoble',),
'seksdobler': ('seksdoble',),
'seksdobles': ('seksdoble',),
'seksdobla': ('seksdoble',),
'seksdoblet': ('seksdoble',),
'seksdobla': ('seksdoble',),
'seksdoblet': ('seksdoble',),
'seksdobl': ('seksdoble',),
'seksdoble': ('seksdoble',),
'seksdobl': ('seksdoble',),
'seksdoble': ('seksdoble',),
'seksjonere': ('seksjonere',),
'seksjonerer': ('seksjonere',),
'seksjoneres': ('seksjonere',),
'seksjonerte': ('seksjonere',),
'seksjonert': ('seksjonere',),
'seksjoner': ('seksjonere',),
'sekularisere': ('sekularisere',),
'sekulariserer': ('sekularisere',),
'sekulariseres': ('sekularisere',),
'sekulariserte': ('sekularisere',),
'sekularisert': ('sekularisere',),
'sekulariser': ('sekularisere',),
'sekundere': ('sekundere',),
'sekunderer': ('sekundere',),
'sekunderes': ('sekundere',),
'sekunderte': ('sekundere',),
'sekundert': ('sekundere',),
'sekunder': ('sekundere',),
'sele': ('sele',),
'seler': ('sele',),
'seles': ('sele',),
'sela': ('sele',),
'selte': ('sele',),
'sela': ('sele',),
'selt': ('sele',),
'sel': ('sele',),
'selektere': ('selektere',),
'selekterer': ('selektere',),
'selekteres': ('selektere',),
'selekterte': ('selektere',),
'selektert': ('selektere',),
'selekter': ('selektere',),
'selge': ('selge',),
'selger': ('selge',),
'selges': ('selge',),
'solgte': ('selge',),
'solgt': ('selge',),
'selg': ('selge',),
'selvstendiggjøre': ('selvstendiggjøre',),
'selvstendiggjør': ('selvstendiggjøre',),
'selvstendiggjøres': ('selvstendiggjøre',),
'selvstendiggjorde': ('selvstendiggjøre',),
'selvstendiggjort': ('selvstendiggjøre',),
'selvstendiggjør': ('selvstendiggjøre',),
'semaforere': ('semaforere',),
'semaforerer': ('semaforere',),
'semaforeres': ('semaforere',),
'semaforerte': ('semaforere',),
'semaforert': ('semaforere',),
'semaforer': ('semaforere',),
'sementere': ('sementere',),
'sementerer': ('sementere',),
'sementeres': ('sementere',),
'sementerte': ('sementere',),
'sementert': ('sementere',),
'sementer': ('sementere',),
'seminere': ('seminere',),
'seminerer': ('seminere',),
'semineres': ('seminere',),
'seminerte': ('seminere',),
'seminert': ('seminere',),
'seminer': ('seminere',),
'semsgarve': ('semsgarve',),
'semsgarver': ('semsgarve',),
'semsgarves': ('semsgarve',),
'semsgarva': ('semsgarve',),
'semsgarvet': ('semsgarve',),
'semsgarva': ('semsgarve',),
'semsgarvet': ('semsgarve',),
'semsgarv': ('semsgarve',),
'semske': ('semske',),
'semsker': ('semske',),
'semskes': ('semske',),
'semska': ('semske',),
'semsket': ('semske',),
'semska': ('semske',),
'semsket': ('semske',),
'semsk': ('semske',),
'semskgarve': ('semskgarve',),
'semskgarver': ('semskgarve',),
'semskgarves': ('semskgarve',),
'semskgarva': ('semskgarve',),
'semskgarvet': ('semskgarve',),
'semskgarva': ('semskgarve',),
'semskgarvet': ('semskgarve',),
'semskgarv': ('semskgarve',),
'sende': ('sende',),
'sender': ('sende',),
'sendes': ('sende',),
'sendte': ('sende',),
'sendt': ('sende',),
'send': ('sende',),
'senke': ('senke',),
'senker': ('senke',),
'senkes': ('senke',),
'senka': ('senke',),
'senket': ('senke',),
'senka': ('senke',),
'senket': ('senke',),
'senk': ('senke',),
'sensurere': ('sensurere',),
'sensurerer': ('sensurere',),
'sensureres': ('sensurere',),
'sensurerte': ('sensurere',),
'sensurert': ('sensurere',),
'sensurer': ('sensurere',),
'sentimentalisere': ('sentimentalisere',),
'sentimentaliserer': ('sentimentalisere',),
'sentimentaliseres': ('sentimentalisere',),
'sentimentaliserte': ('sentimentalisere',),
'sentimentalisert': ('sentimentalisere',),
'sentimentaliser': ('sentimentalisere',),
'sentralisere': ('sentralisere',),
'sentraliserer': ('sentralisere',),
'sentraliseres': ('sentralisere',),
'sentraliserte': ('sentralisere',),
'sentralisert': ('sentralisere',),
'sentraliser': ('sentralisere',),
'sentre': ('sentre',),
'sentrer': ('sentre',),
'sentres': ('sentre',),
'sentra': ('sentre',),
'sentret': ('sentre',),
'sentra': ('sentre',),
'sentret': ('sentre',),
'sentr': ('sentre',),
'sentre': ('sentre',),
'sentr': ('sentre',),
'sentre': ('sentre',),
'sentrere': ('sentrere',),
'sentrerer': ('sentrere',),
'sentreres': ('sentrere',),
'sentrerte': ('sentrere',),
'sentrert': ('sentrere',),
'sentrer': ('sentrere',),
'sentrifugere': ('sentrifugere',),
'sentrifugerer': ('sentrifugere',),
'sentrifugeres': ('sentrifugere',),
'sentrifugerte': ('sentrifugere',),
'sentrifugert': ('sentrifugere',),
'sentrifuger': ('sentrifugere',),
'separere': ('separere',),
'separerer': ('separere',),
'separeres': ('separere',),
'separerte': ('separere',),
'separert': ('separere',),
'separer': ('separere',),
'serratere': ('serratere',),
'serraterer': ('serratere',),
'serrateres': ('serratere',),
'serraterte': ('serratere',),
'serratert': ('serratere',),
'serrater': ('serratere',),
'sertifisere': ('sertifisere',),
'sertifiserer': ('sertifisere',),
'sertifiseres': ('sertifisere',),
'sertifiserte': ('sertifisere',),
'sertifisert': ('sertifisere',),
'sertifiser': ('sertifisere',),
'serve': ('serve',),
'server': ('serve',),
'serves': ('serve',),
'serva': ('serve',),
'servet': ('serve',),
'serva': ('serve',),
'servet': ('serve',),
'serv': ('serve',),
'servere': ('servere',),
'serverer': ('servere',),
'serveres': ('servere',),
'serverte': ('servere',),
'servert': ('servere',),
'server': ('servere',),
'ses': ('ses',),
'sås': ('ses',),
'settes': ('ses',),
'ses': ('ses',),
'sesongdebutere': ('sesongdebutere',),
'sesongdebuterer': ('sesongdebutere',),
'sesongdebuteres': ('sesongdebutere',),
'sesongdebuterte': ('sesongdebutere',),
'sesongdebutert': ('sesongdebutere',),
'sesongdebuter': ('sesongdebutere',),
'sesse': ('sesse',),
'sesser': ('sesse',),
'sesses': ('sesse',),
'sessa': ('sesse',),
'sesset': ('sesse',),
'sessa': ('sesse',),
'sesset': ('sesse',),
'sess': ('sesse',),
'setre': ('setre',),
'setrer': ('setre',),
'setres': ('setre',),
'setra': ('setre',),
'setret': ('setre',),
'setra': ('setre',),
'setret': ('setre',),
'setr': ('setre',),
'setre': ('setre',),
'setr': ('setre',),
'setre': ('setre',),
'sette': ('sette',),
'setter': ('sette',),
'settes': ('sette',),
'satte': ('sette',),
'satt': ('sette',),
'sett': ('sette',),
'settle': ('settle',),
'settler': ('settle',),
'settles': ('settle',),
'settla': ('settle',),
'settlet': ('settle',),
'settla': ('settle',),
'settlet': ('settle',),
'settl': ('settle',),
'settle': ('settle',),
'settl': ('settle',),
'settle': ('settle',),
'sexdebutere': ('sexdebutere',),
'sexdebuterer': ('sexdebutere',),
'sexdebuteres': ('sexdebutere',),
'sexdebuterte': ('sexdebutere',),
'sexdebutert': ('sexdebutere',),
'sexdebuter': ('sexdebutere',),
'shake': ('shake',),
'shaker': ('shake',),
'shakes': ('shake',),
'shaka': ('shake',),
'shaket': ('shake',),
'shaka': ('shake',),
'shaket': ('shake',),
'shak': ('shake',),
'shoppe': ('shoppe',),
'shopper': ('shoppe',),
'shoppes': ('shoppe',),
'shoppa': ('shoppe',),
'shoppet': ('shoppe',),
'shoppa': ('shoppe',),
'shoppet': ('shoppe',),
'shopp': ('shoppe',),
'showe': ('showe',),
'shower': ('showe',),
'showes': ('showe',),
'showa': ('showe',),
'showet': ('showe',),
'showa': ('showe',),
'showet': ('showe',),
'show': ('showe',),
'shunte': ('shunte',),
'shunter': ('shunte',),
'shuntes': ('shunte',),
'shunta': ('shunte',),
'shuntet': ('shunte',),
'shunta': ('shunte',),
'shuntet': ('shunte',),
'shunt': ('shunte',),
'si': ('si',),
'sier': ('si',),
'sies': ('si',),
'sa': ('si',),
'sagt': ('si',),
'si': ('si',),
'sideordne': ('sideordne',),
'sideordner': ('sideordne',),
'sideordnes': ('sideordne',),
'sideordna': ('sideordne',),
'sideordnet': ('sideordne',),
'sideordna': ('sideordne',),
'sideordnet': ('sideordne',),
'sideordn': ('sideordne',),
'sideordne': ('sideordne',),
'sideordn': ('sideordne',),
'sideordne': ('sideordne',),
'sidestille': ('sidestille',),
'sidestiller': ('sidestille',),
'sidestilles': ('sidestille',),
'sidestilte': ('sidestille',),
'sidestilt': ('sidestille',),
'sidestill': ('sidestille',),
'sidrikke': ('sidrikke',),
'sidrikker': ('sidrikke',),
'sidrikkes': ('sidrikke',),
'sidrakk': ('sidrikke',),
'sidrukket': ('sidrikke',),
'sidrikk': ('sidrikke',),
'sifrere': ('sifrere',),
'sifrerer': ('sifrere',),
'sifreres': ('sifrere',),
'sifrerte': ('sifrere',),
'sifrert': ('sifrere',),
'sifrer': ('sifrere',),
'sige': ('sige',),
'siger': ('sige',),
'siges': ('sige',),
'seg': ('sige',),
'seig': ('sige',),
'seg': ('sige',),
'seig': ('sige',),
'seget': ('sige',),
'sig': ('sige',),
'signalere': ('signalere',),
'signalerer': ('signalere',),
'signaleres': ('signalere',),
'signalerte': ('signalere',),
'signalert': ('signalere',),
'signaler': ('signalere',),
'signalisere': ('signalisere',),
'signaliserer': ('signalisere',),
'signaliseres': ('signalisere',),
'signaliserte': ('signalisere',),
'signalisert': ('signalisere',),
'signaliser': ('signalisere',),
'signe': ('signe',),
'signer': ('signe',),
'signes': ('signe',),
'signa': ('signe',),
'signet': ('signe',),
'signa': ('signe',),
'signet': ('signe',),
'sign': ('signe',),
'signere': ('signere',),
'signerer': ('signere',),
'signeres': ('signere',),
'signerte': ('signere',),
'signert': ('signere',),
'signer': ('signere',),
'sike': ('sike',),
'siker': ('sike',),
'sikes': ('sike',),
'sika': ('sike',),
'siket': ('sike',),
'sika': ('sike',),
'siket': ('sike',),
'sik': ('sike',),
'sikkerhetsklarere': ('sikkerhetsklarere',),
'sikkerhetsklarerer': ('sikkerhetsklarere',),
'sikkerhetsklareres': ('sikkerhetsklarere',),
'sikkerhetsklarerte': ('sikkerhetsklarere',),
'sikkerhetsklarert': ('sikkerhetsklarere',),
'sikkerhetsklarer': ('sikkerhetsklarere',),
'sikksakke': ('sikksakke',),
'sikksakker': ('sikksakke',),
'sikksakkes': ('sikksakke',),
'sikksakka': ('sikksakke',),
'sikksakket': ('sikksakke',),
'sikksakka': ('sikksakke',),
'sikksakket': ('sikksakke',),
'sikksakk': ('sikksakke',),
'sikle': ('sikle',),
'sikler': ('sikle',),
'sikles': ('sikle',),
'sikla': ('sikle',),
'siklet': ('sikle',),
'sikla': ('sikle',),
'siklet': ('sikle',),
'sikl': ('sikle',),
'sikle': ('sikle',),
'sikl': ('sikle',),
'sikle': ('sikle',),
'sikre': ('sikre',),
'sikrer': ('sikre',),
'sikres': ('sikre',),
'sikra': ('sikre',),
'sikret': ('sikre',),
'sikra': ('sikre',),
'sikret': ('sikre',),
'sikr': ('sikre',),
'sikre': ('sikre',),
'sikr': ('sikre',),
'sikre': ('sikre',),
'sikte': ('sikte',),
'sikter': ('sikte',),
'siktes': ('sikte',),
'sikta': ('sikte',),
'siktet': ('sikte',),
'sikta': ('sikte',),
'siktet': ('sikte',),
'sikt': ('sikte',),
'silblø': ('silblø',),
'silblør': ('silblø',),
'silbløs': ('silblø',),
'silblødde': ('silblø',),
'silblødd': ('silblø',),
'silblø': ('silblø',),
'sildre': ('sildre',),
'sildrer': ('sildre',),
'sildres': ('sildre',),
'sildra': ('sildre',),
'sildret': ('sildre',),
'sildra': ('sildre',),
'sildret': ('sildre',),
'sildr': ('sildre',),
'sildre': ('sildre',),
'sildr': ('sildre',),
'sildre': ('sildre',),
'sile': ('sile',),
'siler': ('sile',),
'siles': ('sile',),
'silte': ('sile',),
'silt': ('sile',),
'sil': ('sile',),
'silregne': ('silregne',),
'silregner': ('silregne',),
'silregnes': ('silregne',),
'silregna': ('silregne',),
'silregnet': ('silregne',),
'silregnte': ('silregne',),
'silregna': ('silregne',),
'silregnet': ('silregne',),
'silregnt': ('silregne',),
'silregn': ('silregne',),
'silrenne': ('silrenne',),
'silrenner': ('silrenne',),
'silrennes': ('silrenne',),
'silrant': ('silrenne',),
'silrent': ('silrenne',),
'silrenn': ('silrenne',),
'simplifisere': ('simplifisere',),
'simplifiserer': ('simplifisere',),
'simplifiseres': ('simplifisere',),
'simplifiserte': ('simplifisere',),
'simplifisert': ('simplifisere',),
'simplifiser': ('simplifisere',),
'simulere': ('simulere',),
'simulerer': ('simulere',),
'simuleres': ('simulere',),
'simulerte': ('simulere',),
'simulert': ('simulere',),
'simuler': ('simulere',),
'sindre': ('sindre',),
'sindrer': ('sindre',),
'sindres': ('sindre',),
'sindra': ('sindre',),
'sindret': ('sindre',),
'sindra': ('sindre',),
'sindret': ('sindre',),
'sindr': ('sindre',),
'sindre': ('sindre',),
'sindr': ('sindre',),
'sindre': ('sindre',),
'sine': ('sine',),
'siner': ('sine',),
'sines': ('sine',),
'sina': ('sine',),
'sinet': ('sine',),
'sina': ('sine',),
'sinet': ('sine',),
'sin': ('sine',),
'single': ('single',),
'singler': ('single',),
'singles': ('single',),
'singla': ('single',),
'singlet': ('single',),
'singla': ('single',),
'singlet': ('single',),
'singl': ('single',),
'single': ('single',),
'singl': ('single',),
'single': ('single',),
'sinke': ('sinke',),
'sinker': ('sinke',),
'sinkes': ('sinke',),
'sinka': ('sinke',),
'sinket': ('sinke',),
'sinka': ('sinke',),
'sinket': ('sinke',),
'sink': ('sinke',),
'sintre': ('sintre',),
'sintrer': ('sintre',),
'sintres': ('sintre',),
'sintra': ('sintre',),
'sintret': ('sintre',),
'sintra': ('sintre',),
'sintret': ('sintre',),
'sintr': ('sintre',),
'sintre': ('sintre',),
'sintr': ('sintre',),
'sintre': ('sintre',),
'sipe': ('sipe',),
'siper': ('sipe',),
'sipes': ('sipe',),
'sipa': ('sipe',),
'sipet': ('sipe',),
'sipte': ('sipe',),
'sipa': ('sipe',),
'sipet': ('sipe',),
'sipt': ('sipe',),
'sip': ('sipe',),
'sippe': ('sippe',),
'sipper': ('sippe',),
'sippes': ('sippe',),
'sippa': ('sippe',),
'sippet': ('sippe',),
'sipte': ('sippe',),
'sippa': ('sippe',),
'sippet': ('sippe',),
'sipt': ('sippe',),
'sipp': ('sippe',),
'siregne': ('siregne',),
'siregner': ('siregne',),
'siregnes': ('siregne',),
'siregna': ('siregne',),
'siregnet': ('siregne',),
'siregnte': ('siregne',),
'siregna': ('siregne',),
'siregnet': ('siregne',),
'siregnt': ('siregne',),
'siregn': ('siregne',),
'sirkle': ('sirkle',),
'sirkler': ('sirkle',),
'sirkles': ('sirkle',),
'sirkla': ('sirkle',),
'sirklet': ('sirkle',),
'sirkla': ('sirkle',),
'sirklet': ('sirkle',),
'sirkl': ('sirkle',),
'sirkle': ('sirkle',),
'sirkl': ('sirkle',),
'sirkle': ('sirkle',),
'sirkulere': ('sirkulere',),
'sirkulerer': ('sirkulere',),
'sirkuleres': ('sirkulere',),
'sirkulerte': ('sirkulere',),
'sirkulert': ('sirkulere',),
'sirkuler': ('sirkulere',),
'siselere': ('siselere',),
'siselerer': ('siselere',),
'siseleres': ('siselere',),
'siselerte': ('siselere',),
'siselert': ('siselere',),
'siseler': ('siselere',),
'sisle': ('sisle',),
'sisler': ('sisle',),
'sisles': ('sisle',),
'sisla': ('sisle',),
'sislet': ('sisle',),
'sisla': ('sisle',),
'sislet': ('sisle',),
'sisl': ('sisle',),
'sisle': ('sisle',),
'sisl': ('sisle',),
'sisle': ('sisle',),
'sitere': ('sitere',),
'siterer': ('sitere',),
'siteres': ('sitere',),
'siterte': ('sitere',),
'sitert': ('sitere',),
'siter': ('sitere',),
'sitre': ('sitre',),
'sitrer': ('sitre',),
'sitres': ('sitre',),
'sitra': ('sitre',),
'sitret': ('sitre',),
'sitra': ('sitre',),
'sitret': ('sitre',),
'sitr': ('sitre',),
'sitre': ('sitre',),
'sitr': ('sitre',),
'sitre': ('sitre',),
'sitte': ('sitte',),
'sitter': ('sitte',),
'sittes': ('sitte',),
'satt': ('sitte',),
'sittet': ('sitte',),
'sitt': ('sitte',),
'sive': ('sive',),
'siver': ('sive',),
'sives': ('sive',),
'siva': ('sive',),
'sivet': ('sive',),
'siva': ('sive',),
'sivet': ('sive',),
'siv': ('sive',),
'sivilisere': ('sivilisere',),
'siviliserer': ('sivilisere',),
'siviliseres': ('sivilisere',),
'siviliserte': ('sivilisere',),
'sivilisert': ('sivilisere',),
'siviliser': ('sivilisere',),
'sjabbe': ('sjabbe',),
'sjabber': ('sjabbe',),
'sjabbes': ('sjabbe',),
'sjabba': ('sjabbe',),
'sjabbet': ('sjabbe',),
'sjabba': ('sjabbe',),
'sjabbet': ('sjabbe',),
'sjabb': ('sjabbe',),
'sjakle': ('sjakle',),
'sjakler': ('sjakle',),
'sjakles': ('sjakle',),
'sjakla': ('sjakle',),
'sjaklet': ('sjakle',),
'sjakla': ('sjakle',),
'sjaklet': ('sjakle',),
'sjakl': ('sjakle',),
'sjakle': ('sjakle',),
'sjakl': ('sjakle',),
'sjakle': ('sjakle',),
'sjakre': ('sjakre',),
'sjakrer': ('sjakre',),
'sjakres': ('sjakre',),
'sjakra': ('sjakre',),
'sjakret': ('sjakre',),
'sjakra': ('sjakre',),
'sjakret': ('sjakre',),
'sjakr': ('sjakre',),
'sjakre': ('sjakre',),
'sjakr': ('sjakre',),
'sjakre': ('sjakre',),
'sjalte': ('sjalte',),
'sjalter': ('sjalte',),
'sjaltes': ('sjalte',),
'sjalta': ('sjalte',),
'sjaltet': ('sjalte',),
'sjalta': ('sjalte',),
'sjaltet': ('sjalte',),
'sjalt': ('sjalte',),
'sjamponere': ('sjamponere',),
'sjamponerer': ('sjamponere',),
'sjamponeres': ('sjamponere',),
'sjamponerte': ('sjamponere',),
'sjamponert': ('sjamponere',),
'sjamponer': ('sjamponere',),
'sjanghaie': ('sjanghaie',),
'sjanghaier': ('sjanghaie',),
'sjanghaies': ('sjanghaie',),
'sjanghaia': ('sjanghaie',),
'sjanghaiet': ('sjanghaie',),
'sjanghaia': ('sjanghaie',),
'sjanghaiet': ('sjanghaie',),
'sjanghai': ('sjanghaie',),
'sjangle': ('sjangle',),
'sjangler': ('sjangle',),
'sjangles': ('sjangle',),
'sjangla': ('sjangle',),
'sjanglet': ('sjangle',),
'sjangla': ('sjangle',),
'sjanglet': ('sjangle',),
'sjangl': ('sjangle',),
'sjangle': ('sjangle',),
'sjangl': ('sjangle',),
'sjangle': ('sjangle',),
'sjarmantisere': ('sjarmantisere',),
'sjarmantiserer': ('sjarmantisere',),
'sjarmantiseres': ('sjarmantisere',),
'sjarmantiserte': ('sjarmantisere',),
'sjarmantisert': ('sjarmantisere',),
'sjarmantiser': ('sjarmantisere',),
'sjarmere': ('sjarmere',),
'sjarmerer': ('sjarmere',),
'sjarmeres': ('sjarmere',),
'sjarmerte': ('sjarmere',),
'sjarmert': ('sjarmere',),
'sjarmer': ('sjarmere',),
'sjaske': ('sjaske',),
'sjasker': ('sjaske',),
'sjaskes': ('sjaske',),
'sjaska': ('sjaske',),
'sjasket': ('sjaske',),
'sjaska': ('sjaske',),
'sjasket': ('sjaske',),
'sjask': ('sjaske',),
'sjattere': ('sjattere',),
'sjatterer': ('sjattere',),
'sjatteres': ('sjattere',),
'sjatterte': ('sjattere',),
'sjattert': ('sjattere',),
'sjatter': ('sjattere',),
'sjaue': ('sjaue',),
'sjauer': ('sjaue',),
'sjaues': ('sjaue',),
'sjaua': ('sjaue',),
'sjauet': ('sjaue',),
'sjaua': ('sjaue',),
'sjauet': ('sjaue',),
'sjau': ('sjaue',),
'sjefe': ('sjefe',),
'sjefer': ('sjefe',),
'sjefes': ('sjefe',),
'sjefa': ('sjefe',),
'sjefet': ('sjefe',),
'sjefa': ('sjefe',),
'sjefet': ('sjefe',),
'sjef': ('sjefe',),
'sjeide': ('sjeide',),
'sjeider': ('sjeide',),
'sjeides': ('sjeide',),
'sjeida': ('sjeide',),
'sjeidet': ('sjeide',),
'sjeida': ('sjeide',),
'sjeidet': ('sjeide',),
'sjeid': ('sjeide',),
'sjekke': ('sjekke',),
'sjekker': ('sjekke',),
'sjekkes': ('sjekke',),
'sjekka': ('sjekke',),
'sjekket': ('sjekke',),
'sjekka': ('sjekke',),
'sjekket': ('sjekke',),
'sjekk': ('sjekke',),
'sjenere': ('sjenere',),
'sjenerer': ('sjenere',),
'sjeneres': ('sjenere',),
'sjenerte': ('sjenere',),
'sjenert': ('sjenere',),
'sjener': ('sjenere',),
'sjevre': ('sjevre',),
'sjevrer': ('sjevre',),
'sjevres': ('sjevre',),
'sjevra': ('sjevre',),
'sjevret': ('sjevre',),
'sjevra': ('sjevre',),
'sjevret': ('sjevre',),
'sjevr': ('sjevre',),
'sjevre': ('sjevre',),
'sjevr': ('sjevre',),
'sjevre': ('sjevre',),
'sjikanere': ('sjikanere',),
'sjikanerer': ('sjikanere',),
'sjikaneres': ('sjikanere',),
'sjikanerte': ('sjikanere',),
'sjikanert': ('sjikanere',),
'sjikaner': ('sjikanere',),
'sjingle': ('sjingle',),
'sjingler': ('sjingle',),
'sjingles': ('sjingle',),
'sjingla': ('sjingle',),
'sjinglet': ('sjingle',),
'sjingla': ('sjingle',),
'sjinglet': ('sjingle',),
'sjingl': ('sjingle',),
'sjingle': ('sjingle',),
'sjingl': ('sjingle',),
'sjingle': ('sjingle',),
'sjofle': ('sjofle',),
'sjofler': ('sjofle',),
'sjofles': ('sjofle',),
'sjofla': ('sjofle',),
'sjoflet': ('sjofle',),
'sjofla': ('sjofle',),
'sjoflet': ('sjofle',),
'sjofl': ('sjofle',),
'sjofle': ('sjofle',),
'sjofl': ('sjofle',),
'sjofle': ('sjofle',),
'sjoge': ('sjoge',),
'sjoger': ('sjoge',),
'sjoges': ('sjoge',),
'sjoga': ('sjoge',),
'sjoget': ('sjoge',),
'sjoga': ('sjoge',),
'sjoget': ('sjoge',),
'sjog': ('sjoge',),
'sjogse': ('sjogse',),
'sjogser': ('sjogse',),
'sjogses': ('sjogse',),
'sjogsa': ('sjogse',),
'sjogset': ('sjogse',),
'sjogsa': ('sjogse',),
'sjogset': ('sjogse',),
'sjogs': ('sjogse',),
'sjokke': ('sjokke',),
'sjokker': ('sjokke',),
'sjokkes': ('sjokke',),
'sjokka': ('sjokke',),
'sjokket': ('sjokke',),
'sjokka': ('sjokke',),
'sjokket': ('sjokke',),
'sjokk': ('sjokke',),
'sjokkere': ('sjokkere',),
'sjokkerer': ('sjokkere',),
'sjokkeres': ('sjokkere',),
'sjokkerte': ('sjokkere',),
'sjokkert': ('sjokkere',),
'sjokker': ('sjokkere',),
'sjokkåpne': ('sjokkåpne',),
'sjokkåpner': ('sjokkåpne',),
'sjokkåpnes': ('sjokkåpne',),
'sjokkåpna': ('sjokkåpne',),
'sjokkåpnet': ('sjokkåpne',),
'sjokkåpna': ('sjokkåpne',),
'sjokkåpnet': ('sjokkåpne',),
'sjokkåpn': ('sjokkåpne',),
'sjokkåpne': ('sjokkåpne',),
'sjokkåpn': ('sjokkåpne',),
'sjokkåpne': ('sjokkåpne',),
'sjonglere': ('sjonglere',),
'sjonglerer': ('sjonglere',),
'sjongleres': ('sjonglere',),
'sjonglerte': ('sjonglere',),
'sjonglert': ('sjonglere',),
'sjongler': ('sjonglere',),
'sjudoble': ('sjudoble',),
'sjudobler': ('sjudoble',),
'sjudobles': ('sjudoble',),
'sjudobla': ('sjudoble',),
'sjudoblet': ('sjudoble',),
'sjudobla': ('sjudoble',),
'sjudoblet': ('sjudoble',),
'sjudobl': ('sjudoble',),
'sjudoble': ('sjudoble',),
'sjudobl': ('sjudoble',),
'sjudoble': ('sjudoble',),
'sjukemelde': ('sjukemelde',),
'sjukemelder': ('sjukemelde',),
'sjukemeldes': ('sjukemelde',),
'sjukemeldte': ('sjukemelde',),
'sjukemeldt': ('sjukemelde',),
'sjukemeld': ('sjukemelde',),
'sjukmelde': ('sjukmelde',),
'sjukmelder': ('sjukmelde',),
'sjukmeldes': ('sjukmelde',),
'sjukmeldte': ('sjukmelde',),
'sjukmeldt': ('sjukmelde',),
'sjukmeld': ('sjukmelde',),
'sjukne': ('sjukne',),
'sjukner': ('sjukne',),
'sjuknes': ('sjukne',),
'sjukna': ('sjukne',),
'sjuknet': ('sjukne',),
'sjukna': ('sjukne',),
'sjuknet': ('sjukne',),
'sjukn': ('sjukne',),
'sjukne': ('sjukne',),
'sjukn': ('sjukne',),
'sjukne': ('sjukne',),
'sjuske': ('sjuske',),
'sjusker': ('sjuske',),
'sjuskes': ('sjuske',),
'sjuska': ('sjuske',),
'sjusket': ('sjuske',),
'sjuska': ('sjuske',),
'sjusket': ('sjuske',),
'sjusk': ('sjuske',),
'sjølstendiggjøre': ('sjølstendiggjøre',),
'sjølstendiggjør': ('sjølstendiggjøre',),
'sjølstendiggjøres': ('sjølstendiggjøre',),
'sjølstendiggjorde': ('sjølstendiggjøre',),
'sjølstendiggjort': ('sjølstendiggjøre',),
'sjølstendiggjør': ('sjølstendiggjøre',),
'sjøsette': ('sjøsette',),
'sjøsetter': ('sjøsette',),
'sjøsettes': ('sjøsette',),
'sjøsatte': ('sjøsette',),
'sjøsatt': ('sjøsette',),
'sjøsett': ('sjøsette',),
'skade': ('skade',),
'skader': ('skade',),
'skades': ('skade',),
'skada': ('skade',),
'skadet': ('skade',),
'skadde': ('skade',),
'skada': ('skade',),
'skadet': ('skade',),
'skadd': ('skade',),
'skad': ('skade',),
'skadeskyte': ('skadeskyte',),
'skadeskyter': ('skadeskyte',),
'skadeskytes': ('skadeskyte',),
'skadeskjøt': ('skadeskyte',),
'skadeskøyt': ('skadeskyte',),
'skadeskutt': ('skadeskyte',),
'skadeskyt': ('skadeskyte',),
'skaffe': ('skaffe',),
'skaffer': ('skaffe',),
'skaffes': ('skaffe',),
'skaffa': ('skaffe',),
'skaffet': ('skaffe',),
'skaffa': ('skaffe',),
'skaffet': ('skaffe',),
'skaff': ('skaffe',),
'skafte': ('skafte',),
'skafter': ('skafte',),
'skaftes': ('skafte',),
'skafta': ('skafte',),
'skaftet': ('skafte',),
'skafta': ('skafte',),
'skaftet': ('skafte',),
'skaft': ('skafte',),
'skake': ('skake',),
'skaker': ('skake',),
'skakes': ('skake',),
'skaka': ('skake',),
'skaket': ('skake',),
'skaka': ('skake',),
'skaket': ('skake',),
'skak': ('skake',),
'skakke': ('skakke',),
'skakker': ('skakke',),
'skakkes': ('skakke',),
'skakka': ('skakke',),
'skakket': ('skakke',),
'skakka': ('skakke',),
'skakket': ('skakke',),
'skakk': ('skakke',),
'skalere': ('skalere',),
'skalerer': ('skalere',),
'skaleres': ('skalere',),
'skalerte': ('skalere',),
'skalert': ('skalere',),
'skaler': ('skalere',),
'skalke': ('skalke',),
'skalker': ('skalke',),
'skalkes': ('skalke',),
'skalka': ('skalke',),
'skalket': ('skalke',),
'skalka': ('skalke',),
'skalket': ('skalke',),
'skalk': ('skalke',),
'skalle': ('skalle',),
'skaller': ('skalle',),
'skalles': ('skalle',),
'skalla': ('skalle',),
'skallet': ('skalle',),
'skalla': ('skalle',),
'skallet': ('skalle',),
'skall': ('skalle',),
'skalpere': ('skalpere',),
'skalperer': ('skalpere',),
'skalperes': ('skalpere',),
'skalperte': ('skalpere',),
'skalpert': ('skalpere',),
'skalper': ('skalpere',),
'skalte': ('skalte',),
'skalter': ('skalte',),
'skaltes': ('skalte',),
'skalta': ('skalte',),
'skaltet': ('skalte',),
'skalta': ('skalte',),
'skaltet': ('skalte',),
'skalt': ('skalte',),
'skamfere': ('skamfere',),
'skamferer': ('skamfere',),
'skamferes': ('skamfere',),
'skamferte': ('skamfere',),
'skamfert': ('skamfere',),
'skamfer': ('skamfere',),
'skamfryse': ('skamfryse',),
'skamfryser': ('skamfryse',),
'skamfryses': ('skamfryse',),
'skamfrøs': ('skamfryse',),
'skamfrøys': ('skamfryse',),
'skamfrosset': ('skamfryse',),
'skamfrys': ('skamfryse',),
'skamhogge': ('skamhogge',),
'skamhogger': ('skamhogge',),
'skamhogges': ('skamhogge',),
'skamhogde': ('skamhogge',),
'skamhogg': ('skamhogge',),
'skamhogd': ('skamhogge',),
'skamhogg': ('skamhogge',),
'skamhugge': ('skamhugge',),
'skamhugger': ('skamhugge',),
'skamhugges': ('skamhugge',),
'skamhugget': ('skamhugge',),
'skamhugde': ('skamhugge',),
'skamhugg': ('skamhugge',),
'skamhugget': ('skamhugge',),
'skamhugd': ('skamhugge',),
'skamhugg': ('skamhugge',),
'skamkjøre': ('skamkjøre',),
'skamkjører': ('skamkjøre',),
'skamkjøres': ('skamkjøre',),
'skamkjørte': ('skamkjøre',),
'skamkjørt': ('skamkjøre',),
'skamkjør': ('skamkjøre',),
'skamklippe': ('skamklippe',),
'skamklipper': ('skamklippe',),
'skamklippes': ('skamklippe',),
'skamklippa': ('skamklippe',),
'skamklippet': ('skamklippe',),
'skamklipte': ('skamklippe',),
'skamklippa': ('skamklippe',),
'skamklippet': ('skamklippe',),
'skamklipt': ('skamklippe',),
'skamklipp': ('skamklippe',),
'skamme': ('skamme',),
'skammer': ('skamme',),
'skammes': ('skamme',),
'skamma': ('skamme',),
'skammet': ('skamme',),
'skamma': ('skamme',),
'skammet': ('skamme',),
'skam': ('skamme',),
'skamrose': ('skamrose',),
'skamroser': ('skamrose',),
'skamroses': ('skamrose',),
'skamroste': ('skamrose',),
'skamrost': ('skamrose',),
'skamros': ('skamrose',),
'skandalisere': ('skandalisere',),
'skandaliserer': ('skandalisere',),
'skandaliseres': ('skandalisere',),
'skandaliserte': ('skandalisere',),
'skandalisert': ('skandalisere',),
'skandaliser': ('skandalisere',),
'skandere': ('skandere',),
'skanderer': ('skandere',),
'skanderes': ('skandere',),
'skanderte': ('skandere',),
'skandert': ('skandere',),
'skander': ('skandere',),
'skanne': ('skanne',),
'skanner': ('skanne',),
'skannes': ('skanne',),
'skanna': ('skanne',),
'skannet': ('skanne',),
'skanna': ('skanne',),
'skannet': ('skanne',),
'skann': ('skanne',),
'skante': ('skante',),
'skanter': ('skante',),
'skantes': ('skante',),
'skanta': ('skante',),
'skantet': ('skante',),
'skanta': ('skante',),
'skantet': ('skante',),
'skant': ('skante',),
'skape': ('skape',),
'skaper': ('skape',),
'skapes': ('skape',),
'skapte': ('skape',),
'skapt': ('skape',),
'skap': ('skape',),
'skare': ('skare',),
'skarer': ('skare',),
'skares': ('skare',),
'skara': ('skare',),
'skaret': ('skare',),
'skara': ('skare',),
'skaret': ('skare',),
'skar': ('skare',),
'skarifisere': ('skarifisere',),
'skarifiserer': ('skarifisere',),
'skarifiseres': ('skarifisere',),
'skarifiserte': ('skarifisere',),
'skarifisert': ('skarifisere',),
'skarifiser': ('skarifisere',),
'skarre': ('skarre',),
'skarrer': ('skarre',),
'skarres': ('skarre',),
'skarra': ('skarre',),
'skarret': ('skarre',),
'skarra': ('skarre',),
'skarret': ('skarre',),
'skarr': ('skarre',),
'skarve': ('skarve',),
'skarver': ('skarve',),
'skarves': ('skarve',),
'skarva': ('skarve',),
'skarvet': ('skarve',),
'skarva': ('skarve',),
'skarvet': ('skarve',),
'skarv': ('skarve',),
'skate': ('skate',),
'skater': ('skate',),
'skates': ('skate',),
'skata': ('skate',),
'skatet': ('skate',),
'skata': ('skate',),
'skatet': ('skate',),
'skat': ('skate',),
'skatte': ('skatte',),
'skatter': ('skatte',),
'skattes': ('skatte',),
'skatta': ('skatte',),
'skattet': ('skatte',),
'skatta': ('skatte',),
'skattet': ('skatte',),
'skatt': ('skatte',),
'skattlegge': ('skattlegge',),
'skattlegger': ('skattlegge',),
'skattlegges': ('skattlegge',),
'skattla': ('skattlegge',),
'skattlagt': ('skattlegge',),
'skattlegg': ('skattlegge',),
'skave': ('skave',),
'skaver': ('skave',),
'skaves': ('skave',),
'skava': ('skave',),
'skavet': ('skave',),
'skava': ('skave',),
'skavet': ('skave',),
'skav': ('skave',),
'skavle': ('skavle',),
'skavler': ('skavle',),
'skavles': ('skavle',),
'skavla': ('skavle',),
'skavlet': ('skavle',),
'skavla': ('skavle',),
'skavlet': ('skavle',),
'skavl': ('skavle',),
'skavle': ('skavle',),
'skavl': ('skavle',),
'skavle': ('skavle',),
'skeie': ('skeie',),
'skeier': ('skeie',),
'skeies': ('skeie',),
'skeia': ('skeie',),
'skeiet': ('skeie',),
'skeide': ('skeie',),
'skeia': ('skeie',),
'skeiet': ('skeie',),
'skeid': ('skeie',),
'skei': ('skeie',),
'skeine': ('skeine',),
'skeiner': ('skeine',),
'skeines': ('skeine',),
'skeinte': ('skeine',),
'skeint': ('skeine',),
'skein': ('skeine',),
'skeise': ('skeise',),
'skeiser': ('skeise',),
'skeises': ('skeise',),
'skeisa': ('skeise',),
'skeiset': ('skeise',),
'skeiste': ('skeise',),
'skeisa': ('skeise',),
'skeiset': ('skeise',),
'skeist': ('skeise',),
'skeis': ('skeise',),
'skeive': ('skeive',),
'skeiver': ('skeive',),
'skeives': ('skeive',),
'skeiva': ('skeive',),
'skeivet': ('skeive',),
'skeiva': ('skeive',),
'skeivet': ('skeive',),
'skeiv': ('skeive',),
'skeivle': ('skeivle',),
'skeivler': ('skeivle',),
'skeivles': ('skeivle',),
'skeivla': ('skeivle',),
'skeivlet': ('skeivle',),
'skeivla': ('skeivle',),
'skeivlet': ('skeivle',),
'skeivl': ('skeivle',),
'skeivle': ('skeivle',),
'skeivl': ('skeivle',),
'skeivle': ('skeivle',),
'skifte': ('skifte',),
'skifter': ('skifte',),
'skiftes': ('skifte',),
'skifta': ('skifte',),
'skiftet': ('skifte',),
'skifta': ('skifte',),
'skiftet': ('skifte',),
'skift': ('skifte',),
'skikke': ('skikke',),
'skikker': ('skikke',),
'skikkes': ('skikke',),
'skikka': ('skikke',),
'skikket': ('skikke',),
'skikka': ('skikke',),
'skikket': ('skikke',),
'skikk': ('skikke',),
'skildre': ('skildre',),
'skildrer': ('skildre',),
'skildres': ('skildre',),
'skildra': ('skildre',),
'skildret': ('skildre',),
'skildra': ('skildre',),
'skildret': ('skildre',),
'skildr': ('skildre',),
'skildre': ('skildre',),
'skildr': ('skildre',),
'skildre': ('skildre',),
'skille': ('skille',),
'skiller': ('skille',),
'skilles': ('skille',),
'skilte': ('skille',),
'skilt': ('skille',),
'skill': ('skille',),
'skillinge': ('skillinge',),
'skillinger': ('skillinge',),
'skillinges': ('skillinge',),
'skillinga': ('skillinge',),
'skillinget': ('skillinge',),
'skillinga': ('skillinge',),
'skillinget': ('skillinge',),
'skilling': ('skillinge',),
'skilte': ('skilte',),
'skilter': ('skilte',),
'skiltes': ('skilte',),
'skilta': ('skilte',),
'skiltet': ('skilte',),
'skilta': ('skilte',),
'skiltet': ('skilte',),
'skilt': ('skilte',),
'skimle': ('skimle',),
'skimler': ('skimle',),
'skimles': ('skimle',),
'skimla': ('skimle',),
'skimlet': ('skimle',),
'skimla': ('skimle',),
'skimlet': ('skimle',),
'skiml': ('skimle',),
'skimle': ('skimle',),
'skiml': ('skimle',),
'skimle': ('skimle',),
'skimre': ('skimre',),
'skimrer': ('skimre',),
'skimres': ('skimre',),
'skimra': ('skimre',),
'skimret': ('skimre',),
'skimra': ('skimre',),
'skimret': ('skimre',),
'skimr': ('skimre',),
'skimre': ('skimre',),
'skimr': ('skimre',),
'skimre': ('skimre',),
'skimte': ('skimte',),
'skimter': ('skimte',),
'skimtes': ('skimte',),
'skimta': ('skimte',),
'skimtet': ('skimte',),
'skimta': ('skimte',),
'skimtet': ('skimte',),
'skimt': ('skimte',),
'skingre': ('skingre',),
'skingrer': ('skingre',),
'skingres': ('skingre',),
'skingra': ('skingre',),
'skingret': ('skingre',),
'skingra': ('skingre',),
'skingret': ('skingre',),
'skingr': ('skingre',),
'skingre': ('skingre',),
'skingr': ('skingre',),
'skingre': ('skingre',),
'skinne': ('skinne',),
'skinner': ('skinne',),
'skinnes': ('skinne',),
'skinte': ('skinne',),
'skein': ('skinne',),
'skint': ('skinne',),
'skinn': ('skinne',),
'skipe': ('skipe',),
'skiper': ('skipe',),
'skipes': ('skipe',),
'skipa': ('skipe',),
'skipet': ('skipe',),
'skipa': ('skipe',),
'skipet': ('skipe',),
'skip': ('skipe',),
'skiple': ('skiple',),
'skipler': ('skiple',),
'skiples': ('skiple',),
'skipla': ('skiple',),
'skiplet': ('skiple',),
'skipla': ('skiple',),
'skiplet': ('skiple',),
'skipl': ('skiple',),
'skiple': ('skiple',),
'skipl': ('skiple',),
'skiple': ('skiple',),
'skissere': ('skissere',),
'skisserer': ('skissere',),
'skisseres': ('skissere',),
'skisserte': ('skissere',),
'skissert': ('skissere',),
'skisser': ('skissere',),
'skite': ('skite',),
'skiter': ('skite',),
'skites': ('skite',),
'skjet': ('skite',),
'skeit': ('skite',),
'skitt': ('skite',),
'skit': ('skite',),
'skitne': ('skitne',),
'skitner': ('skitne',),
'skitnes': ('skitne',),
'skitna': ('skitne',),
'skitnet': ('skitne',),
'skitna': ('skitne',),
'skitnet': ('skitne',),
'skitn': ('skitne',),
'skitne': ('skitne',),
'skitn': ('skitne',),
'skitne': ('skitne',),
'skive': ('skive',),
'skiver': ('skive',),
'skives': ('skive',),
'skiva': ('skive',),
'skivet': ('skive',),
'skiva': ('skive',),
'skivet': ('skive',),
'skiv': ('skive',),
'skje': ('skje',),
'skjer': ('skje',),
'skjes': ('skje',),
'skjedde': ('skje',),
'skjedd': ('skje',),
'skje': ('skje',),
'skjefte': ('skjefte',),
'skjefter': ('skjefte',),
'skjeftes': ('skjefte',),
'skjefta': ('skjefte',),
'skjeftet': ('skjefte',),
'skjefta': ('skjefte',),
'skjeftet': ('skjefte',),
'skjeft': ('skjefte',),
'skjele': ('skjele',),
'skjeler': ('skjele',),
'skjeles': ('skjele',),
'skjelte': ('skjele',),
'skjelt': ('skjele',),
'skjel': ('skjele',),
'skjelettere': ('skjelettere',),
'skjeletterer': ('skjelettere',),
'skjeletteres': ('skjelettere',),
'skjeletterte': ('skjelettere',),
'skjelettert': ('skjelettere',),
'skjeletter': ('skjelettere',),
'skjelle': ('skjelle',),
'skjeller': ('skjelle',),
'skjelles': ('skjelle',),
'skjelte': ('skjelle',),
'skjelt': ('skjelle',),
'skjell': ('skjelle',),
'skjelme': ('skjelme',),
'skjelmer': ('skjelme',),
'skjelmes': ('skjelme',),
'skjelma': ('skjelme',),
'skjelmet': ('skjelme',),
'skjelma': ('skjelme',),
'skjelmet': ('skjelme',),
'skjelm': ('skjelme',),
'skjelne': ('skjelne',),
'skjelner': ('skjelne',),
'skjelnes': ('skjelne',),
'skjelna': ('skjelne',),
'skjelnet': ('skjelne',),
'skjelna': ('skjelne',),
'skjelnet': ('skjelne',),
'skjeln': ('skjelne',),
'skjelne': ('skjelne',),
'skjeln': ('skjelne',),
'skjelne': ('skjelne',),
'skjelve': ('skjelve',),
'skjelver': ('skjelve',),
'skjelves': ('skjelve',),
'skalv': ('skjelve',),
'skjelvet': ('skjelve',),
'skjelv': ('skjelve',),
'skjematisere': ('skjematisere',),
'skjematiserer': ('skjematisere',),
'skjematiseres': ('skjematisere',),
'skjematiserte': ('skjematisere',),
'skjematisert': ('skjematisere',),
'skjematiser': ('skjematisere',),
'skjemme': ('skjemme',),
'skjemmer': ('skjemme',),
'skjemmes': ('skjemme',),
'skjemte': ('skjemme',),
'skjemt': ('skjemme',),
'skjem': ('skjemme',),
'skjemmes': ('skjemmes',),
'skjems': ('skjemmes',),
'skjemtes': ('skjemmes',),
'skjemmes': ('skjemmes',),
'skjemte': ('skjemte',),
'skjemter': ('skjemte',),
'skjemtes': ('skjemte',),
'skjemta': ('skjemte',),
'skjemtet': ('skjemte',),
'skjemta': ('skjemte',),
'skjemtet': ('skjemte',),
'skjemt': ('skjemte',),
'skjende': ('skjende',),
'skjender': ('skjende',),
'skjendes': ('skjende',),
'skjenda': ('skjende',),
'skjendet': ('skjende',),
'skjenda': ('skjende',),
'skjendet': ('skjende',),
'skjend': ('skjende',),
'skjene': ('skjene',),
'skjener': ('skjene',),
'skjenes': ('skjene',),
'skjena': ('skjene',),
'skjenet': ('skjene',),
'skjente': ('skjene',),
'skjena': ('skjene',),
'skjenet': ('skjene',),
'skjent': ('skjene',),
'skjen': ('skjene',),
'skjenke': ('skjenke',),
'skjenker': ('skjenke',),
'skjenkes': ('skjenke',),
'skjenka': ('skjenke',),
'skjenket': ('skjenke',),
'skjenkte': ('skjenke',),
'skjenka': ('skjenke',),
'skjenket': ('skjenke',),
'skjenkt': ('skjenke',),
'skjenk': ('skjenke',),
'skjenne': ('skjenne',),
'skjenner': ('skjenne',),
'skjennes': ('skjenne',),
'skjente': ('skjenne',),
'skjent': ('skjenne',),
'skjenn': ('skjenne',),
'skjerme': ('skjerme',),
'skjermer': ('skjerme',),
'skjermes': ('skjerme',),
'skjerma': ('skjerme',),
'skjermet': ('skjerme',),
'skjerma': ('skjerme',),
'skjermet': ('skjerme',),
'skjerm': ('skjerme',),
'skjerpe': ('skjerpe',),
'skjerper': ('skjerpe',),
'skjerpes': ('skjerpe',),
'skjerpa': ('skjerpe',),
'skjerpet': ('skjerpe',),
'skjerpa': ('skjerpe',),
'skjerpet': ('skjerpe',),
'skjerp': ('skjerpe',),
'skjolde': ('skjolde',),
'skjolder': ('skjolde',),
'skjoldes': ('skjolde',),
'skjolda': ('skjolde',),
'skjoldet': ('skjolde',),
'skjolda': ('skjolde',),
'skjoldet': ('skjolde',),
'skjold': ('skjolde',),
'skjule': ('skjule',),
'skjuler': ('skjule',),
'skjules': ('skjule',),
'skjulte': ('skjule',),
'skjult': ('skjule',),
'skjul': ('skjule',),
'skjære': ('skjære',),
'skjærer': ('skjære',),
'skjæres': ('skjære',),
'skar': ('skjære',),
'skåret': ('skjære',),
'skjær': ('skjære',),
'skjærne': ('skjærne',),
'skjærner': ('skjærne',),
'skjærnes': ('skjærne',),
'skjærna': ('skjærne',),
'skjærnet': ('skjærne',),
'skjærna': ('skjærne',),
'skjærnet': ('skjærne',),
'skjærn': ('skjærne',),
'skjønne': ('skjønne',),
'skjønner': ('skjønne',),
'skjønnes': ('skjønne',),
'skjønte': ('skjønne',),
'skjønt': ('skjønne',),
'skjønn': ('skjønne',),
'skjønnmale': ('skjønnmale',),
'skjønnmaler': ('skjønnmale',),
'skjønnmales': ('skjønnmale',),
'skjønnmalte': ('skjønnmale',),
'skjønnmalt': ('skjønnmale',),
'skjønnmal': ('skjønnmale',),
'skjønnsligne': ('skjønnsligne',),
'skjønnsligner': ('skjønnsligne',),
'skjønnslignes': ('skjønnsligne',),
'skjønnsligna': ('skjønnsligne',),
'skjønnslignet': ('skjønnsligne',),
'skjønnsligna': ('skjønnsligne',),
'skjønnslignet': ('skjønnsligne',),
'skjønnslign': ('skjønnsligne',),
'skjønnslikne': ('skjønnslikne',),
'skjønnslikner': ('skjønnslikne',),
'skjønnsliknes': ('skjønnslikne',),
'skjønnslikna': ('skjønnslikne',),
'skjønnsliknet': ('skjønnslikne',),
'skjønnslikna': ('skjønnslikne',),
'skjønnsliknet': ('skjønnslikne',),
'skjønnslikn': ('skjønnslikne',),
'skjønnslikne': ('skjønnslikne',),
'skjønnslikn': ('skjønnslikne',),
'skjønnslikne': ('skjønnslikne',),
'skjørne': ('skjørne',),
'skjørner': ('skjørne',),
'skjørnes': ('skjørne',),
'skjørna': ('skjørne',),
'skjørnet': ('skjørne',),
'skjørna': ('skjørne',),
'skjørnet': ('skjørne',),
'skjørn': ('skjørne',),
'skjørte': ('skjørte',),
'skjørter': ('skjørte',),
'skjørtes': ('skjørte',),
'skjørta': ('skjørte',),
'skjørtet': ('skjørte',),
'skjørta': ('skjørte',),
'skjørtet': ('skjørte',),
'skjørt': ('skjørte',),
'skjøte': ('skjøte',),
'skjøter': ('skjøte',),
'skjøtes': ('skjøte',),
'skjøtte': ('skjøte',),
'skjøtt': ('skjøte',),
'skjøt': ('skjøte',),
'skjøte': ('skjøte',),
'skjøter': ('skjøte',),
'skjøtes': ('skjøte',),
'skjøta': ('skjøte',),
'skjøtet': ('skjøte',),
'skjøtte': ('skjøte',),
'skjøta': ('skjøte',),
'skjøtet': ('skjøte',),
'skjøtt': ('skjøte',),
'skjøt': ('skjøte',),
'skjøtte': ('skjøtte',),
'skjøtter': ('skjøtte',),
'skjøttes': ('skjøtte',),
'skjøtta': ('skjøtte',),
'skjøttet': ('skjøtte',),
'skjøtta': ('skjøtte',),
'skjøttet': ('skjøtte',),
'skjøtt': ('skjøtte',),
'skli': ('skli',),
'sklir': ('skli',),
'sklis': ('skli',),
'sklidde': ('skli',),
'sklei': ('skli',),
'skled': ('skli',),
'sklidd': ('skli',),
'skli': ('skli',),
'sko': ('sko',),
'skor': ('sko',),
'skos': ('sko',),
'skodde': ('sko',),
'skodd': ('sko',),
'sko': ('sko',),
'skofte': ('skofte',),
'skofter': ('skofte',),
'skoftes': ('skofte',),
'skofta': ('skofte',),
'skoftet': ('skofte',),
'skofta': ('skofte',),
'skoftet': ('skofte',),
'skoft': ('skofte',),
'skogre': ('skogre',),
'skogrer': ('skogre',),
'skogres': ('skogre',),
'skogra': ('skogre',),
'skogret': ('skogre',),
'skogra': ('skogre',),
'skogret': ('skogre',),
'skogr': ('skogre',),
'skogre': ('skogre',),
'skogr': ('skogre',),
'skogre': ('skogre',),
'skole': ('skole',),
'skoler': ('skole',),
'skoles': ('skole',),
'skolte': ('skole',),
'skolt': ('skole',),
'skol': ('skole',),
'skolere': ('skolere',),
'skolerer': ('skolere',),
'skoleres': ('skolere',),
'skolerte': ('skolere',),
'skolert': ('skolere',),
'skoler': ('skolere',),
'skolme': ('skolme',),
'skolmer': ('skolme',),
'skolmes': ('skolme',),
'skolma': ('skolme',),
'skolmet': ('skolme',),
'skolma': ('skolme',),
'skolmet': ('skolme',),
'skolm': ('skolme',),
'skorde': ('skorde',),
'skorder': ('skorde',),
'skordes': ('skorde',),
'skorda': ('skorde',),
'skordet': ('skorde',),
'skorda': ('skorde',),
'skordet': ('skorde',),
'skord': ('skorde',),
'skorpe': ('skorpe',),
'skorper': ('skorpe',),
'skorpes': ('skorpe',),
'skorpa': ('skorpe',),
'skorpet': ('skorpe',),
'skorpa': ('skorpe',),
'skorpet': ('skorpe',),
'skorp': ('skorpe',),
'skorte': ('skorte',),
'skorter': ('skorte',),
'skortes': ('skorte',),
'skorta': ('skorte',),
'skortet': ('skorte',),
'skorta': ('skorte',),
'skortet': ('skorte',),
'skort': ('skorte',),
'skose': ('skose',),
'skoser': ('skose',),
'skoses': ('skose',),
'skosa': ('skose',),
'skoset': ('skose',),
'skoste': ('skose',),
'skosa': ('skose',),
'skoset': ('skose',),
'skost': ('skose',),
'skos': ('skose',),
'skotte': ('skotte',),
'skotter': ('skotte',),
'skottes': ('skotte',),
'skotta': ('skotte',),
'skottet': ('skotte',),
'skotta': ('skotte',),
'skottet': ('skotte',),
'skott': ('skotte',),
'skove': ('skove',),
'skover': ('skove',),
'skoves': ('skove',),
'skova': ('skove',),
'skovet': ('skove',),
'skova': ('skove',),
'skovet': ('skove',),
'skov': ('skove',),
'skovle': ('skovle',),
'skovler': ('skovle',),
'skovles': ('skovle',),
'skovla': ('skovle',),
'skovlet': ('skovle',),
'skovla': ('skovle',),
'skovlet': ('skovle',),
'skovl': ('skovle',),
'skovle': ('skovle',),
'skovl': ('skovle',),
'skovle': ('skovle',),
'skrakle': ('skrakle',),
'skrakler': ('skrakle',),
'skrakles': ('skrakle',),
'skrakla': ('skrakle',),
'skraklet': ('skrakle',),
'skrakla': ('skrakle',),
'skraklet': ('skrakle',),
'skrakl': ('skrakle',),
'skrakle': ('skrakle',),
'skrakl': ('skrakle',),
'skrakle': ('skrakle',),
'skralle': ('skralle',),
'skraller': ('skralle',),
'skralles': ('skralle',),
'skralla': ('skralle',),
'skrallet': ('skralle',),
'skralla': ('skralle',),
'skrallet': ('skralle',),
'skrall': ('skralle',),
'skramle': ('skramle',),
'skramler': ('skramle',),
'skramles': ('skramle',),
'skramla': ('skramle',),
'skramlet': ('skramle',),
'skramla': ('skramle',),
'skramlet': ('skramle',),
'skraml': ('skramle',),
'skramle': ('skramle',),
'skraml': ('skramle',),
'skramle': ('skramle',),
'skrangle': ('skrangle',),
'skrangler': ('skrangle',),
'skrangles': ('skrangle',),
'skrangla': ('skrangle',),
'skranglet': ('skrangle',),
'skrangla': ('skrangle',),
'skranglet': ('skrangle',),
'skrangl': ('skrangle',),
'skrangle': ('skrangle',),
'skrangl': ('skrangle',),
'skrangle': ('skrangle',),
'skrante': ('skrante',),
'skranter': ('skrante',),
'skrantes': ('skrante',),
'skranta': ('skrante',),
'skrantet': ('skrante',),
'skranta': ('skrante',),
'skrantet': ('skrante',),
'skrant': ('skrante',),
'skrape': ('skrape',),
'skraper': ('skrape',),
'skrapes': ('skrape',),
'skrapa': ('skrape',),
'skrapet': ('skrape',),
'skrapte': ('skrape',),
'skrapa': ('skrape',),
'skrapet': ('skrape',),
'skrapt': ('skrape',),
'skrap': ('skrape',),
'skrappe': ('skrappe',),
'skrapper': ('skrappe',),
'skrappes': ('skrappe',),
'skrappa': ('skrappe',),
'skrappet': ('skrappe',),
'skrappa': ('skrappe',),
'skrappet': ('skrappe',),
'skrapp': ('skrappe',),
'skrasle': ('skrasle',),
'skrasler': ('skrasle',),
'skrasles': ('skrasle',),
'skrasla': ('skrasle',),
'skraslet': ('skrasle',),
'skrasla': ('skrasle',),
'skraslet': ('skrasle',),
'skrasl': ('skrasle',),
'skratle': ('skratle',),
'skratler': ('skratle',),
'skratles': ('skratle',),
'skratla': ('skratle',),
'skratlet': ('skratle',),
'skratla': ('skratle',),
'skratlet': ('skratle',),
'skratl': ('skratle',),
'skratle': ('skratle',),
'skratl': ('skratle',),
'skratle': ('skratle',),
'skratte': ('skratte',),
'skratter': ('skratte',),
'skrattes': ('skratte',),
'skratta': ('skratte',),
'skrattet': ('skratte',),
'skratta': ('skratte',),
'skrattet': ('skratte',),
'skratt': ('skratte',),
'skrattle': ('skrattle',),
'skrattler': ('skrattle',),
'skrattles': ('skrattle',),
'skrattlo': ('skrattle',),
'skrattledd': ('skrattle',),
'skrattle': ('skrattle',),
'skravere': ('skravere',),
'skraverer': ('skravere',),
'skraveres': ('skravere',),
'skraverte': ('skravere',),
'skravert': ('skravere',),
'skraver': ('skravere',),
'skravle': ('skravle',),
'skravler': ('skravle',),
'skravles': ('skravle',),
'skravla': ('skravle',),
'skravlet': ('skravle',),
'skravla': ('skravle',),
'skravlet': ('skravle',),
'skravl': ('skravle',),
'skravle': ('skravle',),
'skravl': ('skravle',),
'skravle': ('skravle',),
'skre': ('skre',),
'skrer': ('skre',),
'skres': ('skre',),
'skredde': ('skre',),
'skredd': ('skre',),
'skre': ('skre',),
'skredderere': ('skredderere',),
'skreddererer': ('skredderere',),
'skreddereres': ('skredderere',),
'skreddererte': ('skredderere',),
'skredderert': ('skredderere',),
'skredderer': ('skredderere',),
'skreddersy': ('skreddersy',),
'skreddersyr': ('skreddersy',),
'skreddersys': ('skreddersy',),
'skreddersydde': ('skreddersy',),
'skreddersydd': ('skreddersy',),
'skreddersy': ('skreddersy',),
'skrelle': ('skrelle',),
'skreller': ('skrelle',),
'skrelles': ('skrelle',),
'skrelte': ('skrelle',),
'skrall': ('skrelle',),
'skrelt': ('skrelle',),
'skrell': ('skrelle',),
'skrelle': ('skrelle',),
'skreller': ('skrelle',),
'skrelles': ('skrelle',),
'skrella': ('skrelle',),
'skrellet': ('skrelle',),
'skrelte': ('skrelle',),
'skrella': ('skrelle',),
'skrellet': ('skrelle',),
'skrelt': ('skrelle',),
'skrell': ('skrelle',),
'skremme': ('skremme',),
'skremmer': ('skremme',),
'skremmes': ('skremme',),
'skremte': ('skremme',),
'skremt': ('skremme',),
'skrem': ('skremme',),
'skrense': ('skrense',),
'skrenser': ('skrense',),
'skrenses': ('skrense',),
'skrensa': ('skrense',),
'skrenset': ('skrense',),
'skrensa': ('skrense',),
'skrenset': ('skrense',),
'skrens': ('skrense',),
'skreppe': ('skreppe',),
'skrepper': ('skreppe',),
'skreppes': ('skreppe',),
'skreppet': ('skreppe',),
'skrepte': ('skreppe',),
'skreppet': ('skreppe',),
'skrept': ('skreppe',),
'skrepp': ('skreppe',),
'skreve': ('skreve',),
'skrever': ('skreve',),
'skreves': ('skreve',),
'skreva': ('skreve',),
'skrevet': ('skreve',),
'skrevde': ('skreve',),
'skreva': ('skreve',),
'skrevet': ('skreve',),
'skrevd': ('skreve',),
'skrev': ('skreve',),
'skri': ('skri',),
'skrir': ('skri',),
'skris': ('skri',),
'skred': ('skri',),
'skrei': ('skri',),
'skred': ('skri',),
'skrei': ('skri',),
'skredet': ('skri',),
'skri': ('skri',),
'skrible': ('skrible',),
'skribler': ('skrible',),
'skribles': ('skrible',),
'skribla': ('skrible',),
'skriblet': ('skrible',),
'skribla': ('skrible',),
'skriblet': ('skrible',),
'skribl': ('skrible',),
'skrible': ('skrible',),
'skribl': ('skrible',),
'skrible': ('skrible',),
'skride': ('skride',),
'skrider': ('skride',),
'skrides': ('skride',),
'skred': ('skride',),
'skrei': ('skride',),
'skred': ('skride',),
'skrei': ('skride',),
'skredet': ('skride',),
'skrid': ('skride',),
'skrifte': ('skrifte',),
'skrifter': ('skrifte',),
'skriftes': ('skrifte',),
'skrifta': ('skrifte',),
'skriftet': ('skrifte',),
'skrifta': ('skrifte',),
'skriftet': ('skrifte',),
'skrift': ('skrifte',),
'skriftfeste': ('skriftfeste',),
'skriftfester': ('skriftfeste',),
'skriftfestes': ('skriftfeste',),
'skriftfesta': ('skriftfeste',),
'skriftfestet': ('skriftfeste',),
'skriftfesta': ('skriftfeste',),
'skriftfestet': ('skriftfeste',),
'skriftfest': ('skriftfeste',),
'skrike': ('skrike',),
'skriker': ('skrike',),
'skrikes': ('skrike',),
'skrek': ('skrike',),
'skreik': ('skrike',),
'skrek': ('skrike',),
'skreik': ('skrike',),
'skreket': ('skrike',),
'skrik': ('skrike',),
'skrinlegge': ('skrinlegge',),
'skrinlegger': ('skrinlegge',),
'skrinlegges': ('skrinlegge',),
'skrinla': ('skrinlegge',),
'skrinlagt': ('skrinlegge',),
'skrinlegg': ('skrinlegge',),
'skritte': ('skritte',),
'skritter': ('skritte',),
'skrittes': ('skritte',),
'skritta': ('skritte',),
'skrittet': ('skritte',),
'skritta': ('skritte',),
'skrittet': ('skritte',),
'skritt': ('skritte',),
'skrive': ('skrive',),
'skriver': ('skrive',),
'skrives': ('skrive',),
'skrev': ('skrive',),
'skreiv': ('skrive',),
'skrev': ('skrive',),
'skreiv': ('skrive',),
'skrevet': ('skrive',),
'skriv': ('skrive',),
'skrote': ('skrote',),
'skroter': ('skrote',),
'skrotes': ('skrote',),
'skrota': ('skrote',),
'skrotet': ('skrote',),
'skrota': ('skrote',),
'skrotet': ('skrote',),
'skrot': ('skrote',),
'skru': ('skru',),
'skrur': ('skru',),
'skrus': ('skru',),
'skrudde': ('skru',),
'skrudd': ('skru',),
'skru': ('skru',),
'skrubbe': ('skrubbe',),
'skrubber': ('skrubbe',),
'skrubbes': ('skrubbe',),
'skrubba': ('skrubbe',),
'skrubbet': ('skrubbe',),
'skrubba': ('skrubbe',),
'skrubbet': ('skrubbe',),
'skrubb': ('skrubbe',),
'skrukke': ('skrukke',),
'skrukker': ('skrukke',),
'skrukkes': ('skrukke',),
'skrukka': ('skrukke',),
'skrukket': ('skrukke',),
'skrukka': ('skrukke',),
'skrukket': ('skrukke',),
'skrukk': ('skrukke',),
'skrumpe': ('skrumpe',),
'skrumper': ('skrumpe',),
'skrumpes': ('skrumpe',),
'skrumpa': ('skrumpe',),
'skrumpet': ('skrumpe',),
'skrumpa': ('skrumpe',),
'skrumpet': ('skrumpe',),
'skrump': ('skrumpe',),
'skryte': ('skryte',),
'skryter': ('skryte',),
'skrytes': ('skryte',),
'skrytte': ('skryte',),
'skrøt': ('skryte',),
'skrytt': ('skryte',),
'skryt': ('skryte',),
'skrå': ('skrå',),
'skrår': ('skrå',),
'skrås': ('skrå',),
'skrådde': ('skrå',),
'skrådd': ('skrå',),
'skrå': ('skrå',),
'skråle': ('skråle',),
'skråler': ('skråle',),
'skråles': ('skråle',),
'skrålte': ('skråle',),
'skrålt': ('skråle',),
'skrål': ('skråle',),
'skråne': ('skråne',),
'skråner': ('skråne',),
'skrånes': ('skråne',),
'skråna': ('skråne',),
'skrånet': ('skråne',),
'skrånte': ('skråne',),
'skråna': ('skråne',),
'skrånet': ('skråne',),
'skrånt': ('skråne',),
'skrån': ('skråne',),
'skråsette': ('skråsette',),
'skråsetter': ('skråsette',),
'skråsettes': ('skråsette',),
'skråsatte': ('skråsette',),
'skråsatt': ('skråsette',),
'skråsett': ('skråsette',),
'skråstille': ('skråstille',),
'skråstiller': ('skråstille',),
'skråstilles': ('skråstille',),
'skråstilte': ('skråstille',),
'skråstilt': ('skråstille',),
'skråstill': ('skråstille',),
'skrø': ('skrø',),
'skrør': ('skrø',),
'skrøs': ('skrø',),
'skrødde': ('skrø',),
'skrødd': ('skrø',),
'skrø': ('skrø',),
'skrøfte': ('skrøfte',),
'skrøfter': ('skrøfte',),
'skrøftes': ('skrøfte',),
'skrøfta': ('skrøfte',),
'skrøftet': ('skrøfte',),
'skrøfta': ('skrøfte',),
'skrøftet': ('skrøfte',),
'skrøft': ('skrøfte',),
'skrømte': ('skrømte',),
'skrømter': ('skrømte',),
'skrømtes': ('skrømte',),
'skrømta': ('skrømte',),
'skrømtet': ('skrømte',),
'skrømta': ('skrømte',),
'skrømtet': ('skrømte',),
'skrømt': ('skrømte',),
'skrøne': ('skrøne',),
'skrøner': ('skrøne',),
'skrønes': ('skrøne',),
'skrønte': ('skrøne',),
'skrønt': ('skrøne',),
'skrøn': ('skrøne',),
'skubbe': ('skubbe',),
'skubber': ('skubbe',),
'skubbes': ('skubbe',),
'skubba': ('skubbe',),
'skubbet': ('skubbe',),
'skubba': ('skubbe',),
'skubbet': ('skubbe',),
'skubb': ('skubbe',),
'skue': ('skue',),
'skuer': ('skue',),
'skues': ('skue',),
'skua': ('skue',),
'skuet': ('skue',),
'skua': ('skue',),
'skuet': ('skue',),
'sku': ('skue',),
'skuffe': ('skuffe',),
'skuffer': ('skuffe',),
'skuffes': ('skuffe',),
'skuffa': ('skuffe',),
'skuffet': ('skuffe',),
'skuffa': ('skuffe',),
'skuffet': ('skuffe',),
'skuff': ('skuffe',),
'skufle': ('skufle',),
'skufler': ('skufle',),
'skufles': ('skufle',),
'skufla': ('skufle',),
'skuflet': ('skufle',),
'skufla': ('skufle',),
'skuflet': ('skufle',),
'skufl': ('skufle',),
'skufle': ('skufle',),
'skufl': ('skufle',),
'skufle': ('skufle',),
'skule': ('skule',),
'skuler': ('skule',),
'skules': ('skule',),
'skulte': ('skule',),
'skult': ('skule',),
'skul': ('skule',),
'skulke': ('skulke',),
'skulker': ('skulke',),
'skulkes': ('skulke',),
'skulka': ('skulke',),
'skulket': ('skulke',),
'skulka': ('skulke',),
'skulket': ('skulke',),
'skulk': ('skulke',),
'skulle': ('skulle',),
'skal': ('skulle',),
'skulle': ('skulle',),
'skullet': ('skulle',),
'skulptere': ('skulptere',),
'skulpterer': ('skulptere',),
'skulpteres': ('skulptere',),
'skulpterte': ('skulptere',),
'skulptert': ('skulptere',),
'skulpter': ('skulptere',),
'skulse': ('skulse',),
'skulser': ('skulse',),
'skulses': ('skulse',),
'skulsa': ('skulse',),
'skulset': ('skulse',),
'skulsa': ('skulse',),
'skulset': ('skulse',),
'skuls': ('skulse',),
'skumkjøre': ('skumkjøre',),
'skumkjører': ('skumkjøre',),
'skumkjøres': ('skumkjøre',),
'skumkjørte': ('skumkjøre',),
'skumkjørt': ('skumkjøre',),
'skumkjør': ('skumkjøre',),
'skumle': ('skumle',),
'skumler': ('skumle',),
'skumles': ('skumle',),
'skumla': ('skumle',),
'skumlet': ('skumle',),
'skumla': ('skumle',),
'skumlet': ('skumle',),
'skuml': ('skumle',),
'skumle': ('skumle',),
'skuml': ('skumle',),
'skumle': ('skumle',),
'skumlese': ('skumlese',),
'skumleser': ('skumlese',),
'skumleses': ('skumlese',),
'skumleste': ('skumlese',),
'skumlest': ('skumlese',),
'skumles': ('skumlese',),
'skumme': ('skumme',),
'skummer': ('skumme',),
'skummes': ('skumme',),
'skumma': ('skumme',),
'skummet': ('skumme',),
'skumma': ('skumme',),
'skummet': ('skumme',),
'skum': ('skumme',),
'skumpe': ('skumpe',),
'skumper': ('skumpe',),
'skumpes': ('skumpe',),
'skumpa': ('skumpe',),
'skumpet': ('skumpe',),
'skumpa': ('skumpe',),
'skumpet': ('skumpe',),
'skump': ('skumpe',),
'skumpiske': ('skumpiske',),
'skumpisker': ('skumpiske',),
'skumpiskes': ('skumpiske',),
'skumpiska': ('skumpiske',),
'skumpisket': ('skumpiske',),
'skumpiska': ('skumpiske',),
'skumpisket': ('skumpiske',),
'skumpisk': ('skumpiske',),
'skumple': ('skumple',),
'skumpler': ('skumple',),
'skumples': ('skumple',),
'skumpla': ('skumple',),
'skumplet': ('skumple',),
'skumpla': ('skumple',),
'skumplet': ('skumple',),
'skumpl': ('skumple',),
'skumple': ('skumple',),
'skumpl': ('skumple',),
'skumple': ('skumple',),
'skumre': ('skumre',),
'skumrer': ('skumre',),
'skumres': ('skumre',),
'skumra': ('skumre',),
'skumret': ('skumre',),
'skumra': ('skumre',),
'skumret': ('skumre',),
'skumr': ('skumre',),
'skumre': ('skumre',),
'skumr': ('skumre',),
'skumre': ('skumre',),
'skumtygge': ('skumtygge',),
'skumtygger': ('skumtygge',),
'skumtygges': ('skumtygge',),
'skumtygget': ('skumtygge',),
'skumtygde': ('skumtygge',),
'skumtygget': ('skumtygge',),
'skumtygd': ('skumtygge',),
'skumtygg': ('skumtygge',),
'skure': ('skure',),
'skurer': ('skure',),
'skures': ('skure',),
'skura': ('skure',),
'skuret': ('skure',),
'skurte': ('skure',),
'skura': ('skure',),
'skuret': ('skure',),
'skurt': ('skure',),
'skur': ('skure',),
'skurre': ('skurre',),
'skurrer': ('skurre',),
'skurres': ('skurre',),
'skurra': ('skurre',),
'skurret': ('skurre',),
'skurra': ('skurre',),
'skurret': ('skurre',),
'skurr': ('skurre',),
'skusle': ('skusle',),
'skusler': ('skusle',),
'skusles': ('skusle',),
'skusla': ('skusle',),
'skuslet': ('skusle',),
'skusla': ('skusle',),
'skuslet': ('skusle',),
'skusl': ('skusle',),
'skusle': ('skusle',),
'skusl': ('skusle',),
'skusle': ('skusle',),
'skutle': ('skutle',),
'skutler': ('skutle',),
'skutles': ('skutle',),
'skutla': ('skutle',),
'skutlet': ('skutle',),
'skutla': ('skutle',),
'skutlet': ('skutle',),
'skutl': ('skutle',),
'skutle': ('skutle',),
'skutl': ('skutle',),
'skutle': ('skutle',),
'skutte': ('skutte',),
'skutter': ('skutte',),
'skuttes': ('skutte',),
'skutta': ('skutte',),
'skuttet': ('skutte',),
'skutta': ('skutte',),
'skuttet': ('skutte',),
'skutt': ('skutte',),
'skvadronere': ('skvadronere',),
'skvadronerer': ('skvadronere',),
'skvadroneres': ('skvadronere',),
'skvadronerte': ('skvadronere',),
'skvadronert': ('skvadronere',),
'skvadroner': ('skvadronere',),
'skvaldre': ('skvaldre',),
'skvaldrer': ('skvaldre',),
'skvaldres': ('skvaldre',),
'skvaldra': ('skvaldre',),
'skvaldret': ('skvaldre',),
'skvaldra': ('skvaldre',),
'skvaldret': ('skvaldre',),
'skvaldr': ('skvaldre',),
'skvaldre': ('skvaldre',),
'skvaldr': ('skvaldre',),
'skvaldre': ('skvaldre',),
'skvale': ('skvale',),
'skvaler': ('skvale',),
'skvales': ('skvale',),
'skvala': ('skvale',),
'skvalet': ('skvale',),
'skvalte': ('skvale',),
'skvala': ('skvale',),
'skvalet': ('skvale',),
'skvalt': ('skvale',),
'skval': ('skvale',),
'skvalpe': ('skvalpe',),
'skvalper': ('skvalpe',),
'skvalpes': ('skvalpe',),
'skvalpa': ('skvalpe',),
'skvalpet': ('skvalpe',),
'skvalpa': ('skvalpe',),
'skvalpet': ('skvalpe',),
'skvalp': ('skvalpe',),
'skvatre': ('skvatre',),
'skvatrer': ('skvatre',),
'skvatres': ('skvatre',),
'skvatra': ('skvatre',),
'skvatret': ('skvatre',),
'skvatra': ('skvatre',),
'skvatret': ('skvatre',),
'skvatr': ('skvatre',),
'skvatre': ('skvatre',),
'skvatr': ('skvatre',),
'skvatre': ('skvatre',),
'skvette': ('skvette',),
'skvetter': ('skvette',),
'skvettes': ('skvette',),
'skvetta': ('skvette',),
'skvettet': ('skvette',),
'skvetta': ('skvette',),
'skvettet': ('skvette',),
'skvett': ('skvette',),
'skvette': ('skvette',),
'skvetter': ('skvette',),
'skvettes': ('skvette',),
'skvatt': ('skvette',),
'skvettet': ('skvette',),
'skvett': ('skvette',),
'skvise': ('skvise',),
'skviser': ('skvise',),
'skvises': ('skvise',),
'skvisa': ('skvise',),
'skviset': ('skvise',),
'skviste': ('skvise',),
'skvisa': ('skvise',),
'skviset': ('skvise',),
'skvist': ('skvise',),
'skvis': ('skvise',),
'skvulpe': ('skvulpe',),
'skvulper': ('skvulpe',),
'skvulpes': ('skvulpe',),
'skvulpa': ('skvulpe',),
'skvulpet': ('skvulpe',),
'skvulpa': ('skvulpe',),
'skvulpet': ('skvulpe',),
'skvulp': ('skvulpe',),
'skvære': ('skvære',),
'skværer': ('skvære',),
'skværes': ('skvære',),
'skværa': ('skvære',),
'skværet': ('skvære',),
'skværte': ('skvære',),
'skværa': ('skvære',),
'skværet': ('skvære',),
'skvært': ('skvære',),
'skvær': ('skvære',),
'sky': ('sky',),
'skyr': ('sky',),
'skys': ('sky',),
'skydde': ('sky',),
'skydd': ('sky',),
'sky': ('sky',),
'skye': ('skye',),
'skyer': ('skye',),
'skyes': ('skye',),
'skya': ('skye',),
'skyet': ('skye',),
'skya': ('skye',),
'skyet': ('skye',),
'sky': ('skye',),
'skyfle': ('skyfle',),
'skyfler': ('skyfle',),
'skyfles': ('skyfle',),
'skyfla': ('skyfle',),
'skyflet': ('skyfle',),
'skyfla': ('skyfle',),
'skyflet': ('skyfle',),
'skyfl': ('skyfle',),
'skyfle': ('skyfle',),
'skyfl': ('skyfle',),
'skyfle': ('skyfle',),
'skygge': ('skygge',),
'skygger': ('skygge',),
'skygges': ('skygge',),
'skygga': ('skygge',),
'skygget': ('skygge',),
'skygde': ('skygge',),
'skygga': ('skygge',),
'skygget': ('skygge',),
'skygd': ('skygge',),
'skygg': ('skygge',),
'skyggelegge': ('skyggelegge',),
'skyggelegger': ('skyggelegge',),
'skyggelegges': ('skyggelegge',),
'skyggela': ('skyggelegge',),
'skyggelagt': ('skyggelegge',),
'skyggelegg': ('skyggelegge',),
'skylde': ('skylde',),
'skylder': ('skylde',),
'skyldes': ('skylde',),
'skyldte': ('skylde',),
'skyldt': ('skylde',),
'skyld': ('skylde',),
'skyldes': ('skyldes',),
'skyldtes': ('skyldes',),
'skyldes': ('skyldes',),
'skyldsette': ('skyldsette',),
'skyldsetter': ('skyldsette',),
'skyldsettes': ('skyldsette',),
'skyldsatte': ('skyldsette',),
'skyldsatt': ('skyldsette',),
'skyldsett': ('skyldsette',),
'skylle': ('skylle',),
'skyller': ('skylle',),
'skylles': ('skylle',),
'skyllet': ('skylle',),
'skylte': ('skylle',),
'skyllet': ('skylle',),
'skylt': ('skylle',),
'skyll': ('skylle',),
'skynde': ('skynde',),
'skynder': ('skynde',),
'skyndes': ('skynde',),
'skyndet': ('skynde',),
'skyndte': ('skynde',),
'skyndet': ('skynde',),
'skyndt': ('skynde',),
'skynd': ('skynde',),
'skysse': ('skysse',),
'skysser': ('skysse',),
'skysses': ('skysse',),
'skyssa': ('skysse',),
'skysset': ('skysse',),
'skyssa': ('skysse',),
'skysset': ('skysse',),
'skyss': ('skysse',),
'skyte': ('skyte',),
'skyter': ('skyte',),
'skytes': ('skyte',),
'skjøt': ('skyte',),
'skøyt': ('skyte',),
'skutt': ('skyte',),
'skyt': ('skyte',),
'skyve': ('skyve',),
'skyver': ('skyve',),
'skyves': ('skyve',),
'skjøv': ('skyve',),
'skøyv': ('skyve',),
'skjøvet': ('skyve',),
'skyv': ('skyve',),
'skålde': ('skålde',),
'skålder': ('skålde',),
'skåldes': ('skålde',),
'skålda': ('skålde',),
'skåldet': ('skålde',),
'skålda': ('skålde',),
'skåldet': ('skålde',),
'skåld': ('skålde',),
'skåle': ('skåle',),
'skåler': ('skåle',),
'skåles': ('skåle',),
'skålte': ('skåle',),
'skålt': ('skåle',),
'skål': ('skåle',),
'skåne': ('skåne',),
'skåner': ('skåne',),
'skånes': ('skåne',),
'skåna': ('skåne',),
'skånet': ('skåne',),
'skånte': ('skåne',),
'skåna': ('skåne',),
'skånet': ('skåne',),
'skånt': ('skåne',),
'skån': ('skåne',),
'skåre': ('skåre',),
'skårer': ('skåre',),
'skåres': ('skåre',),
'skåra': ('skåre',),
'skåret': ('skåre',),
'skåra': ('skåre',),
'skåret': ('skåre',),
'skår': ('skåre',),
'skårlegge': ('skårlegge',),
'skårlegger': ('skårlegge',),
'skårlegges': ('skårlegge',),
'skårla': ('skårlegge',),
'skårlagt': ('skårlegge',),
'skårlegg': ('skårlegge',),
'skåte': ('skåte',),
'skåter': ('skåte',),
'skåtes': ('skåte',),
'skåta': ('skåte',),
'skåtet': ('skåte',),
'skåta': ('skåte',),
'skåtet': ('skåte',),
'skåt': ('skåte',),
'skøye': ('skøye',),
'skøyer': ('skøye',),
'skøyes': ('skøye',),
'skøya': ('skøye',),
'skøyet': ('skøye',),
'skøya': ('skøye',),
'skøyet': ('skøye',),
'skøy': ('skøye',),
'skøyte': ('skøyte',),
'skøyter': ('skøyte',),
'skøytes': ('skøyte',),
'skøyta': ('skøyte',),
'skøytet': ('skøyte',),
'skøyta': ('skøyte',),
'skøytet': ('skøyte',),
'skøyt': ('skøyte',),
'slabbe': ('slabbe',),
'slabber': ('slabbe',),
'slabbes': ('slabbe',),
'slabba': ('slabbe',),
'slabbet': ('slabbe',),
'slabba': ('slabbe',),
'slabbet': ('slabbe',),
'slabb': ('slabbe',),
'sladde': ('sladde',),
'sladder': ('sladde',),
'sladdes': ('sladde',),
'sladda': ('sladde',),
'sladdet': ('sladde',),
'sladda': ('sladde',),
'sladdet': ('sladde',),
'sladd': ('sladde',),
'sladre': ('sladre',),
'sladrer': ('sladre',),
'sladres': ('sladre',),
'sladra': ('sladre',),
'sladret': ('sladre',),
'sladra': ('sladre',),
'sladret': ('sladre',),
'sladr': ('sladre',),
'sladre': ('sladre',),
'sladr': ('sladre',),
'sladre': ('sladre',),
'slafse': ('slafse',),
'slafser': ('slafse',),
'slafses': ('slafse',),
'slafsa': ('slafse',),
'slafset': ('slafse',),
'slafsa': ('slafse',),
'slafset': ('slafse',),
'slafs': ('slafse',),
'slage': ('slage',),
'slager': ('slage',),
'slages': ('slage',),
'slaga': ('slage',),
'slaget': ('slage',),
'slaga': ('slage',),
'slaget': ('slage',),
'slag': ('slage',),
'slagge': ('slagge',),
'slagger': ('slagge',),
'slagges': ('slagge',),
'slagga': ('slagge',),
'slagget': ('slagge',),
'slagga': ('slagge',),
'slagget': ('slagge',),
'slagg': ('slagge',),
'slakke': ('slakke',),
'slakker': ('slakke',),
'slakkes': ('slakke',),
'slakka': ('slakke',),
'slakket': ('slakke',),
'slakka': ('slakke',),
'slakket': ('slakke',),
'slakk': ('slakke',),
'slakne': ('slakne',),
'slakner': ('slakne',),
'slaknes': ('slakne',),
'slakna': ('slakne',),
'slaknet': ('slakne',),
'slakna': ('slakne',),
'slaknet': ('slakne',),
'slakn': ('slakne',),
'slakne': ('slakne',),
'slakn': ('slakne',),
'slakne': ('slakne',),
'slakte': ('slakte',),
'slakter': ('slakte',),
'slaktes': ('slakte',),
'slakta': ('slakte',),
'slaktet': ('slakte',),
'slakta': ('slakte',),
'slaktet': ('slakte',),
'slakt': ('slakte',),
'slamme': ('slamme',),
'slammer': ('slamme',),
'slammes': ('slamme',),
'slamma': ('slamme',),
'slammet': ('slamme',),
'slamma': ('slamme',),
'slammet': ('slamme',),
'slam': ('slamme',),
'slampe': ('slampe',),
'slamper': ('slampe',),
'slampes': ('slampe',),
'slampa': ('slampe',),
'slampet': ('slampe',),
'slampa': ('slampe',),
'slampet': ('slampe',),
'slamp': ('slampe',),
'slamre': ('slamre',),
'slamrer': ('slamre',),
'slamres': ('slamre',),
'slamra': ('slamre',),
'slamret': ('slamre',),
'slamra': ('slamre',),
'slamret': ('slamre',),
'slamr': ('slamre',),
'slamre': ('slamre',),
'slamr': ('slamre',),
'slamre': ('slamre',),
'slamse': ('slamse',),
'slamser': ('slamse',),
'slamses': ('slamse',),
'slamsa': ('slamse',),
'slamset': ('slamse',),
'slamsa': ('slamse',),
'slamset': ('slamse',),
'slams': ('slamse',),
'slange': ('slange',),
'slanger': ('slange',),
'slanges': ('slange',),
'slanga': ('slange',),
'slanget': ('slange',),
'slanga': ('slange',),
'slanget': ('slange',),
'slang': ('slange',),
'slanke': ('slanke',),
'slanker': ('slanke',),
'slankes': ('slanke',),
'slanka': ('slanke',),
'slanket': ('slanke',),
'slanka': ('slanke',),
'slanket': ('slanke',),
'slank': ('slanke',),
'slapne': ('slapne',),
'slapner': ('slapne',),
'slapnes': ('slapne',),
'slapna': ('slapne',),
'slapnet': ('slapne',),
'slapna': ('slapne',),
'slapnet': ('slapne',),
'slapn': ('slapne',),
'slapne': ('slapne',),
'slapn': ('slapne',),
'slapne': ('slapne',),
'slappe': ('slappe',),
'slapper': ('slappe',),
'slappes': ('slappe',),
'slappa': ('slappe',),
'slappet': ('slappe',),
'slappa': ('slappe',),
'slappet': ('slappe',),
'slapp': ('slappe',),
'slarke': ('slarke',),
'slarker': ('slarke',),
'slarkes': ('slarke',),
'slarka': ('slarke',),
'slarket': ('slarke',),
'slarka': ('slarke',),
'slarket': ('slarke',),
'slark': ('slarke',),
'slarve': ('slarve',),
'slarver': ('slarve',),
'slarves': ('slarve',),
'slarva': ('slarve',),
'slarvet': ('slarve',),
'slarva': ('slarve',),
'slarvet': ('slarve',),
'slarv': ('slarve',),
'slaske': ('slaske',),
'slasker': ('slaske',),
'slaskes': ('slaske',),
'slaska': ('slaske',),
'slasket': ('slaske',),
'slaska': ('slaske',),
'slasket': ('slaske',),
'slask': ('slaske',),
'slaure': ('slaure',),
'slaurer': ('slaure',),
'slaures': ('slaure',),
'slaura': ('slaure',),
'slauret': ('slaure',),
'slaura': ('slaure',),
'slauret': ('slaure',),
'slaur': ('slaure',),
'slave': ('slave',),
'slaver': ('slave',),
'slaves': ('slave',),
'slava': ('slave',),
'slavet': ('slave',),
'slava': ('slave',),
'slavet': ('slave',),
'slav': ('slave',),
'slavebinde': ('slavebinde',),
'slavebinder': ('slavebinde',),
'slavebindes': ('slavebinde',),
'slavebandt': ('slavebinde',),
'slavebundet': ('slavebinde',),
'slavebind': ('slavebinde',),
'slegge': ('slegge',),
'slegger': ('slegge',),
'slegges': ('slegge',),
'slegga': ('slegge',),
'slegget': ('slegge',),
'slegga': ('slegge',),
'slegget': ('slegge',),
'slegg': ('slegge',),
'sleike': ('sleike',),
'sleiker': ('sleike',),
'sleikes': ('sleike',),
'sleika': ('sleike',),
'sleiket': ('sleike',),
'sleikte': ('sleike',),
'sleika': ('sleike',),
'sleiket': ('sleike',),
'sleikt': ('sleike',),
'sleik': ('sleike',),
'sleive': ('sleive',),
'sleiver': ('sleive',),
'sleives': ('sleive',),
'sleiva': ('sleive',),
'sleivet': ('sleive',),
'sleivde': ('sleive',),
'sleiva': ('sleive',),
'sleivet': ('sleive',),
'sleivd': ('sleive',),
'sleiv': ('sleive',),
'slekte': ('slekte',),
'slekter': ('slekte',),
'slektes': ('slekte',),
'slekta': ('slekte',),
'slektet': ('slekte',),
'slekta': ('slekte',),
'slektet': ('slekte',),
'slekt': ('slekte',),
'slemme': ('slemme',),
'slemmer': ('slemme',),
'slemmes': ('slemme',),
'slemma': ('slemme',),
'slemmet': ('slemme',),
'slemma': ('slemme',),
'slemmet': ('slemme',),
'slem': ('slemme',),
'slentre': ('slentre',),
'slentrer': ('slentre',),
'slentres': ('slentre',),
'slentra': ('slentre',),
'slentret': ('slentre',),
'slentra': ('slentre',),
'slentret': ('slentre',),
'slentr': ('slentre',),
'slentre': ('slentre',),
'slentr': ('slentre',),
'slentre': ('slentre',),
'slepe': ('slepe',),
'sleper': ('slepe',),
'slepes': ('slepe',),
'slepte': ('slepe',),
'slept': ('slepe',),
'slep': ('slepe',),
'sleske': ('sleske',),
'slesker': ('sleske',),
'sleskes': ('sleske',),
'sleska': ('sleske',),
'slesket': ('sleske',),
'sleska': ('sleske',),
'slesket': ('sleske',),
'slesk': ('sleske',),
'sletne': ('sletne',),
'sletner': ('sletne',),
'sletnes': ('sletne',),
'sletna': ('sletne',),
'sletnet': ('sletne',),
'sletna': ('sletne',),
'sletnet': ('sletne',),
'sletn': ('sletne',),
'sletne': ('sletne',),
'sletn': ('sletne',),
'sletne': ('sletne',),
'slette': ('slette',),
'sletter': ('slette',),
'slettes': ('slette',),
'sletta': ('slette',),
'slettet': ('slette',),
'sletta': ('slette',),
'slettet': ('slette',),
'slett': ('slette',),
'sleve': ('sleve',),
'slever': ('sleve',),
'sleves': ('sleve',),
'sleva': ('sleve',),
'slevet': ('sleve',),
'slevde': ('sleve',),
'sleva': ('sleve',),
'slevet': ('sleve',),
'slevd': ('sleve',),
'slev': ('sleve',),
'slikke': ('slikke',),
'slikker': ('slikke',),
'slikkes': ('slikke',),
'slikka': ('slikke',),
'slikket': ('slikke',),
'slikka': ('slikke',),
'slikket': ('slikke',),
'slikk': ('slikke',),
'slime': ('slime',),
'slimer': ('slime',),
'slimes': ('slime',),
'slima': ('slime',),
'slimet': ('slime',),
'slima': ('slime',),
'slimet': ('slime',),
'slim': ('slime',),
'slindbarke': ('slindbarke',),
'slindbarker': ('slindbarke',),
'slindbarkes': ('slindbarke',),
'slindbarka': ('slindbarke',),
'slindbarket': ('slindbarke',),
'slindbarka': ('slindbarke',),
'slindbarket': ('slindbarke',),
'slindbark': ('slindbarke',),
'slinde': ('slinde',),
'slinder': ('slinde',),
'slindes': ('slinde',),
'slinda': ('slinde',),
'slindet': ('slinde',),
'slinda': ('slinde',),
'slindet': ('slinde',),
'slind': ('slinde',),
'slindre': ('slindre',),
'slindrer': ('slindre',),
'slindres': ('slindre',),
'slindra': ('slindre',),
'slindret': ('slindre',),
'slindra': ('slindre',),
'slindret': ('slindre',),
'slindr': ('slindre',),
'slindre': ('slindre',),
'slindr': ('slindre',),
'slindre': ('slindre',),
'slingre': ('slingre',),
'slingrer': ('slingre',),
'slingres': ('slingre',),
'slingra': ('slingre',),
'slingret': ('slingre',),
'slingra': ('slingre',),
'slingret': ('slingre',),
'slingr': ('slingre',),
'slingre': ('slingre',),
'slingr': ('slingre',),
'slingre': ('slingre',),
'slipe': ('slipe',),
'sliper': ('slipe',),
'slipes': ('slipe',),
'slipte': ('slipe',),
'slipt': ('slipe',),
'slip': ('slipe',),
'slippe': ('slippe',),
'slipper': ('slippe',),
'slippes': ('slippe',),
'slapp': ('slippe',),
'sluppet': ('slippe',),
'slipp': ('slippe',),
'sliske': ('sliske',),
'slisker': ('sliske',),
'sliskes': ('sliske',),
'sliska': ('sliske',),
'slisket': ('sliske',),
'sliska': ('sliske',),
'slisket': ('sliske',),
'slisk': ('sliske',),
'slisse': ('slisse',),
'slisser': ('slisse',),
'slisses': ('slisse',),
'slissa': ('slisse',),
'slisset': ('slisse',),
'slissa': ('slisse',),
'slisset': ('slisse',),
'sliss': ('slisse',),
'slite': ('slite',),
'sliter': ('slite',),
'slites': ('slite',),
'sleit': ('slite',),
'slet': ('slite',),
'slitt': ('slite',),
'slit': ('slite',),
'slitne': ('slitne',),
'slitner': ('slitne',),
'slitnes': ('slitne',),
'slitna': ('slitne',),
'slitnet': ('slitne',),
'slitna': ('slitne',),
'slitnet': ('slitne',),
'slitn': ('slitne',),
'slitne': ('slitne',),
'slitn': ('slitne',),
'slitne': ('slitne',),
'slodde': ('slodde',),
'slodder': ('slodde',),
'sloddes': ('slodde',),
'slodda': ('slodde',),
'sloddet': ('slodde',),
'slodda': ('slodde',),
'sloddet': ('slodde',),
'slodd': ('slodde',),
'slokke': ('slokke',),
'slokker': ('slokke',),
'slokkes': ('slokke',),
'slokka': ('slokke',),
'slokket': ('slokke',),
'slokte': ('slokke',),
'slokka': ('slokke',),
'slokket': ('slokke',),
'slokt': ('slokke',),
'slokk': ('slokke',),
'slokne': ('slokne',),
'slokner': ('slokne',),
'sloknes': ('slokne',),
'slokna': ('slokne',),
'sloknet': ('slokne',),
'slokna': ('slokne',),
'sloknet': ('slokne',),
'slokn': ('slokne',),
'slokne': ('slokne',),
'slokn': ('slokne',),
'slokne': ('slokne',),
'slubbe': ('slubbe',),
'slubber': ('slubbe',),
'slubbes': ('slubbe',),
'slubba': ('slubbe',),
'slubbet': ('slubbe',),
'slubba': ('slubbe',),
'slubbet': ('slubbe',),
'slubb': ('slubbe',),
'slubre': ('slubre',),
'slubrer': ('slubre',),
'slubres': ('slubre',),
'slubra': ('slubre',),
'slubret': ('slubre',),
'slubra': ('slubre',),
'slubret': ('slubre',),
'slubr': ('slubre',),
'sludde': ('sludde',),
'sludder': ('sludde',),
'sluddes': ('sludde',),
'sludda': ('sludde',),
'sluddet': ('sludde',),
'sludda': ('sludde',),
'sluddet': ('sludde',),
'sludd': ('sludde',),
'sludre': ('sludre',),
'sludrer': ('sludre',),
'sludres': ('sludre',),
'sludra': ('sludre',),
'sludret': ('sludre',),
'sludra': ('sludre',),
'sludret': ('sludre',),
'sludr': ('sludre',),
'sludre': ('sludre',),
'sludr': ('sludre',),
'sludre': ('sludre',),
'sluffe': ('sluffe',),
'sluffer': ('sluffe',),
'sluffes': ('sluffe',),
'sluffa': ('sluffe',),
'sluffet': ('sluffe',),
'sluffa': ('sluffe',),
'sluffet': ('sluffe',),
'sluff': ('sluffe',),
'slufse': ('slufse',),
'slufser': ('slufse',),
'slufses': ('slufse',),
'slufsa': ('slufse',),
'slufset': ('slufse',),
'slufsa': ('slufse',),
'slufset': ('slufse',),
'slufs': ('slufse',),
'sluke': ('sluke',),
'sluker': ('sluke',),
'slukes': ('sluke',),
'slukte': ('sluke',),
'slukt': ('sluke',),
'sluk': ('sluke',),
'slukke': ('slukke',),
'slukker': ('slukke',),
'slukkes': ('slukke',),
'slukka': ('slukke',),
'slukket': ('slukke',),
'slukte': ('slukke',),
'slukka': ('slukke',),
'slukket': ('slukke',),
'slukt': ('slukke',),
'slukk': ('slukke',),
'slukne': ('slukne',),
'slukner': ('slukne',),
'sluknes': ('slukne',),
'slukna': ('slukne',),
'sluknet': ('slukne',),
'slukna': ('slukne',),
'sluknet': ('slukne',),
'slukn': ('slukne',),
'slukne': ('slukne',),
'slukn': ('slukne',),
'slukne': ('slukne',),
'slumpe': ('slumpe',),
'slumper': ('slumpe',),
'slumpes': ('slumpe',),
'slumpa': ('slumpe',),
'slumpet': ('slumpe',),
'slumpa': ('slumpe',),
'slumpet': ('slumpe',),
'slump': ('slumpe',),
'slumre': ('slumre',),
'slumrer': ('slumre',),
'slumres': ('slumre',),
'slumra': ('slumre',),
'slumret': ('slumre',),
'slumra': ('slumre',),
'slumret': ('slumre',),
'slumr': ('slumre',),
'slu