# coding: utf8
"""
Special-case rules for normalizing tokens to improve the model's predictions.
For example 'mysterium' vs 'mysterie' and similar.
"""
from __future__ import unicode_literals


# Sources:
# 1: https://dsn.dk/retskrivning/om-retskrivningsordbogen/mere-om-retskrivningsordbogen-2012/endrede-stave-og-ordformer/
# 2: http://www.tjerry-korrektur.dk/ord-med-flere-stavemaader/

_exc = {
    # Alternative spelling
    "a-kraft-værk": "a-kraftværk",  # 1
    "ålborg": "aalborg",  # 2
    "århus": "aarhus",
    "accessoirer": "accessoires",  # 1
    "affektert": "affekteret",  # 1
    "afrikander": "afrikaaner",  # 1
    "aftabuere": "aftabuisere",  # 1
    "aftabuering": "aftabuisering",  # 1
    "akvarium": "akvarie",  # 1
    "alenefader": "alenefar",  # 1
    "alenemoder": "alenemor",  # 1
    "alkoholambulatorium": "alkoholambulatorie",  # 1
    "ambulatorium": "ambulatorie",  # 1
    "ananassene": "ananasserne",  # 2
    "anførelsestegn": "anførselstegn",  # 1
    "anseelig": "anselig",  # 2
    "antioxydant": "antioxidant",  # 1
    "artrig": "artsrig",  # 1
    "auditorium": "auditorie",  # 1
    "avocado": "avokado",  # 2
    "bagerst": "bagest",  # 2
    "bagstræv": "bagstræb",  # 1
    "bagstræver": "bagstræber",  # 1
    "bagstræverisk": "bagstræberisk",  # 1
    "balde": "balle",  # 2
    "barselorlov": "barselsorlov",  # 1
    "barselvikar": "barselsvikar",  # 1
    "baskien": "baskerlandet",  # 1
    "bayrisk": "bayersk",  # 1
    "bedstefader": "bedstefar",  # 1
    "bedstemoder": "bedstemor",  # 1
    "behefte": "behæfte",  # 1
    "beheftelse": "behæftelse",  # 1
    "bidragydende": "bidragsydende",  # 1
    "bidragyder": "bidragsyder",  # 1
    "billiondel": "billiontedel",  # 1
    "blaseret": "blasert",  # 1
    "bleskifte": "bleskift",  # 1
    "blodbroder": "blodsbroder",  # 2
    "blyantspidser": "blyantsspidser",  # 2
    "boligministerium": "boligministerie",  # 1
    "borhul": "borehul",  # 1
    "broder": "bror",  # 2
    "buldog": "bulldog",  # 2
    "bådhus": "bådehus",  # 1
    "børnepleje": "barnepleje",  # 1
    "børneseng": "barneseng",  # 1
    "børnestol": "barnestol",  # 1
    "cairo": "kairo",  # 1
    "cambodia": "cambodja",  # 1
    "cambodianer": "cambodjaner",  # 1
    "cambodiansk": "cambodjansk",  # 1
    "camouflage": "kamuflage",  # 2
    "campylobacter": "kampylobakter",  # 1
    "centeret": "centret",  # 2
    "chefskahyt": "chefkahyt",  # 1
    "chefspost": "chefpost",  # 1
    "chefssekretær": "chefsekretær",  # 1
    "chefsstol": "chefstol",  # 1
    "cirkulærskrivelse": "cirkulæreskrivelse",  # 1
    "cognacsglas": "cognacglas",  # 1
    "columnist": "kolumnist",  # 1
    "cricket": "kricket",  # 2
    "dagplejemoder": "dagplejemor",  # 1
    "damaskesdug": "damaskdug",  # 1
    "damp-barn": "dampbarn",  # 1
    "delfinarium": "delfinarie",  # 1
    "dentallaboratorium": "dentallaboratorie",  # 1
    "diaramme": "diasramme",  # 1
    "diaré": "diarré",  # 1
    "dioxyd": "dioxid",  # 1
    "dommedagsprædiken": "dommedagspræken",  # 1
    "donut": "doughnut",  # 2
    "driftmæssig": "driftsmæssig",  # 1
    "driftsikker": "driftssikker",  # 1
    "driftsikring": "driftssikring",  # 1
    "drikkejogurt": "drikkeyoghurt",  # 1
    "drivein": "drive-in",  # 1
    "driveinbiograf": "drive-in-biograf",  # 1
    "drøvel": "drøbel",  # 1
    "dødskriterium": "dødskriterie",  # 1
    "e-mail-adresse": "e-mailadresse",  # 1
    "e-post-adresse": "e-postadresse",  # 1
    "egypten": "ægypten",  # 2
    "ekskommunicere": "ekskommunikere",  # 1
    "eksperimentarium": "eksperimentarie",  # 1
    "elsass": "Alsace",  # 1
    "elsasser": "alsacer",  # 1
    "elsassisk": "alsacisk",  # 1
    "elvetal": "ellevetal",  # 1
    "elvetiden": "ellevetiden",  # 1
    "elveårig": "elleveårig",  # 1
    "elveårs": "elleveårs",  # 1
    "elveårsbarn": "elleveårsbarn",  # 1
    "elvte": "ellevte",  # 1
    "elvtedel": "ellevtedel",  # 1
    "energiministerium": "energiministerie",  # 1
    "erhvervsministerium": "erhvervsministerie",  # 1
    "espaliere": "spaliere",  # 2
    "evangelium": "evangelie",  # 1
    "fagministerium": "fagministerie",  # 1
    "fakse": "faxe",  # 1
    "fangstkvota": "fangstkvote",  # 1
    "fader": "far",  # 2
    "farbroder": "farbror",  # 1
    "farfader": "farfar",  # 1
    "farmoder": "farmor",  # 1
    "federal": "føderal",  # 1
    "federalisering": "føderalisering",  # 1
    "federalisme": "føderalisme",  # 1
    "federalist": "føderalist",  # 1
    "federalistisk": "føderalistisk",  # 1
    "federation": "føderation",  # 1
    "federativ": "føderativ",  # 1
    "fejlbeheftet": "fejlbehæftet",  # 1
    "femetagers": "femetages",  # 2
    "femhundredekroneseddel": "femhundredkroneseddel",  # 2
    "filmpremiere": "filmpræmiere",  # 2
    "finansimperium": "finansimperie",  # 1
    "finansministerium": "finansministerie",  # 1
    "firehjulstræk": "firhjulstræk",  # 2
    "fjernstudium": "fjernstudie",  # 1
    "formalier": "formalia",  # 1
    "formandsskift": "formandsskifte",  # 1
    "fornemst": "fornemmest",  # 2
    "fornuftparti": "fornuftsparti",  # 1
    "fornuftstridig": "fornuftsstridig",  # 1
    "fornuftvæsen": "fornuftsvæsen",  # 1
    "fornuftægteskab": "fornuftsægteskab",  # 1
    "forretningsministerium": "forretningsministerie",  # 1
    "forskningsministerium": "forskningsministerie",  # 1
    "forstudium": "forstudie",  # 1
    "forsvarsministerium": "forsvarsministerie",  # 1
    "frilægge": "fritlægge",  # 1
    "frilæggelse": "fritlæggelse",  # 1
    "frilægning": "fritlægning",  # 1
    "fristille": "fritstille",  # 1
    "fristilling": "fritstilling",  # 1
    "fuldttegnet": "fuldtegnet",  # 1
    "fødestedskriterium": "fødestedskriterie",  # 1
    "fødevareministerium": "fødevareministerie",  # 1
    "følesløs": "følelsesløs",  # 1
    "følgeligt": "følgelig",  # 1
    "førne": "førn",  # 1
    "gearskift": "gearskifte",  # 2
    "gladeligt": "gladelig",  # 1
    "glosehefte": "glosehæfte",  # 1
    "glædeløs": "glædesløs",  # 1
    "gonoré": "gonorré",  # 1
    "grangiveligt": "grangivelig",  # 1
    "grundliggende": "grundlæggende",  # 2
    "grønsag": "grøntsag",  # 2
    "gudbenådet": "gudsbenådet",  # 1
    "gudfader": "gudfar",  # 1
    "gudmoder": "gudmor",  # 1
    "gulvmop": "gulvmoppe",  # 1
    "gymnasium": "gymnasie",  # 1
    "hackning": "hacking",  # 1
    "halvbroder": "halvbror",  # 1
    "halvelvetiden": "halvellevetiden",  # 1
    "handelsgymnasium": "handelsgymnasie",  # 1
    "hefte": "hæfte",  # 1
    "hefteklamme": "hæfteklamme",  # 1
    "heftelse": "hæftelse",  # 1
    "heftemaskine": "hæftemaskine",  # 1
    "heftepistol": "hæftepistol",  # 1
    "hefteplaster": "hæfteplaster",  # 1
    "heftestraf": "hæftestraf",  # 1
    "heftning": "hæftning",  # 1
    "helbroder": "helbror",  # 1
    "hjemmeklasse": "hjemklasse",  # 1
    "hjulspin": "hjulspind",  # 1
    "huggevåben": "hugvåben",  # 1
    "hulmurisolering": "hulmursisolering",  # 1
    "hurtiggående": "hurtigtgående",  # 2
    "hurtigttørrende": "hurtigtørrende",  # 2
    "husmoder": "husmor",  # 1
    "hydroxyd": "hydroxid",  # 1
    "håndmikser": "håndmixer",  # 1
    "højtaler": "højttaler",  # 2
    "hønemoder": "hønemor",  # 1
    "ide": "idé",  # 2
    "imperium": "imperie",  # 1
    "imponerthed": "imponerethed",  # 1
    "inbox": "indboks",  # 2
    "indenrigsministerium": "indenrigsministerie",  # 1
    "indhefte": "indhæfte",  # 1
    "indheftning": "indhæftning",  # 1
    "indicium": "indicie",  # 1
    "indkassere": "inkassere",  # 2
    "iota": "jota",  # 1
    "jobskift": "jobskifte",  # 1
    "jogurt": "yoghurt",  # 1
    "jukeboks": "jukebox",  # 1
    "justitsministerium": "justitsministerie",  # 1
    "kalorifere": "kalorifer",  # 1
    "kandidatstipendium": "kandidatstipendie",  # 1
    "kannevas": "kanvas",  # 1
    "kaperssauce": "kaperssovs",  # 1
    "kigge": "kikke",  # 2
    "kirkeministerium": "kirkeministerie",  # 1
    "klapmydse": "klapmyds",  # 1
    "klimakterium": "klimakterie",  # 1
    "klogeligt": "klogelig",  # 1
    "knivblad": "knivsblad",  # 1
    "kollegaer": "kolleger",  # 2
    "kollegium": "kollegie",  # 1
    "kollegiehefte": "kollegiehæfte",  # 1
    "kollokviumx": "kollokvium",  # 1
    "kommissorium": "kommissorie",  # 1
    "kompendium": "kompendie",  # 1
    "komplicerthed": "komplicerethed",  # 1
    "konfederation": "konføderation",  # 1
    "konfedereret": "konfødereret",  # 1
    "konferensstudium": "konferensstudie",  # 1
    "konservatorium": "konservatorie",  # 1
    "konsulere": "konsultere",  # 1
    "kradsbørstig": "krasbørstig",  # 2
    "kravsspecifikation": "kravspecifikation",  # 1
    "krematorium": "krematorie",  # 1
    "krep": "crepe",  # 1
    "krepnylon": "crepenylon",  # 1
    "kreppapir": "crepepapir",  # 1
    "kricket": "cricket",  # 2
    "kriterium": "kriterie",  # 1
    "kroat": "kroater",  # 2
    "kroki": "croquis",  # 1
    "kronprinsepar": "kronprinspar",  # 2
    "kropdoven": "kropsdoven",  # 1
    "kroplus": "kropslus",  # 1
    "krøllefedt": "krølfedt",  # 1
    "kulturministerium": "kulturministerie",  # 1
    "kuponhefte": "kuponhæfte",  # 1
    "kvota": "kvote",  # 1
    "kvotaordning": "kvoteordning",  # 1
    "laboratorium": "laboratorie",  # 1
    "laksfarve": "laksefarve",  # 1
    "laksfarvet": "laksefarvet",  # 1
    "laksrød": "lakserød",  # 1
    "laksyngel": "lakseyngel",  # 1
    "laksørred": "lakseørred",  # 1
    "landbrugsministerium": "landbrugsministerie",  # 1
    "landskampstemning": "landskampsstemning",  # 1
    "langust": "languster",  # 1
    "lappegrejer": "lappegrej",  # 1
    "lavløn": "lavtløn",  # 1
    "lillebroder": "lillebror",  # 1
    "linear": "lineær",  # 1
    "loftlampe": "loftslampe",  # 2
    "log-in": "login",  # 1
    "login": "log-in",  # 2
    "lovmedholdig": "lovmedholdelig",  # 1
    "ludder": "luder",  # 2
    "lysholder": "lyseholder",  # 1
    "lægeskifte": "lægeskift",  # 1
    "lærvillig": "lærevillig",  # 1
    "løgsauce": "løgsovs",  # 1
    "madmoder": "madmor",  # 1
    "majonæse": "mayonnaise",  # 1
    "mareridtagtig": "mareridtsagtig",  # 1
    "margen": "margin",  # 2
    "martyrium": "martyrie",  # 1
    "mellemstatlig": "mellemstatslig",  # 1
    "menneskene": "menneskerne",  # 2
    "metropolis": "metropol",  # 1
    "miks": "mix",  # 1
    "mikse": "mixe",  # 1
    "miksepult": "mixerpult",  # 1
    "mikser": "mixer",  # 1
    "mikserpult": "mixerpult",  # 1
    "mikslån": "mixlån",  # 1
    "miksning": "mixning",  # 1
    "miljøministerium": "miljøministerie",  # 1
    "milliarddel": "milliardtedel",  # 1
    "milliondel": "milliontedel",  # 1
    "ministerium": "ministerie",  # 1
    "mop": "moppe",  # 1
    "moder": "mor",  # 2
    "moratorium": "moratorie",  # 1
    "morbroder": "morbror",  # 1
    "morfader": "morfar",  # 1
    "mormoder": "mormor",  # 1
    "musikkonservatorium": "musikkonservatorie",  # 1
    "muslingskal": "muslingeskal",  # 1
    "mysterium": "mysterie",  # 1
    "naturalieydelse": "naturalydelse",  # 1
    "naturalieøkonomi": "naturaløkonomi",  # 1
    "navnebroder": "navnebror",  # 1
    "nerium": "nerie",  # 1
    "nådeløs": "nådesløs",  # 1
    "nærforestående": "nærtforestående",  # 1
    "nærstående": "nærtstående",  # 1
    "observatorium": "observatorie",  # 1
    "oldefader": "oldefar",  # 1
    "oldemoder": "oldemor",  # 1
    "opgraduere": "opgradere",  # 1
    "opgraduering": "opgradering",  # 1
    "oratorium": "oratorie",  # 1
    "overbookning": "overbooking",  # 1
    "overpræsidium": "overpræsidie",  # 1
    "overstatlig": "overstatslig",  # 1
    "oxyd": "oxid",  # 1
    "oxydere": "oxidere",  # 1
    "oxydering": "oxidering",  # 1
    "pakkenellike": "pakkenelliker",  # 1
    "papirtynd": "papirstynd",  # 1
    "pastoralseminarium": "pastoralseminarie",  # 1
    "peanutsene": "peanuttene",  # 2
    "penalhus": "pennalhus",  # 2
    "pensakrav": "pensumkrav",  # 1
    "pepperoni": "peperoni",  # 1
    "peruaner": "peruvianer",  # 1
    "petrole": "petrol",  # 1
    "piltast": "piletast",  # 1
    "piltaste": "piletast",  # 1
    "planetarium": "planetarie",  # 1
    "plasteret": "plastret",  # 2
    "plastic": "plastik",  # 2
    "play-off-kamp": "playoffkamp",  # 1
    "plejefader": "plejefar",  # 1
    "plejemoder": "plejemor",  # 1
    "podium": "podie",  # 2
    "praha": "prag",  # 2
    "preciøs": "pretiøs",  # 2
    "privilegium": "privilegie",  # 1
    "progredere": "progrediere",  # 1
    "præsidium": "præsidie",  # 1
    "psykodelisk": "psykedelisk",  # 1
    "pudsegrejer": "pudsegrej",  # 1
    "referensgruppe": "referencegruppe",  # 1
    "referensramme": "referenceramme",  # 1
    "refugium": "refugie",  # 1
    "registeret": "registret",  # 2
    "remedium": "remedie",  # 1
    "remiks": "remix",  # 1
    "reservert": "reserveret",  # 1
    "ressortministerium": "ressortministerie",  # 1
    "ressource": "resurse",  # 2
    "resætte": "resette",  # 1
    "rettelig": "retteligt",  # 1
    "rettetaste": "rettetast",  # 1
    "returtaste": "returtast",  # 1
    "risici": "risikoer",  # 2
    "roll-on": "rollon",  # 1
    "rollehefte": "rollehæfte",  # 1
    "rostbøf": "roastbeef",  # 1
    "rygsæksturist": "rygsækturist",  # 1
    "rødstjært": "rødstjert",  # 1
    "saddel": "sadel",  # 2
    "samaritan": "samaritaner",  # 2
    "sanatorium": "sanatorie",  # 1
    "sauce": "sovs",  # 1
    "scanning": "skanning",  # 2
    "sceneskifte": "sceneskift",  # 1
    "scilla": "skilla",  # 1
    "sejflydende": "sejtflydende",  # 1
    "selvstudium": "selvstudie",  # 1
    "seminarium": "seminarie",  # 1
    "sennepssauce": "sennepssovs ",  # 1
    "servitutbeheftet": "servitutbehæftet",  # 1
    "sit-in": "sitin",  # 1
    "skatteministerium": "skatteministerie",  # 1
    "skifer": "skiffer",  # 2
    "skyldsfølelse": "skyldfølelse",  # 1
    "skysauce": "skysovs",  # 1
    "sladdertaske": "sladretaske",  # 2
    "sladdervorn": "sladrevorn",  # 2
    "slagsbroder": "slagsbror",  # 1
    "slettetaste": "slettetast",  # 1
    "smørsauce": "smørsovs",  # 1
    "snitsel": "schnitzel",  # 1
    "snobbeeffekt": "snobeffekt",  # 2
    "socialministerium": "socialministerie",  # 1
    "solarium": "solarie",  # 1
    "soldebroder": "soldebror",  # 1
    "spagetti": "spaghetti",  # 1
    "spagettistrop": "spaghettistrop",  # 1
    "spagettiwestern": "spaghettiwestern",  # 1
    "spin-off": "spinoff",  # 1
    "spinnefiskeri": "spindefiskeri",  # 1
    "spolorm": "spoleorm",  # 1
    "sproglaboratorium": "sproglaboratorie",  # 1
    "spækbræt": "spækkebræt",  # 2
    "stand-in": "standin",  # 1
    "stand-up-comedy": "standupcomedy",  # 1
    "stand-up-komiker": "standupkomiker",  # 1
    "statsministerium": "statsministerie",  # 1
    "stedbroder": "stedbror",  # 1
    "stedfader": "stedfar",  # 1
    "stedmoder": "stedmor",  # 1
    "stilehefte": "stilehæfte",  # 1
    "stipendium": "stipendie",  # 1
    "stjært": "stjert",  # 1
    "stjærthage": "stjerthage",  # 1
    "storebroder": "storebror",  # 1
    "stortå": "storetå",  # 1
    "strabads": "strabadser",  # 1
    "strømlinjet": "strømlinet",  # 1
    "studium": "studie",  # 1
    "stænkelap": "stænklap",  # 1
    "sundhedsministerium": "sundhedsministerie",  # 1
    "suppositorium": "suppositorie",  # 1
    "svejts": "schweiz",  # 1
    "svejtser": "schweizer",  # 1
    "svejtserfranc": "schweizerfranc",  # 1
    "svejtserost": "schweizerost",  # 1
    "svejtsisk": "schweizisk",  # 1
    "svigerfader": "svigerfar",  # 1
    "svigermoder": "svigermor",  # 1
    "svirebroder": "svirebror",  # 1
    "symposium": "symposie",  # 1
    "sælarium": "sælarie",  # 1
    "søreme": "sørme",  # 2
    "søterritorium": "søterritorie",  # 1
    "t-bone-steak": "t-bonesteak",  # 1
    "tabgivende": "tabsgivende",  # 1
    "tabuere": "tabuisere",  # 1
    "tabuering": "tabuisering",  # 1
    "tackle": "takle",  # 2
    "tackling": "takling",  # 2
    "taifun": "tyfon",  # 1
    "take-off": "takeoff",  # 1
    "taknemlig": "taknemmelig",  # 2
    "talehørelærer": "tale-høre-lærer",  # 1
    "talehøreundervisning": "tale-høre-undervisning",  # 1
    "tandstik": "tandstikker",  # 1
    "tao": "dao",  # 1
    "taoisme": "daoisme",  # 1
    "taoist": "daoist",  # 1
    "taoistisk": "daoistisk",  # 1
    "taverne": "taverna",  # 1
    "teateret": "teatret",  # 2
    "tekno": "techno",  # 1
    "temposkifte": "temposkift",  # 1
    "terrarium": "terrarie",  # 1
    "territorium": "territorie",  # 1
    "tesis": "tese",  # 1
    "tidsstudium": "tidsstudie",  # 1
    "tipoldefader": "tipoldefar",  # 1
    "tipoldemoder": "tipoldemor",  # 1
    "tomatsauce": "tomatsovs",  # 1
    "tonart": "toneart",  # 1
    "trafikministerium": "trafikministerie",  # 1
    "tredve": "tredive",  # 1
    "tredver": "trediver",  # 1
    "tredveårig": "trediveårig",  # 1
    "tredveårs": "trediveårs",  # 1
    "tredveårsfødselsdag": "trediveårsfødselsdag",  # 1
    "tredvte": "tredivte",  # 1
    "tredvtedel": "tredivtedel",  # 1
    "troldunge": "troldeunge",  # 1
    "trommestikke": "trommestik",  # 1
    "trubadur": "troubadour",  # 2
    "trøstepræmie": "trøstpræmie",  # 2
    "tummerum": "trummerum",  # 1
    "tumultuarisk": "tumultarisk",  # 1
    "tunghørighed": "tunghørhed",  # 1
    "tus": "tusch",  # 2
    "tusind": "tusinde",  # 2
    "tvillingbroder": "tvillingebror",  # 1
    "tvillingbror": "tvillingebror",  # 1
    "tvillingebroder": "tvillingebror",  # 1
    "ubeheftet": "ubehæftet",  # 1
    "udenrigsministerium": "udenrigsministerie",  # 1
    "udhulning": "udhuling",  # 1
    "udslaggivende": "udslagsgivende",  # 1
    "udspekulert": "udspekuleret",  # 1
    "udviklingsministerium": "udviklingsministerie",  # 1
    "uforpligtigende": "uforpligtende",  # 1
    "uheldvarslende": "uheldsvarslende",  # 1
    "uimponerthed": "uimponerethed",  # 1
    "undervisningsministerium": "undervisningsministerie",  # 1
    "unægtelig": "unægteligt",  # 1
    "urinale": "urinal",  # 1
    "uvederheftig": "uvederhæftig",  # 1
    "vabel": "vable",  # 2
    "vadi": "wadi",  # 1
    "vaklevorn": "vakkelvorn",  # 1
    "vanadin": "vanadium",  # 1
    "vaselin": "vaseline",  # 1
    "vederheftig": "vederhæftig",  # 1
    "vedhefte": "vedhæfte",  # 1
    "velar": "velær",  # 1
    "videndeling": "vidensdeling",  # 2
    "vinkelanførelsestegn": "vinkelanførselstegn",  # 1
    "vipstjært": "vipstjert",  # 1
    "vismut": "bismut",  # 1
    "visvas": "vissevasse",  # 1
    "voksværk": "vokseværk",  # 1
    "værtdyr": "værtsdyr",  # 1
    "værtplante": "værtsplante",  # 1
    "wienersnitsel": "wienerschnitzel",  # 1
    "yderliggående": "yderligtgående",  # 2
    "zombi": "zombie",  # 1
    "ægbakke": "æggebakke",  # 1
    "ægformet": "æggeformet",  # 1
    "ægleder": "æggeleder",  # 1
    "ækvilibrist": "ekvilibrist",  # 2
    "æselsøre": "æseløre",  # 1
    "øjehule": "øjenhule",  # 1
    "øjelåg": "øjenlåg",  # 1
    "øjeåbner": "øjenåbner",  # 1
    "økonomiministerium": "økonomiministerie",  # 1
    "ørenring": "ørering",  # 2
    "øvehefte": "øvehæfte"  # 1
}


NORM_EXCEPTIONS = {}

for string, norm in _exc.items():
    NORM_EXCEPTIONS[string] = norm
    NORM_EXCEPTIONS[string.title()] = norm
